/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_TYPES_H
#define VN_PROTOCOL_DRIVER_TYPES_H

#include "vn_protocol_driver_cs.h"
#include "vn_protocol_driver_defines.h"

/* uint64_t */

static inline size_t
vn_sizeof_uint64_t(const uint64_t *val)
{
    assert(sizeof(*val) == 8);
    return 8;
}

static inline void
vn_encode_uint64_t(struct vn_cs_encoder *enc, const uint64_t *val)
{
    vn_encode(enc, 8, val, sizeof(*val));
}

static inline void
vn_decode_uint64_t(struct vn_cs_decoder *dec, uint64_t *val)
{
    vn_decode(dec, 8, val, sizeof(*val));
}

static inline size_t
vn_sizeof_uint64_t_array(const uint64_t *val, uint32_t count)
{
    assert(sizeof(*val) == 8);
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    return size;
}

static inline void
vn_encode_uint64_t_array(struct vn_cs_encoder *enc, const uint64_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_encode(enc, size, val, size);
}

static inline void
vn_decode_uint64_t_array(struct vn_cs_decoder *dec, uint64_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_decode(dec, size, val, size);
}

/* int32_t */

static inline size_t
vn_sizeof_int32_t(const int32_t *val)
{
    assert(sizeof(*val) == 4);
    return 4;
}

static inline void
vn_encode_int32_t(struct vn_cs_encoder *enc, const int32_t *val)
{
    vn_encode(enc, 4, val, sizeof(*val));
}

static inline void
vn_decode_int32_t(struct vn_cs_decoder *dec, int32_t *val)
{
    vn_decode(dec, 4, val, sizeof(*val));
}

static inline size_t
vn_sizeof_int32_t_array(const int32_t *val, uint32_t count)
{
    assert(sizeof(*val) == 4);
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    return size;
}

static inline void
vn_encode_int32_t_array(struct vn_cs_encoder *enc, const int32_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_encode(enc, size, val, size);
}

static inline void
vn_decode_int32_t_array(struct vn_cs_decoder *dec, int32_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_decode(dec, size, val, size);
}

/* enum VkStructureType */

static inline size_t
vn_sizeof_VkStructureType(const VkStructureType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkStructureType(struct vn_cs_encoder *enc, const VkStructureType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkStructureType(struct vn_cs_decoder *dec, VkStructureType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* size_t */

static inline size_t
vn_sizeof_size_t(const size_t *val)
{
    return vn_sizeof_uint64_t(&(uint64_t){ *val });
}

static inline void
vn_encode_size_t(struct vn_cs_encoder *enc, const size_t *val)
{
    const uint64_t tmp = *val;
    vn_encode_uint64_t(enc, &tmp);
}

static inline void
vn_decode_size_t(struct vn_cs_decoder *dec, size_t *val)
{
    uint64_t tmp;
    vn_decode_uint64_t(dec, &tmp);
    *val = tmp;
}

static inline size_t
vn_sizeof_size_t_array(const size_t *val, uint32_t count)
{
    return vn_sizeof_size_t(val) * count;
}

static inline void
vn_encode_size_t_array(struct vn_cs_encoder *enc, const size_t *val, uint32_t count)
{
    if (sizeof(size_t) == sizeof(uint64_t)) {
        vn_encode_uint64_t_array(enc, (const uint64_t *)val, count);
    } else {
        for (uint32_t i = 0; i < count; i++)
            vn_encode_size_t(enc, &val[i]);
    }
}

static inline void
vn_decode_size_t_array(struct vn_cs_decoder *dec, size_t *val, uint32_t count)
{
    if (sizeof(size_t) == sizeof(uint64_t)) {
        vn_decode_uint64_t_array(dec, (uint64_t *)val, count);
    } else {
        for (uint32_t i = 0; i < count; i++)
            vn_decode_size_t(dec, &val[i]);
    }
}

/* opaque blob */

static inline size_t
vn_sizeof_blob_array(const void *val, size_t size)
{
    return (size + 3) & ~3;
}

static inline void
vn_encode_blob_array(struct vn_cs_encoder *enc, const void *val, size_t size)
{
    vn_encode(enc, (size + 3) & ~3, val, size);
}

static inline void
vn_decode_blob_array(struct vn_cs_decoder *dec, void *val, size_t size)
{
    vn_decode(dec, (size + 3) & ~3, val, size);
}

/* string */

static inline size_t
vn_sizeof_char_array(const char *val, size_t size)
{
    return vn_sizeof_blob_array(val, size);
}

static inline void
vn_encode_char_array(struct vn_cs_encoder *enc, const char *val, size_t size)
{
    assert(size && strlen(val) < size);
    vn_encode_blob_array(enc, val, size);
}

static inline void
vn_decode_char_array(struct vn_cs_decoder *dec, char *val, size_t size)
{
    vn_decode_blob_array(dec, val, size);
    if (size)
        val[size - 1] = '\0';
    else
        vn_cs_decoder_set_fatal(dec);
}

/* array size (uint64_t) */

static inline size_t
vn_sizeof_array_size(uint64_t size)
{
    return vn_sizeof_uint64_t(&size);
}

static inline void
vn_encode_array_size(struct vn_cs_encoder *enc, uint64_t size)
{
    vn_encode_uint64_t(enc, &size);
}

static inline uint64_t
vn_decode_array_size(struct vn_cs_decoder *dec, uint64_t expected_size)
{
    uint64_t size;
    vn_decode_uint64_t(dec, &size);
    if (size != expected_size) {
        vn_cs_decoder_set_fatal(dec);
        size = 0;
    }
    return size;
}

static inline uint64_t
vn_decode_array_size_unchecked(struct vn_cs_decoder *dec)
{
    uint64_t size;
    vn_decode_uint64_t(dec, &size);
    return size;
}

static inline uint64_t
vn_peek_array_size(struct vn_cs_decoder *dec)
{
    uint64_t size;
    vn_cs_decoder_peek(dec, sizeof(size), &size, sizeof(size));
    return size;
}

/* non-array pointer */

static inline size_t
vn_sizeof_simple_pointer(const void *val)
{
    return vn_sizeof_array_size(val ? 1 : 0);
}

static inline bool
vn_encode_simple_pointer(struct vn_cs_encoder *enc, const void *val)
{
    vn_encode_array_size(enc, val ? 1 : 0);
    return val;
}

static inline bool
vn_decode_simple_pointer(struct vn_cs_decoder *dec)
{
    return vn_decode_array_size_unchecked(dec);
}

/* uint32_t */

static inline size_t
vn_sizeof_uint32_t(const uint32_t *val)
{
    assert(sizeof(*val) == 4);
    return 4;
}

static inline void
vn_encode_uint32_t(struct vn_cs_encoder *enc, const uint32_t *val)
{
    vn_encode(enc, 4, val, sizeof(*val));
}

static inline void
vn_decode_uint32_t(struct vn_cs_decoder *dec, uint32_t *val)
{
    vn_decode(dec, 4, val, sizeof(*val));
}

static inline size_t
vn_sizeof_uint32_t_array(const uint32_t *val, uint32_t count)
{
    assert(sizeof(*val) == 4);
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    return size;
}

static inline void
vn_encode_uint32_t_array(struct vn_cs_encoder *enc, const uint32_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_encode(enc, size, val, size);
}

static inline void
vn_decode_uint32_t_array(struct vn_cs_decoder *dec, uint32_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_decode(dec, size, val, size);
}

/* float */

static inline size_t
vn_sizeof_float(const float *val)
{
    assert(sizeof(*val) == 4);
    return 4;
}

static inline void
vn_encode_float(struct vn_cs_encoder *enc, const float *val)
{
    vn_encode(enc, 4, val, sizeof(*val));
}

static inline void
vn_decode_float(struct vn_cs_decoder *dec, float *val)
{
    vn_decode(dec, 4, val, sizeof(*val));
}

static inline size_t
vn_sizeof_float_array(const float *val, uint32_t count)
{
    assert(sizeof(*val) == 4);
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    return size;
}

static inline void
vn_encode_float_array(struct vn_cs_encoder *enc, const float *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_encode(enc, size, val, size);
}

static inline void
vn_decode_float_array(struct vn_cs_decoder *dec, float *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_decode(dec, size, val, size);
}

/* uint8_t */

static inline size_t
vn_sizeof_uint8_t(const uint8_t *val)
{
    assert(sizeof(*val) == 1);
    return 4;
}

static inline void
vn_encode_uint8_t(struct vn_cs_encoder *enc, const uint8_t *val)
{
    vn_encode(enc, 4, val, sizeof(*val));
}

static inline void
vn_decode_uint8_t(struct vn_cs_decoder *dec, uint8_t *val)
{
    vn_decode(dec, 4, val, sizeof(*val));
}

static inline size_t
vn_sizeof_uint8_t_array(const uint8_t *val, uint32_t count)
{
    assert(sizeof(*val) == 1);
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    return (size + 3) & ~3;
}

static inline void
vn_encode_uint8_t_array(struct vn_cs_encoder *enc, const uint8_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_encode(enc, (size + 3) & ~3, val, size);
}

static inline void
vn_decode_uint8_t_array(struct vn_cs_decoder *dec, uint8_t *val, uint32_t count)
{
    const size_t size = sizeof(*val) * count;
    assert(size >= count);
    vn_decode(dec, (size + 3) & ~3, val, size);
}

/* uint16_t */

static inline size_t
vn_sizeof_uint16_t(const uint16_t *val)
{
    assert(sizeof(*val) == 2);
    return 4;
}

static inline void
vn_encode_uint16_t(struct vn_cs_encoder *enc, const uint16_t *val)
{
    vn_encode(enc, 4, val, sizeof(*val));
}

static inline void
vn_decode_uint16_t(struct vn_cs_decoder *dec, uint16_t *val)
{
    vn_decode(dec, 4, val, sizeof(*val));
}

/* typedef uint32_t VkSampleMask */

static inline size_t
vn_sizeof_VkSampleMask(const VkSampleMask *val)
{
    return vn_sizeof_uint32_t(val);
}

static inline void
vn_encode_VkSampleMask(struct vn_cs_encoder *enc, const VkSampleMask *val)
{
    vn_encode_uint32_t(enc, val);
}

static inline void
vn_decode_VkSampleMask(struct vn_cs_decoder *dec, VkSampleMask *val)
{
    vn_decode_uint32_t(dec, val);
}

static inline size_t
vn_sizeof_VkSampleMask_array(const VkSampleMask *val, uint32_t count)
{
    return vn_sizeof_uint32_t_array(val, count);
}

static inline void
vn_encode_VkSampleMask_array(struct vn_cs_encoder *enc, const VkSampleMask *val, uint32_t count)
{
    vn_encode_uint32_t_array(enc, val, count);
}

static inline void
vn_decode_VkSampleMask_array(struct vn_cs_decoder *dec, VkSampleMask *val, uint32_t count)
{
    vn_decode_uint32_t_array(dec, val, count);
}

/* typedef uint32_t VkBool32 */

static inline size_t
vn_sizeof_VkBool32(const VkBool32 *val)
{
    return vn_sizeof_uint32_t(val);
}

static inline void
vn_encode_VkBool32(struct vn_cs_encoder *enc, const VkBool32 *val)
{
    vn_encode_uint32_t(enc, val);
}

static inline void
vn_decode_VkBool32(struct vn_cs_decoder *dec, VkBool32 *val)
{
    vn_decode_uint32_t(dec, val);
}

static inline size_t
vn_sizeof_VkBool32_array(const VkBool32 *val, uint32_t count)
{
    return vn_sizeof_uint32_t_array(val, count);
}

static inline void
vn_encode_VkBool32_array(struct vn_cs_encoder *enc, const VkBool32 *val, uint32_t count)
{
    vn_encode_uint32_t_array(enc, val, count);
}

static inline void
vn_decode_VkBool32_array(struct vn_cs_decoder *dec, VkBool32 *val, uint32_t count)
{
    vn_decode_uint32_t_array(dec, val, count);
}

/* typedef uint32_t VkFlags */

static inline size_t
vn_sizeof_VkFlags(const VkFlags *val)
{
    return vn_sizeof_uint32_t(val);
}

static inline void
vn_encode_VkFlags(struct vn_cs_encoder *enc, const VkFlags *val)
{
    vn_encode_uint32_t(enc, val);
}

static inline void
vn_decode_VkFlags(struct vn_cs_decoder *dec, VkFlags *val)
{
    vn_decode_uint32_t(dec, val);
}

static inline size_t
vn_sizeof_VkFlags_array(const VkFlags *val, uint32_t count)
{
    return vn_sizeof_uint32_t_array(val, count);
}

static inline void
vn_encode_VkFlags_array(struct vn_cs_encoder *enc, const VkFlags *val, uint32_t count)
{
    vn_encode_uint32_t_array(enc, val, count);
}

static inline void
vn_decode_VkFlags_array(struct vn_cs_decoder *dec, VkFlags *val, uint32_t count)
{
    vn_decode_uint32_t_array(dec, val, count);
}

/* typedef uint64_t VkFlags64 */

static inline size_t
vn_sizeof_VkFlags64(const VkFlags64 *val)
{
    return vn_sizeof_uint64_t(val);
}

static inline void
vn_encode_VkFlags64(struct vn_cs_encoder *enc, const VkFlags64 *val)
{
    vn_encode_uint64_t(enc, val);
}

static inline void
vn_decode_VkFlags64(struct vn_cs_decoder *dec, VkFlags64 *val)
{
    vn_decode_uint64_t(dec, val);
}

/* typedef uint64_t VkDeviceSize */

static inline size_t
vn_sizeof_VkDeviceSize(const VkDeviceSize *val)
{
    return vn_sizeof_uint64_t(val);
}

static inline void
vn_encode_VkDeviceSize(struct vn_cs_encoder *enc, const VkDeviceSize *val)
{
    vn_encode_uint64_t(enc, val);
}

static inline void
vn_decode_VkDeviceSize(struct vn_cs_decoder *dec, VkDeviceSize *val)
{
    vn_decode_uint64_t(dec, val);
}

static inline size_t
vn_sizeof_VkDeviceSize_array(const VkDeviceSize *val, uint32_t count)
{
    return vn_sizeof_uint64_t_array(val, count);
}

static inline void
vn_encode_VkDeviceSize_array(struct vn_cs_encoder *enc, const VkDeviceSize *val, uint32_t count)
{
    vn_encode_uint64_t_array(enc, val, count);
}

static inline void
vn_decode_VkDeviceSize_array(struct vn_cs_decoder *dec, VkDeviceSize *val, uint32_t count)
{
    vn_decode_uint64_t_array(dec, val, count);
}

/* typedef uint64_t VkDeviceAddress */

static inline size_t
vn_sizeof_VkDeviceAddress(const VkDeviceAddress *val)
{
    return vn_sizeof_uint64_t(val);
}

static inline void
vn_encode_VkDeviceAddress(struct vn_cs_encoder *enc, const VkDeviceAddress *val)
{
    vn_encode_uint64_t(enc, val);
}

static inline void
vn_decode_VkDeviceAddress(struct vn_cs_decoder *dec, VkDeviceAddress *val)
{
    vn_decode_uint64_t(dec, val);
}

static inline size_t
vn_sizeof_VkDeviceAddress_array(const VkDeviceAddress *val, uint32_t count)
{
    return vn_sizeof_uint64_t_array(val, count);
}

static inline void
vn_encode_VkDeviceAddress_array(struct vn_cs_encoder *enc, const VkDeviceAddress *val, uint32_t count)
{
    vn_encode_uint64_t_array(enc, val, count);
}

static inline void
vn_decode_VkDeviceAddress_array(struct vn_cs_decoder *dec, VkDeviceAddress *val, uint32_t count)
{
    vn_decode_uint64_t_array(dec, val, count);
}

/* enum VkFramebufferCreateFlagBits */

static inline size_t
vn_sizeof_VkFramebufferCreateFlagBits(const VkFramebufferCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFramebufferCreateFlagBits(struct vn_cs_encoder *enc, const VkFramebufferCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFramebufferCreateFlagBits(struct vn_cs_decoder *dec, VkFramebufferCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkRenderPassCreateFlagBits */

static inline size_t
vn_sizeof_VkRenderPassCreateFlagBits(const VkRenderPassCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkRenderPassCreateFlagBits(struct vn_cs_encoder *enc, const VkRenderPassCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkRenderPassCreateFlagBits(struct vn_cs_decoder *dec, VkRenderPassCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerCreateFlagBits */

static inline size_t
vn_sizeof_VkSamplerCreateFlagBits(const VkSamplerCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerCreateFlagBits(struct vn_cs_encoder *enc, const VkSamplerCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerCreateFlagBits(struct vn_cs_decoder *dec, VkSamplerCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineLayoutCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineLayoutCreateFlagBits(const VkPipelineLayoutCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineLayoutCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineLayoutCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineLayoutCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineLayoutCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineCacheCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineCacheCreateFlagBits(const VkPipelineCacheCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineCacheCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineCacheCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineCacheCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineCacheCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineDepthStencilStateCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineDepthStencilStateCreateFlagBits(const VkPipelineDepthStencilStateCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineDepthStencilStateCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineDepthStencilStateCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineDepthStencilStateCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineDepthStencilStateCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineColorBlendStateCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineColorBlendStateCreateFlagBits(const VkPipelineColorBlendStateCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineColorBlendStateCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineColorBlendStateCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineColorBlendStateCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineColorBlendStateCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineShaderStageCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineShaderStageCreateFlagBits(const VkPipelineShaderStageCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineShaderStageCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineShaderStageCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineShaderStageCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineShaderStageCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDescriptorSetLayoutCreateFlagBits */

static inline size_t
vn_sizeof_VkDescriptorSetLayoutCreateFlagBits(const VkDescriptorSetLayoutCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDescriptorSetLayoutCreateFlagBits(struct vn_cs_encoder *enc, const VkDescriptorSetLayoutCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDescriptorSetLayoutCreateFlagBits(struct vn_cs_decoder *dec, VkDescriptorSetLayoutCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkInstanceCreateFlagBits */

static inline size_t
vn_sizeof_VkInstanceCreateFlagBits(const VkInstanceCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkInstanceCreateFlagBits(struct vn_cs_encoder *enc, const VkInstanceCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkInstanceCreateFlagBits(struct vn_cs_decoder *dec, VkInstanceCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDeviceQueueCreateFlagBits */

static inline size_t
vn_sizeof_VkDeviceQueueCreateFlagBits(const VkDeviceQueueCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDeviceQueueCreateFlagBits(struct vn_cs_encoder *enc, const VkDeviceQueueCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDeviceQueueCreateFlagBits(struct vn_cs_decoder *dec, VkDeviceQueueCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueueFlagBits */

static inline size_t
vn_sizeof_VkQueueFlagBits(const VkQueueFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueueFlagBits(struct vn_cs_encoder *enc, const VkQueueFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueueFlagBits(struct vn_cs_decoder *dec, VkQueueFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkMemoryPropertyFlagBits */

static inline size_t
vn_sizeof_VkMemoryPropertyFlagBits(const VkMemoryPropertyFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkMemoryPropertyFlagBits(struct vn_cs_encoder *enc, const VkMemoryPropertyFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkMemoryPropertyFlagBits(struct vn_cs_decoder *dec, VkMemoryPropertyFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkMemoryHeapFlagBits */

static inline size_t
vn_sizeof_VkMemoryHeapFlagBits(const VkMemoryHeapFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkMemoryHeapFlagBits(struct vn_cs_encoder *enc, const VkMemoryHeapFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkMemoryHeapFlagBits(struct vn_cs_decoder *dec, VkMemoryHeapFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkAccessFlagBits */

static inline size_t
vn_sizeof_VkAccessFlagBits(const VkAccessFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkAccessFlagBits(struct vn_cs_encoder *enc, const VkAccessFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkAccessFlagBits(struct vn_cs_decoder *dec, VkAccessFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBufferUsageFlagBits */

static inline size_t
vn_sizeof_VkBufferUsageFlagBits(const VkBufferUsageFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBufferUsageFlagBits(struct vn_cs_encoder *enc, const VkBufferUsageFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBufferUsageFlagBits(struct vn_cs_decoder *dec, VkBufferUsageFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBufferCreateFlagBits */

static inline size_t
vn_sizeof_VkBufferCreateFlagBits(const VkBufferCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBufferCreateFlagBits(struct vn_cs_encoder *enc, const VkBufferCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBufferCreateFlagBits(struct vn_cs_decoder *dec, VkBufferCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkShaderStageFlagBits */

static inline size_t
vn_sizeof_VkShaderStageFlagBits(const VkShaderStageFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkShaderStageFlagBits(struct vn_cs_encoder *enc, const VkShaderStageFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkShaderStageFlagBits(struct vn_cs_decoder *dec, VkShaderStageFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkShaderStageFlagBits_array(const VkShaderStageFlagBits *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkShaderStageFlagBits_array(struct vn_cs_encoder *enc, const VkShaderStageFlagBits *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkShaderStageFlagBits_array(struct vn_cs_decoder *dec, VkShaderStageFlagBits *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkImageUsageFlagBits */

static inline size_t
vn_sizeof_VkImageUsageFlagBits(const VkImageUsageFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageUsageFlagBits(struct vn_cs_encoder *enc, const VkImageUsageFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageUsageFlagBits(struct vn_cs_decoder *dec, VkImageUsageFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageCreateFlagBits */

static inline size_t
vn_sizeof_VkImageCreateFlagBits(const VkImageCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageCreateFlagBits(struct vn_cs_encoder *enc, const VkImageCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageCreateFlagBits(struct vn_cs_decoder *dec, VkImageCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageViewCreateFlagBits */

static inline size_t
vn_sizeof_VkImageViewCreateFlagBits(const VkImageViewCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageViewCreateFlagBits(struct vn_cs_encoder *enc, const VkImageViewCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageViewCreateFlagBits(struct vn_cs_decoder *dec, VkImageViewCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineCreateFlagBits */

static inline size_t
vn_sizeof_VkPipelineCreateFlagBits(const VkPipelineCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineCreateFlagBits(struct vn_cs_encoder *enc, const VkPipelineCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineCreateFlagBits(struct vn_cs_decoder *dec, VkPipelineCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkColorComponentFlagBits */

static inline size_t
vn_sizeof_VkColorComponentFlagBits(const VkColorComponentFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkColorComponentFlagBits(struct vn_cs_encoder *enc, const VkColorComponentFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkColorComponentFlagBits(struct vn_cs_decoder *dec, VkColorComponentFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFenceCreateFlagBits */

static inline size_t
vn_sizeof_VkFenceCreateFlagBits(const VkFenceCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFenceCreateFlagBits(struct vn_cs_encoder *enc, const VkFenceCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFenceCreateFlagBits(struct vn_cs_decoder *dec, VkFenceCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFormatFeatureFlagBits */

static inline size_t
vn_sizeof_VkFormatFeatureFlagBits(const VkFormatFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFormatFeatureFlagBits(struct vn_cs_encoder *enc, const VkFormatFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFormatFeatureFlagBits(struct vn_cs_decoder *dec, VkFormatFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueryControlFlagBits */

static inline size_t
vn_sizeof_VkQueryControlFlagBits(const VkQueryControlFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueryControlFlagBits(struct vn_cs_encoder *enc, const VkQueryControlFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueryControlFlagBits(struct vn_cs_decoder *dec, VkQueryControlFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueryResultFlagBits */

static inline size_t
vn_sizeof_VkQueryResultFlagBits(const VkQueryResultFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueryResultFlagBits(struct vn_cs_encoder *enc, const VkQueryResultFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueryResultFlagBits(struct vn_cs_decoder *dec, VkQueryResultFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkEventCreateFlagBits */

static inline size_t
vn_sizeof_VkEventCreateFlagBits(const VkEventCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkEventCreateFlagBits(struct vn_cs_encoder *enc, const VkEventCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkEventCreateFlagBits(struct vn_cs_decoder *dec, VkEventCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandPoolCreateFlagBits */

static inline size_t
vn_sizeof_VkCommandPoolCreateFlagBits(const VkCommandPoolCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandPoolCreateFlagBits(struct vn_cs_encoder *enc, const VkCommandPoolCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandPoolCreateFlagBits(struct vn_cs_decoder *dec, VkCommandPoolCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandPoolResetFlagBits */

static inline size_t
vn_sizeof_VkCommandPoolResetFlagBits(const VkCommandPoolResetFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandPoolResetFlagBits(struct vn_cs_encoder *enc, const VkCommandPoolResetFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandPoolResetFlagBits(struct vn_cs_decoder *dec, VkCommandPoolResetFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandBufferResetFlagBits */

static inline size_t
vn_sizeof_VkCommandBufferResetFlagBits(const VkCommandBufferResetFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandBufferResetFlagBits(struct vn_cs_encoder *enc, const VkCommandBufferResetFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandBufferResetFlagBits(struct vn_cs_decoder *dec, VkCommandBufferResetFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandBufferUsageFlagBits */

static inline size_t
vn_sizeof_VkCommandBufferUsageFlagBits(const VkCommandBufferUsageFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandBufferUsageFlagBits(struct vn_cs_encoder *enc, const VkCommandBufferUsageFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandBufferUsageFlagBits(struct vn_cs_decoder *dec, VkCommandBufferUsageFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueryPipelineStatisticFlagBits */

static inline size_t
vn_sizeof_VkQueryPipelineStatisticFlagBits(const VkQueryPipelineStatisticFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueryPipelineStatisticFlagBits(struct vn_cs_encoder *enc, const VkQueryPipelineStatisticFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueryPipelineStatisticFlagBits(struct vn_cs_decoder *dec, VkQueryPipelineStatisticFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkMemoryMapFlagBits */

static inline size_t
vn_sizeof_VkMemoryMapFlagBits(const VkMemoryMapFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkMemoryMapFlagBits(struct vn_cs_encoder *enc, const VkMemoryMapFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkMemoryMapFlagBits(struct vn_cs_decoder *dec, VkMemoryMapFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkMemoryUnmapFlagBits */

static inline size_t
vn_sizeof_VkMemoryUnmapFlagBits(const VkMemoryUnmapFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkMemoryUnmapFlagBits(struct vn_cs_encoder *enc, const VkMemoryUnmapFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkMemoryUnmapFlagBits(struct vn_cs_decoder *dec, VkMemoryUnmapFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageAspectFlagBits */

static inline size_t
vn_sizeof_VkImageAspectFlagBits(const VkImageAspectFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageAspectFlagBits(struct vn_cs_encoder *enc, const VkImageAspectFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageAspectFlagBits(struct vn_cs_decoder *dec, VkImageAspectFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSparseMemoryBindFlagBits */

static inline size_t
vn_sizeof_VkSparseMemoryBindFlagBits(const VkSparseMemoryBindFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSparseMemoryBindFlagBits(struct vn_cs_encoder *enc, const VkSparseMemoryBindFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSparseMemoryBindFlagBits(struct vn_cs_decoder *dec, VkSparseMemoryBindFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSparseImageFormatFlagBits */

static inline size_t
vn_sizeof_VkSparseImageFormatFlagBits(const VkSparseImageFormatFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSparseImageFormatFlagBits(struct vn_cs_encoder *enc, const VkSparseImageFormatFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSparseImageFormatFlagBits(struct vn_cs_decoder *dec, VkSparseImageFormatFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSubpassDescriptionFlagBits */

static inline size_t
vn_sizeof_VkSubpassDescriptionFlagBits(const VkSubpassDescriptionFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSubpassDescriptionFlagBits(struct vn_cs_encoder *enc, const VkSubpassDescriptionFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSubpassDescriptionFlagBits(struct vn_cs_decoder *dec, VkSubpassDescriptionFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineStageFlagBits */

static inline size_t
vn_sizeof_VkPipelineStageFlagBits(const VkPipelineStageFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineStageFlagBits(struct vn_cs_encoder *enc, const VkPipelineStageFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineStageFlagBits(struct vn_cs_decoder *dec, VkPipelineStageFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSampleCountFlagBits */

static inline size_t
vn_sizeof_VkSampleCountFlagBits(const VkSampleCountFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSampleCountFlagBits(struct vn_cs_encoder *enc, const VkSampleCountFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSampleCountFlagBits(struct vn_cs_decoder *dec, VkSampleCountFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkSampleCountFlagBits_array(const VkSampleCountFlagBits *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkSampleCountFlagBits_array(struct vn_cs_encoder *enc, const VkSampleCountFlagBits *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkSampleCountFlagBits_array(struct vn_cs_decoder *dec, VkSampleCountFlagBits *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkAttachmentDescriptionFlagBits */

static inline size_t
vn_sizeof_VkAttachmentDescriptionFlagBits(const VkAttachmentDescriptionFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkAttachmentDescriptionFlagBits(struct vn_cs_encoder *enc, const VkAttachmentDescriptionFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkAttachmentDescriptionFlagBits(struct vn_cs_decoder *dec, VkAttachmentDescriptionFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkStencilFaceFlagBits */

static inline size_t
vn_sizeof_VkStencilFaceFlagBits(const VkStencilFaceFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkStencilFaceFlagBits(struct vn_cs_encoder *enc, const VkStencilFaceFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkStencilFaceFlagBits(struct vn_cs_decoder *dec, VkStencilFaceFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCullModeFlagBits */

static inline size_t
vn_sizeof_VkCullModeFlagBits(const VkCullModeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCullModeFlagBits(struct vn_cs_encoder *enc, const VkCullModeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCullModeFlagBits(struct vn_cs_decoder *dec, VkCullModeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDescriptorPoolCreateFlagBits */

static inline size_t
vn_sizeof_VkDescriptorPoolCreateFlagBits(const VkDescriptorPoolCreateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDescriptorPoolCreateFlagBits(struct vn_cs_encoder *enc, const VkDescriptorPoolCreateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDescriptorPoolCreateFlagBits(struct vn_cs_decoder *dec, VkDescriptorPoolCreateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDependencyFlagBits */

static inline size_t
vn_sizeof_VkDependencyFlagBits(const VkDependencyFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDependencyFlagBits(struct vn_cs_encoder *enc, const VkDependencyFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDependencyFlagBits(struct vn_cs_decoder *dec, VkDependencyFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSubgroupFeatureFlagBits */

static inline size_t
vn_sizeof_VkSubgroupFeatureFlagBits(const VkSubgroupFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSubgroupFeatureFlagBits(struct vn_cs_encoder *enc, const VkSubgroupFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSubgroupFeatureFlagBits(struct vn_cs_decoder *dec, VkSubgroupFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineCreationFeedbackFlagBits */

static inline size_t
vn_sizeof_VkPipelineCreationFeedbackFlagBits(const VkPipelineCreationFeedbackFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineCreationFeedbackFlagBits(struct vn_cs_encoder *enc, const VkPipelineCreationFeedbackFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineCreationFeedbackFlagBits(struct vn_cs_decoder *dec, VkPipelineCreationFeedbackFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSemaphoreWaitFlagBits */

static inline size_t
vn_sizeof_VkSemaphoreWaitFlagBits(const VkSemaphoreWaitFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSemaphoreWaitFlagBits(struct vn_cs_encoder *enc, const VkSemaphoreWaitFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSemaphoreWaitFlagBits(struct vn_cs_decoder *dec, VkSemaphoreWaitFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* typedef VkFlags64 VkAccessFlagBits2 */

static inline size_t
vn_sizeof_VkAccessFlagBits2(const VkAccessFlagBits2 *val)
{
    assert(sizeof(*val) == sizeof(uint64_t));
    return vn_sizeof_uint64_t((const uint64_t *)val);
}

static inline void
vn_encode_VkAccessFlagBits2(struct vn_cs_encoder *enc, const VkAccessFlagBits2 *val)
{
    vn_encode_uint64_t(enc, (const uint64_t *)val);
}

static inline void
vn_decode_VkAccessFlagBits2(struct vn_cs_decoder *dec, VkAccessFlagBits2 *val)
{
    vn_decode_uint64_t(dec, (uint64_t *)val);
}

/* typedef VkFlags64 VkPipelineStageFlagBits2 */

static inline size_t
vn_sizeof_VkPipelineStageFlagBits2(const VkPipelineStageFlagBits2 *val)
{
    assert(sizeof(*val) == sizeof(uint64_t));
    return vn_sizeof_uint64_t((const uint64_t *)val);
}

static inline void
vn_encode_VkPipelineStageFlagBits2(struct vn_cs_encoder *enc, const VkPipelineStageFlagBits2 *val)
{
    vn_encode_uint64_t(enc, (const uint64_t *)val);
}

static inline void
vn_decode_VkPipelineStageFlagBits2(struct vn_cs_decoder *dec, VkPipelineStageFlagBits2 *val)
{
    vn_decode_uint64_t(dec, (uint64_t *)val);
}

/* typedef VkFlags64 VkFormatFeatureFlagBits2 */

static inline size_t
vn_sizeof_VkFormatFeatureFlagBits2(const VkFormatFeatureFlagBits2 *val)
{
    assert(sizeof(*val) == sizeof(uint64_t));
    return vn_sizeof_uint64_t((const uint64_t *)val);
}

static inline void
vn_encode_VkFormatFeatureFlagBits2(struct vn_cs_encoder *enc, const VkFormatFeatureFlagBits2 *val)
{
    vn_encode_uint64_t(enc, (const uint64_t *)val);
}

static inline void
vn_decode_VkFormatFeatureFlagBits2(struct vn_cs_decoder *dec, VkFormatFeatureFlagBits2 *val)
{
    vn_decode_uint64_t(dec, (uint64_t *)val);
}

/* enum VkRenderingFlagBits */

static inline size_t
vn_sizeof_VkRenderingFlagBits(const VkRenderingFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkRenderingFlagBits(struct vn_cs_encoder *enc, const VkRenderingFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkRenderingFlagBits(struct vn_cs_decoder *dec, VkRenderingFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* typedef VkFlags64 VkPipelineCreateFlagBits2 */

static inline size_t
vn_sizeof_VkPipelineCreateFlagBits2(const VkPipelineCreateFlagBits2 *val)
{
    assert(sizeof(*val) == sizeof(uint64_t));
    return vn_sizeof_uint64_t((const uint64_t *)val);
}

static inline void
vn_encode_VkPipelineCreateFlagBits2(struct vn_cs_encoder *enc, const VkPipelineCreateFlagBits2 *val)
{
    vn_encode_uint64_t(enc, (const uint64_t *)val);
}

static inline void
vn_decode_VkPipelineCreateFlagBits2(struct vn_cs_decoder *dec, VkPipelineCreateFlagBits2 *val)
{
    vn_decode_uint64_t(dec, (uint64_t *)val);
}

/* typedef VkFlags64 VkBufferUsageFlagBits2 */

static inline size_t
vn_sizeof_VkBufferUsageFlagBits2(const VkBufferUsageFlagBits2 *val)
{
    assert(sizeof(*val) == sizeof(uint64_t));
    return vn_sizeof_uint64_t((const uint64_t *)val);
}

static inline void
vn_encode_VkBufferUsageFlagBits2(struct vn_cs_encoder *enc, const VkBufferUsageFlagBits2 *val)
{
    vn_encode_uint64_t(enc, (const uint64_t *)val);
}

static inline void
vn_decode_VkBufferUsageFlagBits2(struct vn_cs_decoder *dec, VkBufferUsageFlagBits2 *val)
{
    vn_decode_uint64_t(dec, (uint64_t *)val);
}

/* enum VkPeerMemoryFeatureFlagBits */

static inline size_t
vn_sizeof_VkPeerMemoryFeatureFlagBits(const VkPeerMemoryFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPeerMemoryFeatureFlagBits(struct vn_cs_encoder *enc, const VkPeerMemoryFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPeerMemoryFeatureFlagBits(struct vn_cs_decoder *dec, VkPeerMemoryFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkMemoryAllocateFlagBits */

static inline size_t
vn_sizeof_VkMemoryAllocateFlagBits(const VkMemoryAllocateFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkMemoryAllocateFlagBits(struct vn_cs_encoder *enc, const VkMemoryAllocateFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkMemoryAllocateFlagBits(struct vn_cs_decoder *dec, VkMemoryAllocateFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalMemoryHandleTypeFlagBits */

static inline size_t
vn_sizeof_VkExternalMemoryHandleTypeFlagBits(const VkExternalMemoryHandleTypeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalMemoryHandleTypeFlagBits(struct vn_cs_encoder *enc, const VkExternalMemoryHandleTypeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalMemoryHandleTypeFlagBits(struct vn_cs_decoder *dec, VkExternalMemoryHandleTypeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalMemoryFeatureFlagBits */

static inline size_t
vn_sizeof_VkExternalMemoryFeatureFlagBits(const VkExternalMemoryFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalMemoryFeatureFlagBits(struct vn_cs_encoder *enc, const VkExternalMemoryFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalMemoryFeatureFlagBits(struct vn_cs_decoder *dec, VkExternalMemoryFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalSemaphoreHandleTypeFlagBits */

static inline size_t
vn_sizeof_VkExternalSemaphoreHandleTypeFlagBits(const VkExternalSemaphoreHandleTypeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalSemaphoreHandleTypeFlagBits(struct vn_cs_encoder *enc, const VkExternalSemaphoreHandleTypeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalSemaphoreHandleTypeFlagBits(struct vn_cs_decoder *dec, VkExternalSemaphoreHandleTypeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalSemaphoreFeatureFlagBits */

static inline size_t
vn_sizeof_VkExternalSemaphoreFeatureFlagBits(const VkExternalSemaphoreFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalSemaphoreFeatureFlagBits(struct vn_cs_encoder *enc, const VkExternalSemaphoreFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalSemaphoreFeatureFlagBits(struct vn_cs_decoder *dec, VkExternalSemaphoreFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSemaphoreImportFlagBits */

static inline size_t
vn_sizeof_VkSemaphoreImportFlagBits(const VkSemaphoreImportFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSemaphoreImportFlagBits(struct vn_cs_encoder *enc, const VkSemaphoreImportFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSemaphoreImportFlagBits(struct vn_cs_decoder *dec, VkSemaphoreImportFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalFenceHandleTypeFlagBits */

static inline size_t
vn_sizeof_VkExternalFenceHandleTypeFlagBits(const VkExternalFenceHandleTypeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalFenceHandleTypeFlagBits(struct vn_cs_encoder *enc, const VkExternalFenceHandleTypeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalFenceHandleTypeFlagBits(struct vn_cs_decoder *dec, VkExternalFenceHandleTypeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkExternalFenceFeatureFlagBits */

static inline size_t
vn_sizeof_VkExternalFenceFeatureFlagBits(const VkExternalFenceFeatureFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkExternalFenceFeatureFlagBits(struct vn_cs_encoder *enc, const VkExternalFenceFeatureFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkExternalFenceFeatureFlagBits(struct vn_cs_decoder *dec, VkExternalFenceFeatureFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFenceImportFlagBits */

static inline size_t
vn_sizeof_VkFenceImportFlagBits(const VkFenceImportFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFenceImportFlagBits(struct vn_cs_encoder *enc, const VkFenceImportFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFenceImportFlagBits(struct vn_cs_decoder *dec, VkFenceImportFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDescriptorBindingFlagBits */

static inline size_t
vn_sizeof_VkDescriptorBindingFlagBits(const VkDescriptorBindingFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDescriptorBindingFlagBits(struct vn_cs_encoder *enc, const VkDescriptorBindingFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDescriptorBindingFlagBits(struct vn_cs_decoder *dec, VkDescriptorBindingFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkConditionalRenderingFlagBitsEXT */

static inline size_t
vn_sizeof_VkConditionalRenderingFlagBitsEXT(const VkConditionalRenderingFlagBitsEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkConditionalRenderingFlagBitsEXT(struct vn_cs_encoder *enc, const VkConditionalRenderingFlagBitsEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkConditionalRenderingFlagBitsEXT(struct vn_cs_decoder *dec, VkConditionalRenderingFlagBitsEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkResolveModeFlagBits */

static inline size_t
vn_sizeof_VkResolveModeFlagBits(const VkResolveModeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkResolveModeFlagBits(struct vn_cs_encoder *enc, const VkResolveModeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkResolveModeFlagBits(struct vn_cs_decoder *dec, VkResolveModeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkToolPurposeFlagBits */

static inline size_t
vn_sizeof_VkToolPurposeFlagBits(const VkToolPurposeFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkToolPurposeFlagBits(struct vn_cs_encoder *enc, const VkToolPurposeFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkToolPurposeFlagBits(struct vn_cs_decoder *dec, VkToolPurposeFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSubmitFlagBits */

static inline size_t
vn_sizeof_VkSubmitFlagBits(const VkSubmitFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSubmitFlagBits(struct vn_cs_encoder *enc, const VkSubmitFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSubmitFlagBits(struct vn_cs_decoder *dec, VkSubmitFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkHostImageCopyFlagBits */

static inline size_t
vn_sizeof_VkHostImageCopyFlagBits(const VkHostImageCopyFlagBits *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkHostImageCopyFlagBits(struct vn_cs_encoder *enc, const VkHostImageCopyFlagBits *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkHostImageCopyFlagBits(struct vn_cs_decoder *dec, VkHostImageCopyFlagBits *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkGraphicsPipelineLibraryFlagBitsEXT */

static inline size_t
vn_sizeof_VkGraphicsPipelineLibraryFlagBitsEXT(const VkGraphicsPipelineLibraryFlagBitsEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkGraphicsPipelineLibraryFlagBitsEXT(struct vn_cs_encoder *enc, const VkGraphicsPipelineLibraryFlagBitsEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkGraphicsPipelineLibraryFlagBitsEXT(struct vn_cs_decoder *dec, VkGraphicsPipelineLibraryFlagBitsEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkAttachmentLoadOp */

static inline size_t
vn_sizeof_VkAttachmentLoadOp(const VkAttachmentLoadOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkAttachmentLoadOp(struct vn_cs_encoder *enc, const VkAttachmentLoadOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkAttachmentLoadOp(struct vn_cs_decoder *dec, VkAttachmentLoadOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkAttachmentStoreOp */

static inline size_t
vn_sizeof_VkAttachmentStoreOp(const VkAttachmentStoreOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkAttachmentStoreOp(struct vn_cs_encoder *enc, const VkAttachmentStoreOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkAttachmentStoreOp(struct vn_cs_decoder *dec, VkAttachmentStoreOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBlendFactor */

static inline size_t
vn_sizeof_VkBlendFactor(const VkBlendFactor *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBlendFactor(struct vn_cs_encoder *enc, const VkBlendFactor *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBlendFactor(struct vn_cs_decoder *dec, VkBlendFactor *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBlendOp */

static inline size_t
vn_sizeof_VkBlendOp(const VkBlendOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBlendOp(struct vn_cs_encoder *enc, const VkBlendOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBlendOp(struct vn_cs_decoder *dec, VkBlendOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBorderColor */

static inline size_t
vn_sizeof_VkBorderColor(const VkBorderColor *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBorderColor(struct vn_cs_encoder *enc, const VkBorderColor *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBorderColor(struct vn_cs_decoder *dec, VkBorderColor *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineCacheHeaderVersion */

static inline size_t
vn_sizeof_VkPipelineCacheHeaderVersion(const VkPipelineCacheHeaderVersion *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineCacheHeaderVersion(struct vn_cs_encoder *enc, const VkPipelineCacheHeaderVersion *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineCacheHeaderVersion(struct vn_cs_decoder *dec, VkPipelineCacheHeaderVersion *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkComponentSwizzle */

static inline size_t
vn_sizeof_VkComponentSwizzle(const VkComponentSwizzle *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkComponentSwizzle(struct vn_cs_encoder *enc, const VkComponentSwizzle *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkComponentSwizzle(struct vn_cs_decoder *dec, VkComponentSwizzle *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandBufferLevel */

static inline size_t
vn_sizeof_VkCommandBufferLevel(const VkCommandBufferLevel *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandBufferLevel(struct vn_cs_encoder *enc, const VkCommandBufferLevel *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandBufferLevel(struct vn_cs_decoder *dec, VkCommandBufferLevel *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCompareOp */

static inline size_t
vn_sizeof_VkCompareOp(const VkCompareOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCompareOp(struct vn_cs_encoder *enc, const VkCompareOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCompareOp(struct vn_cs_decoder *dec, VkCompareOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDescriptorType */

static inline size_t
vn_sizeof_VkDescriptorType(const VkDescriptorType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDescriptorType(struct vn_cs_encoder *enc, const VkDescriptorType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDescriptorType(struct vn_cs_decoder *dec, VkDescriptorType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkDescriptorType_array(const VkDescriptorType *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkDescriptorType_array(struct vn_cs_encoder *enc, const VkDescriptorType *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkDescriptorType_array(struct vn_cs_decoder *dec, VkDescriptorType *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkDynamicState */

static inline size_t
vn_sizeof_VkDynamicState(const VkDynamicState *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDynamicState(struct vn_cs_encoder *enc, const VkDynamicState *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDynamicState(struct vn_cs_decoder *dec, VkDynamicState *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkDynamicState_array(const VkDynamicState *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkDynamicState_array(struct vn_cs_encoder *enc, const VkDynamicState *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkDynamicState_array(struct vn_cs_decoder *dec, VkDynamicState *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkPolygonMode */

static inline size_t
vn_sizeof_VkPolygonMode(const VkPolygonMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPolygonMode(struct vn_cs_encoder *enc, const VkPolygonMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPolygonMode(struct vn_cs_decoder *dec, VkPolygonMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFormat */

static inline size_t
vn_sizeof_VkFormat(const VkFormat *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFormat(struct vn_cs_encoder *enc, const VkFormat *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFormat(struct vn_cs_decoder *dec, VkFormat *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkFormat_array(const VkFormat *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkFormat_array(struct vn_cs_encoder *enc, const VkFormat *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkFormat_array(struct vn_cs_decoder *dec, VkFormat *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkFrontFace */

static inline size_t
vn_sizeof_VkFrontFace(const VkFrontFace *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFrontFace(struct vn_cs_encoder *enc, const VkFrontFace *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFrontFace(struct vn_cs_decoder *dec, VkFrontFace *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageLayout */

static inline size_t
vn_sizeof_VkImageLayout(const VkImageLayout *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageLayout(struct vn_cs_encoder *enc, const VkImageLayout *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageLayout(struct vn_cs_decoder *dec, VkImageLayout *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkImageLayout_array(const VkImageLayout *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkImageLayout_array(struct vn_cs_encoder *enc, const VkImageLayout *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkImageLayout_array(struct vn_cs_decoder *dec, VkImageLayout *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkImageTiling */

static inline size_t
vn_sizeof_VkImageTiling(const VkImageTiling *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageTiling(struct vn_cs_encoder *enc, const VkImageTiling *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageTiling(struct vn_cs_decoder *dec, VkImageTiling *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageType */

static inline size_t
vn_sizeof_VkImageType(const VkImageType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageType(struct vn_cs_encoder *enc, const VkImageType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageType(struct vn_cs_decoder *dec, VkImageType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkImageViewType */

static inline size_t
vn_sizeof_VkImageViewType(const VkImageViewType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkImageViewType(struct vn_cs_encoder *enc, const VkImageViewType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkImageViewType(struct vn_cs_decoder *dec, VkImageViewType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSharingMode */

static inline size_t
vn_sizeof_VkSharingMode(const VkSharingMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSharingMode(struct vn_cs_encoder *enc, const VkSharingMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSharingMode(struct vn_cs_decoder *dec, VkSharingMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkIndexType */

static inline size_t
vn_sizeof_VkIndexType(const VkIndexType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkIndexType(struct vn_cs_encoder *enc, const VkIndexType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkIndexType(struct vn_cs_decoder *dec, VkIndexType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkIndexType_array(const VkIndexType *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkIndexType_array(struct vn_cs_encoder *enc, const VkIndexType *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkIndexType_array(struct vn_cs_decoder *dec, VkIndexType *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkLogicOp */

static inline size_t
vn_sizeof_VkLogicOp(const VkLogicOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkLogicOp(struct vn_cs_encoder *enc, const VkLogicOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkLogicOp(struct vn_cs_decoder *dec, VkLogicOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPhysicalDeviceType */

static inline size_t
vn_sizeof_VkPhysicalDeviceType(const VkPhysicalDeviceType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPhysicalDeviceType(struct vn_cs_encoder *enc, const VkPhysicalDeviceType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPhysicalDeviceType(struct vn_cs_decoder *dec, VkPhysicalDeviceType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineBindPoint */

static inline size_t
vn_sizeof_VkPipelineBindPoint(const VkPipelineBindPoint *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineBindPoint(struct vn_cs_encoder *enc, const VkPipelineBindPoint *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineBindPoint(struct vn_cs_decoder *dec, VkPipelineBindPoint *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPrimitiveTopology */

static inline size_t
vn_sizeof_VkPrimitiveTopology(const VkPrimitiveTopology *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPrimitiveTopology(struct vn_cs_encoder *enc, const VkPrimitiveTopology *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPrimitiveTopology(struct vn_cs_decoder *dec, VkPrimitiveTopology *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueryType */

static inline size_t
vn_sizeof_VkQueryType(const VkQueryType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueryType(struct vn_cs_encoder *enc, const VkQueryType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueryType(struct vn_cs_decoder *dec, VkQueryType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSubpassContents */

static inline size_t
vn_sizeof_VkSubpassContents(const VkSubpassContents *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSubpassContents(struct vn_cs_encoder *enc, const VkSubpassContents *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSubpassContents(struct vn_cs_decoder *dec, VkSubpassContents *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkResult */

static inline size_t
vn_sizeof_VkResult(const VkResult *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkResult(struct vn_cs_encoder *enc, const VkResult *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkResult(struct vn_cs_decoder *dec, VkResult *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkResult_array(const VkResult *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkResult_array(struct vn_cs_encoder *enc, const VkResult *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkResult_array(struct vn_cs_decoder *dec, VkResult *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkStencilOp */

static inline size_t
vn_sizeof_VkStencilOp(const VkStencilOp *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkStencilOp(struct vn_cs_encoder *enc, const VkStencilOp *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkStencilOp(struct vn_cs_decoder *dec, VkStencilOp *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSystemAllocationScope */

static inline size_t
vn_sizeof_VkSystemAllocationScope(const VkSystemAllocationScope *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSystemAllocationScope(struct vn_cs_encoder *enc, const VkSystemAllocationScope *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSystemAllocationScope(struct vn_cs_decoder *dec, VkSystemAllocationScope *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkInternalAllocationType */

static inline size_t
vn_sizeof_VkInternalAllocationType(const VkInternalAllocationType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkInternalAllocationType(struct vn_cs_encoder *enc, const VkInternalAllocationType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkInternalAllocationType(struct vn_cs_decoder *dec, VkInternalAllocationType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerAddressMode */

static inline size_t
vn_sizeof_VkSamplerAddressMode(const VkSamplerAddressMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerAddressMode(struct vn_cs_encoder *enc, const VkSamplerAddressMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerAddressMode(struct vn_cs_decoder *dec, VkSamplerAddressMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFilter */

static inline size_t
vn_sizeof_VkFilter(const VkFilter *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFilter(struct vn_cs_encoder *enc, const VkFilter *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFilter(struct vn_cs_decoder *dec, VkFilter *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerMipmapMode */

static inline size_t
vn_sizeof_VkSamplerMipmapMode(const VkSamplerMipmapMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerMipmapMode(struct vn_cs_encoder *enc, const VkSamplerMipmapMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerMipmapMode(struct vn_cs_decoder *dec, VkSamplerMipmapMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkVertexInputRate */

static inline size_t
vn_sizeof_VkVertexInputRate(const VkVertexInputRate *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkVertexInputRate(struct vn_cs_encoder *enc, const VkVertexInputRate *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkVertexInputRate(struct vn_cs_decoder *dec, VkVertexInputRate *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkObjectType */

static inline size_t
vn_sizeof_VkObjectType(const VkObjectType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkObjectType(struct vn_cs_encoder *enc, const VkObjectType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkObjectType(struct vn_cs_decoder *dec, VkObjectType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkObjectType_array(const VkObjectType *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkObjectType_array(struct vn_cs_encoder *enc, const VkObjectType *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkObjectType_array(struct vn_cs_decoder *dec, VkObjectType *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkDescriptorUpdateTemplateType */

static inline size_t
vn_sizeof_VkDescriptorUpdateTemplateType(const VkDescriptorUpdateTemplateType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDescriptorUpdateTemplateType(struct vn_cs_encoder *enc, const VkDescriptorUpdateTemplateType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDescriptorUpdateTemplateType(struct vn_cs_decoder *dec, VkDescriptorUpdateTemplateType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPointClippingBehavior */

static inline size_t
vn_sizeof_VkPointClippingBehavior(const VkPointClippingBehavior *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPointClippingBehavior(struct vn_cs_encoder *enc, const VkPointClippingBehavior *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPointClippingBehavior(struct vn_cs_decoder *dec, VkPointClippingBehavior *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkQueueGlobalPriority */

static inline size_t
vn_sizeof_VkQueueGlobalPriority(const VkQueueGlobalPriority *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkQueueGlobalPriority(struct vn_cs_encoder *enc, const VkQueueGlobalPriority *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkQueueGlobalPriority(struct vn_cs_decoder *dec, VkQueueGlobalPriority *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkQueueGlobalPriority_array(const VkQueueGlobalPriority *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkQueueGlobalPriority_array(struct vn_cs_encoder *enc, const VkQueueGlobalPriority *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkQueueGlobalPriority_array(struct vn_cs_decoder *dec, VkQueueGlobalPriority *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkTimeDomainKHR */

static inline size_t
vn_sizeof_VkTimeDomainKHR(const VkTimeDomainKHR *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkTimeDomainKHR(struct vn_cs_encoder *enc, const VkTimeDomainKHR *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkTimeDomainKHR(struct vn_cs_decoder *dec, VkTimeDomainKHR *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkTimeDomainKHR_array(const VkTimeDomainKHR *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkTimeDomainKHR_array(struct vn_cs_encoder *enc, const VkTimeDomainKHR *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkTimeDomainKHR_array(struct vn_cs_decoder *dec, VkTimeDomainKHR *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkConservativeRasterizationModeEXT */

static inline size_t
vn_sizeof_VkConservativeRasterizationModeEXT(const VkConservativeRasterizationModeEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkConservativeRasterizationModeEXT(struct vn_cs_encoder *enc, const VkConservativeRasterizationModeEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkConservativeRasterizationModeEXT(struct vn_cs_decoder *dec, VkConservativeRasterizationModeEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSemaphoreType */

static inline size_t
vn_sizeof_VkSemaphoreType(const VkSemaphoreType *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSemaphoreType(struct vn_cs_encoder *enc, const VkSemaphoreType *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSemaphoreType(struct vn_cs_decoder *dec, VkSemaphoreType *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkLineRasterizationMode */

static inline size_t
vn_sizeof_VkLineRasterizationMode(const VkLineRasterizationMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkLineRasterizationMode(struct vn_cs_encoder *enc, const VkLineRasterizationMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkLineRasterizationMode(struct vn_cs_decoder *dec, VkLineRasterizationMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkProvokingVertexModeEXT */

static inline size_t
vn_sizeof_VkProvokingVertexModeEXT(const VkProvokingVertexModeEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkProvokingVertexModeEXT(struct vn_cs_encoder *enc, const VkProvokingVertexModeEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkProvokingVertexModeEXT(struct vn_cs_decoder *dec, VkProvokingVertexModeEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineRobustnessBufferBehavior */

static inline size_t
vn_sizeof_VkPipelineRobustnessBufferBehavior(const VkPipelineRobustnessBufferBehavior *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineRobustnessBufferBehavior(struct vn_cs_encoder *enc, const VkPipelineRobustnessBufferBehavior *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineRobustnessBufferBehavior(struct vn_cs_decoder *dec, VkPipelineRobustnessBufferBehavior *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkPipelineRobustnessImageBehavior */

static inline size_t
vn_sizeof_VkPipelineRobustnessImageBehavior(const VkPipelineRobustnessImageBehavior *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkPipelineRobustnessImageBehavior(struct vn_cs_encoder *enc, const VkPipelineRobustnessImageBehavior *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkPipelineRobustnessImageBehavior(struct vn_cs_decoder *dec, VkPipelineRobustnessImageBehavior *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkTessellationDomainOrigin */

static inline size_t
vn_sizeof_VkTessellationDomainOrigin(const VkTessellationDomainOrigin *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkTessellationDomainOrigin(struct vn_cs_encoder *enc, const VkTessellationDomainOrigin *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkTessellationDomainOrigin(struct vn_cs_decoder *dec, VkTessellationDomainOrigin *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerYcbcrModelConversion */

static inline size_t
vn_sizeof_VkSamplerYcbcrModelConversion(const VkSamplerYcbcrModelConversion *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerYcbcrModelConversion(struct vn_cs_encoder *enc, const VkSamplerYcbcrModelConversion *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerYcbcrModelConversion(struct vn_cs_decoder *dec, VkSamplerYcbcrModelConversion *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerYcbcrRange */

static inline size_t
vn_sizeof_VkSamplerYcbcrRange(const VkSamplerYcbcrRange *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerYcbcrRange(struct vn_cs_encoder *enc, const VkSamplerYcbcrRange *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerYcbcrRange(struct vn_cs_decoder *dec, VkSamplerYcbcrRange *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkChromaLocation */

static inline size_t
vn_sizeof_VkChromaLocation(const VkChromaLocation *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkChromaLocation(struct vn_cs_encoder *enc, const VkChromaLocation *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkChromaLocation(struct vn_cs_decoder *dec, VkChromaLocation *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkSamplerReductionMode */

static inline size_t
vn_sizeof_VkSamplerReductionMode(const VkSamplerReductionMode *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkSamplerReductionMode(struct vn_cs_encoder *enc, const VkSamplerReductionMode *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkSamplerReductionMode(struct vn_cs_decoder *dec, VkSamplerReductionMode *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkBlendOverlapEXT */

static inline size_t
vn_sizeof_VkBlendOverlapEXT(const VkBlendOverlapEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkBlendOverlapEXT(struct vn_cs_encoder *enc, const VkBlendOverlapEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkBlendOverlapEXT(struct vn_cs_decoder *dec, VkBlendOverlapEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkShaderFloatControlsIndependence */

static inline size_t
vn_sizeof_VkShaderFloatControlsIndependence(const VkShaderFloatControlsIndependence *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkShaderFloatControlsIndependence(struct vn_cs_encoder *enc, const VkShaderFloatControlsIndependence *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkShaderFloatControlsIndependence(struct vn_cs_decoder *dec, VkShaderFloatControlsIndependence *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkFragmentShadingRateCombinerOpKHR */

static inline size_t
vn_sizeof_VkFragmentShadingRateCombinerOpKHR(const VkFragmentShadingRateCombinerOpKHR *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkFragmentShadingRateCombinerOpKHR(struct vn_cs_encoder *enc, const VkFragmentShadingRateCombinerOpKHR *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkFragmentShadingRateCombinerOpKHR(struct vn_cs_decoder *dec, VkFragmentShadingRateCombinerOpKHR *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

static inline size_t
vn_sizeof_VkFragmentShadingRateCombinerOpKHR_array(const VkFragmentShadingRateCombinerOpKHR *val, uint32_t count)
{
    return vn_sizeof_int32_t_array((const int32_t *)val, count);
}

static inline void
vn_encode_VkFragmentShadingRateCombinerOpKHR_array(struct vn_cs_encoder *enc, const VkFragmentShadingRateCombinerOpKHR *val, uint32_t count)
{
    vn_encode_int32_t_array(enc, (const int32_t *)val, count);
}

static inline void
vn_decode_VkFragmentShadingRateCombinerOpKHR_array(struct vn_cs_decoder *dec, VkFragmentShadingRateCombinerOpKHR *val, uint32_t count)
{
    vn_decode_int32_t_array(dec, (int32_t *)val, count);
}

/* enum VkVendorId */

static inline size_t
vn_sizeof_VkVendorId(const VkVendorId *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkVendorId(struct vn_cs_encoder *enc, const VkVendorId *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkVendorId(struct vn_cs_decoder *dec, VkVendorId *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkDriverId */

static inline size_t
vn_sizeof_VkDriverId(const VkDriverId *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkDriverId(struct vn_cs_encoder *enc, const VkDriverId *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkDriverId(struct vn_cs_decoder *dec, VkDriverId *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandFlagBitsEXT */

static inline size_t
vn_sizeof_VkCommandFlagBitsEXT(const VkCommandFlagBitsEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandFlagBitsEXT(struct vn_cs_encoder *enc, const VkCommandFlagBitsEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandFlagBitsEXT(struct vn_cs_decoder *dec, VkCommandFlagBitsEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkCommandTypeEXT */

static inline size_t
vn_sizeof_VkCommandTypeEXT(const VkCommandTypeEXT *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkCommandTypeEXT(struct vn_cs_encoder *enc, const VkCommandTypeEXT *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkCommandTypeEXT(struct vn_cs_decoder *dec, VkCommandTypeEXT *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

/* enum VkRingStatusFlagBitsMESA */

static inline size_t
vn_sizeof_VkRingStatusFlagBitsMESA(const VkRingStatusFlagBitsMESA *val)
{
    assert(sizeof(*val) == sizeof(int32_t));
    return vn_sizeof_int32_t((const int32_t *)val);
}

static inline void
vn_encode_VkRingStatusFlagBitsMESA(struct vn_cs_encoder *enc, const VkRingStatusFlagBitsMESA *val)
{
    vn_encode_int32_t(enc, (const int32_t *)val);
}

static inline void
vn_decode_VkRingStatusFlagBitsMESA(struct vn_cs_decoder *dec, VkRingStatusFlagBitsMESA *val)
{
    vn_decode_int32_t(dec, (int32_t *)val);
}

#endif /* VN_PROTOCOL_DRIVER_TYPES_H */
