/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H
#define VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkCmdPushDescriptorSetWithTemplate
 *   vkCmdPushDescriptorSetWithTemplate2
 */

/* struct VkCommandBufferAllocateInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo_self(const VkCommandBufferAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkCommandPool(&val->commandPool);
    size += vn_sizeof_VkCommandBufferLevel(&val->level);
    size += vn_sizeof_uint32_t(&val->commandBufferCount);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferAllocateInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkCommandPool(enc, &val->commandPool);
    vn_encode_VkCommandBufferLevel(enc, &val->level);
    vn_encode_uint32_t(enc, &val->commandBufferCount);
}

static inline void
vn_encode_VkCommandBufferAllocateInfo(struct vn_cs_encoder *enc, const VkCommandBufferAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO });
    vn_encode_VkCommandBufferAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferAllocateInfo_self(enc, val);
}

/* struct VkCommandBufferInheritanceConditionalRenderingInfoEXT chain */

static inline size_t
vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self(const VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->conditionalRenderingEnable);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT(const VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->conditionalRenderingEnable);
}

static inline void
vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT });
    vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self(enc, val);
}

/* struct VkCommandBufferInheritanceRenderingInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferInheritanceRenderingInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceRenderingInfo_self(const VkCommandBufferInheritanceRenderingInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->viewMask);
    size += vn_sizeof_uint32_t(&val->colorAttachmentCount);
    if (val->pColorAttachmentFormats) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        size += vn_sizeof_VkFormat_array(val->pColorAttachmentFormats, val->colorAttachmentCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_VkFormat(&val->depthAttachmentFormat);
    size += vn_sizeof_VkFormat(&val->stencilAttachmentFormat);
    size += vn_sizeof_VkSampleCountFlagBits(&val->rasterizationSamples);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceRenderingInfo(const VkCommandBufferInheritanceRenderingInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferInheritanceRenderingInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferInheritanceRenderingInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferInheritanceRenderingInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferInheritanceRenderingInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceRenderingInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->viewMask);
    vn_encode_uint32_t(enc, &val->colorAttachmentCount);
    if (val->pColorAttachmentFormats) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        vn_encode_VkFormat_array(enc, val->pColorAttachmentFormats, val->colorAttachmentCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFormat(enc, &val->depthAttachmentFormat);
    vn_encode_VkFormat(enc, &val->stencilAttachmentFormat);
    vn_encode_VkSampleCountFlagBits(enc, &val->rasterizationSamples);
}

static inline void
vn_encode_VkCommandBufferInheritanceRenderingInfo(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceRenderingInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO });
    vn_encode_VkCommandBufferInheritanceRenderingInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferInheritanceRenderingInfo_self(enc, val);
}

/* struct VkCommandBufferInheritanceInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self((const VkCommandBufferInheritanceConditionalRenderingInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkCommandBufferInheritanceRenderingInfo_self((const VkCommandBufferInheritanceRenderingInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
            if (!vn_cs_renderer_protocol_has_extension(233 /* VK_KHR_dynamic_rendering_local_read */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderingAttachmentLocationInfo_self((const VkRenderingAttachmentLocationInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
            if (!vn_cs_renderer_protocol_has_extension(233 /* VK_KHR_dynamic_rendering_local_read */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderingInputAttachmentIndexInfo_self((const VkRenderingInputAttachmentIndexInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo_self(const VkCommandBufferInheritanceInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_uint32_t(&val->subpass);
    size += vn_sizeof_VkFramebuffer(&val->framebuffer);
    size += vn_sizeof_VkBool32(&val->occlusionQueryEnable);
    size += vn_sizeof_VkFlags(&val->queryFlags);
    size += vn_sizeof_VkFlags(&val->pipelineStatistics);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferInheritanceInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, pnext->pNext);
            vn_encode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self(enc, (const VkCommandBufferInheritanceConditionalRenderingInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, pnext->pNext);
            vn_encode_VkCommandBufferInheritanceRenderingInfo_self(enc, (const VkCommandBufferInheritanceRenderingInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
            if (!vn_cs_renderer_protocol_has_extension(233 /* VK_KHR_dynamic_rendering_local_read */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderingAttachmentLocationInfo_self(enc, (const VkRenderingAttachmentLocationInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
            if (!vn_cs_renderer_protocol_has_extension(233 /* VK_KHR_dynamic_rendering_local_read */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderingInputAttachmentIndexInfo_self(enc, (const VkRenderingInputAttachmentIndexInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_uint32_t(enc, &val->subpass);
    vn_encode_VkFramebuffer(enc, &val->framebuffer);
    vn_encode_VkBool32(enc, &val->occlusionQueryEnable);
    vn_encode_VkFlags(enc, &val->queryFlags);
    vn_encode_VkFlags(enc, &val->pipelineStatistics);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO });
    vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferInheritanceInfo_self(enc, val);
}

/* struct VkDeviceGroupCommandBufferBeginInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self(const VkDeviceGroupCommandBufferBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceMask);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceMask);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, val);
}

/* struct VkCommandBufferBeginInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self((const VkDeviceGroupCommandBufferBeginInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo_self(const VkCommandBufferBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_simple_pointer(val->pInheritanceInfo);
    if (val->pInheritanceInfo)
        size += vn_sizeof_VkCommandBufferInheritanceInfo(val->pInheritanceInfo);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, (const VkDeviceGroupCommandBufferBeginInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    if (vn_encode_simple_pointer(enc, val->pInheritanceInfo))
        vn_encode_VkCommandBufferInheritanceInfo(enc, val->pInheritanceInfo);
}

static inline void
vn_encode_VkCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferBeginInfo_self(enc, val);
}

/* struct VkMultiDrawInfoEXT */

static inline size_t
vn_sizeof_VkMultiDrawInfoEXT(const VkMultiDrawInfoEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->firstVertex);
    size += vn_sizeof_uint32_t(&val->vertexCount);
    return size;
}

static inline void
vn_encode_VkMultiDrawInfoEXT(struct vn_cs_encoder *enc, const VkMultiDrawInfoEXT *val)
{
    vn_encode_uint32_t(enc, &val->firstVertex);
    vn_encode_uint32_t(enc, &val->vertexCount);
}

/* struct VkMultiDrawIndexedInfoEXT */

static inline size_t
vn_sizeof_VkMultiDrawIndexedInfoEXT(const VkMultiDrawIndexedInfoEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->firstIndex);
    size += vn_sizeof_uint32_t(&val->indexCount);
    size += vn_sizeof_int32_t(&val->vertexOffset);
    return size;
}

static inline void
vn_encode_VkMultiDrawIndexedInfoEXT(struct vn_cs_encoder *enc, const VkMultiDrawIndexedInfoEXT *val)
{
    vn_encode_uint32_t(enc, &val->firstIndex);
    vn_encode_uint32_t(enc, &val->indexCount);
    vn_encode_int32_t(enc, &val->vertexOffset);
}

/* struct VkBufferCopy */

static inline size_t
vn_sizeof_VkBufferCopy(const VkBufferCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->srcOffset);
    size += vn_sizeof_VkDeviceSize(&val->dstOffset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline void
vn_encode_VkBufferCopy(struct vn_cs_encoder *enc, const VkBufferCopy *val)
{
    vn_encode_VkDeviceSize(enc, &val->srcOffset);
    vn_encode_VkDeviceSize(enc, &val->dstOffset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

/* struct VkImageCopy */

static inline size_t
vn_sizeof_VkImageCopy(const VkImageCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_VkOffset3D(&val->srcOffset);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_VkOffset3D(&val->dstOffset);
    size += vn_sizeof_VkExtent3D(&val->extent);
    return size;
}

static inline void
vn_encode_VkImageCopy(struct vn_cs_encoder *enc, const VkImageCopy *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_VkOffset3D(enc, &val->srcOffset);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_VkOffset3D(enc, &val->dstOffset);
    vn_encode_VkExtent3D(enc, &val->extent);
}

/* struct VkImageBlit */

static inline size_t
vn_sizeof_VkImageBlit(const VkImageBlit *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->srcOffsets[i]);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->dstOffsets[i]);
    return size;
}

static inline void
vn_encode_VkImageBlit(struct vn_cs_encoder *enc, const VkImageBlit *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->srcOffsets[i]);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->dstOffsets[i]);
}

/* struct VkBufferImageCopy */

static inline size_t
vn_sizeof_VkBufferImageCopy(const VkBufferImageCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->bufferOffset);
    size += vn_sizeof_uint32_t(&val->bufferRowLength);
    size += vn_sizeof_uint32_t(&val->bufferImageHeight);
    size += vn_sizeof_VkImageSubresourceLayers(&val->imageSubresource);
    size += vn_sizeof_VkOffset3D(&val->imageOffset);
    size += vn_sizeof_VkExtent3D(&val->imageExtent);
    return size;
}

static inline void
vn_encode_VkBufferImageCopy(struct vn_cs_encoder *enc, const VkBufferImageCopy *val)
{
    vn_encode_VkDeviceSize(enc, &val->bufferOffset);
    vn_encode_uint32_t(enc, &val->bufferRowLength);
    vn_encode_uint32_t(enc, &val->bufferImageHeight);
    vn_encode_VkImageSubresourceLayers(enc, &val->imageSubresource);
    vn_encode_VkOffset3D(enc, &val->imageOffset);
    vn_encode_VkExtent3D(enc, &val->imageExtent);
}

/* struct VkClearDepthStencilValue */

static inline size_t
vn_sizeof_VkClearDepthStencilValue(const VkClearDepthStencilValue *val)
{
    size_t size = 0;
    size += vn_sizeof_float(&val->depth);
    size += vn_sizeof_uint32_t(&val->stencil);
    return size;
}

static inline void
vn_encode_VkClearDepthStencilValue(struct vn_cs_encoder *enc, const VkClearDepthStencilValue *val)
{
    vn_encode_float(enc, &val->depth);
    vn_encode_uint32_t(enc, &val->stencil);
}

/* union VkClearValue */

static inline size_t
vn_sizeof_VkClearValue_tag(const VkClearValue *val, uint32_t tag)
{
    size_t size = vn_sizeof_uint32_t(&tag);
    switch (tag) {
    case 0:
        size += vn_sizeof_VkClearColorValue(&val->color);
        break;
    case 1:
        size += vn_sizeof_VkClearDepthStencilValue(&val->depthStencil);
        break;
    default:
        assert(false);
        break;
    }
    return size;
}

static inline size_t
vn_sizeof_VkClearValue(const VkClearValue *val)
{
    return vn_sizeof_VkClearValue_tag(val, 0);
}

static inline void
vn_encode_VkClearValue_tag(struct vn_cs_encoder *enc, const VkClearValue *val, uint32_t tag)
{
    vn_encode_uint32_t(enc, &tag);
    switch (tag) {
    case 0:
        vn_encode_VkClearColorValue(enc, &val->color);
        break;
    case 1:
        vn_encode_VkClearDepthStencilValue(enc, &val->depthStencil);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_encode_VkClearValue(struct vn_cs_encoder *enc, const VkClearValue *val)
{
    vn_encode_VkClearValue_tag(enc, val, 0); /* union with default tag */
}

/* struct VkClearAttachment */

static inline size_t
vn_sizeof_VkClearAttachment(const VkClearAttachment *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_uint32_t(&val->colorAttachment);
    size += vn_sizeof_VkClearValue(&val->clearValue);
    return size;
}

static inline void
vn_encode_VkClearAttachment(struct vn_cs_encoder *enc, const VkClearAttachment *val)
{
    vn_encode_VkFlags(enc, &val->aspectMask);
    vn_encode_uint32_t(enc, &val->colorAttachment);
    vn_encode_VkClearValue(enc, &val->clearValue);
}

/* struct VkClearRect */

static inline size_t
vn_sizeof_VkClearRect(const VkClearRect *val)
{
    size_t size = 0;
    size += vn_sizeof_VkRect2D(&val->rect);
    size += vn_sizeof_uint32_t(&val->baseArrayLayer);
    size += vn_sizeof_uint32_t(&val->layerCount);
    return size;
}

static inline void
vn_encode_VkClearRect(struct vn_cs_encoder *enc, const VkClearRect *val)
{
    vn_encode_VkRect2D(enc, &val->rect);
    vn_encode_uint32_t(enc, &val->baseArrayLayer);
    vn_encode_uint32_t(enc, &val->layerCount);
}

/* struct VkImageResolve */

static inline size_t
vn_sizeof_VkImageResolve(const VkImageResolve *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_VkOffset3D(&val->srcOffset);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_VkOffset3D(&val->dstOffset);
    size += vn_sizeof_VkExtent3D(&val->extent);
    return size;
}

static inline void
vn_encode_VkImageResolve(struct vn_cs_encoder *enc, const VkImageResolve *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_VkOffset3D(enc, &val->srcOffset);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_VkOffset3D(enc, &val->dstOffset);
    vn_encode_VkExtent3D(enc, &val->extent);
}

/* struct VkMemoryBarrier chain */

static inline size_t
vn_sizeof_VkMemoryBarrier_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryBarrier_self(const VkMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryBarrier(const VkMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryBarrier_self(struct vn_cs_encoder *enc, const VkMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
}

static inline void
vn_encode_VkMemoryBarrier(struct vn_cs_encoder *enc, const VkMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_BARRIER });
    vn_encode_VkMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkMemoryBarrier_self(enc, val);
}

/* struct VkExternalMemoryAcquireUnmodifiedEXT chain */

static inline size_t
vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self(const VkExternalMemoryAcquireUnmodifiedEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->acquireUnmodifiedMemory);
    return size;
}

static inline size_t
vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT(const VkExternalMemoryAcquireUnmodifiedEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_pnext(val->pNext);
    size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self(val);

    return size;
}

static inline void
vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(struct vn_cs_encoder *enc, const VkExternalMemoryAcquireUnmodifiedEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->acquireUnmodifiedMemory);
}

static inline void
vn_encode_VkExternalMemoryAcquireUnmodifiedEXT(struct vn_cs_encoder *enc, const VkExternalMemoryAcquireUnmodifiedEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT });
    vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_pnext(enc, val->pNext);
    vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(enc, val);
}

/* struct VkBufferMemoryBarrier chain */

static inline size_t
vn_sizeof_VkBufferMemoryBarrier_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBufferMemoryBarrier_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self((const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier_self(const VkBufferMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier(const VkBufferMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkBufferMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkBufferMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBufferMemoryBarrier_pnext(enc, pnext->pNext);
            vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(enc, (const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferMemoryBarrier_self(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

static inline void
vn_encode_VkBufferMemoryBarrier(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER });
    vn_encode_VkBufferMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkBufferMemoryBarrier_self(enc, val);
}

/* struct VkImageMemoryBarrier chain */

static inline size_t
vn_sizeof_VkImageMemoryBarrier_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageMemoryBarrier_pnext(pnext->pNext);
            size += vn_sizeof_VkSampleLocationsInfoEXT_self((const VkSampleLocationsInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageMemoryBarrier_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self((const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier_self(const VkImageMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_VkImageLayout(&val->oldLayout);
    size += vn_sizeof_VkImageLayout(&val->newLayout);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkImageSubresourceRange(&val->subresourceRange);
    return size;
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier(const VkImageMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkImageMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkImageMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageMemoryBarrier_pnext(enc, pnext->pNext);
            vn_encode_VkSampleLocationsInfoEXT_self(enc, (const VkSampleLocationsInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageMemoryBarrier_pnext(enc, pnext->pNext);
            vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(enc, (const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageMemoryBarrier_self(struct vn_cs_encoder *enc, const VkImageMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_VkImageLayout(enc, &val->oldLayout);
    vn_encode_VkImageLayout(enc, &val->newLayout);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkImageSubresourceRange(enc, &val->subresourceRange);
}

static inline void
vn_encode_VkImageMemoryBarrier(struct vn_cs_encoder *enc, const VkImageMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER });
    vn_encode_VkImageMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkImageMemoryBarrier_self(enc, val);
}

/* struct VkConditionalRenderingBeginInfoEXT chain */

static inline size_t
vn_sizeof_VkConditionalRenderingBeginInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkConditionalRenderingBeginInfoEXT_self(const VkConditionalRenderingBeginInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline size_t
vn_sizeof_VkConditionalRenderingBeginInfoEXT(const VkConditionalRenderingBeginInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkConditionalRenderingBeginInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkConditionalRenderingBeginInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkConditionalRenderingBeginInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkConditionalRenderingBeginInfoEXT_self(struct vn_cs_encoder *enc, const VkConditionalRenderingBeginInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_encode_VkConditionalRenderingBeginInfoEXT(struct vn_cs_encoder *enc, const VkConditionalRenderingBeginInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT });
    vn_encode_VkConditionalRenderingBeginInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkConditionalRenderingBeginInfoEXT_self(enc, val);
}

/* struct VkDeviceGroupRenderPassBeginInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self(const VkDeviceGroupRenderPassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceMask);
    size += vn_sizeof_uint32_t(&val->deviceRenderAreaCount);
    if (val->pDeviceRenderAreas) {
        size += vn_sizeof_array_size(val->deviceRenderAreaCount);
        for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            size += vn_sizeof_VkRect2D(&val->pDeviceRenderAreas[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceMask);
    vn_encode_uint32_t(enc, &val->deviceRenderAreaCount);
    if (val->pDeviceRenderAreas) {
        vn_encode_array_size(enc, val->deviceRenderAreaCount);
        for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            vn_encode_VkRect2D(enc, &val->pDeviceRenderAreas[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo(struct vn_cs_encoder *enc, const VkDeviceGroupRenderPassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO });
    vn_encode_VkDeviceGroupRenderPassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupRenderPassBeginInfo_self(enc, val);
}

/* struct VkAttachmentSampleLocationsEXT */

static inline size_t
vn_sizeof_VkAttachmentSampleLocationsEXT(const VkAttachmentSampleLocationsEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->attachmentIndex);
    size += vn_sizeof_VkSampleLocationsInfoEXT(&val->sampleLocationsInfo);
    return size;
}

static inline void
vn_encode_VkAttachmentSampleLocationsEXT(struct vn_cs_encoder *enc, const VkAttachmentSampleLocationsEXT *val)
{
    vn_encode_uint32_t(enc, &val->attachmentIndex);
    vn_encode_VkSampleLocationsInfoEXT(enc, &val->sampleLocationsInfo);
}

/* struct VkSubpassSampleLocationsEXT */

static inline size_t
vn_sizeof_VkSubpassSampleLocationsEXT(const VkSubpassSampleLocationsEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->subpassIndex);
    size += vn_sizeof_VkSampleLocationsInfoEXT(&val->sampleLocationsInfo);
    return size;
}

static inline void
vn_encode_VkSubpassSampleLocationsEXT(struct vn_cs_encoder *enc, const VkSubpassSampleLocationsEXT *val)
{
    vn_encode_uint32_t(enc, &val->subpassIndex);
    vn_encode_VkSampleLocationsInfoEXT(enc, &val->sampleLocationsInfo);
}

/* struct VkRenderPassSampleLocationsBeginInfoEXT chain */

static inline size_t
vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT_self(const VkRenderPassSampleLocationsBeginInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->attachmentInitialSampleLocationsCount);
    if (val->pAttachmentInitialSampleLocations) {
        size += vn_sizeof_array_size(val->attachmentInitialSampleLocationsCount);
        for (uint32_t i = 0; i < val->attachmentInitialSampleLocationsCount; i++)
            size += vn_sizeof_VkAttachmentSampleLocationsEXT(&val->pAttachmentInitialSampleLocations[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->postSubpassSampleLocationsCount);
    if (val->pPostSubpassSampleLocations) {
        size += vn_sizeof_array_size(val->postSubpassSampleLocationsCount);
        for (uint32_t i = 0; i < val->postSubpassSampleLocationsCount; i++)
            size += vn_sizeof_VkSubpassSampleLocationsEXT(&val->pPostSubpassSampleLocations[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT(const VkRenderPassSampleLocationsBeginInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassSampleLocationsBeginInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassSampleLocationsBeginInfoEXT_self(struct vn_cs_encoder *enc, const VkRenderPassSampleLocationsBeginInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->attachmentInitialSampleLocationsCount);
    if (val->pAttachmentInitialSampleLocations) {
        vn_encode_array_size(enc, val->attachmentInitialSampleLocationsCount);
        for (uint32_t i = 0; i < val->attachmentInitialSampleLocationsCount; i++)
            vn_encode_VkAttachmentSampleLocationsEXT(enc, &val->pAttachmentInitialSampleLocations[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->postSubpassSampleLocationsCount);
    if (val->pPostSubpassSampleLocations) {
        vn_encode_array_size(enc, val->postSubpassSampleLocationsCount);
        for (uint32_t i = 0; i < val->postSubpassSampleLocationsCount; i++)
            vn_encode_VkSubpassSampleLocationsEXT(enc, &val->pPostSubpassSampleLocations[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassSampleLocationsBeginInfoEXT(struct vn_cs_encoder *enc, const VkRenderPassSampleLocationsBeginInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT });
    vn_encode_VkRenderPassSampleLocationsBeginInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkRenderPassSampleLocationsBeginInfoEXT_self(enc, val);
}

/* struct VkRenderPassAttachmentBeginInfo chain */

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo_self(const VkRenderPassAttachmentBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkImageView(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo(const VkRenderPassAttachmentBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassAttachmentBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassAttachmentBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo_self(struct vn_cs_encoder *enc, const VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkImageView(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo(struct vn_cs_encoder *enc, const VkRenderPassAttachmentBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO });
    vn_encode_VkRenderPassAttachmentBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassAttachmentBeginInfo_self(enc, val);
}

/* struct VkRenderPassBeginInfo chain */

static inline size_t
vn_sizeof_VkRenderPassBeginInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self((const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderPassSampleLocationsBeginInfoEXT_self((const VkRenderPassSampleLocationsBeginInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderPassAttachmentBeginInfo_self((const VkRenderPassAttachmentBeginInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassBeginInfo_self(const VkRenderPassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_VkFramebuffer(&val->framebuffer);
    size += vn_sizeof_VkRect2D(&val->renderArea);
    size += vn_sizeof_uint32_t(&val->clearValueCount);
    if (val->pClearValues) {
        size += vn_sizeof_array_size(val->clearValueCount);
        for (uint32_t i = 0; i < val->clearValueCount; i++)
            size += vn_sizeof_VkClearValue(&val->pClearValues[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassBeginInfo(const VkRenderPassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupRenderPassBeginInfo_self(enc, (const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderPassSampleLocationsBeginInfoEXT_self(enc, (const VkRenderPassSampleLocationsBeginInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderPassAttachmentBeginInfo_self(enc, (const VkRenderPassAttachmentBeginInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassBeginInfo_self(struct vn_cs_encoder *enc, const VkRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_VkFramebuffer(enc, &val->framebuffer);
    vn_encode_VkRect2D(enc, &val->renderArea);
    vn_encode_uint32_t(enc, &val->clearValueCount);
    if (val->pClearValues) {
        vn_encode_array_size(enc, val->clearValueCount);
        for (uint32_t i = 0; i < val->clearValueCount; i++)
            vn_encode_VkClearValue(enc, &val->pClearValues[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassBeginInfo(struct vn_cs_encoder *enc, const VkRenderPassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO });
    vn_encode_VkRenderPassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassBeginInfo_self(enc, val);
}

/* struct VkSubpassBeginInfo chain */

static inline size_t
vn_sizeof_VkSubpassBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassBeginInfo_self(const VkSubpassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSubpassContents(&val->contents);
    return size;
}

static inline size_t
vn_sizeof_VkSubpassBeginInfo(const VkSubpassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkSubpassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassBeginInfo_self(struct vn_cs_encoder *enc, const VkSubpassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSubpassContents(enc, &val->contents);
}

static inline void
vn_encode_VkSubpassBeginInfo(struct vn_cs_encoder *enc, const VkSubpassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO });
    vn_encode_VkSubpassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkSubpassBeginInfo_self(enc, val);
}

/* struct VkSubpassEndInfo chain */

static inline size_t
vn_sizeof_VkSubpassEndInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassEndInfo_self(const VkSubpassEndInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    return size;
}

static inline size_t
vn_sizeof_VkSubpassEndInfo(const VkSubpassEndInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassEndInfo_pnext(val->pNext);
    size += vn_sizeof_VkSubpassEndInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassEndInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassEndInfo_self(struct vn_cs_encoder *enc, const VkSubpassEndInfo *val)
{
    /* skip val->{sType,pNext} */
}

static inline void
vn_encode_VkSubpassEndInfo(struct vn_cs_encoder *enc, const VkSubpassEndInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_END_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_END_INFO });
    vn_encode_VkSubpassEndInfo_pnext(enc, val->pNext);
    vn_encode_VkSubpassEndInfo_self(enc, val);
}

/* struct VkColorBlendEquationEXT */

static inline size_t
vn_sizeof_VkColorBlendEquationEXT(const VkColorBlendEquationEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBlendFactor(&val->srcColorBlendFactor);
    size += vn_sizeof_VkBlendFactor(&val->dstColorBlendFactor);
    size += vn_sizeof_VkBlendOp(&val->colorBlendOp);
    size += vn_sizeof_VkBlendFactor(&val->srcAlphaBlendFactor);
    size += vn_sizeof_VkBlendFactor(&val->dstAlphaBlendFactor);
    size += vn_sizeof_VkBlendOp(&val->alphaBlendOp);
    return size;
}

static inline void
vn_encode_VkColorBlendEquationEXT(struct vn_cs_encoder *enc, const VkColorBlendEquationEXT *val)
{
    vn_encode_VkBlendFactor(enc, &val->srcColorBlendFactor);
    vn_encode_VkBlendFactor(enc, &val->dstColorBlendFactor);
    vn_encode_VkBlendOp(enc, &val->colorBlendOp);
    vn_encode_VkBlendFactor(enc, &val->srcAlphaBlendFactor);
    vn_encode_VkBlendFactor(enc, &val->dstAlphaBlendFactor);
    vn_encode_VkBlendOp(enc, &val->alphaBlendOp);
}

/* struct VkColorBlendAdvancedEXT */

static inline size_t
vn_sizeof_VkColorBlendAdvancedEXT(const VkColorBlendAdvancedEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBlendOp(&val->advancedBlendOp);
    size += vn_sizeof_VkBool32(&val->srcPremultiplied);
    size += vn_sizeof_VkBool32(&val->dstPremultiplied);
    size += vn_sizeof_VkBlendOverlapEXT(&val->blendOverlap);
    size += vn_sizeof_VkBool32(&val->clampResults);
    return size;
}

static inline void
vn_encode_VkColorBlendAdvancedEXT(struct vn_cs_encoder *enc, const VkColorBlendAdvancedEXT *val)
{
    vn_encode_VkBlendOp(enc, &val->advancedBlendOp);
    vn_encode_VkBool32(enc, &val->srcPremultiplied);
    vn_encode_VkBool32(enc, &val->dstPremultiplied);
    vn_encode_VkBlendOverlapEXT(enc, &val->blendOverlap);
    vn_encode_VkBool32(enc, &val->clampResults);
}

/* struct VkBufferCopy2 chain */

static inline size_t
vn_sizeof_VkBufferCopy2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferCopy2_self(const VkBufferCopy2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->srcOffset);
    size += vn_sizeof_VkDeviceSize(&val->dstOffset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkBufferCopy2(const VkBufferCopy2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferCopy2_pnext(val->pNext);
    size += vn_sizeof_VkBufferCopy2_self(val);

    return size;
}

static inline void
vn_encode_VkBufferCopy2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferCopy2_self(struct vn_cs_encoder *enc, const VkBufferCopy2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->srcOffset);
    vn_encode_VkDeviceSize(enc, &val->dstOffset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

static inline void
vn_encode_VkBufferCopy2(struct vn_cs_encoder *enc, const VkBufferCopy2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_COPY_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_COPY_2 });
    vn_encode_VkBufferCopy2_pnext(enc, val->pNext);
    vn_encode_VkBufferCopy2_self(enc, val);
}

/* struct VkCopyBufferInfo2 chain */

static inline size_t
vn_sizeof_VkCopyBufferInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyBufferInfo2_self(const VkCopyBufferInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->srcBuffer);
    size += vn_sizeof_VkBuffer(&val->dstBuffer);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkBufferCopy2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyBufferInfo2(const VkCopyBufferInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyBufferInfo2_pnext(val->pNext);
    size += vn_sizeof_VkCopyBufferInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkCopyBufferInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyBufferInfo2_self(struct vn_cs_encoder *enc, const VkCopyBufferInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->srcBuffer);
    vn_encode_VkBuffer(enc, &val->dstBuffer);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkBufferCopy2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyBufferInfo2(struct vn_cs_encoder *enc, const VkCopyBufferInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2 });
    vn_encode_VkCopyBufferInfo2_pnext(enc, val->pNext);
    vn_encode_VkCopyBufferInfo2_self(enc, val);
}

/* struct VkCopyImageInfo2 chain */

static inline size_t
vn_sizeof_VkCopyImageInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyImageInfo2_self(const VkCopyImageInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkImageCopy2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyImageInfo2(const VkCopyImageInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyImageInfo2_pnext(val->pNext);
    size += vn_sizeof_VkCopyImageInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkCopyImageInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyImageInfo2_self(struct vn_cs_encoder *enc, const VkCopyImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkImageCopy2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyImageInfo2(struct vn_cs_encoder *enc, const VkCopyImageInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2 });
    vn_encode_VkCopyImageInfo2_pnext(enc, val->pNext);
    vn_encode_VkCopyImageInfo2_self(enc, val);
}

/* struct VkImageBlit2 chain */

static inline size_t
vn_sizeof_VkImageBlit2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageBlit2_self(const VkImageBlit2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->srcOffsets[i]);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->dstOffsets[i]);
    return size;
}

static inline size_t
vn_sizeof_VkImageBlit2(const VkImageBlit2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageBlit2_pnext(val->pNext);
    size += vn_sizeof_VkImageBlit2_self(val);

    return size;
}

static inline void
vn_encode_VkImageBlit2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageBlit2_self(struct vn_cs_encoder *enc, const VkImageBlit2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->srcOffsets[i]);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->dstOffsets[i]);
}

static inline void
vn_encode_VkImageBlit2(struct vn_cs_encoder *enc, const VkImageBlit2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_BLIT_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_BLIT_2 });
    vn_encode_VkImageBlit2_pnext(enc, val->pNext);
    vn_encode_VkImageBlit2_self(enc, val);
}

/* struct VkBlitImageInfo2 chain */

static inline size_t
vn_sizeof_VkBlitImageInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBlitImageInfo2_self(const VkBlitImageInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkImageBlit2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_VkFilter(&val->filter);
    return size;
}

static inline size_t
vn_sizeof_VkBlitImageInfo2(const VkBlitImageInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBlitImageInfo2_pnext(val->pNext);
    size += vn_sizeof_VkBlitImageInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkBlitImageInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBlitImageInfo2_self(struct vn_cs_encoder *enc, const VkBlitImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkImageBlit2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFilter(enc, &val->filter);
}

static inline void
vn_encode_VkBlitImageInfo2(struct vn_cs_encoder *enc, const VkBlitImageInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2 });
    vn_encode_VkBlitImageInfo2_pnext(enc, val->pNext);
    vn_encode_VkBlitImageInfo2_self(enc, val);
}

/* struct VkBufferImageCopy2 chain */

static inline size_t
vn_sizeof_VkBufferImageCopy2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferImageCopy2_self(const VkBufferImageCopy2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->bufferOffset);
    size += vn_sizeof_uint32_t(&val->bufferRowLength);
    size += vn_sizeof_uint32_t(&val->bufferImageHeight);
    size += vn_sizeof_VkImageSubresourceLayers(&val->imageSubresource);
    size += vn_sizeof_VkOffset3D(&val->imageOffset);
    size += vn_sizeof_VkExtent3D(&val->imageExtent);
    return size;
}

static inline size_t
vn_sizeof_VkBufferImageCopy2(const VkBufferImageCopy2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferImageCopy2_pnext(val->pNext);
    size += vn_sizeof_VkBufferImageCopy2_self(val);

    return size;
}

static inline void
vn_encode_VkBufferImageCopy2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferImageCopy2_self(struct vn_cs_encoder *enc, const VkBufferImageCopy2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->bufferOffset);
    vn_encode_uint32_t(enc, &val->bufferRowLength);
    vn_encode_uint32_t(enc, &val->bufferImageHeight);
    vn_encode_VkImageSubresourceLayers(enc, &val->imageSubresource);
    vn_encode_VkOffset3D(enc, &val->imageOffset);
    vn_encode_VkExtent3D(enc, &val->imageExtent);
}

static inline void
vn_encode_VkBufferImageCopy2(struct vn_cs_encoder *enc, const VkBufferImageCopy2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2 });
    vn_encode_VkBufferImageCopy2_pnext(enc, val->pNext);
    vn_encode_VkBufferImageCopy2_self(enc, val);
}

/* struct VkCopyBufferToImageInfo2 chain */

static inline size_t
vn_sizeof_VkCopyBufferToImageInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyBufferToImageInfo2_self(const VkCopyBufferToImageInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBuffer(&val->srcBuffer);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkBufferImageCopy2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyBufferToImageInfo2(const VkCopyBufferToImageInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyBufferToImageInfo2_pnext(val->pNext);
    size += vn_sizeof_VkCopyBufferToImageInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkCopyBufferToImageInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyBufferToImageInfo2_self(struct vn_cs_encoder *enc, const VkCopyBufferToImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBuffer(enc, &val->srcBuffer);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkBufferImageCopy2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyBufferToImageInfo2(struct vn_cs_encoder *enc, const VkCopyBufferToImageInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2 });
    vn_encode_VkCopyBufferToImageInfo2_pnext(enc, val->pNext);
    vn_encode_VkCopyBufferToImageInfo2_self(enc, val);
}

/* struct VkCopyImageToBufferInfo2 chain */

static inline size_t
vn_sizeof_VkCopyImageToBufferInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyImageToBufferInfo2_self(const VkCopyImageToBufferInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_VkBuffer(&val->dstBuffer);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkBufferImageCopy2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyImageToBufferInfo2(const VkCopyImageToBufferInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyImageToBufferInfo2_pnext(val->pNext);
    size += vn_sizeof_VkCopyImageToBufferInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkCopyImageToBufferInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyImageToBufferInfo2_self(struct vn_cs_encoder *enc, const VkCopyImageToBufferInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_VkBuffer(enc, &val->dstBuffer);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkBufferImageCopy2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyImageToBufferInfo2(struct vn_cs_encoder *enc, const VkCopyImageToBufferInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2 });
    vn_encode_VkCopyImageToBufferInfo2_pnext(enc, val->pNext);
    vn_encode_VkCopyImageToBufferInfo2_self(enc, val);
}

/* struct VkImageResolve2 chain */

static inline size_t
vn_sizeof_VkImageResolve2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageResolve2_self(const VkImageResolve2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_VkOffset3D(&val->srcOffset);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_VkOffset3D(&val->dstOffset);
    size += vn_sizeof_VkExtent3D(&val->extent);
    return size;
}

static inline size_t
vn_sizeof_VkImageResolve2(const VkImageResolve2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageResolve2_pnext(val->pNext);
    size += vn_sizeof_VkImageResolve2_self(val);

    return size;
}

static inline void
vn_encode_VkImageResolve2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageResolve2_self(struct vn_cs_encoder *enc, const VkImageResolve2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_VkOffset3D(enc, &val->srcOffset);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_VkOffset3D(enc, &val->dstOffset);
    vn_encode_VkExtent3D(enc, &val->extent);
}

static inline void
vn_encode_VkImageResolve2(struct vn_cs_encoder *enc, const VkImageResolve2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2 });
    vn_encode_VkImageResolve2_pnext(enc, val->pNext);
    vn_encode_VkImageResolve2_self(enc, val);
}

/* struct VkResolveImageInfo2 chain */

static inline size_t
vn_sizeof_VkResolveImageInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkResolveImageInfo2_self(const VkResolveImageInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkImageResolve2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkResolveImageInfo2(const VkResolveImageInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkResolveImageInfo2_pnext(val->pNext);
    size += vn_sizeof_VkResolveImageInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkResolveImageInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkResolveImageInfo2_self(struct vn_cs_encoder *enc, const VkResolveImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkImageResolve2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkResolveImageInfo2(struct vn_cs_encoder *enc, const VkResolveImageInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2 });
    vn_encode_VkResolveImageInfo2_pnext(enc, val->pNext);
    vn_encode_VkResolveImageInfo2_self(enc, val);
}

/* struct VkVertexInputBindingDescription2EXT chain */

static inline size_t
vn_sizeof_VkVertexInputBindingDescription2EXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkVertexInputBindingDescription2EXT_self(const VkVertexInputBindingDescription2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->binding);
    size += vn_sizeof_uint32_t(&val->stride);
    size += vn_sizeof_VkVertexInputRate(&val->inputRate);
    size += vn_sizeof_uint32_t(&val->divisor);
    return size;
}

static inline size_t
vn_sizeof_VkVertexInputBindingDescription2EXT(const VkVertexInputBindingDescription2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkVertexInputBindingDescription2EXT_pnext(val->pNext);
    size += vn_sizeof_VkVertexInputBindingDescription2EXT_self(val);

    return size;
}

static inline void
vn_encode_VkVertexInputBindingDescription2EXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkVertexInputBindingDescription2EXT_self(struct vn_cs_encoder *enc, const VkVertexInputBindingDescription2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->binding);
    vn_encode_uint32_t(enc, &val->stride);
    vn_encode_VkVertexInputRate(enc, &val->inputRate);
    vn_encode_uint32_t(enc, &val->divisor);
}

static inline void
vn_encode_VkVertexInputBindingDescription2EXT(struct vn_cs_encoder *enc, const VkVertexInputBindingDescription2EXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT });
    vn_encode_VkVertexInputBindingDescription2EXT_pnext(enc, val->pNext);
    vn_encode_VkVertexInputBindingDescription2EXT_self(enc, val);
}

/* struct VkVertexInputAttributeDescription2EXT chain */

static inline size_t
vn_sizeof_VkVertexInputAttributeDescription2EXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkVertexInputAttributeDescription2EXT_self(const VkVertexInputAttributeDescription2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->location);
    size += vn_sizeof_uint32_t(&val->binding);
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_uint32_t(&val->offset);
    return size;
}

static inline size_t
vn_sizeof_VkVertexInputAttributeDescription2EXT(const VkVertexInputAttributeDescription2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkVertexInputAttributeDescription2EXT_pnext(val->pNext);
    size += vn_sizeof_VkVertexInputAttributeDescription2EXT_self(val);

    return size;
}

static inline void
vn_encode_VkVertexInputAttributeDescription2EXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkVertexInputAttributeDescription2EXT_self(struct vn_cs_encoder *enc, const VkVertexInputAttributeDescription2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->location);
    vn_encode_uint32_t(enc, &val->binding);
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_uint32_t(enc, &val->offset);
}

static inline void
vn_encode_VkVertexInputAttributeDescription2EXT(struct vn_cs_encoder *enc, const VkVertexInputAttributeDescription2EXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT });
    vn_encode_VkVertexInputAttributeDescription2EXT_pnext(enc, val->pNext);
    vn_encode_VkVertexInputAttributeDescription2EXT_self(enc, val);
}

/* struct VkBufferMemoryBarrier2 chain */

static inline size_t
vn_sizeof_VkBufferMemoryBarrier2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBufferMemoryBarrier2_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self((const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier2_self(const VkBufferMemoryBarrier2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->srcStageMask);
    size += vn_sizeof_VkFlags64(&val->srcAccessMask);
    size += vn_sizeof_VkFlags64(&val->dstStageMask);
    size += vn_sizeof_VkFlags64(&val->dstAccessMask);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier2(const VkBufferMemoryBarrier2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferMemoryBarrier2_pnext(val->pNext);
    size += vn_sizeof_VkBufferMemoryBarrier2_self(val);

    return size;
}

static inline void
vn_encode_VkBufferMemoryBarrier2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBufferMemoryBarrier2_pnext(enc, pnext->pNext);
            vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(enc, (const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferMemoryBarrier2_self(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags64(enc, &val->srcStageMask);
    vn_encode_VkFlags64(enc, &val->srcAccessMask);
    vn_encode_VkFlags64(enc, &val->dstStageMask);
    vn_encode_VkFlags64(enc, &val->dstAccessMask);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

static inline void
vn_encode_VkBufferMemoryBarrier2(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2 });
    vn_encode_VkBufferMemoryBarrier2_pnext(enc, val->pNext);
    vn_encode_VkBufferMemoryBarrier2_self(enc, val);
}

/* struct VkImageMemoryBarrier2 chain */

static inline size_t
vn_sizeof_VkImageMemoryBarrier2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageMemoryBarrier2_pnext(pnext->pNext);
            size += vn_sizeof_VkSampleLocationsInfoEXT_self((const VkSampleLocationsInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageMemoryBarrier2_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalMemoryAcquireUnmodifiedEXT_self((const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier2_self(const VkImageMemoryBarrier2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->srcStageMask);
    size += vn_sizeof_VkFlags64(&val->srcAccessMask);
    size += vn_sizeof_VkFlags64(&val->dstStageMask);
    size += vn_sizeof_VkFlags64(&val->dstAccessMask);
    size += vn_sizeof_VkImageLayout(&val->oldLayout);
    size += vn_sizeof_VkImageLayout(&val->newLayout);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkImageSubresourceRange(&val->subresourceRange);
    return size;
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier2(const VkImageMemoryBarrier2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageMemoryBarrier2_pnext(val->pNext);
    size += vn_sizeof_VkImageMemoryBarrier2_self(val);

    return size;
}

static inline void
vn_encode_VkImageMemoryBarrier2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(144 /* VK_EXT_sample_locations */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageMemoryBarrier2_pnext(enc, pnext->pNext);
            vn_encode_VkSampleLocationsInfoEXT_self(enc, (const VkSampleLocationsInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            if (!vn_cs_renderer_protocol_has_extension(454 /* VK_EXT_external_memory_acquire_unmodified */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageMemoryBarrier2_pnext(enc, pnext->pNext);
            vn_encode_VkExternalMemoryAcquireUnmodifiedEXT_self(enc, (const VkExternalMemoryAcquireUnmodifiedEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageMemoryBarrier2_self(struct vn_cs_encoder *enc, const VkImageMemoryBarrier2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags64(enc, &val->srcStageMask);
    vn_encode_VkFlags64(enc, &val->srcAccessMask);
    vn_encode_VkFlags64(enc, &val->dstStageMask);
    vn_encode_VkFlags64(enc, &val->dstAccessMask);
    vn_encode_VkImageLayout(enc, &val->oldLayout);
    vn_encode_VkImageLayout(enc, &val->newLayout);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkImageSubresourceRange(enc, &val->subresourceRange);
}

static inline void
vn_encode_VkImageMemoryBarrier2(struct vn_cs_encoder *enc, const VkImageMemoryBarrier2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2 });
    vn_encode_VkImageMemoryBarrier2_pnext(enc, val->pNext);
    vn_encode_VkImageMemoryBarrier2_self(enc, val);
}

/* struct VkDependencyInfo chain */

static inline size_t
vn_sizeof_VkDependencyInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDependencyInfo_self(const VkDependencyInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->dependencyFlags);
    size += vn_sizeof_uint32_t(&val->memoryBarrierCount);
    if (val->pMemoryBarriers) {
        size += vn_sizeof_array_size(val->memoryBarrierCount);
        for (uint32_t i = 0; i < val->memoryBarrierCount; i++)
            size += vn_sizeof_VkMemoryBarrier2(&val->pMemoryBarriers[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->bufferMemoryBarrierCount);
    if (val->pBufferMemoryBarriers) {
        size += vn_sizeof_array_size(val->bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < val->bufferMemoryBarrierCount; i++)
            size += vn_sizeof_VkBufferMemoryBarrier2(&val->pBufferMemoryBarriers[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->imageMemoryBarrierCount);
    if (val->pImageMemoryBarriers) {
        size += vn_sizeof_array_size(val->imageMemoryBarrierCount);
        for (uint32_t i = 0; i < val->imageMemoryBarrierCount; i++)
            size += vn_sizeof_VkImageMemoryBarrier2(&val->pImageMemoryBarriers[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDependencyInfo(const VkDependencyInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDependencyInfo_pnext(val->pNext);
    size += vn_sizeof_VkDependencyInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDependencyInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDependencyInfo_self(struct vn_cs_encoder *enc, const VkDependencyInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->dependencyFlags);
    vn_encode_uint32_t(enc, &val->memoryBarrierCount);
    if (val->pMemoryBarriers) {
        vn_encode_array_size(enc, val->memoryBarrierCount);
        for (uint32_t i = 0; i < val->memoryBarrierCount; i++)
            vn_encode_VkMemoryBarrier2(enc, &val->pMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->bufferMemoryBarrierCount);
    if (val->pBufferMemoryBarriers) {
        vn_encode_array_size(enc, val->bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < val->bufferMemoryBarrierCount; i++)
            vn_encode_VkBufferMemoryBarrier2(enc, &val->pBufferMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->imageMemoryBarrierCount);
    if (val->pImageMemoryBarriers) {
        vn_encode_array_size(enc, val->imageMemoryBarrierCount);
        for (uint32_t i = 0; i < val->imageMemoryBarrierCount; i++)
            vn_encode_VkImageMemoryBarrier2(enc, &val->pImageMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDependencyInfo(struct vn_cs_encoder *enc, const VkDependencyInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEPENDENCY_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEPENDENCY_INFO });
    vn_encode_VkDependencyInfo_pnext(enc, val->pNext);
    vn_encode_VkDependencyInfo_self(enc, val);
}

/* struct VkRenderingAttachmentInfo chain */

static inline size_t
vn_sizeof_VkRenderingAttachmentInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderingAttachmentInfo_self(const VkRenderingAttachmentInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageView(&val->imageView);
    size += vn_sizeof_VkImageLayout(&val->imageLayout);
    size += vn_sizeof_VkResolveModeFlagBits(&val->resolveMode);
    size += vn_sizeof_VkImageView(&val->resolveImageView);
    size += vn_sizeof_VkImageLayout(&val->resolveImageLayout);
    size += vn_sizeof_VkAttachmentLoadOp(&val->loadOp);
    size += vn_sizeof_VkAttachmentStoreOp(&val->storeOp);
    size += vn_sizeof_VkClearValue(&val->clearValue);
    return size;
}

static inline size_t
vn_sizeof_VkRenderingAttachmentInfo(const VkRenderingAttachmentInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderingAttachmentInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderingAttachmentInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderingAttachmentInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderingAttachmentInfo_self(struct vn_cs_encoder *enc, const VkRenderingAttachmentInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageView(enc, &val->imageView);
    vn_encode_VkImageLayout(enc, &val->imageLayout);
    vn_encode_VkResolveModeFlagBits(enc, &val->resolveMode);
    vn_encode_VkImageView(enc, &val->resolveImageView);
    vn_encode_VkImageLayout(enc, &val->resolveImageLayout);
    vn_encode_VkAttachmentLoadOp(enc, &val->loadOp);
    vn_encode_VkAttachmentStoreOp(enc, &val->storeOp);
    vn_encode_VkClearValue(enc, &val->clearValue);
}

static inline void
vn_encode_VkRenderingAttachmentInfo(struct vn_cs_encoder *enc, const VkRenderingAttachmentInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO });
    vn_encode_VkRenderingAttachmentInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderingAttachmentInfo_self(enc, val);
}

/* struct VkRenderingFragmentShadingRateAttachmentInfoKHR chain */

static inline size_t
vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR_self(const VkRenderingFragmentShadingRateAttachmentInfoKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageView(&val->imageView);
    size += vn_sizeof_VkImageLayout(&val->imageLayout);
    size += vn_sizeof_VkExtent2D(&val->shadingRateAttachmentTexelSize);
    return size;
}

static inline size_t
vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR(const VkRenderingFragmentShadingRateAttachmentInfoKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR_pnext(val->pNext);
    size += vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR_self(val);

    return size;
}

static inline void
vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR_self(struct vn_cs_encoder *enc, const VkRenderingFragmentShadingRateAttachmentInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageView(enc, &val->imageView);
    vn_encode_VkImageLayout(enc, &val->imageLayout);
    vn_encode_VkExtent2D(enc, &val->shadingRateAttachmentTexelSize);
}

static inline void
vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR(struct vn_cs_encoder *enc, const VkRenderingFragmentShadingRateAttachmentInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR });
    vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR_pnext(enc, val->pNext);
    vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR_self(enc, val);
}

/* struct VkRenderingInfo chain */

static inline size_t
vn_sizeof_VkRenderingInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderingInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self((const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
            if (!(vn_cs_renderer_protocol_has_extension(227 /* VK_KHR_fragment_shading_rate */) && vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */)))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderingInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderingFragmentShadingRateAttachmentInfoKHR_self((const VkRenderingFragmentShadingRateAttachmentInfoKHR *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderingInfo_self(const VkRenderingInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkRect2D(&val->renderArea);
    size += vn_sizeof_uint32_t(&val->layerCount);
    size += vn_sizeof_uint32_t(&val->viewMask);
    size += vn_sizeof_uint32_t(&val->colorAttachmentCount);
    if (val->pColorAttachments) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            size += vn_sizeof_VkRenderingAttachmentInfo(&val->pColorAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pDepthAttachment);
    if (val->pDepthAttachment)
        size += vn_sizeof_VkRenderingAttachmentInfo(val->pDepthAttachment);
    size += vn_sizeof_simple_pointer(val->pStencilAttachment);
    if (val->pStencilAttachment)
        size += vn_sizeof_VkRenderingAttachmentInfo(val->pStencilAttachment);
    return size;
}

static inline size_t
vn_sizeof_VkRenderingInfo(const VkRenderingInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderingInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderingInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderingInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderingInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupRenderPassBeginInfo_self(enc, (const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
            if (!(vn_cs_renderer_protocol_has_extension(227 /* VK_KHR_fragment_shading_rate */) && vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */)))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderingInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderingFragmentShadingRateAttachmentInfoKHR_self(enc, (const VkRenderingFragmentShadingRateAttachmentInfoKHR *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderingInfo_self(struct vn_cs_encoder *enc, const VkRenderingInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkRect2D(enc, &val->renderArea);
    vn_encode_uint32_t(enc, &val->layerCount);
    vn_encode_uint32_t(enc, &val->viewMask);
    vn_encode_uint32_t(enc, &val->colorAttachmentCount);
    if (val->pColorAttachments) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_encode_VkRenderingAttachmentInfo(enc, &val->pColorAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pDepthAttachment))
        vn_encode_VkRenderingAttachmentInfo(enc, val->pDepthAttachment);
    if (vn_encode_simple_pointer(enc, val->pStencilAttachment))
        vn_encode_VkRenderingAttachmentInfo(enc, val->pStencilAttachment);
}

static inline void
vn_encode_VkRenderingInfo(struct vn_cs_encoder *enc, const VkRenderingInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDERING_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDERING_INFO });
    vn_encode_VkRenderingInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderingInfo_self(enc, val);
}

/* struct VkBindDescriptorSetsInfo chain */

static inline size_t
vn_sizeof_VkBindDescriptorSetsInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkBindDescriptorSetsInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPipelineLayoutCreateInfo_self((const VkPipelineLayoutCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBindDescriptorSetsInfo_self(const VkBindDescriptorSetsInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->stageFlags);
    size += vn_sizeof_VkPipelineLayout(&val->layout);
    size += vn_sizeof_uint32_t(&val->firstSet);
    size += vn_sizeof_uint32_t(&val->descriptorSetCount);
    if (val->pDescriptorSets) {
        size += vn_sizeof_array_size(val->descriptorSetCount);
        for (uint32_t i = 0; i < val->descriptorSetCount; i++)
            size += vn_sizeof_VkDescriptorSet(&val->pDescriptorSets[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->dynamicOffsetCount);
    if (val->pDynamicOffsets) {
        size += vn_sizeof_array_size(val->dynamicOffsetCount);
        size += vn_sizeof_uint32_t_array(val->pDynamicOffsets, val->dynamicOffsetCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkBindDescriptorSetsInfo(const VkBindDescriptorSetsInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBindDescriptorSetsInfo_pnext(val->pNext);
    size += vn_sizeof_VkBindDescriptorSetsInfo_self(val);

    return size;
}

static inline void
vn_encode_VkBindDescriptorSetsInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkBindDescriptorSetsInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPipelineLayoutCreateInfo_self(enc, (const VkPipelineLayoutCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBindDescriptorSetsInfo_self(struct vn_cs_encoder *enc, const VkBindDescriptorSetsInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->stageFlags);
    vn_encode_VkPipelineLayout(enc, &val->layout);
    vn_encode_uint32_t(enc, &val->firstSet);
    vn_encode_uint32_t(enc, &val->descriptorSetCount);
    if (val->pDescriptorSets) {
        vn_encode_array_size(enc, val->descriptorSetCount);
        for (uint32_t i = 0; i < val->descriptorSetCount; i++)
            vn_encode_VkDescriptorSet(enc, &val->pDescriptorSets[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->dynamicOffsetCount);
    if (val->pDynamicOffsets) {
        vn_encode_array_size(enc, val->dynamicOffsetCount);
        vn_encode_uint32_t_array(enc, val->pDynamicOffsets, val->dynamicOffsetCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkBindDescriptorSetsInfo(struct vn_cs_encoder *enc, const VkBindDescriptorSetsInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO });
    vn_encode_VkBindDescriptorSetsInfo_pnext(enc, val->pNext);
    vn_encode_VkBindDescriptorSetsInfo_self(enc, val);
}

/* struct VkPushConstantsInfo chain */

static inline size_t
vn_sizeof_VkPushConstantsInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPushConstantsInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPipelineLayoutCreateInfo_self((const VkPipelineLayoutCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPushConstantsInfo_self(const VkPushConstantsInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPipelineLayout(&val->layout);
    size += vn_sizeof_VkFlags(&val->stageFlags);
    size += vn_sizeof_uint32_t(&val->offset);
    size += vn_sizeof_uint32_t(&val->size);
    if (val->pValues) {
        size += vn_sizeof_array_size(val->size);
        size += vn_sizeof_blob_array(val->pValues, val->size);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPushConstantsInfo(const VkPushConstantsInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPushConstantsInfo_pnext(val->pNext);
    size += vn_sizeof_VkPushConstantsInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPushConstantsInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPushConstantsInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPipelineLayoutCreateInfo_self(enc, (const VkPipelineLayoutCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPushConstantsInfo_self(struct vn_cs_encoder *enc, const VkPushConstantsInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPipelineLayout(enc, &val->layout);
    vn_encode_VkFlags(enc, &val->stageFlags);
    vn_encode_uint32_t(enc, &val->offset);
    vn_encode_uint32_t(enc, &val->size);
    if (val->pValues) {
        vn_encode_array_size(enc, val->size);
        vn_encode_blob_array(enc, val->pValues, val->size);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPushConstantsInfo(struct vn_cs_encoder *enc, const VkPushConstantsInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO });
    vn_encode_VkPushConstantsInfo_pnext(enc, val->pNext);
    vn_encode_VkPushConstantsInfo_self(enc, val);
}

/* struct VkPushDescriptorSetInfo chain */

static inline size_t
vn_sizeof_VkPushDescriptorSetInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPushDescriptorSetInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPipelineLayoutCreateInfo_self((const VkPipelineLayoutCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPushDescriptorSetInfo_self(const VkPushDescriptorSetInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->stageFlags);
    size += vn_sizeof_VkPipelineLayout(&val->layout);
    size += vn_sizeof_uint32_t(&val->set);
    size += vn_sizeof_uint32_t(&val->descriptorWriteCount);
    if (val->pDescriptorWrites) {
        size += vn_sizeof_array_size(val->descriptorWriteCount);
        for (uint32_t i = 0; i < val->descriptorWriteCount; i++)
            size += vn_sizeof_VkWriteDescriptorSet(&val->pDescriptorWrites[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPushDescriptorSetInfo(const VkPushDescriptorSetInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPushDescriptorSetInfo_pnext(val->pNext);
    size += vn_sizeof_VkPushDescriptorSetInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPushDescriptorSetInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPushDescriptorSetInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPipelineLayoutCreateInfo_self(enc, (const VkPipelineLayoutCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPushDescriptorSetInfo_self(struct vn_cs_encoder *enc, const VkPushDescriptorSetInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->stageFlags);
    vn_encode_VkPipelineLayout(enc, &val->layout);
    vn_encode_uint32_t(enc, &val->set);
    vn_encode_uint32_t(enc, &val->descriptorWriteCount);
    if (val->pDescriptorWrites) {
        vn_encode_array_size(enc, val->descriptorWriteCount);
        for (uint32_t i = 0; i < val->descriptorWriteCount; i++)
            vn_encode_VkWriteDescriptorSet(enc, &val->pDescriptorWrites[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPushDescriptorSetInfo(struct vn_cs_encoder *enc, const VkPushDescriptorSetInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO });
    vn_encode_VkPushDescriptorSetInfo_pnext(enc, val->pNext);
    vn_encode_VkPushDescriptorSetInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkAllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pAllocateInfo);
    if (pAllocateInfo)
        cmd_size += vn_sizeof_VkCommandBufferAllocateInfo(pAllocateInfo);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size((pAllocateInfo ? pAllocateInfo->commandBufferCount : 0));
        for (uint32_t i = 0; i < (pAllocateInfo ? pAllocateInfo->commandBufferCount : 0); i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkAllocateCommandBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pAllocateInfo))
        vn_encode_VkCommandBufferAllocateInfo(enc, pAllocateInfo);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, (pAllocateInfo ? pAllocateInfo->commandBufferCount : 0));
        for (uint32_t i = 0; i < (pAllocateInfo ? pAllocateInfo->commandBufferCount : 0); i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkAllocateCommandBuffers_reply(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pAllocateInfo */
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size((pAllocateInfo ? pAllocateInfo->commandBufferCount : 0));
        for (uint32_t i = 0; i < (pAllocateInfo ? pAllocateInfo->commandBufferCount : 0); i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkAllocateCommandBuffers_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pAllocateInfo */
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pAllocateInfo ? pAllocateInfo->commandBufferCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkCommandBuffer(dec, &pCommandBuffers[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pCommandBuffers = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkFreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkCommandPool(&commandPool);
    cmd_size += vn_sizeof_uint32_t(&commandBufferCount);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkFreeCommandBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkCommandPool(enc, &commandPool);
    vn_encode_uint32_t(enc, &commandBufferCount);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkFreeCommandBuffers_reply(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip commandPool */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */

    return cmd_size;
}

static inline void vn_decode_vkFreeCommandBuffers_reply(struct vn_cs_decoder *dec, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT);

    /* skip device */
    /* skip commandPool */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */
}

static inline size_t vn_sizeof_vkBeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pBeginInfo);
    if (pBeginInfo)
        cmd_size += vn_sizeof_VkCommandBufferBeginInfo(pBeginInfo);

    return cmd_size;
}

static inline void vn_encode_vkBeginCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pBeginInfo))
        vn_encode_VkCommandBufferBeginInfo(enc, pBeginInfo);
}

static inline size_t vn_sizeof_vkBeginCommandBuffer_reply(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */
    /* skip pBeginInfo */

    return cmd_size;
}

static inline VkResult vn_decode_vkBeginCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */
    /* skip pBeginInfo */

    return ret;
}

static inline size_t vn_sizeof_vkEndCommandBuffer(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkEndCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkEndCommandBuffer_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */

    return cmd_size;
}

static inline VkResult vn_decode_vkEndCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEndCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */

    return ret;
}

static inline size_t vn_sizeof_vkResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkResetCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkResetCommandBuffer_reply(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */
    /* skip flags */

    return cmd_size;
}

static inline VkResult vn_decode_vkResetCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkResetCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */
    /* skip flags */

    return ret;
}

static inline size_t vn_sizeof_vkCmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineBindPoint(&pipelineBindPoint);
    cmd_size += vn_sizeof_VkPipeline(&pipeline);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindPipeline(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineBindPoint(enc, &pipelineBindPoint);
    vn_encode_VkPipeline(enc, &pipeline);
}

static inline size_t vn_sizeof_vkCmdBindPipeline_reply(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip pipeline */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindPipeline_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindPipeline_EXT);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip pipeline */
}

static inline size_t vn_sizeof_vkCmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstViewport);
    cmd_size += vn_sizeof_uint32_t(&viewportCount);
    if (pViewports) {
        cmd_size += vn_sizeof_array_size(viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            cmd_size += vn_sizeof_VkViewport(&pViewports[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetViewport(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstViewport);
    vn_encode_uint32_t(enc, &viewportCount);
    if (pViewports) {
        vn_encode_array_size(enc, viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            vn_encode_VkViewport(enc, &pViewports[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetViewport_reply(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstViewport */
    /* skip viewportCount */
    /* skip pViewports */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetViewport_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetViewport_EXT);

    /* skip commandBuffer */
    /* skip firstViewport */
    /* skip viewportCount */
    /* skip pViewports */
}

static inline size_t vn_sizeof_vkCmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstScissor);
    cmd_size += vn_sizeof_uint32_t(&scissorCount);
    if (pScissors) {
        cmd_size += vn_sizeof_array_size(scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            cmd_size += vn_sizeof_VkRect2D(&pScissors[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetScissor(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstScissor);
    vn_encode_uint32_t(enc, &scissorCount);
    if (pScissors) {
        vn_encode_array_size(enc, scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            vn_encode_VkRect2D(enc, &pScissors[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetScissor_reply(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstScissor */
    /* skip scissorCount */
    /* skip pScissors */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetScissor_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetScissor_EXT);

    /* skip commandBuffer */
    /* skip firstScissor */
    /* skip scissorCount */
    /* skip pScissors */
}

static inline size_t vn_sizeof_vkCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&lineWidth);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLineWidth(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &lineWidth);
}

static inline size_t vn_sizeof_vkCmdSetLineWidth_reply(VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip lineWidth */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLineWidth_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float lineWidth)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT);

    /* skip commandBuffer */
    /* skip lineWidth */
}

static inline size_t vn_sizeof_vkCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&depthBiasConstantFactor);
    cmd_size += vn_sizeof_float(&depthBiasClamp);
    cmd_size += vn_sizeof_float(&depthBiasSlopeFactor);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBias(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &depthBiasConstantFactor);
    vn_encode_float(enc, &depthBiasClamp);
    vn_encode_float(enc, &depthBiasSlopeFactor);
}

static inline size_t vn_sizeof_vkCmdSetDepthBias_reply(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthBiasConstantFactor */
    /* skip depthBiasClamp */
    /* skip depthBiasSlopeFactor */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBias_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT);

    /* skip commandBuffer */
    /* skip depthBiasConstantFactor */
    /* skip depthBiasClamp */
    /* skip depthBiasSlopeFactor */
}

static inline size_t vn_sizeof_vkCmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_array_size(4);
    cmd_size += vn_sizeof_float_array(blendConstants, 4);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetBlendConstants(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_array_size(enc, 4);
    vn_encode_float_array(enc, blendConstants, 4);
}

static inline size_t vn_sizeof_vkCmdSetBlendConstants_reply(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip blendConstants */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetBlendConstants_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT);

    /* skip commandBuffer */
    /* skip blendConstants */
}

static inline size_t vn_sizeof_vkCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&minDepthBounds);
    cmd_size += vn_sizeof_float(&maxDepthBounds);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBounds(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &minDepthBounds);
    vn_encode_float(enc, &maxDepthBounds);
}

static inline size_t vn_sizeof_vkCmdSetDepthBounds_reply(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip minDepthBounds */
    /* skip maxDepthBounds */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBounds_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT);

    /* skip commandBuffer */
    /* skip minDepthBounds */
    /* skip maxDepthBounds */
}

static inline size_t vn_sizeof_vkCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&compareMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilCompareMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &compareMask);
}

static inline size_t vn_sizeof_vkCmdSetStencilCompareMask_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip compareMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilCompareMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip compareMask */
}

static inline size_t vn_sizeof_vkCmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&writeMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilWriteMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &writeMask);
}

static inline size_t vn_sizeof_vkCmdSetStencilWriteMask_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip writeMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilWriteMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip writeMask */
}

static inline size_t vn_sizeof_vkCmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&reference);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilReference(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &reference);
}

static inline size_t vn_sizeof_vkCmdSetStencilReference_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip reference */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilReference_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip reference */
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineBindPoint(&pipelineBindPoint);
    cmd_size += vn_sizeof_VkPipelineLayout(&layout);
    cmd_size += vn_sizeof_uint32_t(&firstSet);
    cmd_size += vn_sizeof_uint32_t(&descriptorSetCount);
    if (pDescriptorSets) {
        cmd_size += vn_sizeof_array_size(descriptorSetCount);
        for (uint32_t i = 0; i < descriptorSetCount; i++)
            cmd_size += vn_sizeof_VkDescriptorSet(&pDescriptorSets[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&dynamicOffsetCount);
    if (pDynamicOffsets) {
        cmd_size += vn_sizeof_array_size(dynamicOffsetCount);
        cmd_size += vn_sizeof_uint32_t_array(pDynamicOffsets, dynamicOffsetCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindDescriptorSets(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineBindPoint(enc, &pipelineBindPoint);
    vn_encode_VkPipelineLayout(enc, &layout);
    vn_encode_uint32_t(enc, &firstSet);
    vn_encode_uint32_t(enc, &descriptorSetCount);
    if (pDescriptorSets) {
        vn_encode_array_size(enc, descriptorSetCount);
        for (uint32_t i = 0; i < descriptorSetCount; i++)
            vn_encode_VkDescriptorSet(enc, &pDescriptorSets[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &dynamicOffsetCount);
    if (pDynamicOffsets) {
        vn_encode_array_size(enc, dynamicOffsetCount);
        vn_encode_uint32_t_array(enc, pDynamicOffsets, dynamicOffsetCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets_reply(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip firstSet */
    /* skip descriptorSetCount */
    /* skip pDescriptorSets */
    /* skip dynamicOffsetCount */
    /* skip pDynamicOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindDescriptorSets_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip firstSet */
    /* skip descriptorSetCount */
    /* skip pDescriptorSets */
    /* skip dynamicOffsetCount */
    /* skip pDynamicOffsets */
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkIndexType(&indexType);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindIndexBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkIndexType(enc, &indexType);
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip indexType */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindIndexBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip indexType */
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstBinding);
    cmd_size += vn_sizeof_uint32_t(&bindingCount);
    if (pBuffers) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pOffsets) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pOffsets, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindVertexBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstBinding);
    vn_encode_uint32_t(enc, &bindingCount);
    if (pBuffers) {
        vn_encode_array_size(enc, bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            vn_encode_VkBuffer(enc, &pBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pOffsets) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pOffsets, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers_reply(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindVertexBuffers_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
}

static inline size_t vn_sizeof_vkCmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&vertexCount);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstVertex);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);

    return cmd_size;
}

static inline void vn_encode_vkCmdDraw(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &vertexCount);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstVertex);
    vn_encode_uint32_t(enc, &firstInstance);
}

static inline size_t vn_sizeof_vkCmdDraw_reply(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip vertexCount */
    /* skip instanceCount */
    /* skip firstVertex */
    /* skip firstInstance */

    return cmd_size;
}

static inline void vn_decode_vkCmdDraw_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDraw_EXT);

    /* skip commandBuffer */
    /* skip vertexCount */
    /* skip instanceCount */
    /* skip firstVertex */
    /* skip firstInstance */
}

static inline size_t vn_sizeof_vkCmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&indexCount);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstIndex);
    cmd_size += vn_sizeof_int32_t(&vertexOffset);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexed(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &indexCount);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstIndex);
    vn_encode_int32_t(enc, &vertexOffset);
    vn_encode_uint32_t(enc, &firstInstance);
}

static inline size_t vn_sizeof_vkCmdDrawIndexed_reply(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip indexCount */
    /* skip instanceCount */
    /* skip firstIndex */
    /* skip vertexOffset */
    /* skip firstInstance */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexed_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT);

    /* skip commandBuffer */
    /* skip indexCount */
    /* skip instanceCount */
    /* skip firstIndex */
    /* skip vertexOffset */
    /* skip firstInstance */
}

static inline size_t vn_sizeof_vkCmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    if (pVertexInfo) {
        cmd_size += vn_sizeof_array_size(drawCount);
        for (uint32_t i = 0; i < drawCount; i++)
            cmd_size += vn_sizeof_VkMultiDrawInfoEXT(&pVertexInfo[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawMultiEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &drawCount);
    if (pVertexInfo) {
        vn_encode_array_size(enc, drawCount);
        for (uint32_t i = 0; i < drawCount; i++)
            vn_encode_VkMultiDrawInfoEXT(enc, (void *)pVertexInfo + stride * i);
    } else {
        vn_encode_array_size(enc, 0);
    }
    stride = sizeof(VkMultiDrawInfoEXT);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstInstance);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawMultiEXT_reply(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip drawCount */
    /* skip pVertexInfo */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawMultiEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT);

    /* skip commandBuffer */
    /* skip drawCount */
    /* skip pVertexInfo */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    if (pIndexInfo) {
        cmd_size += vn_sizeof_array_size(drawCount);
        for (uint32_t i = 0; i < drawCount; i++)
            cmd_size += vn_sizeof_VkMultiDrawIndexedInfoEXT(&pIndexInfo[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);
    cmd_size += vn_sizeof_uint32_t(&stride);
    cmd_size += vn_sizeof_simple_pointer(pVertexOffset);
    if (pVertexOffset)
        cmd_size += vn_sizeof_int32_t(pVertexOffset);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawMultiIndexedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &drawCount);
    if (pIndexInfo) {
        vn_encode_array_size(enc, drawCount);
        for (uint32_t i = 0; i < drawCount; i++)
            vn_encode_VkMultiDrawIndexedInfoEXT(enc, (void *)pIndexInfo + stride * i);
    } else {
        vn_encode_array_size(enc, 0);
    }
    stride = sizeof(VkMultiDrawIndexedInfoEXT);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstInstance);
    vn_encode_uint32_t(enc, &stride);
    if (vn_encode_simple_pointer(enc, pVertexOffset))
        vn_encode_int32_t(enc, pVertexOffset);
}

static inline size_t vn_sizeof_vkCmdDrawMultiIndexedEXT_reply(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip drawCount */
    /* skip pIndexInfo */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip stride */
    /* skip pVertexOffset */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawMultiIndexedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT);

    /* skip commandBuffer */
    /* skip drawCount */
    /* skip pIndexInfo */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip stride */
    /* skip pVertexOffset */
}

static inline size_t vn_sizeof_vkCmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_uint32_t(enc, &drawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexedIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_uint32_t(enc, &drawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexedIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&groupCountX);
    cmd_size += vn_sizeof_uint32_t(&groupCountY);
    cmd_size += vn_sizeof_uint32_t(&groupCountZ);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatch(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &groupCountX);
    vn_encode_uint32_t(enc, &groupCountY);
    vn_encode_uint32_t(enc, &groupCountZ);
}

static inline size_t vn_sizeof_vkCmdDispatch_reply(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatch_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatch_EXT);

    /* skip commandBuffer */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */
}

static inline size_t vn_sizeof_vkCmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatchIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
}

static inline size_t vn_sizeof_vkCmdDispatchIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatchIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
}

static inline size_t vn_sizeof_vkCmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&srcBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &srcBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageBlit(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkFilter(&filter);

    return cmd_size;
}

static inline void vn_encode_vkCmdBlitImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageBlit(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFilter(enc, &filter);
}

static inline size_t vn_sizeof_vkCmdBlitImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
    /* skip filter */

    return cmd_size;
}

static inline void vn_decode_vkCmdBlitImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBlitImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
    /* skip filter */
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&srcBuffer);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBufferToImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &srcBuffer);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage_reply(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBufferToImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImageToBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImageToBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&dataSize);
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdUpdateBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &dataSize);
    if (pData) {
        vn_encode_array_size(enc, dataSize);
        vn_encode_blob_array(enc, pData, dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdUpdateBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip dataSize */
    /* skip pData */

    return cmd_size;
}

static inline void vn_decode_vkCmdUpdateBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip dataSize */
    /* skip pData */
}

static inline size_t vn_sizeof_vkCmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&size);
    cmd_size += vn_sizeof_uint32_t(&data);

    return cmd_size;
}

static inline void vn_encode_vkCmdFillBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &size);
    vn_encode_uint32_t(enc, &data);
}

static inline size_t vn_sizeof_vkCmdFillBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip size */
    /* skip data */

    return cmd_size;
}

static inline void vn_decode_vkCmdFillBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdFillBuffer_EXT);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip size */
    /* skip data */
}

static inline size_t vn_sizeof_vkCmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_VkImageLayout(&imageLayout);
    cmd_size += vn_sizeof_simple_pointer(pColor);
    if (pColor)
        cmd_size += vn_sizeof_VkClearColorValue(pColor);
    cmd_size += vn_sizeof_uint32_t(&rangeCount);
    if (pRanges) {
        cmd_size += vn_sizeof_array_size(rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            cmd_size += vn_sizeof_VkImageSubresourceRange(&pRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearColorImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &image);
    vn_encode_VkImageLayout(enc, &imageLayout);
    if (vn_encode_simple_pointer(enc, pColor))
        vn_encode_VkClearColorValue(enc, pColor);
    vn_encode_uint32_t(enc, &rangeCount);
    if (pRanges) {
        vn_encode_array_size(enc, rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            vn_encode_VkImageSubresourceRange(enc, &pRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearColorImage_reply(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pColor */
    /* skip rangeCount */
    /* skip pRanges */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearColorImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearColorImage_EXT);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pColor */
    /* skip rangeCount */
    /* skip pRanges */
}

static inline size_t vn_sizeof_vkCmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_VkImageLayout(&imageLayout);
    cmd_size += vn_sizeof_simple_pointer(pDepthStencil);
    if (pDepthStencil)
        cmd_size += vn_sizeof_VkClearDepthStencilValue(pDepthStencil);
    cmd_size += vn_sizeof_uint32_t(&rangeCount);
    if (pRanges) {
        cmd_size += vn_sizeof_array_size(rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            cmd_size += vn_sizeof_VkImageSubresourceRange(&pRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearDepthStencilImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &image);
    vn_encode_VkImageLayout(enc, &imageLayout);
    if (vn_encode_simple_pointer(enc, pDepthStencil))
        vn_encode_VkClearDepthStencilValue(enc, pDepthStencil);
    vn_encode_uint32_t(enc, &rangeCount);
    if (pRanges) {
        vn_encode_array_size(enc, rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            vn_encode_VkImageSubresourceRange(enc, &pRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearDepthStencilImage_reply(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pDepthStencil */
    /* skip rangeCount */
    /* skip pRanges */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearDepthStencilImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pDepthStencil */
    /* skip rangeCount */
    /* skip pRanges */
}

static inline size_t vn_sizeof_vkCmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pAttachments) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            cmd_size += vn_sizeof_VkClearAttachment(&pAttachments[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&rectCount);
    if (pRects) {
        cmd_size += vn_sizeof_array_size(rectCount);
        for (uint32_t i = 0; i < rectCount; i++)
            cmd_size += vn_sizeof_VkClearRect(&pRects[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearAttachments(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pAttachments) {
        vn_encode_array_size(enc, attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            vn_encode_VkClearAttachment(enc, &pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &rectCount);
    if (pRects) {
        vn_encode_array_size(enc, rectCount);
        for (uint32_t i = 0; i < rectCount; i++)
            vn_encode_VkClearRect(enc, &pRects[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearAttachments_reply(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pAttachments */
    /* skip rectCount */
    /* skip pRects */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearAttachments_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearAttachments_EXT);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pAttachments */
    /* skip rectCount */
    /* skip pRects */
}

static inline size_t vn_sizeof_vkCmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageResolve(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdResolveImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageResolve(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdResolveImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdResolveImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResolveImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_VkFlags(&stageMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetEvent(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    vn_encode_VkFlags(enc, &stageMask);
}

static inline size_t vn_sizeof_vkCmdSetEvent_reply(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetEvent_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetEvent_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */
}

static inline size_t vn_sizeof_vkCmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_VkFlags(&stageMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdResetEvent(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    vn_encode_VkFlags(enc, &stageMask);
}

static inline size_t vn_sizeof_vkCmdResetEvent_reply(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdResetEvent_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResetEvent_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */
}

static inline size_t vn_sizeof_vkCmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&eventCount);
    if (pEvents) {
        cmd_size += vn_sizeof_array_size(eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            cmd_size += vn_sizeof_VkEvent(&pEvents[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkFlags(&srcStageMask);
    cmd_size += vn_sizeof_VkFlags(&dstStageMask);
    cmd_size += vn_sizeof_uint32_t(&memoryBarrierCount);
    if (pMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkMemoryBarrier(&pMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkBufferMemoryBarrier(&pBufferMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkImageMemoryBarrier(&pImageMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdWaitEvents(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &eventCount);
    if (pEvents) {
        vn_encode_array_size(enc, eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            vn_encode_VkEvent(enc, &pEvents[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFlags(enc, &srcStageMask);
    vn_encode_VkFlags(enc, &dstStageMask);
    vn_encode_uint32_t(enc, &memoryBarrierCount);
    if (pMemoryBarriers) {
        vn_encode_array_size(enc, memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            vn_encode_VkMemoryBarrier(enc, &pMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        vn_encode_array_size(enc, bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            vn_encode_VkBufferMemoryBarrier(enc, &pBufferMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        vn_encode_array_size(enc, imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            vn_encode_VkImageMemoryBarrier(enc, &pImageMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdWaitEvents_reply(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */

    return cmd_size;
}

static inline void vn_decode_vkCmdWaitEvents_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWaitEvents_EXT);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&srcStageMask);
    cmd_size += vn_sizeof_VkFlags(&dstStageMask);
    cmd_size += vn_sizeof_VkFlags(&dependencyFlags);
    cmd_size += vn_sizeof_uint32_t(&memoryBarrierCount);
    if (pMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkMemoryBarrier(&pMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkBufferMemoryBarrier(&pBufferMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkImageMemoryBarrier(&pImageMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdPipelineBarrier(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &srcStageMask);
    vn_encode_VkFlags(enc, &dstStageMask);
    vn_encode_VkFlags(enc, &dependencyFlags);
    vn_encode_uint32_t(enc, &memoryBarrierCount);
    if (pMemoryBarriers) {
        vn_encode_array_size(enc, memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            vn_encode_VkMemoryBarrier(enc, &pMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        vn_encode_array_size(enc, bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            vn_encode_VkBufferMemoryBarrier(enc, &pBufferMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        vn_encode_array_size(enc, imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            vn_encode_VkImageMemoryBarrier(enc, &pImageMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier_reply(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip dependencyFlags */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */

    return cmd_size;
}

static inline void vn_decode_vkCmdPipelineBarrier_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT);

    /* skip commandBuffer */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip dependencyFlags */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */
}

static inline size_t vn_sizeof_vkCmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginQuery(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkCmdBeginQuery_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginQuery_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginQuery_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
}

static inline size_t vn_sizeof_vkCmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndQuery(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
}

static inline size_t vn_sizeof_vkCmdEndQuery_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndQuery_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndQuery_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
}

static inline size_t vn_sizeof_vkCmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pConditionalRenderingBegin);
    if (pConditionalRenderingBegin)
        cmd_size += vn_sizeof_VkConditionalRenderingBeginInfoEXT(pConditionalRenderingBegin);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginConditionalRenderingEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pConditionalRenderingBegin))
        vn_encode_VkConditionalRenderingBeginInfoEXT(enc, pConditionalRenderingBegin);
}

static inline size_t vn_sizeof_vkCmdBeginConditionalRenderingEXT_reply(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pConditionalRenderingBegin */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginConditionalRenderingEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT);

    /* skip commandBuffer */
    /* skip pConditionalRenderingBegin */
}

static inline size_t vn_sizeof_vkCmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndConditionalRenderingEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkCmdEndConditionalRenderingEXT_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndConditionalRenderingEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT);

    /* skip commandBuffer */
}

static inline size_t vn_sizeof_vkCmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&firstQuery);
    cmd_size += vn_sizeof_uint32_t(&queryCount);

    return cmd_size;
}

static inline void vn_encode_vkCmdResetQueryPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &firstQuery);
    vn_encode_uint32_t(enc, &queryCount);
}

static inline size_t vn_sizeof_vkCmdResetQueryPool_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */

    return cmd_size;
}

static inline void vn_decode_vkCmdResetQueryPool_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineStageFlagBits(&pipelineStage);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);

    return cmd_size;
}

static inline void vn_encode_vkCmdWriteTimestamp(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineStageFlagBits(enc, &pipelineStage);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp_reply(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineStage */
    /* skip queryPool */
    /* skip query */

    return cmd_size;
}

static inline void vn_decode_vkCmdWriteTimestamp_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT);

    /* skip commandBuffer */
    /* skip pipelineStage */
    /* skip queryPool */
    /* skip query */
}

static inline size_t vn_sizeof_vkCmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&firstQuery);
    cmd_size += vn_sizeof_uint32_t(&queryCount);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&stride);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyQueryPoolResults(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &firstQuery);
    vn_encode_uint32_t(enc, &queryCount);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &stride);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkCmdCopyQueryPoolResults_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip stride */
    /* skip flags */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyQueryPoolResults_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip stride */
    /* skip flags */
}

static inline size_t vn_sizeof_vkCmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineLayout(&layout);
    cmd_size += vn_sizeof_VkFlags(&stageFlags);
    cmd_size += vn_sizeof_uint32_t(&offset);
    cmd_size += vn_sizeof_uint32_t(&size);
    if (pValues) {
        cmd_size += vn_sizeof_array_size(size);
        cmd_size += vn_sizeof_blob_array(pValues, size);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdPushConstants(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineLayout(enc, &layout);
    vn_encode_VkFlags(enc, &stageFlags);
    vn_encode_uint32_t(enc, &offset);
    vn_encode_uint32_t(enc, &size);
    if (pValues) {
        vn_encode_array_size(enc, size);
        vn_encode_blob_array(enc, pValues, size);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdPushConstants_reply(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip layout */
    /* skip stageFlags */
    /* skip offset */
    /* skip size */
    /* skip pValues */

    return cmd_size;
}

static inline void vn_decode_vkCmdPushConstants_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPushConstants_EXT);

    /* skip commandBuffer */
    /* skip layout */
    /* skip stageFlags */
    /* skip offset */
    /* skip size */
    /* skip pValues */
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pRenderPassBegin);
    if (pRenderPassBegin)
        cmd_size += vn_sizeof_VkRenderPassBeginInfo(pRenderPassBegin);
    cmd_size += vn_sizeof_VkSubpassContents(&contents);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pRenderPassBegin))
        vn_encode_VkRenderPassBeginInfo(enc, pRenderPassBegin);
    vn_encode_VkSubpassContents(enc, &contents);
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass_reply(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip contents */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginRenderPass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip contents */
}

static inline size_t vn_sizeof_vkCmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkSubpassContents(&contents);

    return cmd_size;
}

static inline void vn_encode_vkCmdNextSubpass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkSubpassContents(enc, &contents);
}

static inline size_t vn_sizeof_vkCmdNextSubpass_reply(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip contents */

    return cmd_size;
}

static inline void vn_decode_vkCmdNextSubpass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdNextSubpass_EXT);

    /* skip commandBuffer */
    /* skip contents */
}

static inline size_t vn_sizeof_vkCmdEndRenderPass(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkCmdEndRenderPass_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndRenderPass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT);

    /* skip commandBuffer */
}

static inline size_t vn_sizeof_vkCmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&commandBufferCount);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdExecuteCommands(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &commandBufferCount);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdExecuteCommands_reply(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */

    return cmd_size;
}

static inline void vn_decode_vkCmdExecuteCommands_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT);

    /* skip commandBuffer */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */
}

static inline size_t vn_sizeof_vkCmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineBindPoint(&pipelineBindPoint);
    cmd_size += vn_sizeof_VkPipelineLayout(&layout);
    cmd_size += vn_sizeof_uint32_t(&set);
    cmd_size += vn_sizeof_uint32_t(&descriptorWriteCount);
    if (pDescriptorWrites) {
        cmd_size += vn_sizeof_array_size(descriptorWriteCount);
        for (uint32_t i = 0; i < descriptorWriteCount; i++)
            cmd_size += vn_sizeof_VkWriteDescriptorSet(&pDescriptorWrites[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdPushDescriptorSet(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineBindPoint(enc, &pipelineBindPoint);
    vn_encode_VkPipelineLayout(enc, &layout);
    vn_encode_uint32_t(enc, &set);
    vn_encode_uint32_t(enc, &descriptorWriteCount);
    if (pDescriptorWrites) {
        vn_encode_array_size(enc, descriptorWriteCount);
        for (uint32_t i = 0; i < descriptorWriteCount; i++)
            vn_encode_VkWriteDescriptorSet(enc, &pDescriptorWrites[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdPushDescriptorSet_reply(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip set */
    /* skip descriptorWriteCount */
    /* skip pDescriptorWrites */

    return cmd_size;
}

static inline void vn_decode_vkCmdPushDescriptorSet_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPushDescriptorSet_EXT);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip set */
    /* skip descriptorWriteCount */
    /* skip pDescriptorWrites */
}

static inline size_t vn_sizeof_vkCmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&deviceMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDeviceMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &deviceMask);
}

static inline size_t vn_sizeof_vkCmdSetDeviceMask_reply(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip deviceMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDeviceMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT);

    /* skip commandBuffer */
    /* skip deviceMask */
}

static inline size_t vn_sizeof_vkCmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&baseGroupX);
    cmd_size += vn_sizeof_uint32_t(&baseGroupY);
    cmd_size += vn_sizeof_uint32_t(&baseGroupZ);
    cmd_size += vn_sizeof_uint32_t(&groupCountX);
    cmd_size += vn_sizeof_uint32_t(&groupCountY);
    cmd_size += vn_sizeof_uint32_t(&groupCountZ);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatchBase(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &baseGroupX);
    vn_encode_uint32_t(enc, &baseGroupY);
    vn_encode_uint32_t(enc, &baseGroupZ);
    vn_encode_uint32_t(enc, &groupCountX);
    vn_encode_uint32_t(enc, &groupCountY);
    vn_encode_uint32_t(enc, &groupCountZ);
}

static inline size_t vn_sizeof_vkCmdDispatchBase_reply(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip baseGroupX */
    /* skip baseGroupY */
    /* skip baseGroupZ */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatchBase_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatchBase_EXT);

    /* skip commandBuffer */
    /* skip baseGroupX */
    /* skip baseGroupY */
    /* skip baseGroupZ */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */
}

static inline size_t vn_sizeof_vkCmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pSampleLocationsInfo);
    if (pSampleLocationsInfo)
        cmd_size += vn_sizeof_VkSampleLocationsInfoEXT(pSampleLocationsInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetSampleLocationsEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pSampleLocationsInfo))
        vn_encode_VkSampleLocationsInfoEXT(enc, pSampleLocationsInfo);
}

static inline size_t vn_sizeof_vkCmdSetSampleLocationsEXT_reply(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pSampleLocationsInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetSampleLocationsEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetSampleLocationsEXT_EXT);

    /* skip commandBuffer */
    /* skip pSampleLocationsInfo */
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pRenderPassBegin);
    if (pRenderPassBegin)
        cmd_size += vn_sizeof_VkRenderPassBeginInfo(pRenderPassBegin);
    cmd_size += vn_sizeof_simple_pointer(pSubpassBeginInfo);
    if (pSubpassBeginInfo)
        cmd_size += vn_sizeof_VkSubpassBeginInfo(pSubpassBeginInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginRenderPass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pRenderPassBegin))
        vn_encode_VkRenderPassBeginInfo(enc, pRenderPassBegin);
    if (vn_encode_simple_pointer(enc, pSubpassBeginInfo))
        vn_encode_VkSubpassBeginInfo(enc, pSubpassBeginInfo);
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass2_reply(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip pSubpassBeginInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginRenderPass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip pSubpassBeginInfo */
}

static inline size_t vn_sizeof_vkCmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pSubpassBeginInfo);
    if (pSubpassBeginInfo)
        cmd_size += vn_sizeof_VkSubpassBeginInfo(pSubpassBeginInfo);
    cmd_size += vn_sizeof_simple_pointer(pSubpassEndInfo);
    if (pSubpassEndInfo)
        cmd_size += vn_sizeof_VkSubpassEndInfo(pSubpassEndInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdNextSubpass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pSubpassBeginInfo))
        vn_encode_VkSubpassBeginInfo(enc, pSubpassBeginInfo);
    if (vn_encode_simple_pointer(enc, pSubpassEndInfo))
        vn_encode_VkSubpassEndInfo(enc, pSubpassEndInfo);
}

static inline size_t vn_sizeof_vkCmdNextSubpass2_reply(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pSubpassBeginInfo */
    /* skip pSubpassEndInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdNextSubpass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT);

    /* skip commandBuffer */
    /* skip pSubpassBeginInfo */
    /* skip pSubpassEndInfo */
}

static inline size_t vn_sizeof_vkCmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pSubpassEndInfo);
    if (pSubpassEndInfo)
        cmd_size += vn_sizeof_VkSubpassEndInfo(pSubpassEndInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndRenderPass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pSubpassEndInfo))
        vn_encode_VkSubpassEndInfo(enc, pSubpassEndInfo);
}

static inline size_t vn_sizeof_vkCmdEndRenderPass2_reply(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pSubpassEndInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndRenderPass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT);

    /* skip commandBuffer */
    /* skip pSubpassEndInfo */
}

static inline size_t vn_sizeof_vkCmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkBuffer(&countBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&countBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&maxDrawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirectCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkBuffer(enc, &countBuffer);
    vn_encode_VkDeviceSize(enc, &countBufferOffset);
    vn_encode_uint32_t(enc, &maxDrawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirectCount_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirectCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkBuffer(&countBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&countBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&maxDrawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexedIndirectCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkBuffer(enc, &countBuffer);
    vn_encode_VkDeviceSize(enc, &countBufferOffset);
    vn_encode_uint32_t(enc, &maxDrawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirectCount_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexedIndirectCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstBinding);
    cmd_size += vn_sizeof_uint32_t(&bindingCount);
    if (pBuffers) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pOffsets) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pOffsets, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pSizes) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pSizes, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindTransformFeedbackBuffersEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstBinding);
    vn_encode_uint32_t(enc, &bindingCount);
    if (pBuffers) {
        vn_encode_array_size(enc, bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            vn_encode_VkBuffer(enc, &pBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pOffsets) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pOffsets, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pSizes) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pSizes, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindTransformFeedbackBuffersEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */
}

static inline size_t vn_sizeof_vkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstCounterBuffer);
    cmd_size += vn_sizeof_uint32_t(&counterBufferCount);
    if (pCounterBuffers) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pCounterBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pCounterBufferOffsets) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pCounterBufferOffsets, counterBufferCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginTransformFeedbackEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstCounterBuffer);
    vn_encode_uint32_t(enc, &counterBufferCount);
    if (pCounterBuffers) {
        vn_encode_array_size(enc, counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            vn_encode_VkBuffer(enc, &pCounterBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pCounterBufferOffsets) {
        vn_encode_array_size(enc, counterBufferCount);
        vn_encode_VkDeviceSize_array(enc, pCounterBufferOffsets, counterBufferCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBeginTransformFeedbackEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginTransformFeedbackEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */
}

static inline size_t vn_sizeof_vkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstCounterBuffer);
    cmd_size += vn_sizeof_uint32_t(&counterBufferCount);
    if (pCounterBuffers) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pCounterBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pCounterBufferOffsets) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pCounterBufferOffsets, counterBufferCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdEndTransformFeedbackEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstCounterBuffer);
    vn_encode_uint32_t(enc, &counterBufferCount);
    if (pCounterBuffers) {
        vn_encode_array_size(enc, counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            vn_encode_VkBuffer(enc, &pCounterBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pCounterBufferOffsets) {
        vn_encode_array_size(enc, counterBufferCount);
        vn_encode_VkDeviceSize_array(enc, pCounterBufferOffsets, counterBufferCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdEndTransformFeedbackEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndTransformFeedbackEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */
}

static inline size_t vn_sizeof_vkCmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_VkFlags(&flags);
    cmd_size += vn_sizeof_uint32_t(&index);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginQueryIndexedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_VkFlags(enc, &flags);
    vn_encode_uint32_t(enc, &index);
}

static inline size_t vn_sizeof_vkCmdBeginQueryIndexedEXT_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
    /* skip index */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginQueryIndexedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
    /* skip index */
}

static inline size_t vn_sizeof_vkCmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_uint32_t(&index);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndQueryIndexedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_uint32_t(enc, &index);
}

static inline size_t vn_sizeof_vkCmdEndQueryIndexedEXT_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip index */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndQueryIndexedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip index */
}

static inline size_t vn_sizeof_vkCmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);
    cmd_size += vn_sizeof_VkBuffer(&counterBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&counterBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&counterOffset);
    cmd_size += vn_sizeof_uint32_t(&vertexStride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirectByteCountEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstInstance);
    vn_encode_VkBuffer(enc, &counterBuffer);
    vn_encode_VkDeviceSize(enc, &counterBufferOffset);
    vn_encode_uint32_t(enc, &counterOffset);
    vn_encode_uint32_t(enc, &vertexStride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirectByteCountEXT_reply(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip counterBuffer */
    /* skip counterBufferOffset */
    /* skip counterOffset */
    /* skip vertexStride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirectByteCountEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT);

    /* skip commandBuffer */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip counterBuffer */
    /* skip counterBufferOffset */
    /* skip counterOffset */
    /* skip vertexStride */
}

static inline size_t vn_sizeof_vkCmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStipple_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&lineStippleFactor);
    cmd_size += vn_sizeof_uint16_t(&lineStipplePattern);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLineStipple(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStipple_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &lineStippleFactor);
    vn_encode_uint16_t(enc, &lineStipplePattern);
}

static inline size_t vn_sizeof_vkCmdSetLineStipple_reply(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStipple_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip lineStippleFactor */
    /* skip lineStipplePattern */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLineStipple_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLineStipple_EXT);

    /* skip commandBuffer */
    /* skip lineStippleFactor */
    /* skip lineStipplePattern */
}

static inline size_t vn_sizeof_vkCmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetCullMode_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&cullMode);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetCullMode(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetCullMode_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &cullMode);
}

static inline size_t vn_sizeof_vkCmdSetCullMode_reply(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetCullMode_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip cullMode */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetCullMode_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetCullMode_EXT);

    /* skip commandBuffer */
    /* skip cullMode */
}

static inline size_t vn_sizeof_vkCmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFrontFace(&frontFace);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetFrontFace(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFrontFace(enc, &frontFace);
}

static inline size_t vn_sizeof_vkCmdSetFrontFace_reply(VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip frontFace */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetFrontFace_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT);

    /* skip commandBuffer */
    /* skip frontFace */
}

static inline size_t vn_sizeof_vkCmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPrimitiveTopology(&primitiveTopology);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetPrimitiveTopology(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPrimitiveTopology(enc, &primitiveTopology);
}

static inline size_t vn_sizeof_vkCmdSetPrimitiveTopology_reply(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip primitiveTopology */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetPrimitiveTopology_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT);

    /* skip commandBuffer */
    /* skip primitiveTopology */
}

static inline size_t vn_sizeof_vkCmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&viewportCount);
    if (pViewports) {
        cmd_size += vn_sizeof_array_size(viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            cmd_size += vn_sizeof_VkViewport(&pViewports[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetViewportWithCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &viewportCount);
    if (pViewports) {
        vn_encode_array_size(enc, viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            vn_encode_VkViewport(enc, &pViewports[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetViewportWithCount_reply(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip viewportCount */
    /* skip pViewports */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetViewportWithCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT);

    /* skip commandBuffer */
    /* skip viewportCount */
    /* skip pViewports */
}

static inline size_t vn_sizeof_vkCmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&scissorCount);
    if (pScissors) {
        cmd_size += vn_sizeof_array_size(scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            cmd_size += vn_sizeof_VkRect2D(&pScissors[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetScissorWithCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &scissorCount);
    if (pScissors) {
        vn_encode_array_size(enc, scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            vn_encode_VkRect2D(enc, &pScissors[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetScissorWithCount_reply(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip scissorCount */
    /* skip pScissors */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetScissorWithCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT);

    /* skip commandBuffer */
    /* skip scissorCount */
    /* skip pScissors */
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkDeviceSize(&size);
    cmd_size += vn_sizeof_VkIndexType(&indexType);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindIndexBuffer2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkDeviceSize(enc, &size);
    vn_encode_VkIndexType(enc, &indexType);
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer2_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip size */
    /* skip indexType */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindIndexBuffer2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindIndexBuffer2_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip size */
    /* skip indexType */
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstBinding);
    cmd_size += vn_sizeof_uint32_t(&bindingCount);
    if (pBuffers) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pOffsets) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pOffsets, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pSizes) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pSizes, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pStrides) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pStrides, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindVertexBuffers2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstBinding);
    vn_encode_uint32_t(enc, &bindingCount);
    if (pBuffers) {
        vn_encode_array_size(enc, bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            vn_encode_VkBuffer(enc, &pBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pOffsets) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pOffsets, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pSizes) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pSizes, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pStrides) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pStrides, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers2_reply(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */
    /* skip pStrides */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindVertexBuffers2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */
    /* skip pStrides */
}

static inline size_t vn_sizeof_vkCmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthTestEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthTestEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthTestEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthTestEnable_reply(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthTestEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthTestEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT);

    /* skip commandBuffer */
    /* skip depthTestEnable */
}

static inline size_t vn_sizeof_vkCmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthWriteEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthWriteEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthWriteEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthWriteEnable_reply(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthWriteEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthWriteEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT);

    /* skip commandBuffer */
    /* skip depthWriteEnable */
}

static inline size_t vn_sizeof_vkCmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkCompareOp(&depthCompareOp);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthCompareOp(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkCompareOp(enc, &depthCompareOp);
}

static inline size_t vn_sizeof_vkCmdSetDepthCompareOp_reply(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthCompareOp */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthCompareOp_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT);

    /* skip commandBuffer */
    /* skip depthCompareOp */
}

static inline size_t vn_sizeof_vkCmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthBoundsTestEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBoundsTestEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthBoundsTestEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthBoundsTestEnable_reply(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthBoundsTestEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBoundsTestEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT);

    /* skip commandBuffer */
    /* skip depthBoundsTestEnable */
}

static inline size_t vn_sizeof_vkCmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&stencilTestEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilTestEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &stencilTestEnable);
}

static inline size_t vn_sizeof_vkCmdSetStencilTestEnable_reply(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip stencilTestEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilTestEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT);

    /* skip commandBuffer */
    /* skip stencilTestEnable */
}

static inline size_t vn_sizeof_vkCmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_VkStencilOp(&failOp);
    cmd_size += vn_sizeof_VkStencilOp(&passOp);
    cmd_size += vn_sizeof_VkStencilOp(&depthFailOp);
    cmd_size += vn_sizeof_VkCompareOp(&compareOp);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilOp(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_VkStencilOp(enc, &failOp);
    vn_encode_VkStencilOp(enc, &passOp);
    vn_encode_VkStencilOp(enc, &depthFailOp);
    vn_encode_VkCompareOp(enc, &compareOp);
}

static inline size_t vn_sizeof_vkCmdSetStencilOp_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip failOp */
    /* skip passOp */
    /* skip depthFailOp */
    /* skip compareOp */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilOp_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip failOp */
    /* skip passOp */
    /* skip depthFailOp */
    /* skip compareOp */
}

static inline size_t vn_sizeof_vkCmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&patchControlPoints);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetPatchControlPointsEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &patchControlPoints);
}

static inline size_t vn_sizeof_vkCmdSetPatchControlPointsEXT_reply(VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip patchControlPoints */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetPatchControlPointsEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT);

    /* skip commandBuffer */
    /* skip patchControlPoints */
}

static inline size_t vn_sizeof_vkCmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&rasterizerDiscardEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetRasterizerDiscardEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &rasterizerDiscardEnable);
}

static inline size_t vn_sizeof_vkCmdSetRasterizerDiscardEnable_reply(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip rasterizerDiscardEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetRasterizerDiscardEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT);

    /* skip commandBuffer */
    /* skip rasterizerDiscardEnable */
}

static inline size_t vn_sizeof_vkCmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthBiasEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBiasEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthBiasEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthBiasEnable_reply(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthBiasEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBiasEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT);

    /* skip commandBuffer */
    /* skip depthBiasEnable */
}

static inline size_t vn_sizeof_vkCmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkLogicOp(&logicOp);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLogicOpEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkLogicOp(enc, &logicOp);
}

static inline size_t vn_sizeof_vkCmdSetLogicOpEXT_reply(VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip logicOp */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLogicOpEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT);

    /* skip commandBuffer */
    /* skip logicOp */
}

static inline size_t vn_sizeof_vkCmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&primitiveRestartEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetPrimitiveRestartEnable(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &primitiveRestartEnable);
}

static inline size_t vn_sizeof_vkCmdSetPrimitiveRestartEnable_reply(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip primitiveRestartEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetPrimitiveRestartEnable_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT);

    /* skip commandBuffer */
    /* skip primitiveRestartEnable */
}

static inline size_t vn_sizeof_vkCmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetTessellationDomainOriginEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkTessellationDomainOrigin(&domainOrigin);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetTessellationDomainOriginEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetTessellationDomainOriginEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkTessellationDomainOrigin(enc, &domainOrigin);
}

static inline size_t vn_sizeof_vkCmdSetTessellationDomainOriginEXT_reply(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetTessellationDomainOriginEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip domainOrigin */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetTessellationDomainOriginEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetTessellationDomainOriginEXT_EXT);

    /* skip commandBuffer */
    /* skip domainOrigin */
}

static inline size_t vn_sizeof_vkCmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClampEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthClampEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthClampEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClampEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthClampEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthClampEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClampEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthClampEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthClampEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthClampEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip depthClampEnable */
}

static inline size_t vn_sizeof_vkCmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPolygonModeEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPolygonMode(&polygonMode);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetPolygonModeEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPolygonModeEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPolygonMode(enc, &polygonMode);
}

static inline size_t vn_sizeof_vkCmdSetPolygonModeEXT_reply(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetPolygonModeEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip polygonMode */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetPolygonModeEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetPolygonModeEXT_EXT);

    /* skip commandBuffer */
    /* skip polygonMode */
}

static inline size_t vn_sizeof_vkCmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationSamplesEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkSampleCountFlagBits(&rasterizationSamples);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetRasterizationSamplesEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationSamplesEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkSampleCountFlagBits(enc, &rasterizationSamples);
}

static inline size_t vn_sizeof_vkCmdSetRasterizationSamplesEXT_reply(VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationSamplesEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip rasterizationSamples */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetRasterizationSamplesEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetRasterizationSamplesEXT_EXT);

    /* skip commandBuffer */
    /* skip rasterizationSamples */
}

static inline size_t vn_sizeof_vkCmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleMaskEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkSampleCountFlagBits(&samples);
    if (pSampleMask) {
        cmd_size += vn_sizeof_array_size((samples + 31) / 32);
        cmd_size += vn_sizeof_VkSampleMask_array(pSampleMask, (samples + 31) / 32);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetSampleMaskEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleMaskEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkSampleCountFlagBits(enc, &samples);
    if (pSampleMask) {
        vn_encode_array_size(enc, (samples + 31) / 32);
        vn_encode_VkSampleMask_array(enc, pSampleMask, (samples + 31) / 32);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetSampleMaskEXT_reply(VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleMaskEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip samples */
    /* skip pSampleMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetSampleMaskEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetSampleMaskEXT_EXT);

    /* skip commandBuffer */
    /* skip samples */
    /* skip pSampleMask */
}

static inline size_t vn_sizeof_vkCmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToCoverageEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&alphaToCoverageEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetAlphaToCoverageEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToCoverageEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &alphaToCoverageEnable);
}

static inline size_t vn_sizeof_vkCmdSetAlphaToCoverageEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToCoverageEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip alphaToCoverageEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetAlphaToCoverageEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetAlphaToCoverageEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip alphaToCoverageEnable */
}

static inline size_t vn_sizeof_vkCmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToOneEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&alphaToOneEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetAlphaToOneEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToOneEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &alphaToOneEnable);
}

static inline size_t vn_sizeof_vkCmdSetAlphaToOneEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetAlphaToOneEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip alphaToOneEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetAlphaToOneEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetAlphaToOneEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip alphaToOneEnable */
}

static inline size_t vn_sizeof_vkCmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&logicOpEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLogicOpEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &logicOpEnable);
}

static inline size_t vn_sizeof_vkCmdSetLogicOpEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLogicOpEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip logicOpEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLogicOpEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLogicOpEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip logicOpEnable */
}

static inline size_t vn_sizeof_vkCmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstAttachment);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pColorBlendEnables) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        cmd_size += vn_sizeof_VkBool32_array(pColorBlendEnables, attachmentCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetColorBlendEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstAttachment);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pColorBlendEnables) {
        vn_encode_array_size(enc, attachmentCount);
        vn_encode_VkBool32_array(enc, pColorBlendEnables, attachmentCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetColorBlendEnableEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendEnables */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetColorBlendEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetColorBlendEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendEnables */
}

static inline size_t vn_sizeof_vkCmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEquationEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstAttachment);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pColorBlendEquations) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            cmd_size += vn_sizeof_VkColorBlendEquationEXT(&pColorBlendEquations[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetColorBlendEquationEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEquationEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstAttachment);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pColorBlendEquations) {
        vn_encode_array_size(enc, attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            vn_encode_VkColorBlendEquationEXT(enc, &pColorBlendEquations[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetColorBlendEquationEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendEquationEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendEquations */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetColorBlendEquationEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetColorBlendEquationEXT_EXT);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendEquations */
}

static inline size_t vn_sizeof_vkCmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteMaskEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstAttachment);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pColorWriteMasks) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            cmd_size += vn_sizeof_VkFlags(&pColorWriteMasks[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetColorWriteMaskEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteMaskEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstAttachment);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pColorWriteMasks) {
        vn_encode_array_size(enc, attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            vn_encode_VkFlags(enc, &pColorWriteMasks[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetColorWriteMaskEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteMaskEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorWriteMasks */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetColorWriteMaskEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetColorWriteMaskEXT_EXT);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorWriteMasks */
}

static inline size_t vn_sizeof_vkCmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationStreamEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&rasterizationStream);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetRasterizationStreamEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationStreamEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &rasterizationStream);
}

static inline size_t vn_sizeof_vkCmdSetRasterizationStreamEXT_reply(VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRasterizationStreamEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip rasterizationStream */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetRasterizationStreamEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetRasterizationStreamEXT_EXT);

    /* skip commandBuffer */
    /* skip rasterizationStream */
}

static inline size_t vn_sizeof_vkCmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetConservativeRasterizationModeEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkConservativeRasterizationModeEXT(&conservativeRasterizationMode);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetConservativeRasterizationModeEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetConservativeRasterizationModeEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkConservativeRasterizationModeEXT(enc, &conservativeRasterizationMode);
}

static inline size_t vn_sizeof_vkCmdSetConservativeRasterizationModeEXT_reply(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetConservativeRasterizationModeEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip conservativeRasterizationMode */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetConservativeRasterizationModeEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetConservativeRasterizationModeEXT_EXT);

    /* skip commandBuffer */
    /* skip conservativeRasterizationMode */
}

static inline size_t vn_sizeof_vkCmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetExtraPrimitiveOverestimationSizeEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&extraPrimitiveOverestimationSize);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetExtraPrimitiveOverestimationSizeEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetExtraPrimitiveOverestimationSizeEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &extraPrimitiveOverestimationSize);
}

static inline size_t vn_sizeof_vkCmdSetExtraPrimitiveOverestimationSizeEXT_reply(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetExtraPrimitiveOverestimationSizeEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip extraPrimitiveOverestimationSize */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetExtraPrimitiveOverestimationSizeEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetExtraPrimitiveOverestimationSizeEXT_EXT);

    /* skip commandBuffer */
    /* skip extraPrimitiveOverestimationSize */
}

static inline size_t vn_sizeof_vkCmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&depthClipEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthClipEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &depthClipEnable);
}

static inline size_t vn_sizeof_vkCmdSetDepthClipEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthClipEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthClipEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthClipEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip depthClipEnable */
}

static inline size_t vn_sizeof_vkCmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&sampleLocationsEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetSampleLocationsEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &sampleLocationsEnable);
}

static inline size_t vn_sizeof_vkCmdSetSampleLocationsEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetSampleLocationsEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip sampleLocationsEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetSampleLocationsEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetSampleLocationsEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip sampleLocationsEnable */
}

static inline size_t vn_sizeof_vkCmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendAdvancedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstAttachment);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pColorBlendAdvanced) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            cmd_size += vn_sizeof_VkColorBlendAdvancedEXT(&pColorBlendAdvanced[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetColorBlendAdvancedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendAdvancedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstAttachment);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pColorBlendAdvanced) {
        vn_encode_array_size(enc, attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            vn_encode_VkColorBlendAdvancedEXT(enc, &pColorBlendAdvanced[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetColorBlendAdvancedEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorBlendAdvancedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendAdvanced */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetColorBlendAdvancedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetColorBlendAdvancedEXT_EXT);

    /* skip commandBuffer */
    /* skip firstAttachment */
    /* skip attachmentCount */
    /* skip pColorBlendAdvanced */
}

static inline size_t vn_sizeof_vkCmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetProvokingVertexModeEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkProvokingVertexModeEXT(&provokingVertexMode);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetProvokingVertexModeEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetProvokingVertexModeEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkProvokingVertexModeEXT(enc, &provokingVertexMode);
}

static inline size_t vn_sizeof_vkCmdSetProvokingVertexModeEXT_reply(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetProvokingVertexModeEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip provokingVertexMode */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetProvokingVertexModeEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetProvokingVertexModeEXT_EXT);

    /* skip commandBuffer */
    /* skip provokingVertexMode */
}

static inline size_t vn_sizeof_vkCmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineRasterizationModeEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkLineRasterizationMode(&lineRasterizationMode);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLineRasterizationModeEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineRasterizationModeEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkLineRasterizationMode(enc, &lineRasterizationMode);
}

static inline size_t vn_sizeof_vkCmdSetLineRasterizationModeEXT_reply(VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineRasterizationModeEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip lineRasterizationMode */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLineRasterizationModeEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLineRasterizationModeEXT_EXT);

    /* skip commandBuffer */
    /* skip lineRasterizationMode */
}

static inline size_t vn_sizeof_vkCmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStippleEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&stippledLineEnable);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLineStippleEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStippleEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &stippledLineEnable);
}

static inline size_t vn_sizeof_vkCmdSetLineStippleEnableEXT_reply(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineStippleEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip stippledLineEnable */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLineStippleEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLineStippleEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip stippledLineEnable */
}

static inline size_t vn_sizeof_vkCmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipNegativeOneToOneEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBool32(&negativeOneToOne);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthClipNegativeOneToOneEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipNegativeOneToOneEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBool32(enc, &negativeOneToOne);
}

static inline size_t vn_sizeof_vkCmdSetDepthClipNegativeOneToOneEXT_reply(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthClipNegativeOneToOneEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip negativeOneToOne */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthClipNegativeOneToOneEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthClipNegativeOneToOneEXT_EXT);

    /* skip commandBuffer */
    /* skip negativeOneToOne */
}

static inline size_t vn_sizeof_vkCmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pCopyBufferInfo);
    if (pCopyBufferInfo)
        cmd_size += vn_sizeof_VkCopyBufferInfo2(pCopyBufferInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBuffer2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pCopyBufferInfo))
        vn_encode_VkCopyBufferInfo2(enc, pCopyBufferInfo);
}

static inline size_t vn_sizeof_vkCmdCopyBuffer2_reply(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pCopyBufferInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBuffer2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT);

    /* skip commandBuffer */
    /* skip pCopyBufferInfo */
}

static inline size_t vn_sizeof_vkCmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pCopyImageInfo);
    if (pCopyImageInfo)
        cmd_size += vn_sizeof_VkCopyImageInfo2(pCopyImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImage2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pCopyImageInfo))
        vn_encode_VkCopyImageInfo2(enc, pCopyImageInfo);
}

static inline size_t vn_sizeof_vkCmdCopyImage2_reply(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pCopyImageInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImage2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImage2_EXT);

    /* skip commandBuffer */
    /* skip pCopyImageInfo */
}

static inline size_t vn_sizeof_vkCmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pBlitImageInfo);
    if (pBlitImageInfo)
        cmd_size += vn_sizeof_VkBlitImageInfo2(pBlitImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdBlitImage2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pBlitImageInfo))
        vn_encode_VkBlitImageInfo2(enc, pBlitImageInfo);
}

static inline size_t vn_sizeof_vkCmdBlitImage2_reply(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pBlitImageInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdBlitImage2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBlitImage2_EXT);

    /* skip commandBuffer */
    /* skip pBlitImageInfo */
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pCopyBufferToImageInfo);
    if (pCopyBufferToImageInfo)
        cmd_size += vn_sizeof_VkCopyBufferToImageInfo2(pCopyBufferToImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBufferToImage2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pCopyBufferToImageInfo))
        vn_encode_VkCopyBufferToImageInfo2(enc, pCopyBufferToImageInfo);
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage2_reply(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pCopyBufferToImageInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBufferToImage2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT);

    /* skip commandBuffer */
    /* skip pCopyBufferToImageInfo */
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pCopyImageToBufferInfo);
    if (pCopyImageToBufferInfo)
        cmd_size += vn_sizeof_VkCopyImageToBufferInfo2(pCopyImageToBufferInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImageToBuffer2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pCopyImageToBufferInfo))
        vn_encode_VkCopyImageToBufferInfo2(enc, pCopyImageToBufferInfo);
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer2_reply(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pCopyImageToBufferInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImageToBuffer2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT);

    /* skip commandBuffer */
    /* skip pCopyImageToBufferInfo */
}

static inline size_t vn_sizeof_vkCmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pResolveImageInfo);
    if (pResolveImageInfo)
        cmd_size += vn_sizeof_VkResolveImageInfo2(pResolveImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdResolveImage2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pResolveImageInfo))
        vn_encode_VkResolveImageInfo2(enc, pResolveImageInfo);
}

static inline size_t vn_sizeof_vkCmdResolveImage2_reply(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pResolveImageInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdResolveImage2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResolveImage2_EXT);

    /* skip commandBuffer */
    /* skip pResolveImageInfo */
}

static inline size_t vn_sizeof_vkCmdSetFragmentShadingRateKHR(VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFragmentShadingRateKHR_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pFragmentSize);
    if (pFragmentSize)
        cmd_size += vn_sizeof_VkExtent2D(pFragmentSize);
    cmd_size += vn_sizeof_array_size(2);
    cmd_size += vn_sizeof_VkFragmentShadingRateCombinerOpKHR_array(combinerOps, 2);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetFragmentShadingRateKHR(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFragmentShadingRateKHR_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pFragmentSize))
        vn_encode_VkExtent2D(enc, pFragmentSize);
    vn_encode_array_size(enc, 2);
    vn_encode_VkFragmentShadingRateCombinerOpKHR_array(enc, combinerOps, 2);
}

static inline size_t vn_sizeof_vkCmdSetFragmentShadingRateKHR_reply(VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetFragmentShadingRateKHR_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pFragmentSize */
    /* skip combinerOps */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetFragmentShadingRateKHR_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetFragmentShadingRateKHR_EXT);

    /* skip commandBuffer */
    /* skip pFragmentSize */
    /* skip combinerOps */
}

static inline size_t vn_sizeof_vkCmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetVertexInputEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&vertexBindingDescriptionCount);
    if (pVertexBindingDescriptions) {
        cmd_size += vn_sizeof_array_size(vertexBindingDescriptionCount);
        for (uint32_t i = 0; i < vertexBindingDescriptionCount; i++)
            cmd_size += vn_sizeof_VkVertexInputBindingDescription2EXT(&pVertexBindingDescriptions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&vertexAttributeDescriptionCount);
    if (pVertexAttributeDescriptions) {
        cmd_size += vn_sizeof_array_size(vertexAttributeDescriptionCount);
        for (uint32_t i = 0; i < vertexAttributeDescriptionCount; i++)
            cmd_size += vn_sizeof_VkVertexInputAttributeDescription2EXT(&pVertexAttributeDescriptions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetVertexInputEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetVertexInputEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &vertexBindingDescriptionCount);
    if (pVertexBindingDescriptions) {
        vn_encode_array_size(enc, vertexBindingDescriptionCount);
        for (uint32_t i = 0; i < vertexBindingDescriptionCount; i++)
            vn_encode_VkVertexInputBindingDescription2EXT(enc, &pVertexBindingDescriptions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &vertexAttributeDescriptionCount);
    if (pVertexAttributeDescriptions) {
        vn_encode_array_size(enc, vertexAttributeDescriptionCount);
        for (uint32_t i = 0; i < vertexAttributeDescriptionCount; i++)
            vn_encode_VkVertexInputAttributeDescription2EXT(enc, &pVertexAttributeDescriptions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetVertexInputEXT_reply(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetVertexInputEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip vertexBindingDescriptionCount */
    /* skip pVertexBindingDescriptions */
    /* skip vertexAttributeDescriptionCount */
    /* skip pVertexAttributeDescriptions */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetVertexInputEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetVertexInputEXT_EXT);

    /* skip commandBuffer */
    /* skip vertexBindingDescriptionCount */
    /* skip pVertexBindingDescriptions */
    /* skip vertexAttributeDescriptionCount */
    /* skip pVertexAttributeDescriptions */
}

static inline size_t vn_sizeof_vkCmdSetColorWriteEnableEXT(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pColorWriteEnables) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        cmd_size += vn_sizeof_VkBool32_array(pColorWriteEnables, attachmentCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetColorWriteEnableEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pColorWriteEnables) {
        vn_encode_array_size(enc, attachmentCount);
        vn_encode_VkBool32_array(enc, pColorWriteEnables, attachmentCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetColorWriteEnableEXT_reply(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pColorWriteEnables */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetColorWriteEnableEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pColorWriteEnables */
}

static inline size_t vn_sizeof_vkCmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_simple_pointer(pDependencyInfo);
    if (pDependencyInfo)
        cmd_size += vn_sizeof_VkDependencyInfo(pDependencyInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetEvent2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    if (vn_encode_simple_pointer(enc, pDependencyInfo))
        vn_encode_VkDependencyInfo(enc, pDependencyInfo);
}

static inline size_t vn_sizeof_vkCmdSetEvent2_reply(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip pDependencyInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetEvent2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetEvent2_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip pDependencyInfo */
}

static inline size_t vn_sizeof_vkCmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_VkFlags64(&stageMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdResetEvent2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    vn_encode_VkFlags64(enc, &stageMask);
}

static inline size_t vn_sizeof_vkCmdResetEvent2_reply(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdResetEvent2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResetEvent2_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */
}

static inline size_t vn_sizeof_vkCmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&eventCount);
    if (pEvents) {
        cmd_size += vn_sizeof_array_size(eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            cmd_size += vn_sizeof_VkEvent(&pEvents[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pDependencyInfos) {
        cmd_size += vn_sizeof_array_size(eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            cmd_size += vn_sizeof_VkDependencyInfo(&pDependencyInfos[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdWaitEvents2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &eventCount);
    if (pEvents) {
        vn_encode_array_size(enc, eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            vn_encode_VkEvent(enc, &pEvents[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pDependencyInfos) {
        vn_encode_array_size(enc, eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            vn_encode_VkDependencyInfo(enc, &pDependencyInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdWaitEvents2_reply(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip pDependencyInfos */

    return cmd_size;
}

static inline void vn_decode_vkCmdWaitEvents2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip pDependencyInfos */
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pDependencyInfo);
    if (pDependencyInfo)
        cmd_size += vn_sizeof_VkDependencyInfo(pDependencyInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdPipelineBarrier2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pDependencyInfo))
        vn_encode_VkDependencyInfo(enc, pDependencyInfo);
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier2_reply(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pDependencyInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdPipelineBarrier2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT);

    /* skip commandBuffer */
    /* skip pDependencyInfo */
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags64(&stage);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);

    return cmd_size;
}

static inline void vn_encode_vkCmdWriteTimestamp2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags64(enc, &stage);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp2_reply(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip stage */
    /* skip queryPool */
    /* skip query */

    return cmd_size;
}

static inline void vn_decode_vkCmdWriteTimestamp2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT);

    /* skip commandBuffer */
    /* skip stage */
    /* skip queryPool */
    /* skip query */
}

static inline size_t vn_sizeof_vkCmdBeginRendering(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRendering_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pRenderingInfo);
    if (pRenderingInfo)
        cmd_size += vn_sizeof_VkRenderingInfo(pRenderingInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginRendering(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRendering_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pRenderingInfo))
        vn_encode_VkRenderingInfo(enc, pRenderingInfo);
}

static inline size_t vn_sizeof_vkCmdBeginRendering_reply(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRendering_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pRenderingInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginRendering_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginRendering_EXT);

    /* skip commandBuffer */
    /* skip pRenderingInfo */
}

static inline size_t vn_sizeof_vkCmdEndRendering(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRendering_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndRendering(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRendering_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkCmdEndRendering_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRendering_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndRendering_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndRendering_EXT);

    /* skip commandBuffer */
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pBindDescriptorSetsInfo);
    if (pBindDescriptorSetsInfo)
        cmd_size += vn_sizeof_VkBindDescriptorSetsInfo(pBindDescriptorSetsInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindDescriptorSets2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pBindDescriptorSetsInfo))
        vn_encode_VkBindDescriptorSetsInfo(enc, pBindDescriptorSetsInfo);
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets2_reply(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pBindDescriptorSetsInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindDescriptorSets2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindDescriptorSets2_EXT);

    /* skip commandBuffer */
    /* skip pBindDescriptorSetsInfo */
}

static inline size_t vn_sizeof_vkCmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pPushConstantsInfo);
    if (pPushConstantsInfo)
        cmd_size += vn_sizeof_VkPushConstantsInfo(pPushConstantsInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdPushConstants2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pPushConstantsInfo))
        vn_encode_VkPushConstantsInfo(enc, pPushConstantsInfo);
}

static inline size_t vn_sizeof_vkCmdPushConstants2_reply(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pPushConstantsInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdPushConstants2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPushConstants2_EXT);

    /* skip commandBuffer */
    /* skip pPushConstantsInfo */
}

static inline size_t vn_sizeof_vkCmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pPushDescriptorSetInfo);
    if (pPushDescriptorSetInfo)
        cmd_size += vn_sizeof_VkPushDescriptorSetInfo(pPushDescriptorSetInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdPushDescriptorSet2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pPushDescriptorSetInfo))
        vn_encode_VkPushDescriptorSetInfo(enc, pPushDescriptorSetInfo);
}

static inline size_t vn_sizeof_vkCmdPushDescriptorSet2_reply(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushDescriptorSet2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pPushDescriptorSetInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdPushDescriptorSet2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPushDescriptorSet2_EXT);

    /* skip commandBuffer */
    /* skip pPushDescriptorSetInfo */
}

static inline size_t vn_sizeof_vkCmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingAttachmentLocations_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pLocationInfo);
    if (pLocationInfo)
        cmd_size += vn_sizeof_VkRenderingAttachmentLocationInfo(pLocationInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetRenderingAttachmentLocations(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingAttachmentLocations_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pLocationInfo))
        vn_encode_VkRenderingAttachmentLocationInfo(enc, pLocationInfo);
}

static inline size_t vn_sizeof_vkCmdSetRenderingAttachmentLocations_reply(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingAttachmentLocations_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pLocationInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetRenderingAttachmentLocations_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetRenderingAttachmentLocations_EXT);

    /* skip commandBuffer */
    /* skip pLocationInfo */
}

static inline size_t vn_sizeof_vkCmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingInputAttachmentIndices_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pInputAttachmentIndexInfo);
    if (pInputAttachmentIndexInfo)
        cmd_size += vn_sizeof_VkRenderingInputAttachmentIndexInfo(pInputAttachmentIndexInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetRenderingInputAttachmentIndices(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingInputAttachmentIndices_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pInputAttachmentIndexInfo))
        vn_encode_VkRenderingInputAttachmentIndexInfo(enc, pInputAttachmentIndexInfo);
}

static inline size_t vn_sizeof_vkCmdSetRenderingInputAttachmentIndices_reply(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetRenderingInputAttachmentIndices_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pInputAttachmentIndexInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetRenderingInputAttachmentIndices_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetRenderingInputAttachmentIndices_EXT);

    /* skip commandBuffer */
    /* skip pInputAttachmentIndexInfo */
}

static inline void vn_submit_vkAllocateCommandBuffers(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkAllocateCommandBuffers_reply(device, pAllocateInfo, pCommandBuffers) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkAllocateCommandBuffers(enc, cmd_flags, device, pAllocateInfo, pCommandBuffers);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkFreeCommandBuffers(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkFreeCommandBuffers_reply(device, commandPool, commandBufferCount, pCommandBuffers) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkFreeCommandBuffers(enc, cmd_flags, device, commandPool, commandBufferCount, pCommandBuffers);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkBeginCommandBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBeginCommandBuffer(commandBuffer, pBeginInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBeginCommandBuffer_reply(commandBuffer, pBeginInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkBeginCommandBuffer(enc, cmd_flags, commandBuffer, pBeginInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEndCommandBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEndCommandBuffer(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEndCommandBuffer_reply(commandBuffer) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEndCommandBuffer(enc, cmd_flags, commandBuffer);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkResetCommandBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkResetCommandBuffer(commandBuffer, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkResetCommandBuffer_reply(commandBuffer, flags) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkResetCommandBuffer(enc, cmd_flags, commandBuffer, flags);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindPipeline(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindPipeline_reply(commandBuffer, pipelineBindPoint, pipeline) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindPipeline(enc, cmd_flags, commandBuffer, pipelineBindPoint, pipeline);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetViewport(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetViewport_reply(commandBuffer, firstViewport, viewportCount, pViewports) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetViewport(enc, cmd_flags, commandBuffer, firstViewport, viewportCount, pViewports);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetScissor(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetScissor_reply(commandBuffer, firstScissor, scissorCount, pScissors) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetScissor(enc, cmd_flags, commandBuffer, firstScissor, scissorCount, pScissors);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLineWidth(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float lineWidth, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLineWidth(commandBuffer, lineWidth);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLineWidth_reply(commandBuffer, lineWidth) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLineWidth(enc, cmd_flags, commandBuffer, lineWidth);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthBias(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBias_reply(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthBias(enc, cmd_flags, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetBlendConstants(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const float blendConstants[4], struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetBlendConstants(commandBuffer, blendConstants);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetBlendConstants_reply(commandBuffer, blendConstants) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetBlendConstants(enc, cmd_flags, commandBuffer, blendConstants);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthBounds(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBounds_reply(commandBuffer, minDepthBounds, maxDepthBounds) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthBounds(enc, cmd_flags, commandBuffer, minDepthBounds, maxDepthBounds);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetStencilCompareMask(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilCompareMask_reply(commandBuffer, faceMask, compareMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetStencilCompareMask(enc, cmd_flags, commandBuffer, faceMask, compareMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetStencilWriteMask(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilWriteMask_reply(commandBuffer, faceMask, writeMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetStencilWriteMask(enc, cmd_flags, commandBuffer, faceMask, writeMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetStencilReference(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilReference(commandBuffer, faceMask, reference);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilReference_reply(commandBuffer, faceMask, reference) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetStencilReference(enc, cmd_flags, commandBuffer, faceMask, reference);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindDescriptorSets(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindDescriptorSets_reply(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindDescriptorSets(enc, cmd_flags, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindIndexBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindIndexBuffer_reply(commandBuffer, buffer, offset, indexType) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindIndexBuffer(enc, cmd_flags, commandBuffer, buffer, offset, indexType);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindVertexBuffers(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindVertexBuffers_reply(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindVertexBuffers(enc, cmd_flags, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDraw(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDraw_reply(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDraw(enc, cmd_flags, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndexed(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexed_reply(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndexed(enc, cmd_flags, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawMultiEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawMultiEXT(commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawMultiEXT_reply(commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawMultiEXT(enc, cmd_flags, commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawMultiIndexedEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawMultiIndexedEXT(commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawMultiIndexedEXT_reply(commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawMultiIndexedEXT(enc, cmd_flags, commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndirect(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirect_reply(commandBuffer, buffer, offset, drawCount, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndirect(enc, cmd_flags, commandBuffer, buffer, offset, drawCount, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndexedIndirect(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexedIndirect_reply(commandBuffer, buffer, offset, drawCount, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndexedIndirect(enc, cmd_flags, commandBuffer, buffer, offset, drawCount, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDispatch(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatch_reply(commandBuffer, groupCountX, groupCountY, groupCountZ) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDispatch(enc, cmd_flags, commandBuffer, groupCountX, groupCountY, groupCountZ);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDispatchIndirect(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatchIndirect(commandBuffer, buffer, offset);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatchIndirect_reply(commandBuffer, buffer, offset) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDispatchIndirect(enc, cmd_flags, commandBuffer, buffer, offset);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBuffer_reply(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyBuffer(enc, cmd_flags, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyImage(enc, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBlitImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBlitImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBlitImage(enc, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyBufferToImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBufferToImage_reply(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyBufferToImage(enc, cmd_flags, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyImageToBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImageToBuffer_reply(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyImageToBuffer(enc, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdUpdateBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdUpdateBuffer_reply(commandBuffer, dstBuffer, dstOffset, dataSize, pData) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdUpdateBuffer(enc, cmd_flags, commandBuffer, dstBuffer, dstOffset, dataSize, pData);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdFillBuffer(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdFillBuffer_reply(commandBuffer, dstBuffer, dstOffset, size, data) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdFillBuffer(enc, cmd_flags, commandBuffer, dstBuffer, dstOffset, size, data);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdClearColorImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearColorImage_reply(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdClearColorImage(enc, cmd_flags, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdClearDepthStencilImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearDepthStencilImage_reply(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdClearDepthStencilImage(enc, cmd_flags, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdClearAttachments(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearAttachments_reply(commandBuffer, attachmentCount, pAttachments, rectCount, pRects) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdClearAttachments(enc, cmd_flags, commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdResolveImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResolveImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdResolveImage(enc, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetEvent(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetEvent(commandBuffer, event, stageMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetEvent_reply(commandBuffer, event, stageMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetEvent(enc, cmd_flags, commandBuffer, event, stageMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdResetEvent(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResetEvent(commandBuffer, event, stageMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResetEvent_reply(commandBuffer, event, stageMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdResetEvent(enc, cmd_flags, commandBuffer, event, stageMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdWaitEvents(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWaitEvents_reply(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdWaitEvents(enc, cmd_flags, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPipelineBarrier(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPipelineBarrier_reply(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPipelineBarrier(enc, cmd_flags, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginQuery(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginQuery(commandBuffer, queryPool, query, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginQuery_reply(commandBuffer, queryPool, query, flags) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginQuery(enc, cmd_flags, commandBuffer, queryPool, query, flags);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndQuery(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndQuery(commandBuffer, queryPool, query);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndQuery_reply(commandBuffer, queryPool, query) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndQuery(enc, cmd_flags, commandBuffer, queryPool, query);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginConditionalRenderingEXT_reply(commandBuffer, pConditionalRenderingBegin) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginConditionalRenderingEXT(enc, cmd_flags, commandBuffer, pConditionalRenderingBegin);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndConditionalRenderingEXT(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndConditionalRenderingEXT_reply(commandBuffer) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndConditionalRenderingEXT(enc, cmd_flags, commandBuffer);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdResetQueryPool(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResetQueryPool_reply(commandBuffer, queryPool, firstQuery, queryCount) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdResetQueryPool(enc, cmd_flags, commandBuffer, queryPool, firstQuery, queryCount);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdWriteTimestamp(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWriteTimestamp_reply(commandBuffer, pipelineStage, queryPool, query) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdWriteTimestamp(enc, cmd_flags, commandBuffer, pipelineStage, queryPool, query);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyQueryPoolResults(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyQueryPoolResults_reply(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyQueryPoolResults(enc, cmd_flags, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPushConstants(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPushConstants_reply(commandBuffer, layout, stageFlags, offset, size, pValues) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPushConstants(enc, cmd_flags, commandBuffer, layout, stageFlags, offset, size, pValues);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginRenderPass(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginRenderPass_reply(commandBuffer, pRenderPassBegin, contents) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginRenderPass(enc, cmd_flags, commandBuffer, pRenderPassBegin, contents);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdNextSubpass(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSubpassContents contents, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdNextSubpass(commandBuffer, contents);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdNextSubpass_reply(commandBuffer, contents) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdNextSubpass(enc, cmd_flags, commandBuffer, contents);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndRenderPass(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndRenderPass(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndRenderPass_reply(commandBuffer) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndRenderPass(enc, cmd_flags, commandBuffer);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdExecuteCommands(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdExecuteCommands_reply(commandBuffer, commandBufferCount, pCommandBuffers) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdExecuteCommands(enc, cmd_flags, commandBuffer, commandBufferCount, pCommandBuffers);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPushDescriptorSet(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPushDescriptorSet_reply(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPushDescriptorSet(enc, cmd_flags, commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDeviceMask(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t deviceMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDeviceMask(commandBuffer, deviceMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDeviceMask_reply(commandBuffer, deviceMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDeviceMask(enc, cmd_flags, commandBuffer, deviceMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDispatchBase(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatchBase_reply(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDispatchBase(enc, cmd_flags, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetSampleLocationsEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetSampleLocationsEXT_reply(commandBuffer, pSampleLocationsInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetSampleLocationsEXT(enc, cmd_flags, commandBuffer, pSampleLocationsInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginRenderPass2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginRenderPass2_reply(commandBuffer, pRenderPassBegin, pSubpassBeginInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginRenderPass2(enc, cmd_flags, commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdNextSubpass2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdNextSubpass2_reply(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdNextSubpass2(enc, cmd_flags, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndRenderPass2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndRenderPass2_reply(commandBuffer, pSubpassEndInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndRenderPass2(enc, cmd_flags, commandBuffer, pSubpassEndInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndirectCount(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirectCount_reply(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndirectCount(enc, cmd_flags, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndexedIndirectCount(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexedIndirectCount_reply(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndexedIndirectCount(enc, cmd_flags, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindTransformFeedbackBuffersEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT_reply(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindTransformFeedbackBuffersEXT(enc, cmd_flags, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginTransformFeedbackEXT_reply(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginTransformFeedbackEXT(enc, cmd_flags, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndTransformFeedbackEXT_reply(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndTransformFeedbackEXT(enc, cmd_flags, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginQueryIndexedEXT_reply(commandBuffer, queryPool, query, flags, index) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginQueryIndexedEXT(enc, cmd_flags, commandBuffer, queryPool, query, flags, index);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndQueryIndexedEXT_reply(commandBuffer, queryPool, query, index) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndQueryIndexedEXT(enc, cmd_flags, commandBuffer, queryPool, query, index);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdDrawIndirectByteCountEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirectByteCountEXT_reply(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdDrawIndirectByteCountEXT(enc, cmd_flags, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLineStipple(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLineStipple_reply(commandBuffer, lineStippleFactor, lineStipplePattern) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLineStipple(enc, cmd_flags, commandBuffer, lineStippleFactor, lineStipplePattern);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetCullMode(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCullModeFlags cullMode, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetCullMode(commandBuffer, cullMode);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetCullMode_reply(commandBuffer, cullMode) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetCullMode(enc, cmd_flags, commandBuffer, cullMode);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetFrontFace(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkFrontFace frontFace, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetFrontFace(commandBuffer, frontFace);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetFrontFace_reply(commandBuffer, frontFace) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetFrontFace(enc, cmd_flags, commandBuffer, frontFace);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetPrimitiveTopology(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetPrimitiveTopology(commandBuffer, primitiveTopology);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetPrimitiveTopology_reply(commandBuffer, primitiveTopology) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetPrimitiveTopology(enc, cmd_flags, commandBuffer, primitiveTopology);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetViewportWithCount(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetViewportWithCount_reply(commandBuffer, viewportCount, pViewports) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetViewportWithCount(enc, cmd_flags, commandBuffer, viewportCount, pViewports);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetScissorWithCount(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetScissorWithCount_reply(commandBuffer, scissorCount, pScissors) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetScissorWithCount(enc, cmd_flags, commandBuffer, scissorCount, pScissors);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindIndexBuffer2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindIndexBuffer2_reply(commandBuffer, buffer, offset, size, indexType) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindIndexBuffer2(enc, cmd_flags, commandBuffer, buffer, offset, size, indexType);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindVertexBuffers2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindVertexBuffers2_reply(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindVertexBuffers2(enc, cmd_flags, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthTestEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthTestEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthTestEnable(commandBuffer, depthTestEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthTestEnable_reply(commandBuffer, depthTestEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthTestEnable(enc, cmd_flags, commandBuffer, depthTestEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthWriteEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthWriteEnable_reply(commandBuffer, depthWriteEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthWriteEnable(enc, cmd_flags, commandBuffer, depthWriteEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthCompareOp(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthCompareOp(commandBuffer, depthCompareOp);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthCompareOp_reply(commandBuffer, depthCompareOp) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthCompareOp(enc, cmd_flags, commandBuffer, depthCompareOp);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthBoundsTestEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBoundsTestEnable_reply(commandBuffer, depthBoundsTestEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthBoundsTestEnable(enc, cmd_flags, commandBuffer, depthBoundsTestEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetStencilTestEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilTestEnable(commandBuffer, stencilTestEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilTestEnable_reply(commandBuffer, stencilTestEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetStencilTestEnable(enc, cmd_flags, commandBuffer, stencilTestEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetStencilOp(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilOp_reply(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetStencilOp(enc, cmd_flags, commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetPatchControlPointsEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t patchControlPoints, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetPatchControlPointsEXT(commandBuffer, patchControlPoints);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetPatchControlPointsEXT_reply(commandBuffer, patchControlPoints) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetPatchControlPointsEXT(enc, cmd_flags, commandBuffer, patchControlPoints);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetRasterizerDiscardEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetRasterizerDiscardEnable_reply(commandBuffer, rasterizerDiscardEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetRasterizerDiscardEnable(enc, cmd_flags, commandBuffer, rasterizerDiscardEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthBiasEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBiasEnable_reply(commandBuffer, depthBiasEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthBiasEnable(enc, cmd_flags, commandBuffer, depthBiasEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLogicOpEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkLogicOp logicOp, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLogicOpEXT(commandBuffer, logicOp);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLogicOpEXT_reply(commandBuffer, logicOp) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLogicOpEXT(enc, cmd_flags, commandBuffer, logicOp);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetPrimitiveRestartEnable(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetPrimitiveRestartEnable_reply(commandBuffer, primitiveRestartEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetPrimitiveRestartEnable(enc, cmd_flags, commandBuffer, primitiveRestartEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetTessellationDomainOriginEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetTessellationDomainOriginEXT(commandBuffer, domainOrigin);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetTessellationDomainOriginEXT_reply(commandBuffer, domainOrigin) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetTessellationDomainOriginEXT(enc, cmd_flags, commandBuffer, domainOrigin);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthClampEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthClampEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthClampEnableEXT(commandBuffer, depthClampEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthClampEnableEXT_reply(commandBuffer, depthClampEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthClampEnableEXT(enc, cmd_flags, commandBuffer, depthClampEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetPolygonModeEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPolygonMode polygonMode, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetPolygonModeEXT(commandBuffer, polygonMode);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetPolygonModeEXT_reply(commandBuffer, polygonMode) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetPolygonModeEXT(enc, cmd_flags, commandBuffer, polygonMode);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetRasterizationSamplesEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetRasterizationSamplesEXT(commandBuffer, rasterizationSamples);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetRasterizationSamplesEXT_reply(commandBuffer, rasterizationSamples) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetRasterizationSamplesEXT(enc, cmd_flags, commandBuffer, rasterizationSamples);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetSampleMaskEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetSampleMaskEXT(commandBuffer, samples, pSampleMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetSampleMaskEXT_reply(commandBuffer, samples, pSampleMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetSampleMaskEXT(enc, cmd_flags, commandBuffer, samples, pSampleMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetAlphaToCoverageEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetAlphaToCoverageEnableEXT(commandBuffer, alphaToCoverageEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetAlphaToCoverageEnableEXT_reply(commandBuffer, alphaToCoverageEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetAlphaToCoverageEnableEXT(enc, cmd_flags, commandBuffer, alphaToCoverageEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetAlphaToOneEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetAlphaToOneEnableEXT(commandBuffer, alphaToOneEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetAlphaToOneEnableEXT_reply(commandBuffer, alphaToOneEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetAlphaToOneEnableEXT(enc, cmd_flags, commandBuffer, alphaToOneEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLogicOpEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 logicOpEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLogicOpEnableEXT(commandBuffer, logicOpEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLogicOpEnableEXT_reply(commandBuffer, logicOpEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLogicOpEnableEXT(enc, cmd_flags, commandBuffer, logicOpEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetColorBlendEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetColorBlendEnableEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetColorBlendEnableEXT_reply(commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetColorBlendEnableEXT(enc, cmd_flags, commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetColorBlendEquationEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetColorBlendEquationEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetColorBlendEquationEXT_reply(commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetColorBlendEquationEXT(enc, cmd_flags, commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetColorWriteMaskEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetColorWriteMaskEXT(commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetColorWriteMaskEXT_reply(commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetColorWriteMaskEXT(enc, cmd_flags, commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetRasterizationStreamEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t rasterizationStream, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetRasterizationStreamEXT(commandBuffer, rasterizationStream);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetRasterizationStreamEXT_reply(commandBuffer, rasterizationStream) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetRasterizationStreamEXT(enc, cmd_flags, commandBuffer, rasterizationStream);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetConservativeRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetConservativeRasterizationModeEXT(commandBuffer, conservativeRasterizationMode);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetConservativeRasterizationModeEXT_reply(commandBuffer, conservativeRasterizationMode) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetConservativeRasterizationModeEXT(enc, cmd_flags, commandBuffer, conservativeRasterizationMode);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetExtraPrimitiveOverestimationSizeEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetExtraPrimitiveOverestimationSizeEXT(commandBuffer, extraPrimitiveOverestimationSize);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetExtraPrimitiveOverestimationSizeEXT_reply(commandBuffer, extraPrimitiveOverestimationSize) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetExtraPrimitiveOverestimationSizeEXT(enc, cmd_flags, commandBuffer, extraPrimitiveOverestimationSize);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthClipEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 depthClipEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthClipEnableEXT(commandBuffer, depthClipEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthClipEnableEXT_reply(commandBuffer, depthClipEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthClipEnableEXT(enc, cmd_flags, commandBuffer, depthClipEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetSampleLocationsEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetSampleLocationsEnableEXT(commandBuffer, sampleLocationsEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetSampleLocationsEnableEXT_reply(commandBuffer, sampleLocationsEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetSampleLocationsEnableEXT(enc, cmd_flags, commandBuffer, sampleLocationsEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetColorBlendAdvancedEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetColorBlendAdvancedEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetColorBlendAdvancedEXT_reply(commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetColorBlendAdvancedEXT(enc, cmd_flags, commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetProvokingVertexModeEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetProvokingVertexModeEXT(commandBuffer, provokingVertexMode);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetProvokingVertexModeEXT_reply(commandBuffer, provokingVertexMode) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetProvokingVertexModeEXT(enc, cmd_flags, commandBuffer, provokingVertexMode);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLineRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLineRasterizationModeEXT(commandBuffer, lineRasterizationMode);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLineRasterizationModeEXT_reply(commandBuffer, lineRasterizationMode) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLineRasterizationModeEXT(enc, cmd_flags, commandBuffer, lineRasterizationMode);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetLineStippleEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLineStippleEnableEXT(commandBuffer, stippledLineEnable);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLineStippleEnableEXT_reply(commandBuffer, stippledLineEnable) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetLineStippleEnableEXT(enc, cmd_flags, commandBuffer, stippledLineEnable);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetDepthClipNegativeOneToOneEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthClipNegativeOneToOneEXT(commandBuffer, negativeOneToOne);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthClipNegativeOneToOneEXT_reply(commandBuffer, negativeOneToOne) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetDepthClipNegativeOneToOneEXT(enc, cmd_flags, commandBuffer, negativeOneToOne);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyBuffer2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBuffer2_reply(commandBuffer, pCopyBufferInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyBuffer2(enc, cmd_flags, commandBuffer, pCopyBufferInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyImage2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImage2(commandBuffer, pCopyImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImage2_reply(commandBuffer, pCopyImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyImage2(enc, cmd_flags, commandBuffer, pCopyImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBlitImage2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBlitImage2(commandBuffer, pBlitImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBlitImage2_reply(commandBuffer, pBlitImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBlitImage2(enc, cmd_flags, commandBuffer, pBlitImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyBufferToImage2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBufferToImage2_reply(commandBuffer, pCopyBufferToImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyBufferToImage2(enc, cmd_flags, commandBuffer, pCopyBufferToImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdCopyImageToBuffer2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImageToBuffer2_reply(commandBuffer, pCopyImageToBufferInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdCopyImageToBuffer2(enc, cmd_flags, commandBuffer, pCopyImageToBufferInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdResolveImage2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResolveImage2(commandBuffer, pResolveImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResolveImage2_reply(commandBuffer, pResolveImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdResolveImage2(enc, cmd_flags, commandBuffer, pResolveImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetFragmentShadingRateKHR(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2], struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetFragmentShadingRateKHR_reply(commandBuffer, pFragmentSize, combinerOps) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetFragmentShadingRateKHR(enc, cmd_flags, commandBuffer, pFragmentSize, combinerOps);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetVertexInputEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetVertexInputEXT_reply(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetVertexInputEXT(enc, cmd_flags, commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetColorWriteEnableEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetColorWriteEnableEXT(commandBuffer, attachmentCount, pColorWriteEnables);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetColorWriteEnableEXT_reply(commandBuffer, attachmentCount, pColorWriteEnables) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetColorWriteEnableEXT(enc, cmd_flags, commandBuffer, attachmentCount, pColorWriteEnables);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetEvent2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetEvent2(commandBuffer, event, pDependencyInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetEvent2_reply(commandBuffer, event, pDependencyInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetEvent2(enc, cmd_flags, commandBuffer, event, pDependencyInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdResetEvent2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResetEvent2(commandBuffer, event, stageMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResetEvent2_reply(commandBuffer, event, stageMask) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdResetEvent2(enc, cmd_flags, commandBuffer, event, stageMask);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdWaitEvents2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWaitEvents2_reply(commandBuffer, eventCount, pEvents, pDependencyInfos) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdWaitEvents2(enc, cmd_flags, commandBuffer, eventCount, pEvents, pDependencyInfos);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPipelineBarrier2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPipelineBarrier2(commandBuffer, pDependencyInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPipelineBarrier2_reply(commandBuffer, pDependencyInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPipelineBarrier2(enc, cmd_flags, commandBuffer, pDependencyInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdWriteTimestamp2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWriteTimestamp2(commandBuffer, stage, queryPool, query);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWriteTimestamp2_reply(commandBuffer, stage, queryPool, query) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdWriteTimestamp2(enc, cmd_flags, commandBuffer, stage, queryPool, query);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBeginRendering(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginRendering(commandBuffer, pRenderingInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginRendering_reply(commandBuffer, pRenderingInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBeginRendering(enc, cmd_flags, commandBuffer, pRenderingInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdEndRendering(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndRendering(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndRendering_reply(commandBuffer) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdEndRendering(enc, cmd_flags, commandBuffer);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdBindDescriptorSets2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindDescriptorSets2_reply(commandBuffer, pBindDescriptorSetsInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdBindDescriptorSets2(enc, cmd_flags, commandBuffer, pBindDescriptorSetsInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPushConstants2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPushConstants2(commandBuffer, pPushConstantsInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPushConstants2_reply(commandBuffer, pPushConstantsInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPushConstants2(enc, cmd_flags, commandBuffer, pPushConstantsInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdPushDescriptorSet2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPushDescriptorSet2_reply(commandBuffer, pPushDescriptorSetInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdPushDescriptorSet2(enc, cmd_flags, commandBuffer, pPushDescriptorSetInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetRenderingAttachmentLocations(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetRenderingAttachmentLocations_reply(commandBuffer, pLocationInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetRenderingAttachmentLocations(enc, cmd_flags, commandBuffer, pLocationInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCmdSetRenderingInputAttachmentIndices(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetRenderingInputAttachmentIndices_reply(commandBuffer, pInputAttachmentIndexInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCmdSetRenderingInputAttachmentIndices(enc, cmd_flags, commandBuffer, pInputAttachmentIndexInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkAllocateCommandBuffers(struct vn_ring *vn_ring, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkAllocateCommandBuffers(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pAllocateInfo, pCommandBuffers, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkAllocateCommandBuffers_reply(dec, device, pAllocateInfo, pCommandBuffers);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkAllocateCommandBuffers(struct vn_ring *vn_ring, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkAllocateCommandBuffers(vn_ring, 0, device, pAllocateInfo, pCommandBuffers, &submit);
}

static inline void vn_call_vkFreeCommandBuffers(struct vn_ring *vn_ring, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkFreeCommandBuffers(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, commandPool, commandBufferCount, pCommandBuffers, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkFreeCommandBuffers_reply(dec, device, commandPool, commandBufferCount, pCommandBuffers);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkFreeCommandBuffers(struct vn_ring *vn_ring, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkFreeCommandBuffers(vn_ring, 0, device, commandPool, commandBufferCount, pCommandBuffers, &submit);
}

static inline VkResult vn_call_vkBeginCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkBeginCommandBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pBeginInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkBeginCommandBuffer_reply(dec, commandBuffer, pBeginInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBeginCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkBeginCommandBuffer(vn_ring, 0, commandBuffer, pBeginInfo, &submit);
}

static inline VkResult vn_call_vkEndCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkEndCommandBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEndCommandBuffer_reply(dec, commandBuffer);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEndCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkEndCommandBuffer(vn_ring, 0, commandBuffer, &submit);
}

static inline VkResult vn_call_vkResetCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkResetCommandBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, flags, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkResetCommandBuffer_reply(dec, commandBuffer, flags);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkResetCommandBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkResetCommandBuffer(vn_ring, 0, commandBuffer, flags, &submit);
}

static inline void vn_call_vkCmdBindPipeline(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindPipeline(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineBindPoint, pipeline, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindPipeline_reply(dec, commandBuffer, pipelineBindPoint, pipeline);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindPipeline(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindPipeline(vn_ring, 0, commandBuffer, pipelineBindPoint, pipeline, &submit);
}

static inline void vn_call_vkCmdSetViewport(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetViewport(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstViewport, viewportCount, pViewports, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetViewport_reply(dec, commandBuffer, firstViewport, viewportCount, pViewports);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetViewport(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetViewport(vn_ring, 0, commandBuffer, firstViewport, viewportCount, pViewports, &submit);
}

static inline void vn_call_vkCmdSetScissor(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetScissor(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstScissor, scissorCount, pScissors, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetScissor_reply(dec, commandBuffer, firstScissor, scissorCount, pScissors);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetScissor(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetScissor(vn_ring, 0, commandBuffer, firstScissor, scissorCount, pScissors, &submit);
}

static inline void vn_call_vkCmdSetLineWidth(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float lineWidth)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineWidth(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, lineWidth, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLineWidth_reply(dec, commandBuffer, lineWidth);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLineWidth(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float lineWidth)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineWidth(vn_ring, 0, commandBuffer, lineWidth, &submit);
}

static inline void vn_call_vkCmdSetDepthBias(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBias(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthBias_reply(dec, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthBias(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBias(vn_ring, 0, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, &submit);
}

static inline void vn_call_vkCmdSetBlendConstants(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetBlendConstants(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, blendConstants, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetBlendConstants_reply(dec, commandBuffer, blendConstants);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetBlendConstants(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetBlendConstants(vn_ring, 0, commandBuffer, blendConstants, &submit);
}

static inline void vn_call_vkCmdSetDepthBounds(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBounds(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, minDepthBounds, maxDepthBounds, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthBounds_reply(dec, commandBuffer, minDepthBounds, maxDepthBounds);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthBounds(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBounds(vn_ring, 0, commandBuffer, minDepthBounds, maxDepthBounds, &submit);
}

static inline void vn_call_vkCmdSetStencilCompareMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilCompareMask(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, compareMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetStencilCompareMask_reply(dec, commandBuffer, faceMask, compareMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetStencilCompareMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilCompareMask(vn_ring, 0, commandBuffer, faceMask, compareMask, &submit);
}

static inline void vn_call_vkCmdSetStencilWriteMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilWriteMask(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, writeMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetStencilWriteMask_reply(dec, commandBuffer, faceMask, writeMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetStencilWriteMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilWriteMask(vn_ring, 0, commandBuffer, faceMask, writeMask, &submit);
}

static inline void vn_call_vkCmdSetStencilReference(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilReference(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, reference, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetStencilReference_reply(dec, commandBuffer, faceMask, reference);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetStencilReference(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilReference(vn_ring, 0, commandBuffer, faceMask, reference, &submit);
}

static inline void vn_call_vkCmdBindDescriptorSets(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindDescriptorSets_reply(dec, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindDescriptorSets(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets(vn_ring, 0, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, &submit);
}

static inline void vn_call_vkCmdBindIndexBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, indexType, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindIndexBuffer_reply(dec, commandBuffer, buffer, offset, indexType);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindIndexBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer(vn_ring, 0, commandBuffer, buffer, offset, indexType, &submit);
}

static inline void vn_call_vkCmdBindVertexBuffers(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindVertexBuffers_reply(dec, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindVertexBuffers(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers(vn_ring, 0, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, &submit);
}

static inline void vn_call_vkCmdDraw(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDraw(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDraw_reply(dec, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDraw(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDraw(vn_ring, 0, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, &submit);
}

static inline void vn_call_vkCmdDrawIndexed(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexed(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndexed_reply(dec, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndexed(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexed(vn_ring, 0, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance, &submit);
}

static inline void vn_call_vkCmdDrawMultiEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawMultiEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawMultiEXT_reply(dec, commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawMultiEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawMultiEXT(vn_ring, 0, commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride, &submit);
}

static inline void vn_call_vkCmdDrawMultiIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawMultiIndexedEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawMultiIndexedEXT_reply(dec, commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawMultiIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawMultiIndexedEXT(vn_ring, 0, commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset, &submit);
}

static inline void vn_call_vkCmdDrawIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirect(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, drawCount, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndirect_reply(dec, commandBuffer, buffer, offset, drawCount, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirect(vn_ring, 0, commandBuffer, buffer, offset, drawCount, stride, &submit);
}

static inline void vn_call_vkCmdDrawIndexedIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirect(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, drawCount, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndexedIndirect_reply(dec, commandBuffer, buffer, offset, drawCount, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndexedIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirect(vn_ring, 0, commandBuffer, buffer, offset, drawCount, stride, &submit);
}

static inline void vn_call_vkCmdDispatch(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatch(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, groupCountX, groupCountY, groupCountZ, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDispatch_reply(dec, commandBuffer, groupCountX, groupCountY, groupCountZ);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDispatch(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatch(vn_ring, 0, commandBuffer, groupCountX, groupCountY, groupCountZ, &submit);
}

static inline void vn_call_vkCmdDispatchIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatchIndirect(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDispatchIndirect_reply(dec, commandBuffer, buffer, offset);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDispatchIndirect(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatchIndirect(vn_ring, 0, commandBuffer, buffer, offset, &submit);
}

static inline void vn_call_vkCmdCopyBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyBuffer_reply(dec, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBuffer(vn_ring, 0, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdCopyImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyImage_reply(dec, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImage(vn_ring, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdBlitImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBlitImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBlitImage_reply(dec, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBlitImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBlitImage(vn_ring, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter, &submit);
}

static inline void vn_call_vkCmdCopyBufferToImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyBufferToImage_reply(dec, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyBufferToImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage(vn_ring, 0, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdCopyImageToBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyImageToBuffer_reply(dec, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyImageToBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer(vn_ring, 0, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdUpdateBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdUpdateBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, dstBuffer, dstOffset, dataSize, pData, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdUpdateBuffer_reply(dec, commandBuffer, dstBuffer, dstOffset, dataSize, pData);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdUpdateBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdUpdateBuffer(vn_ring, 0, commandBuffer, dstBuffer, dstOffset, dataSize, pData, &submit);
}

static inline void vn_call_vkCmdFillBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdFillBuffer(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, dstBuffer, dstOffset, size, data, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdFillBuffer_reply(dec, commandBuffer, dstBuffer, dstOffset, size, data);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdFillBuffer(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdFillBuffer(vn_ring, 0, commandBuffer, dstBuffer, dstOffset, size, data, &submit);
}

static inline void vn_call_vkCmdClearColorImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearColorImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdClearColorImage_reply(dec, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdClearColorImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearColorImage(vn_ring, 0, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, &submit);
}

static inline void vn_call_vkCmdClearDepthStencilImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearDepthStencilImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdClearDepthStencilImage_reply(dec, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdClearDepthStencilImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearDepthStencilImage(vn_ring, 0, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges, &submit);
}

static inline void vn_call_vkCmdClearAttachments(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearAttachments(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, attachmentCount, pAttachments, rectCount, pRects, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdClearAttachments_reply(dec, commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdClearAttachments(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdClearAttachments(vn_ring, 0, commandBuffer, attachmentCount, pAttachments, rectCount, pRects, &submit);
}

static inline void vn_call_vkCmdResolveImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResolveImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdResolveImage_reply(dec, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdResolveImage(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResolveImage(vn_ring, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdSetEvent(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetEvent(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, stageMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetEvent_reply(dec, commandBuffer, event, stageMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetEvent(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetEvent(vn_ring, 0, commandBuffer, event, stageMask, &submit);
}

static inline void vn_call_vkCmdResetEvent(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetEvent(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, stageMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdResetEvent_reply(dec, commandBuffer, event, stageMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdResetEvent(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetEvent(vn_ring, 0, commandBuffer, event, stageMask, &submit);
}

static inline void vn_call_vkCmdWaitEvents(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWaitEvents(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdWaitEvents_reply(dec, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdWaitEvents(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWaitEvents(vn_ring, 0, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
}

static inline void vn_call_vkCmdPipelineBarrier(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPipelineBarrier(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPipelineBarrier_reply(dec, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPipelineBarrier(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPipelineBarrier(vn_ring, 0, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
}

static inline void vn_call_vkCmdBeginQuery(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginQuery(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, flags, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginQuery_reply(dec, commandBuffer, queryPool, query, flags);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginQuery(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginQuery(vn_ring, 0, commandBuffer, queryPool, query, flags, &submit);
}

static inline void vn_call_vkCmdEndQuery(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndQuery(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndQuery_reply(dec, commandBuffer, queryPool, query);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndQuery(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndQuery(vn_ring, 0, commandBuffer, queryPool, query, &submit);
}

static inline void vn_call_vkCmdBeginConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginConditionalRenderingEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pConditionalRenderingBegin, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginConditionalRenderingEXT_reply(dec, commandBuffer, pConditionalRenderingBegin);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginConditionalRenderingEXT(vn_ring, 0, commandBuffer, pConditionalRenderingBegin, &submit);
}

static inline void vn_call_vkCmdEndConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndConditionalRenderingEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndConditionalRenderingEXT_reply(dec, commandBuffer);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndConditionalRenderingEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndConditionalRenderingEXT(vn_ring, 0, commandBuffer, &submit);
}

static inline void vn_call_vkCmdResetQueryPool(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetQueryPool(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, firstQuery, queryCount, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdResetQueryPool_reply(dec, commandBuffer, queryPool, firstQuery, queryCount);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdResetQueryPool(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetQueryPool(vn_ring, 0, commandBuffer, queryPool, firstQuery, queryCount, &submit);
}

static inline void vn_call_vkCmdWriteTimestamp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWriteTimestamp(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineStage, queryPool, query, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdWriteTimestamp_reply(dec, commandBuffer, pipelineStage, queryPool, query);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdWriteTimestamp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWriteTimestamp(vn_ring, 0, commandBuffer, pipelineStage, queryPool, query, &submit);
}

static inline void vn_call_vkCmdCopyQueryPoolResults(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyQueryPoolResults(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyQueryPoolResults_reply(dec, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyQueryPoolResults(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyQueryPoolResults(vn_ring, 0, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags, &submit);
}

static inline void vn_call_vkCmdPushConstants(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushConstants(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, layout, stageFlags, offset, size, pValues, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPushConstants_reply(dec, commandBuffer, layout, stageFlags, offset, size, pValues);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPushConstants(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushConstants(vn_ring, 0, commandBuffer, layout, stageFlags, offset, size, pValues, &submit);
}

static inline void vn_call_vkCmdBeginRenderPass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRenderPass(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pRenderPassBegin, contents, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginRenderPass_reply(dec, commandBuffer, pRenderPassBegin, contents);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginRenderPass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRenderPass(vn_ring, 0, commandBuffer, pRenderPassBegin, contents, &submit);
}

static inline void vn_call_vkCmdNextSubpass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdNextSubpass(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, contents, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdNextSubpass_reply(dec, commandBuffer, contents);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdNextSubpass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdNextSubpass(vn_ring, 0, commandBuffer, contents, &submit);
}

static inline void vn_call_vkCmdEndRenderPass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRenderPass(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndRenderPass_reply(dec, commandBuffer);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndRenderPass(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRenderPass(vn_ring, 0, commandBuffer, &submit);
}

static inline void vn_call_vkCmdExecuteCommands(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdExecuteCommands(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, commandBufferCount, pCommandBuffers, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdExecuteCommands_reply(dec, commandBuffer, commandBufferCount, pCommandBuffers);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdExecuteCommands(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdExecuteCommands(vn_ring, 0, commandBuffer, commandBufferCount, pCommandBuffers, &submit);
}

static inline void vn_call_vkCmdPushDescriptorSet(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushDescriptorSet(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPushDescriptorSet_reply(dec, commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPushDescriptorSet(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushDescriptorSet(vn_ring, 0, commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites, &submit);
}

static inline void vn_call_vkCmdSetDeviceMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDeviceMask(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, deviceMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDeviceMask_reply(dec, commandBuffer, deviceMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDeviceMask(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDeviceMask(vn_ring, 0, commandBuffer, deviceMask, &submit);
}

static inline void vn_call_vkCmdDispatchBase(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatchBase(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDispatchBase_reply(dec, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDispatchBase(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDispatchBase(vn_ring, 0, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ, &submit);
}

static inline void vn_call_vkCmdSetSampleLocationsEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleLocationsEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pSampleLocationsInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetSampleLocationsEXT_reply(dec, commandBuffer, pSampleLocationsInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetSampleLocationsEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleLocationsEXT(vn_ring, 0, commandBuffer, pSampleLocationsInfo, &submit);
}

static inline void vn_call_vkCmdBeginRenderPass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRenderPass2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pRenderPassBegin, pSubpassBeginInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginRenderPass2_reply(dec, commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginRenderPass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRenderPass2(vn_ring, 0, commandBuffer, pRenderPassBegin, pSubpassBeginInfo, &submit);
}

static inline void vn_call_vkCmdNextSubpass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdNextSubpass2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdNextSubpass2_reply(dec, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdNextSubpass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdNextSubpass2(vn_ring, 0, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, &submit);
}

static inline void vn_call_vkCmdEndRenderPass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRenderPass2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pSubpassEndInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndRenderPass2_reply(dec, commandBuffer, pSubpassEndInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndRenderPass2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRenderPass2(vn_ring, 0, commandBuffer, pSubpassEndInfo, &submit);
}

static inline void vn_call_vkCmdDrawIndirectCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirectCount(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndirectCount_reply(dec, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndirectCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirectCount(vn_ring, 0, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
}

static inline void vn_call_vkCmdDrawIndexedIndirectCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirectCount(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndexedIndirectCount_reply(dec, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndexedIndirectCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirectCount(vn_ring, 0, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
}

static inline void vn_call_vkCmdBindTransformFeedbackBuffersEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindTransformFeedbackBuffersEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindTransformFeedbackBuffersEXT_reply(dec, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindTransformFeedbackBuffersEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindTransformFeedbackBuffersEXT(vn_ring, 0, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, &submit);
}

static inline void vn_call_vkCmdBeginTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginTransformFeedbackEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginTransformFeedbackEXT_reply(dec, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginTransformFeedbackEXT(vn_ring, 0, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
}

static inline void vn_call_vkCmdEndTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndTransformFeedbackEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndTransformFeedbackEXT_reply(dec, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndTransformFeedbackEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndTransformFeedbackEXT(vn_ring, 0, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
}

static inline void vn_call_vkCmdBeginQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginQueryIndexedEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, flags, index, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginQueryIndexedEXT_reply(dec, commandBuffer, queryPool, query, flags, index);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginQueryIndexedEXT(vn_ring, 0, commandBuffer, queryPool, query, flags, index, &submit);
}

static inline void vn_call_vkCmdEndQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndQueryIndexedEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, index, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndQueryIndexedEXT_reply(dec, commandBuffer, queryPool, query, index);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndQueryIndexedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndQueryIndexedEXT(vn_ring, 0, commandBuffer, queryPool, query, index, &submit);
}

static inline void vn_call_vkCmdDrawIndirectByteCountEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirectByteCountEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdDrawIndirectByteCountEXT_reply(dec, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdDrawIndirectByteCountEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdDrawIndirectByteCountEXT(vn_ring, 0, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride, &submit);
}

static inline void vn_call_vkCmdSetLineStipple(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineStipple(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, lineStippleFactor, lineStipplePattern, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLineStipple_reply(dec, commandBuffer, lineStippleFactor, lineStipplePattern);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLineStipple(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineStipple(vn_ring, 0, commandBuffer, lineStippleFactor, lineStipplePattern, &submit);
}

static inline void vn_call_vkCmdSetCullMode(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetCullMode(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, cullMode, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetCullMode_reply(dec, commandBuffer, cullMode);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetCullMode(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCullModeFlags cullMode)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetCullMode(vn_ring, 0, commandBuffer, cullMode, &submit);
}

static inline void vn_call_vkCmdSetFrontFace(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetFrontFace(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, frontFace, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetFrontFace_reply(dec, commandBuffer, frontFace);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetFrontFace(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkFrontFace frontFace)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetFrontFace(vn_ring, 0, commandBuffer, frontFace, &submit);
}

static inline void vn_call_vkCmdSetPrimitiveTopology(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPrimitiveTopology(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, primitiveTopology, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetPrimitiveTopology_reply(dec, commandBuffer, primitiveTopology);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetPrimitiveTopology(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPrimitiveTopology(vn_ring, 0, commandBuffer, primitiveTopology, &submit);
}

static inline void vn_call_vkCmdSetViewportWithCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetViewportWithCount(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, viewportCount, pViewports, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetViewportWithCount_reply(dec, commandBuffer, viewportCount, pViewports);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetViewportWithCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetViewportWithCount(vn_ring, 0, commandBuffer, viewportCount, pViewports, &submit);
}

static inline void vn_call_vkCmdSetScissorWithCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetScissorWithCount(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, scissorCount, pScissors, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetScissorWithCount_reply(dec, commandBuffer, scissorCount, pScissors);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetScissorWithCount(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetScissorWithCount(vn_ring, 0, commandBuffer, scissorCount, pScissors, &submit);
}

static inline void vn_call_vkCmdBindIndexBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, size, indexType, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindIndexBuffer2_reply(dec, commandBuffer, buffer, offset, size, indexType);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindIndexBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer2(vn_ring, 0, commandBuffer, buffer, offset, size, indexType, &submit);
}

static inline void vn_call_vkCmdBindVertexBuffers2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindVertexBuffers2_reply(dec, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindVertexBuffers2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers2(vn_ring, 0, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides, &submit);
}

static inline void vn_call_vkCmdSetDepthTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthTestEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthTestEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthTestEnable_reply(dec, commandBuffer, depthTestEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthTestEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthTestEnable(vn_ring, 0, commandBuffer, depthTestEnable, &submit);
}

static inline void vn_call_vkCmdSetDepthWriteEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthWriteEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthWriteEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthWriteEnable_reply(dec, commandBuffer, depthWriteEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthWriteEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthWriteEnable(vn_ring, 0, commandBuffer, depthWriteEnable, &submit);
}

static inline void vn_call_vkCmdSetDepthCompareOp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthCompareOp(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthCompareOp, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthCompareOp_reply(dec, commandBuffer, depthCompareOp);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthCompareOp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthCompareOp(vn_ring, 0, commandBuffer, depthCompareOp, &submit);
}

static inline void vn_call_vkCmdSetDepthBoundsTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBoundsTestEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthBoundsTestEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthBoundsTestEnable_reply(dec, commandBuffer, depthBoundsTestEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthBoundsTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBoundsTestEnable(vn_ring, 0, commandBuffer, depthBoundsTestEnable, &submit);
}

static inline void vn_call_vkCmdSetStencilTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilTestEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, stencilTestEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetStencilTestEnable_reply(dec, commandBuffer, stencilTestEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetStencilTestEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilTestEnable(vn_ring, 0, commandBuffer, stencilTestEnable, &submit);
}

static inline void vn_call_vkCmdSetStencilOp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilOp(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetStencilOp_reply(dec, commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetStencilOp(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetStencilOp(vn_ring, 0, commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, &submit);
}

static inline void vn_call_vkCmdSetPatchControlPointsEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPatchControlPointsEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, patchControlPoints, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetPatchControlPointsEXT_reply(dec, commandBuffer, patchControlPoints);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetPatchControlPointsEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t patchControlPoints)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPatchControlPointsEXT(vn_ring, 0, commandBuffer, patchControlPoints, &submit);
}

static inline void vn_call_vkCmdSetRasterizerDiscardEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizerDiscardEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, rasterizerDiscardEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetRasterizerDiscardEnable_reply(dec, commandBuffer, rasterizerDiscardEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetRasterizerDiscardEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizerDiscardEnable(vn_ring, 0, commandBuffer, rasterizerDiscardEnable, &submit);
}

static inline void vn_call_vkCmdSetDepthBiasEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBiasEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthBiasEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthBiasEnable_reply(dec, commandBuffer, depthBiasEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthBiasEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthBiasEnable(vn_ring, 0, commandBuffer, depthBiasEnable, &submit);
}

static inline void vn_call_vkCmdSetLogicOpEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLogicOpEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, logicOp, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLogicOpEXT_reply(dec, commandBuffer, logicOp);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLogicOpEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkLogicOp logicOp)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLogicOpEXT(vn_ring, 0, commandBuffer, logicOp, &submit);
}

static inline void vn_call_vkCmdSetPrimitiveRestartEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPrimitiveRestartEnable(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, primitiveRestartEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetPrimitiveRestartEnable_reply(dec, commandBuffer, primitiveRestartEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetPrimitiveRestartEnable(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPrimitiveRestartEnable(vn_ring, 0, commandBuffer, primitiveRestartEnable, &submit);
}

static inline void vn_call_vkCmdSetTessellationDomainOriginEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetTessellationDomainOriginEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, domainOrigin, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetTessellationDomainOriginEXT_reply(dec, commandBuffer, domainOrigin);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetTessellationDomainOriginEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetTessellationDomainOriginEXT(vn_ring, 0, commandBuffer, domainOrigin, &submit);
}

static inline void vn_call_vkCmdSetDepthClampEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClampEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthClampEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthClampEnableEXT_reply(dec, commandBuffer, depthClampEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthClampEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthClampEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClampEnableEXT(vn_ring, 0, commandBuffer, depthClampEnable, &submit);
}

static inline void vn_call_vkCmdSetPolygonModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPolygonModeEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, polygonMode, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetPolygonModeEXT_reply(dec, commandBuffer, polygonMode);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetPolygonModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPolygonMode polygonMode)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetPolygonModeEXT(vn_ring, 0, commandBuffer, polygonMode, &submit);
}

static inline void vn_call_vkCmdSetRasterizationSamplesEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizationSamplesEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, rasterizationSamples, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetRasterizationSamplesEXT_reply(dec, commandBuffer, rasterizationSamples);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetRasterizationSamplesEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizationSamplesEXT(vn_ring, 0, commandBuffer, rasterizationSamples, &submit);
}

static inline void vn_call_vkCmdSetSampleMaskEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleMaskEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, samples, pSampleMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetSampleMaskEXT_reply(dec, commandBuffer, samples, pSampleMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetSampleMaskEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleMaskEXT(vn_ring, 0, commandBuffer, samples, pSampleMask, &submit);
}

static inline void vn_call_vkCmdSetAlphaToCoverageEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetAlphaToCoverageEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, alphaToCoverageEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetAlphaToCoverageEnableEXT_reply(dec, commandBuffer, alphaToCoverageEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetAlphaToCoverageEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetAlphaToCoverageEnableEXT(vn_ring, 0, commandBuffer, alphaToCoverageEnable, &submit);
}

static inline void vn_call_vkCmdSetAlphaToOneEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetAlphaToOneEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, alphaToOneEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetAlphaToOneEnableEXT_reply(dec, commandBuffer, alphaToOneEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetAlphaToOneEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetAlphaToOneEnableEXT(vn_ring, 0, commandBuffer, alphaToOneEnable, &submit);
}

static inline void vn_call_vkCmdSetLogicOpEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLogicOpEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, logicOpEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLogicOpEnableEXT_reply(dec, commandBuffer, logicOpEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLogicOpEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 logicOpEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLogicOpEnableEXT(vn_ring, 0, commandBuffer, logicOpEnable, &submit);
}

static inline void vn_call_vkCmdSetColorBlendEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetColorBlendEnableEXT_reply(dec, commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetColorBlendEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendEnableEXT(vn_ring, 0, commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables, &submit);
}

static inline void vn_call_vkCmdSetColorBlendEquationEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendEquationEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetColorBlendEquationEXT_reply(dec, commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetColorBlendEquationEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendEquationEXT(vn_ring, 0, commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations, &submit);
}

static inline void vn_call_vkCmdSetColorWriteMaskEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorWriteMaskEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetColorWriteMaskEXT_reply(dec, commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetColorWriteMaskEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorWriteMaskEXT(vn_ring, 0, commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks, &submit);
}

static inline void vn_call_vkCmdSetRasterizationStreamEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizationStreamEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, rasterizationStream, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetRasterizationStreamEXT_reply(dec, commandBuffer, rasterizationStream);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetRasterizationStreamEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t rasterizationStream)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRasterizationStreamEXT(vn_ring, 0, commandBuffer, rasterizationStream, &submit);
}

static inline void vn_call_vkCmdSetConservativeRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetConservativeRasterizationModeEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, conservativeRasterizationMode, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetConservativeRasterizationModeEXT_reply(dec, commandBuffer, conservativeRasterizationMode);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetConservativeRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetConservativeRasterizationModeEXT(vn_ring, 0, commandBuffer, conservativeRasterizationMode, &submit);
}

static inline void vn_call_vkCmdSetExtraPrimitiveOverestimationSizeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetExtraPrimitiveOverestimationSizeEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, extraPrimitiveOverestimationSize, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetExtraPrimitiveOverestimationSizeEXT_reply(dec, commandBuffer, extraPrimitiveOverestimationSize);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetExtraPrimitiveOverestimationSizeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetExtraPrimitiveOverestimationSizeEXT(vn_ring, 0, commandBuffer, extraPrimitiveOverestimationSize, &submit);
}

static inline void vn_call_vkCmdSetDepthClipEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClipEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthClipEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthClipEnableEXT_reply(dec, commandBuffer, depthClipEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthClipEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 depthClipEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClipEnableEXT(vn_ring, 0, commandBuffer, depthClipEnable, &submit);
}

static inline void vn_call_vkCmdSetSampleLocationsEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleLocationsEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, sampleLocationsEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetSampleLocationsEnableEXT_reply(dec, commandBuffer, sampleLocationsEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetSampleLocationsEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetSampleLocationsEnableEXT(vn_ring, 0, commandBuffer, sampleLocationsEnable, &submit);
}

static inline void vn_call_vkCmdSetColorBlendAdvancedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendAdvancedEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetColorBlendAdvancedEXT_reply(dec, commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetColorBlendAdvancedEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorBlendAdvancedEXT(vn_ring, 0, commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced, &submit);
}

static inline void vn_call_vkCmdSetProvokingVertexModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetProvokingVertexModeEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, provokingVertexMode, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetProvokingVertexModeEXT_reply(dec, commandBuffer, provokingVertexMode);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetProvokingVertexModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetProvokingVertexModeEXT(vn_ring, 0, commandBuffer, provokingVertexMode, &submit);
}

static inline void vn_call_vkCmdSetLineRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineRasterizationModeEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, lineRasterizationMode, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLineRasterizationModeEXT_reply(dec, commandBuffer, lineRasterizationMode);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLineRasterizationModeEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkLineRasterizationMode lineRasterizationMode)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineRasterizationModeEXT(vn_ring, 0, commandBuffer, lineRasterizationMode, &submit);
}

static inline void vn_call_vkCmdSetLineStippleEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineStippleEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, stippledLineEnable, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetLineStippleEnableEXT_reply(dec, commandBuffer, stippledLineEnable);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetLineStippleEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetLineStippleEnableEXT(vn_ring, 0, commandBuffer, stippledLineEnable, &submit);
}

static inline void vn_call_vkCmdSetDepthClipNegativeOneToOneEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClipNegativeOneToOneEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, negativeOneToOne, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetDepthClipNegativeOneToOneEXT_reply(dec, commandBuffer, negativeOneToOne);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetDepthClipNegativeOneToOneEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetDepthClipNegativeOneToOneEXT(vn_ring, 0, commandBuffer, negativeOneToOne, &submit);
}

static inline void vn_call_vkCmdCopyBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBuffer2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pCopyBufferInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyBuffer2_reply(dec, commandBuffer, pCopyBufferInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBuffer2(vn_ring, 0, commandBuffer, pCopyBufferInfo, &submit);
}

static inline void vn_call_vkCmdCopyImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImage2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pCopyImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyImage2_reply(dec, commandBuffer, pCopyImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImage2(vn_ring, 0, commandBuffer, pCopyImageInfo, &submit);
}

static inline void vn_call_vkCmdBlitImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBlitImage2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pBlitImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBlitImage2_reply(dec, commandBuffer, pBlitImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBlitImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBlitImage2(vn_ring, 0, commandBuffer, pBlitImageInfo, &submit);
}

static inline void vn_call_vkCmdCopyBufferToImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pCopyBufferToImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyBufferToImage2_reply(dec, commandBuffer, pCopyBufferToImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyBufferToImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage2(vn_ring, 0, commandBuffer, pCopyBufferToImageInfo, &submit);
}

static inline void vn_call_vkCmdCopyImageToBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pCopyImageToBufferInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdCopyImageToBuffer2_reply(dec, commandBuffer, pCopyImageToBufferInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdCopyImageToBuffer2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer2(vn_ring, 0, commandBuffer, pCopyImageToBufferInfo, &submit);
}

static inline void vn_call_vkCmdResolveImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResolveImage2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pResolveImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdResolveImage2_reply(dec, commandBuffer, pResolveImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdResolveImage2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResolveImage2(vn_ring, 0, commandBuffer, pResolveImageInfo, &submit);
}

static inline void vn_call_vkCmdSetFragmentShadingRateKHR(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetFragmentShadingRateKHR(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pFragmentSize, combinerOps, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetFragmentShadingRateKHR_reply(dec, commandBuffer, pFragmentSize, combinerOps);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetFragmentShadingRateKHR(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2])
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetFragmentShadingRateKHR(vn_ring, 0, commandBuffer, pFragmentSize, combinerOps, &submit);
}

static inline void vn_call_vkCmdSetVertexInputEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetVertexInputEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetVertexInputEXT_reply(dec, commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetVertexInputEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetVertexInputEXT(vn_ring, 0, commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions, &submit);
}

static inline void vn_call_vkCmdSetColorWriteEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorWriteEnableEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, attachmentCount, pColorWriteEnables, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetColorWriteEnableEXT_reply(dec, commandBuffer, attachmentCount, pColorWriteEnables);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetColorWriteEnableEXT(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetColorWriteEnableEXT(vn_ring, 0, commandBuffer, attachmentCount, pColorWriteEnables, &submit);
}

static inline void vn_call_vkCmdSetEvent2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetEvent2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, pDependencyInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetEvent2_reply(dec, commandBuffer, event, pDependencyInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetEvent2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetEvent2(vn_ring, 0, commandBuffer, event, pDependencyInfo, &submit);
}

static inline void vn_call_vkCmdResetEvent2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetEvent2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, stageMask, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdResetEvent2_reply(dec, commandBuffer, event, stageMask);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdResetEvent2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdResetEvent2(vn_ring, 0, commandBuffer, event, stageMask, &submit);
}

static inline void vn_call_vkCmdWaitEvents2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWaitEvents2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, eventCount, pEvents, pDependencyInfos, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdWaitEvents2_reply(dec, commandBuffer, eventCount, pEvents, pDependencyInfos);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdWaitEvents2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWaitEvents2(vn_ring, 0, commandBuffer, eventCount, pEvents, pDependencyInfos, &submit);
}

static inline void vn_call_vkCmdPipelineBarrier2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPipelineBarrier2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pDependencyInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPipelineBarrier2_reply(dec, commandBuffer, pDependencyInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPipelineBarrier2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPipelineBarrier2(vn_ring, 0, commandBuffer, pDependencyInfo, &submit);
}

static inline void vn_call_vkCmdWriteTimestamp2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWriteTimestamp2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, stage, queryPool, query, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdWriteTimestamp2_reply(dec, commandBuffer, stage, queryPool, query);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdWriteTimestamp2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdWriteTimestamp2(vn_ring, 0, commandBuffer, stage, queryPool, query, &submit);
}

static inline void vn_call_vkCmdBeginRendering(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRendering(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pRenderingInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBeginRendering_reply(dec, commandBuffer, pRenderingInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBeginRendering(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBeginRendering(vn_ring, 0, commandBuffer, pRenderingInfo, &submit);
}

static inline void vn_call_vkCmdEndRendering(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRendering(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdEndRendering_reply(dec, commandBuffer);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdEndRendering(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdEndRendering(vn_ring, 0, commandBuffer, &submit);
}

static inline void vn_call_vkCmdBindDescriptorSets2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pBindDescriptorSetsInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdBindDescriptorSets2_reply(dec, commandBuffer, pBindDescriptorSetsInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdBindDescriptorSets2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets2(vn_ring, 0, commandBuffer, pBindDescriptorSetsInfo, &submit);
}

static inline void vn_call_vkCmdPushConstants2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushConstants2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pPushConstantsInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPushConstants2_reply(dec, commandBuffer, pPushConstantsInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPushConstants2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushConstants2(vn_ring, 0, commandBuffer, pPushConstantsInfo, &submit);
}

static inline void vn_call_vkCmdPushDescriptorSet2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushDescriptorSet2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pPushDescriptorSetInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdPushDescriptorSet2_reply(dec, commandBuffer, pPushDescriptorSetInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdPushDescriptorSet2(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdPushDescriptorSet2(vn_ring, 0, commandBuffer, pPushDescriptorSetInfo, &submit);
}

static inline void vn_call_vkCmdSetRenderingAttachmentLocations(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRenderingAttachmentLocations(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pLocationInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetRenderingAttachmentLocations_reply(dec, commandBuffer, pLocationInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetRenderingAttachmentLocations(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRenderingAttachmentLocations(vn_ring, 0, commandBuffer, pLocationInfo, &submit);
}

static inline void vn_call_vkCmdSetRenderingInputAttachmentIndices(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRenderingInputAttachmentIndices(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pInputAttachmentIndexInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkCmdSetRenderingInputAttachmentIndices_reply(dec, commandBuffer, pInputAttachmentIndexInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkCmdSetRenderingInputAttachmentIndices(struct vn_ring *vn_ring, VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCmdSetRenderingInputAttachmentIndices(vn_ring, 0, commandBuffer, pInputAttachmentIndexInfo, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H */
