
/* Copyright © 2023 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
#include "vk_synchronization.h"

VkPipelineStageFlags2
vk_expand_pipeline_stage_flags2(VkPipelineStageFlags2 stages)
{
    if (stages & VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT)
        stages |= VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT;

    if (stages & VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT)
        stages |= VK_PIPELINE_STAGE_2_COPY_BIT |
                  VK_PIPELINE_STAGE_2_BLIT_BIT |
                  VK_PIPELINE_STAGE_2_RESOLVE_BIT |
                  VK_PIPELINE_STAGE_2_CLEAR_BIT |
                  VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR;

    if (stages & VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT)
        stages |= VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
                  VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
                  VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
                  VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
                  VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI;

    if (stages & VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT)
        stages |= VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI;

    if (stages & VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT) {
        stages |= VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT;
        stages |= VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT;
        stages |= VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT;
        stages |= VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT;
        stages |= VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT;
        stages |= VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT;
        stages |= VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT;
        stages |= VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT;
        stages |= VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT;
        stages |= VK_PIPELINE_STAGE_2_COPY_BIT;
        stages |= VK_PIPELINE_STAGE_2_RESOLVE_BIT;
        stages |= VK_PIPELINE_STAGE_2_BLIT_BIT;
        stages |= VK_PIPELINE_STAGE_2_CLEAR_BIT;
        stages |= VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT;
        stages |= VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT;
        stages |= VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT;
        stages |= VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI;
        stages |= VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI;
        stages |= VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR;
        stages |= VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT;
        stages |= VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI;
        stages |= VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV;
        stages |= VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV;
    }

    return stages;
}

VkAccessFlags2
vk_read_access2_for_pipeline_stage_flags2(VkPipelineStageFlags2 stages)
{
    VkAccessFlags2 access = 0;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT))
        access |= VK_ACCESS_2_INDEX_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT))
        access |= VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT |
                  VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT))
        access |= VK_ACCESS_2_UNIFORM_READ_BIT |
                  VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
                  VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
                  VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT |
                  VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT |
                  VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT |
                  VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT))
        access |= VK_ACCESS_2_SHADER_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_BLIT_BIT |
                  VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV |
                  VK_PIPELINE_STAGE_2_COPY_BIT |
                  VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT |
                  VK_PIPELINE_STAGE_2_RESOLVE_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_TRANSFER_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_HOST_BIT))
        access |= VK_ACCESS_2_HOST_READ_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR))
        access |= VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR))
        access |= VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT))
        access |= VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT |
                  VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT))
        access |= VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_MICROMAP_READ_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV |
                  VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT))
        access |= VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV;

    return access;
}

VkAccessFlags2
vk_write_access2_for_pipeline_stage_flags2(VkPipelineStageFlags2 stages)
{
    VkAccessFlags2 access = 0;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT |
                  VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
                  VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI |
                  VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
                  VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT))
        access |= VK_ACCESS_2_SHADER_WRITE_BIT |
                  VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT))
        access |= VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
                  VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT))
        access |= VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_BLIT_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_CLEAR_BIT |
                  VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV |
                  VK_PIPELINE_STAGE_2_COPY_BIT |
                  VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT |
                  VK_PIPELINE_STAGE_2_RESOLVE_BIT))
        access |= VK_ACCESS_2_TRANSFER_WRITE_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_HOST_BIT))
        access |= VK_ACCESS_2_HOST_WRITE_BIT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR))
        access |= VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR))
        access |= VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT))
        access |= VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT |
                  VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT))
        access |= VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR |
                  VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT))
        access |= VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT))
        access |= VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT;

    if (stages & (VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT |
                  VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
                  VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV))
        access |= VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV;

    return access;
}
