/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 59;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_nxv1s1,
  GILLT_nxv2s1,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv8s1,
  GILLT_nxv8s16,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
};
const static size_t NumTypeObjects = 24;
const static LLT TypeObjects[] = {
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasPAuthBit = 7,
  Feature_HasJSBit = 9,
  Feature_HasComplxNumBit = 40,
  Feature_HasFPARMv8Bit = 8,
  Feature_HasNEONBit = 3,
  Feature_HasSM4Bit = 39,
  Feature_HasSHA3Bit = 38,
  Feature_HasSHA2Bit = 18,
  Feature_HasAESBit = 17,
  Feature_HasDotProdBit = 1,
  Feature_HasCRCBit = 11,
  Feature_HasCSSCBit = 19,
  Feature_HasNoCSSCBit = 23,
  Feature_HasLSEBit = 24,
  Feature_HasNoLSEBit = 58,
  Feature_HasRDMBit = 16,
  Feature_HasFullFP16Bit = 14,
  Feature_HasFP16FMLBit = 6,
  Feature_HasFuseAESBit = 49,
  Feature_HasSVEBit = 20,
  Feature_HasSVE2Bit = 21,
  Feature_HasSVE2AESBit = 28,
  Feature_HasSVE2SM4Bit = 30,
  Feature_HasSVE2SHA3Bit = 57,
  Feature_HasSVE2BitPermBit = 29,
  Feature_HasSMEBit = 33,
  Feature_HasSMEF64F64Bit = 34,
  Feature_HasSMEI16I64Bit = 35,
  Feature_HasSME2Bit = 37,
  Feature_HasSVEorSMEBit = 0,
  Feature_HasSVE2orSMEBit = 25,
  Feature_HasSVE2p1_or_HasSMEBit = 36,
  Feature_HasSVE2p1_or_HasSME2Bit = 22,
  Feature_HasNEONorSMEBit = 4,
  Feature_HasRCPCBit = 55,
  Feature_HasFRInt3264Bit = 15,
  Feature_HasMTEBit = 12,
  Feature_HasTMEBit = 10,
  Feature_HasBF16Bit = 2,
  Feature_HasMatMulInt8Bit = 5,
  Feature_HasMatMulFP32Bit = 31,
  Feature_HasMatMulFP64Bit = 32,
  Feature_HasLS64Bit = 53,
  Feature_HasHBCBit = 13,
  Feature_HasRCPC3Bit = 54,
  Feature_IsLEBit = 44,
  Feature_IsBEBit = 50,
  Feature_UseExperimentalZeroingPseudosBit = 27,
  Feature_UseAlternateSExtLoadCVTF32Bit = 47,
  Feature_UseScalarIncVLBit = 26,
  Feature_UseSVEFPLD1RBit = 56,
  Feature_IsNeonAvailableBit = 48,
  Feature_NotForCodeSizeBit = 46,
  Feature_UseSTRQroBit = 45,
  Feature_UseBTIBit = 52,
  Feature_NotUseBTIBit = 51,
  Feature_SLSBLRMitigationBit = 43,
  Feature_NoSLSBLRMitigationBit = 42,
  Feature_OptimizedGISelOrOtherSelectorBit = 41,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasPAuth())
    Features.set(Feature_HasPAuthBit);
  if (Subtarget->hasJS())
    Features.set(Feature_HasJSBit);
  if (Subtarget->hasComplxNum())
    Features.set(Feature_HasComplxNumBit);
  if (Subtarget->hasFPARMv8())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasSHA3())
    Features.set(Feature_HasSHA3Bit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasCSSC())
    Features.set(Feature_HasCSSCBit);
  if (!Subtarget->hasCSSC())
    Features.set(Feature_HasNoCSSCBit);
  if (Subtarget->hasLSE())
    Features.set(Feature_HasLSEBit);
  if (!Subtarget->hasLSE())
    Features.set(Feature_HasNoLSEBit);
  if (Subtarget->hasRDM())
    Features.set(Feature_HasRDMBit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasFP16FML())
    Features.set(Feature_HasFP16FMLBit);
  if (Subtarget->hasFuseAES())
    Features.set(Feature_HasFuseAESBit);
  if (Subtarget->hasSVE())
    Features.set(Feature_HasSVEBit);
  if (Subtarget->hasSVE2())
    Features.set(Feature_HasSVE2Bit);
  if (Subtarget->hasSVE2AES())
    Features.set(Feature_HasSVE2AESBit);
  if (Subtarget->hasSVE2SM4())
    Features.set(Feature_HasSVE2SM4Bit);
  if (Subtarget->hasSVE2SHA3())
    Features.set(Feature_HasSVE2SHA3Bit);
  if (Subtarget->hasSVE2BitPerm())
    Features.set(Feature_HasSVE2BitPermBit);
  if (Subtarget->hasSME())
    Features.set(Feature_HasSMEBit);
  if (Subtarget->hasSMEF64F64())
    Features.set(Feature_HasSMEF64F64Bit);
  if (Subtarget->hasSMEI16I64())
    Features.set(Feature_HasSMEI16I64Bit);
  if (Subtarget->hasSME2())
    Features.set(Feature_HasSME2Bit);
  if (Subtarget->hasSVEorSME())
    Features.set(Feature_HasSVEorSMEBit);
  if (Subtarget->hasSVE2() || Subtarget->hasSME())
    Features.set(Feature_HasSVE2orSMEBit);
  if (Subtarget->hasSVE2p1() || Subtarget->hasSME())
    Features.set(Feature_HasSVE2p1_or_HasSMEBit);
  if (Subtarget->hasSVE2p1() || Subtarget->hasSME2())
    Features.set(Feature_HasSVE2p1_or_HasSME2Bit);
  if (Subtarget->hasNEON() || Subtarget->hasSME())
    Features.set(Feature_HasNEONorSMEBit);
  if (Subtarget->hasRCPC())
    Features.set(Feature_HasRCPCBit);
  if (Subtarget->hasFRInt3264())
    Features.set(Feature_HasFRInt3264Bit);
  if (Subtarget->hasMTE())
    Features.set(Feature_HasMTEBit);
  if (Subtarget->hasTME())
    Features.set(Feature_HasTMEBit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasMatMulFP32())
    Features.set(Feature_HasMatMulFP32Bit);
  if (Subtarget->hasMatMulFP64())
    Features.set(Feature_HasMatMulFP64Bit);
  if (Subtarget->hasLS64())
    Features.set(Feature_HasLS64Bit);
  if (Subtarget->hasHBC())
    Features.set(Feature_HasHBCBit);
  if (Subtarget->hasRCPC3())
    Features.set(Feature_HasRCPC3Bit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBEBit);
  if (Subtarget->useExperimentalZeroingPseudos())
    Features.set(Feature_UseExperimentalZeroingPseudosBit);
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features.set(Feature_UseAlternateSExtLoadCVTF32Bit);
  if (Subtarget->useScalarIncVL())
    Features.set(Feature_UseScalarIncVLBit);
  if (!Subtarget->noSVEFPLD1R())
    Features.set(Feature_UseSVEFPLD1RBit);
  if (Subtarget->isNeonAvailable())
    Features.set(Feature_IsNeonAvailableBit);
  return Features;
}

void AArch64InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (!shouldOptForSize(MF))
    Features.set(Feature_NotForCodeSizeBit);
  if (!Subtarget->isSTRQroSlow() || shouldOptForSize(MF))
    Features.set(Feature_UseSTRQroBit);
  if ( MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() )
    Features.set(Feature_UseBTIBit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() )
    Features.set(Feature_NotUseBTIBit);
  if ( MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (!MF->getFunction().hasOptNone() || MF->getProperties().hasProperty(MachineFunctionProperties::Property::FailedISel) || !MF->getProperties().hasProperty(MachineFunctionProperties::Property::Legalized))
    Features.set(Feature_OptimizedGISelOrOtherSelectorBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasCRC,
  GIFBS_HasCSSC,
  GIFBS_HasFPARMv8,
  GIFBS_HasFRInt3264,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasLSE,
  GIFBS_HasMTE,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasNEONorSME,
  GIFBS_HasNoCSSC,
  GIFBS_HasNoLSE,
  GIFBS_HasPAuth,
  GIFBS_HasRCPC,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_HasSHA3,
  GIFBS_HasSM4,
  GIFBS_HasSME,
  GIFBS_HasSME2,
  GIFBS_HasSMEF64F64,
  GIFBS_HasSMEI16I64,
  GIFBS_HasSVE,
  GIFBS_HasSVE2,
  GIFBS_HasSVE2AES,
  GIFBS_HasSVE2BitPerm,
  GIFBS_HasSVE2SHA3,
  GIFBS_HasSVE2SM4,
  GIFBS_HasSVE2orSME,
  GIFBS_HasSVE2p1_or_HasSME,
  GIFBS_HasSVE2p1_or_HasSME2,
  GIFBS_HasSVEorSME,
  GIFBS_HasTME,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_IsNeonAvailable,
  GIFBS_OptimizedGISelOrOtherSelector,
  GIFBS_UseSTRQro,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasBF16_HasNEONorSME,
  GIFBS_HasBF16_HasSVE,
  GIFBS_HasBF16_HasSVEorSME,
  GIFBS_HasComplxNum_HasNEON,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFPARMv8_HasJS,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEONorSME,
  GIFBS_HasMatMulFP32_HasSVE,
  GIFBS_HasMatMulFP64_HasSVE,
  GIFBS_HasMatMulFP64_HasSVEorSME,
  GIFBS_HasMatMulInt8_HasSVE,
  GIFBS_HasMatMulInt8_HasSVEorSME,
  GIFBS_HasNEON_HasRCPC3,
  GIFBS_HasNEON_HasRDM,
  GIFBS_HasSVEorSME_UseScalarIncVL,
  GIFBS_IsLE_UseSTRQro,
  GIFBS_HasComplxNum_HasFullFP16_HasNEON,
  GIFBS_HasNEON_NotForCodeSize_UseAlternateSExtLoadCVTF32,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasCRCBit, },
  {Feature_HasCSSCBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFRInt3264Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasLSEBit, },
  {Feature_HasMTEBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasNEONorSMEBit, },
  {Feature_HasNoCSSCBit, },
  {Feature_HasNoLSEBit, },
  {Feature_HasPAuthBit, },
  {Feature_HasRCPCBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_HasSHA3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSMEBit, },
  {Feature_HasSME2Bit, },
  {Feature_HasSMEF64F64Bit, },
  {Feature_HasSMEI16I64Bit, },
  {Feature_HasSVEBit, },
  {Feature_HasSVE2Bit, },
  {Feature_HasSVE2AESBit, },
  {Feature_HasSVE2BitPermBit, },
  {Feature_HasSVE2SHA3Bit, },
  {Feature_HasSVE2SM4Bit, },
  {Feature_HasSVE2orSMEBit, },
  {Feature_HasSVE2p1_or_HasSMEBit, },
  {Feature_HasSVE2p1_or_HasSME2Bit, },
  {Feature_HasSVEorSMEBit, },
  {Feature_HasTMEBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_IsNeonAvailableBit, },
  {Feature_OptimizedGISelOrOtherSelectorBit, },
  {Feature_UseSTRQroBit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasBF16Bit, Feature_HasNEONorSMEBit, },
  {Feature_HasBF16Bit, Feature_HasSVEBit, },
  {Feature_HasBF16Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasComplxNumBit, Feature_HasNEONBit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasJSBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONorSMEBit, },
  {Feature_HasMatMulFP32Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasNEONBit, Feature_HasRCPC3Bit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
  {Feature_HasSVEorSMEBit, Feature_UseScalarIncVLBit, },
  {Feature_IsLEBit, Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_NotForCodeSizeBit, Feature_UseAlternateSExtLoadCVTF32Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
  GICP_gi_arith_extended_reg32_i32,
  GICP_gi_arith_extended_reg32_i64,
  GICP_gi_arith_extended_reg32to64_i64,
  GICP_gi_arith_shifted_reg32,
  GICP_gi_arith_shifted_reg64,
  GICP_gi_extract_high_v4f32,
  GICP_gi_extract_high_v8f16,
  GICP_gi_logical_shifted_reg32,
  GICP_gi_logical_shifted_reg64,
  GICP_gi_neg_addsub_shifted_imm32,
  GICP_gi_neg_addsub_shifted_imm64,
  GICP_gi_ro_Windexed128,
  GICP_gi_ro_Windexed16,
  GICP_gi_ro_Windexed32,
  GICP_gi_ro_Windexed64,
  GICP_gi_ro_Windexed8,
  GICP_gi_ro_Xindexed128,
  GICP_gi_ro_Xindexed16,
  GICP_gi_ro_Xindexed32,
  GICP_gi_ro_Xindexed64,
  GICP_gi_ro_Xindexed8,
};
// See constructor for table contents

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i32
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i64
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32to64_i64
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg32
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg64
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v4f32
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v8f16
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg32
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg64
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm32
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeWRO<128>, // gi_ro_Windexed128
  &AArch64InstructionSelector::selectAddrModeWRO<16>, // gi_ro_Windexed16
  &AArch64InstructionSelector::selectAddrModeWRO<32>, // gi_ro_Windexed32
  &AArch64InstructionSelector::selectAddrModeWRO<64>, // gi_ro_Windexed64
  &AArch64InstructionSelector::selectAddrModeWRO<8>, // gi_ro_Windexed8
  &AArch64InstructionSelector::selectAddrModeXRO<128>, // gi_ro_Xindexed128
  &AArch64InstructionSelector::selectAddrModeXRO<16>, // gi_ro_Xindexed16
  &AArch64InstructionSelector::selectAddrModeXRO<32>, // gi_ro_Xindexed32
  &AArch64InstructionSelector::selectAddrModeXRO<64>, // gi_ro_Xindexed64
  &AArch64InstructionSelector::selectAddrModeXRO<8>, // gi_ro_Xindexed8
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_and_or_is_add = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_ldaxr_1,
  GICXXPred_MI_Predicate_ldaxr_2,
  GICXXPred_MI_Predicate_ldaxr_4,
  GICXXPred_MI_Predicate_ldaxr_8,
  GICXXPred_MI_Predicate_ldxr_1,
  GICXXPred_MI_Predicate_ldxr_2,
  GICXXPred_MI_Predicate_ldxr_4,
  GICXXPred_MI_Predicate_ldxr_8,
  GICXXPred_MI_Predicate_stlxr_1,
  GICXXPred_MI_Predicate_stlxr_2,
  GICXXPred_MI_Predicate_stlxr_4,
  GICXXPred_MI_Predicate_stlxr_8,
  GICXXPred_MI_Predicate_stxr_1,
  GICXXPred_MI_Predicate_stxr_2,
  GICXXPred_MI_Predicate_stxr_4,
  GICXXPred_MI_Predicate_stxr_8,
};
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_and_or_is_add: {
    
     // Only handle G_ADD for now. FIXME. build capability to compute whether
     // operands of G_OR have common bits set or not.
     return MI.getOpcode() == TargetOpcode::G_ADD;
  
    llvm_unreachable("add_and_or_is_add should have returned");
  }
  case GICXXPred_MI_Predicate_ldaxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldaxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldaxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldaxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_ldxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_stlxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stlxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stlxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stlxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_stxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex0 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex0_timm,
  GICXXPred_I64_Predicate_VectorIndex1,
  GICXXPred_I64_Predicate_VectorIndex1_timm,
  GICXXPred_I64_Predicate_VectorIndex132b,
  GICXXPred_I64_Predicate_VectorIndex132b_timm,
  GICXXPred_I64_Predicate_VectorIndexB,
  GICXXPred_I64_Predicate_VectorIndexB32b,
  GICXXPred_I64_Predicate_VectorIndexB32b_timm,
  GICXXPred_I64_Predicate_VectorIndexB_timm,
  GICXXPred_I64_Predicate_VectorIndexD,
  GICXXPred_I64_Predicate_VectorIndexD32b,
  GICXXPred_I64_Predicate_VectorIndexD32b_timm,
  GICXXPred_I64_Predicate_VectorIndexD_timm,
  GICXXPred_I64_Predicate_VectorIndexH,
  GICXXPred_I64_Predicate_VectorIndexH32b,
  GICXXPred_I64_Predicate_VectorIndexH32b_timm,
  GICXXPred_I64_Predicate_VectorIndexH_timm,
  GICXXPred_I64_Predicate_VectorIndexS,
  GICXXPred_I64_Predicate_VectorIndexS32b,
  GICXXPred_I64_Predicate_VectorIndexS32b_timm,
  GICXXPred_I64_Predicate_VectorIndexS_timm,
  GICXXPred_I64_Predicate_complexrotateop,
  GICXXPred_I64_Predicate_complexrotateopodd,
  GICXXPred_I64_Predicate_i64imm_32bit,
  GICXXPred_I64_Predicate_i64imm_32bit_tgt,
  GICXXPred_I64_Predicate_imm0_1,
  GICXXPred_I64_Predicate_imm0_3,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_127,
  GICXXPred_I64_Predicate_imm0_127_64b,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm32_0_15,
  GICXXPred_I64_Predicate_imm32_0_31,
  GICXXPred_I64_Predicate_imm64_0_65535,
  GICXXPred_I64_Predicate_maski8_or_more,
  GICXXPred_I64_Predicate_maski16_or_more,
  GICXXPred_I64_Predicate_rprfop,
  GICXXPred_I64_Predicate_s64imm_32bit,
  GICXXPred_I64_Predicate_simm4s1,
  GICXXPred_I64_Predicate_simm4s2,
  GICXXPred_I64_Predicate_simm4s3,
  GICXXPred_I64_Predicate_simm4s4,
  GICXXPred_I64_Predicate_simm4s16,
  GICXXPred_I64_Predicate_simm4s32,
  GICXXPred_I64_Predicate_simm5_8b,
  GICXXPred_I64_Predicate_simm5_8b_tgt,
  GICXXPred_I64_Predicate_simm5_16b,
  GICXXPred_I64_Predicate_simm5_16b_tgt,
  GICXXPred_I64_Predicate_simm5_32b,
  GICXXPred_I64_Predicate_simm5_32b_tgt,
  GICXXPred_I64_Predicate_simm5_64b,
  GICXXPred_I64_Predicate_simm5_64b_tgt,
  GICXXPred_I64_Predicate_simm6_32b,
  GICXXPred_I64_Predicate_simm6s1,
  GICXXPred_I64_Predicate_simm8_32b,
  GICXXPred_I64_Predicate_simm8_64b,
  GICXXPred_I64_Predicate_simm9,
  GICXXPred_I64_Predicate_sme_elm_idx0_0,
  GICXXPred_I64_Predicate_sme_elm_idx0_1,
  GICXXPred_I64_Predicate_sme_elm_idx0_3,
  GICXXPred_I64_Predicate_sme_elm_idx0_7,
  GICXXPred_I64_Predicate_sme_elm_idx0_15,
  GICXXPred_I64_Predicate_svcr_op,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm,
  GICXXPred_I64_Predicate_sve_incdec_imm,
  GICXXPred_I64_Predicate_sve_pred_enum,
  GICXXPred_I64_Predicate_sve_prfop,
  GICXXPred_I64_Predicate_sve_vec_len_specifier_enum,
  GICXXPred_I64_Predicate_tbz_imm0_31_diag,
  GICXXPred_I64_Predicate_tbz_imm0_31_nodiag,
  GICXXPred_I64_Predicate_tbz_imm32_63,
  GICXXPred_I64_Predicate_timm0_1,
  GICXXPred_I64_Predicate_timm0_31,
  GICXXPred_I64_Predicate_timm0_63,
  GICXXPred_I64_Predicate_timm32_0_1,
  GICXXPred_I64_Predicate_timm32_0_3,
  GICXXPred_I64_Predicate_timm32_0_7,
  GICXXPred_I64_Predicate_timm32_0_15,
  GICXXPred_I64_Predicate_timm32_0_31,
  GICXXPred_I64_Predicate_timm32_0_255,
  GICXXPred_I64_Predicate_timm32_0_65535,
  GICXXPred_I64_Predicate_timm64_0_65535,
  GICXXPred_I64_Predicate_tuimm5s2,
  GICXXPred_I64_Predicate_tuimm5s4,
  GICXXPred_I64_Predicate_tuimm5s8,
  GICXXPred_I64_Predicate_tvecshiftL8,
  GICXXPred_I64_Predicate_tvecshiftL16,
  GICXXPred_I64_Predicate_tvecshiftL32,
  GICXXPred_I64_Predicate_tvecshiftL64,
  GICXXPred_I64_Predicate_tvecshiftR8,
  GICXXPred_I64_Predicate_tvecshiftR16,
  GICXXPred_I64_Predicate_tvecshiftR32,
  GICXXPred_I64_Predicate_tvecshiftR64,
  GICXXPred_I64_Predicate_ubsan_trap_imm,
  GICXXPred_I64_Predicate_uimm0s2range,
  GICXXPred_I64_Predicate_uimm0s4range,
  GICXXPred_I64_Predicate_uimm1s2range,
  GICXXPred_I64_Predicate_uimm1s4range,
  GICXXPred_I64_Predicate_uimm2s2range,
  GICXXPred_I64_Predicate_uimm2s4range,
  GICXXPred_I64_Predicate_uimm3s2range,
  GICXXPred_I64_Predicate_uimm3s8,
  GICXXPred_I64_Predicate_uimm5s2,
  GICXXPred_I64_Predicate_uimm5s4,
  GICXXPred_I64_Predicate_uimm5s8,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6s1,
  GICXXPred_I64_Predicate_uimm6s2,
  GICXXPred_I64_Predicate_uimm6s4,
  GICXXPred_I64_Predicate_uimm6s8,
  GICXXPred_I64_Predicate_uimm6s16,
  GICXXPred_I64_Predicate_uimm8_32b,
  GICXXPred_I64_Predicate_uimm8_64b,
  GICXXPred_I64_Predicate_uimm16,
  GICXXPred_I64_Predicate_vecshiftL8,
  GICXXPred_I64_Predicate_vecshiftL16,
  GICXXPred_I64_Predicate_vecshiftL32,
  GICXXPred_I64_Predicate_vecshiftL64,
  GICXXPred_I64_Predicate_vecshiftR8,
  GICXXPred_I64_Predicate_vecshiftR16,
  GICXXPred_I64_Predicate_vecshiftR16Narrow,
  GICXXPred_I64_Predicate_vecshiftR32,
  GICXXPred_I64_Predicate_vecshiftR32Narrow,
  GICXXPred_I64_Predicate_vecshiftR64,
  GICXXPred_I64_Predicate_vecshiftR64Narrow,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex0: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex0_timm: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_complexrotateop: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_complexrotateopodd: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

  }
  case GICXXPred_I64_Predicate_i64imm_32bit_tgt: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

  }
  case GICXXPred_I64_Predicate_imm0_1: {
    
  return ((uint64_t)Imm) < 2;

  }
  case GICXXPred_I64_Predicate_imm0_3: {
    
  return ((uint64_t)Imm) < 4;

  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
  return ((uint64_t)Imm) < 8;

  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
  return ((uint64_t)Imm) < 16;

  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
  return ((uint64_t)Imm) < 32;

  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
  return ((uint64_t)Imm) < 64;

  }
  case GICXXPred_I64_Predicate_imm0_127: {
    
  return ((uint32_t)Imm) < 128;

  }
  case GICXXPred_I64_Predicate_imm0_127_64b: {
    
  return ((uint64_t)Imm) < 128;

  }
  case GICXXPred_I64_Predicate_imm0_255: {
    
  return ((uint32_t)Imm) < 256;

  }
  case GICXXPred_I64_Predicate_imm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

  }
  case GICXXPred_I64_Predicate_imm32_0_31: {
    
  return ((uint64_t)Imm) < 32;

  }
  case GICXXPred_I64_Predicate_imm64_0_65535: {
    
  return ((uint64_t)Imm) < 65536;

  }
  case GICXXPred_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
  }
  case GICXXPred_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
  }
  case GICXXPred_I64_Predicate_rprfop: {
    
    return (((uint32_t)Imm) <= 63);
  
  }
  case GICXXPred_I64_Predicate_s64imm_32bit: {
    
  int64_t Imm64 = static_cast<int64_t>(Imm);
  return Imm64 >= std::numeric_limits<int32_t>::min() &&
         Imm64 <= std::numeric_limits<int32_t>::max();

    llvm_unreachable("s64imm_32bit should have returned");
  }
  case GICXXPred_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
  }
  case GICXXPred_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s32: {
     return Imm >=-256  && Imm <= 224 && (Imm % 32) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm5_8b: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_8b_tgt: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b_tgt: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b_tgt: {
     return (int32_t)Imm >= -16 && (int32_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b_tgt: {
     return (int64_t)Imm >= -16 && (int64_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm8_32b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm8_64b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_0: {
    
  return ((uint32_t)Imm) == 0;

  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_1: {
    
  return ((uint32_t)Imm) <= 1;

  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_3: {
    
  return ((uint32_t)Imm) <= 3;

  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_7: {
    
  return ((uint32_t)Imm) <= 7;

  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_15: {
    
  return ((uint32_t)Imm) <= 15;

  }
  case GICXXPred_I64_Predicate_svcr_op: {
    
    return AArch64SVCR::lookupSVCRByEncoding(Imm) != nullptr;
  
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_incdec_imm: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

  }
  case GICXXPred_I64_Predicate_sve_pred_enum: {
    
  return (((uint32_t)Imm) < 32);
  
  }
  case GICXXPred_I64_Predicate_sve_prfop: {
    
    return (((uint32_t)Imm) <= 15);
  
  }
  case GICXXPred_I64_Predicate_sve_vec_len_specifier_enum: {
    
  return (((uint32_t)Imm) < 2);
  
  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_diag: {
    
  return (((uint32_t)Imm) < 32);

  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_nodiag: {
    
  return (((uint32_t)Imm) < 32);

  }
  case GICXXPred_I64_Predicate_tbz_imm32_63: {
    
  return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);

  }
  case GICXXPred_I64_Predicate_timm0_1: {
    
  return ((uint64_t)Imm) < 2;

  }
  case GICXXPred_I64_Predicate_timm0_31: {
    
  return ((uint64_t)Imm) < 32;

  }
  case GICXXPred_I64_Predicate_timm0_63: {
    
  return ((uint64_t)Imm) < 64;

  }
  case GICXXPred_I64_Predicate_timm32_0_1: {
    
  return ((uint32_t)Imm) < 2;

  }
  case GICXXPred_I64_Predicate_timm32_0_3: {
    
  return ((uint32_t)Imm) < 4;

  }
  case GICXXPred_I64_Predicate_timm32_0_7: {
    
  return ((uint32_t)Imm) < 8;

  }
  case GICXXPred_I64_Predicate_timm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

  }
  case GICXXPred_I64_Predicate_timm32_0_31: {
    
  return ((uint32_t)Imm) < 32;

  }
  case GICXXPred_I64_Predicate_timm32_0_255: {
    
  return ((uint32_t)Imm) < 256;

  }
  case GICXXPred_I64_Predicate_timm32_0_65535: {
    
  return ((uint32_t)Imm) < 65536;

  }
  case GICXXPred_I64_Predicate_timm64_0_65535: {
    
  return ((uint64_t)Imm) < 65536;

  }
  case GICXXPred_I64_Predicate_tuimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_tvecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

  }
  case GICXXPred_I64_Predicate_tvecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

  }
  case GICXXPred_I64_Predicate_tvecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

  }
  case GICXXPred_I64_Predicate_tvecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

  }
  case GICXXPred_I64_Predicate_tvecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

  }
  case GICXXPred_I64_Predicate_tvecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

  }
  case GICXXPred_I64_Predicate_tvecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

  }
  case GICXXPred_I64_Predicate_tvecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

  }
  case GICXXPred_I64_Predicate_ubsan_trap_imm: {
    
  return isUInt<8>(Imm);

  }
  case GICXXPred_I64_Predicate_uimm0s2range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm0s4range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm1s2range: {
     return Imm >= 0 && Imm <= 2 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm1s4range: {
     return Imm >= 0 && Imm <= 4 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s2range: {
     return Imm >= 0 && Imm <= 6 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s4range: {
     return Imm >= 0 && Imm <= 12 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s2range: {
     return Imm >= 0 && Imm <= 14 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s8: {
     return Imm >= 0 && Imm <= 56 && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm8_32b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm8_64b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
  }
  case GICXXPred_I64_Predicate_vecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

  }
  case GICXXPred_I64_Predicate_vecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

  }
  case GICXXPred_I64_Predicate_vecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

  }
  case GICXXPred_I64_Predicate_vecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

  }
  case GICXXPred_I64_Predicate_vecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

  }
  case GICXXPred_I64_Predicate_vecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

  }
  case GICXXPred_I64_Predicate_vecshiftR16Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

  }
  case GICXXPred_I64_Predicate_vecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

  }
  case GICXXPred_I64_Predicate_vecshiftR32Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

  }
  case GICXXPred_I64_Predicate_vecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

  }
  case GICXXPred_I64_Predicate_vecshiftR64Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm16,
  GICXXPred_APFloat_Predicate_fpimm32,
  GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4,
  GICXXPred_APFloat_Predicate_fpimm64,
  GICXXPred_APFloat_Predicate_fpimm_half,
  GICXXPred_APFloat_Predicate_fpimm_minus0,
  GICXXPred_APFloat_Predicate_fpimm_one,
  GICXXPred_APFloat_Predicate_fpimm_two,
  GICXXPred_APFloat_Predicate_fpimmbf16,
  GICXXPred_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
  return Imm.isExactlyValue(+0.0);

  }
  case GICXXPred_APFloat_Predicate_fpimm16: {
    
      return AArch64_AM::getFP16Imm(Imm) != -1;
    
  }
  case GICXXPred_APFloat_Predicate_fpimm32: {
    
      return AArch64_AM::getFP32Imm(Imm) != -1;
    
  }
  case GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4: {
    
      uint64_t Enc = Imm.bitcastToAPInt().getZExtValue();
      return Enc != 0 && AArch64_AM::isAdvSIMDModImmType4(Enc << 32 | Enc);
    
    llvm_unreachable("fpimm32SIMDModImmType4 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm64: {
    
      return AArch64_AM::getFP64Imm(Imm) != -1;
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_half: {
    
  return Imm.isExactlyValue(+0.5);

  }
  case GICXXPred_APFloat_Predicate_fpimm_minus0: {
    
  return Imm.isExactlyValue(-0.0);

  }
  case GICXXPred_APFloat_Predicate_fpimm_one: {
    
  return Imm.isExactlyValue(+1.0);

  }
  case GICXXPred_APFloat_Predicate_fpimm_two: {
    
  return Imm.isExactlyValue(+2.0);

  }
  case GICXXPred_APFloat_Predicate_fpimmbf16: {
    
      return AArch64_AM::getFP16Imm(Imm) != -1;
    
  }
  case GICXXPred_APFloat_Predicate_simdimmtype10: {
    
      return AArch64_AM::isAdvSIMDModImmType10(
                 Imm.bitcastToAPInt().getZExtValue());
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_logical_imm32 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_logical_imm32: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);

  }
  case GICXXPred_APInt_Predicate_logical_imm64: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);

  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AArch64InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderFPImm16,
  GICR_renderFPImm32,
  GICR_renderFPImm32SIMDModImmType4,
  GICR_renderFPImm64,
  GICR_renderLogicalImm32,
  GICR_renderLogicalImm64,
  GICR_renderTruncImm,
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AArch64InstructionSelector::renderFPImm16,
  &AArch64InstructionSelector::renderFPImm32,
  &AArch64InstructionSelector::renderFPImm32SIMDModImmType4,
  &AArch64InstructionSelector::renderFPImm64,
  &AArch64InstructionSelector::renderLogicalImm32,
  &AArch64InstructionSelector::renderLogicalImm64,
  &AArch64InstructionSelector::renderTruncImm,
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ExecInfo, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void AArch64InstructionSelector::runCustomAction(unsigned, const MatcherState&) const {
    llvm_unreachable("AArch64InstructionSelector does not support custom C++ actions!");
}
const int64_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 814, /*)*//*default:*//*Label 120*/ 280849,
    /*TargetOpcode::G_ADD*//*Label 0*/ 773,
    /*TargetOpcode::G_SUB*//*Label 1*/ 12394,
    /*TargetOpcode::G_MUL*//*Label 2*/ 16370,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 17685,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 17754, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 17823,
    /*TargetOpcode::G_OR*//*Label 6*/ 21247,
    /*TargetOpcode::G_XOR*//*Label 7*/ 33157, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ 37774, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 9*/ 46461, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ 58244,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ 58477,
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 12*/ 58710, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 13*/ 58977,
    /*TargetOpcode::G_LOAD*//*Label 14*/ 59003,
    /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ 66996,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ 67967, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 17*/ 70542, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ 80002,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ 81447,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ 82476,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ 83505,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ 84934, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ 86363,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ 87392,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ 88421,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ 89450,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ 90479,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ 91508, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 29*/ 92537, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 30*/ 92589,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 31*/ 207018,
    /*TargetOpcode::G_ANYEXT*//*Label 32*/ 214439,
    /*TargetOpcode::G_TRUNC*//*Label 33*/ 214616,
    /*TargetOpcode::G_CONSTANT*//*Label 34*/ 215624,
    /*TargetOpcode::G_FCONSTANT*//*Label 35*/ 215732, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 36*/ 215990, 0,
    /*TargetOpcode::G_ZEXT*//*Label 37*/ 216325,
    /*TargetOpcode::G_SHL*//*Label 38*/ 216784,
    /*TargetOpcode::G_LSHR*//*Label 39*/ 217097,
    /*TargetOpcode::G_ASHR*//*Label 40*/ 217482, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 41*/ 217977, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 42*/ 218466,
    /*TargetOpcode::G_SMULH*//*Label 43*/ 218899,
    /*TargetOpcode::G_UADDSAT*//*Label 44*/ 219332,
    /*TargetOpcode::G_SADDSAT*//*Label 45*/ 219678,
    /*TargetOpcode::G_USUBSAT*//*Label 46*/ 220024,
    /*TargetOpcode::G_SSUBSAT*//*Label 47*/ 220370, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 48*/ 220716,
    /*TargetOpcode::G_FSUB*//*Label 49*/ 221717,
    /*TargetOpcode::G_FMUL*//*Label 50*/ 222097,
    /*TargetOpcode::G_FMA*//*Label 51*/ 225429, 0,
    /*TargetOpcode::G_FDIV*//*Label 52*/ 235641, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 53*/ 235938,
    /*TargetOpcode::G_FPEXT*//*Label 54*/ 236816,
    /*TargetOpcode::G_FPTRUNC*//*Label 55*/ 237012,
    /*TargetOpcode::G_FPTOSI*//*Label 56*/ 237156,
    /*TargetOpcode::G_FPTOUI*//*Label 57*/ 238177,
    /*TargetOpcode::G_SITOFP*//*Label 58*/ 239198,
    /*TargetOpcode::G_UITOFP*//*Label 59*/ 242779,
    /*TargetOpcode::G_FABS*//*Label 60*/ 245852, 0, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 61*/ 246413,
    /*TargetOpcode::G_FMAXNUM*//*Label 62*/ 246725, 0, 0,
    /*TargetOpcode::G_FMINIMUM*//*Label 63*/ 247037,
    /*TargetOpcode::G_FMAXIMUM*//*Label 64*/ 247349, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 65*/ 247661,
    /*TargetOpcode::G_SMAX*//*Label 66*/ 248010,
    /*TargetOpcode::G_UMIN*//*Label 67*/ 248359,
    /*TargetOpcode::G_UMAX*//*Label 68*/ 248708,
    /*TargetOpcode::G_ABS*//*Label 69*/ 249057,
    /*TargetOpcode::G_LROUND*//*Label 70*/ 249559,
    /*TargetOpcode::G_LLROUND*//*Label 71*/ 249694,
    /*TargetOpcode::G_BR*//*Label 72*/ 249764, 0, 0,
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 73*/ 249777, 0,
    /*TargetOpcode::G_CTTZ*//*Label 74*/ 252398, 0,
    /*TargetOpcode::G_CTLZ*//*Label 75*/ 252529, 0,
    /*TargetOpcode::G_CTPOP*//*Label 76*/ 253152,
    /*TargetOpcode::G_BSWAP*//*Label 77*/ 253265,
    /*TargetOpcode::G_BITREVERSE*//*Label 78*/ 253410,
    /*TargetOpcode::G_FCEIL*//*Label 79*/ 253519, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 80*/ 253752,
    /*TargetOpcode::G_FFLOOR*//*Label 81*/ 253985,
    /*TargetOpcode::G_FRINT*//*Label 82*/ 254218,
    /*TargetOpcode::G_FNEARBYINT*//*Label 83*/ 254451, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 84*/ 254684,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 85*/ 255472,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 86*/ 255769,
    /*TargetOpcode::G_STRICT_FDIV*//*Label 87*/ 258756, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 88*/ 259053,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 89*/ 268567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_VECREDUCE_FADD*//*Label 90*/ 268800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*AArch64::G_BIT*//*Label 91*/ 269081,
    /*AArch64::G_DUP*//*Label 92*/ 269417,
    /*AArch64::G_DUPLANE16*//*Label 93*/ 270996,
    /*AArch64::G_DUPLANE32*//*Label 94*/ 271308,
    /*AArch64::G_DUPLANE64*//*Label 95*/ 271550,
    /*AArch64::G_DUPLANE8*//*Label 96*/ 271696,
    /*AArch64::G_EXT*//*Label 97*/ 271864,
    /*AArch64::G_FCMEQ*//*Label 98*/ 272752,
    /*AArch64::G_FCMEQZ*//*Label 99*/ 273030,
    /*AArch64::G_FCMGE*//*Label 100*/ 273207,
    /*AArch64::G_FCMGEZ*//*Label 101*/ 273790,
    /*AArch64::G_FCMGT*//*Label 102*/ 273967,
    /*AArch64::G_FCMGTZ*//*Label 103*/ 274550,
    /*AArch64::G_FCMLEZ*//*Label 104*/ 274727,
    /*AArch64::G_FCMLTZ*//*Label 105*/ 274904,
    /*AArch64::G_PREFETCH*//*Label 106*/ 275081,
    /*AArch64::G_REV16*//*Label 107*/ 275208,
    /*AArch64::G_REV32*//*Label 108*/ 275266,
    /*AArch64::G_REV64*//*Label 109*/ 275416,
    /*AArch64::G_SITOF*//*Label 110*/ 275640,
    /*AArch64::G_TRN1*//*Label 111*/ 275731,
    /*AArch64::G_TRN2*//*Label 112*/ 276390,
    /*AArch64::G_UITOF*//*Label 113*/ 277049,
    /*AArch64::G_UZP1*//*Label 114*/ 277140,
    /*AArch64::G_UZP2*//*Label 115*/ 277799,
    /*AArch64::G_VASHR*//*Label 116*/ 278458,
    /*AArch64::G_VLSHR*//*Label 117*/ 279093,
    /*AArch64::G_ZIP1*//*Label 118*/ 279531,
    /*AArch64::G_ZIP2*//*Label 119*/ 280190,
    // Label 0: @773
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 24, /*)*//*default:*//*Label 134*/ 12393,
    /*GILLT_s32*//*Label 121*/ 801,
    /*GILLT_s64*//*Label 122*/ 2218, 0,
    /*GILLT_v2s32*//*Label 123*/ 4640,
    /*GILLT_v2s64*//*Label 124*/ 5439,
    /*GILLT_v4s16*//*Label 125*/ 6894,
    /*GILLT_v4s32*//*Label 126*/ 7693,
    /*GILLT_v8s8*//*Label 127*/ 9420,
    /*GILLT_v8s16*//*Label 128*/ 9995,
    /*GILLT_v16s8*//*Label 129*/ 11722, 0, 0, 0, 0,
    /*GILLT_nxv2s64*//*Label 130*/ 12297, 0, 0,
    /*GILLT_nxv4s32*//*Label 131*/ 12321, 0,
    /*GILLT_nxv8s16*//*Label 132*/ 12345, 0,
    /*GILLT_nxv16s8*//*Label 133*/ 12369,
    // Label 121: @801
    GIM_Try, /*On fail goto*//*Label 135*/ 2217,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 136*/ 845, // Rule ID 11436 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11436,
        GIR_Done,
      // Label 136: @845
      GIM_Try, /*On fail goto*//*Label 137*/ 984, // Rule ID 11839 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 11839,
        GIR_Done,
      // Label 137: @984
      GIM_Try, /*On fail goto*//*Label 138*/ 1123, // Rule ID 13686 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 13686,
        GIR_Done,
      // Label 138: @1123
      GIM_Try, /*On fail goto*//*Label 139*/ 1262, // Rule ID 13698 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 13698,
        GIR_Done,
      // Label 139: @1262
      GIM_Try, /*On fail goto*//*Label 140*/ 1401, // Rule ID 13710 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 13710,
        GIR_Done,
      // Label 140: @1401
      GIM_Try, /*On fail goto*//*Label 141*/ 1435, // Rule ID 93 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 93,
        GIR_Done,
      // Label 141: @1435
      GIM_Try, /*On fail goto*//*Label 142*/ 1574, // Rule ID 2520 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 2520,
        GIR_Done,
      // Label 142: @1574
      GIM_Try, /*On fail goto*//*Label 143*/ 1713, // Rule ID 8877 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8877,
        GIR_Done,
      // Label 143: @1713
      GIM_Try, /*On fail goto*//*Label 144*/ 1852, // Rule ID 8889 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8889,
        GIR_Done,
      // Label 144: @1852
      GIM_Try, /*On fail goto*//*Label 145*/ 1991, // Rule ID 8901 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8901,
        GIR_Done,
      // Label 145: @1991
      GIM_Try, /*On fail goto*//*Label 146*/ 2025, // Rule ID 11440 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11440,
        GIR_Done,
      // Label 146: @2025
      GIM_Try, /*On fail goto*//*Label 147*/ 2059, // Rule ID 11975 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } neg_addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32:{ *:[i32] }:$Rn)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11975,
        GIR_Done,
      // Label 147: @2059
      GIM_Try, /*On fail goto*//*Label 148*/ 2093, // Rule ID 99 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 99,
        GIR_Done,
      // Label 148: @2093
      GIM_Try, /*On fail goto*//*Label 149*/ 2127, // Rule ID 3571 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3571,
        GIR_Done,
      // Label 149: @2127
      GIM_Try, /*On fail goto*//*Label 150*/ 2161, // Rule ID 11438 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11438,
        GIR_Done,
      // Label 150: @2161
      GIM_Try, /*On fail goto*//*Label 151*/ 2195, // Rule ID 97 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 97,
        GIR_Done,
      // Label 151: @2195
      GIM_Try, /*On fail goto*//*Label 152*/ 2216, // Rule ID 95 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 95,
        GIR_Done,
      // Label 152: @2216
      GIM_Reject,
    // Label 135: @2217
    GIM_Reject,
    // Label 122: @2218
    GIM_Try, /*On fail goto*//*Label 153*/ 4639,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 154*/ 2297, // Rule ID 5987 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 0,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5987,
        GIR_Done,
      // Label 154: @2297
      GIM_Try, /*On fail goto*//*Label 155*/ 2366, // Rule ID 12136 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 0,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12136,
        GIR_Done,
      // Label 155: @2366
      GIM_Try, /*On fail goto*//*Label 156*/ 2400, // Rule ID 11437 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11437,
        GIR_Done,
      // Label 156: @2400
      GIM_Try, /*On fail goto*//*Label 157*/ 2496, // Rule ID 3621 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3621,
        GIR_Done,
      // Label 157: @2496
      GIM_Try, /*On fail goto*//*Label 158*/ 2592, // Rule ID 3622 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3622,
        GIR_Done,
      // Label 158: @2592
      GIM_Try, /*On fail goto*//*Label 159*/ 2626, // Rule ID 94 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 94,
        GIR_Done,
      // Label 159: @2626
      GIM_Try, /*On fail goto*//*Label 160*/ 2722, // Rule ID 11983 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11983,
        GIR_Done,
      // Label 160: @2722
      GIM_Try, /*On fail goto*//*Label 161*/ 2818, // Rule ID 11984 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11984,
        GIR_Done,
      // Label 161: @2818
      GIM_Try, /*On fail goto*//*Label 162*/ 2903, // Rule ID 11448 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11448,
        GIR_Done,
      // Label 162: @2903
      GIM_Try, /*On fail goto*//*Label 163*/ 2988, // Rule ID 11449 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11449,
        GIR_Done,
      // Label 163: @2988
      GIM_Try, /*On fail goto*//*Label 164*/ 3073, // Rule ID 125 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 164: @3073
      GIM_Try, /*On fail goto*//*Label 165*/ 3158, // Rule ID 127 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 127,
        GIR_Done,
      // Label 165: @3158
      GIM_Try, /*On fail goto*//*Label 166*/ 3217, // Rule ID 11834 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11834,
        GIR_Done,
      // Label 166: @3217
      GIM_Try, /*On fail goto*//*Label 167*/ 3276, // Rule ID 13681 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 13681,
        GIR_Done,
      // Label 167: @3276
      GIM_Try, /*On fail goto*//*Label 168*/ 3335, // Rule ID 13693 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 13693,
        GIR_Done,
      // Label 168: @3335
      GIM_Try, /*On fail goto*//*Label 169*/ 3394, // Rule ID 13705 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 13705,
        GIR_Done,
      // Label 169: @3394
      GIM_Try, /*On fail goto*//*Label 170*/ 3453, // Rule ID 2517 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2517,
        GIR_Done,
      // Label 170: @3453
      GIM_Try, /*On fail goto*//*Label 171*/ 3512, // Rule ID 8874 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8874,
        GIR_Done,
      // Label 171: @3512
      GIM_Try, /*On fail goto*//*Label 172*/ 3571, // Rule ID 8886 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8886,
        GIR_Done,
      // Label 172: @3571
      GIM_Try, /*On fail goto*//*Label 173*/ 3630, // Rule ID 8898 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8898,
        GIR_Done,
      // Label 173: @3630
      GIM_Try, /*On fail goto*//*Label 174*/ 3664, // Rule ID 11441 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11441,
        GIR_Done,
      // Label 174: @3664
      GIM_Try, /*On fail goto*//*Label 175*/ 3698, // Rule ID 11976 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } neg_addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64:{ *:[i64] }:$Rn)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11976,
        GIR_Done,
      // Label 175: @3698
      GIM_Try, /*On fail goto*//*Label 176*/ 3732, // Rule ID 100 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 100,
        GIR_Done,
      // Label 176: @3732
      GIM_Try, /*On fail goto*//*Label 177*/ 3766, // Rule ID 3572 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3572,
        GIR_Done,
      // Label 177: @3766
      GIM_Try, /*On fail goto*//*Label 178*/ 3800, // Rule ID 11439 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11439,
        GIR_Done,
      // Label 178: @3800
      GIM_Try, /*On fail goto*//*Label 179*/ 3834, // Rule ID 98 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 98,
        GIR_Done,
      // Label 179: @3834
      GIM_Try, /*On fail goto*//*Label 180*/ 3890, // Rule ID 11523 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 566:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11523,
        GIR_Done,
      // Label 180: @3890
      GIM_Try, /*On fail goto*//*Label 181*/ 3946, // Rule ID 11535 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 631:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11535,
        GIR_Done,
      // Label 181: @3946
      GIM_Try, /*On fail goto*//*Label 182*/ 4013, // Rule ID 11741 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11741,
        GIR_Done,
      // Label 182: @4013
      GIM_Try, /*On fail goto*//*Label 183*/ 4080, // Rule ID 12125 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12125,
        GIR_Done,
      // Label 183: @4080
      GIM_Try, /*On fail goto*//*Label 184*/ 4147, // Rule ID 11744 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11744,
        GIR_Done,
      // Label 184: @4147
      GIM_Try, /*On fail goto*//*Label 185*/ 4214, // Rule ID 12128 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12128,
        GIR_Done,
      // Label 185: @4214
      GIM_Try, /*On fail goto*//*Label 186*/ 4270, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 566:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 186: @4270
      GIM_Try, /*On fail goto*//*Label 187*/ 4326, // Rule ID 1031 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 631:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1031,
        GIR_Done,
      // Label 187: @4326
      GIM_Try, /*On fail goto*//*Label 188*/ 4393, // Rule ID 2093 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2093,
        GIR_Done,
      // Label 188: @4393
      GIM_Try, /*On fail goto*//*Label 189*/ 4460, // Rule ID 5291 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5291,
        GIR_Done,
      // Label 189: @4460
      GIM_Try, /*On fail goto*//*Label 190*/ 4527, // Rule ID 2102 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2102,
        GIR_Done,
      // Label 190: @4527
      GIM_Try, /*On fail goto*//*Label 191*/ 4594, // Rule ID 5297 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5297,
        GIR_Done,
      // Label 191: @4594
      GIM_Try, /*On fail goto*//*Label 192*/ 4615, // Rule ID 96 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 96,
        GIR_Done,
      // Label 192: @4615
      GIM_Try, /*On fail goto*//*Label 193*/ 4638, // Rule ID 1582 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1582,
        GIR_Done,
      // Label 193: @4638
      GIM_Reject,
    // Label 153: @4639
    GIM_Reject,
    // Label 123: @4640
    GIM_Try, /*On fail goto*//*Label 194*/ 5438,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 195*/ 4718, // Rule ID 11557 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 565:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11557,
        GIR_Done,
      // Label 195: @4718
      GIM_Try, /*On fail goto*//*Label 196*/ 4786, // Rule ID 11569 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 630:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11569,
        GIR_Done,
      // Label 196: @4786
      GIM_Try, /*On fail goto*//*Label 197*/ 4842, // Rule ID 11519 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 566:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11519,
        GIR_Done,
      // Label 197: @4842
      GIM_Try, /*On fail goto*//*Label 198*/ 4898, // Rule ID 11531 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 631:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11531,
        GIR_Done,
      // Label 198: @4898
      GIM_Try, /*On fail goto*//*Label 199*/ 4965, // Rule ID 11761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11761,
        GIR_Done,
      // Label 199: @4965
      GIM_Try, /*On fail goto*//*Label 200*/ 5032, // Rule ID 11782 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11782,
        GIR_Done,
      // Label 200: @5032
      GIM_Try, /*On fail goto*//*Label 201*/ 5100, // Rule ID 1338 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 565:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1338,
        GIR_Done,
      // Label 201: @5100
      GIM_Try, /*On fail goto*//*Label 202*/ 5168, // Rule ID 1461 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 630:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1461,
        GIR_Done,
      // Label 202: @5168
      GIM_Try, /*On fail goto*//*Label 203*/ 5224, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 566:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 203: @5224
      GIM_Try, /*On fail goto*//*Label 204*/ 5280, // Rule ID 1027 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 631:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1027,
        GIR_Done,
      // Label 204: @5280
      GIM_Try, /*On fail goto*//*Label 205*/ 5347, // Rule ID 2207 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2207,
        GIR_Done,
      // Label 205: @5347
      GIM_Try, /*On fail goto*//*Label 206*/ 5414, // Rule ID 2266 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2266,
        GIR_Done,
      // Label 206: @5414
      GIM_Try, /*On fail goto*//*Label 207*/ 5437, // Rule ID 1077 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 207: @5437
      GIM_Reject,
    // Label 194: @5438
    GIM_Reject,
    // Label 124: @5439
    GIM_Try, /*On fail goto*//*Label 208*/ 6893,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 209*/ 5530, // Rule ID 11599 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 565:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11599,
        GIR_Done,
      // Label 209: @5530
      GIM_Try, /*On fail goto*//*Label 210*/ 5611, // Rule ID 11623 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 630:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11623,
        GIR_Done,
      // Label 210: @5611
      GIM_Try, /*On fail goto*//*Label 211*/ 5692, // Rule ID 1671 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 565:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1671,
        GIR_Done,
      // Label 211: @5692
      GIM_Try, /*On fail goto*//*Label 212*/ 5773, // Rule ID 1749 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 630:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1749,
        GIR_Done,
      // Label 212: @5773
      GIM_Try, /*On fail goto*//*Label 213*/ 5829, // Rule ID 11525 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 566:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11525,
        GIR_Done,
      // Label 213: @5829
      GIM_Try, /*On fail goto*//*Label 214*/ 5885, // Rule ID 11537 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 631:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11537,
        GIR_Done,
      // Label 214: @5885
      GIM_Try, /*On fail goto*//*Label 215*/ 5952, // Rule ID 11765 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11765,
        GIR_Done,
      // Label 215: @5952
      GIM_Try, /*On fail goto*//*Label 216*/ 6019, // Rule ID 11786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11786,
        GIR_Done,
      // Label 216: @6019
      GIM_Try, /*On fail goto*//*Label 217*/ 6075, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 566:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 217: @6075
      GIM_Try, /*On fail goto*//*Label 218*/ 6131, // Rule ID 1033 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 631:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1033,
        GIR_Done,
      // Label 218: @6131
      GIM_Try, /*On fail goto*//*Label 219*/ 6198, // Rule ID 2211 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2211,
        GIR_Done,
      // Label 219: @6198
      GIM_Try, /*On fail goto*//*Label 220*/ 6265, // Rule ID 2270 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2270,
        GIR_Done,
      // Label 220: @6265
      GIM_Try, /*On fail goto*//*Label 221*/ 6327, // Rule ID 1771 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1771,
        GIR_Done,
      // Label 221: @6327
      GIM_Try, /*On fail goto*//*Label 222*/ 6389, // Rule ID 1770 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1770,
        GIR_Done,
      // Label 222: @6389
      GIM_Try, /*On fail goto*//*Label 223*/ 6451, // Rule ID 1690 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1690,
        GIR_Done,
      // Label 223: @6451
      GIM_Try, /*On fail goto*//*Label 224*/ 6513, // Rule ID 1769 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1769,
        GIR_Done,
      // Label 224: @6513
      GIM_Try, /*On fail goto*//*Label 225*/ 6575, // Rule ID 1768 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1768,
        GIR_Done,
      // Label 225: @6575
      GIM_Try, /*On fail goto*//*Label 226*/ 6624, // Rule ID 11635 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11635,
        GIR_Done,
      // Label 226: @6624
      GIM_Try, /*On fail goto*//*Label 227*/ 6673, // Rule ID 11606 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11606,
        GIR_Done,
      // Label 227: @6673
      GIM_Try, /*On fail goto*//*Label 228*/ 6722, // Rule ID 11634 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11634,
        GIR_Done,
      // Label 228: @6722
      GIM_Try, /*On fail goto*//*Label 229*/ 6771, // Rule ID 1785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1785,
        GIR_Done,
      // Label 229: @6771
      GIM_Try, /*On fail goto*//*Label 230*/ 6820, // Rule ID 1696 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1696,
        GIR_Done,
      // Label 230: @6820
      GIM_Try, /*On fail goto*//*Label 231*/ 6869, // Rule ID 1784 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1784,
        GIR_Done,
      // Label 231: @6869
      GIM_Try, /*On fail goto*//*Label 232*/ 6892, // Rule ID 1079 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 232: @6892
      GIM_Reject,
    // Label 208: @6893
    GIM_Reject,
    // Label 125: @6894
    GIM_Try, /*On fail goto*//*Label 233*/ 7692,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 234*/ 6972, // Rule ID 11553 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 565:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11553,
        GIR_Done,
      // Label 234: @6972
      GIM_Try, /*On fail goto*//*Label 235*/ 7040, // Rule ID 11565 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 630:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11565,
        GIR_Done,
      // Label 235: @7040
      GIM_Try, /*On fail goto*//*Label 236*/ 7096, // Rule ID 11515 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 566:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11515,
        GIR_Done,
      // Label 236: @7096
      GIM_Try, /*On fail goto*//*Label 237*/ 7152, // Rule ID 11527 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 631:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11527,
        GIR_Done,
      // Label 237: @7152
      GIM_Try, /*On fail goto*//*Label 238*/ 7219, // Rule ID 11757 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11757,
        GIR_Done,
      // Label 238: @7219
      GIM_Try, /*On fail goto*//*Label 239*/ 7286, // Rule ID 11778 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11778,
        GIR_Done,
      // Label 239: @7286
      GIM_Try, /*On fail goto*//*Label 240*/ 7354, // Rule ID 1334 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 565:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1334,
        GIR_Done,
      // Label 240: @7354
      GIM_Try, /*On fail goto*//*Label 241*/ 7422, // Rule ID 1457 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 630:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1457,
        GIR_Done,
      // Label 241: @7422
      GIM_Try, /*On fail goto*//*Label 242*/ 7478, // Rule ID 962 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 566:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 962,
        GIR_Done,
      // Label 242: @7478
      GIM_Try, /*On fail goto*//*Label 243*/ 7534, // Rule ID 1023 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 631:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1023,
        GIR_Done,
      // Label 243: @7534
      GIM_Try, /*On fail goto*//*Label 244*/ 7601, // Rule ID 2203 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2203,
        GIR_Done,
      // Label 244: @7601
      GIM_Try, /*On fail goto*//*Label 245*/ 7668, // Rule ID 2262 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2262,
        GIR_Done,
      // Label 245: @7668
      GIM_Try, /*On fail goto*//*Label 246*/ 7691, // Rule ID 1075 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1075,
        GIR_Done,
      // Label 246: @7691
      GIM_Reject,
    // Label 233: @7692
    GIM_Reject,
    // Label 126: @7693
    GIM_Try, /*On fail goto*//*Label 247*/ 9419,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 248*/ 7784, // Rule ID 11595 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 565:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11595,
        GIR_Done,
      // Label 248: @7784
      GIM_Try, /*On fail goto*//*Label 249*/ 7865, // Rule ID 11619 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 630:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11619,
        GIR_Done,
      // Label 249: @7865
      GIM_Try, /*On fail goto*//*Label 250*/ 7946, // Rule ID 1667 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 565:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1667,
        GIR_Done,
      // Label 250: @7946
      GIM_Try, /*On fail goto*//*Label 251*/ 8027, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 630:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 251: @8027
      GIM_Try, /*On fail goto*//*Label 252*/ 8095, // Rule ID 11559 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 565:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11559,
        GIR_Done,
      // Label 252: @8095
      GIM_Try, /*On fail goto*//*Label 253*/ 8163, // Rule ID 11571 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 630:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11571,
        GIR_Done,
      // Label 253: @8163
      GIM_Try, /*On fail goto*//*Label 254*/ 8219, // Rule ID 11521 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 566:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11521,
        GIR_Done,
      // Label 254: @8219
      GIM_Try, /*On fail goto*//*Label 255*/ 8275, // Rule ID 11533 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 631:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11533,
        GIR_Done,
      // Label 255: @8275
      GIM_Try, /*On fail goto*//*Label 256*/ 8342, // Rule ID 11763 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11763,
        GIR_Done,
      // Label 256: @8342
      GIM_Try, /*On fail goto*//*Label 257*/ 8409, // Rule ID 11784 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11784,
        GIR_Done,
      // Label 257: @8409
      GIM_Try, /*On fail goto*//*Label 258*/ 8477, // Rule ID 1340 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 565:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1340,
        GIR_Done,
      // Label 258: @8477
      GIM_Try, /*On fail goto*//*Label 259*/ 8545, // Rule ID 1463 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 630:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1463,
        GIR_Done,
      // Label 259: @8545
      GIM_Try, /*On fail goto*//*Label 260*/ 8601, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 566:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 260: @8601
      GIM_Try, /*On fail goto*//*Label 261*/ 8657, // Rule ID 1029 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 631:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1029,
        GIR_Done,
      // Label 261: @8657
      GIM_Try, /*On fail goto*//*Label 262*/ 8724, // Rule ID 2209 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2209,
        GIR_Done,
      // Label 262: @8724
      GIM_Try, /*On fail goto*//*Label 263*/ 8791, // Rule ID 2268 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2268,
        GIR_Done,
      // Label 263: @8791
      GIM_Try, /*On fail goto*//*Label 264*/ 8853, // Rule ID 1763 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1763,
        GIR_Done,
      // Label 264: @8853
      GIM_Try, /*On fail goto*//*Label 265*/ 8915, // Rule ID 1762 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1762,
        GIR_Done,
      // Label 265: @8915
      GIM_Try, /*On fail goto*//*Label 266*/ 8977, // Rule ID 1688 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1688,
        GIR_Done,
      // Label 266: @8977
      GIM_Try, /*On fail goto*//*Label 267*/ 9039, // Rule ID 1761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1761,
        GIR_Done,
      // Label 267: @9039
      GIM_Try, /*On fail goto*//*Label 268*/ 9101, // Rule ID 1760 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1760,
        GIR_Done,
      // Label 268: @9101
      GIM_Try, /*On fail goto*//*Label 269*/ 9150, // Rule ID 11631 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11631,
        GIR_Done,
      // Label 269: @9150
      GIM_Try, /*On fail goto*//*Label 270*/ 9199, // Rule ID 11604 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11604,
        GIR_Done,
      // Label 270: @9199
      GIM_Try, /*On fail goto*//*Label 271*/ 9248, // Rule ID 11630 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11630,
        GIR_Done,
      // Label 271: @9248
      GIM_Try, /*On fail goto*//*Label 272*/ 9297, // Rule ID 1781 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1781,
        GIR_Done,
      // Label 272: @9297
      GIM_Try, /*On fail goto*//*Label 273*/ 9346, // Rule ID 1694 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1694,
        GIR_Done,
      // Label 273: @9346
      GIM_Try, /*On fail goto*//*Label 274*/ 9395, // Rule ID 1780 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1780,
        GIR_Done,
      // Label 274: @9395
      GIM_Try, /*On fail goto*//*Label 275*/ 9418, // Rule ID 1078 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 275: @9418
      GIM_Reject,
    // Label 247: @9419
    GIM_Reject,
    // Label 127: @9420
    GIM_Try, /*On fail goto*//*Label 276*/ 9994,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_Try, /*On fail goto*//*Label 277*/ 9498, // Rule ID 11549 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 565:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11549,
        GIR_Done,
      // Label 277: @9498
      GIM_Try, /*On fail goto*//*Label 278*/ 9566, // Rule ID 11561 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 630:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11561,
        GIR_Done,
      // Label 278: @9566
      GIM_Try, /*On fail goto*//*Label 279*/ 9633, // Rule ID 11753 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11753,
        GIR_Done,
      // Label 279: @9633
      GIM_Try, /*On fail goto*//*Label 280*/ 9700, // Rule ID 11774 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11774,
        GIR_Done,
      // Label 280: @9700
      GIM_Try, /*On fail goto*//*Label 281*/ 9768, // Rule ID 1330 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 565:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1330,
        GIR_Done,
      // Label 281: @9768
      GIM_Try, /*On fail goto*//*Label 282*/ 9836, // Rule ID 1453 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 630:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1453,
        GIR_Done,
      // Label 282: @9836
      GIM_Try, /*On fail goto*//*Label 283*/ 9903, // Rule ID 2199 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2199,
        GIR_Done,
      // Label 283: @9903
      GIM_Try, /*On fail goto*//*Label 284*/ 9970, // Rule ID 2258 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2258,
        GIR_Done,
      // Label 284: @9970
      GIM_Try, /*On fail goto*//*Label 285*/ 9993, // Rule ID 1073 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 285: @9993
      GIM_Reject,
    // Label 276: @9994
    GIM_Reject,
    // Label 128: @9995
    GIM_Try, /*On fail goto*//*Label 286*/ 11721,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 287*/ 10086, // Rule ID 11591 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 565:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11591,
        GIR_Done,
      // Label 287: @10086
      GIM_Try, /*On fail goto*//*Label 288*/ 10167, // Rule ID 11615 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 630:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11615,
        GIR_Done,
      // Label 288: @10167
      GIM_Try, /*On fail goto*//*Label 289*/ 10248, // Rule ID 1663 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 565:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1663,
        GIR_Done,
      // Label 289: @10248
      GIM_Try, /*On fail goto*//*Label 290*/ 10329, // Rule ID 1741 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 630:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1741,
        GIR_Done,
      // Label 290: @10329
      GIM_Try, /*On fail goto*//*Label 291*/ 10397, // Rule ID 11555 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 565:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11555,
        GIR_Done,
      // Label 291: @10397
      GIM_Try, /*On fail goto*//*Label 292*/ 10465, // Rule ID 11567 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 630:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11567,
        GIR_Done,
      // Label 292: @10465
      GIM_Try, /*On fail goto*//*Label 293*/ 10521, // Rule ID 11517 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 566:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11517,
        GIR_Done,
      // Label 293: @10521
      GIM_Try, /*On fail goto*//*Label 294*/ 10577, // Rule ID 11529 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 631:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11529,
        GIR_Done,
      // Label 294: @10577
      GIM_Try, /*On fail goto*//*Label 295*/ 10644, // Rule ID 11759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11759,
        GIR_Done,
      // Label 295: @10644
      GIM_Try, /*On fail goto*//*Label 296*/ 10711, // Rule ID 11780 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11780,
        GIR_Done,
      // Label 296: @10711
      GIM_Try, /*On fail goto*//*Label 297*/ 10779, // Rule ID 1336 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 565:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1336,
        GIR_Done,
      // Label 297: @10779
      GIM_Try, /*On fail goto*//*Label 298*/ 10847, // Rule ID 1459 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 630:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1459,
        GIR_Done,
      // Label 298: @10847
      GIM_Try, /*On fail goto*//*Label 299*/ 10903, // Rule ID 964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 566:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 964,
        GIR_Done,
      // Label 299: @10903
      GIM_Try, /*On fail goto*//*Label 300*/ 10959, // Rule ID 1025 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 631:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1025,
        GIR_Done,
      // Label 300: @10959
      GIM_Try, /*On fail goto*//*Label 301*/ 11026, // Rule ID 2205 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2205,
        GIR_Done,
      // Label 301: @11026
      GIM_Try, /*On fail goto*//*Label 302*/ 11093, // Rule ID 2264 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2264,
        GIR_Done,
      // Label 302: @11093
      GIM_Try, /*On fail goto*//*Label 303*/ 11155, // Rule ID 1755 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1755,
        GIR_Done,
      // Label 303: @11155
      GIM_Try, /*On fail goto*//*Label 304*/ 11217, // Rule ID 1754 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1754,
        GIR_Done,
      // Label 304: @11217
      GIM_Try, /*On fail goto*//*Label 305*/ 11279, // Rule ID 1686 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1686,
        GIR_Done,
      // Label 305: @11279
      GIM_Try, /*On fail goto*//*Label 306*/ 11341, // Rule ID 1753 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1753,
        GIR_Done,
      // Label 306: @11341
      GIM_Try, /*On fail goto*//*Label 307*/ 11403, // Rule ID 1752 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1752,
        GIR_Done,
      // Label 307: @11403
      GIM_Try, /*On fail goto*//*Label 308*/ 11452, // Rule ID 11627 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11627,
        GIR_Done,
      // Label 308: @11452
      GIM_Try, /*On fail goto*//*Label 309*/ 11501, // Rule ID 11602 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11602,
        GIR_Done,
      // Label 309: @11501
      GIM_Try, /*On fail goto*//*Label 310*/ 11550, // Rule ID 11626 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11626,
        GIR_Done,
      // Label 310: @11550
      GIM_Try, /*On fail goto*//*Label 311*/ 11599, // Rule ID 1777 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1777,
        GIR_Done,
      // Label 311: @11599
      GIM_Try, /*On fail goto*//*Label 312*/ 11648, // Rule ID 1692 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1692,
        GIR_Done,
      // Label 312: @11648
      GIM_Try, /*On fail goto*//*Label 313*/ 11697, // Rule ID 1776 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1776,
        GIR_Done,
      // Label 313: @11697
      GIM_Try, /*On fail goto*//*Label 314*/ 11720, // Rule ID 1076 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (ADDv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1076,
        GIR_Done,
      // Label 314: @11720
      GIM_Reject,
    // Label 286: @11721
    GIM_Reject,
    // Label 129: @11722
    GIM_Try, /*On fail goto*//*Label 315*/ 12296,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 316*/ 11800, // Rule ID 11551 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 565:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11551,
        GIR_Done,
      // Label 316: @11800
      GIM_Try, /*On fail goto*//*Label 317*/ 11868, // Rule ID 11563 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 630:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11563,
        GIR_Done,
      // Label 317: @11868
      GIM_Try, /*On fail goto*//*Label 318*/ 11935, // Rule ID 11755 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11755,
        GIR_Done,
      // Label 318: @11935
      GIM_Try, /*On fail goto*//*Label 319*/ 12002, // Rule ID 11776 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11776,
        GIR_Done,
      // Label 319: @12002
      GIM_Try, /*On fail goto*//*Label 320*/ 12070, // Rule ID 1332 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 565:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1332,
        GIR_Done,
      // Label 320: @12070
      GIM_Try, /*On fail goto*//*Label 321*/ 12138, // Rule ID 1455 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 630:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1455,
        GIR_Done,
      // Label 321: @12138
      GIM_Try, /*On fail goto*//*Label 322*/ 12205, // Rule ID 2201 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2201,
        GIR_Done,
      // Label 322: @12205
      GIM_Try, /*On fail goto*//*Label 323*/ 12272, // Rule ID 2260 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2260,
        GIR_Done,
      // Label 323: @12272
      GIM_Try, /*On fail goto*//*Label 324*/ 12295, // Rule ID 1074 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ADDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 324: @12295
      GIM_Reject,
    // Label 315: @12296
    GIM_Reject,
    // Label 130: @12297
    GIM_Try, /*On fail goto*//*Label 325*/ 12320, // Rule ID 2649 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (add:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (ADD_ZZZ_D:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADD_ZZZ_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2649,
      GIR_Done,
    // Label 325: @12320
    GIM_Reject,
    // Label 131: @12321
    GIM_Try, /*On fail goto*//*Label 326*/ 12344, // Rule ID 2648 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (add:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (ADD_ZZZ_S:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADD_ZZZ_S,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2648,
      GIR_Done,
    // Label 326: @12344
    GIM_Reject,
    // Label 132: @12345
    GIM_Try, /*On fail goto*//*Label 327*/ 12368, // Rule ID 2647 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (add:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (ADD_ZZZ_H:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADD_ZZZ_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2647,
      GIR_Done,
    // Label 327: @12368
    GIM_Reject,
    // Label 133: @12369
    GIM_Try, /*On fail goto*//*Label 328*/ 12392, // Rule ID 2646 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (add:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (ADD_ZZZ_B:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADD_ZZZ_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2646,
      GIR_Done,
    // Label 328: @12392
    GIM_Reject,
    // Label 134: @12393
    GIM_Reject,
    // Label 1: @12394
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 24, /*)*//*default:*//*Label 342*/ 16369,
    /*GILLT_s32*//*Label 329*/ 12422,
    /*GILLT_s64*//*Label 330*/ 13209, 0,
    /*GILLT_v2s32*//*Label 331*/ 14501,
    /*GILLT_v2s64*//*Label 332*/ 14572,
    /*GILLT_v4s16*//*Label 333*/ 15068,
    /*GILLT_v4s32*//*Label 334*/ 15139,
    /*GILLT_v8s8*//*Label 335*/ 15635,
    /*GILLT_v8s16*//*Label 336*/ 15706,
    /*GILLT_v16s8*//*Label 337*/ 16202, 0, 0, 0, 0,
    /*GILLT_nxv2s64*//*Label 338*/ 16273, 0, 0,
    /*GILLT_nxv4s32*//*Label 339*/ 16297, 0,
    /*GILLT_nxv8s16*//*Label 340*/ 16321, 0,
    /*GILLT_nxv16s8*//*Label 341*/ 16345,
    // Label 329: @12422
    GIM_Try, /*On fail goto*//*Label 343*/ 13208,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 344*/ 12571, // Rule ID 8871 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8871,
        GIR_Done,
      // Label 344: @12571
      GIM_Try, /*On fail goto*//*Label 345*/ 12710, // Rule ID 8883 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8883,
        GIR_Done,
      // Label 345: @12710
      GIM_Try, /*On fail goto*//*Label 346*/ 12849, // Rule ID 8895 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8895,
        GIR_Done,
      // Label 346: @12849
      GIM_Try, /*On fail goto*//*Label 347*/ 12988, // Rule ID 8907 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 8907,
        GIR_Done,
      // Label 347: @12988
      GIM_Try, /*On fail goto*//*Label 348*/ 13047, // Rule ID 3603 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3603,
        GIR_Done,
      // Label 348: @13047
      GIM_Try, /*On fail goto*//*Label 349*/ 13081, // Rule ID 3568 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)  =>  (SUBSWrx:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3568,
        GIR_Done,
      // Label 349: @13081
      GIM_Try, /*On fail goto*//*Label 350*/ 13115, // Rule ID 3573 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3573,
        GIR_Done,
      // Label 350: @13115
      GIM_Try, /*On fail goto*//*Label 351*/ 13149, // Rule ID 3562 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3562,
        GIR_Done,
      // Label 351: @13149
      GIM_Try, /*On fail goto*//*Label 352*/ 13183, // Rule ID 3566 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)  =>  (SUBSWrs:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3566,
        GIR_Done,
      // Label 352: @13183
      GIM_Try, /*On fail goto*//*Label 353*/ 13207, // Rule ID 3564 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SUBSWrr:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSWrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3564,
        GIR_Done,
      // Label 353: @13207
      GIM_Reject,
    // Label 343: @13208
    GIM_Reject,
    // Label 330: @13209
    GIM_Try, /*On fail goto*//*Label 354*/ 14500,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 355*/ 13315, // Rule ID 3618 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3618,
        GIR_Done,
      // Label 355: @13315
      GIM_Try, /*On fail goto*//*Label 356*/ 13411, // Rule ID 3619 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3619,
        GIR_Done,
      // Label 356: @13411
      GIM_Try, /*On fail goto*//*Label 357*/ 13496, // Rule ID 3613 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3613,
        GIR_Done,
      // Label 357: @13496
      GIM_Try, /*On fail goto*//*Label 358*/ 13581, // Rule ID 3614 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3614,
        GIR_Done,
      // Label 358: @13581
      GIM_Try, /*On fail goto*//*Label 359*/ 13677, // Rule ID 3624 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3624,
        GIR_Done,
      // Label 359: @13677
      GIM_Try, /*On fail goto*//*Label 360*/ 13773, // Rule ID 3625 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3625,
        GIR_Done,
      // Label 360: @13773
      GIM_Try, /*On fail goto*//*Label 361*/ 13858, // Rule ID 126 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 126,
        GIR_Done,
      // Label 361: @13858
      GIM_Try, /*On fail goto*//*Label 362*/ 13943, // Rule ID 128 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 128,
        GIR_Done,
      // Label 362: @13943
      GIM_Try, /*On fail goto*//*Label 363*/ 14002, // Rule ID 3604 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3604,
        GIR_Done,
      // Label 363: @14002
      GIM_Try, /*On fail goto*//*Label 364*/ 14061, // Rule ID 8868 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1050:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8868,
        GIR_Done,
      // Label 364: @14061
      GIM_Try, /*On fail goto*//*Label 365*/ 14120, // Rule ID 8880 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1052:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8880,
        GIR_Done,
      // Label 365: @14120
      GIM_Try, /*On fail goto*//*Label 366*/ 14179, // Rule ID 8892 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1058:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8892,
        GIR_Done,
      // Label 366: @14179
      GIM_Try, /*On fail goto*//*Label 367*/ 14238, // Rule ID 8904 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GICXXPred_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1051:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8904,
        GIR_Done,
      // Label 367: @14238
      GIM_Try, /*On fail goto*//*Label 368*/ 14272, // Rule ID 3569 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)  =>  (SUBSXrx:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3569,
        GIR_Done,
      // Label 368: @14272
      GIM_Try, /*On fail goto*//*Label 369*/ 14306, // Rule ID 3574 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3574,
        GIR_Done,
      // Label 369: @14306
      GIM_Try, /*On fail goto*//*Label 370*/ 14340, // Rule ID 3563 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3563,
        GIR_Done,
      // Label 370: @14340
      GIM_Try, /*On fail goto*//*Label 371*/ 14374, // Rule ID 3567 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)  =>  (SUBSXrs:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3567,
        GIR_Done,
      // Label 371: @14374
      GIM_Try, /*On fail goto*//*Label 372*/ 14414, // Rule ID 1629 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v1i64] } immAllZerosV:{ *:[v1i64] }, FPR64:{ *:[v1i64] }:$Rn)  =>  (NEGv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1629,
        GIR_Done,
      // Label 372: @14414
      GIM_Try, /*On fail goto*//*Label 373*/ 14452, // Rule ID 4472 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } immAllZerosV:{ *:[i64] }, FPR64:{ *:[i64] }:$Rn)  =>  (NEGv1i64:{ *:[i64] } FPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4472,
        GIR_Done,
      // Label 373: @14452
      GIM_Try, /*On fail goto*//*Label 374*/ 14475, // Rule ID 1619 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (SUBv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1619,
        GIR_Done,
      // Label 374: @14475
      GIM_Try, /*On fail goto*//*Label 375*/ 14499, // Rule ID 3565 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SUBSXrr:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSXrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3565,
        GIR_Done,
      // Label 375: @14499
      GIM_Reject,
    // Label 354: @14500
    GIM_Reject,
    // Label 331: @14501
    GIM_Try, /*On fail goto*//*Label 376*/ 14571,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 377*/ 14551, // Rule ID 942 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } immAllZerosV:{ *:[v2i32] }, V64:{ *:[v2i32] }:$Rn)  =>  (NEGv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 377: @14551
      GIM_Try, /*On fail goto*//*Label 378*/ 14570, // Rule ID 1449 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (SUBv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1449,
        GIR_Done,
      // Label 378: @14570
      GIM_Reject,
    // Label 376: @14571
    GIM_Reject,
    // Label 332: @14572
    GIM_Try, /*On fail goto*//*Label 379*/ 15067,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 380*/ 14644, // Rule ID 1825 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1825,
        GIR_Done,
      // Label 380: @14644
      GIM_Try, /*On fail goto*//*Label 381*/ 14702, // Rule ID 1824 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1824,
        GIR_Done,
      // Label 381: @14702
      GIM_Try, /*On fail goto*//*Label 382*/ 14760, // Rule ID 1732 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1732,
        GIR_Done,
      // Label 382: @14760
      GIM_Try, /*On fail goto*//*Label 383*/ 14818, // Rule ID 1823 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1823,
        GIR_Done,
      // Label 383: @14818
      GIM_Try, /*On fail goto*//*Label 384*/ 14876, // Rule ID 1822 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1822,
        GIR_Done,
      // Label 384: @14876
      GIM_Try, /*On fail goto*//*Label 385*/ 14912, // Rule ID 944 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, V128:{ *:[v2i64] }:$Rn)  =>  (NEGv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 385: @14912
      GIM_Try, /*On fail goto*//*Label 386*/ 14957, // Rule ID 1839 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1839,
        GIR_Done,
      // Label 386: @14957
      GIM_Try, /*On fail goto*//*Label 387*/ 15002, // Rule ID 1738 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1738,
        GIR_Done,
      // Label 387: @15002
      GIM_Try, /*On fail goto*//*Label 388*/ 15047, // Rule ID 1838 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1838,
        GIR_Done,
      // Label 388: @15047
      GIM_Try, /*On fail goto*//*Label 389*/ 15066, // Rule ID 1451 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (SUBv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1451,
        GIR_Done,
      // Label 389: @15066
      GIM_Reject,
    // Label 379: @15067
    GIM_Reject,
    // Label 333: @15068
    GIM_Try, /*On fail goto*//*Label 390*/ 15138,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 391*/ 15118, // Rule ID 940 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } immAllZerosV:{ *:[v4i16] }, V64:{ *:[v4i16] }:$Rn)  =>  (NEGv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 940,
        GIR_Done,
      // Label 391: @15118
      GIM_Try, /*On fail goto*//*Label 392*/ 15137, // Rule ID 1447 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (SUBv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1447,
        GIR_Done,
      // Label 392: @15137
      GIM_Reject,
    // Label 390: @15138
    GIM_Reject,
    // Label 334: @15139
    GIM_Try, /*On fail goto*//*Label 393*/ 15634,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 394*/ 15211, // Rule ID 1817 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1817,
        GIR_Done,
      // Label 394: @15211
      GIM_Try, /*On fail goto*//*Label 395*/ 15269, // Rule ID 1816 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1816,
        GIR_Done,
      // Label 395: @15269
      GIM_Try, /*On fail goto*//*Label 396*/ 15327, // Rule ID 1730 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1730,
        GIR_Done,
      // Label 396: @15327
      GIM_Try, /*On fail goto*//*Label 397*/ 15385, // Rule ID 1815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1815,
        GIR_Done,
      // Label 397: @15385
      GIM_Try, /*On fail goto*//*Label 398*/ 15443, // Rule ID 1814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1814,
        GIR_Done,
      // Label 398: @15443
      GIM_Try, /*On fail goto*//*Label 399*/ 15479, // Rule ID 943 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, V128:{ *:[v4i32] }:$Rn)  =>  (NEGv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 399: @15479
      GIM_Try, /*On fail goto*//*Label 400*/ 15524, // Rule ID 1835 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1835,
        GIR_Done,
      // Label 400: @15524
      GIM_Try, /*On fail goto*//*Label 401*/ 15569, // Rule ID 1736 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1736,
        GIR_Done,
      // Label 401: @15569
      GIM_Try, /*On fail goto*//*Label 402*/ 15614, // Rule ID 1834 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1834,
        GIR_Done,
      // Label 402: @15614
      GIM_Try, /*On fail goto*//*Label 403*/ 15633, // Rule ID 1450 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (SUBv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1450,
        GIR_Done,
      // Label 403: @15633
      GIM_Reject,
    // Label 393: @15634
    GIM_Reject,
    // Label 335: @15635
    GIM_Try, /*On fail goto*//*Label 404*/ 15705,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 405*/ 15685, // Rule ID 938 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } immAllZerosV:{ *:[v8i8] }, V64:{ *:[v8i8] }:$Rn)  =>  (NEGv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 938,
        GIR_Done,
      // Label 405: @15685
      GIM_Try, /*On fail goto*//*Label 406*/ 15704, // Rule ID 1445 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (SUBv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1445,
        GIR_Done,
      // Label 406: @15704
      GIM_Reject,
    // Label 404: @15705
    GIM_Reject,
    // Label 336: @15706
    GIM_Try, /*On fail goto*//*Label 407*/ 16201,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 408*/ 15778, // Rule ID 1809 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1809,
        GIR_Done,
      // Label 408: @15778
      GIM_Try, /*On fail goto*//*Label 409*/ 15836, // Rule ID 1808 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1808,
        GIR_Done,
      // Label 409: @15836
      GIM_Try, /*On fail goto*//*Label 410*/ 15894, // Rule ID 1728 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1728,
        GIR_Done,
      // Label 410: @15894
      GIM_Try, /*On fail goto*//*Label 411*/ 15952, // Rule ID 1807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1807,
        GIR_Done,
      // Label 411: @15952
      GIM_Try, /*On fail goto*//*Label 412*/ 16010, // Rule ID 1806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1806,
        GIR_Done,
      // Label 412: @16010
      GIM_Try, /*On fail goto*//*Label 413*/ 16046, // Rule ID 941 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } immAllZerosV:{ *:[v8i16] }, V128:{ *:[v8i16] }:$Rn)  =>  (NEGv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 413: @16046
      GIM_Try, /*On fail goto*//*Label 414*/ 16091, // Rule ID 1831 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1831,
        GIR_Done,
      // Label 414: @16091
      GIM_Try, /*On fail goto*//*Label 415*/ 16136, // Rule ID 1734 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1734,
        GIR_Done,
      // Label 415: @16136
      GIM_Try, /*On fail goto*//*Label 416*/ 16181, // Rule ID 1830 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1830,
        GIR_Done,
      // Label 416: @16181
      GIM_Try, /*On fail goto*//*Label 417*/ 16200, // Rule ID 1448 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (SUBv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1448,
        GIR_Done,
      // Label 417: @16200
      GIM_Reject,
    // Label 407: @16201
    GIM_Reject,
    // Label 337: @16202
    GIM_Try, /*On fail goto*//*Label 418*/ 16272,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 419*/ 16252, // Rule ID 939 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } immAllZerosV:{ *:[v16i8] }, V128:{ *:[v16i8] }:$Rn)  =>  (NEGv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 939,
        GIR_Done,
      // Label 419: @16252
      GIM_Try, /*On fail goto*//*Label 420*/ 16271, // Rule ID 1446 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (SUBv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1446,
        GIR_Done,
      // Label 420: @16271
      GIM_Reject,
    // Label 418: @16272
    GIM_Reject,
    // Label 338: @16273
    GIM_Try, /*On fail goto*//*Label 421*/ 16296, // Rule ID 6403 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (sub:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (SUB_ZZZ_D:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUB_ZZZ_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6403,
      GIR_Done,
    // Label 421: @16296
    GIM_Reject,
    // Label 339: @16297
    GIM_Try, /*On fail goto*//*Label 422*/ 16320, // Rule ID 6402 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (sub:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (SUB_ZZZ_S:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUB_ZZZ_S,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6402,
      GIR_Done,
    // Label 422: @16320
    GIM_Reject,
    // Label 340: @16321
    GIM_Try, /*On fail goto*//*Label 423*/ 16344, // Rule ID 6401 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (sub:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (SUB_ZZZ_H:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUB_ZZZ_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6401,
      GIR_Done,
    // Label 423: @16344
    GIM_Reject,
    // Label 341: @16345
    GIM_Try, /*On fail goto*//*Label 424*/ 16368, // Rule ID 6400 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (sub:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (SUB_ZZZ_B:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUB_ZZZ_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6400,
      GIR_Done,
    // Label 424: @16368
    GIM_Reject,
    // Label 342: @16369
    GIM_Reject,
    // Label 2: @16370
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 12, /*)*//*default:*//*Label 433*/ 17684,
    /*GILLT_s32*//*Label 425*/ 16386,
    /*GILLT_s64*//*Label 426*/ 16546, 0,
    /*GILLT_v2s32*//*Label 427*/ 16968, 0,
    /*GILLT_v4s16*//*Label 428*/ 17131,
    /*GILLT_v4s32*//*Label 429*/ 17294,
    /*GILLT_v8s8*//*Label 430*/ 17457,
    /*GILLT_v8s16*//*Label 431*/ 17489,
    /*GILLT_v16s8*//*Label 432*/ 17652,
    // Label 425: @16386
    GIM_Try, /*On fail goto*//*Label 434*/ 16545,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 435*/ 16455, // Rule ID 3605 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn), GPR32:{ *:[i32] }:$Rm)  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3605,
        GIR_Done,
      // Label 435: @16455
      GIM_Try, /*On fail goto*//*Label 436*/ 16510, // Rule ID 11979 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11979,
        GIR_Done,
      // Label 436: @16510
      GIM_Try, /*On fail goto*//*Label 437*/ 16544, // Rule ID 3601 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (MADDWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3601,
        GIR_Done,
      // Label 437: @16544
      GIM_Reject,
    // Label 434: @16545
    GIM_Reject,
    // Label 426: @16546
    GIM_Try, /*On fail goto*//*Label 438*/ 16967,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 439*/ 16615, // Rule ID 3606 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn), GPR64:{ *:[i64] }:$Rm)  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3606,
        GIR_Done,
      // Label 439: @16615
      GIM_Try, /*On fail goto*//*Label 440*/ 16670, // Rule ID 11980 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11980,
        GIR_Done,
      // Label 440: @16670
      GIM_Try, /*On fail goto*//*Label 441*/ 16741, // Rule ID 3615 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_s64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3615,
        GIR_Done,
      // Label 441: @16741
      GIM_Try, /*On fail goto*//*Label 442*/ 16812, // Rule ID 3616 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_i64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3616,
        GIR_Done,
      // Label 442: @16812
      GIM_Try, /*On fail goto*//*Label 443*/ 16872, // Rule ID 3609 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3609,
        GIR_Done,
      // Label 443: @16872
      GIM_Try, /*On fail goto*//*Label 444*/ 16932, // Rule ID 3612 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3612,
        GIR_Done,
      // Label 444: @16932
      GIM_Try, /*On fail goto*//*Label 445*/ 16966, // Rule ID 3602 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (MADDXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3602,
        GIR_Done,
      // Label 445: @16966
      GIM_Reject,
    // Label 438: @16967
    GIM_Reject,
    // Label 427: @16968
    GIM_Try, /*On fail goto*//*Label 446*/ 17130,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 447*/ 17046, // Rule ID 11678 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v2i32] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn)  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv2i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11678,
        GIR_Done,
      // Label 447: @17046
      GIM_Try, /*On fail goto*//*Label 448*/ 17110, // Rule ID 2009 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv2i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2009,
        GIR_Done,
      // Label 448: @17110
      GIM_Try, /*On fail goto*//*Label 449*/ 17129, // Rule ID 1325 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (MULv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1325,
        GIR_Done,
      // Label 449: @17129
      GIM_Reject,
    // Label 446: @17130
    GIM_Reject,
    // Label 428: @17131
    GIM_Try, /*On fail goto*//*Label 450*/ 17293,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 451*/ 17209, // Rule ID 11675 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i16] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn)  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11675,
        GIR_Done,
      // Label 451: @17209
      GIM_Try, /*On fail goto*//*Label 452*/ 17273, // Rule ID 2006 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2006,
        GIR_Done,
      // Label 452: @17273
      GIM_Try, /*On fail goto*//*Label 453*/ 17292, // Rule ID 1323 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (MULv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1323,
        GIR_Done,
      // Label 453: @17292
      GIM_Reject,
    // Label 450: @17293
    GIM_Reject,
    // Label 429: @17294
    GIM_Try, /*On fail goto*//*Label 454*/ 17456,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 455*/ 17372, // Rule ID 11679 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V128:{ *:[v4i32] }:$Rn)  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11679,
        GIR_Done,
      // Label 455: @17372
      GIM_Try, /*On fail goto*//*Label 456*/ 17436, // Rule ID 2010 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2010,
        GIR_Done,
      // Label 456: @17436
      GIM_Try, /*On fail goto*//*Label 457*/ 17455, // Rule ID 1326 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (MULv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1326,
        GIR_Done,
      // Label 457: @17455
      GIM_Reject,
    // Label 454: @17456
    GIM_Reject,
    // Label 430: @17457
    GIM_Try, /*On fail goto*//*Label 458*/ 17488, // Rule ID 1321 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (MULv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1321,
      GIR_Done,
    // Label 458: @17488
    GIM_Reject,
    // Label 431: @17489
    GIM_Try, /*On fail goto*//*Label 459*/ 17651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 460*/ 17567, // Rule ID 11676 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v8i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V128:{ *:[v8i16] }:$Rn)  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv8i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11676,
        GIR_Done,
      // Label 460: @17567
      GIM_Try, /*On fail goto*//*Label 461*/ 17631, // Rule ID 2007 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv8i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2007,
        GIR_Done,
      // Label 461: @17631
      GIM_Try, /*On fail goto*//*Label 462*/ 17650, // Rule ID 1324 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (MULv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1324,
        GIR_Done,
      // Label 462: @17650
      GIM_Reject,
    // Label 459: @17651
    GIM_Reject,
    // Label 432: @17652
    GIM_Try, /*On fail goto*//*Label 463*/ 17683, // Rule ID 1322 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (MULv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1322,
      GIR_Done,
    // Label 463: @17683
    GIM_Reject,
    // Label 433: @17684
    GIM_Reject,
    // Label 3: @17685
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 466*/ 17753,
    /*GILLT_s32*//*Label 464*/ 17693,
    /*GILLT_s64*//*Label 465*/ 17723,
    // Label 464: @17693
    GIM_Try, /*On fail goto*//*Label 467*/ 17722, // Rule ID 119 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 119,
      GIR_Done,
    // Label 467: @17722
    GIM_Reject,
    // Label 465: @17723
    GIM_Try, /*On fail goto*//*Label 468*/ 17752, // Rule ID 120 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 120,
      GIR_Done,
    // Label 468: @17752
    GIM_Reject,
    // Label 466: @17753
    GIM_Reject,
    // Label 4: @17754
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 471*/ 17822,
    /*GILLT_s32*//*Label 469*/ 17762,
    /*GILLT_s64*//*Label 470*/ 17792,
    // Label 469: @17762
    GIM_Try, /*On fail goto*//*Label 472*/ 17791, // Rule ID 117 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (UDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 117,
      GIR_Done,
    // Label 472: @17791
    GIM_Reject,
    // Label 470: @17792
    GIM_Try, /*On fail goto*//*Label 473*/ 17821, // Rule ID 118 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (UDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 118,
      GIR_Done,
    // Label 473: @17821
    GIM_Reject,
    // Label 471: @17822
    GIM_Reject,
    // Label 5: @17823
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 24, /*)*//*default:*//*Label 492*/ 21246,
    /*GILLT_s32*//*Label 474*/ 17851,
    /*GILLT_s64*//*Label 475*/ 18338, 0,
    /*GILLT_v2s32*//*Label 476*/ 19576,
    /*GILLT_v2s64*//*Label 477*/ 19733,
    /*GILLT_v4s16*//*Label 478*/ 19890,
    /*GILLT_v4s32*//*Label 479*/ 20047,
    /*GILLT_v8s8*//*Label 480*/ 20204,
    /*GILLT_v8s16*//*Label 481*/ 20361,
    /*GILLT_v16s8*//*Label 482*/ 20518,
    /*GILLT_nxv1s1*//*Label 483*/ 20675,
    /*GILLT_nxv2s1*//*Label 484*/ 20770, 0, 0,
    /*GILLT_nxv2s64*//*Label 485*/ 20865,
    /*GILLT_nxv4s1*//*Label 486*/ 20889, 0,
    /*GILLT_nxv4s32*//*Label 487*/ 20984,
    /*GILLT_nxv8s1*//*Label 488*/ 21008,
    /*GILLT_nxv8s16*//*Label 489*/ 21103,
    /*GILLT_nxv16s1*//*Label 490*/ 21127,
    /*GILLT_nxv16s8*//*Label 491*/ 21222,
    // Label 474: @17851
    GIM_Try, /*On fail goto*//*Label 493*/ 18337,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 494*/ 17916, // Rule ID 11460 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11460,
        GIR_Done,
      // Label 494: @17916
      GIM_Try, /*On fail goto*//*Label 495*/ 17971, // Rule ID 164 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 164,
        GIR_Done,
      // Label 495: @17971
      GIM_Try, /*On fail goto*//*Label 496*/ 18033, // Rule ID 4803 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexB,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), 255:{ *:[i32] })  =>  (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4803,
        GIR_Done,
      // Label 496: @18033
      GIM_Try, /*On fail goto*//*Label 497*/ 18095, // Rule ID 4804 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 65535:{ *:[i32] })  =>  (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4804,
        GIR_Done,
      // Label 497: @18095
      GIM_Try, /*On fail goto*//*Label 498*/ 18150, // Rule ID 11458 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11458,
        GIR_Done,
      // Label 498: @18150
      GIM_Try, /*On fail goto*//*Label 499*/ 18205, // Rule ID 162 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 162,
        GIR_Done,
      // Label 499: @18205
      GIM_Try, /*On fail goto*//*Label 500*/ 18247, // Rule ID 144 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ANDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 500: @18247
      GIM_Try, /*On fail goto*//*Label 501*/ 18281, // Rule ID 11456 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11456,
        GIR_Done,
      // Label 501: @18281
      GIM_Try, /*On fail goto*//*Label 502*/ 18315, // Rule ID 160 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 160,
        GIR_Done,
      // Label 502: @18315
      GIM_Try, /*On fail goto*//*Label 503*/ 18336, // Rule ID 158 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ANDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 158,
        GIR_Done,
      // Label 503: @18336
      GIM_Reject,
    // Label 493: @18337
    GIM_Reject,
    // Label 475: @18338
    GIM_Try, /*On fail goto*//*Label 504*/ 19575,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 505*/ 18403, // Rule ID 11461 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11461,
        GIR_Done,
      // Label 505: @18403
      GIM_Try, /*On fail goto*//*Label 506*/ 18458, // Rule ID 165 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 506: @18458
      GIM_Try, /*On fail goto*//*Label 507*/ 18561, // Rule ID 4805 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexB,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)), 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::UMOVvi8,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 4805,
        GIR_Done,
      // Label 507: @18561
      GIM_Try, /*On fail goto*//*Label 508*/ 18664, // Rule ID 4806 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_VectorIndexH,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::UMOVvi16,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 4806,
        GIR_Done,
      // Label 508: @18664
      GIM_Try, /*On fail goto*//*Label 509*/ 18750, // Rule ID 6132 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldxr_1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 492:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6132,
        GIR_Done,
      // Label 509: @18750
      GIM_Try, /*On fail goto*//*Label 510*/ 18836, // Rule ID 6133 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldxr_2,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 492:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6133,
        GIR_Done,
      // Label 510: @18836
      GIM_Try, /*On fail goto*//*Label 511*/ 18922, // Rule ID 6134 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldxr_4,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 492:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6134,
        GIR_Done,
      // Label 511: @18922
      GIM_Try, /*On fail goto*//*Label 512*/ 19008, // Rule ID 6139 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldaxr_1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 489:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6139,
        GIR_Done,
      // Label 512: @19008
      GIM_Try, /*On fail goto*//*Label 513*/ 19094, // Rule ID 6140 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldaxr_2,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 489:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6140,
        GIR_Done,
      // Label 513: @19094
      GIM_Try, /*On fail goto*//*Label 514*/ 19180, // Rule ID 6141 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GICXXPred_MI_Predicate_ldaxr_4,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 489:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 6141,
        GIR_Done,
      // Label 514: @19180
      GIM_Try, /*On fail goto*//*Label 515*/ 19235, // Rule ID 11459 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11459,
        GIR_Done,
      // Label 515: @19235
      GIM_Try, /*On fail goto*//*Label 516*/ 19290, // Rule ID 163 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 163,
        GIR_Done,
      // Label 516: @19290
      GIM_Try, /*On fail goto*//*Label 517*/ 19332, // Rule ID 145 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ANDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 517: @19332
      GIM_Try, /*On fail goto*//*Label 518*/ 19366, // Rule ID 11457 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11457,
        GIR_Done,
      // Label 518: @19366
      GIM_Try, /*On fail goto*//*Label 519*/ 19400, // Rule ID 161 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 161,
        GIR_Done,
      // Label 519: @19400
      GIM_Try, /*On fail goto*//*Label 520*/ 19465, // Rule ID 12084 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12084,
        GIR_Done,
      // Label 520: @19465
      GIM_Try, /*On fail goto*//*Label 521*/ 19530, // Rule ID 4396 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4396,
        GIR_Done,
      // Label 521: @19530
      GIM_Try, /*On fail goto*//*Label 522*/ 19551, // Rule ID 159 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ANDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 159,
        GIR_Done,
      // Label 522: @19551
      GIM_Try, /*On fail goto*//*Label 523*/ 19574, // Rule ID 2379 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ANDv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2379,
        GIR_Done,
      // Label 523: @19574
      GIM_Reject,
    // Label 504: @19575
    GIM_Reject,
    // Label 476: @19576
    GIM_Try, /*On fail goto*//*Label 524*/ 19732,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 525*/ 19651, // Rule ID 12083 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12083,
        GIR_Done,
      // Label 525: @19651
      GIM_Try, /*On fail goto*//*Label 526*/ 19712, // Rule ID 4395 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4395,
        GIR_Done,
      // Label 526: @19712
      GIM_Try, /*On fail goto*//*Label 527*/ 19731, // Rule ID 2378 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ANDv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2378,
        GIR_Done,
      // Label 527: @19731
      GIM_Reject,
    // Label 524: @19732
    GIM_Reject,
    // Label 477: @19733
    GIM_Try, /*On fail goto*//*Label 528*/ 19889,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 529*/ 19808, // Rule ID 12087 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12087,
        GIR_Done,
      // Label 529: @19808
      GIM_Try, /*On fail goto*//*Label 530*/ 19869, // Rule ID 4399 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4399,
        GIR_Done,
      // Label 530: @19869
      GIM_Try, /*On fail goto*//*Label 531*/ 19888, // Rule ID 2382 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ANDv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2382,
        GIR_Done,
      // Label 531: @19888
      GIM_Reject,
    // Label 528: @19889
    GIM_Reject,
    // Label 478: @19890
    GIM_Try, /*On fail goto*//*Label 532*/ 20046,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 533*/ 19965, // Rule ID 12082 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$LHS)  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12082,
        GIR_Done,
      // Label 533: @19965
      GIM_Try, /*On fail goto*//*Label 534*/ 20026, // Rule ID 4394 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }))  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4394,
        GIR_Done,
      // Label 534: @20026
      GIM_Try, /*On fail goto*//*Label 535*/ 20045, // Rule ID 2377 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ANDv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2377,
        GIR_Done,
      // Label 535: @20045
      GIM_Reject,
    // Label 532: @20046
    GIM_Reject,
    // Label 479: @20047
    GIM_Try, /*On fail goto*//*Label 536*/ 20203,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 537*/ 20122, // Rule ID 12086 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$LHS)  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12086,
        GIR_Done,
      // Label 537: @20122
      GIM_Try, /*On fail goto*//*Label 538*/ 20183, // Rule ID 4398 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }))  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4398,
        GIR_Done,
      // Label 538: @20183
      GIM_Try, /*On fail goto*//*Label 539*/ 20202, // Rule ID 2381 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ANDv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2381,
        GIR_Done,
      // Label 539: @20202
      GIM_Reject,
    // Label 536: @20203
    GIM_Reject,
    // Label 480: @20204
    GIM_Try, /*On fail goto*//*Label 540*/ 20360,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 541*/ 20279, // Rule ID 11572 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rn)  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11572,
        GIR_Done,
      // Label 541: @20279
      GIM_Try, /*On fail goto*//*Label 542*/ 20340, // Rule ID 1570 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }))  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1570,
        GIR_Done,
      // Label 542: @20340
      GIM_Try, /*On fail goto*//*Label 543*/ 20359, // Rule ID 1568 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ANDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1568,
        GIR_Done,
      // Label 543: @20359
      GIM_Reject,
    // Label 540: @20360
    GIM_Reject,
    // Label 481: @20361
    GIM_Try, /*On fail goto*//*Label 544*/ 20517,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 545*/ 20436, // Rule ID 12085 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$LHS)  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12085,
        GIR_Done,
      // Label 545: @20436
      GIM_Try, /*On fail goto*//*Label 546*/ 20497, // Rule ID 4397 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }))  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4397,
        GIR_Done,
      // Label 546: @20497
      GIM_Try, /*On fail goto*//*Label 547*/ 20516, // Rule ID 2380 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ANDv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2380,
        GIR_Done,
      // Label 547: @20516
      GIM_Reject,
    // Label 544: @20517
    GIM_Reject,
    // Label 482: @20518
    GIM_Try, /*On fail goto*//*Label 548*/ 20674,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 549*/ 20593, // Rule ID 11573 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rn)  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11573,
        GIR_Done,
      // Label 549: @20593
      GIM_Try, /*On fail goto*//*Label 550*/ 20654, // Rule ID 1571 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }))  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1571,
        GIR_Done,
      // Label 550: @20654
      GIM_Try, /*On fail goto*//*Label 551*/ 20673, // Rule ID 1569 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ANDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1569,
        GIR_Done,
      // Label 551: @20673
      GIM_Reject,
    // Label 548: @20674
    GIM_Reject,
    // Label 483: @20675
    GIM_Try, /*On fail goto*//*Label 552*/ 20769,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 553*/ 20740, // Rule ID 9563 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
        // (and:{ *:[nxv1i1] } PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv1i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9563,
        GIR_Done,
      // Label 553: @20740
      GIM_Try, /*On fail goto*//*Label 554*/ 20768, // Rule ID 2622 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        // (and:{ *:[nxv1i1] } nxv1i1:{ *:[nxv1i1] }:$Op1, nxv1i1:{ *:[nxv1i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv1i1] } ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2622,
        GIR_Done,
      // Label 554: @20768
      GIM_Reject,
    // Label 552: @20769
    GIM_Reject,
    // Label 484: @20770
    GIM_Try, /*On fail goto*//*Label 555*/ 20864,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 556*/ 20835, // Rule ID 9562 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
        // (and:{ *:[nxv2i1] } PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv2i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9562,
        GIR_Done,
      // Label 556: @20835
      GIM_Try, /*On fail goto*//*Label 557*/ 20863, // Rule ID 2621 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        // (and:{ *:[nxv2i1] } nxv2i1:{ *:[nxv2i1] }:$Op1, nxv2i1:{ *:[nxv2i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv2i1] } ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2621,
        GIR_Done,
      // Label 557: @20863
      GIM_Reject,
    // Label 555: @20864
    GIM_Reject,
    // Label 485: @20865
    GIM_Try, /*On fail goto*//*Label 558*/ 20888, // Rule ID 3015 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (and:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::AND_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3015,
      GIR_Done,
    // Label 558: @20888
    GIM_Reject,
    // Label 486: @20889
    GIM_Try, /*On fail goto*//*Label 559*/ 20983,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 560*/ 20954, // Rule ID 9561 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
        // (and:{ *:[nxv4i1] } PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv4i1] } (PTRUE_S:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_S,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9561,
        GIR_Done,
      // Label 560: @20954
      GIM_Try, /*On fail goto*//*Label 561*/ 20982, // Rule ID 2620 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        // (and:{ *:[nxv4i1] } nxv4i1:{ *:[nxv4i1] }:$Op1, nxv4i1:{ *:[nxv4i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv4i1] } ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2620,
        GIR_Done,
      // Label 561: @20982
      GIM_Reject,
    // Label 559: @20983
    GIM_Reject,
    // Label 487: @20984
    GIM_Try, /*On fail goto*//*Label 562*/ 21007, // Rule ID 3014 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (and:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::AND_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3014,
      GIR_Done,
    // Label 562: @21007
    GIM_Reject,
    // Label 488: @21008
    GIM_Try, /*On fail goto*//*Label 563*/ 21102,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 564*/ 21073, // Rule ID 9560 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
        // (and:{ *:[nxv8i1] } PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv8i1] } (PTRUE_H:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_H,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9560,
        GIR_Done,
      // Label 564: @21073
      GIM_Try, /*On fail goto*//*Label 565*/ 21101, // Rule ID 2619 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        // (and:{ *:[nxv8i1] } nxv8i1:{ *:[nxv8i1] }:$Op1, nxv8i1:{ *:[nxv8i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv8i1] } ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2619,
        GIR_Done,
      // Label 565: @21101
      GIM_Reject,
    // Label 563: @21102
    GIM_Reject,
    // Label 489: @21103
    GIM_Try, /*On fail goto*//*Label 566*/ 21126, // Rule ID 3013 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (and:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::AND_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3013,
      GIR_Done,
    // Label 566: @21126
    GIM_Reject,
    // Label 490: @21127
    GIM_Try, /*On fail goto*//*Label 567*/ 21221,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 568*/ 21192, // Rule ID 9559 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
        // (and:{ *:[nxv16i1] } PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv16i1] } (PTRUE_B:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_B,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9559,
        GIR_Done,
      // Label 568: @21192
      GIM_Try, /*On fail goto*//*Label 569*/ 21220, // Rule ID 2618 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME,
        // (and:{ *:[nxv16i1] } nxv16i1:{ *:[nxv16i1] }:$Op1, nxv16i1:{ *:[nxv16i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv16i1] } ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2618,
        GIR_Done,
      // Label 569: @21220
      GIM_Reject,
    // Label 567: @21221
    GIM_Reject,
    // Label 491: @21222
    GIM_Try, /*On fail goto*//*Label 570*/ 21245, // Rule ID 3012 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (and:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::AND_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3012,
      GIR_Done,
    // Label 570: @21245
    GIM_Reject,
    // Label 492: @21246
    GIM_Reject,
    // Label 6: @21247
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 24, /*)*//*default:*//*Label 589*/ 33156,
    /*GILLT_s32*//*Label 571*/ 21275,
    /*GILLT_s64*//*Label 572*/ 21638, 0,
    /*GILLT_v2s32*//*Label 573*/ 23776,
    /*GILLT_v2s64*//*Label 574*/ 25073,
    /*GILLT_v4s16*//*Label 575*/ 26370,
    /*GILLT_v4s32*//*Label 576*/ 27667,
    /*GILLT_v8s8*//*Label 577*/ 28964,
    /*GILLT_v8s16*//*Label 578*/ 30261,
    /*GILLT_v16s8*//*Label 579*/ 31558,
    /*GILLT_nxv1s1*//*Label 580*/ 32855,
    /*GILLT_nxv2s1*//*Label 581*/ 32896, 0, 0,
    /*GILLT_nxv2s64*//*Label 582*/ 32937,
    /*GILLT_nxv4s1*//*Label 583*/ 32961, 0,
    /*GILLT_nxv4s32*//*Label 584*/ 33002,
    /*GILLT_nxv8s1*//*Label 585*/ 33026,
    /*GILLT_nxv8s16*//*Label 586*/ 33067,
    /*GILLT_nxv16s1*//*Label 587*/ 33091,
    /*GILLT_nxv16s8*//*Label 588*/ 33132,
    // Label 571: @21275
    GIM_Try, /*On fail goto*//*Label 590*/ 21637,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 591*/ 21340, // Rule ID 11480 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11480,
        GIR_Done,
      // Label 591: @21340
      GIM_Try, /*On fail goto*//*Label 592*/ 21395, // Rule ID 176 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 176,
        GIR_Done,
      // Label 592: @21395
      GIM_Try, /*On fail goto*//*Label 593*/ 21437, // Rule ID 148 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ORRWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 593: @21437
      GIM_Try, /*On fail goto*//*Label 594*/ 21471, // Rule ID 11482 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11482,
        GIR_Done,
      // Label 594: @21471
      GIM_Try, /*On fail goto*//*Label 595*/ 21505, // Rule ID 180 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 595: @21505
      GIM_Try, /*On fail goto*//*Label 596*/ 21560, // Rule ID 11478 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11478,
        GIR_Done,
      // Label 596: @21560
      GIM_Try, /*On fail goto*//*Label 597*/ 21615, // Rule ID 174 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 597: @21615
      GIM_Try, /*On fail goto*//*Label 598*/ 21636, // Rule ID 178 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ORRWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 178,
        GIR_Done,
      // Label 598: @21636
      GIM_Reject,
    // Label 590: @21637
    GIM_Reject,
    // Label 572: @21638
    GIM_Try, /*On fail goto*//*Label 599*/ 23775,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 600*/ 21759, // Rule ID 3664 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 71777214294589695,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -71777214294589696,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }), (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV16Xr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3664,
        GIR_Done,
      // Label 600: @21759
      GIM_Try, /*On fail goto*//*Label 601*/ 21870, // Rule ID 12002 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -71777214294589696,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 71777214294589695,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }), (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV16Xr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12002,
        GIR_Done,
      // Label 601: @21870
      GIM_Try, /*On fail goto*//*Label 602*/ 21925, // Rule ID 11481 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11481,
        GIR_Done,
      // Label 602: @21925
      GIM_Try, /*On fail goto*//*Label 603*/ 21980, // Rule ID 177 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 603: @21980
      GIM_Try, /*On fail goto*//*Label 604*/ 22088, // Rule ID 11806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11806,
        GIR_Done,
      // Label 604: @22088
      GIM_Try, /*On fail goto*//*Label 605*/ 22196, // Rule ID 11805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11805,
        GIR_Done,
      // Label 605: @22196
      GIM_Try, /*On fail goto*//*Label 606*/ 22304, // Rule ID 11808 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11808,
        GIR_Done,
      // Label 606: @22304
      GIM_Try, /*On fail goto*//*Label 607*/ 22412, // Rule ID 11807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11807,
        GIR_Done,
      // Label 607: @22412
      GIM_Try, /*On fail goto*//*Label 608*/ 22520, // Rule ID 2366 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2366,
        GIR_Done,
      // Label 608: @22520
      GIM_Try, /*On fail goto*//*Label 609*/ 22628, // Rule ID 11803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11803,
        GIR_Done,
      // Label 609: @22628
      GIM_Try, /*On fail goto*//*Label 610*/ 22736, // Rule ID 11802 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11802,
        GIR_Done,
      // Label 610: @22736
      GIM_Try, /*On fail goto*//*Label 611*/ 22844, // Rule ID 11804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11804,
        GIR_Done,
      // Label 611: @22844
      GIM_Try, /*On fail goto*//*Label 612*/ 22886, // Rule ID 149 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ORRXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 612: @22886
      GIM_Try, /*On fail goto*//*Label 613*/ 22920, // Rule ID 11483 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11483,
        GIR_Done,
      // Label 613: @22920
      GIM_Try, /*On fail goto*//*Label 614*/ 22954, // Rule ID 181 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 614: @22954
      GIM_Try, /*On fail goto*//*Label 615*/ 23021, // Rule ID 11742 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11742,
        GIR_Done,
      // Label 615: @23021
      GIM_Try, /*On fail goto*//*Label 616*/ 23088, // Rule ID 12126 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12126,
        GIR_Done,
      // Label 616: @23088
      GIM_Try, /*On fail goto*//*Label 617*/ 23155, // Rule ID 11745 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11745,
        GIR_Done,
      // Label 617: @23155
      GIM_Try, /*On fail goto*//*Label 618*/ 23222, // Rule ID 12129 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12129,
        GIR_Done,
      // Label 618: @23222
      GIM_Try, /*On fail goto*//*Label 619*/ 23277, // Rule ID 11479 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11479,
        GIR_Done,
      // Label 619: @23277
      GIM_Try, /*On fail goto*//*Label 620*/ 23344, // Rule ID 2094 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2094,
        GIR_Done,
      // Label 620: @23344
      GIM_Try, /*On fail goto*//*Label 621*/ 23411, // Rule ID 5292 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5292,
        GIR_Done,
      // Label 621: @23411
      GIM_Try, /*On fail goto*//*Label 622*/ 23478, // Rule ID 2103 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2103,
        GIR_Done,
      // Label 622: @23478
      GIM_Try, /*On fail goto*//*Label 623*/ 23545, // Rule ID 5298 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5298,
        GIR_Done,
      // Label 623: @23545
      GIM_Try, /*On fail goto*//*Label 624*/ 23600, // Rule ID 175 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 624: @23600
      GIM_Try, /*On fail goto*//*Label 625*/ 23665, // Rule ID 12090 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12090,
        GIR_Done,
      // Label 625: @23665
      GIM_Try, /*On fail goto*//*Label 626*/ 23730, // Rule ID 4408 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4408,
        GIR_Done,
      // Label 626: @23730
      GIM_Try, /*On fail goto*//*Label 627*/ 23751, // Rule ID 179 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ORRXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 179,
        GIR_Done,
      // Label 627: @23751
      GIM_Try, /*On fail goto*//*Label 628*/ 23774, // Rule ID 4414 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ORRv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4414,
        GIR_Done,
      // Label 628: @23774
      GIM_Reject,
    // Label 599: @23775
    GIM_Reject,
    // Label 573: @23776
    GIM_Try, /*On fail goto*//*Label 629*/ 25072,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 630*/ 23894, // Rule ID 11799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11799,
        GIR_Done,
      // Label 630: @23894
      GIM_Try, /*On fail goto*//*Label 631*/ 24002, // Rule ID 11798 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11798,
        GIR_Done,
      // Label 631: @24002
      GIM_Try, /*On fail goto*//*Label 632*/ 24110, // Rule ID 11801 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11801,
        GIR_Done,
      // Label 632: @24110
      GIM_Try, /*On fail goto*//*Label 633*/ 24218, // Rule ID 11800 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11800,
        GIR_Done,
      // Label 633: @24218
      GIM_Try, /*On fail goto*//*Label 634*/ 24326, // Rule ID 2365 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2365,
        GIR_Done,
      // Label 634: @24326
      GIM_Try, /*On fail goto*//*Label 635*/ 24434, // Rule ID 11796 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11796,
        GIR_Done,
      // Label 635: @24434
      GIM_Try, /*On fail goto*//*Label 636*/ 24542, // Rule ID 11795 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11795,
        GIR_Done,
      // Label 636: @24542
      GIM_Try, /*On fail goto*//*Label 637*/ 24650, // Rule ID 11797 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11797,
        GIR_Done,
      // Label 637: @24650
      GIM_Try, /*On fail goto*//*Label 638*/ 24717, // Rule ID 11762 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11762,
        GIR_Done,
      // Label 638: @24717
      GIM_Try, /*On fail goto*//*Label 639*/ 24784, // Rule ID 11783 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11783,
        GIR_Done,
      // Label 639: @24784
      GIM_Try, /*On fail goto*//*Label 640*/ 24851, // Rule ID 2208 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2208,
        GIR_Done,
      // Label 640: @24851
      GIM_Try, /*On fail goto*//*Label 641*/ 24918, // Rule ID 2267 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2267,
        GIR_Done,
      // Label 641: @24918
      GIM_Try, /*On fail goto*//*Label 642*/ 24983, // Rule ID 12089 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12089,
        GIR_Done,
      // Label 642: @24983
      GIM_Try, /*On fail goto*//*Label 643*/ 25048, // Rule ID 4407 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4407,
        GIR_Done,
      // Label 643: @25048
      GIM_Try, /*On fail goto*//*Label 644*/ 25071, // Rule ID 4413 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ORRv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4413,
        GIR_Done,
      // Label 644: @25071
      GIM_Reject,
    // Label 629: @25072
    GIM_Reject,
    // Label 574: @25073
    GIM_Try, /*On fail goto*//*Label 645*/ 26369,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 646*/ 25191, // Rule ID 11827 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11827,
        GIR_Done,
      // Label 646: @25191
      GIM_Try, /*On fail goto*//*Label 647*/ 25299, // Rule ID 11826 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11826,
        GIR_Done,
      // Label 647: @25299
      GIM_Try, /*On fail goto*//*Label 648*/ 25407, // Rule ID 11829 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11829,
        GIR_Done,
      // Label 648: @25407
      GIM_Try, /*On fail goto*//*Label 649*/ 25515, // Rule ID 11828 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11828,
        GIR_Done,
      // Label 649: @25515
      GIM_Try, /*On fail goto*//*Label 650*/ 25623, // Rule ID 2369 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2369,
        GIR_Done,
      // Label 650: @25623
      GIM_Try, /*On fail goto*//*Label 651*/ 25731, // Rule ID 11824 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11824,
        GIR_Done,
      // Label 651: @25731
      GIM_Try, /*On fail goto*//*Label 652*/ 25839, // Rule ID 11823 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11823,
        GIR_Done,
      // Label 652: @25839
      GIM_Try, /*On fail goto*//*Label 653*/ 25947, // Rule ID 11825 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11825,
        GIR_Done,
      // Label 653: @25947
      GIM_Try, /*On fail goto*//*Label 654*/ 26014, // Rule ID 11766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11766,
        GIR_Done,
      // Label 654: @26014
      GIM_Try, /*On fail goto*//*Label 655*/ 26081, // Rule ID 11787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11787,
        GIR_Done,
      // Label 655: @26081
      GIM_Try, /*On fail goto*//*Label 656*/ 26148, // Rule ID 2212 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2212,
        GIR_Done,
      // Label 656: @26148
      GIM_Try, /*On fail goto*//*Label 657*/ 26215, // Rule ID 2271 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2271,
        GIR_Done,
      // Label 657: @26215
      GIM_Try, /*On fail goto*//*Label 658*/ 26280, // Rule ID 12093 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12093,
        GIR_Done,
      // Label 658: @26280
      GIM_Try, /*On fail goto*//*Label 659*/ 26345, // Rule ID 4411 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4411,
        GIR_Done,
      // Label 659: @26345
      GIM_Try, /*On fail goto*//*Label 660*/ 26368, // Rule ID 4417 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ORRv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4417,
        GIR_Done,
      // Label 660: @26368
      GIM_Reject,
    // Label 645: @26369
    GIM_Reject,
    // Label 575: @26370
    GIM_Try, /*On fail goto*//*Label 661*/ 27666,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 662*/ 26488, // Rule ID 11792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11792,
        GIR_Done,
      // Label 662: @26488
      GIM_Try, /*On fail goto*//*Label 663*/ 26596, // Rule ID 11791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11791,
        GIR_Done,
      // Label 663: @26596
      GIM_Try, /*On fail goto*//*Label 664*/ 26704, // Rule ID 11794 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11794,
        GIR_Done,
      // Label 664: @26704
      GIM_Try, /*On fail goto*//*Label 665*/ 26812, // Rule ID 11793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11793,
        GIR_Done,
      // Label 665: @26812
      GIM_Try, /*On fail goto*//*Label 666*/ 26920, // Rule ID 2364 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2364,
        GIR_Done,
      // Label 666: @26920
      GIM_Try, /*On fail goto*//*Label 667*/ 27028, // Rule ID 11789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11789,
        GIR_Done,
      // Label 667: @27028
      GIM_Try, /*On fail goto*//*Label 668*/ 27136, // Rule ID 11788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11788,
        GIR_Done,
      // Label 668: @27136
      GIM_Try, /*On fail goto*//*Label 669*/ 27244, // Rule ID 11790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11790,
        GIR_Done,
      // Label 669: @27244
      GIM_Try, /*On fail goto*//*Label 670*/ 27311, // Rule ID 11758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11758,
        GIR_Done,
      // Label 670: @27311
      GIM_Try, /*On fail goto*//*Label 671*/ 27378, // Rule ID 11779 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11779,
        GIR_Done,
      // Label 671: @27378
      GIM_Try, /*On fail goto*//*Label 672*/ 27445, // Rule ID 2204 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2204,
        GIR_Done,
      // Label 672: @27445
      GIM_Try, /*On fail goto*//*Label 673*/ 27512, // Rule ID 2263 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2263,
        GIR_Done,
      // Label 673: @27512
      GIM_Try, /*On fail goto*//*Label 674*/ 27577, // Rule ID 12088 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$LHS)  =>  (ORNv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12088,
        GIR_Done,
      // Label 674: @27577
      GIM_Try, /*On fail goto*//*Label 675*/ 27642, // Rule ID 4406 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }))  =>  (ORNv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4406,
        GIR_Done,
      // Label 675: @27642
      GIM_Try, /*On fail goto*//*Label 676*/ 27665, // Rule ID 4412 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ORRv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4412,
        GIR_Done,
      // Label 676: @27665
      GIM_Reject,
    // Label 661: @27666
    GIM_Reject,
    // Label 576: @27667
    GIM_Try, /*On fail goto*//*Label 677*/ 28963,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 678*/ 27785, // Rule ID 11820 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11820,
        GIR_Done,
      // Label 678: @27785
      GIM_Try, /*On fail goto*//*Label 679*/ 27893, // Rule ID 11819 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11819,
        GIR_Done,
      // Label 679: @27893
      GIM_Try, /*On fail goto*//*Label 680*/ 28001, // Rule ID 11822 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11822,
        GIR_Done,
      // Label 680: @28001
      GIM_Try, /*On fail goto*//*Label 681*/ 28109, // Rule ID 11821 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11821,
        GIR_Done,
      // Label 681: @28109
      GIM_Try, /*On fail goto*//*Label 682*/ 28217, // Rule ID 2368 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2368,
        GIR_Done,
      // Label 682: @28217
      GIM_Try, /*On fail goto*//*Label 683*/ 28325, // Rule ID 11817 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11817,
        GIR_Done,
      // Label 683: @28325
      GIM_Try, /*On fail goto*//*Label 684*/ 28433, // Rule ID 11816 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11816,
        GIR_Done,
      // Label 684: @28433
      GIM_Try, /*On fail goto*//*Label 685*/ 28541, // Rule ID 11818 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11818,
        GIR_Done,
      // Label 685: @28541
      GIM_Try, /*On fail goto*//*Label 686*/ 28608, // Rule ID 11764 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11764,
        GIR_Done,
      // Label 686: @28608
      GIM_Try, /*On fail goto*//*Label 687*/ 28675, // Rule ID 11785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11785,
        GIR_Done,
      // Label 687: @28675
      GIM_Try, /*On fail goto*//*Label 688*/ 28742, // Rule ID 2210 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2210,
        GIR_Done,
      // Label 688: @28742
      GIM_Try, /*On fail goto*//*Label 689*/ 28809, // Rule ID 2269 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2269,
        GIR_Done,
      // Label 689: @28809
      GIM_Try, /*On fail goto*//*Label 690*/ 28874, // Rule ID 12092 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$LHS)  =>  (ORNv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12092,
        GIR_Done,
      // Label 690: @28874
      GIM_Try, /*On fail goto*//*Label 691*/ 28939, // Rule ID 4410 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }))  =>  (ORNv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4410,
        GIR_Done,
      // Label 691: @28939
      GIM_Try, /*On fail goto*//*Label 692*/ 28962, // Rule ID 4416 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ORRv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4416,
        GIR_Done,
      // Label 692: @28962
      GIM_Reject,
    // Label 677: @28963
    GIM_Reject,
    // Label 577: @28964
    GIM_Try, /*On fail goto*//*Label 693*/ 30260,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_Try, /*On fail goto*//*Label 694*/ 29082, // Rule ID 11580 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11580,
        GIR_Done,
      // Label 694: @29082
      GIM_Try, /*On fail goto*//*Label 695*/ 29190, // Rule ID 11579 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11579,
        GIR_Done,
      // Label 695: @29190
      GIM_Try, /*On fail goto*//*Label 696*/ 29298, // Rule ID 11582 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11582,
        GIR_Done,
      // Label 696: @29298
      GIM_Try, /*On fail goto*//*Label 697*/ 29406, // Rule ID 11581 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11581,
        GIR_Done,
      // Label 697: @29406
      GIM_Try, /*On fail goto*//*Label 698*/ 29514, // Rule ID 1578 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn), (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1578,
        GIR_Done,
      // Label 698: @29514
      GIM_Try, /*On fail goto*//*Label 699*/ 29622, // Rule ID 11577 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd), (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11577,
        GIR_Done,
      // Label 699: @29622
      GIM_Try, /*On fail goto*//*Label 700*/ 29730, // Rule ID 11576 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11576,
        GIR_Done,
      // Label 700: @29730
      GIM_Try, /*On fail goto*//*Label 701*/ 29838, // Rule ID 11578 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11578,
        GIR_Done,
      // Label 701: @29838
      GIM_Try, /*On fail goto*//*Label 702*/ 29905, // Rule ID 11754 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11754,
        GIR_Done,
      // Label 702: @29905
      GIM_Try, /*On fail goto*//*Label 703*/ 29972, // Rule ID 11775 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11775,
        GIR_Done,
      // Label 703: @29972
      GIM_Try, /*On fail goto*//*Label 704*/ 30039, // Rule ID 2200 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2200,
        GIR_Done,
      // Label 704: @30039
      GIM_Try, /*On fail goto*//*Label 705*/ 30106, // Rule ID 2259 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2259,
        GIR_Done,
      // Label 705: @30106
      GIM_Try, /*On fail goto*//*Label 706*/ 30171, // Rule ID 11574 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rn)  =>  (ORNv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11574,
        GIR_Done,
      // Label 706: @30171
      GIM_Try, /*On fail goto*//*Label 707*/ 30236, // Rule ID 1574 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }))  =>  (ORNv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1574,
        GIR_Done,
      // Label 707: @30236
      GIM_Try, /*On fail goto*//*Label 708*/ 30259, // Rule ID 1576 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ORRv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1576,
        GIR_Done,
      // Label 708: @30259
      GIM_Reject,
    // Label 693: @30260
    GIM_Reject,
    // Label 578: @30261
    GIM_Try, /*On fail goto*//*Label 709*/ 31557,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 710*/ 30379, // Rule ID 11813 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11813,
        GIR_Done,
      // Label 710: @30379
      GIM_Try, /*On fail goto*//*Label 711*/ 30487, // Rule ID 11812 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11812,
        GIR_Done,
      // Label 711: @30487
      GIM_Try, /*On fail goto*//*Label 712*/ 30595, // Rule ID 11815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11815,
        GIR_Done,
      // Label 712: @30595
      GIM_Try, /*On fail goto*//*Label 713*/ 30703, // Rule ID 11814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11814,
        GIR_Done,
      // Label 713: @30703
      GIM_Try, /*On fail goto*//*Label 714*/ 30811, // Rule ID 2367 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS), (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2367,
        GIR_Done,
      // Label 714: @30811
      GIM_Try, /*On fail goto*//*Label 715*/ 30919, // Rule ID 11810 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS), (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11810,
        GIR_Done,
      // Label 715: @30919
      GIM_Try, /*On fail goto*//*Label 716*/ 31027, // Rule ID 11809 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11809,
        GIR_Done,
      // Label 716: @31027
      GIM_Try, /*On fail goto*//*Label 717*/ 31135, // Rule ID 11811 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11811,
        GIR_Done,
      // Label 717: @31135
      GIM_Try, /*On fail goto*//*Label 718*/ 31202, // Rule ID 11760 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11760,
        GIR_Done,
      // Label 718: @31202
      GIM_Try, /*On fail goto*//*Label 719*/ 31269, // Rule ID 11781 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11781,
        GIR_Done,
      // Label 719: @31269
      GIM_Try, /*On fail goto*//*Label 720*/ 31336, // Rule ID 2206 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2206,
        GIR_Done,
      // Label 720: @31336
      GIM_Try, /*On fail goto*//*Label 721*/ 31403, // Rule ID 2265 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2265,
        GIR_Done,
      // Label 721: @31403
      GIM_Try, /*On fail goto*//*Label 722*/ 31468, // Rule ID 12091 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$LHS)  =>  (ORNv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12091,
        GIR_Done,
      // Label 722: @31468
      GIM_Try, /*On fail goto*//*Label 723*/ 31533, // Rule ID 4409 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }))  =>  (ORNv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4409,
        GIR_Done,
      // Label 723: @31533
      GIM_Try, /*On fail goto*//*Label 724*/ 31556, // Rule ID 4415 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ORRv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4415,
        GIR_Done,
      // Label 724: @31556
      GIM_Reject,
    // Label 709: @31557
    GIM_Reject,
    // Label 579: @31558
    GIM_Try, /*On fail goto*//*Label 725*/ 32854,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 726*/ 31676, // Rule ID 11587 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11587,
        GIR_Done,
      // Label 726: @31676
      GIM_Try, /*On fail goto*//*Label 727*/ 31784, // Rule ID 11586 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11586,
        GIR_Done,
      // Label 727: @31784
      GIM_Try, /*On fail goto*//*Label 728*/ 31892, // Rule ID 11589 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11589,
        GIR_Done,
      // Label 728: @31892
      GIM_Try, /*On fail goto*//*Label 729*/ 32000, // Rule ID 11588 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11588,
        GIR_Done,
      // Label 729: @32000
      GIM_Try, /*On fail goto*//*Label 730*/ 32108, // Rule ID 1579 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn), (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1579,
        GIR_Done,
      // Label 730: @32108
      GIM_Try, /*On fail goto*//*Label 731*/ 32216, // Rule ID 11584 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd), (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11584,
        GIR_Done,
      // Label 731: @32216
      GIM_Try, /*On fail goto*//*Label 732*/ 32324, // Rule ID 11583 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11583,
        GIR_Done,
      // Label 732: @32324
      GIM_Try, /*On fail goto*//*Label 733*/ 32432, // Rule ID 11585 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11585,
        GIR_Done,
      // Label 733: @32432
      GIM_Try, /*On fail goto*//*Label 734*/ 32499, // Rule ID 11756 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11756,
        GIR_Done,
      // Label 734: @32499
      GIM_Try, /*On fail goto*//*Label 735*/ 32566, // Rule ID 11777 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11777,
        GIR_Done,
      // Label 735: @32566
      GIM_Try, /*On fail goto*//*Label 736*/ 32633, // Rule ID 2202 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2202,
        GIR_Done,
      // Label 736: @32633
      GIM_Try, /*On fail goto*//*Label 737*/ 32700, // Rule ID 2261 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2261,
        GIR_Done,
      // Label 737: @32700
      GIM_Try, /*On fail goto*//*Label 738*/ 32765, // Rule ID 11575 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rn)  =>  (ORNv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11575,
        GIR_Done,
      // Label 738: @32765
      GIM_Try, /*On fail goto*//*Label 739*/ 32830, // Rule ID 1575 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }))  =>  (ORNv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1575,
        GIR_Done,
      // Label 739: @32830
      GIM_Try, /*On fail goto*//*Label 740*/ 32853, // Rule ID 1577 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ORRv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1577,
        GIR_Done,
      // Label 740: @32853
      GIM_Reject,
    // Label 725: @32854
    GIM_Reject,
    // Label 580: @32855
    GIM_Try, /*On fail goto*//*Label 741*/ 32895, // Rule ID 7394 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (or:{ *:[nxv1i1] } nxv1i1:{ *:[nxv1i1] }:$Op1, nxv1i1:{ *:[nxv1i1] }:$Op2)  =>  (SEL_PPPP:{ *:[nxv1i1] } ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op2)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SEL_PPPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7394,
      GIR_Done,
    // Label 741: @32895
    GIM_Reject,
    // Label 581: @32896
    GIM_Try, /*On fail goto*//*Label 742*/ 32936, // Rule ID 7393 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (or:{ *:[nxv2i1] } nxv2i1:{ *:[nxv2i1] }:$Op1, nxv2i1:{ *:[nxv2i1] }:$Op2)  =>  (SEL_PPPP:{ *:[nxv2i1] } ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op2)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SEL_PPPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7393,
      GIR_Done,
    // Label 742: @32936
    GIM_Reject,
    // Label 582: @32937
    GIM_Try, /*On fail goto*//*Label 743*/ 32960, // Rule ID 6423 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (or:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (ORR_ZZZ:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6423,
      GIR_Done,
    // Label 743: @32960
    GIM_Reject,
    // Label 583: @32961
    GIM_Try, /*On fail goto*//*Label 744*/ 33001, // Rule ID 7392 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (or:{ *:[nxv4i1] } nxv4i1:{ *:[nxv4i1] }:$Op1, nxv4i1:{ *:[nxv4i1] }:$Op2)  =>  (SEL_PPPP:{ *:[nxv4i1] } ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op2)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SEL_PPPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7392,
      GIR_Done,
    // Label 744: @33001
    GIM_Reject,
    // Label 584: @33002
    GIM_Try, /*On fail goto*//*Label 745*/ 33025, // Rule ID 6422 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (or:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (ORR_ZZZ:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6422,
      GIR_Done,
    // Label 745: @33025
    GIM_Reject,
    // Label 585: @33026
    GIM_Try, /*On fail goto*//*Label 746*/ 33066, // Rule ID 7391 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (or:{ *:[nxv8i1] } nxv8i1:{ *:[nxv8i1] }:$Op1, nxv8i1:{ *:[nxv8i1] }:$Op2)  =>  (SEL_PPPP:{ *:[nxv8i1] } ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op2)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SEL_PPPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7391,
      GIR_Done,
    // Label 746: @33066
    GIM_Reject,
    // Label 586: @33067
    GIM_Try, /*On fail goto*//*Label 747*/ 33090, // Rule ID 6421 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (or:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (ORR_ZZZ:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6421,
      GIR_Done,
    // Label 747: @33090
    GIM_Reject,
    // Label 587: @33091
    GIM_Try, /*On fail goto*//*Label 748*/ 33131, // Rule ID 7390 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (or:{ *:[nxv16i1] } nxv16i1:{ *:[nxv16i1] }:$Op1, nxv16i1:{ *:[nxv16i1] }:$Op2)  =>  (SEL_PPPP:{ *:[nxv16i1] } ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op2)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SEL_PPPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7390,
      GIR_Done,
    // Label 748: @33131
    GIM_Reject,
    // Label 588: @33132
    GIM_Try, /*On fail goto*//*Label 749*/ 33155, // Rule ID 6420 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (or:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (ORR_ZZZ:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6420,
      GIR_Done,
    // Label 749: @33155
    GIM_Reject,
    // Label 589: @33156
    GIM_Reject,
    // Label 7: @33157
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 24, /*)*//*default:*//*Label 768*/ 37773,
    /*GILLT_s32*//*Label 750*/ 33185,
    /*GILLT_s64*//*Label 751*/ 33857, 0,
    /*GILLT_v2s32*//*Label 752*/ 34590,
    /*GILLT_v2s64*//*Label 753*/ 34655,
    /*GILLT_v4s16*//*Label 754*/ 35182,
    /*GILLT_v4s32*//*Label 755*/ 35247,
    /*GILLT_v8s8*//*Label 756*/ 35774,
    /*GILLT_v8s16*//*Label 757*/ 35841,
    /*GILLT_v16s8*//*Label 758*/ 36868,
    /*GILLT_nxv1s1*//*Label 759*/ 37397,
    /*GILLT_nxv2s1*//*Label 760*/ 37453, 0, 0,
    /*GILLT_nxv2s64*//*Label 761*/ 37509,
    /*GILLT_nxv4s1*//*Label 762*/ 37533, 0,
    /*GILLT_nxv4s32*//*Label 763*/ 37589,
    /*GILLT_nxv8s1*//*Label 764*/ 37613,
    /*GILLT_nxv8s16*//*Label 765*/ 37669,
    /*GILLT_nxv16s1*//*Label 766*/ 37693,
    /*GILLT_nxv16s8*//*Label 767*/ 37749,
    // Label 750: @33185
    GIM_Try, /*On fail goto*//*Label 769*/ 33856,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 770*/ 33250, // Rule ID 11469 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11469,
        GIR_Done,
      // Label 770: @33250
      GIM_Try, /*On fail goto*//*Label 771*/ 33305, // Rule ID 11468 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11468,
        GIR_Done,
      // Label 771: @33305
      GIM_Try, /*On fail goto*//*Label 772*/ 33360, // Rule ID 11466 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11466,
        GIR_Done,
      // Label 772: @33360
      GIM_Try, /*On fail goto*//*Label 773*/ 33415, // Rule ID 168 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 168,
        GIR_Done,
      // Label 773: @33415
      GIM_Try, /*On fail goto*//*Label 774*/ 33470, // Rule ID 11467 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11467,
        GIR_Done,
      // Label 774: @33470
      GIM_Try, /*On fail goto*//*Label 775*/ 33525, // Rule ID 11470 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11470,
        GIR_Done,
      // Label 775: @33525
      GIM_Try, /*On fail goto*//*Label 776*/ 33567, // Rule ID 146 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (EORWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 776: @33567
      GIM_Try, /*On fail goto*//*Label 777*/ 33601, // Rule ID 11476 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11476,
        GIR_Done,
      // Label 777: @33601
      GIM_Try, /*On fail goto*//*Label 778*/ 33635, // Rule ID 172 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 778: @33635
      GIM_Try, /*On fail goto*//*Label 779*/ 33690, // Rule ID 11462 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rm)  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11462,
        GIR_Done,
      // Label 779: @33690
      GIM_Try, /*On fail goto*//*Label 780*/ 33745, // Rule ID 166 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm), -1:{ *:[i32] })  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 166,
        GIR_Done,
      // Label 780: @33745
      GIM_Try, /*On fail goto*//*Label 781*/ 33800, // Rule ID 11463 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11463,
        GIR_Done,
      // Label 781: @33800
      GIM_Try, /*On fail goto*//*Label 782*/ 33834, // Rule ID 3652 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Wm, -1:{ *:[i32] })  =>  (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Wm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Wm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3652,
        GIR_Done,
      // Label 782: @33834
      GIM_Try, /*On fail goto*//*Label 783*/ 33855, // Rule ID 170 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (EORWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 170,
        GIR_Done,
      // Label 783: @33855
      GIM_Reject,
    // Label 769: @33856
    GIM_Reject,
    // Label 751: @33857
    GIM_Try, /*On fail goto*//*Label 784*/ 34589,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 785*/ 33922, // Rule ID 11474 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11474,
        GIR_Done,
      // Label 785: @33922
      GIM_Try, /*On fail goto*//*Label 786*/ 33977, // Rule ID 11473 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11473,
        GIR_Done,
      // Label 786: @33977
      GIM_Try, /*On fail goto*//*Label 787*/ 34032, // Rule ID 11471 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11471,
        GIR_Done,
      // Label 787: @34032
      GIM_Try, /*On fail goto*//*Label 788*/ 34087, // Rule ID 169 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 169,
        GIR_Done,
      // Label 788: @34087
      GIM_Try, /*On fail goto*//*Label 789*/ 34142, // Rule ID 11472 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11472,
        GIR_Done,
      // Label 789: @34142
      GIM_Try, /*On fail goto*//*Label 790*/ 34197, // Rule ID 11475 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11475,
        GIR_Done,
      // Label 790: @34197
      GIM_Try, /*On fail goto*//*Label 791*/ 34239, // Rule ID 147 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (EORXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 791: @34239
      GIM_Try, /*On fail goto*//*Label 792*/ 34273, // Rule ID 11477 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11477,
        GIR_Done,
      // Label 792: @34273
      GIM_Try, /*On fail goto*//*Label 793*/ 34307, // Rule ID 173 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 793: @34307
      GIM_Try, /*On fail goto*//*Label 794*/ 34362, // Rule ID 11464 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rm)  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11464,
        GIR_Done,
      // Label 794: @34362
      GIM_Try, /*On fail goto*//*Label 795*/ 34417, // Rule ID 167 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm), -1:{ *:[i64] })  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 795: @34417
      GIM_Try, /*On fail goto*//*Label 796*/ 34472, // Rule ID 11465 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11465,
        GIR_Done,
      // Label 796: @34472
      GIM_Try, /*On fail goto*//*Label 797*/ 34506, // Rule ID 3653 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Xm, -1:{ *:[i64] })  =>  (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Xm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Xm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3653,
        GIR_Done,
      // Label 797: @34506
      GIM_Try, /*On fail goto*//*Label 798*/ 34544, // Rule ID 4312 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn, immAllOnesV:{ *:[v1i64] })  =>  (NOTv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4312,
        GIR_Done,
      // Label 798: @34544
      GIM_Try, /*On fail goto*//*Label 799*/ 34565, // Rule ID 171 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (EORXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 799: @34565
      GIM_Try, /*On fail goto*//*Label 800*/ 34588, // Rule ID 4402 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (EORv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4402,
        GIR_Done,
      // Label 800: @34588
      GIM_Reject,
    // Label 784: @34589
    GIM_Reject,
    // Label 752: @34590
    GIM_Try, /*On fail goto*//*Label 801*/ 34654,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 802*/ 34638, // Rule ID 4310 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, immAllOnesV:{ *:[v2i32] })  =>  (NOTv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4310,
        GIR_Done,
      // Label 802: @34638
      GIM_Try, /*On fail goto*//*Label 803*/ 34653, // Rule ID 4401 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (EORv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4401,
        GIR_Done,
      // Label 803: @34653
      GIM_Reject,
    // Label 801: @34654
    GIM_Reject,
    // Label 753: @34655
    GIM_Try, /*On fail goto*//*Label 804*/ 35181,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 805*/ 34755, // Rule ID 11971 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$Vm), V128:{ *:[v2i64] }:$Vn)  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11971,
        GIR_Done,
      // Label 805: @34755
      GIM_Try, /*On fail goto*//*Label 806*/ 34841, // Rule ID 11970 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vm, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] })), V128:{ *:[v2i64] }:$Vn)  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11970,
        GIR_Done,
      // Label 806: @34841
      GIM_Try, /*On fail goto*//*Label 807*/ 34927, // Rule ID 11969 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$Vm))  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11969,
        GIR_Done,
      // Label 807: @34927
      GIM_Try, /*On fail goto*//*Label 808*/ 35013, // Rule ID 3482 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vm, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] })))  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3482,
        GIR_Done,
      // Label 808: @35013
      GIM_Try, /*On fail goto*//*Label 809*/ 35047, // Rule ID 4313 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, immAllOnesV:{ *:[v2i64] })  =>  (NOTv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4313,
        GIR_Done,
      // Label 809: @35047
      GIM_Try, /*On fail goto*//*Label 810*/ 35104, // Rule ID 3478 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm), V128:{ *:[v2i64] }:$Va)  =>  (EOR3:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3478,
        GIR_Done,
      // Label 810: @35104
      GIM_Try, /*On fail goto*//*Label 811*/ 35161, // Rule ID 11959 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm))  =>  (EOR3:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11959,
        GIR_Done,
      // Label 811: @35161
      GIM_Try, /*On fail goto*//*Label 812*/ 35180, // Rule ID 4405 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (EORv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4405,
        GIR_Done,
      // Label 812: @35180
      GIM_Reject,
    // Label 804: @35181
    GIM_Reject,
    // Label 754: @35182
    GIM_Try, /*On fail goto*//*Label 813*/ 35246,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 814*/ 35230, // Rule ID 4308 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, immAllOnesV:{ *:[v4i16] })  =>  (NOTv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4308,
        GIR_Done,
      // Label 814: @35230
      GIM_Try, /*On fail goto*//*Label 815*/ 35245, // Rule ID 4400 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (EORv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4400,
        GIR_Done,
      // Label 815: @35245
      GIM_Reject,
    // Label 813: @35246
    GIM_Reject,
    // Label 755: @35247
    GIM_Try, /*On fail goto*//*Label 816*/ 35773,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 817*/ 35347, // Rule ID 11968 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$Vm), V128:{ *:[v4i32] }:$Vn)  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11968,
        GIR_Done,
      // Label 817: @35347
      GIM_Try, /*On fail goto*//*Label 818*/ 35433, // Rule ID 11967 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vm, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] })), V128:{ *:[v4i32] }:$Vn)  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11967,
        GIR_Done,
      // Label 818: @35433
      GIM_Try, /*On fail goto*//*Label 819*/ 35519, // Rule ID 11966 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$Vm))  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11966,
        GIR_Done,
      // Label 819: @35519
      GIM_Try, /*On fail goto*//*Label 820*/ 35605, // Rule ID 3481 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vm, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] })))  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3481,
        GIR_Done,
      // Label 820: @35605
      GIM_Try, /*On fail goto*//*Label 821*/ 35639, // Rule ID 4311 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, immAllOnesV:{ *:[v4i32] })  =>  (NOTv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4311,
        GIR_Done,
      // Label 821: @35639
      GIM_Try, /*On fail goto*//*Label 822*/ 35696, // Rule ID 3477 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm), V128:{ *:[v4i32] }:$Va)  =>  (EOR3:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3477,
        GIR_Done,
      // Label 822: @35696
      GIM_Try, /*On fail goto*//*Label 823*/ 35753, // Rule ID 11958 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm))  =>  (EOR3:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11958,
        GIR_Done,
      // Label 823: @35753
      GIM_Try, /*On fail goto*//*Label 824*/ 35772, // Rule ID 4404 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (EORv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4404,
        GIR_Done,
      // Label 824: @35772
      GIM_Reject,
    // Label 816: @35773
    GIM_Reject,
    // Label 756: @35774
    GIM_Try, /*On fail goto*//*Label 825*/ 35840,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 826*/ 35824, // Rule ID 945 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, immAllOnesV:{ *:[v8i8] })  =>  (NOTv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 826: @35824
      GIM_Try, /*On fail goto*//*Label 827*/ 35839, // Rule ID 1572 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (EORv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1572,
        GIR_Done,
      // Label 827: @35839
      GIM_Reject,
    // Label 825: @35840
    GIM_Reject,
    // Label 757: @35841
    GIM_Try, /*On fail goto*//*Label 828*/ 36867,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 829*/ 35980, // Rule ID 12051 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/1, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/0, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (add:{ *:[v8i16] } (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB)), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] })), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12051,
        GIR_Done,
      // Label 829: @35980
      GIM_Try, /*On fail goto*//*Label 830*/ 36105, // Rule ID 12052 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/0, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB))), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12052,
        GIR_Done,
      // Label 830: @36105
      GIM_Try, /*On fail goto*//*Label 831*/ 36230, // Rule ID 4254 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (add:{ *:[v8i16] } (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB)), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] })))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4254,
        GIR_Done,
      // Label 831: @36230
      GIM_Try, /*On fail goto*//*Label 832*/ 36355, // Rule ID 12050 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, AArch64::G_VASHR,
        // MIs[3] src
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/6, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB))))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12050,
        GIR_Done,
      // Label 832: @36355
      GIM_Try, /*On fail goto*//*Label 833*/ 36441, // Rule ID 11965 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$Vm), V128:{ *:[v8i16] }:$Vn)  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11965,
        GIR_Done,
      // Label 833: @36441
      GIM_Try, /*On fail goto*//*Label 834*/ 36527, // Rule ID 11964 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vm, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] })), V128:{ *:[v8i16] }:$Vn)  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11964,
        GIR_Done,
      // Label 834: @36527
      GIM_Try, /*On fail goto*//*Label 835*/ 36613, // Rule ID 11963 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$Vm))  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11963,
        GIR_Done,
      // Label 835: @36613
      GIM_Try, /*On fail goto*//*Label 836*/ 36699, // Rule ID 3480 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vm, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] })))  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3480,
        GIR_Done,
      // Label 836: @36699
      GIM_Try, /*On fail goto*//*Label 837*/ 36733, // Rule ID 4309 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, immAllOnesV:{ *:[v8i16] })  =>  (NOTv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4309,
        GIR_Done,
      // Label 837: @36733
      GIM_Try, /*On fail goto*//*Label 838*/ 36790, // Rule ID 3476 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm), V128:{ *:[v8i16] }:$Va)  =>  (EOR3:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3476,
        GIR_Done,
      // Label 838: @36790
      GIM_Try, /*On fail goto*//*Label 839*/ 36847, // Rule ID 11957 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm))  =>  (EOR3:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11957,
        GIR_Done,
      // Label 839: @36847
      GIM_Try, /*On fail goto*//*Label 840*/ 36866, // Rule ID 4403 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (EORv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4403,
        GIR_Done,
      // Label 840: @36866
      GIM_Reject,
    // Label 828: @36867
    GIM_Reject,
    // Label 758: @36868
    GIM_Try, /*On fail goto*//*Label 841*/ 37396,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 842*/ 36968, // Rule ID 11962 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Vm), V128:{ *:[v16i8] }:$Vn)  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11962,
        GIR_Done,
      // Label 842: @36968
      GIM_Try, /*On fail goto*//*Label 843*/ 37054, // Rule ID 11961 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] })), V128:{ *:[v16i8] }:$Vn)  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11961,
        GIR_Done,
      // Label 843: @37054
      GIM_Try, /*On fail goto*//*Label 844*/ 37140, // Rule ID 11960 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Vm))  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11960,
        GIR_Done,
      // Label 844: @37140
      GIM_Try, /*On fail goto*//*Label 845*/ 37226, // Rule ID 3479 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] })))  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3479,
        GIR_Done,
      // Label 845: @37226
      GIM_Try, /*On fail goto*//*Label 846*/ 37262, // Rule ID 946 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, immAllOnesV:{ *:[v16i8] })  =>  (NOTv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 946,
        GIR_Done,
      // Label 846: @37262
      GIM_Try, /*On fail goto*//*Label 847*/ 37319, // Rule ID 3475 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm), V128:{ *:[v16i8] }:$Va)  =>  (EOR3:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3475,
        GIR_Done,
      // Label 847: @37319
      GIM_Try, /*On fail goto*//*Label 848*/ 37376, // Rule ID 11956 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm))  =>  (EOR3:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11956,
        GIR_Done,
      // Label 848: @37376
      GIM_Try, /*On fail goto*//*Label 849*/ 37395, // Rule ID 1573 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (EORv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1573,
        GIR_Done,
      // Label 849: @37395
      GIM_Reject,
    // Label 841: @37396
    GIM_Reject,
    // Label 759: @37397
    GIM_Try, /*On fail goto*//*Label 850*/ 37452, // Rule ID 7384 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (xor:{ *:[nxv1i1] } nxv1i1:{ *:[nxv1i1] }:$Op1, nxv1i1:{ *:[nxv1i1] }:$Op2)  =>  (EOR_PPzPP:{ *:[nxv1i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7384,
      GIR_Done,
    // Label 850: @37452
    GIM_Reject,
    // Label 760: @37453
    GIM_Try, /*On fail goto*//*Label 851*/ 37508, // Rule ID 7383 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (xor:{ *:[nxv2i1] } nxv2i1:{ *:[nxv2i1] }:$Op1, nxv2i1:{ *:[nxv2i1] }:$Op2)  =>  (EOR_PPzPP:{ *:[nxv2i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7383,
      GIR_Done,
    // Label 851: @37508
    GIM_Reject,
    // Label 761: @37509
    GIM_Try, /*On fail goto*//*Label 852*/ 37532, // Rule ID 6427 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (xor:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (EOR_ZZZ:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EOR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6427,
      GIR_Done,
    // Label 852: @37532
    GIM_Reject,
    // Label 762: @37533
    GIM_Try, /*On fail goto*//*Label 853*/ 37588, // Rule ID 7382 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (xor:{ *:[nxv4i1] } nxv4i1:{ *:[nxv4i1] }:$Op1, nxv4i1:{ *:[nxv4i1] }:$Op2)  =>  (EOR_PPzPP:{ *:[nxv4i1] } (PTRUE_S:{ *:[nxv1i1] } 31:{ *:[i32] }), ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_S,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7382,
      GIR_Done,
    // Label 853: @37588
    GIM_Reject,
    // Label 763: @37589
    GIM_Try, /*On fail goto*//*Label 854*/ 37612, // Rule ID 6426 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (xor:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (EOR_ZZZ:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EOR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6426,
      GIR_Done,
    // Label 854: @37612
    GIM_Reject,
    // Label 764: @37613
    GIM_Try, /*On fail goto*//*Label 855*/ 37668, // Rule ID 7381 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (xor:{ *:[nxv8i1] } nxv8i1:{ *:[nxv8i1] }:$Op1, nxv8i1:{ *:[nxv8i1] }:$Op2)  =>  (EOR_PPzPP:{ *:[nxv8i1] } (PTRUE_H:{ *:[nxv1i1] } 31:{ *:[i32] }), ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7381,
      GIR_Done,
    // Label 855: @37668
    GIM_Reject,
    // Label 765: @37669
    GIM_Try, /*On fail goto*//*Label 856*/ 37692, // Rule ID 6425 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (xor:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (EOR_ZZZ:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EOR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6425,
      GIR_Done,
    // Label 856: @37692
    GIM_Reject,
    // Label 766: @37693
    GIM_Try, /*On fail goto*//*Label 857*/ 37748, // Rule ID 7380 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      // (xor:{ *:[nxv16i1] } nxv16i1:{ *:[nxv16i1] }:$Op1, nxv16i1:{ *:[nxv16i1] }:$Op2)  =>  (EOR_PPzPP:{ *:[nxv16i1] } (PTRUE_B:{ *:[nxv1i1] } 31:{ *:[i32] }), ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Op1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Op2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 7380,
      GIR_Done,
    // Label 857: @37748
    GIM_Reject,
    // Label 767: @37749
    GIM_Try, /*On fail goto*//*Label 858*/ 37772, // Rule ID 6424 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      // (xor:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (EOR_ZZZ:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EOR_ZZZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 6424,
      GIR_Done,
    // Label 858: @37772
    GIM_Reject,
    // Label 768: @37773
    GIM_Reject,
    // Label 8: @37774
    GIM_Try, /*On fail goto*//*Label 859*/ 46460,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/6, 23, /*)*//*default:*//*Label 871*/ 46459,
      /*GILLT_v2s64*//*Label 860*/ 37802, 0,
      /*GILLT_v4s32*//*Label 861*/ 38178, 0,
      /*GILLT_v8s16*//*Label 862*/ 41186,
      /*GILLT_v16s8*//*Label 863*/ 43942, 0,
      /*GILLT_nxv2s1*//*Label 864*/ 46263, 0, 0, 0,
      /*GILLT_nxv4s1*//*Label 865*/ 46287,
      /*GILLT_nxv4s16*//*Label 866*/ 46311,
      /*GILLT_nxv4s32*//*Label 867*/ 46349,
      /*GILLT_nxv8s1*//*Label 868*/ 46373,
      /*GILLT_nxv8s16*//*Label 869*/ 46397,
      /*GILLT_nxv16s1*//*Label 870*/ 46435,
      // Label 860: @37802
      GIM_Try, /*On fail goto*//*Label 872*/ 38177,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 873*/ 37876, // Rule ID 4900 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rn, (undef:{ *:[v1i64] }))  =>  (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::FPR64RegClassID,
          // GIR_Coverage, 4900,
          GIR_Done,
        // Label 873: @37876
        GIM_Try, /*On fail goto*//*Label 874*/ 37932, // Rule ID 4901 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rn, (undef:{ *:[v1f64] }))  =>  (INSERT_SUBREG:{ *:[v2f64] } (IMPLICIT_DEF:{ *:[v2f64] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::FPR64RegClassID,
          // GIR_Coverage, 4901,
          GIR_Done,
        // Label 874: @37932
        GIM_Try, /*On fail goto*//*Label 875*/ 38054, // Rule ID 4892 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v1i64] }:$Rn)  =>  (INSvi64lane:{ *:[v2i64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4892,
          GIR_Done,
        // Label 875: @38054
        GIM_Try, /*On fail goto*//*Label 876*/ 38176, // Rule ID 4893 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rd, V64:{ *:[v1f64] }:$Rn)  =>  (INSvi64lane:{ *:[v2f64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4893,
          GIR_Done,
        // Label 876: @38176
        GIM_Reject,
      // Label 872: @38177
      GIM_Reject,
      // Label 861: @38178
      GIM_Try, /*On fail goto*//*Label 877*/ 41185,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_Try, /*On fail goto*//*Label 878*/ 38350, // Rule ID 12135 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, AArch64::G_DUP,
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckConstantInt, /*MI*/4, /*Op*/1, 2147483648,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          GIM_CheckIsSafeToFold, /*InsnID*/4,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Vd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } (AArch64dup:{ *:[v2i64] } 2147483648:{ *:[i64] }), V128:{ *:[v2i64] }:$Vn), 32:{ *:[i32] })))  =>  (RADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Vd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Vn, (MOVIv2d_ns:{ *:[v2i64] } 0:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/AArch64::MOVIv2d_ns,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/3, /*Imm*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // Vn
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 12135,
          GIR_Done,
        // Label 878: @38350
        GIM_Try, /*On fail goto*//*Label 879*/ 38508, // Rule ID 5334 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, AArch64::G_DUP,
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckConstantInt, /*MI*/4, /*Op*/1, 2147483648,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          GIM_CheckIsSafeToFold, /*InsnID*/4,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Vd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (AArch64dup:{ *:[v2i64] } 2147483648:{ *:[i64] })), 32:{ *:[i32] })))  =>  (RADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Vd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Vn, (MOVIv2d_ns:{ *:[v2i64] } 0:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/AArch64::MOVIv2d_ns,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/3, /*Imm*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Vn
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 5334,
          GIR_Done,
        // Label 879: @38508
        GIM_Try, /*On fail goto*//*Label 880*/ 38621, // Rule ID 4637 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm), 32:{ *:[i32] })))  =>  (ADDHNv2i64_v4i32:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[f128] } 0:{ *:[i32] }, V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/1, /*Imm*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4637,
          GIR_Done,
        // Label 880: @38621
        GIM_Try, /*On fail goto*//*Label 881*/ 38734, // Rule ID 4643 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm), 32:{ *:[i32] })))  =>  (SUBHNv2i64_v4i32:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[f128] } 0:{ *:[i32] }, V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
          GIR_AddT