#ifdef GET_AT_DECL
enum ATValues {
  S1E1R = 960,
  S1E2R = 9152,
  S1E3R = 13248,
  S1E1W = 961,
  S1E2W = 9153,
  S1E3W = 13249,
  S1E0R = 962,
  S1E0W = 963,
  S12E1R = 9156,
  S12E1W = 9157,
  S12E0R = 9158,
  S12E0W = 9159,
  S1E1RP = 968,
  S1E1WP = 969,
  S1E1A = 970,
  S1E2A = 9162,
  S1E3A = 13258,
};
#endif

#ifdef GET_BTI_DECL
enum BTIValues {
  c = 2,
  j = 4,
  jc = 6,
};
#endif

#ifdef GET_DB_DECL
enum DBValues {
  oshld = 1,
  oshst = 2,
  osh = 3,
  nshld = 5,
  nshst = 6,
  nsh = 7,
  ishld = 9,
  ishst = 10,
  ish = 11,
  ld = 13,
  st = 14,
  sy = 15,
};
#endif

#ifdef GET_DBNXS_DECL
enum DBnXSValues {
  oshnxs = 3,
  nshnxs = 7,
  ishnxs = 11,
  synxs = 15,
};
#endif

#ifdef GET_DC_DECL
enum DCValues {
  ZVA = 7073,
  IVAC = 945,
  ISW = 946,
  CVAC = 7121,
  CSW = 978,
  CVAU = 7129,
  CIVAC = 7153,
  CISW = 1010,
  CVAP = 7137,
  CVADP = 7145,
  IGVAC = 947,
  IGSW = 948,
  CGSW = 980,
  CIGSW = 1012,
  CGVAC = 7123,
  CGVAP = 7139,
  CGVADP = 7147,
  CIGVAC = 7155,
  GVA = 7075,
  IGDVAC = 949,
  IGDSW = 950,
  CGDSW = 982,
  CIGDSW = 1014,
  CGDVAC = 7125,
  CGDVAP = 7141,
  CGDVADP = 7149,
  CIGDVAC = 7157,
  GZVA = 7076,
  CIPAE = 9200,
  CIGDPAE = 9207,
};
#endif

#ifdef GET_EXACTFPIMM_DECL
enum ExactFPImmValues {
  zero = 0,
  half = 1,
  one = 2,
  two = 3,
};
#endif

#ifdef GET_IC_DECL
enum ICValues {
  IALLUIS = 904,
  IALLU = 936,
  IVAU = 7081,
};
#endif

#ifdef GET_ISB_DECL
enum ISBValues {
  sy = 15,
};
#endif

#ifdef GET_PRFM_DECL
enum PRFMValues {
  pldl1keep = 0,
  pldl1strm = 1,
  pldl2keep = 2,
  pldl2strm = 3,
  pldl3keep = 4,
  pldl3strm = 5,
  pldslckeep = 6,
  pldslcstrm = 7,
  plil1keep = 8,
  plil1strm = 9,
  plil2keep = 10,
  plil2strm = 11,
  plil3keep = 12,
  plil3strm = 13,
  plislckeep = 14,
  plislcstrm = 15,
  pstl1keep = 16,
  pstl1strm = 17,
  pstl2keep = 18,
  pstl2strm = 19,
  pstl3keep = 20,
  pstl3strm = 21,
  pstslckeep = 22,
  pstslcstrm = 23,
};
#endif

#ifdef GET_PSB_DECL
enum PSBValues {
  csync = 17,
};
#endif

#ifdef GET_PSTATEIMM0_1_DECL
enum PStateImm0_1Values {
  ALLINT = 8,
  PM = 72,
};
#endif

#ifdef GET_PSTATEIMM0_15_DECL
enum PStateImm0_15Values {
  SPSel = 5,
  DAIFSet = 30,
  DAIFClr = 31,
  PAN = 4,
  UAO = 3,
  DIT = 26,
  SSBS = 25,
  TCO = 28,
};
#endif

#ifdef GET_RPRFM_DECL
enum RPRFMValues {
  pldkeep = 0,
  pstkeep = 1,
  pldstrm = 4,
  pststrm = 5,
};
#endif

#ifdef GET_SVCR_DECL
enum SVCRValues {
  SVCRSM = 1,
  SVCRZA = 2,
  SVCRSMZA = 3,
};
#endif

#ifdef GET_SVEPREDPAT_DECL
enum SVEPREDPATValues {
  pow2 = 0,
  vl1 = 1,
  vl2 = 2,
  vl3 = 3,
  vl4 = 4,
  vl5 = 5,
  vl6 = 6,
  vl7 = 7,
  vl8 = 8,
  vl16 = 9,
  vl32 = 10,
  vl64 = 11,
  vl128 = 12,
  vl256 = 13,
  mul4 = 29,
  mul3 = 30,
  all = 31,
};
#endif

#ifdef GET_SVEPRFM_DECL
enum SVEPRFMValues {
  pldl1keep = 0,
  pldl1strm = 1,
  pldl2keep = 2,
  pldl2strm = 3,
  pldl3keep = 4,
  pldl3strm = 5,
  pstl1keep = 8,
  pstl1strm = 9,
  pstl2keep = 10,
  pstl2strm = 11,
  pstl3keep = 12,
  pstl3strm = 13,
};
#endif

#ifdef GET_SVEVECLENSPECIFIER_DECL
enum SVEVECLENSPECIFIERValues {
  vlx2 = 0,
  vlx4 = 1,
};
#endif

#ifdef GET_SYSREG_DECL
enum SysRegValues {
  MDCCSR_EL0 = 38920,
  DBGDTRRX_EL0 = 38952,
  MDRAR_EL1 = 32896,
  OSLSR_EL1 = 32908,
  DBGAUTHSTATUS_EL1 = 33782,
  PMCEID0_EL0 = 56550,
  PMCEID1_EL0 = 56551,
  PMMIR_EL1 = 50422,
  MIDR_EL1 = 49152,
  CCSIDR_EL1 = 51200,
  CCSIDR2_EL1 = 51202,
  CLIDR_EL1 = 51201,
  CTR_EL0 = 55297,
  MPIDR_EL1 = 49157,
  REVIDR_EL1 = 49158,
  AIDR_EL1 = 51207,
  DCZID_EL0 = 55303,
  ID_PFR0_EL1 = 49160,
  ID_PFR1_EL1 = 49161,
  ID_PFR2_EL1 = 49180,
  ID_DFR0_EL1 = 49162,
  ID_DFR1_EL1 = 49181,
  ID_AFR0_EL1 = 49163,
  ID_MMFR0_EL1 = 49164,
  ID_MMFR1_EL1 = 49165,
  ID_MMFR2_EL1 = 49166,
  ID_MMFR3_EL1 = 49167,
  ID_ISAR0_EL1 = 49168,
  ID_ISAR1_EL1 = 49169,
  ID_ISAR2_EL1 = 49170,
  ID_ISAR3_EL1 = 49171,
  ID_ISAR4_EL1 = 49172,
  ID_ISAR5_EL1 = 49173,
  ID_ISAR6_EL1 = 49175,
  ID_AA64PFR0_EL1 = 49184,
  ID_AA64PFR1_EL1 = 49185,
  ID_AA64PFR2_EL1 = 49186,
  ID_AA64DFR0_EL1 = 49192,
  ID_AA64DFR1_EL1 = 49193,
  ID_AA64AFR0_EL1 = 49196,
  ID_AA64AFR1_EL1 = 49197,
  ID_AA64ISAR0_EL1 = 49200,
  ID_AA64ISAR1_EL1 = 49201,
  ID_AA64ISAR2_EL1 = 49202,
  ID_AA64MMFR0_EL1 = 49208,
  ID_AA64MMFR1_EL1 = 49209,
  ID_AA64MMFR2_EL1 = 49210,
  ID_AA64MMFR3_EL1 = 49211,
  ID_AA64MMFR4_EL1 = 49212,
  MVFR0_EL1 = 49176,
  MVFR1_EL1 = 49177,
  MVFR2_EL1 = 49178,
  RVBAR_EL1 = 50689,
  RVBAR_EL2 = 58881,
  RVBAR_EL3 = 62977,
  ISR_EL1 = 50696,
  CNTPCT_EL0 = 57089,
  CNTVCT_EL0 = 57090,
  ID_MMFR4_EL1 = 49174,
  ID_MMFR5_EL1 = 49182,
  TRCSTATR = 34840,
  TRCIDR8 = 34822,
  TRCIDR9 = 34830,
  TRCIDR10 = 34838,
  TRCIDR11 = 34846,
  TRCIDR12 = 34854,
  TRCIDR13 = 34862,
  TRCIDR0 = 34887,
  TRCIDR1 = 34895,
  TRCIDR2 = 34903,
  TRCIDR3 = 34911,
  TRCIDR4 = 34919,
  TRCIDR5 = 34927,
  TRCIDR6 = 34935,
  TRCIDR7 = 34943,
  TRCOSLSR = 34956,
  TRCPDSR = 34988,
  TRCDEVAFF0 = 35798,
  TRCDEVAFF1 = 35806,
  TRCLSR = 35822,
  TRCAUTHSTATUS = 35830,
  TRCDEVARCH = 35838,
  TRCDEVID = 35735,
  TRCDEVTYPE = 35743,
  TRCPIDR4 = 35751,
  TRCPIDR5 = 35759,
  TRCPIDR6 = 35767,
  TRCPIDR7 = 35775,
  TRCPIDR0 = 35783,
  TRCPIDR1 = 35791,
  TRCPIDR2 = 35799,
  TRCPIDR3 = 35807,
  TRCCIDR0 = 35815,
  TRCCIDR1 = 35823,
  TRCCIDR2 = 35831,
  TRCCIDR3 = 35839,
  ICC_IAR1_EL1 = 50784,
  ICC_IAR0_EL1 = 50752,
  ICC_HPPIR1_EL1 = 50786,
  ICC_HPPIR0_EL1 = 50754,
  ICC_RPR_EL1 = 50779,
  ICH_VTR_EL2 = 58969,
  ICH_EISR_EL2 = 58971,
  ICH_ELRSR_EL2 = 58973,
  ID_AA64ZFR0_EL1 = 49188,
  LORID_EL1 = 50471,
  ERRIDR_EL1 = 49816,
  ERXFR_EL1 = 49824,
  RNDR = 55584,
  RNDRRS = 55585,
  SCXTNUM_EL0 = 56967,
  SCXTNUM_EL1 = 50823,
  SCXTNUM_EL2 = 59015,
  SCXTNUM_EL3 = 63111,
  SCXTNUM_EL12 = 61063,
  GPCCR_EL3 = 61710,
  GPTBR_EL3 = 61708,
  MFAR_EL3 = 62213,
  MECIDR_EL2 = 58695,
  MECID_P0_EL2 = 58688,
  MECID_A0_EL2 = 58689,
  MECID_P1_EL2 = 58690,
  MECID_A1_EL2 = 58691,
  VMECID_P_EL2 = 58696,
  VMECID_A_EL2 = 58697,
  MECID_RL_A_EL3 = 62801,
  ID_AA64SMFR0_EL1 = 49189,
  DBGDTRTX_EL0 = 38952,
  OSLAR_EL1 = 32900,
  PMSWINC_EL0 = 56548,
  TRCOSLAR = 34948,
  TRCLAR = 35814,
  ICC_EOIR1_EL1 = 50785,
  ICC_EOIR0_EL1 = 50753,
  ICC_DIR_EL1 = 50777,
  ICC_SGI1R_EL1 = 50781,
  ICC_ASGI1R_EL1 = 50782,
  ICC_SGI0R_EL1 = 50783,
  OSDTRRX_EL1 = 32770,
  OSDTRTX_EL1 = 32794,
  TEECR32_EL1 = 36864,
  MDCCINT_EL1 = 32784,
  MDSCR_EL1 = 32786,
  DBGDTR_EL0 = 38944,
  OSECCR_EL1 = 32818,
  DBGVCR32_EL2 = 41016,
  DBGBVR0_EL1 = 32772,
  DBGBCR0_EL1 = 32773,
  DBGWVR0_EL1 = 32774,
  DBGWCR0_EL1 = 32775,
  DBGBVR1_EL1 = 32780,
  DBGBCR1_EL1 = 32781,
  DBGWVR1_EL1 = 32782,
  DBGWCR1_EL1 = 32783,
  DBGBVR2_EL1 = 32788,
  DBGBCR2_EL1 = 32789,
  DBGWVR2_EL1 = 32790,
  DBGWCR2_EL1 = 32791,
  DBGBVR3_EL1 = 32796,
  DBGBCR3_EL1 = 32797,
  DBGWVR3_EL1 = 32798,
  DBGWCR3_EL1 = 32799,
  DBGBVR4_EL1 = 32804,
  DBGBCR4_EL1 = 32805,
  DBGWVR4_EL1 = 32806,
  DBGWCR4_EL1 = 32807,
  DBGBVR5_EL1 = 32812,
  DBGBCR5_EL1 = 32813,
  DBGWVR5_EL1 = 32814,
  DBGWCR5_EL1 = 32815,
  DBGBVR6_EL1 = 32820,
  DBGBCR6_EL1 = 32821,
  DBGWVR6_EL1 = 32822,
  DBGWCR6_EL1 = 32823,
  DBGBVR7_EL1 = 32828,
  DBGBCR7_EL1 = 32829,
  DBGWVR7_EL1 = 32830,
  DBGWCR7_EL1 = 32831,
  DBGBVR8_EL1 = 32836,
  DBGBCR8_EL1 = 32837,
  DBGWVR8_EL1 = 32838,
  DBGWCR8_EL1 = 32839,
  DBGBVR9_EL1 = 32844,
  DBGBCR9_EL1 = 32845,
  DBGWVR9_EL1 = 32846,
  DBGWCR9_EL1 = 32847,
  DBGBVR10_EL1 = 32852,
  DBGBCR10_EL1 = 32853,
  DBGWVR10_EL1 = 32854,
  DBGWCR10_EL1 = 32855,
  DBGBVR11_EL1 = 32860,
  DBGBCR11_EL1 = 32861,
  DBGWVR11_EL1 = 32862,
  DBGWCR11_EL1 = 32863,
  DBGBVR12_EL1 = 32868,
  DBGBCR12_EL1 = 32869,
  DBGWVR12_EL1 = 32870,
  DBGWCR12_EL1 = 32871,
  DBGBVR13_EL1 = 32876,
  DBGBCR13_EL1 = 32877,
  DBGWVR13_EL1 = 32878,
  DBGWCR13_EL1 = 32879,
  DBGBVR14_EL1 = 32884,
  DBGBCR14_EL1 = 32885,
  DBGWVR14_EL1 = 32886,
  DBGWCR14_EL1 = 32887,
  DBGBVR15_EL1 = 32892,
  DBGBCR15_EL1 = 32893,
  DBGWVR15_EL1 = 32894,
  DBGWCR15_EL1 = 32895,
  TEEHBR32_EL1 = 36992,
  OSDLR_EL1 = 32924,
  DBGPRCR_EL1 = 32932,
  DBGCLAIMSET_EL1 = 33734,
  DBGCLAIMCLR_EL1 = 33742,
  CSSELR_EL1 = 53248,
  VPIDR_EL2 = 57344,
  VMPIDR_EL2 = 57349,
  CPACR_EL1 = 49282,
  SCTLR_EL1 = 49280,
  SCTLR_EL2 = 57472,
  SCTLR_EL3 = 61568,
  ACTLR_EL1 = 49281,
  ACTLR_EL2 = 57473,
  ACTLR_EL3 = 61569,
  HCR_EL2 = 57480,
  HCRX_EL2 = 57490,
  SCR_EL3 = 61576,
  MDCR_EL2 = 57481,
  SDER32_EL3 = 61577,
  CPTR_EL2 = 57482,
  CPTR_EL3 = 61578,
  HSTR_EL2 = 57483,
  HACR_EL2 = 57487,
  MDCR_EL3 = 61593,
  TTBR0_EL1 = 49408,
  TTBR0_EL3 = 61696,
  TTBR0_EL2 = 57600,
  VTTBR_EL2 = 57608,
  TTBR1_EL1 = 49409,
  TCR_EL1 = 49410,
  TCR_EL2 = 57602,
  TCR_EL3 = 61698,
  VTCR_EL2 = 57610,
  DACR32_EL2 = 57728,
  SPSR_EL1 = 49664,
  SPSR_EL2 = 57856,
  SPSR_EL3 = 61952,
  ELR_EL1 = 49665,
  ELR_EL2 = 57857,
  ELR_EL3 = 61953,
  SP_EL0 = 49672,
  SP_EL1 = 57864,
  SP_EL2 = 61960,
  SPSel = 49680,
  NZCV = 55824,
  DAIF = 55825,
  CurrentEL = 49682,
  SPSR_irq = 57880,
  SPSR_abt = 57881,
  SPSR_und = 57882,
  SPSR_fiq = 57883,
  FPCR = 55840,
  FPSR = 55841,
  DSPSR_EL0 = 55848,
  DLR_EL0 = 55849,
  IFSR32_EL2 = 57985,
  AFSR0_EL1 = 49800,
  AFSR0_EL2 = 57992,
  AFSR0_EL3 = 62088,
  AFSR1_EL1 = 49801,
  AFSR1_EL2 = 57993,
  AFSR1_EL3 = 62089,
  ESR_EL1 = 49808,
  ESR_EL2 = 58000,
  ESR_EL3 = 62096,
  FPEXC32_EL2 = 58008,
  FAR_EL1 = 49920,
  FAR_EL2 = 58112,
  FAR_EL3 = 62208,
  HPFAR_EL2 = 58116,
  PAR_EL1 = 50080,
  PMCR_EL0 = 56544,
  PMCNTENSET_EL0 = 56545,
  PMCNTENCLR_EL0 = 56546,
  PMOVSCLR_EL0 = 56547,
  PMSELR_EL0 = 56549,
  PMCCNTR_EL0 = 56552,
  PMXEVTYPER_EL0 = 56553,
  PMXEVCNTR_EL0 = 56554,
  PMUSERENR_EL0 = 56560,
  PMINTENSET_EL1 = 50417,
  PMINTENCLR_EL1 = 50418,
  PMOVSSET_EL0 = 56563,
  MAIR_EL1 = 50448,
  MAIR_EL2 = 58640,
  MAIR_EL3 = 62736,
  AMAIR_EL1 = 50456,
  AMAIR_EL2 = 58648,
  AMAIR_EL3 = 62744,
  VBAR_EL1 = 50688,
  VBAR_EL2 = 58880,
  VBAR_EL3 = 62976,
  RMR_EL1 = 50690,
  RMR_EL2 = 58882,
  RMR_EL3 = 62978,
  CONTEXTIDR_EL1 = 50817,
  TPIDR_EL0 = 56962,
  TPIDR_EL2 = 59010,
  TPIDR_EL3 = 63106,
  TPIDRRO_EL0 = 56963,
  TPIDR_EL1 = 50820,
  CNTFRQ_EL0 = 57088,
  CNTVOFF_EL2 = 59139,
  CNTKCTL_EL1 = 50952,
  CNTHCTL_EL2 = 59144,
  CNTP_TVAL_EL0 = 57104,
  CNTHP_TVAL_EL2 = 59152,
  CNTPS_TVAL_EL1 = 65296,
  CNTP_CTL_EL0 = 57105,
  CNTHP_CTL_EL2 = 59153,
  CNTPS_CTL_EL1 = 65297,
  CNTP_CVAL_EL0 = 57106,
  CNTHP_CVAL_EL2 = 59154,
  CNTPS_CVAL_EL1 = 65298,
  CNTV_TVAL_EL0 = 57112,
  CNTV_CTL_EL0 = 57113,
  CNTV_CVAL_EL0 = 57114,
  PMEVCNTR0_EL0 = 57152,
  PMEVCNTR1_EL0 = 57153,
  PMEVCNTR2_EL0 = 57154,
  PMEVCNTR3_EL0 = 57155,
  PMEVCNTR4_EL0 = 57156,
  PMEVCNTR5_EL0 = 57157,
  PMEVCNTR6_EL0 = 57158,
  PMEVCNTR7_EL0 = 57159,
  PMEVCNTR8_EL0 = 57160,
  PMEVCNTR9_EL0 = 57161,
  PMEVCNTR10_EL0 = 57162,
  PMEVCNTR11_EL0 = 57163,
  PMEVCNTR12_EL0 = 57164,
  PMEVCNTR13_EL0 = 57165,
  PMEVCNTR14_EL0 = 57166,
  PMEVCNTR15_EL0 = 57167,
  PMEVCNTR16_EL0 = 57168,
  PMEVCNTR17_EL0 = 57169,
  PMEVCNTR18_EL0 = 57170,
  PMEVCNTR19_EL0 = 57171,
  PMEVCNTR20_EL0 = 57172,
  PMEVCNTR21_EL0 = 57173,
  PMEVCNTR22_EL0 = 57174,
  PMEVCNTR23_EL0 = 57175,
  PMEVCNTR24_EL0 = 57176,
  PMEVCNTR25_EL0 = 57177,
  PMEVCNTR26_EL0 = 57178,
  PMEVCNTR27_EL0 = 57179,
  PMEVCNTR28_EL0 = 57180,
  PMEVCNTR29_EL0 = 57181,
  PMEVCNTR30_EL0 = 57182,
  PMCCFILTR_EL0 = 57215,
  PMEVTYPER0_EL0 = 57184,
  PMEVTYPER1_EL0 = 57185,
  PMEVTYPER2_EL0 = 57186,
  PMEVTYPER3_EL0 = 57187,
  PMEVTYPER4_EL0 = 57188,
  PMEVTYPER5_EL0 = 57189,
  PMEVTYPER6_EL0 = 57190,
  PMEVTYPER7_EL0 = 57191,
  PMEVTYPER8_EL0 = 57192,
  PMEVTYPER9_EL0 = 57193,
  PMEVTYPER10_EL0 = 57194,
  PMEVTYPER11_EL0 = 57195,
  PMEVTYPER12_EL0 = 57196,
  PMEVTYPER13_EL0 = 57197,
  PMEVTYPER14_EL0 = 57198,
  PMEVTYPER15_EL0 = 57199,
  PMEVTYPER16_EL0 = 57200,
  PMEVTYPER17_EL0 = 57201,
  PMEVTYPER18_EL0 = 57202,
  PMEVTYPER19_EL0 = 57203,
  PMEVTYPER20_EL0 = 57204,
  PMEVTYPER21_EL0 = 57205,
  PMEVTYPER22_EL0 = 57206,
  PMEVTYPER23_EL0 = 57207,
  PMEVTYPER24_EL0 = 57208,
  PMEVTYPER25_EL0 = 57209,
  PMEVTYPER26_EL0 = 57210,
  PMEVTYPER27_EL0 = 57211,
  PMEVTYPER28_EL0 = 57212,
  PMEVTYPER29_EL0 = 57213,
  PMEVTYPER30_EL0 = 57214,
  TRCPRGCTLR = 34824,
  TRCPROCSELR = 34832,
  TRCCONFIGR = 34848,
  TRCAUXCTLR = 34864,
  TRCEVENTCTL0R = 34880,
  TRCEVENTCTL1R = 34888,
  TRCSTALLCTLR = 34904,
  TRCTSCTLR = 34912,
  TRCSYNCPR = 34920,
  TRCCCCTLR = 34928,
  TRCBBCTLR = 34936,
  TRCTRACEIDR = 34817,
  TRCQCTLR = 34825,
  TRCVICTLR = 34818,
  TRCVIIECTLR = 34826,
  TRCVISSCTLR = 34834,
  TRCVIPCSSCTLR = 34842,
  TRCVDCTLR = 34882,
  TRCVDSACCTLR = 34890,
  TRCVDARCCTLR = 34898,
  TRCSEQEVR0 = 34820,
  TRCSEQEVR1 = 34828,
  TRCSEQEVR2 = 34836,
  TRCSEQRSTEVR = 34868,
  TRCSEQSTR = 34876,
  TRCEXTINSELR = 34884,
  TRCCNTRLDVR0 = 34821,
  TRCCNTRLDVR1 = 34829,
  TRCCNTRLDVR2 = 34837,
  TRCCNTRLDVR3 = 34845,
  TRCCNTCTLR0 = 34853,
  TRCCNTCTLR1 = 34861,
  TRCCNTCTLR2 = 34869,
  TRCCNTCTLR3 = 34877,
  TRCCNTVR0 = 34885,
  TRCCNTVR1 = 34893,
  TRCCNTVR2 = 34901,
  TRCCNTVR3 = 34909,
  TRCIMSPEC0 = 34823,
  TRCIMSPEC1 = 34831,
  TRCIMSPEC2 = 34839,
  TRCIMSPEC3 = 34847,
  TRCIMSPEC4 = 34855,
  TRCIMSPEC5 = 34863,
  TRCIMSPEC6 = 34871,
  TRCIMSPEC7 = 34879,
  TRCRSCTLR2 = 34960,
  TRCRSCTLR3 = 34968,
  TRCRSCTLR4 = 34976,
  TRCRSCTLR5 = 34984,
  TRCRSCTLR6 = 34992,
  TRCRSCTLR7 = 35000,
  TRCRSCTLR8 = 35008,
  TRCRSCTLR9 = 35016,
  TRCRSCTLR10 = 35024,
  TRCRSCTLR11 = 35032,
  TRCRSCTLR12 = 35040,
  TRCRSCTLR13 = 35048,
  TRCRSCTLR14 = 35056,
  TRCRSCTLR15 = 35064,
  TRCRSCTLR16 = 34945,
  TRCRSCTLR17 = 34953,
  TRCRSCTLR18 = 34961,
  TRCRSCTLR19 = 34969,
  TRCRSCTLR20 = 34977,
  TRCRSCTLR21 = 34985,
  TRCRSCTLR22 = 34993,
  TRCRSCTLR23 = 35001,
  TRCRSCTLR24 = 35009,
  TRCRSCTLR25 = 35017,
  TRCRSCTLR26 = 35025,
  TRCRSCTLR27 = 35033,
  TRCRSCTLR28 = 35041,
  TRCRSCTLR29 = 35049,
  TRCRSCTLR30 = 35057,
  TRCRSCTLR31 = 35065,
  TRCSSCCR0 = 34946,
  TRCSSCCR1 = 34954,
  TRCSSCCR2 = 34962,
  TRCSSCCR3 = 34970,
  TRCSSCCR4 = 34978,
  TRCSSCCR5 = 34986,
  TRCSSCCR6 = 34994,
  TRCSSCCR7 = 35002,
  TRCSSCSR0 = 35010,
  TRCSSCSR1 = 35018,
  TRCSSCSR2 = 35026,
  TRCSSCSR3 = 35034,
  TRCSSCSR4 = 35042,
  TRCSSCSR5 = 35050,
  TRCSSCSR6 = 35058,
  TRCSSCSR7 = 35066,
  TRCSSPCICR0 = 34947,
  TRCSSPCICR1 = 34955,
  TRCSSPCICR2 = 34963,
  TRCSSPCICR3 = 34971,
  TRCSSPCICR4 = 34979,
  TRCSSPCICR5 = 34987,
  TRCSSPCICR6 = 34995,
  TRCSSPCICR7 = 35003,
  TRCPDCR = 34980,
  TRCACVR0 = 35072,
  TRCACVR1 = 35088,
  TRCACVR2 = 35104,
  TRCACVR3 = 35120,
  TRCACVR4 = 35136,
  TRCACVR5 = 35152,
  TRCACVR6 = 35168,
  TRCACVR7 = 35184,
  TRCACVR8 = 35073,
  TRCACVR9 = 35089,
  TRCACVR10 = 35105,
  TRCACVR11 = 35121,
  TRCACVR12 = 35137,
  TRCACVR13 = 35153,
  TRCACVR14 = 35169,
  TRCACVR15 = 35185,
  TRCACATR0 = 35074,
  TRCACATR1 = 35090,
  TRCACATR2 = 35106,
  TRCACATR3 = 35122,
  TRCACATR4 = 35138,
  TRCACATR5 = 35154,
  TRCACATR6 = 35170,
  TRCACATR7 = 35186,
  TRCACATR8 = 35075,
  TRCACATR9 = 35091,
  TRCACATR10 = 35107,
  TRCACATR11 = 35123,
  TRCACATR12 = 35139,
  TRCACATR13 = 35155,
  TRCACATR14 = 35171,
  TRCACATR15 = 35187,
  TRCDVCVR0 = 35076,
  TRCDVCVR1 = 35108,
  TRCDVCVR2 = 35140,
  TRCDVCVR3 = 35172,
  TRCDVCVR4 = 35077,
  TRCDVCVR5 = 35109,
  TRCDVCVR6 = 35141,
  TRCDVCVR7 = 35173,
  TRCDVCMR0 = 35078,
  TRCDVCMR1 = 35110,
  TRCDVCMR2 = 35142,
  TRCDVCMR3 = 35174,
  TRCDVCMR4 = 35079,
  TRCDVCMR5 = 35111,
  TRCDVCMR6 = 35143,
  TRCDVCMR7 = 35175,
  TRCCIDCVR0 = 35200,
  TRCCIDCVR1 = 35216,
  TRCCIDCVR2 = 35232,
  TRCCIDCVR3 = 35248,
  TRCCIDCVR4 = 35264,
  TRCCIDCVR5 = 35280,
  TRCCIDCVR6 = 35296,
  TRCCIDCVR7 = 35312,
  TRCVMIDCVR0 = 35201,
  TRCVMIDCVR1 = 35217,
  TRCVMIDCVR2 = 35233,
  TRCVMIDCVR3 = 35249,
  TRCVMIDCVR4 = 35265,
  TRCVMIDCVR5 = 35281,
  TRCVMIDCVR6 = 35297,
  TRCVMIDCVR7 = 35313,
  TRCCIDCCTLR0 = 35202,
  TRCCIDCCTLR1 = 35210,
  TRCVMIDCCTLR0 = 35218,
  TRCVMIDCCTLR1 = 35226,
  TRCITCTRL = 35716,
  TRCCLAIMSET = 35782,
  TRCCLAIMCLR = 35790,
  ICC_BPR1_EL1 = 50787,
  ICC_BPR0_EL1 = 50755,
  ICC_PMR_EL1 = 49712,
  ICC_CTLR_EL1 = 50788,
  ICC_CTLR_EL3 = 63076,
  ICC_SRE_EL1 = 50789,
  ICC_SRE_EL2 = 58957,
  ICC_SRE_EL3 = 63077,
  ICC_IGRPEN0_EL1 = 50790,
  ICC_IGRPEN1_EL1 = 50791,
  ICC_IGRPEN1_EL3 = 63079,
  ICC_AP0R0_EL1 = 50756,
  ICC_AP0R1_EL1 = 50757,
  ICC_AP0R2_EL1 = 50758,
  ICC_AP0R3_EL1 = 50759,
  ICC_AP1R0_EL1 = 50760,
  ICC_AP1R1_EL1 = 50761,
  ICC_AP1R2_EL1 = 50762,
  ICC_AP1R3_EL1 = 50763,
  ICH_AP0R0_EL2 = 58944,
  ICH_AP0R1_EL2 = 58945,
  ICH_AP0R2_EL2 = 58946,
  ICH_AP0R3_EL2 = 58947,
  ICH_AP1R0_EL2 = 58952,
  ICH_AP1R1_EL2 = 58953,
  ICH_AP1R2_EL2 = 58954,
  ICH_AP1R3_EL2 = 58955,
  ICH_HCR_EL2 = 58968,
  ICH_MISR_EL2 = 58970,
  ICH_VMCR_EL2 = 58975,
  ICH_LR0_EL2 = 58976,
  ICH_LR1_EL2 = 58977,
  ICH_LR2_EL2 = 58978,
  ICH_LR3_EL2 = 58979,
  ICH_LR4_EL2 = 58980,
  ICH_LR5_EL2 = 58981,
  ICH_LR6_EL2 = 58982,
  ICH_LR7_EL2 = 58983,
  ICH_LR8_EL2 = 58984,
  ICH_LR9_EL2 = 58985,
  ICH_LR10_EL2 = 58986,
  ICH_LR11_EL2 = 58987,
  ICH_LR12_EL2 = 58988,
  ICH_LR13_EL2 = 58989,
  ICH_LR14_EL2 = 58990,
  ICH_LR15_EL2 = 58991,
  VSCTLR_EL2 = 57600,
  MPUIR_EL1 = 49156,
  MPUIR_EL2 = 57348,
  PRENR_EL1 = 49929,
  PRENR_EL2 = 58121,
  PRSELR_EL1 = 49937,
  PRSELR_EL2 = 58129,
  PRBAR_EL1 = 49984,
  PRBAR_EL2 = 58176,
  PRLAR_EL1 = 49985,
  PRLAR_EL2 = 58177,
  PRBAR1_EL1 = 49988,
  PRLAR1_EL1 = 49989,
  PRBAR1_EL2 = 58180,
  PRLAR1_EL2 = 58181,
  PRBAR2_EL1 = 49992,
  PRLAR2_EL1 = 49993,
  PRBAR2_EL2 = 58184,
  PRLAR2_EL2 = 58185,
  PRBAR3_EL1 = 49996,
  PRLAR3_EL1 = 49997,
  PRBAR3_EL2 = 58188,
  PRLAR3_EL2 = 58189,
  PRBAR4_EL1 = 50000,
  PRLAR4_EL1 = 50001,
  PRBAR4_EL2 = 58192,
  PRLAR4_EL2 = 58193,
  PRBAR5_EL1 = 50004,
  PRLAR5_EL1 = 50005,
  PRBAR5_EL2 = 58196,
  PRLAR5_EL2 = 58197,
  PRBAR6_EL1 = 50008,
  PRLAR6_EL1 = 50009,
  PRBAR6_EL2 = 58200,
  PRLAR6_EL2 = 58201,
  PRBAR7_EL1 = 50012,
  PRLAR7_EL1 = 50013,
  PRBAR7_EL2 = 58204,
  PRLAR7_EL2 = 58205,
  PRBAR8_EL1 = 50016,
  PRLAR8_EL1 = 50017,
  PRBAR8_EL2 = 58208,
  PRLAR8_EL2 = 58209,
  PRBAR9_EL1 = 50020,
  PRLAR9_EL1 = 50021,
  PRBAR9_EL2 = 58212,
  PRLAR9_EL2 = 58213,
  PRBAR10_EL1 = 50024,
  PRLAR10_EL1 = 50025,
  PRBAR10_EL2 = 58216,
  PRLAR10_EL2 = 58217,
  PRBAR11_EL1 = 50028,
  PRLAR11_EL1 = 50029,
  PRBAR11_EL2 = 58220,
  PRLAR11_EL2 = 58221,
  PRBAR12_EL1 = 50032,
  PRLAR12_EL1 = 50033,
  PRBAR12_EL2 = 58224,
  PRLAR12_EL2 = 58225,
  PRBAR13_EL1 = 50036,
  PRLAR13_EL1 = 50037,
  PRBAR13_EL2 = 58228,
  PRLAR13_EL2 = 58229,
  PRBAR14_EL1 = 50040,
  PRLAR14_EL1 = 50041,
  PRBAR14_EL2 = 58232,
  PRLAR14_EL2 = 58233,
  PRBAR15_EL1 = 50044,
  PRLAR15_EL1 = 50045,
  PRBAR15_EL2 = 58236,
  PRLAR15_EL2 = 58237,
  PAN = 49683,
  LORSA_EL1 = 50464,
  LOREA_EL1 = 50465,
  LORN_EL1 = 50466,
  LORC_EL1 = 50467,
  TTBR1_EL2 = 57601,
  CNTHV_TVAL_EL2 = 59160,
  CNTHV_CVAL_EL2 = 59162,
  CNTHV_CTL_EL2 = 59161,
  SCTLR_EL12 = 59520,
  CPACR_EL12 = 59522,
  TTBR0_EL12 = 59648,
  TTBR1_EL12 = 59649,
  TCR_EL12 = 59650,
  AFSR0_EL12 = 60040,
  AFSR1_EL12 = 60041,
  ESR_EL12 = 60048,
  FAR_EL12 = 60160,
  MAIR_EL12 = 60688,
  AMAIR_EL12 = 60696,
  VBAR_EL12 = 60928,
  CONTEXTIDR_EL12 = 61057,
  CNTKCTL_EL12 = 61192,
  CNTP_TVAL_EL02 = 61200,
  CNTP_CTL_EL02 = 61201,
  CNTP_CVAL_EL02 = 61202,
  CNTV_TVAL_EL02 = 61208,
  CNTV_CTL_EL02 = 61209,
  CNTV_CVAL_EL02 = 61210,
  SPSR_EL12 = 59904,
  ELR_EL12 = 59905,
  CONTEXTIDR_EL2 = 59009,
  UAO = 49684,
  PMBLIMITR_EL1 = 50384,
  PMBPTR_EL1 = 50385,
  PMBSR_EL1 = 50387,
  PMBIDR_EL1 = 50391,
  PMSCR_EL2 = 58568,
  PMSCR_EL12 = 60616,
  PMSCR_EL1 = 50376,
  PMSICR_EL1 = 50378,
  PMSIRR_EL1 = 50379,
  PMSFCR_EL1 = 50380,
  PMSEVFR_EL1 = 50381,
  PMSLATFR_EL1 = 50382,
  PMSIDR_EL1 = 50383,
  ERRSELR_EL1 = 49817,
  ERXCTLR_EL1 = 49825,
  ERXSTATUS_EL1 = 49826,
  ERXADDR_EL1 = 49827,
  ERXMISC0_EL1 = 49832,
  ERXMISC1_EL1 = 49833,
  DISR_EL1 = 50697,
  VDISR_EL2 = 58889,
  VSESR_EL2 = 58003,
  APIAKeyLo_EL1 = 49416,
  APIAKeyHi_EL1 = 49417,
  APIBKeyLo_EL1 = 49418,
  APIBKeyHi_EL1 = 49419,
  APDAKeyLo_EL1 = 49424,
  APDAKeyHi_EL1 = 49425,
  APDBKeyLo_EL1 = 49426,
  APDBKeyHi_EL1 = 49427,
  APGAKeyLo_EL1 = 49432,
  APGAKeyHi_EL1 = 49433,
  VSTCR_EL2 = 57650,
  VSTTBR_EL2 = 57648,
  CNTHVS_TVAL_EL2 = 59168,
  CNTHVS_CVAL_EL2 = 59170,
  CNTHVS_CTL_EL2 = 59169,
  CNTHPS_TVAL_EL2 = 59176,
  CNTHPS_CVAL_EL2 = 59178,
  CNTHPS_CTL_EL2 = 59177,
  SDER32_EL2 = 57497,
  ERXPFGCTL_EL1 = 49829,
  ERXPFGCDN_EL1 = 49830,
  ERXMISC2_EL1 = 49834,
  ERXMISC3_EL1 = 49835,
  ERXPFGF_EL1 = 49828,
  MPAM0_EL1 = 50473,
  MPAM1_EL1 = 50472,
  MPAM2_EL2 = 58664,
  MPAM3_EL3 = 62760,
  MPAM1_EL12 = 60712,
  MPAMHCR_EL2 = 58656,
  MPAMVPMV_EL2 = 58657,
  MPAMVPM0_EL2 = 58672,
  MPAMVPM1_EL2 = 58673,
  MPAMVPM2_EL2 = 58674,
  MPAMVPM3_EL2 = 58675,
  MPAMVPM4_EL2 = 58676,
  MPAMVPM5_EL2 = 58677,
  MPAMVPM6_EL2 = 58678,
  MPAMVPM7_EL2 = 58679,
  MPAMIDR_EL1 = 50468,
  AMCR_EL0 = 56976,
  AMCFGR_EL0 = 56977,
  AMCGCR_EL0 = 56978,
  AMUSERENR_EL0 = 56979,
  AMCNTENCLR0_EL0 = 56980,
  AMCNTENSET0_EL0 = 56981,
  AMEVCNTR00_EL0 = 56992,
  AMEVCNTR01_EL0 = 56993,
  AMEVCNTR02_EL0 = 56994,
  AMEVCNTR03_EL0 = 56995,
  AMEVTYPER00_EL0 = 57008,
  AMEVTYPER01_EL0 = 57009,
  AMEVTYPER02_EL0 = 57010,
  AMEVTYPER03_EL0 = 57011,
  AMCNTENCLR1_EL0 = 56984,
  AMCNTENSET1_EL0 = 56985,
  AMEVCNTR10_EL0 = 57056,
  AMEVCNTR11_EL0 = 57057,
  AMEVCNTR12_EL0 = 57058,
  AMEVCNTR13_EL0 = 57059,
  AMEVCNTR14_EL0 = 57060,
  AMEVCNTR15_EL0 = 57061,
  AMEVCNTR16_EL0 = 57062,
  AMEVCNTR17_EL0 = 57063,
  AMEVCNTR18_EL0 = 57064,
  AMEVCNTR19_EL0 = 57065,
  AMEVCNTR110_EL0 = 57066,
  AMEVCNTR111_EL0 = 57067,
  AMEVCNTR112_EL0 = 57068,
  AMEVCNTR113_EL0 = 57069,
  AMEVCNTR114_EL0 = 57070,
  AMEVCNTR115_EL0 = 57071,
  AMEVTYPER10_EL0 = 57072,
  AMEVTYPER11_EL0 = 57073,
  AMEVTYPER12_EL0 = 57074,
  AMEVTYPER13_EL0 = 57075,
  AMEVTYPER14_EL0 = 57076,
  AMEVTYPER15_EL0 = 57077,
  AMEVTYPER16_EL0 = 57078,
  AMEVTYPER17_EL0 = 57079,
  AMEVTYPER18_EL0 = 57080,
  AMEVTYPER19_EL0 = 57081,
  AMEVTYPER110_EL0 = 57082,
  AMEVTYPER111_EL0 = 57083,
  AMEVTYPER112_EL0 = 57084,
  AMEVTYPER113_EL0 = 57085,
  AMEVTYPER114_EL0 = 57086,
  AMEVTYPER115_EL0 = 57087,
  TRFCR_EL1 = 49297,
  TRFCR_EL2 = 57489,
  TRFCR_EL12 = 59537,
  DIT = 55829,
  VNCR_EL2 = 57616,
  ZCR_EL1 = 49296,
  ZCR_EL2 = 57488,
  ZCR_EL3 = 61584,
  ZCR_EL12 = 59536,
  SSBS = 55830,
  TCO = 55831,
  GCR_EL1 = 49286,
  RGSR_EL1 = 49285,
  TFSR_EL1 = 49840,
  TFSR_EL2 = 58032,
  TFSR_EL3 = 62128,
  TFSR_EL12 = 60080,
  TFSRE0_EL1 = 49841,
  GMID_EL1 = 51204,
  TRCRSR = 34896,
  TRCEXTINSELR0 = 34884,
  TRCEXTINSELR1 = 34892,
  TRCEXTINSELR2 = 34900,
  TRCEXTINSELR3 = 34908,
  TRBLIMITR_EL1 = 50392,
  TRBPTR_EL1 = 50393,
  TRBBASER_EL1 = 50394,
  TRBSR_EL1 = 50395,
  TRBMAR_EL1 = 50396,
  TRBTRG_EL1 = 50398,
  TRBIDR_EL1 = 50399,
  AMCG1IDR_EL0 = 56982,
  AMEVCNTVOFF00_EL2 = 59072,
  AMEVCNTVOFF10_EL2 = 59088,
  AMEVCNTVOFF01_EL2 = 59073,
  AMEVCNTVOFF11_EL2 = 59089,
  AMEVCNTVOFF02_EL2 = 59074,
  AMEVCNTVOFF12_EL2 = 59090,
  AMEVCNTVOFF03_EL2 = 59075,
  AMEVCNTVOFF13_EL2 = 59091,
  AMEVCNTVOFF04_EL2 = 59076,
  AMEVCNTVOFF14_EL2 = 59092,
  AMEVCNTVOFF05_EL2 = 59077,
  AMEVCNTVOFF15_EL2 = 59093,
  AMEVCNTVOFF06_EL2 = 59078,
  AMEVCNTVOFF16_EL2 = 59094,
  AMEVCNTVOFF07_EL2 = 59079,
  AMEVCNTVOFF17_EL2 = 59095,
  AMEVCNTVOFF08_EL2 = 59080,
  AMEVCNTVOFF18_EL2 = 59096,
  AMEVCNTVOFF09_EL2 = 59081,
  AMEVCNTVOFF19_EL2 = 59097,
  AMEVCNTVOFF010_EL2 = 59082,
  AMEVCNTVOFF110_EL2 = 59098,
  AMEVCNTVOFF011_EL2 = 59083,
  AMEVCNTVOFF111_EL2 = 59099,
  AMEVCNTVOFF012_EL2 = 59084,
  AMEVCNTVOFF112_EL2 = 59100,
  AMEVCNTVOFF013_EL2 = 59085,
  AMEVCNTVOFF113_EL2 = 59101,
  AMEVCNTVOFF014_EL2 = 59086,
  AMEVCNTVOFF114_EL2 = 59102,
  AMEVCNTVOFF015_EL2 = 59087,
  AMEVCNTVOFF115_EL2 = 59103,
  HFGRTR_EL2 = 57484,
  HFGWTR_EL2 = 57485,
  HFGITR_EL2 = 57486,
  HDFGRTR_EL2 = 57740,
  HDFGWTR_EL2 = 57741,
  HAFGRTR_EL2 = 57742,
  HDFGRTR2_EL2 = 57736,
  HDFGWTR2_EL2 = 57737,
  HFGRTR2_EL2 = 57738,
  HFGWTR2_EL2 = 57739,
  HFGITR2_EL2 = 57743,
  CNTSCALE_EL2 = 59140,
  CNTISCALE_EL2 = 59141,
  CNTPOFF_EL2 = 59142,
  CNTVFRQ_EL2 = 59143,
  CNTPCTSS_EL0 = 57093,
  CNTVCTSS_EL0 = 57094,
  ACCDATA_EL1 = 50821,
  BRBCR_EL1 = 35968,
  BRBCR_EL12 = 44160,
  BRBCR_EL2 = 42112,
  BRBFCR_EL1 = 35969,
  BRBIDR0_EL1 = 35984,
  BRBINFINJ_EL1 = 35976,
  BRBSRCINJ_EL1 = 35977,
  BRBTGTINJ_EL1 = 35978,
  BRBTS_EL1 = 35970,
  BRBINF0_EL1 = 35840,
  BRBSRC0_EL1 = 35841,
  BRBTGT0_EL1 = 35842,
  BRBINF1_EL1 = 35848,
  BRBSRC1_EL1 = 35849,
  BRBTGT1_EL1 = 35850,
  BRBINF2_EL1 = 35856,
  BRBSRC2_EL1 = 35857,
  BRBTGT2_EL1 = 35858,
  BRBINF3_EL1 = 35864,
  BRBSRC3_EL1 = 35865,
  BRBTGT3_EL1 = 35866,
  BRBINF4_EL1 = 35872,
  BRBSRC4_EL1 = 35873,
  BRBTGT4_EL1 = 35874,
  BRBINF5_EL1 = 35880,
  BRBSRC5_EL1 = 35881,
  BRBTGT5_EL1 = 35882,
  BRBINF6_EL1 = 35888,
  BRBSRC6_EL1 = 35889,
  BRBTGT6_EL1 = 35890,
  BRBINF7_EL1 = 35896,
  BRBSRC7_EL1 = 35897,
  BRBTGT7_EL1 = 35898,
  BRBINF8_EL1 = 35904,
  BRBSRC8_EL1 = 35905,
  BRBTGT8_EL1 = 35906,
  BRBINF9_EL1 = 35912,
  BRBSRC9_EL1 = 35913,
  BRBTGT9_EL1 = 35914,
  BRBINF10_EL1 = 35920,
  BRBSRC10_EL1 = 35921,
  BRBTGT10_EL1 = 35922,
  BRBINF11_EL1 = 35928,
  BRBSRC11_EL1 = 35929,
  BRBTGT11_EL1 = 35930,
  BRBINF12_EL1 = 35936,
  BRBSRC12_EL1 = 35937,
  BRBTGT12_EL1 = 35938,
  BRBINF13_EL1 = 35944,
  BRBSRC13_EL1 = 35945,
  BRBTGT13_EL1 = 35946,
  BRBINF14_EL1 = 35952,
  BRBSRC14_EL1 = 35953,
  BRBTGT14_EL1 = 35954,
  BRBINF15_EL1 = 35960,
  BRBSRC15_EL1 = 35961,
  BRBTGT15_EL1 = 35962,
  BRBINF16_EL1 = 35844,
  BRBSRC16_EL1 = 35845,
  BRBTGT16_EL1 = 35846,
  BRBINF17_EL1 = 35852,
  BRBSRC17_EL1 = 35853,
  BRBTGT17_EL1 = 35854,
  BRBINF18_EL1 = 35860,
  BRBSRC18_EL1 = 35861,
  BRBTGT18_EL1 = 35862,
  BRBINF19_EL1 = 35868,
  BRBSRC19_EL1 = 35869,
  BRBTGT19_EL1 = 35870,
  BRBINF20_EL1 = 35876,
  BRBSRC20_EL1 = 35877,
  BRBTGT20_EL1 = 35878,
  BRBINF21_EL1 = 35884,
  BRBSRC21_EL1 = 35885,
  BRBTGT21_EL1 = 35886,
  BRBINF22_EL1 = 35892,
  BRBSRC22_EL1 = 35893,
  BRBTGT22_EL1 = 35894,
  BRBINF23_EL1 = 35900,
  BRBSRC23_EL1 = 35901,
  BRBTGT23_EL1 = 35902,
  BRBINF24_EL1 = 35908,
  BRBSRC24_EL1 = 35909,
  BRBTGT24_EL1 = 35910,
  BRBINF25_EL1 = 35916,
  BRBSRC25_EL1 = 35917,
  BRBTGT25_EL1 = 35918,
  BRBINF26_EL1 = 35924,
  BRBSRC26_EL1 = 35925,
  BRBTGT26_EL1 = 35926,
  BRBINF27_EL1 = 35932,
  BRBSRC27_EL1 = 35933,
  BRBTGT27_EL1 = 35934,
  BRBINF28_EL1 = 35940,
  BRBSRC28_EL1 = 35941,
  BRBTGT28_EL1 = 35942,
  BRBINF29_EL1 = 35948,
  BRBSRC29_EL1 = 35949,
  BRBTGT29_EL1 = 35950,
  BRBINF30_EL1 = 35956,
  BRBSRC30_EL1 = 35957,
  BRBTGT30_EL1 = 35958,
  BRBINF31_EL1 = 35964,
  BRBSRC31_EL1 = 35965,
  BRBTGT31_EL1 = 35966,
  PMSNEVFR_EL1 = 50377,
  CPM_IOACC_CTL_EL3 = 65424,
  SMCR_EL1 = 49302,
  SMCR_EL2 = 57494,
  SMCR_EL3 = 61590,
  SMCR_EL12 = 59542,
  SVCR = 55826,
  SMPRI_EL1 = 49300,
  SMPRIMAP_EL2 = 57493,
  SMIDR_EL1 = 51206,
  TPIDR2_EL0 = 56965,
  MPAMSM_EL1 = 50475,
  ALLINT = 49688,
  ICC_NMIAR1_EL1 = 50765,
  GCSCR_EL1 = 49448,
  GCSPR_EL1 = 49449,
  GCSCRE0_EL1 = 49450,
  GCSPR_EL0 = 55593,
  GCSCR_EL2 = 57640,
  GCSPR_EL2 = 57641,
  GCSCR_EL12 = 59688,
  GCSPR_EL12 = 59689,
  GCSCR_EL3 = 61736,
  GCSPR_EL3 = 61737,
  AMAIR2_EL1 = 50457,
  AMAIR2_EL12 = 60697,
  AMAIR2_EL2 = 58649,
  AMAIR2_EL3 = 62745,
  MAIR2_EL1 = 50449,
  MAIR2_EL12 = 60689,
  MAIR2_EL2 = 58633,
  MAIR2_EL3 = 62729,
  PIRE0_EL1 = 50450,
  PIRE0_EL12 = 60690,
  PIRE0_EL2 = 58642,
  PIR_EL1 = 50451,
  PIR_EL12 = 60691,
  PIR_EL2 = 58643,
  PIR_EL3 = 62739,
  S2PIR_EL2 = 58645,
  POR_EL0 = 56596,
  POR_EL1 = 50452,
  POR_EL12 = 60692,
  POR_EL2 = 58644,
  POR_EL3 = 62740,
  S2POR_EL1 = 50453,
  SCTLR2_EL1 = 49283,
  SCTLR2_EL12 = 59523,
  SCTLR2_EL2 = 57475,
  SCTLR2_EL3 = 61571,
  TCR2_EL1 = 49411,
  TCR2_EL12 = 59651,
  TCR2_EL2 = 57603,
  RCWMASK_EL1 = 50822,
  RCWSMASK_EL1 = 50819,
  MDSELR_EL1 = 32802,
  PMUACR_EL1 = 50420,
  PMCCNTSVR_EL1 = 34655,
  PMICNTSVR_EL1 = 34656,
  PMSSCR_EL1 = 50411,
  PMEVCNTSVR0_EL1 = 34624,
  PMEVCNTSVR1_EL1 = 34625,
  PMEVCNTSVR2_EL1 = 34626,
  PMEVCNTSVR3_EL1 = 34627,
  PMEVCNTSVR4_EL1 = 34628,
  PMEVCNTSVR5_EL1 = 34629,
  PMEVCNTSVR6_EL1 = 34630,
  PMEVCNTSVR7_EL1 = 34631,
  PMEVCNTSVR8_EL1 = 34632,
  PMEVCNTSVR9_EL1 = 34633,
  PMEVCNTSVR10_EL1 = 34634,
  PMEVCNTSVR11_EL1 = 34635,
  PMEVCNTSVR12_EL1 = 34636,
  PMEVCNTSVR13_EL1 = 34637,
  PMEVCNTSVR14_EL1 = 34638,
  PMEVCNTSVR15_EL1 = 34639,
  PMEVCNTSVR16_EL1 = 34640,
  PMEVCNTSVR17_EL1 = 34641,
  PMEVCNTSVR18_EL1 = 34642,
  PMEVCNTSVR19_EL1 = 34643,
  PMEVCNTSVR20_EL1 = 34644,
  PMEVCNTSVR21_EL1 = 34645,
  PMEVCNTSVR22_EL1 = 34646,
  PMEVCNTSVR23_EL1 = 34647,
  PMEVCNTSVR24_EL1 = 34648,
  PMEVCNTSVR25_EL1 = 34649,
  PMEVCNTSVR26_EL1 = 34650,
  PMEVCNTSVR27_EL1 = 34651,
  PMEVCNTSVR28_EL1 = 34652,
  PMEVCNTSVR29_EL1 = 34653,
  PMEVCNTSVR30_EL1 = 34654,
  PMICNTR_EL0 = 56480,
  PMICFILTR_EL0 = 56496,
  PMZR_EL0 = 56556,
  PMECR_EL1 = 50421,
  PMIAR_EL1 = 50423,
  SPMACCESSR_EL1 = 34027,
  SPMACCESSR_EL12 = 44267,
  SPMACCESSR_EL2 = 42219,
  SPMACCESSR_EL3 = 46315,
  SPMCNTENCLR_EL0 = 40162,
  SPMCNTENSET_EL0 = 40161,
  SPMCR_EL0 = 40160,
  SPMDEVAFF_EL1 = 34030,
  SPMDEVARCH_EL1 = 34029,
  SPMEVCNTR0_EL0 = 40704,
  SPMEVFILT2R0_EL0 = 40752,
  SPMEVFILTR0_EL0 = 40736,
  SPMEVTYPER0_EL0 = 40720,
  SPMEVCNTR1_EL0 = 40705,
  SPMEVFILT2R1_EL0 = 40753,
  SPMEVFILTR1_EL0 = 40737,
  SPMEVTYPER1_EL0 = 40721,
  SPMEVCNTR2_EL0 = 40706,
  SPMEVFILT2R2_EL0 = 40754,
  SPMEVFILTR2_EL0 = 40738,
  SPMEVTYPER2_EL0 = 40722,
  SPMEVCNTR3_EL0 = 40707,
  SPMEVFILT2R3_EL0 = 40755,
  SPMEVFILTR3_EL0 = 40739,
  SPMEVTYPER3_EL0 = 40723,
  SPMEVCNTR4_EL0 = 40708,
  SPMEVFILT2R4_EL0 = 40756,
  SPMEVFILTR4_EL0 = 40740,
  SPMEVTYPER4_EL0 = 40724,
  SPMEVCNTR5_EL0 = 40709,
  SPMEVFILT2R5_EL0 = 40757,
  SPMEVFILTR5_EL0 = 40741,
  SPMEVTYPER5_EL0 = 40725,
  SPMEVCNTR6_EL0 = 40710,
  SPMEVFILT2R6_EL0 = 40758,
  SPMEVFILTR6_EL0 = 40742,
  SPMEVTYPER6_EL0 = 40726,
  SPMEVCNTR7_EL0 = 40711,
  SPMEVFILT2R7_EL0 = 40759,
  SPMEVFILTR7_EL0 = 40743,
  SPMEVTYPER7_EL0 = 40727,
  SPMEVCNTR8_EL0 = 40712,
  SPMEVFILT2R8_EL0 = 40760,
  SPMEVFILTR8_EL0 = 40744,
  SPMEVTYPER8_EL0 = 40728,
  SPMEVCNTR9_EL0 = 40713,
  SPMEVFILT2R9_EL0 = 40761,
  SPMEVFILTR9_EL0 = 40745,
  SPMEVTYPER9_EL0 = 40729,
  SPMEVCNTR10_EL0 = 40714,
  SPMEVFILT2R10_EL0 = 40762,
  SPMEVFILTR10_EL0 = 40746,
  SPMEVTYPER10_EL0 = 40730,
  SPMEVCNTR11_EL0 = 40715,
  SPMEVFILT2R11_EL0 = 40763,
  SPMEVFILTR11_EL0 = 40747,
  SPMEVTYPER11_EL0 = 40731,
  SPMEVCNTR12_EL0 = 40716,
  SPMEVFILT2R12_EL0 = 40764,
  SPMEVFILTR12_EL0 = 40748,
  SPMEVTYPER12_EL0 = 40732,
  SPMEVCNTR13_EL0 = 40717,
  SPMEVFILT2R13_EL0 = 40765,
  SPMEVFILTR13_EL0 = 40749,
  SPMEVTYPER13_EL0 = 40733,
  SPMEVCNTR14_EL0 = 40718,
  SPMEVFILT2R14_EL0 = 40766,
  SPMEVFILTR14_EL0 = 40750,
  SPMEVTYPER14_EL0 = 40734,
  SPMEVCNTR15_EL0 = 40719,
  SPMEVFILT2R15_EL0 = 40767,
  SPMEVFILTR15_EL0 = 40751,
  SPMEVTYPER15_EL0 = 40735,
  SPMIIDR_EL1 = 34028,
  SPMINTENCLR_EL1 = 34034,
  SPMINTENSET_EL1 = 34033,
  SPMOVSCLR_EL0 = 40163,
  SPMOVSSET_EL0 = 40179,
  SPMSELR_EL0 = 40165,
  SPMCGCR0_EL1 = 34024,
  SPMCGCR1_EL1 = 34025,
  SPMCFGR_EL1 = 34031,
  SPMROOTCR_EL3 = 46327,
  SPMSCR_EL1 = 48375,
  TRCITEEDCR = 34833,
  TRCITECR_EL1 = 49299,
  TRCITECR_EL12 = 59539,
  TRCITECR_EL2 = 57491,
  PMSDSFR_EL1 = 50388,
  ERXGSR_EL1 = 49818,
  PFAR_EL1 = 49925,
  PFAR_EL12 = 60165,
  PFAR_EL2 = 58117,
  PM = 49689,
};
#endif

#ifdef GET_TSB_DECL
enum TSBValues {
  csync = 0,
};
#endif

#ifdef GET_TLBITable_DECL
const TLBI *lookupTLBIByEncoding(uint16_t Encoding);
const TLBI *lookupTLBIByName(StringRef Name);
#endif

#ifdef GET_TLBITable_IMPL
constexpr TLBI TLBITable[] = {
  { "ALLE1", 0x243C, false,  {  }  }, // 0
  { "ALLE1IS", 0x241C, false,  {  }  }, // 1
  { "ALLE1ISnXS", 0x249C, false,  { AArch64::FeatureXS }  }, // 2
  { "ALLE1nXS", 0x24BC, false,  { AArch64::FeatureXS }  }, // 3
  { "ALLE1OS", 0x240C, false,  { AArch64::FeatureTLB_RMI }  }, // 4
  { "ALLE1OSnXS", 0x248C, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 5
  { "ALLE2", 0x2438, false,  {  }  }, // 6
  { "ALLE2IS", 0x2418, false,  {  }  }, // 7
  { "ALLE2ISnXS", 0x2498, false,  { AArch64::FeatureXS }  }, // 8
  { "ALLE2nXS", 0x24B8, false,  { AArch64::FeatureXS }  }, // 9
  { "ALLE2OS", 0x2408, false,  { AArch64::FeatureTLB_RMI }  }, // 10
  { "ALLE2OSnXS", 0x2488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 11
  { "ALLE3", 0x3438, false,  {  }  }, // 12
  { "ALLE3IS", 0x3418, false,  {  }  }, // 13
  { "ALLE3ISnXS", 0x3498, false,  { AArch64::FeatureXS }  }, // 14
  { "ALLE3nXS", 0x34B8, false,  { AArch64::FeatureXS }  }, // 15
  { "ALLE3OS", 0x3408, false,  { AArch64::FeatureTLB_RMI }  }, // 16
  { "ALLE3OSnXS", 0x3488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 17
  { "ASIDE1", 0x43A, true,  {  }  }, // 18
  { "ASIDE1IS", 0x41A, true,  {  }  }, // 19
  { "ASIDE1ISnXS", 0x49A, true,  { AArch64::FeatureXS }  }, // 20
  { "ASIDE1nXS", 0x4BA, true,  { AArch64::FeatureXS }  }, // 21
  { "ASIDE1OS", 0x40A, true,  { AArch64::FeatureTLB_RMI }  }, // 22
  { "ASIDE1OSnXS", 0x48A, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 23
  { "IPAS2E1", 0x2421, true,  {  }  }, // 24
  { "IPAS2E1IS", 0x2401, true,  {  }  }, // 25
  { "IPAS2E1ISnXS", 0x2481, true,  { AArch64::FeatureXS }  }, // 26
  { "IPAS2E1nXS", 0x24A1, true,  { AArch64::FeatureXS }  }, // 27
  { "IPAS2E1OS", 0x2420, true,  { AArch64::FeatureTLB_RMI }  }, // 28
  { "IPAS2E1OSnXS", 0x24A0, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 29
  { "IPAS2LE1", 0x2425, true,  {  }  }, // 30
  { "IPAS2LE1IS", 0x2405, true,  {  }  }, // 31
  { "IPAS2LE1ISnXS", 0x2485, true,  { AArch64::FeatureXS }  }, // 32
  { "IPAS2LE1nXS", 0x24A5, true,  { AArch64::FeatureXS }  }, // 33
  { "IPAS2LE1OS", 0x2424, true,  { AArch64::FeatureTLB_RMI }  }, // 34
  { "IPAS2LE1OSnXS", 0x24A4, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 35
  { "PAALL", 0x343C, false,  { AArch64::FeatureRME }  }, // 36
  { "PAALLnXS", 0x34BC, false,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 37
  { "PAALLOS", 0x340C, false,  { AArch64::FeatureRME }  }, // 38
  { "PAALLOSnXS", 0x348C, false,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 39
  { "RIPAS2E1", 0x2422, true,  { AArch64::FeatureTLB_RMI }  }, // 40
  { "RIPAS2E1IS", 0x2402, true,  { AArch64::FeatureTLB_RMI }  }, // 41
  { "RIPAS2E1ISnXS", 0x2482, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 42
  { "RIPAS2E1nXS", 0x24A2, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 43
  { "RIPAS2E1OS", 0x2423, true,  { AArch64::FeatureTLB_RMI }  }, // 44
  { "RIPAS2E1OSnXS", 0x24A3, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 45
  { "RIPAS2LE1", 0x2426, true,  { AArch64::FeatureTLB_RMI }  }, // 46
  { "RIPAS2LE1IS", 0x2406, true,  { AArch64::FeatureTLB_RMI }  }, // 47
  { "RIPAS2LE1ISnXS", 0x2486, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 48
  { "RIPAS2LE1nXS", 0x24A6, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 49
  { "RIPAS2LE1OS", 0x2427, true,  { AArch64::FeatureTLB_RMI }  }, // 50
  { "RIPAS2LE1OSnXS", 0x24A7, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 51
  { "RPALOS", 0x3427, true,  { AArch64::FeatureRME }  }, // 52
  { "RPALOSnXS", 0x34A7, true,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 53
  { "RPAOS", 0x3423, true,  { AArch64::FeatureRME }  }, // 54
  { "RPAOSnXS", 0x34A3, true,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 55
  { "RVAAE1", 0x433, true,  { AArch64::FeatureTLB_RMI }  }, // 56
  { "RVAAE1IS", 0x413, true,  { AArch64::FeatureTLB_RMI }  }, // 57
  { "RVAAE1ISnXS", 0x493, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 58
  { "RVAAE1nXS", 0x4B3, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 59
  { "RVAAE1OS", 0x42B, true,  { AArch64::FeatureTLB_RMI }  }, // 60
  { "RVAAE1OSnXS", 0x4AB, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 61
  { "RVAALE1", 0x437, true,  { AArch64::FeatureTLB_RMI }  }, // 62
  { "RVAALE1IS", 0x417, true,  { AArch64::FeatureTLB_RMI }  }, // 63
  { "RVAALE1ISnXS", 0x497, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 64
  { "RVAALE1nXS", 0x4B7, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 65
  { "RVAALE1OS", 0x42F, true,  { AArch64::FeatureTLB_RMI }  }, // 66
  { "RVAALE1OSnXS", 0x4AF, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 67
  { "RVAE1", 0x431, true,  { AArch64::FeatureTLB_RMI }  }, // 68
  { "RVAE1IS", 0x411, true,  { AArch64::FeatureTLB_RMI }  }, // 69
  { "RVAE1ISnXS", 0x491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 70
  { "RVAE1nXS", 0x4B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 71
  { "RVAE1OS", 0x429, true,  { AArch64::FeatureTLB_RMI }  }, // 72
  { "RVAE1OSnXS", 0x4A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 73
  { "RVAE2", 0x2431, true,  { AArch64::FeatureTLB_RMI }  }, // 74
  { "RVAE2IS", 0x2411, true,  { AArch64::FeatureTLB_RMI }  }, // 75
  { "RVAE2ISnXS", 0x2491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 76
  { "RVAE2nXS", 0x24B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 77
  { "RVAE2OS", 0x2429, true,  { AArch64::FeatureTLB_RMI }  }, // 78
  { "RVAE2OSnXS", 0x24A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 79
  { "RVAE3", 0x3431, true,  { AArch64::FeatureTLB_RMI }  }, // 80
  { "RVAE3IS", 0x3411, true,  { AArch64::FeatureTLB_RMI }  }, // 81
  { "RVAE3ISnXS", 0x3491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 82
  { "RVAE3nXS", 0x34B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 83
  { "RVAE3OS", 0x3429, true,  { AArch64::FeatureTLB_RMI }  }, // 84
  { "RVAE3OSnXS", 0x34A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 85
  { "RVALE1", 0x435, true,  { AArch64::FeatureTLB_RMI }  }, // 86
  { "RVALE1IS", 0x415, true,  { AArch64::FeatureTLB_RMI }  }, // 87
  { "RVALE1ISnXS", 0x495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 88
  { "RVALE1nXS", 0x4B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 89
  { "RVALE1OS", 0x42D, true,  { AArch64::FeatureTLB_RMI }  }, // 90
  { "RVALE1OSnXS", 0x4AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 91
  { "RVALE2", 0x2435, true,  { AArch64::FeatureTLB_RMI }  }, // 92
  { "RVALE2IS", 0x2415, true,  { AArch64::FeatureTLB_RMI }  }, // 93
  { "RVALE2ISnXS", 0x2495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 94
  { "RVALE2nXS", 0x24B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 95
  { "RVALE2OS", 0x242D, true,  { AArch64::FeatureTLB_RMI }  }, // 96
  { "RVALE2OSnXS", 0x24AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 97
  { "RVALE3", 0x3435, true,  { AArch64::FeatureTLB_RMI }  }, // 98
  { "RVALE3IS", 0x3415, true,  { AArch64::FeatureTLB_RMI }  }, // 99
  { "RVALE3ISnXS", 0x3495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 100
  { "RVALE3nXS", 0x34B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 101
  { "RVALE3OS", 0x342D, true,  { AArch64::FeatureTLB_RMI }  }, // 102
  { "RVALE3OSnXS", 0x34AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 103
  { "VAAE1", 0x43B, true,  {  }  }, // 104
  { "VAAE1IS", 0x41B, true,  {  }  }, // 105
  { "VAAE1ISnXS", 0x49B, true,  { AArch64::FeatureXS }  }, // 106
  { "VAAE1nXS", 0x4BB, true,  { AArch64::FeatureXS }  }, // 107
  { "VAAE1OS", 0x40B, true,  { AArch64::FeatureTLB_RMI }  }, // 108
  { "VAAE1OSnXS", 0x48B, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 109
  { "VAALE1", 0x43F, true,  {  }  }, // 110
  { "VAALE1IS", 0x41F, true,  {  }  }, // 111
  { "VAALE1ISnXS", 0x49F, true,  { AArch64::FeatureXS }  }, // 112
  { "VAALE1nXS", 0x4BF, true,  { AArch64::FeatureXS }  }, // 113
  { "VAALE1OS", 0x40F, true,  { AArch64::FeatureTLB_RMI }  }, // 114
  { "VAALE1OSnXS", 0x48F, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 115
  { "VAE1", 0x439, true,  {  }  }, // 116
  { "VAE1IS", 0x419, true,  {  }  }, // 117
  { "VAE1ISnXS", 0x499, true,  { AArch64::FeatureXS }  }, // 118
  { "VAE1nXS", 0x4B9, true,  { AArch64::FeatureXS }  }, // 119
  { "VAE1OS", 0x409, true,  { AArch64::FeatureTLB_RMI }  }, // 120
  { "VAE1OSnXS", 0x489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 121
  { "VAE2", 0x2439, true,  {  }  }, // 122
  { "VAE2IS", 0x2419, true,  {  }  }, // 123
  { "VAE2ISnXS", 0x2499, true,  { AArch64::FeatureXS }  }, // 124
  { "VAE2nXS", 0x24B9, true,  { AArch64::FeatureXS }  }, // 125
  { "VAE2OS", 0x2409, true,  { AArch64::FeatureTLB_RMI }  }, // 126
  { "VAE2OSnXS", 0x2489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 127
  { "VAE3", 0x3439, true,  {  }  }, // 128
  { "VAE3IS", 0x3419, true,  {  }  }, // 129
  { "VAE3ISnXS", 0x3499, true,  { AArch64::FeatureXS }  }, // 130
  { "VAE3nXS", 0x34B9, true,  { AArch64::FeatureXS }  }, // 131
  { "VAE3OS", 0x3409, true,  { AArch64::FeatureTLB_RMI }  }, // 132
  { "VAE3OSnXS", 0x3489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 133
  { "VALE1", 0x43D, true,  {  }  }, // 134
  { "VALE1IS", 0x41D, true,  {  }  }, // 135
  { "VALE1ISnXS", 0x49D, true,  { AArch64::FeatureXS }  }, // 136
  { "VALE1nXS", 0x4BD, true,  { AArch64::FeatureXS }  }, // 137
  { "VALE1OS", 0x40D, true,  { AArch64::FeatureTLB_RMI }  }, // 138
  { "VALE1OSnXS", 0x48D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 139
  { "VALE2", 0x243D, true,  {  }  }, // 140
  { "VALE2IS", 0x241D, true,  {  }  }, // 141
  { "VALE2ISnXS", 0x249D, true,  { AArch64::FeatureXS }  }, // 142
  { "VALE2nXS", 0x24BD, true,  { AArch64::FeatureXS }  }, // 143
  { "VALE2OS", 0x240D, true,  { AArch64::FeatureTLB_RMI }  }, // 144
  { "VALE2OSnXS", 0x248D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 145
  { "VALE3", 0x343D, true,  {  }  }, // 146
  { "VALE3IS", 0x341D, true,  {  }  }, // 147
  { "VALE3ISnXS", 0x349D, true,  { AArch64::FeatureXS }  }, // 148
  { "VALE3nXS", 0x34BD, true,  { AArch64::FeatureXS }  }, // 149
  { "VALE3OS", 0x340D, true,  { AArch64::FeatureTLB_RMI }  }, // 150
  { "VALE3OSnXS", 0x348D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 151
  { "VMALLE1", 0x438, false,  {  }  }, // 152
  { "VMALLE1IS", 0x418, false,  {  }  }, // 153
  { "VMALLE1ISnXS", 0x498, false,  { AArch64::FeatureXS }  }, // 154
  { "VMALLE1nXS", 0x4B8, false,  { AArch64::FeatureXS }  }, // 155
  { "VMALLE1OS", 0x408, false,  { AArch64::FeatureTLB_RMI }  }, // 156
  { "VMALLE1OSnXS", 0x488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 157
  { "VMALLS12E1", 0x243E, false,  {  }  }, // 158
  { "VMALLS12E1IS", 0x241E, false,  {  }  }, // 159
  { "VMALLS12E1ISnXS", 0x249E, false,  { AArch64::FeatureXS }  }, // 160
  { "VMALLS12E1nXS", 0x24BE, false,  { AArch64::FeatureXS }  }, // 161
  { "VMALLS12E1OS", 0x240E, false,  { AArch64::FeatureTLB_RMI }  }, // 162
  { "VMALLS12E1OSnXS", 0x248E, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 163
 };

const TLBI *lookupTLBIByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x408, 156 },
    { 0x409, 120 },
    { 0x40A, 22 },
    { 0x40B, 108 },
    { 0x40D, 138 },
    { 0x40F, 114 },
    { 0x411, 69 },
    { 0x413, 57 },
    { 0x415, 87 },
    { 0x417, 63 },
    { 0x418, 153 },
    { 0x419, 117 },
    { 0x41A, 19 },
    { 0x41B, 105 },
    { 0x41D, 135 },
    { 0x41F, 111 },
    { 0x429, 72 },
    { 0x42B, 60 },
    { 0x42D, 90 },
    { 0x42F, 66 },
    { 0x431, 68 },
    { 0x433, 56 },
    { 0x435, 86 },
    { 0x437, 62 },
    { 0x438, 152 },
    { 0x439, 116 },
    { 0x43A, 18 },
    { 0x43B, 104 },
    { 0x43D, 134 },
    { 0x43F, 110 },
    { 0x488, 157 },
    { 0x489, 121 },
    { 0x48A, 23 },
    { 0x48B, 109 },
    { 0x48D, 139 },
    { 0x48F, 115 },
    { 0x491, 70 },
    { 0x493, 58 },
    { 0x495, 88 },
    { 0x497, 64 },
    { 0x498, 154 },
    { 0x499, 118 },
    { 0x49A, 20 },
    { 0x49B, 106 },
    { 0x49D, 136 },
    { 0x49F, 112 },
    { 0x4A9, 73 },
    { 0x4AB, 61 },
    { 0x4AD, 91 },
    { 0x4AF, 67 },
    { 0x4B1, 71 },
    { 0x4B3, 59 },
    { 0x4B5, 89 },
    { 0x4B7, 65 },
    { 0x4B8, 155 },
    { 0x4B9, 119 },
    { 0x4BA, 21 },
    { 0x4BB, 107 },
    { 0x4BD, 137 },
    { 0x4BF, 113 },
    { 0x2401, 25 },
    { 0x2402, 41 },
    { 0x2405, 31 },
    { 0x2406, 47 },
    { 0x2408, 10 },
    { 0x2409, 126 },
    { 0x240C, 4 },
    { 0x240D, 144 },
    { 0x240E, 162 },
    { 0x2411, 75 },
    { 0x2415, 93 },
    { 0x2418, 7 },
    { 0x2419, 123 },
    { 0x241C, 1 },
    { 0x241D, 141 },
    { 0x241E, 159 },
    { 0x2420, 28 },
    { 0x2421, 24 },
    { 0x2422, 40 },
    { 0x2423, 44 },
    { 0x2424, 34 },
    { 0x2425, 30 },
    { 0x2426, 46 },
    { 0x2427, 50 },
    { 0x2429, 78 },
    { 0x242D, 96 },
    { 0x2431, 74 },
    { 0x2435, 92 },
    { 0x2438, 6 },
    { 0x2439, 122 },
    { 0x243C, 0 },
    { 0x243D, 140 },
    { 0x243E, 158 },
    { 0x2481, 26 },
    { 0x2482, 42 },
    { 0x2485, 32 },
    { 0x2486, 48 },
    { 0x2488, 11 },
    { 0x2489, 127 },
    { 0x248C, 5 },
    { 0x248D, 145 },
    { 0x248E, 163 },
    { 0x2491, 76 },
    { 0x2495, 94 },
    { 0x2498, 8 },
    { 0x2499, 124 },
    { 0x249C, 2 },
    { 0x249D, 142 },
    { 0x249E, 160 },
    { 0x24A0, 29 },
    { 0x24A1, 27 },
    { 0x24A2, 43 },
    { 0x24A3, 45 },
    { 0x24A4, 35 },
    { 0x24A5, 33 },
    { 0x24A6, 49 },
    { 0x24A7, 51 },
    { 0x24A9, 79 },
    { 0x24AD, 97 },
    { 0x24B1, 77 },
    { 0x24B5, 95 },
    { 0x24B8, 9 },
    { 0x24B9, 125 },
    { 0x24BC, 3 },
    { 0x24BD, 143 },
    { 0x24BE, 161 },
    { 0x3408, 16 },
    { 0x3409, 132 },
    { 0x340C, 38 },
    { 0x340D, 150 },
    { 0x3411, 81 },
    { 0x3415, 99 },
    { 0x3418, 13 },
    { 0x3419, 129 },
    { 0x341D, 147 },
    { 0x3423, 54 },
    { 0x3427, 52 },
    { 0x3429, 84 },
    { 0x342D, 102 },
    { 0x3431, 80 },
    { 0x3435, 98 },
    { 0x3438, 12 },
    { 0x3439, 128 },
    { 0x343C, 36 },
    { 0x343D, 146 },
    { 0x3488, 17 },
    { 0x3489, 133 },
    { 0x348C, 39 },
    { 0x348D, 151 },
    { 0x3491, 82 },
    { 0x3495, 100 },
    { 0x3498, 14 },
    { 0x3499, 130 },
    { 0x349D, 148 },
    { 0x34A3, 55 },
    { 0x34A7, 53 },
    { 0x34A9, 85 },
    { 0x34AD, 103 },
    { 0x34B1, 83 },
    { 0x34B5, 101 },
    { 0x34B8, 15 },
    { 0x34B9, 131 },
    { 0x34BC, 37 },
    { 0x34BD, 149 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &TLBITable[Idx->_index];
}

const TLBI *lookupTLBIByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALLE1", 0 },
    { "ALLE1IS", 1 },
    { "ALLE1ISNXS", 2 },
    { "ALLE1NXS", 3 },
    { "ALLE1OS", 4 },
    { "ALLE1OSNXS", 5 },
    { "ALLE2", 6 },
    { "ALLE2IS", 7 },
    { "ALLE2ISNXS", 8 },
    { "ALLE2NXS", 9 },
    { "ALLE2OS", 10 },
    { "ALLE2OSNXS", 11 },
    { "ALLE3", 12 },
    { "ALLE3IS", 13 },
    { "ALLE3ISNXS", 14 },
    { "ALLE3NXS", 15 },
    { "ALLE3OS", 16 },
    { "ALLE3OSNXS", 17 },
    { "ASIDE1", 18 },
    { "ASIDE1IS", 19 },
    { "ASIDE1ISNXS", 20 },
    { "ASIDE1NXS", 21 },
    { "ASIDE1OS", 22 },
    { "ASIDE1OSNXS", 23 },
    { "IPAS2E1", 24 },
    { "IPAS2E1IS", 25 },
    { "IPAS2E1ISNXS", 26 },
    { "IPAS2E1NXS", 27 },
    { "IPAS2E1OS", 28 },
    { "IPAS2E1OSNXS", 29 },
    { "IPAS2LE1", 30 },
    { "IPAS2LE1IS", 31 },
    { "IPAS2LE1ISNXS", 32 },
    { "IPAS2LE1NXS", 33 },
    { "IPAS2LE1OS", 34 },
    { "IPAS2LE1OSNXS", 35 },
    { "PAALL", 36 },
    { "PAALLNXS", 37 },
    { "PAALLOS", 38 },
    { "PAALLOSNXS", 39 },
    { "RIPAS2E1", 40 },
    { "RIPAS2E1IS", 41 },
    { "RIPAS2E1ISNXS", 42 },
    { "RIPAS2E1NXS", 43 },
    { "RIPAS2E1OS", 44 },
    { "RIPAS2E1OSNXS", 45 },
    { "RIPAS2LE1", 46 },
    { "RIPAS2LE1IS", 47 },
    { "RIPAS2LE1ISNXS", 48 },
    { "RIPAS2LE1NXS", 49 },
    { "RIPAS2LE1OS", 50 },
    { "RIPAS2LE1OSNXS", 51 },
    { "RPALOS", 52 },
    { "RPALOSNXS", 53 },
    { "RPAOS", 54 },
    { "RPAOSNXS", 55 },
    { "RVAAE1", 56 },
    { "RVAAE1IS", 57 },
    { "RVAAE1ISNXS", 58 },
    { "RVAAE1NXS", 59 },
    { "RVAAE1OS", 60 },
    { "RVAAE1OSNXS", 61 },
    { "RVAALE1", 62 },
    { "RVAALE1IS", 63 },
    { "RVAALE1ISNXS", 64 },
    { "RVAALE1NXS", 65 },
    { "RVAALE1OS", 66 },
    { "RVAALE1OSNXS", 67 },
    { "RVAE1", 68 },
    { "RVAE1IS", 69 },
    { "RVAE1ISNXS", 70 },
    { "RVAE1NXS", 71 },
    { "RVAE1OS", 72 },
    { "RVAE1OSNXS", 73 },
    { "RVAE2", 74 },
    { "RVAE2IS", 75 },
    { "RVAE2ISNXS", 76 },
    { "RVAE2NXS", 77 },
    { "RVAE2OS", 78 },
    { "RVAE2OSNXS", 79 },
    { "RVAE3", 80 },
    { "RVAE3IS", 81 },
    { "RVAE3ISNXS", 82 },
    { "RVAE3NXS", 83 },
    { "RVAE3OS", 84 },
    { "RVAE3OSNXS", 85 },
    { "RVALE1", 86 },
    { "RVALE1IS", 87 },
    { "RVALE1ISNXS", 88 },
    { "RVALE1NXS", 89 },
    { "RVALE1OS", 90 },
    { "RVALE1OSNXS", 91 },
    { "RVALE2", 92 },
    { "RVALE2IS", 93 },
    { "RVALE2ISNXS", 94 },
    { "RVALE2NXS", 95 },
    { "RVALE2OS", 96 },
    { "RVALE2OSNXS", 97 },
    { "RVALE3", 98 },
    { "RVALE3IS", 99 },
    { "RVALE3ISNXS", 100 },
    { "RVALE3NXS", 101 },
    { "RVALE3OS", 102 },
    { "RVALE3OSNXS", 103 },
    { "VAAE1", 104 },
    { "VAAE1IS", 105 },
    { "VAAE1ISNXS", 106 },
    { "VAAE1NXS", 107 },
    { "VAAE1OS", 108 },
    { "VAAE1OSNXS", 109 },
    { "VAALE1", 110 },
    { "VAALE1IS", 111 },
    { "VAALE1ISNXS", 112 },
    { "VAALE1NXS", 113 },
    { "VAALE1OS", 114 },
    { "VAALE1OSNXS", 115 },
    { "VAE1", 116 },
    { "VAE1IS", 117 },
    { "VAE1ISNXS", 118 },
    { "VAE1NXS", 119 },
    { "VAE1OS", 120 },
    { "VAE1OSNXS", 121 },
    { "VAE2", 122 },
    { "VAE2IS", 123 },
    { "VAE2ISNXS", 124 },
    { "VAE2NXS", 125 },
    { "VAE2OS", 126 },
    { "VAE2OSNXS", 127 },
    { "VAE3", 128 },
    { "VAE3IS", 129 },
    { "VAE3ISNXS", 130 },
    { "VAE3NXS", 131 },
    { "VAE3OS", 132 },
    { "VAE3OSNXS", 133 },
    { "VALE1", 134 },
    { "VALE1IS", 135 },
    { "VALE1ISNXS", 136 },
    { "VALE1NXS", 137 },
    { "VALE1OS", 138 },
    { "VALE1OSNXS", 139 },
    { "VALE2", 140 },
    { "VALE2IS", 141 },
    { "VALE2ISNXS", 142 },
    { "VALE2NXS", 143 },
    { "VALE2OS", 144 },
    { "VALE2OSNXS", 145 },
    { "VALE3", 146 },
    { "VALE3IS", 147 },
    { "VALE3ISNXS", 148 },
    { "VALE3NXS", 149 },
    { "VALE3OS", 150 },
    { "VALE3OSNXS", 151 },
    { "VMALLE1", 152 },
    { "VMALLE1IS", 153 },
    { "VMALLE1ISNXS", 154 },
    { "VMALLE1NXS", 155 },
    { "VMALLE1OS", 156 },
    { "VMALLE1OSNXS", 157 },
    { "VMALLS12E1", 158 },
    { "VMALLS12E1IS", 159 },
    { "VMALLS12E1ISNXS", 160 },
    { "VMALLS12E1NXS", 161 },
    { "VMALLS12E1OS", 162 },
    { "VMALLS12E1OSNXS", 163 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &TLBITable[Idx->_index];
}
#endif

#ifdef GET_AT_DECL
const AT *lookupATByName(StringRef Name);
const AT *lookupATByEncoding(uint16_t Encoding);
#endif

#ifdef GET_AT_IMPL
constexpr AT ATsList[] = {
  { "S12E0R", 0x23C6,  {}  }, // 0
  { "S12E0W", 0x23C7,  {}  }, // 1
  { "S12E1R", 0x23C4,  {}  }, // 2
  { "S12E1W", 0x23C5,  {}  }, // 3
  { "S1E0R", 0x3C2,  {}  }, // 4
  { "S1E0W", 0x3C3,  {}  }, // 5
  { "S1E1A", 0x3CA,  {}  }, // 6
  { "S1E1R", 0x3C0,  {}  }, // 7
  { "S1E1RP", 0x3C8,  {AArch64::FeaturePAN_RWV}  }, // 8
  { "S1E1W", 0x3C1,  {}  }, // 9
  { "S1E1WP", 0x3C9,  {AArch64::FeaturePAN_RWV}  }, // 10
  { "S1E2A", 0x23CA,  {}  }, // 11
  { "S1E2R", 0x23C0,  {}  }, // 12
  { "S1E2W", 0x23C1,  {}  }, // 13
  { "S1E3A", 0x33CA,  {}  }, // 14
  { "S1E3R", 0x33C0,  {}  }, // 15
  { "S1E3W", 0x33C1,  {}  }, // 16
 };

const AT *lookupATByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "S12E0R", 0 },
    { "S12E0W", 1 },
    { "S12E1R", 2 },
    { "S12E1W", 3 },
    { "S1E0R", 4 },
    { "S1E0W", 5 },
    { "S1E1A", 6 },
    { "S1E1R", 7 },
    { "S1E1RP", 8 },
    { "S1E1W", 9 },
    { "S1E1WP", 10 },
    { "S1E2A", 11 },
    { "S1E2R", 12 },
    { "S1E2W", 13 },
    { "S1E3A", 14 },
    { "S1E3R", 15 },
    { "S1E3W", 16 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ATsList[Idx->_index];
}

const AT *lookupATByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3C0, 7 },
    { 0x3C1, 9 },
    { 0x3C2, 4 },
    { 0x3C3, 5 },
    { 0x3C8, 8 },
    { 0x3C9, 10 },
    { 0x3CA, 6 },
    { 0x23C0, 12 },
    { 0x23C1, 13 },
    { 0x23C4, 2 },
    { 0x23C5, 3 },
    { 0x23C6, 0 },
    { 0x23C7, 1 },
    { 0x23CA, 11 },
    { 0x33C0, 15 },
    { 0x33C1, 16 },
    { 0x33CA, 14 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ATsList[Idx->_index];
}
#endif

#ifdef GET_BTI_DECL
const BTI *lookupBTIByName(StringRef Name);
const BTI *lookupBTIByEncoding(uint8_t Encoding);
#endif

#ifdef GET_BTI_IMPL
constexpr BTI BTIsList[] = {
  { "c", 0x2 }, // 0
  { "j", 0x4 }, // 1
  { "jc", 0x6 }, // 2
 };

const BTI *lookupBTIByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "C", 0 },
    { "J", 1 },
    { "JC", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &BTIsList[Idx->_index];
}

const BTI *lookupBTIByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x2, 0 },
    { 0x4, 1 },
    { 0x6, 2 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &BTIsList[Idx->_index];
}
#endif

#ifdef GET_DB_DECL
const DB *lookupDBByName(StringRef Name);
const DB *lookupDBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_DB_IMPL
constexpr DB DBsList[] = {
  { "ish", 0xB }, // 0
  { "ishld", 0x9 }, // 1
  { "ishst", 0xA }, // 2
  { "ld", 0xD }, // 3
  { "nsh", 0x7 }, // 4
  { "nshld", 0x5 }, // 5
  { "nshst", 0x6 }, // 6
  { "osh", 0x3 }, // 7
  { "oshld", 0x1 }, // 8
  { "oshst", 0x2 }, // 9
  { "st", 0xE }, // 10
  { "sy", 0xF }, // 11
 };

const DB *lookupDBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ISH", 0 },
    { "ISHLD", 1 },
    { "ISHST", 2 },
    { "LD", 3 },
    { "NSH", 4 },
    { "NSHLD", 5 },
    { "NSHST", 6 },
    { "OSH", 7 },
    { "OSHLD", 8 },
    { "OSHST", 9 },
    { "ST", 10 },
    { "SY", 11 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DBsList[Idx->_index];
}

const DB *lookupDBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 8 },
    { 0x2, 9 },
    { 0x3, 7 },
    { 0x5, 5 },
    { 0x6, 6 },
    { 0x7, 4 },
    { 0x9, 1 },
    { 0xA, 2 },
    { 0xB, 0 },
    { 0xD, 3 },
    { 0xE, 10 },
    { 0xF, 11 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DBsList[Idx->_index];
}
#endif

#ifdef GET_DBNXS_DECL
const DBnXS *lookupDBnXSByName(StringRef Name);
const DBnXS *lookupDBnXSByEncoding(uint8_t Encoding);
const DBnXS *lookupDBnXSByImmValue(uint8_t ImmValue);
#endif

#ifdef GET_DBNXS_IMPL
constexpr DBnXS DBnXSsList[] = {
  { "ishnxs", 0xB, 0x18,  {AArch64::FeatureXS}  }, // 0
  { "nshnxs", 0x7, 0x14,  {AArch64::FeatureXS}  }, // 1
  { "oshnxs", 0x3, 0x10,  {AArch64::FeatureXS}  }, // 2
  { "synxs", 0xF, 0x1C,  {AArch64::FeatureXS}  }, // 3
 };

const DBnXS *lookupDBnXSByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ISHNXS", 0 },
    { "NSHNXS", 1 },
    { "OSHNXS", 2 },
    { "SYNXS", 3 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}

const DBnXS *lookupDBnXSByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3, 2 },
    { 0x7, 1 },
    { 0xB, 0 },
    { 0xF, 3 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}

const DBnXS *lookupDBnXSByImmValue(uint8_t ImmValue) {
  struct IndexType {
    uint8_t ImmValue;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x10, 2 },
    { 0x14, 1 },
    { 0x18, 0 },
    { 0x1C, 3 },
  };

  struct KeyType {
    uint8_t ImmValue;
  };
  KeyType Key = {ImmValue};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.ImmValue < RHS.ImmValue)
        return true;
      if (LHS.ImmValue > RHS.ImmValue)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.ImmValue != Idx->ImmValue)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}
#endif

#ifdef GET_DC_DECL
const DC *lookupDCByName(StringRef Name);
const DC *lookupDCByEncoding(uint16_t Encoding);
#endif

#ifdef GET_DC_IMPL
constexpr DC DCsList[] = {
  { "CGDSW", 0x3D6,  {AArch64::FeatureMTE}  }, // 0
  { "CGDVAC", 0x1BD5,  {AArch64::FeatureMTE}  }, // 1
  { "CGDVADP", 0x1BED,  {AArch64::FeatureMTE}  }, // 2
  { "CGDVAP", 0x1BE5,  {AArch64::FeatureMTE}  }, // 3
  { "CGSW", 0x3D4,  {AArch64::FeatureMTE}  }, // 4
  { "CGVAC", 0x1BD3,  {AArch64::FeatureMTE}  }, // 5
  { "CGVADP", 0x1BEB,  {AArch64::FeatureMTE}  }, // 6
  { "CGVAP", 0x1BE3,  {AArch64::FeatureMTE}  }, // 7
  { "CIGDPAE", 0x23F7,  {AArch64::FeatureMEC}  }, // 8
  { "CIGDSW", 0x3F6,  {AArch64::FeatureMTE}  }, // 9
  { "CIGDVAC", 0x1BF5,  {AArch64::FeatureMTE}  }, // 10
  { "CIGSW", 0x3F4,  {AArch64::FeatureMTE}  }, // 11
  { "CIGVAC", 0x1BF3,  {AArch64::FeatureMTE}  }, // 12
  { "CIPAE", 0x23F0,  {AArch64::FeatureMEC}  }, // 13
  { "CISW", 0x3F2,  {}  }, // 14
  { "CIVAC", 0x1BF1,  {}  }, // 15
  { "CSW", 0x3D2,  {}  }, // 16
  { "CVAC", 0x1BD1,  {}  }, // 17
  { "CVADP", 0x1BE9,  {AArch64::FeatureCacheDeepPersist}  }, // 18
  { "CVAP", 0x1BE1,  {AArch64::FeatureCCPP}  }, // 19
  { "CVAU", 0x1BD9,  {}  }, // 20
  { "GVA", 0x1BA3,  {AArch64::FeatureMTE}  }, // 21
  { "GZVA", 0x1BA4,  {AArch64::FeatureMTE}  }, // 22
  { "IGDSW", 0x3B6,  {AArch64::FeatureMTE}  }, // 23
  { "IGDVAC", 0x3B5,  {AArch64::FeatureMTE}  }, // 24
  { "IGSW", 0x3B4,  {AArch64::FeatureMTE}  }, // 25
  { "IGVAC", 0x3B3,  {AArch64::FeatureMTE}  }, // 26
  { "ISW", 0x3B2,  {}  }, // 27
  { "IVAC", 0x3B1,  {}  }, // 28
  { "ZVA", 0x1BA1,  {}  }, // 29
 };

const DC *lookupDCByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CGDSW", 0 },
    { "CGDVAC", 1 },
    { "CGDVADP", 2 },
    { "CGDVAP", 3 },
    { "CGSW", 4 },
    { "CGVAC", 5 },
    { "CGVADP", 6 },
    { "CGVAP", 7 },
    { "CIGDPAE", 8 },
    { "CIGDSW", 9 },
    { "CIGDVAC", 10 },
    { "CIGSW", 11 },
    { "CIGVAC", 12 },
    { "CIPAE", 13 },
    { "CISW", 14 },
    { "CIVAC", 15 },
    { "CSW", 16 },
    { "CVAC", 17 },
    { "CVADP", 18 },
    { "CVAP", 19 },
    { "CVAU", 20 },
    { "GVA", 21 },
    { "GZVA", 22 },
    { "IGDSW", 23 },
    { "IGDVAC", 24 },
    { "IGSW", 25 },
    { "IGVAC", 26 },
    { "ISW", 27 },
    { "IVAC", 28 },
    { "ZVA", 29 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DCsList[Idx->_index];
}

const DC *lookupDCByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3B1, 28 },
    { 0x3B2, 27 },
    { 0x3B3, 26 },
    { 0x3B4, 25 },
    { 0x3B5, 24 },
    { 0x3B6, 23 },
    { 0x3D2, 16 },
    { 0x3D4, 4 },
    { 0x3D6, 0 },
    { 0x3F2, 14 },
    { 0x3F4, 11 },
    { 0x3F6, 9 },
    { 0x1BA1, 29 },
    { 0x1BA3, 21 },
    { 0x1BA4, 22 },
    { 0x1BD1, 17 },
    { 0x1BD3, 5 },
    { 0x1BD5, 1 },
    { 0x1BD9, 20 },
    { 0x1BE1, 19 },
    { 0x1BE3, 7 },
    { 0x1BE5, 3 },
    { 0x1BE9, 18 },
    { 0x1BEB, 6 },
    { 0x1BED, 2 },
    { 0x1BF1, 15 },
    { 0x1BF3, 12 },
    { 0x1BF5, 10 },
    { 0x23F0, 13 },
    { 0x23F7, 8 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DCsList[Idx->_index];
}
#endif

#ifdef GET_EXACTFPIMM_DECL
const ExactFPImm *lookupExactFPImmByEnum(uint8_t Enum);
const ExactFPImm *lookupExactFPImmByRepr(StringRef Repr);
#endif

#ifdef GET_EXACTFPIMM_IMPL
constexpr ExactFPImm ExactFPImmsList[] = {
  { "half", 0x1, "0.5" }, // 0
  { "one", 0x2, "1.0" }, // 1
  { "two", 0x3, "2.0" }, // 2
  { "zero", 0x0, "0.0" }, // 3
 };

const ExactFPImm *lookupExactFPImmByEnum(uint8_t Enum) {
  struct IndexType {
    uint8_t Enum;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 3 },
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Enum;
  return Idx >= Table.size() ? nullptr : &ExactFPImmsList[Table[Idx]._index];
}

const ExactFPImm *lookupExactFPImmByRepr(StringRef Repr) {
  struct IndexType {
    const char * Repr;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "0.0", 3 },
    { "0.5", 0 },
    { "1.0", 1 },
    { "2.0", 2 },
  };

  struct KeyType {
    std::string Repr;
  };
  KeyType Key = {Repr.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpRepr = StringRef(LHS.Repr).compare(RHS.Repr);
      if (CmpRepr < 0) return true;
      if (CmpRepr > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Repr != Idx->Repr)
    return nullptr;
  return &ExactFPImmsList[Idx->_index];
}
#endif

#ifdef GET_IC_DECL
const IC *lookupICByName(StringRef Name);
const IC *lookupICByEncoding(uint16_t Encoding);
#endif

#ifdef GET_IC_IMPL
constexpr IC ICsList[] = {
  { "IALLU", 0x3A8, false }, // 0
  { "IALLUIS", 0x388, false }, // 1
  { "IVAU", 0x1BA9, true }, // 2
 };

const IC *lookupICByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "IALLU", 0 },
    { "IALLUIS", 1 },
    { "IVAU", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ICsList[Idx->_index];
}

const IC *lookupICByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x388, 1 },
    { 0x3A8, 0 },
    { 0x1BA9, 2 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ICsList[Idx->_index];
}
#endif

#ifdef GET_ISB_DECL
const ISB *lookupISBByName(StringRef Name);
const ISB *lookupISBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_ISB_IMPL
constexpr ISB ISBsList[] = {
  { "sy", 0xF }, // 0
 };

const ISB *lookupISBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SY", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ISBsList[Idx->_index];
}

const ISB *lookupISBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0xF, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ISBsList[Idx->_index];
}
#endif

#ifdef GET_PRFM_DECL
const PRFM *lookupPRFMByName(StringRef Name);
const PRFM *lookupPRFMByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PRFM_IMPL
constexpr PRFM PRFMsList[] = {
  { "pldl1keep", 0x0,  {}  }, // 0
  { "pldl1strm", 0x1,  {}  }, // 1
  { "pldl2keep", 0x2,  {}  }, // 2
  { "pldl2strm", 0x3,  {}  }, // 3
  { "pldl3keep", 0x4,  {}  }, // 4
  { "pldl3strm", 0x5,  {}  }, // 5
  { "pldslckeep", 0x6,  {AArch64::FeaturePRFM_SLC}  }, // 6
  { "pldslcstrm", 0x7,  {AArch64::FeaturePRFM_SLC}  }, // 7
  { "plil1keep", 0x8,  {}  }, // 8
  { "plil1strm", 0x9,  {}  }, // 9
  { "plil2keep", 0xA,  {}  }, // 10
  { "plil2strm", 0xB,  {}  }, // 11
  { "plil3keep", 0xC,  {}  }, // 12
  { "plil3strm", 0xD,  {}  }, // 13
  { "plislckeep", 0xE,  {AArch64::FeaturePRFM_SLC}  }, // 14
  { "plislcstrm", 0xF,  {AArch64::FeaturePRFM_SLC}  }, // 15
  { "pstl1keep", 0x10,  {}  }, // 16
  { "pstl1strm", 0x11,  {}  }, // 17
  { "pstl2keep", 0x12,  {}  }, // 18
  { "pstl2strm", 0x13,  {}  }, // 19
  { "pstl3keep", 0x14,  {}  }, // 20
  { "pstl3strm", 0x15,  {}  }, // 21
  { "pstslckeep", 0x16,  {AArch64::FeaturePRFM_SLC}  }, // 22
  { "pstslcstrm", 0x17,  {AArch64::FeaturePRFM_SLC}  }, // 23
 };

const PRFM *lookupPRFMByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "PLDL1KEEP", 0 },
    { "PLDL1STRM", 1 },
    { "PLDL2KEEP", 2 },
    { "PLDL2STRM", 3 },
    { "PLDL3KEEP", 4 },
    { "PLDL3STRM", 5 },
    { "PLDSLCKEEP", 6 },
    { "PLDSLCSTRM", 7 },
    { "PLIL1KEEP", 8 },
    { "PLIL1STRM", 9 },
    { "PLIL2KEEP", 10 },
    { "PLIL2STRM", 11 },
    { "PLIL3KEEP", 12 },
    { "PLIL3STRM", 13 },
    { "PLISLCKEEP", 14 },
    { "PLISLCSTRM", 15 },
    { "PSTL1KEEP", 16 },
    { "PSTL1STRM", 17 },
    { "PSTL2KEEP", 18 },
    { "PSTL2STRM", 19 },
    { "PSTL3KEEP", 20 },
    { "PSTL3STRM", 21 },
    { "PSTSLCKEEP", 22 },
    { "PSTSLCSTRM", 23 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PRFMsList[Idx->_index];
}

const PRFM *lookupPRFMByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 1 },
    { 0x2, 2 },
    { 0x3, 3 },
    { 0x4, 4 },
    { 0x5, 5 },
    { 0x6, 6 },
    { 0x7, 7 },
    { 0x8, 8 },
    { 0x9, 9 },
    { 0xA, 10 },
    { 0xB, 11 },
    { 0xC, 12 },
    { 0xD, 13 },
    { 0xE, 14 },
    { 0xF, 15 },
    { 0x10, 16 },
    { 0x11, 17 },
    { 0x12, 18 },
    { 0x13, 19 },
    { 0x14, 20 },
    { 0x15, 21 },
    { 0x16, 22 },
    { 0x17, 23 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &PRFMsList[Table[Idx]._index];
}
#endif

#ifdef GET_PSB_DECL
const PSB *lookupPSBByName(StringRef Name);
const PSB *lookupPSBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PSB_IMPL
constexpr PSB PSBsList[] = {
  { "csync", 0x11 }, // 0
 };

const PSB *lookupPSBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CSYNC", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PSBsList[Idx->_index];
}

const PSB *lookupPSBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x11, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PSBsList[Idx->_index];
}
#endif

#ifdef GET_PSTATEIMM0_1_DECL
const PStateImm0_1 *lookupPStateImm0_1ByName(StringRef Name);
const PStateImm0_1 *lookupPStateImm0_1ByEncoding(uint16_t Encoding);
#endif

#ifdef GET_PSTATEIMM0_1_IMPL
constexpr PStateImm0_1 PStateImm0_1sList[] = {
  { "ALLINT", 0x8,  {AArch64::FeatureNMI}  }, // 0
  { "PM", 0x48,  {}  }, // 1
 };

const PStateImm0_1 *lookupPStateImm0_1ByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALLINT", 0 },
    { "PM", 1 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PStateImm0_1sList[Idx->_index];
}

const PStateImm0_1 *lookupPStateImm0_1ByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x8, 0 },
    { 0x48, 1 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PStateImm0_1sList[Idx->_index];
}
#endif

#ifdef GET_PSTATEIMM0_15_DECL
const PStateImm0_15 *lookupPStateImm0_15ByName(StringRef Name);
const PStateImm0_15 *lookupPStateImm0_15ByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PSTATEIMM0_15_IMPL
constexpr PStateImm0_15 PStateImm0_15sList[] = {
  { "DAIFClr", 0x1F,  {}  }, // 0
  { "DAIFSet", 0x1E,  {}  }, // 1
  { "DIT", 0x1A,  {AArch64::FeatureDIT}  }, // 2
  { "PAN", 0x4,  {AArch64::FeaturePAN}  }, // 3
  { "SPSel", 0x5,  {}  }, // 4
  { "SSBS", 0x19,  {AArch64::FeatureSSBS}  }, // 5
  { "TCO", 0x1C,  {AArch64::FeatureMTE}  }, // 6
  { "UAO", 0x3,  {AArch64::FeaturePsUAO}  }, // 7
 };

const PStateImm0_15 *lookupPStateImm0_15ByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "DAIFCLR", 0 },
    { "DAIFSET", 1 },
    { "DIT", 2 },
    { "PAN", 3 },
    { "SPSEL", 4 },
    { "SSBS", 5 },
    { "TCO", 6 },
    { "UAO", 7 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PStateImm0_15sList[Idx->_index];
}

const PStateImm0_15 *lookupPStateImm0_15ByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3, 7 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x19, 5 },
    { 0x1A, 2 },
    { 0x1C, 6 },
    { 0x1E, 1 },
    { 0x1F, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PStateImm0_15sList[Idx->_index];
}
#endif

#ifdef GET_RPRFM_DECL
const RPRFM *lookupRPRFMByName(StringRef Name);
const RPRFM *lookupRPRFMByEncoding(uint8_t Encoding);
#endif

#ifdef GET_RPRFM_IMPL
constexpr RPRFM RPRFMsList[] = {
  { "pldkeep", 0x0,  {}  }, // 0
  { "pldstrm", 0x4,  {}  }, // 1
  { "pstkeep", 0x1,  {}  }, // 2
  { "pststrm", 0x5,  {}  }, // 3
 };

const RPRFM *lookupRPRFMByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "PLDKEEP", 0 },
    { "PLDSTRM", 1 },
    { "PSTKEEP", 2 },
    { "PSTSTRM", 3 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &RPRFMsList[Idx->_index];
}

const RPRFM *lookupRPRFMByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x4, 1 },
    { 0x5, 3 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &RPRFMsList[Idx->_index];
}
#endif

#ifdef GET_SVCR_DECL
const SVCR *lookupSVCRByName(StringRef Name);
const SVCR *lookupSVCRByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVCR_IMPL
constexpr SVCR SVCRsList[] = {
  { "SVCRSM", 0x1,  {AArch64::FeatureSME}  }, // 0
  { "SVCRSMZA", 0x3,  {AArch64::FeatureSME}  }, // 1
  { "SVCRZA", 0x2,  {AArch64::FeatureSME}  }, // 2
 };

const SVCR *lookupSVCRByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SVCRSM", 0 },
    { "SVCRSMZA", 1 },
    { "SVCRZA", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVCRsList[Idx->_index];
}

const SVCR *lookupSVCRByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 2 },
    { 0x3, 1 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVCRsList[Idx->_index];
}
#endif

#ifdef GET_SVEPREDPAT_DECL
const SVEPREDPAT *lookupSVEPREDPATByName(StringRef Name);
const SVEPREDPAT *lookupSVEPREDPATByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVEPREDPAT_IMPL
constexpr SVEPREDPAT SVEPREDPATsList[] = {
  { "all", 0x1F }, // 0
  { "mul3", 0x1E }, // 1
  { "mul4", 0x1D }, // 2
  { "pow2", 0x0 }, // 3
  { "vl1", 0x1 }, // 4
  { "vl128", 0xC }, // 5
  { "vl16", 0x9 }, // 6
  { "vl2", 0x2 }, // 7
  { "vl256", 0xD }, // 8
  { "vl3", 0x3 }, // 9
  { "vl32", 0xA }, // 10
  { "vl4", 0x4 }, // 11
  { "vl5", 0x5 }, // 12
  { "vl6", 0x6 }, // 13
  { "vl64", 0xB }, // 14
  { "vl7", 0x7 }, // 15
  { "vl8", 0x8 }, // 16
 };

const SVEPREDPAT *lookupSVEPREDPATByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALL", 0 },
    { "MUL3", 1 },
    { "MUL4", 2 },
    { "POW2", 3 },
    { "VL1", 4 },
    { "VL128", 5 },
    { "VL16", 6 },
    { "VL2", 7 },
    { "VL256", 8 },
    { "VL3", 9 },
    { "VL32", 10 },
    { "VL4", 11 },
    { "VL5", 12 },
    { "VL6", 13 },
    { "VL64", 14 },
    { "VL7", 15 },
    { "VL8", 16 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVEPREDPATsList[Idx->_index];
}

const SVEPREDPAT *lookupSVEPREDPATByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 3 },
    { 0x1, 4 },
    { 0x2, 7 },
    { 0x3, 9 },
    { 0x4, 11 },
    { 0x5, 12 },
    { 0x6, 13 },
    { 0x7, 15 },
    { 0x8, 16 },
    { 0x9, 6 },
    { 0xA, 10 },
    { 0xB, 14 },
    { 0xC, 5 },
    { 0xD, 8 },
    { 0x1D, 2 },
    { 0x1E, 1 },
    { 0x1F, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVEPREDPATsList[Idx->_index];
}
#endif

#ifdef GET_SVEPRFM_DECL
const SVEPRFM *lookupSVEPRFMByName(StringRef Name);
const SVEPRFM *lookupSVEPRFMByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVEPRFM_IMPL
constexpr SVEPRFM SVEPRFMsList[] = {
  { "pldl1keep", 0x0,  {AArch64::FeatureSVE}  }, // 0
  { "pldl1strm", 0x1,  {AArch64::FeatureSVE}  }, // 1
  { "pldl2keep", 0x2,  {AArch64::FeatureSVE}  }, // 2
  { "pldl2strm", 0x3,  {AArch64::FeatureSVE}  }, // 3
  { "pldl3keep", 0x4,  {AArch64::FeatureSVE}  }, // 4
  { "pldl3strm", 0x5,  {AArch64::FeatureSVE}  }, // 5
  { "pstl1keep", 0x8,  {AArch64::FeatureSVE}  }, // 6
  { "pstl1strm", 0x9,  {AArch64::FeatureSVE}  }, // 7
  { "pstl2keep", 0xA,  {AArch64::FeatureSVE}  }, // 8
  { "pstl2strm", 0xB,  {AArch64::FeatureSVE}  }, // 9
  { "pstl3keep", 0xC,  {AArch64::FeatureSVE}  }, // 10
  { "pstl3strm", 0xD,  {AArch64::FeatureSVE}  }, // 11
 };

const SVEPRFM *lookupSVEPRFMByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "PLDL1KEEP", 0 },
    { "PLDL1STRM", 1 },
    { "PLDL2KEEP", 2 },
    { "PLDL2STRM", 3 },
    { "PLDL3KEEP", 4 },
    { "PLDL3STRM", 5 },
    { "PSTL1KEEP", 6 },
    { "PSTL1STRM", 7 },
    { "PSTL2KEEP", 8 },
    { "PSTL2STRM", 9 },
    { "PSTL3KEEP", 10 },
    { "PSTL3STRM", 11 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVEPRFMsList[Idx->_index];
}

const SVEPRFM *lookupSVEPRFMByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 1 },
    { 0x2, 2 },
    { 0x3, 3 },
    { 0x4, 4 },
    { 0x5, 5 },
    { 0x8, 6 },
    { 0x9, 7 },
    { 0xA, 8 },
    { 0xB, 9 },
    { 0xC, 10 },
    { 0xD, 11 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVEPRFMsList[Idx->_index];
}
#endif

#ifdef GET_SVEVECLENSPECIFIER_DECL
const SVEVECLENSPECIFIER *lookupSVEVECLENSPECIFIERByName(StringRef Name);
const SVEVECLENSPECIFIER *lookupSVEVECLENSPECIFIERByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVEVECLENSPECIFIER_IMPL
constexpr SVEVECLENSPECIFIER SVEVECLENSPECIFIERsList[] = {
  { "vlx2", 0x0 }, // 0
  { "vlx4", 0x1 }, // 1
 };

const SVEVECLENSPECIFIER *lookupSVEVECLENSPECIFIERByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "VLX2", 0 },
    { "VLX4", 1 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVEVECLENSPECIFIERsList[Idx->_index];
}

const SVEVECLENSPECIFIER *lookupSVEVECLENSPECIFIERByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 1 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &SVEVECLENSPECIFIERsList[Table[Idx]._index];
}
#endif

#ifdef GET_SYSREG_DECL
const SysReg *lookupSysRegByName(StringRef Name);
const SysReg *lookupSysRegByEncoding(uint16_t Encoding);
#endif

#ifdef GET_SYSREG_IMPL
constexpr SysReg SysRegsList[] = {
  { "ACCDATA_EL1", "ACCDATA_EL1", 0xC685, true, true,  {AArch64::FeatureLS64}  }, // 0
  { "ACTLR_EL1", "ACTLR_EL1", 0xC081, true, true,  {}  }, // 1
  { "ACTLR_EL2", "ACTLR_EL2", 0xE081, true, true,  {}  }, // 2
  { "ACTLR_EL3", "ACTLR_EL3", 0xF081, true, true,  {}  }, // 3
  { "AFSR0_EL1", "AFSR0_EL1", 0xC288, true, true,  {}  }, // 4
  { "AFSR0_EL12", "AFSR0_EL12", 0xEA88, true, true,  {AArch64::FeatureVH}  }, // 5
  { "AFSR0_EL2", "AFSR0_EL2", 0xE288, true, true,  {}  }, // 6
  { "AFSR0_EL3", "AFSR0_EL3", 0xF288, true, true,  {}  }, // 7
  { "AFSR1_EL1", "AFSR1_EL1", 0xC289, true, true,  {}  }, // 8
  { "AFSR1_EL12", "AFSR1_EL12", 0xEA89, true, true,  {AArch64::FeatureVH}  }, // 9
  { "AFSR1_EL2", "AFSR1_EL2", 0xE289, true, true,  {}  }, // 10
  { "AFSR1_EL3", "AFSR1_EL3", 0xF289, true, true,  {}  }, // 11
  { "AIDR_EL1", "AIDR_EL1", 0xC807, true, false,  {}  }, // 12
  { "ALLINT", "ALLINT", 0xC218, true, true,  {AArch64::FeatureNMI}  }, // 13
  { "AMAIR2_EL1", "AMAIR2_EL1", 0xC519, true, true,  {}  }, // 14
  { "AMAIR2_EL12", "AMAIR2_EL12", 0xED19, true, true,  {}  }, // 15
  { "AMAIR2_EL2", "AMAIR2_EL2", 0xE519, true, true,  {}  }, // 16
  { "AMAIR2_EL3", "AMAIR2_EL3", 0xF519, true, true,  {}  }, // 17
  { "AMAIR_EL1", "AMAIR_EL1", 0xC518, true, true,  {}  }, // 18
  { "AMAIR_EL12", "AMAIR_EL12", 0xED18, true, true,  {AArch64::FeatureVH}  }, // 19
  { "AMAIR_EL2", "AMAIR_EL2", 0xE518, true, true,  {}  }, // 20
  { "AMAIR_EL3", "AMAIR_EL3", 0xF518, true, true,  {}  }, // 21
  { "AMCFGR_EL0", "AMCFGR_EL0", 0xDE91, true, false,  {AArch64::FeatureAM}  }, // 22
  { "AMCG1IDR_EL0", "AMCG1IDR_EL0", 0xDE96, true, false,  {AArch64::FeatureAMVS}  }, // 23
  { "AMCGCR_EL0", "AMCGCR_EL0", 0xDE92, true, false,  {AArch64::FeatureAM}  }, // 24
  { "AMCNTENCLR0_EL0", "AMCNTENCLR0_EL0", 0xDE94, true, true,  {AArch64::FeatureAM}  }, // 25
  { "AMCNTENCLR1_EL0", "AMCNTENCLR1_EL0", 0xDE98, true, true,  {AArch64::FeatureAM}  }, // 26
  { "AMCNTENSET0_EL0", "AMCNTENSET0_EL0", 0xDE95, true, true,  {AArch64::FeatureAM}  }, // 27
  { "AMCNTENSET1_EL0", "AMCNTENSET1_EL0", 0xDE99, true, true,  {AArch64::FeatureAM}  }, // 28
  { "AMCR_EL0", "AMCR_EL0", 0xDE90, true, true,  {AArch64::FeatureAM}  }, // 29
  { "AMEVCNTR00_EL0", "AMEVCNTR00_EL0", 0xDEA0, true, true,  {AArch64::FeatureAM}  }, // 30
  { "AMEVCNTR01_EL0", "AMEVCNTR01_EL0", 0xDEA1, true, true,  {AArch64::FeatureAM}  }, // 31
  { "AMEVCNTR02_EL0", "AMEVCNTR02_EL0", 0xDEA2, true, true,  {AArch64::FeatureAM}  }, // 32
  { "AMEVCNTR03_EL0", "AMEVCNTR03_EL0", 0xDEA3, true, true,  {AArch64::FeatureAM}  }, // 33
  { "AMEVCNTR10_EL0", "AMEVCNTR10_EL0", 0xDEE0, true, true,  {AArch64::FeatureAM}  }, // 34
  { "AMEVCNTR110_EL0", "AMEVCNTR110_EL0", 0xDEEA, true, true,  {AArch64::FeatureAM}  }, // 35
  { "AMEVCNTR111_EL0", "AMEVCNTR111_EL0", 0xDEEB, true, true,  {AArch64::FeatureAM}  }, // 36
  { "AMEVCNTR112_EL0", "AMEVCNTR112_EL0", 0xDEEC, true, true,  {AArch64::FeatureAM}  }, // 37
  { "AMEVCNTR113_EL0", "AMEVCNTR113_EL0", 0xDEED, true, true,  {AArch64::FeatureAM}  }, // 38
  { "AMEVCNTR114_EL0", "AMEVCNTR114_EL0", 0xDEEE, true, true,  {AArch64::FeatureAM}  }, // 39
  { "AMEVCNTR115_EL0", "AMEVCNTR115_EL0", 0xDEEF, true, true,  {AArch64::FeatureAM}  }, // 40
  { "AMEVCNTR11_EL0", "AMEVCNTR11_EL0", 0xDEE1, true, true,  {AArch64::FeatureAM}  }, // 41
  { "AMEVCNTR12_EL0", "AMEVCNTR12_EL0", 0xDEE2, true, true,  {AArch64::FeatureAM}  }, // 42
  { "AMEVCNTR13_EL0", "AMEVCNTR13_EL0", 0xDEE3, true, true,  {AArch64::FeatureAM}  }, // 43
  { "AMEVCNTR14_EL0", "AMEVCNTR14_EL0", 0xDEE4, true, true,  {AArch64::FeatureAM}  }, // 44
  { "AMEVCNTR15_EL0", "AMEVCNTR15_EL0", 0xDEE5, true, true,  {AArch64::FeatureAM}  }, // 45
  { "AMEVCNTR16_EL0", "AMEVCNTR16_EL0", 0xDEE6, true, true,  {AArch64::FeatureAM}  }, // 46
  { "AMEVCNTR17_EL0", "AMEVCNTR17_EL0", 0xDEE7, true, true,  {AArch64::FeatureAM}  }, // 47
  { "AMEVCNTR18_EL0", "AMEVCNTR18_EL0", 0xDEE8, true, true,  {AArch64::FeatureAM}  }, // 48
  { "AMEVCNTR19_EL0", "AMEVCNTR19_EL0", 0xDEE9, true, true,  {AArch64::FeatureAM}  }, // 49
  { "AMEVCNTVOFF00_EL2", "AMEVCNTVOFF00_EL2", 0xE6C0, true, true,  {AArch64::FeatureAMVS}  }, // 50
  { "AMEVCNTVOFF010_EL2", "AMEVCNTVOFF010_EL2", 0xE6CA, true, true,  {AArch64::FeatureAMVS}  }, // 51
  { "AMEVCNTVOFF011_EL2", "AMEVCNTVOFF011_EL2", 0xE6CB, true, true,  {AArch64::FeatureAMVS}  }, // 52
  { "AMEVCNTVOFF012_EL2", "AMEVCNTVOFF012_EL2", 0xE6CC, true, true,  {AArch64::FeatureAMVS}  }, // 53
  { "AMEVCNTVOFF013_EL2", "AMEVCNTVOFF013_EL2", 0xE6CD, true, true,  {AArch64::FeatureAMVS}  }, // 54
  { "AMEVCNTVOFF014_EL2", "AMEVCNTVOFF014_EL2", 0xE6CE, true, true,  {AArch64::FeatureAMVS}  }, // 55
  { "AMEVCNTVOFF015_EL2", "AMEVCNTVOFF015_EL2", 0xE6CF, true, true,  {AArch64::FeatureAMVS}  }, // 56
  { "AMEVCNTVOFF01_EL2", "AMEVCNTVOFF01_EL2", 0xE6C1, true, true,  {AArch64::FeatureAMVS}  }, // 57
  { "AMEVCNTVOFF02_EL2", "AMEVCNTVOFF02_EL2", 0xE6C2, true, true,  {AArch64::FeatureAMVS}  }, // 58
  { "AMEVCNTVOFF03_EL2", "AMEVCNTVOFF03_EL2", 0xE6C3, true, true,  {AArch64::FeatureAMVS}  }, // 59
  { "AMEVCNTVOFF04_EL2", "AMEVCNTVOFF04_EL2", 0xE6C4, true, true,  {AArch64::FeatureAMVS}  }, // 60
  { "AMEVCNTVOFF05_EL2", "AMEVCNTVOFF05_EL2", 0xE6C5, true, true,  {AArch64::FeatureAMVS}  }, // 61
  { "AMEVCNTVOFF06_EL2", "AMEVCNTVOFF06_EL2", 0xE6C6, true, true,  {AArch64::FeatureAMVS}  }, // 62
  { "AMEVCNTVOFF07_EL2", "AMEVCNTVOFF07_EL2", 0xE6C7, true, true,  {AArch64::FeatureAMVS}  }, // 63
  { "AMEVCNTVOFF08_EL2", "AMEVCNTVOFF08_EL2", 0xE6C8, true, true,  {AArch64::FeatureAMVS}  }, // 64
  { "AMEVCNTVOFF09_EL2", "AMEVCNTVOFF09_EL2", 0xE6C9, true, true,  {AArch64::FeatureAMVS}  }, // 65
  { "AMEVCNTVOFF10_EL2", "AMEVCNTVOFF10_EL2", 0xE6D0, true, true,  {AArch64::FeatureAMVS}  }, // 66
  { "AMEVCNTVOFF110_EL2", "AMEVCNTVOFF110_EL2", 0xE6DA, true, true,  {AArch64::FeatureAMVS}  }, // 67
  { "AMEVCNTVOFF111_EL2", "AMEVCNTVOFF111_EL2", 0xE6DB, true, true,  {AArch64::FeatureAMVS}  }, // 68
  { "AMEVCNTVOFF112_EL2", "AMEVCNTVOFF112_EL2", 0xE6DC, true, true,  {AArch64::FeatureAMVS}  }, // 69
  { "AMEVCNTVOFF113_EL2", "AMEVCNTVOFF113_EL2", 0xE6DD, true, true,  {AArch64::FeatureAMVS}  }, // 70
  { "AMEVCNTVOFF114_EL2", "AMEVCNTVOFF114_EL2", 0xE6DE, true, true,  {AArch64::FeatureAMVS}  }, // 71
  { "AMEVCNTVOFF115_EL2", "AMEVCNTVOFF115_EL2", 0xE6DF, true, true,  {AArch64::FeatureAMVS}  }, // 72
  { "AMEVCNTVOFF11_EL2", "AMEVCNTVOFF11_EL2", 0xE6D1, true, true,  {AArch64::FeatureAMVS}  }, // 73
  { "AMEVCNTVOFF12_EL2", "AMEVCNTVOFF12_EL2", 0xE6D2, true, true,  {AArch64::FeatureAMVS}  }, // 74
  { "AMEVCNTVOFF13_EL2", "AMEVCNTVOFF13_EL2", 0xE6D3, true, true,  {AArch64::FeatureAMVS}  }, // 75
  { "AMEVCNTVOFF14_EL2", "AMEVCNTVOFF14_EL2", 0xE6D4, true, true,  {AArch64::FeatureAMVS}  }, // 76
  { "AMEVCNTVOFF15_EL2", "AMEVCNTVOFF15_EL2", 0xE6D5, true, true,  {AArch64::FeatureAMVS}  }, // 77
  { "AMEVCNTVOFF16_EL2", "AMEVCNTVOFF16_EL2", 0xE6D6, true, true,  {AArch64::FeatureAMVS}  }, // 78
  { "AMEVCNTVOFF17_EL2", "AMEVCNTVOFF17_EL2", 0xE6D7, true, true,  {AArch64::FeatureAMVS}  }, // 79
  { "AMEVCNTVOFF18_EL2", "AMEVCNTVOFF18_EL2", 0xE6D8, true, true,  {AArch64::FeatureAMVS}  }, // 80
  { "AMEVCNTVOFF19_EL2", "AMEVCNTVOFF19_EL2", 0xE6D9, true, true,  {AArch64::FeatureAMVS}  }, // 81
  { "AMEVTYPER00_EL0", "AMEVTYPER00_EL0", 0xDEB0, true, false,  {AArch64::FeatureAM}  }, // 82
  { "AMEVTYPER01_EL0", "AMEVTYPER01_EL0", 0xDEB1, true, false,  {AArch64::FeatureAM}  }, // 83
  { "AMEVTYPER02_EL0", "AMEVTYPER02_EL0", 0xDEB2, true, false,  {AArch64::FeatureAM}  }, // 84
  { "AMEVTYPER03_EL0", "AMEVTYPER03_EL0", 0xDEB3, true, false,  {AArch64::FeatureAM}  }, // 85
  { "AMEVTYPER10_EL0", "AMEVTYPER10_EL0", 0xDEF0, true, true,  {AArch64::FeatureAM}  }, // 86
  { "AMEVTYPER110_EL0", "AMEVTYPER110_EL0", 0xDEFA, true, true,  {AArch64::FeatureAM}  }, // 87
  { "AMEVTYPER111_EL0", "AMEVTYPER111_EL0", 0xDEFB, true, true,  {AArch64::FeatureAM}  }, // 88
  { "AMEVTYPER112_EL0", "AMEVTYPER112_EL0", 0xDEFC, true, true,  {AArch64::FeatureAM}  }, // 89
  { "AMEVTYPER113_EL0", "AMEVTYPER113_EL0", 0xDEFD, true, true,  {AArch64::FeatureAM}  }, // 90
  { "AMEVTYPER114_EL0", "AMEVTYPER114_EL0", 0xDEFE, true, true,  {AArch64::FeatureAM}  }, // 91
  { "AMEVTYPER115_EL0", "AMEVTYPER115_EL0", 0xDEFF, true, true,  {AArch64::FeatureAM}  }, // 92
  { "AMEVTYPER11_EL0", "AMEVTYPER11_EL0", 0xDEF1, true, true,  {AArch64::FeatureAM}  }, // 93
  { "AMEVTYPER12_EL0", "AMEVTYPER12_EL0", 0xDEF2, true, true,  {AArch64::FeatureAM}  }, // 94
  { "AMEVTYPER13_EL0", "AMEVTYPER13_EL0", 0xDEF3, true, true,  {AArch64::FeatureAM}  }, // 95
  { "AMEVTYPER14_EL0", "AMEVTYPER14_EL0", 0xDEF4, true, true,  {AArch64::FeatureAM}  }, // 96
  { "AMEVTYPER15_EL0", "AMEVTYPER15_EL0", 0xDEF5, true, true,  {AArch64::FeatureAM}  }, // 97
  { "AMEVTYPER16_EL0", "AMEVTYPER16_EL0", 0xDEF6, true, true,  {AArch64::FeatureAM}  }, // 98
  { "AMEVTYPER17_EL0", "AMEVTYPER17_EL0", 0xDEF7, true, true,  {AArch64::FeatureAM}  }, // 99
  { "AMEVTYPER18_EL0", "AMEVTYPER18_EL0", 0xDEF8, true, true,  {AArch64::FeatureAM}  }, // 100
  { "AMEVTYPER19_EL0", "AMEVTYPER19_EL0", 0xDEF9, true, true,  {AArch64::FeatureAM}  }, // 101
  { "AMUSERENR_EL0", "AMUSERENR_EL0", 0xDE93, true, true,  {AArch64::FeatureAM}  }, // 102
  { "APDAKeyHi_EL1", "APDAKeyHi_EL1", 0xC111, true, true,  {AArch64::FeaturePAuth}  }, // 103
  { "APDAKeyLo_EL1", "APDAKeyLo_EL1", 0xC110, true, true,  {AArch64::FeaturePAuth}  }, // 104
  { "APDBKeyHi_EL1", "APDBKeyHi_EL1", 0xC113, true, true,  {AArch64::FeaturePAuth}  }, // 105
  { "APDBKeyLo_EL1", "APDBKeyLo_EL1", 0xC112, true, true,  {AArch64::FeaturePAuth}  }, // 106
  { "APGAKeyHi_EL1", "APGAKeyHi_EL1", 0xC119, true, true,  {AArch64::FeaturePAuth}  }, // 107
  { "APGAKeyLo_EL1", "APGAKeyLo_EL1", 0xC118, true, true,  {AArch64::FeaturePAuth}  }, // 108
  { "APIAKeyHi_EL1", "APIAKeyHi_EL1", 0xC109, true, true,  {AArch64::FeaturePAuth}  }, // 109
  { "APIAKeyLo_EL1", "APIAKeyLo_EL1", 0xC108, true, true,  {AArch64::FeaturePAuth}  }, // 110
  { "APIBKeyHi_EL1", "APIBKeyHi_EL1", 0xC10B, true, true,  {AArch64::FeaturePAuth}  }, // 111
  { "APIBKeyLo_EL1", "APIBKeyLo_EL1", 0xC10A, true, true,  {AArch64::FeaturePAuth}  }, // 112
  { "BRBCR_EL1", "BRBCR_EL1", 0x8C80, true, true,  {AArch64::FeatureBRBE}  }, // 113
  { "BRBCR_EL12", "BRBCR_EL12", 0xAC80, true, true,  {AArch64::FeatureBRBE}  }, // 114
  { "BRBCR_EL2", "BRBCR_EL2", 0xA480, true, true,  {AArch64::FeatureBRBE}  }, // 115
  { "BRBFCR_EL1", "BRBFCR_EL1", 0x8C81, true, true,  {AArch64::FeatureBRBE}  }, // 116
  { "BRBIDR0_EL1", "BRBIDR0_EL1", 0x8C90, true, false,  {AArch64::FeatureBRBE}  }, // 117
  { "BRBINF0_EL1", "BRBINF0_EL1", 0x8C00, true, false,  {AArch64::FeatureBRBE}  }, // 118
  { "BRBINF10_EL1", "BRBINF10_EL1", 0x8C50, true, false,  {AArch64::FeatureBRBE}  }, // 119
  { "BRBINF11_EL1", "BRBINF11_EL1", 0x8C58, true, false,  {AArch64::FeatureBRBE}  }, // 120
  { "BRBINF12_EL1", "BRBINF12_EL1", 0x8C60, true, false,  {AArch64::FeatureBRBE}  }, // 121
  { "BRBINF13_EL1", "BRBINF13_EL1", 0x8C68, true, false,  {AArch64::FeatureBRBE}  }, // 122
  { "BRBINF14_EL1", "BRBINF14_EL1", 0x8C70, true, false,  {AArch64::FeatureBRBE}  }, // 123
  { "BRBINF15_EL1", "BRBINF15_EL1", 0x8C78, true, false,  {AArch64::FeatureBRBE}  }, // 124
  { "BRBINF16_EL1", "BRBINF16_EL1", 0x8C04, true, false,  {AArch64::FeatureBRBE}  }, // 125
  { "BRBINF17_EL1", "BRBINF17_EL1", 0x8C0C, true, false,  {AArch64::FeatureBRBE}  }, // 126
  { "BRBINF18_EL1", "BRBINF18_EL1", 0x8C14, true, false,  {AArch64::FeatureBRBE}  }, // 127
  { "BRBINF19_EL1", "BRBINF19_EL1", 0x8C1C, true, false,  {AArch64::FeatureBRBE}  }, // 128
  { "BRBINF1_EL1", "BRBINF1_EL1", 0x8C08, true, false,  {AArch64::FeatureBRBE}  }, // 129
  { "BRBINF20_EL1", "BRBINF20_EL1", 0x8C24, true, false,  {AArch64::FeatureBRBE}  }, // 130
  { "BRBINF21_EL1", "BRBINF21_EL1", 0x8C2C, true, false,  {AArch64::FeatureBRBE}  }, // 131
  { "BRBINF22_EL1", "BRBINF22_EL1", 0x8C34, true, false,  {AArch64::FeatureBRBE}  }, // 132
  { "BRBINF23_EL1", "BRBINF23_EL1", 0x8C3C, true, false,  {AArch64::FeatureBRBE}  }, // 133
  { "BRBINF24_EL1", "BRBINF24_EL1", 0x8C44, true, false,  {AArch64::FeatureBRBE}  }, // 134
  { "BRBINF25_EL1", "BRBINF25_EL1", 0x8C4C, true, false,  {AArch64::FeatureBRBE}  }, // 135
  { "BRBINF26_EL1", "BRBINF26_EL1", 0x8C54, true, false,  {AArch64::FeatureBRBE}  }, // 136
  { "BRBINF27_EL1", "BRBINF27_EL1", 0x8C5C, true, false,  {AArch64::FeatureBRBE}  }, // 137
  { "BRBINF28_EL1", "BRBINF28_EL1", 0x8C64, true, false,  {AArch64::FeatureBRBE}  }, // 138
  { "BRBINF29_EL1", "BRBINF29_EL1", 0x8C6C, true, false,  {AArch64::FeatureBRBE}  }, // 139
  { "BRBINF2_EL1", "BRBINF2_EL1", 0x8C10, true, false,  {AArch64::FeatureBRBE}  }, // 140
  { "BRBINF30_EL1", "BRBINF30_EL1", 0x8C74, true, false,  {AArch64::FeatureBRBE}  }, // 141
  { "BRBINF31_EL1", "BRBINF31_EL1", 0x8C7C, true, false,  {AArch64::FeatureBRBE}  }, // 142
  { "BRBINF3_EL1", "BRBINF3_EL1", 0x8C18, true, false,  {AArch64::FeatureBRBE}  }, // 143
  { "BRBINF4_EL1", "BRBINF4_EL1", 0x8C20, true, false,  {AArch64::FeatureBRBE}  }, // 144
  { "BRBINF5_EL1", "BRBINF5_EL1", 0x8C28, true, false,  {AArch64::FeatureBRBE}  }, // 145
  { "BRBINF6_EL1", "BRBINF6_EL1", 0x8C30, true, false,  {AArch64::FeatureBRBE}  }, // 146
  { "BRBINF7_EL1", "BRBINF7_EL1", 0x8C38, true, false,  {AArch64::FeatureBRBE}  }, // 147
  { "BRBINF8_EL1", "BRBINF8_EL1", 0x8C40, true, false,  {AArch64::FeatureBRBE}  }, // 148
  { "BRBINF9_EL1", "BRBINF9_EL1", 0x8C48, true, false,  {AArch64::FeatureBRBE}  }, // 149
  { "BRBINFINJ_EL1", "BRBINFINJ_EL1", 0x8C88, true, true,  {AArch64::FeatureBRBE}  }, // 150
  { "BRBSRC0_EL1", "BRBSRC0_EL1", 0x8C01, true, false,  {AArch64::FeatureBRBE}  }, // 151
  { "BRBSRC10_EL1", "BRBSRC10_EL1", 0x8C51, true, false,  {AArch64::FeatureBRBE}  }, // 152
  { "BRBSRC11_EL1", "BRBSRC11_EL1", 0x8C59, true, false,  {AArch64::FeatureBRBE}  }, // 153
  { "BRBSRC12_EL1", "BRBSRC12_EL1", 0x8C61, true, false,  {AArch64::FeatureBRBE}  }, // 154
  { "BRBSRC13_EL1", "BRBSRC13_EL1", 0x8C69, true, false,  {AArch64::FeatureBRBE}  }, // 155
  { "BRBSRC14_EL1", "BRBSRC14_EL1", 0x8C71, true, false,  {AArch64::FeatureBRBE}  }, // 156
  { "BRBSRC15_EL1", "BRBSRC15_EL1", 0x8C79, true, false,  {AArch64::FeatureBRBE}  }, // 157
  { "BRBSRC16_EL1", "BRBSRC16_EL1", 0x8C05, true, false,  {AArch64::FeatureBRBE}  }, // 158
  { "BRBSRC17_EL1", "BRBSRC17_EL1", 0x8C0D, true, false,  {AArch64::FeatureBRBE}  }, // 159
  { "BRBSRC18_EL1", "BRBSRC18_EL1", 0x8C15, true, false,  {AArch64::FeatureBRBE}  }, // 160
  { "BRBSRC19_EL1", "BRBSRC19_EL1", 0x8C1D, true, false,  {AArch64::FeatureBRBE}  }, // 161
  { "BRBSRC1_EL1", "BRBSRC1_EL1", 0x8C09, true, false,  {AArch64::FeatureBRBE}  }, // 162
  { "BRBSRC20_EL1", "BRBSRC20_EL1", 0x8C25, true, false,  {AArch64::FeatureBRBE}  }, // 163
  { "BRBSRC21_EL1", "BRBSRC21_EL1", 0x8C2D, true, false,  {AArch64::FeatureBRBE}  }, // 164
  { "BRBSRC22_EL1", "BRBSRC22_EL1", 0x8C35, true, false,  {AArch64::FeatureBRBE}  }, // 165
  { "BRBSRC23_EL1", "BRBSRC23_EL1", 0x8C3D, true, false,  {AArch64::FeatureBRBE}  }, // 166
  { "BRBSRC24_EL1", "BRBSRC24_EL1", 0x8C45, true, false,  {AArch64::FeatureBRBE}  }, // 167
  { "BRBSRC25_EL1", "BRBSRC25_EL1", 0x8C4D, true, false,  {AArch64::FeatureBRBE}  }, // 168
  { "BRBSRC26_EL1", "BRBSRC26_EL1", 0x8C55, true, false,  {AArch64::FeatureBRBE}  }, // 169
  { "BRBSRC27_EL1", "BRBSRC27_EL1", 0x8C5D, true, false,  {AArch64::FeatureBRBE}  }, // 170
  { "BRBSRC28_EL1", "BRBSRC28_EL1", 0x8C65, true, false,  {AArch64::FeatureBRBE}  }, // 171
  { "BRBSRC29_EL1", "BRBSRC29_EL1", 0x8C6D, true, false,  {AArch64::FeatureBRBE}  }, // 172
  { "BRBSRC2_EL1", "BRBSRC2_EL1", 0x8C11, true, false,  {AArch64::FeatureBRBE}  }, // 173
  { "BRBSRC30_EL1", "BRBSRC30_EL1", 0x8C75, true, false,  {AArch64::FeatureBRBE}  }, // 174
  { "BRBSRC31_EL1", "BRBSRC31_EL1", 0x8C7D, true, false,  {AArch64::FeatureBRBE}  }, // 175
  { "BRBSRC3_EL1", "BRBSRC3_EL1", 0x8C19, true, false,  {AArch64::FeatureBRBE}  }, // 176
  { "BRBSRC4_EL1", "BRBSRC4_EL1", 0x8C21, true, false,  {AArch64::FeatureBRBE}  }, // 177
  { "BRBSRC5_EL1", "BRBSRC5_EL1", 0x8C29, true, false,  {AArch64::FeatureBRBE}  }, // 178
  { "BRBSRC6_EL1", "BRBSRC6_EL1", 0x8C31, true, false,  {AArch64::FeatureBRBE}  }, // 179
  { "BRBSRC7_EL1", "BRBSRC7_EL1", 0x8C39, true, false,  {AArch64::FeatureBRBE}  }, // 180
  { "BRBSRC8_EL1", "BRBSRC8_EL1", 0x8C41, true, false,  {AArch64::FeatureBRBE}  }, // 181
  { "BRBSRC9_EL1", "BRBSRC9_EL1", 0x8C49, true, false,  {AArch64::FeatureBRBE}  }, // 182
  { "BRBSRCINJ_EL1", "BRBSRCINJ_EL1", 0x8C89, true, true,  {AArch64::FeatureBRBE}  }, // 183
  { "BRBTGT0_EL1", "BRBTGT0_EL1", 0x8C02, true, false,  {AArch64::FeatureBRBE}  }, // 184
  { "BRBTGT10_EL1", "BRBTGT10_EL1", 0x8C52, true, false,  {AArch64::FeatureBRBE}  }, // 185
  { "BRBTGT11_EL1", "BRBTGT11_EL1", 0x8C5A, true, false,  {AArch64::FeatureBRBE}  }, // 186
  { "BRBTGT12_EL1", "BRBTGT12_EL1", 0x8C62, true, false,  {AArch64::FeatureBRBE}  }, // 187
  { "BRBTGT13_EL1", "BRBTGT13_EL1", 0x8C6A, true, false,  {AArch64::FeatureBRBE}  }, // 188
  { "BRBTGT14_EL1", "BRBTGT14_EL1", 0x8C72, true, false,  {AArch64::FeatureBRBE}  }, // 189
  { "BRBTGT15_EL1", "BRBTGT15_EL1", 0x8C7A, true, false,  {AArch64::FeatureBRBE}  }, // 190
  { "BRBTGT16_EL1", "BRBTGT16_EL1", 0x8C06, true, false,  {AArch64::FeatureBRBE}  }, // 191
  { "BRBTGT17_EL1", "BRBTGT17_EL1", 0x8C0E, true, false,  {AArch64::FeatureBRBE}  }, // 192
  { "BRBTGT18_EL1", "BRBTGT18_EL1", 0x8C16, true, false,  {AArch64::FeatureBRBE}  }, // 193
  { "BRBTGT19_EL1", "BRBTGT19_EL1", 0x8C1E, true, false,  {AArch64::FeatureBRBE}  }, // 194
  { "BRBTGT1_EL1", "BRBTGT1_EL1", 0x8C0A, true, false,  {AArch64::FeatureBRBE}  }, // 195
  { "BRBTGT20_EL1", "BRBTGT20_EL1", 0x8C26, true, false,  {AArch64::FeatureBRBE}  }, // 196
  { "BRBTGT21_EL1", "BRBTGT21_EL1", 0x8C2E, true, false,  {AArch64::FeatureBRBE}  }, // 197
  { "BRBTGT22_EL1", "BRBTGT22_EL1", 0x8C36, true, false,  {AArch64::FeatureBRBE}  }, // 198
  { "BRBTGT23_EL1", "BRBTGT23_EL1", 0x8C3E, true, false,  {AArch64::FeatureBRBE}  }, // 199
  { "BRBTGT24_EL1", "BRBTGT24_EL1", 0x8C46, true, false,  {AArch64::FeatureBRBE}  }, // 200
  { "BRBTGT25_EL1", "BRBTGT25_EL1", 0x8C4E, true, false,  {AArch64::FeatureBRBE}  }, // 201
  { "BRBTGT26_EL1", "BRBTGT26_EL1", 0x8C56, true, false,  {AArch64::FeatureBRBE}  }, // 202
  { "BRBTGT27_EL1", "BRBTGT27_EL1", 0x8C5E, true, false,  {AArch64::FeatureBRBE}  }, // 203
  { "BRBTGT28_EL1", "BRBTGT28_EL1", 0x8C66, true, false,  {AArch64::FeatureBRBE}  }, // 204
  { "BRBTGT29_EL1", "BRBTGT29_EL1", 0x8C6E, true, false,  {AArch64::FeatureBRBE}  }, // 205
  { "BRBTGT2_EL1", "BRBTGT2_EL1", 0x8C12, true, false,  {AArch64::FeatureBRBE}  }, // 206
  { "BRBTGT30_EL1", "BRBTGT30_EL1", 0x8C76, true, false,  {AArch64::FeatureBRBE}  }, // 207
  { "BRBTGT31_EL1", "BRBTGT31_EL1", 0x8C7E, true, false,  {AArch64::FeatureBRBE}  }, // 208
  { "BRBTGT3_EL1", "BRBTGT3_EL1", 0x8C1A, true, false,  {AArch64::FeatureBRBE}  }, // 209
  { "BRBTGT4_EL1", "BRBTGT4_EL1", 0x8C22, true, false,  {AArch64::FeatureBRBE}  }, // 210
  { "BRBTGT5_EL1", "BRBTGT5_EL1", 0x8C2A, true, false,  {AArch64::FeatureBRBE}  }, // 211
  { "BRBTGT6_EL1", "BRBTGT6_EL1", 0x8C32, true, false,  {AArch64::FeatureBRBE}  }, // 212
  { "BRBTGT7_EL1", "BRBTGT7_EL1", 0x8C3A, true, false,  {AArch64::FeatureBRBE}  }, // 213
  { "BRBTGT8_EL1", "BRBTGT8_EL1", 0x8C42, true, false,  {AArch64::FeatureBRBE}  }, // 214
  { "BRBTGT9_EL1", "BRBTGT9_EL1", 0x8C4A, true, false,  {AArch64::FeatureBRBE}  }, // 215
  { "BRBTGTINJ_EL1", "BRBTGTINJ_EL1", 0x8C8A, true, true,  {AArch64::FeatureBRBE}  }, // 216
  { "BRBTS_EL1", "BRBTS_EL1", 0x8C82, true, true,  {AArch64::FeatureBRBE}  }, // 217
  { "CCSIDR2_EL1", "CCSIDR2_EL1", 0xC802, true, false,  {AArch64::FeatureCCIDX}  }, // 218
  { "CCSIDR_EL1", "CCSIDR_EL1", 0xC800, true, false,  {}  }, // 219
  { "CLIDR_EL1", "CLIDR_EL1", 0xC801, true, false,  {}  }, // 220
  { "CNTFRQ_EL0", "CNTFRQ_EL0", 0xDF00, true, true,  {}  }, // 221
  { "CNTHCTL_EL2", "CNTHCTL_EL2", 0xE708, true, true,  {}  }, // 222
  { "CNTHPS_CTL_EL2", "CNTHPS_CTL_EL2", 0xE729, true, true,  {AArch64::FeatureSEL2}  }, // 223
  { "CNTHPS_CVAL_EL2", "CNTHPS_CVAL_EL2", 0xE72A, true, true,  {AArch64::FeatureSEL2}  }, // 224
  { "CNTHPS_TVAL_EL2", "CNTHPS_TVAL_EL2", 0xE728, true, true,  {AArch64::FeatureSEL2}  }, // 225
  { "CNTHP_CTL_EL2", "CNTHP_CTL_EL2", 0xE711, true, true,  {}  }, // 226
  { "CNTHP_CVAL_EL2", "CNTHP_CVAL_EL2", 0xE712, true, true,  {}  }, // 227
  { "CNTHP_TVAL_EL2", "CNTHP_TVAL_EL2", 0xE710, true, true,  {}  }, // 228
  { "CNTHVS_CTL_EL2", "CNTHVS_CTL_EL2", 0xE721, true, true,  {AArch64::FeatureSEL2}  }, // 229
  { "CNTHVS_CVAL_EL2", "CNTHVS_CVAL_EL2", 0xE722, true, true,  {AArch64::FeatureSEL2}  }, // 230
  { "CNTHVS_TVAL_EL2", "CNTHVS_TVAL_EL2", 0xE720, true, true,  {AArch64::FeatureSEL2}  }, // 231
  { "CNTHV_CTL_EL2", "CNTHV_CTL_EL2", 0xE719, true, true,  {AArch64::FeatureVH}  }, // 232
  { "CNTHV_CVAL_EL2", "CNTHV_CVAL_EL2", 0xE71A, true, true,  {AArch64::FeatureVH}  }, // 233
  { "CNTHV_TVAL_EL2", "CNTHV_TVAL_EL2", 0xE718, true, true,  {AArch64::FeatureVH}  }, // 234
  { "CNTISCALE_EL2", "CNTISCALE_EL2", 0xE705, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 235
  { "CNTKCTL_EL1", "CNTKCTL_EL1", 0xC708, true, true,  {}  }, // 236
  { "CNTKCTL_EL12", "CNTKCTL_EL12", 0xEF08, true, true,  {AArch64::FeatureVH}  }, // 237
  { "CNTPCTSS_EL0", "CNTPCTSS_EL0", 0xDF05, true, false,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 238
  { "CNTPCT_EL0", "CNTPCT_EL0", 0xDF01, true, false,  {}  }, // 239
  { "CNTPOFF_EL2", "CNTPOFF_EL2", 0xE706, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 240
  { "CNTPS_CTL_EL1", "CNTPS_CTL_EL1", 0xFF11, true, true,  {}  }, // 241
  { "CNTPS_CVAL_EL1", "CNTPS_CVAL_EL1", 0xFF12, true, true,  {}  }, // 242
  { "CNTPS_TVAL_EL1", "CNTPS_TVAL_EL1", 0xFF10, true, true,  {}  }, // 243
  { "CNTP_CTL_EL0", "CNTP_CTL_EL0", 0xDF11, true, true,  {}  }, // 244
  { "CNTP_CTL_EL02", "CNTP_CTL_EL02", 0xEF11, true, true,  {AArch64::FeatureVH}  }, // 245
  { "CNTP_CVAL_EL0", "CNTP_CVAL_EL0", 0xDF12, true, true,  {}  }, // 246
  { "CNTP_CVAL_EL02", "CNTP_CVAL_EL02", 0xEF12, true, true,  {AArch64::FeatureVH}  }, // 247
  { "CNTP_TVAL_EL0", "CNTP_TVAL_EL0", 0xDF10, true, true,  {}  }, // 248
  { "CNTP_TVAL_EL02", "CNTP_TVAL_EL02", 0xEF10, true, true,  {AArch64::FeatureVH}  }, // 249
  { "CNTSCALE_EL2", "CNTSCALE_EL2", 0xE704, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 250
  { "CNTVCTSS_EL0", "CNTVCTSS_EL0", 0xDF06, true, false,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 251
  { "CNTVCT_EL0", "CNTVCT_EL0", 0xDF02, true, false,  {}  }, // 252
  { "CNTVFRQ_EL2", "CNTVFRQ_EL2", 0xE707, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 253
  { "CNTVOFF_EL2", "CNTVOFF_EL2", 0xE703, true, true,  {}  }, // 254
  { "CNTV_CTL_EL0", "CNTV_CTL_EL0", 0xDF19, true, true,  {}  }, // 255
  { "CNTV_CTL_EL02", "CNTV_CTL_EL02", 0xEF19, true, true,  {AArch64::FeatureVH}  }, // 256
  { "CNTV_CVAL_EL0", "CNTV_CVAL_EL0", 0xDF1A, true, true,  {}  }, // 257
  { "CNTV_CVAL_EL02", "CNTV_CVAL_EL02", 0xEF1A, true, true,  {AArch64::FeatureVH}  }, // 258
  { "CNTV_TVAL_EL0", "CNTV_TVAL_EL0", 0xDF18, true, true,  {}  }, // 259
  { "CNTV_TVAL_EL02", "CNTV_TVAL_EL02", 0xEF18, true, true,  {AArch64::FeatureVH}  }, // 260
  { "CONTEXTIDR_EL1", "CONTEXTIDR_EL1", 0xC681, true, true,  {}  }, // 261
  { "CONTEXTIDR_EL12", "CONTEXTIDR_EL12", 0xEE81, true, true,  {AArch64::FeatureVH}  }, // 262
  { "CONTEXTIDR_EL2", "CONTEXTIDR_EL2", 0xE681, true, true,  {AArch64::FeatureCONTEXTIDREL2}  }, // 263
  { "CPACR_EL1", "CPACR_EL1", 0xC082, true, true,  {}  }, // 264
  { "CPACR_EL12", "CPACR_EL12", 0xE882, true, true,  {AArch64::FeatureVH}  }, // 265
  { "CPM_IOACC_CTL_EL3", "CPM_IOACC_CTL_EL3", 0xFF90, true, true,  {AArch64::FeatureAppleA7SysReg}  }, // 266
  { "CPTR_EL2", "CPTR_EL2", 0xE08A, true, true,  {}  }, // 267
  { "CPTR_EL3", "CPTR_EL3", 0xF08A, true, true,  {}  }, // 268
  { "CSSELR_EL1", "CSSELR_EL1", 0xD000, true, true,  {}  }, // 269
  { "CTR_EL0", "CTR_EL0", 0xD801, true, false,  {}  }, // 270
  { "CurrentEL", "CurrentEL", 0xC212, true, false,  {}  }, // 271
  { "DACR32_EL2", "DACR32_EL2", 0xE180, true, true,  {}  }, // 272
  { "DAIF", "DAIF", 0xDA11, true, true,  {}  }, // 273
  { "DBGAUTHSTATUS_EL1", "DBGAUTHSTATUS_EL1", 0x83F6, true, false,  {}  }, // 274
  { "DBGBCR0_EL1", "DBGBCR0_EL1", 0x8005, true, true,  {}  }, // 275
  { "DBGBCR10_EL1", "DBGBCR10_EL1", 0x8055, true, true,  {}  }, // 276
  { "DBGBCR11_EL1", "DBGBCR11_EL1", 0x805D, true, true,  {}  }, // 277
  { "DBGBCR12_EL1", "DBGBCR12_EL1", 0x8065, true, true,  {}  }, // 278
  { "DBGBCR13_EL1", "DBGBCR13_EL1", 0x806D, true, true,  {}  }, // 279
  { "DBGBCR14_EL1", "DBGBCR14_EL1", 0x8075, true, true,  {}  }, // 280
  { "DBGBCR15_EL1", "DBGBCR15_EL1", 0x807D, true, true,  {}  }, // 281
  { "DBGBCR1_EL1", "DBGBCR1_EL1", 0x800D, true, true,  {}  }, // 282
  { "DBGBCR2_EL1", "DBGBCR2_EL1", 0x8015, true, true,  {}  }, // 283
  { "DBGBCR3_EL1", "DBGBCR3_EL1", 0x801D, true, true,  {}  }, // 284
  { "DBGBCR4_EL1", "DBGBCR4_EL1", 0x8025, true, true,  {}  }, // 285
  { "DBGBCR5_EL1", "DBGBCR5_EL1", 0x802D, true, true,  {}  }, // 286
  { "DBGBCR6_EL1", "DBGBCR6_EL1", 0x8035, true, true,  {}  }, // 287
  { "DBGBCR7_EL1", "DBGBCR7_EL1", 0x803D, true, true,  {}  }, // 288
  { "DBGBCR8_EL1", "DBGBCR8_EL1", 0x8045, true, true,  {}  }, // 289
  { "DBGBCR9_EL1", "DBGBCR9_EL1", 0x804D, true, true,  {}  }, // 290
  { "DBGBVR0_EL1", "DBGBVR0_EL1", 0x8004, true, true,  {}  }, // 291
  { "DBGBVR10_EL1", "DBGBVR10_EL1", 0x8054, true, true,  {}  }, // 292
  { "DBGBVR11_EL1", "DBGBVR11_EL1", 0x805C, true, true,  {}  }, // 293
  { "DBGBVR12_EL1", "DBGBVR12_EL1", 0x8064, true, true,  {}  }, // 294
  { "DBGBVR13_EL1", "DBGBVR13_EL1", 0x806C, true, true,  {}  }, // 295
  { "DBGBVR14_EL1", "DBGBVR14_EL1", 0x8074, true, true,  {}  }, // 296
  { "DBGBVR15_EL1", "DBGBVR15_EL1", 0x807C, true, true,  {}  }, // 297
  { "DBGBVR1_EL1", "DBGBVR1_EL1", 0x800C, true, true,  {}  }, // 298
  { "DBGBVR2_EL1", "DBGBVR2_EL1", 0x8014, true, true,  {}  }, // 299
  { "DBGBVR3_EL1", "DBGBVR3_EL1", 0x801C, true, true,  {}  }, // 300
  { "DBGBVR4_EL1", "DBGBVR4_EL1", 0x8024, true, true,  {}  }, // 301
  { "DBGBVR5_EL1", "DBGBVR5_EL1", 0x802C, true, true,  {}  }, // 302
  { "DBGBVR6_EL1", "DBGBVR6_EL1", 0x8034, true, true,  {}  }, // 303
  { "DBGBVR7_EL1", "DBGBVR7_EL1", 0x803C, true, true,  {}  }, // 304
  { "DBGBVR8_EL1", "DBGBVR8_EL1", 0x8044, true, true,  {}  }, // 305
  { "DBGBVR9_EL1", "DBGBVR9_EL1", 0x804C, true, true,  {}  }, // 306
  { "DBGCLAIMCLR_EL1", "DBGCLAIMCLR_EL1", 0x83CE, true, true,  {}  }, // 307
  { "DBGCLAIMSET_EL1", "DBGCLAIMSET_EL1", 0x83C6, true, true,  {}  }, // 308
  { "DBGDTRRX_EL0", "DBGDTRRX_EL0", 0x9828, true, false,  {}  }, // 309
  { "DBGDTRTX_EL0", "DBGDTRTX_EL0", 0x9828, false, true,  {}  }, // 310
  { "DBGDTR_EL0", "DBGDTR_EL0", 0x9820, true, true,  {}  }, // 311
  { "DBGPRCR_EL1", "DBGPRCR_EL1", 0x80A4, true, true,  {}  }, // 312
  { "DBGVCR32_EL2", "DBGVCR32_EL2", 0xA038, true, true,  {}  }, // 313
  { "DBGWCR0_EL1", "DBGWCR0_EL1", 0x8007, true, true,  {}  }, // 314
  { "DBGWCR10_EL1", "DBGWCR10_EL1", 0x8057, true, true,  {}  }, // 315
  { "DBGWCR11_EL1", "DBGWCR11_EL1", 0x805F, true, true,  {}  }, // 316
  { "DBGWCR12_EL1", "DBGWCR12_EL1", 0x8067, true, true,  {}  }, // 317
  { "DBGWCR13_EL1", "DBGWCR13_EL1", 0x806F, true, true,  {}  }, // 318
  { "DBGWCR14_EL1", "DBGWCR14_EL1", 0x8077, true, true,  {}  }, // 319
  { "DBGWCR15_EL1", "DBGWCR15_EL1", 0x807F, true, true,  {}  }, // 320
  { "DBGWCR1_EL1", "DBGWCR1_EL1", 0x800F, true, true,  {}  }, // 321
  { "DBGWCR2_EL1", "DBGWCR2_EL1", 0x8017, true, true,  {}  }, // 322
  { "DBGWCR3_EL1", "DBGWCR3_EL1", 0x801F, true, true,  {}  }, // 323
  { "DBGWCR4_EL1", "DBGWCR4_EL1", 0x8027, true, true,  {}  }, // 324
  { "DBGWCR5_EL1", "DBGWCR5_EL1", 0x802F, true, true,  {}  }, // 325
  { "DBGWCR6_EL1", "DBGWCR6_EL1", 0x8037, true, true,  {}  }, // 326
  { "DBGWCR7_EL1", "DBGWCR7_EL1", 0x803F, true, true,  {}  }, // 327
  { "DBGWCR8_EL1", "DBGWCR8_EL1", 0x8047, true, true,  {}  }, // 328
  { "DBGWCR9_EL1", "DBGWCR9_EL1", 0x804F, true, true,  {}  }, // 329
  { "DBGWVR0_EL1", "DBGWVR0_EL1", 0x8006, true, true,  {}  }, // 330
  { "DBGWVR10_EL1", "DBGWVR10_EL1", 0x8056, true, true,  {}  }, // 331
  { "DBGWVR11_EL1", "DBGWVR11_EL1", 0x805E, true, true,  {}  }, // 332
  { "DBGWVR12_EL1", "DBGWVR12_EL1", 0x8066, true, true,  {}  }, // 333
  { "DBGWVR13_EL1", "DBGWVR13_EL1", 0x806E, true, true,  {}  }, // 334
  { "DBGWVR14_EL1", "DBGWVR14_EL1", 0x8076, true, true,  {}  }, // 335
  { "DBGWVR15_EL1", "DBGWVR15_EL1", 0x807E, true, true,  {}  }, // 336
  { "DBGWVR1_EL1", "DBGWVR1_EL1", 0x800E, true, true,  {}  }, // 337
  { "DBGWVR2_EL1", "DBGWVR2_EL1", 0x8016, true, true,  {}  }, // 338
  { "DBGWVR3_EL1", "DBGWVR3_EL1", 0x801E, true, true,  {}  }, // 339
  { "DBGWVR4_EL1", "DBGWVR4_EL1", 0x8026, true, true,  {}  }, // 340
  { "DBGWVR5_EL1", "DBGWVR5_EL1", 0x802E, true, true,  {}  }, // 341
  { "DBGWVR6_EL1", "DBGWVR6_EL1", 0x8036, true, true,  {}  }, // 342
  { "DBGWVR7_EL1", "DBGWVR7_EL1", 0x803E, true, true,  {}  }, // 343
  { "DBGWVR8_EL1", "DBGWVR8_EL1", 0x8046, true, true,  {}  }, // 344
  { "DBGWVR9_EL1", "DBGWVR9_EL1", 0x804E, true, true,  {}  }, // 345
  { "DCZID_EL0", "DCZID_EL0", 0xD807, true, false,  {}  }, // 346
  { "DISR_EL1", "DISR_EL1", 0xC609, true, true,  {AArch64::FeatureRAS}  }, // 347
  { "DIT", "DIT", 0xDA15, true, true,  {AArch64::FeatureDIT}  }, // 348
  { "DLR_EL0", "DLR_EL0", 0xDA29, true, true,  {}  }, // 349
  { "DSPSR_EL0", "DSPSR_EL0", 0xDA28, true, true,  {}  }, // 350
  { "ELR_EL1", "ELR_EL1", 0xC201, true, true,  {}  }, // 351
  { "ELR_EL12", "ELR_EL12", 0xEA01, true, true,  {AArch64::FeatureVH}  }, // 352
  { "ELR_EL2", "ELR_EL2", 0xE201, true, true,  {}  }, // 353
  { "ELR_EL3", "ELR_EL3", 0xF201, true, true,  {}  }, // 354
  { "ERRIDR_EL1", "ERRIDR_EL1", 0xC298, true, false,  {AArch64::FeatureRAS}  }, // 355
  { "ERRSELR_EL1", "ERRSELR_EL1", 0xC299, true, true,  {AArch64::FeatureRAS}  }, // 356
  { "ERXADDR_EL1", "ERXADDR_EL1", 0xC2A3, true, true,  {AArch64::FeatureRAS}  }, // 357
  { "ERXCTLR_EL1", "ERXCTLR_EL1", 0xC2A1, true, true,  {AArch64::FeatureRAS}  }, // 358
  { "ERXFR_EL1", "ERXFR_EL1", 0xC2A0, true, false,  {AArch64::FeatureRAS}  }, // 359
  { "ERXGSR_EL1", "ERXGSR_EL1", 0xC29A, true, false,  {AArch64::FeatureRASv2}  }, // 360
  { "ERXMISC0_EL1", "ERXMISC0_EL1", 0xC2A8, true, true,  {AArch64::FeatureRAS}  }, // 361
  { "ERXMISC1_EL1", "ERXMISC1_EL1", 0xC2A9, true, true,  {AArch64::FeatureRAS}  }, // 362
  { "ERXMISC2_EL1", "ERXMISC2_EL1", 0xC2AA, true, true,  {}  }, // 363
  { "ERXMISC3_EL1", "ERXMISC3_EL1", 0xC2AB, true, true,  {}  }, // 364
  { "ERXPFGCDN_EL1", "ERXPFGCDN_EL1", 0xC2A6, true, true,  {}  }, // 365
  { "ERXPFGCTL_EL1", "ERXPFGCTL_EL1", 0xC2A5, true, true,  {}  }, // 366
  { "ERXPFGF_EL1", "ERXPFGF_EL1", 0xC2A4, true, false,  {}  }, // 367
  { "ERXSTATUS_EL1", "ERXSTATUS_EL1", 0xC2A2, true, true,  {AArch64::FeatureRAS}  }, // 368
  { "ESR_EL1", "ESR_EL1", 0xC290, true, true,  {}  }, // 369
  { "ESR_EL12", "ESR_EL12", 0xEA90, true, true,  {AArch64::FeatureVH}  }, // 370
  { "ESR_EL2", "ESR_EL2", 0xE290, true, true,  {}  }, // 371
  { "ESR_EL3", "ESR_EL3", 0xF290, true, true,  {}  }, // 372
  { "FAR_EL1", "FAR_EL1", 0xC300, true, true,  {}  }, // 373
  { "FAR_EL12", "FAR_EL12", 0xEB00, true, true,  {AArch64::FeatureVH}  }, // 374
  { "FAR_EL2", "FAR_EL2", 0xE300, true, true,  {}  }, // 375
  { "FAR_EL3", "FAR_EL3", 0xF300, true, true,  {}  }, // 376
  { "FPCR", "FPCR", 0xDA20, true, true,  {}  }, // 377
  { "FPEXC32_EL2", "FPEXC32_EL2", 0xE298, true, true,  {}  }, // 378
  { "FPSR", "FPSR", 0xDA21, true, true,  {}  }, // 379
  { "GCR_EL1", "GCR_EL1", 0xC086, true, true,  {AArch64::FeatureMTE}  }, // 380
  { "GCSCRE0_EL1", "GCSCRE0_EL1", 0xC12A, true, true,  {}  }, // 381
  { "GCSCR_EL1", "GCSCR_EL1", 0xC128, true, true,  {}  }, // 382
  { "GCSCR_EL12", "GCSCR_EL12", 0xE928, true, true,  {}  }, // 383
  { "GCSCR_EL2", "GCSCR_EL2", 0xE128, true, true,  {}  }, // 384
  { "GCSCR_EL3", "GCSCR_EL3", 0xF128, true, true,  {}  }, // 385
  { "GCSPR_EL0", "GCSPR_EL0", 0xD929, true, true,  {}  }, // 386
  { "GCSPR_EL1", "GCSPR_EL1", 0xC129, true, true,  {}  }, // 387
  { "GCSPR_EL12", "GCSPR_EL12", 0xE929, true, true,  {}  }, // 388
  { "GCSPR_EL2", "GCSPR_EL2", 0xE129, true, true,  {}  }, // 389
  { "GCSPR_EL3", "GCSPR_EL3", 0xF129, true, true,  {}  }, // 390
  { "GMID_EL1", "GMID_EL1", 0xC804, true, false,  {AArch64::FeatureMTE}  }, // 391
  { "GPCCR_EL3", "GPCCR_EL3", 0xF10E, true, true,  {AArch64::FeatureRME}  }, // 392
  { "GPTBR_EL3", "GPTBR_EL3", 0xF10C, true, true,  {AArch64::FeatureRME}  }, // 393
  { "HACR_EL2", "HACR_EL2", 0xE08F, true, true,  {}  }, // 394
  { "HAFGRTR_EL2", "HAFGRTR_EL2", 0xE18E, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 395
  { "HCRX_EL2", "HCRX_EL2", 0xE092, true, true,  {AArch64::FeatureHCX}  }, // 396
  { "HCR_EL2", "HCR_EL2", 0xE088, true, true,  {}  }, // 397
  { "HDFGRTR2_EL2", "HDFGRTR2_EL2", 0xE188, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 398
  { "HDFGRTR_EL2", "HDFGRTR_EL2", 0xE18C, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 399
  { "HDFGWTR2_EL2", "HDFGWTR2_EL2", 0xE189, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 400
  { "HDFGWTR_EL2", "HDFGWTR_EL2", 0xE18D, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 401
  { "HFGITR2_EL2", "HFGITR2_EL2", 0xE18F, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 402
  { "HFGITR_EL2", "HFGITR_EL2", 0xE08E, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 403
  { "HFGRTR2_EL2", "HFGRTR2_EL2", 0xE18A, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 404
  { "HFGRTR_EL2", "HFGRTR_EL2", 0xE08C, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 405
  { "HFGWTR2_EL2", "HFGWTR2_EL2", 0xE18B, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 406
  { "HFGWTR_EL2", "HFGWTR_EL2", 0xE08D, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 407
  { "HPFAR_EL2", "HPFAR_EL2", 0xE304, true, true,  {}  }, // 408
  { "HSTR_EL2", "HSTR_EL2", 0xE08B, true, true,  {}  }, // 409
  { "ICC_AP0R0_EL1", "ICC_AP0R0_EL1", 0xC644, true, true,  {}  }, // 410
  { "ICC_AP0R1_EL1", "ICC_AP0R1_EL1", 0xC645, true, true,  {}  }, // 411
  { "ICC_AP0R2_EL1", "ICC_AP0R2_EL1", 0xC646, true, true,  {}  }, // 412
  { "ICC_AP0R3_EL1", "ICC_AP0R3_EL1", 0xC647, true, true,  {}  }, // 413
  { "ICC_AP1R0_EL1", "ICC_AP1R0_EL1", 0xC648, true, true,  {}  }, // 414
  { "ICC_AP1R1_EL1", "ICC_AP1R1_EL1", 0xC649, true, true,  {}  }, // 415
  { "ICC_AP1R2_EL1", "ICC_AP1R2_EL1", 0xC64A, true, true,  {}  }, // 416
  { "ICC_AP1R3_EL1", "ICC_AP1R3_EL1", 0xC64B, true, true,  {}  }, // 417
  { "ICC_ASGI1R_EL1", "ICC_ASGI1R_EL1", 0xC65E, false, true,  {}  }, // 418
  { "ICC_BPR0_EL1", "ICC_BPR0_EL1", 0xC643, true, true,  {}  }, // 419
  { "ICC_BPR1_EL1", "ICC_BPR1_EL1", 0xC663, true, true,  {}  }, // 420
  { "ICC_CTLR_EL1", "ICC_CTLR_EL1", 0xC664, true, true,  {}  }, // 421
  { "ICC_CTLR_EL3", "ICC_CTLR_EL3", 0xF664, true, true,  {}  }, // 422
  { "ICC_DIR_EL1", "ICC_DIR_EL1", 0xC659, false, true,  {}  }, // 423
  { "ICC_EOIR0_EL1", "ICC_EOIR0_EL1", 0xC641, false, true,  {}  }, // 424
  { "ICC_EOIR1_EL1", "ICC_EOIR1_EL1", 0xC661, false, true,  {}  }, // 425
  { "ICC_HPPIR0_EL1", "ICC_HPPIR0_EL1", 0xC642, true, false,  {}  }, // 426
  { "ICC_HPPIR1_EL1", "ICC_HPPIR1_EL1", 0xC662, true, false,  {}  }, // 427
  { "ICC_IAR0_EL1", "ICC_IAR0_EL1", 0xC640, true, false,  {}  }, // 428
  { "ICC_IAR1_EL1", "ICC_IAR1_EL1", 0xC660, true, false,  {}  }, // 429
  { "ICC_IGRPEN0_EL1", "ICC_IGRPEN0_EL1", 0xC666, true, true,  {}  }, // 430
  { "ICC_IGRPEN1_EL1", "ICC_IGRPEN1_EL1", 0xC667, true, true,  {}  }, // 431
  { "ICC_IGRPEN1_EL3", "ICC_IGRPEN1_EL3", 0xF667, true, true,  {}  }, // 432
  { "ICC_NMIAR1_EL1", "ICC_NMIAR1_EL1", 0xC64D, true, false,  {AArch64::FeatureNMI}  }, // 433
  { "ICC_PMR_EL1", "ICC_PMR_EL1", 0xC230, true, true,  {}  }, // 434
  { "ICC_RPR_EL1", "ICC_RPR_EL1", 0xC65B, true, false,  {}  }, // 435
  { "ICC_SGI0R_EL1", "ICC_SGI0R_EL1", 0xC65F, false, true,  {}  }, // 436
  { "ICC_SGI1R_EL1", "ICC_SGI1R_EL1", 0xC65D, false, true,  {}  }, // 437
  { "ICC_SRE_EL1", "ICC_SRE_EL1", 0xC665, true, true,  {}  }, // 438
  { "ICC_SRE_EL2", "ICC_SRE_EL2", 0xE64D, true, true,  {}  }, // 439
  { "ICC_SRE_EL3", "ICC_SRE_EL3", 0xF665, true, true,  {}  }, // 440
  { "ICH_AP0R0_EL2", "ICH_AP0R0_EL2", 0xE640, true, true,  {}  }, // 441
  { "ICH_AP0R1_EL2", "ICH_AP0R1_EL2", 0xE641, true, true,  {}  }, // 442
  { "ICH_AP0R2_EL2", "ICH_AP0R2_EL2", 0xE642, true, true,  {}  }, // 443
  { "ICH_AP0R3_EL2", "ICH_AP0R3_EL2", 0xE643, true, true,  {}  }, // 444
  { "ICH_AP1R0_EL2", "ICH_AP1R0_EL2", 0xE648, true, true,  {}  }, // 445
  { "ICH_AP1R1_EL2", "ICH_AP1R1_EL2", 0xE649, true, true,  {}  }, // 446
  { "ICH_AP1R2_EL2", "ICH_AP1R2_EL2", 0xE64A, true, true,  {}  }, // 447
  { "ICH_AP1R3_EL2", "ICH_AP1R3_EL2", 0xE64B, true, true,  {}  }, // 448
  { "ICH_EISR_EL2", "ICH_EISR_EL2", 0xE65B, true, false,  {}  }, // 449
  { "ICH_ELRSR_EL2", "ICH_ELRSR_EL2", 0xE65D, true, false,  {}  }, // 450
  { "ICH_HCR_EL2", "ICH_HCR_EL2", 0xE658, true, true,  {}  }, // 451
  { "ICH_LR0_EL2", "ICH_LR0_EL2", 0xE660, true, true,  {}  }, // 452
  { "ICH_LR10_EL2", "ICH_LR10_EL2", 0xE66A, true, true,  {}  }, // 453
  { "ICH_LR11_EL2", "ICH_LR11_EL2", 0xE66B, true, true,  {}  }, // 454
  { "ICH_LR12_EL2", "ICH_LR12_EL2", 0xE66C, true, true,  {}  }, // 455
  { "ICH_LR13_EL2", "ICH_LR13_EL2", 0xE66D, true, true,  {}  }, // 456
  { "ICH_LR14_EL2", "ICH_LR14_EL2", 0xE66E, true, true,  {}  }, // 457
  { "ICH_LR15_EL2", "ICH_LR15_EL2", 0xE66F, true, true,  {}  }, // 458
  { "ICH_LR1_EL2", "ICH_LR1_EL2", 0xE661, true, true,  {}  }, // 459
  { "ICH_LR2_EL2", "ICH_LR2_EL2", 0xE662, true, true,  {}  }, // 460
  { "ICH_LR3_EL2", "ICH_LR3_EL2", 0xE663, true, true,  {}  }, // 461
  { "ICH_LR4_EL2", "ICH_LR4_EL2", 0xE664, true, true,  {}  }, // 462
  { "ICH_LR5_EL2", "ICH_LR5_EL2", 0xE665, true, true,  {}  }, // 463
  { "ICH_LR6_EL2", "ICH_LR6_EL2", 0xE666, true, true,  {}  }, // 464
  { "ICH_LR7_EL2", "ICH_LR7_EL2", 0xE667, true, true,  {}  }, // 465
  { "ICH_LR8_EL2", "ICH_LR8_EL2", 0xE668, true, true,  {}  }, // 466
  { "ICH_LR9_EL2", "ICH_LR9_EL2", 0xE669, true, true,  {}  }, // 467
  { "ICH_MISR_EL2", "ICH_MISR_EL2", 0xE65A, true, false,  {}  }, // 468
  { "ICH_VMCR_EL2", "ICH_VMCR_EL2", 0xE65F, true, true,  {}  }, // 469
  { "ICH_VTR_EL2", "ICH_VTR_EL2", 0xE659, true, false,  {}  }, // 470
  { "ID_AA64AFR0_EL1", "ID_AA64AFR0_EL1", 0xC02C, true, false,  {}  }, // 471
  { "ID_AA64AFR1_EL1", "ID_AA64AFR1_EL1", 0xC02D, true, false,  {}  }, // 472
  { "ID_AA64DFR0_EL1", "ID_AA64DFR0_EL1", 0xC028, true, false,  {}  }, // 473
  { "ID_AA64DFR1_EL1", "ID_AA64DFR1_EL1", 0xC029, true, false,  {}  }, // 474
  { "ID_AA64ISAR0_EL1", "ID_AA64ISAR0_EL1", 0xC030, true, false,  {}  }, // 475
  { "ID_AA64ISAR1_EL1", "ID_AA64ISAR1_EL1", 0xC031, true, false,  {}  }, // 476
  { "ID_AA64ISAR2_EL1", "ID_AA64ISAR2_EL1", 0xC032, true, false,  {}  }, // 477
  { "ID_AA64MMFR0_EL1", "ID_AA64MMFR0_EL1", 0xC038, true, false,  {}  }, // 478
  { "ID_AA64MMFR1_EL1", "ID_AA64MMFR1_EL1", 0xC039, true, false,  {}  }, // 479
  { "ID_AA64MMFR2_EL1", "ID_AA64MMFR2_EL1", 0xC03A, true, false,  {}  }, // 480
  { "ID_AA64MMFR3_EL1", "ID_AA64MMFR3_EL1", 0xC03B, true, false,  {}  }, // 481
  { "ID_AA64MMFR4_EL1", "ID_AA64MMFR4_EL1", 0xC03C, true, false,  {}  }, // 482
  { "ID_AA64PFR0_EL1", "ID_AA64PFR0_EL1", 0xC020, true, false,  {}  }, // 483
  { "ID_AA64PFR1_EL1", "ID_AA64PFR1_EL1", 0xC021, true, false,  {}  }, // 484
  { "ID_AA64PFR2_EL1", "ID_AA64PFR2_EL1", 0xC022, true, false,  {}  }, // 485
  { "ID_AA64SMFR0_EL1", "ID_AA64SMFR0_EL1", 0xC025, true, false,  {AArch64::FeatureSME}  }, // 486
  { "ID_AA64ZFR0_EL1", "ID_AA64ZFR0_EL1", 0xC024, true, false,  {AArch64::FeatureSVE}  }, // 487
  { "ID_AFR0_EL1", "ID_AFR0_EL1", 0xC00B, true, false,  {}  }, // 488
  { "ID_DFR0_EL1", "ID_DFR0_EL1", 0xC00A, true, false,  {}  }, // 489
  { "ID_DFR1_EL1", "ID_DFR1_EL1", 0xC01D, true, false,  {}  }, // 490
  { "ID_ISAR0_EL1", "ID_ISAR0_EL1", 0xC010, true, false,  {}  }, // 491
  { "ID_ISAR1_EL1", "ID_ISAR1_EL1", 0xC011, true, false,  {}  }, // 492
  { "ID_ISAR2_EL1", "ID_ISAR2_EL1", 0xC012, true, false,  {}  }, // 493
  { "ID_ISAR3_EL1", "ID_ISAR3_EL1", 0xC013, true, false,  {}  }, // 494
  { "ID_ISAR4_EL1", "ID_ISAR4_EL1", 0xC014, true, false,  {}  }, // 495
  { "ID_ISAR5_EL1", "ID_ISAR5_EL1", 0xC015, true, false,  {}  }, // 496
  { "ID_ISAR6_EL1", "ID_ISAR6_EL1", 0xC017, true, false,  {AArch64::HasV8_2aOps}  }, // 497
  { "ID_MMFR0_EL1", "ID_MMFR0_EL1", 0xC00C, true, false,  {}  }, // 498
  { "ID_MMFR1_EL1", "ID_MMFR1_EL1", 0xC00D, true, false,  {}  }, // 499
  { "ID_MMFR2_EL1", "ID_MMFR2_EL1", 0xC00E, true, false,  {}  }, // 500
  { "ID_MMFR3_EL1", "ID_MMFR3_EL1", 0xC00F, true, false,  {}  }, // 501
  { "ID_MMFR4_EL1", "ID_MMFR4_EL1", 0xC016, true, false,  {}  }, // 502
  { "ID_MMFR5_EL1", "ID_MMFR5_EL1", 0xC01E, true, false,  {}  }, // 503
  { "ID_PFR0_EL1", "ID_PFR0_EL1", 0xC008, true, false,  {}  }, // 504
  { "ID_PFR1_EL1", "ID_PFR1_EL1", 0xC009, true, false,  {}  }, // 505
  { "ID_PFR2_EL1", "ID_PFR2_EL1", 0xC01C, true, false,  {AArch64::FeatureSpecRestrict}  }, // 506
  { "IFSR32_EL2", "IFSR32_EL2", 0xE281, true, true,  {}  }, // 507
  { "ISR_EL1", "ISR_EL1", 0xC608, true, false,  {}  }, // 508
  { "LORC_EL1", "LORC_EL1", 0xC523, true, true,  {AArch64::FeatureLOR}  }, // 509
  { "LOREA_EL1", "LOREA_EL1", 0xC521, true, true,  {AArch64::FeatureLOR}  }, // 510
  { "LORID_EL1", "LORID_EL1", 0xC527, true, false,  {AArch64::FeatureLOR}  }, // 511
  { "LORN_EL1", "LORN_EL1", 0xC522, true, true,  {AArch64::FeatureLOR}  }, // 512
  { "LORSA_EL1", "LORSA_EL1", 0xC520, true, true,  {AArch64::FeatureLOR}  }, // 513
  { "MAIR2_EL1", "MAIR2_EL1", 0xC511, true, true,  {}  }, // 514
  { "MAIR2_EL12", "MAIR2_EL12", 0xED11, true, true,  {}  }, // 515
  { "MAIR2_EL2", "MAIR2_EL2", 0xE509, true, true,  {}  }, // 516
  { "MAIR2_EL3", "MAIR2_EL3", 0xF509, true, true,  {}  }, // 517
  { "MAIR_EL1", "MAIR_EL1", 0xC510, true, true,  {}  }, // 518
  { "MAIR_EL12", "MAIR_EL12", 0xED10, true, true,  {AArch64::FeatureVH}  }, // 519
  { "MAIR_EL2", "MAIR_EL2", 0xE510, true, true,  {}  }, // 520
  { "MAIR_EL3", "MAIR_EL3", 0xF510, true, true,  {}  }, // 521
  { "MDCCINT_EL1", "MDCCINT_EL1", 0x8010, true, true,  {}  }, // 522
  { "MDCCSR_EL0", "MDCCSR_EL0", 0x9808, true, false,  {}  }, // 523
  { "MDCR_EL2", "MDCR_EL2", 0xE089, true, true,  {}  }, // 524
  { "MDCR_EL3", "MDCR_EL3", 0xF099, true, true,  {}  }, // 525
  { "MDRAR_EL1", "MDRAR_EL1", 0x8080, true, false,  {}  }, // 526
  { "MDSCR_EL1", "MDSCR_EL1", 0x8012, true, true,  {}  }, // 527
  { "MDSELR_EL1", "MDSELR_EL1", 0x8022, true, true,  {}  }, // 528
  { "MECIDR_EL2", "MECIDR_EL2", 0xE547, true, false,  {AArch64::FeatureMEC}  }, // 529
  { "MECID_A0_EL2", "MECID_A0_EL2", 0xE541, true, true,  {AArch64::FeatureMEC}  }, // 530
  { "MECID_A1_EL2", "MECID_A1_EL2", 0xE543, true, true,  {AArch64::FeatureMEC}  }, // 531
  { "MECID_P0_EL2", "MECID_P0_EL2", 0xE540, true, true,  {AArch64::FeatureMEC}  }, // 532
  { "MECID_P1_EL2", "MECID_P1_EL2", 0xE542, true, true,  {AArch64::FeatureMEC}  }, // 533
  { "MECID_RL_A_EL3", "MECID_RL_A_EL3", 0xF551, true, true,  {AArch64::FeatureMEC}  }, // 534
  { "MFAR_EL3", "MFAR_EL3", 0xF305, true, true,  {}  }, // 535
  { "MIDR_EL1", "MIDR_EL1", 0xC000, true, false,  {}  }, // 536
  { "MPAM0_EL1", "MPAM0_EL1", 0xC529, true, true,  {AArch64::FeatureMPAM}  }, // 537
  { "MPAM1_EL1", "MPAM1_EL1", 0xC528, true, true,  {AArch64::FeatureMPAM}  }, // 538
  { "MPAM1_EL12", "MPAM1_EL12", 0xED28, true, true,  {AArch64::FeatureMPAM}  }, // 539
  { "MPAM2_EL2", "MPAM2_EL2", 0xE528, true, true,  {AArch64::FeatureMPAM}  }, // 540
  { "MPAM3_EL3", "MPAM3_EL3", 0xF528, true, true,  {AArch64::FeatureMPAM}  }, // 541
  { "MPAMHCR_EL2", "MPAMHCR_EL2", 0xE520, true, true,  {AArch64::FeatureMPAM}  }, // 542
  { "MPAMIDR_EL1", "MPAMIDR_EL1", 0xC524, true, false,  {AArch64::FeatureMPAM}  }, // 543
  { "MPAMSM_EL1", "MPAMSM_EL1", 0xC52B, true, true,  {AArch64::FeatureMPAM, AArch64::FeatureSME}  }, // 544
  { "MPAMVPM0_EL2", "MPAMVPM0_EL2", 0xE530, true, true,  {AArch64::FeatureMPAM}  }, // 545
  { "MPAMVPM1_EL2", "MPAMVPM1_EL2", 0xE531, true, true,  {AArch64::FeatureMPAM}  }, // 546
  { "MPAMVPM2_EL2", "MPAMVPM2_EL2", 0xE532, true, true,  {AArch64::FeatureMPAM}  }, // 547
  { "MPAMVPM3_EL2", "MPAMVPM3_EL2", 0xE533, true, true,  {AArch64::FeatureMPAM}  }, // 548
  { "MPAMVPM4_EL2", "MPAMVPM4_EL2", 0xE534, true, true,  {AArch64::FeatureMPAM}  }, // 549
  { "MPAMVPM5_EL2", "MPAMVPM5_EL2", 0xE535, true, true,  {AArch64::FeatureMPAM}  }, // 550
  { "MPAMVPM6_EL2", "MPAMVPM6_EL2", 0xE536, true, true,  {AArch64::FeatureMPAM}  }, // 551
  { "MPAMVPM7_EL2", "MPAMVPM7_EL2", 0xE537, true, true,  {AArch64::FeatureMPAM}  }, // 552
  { "MPAMVPMV_EL2", "MPAMVPMV_EL2", 0xE521, true, true,  {AArch64::FeatureMPAM}  }, // 553
  { "MPIDR_EL1", "MPIDR_EL1", 0xC005, true, false,  {}  }, // 554
  { "MPUIR_EL1", "MPUIR_EL1", 0xC004, true, true,  {AArch64::HasV8_0rOps}  }, // 555
  { "MPUIR_EL2", "MPUIR_EL2", 0xE004, true, true,  {AArch64::HasV8_0rOps}  }, // 556
  { "MVFR0_EL1", "MVFR0_EL1", 0xC018, true, false,  {}  }, // 557
  { "MVFR1_EL1", "MVFR1_EL1", 0xC019, true, false,  {}  }, // 558
  { "MVFR2_EL1", "MVFR2_EL1", 0xC01A, true, false,  {}  }, // 559
  { "NZCV", "NZCV", 0xDA10, true, true,  {}  }, // 560
  { "OSDLR_EL1", "OSDLR_EL1", 0x809C, true, true,  {}  }, // 561
  { "OSDTRRX_EL1", "OSDTRRX_EL1", 0x8002, true, true,  {}  }, // 562
  { "OSDTRTX_EL1", "OSDTRTX_EL1", 0x801A, true, true,  {}  }, // 563
  { "OSECCR_EL1", "OSECCR_EL1", 0x8032, true, true,  {}  }, // 564
  { "OSLAR_EL1", "OSLAR_EL1", 0x8084, false, true,  {}  }, // 565
  { "OSLSR_EL1", "OSLSR_EL1", 0x808C, true, false,  {}  }, // 566
  { "PAN", "PAN", 0xC213, true, true,  {AArch64::FeaturePAN}  }, // 567
  { "PAR_EL1", "PAR_EL1", 0xC3A0, true, true,  {}  }, // 568
  { "PFAR_EL1", "PFAR_EL1", 0xC305, true, true,  {}  }, // 569
  { "PFAR_EL12", "PFAR_EL12", 0xEB05, true, true,  {}  }, // 570
  { "PFAR_EL2", "PFAR_EL2", 0xE305, true, true,  {}  }, // 571
  { "PIRE0_EL1", "PIRE0_EL1", 0xC512, true, true,  {}  }, // 572
  { "PIRE0_EL12", "PIRE0_EL12", 0xED12, true, true,  {}  }, // 573
  { "PIRE0_EL2", "PIRE0_EL2", 0xE512, true, true,  {}  }, // 574
  { "PIR_EL1", "PIR_EL1", 0xC513, true, true,  {}  }, // 575
  { "PIR_EL12", "PIR_EL12", 0xED13, true, true,  {}  }, // 576
  { "PIR_EL2", "PIR_EL2", 0xE513, true, true,  {}  }, // 577
  { "PIR_EL3", "PIR_EL3", 0xF513, true, true,  {}  }, // 578
  { "PM", "PM", 0xC219, true, true,  {}  }, // 579
  { "PMBIDR_EL1", "PMBIDR_EL1", 0xC4D7, true, false,  {AArch64::FeatureSPE}  }, // 580
  { "PMBLIMITR_EL1", "PMBLIMITR_EL1", 0xC4D0, true, true,  {AArch64::FeatureSPE}  }, // 581
  { "PMBPTR_EL1", "PMBPTR_EL1", 0xC4D1, true, true,  {AArch64::FeatureSPE}  }, // 582
  { "PMBSR_EL1", "PMBSR_EL1", 0xC4D3, true, true,  {AArch64::FeatureSPE}  }, // 583
  { "PMCCFILTR_EL0", "PMCCFILTR_EL0", 0xDF7F, true, true,  {}  }, // 584
  { "PMCCNTR_EL0", "PMCCNTR_EL0", 0xDCE8, true, true,  {}  }, // 585
  { "PMCCNTSVR_EL1", "PMCCNTSVR_EL1", 0x875F, true, false,  {}  }, // 586
  { "PMCEID0_EL0", "PMCEID0_EL0", 0xDCE6, true, false,  {}  }, // 587
  { "PMCEID1_EL0", "PMCEID1_EL0", 0xDCE7, true, false,  {}  }, // 588
  { "PMCNTENCLR_EL0", "PMCNTENCLR_EL0", 0xDCE2, true, true,  {}  }, // 589
  { "PMCNTENSET_EL0", "PMCNTENSET_EL0", 0xDCE1, true, true,  {}  }, // 590
  { "PMCR_EL0", "PMCR_EL0", 0xDCE0, true, true,  {}  }, // 591
  { "PMECR_EL1", "PMECR_EL1", 0xC4F5, true, true,  {}  }, // 592
  { "PMEVCNTR0_EL0", "PMEVCNTR0_EL0", 0xDF40, true, true,  {}  }, // 593
  { "PMEVCNTR10_EL0", "PMEVCNTR10_EL0", 0xDF4A, true, true,  {}  }, // 594
  { "PMEVCNTR11_EL0", "PMEVCNTR11_EL0", 0xDF4B, true, true,  {}  }, // 595
  { "PMEVCNTR12_EL0", "PMEVCNTR12_EL0", 0xDF4C, true, true,  {}  }, // 596
  { "PMEVCNTR13_EL0", "PMEVCNTR13_EL0", 0xDF4D, true, true,  {}  }, // 597
  { "PMEVCNTR14_EL0", "PMEVCNTR14_EL0", 0xDF4E, true, true,  {}  }, // 598
  { "PMEVCNTR15_EL0", "PMEVCNTR15_EL0", 0xDF4F, true, true,  {}  }, // 599
  { "PMEVCNTR16_EL0", "PMEVCNTR16_EL0", 0xDF50, true, true,  {}  }, // 600
  { "PMEVCNTR17_EL0", "PMEVCNTR17_EL0", 0xDF51, true, true,  {}  }, // 601
  { "PMEVCNTR18_EL0", "PMEVCNTR18_EL0", 0xDF52, true, true,  {}  }, // 602
  { "PMEVCNTR19_EL0", "PMEVCNTR19_EL0", 0xDF53, true, true,  {}  }, // 603
  { "PMEVCNTR1_EL0", "PMEVCNTR1_EL0", 0xDF41, true, true,  {}  }, // 604
  { "PMEVCNTR20_EL0", "PMEVCNTR20_EL0", 0xDF54, true, true,  {}  }, // 605
  { "PMEVCNTR21_EL0", "PMEVCNTR21_EL0", 0xDF55, true, true,  {}  }, // 606
  { "PMEVCNTR22_EL0", "PMEVCNTR22_EL0", 0xDF56, true, true,  {}  }, // 607
  { "PMEVCNTR23_EL0", "PMEVCNTR23_EL0", 0xDF57, true, true,  {}  }, // 608
  { "PMEVCNTR24_EL0", "PMEVCNTR24_EL0", 0xDF58, true, true,  {}  }, // 609
  { "PMEVCNTR25_EL0", "PMEVCNTR25_EL0", 0xDF59, true, true,  {}  }, // 610
  { "PMEVCNTR26_EL0", "PMEVCNTR26_EL0", 0xDF5A, true, true,  {}  }, // 611
  { "PMEVCNTR27_EL0", "PMEVCNTR27_EL0", 0xDF5B, true, true,  {}  }, // 612
  { "PMEVCNTR28_EL0", "PMEVCNTR28_EL0", 0xDF5C, true, true,  {}  }, // 613
  { "PMEVCNTR29_EL0", "PMEVCNTR29_EL0", 0xDF5D, true, true,  {}  }, // 614
  { "PMEVCNTR2_EL0", "PMEVCNTR2_EL0", 0xDF42, true, true,  {}  }, // 615
  { "PMEVCNTR30_EL0", "PMEVCNTR30_EL0", 0xDF5E, true, true,  {}  }, // 616
  { "PMEVCNTR3_EL0", "PMEVCNTR3_EL0", 0xDF43, true, true,  {}  }, // 617
  { "PMEVCNTR4_EL0", "PMEVCNTR4_EL0", 0xDF44, true, true,  {}  }, // 618
  { "PMEVCNTR5_EL0", "PMEVCNTR5_EL0", 0xDF45, true, true,  {}  }, // 619
  { "PMEVCNTR6_EL0", "PMEVCNTR6_EL0", 0xDF46, true, true,  {}  }, // 620
  { "PMEVCNTR7_EL0", "PMEVCNTR7_EL0", 0xDF47, true, true,  {}  }, // 621
  { "PMEVCNTR8_EL0", "PMEVCNTR8_EL0", 0xDF48, true, true,  {}  }, // 622
  { "PMEVCNTR9_EL0", "PMEVCNTR9_EL0", 0xDF49, true, true,  {}  }, // 623
  { "PMEVCNTSVR0_EL1", "PMEVCNTSVR0_EL1", 0x8740, true, false,  {}  }, // 624
  { "PMEVCNTSVR10_EL1", "PMEVCNTSVR10_EL1", 0x874A, true, false,  {}  }, // 625
  { "PMEVCNTSVR11_EL1", "PMEVCNTSVR11_EL1", 0x874B, true, false,  {}  }, // 626
  { "PMEVCNTSVR12_EL1", "PMEVCNTSVR12_EL1", 0x874C, true, false,  {}  }, // 627
  { "PMEVCNTSVR13_EL1", "PMEVCNTSVR13_EL1", 0x874D, true, false,  {}  }, // 628
  { "PMEVCNTSVR14_EL1", "PMEVCNTSVR14_EL1", 0x874E, true, false,  {}  }, // 629
  { "PMEVCNTSVR15_EL1", "PMEVCNTSVR15_EL1", 0x874F, true, false,  {}  }, // 630
  { "PMEVCNTSVR16_EL1", "PMEVCNTSVR16_EL1", 0x8750, true, false,  {}  }, // 631
  { "PMEVCNTSVR17_EL1", "PMEVCNTSVR17_EL1", 0x8751, true, false,  {}  }, // 632
  { "PMEVCNTSVR18_EL1", "PMEVCNTSVR18_EL1", 0x8752, true, false,  {}  }, // 633
  { "PMEVCNTSVR19_EL1", "PMEVCNTSVR19_EL1", 0x8753, true, false,  {}  }, // 634
  { "PMEVCNTSVR1_EL1", "PMEVCNTSVR1_EL1", 0x8741, true, false,  {}  }, // 635
  { "PMEVCNTSVR20_EL1", "PMEVCNTSVR20_EL1", 0x8754, true, false,  {}  }, // 636
  { "PMEVCNTSVR21_EL1", "PMEVCNTSVR21_EL1", 0x8755, true, false,  {}  }, // 637
  { "PMEVCNTSVR22_EL1", "PMEVCNTSVR22_EL1", 0x8756, true, false,  {}  }, // 638
  { "PMEVCNTSVR23_EL1", "PMEVCNTSVR23_EL1", 0x8757, true, false,  {}  }, // 639
  { "PMEVCNTSVR24_EL1", "PMEVCNTSVR24_EL1", 0x8758, true, false,  {}  }, // 640
  { "PMEVCNTSVR25_EL1", "PMEVCNTSVR25_EL1", 0x8759, true, false,  {}  }, // 641
  { "PMEVCNTSVR26_EL1", "PMEVCNTSVR26_EL1", 0x875A, true, false,  {}  }, // 642
  { "PMEVCNTSVR27_EL1", "PMEVCNTSVR27_EL1", 0x875B, true, false,  {}  }, // 643
  { "PMEVCNTSVR28_EL1", "PMEVCNTSVR28_EL1", 0x875C, true, false,  {}  }, // 644
  { "PMEVCNTSVR29_EL1", "PMEVCNTSVR29_EL1", 0x875D, true, false,  {}  }, // 645
  { "PMEVCNTSVR2_EL1", "PMEVCNTSVR2_EL1", 0x8742, true, false,  {}  }, // 646
  { "PMEVCNTSVR30_EL1", "PMEVCNTSVR30_EL1", 0x875E, true, false,  {}  }, // 647
  { "PMEVCNTSVR3_EL1", "PMEVCNTSVR3_EL1", 0x8743, true, false,  {}  }, // 648
  { "PMEVCNTSVR4_EL1", "PMEVCNTSVR4_EL1", 0x8744, true, false,  {}  }, // 649
  { "PMEVCNTSVR5_EL1", "PMEVCNTSVR5_EL1", 0x8745, true, false,  {}  }, // 650
  { "PMEVCNTSVR6_EL1", "PMEVCNTSVR6_EL1", 0x8746, true, false,  {}  }, // 651
  { "PMEVCNTSVR7_EL1", "PMEVCNTSVR7_EL1", 0x8747, true, false,  {}  }, // 652
  { "PMEVCNTSVR8_EL1", "PMEVCNTSVR8_EL1", 0x8748, true, false,  {}  }, // 653
  { "PMEVCNTSVR9_EL1", "PMEVCNTSVR9_EL1", 0x8749, true, false,  {}  }, // 654
  { "PMEVTYPER0_EL0", "PMEVTYPER0_EL0", 0xDF60, true, true,  {}  }, // 655
  { "PMEVTYPER10_EL0", "PMEVTYPER10_EL0", 0xDF6A, true, true,  {}  }, // 656
  { "PMEVTYPER11_EL0", "PMEVTYPER11_EL0", 0xDF6B, true, true,  {}  }, // 657
  { "PMEVTYPER12_EL0", "PMEVTYPER12_EL0", 0xDF6C, true, true,  {}  }, // 658
  { "PMEVTYPER13_EL0", "PMEVTYPER13_EL0", 0xDF6D, true, true,  {}  }, // 659
  { "PMEVTYPER14_EL0", "PMEVTYPER14_EL0", 0xDF6E, true, true,  {}  }, // 660
  { "PMEVTYPER15_EL0", "PMEVTYPER15_EL0", 0xDF6F, true, true,  {}  }, // 661
  { "PMEVTYPER16_EL0", "PMEVTYPER16_EL0", 0xDF70, true, true,  {}  }, // 662
  { "PMEVTYPER17_EL0", "PMEVTYPER17_EL0", 0xDF71, true, true,  {}  }, // 663
  { "PMEVTYPER18_EL0", "PMEVTYPER18_EL0", 0xDF72, true, true,  {}  }, // 664
  { "PMEVTYPER19_EL0", "PMEVTYPER19_EL0", 0xDF73, true, true,  {}  }, // 665
  { "PMEVTYPER1_EL0", "PMEVTYPER1_EL0", 0xDF61, true, true,  {}  }, // 666
  { "PMEVTYPER20_EL0", "PMEVTYPER20_EL0", 0xDF74, true, true,  {}  }, // 667
  { "PMEVTYPER21_EL0", "PMEVTYPER21_EL0", 0xDF75, true, true,  {}  }, // 668
  { "PMEVTYPER22_EL0", "PMEVTYPER22_EL0", 0xDF76, true, true,  {}  }, // 669
  { "PMEVTYPER23_EL0", "PMEVTYPER23_EL0", 0xDF77, true, true,  {}  }, // 670
  { "PMEVTYPER24_EL0", "PMEVTYPER24_EL0", 0xDF78, true, true,  {}  }, // 671
  { "PMEVTYPER25_EL0", "PMEVTYPER25_EL0", 0xDF79, true, true,  {}  }, // 672
  { "PMEVTYPER26_EL0", "PMEVTYPER26_EL0", 0xDF7A, true, true,  {}  }, // 673
  { "PMEVTYPER27_EL0", "PMEVTYPER27_EL0", 0xDF7B, true, true,  {}  }, // 674
  { "PMEVTYPER28_EL0", "PMEVTYPER28_EL0", 0xDF7C, true, true,  {}  }, // 675
  { "PMEVTYPER29_EL0", "PMEVTYPER29_EL0", 0xDF7D, true, true,  {}  }, // 676
  { "PMEVTYPER2_EL0", "PMEVTYPER2_EL0", 0xDF62, true, true,  {}  }, // 677
  { "PMEVTYPER30_EL0", "PMEVTYPER30_EL0", 0xDF7E, true, true,  {}  }, // 678
  { "PMEVTYPER3_EL0", "PMEVTYPER3_EL0", 0xDF63, true, true,  {}  }, // 679
  { "PMEVTYPER4_EL0", "PMEVTYPER4_EL0", 0xDF64, true, true,  {}  }, // 680
  { "PMEVTYPER5_EL0", "PMEVTYPER5_EL0", 0xDF65, true, true,  {}  }, // 681
  { "PMEVTYPER6_EL0", "PMEVTYPER6_EL0", 0xDF66, true, true,  {}  }, // 682
  { "PMEVTYPER7_EL0", "PMEVTYPER7_EL0", 0xDF67, true, true,  {}  }, // 683
  { "PMEVTYPER8_EL0", "PMEVTYPER8_EL0", 0xDF68, true, true,  {}  }, // 684
  { "PMEVTYPER9_EL0", "PMEVTYPER9_EL0", 0xDF69, true, true,  {}  }, // 685
  { "PMIAR_EL1", "PMIAR_EL1", 0xC4F7, true, true,  {}  }, // 686
  { "PMICFILTR_EL0", "PMICFILTR_EL0", 0xDCB0, true, true,  {}  }, // 687
  { "PMICNTR_EL0", "PMICNTR_EL0", 0xDCA0, true, true,  {}  }, // 688
  { "PMICNTSVR_EL1", "PMICNTSVR_EL1", 0x8760, true, false,  {}  }, // 689
  { "PMINTENCLR_EL1", "PMINTENCLR_EL1", 0xC4F2, true, true,  {}  }, // 690
  { "PMINTENSET_EL1", "PMINTENSET_EL1", 0xC4F1, true, true,  {}  }, // 691
  { "PMMIR_EL1", "PMMIR_EL1", 0xC4F6, true, false,  {}  }, // 692
  { "PMOVSCLR_EL0", "PMOVSCLR_EL0", 0xDCE3, true, true,  {}  }, // 693
  { "PMOVSSET_EL0", "PMOVSSET_EL0", 0xDCF3, true, true,  {}  }, // 694
  { "PMSCR_EL1", "PMSCR_EL1", 0xC4C8, true, true,  {AArch64::FeatureSPE}  }, // 695
  { "PMSCR_EL12", "PMSCR_EL12", 0xECC8, true, true,  {AArch64::FeatureSPE}  }, // 696
  { "PMSCR_EL2", "PMSCR_EL2", 0xE4C8, true, true,  {AArch64::FeatureSPE}  }, // 697
  { "PMSDSFR_EL1", "PMSDSFR_EL1", 0xC4D4, true, true,  {}  }, // 698
  { "PMSELR_EL0", "PMSELR_EL0", 0xDCE5, true, true,  {}  }, // 699
  { "PMSEVFR_EL1", "PMSEVFR_EL1", 0xC4CD, true, true,  {AArch64::FeatureSPE}  }, // 700
  { "PMSFCR_EL1", "PMSFCR_EL1", 0xC4CC, true, true,  {AArch64::FeatureSPE}  }, // 701
  { "PMSICR_EL1", "PMSICR_EL1", 0xC4CA, true, true,  {AArch64::FeatureSPE}  }, // 702
  { "PMSIDR_EL1", "PMSIDR_EL1", 0xC4CF, true, false,  {AArch64::FeatureSPE}  }, // 703
  { "PMSIRR_EL1", "PMSIRR_EL1", 0xC4CB, true, true,  {AArch64::FeatureSPE}  }, // 704
  { "PMSLATFR_EL1", "PMSLATFR_EL1", 0xC4CE, true, true,  {AArch64::FeatureSPE}  }, // 705
  { "PMSNEVFR_EL1", "PMSNEVFR_EL1", 0xC4C9, true, true,  {AArch64::FeatureSPE_EEF}  }, // 706
  { "PMSSCR_EL1", "PMSSCR_EL1", 0xC4EB, true, true,  {}  }, // 707
  { "PMSWINC_EL0", "PMSWINC_EL0", 0xDCE4, false, true,  {}  }, // 708
  { "PMUACR_EL1", "PMUACR_EL1", 0xC4F4, true, true,  {}  }, // 709
  { "PMUSERENR_EL0", "PMUSERENR_EL0", 0xDCF0, true, true,  {}  }, // 710
  { "PMXEVCNTR_EL0", "PMXEVCNTR_EL0", 0xDCEA, true, true,  {}  }, // 711
  { "PMXEVTYPER_EL0", "PMXEVTYPER_EL0", 0xDCE9, true, true,  {}  }, // 712
  { "PMZR_EL0", "PMZR_EL0", 0xDCEC, false, true,  {}  }, // 713
  { "POR_EL0", "POR_EL0", 0xDD14, true, true,  {}  }, // 714
  { "POR_EL1", "POR_EL1", 0xC514, true, true,  {}  }, // 715
  { "POR_EL12", "POR_EL12", 0xED14, true, true,  {}  }, // 716
  { "POR_EL2", "POR_EL2", 0xE514, true, true,  {}  }, // 717
  { "POR_EL3", "POR_EL3", 0xF514, true, true,  {}  }, // 718
  { "PRBAR10_EL1", "PRBAR10_EL1", 0xC368, true, true,  {AArch64::HasV8_0rOps}  }, // 719
  { "PRBAR10_EL2", "PRBAR10_EL2", 0xE368, true, true,  {AArch64::HasV8_0rOps}  }, // 720
  { "PRBAR11_EL1", "PRBAR11_EL1", 0xC36C, true, true,  {AArch64::HasV8_0rOps}  }, // 721
  { "PRBAR11_EL2", "PRBAR11_EL2", 0xE36C, true, true,  {AArch64::HasV8_0rOps}  }, // 722
  { "PRBAR12_EL1", "PRBAR12_EL1", 0xC370, true, true,  {AArch64::HasV8_0rOps}  }, // 723
  { "PRBAR12_EL2", "PRBAR12_EL2", 0xE370, true, true,  {AArch64::HasV8_0rOps}  }, // 724
  { "PRBAR13_EL1", "PRBAR13_EL1", 0xC374, true, true,  {AArch64::HasV8_0rOps}  }, // 725
  { "PRBAR13_EL2", "PRBAR13_EL2", 0xE374, true, true,  {AArch64::HasV8_0rOps}  }, // 726
  { "PRBAR14_EL1", "PRBAR14_EL1", 0xC378, true, true,  {AArch64::HasV8_0rOps}  }, // 727
  { "PRBAR14_EL2", "PRBAR14_EL2", 0xE378, true, true,  {AArch64::HasV8_0rOps}  }, // 728
  { "PRBAR15_EL1", "PRBAR15_EL1", 0xC37C, true, true,  {AArch64::HasV8_0rOps}  }, // 729
  { "PRBAR15_EL2", "PRBAR15_EL2", 0xE37C, true, true,  {AArch64::HasV8_0rOps}  }, // 730
  { "PRBAR1_EL1", "PRBAR1_EL1", 0xC344, true, true,  {AArch64::HasV8_0rOps}  }, // 731
  { "PRBAR1_EL2", "PRBAR1_EL2", 0xE344, true, true,  {AArch64::HasV8_0rOps}  }, // 732
  { "PRBAR2_EL1", "PRBAR2_EL1", 0xC348, true, true,  {AArch64::HasV8_0rOps}  }, // 733
  { "PRBAR2_EL2", "PRBAR2_EL2", 0xE348, true, true,  {AArch64::HasV8_0rOps}  }, // 734
  { "PRBAR3_EL1", "PRBAR3_EL1", 0xC34C, true, true,  {AArch64::HasV8_0rOps}  }, // 735
  { "PRBAR3_EL2", "PRBAR3_EL2", 0xE34C, true, true,  {AArch64::HasV8_0rOps}  }, // 736
  { "PRBAR4_EL1", "PRBAR4_EL1", 0xC350, true, true,  {AArch64::HasV8_0rOps}  }, // 737
  { "PRBAR4_EL2", "PRBAR4_EL2", 0xE350, true, true,  {AArch64::HasV8_0rOps}  }, // 738
  { "PRBAR5_EL1", "PRBAR5_EL1", 0xC354, true, true,  {AArch64::HasV8_0rOps}  }, // 739
  { "PRBAR5_EL2", "PRBAR5_EL2", 0xE354, true, true,  {AArch64::HasV8_0rOps}  }, // 740
  { "PRBAR6_EL1", "PRBAR6_EL1", 0xC358, true, true,  {AArch64::HasV8_0rOps}  }, // 741
  { "PRBAR6_EL2", "PRBAR6_EL2", 0xE358, true, true,  {AArch64::HasV8_0rOps}  }, // 742
  { "PRBAR7_EL1", "PRBAR7_EL1", 0xC35C, true, true,  {AArch64::HasV8_0rOps}  }, // 743
  { "PRBAR7_EL2", "PRBAR7_EL2", 0xE35C, true, true,  {AArch64::HasV8_0rOps}  }, // 744
  { "PRBAR8_EL1", "PRBAR8_EL1", 0xC360, true, true,  {AArch64::HasV8_0rOps}  }, // 745
  { "PRBAR8_EL2", "PRBAR8_EL2", 0xE360, true, true,  {AArch64::HasV8_0rOps}  }, // 746
  { "PRBAR9_EL1", "PRBAR9_EL1", 0xC364, true, true,  {AArch64::HasV8_0rOps}  }, // 747
  { "PRBAR9_EL2", "PRBAR9_EL2", 0xE364, true, true,  {AArch64::HasV8_0rOps}  }, // 748
  { "PRBAR_EL1", "PRBAR_EL1", 0xC340, true, true,  {AArch64::HasV8_0rOps}  }, // 749
  { "PRBAR_EL2", "PRBAR_EL2", 0xE340, true, true,  {AArch64::HasV8_0rOps}  }, // 750
  { "PRENR_EL1", "PRENR_EL1", 0xC309, true, true,  {AArch64::HasV8_0rOps}  }, // 751
  { "PRENR_EL2", "PRENR_EL2", 0xE309, true, true,  {AArch64::HasV8_0rOps}  }, // 752
  { "PRLAR10_EL1", "PRLAR10_EL1", 0xC369, true, true,  {AArch64::HasV8_0rOps}  }, // 753
  { "PRLAR10_EL2", "PRLAR10_EL2", 0xE369, true, true,  {AArch64::HasV8_0rOps}  }, // 754
  { "PRLAR11_EL1", "PRLAR11_EL1", 0xC36D, true, true,  {AArch64::HasV8_0rOps}  }, // 755
  { "PRLAR11_EL2", "PRLAR11_EL2", 0xE36D, true, true,  {AArch64::HasV8_0rOps}  }, // 756
  { "PRLAR12_EL1", "PRLAR12_EL1", 0xC371, true, true,  {AArch64::HasV8_0rOps}  }, // 757
  { "PRLAR12_EL2", "PRLAR12_EL2", 0xE371, true, true,  {AArch64::HasV8_0rOps}  }, // 758
  { "PRLAR13_EL1", "PRLAR13_EL1", 0xC375, true, true,  {AArch64::HasV8_0rOps}  }, // 759
  { "PRLAR13_EL2", "PRLAR13_EL2", 0xE375, true, true,  {AArch64::HasV8_0rOps}  }, // 760
  { "PRLAR14_EL1", "PRLAR14_EL1", 0xC379, true, true,  {AArch64::HasV8_0rOps}  }, // 761
  { "PRLAR14_EL2", "PRLAR14_EL2", 0xE379, true, true,  {AArch64::HasV8_0rOps}  }, // 762
  { "PRLAR15_EL1", "PRLAR15_EL1", 0xC37D, true, true,  {AArch64::HasV8_0rOps}  }, // 763
  { "PRLAR15_EL2", "PRLAR15_EL2", 0xE37D, true, true,  {AArch64::HasV8_0rOps}  }, // 764
  { "PRLAR1_EL1", "PRLAR1_EL1", 0xC345, true, true,  {AArch64::HasV8_0rOps}  }, // 765
  { "PRLAR1_EL2", "PRLAR1_EL2", 0xE345, true, true,  {AArch64::HasV8_0rOps}  }, // 766
  { "PRLAR2_EL1", "PRLAR2_EL1", 0xC349, true, true,  {AArch64::HasV8_0rOps}  }, // 767
  { "PRLAR2_EL2", "PRLAR2_EL2", 0xE349, true, true,  {AArch64::HasV8_0rOps}  }, // 768
  { "PRLAR3_EL1", "PRLAR3_EL1", 0xC34D, true, true,  {AArch64::HasV8_0rOps}  }, // 769
  { "PRLAR3_EL2", "PRLAR3_EL2", 0xE34D, true, true,  {AArch64::HasV8_0rOps}  }, // 770
  { "PRLAR4_EL1", "PRLAR4_EL1", 0xC351, true, true,  {AArch64::HasV8_0rOps}  }, // 771
  { "PRLAR4_EL2", "PRLAR4_EL2", 0xE351, true, true,  {AArch64::HasV8_0rOps}  }, // 772
  { "PRLAR5_EL1", "PRLAR5_EL1", 0xC355, true, true,  {AArch64::HasV8_0rOps}  }, // 773
  { "PRLAR5_EL2", "PRLAR5_EL2", 0xE355, true, true,  {AArch64::HasV8_0rOps}  }, // 774
  { "PRLAR6_EL1", "PRLAR6_EL1", 0xC359, true, true,  {AArch64::HasV8_0rOps}  }, // 775
  { "PRLAR6_EL2", "PRLAR6_EL2", 0xE359, true, true,  {AArch64::HasV8_0rOps}  }, // 776
  { "PRLAR7_EL1", "PRLAR7_EL1", 0xC35D, true, true,  {AArch64::HasV8_0rOps}  }, // 777
  { "PRLAR7_EL2", "PRLAR7_EL2", 0xE35D, true, true,  {AArch64::HasV8_0rOps}  }, // 778
  { "PRLAR8_EL1", "PRLAR8_EL1", 0xC361, true, true,  {AArch64::HasV8_0rOps}  }, // 779
  { "PRLAR8_EL2", "PRLAR8_EL2", 0xE361, true, true,  {AArch64::HasV8_0rOps}  }, // 780
  { "PRLAR9_EL1", "PRLAR9_EL1", 0xC365, true, true,  {AArch64::HasV8_0rOps}  }, // 781
  { "PRLAR9_EL2", "PRLAR9_EL2", 0xE365, true, true,  {AArch64::HasV8_0rOps}  }, // 782
  { "PRLAR_EL1", "PRLAR_EL1", 0xC341, true, true,  {AArch64::HasV8_0rOps}  }, // 783
  { "PRLAR_EL2", "PRLAR_EL2", 0xE341, true, true,  {AArch64::HasV8_0rOps}  }, // 784
  { "PRSELR_EL1", "PRSELR_EL1", 0xC311, true, true,  {AArch64::HasV8_0rOps}  }, // 785
  { "PRSELR_EL2", "PRSELR_EL2", 0xE311, true, true,  {AArch64::HasV8_0rOps}  }, // 786
  { "RCWMASK_EL1", "RCWMASK_EL1", 0xC686, true, true,  {AArch64::FeatureTHE}  }, // 787
  { "RCWSMASK_EL1", "RCWSMASK_EL1", 0xC683, true, true,  {AArch64::FeatureTHE}  }, // 788
  { "REVIDR_EL1", "REVIDR_EL1", 0xC006, true, false,  {}  }, // 789
  { "RGSR_EL1", "RGSR_EL1", 0xC085, true, true,  {AArch64::FeatureMTE}  }, // 790
  { "RMR_EL1", "RMR_EL1", 0xC602, true, true,  {}  }, // 791
  { "RMR_EL2", "RMR_EL2", 0xE602, true, true,  {}  }, // 792
  { "RMR_EL3", "RMR_EL3", 0xF602, true, true,  {}  }, // 793
  { "RNDR", "RNDR", 0xD920, true, false,  {AArch64::FeatureRandGen}  }, // 794
  { "RNDRRS", "RNDRRS", 0xD921, true, false,  {AArch64::FeatureRandGen}  }, // 795
  { "RVBAR_EL1", "RVBAR_EL1", 0xC601, true, false,  {}  }, // 796
  { "RVBAR_EL2", "RVBAR_EL2", 0xE601, true, false,  {}  }, // 797
  { "RVBAR_EL3", "RVBAR_EL3", 0xF601, true, false,  {}  }, // 798
  { "S2PIR_EL2", "S2PIR_EL2", 0xE515, true, true,  {}  }, // 799
  { "S2POR_EL1", "S2POR_EL1", 0xC515, true, true,  {}  }, // 800
  { "SCR_EL3", "SCR_EL3", 0xF088, true, true,  {}  }, // 801
  { "SCTLR2_EL1", "SCTLR2_EL1", 0xC083, true, true,  {}  }, // 802
  { "SCTLR2_EL12", "SCTLR2_EL12", 0xE883, true, true,  {}  }, // 803
  { "SCTLR2_EL2", "SCTLR2_EL2", 0xE083, true, true,  {}  }, // 804
  { "SCTLR2_EL3", "SCTLR2_EL3", 0xF083, true, true,  {}  }, // 805
  { "SCTLR_EL1", "SCTLR_EL1", 0xC080, true, true,  {}  }, // 806
  { "SCTLR_EL12", "SCTLR_EL12", 0xE880, true, true,  {AArch64::FeatureVH}  }, // 807
  { "SCTLR_EL2", "SCTLR_EL2", 0xE080, true, true,  {}  }, // 808
  { "SCTLR_EL3", "SCTLR_EL3", 0xF080, true, true,  {}  }, // 809
  { "SCXTNUM_EL0", "SCXTNUM_EL0", 0xDE87, true, true,  {AArch64::FeatureSpecRestrict}  }, // 810
  { "SCXTNUM_EL1", "SCXTNUM_EL1", 0xC687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 811
  { "SCXTNUM_EL12", "SCXTNUM_EL12", 0xEE87, true, true,  {AArch64::FeatureSpecRestrict}  }, // 812
  { "SCXTNUM_EL2", "SCXTNUM_EL2", 0xE687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 813
  { "SCXTNUM_EL3", "SCXTNUM_EL3", 0xF687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 814
  { "SDER32_EL2", "SDER32_EL2", 0xE099, true, true,  {AArch64::FeatureSEL2}  }, // 815
  { "SDER32_EL3", "SDER32_EL3", 0xF089, true, true,  {}  }, // 816
  { "SMCR_EL1", "SMCR_EL1", 0xC096, true, true,  {AArch64::FeatureSME}  }, // 817
  { "SMCR_EL12", "SMCR_EL12", 0xE896, true, true,  {AArch64::FeatureSME}  }, // 818
  { "SMCR_EL2", "SMCR_EL2", 0xE096, true, true,  {AArch64::FeatureSME}  }, // 819
  { "SMCR_EL3", "SMCR_EL3", 0xF096, true, true,  {AArch64::FeatureSME}  }, // 820
  { "SMIDR_EL1", "SMIDR_EL1", 0xC806, true, false,  {AArch64::FeatureSME}  }, // 821
  { "SMPRIMAP_EL2", "SMPRIMAP_EL2", 0xE095, true, true,  {AArch64::FeatureSME}  }, // 822
  { "SMPRI_EL1", "SMPRI_EL1", 0xC094, true, true,  {AArch64::FeatureSME}  }, // 823
  { "SPMACCESSR_EL1", "SPMACCESSR_EL1", 0x84EB, true, true,  {}  }, // 824
  { "SPMACCESSR_EL12", "SPMACCESSR_EL12", 0xACEB, true, true,  {}  }, // 825
  { "SPMACCESSR_EL2", "SPMACCESSR_EL2", 0xA4EB, true, true,  {}  }, // 826
  { "SPMACCESSR_EL3", "SPMACCESSR_EL3", 0xB4EB, true, true,  {}  }, // 827
  { "SPMCFGR_EL1", "SPMCFGR_EL1", 0x84EF, true, false,  {}  }, // 828
  { "SPMCGCR0_EL1", "SPMCGCR0_EL1", 0x84E8, true, false,  {}  }, // 829
  { "SPMCGCR1_EL1", "SPMCGCR1_EL1", 0x84E9, true, false,  {}  }, // 830
  { "SPMCNTENCLR_EL0", "SPMCNTENCLR_EL0", 0x9CE2, true, true,  {}  }, // 831
  { "SPMCNTENSET_EL0", "SPMCNTENSET_EL0", 0x9CE1, true, true,  {}  }, // 832
  { "SPMCR_EL0", "SPMCR_EL0", 0x9CE0, true, true,  {}  }, // 833
  { "SPMDEVAFF_EL1", "SPMDEVAFF_EL1", 0x84EE, true, false,  {}  }, // 834
  { "SPMDEVARCH_EL1", "SPMDEVARCH_EL1", 0x84ED, true, false,  {}  }, // 835
  { "SPMEVCNTR0_EL0", "SPMEVCNTR0_EL0", 0x9F00, true, true,  {}  }, // 836
  { "SPMEVCNTR10_EL0", "SPMEVCNTR10_EL0", 0x9F0A, true, true,  {}  }, // 837
  { "SPMEVCNTR11_EL0", "SPMEVCNTR11_EL0", 0x9F0B, true, true,  {}  }, // 838
  { "SPMEVCNTR12_EL0", "SPMEVCNTR12_EL0", 0x9F0C, true, true,  {}  }, // 839
  { "SPMEVCNTR13_EL0", "SPMEVCNTR13_EL0", 0x9F0D, true, true,  {}  }, // 840
  { "SPMEVCNTR14_EL0", "SPMEVCNTR14_EL0", 0x9F0E, true, true,  {}  }, // 841
  { "SPMEVCNTR15_EL0", "SPMEVCNTR15_EL0", 0x9F0F, true, true,  {}  }, // 842
  { "SPMEVCNTR1_EL0", "SPMEVCNTR1_EL0", 0x9F01, true, true,  {}  }, // 843
  { "SPMEVCNTR2_EL0", "SPMEVCNTR2_EL0", 0x9F02, true, true,  {}  }, // 844
  { "SPMEVCNTR3_EL0", "SPMEVCNTR3_EL0", 0x9F03, true, true,  {}  }, // 845
  { "SPMEVCNTR4_EL0", "SPMEVCNTR4_EL0", 0x9F04, true, true,  {}  }, // 846
  { "SPMEVCNTR5_EL0", "SPMEVCNTR5_EL0", 0x9F05, true, true,  {}  }, // 847
  { "SPMEVCNTR6_EL0", "SPMEVCNTR6_EL0", 0x9F06, true, true,  {}  }, // 848
  { "SPMEVCNTR7_EL0", "SPMEVCNTR7_EL0", 0x9F07, true, true,  {}  }, // 849
  { "SPMEVCNTR8_EL0", "SPMEVCNTR8_EL0", 0x9F08, true, true,  {}  }, // 850
  { "SPMEVCNTR9_EL0", "SPMEVCNTR9_EL0", 0x9F09, true, true,  {}  }, // 851
  { "SPMEVFILT2R0_EL0", "SPMEVFILT2R0_EL0", 0x9F30, true, true,  {}  }, // 852
  { "SPMEVFILT2R10_EL0", "SPMEVFILT2R10_EL0", 0x9F3A, true, true,  {}  }, // 853
  { "SPMEVFILT2R11_EL0", "SPMEVFILT2R11_EL0", 0x9F3B, true, true,  {}  }, // 854
  { "SPMEVFILT2R12_EL0", "SPMEVFILT2R12_EL0", 0x9F3C, true, true,  {}  }, // 855
  { "SPMEVFILT2R13_EL0", "SPMEVFILT2R13_EL0", 0x9F3D, true, true,  {}  }, // 856
  { "SPMEVFILT2R14_EL0", "SPMEVFILT2R14_EL0", 0x9F3E, true, true,  {}  }, // 857
  { "SPMEVFILT2R15_EL0", "SPMEVFILT2R15_EL0", 0x9F3F, true, true,  {}  }, // 858
  { "SPMEVFILT2R1_EL0", "SPMEVFILT2R1_EL0", 0x9F31, true, true,  {}  }, // 859
  { "SPMEVFILT2R2_EL0", "SPMEVFILT2R2_EL0", 0x9F32, true, true,  {}  }, // 860
  { "SPMEVFILT2R3_EL0", "SPMEVFILT2R3_EL0", 0x9F33, true, true,  {}  }, // 861
  { "SPMEVFILT2R4_EL0", "SPMEVFILT2R4_EL0", 0x9F34, true, true,  {}  }, // 862
  { "SPMEVFILT2R5_EL0", "SPMEVFILT2R5_EL0", 0x9F35, true, true,  {}  }, // 863
  { "SPMEVFILT2R6_EL0", "SPMEVFILT2R6_EL0", 0x9F36, true, true,  {}  }, // 864
  { "SPMEVFILT2R7_EL0", "SPMEVFILT2R7_EL0", 0x9F37, true, true,  {}  }, // 865
  { "SPMEVFILT2R8_EL0", "SPMEVFILT2R8_EL0", 0x9F38, true, true,  {}  }, // 866
  { "SPMEVFILT2R9_EL0", "SPMEVFILT2R9_EL0", 0x9F39, true, true,  {}  }, // 867
  { "SPMEVFILTR0_EL0", "SPMEVFILTR0_EL0", 0x9F20, true, true,  {}  }, // 868
  { "SPMEVFILTR10_EL0", "SPMEVFILTR10_EL0", 0x9F2A, true, true,  {}  }, // 869
  { "SPMEVFILTR11_EL0", "SPMEVFILTR11_EL0", 0x9F2B, true, true,  {}  }, // 870
  { "SPMEVFILTR12_EL0", "SPMEVFILTR12_EL0", 0x9F2C, true, true,  {}  }, // 871
  { "SPMEVFILTR13_EL0", "SPMEVFILTR13_EL0", 0x9F2D, true, true,  {}  }, // 872
  { "SPMEVFILTR14_EL0", "SPMEVFILTR14_EL0", 0x9F2E, true, true,  {}  }, // 873
  { "SPMEVFILTR15_EL0", "SPMEVFILTR15_EL0", 0x9F2F, true, true,  {}  }, // 874
  { "SPMEVFILTR1_EL0", "SPMEVFILTR1_EL0", 0x9F21, true, true,  {}  }, // 875
  { "SPMEVFILTR2_EL0", "SPMEVFILTR2_EL0", 0x9F22, true, true,  {}  }, // 876
  { "SPMEVFILTR3_EL0", "SPMEVFILTR3_EL0", 0x9F23, true, true,  {}  }, // 877
  { "SPMEVFILTR4_EL0", "SPMEVFILTR4_EL0", 0x9F24, true, true,  {}  }, // 878
  { "SPMEVFILTR5_EL0", "SPMEVFILTR5_EL0", 0x9F25, true, true,  {}  }, // 879
  { "SPMEVFILTR6_EL0", "SPMEVFILTR6_EL0", 0x9F26, true, true,  {}  }, // 880
  { "SPMEVFILTR7_EL0", "SPMEVFILTR7_EL0", 0x9F27, true, true,  {}  }, // 881
  { "SPMEVFILTR8_EL0", "SPMEVFILTR8_EL0", 0x9F28, true, true,  {}  }, // 882
  { "SPMEVFILTR9_EL0", "SPMEVFILTR9_EL0", 0x9F29, true, true,  {}  }, // 883
  { "SPMEVTYPER0_EL0", "SPMEVTYPER0_EL0", 0x9F10, true, true,  {}  }, // 884
  { "SPMEVTYPER10_EL0", "SPMEVTYPER10_EL0", 0x9F1A, true, true,  {}  }, // 885
  { "SPMEVTYPER11_EL0", "SPMEVTYPER11_EL0", 0x9F1B, true, true,  {}  }, // 886
  { "SPMEVTYPER12_EL0", "SPMEVTYPER12_EL0", 0x9F1C, true, true,  {}  }, // 887
  { "SPMEVTYPER13_EL0", "SPMEVTYPER13_EL0", 0x9F1D, true, true,  {}  }, // 888
  { "SPMEVTYPER14_EL0", "SPMEVTYPER14_EL0", 0x9F1E, true, true,  {}  }, // 889
  { "SPMEVTYPER15_EL0", "SPMEVTYPER15_EL0", 0x9F1F, true, true,  {}  }, // 890
  { "SPMEVTYPER1_EL0", "SPMEVTYPER1_EL0", 0x9F11, true, true,  {}  }, // 891
  { "SPMEVTYPER2_EL0", "SPMEVTYPER2_EL0", 0x9F12, true, true,  {}  }, // 892
  { "SPMEVTYPER3_EL0", "SPMEVTYPER3_EL0", 0x9F13, true, true,  {}  }, // 893
  { "SPMEVTYPER4_EL0", "SPMEVTYPER4_EL0", 0x9F14, true, true,  {}  }, // 894
  { "SPMEVTYPER5_EL0", "SPMEVTYPER5_EL0", 0x9F15, true, true,  {}  }, // 895
  { "SPMEVTYPER6_EL0", "SPMEVTYPER6_EL0", 0x9F16, true, true,  {}  }, // 896
  { "SPMEVTYPER7_EL0", "SPMEVTYPER7_EL0", 0x9F17, true, true,  {}  }, // 897
  { "SPMEVTYPER8_EL0", "SPMEVTYPER8_EL0", 0x9F18, true, true,  {}  }, // 898
  { "SPMEVTYPER9_EL0", "SPMEVTYPER9_EL0", 0x9F19, true, true,  {}  }, // 899
  { "SPMIIDR_EL1", "SPMIIDR_EL1", 0x84EC, true, false,  {}  }, // 900
  { "SPMINTENCLR_EL1", "SPMINTENCLR_EL1", 0x84F2, true, true,  {}  }, // 901
  { "SPMINTENSET_EL1", "SPMINTENSET_EL1", 0x84F1, true, true,  {}  }, // 902
  { "SPMOVSCLR_EL0", "SPMOVSCLR_EL0", 0x9CE3, true, true,  {}  }, // 903
  { "SPMOVSSET_EL0", "SPMOVSSET_EL0", 0x9CF3, true, true,  {}  }, // 904
  { "SPMROOTCR_EL3", "SPMROOTCR_EL3", 0xB4F7, true, true,  {}  }, // 905
  { "SPMSCR_EL1", "SPMSCR_EL1", 0xBCF7, true, true,  {}  }, // 906
  { "SPMSELR_EL0", "SPMSELR_EL0", 0x9CE5, true, true,  {}  }, // 907
  { "SPSel", "SPSel", 0xC210, true, true,  {}  }, // 908
  { "SPSR_abt", "SPSR_abt", 0xE219, true, true,  {}  }, // 909
  { "SPSR_EL1", "SPSR_EL1", 0xC200, true, true,  {}  }, // 910
  { "SPSR_EL12", "SPSR_EL12", 0xEA00, true, true,  {AArch64::FeatureVH}  }, // 911
  { "SPSR_EL2", "SPSR_EL2", 0xE200, true, true,  {}  }, // 912
  { "SPSR_EL3", "SPSR_EL3", 0xF200, true, true,  {}  }, // 913
  { "SPSR_fiq", "SPSR_fiq", 0xE21B, true, true,  {}  }, // 914
  { "SPSR_irq", "SPSR_irq", 0xE218, true, true,  {}  }, // 915
  { "SPSR_und", "SPSR_und", 0xE21A, true, true,  {}  }, // 916
  { "SP_EL0", "SP_EL0", 0xC208, true, true,  {}  }, // 917
  { "SP_EL1", "SP_EL1", 0xE208, true, true,  {}  }, // 918
  { "SP_EL2", "SP_EL2", 0xF208, true, true,  {}  }, // 919
  { "SSBS", "SSBS", 0xDA16, true, true,  {AArch64::FeatureSSBS}  }, // 920
  { "SVCR", "SVCR", 0xDA12, true, true,  {AArch64::FeatureSME}  }, // 921
  { "TCO", "TCO", 0xDA17, true, true,  {AArch64::FeatureMTE}  }, // 922
  { "TCR2_EL1", "TCR2_EL1", 0xC103, true, true,  {}  }, // 923
  { "TCR2_EL12", "TCR2_EL12", 0xE903, true, true,  {}  }, // 924
  { "TCR2_EL2", "TCR2_EL2", 0xE103, true, true,  {}  }, // 925
  { "TCR_EL1", "TCR_EL1", 0xC102, true, true,  {}  }, // 926
  { "TCR_EL12", "TCR_EL12", 0xE902, true, true,  {AArch64::FeatureVH}  }, // 927
  { "TCR_EL2", "TCR_EL2", 0xE102, true, true,  {}  }, // 928
  { "TCR_EL3", "TCR_EL3", 0xF102, true, true,  {}  }, // 929
  { "TEECR32_EL1", "TEECR32_EL1", 0x9000, true, true,  {}  }, // 930
  { "TEEHBR32_EL1", "TEEHBR32_EL1", 0x9080, true, true,  {}  }, // 931
  { "TFSRE0_EL1", "TFSRE0_EL1", 0xC2B1, true, true,  {AArch64::FeatureMTE}  }, // 932
  { "TFSR_EL1", "TFSR_EL1", 0xC2B0, true, true,  {AArch64::FeatureMTE}  }, // 933
  { "TFSR_EL12", "TFSR_EL12", 0xEAB0, true, true,  {AArch64::FeatureMTE}  }, // 934
  { "TFSR_EL2", "TFSR_EL2", 0xE2B0, true, true,  {AArch64::FeatureMTE}  }, // 935
  { "TFSR_EL3", "TFSR_EL3", 0xF2B0, true, true,  {AArch64::FeatureMTE}  }, // 936
  { "TPIDR2_EL0", "TPIDR2_EL0", 0xDE85, true, true,  {AArch64::FeatureSME}  }, // 937
  { "TPIDRRO_EL0", "TPIDRRO_EL0", 0xDE83, true, true,  {}  }, // 938
  { "TPIDR_EL0", "TPIDR_EL0", 0xDE82, true, true,  {}  }, // 939
  { "TPIDR_EL1", "TPIDR_EL1", 0xC684, true, true,  {}  }, // 940
  { "TPIDR_EL2", "TPIDR_EL2", 0xE682, true, true,  {}  }, // 941
  { "TPIDR_EL3", "TPIDR_EL3", 0xF682, true, true,  {}  }, // 942
  { "TRBBASER_EL1", "TRBBASER_EL1", 0xC4DA, true, true,  {AArch64::FeatureTRBE}  }, // 943
  { "TRBIDR_EL1", "TRBIDR_EL1", 0xC4DF, true, false,  {AArch64::FeatureTRBE}  }, // 944
  { "TRBLIMITR_EL1", "TRBLIMITR_EL1", 0xC4D8, true, true,  {AArch64::FeatureTRBE}  }, // 945
  { "TRBMAR_EL1", "TRBMAR_EL1", 0xC4DC, true, true,  {AArch64::FeatureTRBE}  }, // 946
  { "TRBPTR_EL1", "TRBPTR_EL1", 0xC4D9, true, true,  {AArch64::FeatureTRBE}  }, // 947
  { "TRBSR_EL1", "TRBSR_EL1", 0xC4DB, true, true,  {AArch64::FeatureTRBE}  }, // 948
  { "TRBTRG_EL1", "TRBTRG_EL1", 0xC4DE, true, true,  {AArch64::FeatureTRBE}  }, // 949
  { "TRCACATR0", "TRCACATR0", 0x8902, true, true,  {}  }, // 950
  { "TRCACATR1", "TRCACATR1", 0x8912, true, true,  {}  }, // 951
  { "TRCACATR10", "TRCACATR10", 0x8923, true, true,  {}  }, // 952
  { "TRCACATR11", "TRCACATR11", 0x8933, true, true,  {}  }, // 953
  { "TRCACATR12", "TRCACATR12", 0x8943, true, true,  {}  }, // 954
  { "TRCACATR13", "TRCACATR13", 0x8953, true, true,  {}  }, // 955
  { "TRCACATR14", "TRCACATR14", 0x8963, true, true,  {}  }, // 956
  { "TRCACATR15", "TRCACATR15", 0x8973, true, true,  {}  }, // 957
  { "TRCACATR2", "TRCACATR2", 0x8922, true, true,  {}  }, // 958
  { "TRCACATR3", "TRCACATR3", 0x8932, true, true,  {}  }, // 959
  { "TRCACATR4", "TRCACATR4", 0x8942, true, true,  {}  }, // 960
  { "TRCACATR5", "TRCACATR5", 0x8952, true, true,  {}  }, // 961
  { "TRCACATR6", "TRCACATR6", 0x8962, true, true,  {}  }, // 962
  { "TRCACATR7", "TRCACATR7", 0x8972, true, true,  {}  }, // 963
  { "TRCACATR8", "TRCACATR8", 0x8903, true, true,  {}  }, // 964
  { "TRCACATR9", "TRCACATR9", 0x8913, true, true,  {}  }, // 965
  { "TRCACVR0", "TRCACVR0", 0x8900, true, true,  {}  }, // 966
  { "TRCACVR1", "TRCACVR1", 0x8910, true, true,  {}  }, // 967
  { "TRCACVR10", "TRCACVR10", 0x8921, true, true,  {}  }, // 968
  { "TRCACVR11", "TRCACVR11", 0x8931, true, true,  {}  }, // 969
  { "TRCACVR12", "TRCACVR12", 0x8941, true, true,  {}  }, // 970
  { "TRCACVR13", "TRCACVR13", 0x8951, true, true,  {}  }, // 971
  { "TRCACVR14", "TRCACVR14", 0x8961, true, true,  {}  }, // 972
  { "TRCACVR15", "TRCACVR15", 0x8971, true, true,  {}  }, // 973
  { "TRCACVR2", "TRCACVR2", 0x8920, true, true,  {}  }, // 974
  { "TRCACVR3", "TRCACVR3", 0x8930, true, true,  {}  }, // 975
  { "TRCACVR4", "TRCACVR4", 0x8940, true, true,  {}  }, // 976
  { "TRCACVR5", "TRCACVR5", 0x8950, true, true,  {}  }, // 977
  { "TRCACVR6", "TRCACVR6", 0x8960, true, true,  {}  }, // 978
  { "TRCACVR7", "TRCACVR7", 0x8970, true, true,  {}  }, // 979
  { "TRCACVR8", "TRCACVR8", 0x8901, true, true,  {}  }, // 980
  { "TRCACVR9", "TRCACVR9", 0x8911, true, true,  {}  }, // 981
  { "TRCAUTHSTATUS", "TRCAUTHSTATUS", 0x8BF6, true, false,  {}  }, // 982
  { "TRCAUXCTLR", "TRCAUXCTLR", 0x8830, true, true,  {}  }, // 983
  { "TRCBBCTLR", "TRCBBCTLR", 0x8878, true, true,  {}  }, // 984
  { "TRCCCCTLR", "TRCCCCTLR", 0x8870, true, true,  {}  }, // 985
  { "TRCCIDCCTLR0", "TRCCIDCCTLR0", 0x8982, true, true,  {}  }, // 986
  { "TRCCIDCCTLR1", "TRCCIDCCTLR1", 0x898A, true, true,  {}  }, // 987
  { "TRCCIDCVR0", "TRCCIDCVR0", 0x8980, true, true,  {}  }, // 988
  { "TRCCIDCVR1", "TRCCIDCVR1", 0x8990, true, true,  {}  }, // 989
  { "TRCCIDCVR2", "TRCCIDCVR2", 0x89A0, true, true,  {}  }, // 990
  { "TRCCIDCVR3", "TRCCIDCVR3", 0x89B0, true, true,  {}  }, // 991
  { "TRCCIDCVR4", "TRCCIDCVR4", 0x89C0, true, true,  {}  }, // 992
  { "TRCCIDCVR5", "TRCCIDCVR5", 0x89D0, true, true,  {}  }, // 993
  { "TRCCIDCVR6", "TRCCIDCVR6", 0x89E0, true, true,  {}  }, // 994
  { "TRCCIDCVR7", "TRCCIDCVR7", 0x89F0, true, true,  {}  }, // 995
  { "TRCCIDR0", "TRCCIDR0", 0x8BE7, true, false,  {}  }, // 996
  { "TRCCIDR1", "TRCCIDR1", 0x8BEF, true, false,  {}  }, // 997
  { "TRCCIDR2", "TRCCIDR2", 0x8BF7, true, false,  {}  }, // 998
  { "TRCCIDR3", "TRCCIDR3", 0x8BFF, true, false,  {}  }, // 999
  { "TRCCLAIMCLR", "TRCCLAIMCLR", 0x8BCE, true, true,  {}  }, // 1000
  { "TRCCLAIMSET", "TRCCLAIMSET", 0x8BC6, true, true,  {}  }, // 1001
  { "TRCCNTCTLR0", "TRCCNTCTLR0", 0x8825, true, true,  {}  }, // 1002
  { "TRCCNTCTLR1", "TRCCNTCTLR1", 0x882D, true, true,  {}  }, // 1003
  { "TRCCNTCTLR2", "TRCCNTCTLR2", 0x8835, true, true,  {}  }, // 1004
  { "TRCCNTCTLR3", "TRCCNTCTLR3", 0x883D, true, true,  {}  }, // 1005
  { "TRCCNTRLDVR0", "TRCCNTRLDVR0", 0x8805, true, true,  {}  }, // 1006
  { "TRCCNTRLDVR1", "TRCCNTRLDVR1", 0x880D, true, true,  {}  }, // 1007
  { "TRCCNTRLDVR2", "TRCCNTRLDVR2", 0x8815, true, true,  {}  }, // 1008
  { "TRCCNTRLDVR3", "TRCCNTRLDVR3", 0x881D, true, true,  {}  }, // 1009
  { "TRCCNTVR0", "TRCCNTVR0", 0x8845, true, true,  {}  }, // 1010
  { "TRCCNTVR1", "TRCCNTVR1", 0x884D, true, true,  {}  }, // 1011
  { "TRCCNTVR2", "TRCCNTVR2", 0x8855, true, true,  {}  }, // 1012
  { "TRCCNTVR3", "TRCCNTVR3", 0x885D, true, true,  {}  }, // 1013
  { "TRCCONFIGR", "TRCCONFIGR", 0x8820, true, true,  {}  }, // 1014
  { "TRCDEVAFF0", "TRCDEVAFF0", 0x8BD6, true, false,  {}  }, // 1015
  { "TRCDEVAFF1", "TRCDEVAFF1", 0x8BDE, true, false,  {}  }, // 1016
  { "TRCDEVARCH", "TRCDEVARCH", 0x8BFE, true, false,  {}  }, // 1017
  { "TRCDEVID", "TRCDEVID", 0x8B97, true, false,  {}  }, // 1018
  { "TRCDEVTYPE", "TRCDEVTYPE", 0x8B9F, true, false,  {}  }, // 1019
  { "TRCDVCMR0", "TRCDVCMR0", 0x8906, true, true,  {}  }, // 1020
  { "TRCDVCMR1", "TRCDVCMR1", 0x8926, true, true,  {}  }, // 1021
  { "TRCDVCMR2", "TRCDVCMR2", 0x8946, true, true,  {}  }, // 1022
  { "TRCDVCMR3", "TRCDVCMR3", 0x8966, true, true,  {}  }, // 1023
  { "TRCDVCMR4", "TRCDVCMR4", 0x8907, true, true,  {}  }, // 1024
  { "TRCDVCMR5", "TRCDVCMR5", 0x8927, true, true,  {}  }, // 1025
  { "TRCDVCMR6", "TRCDVCMR6", 0x8947, true, true,  {}  }, // 1026
  { "TRCDVCMR7", "TRCDVCMR7", 0x8967, true, true,  {}  }, // 1027
  { "TRCDVCVR0", "TRCDVCVR0", 0x8904, true, true,  {}  }, // 1028
  { "TRCDVCVR1", "TRCDVCVR1", 0x8924, true, true,  {}  }, // 1029
  { "TRCDVCVR2", "TRCDVCVR2", 0x8944, true, true,  {}  }, // 1030
  { "TRCDVCVR3", "TRCDVCVR3", 0x8964, true, true,  {}  }, // 1031
  { "TRCDVCVR4", "TRCDVCVR4", 0x8905, true, true,  {}  }, // 1032
  { "TRCDVCVR5", "TRCDVCVR5", 0x8925, true, true,  {}  }, // 1033
  { "TRCDVCVR6", "TRCDVCVR6", 0x8945, true, true,  {}  }, // 1034
  { "TRCDVCVR7", "TRCDVCVR7", 0x8965, true, true,  {}  }, // 1035
  { "TRCEVENTCTL0R", "TRCEVENTCTL0R", 0x8840, true, true,  {}  }, // 1036
  { "TRCEVENTCTL1R", "TRCEVENTCTL1R", 0x8848, true, true,  {}  }, // 1037
  { "TRCEXTINSELR", "TRCEXTINSELR", 0x8844, true, true,  {}  }, // 1038
  { "TRCEXTINSELR0", "TRCEXTINSELR0", 0x8844, true, true,  {AArch64::FeatureETE}  }, // 1039
  { "TRCEXTINSELR1", "TRCEXTINSELR1", 0x884C, true, true,  {AArch64::FeatureETE}  }, // 1040
  { "TRCEXTINSELR2", "TRCEXTINSELR2", 0x8854, true, true,  {AArch64::FeatureETE}  }, // 1041
  { "TRCEXTINSELR3", "TRCEXTINSELR3", 0x885C, true, true,  {AArch64::FeatureETE}  }, // 1042
  { "TRCIDR0", "TRCIDR0", 0x8847, true, false,  {}  }, // 1043
  { "TRCIDR1", "TRCIDR1", 0x884F, true, false,  {}  }, // 1044
  { "TRCIDR10", "TRCIDR10", 0x8816, true, false,  {}  }, // 1045
  { "TRCIDR11", "TRCIDR11", 0x881E, true, false,  {}  }, // 1046
  { "TRCIDR12", "TRCIDR12", 0x8826, true, false,  {}  }, // 1047
  { "TRCIDR13", "TRCIDR13", 0x882E, true, false,  {}  }, // 1048
  { "TRCIDR2", "TRCIDR2", 0x8857, true, false,  {}  }, // 1049
  { "TRCIDR3", "TRCIDR3", 0x885F, true, false,  {}  }, // 1050
  { "TRCIDR4", "TRCIDR4", 0x8867, true, false,  {}  }, // 1051
  { "TRCIDR5", "TRCIDR5", 0x886F, true, false,  {}  }, // 1052
  { "TRCIDR6", "TRCIDR6", 0x8877, true, false,  {}  }, // 1053
  { "TRCIDR7", "TRCIDR7", 0x887F, true, false,  {}  }, // 1054
  { "TRCIDR8", "TRCIDR8", 0x8806, true, false,  {}  }, // 1055
  { "TRCIDR9", "TRCIDR9", 0x880E, true, false,  {}  }, // 1056
  { "TRCIMSPEC0", "TRCIMSPEC0", 0x8807, true, true,  {}  }, // 1057
  { "TRCIMSPEC1", "TRCIMSPEC1", 0x880F, true, true,  {}  }, // 1058
  { "TRCIMSPEC2", "TRCIMSPEC2", 0x8817, true, true,  {}  }, // 1059
  { "TRCIMSPEC3", "TRCIMSPEC3", 0x881F, true, true,  {}  }, // 1060
  { "TRCIMSPEC4", "TRCIMSPEC4", 0x8827, true, true,  {}  }, // 1061
  { "TRCIMSPEC5", "TRCIMSPEC5", 0x882F, true, true,  {}  }, // 1062
  { "TRCIMSPEC6", "TRCIMSPEC6", 0x8837, true, true,  {}  }, // 1063
  { "TRCIMSPEC7", "TRCIMSPEC7", 0x883F, true, true,  {}  }, // 1064
  { "TRCITCTRL", "TRCITCTRL", 0x8B84, true, true,  {}  }, // 1065
  { "TRCITECR_EL1", "TRCITECR_EL1", 0xC093, true, true,  {AArch64::FeatureITE}  }, // 1066
  { "TRCITECR_EL12", "TRCITECR_EL12", 0xE893, true, true,  {AArch64::FeatureITE}  }, // 1067
  { "TRCITECR_EL2", "TRCITECR_EL2", 0xE093, true, true,  {AArch64::FeatureITE}  }, // 1068
  { "TRCITEEDCR", "TRCITEEDCR", 0x8811, true, true,  {AArch64::FeatureITE}  }, // 1069
  { "TRCLAR", "TRCLAR", 0x8BE6, false, true,  {}  }, // 1070
  { "TRCLSR", "TRCLSR", 0x8BEE, true, false,  {}  }, // 1071
  { "TRCOSLAR", "TRCOSLAR", 0x8884, false, true,  {}  }, // 1072
  { "TRCOSLSR", "TRCOSLSR", 0x888C, true, false,  {}  }, // 1073
  { "TRCPDCR", "TRCPDCR", 0x88A4, true, true,  {}  }, // 1074
  { "TRCPDSR", "TRCPDSR", 0x88AC, true, false,  {}  }, // 1075
  { "TRCPIDR0", "TRCPIDR0", 0x8BC7, true, false,  {}  }, // 1076
  { "TRCPIDR1", "TRCPIDR1", 0x8BCF, true, false,  {}  }, // 1077
  { "TRCPIDR2", "TRCPIDR2", 0x8BD7, true, false,  {}  }, // 1078
  { "TRCPIDR3", "TRCPIDR3", 0x8BDF, true, false,  {}  }, // 1079
  { "TRCPIDR4", "TRCPIDR4", 0x8BA7, true, false,  {}  }, // 1080
  { "TRCPIDR5", "TRCPIDR5", 0x8BAF, true, false,  {}  }, // 1081
  { "TRCPIDR6", "TRCPIDR6", 0x8BB7, true, false,  {}  }, // 1082
  { "TRCPIDR7", "TRCPIDR7", 0x8BBF, true, false,  {}  }, // 1083
  { "TRCPRGCTLR", "TRCPRGCTLR", 0x8808, true, true,  {}  }, // 1084
  { "TRCPROCSELR", "TRCPROCSELR", 0x8810, true, true,  {}  }, // 1085
  { "TRCQCTLR", "TRCQCTLR", 0x8809, true, true,  {}  }, // 1086
  { "TRCRSCTLR10", "TRCRSCTLR10", 0x88D0, true, true,  {}  }, // 1087
  { "TRCRSCTLR11", "TRCRSCTLR11", 0x88D8, true, true,  {}  }, // 1088
  { "TRCRSCTLR12", "TRCRSCTLR12", 0x88E0, true, true,  {}  }, // 1089
  { "TRCRSCTLR13", "TRCRSCTLR13", 0x88E8, true, true,  {}  }, // 1090
  { "TRCRSCTLR14", "TRCRSCTLR14", 0x88F0, true, true,  {}  }, // 1091
  { "TRCRSCTLR15", "TRCRSCTLR15", 0x88F8, true, true,  {}  }, // 1092
  { "TRCRSCTLR16", "TRCRSCTLR16", 0x8881, true, true,  {}  }, // 1093
  { "TRCRSCTLR17", "TRCRSCTLR17", 0x8889, true, true,  {}  }, // 1094
  { "TRCRSCTLR18", "TRCRSCTLR18", 0x8891, true, true,  {}  }, // 1095
  { "TRCRSCTLR19", "TRCRSCTLR19", 0x8899, true, true,  {}  }, // 1096
  { "TRCRSCTLR2", "TRCRSCTLR2", 0x8890, true, true,  {}  }, // 1097
  { "TRCRSCTLR20", "TRCRSCTLR20", 0x88A1, true, true,  {}  }, // 1098
  { "TRCRSCTLR21", "TRCRSCTLR21", 0x88A9, true, true,  {}  }, // 1099
  { "TRCRSCTLR22", "TRCRSCTLR22", 0x88B1, true, true,  {}  }, // 1100
  { "TRCRSCTLR23", "TRCRSCTLR23", 0x88B9, true, true,  {}  }, // 1101
  { "TRCRSCTLR24", "TRCRSCTLR24", 0x88C1, true, true,  {}  }, // 1102
  { "TRCRSCTLR25", "TRCRSCTLR25", 0x88C9, true, true,  {}  }, // 1103
  { "TRCRSCTLR26", "TRCRSCTLR26", 0x88D1, true, true,  {}  }, // 1104
  { "TRCRSCTLR27", "TRCRSCTLR27", 0x88D9, true, true,  {}  }, // 1105
  { "TRCRSCTLR28", "TRCRSCTLR28", 0x88E1, true, true,  {}  }, // 1106
  { "TRCRSCTLR29", "TRCRSCTLR29", 0x88E9, true, true,  {}  }, // 1107
  { "TRCRSCTLR3", "TRCRSCTLR3", 0x8898, true, true,  {}  }, // 1108
  { "TRCRSCTLR30", "TRCRSCTLR30", 0x88F1, true, true,  {}  }, // 1109
  { "TRCRSCTLR31", "TRCRSCTLR31", 0x88F9, true, true,  {}  }, // 1110
  { "TRCRSCTLR4", "TRCRSCTLR4", 0x88A0, true, true,  {}  }, // 1111
  { "TRCRSCTLR5", "TRCRSCTLR5", 0x88A8, true, true,  {}  }, // 1112
  { "TRCRSCTLR6", "TRCRSCTLR6", 0x88B0, true, true,  {}  }, // 1113
  { "TRCRSCTLR7", "TRCRSCTLR7", 0x88B8, true, true,  {}  }, // 1114
  { "TRCRSCTLR8", "TRCRSCTLR8", 0x88C0, true, true,  {}  }, // 1115
  { "TRCRSCTLR9", "TRCRSCTLR9", 0x88C8, true, true,  {}  }, // 1116
  { "TRCRSR", "TRCRSR", 0x8850, true, true,  {AArch64::FeatureETE}  }, // 1117
  { "TRCSEQEVR0", "TRCSEQEVR0", 0x8804, true, true,  {}  }, // 1118
  { "TRCSEQEVR1", "TRCSEQEVR1", 0x880C, true, true,  {}  }, // 1119
  { "TRCSEQEVR2", "TRCSEQEVR2", 0x8814, true, true,  {}  }, // 1120
  { "TRCSEQRSTEVR", "TRCSEQRSTEVR", 0x8834, true, true,  {}  }, // 1121
  { "TRCSEQSTR", "TRCSEQSTR", 0x883C, true, true,  {}  }, // 1122
  { "TRCSSCCR0", "TRCSSCCR0", 0x8882, true, true,  {}  }, // 1123
  { "TRCSSCCR1", "TRCSSCCR1", 0x888A, true, true,  {}  }, // 1124
  { "TRCSSCCR2", "TRCSSCCR2", 0x8892, true, true,  {}  }, // 1125
  { "TRCSSCCR3", "TRCSSCCR3", 0x889A, true, true,  {}  }, // 1126
  { "TRCSSCCR4", "TRCSSCCR4", 0x88A2, true, true,  {}  }, // 1127
  { "TRCSSCCR5", "TRCSSCCR5", 0x88AA, true, true,  {}  }, // 1128
  { "TRCSSCCR6", "TRCSSCCR6", 0x88B2, true, true,  {}  }, // 1129
  { "TRCSSCCR7", "TRCSSCCR7", 0x88BA, true, true,  {}  }, // 1130
  { "TRCSSCSR0", "TRCSSCSR0", 0x88C2, true, true,  {}  }, // 1131
  { "TRCSSCSR1", "TRCSSCSR1", 0x88CA, true, true,  {}  }, // 1132
  { "TRCSSCSR2", "TRCSSCSR2", 0x88D2, true, true,  {}  }, // 1133
  { "TRCSSCSR3", "TRCSSCSR3", 0x88DA, true, true,  {}  }, // 1134
  { "TRCSSCSR4", "TRCSSCSR4", 0x88E2, true, true,  {}  }, // 1135
  { "TRCSSCSR5", "TRCSSCSR5", 0x88EA, true, true,  {}  }, // 1136
  { "TRCSSCSR6", "TRCSSCSR6", 0x88F2, true, true,  {}  }, // 1137
  { "TRCSSCSR7", "TRCSSCSR7", 0x88FA, true, true,  {}  }, // 1138
  { "TRCSSPCICR0", "TRCSSPCICR0", 0x8883, true, true,  {}  }, // 1139
  { "TRCSSPCICR1", "TRCSSPCICR1", 0x888B, true, true,  {}  }, // 1140
  { "TRCSSPCICR2", "TRCSSPCICR2", 0x8893, true, true,  {}  }, // 1141
  { "TRCSSPCICR3", "TRCSSPCICR3", 0x889B, true, true,  {}  }, // 1142
  { "TRCSSPCICR4", "TRCSSPCICR4", 0x88A3, true, true,  {}  }, // 1143
  { "TRCSSPCICR5", "TRCSSPCICR5", 0x88AB, true, true,  {}  }, // 1144
  { "TRCSSPCICR6", "TRCSSPCICR6", 0x88B3, true, true,  {}  }, // 1145
  { "TRCSSPCICR7", "TRCSSPCICR7", 0x88BB, true, true,  {}  }, // 1146
  { "TRCSTALLCTLR", "TRCSTALLCTLR", 0x8858, true, true,  {}  }, // 1147
  { "TRCSTATR", "TRCSTATR", 0x8818, true, false,  {}  }, // 1148
  { "TRCSYNCPR", "TRCSYNCPR", 0x8868, true, true,  {}  }, // 1149
  { "TRCTRACEIDR", "TRCTRACEIDR", 0x8801, true, true,  {}  }, // 1150
  { "TRCTSCTLR", "TRCTSCTLR", 0x8860, true, true,  {}  }, // 1151
  { "TRCVDARCCTLR", "TRCVDARCCTLR", 0x8852, true, true,  {}  }, // 1152
  { "TRCVDCTLR", "TRCVDCTLR", 0x8842, true, true,  {}  }, // 1153
  { "TRCVDSACCTLR", "TRCVDSACCTLR", 0x884A, true, true,  {}  }, // 1154
  { "TRCVICTLR", "TRCVICTLR", 0x8802, true, true,  {}  }, // 1155
  { "TRCVIIECTLR", "TRCVIIECTLR", 0x880A, true, true,  {}  }, // 1156
  { "TRCVIPCSSCTLR", "TRCVIPCSSCTLR", 0x881A, true, true,  {}  }, // 1157
  { "TRCVISSCTLR", "TRCVISSCTLR", 0x8812, true, true,  {}  }, // 1158
  { "TRCVMIDCCTLR0", "TRCVMIDCCTLR0", 0x8992, true, true,  {}  }, // 1159
  { "TRCVMIDCCTLR1", "TRCVMIDCCTLR1", 0x899A, true, true,  {}  }, // 1160
  { "TRCVMIDCVR0", "TRCVMIDCVR0", 0x8981, true, true,  {}  }, // 1161
  { "TRCVMIDCVR1", "TRCVMIDCVR1", 0x8991, true, true,  {}  }, // 1162
  { "TRCVMIDCVR2", "TRCVMIDCVR2", 0x89A1, true, true,  {}  }, // 1163
  { "TRCVMIDCVR3", "TRCVMIDCVR3", 0x89B1, true, true,  {}  }, // 1164
  { "TRCVMIDCVR4", "TRCVMIDCVR4", 0x89C1, true, true,  {}  }, // 1165
  { "TRCVMIDCVR5", "TRCVMIDCVR5", 0x89D1, true, true,  {}  }, // 1166
  { "TRCVMIDCVR6", "TRCVMIDCVR6", 0x89E1, true, true,  {}  }, // 1167
  { "TRCVMIDCVR7", "TRCVMIDCVR7", 0x89F1, true, true,  {}  }, // 1168
  { "TRFCR_EL1", "TRFCR_EL1", 0xC091, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 1169
  { "TRFCR_EL12", "TRFCR_EL12", 0xE891, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 1170
  { "TRFCR_EL2", "TRFCR_EL2", 0xE091, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 1171
  { "TTBR0_EL1", "TTBR0_EL1", 0xC100, true, true,  {}  }, // 1172
  { "TTBR0_EL12", "TTBR0_EL12", 0xE900, true, true,  {AArch64::FeatureVH}  }, // 1173
  { "TTBR0_EL2", "VSCTLR_EL2", 0xE100, true, true,  {AArch64::FeatureEL2VMSA}  }, // 1174
  { "TTBR0_EL3", "TTBR0_EL3", 0xF100, true, true,  {}  }, // 1175
  { "TTBR1_EL1", "TTBR1_EL1", 0xC101, true, true,  {}  }, // 1176
  { "TTBR1_EL12", "TTBR1_EL12", 0xE901, true, true,  {AArch64::FeatureVH}  }, // 1177
  { "TTBR1_EL2", "TTBR1_EL2", 0xE101, true, true,  {AArch64::FeatureVH}  }, // 1178
  { "UAO", "UAO", 0xC214, true, true,  {AArch64::FeaturePsUAO}  }, // 1179
  { "VBAR_EL1", "VBAR_EL1", 0xC600, true, true,  {}  }, // 1180
  { "VBAR_EL12", "VBAR_EL12", 0xEE00, true, true,  {AArch64::FeatureVH}  }, // 1181
  { "VBAR_EL2", "VBAR_EL2", 0xE600, true, true,  {}  }, // 1182
  { "VBAR_EL3", "VBAR_EL3", 0xF600, true, true,  {}  }, // 1183
  { "VDISR_EL2", "VDISR_EL2", 0xE609, true, true,  {AArch64::FeatureRAS}  }, // 1184
  { "VMECID_A_EL2", "VMECID_A_EL2", 0xE549, true, true,  {AArch64::FeatureMEC}  }, // 1185
  { "VMECID_P_EL2", "VMECID_P_EL2", 0xE548, true, true,  {AArch64::FeatureMEC}  }, // 1186
  { "VMPIDR_EL2", "VMPIDR_EL2", 0xE005, true, true,  {}  }, // 1187
  { "VNCR_EL2", "VNCR_EL2", 0xE110, true, true,  {AArch64::FeatureNV}  }, // 1188
  { "VPIDR_EL2", "VPIDR_EL2", 0xE000, true, true,  {}  }, // 1189
  { "VSCTLR_EL2", "TTBR0_EL2", 0xE100, true, true,  {AArch64::HasV8_0rOps}  }, // 1190
  { "VSESR_EL2", "VSESR_EL2", 0xE293, true, true,  {AArch64::FeatureRAS}  }, // 1191
  { "VSTCR_EL2", "VSTCR_EL2", 0xE132, true, true,  {AArch64::FeatureSEL2}  }, // 1192
  { "VSTTBR_EL2", "VSTTBR_EL2", 0xE130, true, true,  {AArch64::HasV8_0aOps}  }, // 1193
  { "VTCR_EL2", "VTCR_EL2", 0xE10A, true, true,  {}  }, // 1194
  { "VTTBR_EL2", "VTTBR_EL2", 0xE108, true, true,  {AArch64::FeatureEL2VMSA}  }, // 1195
  { "ZCR_EL1", "ZCR_EL1", 0xC090, true, true,  {AArch64::FeatureSVE}  }, // 1196
  { "ZCR_EL12", "ZCR_EL12", 0xE890, true, true,  {AArch64::FeatureSVE}  }, // 1197
  { "ZCR_EL2", "ZCR_EL2", 0xE090, true, true,  {AArch64::FeatureSVE}  }, // 1198
  { "ZCR_EL3", "ZCR_EL3", 0xF090, true, true,  {AArch64::FeatureSVE}  }, // 1199
 };

const SysReg *lookupSysRegByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ACCDATA_EL1", 0 },
    { "ACTLR_EL1", 1 },
    { "ACTLR_EL2", 2 },
    { "ACTLR_EL3", 3 },
    { "AFSR0_EL1", 4 },
    { "AFSR0_EL12", 5 },
    { "AFSR0_EL2", 6 },
    { "AFSR0_EL3", 7 },
    { "AFSR1_EL1", 8 },
    { "AFSR1_EL12", 9 },
    { "AFSR1_EL2", 10 },
    { "AFSR1_EL3", 11 },
    { "AIDR_EL1", 12 },
    { "ALLINT", 13 },
    { "AMAIR2_EL1", 14 },
    { "AMAIR2_EL12", 15 },
    { "AMAIR2_EL2", 16 },
    { "AMAIR2_EL3", 17 },
    { "AMAIR_EL1", 18 },
    { "AMAIR_EL12", 19 },
    { "AMAIR_EL2", 20 },
    { "AMAIR_EL3", 21 },
    { "AMCFGR_EL0", 22 },
    { "AMCG1IDR_EL0", 23 },
    { "AMCGCR_EL0", 24 },
    { "AMCNTENCLR0_EL0", 25 },
    { "AMCNTENCLR1_EL0", 26 },
    { "AMCNTENSET0_EL0", 27 },
    { "AMCNTENSET1_EL0", 28 },
    { "AMCR_EL0", 29 },
    { "AMEVCNTR00_EL0", 30 },
    { "AMEVCNTR01_EL0", 31 },
    { "AMEVCNTR02_EL0", 32 },
    { "AMEVCNTR03_EL0", 33 },
    { "AMEVCNTR10_EL0", 34 },
    { "AMEVCNTR110_EL0", 35 },
    { "AMEVCNTR111_EL0", 36 },
    { "AMEVCNTR112_EL0", 37 },
    { "AMEVCNTR113_EL0", 38 },
    { "AMEVCNTR114_EL0", 39 },
    { "AMEVCNTR115_EL0", 40 },
    { "AMEVCNTR11_EL0", 41 },
    { "AMEVCNTR12_EL0", 42 },
    { "AMEVCNTR13_EL0", 43 },
    { "AMEVCNTR14_EL0", 44 },
    { "AMEVCNTR15_EL0", 45 },
    { "AMEVCNTR16_EL0", 46 },
    { "AMEVCNTR17_EL0", 47 },
    { "AMEVCNTR18_EL0", 48 },
    { "AMEVCNTR19_EL0", 49 },
    { "AMEVCNTVOFF00_EL2", 50 },
    { "AMEVCNTVOFF010_EL2", 51 },
    { "AMEVCNTVOFF011_EL2", 52 },
    { "AMEVCNTVOFF012_EL2", 53 },
    { "AMEVCNTVOFF013_EL2", 54 },
    { "AMEVCNTVOFF014_EL2", 55 },
    { "AMEVCNTVOFF015_EL2", 56 },
    { "AMEVCNTVOFF01_EL2", 57 },
    { "AMEVCNTVOFF02_EL2", 58 },
    { "AMEVCNTVOFF03_EL2", 59 },
    { "AMEVCNTVOFF04_EL2", 60 },
    { "AMEVCNTVOFF05_EL2", 61 },
    { "AMEVCNTVOFF06_EL2", 62 },
    { "AMEVCNTVOFF07_EL2", 63 },
    { "AMEVCNTVOFF08_EL2", 64 },
    { "AMEVCNTVOFF09_EL2", 65 },
    { "AMEVCNTVOFF10_EL2", 66 },
    { "AMEVCNTVOFF110_EL2", 67 },
    { "AMEVCNTVOFF111_EL2", 68 },
    { "AMEVCNTVOFF112_EL2", 69 },
    { "AMEVCNTVOFF113_EL2", 70 },
    { "AMEVCNTVOFF114_EL2", 71 },
    { "AMEVCNTVOFF115_EL2", 72 },
    { "AMEVCNTVOFF11_EL2", 73 },
    { "AMEVCNTVOFF12_EL2", 74 },
    { "AMEVCNTVOFF13_EL2", 75 },
    { "AMEVCNTVOFF14_EL2", 76 },
    { "AMEVCNTVOFF15_EL2", 77 },
    { "AMEVCNTVOFF16_EL2", 78 },
    { "AMEVCNTVOFF17_EL2", 79 },
    { "AMEVCNTVOFF18_EL2", 80 },
    { "AMEVCNTVOFF19_EL2", 81 },
    { "AMEVTYPER00_EL0", 82 },
    { "AMEVTYPER01_EL0", 83 },
    { "AMEVTYPER02_EL0", 84 },
    { "AMEVTYPER03_EL0", 85 },
    { "AMEVTYPER10_EL0", 86 },
    { "AMEVTYPER110_EL0", 87 },
    { "AMEVTYPER111_EL0", 88 },
    { "AMEVTYPER112_EL0", 89 },
    { "AMEVTYPER113_EL0", 90 },
    { "AMEVTYPER114_EL0", 91 },
    { "AMEVTYPER115_EL0", 92 },
    { "AMEVTYPER11_EL0", 93 },
    { "AMEVTYPER12_EL0", 94 },
    { "AMEVTYPER13_EL0", 95 },
    { "AMEVTYPER14_EL0", 96 },
    { "AMEVTYPER15_EL0", 97 },
    { "AMEVTYPER16_EL0", 98 },
    { "AMEVTYPER17_EL0", 99 },
    { "AMEVTYPER18_EL0", 100 },
    { "AMEVTYPER19_EL0", 101 },
    { "AMUSERENR_EL0", 102 },
    { "APDAKEYHI_EL1", 103 },
    { "APDAKEYLO_EL1", 104 },
    { "APDBKEYHI_EL1", 105 },
    { "APDBKEYLO_EL1", 106 },
    { "APGAKEYHI_EL1", 107 },
    { "APGAKEYLO_EL1", 108 },
    { "APIAKEYHI_EL1", 109 },
    { "APIAKEYLO_EL1", 110 },
    { "APIBKEYHI_EL1", 111 },
    { "APIBKEYLO_EL1", 112 },
    { "BRBCR_EL1", 113 },
    { "BRBCR_EL12", 114 },
    { "BRBCR_EL2", 115 },
    { "BRBFCR_EL1", 116 },
    { "BRBIDR0_EL1", 117 },
    { "BRBINF0_EL1", 118 },
    { "BRBINF10_EL1", 119 },
    { "BRBINF11_EL1", 120 },
    { "BRBINF12_EL1", 121 },
    { "BRBINF13_EL1", 122 },
    { "BRBINF14_EL1", 123 },
    { "BRBINF15_EL1", 124 },
    { "BRBINF16_EL1", 125 },
    { "BRBINF17_EL1", 126 },
    { "BRBINF18_EL1", 127 },
    { "BRBINF19_EL1", 128 },
    { "BRBINF1_EL1", 129 },
    { "BRBINF20_EL1", 130 },
    { "BRBINF21_EL1", 131 },
    { "BRBINF22_EL1", 132 },
    { "BRBINF23_EL1", 133 },
    { "BRBINF24_EL1", 134 },
    { "BRBINF25_EL1", 135 },
    { "BRBINF26_EL1", 136 },
    { "BRBINF27_EL1", 137 },
    { "BRBINF28_EL1", 138 },
    { "BRBINF29_EL1", 139 },
    { "BRBINF2_EL1", 140 },
    { "BRBINF30_EL1", 141 },
    { "BRBINF31_EL1", 142 },
    { "BRBINF3_EL1", 143 },
    { "BRBINF4_EL1", 144 },
    { "BRBINF5_EL1", 145 },
    { "BRBINF6_EL1", 146 },
    { "BRBINF7_EL1", 147 },
    { "BRBINF8_EL1", 148 },
    { "BRBINF9_EL1", 149 },
    { "BRBINFINJ_EL1", 150 },
    { "BRBSRC0_EL1", 151 },
    { "BRBSRC10_EL1", 152 },
    { "BRBSRC11_EL1", 153 },
    { "BRBSRC12_EL1", 154 },
    { "BRBSRC13_EL1", 155 },
    { "BRBSRC14_EL1", 156 },
    { "BRBSRC15_EL1", 157 },
    { "BRBSRC16_EL1", 158 },
    { "BRBSRC17_EL1", 159 },
    { "BRBSRC18_EL1", 160 },
    { "BRBSRC19_EL1", 161 },
    { "BRBSRC1_EL1", 162 },
    { "BRBSRC20_EL1", 163 },
    { "BRBSRC21_EL1", 164 },
    { "BRBSRC22_EL1", 165 },
    { "BRBSRC23_EL1", 166 },
    { "BRBSRC24_EL1", 167 },
    { "BRBSRC25_EL1", 168 },
    { "BRBSRC26_EL1", 169 },
    { "BRBSRC27_EL1", 170 },
    { "BRBSRC28_EL1", 171 },
    { "BRBSRC29_EL1", 172 },
    { "BRBSRC2_EL1", 173 },
    { "BRBSRC30_EL1", 174 },
    { "BRBSRC31_EL1", 175 },
    { "BRBSRC3_EL1", 176 },
    { "BRBSRC4_EL1", 177 },
    { "BRBSRC5_EL1", 178 },
    { "BRBSRC6_EL1", 179 },
    { "BRBSRC7_EL1", 180 },
    { "BRBSRC8_EL1", 181 },
    { "BRBSRC9_EL1", 182 },
    { "BRBSRCINJ_EL1", 183 },
    { "BRBTGT0_EL1", 184 },
    { "BRBTGT10_EL1", 185 },
    { "BRBTGT11_EL1", 186 },
    { "BRBTGT12_EL1", 187 },
    { "BRBTGT13_EL1", 188 },
    { "BRBTGT14_EL1", 189 },
    { "BRBTGT15_EL1", 190 },
    { "BRBTGT16_EL1", 191 },
    { "BRBTGT17_EL1", 192 },
    { "BRBTGT18_EL1", 193 },
    { "BRBTGT19_EL1", 194 },
    { "BRBTGT1_EL1", 195 },
    { "BRBTGT20_EL1", 196 },
    { "BRBTGT21_EL1", 197 },
    { "BRBTGT22_EL1", 198 },
    { "BRBTGT23_EL1", 199 },
    { "BRBTGT24_EL1", 200 },
    { "BRBTGT25_EL1", 201 },
    { "BRBTGT26_EL1", 202 },
    { "BRBTGT27_EL1", 203 },
    { "BRBTGT28_EL1", 204 },
    { "BRBTGT29_EL1", 205 },
    { "BRBTGT2_EL1", 206 },
    { "BRBTGT30_EL1", 207 },
    { "BRBTGT31_EL1", 208 },
    { "BRBTGT3_EL1", 209 },
    { "BRBTGT4_EL1", 210 },
    { "BRBTGT5_EL1", 211 },
    { "BRBTGT6_EL1", 212 },
    { "BRBTGT7_EL1", 213 },
    { "BRBTGT8_EL1", 214 },
    { "BRBTGT9_EL1", 215 },
    { "BRBTGTINJ_EL1", 216 },
    { "BRBTS_EL1", 217 },
    { "CCSIDR2_EL1", 218 },
    { "CCSIDR_EL1", 219 },
    { "CLIDR_EL1", 220 },
    { "CNTFRQ_EL0", 221 },
    { "CNTHCTL_EL2", 222 },
    { "CNTHPS_CTL_EL2", 223 },
    { "CNTHPS_CVAL_EL2", 224 },
    { "CNTHPS_TVAL_EL2", 225 },
    { "CNTHP_CTL_EL2", 226 },
    { "CNTHP_CVAL_EL2", 227 },
    { "CNTHP_TVAL_EL2", 228 },
    { "CNTHVS_CTL_EL2", 229 },
    { "CNTHVS_CVAL_EL2", 230 },
    { "CNTHVS_TVAL_EL2", 231 },
    { "CNTHV_CTL_EL2", 232 },
    { "CNTHV_CVAL_EL2", 233 },
    { "CNTHV_TVAL_EL2", 234 },
    { "CNTISCALE_EL2", 235 },
    { "CNTKCTL_EL1", 236 },
    { "CNTKCTL_EL12", 237 },
    { "CNTPCTSS_EL0", 238 },
    { "CNTPCT_EL0", 239 },
    { "CNTPOFF_EL2", 240 },
    { "CNTPS_CTL_EL1", 241 },
    { "CNTPS_CVAL_EL1", 242 },
    { "CNTPS_TVAL_EL1", 243 },
    { "CNTP_CTL_EL0", 244 },
    { "CNTP_CTL_EL02", 245 },
    { "CNTP_CVAL_EL0", 246 },
    { "CNTP_CVAL_EL02", 247 },
    { "CNTP_TVAL_EL0", 248 },
    { "CNTP_TVAL_EL02", 249 },
    { "CNTSCALE_EL2", 250 },
    { "CNTVCTSS_EL0", 251 },
    { "CNTVCT_EL0", 252 },
    { "CNTVFRQ_EL2", 253 },
    { "CNTVOFF_EL2", 254 },
    { "CNTV_CTL_EL0", 255 },
    { "CNTV_CTL_EL02", 256 },
    { "CNTV_CVAL_EL0", 257 },
    { "CNTV_CVAL_EL02", 258 },
    { "CNTV_TVAL_EL0", 259 },
    { "CNTV_TVAL_EL02", 260 },
    { "CONTEXTIDR_EL1", 261 },
    { "CONTEXTIDR_EL12", 262 },
    { "CONTEXTIDR_EL2", 263 },
    { "CPACR_EL1", 264 },
    { "CPACR_EL12", 265 },
    { "CPM_IOACC_CTL_EL3", 266 },
    { "CPTR_EL2", 267 },
    { "CPTR_EL3", 268 },
    { "CSSELR_EL1", 269 },
    { "CTR_EL0", 270 },
    { "CURRENTEL", 271 },
    { "DACR32_EL2", 272 },
    { "DAIF", 273 },
    { "DBGAUTHSTATUS_EL1", 274 },
    { "DBGBCR0_EL1", 275 },
    { "DBGBCR10_EL1", 276 },
    { "DBGBCR11_EL1", 277 },
    { "DBGBCR12_EL1", 278 },
    { "DBGBCR13_EL1", 279 },
    { "DBGBCR14_EL1", 280 },
    { "DBGBCR15_EL1", 281 },
    { "DBGBCR1_EL1", 282 },
    { "DBGBCR2_EL1", 283 },
    { "DBGBCR3_EL1", 284 },
    { "DBGBCR4_EL1", 285 },
    { "DBGBCR5_EL1", 286 },
    { "DBGBCR6_EL1", 287 },
    { "DBGBCR7_EL1", 288 },
    { "DBGBCR8_EL1", 289 },
    { "DBGBCR9_EL1", 290 },
    { "DBGBVR0_EL1", 291 },
    { "DBGBVR10_EL1", 292 },
    { "DBGBVR11_EL1", 293 },
    { "DBGBVR12_EL1", 294 },
    { "DBGBVR13_EL1", 295 },
    { "DBGBVR14_EL1", 296 },
    { "DBGBVR15_EL1", 297 },
    { "DBGBVR1_EL1", 298 },
    { "DBGBVR2_EL1", 299 },
    { "DBGBVR3_EL1", 300 },
    { "DBGBVR4_EL1", 301 },
    { "DBGBVR5_EL1", 302 },
    { "DBGBVR6_EL1", 303 },
    { "DBGBVR7_EL1", 304 },
    { "DBGBVR8_EL1", 305 },
    { "DBGBVR9_EL1", 306 },
    { "DBGCLAIMCLR_EL1", 307 },
    { "DBGCLAIMSET_EL1", 308 },
    { "DBGDTRRX_EL0", 309 },
    { "DBGDTRTX_EL0", 310 },
    { "DBGDTR_EL0", 311 },
    { "DBGPRCR_EL1", 312 },
    { "DBGVCR32_EL2", 313 },
    { "DBGWCR0_EL1", 314 },
    { "DBGWCR10_EL1", 315 },
    { "DBGWCR11_EL1", 316 },
    { "DBGWCR12_EL1", 317 },
    { "DBGWCR13_EL1", 318 },
    { "DBGWCR14_EL1", 319 },
    { "DBGWCR15_EL1", 320 },
    { "DBGWCR1_EL1", 321 },
    { "DBGWCR2_EL1", 322 },
    { "DBGWCR3_EL1", 323 },
    { "DBGWCR4_EL1", 324 },
    { "DBGWCR5_EL1", 325 },
    { "DBGWCR6_EL1", 326 },
    { "DBGWCR7_EL1", 327 },
    { "DBGWCR8_EL1", 328 },
    { "DBGWCR9_EL1", 329 },
    { "DBGWVR0_EL1", 330 },
    { "DBGWVR10_EL1", 331 },
    { "DBGWVR11_EL1", 332 },
    { "DBGWVR12_EL1", 333 },
    { "DBGWVR13_EL1", 334 },
    { "DBGWVR14_EL1", 335 },
    { "DBGWVR15_EL1", 336 },
    { "DBGWVR1_EL1", 337 },
    { "DBGWVR2_EL1", 338 },
    { "DBGWVR3_EL1", 339 },
    { "DBGWVR4_EL1", 340 },
    { "DBGWVR5_EL1", 341 },
    { "DBGWVR6_EL1", 342 },
    { "DBGWVR7_EL1", 343 },
    { "DBGWVR8_EL1", 344 },
    { "DBGWVR9_EL1", 345 },
    { "DCZID_EL0", 346 },
    { "DISR_EL1", 347 },
    { "DIT", 348 },
    { "DLR_EL0", 349 },
    { "DSPSR_EL0", 350 },
    { "ELR_EL1", 351 },
    { "ELR_EL12", 352 },
    { "ELR_EL2", 353 },
    { "ELR_EL3", 354 },
    { "ERRIDR_EL1", 355 },
    { "ERRSELR_EL1", 356 },
    { "ERXADDR_EL1", 357 },
    { "ERXCTLR_EL1", 358 },
    { "ERXFR_EL1", 359 },
    { "ERXGSR_EL1", 360 },
    { "ERXMISC0_EL1", 361 },
    { "ERXMISC1_EL1", 362 },
    { "ERXMISC2_EL1", 363 },
    { "ERXMISC3_EL1", 364 },
    { "ERXPFGCDN_EL1", 365 },
    { "ERXPFGCTL_EL1", 366 },
    { "ERXPFGF_EL1", 367 },
    { "ERXSTATUS_EL1", 368 },
    { "ESR_EL1", 369 },
    { "ESR_EL12", 370 },
    { "ESR_EL2", 371 },
    { "ESR_EL3", 372 },
    { "FAR_EL1", 373 },
    { "FAR_EL12", 374 },
    { "FAR_EL2", 375 },
    { "FAR_EL3", 376 },
    { "FPCR", 377 },
    { "FPEXC32_EL2", 378 },
    { "FPSR", 379 },
    { "GCR_EL1", 380 },
    { "GCSCRE0_EL1", 381 },
    { "GCSCR_EL1", 382 },
    { "GCSCR_EL12", 383 },
    { "GCSCR_EL2", 384 },
    { "GCSCR_EL3", 385 },
    { "GCSPR_EL0", 386 },
    { "GCSPR_EL1", 387 },
    { "GCSPR_EL12", 388 },
    { "GCSPR_EL2", 389 },
    { "GCSPR_EL3", 390 },
    { "GMID_EL1", 391 },
    { "GPCCR_EL3", 392 },
    { "GPTBR_EL3", 393 },
    { "HACR_EL2", 394 },
    { "HAFGRTR_EL2", 395 },
    { "HCRX_EL2", 396 },
    { "HCR_EL2", 397 },
    { "HDFGRTR2_EL2", 398 },
    { "HDFGRTR_EL2", 399 },
    { "HDFGWTR2_EL2", 400 },
    { "HDFGWTR_EL2", 401 },
    { "HFGITR2_EL2", 402 },
    { "HFGITR_EL2", 403 },
    { "HFGRTR2_EL2", 404 },
    { "HFGRTR_EL2", 405 },
    { "HFGWTR2_EL2", 406 },
    { "HFGWTR_EL2", 407 },
    { "HPFAR_EL2", 408 },
    { "HSTR_EL2", 409 },
    { "ICC_AP0R0_EL1", 410 },
    { "ICC_AP0R1_EL1", 411 },
    { "ICC_AP0R2_EL1", 412 },
    { "ICC_AP0R3_EL1", 413 },
    { "ICC_AP1R0_EL1", 414 },
    { "ICC_AP1R1_EL1", 415 },
    { "ICC_AP1R2_EL1", 416 },
    { "ICC_AP1R3_EL1", 417 },
    { "ICC_ASGI1R_EL1", 418 },
    { "ICC_BPR0_EL1", 419 },
    { "ICC_BPR1_EL1", 420 },
    { "ICC_CTLR_EL1", 421 },
    { "ICC_CTLR_EL3", 422 },
    { "ICC_DIR_EL1", 423 },
    { "ICC_EOIR0_EL1", 424 },
    { "ICC_EOIR1_EL1", 425 },
    { "ICC_HPPIR0_EL1", 426 },
    { "ICC_HPPIR1_EL1", 427 },
    { "ICC_IAR0_EL1", 428 },
    { "ICC_IAR1_EL1", 429 },
    { "ICC_IGRPEN0_EL1", 430 },
    { "ICC_IGRPEN1_EL1", 431 },
    { "ICC_IGRPEN1_EL3", 432 },
    { "ICC_NMIAR1_EL1", 433 },
    { "ICC_PMR_EL1", 434 },
    { "ICC_RPR_EL1", 435 },
    { "ICC_SGI0R_EL1", 436 },
    { "ICC_SGI1R_EL1", 437 },
    { "ICC_SRE_EL1", 438 },
    { "ICC_SRE_EL2", 439 },
    { "ICC_SRE_EL3", 440 },
    { "ICH_AP0R0_EL2", 441 },
    { "ICH_AP0R1_EL2", 442 },
    { "ICH_AP0R2_EL2", 443 },
    { "ICH_AP0R3_EL2", 444 },
    { "ICH_AP1R0_EL2", 445 },
    { "ICH_AP1R1_EL2", 446 },
    { "ICH_AP1R2_EL2", 447 },
    { "ICH_AP1R3_EL2", 448 },
    { "ICH_EISR_EL2", 449 },
    { "ICH_ELRSR_EL2", 450 },
    { "ICH_HCR_EL2", 451 },
    { "ICH_LR0_EL2", 452 },
    { "ICH_LR10_EL2", 453 },
    { "ICH_LR11_EL2", 454 },
    { "ICH_LR12_EL2", 455 },
    { "ICH_LR13_EL2", 456 },
    { "ICH_LR14_EL2", 457 },
    { "ICH_LR15_EL2", 458 },
    { "ICH_LR1_EL2", 459 },
    { "ICH_LR2_EL2", 460 },
    { "ICH_LR3_EL2", 461 },
    { "ICH_LR4_EL2", 462 },
    { "ICH_LR5_EL2", 463 },
    { "ICH_LR6_EL2", 464 },
    { "ICH_LR7_EL2", 465 },
    { "ICH_LR8_EL2", 466 },
    { "ICH_LR9_EL2", 467 },
    { "ICH_MISR_EL2", 468 },
    { "ICH_VMCR_EL2", 469 },
    { "ICH_VTR_EL2", 470 },
    { "ID_AA64AFR0_EL1", 471 },
    { "ID_AA64AFR1_EL1", 472 },
    { "ID_AA64DFR0_EL1", 473 },
    { "ID_AA64DFR1_EL1", 474 },
    { "ID_AA64ISAR0_EL1", 475 },
    { "ID_AA64ISAR1_EL1", 476 },
    { "ID_AA64ISAR2_EL1", 477 },
    { "ID_AA64MMFR0_EL1", 478 },
    { "ID_AA64MMFR1_EL1", 479 },
    { "ID_AA64MMFR2_EL1", 480 },
    { "ID_AA64MMFR3_EL1", 481 },
    { "ID_AA64MMFR4_EL1", 482 },
    { "ID_AA64PFR0_EL1", 483 },
    { "ID_AA64PFR1_EL1", 484 },
    { "ID_AA64PFR2_EL1", 485 },
    { "ID_AA64SMFR0_EL1", 486 },
    { "ID_AA64ZFR0_EL1", 487 },
    { "ID_AFR0_EL1", 488 },
    { "ID_DFR0_EL1", 489 },
    { "ID_DFR1_EL1", 490 },
    { "ID_ISAR0_EL1", 491 },
    { "ID_ISAR1_EL1", 492 },
    { "ID_ISAR2_EL1", 493 },
    { "ID_ISAR3_EL1", 494 },
    { "ID_ISAR4_EL1", 495 },
    { "ID_ISAR5_EL1", 496 },
    { "ID_ISAR6_EL1", 497 },
    { "ID_MMFR0_EL1", 498 },
    { "ID_MMFR1_EL1", 499 },
    { "ID_MMFR2_EL1", 500 },
    { "ID_MMFR3_EL1", 501 },
    { "ID_MMFR4_EL1", 502 },
    { "ID_MMFR5_EL1", 503 },
    { "ID_PFR0_EL1", 504 },
    { "ID_PFR1_EL1", 505 },
    { "ID_PFR2_EL1", 506 },
    { "IFSR32_EL2", 507 },
    { "ISR_EL1", 508 },
    { "LORC_EL1", 509 },
    { "LOREA_EL1", 510 },
    { "LORID_EL1", 511 },
    { "LORN_EL1", 512 },
    { "LORSA_EL1", 513 },
    { "MAIR2_EL1", 514 },
    { "MAIR2_EL12", 515 },
    { "MAIR2_EL2", 516 },
    { "MAIR2_EL3", 517 },
    { "MAIR_EL1", 518 },
    { "MAIR_EL12", 519 },
    { "MAIR_EL2", 520 },
    { "MAIR_EL3", 521 },
    { "MDCCINT_EL1", 522 },
    { "MDCCSR_EL0", 523 },
    { "MDCR_EL2", 524 },
    { "MDCR_EL3", 525 },
    { "MDRAR_EL1", 526 },
    { "MDSCR_EL1", 527 },
    { "MDSELR_EL1", 528 },
    { "MECIDR_EL2", 529 },
    { "MECID_A0_EL2", 530 },
    { "MECID_A1_EL2", 531 },
    { "MECID_P0_EL2", 532 },
    { "MECID_P1_EL2", 533 },
    { "MECID_RL_A_EL3", 534 },
    { "MFAR_EL3", 535 },
    { "MIDR_EL1", 536 },
    { "MPAM0_EL1", 537 },
    { "MPAM1_EL1", 538 },
    { "MPAM1_EL12", 539 },
    { "MPAM2_EL2", 540 },
    { "MPAM3_EL3", 541 },
    { "MPAMHCR_EL2", 542 },
    { "MPAMIDR_EL1", 543 },
    { "MPAMSM_EL1", 544 },
    { "MPAMVPM0_EL2", 545 },
    { "MPAMVPM1_EL2", 546 },
    { "MPAMVPM2_EL2", 547 },
    { "MPAMVPM3_EL2", 548 },
    { "MPAMVPM4_EL2", 549 },
    { "MPAMVPM5_EL2", 550 },
    { "MPAMVPM6_EL2", 551 },
    { "MPAMVPM7_EL2", 552 },
    { "MPAMVPMV_EL2", 553 },
    { "MPIDR_EL1", 554 },
    { "MPUIR_EL1", 555 },
    { "MPUIR_EL2", 556 },
    { "MVFR0_EL1", 557 },
    { "MVFR1_EL1", 558 },
    { "MVFR2_EL1", 559 },
    { "NZCV", 560 },
    { "OSDLR_EL1", 561 },
    { "OSDTRRX_EL1", 562 },
    { "OSDTRTX_EL1", 563 },
    { "OSECCR_EL1", 564 },
    { "OSLAR_EL1", 565 },
    { "OSLSR_EL1", 566 },
    { "PAN", 567 },
    { "PAR_EL1", 568 },
    { "PFAR_EL1", 569 },
    { "PFAR_EL12", 570 },
    { "PFAR_EL2", 571 },
    { "PIRE0_EL1", 572 },
    { "PIRE0_EL12", 573 },
    { "PIRE0_EL2", 574 },
    { "PIR_EL1", 575 },
    { "PIR_EL12", 576 },
    { "PIR_EL2", 577 },
    { "PIR_EL3", 578 },
    { "PM", 579 },
    { "PMBIDR_EL1", 580 },
    { "PMBLIMITR_EL1", 581 },
    { "PMBPTR_EL1", 582 },
    { "PMBSR_EL1", 583 },
    { "PMCCFILTR_EL0", 584 },
    { "PMCCNTR_EL0", 585 },
    { "PMCCNTSVR_EL1", 586 },
    { "PMCEID0_EL0", 587 },
    { "PMCEID1_EL0", 588 },
    { "PMCNTENCLR_EL0", 589 },
    { "PMCNTENSET_EL0", 590 },
    { "PMCR_EL0", 591 },
    { "PMECR_EL1", 592 },
    { "PMEVCNTR0_EL0", 593 },
    { "PMEVCNTR10_EL0", 594 },
    { "PMEVCNTR11_EL0", 595 },
    { "PMEVCNTR12_EL0", 596 },
    { "PMEVCNTR13_EL0", 597 },
    { "PMEVCNTR14_EL0", 598 },
    { "PMEVCNTR15_EL0", 599 },
    { "PMEVCNTR16_EL0", 600 },
    { "PMEVCNTR17_EL0", 601 },
    { "PMEVCNTR18_EL0", 602 },
    { "PMEVCNTR19_EL0", 603 },
    { "PMEVCNTR1_EL0", 604 },
    { "PMEVCNTR20_EL0", 605 },
    { "PMEVCNTR21_EL0", 606 },
    { "PMEVCNTR22_EL0", 607 },
    { "PMEVCNTR23_EL0", 608 },
    { "PMEVCNTR24_EL0", 609 },
    { "PMEVCNTR25_EL0", 610 },
    { "PMEVCNTR26_EL0", 611 },
    { "PMEVCNTR27_EL0", 612 },
    { "PMEVCNTR28_EL0", 613 },
    { "PMEVCNTR29_EL0", 614 },
    { "PMEVCNTR2_EL0", 615 },
    { "PMEVCNTR30_EL0", 616 },
    { "PMEVCNTR3_EL0", 617 },
    { "PMEVCNTR4_EL0", 618 },
    { "PMEVCNTR5_EL0", 619 },
    { "PMEVCNTR6_EL0", 620 },
    { "PMEVCNTR7_EL0", 621 },
    { "PMEVCNTR8_EL0", 622 },
    { "PMEVCNTR9_EL0", 623 },
    { "PMEVCNTSVR0_EL1", 624 },
    { "PMEVCNTSVR10_EL1", 625 },
    { "PMEVCNTSVR11_EL1", 626 },
    { "PMEVCNTSVR12_EL1", 627 },
    { "PMEVCNTSVR13_EL1", 628 },
    { "PMEVCNTSVR14_EL1", 629 },
    { "PMEVCNTSVR15_EL1", 630 },
    { "PMEVCNTSVR16_EL1", 631 },
    { "PMEVCNTSVR17_EL1", 632 },
    { "PMEVCNTSVR18_EL1", 633 },
    { "PMEVCNTSVR19_EL1", 634 },
    { "PMEVCNTSVR1_EL1", 635 },
    { "PMEVCNTSVR20_EL1", 636 },
    { "PMEVCNTSVR21_EL1", 637 },
    { "PMEVCNTSVR22_EL1", 638 },
    { "PMEVCNTSVR23_EL1", 639 },
    { "PMEVCNTSVR24_EL1", 640 },
    { "PMEVCNTSVR25_EL1", 641 },
    { "PMEVCNTSVR26_EL1", 642 },
    { "PMEVCNTSVR27_EL1", 643 },
    { "PMEVCNTSVR28_EL1", 644 },
    { "PMEVCNTSVR29_EL1", 645 },
    { "PMEVCNTSVR2_EL1", 646 },
    { "PMEVCNTSVR30_EL1", 647 },
    { "PMEVCNTSVR3_EL1", 648 },
    { "PMEVCNTSVR4_EL1", 649 },
    { "PMEVCNTSVR5_EL1", 650 },
    { "PMEVCNTSVR6_EL1", 651 },
    { "PMEVCNTSVR7_EL1", 652 },
    { "PMEVCNTSVR8_EL1", 653 },
    { "PMEVCNTSVR9_EL1", 654 },
    { "PMEVTYPER0_EL0", 655 },
    { "PMEVTYPER10_EL0", 656 },
    { "PMEVTYPER11_EL0", 657 },
    { "PMEVTYPER12_EL0", 658 },
    { "PMEVTYPER13_EL0", 659 },
    { "PMEVTYPER14_EL0", 660 },
    { "PMEVTYPER15_EL0", 661 },
    { "PMEVTYPER16_EL0", 662 },
    { "PMEVTYPER17_EL0", 663 },
    { "PMEVTYPER18_EL0", 664 },
    { "PMEVTYPER19_EL0", 665 },
    { "PMEVTYPER1_EL0", 666 },
    { "PMEVTYPER20_EL0", 667 },
    { "PMEVTYPER21_EL0", 668 },
    { "PMEVTYPER22_EL0", 669 },
    { "PMEVTYPER23_EL0", 670 },
    { "PMEVTYPER24_EL0", 671 },
    { "PMEVTYPER25_EL0", 672 },
    { "PMEVTYPER26_EL0", 673 },
    { "PMEVTYPER27_EL0", 674 },
    { "PMEVTYPER28_EL0", 675 },
    { "PMEVTYPER29_EL0", 676 },
    { "PMEVTYPER2_EL0", 677 },
    { "PMEVTYPER30_EL0", 678 },
    { "PMEVTYPER3_EL0", 679 },
    { "PMEVTYPER4_EL0", 680 },
    { "PMEVTYPER5_EL0", 681 },
    { "PMEVTYPER6_EL0", 682 },
    { "PMEVTYPER7_EL0", 683 },
    { "PMEVTYPER8_EL0", 684 },
    { "PMEVTYPER9_EL0", 685 },
    { "PMIAR_EL1", 686 },
    { "PMICFILTR_EL0", 687 },
    { "PMICNTR_EL0", 688 },
    { "PMICNTSVR_EL1", 689 },
    { "PMINTENCLR_EL1", 690 },
    { "PMINTENSET_EL1", 691 },
    { "PMMIR_EL1", 692 },
    { "PMOVSCLR_EL0", 693 },
    { "PMOVSSET_EL0", 694 },
    { "PMSCR_EL1", 695 },
    { "PMSCR_EL12", 696 },
    { "PMSCR_EL2", 697 },
    { "PMSDSFR_EL1", 698 },
    { "PMSELR_EL0", 699 },
    { "PMSEVFR_EL1", 700 },
    { "PMSFCR_EL1", 701 },
    { "PMSICR_EL1", 702 },
    { "PMSIDR_EL1", 703 },
    { "PMSIRR_EL1", 704 },
    { "PMSLATFR_EL1", 705 },
    { "PMSNEVFR_EL1", 706 },
    { "PMSSCR_EL1", 707 },
    { "PMSWINC_EL0", 708 },
    { "PMUACR_EL1", 709 },
    { "PMUSERENR_EL0", 710 },
    { "PMXEVCNTR_EL0", 711 },
    { "PMXEVTYPER_EL0", 712 },
    { "PMZR_EL0", 713 },
    { "POR_EL0", 714 },
    { "POR_EL1", 715 },
    { "POR_EL12", 716 },
    { "POR_EL2", 717 },
    { "POR_EL3", 718 },
    { "PRBAR10_EL1", 719 },
    { "PRBAR10_EL2", 720 },
    { "PRBAR11_EL1", 721 },
    { "PRBAR11_EL2", 722 },
    { "PRBAR12_EL1", 723 },
    { "PRBAR12_EL2", 724 },
    { "PRBAR13_EL1", 725 },
    { "PRBAR13_EL2", 726 },
    { "PRBAR14_EL1", 727 },
    { "PRBAR14_EL2", 728 },
    { "PRBAR15_EL1", 729 },
    { "PRBAR15_EL2", 730 },
    { "PRBAR1_EL1", 731 },
    { "PRBAR1_EL2", 732 },
    { "PRBAR2_EL1", 733 },
    { "PRBAR2_EL2", 734 },
    { "PRBAR3_EL1", 735 },
    { "PRBAR3_EL2", 736 },
    { "PRBAR4_EL1", 737 },
    { "PRBAR4_EL2", 738 },
    { "PRBAR5_EL1", 739 },
    { "PRBAR5_EL2", 740 },
    { "PRBAR6_EL1", 741 },
    { "PRBAR6_EL2", 742 },
    { "PRBAR7_EL1", 743 },
    { "PRBAR7_EL2", 744 },
    { "PRBAR8_EL1", 745 },
    { "PRBAR8_EL2", 746 },
    { "PRBAR9_EL1", 747 },
    { "PRBAR9_EL2", 748 },
    { "PRBAR_EL1", 749 },
    { "PRBAR_EL2", 750 },
    { "PRENR_EL1", 751 },
    { "PRENR_EL2", 752 },
    { "PRLAR10_EL1", 753 },
    { "PRLAR10_EL2", 754 },
    { "PRLAR11_EL1", 755 },
    { "PRLAR11_EL2", 756 },
    { "PRLAR12_EL1", 757 },
    { "PRLAR12_EL2", 758 },
    { "PRLAR13_EL1", 759 },
    { "PRLAR13_EL2", 760 },
    { "PRLAR14_EL1", 761 },
    { "PRLAR14_EL2", 762 },
    { "PRLAR15_EL1", 763 },
    { "PRLAR15_EL2", 764 },
    { "PRLAR1_EL1", 765 },
    { "PRLAR1_EL2", 766 },
    { "PRLAR2_EL1", 767 },
    { "PRLAR2_EL2", 768 },
    { "PRLAR3_EL1", 769 },
    { "PRLAR3_EL2", 770 },
    { "PRLAR4_EL1", 771 },
    { "PRLAR4_EL2", 772 },
    { "PRLAR5_EL1", 773 },
    { "PRLAR5_EL2", 774 },
    { "PRLAR6_EL1", 775 },
    { "PRLAR6_EL2", 776 },
    { "PRLAR7_EL1", 777 },
    { "PRLAR7_EL2", 778 },
    { "PRLAR8_EL1", 779 },
    { "PRLAR8_EL2", 780 },
    { "PRLAR9_EL1", 781 },
    { "PRLAR9_EL2", 782 },
    { "PRLAR_EL1", 783 },
    { "PRLAR_EL2", 784 },
    { "PRSELR_EL1", 785 },
    { "PRSELR_EL2", 786 },
    { "RCWMASK_EL1", 787 },
    { "RCWSMASK_EL1", 788 },
    { "REVIDR_EL1", 789 },
    { "RGSR_EL1", 790 },
    { "RMR_EL1", 791 },
    { "RMR_EL2", 792 },
    { "RMR_EL3", 793 },
    { "RNDR", 794 },
    { "RNDRRS", 795 },
    { "RVBAR_EL1", 796 },
    { "RVBAR_EL2", 797 },
    { "RVBAR_EL3", 798 },
    { "S2PIR_EL2", 799 },
    { "S2POR_EL1", 800 },
    { "SCR_EL3", 801 },
    { "SCTLR2_EL1", 802 },
    { "SCTLR2_EL12", 803 },
    { "SCTLR2_EL2", 804 },
    { "SCTLR2_EL3", 805 },
    { "SCTLR_EL1", 806 },
    { "SCTLR_EL12", 807 },
    { "SCTLR_EL2", 808 },
    { "SCTLR_EL3", 809 },
    { "SCXTNUM_EL0", 810 },
    { "SCXTNUM_EL1", 811 },
    { "SCXTNUM_EL12", 812 },
    { "SCXTNUM_EL2", 813 },
    { "SCXTNUM_EL3", 814 },
    { "SDER32_EL2", 815 },
    { "SDER32_EL3", 816 },
    { "SMCR_EL1", 817 },
    { "SMCR_EL12", 818 },
    { "SMCR_EL2", 819 },
    { "SMCR_EL3", 820 },
    { "SMIDR_EL1", 821 },
    { "SMPRIMAP_EL2", 822 },
    { "SMPRI_EL1", 823 },
    { "SPMACCESSR_EL1", 824 },
    { "SPMACCESSR_EL12", 825 },
    { "SPMACCESSR_EL2", 826 },
    { "SPMACCESSR_EL3", 827 },
    { "SPMCFGR_EL1", 828 },
    { "SPMCGCR0_EL1", 829 },
    { "SPMCGCR1_EL1", 830 },
    { "SPMCNTENCLR_EL0", 831 },
    { "SPMCNTENSET_EL0", 832 },
    { "SPMCR_EL0", 833 },
    { "SPMDEVAFF_EL1", 834 },
    { "SPMDEVARCH_EL1", 835 },
    { "SPMEVCNTR0_EL0", 836 },
    { "SPMEVCNTR10_EL0", 837 },
    { "SPMEVCNTR11_EL0", 838 },
    { "SPMEVCNTR12_EL0", 839 },
    { "SPMEVCNTR13_EL0", 840 },
    { "SPMEVCNTR14_EL0", 841 },
    { "SPMEVCNTR15_EL0", 842 },
    { "SPMEVCNTR1_EL0", 843 },
    { "SPMEVCNTR2_EL0", 844 },
    { "SPMEVCNTR3_EL0", 845 },
    { "SPMEVCNTR4_EL0", 846 },
    { "SPMEVCNTR5_EL0", 847 },
    { "SPMEVCNTR6_EL0", 848 },
    { "SPMEVCNTR7_EL0", 849 },
    { "SPMEVCNTR8_EL0", 850 },
    { "SPMEVCNTR9_EL0", 851 },
    { "SPMEVFILT2R0_EL0", 852 },
    { "SPMEVFILT2R10_EL0", 853 },
    { "SPMEVFILT2R11_EL0", 854 },
    { "SPMEVFILT2R12_EL0", 855 },
    { "SPMEVFILT2R13_EL0", 856 },
    { "SPMEVFILT2R14_EL0", 857 },
    { "SPMEVFILT2R15_EL0", 858 },
    { "SPMEVFILT2R1_EL0", 859 },
    { "SPMEVFILT2R2_EL0", 860 },
    { "SPMEVFILT2R3_EL0", 861 },
    { "SPMEVFILT2R4_EL0", 862 },
    { "SPMEVFILT2R5_EL0", 863 },
    { "SPMEVFILT2R6_EL0", 864 },
    { "SPMEVFILT2R7_EL0", 865 },
    { "SPMEVFILT2R8_EL0", 866 },
    { "SPMEVFILT2R9_EL0", 867 },
    { "SPMEVFILTR0_EL0", 868 },
    { "SPMEVFILTR10_EL0", 869 },
    { "SPMEVFILTR11_EL0", 870 },
    { "SPMEVFILTR12_EL0", 871 },
    { "SPMEVFILTR13_EL0", 872 },
    { "SPMEVFILTR14_EL0", 873 },
    { "SPMEVFILTR15_EL0", 874 },
    { "SPMEVFILTR1_EL0", 875 },
    { "SPMEVFILTR2_EL0", 876 },
    { "SPMEVFILTR3_EL0", 877 },
    { "SPMEVFILTR4_EL0", 878 },
    { "SPMEVFILTR5_EL0", 879 },
    { "SPMEVFILTR6_EL0", 880 },
    { "SPMEVFILTR7_EL0", 881 },
    { "SPMEVFILTR8_EL0", 882 },
    { "SPMEVFILTR9_EL0", 883 },
    { "SPMEVTYPER0_EL0", 884 },
    { "SPMEVTYPER10_EL0", 885 },
    { "SPMEVTYPER11_EL0", 886 },
    { "SPMEVTYPER12_EL0", 887 },
    { "SPMEVTYPER13_EL0", 888 },
    { "SPMEVTYPER14_EL0", 889 },
    { "SPMEVTYPER15_EL0", 890 },
    { "SPMEVTYPER1_EL0", 891 },
    { "SPMEVTYPER2_EL0", 892 },
    { "SPMEVTYPER3_EL0", 893 },
    { "SPMEVTYPER4_EL0", 894 },
    { "SPMEVTYPER5_EL0", 895 },
    { "SPMEVTYPER6_EL0", 896 },
    { "SPMEVTYPER7_EL0", 897 },
    { "SPMEVTYPER8_EL0", 898 },
    { "SPMEVTYPER9_EL0", 899 },
    { "SPMIIDR_EL1", 900 },
    { "SPMINTENCLR_EL1", 901 },
    { "SPMINTENSET_EL1", 902 },
    { "SPMOVSCLR_EL0", 903 },
    { "SPMOVSSET_EL0", 904 },
    { "SPMROOTCR_EL3", 905 },
    { "SPMSCR_EL1", 906 },
    { "SPMSELR_EL0", 907 },
    { "SPSEL", 908 },
    { "SPSR_ABT", 909 },
    { "SPSR_EL1", 910 },
    { "SPSR_EL12", 911 },
    { "SPSR_EL2", 912 },
    { "SPSR_EL3", 913 },
    { "SPSR_FIQ", 914 },
    { "SPSR_IRQ", 915 },
    { "SPSR_UND", 916 },
    { "SP_EL0", 917 },
    { "SP_EL1", 918 },
    { "SP_EL2", 919 },
    { "SSBS", 920 },
    { "SVCR", 921 },
    { "TCO", 922 },
    { "TCR2_EL1", 923 },
    { "TCR2_EL12", 924 },
    { "TCR2_EL2", 925 },
    { "TCR_EL1", 926 },
    { "TCR_EL12", 927 },
    { "TCR_EL2", 928 },
    { "TCR_EL3", 929 },
    { "TEECR32_EL1", 930 },
    { "TEEHBR32_EL1", 931 },
    { "TFSRE0_EL1", 932 },
    { "TFSR_EL1", 933 },
    { "TFSR_EL12", 934 },
    { "TFSR_EL2", 935 },
    { "TFSR_EL3", 936 },
    { "TPIDR2_EL0", 937 },
    { "TPIDRRO_EL0", 938 },
    { "TPIDR_EL0", 939 },
    { "TPIDR_EL1", 940 },
    { "TPIDR_EL2", 941 },
    { "TPIDR_EL3", 942 },
    { "TRBBASER_EL1", 943 },
    { "TRBIDR_EL1", 944 },
    { "TRBLIMITR_EL1", 945 },
    { "TRBMAR_EL1", 946 },
    { "TRBPTR_EL1", 947 },
    { "TRBSR_EL1", 948 },
    { "TRBTRG_EL1", 949 },
    { "TRCACATR0", 950 },
    { "TRCACATR1", 951 },
    { "TRCACATR10", 952 },
    { "TRCACATR11", 953 },
    { "TRCACATR12", 954 },
    { "TRCACATR13", 955 },
    { "TRCACATR14", 956 },
    { "TRCACATR15", 957 },
    { "TRCACATR2", 958 },
    { "TRCACATR3", 959 },
    { "TRCACATR4", 960 },
    { "TRCACATR5", 961 },
    { "TRCACATR6", 962 },
    { "TRCACATR7", 963 },
    { "TRCACATR8", 964 },
    { "TRCACATR9", 965 },
    { "TRCACVR0", 966 },
    { "TRCACVR1", 967 },
    { "TRCACVR10", 968 },
    { "TRCACVR11", 969 },
    { "TRCACVR12", 970 },
    { "TRCACVR13", 971 },
    { "TRCACVR14", 972 },
    { "TRCACVR15", 973 },
    { "TRCACVR2", 974 },
    { "TRCACVR3", 975 },
    { "TRCACVR4", 976 },
    { "TRCACVR5", 977 },
    { "TRCACVR6", 978 },
    { "TRCACVR7", 979 },
    { "TRCACVR8", 980 },
    { "TRCACVR9", 981 },
    { "TRCAUTHSTATUS", 982 },
    { "TRCAUXCTLR", 983 },
    { "TRCBBCTLR", 984 },
    { "TRCCCCTLR", 985 },
    { "TRCCIDCCTLR0", 986 },
    { "TRCCIDCCTLR1", 987 },
    { "TRCCIDCVR0", 988 },
    { "TRCCIDCVR1", 989 },
    { "TRCCIDCVR2", 990 },
    { "TRCCIDCVR3", 991 },
    { "TRCCIDCVR4", 992 },
    { "TRCCIDCVR5", 993 },
    { "TRCCIDCVR6", 994 },
    { "TRCCIDCVR7", 995 },
    { "TRCCIDR0", 996 },
    { "TRCCIDR1", 997 },
    { "TRCCIDR2", 998 },
    { "TRCCIDR3", 999 },
    { "TRCCLAIMCLR", 1000 },
    { "TRCCLAIMSET", 1001 },
    { "TRCCNTCTLR0", 1002 },
    { "TRCCNTCTLR1", 1003 },
    { "TRCCNTCTLR2", 1004 },
    { "TRCCNTCTLR3", 1005 },
    { "TRCCNTRLDVR0", 1006 },
    { "TRCCNTRLDVR1", 1007 },
    { "TRCCNTRLDVR2", 1008 },
    { "TRCCNTRLDVR3", 1009 },
    { "TRCCNTVR0", 1010 },
    { "TRCCNTVR1", 1011 },
    { "TRCCNTVR2", 1012 },
    { "TRCCNTVR3", 1013 },
    { "TRCCONFIGR", 1014 },
    { "TRCDEVAFF0", 1015 },
    { "TRCDEVAFF1", 1016 },
    { "TRCDEVARCH", 1017 },
    { "TRCDEVID", 1018 },
    { "TRCDEVTYPE", 1019 },
    { "TRCDVCMR0", 1020 },
    { "TRCDVCMR1", 1021 },
    { "TRCDVCMR2", 1022 },
    { "TRCDVCMR3", 1023 },
    { "TRCDVCMR4", 1024 },
    { "TRCDVCMR5", 1025 },
    { "TRCDVCMR6", 1026 },
    { "TRCDVCMR7", 1027 },
    { "TRCDVCVR0", 1028 },
    { "TRCDVCVR1", 1029 },
    { "TRCDVCVR2", 1030 },
    { "TRCDVCVR3", 1031 },
    { "TRCDVCVR4", 1032 },
    { "TRCDVCVR5", 1033 },
    { "TRCDVCVR6", 1034 },
    { "TRCDVCVR7", 1035 },
    { "TRCEVENTCTL0R", 1036 },
    { "TRCEVENTCTL1R", 1037 },
    { "TRCEXTINSELR", 1038 },
    { "TRCEXTINSELR0", 1039 },
    { "TRCEXTINSELR1", 1040 },
    { "TRCEXTINSELR2", 1041 },
    { "TRCEXTINSELR3", 1042 },
    { "TRCIDR0", 1043 },
    { "TRCIDR1", 1044 },
    { "TRCIDR10", 1045 },
    { "TRCIDR11", 1046 },
    { "TRCIDR12", 1047 },
    { "TRCIDR13", 1048 },
    { "TRCIDR2", 1049 },
    { "TRCIDR3", 1050 },
    { "TRCIDR4", 1051 },
    { "TRCIDR5", 1052 },
    { "TRCIDR6", 1053 },
    { "TRCIDR7", 1054 },
    { "TRCIDR8", 1055 },
    { "TRCIDR9", 1056 },
    { "TRCIMSPEC0", 1057 },
    { "TRCIMSPEC1", 1058 },
    { "TRCIMSPEC2", 1059 },
    { "TRCIMSPEC3", 1060 },
    { "TRCIMSPEC4", 1061 },
    { "TRCIMSPEC5", 1062 },
    { "TRCIMSPEC6", 1063 },
    { "TRCIMSPEC7", 1064 },
    { "TRCITCTRL", 1065 },
    { "TRCITECR_EL1", 1066 },
    { "TRCITECR_EL12", 1067 },
    { "TRCITECR_EL2", 1068 },
    { "TRCITEEDCR", 1069 },
    { "TRCLAR", 1070 },
    { "TRCLSR", 1071 },
    { "TRCOSLAR", 1072 },
    { "TRCOSLSR", 1073 },
    { "TRCPDCR", 1074 },
    { "TRCPDSR", 1075 },
    { "TRCPIDR0", 1076 },
    { "TRCPIDR1", 1077 },
    { "TRCPIDR2", 1078 },
    { "TRCPIDR3", 1079 },
    { "TRCPIDR4", 1080 },
    { "TRCPIDR5", 1081 },
    { "TRCPIDR6", 1082 },
    { "TRCPIDR7", 1083 },
    { "TRCPRGCTLR", 1084 },
    { "TRCPROCSELR", 1085 },
    { "TRCQCTLR", 1086 },
    { "TRCRSCTLR10", 1087 },
    { "TRCRSCTLR11", 1088 },
    { "TRCRSCTLR12", 1089 },
    { "TRCRSCTLR13", 1090 },
    { "TRCRSCTLR14", 1091 },
    { "TRCRSCTLR15", 1092 },
    { "TRCRSCTLR16", 1093 },
    { "TRCRSCTLR17", 1094 },
    { "TRCRSCTLR18", 1095 },
    { "TRCRSCTLR19", 1096 },
    { "TRCRSCTLR2", 1097 },
    { "TRCRSCTLR20", 1098 },
    { "TRCRSCTLR21", 1099 },
    { "TRCRSCTLR22", 1100 },
    { "TRCRSCTLR23", 1101 },
    { "TRCRSCTLR24", 1102 },
    { "TRCRSCTLR25", 1103 },
    { "TRCRSCTLR26", 1104 },
    { "TRCRSCTLR27", 1105 },
    { "TRCRSCTLR28", 1106 },
    { "TRCRSCTLR29", 1107 },
    { "TRCRSCTLR3", 1108 },
    { "TRCRSCTLR30", 1109 },
    { "TRCRSCTLR31", 1110 },
    { "TRCRSCTLR4", 1111 },
    { "TRCRSCTLR5", 1112 },
    { "TRCRSCTLR6", 1113 },
    { "TRCRSCTLR7", 1114 },
    { "TRCRSCTLR8", 1115 },
    { "TRCRSCTLR9", 1116 },
    { "TRCRSR", 1117 },
    { "TRCSEQEVR0", 1118 },
    { "TRCSEQEVR1", 1119 },
    { "TRCSEQEVR2", 1120 },
    { "TRCSEQRSTEVR", 1121 },
    { "TRCSEQSTR", 1122 },
    { "TRCSSCCR0", 1123 },
    { "TRCSSCCR1", 1124 },
    { "TRCSSCCR2", 1125 },
    { "TRCSSCCR3", 1126 },
    { "TRCSSCCR4", 1127 },
    { "TRCSSCCR5", 1128 },
    { "TRCSSCCR6", 1129 },
    { "TRCSSCCR7", 1130 },
    { "TRCSSCSR0", 1131 },
    { "TRCSSCSR1", 1132 },
    { "TRCSSCSR2", 1133 },
    { "TRCSSCSR3", 1134 },
    { "TRCSSCSR4", 1135 },
    { "TRCSSCSR5", 1136 },
    { "TRCSSCSR6", 1137 },
    { "TRCSSCSR7", 1138 },
    { "TRCSSPCICR0", 1139 },
    { "TRCSSPCICR1", 1140 },
    { "TRCSSPCICR2", 1141 },
    { "TRCSSPCICR3", 1142 },
    { "TRCSSPCICR4", 1143 },
    { "TRCSSPCICR5", 1144 },
    { "TRCSSPCICR6", 1145 },
    { "TRCSSPCICR7", 1146 },
    { "TRCSTALLCTLR", 1147 },
    { "TRCSTATR", 1148 },
    { "TRCSYNCPR", 1149 },
    { "TRCTRACEIDR", 1150 },
    { "TRCTSCTLR", 1151 },
    { "TRCVDARCCTLR", 1152 },
    { "TRCVDCTLR", 1153 },
    { "TRCVDSACCTLR", 1154 },
    { "TRCVICTLR", 1155 },
    { "TRCVIIECTLR", 1156 },
    { "TRCVIPCSSCTLR", 1157 },
    { "TRCVISSCTLR", 1158 },
    { "TRCVMIDCCTLR0", 1159 },
    { "TRCVMIDCCTLR1", 1160 },
    { "TRCVMIDCVR0", 1161 },
    { "TRCVMIDCVR1", 1162 },
    { "TRCVMIDCVR2", 1163 },
    { "TRCVMIDCVR3", 1164 },
    { "TRCVMIDCVR4", 1165 },
    { "TRCVMIDCVR5", 1166 },
    { "TRCVMIDCVR6", 1167 },
    { "TRCVMIDCVR7", 1168 },
    { "TRFCR_EL1", 1169 },
    { "TRFCR_EL12", 1170 },
    { "TRFCR_EL2", 1171 },
    { "TTBR0_EL1", 1172 },
    { "TTBR0_EL12", 1173 },
    { "TTBR0_EL2", 1174 },
    { "TTBR0_EL3", 1175 },
    { "TTBR1_EL1", 1176 },
    { "TTBR1_EL12", 1177 },
    { "TTBR1_EL2", 1178 },
    { "UAO", 1179 },
    { "VBAR_EL1", 1180 },
    { "VBAR_EL12", 1181 },
    { "VBAR_EL2", 1182 },
    { "VBAR_EL3", 1183 },
    { "VDISR_EL2", 1184 },
    { "VMECID_A_EL2", 1185 },
    { "VMECID_P_EL2", 1186 },
    { "VMPIDR_EL2", 1187 },
    { "VNCR_EL2", 1188 },
    { "VPIDR_EL2", 1189 },
    { "VSCTLR_EL2", 1190 },
    { "VSESR_EL2", 1191 },
    { "VSTCR_EL2", 1192 },
    { "VSTTBR_EL2", 1193 },
    { "VTCR_EL2", 1194 },
    { "VTTBR_EL2", 1195 },
    { "ZCR_EL1", 1196 },
    { "ZCR_EL12", 1197 },
    { "ZCR_EL2", 1198 },
    { "ZCR_EL3", 1199 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SysRegsList[Idx->_index];
}

const SysReg *lookupSysRegByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x8002, 562 },
    { 0x8004, 291 },
    { 0x8005, 275 },
    { 0x8006, 330 },
    { 0x8007, 314 },
    { 0x800C, 298 },
    { 0x800D, 282 },
    { 0x800E, 337 },
    { 0x800F, 321 },
    { 0x8010, 522 },
    { 0x8012, 527 },
    { 0x8014, 299 },
    { 0x8015, 283 },
    { 0x8016, 338 },
    { 0x8017, 322 },
    { 0x801A, 563 },
    { 0x801C, 300 },
    { 0x801D, 284 },
    { 0x801E, 339 },
    { 0x801F, 323 },
    { 0x8022, 528 },
    { 0x8024, 301 },
    { 0x8025, 285 },
    { 0x8026, 340 },
    { 0x8027, 324 },
    { 0x802C, 302 },
    { 0x802D, 286 },
    { 0x802E, 341 },
    { 0x802F, 325 },
    { 0x8032, 564 },
    { 0x8034, 303 },
    { 0x8035, 287 },
    { 0x8036, 342 },
    { 0x8037, 326 },
    { 0x803C, 304 },
    { 0x803D, 288 },
    { 0x803E, 343 },
    { 0x803F, 327 },
    { 0x8044, 305 },
    { 0x8045, 289 },
    { 0x8046, 344 },
    { 0x8047, 328 },
    { 0x804C, 306 },
    { 0x804D, 290 },
    { 0x804E, 345 },
    { 0x804F, 329 },
    { 0x8054, 292 },
    { 0x8055, 276 },
    { 0x8056, 331 },
    { 0x8057, 315 },
    { 0x805C, 293 },
    { 0x805D, 277 },
    { 0x805E, 332 },
    { 0x805F, 316 },
    { 0x8064, 294 },
    { 0x8065, 278 },
    { 0x8066, 333 },
    { 0x8067, 317 },
    { 0x806C, 295 },
    { 0x806D, 279 },
    { 0x806E, 334 },
    { 0x806F, 318 },
    { 0x8074, 296 },
    { 0x8075, 280 },
    { 0x8076, 335 },
    { 0x8077, 319 },
    { 0x807C, 297 },
    { 0x807D, 281 },
    { 0x807E, 336 },
    { 0x807F, 320 },
    { 0x8080, 526 },
    { 0x8084, 565 },
    { 0x808C, 566 },
    { 0x809C, 561 },
    { 0x80A4, 312 },
    { 0x83C6, 308 },
    { 0x83CE, 307 },
    { 0x83F6, 274 },
    { 0x84E8, 829 },
    { 0x84E9, 830 },
    { 0x84EB, 824 },
    { 0x84EC, 900 },
    { 0x84ED, 835 },
    { 0x84EE, 834 },
    { 0x84EF, 828 },
    { 0x84F1, 902 },
    { 0x84F2, 901 },
    { 0x8740, 624 },
    { 0x8741, 635 },
    { 0x8742, 646 },
    { 0x8743, 648 },
    { 0x8744, 649 },
    { 0x8745, 650 },
    { 0x8746, 651 },
    { 0x8747, 652 },
    { 0x8748, 653 },
    { 0x8749, 654 },
    { 0x874A, 625 },
    { 0x874B, 626 },
    { 0x874C, 627 },
    { 0x874D, 628 },
    { 0x874E, 629 },
    { 0x874F, 630 },
    { 0x8750, 631 },
    { 0x8751, 632 },
    { 0x8752, 633 },
    { 0x8753, 634 },
    { 0x8754, 636 },
    { 0x8755, 637 },
    { 0x8756, 638 },
    { 0x8757, 639 },
    { 0x8758, 640 },
    { 0x8759, 641 },
    { 0x875A, 642 },
    { 0x875B, 643 },
    { 0x875C, 644 },
    { 0x875D, 645 },
    { 0x875E, 647 },
    { 0x875F, 586 },
    { 0x8760, 689 },
    { 0x8801, 1150 },
    { 0x8802, 1155 },
    { 0x8804, 1118 },
    { 0x8805, 1006 },
    { 0x8806, 1055 },
    { 0x8807, 1057 },
    { 0x8808, 1084 },
    { 0x8809, 1086 },
    { 0x880A, 1156 },
    { 0x880C, 1119 },
    { 0x880D, 1007 },
    { 0x880E, 1056 },
    { 0x880F, 1058 },
    { 0x8810, 1085 },
    { 0x8811, 1069 },
    { 0x8812, 1158 },
    { 0x8814, 1120 },
    { 0x8815, 1008 },
    { 0x8816, 1045 },
    { 0x8817, 1059 },
    { 0x8818, 1148 },
    { 0x881A, 1157 },
    { 0x881D, 1009 },
    { 0x881E, 1046 },
    { 0x881F, 1060 },
    { 0x8820, 1014 },
    { 0x8825, 1002 },
    { 0x8826, 1047 },
    { 0x8827, 1061 },
    { 0x882D, 1003 },
    { 0x882E, 1048 },
    { 0x882F, 1062 },
    { 0x8830, 983 },
    { 0x8834, 1121 },
    { 0x8835, 1004 },
    { 0x8837, 1063 },
    { 0x883C, 1122 },
    { 0x883D, 1005 },
    { 0x883F, 1064 },
    { 0x8840, 1036 },
    { 0x8842, 1153 },
    { 0x8844, 1038 },
    { 0x8844, 1039 },
    { 0x8845, 1010 },
    { 0x8847, 1043 },
    { 0x8848, 1037 },
    { 0x884A, 1154 },
    { 0x884C, 1040 },
    { 0x884D, 1011 },
    { 0x884F, 1044 },
    { 0x8850, 1117 },
    { 0x8852, 1152 },
    { 0x8854, 1041 },
    { 0x8855, 1012 },
    { 0x8857, 1049 },
    { 0x8858, 1147 },
    { 0x885C, 1042 },
    { 0x885D, 1013 },
    { 0x885F, 1050 },
    { 0x8860, 1151 },
    { 0x8867, 1051 },
    { 0x8868, 1149 },
    { 0x886F, 1052 },
    { 0x8870, 985 },
    { 0x8877, 1053 },
    { 0x8878, 984 },
    { 0x887F, 1054 },
    { 0x8881, 1093 },
    { 0x8882, 1123 },
    { 0x8883, 1139 },
    { 0x8884, 1072 },
    { 0x8889, 1094 },
    { 0x888A, 1124 },
    { 0x888B, 1140 },
    { 0x888C, 1073 },
    { 0x8890, 1097 },
    { 0x8891, 1095 },
    { 0x8892, 1125 },
    { 0x8893, 1141 },
    { 0x8898, 1108 },
    { 0x8899, 1096 },
    { 0x889A, 1126 },
    { 0x889B, 1142 },
    { 0x88A0, 1111 },
    { 0x88A1, 1098 },
    { 0x88A2, 1127 },
    { 0x88A3, 1143 },
    { 0x88A4, 1074 },
    { 0x88A8, 1112 },
    { 0x88A9, 1099 },
    { 0x88AA, 1128 },
    { 0x88AB, 1144 },
    { 0x88AC, 1075 },
    { 0x88B0, 1113 },
    { 0x88B1, 1100 },
    { 0x88B2, 1129 },
    { 0x88B3, 1145 },
    { 0x88B8, 1114 },
    { 0x88B9, 1101 },
    { 0x88BA, 1130 },
    { 0x88BB, 1146 },
    { 0x88C0, 1115 },
    { 0x88C1, 1102 },
    { 0x88C2, 1131 },
    { 0x88C8, 1116 },
    { 0x88C9, 1103 },
    { 0x88CA, 1132 },
    { 0x88D0, 1087 },
    { 0x88D1, 1104 },
    { 0x88D2, 1133 },
    { 0x88D8, 1088 },
    { 0x88D9, 1105 },
    { 0x88DA, 1134 },
    { 0x88E0, 1089 },
    { 0x88E1, 1106 },
    { 0x88E2, 1135 },
    { 0x88E8, 1090 },
    { 0x88E9, 1107 },
    { 0x88EA, 1136 },
    { 0x88F0, 1091 },
    { 0x88F1, 1109 },
    { 0x88F2, 1137 },
    { 0x88F8, 1092 },
    { 0x88F9, 1110 },
    { 0x88FA, 1138 },
    { 0x8900, 966 },
    { 0x8901, 980 },
    { 0x8902, 950 },
    { 0x8903, 964 },
    { 0x8904, 1028 },
    { 0x8905, 1032 },
    { 0x8906, 1020 },
    { 0x8907, 1024 },
    { 0x8910, 967 },
    { 0x8911, 981 },
    { 0x8912, 951 },
    { 0x8913, 965 },
    { 0x8920, 974 },
    { 0x8921, 968 },
    { 0x8922, 958 },
    { 0x8923, 952 },
    { 0x8924, 1029 },
    { 0x8925, 1033 },
    { 0x8926, 1021 },
    { 0x8927, 1025 },
    { 0x8930, 975 },
    { 0x8931, 969 },
    { 0x8932, 959 },
    { 0x8933, 953 },
    { 0x8940, 976 },
    { 0x8941, 970 },
    { 0x8942, 960 },
    { 0x8943, 954 },
    { 0x8944, 1030 },
    { 0x8945, 1034 },
    { 0x8946, 1022 },
    { 0x8947, 1026 },
    { 0x8950, 977 },
    { 0x8951, 971 },
    { 0x8952, 961 },
    { 0x8953, 955 },
    { 0x8960, 978 },
    { 0x8961, 972 },
    { 0x8962, 962 },
    { 0x8963, 956 },
    { 0x8964, 1031 },
    { 0x8965, 1035 },
    { 0x8966, 1023 },
    { 0x8967, 1027 },
    { 0x8970, 979 },
    { 0x8971, 973 },
    { 0x8972, 963 },
    { 0x8973, 957 },
    { 0x8980, 988 },
    { 0x8981, 1161 },
    { 0x8982, 986 },
    { 0x898A, 987 },
    { 0x8990, 989 },
    { 0x8991, 1162 },
    { 0x8992, 1159 },
    { 0x899A, 1160 },
    { 0x89A0, 990 },
    { 0x89A1, 1163 },
    { 0x89B0, 991 },
    { 0x89B1, 1164 },
    { 0x89C0, 992 },
    { 0x89C1, 1165 },
    { 0x89D0, 993 },
    { 0x89D1, 1166 },
    { 0x89E0, 994 },
    { 0x89E1, 1167 },
    { 0x89F0, 995 },
    { 0x89F1, 1168 },
    { 0x8B84, 1065 },
    { 0x8B97, 1018 },
    { 0x8B9F, 1019 },
    { 0x8BA7, 1080 },
    { 0x8BAF, 1081 },
    { 0x8BB7, 1082 },
    { 0x8BBF, 1083 },
    { 0x8BC6, 1001 },
    { 0x8BC7, 1076 },
    { 0x8BCE, 1000 },
    { 0x8BCF, 1077 },
    { 0x8BD6, 1015 },
    { 0x8BD7, 1078 },
    { 0x8BDE, 1016 },
    { 0x8BDF, 1079 },
    { 0x8BE6, 1070 },
    { 0x8BE7, 996 },
    { 0x8BEE, 1071 },
    { 0x8BEF, 997 },
    { 0x8BF6, 982 },
    { 0x8BF7, 998 },
    { 0x8BFE, 1017 },
    { 0x8BFF, 999 },
    { 0x8C00, 118 },
    { 0x8C01, 151 },
    { 0x8C02, 184 },
    { 0x8C04, 125 },
    { 0x8C05, 158 },
    { 0x8C06, 191 },
    { 0x8C08, 129 },
    { 0x8C09, 162 },
    { 0x8C0A, 195 },
    { 0x8C0C, 126 },
    { 0x8C0D, 159 },
    { 0x8C0E, 192 },
    { 0x8C10, 140 },
    { 0x8C11, 173 },
    { 0x8C12, 206 },
    { 0x8C14, 127 },
    { 0x8C15, 160 },
    { 0x8C16, 193 },
    { 0x8C18, 143 },
    { 0x8C19, 176 },
    { 0x8C1A, 209 },
    { 0x8C1C, 128 },
    { 0x8C1D, 161 },
    { 0x8C1E, 194 },
    { 0x8C20, 144 },
    { 0x8C21, 177 },
    { 0x8C22, 210 },
    { 0x8C24, 130 },
    { 0x8C25, 163 },
    { 0x8C26, 196 },
    { 0x8C28, 145 },
    { 0x8C29, 178 },
    { 0x8C2A, 211 },
    { 0x8C2C, 131 },
    { 0x8C2D, 164 },
    { 0x8C2E, 197 },
    { 0x8C30, 146 },
    { 0x8C31, 179 },
    { 0x8C32, 212 },
    { 0x8C34, 132 },
    { 0x8C35, 165 },
    { 0x8C36, 198 },
    { 0x8C38, 147 },
    { 0x8C39, 180 },
    { 0x8C3A, 213 },
    { 0x8C3C, 133 },
    { 0x8C3D, 166 },
    { 0x8C3E, 199 },
    { 0x8C40, 148 },
    { 0x8C41, 181 },
    { 0x8C42, 214 },
    { 0x8C44, 134 },
    { 0x8C45, 167 },
    { 0x8C46, 200 },
    { 0x8C48, 149 },
    { 0x8C49, 182 },
    { 0x8C4A, 215 },
    { 0x8C4C, 135 },
    { 0x8C4D, 168 },
    { 0x8C4E, 201 },
    { 0x8C50, 119 },
    { 0x8C51, 152 },
    { 0x8C52, 185 },
    { 0x8C54, 136 },
    { 0x8C55, 169 },
    { 0x8C56, 202 },
    { 0x8C58, 120 },
    { 0x8C59, 153 },
    { 0x8C5A, 186 },
    { 0x8C5C, 137 },
    { 0x8C5D, 170 },
    { 0x8C5E, 203 },
    { 0x8C60, 121 },
    { 0x8C61, 154 },
    { 0x8C62, 187 },
    { 0x8C64, 138 },
    { 0x8C65, 171 },
    { 0x8C66, 204 },
    { 0x8C68, 122 },
    { 0x8C69, 155 },
    { 0x8C6A, 188 },
    { 0x8C6C, 139 },
    { 0x8C6D, 172 },
    { 0x8C6E, 205 },
    { 0x8C70, 123 },
    { 0x8C71, 156 },
    { 0x8C72, 189 },
    { 0x8C74, 141 },
    { 0x8C75, 174 },
    { 0x8C76, 207 },
    { 0x8C78, 124 },
    { 0x8C79, 157 },
    { 0x8C7A, 190 },
    { 0x8C7C, 142 },
    { 0x8C7D, 175 },
    { 0x8C7E, 208 },
    { 0x8C80, 113 },
    { 0x8C81, 116 },
    { 0x8C82, 217 },
    { 0x8C88, 150 },
    { 0x8C89, 183 },
    { 0x8C8A, 216 },
    { 0x8C90, 117 },
    { 0x9000, 930 },
    { 0x9080, 931 },
    { 0x9808, 523 },
    { 0x9820, 311 },
    { 0x9828, 309 },
    { 0x9828, 310 },
    { 0x9CE0, 833 },
    { 0x9CE1, 832 },
    { 0x9CE2, 831 },
    { 0x9CE3, 903 },
    { 0x9CE5, 907 },
    { 0x9CF3, 904 },
    { 0x9F00, 836 },
    { 0x9F01, 843 },
    { 0x9F02, 844 },
    { 0x9F03, 845 },
    { 0x9F04, 846 },
    { 0x9F05, 847 },
    { 0x9F06, 848 },
    { 0x9F07, 849 },
    { 0x9F08, 850 },
    { 0x9F09, 851 },
    { 0x9F0A, 837 },
    { 0x9F0B, 838 },
    { 0x9F0C, 839 },
    { 0x9F0D, 840 },
    { 0x9F0E, 841 },
    { 0x9F0F, 842 },
    { 0x9F10, 884 },
    { 0x9F11, 891 },
    { 0x9F12, 892 },
    { 0x9F13, 893 },
    { 0x9F14, 894 },
    { 0x9F15, 895 },
    { 0x9F16, 896 },
    { 0x9F17, 897 },
    { 0x9F18, 898 },
    { 0x9F19, 899 },
    { 0x9F1A, 885 },
    { 0x9F1B, 886 },
    { 0x9F1C, 887 },
    { 0x9F1D, 888 },
    { 0x9F1E, 889 },
    { 0x9F1F, 890 },
    { 0x9F20, 868 },
    { 0x9F21, 875 },
    { 0x9F22, 876 },
    { 0x9F23, 877 },
    { 0x9F24, 878 },
    { 0x9F25, 879 },
    { 0x9F26, 880 },
    { 0x9F27, 881 },
    { 0x9F28, 882 },
    { 0x9F29, 883 },
    { 0x9F2A, 869 },
    { 0x9F2B, 870 },
    { 0x9F2C, 871 },
    { 0x9F2D, 872 },
    { 0x9F2E, 873 },
    { 0x9F2F, 874 },
    { 0x9F30, 852 },
    { 0x9F31, 859 },
    { 0x9F32, 860 },
    { 0x9F33, 861 },
    { 0x9F34, 862 },
    { 0x9F35, 863 },
    { 0x9F36, 864 },
    { 0x9F37, 865 },
    { 0x9F38, 866 },
    { 0x9F39, 867 },
    { 0x9F3A, 853 },
    { 0x9F3B, 854 },
    { 0x9F3C, 855 },
    { 0x9F3D, 856 },
    { 0x9F3E, 857 },
    { 0x9F3F, 858 },
    { 0xA038, 313 },
    { 0xA480, 115 },
    { 0xA4EB, 826 },
    { 0xAC80, 114 },
    { 0xACEB, 825 },
    { 0xB4EB, 827 },
    { 0xB4F7, 905 },
    { 0xBCF7, 906 },
    { 0xC000, 536 },
    { 0xC004, 555 },
    { 0xC005, 554 },
    { 0xC006, 789 },
    { 0xC008, 504 },
    { 0xC009, 505 },
    { 0xC00A, 489 },
    { 0xC00B, 488 },
    { 0xC00C, 498 },
    { 0xC00D, 499 },
    { 0xC00E, 500 },
    { 0xC00F, 501 },
    { 0xC010, 491 },
    { 0xC011, 492 },
    { 0xC012, 493 },
    { 0xC013, 494 },
    { 0xC014, 495 },
    { 0xC015, 496 },
    { 0xC016, 502 },
    { 0xC017, 497 },
    { 0xC018, 557 },
    { 0xC019, 558 },
    { 0xC01A, 559 },
    { 0xC01C, 506 },
    { 0xC01D, 490 },
    { 0xC01E, 503 },
    { 0xC020, 483 },
    { 0xC021, 484 },
    { 0xC022, 485 },
    { 0xC024, 487 },
    { 0xC025, 486 },
    { 0xC028, 473 },
    { 0xC029, 474 },
    { 0xC02C, 471 },
    { 0xC02D, 472 },
    { 0xC030, 475 },
    { 0xC031, 476 },
    { 0xC032, 477 },
    { 0xC038, 478 },
    { 0xC039, 479 },
    { 0xC03A, 480 },
    { 0xC03B, 481 },
    { 0xC03C, 482 },
    { 0xC080, 806 },
    { 0xC081, 1 },
    { 0xC082, 264 },
    { 0xC083, 802 },
    { 0xC085, 790 },
    { 0xC086, 380 },
    { 0xC090, 1196 },
    { 0xC091, 1169 },
    { 0xC093, 1066 },
    { 0xC094, 823 },
    { 0xC096, 817 },
    { 0xC100, 1172 },
    { 0xC101, 1176 },
    { 0xC102, 926 },
    { 0xC103, 923 },
    { 0xC108, 110 },
    { 0xC109, 109 },
    { 0xC10A, 112 },
    { 0xC10B, 111 },
    { 0xC110, 104 },
    { 0xC111, 103 },
    { 0xC112, 106 },
    { 0xC113, 105 },
    { 0xC118, 108 },
    { 0xC119, 107 },
    { 0xC128, 382 },
    { 0xC129, 387 },
    { 0xC12A, 381 },
    { 0xC200, 910 },
    { 0xC201, 351 },
    { 0xC208, 917 },
    { 0xC210, 908 },
    { 0xC212, 271 },
    { 0xC213, 567 },
    { 0xC214, 1179 },
    { 0xC218, 13 },
    { 0xC219, 579 },
    { 0xC230, 434 },
    { 0xC288, 4 },
    { 0xC289, 8 },
    { 0xC290, 369 },
    { 0xC298, 355 },
    { 0xC299, 356 },
    { 0xC29A, 360 },
    { 0xC2A0, 359 },
    { 0xC2A1, 358 },
    { 0xC2A2, 368 },
    { 0xC2A3, 357 },
    { 0xC2A4, 367 },
    { 0xC2A5, 366 },
    { 0xC2A6, 365 },
    { 0xC2A8, 361 },
    { 0xC2A9, 362 },
    { 0xC2AA, 363 },
    { 0xC2AB, 364 },
    { 0xC2B0, 933 },
    { 0xC2B1, 932 },
    { 0xC300, 373 },
    { 0xC305, 569 },
    { 0xC309, 751 },
    { 0xC311, 785 },
    { 0xC340, 749 },
    { 0xC341, 783 },
    { 0xC344, 731 },
    { 0xC345, 765 },
    { 0xC348, 733 },
    { 0xC349, 767 },
    { 0xC34C, 735 },
    { 0xC34D, 769 },
    { 0xC350, 737 },
    { 0xC351, 771 },
    { 0xC354, 739 },
    { 0xC355, 773 },
    { 0xC358, 741 },
    { 0xC359, 775 },
    { 0xC35C, 743 },
    { 0xC35D, 777 },
    { 0xC360, 745 },
    { 0xC361, 779 },
    { 0xC364, 747 },
    { 0xC365, 781 },
    { 0xC368, 719 },
    { 0xC369, 753 },
    { 0xC36C, 721 },
    { 0xC36D, 755 },
    { 0xC370, 723 },
    { 0xC371, 757 },
    { 0xC374, 725 },
    { 0xC375, 759 },
    { 0xC378, 727 },
    { 0xC379, 761 },
    { 0xC37C, 729 },
    { 0xC37D, 763 },
    { 0xC3A0, 568 },
    { 0xC4C8, 695 },
    { 0xC4C9, 706 },
    { 0xC4CA, 702 },
    { 0xC4CB, 704 },
    { 0xC4CC, 701 },
    { 0xC4CD, 700 },
    { 0xC4CE, 705 },
    { 0xC4CF, 703 },
    { 0xC4D0, 581 },
    { 0xC4D1, 582 },
    { 0xC4D3, 583 },
    { 0xC4D4, 698 },
    { 0xC4D7, 580 },
    { 0xC4D8, 945 },
    { 0xC4D9, 947 },
    { 0xC4DA, 943 },
    { 0xC4DB, 948 },
    { 0xC4DC, 946 },
    { 0xC4DE, 949 },
    { 0xC4DF, 944 },
    { 0xC4EB, 707 },
    { 0xC4F1, 691 },
    { 0xC4F2, 690 },
    { 0xC4F4, 709 },
    { 0xC4F5, 592 },
    { 0xC4F6, 692 },
    { 0xC4F7, 686 },
    { 0xC510, 518 },
    { 0xC511, 514 },
    { 0xC512, 572 },
    { 0xC513, 575 },
    { 0xC514, 715 },
    { 0xC515, 800 },
    { 0xC518, 18 },
    { 0xC519, 14 },
    { 0xC520, 513 },
    { 0xC521, 510 },
    { 0xC522, 512 },
    { 0xC523, 509 },
    { 0xC524, 543 },
    { 0xC527, 511 },
    { 0xC528, 538 },
    { 0xC529, 537 },
    { 0xC52B, 544 },
    { 0xC600, 1180 },
    { 0xC601, 796 },
    { 0xC602, 791 },
    { 0xC608, 508 },
    { 0xC609, 347 },
    { 0xC640, 428 },
    { 0xC641, 424 },
    { 0xC642, 426 },
    { 0xC643, 419 },
    { 0xC644, 410 },
    { 0xC645, 411 },
    { 0xC646, 412 },
    { 0xC647, 413 },
    { 0xC648, 414 },
    { 0xC649, 415 },
    { 0xC64A, 416 },
    { 0xC64B, 417 },
    { 0xC64D, 433 },
    { 0xC659, 423 },
    { 0xC65B, 435 },
    { 0xC65D, 437 },
    { 0xC65E, 418 },
    { 0xC65F, 436 },
    { 0xC660, 429 },
    { 0xC661, 425 },
    { 0xC662, 427 },
    { 0xC663, 420 },
    { 0xC664, 421 },
    { 0xC665, 438 },
    { 0xC666, 430 },
    { 0xC667, 431 },
    { 0xC681, 261 },
    { 0xC683, 788 },
    { 0xC684, 940 },
    { 0xC685, 0 },
    { 0xC686, 787 },
    { 0xC687, 811 },
    { 0xC708, 236 },
    { 0xC800, 219 },
    { 0xC801, 220 },
    { 0xC802, 218 },
    { 0xC804, 391 },
    { 0xC806, 821 },
    { 0xC807, 12 },
    { 0xD000, 269 },
    { 0xD801, 270 },
    { 0xD807, 346 },
    { 0xD920, 794 },
    { 0xD921, 795 },
    { 0xD929, 386 },
    { 0xDA10, 560 },
    { 0xDA11, 273 },
    { 0xDA12, 921 },
    { 0xDA15, 348 },
    { 0xDA16, 920 },
    { 0xDA17, 922 },
    { 0xDA20, 377 },
    { 0xDA21, 379 },
    { 0xDA28, 350 },
    { 0xDA29, 349 },
    { 0xDCA0, 688 },
    { 0xDCB0, 687 },
    { 0xDCE0, 591 },
    { 0xDCE1, 590 },
    { 0xDCE2, 589 },
    { 0xDCE3, 693 },
    { 0xDCE4, 708 },
    { 0xDCE5, 699 },
    { 0xDCE6, 587 },
    { 0xDCE7, 588 },
    { 0xDCE8, 585 },
    { 0xDCE9, 712 },
    { 0xDCEA, 711 },
    { 0xDCEC, 713 },
    { 0xDCF0, 710 },
    { 0xDCF3, 694 },
    { 0xDD14, 714 },
    { 0xDE82, 939 },
    { 0xDE83, 938 },
    { 0xDE85, 937 },
    { 0xDE87, 810 },
    { 0xDE90, 29 },
    { 0xDE91, 22 },
    { 0xDE92, 24 },
    { 0xDE93, 102 },
    { 0xDE94, 25 },
    { 0xDE95, 27 },
    { 0xDE96, 23 },
    { 0xDE98, 26 },
    { 0xDE99, 28 },
    { 0xDEA0, 30 },
    { 0xDEA1, 31 },
    { 0xDEA2, 32 },
    { 0xDEA3, 33 },
    { 0xDEB0, 82 },
    { 0xDEB1, 83 },
    { 0xDEB2, 84 },
    { 0xDEB3, 85 },
    { 0xDEE0, 34 },
    { 0xDEE1, 41 },
    { 0xDEE2, 42 },
    { 0xDEE3, 43 },
    { 0xDEE4, 44 },
    { 0xDEE5, 45 },
    { 0xDEE6, 46 },
    { 0xDEE7, 47 },
    { 0xDEE8, 48 },
    { 0xDEE9, 49 },
    { 0xDEEA, 35 },
    { 0xDEEB, 36 },
    { 0xDEEC, 37 },
    { 0xDEED, 38 },
    { 0xDEEE, 39 },
    { 0xDEEF, 40 },
    { 0xDEF0, 86 },
    { 0xDEF1, 93 },
    { 0xDEF2, 94 },
    { 0xDEF3, 95 },
    { 0xDEF4, 96 },
    { 0xDEF5, 97 },
    { 0xDEF6, 98 },
    { 0xDEF7, 99 },
    { 0xDEF8, 100 },
    { 0xDEF9, 101 },
    { 0xDEFA, 87 },
    { 0xDEFB, 88 },
    { 0xDEFC, 89 },
    { 0xDEFD, 90 },
    { 0xDEFE, 91 },
    { 0xDEFF, 92 },
    { 0xDF00, 221 },
    { 0xDF01, 239 },
    { 0xDF02, 252 },
    { 0xDF05, 238 },
    { 0xDF06, 251 },
    { 0xDF10, 248 },
    { 0xDF11, 244 },
    { 0xDF12, 246 },
    { 0xDF18, 259 },
    { 0xDF19, 255 },
    { 0xDF1A, 257 },
    { 0xDF40, 593 },
    { 0xDF41, 604 },
    { 0xDF42, 615 },
    { 0xDF43, 617 },
    { 0xDF44, 618 },
    { 0xDF45, 619 },
    { 0xDF46, 620 },
    { 0xDF47, 621 },
    { 0xDF48, 622 },
    { 0xDF49, 623 },
    { 0xDF4A, 594 },
    { 0xDF4B, 595 },
    { 0xDF4C, 596 },
    { 0xDF4D, 597 },
    { 0xDF4E, 598 },
    { 0xDF4F, 599 },
    { 0xDF50, 600 },
    { 0xDF51, 601 },
    { 0xDF52, 602 },
    { 0xDF53, 603 },
    { 0xDF54, 605 },
    { 0xDF55, 606 },
    { 0xDF56, 607 },
    { 0xDF57, 608 },
    { 0xDF58, 609 },
    { 0xDF59, 610 },
    { 0xDF5A, 611 },
    { 0xDF5B, 612 },
    { 0xDF5C, 613 },
    { 0xDF5D, 614 },
    { 0xDF5E, 616 },
    { 0xDF60, 655 },
    { 0xDF61, 666 },
    { 0xDF62, 677 },
    { 0xDF63, 679 },
    { 0xDF64, 680 },
    { 0xDF65, 681 },
    { 0xDF66, 682 },
    { 0xDF67, 683 },
    { 0xDF68, 684 },
    { 0xDF69, 685 },
    { 0xDF6A, 656 },
    { 0xDF6B, 657 },
    { 0xDF6C, 658 },
    { 0xDF6D, 659 },
    { 0xDF6E, 660 },
    { 0xDF6F, 661 },
    { 0xDF70, 662 },
    { 0xDF71, 663 },
    { 0xDF72, 664 },
    { 0xDF73, 665 },
    { 0xDF74, 667 },
    { 0xDF75, 668 },
    { 0xDF76, 669 },
    { 0xDF77, 670 },
    { 0xDF78, 671 },
    { 0xDF79, 672 },
    { 0xDF7A, 673 },
    { 0xDF7B, 674 },
    { 0xDF7C, 675 },
    { 0xDF7D, 676 },
    { 0xDF7E, 678 },
    { 0xDF7F, 584 },
    { 0xE000, 1189 },
    { 0xE004, 556 },
    { 0xE005, 1187 },
    { 0xE080, 808 },
    { 0xE081, 2 },
    { 0xE083, 804 },
    { 0xE088, 397 },
    { 0xE089, 524 },
    { 0xE08A, 267 },
    { 0xE08B, 409 },
    { 0xE08C, 405 },
    { 0xE08D, 407 },
    { 0xE08E, 403 },
    { 0xE08F, 394 },
    { 0xE090, 1198 },
    { 0xE091, 1171 },
    { 0xE092, 396 },
    { 0xE093, 1068 },
    { 0xE095, 822 },
    { 0xE096, 819 },
    { 0xE099, 815 },
    { 0xE100, 1174 },
    { 0xE100, 1190 },
    { 0xE101, 1178 },
    { 0xE102, 928 },
    { 0xE103, 925 },
    { 0xE108, 1195 },
    { 0xE10A, 1194 },
    { 0xE110, 1188 },
    { 0xE128, 384 },
    { 0xE129, 389 },
    { 0xE130, 1193 },
    { 0xE132, 1192 },
    { 0xE180, 272 },
    { 0xE188, 398 },
    { 0xE189, 400 },
    { 0xE18A, 404 },
    { 0xE18B, 406 },
    { 0xE18C, 399 },
    { 0xE18D, 401 },
    { 0xE18E, 395 },
    { 0xE18F, 402 },
    { 0xE200, 912 },
    { 0xE201, 353 },
    { 0xE208, 918 },
    { 0xE218, 915 },
    { 0xE219, 909 },
    { 0xE21A, 916 },
    { 0xE21B, 914 },
    { 0xE281, 507 },
    { 0xE288, 6 },
    { 0xE289, 10 },
    { 0xE290, 371 },
    { 0xE293, 1191 },
    { 0xE298, 378 },
    { 0xE2B0, 935 },
    { 0xE300, 375 },
    { 0xE304, 408 },
    { 0xE305, 571 },
    { 0xE309, 752 },
    { 0xE311, 786 },
    { 0xE340, 750 },
    { 0xE341, 784 },
    { 0xE344, 732 },
    { 0xE345, 766 },
    { 0xE348, 734 },
    { 0xE349, 768 },
    { 0xE34C, 736 },
    { 0xE34D, 770 },
    { 0xE350, 738 },
    { 0xE351, 772 },
    { 0xE354, 740 },
    { 0xE355, 774 },
    { 0xE358, 742 },
    { 0xE359, 776 },
    { 0xE35C, 744 },
    { 0xE35D, 778 },
    { 0xE360, 746 },
    { 0xE361, 780 },
    { 0xE364, 748 },
    { 0xE365, 782 },
    { 0xE368, 720 },
    { 0xE369, 754 },
    { 0xE36C, 722 },
    { 0xE36D, 756 },
    { 0xE370, 724 },
    { 0xE371, 758 },
    { 0xE374, 726 },
    { 0xE375, 760 },
    { 0xE378, 728 },
    { 0xE379, 762 },
    { 0xE37C, 730 },
    { 0xE37D, 764 },
    { 0xE4C8, 697 },
    { 0xE509, 516 },
    { 0xE510, 520 },
    { 0xE512, 574 },
    { 0xE513, 577 },
    { 0xE514, 717 },
    { 0xE515, 799 },
    { 0xE518, 20 },
    { 0xE519, 16 },
    { 0xE520, 542 },
    { 0xE521, 553 },
    { 0xE528, 540 },
    { 0xE530, 545 },
    { 0xE531, 546 },
    { 0xE532, 547 },
    { 0xE533, 548 },
    { 0xE534, 549 },
    { 0xE535, 550 },
    { 0xE536, 551 },
    { 0xE537, 552 },
    { 0xE540, 532 },
    { 0xE541, 530 },
    { 0xE542, 533 },
    { 0xE543, 531 },
    { 0xE547, 529 },
    { 0xE548, 1186 },
    { 0xE549, 1185 },
    { 0xE600, 1182 },
    { 0xE601, 797 },
    { 0xE602, 792 },
    { 0xE609, 1184 },
    { 0xE640, 441 },
    { 0xE641, 442 },
    { 0xE642, 443 },
    { 0xE643, 444 },
    { 0xE648, 445 },
    { 0xE649, 446 },
    { 0xE64A, 447 },
    { 0xE64B, 448 },
    { 0xE64D, 439 },
    { 0xE658, 451 },
    { 0xE659, 470 },
    { 0xE65A, 468 },
    { 0xE65B, 449 },
    { 0xE65D, 450 },
    { 0xE65F, 469 },
    { 0xE660, 452 },
    { 0xE661, 459 },
    { 0xE662, 460 },
    { 0xE663, 461 },
    { 0xE664, 462 },
    { 0xE665, 463 },
    { 0xE666, 464 },
    { 0xE667, 465 },
    { 0xE668, 466 },
    { 0xE669, 467 },
    { 0xE66A, 453 },
    { 0xE66B, 454 },
    { 0xE66C, 455 },
    { 0xE66D, 456 },
    { 0xE66E, 457 },
    { 0xE66F, 458 },
    { 0xE681, 263 },
    { 0xE682, 941 },
    { 0xE687, 813 },
    { 0xE6C0, 50 },
    { 0xE6C1, 57 },
    { 0xE6C2, 58 },
    { 0xE6C3, 59 },
    { 0xE6C4, 60 },
    { 0xE6C5, 61 },
    { 0xE6C6, 62 },
    { 0xE6C7, 63 },
    { 0xE6C8, 64 },
    { 0xE6C9, 65 },
    { 0xE6CA, 51 },
    { 0xE6CB, 52 },
    { 0xE6CC, 53 },
    { 0xE6CD, 54 },
    { 0xE6CE, 55 },
    { 0xE6CF, 56 },
    { 0xE6D0, 66 },
    { 0xE6D1, 73 },
    { 0xE6D2, 74 },
    { 0xE6D3, 75 },
    { 0xE6D4, 76 },
    { 0xE6D5, 77 },
    { 0xE6D6, 78 },
    { 0xE6D7, 79 },
    { 0xE6D8, 80 },
    { 0xE6D9, 81 },
    { 0xE6DA, 67 },
    { 0xE6DB, 68 },
    { 0xE6DC, 69 },
    { 0xE6DD, 70 },
    { 0xE6DE, 71 },
    { 0xE6DF, 72 },
    { 0xE703, 254 },
    { 0xE704, 250 },
    { 0xE705, 235 },
    { 0xE706, 240 },
    { 0xE707, 253 },
    { 0xE708, 222 },
    { 0xE710, 228 },
    { 0xE711, 226 },
    { 0xE712, 227 },
    { 0xE718, 234 },
    { 0xE719, 232 },
    { 0xE71A, 233 },
    { 0xE720, 231 },
    { 0xE721, 229 },
    { 0xE722, 230 },
    { 0xE728, 225 },
    { 0xE729, 223 },
    { 0xE72A, 224 },
    { 0xE880, 807 },
    { 0xE882, 265 },
    { 0xE883, 803 },
    { 0xE890, 1197 },
    { 0xE891, 1170 },
    { 0xE893, 1067 },
    { 0xE896, 818 },
    { 0xE900, 1173 },
    { 0xE901, 1177 },
    { 0xE902, 927 },
    { 0xE903, 924 },
    { 0xE928, 383 },
    { 0xE929, 388 },
    { 0xEA00, 911 },
    { 0xEA01, 352 },
    { 0xEA88, 5 },
    { 0xEA89, 9 },
    { 0xEA90, 370 },
    { 0xEAB0, 934 },
    { 0xEB00, 374 },
    { 0xEB05, 570 },
    { 0xECC8, 696 },
    { 0xED10, 519 },
    { 0xED11, 515 },
    { 0xED12, 573 },
    { 0xED13, 576 },
    { 0xED14, 716 },
    { 0xED18, 19 },
    { 0xED19, 15 },
    { 0xED28, 539 },
    { 0xEE00, 1181 },
    { 0xEE81, 262 },
    { 0xEE87, 812 },
    { 0xEF08, 237 },
    { 0xEF10, 249 },
    { 0xEF11, 245 },
    { 0xEF12, 247 },
    { 0xEF18, 260 },
    { 0xEF19, 256 },
    { 0xEF1A, 258 },
    { 0xF080, 809 },
    { 0xF081, 3 },
    { 0xF083, 805 },
    { 0xF088, 801 },
    { 0xF089, 816 },
    { 0xF08A, 268 },
    { 0xF090, 1199 },
    { 0xF096, 820 },
    { 0xF099, 525 },
    { 0xF100, 1175 },
    { 0xF102, 929 },
    { 0xF10C, 393 },
    { 0xF10E, 392 },
    { 0xF128, 385 },
    { 0xF129, 390 },
    { 0xF200, 913 },
    { 0xF201, 354 },
    { 0xF208, 919 },
    { 0xF288, 7 },
    { 0xF289, 11 },
    { 0xF290, 372 },
    { 0xF2B0, 936 },
    { 0xF300, 376 },
    { 0xF305, 535 },
    { 0xF509, 517 },
    { 0xF510, 521 },
    { 0xF513, 578 },
    { 0xF514, 718 },
    { 0xF518, 21 },
    { 0xF519, 17 },
    { 0xF528, 541 },
    { 0xF551, 534 },
    { 0xF600, 1183 },
    { 0xF601, 798 },
    { 0xF602, 793 },
    { 0xF664, 422 },
    { 0xF665, 440 },
    { 0xF667, 432 },
    { 0xF682, 942 },
    { 0xF687, 814 },
    { 0xFF10, 243 },
    { 0xFF11, 241 },
    { 0xFF12, 242 },
    { 0xFF90, 266 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SysRegsList[Idx->_index];
}
#endif

#ifdef GET_TSB_DECL
const TSB *lookupTSBByName(StringRef Name);
const TSB *lookupTSBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_TSB_IMPL
constexpr TSB TSBsList[] = {
  { "csync", 0x0,  {AArch64::FeatureTRACEV8_4}  }, // 0
 };

const TSB *lookupTSBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CSYNC", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &TSBsList[Idx->_index];
}

const TSB *lookupTSBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &TSBsList[Table[Idx]._index];
}
#endif

#undef GET_AT_DECL
#undef GET_AT_IMPL
#undef GET_BTI_DECL
#undef GET_BTI_IMPL
#undef GET_DBNXS_DECL
#undef GET_DBNXS_IMPL
#undef GET_DB_DECL
#undef GET_DB_IMPL
#undef GET_DC_DECL
#undef GET_DC_IMPL
#undef GET_EXACTFPIMM_DECL
#undef GET_EXACTFPIMM_IMPL
#undef GET_IC_DECL
#undef GET_IC_IMPL
#undef GET_ISB_DECL
#undef GET_ISB_IMPL
#undef GET_PRFM_DECL
#undef GET_PRFM_IMPL
#undef GET_PSB_DECL
#undef GET_PSB_IMPL
#undef GET_PSTATEIMM0_15_DECL
#undef GET_PSTATEIMM0_15_IMPL
#undef GET_PSTATEIMM0_1_DECL
#undef GET_PSTATEIMM0_1_IMPL
#undef GET_RPRFM_DECL
#undef GET_RPRFM_IMPL
#undef GET_SVCR_DECL
#undef GET_SVCR_IMPL
#undef GET_SVEPREDPAT_DECL
#undef GET_SVEPREDPAT_IMPL
#undef GET_SVEPRFM_DECL
#undef GET_SVEPRFM_IMPL
#undef GET_SVEVECLENSPECIFIER_DECL
#undef GET_SVEVECLENSPECIFIER_IMPL
#undef GET_SYSREG_DECL
#undef GET_SYSREG_IMPL
#undef GET_TLBITable_DECL
#undef GET_TLBITable_IMPL
#undef GET_TSB_DECL
#undef GET_TSB_IMPL
