/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AMDGPURegBankCombinerImpl Combiner Match Table                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AMDGPURegBankCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 11:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "unmerge_cst", 11) != 0)
      break;
    return 1;	 // "unmerge_cst"
  case 13:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "unmerge_", 8) != 0)
      break;
    switch (RuleIdentifier[8]) {
    default: break;
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
        break;
      return 0;	 // "unmerge_merge"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
        break;
      return 2;	 // "unmerge_undef"
    }
    break;
  case 15:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "zext_trunc_fold", 15) != 0)
      break;
    return 3;	 // "zext_trunc_fold"
  case 17:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "fp_minmax_to_med3", 17) != 0)
      break;
    return 7;	 // "fp_minmax_to_med3"
  case 18:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "p_minmax_to_clamp", 17) != 0)
        break;
      return 6;	 // "fp_minmax_to_clamp"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nt_minmax_to_med3", 17) != 0)
        break;
      return 4;	 // "int_minmax_to_med3"
    }
    break;
  case 19:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "ptr_add_immed_chain", 19) != 0)
      break;
    return 5;	 // "ptr_add_immed_chain"
  case 24:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "fmed3_intrinsic_to_clamp", 24) != 0)
      break;
    return 8;	 // "fmed3_intrinsic_to_clamp"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 9}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AMDGPURegBankCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AMDGPURegBankCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AMDGPURegBankCombinerOption;
static cl::list<std::string> AMDGPURegBankCombinerDisableOption(
    "amdgpuregbankcombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AMDGPURegBankCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AMDGPURegBankCombinerOption.push_back(Str);
    }));
static cl::list<std::string> AMDGPURegBankCombinerOnlyEnableOption(
    "amdgpuregbankcombiner-only-enable-rule",
    cl::desc("Disable all rules in the AMDGPURegBankCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AMDGPURegBankCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        AMDGPURegBankCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AMDGPURegBankCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AMDGPURegBankCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AMDGPURegBankCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPURegBankCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPURegBankCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPURegBankCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPURegBankCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State) const override;
  struct MatchInfosTy {
    Register MDInfo3;
    SmallVector<Register, 8> MDInfo0;
    Med3MatchInfo MDInfo4;
    std::function<void(MachineIRBuilder &)> MDInfo2;
    SmallVector<APInt, 8> MDInfo1;
    PtrAddChain MDInfo5;
  };
  mutable MatchInfosTy MatchInfos;

#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AMDGPURegBankCombinerImpl::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features;
  return Features;
}

void AMDGPURegBankCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPURegBankCombinerImpl::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AMDGPURegBankCombinerImpl::ComplexMatcherMemFn
AMDGPURegBankCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
  GICXXPred_MI_Predicate_GICombiner3,
  GICXXPred_MI_Predicate_GICombiner4,
  GICXXPred_MI_Predicate_GICombiner5,
  GICXXPred_MI_Predicate_GICombiner6,
  GICXXPred_MI_Predicate_GICombiner7,
  GICXXPred_MI_Predicate_GICombiner8,
};
bool AMDGPURegBankCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], MatchInfos.MDInfo0);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return Helper.matchCombineUnmergeConstant(*State.MIs[0], MatchInfos.MDInfo1);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchCombineUnmergeUndef(*State.MIs[0], MatchInfos.MDInfo2);
  }
  case GICXXPred_MI_Predicate_GICombiner3: {
    return Helper.matchCombineZextTrunc(*State.MIs[0], MatchInfos.MDInfo3);
  }
  case GICXXPred_MI_Predicate_GICombiner4: {
    return matchIntMinMaxToMed3(*State.MIs[0], MatchInfos.MDInfo4);
  }
  case GICXXPred_MI_Predicate_GICombiner5: {
    return Helper.matchPtrAddImmedChain(*State.MIs[0], MatchInfos.MDInfo5);
  }
  case GICXXPred_MI_Predicate_GICombiner6: {
    return matchFPMinMaxToClamp(*State.MIs[0], MatchInfos.MDInfo3);
  }
  case GICXXPred_MI_Predicate_GICombiner7: {
    return matchFPMinMaxToMed3(*State.MIs[0], MatchInfos.MDInfo4);
  }
  case GICXXPred_MI_Predicate_GICombiner8: {
    return matchFPMed3ToClamp(*State.MIs[0], MatchInfos.MDInfo3);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPURegBankCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPURegBankCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPURegBankCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
};

bool AMDGPURegBankCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPURegBankCombinerImpl::CustomRendererFn
AMDGPURegBankCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AMDGPURegBankCombinerImpl::tryCombineAll(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);
  MatchInfos = MatchInfosTy();

  if (executeMatchTable(*this, OutMIs, State, ExecInfo, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_CombineApplyGICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_CombineApplyGICombiner1,
  GICXXCustomAction_CombineApplyGICombiner2,
  GICXXCustomAction_CombineApplyGICombiner3,
  GICXXCustomAction_CombineApplyGICombiner4,
  GICXXCustomAction_CombineApplyGICombiner5,
  GICXXCustomAction_CombineApplyGICombiner6,
};
void AMDGPURegBankCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State) const {
  switch(ApplyID) {
  case GICXXCustomAction_CombineApplyGICombiner0:{
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], MatchInfos.MDInfo0);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner1:{
    Helper.applyCombineUnmergeConstant(*State.MIs[0], MatchInfos.MDInfo1);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner2:{
    Helper.applyBuildFn(*State.MIs[0], MatchInfos.MDInfo2);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner3:{
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], MatchInfos.MDInfo3);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner4:{
    applyMed3(*State.MIs[0], MatchInfos.MDInfo4);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner5:{
    Helper.applyPtrAddImmedChain(*State.MIs[0], MatchInfos.MDInfo5);
    return;
  }
  case GICXXCustomAction_CombineApplyGICombiner6:{
    applyClamp(*State.MIs[0], MatchInfos.MDInfo3);
    return;
  }
}
  llvm_unreachable("Unknown Apply Action");
}
const int64_t *AMDGPURegBankCombinerImpl::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_Try, /*On fail goto*//*Label 0*/ 36,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_UNMERGE_VALUES,
      GIM_Try, /*On fail goto*//*Label 1*/ 15, // Rule ID 0 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule0Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner0,
        // Combiner Rule #0: unmerge_merge; wip_match_opcode alternative 'G_UNMERGE_VALUES'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner0,
        GIR_Done,
      // Label 1: @15
      GIM_Try, /*On fail goto*//*Label 2*/ 25, // Rule ID 1 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule1Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner1,
        // Combiner Rule #1: unmerge_cst; wip_match_opcode alternative 'G_UNMERGE_VALUES'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner1,
        GIR_Done,
      // Label 2: @25
      GIM_Try, /*On fail goto*//*Label 3*/ 35, // Rule ID 2 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule2Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner2,
        // Combiner Rule #2: unmerge_undef; wip_match_opcode alternative 'G_UNMERGE_VALUES'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner2,
        GIR_Done,
      // Label 3: @35
      GIM_Reject,
    // Label 0: @36
    GIM_Try, /*On fail goto*//*Label 4*/ 49, // Rule ID 3 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule3Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_ZEXT,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner3,
      // Combiner Rule #3: zext_trunc_fold; wip_match_opcode alternative 'G_ZEXT'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner3,
      GIR_Done,
    // Label 4: @49
    GIM_Try, /*On fail goto*//*Label 5*/ 62, // Rule ID 4 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule4Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_SMAX,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner4,
      // Combiner Rule #4: int_minmax_to_med3; wip_match_opcode alternative 'G_SMAX'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
      GIR_Done,
    // Label 5: @62
    GIM_Try, /*On fail goto*//*Label 6*/ 75, // Rule ID 5 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule4Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_SMIN,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner4,
      // Combiner Rule #4: int_minmax_to_med3; wip_match_opcode alternative 'G_SMIN'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
      GIR_Done,
    // Label 6: @75
    GIM_Try, /*On fail goto*//*Label 7*/ 88, // Rule ID 6 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule4Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_UMAX,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner4,
      // Combiner Rule #4: int_minmax_to_med3; wip_match_opcode alternative 'G_UMAX'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
      GIR_Done,
    // Label 7: @88
    GIM_Try, /*On fail goto*//*Label 8*/ 101, // Rule ID 7 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule4Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_UMIN,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner4,
      // Combiner Rule #4: int_minmax_to_med3; wip_match_opcode alternative 'G_UMIN'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
      GIR_Done,
    // Label 8: @101
    GIM_Try, /*On fail goto*//*Label 9*/ 114, // Rule ID 8 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule5Enabled,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_PTR_ADD,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner5,
      // Combiner Rule #5: ptr_add_immed_chain; wip_match_opcode alternative 'G_PTR_ADD'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner5,
      GIR_Done,
    // Label 9: @114
    GIM_Try, /*On fail goto*//*Label 10*/ 140,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_FMAXNUM,
      GIM_Try, /*On fail goto*//*Label 11*/ 129, // Rule ID 9 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule6Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner6,
        // Combiner Rule #6: fp_minmax_to_clamp; wip_match_opcode alternative 'G_FMAXNUM'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner6,
        GIR_Done,
      // Label 11: @129
      GIM_Try, /*On fail goto*//*Label 12*/ 139, // Rule ID 13 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule7Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner7,
        // Combiner Rule #7: fp_minmax_to_med3; wip_match_opcode alternative 'G_FMAXNUM'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
        GIR_Done,
      // Label 12: @139
      GIM_Reject,
    // Label 10: @140
    GIM_Try, /*On fail goto*//*Label 13*/ 166,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_FMINNUM,
      GIM_Try, /*On fail goto*//*Label 14*/ 155, // Rule ID 10 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule6Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner6,
        // Combiner Rule #6: fp_minmax_to_clamp; wip_match_opcode alternative 'G_FMINNUM'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner6,
        GIR_Done,
      // Label 14: @155
      GIM_Try, /*On fail goto*//*Label 15*/ 165, // Rule ID 14 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule7Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner7,
        // Combiner Rule #7: fp_minmax_to_med3; wip_match_opcode alternative 'G_FMINNUM'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
        GIR_Done,
      // Label 15: @165
      GIM_Reject,
    // Label 13: @166
    GIM_Try, /*On fail goto*//*Label 16*/ 192,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_FMAXNUM_IEEE,
      GIM_Try, /*On fail goto*//*Label 17*/ 181, // Rule ID 11 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule6Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner6,
        // Combiner Rule #6: fp_minmax_to_clamp; wip_match_opcode alternative 'G_FMAXNUM_IEEE'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner6,
        GIR_Done,
      // Label 17: @181
      GIM_Try, /*On fail goto*//*Label 18*/ 191, // Rule ID 15 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule7Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner7,
        // Combiner Rule #7: fp_minmax_to_med3; wip_match_opcode alternative 'G_FMAXNUM_IEEE'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
        GIR_Done,
      // Label 18: @191
      GIM_Reject,
    // Label 16: @192
    GIM_Try, /*On fail goto*//*Label 19*/ 218,
      GIM_CheckOpcode, /*MI*/0, TargetOpcode::G_FMINNUM_IEEE,
      GIM_Try, /*On fail goto*//*Label 20*/ 207, // Rule ID 12 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule6Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner6,
        // Combiner Rule #6: fp_minmax_to_clamp; wip_match_opcode alternative 'G_FMINNUM_IEEE'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner6,
        GIR_Done,
      // Label 20: @207
      GIM_Try, /*On fail goto*//*Label 21*/ 217, // Rule ID 16 //
        GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule7Enabled,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner7,
        // Combiner Rule #7: fp_minmax_to_med3; wip_match_opcode alternative 'G_FMINNUM_IEEE'
        GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner4,
        GIR_Done,
      // Label 21: @217
      GIM_Reject,
    // Label 19: @218
    GIM_Try, /*On fail goto*//*Label 22*/ 231, // Rule ID 17 //
      GIM_CheckSimplePredicate, GICXXPred_Simple_IsRule8Enabled,
      GIM_CheckOpcode, /*MI*/0, AMDGPU::G_AMDGPU_FMED3,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GICXXPred_MI_Predicate_GICombiner8,
      // Combiner Rule #8: fmed3_intrinsic_to_clamp; wip_match_opcode alternative 'G_AMDGPU_FMED3'
      GIR_CustomAction, GICXXCustomAction_CombineApplyGICombiner6,
      GIR_Done,
    // Label 22: @231
    GIM_Reject,
    };
  return MatchTable0;
}
#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

