#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_AND = 1,
  IMAGE_ATOMIC_CMPSWAP = 2,
  IMAGE_ATOMIC_DEC = 3,
  IMAGE_ATOMIC_FCMPSWAP = 4,
  IMAGE_ATOMIC_FMAX = 5,
  IMAGE_ATOMIC_FMIN = 6,
  IMAGE_ATOMIC_INC = 7,
  IMAGE_ATOMIC_OR = 8,
  IMAGE_ATOMIC_RSUB = 9,
  IMAGE_ATOMIC_SMAX = 10,
  IMAGE_ATOMIC_SMIN = 11,
  IMAGE_ATOMIC_SUB = 12,
  IMAGE_ATOMIC_SWAP = 13,
  IMAGE_ATOMIC_UMAX = 14,
  IMAGE_ATOMIC_UMIN = 15,
  IMAGE_ATOMIC_XOR = 16,
  IMAGE_BVH64_INTERSECT_RAY = 17,
  IMAGE_BVH64_INTERSECT_RAY_a16 = 18,
  IMAGE_BVH_INTERSECT_RAY = 19,
  IMAGE_BVH_INTERSECT_RAY_a16 = 20,
  IMAGE_GATHER4 = 21,
  IMAGE_GATHER4H = 22,
  IMAGE_GATHER4_B = 23,
  IMAGE_GATHER4_B_CL = 24,
  IMAGE_GATHER4_B_CL_O = 25,
  IMAGE_GATHER4_B_O = 26,
  IMAGE_GATHER4_C = 27,
  IMAGE_GATHER4_CL = 28,
  IMAGE_GATHER4_CL_O = 29,
  IMAGE_GATHER4_C_B = 30,
  IMAGE_GATHER4_C_B_CL = 31,
  IMAGE_GATHER4_C_B_CL_O = 32,
  IMAGE_GATHER4_C_B_O = 33,
  IMAGE_GATHER4_C_CL = 34,
  IMAGE_GATHER4_C_CL_O = 35,
  IMAGE_GATHER4_C_L = 36,
  IMAGE_GATHER4_C_LZ = 37,
  IMAGE_GATHER4_C_LZ_O = 38,
  IMAGE_GATHER4_C_L_O = 39,
  IMAGE_GATHER4_C_O = 40,
  IMAGE_GATHER4_L = 41,
  IMAGE_GATHER4_LZ = 42,
  IMAGE_GATHER4_LZ_O = 43,
  IMAGE_GATHER4_L_O = 44,
  IMAGE_GATHER4_O = 45,
  IMAGE_GET_LOD = 46,
  IMAGE_GET_RESINFO = 47,
  IMAGE_LOAD = 48,
  IMAGE_LOAD_MIP = 49,
  IMAGE_LOAD_MIP_PCK = 50,
  IMAGE_LOAD_MIP_PCK_SGN = 51,
  IMAGE_LOAD_PCK = 52,
  IMAGE_LOAD_PCK_SGN = 53,
  IMAGE_MSAA_LOAD = 54,
  IMAGE_MSAA_LOAD_X = 55,
  IMAGE_SAMPLE = 56,
  IMAGE_SAMPLE_B = 57,
  IMAGE_SAMPLE_B_CL = 58,
  IMAGE_SAMPLE_B_CL_O = 59,
  IMAGE_SAMPLE_B_O = 60,
  IMAGE_SAMPLE_C = 61,
  IMAGE_SAMPLE_CD = 62,
  IMAGE_SAMPLE_CD_CL = 63,
  IMAGE_SAMPLE_CD_CL_G16 = 64,
  IMAGE_SAMPLE_CD_CL_O = 65,
  IMAGE_SAMPLE_CD_CL_O_G16 = 66,
  IMAGE_SAMPLE_CD_G16 = 67,
  IMAGE_SAMPLE_CD_O = 68,
  IMAGE_SAMPLE_CD_O_G16 = 69,
  IMAGE_SAMPLE_CL = 70,
  IMAGE_SAMPLE_CL_O = 71,
  IMAGE_SAMPLE_C_B = 72,
  IMAGE_SAMPLE_C_B_CL = 73,
  IMAGE_SAMPLE_C_B_CL_O = 74,
  IMAGE_SAMPLE_C_B_O = 75,
  IMAGE_SAMPLE_C_CD = 76,
  IMAGE_SAMPLE_C_CD_CL = 77,
  IMAGE_SAMPLE_C_CD_CL_G16 = 78,
  IMAGE_SAMPLE_C_CD_CL_O = 79,
  IMAGE_SAMPLE_C_CD_CL_O_G16 = 80,
  IMAGE_SAMPLE_C_CD_G16 = 81,
  IMAGE_SAMPLE_C_CD_O = 82,
  IMAGE_SAMPLE_C_CD_O_G16 = 83,
  IMAGE_SAMPLE_C_CL = 84,
  IMAGE_SAMPLE_C_CL_O = 85,
  IMAGE_SAMPLE_C_D = 86,
  IMAGE_SAMPLE_C_D_CL = 87,
  IMAGE_SAMPLE_C_D_CL_G16 = 88,
  IMAGE_SAMPLE_C_D_CL_O = 89,
  IMAGE_SAMPLE_C_D_CL_O_G16 = 90,
  IMAGE_SAMPLE_C_D_G16 = 91,
  IMAGE_SAMPLE_C_D_O = 92,
  IMAGE_SAMPLE_C_D_O_G16 = 93,
  IMAGE_SAMPLE_C_L = 94,
  IMAGE_SAMPLE_C_LZ = 95,
  IMAGE_SAMPLE_C_LZ_O = 96,
  IMAGE_SAMPLE_C_L_O = 97,
  IMAGE_SAMPLE_C_O = 98,
  IMAGE_SAMPLE_D = 99,
  IMAGE_SAMPLE_D_CL = 100,
  IMAGE_SAMPLE_D_CL_G16 = 101,
  IMAGE_SAMPLE_D_CL_O = 102,
  IMAGE_SAMPLE_D_CL_O_G16 = 103,
  IMAGE_SAMPLE_D_G16 = 104,
  IMAGE_SAMPLE_D_O = 105,
  IMAGE_SAMPLE_D_O_G16 = 106,
  IMAGE_SAMPLE_L = 107,
  IMAGE_SAMPLE_LZ = 108,
  IMAGE_SAMPLE_LZ_O = 109,
  IMAGE_SAMPLE_L_O = 110,
  IMAGE_SAMPLE_O = 111,
  IMAGE_STORE = 112,
  IMAGE_STORE_MIP = 113,
  IMAGE_STORE_MIP_PCK = 114,
  IMAGE_STORE_PCK = 115,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx10Default = 0,
  MIMGEncGfx10NSA = 1,
  MIMGEncGfx11Default = 2,
  MIMGEncGfx11NSA = 3,
  MIMGEncGfx6 = 4,
  MIMGEncGfx8 = 5,
  MIMGEncGfx90a = 6,
};
#endif

#ifdef GET_WMMAOpcode_DECL
enum WMMAOpcode {
  V_DOT2_F32_BF16 = 0,
  V_DOT2_F32_F16 = 1,
  V_DOT2_I32_I16 = 2,
  V_DOT2_U32_U16 = 3,
  V_DOT4_I32_I8 = 4,
  V_DOT4_I32_IU8 = 5,
  V_DOT4_U32_U8 = 6,
  V_DOT8_I32_I4 = 7,
  V_DOT8_I32_IU4 = 8,
  V_DOT8_U32_U4 = 9,
  V_FMA_MIXHI_F16 = 10,
  V_FMA_MIXLO_F16 = 11,
  V_FMA_MIX_F32 = 12,
  V_MAD_MIXHI_F16 = 13,
  V_MAD_MIXLO_F16 = 14,
  V_MAD_MIX_F32 = 15,
  V_PK_ADD_F16 = 16,
  V_PK_ADD_F32 = 17,
  V_PK_ADD_I16 = 18,
  V_PK_ADD_U16 = 19,
  V_PK_ASHRREV_I16 = 20,
  V_PK_FMA_F16 = 21,
  V_PK_FMA_F32 = 22,
  V_PK_LSHLREV_B16 = 23,
  V_PK_LSHRREV_B16 = 24,
  V_PK_MAD_I16 = 25,
  V_PK_MAD_U16 = 26,
  V_PK_MAX_F16 = 27,
  V_PK_MAX_I16 = 28,
  V_PK_MAX_U16 = 29,
  V_PK_MIN_F16 = 30,
  V_PK_MIN_I16 = 31,
  V_PK_MIN_U16 = 32,
  V_PK_MOV_B32 = 33,
  V_PK_MUL_F16 = 34,
  V_PK_MUL_F32 = 35,
  V_PK_MUL_LO_U16 = 36,
  V_PK_SUB_I16 = 37,
  V_PK_SUB_U16 = 38,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w32 = 39,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w64 = 40,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w32 = 41,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w64 = 42,
  V_WMMA_F16_16X16X16_F16_threeaddr_w32 = 43,
  V_WMMA_F16_16X16X16_F16_threeaddr_w64 = 44,
  V_WMMA_F16_16X16X16_F16_twoaddr_w32 = 45,
  V_WMMA_F16_16X16X16_F16_twoaddr_w64 = 46,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w32 = 47,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w64 = 48,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w32 = 49,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w64 = 50,
  V_WMMA_F32_16X16X16_F16_threeaddr_w32 = 51,
  V_WMMA_F32_16X16X16_F16_threeaddr_w64 = 52,
  V_WMMA_F32_16X16X16_F16_twoaddr_w32 = 53,
  V_WMMA_F32_16X16X16_F16_twoaddr_w64 = 54,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w32 = 55,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w64 = 56,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w32 = 57,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w64 = 58,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w32 = 59,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w64 = 60,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w32 = 61,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w64 = 62,
};
#endif

#ifdef GET_Gfx9BufferFormat_DECL
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx9BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx9BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x11, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x21, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x31, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x41, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x51, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0x3, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0x13, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x23, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x33, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x43, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x53, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0xA, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x1A, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3A, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x4A, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x5A, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x2, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x12, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x22, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0x32, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0x42, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0x52, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0x72, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x5, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x15, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x25, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x35, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x45, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x55, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x75, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0xC, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x1C, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x2C, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x3C, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x4C, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x5C, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x7C, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x44, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x54, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x74, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x4B, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x5B, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x7B, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x4D, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x5D, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x7D, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4E, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x5E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x7E, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx9BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 18 },
    { 0x3, 6 },
    { 0x5, 25 },
    { 0xA, 12 },
    { 0xC, 32 },
    { 0x11, 1 },
    { 0x12, 19 },
    { 0x13, 7 },
    { 0x15, 26 },
    { 0x1A, 13 },
    { 0x1C, 33 },
    { 0x21, 2 },
    { 0x22, 20 },
    { 0x23, 8 },
    { 0x25, 27 },
    { 0x2A, 14 },
    { 0x2C, 34 },
    { 0x31, 3 },
    { 0x32, 21 },
    { 0x33, 9 },
    { 0x35, 28 },
    { 0x3A, 15 },
    { 0x3C, 35 },
    { 0x41, 4 },
    { 0x42, 22 },
    { 0x43, 10 },
    { 0x44, 39 },
    { 0x45, 29 },
    { 0x4A, 16 },
    { 0x4B, 42 },
    { 0x4C, 36 },
    { 0x4D, 45 },
    { 0x4E, 48 },
    { 0x51, 5 },
    { 0x52, 23 },
    { 0x53, 11 },
    { 0x54, 40 },
    { 0x55, 30 },
    { 0x5A, 17 },
    { 0x5B, 43 },
    { 0x5C, 37 },
    { 0x5D, 46 },
    { 0x5E, 49 },
    { 0x72, 24 },
    { 0x74, 41 },
    { 0x75, 31 },
    { 0x7B, 44 },
    { 0x7C, 38 },
    { 0x7D, 47 },
    { 0x7E, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx9BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx10BufferFormat_DECL
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx10BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx10BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x38, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x39, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x3A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3B, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x3C, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x3D, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x41, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x42, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x43, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x44, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x45, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x46, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x47, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x3E, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x3F, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x40, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x48, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x49, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x4A, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4B, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x4C, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x4D, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx10BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x38, 12 },
    { 0x39, 13 },
    { 0x3A, 14 },
    { 0x3B, 15 },
    { 0x3C, 16 },
    { 0x3D, 17 },
    { 0x3E, 42 },
    { 0x3F, 43 },
    { 0x40, 44 },
    { 0x41, 32 },
    { 0x42, 33 },
    { 0x43, 34 },
    { 0x44, 35 },
    { 0x45, 36 },
    { 0x46, 37 },
    { 0x47, 38 },
    { 0x48, 45 },
    { 0x49, 46 },
    { 0x4A, 47 },
    { 0x4B, 48 },
    { 0x4C, 49 },
    { 0x4D, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx10BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx11PlusBufferFormat_DECL
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx11PlusBufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx11PlusBufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x2A, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x2B, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2C, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x2D, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x2E, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x2F, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x33, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x34, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x35, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x36, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x37, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x38, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x39, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x30, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x31, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x32, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x3A, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x3B, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x3C, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x3D, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x3E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x3F, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx11PlusBufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x2A, 12 },
    { 0x2B, 13 },
    { 0x2C, 14 },
    { 0x2D, 15 },
    { 0x2E, 16 },
    { 0x2F, 17 },
    { 0x30, 42 },
    { 0x31, 43 },
    { 0x32, 44 },
    { 0x33, 32 },
    { 0x34, 33 },
    { 0x35, 34 },
    { 0x36, 35 },
    { 0x37, 36 },
    { 0x38, 37 },
    { 0x39, 38 },
    { 0x3A, 45 },
    { 0x3B, 46 },
    { 0x3C, 47 },
    { 0x3D, 48 },
    { 0x3E, 49 },
    { 0x3F, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx11PlusBufferFormat[Idx->_index];
}
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
constexpr ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 7
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 8
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 9
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 10
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 11
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 12
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 13
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 14
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 15
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 16
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 17
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 18
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 19
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x4, 0x9, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 20
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 21
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 22
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 23
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 24
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 25
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 26
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 27
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 28
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 29
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 30
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 31
  { Intrinsic::amdgcn_image_atomic_fmax_1d, IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 32
  { Intrinsic::amdgcn_image_atomic_fmax_1darray, IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 33
  { Intrinsic::amdgcn_image_atomic_fmax_2d, IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 34
  { Intrinsic::amdgcn_image_atomic_fmax_2darray, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 35
  { Intrinsic::amdgcn_image_atomic_fmax_2darraymsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 36
  { Intrinsic::amdgcn_image_atomic_fmax_2dmsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 37
  { Intrinsic::amdgcn_image_atomic_fmax_3d, IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 38
  { Intrinsic::amdgcn_image_atomic_fmax_cube, IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 39
  { Intrinsic::amdgcn_image_atomic_fmin_1d, IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 40
  { Intrinsic::amdgcn_image_atomic_fmin_1darray, IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 41
  { Intrinsic::amdgcn_image_atomic_fmin_2d, IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 42
  { Intrinsic::amdgcn_image_atomic_fmin_2darray, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 43
  { Intrinsic::amdgcn_image_atomic_fmin_2darraymsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 44
  { Intrinsic::amdgcn_image_atomic_fmin_2dmsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 45
  { Intrinsic::amdgcn_image_atomic_fmin_3d, IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 46
  { Intrinsic::amdgcn_image_atomic_fmin_cube, IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 47
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 48
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 49
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 50
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 51
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 52
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 53
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 54
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 55
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 56
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 57
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 58
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 59
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 60
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 61
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 62
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 63
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 64
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 65
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 66
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 67
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 68
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 69
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 70
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 71
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 72
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 73
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 74
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 75
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 76
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 77
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 78
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 79
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 80
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 81
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 82
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 83
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 84
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 85
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 86
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 87
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 88
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 89
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 90
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 91
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 92
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 93
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 94
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 95
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 96
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 97
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 98
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 99
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 100
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 101
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 102
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 103
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 104
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 105
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 106
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 107
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 108
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 109
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 110
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 111
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 112
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 113
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 114
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 115
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 116
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 117
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 118
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 119
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 120
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 121
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 122
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 123
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 124
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 125
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 126
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 127
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 128
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 129
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 130
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 131
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 132
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 133
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 134
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 135
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 136
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 137
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 138
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 139
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 140
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 141
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 142
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 143
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 144
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 145
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 146
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 147
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 148
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 149
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 150
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 151
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 152
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 153
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 154
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 155
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 156
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 157
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 158
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 159
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 160
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 161
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 162
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 163
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 164
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 165
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 166
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 167
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 168
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 169
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 170
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 171
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 172
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 173
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 174
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 175
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 176
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 177
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 178
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 179
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 180
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 181
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 182
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 183
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 184
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 185
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 186
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 187
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 188
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 189
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 190
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 191
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 192
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 193
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 194
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 195
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 196
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 197
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 198
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 199
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 200
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 201
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 202
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 203
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 204
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 205
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 206
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 207
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 208
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 209
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 210
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 211
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 212
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 213
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 214
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 215
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 216
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 217
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 218
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 219
  { Intrinsic::amdgcn_image_msaa_load_2darraymsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 220
  { Intrinsic::amdgcn_image_msaa_load_2dmsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 221
  { Intrinsic::amdgcn_image_msaa_load_x_2darraymsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 222
  { Intrinsic::amdgcn_image_msaa_load_x_2dmsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 223
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 224
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 225
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 226
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 227
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 228
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x2, 0x2 }, // 229
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 230
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 231
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 232
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 233
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 234
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 235
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 236
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 237
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 238
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 239
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 240
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 241
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 242
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 243
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 244
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 245
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 246
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 247
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 248
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 249
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 250
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 251
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 252
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 253
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 254
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 255
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 256
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 257
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 258
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 259
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 260
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 261
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 262
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 263
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 264
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 265
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 266
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 267
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 268
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 269
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 270
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 271
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 272
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 273
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 274
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 275
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 276
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 277
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 278
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 279
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 280
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 281
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 282
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 283
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 284
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 285
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 286
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 287
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 288
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 289
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 290
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 291
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 292
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 293
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 294
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 295
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 296
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 297
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 298
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 299
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 300
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 301
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 302
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 303
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 304
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 305
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 306
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 307
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 308
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 309
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 310
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 311
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 312
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 313
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 314
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 315
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 316
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 317
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 318
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 319
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 320
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 321
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 322
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 323
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 324
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 325
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 326
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 327
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 328
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 329
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 330
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 331
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 332
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 333
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 334
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 335
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 336
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 337
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 338
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 339
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 340
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 341
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 342
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 343
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 344
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 345
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 346
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 347
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 348
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 349
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 350
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 351
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 352
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 353
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 354
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 355
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 356
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 357
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 358
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 359
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 360
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 361
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 362
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 363
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 364
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 365
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 366
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 367
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 368
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 369
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 370
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 371
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 372
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 373
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 374
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 375
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 376
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 377
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 378
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 379
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 380
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 381
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 382
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 383
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 384
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 385
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 386
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 387
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 388
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 389
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 390
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 391
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 392
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 393
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 394
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 395
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 396
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 397
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 398
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 399
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 400
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 401
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 402
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 403
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 404
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 405
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 406
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 407
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 408
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 409
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 410
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 411
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 412
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 413
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 414
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 415
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 416
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 417
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 418
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 419
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 420
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 421
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 422
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 423
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 424
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 425
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 426
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 427
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 428
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 429
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 430
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 431
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 432
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 433
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 434
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 435
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 436
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 437
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 438
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 439
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 440
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 441
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 442
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 443
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 444
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 445
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 446
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 447
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 448
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 449
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 450
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 451
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 452
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 453
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 454
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 455
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 456
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 457
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 458
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 459
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 460
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 461
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 462
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 463
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 464
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 465
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 466
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 467
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 468
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 469
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 470
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 471
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 472
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 473
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 474
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 475
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 476
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 477
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_atomic_add_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  auto Table = ArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}

const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim) {
  struct IndexType {
    unsigned BaseOpcode;
    unsigned Dim;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 1 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2D, 2 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 3 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 4 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 5 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim3D, 6 },
    { IMAGE_ATOMIC_ADD, AMDGPUDimCube, 7 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1D, 8 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 9 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2D, 10 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 11 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 12 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 13 },
    { IMAGE_ATOMIC_AND, AMDGPUDim3D, 14 },
    { IMAGE_ATOMIC_AND, AMDGPUDimCube, 15 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 16 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 17 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 18 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 19 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 20 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 21 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 22 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 23 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1D, 24 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 25 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2D, 26 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 27 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 28 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 29 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim3D, 30 },
    { IMAGE_ATOMIC_DEC, AMDGPUDimCube, 31 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 32 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 33 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 34 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 35 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 36 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 37 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 38 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 39 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 40 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 41 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 42 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 43 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 44 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 45 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 46 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 47 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1D, 48 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 49 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2D, 50 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 51 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 52 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 53 },
    { IMAGE_ATOMIC_INC, AMDGPUDim3D, 54 },
    { IMAGE_ATOMIC_INC, AMDGPUDimCube, 55 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1D, 56 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 57 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2D, 58 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 59 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 60 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 61 },
    { IMAGE_ATOMIC_OR, AMDGPUDim3D, 62 },
    { IMAGE_ATOMIC_OR, AMDGPUDimCube, 63 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 64 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 65 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 66 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 67 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 68 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 69 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 70 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 71 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 72 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 73 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 74 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 75 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 76 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 77 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 78 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 79 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1D, 80 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 81 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2D, 82 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 83 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 84 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 85 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim3D, 86 },
    { IMAGE_ATOMIC_SUB, AMDGPUDimCube, 87 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 88 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 89 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 90 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 91 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 92 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 93 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 94 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 95 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 96 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 97 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 98 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 99 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 100 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 101 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 102 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 103 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 104 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 105 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 106 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 107 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 108 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 109 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 110 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 111 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1D, 112 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 113 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2D, 114 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 115 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 116 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 117 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim3D, 118 },
    { IMAGE_ATOMIC_XOR, AMDGPUDimCube, 119 },
    { IMAGE_GATHER4, AMDGPUDim2D, 120 },
    { IMAGE_GATHER4, AMDGPUDim2DArray, 121 },
    { IMAGE_GATHER4, AMDGPUDimCube, 176 },
    { IMAGE_GATHER4_B, AMDGPUDim2D, 122 },
    { IMAGE_GATHER4_B, AMDGPUDim2DArray, 123 },
    { IMAGE_GATHER4_B, AMDGPUDimCube, 130 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2D, 124 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 125 },
    { IMAGE_GATHER4_B_CL, AMDGPUDimCube, 126 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 127 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 128 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 129 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2D, 131 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 132 },
    { IMAGE_GATHER4_B_O, AMDGPUDimCube, 133 },
    { IMAGE_GATHER4_C, AMDGPUDim2D, 134 },
    { IMAGE_GATHER4_C, AMDGPUDim2DArray, 135 },
    { IMAGE_GATHER4_C, AMDGPUDimCube, 154 },
    { IMAGE_GATHER4_CL, AMDGPUDim2D, 170 },
    { IMAGE_GATHER4_CL, AMDGPUDim2DArray, 171 },
    { IMAGE_GATHER4_CL, AMDGPUDimCube, 172 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2D, 173 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 174 },
    { IMAGE_GATHER4_CL_O, AMDGPUDimCube, 175 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2D, 136 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 137 },
    { IMAGE_GATHER4_C_B, AMDGPUDimCube, 144 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 138 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 139 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 140 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 141 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 142 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 143 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 145 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 146 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 147 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2D, 148 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 149 },
    { IMAGE_GATHER4_C_CL, AMDGPUDimCube, 150 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 151 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 152 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 153 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2D, 155 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 156 },
    { IMAGE_GATHER4_C_L, AMDGPUDimCube, 157 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 161 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 162 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 163 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 164 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 165 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 166 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 158 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 159 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 160 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2D, 167 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 168 },
    { IMAGE_GATHER4_C_O, AMDGPUDimCube, 169 },
    { IMAGE_GATHER4_L, AMDGPUDim2D, 177 },
    { IMAGE_GATHER4_L, AMDGPUDim2DArray, 178 },
    { IMAGE_GATHER4_L, AMDGPUDimCube, 179 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2D, 183 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 184 },
    { IMAGE_GATHER4_LZ, AMDGPUDimCube, 185 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 186 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 187 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 188 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2D, 180 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 181 },
    { IMAGE_GATHER4_L_O, AMDGPUDimCube, 182 },
    { IMAGE_GATHER4_O, AMDGPUDim2D, 189 },
    { IMAGE_GATHER4_O, AMDGPUDim2DArray, 190 },
    { IMAGE_GATHER4_O, AMDGPUDimCube, 191 },
    { IMAGE_GET_LOD, AMDGPUDim1D, 192 },
    { IMAGE_GET_LOD, AMDGPUDim1DArray, 193 },
    { IMAGE_GET_LOD, AMDGPUDim2D, 194 },
    { IMAGE_GET_LOD, AMDGPUDim2DArray, 195 },
    { IMAGE_GET_LOD, AMDGPUDim3D, 196 },
    { IMAGE_GET_LOD, AMDGPUDimCube, 197 },
    { IMAGE_GET_RESINFO, AMDGPUDim1D, 198 },
    { IMAGE_GET_RESINFO, AMDGPUDim1DArray, 199 },
    { IMAGE_GET_RESINFO, AMDGPUDim2D, 200 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArray, 201 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 202 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 203 },
    { IMAGE_GET_RESINFO, AMDGPUDim3D, 204 },
    { IMAGE_GET_RESINFO, AMDGPUDimCube, 205 },
    { IMAGE_LOAD, AMDGPUDim1D, 206 },
    { IMAGE_LOAD, AMDGPUDim1DArray, 207 },
    { IMAGE_LOAD, AMDGPUDim2D, 208 },
    { IMAGE_LOAD, AMDGPUDim2DArray, 209 },
    { IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 210 },
    { IMAGE_LOAD, AMDGPUDim2DMsaa, 211 },
    { IMAGE_LOAD, AMDGPUDim3D, 212 },
    { IMAGE_LOAD, AMDGPUDimCube, 213 },
    { IMAGE_LOAD_MIP, AMDGPUDim1D, 214 },
    { IMAGE_LOAD_MIP, AMDGPUDim1DArray, 215 },
    { IMAGE_LOAD_MIP, AMDGPUDim2D, 216 },
    { IMAGE_LOAD_MIP, AMDGPUDim2DArray, 217 },
    { IMAGE_LOAD_MIP, AMDGPUDim3D, 218 },
    { IMAGE_LOAD_MIP, AMDGPUDimCube, 219 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 220 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 221 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 222 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 223 },
    { IMAGE_SAMPLE, AMDGPUDim1D, 224 },
    { IMAGE_SAMPLE, AMDGPUDim1DArray, 225 },
    { IMAGE_SAMPLE, AMDGPUDim2D, 226 },
    { IMAGE_SAMPLE, AMDGPUDim2DArray, 227 },
    { IMAGE_SAMPLE, AMDGPUDim3D, 228 },
    { IMAGE_SAMPLE, AMDGPUDimCube, 409 },
    { IMAGE_SAMPLE_B, AMDGPUDim1D, 229 },
    { IMAGE_SAMPLE_B, AMDGPUDim1DArray, 230 },
    { IMAGE_SAMPLE_B, AMDGPUDim2D, 231 },
    { IMAGE_SAMPLE_B, AMDGPUDim2DArray, 232 },
    { IMAGE_SAMPLE_B, AMDGPUDim3D, 233 },
    { IMAGE_SAMPLE_B, AMDGPUDimCube, 246 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 234 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 235 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 236 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 237 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 238 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 239 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 240 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 241 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 242 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 243 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 244 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 245 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1D, 247 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 248 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2D, 249 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 250 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim3D, 251 },
    { IMAGE_SAMPLE_B_O, AMDGPUDimCube, 252 },
    { IMAGE_SAMPLE_C, AMDGPUDim1D, 253 },
    { IMAGE_SAMPLE_C, AMDGPUDim1DArray, 254 },
    { IMAGE_SAMPLE_C, AMDGPUDim2D, 255 },
    { IMAGE_SAMPLE_C, AMDGPUDim2DArray, 256 },
    { IMAGE_SAMPLE_C, AMDGPUDim3D, 257 },
    { IMAGE_SAMPLE_C, AMDGPUDimCube, 318 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1D, 373 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 374 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2D, 375 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 376 },
    { IMAGE_SAMPLE_CD, AMDGPUDim3D, 377 },
    { IMAGE_SAMPLE_CD, AMDGPUDimCube, 390 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 378 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 379 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 380 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 381 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 382 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 383 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 384 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 385 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 386 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 387 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 388 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 389 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 391 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 392 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 393 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 394 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 395 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 396 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1D, 397 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 398 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2D, 399 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 400 },
    { IMAGE_SAMPLE_CL, AMDGPUDim3D, 401 },
    { IMAGE_SAMPLE_CL, AMDGPUDimCube, 402 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 403 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 404 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 405 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 406 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 407 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 408 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1D, 258 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 259 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2D, 260 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 261 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim3D, 262 },
    { IMAGE_SAMPLE_C_B, AMDGPUDimCube, 275 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 263 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 264 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 265 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 266 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 267 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 268 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 269 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 270 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 271 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 272 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 273 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 274 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 276 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 277 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 278 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 279 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 280 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 281 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 282 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 283 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 284 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 285 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 286 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 299 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 287 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 288 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 289 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 290 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 291 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 292 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 293 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 294 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 295 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 296 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 297 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 298 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 300 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 301 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 302 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 303 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 304 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 305 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 306 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 307 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 308 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 309 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 310 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 311 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 312 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 313 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 314 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 315 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 316 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 317 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1D, 319 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 320 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2D, 321 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 322 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim3D, 323 },
    { IMAGE_SAMPLE_C_D, AMDGPUDimCube, 336 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 324 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 325 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 326 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 327 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 328 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 329 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 330 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 331 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 332 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 333 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 334 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 335 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 337 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 338 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 339 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 340 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 341 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 342 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1D, 343 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 344 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2D, 345 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 346 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim3D, 347 },
    { IMAGE_SAMPLE_C_L, AMDGPUDimCube, 348 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 355 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 356 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 357 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 358 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 359 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 360 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 361 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 362 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 363 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 364 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 365 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 366 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 349 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 350 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 351 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 352 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 353 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 354 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1D, 367 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 368 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2D, 369 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 370 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim3D, 371 },
    { IMAGE_SAMPLE_C_O, AMDGPUDimCube, 372 },
    { IMAGE_SAMPLE_D, AMDGPUDim1D, 410 },
    { IMAGE_SAMPLE_D, AMDGPUDim1DArray, 411 },
    { IMAGE_SAMPLE_D, AMDGPUDim2D, 412 },
    { IMAGE_SAMPLE_D, AMDGPUDim2DArray, 413 },
    { IMAGE_SAMPLE_D, AMDGPUDim3D, 414 },
    { IMAGE_SAMPLE_D, AMDGPUDimCube, 427 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 415 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 416 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 417 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 418 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 419 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 420 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 421 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 422 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 423 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 424 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 425 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 426 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1D, 428 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 429 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2D, 430 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 431 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim3D, 432 },
    { IMAGE_SAMPLE_D_O, AMDGPUDimCube, 433 },
    { IMAGE_SAMPLE_L, AMDGPUDim1D, 434 },
    { IMAGE_SAMPLE_L, AMDGPUDim1DArray, 435 },
    { IMAGE_SAMPLE_L, AMDGPUDim2D, 436 },
    { IMAGE_SAMPLE_L, AMDGPUDim2DArray, 437 },
    { IMAGE_SAMPLE_L, AMDGPUDim3D, 438 },
    { IMAGE_SAMPLE_L, AMDGPUDimCube, 439 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1D, 446 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 447 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2D, 448 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 449 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim3D, 450 },
    { IMAGE_SAMPLE_LZ, AMDGPUDimCube, 451 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 452 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 453 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 454 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 455 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 456 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 457 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1D, 440 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 441 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2D, 442 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 443 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim3D, 444 },
    { IMAGE_SAMPLE_L_O, AMDGPUDimCube, 445 },
    { IMAGE_SAMPLE_O, AMDGPUDim1D, 458 },
    { IMAGE_SAMPLE_O, AMDGPUDim1DArray, 459 },
    { IMAGE_SAMPLE_O, AMDGPUDim2D, 460 },
    { IMAGE_SAMPLE_O, AMDGPUDim2DArray, 461 },
    { IMAGE_SAMPLE_O, AMDGPUDim3D, 462 },
    { IMAGE_SAMPLE_O, AMDGPUDimCube, 463 },
    { IMAGE_STORE, AMDGPUDim1D, 464 },
    { IMAGE_STORE, AMDGPUDim1DArray, 465 },
    { IMAGE_STORE, AMDGPUDim2D, 466 },
    { IMAGE_STORE, AMDGPUDim2DArray, 467 },
    { IMAGE_STORE, AMDGPUDim2DArrayMsaa, 468 },
    { IMAGE_STORE, AMDGPUDim2DMsaa, 469 },
    { IMAGE_STORE, AMDGPUDim3D, 470 },
    { IMAGE_STORE, AMDGPUDimCube, 471 },
    { IMAGE_STORE_MIP, AMDGPUDim1D, 472 },
    { IMAGE_STORE_MIP, AMDGPUDim1DArray, 473 },
    { IMAGE_STORE_MIP, AMDGPUDim2D, 474 },
    { IMAGE_STORE_MIP, AMDGPUDim2DArray, 475 },
    { IMAGE_STORE_MIP, AMDGPUDim3D, 476 },
    { IMAGE_STORE_MIP, AMDGPUDimCube, 477 },
  };

  struct KeyType {
    unsigned BaseOpcode;
    unsigned Dim;
  };
  KeyType Key = {BaseOpcode, Dim};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.Dim < (unsigned)RHS.Dim)
        return true;
      if ((unsigned)LHS.Dim > (unsigned)RHS.Dim)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.Dim != Idx->Dim)
    return nullptr;
  return &ImageDimIntrinsicTable[Idx->_index];
}
#endif

#ifdef GET_MAIInstInfoTable_DECL
const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode);
#endif

#ifdef GET_MAIInstInfoTable_IMPL
constexpr MAIInstInfo MAIInstInfoTable[] = {
  { V_MFMA_F32_16X16X16BF16_1K_e64, false, true }, // 0
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false, true }, // 1
  { V_MFMA_F32_16X16X16F16_e64, false, true }, // 2
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false, true }, // 3
  { V_MFMA_F32_16X16X1F32_e64, false, false }, // 4
  { V_MFMA_F32_16X16X1F32_mac_e64, false, false }, // 5
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false, false }, // 6
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false, false }, // 7
  { V_MFMA_F32_16X16X2BF16_e64, false, false }, // 8
  { V_MFMA_F32_16X16X2BF16_mac_e64, false, false }, // 9
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false, false }, // 10
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false, false }, // 11
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false, true }, // 12
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false, true }, // 13
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false, true }, // 14
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false, true }, // 15
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false, true }, // 16
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false, true }, // 17
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false, true }, // 18
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false, true }, // 19
  { V_MFMA_F32_16X16X4BF16_1K_e64, false, true }, // 20
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false, true }, // 21
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false, true }, // 22
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false, true }, // 23
  { V_MFMA_F32_16X16X4F16_e64, false, true }, // 24
  { V_MFMA_F32_16X16X4F16_mac_e64, false, true }, // 25
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false, true }, // 26
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false, true }, // 27
  { V_MFMA_F32_16X16X4F32_e64, false, false }, // 28
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false, false }, // 29
  { V_MFMA_F32_16X16X8BF16_e64, false, false }, // 30
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false, false }, // 31
  { V_MFMA_F32_16X16X8XF32_e64, false, true }, // 32
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false, true }, // 33
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false, true }, // 34
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false, true }, // 35
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false, true }, // 36
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false, true }, // 37
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false, true }, // 38
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false, true }, // 39
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false, true }, // 40
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false, true }, // 41
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false, true }, // 42
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false, true }, // 43
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false, true }, // 44
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false, true }, // 45
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false, true }, // 46
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false, true }, // 47
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false, true }, // 48
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false, true }, // 49
  { V_MFMA_F32_32X32X1F32_e64, false, false }, // 50
  { V_MFMA_F32_32X32X1F32_mac_e64, false, false }, // 51
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false, false }, // 52
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false, false }, // 53
  { V_MFMA_F32_32X32X2BF16_e64, false, false }, // 54
  { V_MFMA_F32_32X32X2BF16_mac_e64, false, false }, // 55
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false, false }, // 56
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false, false }, // 57
  { V_MFMA_F32_32X32X2F32_e64, false, false }, // 58
  { V_MFMA_F32_32X32X2F32_mac_e64, false, false }, // 59
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false, false }, // 60
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false, false }, // 61
  { V_MFMA_F32_32X32X4BF16_1K_e64, false, true }, // 62
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false, true }, // 63
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false, true }, // 64
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false, true }, // 65
  { V_MFMA_F32_32X32X4BF16_e64, false, false }, // 66
  { V_MFMA_F32_32X32X4BF16_mac_e64, false, false }, // 67
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false, false }, // 68
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false, false }, // 69
  { V_MFMA_F32_32X32X4F16_e64, false, true }, // 70
  { V_MFMA_F32_32X32X4F16_mac_e64, false, true }, // 71
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false, true }, // 72
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false, true }, // 73
  { V_MFMA_F32_32X32X4XF32_e64, false, true }, // 74
  { V_MFMA_F32_32X32X4XF32_mac_e64, false, true }, // 75
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false, true }, // 76
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false, true }, // 77
  { V_MFMA_F32_32X32X8BF16_1K_e64, false, true }, // 78
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false, true }, // 79
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false, true }, // 80
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false, true }, // 81
  { V_MFMA_F32_32X32X8F16_e64, false, true }, // 82
  { V_MFMA_F32_32X32X8F16_mac_e64, false, true }, // 83
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false, true }, // 84
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false, true }, // 85
  { V_MFMA_F32_4X4X1F32_e64, false, false }, // 86
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false, false }, // 87
  { V_MFMA_F32_4X4X2BF16_e64, false, false }, // 88
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false, false }, // 89
  { V_MFMA_F32_4X4X4BF16_1K_e64, false, true }, // 90
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false, true }, // 91
  { V_MFMA_F32_4X4X4F16_e64, false, true }, // 92
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false, true }, // 93
  { V_MFMA_F64_16X16X4F64_e64, true, false }, // 94
  { V_MFMA_F64_16X16X4F64_mac_e64, true, false }, // 95
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, true, false }, // 96
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, true, false }, // 97
  { V_MFMA_F64_4X4X4F64_e64, true, false }, // 98
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, true, false }, // 99
  { V_MFMA_I32_16X16X16I8_e64, false, false }, // 100
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false, false }, // 101
  { V_MFMA_I32_16X16X32I8_e64, false, true }, // 102
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false, true }, // 103
  { V_MFMA_I32_16X16X4I8_e64, false, true }, // 104
  { V_MFMA_I32_16X16X4I8_mac_e64, false, true }, // 105
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false, true }, // 106
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false, true }, // 107
  { V_MFMA_I32_32X32X16I8_e64, false, true }, // 108
  { V_MFMA_I32_32X32X16I8_mac_e64, false, true }, // 109
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false, true }, // 110
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false, true }, // 111
  { V_MFMA_I32_32X32X4I8_e64, false, true }, // 112
  { V_MFMA_I32_32X32X4I8_mac_e64, false, true }, // 113
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false, true }, // 114
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false, true }, // 115
  { V_MFMA_I32_32X32X8I8_e64, false, false }, // 116
  { V_MFMA_I32_32X32X8I8_mac_e64, false, false }, // 117
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false, false }, // 118
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false, false }, // 119
  { V_MFMA_I32_4X4X4I8_e64, false, true }, // 120
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false, true }, // 121
  { V_SMFMAC_F32_16X16X32_BF16_e64, false, true }, // 122
  { V_SMFMAC_F32_16X16X32_F16_e64, false, true }, // 123
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false, true }, // 124
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false, true }, // 125
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false, true }, // 126
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false, true }, // 127
  { V_SMFMAC_F32_32X32X16_BF16_e64, false, true }, // 128
  { V_SMFMAC_F32_32X32X16_F16_e64, false, true }, // 129
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false, true }, // 130
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false, true }, // 131
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false, true }, // 132
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false, true }, // 133
  { V_SMFMAC_I32_16X16X64_I8_e64, false, true }, // 134
  { V_SMFMAC_I32_32X32X32_I8_e64, false, true }, // 135
 };

const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  auto Table = ArrayRef(MAIInstInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MAIInstInfo &LHS, const KeyType &RHS) {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
constexpr MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 0
  { IMAGE_ATOMIC_AND, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 1
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false }, // 2
  { IMAGE_ATOMIC_DEC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 3
  { IMAGE_ATOMIC_FCMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false }, // 4
  { IMAGE_ATOMIC_FMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 5
  { IMAGE_ATOMIC_FMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 6
  { IMAGE_ATOMIC_INC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 7
  { IMAGE_ATOMIC_OR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 8
  { IMAGE_ATOMIC_RSUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 9
  { IMAGE_ATOMIC_SMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 10
  { IMAGE_ATOMIC_SMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 11
  { IMAGE_ATOMIC_SUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 12
  { IMAGE_ATOMIC_SWAP, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 13
  { IMAGE_ATOMIC_UMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 14
  { IMAGE_ATOMIC_UMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 15
  { IMAGE_ATOMIC_XOR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 16
  { IMAGE_BVH64_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false }, // 17
  { IMAGE_BVH64_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true }, // 18
  { IMAGE_BVH_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false }, // 19
  { IMAGE_BVH_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true }, // 20
  { IMAGE_GATHER4, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 21
  { IMAGE_GATHER4H, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 22
  { IMAGE_GATHER4_B, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 23
  { IMAGE_GATHER4_B_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 24
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 25
  { IMAGE_GATHER4_B_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 26
  { IMAGE_GATHER4_C, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 27
  { IMAGE_GATHER4_CL, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false }, // 28
  { IMAGE_GATHER4_CL_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 29
  { IMAGE_GATHER4_C_B, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 30
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 31
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, true, 0x3, false, false, true, true, true, false, false, false }, // 32
  { IMAGE_GATHER4_C_B_O, false, false, false, true, true, 0x3, false, false, true, false, true, false, false, false }, // 33
  { IMAGE_GATHER4_C_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 34
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 35
  { IMAGE_GATHER4_C_L, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 36
  { IMAGE_GATHER4_C_LZ, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 37
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 38
  { IMAGE_GATHER4_C_L_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 39
  { IMAGE_GATHER4_C_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 40
  { IMAGE_GATHER4_L, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false }, // 41
  { IMAGE_GATHER4_LZ, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 42
  { IMAGE_GATHER4_LZ_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 43
  { IMAGE_GATHER4_L_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 44
  { IMAGE_GATHER4_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 45
  { IMAGE_GET_LOD, false, false, false, true, false, 0x0, false, false, true, false, false, false, false, false }, // 46
  { IMAGE_GET_RESINFO, false, false, false, false, false, 0x0, false, false, false, true, false, false, false, false }, // 47
  { IMAGE_LOAD, false, false, false, false, false, 0x0, false, false, true, false, true, false, false, false }, // 48
  { IMAGE_LOAD_MIP, false, false, false, false, false, 0x0, false, false, true, true, true, false, false, false }, // 49
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 50
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 51
  { IMAGE_LOAD_PCK, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 52
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 53
  { IMAGE_MSAA_LOAD, false, false, false, false, true, 0x0, false, false, true, false, true, true, false, false }, // 54
  { IMAGE_MSAA_LOAD_X, false, false, false, false, false, 0x0, false, false, true, false, true, true, false, false }, // 55
  { IMAGE_SAMPLE, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false }, // 56
  { IMAGE_SAMPLE_B, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 57
  { IMAGE_SAMPLE_B_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 58
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 59
  { IMAGE_SAMPLE_B_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 60
  { IMAGE_SAMPLE_C, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 61
  { IMAGE_SAMPLE_CD, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false }, // 62
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false }, // 63
  { IMAGE_SAMPLE_CD_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false }, // 64
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 65
  { IMAGE_SAMPLE_CD_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 66
  { IMAGE_SAMPLE_CD_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false }, // 67
  { IMAGE_SAMPLE_CD_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 68
  { IMAGE_SAMPLE_CD_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 69
  { IMAGE_SAMPLE_CL, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false }, // 70
  { IMAGE_SAMPLE_CL_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 71
  { IMAGE_SAMPLE_C_B, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 72
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 73
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false }, // 74
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false }, // 75
  { IMAGE_SAMPLE_C_CD, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 76
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 77
  { IMAGE_SAMPLE_C_CD_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 78
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false }, // 79
  { IMAGE_SAMPLE_C_CD_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false }, // 80
  { IMAGE_SAMPLE_C_CD_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 81
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false }, // 82
  { IMAGE_SAMPLE_C_CD_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false }, // 83
  { IMAGE_SAMPLE_C_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 84
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 85
  { IMAGE_SAMPLE_C_D, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 86
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 87
  { IMAGE_SAMPLE_C_D_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 88
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false }, // 89
  { IMAGE_SAMPLE_C_D_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false }, // 90
  { IMAGE_SAMPLE_C_D_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 91
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false }, // 92
  { IMAGE_SAMPLE_C_D_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false }, // 93
  { IMAGE_SAMPLE_C_L, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 94
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 95
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 96
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 97
  { IMAGE_SAMPLE_C_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 98
  { IMAGE_SAMPLE_D, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false }, // 99
  { IMAGE_SAMPLE_D_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false }, // 100
  { IMAGE_SAMPLE_D_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false }, // 101
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 102
  { IMAGE_SAMPLE_D_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 103
  { IMAGE_SAMPLE_D_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false }, // 104
  { IMAGE_SAMPLE_D_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 105
  { IMAGE_SAMPLE_D_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 106
  { IMAGE_SAMPLE_L, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false }, // 107
  { IMAGE_SAMPLE_LZ, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false }, // 108
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 109
  { IMAGE_SAMPLE_L_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 110
  { IMAGE_SAMPLE_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 111
  { IMAGE_STORE, true, false, false, false, false, 0x0, false, false, true, false, true, false, false, false }, // 112
  { IMAGE_STORE_MIP, true, false, false, false, false, 0x0, false, false, true, true, true, false, false, false }, // 113
  { IMAGE_STORE_MIP_PCK, true, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 114
  { IMAGE_STORE_PCK, true, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 115
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  auto Table = ArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}
#endif

#ifdef GET_MIMGBiasMappingTable_DECL
const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias);
#endif

#ifdef GET_MIMGBiasMappingTable_IMPL
constexpr MIMGBiasMappingInfo MIMGBiasMappingTable[] = {
  { IMAGE_GATHER4_B, IMAGE_GATHER4 }, // 0
  { IMAGE_GATHER4_B_CL, IMAGE_GATHER4_CL }, // 1
  { IMAGE_GATHER4_B_CL_O, IMAGE_GATHER4_CL_O }, // 2
  { IMAGE_GATHER4_B_O, IMAGE_GATHER4_O }, // 3
  { IMAGE_GATHER4_C_B, IMAGE_GATHER4_C }, // 4
  { IMAGE_GATHER4_C_B_CL, IMAGE_GATHER4_C_CL }, // 5
  { IMAGE_GATHER4_C_B_CL_O, IMAGE_GATHER4_C_CL_O }, // 6
  { IMAGE_GATHER4_C_B_O, IMAGE_GATHER4_C_O }, // 7
  { IMAGE_SAMPLE_B, IMAGE_SAMPLE }, // 8
  { IMAGE_SAMPLE_B_CL, IMAGE_SAMPLE_CL }, // 9
  { IMAGE_SAMPLE_B_CL_O, IMAGE_SAMPLE_CL_O }, // 10
  { IMAGE_SAMPLE_B_O, IMAGE_SAMPLE_O }, // 11
  { IMAGE_SAMPLE_C_B, IMAGE_SAMPLE_C }, // 12
  { IMAGE_SAMPLE_C_B_CL, IMAGE_SAMPLE_C_CL }, // 13
  { IMAGE_SAMPLE_C_B_CL_O, IMAGE_SAMPLE_C_CL_O }, // 14
  { IMAGE_SAMPLE_C_B_O, IMAGE_SAMPLE_C_O }, // 15
 };

const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias) {
  struct KeyType {
    unsigned Bias;
  };
  KeyType Key = {Bias};
  auto Table = ArrayRef(MIMGBiasMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGBiasMappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.Bias < (unsigned)RHS.Bias)
        return true;
      if ((unsigned)LHS.Bias > (unsigned)RHS.Bias)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Bias != Idx->Bias)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix);
const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
constexpr MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false, false, 0x0, "1D" }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, false, true, 0x4, "1D_ARRAY" }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false, false, 0x1, "2D" }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, false, true, 0x5, "2D_ARRAY" }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true, true, 0x7, "2D_MSAA_ARRAY" }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, true, false, 0x6, "2D_MSAA" }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false, false, 0x2, "3D" }, // 6
  { AMDGPUDimCube, 0x3, 0x4, false, true, 0x3, "CUBE" }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  auto Table = ArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}

const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix) {
  struct IndexType {
    const char * AsmSuffix;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "1D", 0 },
    { "1D_ARRAY", 1 },
    { "2D", 2 },
    { "2D_ARRAY", 3 },
    { "2D_MSAA", 5 },
    { "2D_MSAA_ARRAY", 4 },
    { "3D", 6 },
    { "CUBE", 7 },
  };

  struct KeyType {
    std::string AsmSuffix;
  };
  KeyType Key = {AsmSuffix.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpAsmSuffix = StringRef(LHS.AsmSuffix).compare(RHS.AsmSuffix);
      if (CmpAsmSuffix < 0) return true;
      if (CmpAsmSuffix > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.AsmSuffix != Idx->AsmSuffix)
    return nullptr;
  return &MIMGDimInfoTable[Idx->_index];
}

const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x2, 6 },
    { 0x3, 7 },
    { 0x4, 1 },
    { 0x5, 3 },
    { 0x6, 5 },
    { 0x7, 4 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &MIMGDimInfoTable[Table[Idx]._index];
}
#endif

#ifdef GET_MIMGG16MappingTable_DECL
const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G);
#endif

#ifdef GET_MIMGG16MappingTable_IMPL
constexpr MIMGG16MappingInfo MIMGG16MappingTable[] = {
  { IMAGE_SAMPLE_CD, IMAGE_SAMPLE_CD_G16 }, // 0
  { IMAGE_SAMPLE_CD_CL, IMAGE_SAMPLE_CD_CL_G16 }, // 1
  { IMAGE_SAMPLE_CD_CL_O, IMAGE_SAMPLE_CD_CL_O_G16 }, // 2
  { IMAGE_SAMPLE_CD_O, IMAGE_SAMPLE_CD_O_G16 }, // 3
  { IMAGE_SAMPLE_C_CD, IMAGE_SAMPLE_C_CD_G16 }, // 4
  { IMAGE_SAMPLE_C_CD_CL, IMAGE_SAMPLE_C_CD_CL_G16 }, // 5
  { IMAGE_SAMPLE_C_CD_CL_O, IMAGE_SAMPLE_C_CD_CL_O_G16 }, // 6
  { IMAGE_SAMPLE_C_CD_O, IMAGE_SAMPLE_C_CD_O_G16 }, // 7
  { IMAGE_SAMPLE_C_D, IMAGE_SAMPLE_C_D_G16 }, // 8
  { IMAGE_SAMPLE_C_D_CL, IMAGE_SAMPLE_C_D_CL_G16 }, // 9
  { IMAGE_SAMPLE_C_D_CL_O, IMAGE_SAMPLE_C_D_CL_O_G16 }, // 10
  { IMAGE_SAMPLE_C_D_O, IMAGE_SAMPLE_C_D_O_G16 }, // 11
  { IMAGE_SAMPLE_D, IMAGE_SAMPLE_D_G16 }, // 12
  { IMAGE_SAMPLE_D_CL, IMAGE_SAMPLE_D_CL_G16 }, // 13
  { IMAGE_SAMPLE_D_CL_O, IMAGE_SAMPLE_D_CL_O_G16 }, // 14
  { IMAGE_SAMPLE_D_O, IMAGE_SAMPLE_D_O_G16 }, // 15
 };

const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G) {
  struct KeyType {
    unsigned G;
  };
  KeyType Key = {G};
  auto Table = ArrayRef(MIMGG16MappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGG16MappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.G < (unsigned)RHS.G)
        return true;
      if ((unsigned)LHS.G > (unsigned)RHS.G)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.G != Idx->G)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
constexpr MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V2_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6
  { IMAGE_ATOMIC_ADD_V2_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 8
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 9
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 10
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 11
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 12
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 13
  { IMAGE_ATOMIC_ADD_V1_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 14
  { IMAGE_ATOMIC_ADD_V1_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 15
  { IMAGE_ATOMIC_ADD_V1_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 16
  { IMAGE_ATOMIC_ADD_V1_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 17
  { IMAGE_ATOMIC_ADD_V2_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 18
  { IMAGE_ATOMIC_ADD_V2_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 19
  { IMAGE_ATOMIC_ADD_V2_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 20
  { IMAGE_ATOMIC_ADD_V2_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 21
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 22
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 23
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 24
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 25
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 26
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 27
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 28
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 29
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 30
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 31
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 32
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 33
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 34
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 35
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 36
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 37
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 38
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 39
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 40
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 41
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 42
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 43
  { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 44
  { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 45
  { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 46
  { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 47
  { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 48
  { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 49
  { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 50
  { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 51
  { IMAGE_ATOMIC_AND_V1_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 52
  { IMAGE_ATOMIC_AND_V1_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 53
  { IMAGE_ATOMIC_AND_V1_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 54
  { IMAGE_ATOMIC_AND_V1_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 55
  { IMAGE_ATOMIC_AND_V2_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 56
  { IMAGE_ATOMIC_AND_V2_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 57
  { IMAGE_ATOMIC_AND_V2_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 58
  { IMAGE_ATOMIC_AND_V2_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 59
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 60
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 61
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 62
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 63
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 64
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 65
  { IMAGE_ATOMIC_AND_V1_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 66
  { IMAGE_ATOMIC_AND_V1_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 67
  { IMAGE_ATOMIC_AND_V1_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 68
  { IMAGE_ATOMIC_AND_V1_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 69
  { IMAGE_ATOMIC_AND_V2_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 70
  { IMAGE_ATOMIC_AND_V2_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 71
  { IMAGE_ATOMIC_AND_V2_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 72
  { IMAGE_ATOMIC_AND_V2_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 73
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 74
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 75
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 76
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 77
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 78
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 79
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 80
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 81
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 82
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 83
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 84
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 85
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 86
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 87
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 88
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 89
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 90
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 91
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 92
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 93
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 94
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 95
  { IMAGE_ATOMIC_AND_V1_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 96
  { IMAGE_ATOMIC_AND_V1_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 97
  { IMAGE_ATOMIC_AND_V1_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 98
  { IMAGE_ATOMIC_AND_V1_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 99
  { IMAGE_ATOMIC_AND_V2_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 100
  { IMAGE_ATOMIC_AND_V2_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 101
  { IMAGE_ATOMIC_AND_V2_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 102
  { IMAGE_ATOMIC_AND_V2_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 103
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 104
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 105
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 106
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 107
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 108
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 109
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 110
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 111
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 112
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 113
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 114
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 115
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 116
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 117
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 118
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 119
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 120
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 121
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 122
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 123
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 124
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 125
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 126
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 127
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 128
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 129
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 130
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 131
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 132
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 133
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 134
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 135
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 136
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 137
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 138
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 139
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 140
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 141
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 142
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 143
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 144
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 145
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 146
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 147
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 148
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 149
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 150
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 151
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 152
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 153
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 154
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 155
  { IMAGE_ATOMIC_DEC_V1_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 156
  { IMAGE_ATOMIC_DEC_V1_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 157
  { IMAGE_ATOMIC_DEC_V1_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 158
  { IMAGE_ATOMIC_DEC_V1_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 159
  { IMAGE_ATOMIC_DEC_V2_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 160
  { IMAGE_ATOMIC_DEC_V2_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 161
  { IMAGE_ATOMIC_DEC_V2_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 162
  { IMAGE_ATOMIC_DEC_V2_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 163
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 164
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 165
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 166
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 167
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 168
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 169
  { IMAGE_ATOMIC_DEC_V1_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 170
  { IMAGE_ATOMIC_DEC_V1_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 171
  { IMAGE_ATOMIC_DEC_V1_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 172
  { IMAGE_ATOMIC_DEC_V1_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 173
  { IMAGE_ATOMIC_DEC_V2_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 174
  { IMAGE_ATOMIC_DEC_V2_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 175
  { IMAGE_ATOMIC_DEC_V2_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 176
  { IMAGE_ATOMIC_DEC_V2_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 177
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 178
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 179
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 180
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 181
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 182
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 183
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 184
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 185
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 186
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 187
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 188
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 189
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 190
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 191
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 192
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 193
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 194
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 195
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 196
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 197
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 198
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 199
  { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 200
  { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 201
  { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 202
  { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 203
  { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 204
  { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 205
  { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 206
  { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 207
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 208
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 209
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 210
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 211
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 212
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 213
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 214
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 215
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 216
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 217
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 218
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 219
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 220
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 221
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 222
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 223
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 224
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 225
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 226
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 227
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 228
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 229
  { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 230
  { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 231
  { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 232
  { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 233
  { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 234
  { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 235
  { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 236
  { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 237
  { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 238
  { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 239
  { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 240
  { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 241
  { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 242
  { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 243
  { IMAGE_ATOMIC_FMAX_V1_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 244
  { IMAGE_ATOMIC_FMAX_V1_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 245
  { IMAGE_ATOMIC_FMAX_V1_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 246
  { IMAGE_ATOMIC_FMAX_V1_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 247
  { IMAGE_ATOMIC_FMAX_V2_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 248
  { IMAGE_ATOMIC_FMAX_V2_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 249
  { IMAGE_ATOMIC_FMAX_V2_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 250
  { IMAGE_ATOMIC_FMAX_V2_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 251
  { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 252
  { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 253
  { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 254
  { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 255
  { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 256
  { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 257
  { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 258
  { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 259
  { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 260
  { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 261
  { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 262
  { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 263
  { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 264
  { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 265
  { IMAGE_ATOMIC_FMIN_V1_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 266
  { IMAGE_ATOMIC_FMIN_V1_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 267
  { IMAGE_ATOMIC_FMIN_V1_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 268
  { IMAGE_ATOMIC_FMIN_V1_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 269
  { IMAGE_ATOMIC_FMIN_V2_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 270
  { IMAGE_ATOMIC_FMIN_V2_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 271
  { IMAGE_ATOMIC_FMIN_V2_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 272
  { IMAGE_ATOMIC_FMIN_V2_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 273
  { IMAGE_ATOMIC_INC_V1_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 274
  { IMAGE_ATOMIC_INC_V1_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 275
  { IMAGE_ATOMIC_INC_V1_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 276
  { IMAGE_ATOMIC_INC_V1_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 277
  { IMAGE_ATOMIC_INC_V2_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 278
  { IMAGE_ATOMIC_INC_V2_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 279
  { IMAGE_ATOMIC_INC_V2_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 280
  { IMAGE_ATOMIC_INC_V2_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 281
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 282
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 283
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 284
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 285
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 286
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 287
  { IMAGE_ATOMIC_INC_V1_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 288
  { IMAGE_ATOMIC_INC_V1_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 289
  { IMAGE_ATOMIC_INC_V1_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 290
  { IMAGE_ATOMIC_INC_V1_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 291
  { IMAGE_ATOMIC_INC_V2_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 292
  { IMAGE_ATOMIC_INC_V2_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 293
  { IMAGE_ATOMIC_INC_V2_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 294
  { IMAGE_ATOMIC_INC_V2_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 295
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 296
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 297
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 298
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 299
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 300
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 301
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 302
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 303
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 304
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 305
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 306
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 307
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 308
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 309
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 310
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 311
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 312
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 313
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 314
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 315
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 316
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 317
  { IMAGE_ATOMIC_INC_V1_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 318
  { IMAGE_ATOMIC_INC_V1_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 319
  { IMAGE_ATOMIC_INC_V1_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 320
  { IMAGE_ATOMIC_INC_V1_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 321
  { IMAGE_ATOMIC_INC_V2_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 322
  { IMAGE_ATOMIC_INC_V2_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 323
  { IMAGE_ATOMIC_INC_V2_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 324
  { IMAGE_ATOMIC_INC_V2_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 325
  { IMAGE_ATOMIC_OR_V1_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 326
  { IMAGE_ATOMIC_OR_V1_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 327
  { IMAGE_ATOMIC_OR_V1_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 328
  { IMAGE_ATOMIC_OR_V1_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 329
  { IMAGE_ATOMIC_OR_V2_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 330
  { IMAGE_ATOMIC_OR_V2_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 331
  { IMAGE_ATOMIC_OR_V2_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 332
  { IMAGE_ATOMIC_OR_V2_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 333
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 334
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 335
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 336
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 337
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 338
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 339
  { IMAGE_ATOMIC_OR_V1_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 340
  { IMAGE_ATOMIC_OR_V1_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 341
  { IMAGE_ATOMIC_OR_V1_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 342
  { IMAGE_ATOMIC_OR_V1_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 343
  { IMAGE_ATOMIC_OR_V2_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 344
  { IMAGE_ATOMIC_OR_V2_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 345
  { IMAGE_ATOMIC_OR_V2_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 346
  { IMAGE_ATOMIC_OR_V2_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 347
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 348
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 349
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 350
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 351
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 352
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 353
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 354
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 355
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 356
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 357
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 358
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 359
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 360
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 361
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 362
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 363
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 364
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 365
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 366
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 367
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 368
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 369
  { IMAGE_ATOMIC_OR_V1_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 370
  { IMAGE_ATOMIC_OR_V1_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 371
  { IMAGE_ATOMIC_OR_V1_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 372
  { IMAGE_ATOMIC_OR_V1_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 373
  { IMAGE_ATOMIC_OR_V2_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 374
  { IMAGE_ATOMIC_OR_V2_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 375
  { IMAGE_ATOMIC_OR_V2_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 376
  { IMAGE_ATOMIC_OR_V2_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 377
  { IMAGE_ATOMIC_RSUB_V1_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 378
  { IMAGE_ATOMIC_RSUB_V1_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 379
  { IMAGE_ATOMIC_RSUB_V1_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 380
  { IMAGE_ATOMIC_RSUB_V1_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 381
  { IMAGE_ATOMIC_RSUB_V2_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 382
  { IMAGE_ATOMIC_RSUB_V2_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 383
  { IMAGE_ATOMIC_RSUB_V2_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 384
  { IMAGE_ATOMIC_RSUB_V2_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 385
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 386
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 387
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 388
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 389
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 390
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 391
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 392
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 393
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 394
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 395
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 396
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 397
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 398
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 399
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 400
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 401
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 402
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 403
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 404
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 405
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 406
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 407
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 408
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 409
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 410
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 411
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 412
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 413
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 414
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 415
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 416
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 417
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 418
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 419
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 420
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 421
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 422
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 423
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 424
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 425
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 426
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 427
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 428
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 429
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 430
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 431
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 432
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 433
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 434
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 435
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 436
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 437
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 438
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 439
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 440
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 441
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 442
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 443
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 444
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 445
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 446
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 447
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 448
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 449
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 450
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 451
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 452
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 453
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 454
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 455
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 456
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 457
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 458
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 459
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 460
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 461
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 462
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 463
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 464
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 465
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 466
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 467
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 468
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 469
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 470
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 471
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 472
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 473
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 474
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 475
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 476
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 477
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 478
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 479
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 480
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 481
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 482
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 483
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 484
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 485
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 486
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 487
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 488
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 489
  { IMAGE_ATOMIC_SUB_V1_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 490
  { IMAGE_ATOMIC_SUB_V1_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 491
  { IMAGE_ATOMIC_SUB_V1_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 492
  { IMAGE_ATOMIC_SUB_V1_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 493
  { IMAGE_ATOMIC_SUB_V2_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 494
  { IMAGE_ATOMIC_SUB_V2_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 495
  { IMAGE_ATOMIC_SUB_V2_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 496
  { IMAGE_ATOMIC_SUB_V2_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 497
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 498
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 499
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 500
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 501
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 502
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 503
  { IMAGE_ATOMIC_SUB_V1_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 504
  { IMAGE_ATOMIC_SUB_V1_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 505
  { IMAGE_ATOMIC_SUB_V1_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 506
  { IMAGE_ATOMIC_SUB_V1_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 507
  { IMAGE_ATOMIC_SUB_V2_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 508
  { IMAGE_ATOMIC_SUB_V2_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 509
  { IMAGE_ATOMIC_SUB_V2_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 510
  { IMAGE_ATOMIC_SUB_V2_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 511
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 512
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 513
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 514
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 515
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 516
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 517
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 518
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 519
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 520
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 521
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 522
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 523
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 524
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 525
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 526
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 527
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 528
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 529
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 530
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 531
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 532
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 533
  { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 534
  { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 535
  { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 536
  { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 537
  { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 538
  { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 539
  { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 540
  { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 541
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 542
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 543
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 544
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 545
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 546
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 547
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 548
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 549
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 550
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 551
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 552
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 553
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 554
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 555
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 556
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 557
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 558
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 559
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 560
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 561
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 562
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 563
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 564
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 565
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 566
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 567
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 568
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 569
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 570
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 571
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 572
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 573
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 574
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 575
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 576
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 577
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 578
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 579
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 580
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 581
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 582
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 583
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 584
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 585
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 586
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 587
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 588
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 589
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 590
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 591
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 592
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 593
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 594
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 595
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 596
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 597
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 598
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 599
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 600
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 601
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 602
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 603
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 604
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 605
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 606
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 607
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 608
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 609
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 610
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 611
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 612
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 613
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 614
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 615
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 616
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 617
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 618
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 619
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 620
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 621
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 622
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 623
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 624
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 625
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 626
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 627
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 628
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 629
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 630
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 631
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 632
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 633
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 634
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 635
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 636
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 637
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 638
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 639
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 640
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 641
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 642
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 643
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 644
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 645
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 646
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 647
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 648
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 649
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 650
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 651
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 652
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 653
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 654
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 655
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 656
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 657
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 658
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 659
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 660
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 661
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 662
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 663
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 664
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 665
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 666
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 667
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 668
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 669
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 670
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 671
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 672
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 673
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 674
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 675
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 676
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 677
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 678
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 679
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 680
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 681
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 682
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 683
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 684
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 685
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 686
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 687
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 688
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 689
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 690
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 691
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 692
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 693
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 694
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 695
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 696
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 697
  { IMAGE_ATOMIC_XOR_V1_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 698
  { IMAGE_ATOMIC_XOR_V1_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 699
  { IMAGE_ATOMIC_XOR_V1_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 700
  { IMAGE_ATOMIC_XOR_V1_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 701
  { IMAGE_ATOMIC_XOR_V2_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 702
  { IMAGE_ATOMIC_XOR_V2_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 703
  { IMAGE_ATOMIC_XOR_V2_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 704
  { IMAGE_ATOMIC_XOR_V2_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 705
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 706
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 707
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 708
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 709
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 710
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 711
  { IMAGE_ATOMIC_XOR_V1_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 712
  { IMAGE_ATOMIC_XOR_V1_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 713
  { IMAGE_ATOMIC_XOR_V1_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 714
  { IMAGE_ATOMIC_XOR_V1_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 715
  { IMAGE_ATOMIC_XOR_V2_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 716
  { IMAGE_ATOMIC_XOR_V2_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 717
  { IMAGE_ATOMIC_XOR_V2_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 718
  { IMAGE_ATOMIC_XOR_V2_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 719
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 720
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 721
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 722
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 723
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 724
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 725
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 726
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 727
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 728
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 729
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 730
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 731
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 732
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 733
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 734
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 735
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 736
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 737
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 738
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 739
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 740
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 741
  { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 742
  { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 743
  { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 744
  { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 745
  { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 746
  { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 747
  { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 748
  { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 749
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 750
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 751
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 752
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xC, 0x5 }, // 753
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 754
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 755
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 756
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x9, 0x4 }, // 757
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 758
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 759
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 760
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xB, 0x5 }, // 761
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 762
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 763
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 764
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x8, 0x4 }, // 765
  { IMAGE_GATHER4_V2_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 766
  { IMAGE_GATHER4_V2_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 767
  { IMAGE_GATHER4_V2_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 768
  { IMAGE_GATHER4_V2_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 769
  { IMAGE_GATHER4_V4_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 770
  { IMAGE_GATHER4_V4_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 771
  { IMAGE_GATHER4_V4_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 772
  { IMAGE_GATHER4_V4_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 773
  { IMAGE_GATHER4_V5_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 774
  { IMAGE_GATHER4_V5_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 775
  { IMAGE_GATHER4_V5_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 776
  { IMAGE_GATHER4_V5_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 777
  { IMAGE_GATHER4_V2_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 778
  { IMAGE_GATHER4_V2_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 779
  { IMAGE_GATHER4_V4_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 780
  { IMAGE_GATHER4_V4_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 781
  { IMAGE_GATHER4_V5_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 782
  { IMAGE_GATHER4_V5_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 783
  { IMAGE_GATHER4_V2_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 784
  { IMAGE_GATHER4_V2_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 785
  { IMAGE_GATHER4_V2_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 786
  { IMAGE_GATHER4_V2_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 787
  { IMAGE_GATHER4_V4_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 788
  { IMAGE_GATHER4_V4_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 789
  { IMAGE_GATHER4_V4_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 790
  { IMAGE_GATHER4_V4_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 791
  { IMAGE_GATHER4_V5_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 792
  { IMAGE_GATHER4_V5_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 793
  { IMAGE_GATHER4_V5_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 794
  { IMAGE_GATHER4_V5_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 795
  { IMAGE_GATHER4_V2_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 796
  { IMAGE_GATHER4_V2_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 797
  { IMAGE_GATHER4_V4_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 798
  { IMAGE_GATHER4_V4_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 799
  { IMAGE_GATHER4_V5_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 800
  { IMAGE_GATHER4_V5_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 801
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 802
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 803
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 804
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 805
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 806
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 807
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 808
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 809
  { IMAGE_GATHER4_V5_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 810
  { IMAGE_GATHER4_V5_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 811
  { IMAGE_GATHER4_V5_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 812
  { IMAGE_GATHER4_V5_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 813
  { IMAGE_GATHER4H_V2_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 814
  { IMAGE_GATHER4H_V2_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 815
  { IMAGE_GATHER4H_V2_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 816
  { IMAGE_GATHER4H_V2_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 817
  { IMAGE_GATHER4H_V4_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 818
  { IMAGE_GATHER4H_V4_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 819
  { IMAGE_GATHER4H_V4_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 820
  { IMAGE_GATHER4H_V4_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 821
  { IMAGE_GATHER4H_V5_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 822
  { IMAGE_GATHER4H_V5_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 823
  { IMAGE_GATHER4H_V5_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 824
  { IMAGE_GATHER4H_V5_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 825
  { IMAGE_GATHER4H_V2_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 826
  { IMAGE_GATHER4H_V2_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 827
  { IMAGE_GATHER4H_V4_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 828
  { IMAGE_GATHER4H_V4_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 829
  { IMAGE_GATHER4H_V5_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 830
  { IMAGE_GATHER4H_V5_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 831
  { IMAGE_GATHER4H_V2_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 832
  { IMAGE_GATHER4H_V2_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 833
  { IMAGE_GATHER4H_V2_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 834
  { IMAGE_GATHER4H_V2_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 835
  { IMAGE_GATHER4H_V4_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 836
  { IMAGE_GATHER4H_V4_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 837
  { IMAGE_GATHER4H_V4_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 838
  { IMAGE_GATHER4H_V4_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 839
  { IMAGE_GATHER4H_V5_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 840
  { IMAGE_GATHER4H_V5_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 841
  { IMAGE_GATHER4H_V5_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 842
  { IMAGE_GATHER4H_V5_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 843
  { IMAGE_GATHER4H_V2_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 844
  { IMAGE_GATHER4H_V2_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 845
  { IMAGE_GATHER4H_V4_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 846
  { IMAGE_GATHER4H_V4_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 847
  { IMAGE_GATHER4H_V5_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 848
  { IMAGE_GATHER4H_V5_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 849
  { IMAGE_GATHER4H_V2_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 850
  { IMAGE_GATHER4H_V2_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 851
  { IMAGE_GATHER4H_V2_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 852
  { IMAGE_GATHER4H_V2_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 853
  { IMAGE_GATHER4H_V4_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 854
  { IMAGE_GATHER4H_V4_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 855
  { IMAGE_GATHER4H_V4_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 856
  { IMAGE_GATHER4H_V4_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 857
  { IMAGE_GATHER4H_V5_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 858
  { IMAGE_GATHER4H_V5_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 859
  { IMAGE_GATHER4H_V5_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 860
  { IMAGE_GATHER4H_V5_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 861
  { IMAGE_GATHER4_B_V2_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 862
  { IMAGE_GATHER4_B_V2_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 863
  { IMAGE_GATHER4_B_V2_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 864
  { IMAGE_GATHER4_B_V4_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 865
  { IMAGE_GATHER4_B_V4_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 866
  { IMAGE_GATHER4_B_V4_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 867
  { IMAGE_GATHER4_B_V5_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 868
  { IMAGE_GATHER4_B_V5_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 869
  { IMAGE_GATHER4_B_V5_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 870
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 871
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 872
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 873
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 874
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 875
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 876
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 877
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 878
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 879
  { IMAGE_GATHER4_B_V2_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 880
  { IMAGE_GATHER4_B_V2_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 881
  { IMAGE_GATHER4_B_V2_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 882
  { IMAGE_GATHER4_B_V4_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 883
  { IMAGE_GATHER4_B_V4_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 884
  { IMAGE_GATHER4_B_V4_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 885
  { IMAGE_GATHER4_B_V5_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 886
  { IMAGE_GATHER4_B_V5_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 887
  { IMAGE_GATHER4_B_V5_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 888
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 889
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 890
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 891
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 892
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 893
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 894
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 895
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 896
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 897
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 898
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 899
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 900
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 901
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 902
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 903
  { IMAGE_GATHER4_B_V5_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 904
  { IMAGE_GATHER4_B_V5_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 905
  { IMAGE_GATHER4_B_V5_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 906
  { IMAGE_GATHER4_B_CL_V2_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 907
  { IMAGE_GATHER4_B_CL_V2_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 908
  { IMAGE_GATHER4_B_CL_V2_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 909
  { IMAGE_GATHER4_B_CL_V2_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 910
  { IMAGE_GATHER4_B_CL_V2_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 911
  { IMAGE_GATHER4_B_CL_V4_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 912
  { IMAGE_GATHER4_B_CL_V4_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 913
  { IMAGE_GATHER4_B_CL_V4_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 914
  { IMAGE_GATHER4_B_CL_V4_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 915
  { IMAGE_GATHER4_B_CL_V4_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 916
  { IMAGE_GATHER4_B_CL_V5_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 917
  { IMAGE_GATHER4_B_CL_V5_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 918
  { IMAGE_GATHER4_B_CL_V5_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 919
  { IMAGE_GATHER4_B_CL_V5_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 920
  { IMAGE_GATHER4_B_CL_V5_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 921
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 922
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 923
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 924
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 925
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 926
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 927
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 928
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 929
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 930
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 931
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 932
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 933
  { IMAGE_GATHER4_B_CL_V2_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 934
  { IMAGE_GATHER4_B_CL_V2_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 935
  { IMAGE_GATHER4_B_CL_V2_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 936
  { IMAGE_GATHER4_B_CL_V2_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 937
  { IMAGE_GATHER4_B_CL_V2_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 938
  { IMAGE_GATHER4_B_CL_V4_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 939
  { IMAGE_GATHER4_B_CL_V4_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 940
  { IMAGE_GATHER4_B_CL_V4_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 941
  { IMAGE_GATHER4_B_CL_V4_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 942
  { IMAGE_GATHER4_B_CL_V4_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 943
  { IMAGE_GATHER4_B_CL_V5_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 944
  { IMAGE_GATHER4_B_CL_V5_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 945
  { IMAGE_GATHER4_B_CL_V5_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 946
  { IMAGE_GATHER4_B_CL_V5_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 947
  { IMAGE_GATHER4_B_CL_V5_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 948
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 949
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 950
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 951
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 952
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 953
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 954
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 955
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 956
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 957
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 958
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 959
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 960
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 961
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 962
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 963
  { IMAGE_GATHER4_B_CL_V2_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 964
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 965
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 966
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 967
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 968
  { IMAGE_GATHER4_B_CL_V4_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 969
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 970
  { IMAGE_GATHER4_B_CL_V5_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 971
  { IMAGE_GATHER4_B_CL_V5_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 972
  { IMAGE_GATHER4_B_CL_V5_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 973
  { IMAGE_GATHER4_B_CL_V5_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 974
  { IMAGE_GATHER4_B_CL_V5_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 975
  { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 976
  { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 977
  { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 978
  { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 979
  { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 980
  { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 981
  { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 982
  { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 983
  { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 984
  { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 985
  { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 986
  { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 987
  { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 988
  { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 989
  { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 990
  { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 991
  { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 992
  { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 993
  { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 994
  { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 995
  { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 996
  { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 997
  { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 998
  { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 999
  { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1000
  { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1001
  { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1002
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1003
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1004
  { IMAGE_GATHER4_B_CL_O_V2_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1005
  { IMAGE_GATHER4_B_CL_O_V2_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1006
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1007
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1008
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1009
  { IMAGE_GATHER4_B_CL_O_V4_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1010
  { IMAGE_GATHER4_B_CL_O_V4_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1011
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1012
  { IMAGE_GATHER4_B_CL_O_V5_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1013
  { IMAGE_GATHER4_B_CL_O_V5_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1014
  { IMAGE_GATHER4_B_CL_O_V5_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1015
  { IMAGE_GATHER4_B_CL_O_V5_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1016
  { IMAGE_GATHER4_B_CL_O_V5_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1017
  { IMAGE_GATHER4_B_O_V2_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1018
  { IMAGE_GATHER4_B_O_V2_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1019
  { IMAGE_GATHER4_B_O_V2_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1020
  { IMAGE_GATHER4_B_O_V2_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1021
  { IMAGE_GATHER4_B_O_V4_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1022
  { IMAGE_GATHER4_B_O_V4_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1023
  { IMAGE_GATHER4_B_O_V4_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1024
  { IMAGE_GATHER4_B_O_V4_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1025
  { IMAGE_GATHER4_B_O_V5_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1026
  { IMAGE_GATHER4_B_O_V5_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1027
  { IMAGE_GATHER4_B_O_V5_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1028
  { IMAGE_GATHER4_B_O_V5_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1029
  { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1030
  { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1031
  { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1032
  { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1033
  { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1034
  { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1035
  { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1036
  { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1037
  { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1038
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1039
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1040
  { IMAGE_GATHER4_B_O_V2_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1041
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1042
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1043
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1044
  { IMAGE_GATHER4_B_O_V4_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1045
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1046
  { IMAGE_GATHER4_B_O_V5_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1047
  { IMAGE_GATHER4_B_O_V5_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1048
  { IMAGE_GATHER4_B_O_V5_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1049
  { IMAGE_GATHER4_B_O_V5_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1050
  { IMAGE_GATHER4_C_V2_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1051
  { IMAGE_GATHER4_C_V2_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1052
  { IMAGE_GATHER4_C_V2_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1053
  { IMAGE_GATHER4_C_V4_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1054
  { IMAGE_GATHER4_C_V4_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1055
  { IMAGE_GATHER4_C_V4_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1056
  { IMAGE_GATHER4_C_V5_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1057
  { IMAGE_GATHER4_C_V5_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1058
  { IMAGE_GATHER4_C_V5_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1059
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1060
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1061
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1062
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1063
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1064
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1065
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1066
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1067
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1068
  { IMAGE_GATHER4_C_V2_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1069
  { IMAGE_GATHER4_C_V2_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1070
  { IMAGE_GATHER4_C_V2_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1071
  { IMAGE_GATHER4_C_V4_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1072
  { IMAGE_GATHER4_C_V4_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1073
  { IMAGE_GATHER4_C_V4_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1074
  { IMAGE_GATHER4_C_V5_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1075
  { IMAGE_GATHER4_C_V5_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1076
  { IMAGE_GATHER4_C_V5_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1077
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1078
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1079
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1080
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1081
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1082
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1083
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1084
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1085
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1086
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1087
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1088
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1089
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1090
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1091
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1092
  { IMAGE_GATHER4_C_V5_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1093
  { IMAGE_GATHER4_C_V5_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1094
  { IMAGE_GATHER4_C_V5_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1095
  { IMAGE_GATHER4_CL_V2_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1096
  { IMAGE_GATHER4_CL_V2_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1097
  { IMAGE_GATHER4_CL_V2_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1098
  { IMAGE_GATHER4_CL_V2_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1099
  { IMAGE_GATHER4_CL_V4_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1100
  { IMAGE_GATHER4_CL_V4_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1101
  { IMAGE_GATHER4_CL_V4_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1102
  { IMAGE_GATHER4_CL_V4_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1103
  { IMAGE_GATHER4_CL_V5_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1104
  { IMAGE_GATHER4_CL_V5_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1105
  { IMAGE_GATHER4_CL_V5_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1106
  { IMAGE_GATHER4_CL_V5_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1107
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1108
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1109
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1110
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1111
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1112
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1113
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1114
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1115
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1116
  { IMAGE_GATHER4_CL_V2_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1117
  { IMAGE_GATHER4_CL_V2_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1118
  { IMAGE_GATHER4_CL_V2_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1119
  { IMAGE_GATHER4_CL_V2_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1120
  { IMAGE_GATHER4_CL_V4_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1121
  { IMAGE_GATHER4_CL_V4_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1122
  { IMAGE_GATHER4_CL_V4_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1123
  { IMAGE_GATHER4_CL_V4_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1124
  { IMAGE_GATHER4_CL_V5_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1125
  { IMAGE_GATHER4_CL_V5_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1126
  { IMAGE_GATHER4_CL_V5_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1127
  { IMAGE_GATHER4_CL_V5_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1128
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1129
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1130
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1131
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1132
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1133
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1134
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1135
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1136
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1137
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1138
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1139
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1140
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1141
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1142
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1143
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1144
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1145
  { IMAGE_GATHER4_CL_V5_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1146
  { IMAGE_GATHER4_CL_V5_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1147
  { IMAGE_GATHER4_CL_V5_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1148
  { IMAGE_GATHER4_CL_V5_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1149
  { IMAGE_GATHER4_CL_O_V2_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1150
  { IMAGE_GATHER4_CL_O_V2_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1151
  { IMAGE_GATHER4_CL_O_V2_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1152
  { IMAGE_GATHER4_CL_O_V2_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1153
  { IMAGE_GATHER4_CL_O_V2_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1154
  { IMAGE_GATHER4_CL_O_V4_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1155
  { IMAGE_GATHER4_CL_O_V4_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1156
  { IMAGE_GATHER4_CL_O_V4_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1157
  { IMAGE_GATHER4_CL_O_V4_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1158
  { IMAGE_GATHER4_CL_O_V4_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1159
  { IMAGE_GATHER4_CL_O_V5_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1160
  { IMAGE_GATHER4_CL_O_V5_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1161
  { IMAGE_GATHER4_CL_O_V5_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1162
  { IMAGE_GATHER4_CL_O_V5_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1163
  { IMAGE_GATHER4_CL_O_V5_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1164
  { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1165
  { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1166
  { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1167
  { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1168
  { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1169
  { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1170
  { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1171
  { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1172
  { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1173
  { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1174
  { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1175
  { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1176
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1177
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1178
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1179
  { IMAGE_GATHER4_CL_O_V2_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1180
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1181
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1182
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1183
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1184
  { IMAGE_GATHER4_CL_O_V4_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1185
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1186
  { IMAGE_GATHER4_CL_O_V5_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1187
  { IMAGE_GATHER4_CL_O_V5_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1188
  { IMAGE_GATHER4_CL_O_V5_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1189
  { IMAGE_GATHER4_CL_O_V5_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1190
  { IMAGE_GATHER4_CL_O_V5_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1191
  { IMAGE_GATHER4_C_B_V2_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1192
  { IMAGE_GATHER4_C_B_V2_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1193
  { IMAGE_GATHER4_C_B_V2_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1194
  { IMAGE_GATHER4_C_B_V2_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1195
  { IMAGE_GATHER4_C_B_V4_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1196
  { IMAGE_GATHER4_C_B_V4_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1197
  { IMAGE_GATHER4_C_B_V4_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1198
  { IMAGE_GATHER4_C_B_V4_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1199
  { IMAGE_GATHER4_C_B_V5_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1200
  { IMAGE_GATHER4_C_B_V5_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1201
  { IMAGE_GATHER4_C_B_V5_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1202
  { IMAGE_GATHER4_C_B_V5_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1203
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1204
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1205
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1206
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1207
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1208
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1209
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1210
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1211
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1212
  { IMAGE_GATHER4_C_B_V2_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1213
  { IMAGE_GATHER4_C_B_V2_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1214
  { IMAGE_GATHER4_C_B_V2_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1215
  { IMAGE_GATHER4_C_B_V2_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1216
  { IMAGE_GATHER4_C_B_V4_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1217
  { IMAGE_GATHER4_C_B_V4_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1218
  { IMAGE_GATHER4_C_B_V4_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1219
  { IMAGE_GATHER4_C_B_V4_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1220
  { IMAGE_GATHER4_C_B_V5_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1221
  { IMAGE_GATHER4_C_B_V5_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1222
  { IMAGE_GATHER4_C_B_V5_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1223
  { IMAGE_GATHER4_C_B_V5_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1224
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1225
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1226
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1227
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1228
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1229
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1230
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1231
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1232
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1233
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1234
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1235
  { IMAGE_GATHER4_C_B_V2_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1236
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1237
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1238
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1239
  { IMAGE_GATHER4_C_B_V4_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1240
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1241
  { IMAGE_GATHER4_C_B_V5_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1242
  { IMAGE_GATHER4_C_B_V5_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1243
  { IMAGE_GATHER4_C_B_V5_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1244
  { IMAGE_GATHER4_C_B_V5_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1245
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1246
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1247
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1248
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1249
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1250
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1251
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1252
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1253
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1254
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1255
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1256
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1257
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1258
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1259
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1260
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1261
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1262
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1263
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1264
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1265
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1266
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1267
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1268
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1269
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1270
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1271
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1272
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1273
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1274
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1275
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 1276
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1277
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1278
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1279
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1280
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 1281
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1282
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1283
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1284
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1285
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 1286
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1287
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1288
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1289
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1290
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 1291
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1292
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1293
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1294
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 1295
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1296
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1297
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1298
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 1299
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1300
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1301
  { IMAGE_GATHER4_C_B_CL_V2_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1302
  { IMAGE_GATHER4_C_B_CL_V2_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1303
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1304
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1305
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1306
  { IMAGE_GATHER4_C_B_CL_V4_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1307
  { IMAGE_GATHER4_C_B_CL_V4_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1308
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1309
  { IMAGE_GATHER4_C_B_CL_V5_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1310
  { IMAGE_GATHER4_C_B_CL_V5_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1311
  { IMAGE_GATHER4_C_B_CL_V5_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1312
  { IMAGE_GATHER4_C_B_CL_V5_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1313
  { IMAGE_GATHER4_C_B_CL_V5_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1314
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1315
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1316
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1317
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 1318
  { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1319
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1320
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1321
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1322
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 1323
  { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1324
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1325
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1326
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1327
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 1328
  { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1329
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1330
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1331
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1332
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 1333
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1334
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1335
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1336
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 1337
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1338
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1339
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1340
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 1341
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1342
  { IMAGE_GATHER4_C_B_CL_O_V2_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1343
  { IMAGE_GATHER4_C_B_CL_O_V2_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1344
  { IMAGE_GATHER4_C_B_CL_O_V2_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 1345
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1346
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1347
  { IMAGE_GATHER4_C_B_CL_O_V4_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1348
  { IMAGE_GATHER4_C_B_CL_O_V4_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1349
  { IMAGE_GATHER4_C_B_CL_O_V4_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 1350
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1351
  { IMAGE_GATHER4_C_B_CL_O_V5_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1352
  { IMAGE_GATHER4_C_B_CL_O_V5_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1353
  { IMAGE_GATHER4_C_B_CL_O_V5_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1354
  { IMAGE_GATHER4_C_B_CL_O_V5_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 1355
  { IMAGE_GATHER4_C_B_CL_O_V5_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1356
  { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1357
  { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1358
  { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1359
  { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1360
  { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1361
  { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1362
  { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1363
  { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1364
  { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1365
  { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1366
  { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1367
  { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1368
  { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1369
  { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1370
  { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1371
  { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1372
  { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1373
  { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1374
  { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1375
  { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1376
  { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1377
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1378
  { IMAGE_GATHER4_C_B_O_V2_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1379
  { IMAGE_GATHER4_C_B_O_V2_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1380
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1381
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1382
  { IMAGE_GATHER4_C_B_O_V4_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1383
  { IMAGE_GATHER4_C_B_O_V4_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1384
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1385
  { IMAGE_GATHER4_C_B_O_V5_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1386
  { IMAGE_GATHER4_C_B_O_V5_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1387
  { IMAGE_GATHER4_C_B_O_V5_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1388
  { IMAGE_GATHER4_C_B_O_V5_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1389
  { IMAGE_GATHER4_C_CL_V2_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1390
  { IMAGE_GATHER4_C_CL_V2_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1391
  { IMAGE_GATHER4_C_CL_V2_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1392
  { IMAGE_GATHER4_C_CL_V2_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1393
  { IMAGE_GATHER4_C_CL_V2_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1394
  { IMAGE_GATHER4_C_CL_V4_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1395
  { IMAGE_GATHER4_C_CL_V4_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1396
  { IMAGE_GATHER4_C_CL_V4_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1397
  { IMAGE_GATHER4_C_CL_V4_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1398
  { IMAGE_GATHER4_C_CL_V4_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1399
  { IMAGE_GATHER4_C_CL_V5_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1400
  { IMAGE_GATHER4_C_CL_V5_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1401
  { IMAGE_GATHER4_C_CL_V5_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1402
  { IMAGE_GATHER4_C_CL_V5_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1403
  { IMAGE_GATHER4_C_CL_V5_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1404
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1405
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1406
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1407
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1408
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1409
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1410
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1411
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1412
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1413
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1414
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1415
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1416
  { IMAGE_GATHER4_C_CL_V2_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1417
  { IMAGE_GATHER4_C_CL_V2_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1418
  { IMAGE_GATHER4_C_CL_V2_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1419
  { IMAGE_GATHER4_C_CL_V2_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1420
  { IMAGE_GATHER4_C_CL_V2_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1421
  { IMAGE_GATHER4_C_CL_V4_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1422
  { IMAGE_GATHER4_C_CL_V4_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1423
  { IMAGE_GATHER4_C_CL_V4_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1424
  { IMAGE_GATHER4_C_CL_V4_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1425
  { IMAGE_GATHER4_C_CL_V4_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1426
  { IMAGE_GATHER4_C_CL_V5_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1427
  { IMAGE_GATHER4_C_CL_V5_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1428
  { IMAGE_GATHER4_C_CL_V5_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1429
  { IMAGE_GATHER4_C_CL_V5_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1430
  { IMAGE_GATHER4_C_CL_V5_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1431
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1432
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1433
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1434
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1435
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1436
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1437
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1438
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1439
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1440
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1441
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1442
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1443
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1444
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1445
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1446
  { IMAGE_GATHER4_C_CL_V2_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1447
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1448
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1449
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1450
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1451
  { IMAGE_GATHER4_C_CL_V4_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1452
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1453
  { IMAGE_GATHER4_C_CL_V5_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1454
  { IMAGE_GATHER4_C_CL_V5_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1455
  { IMAGE_GATHER4_C_CL_V5_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1456
  { IMAGE_GATHER4_C_CL_V5_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1457
  { IMAGE_GATHER4_C_CL_V5_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1458
  { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1459
  { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1460
  { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1461
  { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1462
  { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1463
  { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1464
  { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1465
  { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1466
  { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1467
  { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1468
  { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1469
  { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1470
  { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1471
  { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1472
  { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1473
  { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1474
  { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1475
  { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1476
  { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1477
  { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1478
  { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1479
  { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1480
  { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1481
  { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1482
  { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1483
  { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1484
  { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1485
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1486
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1487
  { IMAGE_GATHER4_C_CL_O_V2_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1488
  { IMAGE_GATHER4_C_CL_O_V2_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1489
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1490
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1491
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1492
  { IMAGE_GATHER4_C_CL_O_V4_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1493
  { IMAGE_GATHER4_C_CL_O_V4_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1494
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1495
  { IMAGE_GATHER4_C_CL_O_V5_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1496
  { IMAGE_GATHER4_C_CL_O_V5_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1497
  { IMAGE_GATHER4_C_CL_O_V5_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1498
  { IMAGE_GATHER4_C_CL_O_V5_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1499
  { IMAGE_GATHER4_C_CL_O_V5_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1500
  { IMAGE_GATHER4_C_L_V2_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1501
  { IMAGE_GATHER4_C_L_V2_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1502
  { IMAGE_GATHER4_C_L_V2_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1503
  { IMAGE_GATHER4_C_L_V2_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1504
  { IMAGE_GATHER4_C_L_V2_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1505
  { IMAGE_GATHER4_C_L_V4_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1506
  { IMAGE_GATHER4_C_L_V4_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1507
  { IMAGE_GATHER4_C_L_V4_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1508
  { IMAGE_GATHER4_C_L_V4_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1509
  { IMAGE_GATHER4_C_L_V4_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1510
  { IMAGE_GATHER4_C_L_V5_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1511
  { IMAGE_GATHER4_C_L_V5_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1512
  { IMAGE_GATHER4_C_L_V5_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1513
  { IMAGE_GATHER4_C_L_V5_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1514
  { IMAGE_GATHER4_C_L_V5_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1515
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1516
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1517
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1518
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1519
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1520
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1521
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1522
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1523
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1524
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1525
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1526
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1527
  { IMAGE_GATHER4_C_L_V2_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1528
  { IMAGE_GATHER4_C_L_V2_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1529
  { IMAGE_GATHER4_C_L_V2_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1530
  { IMAGE_GATHER4_C_L_V2_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1531
  { IMAGE_GATHER4_C_L_V2_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1532
  { IMAGE_GATHER4_C_L_V4_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1533
  { IMAGE_GATHER4_C_L_V4_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1534
  { IMAGE_GATHER4_C_L_V4_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1535
  { IMAGE_GATHER4_C_L_V4_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1536
  { IMAGE_GATHER4_C_L_V4_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1537
  { IMAGE_GATHER4_C_L_V5_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1538
  { IMAGE_GATHER4_C_L_V5_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1539
  { IMAGE_GATHER4_C_L_V5_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1540
  { IMAGE_GATHER4_C_L_V5_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1541
  { IMAGE_GATHER4_C_L_V5_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1542
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1543
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1544
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1545
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1546
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1547
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1548
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1549
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1550
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1551
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1552
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1553
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1554
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1555
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1556
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1557
  { IMAGE_GATHER4_C_L_V2_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1558
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1559
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1560
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1561
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1562
  { IMAGE_GATHER4_C_L_V4_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1563
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1564
  { IMAGE_GATHER4_C_L_V5_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1565
  { IMAGE_GATHER4_C_L_V5_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1566
  { IMAGE_GATHER4_C_L_V5_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1567
  { IMAGE_GATHER4_C_L_V5_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1568
  { IMAGE_GATHER4_C_L_V5_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1569
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1570
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1571
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1572
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1573
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1574
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1575
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1576
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1577
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1578
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1579
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1580
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1581
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1582
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1583
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1584
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1585
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1586
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1587
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1588
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1589
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1590
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1591
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1592
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1593
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1594
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1595
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1596
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1597
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1598
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1599
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1600
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1601
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1602
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1603
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1604
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1605
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1606
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1607
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1608
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1609
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1610
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1611
  { IMAGE_GATHER4_C_LZ_V5_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1612
  { IMAGE_GATHER4_C_LZ_V5_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1613
  { IMAGE_GATHER4_C_LZ_V5_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1614
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1615
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1616
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1617
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1618
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1619
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1620
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1621
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1622
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1623
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1624
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1625
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1626
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1627
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1628
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1629
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1630
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1631
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1632
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1633
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1634
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1635
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1636
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1637
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1638
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1639
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1640
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1641
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1642
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1643
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1644
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1645
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1646
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1647
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1648
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1649
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1650
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1651
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1652
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1653
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1654
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1655
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1656
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1657
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1658
  { IMAGE_GATHER4_C_LZ_O_V2_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1659
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1660
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1661
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1662
  { IMAGE_GATHER4_C_LZ_O_V4_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1663
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1664
  { IMAGE_GATHER4_C_LZ_O_V5_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1665
  { IMAGE_GATHER4_C_LZ_O_V5_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1666
  { IMAGE_GATHER4_C_LZ_O_V5_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1667
  { IMAGE_GATHER4_C_LZ_O_V5_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1668
  { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1669
  { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1670
  { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1671
  { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1672
  { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1673
  { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1674
  { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1675
  { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1676
  { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1677
  { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1678
  { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1679
  { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1680
  { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1681
  { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1682
  { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1683
  { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1684
  { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1685
  { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1686
  { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1687
  { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1688
  { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1689
  { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1690
  { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1691
  { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1692
  { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1693
  { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1694
  { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1695
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1696
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1697
  { IMAGE_GATHER4_C_L_O_V2_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1698
  { IMAGE_GATHER4_C_L_O_V2_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1699
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1700
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1701
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1702
  { IMAGE_GATHER4_C_L_O_V4_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1703
  { IMAGE_GATHER4_C_L_O_V4_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1704
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1705
  { IMAGE_GATHER4_C_L_O_V5_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1706
  { IMAGE_GATHER4_C_L_O_V5_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1707
  { IMAGE_GATHER4_C_L_O_V5_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1708
  { IMAGE_GATHER4_C_L_O_V5_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1709
  { IMAGE_GATHER4_C_L_O_V5_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1710
  { IMAGE_GATHER4_C_O_V2_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1711
  { IMAGE_GATHER4_C_O_V2_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1712
  { IMAGE_GATHER4_C_O_V2_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1713
  { IMAGE_GATHER4_C_O_V2_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1714
  { IMAGE_GATHER4_C_O_V4_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1715
  { IMAGE_GATHER4_C_O_V4_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1716
  { IMAGE_GATHER4_C_O_V4_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1717
  { IMAGE_GATHER4_C_O_V4_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1718
  { IMAGE_GATHER4_C_O_V5_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1719
  { IMAGE_GATHER4_C_O_V5_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1720
  { IMAGE_GATHER4_C_O_V5_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1721
  { IMAGE_GATHER4_C_O_V5_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1722
  { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1723
  { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1724
  { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1725
  { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1726
  { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1727
  { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1728
  { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1729
  { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1730
  { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1731
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1732
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1733
  { IMAGE_GATHER4_C_O_V2_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1734
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1735
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1736
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1737
  { IMAGE_GATHER4_C_O_V4_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1738
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1739
  { IMAGE_GATHER4_C_O_V5_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1740
  { IMAGE_GATHER4_C_O_V5_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1741
  { IMAGE_GATHER4_C_O_V5_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1742
  { IMAGE_GATHER4_C_O_V5_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1743
  { IMAGE_GATHER4_L_V2_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1744
  { IMAGE_GATHER4_L_V2_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1745
  { IMAGE_GATHER4_L_V2_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1746
  { IMAGE_GATHER4_L_V2_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1747
  { IMAGE_GATHER4_L_V4_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1748
  { IMAGE_GATHER4_L_V4_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1749
  { IMAGE_GATHER4_L_V4_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1750
  { IMAGE_GATHER4_L_V4_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1751
  { IMAGE_GATHER4_L_V5_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1752
  { IMAGE_GATHER4_L_V5_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1753
  { IMAGE_GATHER4_L_V5_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1754
  { IMAGE_GATHER4_L_V5_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1755
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1756
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1757
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1758
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1759
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1760
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1761
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1762
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1763
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1764
  { IMAGE_GATHER4_L_V2_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1765
  { IMAGE_GATHER4_L_V2_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1766
  { IMAGE_GATHER4_L_V2_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1767
  { IMAGE_GATHER4_L_V2_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1768
  { IMAGE_GATHER4_L_V4_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1769
  { IMAGE_GATHER4_L_V4_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1770
  { IMAGE_GATHER4_L_V4_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1771
  { IMAGE_GATHER4_L_V4_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1772
  { IMAGE_GATHER4_L_V5_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1773
  { IMAGE_GATHER4_L_V5_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1774
  { IMAGE_GATHER4_L_V5_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1775
  { IMAGE_GATHER4_L_V5_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1776
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1777
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1778
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1779
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1780
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1781
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1782
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1783
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1784
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1785
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1786
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1787
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1788
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1789
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1790
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1791
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1792
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1793
  { IMAGE_GATHER4_L_V5_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1794
  { IMAGE_GATHER4_L_V5_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1795
  { IMAGE_GATHER4_L_V5_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1796
  { IMAGE_GATHER4_L_V5_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1797
  { IMAGE_GATHER4_LZ_V2_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1798
  { IMAGE_GATHER4_LZ_V2_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1799
  { IMAGE_GATHER4_LZ_V2_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1800
  { IMAGE_GATHER4_LZ_V2_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1801
  { IMAGE_GATHER4_LZ_V4_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1802
  { IMAGE_GATHER4_LZ_V4_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1803
  { IMAGE_GATHER4_LZ_V4_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1804
  { IMAGE_GATHER4_LZ_V4_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1805
  { IMAGE_GATHER4_LZ_V5_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1806
  { IMAGE_GATHER4_LZ_V5_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1807
  { IMAGE_GATHER4_LZ_V5_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1808
  { IMAGE_GATHER4_LZ_V5_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1809
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1810
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1811
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1812
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1813
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1814
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1815
  { IMAGE_GATHER4_LZ_V2_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1816
  { IMAGE_GATHER4_LZ_V2_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1817
  { IMAGE_GATHER4_LZ_V2_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1818
  { IMAGE_GATHER4_LZ_V2_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1819
  { IMAGE_GATHER4_LZ_V4_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1820
  { IMAGE_GATHER4_LZ_V4_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1821
  { IMAGE_GATHER4_LZ_V4_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1822
  { IMAGE_GATHER4_LZ_V4_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1823
  { IMAGE_GATHER4_LZ_V5_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1824
  { IMAGE_GATHER4_LZ_V5_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1825
  { IMAGE_GATHER4_LZ_V5_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1826
  { IMAGE_GATHER4_LZ_V5_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1827
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1828
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1829
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1830
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1831
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1832
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1833
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1834
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1835
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1836
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1837
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1838
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1839
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1840
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1841
  { IMAGE_GATHER4_LZ_V5_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1842
  { IMAGE_GATHER4_LZ_V5_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1843
  { IMAGE_GATHER4_LZ_V5_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1844
  { IMAGE_GATHER4_LZ_V5_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1845
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1846
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1847
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1848
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1849
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1850
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1851
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1852
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1853
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1854
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1855
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1856
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1857
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1858
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1859
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1860
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1861
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1862
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1863
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1864
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1865
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1866
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1867
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1868
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1869
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1870
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1871
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1872
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1873
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1874
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1875
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1876
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1877
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1878
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1879
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1880
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1881
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1882
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1883
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1884
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1885
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1886
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1887
  { IMAGE_GATHER4_LZ_O_V5_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1888
  { IMAGE_GATHER4_LZ_O_V5_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1889
  { IMAGE_GATHER4_LZ_O_V5_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1890
  { IMAGE_GATHER4_L_O_V2_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1891
  { IMAGE_GATHER4_L_O_V2_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1892
  { IMAGE_GATHER4_L_O_V2_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1893
  { IMAGE_GATHER4_L_O_V2_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1894
  { IMAGE_GATHER4_L_O_V2_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1895
  { IMAGE_GATHER4_L_O_V4_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1896
  { IMAGE_GATHER4_L_O_V4_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1897
  { IMAGE_GATHER4_L_O_V4_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1898
  { IMAGE_GATHER4_L_O_V4_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1899
  { IMAGE_GATHER4_L_O_V4_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1900
  { IMAGE_GATHER4_L_O_V5_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1901
  { IMAGE_GATHER4_L_O_V5_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1902
  { IMAGE_GATHER4_L_O_V5_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1903
  { IMAGE_GATHER4_L_O_V5_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1904
  { IMAGE_GATHER4_L_O_V5_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1905
  { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1906
  { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1907
  { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1908
  { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1909
  { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1910
  { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1911
  { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1912
  { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1913
  { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1914
  { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1915
  { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1916
  { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1917
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1918
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1919
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1920
  { IMAGE_GATHER4_L_O_V2_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1921
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1922
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1923
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1924
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1925
  { IMAGE_GATHER4_L_O_V4_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1926
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1927
  { IMAGE_GATHER4_L_O_V5_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1928
  { IMAGE_GATHER4_L_O_V5_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1929
  { IMAGE_GATHER4_L_O_V5_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1930
  { IMAGE_GATHER4_L_O_V5_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1931
  { IMAGE_GATHER4_L_O_V5_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1932
  { IMAGE_GATHER4_O_V2_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1933
  { IMAGE_GATHER4_O_V2_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1934
  { IMAGE_GATHER4_O_V2_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1935
  { IMAGE_GATHER4_O_V4_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1936
  { IMAGE_GATHER4_O_V4_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1937
  { IMAGE_GATHER4_O_V4_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1938
  { IMAGE_GATHER4_O_V5_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1939
  { IMAGE_GATHER4_O_V5_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1940
  { IMAGE_GATHER4_O_V5_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1941
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1942
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1943
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1944
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1945
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1946
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1947
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1948
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1949
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1950
  { IMAGE_GATHER4_O_V2_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1951
  { IMAGE_GATHER4_O_V2_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1952
  { IMAGE_GATHER4_O_V2_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1953
  { IMAGE_GATHER4_O_V4_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1954
  { IMAGE_GATHER4_O_V4_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1955
  { IMAGE_GATHER4_O_V4_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1956
  { IMAGE_GATHER4_O_V5_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1957
  { IMAGE_GATHER4_O_V5_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1958
  { IMAGE_GATHER4_O_V5_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1959
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1960
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1961
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1962
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1963
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1964
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1965
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1966
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1967
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1968
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1969
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1970
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1971
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1972
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1973
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1974
  { IMAGE_GATHER4_O_V5_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1975
  { IMAGE_GATHER4_O_V5_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1976
  { IMAGE_GATHER4_O_V5_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1977
  { IMAGE_GET_LOD_V1_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1978
  { IMAGE_GET_LOD_V1_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1979
  { IMAGE_GET_LOD_V1_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1980
  { IMAGE_GET_LOD_V1_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1981
  { IMAGE_GET_LOD_V2_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1982
  { IMAGE_GET_LOD_V2_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1983
  { IMAGE_GET_LOD_V2_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1984
  { IMAGE_GET_LOD_V2_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1985
  { IMAGE_GET_LOD_V3_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 1986
  { IMAGE_GET_LOD_V3_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 1987
  { IMAGE_GET_LOD_V3_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 1988
  { IMAGE_GET_LOD_V3_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 1989
  { IMAGE_GET_LOD_V4_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1990
  { IMAGE_GET_LOD_V4_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1991
  { IMAGE_GET_LOD_V4_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1992
  { IMAGE_GET_LOD_V4_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1993
  { IMAGE_GET_LOD_V5_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1994
  { IMAGE_GET_LOD_V5_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1995
  { IMAGE_GET_LOD_V5_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1996
  { IMAGE_GET_LOD_V5_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1997
  { IMAGE_GET_LOD_V1_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1998
  { IMAGE_GET_LOD_V1_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1999
  { IMAGE_GET_LOD_V2_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2000
  { IMAGE_GET_LOD_V2_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2001
  { IMAGE_GET_LOD_V3_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2002
  { IMAGE_GET_LOD_V3_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2003
  { IMAGE_GET_LOD_V4_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2004
  { IMAGE_GET_LOD_V4_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2005
  { IMAGE_GET_LOD_V5_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2006
  { IMAGE_GET_LOD_V5_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2007
  { IMAGE_GET_LOD_V1_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2008
  { IMAGE_GET_LOD_V1_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2009
  { IMAGE_GET_LOD_V1_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2010
  { IMAGE_GET_LOD_V1_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2011
  { IMAGE_GET_LOD_V2_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2012
  { IMAGE_GET_LOD_V2_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2013
  { IMAGE_GET_LOD_V2_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2014
  { IMAGE_GET_LOD_V2_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2015
  { IMAGE_GET_LOD_V3_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2016
  { IMAGE_GET_LOD_V3_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2017
  { IMAGE_GET_LOD_V3_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2018
  { IMAGE_GET_LOD_V3_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2019
  { IMAGE_GET_LOD_V4_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2020
  { IMAGE_GET_LOD_V4_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2021
  { IMAGE_GET_LOD_V4_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2022
  { IMAGE_GET_LOD_V4_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2023
  { IMAGE_GET_LOD_V5_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2024
  { IMAGE_GET_LOD_V5_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2025
  { IMAGE_GET_LOD_V5_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2026
  { IMAGE_GET_LOD_V5_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2027
  { IMAGE_GET_LOD_V1_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2028
  { IMAGE_GET_LOD_V1_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2029
  { IMAGE_GET_LOD_V2_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2030
  { IMAGE_GET_LOD_V2_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2031
  { IMAGE_GET_LOD_V3_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2032
  { IMAGE_GET_LOD_V3_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2033
  { IMAGE_GET_LOD_V4_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2034
  { IMAGE_GET_LOD_V4_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2035
  { IMAGE_GET_LOD_V5_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2036
  { IMAGE_GET_LOD_V5_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2037
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2038
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2039
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2040
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2041
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2042
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2043
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2044
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2045
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2046
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2047
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2048
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2049
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2050
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2051
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2052
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2053
  { IMAGE_GET_LOD_V5_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2054
  { IMAGE_GET_LOD_V5_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2055
  { IMAGE_GET_LOD_V5_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2056
  { IMAGE_GET_LOD_V5_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2057
  { IMAGE_GET_LOD_V1_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2058
  { IMAGE_GET_LOD_V1_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2059
  { IMAGE_GET_LOD_V1_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2060
  { IMAGE_GET_LOD_V1_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2061
  { IMAGE_GET_LOD_V2_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2062
  { IMAGE_GET_LOD_V2_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2063
  { IMAGE_GET_LOD_V2_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2064
  { IMAGE_GET_LOD_V2_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2065
  { IMAGE_GET_LOD_V3_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2066
  { IMAGE_GET_LOD_V3_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2067
  { IMAGE_GET_LOD_V3_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2068
  { IMAGE_GET_LOD_V3_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2069
  { IMAGE_GET_LOD_V4_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2070
  { IMAGE_GET_LOD_V4_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2071
  { IMAGE_GET_LOD_V4_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2072
  { IMAGE_GET_LOD_V4_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2073
  { IMAGE_GET_LOD_V5_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2074
  { IMAGE_GET_LOD_V5_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2075
  { IMAGE_GET_LOD_V5_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2076
  { IMAGE_GET_LOD_V5_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2077
  { IMAGE_GET_RESINFO_V1_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2078
  { IMAGE_GET_RESINFO_V1_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2079
  { IMAGE_GET_RESINFO_V1_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2080
  { IMAGE_GET_RESINFO_V1_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2081
  { IMAGE_GET_RESINFO_V2_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2082
  { IMAGE_GET_RESINFO_V2_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2083
  { IMAGE_GET_RESINFO_V2_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2084
  { IMAGE_GET_RESINFO_V2_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2085
  { IMAGE_GET_RESINFO_V3_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2086
  { IMAGE_GET_RESINFO_V3_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2087
  { IMAGE_GET_RESINFO_V3_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2088
  { IMAGE_GET_RESINFO_V3_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2089
  { IMAGE_GET_RESINFO_V4_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2090
  { IMAGE_GET_RESINFO_V4_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2091
  { IMAGE_GET_RESINFO_V4_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2092
  { IMAGE_GET_RESINFO_V4_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2093
  { IMAGE_GET_RESINFO_V5_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2094
  { IMAGE_GET_RESINFO_V5_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2095
  { IMAGE_GET_RESINFO_V5_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2096
  { IMAGE_GET_RESINFO_V5_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2097
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2098
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2099
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2100
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2101
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2102
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2103
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2104
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2105
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2106
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2107
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2108
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2109
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2110
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2111
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2112
  { IMAGE_GET_RESINFO_V1_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2113
  { IMAGE_GET_RESINFO_V1_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2114
  { IMAGE_GET_RESINFO_V1_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2115
  { IMAGE_GET_RESINFO_V1_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2116
  { IMAGE_GET_RESINFO_V2_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2117
  { IMAGE_GET_RESINFO_V2_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2118
  { IMAGE_GET_RESINFO_V2_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2119
  { IMAGE_GET_RESINFO_V2_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2120
  { IMAGE_GET_RESINFO_V3_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2121
  { IMAGE_GET_RESINFO_V3_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2122
  { IMAGE_GET_RESINFO_V3_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2123
  { IMAGE_GET_RESINFO_V3_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2124
  { IMAGE_GET_RESINFO_V4_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2125
  { IMAGE_GET_RESINFO_V4_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2126
  { IMAGE_GET_RESINFO_V4_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2127
  { IMAGE_GET_RESINFO_V4_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2128
  { IMAGE_GET_RESINFO_V5_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2129
  { IMAGE_GET_RESINFO_V5_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2130
  { IMAGE_GET_RESINFO_V5_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2131
  { IMAGE_GET_RESINFO_V5_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2132
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2133
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2134
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2135
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2136
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2137
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2138
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2139
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2140
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2141
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2142
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2143
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2144
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2145
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2146
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2147
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2148
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2149
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2150
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2151
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2152
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2153
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2154
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2155
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2156
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2157
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2158
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2159
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2160
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2161
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2162
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2163
  { IMAGE_GET_RESINFO_V5_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2164
  { IMAGE_GET_RESINFO_V5_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2165
  { IMAGE_GET_RESINFO_V5_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2166
  { IMAGE_GET_RESINFO_V5_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2167
  { IMAGE_GET_RESINFO_V1_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2168
  { IMAGE_GET_RESINFO_V1_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2169
  { IMAGE_GET_RESINFO_V1_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2170
  { IMAGE_GET_RESINFO_V1_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2171
  { IMAGE_GET_RESINFO_V2_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2172
  { IMAGE_GET_RESINFO_V2_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2173
  { IMAGE_GET_RESINFO_V2_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2174
  { IMAGE_GET_RESINFO_V2_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2175
  { IMAGE_GET_RESINFO_V3_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2176
  { IMAGE_GET_RESINFO_V3_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2177
  { IMAGE_GET_RESINFO_V3_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2178
  { IMAGE_GET_RESINFO_V3_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2179
  { IMAGE_GET_RESINFO_V4_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2180
  { IMAGE_GET_RESINFO_V4_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2181
  { IMAGE_GET_RESINFO_V4_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2182
  { IMAGE_GET_RESINFO_V4_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2183
  { IMAGE_GET_RESINFO_V5_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2184
  { IMAGE_GET_RESINFO_V5_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2185
  { IMAGE_GET_RESINFO_V5_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2186
  { IMAGE_GET_RESINFO_V5_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2187
  { IMAGE_LOAD_V1_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2188
  { IMAGE_LOAD_V1_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2189
  { IMAGE_LOAD_V1_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2190
  { IMAGE_LOAD_V1_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2191
  { IMAGE_LOAD_V2_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2192
  { IMAGE_LOAD_V2_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2193
  { IMAGE_LOAD_V2_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2194
  { IMAGE_LOAD_V2_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2195
  { IMAGE_LOAD_V3_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2196
  { IMAGE_LOAD_V3_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2197
  { IMAGE_LOAD_V3_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2198
  { IMAGE_LOAD_V3_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2199
  { IMAGE_LOAD_V4_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2200
  { IMAGE_LOAD_V4_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2201
  { IMAGE_LOAD_V4_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2202
  { IMAGE_LOAD_V4_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2203
  { IMAGE_LOAD_V5_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2204
  { IMAGE_LOAD_V5_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2205
  { IMAGE_LOAD_V5_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2206
  { IMAGE_LOAD_V5_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2207
  { IMAGE_LOAD_V1_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2208
  { IMAGE_LOAD_V1_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2209
  { IMAGE_LOAD_V1_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2210
  { IMAGE_LOAD_V2_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2211
  { IMAGE_LOAD_V2_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2212
  { IMAGE_LOAD_V2_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2213
  { IMAGE_LOAD_V3_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2214
  { IMAGE_LOAD_V3_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2215
  { IMAGE_LOAD_V3_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2216
  { IMAGE_LOAD_V4_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2217
  { IMAGE_LOAD_V4_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2218
  { IMAGE_LOAD_V4_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2219
  { IMAGE_LOAD_V5_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2220
  { IMAGE_LOAD_V5_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2221
  { IMAGE_LOAD_V5_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2222
  { IMAGE_LOAD_V1_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2223
  { IMAGE_LOAD_V1_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2224
  { IMAGE_LOAD_V1_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2225
  { IMAGE_LOAD_V1_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2226
  { IMAGE_LOAD_V2_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2227
  { IMAGE_LOAD_V2_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2228
  { IMAGE_LOAD_V2_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2229
  { IMAGE_LOAD_V2_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2230
  { IMAGE_LOAD_V3_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2231
  { IMAGE_LOAD_V3_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2232
  { IMAGE_LOAD_V3_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2233
  { IMAGE_LOAD_V3_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2234
  { IMAGE_LOAD_V4_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2235
  { IMAGE_LOAD_V4_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2236
  { IMAGE_LOAD_V4_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2237
  { IMAGE_LOAD_V4_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2238
  { IMAGE_LOAD_V5_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2239
  { IMAGE_LOAD_V5_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2240
  { IMAGE_LOAD_V5_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2241
  { IMAGE_LOAD_V5_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2242
  { IMAGE_LOAD_V1_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2243
  { IMAGE_LOAD_V1_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2244
  { IMAGE_LOAD_V1_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2245
  { IMAGE_LOAD_V2_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2246
  { IMAGE_LOAD_V2_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2247
  { IMAGE_LOAD_V2_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2248
  { IMAGE_LOAD_V3_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2249
  { IMAGE_LOAD_V3_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2250
  { IMAGE_LOAD_V3_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2251
  { IMAGE_LOAD_V4_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2252
  { IMAGE_LOAD_V4_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2253
  { IMAGE_LOAD_V4_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2254
  { IMAGE_LOAD_V5_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2255
  { IMAGE_LOAD_V5_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2256
  { IMAGE_LOAD_V5_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2257
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2258
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2259
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2260
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2261
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2262
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2263
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2264
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2265
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2266
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2267
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2268
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2269
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2270
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2271
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2272
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2273
  { IMAGE_LOAD_V5_V1, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2274
  { IMAGE_LOAD_V5_V2, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2275
  { IMAGE_LOAD_V5_V3, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2276
  { IMAGE_LOAD_V5_V4, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2277
  { IMAGE_LOAD_V1_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2278
  { IMAGE_LOAD_V1_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2279
  { IMAGE_LOAD_V1_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2280
  { IMAGE_LOAD_V1_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2281
  { IMAGE_LOAD_V2_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2282
  { IMAGE_LOAD_V2_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2283
  { IMAGE_LOAD_V2_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2284
  { IMAGE_LOAD_V2_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2285
  { IMAGE_LOAD_V3_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2286
  { IMAGE_LOAD_V3_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2287
  { IMAGE_LOAD_V3_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2288
  { IMAGE_LOAD_V3_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2289
  { IMAGE_LOAD_V4_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2290
  { IMAGE_LOAD_V4_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2291
  { IMAGE_LOAD_V4_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2292
  { IMAGE_LOAD_V4_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2293
  { IMAGE_LOAD_V5_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2294
  { IMAGE_LOAD_V5_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2295
  { IMAGE_LOAD_V5_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2296
  { IMAGE_LOAD_V5_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2297
  { IMAGE_LOAD_MIP_V1_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2298
  { IMAGE_LOAD_MIP_V1_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2299
  { IMAGE_LOAD_MIP_V1_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2300
  { IMAGE_LOAD_MIP_V1_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2301
  { IMAGE_LOAD_MIP_V2_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2302
  { IMAGE_LOAD_MIP_V2_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2303
  { IMAGE_LOAD_MIP_V2_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2304
  { IMAGE_LOAD_MIP_V2_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2305
  { IMAGE_LOAD_MIP_V3_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2306
  { IMAGE_LOAD_MIP_V3_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2307
  { IMAGE_LOAD_MIP_V3_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2308
  { IMAGE_LOAD_MIP_V3_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2309
  { IMAGE_LOAD_MIP_V4_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2310
  { IMAGE_LOAD_MIP_V4_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2311
  { IMAGE_LOAD_MIP_V4_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2312
  { IMAGE_LOAD_MIP_V4_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2313
  { IMAGE_LOAD_MIP_V5_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2314
  { IMAGE_LOAD_MIP_V5_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2315
  { IMAGE_LOAD_MIP_V5_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2316
  { IMAGE_LOAD_MIP_V5_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2317
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2318
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2319
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2320
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2321
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2322
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2323
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2324
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2325
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2326
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2327
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2328
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2329
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2330
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2331
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2332
  { IMAGE_LOAD_MIP_V1_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2333
  { IMAGE_LOAD_MIP_V1_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2334
  { IMAGE_LOAD_MIP_V1_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2335
  { IMAGE_LOAD_MIP_V1_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2336
  { IMAGE_LOAD_MIP_V2_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2337
  { IMAGE_LOAD_MIP_V2_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2338
  { IMAGE_LOAD_MIP_V2_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2339
  { IMAGE_LOAD_MIP_V2_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2340
  { IMAGE_LOAD_MIP_V3_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2341
  { IMAGE_LOAD_MIP_V3_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2342
  { IMAGE_LOAD_MIP_V3_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2343
  { IMAGE_LOAD_MIP_V3_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2344
  { IMAGE_LOAD_MIP_V4_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2345
  { IMAGE_LOAD_MIP_V4_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2346
  { IMAGE_LOAD_MIP_V4_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2347
  { IMAGE_LOAD_MIP_V4_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2348
  { IMAGE_LOAD_MIP_V5_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2349
  { IMAGE_LOAD_MIP_V5_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2350
  { IMAGE_LOAD_MIP_V5_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2351
  { IMAGE_LOAD_MIP_V5_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2352
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2353
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2354
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2355
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2356
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2357
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2358
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2359
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2360
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2361
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2362
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2363
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2364
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2365
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2366
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2367
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2368
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2369
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2370
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2371
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2372
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2373
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2374
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2375
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2376
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2377
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2378
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2379
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2380
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2381
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2382
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2383
  { IMAGE_LOAD_MIP_V5_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2384
  { IMAGE_LOAD_MIP_V5_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2385
  { IMAGE_LOAD_MIP_V5_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2386
  { IMAGE_LOAD_MIP_V5_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2387
  { IMAGE_LOAD_MIP_V1_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2388
  { IMAGE_LOAD_MIP_V1_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2389
  { IMAGE_LOAD_MIP_V1_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2390
  { IMAGE_LOAD_MIP_V1_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2391
  { IMAGE_LOAD_MIP_V2_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2392
  { IMAGE_LOAD_MIP_V2_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2393
  { IMAGE_LOAD_MIP_V2_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2394
  { IMAGE_LOAD_MIP_V2_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2395
  { IMAGE_LOAD_MIP_V3_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2396
  { IMAGE_LOAD_MIP_V3_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2397
  { IMAGE_LOAD_MIP_V3_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2398
  { IMAGE_LOAD_MIP_V3_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2399
  { IMAGE_LOAD_MIP_V4_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2400
  { IMAGE_LOAD_MIP_V4_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2401
  { IMAGE_LOAD_MIP_V4_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2402
  { IMAGE_LOAD_MIP_V4_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2403
  { IMAGE_LOAD_MIP_V5_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2404
  { IMAGE_LOAD_MIP_V5_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2405
  { IMAGE_LOAD_MIP_V5_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2406
  { IMAGE_LOAD_MIP_V5_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2407
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2408
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2409
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2410
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2411
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2412
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2413
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2414
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2415
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2416
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2417
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2418
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2419
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2420
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2421
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2422
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2423
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2424
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2425
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2426
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2427
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2428
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2429
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2430
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2431
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2432
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2433
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2434
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2435
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2436
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2437
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2438
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2439
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2440
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2441
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2442
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2443
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2444
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2445
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2446
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2447
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2448
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2449
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2450
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2451
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2452
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2453
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2454
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2455
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2456
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2457
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2458
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2459
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2460
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2461
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2462
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2463
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2464
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2465
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2466
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2467
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2468
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2469
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2470
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2471
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2472
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2473
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2474
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2475
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2476
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2477
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2478
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2479
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2480
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2481
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2482
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2483
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2484
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2485
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2486
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2487
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2488
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2489
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2490
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2491
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2492
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2493
  { IMAGE_LOAD_MIP_PCK_V5_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2494
  { IMAGE_LOAD_MIP_PCK_V5_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2495
  { IMAGE_LOAD_MIP_PCK_V5_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2496
  { IMAGE_LOAD_MIP_PCK_V5_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2497
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2498
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2499
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2500
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2501
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2502
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2503
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2504
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2505
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2506
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2507
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2508
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2509
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2510
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2511
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2512
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2513
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2514
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2515
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2516
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2517
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2518
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2519
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2520
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2521
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2522
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2523
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2524
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2525
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2526
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2527
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2528
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2529
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2530
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2531
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2532
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2533
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2534
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2535
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2536
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2537
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2538
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2539
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2540
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2541
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2542
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2543
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2544
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2545
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2546
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2547
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2548
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2549
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2550
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2551
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2552
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2553
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2554
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2555
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2556
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2557
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2558
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2559
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2560
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2561
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2562
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2563
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2564
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2565
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2566
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2567
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2568
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2569
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2570
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2571
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2572
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2573
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2574
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2575
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2576
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2577
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2578
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2579
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2580
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2581
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2582
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2583
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2584
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2585
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2586
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2587
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2588
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2589
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2590
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2591
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2592
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2593
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2594
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2595
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2596
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2597
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2598
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2599
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2600
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2601
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2602
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2603
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2604
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2605
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2606
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2607
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2608
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2609
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2610
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2611
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2612
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2613
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2614
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2615
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2616
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2617
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2618
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2619
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2620
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2621
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2622
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2623
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2624
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2625
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2626
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2627
  { IMAGE_LOAD_PCK_V1_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2628
  { IMAGE_LOAD_PCK_V1_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2629
  { IMAGE_LOAD_PCK_V1_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2630
  { IMAGE_LOAD_PCK_V1_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2631
  { IMAGE_LOAD_PCK_V2_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2632
  { IMAGE_LOAD_PCK_V2_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2633
  { IMAGE_LOAD_PCK_V2_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2634
  { IMAGE_LOAD_PCK_V2_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2635
  { IMAGE_LOAD_PCK_V3_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2636
  { IMAGE_LOAD_PCK_V3_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2637
  { IMAGE_LOAD_PCK_V3_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2638
  { IMAGE_LOAD_PCK_V3_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2639
  { IMAGE_LOAD_PCK_V4_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2640
  { IMAGE_LOAD_PCK_V4_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2641
  { IMAGE_LOAD_PCK_V4_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2642
  { IMAGE_LOAD_PCK_V4_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2643
  { IMAGE_LOAD_PCK_V5_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2644
  { IMAGE_LOAD_PCK_V5_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2645
  { IMAGE_LOAD_PCK_V5_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2646
  { IMAGE_LOAD_PCK_V5_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2647
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2648
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2649
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2650
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2651
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2652
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2653
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2654
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2655
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2656
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2657
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2658
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2659
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2660
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2661
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2662
  { IMAGE_LOAD_PCK_V1_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2663
  { IMAGE_LOAD_PCK_V1_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2664
  { IMAGE_LOAD_PCK_V1_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2665
  { IMAGE_LOAD_PCK_V1_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2666
  { IMAGE_LOAD_PCK_V2_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2667
  { IMAGE_LOAD_PCK_V2_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2668
  { IMAGE_LOAD_PCK_V2_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2669
  { IMAGE_LOAD_PCK_V2_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2670
  { IMAGE_LOAD_PCK_V3_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2671
  { IMAGE_LOAD_PCK_V3_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2672
  { IMAGE_LOAD_PCK_V3_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2673
  { IMAGE_LOAD_PCK_V3_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2674
  { IMAGE_LOAD_PCK_V4_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2675
  { IMAGE_LOAD_PCK_V4_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2676
  { IMAGE_LOAD_PCK_V4_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2677
  { IMAGE_LOAD_PCK_V4_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2678
  { IMAGE_LOAD_PCK_V5_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2679
  { IMAGE_LOAD_PCK_V5_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2680
  { IMAGE_LOAD_PCK_V5_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2681
  { IMAGE_LOAD_PCK_V5_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2682
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2683
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2684
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2685
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2686
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2687
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2688
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2689
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2690
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2691
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2692
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2693
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2694
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2695
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2696
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2697
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2698
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2699
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2700
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2701
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2702
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2703
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2704
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2705
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2706
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2707
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2708
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2709
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2710
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2711
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2712
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2713
  { IMAGE_LOAD_PCK_V5_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2714
  { IMAGE_LOAD_PCK_V5_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2715
  { IMAGE_LOAD_PCK_V5_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2716
  { IMAGE_LOAD_PCK_V5_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2717
  { IMAGE_LOAD_PCK_V1_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2718
  { IMAGE_LOAD_PCK_V1_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2719
  { IMAGE_LOAD_PCK_V1_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2720
  { IMAGE_LOAD_PCK_V1_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2721
  { IMAGE_LOAD_PCK_V2_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2722
  { IMAGE_LOAD_PCK_V2_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2723
  { IMAGE_LOAD_PCK_V2_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2724
  { IMAGE_LOAD_PCK_V2_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2725
  { IMAGE_LOAD_PCK_V3_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2726
  { IMAGE_LOAD_PCK_V3_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2727
  { IMAGE_LOAD_PCK_V3_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2728
  { IMAGE_LOAD_PCK_V3_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2729
  { IMAGE_LOAD_PCK_V4_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2730
  { IMAGE_LOAD_PCK_V4_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2731
  { IMAGE_LOAD_PCK_V4_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2732
  { IMAGE_LOAD_PCK_V4_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2733
  { IMAGE_LOAD_PCK_V5_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2734
  { IMAGE_LOAD_PCK_V5_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2735
  { IMAGE_LOAD_PCK_V5_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2736
  { IMAGE_LOAD_PCK_V5_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2737
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2738
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2739
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2740
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2741
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2742
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2743
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2744
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2745
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2746
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2747
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2748
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2749
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2750
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2751
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2752
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2753
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2754
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2755
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2756
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2757
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2758
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2759
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2760
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2761
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2762
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2763
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2764
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2765
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2766
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2767
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2768
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2769
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2770
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2771
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2772
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2773
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2774
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2775
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2776
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2777
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2778
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2779
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2780
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2781
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2782
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2783
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2784
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2785
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2786
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2787
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2788
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2789
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2790
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2791
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2792
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2793
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2794
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2795
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2796
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2797
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2798
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2799
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2800
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2801
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2802
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2803
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2804
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2805
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2806
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2807
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2808
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2809
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2810
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2811
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2812
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2813
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2814
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2815
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2816
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2817
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2818
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2819
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2820
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2821
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2822
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2823
  { IMAGE_LOAD_PCK_SGN_V5_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2824
  { IMAGE_LOAD_PCK_SGN_V5_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2825
  { IMAGE_LOAD_PCK_SGN_V5_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2826
  { IMAGE_LOAD_PCK_SGN_V5_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2827
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2828
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2829
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2830
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2831
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2832
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2833
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2834
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2835
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2836
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2837
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2838
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2839
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2840
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2841
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2842
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2843
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2844
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2845
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2846
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2847
  { IMAGE_MSAA_LOAD_V2_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2848
  { IMAGE_MSAA_LOAD_V2_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2849
  { IMAGE_MSAA_LOAD_V2_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2850
  { IMAGE_MSAA_LOAD_V2_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2851
  { IMAGE_MSAA_LOAD_V3_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2852
  { IMAGE_MSAA_LOAD_V3_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2853
  { IMAGE_MSAA_LOAD_V3_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2854
  { IMAGE_MSAA_LOAD_V3_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2855
  { IMAGE_MSAA_LOAD_V4_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2856
  { IMAGE_MSAA_LOAD_V4_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2857
  { IMAGE_MSAA_LOAD_V4_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2858
  { IMAGE_MSAA_LOAD_V4_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2859
  { IMAGE_MSAA_LOAD_V5_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2860
  { IMAGE_MSAA_LOAD_V5_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2861
  { IMAGE_MSAA_LOAD_V5_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2862
  { IMAGE_MSAA_LOAD_V5_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2863
  { IMAGE_MSAA_LOAD_V2_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2864
  { IMAGE_MSAA_LOAD_V2_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2865
  { IMAGE_MSAA_LOAD_V2_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2866
  { IMAGE_MSAA_LOAD_V3_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2867
  { IMAGE_MSAA_LOAD_V3_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2868
  { IMAGE_MSAA_LOAD_V3_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2869
  { IMAGE_MSAA_LOAD_V4_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2870
  { IMAGE_MSAA_LOAD_V4_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2871
  { IMAGE_MSAA_LOAD_V4_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2872
  { IMAGE_MSAA_LOAD_V5_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2873
  { IMAGE_MSAA_LOAD_V5_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2874
  { IMAGE_MSAA_LOAD_V5_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2875
  { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2876
  { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2877
  { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2878
  { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2879
  { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2880
  { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2881
  { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2882
  { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2883
  { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2884
  { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2885
  { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2886
  { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2887
  { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2888
  { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2889
  { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2890
  { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2891
  { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2892
  { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2893
  { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2894
  { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2895
  { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2896
  { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2897
  { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2898
  { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2899
  { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2900
  { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2901
  { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2902
  { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2903
  { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2904
  { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2905
  { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2906
  { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2907
  { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2908
  { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2909
  { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2910
  { IMAGE_MSAA_LOAD_X_V1_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2911
  { IMAGE_MSAA_LOAD_X_V1_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2912
  { IMAGE_MSAA_LOAD_X_V1_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2913
  { IMAGE_MSAA_LOAD_X_V1_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2914
  { IMAGE_MSAA_LOAD_X_V2_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2915
  { IMAGE_MSAA_LOAD_X_V2_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2916
  { IMAGE_MSAA_LOAD_X_V2_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2917
  { IMAGE_MSAA_LOAD_X_V2_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2918
  { IMAGE_MSAA_LOAD_X_V3_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2919
  { IMAGE_MSAA_LOAD_X_V3_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2920
  { IMAGE_MSAA_LOAD_X_V3_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2921
  { IMAGE_MSAA_LOAD_X_V3_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2922
  { IMAGE_MSAA_LOAD_X_V4_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2923
  { IMAGE_MSAA_LOAD_X_V4_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2924
  { IMAGE_MSAA_LOAD_X_V4_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2925
  { IMAGE_MSAA_LOAD_X_V4_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2926
  { IMAGE_MSAA_LOAD_X_V5_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2927
  { IMAGE_MSAA_LOAD_X_V5_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2928
  { IMAGE_MSAA_LOAD_X_V5_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2929
  { IMAGE_MSAA_LOAD_X_V5_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2930
  { IMAGE_SAMPLE_V1_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2931
  { IMAGE_SAMPLE_V1_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2932
  { IMAGE_SAMPLE_V1_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2933
  { IMAGE_SAMPLE_V1_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2934
  { IMAGE_SAMPLE_V2_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2935
  { IMAGE_SAMPLE_V2_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2936
  { IMAGE_SAMPLE_V2_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2937
  { IMAGE_SAMPLE_V2_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2938
  { IMAGE_SAMPLE_V3_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2939
  { IMAGE_SAMPLE_V3_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2940
  { IMAGE_SAMPLE_V3_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2941
  { IMAGE_SAMPLE_V3_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2942
  { IMAGE_SAMPLE_V4_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2943
  { IMAGE_SAMPLE_V4_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2944
  { IMAGE_SAMPLE_V4_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2945
  { IMAGE_SAMPLE_V4_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2946
  { IMAGE_SAMPLE_V5_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2947
  { IMAGE_SAMPLE_V5_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2948
  { IMAGE_SAMPLE_V5_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2949
  { IMAGE_SAMPLE_V5_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2950
  { IMAGE_SAMPLE_V1_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2951
  { IMAGE_SAMPLE_V1_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2952
  { IMAGE_SAMPLE_V2_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2953
  { IMAGE_SAMPLE_V2_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2954
  { IMAGE_SAMPLE_V3_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2955
  { IMAGE_SAMPLE_V3_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2956
  { IMAGE_SAMPLE_V4_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2957
  { IMAGE_SAMPLE_V4_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2958
  { IMAGE_SAMPLE_V5_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2959
  { IMAGE_SAMPLE_V5_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2960
  { IMAGE_SAMPLE_V1_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2961
  { IMAGE_SAMPLE_V1_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2962
  { IMAGE_SAMPLE_V1_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2963
  { IMAGE_SAMPLE_V1_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2964
  { IMAGE_SAMPLE_V2_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2965
  { IMAGE_SAMPLE_V2_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2966
  { IMAGE_SAMPLE_V2_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2967
  { IMAGE_SAMPLE_V2_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2968
  { IMAGE_SAMPLE_V3_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2969
  { IMAGE_SAMPLE_V3_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2970
  { IMAGE_SAMPLE_V3_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2971
  { IMAGE_SAMPLE_V3_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2972
  { IMAGE_SAMPLE_V4_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2973
  { IMAGE_SAMPLE_V4_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2974
  { IMAGE_SAMPLE_V4_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2975
  { IMAGE_SAMPLE_V4_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2976
  { IMAGE_SAMPLE_V5_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2977
  { IMAGE_SAMPLE_V5_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2978
  { IMAGE_SAMPLE_V5_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2979
  { IMAGE_SAMPLE_V5_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2980
  { IMAGE_SAMPLE_V1_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2981
  { IMAGE_SAMPLE_V1_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2982
  { IMAGE_SAMPLE_V2_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2983
  { IMAGE_SAMPLE_V2_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2984
  { IMAGE_SAMPLE_V3_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2985
  { IMAGE_SAMPLE_V3_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2986
  { IMAGE_SAMPLE_V4_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2987
  { IMAGE_SAMPLE_V4_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2988
  { IMAGE_SAMPLE_V5_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2989
  { IMAGE_SAMPLE_V5_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2990
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2991
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2992
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2993
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2994
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2995
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2996
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2997
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2998
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2999
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3000
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3001
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3002
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3003
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3004
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3005
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3006
  { IMAGE_SAMPLE_V5_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3007
  { IMAGE_SAMPLE_V5_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3008
  { IMAGE_SAMPLE_V5_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3009
  { IMAGE_SAMPLE_V5_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3010
  { IMAGE_SAMPLE_V1_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3011
  { IMAGE_SAMPLE_V1_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3012
  { IMAGE_SAMPLE_V1_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3013
  { IMAGE_SAMPLE_V1_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3014
  { IMAGE_SAMPLE_V2_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3015
  { IMAGE_SAMPLE_V2_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3016
  { IMAGE_SAMPLE_V2_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3017
  { IMAGE_SAMPLE_V2_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3018
  { IMAGE_SAMPLE_V3_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3019
  { IMAGE_SAMPLE_V3_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3020
  { IMAGE_SAMPLE_V3_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3021
  { IMAGE_SAMPLE_V3_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3022
  { IMAGE_SAMPLE_V4_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3023
  { IMAGE_SAMPLE_V4_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3024
  { IMAGE_SAMPLE_V4_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3025
  { IMAGE_SAMPLE_V4_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3026
  { IMAGE_SAMPLE_V5_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3027
  { IMAGE_SAMPLE_V5_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3028
  { IMAGE_SAMPLE_V5_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3029
  { IMAGE_SAMPLE_V5_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3030
  { IMAGE_SAMPLE_B_V1_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3031
  { IMAGE_SAMPLE_B_V1_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3032
  { IMAGE_SAMPLE_B_V1_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3033
  { IMAGE_SAMPLE_B_V2_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3034
  { IMAGE_SAMPLE_B_V2_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3035
  { IMAGE_SAMPLE_B_V2_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3036
  { IMAGE_SAMPLE_B_V3_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3037
  { IMAGE_SAMPLE_B_V3_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3038
  { IMAGE_SAMPLE_B_V3_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3039
  { IMAGE_SAMPLE_B_V4_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3040
  { IMAGE_SAMPLE_B_V4_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3041
  { IMAGE_SAMPLE_B_V4_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3042
  { IMAGE_SAMPLE_B_V5_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3043
  { IMAGE_SAMPLE_B_V5_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3044
  { IMAGE_SAMPLE_B_V5_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3045
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3046
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3047
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3048
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3049
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3050
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3051
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3052
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3053
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3054
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3055
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3056
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3057
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3058
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3059
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3060
  { IMAGE_SAMPLE_B_V1_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3061
  { IMAGE_SAMPLE_B_V1_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3062
  { IMAGE_SAMPLE_B_V1_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3063
  { IMAGE_SAMPLE_B_V2_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3064
  { IMAGE_SAMPLE_B_V2_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3065
  { IMAGE_SAMPLE_B_V2_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3066
  { IMAGE_SAMPLE_B_V3_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3067
  { IMAGE_SAMPLE_B_V3_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3068
  { IMAGE_SAMPLE_B_V3_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3069
  { IMAGE_SAMPLE_B_V4_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3070
  { IMAGE_SAMPLE_B_V4_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3071
  { IMAGE_SAMPLE_B_V4_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3072
  { IMAGE_SAMPLE_B_V5_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3073
  { IMAGE_SAMPLE_B_V5_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3074
  { IMAGE_SAMPLE_B_V5_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3075
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3076
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3077
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3078
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3079
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3080
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3081
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3082
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3083
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3084
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3085
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3086
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3087
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3088
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3089
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3090
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3091
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3092
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3093
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3094
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3095
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3096
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3097
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3098
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3099
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3100
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3101
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3102
  { IMAGE_SAMPLE_B_V5_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3103
  { IMAGE_SAMPLE_B_V5_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3104
  { IMAGE_SAMPLE_B_V5_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3105
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3106
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3107
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3108
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3109
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3110
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3111
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3112
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3113
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3114
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3115
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3116
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3117
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3118
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3119
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3120
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3121
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3122
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3123
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3124
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3125
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3126
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3127
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3128
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3129
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3130
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3131
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3132
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3133
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3134
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3135
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3136
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3137
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3138
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3139
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3140
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3141
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3142
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3143
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3144
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3145
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3146
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3147
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3148
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3149
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3150
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3151
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3152
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3153
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3154
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3155
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3156
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3157
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3158
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3159
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3160
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3161
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3162
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3163
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3164
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3165
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3166
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3167
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3168
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3169
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3170
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3171
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3172
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3173
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3174
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3175
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3176
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3177
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3178
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3179
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3180
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3181
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3182
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3183
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3184
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3185
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3186
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3187
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3188
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3189
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3190
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3191
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3192
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3193
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3194
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3195
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3196
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3197
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3198
  { IMAGE_SAMPLE_B_CL_V1_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3199
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3200
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3201
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3202
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3203
  { IMAGE_SAMPLE_B_CL_V2_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3204
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3205
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3206
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3207
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3208
  { IMAGE_SAMPLE_B_CL_V3_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3209
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3210
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3211
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3212
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3213
  { IMAGE_SAMPLE_B_CL_V4_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3214
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3215
  { IMAGE_SAMPLE_B_CL_V5_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3216
  { IMAGE_SAMPLE_B_CL_V5_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3217
  { IMAGE_SAMPLE_B_CL_V5_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3218
  { IMAGE_SAMPLE_B_CL_V5_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3219
  { IMAGE_SAMPLE_B_CL_V5_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3220
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3221
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3222
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3223
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3224
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3225
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3226
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3227
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3228
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3229
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3230
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3231
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3232
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3233
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3234
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3235
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3236
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3237
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3238
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3239
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3240
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3241
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3242
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3243
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3244
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3245
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3246
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3247
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3248
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3249
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3250
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3251
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3252
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3253
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3254
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3255
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3256
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3257
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3258
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3259
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3260
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3261
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3262
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3263
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3264
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3265
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3266
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3267
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3268
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 3269
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3270
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3271
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3272
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3273
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 3274
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3275
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3276
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3277
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3278
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 3279
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3280
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3281
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3282
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3283
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 3284
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3285
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3286
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3287
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3288
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 3289
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3290
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3291
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3292
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3293
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 3294
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3295
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3296
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3297
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 3298
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3299
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3300
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3301
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 3302
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3303
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3304
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3305
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 3306
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3307
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3308
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3309
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 3310
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3311
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3312
  { IMAGE_SAMPLE_B_CL_O_V1_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3313
  { IMAGE_SAMPLE_B_CL_O_V1_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3314
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3315
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3316
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3317
  { IMAGE_SAMPLE_B_CL_O_V2_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3318
  { IMAGE_SAMPLE_B_CL_O_V2_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3319
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3320
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3321
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3322
  { IMAGE_SAMPLE_B_CL_O_V3_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3323
  { IMAGE_SAMPLE_B_CL_O_V3_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3324
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3325
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3326
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3327
  { IMAGE_SAMPLE_B_CL_O_V4_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3328
  { IMAGE_SAMPLE_B_CL_O_V4_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3329
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3330
  { IMAGE_SAMPLE_B_CL_O_V5_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3331
  { IMAGE_SAMPLE_B_CL_O_V5_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3332
  { IMAGE_SAMPLE_B_CL_O_V5_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3333
  { IMAGE_SAMPLE_B_CL_O_V5_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3334
  { IMAGE_SAMPLE_B_CL_O_V5_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3335
  { IMAGE_SAMPLE_B_O_V1_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3336
  { IMAGE_SAMPLE_B_O_V1_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3337
  { IMAGE_SAMPLE_B_O_V1_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3338
  { IMAGE_SAMPLE_B_O_V1_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3339
  { IMAGE_SAMPLE_B_O_V2_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3340
  { IMAGE_SAMPLE_B_O_V2_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3341
  { IMAGE_SAMPLE_B_O_V2_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3342
  { IMAGE_SAMPLE_B_O_V2_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3343
  { IMAGE_SAMPLE_B_O_V3_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3344
  { IMAGE_SAMPLE_B_O_V3_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3345
  { IMAGE_SAMPLE_B_O_V3_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3346
  { IMAGE_SAMPLE_B_O_V3_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3347
  { IMAGE_SAMPLE_B_O_V4_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3348
  { IMAGE_SAMPLE_B_O_V4_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3349
  { IMAGE_SAMPLE_B_O_V4_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3350
  { IMAGE_SAMPLE_B_O_V4_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3351
  { IMAGE_SAMPLE_B_O_V5_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3352
  { IMAGE_SAMPLE_B_O_V5_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3353
  { IMAGE_SAMPLE_B_O_V5_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3354
  { IMAGE_SAMPLE_B_O_V5_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3355
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3356
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3357
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3358
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3359
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3360
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3361
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3362
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3363
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3364
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3365
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3366
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3367
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3368
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3369
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3370
  { IMAGE_SAMPLE_B_O_V1_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3371
  { IMAGE_SAMPLE_B_O_V1_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3372
  { IMAGE_SAMPLE_B_O_V1_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3373
  { IMAGE_SAMPLE_B_O_V1_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3374
  { IMAGE_SAMPLE_B_O_V2_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3375
  { IMAGE_SAMPLE_B_O_V2_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3376
  { IMAGE_SAMPLE_B_O_V2_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3377
  { IMAGE_SAMPLE_B_O_V2_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3378
  { IMAGE_SAMPLE_B_O_V3_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3379
  { IMAGE_SAMPLE_B_O_V3_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3380
  { IMAGE_SAMPLE_B_O_V3_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3381
  { IMAGE_SAMPLE_B_O_V3_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3382
  { IMAGE_SAMPLE_B_O_V4_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3383
  { IMAGE_SAMPLE_B_O_V4_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3384
  { IMAGE_SAMPLE_B_O_V4_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3385
  { IMAGE_SAMPLE_B_O_V4_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3386
  { IMAGE_SAMPLE_B_O_V5_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3387
  { IMAGE_SAMPLE_B_O_V5_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3388
  { IMAGE_SAMPLE_B_O_V5_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3389
  { IMAGE_SAMPLE_B_O_V5_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3390
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3391
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3392
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3393
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3394
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3395
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3396
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3397
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3398
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3399
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3400
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3401
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3402
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3403
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3404
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3405
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3406
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3407
  { IMAGE_SAMPLE_B_O_V1_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3408
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3409
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3410
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3411
  { IMAGE_SAMPLE_B_O_V2_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3412
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3413
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3414
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3415
  { IMAGE_SAMPLE_B_O_V3_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3416
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3417
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3418
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3419
  { IMAGE_SAMPLE_B_O_V4_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3420
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3421
  { IMAGE_SAMPLE_B_O_V5_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3422
  { IMAGE_SAMPLE_B_O_V5_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3423
  { IMAGE_SAMPLE_B_O_V5_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3424
  { IMAGE_SAMPLE_B_O_V5_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3425
  { IMAGE_SAMPLE_C_V1_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3426
  { IMAGE_SAMPLE_C_V1_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3427
  { IMAGE_SAMPLE_C_V1_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3428
  { IMAGE_SAMPLE_C_V2_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3429
  { IMAGE_SAMPLE_C_V2_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3430
  { IMAGE_SAMPLE_C_V2_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3431
  { IMAGE_SAMPLE_C_V3_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3432
  { IMAGE_SAMPLE_C_V3_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3433
  { IMAGE_SAMPLE_C_V3_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3434
  { IMAGE_SAMPLE_C_V4_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3435
  { IMAGE_SAMPLE_C_V4_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3436
  { IMAGE_SAMPLE_C_V4_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3437
  { IMAGE_SAMPLE_C_V5_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3438
  { IMAGE_SAMPLE_C_V5_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3439
  { IMAGE_SAMPLE_C_V5_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3440
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3441
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3442
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3443
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3444
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3445
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3446
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3447
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3448
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3449
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3450
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3451
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3452
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3453
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3454
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3455
  { IMAGE_SAMPLE_C_V1_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3456
  { IMAGE_SAMPLE_C_V1_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3457
  { IMAGE_SAMPLE_C_V1_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3458
  { IMAGE_SAMPLE_C_V2_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3459
  { IMAGE_SAMPLE_C_V2_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3460
  { IMAGE_SAMPLE_C_V2_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3461
  { IMAGE_SAMPLE_C_V3_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3462
  { IMAGE_SAMPLE_C_V3_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3463
  { IMAGE_SAMPLE_C_V3_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3464
  { IMAGE_SAMPLE_C_V4_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3465
  { IMAGE_SAMPLE_C_V4_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3466
  { IMAGE_SAMPLE_C_V4_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3467
  { IMAGE_SAMPLE_C_V5_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3468
  { IMAGE_SAMPLE_C_V5_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3469
  { IMAGE_SAMPLE_C_V5_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3470
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3471
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3472
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3473
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3474
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3475
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3476
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3477
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3478
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3479
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3480
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3481
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3482
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3483
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3484
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3485
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3486
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3487
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3488
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3489
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3490
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3491
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3492
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3493
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3494
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3495
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3496
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3497
  { IMAGE_SAMPLE_C_V5_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3498
  { IMAGE_SAMPLE_C_V5_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3499
  { IMAGE_SAMPLE_C_V5_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3500
  { IMAGE_SAMPLE_CD_V1_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3501
  { IMAGE_SAMPLE_CD_V1_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3502
  { IMAGE_SAMPLE_CD_V1_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3503
  { IMAGE_SAMPLE_CD_V1_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3504
  { IMAGE_SAMPLE_CD_V1_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3505
  { IMAGE_SAMPLE_CD_V1_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 3506
  { IMAGE_SAMPLE_CD_V1_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3507
  { IMAGE_SAMPLE_CD_V1_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 3508
  { IMAGE_SAMPLE_CD_V2_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3509
  { IMAGE_SAMPLE_CD_V2_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3510
  { IMAGE_SAMPLE_CD_V2_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3511
  { IMAGE_SAMPLE_CD_V2_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3512
  { IMAGE_SAMPLE_CD_V2_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3513
  { IMAGE_SAMPLE_CD_V2_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 3514
  { IMAGE_SAMPLE_CD_V2_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3515
  { IMAGE_SAMPLE_CD_V2_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 3516
  { IMAGE_SAMPLE_CD_V3_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3517
  { IMAGE_SAMPLE_CD_V3_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3518
  { IMAGE_SAMPLE_CD_V3_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3519
  { IMAGE_SAMPLE_CD_V3_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3520
  { IMAGE_SAMPLE_CD_V3_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3521
  { IMAGE_SAMPLE_CD_V3_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 3522
  { IMAGE_SAMPLE_CD_V3_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3523
  { IMAGE_SAMPLE_CD_V3_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 3524
  { IMAGE_SAMPLE_CD_V4_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3525
  { IMAGE_SAMPLE_CD_V4_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3526
  { IMAGE_SAMPLE_CD_V4_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3527
  { IMAGE_SAMPLE_CD_V4_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3528
  { IMAGE_SAMPLE_CD_V4_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3529
  { IMAGE_SAMPLE_CD_V4_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 3530
  { IMAGE_SAMPLE_CD_V4_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3531
  { IMAGE_SAMPLE_CD_V4_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 3532
  { IMAGE_SAMPLE_CD_V5_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3533
  { IMAGE_SAMPLE_CD_V5_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3534
  { IMAGE_SAMPLE_CD_V5_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3535
  { IMAGE_SAMPLE_CD_V5_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3536
  { IMAGE_SAMPLE_CD_V5_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3537
  { IMAGE_SAMPLE_CD_V5_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 3538
  { IMAGE_SAMPLE_CD_V5_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3539
  { IMAGE_SAMPLE_CD_V5_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 3540
  { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3541
  { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3542
  { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3543
  { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3544
  { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3545
  { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 3546
  { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 3547
  { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 3548
  { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3549
  { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3550
  { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3551
  { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3552
  { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3553
  { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 3554
  { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 3555
  { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 3556
  { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3557
  { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3558
  { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3559
  { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3560
  { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3561
  { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 3562
  { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 3563
  { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 3564
  { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3565
  { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3566
  { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3567
  { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3568
  { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3569
  { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 3570
  { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 3571
  { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 3572
  { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3573
  { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3574
  { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3575
  { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3576
  { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3577
  { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 3578
  { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 3579
  { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 3580
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3581
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3582
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3583
  { IMAGE_SAMPLE_CD_V1_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3584
  { IMAGE_SAMPLE_CD_V1_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3585
  { IMAGE_SAMPLE_CD_V1_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 3586
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3587
  { IMAGE_SAMPLE_CD_V1_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 3588
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3589
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3590
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3591
  { IMAGE_SAMPLE_CD_V2_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3592
  { IMAGE_SAMPLE_CD_V2_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3593
  { IMAGE_SAMPLE_CD_V2_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 3594
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3595
  { IMAGE_SAMPLE_CD_V2_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 3596
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3597
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3598
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3599
  { IMAGE_SAMPLE_CD_V3_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3600
  { IMAGE_SAMPLE_CD_V3_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3601
  { IMAGE_SAMPLE_CD_V3_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 3602
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3603
  { IMAGE_SAMPLE_CD_V3_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 3604
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3605
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3606
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3607
  { IMAGE_SAMPLE_CD_V4_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3608
  { IMAGE_SAMPLE_CD_V4_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3609
  { IMAGE_SAMPLE_CD_V4_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 3610
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3611
  { IMAGE_SAMPLE_CD_V4_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 3612
  { IMAGE_SAMPLE_CD_V5_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3613
  { IMAGE_SAMPLE_CD_V5_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3614
  { IMAGE_SAMPLE_CD_V5_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3615
  { IMAGE_SAMPLE_CD_V5_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3616
  { IMAGE_SAMPLE_CD_V5_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3617
  { IMAGE_SAMPLE_CD_V5_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 3618
  { IMAGE_SAMPLE_CD_V5_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3619
  { IMAGE_SAMPLE_CD_V5_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 3620
  { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3621
  { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3622
  { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3623
  { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3624
  { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3625
  { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 3626
  { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3627
  { IMAGE_SAMPLE_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 3628
  { IMAGE_SAMPLE_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 3629
  { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3630
  { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3631
  { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3632
  { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3633
  { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3634
  { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 3635
  { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3636
  { IMAGE_SAMPLE_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 3637
  { IMAGE_SAMPLE_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 3638
  { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3639
  { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3640
  { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3641
  { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3642
  { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3643
  { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 3644
  { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3645
  { IMAGE_SAMPLE_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 3646
  { IMAGE_SAMPLE_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 3647
  { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3648
  { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3649
  { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3650
  { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3651
  { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3652
  { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 3653
  { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3654
  { IMAGE_SAMPLE_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 3655
  { IMAGE_SAMPLE_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 3656
  { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3657
  { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3658
  { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3659
  { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3660
  { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3661
  { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 3662
  { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3663
  { IMAGE_SAMPLE_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 3664
  { IMAGE_SAMPLE_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 3665
  { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3666
  { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3667
  { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3668
  { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3669
  { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3670
  { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 3671
  { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 3672
  { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 3673
  { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 3674
  { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3675
  { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3676
  { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3677
  { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3678
  { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3679
  { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 3680
  { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 3681
  { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 3682
  { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 3683
  { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3684
  { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3685
  { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3686
  { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3687
  { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3688
  { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 3689
  { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 3690
  { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 3691
  { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 3692
  { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3693
  { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3694
  { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3695
  { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3696
  { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3697
  { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 3698
  { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 3699
  { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 3700
  { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 3701
  { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3702
  { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3703
  { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3704
  { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3705
  { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3706
  { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 3707
  { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 3708
  { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 3709
  { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 3710
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3711
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3712
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3713
  { IMAGE_SAMPLE_CD_CL_V1_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3714
  { IMAGE_SAMPLE_CD_CL_V1_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3715
  { IMAGE_SAMPLE_CD_CL_V1_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 3716
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3717
  { IMAGE_SAMPLE_CD_CL_V1_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 3718
  { IMAGE_SAMPLE_CD_CL_V1_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 3719
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3720
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3721
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3722
  { IMAGE_SAMPLE_CD_CL_V2_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3723
  { IMAGE_SAMPLE_CD_CL_V2_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3724
  { IMAGE_SAMPLE_CD_CL_V2_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 3725
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3726
  { IMAGE_SAMPLE_CD_CL_V2_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 3727
  { IMAGE_SAMPLE_CD_CL_V2_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 3728
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3729
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3730
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3731
  { IMAGE_SAMPLE_CD_CL_V3_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3732
  { IMAGE_SAMPLE_CD_CL_V3_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3733
  { IMAGE_SAMPLE_CD_CL_V3_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 3734
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3735
  { IMAGE_SAMPLE_CD_CL_V3_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 3736
  { IMAGE_SAMPLE_CD_CL_V3_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 3737
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3738
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3739
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3740
  { IMAGE_SAMPLE_CD_CL_V4_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3741
  { IMAGE_SAMPLE_CD_CL_V4_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3742
  { IMAGE_SAMPLE_CD_CL_V4_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 3743
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3744
  { IMAGE_SAMPLE_CD_CL_V4_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 3745
  { IMAGE_SAMPLE_CD_CL_V4_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 3746
  { IMAGE_SAMPLE_CD_CL_V5_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3747
  { IMAGE_SAMPLE_CD_CL_V5_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3748
  { IMAGE_SAMPLE_CD_CL_V5_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3749
  { IMAGE_SAMPLE_CD_CL_V5_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3750
  { IMAGE_SAMPLE_CD_CL_V5_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3751
  { IMAGE_SAMPLE_CD_CL_V5_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 3752
  { IMAGE_SAMPLE_CD_CL_V5_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3753
  { IMAGE_SAMPLE_CD_CL_V5_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 3754
  { IMAGE_SAMPLE_CD_CL_V5_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 3755
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3756
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3757
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3758
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3759
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3760
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 3761
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3762
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3763
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3764
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3765
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3766
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3767
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 3768
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3769
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3770
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3771
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3772
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3773
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3774
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 3775
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3776
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3777
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3778
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3779
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3780
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3781
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 3782
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3783
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3784
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3785
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3786
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3787
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3788
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 3789
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3790
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3791
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3792
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3793
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3794
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3795
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 3796
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 3797
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3798
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3799
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3800
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3801
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3802
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 3803
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 3804
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3805
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3806
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3807
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3808
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3809
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 3810
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 3811
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3812
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3813
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3814
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3815
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3816
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 3817
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 3818
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3819
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3820
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3821
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3822
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3823
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 3824
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 3825
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3826
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3827
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3828
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3829
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3830
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 3831
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3832
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3833
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3834
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3835
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3836
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3837
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 3838
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3839
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3840
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3841
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3842
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3843
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3844
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 3845
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3846
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3847
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3848
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3849
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3850
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3851
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 3852
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3853
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3854
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3855
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3856
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3857
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3858
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 3859
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3860
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3861
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3862
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3863
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3864
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 3865
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3866
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 3867
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 3868
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 3869
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3870
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3871
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3872
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3873
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 3874
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3875
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 3876
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 3877
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 3878
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3879
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3880
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3881
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3882
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 3883
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3884
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 3885
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 3886
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 3887
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3888
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3889
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3890
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3891
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 3892
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3893
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 3894
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 3895
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 3896
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3897
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3898
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3899
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3900
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 3901
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3902
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 3903
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 3904
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 3905
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3906
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3907
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3908
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3909
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 3910
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 3911
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 3912
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 3913
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 3914
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3915
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3916
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3917
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3918
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 3919
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 3920
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 3921
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 3922
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 3923
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3924
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3925
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3926
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3927
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 3928
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 3929
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 3930
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 3931
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 3932
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3933
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3934
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3935
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3936
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 3937
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 3938
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 3939
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 3940
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 3941
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3942
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3943
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3944
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3945
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 3946
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 3947
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 3948
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 3949
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 3950
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3951
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3952
  { IMAGE_SAMPLE_CD_CL_O_V1_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3953
  { IMAGE_SAMPLE_CD_CL_O_V1_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3954
  { IMAGE_SAMPLE_CD_CL_O_V1_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 3955
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3956
  { IMAGE_SAMPLE_CD_CL_O_V1_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 3957
  { IMAGE_SAMPLE_CD_CL_O_V1_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 3958
  { IMAGE_SAMPLE_CD_CL_O_V1_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 3959
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3960
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3961
  { IMAGE_SAMPLE_CD_CL_O_V2_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3962
  { IMAGE_SAMPLE_CD_CL_O_V2_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3963
  { IMAGE_SAMPLE_CD_CL_O_V2_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 3964
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3965
  { IMAGE_SAMPLE_CD_CL_O_V2_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 3966
  { IMAGE_SAMPLE_CD_CL_O_V2_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 3967
  { IMAGE_SAMPLE_CD_CL_O_V2_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 3968
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3969
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3970
  { IMAGE_SAMPLE_CD_CL_O_V3_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3971
  { IMAGE_SAMPLE_CD_CL_O_V3_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3972
  { IMAGE_SAMPLE_CD_CL_O_V3_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 3973
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3974
  { IMAGE_SAMPLE_CD_CL_O_V3_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 3975
  { IMAGE_SAMPLE_CD_CL_O_V3_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 3976
  { IMAGE_SAMPLE_CD_CL_O_V3_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 3977
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3978
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3979
  { IMAGE_SAMPLE_CD_CL_O_V4_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3980
  { IMAGE_SAMPLE_CD_CL_O_V4_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3981
  { IMAGE_SAMPLE_CD_CL_O_V4_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 3982
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3983
  { IMAGE_SAMPLE_CD_CL_O_V4_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 3984
  { IMAGE_SAMPLE_CD_CL_O_V4_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 3985
  { IMAGE_SAMPLE_CD_CL_O_V4_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 3986
  { IMAGE_SAMPLE_CD_CL_O_V5_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3987
  { IMAGE_SAMPLE_CD_CL_O_V5_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3988
  { IMAGE_SAMPLE_CD_CL_O_V5_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3989
  { IMAGE_SAMPLE_CD_CL_O_V5_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3990
  { IMAGE_SAMPLE_CD_CL_O_V5_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 3991
  { IMAGE_SAMPLE_CD_CL_O_V5_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3992
  { IMAGE_SAMPLE_CD_CL_O_V5_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 3993
  { IMAGE_SAMPLE_CD_CL_O_V5_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 3994
  { IMAGE_SAMPLE_CD_CL_O_V5_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 3995
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3996
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3997
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3998
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3999
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4000
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4001
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4002
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4003
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4004
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4005
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4006
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4007
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4008
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4009
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4010
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4011
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4012
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4013
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4014
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4015
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4016
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4017
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4018
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4019
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4020
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4021
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4022
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4023
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4024
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4025
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4026
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4027
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4028
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4029
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4030
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4031
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4032
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4033
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4034
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4035
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4036
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4037
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4038
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4039
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4040
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4041
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4042
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4043
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4044
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4045
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4046
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4047
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4048
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4049
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4050
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4051
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4052
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4053
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4054
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4055
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4056
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4057
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4058
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4059
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4060
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4061
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4062
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4063
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4064
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4065
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4066
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4067
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4068
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4069
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4070
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4071
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4072
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4073
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4074
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4075
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4076
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4077
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4078
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4079
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4080
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4081
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4082
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4083
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4084
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4085
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4086
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4087
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4088
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4089
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4090
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4091
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4092
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4093
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4094
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4095
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4096
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4097
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4098
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4099
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4100
  { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4101
  { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4102
  { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4103
  { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4104
  { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4105
  { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4106
  { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4107
  { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4108
  { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4109
  { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4110
  { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4111
  { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4112
  { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4113
  { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4114
  { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4115
  { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4116
  { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4117
  { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4118
  { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4119
  { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4120
  { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4121
  { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4122
  { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4123
  { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4124
  { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4125
  { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4126
  { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4127
  { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4128
  { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4129
  { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4130
  { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4131
  { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4132
  { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4133
  { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4134
  { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4135
  { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4136
  { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4137
  { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4138
  { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4139
  { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4140
  { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4141
  { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4142
  { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4143
  { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4144
  { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4145
  { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4146
  { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4147
  { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4148
  { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4149
  { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4150
  { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4151
  { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4152
  { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4153
  { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4154
  { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4155
  { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4156
  { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4157
  { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4158
  { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4159
  { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4160
  { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4161
  { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4162
  { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4163
  { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4164
  { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4165
  { IMAGE_SAMPLE_CD_G16_V1_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4166
  { IMAGE_SAMPLE_CD_G16_V1_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4167
  { IMAGE_SAMPLE_CD_G16_V1_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4168
  { IMAGE_SAMPLE_CD_G16_V1_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4169
  { IMAGE_SAMPLE_CD_G16_V1_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4170
  { IMAGE_SAMPLE_CD_G16_V1_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4171
  { IMAGE_SAMPLE_CD_G16_V1_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4172
  { IMAGE_SAMPLE_CD_G16_V2_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4173
  { IMAGE_SAMPLE_CD_G16_V2_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4174
  { IMAGE_SAMPLE_CD_G16_V2_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4175
  { IMAGE_SAMPLE_CD_G16_V2_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4176
  { IMAGE_SAMPLE_CD_G16_V2_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4177
  { IMAGE_SAMPLE_CD_G16_V2_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4178
  { IMAGE_SAMPLE_CD_G16_V2_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4179
  { IMAGE_SAMPLE_CD_G16_V3_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4180
  { IMAGE_SAMPLE_CD_G16_V3_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4181
  { IMAGE_SAMPLE_CD_G16_V3_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4182
  { IMAGE_SAMPLE_CD_G16_V3_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4183
  { IMAGE_SAMPLE_CD_G16_V3_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4184
  { IMAGE_SAMPLE_CD_G16_V3_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4185
  { IMAGE_SAMPLE_CD_G16_V3_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4186
  { IMAGE_SAMPLE_CD_G16_V4_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4187
  { IMAGE_SAMPLE_CD_G16_V4_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4188
  { IMAGE_SAMPLE_CD_G16_V4_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4189
  { IMAGE_SAMPLE_CD_G16_V4_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4190
  { IMAGE_SAMPLE_CD_G16_V4_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4191
  { IMAGE_SAMPLE_CD_G16_V4_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4192
  { IMAGE_SAMPLE_CD_G16_V4_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4193
  { IMAGE_SAMPLE_CD_G16_V5_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4194
  { IMAGE_SAMPLE_CD_G16_V5_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4195
  { IMAGE_SAMPLE_CD_G16_V5_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4196
  { IMAGE_SAMPLE_CD_G16_V5_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4197
  { IMAGE_SAMPLE_CD_G16_V5_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4198
  { IMAGE_SAMPLE_CD_G16_V5_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4199
  { IMAGE_SAMPLE_CD_G16_V5_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4200
  { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4201
  { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4202
  { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4203
  { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4204
  { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4205
  { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4206
  { IMAGE_SAMPLE_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4207
  { IMAGE_SAMPLE_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 4208
  { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4209
  { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4210
  { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4211
  { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4212
  { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4213
  { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4214
  { IMAGE_SAMPLE_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4215
  { IMAGE_SAMPLE_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 4216
  { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4217
  { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4218
  { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4219
  { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4220
  { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4221
  { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4222
  { IMAGE_SAMPLE_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4223
  { IMAGE_SAMPLE_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 4224
  { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4225
  { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4226
  { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4227
  { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4228
  { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4229
  { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4230
  { IMAGE_SAMPLE_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4231
  { IMAGE_SAMPLE_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 4232
  { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4233
  { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4234
  { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4235
  { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4236
  { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4237
  { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4238
  { IMAGE_SAMPLE_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4239
  { IMAGE_SAMPLE_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 4240
  { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4241
  { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4242
  { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4243
  { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4244
  { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4245
  { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4246
  { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4247
  { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 4248
  { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4249
  { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4250
  { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4251
  { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4252
  { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4253
  { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4254
  { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4255
  { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 4256
  { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4257
  { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4258
  { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4259
  { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4260
  { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4261
  { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4262
  { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4263
  { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 4264
  { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4265
  { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4266
  { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4267
  { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4268
  { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4269
  { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4270
  { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4271
  { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 4272
  { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4273
  { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4274
  { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4275
  { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4276
  { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4277
  { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4278
  { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4279
  { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 4280
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4281
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4282
  { IMAGE_SAMPLE_CD_O_V1_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4283
  { IMAGE_SAMPLE_CD_O_V1_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4284
  { IMAGE_SAMPLE_CD_O_V1_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4285
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4286
  { IMAGE_SAMPLE_CD_O_V1_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4287
  { IMAGE_SAMPLE_CD_O_V1_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 4288
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4289
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4290
  { IMAGE_SAMPLE_CD_O_V2_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4291
  { IMAGE_SAMPLE_CD_O_V2_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4292
  { IMAGE_SAMPLE_CD_O_V2_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4293
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4294
  { IMAGE_SAMPLE_CD_O_V2_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4295
  { IMAGE_SAMPLE_CD_O_V2_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 4296
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4297
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4298
  { IMAGE_SAMPLE_CD_O_V3_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4299
  { IMAGE_SAMPLE_CD_O_V3_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4300
  { IMAGE_SAMPLE_CD_O_V3_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4301
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4302
  { IMAGE_SAMPLE_CD_O_V3_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4303
  { IMAGE_SAMPLE_CD_O_V3_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 4304
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4305
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4306
  { IMAGE_SAMPLE_CD_O_V4_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4307
  { IMAGE_SAMPLE_CD_O_V4_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4308
  { IMAGE_SAMPLE_CD_O_V4_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4309
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4310
  { IMAGE_SAMPLE_CD_O_V4_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4311
  { IMAGE_SAMPLE_CD_O_V4_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 4312
  { IMAGE_SAMPLE_CD_O_V5_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4313
  { IMAGE_SAMPLE_CD_O_V5_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4314
  { IMAGE_SAMPLE_CD_O_V5_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4315
  { IMAGE_SAMPLE_CD_O_V5_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4316
  { IMAGE_SAMPLE_CD_O_V5_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4317
  { IMAGE_SAMPLE_CD_O_V5_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4318
  { IMAGE_SAMPLE_CD_O_V5_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4319
  { IMAGE_SAMPLE_CD_O_V5_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 4320
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4321
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4322
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4323
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4324
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4325
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4326
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4327
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4328
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4329
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4330
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4331
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4332
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4333
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4334
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4335
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4336
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4337
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4338
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4339
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4340
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4341
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4342
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4343
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4344
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4345
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4346
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4347
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4348
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4349
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4350
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4351
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4352
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4353
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4354
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4355
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4356
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4357
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4358
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4359
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4360
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4361
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4362
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4363
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4364
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4365
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4366
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4367
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4368
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4369
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4370
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4371
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4372
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4373
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4374
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4375
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4376
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4377
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4378
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4379
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4380
  { IMAGE_SAMPLE_CD_O_G16_V1_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4381
  { IMAGE_SAMPLE_CD_O_G16_V1_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4382
  { IMAGE_SAMPLE_CD_O_G16_V1_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4383
  { IMAGE_SAMPLE_CD_O_G16_V1_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4384
  { IMAGE_SAMPLE_CD_O_G16_V1_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4385
  { IMAGE_SAMPLE_CD_O_G16_V1_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4386
  { IMAGE_SAMPLE_CD_O_G16_V2_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4387
  { IMAGE_SAMPLE_CD_O_G16_V2_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4388
  { IMAGE_SAMPLE_CD_O_G16_V2_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4389
  { IMAGE_SAMPLE_CD_O_G16_V2_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4390
  { IMAGE_SAMPLE_CD_O_G16_V2_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4391
  { IMAGE_SAMPLE_CD_O_G16_V2_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4392
  { IMAGE_SAMPLE_CD_O_G16_V3_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4393
  { IMAGE_SAMPLE_CD_O_G16_V3_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4394
  { IMAGE_SAMPLE_CD_O_G16_V3_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4395
  { IMAGE_SAMPLE_CD_O_G16_V3_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4396
  { IMAGE_SAMPLE_CD_O_G16_V3_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4397
  { IMAGE_SAMPLE_CD_O_G16_V3_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4398
  { IMAGE_SAMPLE_CD_O_G16_V4_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4399
  { IMAGE_SAMPLE_CD_O_G16_V4_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4400
  { IMAGE_SAMPLE_CD_O_G16_V4_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4401
  { IMAGE_SAMPLE_CD_O_G16_V4_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4402
  { IMAGE_SAMPLE_CD_O_G16_V4_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4403
  { IMAGE_SAMPLE_CD_O_G16_V4_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4404
  { IMAGE_SAMPLE_CD_O_G16_V5_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4405
  { IMAGE_SAMPLE_CD_O_G16_V5_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4406
  { IMAGE_SAMPLE_CD_O_G16_V5_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4407
  { IMAGE_SAMPLE_CD_O_G16_V5_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4408
  { IMAGE_SAMPLE_CD_O_G16_V5_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4409
  { IMAGE_SAMPLE_CD_O_G16_V5_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4410
  { IMAGE_SAMPLE_CL_V1_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 4411
  { IMAGE_SAMPLE_CL_V1_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4412
  { IMAGE_SAMPLE_CL_V1_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4413
  { IMAGE_SAMPLE_CL_V1_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4414
  { IMAGE_SAMPLE_CL_V2_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4415
  { IMAGE_SAMPLE_CL_V2_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4416
  { IMAGE_SAMPLE_CL_V2_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4417
  { IMAGE_SAMPLE_CL_V2_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4418
  { IMAGE_SAMPLE_CL_V3_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 4419
  { IMAGE_SAMPLE_CL_V3_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4420
  { IMAGE_SAMPLE_CL_V3_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4421
  { IMAGE_SAMPLE_CL_V3_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4422
  { IMAGE_SAMPLE_CL_V4_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 4423
  { IMAGE_SAMPLE_CL_V4_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4424
  { IMAGE_SAMPLE_CL_V4_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4425
  { IMAGE_SAMPLE_CL_V4_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4426
  { IMAGE_SAMPLE_CL_V5_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 4427
  { IMAGE_SAMPLE_CL_V5_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4428
  { IMAGE_SAMPLE_CL_V5_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4429
  { IMAGE_SAMPLE_CL_V5_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4430
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4431
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4432
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4433
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4434
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4435
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4436
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4437
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4438
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4439
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4440
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4441
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4442
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4443
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4444
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4445
  { IMAGE_SAMPLE_CL_V1_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 4446
  { IMAGE_SAMPLE_CL_V1_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4447
  { IMAGE_SAMPLE_CL_V1_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4448
  { IMAGE_SAMPLE_CL_V1_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4449
  { IMAGE_SAMPLE_CL_V2_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 4450
  { IMAGE_SAMPLE_CL_V2_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4451
  { IMAGE_SAMPLE_CL_V2_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4452
  { IMAGE_SAMPLE_CL_V2_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4453
  { IMAGE_SAMPLE_CL_V3_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 4454
  { IMAGE_SAMPLE_CL_V3_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4455
  { IMAGE_SAMPLE_CL_V3_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4456
  { IMAGE_SAMPLE_CL_V3_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4457
  { IMAGE_SAMPLE_CL_V4_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 4458
  { IMAGE_SAMPLE_CL_V4_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4459
  { IMAGE_SAMPLE_CL_V4_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4460
  { IMAGE_SAMPLE_CL_V4_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4461
  { IMAGE_SAMPLE_CL_V5_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 4462
  { IMAGE_SAMPLE_CL_V5_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4463
  { IMAGE_SAMPLE_CL_V5_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4464
  { IMAGE_SAMPLE_CL_V5_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4465
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4466
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4467
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4468
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4469
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4470
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4471
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4472
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4473
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4474
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4475
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4476
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4477
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4478
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4479
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4480
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 4481
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4482
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4483
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4484
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 4485
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4486
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4487
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4488
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 4489
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4490
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4491
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4492
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 4493
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4494
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4495
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4496
  { IMAGE_SAMPLE_CL_V5_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 4497
  { IMAGE_SAMPLE_CL_V5_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4498
  { IMAGE_SAMPLE_CL_V5_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4499
  { IMAGE_SAMPLE_CL_V5_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4500
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4501
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4502
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4503
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4504
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4505
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4506
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4507
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4508
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4509
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4510
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4511
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4512
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4513
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4514
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4515
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4516
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4517
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4518
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4519
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4520
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4521
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4522
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4523
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4524
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4525
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4526
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4527
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4528
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4529
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4530
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4531
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4532
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4533
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4534
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4535
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4536
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4537
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4538
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4539
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4540
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4541
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4542
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4543
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4544
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4545
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4546
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4547
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4548
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4549
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4550
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4551
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4552
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4553
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4554
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4555
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4556
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4557
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4558
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4559
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4560
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4561
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4562
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4563
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4564
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4565
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4566
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4567
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4568
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4569
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4570
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4571
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4572
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4573
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4574
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4575
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4576
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4577
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4578
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4579
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4580
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4581
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4582
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4583
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4584
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4585
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4586
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4587
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4588
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4589
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4590
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4591
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4592
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4593
  { IMAGE_SAMPLE_CL_O_V1_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4594
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4595
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4596
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4597
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4598
  { IMAGE_SAMPLE_CL_O_V2_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4599
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4600
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4601
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4602
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4603
  { IMAGE_SAMPLE_CL_O_V3_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4604
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4605
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4606
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4607
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4608
  { IMAGE_SAMPLE_CL_O_V4_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4609
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4610
  { IMAGE_SAMPLE_CL_O_V5_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4611
  { IMAGE_SAMPLE_CL_O_V5_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4612
  { IMAGE_SAMPLE_CL_O_V5_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4613
  { IMAGE_SAMPLE_CL_O_V5_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4614
  { IMAGE_SAMPLE_CL_O_V5_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4615
  { IMAGE_SAMPLE_C_B_V1_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4616
  { IMAGE_SAMPLE_C_B_V1_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4617
  { IMAGE_SAMPLE_C_B_V1_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4618
  { IMAGE_SAMPLE_C_B_V1_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4619
  { IMAGE_SAMPLE_C_B_V2_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4620
  { IMAGE_SAMPLE_C_B_V2_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4621
  { IMAGE_SAMPLE_C_B_V2_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4622
  { IMAGE_SAMPLE_C_B_V2_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4623
  { IMAGE_SAMPLE_C_B_V3_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4624
  { IMAGE_SAMPLE_C_B_V3_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4625
  { IMAGE_SAMPLE_C_B_V3_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4626
  { IMAGE_SAMPLE_C_B_V3_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4627
  { IMAGE_SAMPLE_C_B_V4_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4628
  { IMAGE_SAMPLE_C_B_V4_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4629
  { IMAGE_SAMPLE_C_B_V4_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4630
  { IMAGE_SAMPLE_C_B_V4_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4631
  { IMAGE_SAMPLE_C_B_V5_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4632
  { IMAGE_SAMPLE_C_B_V5_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4633
  { IMAGE_SAMPLE_C_B_V5_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4634
  { IMAGE_SAMPLE_C_B_V5_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4635
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4636
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4637
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4638
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4639
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4640
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4641
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4642
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4643
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4644
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4645
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4646
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4647
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4648
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4649
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4650
  { IMAGE_SAMPLE_C_B_V1_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4651
  { IMAGE_SAMPLE_C_B_V1_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4652
  { IMAGE_SAMPLE_C_B_V1_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4653
  { IMAGE_SAMPLE_C_B_V1_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4654
  { IMAGE_SAMPLE_C_B_V2_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4655
  { IMAGE_SAMPLE_C_B_V2_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4656
  { IMAGE_SAMPLE_C_B_V2_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4657
  { IMAGE_SAMPLE_C_B_V2_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4658
  { IMAGE_SAMPLE_C_B_V3_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4659
  { IMAGE_SAMPLE_C_B_V3_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4660
  { IMAGE_SAMPLE_C_B_V3_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4661
  { IMAGE_SAMPLE_C_B_V3_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4662
  { IMAGE_SAMPLE_C_B_V4_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4663
  { IMAGE_SAMPLE_C_B_V4_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4664
  { IMAGE_SAMPLE_C_B_V4_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4665
  { IMAGE_SAMPLE_C_B_V4_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4666
  { IMAGE_SAMPLE_C_B_V5_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4667
  { IMAGE_SAMPLE_C_B_V5_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4668
  { IMAGE_SAMPLE_C_B_V5_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4669
  { IMAGE_SAMPLE_C_B_V5_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4670
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4671
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4672
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4673
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4674
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4675
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4676
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4677
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4678
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4679
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4680
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4681
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4682
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4683
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4684
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4685
  { IMAGE_SAMPLE_C_B_V1_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4686
  { IMAGE_SAMPLE_C_B_V1_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4687
  { IMAGE_SAMPLE_C_B_V1_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4688
  { IMAGE_SAMPLE_C_B_V1_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4689
  { IMAGE_SAMPLE_C_B_V2_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4690
  { IMAGE_SAMPLE_C_B_V2_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4691
  { IMAGE_SAMPLE_C_B_V2_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4692
  { IMAGE_SAMPLE_C_B_V2_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4693
  { IMAGE_SAMPLE_C_B_V3_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4694
  { IMAGE_SAMPLE_C_B_V3_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4695
  { IMAGE_SAMPLE_C_B_V3_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4696
  { IMAGE_SAMPLE_C_B_V3_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4697
  { IMAGE_SAMPLE_C_B_V4_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4698
  { IMAGE_SAMPLE_C_B_V4_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4699
  { IMAGE_SAMPLE_C_B_V4_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4700
  { IMAGE_SAMPLE_C_B_V4_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4701
  { IMAGE_SAMPLE_C_B_V5_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4702
  { IMAGE_SAMPLE_C_B_V5_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4703
  { IMAGE_SAMPLE_C_B_V5_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4704
  { IMAGE_SAMPLE_C_B_V5_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4705
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4706
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4707
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4708
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4709
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4710
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4711
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4712
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4713
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4714
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4715
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4716
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4717
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4718
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4719
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4720
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4721
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4722
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4723
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4724
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4725
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4726
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4727
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4728
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4729
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4730
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4731
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4732
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4733
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4734
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4735
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4736
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4737
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4738
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4739
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4740
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4741
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4742
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4743
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4744
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4745
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4746
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4747
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4748
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4749
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4750
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4751
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4752
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4753
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 4754
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4755
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4756
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4757
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4758
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 4759
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4760
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4761
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4762
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4763
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 4764
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4765
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4766
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4767
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4768
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 4769
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4770
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4771
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4772
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4773
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 4774
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4775
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4776
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4777
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4778
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 4779
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4780
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4781
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4782
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 4783
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4784
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4785
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4786
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 4787
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4788
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4789
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4790
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 4791
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4792
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4793
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4794
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 4795
  { IMAGE_SAMPLE_C_B_CL_V1_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4796
  { IMAGE_SAMPLE_C_B_CL_V1_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4797
  { IMAGE_SAMPLE_C_B_CL_V1_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4798
  { IMAGE_SAMPLE_C_B_CL_V1_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4799
  { IMAGE_SAMPLE_C_B_CL_V1_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4800
  { IMAGE_SAMPLE_C_B_CL_V2_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4801
  { IMAGE_SAMPLE_C_B_CL_V2_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4802
  { IMAGE_SAMPLE_C_B_CL_V2_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4803
  { IMAGE_SAMPLE_C_B_CL_V2_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4804
  { IMAGE_SAMPLE_C_B_CL_V2_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4805
  { IMAGE_SAMPLE_C_B_CL_V3_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4806
  { IMAGE_SAMPLE_C_B_CL_V3_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4807
  { IMAGE_SAMPLE_C_B_CL_V3_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4808
  { IMAGE_SAMPLE_C_B_CL_V3_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4809
  { IMAGE_SAMPLE_C_B_CL_V3_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4810
  { IMAGE_SAMPLE_C_B_CL_V4_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4811
  { IMAGE_SAMPLE_C_B_CL_V4_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4812
  { IMAGE_SAMPLE_C_B_CL_V4_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4813
  { IMAGE_SAMPLE_C_B_CL_V4_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4814
  { IMAGE_SAMPLE_C_B_CL_V4_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4815
  { IMAGE_SAMPLE_C_B_CL_V5_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4816
  { IMAGE_SAMPLE_C_B_CL_V5_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4817
  { IMAGE_SAMPLE_C_B_CL_V5_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4818
  { IMAGE_SAMPLE_C_B_CL_V5_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4819
  { IMAGE_SAMPLE_C_B_CL_V5_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4820
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4821
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4822
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4823
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4824
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4825
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4826
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4827
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4828
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4829
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4830
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4831
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4832
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4833
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4834
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4835
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4836
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4837
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4838
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4839
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4840
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4841
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4842
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4843
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4844
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4845
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4846
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4847
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4848
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4849
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4850
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4851
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4852
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4853
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4854
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4855
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4856
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4857
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4858
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4859
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4860
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4861
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4862
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4863
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4864
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4865
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4866
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4867
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 4868
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 4869
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4870
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4871
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4872
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 4873
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 4874
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4875
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4876
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4877
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 4878
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 4879
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4880
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4881
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4882
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 4883
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 4884
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4885
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4886
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4887
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 4888
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 4889
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4890
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4891
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4892
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 4893
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 4894
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4895
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4896
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 4897
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 4898
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4899
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4900
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 4901
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 4902
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4903
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4904
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 4905
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 4906
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4907
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4908
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 4909
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 4910
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4911
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4912
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4913
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4914
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4915
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4916
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4917
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4918
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4919
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4920
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4921
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4922
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4923
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4924
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4925
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4926
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4927
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4928
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4929
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4930
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4931
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4932
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4933
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4934
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4935
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4936
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4937
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4938
  { IMAGE_SAMPLE_C_B_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4939
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4940
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4941
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4942
  { IMAGE_SAMPLE_C_B_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4943
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4944
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4945
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4946
  { IMAGE_SAMPLE_C_B_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4947
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4948
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4949
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4950
  { IMAGE_SAMPLE_C_B_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4951
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4952
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4953
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4954
  { IMAGE_SAMPLE_C_B_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4955
  { IMAGE_SAMPLE_C_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4956
  { IMAGE_SAMPLE_C_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4957
  { IMAGE_SAMPLE_C_B_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4958
  { IMAGE_SAMPLE_C_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4959
  { IMAGE_SAMPLE_C_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4960
  { IMAGE_SAMPLE_C_B_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4961
  { IMAGE_SAMPLE_C_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4962
  { IMAGE_SAMPLE_C_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4963
  { IMAGE_SAMPLE_C_B_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4964
  { IMAGE_SAMPLE_C_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4965
  { IMAGE_SAMPLE_C_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4966
  { IMAGE_SAMPLE_C_B_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4967
  { IMAGE_SAMPLE_C_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4968
  { IMAGE_SAMPLE_C_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4969
  { IMAGE_SAMPLE_C_B_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4970
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4971
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4972
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 4973
  { IMAGE_SAMPLE_C_B_O_V1_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4974
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4975
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4976
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 4977
  { IMAGE_SAMPLE_C_B_O_V2_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4978
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4979
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4980
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 4981
  { IMAGE_SAMPLE_C_B_O_V3_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4982
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4983
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4984
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 4985
  { IMAGE_SAMPLE_C_B_O_V4_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4986
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4987
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4988
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 4989
  { IMAGE_SAMPLE_C_B_O_V5_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4990
  { IMAGE_SAMPLE_C_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4991
  { IMAGE_SAMPLE_C_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4992
  { IMAGE_SAMPLE_C_B_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 4993
  { IMAGE_SAMPLE_C_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4994
  { IMAGE_SAMPLE_C_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4995
  { IMAGE_SAMPLE_C_B_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 4996
  { IMAGE_SAMPLE_C_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4997
  { IMAGE_SAMPLE_C_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4998
  { IMAGE_SAMPLE_C_B_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 4999
  { IMAGE_SAMPLE_C_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5000
  { IMAGE_SAMPLE_C_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5001
  { IMAGE_SAMPLE_C_B_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 5002
  { IMAGE_SAMPLE_C_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5003
  { IMAGE_SAMPLE_C_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5004
  { IMAGE_SAMPLE_C_B_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 5005
  { IMAGE_SAMPLE_C_B_O_V1_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5006
  { IMAGE_SAMPLE_C_B_O_V1_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5007
  { IMAGE_SAMPLE_C_B_O_V1_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5008
  { IMAGE_SAMPLE_C_B_O_V1_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5009
  { IMAGE_SAMPLE_C_B_O_V2_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5010
  { IMAGE_SAMPLE_C_B_O_V2_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5011
  { IMAGE_SAMPLE_C_B_O_V2_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5012
  { IMAGE_SAMPLE_C_B_O_V2_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5013
  { IMAGE_SAMPLE_C_B_O_V3_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5014
  { IMAGE_SAMPLE_C_B_O_V3_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5015
  { IMAGE_SAMPLE_C_B_O_V3_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5016
  { IMAGE_SAMPLE_C_B_O_V3_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5017
  { IMAGE_SAMPLE_C_B_O_V4_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5018
  { IMAGE_SAMPLE_C_B_O_V4_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5019
  { IMAGE_SAMPLE_C_B_O_V4_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5020
  { IMAGE_SAMPLE_C_B_O_V4_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5021
  { IMAGE_SAMPLE_C_B_O_V5_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5022
  { IMAGE_SAMPLE_C_B_O_V5_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5023
  { IMAGE_SAMPLE_C_B_O_V5_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5024
  { IMAGE_SAMPLE_C_B_O_V5_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5025
  { IMAGE_SAMPLE_C_CD_V1_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5026
  { IMAGE_SAMPLE_C_CD_V1_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5027
  { IMAGE_SAMPLE_C_CD_V1_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5028
  { IMAGE_SAMPLE_C_CD_V1_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5029
  { IMAGE_SAMPLE_C_CD_V1_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5030
  { IMAGE_SAMPLE_C_CD_V1_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5031
  { IMAGE_SAMPLE_C_CD_V1_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5032
  { IMAGE_SAMPLE_C_CD_V1_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5033
  { IMAGE_SAMPLE_C_CD_V2_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5034
  { IMAGE_SAMPLE_C_CD_V2_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5035
  { IMAGE_SAMPLE_C_CD_V2_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5036
  { IMAGE_SAMPLE_C_CD_V2_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5037
  { IMAGE_SAMPLE_C_CD_V2_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5038
  { IMAGE_SAMPLE_C_CD_V2_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5039
  { IMAGE_SAMPLE_C_CD_V2_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5040
  { IMAGE_SAMPLE_C_CD_V2_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5041
  { IMAGE_SAMPLE_C_CD_V3_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5042
  { IMAGE_SAMPLE_C_CD_V3_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5043
  { IMAGE_SAMPLE_C_CD_V3_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5044
  { IMAGE_SAMPLE_C_CD_V3_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5045
  { IMAGE_SAMPLE_C_CD_V3_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5046
  { IMAGE_SAMPLE_C_CD_V3_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5047
  { IMAGE_SAMPLE_C_CD_V3_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5048
  { IMAGE_SAMPLE_C_CD_V3_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5049
  { IMAGE_SAMPLE_C_CD_V4_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5050
  { IMAGE_SAMPLE_C_CD_V4_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5051
  { IMAGE_SAMPLE_C_CD_V4_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5052
  { IMAGE_SAMPLE_C_CD_V4_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5053
  { IMAGE_SAMPLE_C_CD_V4_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5054
  { IMAGE_SAMPLE_C_CD_V4_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5055
  { IMAGE_SAMPLE_C_CD_V4_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5056
  { IMAGE_SAMPLE_C_CD_V4_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5057
  { IMAGE_SAMPLE_C_CD_V5_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5058
  { IMAGE_SAMPLE_C_CD_V5_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5059
  { IMAGE_SAMPLE_C_CD_V5_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5060
  { IMAGE_SAMPLE_C_CD_V5_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5061
  { IMAGE_SAMPLE_C_CD_V5_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5062
  { IMAGE_SAMPLE_C_CD_V5_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5063
  { IMAGE_SAMPLE_C_CD_V5_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5064
  { IMAGE_SAMPLE_C_CD_V5_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5065
  { IMAGE_SAMPLE_C_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5066
  { IMAGE_SAMPLE_C_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5067
  { IMAGE_SAMPLE_C_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5068
  { IMAGE_SAMPLE_C_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5069
  { IMAGE_SAMPLE_C_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5070
  { IMAGE_SAMPLE_C_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5071
  { IMAGE_SAMPLE_C_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5072
  { IMAGE_SAMPLE_C_CD_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5073
  { IMAGE_SAMPLE_C_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5074
  { IMAGE_SAMPLE_C_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5075
  { IMAGE_SAMPLE_C_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5076
  { IMAGE_SAMPLE_C_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5077
  { IMAGE_SAMPLE_C_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5078
  { IMAGE_SAMPLE_C_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5079
  { IMAGE_SAMPLE_C_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5080
  { IMAGE_SAMPLE_C_CD_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5081
  { IMAGE_SAMPLE_C_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5082
  { IMAGE_SAMPLE_C_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5083
  { IMAGE_SAMPLE_C_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5084
  { IMAGE_SAMPLE_C_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5085
  { IMAGE_SAMPLE_C_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5086
  { IMAGE_SAMPLE_C_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5087
  { IMAGE_SAMPLE_C_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5088
  { IMAGE_SAMPLE_C_CD_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5089
  { IMAGE_SAMPLE_C_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5090
  { IMAGE_SAMPLE_C_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5091
  { IMAGE_SAMPLE_C_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5092
  { IMAGE_SAMPLE_C_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5093
  { IMAGE_SAMPLE_C_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5094
  { IMAGE_SAMPLE_C_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5095
  { IMAGE_SAMPLE_C_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5096
  { IMAGE_SAMPLE_C_CD_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5097
  { IMAGE_SAMPLE_C_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5098
  { IMAGE_SAMPLE_C_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5099
  { IMAGE_SAMPLE_C_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5100
  { IMAGE_SAMPLE_C_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5101
  { IMAGE_SAMPLE_C_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5102
  { IMAGE_SAMPLE_C_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5103
  { IMAGE_SAMPLE_C_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5104
  { IMAGE_SAMPLE_C_CD_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5105
  { IMAGE_SAMPLE_C_CD_V1_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5106
  { IMAGE_SAMPLE_C_CD_V1_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5107
  { IMAGE_SAMPLE_C_CD_V1_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5108
  { IMAGE_SAMPLE_C_CD_V1_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5109
  { IMAGE_SAMPLE_C_CD_V1_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5110
  { IMAGE_SAMPLE_C_CD_V1_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5111
  { IMAGE_SAMPLE_C_CD_V1_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5112
  { IMAGE_SAMPLE_C_CD_V1_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5113
  { IMAGE_SAMPLE_C_CD_V2_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5114
  { IMAGE_SAMPLE_C_CD_V2_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5115
  { IMAGE_SAMPLE_C_CD_V2_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5116
  { IMAGE_SAMPLE_C_CD_V2_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5117
  { IMAGE_SAMPLE_C_CD_V2_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5118
  { IMAGE_SAMPLE_C_CD_V2_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5119
  { IMAGE_SAMPLE_C_CD_V2_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5120
  { IMAGE_SAMPLE_C_CD_V2_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5121
  { IMAGE_SAMPLE_C_CD_V3_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5122
  { IMAGE_SAMPLE_C_CD_V3_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5123
  { IMAGE_SAMPLE_C_CD_V3_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5124
  { IMAGE_SAMPLE_C_CD_V3_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5125
  { IMAGE_SAMPLE_C_CD_V3_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5126
  { IMAGE_SAMPLE_C_CD_V3_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5127
  { IMAGE_SAMPLE_C_CD_V3_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5128
  { IMAGE_SAMPLE_C_CD_V3_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5129
  { IMAGE_SAMPLE_C_CD_V4_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5130
  { IMAGE_SAMPLE_C_CD_V4_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5131
  { IMAGE_SAMPLE_C_CD_V4_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5132
  { IMAGE_SAMPLE_C_CD_V4_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5133
  { IMAGE_SAMPLE_C_CD_V4_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5134
  { IMAGE_SAMPLE_C_CD_V4_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5135
  { IMAGE_SAMPLE_C_CD_V4_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5136
  { IMAGE_SAMPLE_C_CD_V4_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5137
  { IMAGE_SAMPLE_C_CD_V5_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5138
  { IMAGE_SAMPLE_C_CD_V5_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5139
  { IMAGE_SAMPLE_C_CD_V5_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5140
  { IMAGE_SAMPLE_C_CD_V5_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5141
  { IMAGE_SAMPLE_C_CD_V5_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5142
  { IMAGE_SAMPLE_C_CD_V5_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5143
  { IMAGE_SAMPLE_C_CD_V5_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5144
  { IMAGE_SAMPLE_C_CD_V5_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5145
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5146
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5147
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5148
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5149
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5150
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5151
  { IMAGE_SAMPLE_C_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5152
  { IMAGE_SAMPLE_C_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5153
  { IMAGE_SAMPLE_C_CD_CL_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5154
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5155
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5156
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5157
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5158
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5159
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5160
  { IMAGE_SAMPLE_C_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5161
  { IMAGE_SAMPLE_C_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5162
  { IMAGE_SAMPLE_C_CD_CL_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5163
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5164
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5165
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5166
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5167
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5168
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5169
  { IMAGE_SAMPLE_C_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5170
  { IMAGE_SAMPLE_C_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5171
  { IMAGE_SAMPLE_C_CD_CL_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5172
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5173
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5174
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5175
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5176
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5177
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5178
  { IMAGE_SAMPLE_C_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5179
  { IMAGE_SAMPLE_C_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5180
  { IMAGE_SAMPLE_C_CD_CL_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5181
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5182
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5183
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5184
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5185
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5186
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5187
  { IMAGE_SAMPLE_C_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5188
  { IMAGE_SAMPLE_C_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5189
  { IMAGE_SAMPLE_C_CD_CL_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5190
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5191
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5192
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5193
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5194
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5195
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5196
  { IMAGE_SAMPLE_C_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5197
  { IMAGE_SAMPLE_C_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5198
  { IMAGE_SAMPLE_C_CD_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5199
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5200
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5201
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5202
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5203
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5204
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5205
  { IMAGE_SAMPLE_C_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5206
  { IMAGE_SAMPLE_C_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5207
  { IMAGE_SAMPLE_C_CD_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5208
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5209
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5210
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5211
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5212
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5213
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5214
  { IMAGE_SAMPLE_C_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5215
  { IMAGE_SAMPLE_C_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5216
  { IMAGE_SAMPLE_C_CD_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5217
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5218
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5219
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5220
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5221
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5222
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5223
  { IMAGE_SAMPLE_C_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5224
  { IMAGE_SAMPLE_C_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5225
  { IMAGE_SAMPLE_C_CD_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5226
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5227
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5228
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5229
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5230
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5231
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5232
  { IMAGE_SAMPLE_C_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5233
  { IMAGE_SAMPLE_C_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5234
  { IMAGE_SAMPLE_C_CD_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5235
  { IMAGE_SAMPLE_C_CD_CL_V1_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5236
  { IMAGE_SAMPLE_C_CD_CL_V1_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5237
  { IMAGE_SAMPLE_C_CD_CL_V1_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5238
  { IMAGE_SAMPLE_C_CD_CL_V1_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5239
  { IMAGE_SAMPLE_C_CD_CL_V1_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5240
  { IMAGE_SAMPLE_C_CD_CL_V1_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5241
  { IMAGE_SAMPLE_C_CD_CL_V1_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5242
  { IMAGE_SAMPLE_C_CD_CL_V1_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5243
  { IMAGE_SAMPLE_C_CD_CL_V1_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5244
  { IMAGE_SAMPLE_C_CD_CL_V2_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5245
  { IMAGE_SAMPLE_C_CD_CL_V2_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5246
  { IMAGE_SAMPLE_C_CD_CL_V2_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5247
  { IMAGE_SAMPLE_C_CD_CL_V2_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5248
  { IMAGE_SAMPLE_C_CD_CL_V2_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5249
  { IMAGE_SAMPLE_C_CD_CL_V2_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5250
  { IMAGE_SAMPLE_C_CD_CL_V2_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5251
  { IMAGE_SAMPLE_C_CD_CL_V2_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5252
  { IMAGE_SAMPLE_C_CD_CL_V2_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5253
  { IMAGE_SAMPLE_C_CD_CL_V3_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5254
  { IMAGE_SAMPLE_C_CD_CL_V3_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5255
  { IMAGE_SAMPLE_C_CD_CL_V3_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5256
  { IMAGE_SAMPLE_C_CD_CL_V3_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5257
  { IMAGE_SAMPLE_C_CD_CL_V3_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5258
  { IMAGE_SAMPLE_C_CD_CL_V3_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5259
  { IMAGE_SAMPLE_C_CD_CL_V3_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5260
  { IMAGE_SAMPLE_C_CD_CL_V3_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5261
  { IMAGE_SAMPLE_C_CD_CL_V3_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5262
  { IMAGE_SAMPLE_C_CD_CL_V4_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5263
  { IMAGE_SAMPLE_C_CD_CL_V4_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5264
  { IMAGE_SAMPLE_C_CD_CL_V4_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5265
  { IMAGE_SAMPLE_C_CD_CL_V4_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5266
  { IMAGE_SAMPLE_C_CD_CL_V4_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5267
  { IMAGE_SAMPLE_C_CD_CL_V4_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5268
  { IMAGE_SAMPLE_C_CD_CL_V4_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5269
  { IMAGE_SAMPLE_C_CD_CL_V4_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5270
  { IMAGE_SAMPLE_C_CD_CL_V4_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5271
  { IMAGE_SAMPLE_C_CD_CL_V5_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5272
  { IMAGE_SAMPLE_C_CD_CL_V5_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5273
  { IMAGE_SAMPLE_C_CD_CL_V5_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5274
  { IMAGE_SAMPLE_C_CD_CL_V5_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5275
  { IMAGE_SAMPLE_C_CD_CL_V5_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5276
  { IMAGE_SAMPLE_C_CD_CL_V5_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5277
  { IMAGE_SAMPLE_C_CD_CL_V5_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5278
  { IMAGE_SAMPLE_C_CD_CL_V5_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5279
  { IMAGE_SAMPLE_C_CD_CL_V5_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5280
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5281
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5282
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5283
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5284
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5285
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5286
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5287
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5288
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5289
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5290
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5291
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5292
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5293
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5294
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5295
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5296
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5297
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5298
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5299
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5300
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5301
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5302
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5303
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5304
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5305
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5306
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5307
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5308
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5309
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5310
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5311
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5312
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5313
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5314
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5315
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5316
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5317
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5318
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5319
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5320
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5321
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5322
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5323
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5324
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5325
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5326
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5327
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5328
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5329
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5330
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5331
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5332
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5333
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5334
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5335
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5336
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5337
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5338
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5339
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5340
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5341
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5342
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5343
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5344
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5345
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5346
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5347
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5348
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5349
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5350
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5351
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5352
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5353
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5354
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5355
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5356
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5357
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5358
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5359
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5360
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5361
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5362
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5363
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5364
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5365
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5366
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5367
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5368
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5369
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5370
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5371
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5372
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5373
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5374
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5375
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5376
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5377
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5378
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5379
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5380
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5381
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5382
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5383
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5384
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5385
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5386
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5387
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5388
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5389
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5390
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5391
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5392
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5393
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xC, 0x1 }, // 5394
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5395
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5396
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5397
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5398
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5399
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5400
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5401
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5402
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xC, 0x1 }, // 5403
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5404
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5405
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5406
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5407
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5408
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5409
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5410
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5411
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xC, 0x1 }, // 5412
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5413
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5414
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5415
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5416
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5417
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5418
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5419
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5420
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 5421
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5422
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5423
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5424
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5425
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5426
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5427
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5428
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5429
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xC, 0x1 }, // 5430
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5431
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5432
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5433
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5434
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5435
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5436
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5437
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5438
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xC, 0xC }, // 5439
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5440
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5441
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5442
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5443
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5444
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5445
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5446
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5447
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xC, 0xC }, // 5448
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5449
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5450
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5451
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5452
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5453
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5454
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5455
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5456
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xC, 0xC }, // 5457
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5458
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5459
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5460
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5461
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5462
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5463
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5464
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5465
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 5466
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5467
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5468
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5469
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5470
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5471
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5472
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5473
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5474
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xC, 0xC }, // 5475
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5476
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5477
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5478
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5479
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5480
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5481
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5482
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5483
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xC, 0x1 }, // 5484
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5485
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5486
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5487
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5488
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5489
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5490
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5491
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5492
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xC, 0x1 }, // 5493
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5494
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5495
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5496
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5497
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5498
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5499
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5500
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5501
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xC, 0x1 }, // 5502
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5503
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5504
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5505
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5506
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5507
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5508
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5509
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5510
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xC, 0x1 }, // 5511
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5512
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5513
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5514
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5515
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5516
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5517
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5518
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5519
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xC, 0x1 }, // 5520
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5521
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5522
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5523
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5524
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5525
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5526
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5527
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5528
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5529
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5530
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5531
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5532
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5533
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5534
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5535
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5536
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5537
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5538
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5539
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5540
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5541
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5542
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5543
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5544
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5545
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5546
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5547
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5548
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5549
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5550
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5551
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5552
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5553
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5554
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5555
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5556
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5557
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5558
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5559
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5560
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5561
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5562
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5563
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5564
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5565
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5566
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5567
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5568
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5569
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5570
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5571
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5572
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5573
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5574
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5575
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5576
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5577
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5578
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5579
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5580
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5581
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5582
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5583
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5584
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5585
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5586
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5587
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5588
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5589
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5590
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5591
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5592
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5593
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5594
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5595
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5596
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5597
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5598
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5599
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5600
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5601
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5602
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5603
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5604
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5605
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5606
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5607
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5608
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5609
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5610
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5611
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5612
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5613
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5614
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5615
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5616
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5617
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5618
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5619
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5620
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5621
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5622
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5623
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5624
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5625
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5626
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5627
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5628
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5629
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5630
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5631
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5632
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5633
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5634
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5635
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5636
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5637
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5638
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5639
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5640
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5641
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5642
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5643
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5644
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5645
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5646
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5647
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5648
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5649
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5650
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5651
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5652
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5653
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5654
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5655
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5656
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5657
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5658
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5659
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5660
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5661
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5662
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5663
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5664
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5665
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5666
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5667
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5668
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5669
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5670
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5671
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5672
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5673
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5674
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5675
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5676
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5677
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5678
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5679
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5680
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5681
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5682
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5683
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5684
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5685
  { IMAGE_SAMPLE_C_CD_G16_V1_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5686
  { IMAGE_SAMPLE_C_CD_G16_V1_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5687
  { IMAGE_SAMPLE_C_CD_G16_V1_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5688
  { IMAGE_SAMPLE_C_CD_G16_V1_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5689
  { IMAGE_SAMPLE_C_CD_G16_V1_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5690
  { IMAGE_SAMPLE_C_CD_G16_V1_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5691
  { IMAGE_SAMPLE_C_CD_G16_V2_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5692
  { IMAGE_SAMPLE_C_CD_G16_V2_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5693
  { IMAGE_SAMPLE_C_CD_G16_V2_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5694
  { IMAGE_SAMPLE_C_CD_G16_V2_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5695
  { IMAGE_SAMPLE_C_CD_G16_V2_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5696
  { IMAGE_SAMPLE_C_CD_G16_V2_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5697
  { IMAGE_SAMPLE_C_CD_G16_V3_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5698
  { IMAGE_SAMPLE_C_CD_G16_V3_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5699
  { IMAGE_SAMPLE_C_CD_G16_V3_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5700
  { IMAGE_SAMPLE_C_CD_G16_V3_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5701
  { IMAGE_SAMPLE_C_CD_G16_V3_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5702
  { IMAGE_SAMPLE_C_CD_G16_V3_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5703
  { IMAGE_SAMPLE_C_CD_G16_V4_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5704
  { IMAGE_SAMPLE_C_CD_G16_V4_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5705
  { IMAGE_SAMPLE_C_CD_G16_V4_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5706
  { IMAGE_SAMPLE_C_CD_G16_V4_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5707
  { IMAGE_SAMPLE_C_CD_G16_V4_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5708
  { IMAGE_SAMPLE_C_CD_G16_V4_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5709
  { IMAGE_SAMPLE_C_CD_G16_V5_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5710
  { IMAGE_SAMPLE_C_CD_G16_V5_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5711
  { IMAGE_SAMPLE_C_CD_G16_V5_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5712
  { IMAGE_SAMPLE_C_CD_G16_V5_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5713
  { IMAGE_SAMPLE_C_CD_G16_V5_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5714
  { IMAGE_SAMPLE_C_CD_G16_V5_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5715
  { IMAGE_SAMPLE_C_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5716
  { IMAGE_SAMPLE_C_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5717
  { IMAGE_SAMPLE_C_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5718
  { IMAGE_SAMPLE_C_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5719
  { IMAGE_SAMPLE_C_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5720
  { IMAGE_SAMPLE_C_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5721
  { IMAGE_SAMPLE_C_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5722
  { IMAGE_SAMPLE_C_CD_O_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5723
  { IMAGE_SAMPLE_C_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5724
  { IMAGE_SAMPLE_C_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5725
  { IMAGE_SAMPLE_C_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5726
  { IMAGE_SAMPLE_C_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5727
  { IMAGE_SAMPLE_C_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5728
  { IMAGE_SAMPLE_C_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5729
  { IMAGE_SAMPLE_C_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5730
  { IMAGE_SAMPLE_C_CD_O_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5731
  { IMAGE_SAMPLE_C_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5732
  { IMAGE_SAMPLE_C_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5733
  { IMAGE_SAMPLE_C_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5734
  { IMAGE_SAMPLE_C_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5735
  { IMAGE_SAMPLE_C_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5736
  { IMAGE_SAMPLE_C_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5737
  { IMAGE_SAMPLE_C_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5738
  { IMAGE_SAMPLE_C_CD_O_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5739
  { IMAGE_SAMPLE_C_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5740
  { IMAGE_SAMPLE_C_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5741
  { IMAGE_SAMPLE_C_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5742
  { IMAGE_SAMPLE_C_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5743
  { IMAGE_SAMPLE_C_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5744
  { IMAGE_SAMPLE_C_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5745
  { IMAGE_SAMPLE_C_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5746
  { IMAGE_SAMPLE_C_CD_O_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5747
  { IMAGE_SAMPLE_C_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5748
  { IMAGE_SAMPLE_C_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5749
  { IMAGE_SAMPLE_C_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5750
  { IMAGE_SAMPLE_C_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5751
  { IMAGE_SAMPLE_C_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5752
  { IMAGE_SAMPLE_C_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5753
  { IMAGE_SAMPLE_C_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5754
  { IMAGE_SAMPLE_C_CD_O_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5755
  { IMAGE_SAMPLE_C_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5756
  { IMAGE_SAMPLE_C_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5757
  { IMAGE_SAMPLE_C_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5758
  { IMAGE_SAMPLE_C_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5759
  { IMAGE_SAMPLE_C_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5760
  { IMAGE_SAMPLE_C_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5761
  { IMAGE_SAMPLE_C_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5762
  { IMAGE_SAMPLE_C_CD_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5763
  { IMAGE_SAMPLE_C_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5764
  { IMAGE_SAMPLE_C_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5765
  { IMAGE_SAMPLE_C_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5766
  { IMAGE_SAMPLE_C_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5767
  { IMAGE_SAMPLE_C_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5768
  { IMAGE_SAMPLE_C_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5769
  { IMAGE_SAMPLE_C_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5770
  { IMAGE_SAMPLE_C_CD_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5771
  { IMAGE_SAMPLE_C_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5772
  { IMAGE_SAMPLE_C_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5773
  { IMAGE_SAMPLE_C_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5774
  { IMAGE_SAMPLE_C_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5775
  { IMAGE_SAMPLE_C_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5776
  { IMAGE_SAMPLE_C_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5777
  { IMAGE_SAMPLE_C_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5778
  { IMAGE_SAMPLE_C_CD_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5779
  { IMAGE_SAMPLE_C_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5780
  { IMAGE_SAMPLE_C_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5781
  { IMAGE_SAMPLE_C_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5782
  { IMAGE_SAMPLE_C_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5783
  { IMAGE_SAMPLE_C_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5784
  { IMAGE_SAMPLE_C_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5785
  { IMAGE_SAMPLE_C_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5786
  { IMAGE_SAMPLE_C_CD_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5787
  { IMAGE_SAMPLE_C_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5788
  { IMAGE_SAMPLE_C_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5789
  { IMAGE_SAMPLE_C_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5790
  { IMAGE_SAMPLE_C_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5791
  { IMAGE_SAMPLE_C_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5792
  { IMAGE_SAMPLE_C_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5793
  { IMAGE_SAMPLE_C_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5794
  { IMAGE_SAMPLE_C_CD_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5795
  { IMAGE_SAMPLE_C_CD_O_V1_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5796
  { IMAGE_SAMPLE_C_CD_O_V1_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5797
  { IMAGE_SAMPLE_C_CD_O_V1_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5798
  { IMAGE_SAMPLE_C_CD_O_V1_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5799
  { IMAGE_SAMPLE_C_CD_O_V1_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5800
  { IMAGE_SAMPLE_C_CD_O_V1_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5801
  { IMAGE_SAMPLE_C_CD_O_V1_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5802
  { IMAGE_SAMPLE_C_CD_O_V1_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5803
  { IMAGE_SAMPLE_C_CD_O_V2_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5804
  { IMAGE_SAMPLE_C_CD_O_V2_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5805
  { IMAGE_SAMPLE_C_CD_O_V2_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5806
  { IMAGE_SAMPLE_C_CD_O_V2_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5807
  { IMAGE_SAMPLE_C_CD_O_V2_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5808
  { IMAGE_SAMPLE_C_CD_O_V2_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5809
  { IMAGE_SAMPLE_C_CD_O_V2_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5810
  { IMAGE_SAMPLE_C_CD_O_V2_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5811
  { IMAGE_SAMPLE_C_CD_O_V3_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5812
  { IMAGE_SAMPLE_C_CD_O_V3_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5813
  { IMAGE_SAMPLE_C_CD_O_V3_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5814
  { IMAGE_SAMPLE_C_CD_O_V3_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5815
  { IMAGE_SAMPLE_C_CD_O_V3_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5816
  { IMAGE_SAMPLE_C_CD_O_V3_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5817
  { IMAGE_SAMPLE_C_CD_O_V3_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5818
  { IMAGE_SAMPLE_C_CD_O_V3_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5819
  { IMAGE_SAMPLE_C_CD_O_V4_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5820
  { IMAGE_SAMPLE_C_CD_O_V4_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5821
  { IMAGE_SAMPLE_C_CD_O_V4_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5822
  { IMAGE_SAMPLE_C_CD_O_V4_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5823
  { IMAGE_SAMPLE_C_CD_O_V4_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5824
  { IMAGE_SAMPLE_C_CD_O_V4_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5825
  { IMAGE_SAMPLE_C_CD_O_V4_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5826
  { IMAGE_SAMPLE_C_CD_O_V4_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5827
  { IMAGE_SAMPLE_C_CD_O_V5_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5828
  { IMAGE_SAMPLE_C_CD_O_V5_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5829
  { IMAGE_SAMPLE_C_CD_O_V5_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5830
  { IMAGE_SAMPLE_C_CD_O_V5_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5831
  { IMAGE_SAMPLE_C_CD_O_V5_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5832
  { IMAGE_SAMPLE_C_CD_O_V5_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5833
  { IMAGE_SAMPLE_C_CD_O_V5_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5834
  { IMAGE_SAMPLE_C_CD_O_V5_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5835
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5836
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5837
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5838
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5839
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5840
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5841
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5842
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5843
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5844
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5845
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5846
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5847
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5848
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5849
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5850
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5851
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5852
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5853
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5854
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5855
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5856
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5857
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5858
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5859
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5860
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5861
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5862
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5863
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5864
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5865
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5866
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5867
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5868
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5869
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5870
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5871
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5872
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5873
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5874
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5875
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5876
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5877
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5878
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5879
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5880
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5881
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5882
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5883
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5884
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5885
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5886
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5887
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5888
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5889
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5890
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5891
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5892
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5893
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5894
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5895
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5896
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5897
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5898
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5899
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5900
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5901
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5902
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5903
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5904
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5905
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5906
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5907
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5908
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5909
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5910
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5911
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5912
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5913
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5914
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5915
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5916
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5917
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5918
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5919
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5920
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5921
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5922
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5923
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5924
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5925
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5926
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5927
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5928
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5929
  { IMAGE_SAMPLE_C_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5930
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5931
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5932
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5933
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5934
  { IMAGE_SAMPLE_C_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5935
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5936
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5937
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5938
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5939
  { IMAGE_SAMPLE_C_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5940
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5941
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5942
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5943
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5944
  { IMAGE_SAMPLE_C_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5945
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5946
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5947
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5948
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5949
  { IMAGE_SAMPLE_C_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5950
  { IMAGE_SAMPLE_C_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5951
  { IMAGE_SAMPLE_C_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5952
  { IMAGE_SAMPLE_C_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5953
  { IMAGE_SAMPLE_C_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5954
  { IMAGE_SAMPLE_C_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5955
  { IMAGE_SAMPLE_C_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5956
  { IMAGE_SAMPLE_C_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5957
  { IMAGE_SAMPLE_C_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5958
  { IMAGE_SAMPLE_C_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5959
  { IMAGE_SAMPLE_C_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5960
  { IMAGE_SAMPLE_C_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5961
  { IMAGE_SAMPLE_C_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5962
  { IMAGE_SAMPLE_C_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5963
  { IMAGE_SAMPLE_C_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5964
  { IMAGE_SAMPLE_C_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5965
  { IMAGE_SAMPLE_C_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5966
  { IMAGE_SAMPLE_C_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5967
  { IMAGE_SAMPLE_C_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5968
  { IMAGE_SAMPLE_C_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5969
  { IMAGE_SAMPLE_C_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5970
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 5971
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5972
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5973
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5974
  { IMAGE_SAMPLE_C_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5975
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 5976
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5977
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5978
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5979
  { IMAGE_SAMPLE_C_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5980
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 5981
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5982
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5983
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5984
  { IMAGE_SAMPLE_C_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5985
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5986
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5987
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5988
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5989
  { IMAGE_SAMPLE_C_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5990
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5991
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5992
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5993
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5994
  { IMAGE_SAMPLE_C_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5995
  { IMAGE_SAMPLE_C_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5996
  { IMAGE_SAMPLE_C_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5997
  { IMAGE_SAMPLE_C_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5998
  { IMAGE_SAMPLE_C_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5999
  { IMAGE_SAMPLE_C_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 6000
  { IMAGE_SAMPLE_C_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6001
  { IMAGE_SAMPLE_C_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6002
  { IMAGE_SAMPLE_C_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6003
  { IMAGE_SAMPLE_C_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 6004
  { IMAGE_SAMPLE_C_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6005
  { IMAGE_SAMPLE_C_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6006
  { IMAGE_SAMPLE_C_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6007
  { IMAGE_SAMPLE_C_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 6008
  { IMAGE_SAMPLE_C_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6009
  { IMAGE_SAMPLE_C_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6010
  { IMAGE_SAMPLE_C_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6011
  { IMAGE_SAMPLE_C_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 6012
  { IMAGE_SAMPLE_C_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6013
  { IMAGE_SAMPLE_C_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6014
  { IMAGE_SAMPLE_C_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6015
  { IMAGE_SAMPLE_C_CL_V1_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 6016
  { IMAGE_SAMPLE_C_CL_V1_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6017
  { IMAGE_SAMPLE_C_CL_V1_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6018
  { IMAGE_SAMPLE_C_CL_V1_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6019
  { IMAGE_SAMPLE_C_CL_V1_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6020
  { IMAGE_SAMPLE_C_CL_V2_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 6021
  { IMAGE_SAMPLE_C_CL_V2_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6022
  { IMAGE_SAMPLE_C_CL_V2_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6023
  { IMAGE_SAMPLE_C_CL_V2_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6024
  { IMAGE_SAMPLE_C_CL_V2_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6025
  { IMAGE_SAMPLE_C_CL_V3_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 6026
  { IMAGE_SAMPLE_C_CL_V3_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6027
  { IMAGE_SAMPLE_C_CL_V3_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6028
  { IMAGE_SAMPLE_C_CL_V3_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6029
  { IMAGE_SAMPLE_C_CL_V3_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6030
  { IMAGE_SAMPLE_C_CL_V4_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 6031
  { IMAGE_SAMPLE_C_CL_V4_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6032
  { IMAGE_SAMPLE_C_CL_V4_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6033
  { IMAGE_SAMPLE_C_CL_V4_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6034
  { IMAGE_SAMPLE_C_CL_V4_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6035
  { IMAGE_SAMPLE_C_CL_V5_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 6036
  { IMAGE_SAMPLE_C_CL_V5_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6037
  { IMAGE_SAMPLE_C_CL_V5_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6038
  { IMAGE_SAMPLE_C_CL_V5_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6039
  { IMAGE_SAMPLE_C_CL_V5_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6040
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6041
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6042
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6043
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6044
  { IMAGE_SAMPLE_C_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6045
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6046
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6047
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6048
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6049
  { IMAGE_SAMPLE_C_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6050
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6051
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6052
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6053
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6054
  { IMAGE_SAMPLE_C_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6055
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6056
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6057
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6058
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6059
  { IMAGE_SAMPLE_C_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6060
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6061
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6062
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6063
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6064
  { IMAGE_SAMPLE_C_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6065
  { IMAGE_SAMPLE_C_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6066
  { IMAGE_SAMPLE_C_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6067
  { IMAGE_SAMPLE_C_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6068
  { IMAGE_SAMPLE_C_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6069
  { IMAGE_SAMPLE_C_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6070
  { IMAGE_SAMPLE_C_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6071
  { IMAGE_SAMPLE_C_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6072
  { IMAGE_SAMPLE_C_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6073
  { IMAGE_SAMPLE_C_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6074
  { IMAGE_SAMPLE_C_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6075
  { IMAGE_SAMPLE_C_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6076
  { IMAGE_SAMPLE_C_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6077
  { IMAGE_SAMPLE_C_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6078
  { IMAGE_SAMPLE_C_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6079
  { IMAGE_SAMPLE_C_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6080
  { IMAGE_SAMPLE_C_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6081
  { IMAGE_SAMPLE_C_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6082
  { IMAGE_SAMPLE_C_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6083
  { IMAGE_SAMPLE_C_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6084
  { IMAGE_SAMPLE_C_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6085
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6086
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6087
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6088
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6089
  { IMAGE_SAMPLE_C_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6090
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6091
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6092
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6093
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6094
  { IMAGE_SAMPLE_C_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6095
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6096
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6097
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6098
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6099
  { IMAGE_SAMPLE_C_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6100
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6101
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6102
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6103
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6104
  { IMAGE_SAMPLE_C_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6105
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6106
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6107
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6108
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6109
  { IMAGE_SAMPLE_C_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6110
  { IMAGE_SAMPLE_C_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6111
  { IMAGE_SAMPLE_C_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6112
  { IMAGE_SAMPLE_C_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6113
  { IMAGE_SAMPLE_C_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6114
  { IMAGE_SAMPLE_C_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6115
  { IMAGE_SAMPLE_C_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6116
  { IMAGE_SAMPLE_C_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6117
  { IMAGE_SAMPLE_C_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6118
  { IMAGE_SAMPLE_C_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6119
  { IMAGE_SAMPLE_C_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6120
  { IMAGE_SAMPLE_C_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6121
  { IMAGE_SAMPLE_C_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6122
  { IMAGE_SAMPLE_C_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6123
  { IMAGE_SAMPLE_C_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6124
  { IMAGE_SAMPLE_C_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6125
  { IMAGE_SAMPLE_C_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6126
  { IMAGE_SAMPLE_C_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6127
  { IMAGE_SAMPLE_C_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6128
  { IMAGE_SAMPLE_C_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6129
  { IMAGE_SAMPLE_C_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6130
  { IMAGE_SAMPLE_C_CL_O_V1_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6131
  { IMAGE_SAMPLE_C_CL_O_V1_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6132
  { IMAGE_SAMPLE_C_CL_O_V1_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6133
  { IMAGE_SAMPLE_C_CL_O_V1_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6134
  { IMAGE_SAMPLE_C_CL_O_V1_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6135
  { IMAGE_SAMPLE_C_CL_O_V2_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6136
  { IMAGE_SAMPLE_C_CL_O_V2_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6137
  { IMAGE_SAMPLE_C_CL_O_V2_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6138
  { IMAGE_SAMPLE_C_CL_O_V2_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6139
  { IMAGE_SAMPLE_C_CL_O_V2_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6140
  { IMAGE_SAMPLE_C_CL_O_V3_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6141
  { IMAGE_SAMPLE_C_CL_O_V3_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6142
  { IMAGE_SAMPLE_C_CL_O_V3_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6143
  { IMAGE_SAMPLE_C_CL_O_V3_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6144
  { IMAGE_SAMPLE_C_CL_O_V3_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6145
  { IMAGE_SAMPLE_C_CL_O_V4_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6146
  { IMAGE_SAMPLE_C_CL_O_V4_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6147
  { IMAGE_SAMPLE_C_CL_O_V4_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6148
  { IMAGE_SAMPLE_C_CL_O_V4_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6149
  { IMAGE_SAMPLE_C_CL_O_V4_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6150
  { IMAGE_SAMPLE_C_CL_O_V5_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6151
  { IMAGE_SAMPLE_C_CL_O_V5_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6152
  { IMAGE_SAMPLE_C_CL_O_V5_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6153
  { IMAGE_SAMPLE_C_CL_O_V5_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6154
  { IMAGE_SAMPLE_C_CL_O_V5_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6155
  { IMAGE_SAMPLE_C_D_V1_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6156
  { IMAGE_SAMPLE_C_D_V1_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6157
  { IMAGE_SAMPLE_C_D_V1_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6158
  { IMAGE_SAMPLE_C_D_V1_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6159
  { IMAGE_SAMPLE_C_D_V1_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6160
  { IMAGE_SAMPLE_C_D_V1_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6161
  { IMAGE_SAMPLE_C_D_V1_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6162
  { IMAGE_SAMPLE_C_D_V1_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6163
  { IMAGE_SAMPLE_C_D_V2_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6164
  { IMAGE_SAMPLE_C_D_V2_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6165
  { IMAGE_SAMPLE_C_D_V2_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6166
  { IMAGE_SAMPLE_C_D_V2_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6167
  { IMAGE_SAMPLE_C_D_V2_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6168
  { IMAGE_SAMPLE_C_D_V2_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6169
  { IMAGE_SAMPLE_C_D_V2_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6170
  { IMAGE_SAMPLE_C_D_V2_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6171
  { IMAGE_SAMPLE_C_D_V3_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6172
  { IMAGE_SAMPLE_C_D_V3_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6173
  { IMAGE_SAMPLE_C_D_V3_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6174
  { IMAGE_SAMPLE_C_D_V3_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6175
  { IMAGE_SAMPLE_C_D_V3_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6176
  { IMAGE_SAMPLE_C_D_V3_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6177
  { IMAGE_SAMPLE_C_D_V3_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6178
  { IMAGE_SAMPLE_C_D_V3_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6179
  { IMAGE_SAMPLE_C_D_V4_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6180
  { IMAGE_SAMPLE_C_D_V4_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6181
  { IMAGE_SAMPLE_C_D_V4_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6182
  { IMAGE_SAMPLE_C_D_V4_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6183
  { IMAGE_SAMPLE_C_D_V4_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6184
  { IMAGE_SAMPLE_C_D_V4_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6185
  { IMAGE_SAMPLE_C_D_V4_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6186
  { IMAGE_SAMPLE_C_D_V4_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6187
  { IMAGE_SAMPLE_C_D_V5_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6188
  { IMAGE_SAMPLE_C_D_V5_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6189
  { IMAGE_SAMPLE_C_D_V5_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6190
  { IMAGE_SAMPLE_C_D_V5_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6191
  { IMAGE_SAMPLE_C_D_V5_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6192
  { IMAGE_SAMPLE_C_D_V5_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6193
  { IMAGE_SAMPLE_C_D_V5_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6194
  { IMAGE_SAMPLE_C_D_V5_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6195
  { IMAGE_SAMPLE_C_D_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6196
  { IMAGE_SAMPLE_C_D_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6197
  { IMAGE_SAMPLE_C_D_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6198
  { IMAGE_SAMPLE_C_D_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6199
  { IMAGE_SAMPLE_C_D_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6200
  { IMAGE_SAMPLE_C_D_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6201
  { IMAGE_SAMPLE_C_D_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6202
  { IMAGE_SAMPLE_C_D_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6203
  { IMAGE_SAMPLE_C_D_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6204
  { IMAGE_SAMPLE_C_D_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6205
  { IMAGE_SAMPLE_C_D_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6206
  { IMAGE_SAMPLE_C_D_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6207
  { IMAGE_SAMPLE_C_D_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6208
  { IMAGE_SAMPLE_C_D_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6209
  { IMAGE_SAMPLE_C_D_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6210
  { IMAGE_SAMPLE_C_D_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6211
  { IMAGE_SAMPLE_C_D_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6212
  { IMAGE_SAMPLE_C_D_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6213
  { IMAGE_SAMPLE_C_D_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6214
  { IMAGE_SAMPLE_C_D_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6215
  { IMAGE_SAMPLE_C_D_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6216
  { IMAGE_SAMPLE_C_D_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6217
  { IMAGE_SAMPLE_C_D_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6218
  { IMAGE_SAMPLE_C_D_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6219
  { IMAGE_SAMPLE_C_D_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6220
  { IMAGE_SAMPLE_C_D_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6221
  { IMAGE_SAMPLE_C_D_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6222
  { IMAGE_SAMPLE_C_D_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6223
  { IMAGE_SAMPLE_C_D_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6224
  { IMAGE_SAMPLE_C_D_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6225
  { IMAGE_SAMPLE_C_D_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6226
  { IMAGE_SAMPLE_C_D_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6227
  { IMAGE_SAMPLE_C_D_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6228
  { IMAGE_SAMPLE_C_D_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6229
  { IMAGE_SAMPLE_C_D_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6230
  { IMAGE_SAMPLE_C_D_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6231
  { IMAGE_SAMPLE_C_D_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6232
  { IMAGE_SAMPLE_C_D_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6233
  { IMAGE_SAMPLE_C_D_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6234
  { IMAGE_SAMPLE_C_D_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6235
  { IMAGE_SAMPLE_C_D_V1_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6236
  { IMAGE_SAMPLE_C_D_V1_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6237
  { IMAGE_SAMPLE_C_D_V1_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6238
  { IMAGE_SAMPLE_C_D_V1_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6239
  { IMAGE_SAMPLE_C_D_V1_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6240
  { IMAGE_SAMPLE_C_D_V1_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6241
  { IMAGE_SAMPLE_C_D_V1_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 6242
  { IMAGE_SAMPLE_C_D_V1_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 6243
  { IMAGE_SAMPLE_C_D_V2_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6244
  { IMAGE_SAMPLE_C_D_V2_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6245
  { IMAGE_SAMPLE_C_D_V2_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6246
  { IMAGE_SAMPLE_C_D_V2_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6247
  { IMAGE_SAMPLE_C_D_V2_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6248
  { IMAGE_SAMPLE_C_D_V2_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6249
  { IMAGE_SAMPLE_C_D_V2_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 6250
  { IMAGE_SAMPLE_C_D_V2_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 6251
  { IMAGE_SAMPLE_C_D_V3_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6252
  { IMAGE_SAMPLE_C_D_V3_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6253
  { IMAGE_SAMPLE_C_D_V3_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6254
  { IMAGE_SAMPLE_C_D_V3_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6255
  { IMAGE_SAMPLE_C_D_V3_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6256
  { IMAGE_SAMPLE_C_D_V3_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6257
  { IMAGE_SAMPLE_C_D_V3_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 6258
  { IMAGE_SAMPLE_C_D_V3_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 6259
  { IMAGE_SAMPLE_C_D_V4_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6260
  { IMAGE_SAMPLE_C_D_V4_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6261
  { IMAGE_SAMPLE_C_D_V4_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6262
  { IMAGE_SAMPLE_C_D_V4_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6263
  { IMAGE_SAMPLE_C_D_V4_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6264
  { IMAGE_SAMPLE_C_D_V4_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6265
  { IMAGE_SAMPLE_C_D_V4_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 6266
  { IMAGE_SAMPLE_C_D_V4_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 6267
  { IMAGE_SAMPLE_C_D_V5_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6268
  { IMAGE_SAMPLE_C_D_V5_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6269
  { IMAGE_SAMPLE_C_D_V5_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6270
  { IMAGE_SAMPLE_C_D_V5_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6271
  { IMAGE_SAMPLE_C_D_V5_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 6272
  { IMAGE_SAMPLE_C_D_V5_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6273
  { IMAGE_SAMPLE_C_D_V5_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 6274
  { IMAGE_SAMPLE_C_D_V5_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 6275
  { IMAGE_SAMPLE_C_D_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6276
  { IMAGE_SAMPLE_C_D_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6277
  { IMAGE_SAMPLE_C_D_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6278
  { IMAGE_SAMPLE_C_D_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6279
  { IMAGE_SAMPLE_C_D_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 6280
  { IMAGE_SAMPLE_C_D_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 6281
  { IMAGE_SAMPLE_C_D_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 6282
  { IMAGE_SAMPLE_C_D_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 6283
  { IMAGE_SAMPLE_C_D_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6284
  { IMAGE_SAMPLE_C_D_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6285
  { IMAGE_SAMPLE_C_D_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6286
  { IMAGE_SAMPLE_C_D_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6287
  { IMAGE_SAMPLE_C_D_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 6288
  { IMAGE_SAMPLE_C_D_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 6289
  { IMAGE_SAMPLE_C_D_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 6290
  { IMAGE_SAMPLE_C_D_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 6291
  { IMAGE_SAMPLE_C_D_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6292
  { IMAGE_SAMPLE_C_D_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6293
  { IMAGE_SAMPLE_C_D_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6294
  { IMAGE_SAMPLE_C_D_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6295
  { IMAGE_SAMPLE_C_D_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 6296
  { IMAGE_SAMPLE_C_D_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 6297
  { IMAGE_SAMPLE_C_D_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 6298
  { IMAGE_SAMPLE_C_D_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 6299
  { IMAGE_SAMPLE_C_D_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6300
  { IMAGE_SAMPLE_C_D_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6301
  { IMAGE_SAMPLE_C_D_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6302
  { IMAGE_SAMPLE_C_D_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6303
  { IMAGE_SAMPLE_C_D_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 6304
  { IMAGE_SAMPLE_C_D_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 6305
  { IMAGE_SAMPLE_C_D_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 6306
  { IMAGE_SAMPLE_C_D_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 6307
  { IMAGE_SAMPLE_C_D_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6308
  { IMAGE_SAMPLE_C_D_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6309
  { IMAGE_SAMPLE_C_D_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6310
  { IMAGE_SAMPLE_C_D_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6311
  { IMAGE_SAMPLE_C_D_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 6312
  { IMAGE_SAMPLE_C_D_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 6313
  { IMAGE_SAMPLE_C_D_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 6314
  { IMAGE_SAMPLE_C_D_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 6315
  { IMAGE_SAMPLE_C_D_V1_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6316
  { IMAGE_SAMPLE_C_D_V1_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6317
  { IMAGE_SAMPLE_C_D_V1_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6318
  { IMAGE_SAMPLE_C_D_V1_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6319
  { IMAGE_SAMPLE_C_D_V1_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6320
  { IMAGE_SAMPLE_C_D_V1_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6321
  { IMAGE_SAMPLE_C_D_V1_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6322
  { IMAGE_SAMPLE_C_D_V1_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6323
  { IMAGE_SAMPLE_C_D_V2_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6324
  { IMAGE_SAMPLE_C_D_V2_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6325
  { IMAGE_SAMPLE_C_D_V2_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6326
  { IMAGE_SAMPLE_C_D_V2_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6327
  { IMAGE_SAMPLE_C_D_V2_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6328
  { IMAGE_SAMPLE_C_D_V2_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6329
  { IMAGE_SAMPLE_C_D_V2_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6330
  { IMAGE_SAMPLE_C_D_V2_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6331
  { IMAGE_SAMPLE_C_D_V3_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6332
  { IMAGE_SAMPLE_C_D_V3_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6333
  { IMAGE_SAMPLE_C_D_V3_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6334
  { IMAGE_SAMPLE_C_D_V3_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6335
  { IMAGE_SAMPLE_C_D_V3_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6336
  { IMAGE_SAMPLE_C_D_V3_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6337
  { IMAGE_SAMPLE_C_D_V3_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6338
  { IMAGE_SAMPLE_C_D_V3_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6339
  { IMAGE_SAMPLE_C_D_V4_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6340
  { IMAGE_SAMPLE_C_D_V4_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6341
  { IMAGE_SAMPLE_C_D_V4_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6342
  { IMAGE_SAMPLE_C_D_V4_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6343
  { IMAGE_SAMPLE_C_D_V4_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6344
  { IMAGE_SAMPLE_C_D_V4_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6345
  { IMAGE_SAMPLE_C_D_V4_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6346
  { IMAGE_SAMPLE_C_D_V4_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6347
  { IMAGE_SAMPLE_C_D_V5_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6348
  { IMAGE_SAMPLE_C_D_V5_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6349
  { IMAGE_SAMPLE_C_D_V5_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6350
  { IMAGE_SAMPLE_C_D_V5_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6351
  { IMAGE_SAMPLE_C_D_V5_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6352
  { IMAGE_SAMPLE_C_D_V5_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6353
  { IMAGE_SAMPLE_C_D_V5_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6354
  { IMAGE_SAMPLE_C_D_V5_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6355
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6356
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6357
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6358
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6359
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6360
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6361
  { IMAGE_SAMPLE_C_D_CL_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6362
  { IMAGE_SAMPLE_C_D_CL_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6363
  { IMAGE_SAMPLE_C_D_CL_V1_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 6364
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6365
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6366
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6367
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6368
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6369
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6370
  { IMAGE_SAMPLE_C_D_CL_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6371
  { IMAGE_SAMPLE_C_D_CL_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6372
  { IMAGE_SAMPLE_C_D_CL_V2_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 6373
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6374
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6375
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6376
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6377
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6378
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6379
  { IMAGE_SAMPLE_C_D_CL_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6380
  { IMAGE_SAMPLE_C_D_CL_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6381
  { IMAGE_SAMPLE_C_D_CL_V3_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 6382
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6383
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6384
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6385
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6386
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6387
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6388
  { IMAGE_SAMPLE_C_D_CL_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6389
  { IMAGE_SAMPLE_C_D_CL_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6390
  { IMAGE_SAMPLE_C_D_CL_V4_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 6391
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6392
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6393
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6394
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6395
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6396
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6397
  { IMAGE_SAMPLE_C_D_CL_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6398
  { IMAGE_SAMPLE_C_D_CL_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6399
  { IMAGE_SAMPLE_C_D_CL_V5_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 6400
  { IMAGE_SAMPLE_C_D_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6401
  { IMAGE_SAMPLE_C_D_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6402
  { IMAGE_SAMPLE_C_D_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6403
  { IMAGE_SAMPLE_C_D_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6404
  { IMAGE_SAMPLE_C_D_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6405
  { IMAGE_SAMPLE_C_D_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6406
  { IMAGE_SAMPLE_C_D_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6407
  { IMAGE_SAMPLE_C_D_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6408
  { IMAGE_SAMPLE_C_D_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 6409
  { IMAGE_SAMPLE_C_D_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6410
  { IMAGE_SAMPLE_C_D_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6411
  { IMAGE_SAMPLE_C_D_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6412
  { IMAGE_SAMPLE_C_D_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6413
  { IMAGE_SAMPLE_C_D_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6414
  { IMAGE_SAMPLE_C_D_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6415
  { IMAGE_SAMPLE_C_D_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6416
  { IMAGE_SAMPLE_C_D_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6417
  { IMAGE_SAMPLE_C_D_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 6418
  { IMAGE_SAMPLE_C_D_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6419
  { IMAGE_SAMPLE_C_D_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6420
  { IMAGE_SAMPLE_C_D_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6421
  { IMAGE_SAMPLE_C_D_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6422
  { IMAGE_SAMPLE_C_D_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6423
  { IMAGE_SAMPLE_C_D_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6424
  { IMAGE_SAMPLE_C_D_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6425
  { IMAGE_SAMPLE_C_D_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6426
  { IMAGE_SAMPLE_C_D_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 6427
  { IMAGE_SAMPLE_C_D_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6428
  { IMAGE_SAMPLE_C_D_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6429
  { IMAGE_SAMPLE_C_D_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6430
  { IMAGE_SAMPLE_C_D_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6431
  { IMAGE_SAMPLE_C_D_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6432
  { IMAGE_SAMPLE_C_D_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6433
  { IMAGE_SAMPLE_C_D_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6434
  { IMAGE_SAMPLE_C_D_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6435
  { IMAGE_SAMPLE_C_D_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 6436
  { IMAGE_SAMPLE_C_D_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6437
  { IMAGE_SAMPLE_C_D_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6438
  { IMAGE_SAMPLE_C_D_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6439
  { IMAGE_SAMPLE_C_D_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6440
  { IMAGE_SAMPLE_C_D_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6441
  { IMAGE_SAMPLE_C_D_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6442
  { IMAGE_SAMPLE_C_D_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6443
  { IMAGE_SAMPLE_C_D_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6444
  { IMAGE_SAMPLE_C_D_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 6445
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6446
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6447
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6448
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6449
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6450
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6451
  { IMAGE_SAMPLE_C_D_CL_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 6452
  { IMAGE_SAMPLE_C_D_CL_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 6453
  { IMAGE_SAMPLE_C_D_CL_V1_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0xB, 0x1 }, // 6454
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6455
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6456
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6457
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6458
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6459
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6460
  { IMAGE_SAMPLE_C_D_CL_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 6461
  { IMAGE_SAMPLE_C_D_CL_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 6462
  { IMAGE_SAMPLE_C_D_CL_V2_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0xB, 0x1 }, // 6463
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6464
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6465
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6466
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6467
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6468
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6469
  { IMAGE_SAMPLE_C_D_CL_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 6470
  { IMAGE_SAMPLE_C_D_CL_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 6471
  { IMAGE_SAMPLE_C_D_CL_V3_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0xB, 0x1 }, // 6472
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6473
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6474
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6475
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6476
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6477
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6478
  { IMAGE_SAMPLE_C_D_CL_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 6479
  { IMAGE_SAMPLE_C_D_CL_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 6480
  { IMAGE_SAMPLE_C_D_CL_V4_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 6481
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6482
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6483
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6484
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6485
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 6486
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6487
  { IMAGE_SAMPLE_C_D_CL_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 6488
  { IMAGE_SAMPLE_C_D_CL_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 6489
  { IMAGE_SAMPLE_C_D_CL_V5_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0xB, 0x1 }, // 6490
  { IMAGE_SAMPLE_C_D_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6491
  { IMAGE_SAMPLE_C_D_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6492
  { IMAGE_SAMPLE_C_D_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6493
  { IMAGE_SAMPLE_C_D_CL_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6494
  { IMAGE_SAMPLE_C_D_CL_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 6495
  { IMAGE_SAMPLE_C_D_CL_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 6496
  { IMAGE_SAMPLE_C_D_CL_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 6497
  { IMAGE_SAMPLE_C_D_CL_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 6498
  { IMAGE_SAMPLE_C_D_CL_V1_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0xB, 0xB }, // 6499
  { IMAGE_SAMPLE_C_D_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6500
  { IMAGE_SAMPLE_C_D_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6501
  { IMAGE_SAMPLE_C_D_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6502
  { IMAGE_SAMPLE_C_D_CL_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6503
  { IMAGE_SAMPLE_C_D_CL_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 6504
  { IMAGE_SAMPLE_C_D_CL_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 6505
  { IMAGE_SAMPLE_C_D_CL_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 6506
  { IMAGE_SAMPLE_C_D_CL_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 6507
  { IMAGE_SAMPLE_C_D_CL_V2_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0xB, 0xB }, // 6508
  { IMAGE_SAMPLE_C_D_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6509
  { IMAGE_SAMPLE_C_D_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6510
  { IMAGE_SAMPLE_C_D_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6511
  { IMAGE_SAMPLE_C_D_CL_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6512
  { IMAGE_SAMPLE_C_D_CL_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 6513
  { IMAGE_SAMPLE_C_D_CL_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 6514
  { IMAGE_SAMPLE_C_D_CL_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 6515
  { IMAGE_SAMPLE_C_D_CL_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 6516
  { IMAGE_SAMPLE_C_D_CL_V3_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0xB, 0xB }, // 6517
  { IMAGE_SAMPLE_C_D_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6518
  { IMAGE_SAMPLE_C_D_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6519
  { IMAGE_SAMPLE_C_D_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6520
  { IMAGE_SAMPLE_C_D_CL_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6521
  { IMAGE_SAMPLE_C_D_CL_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 6522
  { IMAGE_SAMPLE_C_D_CL_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 6523
  { IMAGE_SAMPLE_C_D_CL_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 6524
  { IMAGE_SAMPLE_C_D_CL_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 6525
  { IMAGE_SAMPLE_C_D_CL_V4_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0xB, 0xB }, // 6526
  { IMAGE_SAMPLE_C_D_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6527
  { IMAGE_SAMPLE_C_D_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6528
  { IMAGE_SAMPLE_C_D_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6529
  { IMAGE_SAMPLE_C_D_CL_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6530
  { IMAGE_SAMPLE_C_D_CL_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 6531
  { IMAGE_SAMPLE_C_D_CL_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 6532
  { IMAGE_SAMPLE_C_D_CL_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 6533
  { IMAGE_SAMPLE_C_D_CL_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 6534
  { IMAGE_SAMPLE_C_D_CL_V5_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0xB, 0xB }, // 6535
  { IMAGE_SAMPLE_C_D_CL_V1_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6536
  { IMAGE_SAMPLE_C_D_CL_V1_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6537
  { IMAGE_SAMPLE_C_D_CL_V1_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6538
  { IMAGE_SAMPLE_C_D_CL_V1_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6539
  { IMAGE_SAMPLE_C_D_CL_V1_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6540
  { IMAGE_SAMPLE_C_D_CL_V1_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6541
  { IMAGE_SAMPLE_C_D_CL_V1_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6542
  { IMAGE_SAMPLE_C_D_CL_V1_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6543
  { IMAGE_SAMPLE_C_D_CL_V1_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 6544
  { IMAGE_SAMPLE_C_D_CL_V2_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6545
  { IMAGE_SAMPLE_C_D_CL_V2_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6546
  { IMAGE_SAMPLE_C_D_CL_V2_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6547
  { IMAGE_SAMPLE_C_D_CL_V2_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6548
  { IMAGE_SAMPLE_C_D_CL_V2_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6549
  { IMAGE_SAMPLE_C_D_CL_V2_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6550
  { IMAGE_SAMPLE_C_D_CL_V2_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6551
  { IMAGE_SAMPLE_C_D_CL_V2_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6552
  { IMAGE_SAMPLE_C_D_CL_V2_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 6553
  { IMAGE_SAMPLE_C_D_CL_V3_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6554
  { IMAGE_SAMPLE_C_D_CL_V3_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6555
  { IMAGE_SAMPLE_C_D_CL_V3_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6556
  { IMAGE_SAMPLE_C_D_CL_V3_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6557
  { IMAGE_SAMPLE_C_D_CL_V3_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6558
  { IMAGE_SAMPLE_C_D_CL_V3_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6559
  { IMAGE_SAMPLE_C_D_CL_V3_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6560
  { IMAGE_SAMPLE_C_D_CL_V3_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6561
  { IMAGE_SAMPLE_C_D_CL_V3_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 6562
  { IMAGE_SAMPLE_C_D_CL_V4_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6563
  { IMAGE_SAMPLE_C_D_CL_V4_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6564
  { IMAGE_SAMPLE_C_D_CL_V4_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6565
  { IMAGE_SAMPLE_C_D_CL_V4_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6566
  { IMAGE_SAMPLE_C_D_CL_V4_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6567
  { IMAGE_SAMPLE_C_D_CL_V4_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6568
  { IMAGE_SAMPLE_C_D_CL_V4_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6569
  { IMAGE_SAMPLE_C_D_CL_V4_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6570
  { IMAGE_SAMPLE_C_D_CL_V4_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 6571
  { IMAGE_SAMPLE_C_D_CL_V5_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6572
  { IMAGE_SAMPLE_C_D_CL_V5_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6573
  { IMAGE_SAMPLE_C_D_CL_V5_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6574
  { IMAGE_SAMPLE_C_D_CL_V5_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6575
  { IMAGE_SAMPLE_C_D_CL_V5_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6576
  { IMAGE_SAMPLE_C_D_CL_V5_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6577
  { IMAGE_SAMPLE_C_D_CL_V5_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6578
  { IMAGE_SAMPLE_C_D_CL_V5_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6579
  { IMAGE_SAMPLE_C_D_CL_V5_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 6580
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6581
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6582
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6583
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6584
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6585
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6586
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6587
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6588
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6589
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6590
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6591
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6592
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6593
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6594
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6595
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6596
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6597
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6598
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6599
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6600
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6601
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6602
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6603
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6604
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6605
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6606
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6607
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6608
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6609
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6610
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6611
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6612
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6613
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6614
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6615
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6616
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6617
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6618
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6619
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6620
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6621
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6622
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6623
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6624
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6625
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6626
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6627
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6628
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6629
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6630
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6631
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6632
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6633
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6634
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6635
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6636
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6637
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6638
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6639
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6640
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6641
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6642
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6643
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6644
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6645
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6646
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6647
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6648
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6649
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6650
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6651
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6652
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6653
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6654
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6655
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6656
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 6657
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6658
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6659
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6660
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6661
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6662
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6663
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 6664
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6665
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6666
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6667
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6668
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6669
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6670
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 6671
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6672
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6673
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6674
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6675
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6676
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6677
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 6678
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6679
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6680
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6681
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6682
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 6683
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6684
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 6685
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6686
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6687
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6688
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6689
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 6690
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 6691
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 6692
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6693
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6694
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6695
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6696
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 6697
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 6698
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 6699
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6700
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6701
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6702
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6703
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 6704
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 6705
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 6706
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6707
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6708
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6709
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6710
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 6711
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 6712
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 6713
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6714
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6715
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6716
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6717
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 6718
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 6719
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 6720
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6721
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6722
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6723
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6724
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6725
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6726
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6727
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6728
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6729
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6730
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6731
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6732
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6733
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6734
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6735
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6736
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6737
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6738
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6739
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6740
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6741
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6742
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6743
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6744
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6745
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6746
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6747
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6748
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6749
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6750
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6751
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6752
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6753
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6754
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6755
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6756
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6757
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6758
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6759
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6760
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6761
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6762
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 6763
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xC, 0x1 }, // 6764
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6765
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6766
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6767
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6768
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6769
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6770
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6771
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 6772
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xC, 0x1 }, // 6773
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6774
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6775
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6776
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6777
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6778
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6779
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6780
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 6781
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xC, 0x1 }, // 6782
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6783
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6784
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6785
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6786
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6787
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6788
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6789
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 6790
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 6791
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6792
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6793
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6794
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6795
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6796
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6797
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6798
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 6799
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xC, 0x1 }, // 6800
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6801
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6802
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6803
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6804
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6805
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6806
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6807
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 6808
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xC, 0xC }, // 6809
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6810
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6811
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6812
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6813
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6814
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6815
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6816
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 6817
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xC, 0xC }, // 6818
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6819
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6820
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6821
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6822
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6823
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6824
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6825
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 6826
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xC, 0xC }, // 6827
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6828
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6829
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6830
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6831
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6832
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6833
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6834
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 6835
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 6836
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6837
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6838
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6839
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6840
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6841
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6842
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6843
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 6844
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xC, 0xC }, // 6845
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6846
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6847
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6848
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6849
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6850
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 6851
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 6852
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xB, 0x1 }, // 6853
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xC, 0x1 }, // 6854
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6855
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6856
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6857
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6858
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6859
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 6860
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 6861
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xB, 0x1 }, // 6862
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xC, 0x1 }, // 6863
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6864
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6865
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6866
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6867
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6868
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 6869
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 6870
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xB, 0x1 }, // 6871
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xC, 0x1 }, // 6872
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6873
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6874
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6875
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6876
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6877
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 6878
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 6879
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 6880
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 6881
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6882
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6883
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6884
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 6885
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6886
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 6887
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 6888
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xB, 0x1 }, // 6889
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xC, 0x1 }, // 6890
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6891
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6892
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6893
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 6894
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 6895
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 6896
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 6897
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xB, 0xB }, // 6898
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xC, 0xC }, // 6899
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6900
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6901
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6902
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 6903
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 6904
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 6905
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 6906
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xB, 0xB }, // 6907
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xC, 0xC }, // 6908
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6909
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6910
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6911
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 6912
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 6913
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 6914
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 6915
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xB, 0xB }, // 6916
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xC, 0xC }, // 6917
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6918
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6919
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6920
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 6921
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 6922
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 6923
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 6924
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xB, 0xB }, // 6925
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xC, 0xC }, // 6926
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6927
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6928
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6929
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 6930
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 6931
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 6932
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 6933
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xB, 0xB }, // 6934
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xC, 0xC }, // 6935
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6936
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6937
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6938
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6939
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6940
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6941
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6942
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 6943
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xC, 0x1 }, // 6944
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6945
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6946
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6947
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6948
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6949
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6950
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6951
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 6952
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xC, 0x1 }, // 6953
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6954
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6955
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6956
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6957
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6958
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6959
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6960
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 6961
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xC, 0x1 }, // 6962
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6963
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6964
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6965
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6966
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6967
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6968
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6969
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 6970
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xC, 0x1 }, // 6971
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6972
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6973
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6974
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6975
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6976
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6977
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6978
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 6979
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xC, 0x1 }, // 6980
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6981
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6982
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6983
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6984
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6985
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6986
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6987
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6988
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6989
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6990
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6991
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6992
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6993
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6994
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6995
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6996
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6997
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6998
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6999
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7000
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 7001
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7002
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7003
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7004
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7005
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7006
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7007
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 7008
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7009
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7010
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7011
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7012
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7013
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7014
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 7015
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7016
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7017
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7018
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7019
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7020
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7021
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 7022
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7023
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7024
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7025
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7026
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7027
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7028
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 7029
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7030
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7031
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7032
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7033
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7034
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7035
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 7036
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7037
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7038
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7039
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7040
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7041
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7042
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 7043
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7044
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7045
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7046
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7047
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7048
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7049
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 7050
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7051
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7052
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7053
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7054
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7055
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7056
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 7057
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7058
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7059
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7060
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7061
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7062
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7063
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 7064
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7065
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7066
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7067
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7068
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7069
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7070
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 7071
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7072
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7073
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7074
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7075
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7076
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7077
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 7078
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7079
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7080
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7081
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7082
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7083
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7084
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7085
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7086
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7087
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7088
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7089
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7090
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7091
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7092
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7093
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7094
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7095
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7096
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7097
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7098
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7099
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7100
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7101
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7102
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7103
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7104
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7105
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 7106
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7107
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7108
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7109
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7110
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7111
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7112
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 7113
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7114
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7115
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7116
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7117
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7118
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7119
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 7120
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7121
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7122
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7123
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7124
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7125
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7126
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 7127
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7128
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7129
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7130
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7131
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7132
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7133
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 7134
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7135
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7136
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7137
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7138
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7139
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7140
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 7141
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7142
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7143
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7144
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7145
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7146
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7147
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 7148
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7149
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7150
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7151
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7152
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7153
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7154
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 7155
  { IMAGE_SAMPLE_C_D_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7156
  { IMAGE_SAMPLE_C_D_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7157
  { IMAGE_SAMPLE_C_D_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7158
  { IMAGE_SAMPLE_C_D_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7159
  { IMAGE_SAMPLE_C_D_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7160
  { IMAGE_SAMPLE_C_D_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7161
  { IMAGE_SAMPLE_C_D_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7162
  { IMAGE_SAMPLE_C_D_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7163
  { IMAGE_SAMPLE_C_D_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7164
  { IMAGE_SAMPLE_C_D_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7165
  { IMAGE_SAMPLE_C_D_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7166
  { IMAGE_SAMPLE_C_D_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7167
  { IMAGE_SAMPLE_C_D_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7168
  { IMAGE_SAMPLE_C_D_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7169
  { IMAGE_SAMPLE_C_D_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7170
  { IMAGE_SAMPLE_C_D_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7171
  { IMAGE_SAMPLE_C_D_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7172
  { IMAGE_SAMPLE_C_D_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7173
  { IMAGE_SAMPLE_C_D_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7174
  { IMAGE_SAMPLE_C_D_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7175
  { IMAGE_SAMPLE_C_D_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7176
  { IMAGE_SAMPLE_C_D_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7177
  { IMAGE_SAMPLE_C_D_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7178
  { IMAGE_SAMPLE_C_D_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7179
  { IMAGE_SAMPLE_C_D_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7180
  { IMAGE_SAMPLE_C_D_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7181
  { IMAGE_SAMPLE_C_D_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7182
  { IMAGE_SAMPLE_C_D_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7183
  { IMAGE_SAMPLE_C_D_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7184
  { IMAGE_SAMPLE_C_D_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7185
  { IMAGE_SAMPLE_C_D_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7186
  { IMAGE_SAMPLE_C_D_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7187
  { IMAGE_SAMPLE_C_D_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7188
  { IMAGE_SAMPLE_C_D_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7189
  { IMAGE_SAMPLE_C_D_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7190
  { IMAGE_SAMPLE_C_D_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7191
  { IMAGE_SAMPLE_C_D_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7192
  { IMAGE_SAMPLE_C_D_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7193
  { IMAGE_SAMPLE_C_D_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7194
  { IMAGE_SAMPLE_C_D_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7195
  { IMAGE_SAMPLE_C_D_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7196
  { IMAGE_SAMPLE_C_D_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7197
  { IMAGE_SAMPLE_C_D_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7198
  { IMAGE_SAMPLE_C_D_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7199
  { IMAGE_SAMPLE_C_D_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7200
  { IMAGE_SAMPLE_C_D_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7201
  { IMAGE_SAMPLE_C_D_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7202
  { IMAGE_SAMPLE_C_D_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7203
  { IMAGE_SAMPLE_C_D_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7204
  { IMAGE_SAMPLE_C_D_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7205
  { IMAGE_SAMPLE_C_D_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7206
  { IMAGE_SAMPLE_C_D_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7207
  { IMAGE_SAMPLE_C_D_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7208
  { IMAGE_SAMPLE_C_D_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7209
  { IMAGE_SAMPLE_C_D_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7210
  { IMAGE_SAMPLE_C_D_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7211
  { IMAGE_SAMPLE_C_D_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7212
  { IMAGE_SAMPLE_C_D_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7213
  { IMAGE_SAMPLE_C_D_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7214
  { IMAGE_SAMPLE_C_D_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7215
  { IMAGE_SAMPLE_C_D_G16_V1_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7216
  { IMAGE_SAMPLE_C_D_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7217
  { IMAGE_SAMPLE_C_D_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7218
  { IMAGE_SAMPLE_C_D_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7219
  { IMAGE_SAMPLE_C_D_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7220
  { IMAGE_SAMPLE_C_D_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7221
  { IMAGE_SAMPLE_C_D_G16_V2_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7222
  { IMAGE_SAMPLE_C_D_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7223
  { IMAGE_SAMPLE_C_D_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7224
  { IMAGE_SAMPLE_C_D_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7225
  { IMAGE_SAMPLE_C_D_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7226
  { IMAGE_SAMPLE_C_D_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7227
  { IMAGE_SAMPLE_C_D_G16_V3_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7228
  { IMAGE_SAMPLE_C_D_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7229
  { IMAGE_SAMPLE_C_D_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7230
  { IMAGE_SAMPLE_C_D_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7231
  { IMAGE_SAMPLE_C_D_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7232
  { IMAGE_SAMPLE_C_D_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7233
  { IMAGE_SAMPLE_C_D_G16_V4_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7234
  { IMAGE_SAMPLE_C_D_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7235
  { IMAGE_SAMPLE_C_D_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7236
  { IMAGE_SAMPLE_C_D_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7237
  { IMAGE_SAMPLE_C_D_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7238
  { IMAGE_SAMPLE_C_D_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7239
  { IMAGE_SAMPLE_C_D_G16_V5_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7240
  { IMAGE_SAMPLE_C_D_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7241
  { IMAGE_SAMPLE_C_D_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7242
  { IMAGE_SAMPLE_C_D_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7243
  { IMAGE_SAMPLE_C_D_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7244
  { IMAGE_SAMPLE_C_D_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7245
  { IMAGE_SAMPLE_C_D_G16_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7246
  { IMAGE_SAMPLE_C_D_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7247
  { IMAGE_SAMPLE_C_D_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7248
  { IMAGE_SAMPLE_C_D_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7249
  { IMAGE_SAMPLE_C_D_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7250
  { IMAGE_SAMPLE_C_D_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7251
  { IMAGE_SAMPLE_C_D_G16_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7252
  { IMAGE_SAMPLE_C_D_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7253
  { IMAGE_SAMPLE_C_D_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7254
  { IMAGE_SAMPLE_C_D_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7255
  { IMAGE_SAMPLE_C_D_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7256
  { IMAGE_SAMPLE_C_D_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7257
  { IMAGE_SAMPLE_C_D_G16_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7258
  { IMAGE_SAMPLE_C_D_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7259
  { IMAGE_SAMPLE_C_D_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7260
  { IMAGE_SAMPLE_C_D_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7261
  { IMAGE_SAMPLE_C_D_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7262
  { IMAGE_SAMPLE_C_D_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7263
  { IMAGE_SAMPLE_C_D_G16_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7264
  { IMAGE_SAMPLE_C_D_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7265
  { IMAGE_SAMPLE_C_D_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7266
  { IMAGE_SAMPLE_C_D_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7267
  { IMAGE_SAMPLE_C_D_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7268
  { IMAGE_SAMPLE_C_D_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7269
  { IMAGE_SAMPLE_C_D_G16_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7270
  { IMAGE_SAMPLE_C_D_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7271
  { IMAGE_SAMPLE_C_D_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7272
  { IMAGE_SAMPLE_C_D_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7273
  { IMAGE_SAMPLE_C_D_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7274
  { IMAGE_SAMPLE_C_D_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7275
  { IMAGE_SAMPLE_C_D_G16_V1_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7276
  { IMAGE_SAMPLE_C_D_G16_V1_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7277
  { IMAGE_SAMPLE_C_D_G16_V1_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7278
  { IMAGE_SAMPLE_C_D_G16_V1_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7279
  { IMAGE_SAMPLE_C_D_G16_V1_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7280
  { IMAGE_SAMPLE_C_D_G16_V1_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7281
  { IMAGE_SAMPLE_C_D_G16_V2_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7282
  { IMAGE_SAMPLE_C_D_G16_V2_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7283
  { IMAGE_SAMPLE_C_D_G16_V2_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7284
  { IMAGE_SAMPLE_C_D_G16_V2_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7285
  { IMAGE_SAMPLE_C_D_G16_V2_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7286
  { IMAGE_SAMPLE_C_D_G16_V2_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7287
  { IMAGE_SAMPLE_C_D_G16_V3_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7288
  { IMAGE_SAMPLE_C_D_G16_V3_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7289
  { IMAGE_SAMPLE_C_D_G16_V3_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7290
  { IMAGE_SAMPLE_C_D_G16_V3_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7291
  { IMAGE_SAMPLE_C_D_G16_V3_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7292
  { IMAGE_SAMPLE_C_D_G16_V3_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7293
  { IMAGE_SAMPLE_C_D_G16_V4_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7294
  { IMAGE_SAMPLE_C_D_G16_V4_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7295
  { IMAGE_SAMPLE_C_D_G16_V4_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7296
  { IMAGE_SAMPLE_C_D_G16_V4_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7297
  { IMAGE_SAMPLE_C_D_G16_V4_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7298
  { IMAGE_SAMPLE_C_D_G16_V4_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7299
  { IMAGE_SAMPLE_C_D_G16_V5_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7300
  { IMAGE_SAMPLE_C_D_G16_V5_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7301
  { IMAGE_SAMPLE_C_D_G16_V5_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7302
  { IMAGE_SAMPLE_C_D_G16_V5_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7303
  { IMAGE_SAMPLE_C_D_G16_V5_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7304
  { IMAGE_SAMPLE_C_D_G16_V5_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7305
  { IMAGE_SAMPLE_C_D_O_V1_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7306
  { IMAGE_SAMPLE_C_D_O_V1_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7307
  { IMAGE_SAMPLE_C_D_O_V1_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7308
  { IMAGE_SAMPLE_C_D_O_V1_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7309
  { IMAGE_SAMPLE_C_D_O_V1_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7310
  { IMAGE_SAMPLE_C_D_O_V1_V9_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7311
  { IMAGE_SAMPLE_C_D_O_V1_V10_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 7312
  { IMAGE_SAMPLE_C_D_O_V1_V11_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 7313
  { IMAGE_SAMPLE_C_D_O_V2_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7314
  { IMAGE_SAMPLE_C_D_O_V2_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7315
  { IMAGE_SAMPLE_C_D_O_V2_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7316
  { IMAGE_SAMPLE_C_D_O_V2_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7317
  { IMAGE_SAMPLE_C_D_O_V2_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7318
  { IMAGE_SAMPLE_C_D_O_V2_V9_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7319
  { IMAGE_SAMPLE_C_D_O_V2_V10_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 7320
  { IMAGE_SAMPLE_C_D_O_V2_V11_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 7321
  { IMAGE_SAMPLE_C_D_O_V3_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7322
  { IMAGE_SAMPLE_C_D_O_V3_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7323
  { IMAGE_SAMPLE_C_D_O_V3_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7324
  { IMAGE_SAMPLE_C_D_O_V3_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7325
  { IMAGE_SAMPLE_C_D_O_V3_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7326
  { IMAGE_SAMPLE_C_D_O_V3_V9_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7327
  { IMAGE_SAMPLE_C_D_O_V3_V10_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 7328
  { IMAGE_SAMPLE_C_D_O_V3_V11_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 7329
  { IMAGE_SAMPLE_C_D_O_V4_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7330
  { IMAGE_SAMPLE_C_D_O_V4_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7331
  { IMAGE_SAMPLE_C_D_O_V4_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7332
  { IMAGE_SAMPLE_C_D_O_V4_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7333
  { IMAGE_SAMPLE_C_D_O_V4_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7334
  { IMAGE_SAMPLE_C_D_O_V4_V9_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7335
  { IMAGE_SAMPLE_C_D_O_V4_V10_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 7336
  { IMAGE_SAMPLE_C_D_O_V4_V11_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 7337
  { IMAGE_SAMPLE_C_D_O_V5_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7338
  { IMAGE_SAMPLE_C_D_O_V5_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7339
  { IMAGE_SAMPLE_C_D_O_V5_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7340
  { IMAGE_SAMPLE_C_D_O_V5_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7341
  { IMAGE_SAMPLE_C_D_O_V5_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7342
  { IMAGE_SAMPLE_C_D_O_V5_V9_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7343
  { IMAGE_SAMPLE_C_D_O_V5_V10_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 7344
  { IMAGE_SAMPLE_C_D_O_V5_V11_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 7345
  { IMAGE_SAMPLE_C_D_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7346
  { IMAGE_SAMPLE_C_D_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7347
  { IMAGE_SAMPLE_C_D_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7348
  { IMAGE_SAMPLE_C_D_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7349
  { IMAGE_SAMPLE_C_D_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7350
  { IMAGE_SAMPLE_C_D_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7351
  { IMAGE_SAMPLE_C_D_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 7352
  { IMAGE_SAMPLE_C_D_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 7353
  { IMAGE_SAMPLE_C_D_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7354
  { IMAGE_SAMPLE_C_D_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7355
  { IMAGE_SAMPLE_C_D_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7356
  { IMAGE_SAMPLE_C_D_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7357
  { IMAGE_SAMPLE_C_D_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7358
  { IMAGE_SAMPLE_C_D_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7359
  { IMAGE_SAMPLE_C_D_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 7360
  { IMAGE_SAMPLE_C_D_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 7361
  { IMAGE_SAMPLE_C_D_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7362
  { IMAGE_SAMPLE_C_D_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7363
  { IMAGE_SAMPLE_C_D_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7364
  { IMAGE_SAMPLE_C_D_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7365
  { IMAGE_SAMPLE_C_D_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7366
  { IMAGE_SAMPLE_C_D_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7367
  { IMAGE_SAMPLE_C_D_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 7368
  { IMAGE_SAMPLE_C_D_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 7369
  { IMAGE_SAMPLE_C_D_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7370
  { IMAGE_SAMPLE_C_D_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7371
  { IMAGE_SAMPLE_C_D_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7372
  { IMAGE_SAMPLE_C_D_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7373
  { IMAGE_SAMPLE_C_D_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7374
  { IMAGE_SAMPLE_C_D_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7375
  { IMAGE_SAMPLE_C_D_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 7376
  { IMAGE_SAMPLE_C_D_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 7377
  { IMAGE_SAMPLE_C_D_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7378
  { IMAGE_SAMPLE_C_D_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7379
  { IMAGE_SAMPLE_C_D_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7380
  { IMAGE_SAMPLE_C_D_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7381
  { IMAGE_SAMPLE_C_D_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7382
  { IMAGE_SAMPLE_C_D_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7383
  { IMAGE_SAMPLE_C_D_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 7384
  { IMAGE_SAMPLE_C_D_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 7385
  { IMAGE_SAMPLE_C_D_O_V1_V4_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7386
  { IMAGE_SAMPLE_C_D_O_V1_V5_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7387
  { IMAGE_SAMPLE_C_D_O_V1_V6_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7388
  { IMAGE_SAMPLE_C_D_O_V1_V7_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7389
  { IMAGE_SAMPLE_C_D_O_V1_V8_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7390
  { IMAGE_SAMPLE_C_D_O_V1_V9_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7391
  { IMAGE_SAMPLE_C_D_O_V1_V10_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 7392
  { IMAGE_SAMPLE_C_D_O_V1_V11_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x1, 0xB, 0x1 }, // 7393
  { IMAGE_SAMPLE_C_D_O_V2_V4_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7394
  { IMAGE_SAMPLE_C_D_O_V2_V5_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7395
  { IMAGE_SAMPLE_C_D_O_V2_V6_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7396
  { IMAGE_SAMPLE_C_D_O_V2_V7_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7397
  { IMAGE_SAMPLE_C_D_O_V2_V8_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7398
  { IMAGE_SAMPLE_C_D_O_V2_V9_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7399
  { IMAGE_SAMPLE_C_D_O_V2_V10_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 7400
  { IMAGE_SAMPLE_C_D_O_V2_V11_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x2, 0xB, 0x1 }, // 7401
  { IMAGE_SAMPLE_C_D_O_V3_V4_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7402
  { IMAGE_SAMPLE_C_D_O_V3_V5_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7403
  { IMAGE_SAMPLE_C_D_O_V3_V6_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7404
  { IMAGE_SAMPLE_C_D_O_V3_V7_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7405
  { IMAGE_SAMPLE_C_D_O_V3_V8_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7406
  { IMAGE_SAMPLE_C_D_O_V3_V9_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7407
  { IMAGE_SAMPLE_C_D_O_V3_V10_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 7408
  { IMAGE_SAMPLE_C_D_O_V3_V11_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x3, 0xB, 0x1 }, // 7409
  { IMAGE_SAMPLE_C_D_O_V4_V4_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7410
  { IMAGE_SAMPLE_C_D_O_V4_V5_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7411
  { IMAGE_SAMPLE_C_D_O_V4_V6_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7412
  { IMAGE_SAMPLE_C_D_O_V4_V7_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7413
  { IMAGE_SAMPLE_C_D_O_V4_V8_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7414
  { IMAGE_SAMPLE_C_D_O_V4_V9_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7415
  { IMAGE_SAMPLE_C_D_O_V4_V10_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 7416
  { IMAGE_SAMPLE_C_D_O_V4_V11_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 7417
  { IMAGE_SAMPLE_C_D_O_V5_V4_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7418
  { IMAGE_SAMPLE_C_D_O_V5_V5_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7419
  { IMAGE_SAMPLE_C_D_O_V5_V6_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7420
  { IMAGE_SAMPLE_C_D_O_V5_V7_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7421
  { IMAGE_SAMPLE_C_D_O_V5_V8_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7422
  { IMAGE_SAMPLE_C_D_O_V5_V9_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7423
  { IMAGE_SAMPLE_C_D_O_V5_V10_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7424
  { IMAGE_SAMPLE_C_D_O_V5_V11_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11Default, 0x5, 0xB, 0x1 }, // 7425
  { IMAGE_SAMPLE_C_D_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7426
  { IMAGE_SAMPLE_C_D_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7427
  { IMAGE_SAMPLE_C_D_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7428
  { IMAGE_SAMPLE_C_D_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7429
  { IMAGE_SAMPLE_C_D_O_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7430
  { IMAGE_SAMPLE_C_D_O_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7431
  { IMAGE_SAMPLE_C_D_O_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7432
  { IMAGE_SAMPLE_C_D_O_V1_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x1, 0xB, 0xB }, // 7433
  { IMAGE_SAMPLE_C_D_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7434
  { IMAGE_SAMPLE_C_D_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7435
  { IMAGE_SAMPLE_C_D_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7436
  { IMAGE_SAMPLE_C_D_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7437
  { IMAGE_SAMPLE_C_D_O_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7438
  { IMAGE_SAMPLE_C_D_O_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7439
  { IMAGE_SAMPLE_C_D_O_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7440
  { IMAGE_SAMPLE_C_D_O_V2_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x2, 0xB, 0xB }, // 7441
  { IMAGE_SAMPLE_C_D_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7442
  { IMAGE_SAMPLE_C_D_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7443
  { IMAGE_SAMPLE_C_D_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7444
  { IMAGE_SAMPLE_C_D_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7445
  { IMAGE_SAMPLE_C_D_O_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7446
  { IMAGE_SAMPLE_C_D_O_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7447
  { IMAGE_SAMPLE_C_D_O_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 7448
  { IMAGE_SAMPLE_C_D_O_V3_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x3, 0xB, 0xB }, // 7449
  { IMAGE_SAMPLE_C_D_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7450
  { IMAGE_SAMPLE_C_D_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7451
  { IMAGE_SAMPLE_C_D_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7452
  { IMAGE_SAMPLE_C_D_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7453
  { IMAGE_SAMPLE_C_D_O_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7454
  { IMAGE_SAMPLE_C_D_O_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7455
  { IMAGE_SAMPLE_C_D_O_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 7456
  { IMAGE_SAMPLE_C_D_O_V4_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x4, 0xB, 0xB }, // 7457
  { IMAGE_SAMPLE_C_D_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7458
  { IMAGE_SAMPLE_C_D_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7459
  { IMAGE_SAMPLE_C_D_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7460
  { IMAGE_SAMPLE_C_D_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7461
  { IMAGE_SAMPLE_C_D_O_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7462
  { IMAGE_SAMPLE_C_D_O_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7463
  { IMAGE_SAMPLE_C_D_O_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 7464
  { IMAGE_SAMPLE_C_D_O_V5_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx11NSA, 0x5, 0xB, 0xB }, // 7465
  { IMAGE_SAMPLE_C_D_O_V1_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7466
  { IMAGE_SAMPLE_C_D_O_V1_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7467
  { IMAGE_SAMPLE_C_D_O_V1_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7468
  { IMAGE_SAMPLE_C_D_O_V1_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7469
  { IMAGE_SAMPLE_C_D_O_V1_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7470
  { IMAGE_SAMPLE_C_D_O_V1_V9, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7471
  { IMAGE_SAMPLE_C_D_O_V1_V10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 7472
  { IMAGE_SAMPLE_C_D_O_V1_V11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 7473
  { IMAGE_SAMPLE_C_D_O_V2_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7474
  { IMAGE_SAMPLE_C_D_O_V2_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7475
  { IMAGE_SAMPLE_C_D_O_V2_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7476
  { IMAGE_SAMPLE_C_D_O_V2_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7477
  { IMAGE_SAMPLE_C_D_O_V2_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7478
  { IMAGE_SAMPLE_C_D_O_V2_V9, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7479
  { IMAGE_SAMPLE_C_D_O_V2_V10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 7480
  { IMAGE_SAMPLE_C_D_O_V2_V11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 7481
  { IMAGE_SAMPLE_C_D_O_V3_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7482
  { IMAGE_SAMPLE_C_D_O_V3_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7483
  { IMAGE_SAMPLE_C_D_O_V3_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7484
  { IMAGE_SAMPLE_C_D_O_V3_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7485
  { IMAGE_SAMPLE_C_D_O_V3_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7486
  { IMAGE_SAMPLE_C_D_O_V3_V9, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7487
  { IMAGE_SAMPLE_C_D_O_V3_V10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 7488
  { IMAGE_SAMPLE_C_D_O_V3_V11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 7489
  { IMAGE_SAMPLE_C_D_O_V4_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7490
  { IMAGE_SAMPLE_C_D_O_V4_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7491
  { IMAGE_SAMPLE_C_D_O_V4_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7492
  { IMAGE_SAMPLE_C_D_O_V4_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7493
  { IMAGE_SAMPLE_C_D_O_V4_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7494
  { IMAGE_SAMPLE_C_D_O_V4_V9, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7495
  { IMAGE_SAMPLE_C_D_O_V4_V10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 7496
  { IMAGE_SAMPLE_C_D_O_V4_V11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 7497
  { IMAGE_SAMPLE_C_D_O_V5_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7498
  { IMAGE_SAMPLE_C_D_O_V5_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7499
  { IMAGE_SAMPLE_C_D_O_V5_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7500
  { IMAGE_SAMPLE_C_D_O_V5_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7501
  { IMAGE_SAMPLE_C_D_O_V5_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7502
  { IMAGE_SAMPLE_C_D_O_V5_V9, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7503
  { IMAGE_SAMPLE_C_D_O_V5_V10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 7504
  { IMAGE_SAMPLE_C_D_O_V5_V11, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 7505
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7506
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7507
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7508
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7509
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7510
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7511
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7512
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7513
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7514
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7515
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7516
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7517
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7518
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7519
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7520
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7521
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7522
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7523
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7524
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7525
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7526
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7527
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7528
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7529
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7530
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7531
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7532
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7533
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7534
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7535
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7536
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7537
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7538
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7539
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7540
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7541
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7542
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7543
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7544
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7545
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7546
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7547
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7548
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7549
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7550
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7551
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7552
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7553
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7554
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7555
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7556
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7557
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7558
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7559
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7560
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7561
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7562
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7563
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7564
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7565
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7566
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7567
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7568
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7569
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7570
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7571
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7572
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7573
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7574
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7575
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7576
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7577
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7578
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7579
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7580
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7581
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7582
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7583
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7584
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7585
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7586
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7587
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7588
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7589
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7590
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7591
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7592
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7593
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7594
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7595
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7596
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7597
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7598
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7599
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7600
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7601
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7602
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7603
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7604
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7605
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7606
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7607
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7608
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7609
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7610
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7611
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7612
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7613
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7614
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7615
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7616
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7617
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7618
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7619
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7620
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7621
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7622
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7623
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7624
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7625
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7626
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7627
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7628
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7629
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7630
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7631
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7632
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7633
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7634
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7635
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7636
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7637
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7638
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7639
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7640
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7641
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7642
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7643
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7644
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7645
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7646
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7647
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7648
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7649
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7650
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7651
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7652
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7653
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7654
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7655
  { IMAGE_SAMPLE_C_L_V1_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 7656
  { IMAGE_SAMPLE_C_L_V1_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7657
  { IMAGE_SAMPLE_C_L_V1_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7658
  { IMAGE_SAMPLE_C_L_V1_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7659
  { IMAGE_SAMPLE_C_L_V1_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7660
  { IMAGE_SAMPLE_C_L_V2_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 7661
  { IMAGE_SAMPLE_C_L_V2_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7662
  { IMAGE_SAMPLE_C_L_V2_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7663
  { IMAGE_SAMPLE_C_L_V2_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7664
  { IMAGE_SAMPLE_C_L_V2_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7665
  { IMAGE_SAMPLE_C_L_V3_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 7666
  { IMAGE_SAMPLE_C_L_V3_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7667
  { IMAGE_SAMPLE_C_L_V3_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7668
  { IMAGE_SAMPLE_C_L_V3_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7669
  { IMAGE_SAMPLE_C_L_V3_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7670
  { IMAGE_SAMPLE_C_L_V4_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 7671
  { IMAGE_SAMPLE_C_L_V4_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7672
  { IMAGE_SAMPLE_C_L_V4_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7673
  { IMAGE_SAMPLE_C_L_V4_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7674
  { IMAGE_SAMPLE_C_L_V4_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7675
  { IMAGE_SAMPLE_C_L_V5_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 7676
  { IMAGE_SAMPLE_C_L_V5_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7677
  { IMAGE_SAMPLE_C_L_V5_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7678
  { IMAGE_SAMPLE_C_L_V5_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7679
  { IMAGE_SAMPLE_C_L_V5_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7680
  { IMAGE_SAMPLE_C_L_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 7681
  { IMAGE_SAMPLE_C_L_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7682
  { IMAGE_SAMPLE_C_L_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7683
  { IMAGE_SAMPLE_C_L_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7684
  { IMAGE_SAMPLE_C_L_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 7685
  { IMAGE_SAMPLE_C_L_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7686
  { IMAGE_SAMPLE_C_L_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7687
  { IMAGE_SAMPLE_C_L_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7688
  { IMAGE_SAMPLE_C_L_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 7689
  { IMAGE_SAMPLE_C_L_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7690
  { IMAGE_SAMPLE_C_L_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7691
  { IMAGE_SAMPLE_C_L_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7692
  { IMAGE_SAMPLE_C_L_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 7693
  { IMAGE_SAMPLE_C_L_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7694
  { IMAGE_SAMPLE_C_L_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7695
  { IMAGE_SAMPLE_C_L_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7696
  { IMAGE_SAMPLE_C_L_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 7697
  { IMAGE_SAMPLE_C_L_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7698
  { IMAGE_SAMPLE_C_L_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7699
  { IMAGE_SAMPLE_C_L_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7700
  { IMAGE_SAMPLE_C_L_V1_V2_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 7701
  { IMAGE_SAMPLE_C_L_V1_V3_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7702
  { IMAGE_SAMPLE_C_L_V1_V4_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7703
  { IMAGE_SAMPLE_C_L_V1_V5_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7704
  { IMAGE_SAMPLE_C_L_V1_V8_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7705
  { IMAGE_SAMPLE_C_L_V2_V2_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 7706
  { IMAGE_SAMPLE_C_L_V2_V3_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7707
  { IMAGE_SAMPLE_C_L_V2_V4_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7708
  { IMAGE_SAMPLE_C_L_V2_V5_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7709
  { IMAGE_SAMPLE_C_L_V2_V8_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7710
  { IMAGE_SAMPLE_C_L_V3_V2_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 7711
  { IMAGE_SAMPLE_C_L_V3_V3_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7712
  { IMAGE_SAMPLE_C_L_V3_V4_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7713
  { IMAGE_SAMPLE_C_L_V3_V5_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7714
  { IMAGE_SAMPLE_C_L_V3_V8_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7715
  { IMAGE_SAMPLE_C_L_V4_V2_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 7716
  { IMAGE_SAMPLE_C_L_V4_V3_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7717
  { IMAGE_SAMPLE_C_L_V4_V4_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7718
  { IMAGE_SAMPLE_C_L_V4_V5_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7719
  { IMAGE_SAMPLE_C_L_V4_V8_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7720
  { IMAGE_SAMPLE_C_L_V5_V2_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 7721
  { IMAGE_SAMPLE_C_L_V5_V3_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7722
  { IMAGE_SAMPLE_C_L_V5_V4_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7723
  { IMAGE_SAMPLE_C_L_V5_V5_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7724
  { IMAGE_SAMPLE_C_L_V5_V8_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7725
  { IMAGE_SAMPLE_C_L_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 7726
  { IMAGE_SAMPLE_C_L_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7727
  { IMAGE_SAMPLE_C_L_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7728
  { IMAGE_SAMPLE_C_L_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7729
  { IMAGE_SAMPLE_C_L_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 7730
  { IMAGE_SAMPLE_C_L_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7731
  { IMAGE_SAMPLE_C_L_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7732
  { IMAGE_SAMPLE_C_L_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7733
  { IMAGE_SAMPLE_C_L_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 7734
  { IMAGE_SAMPLE_C_L_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7735
  { IMAGE_SAMPLE_C_L_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7736
  { IMAGE_SAMPLE_C_L_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7737
  { IMAGE_SAMPLE_C_L_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 7738
  { IMAGE_SAMPLE_C_L_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7739
  { IMAGE_SAMPLE_C_L_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7740
  { IMAGE_SAMPLE_C_L_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7741
  { IMAGE_SAMPLE_C_L_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 7742
  { IMAGE_SAMPLE_C_L_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7743
  { IMAGE_SAMPLE_C_L_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7744
  { IMAGE_SAMPLE_C_L_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_L, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7745
  { IMAGE_SAMPLE_C_L_V1_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 7746
  { IMAGE_SAMPLE_C_L_V1_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7747
  { IMAGE_SAMPLE_C_L_V1_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7748
  { IMAGE_SAMPLE_C_L_V1_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7749
  { IMAGE_SAMPLE_C_L_V1_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7750
  { IMAGE_SAMPLE_C_L_V2_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 7751
  { IMAGE_SAMPLE_C_L_V2_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7752
  { IMAGE_SAMPLE_C_L_V2_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7753
  { IMAGE_SAMPLE_C_L_V2_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7754
  { IMAGE_SAMPLE_C_L_V2_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7755
  { IMAGE_SAMPLE_C_L_V3_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 7756
  { IMAGE_SAMPLE_C_L_V3_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7757
  { IMAGE_SAMPLE_C_L_V3_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7758
  { IMAGE_SAMPLE_C_L_V3_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7759
  { IMAGE_SAMPLE_C_L_V3_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7760
  { IMAGE_SAMPLE_C_L_V4_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 7761
  { IMAGE_SAMPLE_C_L_V4_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7762
  { IMAGE_SAMPLE_C_L_V4_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7763
  { IMAGE_SAMPLE_C_L_V4_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7764
  { IMAGE_SAMPLE_C_L_V4_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7765
  { IMAGE_SAMPLE_C_L_V5_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 7766
  { IMAGE_SAMPLE_C_L_V5_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7767
  { IMAGE_SAMPLE_C_L_V5_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7768
  { IMAGE_SAMPLE_C_L_V5_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7769
  { IMAGE_SAMPLE_C_L_V5_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7770
  { IMAGE_SAMPLE_C_LZ_V1_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 7771
  { IMAGE_SAMPLE_C_LZ_V1_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7772
  { IMAGE_SAMPLE_C_LZ_V1_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7773
  { IMAGE_SAMPLE_C_LZ_V2_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 7774
  { IMAGE_SAMPLE_C_LZ_V2_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7775
  { IMAGE_SAMPLE_C_LZ_V2_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7776
  { IMAGE_SAMPLE_C_LZ_V3_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 7777
  { IMAGE_SAMPLE_C_LZ_V3_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7778
  { IMAGE_SAMPLE_C_LZ_V3_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7779
  { IMAGE_SAMPLE_C_LZ_V4_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 7780
  { IMAGE_SAMPLE_C_LZ_V4_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7781
  { IMAGE_SAMPLE_C_LZ_V4_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7782
  { IMAGE_SAMPLE_C_LZ_V5_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 7783
  { IMAGE_SAMPLE_C_LZ_V5_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7784
  { IMAGE_SAMPLE_C_LZ_V5_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7785
  { IMAGE_SAMPLE_C_LZ_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 7786
  { IMAGE_SAMPLE_C_LZ_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7787
  { IMAGE_SAMPLE_C_LZ_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7788
  { IMAGE_SAMPLE_C_LZ_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 7789
  { IMAGE_SAMPLE_C_LZ_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7790
  { IMAGE_SAMPLE_C_LZ_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7791
  { IMAGE_SAMPLE_C_LZ_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 7792
  { IMAGE_SAMPLE_C_LZ_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7793
  { IMAGE_SAMPLE_C_LZ_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7794
  { IMAGE_SAMPLE_C_LZ_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 7795
  { IMAGE_SAMPLE_C_LZ_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7796
  { IMAGE_SAMPLE_C_LZ_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7797
  { IMAGE_SAMPLE_C_LZ_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 7798
  { IMAGE_SAMPLE_C_LZ_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7799
  { IMAGE_SAMPLE_C_LZ_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7800
  { IMAGE_SAMPLE_C_LZ_V1_V2_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 7801
  { IMAGE_SAMPLE_C_LZ_V1_V3_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7802
  { IMAGE_SAMPLE_C_LZ_V1_V4_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7803
  { IMAGE_SAMPLE_C_LZ_V2_V2_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 7804
  { IMAGE_SAMPLE_C_LZ_V2_V3_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7805
  { IMAGE_SAMPLE_C_LZ_V2_V4_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7806
  { IMAGE_SAMPLE_C_LZ_V3_V2_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 7807
  { IMAGE_SAMPLE_C_LZ_V3_V3_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7808
  { IMAGE_SAMPLE_C_LZ_V3_V4_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7809
  { IMAGE_SAMPLE_C_LZ_V4_V2_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 7810
  { IMAGE_SAMPLE_C_LZ_V4_V3_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7811
  { IMAGE_SAMPLE_C_LZ_V4_V4_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7812
  { IMAGE_SAMPLE_C_LZ_V5_V2_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 7813
  { IMAGE_SAMPLE_C_LZ_V5_V3_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7814
  { IMAGE_SAMPLE_C_LZ_V5_V4_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7815
  { IMAGE_SAMPLE_C_LZ_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 7816
  { IMAGE_SAMPLE_C_LZ_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7817
  { IMAGE_SAMPLE_C_LZ_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7818
  { IMAGE_SAMPLE_C_LZ_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 7819
  { IMAGE_SAMPLE_C_LZ_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7820
  { IMAGE_SAMPLE_C_LZ_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7821
  { IMAGE_SAMPLE_C_LZ_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 7822
  { IMAGE_SAMPLE_C_LZ_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7823
  { IMAGE_SAMPLE_C_LZ_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7824
  { IMAGE_SAMPLE_C_LZ_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 7825
  { IMAGE_SAMPLE_C_LZ_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7826
  { IMAGE_SAMPLE_C_LZ_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7827
  { IMAGE_SAMPLE_C_LZ_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 7828
  { IMAGE_SAMPLE_C_LZ_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7829
  { IMAGE_SAMPLE_C_LZ_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7830
  { IMAGE_SAMPLE_C_LZ_V1_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 7831
  { IMAGE_SAMPLE_C_LZ_V1_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7832
  { IMAGE_SAMPLE_C_LZ_V1_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7833
  { IMAGE_SAMPLE_C_LZ_V2_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 7834
  { IMAGE_SAMPLE_C_LZ_V2_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7835
  { IMAGE_SAMPLE_C_LZ_V2_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7836
  { IMAGE_SAMPLE_C_LZ_V3_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 7837
  { IMAGE_SAMPLE_C_LZ_V3_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7838
  { IMAGE_SAMPLE_C_LZ_V3_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7839
  { IMAGE_SAMPLE_C_LZ_V4_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 7840
  { IMAGE_SAMPLE_C_LZ_V4_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7841
  { IMAGE_SAMPLE_C_LZ_V4_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7842
  { IMAGE_SAMPLE_C_LZ_V5_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 7843
  { IMAGE_SAMPLE_C_LZ_V5_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7844
  { IMAGE_SAMPLE_C_LZ_V5_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7845
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7846
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7847
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7848
  { IMAGE_SAMPLE_C_LZ_O_V1_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7849
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7850
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7851
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7852
  { IMAGE_SAMPLE_C_LZ_O_V2_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7853
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7854
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7855
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7856
  { IMAGE_SAMPLE_C_LZ_O_V3_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7857
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7858
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7859
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7860
  { IMAGE_SAMPLE_C_LZ_O_V4_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7861
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7862
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7863
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7864
  { IMAGE_SAMPLE_C_LZ_O_V5_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7865
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7866
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7867
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7868
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7869
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7870
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7871
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7872
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7873
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7874
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7875
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7876
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7877
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7878
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7879
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7880
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7881
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7882
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7883
  { IMAGE_SAMPLE_C_LZ_O_V1_V8_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7884
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7885
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7886
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7887
  { IMAGE_SAMPLE_C_LZ_O_V2_V8_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7888
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7889
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7890
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7891
  { IMAGE_SAMPLE_C_LZ_O_V3_V8_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7892
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7893
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7894
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7895
  { IMAGE_SAMPLE_C_LZ_O_V4_V8_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7896
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7897
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7898
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7899
  { IMAGE_SAMPLE_C_LZ_O_V5_V8_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7900
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7901
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7902
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7903
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7904
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7905
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7906
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7907
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7908
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7909
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7910
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7911
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7912
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7913
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7914
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7915
  { IMAGE_SAMPLE_C_LZ_O_V1_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7916
  { IMAGE_SAMPLE_C_LZ_O_V1_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7917
  { IMAGE_SAMPLE_C_LZ_O_V1_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7918
  { IMAGE_SAMPLE_C_LZ_O_V1_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7919
  { IMAGE_SAMPLE_C_LZ_O_V2_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7920
  { IMAGE_SAMPLE_C_LZ_O_V2_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7921
  { IMAGE_SAMPLE_C_LZ_O_V2_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7922
  { IMAGE_SAMPLE_C_LZ_O_V2_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7923
  { IMAGE_SAMPLE_C_LZ_O_V3_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7924
  { IMAGE_SAMPLE_C_LZ_O_V3_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7925
  { IMAGE_SAMPLE_C_LZ_O_V3_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7926
  { IMAGE_SAMPLE_C_LZ_O_V3_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7927
  { IMAGE_SAMPLE_C_LZ_O_V4_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7928
  { IMAGE_SAMPLE_C_LZ_O_V4_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7929
  { IMAGE_SAMPLE_C_LZ_O_V4_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7930
  { IMAGE_SAMPLE_C_LZ_O_V4_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7931
  { IMAGE_SAMPLE_C_LZ_O_V5_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7932
  { IMAGE_SAMPLE_C_LZ_O_V5_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7933
  { IMAGE_SAMPLE_C_LZ_O_V5_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7934
  { IMAGE_SAMPLE_C_LZ_O_V5_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7935
  { IMAGE_SAMPLE_C_L_O_V1_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7936
  { IMAGE_SAMPLE_C_L_O_V1_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7937
  { IMAGE_SAMPLE_C_L_O_V1_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7938
  { IMAGE_SAMPLE_C_L_O_V1_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7939
  { IMAGE_SAMPLE_C_L_O_V1_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7940
  { IMAGE_SAMPLE_C_L_O_V2_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7941
  { IMAGE_SAMPLE_C_L_O_V2_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7942
  { IMAGE_SAMPLE_C_L_O_V2_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7943
  { IMAGE_SAMPLE_C_L_O_V2_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7944
  { IMAGE_SAMPLE_C_L_O_V2_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7945
  { IMAGE_SAMPLE_C_L_O_V3_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7946
  { IMAGE_SAMPLE_C_L_O_V3_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7947
  { IMAGE_SAMPLE_C_L_O_V3_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7948
  { IMAGE_SAMPLE_C_L_O_V3_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7949
  { IMAGE_SAMPLE_C_L_O_V3_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7950
  { IMAGE_SAMPLE_C_L_O_V4_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7951
  { IMAGE_SAMPLE_C_L_O_V4_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7952
  { IMAGE_SAMPLE_C_L_O_V4_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7953
  { IMAGE_SAMPLE_C_L_O_V4_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7954
  { IMAGE_SAMPLE_C_L_O_V4_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7955
  { IMAGE_SAMPLE_C_L_O_V5_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7956
  { IMAGE_SAMPLE_C_L_O_V5_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7957
  { IMAGE_SAMPLE_C_L_O_V5_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7958
  { IMAGE_SAMPLE_C_L_O_V5_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7959
  { IMAGE_SAMPLE_C_L_O_V5_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7960
  { IMAGE_SAMPLE_C_L_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7961
  { IMAGE_SAMPLE_C_L_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7962
  { IMAGE_SAMPLE_C_L_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7963
  { IMAGE_SAMPLE_C_L_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7964
  { IMAGE_SAMPLE_C_L_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7965
  { IMAGE_SAMPLE_C_L_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7966
  { IMAGE_SAMPLE_C_L_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7967
  { IMAGE_SAMPLE_C_L_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7968
  { IMAGE_SAMPLE_C_L_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7969
  { IMAGE_SAMPLE_C_L_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7970
  { IMAGE_SAMPLE_C_L_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7971
  { IMAGE_SAMPLE_C_L_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7972
  { IMAGE_SAMPLE_C_L_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7973
  { IMAGE_SAMPLE_C_L_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7974
  { IMAGE_SAMPLE_C_L_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7975
  { IMAGE_SAMPLE_C_L_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7976
  { IMAGE_SAMPLE_C_L_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7977
  { IMAGE_SAMPLE_C_L_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7978
  { IMAGE_SAMPLE_C_L_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7979
  { IMAGE_SAMPLE_C_L_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7980
  { IMAGE_SAMPLE_C_L_O_V1_V3_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7981
  { IMAGE_SAMPLE_C_L_O_V1_V4_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7982
  { IMAGE_SAMPLE_C_L_O_V1_V5_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7983
  { IMAGE_SAMPLE_C_L_O_V1_V6_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7984
  { IMAGE_SAMPLE_C_L_O_V1_V8_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7985
  { IMAGE_SAMPLE_C_L_O_V2_V3_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7986
  { IMAGE_SAMPLE_C_L_O_V2_V4_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7987
  { IMAGE_SAMPLE_C_L_O_V2_V5_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7988
  { IMAGE_SAMPLE_C_L_O_V2_V6_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7989
  { IMAGE_SAMPLE_C_L_O_V2_V8_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7990
  { IMAGE_SAMPLE_C_L_O_V3_V3_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7991
  { IMAGE_SAMPLE_C_L_O_V3_V4_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7992
  { IMAGE_SAMPLE_C_L_O_V3_V5_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7993
  { IMAGE_SAMPLE_C_L_O_V3_V6_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7994
  { IMAGE_SAMPLE_C_L_O_V3_V8_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7995
  { IMAGE_SAMPLE_C_L_O_V4_V3_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7996
  { IMAGE_SAMPLE_C_L_O_V4_V4_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7997
  { IMAGE_SAMPLE_C_L_O_V4_V5_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7998
  { IMAGE_SAMPLE_C_L_O_V4_V6_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7999
  { IMAGE_SAMPLE_C_L_O_V4_V8_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 8000
  { IMAGE_SAMPLE_C_L_O_V5_V3_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 8001
  { IMAGE_SAMPLE_C_L_O_V5_V4_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 8002
  { IMAGE_SAMPLE_C_L_O_V5_V5_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 8003
  { IMAGE_SAMPLE_C_L_O_V5_V6_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 8004
  { IMAGE_SAMPLE_C_L_O_V5_V8_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 8005
  { IMAGE_SAMPLE_C_L_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 8006
  { IMAGE_SAMPLE_C_L_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 8007
  { IMAGE_SAMPLE_C_L_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 8008
  { IMAGE_SAMPLE_C_L_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 8009
  { IMAGE_SAMPLE_C_L_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 8010
  { IMAGE_SAMPLE_C_L_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 8011
  { IMAGE_SAMPLE_C_L_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 8012
  { IMAGE_SAMPLE_C_L_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 8013
  { IMAGE_SAMPLE_C_L_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 8014
  { IMAGE_SAMPLE_C_L_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 8015
  { IMAGE_SAMPLE_C_L_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 8016
  { IMAGE_SAMPLE_C_L_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 8017
  { IMAGE_SAMPLE_C_L_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 8018
  { IMAGE_SAMPLE_C_L_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 8019
  { IMAGE_SAMPLE_C_L_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 8020
  { IMAGE_SAMPLE_C_L_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 8021
  { IMAGE_SAMPLE_C_L_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 8022
  { IMAGE_SAMPLE_C_L_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 8023
  { IMAGE_SAMPLE_C_L_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 8024
  { IMAGE_SAMPLE_C_L_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_L_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 8025
  { IMAGE_SAMPLE_C_L_O_V1_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 8026
  { IMAGE_SAMPLE_C_L_O_V1_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 8027
  { IMAGE_SAMPLE_C_L_O_V1_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 8028
  { IMAGE_SAMPLE_C_L_O_V1_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 8029
  { IMAGE_SAMPLE_C_L_O_V1_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 8030
  { IMAGE_SAMPLE_C_L_O_V2_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 8031
  { IMAGE_SAMPLE_C_L_O_V2_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 8032
  { IMAGE_SAMPLE_C_L_O_V2_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 8033
  { IMAGE_SAMPLE_C_L_O_V2_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 8034
  { IMAGE_SAMPLE_C_L_O_V2_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 8035
  { IMAGE_SAMPLE_C_L_O_V3_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 8036
  { IMAGE_SAMPLE_C_L_O_V3_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 8037
  { IMAGE_SAMPLE_C_L_O_V3_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 8038
  { IMAGE_SAMPLE_C_L_O_V3_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 8039
  { IMAGE_SAMPLE_C_L_O_V3_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 8040
  { IMAGE_SAMPLE_C_L_O_V4_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 8041
  { IMAGE_SAMPLE_C_L_O_V4_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 8042
  { IMAGE_SAMPLE_C_L_O_V4_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 8043
  { IMAGE_SAMPLE_C_L_O_V4_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 8044
  { IMAGE_SAMPLE_C_L_O_V4_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 8045
  { IMAGE_SAMPLE_C_L_O_V5_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 8046
  { IMAGE_SAMPLE_C_L_O_V5_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 8047
  { IMAGE_SAMPLE_C_L_O_V5_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 8048
  { IMAGE_SAMPLE_C_L_O_V5_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 8049
  { IMAGE_SAMPLE_C_L_O_V5_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 8050
  { IMAGE_SAMPLE_C_O_V1_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 8051
  { IMAGE_SAMPLE_C_O_V1_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 8052
  { IMAGE_SAMPLE_C_O_V1_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 8053
  { IMAGE_SAMPLE_C_O_V1_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 8054
  { IMAGE_SAMPLE_C_O_V2_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 8055
  { IMAGE_SAMPLE_C_O_V2_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 8056
  { IMAGE_SAMPLE_C_O_V2_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 8057
  { IMAGE_SAMPLE_C_O_V2_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 8058
  { IMAGE_SAMPLE_C_O_V3_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 8059
  { IMAGE_SAMPLE_C_O_V3_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 8060
  { IMAGE_SAMPLE_C_O_V3_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 8061
  { IMAGE_SAMPLE_C_O_V3_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 8062
  { IMAGE_SAMPLE_C_O_V4_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 8063
  { IMAGE_SAMPLE_C_O_V4_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 8064
  { IMAGE_SAMPLE_C_O_V4_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 8065
  { IMAGE_SAMPLE_C_O_V4_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 8066
  { IMAGE_SAMPLE_C_O_V5_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 8067
  { IMAGE_SAMPLE_C_O_V5_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 8068
  { IMAGE_SAMPLE_C_O_V5_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 8069
  { IMAGE_SAMPLE_C_O_V5_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 8070
  { IMAGE_SAMPLE_C_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 8071
  { IMAGE_SAMPLE_C_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 8072
  { IMAGE_SAMPLE_C_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 8073
  { IMAGE_SAMPLE_C_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 8074
  { IMAGE_SAMPLE_C_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 8075
  { IMAGE_SAMPLE_C_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 8076
  { IMAGE_SAMPLE_C_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 8077
  { IMAGE_SAMPLE_C_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 8078
  { IMAGE_SAMPLE_C_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 8079
  { IMAGE_SAMPLE_C_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 8080
  { IMAGE_SAMPLE_C_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 8081
  { IMAGE_SAMPLE_C_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 8082
  { IMAGE_SAMPLE_C_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 8083
  { IMAGE_SAMPLE_C_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 8084
  { IMAGE_SAMPLE_C_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 8085
  { IMAGE_SAMPLE_C_O_V1_V3_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 8086
  { IMAGE_SAMPLE_C_O_V1_V4_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 8087
  { IMAGE_SAMPLE_C_O_V1_V5_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 8088
  { IMAGE_SAMPLE_C_O_V1_V8_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 8089
  { IMAGE_SAMPLE_C_O_V2_V3_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 8090
  { IMAGE_SAMPLE_C_O_V2_V4_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 8091
  { IMAGE_SAMPLE_C_O_V2_V5_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 8092
  { IMAGE_SAMPLE_C_O_V2_V8_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 8093
  { IMAGE_SAMPLE_C_O_V3_V3_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 8094
  { IMAGE_SAMPLE_C_O_V3_V4_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 8095
  { IMAGE_SAMPLE_C_O_V3_V5_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 8096
  { IMAGE_SAMPLE_C_O_V3_V8_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 8097
  { IMAGE_SAMPLE_C_O_V4_V3_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 8098
  { IMAGE_SAMPLE_C_O_V4_V4_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 8099
  { IMAGE_SAMPLE_C_O_V4_V5_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 8100
  { IMAGE_SAMPLE_C_O_V4_V8_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 8101
  { IMAGE_SAMPLE_C_O_V5_V3_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 8102
  { IMAGE_SAMPLE_C_O_V5_V4_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 8103
  { IMAGE_SAMPLE_C_O_V5_V5_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 8104
  { IMAGE_SAMPLE_C_O_V5_V8_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 8105
  { IMAGE_SAMPLE_C_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 8106
  { IMAGE_SAMPLE_C_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 8107
  { IMAGE_SAMPLE_C_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 8108
  { IMAGE_SAMPLE_C_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 8109
  { IMAGE_SAMPLE_C_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 8110
  { IMAGE_SAMPLE_C_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 8111
  { IMAGE_SAMPLE_C_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 8112
  { IMAGE_SAMPLE_C_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 8113
  { IMAGE_SAMPLE_C_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 8114
  { IMAGE_SAMPLE_C_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 8115
  { IMAGE_SAMPLE_C_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 8116
  { IMAGE_SAMPLE_C_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 8117
  { IMAGE_SAMPLE_C_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 8118
  { IMAGE_SAMPLE_C_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 8119
  { IMAGE_SAMPLE_C_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 8120
  { IMAGE_SAMPLE_C_O_V1_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 8121
  { IMAGE_SAMPLE_C_O_V1_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 8122
  { IMAGE_SAMPLE_C_O_V1_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 8123
  { IMAGE_SAMPLE_C_O_V1_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 8124
  { IMAGE_SAMPLE_C_O_V2_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 8125
  { IMAGE_SAMPLE_C_O_V2_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 8126
  { IMAGE_SAMPLE_C_O_V2_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 8127
  { IMAGE_SAMPLE_C_O_V2_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 8128
  { IMAGE_SAMPLE_C_O_V3_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 8129
  { IMAGE_SAMPLE_C_O_V3_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 8130
  { IMAGE_SAMPLE_C_O_V3_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 8131
  { IMAGE_SAMPLE_C_O_V3_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 8132
  { IMAGE_SAMPLE_C_O_V4_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 8133
  { IMAGE_SAMPLE_C_O_V4_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 8134
  { IMAGE_SAMPLE_C_O_V4_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 8135
  { IMAGE_SAMPLE_C_O_V4_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 8136
  { IMAGE_SAMPLE_C_O_V5_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 8137
  { IMAGE_SAMPLE_C_O_V5_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 8138
  { IMAGE_SAMPLE_C_O_V5_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 8139
  { IMAGE_SAMPLE_C_O_V5_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 8140
  { IMAGE_SAMPLE_D_V1_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 8141
  { IMAGE_SAMPLE_D_V1_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 8142
  { IMAGE_SAMPLE_D_V1_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 8143
  { IMAGE_SAMPLE_D_V1_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 8144
  { IMAGE_SAMPLE_D_V1_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 8145
  { IMAGE_SAMPLE_D_V1_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 8146
  { IMAGE_SAMPLE_D_V1_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 8147
  { IMAGE_SAMPLE_D_V1_V9_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 8148
  { IMAGE_SAMPLE_D_V2_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 8149
  { IMAGE_SAMPLE_D_V2_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 8150
  { IMAGE_SAMPLE_D_V2_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 8151
  { IMAGE_SAMPLE_D_V2_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 8152
  { IMAGE_SAMPLE_D_V2_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 8153
  { IMAGE_SAMPLE_D_V2_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 8154
  { IMAGE_SAMPLE_D_V2_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 8155
  { IMAGE_SAMPLE_D_V2_V9_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 8156
  { IMAGE_SAMPLE_D_V3_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 8157
  { IMAGE_SAMPLE_D_V3_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 8158
  { IMAGE_SAMPLE_D_V3_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 8159
  { IMAGE_SAMPLE_D_V3_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 8160
  { IMAGE_SAMPLE_D_V3_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 8161
  { IMAGE_SAMPLE_D_V3_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 8162
  { IMAGE_SAMPLE_D_V3_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 8163
  { IMAGE_SAMPLE_D_V3_V9_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 8164
  { IMAGE_SAMPLE_D_V4_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 8165
  { IMAGE_SAMPLE_D_V4_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 8166
  { IMAGE_SAMPLE_D_V4_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 8167
  { IMAGE_SAMPLE_D_V4_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 8168
  { IMAGE_SAMPLE_D_V4_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 8169
  { IMAGE_SAMPLE_D_V4_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 8170
  { IMAGE_SAMPLE_D_V4_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 8171
  { IMAGE_SAMPLE_D_V4_V9_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 8172
  { IMAGE_SAMPLE_D_V5_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 8173
  { IMAGE_SAMPLE_D_V5_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 8174
  { IMAGE_SAMPLE_D_V5_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 8175
  { IMAGE_SAMPLE_D_V5_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 8176
  { IMAGE_SAMPLE_D_V5_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 8177
  { IMAGE_SAMPLE_D_V5_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 8178
  { IMAGE_SAMPLE_D_V5_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 8179
  { IMAGE_SAMPLE_D_V5_V9_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 8180
  { IMAGE_SAMPLE_D_V1_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 8181
  { IMAGE_SAMPLE_D_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 8182
  { IMAGE_SAMPLE_D_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 8183
  { IMAGE_SAMPLE_D_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 8184
  { IMAGE_SAMPLE_D_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 8185
  { IMAGE_SAMPLE_D_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 8186
  { IMAGE_SAMPLE_D_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 8187
  { IMAGE_SAMPLE_D_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 8188
  { IMAGE_SAMPLE_D_V2_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 8189
  { IMAGE_SAMPLE_D_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 8190
  { IMAGE_SAMPLE_D_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 8191
  { IMAGE_SAMPLE_D_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 8192
  { IMAGE_SAMPLE_D_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 8193
  { IMAGE_SAMPLE_D_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 8194
  { IMAGE_SAMPLE_D_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 8195
  { IMAGE_SAMPLE_D_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 8196
  { IMAGE_SAMPLE_D_V3_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 8197
  { IMAGE_SAMPLE_D_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 8198
  { IMAGE_SAMPLE_D_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 8199
  { IMAGE_SAMPLE_D_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 8200
  { IMAGE_SAMPLE_D_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 8201
  { IMAGE_SAMPLE_D_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 8202
  { IMAGE_SAMPLE_D_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 8203
  { IMAGE_SAMPLE_D_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 8204
  { IMAGE_SAMPLE_D_V4_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 8205
  { IMAGE_SAMPLE_D_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 8206
  { IMAGE_SAMPLE_D_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 8207
  { IMAGE_SAMPLE_D_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 8208
  { IMAGE_SAMPLE_D_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 8209
  { IMAGE_SAMPLE_D_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 8210
  { IMAGE_SAMPLE_D_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 8211
  { IMAGE_SAMPLE_D_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 8212
  { IMAGE_SAMPLE_D_V5_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 8213
  { IMAGE_SAMPLE_D_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 8214
  { IMAGE_SAMPLE_D_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 8215
  { IMAGE_SAMPLE_D_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 8216
  { IMAGE_SAMPLE_D_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 8217
  { IMAGE_SAMPLE_D_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 8218
  { IMAGE_SAMPLE_D_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 8219
  { IMAGE_SAMPLE_D_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 8220
  { IMAGE_SAMPLE_D_V1_V2_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 8221
  { IMAGE_SAMPLE_D_V1_V3_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 8222
  { IMAGE_SAMPLE_D_V1_V4_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 8223
  { IMAGE_SAMPLE_D_V1_V5_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 8224
  { IMAGE_SAMPLE_D_V1_V6_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 8225
  { IMAGE_SAMPLE_D_V1_V7_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 8226
  { IMAGE_SAMPLE_D_V1_V8_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 8227
  { IMAGE_SAMPLE_D_V1_V9_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 8228
  { IMAGE_SAMPLE_D_V2_V2_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 8229
  { IMAGE_SAMPLE_D_V2_V3_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 8230
  { IMAGE_SAMPLE_D_V2_V4_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 8231
  { IMAGE_SAMPLE_D_V2_V5_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 8232
  { IMAGE_SAMPLE_D_V2_V6_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 8233
  { IMAGE_SAMPLE_D_V2_V7_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 8234
  { IMAGE_SAMPLE_D_V2_V8_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 8235
  { IMAGE_SAMPLE_D_V2_V9_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 8236
  { IMAGE_SAMPLE_D_V3_V2_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 8237
  { IMAGE_SAMPLE_D_V3_V3_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 8238
  { IMAGE_SAMPLE_D_V3_V4_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 8239
  { IMAGE_SAMPLE_D_V3_V5_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 8240
  { IMAGE_SAMPLE_D_V3_V6_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 8241
  { IMAGE_SAMPLE_D_V3_V7_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 8242
  { IMAGE_SAMPLE_D_V3_V8_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 8243
  { IMAGE_SAMPLE_D_V3_V9_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 8244
  { IMAGE_SAMPLE_D_V4_V2_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 8245
  { IMAGE_SAMPLE_D_V4_V3_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 8246
  { IMAGE_SAMPLE_D_V4_V4_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 8247
  { IMAGE_SAMPLE_D_V4_V5_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 8248
  { IMAGE_SAMPLE_D_V4_V6_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 8249
  { IMAGE_SAMPLE_D_V4_V7_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 8250
  { IMAGE_SAMPLE_D_V4_V8_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 8251
  { IMAGE_SAMPLE_D_V4_V9_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 8252
  { IMAGE_SAMPLE_D_V5_V2_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 8253
  { IMAGE_SAMPLE_D_V5_V3_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 8254
  { IMAGE_SAMPLE_D_V5_V4_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 8255
  { IMAGE_SAMPLE_D_V5_V5_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 8256
  { IMAGE_SAMPLE_D_V5_V6_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 8257
  { IMAGE_SAMPLE_D_V5_V7_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 8258
  { IMAGE_SAMPLE_D_V5_V8_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 8259
  { IMAGE_SAMPLE_D_V5_V9_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 8260
  { IMAGE_SAMPLE_D_V1_V2_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 8261
  { IMAGE_SAMPLE_D_V1_V3_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 8262
  { IMAGE_SAMPLE_D_V1_V4_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 8263
  { IMAGE_SAMPLE_D_V1_V5_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 8264
  { IMAGE_SAMPLE_D_V1_V6_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 8265
  { IMAGE_SAMPLE_D_V1_V7_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 8266
  { IMAGE_SAMPLE_D_V1_V8_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 8267
  { IMAGE_SAMPLE_D_V1_V9_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 8268
  { IMAGE_SAMPLE_D_V2_V2_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 8269
  { IMAGE_SAMPLE_D_V2_V3_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 8270
  { IMAGE_SAMPLE_D_V2_V4_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 8271
  { IMAGE_SAMPLE_D_V2_V5_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 8272
  { IMAGE_SAMPLE_D_V2_V6_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 8273
  { IMAGE_SAMPLE_D_V2_V7_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 8274
  { IMAGE_SAMPLE_D_V2_V8_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 8275
  { IMAGE_SAMPLE_D_V2_V9_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 8276
  { IMAGE_SAMPLE_D_V3_V2_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 8277
  { IMAGE_SAMPLE_D_V3_V3_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 8278
  { IMAGE_SAMPLE_D_V3_V4_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 8279
  { IMAGE_SAMPLE_D_V3_V5_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 8280
  { IMAGE_SAMPLE_D_V3_V6_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 8281
  { IMAGE_SAMPLE_D_V3_V7_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 8282
  { IMAGE_SAMPLE_D_V3_V8_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 8283
  { IMAGE_SAMPLE_D_V3_V9_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 8284
  { IMAGE_SAMPLE_D_V4_V2_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 8285
  { IMAGE_SAMPLE_D_V4_V3_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 8286
  { IMAGE_SAMPLE_D_V4_V4_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 8287
  { IMAGE_SAMPLE_D_V4_V5_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 8288
  { IMAGE_SAMPLE_D_V4_V6_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 8289
  { IMAGE_SAMPLE_D_V4_V7_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 8290
  { IMAGE_SAMPLE_D_V4_V8_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 8291
  { IMAGE_SAMPLE_D_V4_V9_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 8292
  { IMAGE_SAMPLE_D_V5_V2_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 8293
  { IMAGE_SAMPLE_D_V5_V3_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 8294
  { IMAGE_SAMPLE_D_V5_V4_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 8295
  { IMAGE_SAMPLE_D_V5_V5_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 8296
  { IMAGE_SAMPLE_D_V5_V6_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 8297
  { IMAGE_SAMPLE_D_V5_V7_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 8298
  { IMAGE_SAMPLE_D_V5_V8_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 8299
  { IMAGE_SAMPLE_D_V5_V9_nsa_gfx11, IMAGE_SAMPLE_D, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 8300
  { IMAGE_SAMPLE_D_V1_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 8301
  { IMAGE_SAMPLE_D_V1_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 8302
  { IMAGE_SAMPLE_D_V1_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 8303
  { IMAGE_SAMPLE_D_V1_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 8304
  { IMAGE_SAMPLE_D_V1_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 8305
  { IMAGE_SAMPLE_D_V1_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 8306
  { IMAGE_SAMPLE_D_V1_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 8307
  { IMAGE_SAMPLE_D_V1_V9, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 8308
  { IMAGE_SAMPLE_D_V2_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 8309
  { IMAGE_SAMPLE_D_V2_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 8310
  { IMAGE_SAMPLE_D_V2_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 8311
  { IMAGE_SAMPLE_D_V2_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 8312
  { IMAGE_SAMPLE_D_V2_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 8313
  { IMAGE_SAMPLE_D_V2_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 8314
  { IMAGE_SAMPLE_D_V2_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 8315
  { IMAGE_SAMPLE_D_V2_V9, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 8316
  { IMAGE_SAMPLE_D_V3_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 8317
  { IMAGE_SAMPLE_D_V3_V3, IMAGE_SAMPL