/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * LoongArch Disassembler                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace llvm {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * be constructible from an APInt (this can be private)
// * Support insertBits(bits, startBit, numBits)
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
// * Support put (<<) to raw_ostream&
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// a field.
template <typename InsnType>
static std::enable_if_t<std::is_integral<InsnType>::value>
insertBits(InsnType &field, InsnType bits, unsigned startBit, unsigned numBits) {
  assert(startBit + numBits <= sizeof field * 8);
  field |= (InsnType)bits << startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value>
insertBits(InsnType &field, uint64_t bits, unsigned startBit, unsigned numBits) {
  field.insertBits(bits, startBit, numBits);
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 32, 17, 0, // Skip to: 4392
/* 8 */       MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 11 */      MCD::OPC_FilterValue, 0, 69, 10, 0, // Skip to: 2645
/* 16 */      MCD::OPC_ExtractField, 18, 4,  // Inst{21-18} ...
/* 19 */      MCD::OPC_FilterValue, 0, 104, 2, 0, // Skip to: 640
/* 24 */      MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 27 */      MCD::OPC_FilterValue, 0, 112, 1, 0, // Skip to: 400
/* 32 */      MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 35 */      MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 51
/* 40 */      MCD::OPC_CheckField, 2, 3, 0, 161, 93, 0, // Skip to: 24016
/* 47 */      MCD::OPC_Decode, 147, 5, 0, // Opcode: MOVGR2SCR
/* 51 */      MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 67
/* 56 */      MCD::OPC_CheckField, 7, 3, 0, 145, 93, 0, // Skip to: 24016
/* 63 */      MCD::OPC_Decode, 148, 5, 1, // Opcode: MOVSCR2GR
/* 67 */      MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 76
/* 72 */      MCD::OPC_Decode, 164, 3, 2, // Opcode: CLO_W
/* 76 */      MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 85
/* 81 */      MCD::OPC_Decode, 166, 3, 2, // Opcode: CLZ_W
/* 85 */      MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 94
/* 90 */      MCD::OPC_Decode, 180, 3, 2, // Opcode: CTO_W
/* 94 */      MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 103
/* 99 */      MCD::OPC_Decode, 182, 3, 2, // Opcode: CTZ_W
/* 103 */     MCD::OPC_FilterValue, 8, 9, 0, 0, // Skip to: 117
/* 108 */     MCD::OPC_CheckPredicate, 0, 95, 93, 0, // Skip to: 24016
/* 113 */     MCD::OPC_Decode, 163, 3, 2, // Opcode: CLO_D
/* 117 */     MCD::OPC_FilterValue, 9, 9, 0, 0, // Skip to: 131
/* 122 */     MCD::OPC_CheckPredicate, 0, 81, 93, 0, // Skip to: 24016
/* 127 */     MCD::OPC_Decode, 165, 3, 2, // Opcode: CLZ_D
/* 131 */     MCD::OPC_FilterValue, 10, 9, 0, 0, // Skip to: 145
/* 136 */     MCD::OPC_CheckPredicate, 0, 67, 93, 0, // Skip to: 24016
/* 141 */     MCD::OPC_Decode, 179, 3, 2, // Opcode: CTO_D
/* 145 */     MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 159
/* 150 */     MCD::OPC_CheckPredicate, 0, 53, 93, 0, // Skip to: 24016
/* 155 */     MCD::OPC_Decode, 181, 3, 2, // Opcode: CTZ_D
/* 159 */     MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 168
/* 164 */     MCD::OPC_Decode, 178, 5, 2, // Opcode: REVB_2H
/* 168 */     MCD::OPC_FilterValue, 13, 9, 0, 0, // Skip to: 182
/* 173 */     MCD::OPC_CheckPredicate, 0, 30, 93, 0, // Skip to: 24016
/* 178 */     MCD::OPC_Decode, 180, 5, 2, // Opcode: REVB_4H
/* 182 */     MCD::OPC_FilterValue, 14, 9, 0, 0, // Skip to: 196
/* 187 */     MCD::OPC_CheckPredicate, 0, 16, 93, 0, // Skip to: 24016
/* 192 */     MCD::OPC_Decode, 179, 5, 2, // Opcode: REVB_2W
/* 196 */     MCD::OPC_FilterValue, 15, 9, 0, 0, // Skip to: 210
/* 201 */     MCD::OPC_CheckPredicate, 0, 2, 93, 0, // Skip to: 24016
/* 206 */     MCD::OPC_Decode, 181, 5, 2, // Opcode: REVB_D
/* 210 */     MCD::OPC_FilterValue, 16, 9, 0, 0, // Skip to: 224
/* 215 */     MCD::OPC_CheckPredicate, 0, 244, 92, 0, // Skip to: 24016
/* 220 */     MCD::OPC_Decode, 182, 5, 2, // Opcode: REVH_2W
/* 224 */     MCD::OPC_FilterValue, 17, 9, 0, 0, // Skip to: 238
/* 229 */     MCD::OPC_CheckPredicate, 0, 230, 92, 0, // Skip to: 24016
/* 234 */     MCD::OPC_Decode, 183, 5, 2, // Opcode: REVH_D
/* 238 */     MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 146, 3, 2, // Opcode: BITREV_4B
/* 247 */     MCD::OPC_FilterValue, 19, 9, 0, 0, // Skip to: 261
/* 252 */     MCD::OPC_CheckPredicate, 0, 207, 92, 0, // Skip to: 24016
/* 257 */     MCD::OPC_Decode, 147, 3, 2, // Opcode: BITREV_8B
/* 261 */     MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 270
/* 266 */     MCD::OPC_Decode, 149, 3, 2, // Opcode: BITREV_W
/* 270 */     MCD::OPC_FilterValue, 21, 9, 0, 0, // Skip to: 284
/* 275 */     MCD::OPC_CheckPredicate, 0, 184, 92, 0, // Skip to: 24016
/* 280 */     MCD::OPC_Decode, 148, 3, 2, // Opcode: BITREV_D
/* 284 */     MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 293
/* 289 */     MCD::OPC_Decode, 191, 3, 2, // Opcode: EXT_W_H
/* 293 */     MCD::OPC_FilterValue, 23, 4, 0, 0, // Skip to: 302
/* 298 */     MCD::OPC_Decode, 190, 3, 2, // Opcode: EXT_W_B
/* 302 */     MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 311
/* 307 */     MCD::OPC_Decode, 176, 5, 2, // Opcode: RDTIMEL_W
/* 311 */     MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 320
/* 316 */     MCD::OPC_Decode, 175, 5, 2, // Opcode: RDTIMEH_W
/* 320 */     MCD::OPC_FilterValue, 26, 9, 0, 0, // Skip to: 334
/* 325 */     MCD::OPC_CheckPredicate, 0, 134, 92, 0, // Skip to: 24016
/* 330 */     MCD::OPC_Decode, 177, 5, 2, // Opcode: RDTIME_D
/* 334 */     MCD::OPC_FilterValue, 27, 4, 0, 0, // Skip to: 343
/* 339 */     MCD::OPC_Decode, 167, 3, 2, // Opcode: CPUCFG
/* 343 */     MCD::OPC_FilterValue, 28, 18, 0, 0, // Skip to: 366
/* 348 */     MCD::OPC_CheckField, 8, 2, 0, 109, 92, 0, // Skip to: 24016
/* 355 */     MCD::OPC_CheckField, 0, 5, 0, 102, 92, 0, // Skip to: 24016
/* 362 */     MCD::OPC_Decode, 235, 11, 3, // Opcode: X86MTTOP
/* 366 */     MCD::OPC_FilterValue, 29, 11, 0, 0, // Skip to: 382
/* 371 */     MCD::OPC_CheckField, 5, 5, 0, 86, 92, 0, // Skip to: 24016
/* 378 */     MCD::OPC_Decode, 233, 11, 4, // Opcode: X86MFTOP
/* 382 */     MCD::OPC_FilterValue, 30, 4, 0, 0, // Skip to: 391
/* 387 */     MCD::OPC_Decode, 200, 5, 2, // Opcode: SETX86LOOPE
/* 391 */     MCD::OPC_FilterValue, 31, 68, 92, 0, // Skip to: 24016
/* 396 */     MCD::OPC_Decode, 201, 5, 2, // Opcode: SETX86LOOPNE
/* 400 */     MCD::OPC_FilterValue, 1, 193, 0, 0, // Skip to: 598
/* 405 */     MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 408 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 424
/* 413 */     MCD::OPC_CheckField, 10, 5, 0, 44, 92, 0, // Skip to: 24016
/* 420 */     MCD::OPC_Decode, 228, 11, 5, // Opcode: X86INC_B
/* 424 */     MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 440
/* 429 */     MCD::OPC_CheckField, 10, 5, 0, 28, 92, 0, // Skip to: 24016
/* 436 */     MCD::OPC_Decode, 230, 11, 5, // Opcode: X86INC_H
/* 440 */     MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 456
/* 445 */     MCD::OPC_CheckField, 10, 5, 0, 12, 92, 0, // Skip to: 24016
/* 452 */     MCD::OPC_Decode, 231, 11, 5, // Opcode: X86INC_W
/* 456 */     MCD::OPC_FilterValue, 3, 16, 0, 0, // Skip to: 477
/* 461 */     MCD::OPC_CheckPredicate, 0, 254, 91, 0, // Skip to: 24016
/* 466 */     MCD::OPC_CheckField, 10, 5, 0, 247, 91, 0, // Skip to: 24016
/* 473 */     MCD::OPC_Decode, 229, 11, 5, // Opcode: X86INC_D
/* 477 */     MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 493
/* 482 */     MCD::OPC_CheckField, 10, 5, 0, 231, 91, 0, // Skip to: 24016
/* 489 */     MCD::OPC_Decode, 223, 11, 5, // Opcode: X86DEC_B
/* 493 */     MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 509
/* 498 */     MCD::OPC_CheckField, 10, 5, 0, 215, 91, 0, // Skip to: 24016
/* 505 */     MCD::OPC_Decode, 225, 11, 5, // Opcode: X86DEC_H
/* 509 */     MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 525
/* 514 */     MCD::OPC_CheckField, 10, 5, 0, 199, 91, 0, // Skip to: 24016
/* 521 */     MCD::OPC_Decode, 226, 11, 5, // Opcode: X86DEC_W
/* 525 */     MCD::OPC_FilterValue, 7, 16, 0, 0, // Skip to: 546
/* 530 */     MCD::OPC_CheckPredicate, 0, 185, 91, 0, // Skip to: 24016
/* 535 */     MCD::OPC_CheckField, 10, 5, 0, 178, 91, 0, // Skip to: 24016
/* 542 */     MCD::OPC_Decode, 224, 11, 5, // Opcode: X86DEC_D
/* 546 */     MCD::OPC_FilterValue, 8, 21, 0, 0, // Skip to: 572
/* 551 */     MCD::OPC_ExtractField, 5, 10,  // Inst{14-5} ...
/* 554 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 563
/* 559 */     MCD::OPC_Decode, 157, 12, 6, // Opcode: X86SETTM
/* 563 */     MCD::OPC_FilterValue, 1, 152, 91, 0, // Skip to: 24016
/* 568 */     MCD::OPC_Decode, 221, 11, 6, // Opcode: X86CLRTM
/* 572 */     MCD::OPC_FilterValue, 9, 143, 91, 0, // Skip to: 24016
/* 577 */     MCD::OPC_ExtractField, 5, 10,  // Inst{14-5} ...
/* 580 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 589
/* 585 */     MCD::OPC_Decode, 227, 11, 6, // Opcode: X86INCTOP
/* 589 */     MCD::OPC_FilterValue, 1, 126, 91, 0, // Skip to: 24016
/* 594 */     MCD::OPC_Decode, 222, 11, 6, // Opcode: X86DECTOP
/* 598 */     MCD::OPC_FilterValue, 2, 16, 0, 0, // Skip to: 619
/* 603 */     MCD::OPC_CheckPredicate, 0, 112, 91, 0, // Skip to: 24016
/* 608 */     MCD::OPC_CheckField, 0, 5, 0, 105, 91, 0, // Skip to: 24016
/* 615 */     MCD::OPC_Decode, 138, 3, 7, // Opcode: ASRTLE_D
/* 619 */     MCD::OPC_FilterValue, 3, 96, 91, 0, // Skip to: 24016
/* 624 */     MCD::OPC_CheckPredicate, 0, 91, 91, 0, // Skip to: 24016
/* 629 */     MCD::OPC_CheckField, 0, 5, 0, 84, 91, 0, // Skip to: 24016
/* 636 */     MCD::OPC_Decode, 137, 3, 7, // Opcode: ASRTGT_D
/* 640 */     MCD::OPC_FilterValue, 1, 26, 0, 0, // Skip to: 671
/* 645 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 648 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 657
/* 653 */     MCD::OPC_Decode, 202, 2, 8, // Opcode: ALSL_W
/* 657 */     MCD::OPC_FilterValue, 1, 58, 91, 0, // Skip to: 24016
/* 662 */     MCD::OPC_CheckPredicate, 0, 53, 91, 0, // Skip to: 24016
/* 667 */     MCD::OPC_Decode, 203, 2, 8, // Opcode: ALSL_WU
/* 671 */     MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 687
/* 676 */     MCD::OPC_CheckField, 17, 1, 0, 37, 91, 0, // Skip to: 24016
/* 683 */     MCD::OPC_Decode, 161, 3, 9, // Opcode: BYTEPICK_W
/* 687 */     MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 701
/* 692 */     MCD::OPC_CheckPredicate, 0, 23, 91, 0, // Skip to: 24016
/* 697 */     MCD::OPC_Decode, 160, 3, 10, // Opcode: BYTEPICK_D
/* 701 */     MCD::OPC_FilterValue, 4, 85, 0, 0, // Skip to: 791
/* 706 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 709 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 718
/* 714 */     MCD::OPC_Decode, 200, 2, 11, // Opcode: ADD_W
/* 718 */     MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 732
/* 723 */     MCD::OPC_CheckPredicate, 0, 248, 90, 0, // Skip to: 24016
/* 728 */     MCD::OPC_Decode, 199, 2, 11, // Opcode: ADD_D
/* 732 */     MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 741
/* 737 */     MCD::OPC_Decode, 243, 5, 11, // Opcode: SUB_W
/* 741 */     MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 755
/* 746 */     MCD::OPC_CheckPredicate, 0, 225, 90, 0, // Skip to: 24016
/* 751 */     MCD::OPC_Decode, 242, 5, 11, // Opcode: SUB_D
/* 755 */     MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 764
/* 760 */     MCD::OPC_Decode, 208, 5, 11, // Opcode: SLT
/* 764 */     MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 773
/* 769 */     MCD::OPC_Decode, 210, 5, 11, // Opcode: SLTU
/* 773 */     MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 782
/* 778 */     MCD::OPC_Decode, 255, 4, 11, // Opcode: MASKEQZ
/* 782 */     MCD::OPC_FilterValue, 7, 189, 90, 0, // Skip to: 24016
/* 787 */     MCD::OPC_Decode, 128, 5, 11, // Opcode: MASKNEZ
/* 791 */     MCD::OPC_FilterValue, 5, 75, 0, 0, // Skip to: 871
/* 796 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 799 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 808
/* 804 */     MCD::OPC_Decode, 157, 5, 11, // Opcode: NOR
/* 808 */     MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 817
/* 813 */     MCD::OPC_Decode, 240, 2, 11, // Opcode: AND
/* 817 */     MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 826
/* 822 */     MCD::OPC_Decode, 158, 5, 11, // Opcode: OR
/* 826 */     MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 835
/* 831 */     MCD::OPC_Decode, 192, 12, 11, // Opcode: XOR
/* 835 */     MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 844
/* 840 */     MCD::OPC_Decode, 160, 5, 11, // Opcode: ORN
/* 844 */     MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 853
/* 849 */     MCD::OPC_Decode, 242, 2, 11, // Opcode: ANDN
/* 853 */     MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 862
/* 858 */     MCD::OPC_Decode, 207, 5, 11, // Opcode: SLL_W
/* 862 */     MCD::OPC_FilterValue, 7, 109, 90, 0, // Skip to: 24016
/* 867 */     MCD::OPC_Decode, 219, 5, 11, // Opcode: SRL_W
/* 871 */     MCD::OPC_FilterValue, 6, 95, 0, 0, // Skip to: 971
/* 876 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 879 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 888
/* 884 */     MCD::OPC_Decode, 215, 5, 11, // Opcode: SRA_W
/* 888 */     MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 902
/* 893 */     MCD::OPC_CheckPredicate, 0, 78, 90, 0, // Skip to: 24016
/* 898 */     MCD::OPC_Decode, 206, 5, 11, // Opcode: SLL_D
/* 902 */     MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 916
/* 907 */     MCD::OPC_CheckPredicate, 0, 64, 90, 0, // Skip to: 24016
/* 912 */     MCD::OPC_Decode, 218, 5, 11, // Opcode: SRL_D
/* 916 */     MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 930
/* 921 */     MCD::OPC_CheckPredicate, 0, 50, 90, 0, // Skip to: 24016
/* 926 */     MCD::OPC_Decode, 214, 5, 11, // Opcode: SRA_D
/* 930 */     MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 939
/* 935 */     MCD::OPC_Decode, 188, 5, 11, // Opcode: ROTR_B
/* 939 */     MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 948
/* 944 */     MCD::OPC_Decode, 190, 5, 11, // Opcode: ROTR_H
/* 948 */     MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 957
/* 953 */     MCD::OPC_Decode, 191, 5, 11, // Opcode: ROTR_W
/* 957 */     MCD::OPC_FilterValue, 7, 14, 90, 0, // Skip to: 24016
/* 962 */     MCD::OPC_CheckPredicate, 0, 9, 90, 0, // Skip to: 24016
/* 967 */     MCD::OPC_Decode, 189, 5, 11, // Opcode: ROTR_D
/* 971 */     MCD::OPC_FilterValue, 7, 100, 0, 0, // Skip to: 1076
/* 976 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 979 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 988
/* 984 */     MCD::OPC_Decode, 156, 5, 11, // Opcode: MUL_W
/* 988 */     MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 997
/* 993 */     MCD::OPC_Decode, 151, 5, 11, // Opcode: MULH_W
/* 997 */     MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1006
/* 1002 */    MCD::OPC_Decode, 152, 5, 11, // Opcode: MULH_WU
/* 1006 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1020
/* 1011 */    MCD::OPC_CheckPredicate, 0, 216, 89, 0, // Skip to: 24016
/* 1016 */    MCD::OPC_Decode, 155, 5, 11, // Opcode: MUL_D
/* 1020 */    MCD::OPC_FilterValue, 4, 9, 0, 0, // Skip to: 1034
/* 1025 */    MCD::OPC_CheckPredicate, 0, 202, 89, 0, // Skip to: 24016
/* 1030 */    MCD::OPC_Decode, 149, 5, 11, // Opcode: MULH_D
/* 1034 */    MCD::OPC_FilterValue, 5, 9, 0, 0, // Skip to: 1048
/* 1039 */    MCD::OPC_CheckPredicate, 0, 188, 89, 0, // Skip to: 24016
/* 1044 */    MCD::OPC_Decode, 150, 5, 11, // Opcode: MULH_DU
/* 1048 */    MCD::OPC_FilterValue, 6, 9, 0, 0, // Skip to: 1062
/* 1053 */    MCD::OPC_CheckPredicate, 0, 174, 89, 0, // Skip to: 24016
/* 1058 */    MCD::OPC_Decode, 153, 5, 11, // Opcode: MULW_D_W
/* 1062 */    MCD::OPC_FilterValue, 7, 165, 89, 0, // Skip to: 24016
/* 1067 */    MCD::OPC_CheckPredicate, 0, 160, 89, 0, // Skip to: 24016
/* 1072 */    MCD::OPC_Decode, 154, 5, 11, // Opcode: MULW_D_WU
/* 1076 */    MCD::OPC_FilterValue, 8, 95, 0, 0, // Skip to: 1176
/* 1081 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1084 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1093
/* 1089 */    MCD::OPC_Decode, 187, 3, 11, // Opcode: DIV_W
/* 1093 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1102
/* 1098 */    MCD::OPC_Decode, 131, 5, 11, // Opcode: MOD_W
/* 1102 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1111
/* 1107 */    MCD::OPC_Decode, 188, 3, 11, // Opcode: DIV_WU
/* 1111 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 1120
/* 1116 */    MCD::OPC_Decode, 132, 5, 11, // Opcode: MOD_WU
/* 1120 */    MCD::OPC_FilterValue, 4, 9, 0, 0, // Skip to: 1134
/* 1125 */    MCD::OPC_CheckPredicate, 0, 102, 89, 0, // Skip to: 24016
/* 1130 */    MCD::OPC_Decode, 185, 3, 11, // Opcode: DIV_D
/* 1134 */    MCD::OPC_FilterValue, 5, 9, 0, 0, // Skip to: 1148
/* 1139 */    MCD::OPC_CheckPredicate, 0, 88, 89, 0, // Skip to: 24016
/* 1144 */    MCD::OPC_Decode, 129, 5, 11, // Opcode: MOD_D
/* 1148 */    MCD::OPC_FilterValue, 6, 9, 0, 0, // Skip to: 1162
/* 1153 */    MCD::OPC_CheckPredicate, 0, 74, 89, 0, // Skip to: 24016
/* 1158 */    MCD::OPC_Decode, 186, 3, 11, // Opcode: DIV_DU
/* 1162 */    MCD::OPC_FilterValue, 7, 65, 89, 0, // Skip to: 24016
/* 1167 */    MCD::OPC_CheckPredicate, 0, 60, 89, 0, // Skip to: 24016
/* 1172 */    MCD::OPC_Decode, 130, 5, 11, // Opcode: MOD_DU
/* 1176 */    MCD::OPC_FilterValue, 9, 115, 0, 0, // Skip to: 1296
/* 1181 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1184 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 1198
/* 1189 */    MCD::OPC_CheckPredicate, 0, 38, 89, 0, // Skip to: 24016
/* 1194 */    MCD::OPC_Decode, 172, 3, 11, // Opcode: CRC_W_B_W
/* 1198 */    MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 1212
/* 1203 */    MCD::OPC_CheckPredicate, 0, 24, 89, 0, // Skip to: 24016
/* 1208 */    MCD::OPC_Decode, 174, 3, 11, // Opcode: CRC_W_H_W
/* 1212 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 1226
/* 1217 */    MCD::OPC_CheckPredicate, 0, 10, 89, 0, // Skip to: 24016
/* 1222 */    MCD::OPC_Decode, 175, 3, 11, // Opcode: CRC_W_W_W
/* 1226 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1240
/* 1231 */    MCD::OPC_CheckPredicate, 0, 252, 88, 0, // Skip to: 24016
/* 1236 */    MCD::OPC_Decode, 173, 3, 11, // Opcode: CRC_W_D_W
/* 1240 */    MCD::OPC_FilterValue, 4, 9, 0, 0, // Skip to: 1254
/* 1245 */    MCD::OPC_CheckPredicate, 0, 238, 88, 0, // Skip to: 24016
/* 1250 */    MCD::OPC_Decode, 168, 3, 11, // Opcode: CRCC_W_B_W
/* 1254 */    MCD::OPC_FilterValue, 5, 9, 0, 0, // Skip to: 1268
/* 1259 */    MCD::OPC_CheckPredicate, 0, 224, 88, 0, // Skip to: 24016
/* 1264 */    MCD::OPC_Decode, 170, 3, 11, // Opcode: CRCC_W_H_W
/* 1268 */    MCD::OPC_FilterValue, 6, 9, 0, 0, // Skip to: 1282
/* 1273 */    MCD::OPC_CheckPredicate, 0, 210, 88, 0, // Skip to: 24016
/* 1278 */    MCD::OPC_Decode, 171, 3, 11, // Opcode: CRCC_W_W_W
/* 1282 */    MCD::OPC_FilterValue, 7, 201, 88, 0, // Skip to: 24016
/* 1287 */    MCD::OPC_CheckPredicate, 0, 196, 88, 0, // Skip to: 24016
/* 1292 */    MCD::OPC_Decode, 169, 3, 11, // Opcode: CRCC_W_D_W
/* 1296 */    MCD::OPC_FilterValue, 10, 62, 0, 0, // Skip to: 1363
/* 1301 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1304 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1313
/* 1309 */    MCD::OPC_Decode, 197, 2, 12, // Opcode: ADDU12I_W
/* 1313 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1327
/* 1318 */    MCD::OPC_CheckPredicate, 0, 165, 88, 0, // Skip to: 24016
/* 1323 */    MCD::OPC_Decode, 196, 2, 12, // Opcode: ADDU12I_D
/* 1327 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 1336
/* 1332 */    MCD::OPC_Decode, 155, 3, 13, // Opcode: BREAK
/* 1336 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 1345
/* 1341 */    MCD::OPC_Decode, 184, 3, 13, // Opcode: DBCL
/* 1345 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 1354
/* 1350 */    MCD::OPC_Decode, 244, 5, 13, // Opcode: SYSCALL
/* 1354 */    MCD::OPC_FilterValue, 7, 129, 88, 0, // Skip to: 24016
/* 1359 */    MCD::OPC_Decode, 205, 4, 13, // Opcode: HVCL
/* 1363 */    MCD::OPC_FilterValue, 11, 16, 0, 0, // Skip to: 1384
/* 1368 */    MCD::OPC_CheckPredicate, 0, 115, 88, 0, // Skip to: 24016
/* 1373 */    MCD::OPC_CheckField, 17, 1, 0, 108, 88, 0, // Skip to: 24016
/* 1380 */    MCD::OPC_Decode, 201, 2, 8, // Opcode: ALSL_D
/* 1384 */    MCD::OPC_FilterValue, 12, 85, 0, 0, // Skip to: 1474
/* 1389 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1392 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1401
/* 1397 */    MCD::OPC_Decode, 190, 2, 11, // Opcode: ADC_B
/* 1401 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1410
/* 1406 */    MCD::OPC_Decode, 192, 2, 11, // Opcode: ADC_H
/* 1410 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1419
/* 1415 */    MCD::OPC_Decode, 193, 2, 11, // Opcode: ADC_W
/* 1419 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1433
/* 1424 */    MCD::OPC_CheckPredicate, 0, 59, 88, 0, // Skip to: 24016
/* 1429 */    MCD::OPC_Decode, 191, 2, 11, // Opcode: ADC_D
/* 1433 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 1442
/* 1438 */    MCD::OPC_Decode, 192, 5, 11, // Opcode: SBC_B
/* 1442 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 1451
/* 1447 */    MCD::OPC_Decode, 194, 5, 11, // Opcode: SBC_H
/* 1451 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 1460
/* 1456 */    MCD::OPC_Decode, 195, 5, 11, // Opcode: SBC_W
/* 1460 */    MCD::OPC_FilterValue, 7, 23, 88, 0, // Skip to: 24016
/* 1465 */    MCD::OPC_CheckPredicate, 0, 18, 88, 0, // Skip to: 24016
/* 1470 */    MCD::OPC_Decode, 193, 5, 11, // Opcode: SBC_D
/* 1474 */    MCD::OPC_FilterValue, 13, 132, 0, 0, // Skip to: 1611
/* 1479 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1482 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1491
/* 1487 */    MCD::OPC_Decode, 171, 5, 11, // Opcode: RCR_B
/* 1491 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1500
/* 1496 */    MCD::OPC_Decode, 173, 5, 11, // Opcode: RCR_H
/* 1500 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1509
/* 1505 */    MCD::OPC_Decode, 174, 5, 11, // Opcode: RCR_W
/* 1509 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1523
/* 1514 */    MCD::OPC_CheckPredicate, 0, 225, 87, 0, // Skip to: 24016
/* 1519 */    MCD::OPC_Decode, 172, 5, 11, // Opcode: RCR_D
/* 1523 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 1539
/* 1528 */    MCD::OPC_CheckField, 14, 1, 1, 209, 87, 0, // Skip to: 24016
/* 1535 */    MCD::OPC_Decode, 247, 2, 14, // Opcode: ARMMOVE
/* 1539 */    MCD::OPC_FilterValue, 5, 35, 0, 0, // Skip to: 1579
/* 1544 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 1547 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1563
/* 1552 */    MCD::OPC_CheckField, 5, 5, 0, 185, 87, 0, // Skip to: 24016
/* 1559 */    MCD::OPC_Decode, 199, 5, 15, // Opcode: SETX86J
/* 1563 */    MCD::OPC_FilterValue, 1, 176, 87, 0, // Skip to: 24016
/* 1568 */    MCD::OPC_CheckField, 5, 5, 0, 169, 87, 0, // Skip to: 24016
/* 1575 */    MCD::OPC_Decode, 198, 5, 15, // Opcode: SETARMJ
/* 1579 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 1595
/* 1584 */    MCD::OPC_CheckField, 4, 1, 1, 153, 87, 0, // Skip to: 24016
/* 1591 */    MCD::OPC_Decode, 244, 2, 16, // Opcode: ARMADD_W
/* 1595 */    MCD::OPC_FilterValue, 7, 144, 87, 0, // Skip to: 24016
/* 1600 */    MCD::OPC_CheckField, 4, 1, 1, 137, 87, 0, // Skip to: 24016
/* 1607 */    MCD::OPC_Decode, 135, 3, 16, // Opcode: ARMSUB_W
/* 1611 */    MCD::OPC_FilterValue, 14, 131, 0, 0, // Skip to: 1747
/* 1616 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1619 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1635
/* 1624 */    MCD::OPC_CheckField, 4, 1, 1, 113, 87, 0, // Skip to: 24016
/* 1631 */    MCD::OPC_Decode, 243, 2, 16, // Opcode: ARMADC_W
/* 1635 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 1651
/* 1640 */    MCD::OPC_CheckField, 4, 1, 1, 97, 87, 0, // Skip to: 24016
/* 1647 */    MCD::OPC_Decode, 128, 3, 16, // Opcode: ARMSBC_W
/* 1651 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 1667
/* 1656 */    MCD::OPC_CheckField, 4, 1, 1, 81, 87, 0, // Skip to: 24016
/* 1663 */    MCD::OPC_Decode, 245, 2, 16, // Opcode: ARMAND_W
/* 1667 */    MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 1683
/* 1672 */    MCD::OPC_CheckField, 4, 1, 1, 65, 87, 0, // Skip to: 24016
/* 1679 */    MCD::OPC_Decode, 252, 2, 16, // Opcode: ARMOR_W
/* 1683 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 1699
/* 1688 */    MCD::OPC_CheckField, 4, 1, 1, 49, 87, 0, // Skip to: 24016
/* 1695 */    MCD::OPC_Decode, 136, 3, 16, // Opcode: ARMXOR_W
/* 1699 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 1715
/* 1704 */    MCD::OPC_CheckField, 4, 1, 1, 33, 87, 0, // Skip to: 24016
/* 1711 */    MCD::OPC_Decode, 130, 3, 16, // Opcode: ARMSLL_W
/* 1715 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 1731
/* 1720 */    MCD::OPC_CheckField, 4, 1, 1, 17, 87, 0, // Skip to: 24016
/* 1727 */    MCD::OPC_Decode, 134, 3, 16, // Opcode: ARMSRL_W
/* 1731 */    MCD::OPC_FilterValue, 7, 8, 87, 0, // Skip to: 24016
/* 1736 */    MCD::OPC_CheckField, 4, 1, 1, 1, 87, 0, // Skip to: 24016
/* 1743 */    MCD::OPC_Decode, 132, 3, 16, // Opcode: ARMSRA_W
/* 1747 */    MCD::OPC_FilterValue, 15, 248, 86, 0, // Skip to: 24016
/* 1752 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1755 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1771
/* 1760 */    MCD::OPC_CheckField, 4, 1, 1, 233, 86, 0, // Skip to: 24016
/* 1767 */    MCD::OPC_Decode, 254, 2, 16, // Opcode: ARMROTR_W
/* 1771 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 1787
/* 1776 */    MCD::OPC_CheckField, 4, 1, 1, 217, 86, 0, // Skip to: 24016
/* 1783 */    MCD::OPC_Decode, 129, 3, 17, // Opcode: ARMSLLI_W
/* 1787 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 1803
/* 1792 */    MCD::OPC_CheckField, 4, 1, 1, 201, 86, 0, // Skip to: 24016
/* 1799 */    MCD::OPC_Decode, 133, 3, 17, // Opcode: ARMSRLI_W
/* 1803 */    MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 1819
/* 1808 */    MCD::OPC_CheckField, 4, 1, 1, 185, 86, 0, // Skip to: 24016
/* 1815 */    MCD::OPC_Decode, 131, 3, 17, // Opcode: ARMSRAI_W
/* 1819 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 1835
/* 1824 */    MCD::OPC_CheckField, 4, 1, 1, 169, 86, 0, // Skip to: 24016
/* 1831 */    MCD::OPC_Decode, 253, 2, 17, // Opcode: ARMROTRI_W
/* 1835 */    MCD::OPC_FilterValue, 5, 90, 0, 0, // Skip to: 1930
/* 1840 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 1843 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1852
/* 1848 */    MCD::OPC_Decode, 236, 11, 7, // Opcode: X86MUL_B
/* 1852 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1861
/* 1857 */    MCD::OPC_Decode, 240, 11, 7, // Opcode: X86MUL_H
/* 1861 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1870
/* 1866 */    MCD::OPC_Decode, 242, 11, 7, // Opcode: X86MUL_W
/* 1870 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1884
/* 1875 */    MCD::OPC_CheckPredicate, 0, 120, 86, 0, // Skip to: 24016
/* 1880 */    MCD::OPC_Decode, 238, 11, 7, // Opcode: X86MUL_D
/* 1884 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 1893
/* 1889 */    MCD::OPC_Decode, 237, 11, 7, // Opcode: X86MUL_BU
/* 1893 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 1902
/* 1898 */    MCD::OPC_Decode, 241, 11, 7, // Opcode: X86MUL_HU
/* 1902 */    MCD::OPC_FilterValue, 6, 9, 0, 0, // Skip to: 1916
/* 1907 */    MCD::OPC_CheckPredicate, 0, 88, 86, 0, // Skip to: 24016
/* 1912 */    MCD::OPC_Decode, 243, 11, 7, // Opcode: X86MUL_WU
/* 1916 */    MCD::OPC_FilterValue, 7, 79, 86, 0, // Skip to: 24016
/* 1921 */    MCD::OPC_CheckPredicate, 0, 74, 86, 0, // Skip to: 24016
/* 1926 */    MCD::OPC_Decode, 239, 11, 7, // Opcode: X86MUL_DU
/* 1930 */    MCD::OPC_FilterValue, 6, 90, 1, 0, // Skip to: 2281
/* 1935 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 1938 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 1952
/* 1943 */    MCD::OPC_CheckPredicate, 0, 52, 86, 0, // Skip to: 24016
/* 1948 */    MCD::OPC_Decode, 216, 11, 7, // Opcode: X86ADD_WU
/* 1952 */    MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 1966
/* 1957 */    MCD::OPC_CheckPredicate, 0, 38, 86, 0, // Skip to: 24016
/* 1962 */    MCD::OPC_Decode, 213, 11, 7, // Opcode: X86ADD_DU
/* 1966 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 1980
/* 1971 */    MCD::OPC_CheckPredicate, 0, 24, 86, 0, // Skip to: 24016
/* 1976 */    MCD::OPC_Decode, 187, 12, 7, // Opcode: X86SUB_WU
/* 1980 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 1994
/* 1985 */    MCD::OPC_CheckPredicate, 0, 10, 86, 0, // Skip to: 24016
/* 1990 */    MCD::OPC_Decode, 184, 12, 7, // Opcode: X86SUB_DU
/* 1994 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 2003
/* 1999 */    MCD::OPC_Decode, 211, 11, 7, // Opcode: X86ADD_B
/* 2003 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 2012
/* 2008 */    MCD::OPC_Decode, 214, 11, 7, // Opcode: X86ADD_H
/* 2012 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 2021
/* 2017 */    MCD::OPC_Decode, 215, 11, 7, // Opcode: X86ADD_W
/* 2021 */    MCD::OPC_FilterValue, 7, 9, 0, 0, // Skip to: 2035
/* 2026 */    MCD::OPC_CheckPredicate, 0, 225, 85, 0, // Skip to: 24016
/* 2031 */    MCD::OPC_Decode, 212, 11, 7, // Opcode: X86ADD_D
/* 2035 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 2044
/* 2040 */    MCD::OPC_Decode, 182, 12, 7, // Opcode: X86SUB_B
/* 2044 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 2053
/* 2049 */    MCD::OPC_Decode, 185, 12, 7, // Opcode: X86SUB_H
/* 2053 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 2062
/* 2058 */    MCD::OPC_Decode, 186, 12, 7, // Opcode: X86SUB_W
/* 2062 */    MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 2076
/* 2067 */    MCD::OPC_CheckPredicate, 0, 184, 85, 0, // Skip to: 24016
/* 2072 */    MCD::OPC_Decode, 183, 12, 7, // Opcode: X86SUB_D
/* 2076 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 2085
/* 2081 */    MCD::OPC_Decode, 207, 11, 7, // Opcode: X86ADC_B
/* 2085 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 2094
/* 2090 */    MCD::OPC_Decode, 209, 11, 7, // Opcode: X86ADC_H
/* 2094 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 2103
/* 2099 */    MCD::OPC_Decode, 210, 11, 7, // Opcode: X86ADC_W
/* 2103 */    MCD::OPC_FilterValue, 15, 9, 0, 0, // Skip to: 2117
/* 2108 */    MCD::OPC_CheckPredicate, 0, 143, 85, 0, // Skip to: 24016
/* 2113 */    MCD::OPC_Decode, 208, 11, 7, // Opcode: X86ADC_D
/* 2117 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 2126
/* 2122 */    MCD::OPC_Decode, 152, 12, 7, // Opcode: X86SBC_B
/* 2126 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 2135
/* 2131 */    MCD::OPC_Decode, 154, 12, 7, // Opcode: X86SBC_H
/* 2135 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 2144
/* 2140 */    MCD::OPC_Decode, 155, 12, 7, // Opcode: X86SBC_W
/* 2144 */    MCD::OPC_FilterValue, 19, 9, 0, 0, // Skip to: 2158
/* 2149 */    MCD::OPC_CheckPredicate, 0, 102, 85, 0, // Skip to: 24016
/* 2154 */    MCD::OPC_Decode, 153, 12, 7, // Opcode: X86SBC_D
/* 2158 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 2167
/* 2163 */    MCD::OPC_Decode, 162, 12, 7, // Opcode: X86SLL_B
/* 2167 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 2176
/* 2172 */    MCD::OPC_Decode, 164, 12, 7, // Opcode: X86SLL_H
/* 2176 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 2185
/* 2181 */    MCD::OPC_Decode, 165, 12, 7, // Opcode: X86SLL_W
/* 2185 */    MCD::OPC_FilterValue, 23, 9, 0, 0, // Skip to: 2199
/* 2190 */    MCD::OPC_CheckPredicate, 0, 61, 85, 0, // Skip to: 24016
/* 2195 */    MCD::OPC_Decode, 163, 12, 7, // Opcode: X86SLL_D
/* 2199 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 2208
/* 2204 */    MCD::OPC_Decode, 178, 12, 7, // Opcode: X86SRL_B
/* 2208 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 2217
/* 2213 */    MCD::OPC_Decode, 180, 12, 7, // Opcode: X86SRL_H
/* 2217 */    MCD::OPC_FilterValue, 26, 4, 0, 0, // Skip to: 2226
/* 2222 */    MCD::OPC_Decode, 181, 12, 7, // Opcode: X86SRL_W
/* 2226 */    MCD::OPC_FilterValue, 27, 9, 0, 0, // Skip to: 2240
/* 2231 */    MCD::OPC_CheckPredicate, 0, 20, 85, 0, // Skip to: 24016
/* 2236 */    MCD::OPC_Decode, 179, 12, 7, // Opcode: X86SRL_D
/* 2240 */    MCD::OPC_FilterValue, 28, 4, 0, 0, // Skip to: 2249
/* 2245 */    MCD::OPC_Decode, 170, 12, 7, // Opcode: X86SRA_B
/* 2249 */    MCD::OPC_FilterValue, 29, 4, 0, 0, // Skip to: 2258
/* 2254 */    MCD::OPC_Decode, 172, 12, 7, // Opcode: X86SRA_H
/* 2258 */    MCD::OPC_FilterValue, 30, 4, 0, 0, // Skip to: 2267
/* 2263 */    MCD::OPC_Decode, 173, 12, 7, // Opcode: X86SRA_W
/* 2267 */    MCD::OPC_FilterValue, 31, 240, 84, 0, // Skip to: 24016
/* 2272 */    MCD::OPC_CheckPredicate, 0, 235, 84, 0, // Skip to: 24016
/* 2277 */    MCD::OPC_Decode, 171, 12, 7, // Opcode: X86SRA_D
/* 2281 */    MCD::OPC_FilterValue, 7, 226, 84, 0, // Skip to: 24016
/* 2286 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 2289 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 2298
/* 2294 */    MCD::OPC_Decode, 148, 12, 7, // Opcode: X86ROTR_B
/* 2298 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 2307
/* 2303 */    MCD::OPC_Decode, 150, 12, 7, // Opcode: X86ROTR_H
/* 2307 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 2321
/* 2312 */    MCD::OPC_CheckPredicate, 0, 195, 84, 0, // Skip to: 24016
/* 2317 */    MCD::OPC_Decode, 149, 12, 7, // Opcode: X86ROTR_D
/* 2321 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 2330
/* 2326 */    MCD::OPC_Decode, 151, 12, 7, // Opcode: X86ROTR_W
/* 2330 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 2339
/* 2335 */    MCD::OPC_Decode, 140, 12, 7, // Opcode: X86ROTL_B
/* 2339 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 2348
/* 2344 */    MCD::OPC_Decode, 142, 12, 7, // Opcode: X86ROTL_H
/* 2348 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 2357
/* 2353 */    MCD::OPC_Decode, 143, 12, 7, // Opcode: X86ROTL_W
/* 2357 */    MCD::OPC_FilterValue, 7, 9, 0, 0, // Skip to: 2371
/* 2362 */    MCD::OPC_CheckPredicate, 0, 145, 84, 0, // Skip to: 24016
/* 2367 */    MCD::OPC_Decode, 141, 12, 7, // Opcode: X86ROTL_D
/* 2371 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 2380
/* 2376 */    MCD::OPC_Decode, 132, 12, 7, // Opcode: X86RCR_B
/* 2380 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 2389
/* 2385 */    MCD::OPC_Decode, 134, 12, 7, // Opcode: X86RCR_H
/* 2389 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 2398
/* 2394 */    MCD::OPC_Decode, 135, 12, 7, // Opcode: X86RCR_W
/* 2398 */    MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 2412
/* 2403 */    MCD::OPC_CheckPredicate, 0, 104, 84, 0, // Skip to: 24016
/* 2408 */    MCD::OPC_Decode, 133, 12, 7, // Opcode: X86RCR_D
/* 2412 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 2421
/* 2417 */    MCD::OPC_Decode, 252, 11, 7, // Opcode: X86RCL_B
/* 2421 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 2430
/* 2426 */    MCD::OPC_Decode, 254, 11, 7, // Opcode: X86RCL_H
/* 2430 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 2439
/* 2435 */    MCD::OPC_Decode, 255, 11, 7, // Opcode: X86RCL_W
/* 2439 */    MCD::OPC_FilterValue, 15, 9, 0, 0, // Skip to: 2453
/* 2444 */    MCD::OPC_CheckPredicate, 0, 63, 84, 0, // Skip to: 24016
/* 2449 */    MCD::OPC_Decode, 253, 11, 7, // Opcode: X86RCL_D
/* 2453 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 2462
/* 2458 */    MCD::OPC_Decode, 217, 11, 7, // Opcode: X86AND_B
/* 2462 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 2471
/* 2467 */    MCD::OPC_Decode, 219, 11, 7, // Opcode: X86AND_H
/* 2471 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 2480
/* 2476 */    MCD::OPC_Decode, 220, 11, 7, // Opcode: X86AND_W
/* 2480 */    MCD::OPC_FilterValue, 19, 9, 0, 0, // Skip to: 2494
/* 2485 */    MCD::OPC_CheckPredicate, 0, 22, 84, 0, // Skip to: 24016
/* 2490 */    MCD::OPC_Decode, 218, 11, 7, // Opcode: X86AND_D
/* 2494 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 2503
/* 2499 */    MCD::OPC_Decode, 244, 11, 7, // Opcode: X86OR_B
/* 2503 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 2512
/* 2508 */    MCD::OPC_Decode, 246, 11, 7, // Opcode: X86OR_H
/* 2512 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 2521
/* 2517 */    MCD::OPC_Decode, 247, 11, 7, // Opcode: X86OR_W
/* 2521 */    MCD::OPC_FilterValue, 23, 9, 0, 0, // Skip to: 2535
/* 2526 */    MCD::OPC_CheckPredicate, 0, 237, 83, 0, // Skip to: 24016
/* 2531 */    MCD::OPC_Decode, 245, 11, 7, // Opcode: X86OR_D
/* 2535 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 2544
/* 2540 */    MCD::OPC_Decode, 188, 12, 7, // Opcode: X86XOR_B
/* 2544 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 2553
/* 2549 */    MCD::OPC_Decode, 190, 12, 7, // Opcode: X86XOR_H
/* 2553 */    MCD::OPC_FilterValue, 26, 4, 0, 0, // Skip to: 2562
/* 2558 */    MCD::OPC_Decode, 191, 12, 7, // Opcode: X86XOR_W
/* 2562 */    MCD::OPC_FilterValue, 27, 9, 0, 0, // Skip to: 2576
/* 2567 */    MCD::OPC_CheckPredicate, 0, 196, 83, 0, // Skip to: 24016
/* 2572 */    MCD::OPC_Decode, 189, 12, 7, // Opcode: X86XOR_D
/* 2576 */    MCD::OPC_FilterValue, 28, 11, 0, 0, // Skip to: 2592
/* 2581 */    MCD::OPC_CheckField, 14, 1, 1, 180, 83, 0, // Skip to: 24016
/* 2588 */    MCD::OPC_Decode, 251, 2, 18, // Opcode: ARMNOT_W
/* 2592 */    MCD::OPC_FilterValue, 29, 11, 0, 0, // Skip to: 2608
/* 2597 */    MCD::OPC_CheckField, 14, 1, 1, 164, 83, 0, // Skip to: 24016
/* 2604 */    MCD::OPC_Decode, 249, 2, 18, // Opcode: ARMMOV_W
/* 2608 */    MCD::OPC_FilterValue, 30, 16, 0, 0, // Skip to: 2629
/* 2613 */    MCD::OPC_CheckPredicate, 0, 150, 83, 0, // Skip to: 24016
/* 2618 */    MCD::OPC_CheckField, 14, 1, 1, 143, 83, 0, // Skip to: 24016
/* 2625 */    MCD::OPC_Decode, 248, 2, 18, // Opcode: ARMMOV_D
/* 2629 */    MCD::OPC_FilterValue, 31, 134, 83, 0, // Skip to: 24016
/* 2634 */    MCD::OPC_CheckField, 14, 1, 1, 127, 83, 0, // Skip to: 24016
/* 2641 */    MCD::OPC_Decode, 255, 2, 18, // Opcode: ARMRRX_W
/* 2645 */    MCD::OPC_FilterValue, 1, 71, 3, 0, // Skip to: 3489
/* 2650 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 2653 */    MCD::OPC_FilterValue, 0, 37, 3, 0, // Skip to: 3463
/* 2658 */    MCD::OPC_ExtractField, 18, 3,  // Inst{20-18} ...
/* 2661 */    MCD::OPC_FilterValue, 0, 33, 0, 0, // Skip to: 2699
/* 2666 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2669 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2685
/* 2674 */    MCD::OPC_CheckField, 15, 1, 1, 87, 83, 0, // Skip to: 24016
/* 2681 */    MCD::OPC_Decode, 205, 5, 19, // Opcode: SLLI_W
/* 2685 */    MCD::OPC_FilterValue, 1, 78, 83, 0, // Skip to: 24016
/* 2690 */    MCD::OPC_CheckPredicate, 0, 73, 83, 0, // Skip to: 24016
/* 2695 */    MCD::OPC_Decode, 204, 5, 20, // Opcode: SLLI_D
/* 2699 */    MCD::OPC_FilterValue, 1, 33, 0, 0, // Skip to: 2737
/* 2704 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2707 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2723
/* 2712 */    MCD::OPC_CheckField, 15, 1, 1, 49, 83, 0, // Skip to: 24016
/* 2719 */    MCD::OPC_Decode, 217, 5, 19, // Opcode: SRLI_W
/* 2723 */    MCD::OPC_FilterValue, 1, 40, 83, 0, // Skip to: 24016
/* 2728 */    MCD::OPC_CheckPredicate, 0, 35, 83, 0, // Skip to: 24016
/* 2733 */    MCD::OPC_Decode, 216, 5, 20, // Opcode: SRLI_D
/* 2737 */    MCD::OPC_FilterValue, 2, 33, 0, 0, // Skip to: 2775
/* 2742 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2745 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2761
/* 2750 */    MCD::OPC_CheckField, 15, 1, 1, 11, 83, 0, // Skip to: 24016
/* 2757 */    MCD::OPC_Decode, 213, 5, 19, // Opcode: SRAI_W
/* 2761 */    MCD::OPC_FilterValue, 1, 2, 83, 0, // Skip to: 24016
/* 2766 */    MCD::OPC_CheckPredicate, 0, 253, 82, 0, // Skip to: 24016
/* 2771 */    MCD::OPC_Decode, 212, 5, 20, // Opcode: SRAI_D
/* 2775 */    MCD::OPC_FilterValue, 3, 67, 0, 0, // Skip to: 2847
/* 2780 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2783 */    MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 2833
/* 2788 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 2791 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 2824
/* 2796 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 2799 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2815
/* 2804 */    MCD::OPC_CheckField, 13, 1, 1, 213, 82, 0, // Skip to: 24016
/* 2811 */    MCD::OPC_Decode, 184, 5, 21, // Opcode: ROTRI_B
/* 2815 */    MCD::OPC_FilterValue, 1, 204, 82, 0, // Skip to: 24016
/* 2820 */    MCD::OPC_Decode, 186, 5, 14, // Opcode: ROTRI_H
/* 2824 */    MCD::OPC_FilterValue, 1, 195, 82, 0, // Skip to: 24016
/* 2829 */    MCD::OPC_Decode, 187, 5, 19, // Opcode: ROTRI_W
/* 2833 */    MCD::OPC_FilterValue, 1, 186, 82, 0, // Skip to: 24016
/* 2838 */    MCD::OPC_CheckPredicate, 0, 181, 82, 0, // Skip to: 24016
/* 2843 */    MCD::OPC_Decode, 185, 5, 20, // Opcode: ROTRI_D
/* 2847 */    MCD::OPC_FilterValue, 4, 67, 0, 0, // Skip to: 2919
/* 2852 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2855 */    MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 2905
/* 2860 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 2863 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 2896
/* 2868 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 2871 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2887
/* 2876 */    MCD::OPC_CheckField, 13, 1, 1, 141, 82, 0, // Skip to: 24016
/* 2883 */    MCD::OPC_Decode, 167, 5, 21, // Opcode: RCRI_B
/* 2887 */    MCD::OPC_FilterValue, 1, 132, 82, 0, // Skip to: 24016
/* 2892 */    MCD::OPC_Decode, 169, 5, 14, // Opcode: RCRI_H
/* 2896 */    MCD::OPC_FilterValue, 1, 123, 82, 0, // Skip to: 24016
/* 2901 */    MCD::OPC_Decode, 170, 5, 19, // Opcode: RCRI_W
/* 2905 */    MCD::OPC_FilterValue, 1, 114, 82, 0, // Skip to: 24016
/* 2910 */    MCD::OPC_CheckPredicate, 0, 109, 82, 0, // Skip to: 24016
/* 2915 */    MCD::OPC_Decode, 168, 5, 20, // Opcode: RCRI_D
/* 2919 */    MCD::OPC_FilterValue, 5, 230, 1, 0, // Skip to: 3410
/* 2924 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 2927 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2943
/* 2932 */    MCD::OPC_CheckField, 13, 5, 1, 85, 82, 0, // Skip to: 24016
/* 2939 */    MCD::OPC_Decode, 158, 12, 22, // Opcode: X86SLLI_B
/* 2943 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 2959
/* 2948 */    MCD::OPC_CheckField, 14, 4, 1, 69, 82, 0, // Skip to: 24016
/* 2955 */    MCD::OPC_Decode, 160, 12, 18, // Opcode: X86SLLI_H
/* 2959 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 2975
/* 2964 */    MCD::OPC_CheckField, 15, 3, 1, 53, 82, 0, // Skip to: 24016
/* 2971 */    MCD::OPC_Decode, 161, 12, 23, // Opcode: X86SLLI_W
/* 2975 */    MCD::OPC_FilterValue, 3, 16, 0, 0, // Skip to: 2996
/* 2980 */    MCD::OPC_CheckPredicate, 0, 39, 82, 0, // Skip to: 24016
/* 2985 */    MCD::OPC_CheckField, 16, 2, 1, 32, 82, 0, // Skip to: 24016
/* 2992 */    MCD::OPC_Decode, 159, 12, 24, // Opcode: X86SLLI_D
/* 2996 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 3012
/* 3001 */    MCD::OPC_CheckField, 13, 5, 1, 16, 82, 0, // Skip to: 24016
/* 3008 */    MCD::OPC_Decode, 174, 12, 22, // Opcode: X86SRLI_B
/* 3012 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 3028
/* 3017 */    MCD::OPC_CheckField, 14, 4, 1, 0, 82, 0, // Skip to: 24016
/* 3024 */    MCD::OPC_Decode, 176, 12, 18, // Opcode: X86SRLI_H
/* 3028 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 3044
/* 3033 */    MCD::OPC_CheckField, 15, 3, 1, 240, 81, 0, // Skip to: 24016
/* 3040 */    MCD::OPC_Decode, 177, 12, 23, // Opcode: X86SRLI_W
/* 3044 */    MCD::OPC_FilterValue, 7, 16, 0, 0, // Skip to: 3065
/* 3049 */    MCD::OPC_CheckPredicate, 0, 226, 81, 0, // Skip to: 24016
/* 3054 */    MCD::OPC_CheckField, 16, 2, 1, 219, 81, 0, // Skip to: 24016
/* 3061 */    MCD::OPC_Decode, 175, 12, 24, // Opcode: X86SRLI_D
/* 3065 */    MCD::OPC_FilterValue, 8, 11, 0, 0, // Skip to: 3081
/* 3070 */    MCD::OPC_CheckField, 13, 5, 1, 203, 81, 0, // Skip to: 24016
/* 3077 */    MCD::OPC_Decode, 166, 12, 22, // Opcode: X86SRAI_B
/* 3081 */    MCD::OPC_FilterValue, 9, 11, 0, 0, // Skip to: 3097
/* 3086 */    MCD::OPC_CheckField, 14, 4, 1, 187, 81, 0, // Skip to: 24016
/* 3093 */    MCD::OPC_Decode, 168, 12, 18, // Opcode: X86SRAI_H
/* 3097 */    MCD::OPC_FilterValue, 10, 11, 0, 0, // Skip to: 3113
/* 3102 */    MCD::OPC_CheckField, 15, 3, 1, 171, 81, 0, // Skip to: 24016
/* 3109 */    MCD::OPC_Decode, 169, 12, 23, // Opcode: X86SRAI_W
/* 3113 */    MCD::OPC_FilterValue, 11, 16, 0, 0, // Skip to: 3134
/* 3118 */    MCD::OPC_CheckPredicate, 0, 157, 81, 0, // Skip to: 24016
/* 3123 */    MCD::OPC_CheckField, 16, 2, 1, 150, 81, 0, // Skip to: 24016
/* 3130 */    MCD::OPC_Decode, 167, 12, 24, // Opcode: X86SRAI_D
/* 3134 */    MCD::OPC_FilterValue, 12, 11, 0, 0, // Skip to: 3150
/* 3139 */    MCD::OPC_CheckField, 13, 5, 1, 134, 81, 0, // Skip to: 24016
/* 3146 */    MCD::OPC_Decode, 144, 12, 22, // Opcode: X86ROTRI_B
/* 3150 */    MCD::OPC_FilterValue, 13, 11, 0, 0, // Skip to: 3166
/* 3155 */    MCD::OPC_CheckField, 14, 4, 1, 118, 81, 0, // Skip to: 24016
/* 3162 */    MCD::OPC_Decode, 146, 12, 18, // Opcode: X86ROTRI_H
/* 3166 */    MCD::OPC_FilterValue, 14, 11, 0, 0, // Skip to: 3182
/* 3171 */    MCD::OPC_CheckField, 15, 3, 1, 102, 81, 0, // Skip to: 24016
/* 3178 */    MCD::OPC_Decode, 147, 12, 23, // Opcode: X86ROTRI_W
/* 3182 */    MCD::OPC_FilterValue, 15, 16, 0, 0, // Skip to: 3203
/* 3187 */    MCD::OPC_CheckPredicate, 0, 88, 81, 0, // Skip to: 24016
/* 3192 */    MCD::OPC_CheckField, 16, 2, 1, 81, 81, 0, // Skip to: 24016
/* 3199 */    MCD::OPC_Decode, 145, 12, 24, // Opcode: X86ROTRI_D
/* 3203 */    MCD::OPC_FilterValue, 16, 11, 0, 0, // Skip to: 3219
/* 3208 */    MCD::OPC_CheckField, 13, 5, 1, 65, 81, 0, // Skip to: 24016
/* 3215 */    MCD::OPC_Decode, 128, 12, 22, // Opcode: X86RCRI_B
/* 3219 */    MCD::OPC_FilterValue, 17, 11, 0, 0, // Skip to: 3235
/* 3224 */    MCD::OPC_CheckField, 14, 4, 1, 49, 81, 0, // Skip to: 24016
/* 3231 */    MCD::OPC_Decode, 130, 12, 18, // Opcode: X86RCRI_H
/* 3235 */    MCD::OPC_FilterValue, 18, 11, 0, 0, // Skip to: 3251
/* 3240 */    MCD::OPC_CheckField, 15, 3, 1, 33, 81, 0, // Skip to: 24016
/* 3247 */    MCD::OPC_Decode, 131, 12, 23, // Opcode: X86RCRI_W
/* 3251 */    MCD::OPC_FilterValue, 19, 16, 0, 0, // Skip to: 3272
/* 3256 */    MCD::OPC_CheckPredicate, 0, 19, 81, 0, // Skip to: 24016
/* 3261 */    MCD::OPC_CheckField, 16, 2, 1, 12, 81, 0, // Skip to: 24016
/* 3268 */    MCD::OPC_Decode, 129, 12, 24, // Opcode: X86RCRI_D
/* 3272 */    MCD::OPC_FilterValue, 20, 11, 0, 0, // Skip to: 3288
/* 3277 */    MCD::OPC_CheckField, 13, 5, 1, 252, 80, 0, // Skip to: 24016
/* 3284 */    MCD::OPC_Decode, 136, 12, 22, // Opcode: X86ROTLI_B
/* 3288 */    MCD::OPC_FilterValue, 21, 11, 0, 0, // Skip to: 3304
/* 3293 */    MCD::OPC_CheckField, 14, 4, 1, 236, 80, 0, // Skip to: 24016
/* 3300 */    MCD::OPC_Decode, 138, 12, 18, // Opcode: X86ROTLI_H
/* 3304 */    MCD::OPC_FilterValue, 22, 11, 0, 0, // Skip to: 3320
/* 3309 */    MCD::OPC_CheckField, 15, 3, 1, 220, 80, 0, // Skip to: 24016
/* 3316 */    MCD::OPC_Decode, 139, 12, 23, // Opcode: X86ROTLI_W
/* 3320 */    MCD::OPC_FilterValue, 23, 16, 0, 0, // Skip to: 3341
/* 3325 */    MCD::OPC_CheckPredicate, 0, 206, 80, 0, // Skip to: 24016
/* 3330 */    MCD::OPC_CheckField, 16, 2, 1, 199, 80, 0, // Skip to: 24016
/* 3337 */    MCD::OPC_Decode, 137, 12, 24, // Opcode: X86ROTLI_D
/* 3341 */    MCD::OPC_FilterValue, 24, 11, 0, 0, // Skip to: 3357
/* 3346 */    MCD::OPC_CheckField, 13, 5, 1, 183, 80, 0, // Skip to: 24016
/* 3353 */    MCD::OPC_Decode, 248, 11, 22, // Opcode: X86RCLI_B
/* 3357 */    MCD::OPC_FilterValue, 25, 11, 0, 0, // Skip to: 3373
/* 3362 */    MCD::OPC_CheckField, 14, 4, 1, 167, 80, 0, // Skip to: 24016
/* 3369 */    MCD::OPC_Decode, 250, 11, 18, // Opcode: X86RCLI_H
/* 3373 */    MCD::OPC_FilterValue, 26, 11, 0, 0, // Skip to: 3389
/* 3378 */    MCD::OPC_CheckField, 15, 3, 1, 151, 80, 0, // Skip to: 24016
/* 3385 */    MCD::OPC_Decode, 251, 11, 23, // Opcode: X86RCLI_W
/* 3389 */    MCD::OPC_FilterValue, 27, 142, 80, 0, // Skip to: 24016
/* 3394 */    MCD::OPC_CheckPredicate, 0, 137, 80, 0, // Skip to: 24016
/* 3399 */    MCD::OPC_CheckField, 16, 2, 1, 130, 80, 0, // Skip to: 24016
/* 3406 */    MCD::OPC_Decode, 249, 11, 24, // Opcode: X86RCLI_D
/* 3410 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 3419
/* 3415 */    MCD::OPC_Decode, 156, 12, 25, // Opcode: X86SETTAG
/* 3419 */    MCD::OPC_FilterValue, 7, 112, 80, 0, // Skip to: 24016
/* 3424 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 3427 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 3436
/* 3432 */    MCD::OPC_Decode, 232, 11, 26, // Opcode: X86MFFLAG
/* 3436 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 3445
/* 3441 */    MCD::OPC_Decode, 234, 11, 26, // Opcode: X86MTFLAG
/* 3445 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 3454
/* 3450 */    MCD::OPC_Decode, 246, 2, 26, // Opcode: ARMMFFLAG
/* 3454 */    MCD::OPC_FilterValue, 3, 77, 80, 0, // Skip to: 24016
/* 3459 */    MCD::OPC_Decode, 250, 2, 26, // Opcode: ARMMTFLAG
/* 3463 */    MCD::OPC_FilterValue, 1, 68, 80, 0, // Skip to: 24016
/* 3468 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 3471 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 3480
/* 3476 */    MCD::OPC_Decode, 157, 3, 27, // Opcode: BSTRINS_W
/* 3480 */    MCD::OPC_FilterValue, 1, 51, 80, 0, // Skip to: 24016
/* 3485 */    MCD::OPC_Decode, 159, 3, 28, // Opcode: BSTRPICK_W
/* 3489 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 3503
/* 3494 */    MCD::OPC_CheckPredicate, 0, 37, 80, 0, // Skip to: 24016
/* 3499 */    MCD::OPC_Decode, 156, 3, 29, // Opcode: BSTRINS_D
/* 3503 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 3517
/* 3508 */    MCD::OPC_CheckPredicate, 0, 23, 80, 0, // Skip to: 24016
/* 3513 */    MCD::OPC_Decode, 158, 3, 30, // Opcode: BSTRPICK_D
/* 3517 */    MCD::OPC_FilterValue, 4, 20, 3, 0, // Skip to: 4310
/* 3522 */    MCD::OPC_ExtractField, 15, 7,  // Inst{21-15} ...
/* 3525 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 3534
/* 3530 */    MCD::OPC_Decode, 195, 3, 31, // Opcode: FADD_S
/* 3534 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 3543
/* 3539 */    MCD::OPC_Decode, 194, 3, 32, // Opcode: FADD_D
/* 3543 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 3552
/* 3548 */    MCD::OPC_Decode, 180, 4, 31, // Opcode: FSUB_S
/* 3552 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 3561
/* 3557 */    MCD::OPC_Decode, 179, 4, 32, // Opcode: FSUB_D
/* 3561 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 3570
/* 3566 */    MCD::OPC_Decode, 152, 4, 31, // Opcode: FMUL_S
/* 3570 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 3579
/* 3575 */    MCD::OPC_Decode, 151, 4, 32, // Opcode: FMUL_D
/* 3579 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 3588
/* 3584 */    MCD::OPC_Decode, 250, 3, 31, // Opcode: FDIV_S
/* 3588 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 3597
/* 3593 */    MCD::OPC_Decode, 249, 3, 32, // Opcode: FDIV_D
/* 3597 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 3606
/* 3602 */    MCD::OPC_Decode, 142, 4, 31, // Opcode: FMAX_S
/* 3606 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 3615
/* 3611 */    MCD::OPC_Decode, 141, 4, 32, // Opcode: FMAX_D
/* 3615 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 3624
/* 3620 */    MCD::OPC_Decode, 146, 4, 31, // Opcode: FMIN_S
/* 3624 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 3633
/* 3629 */    MCD::OPC_Decode, 145, 4, 32, // Opcode: FMIN_D
/* 3633 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 3642
/* 3638 */    MCD::OPC_Decode, 140, 4, 31, // Opcode: FMAXA_S
/* 3642 */    MCD::OPC_FilterValue, 26, 4, 0, 0, // Skip to: 3651
/* 3647 */    MCD::OPC_Decode, 139, 4, 32, // Opcode: FMAXA_D
/* 3651 */    MCD::OPC_FilterValue, 29, 4, 0, 0, // Skip to: 3660
/* 3656 */    MCD::OPC_Decode, 144, 4, 31, // Opcode: FMINA_S
/* 3660 */    MCD::OPC_FilterValue, 30, 4, 0, 0, // Skip to: 3669
/* 3665 */    MCD::OPC_Decode, 143, 4, 32, // Opcode: FMINA_D
/* 3669 */    MCD::OPC_FilterValue, 33, 4, 0, 0, // Skip to: 3678
/* 3674 */    MCD::OPC_Decode, 166, 4, 31, // Opcode: FSCALEB_S
/* 3678 */    MCD::OPC_FilterValue, 34, 4, 0, 0, // Skip to: 3687
/* 3683 */    MCD::OPC_Decode, 165, 4, 32, // Opcode: FSCALEB_D
/* 3687 */    MCD::OPC_FilterValue, 37, 4, 0, 0, // Skip to: 3696
/* 3692 */    MCD::OPC_Decode, 243, 3, 31, // Opcode: FCOPYSIGN_S
/* 3696 */    MCD::OPC_FilterValue, 38, 4, 0, 0, // Skip to: 3705
/* 3701 */    MCD::OPC_Decode, 242, 3, 32, // Opcode: FCOPYSIGN_D
/* 3705 */    MCD::OPC_FilterValue, 40, 129, 0, 0, // Skip to: 3839
/* 3710 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3713 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 3722
/* 3718 */    MCD::OPC_Decode, 193, 3, 33, // Opcode: FABS_S
/* 3722 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 3731
/* 3727 */    MCD::OPC_Decode, 192, 3, 34, // Opcode: FABS_D
/* 3731 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 3740
/* 3736 */    MCD::OPC_Decode, 154, 4, 33, // Opcode: FNEG_S
/* 3740 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 3749
/* 3745 */    MCD::OPC_Decode, 153, 4, 34, // Opcode: FNEG_D
/* 3749 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 3758
/* 3754 */    MCD::OPC_Decode, 136, 4, 33, // Opcode: FLOGB_S
/* 3758 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 3767
/* 3763 */    MCD::OPC_Decode, 135, 4, 34, // Opcode: FLOGB_D
/* 3767 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 3776
/* 3772 */    MCD::OPC_Decode, 197, 3, 33, // Opcode: FCLASS_S
/* 3776 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 3785
/* 3781 */    MCD::OPC_Decode, 196, 3, 34, // Opcode: FCLASS_D
/* 3785 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 3794
/* 3790 */    MCD::OPC_Decode, 170, 4, 33, // Opcode: FSQRT_S
/* 3794 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 3803
/* 3799 */    MCD::OPC_Decode, 169, 4, 34, // Opcode: FSQRT_D
/* 3803 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 3812
/* 3808 */    MCD::OPC_Decode, 160, 4, 33, // Opcode: FRECIP_S
/* 3812 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 3821
/* 3817 */    MCD::OPC_Decode, 159, 4, 34, // Opcode: FRECIP_D
/* 3821 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 3830
/* 3826 */    MCD::OPC_Decode, 164, 4, 33, // Opcode: FRSQRT_S
/* 3830 */    MCD::OPC_FilterValue, 26, 213, 78, 0, // Skip to: 24016
/* 3835 */    MCD::OPC_Decode, 163, 4, 34, // Opcode: FRSQRT_D
/* 3839 */    MCD::OPC_FilterValue, 41, 157, 0, 0, // Skip to: 4001
/* 3844 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3847 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 3856
/* 3852 */    MCD::OPC_Decode, 148, 4, 33, // Opcode: FMOV_S
/* 3856 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 3865
/* 3861 */    MCD::OPC_Decode, 147, 4, 34, // Opcode: FMOV_D
/* 3865 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 3874
/* 3870 */    MCD::OPC_Decode, 145, 5, 35, // Opcode: MOVGR2FR_W
/* 3874 */    MCD::OPC_FilterValue, 10, 9, 0, 0, // Skip to: 3888
/* 3879 */    MCD::OPC_CheckPredicate, 0, 164, 78, 0, // Skip to: 24016
/* 3884 */    MCD::OPC_Decode, 144, 5, 36, // Opcode: MOVGR2FR_D
/* 3888 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 3897
/* 3893 */    MCD::OPC_Decode, 143, 5, 37, // Opcode: MOVGR2FRH_W
/* 3897 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 3906
/* 3902 */    MCD::OPC_Decode, 138, 5, 38, // Opcode: MOVFR2GR_S
/* 3906 */    MCD::OPC_FilterValue, 14, 9, 0, 0, // Skip to: 3920
/* 3911 */    MCD::OPC_CheckPredicate, 0, 132, 78, 0, // Skip to: 24016
/* 3916 */    MCD::OPC_Decode, 137, 5, 39, // Opcode: MOVFR2GR_D
/* 3920 */    MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 3929
/* 3925 */    MCD::OPC_Decode, 140, 5, 39, // Opcode: MOVFRH2GR_S
/* 3929 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 3938
/* 3934 */    MCD::OPC_Decode, 142, 5, 40, // Opcode: MOVGR2FCSR
/* 3938 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 3947
/* 3943 */    MCD::OPC_Decode, 135, 5, 41, // Opcode: MOVFCSR2GR
/* 3947 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 3956
/* 3952 */    MCD::OPC_Decode, 136, 5, 42, // Opcode: MOVFR2CF_xS
/* 3956 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 3965
/* 3961 */    MCD::OPC_Decode, 133, 5, 43, // Opcode: MOVCF2FR_xS
/* 3965 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 3974
/* 3970 */    MCD::OPC_Decode, 141, 5, 44, // Opcode: MOVGR2CF
/* 3974 */    MCD::OPC_FilterValue, 23, 4, 0, 0, // Skip to: 3983
/* 3979 */    MCD::OPC_Decode, 134, 5, 45, // Opcode: MOVCF2GR
/* 3983 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 3992
/* 3988 */    MCD::OPC_Decode, 246, 3, 33, // Opcode: FCVT_LD_D
/* 3992 */    MCD::OPC_FilterValue, 25, 51, 78, 0, // Skip to: 24016
/* 3997 */    MCD::OPC_Decode, 248, 3, 33, // Opcode: FCVT_UD_D
/* 4001 */    MCD::OPC_FilterValue, 42, 4, 0, 0, // Skip to: 4010
/* 4006 */    MCD::OPC_Decode, 244, 3, 31, // Opcode: FCVT_D_LD
/* 4010 */    MCD::OPC_FilterValue, 50, 21, 0, 0, // Skip to: 4036
/* 4015 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4018 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 4027
/* 4023 */    MCD::OPC_Decode, 247, 3, 46, // Opcode: FCVT_S_D
/* 4027 */    MCD::OPC_FilterValue, 9, 16, 78, 0, // Skip to: 24016
/* 4032 */    MCD::OPC_Decode, 245, 3, 47, // Opcode: FCVT_D_S
/* 4036 */    MCD::OPC_FilterValue, 52, 75, 0, 0, // Skip to: 4116
/* 4041 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4044 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4053
/* 4049 */    MCD::OPC_Decode, 184, 4, 33, // Opcode: FTINTRM_W_S
/* 4053 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 4062
/* 4058 */    MCD::OPC_Decode, 183, 4, 46, // Opcode: FTINTRM_W_D
/* 4062 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 4071
/* 4067 */    MCD::OPC_Decode, 182, 4, 47, // Opcode: FTINTRM_L_S
/* 4071 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 4080
/* 4076 */    MCD::OPC_Decode, 181, 4, 34, // Opcode: FTINTRM_L_D
/* 4080 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 4089
/* 4085 */    MCD::OPC_Decode, 192, 4, 33, // Opcode: FTINTRP_W_S
/* 4089 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 4098
/* 4094 */    MCD::OPC_Decode, 191, 4, 46, // Opcode: FTINTRP_W_D
/* 4098 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 4107
/* 4103 */    MCD::OPC_Decode, 190, 4, 47, // Opcode: FTINTRP_L_S
/* 4107 */    MCD::OPC_FilterValue, 26, 192, 77, 0, // Skip to: 24016
/* 4112 */    MCD::OPC_Decode, 189, 4, 34, // Opcode: FTINTRP_L_D
/* 4116 */    MCD::OPC_FilterValue, 53, 75, 0, 0, // Skip to: 4196
/* 4121 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4124 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4133
/* 4129 */    MCD::OPC_Decode, 196, 4, 33, // Opcode: FTINTRZ_W_S
/* 4133 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 4142
/* 4138 */    MCD::OPC_Decode, 195, 4, 46, // Opcode: FTINTRZ_W_D
/* 4142 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 4151
/* 4147 */    MCD::OPC_Decode, 194, 4, 47, // Opcode: FTINTRZ_L_S
/* 4151 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 4160
/* 4156 */    MCD::OPC_Decode, 193, 4, 34, // Opcode: FTINTRZ_L_D
/* 4160 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 4169
/* 4165 */    MCD::OPC_Decode, 188, 4, 33, // Opcode: FTINTRNE_W_S
/* 4169 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 4178
/* 4174 */    MCD::OPC_Decode, 187, 4, 46, // Opcode: FTINTRNE_W_D
/* 4178 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 4187
/* 4183 */    MCD::OPC_Decode, 186, 4, 47, // Opcode: FTINTRNE_L_S
/* 4187 */    MCD::OPC_FilterValue, 26, 112, 77, 0, // Skip to: 24016
/* 4192 */    MCD::OPC_Decode, 185, 4, 34, // Opcode: FTINTRNE_L_D
/* 4196 */    MCD::OPC_FilterValue, 54, 39, 0, 0, // Skip to: 4240
/* 4201 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4204 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4213
/* 4209 */    MCD::OPC_Decode, 200, 4, 33, // Opcode: FTINT_W_S
/* 4213 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 4222
/* 4218 */    MCD::OPC_Decode, 199, 4, 46, // Opcode: FTINT_W_D
/* 4222 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 4231
/* 4227 */    MCD::OPC_Decode, 198, 4, 47, // Opcode: FTINT_L_S
/* 4231 */    MCD::OPC_FilterValue, 10, 68, 77, 0, // Skip to: 24016
/* 4236 */    MCD::OPC_Decode, 197, 4, 34, // Opcode: FTINT_L_D
/* 4240 */    MCD::OPC_FilterValue, 58, 39, 0, 0, // Skip to: 4284
/* 4245 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4248 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 4257
/* 4253 */    MCD::OPC_Decode, 254, 3, 33, // Opcode: FFINT_S_W
/* 4257 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 4266
/* 4262 */    MCD::OPC_Decode, 253, 3, 46, // Opcode: FFINT_S_L
/* 4266 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 4275
/* 4271 */    MCD::OPC_Decode, 252, 3, 47, // Opcode: FFINT_D_W
/* 4275 */    MCD::OPC_FilterValue, 10, 24, 77, 0, // Skip to: 24016
/* 4280 */    MCD::OPC_Decode, 251, 3, 34, // Opcode: FFINT_D_L
/* 4284 */    MCD::OPC_FilterValue, 60, 15, 77, 0, // Skip to: 24016
/* 4289 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4292 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 4301
/* 4297 */    MCD::OPC_Decode, 162, 4, 33, // Opcode: FRINT_S
/* 4301 */    MCD::OPC_FilterValue, 18, 254, 76, 0, // Skip to: 24016
/* 4306 */    MCD::OPC_Decode, 161, 4, 34, // Opcode: FRINT_D
/* 4310 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 4319
/* 4315 */    MCD::OPC_Decode, 209, 5, 48, // Opcode: SLTI
/* 4319 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 4328
/* 4324 */    MCD::OPC_Decode, 211, 5, 48, // Opcode: SLTUI
/* 4328 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 4337
/* 4333 */    MCD::OPC_Decode, 195, 2, 48, // Opcode: ADDI_W
/* 4337 */    MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 4351
/* 4342 */    MCD::OPC_CheckPredicate, 0, 213, 76, 0, // Skip to: 24016
/* 4347 */    MCD::OPC_Decode, 194, 2, 48, // Opcode: ADDI_D
/* 4351 */    MCD::OPC_FilterValue, 12, 9, 0, 0, // Skip to: 4365
/* 4356 */    MCD::OPC_CheckPredicate, 0, 199, 76, 0, // Skip to: 24016
/* 4361 */    MCD::OPC_Decode, 254, 4, 48, // Opcode: LU52I_D
/* 4365 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 4374
/* 4370 */    MCD::OPC_Decode, 241, 2, 49, // Opcode: ANDI
/* 4374 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 4383
/* 4379 */    MCD::OPC_Decode, 159, 5, 49, // Opcode: ORI
/* 4383 */    MCD::OPC_FilterValue, 15, 172, 76, 0, // Skip to: 24016
/* 4388 */    MCD::OPC_Decode, 193, 12, 49, // Opcode: XORI
/* 4392 */    MCD::OPC_FilterValue, 1, 95, 1, 0, // Skip to: 4748
/* 4397 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 4400 */    MCD::OPC_FilterValue, 0, 25, 0, 0, // Skip to: 4430
/* 4405 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 4408 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4417
/* 4413 */    MCD::OPC_Decode, 176, 3, 50, // Opcode: CSRRD
/* 4417 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4426
/* 4422 */    MCD::OPC_Decode, 177, 3, 51, // Opcode: CSRWR
/* 4426 */    MCD::OPC_Decode, 178, 3, 52, // Opcode: CSRXCHG
/* 4430 */    MCD::OPC_FilterValue, 1, 25, 0, 0, // Skip to: 4460
/* 4435 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 4438 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4447
/* 4443 */    MCD::OPC_Decode, 201, 4, 50, // Opcode: GCSRRD
/* 4447 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4456
/* 4452 */    MCD::OPC_Decode, 202, 4, 51, // Opcode: GCSRWR
/* 4456 */    MCD::OPC_Decode, 203, 4, 52, // Opcode: GCSRXCHG
/* 4460 */    MCD::OPC_FilterValue, 2, 95, 76, 0, // Skip to: 24016
/* 4465 */    MCD::OPC_ExtractField, 22, 2,  // Inst{23-22} ...
/* 4468 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4477
/* 4473 */    MCD::OPC_Decode, 162, 3, 53, // Opcode: CACOP
/* 4477 */    MCD::OPC_FilterValue, 1, 78, 76, 0, // Skip to: 24016
/* 4482 */    MCD::OPC_ExtractField, 18, 4,  // Inst{21-18} ...
/* 4485 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4494
/* 4490 */    MCD::OPC_Decode, 220, 4, 54, // Opcode: LDDIR
/* 4494 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 4510
/* 4499 */    MCD::OPC_CheckField, 0, 5, 0, 54, 76, 0, // Skip to: 24016
/* 4506 */    MCD::OPC_Decode, 231, 4, 55, // Opcode: LDPTE
/* 4510 */    MCD::OPC_FilterValue, 2, 45, 76, 0, // Skip to: 24016
/* 4515 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 4518 */    MCD::OPC_FilterValue, 0, 207, 0, 0, // Skip to: 4730
/* 4523 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 4526 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4535
/* 4531 */    MCD::OPC_Decode, 209, 4, 2, // Opcode: IOCSRRD_B
/* 4535 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4544
/* 4540 */    MCD::OPC_Decode, 211, 4, 2, // Opcode: IOCSRRD_H
/* 4544 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 4553
/* 4549 */    MCD::OPC_Decode, 212, 4, 2, // Opcode: IOCSRRD_W
/* 4553 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 4567
/* 4558 */    MCD::OPC_CheckPredicate, 0, 253, 75, 0, // Skip to: 24016
/* 4563 */    MCD::OPC_Decode, 210, 4, 2, // Opcode: IOCSRRD_D
/* 4567 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 4576
/* 4572 */    MCD::OPC_Decode, 213, 4, 2, // Opcode: IOCSRWR_B
/* 4576 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 4585
/* 4581 */    MCD::OPC_Decode, 215, 4, 2, // Opcode: IOCSRWR_H
/* 4585 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 4594
/* 4590 */    MCD::OPC_Decode, 216, 4, 2, // Opcode: IOCSRWR_W
/* 4594 */    MCD::OPC_FilterValue, 7, 9, 0, 0, // Skip to: 4608
/* 4599 */    MCD::OPC_CheckPredicate, 0, 212, 75, 0, // Skip to: 24016
/* 4604 */    MCD::OPC_Decode, 214, 4, 2, // Opcode: IOCSRWR_D
/* 4608 */    MCD::OPC_FilterValue, 8, 11, 0, 0, // Skip to: 4624
/* 4613 */    MCD::OPC_CheckField, 0, 10, 0, 196, 75, 0, // Skip to: 24016
/* 4620 */    MCD::OPC_Decode, 245, 5, 6, // Opcode: TLBCLR
/* 4624 */    MCD::OPC_FilterValue, 9, 21, 0, 0, // Skip to: 4650
/* 4629 */    MCD::OPC_ExtractField, 0, 10,  // Inst{9-0} ...
/* 4632 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 4641
/* 4637 */    MCD::OPC_Decode, 247, 5, 6, // Opcode: TLBFLUSH
/* 4641 */    MCD::OPC_FilterValue, 1, 170, 75, 0, // Skip to: 24016
/* 4646 */    MCD::OPC_Decode, 204, 4, 6, // Opcode: GTLBFLUSH
/* 4650 */    MCD::OPC_FilterValue, 10, 11, 0, 0, // Skip to: 4666
/* 4655 */    MCD::OPC_CheckField, 0, 10, 0, 154, 75, 0, // Skip to: 24016
/* 4662 */    MCD::OPC_Decode, 249, 5, 6, // Opcode: TLBSRCH
/* 4666 */    MCD::OPC_FilterValue, 11, 11, 0, 0, // Skip to: 4682
/* 4671 */    MCD::OPC_CheckField, 0, 10, 0, 138, 75, 0, // Skip to: 24016
/* 4678 */    MCD::OPC_Decode, 248, 5, 6, // Opcode: TLBRD
/* 4682 */    MCD::OPC_FilterValue, 12, 11, 0, 0, // Skip to: 4698
/* 4687 */    MCD::OPC_CheckField, 0, 10, 0, 122, 75, 0, // Skip to: 24016
/* 4694 */    MCD::OPC_Decode, 250, 5, 6, // Opcode: TLBWR
/* 4698 */    MCD::OPC_FilterValue, 13, 11, 0, 0, // Skip to: 4714
/* 4703 */    MCD::OPC_CheckField, 0, 10, 0, 106, 75, 0, // Skip to: 24016
/* 4710 */    MCD::OPC_Decode, 246, 5, 6, // Opcode: TLBFILL
/* 4714 */    MCD::OPC_FilterValue, 14, 97, 75, 0, // Skip to: 24016
/* 4719 */    MCD::OPC_CheckField, 0, 10, 0, 90, 75, 0, // Skip to: 24016
/* 4726 */    MCD::OPC_Decode, 189, 3, 6, // Opcode: ERTN
/* 4730 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4739
/* 4735 */    MCD::OPC_Decode, 207, 4, 13, // Opcode: IDLE
/* 4739 */    MCD::OPC_FilterValue, 3, 72, 75, 0, // Skip to: 24016
/* 4744 */    MCD::OPC_Decode, 208, 4, 56, // Opcode: INVTLB
/* 4748 */    MCD::OPC_FilterValue, 2, 219, 0, 0, // Skip to: 4972
/* 4753 */    MCD::OPC_ExtractField, 20, 6,  // Inst{25-20} ...
/* 4756 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 4765
/* 4761 */    MCD::OPC_Decode, 138, 4, 57, // Opcode: FMADD_S
/* 4765 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 4774
/* 4770 */    MCD::OPC_Decode, 137, 4, 58, // Opcode: FMADD_D
/* 4774 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 4783
/* 4779 */    MCD::OPC_Decode, 150, 4, 57, // Opcode: FMSUB_S
/* 4783 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 4792
/* 4788 */    MCD::OPC_Decode, 149, 4, 58, // Opcode: FMSUB_D
/* 4792 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 4801
/* 4797 */    MCD::OPC_Decode, 156, 4, 57, // Opcode: FNMADD_S
/* 4801 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 4810
/* 4806 */    MCD::OPC_Decode, 155, 4, 58, // Opcode: FNMADD_D
/* 4810 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 4819
/* 4815 */    MCD::OPC_Decode, 158, 4, 57, // Opcode: FNMSUB_S
/* 4819 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 4828
/* 4824 */    MCD::OPC_Decode, 157, 4, 58, // Opcode: FNMSUB_D
/* 4828 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 4837
/* 4833 */    MCD::OPC_Decode, 195, 7, 59, // Opcode: VFMADD_S
/* 4837 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 4846
/* 4842 */    MCD::OPC_Decode, 194, 7, 59, // Opcode: VFMADD_D
/* 4846 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 4855
/* 4851 */    MCD::OPC_Decode, 205, 7, 59, // Opcode: VFMSUB_S
/* 4855 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 4864
/* 4860 */    MCD::OPC_Decode, 204, 7, 59, // Opcode: VFMSUB_D
/* 4864 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 4873
/* 4869 */    MCD::OPC_Decode, 209, 7, 59, // Opcode: VFNMADD_S
/* 4873 */    MCD::OPC_FilterValue, 26, 4, 0, 0, // Skip to: 4882
/* 4878 */    MCD::OPC_Decode, 208, 7, 59, // Opcode: VFNMADD_D
/* 4882 */    MCD::OPC_FilterValue, 29, 4, 0, 0, // Skip to: 4891
/* 4887 */    MCD::OPC_Decode, 211, 7, 59, // Opcode: VFNMSUB_S
/* 4891 */    MCD::OPC_FilterValue, 30, 4, 0, 0, // Skip to: 4900
/* 4896 */    MCD::OPC_Decode, 210, 7, 59, // Opcode: VFNMSUB_D
/* 4900 */    MCD::OPC_FilterValue, 33, 4, 0, 0, // Skip to: 4909
/* 4905 */    MCD::OPC_Decode, 254, 13, 60, // Opcode: XVFMADD_S
/* 4909 */    MCD::OPC_FilterValue, 34, 4, 0, 0, // Skip to: 4918
/* 4914 */    MCD::OPC_Decode, 253, 13, 60, // Opcode: XVFMADD_D
/* 4918 */    MCD::OPC_FilterValue, 37, 4, 0, 0, // Skip to: 4927
/* 4923 */    MCD::OPC_Decode, 136, 14, 60, // Opcode: XVFMSUB_S
/* 4927 */    MCD::OPC_FilterValue, 38, 4, 0, 0, // Skip to: 4936
/* 4932 */    MCD::OPC_Decode, 135, 14, 60, // Opcode: XVFMSUB_D
/* 4936 */    MCD::OPC_FilterValue, 41, 4, 0, 0, // Skip to: 4945
/* 4941 */    MCD::OPC_Decode, 140, 14, 60, // Opcode: XVFNMADD_S
/* 4945 */    MCD::OPC_FilterValue, 42, 4, 0, 0, // Skip to: 4954
/* 4950 */    MCD::OPC_Decode, 139, 14, 60, // Opcode: XVFNMADD_D
/* 4954 */    MCD::OPC_FilterValue, 45, 4, 0, 0, // Skip to: 4963
/* 4959 */    MCD::OPC_Decode, 142, 14, 60, // Opcode: XVFNMSUB_S
/* 4963 */    MCD::OPC_FilterValue, 46, 104, 74, 0, // Skip to: 24016
/* 4968 */    MCD::OPC_Decode, 141, 14, 60, // Opcode: XVFNMSUB_D
/* 4972 */    MCD::OPC_FilterValue, 3, 63, 6, 0, // Skip to: 6576
/* 4977 */    MCD::OPC_ExtractField, 20, 6,  // Inst{25-20} ...
/* 4980 */    MCD::OPC_FilterValue, 1, 99, 1, 0, // Skip to: 5340
/* 4985 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 4988 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 5004
/* 4993 */    MCD::OPC_CheckField, 3, 2, 0, 72, 74, 0, // Skip to: 24016
/* 5000 */    MCD::OPC_Decode, 199, 3, 61, // Opcode: FCMP_CAF_S
/* 5004 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 5020
/* 5009 */    MCD::OPC_CheckField, 3, 2, 0, 56, 74, 0, // Skip to: 24016
/* 5016 */    MCD::OPC_Decode, 221, 3, 61, // Opcode: FCMP_SAF_S
/* 5020 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 5036
/* 5025 */    MCD::OPC_CheckField, 3, 2, 0, 40, 74, 0, // Skip to: 24016
/* 5032 */    MCD::OPC_Decode, 205, 3, 61, // Opcode: FCMP_CLT_S
/* 5036 */    MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 5052
/* 5041 */    MCD::OPC_CheckField, 3, 2, 0, 24, 74, 0, // Skip to: 24016
/* 5048 */    MCD::OPC_Decode, 227, 3, 61, // Opcode: FCMP_SLT_S
/* 5052 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 5068
/* 5057 */    MCD::OPC_CheckField, 3, 2, 0, 8, 74, 0, // Skip to: 24016
/* 5064 */    MCD::OPC_Decode, 201, 3, 61, // Opcode: FCMP_CEQ_S
/* 5068 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 5084
/* 5073 */    MCD::OPC_CheckField, 3, 2, 0, 248, 73, 0, // Skip to: 24016
/* 5080 */    MCD::OPC_Decode, 223, 3, 61, // Opcode: FCMP_SEQ_S
/* 5084 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 5100
/* 5089 */    MCD::OPC_CheckField, 3, 2, 0, 232, 73, 0, // Skip to: 24016
/* 5096 */    MCD::OPC_Decode, 203, 3, 61, // Opcode: FCMP_CLE_S
/* 5100 */    MCD::OPC_FilterValue, 7, 11, 0, 0, // Skip to: 5116
/* 5105 */    MCD::OPC_CheckField, 3, 2, 0, 216, 73, 0, // Skip to: 24016
/* 5112 */    MCD::OPC_Decode, 225, 3, 61, // Opcode: FCMP_SLE_S
/* 5116 */    MCD::OPC_FilterValue, 8, 11, 0, 0, // Skip to: 5132
/* 5121 */    MCD::OPC_CheckField, 3, 2, 0, 200, 73, 0, // Skip to: 24016
/* 5128 */    MCD::OPC_Decode, 219, 3, 61, // Opcode: FCMP_CUN_S
/* 5132 */    MCD::OPC_FilterValue, 9, 11, 0, 0, // Skip to: 5148
/* 5137 */    MCD::OPC_CheckField, 3, 2, 0, 184, 73, 0, // Skip to: 24016
/* 5144 */    MCD::OPC_Decode, 241, 3, 61, // Opcode: FCMP_SUN_S
/* 5148 */    MCD::OPC_FilterValue, 10, 11, 0, 0, // Skip to: 5164
/* 5153 */    MCD::OPC_CheckField, 3, 2, 0, 168, 73, 0, // Skip to: 24016
/* 5160 */    MCD::OPC_Decode, 215, 3, 61, // Opcode: FCMP_CULT_S
/* 5164 */    MCD::OPC_FilterValue, 11, 11, 0, 0, // Skip to: 5180
/* 5169 */    MCD::OPC_CheckField, 3, 2, 0, 152, 73, 0, // Skip to: 24016
/* 5176 */    MCD::OPC_Decode, 237, 3, 61, // Opcode: FCMP_SULT_S
/* 5180 */    MCD::OPC_FilterValue, 12, 11, 0, 0, // Skip to: 5196
/* 5185 */    MCD::OPC_CheckField, 3, 2, 0, 136, 73, 0, // Skip to: 24016
/* 5192 */    MCD::OPC_Decode, 211, 3, 61, // Opcode: FCMP_CUEQ_S
/* 5196 */    MCD::OPC_FilterValue, 13, 11, 0, 0, // Skip to: 5212
/* 5201 */    MCD::OPC_CheckField, 3, 2, 0, 120, 73, 0, // Skip to: 24016
/* 5208 */    MCD::OPC_Decode, 233, 3, 61, // Opcode: FCMP_SUEQ_S
/* 5212 */    MCD::OPC_FilterValue, 14, 11, 0, 0, // Skip to: 5228
/* 5217 */    MCD::OPC_CheckField, 3, 2, 0, 104, 73, 0, // Skip to: 24016
/* 5224 */    MCD::OPC_Decode, 213, 3, 61, // Opcode: FCMP_CULE_S
/* 5228 */    MCD::OPC_FilterValue, 15, 11, 0, 0, // Skip to: 5244
/* 5233 */    MCD::OPC_CheckField, 3, 2, 0, 88, 73, 0, // Skip to: 24016
/* 5240 */    MCD::OPC_Decode, 235, 3, 61, // Opcode: FCMP_SULE_S
/* 5244 */    MCD::OPC_FilterValue, 16, 11, 0, 0, // Skip to: 5260
/* 5249 */    MCD::OPC_CheckField, 3, 2, 0, 72, 73, 0, // Skip to: 24016
/* 5256 */    MCD::OPC_Decode, 207, 3, 61, // Opcode: FCMP_CNE_S
/* 5260 */    MCD::OPC_FilterValue, 17, 11, 0, 0, // Skip to: 5276
/* 5265 */    MCD::OPC_CheckField, 3, 2, 0, 56, 73, 0, // Skip to: 24016
/* 5272 */    MCD::OPC_Decode, 229, 3, 61, // Opcode: FCMP_SNE_S
/* 5276 */    MCD::OPC_FilterValue, 20, 11, 0, 0, // Skip to: 5292
/* 5281 */    MCD::OPC_CheckField, 3, 2, 0, 40, 73, 0, // Skip to: 24016
/* 5288 */    MCD::OPC_Decode, 209, 3, 61, // Opcode: FCMP_COR_S
/* 5292 */    MCD::OPC_FilterValue, 21, 11, 0, 0, // Skip to: 5308
/* 5297 */    MCD::OPC_CheckField, 3, 2, 0, 24, 73, 0, // Skip to: 24016
/* 5304 */    MCD::OPC_Decode, 231, 3, 61, // Opcode: FCMP_SOR_S
/* 5308 */    MCD::OPC_FilterValue, 24, 11, 0, 0, // Skip to: 5324
/* 5313 */    MCD::OPC_CheckField, 3, 2, 0, 8, 73, 0, // Skip to: 24016
/* 5320 */    MCD::OPC_Decode, 217, 3, 61, // Opcode: FCMP_CUNE_S
/* 5324 */    MCD::OPC_FilterValue, 25, 255, 72, 0, // Skip to: 24016
/* 5329 */    MCD::OPC_CheckField, 3, 2, 0, 248, 72, 0, // Skip to: 24016
/* 5336 */    MCD::OPC_Decode, 239, 3, 61, // Opcode: FCMP_SUNE_S
/* 5340 */    MCD::OPC_FilterValue, 2, 99, 1, 0, // Skip to: 5700
/* 5345 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 5348 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 5364
/* 5353 */    MCD::OPC_CheckField, 3, 2, 0, 224, 72, 0, // Skip to: 24016
/* 5360 */    MCD::OPC_Decode, 198, 3, 62, // Opcode: FCMP_CAF_D
/* 5364 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 5380
/* 5369 */    MCD::OPC_CheckField, 3, 2, 0, 208, 72, 0, // Skip to: 24016
/* 5376 */    MCD::OPC_Decode, 220, 3, 62, // Opcode: FCMP_SAF_D
/* 5380 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 5396
/* 5385 */    MCD::OPC_CheckField, 3, 2, 0, 192, 72, 0, // Skip to: 24016
/* 5392 */    MCD::OPC_Decode, 204, 3, 62, // Opcode: FCMP_CLT_D
/* 5396 */    MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 5412
/* 5401 */    MCD::OPC_CheckField, 3, 2, 0, 176, 72, 0, // Skip to: 24016
/* 5408 */    MCD::OPC_Decode, 226, 3, 62, // Opcode: FCMP_SLT_D
/* 5412 */    MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 5428
/* 5417 */    MCD::OPC_CheckField, 3, 2, 0, 160, 72, 0, // Skip to: 24016
/* 5424 */    MCD::OPC_Decode, 200, 3, 62, // Opcode: FCMP_CEQ_D
/* 5428 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 5444
/* 5433 */    MCD::OPC_CheckField, 3, 2, 0, 144, 72, 0, // Skip to: 24016
/* 5440 */    MCD::OPC_Decode, 222, 3, 62, // Opcode: FCMP_SEQ_D
/* 5444 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 5460
/* 5449 */    MCD::OPC_CheckField, 3, 2, 0, 128, 72, 0, // Skip to: 24016
/* 5456 */    MCD::OPC_Decode, 202, 3, 62, // Opcode: FCMP_CLE_D
/* 5460 */    MCD::OPC_FilterValue, 7, 11, 0, 0, // Skip to: 5476
/* 5465 */    MCD::OPC_CheckField, 3, 2, 0, 112, 72, 0, // Skip to: 24016
/* 5472 */    MCD::OPC_Decode, 224, 3, 62, // Opcode: FCMP_SLE_D
/* 5476 */    MCD::OPC_FilterValue, 8, 11, 0, 0, // Skip to: 5492
/* 5481 */    MCD::OPC_CheckField, 3, 2, 0, 96, 72, 0, // Skip to: 24016
/* 5488 */    MCD::OPC_Decode, 218, 3, 62, // Opcode: FCMP_CUN_D
/* 5492 */    MCD::OPC_FilterValue, 9, 11, 0, 0, // Skip to: 5508
/* 5497 */    MCD::OPC_CheckField, 3, 2, 0, 80, 72, 0, // Skip to: 24016
/* 5504 */    MCD::OPC_Decode, 240, 3, 62, // Opcode: FCMP_SUN_D
/* 5508 */    MCD::OPC_FilterValue, 10, 11, 0, 0, // Skip to: 5524
/* 5513 */    MCD::OPC_CheckField, 3, 2, 0, 64, 72, 0, // Skip to: 24016
/* 5520 */    MCD::OPC_Decode, 214, 3, 62, // Opcode: FCMP_CULT_D
/* 5524 */    MCD::OPC_FilterValue, 11, 11, 0, 0, // Skip to: 5540
/* 5529 */    MCD::OPC_CheckField, 3, 2, 0, 48, 72, 0, // Skip to: 24016
/* 5536 */    MCD::OPC_Decode, 236, 3, 62, // Opcode: FCMP_SULT_D
/* 5540 */    MCD::OPC_FilterValue, 12, 11, 0, 0, // Skip to: 5556
/* 5545 */    MCD::OPC_CheckField, 3, 2, 0, 32, 72, 0, // Skip to: 24016
/* 5552 */    MCD::OPC_Decode, 210, 3, 62, // Opcode: FCMP_CUEQ_D
/* 5556 */    MCD::OPC_FilterValue, 13, 11, 0, 0, // Skip to: 5572
/* 5561 */    MCD::OPC_CheckField, 3, 2, 0, 16, 72, 0, // Skip to: 24016
/* 5568 */    MCD::OPC_Decode, 232, 3, 62, // Opcode: FCMP_SUEQ_D
/* 5572 */    MCD::OPC_FilterValue, 14, 11, 0, 0, // Skip to: 5588
/* 5577 */    MCD::OPC_CheckField, 3, 2, 0, 0, 72, 0, // Skip to: 24016
/* 5584 */    MCD::OPC_Decode, 212, 3, 62, // Opcode: FCMP_CULE_D
/* 5588 */    MCD::OPC_FilterValue, 15, 11, 0, 0, // Skip to: 5604
/* 5593 */    MCD::OPC_CheckField, 3, 2, 0, 240, 71, 0, // Skip to: 24016
/* 5600 */    MCD::OPC_Decode, 234, 3, 62, // Opcode: FCMP_SULE_D
/* 5604 */    MCD::OPC_FilterValue, 16, 11, 0, 0, // Skip to: 5620
/* 5609 */    MCD::OPC_CheckField, 3, 2, 0, 224, 71, 0, // Skip to: 24016
/* 5616 */    MCD::OPC_Decode, 206, 3, 62, // Opcode: FCMP_CNE_D
/* 5620 */    MCD::OPC_FilterValue, 17, 11, 0, 0, // Skip to: 5636
/* 5625 */    MCD::OPC_CheckField, 3, 2, 0, 208, 71, 0, // Skip to: 24016
/* 5632 */    MCD::OPC_Decode, 228, 3, 62, // Opcode: FCMP_SNE_D
/* 5636 */    MCD::OPC_FilterValue, 20, 11, 0, 0, // Skip to: 5652
/* 5641 */    MCD::OPC_CheckField, 3, 2, 0, 192, 71, 0, // Skip to: 24016
/* 5648 */    MCD::OPC_Decode, 208, 3, 62, // Opcode: FCMP_COR_D
/* 5652 */    MCD::OPC_FilterValue, 21, 11, 0, 0, // Skip to: 5668
/* 5657 */    MCD::OPC_CheckField, 3, 2, 0, 176, 71, 0, // Skip to: 24016
/* 5664 */    MCD::OPC_Decode, 230, 3, 62, // Opcode: FCMP_SOR_D
/* 5668 */    MCD::OPC_FilterValue, 24, 11, 0, 0, // Skip to: 5684
/* 5673 */    MCD::OPC_CheckField, 3, 2, 0, 160, 71, 0, // Skip to: 24016
/* 5680 */    MCD::OPC_Decode, 216, 3, 62, // Opcode: FCMP_CUNE_D
/* 5684 */    MCD::OPC_FilterValue, 25, 151, 71, 0, // Skip to: 24016
/* 5689 */    MCD::OPC_CheckField, 3, 2, 0, 144, 71, 0, // Skip to: 24016
/* 5696 */    MCD::OPC_Decode, 238, 3, 62, // Opcode: FCMP_SUNE_D
/* 5700 */    MCD::OPC_FilterValue, 5, 201, 0, 0, // Skip to: 5906
/* 5705 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 5708 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 5717
/* 5713 */    MCD::OPC_Decode, 134, 7, 63, // Opcode: VFCMP_CAF_S
/* 5717 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 5726
/* 5722 */    MCD::OPC_Decode, 156, 7, 63, // Opcode: VFCMP_SAF_S
/* 5726 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 5735
/* 5731 */    MCD::OPC_Decode, 140, 7, 63, // Opcode: VFCMP_CLT_S
/* 5735 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 5744
/* 5740 */    MCD::OPC_Decode, 162, 7, 63, // Opcode: VFCMP_SLT_S
/* 5744 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 5753
/* 5749 */    MCD::OPC_Decode, 136, 7, 63, // Opcode: VFCMP_CEQ_S
/* 5753 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 5762
/* 5758 */    MCD::OPC_Decode, 158, 7, 63, // Opcode: VFCMP_SEQ_S
/* 5762 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 5771
/* 5767 */    MCD::OPC_Decode, 138, 7, 63, // Opcode: VFCMP_CLE_S
/* 5771 */    MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 5780
/* 5776 */    MCD::OPC_Decode, 160, 7, 63, // Opcode: VFCMP_SLE_S
/* 5780 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 5789
/* 5785 */    MCD::OPC_Decode, 154, 7, 63, // Opcode: VFCMP_CUN_S
/* 5789 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 5798
/* 5794 */    MCD::OPC_Decode, 176, 7, 63, // Opcode: VFCMP_SUN_S
/* 5798 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 5807
/* 5803 */    MCD::OPC_Decode, 150, 7, 63, // Opcode: VFCMP_CULT_S
/* 5807 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 5816
/* 5812 */    MCD::OPC_Decode, 172, 7, 63, // Opcode: VFCMP_SULT_S
/* 5816 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 5825
/* 5821 */    MCD::OPC_Decode, 146, 7, 63, // Opcode: VFCMP_CUEQ_S
/* 5825 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 5834
/* 5830 */    MCD::OPC_Decode, 168, 7, 63, // Opcode: VFCMP_SUEQ_S
/* 5834 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 5843
/* 5839 */    MCD::OPC_Decode, 148, 7, 63, // Opcode: VFCMP_CULE_S
/* 5843 */    MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 5852
/* 5848 */    MCD::OPC_Decode, 170, 7, 63, // Opcode: VFCMP_SULE_S
/* 5852 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 5861
/* 5857 */    MCD::OPC_Decode, 142, 7, 63, // Opcode: VFCMP_CNE_S
/* 5861 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 5870
/* 5866 */    MCD::OPC_Decode, 164, 7, 63, // Opcode: VFCMP_SNE_S
/* 5870 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 5879
/* 5875 */    MCD::OPC_Decode, 144, 7, 63, // Opcode: VFCMP_COR_S
/* 5879 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 5888
/* 5884 */    MCD::OPC_Decode, 166, 7, 63, // Opcode: VFCMP_SOR_S
/* 5888 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 5897
/* 5893 */    MCD::OPC_Decode, 152, 7, 63, // Opcode: VFCMP_CUNE_S
/* 5897 */    MCD::OPC_FilterValue, 25, 194, 70, 0, // Skip to: 24016
/* 5902 */    MCD::OPC_Decode, 174, 7, 63, // Opcode: VFCMP_SUNE_S
/* 5906 */    MCD::OPC_FilterValue, 6, 201, 0, 0, // Skip to: 6112
/* 5911 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 5914 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 5923
/* 5919 */    MCD::OPC_Decode, 133, 7, 63, // Opcode: VFCMP_CAF_D
/* 5923 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 5932
/* 5928 */    MCD::OPC_Decode, 155, 7, 63, // Opcode: VFCMP_SAF_D
/* 5932 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 5941
/* 5937 */    MCD::OPC_Decode, 139, 7, 63, // Opcode: VFCMP_CLT_D
/* 5941 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 5950
/* 5946 */    MCD::OPC_Decode, 161, 7, 63, // Opcode: VFCMP_SLT_D
/* 5950 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 5959
/* 5955 */    MCD::OPC_Decode, 135, 7, 63, // Opcode: VFCMP_CEQ_D
/* 5959 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 5968
/* 5964 */    MCD::OPC_Decode, 157, 7, 63, // Opcode: VFCMP_SEQ_D
/* 5968 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 5977
/* 5973 */    MCD::OPC_Decode, 137, 7, 63, // Opcode: VFCMP_CLE_D
/* 5977 */    MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 5986
/* 5982 */    MCD::OPC_Decode, 159, 7, 63, // Opcode: VFCMP_SLE_D
/* 5986 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 5995
/* 5991 */    MCD::OPC_Decode, 153, 7, 63, // Opcode: VFCMP_CUN_D
/* 5995 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 6004
/* 6000 */    MCD::OPC_Decode, 175, 7, 63, // Opcode: VFCMP_SUN_D
/* 6004 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 6013
/* 6009 */    MCD::OPC_Decode, 149, 7, 63, // Opcode: VFCMP_CULT_D
/* 6013 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 6022
/* 6018 */    MCD::OPC_Decode, 171, 7, 63, // Opcode: VFCMP_SULT_D
/* 6022 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 6031
/* 6027 */    MCD::OPC_Decode, 145, 7, 63, // Opcode: VFCMP_CUEQ_D
/* 6031 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 6040
/* 6036 */    MCD::OPC_Decode, 167, 7, 63, // Opcode: VFCMP_SUEQ_D
/* 6040 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 6049
/* 6045 */    MCD::OPC_Decode, 147, 7, 63, // Opcode: VFCMP_CULE_D
/* 6049 */    MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 6058
/* 6054 */    MCD::OPC_Decode, 169, 7, 63, // Opcode: VFCMP_SULE_D
/* 6058 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 6067
/* 6063 */    MCD::OPC_Decode, 141, 7, 63, // Opcode: VFCMP_CNE_D
/* 6067 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 6076
/* 6072 */    MCD::OPC_Decode, 163, 7, 63, // Opcode: VFCMP_SNE_D
/* 6076 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 6085
/* 6081 */    MCD::OPC_Decode, 143, 7, 63, // Opcode: VFCMP_COR_D
/* 6085 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 6094
/* 6090 */    MCD::OPC_Decode, 165, 7, 63, // Opcode: VFCMP_SOR_D
/* 6094 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 6103
/* 6099 */    MCD::OPC_Decode, 151, 7, 63, // Opcode: VFCMP_CUNE_D
/* 6103 */    MCD::OPC_FilterValue, 25, 244, 69, 0, // Skip to: 24016
/* 6108 */    MCD::OPC_Decode, 173, 7, 63, // Opcode: VFCMP_SUNE_D
/* 6112 */    MCD::OPC_FilterValue, 9, 201, 0, 0, // Skip to: 6318
/* 6117 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 6120 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6129
/* 6125 */    MCD::OPC_Decode, 193, 13, 64, // Opcode: XVFCMP_CAF_S
/* 6129 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 6138
/* 6134 */    MCD::OPC_Decode, 215, 13, 64, // Opcode: XVFCMP_SAF_S
/* 6138 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 6147
/* 6143 */    MCD::OPC_Decode, 199, 13, 64, // Opcode: XVFCMP_CLT_S
/* 6147 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 6156
/* 6152 */    MCD::OPC_Decode, 221, 13, 64, // Opcode: XVFCMP_SLT_S
/* 6156 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 6165
/* 6161 */    MCD::OPC_Decode, 195, 13, 64, // Opcode: XVFCMP_CEQ_S
/* 6165 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 6174
/* 6170 */    MCD::OPC_Decode, 217, 13, 64, // Opcode: XVFCMP_SEQ_S
/* 6174 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 6183
/* 6179 */    MCD::OPC_Decode, 197, 13, 64, // Opcode: XVFCMP_CLE_S
/* 6183 */    MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 6192
/* 6188 */    MCD::OPC_Decode, 219, 13, 64, // Opcode: XVFCMP_SLE_S
/* 6192 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 6201
/* 6197 */    MCD::OPC_Decode, 213, 13, 64, // Opcode: XVFCMP_CUN_S
/* 6201 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 6210
/* 6206 */    MCD::OPC_Decode, 235, 13, 64, // Opcode: XVFCMP_SUN_S
/* 6210 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 6219
/* 6215 */    MCD::OPC_Decode, 209, 13, 64, // Opcode: XVFCMP_CULT_S
/* 6219 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 6228
/* 6224 */    MCD::OPC_Decode, 231, 13, 64, // Opcode: XVFCMP_SULT_S
/* 6228 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 6237
/* 6233 */    MCD::OPC_Decode, 205, 13, 64, // Opcode: XVFCMP_CUEQ_S
/* 6237 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 6246
/* 6242 */    MCD::OPC_Decode, 227, 13, 64, // Opcode: XVFCMP_SUEQ_S
/* 6246 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 6255
/* 6251 */    MCD::OPC_Decode, 207, 13, 64, // Opcode: XVFCMP_CULE_S
/* 6255 */    MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 6264
/* 6260 */    MCD::OPC_Decode, 229, 13, 64, // Opcode: XVFCMP_SULE_S
/* 6264 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 6273
/* 6269 */    MCD::OPC_Decode, 201, 13, 64, // Opcode: XVFCMP_CNE_S
/* 6273 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 6282
/* 6278 */    MCD::OPC_Decode, 223, 13, 64, // Opcode: XVFCMP_SNE_S
/* 6282 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 6291
/* 6287 */    MCD::OPC_Decode, 203, 13, 64, // Opcode: XVFCMP_COR_S
/* 6291 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 6300
/* 6296 */    MCD::OPC_Decode, 225, 13, 64, // Opcode: XVFCMP_SOR_S
/* 6300 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 6309
/* 6305 */    MCD::OPC_Decode, 211, 13, 64, // Opcode: XVFCMP_CUNE_S
/* 6309 */    MCD::OPC_FilterValue, 25, 38, 69, 0, // Skip to: 24016
/* 6314 */    MCD::OPC_Decode, 233, 13, 64, // Opcode: XVFCMP_SUNE_S
/* 6318 */    MCD::OPC_FilterValue, 10, 201, 0, 0, // Skip to: 6524
/* 6323 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 6326 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6335
/* 6331 */    MCD::OPC_Decode, 192, 13, 64, // Opcode: XVFCMP_CAF_D
/* 6335 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 6344
/* 6340 */    MCD::OPC_Decode, 214, 13, 64, // Opcode: XVFCMP_SAF_D
/* 6344 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 6353
/* 6349 */    MCD::OPC_Decode, 198, 13, 64, // Opcode: XVFCMP_CLT_D
/* 6353 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 6362
/* 6358 */    MCD::OPC_Decode, 220, 13, 64, // Opcode: XVFCMP_SLT_D
/* 6362 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 6371
/* 6367 */    MCD::OPC_Decode, 194, 13, 64, // Opcode: XVFCMP_CEQ_D
/* 6371 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 6380
/* 6376 */    MCD::OPC_Decode, 216, 13, 64, // Opcode: XVFCMP_SEQ_D
/* 6380 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 6389
/* 6385 */    MCD::OPC_Decode, 196, 13, 64, // Opcode: XVFCMP_CLE_D
/* 6389 */    MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 6398
/* 6394 */    MCD::OPC_Decode, 218, 13, 64, // Opcode: XVFCMP_SLE_D
/* 6398 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 6407
/* 6403 */    MCD::OPC_Decode, 212, 13, 64, // Opcode: XVFCMP_CUN_D
/* 6407 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 6416
/* 6412 */    MCD::OPC_Decode, 234, 13, 64, // Opcode: XVFCMP_SUN_D
/* 6416 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 6425
/* 6421 */    MCD::OPC_Decode, 208, 13, 64, // Opcode: XVFCMP_CULT_D
/* 6425 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 6434
/* 6430 */    MCD::OPC_Decode, 230, 13, 64, // Opcode: XVFCMP_SULT_D
/* 6434 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 6443
/* 6439 */    MCD::OPC_Decode, 204, 13, 64, // Opcode: XVFCMP_CUEQ_D
/* 6443 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 6452
/* 6448 */    MCD::OPC_Decode, 226, 13, 64, // Opcode: XVFCMP_SUEQ_D
/* 6452 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 6461
/* 6457 */    MCD::OPC_Decode, 206, 13, 64, // Opcode: XVFCMP_CULE_D
/* 6461 */    MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 6470
/* 6466 */    MCD::OPC_Decode, 228, 13, 64, // Opcode: XVFCMP_SULE_D
/* 6470 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 6479
/* 6475 */    MCD::OPC_Decode, 200, 13, 64, // Opcode: XVFCMP_CNE_D
/* 6479 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 6488
/* 6484 */    MCD::OPC_Decode, 222, 13, 64, // Opcode: XVFCMP_SNE_D
/* 6488 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 6497
/* 6493 */    MCD::OPC_Decode, 202, 13, 64, // Opcode: XVFCMP_COR_D
/* 6497 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 6506
/* 6502 */    MCD::OPC_Decode, 224, 13, 64, // Opcode: XVFCMP_SOR_D
/* 6506 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 6515
/* 6511 */    MCD::OPC_Decode, 210, 13, 64, // Opcode: XVFCMP_CUNE_D
/* 6515 */    MCD::OPC_FilterValue, 25, 88, 68, 0, // Skip to: 24016
/* 6520 */    MCD::OPC_Decode, 232, 13, 64, // Opcode: XVFCMP_SUNE_D
/* 6524 */    MCD::OPC_FilterValue, 16, 11, 0, 0, // Skip to: 6540
/* 6529 */    MCD::OPC_CheckField, 18, 2, 0, 72, 68, 0, // Skip to: 24016
/* 6536 */    MCD::OPC_Decode, 168, 4, 65, // Opcode: FSEL_xS
/* 6540 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 6549
/* 6545 */    MCD::OPC_Decode, 204, 6, 59, // Opcode: VBITSEL_V
/* 6549 */    MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 6558
/* 6554 */    MCD::OPC_Decode, 147, 13, 60, // Opcode: XVBITSEL_V
/* 6558 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 6567
/* 6563 */    MCD::OPC_Decode, 252, 9, 59, // Opcode: VSHUF_B
/* 6567 */    MCD::OPC_FilterValue, 22, 36, 68, 0, // Skip to: 24016
/* 6572 */    MCD::OPC_Decode, 190, 16, 60, // Opcode: XVSHUF_B
/* 6576 */    MCD::OPC_FilterValue, 4, 9, 0, 0, // Skip to: 6590
/* 6581 */    MCD::OPC_CheckPredicate, 0, 22, 68, 0, // Skip to: 24016
/* 6586 */    MCD::OPC_Decode, 198, 2, 66, // Opcode: ADDU16I_D
/* 6590 */    MCD::OPC_FilterValue, 5, 26, 0, 0, // Skip to: 6621
/* 6595 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 6598 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6607
/* 6603 */    MCD::OPC_Decode, 252, 4, 67, // Opcode: LU12I_W
/* 6607 */    MCD::OPC_FilterValue, 1, 252, 67, 0, // Skip to: 24016
/* 6612 */    MCD::OPC_CheckPredicate, 0, 247, 67, 0, // Skip to: 24016
/* 6617 */    MCD::OPC_Decode, 253, 4, 68, // Opcode: LU32I_D
/* 6621 */    MCD::OPC_FilterValue, 6, 21, 0, 0, // Skip to: 6647
/* 6626 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 6629 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6638
/* 6634 */    MCD::OPC_Decode, 161, 5, 67, // Opcode: PCADDI
/* 6638 */    MCD::OPC_FilterValue, 1, 221, 67, 0, // Skip to: 24016
/* 6643 */    MCD::OPC_Decode, 164, 5, 67, // Opcode: PCALAU12I
/* 6647 */    MCD::OPC_FilterValue, 7, 26, 0, 0, // Skip to: 6678
/* 6652 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 6655 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6664
/* 6660 */    MCD::OPC_Decode, 162, 5, 67, // Opcode: PCADDU12I
/* 6664 */    MCD::OPC_FilterValue, 1, 195, 67, 0, // Skip to: 24016
/* 6669 */    MCD::OPC_CheckPredicate, 0, 190, 67, 0, // Skip to: 24016
/* 6674 */    MCD::OPC_Decode, 163, 5, 67, // Opcode: PCADDU18I
/* 6678 */    MCD::OPC_FilterValue, 8, 49, 0, 0, // Skip to: 6732
/* 6683 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 6686 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6695
/* 6691 */    MCD::OPC_Decode, 251, 4, 69, // Opcode: LL_W
/* 6695 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 6704
/* 6700 */    MCD::OPC_Decode, 197, 5, 70, // Opcode: SC_W
/* 6704 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 6718
/* 6709 */    MCD::OPC_CheckPredicate, 0, 150, 67, 0, // Skip to: 24016
/* 6714 */    MCD::OPC_Decode, 250, 4, 69, // Opcode: LL_D
/* 6718 */    MCD::OPC_FilterValue, 3, 141, 67, 0, // Skip to: 24016
/* 6723 */    MCD::OPC_CheckPredicate, 0, 136, 67, 0, // Skip to: 24016
/* 6728 */    MCD::OPC_Decode, 196, 5, 70, // Opcode: SC_D
/* 6732 */    MCD::OPC_FilterValue, 9, 59, 0, 0, // Skip to: 6796
/* 6737 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 6740 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 6754
/* 6745 */    MCD::OPC_CheckPredicate, 0, 114, 67, 0, // Skip to: 24016
/* 6750 */    MCD::OPC_Decode, 233, 4, 69, // Opcode: LDPTR_W
/* 6754 */    MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 6768
/* 6759 */    MCD::OPC_CheckPredicate, 0, 100, 67, 0, // Skip to: 24016
/* 6764 */    MCD::OPC_Decode, 231, 5, 69, // Opcode: STPTR_W
/* 6768 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 6782
/* 6773 */    MCD::OPC_CheckPredicate, 0, 86, 67, 0, // Skip to: 24016
/* 6778 */    MCD::OPC_Decode, 232, 4, 69, // Opcode: LDPTR_D
/* 6782 */    MCD::OPC_FilterValue, 3, 77, 67, 0, // Skip to: 24016
/* 6787 */    MCD::OPC_CheckPredicate, 0, 72, 67, 0, // Skip to: 24016
/* 6792 */    MCD::OPC_Decode, 230, 5, 69, // Opcode: STPTR_D
/* 6796 */    MCD::OPC_FilterValue, 10, 162, 0, 0, // Skip to: 6963
/* 6801 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 6804 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6813
/* 6809 */    MCD::OPC_Decode, 243, 4, 48, // Opcode: LD_B
/* 6813 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 6822
/* 6818 */    MCD::OPC_Decode, 246, 4, 48, // Opcode: LD_H
/* 6822 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 6831
/* 6827 */    MCD::OPC_Decode, 248, 4, 48, // Opcode: LD_W
/* 6831 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 6845
/* 6836 */    MCD::OPC_CheckPredicate, 0, 23, 67, 0, // Skip to: 24016
/* 6841 */    MCD::OPC_Decode, 245, 4, 48, // Opcode: LD_D
/* 6845 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 6854
/* 6850 */    MCD::OPC_Decode, 238, 5, 48, // Opcode: ST_B
/* 6854 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 6863
/* 6859 */    MCD::OPC_Decode, 240, 5, 48, // Opcode: ST_H
/* 6863 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 6872
/* 6868 */    MCD::OPC_Decode, 241, 5, 48, // Opcode: ST_W
/* 6872 */    MCD::OPC_FilterValue, 7, 9, 0, 0, // Skip to: 6886
/* 6877 */    MCD::OPC_CheckPredicate, 0, 238, 66, 0, // Skip to: 24016
/* 6882 */    MCD::OPC_Decode, 239, 5, 48, // Opcode: ST_D
/* 6886 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 6895
/* 6891 */    MCD::OPC_Decode, 244, 4, 48, // Opcode: LD_BU
/* 6895 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 6904
/* 6900 */    MCD::OPC_Decode, 247, 4, 48, // Opcode: LD_HU
/* 6904 */    MCD::OPC_FilterValue, 10, 9, 0, 0, // Skip to: 6918
/* 6909 */    MCD::OPC_CheckPredicate, 0, 206, 66, 0, // Skip to: 24016
/* 6914 */    MCD::OPC_Decode, 249, 4, 48, // Opcode: LD_WU
/* 6918 */    MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 6927
/* 6923 */    MCD::OPC_Decode, 165, 5, 53, // Opcode: PRELD
/* 6927 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 6936
/* 6932 */    MCD::OPC_Decode, 134, 4, 71, // Opcode: FLD_S
/* 6936 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 6945
/* 6941 */    MCD::OPC_Decode, 178, 4, 71, // Opcode: FST_S
/* 6945 */    MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 6954
/* 6950 */    MCD::OPC_Decode, 133, 4, 72, // Opcode: FLD_D
/* 6954 */    MCD::OPC_FilterValue, 15, 161, 66, 0, // Skip to: 24016
/* 6959 */    MCD::OPC_Decode, 177, 4, 72, // Opcode: FST_D
/* 6963 */    MCD::OPC_FilterValue, 11, 131, 0, 0, // Skip to: 7099
/* 6968 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 6971 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6980
/* 6976 */    MCD::OPC_Decode, 163, 8, 73, // Opcode: VLD
/* 6980 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 6989
/* 6985 */    MCD::OPC_Decode, 174, 11, 73, // Opcode: VST
/* 6989 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 6998
/* 6994 */    MCD::OPC_Decode, 223, 14, 74, // Opcode: XVLD
/* 6998 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 7007
/* 7003 */    MCD::OPC_Decode, 240, 17, 74, // Opcode: XVST
/* 7007 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 7016
/* 7012 */    MCD::OPC_Decode, 230, 4, 48, // Opcode: LDL_W
/* 7016 */    MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 7025
/* 7021 */    MCD::OPC_Decode, 235, 4, 48, // Opcode: LDR_W
/* 7025 */    MCD::OPC_FilterValue, 10, 9, 0, 0, // Skip to: 7039
/* 7030 */    MCD::OPC_CheckPredicate, 0, 85, 66, 0, // Skip to: 24016
/* 7035 */    MCD::OPC_Decode, 229, 4, 48, // Opcode: LDL_D
/* 7039 */    MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 7053
/* 7044 */    MCD::OPC_CheckPredicate, 0, 71, 66, 0, // Skip to: 24016
/* 7049 */    MCD::OPC_Decode, 234, 4, 48, // Opcode: LDR_D
/* 7053 */    MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 7062
/* 7058 */    MCD::OPC_Decode, 229, 5, 48, // Opcode: STL_W
/* 7062 */    MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 7071
/* 7067 */    MCD::OPC_Decode, 233, 5, 48, // Opcode: STR_W
/* 7071 */    MCD::OPC_FilterValue, 14, 9, 0, 0, // Skip to: 7085
/* 7076 */    MCD::OPC_CheckPredicate, 0, 39, 66, 0, // Skip to: 24016
/* 7081 */    MCD::OPC_Decode, 228, 5, 48, // Opcode: STL_D
/* 7085 */    MCD::OPC_FilterValue, 15, 30, 66, 0, // Skip to: 24016
/* 7090 */    MCD::OPC_CheckPredicate, 0, 25, 66, 0, // Skip to: 24016
/* 7095 */    MCD::OPC_Decode, 232, 5, 48, // Opcode: STR_D
/* 7099 */    MCD::OPC_FilterValue, 12, 1, 1, 0, // Skip to: 7361
/* 7104 */    MCD::OPC_ExtractField, 23, 3,  // Inst{25-23} ...
/* 7107 */    MCD::OPC_FilterValue, 0, 44, 0, 0, // Skip to: 7156
/* 7112 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 7115 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 7131
/* 7120 */    MCD::OPC_CheckField, 19, 2, 2, 249, 65, 0, // Skip to: 24016
/* 7127 */    MCD::OPC_Decode, 166, 8, 75, // Opcode: VLDREPL_D
/* 7131 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 7147
/* 7136 */    MCD::OPC_CheckField, 20, 1, 0, 233, 65, 0, // Skip to: 24016
/* 7143 */    MCD::OPC_Decode, 168, 8, 76, // Opcode: VLDREPL_W
/* 7147 */    MCD::OPC_FilterValue, 2, 224, 65, 0, // Skip to: 24016
/* 7152 */    MCD::OPC_Decode, 167, 8, 77, // Opcode: VLDREPL_H
/* 7156 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 7172
/* 7161 */    MCD::OPC_CheckField, 22, 1, 0, 208, 65, 0, // Skip to: 24016
/* 7168 */    MCD::OPC_Decode, 165, 8, 73, // Opcode: VLDREPL_B
/* 7172 */    MCD::OPC_FilterValue, 2, 44, 0, 0, // Skip to: 7221
/* 7177 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 7180 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 7196
/* 7185 */    MCD::OPC_CheckField, 19, 2, 2, 184, 65, 0, // Skip to: 24016
/* 7192 */    MCD::OPC_Decode, 176, 11, 78, // Opcode: VSTELM_D
/* 7196 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 7212
/* 7201 */    MCD::OPC_CheckField, 20, 1, 0, 168, 65, 0, // Skip to: 24016
/* 7208 */    MCD::OPC_Decode, 178, 11, 79, // Opcode: VSTELM_W
/* 7212 */    MCD::OPC_FilterValue, 2, 159, 65, 0, // Skip to: 24016
/* 7217 */    MCD::OPC_Decode, 177, 11, 80, // Opcode: VSTELM_H
/* 7221 */    MCD::OPC_FilterValue, 3, 11, 0, 0, // Skip to: 7237
/* 7226 */    MCD::OPC_CheckField, 22, 1, 0, 143, 65, 0, // Skip to: 24016
/* 7233 */    MCD::OPC_Decode, 175, 11, 81, // Opcode: VSTELM_B
/* 7237 */    MCD::OPC_FilterValue, 4, 44, 0, 0, // Skip to: 7286
/* 7242 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 7245 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 7261
/* 7250 */    MCD::OPC_CheckField, 19, 2, 2, 119, 65, 0, // Skip to: 24016
/* 7257 */    MCD::OPC_Decode, 226, 14, 82, // Opcode: XVLDREPL_D
/* 7261 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 7277
/* 7266 */    MCD::OPC_CheckField, 20, 1, 0, 103, 65, 0, // Skip to: 24016
/* 7273 */    MCD::OPC_Decode, 228, 14, 83, // Opcode: XVLDREPL_W
/* 7277 */    MCD::OPC_FilterValue, 2, 94, 65, 0, // Skip to: 24016
/* 7282 */    MCD::OPC_Decode, 227, 14, 84, // Opcode: XVLDREPL_H
/* 7286 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 7302
/* 7291 */    MCD::OPC_CheckField, 22, 1, 0, 78, 65, 0, // Skip to: 24016
/* 7298 */    MCD::OPC_Decode, 225, 14, 74, // Opcode: XVLDREPL_B
/* 7302 */    MCD::OPC_FilterValue, 6, 45, 0, 0, // Skip to: 7352
/* 7307 */    MCD::OPC_ExtractField, 22, 1,  // Inst{22} ...
/* 7310 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 7343
/* 7315 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 7318 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 7334
/* 7323 */    MCD::OPC_CheckField, 20, 1, 1, 46, 65, 0, // Skip to: 24016
/* 7330 */    MCD::OPC_Decode, 242, 17, 85, // Opcode: XVSTELM_D
/* 7334 */    MCD::OPC_FilterValue, 1, 37, 65, 0, // Skip to: 24016
/* 7339 */    MCD::OPC_Decode, 244, 17, 86, // Opcode: XVSTELM_W
/* 7343 */    MCD::OPC_FilterValue, 1, 28, 65, 0, // Skip to: 24016
/* 7348 */    MCD::OPC_Decode, 243, 17, 87, // Opcode: XVSTELM_H
/* 7352 */    MCD::OPC_FilterValue, 7, 19, 65, 0, // Skip to: 24016
/* 7357 */    MCD::OPC_Decode, 241, 17, 88, // Opcode: XVSTELM_B
/* 7361 */    MCD::OPC_FilterValue, 14, 103, 4, 0, // Skip to: 8493
/* 7366 */    MCD::OPC_ExtractField, 15, 11,  // Inst{25-15} ...
/* 7369 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 7383
/* 7374 */    MCD::OPC_CheckPredicate, 0, 253, 64, 0, // Skip to: 24016
/* 7379 */    MCD::OPC_Decode, 236, 4, 11, // Opcode: LDX_B
/* 7383 */    MCD::OPC_FilterValue, 8, 9, 0, 0, // Skip to: 7397
/* 7388 */    MCD::OPC_CheckPredicate, 0, 239, 64, 0, // Skip to: 24016
/* 7393 */    MCD::OPC_Decode, 239, 4, 11, // Opcode: LDX_H
/* 7397 */    MCD::OPC_FilterValue, 16, 9, 0, 0, // Skip to: 7411
/* 7402 */    MCD::OPC_CheckPredicate, 0, 225, 64, 0, // Skip to: 24016
/* 7407 */    MCD::OPC_Decode, 241, 4, 11, // Opcode: LDX_W
/* 7411 */    MCD::OPC_FilterValue, 24, 9, 0, 0, // Skip to: 7425
/* 7416 */    MCD::OPC_CheckPredicate, 0, 211, 64, 0, // Skip to: 24016
/* 7421 */    MCD::OPC_Decode, 238, 4, 11, // Opcode: LDX_D
/* 7425 */    MCD::OPC_FilterValue, 32, 9, 0, 0, // Skip to: 7439
/* 7430 */    MCD::OPC_CheckPredicate, 0, 197, 64, 0, // Skip to: 24016
/* 7435 */    MCD::OPC_Decode, 234, 5, 11, // Opcode: STX_B
/* 7439 */    MCD::OPC_FilterValue, 40, 9, 0, 0, // Skip to: 7453
/* 7444 */    MCD::OPC_CheckPredicate, 0, 183, 64, 0, // Skip to: 24016
/* 7449 */    MCD::OPC_Decode, 236, 5, 11, // Opcode: STX_H
/* 7453 */    MCD::OPC_FilterValue, 48, 9, 0, 0, // Skip to: 7467
/* 7458 */    MCD::OPC_CheckPredicate, 0, 169, 64, 0, // Skip to: 24016
/* 7463 */    MCD::OPC_Decode, 237, 5, 11, // Opcode: STX_W
/* 7467 */    MCD::OPC_FilterValue, 56, 9, 0, 0, // Skip to: 7481
/* 7472 */    MCD::OPC_CheckPredicate, 0, 155, 64, 0, // Skip to: 24016
/* 7477 */    MCD::OPC_Decode, 235, 5, 11, // Opcode: STX_D
/* 7481 */    MCD::OPC_FilterValue, 64, 9, 0, 0, // Skip to: 7495
/* 7486 */    MCD::OPC_CheckPredicate, 0, 141, 64, 0, // Skip to: 24016
/* 7491 */    MCD::OPC_Decode, 237, 4, 11, // Opcode: LDX_BU
/* 7495 */    MCD::OPC_FilterValue, 72, 9, 0, 0, // Skip to: 7509
/* 7500 */    MCD::OPC_CheckPredicate, 0, 127, 64, 0, // Skip to: 24016
/* 7505 */    MCD::OPC_Decode, 240, 4, 11, // Opcode: LDX_HU
/* 7509 */    MCD::OPC_FilterValue, 80, 9, 0, 0, // Skip to: 7523
/* 7514 */    MCD::OPC_CheckPredicate, 0, 113, 64, 0, // Skip to: 24016
/* 7519 */    MCD::OPC_Decode, 242, 4, 11, // Opcode: LDX_WU
/* 7523 */    MCD::OPC_FilterValue, 88, 9, 0, 0, // Skip to: 7537
/* 7528 */    MCD::OPC_CheckPredicate, 0, 99, 64, 0, // Skip to: 24016
/* 7533 */    MCD::OPC_Decode, 166, 5, 89, // Opcode: PRELDX
/* 7537 */    MCD::OPC_FilterValue, 96, 4, 0, 0, // Skip to: 7546
/* 7542 */    MCD::OPC_Decode, 132, 4, 90, // Opcode: FLDX_S
/* 7546 */    MCD::OPC_FilterValue, 104, 4, 0, 0, // Skip to: 7555
/* 7551 */    MCD::OPC_Decode, 131, 4, 91, // Opcode: FLDX_D
/* 7555 */    MCD::OPC_FilterValue, 112, 4, 0, 0, // Skip to: 7564
/* 7560 */    MCD::OPC_Decode, 176, 4, 90, // Opcode: FSTX_S
/* 7564 */    MCD::OPC_FilterValue, 120, 4, 0, 0, // Skip to: 7573
/* 7569 */    MCD::OPC_Decode, 175, 4, 91, // Opcode: FSTX_D
/* 7573 */    MCD::OPC_FilterValue, 128, 1, 4, 0, 0, // Skip to: 7583
/* 7579 */    MCD::OPC_Decode, 169, 8, 92, // Opcode: VLDX
/* 7583 */    MCD::OPC_FilterValue, 136, 1, 4, 0, 0, // Skip to: 7593
/* 7589 */    MCD::OPC_Decode, 179, 11, 92, // Opcode: VSTX
/* 7593 */    MCD::OPC_FilterValue, 144, 1, 4, 0, 0, // Skip to: 7603
/* 7599 */    MCD::OPC_Decode, 229, 14, 93, // Opcode: XVLDX
/* 7603 */    MCD::OPC_FilterValue, 152, 1, 4, 0, 0, // Skip to: 7613
/* 7609 */    MCD::OPC_Decode, 245, 17, 93, // Opcode: XVSTX
/* 7613 */    MCD::OPC_FilterValue, 192, 1, 9, 0, 0, // Skip to: 7628
/* 7619 */    MCD::OPC_CheckPredicate, 0, 8, 64, 0, // Skip to: 24016
/* 7624 */    MCD::OPC_Decode, 233, 2, 94, // Opcode: AMSWAP_W
/* 7628 */    MCD::OPC_FilterValue, 193, 1, 9, 0, 0, // Skip to: 7643
/* 7634 */    MCD::OPC_CheckPredicate, 0, 249, 63, 0, // Skip to: 24016
/* 7639 */    MCD::OPC_Decode, 232, 2, 94, // Opcode: AMSWAP_D
/* 7643 */    MCD::OPC_FilterValue, 194, 1, 9, 0, 0, // Skip to: 7658
/* 7649 */    MCD::OPC_CheckPredicate, 0, 234, 63, 0, // Skip to: 24016
/* 7654 */    MCD::OPC_Decode, 205, 2, 94, // Opcode: AMADD_W
/* 7658 */    MCD::OPC_FilterValue, 195, 1, 9, 0, 0, // Skip to: 7673
/* 7664 */    MCD::OPC_CheckPredicate, 0, 219, 63, 0, // Skip to: 24016
/* 7669 */    MCD::OPC_Decode, 204, 2, 94, // Opcode: AMADD_D
/* 7673 */    MCD::OPC_FilterValue, 196, 1, 9, 0, 0, // Skip to: 7688
/* 7679 */    MCD::OPC_CheckPredicate, 0, 204, 63, 0, // Skip to: 24016
/* 7684 */    MCD::OPC_Decode, 209, 2, 94, // Opcode: AMAND_W
/* 7688 */    MCD::OPC_FilterValue, 197, 1, 9, 0, 0, // Skip to: 7703
/* 7694 */    MCD::OPC_CheckPredicate, 0, 189, 63, 0, // Skip to: 24016
/* 7699 */    MCD::OPC_Decode, 208, 2, 94, // Opcode: AMAND_D
/* 7703 */    MCD::OPC_FilterValue, 198, 1, 9, 0, 0, // Skip to: 7718
/* 7709 */    MCD::OPC_CheckPredicate, 0, 174, 63, 0, // Skip to: 24016
/* 7714 */    MCD::OPC_Decode, 229, 2, 94, // Opcode: AMOR_W
/* 7718 */    MCD::OPC_FilterValue, 199, 1, 9, 0, 0, // Skip to: 7733
/* 7724 */    MCD::OPC_CheckPredicate, 0, 159, 63, 0, // Skip to: 24016
/* 7729 */    MCD::OPC_Decode, 228, 2, 94, // Opcode: AMOR_D
/* 7733 */    MCD::OPC_FilterValue, 200, 1, 9, 0, 0, // Skip to: 7748
/* 7739 */    MCD::OPC_CheckPredicate, 0, 144, 63, 0, // Skip to: 24016
/* 7744 */    MCD::OPC_Decode, 237, 2, 94, // Opcode: AMXOR_W
/* 7748 */    MCD::OPC_FilterValue, 201, 1, 9, 0, 0, // Skip to: 7763
/* 7754 */    MCD::OPC_CheckPredicate, 0, 129, 63, 0, // Skip to: 24016
/* 7759 */    MCD::OPC_Decode, 236, 2, 94, // Opcode: AMXOR_D
/* 7763 */    MCD::OPC_FilterValue, 202, 1, 9, 0, 0, // Skip to: 7778
/* 7769 */    MCD::OPC_CheckPredicate, 0, 114, 63, 0, // Skip to: 24016
/* 7774 */    MCD::OPC_Decode, 214, 2, 94, // Opcode: AMMAX_W
/* 7778 */    MCD::OPC_FilterValue, 203, 1, 9, 0, 0, // Skip to: 7793
/* 7784 */    MCD::OPC_CheckPredicate, 0, 99, 63, 0, // Skip to: 24016
/* 7789 */    MCD::OPC_Decode, 212, 2, 94, // Opcode: AMMAX_D
/* 7793 */    MCD::OPC_FilterValue, 204, 1, 9, 0, 0, // Skip to: 7808
/* 7799 */    MCD::OPC_CheckPredicate, 0, 84, 63, 0, // Skip to: 24016
/* 7804 */    MCD::OPC_Decode, 222, 2, 94, // Opcode: AMMIN_W
/* 7808 */    MCD::OPC_FilterValue, 205, 1, 9, 0, 0, // Skip to: 7823
/* 7814 */    MCD::OPC_CheckPredicate, 0, 69, 63, 0, // Skip to: 24016
/* 7819 */    MCD::OPC_Decode, 220, 2, 94, // Opcode: AMMIN_D
/* 7823 */    MCD::OPC_FilterValue, 206, 1, 9, 0, 0, // Skip to: 7838
/* 7829 */    MCD::OPC_CheckPredicate, 0, 54, 63, 0, // Skip to: 24016
/* 7834 */    MCD::OPC_Decode, 215, 2, 94, // Opcode: AMMAX_WU
/* 7838 */    MCD::OPC_FilterValue, 207, 1, 9, 0, 0, // Skip to: 7853
/* 7844 */    MCD::OPC_CheckPredicate, 0, 39, 63, 0, // Skip to: 24016
/* 7849 */    MCD::OPC_Decode, 213, 2, 94, // Opcode: AMMAX_DU
/* 7853 */    MCD::OPC_FilterValue, 208, 1, 9, 0, 0, // Skip to: 7868
/* 7859 */    MCD::OPC_CheckPredicate, 0, 24, 63, 0, // Skip to: 24016
/* 7864 */    MCD::OPC_Decode, 223, 2, 94, // Opcode: AMMIN_WU
/* 7868 */    MCD::OPC_FilterValue, 209, 1, 9, 0, 0, // Skip to: 7883
/* 7874 */    MCD::OPC_CheckPredicate, 0, 9, 63, 0, // Skip to: 24016
/* 7879 */    MCD::OPC_Decode, 221, 2, 94, // Opcode: AMMIN_DU
/* 7883 */    MCD::OPC_FilterValue, 210, 1, 9, 0, 0, // Skip to: 7898
/* 7889 */    MCD::OPC_CheckPredicate, 0, 250, 62, 0, // Skip to: 24016
/* 7894 */    MCD::OPC_Decode, 235, 2, 94, // Opcode: AMSWAP__DB_W
/* 7898 */    MCD::OPC_FilterValue, 211, 1, 9, 0, 0, // Skip to: 7913
/* 7904 */    MCD::OPC_CheckPredicate, 0, 235, 62, 0, // Skip to: 24016
/* 7909 */    MCD::OPC_Decode, 234, 2, 94, // Opcode: AMSWAP__DB_D
/* 7913 */    MCD::OPC_FilterValue, 212, 1, 9, 0, 0, // Skip to: 7928
/* 7919 */    MCD::OPC_CheckPredicate, 0, 220, 62, 0, // Skip to: 24016
/* 7924 */    MCD::OPC_Decode, 207, 2, 94, // Opcode: AMADD__DB_W
/* 7928 */    MCD::OPC_FilterValue, 213, 1, 9, 0, 0, // Skip to: 7943
/* 7934 */    MCD::OPC_CheckPredicate, 0, 205, 62, 0, // Skip to: 24016
/* 7939 */    MCD::OPC_Decode, 206, 2, 94, // Opcode: AMADD__DB_D
/* 7943 */    MCD::OPC_FilterValue, 214, 1, 9, 0, 0, // Skip to: 7958
/* 7949 */    MCD::OPC_CheckPredicate, 0, 190, 62, 0, // Skip to: 24016
/* 7954 */    MCD::OPC_Decode, 211, 2, 94, // Opcode: AMAND__DB_W
/* 7958 */    MCD::OPC_FilterValue, 215, 1, 9, 0, 0, // Skip to: 7973
/* 7964 */    MCD::OPC_CheckPredicate, 0, 175, 62, 0, // Skip to: 24016
/* 7969 */    MCD::OPC_Decode, 210, 2, 94, // Opcode: AMAND__DB_D
/* 7973 */    MCD::OPC_FilterValue, 216, 1, 9, 0, 0, // Skip to: 7988
/* 7979 */    MCD::OPC_CheckPredicate, 0, 160, 62, 0, // Skip to: 24016
/* 7984 */    MCD::OPC_Decode, 231, 2, 94, // Opcode: AMOR__DB_W
/* 7988 */    MCD::OPC_FilterValue, 217, 1, 9, 0, 0, // Skip to: 8003
/* 7994 */    MCD::OPC_CheckPredicate, 0, 145, 62, 0, // Skip to: 24016
/* 7999 */    MCD::OPC_Decode, 230, 2, 94, // Opcode: AMOR__DB_D
/* 8003 */    MCD::OPC_FilterValue, 218, 1, 9, 0, 0, // Skip to: 8018
/* 8009 */    MCD::OPC_CheckPredicate, 0, 130, 62, 0, // Skip to: 24016
/* 8014 */    MCD::OPC_Decode, 239, 2, 94, // Opcode: AMXOR__DB_W
/* 8018 */    MCD::OPC_FilterValue, 219, 1, 9, 0, 0, // Skip to: 8033
/* 8024 */    MCD::OPC_CheckPredicate, 0, 115, 62, 0, // Skip to: 24016
/* 8029 */    MCD::OPC_Decode, 238, 2, 94, // Opcode: AMXOR__DB_D
/* 8033 */    MCD::OPC_FilterValue, 220, 1, 9, 0, 0, // Skip to: 8048
/* 8039 */    MCD::OPC_CheckPredicate, 0, 100, 62, 0, // Skip to: 24016
/* 8044 */    MCD::OPC_Decode, 218, 2, 94, // Opcode: AMMAX__DB_W
/* 8048 */    MCD::OPC_FilterValue, 221, 1, 9, 0, 0, // Skip to: 8063
/* 8054 */    MCD::OPC_CheckPredicate, 0, 85, 62, 0, // Skip to: 24016
/* 8059 */    MCD::OPC_Decode, 216, 2, 94, // Opcode: AMMAX__DB_D
/* 8063 */    MCD::OPC_FilterValue, 222, 1, 9, 0, 0, // Skip to: 8078
/* 8069 */    MCD::OPC_CheckPredicate, 0, 70, 62, 0, // Skip to: 24016
/* 8074 */    MCD::OPC_Decode, 226, 2, 94, // Opcode: AMMIN__DB_W
/* 8078 */    MCD::OPC_FilterValue, 223, 1, 9, 0, 0, // Skip to: 8093
/* 8084 */    MCD::OPC_CheckPredicate, 0, 55, 62, 0, // Skip to: 24016
/* 8089 */    MCD::OPC_Decode, 224, 2, 94, // Opcode: AMMIN__DB_D
/* 8093 */    MCD::OPC_FilterValue, 224, 1, 9, 0, 0, // Skip to: 8108
/* 8099 */    MCD::OPC_CheckPredicate, 0, 40, 62, 0, // Skip to: 24016
/* 8104 */    MCD::OPC_Decode, 219, 2, 94, // Opcode: AMMAX__DB_WU
/* 8108 */    MCD::OPC_FilterValue, 225, 1, 9, 0, 0, // Skip to: 8123
/* 8114 */    MCD::OPC_CheckPredicate, 0, 25, 62, 0, // Skip to: 24016
/* 8119 */    MCD::OPC_Decode, 217, 2, 94, // Opcode: AMMAX__DB_DU
/* 8123 */    MCD::OPC_FilterValue, 226, 1, 9, 0, 0, // Skip to: 8138
/* 8129 */    MCD::OPC_CheckPredicate, 0, 10, 62, 0, // Skip to: 24016
/* 8134 */    MCD::OPC_Decode, 227, 2, 94, // Opcode: AMMIN__DB_WU
/* 8138 */    MCD::OPC_FilterValue, 227, 1, 9, 0, 0, // Skip to: 8153
/* 8144 */    MCD::OPC_CheckPredicate, 0, 251, 61, 0, // Skip to: 24016
/* 8149 */    MCD::OPC_Decode, 225, 2, 94, // Opcode: AMMIN__DB_DU
/* 8153 */    MCD::OPC_FilterValue, 228, 1, 4, 0, 0, // Skip to: 8163
/* 8159 */    MCD::OPC_Decode, 183, 3, 13, // Opcode: DBAR
/* 8163 */    MCD::OPC_FilterValue, 229, 1, 4, 0, 0, // Skip to: 8173
/* 8169 */    MCD::OPC_Decode, 206, 4, 13, // Opcode: IBAR
/* 8173 */    MCD::OPC_FilterValue, 232, 1, 4, 0, 0, // Skip to: 8183
/* 8179 */    MCD::OPC_Decode, 128, 4, 90, // Opcode: FLDGT_S
/* 8183 */    MCD::OPC_FilterValue, 233, 1, 4, 0, 0, // Skip to: 8193
/* 8189 */    MCD::OPC_Decode, 255, 3, 91, // Opcode: FLDGT_D
/* 8193 */    MCD::OPC_FilterValue, 234, 1, 4, 0, 0, // Skip to: 8203
/* 8199 */    MCD::OPC_Decode, 130, 4, 90, // Opcode: FLDLE_S
/* 8203 */    MCD::OPC_FilterValue, 235, 1, 4, 0, 0, // Skip to: 8213
/* 8209 */    MCD::OPC_Decode, 129, 4, 91, // Opcode: FLDLE_D
/* 8213 */    MCD::OPC_FilterValue, 236, 1, 4, 0, 0, // Skip to: 8223
/* 8219 */    MCD::OPC_Decode, 172, 4, 90, // Opcode: FSTGT_S
/* 8223 */    MCD::OPC_FilterValue, 237, 1, 4, 0, 0, // Skip to: 8233
/* 8229 */    MCD::OPC_Decode, 171, 4, 91, // Opcode: FSTGT_D
/* 8233 */    MCD::OPC_FilterValue, 238, 1, 4, 0, 0, // Skip to: 8243
/* 8239 */    MCD::OPC_Decode, 174, 4, 90, // Opcode: FSTLE_S
/* 8243 */    MCD::OPC_FilterValue, 239, 1, 4, 0, 0, // Skip to: 8253
/* 8249 */    MCD::OPC_Decode, 173, 4, 91, // Opcode: FSTLE_D
/* 8253 */    MCD::OPC_FilterValue, 240, 1, 9, 0, 0, // Skip to: 8268
/* 8259 */    MCD::OPC_CheckPredicate, 0, 136, 61, 0, // Skip to: 24016
/* 8264 */    MCD::OPC_Decode, 221, 4, 11, // Opcode: LDGT_B
/* 8268 */    MCD::OPC_FilterValue, 241, 1, 9, 0, 0, // Skip to: 8283
/* 8274 */    MCD::OPC_CheckPredicate, 0, 121, 61, 0, // Skip to: 24016
/* 8279 */    MCD::OPC_Decode, 223, 4, 11, // Opcode: LDGT_H
/* 8283 */    MCD::OPC_FilterValue, 242, 1, 9, 0, 0, // Skip to: 8298
/* 8289 */    MCD::OPC_CheckPredicate, 0, 106, 61, 0, // Skip to: 24016
/* 8294 */    MCD::OPC_Decode, 224, 4, 11, // Opcode: LDGT_W
/* 8298 */    MCD::OPC_FilterValue, 243, 1, 9, 0, 0, // Skip to: 8313
/* 8304 */    MCD::OPC_CheckPredicate, 0, 91, 61, 0, // Skip to: 24016
/* 8309 */    MCD::OPC_Decode, 222, 4, 11, // Opcode: LDGT_D
/* 8313 */    MCD::OPC_FilterValue, 244, 1, 9, 0, 0, // Skip to: 8328
/* 8319 */    MCD::OPC_CheckPredicate, 0, 76, 61, 0, // Skip to: 24016
/* 8324 */    MCD::OPC_Decode, 225, 4, 11, // Opcode: LDLE_B
/* 8328 */    MCD::OPC_FilterValue, 245, 1, 9, 0, 0, // Skip to: 8343
/* 8334 */    MCD::OPC_CheckPredicate, 0, 61, 61, 0, // Skip to: 24016
/* 8339 */    MCD::OPC_Decode, 227, 4, 11, // Opcode: LDLE_H
/* 8343 */    MCD::OPC_FilterValue, 246, 1, 9, 0, 0, // Skip to: 8358
/* 8349 */    MCD::OPC_CheckPredicate, 0, 46, 61, 0, // Skip to: 24016
/* 8354 */    MCD::OPC_Decode, 228, 4, 11, // Opcode: LDLE_W
/* 8358 */    MCD::OPC_FilterValue, 247, 1, 9, 0, 0, // Skip to: 8373
/* 8364 */    MCD::OPC_CheckPredicate, 0, 31, 61, 0, // Skip to: 24016
/* 8369 */    MCD::OPC_Decode, 226, 4, 11, // Opcode: LDLE_D
/* 8373 */    MCD::OPC_FilterValue, 248, 1, 9, 0, 0, // Skip to: 8388
/* 8379 */    MCD::OPC_CheckPredicate, 0, 16, 61, 0, // Skip to: 24016
/* 8384 */    MCD::OPC_Decode, 220, 5, 11, // Opcode: STGT_B
/* 8388 */    MCD::OPC_FilterValue, 249, 1, 9, 0, 0, // Skip to: 8403
/* 8394 */    MCD::OPC_CheckPredicate, 0, 1, 61, 0, // Skip to: 24016
/* 8399 */    MCD::OPC_Decode, 222, 5, 11, // Opcode: STGT_H
/* 8403 */    MCD::OPC_FilterValue, 250, 1, 9, 0, 0, // Skip to: 8418
/* 8409 */    MCD::OPC_CheckPredicate, 0, 242, 60, 0, // Skip to: 24016
/* 8414 */    MCD::OPC_Decode, 223, 5, 11, // Opcode: STGT_W
/* 8418 */    MCD::OPC_FilterValue, 251, 1, 9, 0, 0, // Skip to: 8433
/* 8424 */    MCD::OPC_CheckPredicate, 0, 227, 60, 0, // Skip to: 24016
/* 8429 */    MCD::OPC_Decode, 221, 5, 11, // Opcode: STGT_D
/* 8433 */    MCD::OPC_FilterValue, 252, 1, 9, 0, 0, // Skip to: 8448
/* 8439 */    MCD::OPC_CheckPredicate, 0, 212, 60, 0, // Skip to: 24016
/* 8444 */    MCD::OPC_Decode, 224, 5, 11, // Opcode: STLE_B
/* 8448 */    MCD::OPC_FilterValue, 253, 1, 9, 0, 0, // Skip to: 8463
/* 8454 */    MCD::OPC_CheckPredicate, 0, 197, 60, 0, // Skip to: 24016
/* 8459 */    MCD::OPC_Decode, 226, 5, 11, // Opcode: STLE_H
/* 8463 */    MCD::OPC_FilterValue, 254, 1, 9, 0, 0, // Skip to: 8478
/* 8469 */    MCD::OPC_CheckPredicate, 0, 182, 60, 0, // Skip to: 24016
/* 8474 */    MCD::OPC_Decode, 227, 5, 11, // Opcode: STLE_W
/* 8478 */    MCD::OPC_FilterValue, 255, 1, 172, 60, 0, // Skip to: 24016
/* 8484 */    MCD::OPC_CheckPredicate, 0, 167, 60, 0, // Skip to: 24016
/* 8489 */    MCD::OPC_Decode, 225, 5, 11, // Opcode: STLE_D
/* 8493 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 8502
/* 8498 */    MCD::OPC_Decode, 143, 3, 95, // Opcode: BEQZ
/* 8502 */    MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 8511
/* 8507 */    MCD::OPC_Decode, 154, 3, 95, // Opcode: BNEZ
/* 8511 */    MCD::OPC_FilterValue, 18, 53, 0, 0, // Skip to: 8569
/* 8516 */    MCD::OPC_ExtractField, 8, 2,  // Inst{9-8} ...
/* 8519 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 8528
/* 8524 */    MCD::OPC_Decode, 140, 3, 96, // Opcode: BCEQZ
/* 8528 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 8537
/* 8533 */    MCD::OPC_Decode, 141, 3, 96, // Opcode: BCNEZ
/* 8537 */    MCD::OPC_FilterValue, 2, 11, 0, 0, // Skip to: 8553
/* 8542 */    MCD::OPC_CheckField, 5, 3, 0, 107, 60, 0, // Skip to: 24016
/* 8549 */    MCD::OPC_Decode, 218, 4, 97, // Opcode: JISCR0
/* 8553 */    MCD::OPC_FilterValue, 3, 98, 60, 0, // Skip to: 24016
/* 8558 */    MCD::OPC_CheckField, 5, 3, 0, 91, 60, 0, // Skip to: 24016
/* 8565 */    MCD::OPC_Decode, 219, 4, 97, // Opcode: JISCR1
/* 8569 */    MCD::OPC_FilterValue, 19, 4, 0, 0, // Skip to: 8578
/* 8574 */    MCD::OPC_Decode, 217, 4, 98, // Opcode: JIRL
/* 8578 */    MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 8587
/* 8583 */    MCD::OPC_Decode, 139, 3, 99, // Opcode: B
/* 8587 */    MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 8596
/* 8592 */    MCD::OPC_Decode, 150, 3, 99, // Opcode: BL
/* 8596 */    MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 8605
/* 8601 */    MCD::OPC_Decode, 142, 3, 100, // Opcode: BEQ
/* 8605 */    MCD::OPC_FilterValue, 23, 4, 0, 0, // Skip to: 8614
/* 8610 */    MCD::OPC_Decode, 153, 3, 100, // Opcode: BNE
/* 8614 */    MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 8623
/* 8619 */    MCD::OPC_Decode, 151, 3, 100, // Opcode: BLT
/* 8623 */    MCD::OPC_FilterValue, 25, 4, 0, 0, // Skip to: 8632
/* 8628 */    MCD::OPC_Decode, 144, 3, 100, // Opcode: BGE
/* 8632 */    MCD::OPC_FilterValue, 26, 4, 0, 0, // Skip to: 8641
/* 8637 */    MCD::OPC_Decode, 152, 3, 100, // Opcode: BLTU
/* 8641 */    MCD::OPC_FilterValue, 27, 4, 0, 0, // Skip to: 8650
/* 8646 */    MCD::OPC_Decode, 145, 3, 100, // Opcode: BGEU
/* 8650 */    MCD::OPC_FilterValue, 28, 246, 28, 0, // Skip to: 16069
/* 8655 */    MCD::OPC_ExtractField, 18, 8,  // Inst{25-18} ...
/* 8658 */    MCD::OPC_FilterValue, 0, 75, 0, 0, // Skip to: 8738
/* 8663 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8666 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 8675
/* 8671 */    MCD::OPC_Decode, 234, 9, 63, // Opcode: VSEQ_B
/* 8675 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 8684
/* 8680 */    MCD::OPC_Decode, 236, 9, 63, // Opcode: VSEQ_H
/* 8684 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 8693
/* 8689 */    MCD::OPC_Decode, 237, 9, 63, // Opcode: VSEQ_W
/* 8693 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 8702
/* 8698 */    MCD::OPC_Decode, 235, 9, 63, // Opcode: VSEQ_D
/* 8702 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 8711
/* 8707 */    MCD::OPC_Decode, 140, 10, 63, // Opcode: VSLE_B
/* 8711 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 8720
/* 8716 */    MCD::OPC_Decode, 144, 10, 63, // Opcode: VSLE_H
/* 8720 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 8729
/* 8725 */    MCD::OPC_Decode, 146, 10, 63, // Opcode: VSLE_W
/* 8729 */    MCD::OPC_FilterValue, 7, 178, 59, 0, // Skip to: 24016
/* 8734 */    MCD::OPC_Decode, 142, 10, 63, // Opcode: VSLE_D
/* 8738 */    MCD::OPC_FilterValue, 1, 75, 0, 0, // Skip to: 8818
/* 8743 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8746 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 8755
/* 8751 */    MCD::OPC_Decode, 141, 10, 63, // Opcode: VSLE_BU
/* 8755 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 8764
/* 8760 */    MCD::OPC_Decode, 145, 10, 63, // Opcode: VSLE_HU
/* 8764 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 8773
/* 8769 */    MCD::OPC_Decode, 147, 10, 63, // Opcode: VSLE_WU
/* 8773 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 8782
/* 8778 */    MCD::OPC_Decode, 143, 10, 63, // Opcode: VSLE_DU
/* 8782 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 8791
/* 8787 */    MCD::OPC_Decode, 170, 10, 63, // Opcode: VSLT_B
/* 8791 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 8800
/* 8796 */    MCD::OPC_Decode, 174, 10, 63, // Opcode: VSLT_H
/* 8800 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 8809
/* 8805 */    MCD::OPC_Decode, 176, 10, 63, // Opcode: VSLT_W
/* 8809 */    MCD::OPC_FilterValue, 7, 98, 59, 0, // Skip to: 24016
/* 8814 */    MCD::OPC_Decode, 172, 10, 63, // Opcode: VSLT_D
/* 8818 */    MCD::OPC_FilterValue, 2, 75, 0, 0, // Skip to: 8898
/* 8823 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8826 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 8835
/* 8831 */    MCD::OPC_Decode, 171, 10, 63, // Opcode: VSLT_BU
/* 8835 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 8844
/* 8840 */    MCD::OPC_Decode, 175, 10, 63, // Opcode: VSLT_HU
/* 8844 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 8853
/* 8849 */    MCD::OPC_Decode, 177, 10, 63, // Opcode: VSLT_WU
/* 8853 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 8862
/* 8858 */    MCD::OPC_Decode, 173, 10, 63, // Opcode: VSLT_DU
/* 8862 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 8871
/* 8867 */    MCD::OPC_Decode, 163, 6, 63, // Opcode: VADD_B
/* 8871 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 8880
/* 8876 */    MCD::OPC_Decode, 165, 6, 63, // Opcode: VADD_H
/* 8880 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 8889
/* 8885 */    MCD::OPC_Decode, 167, 6, 63, // Opcode: VADD_W
/* 8889 */    MCD::OPC_FilterValue, 7, 18, 59, 0, // Skip to: 24016
/* 8894 */    MCD::OPC_Decode, 164, 6, 63, // Opcode: VADD_D
/* 8898 */    MCD::OPC_FilterValue, 3, 39, 0, 0, // Skip to: 8942
/* 8903 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8906 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 8915
/* 8911 */    MCD::OPC_Decode, 200, 11, 63, // Opcode: VSUB_B
/* 8915 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 8924
/* 8920 */    MCD::OPC_Decode, 202, 11, 63, // Opcode: VSUB_H
/* 8924 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 8933
/* 8929 */    MCD::OPC_Decode, 204, 11, 63, // Opcode: VSUB_W
/* 8933 */    MCD::OPC_FilterValue, 3, 230, 58, 0, // Skip to: 24016
/* 8938 */    MCD::OPC_Decode, 201, 11, 63, // Opcode: VSUB_D
/* 8942 */    MCD::OPC_FilterValue, 7, 39, 0, 0, // Skip to: 8986
/* 8947 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8950 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 8959
/* 8955 */    MCD::OPC_Decode, 142, 6, 63, // Opcode: VADDWEV_H_B
/* 8959 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 8968
/* 8964 */    MCD::OPC_Decode, 148, 6, 63, // Opcode: VADDWEV_W_H
/* 8968 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 8977
/* 8973 */    MCD::OPC_Decode, 139, 6, 63, // Opcode: VADDWEV_D_W
/* 8977 */    MCD::OPC_FilterValue, 7, 186, 58, 0, // Skip to: 24016
/* 8982 */    MCD::OPC_Decode, 145, 6, 63, // Opcode: VADDWEV_Q_D
/* 8986 */    MCD::OPC_FilterValue, 8, 75, 0, 0, // Skip to: 9066
/* 8991 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8994 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9003
/* 8999 */    MCD::OPC_Decode, 186, 11, 63, // Opcode: VSUBWEV_H_B
/* 9003 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9012
/* 9008 */    MCD::OPC_Decode, 190, 11, 63, // Opcode: VSUBWEV_W_H
/* 9012 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9021
/* 9017 */    MCD::OPC_Decode, 184, 11, 63, // Opcode: VSUBWEV_D_W
/* 9021 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9030
/* 9026 */    MCD::OPC_Decode, 188, 11, 63, // Opcode: VSUBWEV_Q_D
/* 9030 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9039
/* 9035 */    MCD::OPC_Decode, 154, 6, 63, // Opcode: VADDWOD_H_B
/* 9039 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9048
/* 9044 */    MCD::OPC_Decode, 160, 6, 63, // Opcode: VADDWOD_W_H
/* 9048 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9057
/* 9053 */    MCD::OPC_Decode, 151, 6, 63, // Opcode: VADDWOD_D_W
/* 9057 */    MCD::OPC_FilterValue, 7, 106, 58, 0, // Skip to: 24016
/* 9062 */    MCD::OPC_Decode, 157, 6, 63, // Opcode: VADDWOD_Q_D
/* 9066 */    MCD::OPC_FilterValue, 9, 39, 0, 0, // Skip to: 9110
/* 9071 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9074 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9083
/* 9079 */    MCD::OPC_Decode, 194, 11, 63, // Opcode: VSUBWOD_H_B
/* 9083 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9092
/* 9088 */    MCD::OPC_Decode, 198, 11, 63, // Opcode: VSUBWOD_W_H
/* 9092 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9101
/* 9097 */    MCD::OPC_Decode, 192, 11, 63, // Opcode: VSUBWOD_D_W
/* 9101 */    MCD::OPC_FilterValue, 3, 62, 58, 0, // Skip to: 24016
/* 9106 */    MCD::OPC_Decode, 196, 11, 63, // Opcode: VSUBWOD_Q_D
/* 9110 */    MCD::OPC_FilterValue, 11, 39, 0, 0, // Skip to: 9154
/* 9115 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9118 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9127
/* 9123 */    MCD::OPC_Decode, 143, 6, 63, // Opcode: VADDWEV_H_BU
/* 9127 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9136
/* 9132 */    MCD::OPC_Decode, 149, 6, 63, // Opcode: VADDWEV_W_HU
/* 9136 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9145
/* 9141 */    MCD::OPC_Decode, 140, 6, 63, // Opcode: VADDWEV_D_WU
/* 9145 */    MCD::OPC_FilterValue, 7, 18, 58, 0, // Skip to: 24016
/* 9150 */    MCD::OPC_Decode, 146, 6, 63, // Opcode: VADDWEV_Q_DU
/* 9154 */    MCD::OPC_FilterValue, 12, 75, 0, 0, // Skip to: 9234
/* 9159 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9162 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9171
/* 9167 */    MCD::OPC_Decode, 187, 11, 63, // Opcode: VSUBWEV_H_BU
/* 9171 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9180
/* 9176 */    MCD::OPC_Decode, 191, 11, 63, // Opcode: VSUBWEV_W_HU
/* 9180 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9189
/* 9185 */    MCD::OPC_Decode, 185, 11, 63, // Opcode: VSUBWEV_D_WU
/* 9189 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9198
/* 9194 */    MCD::OPC_Decode, 189, 11, 63, // Opcode: VSUBWEV_Q_DU
/* 9198 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9207
/* 9203 */    MCD::OPC_Decode, 155, 6, 63, // Opcode: VADDWOD_H_BU
/* 9207 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9216
/* 9212 */    MCD::OPC_Decode, 161, 6, 63, // Opcode: VADDWOD_W_HU
/* 9216 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9225
/* 9221 */    MCD::OPC_Decode, 152, 6, 63, // Opcode: VADDWOD_D_WU
/* 9225 */    MCD::OPC_FilterValue, 7, 194, 57, 0, // Skip to: 24016
/* 9230 */    MCD::OPC_Decode, 158, 6, 63, // Opcode: VADDWOD_Q_DU
/* 9234 */    MCD::OPC_FilterValue, 13, 39, 0, 0, // Skip to: 9278
/* 9239 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9242 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9251
/* 9247 */    MCD::OPC_Decode, 195, 11, 63, // Opcode: VSUBWOD_H_BU
/* 9251 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9260
/* 9256 */    MCD::OPC_Decode, 199, 11, 63, // Opcode: VSUBWOD_W_HU
/* 9260 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9269
/* 9265 */    MCD::OPC_Decode, 193, 11, 63, // Opcode: VSUBWOD_D_WU
/* 9269 */    MCD::OPC_FilterValue, 3, 150, 57, 0, // Skip to: 24016
/* 9274 */    MCD::OPC_Decode, 197, 11, 63, // Opcode: VSUBWOD_Q_DU
/* 9278 */    MCD::OPC_FilterValue, 15, 39, 0, 0, // Skip to: 9322
/* 9283 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9286 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9295
/* 9291 */    MCD::OPC_Decode, 144, 6, 63, // Opcode: VADDWEV_H_BU_B
/* 9295 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9304
/* 9300 */    MCD::OPC_Decode, 150, 6, 63, // Opcode: VADDWEV_W_HU_H
/* 9304 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9313
/* 9309 */    MCD::OPC_Decode, 141, 6, 63, // Opcode: VADDWEV_D_WU_W
/* 9313 */    MCD::OPC_FilterValue, 7, 106, 57, 0, // Skip to: 24016
/* 9318 */    MCD::OPC_Decode, 147, 6, 63, // Opcode: VADDWEV_Q_DU_D
/* 9322 */    MCD::OPC_FilterValue, 16, 39, 0, 0, // Skip to: 9366
/* 9327 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9330 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9339
/* 9335 */    MCD::OPC_Decode, 156, 6, 63, // Opcode: VADDWOD_H_BU_B
/* 9339 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9348
/* 9344 */    MCD::OPC_Decode, 162, 6, 63, // Opcode: VADDWOD_W_HU_H
/* 9348 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9357
/* 9353 */    MCD::OPC_Decode, 153, 6, 63, // Opcode: VADDWOD_D_WU_W
/* 9357 */    MCD::OPC_FilterValue, 3, 62, 57, 0, // Skip to: 24016
/* 9362 */    MCD::OPC_Decode, 159, 6, 63, // Opcode: VADDWOD_Q_DU_D
/* 9366 */    MCD::OPC_FilterValue, 17, 39, 0, 0, // Skip to: 9410
/* 9371 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9374 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9383
/* 9379 */    MCD::OPC_Decode, 214, 9, 63, // Opcode: VSADD_B
/* 9383 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9392
/* 9388 */    MCD::OPC_Decode, 218, 9, 63, // Opcode: VSADD_H
/* 9392 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9401
/* 9397 */    MCD::OPC_Decode, 220, 9, 63, // Opcode: VSADD_W
/* 9401 */    MCD::OPC_FilterValue, 7, 18, 57, 0, // Skip to: 24016
/* 9406 */    MCD::OPC_Decode, 216, 9, 63, // Opcode: VSADD_D
/* 9410 */    MCD::OPC_FilterValue, 18, 75, 0, 0, // Skip to: 9490
/* 9415 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9418 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9427
/* 9423 */    MCD::OPC_Decode, 166, 11, 63, // Opcode: VSSUB_B
/* 9427 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9436
/* 9432 */    MCD::OPC_Decode, 170, 11, 63, // Opcode: VSSUB_H
/* 9436 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9445
/* 9441 */    MCD::OPC_Decode, 172, 11, 63, // Opcode: VSSUB_W
/* 9445 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9454
/* 9450 */    MCD::OPC_Decode, 168, 11, 63, // Opcode: VSSUB_D
/* 9454 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9463
/* 9459 */    MCD::OPC_Decode, 215, 9, 63, // Opcode: VSADD_BU
/* 9463 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9472
/* 9468 */    MCD::OPC_Decode, 219, 9, 63, // Opcode: VSADD_HU
/* 9472 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9481
/* 9477 */    MCD::OPC_Decode, 221, 9, 63, // Opcode: VSADD_WU
/* 9481 */    MCD::OPC_FilterValue, 7, 194, 56, 0, // Skip to: 24016
/* 9486 */    MCD::OPC_Decode, 217, 9, 63, // Opcode: VSADD_DU
/* 9490 */    MCD::OPC_FilterValue, 19, 39, 0, 0, // Skip to: 9534
/* 9495 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9498 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9507
/* 9503 */    MCD::OPC_Decode, 167, 11, 63, // Opcode: VSSUB_BU
/* 9507 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9516
/* 9512 */    MCD::OPC_Decode, 171, 11, 63, // Opcode: VSSUB_HU
/* 9516 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9525
/* 9521 */    MCD::OPC_Decode, 173, 11, 63, // Opcode: VSSUB_WU
/* 9525 */    MCD::OPC_FilterValue, 3, 150, 56, 0, // Skip to: 24016
/* 9530 */    MCD::OPC_Decode, 169, 11, 63, // Opcode: VSSUB_DU
/* 9534 */    MCD::OPC_FilterValue, 21, 75, 0, 0, // Skip to: 9614
/* 9539 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9542 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9551
/* 9547 */    MCD::OPC_Decode, 138, 8, 63, // Opcode: VHADDW_H_B
/* 9551 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9560
/* 9556 */    MCD::OPC_Decode, 142, 8, 63, // Opcode: VHADDW_W_H
/* 9560 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9569
/* 9565 */    MCD::OPC_Decode, 136, 8, 63, // Opcode: VHADDW_D_W
/* 9569 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9578
/* 9574 */    MCD::OPC_Decode, 140, 8, 63, // Opcode: VHADDW_Q_D
/* 9578 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9587
/* 9583 */    MCD::OPC_Decode, 146, 8, 63, // Opcode: VHSUBW_H_B
/* 9587 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9596
/* 9592 */    MCD::OPC_Decode, 150, 8, 63, // Opcode: VHSUBW_W_H
/* 9596 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9605
/* 9601 */    MCD::OPC_Decode, 144, 8, 63, // Opcode: VHSUBW_D_W
/* 9605 */    MCD::OPC_FilterValue, 7, 70, 56, 0, // Skip to: 24016
/* 9610 */    MCD::OPC_Decode, 148, 8, 63, // Opcode: VHSUBW_Q_D
/* 9614 */    MCD::OPC_FilterValue, 22, 75, 0, 0, // Skip to: 9694
/* 9619 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9622 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9631
/* 9627 */    MCD::OPC_Decode, 137, 8, 63, // Opcode: VHADDW_HU_BU
/* 9631 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9640
/* 9636 */    MCD::OPC_Decode, 141, 8, 63, // Opcode: VHADDW_WU_HU
/* 9640 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9649
/* 9645 */    MCD::OPC_Decode, 135, 8, 63, // Opcode: VHADDW_DU_WU
/* 9649 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9658
/* 9654 */    MCD::OPC_Decode, 139, 8, 63, // Opcode: VHADDW_QU_DU
/* 9658 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9667
/* 9663 */    MCD::OPC_Decode, 145, 8, 63, // Opcode: VHSUBW_HU_BU
/* 9667 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9676
/* 9672 */    MCD::OPC_Decode, 149, 8, 63, // Opcode: VHSUBW_WU_HU
/* 9676 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9685
/* 9681 */    MCD::OPC_Decode, 143, 8, 63, // Opcode: VHSUBW_DU_WU
/* 9685 */    MCD::OPC_FilterValue, 7, 246, 55, 0, // Skip to: 24016
/* 9690 */    MCD::OPC_Decode, 147, 8, 63, // Opcode: VHSUBW_QU_DU
/* 9694 */    MCD::OPC_FilterValue, 23, 39, 0, 0, // Skip to: 9738
/* 9699 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9702 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9711
/* 9707 */    MCD::OPC_Decode, 131, 6, 63, // Opcode: VADDA_B
/* 9711 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9720
/* 9716 */    MCD::OPC_Decode, 133, 6, 63, // Opcode: VADDA_H
/* 9720 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9729
/* 9725 */    MCD::OPC_Decode, 134, 6, 63, // Opcode: VADDA_W
/* 9729 */    MCD::OPC_FilterValue, 3, 202, 55, 0, // Skip to: 24016
/* 9734 */    MCD::OPC_Decode, 132, 6, 63, // Opcode: VADDA_D
/* 9738 */    MCD::OPC_FilterValue, 24, 75, 0, 0, // Skip to: 9818
/* 9743 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9746 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9755
/* 9751 */    MCD::OPC_Decode, 251, 5, 63, // Opcode: VABSD_B
/* 9755 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9764
/* 9760 */    MCD::OPC_Decode, 255, 5, 63, // Opcode: VABSD_H
/* 9764 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9773
/* 9769 */    MCD::OPC_Decode, 129, 6, 63, // Opcode: VABSD_W
/* 9773 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9782
/* 9778 */    MCD::OPC_Decode, 253, 5, 63, // Opcode: VABSD_D
/* 9782 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9791
/* 9787 */    MCD::OPC_Decode, 252, 5, 63, // Opcode: VABSD_BU
/* 9791 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9800
/* 9796 */    MCD::OPC_Decode, 128, 6, 63, // Opcode: VABSD_HU
/* 9800 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9809
/* 9805 */    MCD::OPC_Decode, 130, 6, 63, // Opcode: VABSD_WU
/* 9809 */    MCD::OPC_FilterValue, 7, 122, 55, 0, // Skip to: 24016
/* 9814 */    MCD::OPC_Decode, 254, 5, 63, // Opcode: VABSD_DU
/* 9818 */    MCD::OPC_FilterValue, 25, 75, 0, 0, // Skip to: 9898
/* 9823 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9826 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9835
/* 9831 */    MCD::OPC_Decode, 179, 6, 63, // Opcode: VAVG_B
/* 9835 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9844
/* 9840 */    MCD::OPC_Decode, 183, 6, 63, // Opcode: VAVG_H
/* 9844 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9853
/* 9849 */    MCD::OPC_Decode, 185, 6, 63, // Opcode: VAVG_W
/* 9853 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9862
/* 9858 */    MCD::OPC_Decode, 181, 6, 63, // Opcode: VAVG_D
/* 9862 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9871
/* 9867 */    MCD::OPC_Decode, 180, 6, 63, // Opcode: VAVG_BU
/* 9871 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9880
/* 9876 */    MCD::OPC_Decode, 184, 6, 63, // Opcode: VAVG_HU
/* 9880 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9889
/* 9885 */    MCD::OPC_Decode, 186, 6, 63, // Opcode: VAVG_WU
/* 9889 */    MCD::OPC_FilterValue, 7, 42, 55, 0, // Skip to: 24016
/* 9894 */    MCD::OPC_Decode, 182, 6, 63, // Opcode: VAVG_DU
/* 9898 */    MCD::OPC_FilterValue, 26, 75, 0, 0, // Skip to: 9978
/* 9903 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9906 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9915
/* 9911 */    MCD::OPC_Decode, 171, 6, 63, // Opcode: VAVGR_B
/* 9915 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 9924
/* 9920 */    MCD::OPC_Decode, 175, 6, 63, // Opcode: VAVGR_H
/* 9924 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 9933
/* 9929 */    MCD::OPC_Decode, 177, 6, 63, // Opcode: VAVGR_W
/* 9933 */    MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 9942
/* 9938 */    MCD::OPC_Decode, 173, 6, 63, // Opcode: VAVGR_D
/* 9942 */    MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 9951
/* 9947 */    MCD::OPC_Decode, 172, 6, 63, // Opcode: VAVGR_BU
/* 9951 */    MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 9960
/* 9956 */    MCD::OPC_Decode, 176, 6, 63, // Opcode: VAVGR_HU
/* 9960 */    MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 9969
/* 9965 */    MCD::OPC_Decode, 178, 6, 63, // Opcode: VAVGR_WU
/* 9969 */    MCD::OPC_FilterValue, 7, 218, 54, 0, // Skip to: 24016
/* 9974 */    MCD::OPC_Decode, 174, 6, 63, // Opcode: VAVGR_DU
/* 9978 */    MCD::OPC_FilterValue, 28, 75, 0, 0, // Skip to: 10058
/* 9983 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9986 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 9995
/* 9991 */    MCD::OPC_Decode, 206, 8, 63, // Opcode: VMAX_B
/* 9995 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10004
/* 10000 */   MCD::OPC_Decode, 210, 8, 63, // Opcode: VMAX_H
/* 10004 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10013
/* 10009 */   MCD::OPC_Decode, 212, 8, 63, // Opcode: VMAX_W
/* 10013 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10022
/* 10018 */   MCD::OPC_Decode, 208, 8, 63, // Opcode: VMAX_D
/* 10022 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10031
/* 10027 */   MCD::OPC_Decode, 222, 8, 63, // Opcode: VMIN_B
/* 10031 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10040
/* 10036 */   MCD::OPC_Decode, 226, 8, 63, // Opcode: VMIN_H
/* 10040 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10049
/* 10045 */   MCD::OPC_Decode, 228, 8, 63, // Opcode: VMIN_W
/* 10049 */   MCD::OPC_FilterValue, 7, 138, 54, 0, // Skip to: 24016
/* 10054 */   MCD::OPC_Decode, 224, 8, 63, // Opcode: VMIN_D
/* 10058 */   MCD::OPC_FilterValue, 29, 75, 0, 0, // Skip to: 10138
/* 10063 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10066 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10075
/* 10071 */   MCD::OPC_Decode, 207, 8, 63, // Opcode: VMAX_BU
/* 10075 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10084
/* 10080 */   MCD::OPC_Decode, 211, 8, 63, // Opcode: VMAX_HU
/* 10084 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10093
/* 10089 */   MCD::OPC_Decode, 213, 8, 63, // Opcode: VMAX_WU
/* 10093 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10102
/* 10098 */   MCD::OPC_Decode, 209, 8, 63, // Opcode: VMAX_DU
/* 10102 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10111
/* 10107 */   MCD::OPC_Decode, 223, 8, 63, // Opcode: VMIN_BU
/* 10111 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10120
/* 10116 */   MCD::OPC_Decode, 227, 8, 63, // Opcode: VMIN_HU
/* 10120 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10129
/* 10125 */   MCD::OPC_Decode, 229, 8, 63, // Opcode: VMIN_WU
/* 10129 */   MCD::OPC_FilterValue, 7, 58, 54, 0, // Skip to: 24016
/* 10134 */   MCD::OPC_Decode, 225, 8, 63, // Opcode: VMIN_DU
/* 10138 */   MCD::OPC_FilterValue, 33, 75, 0, 0, // Skip to: 10218
/* 10143 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10146 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10155
/* 10151 */   MCD::OPC_Decode, 152, 9, 63, // Opcode: VMUL_B
/* 10155 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10164
/* 10160 */   MCD::OPC_Decode, 154, 9, 63, // Opcode: VMUL_H
/* 10164 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10173
/* 10169 */   MCD::OPC_Decode, 155, 9, 63, // Opcode: VMUL_W
/* 10173 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10182
/* 10178 */   MCD::OPC_Decode, 153, 9, 63, // Opcode: VMUL_D
/* 10182 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10191
/* 10187 */   MCD::OPC_Decode, 248, 8, 63, // Opcode: VMUH_B
/* 10191 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10200
/* 10196 */   MCD::OPC_Decode, 252, 8, 63, // Opcode: VMUH_H
/* 10200 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10209
/* 10205 */   MCD::OPC_Decode, 254, 8, 63, // Opcode: VMUH_W
/* 10209 */   MCD::OPC_FilterValue, 7, 234, 53, 0, // Skip to: 24016
/* 10214 */   MCD::OPC_Decode, 250, 8, 63, // Opcode: VMUH_D
/* 10218 */   MCD::OPC_FilterValue, 34, 39, 0, 0, // Skip to: 10262
/* 10223 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10226 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10235
/* 10231 */   MCD::OPC_Decode, 249, 8, 63, // Opcode: VMUH_BU
/* 10235 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10244
/* 10240 */   MCD::OPC_Decode, 253, 8, 63, // Opcode: VMUH_HU
/* 10244 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10253
/* 10249 */   MCD::OPC_Decode, 255, 8, 63, // Opcode: VMUH_WU
/* 10253 */   MCD::OPC_FilterValue, 3, 190, 53, 0, // Skip to: 24016
/* 10258 */   MCD::OPC_Decode, 251, 8, 63, // Opcode: VMUH_DU
/* 10262 */   MCD::OPC_FilterValue, 36, 75, 0, 0, // Skip to: 10342
/* 10267 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10270 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10279
/* 10275 */   MCD::OPC_Decode, 131, 9, 63, // Opcode: VMULWEV_H_B
/* 10279 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10288
/* 10284 */   MCD::OPC_Decode, 137, 9, 63, // Opcode: VMULWEV_W_H
/* 10288 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10297
/* 10293 */   MCD::OPC_Decode, 128, 9, 63, // Opcode: VMULWEV_D_W
/* 10297 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10306
/* 10302 */   MCD::OPC_Decode, 134, 9, 63, // Opcode: VMULWEV_Q_D
/* 10306 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10315
/* 10311 */   MCD::OPC_Decode, 143, 9, 63, // Opcode: VMULWOD_H_B
/* 10315 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10324
/* 10320 */   MCD::OPC_Decode, 149, 9, 63, // Opcode: VMULWOD_W_H
/* 10324 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10333
/* 10329 */   MCD::OPC_Decode, 140, 9, 63, // Opcode: VMULWOD_D_W
/* 10333 */   MCD::OPC_FilterValue, 7, 110, 53, 0, // Skip to: 24016
/* 10338 */   MCD::OPC_Decode, 146, 9, 63, // Opcode: VMULWOD_Q_D
/* 10342 */   MCD::OPC_FilterValue, 38, 75, 0, 0, // Skip to: 10422
/* 10347 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10350 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10359
/* 10355 */   MCD::OPC_Decode, 132, 9, 63, // Opcode: VMULWEV_H_BU
/* 10359 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10368
/* 10364 */   MCD::OPC_Decode, 138, 9, 63, // Opcode: VMULWEV_W_HU
/* 10368 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10377
/* 10373 */   MCD::OPC_Decode, 129, 9, 63, // Opcode: VMULWEV_D_WU
/* 10377 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10386
/* 10382 */   MCD::OPC_Decode, 135, 9, 63, // Opcode: VMULWEV_Q_DU
/* 10386 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10395
/* 10391 */   MCD::OPC_Decode, 144, 9, 63, // Opcode: VMULWOD_H_BU
/* 10395 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10404
/* 10400 */   MCD::OPC_Decode, 150, 9, 63, // Opcode: VMULWOD_W_HU
/* 10404 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10413
/* 10409 */   MCD::OPC_Decode, 141, 9, 63, // Opcode: VMULWOD_D_WU
/* 10413 */   MCD::OPC_FilterValue, 7, 30, 53, 0, // Skip to: 24016
/* 10418 */   MCD::OPC_Decode, 147, 9, 63, // Opcode: VMULWOD_Q_DU
/* 10422 */   MCD::OPC_FilterValue, 40, 75, 0, 0, // Skip to: 10502
/* 10427 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10430 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10439
/* 10435 */   MCD::OPC_Decode, 133, 9, 63, // Opcode: VMULWEV_H_BU_B
/* 10439 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10448
/* 10444 */   MCD::OPC_Decode, 139, 9, 63, // Opcode: VMULWEV_W_HU_H
/* 10448 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10457
/* 10453 */   MCD::OPC_Decode, 130, 9, 63, // Opcode: VMULWEV_D_WU_W
/* 10457 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10466
/* 10462 */   MCD::OPC_Decode, 136, 9, 63, // Opcode: VMULWEV_Q_DU_D
/* 10466 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10475
/* 10471 */   MCD::OPC_Decode, 145, 9, 63, // Opcode: VMULWOD_H_BU_B
/* 10475 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10484
/* 10480 */   MCD::OPC_Decode, 151, 9, 63, // Opcode: VMULWOD_W_HU_H
/* 10484 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10493
/* 10489 */   MCD::OPC_Decode, 142, 9, 63, // Opcode: VMULWOD_D_WU_W
/* 10493 */   MCD::OPC_FilterValue, 7, 206, 52, 0, // Skip to: 24016
/* 10498 */   MCD::OPC_Decode, 148, 9, 63, // Opcode: VMULWOD_Q_DU_D
/* 10502 */   MCD::OPC_FilterValue, 42, 75, 0, 0, // Skip to: 10582
/* 10507 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10510 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10519
/* 10515 */   MCD::OPC_Decode, 194, 8, 101, // Opcode: VMADD_B
/* 10519 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10528
/* 10524 */   MCD::OPC_Decode, 196, 8, 101, // Opcode: VMADD_H
/* 10528 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10537
/* 10533 */   MCD::OPC_Decode, 197, 8, 101, // Opcode: VMADD_W
/* 10537 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10546
/* 10542 */   MCD::OPC_Decode, 195, 8, 101, // Opcode: VMADD_D
/* 10546 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10555
/* 10551 */   MCD::OPC_Decode, 244, 8, 101, // Opcode: VMSUB_B
/* 10555 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10564
/* 10560 */   MCD::OPC_Decode, 246, 8, 101, // Opcode: VMSUB_H
/* 10564 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10573
/* 10569 */   MCD::OPC_Decode, 247, 8, 101, // Opcode: VMSUB_W
/* 10573 */   MCD::OPC_FilterValue, 7, 126, 52, 0, // Skip to: 24016
/* 10578 */   MCD::OPC_Decode, 245, 8, 101, // Opcode: VMSUB_D
/* 10582 */   MCD::OPC_FilterValue, 43, 75, 0, 0, // Skip to: 10662
/* 10587 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10590 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10599
/* 10595 */   MCD::OPC_Decode, 173, 8, 101, // Opcode: VMADDWEV_H_B
/* 10599 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10608
/* 10604 */   MCD::OPC_Decode, 179, 8, 101, // Opcode: VMADDWEV_W_H
/* 10608 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10617
/* 10613 */   MCD::OPC_Decode, 170, 8, 101, // Opcode: VMADDWEV_D_W
/* 10617 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10626
/* 10622 */   MCD::OPC_Decode, 176, 8, 101, // Opcode: VMADDWEV_Q_D
/* 10626 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10635
/* 10631 */   MCD::OPC_Decode, 185, 8, 101, // Opcode: VMADDWOD_H_B
/* 10635 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10644
/* 10640 */   MCD::OPC_Decode, 191, 8, 101, // Opcode: VMADDWOD_W_H
/* 10644 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10653
/* 10649 */   MCD::OPC_Decode, 182, 8, 101, // Opcode: VMADDWOD_D_W
/* 10653 */   MCD::OPC_FilterValue, 7, 46, 52, 0, // Skip to: 24016
/* 10658 */   MCD::OPC_Decode, 188, 8, 101, // Opcode: VMADDWOD_Q_D
/* 10662 */   MCD::OPC_FilterValue, 45, 75, 0, 0, // Skip to: 10742
/* 10667 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10670 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10679
/* 10675 */   MCD::OPC_Decode, 174, 8, 101, // Opcode: VMADDWEV_H_BU
/* 10679 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10688
/* 10684 */   MCD::OPC_Decode, 180, 8, 101, // Opcode: VMADDWEV_W_HU
/* 10688 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10697
/* 10693 */   MCD::OPC_Decode, 171, 8, 101, // Opcode: VMADDWEV_D_WU
/* 10697 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10706
/* 10702 */   MCD::OPC_Decode, 177, 8, 101, // Opcode: VMADDWEV_Q_DU
/* 10706 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10715
/* 10711 */   MCD::OPC_Decode, 186, 8, 101, // Opcode: VMADDWOD_H_BU
/* 10715 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10724
/* 10720 */   MCD::OPC_Decode, 192, 8, 101, // Opcode: VMADDWOD_W_HU
/* 10724 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10733
/* 10729 */   MCD::OPC_Decode, 183, 8, 101, // Opcode: VMADDWOD_D_WU
/* 10733 */   MCD::OPC_FilterValue, 7, 222, 51, 0, // Skip to: 24016
/* 10738 */   MCD::OPC_Decode, 189, 8, 101, // Opcode: VMADDWOD_Q_DU
/* 10742 */   MCD::OPC_FilterValue, 47, 75, 0, 0, // Skip to: 10822
/* 10747 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10750 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10759
/* 10755 */   MCD::OPC_Decode, 175, 8, 101, // Opcode: VMADDWEV_H_BU_B
/* 10759 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10768
/* 10764 */   MCD::OPC_Decode, 181, 8, 101, // Opcode: VMADDWEV_W_HU_H
/* 10768 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10777
/* 10773 */   MCD::OPC_Decode, 172, 8, 101, // Opcode: VMADDWEV_D_WU_W
/* 10777 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10786
/* 10782 */   MCD::OPC_Decode, 178, 8, 101, // Opcode: VMADDWEV_Q_DU_D
/* 10786 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10795
/* 10791 */   MCD::OPC_Decode, 187, 8, 101, // Opcode: VMADDWOD_H_BU_B
/* 10795 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10804
/* 10800 */   MCD::OPC_Decode, 193, 8, 101, // Opcode: VMADDWOD_W_HU_H
/* 10804 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10813
/* 10809 */   MCD::OPC_Decode, 184, 8, 101, // Opcode: VMADDWOD_D_WU_W
/* 10813 */   MCD::OPC_FilterValue, 7, 142, 51, 0, // Skip to: 24016
/* 10818 */   MCD::OPC_Decode, 190, 8, 101, // Opcode: VMADDWOD_Q_DU_D
/* 10822 */   MCD::OPC_FilterValue, 56, 75, 0, 0, // Skip to: 10902
/* 10827 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10830 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10839
/* 10835 */   MCD::OPC_Decode, 223, 6, 63, // Opcode: VDIV_B
/* 10839 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10848
/* 10844 */   MCD::OPC_Decode, 227, 6, 63, // Opcode: VDIV_H
/* 10848 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10857
/* 10853 */   MCD::OPC_Decode, 229, 6, 63, // Opcode: VDIV_W
/* 10857 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10866
/* 10862 */   MCD::OPC_Decode, 225, 6, 63, // Opcode: VDIV_D
/* 10866 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10875
/* 10871 */   MCD::OPC_Decode, 230, 8, 63, // Opcode: VMOD_B
/* 10875 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10884
/* 10880 */   MCD::OPC_Decode, 234, 8, 63, // Opcode: VMOD_H
/* 10884 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10893
/* 10889 */   MCD::OPC_Decode, 236, 8, 63, // Opcode: VMOD_W
/* 10893 */   MCD::OPC_FilterValue, 7, 62, 51, 0, // Skip to: 24016
/* 10898 */   MCD::OPC_Decode, 232, 8, 63, // Opcode: VMOD_D
/* 10902 */   MCD::OPC_FilterValue, 57, 75, 0, 0, // Skip to: 10982
/* 10907 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10910 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10919
/* 10915 */   MCD::OPC_Decode, 224, 6, 63, // Opcode: VDIV_BU
/* 10919 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 10928
/* 10924 */   MCD::OPC_Decode, 228, 6, 63, // Opcode: VDIV_HU
/* 10928 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 10937
/* 10933 */   MCD::OPC_Decode, 230, 6, 63, // Opcode: VDIV_WU
/* 10937 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 10946
/* 10942 */   MCD::OPC_Decode, 226, 6, 63, // Opcode: VDIV_DU
/* 10946 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 10955
/* 10951 */   MCD::OPC_Decode, 231, 8, 63, // Opcode: VMOD_BU
/* 10955 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 10964
/* 10960 */   MCD::OPC_Decode, 235, 8, 63, // Opcode: VMOD_HU
/* 10964 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 10973
/* 10969 */   MCD::OPC_Decode, 237, 8, 63, // Opcode: VMOD_WU
/* 10973 */   MCD::OPC_FilterValue, 7, 238, 50, 0, // Skip to: 24016
/* 10978 */   MCD::OPC_Decode, 233, 8, 63, // Opcode: VMOD_DU
/* 10982 */   MCD::OPC_FilterValue, 58, 75, 0, 0, // Skip to: 11062
/* 10987 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10990 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 10999
/* 10995 */   MCD::OPC_Decode, 158, 10, 63, // Opcode: VSLL_B
/* 10999 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11008
/* 11004 */   MCD::OPC_Decode, 160, 10, 63, // Opcode: VSLL_H
/* 11008 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11017
/* 11013 */   MCD::OPC_Decode, 161, 10, 63, // Opcode: VSLL_W
/* 11017 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11026
/* 11022 */   MCD::OPC_Decode, 159, 10, 63, // Opcode: VSLL_D
/* 11026 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11035
/* 11031 */   MCD::OPC_Decode, 234, 10, 63, // Opcode: VSRL_B
/* 11035 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11044
/* 11040 */   MCD::OPC_Decode, 236, 10, 63, // Opcode: VSRL_H
/* 11044 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11053
/* 11049 */   MCD::OPC_Decode, 237, 10, 63, // Opcode: VSRL_W
/* 11053 */   MCD::OPC_FilterValue, 7, 158, 50, 0, // Skip to: 24016
/* 11058 */   MCD::OPC_Decode, 235, 10, 63, // Opcode: VSRL_D
/* 11062 */   MCD::OPC_FilterValue, 59, 75, 0, 0, // Skip to: 11142
/* 11067 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11070 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11079
/* 11075 */   MCD::OPC_Decode, 204, 10, 63, // Opcode: VSRA_B
/* 11079 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11088
/* 11084 */   MCD::OPC_Decode, 206, 10, 63, // Opcode: VSRA_H
/* 11088 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11097
/* 11093 */   MCD::OPC_Decode, 207, 10, 63, // Opcode: VSRA_W
/* 11097 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11106
/* 11102 */   MCD::OPC_Decode, 205, 10, 63, // Opcode: VSRA_D
/* 11106 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11115
/* 11111 */   MCD::OPC_Decode, 210, 9, 63, // Opcode: VROTR_B
/* 11115 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11124
/* 11120 */   MCD::OPC_Decode, 212, 9, 63, // Opcode: VROTR_H
/* 11124 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11133
/* 11129 */   MCD::OPC_Decode, 213, 9, 63, // Opcode: VROTR_W
/* 11133 */   MCD::OPC_FilterValue, 7, 78, 50, 0, // Skip to: 24016
/* 11138 */   MCD::OPC_Decode, 211, 9, 63, // Opcode: VROTR_D
/* 11142 */   MCD::OPC_FilterValue, 60, 75, 0, 0, // Skip to: 11222
/* 11147 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11150 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11159
/* 11155 */   MCD::OPC_Decode, 230, 10, 63, // Opcode: VSRLR_B
/* 11159 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11168
/* 11164 */   MCD::OPC_Decode, 232, 10, 63, // Opcode: VSRLR_H
/* 11168 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11177
/* 11173 */   MCD::OPC_Decode, 233, 10, 63, // Opcode: VSRLR_W
/* 11177 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11186
/* 11182 */   MCD::OPC_Decode, 231, 10, 63, // Opcode: VSRLR_D
/* 11186 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11195
/* 11191 */   MCD::OPC_Decode, 200, 10, 63, // Opcode: VSRAR_B
/* 11195 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11204
/* 11200 */   MCD::OPC_Decode, 202, 10, 63, // Opcode: VSRAR_H
/* 11204 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11213
/* 11209 */   MCD::OPC_Decode, 203, 10, 63, // Opcode: VSRAR_W
/* 11213 */   MCD::OPC_FilterValue, 7, 254, 49, 0, // Skip to: 24016
/* 11218 */   MCD::OPC_Decode, 201, 10, 63, // Opcode: VSRAR_D
/* 11222 */   MCD::OPC_FilterValue, 61, 57, 0, 0, // Skip to: 11284
/* 11227 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11230 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11239
/* 11235 */   MCD::OPC_Decode, 216, 10, 63, // Opcode: VSRLN_B_H
/* 11239 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11248
/* 11244 */   MCD::OPC_Decode, 217, 10, 63, // Opcode: VSRLN_H_W
/* 11248 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11257
/* 11253 */   MCD::OPC_Decode, 218, 10, 63, // Opcode: VSRLN_W_D
/* 11257 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11266
/* 11262 */   MCD::OPC_Decode, 186, 10, 63, // Opcode: VSRAN_B_H
/* 11266 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11275
/* 11271 */   MCD::OPC_Decode, 187, 10, 63, // Opcode: VSRAN_H_W
/* 11275 */   MCD::OPC_FilterValue, 7, 192, 49, 0, // Skip to: 24016
/* 11280 */   MCD::OPC_Decode, 188, 10, 63, // Opcode: VSRAN_W_D
/* 11284 */   MCD::OPC_FilterValue, 62, 57, 0, 0, // Skip to: 11346
/* 11289 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11292 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11301
/* 11297 */   MCD::OPC_Decode, 227, 10, 63, // Opcode: VSRLRN_B_H
/* 11301 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11310
/* 11306 */   MCD::OPC_Decode, 228, 10, 63, // Opcode: VSRLRN_H_W
/* 11310 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11319
/* 11315 */   MCD::OPC_Decode, 229, 10, 63, // Opcode: VSRLRN_W_D
/* 11319 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11328
/* 11324 */   MCD::OPC_Decode, 197, 10, 63, // Opcode: VSRARN_B_H
/* 11328 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11337
/* 11333 */   MCD::OPC_Decode, 198, 10, 63, // Opcode: VSRARN_H_W
/* 11337 */   MCD::OPC_FilterValue, 7, 130, 49, 0, // Skip to: 24016
/* 11342 */   MCD::OPC_Decode, 199, 10, 63, // Opcode: VSRARN_W_D
/* 11346 */   MCD::OPC_FilterValue, 63, 57, 0, 0, // Skip to: 11408
/* 11351 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11354 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11363
/* 11359 */   MCD::OPC_Decode, 147, 11, 63, // Opcode: VSSRLN_B_H
/* 11363 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11372
/* 11368 */   MCD::OPC_Decode, 149, 11, 63, // Opcode: VSSRLN_H_W
/* 11372 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11381
/* 11377 */   MCD::OPC_Decode, 151, 11, 63, // Opcode: VSSRLN_W_D
/* 11381 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11390
/* 11386 */   MCD::OPC_Decode, 247, 10, 63, // Opcode: VSSRAN_B_H
/* 11390 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11399
/* 11395 */   MCD::OPC_Decode, 249, 10, 63, // Opcode: VSSRAN_H_W
/* 11399 */   MCD::OPC_FilterValue, 7, 68, 49, 0, // Skip to: 24016
/* 11404 */   MCD::OPC_Decode, 251, 10, 63, // Opcode: VSSRAN_W_D
/* 11408 */   MCD::OPC_FilterValue, 64, 57, 0, 0, // Skip to: 11470
/* 11413 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11416 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11425
/* 11421 */   MCD::OPC_Decode, 161, 11, 63, // Opcode: VSSRLRN_B_H
/* 11425 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11434
/* 11430 */   MCD::OPC_Decode, 163, 11, 63, // Opcode: VSSRLRN_H_W
/* 11434 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11443
/* 11439 */   MCD::OPC_Decode, 165, 11, 63, // Opcode: VSSRLRN_W_D
/* 11443 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11452
/* 11448 */   MCD::OPC_Decode, 133, 11, 63, // Opcode: VSSRARN_B_H
/* 11452 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11461
/* 11457 */   MCD::OPC_Decode, 135, 11, 63, // Opcode: VSSRARN_H_W
/* 11461 */   MCD::OPC_FilterValue, 7, 6, 49, 0, // Skip to: 24016
/* 11466 */   MCD::OPC_Decode, 137, 11, 63, // Opcode: VSSRARN_W_D
/* 11470 */   MCD::OPC_FilterValue, 65, 57, 0, 0, // Skip to: 11532
/* 11475 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11478 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11487
/* 11483 */   MCD::OPC_Decode, 146, 11, 63, // Opcode: VSSRLN_BU_H
/* 11487 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11496
/* 11492 */   MCD::OPC_Decode, 148, 11, 63, // Opcode: VSSRLN_HU_W
/* 11496 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11505
/* 11501 */   MCD::OPC_Decode, 150, 11, 63, // Opcode: VSSRLN_WU_D
/* 11505 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11514
/* 11510 */   MCD::OPC_Decode, 246, 10, 63, // Opcode: VSSRAN_BU_H
/* 11514 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11523
/* 11519 */   MCD::OPC_Decode, 248, 10, 63, // Opcode: VSSRAN_HU_W
/* 11523 */   MCD::OPC_FilterValue, 7, 200, 48, 0, // Skip to: 24016
/* 11528 */   MCD::OPC_Decode, 250, 10, 63, // Opcode: VSSRAN_WU_D
/* 11532 */   MCD::OPC_FilterValue, 66, 57, 0, 0, // Skip to: 11594
/* 11537 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11540 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11549
/* 11545 */   MCD::OPC_Decode, 160, 11, 63, // Opcode: VSSRLRN_BU_H
/* 11549 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11558
/* 11554 */   MCD::OPC_Decode, 162, 11, 63, // Opcode: VSSRLRN_HU_W
/* 11558 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11567
/* 11563 */   MCD::OPC_Decode, 164, 11, 63, // Opcode: VSSRLRN_WU_D
/* 11567 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11576
/* 11572 */   MCD::OPC_Decode, 132, 11, 63, // Opcode: VSSRARN_BU_H
/* 11576 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11585
/* 11581 */   MCD::OPC_Decode, 134, 11, 63, // Opcode: VSSRARN_HU_W
/* 11585 */   MCD::OPC_FilterValue, 7, 138, 48, 0, // Skip to: 24016
/* 11590 */   MCD::OPC_Decode, 136, 11, 63, // Opcode: VSSRARN_WU_D
/* 11594 */   MCD::OPC_FilterValue, 67, 75, 0, 0, // Skip to: 11674
/* 11599 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11602 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11611
/* 11607 */   MCD::OPC_Decode, 191, 6, 63, // Opcode: VBITCLR_B
/* 11611 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11620
/* 11616 */   MCD::OPC_Decode, 193, 6, 63, // Opcode: VBITCLR_H
/* 11620 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11629
/* 11625 */   MCD::OPC_Decode, 194, 6, 63, // Opcode: VBITCLR_W
/* 11629 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11638
/* 11634 */   MCD::OPC_Decode, 192, 6, 63, // Opcode: VBITCLR_D
/* 11638 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11647
/* 11643 */   MCD::OPC_Decode, 209, 6, 63, // Opcode: VBITSET_B
/* 11647 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11656
/* 11652 */   MCD::OPC_Decode, 211, 6, 63, // Opcode: VBITSET_H
/* 11656 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11665
/* 11661 */   MCD::OPC_Decode, 212, 6, 63, // Opcode: VBITSET_W
/* 11665 */   MCD::OPC_FilterValue, 7, 58, 48, 0, // Skip to: 24016
/* 11670 */   MCD::OPC_Decode, 210, 6, 63, // Opcode: VBITSET_D
/* 11674 */   MCD::OPC_FilterValue, 68, 39, 0, 0, // Skip to: 11718
/* 11679 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11682 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11691
/* 11687 */   MCD::OPC_Decode, 199, 6, 63, // Opcode: VBITREV_B
/* 11691 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11700
/* 11696 */   MCD::OPC_Decode, 201, 6, 63, // Opcode: VBITREV_H
/* 11700 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11709
/* 11705 */   MCD::OPC_Decode, 202, 6, 63, // Opcode: VBITREV_W
/* 11709 */   MCD::OPC_FilterValue, 3, 14, 48, 0, // Skip to: 24016
/* 11714 */   MCD::OPC_Decode, 200, 6, 63, // Opcode: VBITREV_D
/* 11718 */   MCD::OPC_FilterValue, 69, 39, 0, 0, // Skip to: 11762
/* 11723 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11726 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11735
/* 11731 */   MCD::OPC_Decode, 165, 9, 63, // Opcode: VPACKEV_B
/* 11735 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11744
/* 11740 */   MCD::OPC_Decode, 167, 9, 63, // Opcode: VPACKEV_H
/* 11744 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11753
/* 11749 */   MCD::OPC_Decode, 168, 9, 63, // Opcode: VPACKEV_W
/* 11753 */   MCD::OPC_FilterValue, 7, 226, 47, 0, // Skip to: 24016
/* 11758 */   MCD::OPC_Decode, 166, 9, 63, // Opcode: VPACKEV_D
/* 11762 */   MCD::OPC_FilterValue, 70, 75, 0, 0, // Skip to: 11842
/* 11767 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11770 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11779
/* 11775 */   MCD::OPC_Decode, 169, 9, 63, // Opcode: VPACKOD_B
/* 11779 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11788
/* 11784 */   MCD::OPC_Decode, 171, 9, 63, // Opcode: VPACKOD_H
/* 11788 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11797
/* 11793 */   MCD::OPC_Decode, 172, 9, 63, // Opcode: VPACKOD_W
/* 11797 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11806
/* 11802 */   MCD::OPC_Decode, 170, 9, 63, // Opcode: VPACKOD_D
/* 11806 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11815
/* 11811 */   MCD::OPC_Decode, 155, 8, 63, // Opcode: VILVL_B
/* 11815 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11824
/* 11820 */   MCD::OPC_Decode, 157, 8, 63, // Opcode: VILVL_H
/* 11824 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11833
/* 11829 */   MCD::OPC_Decode, 158, 8, 63, // Opcode: VILVL_W
/* 11833 */   MCD::OPC_FilterValue, 7, 146, 47, 0, // Skip to: 24016
/* 11838 */   MCD::OPC_Decode, 156, 8, 63, // Opcode: VILVL_D
/* 11842 */   MCD::OPC_FilterValue, 71, 75, 0, 0, // Skip to: 11922
/* 11847 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11850 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11859
/* 11855 */   MCD::OPC_Decode, 151, 8, 63, // Opcode: VILVH_B
/* 11859 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11868
/* 11864 */   MCD::OPC_Decode, 153, 8, 63, // Opcode: VILVH_H
/* 11868 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11877
/* 11873 */   MCD::OPC_Decode, 154, 8, 63, // Opcode: VILVH_W
/* 11877 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11886
/* 11882 */   MCD::OPC_Decode, 152, 8, 63, // Opcode: VILVH_D
/* 11886 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11895
/* 11891 */   MCD::OPC_Decode, 178, 9, 63, // Opcode: VPICKEV_B
/* 11895 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11904
/* 11900 */   MCD::OPC_Decode, 180, 9, 63, // Opcode: VPICKEV_H
/* 11904 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11913
/* 11909 */   MCD::OPC_Decode, 181, 9, 63, // Opcode: VPICKEV_W
/* 11913 */   MCD::OPC_FilterValue, 7, 66, 47, 0, // Skip to: 24016
/* 11918 */   MCD::OPC_Decode, 179, 9, 63, // Opcode: VPICKEV_D
/* 11922 */   MCD::OPC_FilterValue, 72, 75, 0, 0, // Skip to: 12002
/* 11927 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 11930 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 11939
/* 11935 */   MCD::OPC_Decode, 182, 9, 63, // Opcode: VPICKOD_B
/* 11939 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 11948
/* 11944 */   MCD::OPC_Decode, 184, 9, 63, // Opcode: VPICKOD_H
/* 11948 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 11957
/* 11953 */   MCD::OPC_Decode, 185, 9, 63, // Opcode: VPICKOD_W
/* 11957 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 11966
/* 11962 */   MCD::OPC_Decode, 183, 9, 63, // Opcode: VPICKOD_D
/* 11966 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 11975
/* 11971 */   MCD::OPC_Decode, 202, 9, 102, // Opcode: VREPLVE_B
/* 11975 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 11984
/* 11980 */   MCD::OPC_Decode, 204, 9, 102, // Opcode: VREPLVE_H
/* 11984 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 11993
/* 11989 */   MCD::OPC_Decode, 205, 9, 102, // Opcode: VREPLVE_W
/* 11993 */   MCD::OPC_FilterValue, 7, 242, 46, 0, // Skip to: 24016
/* 11998 */   MCD::OPC_Decode, 203, 9, 102, // Opcode: VREPLVE_D
/* 12002 */   MCD::OPC_FilterValue, 73, 39, 0, 0, // Skip to: 12046
/* 12007 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12010 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12019
/* 12015 */   MCD::OPC_Decode, 170, 6, 63, // Opcode: VAND_V
/* 12019 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12028
/* 12024 */   MCD::OPC_Decode, 164, 9, 63, // Opcode: VOR_V
/* 12028 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12037
/* 12033 */   MCD::OPC_Decode, 206, 11, 63, // Opcode: VXOR_V
/* 12037 */   MCD::OPC_FilterValue, 7, 198, 46, 0, // Skip to: 24016
/* 12042 */   MCD::OPC_Decode, 161, 9, 63, // Opcode: VNOR_V
/* 12046 */   MCD::OPC_FilterValue, 74, 39, 0, 0, // Skip to: 12090
/* 12051 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12054 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12063
/* 12059 */   MCD::OPC_Decode, 169, 6, 63, // Opcode: VANDN_V
/* 12063 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12072
/* 12068 */   MCD::OPC_Decode, 163, 9, 63, // Opcode: VORN_V
/* 12072 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12081
/* 12077 */   MCD::OPC_Decode, 228, 7, 101, // Opcode: VFRSTP_B
/* 12081 */   MCD::OPC_FilterValue, 7, 154, 46, 0, // Skip to: 24016
/* 12086 */   MCD::OPC_Decode, 229, 7, 101, // Opcode: VFRSTP_H
/* 12090 */   MCD::OPC_FilterValue, 75, 57, 0, 0, // Skip to: 12152
/* 12095 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12098 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12107
/* 12103 */   MCD::OPC_Decode, 166, 6, 63, // Opcode: VADD_Q
/* 12107 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12116
/* 12112 */   MCD::OPC_Decode, 203, 11, 63, // Opcode: VSUB_Q
/* 12116 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12125
/* 12121 */   MCD::OPC_Decode, 128, 10, 63, // Opcode: VSIGNCOV_B
/* 12125 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12134
/* 12130 */   MCD::OPC_Decode, 130, 10, 63, // Opcode: VSIGNCOV_H
/* 12134 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12143
/* 12139 */   MCD::OPC_Decode, 131, 10, 63, // Opcode: VSIGNCOV_W
/* 12143 */   MCD::OPC_FilterValue, 7, 92, 46, 0, // Skip to: 24016
/* 12148 */   MCD::OPC_Decode, 129, 10, 63, // Opcode: VSIGNCOV_D
/* 12152 */   MCD::OPC_FilterValue, 76, 39, 0, 0, // Skip to: 12196
/* 12157 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12160 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12169
/* 12165 */   MCD::OPC_Decode, 130, 7, 63, // Opcode: VFADD_S
/* 12169 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12178
/* 12174 */   MCD::OPC_Decode, 129, 7, 63, // Opcode: VFADD_D
/* 12178 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12187
/* 12183 */   MCD::OPC_Decode, 233, 7, 63, // Opcode: VFSUB_S
/* 12187 */   MCD::OPC_FilterValue, 6, 48, 46, 0, // Skip to: 24016
/* 12192 */   MCD::OPC_Decode, 232, 7, 63, // Opcode: VFSUB_D
/* 12196 */   MCD::OPC_FilterValue, 78, 39, 0, 0, // Skip to: 12240
/* 12201 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12204 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12213
/* 12209 */   MCD::OPC_Decode, 207, 7, 63, // Opcode: VFMUL_S
/* 12213 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12222
/* 12218 */   MCD::OPC_Decode, 206, 7, 63, // Opcode: VFMUL_D
/* 12222 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12231
/* 12227 */   MCD::OPC_Decode, 184, 7, 63, // Opcode: VFDIV_S
/* 12231 */   MCD::OPC_FilterValue, 6, 4, 46, 0, // Skip to: 24016
/* 12236 */   MCD::OPC_Decode, 183, 7, 63, // Opcode: VFDIV_D
/* 12240 */   MCD::OPC_FilterValue, 79, 39, 0, 0, // Skip to: 12284
/* 12245 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12248 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12257
/* 12253 */   MCD::OPC_Decode, 199, 7, 63, // Opcode: VFMAX_S
/* 12257 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12266
/* 12262 */   MCD::OPC_Decode, 198, 7, 63, // Opcode: VFMAX_D
/* 12266 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12275
/* 12271 */   MCD::OPC_Decode, 203, 7, 63, // Opcode: VFMIN_S
/* 12275 */   MCD::OPC_FilterValue, 6, 216, 45, 0, // Skip to: 24016
/* 12280 */   MCD::OPC_Decode, 202, 7, 63, // Opcode: VFMIN_D
/* 12284 */   MCD::OPC_FilterValue, 80, 39, 0, 0, // Skip to: 12328
/* 12289 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12292 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12301
/* 12297 */   MCD::OPC_Decode, 197, 7, 63, // Opcode: VFMAXA_S
/* 12301 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12310
/* 12306 */   MCD::OPC_Decode, 196, 7, 63, // Opcode: VFMAXA_D
/* 12310 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12319
/* 12315 */   MCD::OPC_Decode, 201, 7, 63, // Opcode: VFMINA_S
/* 12319 */   MCD::OPC_FilterValue, 6, 172, 45, 0, // Skip to: 24016
/* 12324 */   MCD::OPC_Decode, 200, 7, 63, // Opcode: VFMINA_D
/* 12328 */   MCD::OPC_FilterValue, 81, 21, 0, 0, // Skip to: 12354
/* 12333 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12336 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12345
/* 12341 */   MCD::OPC_Decode, 181, 7, 63, // Opcode: VFCVT_H_S
/* 12345 */   MCD::OPC_FilterValue, 5, 146, 45, 0, // Skip to: 24016
/* 12350 */   MCD::OPC_Decode, 182, 7, 63, // Opcode: VFCVT_S_D
/* 12354 */   MCD::OPC_FilterValue, 82, 57, 0, 0, // Skip to: 12416
/* 12359 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12362 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12371
/* 12367 */   MCD::OPC_Decode, 189, 7, 63, // Opcode: VFFINT_S_L
/* 12371 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12380
/* 12376 */   MCD::OPC_Decode, 133, 8, 63, // Opcode: VFTINT_W_D
/* 12380 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12389
/* 12385 */   MCD::OPC_Decode, 239, 7, 63, // Opcode: VFTINTRM_W_D
/* 12389 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12398
/* 12394 */   MCD::OPC_Decode, 249, 7, 63, // Opcode: VFTINTRP_W_D
/* 12398 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12407
/* 12403 */   MCD::OPC_Decode, 128, 8, 63, // Opcode: VFTINTRZ_W_D
/* 12407 */   MCD::OPC_FilterValue, 7, 84, 45, 0, // Skip to: 24016
/* 12412 */   MCD::OPC_Decode, 244, 7, 63, // Opcode: VFTINTRNE_W_D
/* 12416 */   MCD::OPC_FilterValue, 94, 30, 0, 0, // Skip to: 12451
/* 12421 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12424 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12433
/* 12429 */   MCD::OPC_Decode, 254, 9, 101, // Opcode: VSHUF_H
/* 12433 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12442
/* 12438 */   MCD::OPC_Decode, 255, 9, 101, // Opcode: VSHUF_W
/* 12442 */   MCD::OPC_FilterValue, 7, 49, 45, 0, // Skip to: 24016
/* 12447 */   MCD::OPC_Decode, 253, 9, 101, // Opcode: VSHUF_D
/* 12451 */   MCD::OPC_FilterValue, 160, 1, 75, 0, 0, // Skip to: 12532
/* 12457 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12460 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12469
/* 12465 */   MCD::OPC_Decode, 230, 9, 103, // Opcode: VSEQI_B
/* 12469 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12478
/* 12474 */   MCD::OPC_Decode, 232, 9, 103, // Opcode: VSEQI_H
/* 12478 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12487
/* 12483 */   MCD::OPC_Decode, 233, 9, 103, // Opcode: VSEQI_W
/* 12487 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12496
/* 12492 */   MCD::OPC_Decode, 231, 9, 103, // Opcode: VSEQI_D
/* 12496 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12505
/* 12501 */   MCD::OPC_Decode, 132, 10, 103, // Opcode: VSLEI_B
/* 12505 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12514
/* 12510 */   MCD::OPC_Decode, 136, 10, 103, // Opcode: VSLEI_H
/* 12514 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12523
/* 12519 */   MCD::OPC_Decode, 138, 10, 103, // Opcode: VSLEI_W
/* 12523 */   MCD::OPC_FilterValue, 7, 224, 44, 0, // Skip to: 24016
/* 12528 */   MCD::OPC_Decode, 134, 10, 103, // Opcode: VSLEI_D
/* 12532 */   MCD::OPC_FilterValue, 161, 1, 75, 0, 0, // Skip to: 12613
/* 12538 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12541 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12550
/* 12546 */   MCD::OPC_Decode, 133, 10, 104, // Opcode: VSLEI_BU
/* 12550 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12559
/* 12555 */   MCD::OPC_Decode, 137, 10, 104, // Opcode: VSLEI_HU
/* 12559 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12568
/* 12564 */   MCD::OPC_Decode, 139, 10, 104, // Opcode: VSLEI_WU
/* 12568 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12577
/* 12573 */   MCD::OPC_Decode, 135, 10, 104, // Opcode: VSLEI_DU
/* 12577 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12586
/* 12582 */   MCD::OPC_Decode, 162, 10, 103, // Opcode: VSLTI_B
/* 12586 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12595
/* 12591 */   MCD::OPC_Decode, 166, 10, 103, // Opcode: VSLTI_H
/* 12595 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12604
/* 12600 */   MCD::OPC_Decode, 168, 10, 103, // Opcode: VSLTI_W
/* 12604 */   MCD::OPC_FilterValue, 7, 143, 44, 0, // Skip to: 24016
/* 12609 */   MCD::OPC_Decode, 164, 10, 103, // Opcode: VSLTI_D
/* 12613 */   MCD::OPC_FilterValue, 162, 1, 75, 0, 0, // Skip to: 12694
/* 12619 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12622 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12631
/* 12627 */   MCD::OPC_Decode, 163, 10, 104, // Opcode: VSLTI_BU
/* 12631 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12640
/* 12636 */   MCD::OPC_Decode, 167, 10, 104, // Opcode: VSLTI_HU
/* 12640 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12649
/* 12645 */   MCD::OPC_Decode, 169, 10, 104, // Opcode: VSLTI_WU
/* 12649 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12658
/* 12654 */   MCD::OPC_Decode, 165, 10, 104, // Opcode: VSLTI_DU
/* 12658 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12667
/* 12663 */   MCD::OPC_Decode, 135, 6, 104, // Opcode: VADDI_BU
/* 12667 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12676
/* 12672 */   MCD::OPC_Decode, 137, 6, 104, // Opcode: VADDI_HU
/* 12676 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12685
/* 12681 */   MCD::OPC_Decode, 138, 6, 104, // Opcode: VADDI_WU
/* 12685 */   MCD::OPC_FilterValue, 7, 62, 44, 0, // Skip to: 24016
/* 12690 */   MCD::OPC_Decode, 136, 6, 104, // Opcode: VADDI_DU
/* 12694 */   MCD::OPC_FilterValue, 163, 1, 57, 0, 0, // Skip to: 12757
/* 12700 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12703 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12712
/* 12708 */   MCD::OPC_Decode, 180, 11, 104, // Opcode: VSUBI_BU
/* 12712 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12721
/* 12717 */   MCD::OPC_Decode, 182, 11, 104, // Opcode: VSUBI_HU
/* 12721 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12730
/* 12726 */   MCD::OPC_Decode, 183, 11, 104, // Opcode: VSUBI_WU
/* 12730 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12739
/* 12735 */   MCD::OPC_Decode, 181, 11, 104, // Opcode: VSUBI_DU
/* 12739 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12748
/* 12744 */   MCD::OPC_Decode, 213, 6, 104, // Opcode: VBSLL_V
/* 12748 */   MCD::OPC_FilterValue, 5, 255, 43, 0, // Skip to: 24016
/* 12753 */   MCD::OPC_Decode, 214, 6, 104, // Opcode: VBSRL_V
/* 12757 */   MCD::OPC_FilterValue, 164, 1, 75, 0, 0, // Skip to: 12838
/* 12763 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12766 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12775
/* 12771 */   MCD::OPC_Decode, 198, 8, 103, // Opcode: VMAXI_B
/* 12775 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12784
/* 12780 */   MCD::OPC_Decode, 202, 8, 103, // Opcode: VMAXI_H
/* 12784 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12793
/* 12789 */   MCD::OPC_Decode, 204, 8, 103, // Opcode: VMAXI_W
/* 12793 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12802
/* 12798 */   MCD::OPC_Decode, 200, 8, 103, // Opcode: VMAXI_D
/* 12802 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12811
/* 12807 */   MCD::OPC_Decode, 214, 8, 103, // Opcode: VMINI_B
/* 12811 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12820
/* 12816 */   MCD::OPC_Decode, 218, 8, 103, // Opcode: VMINI_H
/* 12820 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12829
/* 12825 */   MCD::OPC_Decode, 220, 8, 103, // Opcode: VMINI_W
/* 12829 */   MCD::OPC_FilterValue, 7, 174, 43, 0, // Skip to: 24016
/* 12834 */   MCD::OPC_Decode, 216, 8, 103, // Opcode: VMINI_D
/* 12838 */   MCD::OPC_FilterValue, 165, 1, 75, 0, 0, // Skip to: 12919
/* 12844 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12847 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12856
/* 12852 */   MCD::OPC_Decode, 199, 8, 104, // Opcode: VMAXI_BU
/* 12856 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12865
/* 12861 */   MCD::OPC_Decode, 203, 8, 104, // Opcode: VMAXI_HU
/* 12865 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12874
/* 12870 */   MCD::OPC_Decode, 205, 8, 104, // Opcode: VMAXI_WU
/* 12874 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12883
/* 12879 */   MCD::OPC_Decode, 201, 8, 104, // Opcode: VMAXI_DU
/* 12883 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12892
/* 12888 */   MCD::OPC_Decode, 215, 8, 104, // Opcode: VMINI_BU
/* 12892 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 12901
/* 12897 */   MCD::OPC_Decode, 219, 8, 104, // Opcode: VMINI_HU
/* 12901 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 12910
/* 12906 */   MCD::OPC_Decode, 221, 8, 104, // Opcode: VMINI_WU
/* 12910 */   MCD::OPC_FilterValue, 7, 93, 43, 0, // Skip to: 24016
/* 12915 */   MCD::OPC_Decode, 217, 8, 104, // Opcode: VMINI_DU
/* 12919 */   MCD::OPC_FilterValue, 166, 1, 21, 0, 0, // Skip to: 12946
/* 12925 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12928 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 12937
/* 12933 */   MCD::OPC_Decode, 226, 7, 105, // Opcode: VFRSTPI_B
/* 12937 */   MCD::OPC_FilterValue, 5, 66, 43, 0, // Skip to: 24016
/* 12942 */   MCD::OPC_Decode, 227, 7, 105, // Opcode: VFRSTPI_H
/* 12946 */   MCD::OPC_FilterValue, 167, 1, 229, 3, 0, // Skip to: 13949
/* 12952 */   MCD::OPC_ExtractField, 10, 8,  // Inst{17-10} ...
/* 12955 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 12964
/* 12960 */   MCD::OPC_Decode, 215, 6, 106, // Opcode: VCLO_B
/* 12964 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 12973
/* 12969 */   MCD::OPC_Decode, 217, 6, 106, // Opcode: VCLO_H
/* 12973 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 12982
/* 12978 */   MCD::OPC_Decode, 218, 6, 106, // Opcode: VCLO_W
/* 12982 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 12991
/* 12987 */   MCD::OPC_Decode, 216, 6, 106, // Opcode: VCLO_D
/* 12991 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 13000
/* 12996 */   MCD::OPC_Decode, 219, 6, 106, // Opcode: VCLZ_B
/* 13000 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 13009
/* 13005 */   MCD::OPC_Decode, 221, 6, 106, // Opcode: VCLZ_H
/* 13009 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 13018
/* 13014 */   MCD::OPC_Decode, 222, 6, 106, // Opcode: VCLZ_W
/* 13018 */   MCD::OPC_FilterValue, 7, 4, 0, 0, // Skip to: 13027
/* 13023 */   MCD::OPC_Decode, 220, 6, 106, // Opcode: VCLZ_D
/* 13027 */   MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 13036
/* 13032 */   MCD::OPC_Decode, 173, 9, 106, // Opcode: VPCNT_B
/* 13036 */   MCD::OPC_FilterValue, 9, 4, 0, 0, // Skip to: 13045
/* 13041 */   MCD::OPC_Decode, 175, 9, 106, // Opcode: VPCNT_H
/* 13045 */   MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 13054
/* 13050 */   MCD::OPC_Decode, 176, 9, 106, // Opcode: VPCNT_W
/* 13054 */   MCD::OPC_FilterValue, 11, 4, 0, 0, // Skip to: 13063
/* 13059 */   MCD::OPC_Decode, 174, 9, 106, // Opcode: VPCNT_D
/* 13063 */   MCD::OPC_FilterValue, 12, 4, 0, 0, // Skip to: 13072
/* 13068 */   MCD::OPC_Decode, 156, 9, 106, // Opcode: VNEG_B
/* 13072 */   MCD::OPC_FilterValue, 13, 4, 0, 0, // Skip to: 13081
/* 13077 */   MCD::OPC_Decode, 158, 9, 106, // Opcode: VNEG_H
/* 13081 */   MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 13090
/* 13086 */   MCD::OPC_Decode, 159, 9, 106, // Opcode: VNEG_W
/* 13090 */   MCD::OPC_FilterValue, 15, 4, 0, 0, // Skip to: 13099
/* 13095 */   MCD::OPC_Decode, 157, 9, 106, // Opcode: VNEG_D
/* 13099 */   MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 13108
/* 13104 */   MCD::OPC_Decode, 239, 8, 106, // Opcode: VMSKLTZ_B
/* 13108 */   MCD::OPC_FilterValue, 17, 4, 0, 0, // Skip to: 13117
/* 13113 */   MCD::OPC_Decode, 241, 8, 106, // Opcode: VMSKLTZ_H
/* 13117 */   MCD::OPC_FilterValue, 18, 4, 0, 0, // Skip to: 13126
/* 13122 */   MCD::OPC_Decode, 242, 8, 106, // Opcode: VMSKLTZ_W
/* 13126 */   MCD::OPC_FilterValue, 19, 4, 0, 0, // Skip to: 13135
/* 13131 */   MCD::OPC_Decode, 240, 8, 106, // Opcode: VMSKLTZ_D
/* 13135 */   MCD::OPC_FilterValue, 20, 4, 0, 0, // Skip to: 13144
/* 13140 */   MCD::OPC_Decode, 238, 8, 106, // Opcode: VMSKGEZ_B
/* 13144 */   MCD::OPC_FilterValue, 24, 4, 0, 0, // Skip to: 13153
/* 13149 */   MCD::OPC_Decode, 243, 8, 106, // Opcode: VMSKNZ_B
/* 13153 */   MCD::OPC_FilterValue, 38, 11, 0, 0, // Skip to: 13169
/* 13158 */   MCD::OPC_CheckField, 3, 2, 0, 99, 42, 0, // Skip to: 24016
/* 13165 */   MCD::OPC_Decode, 246, 9, 107, // Opcode: VSETEQZ_V
/* 13169 */   MCD::OPC_FilterValue, 39, 11, 0, 0, // Skip to: 13185
/* 13174 */   MCD::OPC_CheckField, 3, 2, 0, 83, 42, 0, // Skip to: 24016
/* 13181 */   MCD::OPC_Decode, 247, 9, 107, // Opcode: VSETNEZ_V
/* 13185 */   MCD::OPC_FilterValue, 40, 11, 0, 0, // Skip to: 13201
/* 13190 */   MCD::OPC_CheckField, 3, 2, 0, 67, 42, 0, // Skip to: 24016
/* 13197 */   MCD::OPC_Decode, 242, 9, 107, // Opcode: VSETANYEQZ_B
/* 13201 */   MCD::OPC_FilterValue, 41, 11, 0, 0, // Skip to: 13217
/* 13206 */   MCD::OPC_CheckField, 3, 2, 0, 51, 42, 0, // Skip to: 24016
/* 13213 */   MCD::OPC_Decode, 244, 9, 107, // Opcode: VSETANYEQZ_H
/* 13217 */   MCD::OPC_FilterValue, 42, 11, 0, 0, // Skip to: 13233
/* 13222 */   MCD::OPC_CheckField, 3, 2, 0, 35, 42, 0, // Skip to: 24016
/* 13229 */   MCD::OPC_Decode, 245, 9, 107, // Opcode: VSETANYEQZ_W
/* 13233 */   MCD::OPC_FilterValue, 43, 11, 0, 0, // Skip to: 13249
/* 13238 */   MCD::OPC_CheckField, 3, 2, 0, 19, 42, 0, // Skip to: 24016
/* 13245 */   MCD::OPC_Decode, 243, 9, 107, // Opcode: VSETANYEQZ_D
/* 13249 */   MCD::OPC_FilterValue, 44, 11, 0, 0, // Skip to: 13265
/* 13254 */   MCD::OPC_CheckField, 3, 2, 0, 3, 42, 0, // Skip to: 24016
/* 13261 */   MCD::OPC_Decode, 238, 9, 107, // Opcode: VSETALLNEZ_B
/* 13265 */   MCD::OPC_FilterValue, 45, 11, 0, 0, // Skip to: 13281
/* 13270 */   MCD::OPC_CheckField, 3, 2, 0, 243, 41, 0, // Skip to: 24016
/* 13277 */   MCD::OPC_Decode, 240, 9, 107, // Opcode: VSETALLNEZ_H
/* 13281 */   MCD::OPC_FilterValue, 46, 11, 0, 0, // Skip to: 13297
/* 13286 */   MCD::OPC_CheckField, 3, 2, 0, 227, 41, 0, // Skip to: 24016
/* 13293 */   MCD::OPC_Decode, 241, 9, 107, // Opcode: VSETALLNEZ_W
/* 13297 */   MCD::OPC_FilterValue, 47, 11, 0, 0, // Skip to: 13313
/* 13302 */   MCD::OPC_CheckField, 3, 2, 0, 211, 41, 0, // Skip to: 24016
/* 13309 */   MCD::OPC_Decode, 239, 9, 107, // Opcode: VSETALLNEZ_D
/* 13313 */   MCD::OPC_FilterValue, 49, 4, 0, 0, // Skip to: 13322
/* 13318 */   MCD::OPC_Decode, 193, 7, 106, // Opcode: VFLOGB_S
/* 13322 */   MCD::OPC_FilterValue, 50, 4, 0, 0, // Skip to: 13331
/* 13327 */   MCD::OPC_Decode, 192, 7, 106, // Opcode: VFLOGB_D
/* 13331 */   MCD::OPC_FilterValue, 53, 4, 0, 0, // Skip to: 13340
/* 13336 */   MCD::OPC_Decode, 132, 7, 106, // Opcode: VFCLASS_S
/* 13340 */   MCD::OPC_FilterValue, 54, 4, 0, 0, // Skip to: 13349
/* 13345 */   MCD::OPC_Decode, 131, 7, 106, // Opcode: VFCLASS_D
/* 13349 */   MCD::OPC_FilterValue, 57, 4, 0, 0, // Skip to: 13358
/* 13354 */   MCD::OPC_Decode, 231, 7, 106, // Opcode: VFSQRT_S
/* 13358 */   MCD::OPC_FilterValue, 58, 4, 0, 0, // Skip to: 13367
/* 13363 */   MCD::OPC_Decode, 230, 7, 106, // Opcode: VFSQRT_D
/* 13367 */   MCD::OPC_FilterValue, 61, 4, 0, 0, // Skip to: 13376
/* 13372 */   MCD::OPC_Decode, 213, 7, 106, // Opcode: VFRECIP_S
/* 13376 */   MCD::OPC_FilterValue, 62, 4, 0, 0, // Skip to: 13385
/* 13381 */   MCD::OPC_Decode, 212, 7, 106, // Opcode: VFRECIP_D
/* 13385 */   MCD::OPC_FilterValue, 65, 4, 0, 0, // Skip to: 13394
/* 13390 */   MCD::OPC_Decode, 225, 7, 106, // Opcode: VFRSQRT_S
/* 13394 */   MCD::OPC_FilterValue, 66, 4, 0, 0, // Skip to: 13403
/* 13399 */   MCD::OPC_Decode, 224, 7, 106, // Opcode: VFRSQRT_D
/* 13403 */   MCD::OPC_FilterValue, 77, 4, 0, 0, // Skip to: 13412
/* 13408 */   MCD::OPC_Decode, 223, 7, 106, // Opcode: VFRINT_S
/* 13412 */   MCD::OPC_FilterValue, 78, 4, 0, 0, // Skip to: 13421
/* 13417 */   MCD::OPC_Decode, 222, 7, 106, // Opcode: VFRINT_D
/* 13421 */   MCD::OPC_FilterValue, 81, 4, 0, 0, // Skip to: 13430
/* 13426 */   MCD::OPC_Decode, 215, 7, 106, // Opcode: VFRINTRM_S
/* 13430 */   MCD::OPC_FilterValue, 82, 4, 0, 0, // Skip to: 13439
/* 13435 */   MCD::OPC_Decode, 214, 7, 106, // Opcode: VFRINTRM_D
/* 13439 */   MCD::OPC_FilterValue, 85, 4, 0, 0, // Skip to: 13448
/* 13444 */   MCD::OPC_Decode, 219, 7, 106, // Opcode: VFRINTRP_S
/* 13448 */   MCD::OPC_FilterValue, 86, 4, 0, 0, // Skip to: 13457
/* 13453 */   MCD::OPC_Decode, 218, 7, 106, // Opcode: VFRINTRP_D
/* 13457 */   MCD::OPC_FilterValue, 89, 4, 0, 0, // Skip to: 13466
/* 13462 */   MCD::OPC_Decode, 221, 7, 106, // Opcode: VFRINTRZ_S
/* 13466 */   MCD::OPC_FilterValue, 90, 4, 0, 0, // Skip to: 13475
/* 13471 */   MCD::OPC_Decode, 220, 7, 106, // Opcode: VFRINTRZ_D
/* 13475 */   MCD::OPC_FilterValue, 93, 4, 0, 0, // Skip to: 13484
/* 13480 */   MCD::OPC_Decode, 217, 7, 106, // Opcode: VFRINTRNE_S
/* 13484 */   MCD::OPC_FilterValue, 94, 4, 0, 0, // Skip to: 13493
/* 13489 */   MCD::OPC_Decode, 216, 7, 106, // Opcode: VFRINTRNE_D
/* 13493 */   MCD::OPC_FilterValue, 122, 4, 0, 0, // Skip to: 13502
/* 13498 */   MCD::OPC_Decode, 180, 7, 106, // Opcode: VFCVTL_S_H
/* 13502 */   MCD::OPC_FilterValue, 123, 4, 0, 0, // Skip to: 13511
/* 13507 */   MCD::OPC_Decode, 178, 7, 106, // Opcode: VFCVTH_S_H
/* 13511 */   MCD::OPC_FilterValue, 124, 4, 0, 0, // Skip to: 13520
/* 13516 */   MCD::OPC_Decode, 179, 7, 106, // Opcode: VFCVTL_D_S
/* 13520 */   MCD::OPC_FilterValue, 125, 4, 0, 0, // Skip to: 13529
/* 13525 */   MCD::OPC_Decode, 177, 7, 106, // Opcode: VFCVTH_D_S
/* 13529 */   MCD::OPC_FilterValue, 128, 1, 4, 0, 0, // Skip to: 13539
/* 13535 */   MCD::OPC_Decode, 190, 7, 106, // Opcode: VFFINT_S_W
/* 13539 */   MCD::OPC_FilterValue, 129, 1, 4, 0, 0, // Skip to: 13549
/* 13545 */   MCD::OPC_Decode, 191, 7, 106, // Opcode: VFFINT_S_WU
/* 13549 */   MCD::OPC_FilterValue, 130, 1, 4, 0, 0, // Skip to: 13559
/* 13555 */   MCD::OPC_Decode, 187, 7, 106, // Opcode: VFFINT_D_L
/* 13559 */   MCD::OPC_FilterValue, 131, 1, 4, 0, 0, // Skip to: 13569
/* 13565 */   MCD::OPC_Decode, 188, 7, 106, // Opcode: VFFINT_D_LU
/* 13569 */   MCD::OPC_FilterValue, 132, 1, 4, 0, 0, // Skip to: 13579
/* 13575 */   MCD::OPC_Decode, 186, 7, 106, // Opcode: VFFINTL_D_W
/* 13579 */   MCD::OPC_FilterValue, 133, 1, 4, 0, 0, // Skip to: 13589
/* 13585 */   MCD::OPC_Decode, 185, 7, 106, // Opcode: VFFINTH_D_W
/* 13589 */   MCD::OPC_FilterValue, 140, 1, 4, 0, 0, // Skip to: 13599
/* 13595 */   MCD::OPC_Decode, 134, 8, 106, // Opcode: VFTINT_W_S
/* 13599 */   MCD::OPC_FilterValue, 141, 1, 4, 0, 0, // Skip to: 13609
/* 13605 */   MCD::OPC_Decode, 131, 8, 106, // Opcode: VFTINT_L_D
/* 13609 */   MCD::OPC_FilterValue, 142, 1, 4, 0, 0, // Skip to: 13619
/* 13615 */   MCD::OPC_Decode, 240, 7, 106, // Opcode: VFTINTRM_W_S
/* 13619 */   MCD::OPC_FilterValue, 143, 1, 4, 0, 0, // Skip to: 13629
/* 13625 */   MCD::OPC_Decode, 238, 7, 106, // Opcode: VFTINTRM_L_D
/* 13629 */   MCD::OPC_FilterValue, 144, 1, 4, 0, 0, // Skip to: 13639
/* 13635 */   MCD::OPC_Decode, 250, 7, 106, // Opcode: VFTINTRP_W_S
/* 13639 */   MCD::OPC_FilterValue, 145, 1, 4, 0, 0, // Skip to: 13649
/* 13645 */   MCD::OPC_Decode, 248, 7, 106, // Opcode: VFTINTRP_L_D
/* 13649 */   MCD::OPC_FilterValue, 146, 1, 4, 0, 0, // Skip to: 13659
/* 13655 */   MCD::OPC_Decode, 129, 8, 106, // Opcode: VFTINTRZ_W_S
/* 13659 */   MCD::OPC_FilterValue, 147, 1, 4, 0, 0, // Skip to: 13669
/* 13665 */   MCD::OPC_Decode, 254, 7, 106, // Opcode: VFTINTRZ_L_D
/* 13669 */   MCD::OPC_FilterValue, 148, 1, 4, 0, 0, // Skip to: 13679
/* 13675 */   MCD::OPC_Decode, 245, 7, 106, // Opcode: VFTINTRNE_W_S
/* 13679 */   MCD::OPC_FilterValue, 149, 1, 4, 0, 0, // Skip to: 13689
/* 13685 */   MCD::OPC_Decode, 243, 7, 106, // Opcode: VFTINTRNE_L_D
/* 13689 */   MCD::OPC_FilterValue, 150, 1, 4, 0, 0, // Skip to: 13699
/* 13695 */   MCD::OPC_Decode, 132, 8, 106, // Opcode: VFTINT_WU_S
/* 13699 */   MCD::OPC_FilterValue, 151, 1, 4, 0, 0, // Skip to: 13709
/* 13705 */   MCD::OPC_Decode, 130, 8, 106, // Opcode: VFTINT_LU_D
/* 13709 */   MCD::OPC_FilterValue, 156, 1, 4, 0, 0, // Skip to: 13719
/* 13715 */   MCD::OPC_Decode, 255, 7, 106, // Opcode: VFTINTRZ_WU_S
/* 13719 */   MCD::OPC_FilterValue, 157, 1, 4, 0, 0, // Skip to: 13729
/* 13725 */   MCD::OPC_Decode, 253, 7, 106, // Opcode: VFTINTRZ_LU_D
/* 13729 */   MCD::OPC_FilterValue, 160, 1, 4, 0, 0, // Skip to: 13739
/* 13735 */   MCD::OPC_Decode, 235, 7, 106, // Opcode: VFTINTL_L_S
/* 13739 */   MCD::OPC_FilterValue, 161, 1, 4, 0, 0, // Skip to: 13749
/* 13745 */   MCD::OPC_Decode, 234, 7, 106, // Opcode: VFTINTH_L_S
/* 13749 */   MCD::OPC_FilterValue, 162, 1, 4, 0, 0, // Skip to: 13759
/* 13755 */   MCD::OPC_Decode, 237, 7, 106, // Opcode: VFTINTRML_L_S
/* 13759 */   MCD::OPC_FilterValue, 163, 1, 4, 0, 0, // Skip to: 13769
/* 13765 */   MCD::OPC_Decode, 236, 7, 106, // Opcode: VFTINTRMH_L_S
/* 13769 */   MCD::OPC_FilterValue, 164, 1, 4, 0, 0, // Skip to: 13779
/* 13775 */   MCD::OPC_Decode, 247, 7, 106, // Opcode: VFTINTRPL_L_S
/* 13779 */   MCD::OPC_FilterValue, 165, 1, 4, 0, 0, // Skip to: 13789
/* 13785 */   MCD::OPC_Decode, 246, 7, 106, // Opcode: VFTINTRPH_L_S
/* 13789 */   MCD::OPC_FilterValue, 166, 1, 4, 0, 0, // Skip to: 13799
/* 13795 */   MCD::OPC_Decode, 252, 7, 106, // Opcode: VFTINTRZL_L_S
/* 13799 */   MCD::OPC_FilterValue, 167, 1, 4, 0, 0, // Skip to: 13809
/* 13805 */   MCD::OPC_Decode, 251, 7, 106, // Opcode: VFTINTRZH_L_S
/* 13809 */   MCD::OPC_FilterValue, 168, 1, 4, 0, 0, // Skip to: 13819
/* 13815 */   MCD::OPC_Decode, 242, 7, 106, // Opcode: VFTINTRNEL_L_S
/* 13819 */   MCD::OPC_FilterValue, 169, 1, 4, 0, 0, // Skip to: 13829
/* 13825 */   MCD::OPC_Decode, 241, 7, 106, // Opcode: VFTINTRNEH_L_S
/* 13829 */   MCD::OPC_FilterValue, 184, 1, 4, 0, 0, // Skip to: 13839
/* 13835 */   MCD::OPC_Decode, 246, 6, 106, // Opcode: VEXTH_H_B
/* 13839 */   MCD::OPC_FilterValue, 185, 1, 4, 0, 0, // Skip to: 13849
/* 13845 */   MCD::OPC_Decode, 250, 6, 106, // Opcode: VEXTH_W_H
/* 13849 */   MCD::OPC_FilterValue, 186, 1, 4, 0, 0, // Skip to: 13859
/* 13855 */   MCD::OPC_Decode, 244, 6, 106, // Opcode: VEXTH_D_W
/* 13859 */   MCD::OPC_FilterValue, 187, 1, 4, 0, 0, // Skip to: 13869
/* 13865 */   MCD::OPC_Decode, 248, 6, 106, // Opcode: VEXTH_Q_D
/* 13869 */   MCD::OPC_FilterValue, 188, 1, 4, 0, 0, // Skip to: 13879
/* 13875 */   MCD::OPC_Decode, 245, 6, 106, // Opcode: VEXTH_HU_BU
/* 13879 */   MCD::OPC_FilterValue, 189, 1, 4, 0, 0, // Skip to: 13889
/* 13885 */   MCD::OPC_Decode, 249, 6, 106, // Opcode: VEXTH_WU_HU
/* 13889 */   MCD::OPC_FilterValue, 190, 1, 4, 0, 0, // Skip to: 13899
/* 13895 */   MCD::OPC_Decode, 243, 6, 106, // Opcode: VEXTH_DU_WU
/* 13899 */   MCD::OPC_FilterValue, 191, 1, 4, 0, 0, // Skip to: 13909
/* 13905 */   MCD::OPC_Decode, 247, 6, 106, // Opcode: VEXTH_QU_DU
/* 13909 */   MCD::OPC_FilterValue, 192, 1, 4, 0, 0, // Skip to: 13919
/* 13915 */   MCD::OPC_Decode, 194, 9, 108, // Opcode: VREPLGR2VR_B
/* 13919 */   MCD::OPC_FilterValue, 193, 1, 4, 0, 0, // Skip to: 13929
/* 13925 */   MCD::OPC_Decode, 196, 9, 108, // Opcode: VREPLGR2VR_H
/* 13929 */   MCD::OPC_FilterValue, 194, 1, 4, 0, 0, // Skip to: 13939
/* 13935 */   MCD::OPC_Decode, 197, 9, 108, // Opcode: VREPLGR2VR_W
/* 13939 */   MCD::OPC_FilterValue, 195, 1, 87, 39, 0, // Skip to: 24016
/* 13945 */   MCD::OPC_Decode, 195, 9, 108, // Opcode: VREPLGR2VR_D
/* 13949 */   MCD::OPC_FilterValue, 168, 1, 62, 0, 0, // Skip to: 14017
/* 13955 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 13958 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14008
/* 13963 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 13966 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 13999
/* 13971 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 13974 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 13990
/* 13979 */   MCD::OPC_CheckField, 13, 1, 1, 46, 39, 0, // Skip to: 24016
/* 13986 */   MCD::OPC_Decode, 206, 9, 109, // Opcode: VROTRI_B
/* 13990 */   MCD::OPC_FilterValue, 1, 37, 39, 0, // Skip to: 24016
/* 13995 */   MCD::OPC_Decode, 208, 9, 110, // Opcode: VROTRI_H
/* 13999 */   MCD::OPC_FilterValue, 1, 28, 39, 0, // Skip to: 24016
/* 14004 */   MCD::OPC_Decode, 209, 9, 104, // Opcode: VROTRI_W
/* 14008 */   MCD::OPC_FilterValue, 1, 19, 39, 0, // Skip to: 24016
/* 14013 */   MCD::OPC_Decode, 207, 9, 111, // Opcode: VROTRI_D
/* 14017 */   MCD::OPC_FilterValue, 169, 1, 62, 0, 0, // Skip to: 14085
/* 14023 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14026 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14076
/* 14031 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14034 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14067
/* 14039 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14042 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14058
/* 14047 */   MCD::OPC_CheckField, 13, 1, 1, 234, 38, 0, // Skip to: 24016
/* 14054 */   MCD::OPC_Decode, 219, 10, 109, // Opcode: VSRLRI_B
/* 14058 */   MCD::OPC_FilterValue, 1, 225, 38, 0, // Skip to: 24016
/* 14063 */   MCD::OPC_Decode, 221, 10, 110, // Opcode: VSRLRI_H
/* 14067 */   MCD::OPC_FilterValue, 1, 216, 38, 0, // Skip to: 24016
/* 14072 */   MCD::OPC_Decode, 222, 10, 104, // Opcode: VSRLRI_W
/* 14076 */   MCD::OPC_FilterValue, 1, 207, 38, 0, // Skip to: 24016
/* 14081 */   MCD::OPC_Decode, 220, 10, 111, // Opcode: VSRLRI_D
/* 14085 */   MCD::OPC_FilterValue, 170, 1, 62, 0, 0, // Skip to: 14153
/* 14091 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14094 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14144
/* 14099 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14102 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14135
/* 14107 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14110 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14126
/* 14115 */   MCD::OPC_CheckField, 13, 1, 1, 166, 38, 0, // Skip to: 24016
/* 14122 */   MCD::OPC_Decode, 189, 10, 109, // Opcode: VSRARI_B
/* 14126 */   MCD::OPC_FilterValue, 1, 157, 38, 0, // Skip to: 24016
/* 14131 */   MCD::OPC_Decode, 191, 10, 110, // Opcode: VSRARI_H
/* 14135 */   MCD::OPC_FilterValue, 1, 148, 38, 0, // Skip to: 24016
/* 14140 */   MCD::OPC_Decode, 192, 10, 104, // Opcode: VSRARI_W
/* 14144 */   MCD::OPC_FilterValue, 1, 139, 38, 0, // Skip to: 24016
/* 14149 */   MCD::OPC_Decode, 190, 10, 111, // Opcode: VSRARI_D
/* 14153 */   MCD::OPC_FilterValue, 186, 1, 62, 0, 0, // Skip to: 14221
/* 14159 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 14162 */   MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 14171
/* 14167 */   MCD::OPC_Decode, 159, 8, 112, // Opcode: VINSGR2VR_B
/* 14171 */   MCD::OPC_FilterValue, 15, 112, 38, 0, // Skip to: 24016
/* 14176 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 14179 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14188
/* 14184 */   MCD::OPC_Decode, 161, 8, 113, // Opcode: VINSGR2VR_H
/* 14188 */   MCD::OPC_FilterValue, 1, 95, 38, 0, // Skip to: 24016
/* 14193 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 14196 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14205
/* 14201 */   MCD::OPC_Decode, 162, 8, 114, // Opcode: VINSGR2VR_W
/* 14205 */   MCD::OPC_FilterValue, 1, 78, 38, 0, // Skip to: 24016
/* 14210 */   MCD::OPC_CheckField, 11, 1, 0, 71, 38, 0, // Skip to: 24016
/* 14217 */   MCD::OPC_Decode, 160, 8, 115, // Opcode: VINSGR2VR_D
/* 14221 */   MCD::OPC_FilterValue, 187, 1, 62, 0, 0, // Skip to: 14289
/* 14227 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 14230 */   MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 14239
/* 14235 */   MCD::OPC_Decode, 186, 9, 116, // Opcode: VPICKVE2GR_B
/* 14239 */   MCD::OPC_FilterValue, 15, 44, 38, 0, // Skip to: 24016
/* 14244 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 14247 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14256
/* 14252 */   MCD::OPC_Decode, 190, 9, 117, // Opcode: VPICKVE2GR_H
/* 14256 */   MCD::OPC_FilterValue, 1, 27, 38, 0, // Skip to: 24016
/* 14261 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 14264 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14273
/* 14269 */   MCD::OPC_Decode, 192, 9, 118, // Opcode: VPICKVE2GR_W
/* 14273 */   MCD::OPC_FilterValue, 1, 10, 38, 0, // Skip to: 24016
/* 14278 */   MCD::OPC_CheckField, 11, 1, 0, 3, 38, 0, // Skip to: 24016
/* 14285 */   MCD::OPC_Decode, 188, 9, 119, // Opcode: VPICKVE2GR_D
/* 14289 */   MCD::OPC_FilterValue, 188, 1, 62, 0, 0, // Skip to: 14357
/* 14295 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 14298 */   MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 14307
/* 14303 */   MCD::OPC_Decode, 187, 9, 116, // Opcode: VPICKVE2GR_BU
/* 14307 */   MCD::OPC_FilterValue, 15, 232, 37, 0, // Skip to: 24016
/* 14312 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 14315 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14324
/* 14320 */   MCD::OPC_Decode, 191, 9, 117, // Opcode: VPICKVE2GR_HU
/* 14324 */   MCD::OPC_FilterValue, 1, 215, 37, 0, // Skip to: 24016
/* 14329 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 14332 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14341
/* 14337 */   MCD::OPC_Decode, 193, 9, 118, // Opcode: VPICKVE2GR_WU
/* 14341 */   MCD::OPC_FilterValue, 1, 198, 37, 0, // Skip to: 24016
/* 14346 */   MCD::OPC_CheckField, 11, 1, 0, 191, 37, 0, // Skip to: 24016
/* 14353 */   MCD::OPC_Decode, 189, 9, 119, // Opcode: VPICKVE2GR_DU
/* 14357 */   MCD::OPC_FilterValue, 189, 1, 62, 0, 0, // Skip to: 14425
/* 14363 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 14366 */   MCD::OPC_FilterValue, 14, 4, 0, 0, // Skip to: 14375
/* 14371 */   MCD::OPC_Decode, 198, 9, 110, // Opcode: VREPLVEI_B
/* 14375 */   MCD::OPC_FilterValue, 15, 164, 37, 0, // Skip to: 24016
/* 14380 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 14383 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14392
/* 14388 */   MCD::OPC_Decode, 200, 9, 109, // Opcode: VREPLVEI_H
/* 14392 */   MCD::OPC_FilterValue, 1, 147, 37, 0, // Skip to: 24016
/* 14397 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 14400 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 14409
/* 14405 */   MCD::OPC_Decode, 201, 9, 120, // Opcode: VREPLVEI_W
/* 14409 */   MCD::OPC_FilterValue, 1, 130, 37, 0, // Skip to: 24016
/* 14414 */   MCD::OPC_CheckField, 11, 1, 0, 123, 37, 0, // Skip to: 24016
/* 14421 */   MCD::OPC_Decode, 199, 9, 121, // Opcode: VREPLVEI_D
/* 14425 */   MCD::OPC_FilterValue, 194, 1, 61, 0, 0, // Skip to: 14492
/* 14431 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14434 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14467
/* 14439 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14442 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14458
/* 14447 */   MCD::OPC_CheckField, 13, 1, 1, 90, 37, 0, // Skip to: 24016
/* 14454 */   MCD::OPC_Decode, 155, 10, 109, // Opcode: VSLLWIL_H_B
/* 14458 */   MCD::OPC_FilterValue, 1, 81, 37, 0, // Skip to: 24016
/* 14463 */   MCD::OPC_Decode, 157, 10, 110, // Opcode: VSLLWIL_W_H
/* 14467 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 14476
/* 14472 */   MCD::OPC_Decode, 153, 10, 104, // Opcode: VSLLWIL_D_W
/* 14476 */   MCD::OPC_FilterValue, 2, 63, 37, 0, // Skip to: 24016
/* 14481 */   MCD::OPC_CheckField, 10, 5, 0, 56, 37, 0, // Skip to: 24016
/* 14488 */   MCD::OPC_Decode, 252, 6, 106, // Opcode: VEXTL_Q_D
/* 14492 */   MCD::OPC_FilterValue, 195, 1, 61, 0, 0, // Skip to: 14559
/* 14498 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14501 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14534
/* 14506 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14509 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14525
/* 14514 */   MCD::OPC_CheckField, 13, 1, 1, 23, 37, 0, // Skip to: 24016
/* 14521 */   MCD::OPC_Decode, 154, 10, 109, // Opcode: VSLLWIL_HU_BU
/* 14525 */   MCD::OPC_FilterValue, 1, 14, 37, 0, // Skip to: 24016
/* 14530 */   MCD::OPC_Decode, 156, 10, 110, // Opcode: VSLLWIL_WU_HU
/* 14534 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 14543
/* 14539 */   MCD::OPC_Decode, 152, 10, 104, // Opcode: VSLLWIL_DU_WU
/* 14543 */   MCD::OPC_FilterValue, 2, 252, 36, 0, // Skip to: 24016
/* 14548 */   MCD::OPC_CheckField, 10, 5, 0, 245, 36, 0, // Skip to: 24016
/* 14555 */   MCD::OPC_Decode, 251, 6, 106, // Opcode: VEXTL_QU_DU
/* 14559 */   MCD::OPC_FilterValue, 196, 1, 62, 0, 0, // Skip to: 14627
/* 14565 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14568 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14618
/* 14573 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14576 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14609
/* 14581 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14584 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14600
/* 14589 */   MCD::OPC_CheckField, 13, 1, 1, 204, 36, 0, // Skip to: 24016
/* 14596 */   MCD::OPC_Decode, 187, 6, 109, // Opcode: VBITCLRI_B
/* 14600 */   MCD::OPC_FilterValue, 1, 195, 36, 0, // Skip to: 24016
/* 14605 */   MCD::OPC_Decode, 189, 6, 110, // Opcode: VBITCLRI_H
/* 14609 */   MCD::OPC_FilterValue, 1, 186, 36, 0, // Skip to: 24016
/* 14614 */   MCD::OPC_Decode, 190, 6, 104, // Opcode: VBITCLRI_W
/* 14618 */   MCD::OPC_FilterValue, 1, 177, 36, 0, // Skip to: 24016
/* 14623 */   MCD::OPC_Decode, 188, 6, 111, // Opcode: VBITCLRI_D
/* 14627 */   MCD::OPC_FilterValue, 197, 1, 62, 0, 0, // Skip to: 14695
/* 14633 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14636 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14686
/* 14641 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14644 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14677
/* 14649 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14652 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14668
/* 14657 */   MCD::OPC_CheckField, 13, 1, 1, 136, 36, 0, // Skip to: 24016
/* 14664 */   MCD::OPC_Decode, 205, 6, 109, // Opcode: VBITSETI_B
/* 14668 */   MCD::OPC_FilterValue, 1, 127, 36, 0, // Skip to: 24016
/* 14673 */   MCD::OPC_Decode, 207, 6, 110, // Opcode: VBITSETI_H
/* 14677 */   MCD::OPC_FilterValue, 1, 118, 36, 0, // Skip to: 24016
/* 14682 */   MCD::OPC_Decode, 208, 6, 104, // Opcode: VBITSETI_W
/* 14686 */   MCD::OPC_FilterValue, 1, 109, 36, 0, // Skip to: 24016
/* 14691 */   MCD::OPC_Decode, 206, 6, 111, // Opcode: VBITSETI_D
/* 14695 */   MCD::OPC_FilterValue, 198, 1, 62, 0, 0, // Skip to: 14763
/* 14701 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14704 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14754
/* 14709 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14712 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14745
/* 14717 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14720 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14736
/* 14725 */   MCD::OPC_CheckField, 13, 1, 1, 68, 36, 0, // Skip to: 24016
/* 14732 */   MCD::OPC_Decode, 195, 6, 109, // Opcode: VBITREVI_B
/* 14736 */   MCD::OPC_FilterValue, 1, 59, 36, 0, // Skip to: 24016
/* 14741 */   MCD::OPC_Decode, 197, 6, 110, // Opcode: VBITREVI_H
/* 14745 */   MCD::OPC_FilterValue, 1, 50, 36, 0, // Skip to: 24016
/* 14750 */   MCD::OPC_Decode, 198, 6, 104, // Opcode: VBITREVI_W
/* 14754 */   MCD::OPC_FilterValue, 1, 41, 36, 0, // Skip to: 24016
/* 14759 */   MCD::OPC_Decode, 196, 6, 111, // Opcode: VBITREVI_D
/* 14763 */   MCD::OPC_FilterValue, 201, 1, 62, 0, 0, // Skip to: 14831
/* 14769 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14772 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14822
/* 14777 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14780 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14813
/* 14785 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14788 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14804
/* 14793 */   MCD::OPC_CheckField, 13, 1, 1, 0, 36, 0, // Skip to: 24016
/* 14800 */   MCD::OPC_Decode, 222, 9, 109, // Opcode: VSAT_B
/* 14804 */   MCD::OPC_FilterValue, 1, 247, 35, 0, // Skip to: 24016
/* 14809 */   MCD::OPC_Decode, 226, 9, 110, // Opcode: VSAT_H
/* 14813 */   MCD::OPC_FilterValue, 1, 238, 35, 0, // Skip to: 24016
/* 14818 */   MCD::OPC_Decode, 228, 9, 104, // Opcode: VSAT_W
/* 14822 */   MCD::OPC_FilterValue, 1, 229, 35, 0, // Skip to: 24016
/* 14827 */   MCD::OPC_Decode, 224, 9, 111, // Opcode: VSAT_D
/* 14831 */   MCD::OPC_FilterValue, 202, 1, 62, 0, 0, // Skip to: 14899
/* 14837 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14840 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14890
/* 14845 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14848 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14881
/* 14853 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14856 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14872
/* 14861 */   MCD::OPC_CheckField, 13, 1, 1, 188, 35, 0, // Skip to: 24016
/* 14868 */   MCD::OPC_Decode, 223, 9, 109, // Opcode: VSAT_BU
/* 14872 */   MCD::OPC_FilterValue, 1, 179, 35, 0, // Skip to: 24016
/* 14877 */   MCD::OPC_Decode, 227, 9, 110, // Opcode: VSAT_HU
/* 14881 */   MCD::OPC_FilterValue, 1, 170, 35, 0, // Skip to: 24016
/* 14886 */   MCD::OPC_Decode, 229, 9, 104, // Opcode: VSAT_WU
/* 14890 */   MCD::OPC_FilterValue, 1, 161, 35, 0, // Skip to: 24016
/* 14895 */   MCD::OPC_Decode, 225, 9, 111, // Opcode: VSAT_DU
/* 14899 */   MCD::OPC_FilterValue, 203, 1, 62, 0, 0, // Skip to: 14967
/* 14905 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14908 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 14958
/* 14913 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14916 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 14949
/* 14921 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14924 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 14940
/* 14929 */   MCD::OPC_CheckField, 13, 1, 1, 120, 35, 0, // Skip to: 24016
/* 14936 */   MCD::OPC_Decode, 148, 10, 109, // Opcode: VSLLI_B
/* 14940 */   MCD::OPC_FilterValue, 1, 111, 35, 0, // Skip to: 24016
/* 14945 */   MCD::OPC_Decode, 150, 10, 110, // Opcode: VSLLI_H
/* 14949 */   MCD::OPC_FilterValue, 1, 102, 35, 0, // Skip to: 24016
/* 14954 */   MCD::OPC_Decode, 151, 10, 104, // Opcode: VSLLI_W
/* 14958 */   MCD::OPC_FilterValue, 1, 93, 35, 0, // Skip to: 24016
/* 14963 */   MCD::OPC_Decode, 149, 10, 111, // Opcode: VSLLI_D
/* 14967 */   MCD::OPC_FilterValue, 204, 1, 62, 0, 0, // Skip to: 15035
/* 14973 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 14976 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15026
/* 14981 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 14984 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15017
/* 14989 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 14992 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15008
/* 14997 */   MCD::OPC_CheckField, 13, 1, 1, 52, 35, 0, // Skip to: 24016
/* 15004 */   MCD::OPC_Decode, 208, 10, 109, // Opcode: VSRLI_B
/* 15008 */   MCD::OPC_FilterValue, 1, 43, 35, 0, // Skip to: 24016
/* 15013 */   MCD::OPC_Decode, 210, 10, 110, // Opcode: VSRLI_H
/* 15017 */   MCD::OPC_FilterValue, 1, 34, 35, 0, // Skip to: 24016
/* 15022 */   MCD::OPC_Decode, 211, 10, 104, // Opcode: VSRLI_W
/* 15026 */   MCD::OPC_FilterValue, 1, 25, 35, 0, // Skip to: 24016
/* 15031 */   MCD::OPC_Decode, 209, 10, 111, // Opcode: VSRLI_D
/* 15035 */   MCD::OPC_FilterValue, 205, 1, 62, 0, 0, // Skip to: 15103
/* 15041 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 15044 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15094
/* 15049 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15052 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15085
/* 15057 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 15060 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15076
/* 15065 */   MCD::OPC_CheckField, 13, 1, 1, 240, 34, 0, // Skip to: 24016
/* 15072 */   MCD::OPC_Decode, 178, 10, 109, // Opcode: VSRAI_B
/* 15076 */   MCD::OPC_FilterValue, 1, 231, 34, 0, // Skip to: 24016
/* 15081 */   MCD::OPC_Decode, 180, 10, 110, // Opcode: VSRAI_H
/* 15085 */   MCD::OPC_FilterValue, 1, 222, 34, 0, // Skip to: 24016
/* 15090 */   MCD::OPC_Decode, 181, 10, 104, // Opcode: VSRAI_W
/* 15094 */   MCD::OPC_FilterValue, 1, 213, 34, 0, // Skip to: 24016
/* 15099 */   MCD::OPC_Decode, 179, 10, 111, // Opcode: VSRAI_D
/* 15103 */   MCD::OPC_FilterValue, 208, 1, 62, 0, 0, // Skip to: 15171
/* 15109 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15112 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15162
/* 15117 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15120 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15153
/* 15125 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15128 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15144
/* 15133 */   MCD::OPC_CheckField, 14, 1, 1, 172, 34, 0, // Skip to: 24016
/* 15140 */   MCD::OPC_Decode, 212, 10, 122, // Opcode: VSRLNI_B_H
/* 15144 */   MCD::OPC_FilterValue, 1, 163, 34, 0, // Skip to: 24016
/* 15149 */   MCD::OPC_Decode, 214, 10, 105, // Opcode: VSRLNI_H_W
/* 15153 */   MCD::OPC_FilterValue, 1, 154, 34, 0, // Skip to: 24016
/* 15158 */   MCD::OPC_Decode, 215, 10, 123, // Opcode: VSRLNI_W_D
/* 15162 */   MCD::OPC_FilterValue, 1, 145, 34, 0, // Skip to: 24016
/* 15167 */   MCD::OPC_Decode, 213, 10, 124, // Opcode: VSRLNI_D_Q
/* 15171 */   MCD::OPC_FilterValue, 209, 1, 62, 0, 0, // Skip to: 15239
/* 15177 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15180 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15230
/* 15185 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15188 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15221
/* 15193 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15196 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15212
/* 15201 */   MCD::OPC_CheckField, 14, 1, 1, 104, 34, 0, // Skip to: 24016
/* 15208 */   MCD::OPC_Decode, 223, 10, 122, // Opcode: VSRLRNI_B_H
/* 15212 */   MCD::OPC_FilterValue, 1, 95, 34, 0, // Skip to: 24016
/* 15217 */   MCD::OPC_Decode, 225, 10, 105, // Opcode: VSRLRNI_H_W
/* 15221 */   MCD::OPC_FilterValue, 1, 86, 34, 0, // Skip to: 24016
/* 15226 */   MCD::OPC_Decode, 226, 10, 123, // Opcode: VSRLRNI_W_D
/* 15230 */   MCD::OPC_FilterValue, 1, 77, 34, 0, // Skip to: 24016
/* 15235 */   MCD::OPC_Decode, 224, 10, 124, // Opcode: VSRLRNI_D_Q
/* 15239 */   MCD::OPC_FilterValue, 210, 1, 62, 0, 0, // Skip to: 15307
/* 15245 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15248 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15298
/* 15253 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15256 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15289
/* 15261 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15264 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15280
/* 15269 */   MCD::OPC_CheckField, 14, 1, 1, 36, 34, 0, // Skip to: 24016
/* 15276 */   MCD::OPC_Decode, 139, 11, 122, // Opcode: VSSRLNI_B_H
/* 15280 */   MCD::OPC_FilterValue, 1, 27, 34, 0, // Skip to: 24016
/* 15285 */   MCD::OPC_Decode, 143, 11, 105, // Opcode: VSSRLNI_H_W
/* 15289 */   MCD::OPC_FilterValue, 1, 18, 34, 0, // Skip to: 24016
/* 15294 */   MCD::OPC_Decode, 145, 11, 123, // Opcode: VSSRLNI_W_D
/* 15298 */   MCD::OPC_FilterValue, 1, 9, 34, 0, // Skip to: 24016
/* 15303 */   MCD::OPC_Decode, 141, 11, 124, // Opcode: VSSRLNI_D_Q
/* 15307 */   MCD::OPC_FilterValue, 211, 1, 62, 0, 0, // Skip to: 15375
/* 15313 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15316 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15366
/* 15321 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15324 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15357
/* 15329 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15332 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15348
/* 15337 */   MCD::OPC_CheckField, 14, 1, 1, 224, 33, 0, // Skip to: 24016
/* 15344 */   MCD::OPC_Decode, 138, 11, 122, // Opcode: VSSRLNI_BU_H
/* 15348 */   MCD::OPC_FilterValue, 1, 215, 33, 0, // Skip to: 24016
/* 15353 */   MCD::OPC_Decode, 142, 11, 105, // Opcode: VSSRLNI_HU_W
/* 15357 */   MCD::OPC_FilterValue, 1, 206, 33, 0, // Skip to: 24016
/* 15362 */   MCD::OPC_Decode, 144, 11, 123, // Opcode: VSSRLNI_WU_D
/* 15366 */   MCD::OPC_FilterValue, 1, 197, 33, 0, // Skip to: 24016
/* 15371 */   MCD::OPC_Decode, 140, 11, 124, // Opcode: VSSRLNI_DU_Q
/* 15375 */   MCD::OPC_FilterValue, 212, 1, 62, 0, 0, // Skip to: 15443
/* 15381 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15384 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15434
/* 15389 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15392 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15425
/* 15397 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15400 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15416
/* 15405 */   MCD::OPC_CheckField, 14, 1, 1, 156, 33, 0, // Skip to: 24016
/* 15412 */   MCD::OPC_Decode, 153, 11, 122, // Opcode: VSSRLRNI_B_H
/* 15416 */   MCD::OPC_FilterValue, 1, 147, 33, 0, // Skip to: 24016
/* 15421 */   MCD::OPC_Decode, 157, 11, 105, // Opcode: VSSRLRNI_H_W
/* 15425 */   MCD::OPC_FilterValue, 1, 138, 33, 0, // Skip to: 24016
/* 15430 */   MCD::OPC_Decode, 159, 11, 123, // Opcode: VSSRLRNI_W_D
/* 15434 */   MCD::OPC_FilterValue, 1, 129, 33, 0, // Skip to: 24016
/* 15439 */   MCD::OPC_Decode, 155, 11, 124, // Opcode: VSSRLRNI_D_Q
/* 15443 */   MCD::OPC_FilterValue, 213, 1, 62, 0, 0, // Skip to: 15511
/* 15449 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15452 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15502
/* 15457 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15460 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15493
/* 15465 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15468 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15484
/* 15473 */   MCD::OPC_CheckField, 14, 1, 1, 88, 33, 0, // Skip to: 24016
/* 15480 */   MCD::OPC_Decode, 152, 11, 122, // Opcode: VSSRLRNI_BU_H
/* 15484 */   MCD::OPC_FilterValue, 1, 79, 33, 0, // Skip to: 24016
/* 15489 */   MCD::OPC_Decode, 156, 11, 105, // Opcode: VSSRLRNI_HU_W
/* 15493 */   MCD::OPC_FilterValue, 1, 70, 33, 0, // Skip to: 24016
/* 15498 */   MCD::OPC_Decode, 158, 11, 123, // Opcode: VSSRLRNI_WU_D
/* 15502 */   MCD::OPC_FilterValue, 1, 61, 33, 0, // Skip to: 24016
/* 15507 */   MCD::OPC_Decode, 154, 11, 124, // Opcode: VSSRLRNI_DU_Q
/* 15511 */   MCD::OPC_FilterValue, 214, 1, 62, 0, 0, // Skip to: 15579
/* 15517 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15520 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15570
/* 15525 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15528 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15561
/* 15533 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15536 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15552
/* 15541 */   MCD::OPC_CheckField, 14, 1, 1, 20, 33, 0, // Skip to: 24016
/* 15548 */   MCD::OPC_Decode, 182, 10, 122, // Opcode: VSRANI_B_H
/* 15552 */   MCD::OPC_FilterValue, 1, 11, 33, 0, // Skip to: 24016
/* 15557 */   MCD::OPC_Decode, 184, 10, 105, // Opcode: VSRANI_H_W
/* 15561 */   MCD::OPC_FilterValue, 1, 2, 33, 0, // Skip to: 24016
/* 15566 */   MCD::OPC_Decode, 185, 10, 123, // Opcode: VSRANI_W_D
/* 15570 */   MCD::OPC_FilterValue, 1, 249, 32, 0, // Skip to: 24016
/* 15575 */   MCD::OPC_Decode, 183, 10, 124, // Opcode: VSRANI_D_Q
/* 15579 */   MCD::OPC_FilterValue, 215, 1, 62, 0, 0, // Skip to: 15647
/* 15585 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15588 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15638
/* 15593 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15596 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15629
/* 15601 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15604 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15620
/* 15609 */   MCD::OPC_CheckField, 14, 1, 1, 208, 32, 0, // Skip to: 24016
/* 15616 */   MCD::OPC_Decode, 193, 10, 122, // Opcode: VSRARNI_B_H
/* 15620 */   MCD::OPC_FilterValue, 1, 199, 32, 0, // Skip to: 24016
/* 15625 */   MCD::OPC_Decode, 195, 10, 105, // Opcode: VSRARNI_H_W
/* 15629 */   MCD::OPC_FilterValue, 1, 190, 32, 0, // Skip to: 24016
/* 15634 */   MCD::OPC_Decode, 196, 10, 123, // Opcode: VSRARNI_W_D
/* 15638 */   MCD::OPC_FilterValue, 1, 181, 32, 0, // Skip to: 24016
/* 15643 */   MCD::OPC_Decode, 194, 10, 124, // Opcode: VSRARNI_D_Q
/* 15647 */   MCD::OPC_FilterValue, 216, 1, 62, 0, 0, // Skip to: 15715
/* 15653 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15656 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15706
/* 15661 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15664 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15697
/* 15669 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15672 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15688
/* 15677 */   MCD::OPC_CheckField, 14, 1, 1, 140, 32, 0, // Skip to: 24016
/* 15684 */   MCD::OPC_Decode, 239, 10, 122, // Opcode: VSSRANI_B_H
/* 15688 */   MCD::OPC_FilterValue, 1, 131, 32, 0, // Skip to: 24016
/* 15693 */   MCD::OPC_Decode, 243, 10, 105, // Opcode: VSSRANI_H_W
/* 15697 */   MCD::OPC_FilterValue, 1, 122, 32, 0, // Skip to: 24016
/* 15702 */   MCD::OPC_Decode, 245, 10, 123, // Opcode: VSSRANI_W_D
/* 15706 */   MCD::OPC_FilterValue, 1, 113, 32, 0, // Skip to: 24016
/* 15711 */   MCD::OPC_Decode, 241, 10, 124, // Opcode: VSSRANI_D_Q
/* 15715 */   MCD::OPC_FilterValue, 217, 1, 62, 0, 0, // Skip to: 15783
/* 15721 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15724 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15774
/* 15729 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15732 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15765
/* 15737 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15740 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15756
/* 15745 */   MCD::OPC_CheckField, 14, 1, 1, 72, 32, 0, // Skip to: 24016
/* 15752 */   MCD::OPC_Decode, 238, 10, 122, // Opcode: VSSRANI_BU_H
/* 15756 */   MCD::OPC_FilterValue, 1, 63, 32, 0, // Skip to: 24016
/* 15761 */   MCD::OPC_Decode, 242, 10, 105, // Opcode: VSSRANI_HU_W
/* 15765 */   MCD::OPC_FilterValue, 1, 54, 32, 0, // Skip to: 24016
/* 15770 */   MCD::OPC_Decode, 244, 10, 123, // Opcode: VSSRANI_WU_D
/* 15774 */   MCD::OPC_FilterValue, 1, 45, 32, 0, // Skip to: 24016
/* 15779 */   MCD::OPC_Decode, 240, 10, 124, // Opcode: VSSRANI_DU_Q
/* 15783 */   MCD::OPC_FilterValue, 218, 1, 62, 0, 0, // Skip to: 15851
/* 15789 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15792 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15842
/* 15797 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15800 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15833
/* 15805 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15808 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15824
/* 15813 */   MCD::OPC_CheckField, 14, 1, 1, 4, 32, 0, // Skip to: 24016
/* 15820 */   MCD::OPC_Decode, 253, 10, 122, // Opcode: VSSRARNI_B_H
/* 15824 */   MCD::OPC_FilterValue, 1, 251, 31, 0, // Skip to: 24016
/* 15829 */   MCD::OPC_Decode, 129, 11, 105, // Opcode: VSSRARNI_H_W
/* 15833 */   MCD::OPC_FilterValue, 1, 242, 31, 0, // Skip to: 24016
/* 15838 */   MCD::OPC_Decode, 131, 11, 123, // Opcode: VSSRARNI_W_D
/* 15842 */   MCD::OPC_FilterValue, 1, 233, 31, 0, // Skip to: 24016
/* 15847 */   MCD::OPC_Decode, 255, 10, 124, // Opcode: VSSRARNI_D_Q
/* 15851 */   MCD::OPC_FilterValue, 219, 1, 62, 0, 0, // Skip to: 15919
/* 15857 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 15860 */   MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 15910
/* 15865 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 15868 */   MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 15901
/* 15873 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 15876 */   MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 15892
/* 15881 */   MCD::OPC_CheckField, 14, 1, 1, 192, 31, 0, // Skip to: 24016
/* 15888 */   MCD::OPC_Decode, 252, 10, 122, // Opcode: VSSRARNI_BU_H
/* 15892 */   MCD::OPC_FilterValue, 1, 183, 31, 0, // Skip to: 24016
/* 15897 */   MCD::OPC_Decode, 128, 11, 105, // Opcode: VSSRARNI_HU_W
/* 15901 */   MCD::OPC_FilterValue, 1, 174, 31, 0, // Skip to: 24016
/* 15906 */   MCD::OPC_Decode, 130, 11, 123, // Opcode: VSSRARNI_WU_D
/* 15910 */   MCD::OPC_FilterValue, 1, 165, 31, 0, // Skip to: 24016
/* 15915 */   MCD::OPC_Decode, 254, 10, 124, // Opcode: VSSRARNI_DU_Q
/* 15919 */   MCD::OPC_FilterValue, 224, 1, 4, 0, 0, // Skip to: 15929
/* 15925 */   MCD::OPC_Decode, 254, 6, 125, // Opcode: VEXTRINS_D
/* 15929 */   MCD::OPC_FilterValue, 225, 1, 4, 0, 0, // Skip to: 15939
/* 15935 */   MCD::OPC_Decode, 128, 7, 125, // Opcode: VEXTRINS_W
/* 15939 */   MCD::OPC_FilterValue, 226, 1, 4, 0, 0, // Skip to: 15949
/* 15945 */   MCD::OPC_Decode, 255, 6, 125, // Opcode: VEXTRINS_H
/* 15949 */   MCD::OPC_FilterValue, 227, 1, 4, 0, 0, // Skip to: 15959
/* 15955 */   MCD::OPC_Decode, 253, 6, 125, // Opcode: VEXTRINS_B
/* 15959 */   MCD::OPC_FilterValue, 228, 1, 4, 0, 0, // Skip to: 15969
/* 15965 */   MCD::OPC_Decode, 248, 9, 126, // Opcode: VSHUF4I_B
/* 15969 */   MCD::OPC_FilterValue, 229, 1, 4, 0, 0, // Skip to: 15979
/* 15975 */   MCD::OPC_Decode, 250, 9, 126, // Opcode: VSHUF4I_H
/* 15979 */   MCD::OPC_FilterValue, 230, 1, 4, 0, 0, // Skip to: 15989
/* 15985 */   MCD::OPC_Decode, 251, 9, 126, // Opcode: VSHUF4I_W
/* 15989 */   MCD::OPC_FilterValue, 231, 1, 4, 0, 0, // Skip to: 15999
/* 15995 */   MCD::OPC_Decode, 249, 9, 125, // Opcode: VSHUF4I_D
/* 15999 */   MCD::OPC_FilterValue, 241, 1, 4, 0, 0, // Skip to: 16009
/* 16005 */   MCD::OPC_Decode, 203, 6, 125, // Opcode: VBITSELI_B
/* 16009 */   MCD::OPC_FilterValue, 244, 1, 4, 0, 0, // Skip to: 16019
/* 16015 */   MCD::OPC_Decode, 168, 6, 126, // Opcode: VANDI_B
/* 16019 */   MCD::OPC_FilterValue, 245, 1, 4, 0, 0, // Skip to: 16029
/* 16025 */   MCD::OPC_Decode, 162, 9, 126, // Opcode: VORI_B
/* 16029 */   MCD::OPC_FilterValue, 246, 1, 4, 0, 0, // Skip to: 16039
/* 16035 */   MCD::OPC_Decode, 205, 11, 126, // Opcode: VXORI_B
/* 16039 */   MCD::OPC_FilterValue, 247, 1, 4, 0, 0, // Skip to: 16049
/* 16045 */   MCD::OPC_Decode, 160, 9, 126, // Opcode: VNORI_B
/* 16049 */   MCD::OPC_FilterValue, 248, 1, 4, 0, 0, // Skip to: 16059
/* 16055 */   MCD::OPC_Decode, 164, 8, 127, // Opcode: VLDI
/* 16059 */   MCD::OPC_FilterValue, 249, 1, 15, 31, 0, // Skip to: 24016
/* 16065 */   MCD::OPC_Decode, 177, 9, 125, // Opcode: VPERMI_W
/* 16069 */   MCD::OPC_FilterValue, 29, 6, 31, 0, // Skip to: 24016
/* 16074 */   MCD::OPC_ExtractField, 18, 8,  // Inst{25-18} ...
/* 16077 */   MCD::OPC_FilterValue, 0, 75, 0, 0, // Skip to: 16157
/* 16082 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16085 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16094
/* 16090 */   MCD::OPC_Decode, 172, 16, 64, // Opcode: XVSEQ_B
/* 16094 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16103
/* 16099 */   MCD::OPC_Decode, 174, 16, 64, // Opcode: XVSEQ_H
/* 16103 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16112
/* 16108 */   MCD::OPC_Decode, 175, 16, 64, // Opcode: XVSEQ_W
/* 16112 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16121
/* 16117 */   MCD::OPC_Decode, 173, 16, 64, // Opcode: XVSEQ_D
/* 16121 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16130
/* 16126 */   MCD::OPC_Decode, 206, 16, 64, // Opcode: XVSLE_B
/* 16130 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16139
/* 16135 */   MCD::OPC_Decode, 210, 16, 64, // Opcode: XVSLE_H
/* 16139 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16148
/* 16144 */   MCD::OPC_Decode, 212, 16, 64, // Opcode: XVSLE_W
/* 16148 */   MCD::OPC_FilterValue, 7, 183, 30, 0, // Skip to: 24016
/* 16153 */   MCD::OPC_Decode, 208, 16, 64, // Opcode: XVSLE_D
/* 16157 */   MCD::OPC_FilterValue, 1, 75, 0, 0, // Skip to: 16237
/* 16162 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16165 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16174
/* 16170 */   MCD::OPC_Decode, 207, 16, 64, // Opcode: XVSLE_BU
/* 16174 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16183
/* 16179 */   MCD::OPC_Decode, 211, 16, 64, // Opcode: XVSLE_HU
/* 16183 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16192
/* 16188 */   MCD::OPC_Decode, 213, 16, 64, // Opcode: XVSLE_WU
/* 16192 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16201
/* 16197 */   MCD::OPC_Decode, 209, 16, 64, // Opcode: XVSLE_DU
/* 16201 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16210
/* 16206 */   MCD::OPC_Decode, 236, 16, 64, // Opcode: XVSLT_B
/* 16210 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16219
/* 16215 */   MCD::OPC_Decode, 240, 16, 64, // Opcode: XVSLT_H
/* 16219 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16228
/* 16224 */   MCD::OPC_Decode, 242, 16, 64, // Opcode: XVSLT_W
/* 16228 */   MCD::OPC_FilterValue, 7, 103, 30, 0, // Skip to: 24016
/* 16233 */   MCD::OPC_Decode, 238, 16, 64, // Opcode: XVSLT_D
/* 16237 */   MCD::OPC_FilterValue, 2, 75, 0, 0, // Skip to: 16317
/* 16242 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16245 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16254
/* 16250 */   MCD::OPC_Decode, 237, 16, 64, // Opcode: XVSLT_BU
/* 16254 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16263
/* 16259 */   MCD::OPC_Decode, 241, 16, 64, // Opcode: XVSLT_HU
/* 16263 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16272
/* 16268 */   MCD::OPC_Decode, 243, 16, 64, // Opcode: XVSLT_WU
/* 16272 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16281
/* 16277 */   MCD::OPC_Decode, 239, 16, 64, // Opcode: XVSLT_DU
/* 16281 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16290
/* 16286 */   MCD::OPC_Decode, 234, 12, 64, // Opcode: XVADD_B
/* 16290 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16299
/* 16295 */   MCD::OPC_Decode, 236, 12, 64, // Opcode: XVADD_H
/* 16299 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16308
/* 16304 */   MCD::OPC_Decode, 238, 12, 64, // Opcode: XVADD_W
/* 16308 */   MCD::OPC_FilterValue, 7, 23, 30, 0, // Skip to: 24016
/* 16313 */   MCD::OPC_Decode, 235, 12, 64, // Opcode: XVADD_D
/* 16317 */   MCD::OPC_FilterValue, 3, 39, 0, 0, // Skip to: 16361
/* 16322 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16325 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16334
/* 16330 */   MCD::OPC_Decode, 138, 18, 64, // Opcode: XVSUB_B
/* 16334 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16343
/* 16339 */   MCD::OPC_Decode, 140, 18, 64, // Opcode: XVSUB_H
/* 16343 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16352
/* 16348 */   MCD::OPC_Decode, 142, 18, 64, // Opcode: XVSUB_W
/* 16352 */   MCD::OPC_FilterValue, 3, 235, 29, 0, // Skip to: 24016
/* 16357 */   MCD::OPC_Decode, 139, 18, 64, // Opcode: XVSUB_D
/* 16361 */   MCD::OPC_FilterValue, 7, 39, 0, 0, // Skip to: 16405
/* 16366 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16369 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16378
/* 16374 */   MCD::OPC_Decode, 213, 12, 64, // Opcode: XVADDWEV_H_B
/* 16378 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16387
/* 16383 */   MCD::OPC_Decode, 219, 12, 64, // Opcode: XVADDWEV_W_H
/* 16387 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16396
/* 16392 */   MCD::OPC_Decode, 210, 12, 64, // Opcode: XVADDWEV_D_W
/* 16396 */   MCD::OPC_FilterValue, 7, 191, 29, 0, // Skip to: 24016
/* 16401 */   MCD::OPC_Decode, 216, 12, 64, // Opcode: XVADDWEV_Q_D
/* 16405 */   MCD::OPC_FilterValue, 8, 75, 0, 0, // Skip to: 16485
/* 16410 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16413 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16422
/* 16418 */   MCD::OPC_Decode, 252, 17, 64, // Opcode: XVSUBWEV_H_B
/* 16422 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16431
/* 16427 */   MCD::OPC_Decode, 128, 18, 64, // Opcode: XVSUBWEV_W_H
/* 16431 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16440
/* 16436 */   MCD::OPC_Decode, 250, 17, 64, // Opcode: XVSUBWEV_D_W
/* 16440 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16449
/* 16445 */   MCD::OPC_Decode, 254, 17, 64, // Opcode: XVSUBWEV_Q_D
/* 16449 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16458
/* 16454 */   MCD::OPC_Decode, 225, 12, 64, // Opcode: XVADDWOD_H_B
/* 16458 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16467
/* 16463 */   MCD::OPC_Decode, 231, 12, 64, // Opcode: XVADDWOD_W_H
/* 16467 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16476
/* 16472 */   MCD::OPC_Decode, 222, 12, 64, // Opcode: XVADDWOD_D_W
/* 16476 */   MCD::OPC_FilterValue, 7, 111, 29, 0, // Skip to: 24016
/* 16481 */   MCD::OPC_Decode, 228, 12, 64, // Opcode: XVADDWOD_Q_D
/* 16485 */   MCD::OPC_FilterValue, 9, 39, 0, 0, // Skip to: 16529
/* 16490 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16493 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16502
/* 16498 */   MCD::OPC_Decode, 132, 18, 64, // Opcode: XVSUBWOD_H_B
/* 16502 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16511
/* 16507 */   MCD::OPC_Decode, 136, 18, 64, // Opcode: XVSUBWOD_W_H
/* 16511 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16520
/* 16516 */   MCD::OPC_Decode, 130, 18, 64, // Opcode: XVSUBWOD_D_W
/* 16520 */   MCD::OPC_FilterValue, 3, 67, 29, 0, // Skip to: 24016
/* 16525 */   MCD::OPC_Decode, 134, 18, 64, // Opcode: XVSUBWOD_Q_D
/* 16529 */   MCD::OPC_FilterValue, 11, 39, 0, 0, // Skip to: 16573
/* 16534 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16537 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16546
/* 16542 */   MCD::OPC_Decode, 214, 12, 64, // Opcode: XVADDWEV_H_BU
/* 16546 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16555
/* 16551 */   MCD::OPC_Decode, 220, 12, 64, // Opcode: XVADDWEV_W_HU
/* 16555 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16564
/* 16560 */   MCD::OPC_Decode, 211, 12, 64, // Opcode: XVADDWEV_D_WU
/* 16564 */   MCD::OPC_FilterValue, 7, 23, 29, 0, // Skip to: 24016
/* 16569 */   MCD::OPC_Decode, 217, 12, 64, // Opcode: XVADDWEV_Q_DU
/* 16573 */   MCD::OPC_FilterValue, 12, 75, 0, 0, // Skip to: 16653
/* 16578 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16581 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16590
/* 16586 */   MCD::OPC_Decode, 253, 17, 64, // Opcode: XVSUBWEV_H_BU
/* 16590 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16599
/* 16595 */   MCD::OPC_Decode, 129, 18, 64, // Opcode: XVSUBWEV_W_HU
/* 16599 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16608
/* 16604 */   MCD::OPC_Decode, 251, 17, 64, // Opcode: XVSUBWEV_D_WU
/* 16608 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16617
/* 16613 */   MCD::OPC_Decode, 255, 17, 64, // Opcode: XVSUBWEV_Q_DU
/* 16617 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16626
/* 16622 */   MCD::OPC_Decode, 226, 12, 64, // Opcode: XVADDWOD_H_BU
/* 16626 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16635
/* 16631 */   MCD::OPC_Decode, 232, 12, 64, // Opcode: XVADDWOD_W_HU
/* 16635 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16644
/* 16640 */   MCD::OPC_Decode, 223, 12, 64, // Opcode: XVADDWOD_D_WU
/* 16644 */   MCD::OPC_FilterValue, 7, 199, 28, 0, // Skip to: 24016
/* 16649 */   MCD::OPC_Decode, 229, 12, 64, // Opcode: XVADDWOD_Q_DU
/* 16653 */   MCD::OPC_FilterValue, 13, 39, 0, 0, // Skip to: 16697
/* 16658 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16661 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16670
/* 16666 */   MCD::OPC_Decode, 133, 18, 64, // Opcode: XVSUBWOD_H_BU
/* 16670 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16679
/* 16675 */   MCD::OPC_Decode, 137, 18, 64, // Opcode: XVSUBWOD_W_HU
/* 16679 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16688
/* 16684 */   MCD::OPC_Decode, 131, 18, 64, // Opcode: XVSUBWOD_D_WU
/* 16688 */   MCD::OPC_FilterValue, 3, 155, 28, 0, // Skip to: 24016
/* 16693 */   MCD::OPC_Decode, 135, 18, 64, // Opcode: XVSUBWOD_Q_DU
/* 16697 */   MCD::OPC_FilterValue, 15, 39, 0, 0, // Skip to: 16741
/* 16702 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16705 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16714
/* 16710 */   MCD::OPC_Decode, 215, 12, 64, // Opcode: XVADDWEV_H_BU_B
/* 16714 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16723
/* 16719 */   MCD::OPC_Decode, 221, 12, 64, // Opcode: XVADDWEV_W_HU_H
/* 16723 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16732
/* 16728 */   MCD::OPC_Decode, 212, 12, 64, // Opcode: XVADDWEV_D_WU_W
/* 16732 */   MCD::OPC_FilterValue, 7, 111, 28, 0, // Skip to: 24016
/* 16737 */   MCD::OPC_Decode, 218, 12, 64, // Opcode: XVADDWEV_Q_DU_D
/* 16741 */   MCD::OPC_FilterValue, 16, 39, 0, 0, // Skip to: 16785
/* 16746 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16749 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16758
/* 16754 */   MCD::OPC_Decode, 227, 12, 64, // Opcode: XVADDWOD_H_BU_B
/* 16758 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16767
/* 16763 */   MCD::OPC_Decode, 233, 12, 64, // Opcode: XVADDWOD_W_HU_H
/* 16767 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16776
/* 16772 */   MCD::OPC_Decode, 224, 12, 64, // Opcode: XVADDWOD_D_WU_W
/* 16776 */   MCD::OPC_FilterValue, 3, 67, 28, 0, // Skip to: 24016
/* 16781 */   MCD::OPC_Decode, 230, 12, 64, // Opcode: XVADDWOD_Q_DU_D
/* 16785 */   MCD::OPC_FilterValue, 17, 39, 0, 0, // Skip to: 16829
/* 16790 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16793 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16802
/* 16798 */   MCD::OPC_Decode, 152, 16, 64, // Opcode: XVSADD_B
/* 16802 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16811
/* 16807 */   MCD::OPC_Decode, 156, 16, 64, // Opcode: XVSADD_H
/* 16811 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16820
/* 16816 */   MCD::OPC_Decode, 158, 16, 64, // Opcode: XVSADD_W
/* 16820 */   MCD::OPC_FilterValue, 7, 23, 28, 0, // Skip to: 24016
/* 16825 */   MCD::OPC_Decode, 154, 16, 64, // Opcode: XVSADD_D
/* 16829 */   MCD::OPC_FilterValue, 18, 75, 0, 0, // Skip to: 16909
/* 16834 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16837 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16846
/* 16842 */   MCD::OPC_Decode, 232, 17, 64, // Opcode: XVSSUB_B
/* 16846 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16855
/* 16851 */   MCD::OPC_Decode, 236, 17, 64, // Opcode: XVSSUB_H
/* 16855 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16864
/* 16860 */   MCD::OPC_Decode, 238, 17, 64, // Opcode: XVSSUB_W
/* 16864 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16873
/* 16869 */   MCD::OPC_Decode, 234, 17, 64, // Opcode: XVSSUB_D
/* 16873 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 16882
/* 16878 */   MCD::OPC_Decode, 153, 16, 64, // Opcode: XVSADD_BU
/* 16882 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 16891
/* 16887 */   MCD::OPC_Decode, 157, 16, 64, // Opcode: XVSADD_HU
/* 16891 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 16900
/* 16896 */   MCD::OPC_Decode, 159, 16, 64, // Opcode: XVSADD_WU
/* 16900 */   MCD::OPC_FilterValue, 7, 199, 27, 0, // Skip to: 24016
/* 16905 */   MCD::OPC_Decode, 155, 16, 64, // Opcode: XVSADD_DU
/* 16909 */   MCD::OPC_FilterValue, 19, 39, 0, 0, // Skip to: 16953
/* 16914 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16917 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16926
/* 16922 */   MCD::OPC_Decode, 233, 17, 64, // Opcode: XVSSUB_BU
/* 16926 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16935
/* 16931 */   MCD::OPC_Decode, 237, 17, 64, // Opcode: XVSSUB_HU
/* 16935 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16944
/* 16940 */   MCD::OPC_Decode, 239, 17, 64, // Opcode: XVSSUB_WU
/* 16944 */   MCD::OPC_FilterValue, 3, 155, 27, 0, // Skip to: 24016
/* 16949 */   MCD::OPC_Decode, 235, 17, 64, // Opcode: XVSSUB_DU
/* 16953 */   MCD::OPC_FilterValue, 21, 75, 0, 0, // Skip to: 17033
/* 16958 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16961 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 16970
/* 16966 */   MCD::OPC_Decode, 197, 14, 64, // Opcode: XVHADDW_H_B
/* 16970 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 16979
/* 16975 */   MCD::OPC_Decode, 201, 14, 64, // Opcode: XVHADDW_W_H
/* 16979 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 16988
/* 16984 */   MCD::OPC_Decode, 195, 14, 64, // Opcode: XVHADDW_D_W
/* 16988 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 16997
/* 16993 */   MCD::OPC_Decode, 199, 14, 64, // Opcode: XVHADDW_Q_D
/* 16997 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17006
/* 17002 */   MCD::OPC_Decode, 206, 14, 64, // Opcode: XVHSUBW_H_B
/* 17006 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17015
/* 17011 */   MCD::OPC_Decode, 210, 14, 64, // Opcode: XVHSUBW_W_H
/* 17015 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17024
/* 17020 */   MCD::OPC_Decode, 204, 14, 64, // Opcode: XVHSUBW_D_W
/* 17024 */   MCD::OPC_FilterValue, 7, 75, 27, 0, // Skip to: 24016
/* 17029 */   MCD::OPC_Decode, 208, 14, 64, // Opcode: XVHSUBW_Q_D
/* 17033 */   MCD::OPC_FilterValue, 22, 75, 0, 0, // Skip to: 17113
/* 17038 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17041 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17050
/* 17046 */   MCD::OPC_Decode, 196, 14, 64, // Opcode: XVHADDW_HU_BU
/* 17050 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17059
/* 17055 */   MCD::OPC_Decode, 200, 14, 64, // Opcode: XVHADDW_WU_HU
/* 17059 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17068
/* 17064 */   MCD::OPC_Decode, 194, 14, 64, // Opcode: XVHADDW_DU_WU
/* 17068 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17077
/* 17073 */   MCD::OPC_Decode, 198, 14, 64, // Opcode: XVHADDW_QU_DU
/* 17077 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17086
/* 17082 */   MCD::OPC_Decode, 205, 14, 64, // Opcode: XVHSUBW_HU_BU
/* 17086 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17095
/* 17091 */   MCD::OPC_Decode, 209, 14, 64, // Opcode: XVHSUBW_WU_HU
/* 17095 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17104
/* 17100 */   MCD::OPC_Decode, 203, 14, 64, // Opcode: XVHSUBW_DU_WU
/* 17104 */   MCD::OPC_FilterValue, 7, 251, 26, 0, // Skip to: 24016
/* 17109 */   MCD::OPC_Decode, 207, 14, 64, // Opcode: XVHSUBW_QU_DU
/* 17113 */   MCD::OPC_FilterValue, 23, 39, 0, 0, // Skip to: 17157
/* 17118 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17121 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17130
/* 17126 */   MCD::OPC_Decode, 202, 12, 64, // Opcode: XVADDA_B
/* 17130 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17139
/* 17135 */   MCD::OPC_Decode, 204, 12, 64, // Opcode: XVADDA_H
/* 17139 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17148
/* 17144 */   MCD::OPC_Decode, 205, 12, 64, // Opcode: XVADDA_W
/* 17148 */   MCD::OPC_FilterValue, 3, 207, 26, 0, // Skip to: 24016
/* 17153 */   MCD::OPC_Decode, 203, 12, 64, // Opcode: XVADDA_D
/* 17157 */   MCD::OPC_FilterValue, 24, 75, 0, 0, // Skip to: 17237
/* 17162 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17165 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17174
/* 17170 */   MCD::OPC_Decode, 194, 12, 64, // Opcode: XVABSD_B
/* 17174 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17183
/* 17179 */   MCD::OPC_Decode, 198, 12, 64, // Opcode: XVABSD_H
/* 17183 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17192
/* 17188 */   MCD::OPC_Decode, 200, 12, 64, // Opcode: XVABSD_W
/* 17192 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17201
/* 17197 */   MCD::OPC_Decode, 196, 12, 64, // Opcode: XVABSD_D
/* 17201 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17210
/* 17206 */   MCD::OPC_Decode, 195, 12, 64, // Opcode: XVABSD_BU
/* 17210 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17219
/* 17215 */   MCD::OPC_Decode, 199, 12, 64, // Opcode: XVABSD_HU
/* 17219 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17228
/* 17224 */   MCD::OPC_Decode, 201, 12, 64, // Opcode: XVABSD_WU
/* 17228 */   MCD::OPC_FilterValue, 7, 127, 26, 0, // Skip to: 24016
/* 17233 */   MCD::OPC_Decode, 197, 12, 64, // Opcode: XVABSD_DU
/* 17237 */   MCD::OPC_FilterValue, 25, 75, 0, 0, // Skip to: 17317
/* 17242 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17245 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17254
/* 17250 */   MCD::OPC_Decode, 250, 12, 64, // Opcode: XVAVG_B
/* 17254 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17263
/* 17259 */   MCD::OPC_Decode, 254, 12, 64, // Opcode: XVAVG_H
/* 17263 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17272
/* 17268 */   MCD::OPC_Decode, 128, 13, 64, // Opcode: XVAVG_W
/* 17272 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17281
/* 17277 */   MCD::OPC_Decode, 252, 12, 64, // Opcode: XVAVG_D
/* 17281 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17290
/* 17286 */   MCD::OPC_Decode, 251, 12, 64, // Opcode: XVAVG_BU
/* 17290 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17299
/* 17295 */   MCD::OPC_Decode, 255, 12, 64, // Opcode: XVAVG_HU
/* 17299 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17308
/* 17304 */   MCD::OPC_Decode, 129, 13, 64, // Opcode: XVAVG_WU
/* 17308 */   MCD::OPC_FilterValue, 7, 47, 26, 0, // Skip to: 24016
/* 17313 */   MCD::OPC_Decode, 253, 12, 64, // Opcode: XVAVG_DU
/* 17317 */   MCD::OPC_FilterValue, 26, 75, 0, 0, // Skip to: 17397
/* 17322 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17325 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17334
/* 17330 */   MCD::OPC_Decode, 242, 12, 64, // Opcode: XVAVGR_B
/* 17334 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17343
/* 17339 */   MCD::OPC_Decode, 246, 12, 64, // Opcode: XVAVGR_H
/* 17343 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17352
/* 17348 */   MCD::OPC_Decode, 248, 12, 64, // Opcode: XVAVGR_W
/* 17352 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17361
/* 17357 */   MCD::OPC_Decode, 244, 12, 64, // Opcode: XVAVGR_D
/* 17361 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17370
/* 17366 */   MCD::OPC_Decode, 243, 12, 64, // Opcode: XVAVGR_BU
/* 17370 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17379
/* 17375 */   MCD::OPC_Decode, 247, 12, 64, // Opcode: XVAVGR_HU
/* 17379 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17388
/* 17384 */   MCD::OPC_Decode, 249, 12, 64, // Opcode: XVAVGR_WU
/* 17388 */   MCD::OPC_FilterValue, 7, 223, 25, 0, // Skip to: 24016
/* 17393 */   MCD::OPC_Decode, 245, 12, 64, // Opcode: XVAVGR_DU
/* 17397 */   MCD::OPC_FilterValue, 28, 75, 0, 0, // Skip to: 17477
/* 17402 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17405 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17414
/* 17410 */   MCD::OPC_Decode, 138, 15, 64, // Opcode: XVMAX_B
/* 17414 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17423
/* 17419 */   MCD::OPC_Decode, 142, 15, 64, // Opcode: XVMAX_H
/* 17423 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17432
/* 17428 */   MCD::OPC_Decode, 144, 15, 64, // Opcode: XVMAX_W
/* 17432 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17441
/* 17437 */   MCD::OPC_Decode, 140, 15, 64, // Opcode: XVMAX_D
/* 17441 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17450
/* 17446 */   MCD::OPC_Decode, 154, 15, 64, // Opcode: XVMIN_B
/* 17450 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17459
/* 17455 */   MCD::OPC_Decode, 158, 15, 64, // Opcode: XVMIN_H
/* 17459 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17468
/* 17464 */   MCD::OPC_Decode, 160, 15, 64, // Opcode: XVMIN_W
/* 17468 */   MCD::OPC_FilterValue, 7, 143, 25, 0, // Skip to: 24016
/* 17473 */   MCD::OPC_Decode, 156, 15, 64, // Opcode: XVMIN_D
/* 17477 */   MCD::OPC_FilterValue, 29, 75, 0, 0, // Skip to: 17557
/* 17482 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17485 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17494
/* 17490 */   MCD::OPC_Decode, 139, 15, 64, // Opcode: XVMAX_BU
/* 17494 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17503
/* 17499 */   MCD::OPC_Decode, 143, 15, 64, // Opcode: XVMAX_HU
/* 17503 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17512
/* 17508 */   MCD::OPC_Decode, 145, 15, 64, // Opcode: XVMAX_WU
/* 17512 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17521
/* 17517 */   MCD::OPC_Decode, 141, 15, 64, // Opcode: XVMAX_DU
/* 17521 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17530
/* 17526 */   MCD::OPC_Decode, 155, 15, 64, // Opcode: XVMIN_BU
/* 17530 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17539
/* 17535 */   MCD::OPC_Decode, 159, 15, 64, // Opcode: XVMIN_HU
/* 17539 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17548
/* 17544 */   MCD::OPC_Decode, 161, 15, 64, // Opcode: XVMIN_WU
/* 17548 */   MCD::OPC_FilterValue, 7, 63, 25, 0, // Skip to: 24016
/* 17553 */   MCD::OPC_Decode, 157, 15, 64, // Opcode: XVMIN_DU
/* 17557 */   MCD::OPC_FilterValue, 33, 75, 0, 0, // Skip to: 17637
/* 17562 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17565 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17574
/* 17570 */   MCD::OPC_Decode, 212, 15, 64, // Opcode: XVMUL_B
/* 17574 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17583
/* 17579 */   MCD::OPC_Decode, 214, 15, 64, // Opcode: XVMUL_H
/* 17583 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17592
/* 17588 */   MCD::OPC_Decode, 215, 15, 64, // Opcode: XVMUL_W
/* 17592 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17601
/* 17597 */   MCD::OPC_Decode, 213, 15, 64, // Opcode: XVMUL_D
/* 17601 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17610
/* 17606 */   MCD::OPC_Decode, 180, 15, 64, // Opcode: XVMUH_B
/* 17610 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17619
/* 17615 */   MCD::OPC_Decode, 184, 15, 64, // Opcode: XVMUH_H
/* 17619 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17628
/* 17624 */   MCD::OPC_Decode, 186, 15, 64, // Opcode: XVMUH_W
/* 17628 */   MCD::OPC_FilterValue, 7, 239, 24, 0, // Skip to: 24016
/* 17633 */   MCD::OPC_Decode, 182, 15, 64, // Opcode: XVMUH_D
/* 17637 */   MCD::OPC_FilterValue, 34, 39, 0, 0, // Skip to: 17681
/* 17642 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17645 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17654
/* 17650 */   MCD::OPC_Decode, 181, 15, 64, // Opcode: XVMUH_BU
/* 17654 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17663
/* 17659 */   MCD::OPC_Decode, 185, 15, 64, // Opcode: XVMUH_HU
/* 17663 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17672
/* 17668 */   MCD::OPC_Decode, 187, 15, 64, // Opcode: XVMUH_WU
/* 17672 */   MCD::OPC_FilterValue, 3, 195, 24, 0, // Skip to: 24016
/* 17677 */   MCD::OPC_Decode, 183, 15, 64, // Opcode: XVMUH_DU
/* 17681 */   MCD::OPC_FilterValue, 36, 75, 0, 0, // Skip to: 17761
/* 17686 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17689 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17698
/* 17694 */   MCD::OPC_Decode, 191, 15, 64, // Opcode: XVMULWEV_H_B
/* 17698 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17707
/* 17703 */   MCD::OPC_Decode, 197, 15, 64, // Opcode: XVMULWEV_W_H
/* 17707 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17716
/* 17712 */   MCD::OPC_Decode, 188, 15, 64, // Opcode: XVMULWEV_D_W
/* 17716 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17725
/* 17721 */   MCD::OPC_Decode, 194, 15, 64, // Opcode: XVMULWEV_Q_D
/* 17725 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17734
/* 17730 */   MCD::OPC_Decode, 203, 15, 64, // Opcode: XVMULWOD_H_B
/* 17734 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17743
/* 17739 */   MCD::OPC_Decode, 209, 15, 64, // Opcode: XVMULWOD_W_H
/* 17743 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17752
/* 17748 */   MCD::OPC_Decode, 200, 15, 64, // Opcode: XVMULWOD_D_W
/* 17752 */   MCD::OPC_FilterValue, 7, 115, 24, 0, // Skip to: 24016
/* 17757 */   MCD::OPC_Decode, 206, 15, 64, // Opcode: XVMULWOD_Q_D
/* 17761 */   MCD::OPC_FilterValue, 38, 75, 0, 0, // Skip to: 17841
/* 17766 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17769 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17778
/* 17774 */   MCD::OPC_Decode, 192, 15, 64, // Opcode: XVMULWEV_H_BU
/* 17778 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17787
/* 17783 */   MCD::OPC_Decode, 198, 15, 64, // Opcode: XVMULWEV_W_HU
/* 17787 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17796
/* 17792 */   MCD::OPC_Decode, 189, 15, 64, // Opcode: XVMULWEV_D_WU
/* 17796 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17805
/* 17801 */   MCD::OPC_Decode, 195, 15, 64, // Opcode: XVMULWEV_Q_DU
/* 17805 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17814
/* 17810 */   MCD::OPC_Decode, 204, 15, 64, // Opcode: XVMULWOD_H_BU
/* 17814 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17823
/* 17819 */   MCD::OPC_Decode, 210, 15, 64, // Opcode: XVMULWOD_W_HU
/* 17823 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17832
/* 17828 */   MCD::OPC_Decode, 201, 15, 64, // Opcode: XVMULWOD_D_WU
/* 17832 */   MCD::OPC_FilterValue, 7, 35, 24, 0, // Skip to: 24016
/* 17837 */   MCD::OPC_Decode, 207, 15, 64, // Opcode: XVMULWOD_Q_DU
/* 17841 */   MCD::OPC_FilterValue, 40, 75, 0, 0, // Skip to: 17921
/* 17846 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17849 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 17858
/* 17854 */   MCD::OPC_Decode, 193, 15, 64, // Opcode: XVMULWEV_H_BU_B
/* 17858 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 17867
/* 17863 */   MCD::OPC_Decode, 199, 15, 64, // Opcode: XVMULWEV_W_HU_H
/* 17867 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 17876
/* 17872 */   MCD::OPC_Decode, 190, 15, 64, // Opcode: XVMULWEV_D_WU_W
/* 17876 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 17885
/* 17881 */   MCD::OPC_Decode, 196, 15, 64, // Opcode: XVMULWEV_Q_DU_D
/* 17885 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 17894
/* 17890 */   MCD::OPC_Decode, 205, 15, 64, // Opcode: XVMULWOD_H_BU_B
/* 17894 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 17903
/* 17899 */   MCD::OPC_Decode, 211, 15, 64, // Opcode: XVMULWOD_W_HU_H
/* 17903 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 17912
/* 17908 */   MCD::OPC_Decode, 202, 15, 64, // Opcode: XVMULWOD_D_WU_W
/* 17912 */   MCD::OPC_FilterValue, 7, 211, 23, 0, // Skip to: 24016
/* 17917 */   MCD::OPC_Decode, 208, 15, 64, // Opcode: XVMULWOD_Q_DU_D
/* 17921 */   MCD::OPC_FilterValue, 42, 83, 0, 0, // Skip to: 18009
/* 17926 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17929 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 17939
/* 17934 */   MCD::OPC_Decode, 254, 14, 128, 1, // Opcode: XVMADD_B
/* 17939 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 17949
/* 17944 */   MCD::OPC_Decode, 128, 15, 128, 1, // Opcode: XVMADD_H
/* 17949 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 17959
/* 17954 */   MCD::OPC_Decode, 129, 15, 128, 1, // Opcode: XVMADD_W
/* 17959 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 17969
/* 17964 */   MCD::OPC_Decode, 255, 14, 128, 1, // Opcode: XVMADD_D
/* 17969 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 17979
/* 17974 */   MCD::OPC_Decode, 176, 15, 128, 1, // Opcode: XVMSUB_B
/* 17979 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 17989
/* 17984 */   MCD::OPC_Decode, 178, 15, 128, 1, // Opcode: XVMSUB_H
/* 17989 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 17999
/* 17994 */   MCD::OPC_Decode, 179, 15, 128, 1, // Opcode: XVMSUB_W
/* 17999 */   MCD::OPC_FilterValue, 7, 124, 23, 0, // Skip to: 24016
/* 18004 */   MCD::OPC_Decode, 177, 15, 128, 1, // Opcode: XVMSUB_D
/* 18009 */   MCD::OPC_FilterValue, 43, 83, 0, 0, // Skip to: 18097
/* 18014 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18017 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 18027
/* 18022 */   MCD::OPC_Decode, 233, 14, 128, 1, // Opcode: XVMADDWEV_H_B
/* 18027 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 18037
/* 18032 */   MCD::OPC_Decode, 239, 14, 128, 1, // Opcode: XVMADDWEV_W_H
/* 18037 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 18047
/* 18042 */   MCD::OPC_Decode, 230, 14, 128, 1, // Opcode: XVMADDWEV_D_W
/* 18047 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 18057
/* 18052 */   MCD::OPC_Decode, 236, 14, 128, 1, // Opcode: XVMADDWEV_Q_D
/* 18057 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 18067
/* 18062 */   MCD::OPC_Decode, 245, 14, 128, 1, // Opcode: XVMADDWOD_H_B
/* 18067 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 18077
/* 18072 */   MCD::OPC_Decode, 251, 14, 128, 1, // Opcode: XVMADDWOD_W_H
/* 18077 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 18087
/* 18082 */   MCD::OPC_Decode, 242, 14, 128, 1, // Opcode: XVMADDWOD_D_W
/* 18087 */   MCD::OPC_FilterValue, 7, 36, 23, 0, // Skip to: 24016
/* 18092 */   MCD::OPC_Decode, 248, 14, 128, 1, // Opcode: XVMADDWOD_Q_D
/* 18097 */   MCD::OPC_FilterValue, 45, 83, 0, 0, // Skip to: 18185
/* 18102 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18105 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 18115
/* 18110 */   MCD::OPC_Decode, 234, 14, 128, 1, // Opcode: XVMADDWEV_H_BU
/* 18115 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 18125
/* 18120 */   MCD::OPC_Decode, 240, 14, 128, 1, // Opcode: XVMADDWEV_W_HU
/* 18125 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 18135
/* 18130 */   MCD::OPC_Decode, 231, 14, 128, 1, // Opcode: XVMADDWEV_D_WU
/* 18135 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 18145
/* 18140 */   MCD::OPC_Decode, 237, 14, 128, 1, // Opcode: XVMADDWEV_Q_DU
/* 18145 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 18155
/* 18150 */   MCD::OPC_Decode, 246, 14, 128, 1, // Opcode: XVMADDWOD_H_BU
/* 18155 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 18165
/* 18160 */   MCD::OPC_Decode, 252, 14, 128, 1, // Opcode: XVMADDWOD_W_HU
/* 18165 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 18175
/* 18170 */   MCD::OPC_Decode, 243, 14, 128, 1, // Opcode: XVMADDWOD_D_WU
/* 18175 */   MCD::OPC_FilterValue, 7, 204, 22, 0, // Skip to: 24016
/* 18180 */   MCD::OPC_Decode, 249, 14, 128, 1, // Opcode: XVMADDWOD_Q_DU
/* 18185 */   MCD::OPC_FilterValue, 47, 83, 0, 0, // Skip to: 18273
/* 18190 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18193 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 18203
/* 18198 */   MCD::OPC_Decode, 235, 14, 128, 1, // Opcode: XVMADDWEV_H_BU_B
/* 18203 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 18213
/* 18208 */   MCD::OPC_Decode, 241, 14, 128, 1, // Opcode: XVMADDWEV_W_HU_H
/* 18213 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 18223
/* 18218 */   MCD::OPC_Decode, 232, 14, 128, 1, // Opcode: XVMADDWEV_D_WU_W
/* 18223 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 18233
/* 18228 */   MCD::OPC_Decode, 238, 14, 128, 1, // Opcode: XVMADDWEV_Q_DU_D
/* 18233 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 18243
/* 18238 */   MCD::OPC_Decode, 247, 14, 128, 1, // Opcode: XVMADDWOD_H_BU_B
/* 18243 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 18253
/* 18248 */   MCD::OPC_Decode, 253, 14, 128, 1, // Opcode: XVMADDWOD_W_HU_H
/* 18253 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 18263
/* 18258 */   MCD::OPC_Decode, 244, 14, 128, 1, // Opcode: XVMADDWOD_D_WU_W
/* 18263 */   MCD::OPC_FilterValue, 7, 116, 22, 0, // Skip to: 24016
/* 18268 */   MCD::OPC_Decode, 250, 14, 128, 1, // Opcode: XVMADDWOD_Q_DU_D
/* 18273 */   MCD::OPC_FilterValue, 56, 75, 0, 0, // Skip to: 18353
/* 18278 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18281 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 18290
/* 18286 */   MCD::OPC_Decode, 166, 13, 64, // Opcode: XVDIV_B
/* 18290 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18299
/* 18295 */   MCD::OPC_Decode, 170, 13, 64, // Opcode: XVDIV_H
/* 18299 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18308
/* 18304 */   MCD::OPC_Decode, 172, 13, 64, // Opcode: XVDIV_W
/* 18308 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18317
/* 18313 */   MCD::OPC_Decode, 168, 13, 64, // Opcode: XVDIV_D
/* 18317 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 18326
/* 18322 */   MCD::OPC_Decode, 162, 15, 64, // Opcode: XVMOD_B
/* 18326 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18335
/* 18331 */   MCD::OPC_Decode, 166, 15, 64, // Opcode: XVMOD_H
/* 18335 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18344
/* 18340 */   MCD::OPC_Decode, 168, 15, 64, // Opcode: XVMOD_W
/* 18344 */   MCD::OPC_FilterValue, 7, 35, 22, 0, // Skip to: 24016
/* 18349 */   MCD::OPC_Decode, 164, 15, 64, // Opcode: XVMOD_D
/* 18353 */   MCD::OPC_FilterValue, 57, 75, 0, 0, // Skip to: 18433
/* 18358 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18361 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 18370
/* 18366 */   MCD::OPC_Decode, 167, 13, 64, // Opcode: XVDIV_BU
/* 18370 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18379
/* 18375 */   MCD::OPC_Decode, 171, 13, 64, // Opcode: XVDIV_HU
/* 18379 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18388
/* 18384 */   MCD::OPC_Decode, 173, 13, 64, // Opcode: XVDIV_WU
/* 18388 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18397
/* 18393 */   MCD::OPC_Decode, 169, 13, 64, // Opcode: XVDIV_DU
/* 18397 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 18406
/* 18402 */   MCD::OPC_Decode, 163, 15, 64, // Opcode: XVMOD_BU
/* 18406 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18415
/* 18411 */   MCD::OPC_Decode, 167, 15, 64, // Opcode: XVMOD_HU
/* 18415 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18424
/* 18420 */   MCD::OPC_Decode, 169, 15, 64, // Opcode: XVMOD_WU
/* 18424 */   MCD::OPC_FilterValue, 7, 211, 21, 0, // Skip to: 24016
/* 18429 */   MCD::OPC_Decode, 165, 15, 64, // Opcode: XVMOD_DU
/* 18433 */   MCD::OPC_FilterValue, 58, 75, 0, 0, // Skip to: 18513
/* 18438 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18441 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 18450
/* 18446 */   MCD::OPC_Decode, 224, 16, 64, // Opcode: XVSLL_B
/* 18450 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18459
/* 18455 */   MCD::OPC_Decode, 226, 16, 64, // Opcode: XVSLL_H
/* 18459 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18468
/* 18464 */   MCD::OPC_Decode, 227, 16, 64, // Opcode: XVSLL_W
/* 18468 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18477
/* 18473 */   MCD::OPC_Decode, 225, 16, 64, // Opcode: XVSLL_D
/* 18477 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 18486
/* 18482 */   MCD::OPC_Decode, 172, 17, 64, // Opcode: XVSRL_B
/* 18486 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18495
/* 18491 */   MCD::OPC_Decode, 174, 17, 64, // Opcode: XVSRL_H
/* 18495 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18504
/* 18500 */   MCD::OPC_Decode, 175, 17, 64, // Opcode: XVSRL_W
/* 18504 */   MCD::OPC_FilterValue, 7, 131, 21, 0, // Skip to: 24016
/* 18509 */   MCD::OPC_Decode, 173, 17, 64, // Opcode: XVSRL_D
/* 18513 */   MCD::OPC_FilterValue, 59, 75, 0, 0, // Skip to: 18593
/* 18518 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18521 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 18530
/* 18526 */   MCD::OPC_Decode, 142, 17, 64, // Opcode: XVSRA_B
/* 18530 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18539
/* 18535 */   MCD::OPC_Decode, 144, 17, 64, // Opcode: XVSRA_H
/* 18539 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18548
/* 18544 */   MCD::OPC_Decode, 145, 17, 64, // Opcode: XVSRA_W
/* 18548 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18557
/* 18553 */   MCD::OPC_Decode, 143, 17, 64, // Opcode: XVSRA_D
/* 18557 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 18566
/* 18562 */   MCD::OPC_Decode, 148, 16, 64, // Opcode: XVROTR_B
/* 18566 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18575
/* 18571 */   MCD::OPC_Decode, 150, 16, 64, // Opcode: XVROTR_H
/* 18575 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18584
/* 18580 */   MCD::OPC_Decode, 151, 16, 64, // Opcode: XVROTR_W
/* 18584 */   MCD::OPC_FilterValue, 7, 51, 21, 0, // Skip to: 24016
/* 18589 */   MCD::OPC_Decode, 149, 16, 64, // Opcode: XVROTR_D
/* 18593 */   MCD::OPC_FilterValue, 60, 75, 0, 0, // Skip to: 18673
/* 18598 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18601 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 18610
/* 18606 */   MCD::OPC_Decode, 168, 17, 64, // Opcode: XVSRLR_B
/* 18610 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18619
/* 18615 */   MCD::OPC_Decode, 170, 17, 64, // Opcode: XVSRLR_H
/* 18619 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18628
/* 18624 */   MCD::OPC_Decode, 171, 17, 64, // Opcode: XVSRLR_W
/* 18628 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18637
/* 18633 */   MCD::OPC_Decode, 169, 17, 64, // Opcode: XVSRLR_D
/* 18637 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 18646
/* 18642 */   MCD::OPC_Decode, 138, 17, 64, // Opcode: XVSRAR_B
/* 18646 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18655
/* 18651 */   MCD::OPC_Decode, 140, 17, 64, // Opcode: XVSRAR_H
/* 18655 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18664
/* 18660 */   MCD::OPC_Decode, 141, 17, 64, // Opcode: XVSRAR_W
/* 18664 */   MCD::OPC_FilterValue, 7, 227, 20, 0, // Skip to: 24016
/* 18669 */   MCD::OPC_Decode, 139, 17, 64, // Opcode: XVSRAR_D
/* 18673 */   MCD::OPC_FilterValue, 61, 57, 0, 0, // Skip to: 18735
/* 18678 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18681 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18690
/* 18686 */   MCD::OPC_Decode, 154, 17, 64, // Opcode: XVSRLN_B_H
/* 18690 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18699
/* 18695 */   MCD::OPC_Decode, 155, 17, 64, // Opcode: XVSRLN_H_W
/* 18699 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18708
/* 18704 */   MCD::OPC_Decode, 156, 17, 64, // Opcode: XVSRLN_W_D
/* 18708 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18717
/* 18713 */   MCD::OPC_Decode, 252, 16, 64, // Opcode: XVSRAN_B_H
/* 18717 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18726
/* 18722 */   MCD::OPC_Decode, 253, 16, 64, // Opcode: XVSRAN_H_W
/* 18726 */   MCD::OPC_FilterValue, 7, 165, 20, 0, // Skip to: 24016
/* 18731 */   MCD::OPC_Decode, 254, 16, 64, // Opcode: XVSRAN_W_D
/* 18735 */   MCD::OPC_FilterValue, 62, 57, 0, 0, // Skip to: 18797
/* 18740 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18743 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18752
/* 18748 */   MCD::OPC_Decode, 165, 17, 64, // Opcode: XVSRLRN_B_H
/* 18752 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18761
/* 18757 */   MCD::OPC_Decode, 166, 17, 64, // Opcode: XVSRLRN_H_W
/* 18761 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18770
/* 18766 */   MCD::OPC_Decode, 167, 17, 64, // Opcode: XVSRLRN_W_D
/* 18770 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18779
/* 18775 */   MCD::OPC_Decode, 135, 17, 64, // Opcode: XVSRARN_B_H
/* 18779 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18788
/* 18784 */   MCD::OPC_Decode, 136, 17, 64, // Opcode: XVSRARN_H_W
/* 18788 */   MCD::OPC_FilterValue, 7, 103, 20, 0, // Skip to: 24016
/* 18793 */   MCD::OPC_Decode, 137, 17, 64, // Opcode: XVSRARN_W_D
/* 18797 */   MCD::OPC_FilterValue, 63, 57, 0, 0, // Skip to: 18859
/* 18802 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18805 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18814
/* 18810 */   MCD::OPC_Decode, 213, 17, 64, // Opcode: XVSSRLN_B_H
/* 18814 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18823
/* 18819 */   MCD::OPC_Decode, 215, 17, 64, // Opcode: XVSSRLN_H_W
/* 18823 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18832
/* 18828 */   MCD::OPC_Decode, 217, 17, 64, // Opcode: XVSSRLN_W_D
/* 18832 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18841
/* 18837 */   MCD::OPC_Decode, 185, 17, 64, // Opcode: XVSSRAN_B_H
/* 18841 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18850
/* 18846 */   MCD::OPC_Decode, 187, 17, 64, // Opcode: XVSSRAN_H_W
/* 18850 */   MCD::OPC_FilterValue, 7, 41, 20, 0, // Skip to: 24016
/* 18855 */   MCD::OPC_Decode, 189, 17, 64, // Opcode: XVSSRAN_W_D
/* 18859 */   MCD::OPC_FilterValue, 64, 57, 0, 0, // Skip to: 18921
/* 18864 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18867 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18876
/* 18872 */   MCD::OPC_Decode, 227, 17, 64, // Opcode: XVSSRLRN_B_H
/* 18876 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18885
/* 18881 */   MCD::OPC_Decode, 229, 17, 64, // Opcode: XVSSRLRN_H_W
/* 18885 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18894
/* 18890 */   MCD::OPC_Decode, 231, 17, 64, // Opcode: XVSSRLRN_W_D
/* 18894 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18903
/* 18899 */   MCD::OPC_Decode, 199, 17, 64, // Opcode: XVSSRARN_B_H
/* 18903 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18912
/* 18908 */   MCD::OPC_Decode, 201, 17, 64, // Opcode: XVSSRARN_H_W
/* 18912 */   MCD::OPC_FilterValue, 7, 235, 19, 0, // Skip to: 24016
/* 18917 */   MCD::OPC_Decode, 203, 17, 64, // Opcode: XVSSRARN_W_D
/* 18921 */   MCD::OPC_FilterValue, 65, 57, 0, 0, // Skip to: 18983
/* 18926 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18929 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 18938
/* 18934 */   MCD::OPC_Decode, 212, 17, 64, // Opcode: XVSSRLN_BU_H
/* 18938 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 18947
/* 18943 */   MCD::OPC_Decode, 214, 17, 64, // Opcode: XVSSRLN_HU_W
/* 18947 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 18956
/* 18952 */   MCD::OPC_Decode, 216, 17, 64, // Opcode: XVSSRLN_WU_D
/* 18956 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 18965
/* 18961 */   MCD::OPC_Decode, 184, 17, 64, // Opcode: XVSSRAN_BU_H
/* 18965 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 18974
/* 18970 */   MCD::OPC_Decode, 186, 17, 64, // Opcode: XVSSRAN_HU_W
/* 18974 */   MCD::OPC_FilterValue, 7, 173, 19, 0, // Skip to: 24016
/* 18979 */   MCD::OPC_Decode, 188, 17, 64, // Opcode: XVSSRAN_WU_D
/* 18983 */   MCD::OPC_FilterValue, 66, 57, 0, 0, // Skip to: 19045
/* 18988 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18991 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19000
/* 18996 */   MCD::OPC_Decode, 226, 17, 64, // Opcode: XVSSRLRN_BU_H
/* 19000 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19009
/* 19005 */   MCD::OPC_Decode, 228, 17, 64, // Opcode: XVSSRLRN_HU_W
/* 19009 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19018
/* 19014 */   MCD::OPC_Decode, 230, 17, 64, // Opcode: XVSSRLRN_WU_D
/* 19018 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19027
/* 19023 */   MCD::OPC_Decode, 198, 17, 64, // Opcode: XVSSRARN_BU_H
/* 19027 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19036
/* 19032 */   MCD::OPC_Decode, 200, 17, 64, // Opcode: XVSSRARN_HU_W
/* 19036 */   MCD::OPC_FilterValue, 7, 111, 19, 0, // Skip to: 24016
/* 19041 */   MCD::OPC_Decode, 202, 17, 64, // Opcode: XVSSRARN_WU_D
/* 19045 */   MCD::OPC_FilterValue, 67, 75, 0, 0, // Skip to: 19125
/* 19050 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19053 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19062
/* 19058 */   MCD::OPC_Decode, 134, 13, 64, // Opcode: XVBITCLR_B
/* 19062 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19071
/* 19067 */   MCD::OPC_Decode, 136, 13, 64, // Opcode: XVBITCLR_H
/* 19071 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19080
/* 19076 */   MCD::OPC_Decode, 137, 13, 64, // Opcode: XVBITCLR_W
/* 19080 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19089
/* 19085 */   MCD::OPC_Decode, 135, 13, 64, // Opcode: XVBITCLR_D
/* 19089 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19098
/* 19094 */   MCD::OPC_Decode, 152, 13, 64, // Opcode: XVBITSET_B
/* 19098 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19107
/* 19103 */   MCD::OPC_Decode, 154, 13, 64, // Opcode: XVBITSET_H
/* 19107 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19116
/* 19112 */   MCD::OPC_Decode, 155, 13, 64, // Opcode: XVBITSET_W
/* 19116 */   MCD::OPC_FilterValue, 7, 31, 19, 0, // Skip to: 24016
/* 19121 */   MCD::OPC_Decode, 153, 13, 64, // Opcode: XVBITSET_D
/* 19125 */   MCD::OPC_FilterValue, 68, 39, 0, 0, // Skip to: 19169
/* 19130 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19133 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19142
/* 19138 */   MCD::OPC_Decode, 142, 13, 64, // Opcode: XVBITREV_B
/* 19142 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19151
/* 19147 */   MCD::OPC_Decode, 144, 13, 64, // Opcode: XVBITREV_H
/* 19151 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19160
/* 19156 */   MCD::OPC_Decode, 145, 13, 64, // Opcode: XVBITREV_W
/* 19160 */   MCD::OPC_FilterValue, 3, 243, 18, 0, // Skip to: 24016
/* 19165 */   MCD::OPC_Decode, 143, 13, 64, // Opcode: XVBITREV_D
/* 19169 */   MCD::OPC_FilterValue, 69, 39, 0, 0, // Skip to: 19213
/* 19174 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19177 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19186
/* 19182 */   MCD::OPC_Decode, 225, 15, 64, // Opcode: XVPACKEV_B
/* 19186 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19195
/* 19191 */   MCD::OPC_Decode, 227, 15, 64, // Opcode: XVPACKEV_H
/* 19195 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19204
/* 19200 */   MCD::OPC_Decode, 228, 15, 64, // Opcode: XVPACKEV_W
/* 19204 */   MCD::OPC_FilterValue, 7, 199, 18, 0, // Skip to: 24016
/* 19209 */   MCD::OPC_Decode, 226, 15, 64, // Opcode: XVPACKEV_D
/* 19213 */   MCD::OPC_FilterValue, 70, 75, 0, 0, // Skip to: 19293
/* 19218 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19221 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19230
/* 19226 */   MCD::OPC_Decode, 229, 15, 64, // Opcode: XVPACKOD_B
/* 19230 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19239
/* 19235 */   MCD::OPC_Decode, 231, 15, 64, // Opcode: XVPACKOD_H
/* 19239 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19248
/* 19244 */   MCD::OPC_Decode, 232, 15, 64, // Opcode: XVPACKOD_W
/* 19248 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19257
/* 19253 */   MCD::OPC_Decode, 230, 15, 64, // Opcode: XVPACKOD_D
/* 19257 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19266
/* 19262 */   MCD::OPC_Decode, 215, 14, 64, // Opcode: XVILVL_B
/* 19266 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19275
/* 19271 */   MCD::OPC_Decode, 217, 14, 64, // Opcode: XVILVL_H
/* 19275 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19284
/* 19280 */   MCD::OPC_Decode, 218, 14, 64, // Opcode: XVILVL_W
/* 19284 */   MCD::OPC_FilterValue, 7, 119, 18, 0, // Skip to: 24016
/* 19289 */   MCD::OPC_Decode, 216, 14, 64, // Opcode: XVILVL_D
/* 19293 */   MCD::OPC_FilterValue, 71, 75, 0, 0, // Skip to: 19373
/* 19298 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19301 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19310
/* 19306 */   MCD::OPC_Decode, 211, 14, 64, // Opcode: XVILVH_B
/* 19310 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19319
/* 19315 */   MCD::OPC_Decode, 213, 14, 64, // Opcode: XVILVH_H
/* 19319 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19328
/* 19324 */   MCD::OPC_Decode, 214, 14, 64, // Opcode: XVILVH_W
/* 19328 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19337
/* 19333 */   MCD::OPC_Decode, 212, 14, 64, // Opcode: XVILVH_D
/* 19337 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19346
/* 19342 */   MCD::OPC_Decode, 241, 15, 64, // Opcode: XVPICKEV_B
/* 19346 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19355
/* 19351 */   MCD::OPC_Decode, 243, 15, 64, // Opcode: XVPICKEV_H
/* 19355 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19364
/* 19360 */   MCD::OPC_Decode, 244, 15, 64, // Opcode: XVPICKEV_W
/* 19364 */   MCD::OPC_FilterValue, 7, 39, 18, 0, // Skip to: 24016
/* 19369 */   MCD::OPC_Decode, 242, 15, 64, // Opcode: XVPICKEV_D
/* 19373 */   MCD::OPC_FilterValue, 72, 79, 0, 0, // Skip to: 19457
/* 19378 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19381 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19390
/* 19386 */   MCD::OPC_Decode, 245, 15, 64, // Opcode: XVPICKOD_B
/* 19390 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19399
/* 19395 */   MCD::OPC_Decode, 247, 15, 64, // Opcode: XVPICKOD_H
/* 19399 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19408
/* 19404 */   MCD::OPC_Decode, 248, 15, 64, // Opcode: XVPICKOD_W
/* 19408 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19417
/* 19413 */   MCD::OPC_Decode, 246, 15, 64, // Opcode: XVPICKOD_D
/* 19417 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 19427
/* 19422 */   MCD::OPC_Decode, 140, 16, 129, 1, // Opcode: XVREPLVE_B
/* 19427 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 19437
/* 19432 */   MCD::OPC_Decode, 142, 16, 129, 1, // Opcode: XVREPLVE_H
/* 19437 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 19447
/* 19442 */   MCD::OPC_Decode, 143, 16, 129, 1, // Opcode: XVREPLVE_W
/* 19447 */   MCD::OPC_FilterValue, 7, 212, 17, 0, // Skip to: 24016
/* 19452 */   MCD::OPC_Decode, 141, 16, 129, 1, // Opcode: XVREPLVE_D
/* 19457 */   MCD::OPC_FilterValue, 73, 39, 0, 0, // Skip to: 19501
/* 19462 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19465 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19474
/* 19470 */   MCD::OPC_Decode, 241, 12, 64, // Opcode: XVAND_V
/* 19474 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19483
/* 19479 */   MCD::OPC_Decode, 224, 15, 64, // Opcode: XVOR_V
/* 19483 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19492
/* 19488 */   MCD::OPC_Decode, 144, 18, 64, // Opcode: XVXOR_V
/* 19492 */   MCD::OPC_FilterValue, 7, 167, 17, 0, // Skip to: 24016
/* 19497 */   MCD::OPC_Decode, 221, 15, 64, // Opcode: XVNOR_V
/* 19501 */   MCD::OPC_FilterValue, 74, 41, 0, 0, // Skip to: 19547
/* 19506 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19509 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19518
/* 19514 */   MCD::OPC_Decode, 240, 12, 64, // Opcode: XVANDN_V
/* 19518 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19527
/* 19523 */   MCD::OPC_Decode, 223, 15, 64, // Opcode: XVORN_V
/* 19527 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 19537
/* 19532 */   MCD::OPC_Decode, 159, 14, 128, 1, // Opcode: XVFRSTP_B
/* 19537 */   MCD::OPC_FilterValue, 7, 122, 17, 0, // Skip to: 24016
/* 19542 */   MCD::OPC_Decode, 160, 14, 128, 1, // Opcode: XVFRSTP_H
/* 19547 */   MCD::OPC_FilterValue, 75, 57, 0, 0, // Skip to: 19609
/* 19552 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19555 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19564
/* 19560 */   MCD::OPC_Decode, 237, 12, 64, // Opcode: XVADD_Q
/* 19564 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19573
/* 19569 */   MCD::OPC_Decode, 141, 18, 64, // Opcode: XVSUB_Q
/* 19573 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19582
/* 19578 */   MCD::OPC_Decode, 194, 16, 64, // Opcode: XVSIGNCOV_B
/* 19582 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19591
/* 19587 */   MCD::OPC_Decode, 196, 16, 64, // Opcode: XVSIGNCOV_H
/* 19591 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19600
/* 19596 */   MCD::OPC_Decode, 197, 16, 64, // Opcode: XVSIGNCOV_W
/* 19600 */   MCD::OPC_FilterValue, 7, 59, 17, 0, // Skip to: 24016
/* 19605 */   MCD::OPC_Decode, 195, 16, 64, // Opcode: XVSIGNCOV_D
/* 19609 */   MCD::OPC_FilterValue, 76, 39, 0, 0, // Skip to: 19653
/* 19614 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19617 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19626
/* 19622 */   MCD::OPC_Decode, 189, 13, 64, // Opcode: XVFADD_S
/* 19626 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19635
/* 19631 */   MCD::OPC_Decode, 188, 13, 64, // Opcode: XVFADD_D
/* 19635 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19644
/* 19640 */   MCD::OPC_Decode, 164, 14, 64, // Opcode: XVFSUB_S
/* 19644 */   MCD::OPC_FilterValue, 6, 15, 17, 0, // Skip to: 24016
/* 19649 */   MCD::OPC_Decode, 163, 14, 64, // Opcode: XVFSUB_D
/* 19653 */   MCD::OPC_FilterValue, 78, 39, 0, 0, // Skip to: 19697
/* 19658 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19661 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19670
/* 19666 */   MCD::OPC_Decode, 138, 14, 64, // Opcode: XVFMUL_S
/* 19670 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19679
/* 19675 */   MCD::OPC_Decode, 137, 14, 64, // Opcode: XVFMUL_D
/* 19679 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19688
/* 19684 */   MCD::OPC_Decode, 243, 13, 64, // Opcode: XVFDIV_S
/* 19688 */   MCD::OPC_FilterValue, 6, 227, 16, 0, // Skip to: 24016
/* 19693 */   MCD::OPC_Decode, 242, 13, 64, // Opcode: XVFDIV_D
/* 19697 */   MCD::OPC_FilterValue, 79, 39, 0, 0, // Skip to: 19741
/* 19702 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19705 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19714
/* 19710 */   MCD::OPC_Decode, 130, 14, 64, // Opcode: XVFMAX_S
/* 19714 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19723
/* 19719 */   MCD::OPC_Decode, 129, 14, 64, // Opcode: XVFMAX_D
/* 19723 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19732
/* 19728 */   MCD::OPC_Decode, 134, 14, 64, // Opcode: XVFMIN_S
/* 19732 */   MCD::OPC_FilterValue, 6, 183, 16, 0, // Skip to: 24016
/* 19737 */   MCD::OPC_Decode, 133, 14, 64, // Opcode: XVFMIN_D
/* 19741 */   MCD::OPC_FilterValue, 80, 39, 0, 0, // Skip to: 19785
/* 19746 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19749 */   MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 19758
/* 19754 */   MCD::OPC_Decode, 128, 14, 64, // Opcode: XVFMAXA_S
/* 19758 */   MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 19767
/* 19763 */   MCD::OPC_Decode, 255, 13, 64, // Opcode: XVFMAXA_D
/* 19767 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19776
/* 19772 */   MCD::OPC_Decode, 132, 14, 64, // Opcode: XVFMINA_S
/* 19776 */   MCD::OPC_FilterValue, 6, 139, 16, 0, // Skip to: 24016
/* 19781 */   MCD::OPC_Decode, 131, 14, 64, // Opcode: XVFMINA_D
/* 19785 */   MCD::OPC_FilterValue, 81, 21, 0, 0, // Skip to: 19811
/* 19790 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19793 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19802
/* 19798 */   MCD::OPC_Decode, 240, 13, 64, // Opcode: XVFCVT_H_S
/* 19802 */   MCD::OPC_FilterValue, 5, 113, 16, 0, // Skip to: 24016
/* 19807 */   MCD::OPC_Decode, 241, 13, 64, // Opcode: XVFCVT_S_D
/* 19811 */   MCD::OPC_FilterValue, 82, 57, 0, 0, // Skip to: 19873
/* 19816 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19819 */   MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 19828
/* 19824 */   MCD::OPC_Decode, 248, 13, 64, // Opcode: XVFFINT_S_L
/* 19828 */   MCD::OPC_FilterValue, 3, 4, 0, 0, // Skip to: 19837
/* 19833 */   MCD::OPC_Decode, 192, 14, 64, // Opcode: XVFTINT_W_D
/* 19837 */   MCD::OPC_FilterValue, 4, 4, 0, 0, // Skip to: 19846
/* 19842 */   MCD::OPC_Decode, 170, 14, 64, // Opcode: XVFTINTRM_W_D
/* 19846 */   MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 19855
/* 19851 */   MCD::OPC_Decode, 180, 14, 64, // Opcode: XVFTINTRP_W_D
/* 19855 */   MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 19864
/* 19860 */   MCD::OPC_Decode, 187, 14, 64, // Opcode: XVFTINTRZ_W_D
/* 19864 */   MCD::OPC_FilterValue, 7, 51, 16, 0, // Skip to: 24016
/* 19869 */   MCD::OPC_Decode, 175, 14, 64, // Opcode: XVFTINTRNE_W_D
/* 19873 */   MCD::OPC_FilterValue, 94, 33, 0, 0, // Skip to: 19911
/* 19878 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19881 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 19891
/* 19886 */   MCD::OPC_Decode, 192, 16, 128, 1, // Opcode: XVSHUF_H
/* 19891 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 19901
/* 19896 */   MCD::OPC_Decode, 193, 16, 128, 1, // Opcode: XVSHUF_W
/* 19901 */   MCD::OPC_FilterValue, 7, 14, 16, 0, // Skip to: 24016
/* 19906 */   MCD::OPC_Decode, 191, 16, 128, 1, // Opcode: XVSHUF_D
/* 19911 */   MCD::OPC_FilterValue, 95, 11, 0, 0, // Skip to: 19927
/* 19916 */   MCD::OPC_CheckField, 15, 3, 2, 253, 15, 0, // Skip to: 24016
/* 19923 */   MCD::OPC_Decode, 240, 15, 64, // Opcode: XVPERM_W
/* 19927 */   MCD::OPC_FilterValue, 160, 1, 83, 0, 0, // Skip to: 20016
/* 19933 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 19936 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 19946
/* 19941 */   MCD::OPC_Decode, 168, 16, 130, 1, // Opcode: XVSEQI_B
/* 19946 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 19956
/* 19951 */   MCD::OPC_Decode, 170, 16, 130, 1, // Opcode: XVSEQI_H
/* 19956 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 19966
/* 19961 */   MCD::OPC_Decode, 171, 16, 130, 1, // Opcode: XVSEQI_W
/* 19966 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 19976
/* 19971 */   MCD::OPC_Decode, 169, 16, 130, 1, // Opcode: XVSEQI_D
/* 19976 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 19986
/* 19981 */   MCD::OPC_Decode, 198, 16, 130, 1, // Opcode: XVSLEI_B
/* 19986 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 19996
/* 19991 */   MCD::OPC_Decode, 202, 16, 130, 1, // Opcode: XVSLEI_H
/* 19996 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20006
/* 20001 */   MCD::OPC_Decode, 204, 16, 130, 1, // Opcode: XVSLEI_W
/* 20006 */   MCD::OPC_FilterValue, 7, 165, 15, 0, // Skip to: 24016
/* 20011 */   MCD::OPC_Decode, 200, 16, 130, 1, // Opcode: XVSLEI_D
/* 20016 */   MCD::OPC_FilterValue, 161, 1, 83, 0, 0, // Skip to: 20105
/* 20022 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20025 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20035
/* 20030 */   MCD::OPC_Decode, 199, 16, 131, 1, // Opcode: XVSLEI_BU
/* 20035 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20045
/* 20040 */   MCD::OPC_Decode, 203, 16, 131, 1, // Opcode: XVSLEI_HU
/* 20045 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20055
/* 20050 */   MCD::OPC_Decode, 205, 16, 131, 1, // Opcode: XVSLEI_WU
/* 20055 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20065
/* 20060 */   MCD::OPC_Decode, 201, 16, 131, 1, // Opcode: XVSLEI_DU
/* 20065 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20075
/* 20070 */   MCD::OPC_Decode, 228, 16, 130, 1, // Opcode: XVSLTI_B
/* 20075 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 20085
/* 20080 */   MCD::OPC_Decode, 232, 16, 130, 1, // Opcode: XVSLTI_H
/* 20085 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20095
/* 20090 */   MCD::OPC_Decode, 234, 16, 130, 1, // Opcode: XVSLTI_W
/* 20095 */   MCD::OPC_FilterValue, 7, 76, 15, 0, // Skip to: 24016
/* 20100 */   MCD::OPC_Decode, 230, 16, 130, 1, // Opcode: XVSLTI_D
/* 20105 */   MCD::OPC_FilterValue, 162, 1, 83, 0, 0, // Skip to: 20194
/* 20111 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20114 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20124
/* 20119 */   MCD::OPC_Decode, 229, 16, 131, 1, // Opcode: XVSLTI_BU
/* 20124 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20134
/* 20129 */   MCD::OPC_Decode, 233, 16, 131, 1, // Opcode: XVSLTI_HU
/* 20134 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20144
/* 20139 */   MCD::OPC_Decode, 235, 16, 131, 1, // Opcode: XVSLTI_WU
/* 20144 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20154
/* 20149 */   MCD::OPC_Decode, 231, 16, 131, 1, // Opcode: XVSLTI_DU
/* 20154 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20164
/* 20159 */   MCD::OPC_Decode, 206, 12, 131, 1, // Opcode: XVADDI_BU
/* 20164 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 20174
/* 20169 */   MCD::OPC_Decode, 208, 12, 131, 1, // Opcode: XVADDI_HU
/* 20174 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20184
/* 20179 */   MCD::OPC_Decode, 209, 12, 131, 1, // Opcode: XVADDI_WU
/* 20184 */   MCD::OPC_FilterValue, 7, 243, 14, 0, // Skip to: 24016
/* 20189 */   MCD::OPC_Decode, 207, 12, 131, 1, // Opcode: XVADDI_DU
/* 20194 */   MCD::OPC_FilterValue, 163, 1, 63, 0, 0, // Skip to: 20263
/* 20200 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20203 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20213
/* 20208 */   MCD::OPC_Decode, 246, 17, 131, 1, // Opcode: XVSUBI_BU
/* 20213 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20223
/* 20218 */   MCD::OPC_Decode, 248, 17, 131, 1, // Opcode: XVSUBI_HU
/* 20223 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20233
/* 20228 */   MCD::OPC_Decode, 249, 17, 131, 1, // Opcode: XVSUBI_WU
/* 20233 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20243
/* 20238 */   MCD::OPC_Decode, 247, 17, 131, 1, // Opcode: XVSUBI_DU
/* 20243 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20253
/* 20248 */   MCD::OPC_Decode, 156, 13, 131, 1, // Opcode: XVBSLL_V
/* 20253 */   MCD::OPC_FilterValue, 5, 174, 14, 0, // Skip to: 24016
/* 20258 */   MCD::OPC_Decode, 157, 13, 131, 1, // Opcode: XVBSRL_V
/* 20263 */   MCD::OPC_FilterValue, 164, 1, 83, 0, 0, // Skip to: 20352
/* 20269 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20272 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20282
/* 20277 */   MCD::OPC_Decode, 130, 15, 130, 1, // Opcode: XVMAXI_B
/* 20282 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20292
/* 20287 */   MCD::OPC_Decode, 134, 15, 130, 1, // Opcode: XVMAXI_H
/* 20292 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20302
/* 20297 */   MCD::OPC_Decode, 136, 15, 130, 1, // Opcode: XVMAXI_W
/* 20302 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20312
/* 20307 */   MCD::OPC_Decode, 132, 15, 130, 1, // Opcode: XVMAXI_D
/* 20312 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20322
/* 20317 */   MCD::OPC_Decode, 146, 15, 130, 1, // Opcode: XVMINI_B
/* 20322 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 20332
/* 20327 */   MCD::OPC_Decode, 150, 15, 130, 1, // Opcode: XVMINI_H
/* 20332 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20342
/* 20337 */   MCD::OPC_Decode, 152, 15, 130, 1, // Opcode: XVMINI_W
/* 20342 */   MCD::OPC_FilterValue, 7, 85, 14, 0, // Skip to: 24016
/* 20347 */   MCD::OPC_Decode, 148, 15, 130, 1, // Opcode: XVMINI_D
/* 20352 */   MCD::OPC_FilterValue, 165, 1, 83, 0, 0, // Skip to: 20441
/* 20358 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20361 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20371
/* 20366 */   MCD::OPC_Decode, 131, 15, 131, 1, // Opcode: XVMAXI_BU
/* 20371 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20381
/* 20376 */   MCD::OPC_Decode, 135, 15, 131, 1, // Opcode: XVMAXI_HU
/* 20381 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20391
/* 20386 */   MCD::OPC_Decode, 137, 15, 131, 1, // Opcode: XVMAXI_WU
/* 20391 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20401
/* 20396 */   MCD::OPC_Decode, 133, 15, 131, 1, // Opcode: XVMAXI_DU
/* 20401 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20411
/* 20406 */   MCD::OPC_Decode, 147, 15, 131, 1, // Opcode: XVMINI_BU
/* 20411 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 20421
/* 20416 */   MCD::OPC_Decode, 151, 15, 131, 1, // Opcode: XVMINI_HU
/* 20421 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20431
/* 20426 */   MCD::OPC_Decode, 153, 15, 131, 1, // Opcode: XVMINI_WU
/* 20431 */   MCD::OPC_FilterValue, 7, 252, 13, 0, // Skip to: 24016
/* 20436 */   MCD::OPC_Decode, 149, 15, 131, 1, // Opcode: XVMINI_DU
/* 20441 */   MCD::OPC_FilterValue, 166, 1, 23, 0, 0, // Skip to: 20470
/* 20447 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20450 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20460
/* 20455 */   MCD::OPC_Decode, 157, 14, 132, 1, // Opcode: XVFRSTPI_B
/* 20460 */   MCD::OPC_FilterValue, 5, 223, 13, 0, // Skip to: 24016
/* 20465 */   MCD::OPC_Decode, 158, 14, 132, 1, // Opcode: XVFRSTPI_H
/* 20470 */   MCD::OPC_FilterValue, 167, 1, 215, 4, 0, // Skip to: 21715
/* 20476 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 20479 */   MCD::OPC_FilterValue, 0, 223, 0, 0, // Skip to: 20707
/* 20484 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 20487 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 20497
/* 20492 */   MCD::OPC_Decode, 158, 13, 133, 1, // Opcode: XVCLO_B
/* 20497 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20507
/* 20502 */   MCD::OPC_Decode, 160, 13, 133, 1, // Opcode: XVCLO_H
/* 20507 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20517
/* 20512 */   MCD::OPC_Decode, 161, 13, 133, 1, // Opcode: XVCLO_W
/* 20517 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 20527
/* 20522 */   MCD::OPC_Decode, 159, 13, 133, 1, // Opcode: XVCLO_D
/* 20527 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 20537
/* 20532 */   MCD::OPC_Decode, 162, 13, 133, 1, // Opcode: XVCLZ_B
/* 20537 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 20547
/* 20542 */   MCD::OPC_Decode, 164, 13, 133, 1, // Opcode: XVCLZ_H
/* 20547 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 20557
/* 20552 */   MCD::OPC_Decode, 165, 13, 133, 1, // Opcode: XVCLZ_W
/* 20557 */   MCD::OPC_FilterValue, 7, 5, 0, 0, // Skip to: 20567
/* 20562 */   MCD::OPC_Decode, 163, 13, 133, 1, // Opcode: XVCLZ_D
/* 20567 */   MCD::OPC_FilterValue, 8, 5, 0, 0, // Skip to: 20577
/* 20572 */   MCD::OPC_Decode, 233, 15, 133, 1, // Opcode: XVPCNT_B
/* 20577 */   MCD::OPC_FilterValue, 9, 5, 0, 0, // Skip to: 20587
/* 20582 */   MCD::OPC_Decode, 235, 15, 133, 1, // Opcode: XVPCNT_H
/* 20587 */   MCD::OPC_FilterValue, 10, 5, 0, 0, // Skip to: 20597
/* 20592 */   MCD::OPC_Decode, 236, 15, 133, 1, // Opcode: XVPCNT_W
/* 20597 */   MCD::OPC_FilterValue, 11, 5, 0, 0, // Skip to: 20607
/* 20602 */   MCD::OPC_Decode, 234, 15, 133, 1, // Opcode: XVPCNT_D
/* 20607 */   MCD::OPC_FilterValue, 12, 5, 0, 0, // Skip to: 20617
/* 20612 */   MCD::OPC_Decode, 216, 15, 133, 1, // Opcode: XVNEG_B
/* 20617 */   MCD::OPC_FilterValue, 13, 5, 0, 0, // Skip to: 20627
/* 20622 */   MCD::OPC_Decode, 218, 15, 133, 1, // Opcode: XVNEG_H
/* 20627 */   MCD::OPC_FilterValue, 14, 5, 0, 0, // Skip to: 20637
/* 20632 */   MCD::OPC_Decode, 219, 15, 133, 1, // Opcode: XVNEG_W
/* 20637 */   MCD::OPC_FilterValue, 15, 5, 0, 0, // Skip to: 20647
/* 20642 */   MCD::OPC_Decode, 217, 15, 133, 1, // Opcode: XVNEG_D
/* 20647 */   MCD::OPC_FilterValue, 16, 5, 0, 0, // Skip to: 20657
/* 20652 */   MCD::OPC_Decode, 171, 15, 133, 1, // Opcode: XVMSKLTZ_B
/* 20657 */   MCD::OPC_FilterValue, 17, 5, 0, 0, // Skip to: 20667
/* 20662 */   MCD::OPC_Decode, 173, 15, 133, 1, // Opcode: XVMSKLTZ_H
/* 20667 */   MCD::OPC_FilterValue, 18, 5, 0, 0, // Skip to: 20677
/* 20672 */   MCD::OPC_Decode, 174, 15, 133, 1, // Opcode: XVMSKLTZ_W
/* 20677 */   MCD::OPC_FilterValue, 19, 5, 0, 0, // Skip to: 20687
/* 20682 */   MCD::OPC_Decode, 172, 15, 133, 1, // Opcode: XVMSKLTZ_D
/* 20687 */   MCD::OPC_FilterValue, 20, 5, 0, 0, // Skip to: 20697
/* 20692 */   MCD::OPC_Decode, 170, 15, 133, 1, // Opcode: XVMSKGEZ_B
/* 20697 */   MCD::OPC_FilterValue, 24, 242, 12, 0, // Skip to: 24016
/* 20702 */   MCD::OPC_Decode, 175, 15, 133, 1, // Opcode: XVMSKNZ_B
/* 20707 */   MCD::OPC_FilterValue, 1, 253, 0, 0, // Skip to: 20965
/* 20712 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 20715 */   MCD::OPC_FilterValue, 6, 12, 0, 0, // Skip to: 20732
/* 20720 */   MCD::OPC_CheckField, 3, 2, 0, 217, 12, 0, // Skip to: 24016
/* 20727 */   MCD::OPC_Decode, 184, 16, 134, 1, // Opcode: XVSETEQZ_V
/* 20732 */   MCD::OPC_FilterValue, 7, 12, 0, 0, // Skip to: 20749
/* 20737 */   MCD::OPC_CheckField, 3, 2, 0, 200, 12, 0, // Skip to: 24016
/* 20744 */   MCD::OPC_Decode, 185, 16, 134, 1, // Opcode: XVSETNEZ_V
/* 20749 */   MCD::OPC_FilterValue, 8, 12, 0, 0, // Skip to: 20766
/* 20754 */   MCD::OPC_CheckField, 3, 2, 0, 183, 12, 0, // Skip to: 24016
/* 20761 */   MCD::OPC_Decode, 180, 16, 134, 1, // Opcode: XVSETANYEQZ_B
/* 20766 */   MCD::OPC_FilterValue, 9, 12, 0, 0, // Skip to: 20783
/* 20771 */   MCD::OPC_CheckField, 3, 2, 0, 166, 12, 0, // Skip to: 24016
/* 20778 */   MCD::OPC_Decode, 182, 16, 134, 1, // Opcode: XVSETANYEQZ_H
/* 20783 */   MCD::OPC_FilterValue, 10, 12, 0, 0, // Skip to: 20800
/* 20788 */   MCD::OPC_CheckField, 3, 2, 0, 149, 12, 0, // Skip to: 24016
/* 20795 */   MCD::OPC_Decode, 183, 16, 134, 1, // Opcode: XVSETANYEQZ_W
/* 20800 */   MCD::OPC_FilterValue, 11, 12, 0, 0, // Skip to: 20817
/* 20805 */   MCD::OPC_CheckField, 3, 2, 0, 132, 12, 0, // Skip to: 24016
/* 20812 */   MCD::OPC_Decode, 181, 16, 134, 1, // Opcode: XVSETANYEQZ_D
/* 20817 */   MCD::OPC_FilterValue, 12, 12, 0, 0, // Skip to: 20834
/* 20822 */   MCD::OPC_CheckField, 3, 2, 0, 115, 12, 0, // Skip to: 24016
/* 20829 */   MCD::OPC_Decode, 176, 16, 134, 1, // Opcode: XVSETALLNEZ_B
/* 20834 */   MCD::OPC_FilterValue, 13, 12, 0, 0, // Skip to: 20851
/* 20839 */   MCD::OPC_CheckField, 3, 2, 0, 98, 12, 0, // Skip to: 24016
/* 20846 */   MCD::OPC_Decode, 178, 16, 134, 1, // Opcode: XVSETALLNEZ_H
/* 20851 */   MCD::OPC_FilterValue, 14, 12, 0, 0, // Skip to: 20868
/* 20856 */   MCD::OPC_CheckField, 3, 2, 0, 81, 12, 0, // Skip to: 24016
/* 20863 */   MCD::OPC_Decode, 179, 16, 134, 1, // Opcode: XVSETALLNEZ_W
/* 20868 */   MCD::OPC_FilterValue, 15, 12, 0, 0, // Skip to: 20885
/* 20873 */   MCD::OPC_CheckField, 3, 2, 0, 64, 12, 0, // Skip to: 24016
/* 20880 */   MCD::OPC_Decode, 177, 16, 134, 1, // Opcode: XVSETALLNEZ_D
/* 20885 */   MCD::OPC_FilterValue, 17, 5, 0, 0, // Skip to: 20895
/* 20890 */   MCD::OPC_Decode, 252, 13, 133, 1, // Opcode: XVFLOGB_S
/* 20895 */   MCD::OPC_FilterValue, 18, 5, 0, 0, // Skip to: 20905
/* 20900 */   MCD::OPC_Decode, 251, 13, 133, 1, // Opcode: XVFLOGB_D
/* 20905 */   MCD::OPC_FilterValue, 21, 5, 0, 0, // Skip to: 20915
/* 20910 */   MCD::OPC_Decode, 191, 13, 133, 1, // Opcode: XVFCLASS_S
/* 20915 */   MCD::OPC_FilterValue, 22, 5, 0, 0, // Skip to: 20925
/* 20920 */   MCD::OPC_Decode, 190, 13, 133, 1, // Opcode: XVFCLASS_D
/* 20925 */   MCD::OPC_FilterValue, 25, 5, 0, 0, // Skip to: 20935
/* 20930 */   MCD::OPC_Decode, 162, 14, 133, 1, // Opcode: XVFSQRT_S
/* 20935 */   MCD::OPC_FilterValue, 26, 5, 0, 0, // Skip to: 20945
/* 20940 */   MCD::OPC_Decode, 161, 14, 133, 1, // Opcode: XVFSQRT_D
/* 20945 */   MCD::OPC_FilterValue, 29, 5, 0, 0, // Skip to: 20955
/* 20950 */   MCD::OPC_Decode, 144, 14, 133, 1, // Opcode: XVFRECIP_S
/* 20955 */   MCD::OPC_FilterValue, 30, 240, 11, 0, // Skip to: 24016
/* 20960 */   MCD::OPC_Decode, 143, 14, 133, 1, // Opcode: XVFRECIP_D
/* 20965 */   MCD::OPC_FilterValue, 2, 123, 0, 0, // Skip to: 21093
/* 20970 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 20973 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 20983
/* 20978 */   MCD::OPC_Decode, 156, 14, 133, 1, // Opcode: XVFRSQRT_S
/* 20983 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 20993
/* 20988 */   MCD::OPC_Decode, 155, 14, 133, 1, // Opcode: XVFRSQRT_D
/* 20993 */   MCD::OPC_FilterValue, 13, 5, 0, 0, // Skip to: 21003
/* 20998 */   MCD::OPC_Decode, 154, 14, 133, 1, // Opcode: XVFRINT_S
/* 21003 */   MCD::OPC_FilterValue, 14, 5, 0, 0, // Skip to: 21013
/* 21008 */   MCD::OPC_Decode, 153, 14, 133, 1, // Opcode: XVFRINT_D
/* 21013 */   MCD::OPC_FilterValue, 17, 5, 0, 0, // Skip to: 21023
/* 21018 */   MCD::OPC_Decode, 146, 14, 133, 1, // Opcode: XVFRINTRM_S
/* 21023 */   MCD::OPC_FilterValue, 18, 5, 0, 0, // Skip to: 21033
/* 21028 */   MCD::OPC_Decode, 145, 14, 133, 1, // Opcode: XVFRINTRM_D
/* 21033 */   MCD::OPC_FilterValue, 21, 5, 0, 0, // Skip to: 21043
/* 21038 */   MCD::OPC_Decode, 150, 14, 133, 1, // Opcode: XVFRINTRP_S
/* 21043 */   MCD::OPC_FilterValue, 22, 5, 0, 0, // Skip to: 21053
/* 21048 */   MCD::OPC_Decode, 149, 14, 133, 1, // Opcode: XVFRINTRP_D
/* 21053 */   MCD::OPC_FilterValue, 25, 5, 0, 0, // Skip to: 21063
/* 21058 */   MCD::OPC_Decode, 152, 14, 133, 1, // Opcode: XVFRINTRZ_S
/* 21063 */   MCD::OPC_FilterValue, 26, 5, 0, 0, // Skip to: 21073
/* 21068 */   MCD::OPC_Decode, 151, 14, 133, 1, // Opcode: XVFRINTRZ_D
/* 21073 */   MCD::OPC_FilterValue, 29, 5, 0, 0, // Skip to: 21083
/* 21078 */   MCD::OPC_Decode, 148, 14, 133, 1, // Opcode: XVFRINTRNE_S
/* 21083 */   MCD::OPC_FilterValue, 30, 112, 11, 0, // Skip to: 24016
/* 21088 */   MCD::OPC_Decode, 147, 14, 133, 1, // Opcode: XVFRINTRNE_D
/* 21093 */   MCD::OPC_FilterValue, 3, 43, 0, 0, // Skip to: 21141
/* 21098 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 21101 */   MCD::OPC_FilterValue, 26, 5, 0, 0, // Skip to: 21111
/* 21106 */   MCD::OPC_Decode, 239, 13, 133, 1, // Opcode: XVFCVTL_S_H
/* 21111 */   MCD::OPC_FilterValue, 27, 5, 0, 0, // Skip to: 21121
/* 21116 */   MCD::OPC_Decode, 237, 13, 133, 1, // Opcode: XVFCVTH_S_H
/* 21121 */   MCD::OPC_FilterValue, 28, 5, 0, 0, // Skip to: 21131
/* 21126 */   MCD::OPC_Decode, 238, 13, 133, 1, // Opcode: XVFCVTL_D_S
/* 21131 */   MCD::OPC_FilterValue, 29, 64, 11, 0, // Skip to: 24016
/* 21136 */   MCD::OPC_Decode, 236, 13, 133, 1, // Opcode: XVFCVTH_D_S
/* 21141 */   MCD::OPC_FilterValue, 4, 203, 0, 0, // Skip to: 21349
/* 21146 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 21149 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 21159
/* 21154 */   MCD::OPC_Decode, 249, 13, 133, 1, // Opcode: XVFFINT_S_W
/* 21159 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 21169
/* 21164 */   MCD::OPC_Decode, 250, 13, 133, 1, // Opcode: XVFFINT_S_WU
/* 21169 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 21179
/* 21174 */   MCD::OPC_Decode, 246, 13, 133, 1, // Opcode: XVFFINT_D_L
/* 21179 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 21189
/* 21184 */   MCD::OPC_Decode, 247, 13, 133, 1, // Opcode: XVFFINT_D_LU
/* 21189 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 21199
/* 21194 */   MCD::OPC_Decode, 245, 13, 133, 1, // Opcode: XVFFINTL_D_W
/* 21199 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 21209
/* 21204 */   MCD::OPC_Decode, 244, 13, 133, 1, // Opcode: XVFFINTH_D_W
/* 21209 */   MCD::OPC_FilterValue, 12, 5, 0, 0, // Skip to: 21219
/* 21214 */   MCD::OPC_Decode, 193, 14, 133, 1, // Opcode: XVFTINT_W_S
/* 21219 */   MCD::OPC_FilterValue, 13, 5, 0, 0, // Skip to: 21229
/* 21224 */   MCD::OPC_Decode, 190, 14, 133, 1, // Opcode: XVFTINT_L_D
/* 21229 */   MCD::OPC_FilterValue, 14, 5, 0, 0, // Skip to: 21239
/* 21234 */   MCD::OPC_Decode, 171, 14, 133, 1, // Opcode: XVFTINTRM_W_S
/* 21239 */   MCD::OPC_FilterValue, 15, 5, 0, 0, // Skip to: 21249
/* 21244 */   MCD::OPC_Decode, 169, 14, 133, 1, // Opcode: XVFTINTRM_L_D
/* 21249 */   MCD::OPC_FilterValue, 16, 5, 0, 0, // Skip to: 21259
/* 21254 */   MCD::OPC_Decode, 181, 14, 133, 1, // Opcode: XVFTINTRP_W_S
/* 21259 */   MCD::OPC_FilterValue, 17, 5, 0, 0, // Skip to: 21269
/* 21264 */   MCD::OPC_Decode, 179, 14, 133, 1, // Opcode: XVFTINTRP_L_D
/* 21269 */   MCD::OPC_FilterValue, 18, 5, 0, 0, // Skip to: 21279
/* 21274 */   MCD::OPC_Decode, 188, 14, 133, 1, // Opcode: XVFTINTRZ_W_S
/* 21279 */   MCD::OPC_FilterValue, 19, 5, 0, 0, // Skip to: 21289
/* 21284 */   MCD::OPC_Decode, 185, 14, 133, 1, // Opcode: XVFTINTRZ_L_D
/* 21289 */   MCD::OPC_FilterValue, 20, 5, 0, 0, // Skip to: 21299
/* 21294 */   MCD::OPC_Decode, 176, 14, 133, 1, // Opcode: XVFTINTRNE_W_S
/* 21299 */   MCD::OPC_FilterValue, 21, 5, 0, 0, // Skip to: 21309
/* 21304 */   MCD::OPC_Decode, 174, 14, 133, 1, // Opcode: XVFTINTRNE_L_D
/* 21309 */   MCD::OPC_FilterValue, 22, 5, 0, 0, // Skip to: 21319
/* 21314 */   MCD::OPC_Decode, 191, 14, 133, 1, // Opcode: XVFTINT_WU_S
/* 21319 */   MCD::OPC_FilterValue, 23, 5, 0, 0, // Skip to: 21329
/* 21324 */   MCD::OPC_Decode, 189, 14, 133, 1, // Opcode: XVFTINT_LU_D
/* 21329 */   MCD::OPC_FilterValue, 28, 5, 0, 0, // Skip to: 21339
/* 21334 */   MCD::OPC_Decode, 186, 14, 133, 1, // Opcode: XVFTINTRZ_WU_S
/* 21339 */   MCD::OPC_FilterValue, 29, 112, 10, 0, // Skip to: 24016
/* 21344 */   MCD::OPC_Decode, 184, 14, 133, 1, // Opcode: XVFTINTRZ_LU_D
/* 21349 */   MCD::OPC_FilterValue, 5, 183, 0, 0, // Skip to: 21537
/* 21354 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 21357 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 21367
/* 21362 */   MCD::OPC_Decode, 166, 14, 133, 1, // Opcode: XVFTINTL_L_S
/* 21367 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 21377
/* 21372 */   MCD::OPC_Decode, 165, 14, 133, 1, // Opcode: XVFTINTH_L_S
/* 21377 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 21387
/* 21382 */   MCD::OPC_Decode, 168, 14, 133, 1, // Opcode: XVFTINTRML_L_S
/* 21387 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 21397
/* 21392 */   MCD::OPC_Decode, 167, 14, 133, 1, // Opcode: XVFTINTRMH_L_S
/* 21397 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 21407
/* 21402 */   MCD::OPC_Decode, 178, 14, 133, 1, // Opcode: XVFTINTRPL_L_S
/* 21407 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 21417
/* 21412 */   MCD::OPC_Decode, 177, 14, 133, 1, // Opcode: XVFTINTRPH_L_S
/* 21417 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 21427
/* 21422 */   MCD::OPC_Decode, 183, 14, 133, 1, // Opcode: XVFTINTRZL_L_S
/* 21427 */   MCD::OPC_FilterValue, 7, 5, 0, 0, // Skip to: 21437
/* 21432 */   MCD::OPC_Decode, 182, 14, 133, 1, // Opcode: XVFTINTRZH_L_S
/* 21437 */   MCD::OPC_FilterValue, 8, 5, 0, 0, // Skip to: 21447
/* 21442 */   MCD::OPC_Decode, 173, 14, 133, 1, // Opcode: XVFTINTRNEL_L_S
/* 21447 */   MCD::OPC_FilterValue, 9, 5, 0, 0, // Skip to: 21457
/* 21452 */   MCD::OPC_Decode, 172, 14, 133, 1, // Opcode: XVFTINTRNEH_L_S
/* 21457 */   MCD::OPC_FilterValue, 24, 5, 0, 0, // Skip to: 21467
/* 21462 */   MCD::OPC_Decode, 177, 13, 133, 1, // Opcode: XVEXTH_H_B
/* 21467 */   MCD::OPC_FilterValue, 25, 5, 0, 0, // Skip to: 21477
/* 21472 */   MCD::OPC_Decode, 181, 13, 133, 1, // Opcode: XVEXTH_W_H
/* 21477 */   MCD::OPC_FilterValue, 26, 5, 0, 0, // Skip to: 21487
/* 21482 */   MCD::OPC_Decode, 175, 13, 133, 1, // Opcode: XVEXTH_D_W
/* 21487 */   MCD::OPC_FilterValue, 27, 5, 0, 0, // Skip to: 21497
/* 21492 */   MCD::OPC_Decode, 179, 13, 133, 1, // Opcode: XVEXTH_Q_D
/* 21497 */   MCD::OPC_FilterValue, 28, 5, 0, 0, // Skip to: 21507
/* 21502 */   MCD::OPC_Decode, 176, 13, 133, 1, // Opcode: XVEXTH_HU_BU
/* 21507 */   MCD::OPC_FilterValue, 29, 5, 0, 0, // Skip to: 21517
/* 21512 */   MCD::OPC_Decode, 180, 13, 133, 1, // Opcode: XVEXTH_WU_HU
/* 21517 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 21527
/* 21522 */   MCD::OPC_Decode, 174, 13, 133, 1, // Opcode: XVEXTH_DU_WU
/* 21527 */   MCD::OPC_FilterValue, 31, 180, 9, 0, // Skip to: 24016
/* 21532 */   MCD::OPC_Decode, 178, 13, 133, 1, // Opcode: XVEXTH_QU_DU
/* 21537 */   MCD::OPC_FilterValue, 6, 163, 0, 0, // Skip to: 21705
/* 21542 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 21545 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 21555
/* 21550 */   MCD::OPC_Decode, 131, 16, 135, 1, // Opcode: XVREPLGR2VR_B
/* 21555 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 21565
/* 21560 */   MCD::OPC_Decode, 133, 16, 135, 1, // Opcode: XVREPLGR2VR_H
/* 21565 */   MCD::OPC_FilterValue, 2, 5, 0, 0, // Skip to: 21575
/* 21570 */   MCD::OPC_Decode, 134, 16, 135, 1, // Opcode: XVREPLGR2VR_W
/* 21575 */   MCD::OPC_FilterValue, 3, 5, 0, 0, // Skip to: 21585
/* 21580 */   MCD::OPC_Decode, 132, 16, 135, 1, // Opcode: XVREPLGR2VR_D
/* 21585 */   MCD::OPC_FilterValue, 4, 5, 0, 0, // Skip to: 21595
/* 21590 */   MCD::OPC_Decode, 238, 6, 133, 1, // Opcode: VEXT2XV_H_B
/* 21595 */   MCD::OPC_FilterValue, 5, 5, 0, 0, // Skip to: 21605
/* 21600 */   MCD::OPC_Decode, 241, 6, 133, 1, // Opcode: VEXT2XV_W_B
/* 21605 */   MCD::OPC_FilterValue, 6, 5, 0, 0, // Skip to: 21615
/* 21610 */   MCD::OPC_Decode, 234, 6, 133, 1, // Opcode: VEXT2XV_D_B
/* 21615 */   MCD::OPC_FilterValue, 7, 5, 0, 0, // Skip to: 21625
/* 21620 */   MCD::OPC_Decode, 242, 6, 133, 1, // Opcode: VEXT2XV_W_H
/* 21625 */   MCD::OPC_FilterValue, 8, 5, 0, 0, // Skip to: 21635
/* 21630 */   MCD::OPC_Decode, 235, 6, 133, 1, // Opcode: VEXT2XV_D_H
/* 21635 */   MCD::OPC_FilterValue, 9, 5, 0, 0, // Skip to: 21645
/* 21640 */   MCD::OPC_Decode, 236, 6, 133, 1, // Opcode: VEXT2XV_D_W
/* 21645 */   MCD::OPC_FilterValue, 10, 5, 0, 0, // Skip to: 21655
/* 21650 */   MCD::OPC_Decode, 237, 6, 133, 1, // Opcode: VEXT2XV_HU_BU
/* 21655 */   MCD::OPC_FilterValue, 11, 5, 0, 0, // Skip to: 21665
/* 21660 */   MCD::OPC_Decode, 239, 6, 133, 1, // Opcode: VEXT2XV_WU_BU
/* 21665 */   MCD::OPC_FilterValue, 12, 5, 0, 0, // Skip to: 21675
/* 21670 */   MCD::OPC_Decode, 231, 6, 133, 1, // Opcode: VEXT2XV_DU_BU
/* 21675 */   MCD::OPC_FilterValue, 13, 5, 0, 0, // Skip to: 21685
/* 21680 */   MCD::OPC_Decode, 240, 6, 133, 1, // Opcode: VEXT2XV_WU_HU
/* 21685 */   MCD::OPC_FilterValue, 14, 5, 0, 0, // Skip to: 21695
/* 21690 */   MCD::OPC_Decode, 232, 6, 133, 1, // Opcode: VEXT2XV_DU_HU
/* 21695 */   MCD::OPC_FilterValue, 15, 12, 9, 0, // Skip to: 24016
/* 21700 */   MCD::OPC_Decode, 233, 6, 133, 1, // Opcode: VEXT2XV_DU_WU
/* 21705 */   MCD::OPC_FilterValue, 7, 2, 9, 0, // Skip to: 24016
/* 21710 */   MCD::OPC_Decode, 202, 14, 131, 1, // Opcode: XVHSELI_D
/* 21715 */   MCD::OPC_FilterValue, 168, 1, 66, 0, 0, // Skip to: 21787
/* 21721 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 21724 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 21777
/* 21729 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 21732 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 21767
/* 21737 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 21740 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 21757
/* 21745 */   MCD::OPC_CheckField, 13, 1, 1, 216, 8, 0, // Skip to: 24016
/* 21752 */   MCD::OPC_Decode, 144, 16, 136, 1, // Opcode: XVROTRI_B
/* 21757 */   MCD::OPC_FilterValue, 1, 206, 8, 0, // Skip to: 24016
/* 21762 */   MCD::OPC_Decode, 146, 16, 137, 1, // Opcode: XVROTRI_H
/* 21767 */   MCD::OPC_FilterValue, 1, 196, 8, 0, // Skip to: 24016
/* 21772 */   MCD::OPC_Decode, 147, 16, 131, 1, // Opcode: XVROTRI_W
/* 21777 */   MCD::OPC_FilterValue, 1, 186, 8, 0, // Skip to: 24016
/* 21782 */   MCD::OPC_Decode, 145, 16, 138, 1, // Opcode: XVROTRI_D
/* 21787 */   MCD::OPC_FilterValue, 169, 1, 66, 0, 0, // Skip to: 21859
/* 21793 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 21796 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 21849
/* 21801 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 21804 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 21839
/* 21809 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 21812 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 21829
/* 21817 */   MCD::OPC_CheckField, 13, 1, 1, 144, 8, 0, // Skip to: 24016
/* 21824 */   MCD::OPC_Decode, 157, 17, 136, 1, // Opcode: XVSRLRI_B
/* 21829 */   MCD::OPC_FilterValue, 1, 134, 8, 0, // Skip to: 24016
/* 21834 */   MCD::OPC_Decode, 159, 17, 137, 1, // Opcode: XVSRLRI_H
/* 21839 */   MCD::OPC_FilterValue, 1, 124, 8, 0, // Skip to: 24016
/* 21844 */   MCD::OPC_Decode, 160, 17, 131, 1, // Opcode: XVSRLRI_W
/* 21849 */   MCD::OPC_FilterValue, 1, 114, 8, 0, // Skip to: 24016
/* 21854 */   MCD::OPC_Decode, 158, 17, 138, 1, // Opcode: XVSRLRI_D
/* 21859 */   MCD::OPC_FilterValue, 170, 1, 66, 0, 0, // Skip to: 21931
/* 21865 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 21868 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 21921
/* 21873 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 21876 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 21911
/* 21881 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 21884 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 21901
/* 21889 */   MCD::OPC_CheckField, 13, 1, 1, 72, 8, 0, // Skip to: 24016
/* 21896 */   MCD::OPC_Decode, 255, 16, 136, 1, // Opcode: XVSRARI_B
/* 21901 */   MCD::OPC_FilterValue, 1, 62, 8, 0, // Skip to: 24016
/* 21906 */   MCD::OPC_Decode, 129, 17, 137, 1, // Opcode: XVSRARI_H
/* 21911 */   MCD::OPC_FilterValue, 1, 52, 8, 0, // Skip to: 24016
/* 21916 */   MCD::OPC_Decode, 130, 17, 131, 1, // Opcode: XVSRARI_W
/* 21921 */   MCD::OPC_FilterValue, 1, 42, 8, 0, // Skip to: 24016
/* 21926 */   MCD::OPC_Decode, 128, 17, 138, 1, // Opcode: XVSRARI_D
/* 21931 */   MCD::OPC_FilterValue, 186, 1, 30, 0, 0, // Skip to: 21967
/* 21937 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 21940 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 21950
/* 21945 */   MCD::OPC_Decode, 220, 14, 139, 1, // Opcode: XVINSGR2VR_W
/* 21950 */   MCD::OPC_FilterValue, 31, 13, 8, 0, // Skip to: 24016
/* 21955 */   MCD::OPC_CheckField, 12, 1, 0, 6, 8, 0, // Skip to: 24016
/* 21962 */   MCD::OPC_Decode, 219, 14, 140, 1, // Opcode: XVINSGR2VR_D
/* 21967 */   MCD::OPC_FilterValue, 187, 1, 30, 0, 0, // Skip to: 22003
/* 21973 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 21976 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 21986
/* 21981 */   MCD::OPC_Decode, 251, 15, 141, 1, // Opcode: XVPICKVE2GR_W
/* 21986 */   MCD::OPC_FilterValue, 31, 233, 7, 0, // Skip to: 24016
/* 21991 */   MCD::OPC_CheckField, 12, 1, 0, 226, 7, 0, // Skip to: 24016
/* 21998 */   MCD::OPC_Decode, 249, 15, 142, 1, // Opcode: XVPICKVE2GR_D
/* 22003 */   MCD::OPC_FilterValue, 188, 1, 30, 0, 0, // Skip to: 22039
/* 22009 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 22012 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 22022
/* 22017 */   MCD::OPC_Decode, 252, 15, 141, 1, // Opcode: XVPICKVE2GR_WU
/* 22022 */   MCD::OPC_FilterValue, 31, 197, 7, 0, // Skip to: 24016
/* 22027 */   MCD::OPC_CheckField, 12, 1, 0, 190, 7, 0, // Skip to: 24016
/* 22034 */   MCD::OPC_Decode, 250, 15, 142, 1, // Opcode: XVPICKVE2GR_DU
/* 22039 */   MCD::OPC_FilterValue, 189, 1, 66, 0, 0, // Skip to: 22111
/* 22045 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 22048 */   MCD::OPC_FilterValue, 14, 5, 0, 0, // Skip to: 22058
/* 22053 */   MCD::OPC_Decode, 255, 15, 137, 1, // Opcode: XVREPL128VEI_B
/* 22058 */   MCD::OPC_FilterValue, 15, 161, 7, 0, // Skip to: 24016
/* 22063 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 22066 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 22076
/* 22071 */   MCD::OPC_Decode, 129, 16, 136, 1, // Opcode: XVREPL128VEI_H
/* 22076 */   MCD::OPC_FilterValue, 1, 143, 7, 0, // Skip to: 24016
/* 22081 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 22084 */   MCD::OPC_FilterValue, 0, 5, 0, 0, // Skip to: 22094
/* 22089 */   MCD::OPC_Decode, 130, 16, 143, 1, // Opcode: XVREPL128VEI_W
/* 22094 */   MCD::OPC_FilterValue, 1, 125, 7, 0, // Skip to: 24016
/* 22099 */   MCD::OPC_CheckField, 11, 1, 0, 118, 7, 0, // Skip to: 24016
/* 22106 */   MCD::OPC_Decode, 128, 16, 144, 1, // Opcode: XVREPL128VEI_D
/* 22111 */   MCD::OPC_FilterValue, 191, 1, 30, 0, 0, // Skip to: 22147
/* 22117 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 22120 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 22130
/* 22125 */   MCD::OPC_Decode, 222, 14, 145, 1, // Opcode: XVINSVE0_W
/* 22130 */   MCD::OPC_FilterValue, 31, 89, 7, 0, // Skip to: 24016
/* 22135 */   MCD::OPC_CheckField, 12, 1, 0, 82, 7, 0, // Skip to: 24016
/* 22142 */   MCD::OPC_Decode, 221, 14, 146, 1, // Opcode: XVINSVE0_D
/* 22147 */   MCD::OPC_FilterValue, 192, 1, 30, 0, 0, // Skip to: 22183
/* 22153 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 22156 */   MCD::OPC_FilterValue, 30, 5, 0, 0, // Skip to: 22166
/* 22161 */   MCD::OPC_Decode, 254, 15, 136, 1, // Opcode: XVPICKVE_W
/* 22166 */   MCD::OPC_FilterValue, 31, 53, 7, 0, // Skip to: 24016
/* 22171 */   MCD::OPC_CheckField, 12, 1, 0, 46, 7, 0, // Skip to: 24016
/* 22178 */   MCD::OPC_Decode, 253, 15, 143, 1, // Opcode: XVPICKVE_D
/* 22183 */   MCD::OPC_FilterValue, 193, 1, 58, 0, 0, // Skip to: 22247
/* 22189 */   MCD::OPC_ExtractField, 10, 8,  // Inst{17-10} ...
/* 22192 */   MCD::OPC_FilterValue, 192, 1, 5, 0, 0, // Skip to: 22203
/* 22198 */   MCD::OPC_Decode, 135, 16, 133, 1, // Opcode: XVREPLVE0_B
/* 22203 */   MCD::OPC_FilterValue, 224, 1, 5, 0, 0, // Skip to: 22214
/* 22209 */   MCD::OPC_Decode, 137, 16, 133, 1, // Opcode: XVREPLVE0_H
/* 22214 */   MCD::OPC_FilterValue, 240, 1, 5, 0, 0, // Skip to: 22225
/* 22220 */   MCD::OPC_Decode, 139, 16, 133, 1, // Opcode: XVREPLVE0_W
/* 22225 */   MCD::OPC_FilterValue, 248, 1, 5, 0, 0, // Skip to: 22236
/* 22231 */   MCD::OPC_Decode, 136, 16, 133, 1, // Opcode: XVREPLVE0_D
/* 22236 */   MCD::OPC_FilterValue, 252, 1, 238, 6, 0, // Skip to: 24016
/* 22242 */   MCD::OPC_Decode, 138, 16, 133, 1, // Opcode: XVREPLVE0_Q
/* 22247 */   MCD::OPC_FilterValue, 194, 1, 65, 0, 0, // Skip to: 22318
/* 22253 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 22256 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22291
/* 22261 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22264 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22281
/* 22269 */   MCD::OPC_CheckField, 13, 1, 1, 204, 6, 0, // Skip to: 24016
/* 22276 */   MCD::OPC_Decode, 221, 16, 136, 1, // Opcode: XVSLLWIL_H_B
/* 22281 */   MCD::OPC_FilterValue, 1, 194, 6, 0, // Skip to: 24016
/* 22286 */   MCD::OPC_Decode, 223, 16, 137, 1, // Opcode: XVSLLWIL_W_H
/* 22291 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 22301
/* 22296 */   MCD::OPC_Decode, 219, 16, 131, 1, // Opcode: XVSLLWIL_D_W
/* 22301 */   MCD::OPC_FilterValue, 2, 174, 6, 0, // Skip to: 24016
/* 22306 */   MCD::OPC_CheckField, 10, 5, 0, 167, 6, 0, // Skip to: 24016
/* 22313 */   MCD::OPC_Decode, 183, 13, 133, 1, // Opcode: XVEXTL_Q_D
/* 22318 */   MCD::OPC_FilterValue, 195, 1, 65, 0, 0, // Skip to: 22389
/* 22324 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 22327 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22362
/* 22332 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22335 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22352
/* 22340 */   MCD::OPC_CheckField, 13, 1, 1, 133, 6, 0, // Skip to: 24016
/* 22347 */   MCD::OPC_Decode, 220, 16, 136, 1, // Opcode: XVSLLWIL_HU_BU
/* 22352 */   MCD::OPC_FilterValue, 1, 123, 6, 0, // Skip to: 24016
/* 22357 */   MCD::OPC_Decode, 222, 16, 137, 1, // Opcode: XVSLLWIL_WU_HU
/* 22362 */   MCD::OPC_FilterValue, 1, 5, 0, 0, // Skip to: 22372
/* 22367 */   MCD::OPC_Decode, 218, 16, 131, 1, // Opcode: XVSLLWIL_DU_WU
/* 22372 */   MCD::OPC_FilterValue, 2, 103, 6, 0, // Skip to: 24016
/* 22377 */   MCD::OPC_CheckField, 10, 5, 0, 96, 6, 0, // Skip to: 24016
/* 22384 */   MCD::OPC_Decode, 182, 13, 133, 1, // Opcode: XVEXTL_QU_DU
/* 22389 */   MCD::OPC_FilterValue, 196, 1, 66, 0, 0, // Skip to: 22461
/* 22395 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22398 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22451
/* 22403 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22406 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22441
/* 22411 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22414 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22431
/* 22419 */   MCD::OPC_CheckField, 13, 1, 1, 54, 6, 0, // Skip to: 24016
/* 22426 */   MCD::OPC_Decode, 130, 13, 136, 1, // Opcode: XVBITCLRI_B
/* 22431 */   MCD::OPC_FilterValue, 1, 44, 6, 0, // Skip to: 24016
/* 22436 */   MCD::OPC_Decode, 132, 13, 137, 1, // Opcode: XVBITCLRI_H
/* 22441 */   MCD::OPC_FilterValue, 1, 34, 6, 0, // Skip to: 24016
/* 22446 */   MCD::OPC_Decode, 133, 13, 131, 1, // Opcode: XVBITCLRI_W
/* 22451 */   MCD::OPC_FilterValue, 1, 24, 6, 0, // Skip to: 24016
/* 22456 */   MCD::OPC_Decode, 131, 13, 138, 1, // Opcode: XVBITCLRI_D
/* 22461 */   MCD::OPC_FilterValue, 197, 1, 66, 0, 0, // Skip to: 22533
/* 22467 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22470 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22523
/* 22475 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22478 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22513
/* 22483 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22486 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22503
/* 22491 */   MCD::OPC_CheckField, 13, 1, 1, 238, 5, 0, // Skip to: 24016
/* 22498 */   MCD::OPC_Decode, 148, 13, 136, 1, // Opcode: XVBITSETI_B
/* 22503 */   MCD::OPC_FilterValue, 1, 228, 5, 0, // Skip to: 24016
/* 22508 */   MCD::OPC_Decode, 150, 13, 137, 1, // Opcode: XVBITSETI_H
/* 22513 */   MCD::OPC_FilterValue, 1, 218, 5, 0, // Skip to: 24016
/* 22518 */   MCD::OPC_Decode, 151, 13, 131, 1, // Opcode: XVBITSETI_W
/* 22523 */   MCD::OPC_FilterValue, 1, 208, 5, 0, // Skip to: 24016
/* 22528 */   MCD::OPC_Decode, 149, 13, 138, 1, // Opcode: XVBITSETI_D
/* 22533 */   MCD::OPC_FilterValue, 198, 1, 66, 0, 0, // Skip to: 22605
/* 22539 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22542 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22595
/* 22547 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22550 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22585
/* 22555 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22558 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22575
/* 22563 */   MCD::OPC_CheckField, 13, 1, 1, 166, 5, 0, // Skip to: 24016
/* 22570 */   MCD::OPC_Decode, 138, 13, 136, 1, // Opcode: XVBITREVI_B
/* 22575 */   MCD::OPC_FilterValue, 1, 156, 5, 0, // Skip to: 24016
/* 22580 */   MCD::OPC_Decode, 140, 13, 137, 1, // Opcode: XVBITREVI_H
/* 22585 */   MCD::OPC_FilterValue, 1, 146, 5, 0, // Skip to: 24016
/* 22590 */   MCD::OPC_Decode, 141, 13, 131, 1, // Opcode: XVBITREVI_W
/* 22595 */   MCD::OPC_FilterValue, 1, 136, 5, 0, // Skip to: 24016
/* 22600 */   MCD::OPC_Decode, 139, 13, 138, 1, // Opcode: XVBITREVI_D
/* 22605 */   MCD::OPC_FilterValue, 201, 1, 66, 0, 0, // Skip to: 22677
/* 22611 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22614 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22667
/* 22619 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22622 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22657
/* 22627 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22630 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22647
/* 22635 */   MCD::OPC_CheckField, 13, 1, 1, 94, 5, 0, // Skip to: 24016
/* 22642 */   MCD::OPC_Decode, 160, 16, 136, 1, // Opcode: XVSAT_B
/* 22647 */   MCD::OPC_FilterValue, 1, 84, 5, 0, // Skip to: 24016
/* 22652 */   MCD::OPC_Decode, 164, 16, 137, 1, // Opcode: XVSAT_H
/* 22657 */   MCD::OPC_FilterValue, 1, 74, 5, 0, // Skip to: 24016
/* 22662 */   MCD::OPC_Decode, 166, 16, 131, 1, // Opcode: XVSAT_W
/* 22667 */   MCD::OPC_FilterValue, 1, 64, 5, 0, // Skip to: 24016
/* 22672 */   MCD::OPC_Decode, 162, 16, 138, 1, // Opcode: XVSAT_D
/* 22677 */   MCD::OPC_FilterValue, 202, 1, 66, 0, 0, // Skip to: 22749
/* 22683 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22686 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22739
/* 22691 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22694 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22729
/* 22699 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22702 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22719
/* 22707 */   MCD::OPC_CheckField, 13, 1, 1, 22, 5, 0, // Skip to: 24016
/* 22714 */   MCD::OPC_Decode, 161, 16, 136, 1, // Opcode: XVSAT_BU
/* 22719 */   MCD::OPC_FilterValue, 1, 12, 5, 0, // Skip to: 24016
/* 22724 */   MCD::OPC_Decode, 165, 16, 137, 1, // Opcode: XVSAT_HU
/* 22729 */   MCD::OPC_FilterValue, 1, 2, 5, 0, // Skip to: 24016
/* 22734 */   MCD::OPC_Decode, 167, 16, 131, 1, // Opcode: XVSAT_WU
/* 22739 */   MCD::OPC_FilterValue, 1, 248, 4, 0, // Skip to: 24016
/* 22744 */   MCD::OPC_Decode, 163, 16, 138, 1, // Opcode: XVSAT_DU
/* 22749 */   MCD::OPC_FilterValue, 203, 1, 66, 0, 0, // Skip to: 22821
/* 22755 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22758 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22811
/* 22763 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22766 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22801
/* 22771 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22774 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22791
/* 22779 */   MCD::OPC_CheckField, 13, 1, 1, 206, 4, 0, // Skip to: 24016
/* 22786 */   MCD::OPC_Decode, 214, 16, 136, 1, // Opcode: XVSLLI_B
/* 22791 */   MCD::OPC_FilterValue, 1, 196, 4, 0, // Skip to: 24016
/* 22796 */   MCD::OPC_Decode, 216, 16, 137, 1, // Opcode: XVSLLI_H
/* 22801 */   MCD::OPC_FilterValue, 1, 186, 4, 0, // Skip to: 24016
/* 22806 */   MCD::OPC_Decode, 217, 16, 131, 1, // Opcode: XVSLLI_W
/* 22811 */   MCD::OPC_FilterValue, 1, 176, 4, 0, // Skip to: 24016
/* 22816 */   MCD::OPC_Decode, 215, 16, 138, 1, // Opcode: XVSLLI_D
/* 22821 */   MCD::OPC_FilterValue, 204, 1, 66, 0, 0, // Skip to: 22893
/* 22827 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22830 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22883
/* 22835 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22838 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22873
/* 22843 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22846 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22863
/* 22851 */   MCD::OPC_CheckField, 13, 1, 1, 134, 4, 0, // Skip to: 24016
/* 22858 */   MCD::OPC_Decode, 146, 17, 136, 1, // Opcode: XVSRLI_B
/* 22863 */   MCD::OPC_FilterValue, 1, 124, 4, 0, // Skip to: 24016
/* 22868 */   MCD::OPC_Decode, 148, 17, 137, 1, // Opcode: XVSRLI_H
/* 22873 */   MCD::OPC_FilterValue, 1, 114, 4, 0, // Skip to: 24016
/* 22878 */   MCD::OPC_Decode, 149, 17, 131, 1, // Opcode: XVSRLI_W
/* 22883 */   MCD::OPC_FilterValue, 1, 104, 4, 0, // Skip to: 24016
/* 22888 */   MCD::OPC_Decode, 147, 17, 138, 1, // Opcode: XVSRLI_D
/* 22893 */   MCD::OPC_FilterValue, 205, 1, 66, 0, 0, // Skip to: 22965
/* 22899 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 22902 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 22955
/* 22907 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22910 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 22945
/* 22915 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 22918 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 22935
/* 22923 */   MCD::OPC_CheckField, 13, 1, 1, 62, 4, 0, // Skip to: 24016
/* 22930 */   MCD::OPC_Decode, 244, 16, 136, 1, // Opcode: XVSRAI_B
/* 22935 */   MCD::OPC_FilterValue, 1, 52, 4, 0, // Skip to: 24016
/* 22940 */   MCD::OPC_Decode, 246, 16, 137, 1, // Opcode: XVSRAI_H
/* 22945 */   MCD::OPC_FilterValue, 1, 42, 4, 0, // Skip to: 24016
/* 22950 */   MCD::OPC_Decode, 247, 16, 131, 1, // Opcode: XVSRAI_W
/* 22955 */   MCD::OPC_FilterValue, 1, 32, 4, 0, // Skip to: 24016
/* 22960 */   MCD::OPC_Decode, 245, 16, 138, 1, // Opcode: XVSRAI_D
/* 22965 */   MCD::OPC_FilterValue, 208, 1, 66, 0, 0, // Skip to: 23037
/* 22971 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 22974 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23027
/* 22979 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 22982 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23017
/* 22987 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 22990 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23007
/* 22995 */   MCD::OPC_CheckField, 14, 1, 1, 246, 3, 0, // Skip to: 24016
/* 23002 */   MCD::OPC_Decode, 150, 17, 147, 1, // Opcode: XVSRLNI_B_H
/* 23007 */   MCD::OPC_FilterValue, 1, 236, 3, 0, // Skip to: 24016
/* 23012 */   MCD::OPC_Decode, 152, 17, 132, 1, // Opcode: XVSRLNI_H_W
/* 23017 */   MCD::OPC_FilterValue, 1, 226, 3, 0, // Skip to: 24016
/* 23022 */   MCD::OPC_Decode, 153, 17, 148, 1, // Opcode: XVSRLNI_W_D
/* 23027 */   MCD::OPC_FilterValue, 1, 216, 3, 0, // Skip to: 24016
/* 23032 */   MCD::OPC_Decode, 151, 17, 149, 1, // Opcode: XVSRLNI_D_Q
/* 23037 */   MCD::OPC_FilterValue, 209, 1, 66, 0, 0, // Skip to: 23109
/* 23043 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23046 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23099
/* 23051 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23054 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23089
/* 23059 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23062 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23079
/* 23067 */   MCD::OPC_CheckField, 14, 1, 1, 174, 3, 0, // Skip to: 24016
/* 23074 */   MCD::OPC_Decode, 161, 17, 147, 1, // Opcode: XVSRLRNI_B_H
/* 23079 */   MCD::OPC_FilterValue, 1, 164, 3, 0, // Skip to: 24016
/* 23084 */   MCD::OPC_Decode, 163, 17, 132, 1, // Opcode: XVSRLRNI_H_W
/* 23089 */   MCD::OPC_FilterValue, 1, 154, 3, 0, // Skip to: 24016
/* 23094 */   MCD::OPC_Decode, 164, 17, 148, 1, // Opcode: XVSRLRNI_W_D
/* 23099 */   MCD::OPC_FilterValue, 1, 144, 3, 0, // Skip to: 24016
/* 23104 */   MCD::OPC_Decode, 162, 17, 149, 1, // Opcode: XVSRLRNI_D_Q
/* 23109 */   MCD::OPC_FilterValue, 210, 1, 66, 0, 0, // Skip to: 23181
/* 23115 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23118 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23171
/* 23123 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23126 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23161
/* 23131 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23134 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23151
/* 23139 */   MCD::OPC_CheckField, 14, 1, 1, 102, 3, 0, // Skip to: 24016
/* 23146 */   MCD::OPC_Decode, 205, 17, 147, 1, // Opcode: XVSSRLNI_B_H
/* 23151 */   MCD::OPC_FilterValue, 1, 92, 3, 0, // Skip to: 24016
/* 23156 */   MCD::OPC_Decode, 209, 17, 132, 1, // Opcode: XVSSRLNI_H_W
/* 23161 */   MCD::OPC_FilterValue, 1, 82, 3, 0, // Skip to: 24016
/* 23166 */   MCD::OPC_Decode, 211, 17, 148, 1, // Opcode: XVSSRLNI_W_D
/* 23171 */   MCD::OPC_FilterValue, 1, 72, 3, 0, // Skip to: 24016
/* 23176 */   MCD::OPC_Decode, 207, 17, 149, 1, // Opcode: XVSSRLNI_D_Q
/* 23181 */   MCD::OPC_FilterValue, 211, 1, 66, 0, 0, // Skip to: 23253
/* 23187 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23190 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23243
/* 23195 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23198 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23233
/* 23203 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23206 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23223
/* 23211 */   MCD::OPC_CheckField, 14, 1, 1, 30, 3, 0, // Skip to: 24016
/* 23218 */   MCD::OPC_Decode, 204, 17, 147, 1, // Opcode: XVSSRLNI_BU_H
/* 23223 */   MCD::OPC_FilterValue, 1, 20, 3, 0, // Skip to: 24016
/* 23228 */   MCD::OPC_Decode, 208, 17, 132, 1, // Opcode: XVSSRLNI_HU_W
/* 23233 */   MCD::OPC_FilterValue, 1, 10, 3, 0, // Skip to: 24016
/* 23238 */   MCD::OPC_Decode, 210, 17, 148, 1, // Opcode: XVSSRLNI_WU_D
/* 23243 */   MCD::OPC_FilterValue, 1, 0, 3, 0, // Skip to: 24016
/* 23248 */   MCD::OPC_Decode, 206, 17, 149, 1, // Opcode: XVSSRLNI_DU_Q
/* 23253 */   MCD::OPC_FilterValue, 212, 1, 66, 0, 0, // Skip to: 23325
/* 23259 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23262 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23315
/* 23267 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23270 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23305
/* 23275 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23278 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23295
/* 23283 */   MCD::OPC_CheckField, 14, 1, 1, 214, 2, 0, // Skip to: 24016
/* 23290 */   MCD::OPC_Decode, 219, 17, 147, 1, // Opcode: XVSSRLRNI_B_H
/* 23295 */   MCD::OPC_FilterValue, 1, 204, 2, 0, // Skip to: 24016
/* 23300 */   MCD::OPC_Decode, 223, 17, 132, 1, // Opcode: XVSSRLRNI_H_W
/* 23305 */   MCD::OPC_FilterValue, 1, 194, 2, 0, // Skip to: 24016
/* 23310 */   MCD::OPC_Decode, 225, 17, 148, 1, // Opcode: XVSSRLRNI_W_D
/* 23315 */   MCD::OPC_FilterValue, 1, 184, 2, 0, // Skip to: 24016
/* 23320 */   MCD::OPC_Decode, 221, 17, 149, 1, // Opcode: XVSSRLRNI_D_Q
/* 23325 */   MCD::OPC_FilterValue, 213, 1, 66, 0, 0, // Skip to: 23397
/* 23331 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23334 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23387
/* 23339 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23342 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23377
/* 23347 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23350 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23367
/* 23355 */   MCD::OPC_CheckField, 14, 1, 1, 142, 2, 0, // Skip to: 24016
/* 23362 */   MCD::OPC_Decode, 218, 17, 147, 1, // Opcode: XVSSRLRNI_BU_H
/* 23367 */   MCD::OPC_FilterValue, 1, 132, 2, 0, // Skip to: 24016
/* 23372 */   MCD::OPC_Decode, 222, 17, 132, 1, // Opcode: XVSSRLRNI_HU_W
/* 23377 */   MCD::OPC_FilterValue, 1, 122, 2, 0, // Skip to: 24016
/* 23382 */   MCD::OPC_Decode, 224, 17, 148, 1, // Opcode: XVSSRLRNI_WU_D
/* 23387 */   MCD::OPC_FilterValue, 1, 112, 2, 0, // Skip to: 24016
/* 23392 */   MCD::OPC_Decode, 220, 17, 149, 1, // Opcode: XVSSRLRNI_DU_Q
/* 23397 */   MCD::OPC_FilterValue, 214, 1, 66, 0, 0, // Skip to: 23469
/* 23403 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23406 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23459
/* 23411 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23414 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23449
/* 23419 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23422 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23439
/* 23427 */   MCD::OPC_CheckField, 14, 1, 1, 70, 2, 0, // Skip to: 24016
/* 23434 */   MCD::OPC_Decode, 248, 16, 147, 1, // Opcode: XVSRANI_B_H
/* 23439 */   MCD::OPC_FilterValue, 1, 60, 2, 0, // Skip to: 24016
/* 23444 */   MCD::OPC_Decode, 250, 16, 132, 1, // Opcode: XVSRANI_H_W
/* 23449 */   MCD::OPC_FilterValue, 1, 50, 2, 0, // Skip to: 24016
/* 23454 */   MCD::OPC_Decode, 251, 16, 148, 1, // Opcode: XVSRANI_W_D
/* 23459 */   MCD::OPC_FilterValue, 1, 40, 2, 0, // Skip to: 24016
/* 23464 */   MCD::OPC_Decode, 249, 16, 149, 1, // Opcode: XVSRANI_D_Q
/* 23469 */   MCD::OPC_FilterValue, 215, 1, 66, 0, 0, // Skip to: 23541
/* 23475 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23478 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23531
/* 23483 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23486 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23521
/* 23491 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23494 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23511
/* 23499 */   MCD::OPC_CheckField, 14, 1, 1, 254, 1, 0, // Skip to: 24016
/* 23506 */   MCD::OPC_Decode, 131, 17, 147, 1, // Opcode: XVSRARNI_B_H
/* 23511 */   MCD::OPC_FilterValue, 1, 244, 1, 0, // Skip to: 24016
/* 23516 */   MCD::OPC_Decode, 133, 17, 132, 1, // Opcode: XVSRARNI_H_W
/* 23521 */   MCD::OPC_FilterValue, 1, 234, 1, 0, // Skip to: 24016
/* 23526 */   MCD::OPC_Decode, 134, 17, 148, 1, // Opcode: XVSRARNI_W_D
/* 23531 */   MCD::OPC_FilterValue, 1, 224, 1, 0, // Skip to: 24016
/* 23536 */   MCD::OPC_Decode, 132, 17, 149, 1, // Opcode: XVSRARNI_D_Q
/* 23541 */   MCD::OPC_FilterValue, 216, 1, 66, 0, 0, // Skip to: 23613
/* 23547 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23550 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23603
/* 23555 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23558 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23593
/* 23563 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23566 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23583
/* 23571 */   MCD::OPC_CheckField, 14, 1, 1, 182, 1, 0, // Skip to: 24016
/* 23578 */   MCD::OPC_Decode, 177, 17, 147, 1, // Opcode: XVSSRANI_B_H
/* 23583 */   MCD::OPC_FilterValue, 1, 172, 1, 0, // Skip to: 24016
/* 23588 */   MCD::OPC_Decode, 181, 17, 132, 1, // Opcode: XVSSRANI_H_W
/* 23593 */   MCD::OPC_FilterValue, 1, 162, 1, 0, // Skip to: 24016
/* 23598 */   MCD::OPC_Decode, 183, 17, 148, 1, // Opcode: XVSSRANI_W_D
/* 23603 */   MCD::OPC_FilterValue, 1, 152, 1, 0, // Skip to: 24016
/* 23608 */   MCD::OPC_Decode, 179, 17, 149, 1, // Opcode: XVSSRANI_D_Q
/* 23613 */   MCD::OPC_FilterValue, 217, 1, 66, 0, 0, // Skip to: 23685
/* 23619 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23622 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23675
/* 23627 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23630 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23665
/* 23635 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23638 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23655
/* 23643 */   MCD::OPC_CheckField, 14, 1, 1, 110, 1, 0, // Skip to: 24016
/* 23650 */   MCD::OPC_Decode, 176, 17, 147, 1, // Opcode: XVSSRANI_BU_H
/* 23655 */   MCD::OPC_FilterValue, 1, 100, 1, 0, // Skip to: 24016
/* 23660 */   MCD::OPC_Decode, 180, 17, 132, 1, // Opcode: XVSSRANI_HU_W
/* 23665 */   MCD::OPC_FilterValue, 1, 90, 1, 0, // Skip to: 24016
/* 23670 */   MCD::OPC_Decode, 182, 17, 148, 1, // Opcode: XVSSRANI_WU_D
/* 23675 */   MCD::OPC_FilterValue, 1, 80, 1, 0, // Skip to: 24016
/* 23680 */   MCD::OPC_Decode, 178, 17, 149, 1, // Opcode: XVSSRANI_DU_Q
/* 23685 */   MCD::OPC_FilterValue, 218, 1, 66, 0, 0, // Skip to: 23757
/* 23691 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23694 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23747
/* 23699 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23702 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23737
/* 23707 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23710 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23727
/* 23715 */   MCD::OPC_CheckField, 14, 1, 1, 38, 1, 0, // Skip to: 24016
/* 23722 */   MCD::OPC_Decode, 191, 17, 147, 1, // Opcode: XVSSRARNI_B_H
/* 23727 */   MCD::OPC_FilterValue, 1, 28, 1, 0, // Skip to: 24016
/* 23732 */   MCD::OPC_Decode, 195, 17, 132, 1, // Opcode: XVSSRARNI_H_W
/* 23737 */   MCD::OPC_FilterValue, 1, 18, 1, 0, // Skip to: 24016
/* 23742 */   MCD::OPC_Decode, 197, 17, 148, 1, // Opcode: XVSSRARNI_W_D
/* 23747 */   MCD::OPC_FilterValue, 1, 8, 1, 0, // Skip to: 24016
/* 23752 */   MCD::OPC_Decode, 193, 17, 149, 1, // Opcode: XVSSRARNI_D_Q
/* 23757 */   MCD::OPC_FilterValue, 219, 1, 66, 0, 0, // Skip to: 23829
/* 23763 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 23766 */   MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 23819
/* 23771 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 23774 */   MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 23809
/* 23779 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 23782 */   MCD::OPC_FilterValue, 0, 12, 0, 0, // Skip to: 23799
/* 23787 */   MCD::OPC_CheckField, 14, 1, 1, 222, 0, 0, // Skip to: 24016
/* 23794 */   MCD::OPC_Decode, 190, 17, 147, 1, // Opcode: XVSSRARNI_BU_H
/* 23799 */   MCD::OPC_FilterValue, 1, 212, 0, 0, // Skip to: 24016
/* 23804 */   MCD::OPC_Decode, 194, 17, 132, 1, // Opcode: XVSSRARNI_HU_W
/* 23809 */   MCD::OPC_FilterValue, 1, 202, 0, 0, // Skip to: 24016
/* 23814 */   MCD::OPC_Decode, 196, 17, 148, 1, // Opcode: XVSSRARNI_WU_D
/* 23819 */   MCD::OPC_FilterValue, 1, 192, 0, 0, // Skip to: 24016
/* 23824 */   MCD::OPC_Decode, 192, 17, 149, 1, // Opcode: XVSSRARNI_DU_Q
/* 23829 */   MCD::OPC_FilterValue, 224, 1, 5, 0, 0, // Skip to: 23840
/* 23835 */   MCD::OPC_Decode, 185, 13, 150, 1, // Opcode: XVEXTRINS_D
/* 23840 */   MCD::OPC_FilterValue, 225, 1, 5, 0, 0, // Skip to: 23851
/* 23846 */   MCD::OPC_Decode, 187, 13, 150, 1, // Opcode: XVEXTRINS_W
/* 23851 */   MCD::OPC_FilterValue, 226, 1, 5, 0, 0, // Skip to: 23862
/* 23857 */   MCD::OPC_Decode, 186, 13, 150, 1, // Opcode: XVEXTRINS_H
/* 23862 */   MCD::OPC_FilterValue, 227, 1, 5, 0, 0, // Skip to: 23873
/* 23868 */   MCD::OPC_Decode, 184, 13, 150, 1, // Opcode: XVEXTRINS_B
/* 23873 */   MCD::OPC_FilterValue, 228, 1, 5, 0, 0, // Skip to: 23884
/* 23879 */   MCD::OPC_Decode, 186, 16, 151, 1, // Opcode: XVSHUF4I_B
/* 23884 */   MCD::OPC_FilterValue, 229, 1, 5, 0, 0, // Skip to: 23895
/* 23890 */   MCD::OPC_Decode, 188, 16, 151, 1, // Opcode: XVSHUF4I_H
/* 23895 */   MCD::OPC_FilterValue, 230, 1, 5, 0, 0, // Skip to: 23906
/* 23901 */   MCD::OPC_Decode, 189, 16, 151, 1, // Opcode: XVSHUF4I_W
/* 23906 */   MCD::OPC_FilterValue, 231, 1, 5, 0, 0, // Skip to: 23917
/* 23912 */   MCD::OPC_Decode, 187, 16, 150, 1, // Opcode: XVSHUF4I_D
/* 23917 */   MCD::OPC_FilterValue, 241, 1, 5, 0, 0, // Skip to: 23928
/* 23923 */   MCD::OPC_Decode, 146, 13, 150, 1, // Opcode: XVBITSELI_B
/* 23928 */   MCD::OPC_FilterValue, 244, 1, 5, 0, 0, // Skip to: 23939
/* 23934 */   MCD::OPC_Decode, 239, 12, 151, 1, // Opcode: XVANDI_B
/* 23939 */   MCD::OPC_FilterValue, 245, 1, 5, 0, 0, // Skip to: 23950
/* 23945 */   MCD::OPC_Decode, 222, 15, 151, 1, // Opcode: XVORI_B
/* 23950 */   MCD::OPC_FilterValue, 246, 1, 5, 0, 0, // Skip to: 23961
/* 23956 */   MCD::OPC_Decode, 143, 18, 151, 1, // Opcode: XVXORI_B
/* 23961 */   MCD::OPC_FilterValue, 247, 1, 5, 0, 0, // Skip to: 23972
/* 23967 */   MCD::OPC_Decode, 220, 15, 151, 1, // Opcode: XVNORI_B
/* 23972 */   MCD::OPC_FilterValue, 248, 1, 5, 0, 0, // Skip to: 23983
/* 23978 */   MCD::OPC_Decode, 224, 14, 152, 1, // Opcode: XVLDI
/* 23983 */   MCD::OPC_FilterValue, 249, 1, 5, 0, 0, // Skip to: 23994
/* 23989 */   MCD::OPC_Decode, 239, 15, 150, 1, // Opcode: XVPERMI_W
/* 23994 */   MCD::OPC_FilterValue, 250, 1, 5, 0, 0, // Skip to: 24005
/* 24000 */   MCD::OPC_Decode, 237, 15, 151, 1, // Opcode: XVPERMI_D
/* 24005 */   MCD::OPC_FilterValue, 251, 1, 5, 0, 0, // Skip to: 24016
/* 24011 */   MCD::OPC_Decode, 238, 15, 150, 1, // Opcode: XVPERMI_Q
/* 24016 */   MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[LoongArch::Feature64Bit]);
  }
}

template <typename InsnType>
static DecodeStatus decodeToMCInst(DecodeStatus S, unsigned Idx, InsnType insn, MCInst &MI,
                                   uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 2);
    if (!Check(S, DecodeSCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 2);
    if (!Check(S, DecodeSCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 5, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 2);
    if (!Check(S, decodeUImmOperand<2, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 0, 15);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 37:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 39:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 40:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFCSRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 41:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFCSRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 42:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 43:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 44:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 45:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 46:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 47:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 48:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 49:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeUImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 50:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 51:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 52:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 53:
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 54:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 55:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 56:
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 57:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 58:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 59:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 60:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 61:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 62:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 63:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 64:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 65:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 66:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 67:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 20);
    if (!Check(S, decodeSImmOperand<20>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 68:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 20);
    if (!Check(S, decodeSImmOperand<20>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 69:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    if (!Check(S, decodeSImmOperand<14, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 70:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    if (!Check(S, decodeSImmOperand<14, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 71:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 72:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 73:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 74:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 75:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 9);
    if (!Check(S, decodeSImmOperand<9, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 76:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 10);
    if (!Check(S, decodeSImmOperand<10, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 77:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 11);
    if (!Check(S, decodeSImmOperand<11, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 78:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 79:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 80:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 81:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 82:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 9);
    if (!Check(S, decodeSImmOperand<9, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 83:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 10);
    if (!Check(S, decodeSImmOperand<10, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 84:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 11);
    if (!Check(S, decodeSImmOperand<11, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 85:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 86:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 87:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8,1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 88:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 89:
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 90:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 91:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 92:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 93:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 94:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 95:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 96:
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 97:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 98:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 99:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 16, 10);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<26, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 100:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 101:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 102:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 103:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 104:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 105:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 106:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 107:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 108:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 109:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 110:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 111:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 112:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 113:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 114:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 115:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 116:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 117:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 118:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 119:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 120:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 121:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 122:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 123:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 124:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 7);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 125:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 126:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 127:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 13);
    if (!Check(S, decodeSImmOperand<13>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 128:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 129:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 130:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 131:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 132:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 133:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 134:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 135:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 136:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 137:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 138:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 139:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 140:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 141:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 142:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 143:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 144:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 145:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 146:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 147:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 148:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 149:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 7);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 150:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 151:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 152:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 13);
    if (!Check(S, decodeSImmOperand<13>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    switch (*Ptr) {
    default:
      errs() << Loc << ": Unexpected decode table opcode!\n";
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      unsigned Start = *++Ptr;
      unsigned Len = *++Ptr;
      ++Ptr;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue: {
      // Decode the field value.
      unsigned Len;
      uint64_t Val = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the filter operation.
      if (Val != CurFieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_FilterValue(" << Val << ", " << NumToSkip
                   << "): " << ((Val != CurFieldValue) ? "FAIL:" : "PASS:")
                   << " continuing at " << (Ptr - DecodeTable) << "\n");

      break;
    }
    case MCD::OPC_CheckField: {
      unsigned Start = *++Ptr;
      unsigned Len = *++Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // If the actual and expected values don't match, skip.
      if (ExpectedValue != FieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckField(" << Start << ", "
                   << Len << ", " << ExpectedValue << ", " << NumToSkip
                   << "): FieldValue = " << FieldValue << ", ExpectedValue = "
                   << ExpectedValue << ": "
                   << ((ExpectedValue == FieldValue) ? "PASS\n" : "FAIL\n"));
      break;
    }
    case MCD::OPC_CheckPredicate: {
      unsigned Len;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;
      // Check the predicate.
      bool Pred;
      if (!(Pred = checkDecoderPredicate(PIdx, Bits)))
        Ptr += NumToSkip;
      (void)Pred;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckPredicate(" << PIdx << "): "
            << (Pred ? "PASS\n" : "FAIL\n"));

      break;
    }
    case MCD::OPC_Decode: {
      unsigned Len;
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      unsigned DecodeIdx = decodeULEB128(Ptr, &Len);
      Ptr += Len;

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
      return S;
    }
    case MCD::OPC_TryDecode: {
      unsigned Len;
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      unsigned DecodeIdx = decodeULEB128(Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the decode operation.
      MCInst TmpMI;
      TmpMI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, TmpMI, Address, DisAsm, DecodeComplete);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_TryDecode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": ");

      if (DecodeComplete) {
        // Decoding complete.
        LLVM_DEBUG(dbgs() << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
        MI = TmpMI;
        return S;
      } else {
        assert(S == MCDisassembler::Fail);
        // If the decoding was incomplete, skip.
        Ptr += NumToSkip;
        LLVM_DEBUG(dbgs() << "FAIL: continuing at " << (Ptr - DecodeTable) << "\n");
        // Reset decode status. This also drops a SoftFail status that could be
        // set before the decode attempt.
        S = MCDisassembler::Success;
      }
      break;
    }
    case MCD::OPC_SoftFail: {
      // Decode the mask values.
      unsigned Len;
      uint64_t PositiveMask = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      uint64_t NegativeMask = decodeULEB128(Ptr, &Len);
      Ptr += Len;
      bool Fail = (insn & PositiveMask) != 0 || (~insn & NegativeMask) != 0;
      if (Fail)
        S = MCDisassembler::SoftFail;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_SoftFail: " << (Fail ? "FAIL\n" : "PASS\n"));
      break;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // end namespace llvm
