/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 40;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 39,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 36,
  Feature_IsNotISA3_1Bit = 38,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 20,
  Feature_IsNotISAFutureBit = 18,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 31,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_NoP8VectorBit = 30,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 32,
  Feature_NoP10VectorBit = 33,
  Feature_HasHTMBit = 34,
  Feature_IsPPC32Bit = 37,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 35,
  Feature_MMABit = 19,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (!Subtarget->hasP8Vector())
    Features.set(Feature_NoP8VectorBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_In32BitMode,
  GIFBS_In64BitMode,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_IsNotISA3_1,
  GIFBS_NotAIX,
  GIFBS_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasFPU_IsISA3_1,
  GIFBS_HasP8Altivec_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_HasVSX_IsISA3_1,
  GIFBS_In64BitMode_IsISA3_0,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
  GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
  GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
  GIFBS_IsISAFuture_MMA_PrefixInstrs,
  GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
  GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_IsNotISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasFPUBit, Feature_IsISA3_1Bit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_HasVSXBit, Feature_IsISA3_1Bit, },
  {Feature_In64BitModeBit, Feature_IsISA3_0Bit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsBigEndianBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsISA3_0Bit, Feature_IsLittleEndianBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, Feature_NoP9VectorBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_0Bit, Feature_IsPPC64Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsPPC64Bit, Feature_NoP9VectorBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_Msk2Imm = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_Msk4Imm,
  GICXXPred_I64_Predicate_Msk8Imm,
  GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
  GICXXPred_I64_Predicate_imm32SExt16,
  GICXXPred_I64_Predicate_imm64SExt16,
  GICXXPred_I64_Predicate_imm64ZExt32,
  GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
  GICXXPred_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
  }
  case GICXXPred_I64_Predicate_imm32SExt16: {
    
  // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
  // sign extended field.  Used by instructions like 'addi'.
  return (int32_t)Imm == (short)Imm;

    llvm_unreachable("imm32SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64SExt16: {
    
  // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
  // sign extended field.  Used by instructions like 'addi'.
  return (int64_t)Imm == (short)Imm;

    llvm_unreachable("imm64SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64ZExt32: {
    
  // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
  // zero extended field.
  return isUInt<32>(Imm);

    llvm_unreachable("imm64ZExt32 should have returned");
  }
  case GICXXPred_I64_Predicate_immNonAllOneAnyExt8: {
    
  return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));

  }
  case GICXXPred_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("PPCInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ExecInfo, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void PPCInstructionSelector::runCustomAction(unsigned, const MatcherState&) const {
    llvm_unreachable("PPCInstructionSelector does not support custom C++ actions!");
}
const int64_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 231, /*)*//*default:*//*Label 78*/ 83203,
    /*TargetOpcode::G_ADD*//*Label 0*/ 190,
    /*TargetOpcode::G_SUB*//*Label 1*/ 463,
    /*TargetOpcode::G_MUL*//*Label 2*/ 876,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 1129,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 1257,
    /*TargetOpcode::G_SREM*//*Label 5*/ 1385,
    /*TargetOpcode::G_UREM*//*Label 6*/ 1517, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 1649,
    /*TargetOpcode::G_OR*//*Label 8*/ 2265,
    /*TargetOpcode::G_XOR*//*Label 9*/ 2881, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ 4402, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 11*/ 5350, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ 7537,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ 7761,
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 14*/ 7967, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 15*/ 8081, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 16*/ 8099, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 17*/ 8206,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 18*/ 36488,
    /*TargetOpcode::G_ANYEXT*//*Label 19*/ 39204,
    /*TargetOpcode::G_TRUNC*//*Label 20*/ 39371,
    /*TargetOpcode::G_CONSTANT*//*Label 21*/ 39511, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 22*/ 39633, 0,
    /*TargetOpcode::G_ZEXT*//*Label 23*/ 39822,
    /*TargetOpcode::G_SHL*//*Label 24*/ 39989,
    /*TargetOpcode::G_LSHR*//*Label 25*/ 40301,
    /*TargetOpcode::G_ASHR*//*Label 26*/ 40613, 0, 0, 0,
    /*TargetOpcode::G_ROTL*//*Label 27*/ 40931,
    /*TargetOpcode::G_ICMP*//*Label 28*/ 41219,
    /*TargetOpcode::G_FCMP*//*Label 29*/ 44818,
    /*TargetOpcode::G_SELECT*//*Label 30*/ 48000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 31*/ 48338,
    /*TargetOpcode::G_SMULH*//*Label 32*/ 48442,
    /*TargetOpcode::G_UADDSAT*//*Label 33*/ 48546,
    /*TargetOpcode::G_SADDSAT*//*Label 34*/ 48628,
    /*TargetOpcode::G_USUBSAT*//*Label 35*/ 48710,
    /*TargetOpcode::G_SSUBSAT*//*Label 36*/ 48792, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 37*/ 48874,
    /*TargetOpcode::G_FSUB*//*Label 38*/ 49105,
    /*TargetOpcode::G_FMUL*//*Label 39*/ 49336,
    /*TargetOpcode::G_FMA*//*Label 40*/ 49628, 0,
    /*TargetOpcode::G_FDIV*//*Label 41*/ 50238, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 42*/ 50451,
    /*TargetOpcode::G_FPEXT*//*Label 43*/ 52787,
    /*TargetOpcode::G_FPTRUNC*//*Label 44*/ 52917,
    /*TargetOpcode::G_FPTOSI*//*Label 45*/ 53051,
    /*TargetOpcode::G_FPTOUI*//*Label 46*/ 53271,
    /*TargetOpcode::G_SITOFP*//*Label 47*/ 53491,
    /*TargetOpcode::G_UITOFP*//*Label 48*/ 53696,
    /*TargetOpcode::G_FABS*//*Label 49*/ 53901,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 50*/ 54131, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 51*/ 54462,
    /*TargetOpcode::G_FMAXNUM*//*Label 52*/ 54525,
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 53*/ 54588,
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 54*/ 54711, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 55*/ 54834,
    /*TargetOpcode::G_SMAX*//*Label 56*/ 54986,
    /*TargetOpcode::G_UMIN*//*Label 57*/ 55138,
    /*TargetOpcode::G_UMAX*//*Label 58*/ 55290, 0,
    /*TargetOpcode::G_LROUND*//*Label 59*/ 55442,
    /*TargetOpcode::G_LLROUND*//*Label 60*/ 55588,
    /*TargetOpcode::G_BR*//*Label 61*/ 55734, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 62*/ 55747, 0,
    /*TargetOpcode::G_CTLZ*//*Label 63*/ 55881, 0,
    /*TargetOpcode::G_CTPOP*//*Label 64*/ 56011,
    /*TargetOpcode::G_BSWAP*//*Label 65*/ 56141,
    /*TargetOpcode::G_BITREVERSE*//*Label 66*/ 56360,
    /*TargetOpcode::G_FCEIL*//*Label 67*/ 80610, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 68*/ 80834,
    /*TargetOpcode::G_FFLOOR*//*Label 69*/ 80997,
    /*TargetOpcode::G_FRINT*//*Label 70*/ 81221,
    /*TargetOpcode::G_FNEARBYINT*//*Label 71*/ 81400, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 72*/ 81597,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 73*/ 81810,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 74*/ 82023,
    /*TargetOpcode::G_STRICT_FDIV*//*Label 75*/ 82236, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 76*/ 82449,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 77*/ 83040,
    // Label 0: @190
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 8, /*)*//*default:*//*Label 87*/ 462,
    /*GILLT_s1*//*Label 79*/ 204,
    /*GILLT_s32*//*Label 80*/ 226,
    /*GILLT_s64*//*Label 81*/ 284,
    /*GILLT_s128*//*Label 82*/ 342,
    /*GILLT_v2s64*//*Label 83*/ 366,
    /*GILLT_v4s32*//*Label 84*/ 390,
    /*GILLT_v8s16*//*Label 85*/ 414,
    /*GILLT_v16s8*//*Label 86*/ 438,
    // Label 79: @204
    GIM_Try, /*On fail goto*//*Label 88*/ 225, // Rule ID 3610 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      // (add:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRXOR,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3610,
      GIR_Done,
    // Label 88: @225
    GIM_Reject,
    // Label 80: @226
    GIM_Try, /*On fail goto*//*Label 89*/ 283,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 90*/ 273, // Rule ID 104 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 104,
        GIR_Done,
      // Label 90: @273
      GIM_Try, /*On fail goto*//*Label 91*/ 282, // Rule ID 196 //
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ADD4,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 91: @282
      GIM_Reject,
    // Label 89: @283
    GIM_Reject,
    // Label 81: @284
    GIM_Try, /*On fail goto*//*Label 92*/ 341,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 93*/ 331, // Rule ID 656 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm64SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ADDI8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 656,
        GIR_Done,
      // Label 93: @331
      GIM_Try, /*On fail goto*//*Label 94*/ 340, // Rule ID 652 //
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ADD8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 652,
        GIR_Done,
      // Label 94: @340
      GIM_Reject,
    // Label 92: @341
    GIM_Reject,
    // Label 82: @342
    GIM_Try, /*On fail goto*//*Label 95*/ 365, // Rule ID 467 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUQM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 467,
      GIR_Done,
    // Label 95: @365
    GIM_Reject,
    // Label 83: @366
    GIM_Try, /*On fail goto*//*Label 96*/ 389, // Rule ID 466 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUDM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 466,
      GIR_Done,
    // Label 96: @389
    GIM_Reject,
    // Label 84: @390
    GIM_Try, /*On fail goto*//*Label 97*/ 413, // Rule ID 300 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUWM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 300,
      GIR_Done,
    // Label 97: @413
    GIM_Reject,
    // Label 85: @414
    GIM_Try, /*On fail goto*//*Label 98*/ 437, // Rule ID 299 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUHM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 299,
      GIR_Done,
    // Label 98: @437
    GIM_Reject,
    // Label 86: @438
    GIM_Try, /*On fail goto*//*Label 99*/ 461, // Rule ID 298 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUBM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 298,
      GIR_Done,
    // Label 99: @461
    GIM_Reject,
    // Label 87: @462
    GIM_Reject,
    // Label 1: @463
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 8, /*)*//*default:*//*Label 108*/ 875,
    /*GILLT_s1*//*Label 100*/ 477,
    /*GILLT_s32*//*Label 101*/ 499,
    /*GILLT_s64*//*Label 102*/ 592,
    /*GILLT_s128*//*Label 103*/ 685,
    /*GILLT_v2s64*//*Label 104*/ 709,
    /*GILLT_v4s32*//*Label 105*/ 768,
    /*GILLT_v8s16*//*Label 106*/ 827,
    /*GILLT_v16s8*//*Label 107*/ 851,
    // Label 100: @477
    GIM_Try, /*On fail goto*//*Label 109*/ 498, // Rule ID 3611 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      // (sub:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRXOR,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3611,
      GIR_Done,
    // Label 109: @498
    GIM_Reject,
    // Label 101: @499
    GIM_Try, /*On fail goto*//*Label 110*/ 591,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 111*/ 535, // Rule ID 208 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$RA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NEG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 111: @535
      GIM_Try, /*On fail goto*//*Label 112*/ 568, // Rule ID 1198 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm, i32:{ *:[i32] }:$in)  =>  (SUBFIC:{ *:[i32] }:{ *:[i32] } ?:{ *:[i32] }:$in, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBFIC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 112: @568
      GIM_Try, /*On fail goto*//*Label 113*/ 590, // Rule ID 206 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$RB, i32:{ *:[i32] }:$RA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBF,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 113: @590
      GIM_Reject,
    // Label 110: @591
    GIM_Reject,
    // Label 102: @592
    GIM_Try, /*On fail goto*//*Label 114*/ 684,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 115*/ 628, // Rule ID 662 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$RA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NEG8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 662,
        GIR_Done,
      // Label 115: @628
      GIM_Try, /*On fail goto*//*Label 116*/ 661, // Rule ID 1518 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm64SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm, i64:{ *:[i64] }:$in)  =>  (SUBFIC8:{ *:[i64] }:{ *:[i32] } ?:{ *:[i64] }:$in, (imm:{ *:[i64] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBFIC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1518,
        GIR_Done,
      // Label 116: @661
      GIM_Try, /*On fail goto*//*Label 117*/ 683, // Rule ID 661 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$RB, i64:{ *:[i64] }:$RA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 661,
        GIR_Done,
      // Label 117: @683
      GIM_Reject,
    // Label 114: @684
    GIM_Reject,
    // Label 103: @685
    GIM_Try, /*On fail goto*//*Label 118*/ 708, // Rule ID 472 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUQM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 472,
      GIR_Done,
    // Label 118: @708
    GIM_Reject,
    // Label 104: @709
    GIM_Try, /*On fail goto*//*Label 119*/ 767,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 120*/ 755, // Rule ID 539 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNEGD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 120: @755
      GIM_Try, /*On fail goto*//*Label 121*/ 766, // Rule ID 471 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUDM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 121: @766
      GIM_Reject,
    // Label 119: @767
    GIM_Reject,
    // Label 105: @768
    GIM_Try, /*On fail goto*//*Label 122*/ 826,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 123*/ 814, // Rule ID 538 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNEGW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 123: @814
      GIM_Try, /*On fail goto*//*Label 124*/ 825, // Rule ID 370 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUWM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 124: @825
      GIM_Reject,
    // Label 122: @826
    GIM_Reject,
    // Label 106: @827
    GIM_Try, /*On fail goto*//*Label 125*/ 850, // Rule ID 369 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUHM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 369,
      GIR_Done,
    // Label 125: @850
    GIM_Reject,
    // Label 107: @851
    GIM_Try, /*On fail goto*//*Label 126*/ 874, // Rule ID 368 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUBM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 368,
      GIR_Done,
    // Label 126: @874
    GIM_Reject,
    // Label 108: @875
    GIM_Reject,
    // Label 2: @876
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 7, /*)*//*default:*//*Label 133*/ 1128,
    /*GILLT_s1*//*Label 127*/ 889,
    /*GILLT_s32*//*Label 128*/ 911,
    /*GILLT_s64*//*Label 129*/ 969, 0,
    /*GILLT_v2s64*//*Label 130*/ 1027,
    /*GILLT_v4s32*//*Label 131*/ 1051,
    /*GILLT_v8s16*//*Label 132*/ 1075,
    // Label 127: @889
    GIM_Try, /*On fail goto*//*Label 134*/ 910, // Rule ID 3612 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      // (mul:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRAND:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRAND,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3612,
      GIR_Done,
    // Label 134: @910
    GIM_Reject,
    // Label 128: @911
    GIM_Try, /*On fail goto*//*Label 135*/ 968,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 136*/ 958, // Rule ID 108 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 108,
        GIR_Done,
      // Label 136: @958
      GIM_Try, /*On fail goto*//*Label 137*/ 967, // Rule ID 205 //
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULLW,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 137: @967
      GIM_Reject,
    // Label 135: @968
    GIM_Reject,
    // Label 129: @969
    GIM_Try, /*On fail goto*//*Label 138*/ 1026,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 139*/ 1016, // Rule ID 696 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_imm64SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULLI8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 139: @1016
      GIM_Try, /*On fail goto*//*Label 140*/ 1025, // Rule ID 695 //
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULLD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 140: @1025
      GIM_Reject,
    // Label 138: @1026
    GIM_Reject,
    // Label 130: @1027
    GIM_Try, /*On fail goto*//*Label 141*/ 1050, // Rule ID 1111 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULLD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1111,
      GIR_Done,
    // Label 141: @1050
    GIM_Reject,
    // Label 131: @1051
    GIM_Try, /*On fail goto*//*Label 142*/ 1074, // Rule ID 458 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULUWM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 458,
      GIR_Done,
    // Label 142: @1074
    GIM_Reject,
    // Label 132: @1075
    GIM_Try, /*On fail goto*//*Label 143*/ 1127, // Rule ID 1274 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, (V_SET0H:{ *:[v8i16] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::V_SET0H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMLADDUHM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1274,
      GIR_Done,
    // Label 143: @1127
    GIM_Reject,
    // Label 133: @1128
    GIM_Reject,
    // Label 3: @1129
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 149*/ 1256,
    /*GILLT_s32*//*Label 144*/ 1140,
    /*GILLT_s64*//*Label 145*/ 1162,
    /*GILLT_s128*//*Label 146*/ 1184,
    /*GILLT_v2s64*//*Label 147*/ 1208,
    /*GILLT_v4s32*//*Label 148*/ 1232,
    // Label 144: @1140
    GIM_Try, /*On fail goto*//*Label 150*/ 1161, // Rule ID 199 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 199,
      GIR_Done,
    // Label 150: @1161
    GIM_Reject,
    // Label 145: @1162
    GIM_Try, /*On fail goto*//*Label 151*/ 1183, // Rule ID 687 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 687,
      GIR_Done,
    // Label 151: @1183
    GIM_Reject,
    // Label 146: @1184
    GIM_Try, /*On fail goto*//*Label 152*/ 1207, // Rule ID 1135 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1135,
      GIR_Done,
    // Label 152: @1207
    GIM_Reject,
    // Label 147: @1208
    GIM_Try, /*On fail goto*//*Label 153*/ 1231, // Rule ID 1122 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1122,
      GIR_Done,
    // Label 153: @1231
    GIM_Reject,
    // Label 148: @1232
    GIM_Try, /*On fail goto*//*Label 154*/ 1255, // Rule ID 1120 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1120,
      GIR_Done,
    // Label 154: @1255
    GIM_Reject,
    // Label 149: @1256
    GIM_Reject,
    // Label 4: @1257
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 160*/ 1384,
    /*GILLT_s32*//*Label 155*/ 1268,
    /*GILLT_s64*//*Label 156*/ 1290,
    /*GILLT_s128*//*Label 157*/ 1312,
    /*GILLT_v2s64*//*Label 158*/ 1336,
    /*GILLT_v4s32*//*Label 159*/ 1360,
    // Label 155: @1268
    GIM_Try, /*On fail goto*//*Label 161*/ 1289, // Rule ID 200 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVWU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 200,
      GIR_Done,
    // Label 161: @1289
    GIM_Reject,
    // Label 156: @1290
    GIM_Try, /*On fail goto*//*Label 162*/ 1311, // Rule ID 688 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVDU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 688,
      GIR_Done,
    // Label 162: @1311
    GIM_Reject,
    // Label 157: @1312
    GIM_Try, /*On fail goto*//*Label 163*/ 1335, // Rule ID 1136 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1136,
      GIR_Done,
    // Label 163: @1335
    GIM_Reject,
    // Label 158: @1336
    GIM_Try, /*On fail goto*//*Label 164*/ 1359, // Rule ID 1123 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1123,
      GIR_Done,
    // Label 164: @1359
    GIM_Reject,
    // Label 159: @1360
    GIM_Try, /*On fail goto*//*Label 165*/ 1383, // Rule ID 1121 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1121,
      GIR_Done,
    // Label 165: @1383
    GIM_Reject,
    // Label 160: @1384
    GIM_Reject,
    // Label 5: @1385
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 171*/ 1516,
    /*GILLT_s32*//*Label 166*/ 1396,
    /*GILLT_s64*//*Label 167*/ 1420,
    /*GILLT_s128*//*Label 168*/ 1444,
    /*GILLT_v2s64*//*Label 169*/ 1468,
    /*GILLT_v4s32*//*Label 170*/ 1492,
    // Label 166: @1396
    GIM_Try, /*On fail goto*//*Label 172*/ 1419, // Rule ID 194 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 194,
      GIR_Done,
    // Label 172: @1419
    GIM_Reject,
    // Label 167: @1420
    GIM_Try, /*On fail goto*//*Label 173*/ 1443, // Rule ID 692 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 173: @1443
    GIM_Reject,
    // Label 168: @1444
    GIM_Try, /*On fail goto*//*Label 174*/ 1467, // Rule ID 1145 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1145,
      GIR_Done,
    // Label 174: @1467
    GIM_Reject,
    // Label 169: @1468
    GIM_Try, /*On fail goto*//*Label 175*/ 1491, // Rule ID 1118 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1118,
      GIR_Done,
    // Label 175: @1491
    GIM_Reject,
    // Label 170: @1492
    GIM_Try, /*On fail goto*//*Label 176*/ 1515, // Rule ID 1116 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1116,
      GIR_Done,
    // Label 176: @1515
    GIM_Reject,
    // Label 171: @1516
    GIM_Reject,
    // Label 6: @1517
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 182*/ 1648,
    /*GILLT_s32*//*Label 177*/ 1528,
    /*GILLT_s64*//*Label 178*/ 1552,
    /*GILLT_s128*//*Label 179*/ 1576,
    /*GILLT_v2s64*//*Label 180*/ 1600,
    /*GILLT_v4s32*//*Label 181*/ 1624,
    // Label 177: @1528
    GIM_Try, /*On fail goto*//*Label 183*/ 1551, // Rule ID 195 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 195,
      GIR_Done,
    // Label 183: @1551
    GIM_Reject,
    // Label 178: @1552
    GIM_Try, /*On fail goto*//*Label 184*/ 1575, // Rule ID 693 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 184: @1575
    GIM_Reject,
    // Label 179: @1576
    GIM_Try, /*On fail goto*//*Label 185*/ 1599, // Rule ID 1146 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1146,
      GIR_Done,
    // Label 185: @1599
    GIM_Reject,
    // Label 180: @1600
    GIM_Try, /*On fail goto*//*Label 186*/ 1623, // Rule ID 1119 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1119,
      GIR_Done,
    // Label 186: @1623
    GIM_Reject,
    // Label 181: @1624
    GIM_Try, /*On fail goto*//*Label 187*/ 1647, // Rule ID 1117 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1117,
      GIR_Done,
    // Label 187: @1647
    GIM_Reject,
    // Label 182: @1648
    GIM_Reject,
    // Label 7: @1649
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 192*/ 2264,
    /*GILLT_s1*//*Label 188*/ 1661,
    /*GILLT_s32*//*Label 189*/ 1772,
    /*GILLT_s64*//*Label 190*/ 1883, 0, 0,
    /*GILLT_v4s32*//*Label 191*/ 1994,
    // Label 188: @1661
    GIM_Try, /*On fail goto*//*Label 193*/ 1771,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 194*/ 1718, // Rule ID 4858 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4858,
        GIR_Done,
      // Label 194: @1718
      GIM_Try, /*On fail goto*//*Label 195*/ 1761, // Rule ID 179 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 179,
        GIR_Done,
      // Label 195: @1761
      GIM_Try, /*On fail goto*//*Label 196*/ 1770, // Rule ID 172 //
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 196: @1770
      GIM_Reject,
    // Label 193: @1771
    GIM_Reject,
    // Label 189: @1772
    GIM_Try, /*On fail goto*//*Label 197*/ 1882,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 198*/ 1829, // Rule ID 4852 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4852,
        GIR_Done,
      // Label 198: @1829
      GIM_Try, /*On fail goto*//*Label 199*/ 1872, // Rule ID 120 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 199: @1872
      GIM_Try, /*On fail goto*//*Label 200*/ 1881, // Rule ID 119 //
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 200: @1881
      GIM_Reject,
    // Label 197: @1882
    GIM_Reject,
    // Label 190: @1883
    GIM_Try, /*On fail goto*//*Label 201*/ 1993,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 202*/ 1940, // Rule ID 4865 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4865,
        GIR_Done,
      // Label 202: @1940
      GIM_Try, /*On fail goto*//*Label 203*/ 1983, // Rule ID 640 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 640,
        GIR_Done,
      // Label 203: @1983
      GIM_Try, /*On fail goto*//*Label 204*/ 1992, // Rule ID 639 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::AND8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 204: @1992
      GIM_Reject,
    // Label 201: @1993
    GIM_Reject,
    // Label 191: @1994
    GIM_Try, /*On fail goto*//*Label 205*/ 2263,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 206*/ 2061, // Rule ID 4873 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4873,
        GIR_Done,
      // Label 206: @2061
      GIM_Try, /*On fail goto*//*Label 207*/ 2118, // Rule ID 922 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 207: @2118
      GIM_Try, /*On fail goto*//*Label 208*/ 2133, // Rule ID 921 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 921,
        GIR_Done,
      // Label 208: @2133
      GIM_Try, /*On fail goto*//*Label 209*/ 2190, // Rule ID 4861 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4861,
        GIR_Done,
      // Label 209: @2190
      GIM_Try, /*On fail goto*//*Label 210*/ 2247, // Rule ID 309 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 309,
        GIR_Done,
      // Label 210: @2247
      GIM_Try, /*On fail goto*//*Label 211*/ 2262, // Rule ID 308 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 308,
        GIR_Done,
      // Label 211: @2262
      GIM_Reject,
    // Label 205: @2263
    GIM_Reject,
    // Label 192: @2264
    GIM_Reject,
    // Label 8: @2265
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 216*/ 2880,
    /*GILLT_s1*//*Label 212*/ 2277,
    /*GILLT_s32*//*Label 213*/ 2388,
    /*GILLT_s64*//*Label 214*/ 2499, 0, 0,
    /*GILLT_v4s32*//*Label 215*/ 2610,
    // Label 212: @2277
    GIM_Try, /*On fail goto*//*Label 217*/ 2387,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 218*/ 2334, // Rule ID 4859 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4859,
        GIR_Done,
      // Label 218: @2334
      GIM_Try, /*On fail goto*//*Label 219*/ 2377, // Rule ID 180 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 219: @2377
      GIM_Try, /*On fail goto*//*Label 220*/ 2386, // Rule ID 174 //
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CROR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 220: @2386
      GIM_Reject,
    // Label 217: @2387
    GIM_Reject,
    // Label 213: @2388
    GIM_Try, /*On fail goto*//*Label 221*/ 2498,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 222*/ 2445, // Rule ID 4853 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4853,
        GIR_Done,
      // Label 222: @2445
      GIM_Try, /*On fail goto*//*Label 223*/ 2488, // Rule ID 123 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 123,
        GIR_Done,
      // Label 223: @2488
      GIM_Try, /*On fail goto*//*Label 224*/ 2497, // Rule ID 121 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 224: @2497
      GIM_Reject,
    // Label 221: @2498
    GIM_Reject,
    // Label 214: @2499
    GIM_Try, /*On fail goto*//*Label 225*/ 2609,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 226*/ 2556, // Rule ID 4866 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4866,
        GIR_Done,
      // Label 226: @2556
      GIM_Try, /*On fail goto*//*Label 227*/ 2599, // Rule ID 643 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 643,
        GIR_Done,
      // Label 227: @2599
      GIM_Try, /*On fail goto*//*Label 228*/ 2608, // Rule ID 641 //
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::OR8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 228: @2608
      GIM_Reject,
    // Label 225: @2609
    GIM_Reject,
    // Label 215: @2610
    GIM_Try, /*On fail goto*//*Label 229*/ 2879,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 230*/ 2677, // Rule ID 4876 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4876,
        GIR_Done,
      // Label 230: @2677
      GIM_Try, /*On fail goto*//*Label 231*/ 2734, // Rule ID 935 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 935,
        GIR_Done,
      // Label 231: @2734
      GIM_Try, /*On fail goto*//*Label 232*/ 2749, // Rule ID 924 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 924,
        GIR_Done,
      // Label 232: @2749
      GIM_Try, /*On fail goto*//*Label 233*/ 2806, // Rule ID 4864 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4864,
        GIR_Done,
      // Label 233: @2806
      GIM_Try, /*On fail goto*//*Label 234*/ 2863, // Rule ID 486 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 234: @2863
      GIM_Try, /*On fail goto*//*Label 235*/ 2878, // Rule ID 383 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 235: @2878
      GIM_Reject,
    // Label 229: @2879
    GIM_Reject,
    // Label 216: @2880
    GIM_Reject,
    // Label 9: @2881
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 240*/ 4401,
    /*GILLT_s1*//*Label 236*/ 2893,
    /*GILLT_s32*//*Label 237*/ 3177,
    /*GILLT_s64*//*Label 238*/ 3443, 0, 0,
    /*GILLT_v4s32*//*Label 239*/ 3709,
    // Label 236: @2893
    GIM_Try, /*On fail goto*//*Label 241*/ 3176,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 242*/ 2950, // Rule ID 173 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 242: @2950
      GIM_Try, /*On fail goto*//*Label 243*/ 2993, // Rule ID 176 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 176,
        GIR_Done,
      // Label 243: @2993
      GIM_Try, /*On fail goto*//*Label 244*/ 3036, // Rule ID 4856 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRB)  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4856,
        GIR_Done,
      // Label 244: @3036
      GIM_Try, /*On fail goto*//*Label 245*/ 3079, // Rule ID 177 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 245: @3079
      GIM_Try, /*On fail goto*//*Label 246*/ 3122, // Rule ID 4857 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }))  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4857,
        GIR_Done,
      // Label 246: @3122
      GIM_Try, /*On fail goto*//*Label 247*/ 3144, // Rule ID 178 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } i1:{ *:[i1] }:$CRA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 178,
        GIR_Done,
      // Label 247: @3144
      GIM_Try, /*On fail goto*//*Label 248*/ 3166, // Rule ID 2883 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$in, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } ?:{ *:[i1] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2883,
        GIR_Done,
      // Label 248: @3166
      GIM_Try, /*On fail goto*//*Label 249*/ 3175, // Rule ID 175 //
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRXOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 249: @3175
      GIM_Reject,
    // Label 241: @3176
    GIM_Reject,
    // Label 237: @3177
    GIM_Try, /*On fail goto*//*Label 250*/ 3442,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 251*/ 3234, // Rule ID 118 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NAND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 118,
        GIR_Done,
      // Label 251: @3234
      GIM_Try, /*On fail goto*//*Label 252*/ 3277, // Rule ID 122 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 252: @3277
      GIM_Try, /*On fail goto*//*Label 253*/ 3320, // Rule ID 4854 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }), i32:{ *:[i32] }:$RB)  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4854,
        GIR_Done,
      // Label 253: @3320
      GIM_Try, /*On fail goto*//*Label 254*/ 3363, // Rule ID 124 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 124,
        GIR_Done,
      // Label 254: @3363
      GIM_Try, /*On fail goto*//*Label 255*/ 3406, // Rule ID 4855 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }))  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4855,
        GIR_Done,
      // Label 255: @3406
      GIM_Try, /*On fail goto*//*Label 256*/ 3432, // Rule ID 1194 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } ?:{ *:[i32] }:$in, ?:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1194,
        GIR_Done,
      // Label 256: @3432
      GIM_Try, /*On fail goto*//*Label 257*/ 3441, // Rule ID 125 //
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (XOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 257: @3441
      GIM_Reject,
    // Label 250: @3442
    GIM_Reject,
    // Label 238: @3443
    GIM_Try, /*On fail goto*//*Label 258*/ 3708,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 259*/ 3500, // Rule ID 638 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NAND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NAND8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 638,
        GIR_Done,
      // Label 259: @3500
      GIM_Try, /*On fail goto*//*Label 260*/ 3543, // Rule ID 642 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 642,
        GIR_Done,
      // Label 260: @3543
      GIM_Try, /*On fail goto*//*Label 261*/ 3586, // Rule ID 4867 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }), i64:{ *:[i64] }:$RB)  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4867,
        GIR_Done,
      // Label 261: @3586
      GIM_Try, /*On fail goto*//*Label 262*/ 3629, // Rule ID 644 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 644,
        GIR_Done,
      // Label 262: @3629
      GIM_Try, /*On fail goto*//*Label 263*/ 3672, // Rule ID 4868 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }))  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4868,
        GIR_Done,
      // Label 263: @3672
      GIM_Try, /*On fail goto*//*Label 264*/ 3698, // Rule ID 1504 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$in, -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } ?:{ *:[i64] }:$in, ?:{ *:[i64] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1504,
        GIR_Done,
      // Label 264: @3698
      GIM_Try, /*On fail goto*//*Label 265*/ 3707, // Rule ID 645 //
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (XOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XOR8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 645,
        GIR_Done,
      // Label 265: @3707
      GIM_Reject,
    // Label 258: @3708
    GIM_Reject,
    // Label 239: @3709
    GIM_Try, /*On fail goto*//*Label 266*/ 4400,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 267*/ 3776, // Rule ID 933 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 933,
        GIR_Done,
      // Label 267: @3776
      GIM_Try, /*On fail goto*//*Label 268*/ 3833, // Rule ID 923 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 923,
        GIR_Done,
      // Label 268: @3833
      GIM_Try, /*On fail goto*//*Label 269*/ 3890, // Rule ID 4874 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XB)  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4874,
        GIR_Done,
      // Label 269: @3890
      GIM_Try, /*On fail goto*//*Label 270*/ 3947, // Rule ID 932 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 270: @3947
      GIM_Try, /*On fail goto*//*Label 271*/ 4004, // Rule ID 4875 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }))  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4875,
        GIR_Done,
      // Label 271: @4004
      GIM_Try, /*On fail goto*//*Label 272*/ 4044, // Rule ID 1565 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1565,
        GIR_Done,
      // Label 272: @4044
      GIM_Try, /*On fail goto*//*Label 273*/ 4059, // Rule ID 925 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 925,
        GIR_Done,
      // Label 273: @4059
      GIM_Try, /*On fail goto*//*Label 274*/ 4116, // Rule ID 485 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 274: @4116
      GIM_Try, /*On fail goto*//*Label 275*/ 4173, // Rule ID 382 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 382,
        GIR_Done,
      // Label 275: @4173
      GIM_Try, /*On fail goto*//*Label 276*/ 4230, // Rule ID 4862 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VB)  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4862,
        GIR_Done,
      // Label 276: @4230
      GIM_Try, /*On fail goto*//*Label 277*/ 4287, // Rule ID 484 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 277: @4287
      GIM_Try, /*On fail goto*//*Label 278*/ 4344, // Rule ID 4863 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }))  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4863,
        GIR_Done,
      // Label 278: @4344
      GIM_Try, /*On fail goto*//*Label 279*/ 4384, // Rule ID 1361 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1361,
        GIR_Done,
      // Label 279: @4384
      GIM_Try, /*On fail goto*//*Label 280*/ 4399, // Rule ID 384 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 384,
        GIR_Done,
      // Label 280: @4399
      GIM_Reject,
    // Label 266: @4400
    GIM_Reject,
    // Label 240: @4401
    GIM_Reject,
    // Label 10: @4402
    GIM_Try, /*On fail goto*//*Label 281*/ 4689,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 282*/ 4538, // Rule ID 2107 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::MTVSRD,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::MTVSRD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXPERMDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2107,
        GIR_Done,
      // Label 282: @4538
      GIM_Try, /*On fail goto*//*Label 283*/ 4653, // Rule ID 2110 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::MTVSRD,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::MTVSRD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXPERMDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2110,
        GIR_Done,
      // Label 283: @4653
      GIM_Try, /*On fail goto*//*Label 284*/ 4664, // Rule ID 2853 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rB, i64:{ *:[i64] }:$rA)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MTVSRDD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2853,
        GIR_Done,
      // Label 284: @4664
      GIM_Try, /*On fail goto*//*Label 285*/ 4688, // Rule ID 2857 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRDD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2857,
        GIR_Done,
      // Label 285: @4688
      GIM_Reject,
    // Label 281: @4689
    GIM_Try, /*On fail goto*//*Label 286*/ 5210,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 287*/ 4752, // Rule ID 2021 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_immSExt5NonZero,
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A)  =>  (VSPLTISW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSPLTISW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2021,
        GIR_Done,
      // Label 287: @4752
      GIM_Try, /*On fail goto*//*Label 288*/ 4802, // Rule ID 3352 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A)  =>  (XXSPLTIW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTIW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3352,
        GIR_Done,
      // Label 288: @4802
      GIM_Try, /*On fail goto*//*Label 289*/ 4940, // Rule ID 1713 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FPTRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FPTRUNC,
        // MIs[2] A
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_FPTRUNC,
        // MIs[3] A
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/4, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_FPTRUNC,
        // MIs[4] A
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v4f32] } (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A))  =>  (XXSPLTW:{ *:[v4f32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (XSCVDPSP:{ *:[f64] } f64:{ *:[f64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCVDPSP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1713,
        GIR_Done,
      // Label 289: @4940
      GIM_Try, /*On fail goto*//*Label 290*/ 4998, // Rule ID 1714 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A)  =>  (XXSPLTW:{ *:[v4f32] } (XSCVDPSPN:{ *:[v4f32] } ?:{ *:[f32] }:$A), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCVDPSPN,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1714,
        GIR_Done,
      // Label 290: @4998
      GIM_Try, /*On fail goto*//*Label 291*/ 5084, // Rule ID 2109 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::MTVSRWZ,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2109,
        GIR_Done,
      // Label 291: @5084
      GIM_Try, /*On fail goto*//*Label 292*/ 5170, // Rule ID 2112 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::MTVSRWZ,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2112,
        GIR_Done,
      // Label 292: @5170
      GIM_Try, /*On fail goto*//*Label 293*/ 5209, // Rule ID 2243 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (MTVSRWS:{ *:[v4i32] } ?:{ *:[i32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2243,
        GIR_Done,
      // Label 293: @5209
      GIM_Reject,
    // Label 286: @5210
    GIM_Try, /*On fail goto*//*Label 294*/ 5349, // Rule ID 2244 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
      // MIs[1] Operand 1
      // No operand predicates
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXSPLTIB:{ *:[v4i32] } (imm:{ *:[i32] }):$A), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXSPLTIB,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 2244,
      GIR_Done,
    // Label 294: @5349
    GIM_Reject,
    // Label 11: @5350
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 302*/ 7536,
    /*GILLT_s32*//*Label 295*/ 5363,
    /*GILLT_s64*//*Label 296*/ 5431,
    /*GILLT_s128*//*Label 297*/ 5469,
    /*GILLT_v2s64*//*Label 298*/ 5885,
    /*GILLT_v4s32*//*Label 299*/ 6396,
    /*GILLT_v8s16*//*Label 300*/ 6946,
    /*GILLT_v16s8*//*Label 301*/ 7268,
    // Label 295: @5363
    GIM_Try, /*On fail goto*//*Label 303*/ 5430, // Rule ID 2007 //
      GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (bitconvert:{ *:[i32] } f32:{ *:[f32] }:$A)  =>  (MFVSRWZ:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f64] } (XSCVDPSPN:{ *:[v4i32] } ?:{ *:[f32] }:$A), sub_64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCVDPSPN,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_64,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSSRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::VSRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSRWZ,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 303: @5430
    GIM_Reject,
    // Label 296: @5431
    GIM_Try, /*On fail goto*//*Label 304*/ 5468,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 305*/ 5452, // Rule ID 2009 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (bitconvert:{ *:[i64] } f64:{ *:[f64] }:$A)  =>  (MFVSRD:{ *:[i64] } ?:{ *:[f64] }:$A)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MFVSRD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2009,
        GIR_Done,
      // Label 305: @5452
      GIM_Try, /*On fail goto*//*Label 306*/ 5467, // Rule ID 2010 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (bitconvert:{ *:[f64] } i64:{ *:[i64] }:$S)  =>  (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$S)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MTVSRD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2010,
        GIR_Done,
      // Label 306: @5467
      GIM_Reject,
    // Label 304: @5468
    GIM_Reject,
    // Label 297: @5469
    GIM_Try, /*On fail goto*//*Label 307*/ 5523, // Rule ID 1913 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v1i128] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1913,
      GIR_Done,
    // Label 307: @5523
    GIM_Try, /*On fail goto*//*Label 308*/ 5544, // Rule ID 1600 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1600,
      GIR_Done,
    // Label 308: @5544
    GIM_Try, /*On fail goto*//*Label 309*/ 5578, // Rule ID 1315 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1315,
      GIR_Done,
    // Label 309: @5578
    GIM_Try, /*On fail goto*//*Label 310*/ 5612, // Rule ID 1316 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1316,
      GIR_Done,
    // Label 310: @5612
    GIM_Try, /*On fail goto*//*Label 311*/ 5646, // Rule ID 1317 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1317,
      GIR_Done,
    // Label 311: @5646
    GIM_Try, /*On fail goto*//*Label 312*/ 5680, // Rule ID 1318 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1318,
      GIR_Done,
    // Label 312: @5680
    GIM_Try, /*On fail goto*//*Label 313*/ 5714, // Rule ID 1319 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1319,
      GIR_Done,
    // Label 313: @5714
    GIM_Try, /*On fail goto*//*Label 314*/ 5748, // Rule ID 1320 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1320,
      GIR_Done,
    // Label 314: @5748
    GIM_Try, /*On fail goto*//*Label 315*/ 5782, // Rule ID 1321 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1321,
      GIR_Done,
    // Label 315: @5782
    GIM_Try, /*On fail goto*//*Label 316*/ 5816, // Rule ID 1322 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1322,
      GIR_Done,
    // Label 316: @5816
    GIM_Try, /*On fail goto*//*Label 317*/ 5850, // Rule ID 1323 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1323,
      GIR_Done,
    // Label 317: @5850
    GIM_Try, /*On fail goto*//*Label 318*/ 5884, // Rule ID 1324 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v2f64] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1324,
      GIR_Done,
    // Label 318: @5884
    GIM_Reject,
    // Label 298: @5885
    GIM_Try, /*On fail goto*//*Label 319*/ 5939, // Rule ID 1914 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v2i64] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1914,
      GIR_Done,
    // Label 319: @5939
    GIM_Try, /*On fail goto*//*Label 320*/ 5960, // Rule ID 1581 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1581,
      GIR_Done,
    // Label 320: @5960
    GIM_Try, /*On fail goto*//*Label 321*/ 5981, // Rule ID 1582 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1582,
      GIR_Done,
    // Label 321: @5981
    GIM_Try, /*On fail goto*//*Label 322*/ 6002, // Rule ID 1583 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1583,
      GIR_Done,
    // Label 322: @6002
    GIM_Try, /*On fail goto*//*Label 323*/ 6023, // Rule ID 1584 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1584,
      GIR_Done,
    // Label 323: @6023
    GIM_Try, /*On fail goto*//*Label 324*/ 6044, // Rule ID 1589 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1589,
      GIR_Done,
    // Label 324: @6044
    GIM_Try, /*On fail goto*//*Label 325*/ 6065, // Rule ID 1590 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1590,
      GIR_Done,
    // Label 325: @6065
    GIM_Try, /*On fail goto*//*Label 326*/ 6086, // Rule ID 1591 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1591,
      GIR_Done,
    // Label 326: @6086
    GIM_Try, /*On fail goto*//*Label 327*/ 6107, // Rule ID 1592 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1592,
      GIR_Done,
    // Label 327: @6107
    GIM_Try, /*On fail goto*//*Label 328*/ 6128, // Rule ID 1597 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1597,
      GIR_Done,
    // Label 328: @6128
    GIM_Try, /*On fail goto*//*Label 329*/ 6149, // Rule ID 1598 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1598,
      GIR_Done,
    // Label 329: @6149
    GIM_Try, /*On fail goto*//*Label 330*/ 6170, // Rule ID 1599 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2f64] } v1i128:{ *:[v1i128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v1i128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1599,
      GIR_Done,
    // Label 330: @6170
    GIM_Try, /*On fail goto*//*Label 331*/ 6191, // Rule ID 1601 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 331: @6191
    GIM_Try, /*On fail goto*//*Label 332*/ 6225, // Rule ID 1310 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1310,
      GIR_Done,
    // Label 332: @6225
    GIM_Try, /*On fail goto*//*Label 333*/ 6259, // Rule ID 1311 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1311,
      GIR_Done,
    // Label 333: @6259
    GIM_Try, /*On fail goto*//*Label 334*/ 6293, // Rule ID 1312 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1312,
      GIR_Done,
    // Label 334: @6293
    GIM_Try, /*On fail goto*//*Label 335*/ 6327, // Rule ID 1313 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1313,
      GIR_Done,
    // Label 335: @6327
    GIM_Try, /*On fail goto*//*Label 336*/ 6361, // Rule ID 1314 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1314,
      GIR_Done,
    // Label 336: @6361
    GIM_Try, /*On fail goto*//*Label 337*/ 6395, // Rule ID 1329 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2f64] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1329,
      GIR_Done,
    // Label 337: @6395
    GIM_Reject,
    // Label 299: @6396
    GIM_Try, /*On fail goto*//*Label 338*/ 6432, // Rule ID 934 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v4i32] } immAllOnesV:{ *:[v16i8] })  =>  (XXLEQVOnes:{ *:[v4i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQVOnes,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 934,
      GIR_Done,
    // Label 338: @6432
    GIM_Try, /*On fail goto*//*Label 339*/ 6453, // Rule ID 1585 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1585,
      GIR_Done,
    // Label 339: @6453
    GIM_Try, /*On fail goto*//*Label 340*/ 6474, // Rule ID 1586 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1586,
      GIR_Done,
    // Label 340: @6474
    GIM_Try, /*On fail goto*//*Label 341*/ 6495, // Rule ID 1593 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1593,
      GIR_Done,
    // Label 341: @6495
    GIM_Try, /*On fail goto*//*Label 342*/ 6516, // Rule ID 1594 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1594,
      GIR_Done,
    // Label 342: @6516
    GIM_Try, /*On fail goto*//*Label 343*/ 6537, // Rule ID 1602 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 343: @6537
    GIM_Try, /*On fail goto*//*Label 344*/ 6571, // Rule ID 1300 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1300,
      GIR_Done,
    // Label 344: @6571
    GIM_Try, /*On fail goto*//*Label 345*/ 6605, // Rule ID 1301 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1301,
      GIR_Done,
    // Label 345: @6605
    GIM_Try, /*On fail goto*//*Label 346*/ 6639, // Rule ID 1302 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1302,
      GIR_Done,
    // Label 346: @6639
    GIM_Try, /*On fail goto*//*Label 347*/ 6673, // Rule ID 1303 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1303,
      GIR_Done,
    // Label 347: @6673
    GIM_Try, /*On fail goto*//*Label 348*/ 6707, // Rule ID 1304 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1304,
      GIR_Done,
    // Label 348: @6707
    GIM_Try, /*On fail goto*//*Label 349*/ 6741, // Rule ID 1305 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1305,
      GIR_Done,
    // Label 349: @6741
    GIM_Try, /*On fail goto*//*Label 350*/ 6775, // Rule ID 1306 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1306,
      GIR_Done,
    // Label 350: @6775
    GIM_Try, /*On fail goto*//*Label 351*/ 6809, // Rule ID 1307 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1307,
      GIR_Done,
    // Label 351: @6809
    GIM_Try, /*On fail goto*//*Label 352*/ 6843, // Rule ID 1308 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1308,
      GIR_Done,
    // Label 352: @6843
    GIM_Try, /*On fail goto*//*Label 353*/ 6877, // Rule ID 1309 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1309,
      GIR_Done,
    // Label 353: @6877
    GIM_Try, /*On fail goto*//*Label 354*/ 6911, // Rule ID 1327 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1327,
      GIR_Done,
    // Label 354: @6911
    GIM_Try, /*On fail goto*//*Label 355*/ 6945, // Rule ID 1328 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1328,
      GIR_Done,
    // Label 355: @6945
    GIM_Reject,
    // Label 300: @6946
    GIM_Try, /*On fail goto*//*Label 356*/ 7000, // Rule ID 1915 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v8i16] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1915,
      GIR_Done,
    // Label 356: @7000
    GIM_Try, /*On fail goto*//*Label 357*/ 7021, // Rule ID 1587 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1587,
      GIR_Done,
    // Label 357: @7021
    GIM_Try, /*On fail goto*//*Label 358*/ 7042, // Rule ID 1595 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1595,
      GIR_Done,
    // Label 358: @7042
    GIM_Try, /*On fail goto*//*Label 359*/ 7063, // Rule ID 1603 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 359: @7063
    GIM_Try, /*On fail goto*//*Label 360*/ 7097, // Rule ID 1295 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1295,
      GIR_Done,
    // Label 360: @7097
    GIM_Try, /*On fail goto*//*Label 361*/ 7131, // Rule ID 1296 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1296,
      GIR_Done,
    // Label 361: @7131
    GIM_Try, /*On fail goto*//*Label 362*/ 7165, // Rule ID 1297 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1297,
      GIR_Done,
    // Label 362: @7165
    GIM_Try, /*On fail goto*//*Label 363*/ 7199, // Rule ID 1298 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1298,
      GIR_Done,
    // Label 363: @7199
    GIM_Try, /*On fail goto*//*Label 364*/ 7233, // Rule ID 1299 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1299,
      GIR_Done,
    // Label 364: @7233
    GIM_Try, /*On fail goto*//*Label 365*/ 7267, // Rule ID 1326 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1326,
      GIR_Done,
    // Label 365: @7267
    GIM_Reject,
    // Label 301: @7268
    GIM_Try, /*On fail goto*//*Label 366*/ 7289, // Rule ID 1588 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1588,
      GIR_Done,
    // Label 366: @7289
    GIM_Try, /*On fail goto*//*Label 367*/ 7310, // Rule ID 1596 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1596,
      GIR_Done,
    // Label 367: @7310
    GIM_Try, /*On fail goto*//*Label 368*/ 7331, // Rule ID 1604 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1604,
      GIR_Done,
    // Label 368: @7331
    GIM_Try, /*On fail goto*//*Label 369*/ 7365, // Rule ID 1290 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1290,
      GIR_Done,
    // Label 369: @7365
    GIM_Try, /*On fail goto*//*Label 370*/ 7399, // Rule ID 1291 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1291,
      GIR_Done,
    // Label 370: @7399
    GIM_Try, /*On fail goto*//*Label 371*/ 7433, // Rule ID 1292 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1292,
      GIR_Done,
    // Label 371: @7433
    GIM_Try, /*On fail goto*//*Label 372*/ 7467, // Rule ID 1293 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1293,
      GIR_Done,
    // Label 372: @7467
    GIM_Try, /*On fail goto*//*Label 373*/ 7501, // Rule ID 1294 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1294,
      GIR_Done,
    // Label 373: @7501
    GIM_Try, /*On fail goto*//*Label 374*/ 7535, // Rule ID 1325 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1325,
      GIR_Done,
    // Label 374: @7535
    GIM_Reject,
    // Label 302: @7536
    GIM_Reject,
    // Label 12: @7537
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 380*/ 7760,
    /*GILLT_s32*//*Label 375*/ 7548,
    /*GILLT_s64*//*Label 376*/ 7629,
    /*GILLT_s128*//*Label 377*/ 7667,
    /*GILLT_v2s64*//*Label 378*/ 7702,
    /*GILLT_v4s32*//*Label 379*/ 7722,
    // Label 375: @7548
    GIM_Try, /*On fail goto*//*Label 381*/ 7628,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 382*/ 7612, // Rule ID 1691 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPIZ:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSRDPIZ,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSSRCRegClassID,
        // GIR_Coverage, 1691,
        GIR_Done,
      // Label 382: @7612
      GIM_Try, /*On fail goto*//*Label 383*/ 7627, // Rule ID 147 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRIZS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIZS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 383: @7627
      GIM_Reject,
    // Label 381: @7628
    GIM_Reject,
    // Label 376: @7629
    GIM_Try, /*On fail goto*//*Label 384*/ 7666,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 385*/ 7650, // Rule ID 904 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIZ:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPIZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 904,
        GIR_Done,
      // Label 385: @7650
      GIM_Try, /*On fail goto*//*Label 386*/ 7665, // Rule ID 145 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIZD:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIZD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 386: @7665
      GIM_Reject,
    // Label 384: @7666
    GIM_Reject,
    // Label 377: @7667
    GIM_Try, /*On fail goto*//*Label 387*/ 7701, // Rule ID 2140 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ftrunc:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 1:{ *:[i32] }, ?:{ *:[f128] }:$vB, 1:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSRQPI,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
      GIR_AddImm, /*InsnID*/0, /*Imm*/1,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
      GIR_AddImm, /*InsnID*/0, /*Imm*/1,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2140,
      GIR_Done,
    // Label 387: @7701
    GIM_Reject,
    // Label 378: @7702
    GIM_Try, /*On fail goto*//*Label 388*/ 7721, // Rule ID 912 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (ftrunc:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIZ:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 912,
      GIR_Done,
    // Label 388: @7721
    GIM_Reject,
    // Label 379: @7722
    GIM_Try, /*On fail goto*//*Label 389*/ 7759,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 390*/ 7743, // Rule ID 920 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPIZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 920,
        GIR_Done,
      // Label 390: @7743
      GIM_Try, /*On fail goto*//*Label 391*/ 7758, // Rule ID 1400 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA)  =>  (VRFIZ:{ *:[v4f32] } ?:{ *:[v4f32] }:$vA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRFIZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1400,
        GIR_Done,
      // Label 391: @7758
      GIM_Reject,
    // Label 389: @7759
    GIM_Reject,
    // Label 380: @7760
    GIM_Reject,
    // Label 13: @7761
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 397*/ 7966,
    /*GILLT_s32*//*Label 392*/ 7772,
    /*GILLT_s64*//*Label 393*/ 7853,
    /*GILLT_s128*//*Label 394*/ 7891,
    /*GILLT_v2s64*//*Label 395*/ 7926,
    /*GILLT_v4s32*//*Label 396*/ 7946,
    // Label 392: @7772
    GIM_Try, /*On fail goto*//*Label 398*/ 7852,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 399*/ 7836, // Rule ID 1685 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPI:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSRDPI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSSRCRegClassID,
        // GIR_Coverage, 1685,
        GIR_Done,
      // Label 399: @7836
      GIM_Try, /*On fail goto*//*Label 400*/ 7851, // Rule ID 139 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRINS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRINS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 400: @7851
      GIM_Reject,
    // Label 398: @7852
    GIM_Reject,
    // Label 393: @7853
    GIM_Try, /*On fail goto*//*Label 401*/ 7890,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 402*/ 7874, // Rule ID 898 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPI:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPI,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 898,
        GIR_Done,
      // Label 402: @7874
      GIM_Try, /*On fail goto*//*Label 403*/ 7889, // Rule ID 137 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIND:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 403: @7889
      GIM_Reject,
    // Label 401: @7890
    GIM_Reject,
    // Label 394: @7891
    GIM_Try, /*On fail goto*//*Label 404*/ 7925, // Rule ID 2138 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fround:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 0:{ *:[i32] }, ?:{ *:[f128] }:$vB, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSRQPI,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2138,
      GIR_Done,
    // Label 404: @7925
    GIM_Reject,
    // Label 395: @7926
    GIM_Try, /*On fail goto*//*Label 405*/ 7945, // Rule ID 906 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fround:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPI:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 405: @7945
    GIM_Reject,
    // Label 396: @7946
    GIM_Try, /*On fail goto*//*Label 406*/ 7965, // Rule ID 914 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fround:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPI:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 914,
      GIR_Done,
    // Label 406: @7965
    GIM_Reject,
    // Label 397: @7966
    GIM_Reject,
    // Label 14: @7967
    GIM_Try, /*On fail goto*//*Label 407*/ 8080,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/1, 3, /*)*//*default:*//*Label 410*/ 8079,
      /*GILLT_s32*//*Label 408*/ 7981,
      /*GILLT_s64*//*Label 409*/ 8038,
      // Label 408: @7981
      GIM_Try, /*On fail goto*//*Label 411*/ 8037, // Rule ID 2012 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (lrint:{ *:[i64] } f32:{ *:[f32] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, F8RC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCTID,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2012,
        GIR_Done,
      // Label 411: @8037
      GIM_Reject,
      // Label 409: @8038
      GIM_Try, /*On fail goto*//*Label 412*/ 8078, // Rule ID 2011 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (lrint:{ *:[i64] } f64:{ *:[f64] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } ?:{ *:[f64] }:$S))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCTID,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2011,
        GIR_Done,
      // Label 412: @8078
      GIM_Reject,
      // Label 410: @8079
      GIM_Reject,
    // Label 407: @8080
    GIM_Reject,
    // Label 15: @8081
    GIM_Try, /*On fail goto*//*Label 413*/ 8098, // Rule ID 632 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (MFTB8:{ *:[i64] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MFTB8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 632,
      GIR_Done,
    // Label 413: @8098
    GIM_Reject,
    // Label 16: @8099
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 416*/ 8161,
    /*GILLT_s32*//*Label 414*/ 8107,
    /*GILLT_s64*//*Label 415*/ 8134,
    // Label 414: @8107
    GIM_Try, /*On fail goto*//*Label 417*/ 8133, // Rule ID 1250 //
      GIM_CheckFeatures, GIFBS_HasSYNC,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1250,
      GIR_Done,
    // Label 417: @8133
    GIM_Reject,
    // Label 415: @8134
    GIM_Try, /*On fail goto*//*Label 418*/ 8160, // Rule ID 1249 //
      GIM_CheckFeatures, GIFBS_HasSYNC,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1249,
      GIR_Done,
    // Label 418: @8160
    GIM_Reject,
    // Label 416: @8161
    GIM_Try, /*On fail goto*//*Label 419*/ 8205,
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      GIM_Try, /*On fail goto*//*Label 420*/ 8188, // Rule ID 1251 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1251,
        GIR_Done,
      // Label 420: @8188
      GIM_Try, /*On fail goto*//*Label 421*/ 8204, // Rule ID 1252 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1252,
        GIR_Done,
      // Label 421: @8204
      GIM_Reject,
    // Label 419: @8205
    GIM_Reject,
    // Label 17: @8206
    GIM_Try, /*On fail goto*//*Label 422*/ 8323,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 423*/ 8239, // Rule ID 1154 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxsetaccz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8020:{ *:[iPTR] })  =>  (XXSETACCZ:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSETACCZ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 423: @8239
      GIM_Try, /*On fail goto*//*Label 424*/ 8267, // Rule ID 1155 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxsetaccz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8020:{ *:[iPTR] })  =>  (XXSETACCZW:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSETACCZW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 424: @8267
      GIM_Try, /*On fail goto*//*Label 425*/ 8293, // Rule ID 4841 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mfmsr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7952:{ *:[iPTR] })  =>  (MFMSR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFMSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4841,
        GIR_Done,
      // Label 425: @8293
      GIM_Try, /*On fail goto*//*Label 426*/ 8322, // Rule ID 4842 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mftbu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7954:{ *:[iPTR] })  =>  (MFTB:{ *:[i32] } 269:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_AddImm, /*InsnID*/0, /*Imm*/269,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4842,
        GIR_Done,
      // Label 426: @8322
      GIM_Reject,
    // Label 422: @8323
    GIM_Try, /*On fail goto*//*Label 427*/ 12207,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 428*/ 8368, // Rule ID 1733 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_frsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7928:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XB)  =>  (XSRSQRTEDP:{ *:[f64] } ?:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSRSQRTEDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1733,
        GIR_Done,
      // Label 428: @8368
      GIM_Try, /*On fail goto*//*Label 429*/ 8408, // Rule ID 1924 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_frsqrtes,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7929:{ *:[iPTR] }, vssrc:{ *:[f32] }:$XB)  =>  (XSRSQRTESP:{ *:[f32] } ?:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSRSQRTESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1924,
        GIR_Done,
      // Label 429: @8408
      GIM_Try, /*On fail goto*//*Label 430*/ 8444, // Rule ID 865 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8110:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSP:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 865,
        GIR_Done,
      // Label 430: @8444
      GIM_Try, /*On fail goto*//*Label 431*/ 8480, // Rule ID 868 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpsxws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8111:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPSXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 868,
        GIR_Done,
      // Label 431: @8480
      GIM_Try, /*On fail goto*//*Label 432*/ 8516, // Rule ID 871 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpuxws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8112:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPUXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPUXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 871,
        GIR_Done,
      // Label 432: @8516
      GIM_Try, /*On fail goto*//*Label 433*/ 8552, // Rule ID 872 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8115:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPDP:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 872,
        GIR_Done,
      // Label 433: @8552
      GIM_Try, /*On fail goto*//*Label 434*/ 8588, // Rule ID 873 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspsxds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8117:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPSXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPSXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 873,
        GIR_Done,
      // Label 434: @8588
      GIM_Try, /*On fail goto*//*Label 435*/ 8624, // Rule ID 876 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspuxds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8118:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPUXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPUXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 876,
        GIR_Done,
      // Label 435: @8624
      GIM_Try, /*On fail goto*//*Label 436*/ 8660, // Rule ID 881 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsxdsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8119:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVSXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSXDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 881,
        GIR_Done,
      // Label 436: @8660
      GIM_Try, /*On fail goto*//*Label 437*/ 8696, // Rule ID 886 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvuxdsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8121:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVUXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVUXDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 886,
        GIR_Done,
      // Label 437: @8696
      GIM_Try, /*On fail goto*//*Label 438*/ 8732, // Rule ID 889 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsxwdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8120:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVSXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSXWDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 889,
        GIR_Done,
      // Label 438: @8732
      GIM_Try, /*On fail goto*//*Label 439*/ 8768, // Rule ID 890 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvuxwdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8122:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVUXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVUXWDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 890,
        GIR_Done,
      // Label 439: @8768
      GIM_Try, /*On fail goto*//*Label 440*/ 8804, // Rule ID 998 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_sqrtf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 8046:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSSQRTQPO:{ *:[f128] } f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSSQRTQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 440: @8804
      GIM_Try, /*On fail goto*//*Label 441*/ 8840, // Rule ID 1005 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_truncf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 8073:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSCVQPDPO:{ *:[f64] } f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVQPDPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 441: @8840
      GIM_Try, /*On fail goto*//*Label 442*/ 8876, // Rule ID 1014 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsphp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8116:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPHP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPHP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1014,
        GIR_Done,
      // Label 442: @8876
      GIM_Try, /*On fail goto*//*Label 443*/ 8912, // Rule ID 1018 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxexpdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8144:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXEXPDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXEXPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1018,
        GIR_Done,
      // Label 443: @8912
      GIM_Try, /*On fail goto*//*Label 444*/ 8948, // Rule ID 1019 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxexpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8145:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXEXPSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXEXPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1019,
        GIR_Done,
      // Label 444: @8948
      GIM_Try, /*On fail goto*//*Label 445*/ 8984, // Rule ID 1020 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxsigdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8146:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXSIGDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXSIGDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1020,
        GIR_Done,
      // Label 445: @8984
      GIM_Try, /*On fail goto*//*Label 446*/ 9020, // Rule ID 1021 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxsigsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8147:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXSIGSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXSIGSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1021,
        GIR_Done,
      // Label 446: @9020
      GIM_Try, /*On fail goto*//*Label 447*/ 9074, // Rule ID 1641 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtsqrtdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8140:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTDP:{ *:[i32] } ?:{ *:[v2f64] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTSQRTDP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 447: @9074
      GIM_Try, /*On fail goto*//*Label 448*/ 9128, // Rule ID 1642 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtsqrtsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8141:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTSP:{ *:[i32] } ?:{ *:[v4f32] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTSQRTSP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        // GIR_Coverage, 1642,
        GIR_Done,
      // Label 448: @9128
      GIM_Try, /*On fail goto*//*Label 449*/ 9164, // Rule ID 1643 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvresp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8133:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVRESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 449: @9164
      GIM_Try, /*On fail goto*//*Label 450*/ 9200, // Rule ID 1644 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvredp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8132:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVREDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVREDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 450: @9200
      GIM_Try, /*On fail goto*//*Label 451*/ 9236, // Rule ID 1645 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvrsqrtesp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8136:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRSQRTESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVRSQRTESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 451: @9236
      GIM_Try, /*On fail goto*//*Label 452*/ 9272, // Rule ID 1646 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvrsqrtedp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8135:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVRSQRTEDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVRSQRTEDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 452: @9272
      GIM_Try, /*On fail goto*//*Label 453*/ 9308, // Rule ID 1732 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fre,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7926:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSREDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSREDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1732,
        GIR_Done,
      // Label 453: @9308
      GIM_Try, /*On fail goto*//*Label 454*/ 9344, // Rule ID 1734 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7921:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSNABSDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNABSDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1734,
        GIR_Done,
      // Label 454: @9344
      GIM_Try, /*On fail goto*//*Label 455*/ 9380, // Rule ID 1735 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnabss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7922:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSNABSDPs:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNABSDPs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1735,
        GIR_Done,
      // Label 455: @9380
      GIM_Try, /*On fail goto*//*Label 456*/ 9416, // Rule ID 1919 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fres,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7927:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSRESP:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSRESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1919,
        GIR_Done,
      // Label 456: @9416
      GIM_Try, /*On fail goto*//*Label 457*/ 9491, // Rule ID 1920 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_extract_exp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7908:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (EXTRACT_SUBREG:{ *:[i32] } (XSXEXPDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] })), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSXEXPDP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::G8RCRegClassID,
        // GIR_Coverage, 1920,
        GIR_Done,
      // Label 457: @9491
      GIM_Try, /*On fail goto*//*Label 458*/ 9543, // Rule ID 1921 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_extract_sig,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7909:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSXSIGDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSXSIGDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1921,
        GIR_Done,
      // Label 458: @9543
      GIM_Try, /*On fail goto*//*Label 459*/ 9595, // Rule ID 2134 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvhpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8113:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A)  =>  (XVCVHPSP:{ *:[v4f32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVHPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2134,
        GIR_Done,
      // Label 459: @9595
      GIM_Try, /*On fail goto*//*Label 460*/ 9670, // Rule ID 2148 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_scalar_extract_expq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8037:{ *:[iPTR] }, f128:{ *:[f128] }:$vA)  =>  (MFVSRD:{ *:[i64] } (EXTRACT_SUBREG:{ *:[f64] } (XSXEXPQP:{ *:[v2i64] } ?:{ *:[f128] }:$vA), sub_64:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSXEXPQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_64,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VFRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::VRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2148,
        GIR_Done,
      // Label 460: @9670
      GIM_Try, /*On fail goto*//*Label 461*/ 9714, // Rule ID 1084 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7577:{ *:[iPTR] }, (imm:{ *:[i64] }):$D)  =>  (MTVSRBMI:{ *:[v16i8] } (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRBMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1084,
        GIR_Done,
      // Label 461: @9714
      GIM_Try, /*On fail goto*//*Label 462*/ 9752, // Rule ID 4799 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_frsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7928:{ *:[iPTR] }, f8rc:{ *:[f64] }:$frB)  =>  (FRSQRTE:{ *:[f64] } ?:{ *:[f64] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FRSQRTE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4799,
        GIR_Done,
      // Label 462: @9752
      GIM_Try, /*On fail goto*//*Label 463*/ 9790, // Rule ID 4800 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_frsqrtes,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::F4RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7929:{ *:[iPTR] }, f4rc:{ *:[f32] }:$frB)  =>  (FRSQRTES:{ *:[f32] } ?:{ *:[f32] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FRSQRTES,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4800,
        GIR_Done,
      // Label 463: @9790
      GIM_Try, /*On fail goto*//*Label 464*/ 9824, // Rule ID 73 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_popcntb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8035:{ *:[iPTR] }, i32:{ *:[i32] }:$RST)  =>  (POPCNTB:{ *:[i32] } i32:{ *:[i32] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::POPCNTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 464: @9824
      GIM_Try, /*On fail goto*//*Label 465*/ 9860, // Rule ID 318 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexptefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7684:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VEXPTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPTEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 318,
        GIR_Done,
      // Label 465: @9860
      GIM_Try, /*On fail goto*//*Label 466*/ 9896, // Rule ID 319 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vlogefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7722:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VLOGEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VLOGEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 319,
        GIR_Done,
      // Label 466: @9896
      GIM_Try, /*On fail goto*//*Label 467*/ 9932, // Rule ID 360 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7790:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VREFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VREFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 467: @9932
      GIM_Try, /*On fail goto*//*Label 468*/ 9968, // Rule ID 361 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfim,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7791:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIM:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 468: @9968
      GIM_Try, /*On fail goto*//*Label 469*/ 10004, // Rule ID 362 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfin,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7792:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIN:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 469: @10004
      GIM_Try, /*On fail goto*//*Label 470*/ 10040, // Rule ID 363 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfip,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7793:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 470: @10040
      GIM_Try, /*On fail goto*//*Label 471*/ 10076, // Rule ID 364 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfiz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7794:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIZ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 471: @10076
      GIM_Try, /*On fail goto*//*Label 472*/ 10112, // Rule ID 365 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrsqrtefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7805:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRSQRTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRSQRTEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 472: @10112
      GIM_Try, /*On fail goto*//*Label 473*/ 10148, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7847:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 473: @10148
      GIM_Try, /*On fail goto*//*Label 474*/ 10184, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7848:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKHSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 474: @10184
      GIM_Try, /*On fail goto*//*Label 475*/ 10220, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7849:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 475: @10220
      GIM_Try, /*On fail goto*//*Label 476*/ 10256, // Rule ID 419 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7851:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 476: @10256
      GIM_Try, /*On fail goto*//*Label 477*/ 10292, // Rule ID 420 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7852:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKLSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 477: @10292
      GIM_Try, /*On fail goto*//*Label 478*/ 10328, // Rule ID 421 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7853:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 478: @10328
      GIM_Try, /*On fail goto*//*Label 479*/ 10364, // Rule ID 501 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7850:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKHSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 479: @10364
      GIM_Try, /*On fail goto*//*Label 480*/ 10400, // Rule ID 502 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7854:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKLSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 480: @10400
      GIM_Try, /*On fail goto*//*Label 481*/ 10436, // Rule ID 503 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vgbbd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7704:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VGBBD:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VGBBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 481: @10436
      GIM_Try, /*On fail goto*//*Label 482*/ 10472, // Rule ID 511 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vsbox,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7559:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA)  =>  (VSBOX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSBOX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 482: @10472
      GIM_Try, /*On fail goto*//*Label 483*/ 10508, // Rule ID 527 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclzlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7614:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCLZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLZLSBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 527,
        GIR_Done,
      // Label 483: @10508
      GIM_Try, /*On fail goto*//*Label 484*/ 10544, // Rule ID 528 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctzlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7672:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCTZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTZLSBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 484: @10544
      GIM_Try, /*On fail goto*//*Label 485*/ 10580, // Rule ID 533 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsb2w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7699:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2W:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSB2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 533,
        GIR_Done,
      // Label 485: @10580
      GIM_Try, /*On fail goto*//*Label 486*/ 10616, // Rule ID 534 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsh2w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7702:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2W:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSH2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 534,
        GIR_Done,
      // Label 486: @10616
      GIM_Try, /*On fail goto*//*Label 487*/ 10652, // Rule ID 535 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsb2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7698:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2D:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSB2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 535,
        GIR_Done,
      // Label 487: @10652
      GIM_Try, /*On fail goto*//*Label 488*/ 10688, // Rule ID 536 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsh2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7701:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2D:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSH2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 488: @10688
      GIM_Try, /*On fail goto*//*Label 489*/ 10724, // Rule ID 537 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsw2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7703:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTSW2D:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSW2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 489: @10724
      GIM_Try, /*On fail goto*//*Label 490*/ 10760, // Rule ID 540 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7789:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VPRTYBW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 490: @10760
      GIM_Try, /*On fail goto*//*Label 491*/ 10796, // Rule ID 541 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7787:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VPRTYBD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 541,
        GIR_Done,
      // Label 491: @10796
      GIM_Try, /*On fail goto*//*Label 492*/ 10832, // Rule ID 542 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7788:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VPRTYBQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 542,
        GIR_Done,
      // Label 492: @10832
      GIM_Try, /*On fail goto*//*Label 493*/ 10866, // Rule ID 686 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_popcntb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8035:{ *:[iPTR] }, i64:{ *:[i64] }:$RST)  =>  (POPCNTB8:{ *:[i64] } i64:{ *:[i64] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::POPCNTB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 686,
        GIR_Done,
      // Label 493: @10866
      GIM_Try, /*On fail goto*//*Label 494*/ 10902, // Rule ID 1049 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstribr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7826:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBR:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1049,
        GIR_Done,
      // Label 494: @10902
      GIM_Try, /*On fail goto*//*Label 495*/ 10938, // Rule ID 1050 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstribl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7824:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBL:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1050,
        GIR_Done,
      // Label 495: @10938
      GIM_Try, /*On fail goto*//*Label 496*/ 10974, // Rule ID 1051 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstrihr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7830:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHR:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1051,
        GIR_Done,
      // Label 496: @10974
      GIM_Try, /*On fail goto*//*Label 497*/ 11010, // Rule ID 1052 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstrihl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7828:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHL:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1052,
        GIR_Done,
      // Label 497: @11010
      GIM_Try, /*On fail goto*//*Label 498*/ 11046, // Rule ID 1069 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7693:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTRACTBM:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1069,
        GIR_Done,
      // Label 498: @11046
      GIM_Try, /*On fail goto*//*Label 499*/ 11082, // Rule ID 1070 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextracthm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7695:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTRACTHM:{ *:[i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1070,
        GIR_Done,
      // Label 499: @11082
      GIM_Try, /*On fail goto*//*Label 500*/ 11118, // Rule ID 1071 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7697:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTRACTWM:{ *:[i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1071,
        GIR_Done,
      // Label 500: @11118
      GIM_Try, /*On fail goto*//*Label 501*/ 11154, // Rule ID 1072 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7694:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTRACTDM:{ *:[i32] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 501: @11154
      GIM_Try, /*On fail goto*//*Label 502*/ 11190, // Rule ID 1073 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7696:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXTRACTQM:{ *:[i32] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 502: @11190
      GIM_Try, /*On fail goto*//*Label 503*/ 11226, // Rule ID 1074 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7679:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXPANDBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 503: @11226
      GIM_Try, /*On fail goto*//*Label 504*/ 11262, // Rule ID 1075 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7681:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXPANDHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1075,
        GIR_Done,
      // Label 504: @11262
      GIM_Try, /*On fail goto*//*Label 505*/ 11298, // Rule ID 1076 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7683:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXPANDWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1076,
        GIR_Done,
      // Label 505: @11298
      GIM_Try, /*On fail goto*//*Label 506*/ 11334, // Rule ID 1077 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpanddm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7680:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXPANDDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 506: @11334
      GIM_Try, /*On fail goto*//*Label 507*/ 11370, // Rule ID 1078 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7682:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXPANDQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 507: @11370
      GIM_Try, /*On fail goto*//*Label 508*/ 11406, // Rule ID 1079 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7577:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRBM:{ *:[v16i8] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 508: @11406
      GIM_Try, /*On fail goto*//*Label 509*/ 11442, // Rule ID 1080 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7579:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRHM:{ *:[v8i16] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1080,
        GIR_Done,
      // Label 509: @11442
      GIM_Try, /*On fail goto*//*Label 510*/ 11478, // Rule ID 1081 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7581:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRWM:{ *:[v4i32] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1081,
        GIR_Done,
      // Label 510: @11478
      GIM_Try, /*On fail goto*//*Label 511*/ 11514, // Rule ID 1082 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7578:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRDM:{ *:[v2i64] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1082,
        GIR_Done,
      // Label 511: @11514
      GIM_Try, /*On fail goto*//*Label 512*/ 11550, // Rule ID 1083 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7580:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRQM:{ *:[v1i128] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1083,
        GIR_Done,
      // Label 512: @11550
      GIM_Try, /*On fail goto*//*Label 513*/ 11586, // Rule ID 1147 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsd2q,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7700:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTSD2Q:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSD2Q,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1147,
        GIR_Done,
      // Label 513: @11586
      GIM_Try, /*On fail goto*//*Label 514*/ 11622, // Rule ID 1152 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxmfacc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8018:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$AT)  =>  (XXMFACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$AT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXMFACC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // ATo
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // AT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 514: @11622
      GIM_Try, /*On fail goto*//*Label 515*/ 11658, // Rule ID 1153 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxmtacc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8019:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi)  =>  (XXMTACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$ATi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXMTACC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1153,
        GIR_Done,
      // Label 515: @11658
      GIM_Try, /*On fail goto*//*Label 516*/ 11692, // Rule ID 1265 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fre,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7926:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FRE:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FRE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 516: @11692
      GIM_Try, /*On fail goto*//*Label 517*/ 11726, // Rule ID 1266 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fres,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7927:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FRES:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FRES,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 517: @11726
      GIM_Try, /*On fail goto*//*Label 518*/ 11760, // Rule ID 1267 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7921:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FNABSD:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNABSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 518: @11760
      GIM_Try, /*On fail goto*//*Label 519*/ 11794, // Rule ID 1268 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnabss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7922:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FNABSS:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNABSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 519: @11794
      GIM_Try, /*On fail goto*//*Label 520*/ 11864, // Rule ID 3336 //
        GIM_CheckFeatures, GIFBS_HasVSX_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspbf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 8114:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVSPBF16:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVCVSPBF16,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3336,
        GIR_Done,
      // Label 520: @11864
      GIM_Try, /*On fail goto*//*Label 521*/ 11934, // Rule ID 3337 //
        GIM_CheckFeatures, GIFBS_HasVSX_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvbf16spn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 8109:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVBF16SPN:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVCVBF16SPN,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3337,
        GIR_Done,
      // Label 521: @11934
      GIM_Try, /*On fail goto*//*Label 522*/ 11968, // Rule ID 4833 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fcfid,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7910:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVSXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVSXDDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4833,
        GIR_Done,
      // Label 522: @11968
      GIM_Try, /*On fail goto*//*Label 523*/ 12002, // Rule ID 4834 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fcfud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7911:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVUXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVUXDDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4834,
        GIR_Done,
      // Label 523: @12002
      GIM_Try, /*On fail goto*//*Label 524*/ 12036, // Rule ID 4835 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctid,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7912:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTID:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FCTID,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4835,
        GIR_Done,
      // Label 524: @12036
      GIM_Try, /*On fail goto*//*Label 525*/ 12070, // Rule ID 4836 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctidz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7913:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVDPSXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4836,
        GIR_Done,
      // Label 525: @12070
      GIM_Try, /*On fail goto*//*Label 526*/ 12104, // Rule ID 4837 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctiw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7914:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTIW:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FCTIW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4837,
        GIR_Done,
      // Label 526: @12104
      GIM_Try, /*On fail goto*//*Label 527*/ 12138, // Rule ID 4838 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctiwz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7915:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVDPSXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4838,
        GIR_Done,
      // Label 527: @12138
      GIM_Try, /*On fail goto*//*Label 528*/ 12172, // Rule ID 4839 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctudz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7916:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVDPUXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4839,
        GIR_Done,
      // Label 528: @12172
      GIM_Try, /*On fail goto*//*Label 529*/ 12206, // Rule ID 4840 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fctuwz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7917:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVDPUXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4840,
        GIR_Done,
      // Label 529: @12206
      GIM_Reject,
    // Label 427: @12207
    GIM_Try, /*On fail goto*//*Label 530*/ 21496,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 531*/ 12282, // Rule ID 2150 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxextractuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8153:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXEXTRACTUW:{ *:[f64] } ?:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXEXTRACTUW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
        // GIR_Coverage, 2150,
        GIR_Done,
      // Label 531: @12282
      GIM_Try, /*On fail goto*//*Label 532*/ 12325, // Rule ID 1022 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtstdcsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8143:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCSP:{ *:[v4i32] } (timm:{ *:[i32] }):$DCMX, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVTSTDCSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1022,
        GIR_Done,
      // Label 532: @12325
      GIM_Try, /*On fail goto*//*Label 533*/ 12368, // Rule ID 1023 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtstdcdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8142:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCDP:{ *:[v2i64] } (timm:{ *:[i32] }):$DCMX, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVTSTDCDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1023,
        GIR_Done,
      // Label 533: @12368
      GIM_Try, /*On fail goto*//*Label 534*/ 12420, // Rule ID 891 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xsmaxdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 8095:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMAXDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMAXDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 891,
        GIR_Done,
      // Label 534: @12420
      GIM_Try, /*On fail goto*//*Label 535*/ 12472, // Rule ID 892 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xsmindp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 8096:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMINDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMINDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 535: @12472
      GIM_Try, /*On fail goto*//*Label 536*/ 12524, // Rule ID 893 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmaxdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8127:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMAXDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMAXDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 536: @12524
      GIM_Try, /*On fail goto*//*Label 537*/ 12576, // Rule ID 894 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmindp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8129:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMINDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMINDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 537: @12576
      GIM_Try, /*On fail goto*//*Label 538*/ 12628, // Rule ID 895 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmaxsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8128:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMAXSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMAXSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 538: @12628
      GIM_Try, /*On fail goto*//*Label 539*/ 12680, // Rule ID 896 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvminsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8130:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMINSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMINSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 896,
        GIR_Done,
      // Label 539: @12680
      GIM_Try, /*On fail goto*//*Label 540*/ 12724, // Rule ID 820 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpeqdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8097:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPEQDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPEQDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 820,
        GIR_Done,
      // Label 540: @12724
      GIM_Try, /*On fail goto*//*Label 541*/ 12768, // Rule ID 822 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpeqsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8099:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPEQSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPEQSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 822,
        GIR_Done,
      // Label 541: @12768
      GIM_Try, /*On fail goto*//*Label 542*/ 12812, // Rule ID 824 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgedp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8101:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGEDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGEDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 824,
        GIR_Done,
      // Label 542: @12812
      GIM_Try, /*On fail goto*//*Label 543*/ 12856, // Rule ID 826 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgesp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8103:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGESP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 826,
        GIR_Done,
      // Label 543: @12856
      GIM_Try, /*On fail goto*//*Label 544*/ 12900, // Rule ID 828 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgtdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8105:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGTDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGTDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 828,
        GIR_Done,
      // Label 544: @12900
      GIM_Try, /*On fail goto*//*Label 545*/ 12944, // Rule ID 830 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgtsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8107:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGTSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGTSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 830,
        GIR_Done,
      // Label 545: @12944
      GIM_Try, /*On fail goto*//*Label 546*/ 12988, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_addf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7548:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSADDQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 546: @12988
      GIM_Try, /*On fail goto*//*Label 547*/ 13032, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 8027:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSMULQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMULQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 547: @13032
      GIM_Try, /*On fail goto*//*Label 548*/ 13076, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_subf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 8055:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSSUBQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 548: @13076
      GIM_Try, /*On fail goto*//*Label 549*/ 13120, // Rule ID 997 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7904:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSDIVQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSDIVQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 549: @13120
      GIM_Try, /*On fail goto*//*Label 550*/ 13164, // Rule ID 1016 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xviexpdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8125:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)  =>  (XVIEXPDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVIEXPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1016,
        GIR_Done,
      // Label 550: @13164
      GIM_Try, /*On fail goto*//*Label 551*/ 13208, // Rule ID 1017 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xviexpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8126:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XVIEXPSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVIEXPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1017,
        GIR_Done,
      // Label 551: @13208
      GIM_Try, /*On fail goto*//*Label 552*/ 13252, // Rule ID 1637 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvdivsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 8124:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (XVDIVSP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVDIVSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1637,
        GIR_Done,
      // Label 552: @13252
      GIM_Try, /*On fail goto*//*Label 553*/ 13296, // Rule ID 1638 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvdivdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 8123:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (XVDIVDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVDIVDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1638,
        GIR_Done,
      // Label 553: @13296
      GIM_Try, /*On fail goto*//*Label 554*/ 13358, // Rule ID 1639 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtdivdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8137:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVDP:{ *:[i32] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTDIVDP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 554: @13358
      GIM_Try, /*On fail goto*//*Label 555*/ 13420, // Rule ID 1640 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtdivsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8138:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVSP:{ *:[i32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTDIVSP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 555: @13420
      GIM_Try, /*On fail goto*//*Label 556*/ 13464, // Rule ID 1884 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxleqv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8159:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B)  =>  (XXLEQV:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1884,
        GIR_Done,
      // Label 556: @13464
      GIM_Try, /*On fail goto*//*Label 557*/ 13542, // Rule ID 1922 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_insert_exp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7937:{ *:[iPTR] }, f64:{ *:[f64] }:$A, i64:{ *:[i64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[f64] } (XSIEXPDP:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[i64] } ?:{ *:[f64] }:$A, G8RC:{ *:[i32] }), ?:{ *:[i64] }:$B), F8RC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSIEXPDP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::F8RCRegClassID,
        // GIR_Coverage, 1922,
        GIR_Done,
      // Label 557: @13542
      GIM_Try, /*On fail goto*//*Label 558*/ 13602, // Rule ID 2147 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_scalar_insert_exp_qp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 8038:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, i64:{ *:[i64] }:$vB)  =>  (XSIEXPQP:{ *:[f128] } ?:{ *:[f128] }:$vA, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$vB))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::MTVSRD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSIEXPQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2147,
        GIR_Done,
      // Label 558: @13602
      GIM_Try, /*On fail goto*//*Label 559*/ 13685, // Rule ID 3326 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 1,
        // (intrinsic_wo_chain:{ *:[i32] } 8139:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 1:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTLSBB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 3326,
        GIR_Done,
      // Label 559: @13685
      GIM_Try, /*On fail goto*//*Label 560*/ 13768, // Rule ID 3327 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[i32] } 8139:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 0:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XVTLSBB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 3327,
        GIR_Done,
      // Label 560: @13768
      GIM_Try, /*On fail goto*//*Label 561*/ 13808, // Rule ID 314 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfsx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7608:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFSX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFSX_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 314,
        GIR_Done,
      // Label 561: @13808
      GIM_Try, /*On fail goto*//*Label 562*/ 13848, // Rule ID 315 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctuxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7670:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTUXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTUXS_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 315,
        GIR_Done,
      // Label 562: @13848
      GIM_Try, /*On fail goto*//*Label 563*/ 13888, // Rule ID 316 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfux,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7610:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFUX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUX_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 316,
        GIR_Done,
      // Label 563: @13888
      GIM_Try, /*On fail goto*//*Label 564*/ 13928, // Rule ID 317 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctsxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7669:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTSXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTSXS_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 317,
        GIR_Done,
      // Label 564: @13928
      GIM_Try, /*On fail goto*//*Label 565*/ 13998, // Rule ID 3322 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxgenpcvbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 8154:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXGENPCVBM:{ *:[v4i32] } ?:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXGENPCVBM,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3322,
        GIR_Done,
      // Label 565: @13998
      GIM_Try, /*On fail goto*//*Label 566*/ 14068, // Rule ID 3323 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxgenpcvhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 8156:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXGENPCVHM:{ *:[v4i32] } ?:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXGENPCVHM,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3323,
        GIR_Done,
      // Label 566: @14068
      GIM_Try, /*On fail goto*//*Label 567*/ 14138, // Rule ID 3324 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxgenpcvwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8157:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (XXGENPCVWM:{ *:[v4i32] } ?:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXGENPCVWM,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3324,
        GIR_Done,
      // Label 567: @14138
      GIM_Try, /*On fail goto*//*Label 568*/ 14208, // Rule ID 3325 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxgenpcvdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8155:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXGENPCVDM:{ *:[v4i32] } ?:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXGENPCVDM,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
        // GIR_Coverage, 3325,
        GIR_Done,
      // Label 568: @14208
      GIM_Try, /*On fail goto*//*Label 569*/ 14251, // Rule ID 310 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfsx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7608:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFSX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFSX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 310,
        GIR_Done,
      // Label 569: @14251
      GIM_Try, /*On fail goto*//*Label 570*/ 14294, // Rule ID 311 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfux,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7610:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFUX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 570: @14294
      GIM_Try, /*On fail goto*//*Label 571*/ 14337, // Rule ID 312 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctsxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7669:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTSXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTSXS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 312,
        GIR_Done,
      // Label 571: @14337
      GIM_Try, /*On fail goto*//*Label 572*/ 14380, // Rule ID 313 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctuxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7670:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTUXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTUXS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 313,
        GIR_Done,
      // Label 572: @14380
      GIM_Try, /*On fail goto*//*Label 573*/ 14423, // Rule ID 1085 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7665:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBB:{ *:[i64] } v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1085,
        GIR_Done,
      // Label 573: @14423
      GIM_Try, /*On fail goto*//*Label 574*/ 14466, // Rule ID 1086 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7667:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBH:{ *:[i64] } v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1086,
        GIR_Done,
      // Label 574: @14466
      GIM_Try, /*On fail goto*//*Label 575*/ 14509, // Rule ID 1087 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7668:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBW:{ *:[i64] } v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1087,
        GIR_Done,
      // Label 575: @14509
      GIM_Try, /*On fail goto*//*Label 576*/ 14552, // Rule ID 1088 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7666:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBD:{ *:[i64] } v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 576: @14552
      GIM_Try, /*On fail goto*//*Label 577*/ 14595, // Rule ID 1102 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vgnb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] N
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7705:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)  =>  (VGNB:{ *:[i64] } v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VGNB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // N
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1102,
        GIR_Done,
      // Label 577: @14595
      GIM_Try, /*On fail goto*//*Label 578*/ 14647, // Rule ID 201 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divwe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7905:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWE:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVWE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 201,
        GIR_Done,
      // Label 578: @14647
      GIM_Try, /*On fail goto*//*Label 579*/ 14699, // Rule ID 202 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divweu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7906:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWEU:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVWEU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 579: @14699
      GIM_Try, /*On fail goto*//*Label 580*/ 14751, // Rule ID 683 //
        GIM_CheckFeatures, GIFBS_HasBPERMD,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_bpermd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7868:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)  =>  (BPERMD:{ *:[i64] } g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::BPERMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 683,
        GIR_Done,
      // Label 580: @14751
      GIM_Try, /*On fail goto*//*Label 581*/ 14803, // Rule ID 689 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divde,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7902:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDE:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVDE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 689,
        GIR_Done,
      // Label 581: @14803
      GIM_Try, /*On fail goto*//*Label 582*/ 14855, // Rule ID 694 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divdeu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7903:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDEU:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVDEU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 582: @14855
      GIM_Try, /*On fail goto*//*Label 583*/ 14923, // Rule ID 1543 //
        GIM_CheckFeatures, GIFBS_In64BitMode_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cmpeqb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7872:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPEQB:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::CMPEQB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1543,
        GIR_Done,
      // Label 583: @14923
      GIM_Try, /*On fail goto*//*Label 584*/ 14991, // Rule ID 1544 //
        GIM_CheckFeatures, GIFBS_In64BitMode_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8043:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPD:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::CMPD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1544,
        GIR_Done,
      // Label 584: @14991
      GIM_Try, /*On fail goto*//*Label 585*/ 15043, // Rule ID 1548 //
        GIM_CheckFeatures, GIFBS_In64BitMode,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulhd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8028:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULHD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1548,
        GIR_Done,
      // Label 585: @15043
      GIM_Try, /*On fail goto*//*Label 586*/ 15095, // Rule ID 1549 //
        GIM_CheckFeatures, GIFBS_In64BitMode,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulhdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8029:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULHDU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1549,
        GIR_Done,
      // Label 586: @15095
      GIM_Try, /*On fail goto*//*Label 587*/ 15145, // Rule ID 1552 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cmpb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7871:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (CMPB8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CMPB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1552,
        GIR_Done,
      // Label 587: @15145
      GIM_Try, /*On fail goto*//*Label 588*/ 15195, // Rule ID 4819 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulhw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8030:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHW:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULHW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4819,
        GIR_Done,
      // Label 588: @15195
      GIM_Try, /*On fail goto*//*Label 589*/ 15245, // Rule ID 4820 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulhwu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 8031:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHWU:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULHWU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4820,
        GIR_Done,
      // Label 589: @15245
      GIM_Try, /*On fail goto*//*Label 590*/ 15295, // Rule ID 4821 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cmpb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7871:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (CMPB:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CMPB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4821,
        GIR_Done,
      // Label 590: @15295
      GIM_Try, /*On fail goto*//*Label 591*/ 15339, // Rule ID 301 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddcuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7591:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDCUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 301,
        GIR_Done,
      // Label 591: @15339
      GIM_Try, /*On fail goto*//*Label 592*/ 15383, // Rule ID 302 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddsbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7594:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 302,
        GIR_Done,
      // Label 592: @15383
      GIM_Try, /*On fail goto*//*Label 593*/ 15427, // Rule ID 303 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7595:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 303,
        GIR_Done,
      // Label 593: @15427
      GIM_Try, /*On fail goto*//*Label 594*/ 15471, // Rule ID 304 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7596:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 304,
        GIR_Done,
      // Label 594: @15471
      GIM_Try, /*On fail goto*//*Label 595*/ 15515, // Rule ID 305 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7597:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 305,
        GIR_Done,
      // Label 595: @15515
      GIM_Try, /*On fail goto*//*Label 596*/ 15559, // Rule ID 306 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vadduhs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7598:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 306,
        GIR_Done,
      // Label 596: @15559
      GIM_Try, /*On fail goto*//*Label 597*/ 15603, // Rule ID 307 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vadduws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7599:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 307,
        GIR_Done,
      // Label 597: @15603
      GIM_Try, /*On fail goto*//*Label 598*/ 15647, // Rule ID 320 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7600:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 320,
        GIR_Done,
      // Label 598: @15647
      GIM_Try, /*On fail goto*//*Label 599*/ 15691, // Rule ID 321 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7601:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 321,
        GIR_Done,
      // Label 599: @15691
      GIM_Try, /*On fail goto*//*Label 600*/ 15735, // Rule ID 322 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7602:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 322,
        GIR_Done,
      // Label 600: @15735
      GIM_Try, /*On fail goto*//*Label 601*/ 15779, // Rule ID 323 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7603:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 323,
        GIR_Done,
      // Label 601: @15779
      GIM_Try, /*On fail goto*//*Label 602*/ 15823, // Rule ID 324 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavguh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7604:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 324,
        GIR_Done,
      // Label 602: @15823
      GIM_Try, /*On fail goto*//*Label 603*/ 15867, // Rule ID 325 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavguw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7605:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 325,
        GIR_Done,
      // Label 603: @15867
      GIM_Try, /*On fail goto*//*Label 604*/ 15911, // Rule ID 326 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7724:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMAXFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 604: @15911
      GIM_Try, /*On fail goto*//*Label 605*/ 15955, // Rule ID 327 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7725:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 605: @15955
      GIM_Try, /*On fail goto*//*Label 606*/ 15999, // Rule ID 328 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7727:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 606: @15999
      GIM_Try, /*On fail goto*//*Label 607*/ 16043, // Rule ID 329 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7728:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 607: @16043
      GIM_Try, /*On fail goto*//*Label 608*/ 16087, // Rule ID 330 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7729:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 330,
        GIR_Done,
      // Label 608: @16087
      GIM_Try, /*On fail goto*//*Label 609*/ 16131, // Rule ID 331 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7731:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 331,
        GIR_Done,
      // Label 609: @16131
      GIM_Try, /*On fail goto*//*Label 610*/ 16175, // Rule ID 332 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7732:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 610: @16175
      GIM_Try, /*On fail goto*//*Label 611*/ 16219, // Rule ID 333 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7735:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMINFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 611: @16219
      GIM_Try, /*On fail goto*//*Label 612*/ 16263, // Rule ID 334 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7736:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 334,
        GIR_Done,
      // Label 612: @16263
      GIM_Try, /*On fail goto*//*Label 613*/ 16307, // Rule ID 335 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7738:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 613: @16307
      GIM_Try, /*On fail goto*//*Label 614*/ 16351, // Rule ID 336 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7739:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 336,
        GIR_Done,
      // Label 614: @16351
      GIM_Try, /*On fail goto*//*Label 615*/ 16395, // Rule ID 337 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7740:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 615: @16395
      GIM_Try, /*On fail goto*//*Label 616*/ 16439, // Rule ID 338 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7742:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 338,
        GIR_Done,
      // Label 616: @16439
      GIM_Try, /*On fail goto*//*Label 617*/ 16483, // Rule ID 339 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7743:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 339,
        GIR_Done,
      // Label 617: @16483
      GIM_Try, /*On fail goto*//*Label 618*/ 16527, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7753:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULESB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 618: @16527
      GIM_Try, /*On fail goto*//*Label 619*/ 16571, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7755:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULESH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 619: @16571
      GIM_Try, /*On fail goto*//*Label 620*/ 16615, // Rule ID 354 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7757:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULEUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 620: @16615
      GIM_Try, /*On fail goto*//*Label 621*/ 16659, // Rule ID 355 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7759:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULEUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 621: @16659
      GIM_Try, /*On fail goto*//*Label 622*/ 16703, // Rule ID 356 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7765:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 622: @16703
      GIM_Try, /*On fail goto*//*Label 623*/ 16747, // Rule ID 357 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7767:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 623: @16747
      GIM_Try, /*On fail goto*//*Label 624*/ 16791, // Rule ID 358 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuloub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7769:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 624: @16791
      GIM_Try, /*On fail goto*//*Label 625*/ 16835, // Rule ID 359 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulouh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7771:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 625: @16835
      GIM_Try, /*On fail goto*//*Label 626*/ 16879, // Rule ID 366 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubcuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7833:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBCUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 626: @16879
      GIM_Try, /*On fail goto*//*Label 627*/ 16923, // Rule ID 371 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubsbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7836:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 371,
        GIR_Done,
      // Label 627: @16923
      GIM_Try, /*On fail goto*//*Label 628*/ 16967, // Rule ID 372 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7837:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 372,
        GIR_Done,
      // Label 628: @16967
      GIM_Try, /*On fail goto*//*Label 629*/ 17011, // Rule ID 373 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7838:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 629: @17011
      GIM_Try, /*On fail goto*//*Label 630*/ 17055, // Rule ID 374 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsububs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7839:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 374,
        GIR_Done,
      // Label 630: @17055
      GIM_Try, /*On fail goto*//*Label 631*/ 17099, // Rule ID 375 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubuhs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7840:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 375,
        GIR_Done,
      // Label 631: @17099
      GIM_Try, /*On fail goto*//*Label 632*/ 17143, // Rule ID 376 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubuws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7841:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 376,
        GIR_Done,
      // Label 632: @17143
      GIM_Try, /*On fail goto*//*Label 633*/ 17187, // Rule ID 385 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7795:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 385,
        GIR_Done,
      // Label 633: @17187
      GIM_Try, /*On fail goto*//*Label 634*/ 17231, // Rule ID 386 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7799:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VRLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 386,
        GIR_Done,
      // Label 634: @17231
      GIM_Try, /*On fail goto*//*Label 635*/ 17275, // Rule ID 387 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7802:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 387,
        GIR_Done,
      // Label 635: @17275
      GIM_Try, /*On fail goto*//*Label 636*/ 17319, // Rule ID 388 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7807:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 388,
        GIR_Done,
      // Label 636: @17319
      GIM_Try, /*On fail goto*//*Label 637*/ 17363, // Rule ID 389 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslo,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7811:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 389,
        GIR_Done,
      // Label 637: @17363
      GIM_Try, /*On fail goto*//*Label 638*/ 17407, // Rule ID 390 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7808:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 390,
        GIR_Done,
      // Label 638: @17407
      GIM_Try, /*On fail goto*//*Label 639*/ 17451, // Rule ID 391 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7810:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 391,
        GIR_Done,
      // Label 639: @17451
      GIM_Try, /*On fail goto*//*Label 640*/ 17495, // Rule ID 392 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7813:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 392,
        GIR_Done,
      // Label 640: @17495
      GIM_Try, /*On fail goto*//*Label 641*/ 17539, // Rule ID 396 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7814:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 396,
        GIR_Done,
      // Label 641: @17539
      GIM_Try, /*On fail goto*//*Label 642*/ 17583, // Rule ID 397 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsro,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7821:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 397,
        GIR_Done,
      // Label 642: @17583
      GIM_Try, /*On fail goto*//*Label 643*/ 17627, // Rule ID 398 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrab,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7815:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRAB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 398,
        GIR_Done,
      // Label 643: @17627
      GIM_Try, /*On fail goto*//*Label 644*/ 17671, // Rule ID 399 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrah,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7816:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRAH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 399,
        GIR_Done,
      // Label 644: @17671
      GIM_Try, /*On fail goto*//*Label 645*/ 17715, // Rule ID 400 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsraw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7817:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 400,
        GIR_Done,
      // Label 645: @17715
      GIM_Try, /*On fail goto*//*Label 646*/ 17759, // Rule ID 401 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7818:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 401,
        GIR_Done,
      // Label 646: @17759
      GIM_Try, /*On fail goto*//*Label 647*/ 17803, // Rule ID 402 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7820:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 402,
        GIR_Done,
      // Label 647: @17803
      GIM_Try, /*On fail goto*//*Label 648*/ 17847, // Rule ID 403 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7823:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 403,
        GIR_Done,
      // Label 648: @17847
      GIM_Try, /*On fail goto*//*Label 649*/ 17891, // Rule ID 407 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7777:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKPX:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 407,
        GIR_Done,
      // Label 649: @17891
      GIM_Try, /*On fail goto*//*Label 650*/ 17935, // Rule ID 454 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7756:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULESW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 650: @17935
      GIM_Try, /*On fail goto*//*Label 651*/ 17979, // Rule ID 455 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7760:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULEUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 455,
        GIR_Done,
      // Label 651: @17979
      GIM_Try, /*On fail goto*//*Label 652*/ 18023, // Rule ID 456 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7768:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 652: @18023
      GIM_Try, /*On fail goto*//*Label 653*/ 18067, // Rule ID 457 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulouw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7772:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 457,
        GIR_Done,
      // Label 653: @18067
      GIM_Try, /*On fail goto*//*Label 654*/ 18111, // Rule ID 459 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7726:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 654: @18111
      GIM_Try, /*On fail goto*//*Label 655*/ 18155, // Rule ID 460 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7730:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 655: @18155
      GIM_Try, /*On fail goto*//*Label 656*/ 18199, // Rule ID 461 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7737:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 656: @18199
      GIM_Try, /*On fail goto*//*Label 657*/ 18243, // Rule ID 462 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7741:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 657: @18243
      GIM_Try, /*On fail goto*//*Label 658*/ 18287, // Rule ID 465 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrld,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7796:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 658: @18287
      GIM_Try, /*On fail goto*//*Label 659*/ 18331, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddcuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7590:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDCUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 659: @18331
      GIM_Try, /*On fail goto*//*Label 660*/ 18375, // Rule ID 474 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubcuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7832:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBCUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 474,
        GIR_Done,
      // Label 660: @18375
      GIM_Try, /*On fail goto*//*Label 661*/ 18419, // Rule ID 493 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7555:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VPMSUMB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 661: @18419
      GIM_Try, /*On fail goto*//*Label 662*/ 18463, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7557:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPMSUMH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 662: @18463
      GIM_Try, /*On fail goto*//*Label 663*/ 18507, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7558:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPMSUMW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 663: @18507
      GIM_Try, /*On fail goto*//*Label 664*/ 18551, // Rule ID 496 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7556:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPMSUMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 664: @18551
      GIM_Try, /*On fail goto*//*Label 665*/ 18595, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vbpermq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7607:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMQ:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VBPERMQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 665: @18595
      GIM_Try, /*On fail goto*//*Label 666*/ 18639, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vcipher,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7549:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCIPHER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 666: @18639
      GIM_Try, /*On fail goto*//*Label 667*/ 18683, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vcipherlast,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7550:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCIPHERLAST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 667: @18683
      GIM_Try, /*On fail goto*//*Label 668*/ 18727, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vncipher,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7551:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNCIPHER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 668: @18727
      GIM_Try, /*On fail goto*//*Label 669*/ 18771, // Rule ID 510 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vncipherlast,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7552:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNCIPHERLAST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 669: @18771
      GIM_Try, /*On fail goto*//*Label 670*/ 18815, // Rule ID 543 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vbpermd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7606:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VBPERMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 543,
        GIR_Done,
      // Label 670: @18815
      GIM_Try, /*On fail goto*//*Label 671*/ 18859, // Rule ID 544 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlwnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7804:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLWNM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLWNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 671: @18859
      GIM_Try, /*On fail goto*//*Label 672*/ 18903, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrldnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7798:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLDNM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLDNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 672: @18903
      GIM_Try, /*On fail goto*//*Label 673*/ 18947, // Rule ID 548 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7812:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 673: @18947
      GIM_Try, /*On fail goto*//*Label 674*/ 18991, // Rule ID 549 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7822:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 674: @18991
      GIM_Try, /*On fail goto*//*Label 675*/ 19035, // Rule ID 550 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsdub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7587:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VABSDUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 550,
        GIR_Done,
      // Label 675: @19035
      GIM_Try, /*On fail goto*//*Label 676*/ 19079, // Rule ID 551 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsduh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7588:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VABSDUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 551,
        GIR_Done,
      // Label 676: @19079
      GIM_Try, /*On fail goto*//*Label 677*/ 19123, // Rule ID 552 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsduw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7589:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VABSDUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 552,
        GIR_Done,
      // Label 677: @19123
      GIM_Try, /*On fail goto*//*Label 678*/ 19167, // Rule ID 1097 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpdepd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7774:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPDEPD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPDEPD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1097,
        GIR_Done,
      // Label 678: @19167
      GIM_Try, /*On fail goto*//*Label 679*/ 19211, // Rule ID 1098 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpextd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7776:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPEXTD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPEXTD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1098,
        GIR_Done,
      // Label 679: @19211
      GIM_Try, /*On fail goto*//*Label 680*/ 19255, // Rule ID 1099 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_pdepd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8033:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PDEPD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PDEPD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1099,
        GIR_Done,
      // Label 680: @19255
      GIM_Try, /*On fail goto*//*Label 681*/ 19299, // Rule ID 1100 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_pextd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 8034:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PEXTD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PEXTD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1100,
        GIR_Done,
      // Label 681: @19299
      GIM_Try, /*On fail goto*//*Label 682*/ 19343, // Rule ID 1101 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfuged,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7609:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCFUGED:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUGED,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1101,
        GIR_Done,
      // Label 682: @19343
      GIM_Try, /*On fail goto*//*Label 683*/ 19387, // Rule ID 1103 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cfuged,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7870:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CFUGED:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CFUGED,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1103,
        GIR_Done,
      // Label 683: @19387
      GIM_Try, /*On fail goto*//*Label 684*/ 19431, // Rule ID 1105 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7613:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCLZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1105,
        GIR_Done,
      // Label 684: @19431
      GIM_Try, /*On fail goto*//*Label 685*/ 19475, // Rule ID 1106 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7671:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCTZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1106,
        GIR_Done,
      // Label 685: @19475
      GIM_Try, /*On fail goto*//*Label 686*/ 19519, // Rule ID 1107 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cntlzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7875:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTLZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CNTLZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1107,
        GIR_Done,
      // Label 686: @19519
      GIM_Try, /*On fail goto*//*Label 687*/ 19563, // Rule ID 1108 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cnttzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7876:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTTZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CNTTZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1108,
        GIR_Done,
      // Label 687: @19563
      GIM_Try, /*On fail goto*//*Label 688*/ 19607, // Rule ID 1109 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclrlb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7611:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLRLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1109,
        GIR_Done,
      // Label 688: @19607
      GIM_Try, /*On fail goto*//*Label 689*/ 19651, // Rule ID 1110 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclrrb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7612:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLRRB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1110,
        GIR_Done,
      // Label 689: @19651
      GIM_Try, /*On fail goto*//*Label 690*/ 19695, // Rule ID 1124 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7675:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVESW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1124,
        GIR_Done,
      // Label 690: @19695
      GIM_Try, /*On fail goto*//*Label 691*/ 19739, // Rule ID 1125 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7678:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVEUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1125,
        GIR_Done,
      // Label 691: @19739
      GIM_Try, /*On fail goto*//*Label 692*/ 19783, // Rule ID 1126 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7673:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVESD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1126,
        GIR_Done,
      // Label 692: @19783
      GIM_Try, /*On fail goto*//*Label 693*/ 19827, // Rule ID 1127 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7676:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVEUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1127,
        GIR_Done,
      // Label 693: @19827
      GIM_Try, /*On fail goto*//*Label 694*/ 19871, // Rule ID 1130 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7754:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULESD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1130,
        GIR_Done,
      // Label 694: @19871
      GIM_Try, /*On fail goto*//*Label 695*/ 19915, // Rule ID 1131 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7758:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULEUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1131,
        GIR_Done,
      // Label 695: @19915
      GIM_Try, /*On fail goto*//*Label 696*/ 19959, // Rule ID 1132 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7766:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOSD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1132,
        GIR_Done,
      // Label 696: @19959
      GIM_Try, /*On fail goto*//*Label 697*/ 20003, // Rule ID 1133 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuloud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7770:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1133,
        GIR_Done,
      // Label 697: @20003
      GIM_Try, /*On fail goto*//*Label 698*/ 20047, // Rule ID 1137 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7674:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVESQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1137,
        GIR_Done,
      // Label 698: @20047
      GIM_Try, /*On fail goto*//*Label 699*/ 20091, // Rule ID 1138 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7677:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVEUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1138,
        GIR_Done,
      // Label 699: @20091
      GIM_Try, /*On fail goto*//*Label 700*/ 20135, // Rule ID 1148 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlqnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7801:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VRLQNM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLQNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1148,
        GIR_Done,
      // Label 700: @20135
      GIM_Try, /*On fail goto*//*Label 701*/ 20179, // Rule ID 3318 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulhsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7762:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHSW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULHSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3318,
        GIR_Done,
      // Label 701: @20179
      GIM_Try, /*On fail goto*//*Label 702*/ 20223, // Rule ID 3319 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulhuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7764:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHUW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULHUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3319,
        GIR_Done,
      // Label 702: @20223
      GIM_Try, /*On fail goto*//*Label 703*/ 20267, // Rule ID 3320 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulhsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7761:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHSD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULHSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3320,
        GIR_Done,
      // Label 703: @20267
      GIM_Try, /*On fail goto*//*Label 704*/ 20311, // Rule ID 3321 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulhud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7763:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHUD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULHUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3321,
        GIR_Done,
      // Label 704: @20311
      GIM_Try, /*On fail goto*//*Label 705*/ 20387, // Rule ID 3484 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi4ger8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8013:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI4GER8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3484,
        GIR_Done,
      // Label 705: @20387
      GIM_Try, /*On fail goto*//*Label 706*/ 20463, // Rule ID 3486 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8015:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3486,
        GIR_Done,
      // Label 706: @20463
      GIM_Try, /*On fail goto*//*Label 707*/ 20539, // Rule ID 3488 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2s,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8011:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3488,
        GIR_Done,
      // Label 707: @20539
      GIM_Try, /*On fail goto*//*Label 708*/ 20615, // Rule ID 3490 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi4ger8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8013:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI4GER8W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3490,
        GIR_Done,
      // Label 708: @20615
      GIM_Try, /*On fail goto*//*Label 709*/ 20691, // Rule ID 3492 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8015:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3492,
        GIR_Done,
      // Label 709: @20691
      GIM_Try, /*On fail goto*//*Label 710*/ 20767, // Rule ID 3494 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2s,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8011:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2SW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3494,
        GIR_Done,
      // Label 710: @20767
      GIM_Try, /*On fail goto*//*Label 711*/ 20843, // Rule ID 3496 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7994:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3496,
        GIR_Done,
      // Label 711: @20843
      GIM_Try, /*On fail goto*//*Label 712*/ 20919, // Rule ID 3501 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7994:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3501,
        GIR_Done,
      // Label 712: @20919
      GIM_Try, /*On fail goto*//*Label 713*/ 20995, // Rule ID 3506 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7999:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3506,
        GIR_Done,
      // Label 713: @20995
      GIM_Try, /*On fail goto*//*Label 714*/ 21055, // Rule ID 3511 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8004:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3511,
        GIR_Done,
      // Label 714: @21055
      GIM_Try, /*On fail goto*//*Label 715*/ 21131, // Rule ID 3516 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7989:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3516,
        GIR_Done,
      // Label 715: @21131
      GIM_Try, /*On fail goto*//*Label 716*/ 21207, // Rule ID 3521 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8009:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3521,
        GIR_Done,
      // Label 716: @21207
      GIM_Try, /*On fail goto*//*Label 717*/ 21283, // Rule ID 3524 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7999:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3524,
        GIR_Done,
      // Label 717: @21283
      GIM_Try, /*On fail goto*//*Label 718*/ 21343, // Rule ID 3529 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8004:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3529,
        GIR_Done,
      // Label 718: @21343
      GIM_Try, /*On fail goto*//*Label 719*/ 21419, // Rule ID 3534 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7989:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3534,
        GIR_Done,
      // Label 719: @21419
      GIM_Try, /*On fail goto*//*Label 720*/ 21495, // Rule ID 3539 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8009:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3539,
        GIR_Done,
      // Label 720: @21495
      GIM_Reject,
    // Label 530: @21496
    GIM_Try, /*On fail goto*//*Label 721*/ 28775,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 722*/ 21566, // Rule ID 1000 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[f128] } 7918:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$RSTi))  =>  (XSMSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RSTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 722: @21566
      GIM_Try, /*On fail goto*//*Label 723*/ 21626, // Rule ID 2149 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxinsertw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8158:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v2i64:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)  =>  (XXINSERTW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXINSERTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // IMM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2149,
        GIR_Done,
      // Label 723: @21626
      GIM_Try, /*On fail goto*//*Label 724*/ 21678, // Rule ID 999 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7918:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, f128:{ *:[f128] }:$RSTi)  =>  (XSMADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMADDQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RSTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 724: @21678
      GIM_Try, /*On fail goto*//*Label 725*/ 21730, // Rule ID 1730 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7919:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSMSUBMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBMDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1730,
        GIR_Done,
      // Label 725: @21730
      GIM_Try, /*On fail goto*//*Label 726*/ 21782, // Rule ID 1731 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnmadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7923:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSNMADDMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDMDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1731,
        GIR_Done,
      // Label 726: @21782
      GIM_Try, /*On fail goto*//*Label 727*/ 21834, // Rule ID 1917 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7920:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSMSUBMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBMSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1917,
        GIR_Done,
      // Label 727: @21834
      GIM_Try, /*On fail goto*//*Label 728*/ 21886, // Rule ID 1918 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnmadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7924:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSNMADDMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDMSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1918,
        GIR_Done,
      // Label 728: @21886
      GIM_Try, /*On fail goto*//*Label 729*/ 21936, // Rule ID 505 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vshasigmaw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7561:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSHASIGMAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 729: @21936
      GIM_Try, /*On fail goto*//*Label 730*/ 21986, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vshasigmad,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7560:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSHASIGMAD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 730: @21986
      GIM_Try, /*On fail goto*//*Label 731*/ 22037, // Rule ID 1047 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsldbi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7809:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSLDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLDBI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SD
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1047,
        GIR_Done,
      // Label 731: @22037
      GIM_Try, /*On fail goto*//*Label 732*/ 22088, // Rule ID 1048 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrdbi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7819:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSRDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRDBI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SD
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1048,
        GIR_Done,
      // Label 732: @22088
      GIM_Try, /*On fail goto*//*Label 733*/ 22139, // Rule ID 1053 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7717:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, (timm:{ *:[i32] }):$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1053,
        GIR_Done,
      // Label 733: @22139
      GIM_Try, /*On fail goto*//*Label 734*/ 22190, // Rule ID 1054 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7710:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, (timm:{ *:[i32] }):$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1054,
        GIR_Done,
      // Label 734: @22190
      GIM_Try, /*On fail goto*//*Label 735*/ 22241, // Rule ID 1429 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_bcdadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7864:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDADD_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::BCDADD_rec,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // PS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1429,
        GIR_Done,
      // Label 735: @22241
      GIM_Try, /*On fail goto*//*Label 736*/ 22292, // Rule ID 1430 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_bcdsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7866:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDSUB_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::BCDSUB_rec,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // PS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1430,
        GIR_Done,
      // Label 736: @22292
      GIM_Try, /*On fail goto*//*Label 737*/ 22356, // Rule ID 1545 //
        GIM_CheckFeatures, GIFBS_In64BitMode_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_maddhd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7946:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MADDHD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1545,
        GIR_Done,
      // Label 737: @22356
      GIM_Try, /*On fail goto*//*Label 738*/ 22420, // Rule ID 1546 //
        GIM_CheckFeatures, GIFBS_In64BitMode_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_maddhdu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7947:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MADDHDU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1546,
        GIR_Done,
      // Label 738: @22420
      GIM_Try, /*On fail goto*//*Label 739*/ 22484, // Rule ID 1547 //
        GIM_CheckFeatures, GIFBS_In64BitMode_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_maddld,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7948:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDLD8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MADDLD8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1547,
        GIR_Done,
      // Label 739: @22484
      GIM_Try, /*On fail goto*//*Label 740*/ 22546, // Rule ID 4798 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fsel,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7930:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FRA, f8rc:{ *:[f64] }:$FRC, f8rc:{ *:[f64] }:$FRB)  =>  (FSELD:{ *:[f64] } ?:{ *:[f64] }:$FRA, ?:{ *:[f64] }:$FRC, ?:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FSELD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4798,
        GIR_Done,
      // Label 740: @22546
      GIM_Try, /*On fail goto*//*Label 741*/ 22598, // Rule ID 293 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmladduhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7744:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)  =>  (VMLADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMLADDUHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 293,
        GIR_Done,
      // Label 741: @22598
      GIM_Try, /*On fail goto*//*Label 742*/ 22650, // Rule ID 294 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vperm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7775:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)  =>  (VPERM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPERM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 294,
        GIR_Done,
      // Label 742: @22650
      GIM_Try, /*On fail goto*//*Label 743*/ 22702, // Rule ID 295 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsel,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7806:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VSEL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSEL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 295,
        GIR_Done,
      // Label 743: @22702
      GIM_Try, /*On fail goto*//*Label 744*/ 22754, // Rule ID 346 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsummbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7746:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMMBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMMBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 346,
        GIR_Done,
      // Label 744: @22754
      GIM_Try, /*On fail goto*//*Label 745*/ 22806, // Rule ID 347 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumshm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7747:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMSHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMSHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 745: @22806
      GIM_Try, /*On fail goto*//*Label 746*/ 22858, // Rule ID 348 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumubm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7749:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 746: @22858
      GIM_Try, /*On fail goto*//*Label 747*/ 22910, // Rule ID 349 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumuhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7751:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 747: @22910
      GIM_Try, /*On fail goto*//*Label 748*/ 22962, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddeuqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7593:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDEUQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 748: @22962
      GIM_Try, /*On fail goto*//*Label 749*/ 23014, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddecuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7592:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDECUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 749: @23014
      GIM_Try, /*On fail goto*//*Label 750*/ 23066, // Rule ID 473 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubeuqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7835:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBEUQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 750: @23066
      GIM_Try, /*On fail goto*//*Label 751*/ 23118, // Rule ID 475 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubecuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7834:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBECUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 475,
        GIR_Done,
      // Label 751: @23118
      GIM_Try, /*On fail goto*//*Label 752*/ 23170, // Rule ID 512 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumudm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7750:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMUDM:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 512,
        GIR_Done,
      // Label 752: @23170
      GIM_Try, /*On fail goto*//*Label 753*/ 23222, // Rule ID 545 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlwmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7803:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)  =>  (VRLWMI:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLWMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 753: @23222
      GIM_Try, /*On fail goto*//*Label 754*/ 23274, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrldmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7797:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)  =>  (VRLDMI:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLDMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 754: @23274
      GIM_Try, /*On fail goto*//*Label 755*/ 23326, // Rule ID 1055 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7708:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1055,
        GIR_Done,
      // Label 755: @23326
      GIM_Try, /*On fail goto*//*Label 756*/ 23378, // Rule ID 1056 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7709:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1056,
        GIR_Done,
      // Label 756: @23378
      GIM_Try, /*On fail goto*//*Label 757*/ 23430, // Rule ID 1057 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7715:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1057,
        GIR_Done,
      // Label 757: @23430
      GIM_Try, /*On fail goto*//*Label 758*/ 23482, // Rule ID 1058 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7716:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1058,
        GIR_Done,
      // Label 758: @23482
      GIM_Try, /*On fail goto*//*Label 759*/ 23534, // Rule ID 1059 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7720:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1059,
        GIR_Done,
      // Label 759: @23534
      GIM_Try, /*On fail goto*//*Label 760*/ 23586, // Rule ID 1060 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7721:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 760: @23586
      GIM_Try, /*On fail goto*//*Label 761*/ 23638, // Rule ID 1061 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsblx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7706:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 761: @23638
      GIM_Try, /*On fail goto*//*Label 762*/ 23690, // Rule ID 1062 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7707:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1062,
        GIR_Done,
      // Label 762: @23690
      GIM_Try, /*On fail goto*//*Label 763*/ 23742, // Rule ID 1063 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7713:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 763: @23742
      GIM_Try, /*On fail goto*//*Label 764*/ 23794, // Rule ID 1064 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7714:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 764: @23794
      GIM_Try, /*On fail goto*//*Label 765*/ 23846, // Rule ID 1065 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7718:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 765: @23846
      GIM_Try, /*On fail goto*//*Label 766*/ 23898, // Rule ID 1066 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7719:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1066,
        GIR_Done,
      // Label 766: @23898
      GIM_Try, /*On fail goto*//*Label 767*/ 23950, // Rule ID 1067 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsdlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7711:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSDLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1067,
        GIR_Done,
      // Label 767: @23950
      GIM_Try, /*On fail goto*//*Label 768*/ 24002, // Rule ID 1068 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsdrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7712:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSDRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1068,
        GIR_Done,
      // Label 768: @24002
      GIM_Try, /*On fail goto*//*Label 769*/ 24054, // Rule ID 1089 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextdubvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7687:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVLX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUBVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 769: @24054
      GIM_Try, /*On fail goto*//*Label 770*/ 24106, // Rule ID 1090 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextdubvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7688:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVRX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUBVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 770: @24106
      GIM_Try, /*On fail goto*//*Label 771*/ 24158, // Rule ID 1091 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduhvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7689:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVLX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUHVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 771: @24158
      GIM_Try, /*On fail goto*//*Label 772*/ 24210, // Rule ID 1092 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduhvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7690:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVRX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUHVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 772: @24210
      GIM_Try, /*On fail goto*//*Label 773*/ 24262, // Rule ID 1093 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduwvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7691:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVLX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUWVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 773: @24262
      GIM_Try, /*On fail goto*//*Label 774*/ 24314, // Rule ID 1094 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduwvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7692:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVRX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUWVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1094,
        GIR_Done,
      // Label 774: @24314
      GIM_Try, /*On fail goto*//*Label 775*/ 24366, // Rule ID 1095 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextddvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7685:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDDVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1095,
        GIR_Done,
      // Label 775: @24366
      GIM_Try, /*On fail goto*//*Label 776*/ 24418, // Rule ID 1096 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextddvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7686:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDDVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1096,
        GIR_Done,
      // Label 776: @24418
      GIM_Try, /*On fail goto*//*Label 777*/ 24470, // Rule ID 1134 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumcud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7745:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMCUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMCUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1134,
        GIR_Done,
      // Label 777: @24470
      GIM_Try, /*On fail goto*//*Label 778*/ 24522, // Rule ID 1149 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlqmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7800:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)  =>  (VRLQMI:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLQMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1149,
        GIR_Done,
      // Label 778: @24522
      GIM_Try, /*On fail goto*//*Label 779*/ 24572, // Rule ID 1261 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7919:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FMSUB:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FMSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 779: @24572
      GIM_Try, /*On fail goto*//*Label 780*/ 24622, // Rule ID 1262 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmsubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7920:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FMSUBS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FMSUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1262,
        GIR_Done,
      // Label 780: @24622
      GIM_Try, /*On fail goto*//*Label 781*/ 24672, // Rule ID 1263 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnmadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7923:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FNMADD:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 781: @24672
      GIM_Try, /*On fail goto*//*Label 782*/ 24722, // Rule ID 1264 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fnmadds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 7924:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FNMADDS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 782: @24722
      GIM_Try, /*On fail goto*//*Label 783*/ 24774, // Rule ID 1366 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaddfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7723:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VMADDFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMADDFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1366,
        GIR_Done,
      // Label 783: @24774
      GIM_Try, /*On fail goto*//*Label 784*/ 24826, // Rule ID 1367 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vnmsubfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7773:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VNMSUBFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNMSUBFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1367,
        GIR_Done,
      // Label 784: @24826
      GIM_Try, /*On fail goto*//*Label 785*/ 24930, // Rule ID 1562 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpermxor,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7553:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, (XXLNOR:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLNOR,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPERMXOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 785: @24930
      GIM_Try, /*On fail goto*//*Label 786*/ 24982, // Rule ID 1563 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpermxor,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7553:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPERMXOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1563,
        GIR_Done,
      // Label 786: @24982
      GIM_Try, /*On fail goto*//*Label 787*/ 25034, // Rule ID 1564 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpermxor_be,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7554:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPERMXOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1564,
        GIR_Done,
      // Label 787: @25034
      GIM_Try, /*On fail goto*//*Label 788*/ 25152, // Rule ID 3402 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxblendvb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 8148:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXBLENDVB:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXBLENDVB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
        // GIR_Coverage, 3402,
        GIR_Done,
      // Label 788: @25152
      GIM_Try, /*On fail goto*//*Label 789*/ 25270, // Rule ID 3403 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxblendvh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 8150:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A, v8i16:{ *:[v8i16] }:$B, v8i16:{ *:[v8i16] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXBLENDVH:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXBLENDVH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
        // GIR_Coverage, 3403,
        GIR_Done,
      // Label 789: @25270
      GIM_Try, /*On fail goto*//*Label 790*/ 25322, // Rule ID 3404 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxblendvw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 8151:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C)  =>  (XXBLENDVW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXBLENDVW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3404,
        GIR_Done,
      // Label 790: @25322
      GIM_Try, /*On fail goto*//*Label 791*/ 25374, // Rule ID 3405 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxblendvd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8149:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, v2i64:{ *:[v2i64] }:$B, v2i64:{ *:[v2i64] }:$C)  =>  (XXBLENDVD:{ *:[v2i64] } ?:{ *:[v2i64] }:$A, ?:{ *:[v2i64] }:$B, ?:{ *:[v2i64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXBLENDVD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3405,
        GIR_Done,
      // Label 791: @25374
      GIM_Try, /*On fail goto*//*Label 792*/ 25458, // Rule ID 3485 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi4ger8pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8014:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI4GER8PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3485,
        GIR_Done,
      // Label 792: @25458
      GIM_Try, /*On fail goto*//*Label 793*/ 25542, // Rule ID 3487 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8016:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3487,
        GIR_Done,
      // Label 793: @25542
      GIM_Try, /*On fail goto*//*Label 794*/ 25626, // Rule ID 3489 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8012:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2SPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3489,
        GIR_Done,
      // Label 794: @25626
      GIM_Try, /*On fail goto*//*Label 795*/ 25710, // Rule ID 3491 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi4ger8pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8014:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI4GER8WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3491,
        GIR_Done,
      // Label 795: @25710
      GIM_Try, /*On fail goto*//*Label 796*/ 25794, // Rule ID 3493 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8016:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3493,
        GIR_Done,
      // Label 796: @25794
      GIM_Try, /*On fail goto*//*Label 797*/ 25878, // Rule ID 3495 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8012:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2SWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3495,
        GIR_Done,
      // Label 797: @25878
      GIM_Try, /*On fail goto*//*Label 798*/ 25962, // Rule ID 3497 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7998:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3497,
        GIR_Done,
      // Label 798: @25962
      GIM_Try, /*On fail goto*//*Label 799*/ 26046, // Rule ID 3498 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7997:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2PN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3498,
        GIR_Done,
      // Label 799: @26046
      GIM_Try, /*On fail goto*//*Label 800*/ 26130, // Rule ID 3499 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7996:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2NP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3499,
        GIR_Done,
      // Label 800: @26130
      GIM_Try, /*On fail goto*//*Label 801*/ 26214, // Rule ID 3500 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7995:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2NN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3500,
        GIR_Done,
      // Label 801: @26214
      GIM_Try, /*On fail goto*//*Label 802*/ 26298, // Rule ID 3502 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7998:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3502,
        GIR_Done,
      // Label 802: @26298
      GIM_Try, /*On fail goto*//*Label 803*/ 26382, // Rule ID 3503 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7997:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2WPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3503,
        GIR_Done,
      // Label 803: @26382
      GIM_Try, /*On fail goto*//*Label 804*/ 26466, // Rule ID 3504 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7996:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2WNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3504,
        GIR_Done,
      // Label 804: @26466
      GIM_Try, /*On fail goto*//*Label 805*/ 26550, // Rule ID 3505 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7995:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF16GER2WNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3505,
        GIR_Done,
      // Label 805: @26550
      GIM_Try, /*On fail goto*//*Label 806*/ 26634, // Rule ID 3507 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8003:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3507,
        GIR_Done,
      // Label 806: @26634
      GIM_Try, /*On fail goto*//*Label 807*/ 26718, // Rule ID 3508 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8002:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3508,
        GIR_Done,
      // Label 807: @26718
      GIM_Try, /*On fail goto*//*Label 808*/ 26802, // Rule ID 3509 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8001:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3509,
        GIR_Done,
      // Label 808: @26802
      GIM_Try, /*On fail goto*//*Label 809*/ 26886, // Rule ID 3510 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8000:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3510,
        GIR_Done,
      // Label 809: @26886
      GIM_Try, /*On fail goto*//*Label 810*/ 26954, // Rule ID 3512 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8008:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3512,
        GIR_Done,
      // Label 810: @26954
      GIM_Try, /*On fail goto*//*Label 811*/ 27022, // Rule ID 3513 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8007:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3513,
        GIR_Done,
      // Label 811: @27022
      GIM_Try, /*On fail goto*//*Label 812*/ 27090, // Rule ID 3514 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8006:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3514,
        GIR_Done,
      // Label 812: @27090
      GIM_Try, /*On fail goto*//*Label 813*/ 27158, // Rule ID 3515 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8005:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3515,
        GIR_Done,
      // Label 813: @27158
      GIM_Try, /*On fail goto*//*Label 814*/ 27242, // Rule ID 3517 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7993:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3517,
        GIR_Done,
      // Label 814: @27242
      GIM_Try, /*On fail goto*//*Label 815*/ 27326, // Rule ID 3518 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7992:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2PN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3518,
        GIR_Done,
      // Label 815: @27326
      GIM_Try, /*On fail goto*//*Label 816*/ 27410, // Rule ID 3519 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7991:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2NP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3519,
        GIR_Done,
      // Label 816: @27410
      GIM_Try, /*On fail goto*//*Label 817*/ 27494, // Rule ID 3520 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7990:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2NN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3520,
        GIR_Done,
      // Label 817: @27494
      GIM_Try, /*On fail goto*//*Label 818*/ 27578, // Rule ID 3522 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8010:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3522,
        GIR_Done,
      // Label 818: @27578
      GIM_Try, /*On fail goto*//*Label 819*/ 27662, // Rule ID 3523 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8017:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4SPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3523,
        GIR_Done,
      // Label 819: @27662
      GIM_Try, /*On fail goto*//*Label 820*/ 27746, // Rule ID 3525 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8003:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3525,
        GIR_Done,
      // Label 820: @27746
      GIM_Try, /*On fail goto*//*Label 821*/ 27830, // Rule ID 3526 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8002:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERWPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3526,
        GIR_Done,
      // Label 821: @27830
      GIM_Try, /*On fail goto*//*Label 822*/ 27914, // Rule ID 3527 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8001:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERWNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3527,
        GIR_Done,
      // Label 822: @27914
      GIM_Try, /*On fail goto*//*Label 823*/ 27998, // Rule ID 3528 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf32gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8000:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF32GERWNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3528,
        GIR_Done,
      // Label 823: @27998
      GIM_Try, /*On fail goto*//*Label 824*/ 28066, // Rule ID 3530 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8008:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3530,
        GIR_Done,
      // Label 824: @28066
      GIM_Try, /*On fail goto*//*Label 825*/ 28134, // Rule ID 3531 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8007:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERWPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3531,
        GIR_Done,
      // Label 825: @28134
      GIM_Try, /*On fail goto*//*Label 826*/ 28202, // Rule ID 3532 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8006:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3532,
        GIR_Done,
      // Label 826: @28202
      GIM_Try, /*On fail goto*//*Label 827*/ 28270, // Rule ID 3533 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvf64gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8005:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVF64GERWNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3533,
        GIR_Done,
      // Label 827: @28270
      GIM_Try, /*On fail goto*//*Label 828*/ 28354, // Rule ID 3535 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7993:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3535,
        GIR_Done,
      // Label 828: @28354
      GIM_Try, /*On fail goto*//*Label 829*/ 28438, // Rule ID 3536 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7992:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2WPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3536,
        GIR_Done,
      // Label 829: @28438
      GIM_Try, /*On fail goto*//*Label 830*/ 28522, // Rule ID 3537 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7991:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2WNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3537,
        GIR_Done,
      // Label 830: @28522
      GIM_Try, /*On fail goto*//*Label 831*/ 28606, // Rule ID 3538 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvbf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7990:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVBF16GER2WNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3538,
        GIR_Done,
      // Label 831: @28606
      GIM_Try, /*On fail goto*//*Label 832*/ 28690, // Rule ID 3540 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8010:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3540,
        GIR_Done,
      // Label 832: @28690
      GIM_Try, /*On fail goto*//*Label 833*/ 28774, // Rule ID 3541 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xvi8ger4spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 8017:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVI8GER4WSPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3541,
        GIR_Done,
      // Label 833: @28774
      GIM_Reject,
    // Label 721: @28775
    GIM_Try, /*On fail goto*//*Label 834*/ 29389,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_Try, /*On fail goto*//*Label 835*/ 28894, // Rule ID 3553 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7970:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3553,
        GIR_Done,
      // Label 835: @28894
      GIM_Try, /*On fail goto*//*Label 836*/ 28992, // Rule ID 3558 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7975:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3558,
        GIR_Done,
      // Label 836: @28992
      GIM_Try, /*On fail goto*//*Label 837*/ 29106, // Rule ID 3582 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7970:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3582,
        GIR_Done,
      // Label 837: @29106
      GIM_Try, /*On fail goto*//*Label 838*/ 29204, // Rule ID 3587 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64ger,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7975:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3587,
        GIR_Done,
      // Label 838: @29204
      GIM_Try, /*On fail goto*//*Label 839*/ 29263, // Rule ID 1104 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxeval,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] IMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v2i64] } 8152:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)  =>  (XXEVAL:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXEVAL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // XC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // IMM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1104,
        GIR_Done,
      // Label 839: @29263
      GIM_Try, /*On fail goto*//*Label 840*/ 29388, // Rule ID 3401 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxpermx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] D
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v16i8] } 8160:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C, (timm:{ *:[i32] }):$D)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXPERMX:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] }), ?:{ *:[i32] }:$D), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXPERMX,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
        // GIR_Coverage, 3401,
        GIR_Done,
      // Label 840: @29388
      GIM_Reject,
    // Label 834: @29389
    GIM_Try, /*On fail goto*//*Label 841*/ 32815,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/7,
      GIM_Try, /*On fail goto*//*Label 842*/ 29527, // Rule ID 3542 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi4ger8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk8Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7984:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI4GER8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3542,
        GIR_Done,
      // Label 842: @29527
      GIM_Try, /*On fail goto*//*Label 843*/ 29660, // Rule ID 3544 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7986:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3544,
        GIR_Done,
      // Label 843: @29660
      GIM_Try, /*On fail goto*//*Label 844*/ 29793, // Rule ID 3546 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2s,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7982:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3546,
        GIR_Done,
      // Label 844: @29793
      GIM_Try, /*On fail goto*//*Label 845*/ 29926, // Rule ID 3548 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7965:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3548,
        GIR_Done,
      // Label 845: @29926
      GIM_Try, /*On fail goto*//*Label 846*/ 30059, // Rule ID 3563 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7960:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3563,
        GIR_Done,
      // Label 846: @30059
      GIM_Try, /*On fail goto*//*Label 847*/ 30192, // Rule ID 3568 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7980:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3568,
        GIR_Done,
      // Label 847: @30192
      GIM_Try, /*On fail goto*//*Label 848*/ 30325, // Rule ID 3571 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi4ger8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk8Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7984:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI4GER8W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3571,
        GIR_Done,
      // Label 848: @30325
      GIM_Try, /*On fail goto*//*Label 849*/ 30458, // Rule ID 3573 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7986:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3573,
        GIR_Done,
      // Label 849: @30458
      GIM_Try, /*On fail goto*//*Label 850*/ 30591, // Rule ID 3575 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2s,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7982:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2SW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3575,
        GIR_Done,
      // Label 850: @30591
      GIM_Try, /*On fail goto*//*Label 851*/ 30724, // Rule ID 3577 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7965:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3577,
        GIR_Done,
      // Label 851: @30724
      GIM_Try, /*On fail goto*//*Label 852*/ 30857, // Rule ID 3592 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7960:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3592,
        GIR_Done,
      // Label 852: @30857
      GIM_Try, /*On fail goto*//*Label 853*/ 30990, // Rule ID 3597 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7980:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3597,
        GIR_Done,
      // Label 853: @30990
      GIM_Try, /*On fail goto*//*Label 854*/ 31112, // Rule ID 3554 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7974:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3554,
        GIR_Done,
      // Label 854: @31112
      GIM_Try, /*On fail goto*//*Label 855*/ 31234, // Rule ID 3555 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7973:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3555,
        GIR_Done,
      // Label 855: @31234
      GIM_Try, /*On fail goto*//*Label 856*/ 31356, // Rule ID 3556 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7972:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3556,
        GIR_Done,
      // Label 856: @31356
      GIM_Try, /*On fail goto*//*Label 857*/ 31478, // Rule ID 3557 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7971:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3557,
        GIR_Done,
      // Label 857: @31478
      GIM_Try, /*On fail goto*//*Label 858*/ 31584, // Rule ID 3559 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7979:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3559,
        GIR_Done,
      // Label 858: @31584
      GIM_Try, /*On fail goto*//*Label 859*/ 31690, // Rule ID 3560 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7978:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3560,
        GIR_Done,
      // Label 859: @31690
      GIM_Try, /*On fail goto*//*Label 860*/ 31796, // Rule ID 3561 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7977:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3561,
        GIR_Done,
      // Label 860: @31796
      GIM_Try, /*On fail goto*//*Label 861*/ 31902, // Rule ID 3562 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7976:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3562,
        GIR_Done,
      // Label 861: @31902
      GIM_Try, /*On fail goto*//*Label 862*/ 32024, // Rule ID 3583 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7974:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3583,
        GIR_Done,
      // Label 862: @32024
      GIM_Try, /*On fail goto*//*Label 863*/ 32146, // Rule ID 3584 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7973:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERWPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3584,
        GIR_Done,
      // Label 863: @32146
      GIM_Try, /*On fail goto*//*Label 864*/ 32268, // Rule ID 3585 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7972:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERWNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3585,
        GIR_Done,
      // Label 864: @32268
      GIM_Try, /*On fail goto*//*Label 865*/ 32390, // Rule ID 3586 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf32gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7971:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF32GERWNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3586,
        GIR_Done,
      // Label 865: @32390
      GIM_Try, /*On fail goto*//*Label 866*/ 32496, // Rule ID 3588 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gerpp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7979:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3588,
        GIR_Done,
      // Label 866: @32496
      GIM_Try, /*On fail goto*//*Label 867*/ 32602, // Rule ID 3589 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gerpn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7978:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERWPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3589,
        GIR_Done,
      // Label 867: @32602
      GIM_Try, /*On fail goto*//*Label 868*/ 32708, // Rule ID 3590 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gernp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7977:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERWNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3590,
        GIR_Done,
      // Label 868: @32708
      GIM_Try, /*On fail goto*//*Label 869*/ 32814, // Rule ID 3591 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf64gernn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7976:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF64GERWNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3591,
        GIR_Done,
      // Label 869: @32814
      GIM_Reject,
    // Label 841: @32815
    GIM_Try, /*On fail goto*//*Label 870*/ 36487,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/8,
      GIM_Try, /*On fail goto*//*Label 871*/ 32961, // Rule ID 3543 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi4ger8pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk8Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7985:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI4GER8PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3543,
        GIR_Done,
      // Label 871: @32961
      GIM_Try, /*On fail goto*//*Label 872*/ 33102, // Rule ID 3545 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7987:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3545,
        GIR_Done,
      // Label 872: @33102
      GIM_Try, /*On fail goto*//*Label 873*/ 33243, // Rule ID 3547 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7983:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2SPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3547,
        GIR_Done,
      // Label 873: @33243
      GIM_Try, /*On fail goto*//*Label 874*/ 33384, // Rule ID 3549 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7969:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3549,
        GIR_Done,
      // Label 874: @33384
      GIM_Try, /*On fail goto*//*Label 875*/ 33525, // Rule ID 3550 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7968:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2PN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3550,
        GIR_Done,
      // Label 875: @33525
      GIM_Try, /*On fail goto*//*Label 876*/ 33666, // Rule ID 3551 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7967:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2NP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3551,
        GIR_Done,
      // Label 876: @33666
      GIM_Try, /*On fail goto*//*Label 877*/ 33807, // Rule ID 3552 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7966:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2NN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3552,
        GIR_Done,
      // Label 877: @33807
      GIM_Try, /*On fail goto*//*Label 878*/ 33948, // Rule ID 3564 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7964:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3564,
        GIR_Done,
      // Label 878: @33948
      GIM_Try, /*On fail goto*//*Label 879*/ 34089, // Rule ID 3565 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7963:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2PN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3565,
        GIR_Done,
      // Label 879: @34089
      GIM_Try, /*On fail goto*//*Label 880*/ 34230, // Rule ID 3566 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7962:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2NP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3566,
        GIR_Done,
      // Label 880: @34230
      GIM_Try, /*On fail goto*//*Label 881*/ 34371, // Rule ID 3567 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7961:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2NN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3567,
        GIR_Done,
      // Label 881: @34371
      GIM_Try, /*On fail goto*//*Label 882*/ 34512, // Rule ID 3569 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7988:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4SPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3569,
        GIR_Done,
      // Label 882: @34512
      GIM_Try, /*On fail goto*//*Label 883*/ 34653, // Rule ID 3570 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7981:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2PP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3570,
        GIR_Done,
      // Label 883: @34653
      GIM_Try, /*On fail goto*//*Label 884*/ 34794, // Rule ID 3572 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi4ger8pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk8Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7985:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI4GER8WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3572,
        GIR_Done,
      // Label 884: @34794
      GIM_Try, /*On fail goto*//*Label 885*/ 34935, // Rule ID 3574 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7987:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3574,
        GIR_Done,
      // Label 885: @34935
      GIM_Try, /*On fail goto*//*Label 886*/ 35076, // Rule ID 3576 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7983:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2SWPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3576,
        GIR_Done,
      // Label 886: @35076
      GIM_Try, /*On fail goto*//*Label 887*/ 35217, // Rule ID 3578 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7969:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3578,
        GIR_Done,
      // Label 887: @35217
      GIM_Try, /*On fail goto*//*Label 888*/ 35358, // Rule ID 3579 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7968:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2WPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3579,
        GIR_Done,
      // Label 888: @35358
      GIM_Try, /*On fail goto*//*Label 889*/ 35499, // Rule ID 3580 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7967:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2WNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3580,
        GIR_Done,
      // Label 889: @35499
      GIM_Try, /*On fail goto*//*Label 890*/ 35640, // Rule ID 3581 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7966:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVF16GER2WNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3581,
        GIR_Done,
      // Label 890: @35640
      GIM_Try, /*On fail goto*//*Label 891*/ 35781, // Rule ID 3593 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7964:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3593,
        GIR_Done,
      // Label 891: @35781
      GIM_Try, /*On fail goto*//*Label 892*/ 35922, // Rule ID 3594 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2pn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7963:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2WPN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3594,
        GIR_Done,
      // Label 892: @35922
      GIM_Try, /*On fail goto*//*Label 893*/ 36063, // Rule ID 3595 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2np,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7962:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2WNP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3595,
        GIR_Done,
      // Label 893: @36063
      GIM_Try, /*On fail goto*//*Label 894*/ 36204, // Rule ID 3596 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvbf16ger2nn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7961:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVBF16GER2WNN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3596,
        GIR_Done,
      // Label 894: @36204
      GIM_Try, /*On fail goto*//*Label 895*/ 36345, // Rule ID 3598 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi8ger4spp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7988:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI8GER4WSPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3598,
        GIR_Done,
      // Label 895: @36345
      GIM_Try, /*On fail goto*//*Label 896*/ 36486, // Rule ID 3599 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA_PrefixInstrs,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_pmxvi16ger2pp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_Msk4Imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GICXXPred_I64_Predicate_Msk2Imm,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7981:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PMXVI16GER2WPP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3599,
        GIR_Done,
      // Label 896: @36486
      GIM_Reject,
    // Label 870: @36487
    GIM_Reject,
    // Label 18: @36488
    GIM_Try, /*On fail goto*//*Label 897*/ 36778,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 898*/ 36511, // Rule ID 103 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_eieio,
        // (intrinsic_void 7907:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 103,
        GIR_Done,
      // Label 898: @36511
      GIM_Try, /*On fail goto*//*Label 899*/ 36534, // Rule ID 1182 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_sync,
        // (intrinsic_void 8056:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1182,
        GIR_Done,
      // Label 899: @36534
      GIM_Try, /*On fail goto*//*Label 900*/ 36557, // Rule ID 1183 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_sync,
        // (intrinsic_void 7940:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1183,
        GIR_Done,
      // Label 900: @36557
      GIM_Try, /*On fail goto*//*Label 901*/ 36580, // Rule ID 1184 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_lwsync,
        // (intrinsic_void 7945:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1184,
        GIR_Done,
      // Label 901: @36580
      GIM_Try, /*On fail goto*//*Label 902*/ 36603, // Rule ID 1185 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_lwsync,
        // (intrinsic_void 7939:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1185,
        GIR_Done,
      // Label 902: @36603
      GIM_Try, /*On fail goto*//*Label 903*/ 36623, // Rule ID 1186 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_sync,
        // (intrinsic_void 8056:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1186,
        GIR_Done,
      // Label 903: @36623
      GIM_Try, /*On fail goto*//*Label 904*/ 36643, // Rule ID 1187 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_sync,
        // (intrinsic_void 7940:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1187,
        GIR_Done,
      // Label 904: @36643
      GIM_Try, /*On fail goto*//*Label 905*/ 36663, // Rule ID 1188 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_lwsync,
        // (intrinsic_void 7945:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1188,
        GIR_Done,
      // Label 905: @36663
      GIM_Try, /*On fail goto*//*Label 906*/ 36683, // Rule ID 1189 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_lwsync,
        // (intrinsic_void 7939:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1189,
        GIR_Done,
      // Label 906: @36683
      GIM_Try, /*On fail goto*//*Label 907*/ 36701, // Rule ID 1190 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_eieio,
        // (intrinsic_void 7907:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1190,
        GIR_Done,
      // Label 907: @36701
      GIM_Try, /*On fail goto*//*Label 908*/ 36719, // Rule ID 1191 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_eieio,
        // (intrinsic_void 7938:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1191,
        GIR_Done,
      // Label 908: @36719
      GIM_Try, /*On fail goto*//*Label 909*/ 36739, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_IsAIX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dssall,
        // (intrinsic_void 7563:{ *:[iPTR] })  =>  (NOP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOP,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 909: @36739
      GIM_Try, /*On fail goto*//*Label 910*/ 36759, // Rule ID 1270 //
        GIM_CheckFeatures, GIFBS_NotAIX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dssall,
        // (intrinsic_void 7563:{ *:[iPTR] })  =>  (DSSALL)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSSALL,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 910: @36759
      GIM_Try, /*On fail goto*//*Label 911*/ 36777, // Rule ID 4801 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_isync,
        // (intrinsic_void 7941:{ *:[iPTR] })  =>  (ISYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ISYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4801,
        GIR_Done,
      // Label 911: @36777
      GIM_Reject,
    // Label 897: @36778
    GIM_Try, /*On fail goto*//*Label 912*/ 37454,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 913*/ 36820, // Rule ID 266 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dss,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7562:{ *:[iPTR] }, (imm:{ *:[i32] }):$STRM)  =>  (DSS (imm:{ *:[i32] }):$STRM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSS,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 266,
        GIR_Done,
      // Label 913: @36820
      GIM_Try, /*On fail goto*//*Label 914*/ 36843, // Rule ID 190 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsb0,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 8021:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB0 (timm:{ *:[i32] }):$FM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSB0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 190,
        GIR_Done,
      // Label 914: @36843
      GIM_Try, /*On fail goto*//*Label 915*/ 36866, // Rule ID 191 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsb1,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 8022:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB1 (timm:{ *:[i32] }):$FM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSB1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 191,
        GIR_Done,
      // Label 915: @36866
      GIM_Try, /*On fail goto*//*Label 916*/ 36894, // Rule ID 275 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mfvscr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7575:{ *:[iPTR] })  =>  (MFVSCR:{ *:[v8i16] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSCR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 275,
        GIR_Done,
      // Label 916: @36894
      GIM_Try, /*On fail goto*//*Label 917*/ 36920, // Rule ID 1217 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_readflm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 8036:{ *:[iPTR] })  =>  (MFFS:{ *:[f64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFFS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1217,
        GIR_Done,
      // Label 917: @36920
      GIM_Try, /*On fail goto*//*Label 918*/ 36978, // Rule ID 1553 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darn32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 7884:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (DARN:{ *:[i64] } 0:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::DARN,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::G8RCRegClassID,
        // GIR_Coverage, 1553,
        GIR_Done,
      // Label 918: @36978
      GIM_Try, /*On fail goto*//*Label 919*/ 37013, // Rule ID 1554 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7883:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DARN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1554,
        GIR_Done,
      // Label 919: @37013
      GIM_Try, /*On fail goto*//*Label 920*/ 37048, // Rule ID 1555 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darnraw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7885:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 2:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DARN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1555,
        GIR_Done,
      // Label 920: @37048
      GIM_Try, /*On fail goto*//*Label 921*/ 37080, // Rule ID 2867 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_tcheck,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 8063:{ *:[iPTR] })  =>  (TCHECK_RET:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::TCHECK_RET,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2867,
        GIR_Done,
      // Label 921: @37080
      GIM_Try, /*On fail goto*//*Label 922*/ 37115, // Rule ID 2871 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_texasr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7932:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 130:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_AddImm, /*InsnID*/0, /*Imm*/130,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2871,
        GIR_Done,
      // Label 922: @37115
      GIM_Try, /*On fail goto*//*Label 923*/ 37150, // Rule ID 2872 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_texasru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7933:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 131:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_AddImm, /*InsnID*/0, /*Imm*/131,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2872,
        GIR_Done,
      // Label 923: @37150
      GIM_Try, /*On fail goto*//*Label 924*/ 37185, // Rule ID 2873 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_tfhar,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7934:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 128:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_AddImm, /*InsnID*/0, /*Imm*/128,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2873,
        GIR_Done,
      // Label 924: @37185
      GIM_Try, /*On fail goto*//*Label 925*/ 37220, // Rule ID 2874 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_tfiar,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7935:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 129:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_AddImm, /*InsnID*/0, /*Imm*/129,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2874,
        GIR_Done,
      // Label 925: @37220
      GIM_Try, /*On fail goto*//*Label 926*/ 37253, // Rule ID 4845 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtmsr,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_void 8025:{ *:[iPTR] }, gprc:{ *:[i32] }:$RS)  =>  (MTMSR ?:{ *:[i32] }:$RS, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTMSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RS
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4845,
        GIR_Done,
      // Label 926: @37253
      GIM_Try, /*On fail goto*//*Label 927*/ 37279, // Rule ID 186 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::set_loop_iterations,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        // (intrinsic_void 282:{ *:[iPTR] }, i32:{ *:[i32] }:$RST)  =>  (MTCTRloop:{ *:[i32] } i32:{ *:[i32] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTCTRloop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 186,
        GIR_Done,
      // Label 927: @37279
      GIM_Try, /*On fail goto*//*Label 928*/ 37303, // Rule ID 276 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_mtvscr,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
        // (intrinsic_void 7576:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (MTVSCR v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSCR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 276,
        GIR_Done,
      // Label 928: @37303
      GIM_Try, /*On fail goto*//*Label 929*/ 37329, // Rule ID 630 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::set_loop_iterations,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 282:{ *:[iPTR] }, i64:{ *:[i64] }:$RST)  =>  (MTCTR8loop:{ *:[i64] } i64:{ *:[i64] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTCTR8loop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 630,
        GIR_Done,
      // Label 929: @37329
      GIM_Try, /*On fail goto*//*Label 930*/ 37360, // Rule ID 2875 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_set_texasr,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 8039:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 130:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR8,
        GIR_AddImm, /*InsnID*/0, /*Imm*/130,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2875,
        GIR_Done,
      // Label 930: @37360
      GIM_Try, /*On fail goto*//*Label 931*/ 37391, // Rule ID 2876 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_set_texasru,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 8040:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 131:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR8,
        GIR_AddImm, /*InsnID*/0, /*Imm*/131,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2876,
        GIR_Done,
      // Label 931: @37391
      GIM_Try, /*On fail goto*//*Label 932*/ 37422, // Rule ID 2877 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_set_tfhar,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 8041:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 128:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR8,
        GIR_AddImm, /*InsnID*/0, /*Imm*/128,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2877,
        GIR_Done,
      // Label 932: @37422
      GIM_Try, /*On fail goto*//*Label 933*/ 37453, // Rule ID 2878 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_set_tfiar,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 8042:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 129:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR8,
        GIR_AddImm, /*InsnID*/0, /*Imm*/129,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2878,
        GIR_Done,
      // Label 933: @37453
      GIM_Reject,
    // Label 912: @37454
    GIM_Try, /*On fail goto*//*Label 934*/ 37894,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 935*/ 37489, // Rule ID 1160 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsfi,
        // MIs[0] BF
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] U
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 8024:{ *:[iPTR] }, (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)  =>  (MTFSFIb (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSFIb,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // BF
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // U
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1160,
        GIR_Done,
      // Label 935: @37489
      GIM_Try, /*On fail goto*//*Label 936*/ 37536, // Rule ID 12 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setrnd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[f64] } 8045:{ *:[iPTR] }, (imm:{ *:[i32] }):$RND)  =>  (SETRNDi:{ *:[f64] } (imm:{ *:[i32] }):$RND)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETRNDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // RND
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12,
        GIR_Done,
      // Label 936: @37536
      GIM_Try, /*On fail goto*//*Label 937*/ 37583, // Rule ID 187 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::loop_decrement,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i1] } 189:{ *:[iPTR] }, (imm:{ *:[i32] }):$stride)  =>  (DecreaseCTRloop:{ *:[i1] }:{ *:[i32] } (imm:{ *:[i32] }):$stride)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DecreaseCTRloop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 187,
        GIR_Done,
      // Label 937: @37583
      GIM_Try, /*On fail goto*//*Label 938*/ 37630, // Rule ID 631 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::loop_decrement,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i1] } 189:{ *:[iPTR] }, (imm:{ *:[i64] }):$stride)  =>  (DecreaseCTR8loop:{ *:[i1] }:{ *:[i64] } (imm:{ *:[i64] }):$stride)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DecreaseCTR8loop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 631,
        GIR_Done,
      // Label 938: @37630
      GIM_Try, /*On fail goto*//*Label 939*/ 37667, // Rule ID 1558 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mfspr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i64] } 7953:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR)  =>  (MFSPR8:{ *:[i64] } ?:{ *:[i32] }:$SPR)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // SPR
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1558,
        GIR_Done,
      // Label 939: @37667
      GIM_Try, /*On fail goto*//*Label 940*/ 37704, // Rule ID 4843 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mfspr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 7953:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR)  =>  (MFSPR:{ *:[i32] } ?:{ *:[i32] }:$SPR)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // SPR
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4843,
        GIR_Done,
      // Label 940: @37704
      GIM_Try, /*On fail goto*//*Label 941*/ 37741, // Rule ID 1559 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtspr,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_void 8026:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR, g8rc:{ *:[i64] }:$RT)  =>  (MTSPR8 ?:{ *:[i32] }:$SPR, ?:{ *:[i64] }:$RT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // SPR
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RT
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1559,
        GIR_Done,
      // Label 941: @37741
      GIM_Try, /*On fail goto*//*Label 942*/ 37778, // Rule ID 4844 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtspr,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_void 8026:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR, gprc:{ *:[i32] }:$RT)  =>  (MTSPR ?:{ *:[i32] }:$SPR, ?:{ *:[i32] }:$RT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTSPR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // SPR
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RT
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4844,
        GIR_Done,
      // Label 942: @37778
      GIM_Try, /*On fail goto*//*Label 943*/ 37809, // Rule ID 192 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsf,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 8023:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$RT)  =>  (MTFSFb (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$RT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSFb,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 192,
        GIR_Done,
      // Label 943: @37809
      GIM_Try, /*On fail goto*//*Label 944*/ 37851, // Rule ID 13 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setrnd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 8045:{ *:[iPTR] }, gprc:{ *:[i32] }:$in)  =>  (SETRND:{ *:[f64] } gprc:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETRND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 13,
        GIR_Done,
      // Label 944: @37851
      GIM_Try, /*On fail goto*//*Label 945*/ 37893, // Rule ID 14 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setflm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 8044:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FLM)  =>  (SETFLM:{ *:[f64] } f8rc:{ *:[f64] }:$FLM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETFLM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FLM
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 14,
        GIR_Done,
      // Label 945: @37893
      GIM_Reject,
    // Label 934: @37894
    GIM_Try, /*On fail goto*//*Label 946*/ 38940,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 947*/ 37952, // Rule ID 267 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7564:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DST,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 267,
        GIR_Done,
      // Label 947: @37952
      GIM_Try, /*On fail goto*//*Label 948*/ 38005, // Rule ID 268 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7567:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTT,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 268,
        GIR_Done,
      // Label 948: @38005
      GIM_Try, /*On fail goto*//*Label 949*/ 38058, // Rule ID 269 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7565:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTST,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 269,
        GIR_Done,
      // Label 949: @38058
      GIM_Try, /*On fail goto*//*Label 950*/ 38111, // Rule ID 270 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dststt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7566:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTSTT,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 270,
        GIR_Done,
      // Label 950: @38111
      GIM_Try, /*On fail goto*//*Label 951*/ 38164, // Rule ID 271 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7564:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DST64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 271,
        GIR_Done,
      // Label 951: @38164
      GIM_Try, /*On fail goto*//*Label 952*/ 38217, // Rule ID 272 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7567:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTT64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 272,
        GIR_Done,
      // Label 952: @38217
      GIM_Try, /*On fail goto*//*Label 953*/ 38270, // Rule ID 273 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7565:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTST64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 273,
        GIR_Done,
      // Label 953: @38270
      GIM_Try, /*On fail goto*//*Label 954*/ 38323, // Rule ID 274 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dststt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7566:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTSTT64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 954: @38323
      GIM_Try, /*On fail goto*//*Label 955*/ 38367, // Rule ID 377 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsumsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7846:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUMSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUMSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 377,
        GIR_Done,
      // Label 955: @38367
      GIM_Try, /*On fail goto*//*Label 956*/ 38411, // Rule ID 378 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum2sws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7842:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM2SWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM2SWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 378,
        GIR_Done,
      // Label 956: @38411
      GIM_Try, /*On fail goto*//*Label 957*/ 38455, // Rule ID 379 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4sbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7843:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4SBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4SBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 379,
        GIR_Done,
      // Label 957: @38455
      GIM_Try, /*On fail goto*//*Label 958*/ 38499, // Rule ID 380 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4shs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7844:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4SHS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4SHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 380,
        GIR_Done,
      // Label 958: @38499
      GIM_Try, /*On fail goto*//*Label 959*/ 38543, // Rule ID 381 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4ubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7845:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4UBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4UBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 381,
        GIR_Done,
      // Label 959: @38543
      GIM_Try, /*On fail goto*//*Label 960*/ 38587, // Rule ID 408 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkshss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7780:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKSHSS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSHSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 408,
        GIR_Done,
      // Label 960: @38587
      GIM_Try, /*On fail goto*//*Label 961*/ 38631, // Rule ID 409 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkshus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7781:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKSHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSHUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 409,
        GIR_Done,
      // Label 961: @38631
      GIM_Try, /*On fail goto*//*Label 962*/ 38675, // Rule ID 410 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkswss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7782:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKSWSS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSWSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 410,
        GIR_Done,
      // Label 962: @38675
      GIM_Try, /*On fail goto*//*Label 963*/ 38719, // Rule ID 411 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkswus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7783:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKSWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSWUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 411,
        GIR_Done,
      // Label 963: @38719
      GIM_Try, /*On fail goto*//*Label 964*/ 38763, // Rule ID 412 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkuhus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7785:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKUHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKUHUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 412,
        GIR_Done,
      // Label 964: @38763
      GIM_Try, /*On fail goto*//*Label 965*/ 38807, // Rule ID 413 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkuwus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7786:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKUWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKUWUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 413,
        GIR_Done,
      // Label 965: @38807
      GIM_Try, /*On fail goto*//*Label 966*/ 38851, // Rule ID 497 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpksdss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7778:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPKSDSS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSDSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 966: @38851
      GIM_Try, /*On fail goto*//*Label 967*/ 38895, // Rule ID 498 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpksdus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7779:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPKSDUS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSDUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, //