/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands,
                       const SmallBitVector &OptionalOperandsMask);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidBareSymbol,
  Match_InvalidCLUIImm,
  Match_InvalidCSRSystemRegister,
  Match_InvalidCallSymbol,
  Match_InvalidImmXLenLI,
  Match_InvalidImmXLenLI_Restricted,
  Match_InvalidImmZero,
  Match_InvalidLoadFPImm,
  Match_InvalidPseudoJumpSymbol,
  Match_InvalidRTZArg,
  Match_InvalidRlist,
  Match_InvalidRnumArg,
  Match_InvalidRnumArg_0_7,
  Match_InvalidRnumArg_1_10,
  Match_InvalidRnumArg_2_14,
  Match_InvalidSImm10Lsb0000NonZero,
  Match_InvalidSImm12,
  Match_InvalidSImm12Lsb0,
  Match_InvalidSImm12Lsb00000,
  Match_InvalidSImm13Lsb0,
  Match_InvalidSImm21Lsb0JAL,
  Match_InvalidSImm5,
  Match_InvalidSImm5Plus1,
  Match_InvalidSImm6,
  Match_InvalidSImm6NonZero,
  Match_InvalidSImm9Lsb0,
  Match_InvalidSpimm,
  Match_InvalidTPRelAddSymbol,
  Match_InvalidUImm1,
  Match_InvalidUImm10Lsb00NonZero,
  Match_InvalidUImm2,
  Match_InvalidUImm20AUIPC,
  Match_InvalidUImm20LUI,
  Match_InvalidUImm2Lsb0,
  Match_InvalidUImm3,
  Match_InvalidUImm4,
  Match_InvalidUImm5,
  Match_InvalidUImm6,
  Match_InvalidUImm7,
  Match_InvalidUImm7Lsb00,
  Match_InvalidUImm8,
  Match_InvalidUImm8GE32,
  Match_InvalidUImm8Lsb00,
  Match_InvalidUImm8Lsb000,
  Match_InvalidUImm9Lsb000,
  Match_InvalidUImmLog2XLen,
  Match_InvalidUImmLog2XLenHalf,
  Match_InvalidUImmLog2XLenNonZero,
  Match_InvalidVMaskRegister,
  Match_InvalidVTypeI,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicsrBit = 42,
  Feature_HasStdExtMBit = 10,
  Feature_HasStdExtMOrZmmulBit = 11,
  Feature_HasStdExtABit = 2,
  Feature_HasStdExtFBit = 8,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtHBit = 9,
  Feature_HasStdExtZihintpauseBit = 45,
  Feature_HasStdExtZihintntlBit = 44,
  Feature_HasStdExtZifenceiBit = 43,
  Feature_HasStdExtZfhminBit = 33,
  Feature_HasStdExtZfhBit = 30,
  Feature_HasStdExtZfhOrZfhminBit = 31,
  Feature_HasStdExtZfinxBit = 34,
  Feature_HasStdExtZdinxBit = 27,
  Feature_HasStdExtZhinxminBit = 37,
  Feature_HasStdExtZhinxBit = 35,
  Feature_HasStdExtZhinxOrZhinxminBit = 36,
  Feature_HasStdExtZfaBit = 28,
  Feature_HasStdExtCBit = 3,
  Feature_HasStdExtZbaBit = 15,
  Feature_HasStdExtZbbBit = 16,
  Feature_HasStdExtZbcBit = 18,
  Feature_HasStdExtZbsBit = 23,
  Feature_HasStdExtZbkbBit = 20,
  Feature_HasStdExtZbkxBit = 22,
  Feature_HasStdExtZbbOrZbkbBit = 17,
  Feature_HasStdExtZbkcBit = 21,
  Feature_HasStdExtZbcOrZbkcBit = 19,
  Feature_HasStdExtZkndBit = 46,
  Feature_HasStdExtZkneBit = 48,
  Feature_HasStdExtZkndOrZkneBit = 47,
  Feature_HasStdExtZknhBit = 49,
  Feature_HasStdExtZksedBit = 51,
  Feature_HasStdExtZkshBit = 52,
  Feature_HasStdExtZkrBit = 50,
  Feature_HasStdExtCOrZcaBit = 4,
  Feature_HasStdExtZcbBit = 24,
  Feature_HasStdExtCOrZcdBit = 5,
  Feature_HasStdExtZcmpBit = 25,
  Feature_HasStdExtZcmtBit = 26,
  Feature_HasStdExtCOrZcfOrZceBit = 6,
  Feature_HasRVCHintsBit = 1,
  Feature_HasVInstructionsBit = 63,
  Feature_HasVInstructionsI64Bit = 65,
  Feature_HasVInstructionsAnyFBit = 64,
  Feature_HasStdExtZvfbfminBit = 56,
  Feature_HasStdExtZvfbfwmaBit = 57,
  Feature_HasStdExtZfhOrZvfhBit = 32,
  Feature_HasStdExtZicbomBit = 38,
  Feature_HasStdExtZicbozBit = 40,
  Feature_HasStdExtZicbopBit = 39,
  Feature_HasStdExtSvinvalBit = 12,
  Feature_HasStdExtZtsoBit = 53,
  Feature_HasStdExtZawrsBit = 14,
  Feature_HasStdExtZvbbBit = 54,
  Feature_HasStdExtZvbcBit = 55,
  Feature_HasStdExtZvkgBit = 58,
  Feature_HasStdExtZvknedBit = 59,
  Feature_HasStdExtZvknhaBit = 60,
  Feature_HasStdExtZvksedBit = 61,
  Feature_HasStdExtZvkshBit = 62,
  Feature_HasStdExtZicondBit = 41,
  Feature_HasStdExtZfbfminBit = 29,
  Feature_HasHalfFPLoadStoreMoveBit = 0,
  Feature_HasStdExtZacasBit = 13,
  Feature_HasVendorXVentanaCondOpsBit = 81,
  Feature_HasVendorXTHeadBaBit = 70,
  Feature_HasVendorXTHeadBbBit = 71,
  Feature_HasVendorXTHeadBsBit = 72,
  Feature_HasVendorXTHeadCondMovBit = 74,
  Feature_HasVendorXTHeadCmoBit = 73,
  Feature_HasVendorXTHeadFMemIdxBit = 75,
  Feature_HasVendorXTHeadMacBit = 76,
  Feature_HasVendorXTHeadMemIdxBit = 77,
  Feature_HasVendorXTHeadMemPairBit = 78,
  Feature_HasVendorXTHeadSyncBit = 79,
  Feature_HasVendorXTHeadVdotBit = 80,
  Feature_HasVendorXSfvcpBit = 69,
  Feature_HasVendorXSfcieBit = 68,
  Feature_HasVendorXCVbitmanipBit = 66,
  Feature_HasVendorXCVmacBit = 67,
  Feature_IsRV64Bit = 83,
  Feature_IsRV32Bit = 82,
  Feature_IsRVEBit = 84,
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != '0')
      break;
    return 8;	 // "0"
  case 2:	 // 66 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 30 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return 73;	 // "f0"
      case '1':	 // 3 strings to match.
        return 74;	 // "f1"
      case '2':	 // 3 strings to match.
        return 75;	 // "f2"
      case '3':	 // 3 strings to match.
        return 76;	 // "f3"
      case '4':	 // 3 strings to match.
        return 77;	 // "f4"
      case '5':	 // 3 strings to match.
        return 78;	 // "f5"
      case '6':	 // 3 strings to match.
        return 79;	 // "f6"
      case '7':	 // 3 strings to match.
        return 80;	 // "f7"
      case '8':	 // 3 strings to match.
        return 81;	 // "f8"
      case '9':	 // 3 strings to match.
        return 82;	 // "f9"
      }
      break;
    case 'v':	 // 21 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return 9;	 // "v0"
      case '1':	 // 1 string to match.
        return 10;	 // "v1"
      case '2':	 // 2 strings to match.
        return 11;	 // "v2"
      case '3':	 // 1 string to match.
        return 12;	 // "v3"
      case '4':	 // 3 strings to match.
        return 13;	 // "v4"
      case '5':	 // 1 string to match.
        return 14;	 // "v5"
      case '6':	 // 2 strings to match.
        return 15;	 // "v6"
      case '7':	 // 1 string to match.
        return 16;	 // "v7"
      case '8':	 // 4 strings to match.
        return 17;	 // "v8"
      case '9':	 // 1 string to match.
        return 18;	 // "v9"
      case 'l':	 // 1 string to match.
        return 3;	 // "vl"
      }
      break;
    case 'x':	 // 15 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 41;	 // "x0"
      case '1':	 // 1 string to match.
        return 42;	 // "x1"
      case '2':	 // 2 strings to match.
        return 43;	 // "x2"
      case '3':	 // 1 string to match.
        return 44;	 // "x3"
      case '4':	 // 2 strings to match.
        return 45;	 // "x4"
      case '5':	 // 1 string to match.
        return 46;	 // "x5"
      case '6':	 // 2 strings to match.
        return 47;	 // "x6"
      case '7':	 // 1 string to match.
        return 48;	 // "x7"
      case '8':	 // 2 strings to match.
        return 49;	 // "x8"
      case '9':	 // 1 string to match.
        return 50;	 // "x9"
      }
      break;
    }
    break;
  case 3:	 // 140 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 67 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 83;	 // "f10"
        case '1':	 // 3 strings to match.
          return 84;	 // "f11"
        case '2':	 // 3 strings to match.
          return 85;	 // "f12"
        case '3':	 // 3 strings to match.
          return 86;	 // "f13"
        case '4':	 // 3 strings to match.
          return 87;	 // "f14"
        case '5':	 // 3 strings to match.
          return 88;	 // "f15"
        case '6':	 // 3 strings to match.
          return 89;	 // "f16"
        case '7':	 // 3 strings to match.
          return 90;	 // "f17"
        case '8':	 // 3 strings to match.
          return 91;	 // "f18"
        case '9':	 // 3 strings to match.
          return 92;	 // "f19"
        }
        break;
      case '2':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 93;	 // "f20"
        case '1':	 // 3 strings to match.
          return 94;	 // "f21"
        case '2':	 // 3 strings to match.
          return 95;	 // "f22"
        case '3':	 // 3 strings to match.
          return 96;	 // "f23"
        case '4':	 // 3 strings to match.
          return 97;	 // "f24"
        case '5':	 // 3 strings to match.
          return 98;	 // "f25"
        case '6':	 // 3 strings to match.
          return 99;	 // "f26"
        case '7':	 // 3 strings to match.
          return 100;	 // "f27"
        case '8':	 // 3 strings to match.
          return 101;	 // "f28"
        case '9':	 // 3 strings to match.
          return 102;	 // "f29"
        }
        break;
      case '3':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 103;	 // "f30"
        case '1':	 // 3 strings to match.
          return 104;	 // "f31"
        }
        break;
      case 'r':	 // 1 string to match.
        if (Name[2] != 'm')
          break;
        return 2;	 // "frm"
      }
      break;
    case 'v':	 // 40 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 18 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 19;	 // "v10"
        case '1':	 // 1 string to match.
          return 20;	 // "v11"
        case '2':	 // 3 strings to match.
          return 21;	 // "v12"
        case '3':	 // 1 string to match.
          return 22;	 // "v13"
        case '4':	 // 2 strings to match.
          return 23;	 // "v14"
        case '5':	 // 1 string to match.
          return 24;	 // "v15"
        case '6':	 // 4 strings to match.
          return 25;	 // "v16"
        case '7':	 // 1 string to match.
          return 26;	 // "v17"
        case '8':	 // 2 strings to match.
          return 27;	 // "v18"
        case '9':	 // 1 string to match.
          return 28;	 // "v19"
        }
        break;
      case '2':	 // 19 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 29;	 // "v20"
        case '1':	 // 1 string to match.
          return 30;	 // "v21"
        case '2':	 // 2 strings to match.
          return 31;	 // "v22"
        case '3':	 // 1 string to match.
          return 32;	 // "v23"
        case '4':	 // 4 strings to match.
          return 33;	 // "v24"
        case '5':	 // 1 string to match.
          return 34;	 // "v25"
        case '6':	 // 2 strings to match.
          return 35;	 // "v26"
        case '7':	 // 1 string to match.
          return 36;	 // "v27"
        case '8':	 // 3 strings to match.
          return 37;	 // "v28"
        case '9':	 // 1 string to match.
          return 38;	 // "v29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 39;	 // "v30"
        case '1':	 // 1 string to match.
          return 40;	 // "v31"
        }
        break;
      }
      break;
    case 'x':	 // 33 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 51;	 // "x10"
        case '1':	 // 1 string to match.
          return 52;	 // "x11"
        case '2':	 // 2 strings to match.
          return 53;	 // "x12"
        case '3':	 // 1 string to match.
          return 54;	 // "x13"
        case '4':	 // 2 strings to match.
          return 55;	 // "x14"
        case '5':	 // 1 string to match.
          return 56;	 // "x15"
        case '6':	 // 2 strings to match.
          return 57;	 // "x16"
        case '7':	 // 1 string to match.
          return 58;	 // "x17"
        case '8':	 // 2 strings to match.
          return 59;	 // "x18"
        case '9':	 // 1 string to match.
          return 60;	 // "x19"
        }
        break;
      case '2':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 61;	 // "x20"
        case '1':	 // 1 string to match.
          return 62;	 // "x21"
        case '2':	 // 2 strings to match.
          return 63;	 // "x22"
        case '3':	 // 1 string to match.
          return 64;	 // "x23"
        case '4':	 // 2 strings to match.
          return 65;	 // "x24"
        case '5':	 // 1 string to match.
          return 66;	 // "x25"
        case '6':	 // 2 strings to match.
          return 67;	 // "x26"
        case '7':	 // 1 string to match.
          return 68;	 // "x27"
        case '8':	 // 2 strings to match.
          return 69;	 // "x28"
        case '9':	 // 1 string to match.
          return 70;	 // "x29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 71;	 // "x30"
        case '1':	 // 1 string to match.
          return 72;	 // "x31"
        }
        break;
      }
      break;
    }
    break;
  case 4:	 // 1 string to match.
    if (memcmp(Name.data()+0, "vxrm", 4) != 0)
      break;
    return 6;	 // "vxrm"
  case 5:	 // 3 strings to match.
    if (Name[0] != 'v')
      break;
    switch (Name[1]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+2, "enb", 3) != 0)
        break;
      return 4;	 // "vlenb"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+2, "ype", 3) != 0)
        break;
      return 5;	 // "vtype"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "sat", 3) != 0)
        break;
      return 7;	 // "vxsat"
    }
    break;
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fflags", 6) != 0)
      break;
    return 1;	 // "fflags"
  }
  return 0;
}

static unsigned MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 45 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 51;	 // "a0"
      case '1':	 // 1 string to match.
        return 52;	 // "a1"
      case '2':	 // 2 strings to match.
        return 53;	 // "a2"
      case '3':	 // 1 string to match.
        return 54;	 // "a3"
      case '4':	 // 2 strings to match.
        return 55;	 // "a4"
      case '5':	 // 1 string to match.
        return 56;	 // "a5"
      case '6':	 // 2 strings to match.
        return 57;	 // "a6"
      case '7':	 // 1 string to match.
        return 58;	 // "a7"
      }
      break;
    case 'f':	 // 2 strings to match.
      if (Name[1] != 'p')
        break;
      return 49;	 // "fp"
    case 'g':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 44;	 // "gp"
    case 'r':	 // 1 string to match.
      if (Name[1] != 'a')
        break;
      return 42;	 // "ra"
    case 's':	 // 17 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 49;	 // "s0"
      case '1':	 // 1 string to match.
        return 50;	 // "s1"
      case '2':	 // 2 strings to match.
        return 59;	 // "s2"
      case '3':	 // 1 string to match.
        return 60;	 // "s3"
      case '4':	 // 2 strings to match.
        return 61;	 // "s4"
      case '5':	 // 1 string to match.
        return 62;	 // "s5"
      case '6':	 // 2 strings to match.
        return 63;	 // "s6"
      case '7':	 // 1 string to match.
        return 64;	 // "s7"
      case '8':	 // 2 strings to match.
        return 65;	 // "s8"
      case '9':	 // 1 string to match.
        return 66;	 // "s9"
      case 'p':	 // 2 strings to match.
        return 43;	 // "sp"
      }
      break;
    case 't':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 46;	 // "t0"
      case '1':	 // 2 strings to match.
        return 47;	 // "t1"
      case '2':	 // 1 string to match.
        return 48;	 // "t2"
      case '3':	 // 2 strings to match.
        return 69;	 // "t3"
      case '4':	 // 1 string to match.
        return 70;	 // "t4"
      case '5':	 // 2 strings to match.
        return 71;	 // "t5"
      case '6':	 // 1 string to match.
        return 72;	 // "t6"
      case 'p':	 // 2 strings to match.
        return 45;	 // "tp"
      }
      break;
    }
    break;
  case 3:	 // 87 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 84 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 24 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 83;	 // "fa0"
        case '1':	 // 3 strings to match.
          return 84;	 // "fa1"
        case '2':	 // 3 strings to match.
          return 85;	 // "fa2"
        case '3':	 // 3 strings to match.
          return 86;	 // "fa3"
        case '4':	 // 3 strings to match.
          return 87;	 // "fa4"
        case '5':	 // 3 strings to match.
          return 88;	 // "fa5"
        case '6':	 // 3 strings to match.
          return 89;	 // "fa6"
        case '7':	 // 3 strings to match.
          return 90;	 // "fa7"
        }
        break;
      case 's':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 81;	 // "fs0"
        case '1':	 // 3 strings to match.
          return 82;	 // "fs1"
        case '2':	 // 3 strings to match.
          return 91;	 // "fs2"
        case '3':	 // 3 strings to match.
          return 92;	 // "fs3"
        case '4':	 // 3 strings to match.
          return 93;	 // "fs4"
        case '5':	 // 3 strings to match.
          return 94;	 // "fs5"
        case '6':	 // 3 strings to match.
          return 95;	 // "fs6"
        case '7':	 // 3 strings to match.
          return 96;	 // "fs7"
        case '8':	 // 3 strings to match.
          return 97;	 // "fs8"
        case '9':	 // 3 strings to match.
          return 98;	 // "fs9"
        }
        break;
      case 't':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 73;	 // "ft0"
        case '1':	 // 3 strings to match.
          return 74;	 // "ft1"
        case '2':	 // 3 strings to match.
          return 75;	 // "ft2"
        case '3':	 // 3 strings to match.
          return 76;	 // "ft3"
        case '4':	 // 3 strings to match.
          return 77;	 // "ft4"
        case '5':	 // 3 strings to match.
          return 78;	 // "ft5"
        case '6':	 // 3 strings to match.
          return 79;	 // "ft6"
        case '7':	 // 3 strings to match.
          return 80;	 // "ft7"
        case '8':	 // 3 strings to match.
          return 101;	 // "ft8"
        case '9':	 // 3 strings to match.
          return 102;	 // "ft9"
        }
        break;
      }
      break;
    case 's':	 // 3 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 67;	 // "s10"
      case '1':	 // 1 string to match.
        return 68;	 // "s11"
      }
      break;
    }
    break;
  case 4:	 // 14 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case 's':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 99;	 // "fs10"
        case '1':	 // 3 strings to match.
          return 100;	 // "fs11"
        }
        break;
      case 't':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 103;	 // "ft10"
        case '1':	 // 3 strings to match.
          return 104;	 // "ft11"
        }
        break;
      }
      break;
    case 'z':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ero", 3) != 0)
        break;
      return 41;	 // "zero"
    }
    break;
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasStdExtZicsrBit: return "'Zicsr' (CSRs)";
  case Feature_HasStdExtMBit: return "'M' (Integer Multiplication and Division)";
  case Feature_HasStdExtMOrZmmulBit: return "'M' (Integer Multiplication and Division) or 'Zmmul' (Integer Multiplication)";
  case Feature_HasStdExtABit: return "'A' (Atomic Instructions)";
  case Feature_HasStdExtFBit: return "'F' (Single-Precision Floating-Point)";
  case Feature_HasStdExtDBit: return "'D' (Double-Precision Floating-Point)";
  case Feature_HasStdExtHBit: return "'H' (Hypervisor)";
  case Feature_HasStdExtZihintpauseBit: return "'Zihintpause' (Pause Hint)";
  case Feature_HasStdExtZihintntlBit: return "'Zihintntl' (Non-Temporal Locality Hints)";
  case Feature_HasStdExtZifenceiBit: return "'Zifencei' (fence.i)";
  case Feature_HasStdExtZfhminBit: return "'Zfhmin' (Half-Precision Floating-Point Minimal)";
  case Feature_HasStdExtZfhBit: return "'Zfh' (Half-Precision Floating-Point)";
  case Feature_HasStdExtZfhOrZfhminBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal)";
  case Feature_HasStdExtZfinxBit: return "'Zfinx' (Float in Integer)";
  case Feature_HasStdExtZdinxBit: return "'Zdinx' (Double in Integer)";
  case Feature_HasStdExtZhinxminBit: return "'Zhinxmin' (Half Float in Integer Minimal)";
  case Feature_HasStdExtZhinxBit: return "'Zhinx' (Half Float in Integer)";
  case Feature_HasStdExtZhinxOrZhinxminBit: return "'Zhinx' (Half Float in Integer) or 'Zhinxmin' (Half Float in Integer Minimal)";
  case Feature_HasStdExtZfaBit: return "'Zfa' (Additional Floating-Point)";
  case Feature_HasStdExtCBit: return "'C' (Compressed Instructions)";
  case Feature_HasStdExtZbaBit: return "'Zba' (Address Generation Instructions)";
  case Feature_HasStdExtZbbBit: return "'Zbb' (Basic Bit-Manipulation)";
  case Feature_HasStdExtZbcBit: return "'Zbc' (Carry-Less Multiplication)";
  case Feature_HasStdExtZbsBit: return "'Zbs' (Single-Bit Instructions)";
  case Feature_HasStdExtZbkbBit: return "'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkxBit: return "'Zbkx' (Crossbar permutation instructions)";
  case Feature_HasStdExtZbbOrZbkbBit: return "'Zbb' (Basic Bit-Manipulation) or 'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkcBit: return "'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZbcOrZbkcBit: return "'Zbc' (Carry-Less Multiplication) or 'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZkndBit: return "'Zknd' (NIST Suite: AES Decryption)";
  case Feature_HasStdExtZkneBit: return "'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZkndOrZkneBit: return "'Zknd' (NIST Suite: AES Decryption) or 'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZknhBit: return "'Zknh' (NIST Suite: Hash Function Instructions)";
  case Feature_HasStdExtZksedBit: return "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZkshBit: return "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)";
  case Feature_HasStdExtZkrBit: return "'Zkr' (Entropy Source Extension)";
  case Feature_HasStdExtCOrZcaBit: return "'C' (Compressed Instructions) or 'Zca' (part of the C extension, excluding compressed floating point loads/stores)";
  case Feature_HasStdExtZcbBit: return "'Zcb' (Compressed basic bit manipulation instructions)";
  case Feature_HasStdExtCOrZcdBit: return "'C' (Compressed Instructions) or 'Zcd' (Compressed Double-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmpBit: return "'Zcmp' (sequenced instuctions for code-size reduction)";
  case Feature_HasStdExtZcmtBit: return "'Zcmt' (table jump instuctions for code-size reduction)";
  case Feature_HasStdExtCOrZcfOrZceBit: return "'C' (Compressed Instructions) or 'Zcf' (Compressed Single-Precision Floating-Point Instructions)";
  case Feature_HasRVCHintsBit: return "RVC Hint Instructions";
  case Feature_HasVInstructionsBit: return "'V' (Vector Extension for Application Processors), 'Zve32x' or 'Zve64x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsI64Bit: return "'V' (Vector Extension for Application Processors) or 'Zve64x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsAnyFBit: return "'V' (Vector Extension for Application Processors), 'Zve32f', 'Zve64f' or 'Zve64d' (Vector Extensions for Embedded Processors)";
  case Feature_HasStdExtZvfbfminBit: return "'Zvfbfmin' (Vector BF16 Converts)";
  case Feature_HasStdExtZvfbfwmaBit: return "'Zvfbfwma' (Vector BF16 widening mul-add)";
  case Feature_HasStdExtZfhOrZvfhBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtZicbomBit: return "'Zicbom' (Cache-Block Management Instructions)";
  case Feature_HasStdExtZicbozBit: return "'Zicboz' (Cache-Block Zero Instructions)";
  case Feature_HasStdExtZicbopBit: return "'Zicbop' (Cache-Block Prefetch Instructions)";
  case Feature_HasStdExtSvinvalBit: return "'Svinval' (Fine-Grained Address-Translation Cache Invalidation)";
  case Feature_HasStdExtZtsoBit: return "'Ztso' (Memory Model - Total Store Order)";
  case Feature_HasStdExtZawrsBit: return "'Zawrs' (Wait on Reservation Set)";
  case Feature_HasStdExtZvbbBit: return "'Zvbb' (Vector Bit-manipulation used in Cryptography)";
  case Feature_HasStdExtZvbcBit: return "'Zvbc' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvkgBit: return "'Zvkg' (Vector GCM instructions for Cryptography)";
  case Feature_HasStdExtZvknedBit: return "'Zvkned' (Vector AES Encryption & Decryption (Single Round))";
  case Feature_HasStdExtZvknhaBit: return "'Zvknha' (Vector SHA-2 (SHA-256 only))";
  case Feature_HasStdExtZvksedBit: return "'Zvksed' (SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZvkshBit: return "'Zvksh' (SM3 Hash Function Instructions)";
  case Feature_HasStdExtZicondBit: return "'Zicond' (Integer Conditional Operations)";
  case Feature_HasStdExtZfbfminBit: return "'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasHalfFPLoadStoreMoveBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal) or 'Zfbfmin' (Scalar BF16 Converts) or 'Zvfbfwma' (Vector BF16 widening mul-add)";
  case Feature_HasStdExtZacasBit: return "'Zacas' (Atomic Compare-And-Swap Instructions)";
  case Feature_HasVendorXVentanaCondOpsBit: return "'XVentanaCondOps' (Ventana Conditional Ops)";
  case Feature_HasVendorXTHeadBaBit: return "'xtheadba' (T-Head address calculation instructions)";
  case Feature_HasVendorXTHeadBbBit: return "'xtheadbb' (T-Head basic bit-manipulation instructions)";
  case Feature_HasVendorXTHeadBsBit: return "'xtheadbs' (T-Head single-bit instructions)";
  case Feature_HasVendorXTHeadCondMovBit: return "'xtheadcondmov' (T-Head conditional move instructions)";
  case Feature_HasVendorXTHeadCmoBit: return "'xtheadcmo' (T-Head cache management instructions)";
  case Feature_HasVendorXTHeadFMemIdxBit: return "'xtheadfmemidx' (T-Head FP Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMacBit: return "'xtheadmac' (T-Head Multiply-Accumulate Instructions)";
  case Feature_HasVendorXTHeadMemIdxBit: return "'xtheadmemidx' (T-Head Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMemPairBit: return "'xtheadmempair' (T-Head two-GPR Memory Operations)";
  case Feature_HasVendorXTHeadSyncBit: return "'xtheadsync' (T-Head multicore synchronization instructions)";
  case Feature_HasVendorXTHeadVdotBit: return "'xtheadvdot' (T-Head Vector Extensions for Dot)";
  case Feature_HasVendorXSfvcpBit: return "'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)";
  case Feature_HasVendorXSfcieBit: return "'XSfcie' (SiFive Custom Instruction Extension SCIE.)";
  case Feature_HasVendorXCVbitmanipBit: return "'XCVbitmanip' (CORE-V Bit Manipulation)";
  case Feature_HasVendorXCVmacBit: return "'XCVmac' (CORE-V Multiply-Accumulate)";
  case Feature_IsRV64Bit: return "RV64I Base Instruction Set";
  case Feature_IsRV32Bit: return "RV32I Base Instruction Set";
  case Feature_IsRVEBit: return "";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "move", 4) != 0)
          break;
        Mnemonic = "mv";	 // "move"
        return;
      case 5:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
          break;
        Mnemonic = "ecall";	 // "scall"
        return;
      case 6:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "sbreak", 6) != 0)
          break;
        Mnemonic = "ebreak";	 // "sbreak"
        return;
      case 7:	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+0, "fmv.", 4) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
            break;
          if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
            Mnemonic = "fmv.w.x";
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
            break;
          if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
            Mnemonic = "fmv.x.w";
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 4:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "move", 4) != 0)
      break;
    Mnemonic = "mv";	 // "move"
    return;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
      break;
    Mnemonic = "ecall";	 // "scall"
    return;
  case 6:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "sbreak", 6) != 0)
      break;
    Mnemonic = "ebreak";	 // "sbreak"
    return;
  case 7:	 // 2 strings to match.
    if (memcmp(Mnemonic.data()+0, "fmv.", 4) != 0)
      break;
    switch (Mnemonic[4]) {
    default: break;
    case 's':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
        break;
      if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
        Mnemonic = "fmv.w.x";
      return;
    case 'x':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
        break;
      if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
        Mnemonic = "fmv.x.w";
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie1_3_3,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie1_3_3 */ { 1, 3, 3 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addImmOperands,
  CVT_95_addRegOperands,
  CVT_95_Reg,
  CVT_regX0,
  CVT_imm_95_0,
  CVT_regX5,
  CVT_regX2,
  CVT_regX3,
  CVT_regX4,
  CVT_95_addRlistOperands,
  CVT_95_addSpimmOperands,
  CVT_95_addCSRSystemRegisterOperands,
  CVT_95_addFRMArgOperands_95_defaultFRMArgOp,
  CVT_95_addFRMArgOperands,
  CVT_imm_95_15,
  CVT_95_addFenceArgOperands,
  CVT_95_addFPImmOperands,
  CVT_imm_95_3,
  CVT_imm_95_1,
  CVT_imm_95_2,
  CVT_regX1,
  CVT_imm_95__MINUS_1,
  CVT_imm_95_3072,
  CVT_imm_95_3200,
  CVT_imm_95_3074,
  CVT_imm_95_3202,
  CVT_imm_95_3073,
  CVT_imm_95_3201,
  CVT_95_addRegOperands_95_defaultMaskRegOp,
  CVT_reg0,
  CVT_95_addVTypeIOperands,
  CVT_imm_95_255,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4,
  Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__SImm121_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__RnumArg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__Reg1_0__UImm20AUIPC1_1,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2,
  Convert__Reg1_0__Reg1_1__SImm13Lsb01_2,
  Convert__Reg1_0__regX0__SImm13Lsb01_1,
  Convert__Reg1_1__Reg1_0__SImm13Lsb01_2,
  Convert__regX0__Reg1_0__SImm13Lsb01_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ImmZero1_1,
  Convert__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1,
  Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2,
  Convert__Reg1_0__Tie0_1_1__SImm61_1,
  Convert__Reg1_0__SImm9Lsb01_1,
  Convert_NoOperands,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm7Lsb001_1,
  Convert__Reg1_0__Reg1_3__UImm8Lsb001_1,
  Convert__SImm12Lsb01_0,
  Convert__Reg1_0,
  Convert__Reg1_0__Reg1_3__UImm21_1,
  Convert__Reg1_0__Reg1_3__UImm2Lsb01_1,
  Convert__Reg1_0__SImm61_1,
  Convert__Reg1_0__CLUIImm1_1,
  Convert__SImm6NonZero1_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__regX0__Tie0_1_1__regX5,
  Convert__regX0__Tie0_1_1__regX2,
  Convert__regX0__Tie0_1_1__regX3,
  Convert__regX0__Tie0_1_1__regX4,
  Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1,
  Convert__CallSymbol1_0,
  Convert__Reg1_0__CallSymbol1_1,
  Convert__ZeroOffsetMemOpOperand1_0,
  Convert__regX0,
  Convert__UImm8GE321_0,
  Convert__UImm51_0,
  Convert__Rlist1_0__Spimm1_1,
  Convert__regX0__CSRSystemRegister1_0__Reg1_1,
  Convert__regX0__CSRSystemRegister1_0__UImm51_1,
  Convert__Reg1_0__CSRSystemRegister1_1__regX0,
  Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2,
  Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2,
  Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3,
  Convert__imm_95_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1,
  Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_1,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3,
  Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3,
  Convert__Reg1_0__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPF64AsFPR1_1,
  Convert__Reg1_0__GPRAsFPR1_1,
  Convert__Reg1_0__Reg1_1__FRMArg1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR1_1,
  Convert__GPRPF64AsFPR1_0__GPRAsFPR1_1,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1,
  Convert__GPRPF64AsFPR1_0__Reg1_1,
  Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1,
  Convert__Reg1_0__GPRPF64AsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__RTZArg1_2,
  Convert__imm_95_15__imm_95_15,
  Convert__FenceArg1_0__FenceArg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__Reg1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2,
  Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2,
  Convert__Reg1_0__Reg1_2__Reg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPF64AsFPR1_2__GPRPF64AsFPR1_1,
  Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1,
  Convert__Reg1_2__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__Reg1_3__SImm121_1,
  Convert__Reg1_0__LoadFPImm1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4,
  Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2,
  Convert__Reg1_0__imm_95_3__regX0,
  Convert__Reg1_0__imm_95_1__regX0,
  Convert__Reg1_0__imm_95_2__regX0,
  Convert__regX0__imm_95_3__Reg1_0,
  Convert__Reg1_0__imm_95_3__Reg1_1,
  Convert__regX0__imm_95_1__Reg1_0,
  Convert__Reg1_0__imm_95_1__Reg1_1,
  Convert__regX0__imm_95_1__UImm51_0,
  Convert__Reg1_0__imm_95_1__UImm51_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2,
  Convert__regX0__imm_95_2__Reg1_0,
  Convert__Reg1_0__imm_95_2__Reg1_1,
  Convert__regX0__imm_95_2__UImm51_0,
  Convert__Reg1_0__imm_95_2__UImm51_1,
  Convert__regX0__regX0,
  Convert__Reg1_0__regX0,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1,
  Convert__regX0__SImm21Lsb0JAL1_0,
  Convert__regX1__SImm21Lsb0JAL1_0,
  Convert__Reg1_0__SImm21Lsb0JAL1_1,
  Convert__regX1__Reg1_0__imm_95_0,
  Convert__regX1__Reg1_0__SImm121_1,
  Convert__regX1__Reg1_2__SImm121_0,
  Convert__regX0__Reg1_0__imm_95_0,
  Convert__regX0__Reg1_0__SImm121_1,
  Convert__regX0__Reg1_2__SImm121_0,
  Convert__Reg1_1__PseudoJumpSymbol1_0,
  Convert__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__ImmXLenLI_Restricted1_1,
  Convert__Reg1_0__regX0__SImm121_1,
  Convert__Reg1_0__ImmXLenLI1_1,
  Convert__Reg1_0__UImm20LUI1_1,
  Convert__Reg1_0__regX0__Reg1_1,
  Convert__regX0__regX0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1,
  Convert__regX0__regX0__regX5,
  Convert__regX0__regX0__regX2,
  Convert__regX0__regX0__regX3,
  Convert__regX0__regX0__regX4,
  Convert__imm_95_1__imm_95_0,
  Convert__Reg1_2__SImm12Lsb000001_0,
  Convert__Reg1_0__imm_95_3072__regX0,
  Convert__Reg1_0__imm_95_3200__regX0,
  Convert__Reg1_0__imm_95_3074__regX0,
  Convert__Reg1_0__imm_95_3202__regX0,
  Convert__Reg1_0__imm_95_3073__regX0,
  Convert__Reg1_0__imm_95_3201__regX0,
  Convert__regX0__regX1__imm_95_0,
  Convert__Reg1_0__Reg1_1__UImm51_2,
  Convert__Reg1_0__Reg1_1__imm_95_1,
  Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__regX0,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__Reg1_1__reg0,
  Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__RVVMaskRegOpOperand1_1,
  Convert__Reg1_0__Reg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2,
  Convert__Reg1_0__Reg1_0__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__SImm51_1,
  Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0__reg0,
  Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__UImm51_1__VTypeI101_2,
  Convert__Reg1_0__Reg1_1__VTypeI111_2,
  Convert__Reg1_0__Reg1_1__imm_95_255,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][15] = {
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_95_addRegOperands, 7, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RnumArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__UImm20AUIPC1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__regX0__SImm13Lsb01_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__SImm13Lsb01_2
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__regX0__Reg1_0__SImm13Lsb01_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm61_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm9Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm7Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm12Lsb01_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm21_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm2Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm61_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CLUIImm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX5
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX2
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX3
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX4
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__CallSymbol1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__CallSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__regX0
  { CVT_regX0, 0, CVT_Done },
  // Convert__UImm8GE321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__UImm51_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Rlist1_0__Spimm1_1
  { CVT_95_addRlistOperands, 1, CVT_95_addSpimmOperands, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__Reg1_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__UImm51_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__regX0
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__imm_95_0__imm_95_0
  { CVT_imm_95_0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__Reg1_1
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPF64AsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RTZArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands, 3, CVT_Done },
  // Convert__imm_95_15__imm_95_15
  { CVT_imm_95_15, 0, CVT_imm_95_15, 0, CVT_Done },
  // Convert__FenceArg1_0__FenceArg1_1
  { CVT_95_addFenceArgOperands, 1, CVT_95_addFenceArgOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPF64AsFPR1_2__GPRPF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__LoadFPImm1_1
  { CVT_95_Reg, 1, CVT_95_addFPImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__imm_95_3__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1__regX0
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2__regX0
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__imm_95_3__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__regX0__imm_95_2__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_2__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__regX0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__regX0
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__regX0__SImm21Lsb0JAL1_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regX1__SImm21Lsb0JAL1_0
  { CVT_regX1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__SImm21Lsb0JAL1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_0__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_0__SImm121_1
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_2__SImm121_0
  { CVT_regX1, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regX0__Reg1_0__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_0__SImm121_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__Reg1_2__SImm121_0
  { CVT_regX0, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__PseudoJumpSymbol1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI_Restricted1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__SImm121_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImm20LUI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__Reg1_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__regX0__imm_95_0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_Done },
  // Convert__regX0__regX0__regX5
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__regX0__regX2
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__regX0__regX3
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__regX0__regX4
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX4, 0, CVT_Done },
  // Convert__imm_95_1__imm_95_0
  { CVT_imm_95_1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__SImm12Lsb000001_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3072__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3072, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3200__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3200, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3074__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3074, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3202__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3202, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3073__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3073, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3201__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3201, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__regX1__imm_95_0
  { CVT_regX0, 0, CVT_regX1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__RVVMaskRegOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands_95_defaultMaskRegOp, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Reg1_0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__UImm51_1__VTypeI101_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__VTypeI111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_255
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_255, 0, CVT_Done },
};

void RISCVAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands,
                const SmallBitVector &OptionalOperandsMask) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned DefaultsOffset[8] = { 0 };
  assert(OptionalOperandsMask.size() == 7);
  for (unsigned i = 0, NumDefaults = 0; i < 7; ++i) {
    DefaultsOffset[i + 1] = NumDefaults;
    NumDefaults += (OptionalOperandsMask[i] ? 1 : 0);
  }
  unsigned OpIdx;
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    OpIdx = *(p + 1) - DefaultsOffset[*(p + 1)];
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[OpIdx][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regX0:
      Inst.addOperand(MCOperand::createReg(RISCV::X0));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_regX5:
      Inst.addOperand(MCOperand::createReg(RISCV::X5));
      break;
    case CVT_regX2:
      Inst.addOperand(MCOperand::createReg(RISCV::X2));
      break;
    case CVT_regX3:
      Inst.addOperand(MCOperand::createReg(RISCV::X3));
      break;
    case CVT_regX4:
      Inst.addOperand(MCOperand::createReg(RISCV::X4));
      break;
    case CVT_95_addRlistOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRlistOperands(Inst, 1);
      break;
    case CVT_95_addSpimmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addSpimmOperands(Inst, 1);
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addCSRSystemRegisterOperands(Inst, 1);
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addFenceArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFenceArgOperands(Inst, 1);
      break;
    case CVT_95_addFPImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_regX1:
      Inst.addOperand(MCOperand::createReg(RISCV::X1));
      break;
    case CVT_imm_95__MINUS_1:
      Inst.addOperand(MCOperand::createImm(-1));
      break;
    case CVT_imm_95_3072:
      Inst.addOperand(MCOperand::createImm(3072));
      break;
    case CVT_imm_95_3200:
      Inst.addOperand(MCOperand::createImm(3200));
      break;
    case CVT_imm_95_3074:
      Inst.addOperand(MCOperand::createImm(3074));
      break;
    case CVT_imm_95_3202:
      Inst.addOperand(MCOperand::createImm(3202));
      break;
    case CVT_imm_95_3073:
      Inst.addOperand(MCOperand::createImm(3073));
      break;
    case CVT_imm_95_3201:
      Inst.addOperand(MCOperand::createImm(3201));
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultMaskRegOp()->addRegOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      }
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_95_addVTypeIOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addVTypeIOperands(Inst, 1);
      break;
    case CVT_imm_95_255:
      Inst.addOperand(MCOperand::createImm(255));
      break;
    }
  }
}

void RISCVAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regX0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addRlistOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSpimmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFenceArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95__MINUS_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3072:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3200:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3074:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3202:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3073:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3201:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addVTypeIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_255:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__40_, // '('
  MCK__41_, // ')'
  MCK_LAST_TOKEN = MCK__41_,
  MCK_Reg76, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg70, // derived register class
  MCK_Reg67, // derived register class
  MCK_Reg64, // derived register class
  MCK_Reg61, // derived register class
  MCK_Reg58, // derived register class
  MCK_Reg55, // derived register class
  MCK_Reg52, // derived register class
  MCK_Reg49, // derived register class
  MCK_Reg46, // derived register class
  MCK_Reg39, // derived register class
  MCK_Reg34, // derived register class
  MCK_Reg32, // derived register class
  MCK_Reg28, // derived register class
  MCK_Reg25, // derived register class
  MCK_Reg22, // derived register class
  MCK_GPRX0, // register class 'GPRX0,X0'
  MCK_SP, // register class 'SP'
  MCK_VMV0, // register class 'VMV0,V0'
  MCK_Reg9, // derived register class
  MCK_Reg43, // derived register class
  MCK_VCSR, // register class 'VCSR'
  MCK_VRM8NoV0, // register class 'VRM8NoV0'
  MCK_Reg41, // derived register class
  MCK_Reg40, // derived register class
  MCK_VRM8, // register class 'VRM8'
  MCK_Reg42, // derived register class
  MCK_Reg13, // derived register class
  MCK_VRN2M4NoV0, // register class 'VRN2M4NoV0'
  MCK_Reg38, // derived register class
  MCK_VRM4NoV0, // register class 'VRM4NoV0'
  MCK_VRN2M4, // register class 'VRN2M4'
  MCK_FPR32C, // register class 'FPR32C'
  MCK_FPR64C, // register class 'FPR64C'
  MCK_GPRC, // register class 'GPRC'
  MCK_SR07, // register class 'SR07'
  MCK_VRM4, // register class 'VRM4'
  MCK_Reg12, // derived register class
  MCK_VRN4M2NoV0, // register class 'VRN4M2NoV0'
  MCK_Reg37, // derived register class
  MCK_PGPR, // register class 'PGPR'
  MCK_VRN3M2NoV0, // register class 'VRN3M2NoV0'
  MCK_VRN4M2, // register class 'VRN4M2'
  MCK_Reg36, // derived register class
  MCK_GPRTC, // register class 'GPRTC'
  MCK_VRN2M2NoV0, // register class 'VRN2M2NoV0'
  MCK_VRN3M2, // register class 'VRN3M2'
  MCK_Reg35, // derived register class
  MCK_VRM2NoV0, // register class 'VRM2NoV0'
  MCK_VRN2M2, // register class 'VRN2M2'
  MCK_GPRPF64, // register class 'GPRPF64'
  MCK_VRM2, // register class 'VRM2'
  MCK_VRN8M1NoV0, // register class 'VRN8M1NoV0'
  MCK_VRN7M1NoV0, // register class 'VRN7M1NoV0'
  MCK_VRN8M1, // register class 'VRN8M1'
  MCK_GPRJALR, // register class 'GPRJALR'
  MCK_VRN6M1NoV0, // register class 'VRN6M1NoV0'
  MCK_VRN7M1, // register class 'VRN7M1'
  MCK_VRN5M1NoV0, // register class 'VRN5M1NoV0'
  MCK_VRN6M1, // register class 'VRN6M1'
  MCK_VRN4M1NoV0, // register class 'VRN4M1NoV0'
  MCK_VRN5M1, // register class 'VRN5M1'
  MCK_VRN3M1NoV0, // register class 'VRN3M1NoV0'
  MCK_VRN4M1, // register class 'VRN4M1'
  MCK_GPRNoX0X2, // register class 'GPRNoX0X2'
  MCK_VRN2M1NoV0, // register class 'VRN2M1NoV0'
  MCK_VRN3M1, // register class 'VRN3M1'
  MCK_GPRNoX0, // register class 'GPRNoX0'
  MCK_VRN2M1, // register class 'VRN2M1'
  MCK_VRNoV0, // register class 'VRNoV0'
  MCK_FPR16, // register class 'FPR16'
  MCK_FPR32, // register class 'FPR32'
  MCK_FPR64, // register class 'FPR64'
  MCK_GPR, // register class 'GPR,GPRF16,GPRF32'
  MCK_VM, // register class 'VM,VR'
  MCK_GPRAll, // register class 'GPRAll'
  MCK_LAST_REGISTER = MCK_GPRAll,
  MCK_AnyRegCOperand, // user defined class 'AnyRegCOperand'
  MCK_AnyRegOperand, // user defined class 'AnyRegOperand'
  MCK_BareSymbol, // user defined class 'BareSymbol'
  MCK_CLUIImm, // user defined class 'CLUIImmAsmOperand'
  MCK_CSRSystemRegister, // user defined class 'CSRSystemRegister'
  MCK_CallSymbol, // user defined class 'CallSymbol'
  MCK_FRMArg, // user defined class 'FRMArg'
  MCK_FenceArg, // user defined class 'FenceArg'
  MCK_GPRAsFPR, // user defined class 'GPRAsFPR'
  MCK_GPRF64AsFPR, // user defined class 'GPRF64AsFPR'
  MCK_GPRPF64AsFPR, // user defined class 'GPRPF64AsFPR'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmZero, // user defined class 'ImmZeroAsmOperand'
  MCK_InsnCDirectiveOpcode, // user defined class 'InsnCDirectiveOpcode'
  MCK_InsnDirectiveOpcode, // user defined class 'InsnDirectiveOpcode'
  MCK_LoadFPImm, // user defined class 'LoadFPImmOperand'
  MCK_PseudoJumpSymbol, // user defined class 'PseudoJumpSymbol'
  MCK_RTZArg, // user defined class 'RTZArg'
  MCK_Rlist, // user defined class 'RlistAsmOperand'
  MCK_RnumArg, // user defined class 'RnumArg'
  MCK_RnumArg_0_7, // user defined class 'RnumArg_0_7'
  MCK_RnumArg_1_10, // user defined class 'RnumArg_1_10'
  MCK_RnumArg_2_14, // user defined class 'RnumArg_2_14'
  MCK_SImm5Plus1, // user defined class 'SImm5Plus1AsmOperand'
  MCK_SImm21Lsb0JAL, // user defined class 'Simm21Lsb0JALAsmOperand'
  MCK_Spimm, // user defined class 'SpimmAsmOperand'
  MCK_TPRelAddSymbol, // user defined class 'TPRelAddSymbol'
  MCK_UImmLog2XLen, // user defined class 'UImmLog2XLenAsmOperand'
  MCK_UImmLog2XLenHalf, // user defined class 'UImmLog2XLenHalfAsmOperand'
  MCK_UImmLog2XLenNonZero, // user defined class 'UImmLog2XLenNonZeroAsmOperand'
  MCK_RVVMaskRegOpOperand, // user defined class 'VMaskAsmOperand'
  MCK_ZeroOffsetMemOpOperand, // user defined class 'ZeroOffsetMemOpOperand'
  MCK_SImm12Lsb00000, // user defined class 'anonymous_44824'
  MCK_SImm6, // user defined class 'anonymous_44830'
  MCK_SImm6NonZero, // user defined class 'anonymous_44831'
  MCK_UImm7Lsb00, // user defined class 'anonymous_44832'
  MCK_UImm8Lsb00, // user defined class 'anonymous_44833'
  MCK_UImm8Lsb000, // user defined class 'anonymous_44834'
  MCK_SImm9Lsb0, // user defined class 'anonymous_44835'
  MCK_UImm9Lsb000, // user defined class 'anonymous_44836'
  MCK_UImm10Lsb00NonZero, // user defined class 'anonymous_44837'
  MCK_SImm10Lsb0000NonZero, // user defined class 'anonymous_44838'
  MCK_SImm12Lsb0, // user defined class 'anonymous_44839'
  MCK_UImm2Lsb0, // user defined class 'anonymous_44921'
  MCK_UImm8GE32, // user defined class 'anonymous_44922'
  MCK_UImm1, // user defined class 'anonymous_7736'
  MCK_UImm2, // user defined class 'anonymous_7737'
  MCK_UImm3, // user defined class 'anonymous_7738'
  MCK_UImm4, // user defined class 'anonymous_7739'
  MCK_UImm5, // user defined class 'anonymous_7740'
  MCK_UImm6, // user defined class 'anonymous_7741'
  MCK_UImm7, // user defined class 'anonymous_7742'
  MCK_UImm8, // user defined class 'anonymous_7743'
  MCK_SImm12, // user defined class 'anonymous_7744'
  MCK_SImm13Lsb0, // user defined class 'anonymous_7745'
  MCK_UImm20LUI, // user defined class 'anonymous_7746'
  MCK_UImm20AUIPC, // user defined class 'anonymous_7747'
  MCK_ImmXLenLI, // user defined class 'anonymous_7748'
  MCK_ImmXLenLI_Restricted, // user defined class 'anonymous_7749'
  MCK_VTypeI10, // user defined class 'anonymous_8846'
  MCK_VTypeI11, // user defined class 'anonymous_8847'
  MCK_SImm5, // user defined class 'anonymous_8848'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case '(':	 // 1 string to match.
      return MCK__40_;	 // "("
    case ')':	 // 1 string to match.
      return MCK__41_;	 // ")"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_Reg76:
    return B == MCK_VRN8M1;

  case MCK_Reg73:
    return B == MCK_VRN7M1;

  case MCK_Reg70:
    return B == MCK_VRN6M1;

  case MCK_Reg67:
    return B == MCK_VRN5M1;

  case MCK_Reg64:
    return B == MCK_VRN4M2;

  case MCK_Reg61:
    return B == MCK_VRN4M1;

  case MCK_Reg58:
    return B == MCK_VRN3M2;

  case MCK_Reg55:
    return B == MCK_VRN3M1;

  case MCK_Reg52:
    return B == MCK_VRN2M4;

  case MCK_Reg49:
    return B == MCK_VRN2M2;

  case MCK_Reg46:
    return B == MCK_VRN2M1;

  case MCK_Reg39:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_Reg40: return true;
    case MCK_Reg42: return true;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_Reg34:
    switch (B) {
    default: return false;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_Reg32:
    return B == MCK_GPRPF64;

  case MCK_Reg28:
    return B == MCK_VRM8;

  case MCK_Reg25:
    return B == MCK_VRM4;

  case MCK_Reg22:
    return B == MCK_VRM2;

  case MCK_GPRX0:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_SP:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VMV0:
    return B == MCK_VM;

  case MCK_Reg9:
    switch (B) {
    default: return false;
    case MCK_GPRC: return true;
    case MCK_SR07: return true;
    case MCK_Reg12: return true;
    case MCK_PGPR: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_Reg43:
    switch (B) {
    default: return false;
    case MCK_Reg40: return true;
    case MCK_Reg38: return true;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_VRM8NoV0:
    return B == MCK_VRM8;

  case MCK_Reg41:
    switch (B) {
    default: return false;
    case MCK_Reg42: return true;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_Reg40:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_Reg42:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_Reg13:
    switch (B) {
    default: return false;
    case MCK_GPRC: return true;
    case MCK_GPRTC: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M4NoV0:
    return B == MCK_VRN2M4;

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_VRM4NoV0:
    return B == MCK_VRM4;

  case MCK_FPR32C:
    return B == MCK_FPR32;

  case MCK_FPR64C:
    return B == MCK_FPR64;

  case MCK_GPRC:
    switch (B) {
    default: return false;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_SR07:
    switch (B) {
    default: return false;
    case MCK_Reg12: return true;
    case MCK_PGPR: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_Reg12:
    switch (B) {
    default: return false;
    case MCK_PGPR: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN4M2NoV0:
    return B == MCK_VRN4M2;

  case MCK_Reg37:
    switch (B) {
    default: return false;
    case MCK_Reg36: return true;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_PGPR:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN3M2NoV0:
    return B == MCK_VRN3M2;

  case MCK_Reg36:
    switch (B) {
    default: return false;
    case MCK_Reg35: return true;
    case MCK_GPRPF64: return true;
    }

  case MCK_GPRTC:
    switch (B) {
    default: return false;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M2NoV0:
    return B == MCK_VRN2M2;

  case MCK_Reg35:
    return B == MCK_GPRPF64;

  case MCK_VRM2NoV0:
    return B == MCK_VRM2;

  case MCK_VRN8M1NoV0:
    return B == MCK_VRN8M1;

  case MCK_VRN7M1NoV0:
    return B == MCK_VRN7M1;

  case MCK_GPRJALR:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN6M1NoV0:
    return B == MCK_VRN6M1;

  case MCK_VRN5M1NoV0:
    return B == MCK_VRN5M1;

  case MCK_VRN4M1NoV0:
    return B == MCK_VRN4M1;

  case MCK_VRN3M1NoV0:
    return B == MCK_VRN3M1;

  case MCK_GPRNoX0X2:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M1NoV0:
    return B == MCK_VRN2M1;

  case MCK_GPRNoX0:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRNoV0:
    return B == MCK_VM;

  case MCK_GPR:
    return B == MCK_GPRAll;

  case MCK_FRMArg:
    return B == OptionalMatchClass;

  case MCK_RVVMaskRegOpOperand:
    return B == OptionalMatchClass;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  RISCVOperand &Operand = (RISCVOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AnyRegCOperand' class
  case MCK_AnyRegCOperand: {
    DiagnosticPredicate DP(Operand.isAnyRegC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AnyRegOperand' class
  case MCK_AnyRegOperand: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'BareSymbol' class
  case MCK_BareSymbol: {
    DiagnosticPredicate DP(Operand.isBareSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSymbol;
    break;
    }
  // 'CLUIImm' class
  case MCK_CLUIImm: {
    DiagnosticPredicate DP(Operand.isCLUIImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCLUIImm;
    break;
    }
  // 'CSRSystemRegister' class
  case MCK_CSRSystemRegister: {
    DiagnosticPredicate DP(Operand.isCSRSystemRegister());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCSRSystemRegister;
    break;
    }
  // 'CallSymbol' class
  case MCK_CallSymbol: {
    DiagnosticPredicate DP(Operand.isCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCallSymbol;
    break;
    }
  // 'FRMArg' class
  case MCK_FRMArg: {
    DiagnosticPredicate DP(Operand.isFRMArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FenceArg' class
  case MCK_FenceArg: {
    DiagnosticPredicate DP(Operand.isFenceArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRAsFPR' class
  case MCK_GPRAsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRF64AsFPR' class
  case MCK_GPRF64AsFPR: {
    DiagnosticPredicate DP(Operand.isGPRF64AsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRPF64AsFPR' class
  case MCK_GPRPF64AsFPR: {
    DiagnosticPredicate DP(Operand.isGPRPF64AsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmZero' class
  case MCK_ImmZero: {
    DiagnosticPredicate DP(Operand.isImmZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmZero;
    break;
    }
  // 'InsnCDirectiveOpcode' class
  case MCK_InsnCDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'InsnDirectiveOpcode' class
  case MCK_InsnDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'LoadFPImm' class
  case MCK_LoadFPImm: {
    DiagnosticPredicate DP(Operand.isLoadFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidLoadFPImm;
    break;
    }
  // 'PseudoJumpSymbol' class
  case MCK_PseudoJumpSymbol: {
    DiagnosticPredicate DP(Operand.isPseudoJumpSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidPseudoJumpSymbol;
    break;
    }
  // 'RTZArg' class
  case MCK_RTZArg: {
    DiagnosticPredicate DP(Operand.isRTZArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRTZArg;
    break;
    }
  // 'Rlist' class
  case MCK_Rlist: {
    DiagnosticPredicate DP(Operand.isRlist());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRlist;
    break;
    }
  // 'RnumArg' class
  case MCK_RnumArg: {
    DiagnosticPredicate DP(Operand.isRnumArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg;
    break;
    }
  // 'RnumArg_0_7' class
  case MCK_RnumArg_0_7: {
    DiagnosticPredicate DP(Operand.isRnumArg_0_7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg_0_7;
    break;
    }
  // 'RnumArg_1_10' class
  case MCK_RnumArg_1_10: {
    DiagnosticPredicate DP(Operand.isRnumArg_1_10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg_1_10;
    break;
    }
  // 'RnumArg_2_14' class
  case MCK_RnumArg_2_14: {
    DiagnosticPredicate DP(Operand.isRnumArg_2_14());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg_2_14;
    break;
    }
  // 'SImm5Plus1' class
  case MCK_SImm5Plus1: {
    DiagnosticPredicate DP(Operand.isSImm5Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5Plus1;
    break;
    }
  // 'SImm21Lsb0JAL' class
  case MCK_SImm21Lsb0JAL: {
    DiagnosticPredicate DP(Operand.isSImm21Lsb0JAL());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm21Lsb0JAL;
    break;
    }
  // 'Spimm' class
  case MCK_Spimm: {
    DiagnosticPredicate DP(Operand.isSpimm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSpimm;
    break;
    }
  // 'TPRelAddSymbol' class
  case MCK_TPRelAddSymbol: {
    DiagnosticPredicate DP(Operand.isTPRelAddSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTPRelAddSymbol;
    break;
    }
  // 'UImmLog2XLen' class
  case MCK_UImmLog2XLen: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLen());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLen;
    break;
    }
  // 'UImmLog2XLenHalf' class
  case MCK_UImmLog2XLenHalf: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenHalf());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenHalf;
    break;
    }
  // 'UImmLog2XLenNonZero' class
  case MCK_UImmLog2XLenNonZero: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenNonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenNonZero;
    break;
    }
  // 'RVVMaskRegOpOperand' class
  case MCK_RVVMaskRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskRegister;
    break;
    }
  // 'ZeroOffsetMemOpOperand' class
  case MCK_ZeroOffsetMemOpOperand: {
    DiagnosticPredicate DP(Operand.isGPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SImm12Lsb00000' class
  case MCK_SImm12Lsb00000: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb00000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb00000;
    break;
    }
  // 'SImm6' class
  case MCK_SImm6: {
    DiagnosticPredicate DP(Operand.isSImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6;
    break;
    }
  // 'SImm6NonZero' class
  case MCK_SImm6NonZero: {
    DiagnosticPredicate DP(Operand.isSImm6NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6NonZero;
    break;
    }
  // 'UImm7Lsb00' class
  case MCK_UImm7Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb00;
    break;
    }
  // 'UImm8Lsb00' class
  case MCK_UImm8Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb00;
    break;
    }
  // 'UImm8Lsb000' class
  case MCK_UImm8Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb000;
    break;
    }
  // 'SImm9Lsb0' class
  case MCK_SImm9Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm9Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm9Lsb0;
    break;
    }
  // 'UImm9Lsb000' class
  case MCK_UImm9Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm9Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm9Lsb000;
    break;
    }
  // 'UImm10Lsb00NonZero' class
  case MCK_UImm10Lsb00NonZero: {
    DiagnosticPredicate DP(Operand.isUImm10Lsb00NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10Lsb00NonZero;
    break;
    }
  // 'SImm10Lsb0000NonZero' class
  case MCK_SImm10Lsb0000NonZero: {
    DiagnosticPredicate DP(Operand.isSImm10Lsb0000NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10Lsb0000NonZero;
    break;
    }
  // 'SImm12Lsb0' class
  case MCK_SImm12Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb0;
    break;
    }
  // 'UImm2Lsb0' class
  case MCK_UImm2Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm2Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2Lsb0;
    break;
    }
  // 'UImm8GE32' class
  case MCK_UImm8GE32: {
    DiagnosticPredicate DP(Operand.isUImm8GE32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8GE32;
    break;
    }
  // 'UImm1' class
  case MCK_UImm1: {
    DiagnosticPredicate DP(Operand.isUImm1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm1;
    break;
    }
  // 'UImm2' class
  case MCK_UImm2: {
    DiagnosticPredicate DP(Operand.isUImm2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2;
    break;
    }
  // 'UImm3' class
  case MCK_UImm3: {
    DiagnosticPredicate DP(Operand.isUImm3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm3;
    break;
    }
  // 'UImm4' class
  case MCK_UImm4: {
    DiagnosticPredicate DP(Operand.isUImm4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm4;
    break;
    }
  // 'UImm5' class
  case MCK_UImm5: {
    DiagnosticPredicate DP(Operand.isUImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5;
    break;
    }
  // 'UImm6' class
  case MCK_UImm6: {
    DiagnosticPredicate DP(Operand.isUImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6;
    break;
    }
  // 'UImm7' class
  case MCK_UImm7: {
    DiagnosticPredicate DP(Operand.isUImm7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7;
    break;
    }
  // 'UImm8' class
  case MCK_UImm8: {
    DiagnosticPredicate DP(Operand.isUImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8;
    break;
    }
  // 'SImm12' class
  case MCK_SImm12: {
    DiagnosticPredicate DP(Operand.isSImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12;
    break;
    }
  // 'SImm13Lsb0' class
  case MCK_SImm13Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm13Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm13Lsb0;
    break;
    }
  // 'UImm20LUI' class
  case MCK_UImm20LUI: {
    DiagnosticPredicate DP(Operand.isUImm20LUI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20LUI;
    break;
    }
  // 'UImm20AUIPC' class
  case MCK_UImm20AUIPC: {
    DiagnosticPredicate DP(Operand.isUImm20AUIPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20AUIPC;
    break;
    }
  // 'ImmXLenLI' class
  case MCK_ImmXLenLI: {
    DiagnosticPredicate DP(Operand.isImmXLenLI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI;
    break;
    }
  // 'ImmXLenLI_Restricted' class
  case MCK_ImmXLenLI_Restricted: {
    DiagnosticPredicate DP(Operand.isImmXLenLI_Restricted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI_Restricted;
    break;
    }
  // 'VTypeI10' class
  case MCK_VTypeI10: {
    DiagnosticPredicate DP(Operand.isVTypeI10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
    }
  // 'VTypeI11' class
  case MCK_VTypeI11: {
    DiagnosticPredicate DP(Operand.isVTypeI11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
    }
  // 'SImm5' class
  case MCK_SImm5: {
    DiagnosticPredicate DP(Operand.isSImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case RISCV::X0: OpKind = MCK_GPRX0; break;
    case RISCV::X1: OpKind = MCK_PGPR; break;
    case RISCV::X2: OpKind = MCK_SP; break;
    case RISCV::X3: OpKind = MCK_GPRNoX0X2; break;
    case RISCV::X4: OpKind = MCK_GPRNoX0X2; break;
    case RISCV::X5: OpKind = MCK_GPRNoX0X2; break;
    case RISCV::X6: OpKind = MCK_GPRTC; break;
    case RISCV::X7: OpKind = MCK_GPRTC; break;
    case RISCV::X8: OpKind = MCK_Reg9; break;
    case RISCV::X9: OpKind = MCK_Reg9; break;
    case RISCV::X10: OpKind = MCK_Reg13; break;
    case RISCV::X11: OpKind = MCK_Reg13; break;
    case RISCV::X12: OpKind = MCK_Reg13; break;
    case RISCV::X13: OpKind = MCK_Reg13; break;
    case RISCV::X14: OpKind = MCK_Reg13; break;
    case RISCV::X15: OpKind = MCK_Reg13; break;
    case RISCV::X16: OpKind = MCK_GPRTC; break;
    case RISCV::X17: OpKind = MCK_GPRTC; break;
    case RISCV::X18: OpKind = MCK_SR07; break;
    case RISCV::X19: OpKind = MCK_SR07; break;
    case RISCV::X20: OpKind = MCK_SR07; break;
    case RISCV::X21: OpKind = MCK_SR07; break;
    case RISCV::X22: OpKind = MCK_SR07; break;
    case RISCV::X23: OpKind = MCK_SR07; break;
    case RISCV::X24: OpKind = MCK_Reg12; break;
    case RISCV::X25: OpKind = MCK_Reg12; break;
    case RISCV::X26: OpKind = MCK_Reg12; break;
    case RISCV::X27: OpKind = MCK_Reg12; break;
    case RISCV::X28: OpKind = MCK_GPRTC; break;
    case RISCV::X29: OpKind = MCK_GPRTC; break;
    case RISCV::X30: OpKind = MCK_GPRTC; break;
    case RISCV::X31: OpKind = MCK_GPRTC; break;
    case RISCV::F0_H: OpKind = MCK_FPR16; break;
    case RISCV::F1_H: OpKind = MCK_FPR16; break;
    case RISCV::F2_H: OpKind = MCK_FPR16; break;
    case RISCV::F3_H: OpKind = MCK_FPR16; break;
    case RISCV::F4_H: OpKind = MCK_FPR16; break;
    case RISCV::F5_H: OpKind = MCK_FPR16; break;
    case RISCV::F6_H: OpKind = MCK_FPR16; break;
    case RISCV::F7_H: OpKind = MCK_FPR16; break;
    case RISCV::F8_H: OpKind = MCK_FPR16; break;
    case RISCV::F9_H: OpKind = MCK_FPR16; break;
    case RISCV::F10_H: OpKind = MCK_FPR16; break;
    case RISCV::F11_H: OpKind = MCK_FPR16; break;
    case RISCV::F12_H: OpKind = MCK_FPR16; break;
    case RISCV::F13_H: OpKind = MCK_FPR16; break;
    case RISCV::F14_H: OpKind = MCK_FPR16; break;
    case RISCV::F15_H: OpKind = MCK_FPR16; break;
    case RISCV::F16_H: OpKind = MCK_FPR16; break;
    case RISCV::F17_H: OpKind = MCK_FPR16; break;
    case RISCV::F18_H: OpKind = MCK_FPR16; break;
    case RISCV::F19_H: OpKind = MCK_FPR16; break;
    case RISCV::F20_H: OpKind = MCK_FPR16; break;
    case RISCV::F21_H: OpKind = MCK_FPR16; break;
    case RISCV::F22_H: OpKind = MCK_FPR16; break;
    case RISCV::F23_H: OpKind = MCK_FPR16; break;
    case RISCV::F24_H: OpKind = MCK_FPR16; break;
    case RISCV::F25_H: OpKind = MCK_FPR16; break;
    case RISCV::F26_H: OpKind = MCK_FPR16; break;
    case RISCV::F27_H: OpKind = MCK_FPR16; break;
    case RISCV::F28_H: OpKind = MCK_FPR16; break;
    case RISCV::F29_H: OpKind = MCK_FPR16; break;
    case RISCV::F30_H: OpKind = MCK_FPR16; break;
    case RISCV::F31_H: OpKind = MCK_FPR16; break;
    case RISCV::F0_F: OpKind = MCK_FPR32; break;
    case RISCV::F1_F: OpKind = MCK_FPR32; break;
    case RISCV::F2_F: OpKind = MCK_FPR32; break;
    case RISCV::F3_F: OpKind = MCK_FPR32; break;
    case RISCV::F4_F: OpKind = MCK_FPR32; break;
    case RISCV::F5_F: OpKind = MCK_FPR32; break;
    case RISCV::F6_F: OpKind = MCK_FPR32; break;
    case RISCV::F7_F: OpKind = MCK_FPR32; break;
    case RISCV::F8_F: OpKind = MCK_FPR32C; break;
    case RISCV::F9_F: OpKind = MCK_FPR32C; break;
    case RISCV::F10_F: OpKind = MCK_FPR32C; break;
    case RISCV::F11_F: OpKind = MCK_FPR32C; break;
    case RISCV::F12_F: OpKind = MCK_FPR32C; break;
    case RISCV::F13_F: OpKind = MCK_FPR32C; break;
    case RISCV::F14_F: OpKind = MCK_FPR32C; break;
    case RISCV::F15_F: OpKind = MCK_FPR32C; break;
    case RISCV::F16_F: OpKind = MCK_FPR32; break;
    case RISCV::F17_F: OpKind = MCK_FPR32; break;
    case RISCV::F18_F: OpKind = MCK_FPR32; break;
    case RISCV::F19_F: OpKind = MCK_FPR32; break;
    case RISCV::F20_F: OpKind = MCK_FPR32; break;
    case RISCV::F21_F: OpKind = MCK_FPR32; break;
    case RISCV::F22_F: OpKind = MCK_FPR32; break;
    case RISCV::F23_F: OpKind = MCK_FPR32; break;
    case RISCV::F24_F: OpKind = MCK_FPR32; break;
    case RISCV::F25_F: OpKind = MCK_FPR32; break;
    case RISCV::F26_F: OpKind = MCK_FPR32; break;
    case RISCV::F27_F: OpKind = MCK_FPR32; break;
    case RISCV::F28_F: OpKind = MCK_FPR32; break;
    case RISCV::F29_F: OpKind = MCK_FPR32; break;
    case RISCV::F30_F: OpKind = MCK_FPR32; break;
    case RISCV::F31_F: OpKind = MCK_FPR32; break;
    case RISCV::F0_D: OpKind = MCK_FPR64; break;
    case RISCV::F1_D: OpKind = MCK_FPR64; break;
    case RISCV::F2_D: OpKind = MCK_FPR64; break;
    case RISCV::F3_D: OpKind = MCK_FPR64; break;
    case RISCV::F4_D: OpKind = MCK_FPR64; break;
    case RISCV::F5_D: OpKind = MCK_FPR64; break;
    case RISCV::F6_D: OpKind = MCK_FPR64; break;
    case RISCV::F7_D: OpKind = MCK_FPR64; break;
    case RISCV::F8_D: OpKind = MCK_FPR64C; break;
    case RISCV::F9_D: OpKind = MCK_FPR64C; break;
    case RISCV::F10_D: OpKind = MCK_FPR64C; break;
    case RISCV::F11_D: OpKind = MCK_FPR64C; break;
    case RISCV::F12_D: OpKind = MCK_FPR64C; break;
    case RISCV::F13_D: OpKind = MCK_FPR64C; break;
    case RISCV::F14_D: OpKind = MCK_FPR64C; break;
    case RISCV::F15_D: OpKind = MCK_FPR64C; break;
    case RISCV::F16_D: OpKind = MCK_FPR64; break;
    case RISCV::F17_D: OpKind = MCK_FPR64; break;
    case RISCV::F18_D: OpKind = MCK_FPR64; break;
    case RISCV::F19_D: OpKind = MCK_FPR64; break;
    case RISCV::F20_D: OpKind = MCK_FPR64; break;
    case RISCV::F21_D: OpKind = MCK_FPR64; break;
    case RISCV::F22_D: OpKind = MCK_FPR64; break;
    case RISCV::F23_D: OpKind = MCK_FPR64; break;
    case RISCV::F24_D: OpKind = MCK_FPR64; break;
    case RISCV::F25_D: OpKind = MCK_FPR64; break;
    case RISCV::F26_D: OpKind = MCK_FPR64; break;
    case RISCV::F27_D: OpKind = MCK_FPR64; break;
    case RISCV::F28_D: OpKind = MCK_FPR64; break;
    case RISCV::F29_D: OpKind = MCK_FPR64; break;
    case RISCV::F30_D: OpKind = MCK_FPR64; break;
    case RISCV::F31_D: OpKind = MCK_FPR64; break;
    case RISCV::V0: OpKind = MCK_VMV0; break;
    case RISCV::V1: OpKind = MCK_VRNoV0; break;
    case RISCV::V2: OpKind = MCK_VRNoV0; break;
    case RISCV::V3: OpKind = MCK_VRNoV0; break;
    case RISCV::V4: OpKind = MCK_VRNoV0; break;
    case RISCV::V5: OpKind = MCK_VRNoV0; break;
    case RISCV::V6: OpKind = MCK_VRNoV0; break;
    case RISCV::V7: OpKind = MCK_VRNoV0; break;
    case RISCV::V8: OpKind = MCK_VRNoV0; break;
    case RISCV::V9: OpKind = MCK_VRNoV0; break;
    case RISCV::V10: OpKind = MCK_VRNoV0; break;
    case RISCV::V11: OpKind = MCK_VRNoV0; break;
    case RISCV::V12: OpKind = MCK_VRNoV0; break;
    case RISCV::V13: OpKind = MCK_VRNoV0; break;
    case RISCV::V14: OpKind = MCK_VRNoV0; break;
    case RISCV::V15: OpKind = MCK_VRNoV0; break;
    case RISCV::V16: OpKind = MCK_VRNoV0; break;
    case RISCV::V17: OpKind = MCK_VRNoV0; break;
    case RISCV::V18: OpKind = MCK_VRNoV0; break;
    case RISCV::V19: OpKind = MCK_VRNoV0; break;
    case RISCV::V20: OpKind = MCK_VRNoV0; break;
    case RISCV::V21: OpKind = MCK_VRNoV0; break;
    case RISCV::V22: OpKind = MCK_VRNoV0; break;
    case RISCV::V23: OpKind = MCK_VRNoV0; break;
    case RISCV::V24: OpKind = MCK_VRNoV0; break;
    case RISCV::V25: OpKind = MCK_VRNoV0; break;
    case RISCV::V26: OpKind = MCK_VRNoV0; break;
    case RISCV::V27: OpKind = MCK_VRNoV0; break;
    case RISCV::V28: OpKind = MCK_VRNoV0; break;
    case RISCV::V29: OpKind = MCK_VRNoV0; break;
    case RISCV::V30: OpKind = MCK_VRNoV0; break;
    case RISCV::V31: OpKind = MCK_VRNoV0; break;
    case RISCV::V0M2: OpKind = MCK_Reg22; break;
    case RISCV::V2M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V4M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V6M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V8M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V10M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V12M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V14M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V16M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V18M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V20M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V22M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V24M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V26M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V28M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V30M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V0M4: OpKind = MCK_Reg25; break;
    case RISCV::V4M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V8M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V12M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V16M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V20M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V24M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V28M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V0M8: OpKind = MCK_Reg28; break;
    case RISCV::V8M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::V16M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::V24M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::VTYPE: OpKind = MCK_VCSR; break;
    case RISCV::VL: OpKind = MCK_VCSR; break;
    case RISCV::VLENB: OpKind = MCK_VCSR; break;
    case RISCV::DUMMY_REG_PAIR_WITH_X0: OpKind = MCK_GPRAll; break;
    case RISCV::X0_PD: OpKind = MCK_Reg32; break;
    case RISCV::X2_PD: OpKind = MCK_Reg34; break;
    case RISCV::X4_PD: OpKind = MCK_Reg36; break;
    case RISCV::X6_PD: OpKind = MCK_Reg38; break;
    case RISCV::X8_PD: OpKind = MCK_Reg39; break;
    case RISCV::X10_PD: OpKind = MCK_Reg43; break;
    case RISCV::X12_PD: OpKind = MCK_Reg43; break;
    case RISCV::X14_PD: OpKind = MCK_Reg43; break;
    case RISCV::X16_PD: OpKind = MCK_Reg38; break;
    case RISCV::X18_PD: OpKind = MCK_Reg41; break;
    case RISCV::X20_PD: OpKind = MCK_Reg41; break;
    case RISCV::X22_PD: OpKind = MCK_Reg41; break;
    case RISCV::X24_PD: OpKind = MCK_Reg42; break;
    case RISCV::X26_PD: OpKind = MCK_Reg42; break;
    case RISCV::X28_PD: OpKind = MCK_Reg38; break;
    case RISCV::X30_PD: OpKind = MCK_Reg38; break;
    case RISCV::V8_V9: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V9_V10: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V10_V11: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V11_V12: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V12_V13: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V13_V14: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V14_V15: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V15_V16: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V16_V17: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V17_V18: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V18_V19: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V19_V20: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V20_V21: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V21_V22: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V22_V23: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V23_V24: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V24_V25: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V25_V26: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V26_V27: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V27_V28: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V28_V29: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V29_V30: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V30_V31: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V1_V2: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V2_V3: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V3_V4: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V4_V5: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V5_V6: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V6_V7: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V7_V8: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V0_V1: OpKind = MCK_Reg46; break;
    case RISCV::V8M2_V10M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V10M2_V12M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V12M2_V14M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V14M2_V16M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V16M2_V18M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V18M2_V20M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V20M2_V22M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V22M2_V24M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V24M2_V26M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V26M2_V28M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V28M2_V30M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V2M2_V4M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V4M2_V6M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V6M2_V8M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V0M2_V2M2: OpKind = MCK_Reg49; break;
    case RISCV::V8M4_V12M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V12M4_V16M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V16M4_V20M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V20M4_V24M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V24M4_V28M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V4M4_V8M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V0M4_V4M4: OpKind = MCK_Reg52; break;
    case RISCV::V8_V9_V10: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V9_V10_V11: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V10_V11_V12: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V11_V12_V13: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V12_V13_V14: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V13_V14_V15: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V14_V15_V16: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V15_V16_V17: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V16_V17_V18: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V17_V18_V19: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V18_V19_V20: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V19_V20_V21: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V20_V21_V22: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V21_V22_V23: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V22_V23_V24: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V23_V24_V25: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V24_V25_V26: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V25_V26_V27: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V26_V27_V28: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V27_V28_V29: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V28_V29_V30: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V29_V30_V31: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V1_V2_V3: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V2_V3_V4: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V3_V4_V5: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V4_V5_V6: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V5_V6_V7: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V6_V7_V8: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V7_V8_V9: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V0_V1_V2: OpKind = MCK_Reg55; break;
    case RISCV::V8M2_V10M2_V12M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V10M2_V12M2_V14M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V12M2_V14M2_V16M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V14M2_V16M2_V18M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V16M2_V18M2_V20M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V18M2_V20M2_V22M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V20M2_V22M2_V24M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V22M2_V24M2_V26M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V24M2_V26M2_V28M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V26M2_V28M2_V30M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V2M2_V4M2_V6M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V4M2_V6M2_V8M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V6M2_V8M2_V10M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V0M2_V2M2_V4M2: OpKind = MCK_Reg58; break;
    case RISCV::V8_V9_V10_V11: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V9_V10_V11_V12: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V10_V11_V12_V13: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V11_V12_V13_V14: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V12_V13_V14_V15: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V13_V14_V15_V16: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V14_V15_V16_V17: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V15_V16_V17_V18: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V16_V17_V18_V19: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V17_V18_V19_V20: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V18_V19_V20_V21: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V19_V20_V21_V22: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V20_V21_V22_V23: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V21_V22_V23_V24: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V22_V23_V24_V25: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V23_V24_V25_V26: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V24_V25_V26_V27: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V25_V26_V27_V28: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V26_V27_V28_V29: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V27_V28_V29_V30: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V28_V29_V30_V31: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V1_V2_V3_V4: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V2_V3_V4_V5: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V3_V4_V5_V6: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V4_V5_V6_V7: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V5_V6_V7_V8: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V6_V7_V8_V9: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V7_V8_V9_V10: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V0_V1_V2_V3: OpKind = MCK_Reg61; break;
    case RISCV::V8M2_V10M2_V12M2_V14M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V10M2_V12M2_V14M2_V16M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V12M2_V14M2_V16M2_V18M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V14M2_V16M2_V18M2_V20M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V16M2_V18M2_V20M2_V22M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V18M2_V20M2_V22M2_V24M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V20M2_V22M2_V24M2_V26M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V22M2_V24M2_V26M2_V28M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V24M2_V26M2_V28M2_V30M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V2M2_V4M2_V6M2_V8M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V4M2_V6M2_V8M2_V10M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V6M2_V8M2_V10M2_V12M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V0M2_V2M2_V4M2_V6M2: OpKind = MCK_Reg64; break;
    case RISCV::V8_V9_V10_V11_V12: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V26_V27_V28_V29_V30: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V27_V28_V29_V30_V31: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4: OpKind = MCK_Reg67; break;
    case RISCV::V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5: OpKind = MCK_Reg70; break;
    case RISCV::V8_V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6_V7: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5_V6: OpKind = MCK_Reg73; break;
    case RISCV::V8_V9_V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5_V6_V7: OpKind = MCK_Reg76; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__40_: return "MCK__40_";
  case MCK__41_: return "MCK__41_";
  case MCK_Reg76: return "MCK_Reg76";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg70: return "MCK_Reg70";
  case MCK_Reg67: return "MCK_Reg67";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg61: return "MCK_Reg61";
  case MCK_Reg58: return "MCK_Reg58";
  case MCK_Reg55: return "MCK_Reg55";
  case MCK_Reg52: return "MCK_Reg52";
  case MCK_Reg49: return "MCK_Reg49";
  case MCK_Reg46: return "MCK_Reg46";
  case MCK_Reg39: return "MCK_Reg39";
  case MCK_Reg34: return "MCK_Reg34";
  case MCK_Reg32: return "MCK_Reg32";
  case MCK_Reg28: return "MCK_Reg28";
  case MCK_Reg25: return "MCK_Reg25";
  case MCK_Reg22: return "MCK_Reg22";
  case MCK_GPRX0: return "MCK_GPRX0";
  case MCK_SP: return "MCK_SP";
  case MCK_VMV0: return "MCK_VMV0";
  case MCK_Reg9: return "MCK_Reg9";
  case MCK_Reg43: return "MCK_Reg43";
  case MCK_VCSR: return "MCK_VCSR";
  case MCK_VRM8NoV0: return "MCK_VRM8NoV0";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg40: return "MCK_Reg40";
  case MCK_VRM8: return "MCK_VRM8";
  case MCK_Reg42: return "MCK_Reg42";
  case MCK_Reg13: return "MCK_Reg13";
  case MCK_VRN2M4NoV0: return "MCK_VRN2M4NoV0";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_VRM4NoV0: return "MCK_VRM4NoV0";
  case MCK_VRN2M4: return "MCK_VRN2M4";
  case MCK_FPR32C: return "MCK_FPR32C";
  case MCK_FPR64C: return "MCK_FPR64C";
  case MCK_GPRC: return "MCK_GPRC";
  case MCK_SR07: return "MCK_SR07";
  case MCK_VRM4: return "MCK_VRM4";
  case MCK_Reg12: return "MCK_Reg12";
  case MCK_VRN4M2NoV0: return "MCK_VRN4M2NoV0";
  case MCK_Reg37: return "MCK_Reg37";
  case MCK_PGPR: return "MCK_PGPR";
  case MCK_VRN3M2NoV0: return "MCK_VRN3M2NoV0";
  case MCK_VRN4M2: return "MCK_VRN4M2";
  case MCK_Reg36: return "MCK_Reg36";
  case MCK_GPRTC: return "MCK_GPRTC";
  case MCK_VRN2M2NoV0: return "MCK_VRN2M2NoV0";
  case MCK_VRN3M2: return "MCK_VRN3M2";
  case MCK_Reg35: return "MCK_Reg35";
  case MCK_VRM2NoV0: return "MCK_VRM2NoV0";
  case MCK_VRN2M2: return "MCK_VRN2M2";
  case MCK_GPRPF64: return "MCK_GPRPF64";
  case MCK_VRM2: return "MCK_VRM2";
  case MCK_VRN8M1NoV0: return "MCK_VRN8M1NoV0";
  case MCK_VRN7M1NoV0: return "MCK_VRN7M1NoV0";
  case MCK_VRN8M1: return "MCK_VRN8M1";
  case MCK_GPRJALR: return "MCK_GPRJALR";
  case MCK_VRN6M1NoV0: return "MCK_VRN6M1NoV0";
  case MCK_VRN7M1: return "MCK_VRN7M1";
  case MCK_VRN5M1NoV0: return "MCK_VRN5M1NoV0";
  case MCK_VRN6M1: return "MCK_VRN6M1";
  case MCK_VRN4M1NoV0: return "MCK_VRN4M1NoV0";
  case MCK_VRN5M1: return "MCK_VRN5M1";
  case MCK_VRN3M1NoV0: return "MCK_VRN3M1NoV0";
  case MCK_VRN4M1: return "MCK_VRN4M1";
  case MCK_GPRNoX0X2: return "MCK_GPRNoX0X2";
  case MCK_VRN2M1NoV0: return "MCK_VRN2M1NoV0";
  case MCK_VRN3M1: return "MCK_VRN3M1";
  case MCK_GPRNoX0: return "MCK_GPRNoX0";
  case MCK_VRN2M1: return "MCK_VRN2M1";
  case MCK_VRNoV0: return "MCK_VRNoV0";
  case MCK_FPR16: return "MCK_FPR16";
  case MCK_FPR32: return "MCK_FPR32";
  case MCK_FPR64: return "MCK_FPR64";
  case MCK_GPR: return "MCK_GPR";
  case MCK_VM: return "MCK_VM";
  case MCK_GPRAll: return "MCK_GPRAll";
  case MCK_AnyRegCOperand: return "MCK_AnyRegCOperand";
  case MCK_AnyRegOperand: return "MCK_AnyRegOperand";
  case MCK_BareSymbol: return "MCK_BareSymbol";
  case MCK_CLUIImm: return "MCK_CLUIImm";
  case MCK_CSRSystemRegister: return "MCK_CSRSystemRegister";
  case MCK_CallSymbol: return "MCK_CallSymbol";
  case MCK_FRMArg: return "MCK_FRMArg";
  case MCK_FenceArg: return "MCK_FenceArg";
  case MCK_GPRAsFPR: return "MCK_GPRAsFPR";
  case MCK_GPRF64AsFPR: return "MCK_GPRF64AsFPR";
  case MCK_GPRPF64AsFPR: return "MCK_GPRPF64AsFPR";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmZero: return "MCK_ImmZero";
  case MCK_InsnCDirectiveOpcode: return "MCK_InsnCDirectiveOpcode";
  case MCK_InsnDirectiveOpcode: return "MCK_InsnDirectiveOpcode";
  case MCK_LoadFPImm: return "MCK_LoadFPImm";
  case MCK_PseudoJumpSymbol: return "MCK_PseudoJumpSymbol";
  case MCK_RTZArg: return "MCK_RTZArg";
  case MCK_Rlist: return "MCK_Rlist";
  case MCK_RnumArg: return "MCK_RnumArg";
  case MCK_RnumArg_0_7: return "MCK_RnumArg_0_7";
  case MCK_RnumArg_1_10: return "MCK_RnumArg_1_10";
  case MCK_RnumArg_2_14: return "MCK_RnumArg_2_14";
  case MCK_SImm5Plus1: return "MCK_SImm5Plus1";
  case MCK_SImm21Lsb0JAL: return "MCK_SImm21Lsb0JAL";
  case MCK_Spimm: return "MCK_Spimm";
  case MCK_TPRelAddSymbol: return "MCK_TPRelAddSymbol";
  case MCK_UImmLog2XLen: return "MCK_UImmLog2XLen";
  case MCK_UImmLog2XLenHalf: return "MCK_UImmLog2XLenHalf";
  case MCK_UImmLog2XLenNonZero: return "MCK_UImmLog2XLenNonZero";
  case MCK_RVVMaskRegOpOperand: return "MCK_RVVMaskRegOpOperand";
  case MCK_ZeroOffsetMemOpOperand: return "MCK_ZeroOffsetMemOpOperand";
  case MCK_SImm12Lsb00000: return "MCK_SImm12Lsb00000";
  case MCK_SImm6: return "MCK_SImm6";
  case MCK_SImm6NonZero: return "MCK_SImm6NonZero";
  case MCK_UImm7Lsb00: return "MCK_UImm7Lsb00";
  case MCK_UImm8Lsb00: return "MCK_UImm8Lsb00";
  case MCK_UImm8Lsb000: return "MCK_UImm8Lsb000";
  case MCK_SImm9Lsb0: return "MCK_SImm9Lsb0";
  case MCK_UImm9Lsb000: return "MCK_UImm9Lsb000";
  case MCK_UImm10Lsb00NonZero: return "MCK_UImm10Lsb00NonZero";
  case MCK_SImm10Lsb0000NonZero: return "MCK_SImm10Lsb0000NonZero";
  case MCK_SImm12Lsb0: return "MCK_SImm12Lsb0";
  case MCK_UImm2Lsb0: return "MCK_UImm2Lsb0";
  case MCK_UImm8GE32: return "MCK_UImm8GE32";
  case MCK_UImm1: return "MCK_UImm1";
  case MCK_UImm2: return "MCK_UImm2";
  case MCK_UImm3: return "MCK_UImm3";
  case MCK_UImm4: return "MCK_UImm4";
  case MCK_UImm5: return "MCK_UImm5";
  case MCK_UImm6: return "MCK_UImm6";
  case MCK_UImm7: return "MCK_UImm7";
  case MCK_UImm8: return "MCK_UImm8";
  case MCK_SImm12: return "MCK_SImm12";
  case MCK_SImm13Lsb0: return "MCK_SImm13Lsb0";
  case MCK_UImm20LUI: return "MCK_UImm20LUI";
  case MCK_UImm20AUIPC: return "MCK_UImm20AUIPC";
  case MCK_ImmXLenLI: return "MCK_ImmXLenLI";
  case MCK_ImmXLenLI_Restricted: return "MCK_ImmXLenLI_Restricted";
  case MCK_VTypeI10: return "MCK_VTypeI10";
  case MCK_VTypeI11: return "MCK_VTypeI11";
  case MCK_SImm5: return "MCK_SImm5";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset RISCVAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[RISCV::FeatureStdExtZicsr])
    Features.set(Feature_HasStdExtZicsrBit);
  if (FB[RISCV::FeatureStdExtM])
    Features.set(Feature_HasStdExtMBit);
  if (FB[RISCV::FeatureStdExtM] || FB[RISCV::FeatureStdExtZmmul])
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (FB[RISCV::FeatureStdExtA])
    Features.set(Feature_HasStdExtABit);
  if (FB[RISCV::FeatureStdExtF])
    Features.set(Feature_HasStdExtFBit);
  if (FB[RISCV::FeatureStdExtD])
    Features.set(Feature_HasStdExtDBit);
  if (FB[RISCV::FeatureStdExtH])
    Features.set(Feature_HasStdExtHBit);
  if (FB[RISCV::FeatureStdExtZihintpause])
    Features.set(Feature_HasStdExtZihintpauseBit);
  if (FB[RISCV::FeatureStdExtZihintntl])
    Features.set(Feature_HasStdExtZihintntlBit);
  if (FB[RISCV::FeatureStdExtZifencei])
    Features.set(Feature_HasStdExtZifenceiBit);
  if (FB[RISCV::FeatureStdExtZfhmin])
    Features.set(Feature_HasStdExtZfhminBit);
  if (FB[RISCV::FeatureStdExtZfh])
    Features.set(Feature_HasStdExtZfhBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZfhmin])
    Features.set(Feature_HasStdExtZfhOrZfhminBit);
  if (FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtZfinxBit);
  if (FB[RISCV::FeatureStdExtZdinx])
    Features.set(Feature_HasStdExtZdinxBit);
  if (FB[RISCV::FeatureStdExtZhinxmin])
    Features.set(Feature_HasStdExtZhinxminBit);
  if (FB[RISCV::FeatureStdExtZhinx])
    Features.set(Feature_HasStdExtZhinxBit);
  if (FB[RISCV::FeatureStdExtZhinx] || FB[RISCV::FeatureStdExtZhinxmin])
    Features.set(Feature_HasStdExtZhinxOrZhinxminBit);
  if (FB[RISCV::FeatureStdExtZfa])
    Features.set(Feature_HasStdExtZfaBit);
  if (FB[RISCV::FeatureStdExtC])
    Features.set(Feature_HasStdExtCBit);
  if (FB[RISCV::FeatureStdExtZba])
    Features.set(Feature_HasStdExtZbaBit);
  if (FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_HasStdExtZbbBit);
  if (FB[RISCV::FeatureStdExtZbc])
    Features.set(Feature_HasStdExtZbcBit);
  if (FB[RISCV::FeatureStdExtZbs])
    Features.set(Feature_HasStdExtZbsBit);
  if (FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkx])
    Features.set(Feature_HasStdExtZbkxBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbkcBit);
  if (FB[RISCV::FeatureStdExtZbc] || FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (FB[RISCV::FeatureStdExtZknd])
    Features.set(Feature_HasStdExtZkndBit);
  if (FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkneBit);
  if (FB[RISCV::FeatureStdExtZknd] || FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (FB[RISCV::FeatureStdExtZknh])
    Features.set(Feature_HasStdExtZknhBit);
  if (FB[RISCV::FeatureStdExtZksed])
    Features.set(Feature_HasStdExtZksedBit);
  if (FB[RISCV::FeatureStdExtZksh])
    Features.set(Feature_HasStdExtZkshBit);
  if (FB[RISCV::FeatureStdExtZkr])
    Features.set(Feature_HasStdExtZkrBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZca])
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (FB[RISCV::FeatureStdExtZcb])
    Features.set(Feature_HasStdExtZcbBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcd])
    Features.set(Feature_HasStdExtCOrZcdBit);
  if (FB[RISCV::FeatureStdExtZcmp])
    Features.set(Feature_HasStdExtZcmpBit);
  if (FB[RISCV::FeatureStdExtZcmt])
    Features.set(Feature_HasStdExtZcmtBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcf] || FB[RISCV::FeatureStdExtZce])
    Features.set(Feature_HasStdExtCOrZcfOrZceBit);
  if (!FB[RISCV::FeatureNoRVCHints])
    Features.set(Feature_HasRVCHintsBit);
  if (FB[RISCV::FeatureStdExtZve32x])
    Features.set(Feature_HasVInstructionsBit);
  if (FB[RISCV::FeatureStdExtZve64x])
    Features.set(Feature_HasVInstructionsI64Bit);
  if (FB[RISCV::FeatureStdExtZve32f])
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (FB[RISCV::FeatureStdExtZvfbfmin])
    Features.set(Feature_HasStdExtZvfbfminBit);
  if (FB[RISCV::FeatureStdExtZvfbfwma])
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasStdExtZfhOrZvfhBit);
  if (FB[RISCV::FeatureStdExtZicbom])
    Features.set(Feature_HasStdExtZicbomBit);
  if (FB[RISCV::FeatureStdExtZicboz])
    Features.set(Feature_HasStdExtZicbozBit);
  if (FB[RISCV::FeatureStdExtZicbop])
    Features.set(Feature_HasStdExtZicbopBit);
  if (FB[RISCV::FeatureStdExtSvinval])
    Features.set(Feature_HasStdExtSvinvalBit);
  if (FB[RISCV::FeatureStdExtZtso])
    Features.set(Feature_HasStdExtZtsoBit);
  if (FB[RISCV::FeatureStdExtZawrs])
    Features.set(Feature_HasStdExtZawrsBit);
  if (FB[RISCV::FeatureStdExtZvbb])
    Features.set(Feature_HasStdExtZvbbBit);
  if (FB[RISCV::FeatureStdExtZvbc])
    Features.set(Feature_HasStdExtZvbcBit);
  if (FB[RISCV::FeatureStdExtZvkg])
    Features.set(Feature_HasStdExtZvkgBit);
  if (FB[RISCV::FeatureStdExtZvkned])
    Features.set(Feature_HasStdExtZvknedBit);
  if (FB[RISCV::FeatureStdExtZvknha])
    Features.set(Feature_HasStdExtZvknhaBit);
  if (FB[RISCV::FeatureStdExtZvksed])
    Features.set(Feature_HasStdExtZvksedBit);
  if (FB[RISCV::FeatureStdExtZvksh])
    Features.set(Feature_HasStdExtZvkshBit);
  if (FB[RISCV::FeatureStdExtZicond])
    Features.set(Feature_HasStdExtZicondBit);
  if (FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasStdExtZfbfminBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZfhmin] || FB[RISCV::FeatureStdExtZfbfmin] || FB[RISCV::FeatureStdExtZvfbfwma])
    Features.set(Feature_HasHalfFPLoadStoreMoveBit);
  if (FB[RISCV::FeatureStdExtZacas])
    Features.set(Feature_HasStdExtZacasBit);
  if (FB[RISCV::FeatureVendorXVentanaCondOps])
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (FB[RISCV::FeatureVendorXTHeadBa])
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (FB[RISCV::FeatureVendorXTHeadBb])
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (FB[RISCV::FeatureVendorXTHeadBs])
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (FB[RISCV::FeatureVendorXTHeadCondMov])
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (FB[RISCV::FeatureVendorXTHeadCmo])
    Features.set(Feature_HasVendorXTHeadCmoBit);
  if (FB[RISCV::FeatureVendorXTHeadFMemIdx])
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMac])
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (FB[RISCV::FeatureVendorXTHeadMemIdx])
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMemPair])
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (FB[RISCV::FeatureVendorXTHeadSync])
    Features.set(Feature_HasVendorXTHeadSyncBit);
  if (FB[RISCV::FeatureVendorXTHeadVdot])
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (FB[RISCV::FeatureVendorXSfvcp])
    Features.set(Feature_HasVendorXSfvcpBit);
  if (FB[RISCV::FeatureVendorXSfcie])
    Features.set(Feature_HasVendorXSfcieBit);
  if (FB[RISCV::FeatureVendorXCVbitmanip])
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (FB[RISCV::FeatureVendorXCVmac])
    Features.set(Feature_HasVendorXCVmacBit);
  if (FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV64Bit);
  if (!FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV32Bit);
  if (FB[RISCV::FeatureRVE])
    Features.set(Feature_IsRVEBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const RISCVAsmParser&AsmParser,
                               unsigned Kind,
                               const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\007.insn_b\010.insn_ca\010.insn_cb\010.insn_ci\t.insn_ciw\010.insn_cj\010"
    ".insn_cl\010.insn_cr\010.insn_cs\t.insn_css\007.insn_i\007.insn_j\007.i"
    "nsn_r\010.insn_r4\007.insn_s\010.insn_sb\007.insn_u\010.insn_uj\003add\006"
    "add.uw\004addi\005addiw\004addw\010aes32dsi\taes32dsmi\010aes32esi\taes"
    "32esmi\007aes64ds\010aes64dsm\007aes64es\010aes64esm\007aes64im\taes64k"
    "s1i\010aes64ks2\010amoadd.d\013amoadd.d.aq\015amoadd.d.aqrl\013amoadd.d"
    ".rl\010amoadd.w\013amoadd.w.aq\015amoadd.w.aqrl\013amoadd.w.rl\010amoan"
    "d.d\013amoand.d.aq\015amoand.d.aqrl\013amoand.d.rl\010amoand.w\013amoan"
    "d.w.aq\015amoand.w.aqrl\013amoand.w.rl\010amocas.d\013amocas.d.aq\015am"
    "ocas.d.aqrl\013amocas.d.rl\010amocas.q\013amocas.q.aq\015amocas.q.aqrl\013"
    "amocas.q.rl\010amocas.w\013amocas.w.aq\015amocas.w.aqrl\013amocas.w.rl\010"
    "amomax.d\013amomax.d.aq\015amomax.d.aqrl\013amomax.d.rl\010amomax.w\013"
    "amomax.w.aq\015amomax.w.aqrl\013amomax.w.rl\tamomaxu.d\014amomaxu.d.aq\016"
    "amomaxu.d.aqrl\014amomaxu.d.rl\tamomaxu.w\014amomaxu.w.aq\016amomaxu.w."
    "aqrl\014amomaxu.w.rl\010amomin.d\013amomin.d.aq\015amomin.d.aqrl\013amo"
    "min.d.rl\010amomin.w\013amomin.w.aq\015amomin.w.aqrl\013amomin.w.rl\tam"
    "ominu.d\014amominu.d.aq\016amominu.d.aqrl\014amominu.d.rl\tamominu.w\014"
    "amominu.w.aq\016amominu.w.aqrl\014amominu.w.rl\007amoor.d\namoor.d.aq\014"
    "amoor.d.aqrl\namoor.d.rl\007amoor.w\namoor.w.aq\014amoor.w.aqrl\namoor."
    "w.rl\tamoswap.d\014amoswap.d.aq\016amoswap.d.aqrl\014amoswap.d.rl\tamos"
    "wap.w\014amoswap.w.aq\016amoswap.w.aqrl\014amoswap.w.rl\010amoxor.d\013"
    "amoxor.d.aq\015amoxor.d.aqrl\013amoxor.d.rl\010amoxor.w\013amoxor.w.aq\015"
    "amoxor.w.aqrl\013amoxor.w.rl\003and\004andi\004andn\005auipc\004bclr\005"
    "bclri\003beq\004beqz\004bext\005bexti\003bge\004bgeu\004bgez\003bgt\004"
    "bgtu\004bgtz\004binv\005binvi\003ble\004bleu\004blez\003blt\004bltu\004"
    "bltz\003bne\004bnez\005brev8\004bset\005bseti\005c.add\006c.addi\nc.add"
    "i16sp\nc.addi4spn\007c.addiw\006c.addw\005c.and\006c.andi\006c.beqz\006"
    "c.bnez\010c.ebreak\005c.fld\007c.fldsp\005c.flw\007c.flwsp\005c.fsd\007"
    "c.fsdsp\005c.fsw\007c.fswsp\003c.j\005c.jal\006c.jalr\004c.jr\005c.lbu\004"
    "c.ld\006c.ldsp\004c.lh\005c.lhu\004c.li\005c.lui\004c.lw\006c.lwsp\005c"
    ".mul\004c.mv\005c.nop\005c.not\tc.ntl.all\010c.ntl.p1\nc.ntl.pall\010c."
    "ntl.s1\004c.or\004c.sb\004c.sd\006c.sdsp\010c.sext.b\010c.sext.h\004c.s"
    "h\006c.slli\010c.slli64\006c.srai\010c.srai64\006c.srli\010c.srli64\005"
    "c.sub\006c.subw\004c.sw\006c.swsp\007c.unimp\005c.xor\010c.zext.b\010c."
    "zext.h\010c.zext.w\004call\tcbo.clean\tcbo.flush\tcbo.inval\010cbo.zero"
    "\015cdiscard.d.l1\005cease\013cflush.d.l1\005clmul\006clmulh\006clmulr\003"
    "clz\004clzw\007cm.jalt\005cm.jt\tcm.mva01s\tcm.mvsa01\006cm.pop\tcm.pop"
    "ret\ncm.popretz\007cm.push\004cpop\005cpopw\004csrc\005csrci\004csrr\005"
    "csrrc\006csrrci\005csrrs\006csrrsi\005csrrw\006csrrwi\004csrs\005csrsi\004"
    "csrw\005csrwi\003ctz\004ctzw\007cv.bclr\010cv.bclrr\tcv.bitrev\007cv.bs"
    "et\010cv.bsetr\006cv.clb\006cv.cnt\ncv.extract\013cv.extractr\013cv.ext"
    "ractu\014cv.extractur\006cv.ff1\006cv.fl1\tcv.insert\ncv.insertr\006cv."
    "mac\ncv.machhsn\013cv.machhsrn\ncv.machhun\013cv.machhurn\010cv.macsn\t"
    "cv.macsrn\010cv.macun\tcv.macurn\006cv.msu\tcv.mulhhs\ncv.mulhhsn\013cv"
    ".mulhhsrn\tcv.mulhhu\ncv.mulhhun\013cv.mulhhurn\007cv.muls\010cv.mulsn\t"
    "cv.mulsrn\007cv.mulu\010cv.mulun\tcv.mulurn\006cv.ror\tczero.eqz\tczero"
    ".nez\003div\004divu\005divuw\004divw\004dret\006ebreak\005ecall\006fabs"
    ".d\006fabs.h\006fabs.s\006fadd.d\006fadd.h\006fadd.s\010fclass.d\010fcl"
    "ass.h\010fclass.s\013fcvt.bf16.s\010fcvt.d.h\010fcvt.d.l\tfcvt.d.lu\010"
    "fcvt.d.s\010fcvt.d.w\tfcvt.d.wu\010fcvt.h.d\010fcvt.h.l\tfcvt.h.lu\010f"
    "cvt.h.s\010fcvt.h.w\tfcvt.h.wu\010fcvt.l.d\010fcvt.l.h\010fcvt.l.s\tfcv"
    "t.lu.d\tfcvt.lu.h\tfcvt.lu.s\013fcvt.s.bf16\010fcvt.s.d\010fcvt.s.h\010"
    "fcvt.s.l\tfcvt.s.lu\010fcvt.s.w\tfcvt.s.wu\010fcvt.w.d\010fcvt.w.h\010f"
    "cvt.w.s\tfcvt.wu.d\tfcvt.wu.h\tfcvt.wu.s\013fcvtmod.w.d\006fdiv.d\006fd"
    "iv.h\006fdiv.s\005fence\007fence.i\tfence.tso\005feq.d\005feq.h\005feq."
    "s\005fge.d\005fge.h\005fge.s\006fgeq.d\006fgeq.h\006fgeq.s\005fgt.d\005"
    "fgt.h\005fgt.s\006fgtq.d\006fgtq.h\006fgtq.s\003fld\005fle.d\005fle.h\005"
    "fle.s\006fleq.d\006fleq.h\006fleq.s\003flh\005fli.d\005fli.h\005fli.s\005"
    "flt.d\005flt.h\005flt.s\006fltq.d\006fltq.h\006fltq.s\003flw\007fmadd.d"
    "\007fmadd.h\007fmadd.s\006fmax.d\006fmax.h\006fmax.s\007fmaxm.d\007fmax"
    "m.h\007fmaxm.s\006fmin.d\006fmin.h\006fmin.s\007fminm.d\007fminm.h\007f"
    "minm.s\007fmsub.d\007fmsub.h\007fmsub.s\006fmul.d\006fmul.h\006fmul.s\005"
    "fmv.d\007fmv.d.x\005fmv.h\007fmv.h.x\005fmv.s\007fmv.w.x\007fmv.x.d\007"
    "fmv.x.h\007fmv.x.w\010fmvh.x.d\010fmvp.d.x\006fneg.d\006fneg.h\006fneg."
    "s\010fnmadd.d\010fnmadd.h\010fnmadd.s\010fnmsub.d\010fnmsub.h\010fnmsub"
    ".s\005frcsr\007frflags\010fround.d\010fround.h\010fround.s\nfroundnx.d\n"
    "froundnx.h\nfroundnx.s\004frrm\004frsr\005fscsr\003fsd\007fsflags\010fs"
    "flagsi\007fsgnj.d\007fsgnj.h\007fsgnj.s\010fsgnjn.d\010fsgnjn.h\010fsgn"
    "jn.s\010fsgnjx.d\010fsgnjx.h\010fsgnjx.s\003fsh\007fsqrt.d\007fsqrt.h\007"
    "fsqrt.s\004fsrm\005fsrmi\004fssr\006fsub.d\006fsub.h\006fsub.s\003fsw\013"
    "hfence.gvma\013hfence.vvma\013hinval.gvma\013hinval.vvma\005hlv.b\006hl"
    "v.bu\005hlv.d\005hlv.h\006hlv.hu\005hlv.w\006hlv.wu\007hlvx.hu\007hlvx."
    "wu\005hsv.b\005hsv.d\005hsv.h\005hsv.w\001j\003jal\004jalr\002jr\004jum"
    "p\002la\tla.tls.gd\tla.tls.ie\002lb\003lbu\002ld\003lga\002lh\003lhu\002"
    "li\003lla\004lr.d\007lr.d.aq\tlr.d.aqrl\007lr.d.rl\004lr.w\007lr.w.aq\t"
    "lr.w.aqrl\007lr.w.rl\003lui\002lw\003lwu\003max\004maxu\003min\004minu\004"
    "mret\003mul\004mulh\006mulhsu\005mulhu\004mulw\002mv\003neg\004negw\003"
    "nop\003not\007ntl.all\006ntl.p1\010ntl.pall\006ntl.s1\002or\005orc.b\003"
    "ori\003orn\004pack\005packh\005packw\005pause\nprefetch.i\nprefetch.r\n"
    "prefetch.w\007rdcycle\010rdcycleh\trdinstret\nrdinstreth\006rdtime\007r"
    "dtimeh\003rem\004remu\005remuw\004remw\003ret\004rev8\003rol\004rolw\003"
    "ror\004rori\005roriw\004rorw\002sb\004sc.d\007sc.d.aq\tsc.d.aqrl\007sc."
    "d.rl\004sc.w\007sc.w.aq\tsc.w.aqrl\007sc.w.rl\002sd\004seqz\006sext.b\006"
    "sext.h\006sext.w\010sf.vc.fv\tsf.vc.fvv\tsf.vc.fvw\007sf.vc.i\010sf.vc."
    "iv\tsf.vc.ivv\tsf.vc.ivw\nsf.vc.v.fv\013sf.vc.v.fvv\013sf.vc.v.fvw\tsf."
    "vc.v.i\nsf.vc.v.iv\013sf.vc.v.ivv\013sf.vc.v.ivw\nsf.vc.v.vv\013sf.vc.v"
    ".vvv\013sf.vc.v.vvw\tsf.vc.v.x\nsf.vc.v.xv\013sf.vc.v.xvv\013sf.vc.v.xv"
    "w\010sf.vc.vv\tsf.vc.vvv\tsf.vc.vvw\007sf.vc.x\010sf.vc.xv\tsf.vc.xvv\t"
    "sf.vc.xvw\017sfence.inval.ir\nsfence.vma\016sfence.w.inval\003sgt\004sg"
    "tu\004sgtz\002sh\006sh1add\tsh1add.uw\006sh2add\tsh2add.uw\006sh3add\ts"
    "h3add.uw\nsha256sig0\nsha256sig1\nsha256sum0\nsha256sum1\nsha512sig0\013"
    "sha512sig0h\013sha512sig0l\nsha512sig1\013sha512sig1h\013sha512sig1l\ns"
    "ha512sum0\013sha512sum0r\nsha512sum1\013sha512sum1r\nsinval.vma\003sll\004"
    "slli\007slli.uw\005slliw\004sllw\003slt\004slti\005sltiu\004sltu\004slt"
    "z\005sm3p0\005sm3p1\005sm4ed\005sm4ks\004snez\003sra\004srai\005sraiw\004"
    "sraw\004sret\003srl\004srli\005srliw\004srlw\003sub\004subw\002sw\004ta"
    "il\010th.addsl\016th.dcache.call\017th.dcache.ciall\016th.dcache.cipa\016"
    "th.dcache.cisw\016th.dcache.civa\015th.dcache.cpa\017th.dcache.cpal1\015"
    "th.dcache.csw\015th.dcache.cva\017th.dcache.cval1\016th.dcache.iall\015"
    "th.dcache.ipa\015th.dcache.isw\015th.dcache.iva\006th.ext\007th.extu\006"
    "th.ff0\006th.ff1\007th.flrd\007th.flrw\010th.flurd\010th.flurw\007th.fs"
    "rd\007th.fsrw\010th.fsurd\010th.fsurw\016th.icache.iall\017th.icache.ia"
    "lls\015th.icache.ipa\015th.icache.iva\017th.l2cache.call\020th.l2cache."
    "ciall\017th.l2cache.iall\007th.lbia\007th.lbib\010th.lbuia\010th.lbuib\006"
    "th.ldd\007th.ldia\007th.ldib\007th.lhia\007th.lhib\010th.lhuia\010th.lh"
    "uib\006th.lrb\007th.lrbu\006th.lrd\006th.lrh\007th.lrhu\006th.lrw\007th"
    ".lrwu\007th.lurb\010th.lurbu\007th.lurd\007th.lurh\010th.lurhu\007th.lu"
    "rw\010th.lurwu\006th.lwd\007th.lwia\007th.lwib\007th.lwud\010th.lwuia\010"
    "th.lwuib\007th.mula\010th.mulah\010th.mulaw\007th.muls\010th.mulsh\010t"
    "h.mulsw\010th.mveqz\010th.mvnez\006th.rev\007th.revw\007th.sbia\007th.s"
    "bib\006th.sdd\007th.sdia\007th.sdib\016th.sfence.vmas\007th.shia\007th."
    "shib\006th.srb\006th.srd\006th.srh\007th.srri\010th.srriw\006th.srw\007"
    "th.surb\007th.surd\007th.surh\007th.surw\006th.swd\007th.swia\007th.swi"
    "b\007th.sync\tth.sync.i\nth.sync.is\tth.sync.s\006th.tst\tth.tstnbz\013"
    "th.vmaqa.vv\013th.vmaqa.vx\015th.vmaqasu.vv\015th.vmaqasu.vx\014th.vmaq"
    "au.vv\014th.vmaqau.vx\015th.vmaqaus.vx\005unimp\005unzip\010vaadd.vv\010"
    "vaadd.vx\tvaaddu.vv\tvaaddu.vx\010vadc.vim\010vadc.vvm\010vadc.vxm\007v"
    "add.vi\007vadd.vv\007vadd.vx\tvaesdf.vs\tvaesdf.vv\tvaesdm.vs\tvaesdm.v"
    "v\tvaesef.vs\tvaesef.vv\tvaesem.vs\tvaesem.vv\nvaeskf1.vi\nvaeskf2.vi\010"
    "vaesz.vs\007vand.vi\007vand.vv\007vand.vx\010vandn.vv\010vandn.vx\010va"
    "sub.vv\010vasub.vx\tvasubu.vv\tvasubu.vx\007vbrev.v\010vbrev8.v\tvclmul"
    ".vv\tvclmul.vx\nvclmulh.vv\nvclmulh.vx\006vclz.v\014vcompress.vm\007vcp"
    "op.m\007vcpop.v\006vctz.v\007vdiv.vv\007vdiv.vx\010vdivu.vv\010vdivu.vx"
    "\007vfabs.v\010vfadd.vf\010vfadd.vv\tvfclass.v\013vfcvt.f.x.v\014vfcvt."
    "f.xu.v\017vfcvt.rtz.x.f.v\020vfcvt.rtz.xu.f.v\013vfcvt.x.f.v\014vfcvt.x"
    "u.f.v\010vfdiv.vf\010vfdiv.vv\010vfirst.m\tvfmacc.vf\tvfmacc.vv\tvfmadd"
    ".vf\tvfmadd.vv\010vfmax.vf\010vfmax.vv\013vfmerge.vfm\010vfmin.vf\010vf"
    "min.vv\tvfmsac.vf\tvfmsac.vv\tvfmsub.vf\tvfmsub.vv\010vfmul.vf\010vfmul"
    ".vv\010vfmv.f.s\010vfmv.s.f\010vfmv.v.f\014vfncvt.f.f.w\014vfncvt.f.x.w"
    "\015vfncvt.f.xu.w\020vfncvt.rod.f.f.w\020vfncvt.rtz.x.f.w\021vfncvt.rtz"
    ".xu.f.w\014vfncvt.x.f.w\015vfncvt.xu.f.w\020vfncvtbf16.f.f.w\007vfneg.v"
    "\nvfnmacc.vf\nvfnmacc.vv\nvfnmadd.vf\nvfnmadd.vv\nvfnmsac.vf\nvfnmsac.v"
    "v\nvfnmsub.vf\nvfnmsub.vv\tvfrdiv.vf\010vfrec7.v\013vfredmax.vs\013vfre"
    "dmin.vs\014vfredosum.vs\013vfredsum.vs\014vfredusum.vs\nvfrsqrt7.v\tvfr"
    "sub.vf\tvfsgnj.vf\tvfsgnj.vv\nvfsgnjn.vf\nvfsgnjn.vv\nvfsgnjx.vf\nvfsgn"
    "jx.vv\017vfslide1down.vf\015vfslide1up.vf\010vfsqrt.v\010vfsub.vf\010vf"
    "sub.vv\tvfwadd.vf\tvfwadd.vv\tvfwadd.wf\tvfwadd.wv\014vfwcvt.f.f.v\014v"
    "fwcvt.f.x.v\015vfwcvt.f.xu.v\020vfwcvt.rtz.x.f.v\021vfwcvt.rtz.xu.f.v\014"
    "vfwcvt.x.f.v\015vfwcvt.xu.f.v\020vfwcvtbf16.f.f.v\nvfwmacc.vf\nvfwmacc."
    "vv\016vfwmaccbf16.vf\016vfwmaccbf16.vv\nvfwmsac.vf\nvfwmsac.vv\tvfwmul."
    "vf\tvfwmul.vv\013vfwnmacc.vf\013vfwnmacc.vv\013vfwnmsac.vf\013vfwnmsac."
    "vv\015vfwredosum.vs\014vfwredsum.vs\015vfwredusum.vs\tvfwsub.vf\tvfwsub"
    ".vv\tvfwsub.wf\tvfwsub.wv\010vghsh.vv\010vgmul.vv\005vid.v\007viota.m\006"
    "vl1r.v\tvl1re16.v\tvl1re32.v\tvl1re64.v\010vl1re8.v\006vl2r.v\tvl2re16."
    "v\tvl2re32.v\tvl2re64.v\010vl2re8.v\006vl4r.v\tvl4re16.v\tvl4re32.v\tvl"
    "4re64.v\010vl4re8.v\006vl8r.v\tvl8re16.v\tvl8re32.v\tvl8re64.v\010vl8re"
    "8.v\006vle1.v\007vle16.v\tvle16ff.v\007vle32.v\tvle32ff.v\007vle64.v\tv"
    "le64ff.v\006vle8.v\010vle8ff.v\005vlm.v\nvloxei16.v\nvloxei32.v\nvloxei"
    "64.v\tvloxei8.v\016vloxseg2ei16.v\016vloxseg2ei32.v\016vloxseg2ei64.v\015"
    "vloxseg2ei8.v\016vloxseg3ei16.v\016vloxseg3ei32.v\016vloxseg3ei64.v\015"
    "vloxseg3ei8.v\016vloxseg4ei16.v\016vloxseg4ei32.v\016vloxseg4ei64.v\015"
    "vloxseg4ei8.v\016vloxseg5ei16.v\016vloxseg5ei32.v\016vloxseg5ei64.v\015"
    "vloxseg5ei8.v\016vloxseg6ei16.v\016vloxseg6ei32.v\016vloxseg6ei64.v\015"
    "vloxseg6ei8.v\016vloxseg7ei16.v\016vloxseg7ei32.v\016vloxseg7ei64.v\015"
    "vloxseg7ei8.v\016vloxseg8ei16.v\016vloxseg8ei32.v\016vloxseg8ei64.v\015"
    "vloxseg8ei8.v\010vlse16.v\010vlse32.v\010vlse64.v\007vlse8.v\013vlseg2e"
    "16.v\015vlseg2e16ff.v\013vlseg2e32.v\015vlseg2e32ff.v\013vlseg2e64.v\015"
    "vlseg2e64ff.v\nvlseg2e8.v\014vlseg2e8ff.v\013vlseg3e16.v\015vlseg3e16ff"
    ".v\013vlseg3e32.v\015vlseg3e32ff.v\013vlseg3e64.v\015vlseg3e64ff.v\nvls"
    "eg3e8.v\014vlseg3e8ff.v\013vlseg4e16.v\015vlseg4e16ff.v\013vlseg4e32.v\015"
    "vlseg4e32ff.v\013vlseg4e64.v\015vlseg4e64ff.v\nvlseg4e8.v\014vlseg4e8ff"
    ".v\013vlseg5e16.v\015vlseg5e16ff.v\013vlseg5e32.v\015vlseg5e32ff.v\013v"
    "lseg5e64.v\015vlseg5e64ff.v\nvlseg5e8.v\014vlseg5e8ff.v\013vlseg6e16.v\015"
    "vlseg6e16ff.v\013vlseg6e32.v\015vlseg6e32ff.v\013vlseg6e64.v\015vlseg6e"
    "64ff.v\nvlseg6e8.v\014vlseg6e8ff.v\013vlseg7e16.v\015vlseg7e16ff.v\013v"
    "lseg7e32.v\015vlseg7e32ff.v\013vlseg7e64.v\015vlseg7e64ff.v\nvlseg7e8.v"
    "\014vlseg7e8ff.v\013vlseg8e16.v\015vlseg8e16ff.v\013vlseg8e32.v\015vlse"
    "g8e32ff.v\013vlseg8e64.v\015vlseg8e64ff.v\nvlseg8e8.v\014vlseg8e8ff.v\014"
    "vlsseg2e16.v\014vlsseg2e32.v\014vlsseg2e64.v\013vlsseg2e8.v\014vlsseg3e"
    "16.v\014vlsseg3e32.v\014vlsseg3e64.v\013vlsseg3e8.v\014vlsseg4e16.v\014"
    "vlsseg4e32.v\014vlsseg4e64.v\013vlsseg4e8.v\014vlsseg5e16.v\014vlsseg5e"
    "32.v\014vlsseg5e64.v\013vlsseg5e8.v\014vlsseg6e16.v\014vlsseg6e32.v\014"
    "vlsseg6e64.v\013vlsseg6e8.v\014vlsseg7e16.v\014vlsseg7e32.v\014vlsseg7e"
    "64.v\013vlsseg7e8.v\014vlsseg8e16.v\014vlsseg8e32.v\014vlsseg8e64.v\013"
    "vlsseg8e8.v\nvluxei16.v\nvluxei32.v\nvluxei64.v\tvluxei8.v\016vluxseg2e"
    "i16.v\016vluxseg2ei32.v\016vluxseg2ei64.v\015vluxseg2ei8.v\016vluxseg3e"
    "i16.v\016vluxseg3ei32.v\016vluxseg3ei64.v\015vluxseg3ei8.v\016vluxseg4e"
    "i16.v\016vluxseg4ei32.v\016vluxseg4ei64.v\015vluxseg4ei8.v\016vluxseg5e"
    "i16.v\016vluxseg5ei32.v\016vluxseg5ei64.v\015vluxseg5ei8.v\016vluxseg6e"
    "i16.v\016vluxseg6ei32.v\016vluxseg6ei64.v\015vluxseg6ei8.v\016vluxseg7e"
    "i16.v\016vluxseg7ei32.v\016vluxseg7ei64.v\015vluxseg7ei8.v\016vluxseg8e"
    "i16.v\016vluxseg8ei32.v\016vluxseg8ei64.v\015vluxseg8ei8.v\010vmacc.vv\010"
    "vmacc.vx\010vmadc.vi\tvmadc.vim\010vmadc.vv\tvmadc.vvm\010vmadc.vx\tvma"
    "dc.vxm\010vmadd.vv\010vmadd.vx\010vmand.mm\tvmandn.mm\013vmandnot.mm\007"
    "vmax.vv\007vmax.vx\010vmaxu.vv\010vmaxu.vx\007vmclr.m\nvmerge.vim\nvmer"
    "ge.vvm\nvmerge.vxm\010vmfeq.vf\010vmfeq.vv\010vmfge.vf\010vmfge.vv\010v"
    "mfgt.vf\010vmfgt.vv\010vmfle.vf\010vmfle.vv\010vmflt.vf\010vmflt.vv\010"
    "vmfne.vf\010vmfne.vv\007vmin.vv\007vmin.vx\010vminu.vv\010vminu.vx\006v"
    "mmv.m\tvmnand.mm\010vmnor.mm\007vmnot.m\007vmor.mm\010vmorn.mm\nvmornot"
    ".mm\010vmsbc.vv\tvmsbc.vvm\010vmsbc.vx\tvmsbc.vxm\007vmsbf.m\010vmseq.v"
    "i\010vmseq.vv\010vmseq.vx\007vmset.m\010vmsge.vi\010vmsge.vv\010vmsge.v"
    "x\tvmsgeu.vi\tvmsgeu.vv\tvmsgeu.vx\010vmsgt.vi\010vmsgt.vv\010vmsgt.vx\t"
    "vmsgtu.vi\tvmsgtu.vv\tvmsgtu.vx\007vmsif.m\010vmsle.vi\010vmsle.vv\010v"
    "msle.vx\tvmsleu.vi\tvmsleu.vv\tvmsleu.vx\010vmslt.vi\010vmslt.vv\010vms"
    "lt.vx\tvmsltu.vi\tvmsltu.vv\tvmsltu.vx\010vmsne.vi\010vmsne.vv\010vmsne"
    ".vx\007vmsof.m\007vmul.vv\007vmul.vx\010vmulh.vv\010vmulh.vx\nvmulhsu.v"
    "v\nvmulhsu.vx\tvmulhu.vv\tvmulhu.vx\007vmv.s.x\007vmv.v.i\007vmv.v.v\007"
    "vmv.v.x\007vmv.x.s\007vmv1r.v\007vmv2r.v\007vmv4r.v\007vmv8r.v\tvmxnor."
    "mm\010vmxor.mm\tvnclip.wi\tvnclip.wv\tvnclip.wx\nvnclipu.wi\nvnclipu.wv"
    "\nvnclipu.wx\013vncvt.x.x.w\006vneg.v\tvnmsac.vv\tvnmsac.vx\tvnmsub.vv\t"
    "vnmsub.vx\006vnot.v\010vnsra.wi\010vnsra.wv\010vnsra.wx\010vnsrl.wi\010"
    "vnsrl.wv\010vnsrl.wx\006vor.vi\006vor.vv\006vor.vx\007vpopc.m\nvredand."
    "vs\nvredmax.vs\013vredmaxu.vs\nvredmin.vs\013vredminu.vs\tvredor.vs\nvr"
    "edsum.vs\nvredxor.vs\007vrem.vv\007vrem.vx\010vremu.vv\010vremu.vx\007v"
    "rev8.v\013vrgather.vi\013vrgather.vv\013vrgather.vx\017vrgatherei16.vv\007"
    "vrol.vv\007vrol.vx\007vror.vi\007vror.vv\007vror.vx\010vrsub.vi\010vrsu"
    "b.vx\006vs1r.v\006vs2r.v\006vs4r.v\006vs8r.v\010vsadd.vi\010vsadd.vv\010"
    "vsadd.vx\tvsaddu.vi\tvsaddu.vv\tvsaddu.vx\010vsbc.vvm\010vsbc.vxm\006vs"
    "e1.v\007vse16.v\007vse32.v\007vse64.v\006vse8.v\010vsetivli\006vsetvl\007"
    "vsetvli\tvsext.vf2\tvsext.vf4\tvsext.vf8\nvsha2ch.vv\nvsha2cl.vv\nvsha2"
    "ms.vv\016vslide1down.vx\014vslide1up.vx\015vslidedown.vi\015vslidedown."
    "vx\013vslideup.vi\013vslideup.vx\007vsll.vi\007vsll.vv\007vsll.vx\005vs"
    "m.v\010vsm3c.vi\tvsm3me.vv\010vsm4k.vi\010vsm4r.vs\010vsm4r.vv\010vsmul"
    ".vv\010vsmul.vx\nvsoxei16.v\nvsoxei32.v\nvsoxei64.v\tvsoxei8.v\016vsoxs"
    "eg2ei16.v\016vsoxseg2ei32.v\016vsoxseg2ei64.v\015vsoxseg2ei8.v\016vsoxs"
    "eg3ei16.v\016vsoxseg3ei32.v\016vsoxseg3ei64.v\015vsoxseg3ei8.v\016vsoxs"
    "eg4ei16.v\016vsoxseg4ei32.v\016vsoxseg4ei64.v\015vsoxseg4ei8.v\016vsoxs"
    "eg5ei16.v\016vsoxseg5ei32.v\016vsoxseg5ei64.v\015vsoxseg5ei8.v\016vsoxs"
    "eg6ei16.v\016vsoxseg6ei32.v\016vsoxseg6ei64.v\015vsoxseg6ei8.v\016vsoxs"
    "eg7ei16.v\016vsoxseg7ei32.v\016vsoxseg7ei64.v\015vsoxseg7ei8.v\016vsoxs"
    "eg8ei16.v\016vsoxseg8ei32.v\016vsoxseg8ei64.v\015vsoxseg8ei8.v\007vsra."
    "vi\007vsra.vv\007vsra.vx\007vsrl.vi\007vsrl.vv\007vsrl.vx\010vsse16.v\010"
    "vsse32.v\010vsse64.v\007vsse8.v\013vsseg2e16.v\013vsseg2e32.v\013vsseg2"
    "e64.v\nvsseg2e8.v\013vsseg3e16.v\013vsseg3e32.v\013vsseg3e64.v\nvsseg3e"
    "8.v\013vsseg4e16.v\013vsseg4e32.v\013vsseg4e64.v\nvsseg4e8.v\013vsseg5e"
    "16.v\013vsseg5e32.v\013vsseg5e64.v\nvsseg5e8.v\013vsseg6e16.v\013vsseg6"
    "e32.v\013vsseg6e64.v\nvsseg6e8.v\013vsseg7e16.v\013vsseg7e32.v\013vsseg"
    "7e64.v\nvsseg7e8.v\013vsseg8e16.v\013vsseg8e32.v\013vsseg8e64.v\nvsseg8"
    "e8.v\010vssra.vi\010vssra.vv\010vssra.vx\010vssrl.vi\010vssrl.vv\010vss"
    "rl.vx\014vssseg2e16.v\014vssseg2e32.v\014vssseg2e64.v\013vssseg2e8.v\014"
    "vssseg3e16.v\014vssseg3e32.v\014vssseg3e64.v\013vssseg3e8.v\014vssseg4e"
    "16.v\014vssseg4e32.v\014vssseg4e64.v\013vssseg4e8.v\014vssseg5e16.v\014"
    "vssseg5e32.v\014vssseg5e64.v\013vssseg5e8.v\014vssseg6e16.v\014vssseg6e"
    "32.v\014vssseg6e64.v\013vssseg6e8.v\014vssseg7e16.v\014vssseg7e32.v\014"
    "vssseg7e64.v\013vssseg7e8.v\014vssseg8e16.v\014vssseg8e32.v\014vssseg8e"
    "64.v\013vssseg8e8.v\010vssub.vv\010vssub.vx\tvssubu.vv\tvssubu.vx\007vs"
    "ub.vv\007vsub.vx\nvsuxei16.v\nvsuxei32.v\nvsuxei64.v\tvsuxei8.v\016vsux"
    "seg2ei16.v\016vsuxseg2ei32.v\016vsuxseg2ei64.v\015vsuxseg2ei8.v\016vsux"
    "seg3ei16.v\016vsuxseg3ei32.v\016vsuxseg3ei64.v\015vsuxseg3ei8.v\016vsux"
    "seg4ei16.v\016vsuxseg4ei32.v\016vsuxseg4ei64.v\015vsuxseg4ei8.v\016vsux"
    "seg5ei16.v\016vsuxseg5ei32.v\016vsuxseg5ei64.v\015vsuxseg5ei8.v\016vsux"
    "seg6ei16.v\016vsuxseg6ei32.v\016vsuxseg6ei64.v\015vsuxseg6ei8.v\016vsux"
    "seg7ei16.v\016vsuxseg7ei32.v\016vsuxseg7ei64.v\015vsuxseg7ei8.v\016vsux"
    "seg8ei16.v\016vsuxseg8ei32.v\016vsuxseg8ei64.v\015vsuxseg8ei8.v\010vt.m"
    "askc\tvt.maskcn\010vwadd.vv\010vwadd.vx\010vwadd.wv\010vwadd.wx\tvwaddu"
    ".vv\tvwaddu.vx\tvwaddu.wv\tvwaddu.wx\013vwcvt.x.x.v\014vwcvtu.x.x.v\tvw"
    "macc.vv\tvwmacc.vx\013vwmaccsu.vv\013vwmaccsu.vx\nvwmaccu.vv\nvwmaccu.v"
    "x\013vwmaccus.vx\010vwmul.vv\010vwmul.vx\nvwmulsu.vv\nvwmulsu.vx\tvwmul"
    "u.vv\tvwmulu.vx\013vwredsum.vs\014vwredsumu.vs\010vwsll.vi\010vwsll.vv\010"
    "vwsll.vx\010vwsub.vv\010vwsub.vx\010vwsub.wv\010vwsub.wx\tvwsubu.vv\tvw"
    "subu.vx\tvwsubu.wv\tvwsubu.wx\007vxor.vi\007vxor.vv\007vxor.vx\tvzext.v"
    "f2\tvzext.vf4\tvzext.vf8\003wfi\007wrs.nto\007wrs.sto\004xnor\003xor\004"
    "xori\006xperm4\006xperm8\006zext.b\006zext.h\006zext.w\003zip";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasHalfFPLoadStoreMove,
  AMFBS_HasStdExtA,
  AMFBS_HasStdExtCOrZca,
  AMFBS_HasStdExtD,
  AMFBS_HasStdExtF,
  AMFBS_HasStdExtH,
  AMFBS_HasStdExtM,
  AMFBS_HasStdExtMOrZmmul,
  AMFBS_HasStdExtSvinval,
  AMFBS_HasStdExtZacas,
  AMFBS_HasStdExtZawrs,
  AMFBS_HasStdExtZba,
  AMFBS_HasStdExtZbb,
  AMFBS_HasStdExtZbbOrZbkb,
  AMFBS_HasStdExtZbc,
  AMFBS_HasStdExtZbcOrZbkc,
  AMFBS_HasStdExtZbkb,
  AMFBS_HasStdExtZbkx,
  AMFBS_HasStdExtZbs,
  AMFBS_HasStdExtZcb,
  AMFBS_HasStdExtZcmp,
  AMFBS_HasStdExtZcmt,
  AMFBS_HasStdExtZfa,
  AMFBS_HasStdExtZfbfmin,
  AMFBS_HasStdExtZfh,
  AMFBS_HasStdExtZfhOrZfhmin,
  AMFBS_HasStdExtZfinx,
  AMFBS_HasStdExtZhinx,
  AMFBS_HasStdExtZhinxOrZhinxmin,
  AMFBS_HasStdExtZicbom,
  AMFBS_HasStdExtZicbop,
  AMFBS_HasStdExtZicboz,
  AMFBS_HasStdExtZicond,
  AMFBS_HasStdExtZihintntl,
  AMFBS_HasStdExtZihintpause,
  AMFBS_HasStdExtZknh,
  AMFBS_HasStdExtZksed,
  AMFBS_HasStdExtZksh,
  AMFBS_HasStdExtZvbb,
  AMFBS_HasStdExtZvbc,
  AMFBS_HasStdExtZvfbfmin,
  AMFBS_HasStdExtZvfbfwma,
  AMFBS_HasStdExtZvkg,
  AMFBS_HasStdExtZvkned,
  AMFBS_HasStdExtZvknha,
  AMFBS_HasStdExtZvksed,
  AMFBS_HasStdExtZvksh,
  AMFBS_HasVInstructions,
  AMFBS_HasVInstructionsAnyF,
  AMFBS_HasVInstructionsI64,
  AMFBS_HasVendorXSfcie,
  AMFBS_HasVendorXSfvcp,
  AMFBS_HasVendorXTHeadBa,
  AMFBS_HasVendorXTHeadBb,
  AMFBS_HasVendorXTHeadBs,
  AMFBS_HasVendorXTHeadCmo,
  AMFBS_HasVendorXTHeadCondMov,
  AMFBS_HasVendorXTHeadMac,
  AMFBS_HasVendorXTHeadMemIdx,
  AMFBS_HasVendorXTHeadMemPair,
  AMFBS_HasVendorXTHeadSync,
  AMFBS_HasVendorXTHeadVdot,
  AMFBS_IsRV32,
  AMFBS_IsRV64,
  AMFBS_HasStdExtA_IsRV64,
  AMFBS_HasStdExtCOrZca_HasRVCHints,
  AMFBS_HasStdExtCOrZca_IsRV32,
  AMFBS_HasStdExtCOrZca_IsRV64,
  AMFBS_HasStdExtCOrZcd_HasStdExtD,
  AMFBS_HasStdExtD_IsRV64,
  AMFBS_HasStdExtF_IsRV64,
  AMFBS_HasStdExtM_IsRV64,
  AMFBS_HasStdExtMOrZmmul_IsRV64,
  AMFBS_HasStdExtZacas_IsRV64,
  AMFBS_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbb_IsRV64,
  AMFBS_HasStdExtZbbOrZbkb_IsRV32,
  AMFBS_HasStdExtZbbOrZbkb_IsRV64,
  AMFBS_HasStdExtZbkb_IsRV32,
  AMFBS_HasStdExtZbkb_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtMOrZmmul,
  AMFBS_HasStdExtZcb_HasStdExtZbb,
  AMFBS_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZdinx_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD,
  AMFBS_HasStdExtZfa_HasStdExtZfh,
  AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh,
  AMFBS_HasStdExtZfh_IsRV64,
  AMFBS_HasStdExtZfhOrZfhmin_HasStdExtD,
  AMFBS_HasStdExtZfinx_IsRV64,
  AMFBS_HasStdExtZhinx_IsRV64,
  AMFBS_HasStdExtZknd_IsRV32,
  AMFBS_HasStdExtZknd_IsRV64,
  AMFBS_HasStdExtZkndOrZkne_IsRV64,
  AMFBS_HasStdExtZkne_IsRV32,
  AMFBS_HasStdExtZkne_IsRV64,
  AMFBS_HasStdExtZknh_IsRV32,
  AMFBS_HasStdExtZknh_IsRV64,
  AMFBS_HasVInstructionsI64_IsRV64,
  AMFBS_HasVendorXCVbitmanip_IsRV32,
  AMFBS_HasVendorXCVmac_IsRV32,
  AMFBS_HasVendorXTHeadBb_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF,
  AMFBS_HasVendorXTHeadMac_IsRV64,
  AMFBS_HasVendorXTHeadMemIdx_IsRV64,
  AMFBS_HasVendorXTHeadMemPair_IsRV64,
  AMFBS_IsRV64_HasStdExtH,
  AMFBS_IsRV64_HasVInstructionsI64,
  AMFBS_IsRV64_HasVendorXVentanaCondOps,
  AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl,
  AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32,
  AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZdinx_IsRV64_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD_IsRV32,
  AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasHalfFPLoadStoreMoveBit, },
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtCOrZcaBit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtHBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtSvinvalBit, },
  {Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZawrsBit, },
  {Feature_HasStdExtZbaBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkbBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZcbBit, },
  {Feature_HasStdExtZcmpBit, },
  {Feature_HasStdExtZcmtBit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfbfminBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxOrZhinxminBit, },
  {Feature_HasStdExtZicbomBit, },
  {Feature_HasStdExtZicbopBit, },
  {Feature_HasStdExtZicbozBit, },
  {Feature_HasStdExtZicondBit, },
  {Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtZihintpauseBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasStdExtZvbbBit, },
  {Feature_HasStdExtZvbcBit, },
  {Feature_HasStdExtZvfbfminBit, },
  {Feature_HasStdExtZvfbfwmaBit, },
  {Feature_HasStdExtZvkgBit, },
  {Feature_HasStdExtZvknedBit, },
  {Feature_HasStdExtZvknhaBit, },
  {Feature_HasStdExtZvksedBit, },
  {Feature_HasStdExtZvkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXSfcieBit, },
  {Feature_HasVendorXSfvcpBit, },
  {Feature_HasVendorXTHeadBaBit, },
  {Feature_HasVendorXTHeadBbBit, },
  {Feature_HasVendorXTHeadBsBit, },
  {Feature_HasVendorXTHeadCmoBit, },
  {Feature_HasVendorXTHeadCondMovBit, },
  {Feature_HasVendorXTHeadMacBit, },
  {Feature_HasVendorXTHeadMemIdxBit, },
  {Feature_HasVendorXTHeadMemPairBit, },
  {Feature_HasVendorXTHeadSyncBit, },
  {Feature_HasVendorXTHeadVdotBit, },
  {Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_HasRVCHintsBit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcdBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhOrZvfhBit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfhOrZfhminBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_IsRV64Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemIdxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemPairBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_HasStdExtHBit, },
  {Feature_IsRV64Bit, Feature_HasVInstructionsI64Bit, },
  {Feature_IsRV64Bit, Feature_HasVendorXVentanaCondOpsBit, },
  {Feature_HasStdExtCBit, Feature_HasRVCHintsBit, Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtCOrZcfOrZceBit, Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxOrZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxOrZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, Feature_IsRV64Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint8_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[7];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* .insn_b */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 8 /* .insn_ca */, RISCV::InsnCA, Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm6, MCK_UImm2, MCK_AnyRegCOperand, MCK_AnyRegCOperand }, },
  { 17 /* .insn_cb */, RISCV::InsnCB, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_SImm9Lsb0 }, },
  { 26 /* .insn_ci */, RISCV::InsnCI, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_SImm6 }, },
  { 35 /* .insn_ciw */, RISCV::InsnCIW, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm8 }, },
  { 45 /* .insn_cj */, RISCV::InsnCJ, Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_SImm12Lsb0 }, },
  { 54 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 63 /* .insn_cr */, RISCV::InsnCR, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm4, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 72 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 81 /* .insn_css */, RISCV::InsnCSS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_UImm6 }, },
  { 91 /* .insn_i */, RISCV::InsnI, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm12 }, },
  { 91 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 99 /* .insn_j */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 107 /* .insn_r */, RISCV::InsnR, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm7, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 107 /* .insn_r */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 115 /* .insn_r4 */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 124 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 132 /* .insn_sb */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 141 /* .insn_u */, RISCV::InsnU, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_UImm20LUI }, },
  { 149 /* .insn_uj */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 158 /* add */, RISCV::ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 158 /* add */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 158 /* add */, RISCV::PseudoAddTPRel, Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_TPRelAddSymbol }, },
  { 162 /* add.uw */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 169 /* addi */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 174 /* addiw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 180 /* addw */, RISCV::ADDW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 180 /* addw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 185 /* aes32dsi */, RISCV::AES32DSI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 194 /* aes32dsmi */, RISCV::AES32DSMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 204 /* aes32esi */, RISCV::AES32ESI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 213 /* aes32esmi */, RISCV::AES32ESMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 223 /* aes64ds */, RISCV::AES64DS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 231 /* aes64dsm */, RISCV::AES64DSM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 240 /* aes64es */, RISCV::AES64ES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 248 /* aes64esm */, RISCV::AES64ESM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 257 /* aes64im */, RISCV::AES64IM, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 265 /* aes64ks1i */, RISCV::AES64KS1I, Convert__Reg1_0__Reg1_1__RnumArg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_RnumArg }, },
  { 275 /* aes64ks2 */, RISCV::AES64KS2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 284 /* amoadd.d */, RISCV::AMOADD_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 293 /* amoadd.d.aq */, RISCV::AMOADD_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 305 /* amoadd.d.aqrl */, RISCV::AMOADD_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 319 /* amoadd.d.rl */, RISCV::AMOADD_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 331 /* amoadd.w */, RISCV::AMOADD_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 340 /* amoadd.w.aq */, RISCV::AMOADD_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 352 /* amoadd.w.aqrl */, RISCV::AMOADD_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 366 /* amoadd.w.rl */, RISCV::AMOADD_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 378 /* amoand.d */, RISCV::AMOAND_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 387 /* amoand.d.aq */, RISCV::AMOAND_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 399 /* amoand.d.aqrl */, RISCV::AMOAND_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 413 /* amoand.d.rl */, RISCV::AMOAND_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 425 /* amoand.w */, RISCV::AMOAND_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 434 /* amoand.w.aq */, RISCV::AMOAND_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 446 /* amoand.w.aqrl */, RISCV::AMOAND_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 460 /* amoand.w.rl */, RISCV::AMOAND_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 472 /* amocas.d */, RISCV::AMOCAS_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 481 /* amocas.d.aq */, RISCV::AMOCAS_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 493 /* amocas.d.aqrl */, RISCV::AMOCAS_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 507 /* amocas.d.rl */, RISCV::AMOCAS_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 519 /* amocas.q */, RISCV::AMOCAS_Q, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 528 /* amocas.q.aq */, RISCV::AMOCAS_Q_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 540 /* amocas.q.aqrl */, RISCV::AMOCAS_Q_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 554 /* amocas.q.rl */, RISCV::AMOCAS_Q_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 566 /* amocas.w */, RISCV::AMOCAS_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 575 /* amocas.w.aq */, RISCV::AMOCAS_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 587 /* amocas.w.aqrl */, RISCV::AMOCAS_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 601 /* amocas.w.rl */, RISCV::AMOCAS_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 613 /* amomax.d */, RISCV::AMOMAX_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 622 /* amomax.d.aq */, RISCV::AMOMAX_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 634 /* amomax.d.aqrl */, RISCV::AMOMAX_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 648 /* amomax.d.rl */, RISCV::AMOMAX_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 660 /* amomax.w */, RISCV::AMOMAX_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 669 /* amomax.w.aq */, RISCV::AMOMAX_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 681 /* amomax.w.aqrl */, RISCV::AMOMAX_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 695 /* amomax.w.rl */, RISCV::AMOMAX_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 707 /* amomaxu.d */, RISCV::AMOMAXU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 717 /* amomaxu.d.aq */, RISCV::AMOMAXU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 730 /* amomaxu.d.aqrl */, RISCV::AMOMAXU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 745 /* amomaxu.d.rl */, RISCV::AMOMAXU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 758 /* amomaxu.w */, RISCV::AMOMAXU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 768 /* amomaxu.w.aq */, RISCV::AMOMAXU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 781 /* amomaxu.w.aqrl */, RISCV::AMOMAXU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 796 /* amomaxu.w.rl */, RISCV::AMOMAXU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 809 /* amomin.d */, RISCV::AMOMIN_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 818 /* amomin.d.aq */, RISCV::AMOMIN_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 830 /* amomin.d.aqrl */, RISCV::AMOMIN_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 844 /* amomin.d.rl */, RISCV::AMOMIN_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 856 /* amomin.w */, RISCV::AMOMIN_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 865 /* amomin.w.aq */, RISCV::AMOMIN_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 877 /* amomin.w.aqrl */, RISCV::AMOMIN_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 891 /* amomin.w.rl */, RISCV::AMOMIN_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 903 /* amominu.d */, RISCV::AMOMINU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 913 /* amominu.d.aq */, RISCV::AMOMINU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 926 /* amominu.d.aqrl */, RISCV::AMOMINU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 941 /* amominu.d.rl */, RISCV::AMOMINU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 954 /* amominu.w */, RISCV::AMOMINU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 964 /* amominu.w.aq */, RISCV::AMOMINU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 977 /* amominu.w.aqrl */, RISCV::AMOMINU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 992 /* amominu.w.rl */, RISCV::AMOMINU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1005 /* amoor.d */, RISCV::AMOOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1013 /* amoor.d.aq */, RISCV::AMOOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1024 /* amoor.d.aqrl */, RISCV::AMOOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1037 /* amoor.d.rl */, RISCV::AMOOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1048 /* amoor.w */, RISCV::AMOOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1056 /* amoor.w.aq */, RISCV::AMOOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1067 /* amoor.w.aqrl */, RISCV::AMOOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1080 /* amoor.w.rl */, RISCV::AMOOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1091 /* amoswap.d */, RISCV::AMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1101 /* amoswap.d.aq */, RISCV::AMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1114 /* amoswap.d.aqrl */, RISCV::AMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1129 /* amoswap.d.rl */, RISCV::AMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1142 /* amoswap.w */, RISCV::AMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1152 /* amoswap.w.aq */, RISCV::AMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1165 /* amoswap.w.aqrl */, RISCV::AMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1180 /* amoswap.w.rl */, RISCV::AMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1193 /* amoxor.d */, RISCV::AMOXOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1202 /* amoxor.d.aq */, RISCV::AMOXOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1214 /* amoxor.d.aqrl */, RISCV::AMOXOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1228 /* amoxor.d.rl */, RISCV::AMOXOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1240 /* amoxor.w */, RISCV::AMOXOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1249 /* amoxor.w.aq */, RISCV::AMOXOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1261 /* amoxor.w.aqrl */, RISCV::AMOXOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1275 /* amoxor.w.rl */, RISCV::AMOXOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1287 /* and */, RISCV::AND, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1287 /* and */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 1291 /* andi */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 1296 /* andn */, RISCV::ANDN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1301 /* auipc */, RISCV::AUIPC, Convert__Reg1_0__UImm20AUIPC1_1, AMFBS_None, { MCK_GPR, MCK_UImm20AUIPC }, },
  { 1307 /* bclr */, RISCV::BCLR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1307 /* bclr */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1312 /* bclri */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1318 /* beq */, RISCV::BEQ, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1322 /* beqz */, RISCV::BEQ, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1327 /* bext */, RISCV::BEXT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1327 /* bext */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1332 /* bexti */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1338 /* bge */, RISCV::BGE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1342 /* bgeu */, RISCV::BGEU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1347 /* bgez */, RISCV::BGE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1352 /* bgt */, RISCV::BLT, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1356 /* bgtu */, RISCV::BLTU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1361 /* bgtz */, RISCV::BLT, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1366 /* binv */, RISCV::BINV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1366 /* binv */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1371 /* binvi */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1377 /* ble */, RISCV::BGE, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1381 /* bleu */, RISCV::BGEU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1386 /* blez */, RISCV::BGE, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1391 /* blt */, RISCV::BLT, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1395 /* bltu */, RISCV::BLTU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1400 /* bltz */, RISCV::BLT, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1405 /* bne */, RISCV::BNE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1409 /* bnez */, RISCV::BNE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1414 /* brev8 */, RISCV::BREV8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR }, },
  { 1420 /* bset */, RISCV::BSET, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1420 /* bset */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1425 /* bseti */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1431 /* c.add */, RISCV::C_ADD_HINT, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 1431 /* c.add */, RISCV::C_ADD, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 1437 /* c.addi */, RISCV::C_ADDI_NOP, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRX0, MCK_ImmZero }, },
  { 1437 /* c.addi */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6NonZero }, },
  { 1437 /* c.addi */, RISCV::C_ADDI_HINT_IMM_ZERO, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRNoX0, MCK_ImmZero }, },
  { 1437 /* c.addi */, RISCV::C_ADDI, Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6NonZero }, },
  { 1444 /* c.addi16sp */, RISCV::C_ADDI16SP, Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_SP, MCK_SImm10Lsb0000NonZero }, },
  { 1455 /* c.addi4spn */, RISCV::C_ADDI4SPN, Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SP, MCK_UImm10Lsb00NonZero }, },
  { 1466 /* c.addiw */, RISCV::C_ADDIW, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 1474 /* c.addw */, RISCV::C_ADDW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 1481 /* c.and */, RISCV::C_AND, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1487 /* c.andi */, RISCV::C_ANDI, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm6 }, },
  { 1494 /* c.beqz */, RISCV::C_BEQZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 1501 /* c.bnez */, RISCV::C_BNEZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 1508 /* c.ebreak */, RISCV::C_EBREAK, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1517 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1517 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1523 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1523 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1531 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1531 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1537 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1537 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1545 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1545 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1551 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1551 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1559 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1559 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1565 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1565 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1573 /* c.j */, RISCV::C_J, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca, { MCK_SImm12Lsb0 }, },
  { 1577 /* c.jal */, RISCV::C_JAL, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca_IsRV32, { MCK_SImm12Lsb0 }, },
  { 1583 /* c.jalr */, RISCV::C_JALR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 1590 /* c.jr */, RISCV::C_JR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 1595 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1595 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1601 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1601 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1606 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1606 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1613 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1613 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1618 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1618 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1624 /* c.li */, RISCV::C_LI_HINT, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6 }, },
  { 1624 /* c.li */, RISCV::C_LI, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 1629 /* c.lui */, RISCV::C_LUI_HINT, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_CLUIImm }, },
  { 1629 /* c.lui */, RISCV::C_LUI, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0X2, MCK_CLUIImm }, },
  { 1635 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1635 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1640 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1640 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1647 /* c.mul */, RISCV::C_MUL, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZcb_HasStdExtMOrZmmul, { MCK_GPRC, MCK_GPRC }, },
  { 1653 /* c.mv */, RISCV::C_MV_HINT, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 1653 /* c.mv */, RISCV::C_MV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 1658 /* c.nop */, RISCV::C_NOP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1658 /* c.nop */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_0, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_SImm6NonZero }, },
  { 1664 /* c.not */, RISCV::C_NOT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 1670 /* c.ntl.all */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX5, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1680 /* c.ntl.p1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX2, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1689 /* c.ntl.pall */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX3, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1700 /* c.ntl.s1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX4, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1709 /* c.or */, RISCV::C_OR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1714 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1714 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1719 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1719 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1724 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1724 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPR, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1731 /* c.sext.b */, RISCV::C_SEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1740 /* c.sext.h */, RISCV::C_SEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1749 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1749 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1754 /* c.slli */, RISCV::C_SLLI_HINT, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_UImmLog2XLenNonZero }, },
  { 1754 /* c.slli */, RISCV::C_SLLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImmLog2XLenNonZero }, },
  { 1761 /* c.slli64 */, RISCV::C_SLLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPR }, },
  { 1770 /* c.srai */, RISCV::C_SRAI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 1777 /* c.srai64 */, RISCV::C_SRAI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 1786 /* c.srli */, RISCV::C_SRLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 1793 /* c.srli64 */, RISCV::C_SRLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 1802 /* c.sub */, RISCV::C_SUB, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1808 /* c.subw */, RISCV::C_SUBW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 1815 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1815 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1820 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1820 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPR, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1827 /* c.unimp */, RISCV::C_UNIMP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1835 /* c.xor */, RISCV::C_XOR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1841 /* c.zext.b */, RISCV::C_ZEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 1850 /* c.zext.h */, RISCV::C_ZEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1859 /* c.zext.w */, RISCV::C_ZEXT_W, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64, { MCK_GPRC }, },
  { 1868 /* call */, RISCV::PseudoCALL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 1868 /* call */, RISCV::PseudoCALLReg, Convert__Reg1_0__CallSymbol1_1, AMFBS_None, { MCK_GPR, MCK_CallSymbol }, },
  { 1873 /* cbo.clean */, RISCV::CBO_CLEAN, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1883 /* cbo.flush */, RISCV::CBO_FLUSH, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1893 /* cbo.inval */, RISCV::CBO_INVAL, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1903 /* cbo.zero */, RISCV::CBO_ZERO, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicboz, { MCK_ZeroOffsetMemOpOperand }, },
  { 1912 /* cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__regX0, AMFBS_HasVendorXSfcie, {  }, },
  { 1912 /* cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSfcie, { MCK_GPR }, },
  { 1926 /* cease */, RISCV::SF_CEASE, Convert_NoOperands, AMFBS_HasVendorXSfcie, {  }, },
  { 1932 /* cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__regX0, AMFBS_HasVendorXSfcie, {  }, },
  { 1932 /* cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSfcie, { MCK_GPR }, },
  { 1944 /* clmul */, RISCV::CLMUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1950 /* clmulh */, RISCV::CLMULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1957 /* clmulr */, RISCV::CLMULR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1964 /* clz */, RISCV::CLZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 1968 /* clzw */, RISCV::CLZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 1973 /* cm.jalt */, RISCV::CM_JALT, Convert__UImm8GE321_0, AMFBS_HasStdExtZcmt, { MCK_UImm8GE32 }, },
  { 1981 /* cm.jt */, RISCV::CM_JT, Convert__UImm51_0, AMFBS_HasStdExtZcmt, { MCK_UImm5 }, },
  { 1987 /* cm.mva01s */, RISCV::CM_MVA01S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 1997 /* cm.mvsa01 */, RISCV::CM_MVSA01, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 2007 /* cm.pop */, RISCV::CM_POP, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2014 /* cm.popret */, RISCV::CM_POPRET, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2024 /* cm.popretz */, RISCV::CM_POPRETZ, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2035 /* cm.push */, RISCV::CM_PUSH, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2043 /* cpop */, RISCV::CPOP, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 2048 /* cpopw */, RISCV::CPOPW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 2054 /* csrc */, RISCV::CSRRC, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2054 /* csrc */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2059 /* csrci */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2065 /* csrr */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__regX0, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister }, },
  { 2070 /* csrrc */, RISCV::CSRRC, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2070 /* csrrc */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2076 /* csrrci */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2083 /* csrrs */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2083 /* csrrs */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2089 /* csrrsi */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2096 /* csrrw */, RISCV::CSRRW, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2096 /* csrrw */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2102 /* csrrwi */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2109 /* csrs */, RISCV::CSRRS, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2109 /* csrs */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2114 /* csrsi */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2120 /* csrw */, RISCV::CSRRW, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2120 /* csrw */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2125 /* csrwi */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2131 /* ctz */, RISCV::CTZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 2135 /* ctzw */, RISCV::CTZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 2140 /* cv.bclr */, RISCV::CV_BCLR, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2148 /* cv.bclrr */, RISCV::CV_BCLRR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2157 /* cv.bitrev */, RISCV::CV_BITREV, Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm2, MCK_UImm5 }, },
  { 2167 /* cv.bset */, RISCV::CV_BSET, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2175 /* cv.bsetr */, RISCV::CV_BSETR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2184 /* cv.clb */, RISCV::CV_CLB, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2191 /* cv.cnt */, RISCV::CV_CNT, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2198 /* cv.extract */, RISCV::CV_EXTRACT, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2209 /* cv.extractr */, RISCV::CV_EXTRACTR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2221 /* cv.extractu */, RISCV::CV_EXTRACTU, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2233 /* cv.extractur */, RISCV::CV_EXTRACTUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2246 /* cv.ff1 */, RISCV::CV_FF1, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2253 /* cv.fl1 */, RISCV::CV_FL1, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2260 /* cv.insert */, RISCV::CV_INSERT, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2270 /* cv.insertr */, RISCV::CV_INSERTR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2281 /* cv.mac */, RISCV::CV_MAC, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2288 /* cv.machhsn */, RISCV::CV_MACHHSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2299 /* cv.machhsrn */, RISCV::CV_MACHHSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2311 /* cv.machhun */, RISCV::CV_MACHHUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2322 /* cv.machhurn */, RISCV::CV_MACHHURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2334 /* cv.macsn */, RISCV::CV_MACSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2343 /* cv.macsrn */, RISCV::CV_MACSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2353 /* cv.macun */, RISCV::CV_MACUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2362 /* cv.macurn */, RISCV::CV_MACURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2372 /* cv.msu */, RISCV::CV_MSU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2379 /* cv.mulhhs */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2389 /* cv.mulhhsn */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2400 /* cv.mulhhsrn */, RISCV::CV_MULHHSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2412 /* cv.mulhhu */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2422 /* cv.mulhhun */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2433 /* cv.mulhhurn */, RISCV::CV_MULHHURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2445 /* cv.muls */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2453 /* cv.mulsn */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2462 /* cv.mulsrn */, RISCV::CV_MULSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2472 /* cv.mulu */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2480 /* cv.mulun */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2489 /* cv.mulurn */, RISCV::CV_MULURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2499 /* cv.ror */, RISCV::CV_ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2506 /* czero.eqz */, RISCV::CZERO_EQZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2516 /* czero.nez */, RISCV::CZERO_NEZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2526 /* div */, RISCV::DIV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2530 /* divu */, RISCV::DIVU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2535 /* divuw */, RISCV::DIVUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2541 /* divw */, RISCV::DIVW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2546 /* dret */, RISCV::DRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 2551 /* ebreak */, RISCV::EBREAK, Convert_NoOperands, AMFBS_None, {  }, },
  { 2558 /* ecall */, RISCV::ECALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 2564 /* fabs.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 2564 /* fabs.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 2564 /* fabs.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 2571 /* fabs.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 2571 /* fabs.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 2578 /* fabs.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 2578 /* fabs.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 2585 /* fadd.d */, RISCV::FADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 2585 /* fadd.d */, RISCV::FADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2585 /* fadd.d */, RISCV::FADD_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2592 /* fadd.h */, RISCV::FADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 2592 /* fadd.h */, RISCV::FADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2599 /* fadd.s */, RISCV::FADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 2599 /* fadd.s */, RISCV::FADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2606 /* fclass.d */, RISCV::FCLASS_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64 }, },
  { 2606 /* fclass.d */, RISCV::FCLASS_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR }, },
  { 2606 /* fclass.d */, RISCV::FCLASS_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR }, },
  { 2615 /* fclass.h */, RISCV::FCLASS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16 }, },
  { 2615 /* fclass.h */, RISCV::FCLASS_H_INX, Convert__Reg1_0__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR }, },
  { 2624 /* fclass.s */, RISCV::FCLASS_S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 2624 /* fclass.s */, RISCV::FCLASS_S_INX, Convert__Reg1_0__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR }, },
  { 2633 /* fcvt.bf16.s */, RISCV::FCVT_BF16_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 2645 /* fcvt.d.h */, RISCV::FCVT_D_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfhOrZfhmin_HasStdExtD, { MCK_FPR64, MCK_FPR16 }, },
  { 2645 /* fcvt.d.h */, RISCV::FCVT_D_H_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR1_1, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR }, },
  { 2645 /* fcvt.d.h */, RISCV::FCVT_D_H_IN32X, Convert__GPRPF64AsFPR1_0__GPRAsFPR1_1, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRAsFPR }, },
  { 2654 /* fcvt.d.l */, RISCV::FCVT_D_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 2654 /* fcvt.d.l */, RISCV::FCVT_D_L_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2663 /* fcvt.d.lu */, RISCV::FCVT_D_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 2663 /* fcvt.d.lu */, RISCV::FCVT_D_LU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2673 /* fcvt.d.s */, RISCV::FCVT_D_S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR32 }, },
  { 2673 /* fcvt.d.s */, RISCV::FCVT_D_S_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR }, },
  { 2673 /* fcvt.d.s */, RISCV::FCVT_D_S_IN32X, Convert__GPRPF64AsFPR1_0__GPRAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRAsFPR }, },
  { 2682 /* fcvt.d.w */, RISCV::FCVT_D_W, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR }, },
  { 2682 /* fcvt.d.w */, RISCV::FCVT_D_W_INX, Convert__GPRF64AsFPR1_0__Reg1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR }, },
  { 2682 /* fcvt.d.w */, RISCV::FCVT_D_W_IN32X, Convert__GPRPF64AsFPR1_0__Reg1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPR }, },
  { 2691 /* fcvt.d.wu */, RISCV::FCVT_D_WU, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR }, },
  { 2691 /* fcvt.d.wu */, RISCV::FCVT_D_WU_INX, Convert__GPRF64AsFPR1_0__Reg1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR }, },
  { 2691 /* fcvt.d.wu */, RISCV::FCVT_D_WU_IN32X, Convert__GPRPF64AsFPR1_0__Reg1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPR }, },
  { 2701 /* fcvt.h.d */, RISCV::FCVT_H_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhOrZfhmin_HasStdExtD, { MCK_FPR16, MCK_FPR64, MCK_FRMArg }, },
  { 2701 /* fcvt.h.d */, RISCV::FCVT_H_D_INX, Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2701 /* fcvt.h.d */, RISCV::FCVT_H_D_IN32X, Convert__GPRAsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2710 /* fcvt.h.l */, RISCV::FCVT_H_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 2710 /* fcvt.h.l */, RISCV::FCVT_H_L_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2719 /* fcvt.h.lu */, RISCV::FCVT_H_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 2719 /* fcvt.h.lu */, RISCV::FCVT_H_LU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2729 /* fcvt.h.s */, RISCV::FCVT_H_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 2729 /* fcvt.h.s */, RISCV::FCVT_H_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxOrZhinxmin, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2738 /* fcvt.h.w */, RISCV::FCVT_H_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 2738 /* fcvt.h.w */, RISCV::FCVT_H_W_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2747 /* fcvt.h.wu */, RISCV::FCVT_H_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 2747 /* fcvt.h.wu */, RISCV::FCVT_H_WU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2757 /* fcvt.l.d */, RISCV::FCVT_L_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 2757 /* fcvt.l.d */, RISCV::FCVT_L_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2766 /* fcvt.l.h */, RISCV::FCVT_L_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 2766 /* fcvt.l.h */, RISCV::FCVT_L_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2775 /* fcvt.l.s */, RISCV::FCVT_L_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 2775 /* fcvt.l.s */, RISCV::FCVT_L_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2784 /* fcvt.lu.d */, RISCV::FCVT_LU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 2784 /* fcvt.lu.d */, RISCV::FCVT_LU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2794 /* fcvt.lu.h */, RISCV::FCVT_LU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 2794 /* fcvt.lu.h */, RISCV::FCVT_LU_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2804 /* fcvt.lu.s */, RISCV::FCVT_LU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 2804 /* fcvt.lu.s */, RISCV::FCVT_LU_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2814 /* fcvt.s.bf16 */, RISCV::FCVT_S_BF16, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArg }, },
  { 2826 /* fcvt.s.d */, RISCV::FCVT_S_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR32, MCK_FPR64, MCK_FRMArg }, },
  { 2826 /* fcvt.s.d */, RISCV::FCVT_S_D_INX, Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2826 /* fcvt.s.d */, RISCV::FCVT_S_D_IN32X, Convert__GPRAsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2835 /* fcvt.s.h */, RISCV::FCVT_S_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR32, MCK_FPR16 }, },
  { 2835 /* fcvt.s.h */, RISCV::FCVT_S_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1, AMFBS_HasStdExtZhinxOrZhinxmin, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 2844 /* fcvt.s.l */, RISCV::FCVT_S_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 2844 /* fcvt.s.l */, RISCV::FCVT_S_L_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2853 /* fcvt.s.lu */, RISCV::FCVT_S_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 2853 /* fcvt.s.lu */, RISCV::FCVT_S_LU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2863 /* fcvt.s.w */, RISCV::FCVT_S_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 2863 /* fcvt.s.w */, RISCV::FCVT_S_W_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2872 /* fcvt.s.wu */, RISCV::FCVT_S_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 2872 /* fcvt.s.wu */, RISCV::FCVT_S_WU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 2882 /* fcvt.w.d */, RISCV::FCVT_W_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 2882 /* fcvt.w.d */, RISCV::FCVT_W_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2882 /* fcvt.w.d */, RISCV::FCVT_W_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2891 /* fcvt.w.h */, RISCV::FCVT_W_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 2891 /* fcvt.w.h */, RISCV::FCVT_W_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2900 /* fcvt.w.s */, RISCV::FCVT_W_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 2900 /* fcvt.w.s */, RISCV::FCVT_W_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2909 /* fcvt.wu.d */, RISCV::FCVT_WU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 2909 /* fcvt.wu.d */, RISCV::FCVT_WU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2909 /* fcvt.wu.d */, RISCV::FCVT_WU_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2919 /* fcvt.wu.h */, RISCV::FCVT_WU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 2919 /* fcvt.wu.h */, RISCV::FCVT_WU_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2929 /* fcvt.wu.s */, RISCV::FCVT_WU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 2929 /* fcvt.wu.s */, RISCV::FCVT_WU_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2939 /* fcvtmod.w.d */, RISCV::FCVTMOD_W_D, Convert__Reg1_0__Reg1_1__RTZArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_RTZArg }, },
  { 2951 /* fdiv.d */, RISCV::FDIV_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 2951 /* fdiv.d */, RISCV::FDIV_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 2951 /* fdiv.d */, RISCV::FDIV_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 2958 /* fdiv.h */, RISCV::FDIV_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 2958 /* fdiv.h */, RISCV::FDIV_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2965 /* fdiv.s */, RISCV::FDIV_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 2965 /* fdiv.s */, RISCV::FDIV_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 2972 /* fence */, RISCV::FENCE, Convert__imm_95_15__imm_95_15, AMFBS_None, {  }, },
  { 2972 /* fence */, RISCV::FENCE, Convert__FenceArg1_0__FenceArg1_1, AMFBS_None, { MCK_FenceArg, MCK_FenceArg }, },
  { 2978 /* fence.i */, RISCV::FENCE_I, Convert_NoOperands, AMFBS_None, {  }, },
  { 2986 /* fence.tso */, RISCV::FENCE_TSO, Convert_NoOperands, AMFBS_None, {  }, },
  { 2996 /* feq.d */, RISCV::FEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 2996 /* feq.d */, RISCV::FEQ_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 2996 /* feq.d */, RISCV::FEQ_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3002 /* feq.h */, RISCV::FEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3002 /* feq.h */, RISCV::FEQ_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3008 /* feq.s */, RISCV::FEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3008 /* feq.s */, RISCV::FEQ_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3014 /* fge.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3014 /* fge.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3014 /* fge.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_2__GPRPF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3020 /* fge.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3020 /* fge.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3026 /* fge.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3026 /* fge.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3032 /* fgeq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3039 /* fgeq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3046 /* fgeq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3053 /* fgt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3053 /* fgt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3053 /* fgt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_2__GPRPF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3059 /* fgt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3059 /* fgt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3065 /* fgt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3065 /* fgt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3071 /* fgtq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3078 /* fgtq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3085 /* fgtq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3092 /* fld */, RISCV::PseudoFLD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 3092 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3092 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3096 /* fle.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3096 /* fle.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3096 /* fle.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3102 /* fle.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3102 /* fle.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3108 /* fle.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3108 /* fle.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3114 /* fleq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3121 /* fleq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3128 /* fleq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3135 /* flh */, RISCV::PseudoFLH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 3135 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3135 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3139 /* fli.d */, RISCV::FLI_D, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_LoadFPImm }, },
  { 3145 /* fli.h */, RISCV::FLI_H, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh, { MCK_FPR16, MCK_LoadFPImm }, },
  { 3151 /* fli.s */, RISCV::FLI_S, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_LoadFPImm }, },
  { 3157 /* flt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3157 /* flt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3157 /* flt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3163 /* flt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3163 /* flt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3169 /* flt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3169 /* flt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3175 /* fltq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 3182 /* fltq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 3189 /* fltq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 3196 /* flw */, RISCV::PseudoFLW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 3196 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3196 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3200 /* fmadd.d */, RISCV::FMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3200 /* fmadd.d */, RISCV::FMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3200 /* fmadd.d */, RISCV::FMADD_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3208 /* fmadd.h */, RISCV::FMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3208 /* fmadd.h */, RISCV::FMADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3216 /* fmadd.s */, RISCV::FMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3216 /* fmadd.s */, RISCV::FMADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3224 /* fmax.d */, RISCV::FMAX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3224 /* fmax.d */, RISCV::FMAX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3224 /* fmax.d */, RISCV::FMAX_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3231 /* fmax.h */, RISCV::FMAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3231 /* fmax.h */, RISCV::FMAX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3238 /* fmax.s */, RISCV::FMAX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3238 /* fmax.s */, RISCV::FMAX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3245 /* fmaxm.d */, RISCV::FMAXM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3253 /* fmaxm.h */, RISCV::FMAXM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3261 /* fmaxm.s */, RISCV::FMAXM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3269 /* fmin.d */, RISCV::FMIN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3269 /* fmin.d */, RISCV::FMIN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3269 /* fmin.d */, RISCV::FMIN_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3276 /* fmin.h */, RISCV::FMIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3276 /* fmin.h */, RISCV::FMIN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3283 /* fmin.s */, RISCV::FMIN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3283 /* fmin.s */, RISCV::FMIN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3290 /* fminm.d */, RISCV::FMINM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3298 /* fminm.h */, RISCV::FMINM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3306 /* fminm.s */, RISCV::FMINM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3314 /* fmsub.d */, RISCV::FMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3314 /* fmsub.d */, RISCV::FMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3314 /* fmsub.d */, RISCV::FMSUB_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3322 /* fmsub.h */, RISCV::FMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3322 /* fmsub.h */, RISCV::FMSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3330 /* fmsub.s */, RISCV::FMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3330 /* fmsub.s */, RISCV::FMSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3338 /* fmul.d */, RISCV::FMUL_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3338 /* fmul.d */, RISCV::FMUL_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3338 /* fmul.d */, RISCV::FMUL_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3345 /* fmul.h */, RISCV::FMUL_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3345 /* fmul.h */, RISCV::FMUL_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3352 /* fmul.s */, RISCV::FMUL_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3352 /* fmul.s */, RISCV::FMUL_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3359 /* fmv.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 3365 /* fmv.d.x */, RISCV::FMV_D_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR }, },
  { 3373 /* fmv.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 3373 /* fmv.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3379 /* fmv.h.x */, RISCV::FMV_H_X, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_GPR }, },
  { 3387 /* fmv.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 3393 /* fmv.w.x */, RISCV::FMV_W_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR }, },
  { 3401 /* fmv.x.d */, RISCV::FMV_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64 }, },
  { 3409 /* fmv.x.h */, RISCV::FMV_X_H, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_GPR, MCK_FPR16 }, },
  { 3417 /* fmv.x.w */, RISCV::FMV_X_W, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 3425 /* fmvh.x.d */, RISCV::FMVH_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_GPR, MCK_FPR64 }, },
  { 3434 /* fmvp.d.x */, RISCV::FMVP_D_X, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_FPR64, MCK_GPR, MCK_GPR }, },
  { 3443 /* fneg.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 3443 /* fneg.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3443 /* fneg.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3450 /* fneg.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 3450 /* fneg.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3457 /* fneg.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 3457 /* fneg.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3464 /* fnmadd.d */, RISCV::FNMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3464 /* fnmadd.d */, RISCV::FNMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3464 /* fnmadd.d */, RISCV::FNMADD_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3473 /* fnmadd.h */, RISCV::FNMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3473 /* fnmadd.h */, RISCV::FNMADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3482 /* fnmadd.s */, RISCV::FNMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3482 /* fnmadd.s */, RISCV::FNMADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3491 /* fnmsub.d */, RISCV::FNMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3491 /* fnmsub.d */, RISCV::FNMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3491 /* fnmsub.d */, RISCV::FNMSUB_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__GPRPF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3500 /* fnmsub.h */, RISCV::FNMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3500 /* fnmsub.h */, RISCV::FNMSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3509 /* fnmsub.s */, RISCV::FNMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3509 /* fnmsub.s */, RISCV::FNMSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3518 /* frcsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3524 /* frflags */, RISCV::CSRRS, Convert__Reg1_0__imm_95_1__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3532 /* fround.d */, RISCV::FROUND_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3541 /* fround.h */, RISCV::FROUND_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3550 /* fround.s */, RISCV::FROUND_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3559 /* froundnx.d */, RISCV::FROUNDNX_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3570 /* froundnx.h */, RISCV::FROUNDNX_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3581 /* froundnx.s */, RISCV::FROUNDNX_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3592 /* frrm */, RISCV::CSRRS, Convert__Reg1_0__imm_95_2__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3597 /* frsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3602 /* fscsr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3602 /* fscsr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 3608 /* fsd */, RISCV::PseudoFSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 3608 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3608 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3612 /* fsflags */, RISCV::CSRRW, Convert__regX0__imm_95_1__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3612 /* fsflags */, RISCV::CSRRW, Convert__Reg1_0__imm_95_1__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 3620 /* fsflagsi */, RISCV::CSRRWI, Convert__regX0__imm_95_1__UImm51_0, AMFBS_HasStdExtF, { MCK_UImm5 }, },
  { 3620 /* fsflagsi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_1__UImm51_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_UImm5 }, },
  { 3629 /* fsgnj.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3629 /* fsgnj.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3629 /* fsgnj.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3637 /* fsgnj.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3637 /* fsgnj.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3645 /* fsgnj.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3645 /* fsgnj.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3653 /* fsgnjn.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3653 /* fsgnjn.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3653 /* fsgnjn.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3662 /* fsgnjn.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3662 /* fsgnjn.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3671 /* fsgnjn.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3671 /* fsgnjn.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3680 /* fsgnjx.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 3680 /* fsgnjx.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 3680 /* fsgnjx.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR }, },
  { 3689 /* fsgnjx.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 3689 /* fsgnjx.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3698 /* fsgnjx.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 3698 /* fsgnjx.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 3707 /* fsh */, RISCV::PseudoFSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 3707 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhOrZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3707 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3711 /* fsqrt.d */, RISCV::FSQRT_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3711 /* fsqrt.d */, RISCV::FSQRT_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3711 /* fsqrt.d */, RISCV::FSQRT_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3719 /* fsqrt.h */, RISCV::FSQRT_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3719 /* fsqrt.h */, RISCV::FSQRT_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3727 /* fsqrt.s */, RISCV::FSQRT_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3727 /* fsqrt.s */, RISCV::FSQRT_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3735 /* fsrm */, RISCV::CSRRW, Convert__regX0__imm_95_2__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3735 /* fsrm */, RISCV::CSRRW, Convert__Reg1_0__imm_95_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 3740 /* fsrmi */, RISCV::CSRRWI, Convert__regX0__imm_95_2__UImm51_0, AMFBS_HasStdExtF, { MCK_UImm5 }, },
  { 3740 /* fsrmi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_2__UImm51_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_UImm5 }, },
  { 3746 /* fssr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 3746 /* fssr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 3751 /* fsub.d */, RISCV::FSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 3751 /* fsub.d */, RISCV::FSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 3751 /* fsub.d */, RISCV::FSUB_D_IN32X, Convert__GPRPF64AsFPR1_0__GPRPF64AsFPR1_1__GPRPF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_GPRPF64AsFPR, MCK_FRMArg }, },
  { 3758 /* fsub.h */, RISCV::FSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 3758 /* fsub.h */, RISCV::FSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3765 /* fsub.s */, RISCV::FSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 3765 /* fsub.s */, RISCV::FSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 3772 /* fsw */, RISCV::PseudoFSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 3772 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3772 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3776 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 3776 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 3776 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 3788 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 3788 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 3788 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 3800 /* hinval.gvma */, RISCV::HINVAL_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 3812 /* hinval.vvma */, RISCV::HINVAL_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 3824 /* hlv.b */, RISCV::HLV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3830 /* hlv.bu */, RISCV::HLV_BU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3837 /* hlv.d */, RISCV::HLV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3843 /* hlv.h */, RISCV::HLV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3849 /* hlv.hu */, RISCV::HLV_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3856 /* hlv.w */, RISCV::HLV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3862 /* hlv.wu */, RISCV::HLV_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3869 /* hlvx.hu */, RISCV::HLVX_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3877 /* hlvx.wu */, RISCV::HLVX_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3885 /* hsv.b */, RISCV::HSV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3891 /* hsv.d */, RISCV::HSV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3897 /* hsv.h */, RISCV::HSV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3903 /* hsv.w */, RISCV::HSV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3909 /* j */, RISCV::JAL, Convert__regX0__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 3911 /* jal */, RISCV::JAL, Convert__regX1__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 3911 /* jal */, RISCV::JAL, Convert__Reg1_0__SImm21Lsb0JAL1_1, AMFBS_None, { MCK_GPR, MCK_SImm21Lsb0JAL }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3915 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3920 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 3920 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 3920 /* jr */, RISCV::JALR, Convert__regX0__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3923 /* jump */, RISCV::PseudoJump, Convert__Reg1_1__PseudoJumpSymbol1_0, AMFBS_None, { MCK_PseudoJumpSymbol, MCK_GPR }, },
  { 3928 /* la */, RISCV::PseudoLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3928 /* la */, RISCV::PseudoLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 3931 /* la.tls.gd */, RISCV::PseudoLA_TLS_GD, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3941 /* la.tls.ie */, RISCV::PseudoLA_TLS_IE, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3951 /* lb */, RISCV::PseudoLB, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3951 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3951 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3954 /* lbu */, RISCV::PseudoLBU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3954 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3954 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3958 /* ld */, RISCV::PseudoLD, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 3958 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3958 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3961 /* lga */, RISCV::PseudoLGA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3965 /* lh */, RISCV::PseudoLH, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3965 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3965 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3968 /* lhu */, RISCV::PseudoLHU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3968 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3968 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3972 /* li */, RISCV::ADDI, Convert__Reg1_0__regX0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 3972 /* li */, RISCV::PseudoLI, Convert__Reg1_0__ImmXLenLI1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI }, },
  { 3975 /* lla */, RISCV::PseudoLLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 3975 /* lla */, RISCV::PseudoLLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 3979 /* lr.d */, RISCV::LR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3984 /* lr.d.aq */, RISCV::LR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 3992 /* lr.d.aqrl */, RISCV::LR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4002 /* lr.d.rl */, RISCV::LR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4010 /* lr.w */, RISCV::LR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4015 /* lr.w.aq */, RISCV::LR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4023 /* lr.w.aqrl */, RISCV::LR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4033 /* lr.w.rl */, RISCV::LR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4041 /* lui */, RISCV::LUI, Convert__Reg1_0__UImm20LUI1_1, AMFBS_None, { MCK_GPR, MCK_UImm20LUI }, },
  { 4045 /* lw */, RISCV::PseudoLW, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 4045 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4045 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4048 /* lwu */, RISCV::PseudoLWU, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 4048 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4048 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4052 /* max */, RISCV::MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4056 /* maxu */, RISCV::MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4061 /* min */, RISCV::MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4065 /* minu */, RISCV::MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4070 /* mret */, RISCV::MRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 4075 /* mul */, RISCV::MUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4079 /* mulh */, RISCV::MULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4084 /* mulhsu */, RISCV::MULHSU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4091 /* mulhu */, RISCV::MULHU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4097 /* mulw */, RISCV::MULW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4102 /* mv */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4105 /* neg */, RISCV::SUB, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4109 /* negw */, RISCV::SUBW, Convert__Reg1_0__regX0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4114 /* nop */, RISCV::ADDI, Convert__regX0__regX0__imm_95_0, AMFBS_None, {  }, },
  { 4118 /* not */, RISCV::XORI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4122 /* ntl.all */, RISCV::ADD, Convert__regX0__regX0__regX5, AMFBS_HasStdExtZihintntl, {  }, },
  { 4130 /* ntl.p1 */, RISCV::ADD, Convert__regX0__regX0__regX2, AMFBS_HasStdExtZihintntl, {  }, },
  { 4137 /* ntl.pall */, RISCV::ADD, Convert__regX0__regX0__regX3, AMFBS_HasStdExtZihintntl, {  }, },
  { 4146 /* ntl.s1 */, RISCV::ADD, Convert__regX0__regX0__regX4, AMFBS_HasStdExtZihintntl, {  }, },
  { 4153 /* or */, RISCV::OR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4153 /* or */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 4156 /* orc.b */, RISCV::ORC_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 4162 /* ori */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 4166 /* orn */, RISCV::ORN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4170 /* pack */, RISCV::PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4175 /* packh */, RISCV::PACKH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4181 /* packw */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4187 /* pause */, RISCV::FENCE, Convert__imm_95_1__imm_95_0, AMFBS_HasStdExtZihintpause, {  }, },
  { 4193 /* prefetch.i */, RISCV::PREFETCH_I, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4204 /* prefetch.r */, RISCV::PREFETCH_R, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4215 /* prefetch.w */, RISCV::PREFETCH_W, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4226 /* rdcycle */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3072__regX0, AMFBS_None, { MCK_GPR }, },
  { 4234 /* rdcycleh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3200__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 4243 /* rdinstret */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3074__regX0, AMFBS_None, { MCK_GPR }, },
  { 4253 /* rdinstreth */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3202__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 4264 /* rdtime */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3073__regX0, AMFBS_None, { MCK_GPR }, },
  { 4271 /* rdtimeh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3201__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 4279 /* rem */, RISCV::REM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4283 /* remu */, RISCV::REMU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4288 /* remuw */, RISCV::REMUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4294 /* remw */, RISCV::REMW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4299 /* ret */, RISCV::JALR, Convert__regX0__regX1__imm_95_0, AMFBS_None, {  }, },
  { 4303 /* rev8 */, RISCV::REV8_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4303 /* rev8 */, RISCV::REV8_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4308 /* rol */, RISCV::ROL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4312 /* rolw */, RISCV::ROLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4317 /* ror */, RISCV::ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4317 /* ror */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 4321 /* rori */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 4326 /* roriw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4332 /* rorw */, RISCV::RORW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4332 /* rorw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4337 /* sb */, RISCV::PseudoSB, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 4337 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4337 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4340 /* sc.d */, RISCV::SC_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4345 /* sc.d.aq */, RISCV::SC_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4353 /* sc.d.aqrl */, RISCV::SC_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4363 /* sc.d.rl */, RISCV::SC_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4371 /* sc.w */, RISCV::SC_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4376 /* sc.w.aq */, RISCV::SC_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4384 /* sc.w.aqrl */, RISCV::SC_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4394 /* sc.w.rl */, RISCV::SC_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 4402 /* sd */, RISCV::PseudoSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 4402 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4402 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4405 /* seqz */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__imm_95_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4410 /* sext.b */, RISCV::SEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 4410 /* sext.b */, RISCV::PseudoSEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4417 /* sext.h */, RISCV::SEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 4417 /* sext.h */, RISCV::PseudoSEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4424 /* sext.w */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4431 /* sf.vc.fv */, RISCV::VC_FV, Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_UImm5, MCK_VM, MCK_FPR32 }, },
  { 4440 /* sf.vc.fvv */, RISCV::VC_FVV, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 4450 /* sf.vc.fvw */, RISCV::VC_FVW, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 4460 /* sf.vc.i */, RISCV::VC_I, Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_SImm5 }, },
  { 4468 /* sf.vc.iv */, RISCV::VC_IV, Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 4477 /* sf.vc.ivv */, RISCV::VC_IVV, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 4487 /* sf.vc.ivw */, RISCV::VC_IVW, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 4497 /* sf.vc.v.fv */, RISCV::VC_V_FV, Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 4508 /* sf.vc.v.fvv */, RISCV::VC_V_FVV, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 4520 /* sf.vc.v.fvw */, RISCV::VC_V_FVW, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 4532 /* sf.vc.v.i */, RISCV::VC_V_I, Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 4542 /* sf.vc.v.iv */, RISCV::VC_V_IV, Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 4553 /* sf.vc.v.ivv */, RISCV::VC_V_IVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 4565 /* sf.vc.v.ivw */, RISCV::VC_V_IVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 4577 /* sf.vc.v.vv */, RISCV::VC_V_VV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 4588 /* sf.vc.v.vvv */, RISCV::VC_V_VVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 4600 /* sf.vc.v.vvw */, RISCV::VC_V_VVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 4612 /* sf.vc.v.x */, RISCV::VC_V_X, Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 4622 /* sf.vc.v.xv */, RISCV::VC_V_XV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 4633 /* sf.vc.v.xvv */, RISCV::VC_V_XVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 4645 /* sf.vc.v.xvw */, RISCV::VC_V_XVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 4657 /* sf.vc.vv */, RISCV::VC_VV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_VM }, },
  { 4666 /* sf.vc.vvv */, RISCV::VC_VVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 4676 /* sf.vc.vvw */, RISCV::VC_VVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 4686 /* sf.vc.x */, RISCV::VC_X, Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_GPR }, },
  { 4694 /* sf.vc.xv */, RISCV::VC_XV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 4703 /* sf.vc.xvv */, RISCV::VC_XVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 4713 /* sf.vc.xvw */, RISCV::VC_XVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 4723 /* sfence.inval.ir */, RISCV::SFENCE_INVAL_IR, Convert__imm_95_0__imm_95_0, AMFBS_HasStdExtSvinval, {  }, },
  { 4739 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 4739 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 4739 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4750 /* sfence.w.inval */, RISCV::SFENCE_W_INVAL, Convert__imm_95_0__imm_95_0, AMFBS_HasStdExtSvinval, {  }, },
  { 4765 /* sgt */, RISCV::SLT, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4769 /* sgtu */, RISCV::SLTU, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4774 /* sgtz */, RISCV::SLT, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 4779 /* sh */, RISCV::PseudoSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 4779 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4779 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4782 /* sh1add */, RISCV::SH1ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4789 /* sh1add.uw */, RISCV::SH1ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4799 /* sh2add */, RISCV::SH2ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4806 /* sh2add.uw */, RISCV::SH2ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4816 /* sh3add */, RISCV::SH3ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4823 /* sh3add.uw */, RISCV::SH3ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4833 /* sha256sig0 */, RISCV::SHA256SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 4844 /* sha256sig1 */, RISCV::SHA256SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 4855 /* sha256sum0 */, RISCV::SHA256SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 4866 /* sha256sum1 */, RISCV::SHA256SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 4877 /* sha512sig0 */, RISCV::SHA512SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4888 /* sha512sig0h */, RISCV::SHA512SIG0H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4900 /* sha512sig0l */, RISCV::SHA512SIG0L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4912 /* sha512sig1 */, RISCV::SHA512SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4923 /* sha512sig1h */, RISCV::SHA512SIG1H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4935 /* sha512sig1l */, RISCV::SHA512SIG1L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4947 /* sha512sum0 */, RISCV::SHA512SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4958 /* sha512sum0r */, RISCV::SHA512SUM0R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4970 /* sha512sum1 */, RISCV::SHA512SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 4981 /* sha512sum1r */, RISCV::SHA512SUM1R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4993 /* sinval.vma */, RISCV::SINVAL_VMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 5004 /* sll */, RISCV::SLL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5004 /* sll */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5008 /* slli */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5013 /* slli.uw */, RISCV::SLLI_UW, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5021 /* slliw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5027 /* sllw */, RISCV::SLLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5027 /* sllw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5032 /* slt */, RISCV::SLT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5032 /* slt */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 5036 /* slti */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 5041 /* sltiu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 5047 /* sltu */, RISCV::SLTU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5047 /* sltu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 5052 /* sltz */, RISCV::SLT, Convert__Reg1_0__Reg1_1__regX0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 5057 /* sm3p0 */, RISCV::SM3P0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 5063 /* sm3p1 */, RISCV::SM3P1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 5069 /* sm4ed */, RISCV::SM4ED, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5075 /* sm4ks */, RISCV::SM4KS, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5081 /* snez */, RISCV::SLTU, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 5086 /* sra */, RISCV::SRA, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5086 /* sra */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5090 /* srai */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5095 /* sraiw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5101 /* sraw */, RISCV::SRAW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5101 /* sraw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5106 /* sret */, RISCV::SRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 5111 /* srl */, RISCV::SRL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5111 /* srl */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5115 /* srli */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 5120 /* srliw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5126 /* srlw */, RISCV::SRLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5126 /* srlw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5131 /* sub */, RISCV::SUB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5135 /* subw */, RISCV::SUBW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5140 /* sw */, RISCV::PseudoSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 5140 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 5140 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 5143 /* tail */, RISCV::PseudoTAIL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 5148 /* th.addsl */, RISCV::TH_ADDSL, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadBa, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5157 /* th.dcache.call */, RISCV::TH_DCACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5172 /* th.dcache.ciall */, RISCV::TH_DCACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5188 /* th.dcache.cipa */, RISCV::TH_DCACHE_CIPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5203 /* th.dcache.cisw */, RISCV::TH_DCACHE_CISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5218 /* th.dcache.civa */, RISCV::TH_DCACHE_CIVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5233 /* th.dcache.cpa */, RISCV::TH_DCACHE_CPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5247 /* th.dcache.cpal1 */, RISCV::TH_DCACHE_CPAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5263 /* th.dcache.csw */, RISCV::TH_DCACHE_CSW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5277 /* th.dcache.cva */, RISCV::TH_DCACHE_CVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5291 /* th.dcache.cval1 */, RISCV::TH_DCACHE_CVAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5307 /* th.dcache.iall */, RISCV::TH_DCACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5322 /* th.dcache.ipa */, RISCV::TH_DCACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5336 /* th.dcache.isw */, RISCV::TH_DCACHE_ISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5350 /* th.dcache.iva */, RISCV::TH_DCACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5364 /* th.ext */, RISCV::TH_EXT, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 5371 /* th.extu */, RISCV::TH_EXTU, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 5379 /* th.ff0 */, RISCV::TH_FF0, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 5386 /* th.ff1 */, RISCV::TH_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 5393 /* th.flrd */, RISCV::TH_FLRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5401 /* th.flrw */, RISCV::TH_FLRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5409 /* th.flurd */, RISCV::TH_FLURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5418 /* th.flurw */, RISCV::TH_FLURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5427 /* th.fsrd */, RISCV::TH_FSRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5435 /* th.fsrw */, RISCV::TH_FSRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5443 /* th.fsurd */, RISCV::TH_FSURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5452 /* th.fsurw */, RISCV::TH_FSURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5461 /* th.icache.iall */, RISCV::TH_ICACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5476 /* th.icache.ialls */, RISCV::TH_ICACHE_IALLS, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5492 /* th.icache.ipa */, RISCV::TH_ICACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5506 /* th.icache.iva */, RISCV::TH_ICACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 5520 /* th.l2cache.call */, RISCV::TH_L2CACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5536 /* th.l2cache.ciall */, RISCV::TH_L2CACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5553 /* th.l2cache.iall */, RISCV::TH_L2CACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 5569 /* th.lbia */, RISCV::TH_LBIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5577 /* th.lbib */, RISCV::TH_LBIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5585 /* th.lbuia */, RISCV::TH_LBUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5594 /* th.lbuib */, RISCV::TH_LBUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5603 /* th.ldd */, RISCV::TH_LDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 5610 /* th.ldia */, RISCV::TH_LDIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5618 /* th.ldib */, RISCV::TH_LDIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5626 /* th.lhia */, RISCV::TH_LHIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5634 /* th.lhib */, RISCV::TH_LHIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5642 /* th.lhuia */, RISCV::TH_LHUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5651 /* th.lhuib */, RISCV::TH_LHUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5660 /* th.lrb */, RISCV::TH_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5667 /* th.lrbu */, RISCV::TH_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5675 /* th.lrd */, RISCV::TH_LRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5682 /* th.lrh */, RISCV::TH_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5689 /* th.lrhu */, RISCV::TH_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5697 /* th.lrw */, RISCV::TH_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5704 /* th.lrwu */, RISCV::TH_LRWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5712 /* th.lurb */, RISCV::TH_LURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5720 /* th.lurbu */, RISCV::TH_LURBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5729 /* th.lurd */, RISCV::TH_LURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5737 /* th.lurh */, RISCV::TH_LURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5745 /* th.lurhu */, RISCV::TH_LURHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5754 /* th.lurw */, RISCV::TH_LURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5762 /* th.lurwu */, RISCV::TH_LURWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5771 /* th.lwd */, RISCV::TH_LWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 5778 /* th.lwia */, RISCV::TH_LWIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5786 /* th.lwib */, RISCV::TH_LWIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5794 /* th.lwud */, RISCV::TH_LWUD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 5802 /* th.lwuia */, RISCV::TH_LWUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5811 /* th.lwuib */, RISCV::TH_LWUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5820 /* th.mula */, RISCV::TH_MULA, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5828 /* th.mulah */, RISCV::TH_MULAH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5837 /* th.mulaw */, RISCV::TH_MULAW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5846 /* th.muls */, RISCV::TH_MULS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5854 /* th.mulsh */, RISCV::TH_MULSH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5863 /* th.mulsw */, RISCV::TH_MULSW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5872 /* th.mveqz */, RISCV::TH_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5881 /* th.mvnez */, RISCV::TH_MVNEZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5890 /* th.rev */, RISCV::TH_REV, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 5897 /* th.revw */, RISCV::TH_REVW, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 5905 /* th.sbia */, RISCV::TH_SBIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5913 /* th.sbib */, RISCV::TH_SBIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5921 /* th.sdd */, RISCV::TH_SDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 5928 /* th.sdia */, RISCV::TH_SDIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5936 /* th.sdib */, RISCV::TH_SDIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5944 /* th.sfence.vmas */, RISCV::TH_SFENCE_VMAS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadSync, { MCK_GPR, MCK_GPR }, },
  { 5959 /* th.shia */, RISCV::TH_SHIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5967 /* th.shib */, RISCV::TH_SHIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 5975 /* th.srb */, RISCV::TH_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5982 /* th.srd */, RISCV::TH_SRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5989 /* th.srh */, RISCV::TH_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 5996 /* th.srri */, RISCV::TH_SRRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 6004 /* th.srriw */, RISCV::TH_SRRIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6013 /* th.srw */, RISCV::TH_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 6020 /* th.surb */, RISCV::TH_SURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 6028 /* th.surd */, RISCV::TH_SURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 6036 /* th.surh */, RISCV::TH_SURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 6044 /* th.surw */, RISCV::TH_SURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 6052 /* th.swd */, RISCV::TH_SWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 6059 /* th.swia */, RISCV::TH_SWIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 6067 /* th.swib */, RISCV::TH_SWIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 6075 /* th.sync */, RISCV::TH_SYNC, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 6083 /* th.sync.i */, RISCV::TH_SYNC_I, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 6093 /* th.sync.is */, RISCV::TH_SYNC_IS, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 6104 /* th.sync.s */, RISCV::TH_SYNC_S, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 6114 /* th.tst */, RISCV::TH_TST, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 6121 /* th.tstnbz */, RISCV::TH_TSTNBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 6131 /* th.vmaqa.vv */, RISCV::THVdotVMAQA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6143 /* th.vmaqa.vx */, RISCV::THVdotVMAQA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6155 /* th.vmaqasu.vv */, RISCV::THVdotVMAQASU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6169 /* th.vmaqasu.vx */, RISCV::THVdotVMAQASU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6183 /* th.vmaqau.vv */, RISCV::THVdotVMAQAU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6196 /* th.vmaqau.vx */, RISCV::THVdotVMAQAU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6209 /* th.vmaqaus.vx */, RISCV::THVdotVMAQAUS_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6223 /* unimp */, RISCV::UNIMP, Convert_NoOperands, AMFBS_None, {  }, },
  { 6229 /* unzip */, RISCV::UNZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 6235 /* vaadd.vv */, RISCV::VAADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6244 /* vaadd.vx */, RISCV::VAADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6253 /* vaaddu.vv */, RISCV::VAADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6263 /* vaaddu.vx */, RISCV::VAADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6273 /* vadc.vim */, RISCV::VADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 6282 /* vadc.vvm */, RISCV::VADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 6291 /* vadc.vxm */, RISCV::VADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 6300 /* vadd.vi */, RISCV::VADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 6308 /* vadd.vv */, RISCV::VADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6316 /* vadd.vx */, RISCV::VADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6324 /* vaesdf.vs */, RISCV::VAESDF_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6334 /* vaesdf.vv */, RISCV::VAESDF_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6344 /* vaesdm.vs */, RISCV::VAESDM_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6354 /* vaesdm.vv */, RISCV::VAESDM_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6364 /* vaesef.vs */, RISCV::VAESEF_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6374 /* vaesef.vv */, RISCV::VAESEF_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6384 /* vaesem.vs */, RISCV::VAESEM_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6394 /* vaesem.vv */, RISCV::VAESEM_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6404 /* vaeskf1.vi */, RISCV::VAESKF1_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 6415 /* vaeskf2.vi */, RISCV::VAESKF2_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 6426 /* vaesz.vs */, RISCV::VAESZ_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 6435 /* vand.vi */, RISCV::VAND_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 6443 /* vand.vv */, RISCV::VAND_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6451 /* vand.vx */, RISCV::VAND_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6459 /* vandn.vv */, RISCV::VANDN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6468 /* vandn.vx */, RISCV::VANDN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6477 /* vasub.vv */, RISCV::VASUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6486 /* vasub.vx */, RISCV::VASUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6495 /* vasubu.vv */, RISCV::VASUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6505 /* vasubu.vx */, RISCV::VASUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6515 /* vbrev.v */, RISCV::VBREV_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6523 /* vbrev8.v */, RISCV::VBREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6532 /* vclmul.vv */, RISCV::VCLMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6542 /* vclmul.vx */, RISCV::VCLMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6552 /* vclmulh.vv */, RISCV::VCLMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6563 /* vclmulh.vx */, RISCV::VCLMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6574 /* vclz.v */, RISCV::VCLZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6581 /* vcompress.vm */, RISCV::VCOMPRESS_VM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 6594 /* vcpop.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6602 /* vcpop.v */, RISCV::VCPOP_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6610 /* vctz.v */, RISCV::VCTZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6617 /* vdiv.vv */, RISCV::VDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6625 /* vdiv.vx */, RISCV::VDIV_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6633 /* vdivu.vv */, RISCV::VDIVU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6642 /* vdivu.vx */, RISCV::VDIVU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 6651 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 6651 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6659 /* vfadd.vf */, RISCV::VFADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 6668 /* vfadd.vv */, RISCV::VFADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6677 /* vfclass.v */, RISCV::VFCLASS_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6687 /* vfcvt.f.x.v */, RISCV::VFCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6699 /* vfcvt.f.xu.v */, RISCV::VFCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6712 /* vfcvt.rtz.x.f.v */, RISCV::VFCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6728 /* vfcvt.rtz.xu.f.v */, RISCV::VFCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6745 /* vfcvt.x.f.v */, RISCV::VFCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6757 /* vfcvt.xu.f.v */, RISCV::VFCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6770 /* vfdiv.vf */, RISCV::VFDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 6779 /* vfdiv.vv */, RISCV::VFDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6788 /* vfirst.m */, RISCV::VFIRST_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6797 /* vfmacc.vf */, RISCV::VFMACC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6807 /* vfmacc.vv */, RISCV::VFMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6817 /* vfmadd.vf */, RISCV::VFMADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6827 /* vfmadd.vv */, RISCV::VFMADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6837 /* vfmax.vf */, RISCV::VFMAX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 6846 /* vfmax.vv */, RISCV::VFMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6855 /* vfmerge.vfm */, RISCV::VFMERGE_VFM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_VMV0 }, },
  { 6867 /* vfmin.vf */, RISCV::VFMIN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 6876 /* vfmin.vv */, RISCV::VFMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6885 /* vfmsac.vf */, RISCV::VFMSAC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6895 /* vfmsac.vv */, RISCV::VFMSAC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6905 /* vfmsub.vf */, RISCV::VFMSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6915 /* vfmsub.vv */, RISCV::VFMSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6925 /* vfmul.vf */, RISCV::VFMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 6934 /* vfmul.vv */, RISCV::VFMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6943 /* vfmv.f.s */, RISCV::VFMV_F_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_FPR32, MCK_VM }, },
  { 6952 /* vfmv.s.f */, RISCV::VFMV_S_F, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 6961 /* vfmv.v.f */, RISCV::VFMV_V_F, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 6970 /* vfncvt.f.f.w */, RISCV::VFNCVT_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6983 /* vfncvt.f.x.w */, RISCV::VFNCVT_F_X_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 6996 /* vfncvt.f.xu.w */, RISCV::VFNCVT_F_XU_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7010 /* vfncvt.rod.f.f.w */, RISCV::VFNCVT_ROD_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7027 /* vfncvt.rtz.x.f.w */, RISCV::VFNCVT_RTZ_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7044 /* vfncvt.rtz.xu.f.w */, RISCV::VFNCVT_RTZ_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7062 /* vfncvt.x.f.w */, RISCV::VFNCVT_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7075 /* vfncvt.xu.f.w */, RISCV::VFNCVT_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7089 /* vfncvtbf16.f.f.w */, RISCV::VFNCVTBF16_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7106 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 7106 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7114 /* vfnmacc.vf */, RISCV::VFNMACC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7125 /* vfnmacc.vv */, RISCV::VFNMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7136 /* vfnmadd.vf */, RISCV::VFNMADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7147 /* vfnmadd.vv */, RISCV::VFNMADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7158 /* vfnmsac.vf */, RISCV::VFNMSAC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7169 /* vfnmsac.vv */, RISCV::VFNMSAC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7180 /* vfnmsub.vf */, RISCV::VFNMSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7191 /* vfnmsub.vv */, RISCV::VFNMSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7202 /* vfrdiv.vf */, RISCV::VFRDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7212 /* vfrec7.v */, RISCV::VFREC7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7221 /* vfredmax.vs */, RISCV::VFREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7233 /* vfredmin.vs */, RISCV::VFREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7245 /* vfredosum.vs */, RISCV::VFREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7258 /* vfredsum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7270 /* vfredusum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7283 /* vfrsqrt7.v */, RISCV::VFRSQRT7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7294 /* vfrsub.vf */, RISCV::VFRSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7304 /* vfsgnj.vf */, RISCV::VFSGNJ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7314 /* vfsgnj.vv */, RISCV::VFSGNJ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7324 /* vfsgnjn.vf */, RISCV::VFSGNJN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7335 /* vfsgnjn.vv */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7346 /* vfsgnjx.vf */, RISCV::VFSGNJX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7357 /* vfsgnjx.vv */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7368 /* vfslide1down.vf */, RISCV::VFSLIDE1DOWN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7384 /* vfslide1up.vf */, RISCV::VFSLIDE1UP_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7398 /* vfsqrt.v */, RISCV::VFSQRT_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7407 /* vfsub.vf */, RISCV::VFSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7416 /* vfsub.vv */, RISCV::VFSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7425 /* vfwadd.vf */, RISCV::VFWADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7435 /* vfwadd.vv */, RISCV::VFWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7445 /* vfwadd.wf */, RISCV::VFWADD_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7455 /* vfwadd.wv */, RISCV::VFWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7465 /* vfwcvt.f.f.v */, RISCV::VFWCVT_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7478 /* vfwcvt.f.x.v */, RISCV::VFWCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7491 /* vfwcvt.f.xu.v */, RISCV::VFWCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7505 /* vfwcvt.rtz.x.f.v */, RISCV::VFWCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7522 /* vfwcvt.rtz.xu.f.v */, RISCV::VFWCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7540 /* vfwcvt.x.f.v */, RISCV::VFWCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7553 /* vfwcvt.xu.f.v */, RISCV::VFWCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7567 /* vfwcvtbf16.f.f.v */, RISCV::VFWCVTBF16_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7584 /* vfwmacc.vf */, RISCV::VFWMACC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7595 /* vfwmacc.vv */, RISCV::VFWMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7606 /* vfwmaccbf16.vf */, RISCV::VFWMACCBF16_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7621 /* vfwmaccbf16.vv */, RISCV::VFWMACCBF16_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7636 /* vfwmsac.vf */, RISCV::VFWMSAC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7647 /* vfwmsac.vv */, RISCV::VFWMSAC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7658 /* vfwmul.vf */, RISCV::VFWMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7668 /* vfwmul.vv */, RISCV::VFWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7678 /* vfwnmacc.vf */, RISCV::VFWNMACC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7690 /* vfwnmacc.vv */, RISCV::VFWNMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7702 /* vfwnmsac.vf */, RISCV::VFWNMSAC_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7714 /* vfwnmsac.vv */, RISCV::VFWNMSAC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7726 /* vfwredosum.vs */, RISCV::VFWREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7740 /* vfwredsum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7753 /* vfwredusum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7767 /* vfwsub.vf */, RISCV::VFWSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7777 /* vfwsub.vv */, RISCV::VFWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7787 /* vfwsub.wf */, RISCV::VFWSUB_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 7797 /* vfwsub.wv */, RISCV::VFWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7807 /* vghsh.vv */, RISCV::VGHSH_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM, MCK_VM }, },
  { 7816 /* vgmul.vv */, RISCV::VGMUL_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM }, },
  { 7825 /* vid.v */, RISCV::VID_V, Convert__Reg1_0__RVVMaskRegOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7831 /* viota.m */, RISCV::VIOTA_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 7839 /* vl1r.v */, RISCV::VL1RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7846 /* vl1re16.v */, RISCV::VL1RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 7856 /* vl1re32.v */, RISCV::VL1RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 7866 /* vl1re64.v */, RISCV::VL1RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 7876 /* vl1re8.v */, RISCV::VL1RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 7885 /* vl2r.v */, RISCV::VL2RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM2, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7892 /* vl2re16.v */, RISCV::VL2RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 7902 /* vl2re32.v */, RISCV::VL2RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 7912 /* vl2re64.v */, RISCV::VL2RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 7922 /* vl2re8.v */, RISCV::VL2RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 7931 /* vl4r.v */, RISCV::VL4RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM4, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7938 /* vl4re16.v */, RISCV::VL4RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 7948 /* vl4re32.v */, RISCV::VL4RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 7958 /* vl4re64.v */, RISCV::VL4RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 7968 /* vl4re8.v */, RISCV::VL4RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 7977 /* vl8r.v */, RISCV::VL8RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM8, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7984 /* vl8re16.v */, RISCV::VL8RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 7994 /* vl8re32.v */, RISCV::VL8RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 8004 /* vl8re64.v */, RISCV::VL8RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 8014 /* vl8re8.v */, RISCV::VL8RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 8023 /* vle1.v */, RISCV::VLM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8030 /* vle16.v */, RISCV::VLE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8038 /* vle16ff.v */, RISCV::VLE16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8048 /* vle32.v */, RISCV::VLE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8056 /* vle32ff.v */, RISCV::VLE32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8066 /* vle64.v */, RISCV::VLE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8074 /* vle64ff.v */, RISCV::VLE64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8084 /* vle8.v */, RISCV::VLE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8091 /* vle8ff.v */, RISCV::VLE8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8100 /* vlm.v */, RISCV::VLM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 8106 /* vloxei16.v */, RISCV::VLOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8117 /* vloxei32.v */, RISCV::VLOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8128 /* vloxei64.v */, RISCV::VLOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8139 /* vloxei8.v */, RISCV::VLOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8149 /* vloxseg2ei16.v */, RISCV::VLOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8164 /* vloxseg2ei32.v */, RISCV::VLOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8179 /* vloxseg2ei64.v */, RISCV::VLOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8194 /* vloxseg2ei8.v */, RISCV::VLOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8208 /* vloxseg3ei16.v */, RISCV::VLOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8223 /* vloxseg3ei32.v */, RISCV::VLOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8238 /* vloxseg3ei64.v */, RISCV::VLOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8253 /* vloxseg3ei8.v */, RISCV::VLOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8267 /* vloxseg4ei16.v */, RISCV::VLOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8282 /* vloxseg4ei32.v */, RISCV::VLOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8297 /* vloxseg4ei64.v */, RISCV::VLOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8312 /* vloxseg4ei8.v */, RISCV::VLOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8326 /* vloxseg5ei16.v */, RISCV::VLOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8341 /* vloxseg5ei32.v */, RISCV::VLOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8356 /* vloxseg5ei64.v */, RISCV::VLOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8371 /* vloxseg5ei8.v */, RISCV::VLOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8385 /* vloxseg6ei16.v */, RISCV::VLOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8400 /* vloxseg6ei32.v */, RISCV::VLOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8415 /* vloxseg6ei64.v */, RISCV::VLOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8430 /* vloxseg6ei8.v */, RISCV::VLOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8444 /* vloxseg7ei16.v */, RISCV::VLOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8459 /* vloxseg7ei32.v */, RISCV::VLOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8474 /* vloxseg7ei64.v */, RISCV::VLOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8489 /* vloxseg7ei8.v */, RISCV::VLOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8503 /* vloxseg8ei16.v */, RISCV::VLOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8518 /* vloxseg8ei32.v */, RISCV::VLOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8533 /* vloxseg8ei64.v */, RISCV::VLOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8548 /* vloxseg8ei8.v */, RISCV::VLOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 8562 /* vlse16.v */, RISCV::VLSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 8571 /* vlse32.v */, RISCV::VLSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 8580 /* vlse64.v */, RISCV::VLSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 8589 /* vlse8.v */, RISCV::VLSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 8597 /* vlseg2e16.v */, RISCV::VLSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8609 /* vlseg2e16ff.v */, RISCV::VLSEG2E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8623 /* vlseg2e32.v */, RISCV::VLSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8635 /* vlseg2e32ff.v */, RISCV::VLSEG2E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8649 /* vlseg2e64.v */, RISCV::VLSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8661 /* vlseg2e64ff.v */, RISCV::VLSEG2E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8675 /* vlseg2e8.v */, RISCV::VLSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8686 /* vlseg2e8ff.v */, RISCV::VLSEG2E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8699 /* vlseg3e16.v */, RISCV::VLSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8711 /* vlseg3e16ff.v */, RISCV::VLSEG3E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8725 /* vlseg3e32.v */, RISCV::VLSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8737 /* vlseg3e32ff.v */, RISCV::VLSEG3E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8751 /* vlseg3e64.v */, RISCV::VLSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8763 /* vlseg3e64ff.v */, RISCV::VLSEG3E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8777 /* vlseg3e8.v */, RISCV::VLSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8788 /* vlseg3e8ff.v */, RISCV::VLSEG3E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8801 /* vlseg4e16.v */, RISCV::VLSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8813 /* vlseg4e16ff.v */, RISCV::VLSEG4E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8827 /* vlseg4e32.v */, RISCV::VLSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8839 /* vlseg4e32ff.v */, RISCV::VLSEG4E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8853 /* vlseg4e64.v */, RISCV::VLSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8865 /* vlseg4e64ff.v */, RISCV::VLSEG4E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8879 /* vlseg4e8.v */, RISCV::VLSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8890 /* vlseg4e8ff.v */, RISCV::VLSEG4E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8903 /* vlseg5e16.v */, RISCV::VLSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8915 /* vlseg5e16ff.v */, RISCV::VLSEG5E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8929 /* vlseg5e32.v */, RISCV::VLSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8941 /* vlseg5e32ff.v */, RISCV::VLSEG5E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8955 /* vlseg5e64.v */, RISCV::VLSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8967 /* vlseg5e64ff.v */, RISCV::VLSEG5E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8981 /* vlseg5e8.v */, RISCV::VLSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 8992 /* vlseg5e8ff.v */, RISCV::VLSEG5E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9005 /* vlseg6e16.v */, RISCV::VLSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9017 /* vlseg6e16ff.v */, RISCV::VLSEG6E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9031 /* vlseg6e32.v */, RISCV::VLSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9043 /* vlseg6e32ff.v */, RISCV::VLSEG6E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9057 /* vlseg6e64.v */, RISCV::VLSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9069 /* vlseg6e64ff.v */, RISCV::VLSEG6E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9083 /* vlseg6e8.v */, RISCV::VLSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9094 /* vlseg6e8ff.v */, RISCV::VLSEG6E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9107 /* vlseg7e16.v */, RISCV::VLSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9119 /* vlseg7e16ff.v */, RISCV::VLSEG7E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9133 /* vlseg7e32.v */, RISCV::VLSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9145 /* vlseg7e32ff.v */, RISCV::VLSEG7E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9159 /* vlseg7e64.v */, RISCV::VLSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9171 /* vlseg7e64ff.v */, RISCV::VLSEG7E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9185 /* vlseg7e8.v */, RISCV::VLSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9196 /* vlseg7e8ff.v */, RISCV::VLSEG7E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9209 /* vlseg8e16.v */, RISCV::VLSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9221 /* vlseg8e16ff.v */, RISCV::VLSEG8E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9235 /* vlseg8e32.v */, RISCV::VLSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9247 /* vlseg8e32ff.v */, RISCV::VLSEG8E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9261 /* vlseg8e64.v */, RISCV::VLSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9273 /* vlseg8e64ff.v */, RISCV::VLSEG8E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9287 /* vlseg8e8.v */, RISCV::VLSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9298 /* vlseg8e8ff.v */, RISCV::VLSEG8E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 9311 /* vlsseg2e16.v */, RISCV::VLSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9324 /* vlsseg2e32.v */, RISCV::VLSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9337 /* vlsseg2e64.v */, RISCV::VLSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9350 /* vlsseg2e8.v */, RISCV::VLSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9362 /* vlsseg3e16.v */, RISCV::VLSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9375 /* vlsseg3e32.v */, RISCV::VLSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9388 /* vlsseg3e64.v */, RISCV::VLSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9401 /* vlsseg3e8.v */, RISCV::VLSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9413 /* vlsseg4e16.v */, RISCV::VLSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9426 /* vlsseg4e32.v */, RISCV::VLSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9439 /* vlsseg4e64.v */, RISCV::VLSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9452 /* vlsseg4e8.v */, RISCV::VLSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9464 /* vlsseg5e16.v */, RISCV::VLSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9477 /* vlsseg5e32.v */, RISCV::VLSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9490 /* vlsseg5e64.v */, RISCV::VLSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9503 /* vlsseg5e8.v */, RISCV::VLSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9515 /* vlsseg6e16.v */, RISCV::VLSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9528 /* vlsseg6e32.v */, RISCV::VLSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9541 /* vlsseg6e64.v */, RISCV::VLSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9554 /* vlsseg6e8.v */, RISCV::VLSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9566 /* vlsseg7e16.v */, RISCV::VLSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9579 /* vlsseg7e32.v */, RISCV::VLSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9592 /* vlsseg7e64.v */, RISCV::VLSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9605 /* vlsseg7e8.v */, RISCV::VLSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9617 /* vlsseg8e16.v */, RISCV::VLSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9630 /* vlsseg8e32.v */, RISCV::VLSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9643 /* vlsseg8e64.v */, RISCV::VLSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9656 /* vlsseg8e8.v */, RISCV::VLSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 9668 /* vluxei16.v */, RISCV::VLUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9679 /* vluxei32.v */, RISCV::VLUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9690 /* vluxei64.v */, RISCV::VLUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9701 /* vluxei8.v */, RISCV::VLUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9711 /* vluxseg2ei16.v */, RISCV::VLUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9726 /* vluxseg2ei32.v */, RISCV::VLUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9741 /* vluxseg2ei64.v */, RISCV::VLUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9756 /* vluxseg2ei8.v */, RISCV::VLUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9770 /* vluxseg3ei16.v */, RISCV::VLUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9785 /* vluxseg3ei32.v */, RISCV::VLUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9800 /* vluxseg3ei64.v */, RISCV::VLUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9815 /* vluxseg3ei8.v */, RISCV::VLUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9829 /* vluxseg4ei16.v */, RISCV::VLUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9844 /* vluxseg4ei32.v */, RISCV::VLUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9859 /* vluxseg4ei64.v */, RISCV::VLUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9874 /* vluxseg4ei8.v */, RISCV::VLUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9888 /* vluxseg5ei16.v */, RISCV::VLUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9903 /* vluxseg5ei32.v */, RISCV::VLUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9918 /* vluxseg5ei64.v */, RISCV::VLUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9933 /* vluxseg5ei8.v */, RISCV::VLUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9947 /* vluxseg6ei16.v */, RISCV::VLUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9962 /* vluxseg6ei32.v */, RISCV::VLUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9977 /* vluxseg6ei64.v */, RISCV::VLUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 9992 /* vluxseg6ei8.v */, RISCV::VLUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10006 /* vluxseg7ei16.v */, RISCV::VLUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10021 /* vluxseg7ei32.v */, RISCV::VLUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10036 /* vluxseg7ei64.v */, RISCV::VLUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10051 /* vluxseg7ei8.v */, RISCV::VLUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10065 /* vluxseg8ei16.v */, RISCV::VLUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10080 /* vluxseg8ei32.v */, RISCV::VLUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10095 /* vluxseg8ei64.v */, RISCV::VLUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10110 /* vluxseg8ei8.v */, RISCV::VLUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10124 /* vmacc.vv */, RISCV::VMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10133 /* vmacc.vx */, RISCV::VMACC_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10142 /* vmadc.vi */, RISCV::VMADC_VI, Convert__Reg1_0__Reg1_1__SImm51_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10151 /* vmadc.vim */, RISCV::VMADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 10161 /* vmadc.vv */, RISCV::VMADC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10170 /* vmadc.vvm */, RISCV::VMADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 10180 /* vmadc.vx */, RISCV::VMADC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 10189 /* vmadc.vxm */, RISCV::VMADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 10199 /* vmadd.vv */, RISCV::VMADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10208 /* vmadd.vx */, RISCV::VMADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10217 /* vmand.mm */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10226 /* vmandn.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10236 /* vmandnot.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10248 /* vmax.vv */, RISCV::VMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10256 /* vmax.vx */, RISCV::VMAX_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10264 /* vmaxu.vv */, RISCV::VMAXU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10273 /* vmaxu.vx */, RISCV::VMAXU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10282 /* vmclr.m */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 10290 /* vmerge.vim */, RISCV::VMERGE_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 10301 /* vmerge.vvm */, RISCV::VMERGE_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 10312 /* vmerge.vxm */, RISCV::VMERGE_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 10323 /* vmfeq.vf */, RISCV::VMFEQ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10332 /* vmfeq.vv */, RISCV::VMFEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10341 /* vmfge.vf */, RISCV::VMFGE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10350 /* vmfge.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10359 /* vmfgt.vf */, RISCV::VMFGT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10368 /* vmfgt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10377 /* vmfle.vf */, RISCV::VMFLE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10386 /* vmfle.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10395 /* vmflt.vf */, RISCV::VMFLT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10404 /* vmflt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10413 /* vmfne.vf */, RISCV::VMFNE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10422 /* vmfne.vv */, RISCV::VMFNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10431 /* vmin.vv */, RISCV::VMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10439 /* vmin.vx */, RISCV::VMIN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10447 /* vminu.vv */, RISCV::VMINU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10456 /* vminu.vx */, RISCV::VMINU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10465 /* vmmv.m */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 10472 /* vmnand.mm */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10482 /* vmnor.mm */, RISCV::VMNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10491 /* vmnot.m */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 10499 /* vmor.mm */, RISCV::VMOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10507 /* vmorn.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10516 /* vmornot.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10527 /* vmsbc.vv */, RISCV::VMSBC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10536 /* vmsbc.vvm */, RISCV::VMSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 10546 /* vmsbc.vx */, RISCV::VMSBC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 10555 /* vmsbc.vxm */, RISCV::VMSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 10565 /* vmsbf.m */, RISCV::VMSBF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10573 /* vmseq.vi */, RISCV::VMSEQ_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10582 /* vmseq.vv */, RISCV::VMSEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10591 /* vmseq.vx */, RISCV::VMSEQ_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10600 /* vmset.m */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 10608 /* vmsge.vi */, RISCV::PseudoVMSGE_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 10617 /* vmsge.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10626 /* vmsge.vx */, RISCV::PseudoVMSGE_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 10626 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10626 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 10635 /* vmsgeu.vi */, RISCV::PseudoVMSGEU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 10645 /* vmsgeu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10655 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 10655 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10655 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 10665 /* vmsgt.vi */, RISCV::VMSGT_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10674 /* vmsgt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10683 /* vmsgt.vx */, RISCV::VMSGT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10692 /* vmsgtu.vi */, RISCV::VMSGTU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10702 /* vmsgtu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10712 /* vmsgtu.vx */, RISCV::VMSGTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10722 /* vmsif.m */, RISCV::VMSIF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10730 /* vmsle.vi */, RISCV::VMSLE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10739 /* vmsle.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10748 /* vmsle.vx */, RISCV::VMSLE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10757 /* vmsleu.vi */, RISCV::VMSLEU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10767 /* vmsleu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10777 /* vmsleu.vx */, RISCV::VMSLEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10787 /* vmslt.vi */, RISCV::PseudoVMSLT_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 10796 /* vmslt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10805 /* vmslt.vx */, RISCV::VMSLT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10814 /* vmsltu.vi */, RISCV::PseudoVMSLTU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 10824 /* vmsltu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10834 /* vmsltu.vx */, RISCV::VMSLTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10844 /* vmsne.vi */, RISCV::VMSNE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10853 /* vmsne.vv */, RISCV::VMSNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10862 /* vmsne.vx */, RISCV::VMSNE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10871 /* vmsof.m */, RISCV::VMSOF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10879 /* vmul.vv */, RISCV::VMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10887 /* vmul.vx */, RISCV::VMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10895 /* vmulh.vv */, RISCV::VMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10904 /* vmulh.vx */, RISCV::VMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10913 /* vmulhsu.vv */, RISCV::VMULHSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10924 /* vmulhsu.vx */, RISCV::VMULHSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10935 /* vmulhu.vv */, RISCV::VMULHU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10945 /* vmulhu.vx */, RISCV::VMULHU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10955 /* vmv.s.x */, RISCV::VMV_S_X, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 10963 /* vmv.v.i */, RISCV::VMV_V_I, Convert__Reg1_0__SImm51_1, AMFBS_HasVInstructions, { MCK_VM, MCK_SImm5 }, },
  { 10971 /* vmv.v.v */, RISCV::VMV_V_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 10979 /* vmv.v.x */, RISCV::VMV_V_X, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 10987 /* vmv.x.s */, RISCV::VMV_X_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM }, },
  { 10995 /* vmv1r.v */, RISCV::VMV1R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 11003 /* vmv2r.v */, RISCV::VMV2R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_VRM2 }, },
  { 11011 /* vmv4r.v */, RISCV::VMV4R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_VRM4 }, },
  { 11019 /* vmv8r.v */, RISCV::VMV8R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_VRM8 }, },
  { 11027 /* vmxnor.mm */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11037 /* vmxor.mm */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11046 /* vnclip.wi */, RISCV::VNCLIP_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11056 /* vnclip.wv */, RISCV::VNCLIP_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11066 /* vnclip.wx */, RISCV::VNCLIP_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11076 /* vnclipu.wi */, RISCV::VNCLIPU_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11087 /* vnclipu.wv */, RISCV::VNCLIPU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11098 /* vnclipu.wx */, RISCV::VNCLIPU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11109 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 11109 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11121 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 11121 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11128 /* vnmsac.vv */, RISCV::VNMSAC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11138 /* vnmsac.vx */, RISCV::VNMSAC_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11148 /* vnmsub.vv */, RISCV::VNMSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11158 /* vnmsub.vx */, RISCV::VNMSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11168 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 11168 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11175 /* vnsra.wi */, RISCV::VNSRA_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11184 /* vnsra.wv */, RISCV::VNSRA_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11193 /* vnsra.wx */, RISCV::VNSRA_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11202 /* vnsrl.wi */, RISCV::VNSRL_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11211 /* vnsrl.wv */, RISCV::VNSRL_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11220 /* vnsrl.wx */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11229 /* vor.vi */, RISCV::VOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 11236 /* vor.vv */, RISCV::VOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11243 /* vor.vx */, RISCV::VOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11250 /* vpopc.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11258 /* vredand.vs */, RISCV::VREDAND_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11269 /* vredmax.vs */, RISCV::VREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11280 /* vredmaxu.vs */, RISCV::VREDMAXU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11292 /* vredmin.vs */, RISCV::VREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11303 /* vredminu.vs */, RISCV::VREDMINU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11315 /* vredor.vs */, RISCV::VREDOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11325 /* vredsum.vs */, RISCV::VREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11336 /* vredxor.vs */, RISCV::VREDXOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11347 /* vrem.vv */, RISCV::VREM_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11355 /* vrem.vx */, RISCV::VREM_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11363 /* vremu.vv */, RISCV::VREMU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11372 /* vremu.vx */, RISCV::VREMU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11381 /* vrev8.v */, RISCV::VREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11389 /* vrgather.vi */, RISCV::VRGATHER_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11401 /* vrgather.vv */, RISCV::VRGATHER_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11413 /* vrgather.vx */, RISCV::VRGATHER_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11425 /* vrgatherei16.vv */, RISCV::VRGATHEREI16_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11441 /* vrol.vv */, RISCV::VROL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11449 /* vrol.vx */, RISCV::VROL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11457 /* vror.vi */, RISCV::VROR_VI, Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_UImm6, MCK_RVVMaskRegOpOperand }, },
  { 11465 /* vror.vv */, RISCV::VROR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11473 /* vror.vx */, RISCV::VROR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11481 /* vrsub.vi */, RISCV::VRSUB_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 11490 /* vrsub.vx */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11499 /* vs1r.v */, RISCV::VS1R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11506 /* vs2r.v */, RISCV::VS2R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 11513 /* vs4r.v */, RISCV::VS4R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 11520 /* vs8r.v */, RISCV::VS8R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 11527 /* vsadd.vi */, RISCV::VSADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 11536 /* vsadd.vv */, RISCV::VSADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11545 /* vsadd.vx */, RISCV::VSADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11554 /* vsaddu.vi */, RISCV::VSADDU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 11564 /* vsaddu.vv */, RISCV::VSADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11574 /* vsaddu.vx */, RISCV::VSADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11584 /* vsbc.vvm */, RISCV::VSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 11593 /* vsbc.vxm */, RISCV::VSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 11602 /* vse1.v */, RISCV::VSM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11609 /* vse16.v */, RISCV::VSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 11617 /* vse32.v */, RISCV::VSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 11625 /* vse64.v */, RISCV::VSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 11633 /* vse8.v */, RISCV::VSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 11640 /* vsetivli */, RISCV::VSETIVLI, Convert__Reg1_0__UImm51_1__VTypeI101_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_UImm5, MCK_VTypeI10 }, },
  { 11649 /* vsetvl */, RISCV::VSETVL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11656 /* vsetvli */, RISCV::VSETVLI, Convert__Reg1_0__Reg1_1__VTypeI111_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_VTypeI11 }, },
  { 11664 /* vsext.vf2 */, RISCV::VSEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11674 /* vsext.vf4 */, RISCV::VSEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11684 /* vsext.vf8 */, RISCV::VSEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11694 /* vsha2ch.vv */, RISCV::VSHA2CH_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknha, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11705 /* vsha2cl.vv */, RISCV::VSHA2CL_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknha, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11716 /* vsha2ms.vv */, RISCV::VSHA2MS_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknha, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11727 /* vslide1down.vx */, RISCV::VSLIDE1DOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11742 /* vslide1up.vx */, RISCV::VSLIDE1UP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11755 /* vslidedown.vi */, RISCV::VSLIDEDOWN_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11769 /* vslidedown.vx */, RISCV::VSLIDEDOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11783 /* vslideup.vi */, RISCV::VSLIDEUP_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11795 /* vslideup.vx */, RISCV::VSLIDEUP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11807 /* vsll.vi */, RISCV::VSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 11815 /* vsll.vv */, RISCV::VSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11823 /* vsll.vx */, RISCV::VSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11831 /* vsm.v */, RISCV::VSM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11837 /* vsm3c.vi */, RISCV::VSM3C_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 11846 /* vsm3me.vv */, RISCV::VSM3ME_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11856 /* vsm4k.vi */, RISCV::VSM4K_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 11865 /* vsm4r.vs */, RISCV::VSM4R_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 11874 /* vsm4r.vv */, RISCV::VSM4R_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 11883 /* vsmul.vv */, RISCV::VSMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11892 /* vsmul.vx */, RISCV::VSMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 11901 /* vsoxei16.v */, RISCV::VSOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11912 /* vsoxei32.v */, RISCV::VSOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11923 /* vsoxei64.v */, RISCV::VSOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11934 /* vsoxei8.v */, RISCV::VSOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11944 /* vsoxseg2ei16.v */, RISCV::VSOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11959 /* vsoxseg2ei32.v */, RISCV::VSOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11974 /* vsoxseg2ei64.v */, RISCV::VSOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11989 /* vsoxseg2ei8.v */, RISCV::VSOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12003 /* vsoxseg3ei16.v */, RISCV::VSOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12018 /* vsoxseg3ei32.v */, RISCV::VSOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12033 /* vsoxseg3ei64.v */, RISCV::VSOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12048 /* vsoxseg3ei8.v */, RISCV::VSOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12062 /* vsoxseg4ei16.v */, RISCV::VSOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12077 /* vsoxseg4ei32.v */, RISCV::VSOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12092 /* vsoxseg4ei64.v */, RISCV::VSOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12107 /* vsoxseg4ei8.v */, RISCV::VSOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12121 /* vsoxseg5ei16.v */, RISCV::VSOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12136 /* vsoxseg5ei32.v */, RISCV::VSOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12151 /* vsoxseg5ei64.v */, RISCV::VSOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12166 /* vsoxseg5ei8.v */, RISCV::VSOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12180 /* vsoxseg6ei16.v */, RISCV::VSOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12195 /* vsoxseg6ei32.v */, RISCV::VSOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12210 /* vsoxseg6ei64.v */, RISCV::VSOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12225 /* vsoxseg6ei8.v */, RISCV::VSOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12239 /* vsoxseg7ei16.v */, RISCV::VSOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12254 /* vsoxseg7ei32.v */, RISCV::VSOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12269 /* vsoxseg7ei64.v */, RISCV::VSOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12284 /* vsoxseg7ei8.v */, RISCV::VSOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12298 /* vsoxseg8ei16.v */, RISCV::VSOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12313 /* vsoxseg8ei32.v */, RISCV::VSOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12328 /* vsoxseg8ei64.v */, RISCV::VSOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12343 /* vsoxseg8ei8.v */, RISCV::VSOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12357 /* vsra.vi */, RISCV::VSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 12365 /* vsra.vv */, RISCV::VSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12373 /* vsra.vx */, RISCV::VSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12381 /* vsrl.vi */, RISCV::VSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 12389 /* vsrl.vv */, RISCV::VSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12397 /* vsrl.vx */, RISCV::VSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12405 /* vsse16.v */, RISCV::VSSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12414 /* vsse32.v */, RISCV::VSSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12423 /* vsse64.v */, RISCV::VSSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12432 /* vsse8.v */, RISCV::VSSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12440 /* vsseg2e16.v */, RISCV::VSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12452 /* vsseg2e32.v */, RISCV::VSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12464 /* vsseg2e64.v */, RISCV::VSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12476 /* vsseg2e8.v */, RISCV::VSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12487 /* vsseg3e16.v */, RISCV::VSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12499 /* vsseg3e32.v */, RISCV::VSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12511 /* vsseg3e64.v */, RISCV::VSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12523 /* vsseg3e8.v */, RISCV::VSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12534 /* vsseg4e16.v */, RISCV::VSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12546 /* vsseg4e32.v */, RISCV::VSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12558 /* vsseg4e64.v */, RISCV::VSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12570 /* vsseg4e8.v */, RISCV::VSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12581 /* vsseg5e16.v */, RISCV::VSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12593 /* vsseg5e32.v */, RISCV::VSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12605 /* vsseg5e64.v */, RISCV::VSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12617 /* vsseg5e8.v */, RISCV::VSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12628 /* vsseg6e16.v */, RISCV::VSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12640 /* vsseg6e32.v */, RISCV::VSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12652 /* vsseg6e64.v */, RISCV::VSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12664 /* vsseg6e8.v */, RISCV::VSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12675 /* vsseg7e16.v */, RISCV::VSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12687 /* vsseg7e32.v */, RISCV::VSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12699 /* vsseg7e64.v */, RISCV::VSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12711 /* vsseg7e8.v */, RISCV::VSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12722 /* vsseg8e16.v */, RISCV::VSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12734 /* vsseg8e32.v */, RISCV::VSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12746 /* vsseg8e64.v */, RISCV::VSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12758 /* vsseg8e8.v */, RISCV::VSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12769 /* vssra.vi */, RISCV::VSSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 12778 /* vssra.vv */, RISCV::VSSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12787 /* vssra.vx */, RISCV::VSSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12796 /* vssrl.vi */, RISCV::VSSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 12805 /* vssrl.vv */, RISCV::VSSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12814 /* vssrl.vx */, RISCV::VSSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12823 /* vssseg2e16.v */, RISCV::VSSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12836 /* vssseg2e32.v */, RISCV::VSSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12849 /* vssseg2e64.v */, RISCV::VSSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12862 /* vssseg2e8.v */, RISCV::VSSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12874 /* vssseg3e16.v */, RISCV::VSSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12887 /* vssseg3e32.v */, RISCV::VSSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12900 /* vssseg3e64.v */, RISCV::VSSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12913 /* vssseg3e8.v */, RISCV::VSSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12925 /* vssseg4e16.v */, RISCV::VSSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12938 /* vssseg4e32.v */, RISCV::VSSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12951 /* vssseg4e64.v */, RISCV::VSSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12964 /* vssseg4e8.v */, RISCV::VSSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12976 /* vssseg5e16.v */, RISCV::VSSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12989 /* vssseg5e32.v */, RISCV::VSSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13002 /* vssseg5e64.v */, RISCV::VSSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13015 /* vssseg5e8.v */, RISCV::VSSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13027 /* vssseg6e16.v */, RISCV::VSSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13040 /* vssseg6e32.v */, RISCV::VSSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13053 /* vssseg6e64.v */, RISCV::VSSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13066 /* vssseg6e8.v */, RISCV::VSSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13078 /* vssseg7e16.v */, RISCV::VSSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13091 /* vssseg7e32.v */, RISCV::VSSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13104 /* vssseg7e64.v */, RISCV::VSSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13117 /* vssseg7e8.v */, RISCV::VSSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13129 /* vssseg8e16.v */, RISCV::VSSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13142 /* vssseg8e32.v */, RISCV::VSSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13155 /* vssseg8e64.v */, RISCV::VSSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13168 /* vssseg8e8.v */, RISCV::VSSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13180 /* vssub.vv */, RISCV::VSSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13189 /* vssub.vx */, RISCV::VSSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13198 /* vssubu.vv */, RISCV::VSSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13208 /* vssubu.vx */, RISCV::VSSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13218 /* vsub.vv */, RISCV::VSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13226 /* vsub.vx */, RISCV::VSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13234 /* vsuxei16.v */, RISCV::VSUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13245 /* vsuxei32.v */, RISCV::VSUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13256 /* vsuxei64.v */, RISCV::VSUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13267 /* vsuxei8.v */, RISCV::VSUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13277 /* vsuxseg2ei16.v */, RISCV::VSUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13292 /* vsuxseg2ei32.v */, RISCV::VSUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13307 /* vsuxseg2ei64.v */, RISCV::VSUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13322 /* vsuxseg2ei8.v */, RISCV::VSUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13336 /* vsuxseg3ei16.v */, RISCV::VSUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13351 /* vsuxseg3ei32.v */, RISCV::VSUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13366 /* vsuxseg3ei64.v */, RISCV::VSUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13381 /* vsuxseg3ei8.v */, RISCV::VSUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13395 /* vsuxseg4ei16.v */, RISCV::VSUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13410 /* vsuxseg4ei32.v */, RISCV::VSUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13425 /* vsuxseg4ei64.v */, RISCV::VSUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13440 /* vsuxseg4ei8.v */, RISCV::VSUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13454 /* vsuxseg5ei16.v */, RISCV::VSUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13469 /* vsuxseg5ei32.v */, RISCV::VSUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13484 /* vsuxseg5ei64.v */, RISCV::VSUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13499 /* vsuxseg5ei8.v */, RISCV::VSUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13513 /* vsuxseg6ei16.v */, RISCV::VSUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13528 /* vsuxseg6ei32.v */, RISCV::VSUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13543 /* vsuxseg6ei64.v */, RISCV::VSUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13558 /* vsuxseg6ei8.v */, RISCV::VSUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13572 /* vsuxseg7ei16.v */, RISCV::VSUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13587 /* vsuxseg7ei32.v */, RISCV::VSUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13602 /* vsuxseg7ei64.v */, RISCV::VSUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13617 /* vsuxseg7ei8.v */, RISCV::VSUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13631 /* vsuxseg8ei16.v */, RISCV::VSUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13646 /* vsuxseg8ei32.v */, RISCV::VSUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13661 /* vsuxseg8ei64.v */, RISCV::VSUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13676 /* vsuxseg8ei8.v */, RISCV::VSUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13690 /* vt.maskc */, RISCV::VT_MASKC, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13699 /* vt.maskcn */, RISCV::VT_MASKCN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 13709 /* vwadd.vv */, RISCV::VWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13718 /* vwadd.vx */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13727 /* vwadd.wv */, RISCV::VWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13736 /* vwadd.wx */, RISCV::VWADD_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13745 /* vwaddu.vv */, RISCV::VWADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13755 /* vwaddu.vx */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13765 /* vwaddu.wv */, RISCV::VWADDU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13775 /* vwaddu.wx */, RISCV::VWADDU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13785 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 13785 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13797 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 13797 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13810 /* vwmacc.vv */, RISCV::VWMACC_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13820 /* vwmacc.vx */, RISCV::VWMACC_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13830 /* vwmaccsu.vv */, RISCV::VWMACCSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13842 /* vwmaccsu.vx */, RISCV::VWMACCSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13854 /* vwmaccu.vv */, RISCV::VWMACCU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13865 /* vwmaccu.vx */, RISCV::VWMACCU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13876 /* vwmaccus.vx */, RISCV::VWMACCUS_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13888 /* vwmul.vv */, RISCV::VWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13897 /* vwmul.vx */, RISCV::VWMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13906 /* vwmulsu.vv */, RISCV::VWMULSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13917 /* vwmulsu.vx */, RISCV::VWMULSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13928 /* vwmulu.vv */, RISCV::VWMULU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13938 /* vwmulu.vx */, RISCV::VWMULU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13948 /* vwredsum.vs */, RISCV::VWREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13960 /* vwredsumu.vs */, RISCV::VWREDSUMU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13973 /* vwsll.vi */, RISCV::VWSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 13982 /* vwsll.vv */, RISCV::VWSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13991 /* vwsll.vx */, RISCV::VWSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14000 /* vwsub.vv */, RISCV::VWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14009 /* vwsub.vx */, RISCV::VWSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14018 /* vwsub.wv */, RISCV::VWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14027 /* vwsub.wx */, RISCV::VWSUB_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14036 /* vwsubu.vv */, RISCV::VWSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14046 /* vwsubu.vx */, RISCV::VWSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14056 /* vwsubu.wv */, RISCV::VWSUBU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14066 /* vwsubu.wx */, RISCV::VWSUBU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14076 /* vxor.vi */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14084 /* vxor.vv */, RISCV::VXOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14092 /* vxor.vx */, RISCV::VXOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14100 /* vzext.vf2 */, RISCV::VZEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14110 /* vzext.vf4 */, RISCV::VZEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14120 /* vzext.vf8 */, RISCV::VZEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14130 /* wfi */, RISCV::WFI, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 14134 /* wrs.nto */, RISCV::WRS_NTO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 14142 /* wrs.sto */, RISCV::WRS_STO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 14150 /* xnor */, RISCV::XNOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14155 /* xor */, RISCV::XOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14155 /* xor */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 14159 /* xori */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 14164 /* xperm4 */, RISCV::XPERM4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14171 /* xperm8 */, RISCV::XPERM8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 14178 /* zext.b */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__imm_95_255, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 14185 /* zext.h */, RISCV::ZEXT_H_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 14185 /* zext.h */, RISCV::ZEXT_H_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 14185 /* zext.h */, RISCV::PseudoZEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 14192 /* zext.w */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 14192 /* zext.w */, RISCV::PseudoZEXT_W, Convert__Reg1_0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 14199 /* zip */, RISCV::ZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned RISCVAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 8) {
    ErrorInfo = 8;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((RISCVOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  SmallBitVector OptionalOperandsMask(7);
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    OptionalOperandsMask.reset(0, 7);
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 7; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          OptionalOperandsMask.set(FormalIdx, 7);
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          OptionalOperandsMask.set(FormalIdx);
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        OptionalOperandsMask.set(FormalIdx);
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands, ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands,
                    OptionalOperandsMask);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands, ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[1390] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* .insn_b */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 8 /* .insn_ca */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 17 /* .insn_cb */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 26 /* .insn_ci */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 35 /* .insn_ciw */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 45 /* .insn_cj */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 54 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 63 /* .insn_cr */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 72 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 81 /* .insn_css */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 107 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 107 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 115 /* .insn_r4 */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 124 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 132 /* .insn_sb */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 141 /* .insn_u */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 149 /* .insn_uj */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 149 /* .insn_uj */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 158 /* add */, 8 /* 3 */, MCK_TPRelAddSymbol, AMFBS_None },
  { 284 /* amoadd.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 293 /* amoadd.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 305 /* amoadd.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 319 /* amoadd.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 331 /* amoadd.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 340 /* amoadd.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 352 /* amoadd.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 366 /* amoadd.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 378 /* amoand.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 387 /* amoand.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 399 /* amoand.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 413 /* amoand.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 425 /* amoand.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 434 /* amoand.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 446 /* amoand.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 460 /* amoand.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 472 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 481 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 493 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 507 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 519 /* amocas.q */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 528 /* amocas.q.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 540 /* amocas.q.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 554 /* amocas.q.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 566 /* amocas.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 575 /* amocas.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 587 /* amocas.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 601 /* amocas.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 613 /* amomax.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 622 /* amomax.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 634 /* amomax.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 648 /* amomax.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 660 /* amomax.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 669 /* amomax.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 681 /* amomax.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 695 /* amomax.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 707 /* amomaxu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 717 /* amomaxu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 730 /* amomaxu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 745 /* amomaxu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 758 /* amomaxu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 768 /* amomaxu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 781 /* amomaxu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 796 /* amomaxu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 809 /* amomin.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 818 /* amomin.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 830 /* amomin.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 844 /* amomin.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 856 /* amomin.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 865 /* amomin.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 877 /* amomin.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 891 /* amomin.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 903 /* amominu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 913 /* amominu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 926 /* amominu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 941 /* amominu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 954 /* amominu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 964 /* amominu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 977 /* amominu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 992 /* amominu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1005 /* amoor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1013 /* amoor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1024 /* amoor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1037 /* amoor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1048 /* amoor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1056 /* amoor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1067 /* amoor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1080 /* amoor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1091 /* amoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1101 /* amoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1114 /* amoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1129 /* amoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1142 /* amoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1152 /* amoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1165 /* amoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1180 /* amoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1193 /* amoxor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1202 /* amoxor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1214 /* amoxor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1228 /* amoxor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1240 /* amoxor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1249 /* amoxor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1261 /* amoxor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1275 /* amoxor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1868 /* call */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 1868 /* call */, 2 /* 1 */, MCK_CallSymbol, AMFBS_None },
  { 1873 /* cbo.clean */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1883 /* cbo.flush */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1893 /* cbo.inval */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1903 /* cbo.zero */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicboz },
  { 2007 /* cm.pop */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2007 /* cm.pop */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2014 /* cm.popret */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2014 /* cm.popret */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2024 /* cm.popretz */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2024 /* cm.popretz */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2035 /* cm.push */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2035 /* cm.push */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2054 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2054 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2059 /* csrci */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2065 /* csrr */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2070 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2070 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2076 /* csrrci */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2083 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2083 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2089 /* csrrsi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2096 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2096 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2102 /* csrrwi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2109 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2109 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2114 /* csrsi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2120 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2120 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2125 /* csrwi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2564 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2564 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2571 /* fabs.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2578 /* fabs.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2585 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 2585 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2585 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2585 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2585 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2592 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2592 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2592 /* fadd.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2599 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2599 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2599 /* fadd.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2606 /* fclass.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2606 /* fclass.d */, 2 /* 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2615 /* fclass.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2624 /* fclass.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2633 /* fcvt.bf16.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 2645 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64 },
  { 2645 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64 },
  { 2645 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32 },
  { 2645 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32 },
  { 2654 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 2654 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2654 /* fcvt.d.l */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2663 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 2663 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2663 /* fcvt.d.lu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2673 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2673 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2673 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2673 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2682 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2682 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2691 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2691 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2701 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhOrZfhmin_HasStdExtD },
  { 2701 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64 },
  { 2701 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64 },
  { 2701 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV64 },
  { 2701 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32 },
  { 2701 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32 },
  { 2701 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZhinxOrZhinxmin_HasStdExtZdinx_IsRV32 },
  { 2710 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 2710 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2710 /* fcvt.h.l */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2719 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 2719 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2719 /* fcvt.h.lu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2729 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhOrZfhmin },
  { 2729 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxOrZhinxmin },
  { 2729 /* fcvt.h.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin },
  { 2738 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2738 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2738 /* fcvt.h.w */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2747 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2747 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2747 /* fcvt.h.wu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2757 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 2757 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2757 /* fcvt.l.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2766 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 2766 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2766 /* fcvt.l.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2775 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 2775 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2775 /* fcvt.l.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2784 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 2784 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2784 /* fcvt.lu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 2794 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 2794 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2794 /* fcvt.lu.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 2804 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 2804 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2804 /* fcvt.lu.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2814 /* fcvt.s.bf16 */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 2826 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 2826 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2826 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2826 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2826 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2826 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2826 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2835 /* fcvt.s.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxOrZhinxmin },
  { 2844 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 2844 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2844 /* fcvt.s.l */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2853 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 2853 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2853 /* fcvt.s.lu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 2863 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2863 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2863 /* fcvt.s.w */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2872 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2872 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2872 /* fcvt.s.wu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2882 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 2882 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2882 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2882 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2882 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2891 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2891 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2891 /* fcvt.w.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2900 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2900 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2900 /* fcvt.w.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2909 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 2909 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2909 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2909 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2909 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2919 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2919 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2919 /* fcvt.wu.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2929 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2929 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2929 /* fcvt.wu.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2939 /* fcvtmod.w.d */, 4 /* 2 */, MCK_RTZArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 2951 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 2951 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2951 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2951 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2951 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 2958 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 2958 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 2958 /* fdiv.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 2965 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 2965 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 2965 /* fdiv.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 2972 /* fence */, 3 /* 0, 1 */, MCK_FenceArg, AMFBS_None },
  { 2996 /* feq.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 2996 /* feq.d */, 6 /* 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3002 /* feq.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3008 /* feq.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3014 /* fge.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3014 /* fge.d */, 6 /* 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3020 /* fge.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3026 /* fge.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3053 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3053 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3059 /* fgt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3065 /* fgt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3092 /* fld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 3096 /* fle.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3096 /* fle.d */, 6 /* 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3102 /* fle.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3108 /* fle.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3135 /* flh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhOrZfhmin },
  { 3139 /* fli.d */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtD },
  { 3145 /* fli.h */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh },
  { 3151 /* fli.s */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa },
  { 3157 /* flt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3157 /* flt.d */, 6 /* 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3163 /* flt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3169 /* flt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3196 /* flw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 3200 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3200 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3200 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3200 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3200 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3208 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3208 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3208 /* fmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3216 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3216 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3216 /* fmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3224 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3224 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3231 /* fmax.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3238 /* fmax.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3269 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3269 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3276 /* fmin.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3283 /* fmin.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3314 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3314 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3314 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3314 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3314 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3322 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3322 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3322 /* fmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3330 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3330 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3330 /* fmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3338 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3338 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3338 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3338 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3338 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3345 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3345 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3345 /* fmul.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3352 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3352 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3352 /* fmul.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3373 /* fmv.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3443 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3443 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3450 /* fneg.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3457 /* fneg.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3464 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3464 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3464 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3464 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3464 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3473 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3473 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3473 /* fnmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3482 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3482 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3482 /* fnmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3491 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3491 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3491 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3491 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3491 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3500 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3500 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3500 /* fnmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3509 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3509 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3509 /* fnmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3532 /* fround.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 3541 /* fround.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 3550 /* fround.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 3559 /* froundnx.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 3570 /* froundnx.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 3581 /* froundnx.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 3608 /* fsd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 3629 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3629 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3637 /* fsgnj.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3645 /* fsgnj.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3653 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3653 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3662 /* fsgnjn.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3671 /* fsgnjn.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3680 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3680 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3689 /* fsgnjx.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3698 /* fsgnjx.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3707 /* fsh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhOrZfhmin },
  { 3711 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3711 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3711 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3711 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3711 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3719 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3719 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3719 /* fsqrt.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3727 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3727 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3727 /* fsqrt.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3751 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 3751 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3751 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 3751 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3751 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRPF64AsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 3758 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 3758 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 3758 /* fsub.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 3765 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 3765 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 3765 /* fsub.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 3772 /* fsw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 3824 /* hlv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3830 /* hlv.bu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3837 /* hlv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 3843 /* hlv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3849 /* hlv.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3856 /* hlv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3862 /* hlv.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 3869 /* hlvx.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3877 /* hlvx.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3885 /* hsv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3891 /* hsv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 3897 /* hsv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3903 /* hsv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 3909 /* j */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 3911 /* jal */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 3911 /* jal */, 2 /* 1 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 3923 /* jump */, 1 /* 0 */, MCK_PseudoJumpSymbol, AMFBS_None },
  { 3928 /* la */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3931 /* la.tls.gd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3941 /* la.tls.ie */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3951 /* lb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3954 /* lbu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3958 /* ld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 3961 /* lga */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3965 /* lh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3968 /* lhu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3975 /* lla */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 3979 /* lr.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 3984 /* lr.d.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 3992 /* lr.d.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4002 /* lr.d.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4010 /* lr.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4015 /* lr.w.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4023 /* lr.w.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4033 /* lr.w.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4045 /* lw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 4048 /* lwu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 4337 /* sb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 4340 /* sc.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4345 /* sc.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4353 /* sc.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4363 /* sc.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 4371 /* sc.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4376 /* sc.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4384 /* sc.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4394 /* sc.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 4402 /* sd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 4779 /* sh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 5140 /* sw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 5143 /* tail */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 6131 /* th.vmaqa.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6143 /* th.vmaqa.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6155 /* th.vmaqasu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6169 /* th.vmaqasu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6183 /* th.vmaqau.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6196 /* th.vmaqau.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6209 /* th.vmaqaus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 6235 /* vaadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6244 /* vaadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6253 /* vaaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6263 /* vaaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6300 /* vadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6308 /* vadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6316 /* vadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6435 /* vand.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6443 /* vand.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6451 /* vand.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6459 /* vandn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6468 /* vandn.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6477 /* vasub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6486 /* vasub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6495 /* vasubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6505 /* vasubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6515 /* vbrev.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6523 /* vbrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6532 /* vclmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 6542 /* vclmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 6552 /* vclmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 6563 /* vclmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 6574 /* vclz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6594 /* vcpop.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6602 /* vcpop.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6610 /* vctz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 6617 /* vdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6625 /* vdiv.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6633 /* vdivu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6642 /* vdivu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6651 /* vfabs.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6659 /* vfadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6668 /* vfadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6677 /* vfclass.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6687 /* vfcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6699 /* vfcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6712 /* vfcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6728 /* vfcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6745 /* vfcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6757 /* vfcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6770 /* vfdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6779 /* vfdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6788 /* vfirst.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 6797 /* vfmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6807 /* vfmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6817 /* vfmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6827 /* vfmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6837 /* vfmax.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6846 /* vfmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6867 /* vfmin.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6876 /* vfmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6885 /* vfmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6895 /* vfmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6905 /* vfmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6915 /* vfmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6925 /* vfmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6934 /* vfmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6970 /* vfncvt.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6983 /* vfncvt.f.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 6996 /* vfncvt.f.xu.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7010 /* vfncvt.rod.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7027 /* vfncvt.rtz.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7044 /* vfncvt.rtz.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7062 /* vfncvt.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7075 /* vfncvt.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7089 /* vfncvtbf16.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 7106 /* vfneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7114 /* vfnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7125 /* vfnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7136 /* vfnmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7147 /* vfnmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7158 /* vfnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7169 /* vfnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7180 /* vfnmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7191 /* vfnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7202 /* vfrdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7212 /* vfrec7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7221 /* vfredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7233 /* vfredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7245 /* vfredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7258 /* vfredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7270 /* vfredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7283 /* vfrsqrt7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7294 /* vfrsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7304 /* vfsgnj.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7314 /* vfsgnj.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7324 /* vfsgnjn.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7335 /* vfsgnjn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7346 /* vfsgnjx.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7357 /* vfsgnjx.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7368 /* vfslide1down.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7384 /* vfslide1up.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7398 /* vfsqrt.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7407 /* vfsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7416 /* vfsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7425 /* vfwadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7435 /* vfwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7445 /* vfwadd.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7455 /* vfwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7465 /* vfwcvt.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7478 /* vfwcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7491 /* vfwcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7505 /* vfwcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7522 /* vfwcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7540 /* vfwcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7553 /* vfwcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7567 /* vfwcvtbf16.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 7584 /* vfwmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7595 /* vfwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7606 /* vfwmaccbf16.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 7621 /* vfwmaccbf16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 7636 /* vfwmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7647 /* vfwmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7658 /* vfwmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7668 /* vfwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7678 /* vfwnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7690 /* vfwnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7702 /* vfwnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7714 /* vfwnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7726 /* vfwredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7740 /* vfwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7753 /* vfwredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7767 /* vfwsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7777 /* vfwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7787 /* vfwsub.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7797 /* vfwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 7825 /* vid.v */, 2 /* 1 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 7831 /* viota.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 7846 /* vl1re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7856 /* vl1re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7866 /* vl1re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 7876 /* vl1re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7892 /* vl2re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7902 /* vl2re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7912 /* vl2re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 7922 /* vl2re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7938 /* vl4re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7948 /* vl4re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7958 /* vl4re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 7968 /* vl4re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7984 /* vl8re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 7994 /* vl8re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8004 /* vl8re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8014 /* vl8re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8030 /* vle16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8030 /* vle16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8038 /* vle16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8038 /* vle16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8048 /* vle32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8048 /* vle32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8056 /* vle32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8056 /* vle32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8066 /* vle64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8066 /* vle64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8074 /* vle64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8074 /* vle64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8084 /* vle8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8084 /* vle8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8091 /* vle8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8091 /* vle8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8100 /* vlm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8106 /* vloxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8106 /* vloxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8117 /* vloxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8117 /* vloxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8128 /* vloxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 8128 /* vloxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 8139 /* vloxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8139 /* vloxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8149 /* vloxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8149 /* vloxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8164 /* vloxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8164 /* vloxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8179 /* vloxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8179 /* vloxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8194 /* vloxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8194 /* vloxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8208 /* vloxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8208 /* vloxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8223 /* vloxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8223 /* vloxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8238 /* vloxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8238 /* vloxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8253 /* vloxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8253 /* vloxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8267 /* vloxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8267 /* vloxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8282 /* vloxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8282 /* vloxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8297 /* vloxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8297 /* vloxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8312 /* vloxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8312 /* vloxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8326 /* vloxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8326 /* vloxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8341 /* vloxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8341 /* vloxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8356 /* vloxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8356 /* vloxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8371 /* vloxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8371 /* vloxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8385 /* vloxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8385 /* vloxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8400 /* vloxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8400 /* vloxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8415 /* vloxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8415 /* vloxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8430 /* vloxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8430 /* vloxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8444 /* vloxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8444 /* vloxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8459 /* vloxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8459 /* vloxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8474 /* vloxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8474 /* vloxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8489 /* vloxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8489 /* vloxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8503 /* vloxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8503 /* vloxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8518 /* vloxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8518 /* vloxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8533 /* vloxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8533 /* vloxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 8548 /* vloxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8548 /* vloxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8562 /* vlse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8562 /* vlse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8571 /* vlse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8571 /* vlse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8580 /* vlse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8580 /* vlse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8589 /* vlse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8589 /* vlse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8597 /* vlseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8597 /* vlseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8609 /* vlseg2e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8609 /* vlseg2e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8623 /* vlseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8623 /* vlseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8635 /* vlseg2e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8635 /* vlseg2e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8649 /* vlseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8649 /* vlseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8661 /* vlseg2e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8661 /* vlseg2e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8675 /* vlseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8675 /* vlseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8686 /* vlseg2e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8686 /* vlseg2e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8699 /* vlseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8699 /* vlseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8711 /* vlseg3e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8711 /* vlseg3e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8725 /* vlseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8725 /* vlseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8737 /* vlseg3e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8737 /* vlseg3e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8751 /* vlseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8751 /* vlseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8763 /* vlseg3e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8763 /* vlseg3e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8777 /* vlseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8777 /* vlseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8788 /* vlseg3e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8788 /* vlseg3e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8801 /* vlseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8801 /* vlseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8813 /* vlseg4e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8813 /* vlseg4e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8827 /* vlseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8827 /* vlseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8839 /* vlseg4e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8839 /* vlseg4e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8853 /* vlseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8853 /* vlseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8865 /* vlseg4e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8865 /* vlseg4e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8879 /* vlseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8879 /* vlseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8890 /* vlseg4e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8890 /* vlseg4e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8903 /* vlseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8903 /* vlseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8915 /* vlseg5e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8915 /* vlseg5e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8929 /* vlseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8929 /* vlseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8941 /* vlseg5e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8941 /* vlseg5e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8955 /* vlseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8955 /* vlseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8967 /* vlseg5e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 8967 /* vlseg5e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 8981 /* vlseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8981 /* vlseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 8992 /* vlseg5e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 8992 /* vlseg5e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9005 /* vlseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9005 /* vlseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9017 /* vlseg6e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9017 /* vlseg6e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9031 /* vlseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9031 /* vlseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9043 /* vlseg6e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9043 /* vlseg6e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9057 /* vlseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9057 /* vlseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9069 /* vlseg6e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9069 /* vlseg6e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9083 /* vlseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9083 /* vlseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9094 /* vlseg6e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9094 /* vlseg6e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9107 /* vlseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9107 /* vlseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9119 /* vlseg7e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9119 /* vlseg7e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9133 /* vlseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9133 /* vlseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9145 /* vlseg7e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9145 /* vlseg7e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9159 /* vlseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9159 /* vlseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9171 /* vlseg7e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9171 /* vlseg7e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9185 /* vlseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9185 /* vlseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9196 /* vlseg7e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9196 /* vlseg7e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9209 /* vlseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9209 /* vlseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9221 /* vlseg8e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9221 /* vlseg8e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9235 /* vlseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9235 /* vlseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9247 /* vlseg8e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9247 /* vlseg8e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9261 /* vlseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9261 /* vlseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9273 /* vlseg8e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9273 /* vlseg8e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9287 /* vlseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9287 /* vlseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9298 /* vlseg8e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9298 /* vlseg8e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9311 /* vlsseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9311 /* vlsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9324 /* vlsseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9324 /* vlsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9337 /* vlsseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9337 /* vlsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9350 /* vlsseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9350 /* vlsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9362 /* vlsseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9362 /* vlsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9375 /* vlsseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9375 /* vlsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9388 /* vlsseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9388 /* vlsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9401 /* vlsseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9401 /* vlsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9413 /* vlsseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9413 /* vlsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9426 /* vlsseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9426 /* vlsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9439 /* vlsseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9439 /* vlsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9452 /* vlsseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9452 /* vlsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9464 /* vlsseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9464 /* vlsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9477 /* vlsseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9477 /* vlsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9490 /* vlsseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9490 /* vlsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9503 /* vlsseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9503 /* vlsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9515 /* vlsseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9515 /* vlsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9528 /* vlsseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9528 /* vlsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9541 /* vlsseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9541 /* vlsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9554 /* vlsseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9554 /* vlsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9566 /* vlsseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9566 /* vlsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9579 /* vlsseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9579 /* vlsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9592 /* vlsseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9592 /* vlsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9605 /* vlsseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9605 /* vlsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9617 /* vlsseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9617 /* vlsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9630 /* vlsseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9630 /* vlsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9643 /* vlsseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 9643 /* vlsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 9656 /* vlsseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9656 /* vlsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9668 /* vluxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9668 /* vluxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9679 /* vluxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9679 /* vluxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9690 /* vluxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 9690 /* vluxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 9701 /* vluxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9701 /* vluxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9711 /* vluxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9711 /* vluxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9726 /* vluxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9726 /* vluxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9741 /* vluxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9741 /* vluxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9756 /* vluxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9756 /* vluxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9770 /* vluxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9770 /* vluxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9785 /* vluxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9785 /* vluxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9800 /* vluxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9800 /* vluxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9815 /* vluxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9815 /* vluxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9829 /* vluxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9829 /* vluxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9844 /* vluxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9844 /* vluxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9859 /* vluxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9859 /* vluxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9874 /* vluxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9874 /* vluxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9888 /* vluxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9888 /* vluxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9903 /* vluxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9903 /* vluxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9918 /* vluxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9918 /* vluxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9933 /* vluxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9933 /* vluxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9947 /* vluxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9947 /* vluxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9962 /* vluxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9962 /* vluxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 9977 /* vluxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9977 /* vluxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 9992 /* vluxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 9992 /* vluxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10006 /* vluxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10006 /* vluxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10021 /* vluxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10021 /* vluxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10036 /* vluxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 10036 /* vluxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 10051 /* vluxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10051 /* vluxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10065 /* vluxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10065 /* vluxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10080 /* vluxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10080 /* vluxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10095 /* vluxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 10095 /* vluxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 10110 /* vluxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10110 /* vluxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 10124 /* vmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10133 /* vmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10199 /* vmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10208 /* vmadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10248 /* vmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10256 /* vmax.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10264 /* vmaxu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10273 /* vmaxu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10323 /* vmfeq.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10332 /* vmfeq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10341 /* vmfge.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10350 /* vmfge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10359 /* vmfgt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10368 /* vmfgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10377 /* vmfle.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10386 /* vmfle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10395 /* vmflt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10404 /* vmflt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10413 /* vmfne.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10422 /* vmfne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10431 /* vmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10439 /* vmin.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10447 /* vminu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10456 /* vminu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10565 /* vmsbf.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10573 /* vmseq.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10582 /* vmseq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10591 /* vmseq.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10608 /* vmsge.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10617 /* vmsge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10626 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10626 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10635 /* vmsgeu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10645 /* vmsgeu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10655 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10655 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10665 /* vmsgt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10674 /* vmsgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10683 /* vmsgt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10692 /* vmsgtu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10702 /* vmsgtu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10712 /* vmsgtu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10722 /* vmsif.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10730 /* vmsle.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10739 /* vmsle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10748 /* vmsle.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10757 /* vmsleu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10767 /* vmsleu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10777 /* vmsleu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10787 /* vmslt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10796 /* vmslt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10805 /* vmslt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10814 /* vmsltu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10824 /* vmsltu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10834 /* vmsltu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10844 /* vmsne.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10853 /* vmsne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10862 /* vmsne.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10871 /* vmsof.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10879 /* vmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10887 /* vmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10895 /* vmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10904 /* vmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10913 /* vmulhsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10924 /* vmulhsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10935 /* vmulhu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10945 /* vmulhu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11046 /* vnclip.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11056 /* vnclip.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11066 /* vnclip.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11076 /* vnclipu.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11087 /* vnclipu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11098 /* vnclipu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11109 /* vncvt.x.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11121 /* vneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11128 /* vnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11138 /* vnmsac.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11148 /* vnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11158 /* vnmsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11168 /* vnot.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11175 /* vnsra.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11184 /* vnsra.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11193 /* vnsra.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11202 /* vnsrl.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11211 /* vnsrl.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11220 /* vnsrl.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11229 /* vor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11236 /* vor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11243 /* vor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11250 /* vpopc.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11258 /* vredand.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11269 /* vredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11280 /* vredmaxu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11292 /* vredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11303 /* vredminu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11315 /* vredor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11325 /* vredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11336 /* vredxor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11347 /* vrem.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11355 /* vrem.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11363 /* vremu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11372 /* vremu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11381 /* vrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11389 /* vrgather.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11401 /* vrgather.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11413 /* vrgather.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11425 /* vrgatherei16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11441 /* vrol.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11449 /* vrol.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11457 /* vror.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11465 /* vror.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11473 /* vror.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 11481 /* vrsub.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11490 /* vrsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11499 /* vs1r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11506 /* vs2r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11513 /* vs4r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11520 /* vs8r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11527 /* vsadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11536 /* vsadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11545 /* vsadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11554 /* vsaddu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11564 /* vsaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11574 /* vsaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11609 /* vse16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11609 /* vse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11617 /* vse32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11617 /* vse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11625 /* vse64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 11625 /* vse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 11633 /* vse8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11633 /* vse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11640 /* vsetivli */, 4 /* 2 */, MCK_VTypeI10, AMFBS_HasVInstructions },
  { 11656 /* vsetvli */, 4 /* 2 */, MCK_VTypeI11, AMFBS_HasVInstructions },
  { 11664 /* vsext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11674 /* vsext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11684 /* vsext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11727 /* vslide1down.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11742 /* vslide1up.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11755 /* vslidedown.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11769 /* vslidedown.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11783 /* vslideup.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11795 /* vslideup.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11807 /* vsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11815 /* vsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11823 /* vsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11831 /* vsm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11883 /* vsmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11892 /* vsmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11901 /* vsoxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11901 /* vsoxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11912 /* vsoxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11912 /* vsoxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11923 /* vsoxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 11923 /* vsoxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 11934 /* vsoxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11934 /* vsoxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11944 /* vsoxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11944 /* vsoxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11959 /* vsoxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11959 /* vsoxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11974 /* vsoxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 11974 /* vsoxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 11989 /* vsoxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11989 /* vsoxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12003 /* vsoxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12003 /* vsoxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12018 /* vsoxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12018 /* vsoxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12033 /* vsoxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12033 /* vsoxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12048 /* vsoxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12048 /* vsoxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12062 /* vsoxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12062 /* vsoxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12077 /* vsoxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12077 /* vsoxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12092 /* vsoxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12092 /* vsoxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12107 /* vsoxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12107 /* vsoxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12121 /* vsoxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12121 /* vsoxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12136 /* vsoxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12136 /* vsoxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12151 /* vsoxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12151 /* vsoxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12166 /* vsoxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12166 /* vsoxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12180 /* vsoxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12180 /* vsoxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12195 /* vsoxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12195 /* vsoxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12210 /* vsoxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12210 /* vsoxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12225 /* vsoxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12225 /* vsoxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12239 /* vsoxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12239 /* vsoxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12254 /* vsoxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12254 /* vsoxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12269 /* vsoxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12269 /* vsoxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12284 /* vsoxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12284 /* vsoxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12298 /* vsoxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12298 /* vsoxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12313 /* vsoxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12313 /* vsoxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12328 /* vsoxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12328 /* vsoxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12343 /* vsoxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12343 /* vsoxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12357 /* vsra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12365 /* vsra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12373 /* vsra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12381 /* vsrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12389 /* vsrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12397 /* vsrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12405 /* vsse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12405 /* vsse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12414 /* vsse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12414 /* vsse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12423 /* vsse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12423 /* vsse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12432 /* vsse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12432 /* vsse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12440 /* vsseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12440 /* vsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12452 /* vsseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12452 /* vsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12464 /* vsseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12464 /* vsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12476 /* vsseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12476 /* vsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12487 /* vsseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12487 /* vsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12499 /* vsseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12499 /* vsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12511 /* vsseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12511 /* vsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12523 /* vsseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12523 /* vsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12534 /* vsseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12534 /* vsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12546 /* vsseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12546 /* vsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12558 /* vsseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12558 /* vsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12570 /* vsseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12570 /* vsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12581 /* vsseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12581 /* vsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12593 /* vsseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12593 /* vsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12605 /* vsseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12605 /* vsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12617 /* vsseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12617 /* vsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12628 /* vsseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12628 /* vsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12640 /* vsseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12640 /* vsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12652 /* vsseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12652 /* vsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12664 /* vsseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12664 /* vsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12675 /* vsseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12675 /* vsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12687 /* vsseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12687 /* vsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12699 /* vsseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12699 /* vsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12711 /* vsseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12711 /* vsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12722 /* vsseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12722 /* vsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12734 /* vsseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12734 /* vsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12746 /* vsseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12746 /* vsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12758 /* vsseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12758 /* vsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12769 /* vssra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12778 /* vssra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12787 /* vssra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12796 /* vssrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12805 /* vssrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12814 /* vssrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12823 /* vssseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12823 /* vssseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12836 /* vssseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12836 /* vssseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12849 /* vssseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12849 /* vssseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12862 /* vssseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12862 /* vssseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12874 /* vssseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12874 /* vssseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12887 /* vssseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12887 /* vssseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12900 /* vssseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12900 /* vssseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12913 /* vssseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12913 /* vssseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12925 /* vssseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12925 /* vssseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12938 /* vssseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12938 /* vssseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12951 /* vssseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12951 /* vssseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12964 /* vssseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12964 /* vssseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12976 /* vssseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12976 /* vssseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12989 /* vssseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12989 /* vssseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13002 /* vssseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13002 /* vssseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13015 /* vssseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13015 /* vssseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13027 /* vssseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13027 /* vssseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13040 /* vssseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13040 /* vssseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13053 /* vssseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13053 /* vssseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13066 /* vssseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13066 /* vssseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13078 /* vssseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13078 /* vssseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13091 /* vssseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13091 /* vssseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13104 /* vssseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13104 /* vssseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13117 /* vssseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13117 /* vssseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13129 /* vssseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13129 /* vssseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13142 /* vssseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13142 /* vssseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13155 /* vssseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13155 /* vssseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13168 /* vssseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13168 /* vssseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13180 /* vssub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13189 /* vssub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13198 /* vssubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13208 /* vssubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13218 /* vsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13226 /* vsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13234 /* vsuxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13234 /* vsuxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13245 /* vsuxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13245 /* vsuxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13256 /* vsuxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 13256 /* vsuxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 13267 /* vsuxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13267 /* vsuxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13277 /* vsuxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13277 /* vsuxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13292 /* vsuxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13292 /* vsuxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13307 /* vsuxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13307 /* vsuxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13322 /* vsuxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13322 /* vsuxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13336 /* vsuxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13336 /* vsuxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13351 /* vsuxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13351 /* vsuxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13366 /* vsuxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13366 /* vsuxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13381 /* vsuxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13381 /* vsuxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13395 /* vsuxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13395 /* vsuxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13410 /* vsuxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13410 /* vsuxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13425 /* vsuxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13425 /* vsuxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13440 /* vsuxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13440 /* vsuxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13454 /* vsuxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13454 /* vsuxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13469 /* vsuxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13469 /* vsuxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13484 /* vsuxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13484 /* vsuxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13499 /* vsuxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13499 /* vsuxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13513 /* vsuxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13513 /* vsuxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13528 /* vsuxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13528 /* vsuxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13543 /* vsuxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13543 /* vsuxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13558 /* vsuxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13558 /* vsuxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13572 /* vsuxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13572 /* vsuxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13587 /* vsuxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13587 /* vsuxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13602 /* vsuxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13602 /* vsuxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13617 /* vsuxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13617 /* vsuxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13631 /* vsuxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13631 /* vsuxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13646 /* vsuxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13646 /* vsuxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13661 /* vsuxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13661 /* vsuxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13676 /* vsuxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13676 /* vsuxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13709 /* vwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13718 /* vwadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13727 /* vwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13736 /* vwadd.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13745 /* vwaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13755 /* vwaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13765 /* vwaddu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13775 /* vwaddu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13785 /* vwcvt.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13797 /* vwcvtu.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13810 /* vwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13820 /* vwmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13830 /* vwmaccsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13842 /* vwmaccsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13854 /* vwmaccu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13865 /* vwmaccu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13876 /* vwmaccus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13888 /* vwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13897 /* vwmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13906 /* vwmulsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13917 /* vwmulsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13928 /* vwmulu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13938 /* vwmulu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13948 /* vwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13960 /* vwredsumu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13973 /* vwsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 13982 /* vwsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 13991 /* vwsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 14000 /* vwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14009 /* vwsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14018 /* vwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14027 /* vwsub.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14036 /* vwsubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14046 /* vwsubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14056 /* vwsubu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14066 /* vwsubu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14076 /* vxor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14084 /* vxor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14092 /* vxor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14100 /* vzext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14110 /* vzext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14120 /* vzext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
};

ParseStatus RISCVAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_BareSymbol:
    return parseBareSymbol(Operands);
  case MCK_CSRSystemRegister:
    return parseCSRSystemRegister(Operands);
  case MCK_CallSymbol:
    return parseCallSymbol(Operands);
  case MCK_FRMArg:
    return parseFRMArg(Operands);
  case MCK_FenceArg:
    return parseFenceArg(Operands);
  case MCK_GPRAsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_GPRF64AsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_GPRPF64AsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_InsnCDirectiveOpcode:
    return parseInsnCDirectiveOpcode(Operands);
  case MCK_InsnDirectiveOpcode:
    return parseInsnDirectiveOpcode(Operands);
  case MCK_LoadFPImm:
    return parseFPImm(Operands);
  case MCK_PseudoJumpSymbol:
    return parsePseudoJumpSymbol(Operands);
  case MCK_RTZArg:
    return parseFRMArg(Operands);
  case MCK_Rlist:
    return parseReglist(Operands);
  case MCK_SImm21Lsb0JAL:
    return parseJALOffset(Operands);
  case MCK_Spimm:
    return parseZcmpSpimm(Operands);
  case MCK_TPRelAddSymbol:
    return parseOperandWithModifier(Operands);
  case MCK_RVVMaskRegOpOperand:
    return parseMaskReg(Operands);
  case MCK_ZeroOffsetMemOpOperand:
    return parseZeroOffsetMemOp(Operands);
  case MCK_VTypeI10:
    return parseVTypeI(Operands);
  case MCK_VTypeI11:
    return parseVTypeI(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus RISCVAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string RISCVMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T.equals(Prev))
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool RISCVCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

