/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 59;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 32;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtMBit = 15,
  Feature_HasStdExtMOrZmmulBit = 14,
  Feature_HasStdExtABit = 17,
  Feature_HasStdExtFBit = 4,
  Feature_HasStdExtDBit = 6,
  Feature_HasStdExtZfhminBit = 20,
  Feature_HasStdExtZfhBit = 8,
  Feature_NoStdExtZfhBit = 21,
  Feature_HasStdExtZfhOrZfhminBit = 18,
  Feature_HasStdExtZfinxBit = 5,
  Feature_HasStdExtZdinxBit = 7,
  Feature_HasStdExtZhinxminBit = 22,
  Feature_HasStdExtZhinxBit = 9,
  Feature_NoStdExtZhinxBit = 23,
  Feature_HasStdExtZhinxOrZhinxminBit = 19,
  Feature_HasStdExtZfaBit = 25,
  Feature_HasStdExtCBit = 11,
  Feature_HasStdExtZbaBit = 30,
  Feature_NotHasStdExtZbaBit = 13,
  Feature_HasStdExtZbbBit = 28,
  Feature_HasStdExtZbcBit = 32,
  Feature_HasStdExtZbsBit = 27,
  Feature_HasStdExtZbkbBit = 29,
  Feature_HasStdExtZbkxBit = 33,
  Feature_HasStdExtZbbOrZbkbBit = 26,
  Feature_HasStdExtZbcOrZbkcBit = 31,
  Feature_HasStdExtZkndBit = 34,
  Feature_HasStdExtZkneBit = 36,
  Feature_HasStdExtZkndOrZkneBit = 35,
  Feature_HasStdExtZknhBit = 37,
  Feature_HasStdExtZksedBit = 38,
  Feature_HasStdExtZkshBit = 39,
  Feature_HasVInstructionsBit = 10,
  Feature_HasVInstructionsI64Bit = 42,
  Feature_HasVInstructionsAnyFBit = 41,
  Feature_HasVInstructionsF64Bit = 44,
  Feature_HasVInstructionsFullMultiplyBit = 43,
  Feature_HasVInstructionsF16Bit = 40,
  Feature_HasStdExtZicbopBit = 46,
  Feature_HasStdExtZvbbBit = 45,
  Feature_HasStdExtZicondBit = 47,
  Feature_HasStdExtZfbfminBit = 24,
  Feature_HasVendorXVentanaCondOpsBit = 48,
  Feature_HasVendorXTHeadBaBit = 49,
  Feature_HasVendorXTHeadBbBit = 50,
  Feature_HasVendorXTHeadBsBit = 51,
  Feature_HasVendorXTHeadCondMovBit = 52,
  Feature_HasVendorXTHeadFMemIdxBit = 57,
  Feature_HasVendorXTHeadMacBit = 53,
  Feature_HasVendorXTHeadMemIdxBit = 56,
  Feature_HasVendorXTHeadMemPairBit = 55,
  Feature_HasVendorXTHeadVdotBit = 54,
  Feature_HasVendorXSfvcpBit = 58,
  Feature_IsRV64Bit = 3,
  Feature_IsRV32Bit = 2,
  Feature_HasShortForwardBranchOptBit = 0,
  Feature_NoShortForwardBranchOptBit = 1,
  Feature_HasAtomicLdStBit = 16,
  Feature_OptForMinSizeBit = 12,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtM() || Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (!Subtarget->hasStdExtZfh())
    Features.set(Feature_NoStdExtZfhBit);
  if (Subtarget->hasStdExtZfhOrZfhmin())
    Features.set(Feature_HasStdExtZfhOrZfhminBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (!Subtarget->hasStdExtZhinx())
    Features.set(Feature_NoStdExtZhinxBit);
  if (Subtarget->hasStdExtZhinx() || Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxOrZhinxminBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtZfbfmin())
    Features.set(Feature_HasStdExtZfbfminBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasStdExtA,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtM,
  GIFBS_HasStdExtMOrZmmul,
  GIFBS_HasStdExtZbb,
  GIFBS_HasStdExtZbbOrZbkb,
  GIFBS_HasStdExtZbkx,
  GIFBS_HasStdExtZbs,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinxOrZhinxmin,
  GIFBS_HasVInstructions,
  GIFBS_HasVInstructionsAnyF,
  GIFBS_HasVInstructionsF16,
  GIFBS_HasVInstructionsF64,
  GIFBS_HasVInstructionsFullMultiply,
  GIFBS_HasVInstructionsI64,
  GIFBS_HasVendorXTHeadBa,
  GIFBS_HasVendorXTHeadBb,
  GIFBS_HasVendorXTHeadBs,
  GIFBS_HasVendorXTHeadCondMov,
  GIFBS_HasVendorXTHeadMac,
  GIFBS_IsRV64,
  GIFBS_HasStdExtA_IsRV64,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtD_IsRV32,
  GIFBS_HasStdExtD_IsRV64,
  GIFBS_HasStdExtF_IsRV32,
  GIFBS_HasStdExtF_IsRV64,
  GIFBS_HasStdExtZba_IsRV64,
  GIFBS_HasStdExtZbb_IsRV32,
  GIFBS_HasStdExtZbb_IsRV64,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV64,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfh_IsRV32,
  GIFBS_HasStdExtZfh_IsRV64,
  GIFBS_HasStdExtZfinx_IsRV32,
  GIFBS_HasStdExtZfinx_IsRV64,
  GIFBS_HasStdExtZhinx_IsRV32,
  GIFBS_HasStdExtZhinx_IsRV64,
  GIFBS_HasStdExtZknd_IsRV32,
  GIFBS_HasStdExtZknd_IsRV64,
  GIFBS_HasStdExtZkndOrZkne_IsRV64,
  GIFBS_HasStdExtZkne_IsRV32,
  GIFBS_HasStdExtZkne_IsRV64,
  GIFBS_HasStdExtZknh_IsRV32,
  GIFBS_HasStdExtZknh_IsRV64,
  GIFBS_HasStdExtZvbb_HasVInstructions,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64,
  GIFBS_HasVInstructions_HasVInstructionsAnyF,
  GIFBS_HasVInstructions_HasVInstructionsF16,
  GIFBS_HasVInstructions_HasVInstructionsF64,
  GIFBS_HasVInstructions_HasVInstructionsI64,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64,
  GIFBS_HasVendorXTHeadBb_IsRV64,
  GIFBS_IsRV64_NotHasStdExtZba,
  GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxOrZhinxmin_IsRV32,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxOrZhinxmin_IsRV64,
  GIFBS_HasStdExtZfhmin_IsRV32_NoStdExtZfh,
  GIFBS_HasStdExtZfhmin_IsRV64_NoStdExtZfh,
  GIFBS_HasStdExtZhinxmin_IsRV32_NoStdExtZhinx,
  GIFBS_HasStdExtZhinxmin_IsRV64_NoStdExtZhinx,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxOrZhinxminBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsF16Bit, },
  {Feature_HasVInstructionsF64Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, },
  {Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXTHeadBaBit, },
  {Feature_HasVendorXTHeadBbBit, },
  {Feature_HasVendorXTHeadBsBit, },
  {Feature_HasVendorXTHeadCondMovBit, },
  {Feature_HasVendorXTHeadMacBit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxOrZhinxminBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxOrZhinxminBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfhminBit, Feature_IsRV32Bit, Feature_NoStdExtZfhBit, },
  {Feature_HasStdExtZfhminBit, Feature_IsRV64Bit, Feature_NoStdExtZfhBit, },
  {Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_NoStdExtZhinxBit, },
  {Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_NoStdExtZhinxBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_BCLRMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_rnum_0_7,
  GICXXPred_I64_Predicate_rnum_1_10,
  GICXXPred_I64_Predicate_rnum_2_14,
  GICXXPred_I64_Predicate_shfl_uimm,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm9_lsb0,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12_lsb0,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_timm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_BCLRMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(~Imm);

    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(Imm);

    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                 (isUInt<5>(Imm) ||
                                  (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_rnum_0_7: {
    return (0 <= Imm && Imm <= 7);
  }
  case GICXXPred_I64_Predicate_rnum_1_10: {
    return (1 <= Imm && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_rnum_2_14: {
    return (2 <= Imm && Imm <= 14);
  }
  case GICXXPred_I64_Predicate_shfl_uimm: {
    
  if (Subtarget->is64Bit())
    return isUInt<5>(Imm);
  return isUInt<4>(Imm);

    llvm_unreachable("shfl_uimm should have returned");
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
  return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_timm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
  return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));

  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
  return isShiftedUInt<2, 3>(Imm);

  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
  return isShiftedUInt<2, 4>(Imm);

  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
  return isUInt<6>(Imm) && Imm > 32;

  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm);
  return isUInt<5>(Imm);

    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm) && (Imm != 0);
  return isUInt<5>(Imm) && (Imm != 0);

    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ExecInfo, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
const int64_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 231, /*)*//*default:*//*Label 90*/ 241161,
    /*TargetOpcode::G_ADD*//*Label 0*/ 190,
    /*TargetOpcode::G_SUB*//*Label 1*/ 3536,
    /*TargetOpcode::G_MUL*//*Label 2*/ 6430,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 9331,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 12117,
    /*TargetOpcode::G_SREM*//*Label 5*/ 14903,
    /*TargetOpcode::G_UREM*//*Label 6*/ 17689, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 20475,
    /*TargetOpcode::G_OR*//*Label 8*/ 24755,
    /*TargetOpcode::G_XOR*//*Label 9*/ 28417, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 10*/ 32185, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 11*/ 32429,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 12*/ 32625,
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 13*/ 32821, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 14*/ 33768,
    /*TargetOpcode::G_LOAD*//*Label 15*/ 33800, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 16*/ 35621, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 17*/ 37020,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 18*/ 37365,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 19*/ 37884,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 20*/ 38403,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 21*/ 38754,
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 22*/ 39273,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ 39574,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ 40093,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ 40612,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ 41131,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ 41650,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ 42169, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 29*/ 42688, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 30*/ 42871,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 31*/ 44173,
    /*TargetOpcode::G_ANYEXT*//*Label 32*/ 45049, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 33*/ 48234, 0,
    /*TargetOpcode::G_ZEXT*//*Label 34*/ 51419,
    /*TargetOpcode::G_SHL*//*Label 35*/ 54604,
    /*TargetOpcode::G_LSHR*//*Label 36*/ 57489,
    /*TargetOpcode::G_ASHR*//*Label 37*/ 60374, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 38*/ 63236,
    /*TargetOpcode::G_ROTL*//*Label 39*/ 66138,
    /*TargetOpcode::G_ICMP*//*Label 40*/ 68857,
    /*TargetOpcode::G_FCMP*//*Label 41*/ 92834,
    /*TargetOpcode::G_SELECT*//*Label 42*/ 101147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 43*/ 101420,
    /*TargetOpcode::G_SMULH*//*Label 44*/ 104206,
    /*TargetOpcode::G_UADDSAT*//*Label 45*/ 106992,
    /*TargetOpcode::G_SADDSAT*//*Label 46*/ 109711,
    /*TargetOpcode::G_USUBSAT*//*Label 47*/ 112430,
    /*TargetOpcode::G_SSUBSAT*//*Label 48*/ 115149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 49*/ 117868,
    /*TargetOpcode::G_FSUB*//*Label 50*/ 120368,
    /*TargetOpcode::G_FMUL*//*Label 51*/ 122868,
    /*TargetOpcode::G_FMA*//*Label 52*/ 125368, 0,
    /*TargetOpcode::G_FDIV*//*Label 53*/ 143532, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 54*/ 146032,
    /*TargetOpcode::G_FPEXT*//*Label 55*/ 148027,
    /*TargetOpcode::G_FPTRUNC*//*Label 56*/ 148221,
    /*TargetOpcode::G_FPTOSI*//*Label 57*/ 149741,
    /*TargetOpcode::G_FPTOUI*//*Label 58*/ 155119,
    /*TargetOpcode::G_SITOFP*//*Label 59*/ 160497,
    /*TargetOpcode::G_UITOFP*//*Label 60*/ 166048,
    /*TargetOpcode::G_FABS*//*Label 61*/ 171599,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 62*/ 173594, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 63*/ 178988,
    /*TargetOpcode::G_FMAXNUM*//*Label 64*/ 181052, 0, 0,
    /*TargetOpcode::G_FMINIMUM*//*Label 65*/ 183116,
    /*TargetOpcode::G_FMAXIMUM*//*Label 66*/ 183222, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 67*/ 183328,
    /*TargetOpcode::G_SMAX*//*Label 68*/ 186114,
    /*TargetOpcode::G_UMIN*//*Label 69*/ 188900,
    /*TargetOpcode::G_UMAX*//*Label 70*/ 191686, 0,
    /*TargetOpcode::G_LROUND*//*Label 71*/ 194472,
    /*TargetOpcode::G_LLROUND*//*Label 72*/ 195419,
    /*TargetOpcode::G_BR*//*Label 73*/ 195708, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 74*/ 195721, 0,
    /*TargetOpcode::G_CTLZ*//*Label 75*/ 198139, 0,
    /*TargetOpcode::G_CTPOP*//*Label 76*/ 200683,
    /*TargetOpcode::G_BSWAP*//*Label 77*/ 203101,
    /*TargetOpcode::G_BITREVERSE*//*Label 78*/ 205558,
    /*TargetOpcode::G_FCEIL*//*Label 79*/ 207925, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 80*/ 208121,
    /*TargetOpcode::G_FFLOOR*//*Label 81*/ 210265,
    /*TargetOpcode::G_FRINT*//*Label 82*/ 210461,
    /*TargetOpcode::G_FNEARBYINT*//*Label 83*/ 210657, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 84*/ 210853,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 85*/ 213353,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 86*/ 215853,
    /*TargetOpcode::G_STRICT_FDIV*//*Label 87*/ 218353, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 88*/ 220853,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 89*/ 239017,
    // Label 0: @190
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 115*/ 3535,
    /*GILLT_s32*//*Label 91*/ 227,
    /*GILLT_s64*//*Label 92*/ 539, 0,
    /*GILLT_nxv1s8*//*Label 93*/ 851,
    /*GILLT_nxv1s16*//*Label 94*/ 973,
    /*GILLT_nxv1s32*//*Label 95*/ 1095,
    /*GILLT_nxv1s64*//*Label 96*/ 1217, 0,
    /*GILLT_nxv2s8*//*Label 97*/ 1339,
    /*GILLT_nxv2s16*//*Label 98*/ 1461,
    /*GILLT_nxv2s32*//*Label 99*/ 1583,
    /*GILLT_nxv2s64*//*Label 100*/ 1705, 0,
    /*GILLT_nxv4s8*//*Label 101*/ 1827,
    /*GILLT_nxv4s16*//*Label 102*/ 1949,
    /*GILLT_nxv4s32*//*Label 103*/ 2071,
    /*GILLT_nxv4s64*//*Label 104*/ 2193, 0,
    /*GILLT_nxv8s8*//*Label 105*/ 2315,
    /*GILLT_nxv8s16*//*Label 106*/ 2437,
    /*GILLT_nxv8s32*//*Label 107*/ 2559,
    /*GILLT_nxv8s64*//*Label 108*/ 2681, 0,
    /*GILLT_nxv16s8*//*Label 109*/ 2803,
    /*GILLT_nxv16s16*//*Label 110*/ 2925,
    /*GILLT_nxv16s32*//*Label 111*/ 3047, 0,
    /*GILLT_nxv32s8*//*Label 112*/ 3169,
    /*GILLT_nxv32s16*//*Label 113*/ 3291, 0,
    /*GILLT_nxv64s8*//*Label 114*/ 3413,
    // Label 91: @227
    GIM_Try, /*On fail goto*//*Label 116*/ 538,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 117*/ 305, // Rule ID 63975 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBa,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimm2,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i32] }:$rs1)  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_ADDSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63975,
        GIR_Done,
      // Label 117: @305
      GIM_Try, /*On fail goto*//*Label 118*/ 369, // Rule ID 55590 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBa,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimm2,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_ADDSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55590,
        GIR_Done,
      // Label 118: @369
      GIM_Try, /*On fail goto*//*Label 119*/ 406, // Rule ID 69 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 69,
        GIR_Done,
      // Label 119: @406
      GIM_Try, /*On fail goto*//*Label 120*/ 463, // Rule ID 64001 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64001,
        GIR_Done,
      // Label 120: @463
      GIM_Try, /*On fail goto*//*Label 121*/ 520, // Rule ID 55694 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55694,
        GIR_Done,
      // Label 121: @520
      GIM_Try, /*On fail goto*//*Label 122*/ 537, // Rule ID 67 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 67,
        GIR_Done,
      // Label 122: @537
      GIM_Reject,
    // Label 116: @538
    GIM_Reject,
    // Label 92: @539
    GIM_Try, /*On fail goto*//*Label 123*/ 850,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 124*/ 617, // Rule ID 63974 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBa,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimm2,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i64] }:$rs1)  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_ADDSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63974,
        GIR_Done,
      // Label 124: @617
      GIM_Try, /*On fail goto*//*Label 125*/ 681, // Rule ID 55589 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBa,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimm2,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_ADDSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55589,
        GIR_Done,
      // Label 125: @681
      GIM_Try, /*On fail goto*//*Label 126*/ 718, // Rule ID 68 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 68,
        GIR_Done,
      // Label 126: @718
      GIM_Try, /*On fail goto*//*Label 127*/ 775, // Rule ID 64000 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64000,
        GIR_Done,
      // Label 127: @775
      GIM_Try, /*On fail goto*//*Label 128*/ 832, // Rule ID 55693 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55693,
        GIR_Done,
      // Label 128: @832
      GIM_Try, /*On fail goto*//*Label 129*/ 849, // Rule ID 66 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 66,
        GIR_Done,
      // Label 129: @849
      GIM_Reject,
    // Label 123: @850
    GIM_Reject,
    // Label 93: @851
    GIM_Try, /*On fail goto*//*Label 130*/ 972,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 131*/ 922, // Rule ID 44311 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44311,
        GIR_Done,
      // Label 131: @922
      GIM_Try, /*On fail goto*//*Label 132*/ 971, // Rule ID 44312 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44312,
        GIR_Done,
      // Label 132: @971
      GIM_Reject,
    // Label 130: @972
    GIM_Reject,
    // Label 94: @973
    GIM_Try, /*On fail goto*//*Label 133*/ 1094,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 134*/ 1044, // Rule ID 44613 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44613,
        GIR_Done,
      // Label 134: @1044
      GIM_Try, /*On fail goto*//*Label 135*/ 1093, // Rule ID 44614 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44614,
        GIR_Done,
      // Label 135: @1093
      GIM_Reject,
    // Label 133: @1094
    GIM_Reject,
    // Label 95: @1095
    GIM_Try, /*On fail goto*//*Label 136*/ 1216,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 137*/ 1166, // Rule ID 44621 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44621,
        GIR_Done,
      // Label 137: @1166
      GIM_Try, /*On fail goto*//*Label 138*/ 1215, // Rule ID 44622 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44622,
        GIR_Done,
      // Label 138: @1215
      GIM_Reject,
    // Label 136: @1216
    GIM_Reject,
    // Label 96: @1217
    GIM_Try, /*On fail goto*//*Label 139*/ 1338,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 140*/ 1288, // Rule ID 44637 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44637,
        GIR_Done,
      // Label 140: @1288
      GIM_Try, /*On fail goto*//*Label 141*/ 1337, // Rule ID 44638 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44638,
        GIR_Done,
      // Label 141: @1337
      GIM_Reject,
    // Label 139: @1338
    GIM_Reject,
    // Label 97: @1339
    GIM_Try, /*On fail goto*//*Label 142*/ 1460,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 143*/ 1410, // Rule ID 44605 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44605,
        GIR_Done,
      // Label 143: @1410
      GIM_Try, /*On fail goto*//*Label 144*/ 1459, // Rule ID 44606 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44606,
        GIR_Done,
      // Label 144: @1459
      GIM_Reject,
    // Label 142: @1460
    GIM_Reject,
    // Label 98: @1461
    GIM_Try, /*On fail goto*//*Label 145*/ 1582,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 146*/ 1532, // Rule ID 44617 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44617,
        GIR_Done,
      // Label 146: @1532
      GIM_Try, /*On fail goto*//*Label 147*/ 1581, // Rule ID 44618 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44618,
        GIR_Done,
      // Label 147: @1581
      GIM_Reject,
    // Label 145: @1582
    GIM_Reject,
    // Label 99: @1583
    GIM_Try, /*On fail goto*//*Label 148*/ 1704,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 149*/ 1654, // Rule ID 44633 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44633,
        GIR_Done,
      // Label 149: @1654
      GIM_Try, /*On fail goto*//*Label 150*/ 1703, // Rule ID 44634 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44634,
        GIR_Done,
      // Label 150: @1703
      GIM_Reject,
    // Label 148: @1704
    GIM_Reject,
    // Label 100: @1705
    GIM_Try, /*On fail goto*//*Label 151*/ 1826,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 152*/ 1776, // Rule ID 44677 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44677,
        GIR_Done,
      // Label 152: @1776
      GIM_Try, /*On fail goto*//*Label 153*/ 1825, // Rule ID 44678 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44678,
        GIR_Done,
      // Label 153: @1825
      GIM_Reject,
    // Label 151: @1826
    GIM_Reject,
    // Label 101: @1827
    GIM_Try, /*On fail goto*//*Label 154*/ 1948,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 155*/ 1898, // Rule ID 44609 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44609,
        GIR_Done,
      // Label 155: @1898
      GIM_Try, /*On fail goto*//*Label 156*/ 1947, // Rule ID 44610 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44610,
        GIR_Done,
      // Label 156: @1947
      GIM_Reject,
    // Label 154: @1948
    GIM_Reject,
    // Label 102: @1949
    GIM_Try, /*On fail goto*//*Label 157*/ 2070,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 158*/ 2020, // Rule ID 44629 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44629,
        GIR_Done,
      // Label 158: @2020
      GIM_Try, /*On fail goto*//*Label 159*/ 2069, // Rule ID 44630 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44630,
        GIR_Done,
      // Label 159: @2069
      GIM_Reject,
    // Label 157: @2070
    GIM_Reject,
    // Label 103: @2071
    GIM_Try, /*On fail goto*//*Label 160*/ 2192,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 161*/ 2142, // Rule ID 44665 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44665,
        GIR_Done,
      // Label 161: @2142
      GIM_Try, /*On fail goto*//*Label 162*/ 2191, // Rule ID 44666 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44666,
        GIR_Done,
      // Label 162: @2191
      GIM_Reject,
    // Label 160: @2192
    GIM_Reject,
    // Label 104: @2193
    GIM_Try, /*On fail goto*//*Label 163*/ 2314,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 164*/ 2264, // Rule ID 44681 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44681,
        GIR_Done,
      // Label 164: @2264
      GIM_Try, /*On fail goto*//*Label 165*/ 2313, // Rule ID 44682 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44682,
        GIR_Done,
      // Label 165: @2313
      GIM_Reject,
    // Label 163: @2314
    GIM_Reject,
    // Label 105: @2315
    GIM_Try, /*On fail goto*//*Label 166*/ 2436,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 167*/ 2386, // Rule ID 44625 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44625,
        GIR_Done,
      // Label 167: @2386
      GIM_Try, /*On fail goto*//*Label 168*/ 2435, // Rule ID 44626 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44626,
        GIR_Done,
      // Label 168: @2435
      GIM_Reject,
    // Label 166: @2436
    GIM_Reject,
    // Label 106: @2437
    GIM_Try, /*On fail goto*//*Label 169*/ 2558,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 170*/ 2508, // Rule ID 44653 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44653,
        GIR_Done,
      // Label 170: @2508
      GIM_Try, /*On fail goto*//*Label 171*/ 2557, // Rule ID 44654 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44654,
        GIR_Done,
      // Label 171: @2557
      GIM_Reject,
    // Label 169: @2558
    GIM_Reject,
    // Label 107: @2559
    GIM_Try, /*On fail goto*//*Label 172*/ 2680,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 173*/ 2630, // Rule ID 44669 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44669,
        GIR_Done,
      // Label 173: @2630
      GIM_Try, /*On fail goto*//*Label 174*/ 2679, // Rule ID 44670 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44670,
        GIR_Done,
      // Label 174: @2679
      GIM_Reject,
    // Label 172: @2680
    GIM_Reject,
    // Label 108: @2681
    GIM_Try, /*On fail goto*//*Label 175*/ 2802,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 176*/ 2752, // Rule ID 44685 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44685,
        GIR_Done,
      // Label 176: @2752
      GIM_Try, /*On fail goto*//*Label 177*/ 2801, // Rule ID 44686 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44686,
        GIR_Done,
      // Label 177: @2801
      GIM_Reject,
    // Label 175: @2802
    GIM_Reject,
    // Label 109: @2803
    GIM_Try, /*On fail goto*//*Label 178*/ 2924,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 179*/ 2874, // Rule ID 44641 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44641,
        GIR_Done,
      // Label 179: @2874
      GIM_Try, /*On fail goto*//*Label 180*/ 2923, // Rule ID 44642 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44642,
        GIR_Done,
      // Label 180: @2923
      GIM_Reject,
    // Label 178: @2924
    GIM_Reject,
    // Label 110: @2925
    GIM_Try, /*On fail goto*//*Label 181*/ 3046,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 182*/ 2996, // Rule ID 44657 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44657,
        GIR_Done,
      // Label 182: @2996
      GIM_Try, /*On fail goto*//*Label 183*/ 3045, // Rule ID 44658 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44658,
        GIR_Done,
      // Label 183: @3045
      GIM_Reject,
    // Label 181: @3046
    GIM_Reject,
    // Label 111: @3047
    GIM_Try, /*On fail goto*//*Label 184*/ 3168,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 185*/ 3118, // Rule ID 44673 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44673,
        GIR_Done,
      // Label 185: @3118
      GIM_Try, /*On fail goto*//*Label 186*/ 3167, // Rule ID 44674 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44674,
        GIR_Done,
      // Label 186: @3167
      GIM_Reject,
    // Label 184: @3168
    GIM_Reject,
    // Label 112: @3169
    GIM_Try, /*On fail goto*//*Label 187*/ 3290,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 188*/ 3240, // Rule ID 44645 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44645,
        GIR_Done,
      // Label 188: @3240
      GIM_Try, /*On fail goto*//*Label 189*/ 3289, // Rule ID 44646 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44646,
        GIR_Done,
      // Label 189: @3289
      GIM_Reject,
    // Label 187: @3290
    GIM_Reject,
    // Label 113: @3291
    GIM_Try, /*On fail goto*//*Label 190*/ 3412,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 191*/ 3362, // Rule ID 44661 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44661,
        GIR_Done,
      // Label 191: @3362
      GIM_Try, /*On fail goto*//*Label 192*/ 3411, // Rule ID 44662 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44662,
        GIR_Done,
      // Label 192: @3411
      GIM_Reject,
    // Label 190: @3412
    GIM_Reject,
    // Label 114: @3413
    GIM_Try, /*On fail goto*//*Label 193*/ 3534,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 194*/ 3484, // Rule ID 44649 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44649,
        GIR_Done,
      // Label 194: @3484
      GIM_Try, /*On fail goto*//*Label 195*/ 3533, // Rule ID 44650 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44650,
        GIR_Done,
      // Label 195: @3533
      GIM_Reject,
    // Label 193: @3534
    GIM_Reject,
    // Label 115: @3535
    GIM_Reject,
    // Label 1: @3536
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 220*/ 6429,
    /*GILLT_s32*//*Label 196*/ 3573,
    /*GILLT_s64*//*Label 197*/ 3659, 0,
    /*GILLT_nxv1s8*//*Label 198*/ 3745,
    /*GILLT_nxv1s16*//*Label 199*/ 3867,
    /*GILLT_nxv1s32*//*Label 200*/ 3989,
    /*GILLT_nxv1s64*//*Label 201*/ 4111, 0,
    /*GILLT_nxv2s8*//*Label 202*/ 4233,
    /*GILLT_nxv2s16*//*Label 203*/ 4355,
    /*GILLT_nxv2s32*//*Label 204*/ 4477,
    /*GILLT_nxv2s64*//*Label 205*/ 4599, 0,
    /*GILLT_nxv4s8*//*Label 206*/ 4721,
    /*GILLT_nxv4s16*//*Label 207*/ 4843,
    /*GILLT_nxv4s32*//*Label 208*/ 4965,
    /*GILLT_nxv4s64*//*Label 209*/ 5087, 0,
    /*GILLT_nxv8s8*//*Label 210*/ 5209,
    /*GILLT_nxv8s16*//*Label 211*/ 5331,
    /*GILLT_nxv8s32*//*Label 212*/ 5453,
    /*GILLT_nxv8s64*//*Label 213*/ 5575, 0,
    /*GILLT_nxv16s8*//*Label 214*/ 5697,
    /*GILLT_nxv16s16*//*Label 215*/ 5819,
    /*GILLT_nxv16s32*//*Label 216*/ 5941, 0,
    /*GILLT_nxv32s8*//*Label 217*/ 6063,
    /*GILLT_nxv32s16*//*Label 218*/ 6185, 0,
    /*GILLT_nxv64s8*//*Label 219*/ 6307,
    // Label 196: @3573
    GIM_Try, /*On fail goto*//*Label 221*/ 3658,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 222*/ 3644, // Rule ID 55696 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULS:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55696,
        GIR_Done,
      // Label 222: @3644
      GIM_Try, /*On fail goto*//*Label 223*/ 3657, // Rule ID 71 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 71,
        GIR_Done,
      // Label 223: @3657
      GIM_Reject,
    // Label 221: @3658
    GIM_Reject,
    // Label 197: @3659
    GIM_Try, /*On fail goto*//*Label 224*/ 3744,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 225*/ 3730, // Rule ID 55695 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadMac,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULS:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_MULS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_wb
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55695,
        GIR_Done,
      // Label 225: @3730
      GIM_Try, /*On fail goto*//*Label 226*/ 3743, // Rule ID 70 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 70,
        GIR_Done,
      // Label 226: @3743
      GIM_Reject,
    // Label 224: @3744
    GIM_Reject,
    // Label 198: @3745
    GIM_Try, /*On fail goto*//*Label 227*/ 3866,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 228*/ 3816, // Rule ID 44731 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44731,
        GIR_Done,
      // Label 228: @3816
      GIM_Try, /*On fail goto*//*Label 229*/ 3865, // Rule ID 44732 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44732,
        GIR_Done,
      // Label 229: @3865
      GIM_Reject,
    // Label 227: @3866
    GIM_Reject,
    // Label 199: @3867
    GIM_Try, /*On fail goto*//*Label 230*/ 3988,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 231*/ 3938, // Rule ID 44743 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44743,
        GIR_Done,
      // Label 231: @3938
      GIM_Try, /*On fail goto*//*Label 232*/ 3987, // Rule ID 44744 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44744,
        GIR_Done,
      // Label 232: @3987
      GIM_Reject,
    // Label 230: @3988
    GIM_Reject,
    // Label 200: @3989
    GIM_Try, /*On fail goto*//*Label 233*/ 4110,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 234*/ 4060, // Rule ID 44751 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44751,
        GIR_Done,
      // Label 234: @4060
      GIM_Try, /*On fail goto*//*Label 235*/ 4109, // Rule ID 44752 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44752,
        GIR_Done,
      // Label 235: @4109
      GIM_Reject,
    // Label 233: @4110
    GIM_Reject,
    // Label 201: @4111
    GIM_Try, /*On fail goto*//*Label 236*/ 4232,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 237*/ 4182, // Rule ID 44767 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44767,
        GIR_Done,
      // Label 237: @4182
      GIM_Try, /*On fail goto*//*Label 238*/ 4231, // Rule ID 44768 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44768,
        GIR_Done,
      // Label 238: @4231
      GIM_Reject,
    // Label 236: @4232
    GIM_Reject,
    // Label 202: @4233
    GIM_Try, /*On fail goto*//*Label 239*/ 4354,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 240*/ 4304, // Rule ID 44735 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44735,
        GIR_Done,
      // Label 240: @4304
      GIM_Try, /*On fail goto*//*Label 241*/ 4353, // Rule ID 44736 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44736,
        GIR_Done,
      // Label 241: @4353
      GIM_Reject,
    // Label 239: @4354
    GIM_Reject,
    // Label 203: @4355
    GIM_Try, /*On fail goto*//*Label 242*/ 4476,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 243*/ 4426, // Rule ID 44747 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44747,
        GIR_Done,
      // Label 243: @4426
      GIM_Try, /*On fail goto*//*Label 244*/ 4475, // Rule ID 44748 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44748,
        GIR_Done,
      // Label 244: @4475
      GIM_Reject,
    // Label 242: @4476
    GIM_Reject,
    // Label 204: @4477
    GIM_Try, /*On fail goto*//*Label 245*/ 4598,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 246*/ 4548, // Rule ID 44763 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44763,
        GIR_Done,
      // Label 246: @4548
      GIM_Try, /*On fail goto*//*Label 247*/ 4597, // Rule ID 44764 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44764,
        GIR_Done,
      // Label 247: @4597
      GIM_Reject,
    // Label 245: @4598
    GIM_Reject,
    // Label 205: @4599
    GIM_Try, /*On fail goto*//*Label 248*/ 4720,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 249*/ 4670, // Rule ID 44807 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44807,
        GIR_Done,
      // Label 249: @4670
      GIM_Try, /*On fail goto*//*Label 250*/ 4719, // Rule ID 44808 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44808,
        GIR_Done,
      // Label 250: @4719
      GIM_Reject,
    // Label 248: @4720
    GIM_Reject,
    // Label 206: @4721
    GIM_Try, /*On fail goto*//*Label 251*/ 4842,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 252*/ 4792, // Rule ID 44739 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44739,
        GIR_Done,
      // Label 252: @4792
      GIM_Try, /*On fail goto*//*Label 253*/ 4841, // Rule ID 44740 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44740,
        GIR_Done,
      // Label 253: @4841
      GIM_Reject,
    // Label 251: @4842
    GIM_Reject,
    // Label 207: @4843
    GIM_Try, /*On fail goto*//*Label 254*/ 4964,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 255*/ 4914, // Rule ID 44759 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44759,
        GIR_Done,
      // Label 255: @4914
      GIM_Try, /*On fail goto*//*Label 256*/ 4963, // Rule ID 44760 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44760,
        GIR_Done,
      // Label 256: @4963
      GIM_Reject,
    // Label 254: @4964
    GIM_Reject,
    // Label 208: @4965
    GIM_Try, /*On fail goto*//*Label 257*/ 5086,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 258*/ 5036, // Rule ID 44795 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44795,
        GIR_Done,
      // Label 258: @5036
      GIM_Try, /*On fail goto*//*Label 259*/ 5085, // Rule ID 44796 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44796,
        GIR_Done,
      // Label 259: @5085
      GIM_Reject,
    // Label 257: @5086
    GIM_Reject,
    // Label 209: @5087
    GIM_Try, /*On fail goto*//*Label 260*/ 5208,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 261*/ 5158, // Rule ID 44811 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44811,
        GIR_Done,
      // Label 261: @5158
      GIM_Try, /*On fail goto*//*Label 262*/ 5207, // Rule ID 44812 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44812,
        GIR_Done,
      // Label 262: @5207
      GIM_Reject,
    // Label 260: @5208
    GIM_Reject,
    // Label 210: @5209
    GIM_Try, /*On fail goto*//*Label 263*/ 5330,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 264*/ 5280, // Rule ID 44755 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44755,
        GIR_Done,
      // Label 264: @5280
      GIM_Try, /*On fail goto*//*Label 265*/ 5329, // Rule ID 44756 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44756,
        GIR_Done,
      // Label 265: @5329
      GIM_Reject,
    // Label 263: @5330
    GIM_Reject,
    // Label 211: @5331
    GIM_Try, /*On fail goto*//*Label 266*/ 5452,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 267*/ 5402, // Rule ID 44783 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44783,
        GIR_Done,
      // Label 267: @5402
      GIM_Try, /*On fail goto*//*Label 268*/ 5451, // Rule ID 44784 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44784,
        GIR_Done,
      // Label 268: @5451
      GIM_Reject,
    // Label 266: @5452
    GIM_Reject,
    // Label 212: @5453
    GIM_Try, /*On fail goto*//*Label 269*/ 5574,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 270*/ 5524, // Rule ID 44799 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44799,
        GIR_Done,
      // Label 270: @5524
      GIM_Try, /*On fail goto*//*Label 271*/ 5573, // Rule ID 44800 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44800,
        GIR_Done,
      // Label 271: @5573
      GIM_Reject,
    // Label 269: @5574
    GIM_Reject,
    // Label 213: @5575
    GIM_Try, /*On fail goto*//*Label 272*/ 5696,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 273*/ 5646, // Rule ID 44815 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44815,
        GIR_Done,
      // Label 273: @5646
      GIM_Try, /*On fail goto*//*Label 274*/ 5695, // Rule ID 44816 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44816,
        GIR_Done,
      // Label 274: @5695
      GIM_Reject,
    // Label 272: @5696
    GIM_Reject,
    // Label 214: @5697
    GIM_Try, /*On fail goto*//*Label 275*/ 5818,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 276*/ 5768, // Rule ID 44771 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44771,
        GIR_Done,
      // Label 276: @5768
      GIM_Try, /*On fail goto*//*Label 277*/ 5817, // Rule ID 44772 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44772,
        GIR_Done,
      // Label 277: @5817
      GIM_Reject,
    // Label 275: @5818
    GIM_Reject,
    // Label 215: @5819
    GIM_Try, /*On fail goto*//*Label 278*/ 5940,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 279*/ 5890, // Rule ID 44787 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44787,
        GIR_Done,
      // Label 279: @5890
      GIM_Try, /*On fail goto*//*Label 280*/ 5939, // Rule ID 44788 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44788,
        GIR_Done,
      // Label 280: @5939
      GIM_Reject,
    // Label 278: @5940
    GIM_Reject,
    // Label 216: @5941
    GIM_Try, /*On fail goto*//*Label 281*/ 6062,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 282*/ 6012, // Rule ID 44803 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44803,
        GIR_Done,
      // Label 282: @6012
      GIM_Try, /*On fail goto*//*Label 283*/ 6061, // Rule ID 44804 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44804,
        GIR_Done,
      // Label 283: @6061
      GIM_Reject,
    // Label 281: @6062
    GIM_Reject,
    // Label 217: @6063
    GIM_Try, /*On fail goto*//*Label 284*/ 6184,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 285*/ 6134, // Rule ID 44775 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44775,
        GIR_Done,
      // Label 285: @6134
      GIM_Try, /*On fail goto*//*Label 286*/ 6183, // Rule ID 44776 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44776,
        GIR_Done,
      // Label 286: @6183
      GIM_Reject,
    // Label 284: @6184
    GIM_Reject,
    // Label 218: @6185
    GIM_Try, /*On fail goto*//*Label 287*/ 6306,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 288*/ 6256, // Rule ID 44791 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44791,
        GIR_Done,
      // Label 288: @6256
      GIM_Try, /*On fail goto*//*Label 289*/ 6305, // Rule ID 44792 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44792,
        GIR_Done,
      // Label 289: @6305
      GIM_Reject,
    // Label 287: @6306
    GIM_Reject,
    // Label 219: @6307
    GIM_Try, /*On fail goto*//*Label 290*/ 6428,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 291*/ 6378, // Rule ID 44779 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44779,
        GIR_Done,
      // Label 291: @6378
      GIM_Try, /*On fail goto*//*Label 292*/ 6427, // Rule ID 44780 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44780,
        GIR_Done,
      // Label 292: @6427
      GIM_Reject,
    // Label 290: @6428
    GIM_Reject,
    // Label 220: @6429
    GIM_Reject,
    // Label 2: @6430
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 317*/ 9330,
    /*GILLT_s32*//*Label 293*/ 6467,
    /*GILLT_s64*//*Label 294*/ 6499, 0,
    /*GILLT_nxv1s8*//*Label 295*/ 6646,
    /*GILLT_nxv1s16*//*Label 296*/ 6768,
    /*GILLT_nxv1s32*//*Label 297*/ 6890,
    /*GILLT_nxv1s64*//*Label 298*/ 7012, 0,
    /*GILLT_nxv2s8*//*Label 299*/ 7134,
    /*GILLT_nxv2s16*//*Label 300*/ 7256,
    /*GILLT_nxv2s32*//*Label 301*/ 7378,
    /*GILLT_nxv2s64*//*Label 302*/ 7500, 0,
    /*GILLT_nxv4s8*//*Label 303*/ 7622,
    /*GILLT_nxv4s16*//*Label 304*/ 7744,
    /*GILLT_nxv4s32*//*Label 305*/ 7866,
    /*GILLT_nxv4s64*//*Label 306*/ 7988, 0,
    /*GILLT_nxv8s8*//*Label 307*/ 8110,
    /*GILLT_nxv8s16*//*Label 308*/ 8232,
    /*GILLT_nxv8s32*//*Label 309*/ 8354,
    /*GILLT_nxv8s64*//*Label 310*/ 8476, 0,
    /*GILLT_nxv16s8*//*Label 311*/ 8598,
    /*GILLT_nxv16s16*//*Label 312*/ 8720,
    /*GILLT_nxv16s32*//*Label 313*/ 8842, 0,
    /*GILLT_nxv32s8*//*Label 314*/ 8964,
    /*GILLT_nxv32s16*//*Label 315*/ 9086, 0,
    /*GILLT_nxv64s8*//*Label 316*/ 9208,
    // Label 293: @6467
    GIM_Try, /*On fail goto*//*Label 318*/ 6498, // Rule ID 266 //
      GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 266,
      GIR_Done,
    // Label 318: @6498
    GIM_Reject,
    // Label 294: @6499
    GIM_Try, /*On fail goto*//*Label 319*/ 6645,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 320*/ 6625, // Rule ID 288 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::MULHU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 288,
        GIR_Done,
      // Label 320: @6625
      GIM_Try, /*On fail goto*//*Label 321*/ 6644, // Rule ID 265 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 265,
        GIR_Done,
      // Label 321: @6644
      GIM_Reject,
    // Label 319: @6645
    GIM_Reject,
    // Label 295: @6646
    GIM_Try, /*On fail goto*//*Label 322*/ 6767,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 323*/ 6717, // Rule ID 48987 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48987,
        GIR_Done,
      // Label 323: @6717
      GIM_Try, /*On fail goto*//*Label 324*/ 6766, // Rule ID 48988 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48988,
        GIR_Done,
      // Label 324: @6766
      GIM_Reject,
    // Label 322: @6767
    GIM_Reject,
    // Label 296: @6768
    GIM_Try, /*On fail goto*//*Label 325*/ 6889,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 326*/ 6839, // Rule ID 48999 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48999,
        GIR_Done,
      // Label 326: @6839
      GIM_Try, /*On fail goto*//*Label 327*/ 6888, // Rule ID 49000 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49000,
        GIR_Done,
      // Label 327: @6888
      GIM_Reject,
    // Label 325: @6889
    GIM_Reject,
    // Label 297: @6890
    GIM_Try, /*On fail goto*//*Label 328*/ 7011,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 329*/ 6961, // Rule ID 49007 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49007,
        GIR_Done,
      // Label 329: @6961
      GIM_Try, /*On fail goto*//*Label 330*/ 7010, // Rule ID 49008 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49008,
        GIR_Done,
      // Label 330: @7010
      GIM_Reject,
    // Label 328: @7011
    GIM_Reject,
    // Label 298: @7012
    GIM_Try, /*On fail goto*//*Label 331*/ 7133,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 332*/ 7083, // Rule ID 49023 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49023,
        GIR_Done,
      // Label 332: @7083
      GIM_Try, /*On fail goto*//*Label 333*/ 7132, // Rule ID 49024 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49024,
        GIR_Done,
      // Label 333: @7132
      GIM_Reject,
    // Label 331: @7133
    GIM_Reject,
    // Label 299: @7134
    GIM_Try, /*On fail goto*//*Label 334*/ 7255,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 335*/ 7205, // Rule ID 48991 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48991,
        GIR_Done,
      // Label 335: @7205
      GIM_Try, /*On fail goto*//*Label 336*/ 7254, // Rule ID 48992 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48992,
        GIR_Done,
      // Label 336: @7254
      GIM_Reject,
    // Label 334: @7255
    GIM_Reject,
    // Label 300: @7256
    GIM_Try, /*On fail goto*//*Label 337*/ 7377,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 338*/ 7327, // Rule ID 49003 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49003,
        GIR_Done,
      // Label 338: @7327
      GIM_Try, /*On fail goto*//*Label 339*/ 7376, // Rule ID 49004 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49004,
        GIR_Done,
      // Label 339: @7376
      GIM_Reject,
    // Label 337: @7377
    GIM_Reject,
    // Label 301: @7378
    GIM_Try, /*On fail goto*//*Label 340*/ 7499,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 341*/ 7449, // Rule ID 49019 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49019,
        GIR_Done,
      // Label 341: @7449
      GIM_Try, /*On fail goto*//*Label 342*/ 7498, // Rule ID 49020 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49020,
        GIR_Done,
      // Label 342: @7498
      GIM_Reject,
    // Label 340: @7499
    GIM_Reject,
    // Label 302: @7500
    GIM_Try, /*On fail goto*//*Label 343*/ 7621,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 344*/ 7571, // Rule ID 49063 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49063,
        GIR_Done,
      // Label 344: @7571
      GIM_Try, /*On fail goto*//*Label 345*/ 7620, // Rule ID 49064 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49064,
        GIR_Done,
      // Label 345: @7620
      GIM_Reject,
    // Label 343: @7621
    GIM_Reject,
    // Label 303: @7622
    GIM_Try, /*On fail goto*//*Label 346*/ 7743,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 347*/ 7693, // Rule ID 48995 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48995,
        GIR_Done,
      // Label 347: @7693
      GIM_Try, /*On fail goto*//*Label 348*/ 7742, // Rule ID 48996 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48996,
        GIR_Done,
      // Label 348: @7742
      GIM_Reject,
    // Label 346: @7743
    GIM_Reject,
    // Label 304: @7744
    GIM_Try, /*On fail goto*//*Label 349*/ 7865,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 350*/ 7815, // Rule ID 49015 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49015,
        GIR_Done,
      // Label 350: @7815
      GIM_Try, /*On fail goto*//*Label 351*/ 7864, // Rule ID 49016 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49016,
        GIR_Done,
      // Label 351: @7864
      GIM_Reject,
    // Label 349: @7865
    GIM_Reject,
    // Label 305: @7866
    GIM_Try, /*On fail goto*//*Label 352*/ 7987,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 353*/ 7937, // Rule ID 49051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49051,
        GIR_Done,
      // Label 353: @7937
      GIM_Try, /*On fail goto*//*Label 354*/ 7986, // Rule ID 49052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49052,
        GIR_Done,
      // Label 354: @7986
      GIM_Reject,
    // Label 352: @7987
    GIM_Reject,
    // Label 306: @7988
    GIM_Try, /*On fail goto*//*Label 355*/ 8109,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 356*/ 8059, // Rule ID 49067 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49067,
        GIR_Done,
      // Label 356: @8059
      GIM_Try, /*On fail goto*//*Label 357*/ 8108, // Rule ID 49068 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49068,
        GIR_Done,
      // Label 357: @8108
      GIM_Reject,
    // Label 355: @8109
    GIM_Reject,
    // Label 307: @8110
    GIM_Try, /*On fail goto*//*Label 358*/ 8231,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 359*/ 8181, // Rule ID 49011 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49011,
        GIR_Done,
      // Label 359: @8181
      GIM_Try, /*On fail goto*//*Label 360*/ 8230, // Rule ID 49012 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49012,
        GIR_Done,
      // Label 360: @8230
      GIM_Reject,
    // Label 358: @8231
    GIM_Reject,
    // Label 308: @8232
    GIM_Try, /*On fail goto*//*Label 361*/ 8353,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 362*/ 8303, // Rule ID 49039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49039,
        GIR_Done,
      // Label 362: @8303
      GIM_Try, /*On fail goto*//*Label 363*/ 8352, // Rule ID 49040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49040,
        GIR_Done,
      // Label 363: @8352
      GIM_Reject,
    // Label 361: @8353
    GIM_Reject,
    // Label 309: @8354
    GIM_Try, /*On fail goto*//*Label 364*/ 8475,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 365*/ 8425, // Rule ID 49055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49055,
        GIR_Done,
      // Label 365: @8425
      GIM_Try, /*On fail goto*//*Label 366*/ 8474, // Rule ID 49056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49056,
        GIR_Done,
      // Label 366: @8474
      GIM_Reject,
    // Label 364: @8475
    GIM_Reject,
    // Label 310: @8476
    GIM_Try, /*On fail goto*//*Label 367*/ 8597,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 368*/ 8547, // Rule ID 49071 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49071,
        GIR_Done,
      // Label 368: @8547
      GIM_Try, /*On fail goto*//*Label 369*/ 8596, // Rule ID 49072 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49072,
        GIR_Done,
      // Label 369: @8596
      GIM_Reject,
    // Label 367: @8597
    GIM_Reject,
    // Label 311: @8598
    GIM_Try, /*On fail goto*//*Label 370*/ 8719,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 371*/ 8669, // Rule ID 49027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49027,
        GIR_Done,
      // Label 371: @8669
      GIM_Try, /*On fail goto*//*Label 372*/ 8718, // Rule ID 49028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49028,
        GIR_Done,
      // Label 372: @8718
      GIM_Reject,
    // Label 370: @8719
    GIM_Reject,
    // Label 312: @8720
    GIM_Try, /*On fail goto*//*Label 373*/ 8841,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 374*/ 8791, // Rule ID 49043 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49043,
        GIR_Done,
      // Label 374: @8791
      GIM_Try, /*On fail goto*//*Label 375*/ 8840, // Rule ID 49044 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49044,
        GIR_Done,
      // Label 375: @8840
      GIM_Reject,
    // Label 373: @8841
    GIM_Reject,
    // Label 313: @8842
    GIM_Try, /*On fail goto*//*Label 376*/ 8963,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 377*/ 8913, // Rule ID 49059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49059,
        GIR_Done,
      // Label 377: @8913
      GIM_Try, /*On fail goto*//*Label 378*/ 8962, // Rule ID 49060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49060,
        GIR_Done,
      // Label 378: @8962
      GIM_Reject,
    // Label 376: @8963
    GIM_Reject,
    // Label 314: @8964
    GIM_Try, /*On fail goto*//*Label 379*/ 9085,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 380*/ 9035, // Rule ID 49031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49031,
        GIR_Done,
      // Label 380: @9035
      GIM_Try, /*On fail goto*//*Label 381*/ 9084, // Rule ID 49032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49032,
        GIR_Done,
      // Label 381: @9084
      GIM_Reject,
    // Label 379: @9085
    GIM_Reject,
    // Label 315: @9086
    GIM_Try, /*On fail goto*//*Label 382*/ 9207,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 383*/ 9157, // Rule ID 49047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49047,
        GIR_Done,
      // Label 383: @9157
      GIM_Try, /*On fail goto*//*Label 384*/ 9206, // Rule ID 49048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49048,
        GIR_Done,
      // Label 384: @9206
      GIM_Reject,
    // Label 382: @9207
    GIM_Reject,
    // Label 316: @9208
    GIM_Try, /*On fail goto*//*Label 385*/ 9329,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 386*/ 9279, // Rule ID 49035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49035,
        GIR_Done,
      // Label 386: @9279
      GIM_Try, /*On fail goto*//*Label 387*/ 9328, // Rule ID 49036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49036,
        GIR_Done,
      // Label 387: @9328
      GIM_Reject,
    // Label 385: @9329
    GIM_Reject,
    // Label 317: @9330
    GIM_Reject,
    // Label 3: @9331
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 412*/ 12116,
    /*GILLT_s32*//*Label 388*/ 9368,
    /*GILLT_s64*//*Label 389*/ 9400, 0,
    /*GILLT_nxv1s8*//*Label 390*/ 9432,
    /*GILLT_nxv1s16*//*Label 391*/ 9554,
    /*GILLT_nxv1s32*//*Label 392*/ 9676,
    /*GILLT_nxv1s64*//*Label 393*/ 9798, 0,
    /*GILLT_nxv2s8*//*Label 394*/ 9920,
    /*GILLT_nxv2s16*//*Label 395*/ 10042,
    /*GILLT_nxv2s32*//*Label 396*/ 10164,
    /*GILLT_nxv2s64*//*Label 397*/ 10286, 0,
    /*GILLT_nxv4s8*//*Label 398*/ 10408,
    /*GILLT_nxv4s16*//*Label 399*/ 10530,
    /*GILLT_nxv4s32*//*Label 400*/ 10652,
    /*GILLT_nxv4s64*//*Label 401*/ 10774, 0,
    /*GILLT_nxv8s8*//*Label 402*/ 10896,
    /*GILLT_nxv8s16*//*Label 403*/ 11018,
    /*GILLT_nxv8s32*//*Label 404*/ 11140,
    /*GILLT_nxv8s64*//*Label 405*/ 11262, 0,
    /*GILLT_nxv16s8*//*Label 406*/ 11384,
    /*GILLT_nxv16s16*//*Label 407*/ 11506,
    /*GILLT_nxv16s32*//*Label 408*/ 11628, 0,
    /*GILLT_nxv32s8*//*Label 409*/ 11750,
    /*GILLT_nxv32s16*//*Label 410*/ 11872, 0,
    /*GILLT_nxv64s8*//*Label 411*/ 11994,
    // Label 388: @9368
    GIM_Try, /*On fail goto*//*Label 413*/ 9399, // Rule ID 274 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 274,
      GIR_Done,
    // Label 413: @9399
    GIM_Reject,
    // Label 389: @9400
    GIM_Try, /*On fail goto*//*Label 414*/ 9431, // Rule ID 273 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 273,
      GIR_Done,
    // Label 414: @9431
    GIM_Reject,
    // Label 390: @9432
    GIM_Try, /*On fail goto*//*Label 415*/ 9553,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 416*/ 9503, // Rule ID 49339 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49339,
        GIR_Done,
      // Label 416: @9503
      GIM_Try, /*On fail goto*//*Label 417*/ 9552, // Rule ID 49340 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49340,
        GIR_Done,
      // Label 417: @9552
      GIM_Reject,
    // Label 415: @9553
    GIM_Reject,
    // Label 391: @9554
    GIM_Try, /*On fail goto*//*Label 418*/ 9675,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 419*/ 9625, // Rule ID 49351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49351,
        GIR_Done,
      // Label 419: @9625
      GIM_Try, /*On fail goto*//*Label 420*/ 9674, // Rule ID 49352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49352,
        GIR_Done,
      // Label 420: @9674
      GIM_Reject,
    // Label 418: @9675
    GIM_Reject,
    // Label 392: @9676
    GIM_Try, /*On fail goto*//*Label 421*/ 9797,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 422*/ 9747, // Rule ID 49359 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49359,
        GIR_Done,
      // Label 422: @9747
      GIM_Try, /*On fail goto*//*Label 423*/ 9796, // Rule ID 49360 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49360,
        GIR_Done,
      // Label 423: @9796
      GIM_Reject,
    // Label 421: @9797
    GIM_Reject,
    // Label 393: @9798
    GIM_Try, /*On fail goto*//*Label 424*/ 9919,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 425*/ 9869, // Rule ID 49375 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49375,
        GIR_Done,
      // Label 425: @9869
      GIM_Try, /*On fail goto*//*Label 426*/ 9918, // Rule ID 49376 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49376,
        GIR_Done,
      // Label 426: @9918
      GIM_Reject,
    // Label 424: @9919
    GIM_Reject,
    // Label 394: @9920
    GIM_Try, /*On fail goto*//*Label 427*/ 10041,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 428*/ 9991, // Rule ID 49343 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49343,
        GIR_Done,
      // Label 428: @9991
      GIM_Try, /*On fail goto*//*Label 429*/ 10040, // Rule ID 49344 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49344,
        GIR_Done,
      // Label 429: @10040
      GIM_Reject,
    // Label 427: @10041
    GIM_Reject,
    // Label 395: @10042
    GIM_Try, /*On fail goto*//*Label 430*/ 10163,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 431*/ 10113, // Rule ID 49355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49355,
        GIR_Done,
      // Label 431: @10113
      GIM_Try, /*On fail goto*//*Label 432*/ 10162, // Rule ID 49356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49356,
        GIR_Done,
      // Label 432: @10162
      GIM_Reject,
    // Label 430: @10163
    GIM_Reject,
    // Label 396: @10164
    GIM_Try, /*On fail goto*//*Label 433*/ 10285,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 434*/ 10235, // Rule ID 49371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49371,
        GIR_Done,
      // Label 434: @10235
      GIM_Try, /*On fail goto*//*Label 435*/ 10284, // Rule ID 49372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49372,
        GIR_Done,
      // Label 435: @10284
      GIM_Reject,
    // Label 433: @10285
    GIM_Reject,
    // Label 397: @10286
    GIM_Try, /*On fail goto*//*Label 436*/ 10407,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 437*/ 10357, // Rule ID 49415 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49415,
        GIR_Done,
      // Label 437: @10357
      GIM_Try, /*On fail goto*//*Label 438*/ 10406, // Rule ID 49416 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49416,
        GIR_Done,
      // Label 438: @10406
      GIM_Reject,
    // Label 436: @10407
    GIM_Reject,
    // Label 398: @10408
    GIM_Try, /*On fail goto*//*Label 439*/ 10529,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 440*/ 10479, // Rule ID 49347 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49347,
        GIR_Done,
      // Label 440: @10479
      GIM_Try, /*On fail goto*//*Label 441*/ 10528, // Rule ID 49348 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49348,
        GIR_Done,
      // Label 441: @10528
      GIM_Reject,
    // Label 439: @10529
    GIM_Reject,
    // Label 399: @10530
    GIM_Try, /*On fail goto*//*Label 442*/ 10651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 443*/ 10601, // Rule ID 49367 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49367,
        GIR_Done,
      // Label 443: @10601
      GIM_Try, /*On fail goto*//*Label 444*/ 10650, // Rule ID 49368 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49368,
        GIR_Done,
      // Label 444: @10650
      GIM_Reject,
    // Label 442: @10651
    GIM_Reject,
    // Label 400: @10652
    GIM_Try, /*On fail goto*//*Label 445*/ 10773,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 446*/ 10723, // Rule ID 49403 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49403,
        GIR_Done,
      // Label 446: @10723
      GIM_Try, /*On fail goto*//*Label 447*/ 10772, // Rule ID 49404 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49404,
        GIR_Done,
      // Label 447: @10772
      GIM_Reject,
    // Label 445: @10773
    GIM_Reject,
    // Label 401: @10774
    GIM_Try, /*On fail goto*//*Label 448*/ 10895,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 449*/ 10845, // Rule ID 49419 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49419,
        GIR_Done,
      // Label 449: @10845
      GIM_Try, /*On fail goto*//*Label 450*/ 10894, // Rule ID 49420 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49420,
        GIR_Done,
      // Label 450: @10894
      GIM_Reject,
    // Label 448: @10895
    GIM_Reject,
    // Label 402: @10896
    GIM_Try, /*On fail goto*//*Label 451*/ 11017,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 452*/ 10967, // Rule ID 49363 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49363,
        GIR_Done,
      // Label 452: @10967
      GIM_Try, /*On fail goto*//*Label 453*/ 11016, // Rule ID 49364 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49364,
        GIR_Done,
      // Label 453: @11016
      GIM_Reject,
    // Label 451: @11017
    GIM_Reject,
    // Label 403: @11018
    GIM_Try, /*On fail goto*//*Label 454*/ 11139,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 455*/ 11089, // Rule ID 49391 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49391,
        GIR_Done,
      // Label 455: @11089
      GIM_Try, /*On fail goto*//*Label 456*/ 11138, // Rule ID 49392 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49392,
        GIR_Done,
      // Label 456: @11138
      GIM_Reject,
    // Label 454: @11139
    GIM_Reject,
    // Label 404: @11140
    GIM_Try, /*On fail goto*//*Label 457*/ 11261,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 458*/ 11211, // Rule ID 49407 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49407,
        GIR_Done,
      // Label 458: @11211
      GIM_Try, /*On fail goto*//*Label 459*/ 11260, // Rule ID 49408 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49408,
        GIR_Done,
      // Label 459: @11260
      GIM_Reject,
    // Label 457: @11261
    GIM_Reject,
    // Label 405: @11262
    GIM_Try, /*On fail goto*//*Label 460*/ 11383,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 461*/ 11333, // Rule ID 49423 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49423,
        GIR_Done,
      // Label 461: @11333
      GIM_Try, /*On fail goto*//*Label 462*/ 11382, // Rule ID 49424 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49424,
        GIR_Done,
      // Label 462: @11382
      GIM_Reject,
    // Label 460: @11383
    GIM_Reject,
    // Label 406: @11384
    GIM_Try, /*On fail goto*//*Label 463*/ 11505,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 464*/ 11455, // Rule ID 49379 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49379,
        GIR_Done,
      // Label 464: @11455
      GIM_Try, /*On fail goto*//*Label 465*/ 11504, // Rule ID 49380 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49380,
        GIR_Done,
      // Label 465: @11504
      GIM_Reject,
    // Label 463: @11505
    GIM_Reject,
    // Label 407: @11506
    GIM_Try, /*On fail goto*//*Label 466*/ 11627,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 467*/ 11577, // Rule ID 49395 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49395,
        GIR_Done,
      // Label 467: @11577
      GIM_Try, /*On fail goto*//*Label 468*/ 11626, // Rule ID 49396 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49396,
        GIR_Done,
      // Label 468: @11626
      GIM_Reject,
    // Label 466: @11627
    GIM_Reject,
    // Label 408: @11628
    GIM_Try, /*On fail goto*//*Label 469*/ 11749,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 470*/ 11699, // Rule ID 49411 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49411,
        GIR_Done,
      // Label 470: @11699
      GIM_Try, /*On fail goto*//*Label 471*/ 11748, // Rule ID 49412 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49412,
        GIR_Done,
      // Label 471: @11748
      GIM_Reject,
    // Label 469: @11749
    GIM_Reject,
    // Label 409: @11750
    GIM_Try, /*On fail goto*//*Label 472*/ 11871,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 473*/ 11821, // Rule ID 49383 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49383,
        GIR_Done,
      // Label 473: @11821
      GIM_Try, /*On fail goto*//*Label 474*/ 11870, // Rule ID 49384 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49384,
        GIR_Done,
      // Label 474: @11870
      GIM_Reject,
    // Label 472: @11871
    GIM_Reject,
    // Label 410: @11872
    GIM_Try, /*On fail goto*//*Label 475*/ 11993,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 476*/ 11943, // Rule ID 49399 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49399,
        GIR_Done,
      // Label 476: @11943
      GIM_Try, /*On fail goto*//*Label 477*/ 11992, // Rule ID 49400 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49400,
        GIR_Done,
      // Label 477: @11992
      GIM_Reject,
    // Label 475: @11993
    GIM_Reject,
    // Label 411: @11994
    GIM_Try, /*On fail goto*//*Label 478*/ 12115,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 479*/ 12065, // Rule ID 49387 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49387,
        GIR_Done,
      // Label 479: @12065
      GIM_Try, /*On fail goto*//*Label 480*/ 12114, // Rule ID 49388 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49388,
        GIR_Done,
      // Label 480: @12114
      GIM_Reject,
    // Label 478: @12115
    GIM_Reject,
    // Label 412: @12116
    GIM_Reject,
    // Label 4: @12117
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 505*/ 14902,
    /*GILLT_s32*//*Label 481*/ 12154,
    /*GILLT_s64*//*Label 482*/ 12186, 0,
    /*GILLT_nxv1s8*//*Label 483*/ 12218,
    /*GILLT_nxv1s16*//*Label 484*/ 12340,
    /*GILLT_nxv1s32*//*Label 485*/ 12462,
    /*GILLT_nxv1s64*//*Label 486*/ 12584, 0,
    /*GILLT_nxv2s8*//*Label 487*/ 12706,
    /*GILLT_nxv2s16*//*Label 488*/ 12828,
    /*GILLT_nxv2s32*//*Label 489*/ 12950,
    /*GILLT_nxv2s64*//*Label 490*/ 13072, 0,
    /*GILLT_nxv4s8*//*Label 491*/ 13194,
    /*GILLT_nxv4s16*//*Label 492*/ 13316,
    /*GILLT_nxv4s32*//*Label 493*/ 13438,
    /*GILLT_nxv4s64*//*Label 494*/ 13560, 0,
    /*GILLT_nxv8s8*//*Label 495*/ 13682,
    /*GILLT_nxv8s16*//*Label 496*/ 13804,
    /*GILLT_nxv8s32*//*Label 497*/ 13926,
    /*GILLT_nxv8s64*//*Label 498*/ 14048, 0,
    /*GILLT_nxv16s8*//*Label 499*/ 14170,
    /*GILLT_nxv16s16*//*Label 500*/ 14292,
    /*GILLT_nxv16s32*//*Label 501*/ 14414, 0,
    /*GILLT_nxv32s8*//*Label 502*/ 14536,
    /*GILLT_nxv32s16*//*Label 503*/ 14658, 0,
    /*GILLT_nxv64s8*//*Label 504*/ 14780,
    // Label 481: @12154
    GIM_Try, /*On fail goto*//*Label 506*/ 12185, // Rule ID 276 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 276,
      GIR_Done,
    // Label 506: @12185
    GIM_Reject,
    // Label 482: @12186
    GIM_Try, /*On fail goto*//*Label 507*/ 12217, // Rule ID 275 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 275,
      GIR_Done,
    // Label 507: @12217
    GIM_Reject,
    // Label 483: @12218
    GIM_Try, /*On fail goto*//*Label 508*/ 12339,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 509*/ 12289, // Rule ID 49251 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49251,
        GIR_Done,
      // Label 509: @12289
      GIM_Try, /*On fail goto*//*Label 510*/ 12338, // Rule ID 49252 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49252,
        GIR_Done,
      // Label 510: @12338
      GIM_Reject,
    // Label 508: @12339
    GIM_Reject,
    // Label 484: @12340
    GIM_Try, /*On fail goto*//*Label 511*/ 12461,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 512*/ 12411, // Rule ID 49263 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49263,
        GIR_Done,
      // Label 512: @12411
      GIM_Try, /*On fail goto*//*Label 513*/ 12460, // Rule ID 49264 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49264,
        GIR_Done,
      // Label 513: @12460
      GIM_Reject,
    // Label 511: @12461
    GIM_Reject,
    // Label 485: @12462
    GIM_Try, /*On fail goto*//*Label 514*/ 12583,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 515*/ 12533, // Rule ID 49271 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49271,
        GIR_Done,
      // Label 515: @12533
      GIM_Try, /*On fail goto*//*Label 516*/ 12582, // Rule ID 49272 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49272,
        GIR_Done,
      // Label 516: @12582
      GIM_Reject,
    // Label 514: @12583
    GIM_Reject,
    // Label 486: @12584
    GIM_Try, /*On fail goto*//*Label 517*/ 12705,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 518*/ 12655, // Rule ID 49287 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49287,
        GIR_Done,
      // Label 518: @12655
      GIM_Try, /*On fail goto*//*Label 519*/ 12704, // Rule ID 49288 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49288,
        GIR_Done,
      // Label 519: @12704
      GIM_Reject,
    // Label 517: @12705
    GIM_Reject,
    // Label 487: @12706
    GIM_Try, /*On fail goto*//*Label 520*/ 12827,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 521*/ 12777, // Rule ID 49255 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49255,
        GIR_Done,
      // Label 521: @12777
      GIM_Try, /*On fail goto*//*Label 522*/ 12826, // Rule ID 49256 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49256,
        GIR_Done,
      // Label 522: @12826
      GIM_Reject,
    // Label 520: @12827
    GIM_Reject,
    // Label 488: @12828
    GIM_Try, /*On fail goto*//*Label 523*/ 12949,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 524*/ 12899, // Rule ID 49267 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49267,
        GIR_Done,
      // Label 524: @12899
      GIM_Try, /*On fail goto*//*Label 525*/ 12948, // Rule ID 49268 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49268,
        GIR_Done,
      // Label 525: @12948
      GIM_Reject,
    // Label 523: @12949
    GIM_Reject,
    // Label 489: @12950
    GIM_Try, /*On fail goto*//*Label 526*/ 13071,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 527*/ 13021, // Rule ID 49283 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49283,
        GIR_Done,
      // Label 527: @13021
      GIM_Try, /*On fail goto*//*Label 528*/ 13070, // Rule ID 49284 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49284,
        GIR_Done,
      // Label 528: @13070
      GIM_Reject,
    // Label 526: @13071
    GIM_Reject,
    // Label 490: @13072
    GIM_Try, /*On fail goto*//*Label 529*/ 13193,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 530*/ 13143, // Rule ID 49327 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49327,
        GIR_Done,
      // Label 530: @13143
      GIM_Try, /*On fail goto*//*Label 531*/ 13192, // Rule ID 49328 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49328,
        GIR_Done,
      // Label 531: @13192
      GIM_Reject,
    // Label 529: @13193
    GIM_Reject,
    // Label 491: @13194
    GIM_Try, /*On fail goto*//*Label 532*/ 13315,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 533*/ 13265, // Rule ID 49259 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49259,
        GIR_Done,
      // Label 533: @13265
      GIM_Try, /*On fail goto*//*Label 534*/ 13314, // Rule ID 49260 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49260,
        GIR_Done,
      // Label 534: @13314
      GIM_Reject,
    // Label 532: @13315
    GIM_Reject,
    // Label 492: @13316
    GIM_Try, /*On fail goto*//*Label 535*/ 13437,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 536*/ 13387, // Rule ID 49279 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49279,
        GIR_Done,
      // Label 536: @13387
      GIM_Try, /*On fail goto*//*Label 537*/ 13436, // Rule ID 49280 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49280,
        GIR_Done,
      // Label 537: @13436
      GIM_Reject,
    // Label 535: @13437
    GIM_Reject,
    // Label 493: @13438
    GIM_Try, /*On fail goto*//*Label 538*/ 13559,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 539*/ 13509, // Rule ID 49315 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49315,
        GIR_Done,
      // Label 539: @13509
      GIM_Try, /*On fail goto*//*Label 540*/ 13558, // Rule ID 49316 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49316,
        GIR_Done,
      // Label 540: @13558
      GIM_Reject,
    // Label 538: @13559
    GIM_Reject,
    // Label 494: @13560
    GIM_Try, /*On fail goto*//*Label 541*/ 13681,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 542*/ 13631, // Rule ID 49331 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49331,
        GIR_Done,
      // Label 542: @13631
      GIM_Try, /*On fail goto*//*Label 543*/ 13680, // Rule ID 49332 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49332,
        GIR_Done,
      // Label 543: @13680
      GIM_Reject,
    // Label 541: @13681
    GIM_Reject,
    // Label 495: @13682
    GIM_Try, /*On fail goto*//*Label 544*/ 13803,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 545*/ 13753, // Rule ID 49275 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49275,
        GIR_Done,
      // Label 545: @13753
      GIM_Try, /*On fail goto*//*Label 546*/ 13802, // Rule ID 49276 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49276,
        GIR_Done,
      // Label 546: @13802
      GIM_Reject,
    // Label 544: @13803
    GIM_Reject,
    // Label 496: @13804
    GIM_Try, /*On fail goto*//*Label 547*/ 13925,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 548*/ 13875, // Rule ID 49303 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49303,
        GIR_Done,
      // Label 548: @13875
      GIM_Try, /*On fail goto*//*Label 549*/ 13924, // Rule ID 49304 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49304,
        GIR_Done,
      // Label 549: @13924
      GIM_Reject,
    // Label 547: @13925
    GIM_Reject,
    // Label 497: @13926
    GIM_Try, /*On fail goto*//*Label 550*/ 14047,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 551*/ 13997, // Rule ID 49319 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49319,
        GIR_Done,
      // Label 551: @13997
      GIM_Try, /*On fail goto*//*Label 552*/ 14046, // Rule ID 49320 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49320,
        GIR_Done,
      // Label 552: @14046
      GIM_Reject,
    // Label 550: @14047
    GIM_Reject,
    // Label 498: @14048
    GIM_Try, /*On fail goto*//*Label 553*/ 14169,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 554*/ 14119, // Rule ID 49335 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49335,
        GIR_Done,
      // Label 554: @14119
      GIM_Try, /*On fail goto*//*Label 555*/ 14168, // Rule ID 49336 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49336,
        GIR_Done,
      // Label 555: @14168
      GIM_Reject,
    // Label 553: @14169
    GIM_Reject,
    // Label 499: @14170
    GIM_Try, /*On fail goto*//*Label 556*/ 14291,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 557*/ 14241, // Rule ID 49291 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49291,
        GIR_Done,
      // Label 557: @14241
      GIM_Try, /*On fail goto*//*Label 558*/ 14290, // Rule ID 49292 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49292,
        GIR_Done,
      // Label 558: @14290
      GIM_Reject,
    // Label 556: @14291
    GIM_Reject,
    // Label 500: @14292
    GIM_Try, /*On fail goto*//*Label 559*/ 14413,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 560*/ 14363, // Rule ID 49307 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49307,
        GIR_Done,
      // Label 560: @14363
      GIM_Try, /*On fail goto*//*Label 561*/ 14412, // Rule ID 49308 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49308,
        GIR_Done,
      // Label 561: @14412
      GIM_Reject,
    // Label 559: @14413
    GIM_Reject,
    // Label 501: @14414
    GIM_Try, /*On fail goto*//*Label 562*/ 14535,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 563*/ 14485, // Rule ID 49323 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49323,
        GIR_Done,
      // Label 563: @14485
      GIM_Try, /*On fail goto*//*Label 564*/ 14534, // Rule ID 49324 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49324,
        GIR_Done,
      // Label 564: @14534
      GIM_Reject,
    // Label 562: @14535
    GIM_Reject,
    // Label 502: @14536
    GIM_Try, /*On fail goto*//*Label 565*/ 14657,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 566*/ 14607, // Rule ID 49295 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49295,
        GIR_Done,
      // Label 566: @14607
      GIM_Try, /*On fail goto*//*Label 567*/ 14656, // Rule ID 49296 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49296,
        GIR_Done,
      // Label 567: @14656
      GIM_Reject,
    // Label 565: @14657
    GIM_Reject,
    // Label 503: @14658
    GIM_Try, /*On fail goto*//*Label 568*/ 14779,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 569*/ 14729, // Rule ID 49311 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49311,
        GIR_Done,
      // Label 569: @14729
      GIM_Try, /*On fail goto*//*Label 570*/ 14778, // Rule ID 49312 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49312,
        GIR_Done,
      // Label 570: @14778
      GIM_Reject,
    // Label 568: @14779
    GIM_Reject,
    // Label 504: @14780
    GIM_Try, /*On fail goto*//*Label 571*/ 14901,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 572*/ 14851, // Rule ID 49299 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49299,
        GIR_Done,
      // Label 572: @14851
      GIM_Try, /*On fail goto*//*Label 573*/ 14900, // Rule ID 49300 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49300,
        GIR_Done,
      // Label 573: @14900
      GIM_Reject,
    // Label 571: @14901
    GIM_Reject,
    // Label 505: @14902
    GIM_Reject,
    // Label 5: @14903
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 598*/ 17688,
    /*GILLT_s32*//*Label 574*/ 14940,
    /*GILLT_s64*//*Label 575*/ 14972, 0,
    /*GILLT_nxv1s8*//*Label 576*/ 15004,
    /*GILLT_nxv1s16*//*Label 577*/ 15126,
    /*GILLT_nxv1s32*//*Label 578*/ 15248,
    /*GILLT_nxv1s64*//*Label 579*/ 15370, 0,
    /*GILLT_nxv2s8*//*Label 580*/ 15492,
    /*GILLT_nxv2s16*//*Label 581*/ 15614,
    /*GILLT_nxv2s32*//*Label 582*/ 15736,
    /*GILLT_nxv2s64*//*Label 583*/ 15858, 0,
    /*GILLT_nxv4s8*//*Label 584*/ 15980,
    /*GILLT_nxv4s16*//*Label 585*/ 16102,
    /*GILLT_nxv4s32*//*Label 586*/ 16224,
    /*GILLT_nxv4s64*//*Label 587*/ 16346, 0,
    /*GILLT_nxv8s8*//*Label 588*/ 16468,
    /*GILLT_nxv8s16*//*Label 589*/ 16590,
    /*GILLT_nxv8s32*//*Label 590*/ 16712,
    /*GILLT_nxv8s64*//*Label 591*/ 16834, 0,
    /*GILLT_nxv16s8*//*Label 592*/ 16956,
    /*GILLT_nxv16s16*//*Label 593*/ 17078,
    /*GILLT_nxv16s32*//*Label 594*/ 17200, 0,
    /*GILLT_nxv32s8*//*Label 595*/ 17322,
    /*GILLT_nxv32s16*//*Label 596*/ 17444, 0,
    /*GILLT_nxv64s8*//*Label 597*/ 17566,
    // Label 574: @14940
    GIM_Try, /*On fail goto*//*Label 599*/ 14971, // Rule ID 278 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 278,
      GIR_Done,
    // Label 599: @14971
    GIM_Reject,
    // Label 575: @14972
    GIM_Try, /*On fail goto*//*Label 600*/ 15003, // Rule ID 277 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 277,
      GIR_Done,
    // Label 600: @15003
    GIM_Reject,
    // Label 576: @15004
    GIM_Try, /*On fail goto*//*Label 601*/ 15125,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 602*/ 15075, // Rule ID 49515 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49515,
        GIR_Done,
      // Label 602: @15075
      GIM_Try, /*On fail goto*//*Label 603*/ 15124, // Rule ID 49516 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49516,
        GIR_Done,
      // Label 603: @15124
      GIM_Reject,
    // Label 601: @15125
    GIM_Reject,
    // Label 577: @15126
    GIM_Try, /*On fail goto*//*Label 604*/ 15247,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 605*/ 15197, // Rule ID 49527 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49527,
        GIR_Done,
      // Label 605: @15197
      GIM_Try, /*On fail goto*//*Label 606*/ 15246, // Rule ID 49528 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49528,
        GIR_Done,
      // Label 606: @15246
      GIM_Reject,
    // Label 604: @15247
    GIM_Reject,
    // Label 578: @15248
    GIM_Try, /*On fail goto*//*Label 607*/ 15369,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 608*/ 15319, // Rule ID 49535 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49535,
        GIR_Done,
      // Label 608: @15319
      GIM_Try, /*On fail goto*//*Label 609*/ 15368, // Rule ID 49536 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49536,
        GIR_Done,
      // Label 609: @15368
      GIM_Reject,
    // Label 607: @15369
    GIM_Reject,
    // Label 579: @15370
    GIM_Try, /*On fail goto*//*Label 610*/ 15491,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 611*/ 15441, // Rule ID 49551 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49551,
        GIR_Done,
      // Label 611: @15441
      GIM_Try, /*On fail goto*//*Label 612*/ 15490, // Rule ID 49552 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49552,
        GIR_Done,
      // Label 612: @15490
      GIM_Reject,
    // Label 610: @15491
    GIM_Reject,
    // Label 580: @15492
    GIM_Try, /*On fail goto*//*Label 613*/ 15613,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 614*/ 15563, // Rule ID 49519 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49519,
        GIR_Done,
      // Label 614: @15563
      GIM_Try, /*On fail goto*//*Label 615*/ 15612, // Rule ID 49520 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49520,
        GIR_Done,
      // Label 615: @15612
      GIM_Reject,
    // Label 613: @15613
    GIM_Reject,
    // Label 581: @15614
    GIM_Try, /*On fail goto*//*Label 616*/ 15735,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 617*/ 15685, // Rule ID 49531 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49531,
        GIR_Done,
      // Label 617: @15685
      GIM_Try, /*On fail goto*//*Label 618*/ 15734, // Rule ID 49532 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49532,
        GIR_Done,
      // Label 618: @15734
      GIM_Reject,
    // Label 616: @15735
    GIM_Reject,
    // Label 582: @15736
    GIM_Try, /*On fail goto*//*Label 619*/ 15857,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 620*/ 15807, // Rule ID 49547 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49547,
        GIR_Done,
      // Label 620: @15807
      GIM_Try, /*On fail goto*//*Label 621*/ 15856, // Rule ID 49548 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49548,
        GIR_Done,
      // Label 621: @15856
      GIM_Reject,
    // Label 619: @15857
    GIM_Reject,
    // Label 583: @15858
    GIM_Try, /*On fail goto*//*Label 622*/ 15979,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 623*/ 15929, // Rule ID 49591 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49591,
        GIR_Done,
      // Label 623: @15929
      GIM_Try, /*On fail goto*//*Label 624*/ 15978, // Rule ID 49592 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49592,
        GIR_Done,
      // Label 624: @15978
      GIM_Reject,
    // Label 622: @15979
    GIM_Reject,
    // Label 584: @15980
    GIM_Try, /*On fail goto*//*Label 625*/ 16101,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 626*/ 16051, // Rule ID 49523 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49523,
        GIR_Done,
      // Label 626: @16051
      GIM_Try, /*On fail goto*//*Label 627*/ 16100, // Rule ID 49524 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49524,
        GIR_Done,
      // Label 627: @16100
      GIM_Reject,
    // Label 625: @16101
    GIM_Reject,
    // Label 585: @16102
    GIM_Try, /*On fail goto*//*Label 628*/ 16223,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 629*/ 16173, // Rule ID 49543 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49543,
        GIR_Done,
      // Label 629: @16173
      GIM_Try, /*On fail goto*//*Label 630*/ 16222, // Rule ID 49544 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49544,
        GIR_Done,
      // Label 630: @16222
      GIM_Reject,
    // Label 628: @16223
    GIM_Reject,
    // Label 586: @16224
    GIM_Try, /*On fail goto*//*Label 631*/ 16345,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 632*/ 16295, // Rule ID 49579 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49579,
        GIR_Done,
      // Label 632: @16295
      GIM_Try, /*On fail goto*//*Label 633*/ 16344, // Rule ID 49580 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49580,
        GIR_Done,
      // Label 633: @16344
      GIM_Reject,
    // Label 631: @16345
    GIM_Reject,
    // Label 587: @16346
    GIM_Try, /*On fail goto*//*Label 634*/ 16467,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 635*/ 16417, // Rule ID 49595 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49595,
        GIR_Done,
      // Label 635: @16417
      GIM_Try, /*On fail goto*//*Label 636*/ 16466, // Rule ID 49596 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49596,
        GIR_Done,
      // Label 636: @16466
      GIM_Reject,
    // Label 634: @16467
    GIM_Reject,
    // Label 588: @16468
    GIM_Try, /*On fail goto*//*Label 637*/ 16589,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 638*/ 16539, // Rule ID 49539 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49539,
        GIR_Done,
      // Label 638: @16539
      GIM_Try, /*On fail goto*//*Label 639*/ 16588, // Rule ID 49540 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49540,
        GIR_Done,
      // Label 639: @16588
      GIM_Reject,
    // Label 637: @16589
    GIM_Reject,
    // Label 589: @16590
    GIM_Try, /*On fail goto*//*Label 640*/ 16711,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 641*/ 16661, // Rule ID 49567 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49567,
        GIR_Done,
      // Label 641: @16661
      GIM_Try, /*On fail goto*//*Label 642*/ 16710, // Rule ID 49568 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49568,
        GIR_Done,
      // Label 642: @16710
      GIM_Reject,
    // Label 640: @16711
    GIM_Reject,
    // Label 590: @16712
    GIM_Try, /*On fail goto*//*Label 643*/ 16833,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 644*/ 16783, // Rule ID 49583 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49583,
        GIR_Done,
      // Label 644: @16783
      GIM_Try, /*On fail goto*//*Label 645*/ 16832, // Rule ID 49584 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49584,
        GIR_Done,
      // Label 645: @16832
      GIM_Reject,
    // Label 643: @16833
    GIM_Reject,
    // Label 591: @16834
    GIM_Try, /*On fail goto*//*Label 646*/ 16955,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 647*/ 16905, // Rule ID 49599 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49599,
        GIR_Done,
      // Label 647: @16905
      GIM_Try, /*On fail goto*//*Label 648*/ 16954, // Rule ID 49600 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49600,
        GIR_Done,
      // Label 648: @16954
      GIM_Reject,
    // Label 646: @16955
    GIM_Reject,
    // Label 592: @16956
    GIM_Try, /*On fail goto*//*Label 649*/ 17077,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 650*/ 17027, // Rule ID 49555 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49555,
        GIR_Done,
      // Label 650: @17027
      GIM_Try, /*On fail goto*//*Label 651*/ 17076, // Rule ID 49556 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49556,
        GIR_Done,
      // Label 651: @17076
      GIM_Reject,
    // Label 649: @17077
    GIM_Reject,
    // Label 593: @17078
    GIM_Try, /*On fail goto*//*Label 652*/ 17199,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 653*/ 17149, // Rule ID 49571 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49571,
        GIR_Done,
      // Label 653: @17149
      GIM_Try, /*On fail goto*//*Label 654*/ 17198, // Rule ID 49572 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49572,
        GIR_Done,
      // Label 654: @17198
      GIM_Reject,
    // Label 652: @17199
    GIM_Reject,
    // Label 594: @17200
    GIM_Try, /*On fail goto*//*Label 655*/ 17321,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 656*/ 17271, // Rule ID 49587 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49587,
        GIR_Done,
      // Label 656: @17271
      GIM_Try, /*On fail goto*//*Label 657*/ 17320, // Rule ID 49588 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49588,
        GIR_Done,
      // Label 657: @17320
      GIM_Reject,
    // Label 655: @17321
    GIM_Reject,
    // Label 595: @17322
    GIM_Try, /*On fail goto*//*Label 658*/ 17443,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 659*/ 17393, // Rule ID 49559 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49559,
        GIR_Done,
      // Label 659: @17393
      GIM_Try, /*On fail goto*//*Label 660*/ 17442, // Rule ID 49560 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49560,
        GIR_Done,
      // Label 660: @17442
      GIM_Reject,
    // Label 658: @17443
    GIM_Reject,
    // Label 596: @17444
    GIM_Try, /*On fail goto*//*Label 661*/ 17565,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 662*/ 17515, // Rule ID 49575 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49575,
        GIR_Done,
      // Label 662: @17515
      GIM_Try, /*On fail goto*//*Label 663*/ 17564, // Rule ID 49576 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49576,
        GIR_Done,
      // Label 663: @17564
      GIM_Reject,
    // Label 661: @17565
    GIM_Reject,
    // Label 597: @17566
    GIM_Try, /*On fail goto*//*Label 664*/ 17687,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 665*/ 17637, // Rule ID 49563 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49563,
        GIR_Done,
      // Label 665: @17637
      GIM_Try, /*On fail goto*//*Label 666*/ 17686, // Rule ID 49564 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49564,
        GIR_Done,
      // Label 666: @17686
      GIM_Reject,
    // Label 664: @17687
    GIM_Reject,
    // Label 598: @17688
    GIM_Reject,
    // Label 6: @17689
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 691*/ 20474,
    /*GILLT_s32*//*Label 667*/ 17726,
    /*GILLT_s64*//*Label 668*/ 17758, 0,
    /*GILLT_nxv1s8*//*Label 669*/ 17790,
    /*GILLT_nxv1s16*//*Label 670*/ 17912,
    /*GILLT_nxv1s32*//*Label 671*/ 18034,
    /*GILLT_nxv1s64*//*Label 672*/ 18156, 0,
    /*GILLT_nxv2s8*//*Label 673*/ 18278,
    /*GILLT_nxv2s16*//*Label 674*/ 18400,
    /*GILLT_nxv2s32*//*Label 675*/ 18522,
    /*GILLT_nxv2s64*//*Label 676*/ 18644, 0,
    /*GILLT_nxv4s8*//*Label 677*/ 18766,
    /*GILLT_nxv4s16*//*Label 678*/ 18888,
    /*GILLT_nxv4s32*//*Label 679*/ 19010,
    /*GILLT_nxv4s64*//*Label 680*/ 19132, 0,
    /*GILLT_nxv8s8*//*Label 681*/ 19254,
    /*GILLT_nxv8s16*//*Label 682*/ 19376,
    /*GILLT_nxv8s32*//*Label 683*/ 19498,
    /*GILLT_nxv8s64*//*Label 684*/ 19620, 0,
    /*GILLT_nxv16s8*//*Label 685*/ 19742,
    /*GILLT_nxv16s16*//*Label 686*/ 19864,
    /*GILLT_nxv16s32*//*Label 687*/ 19986, 0,
    /*GILLT_nxv32s8*//*Label 688*/ 20108,
    /*GILLT_nxv32s16*//*Label 689*/ 20230, 0,
    /*GILLT_nxv64s8*//*Label 690*/ 20352,
    // Label 667: @17726
    GIM_Try, /*On fail goto*//*Label 692*/ 17757, // Rule ID 280 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 280,
      GIR_Done,
    // Label 692: @17757
    GIM_Reject,
    // Label 668: @17758
    GIM_Try, /*On fail goto*//*Label 693*/ 17789, // Rule ID 279 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 279,
      GIR_Done,
    // Label 693: @17789
    GIM_Reject,
    // Label 669: @17790
    GIM_Try, /*On fail goto*//*Label 694*/ 17911,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 695*/ 17861, // Rule ID 49427 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49427,
        GIR_Done,
      // Label 695: @17861
      GIM_Try, /*On fail goto*//*Label 696*/ 17910, // Rule ID 49428 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49428,
        GIR_Done,
      // Label 696: @17910
      GIM_Reject,
    // Label 694: @17911
    GIM_Reject,
    // Label 670: @17912
    GIM_Try, /*On fail goto*//*Label 697*/ 18033,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 698*/ 17983, // Rule ID 49439 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49439,
        GIR_Done,
      // Label 698: @17983
      GIM_Try, /*On fail goto*//*Label 699*/ 18032, // Rule ID 49440 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49440,
        GIR_Done,
      // Label 699: @18032
      GIM_Reject,
    // Label 697: @18033
    GIM_Reject,
    // Label 671: @18034
    GIM_Try, /*On fail goto*//*Label 700*/ 18155,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 701*/ 18105, // Rule ID 49447 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49447,
        GIR_Done,
      // Label 701: @18105
      GIM_Try, /*On fail goto*//*Label 702*/ 18154, // Rule ID 49448 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49448,
        GIR_Done,
      // Label 702: @18154
      GIM_Reject,
    // Label 700: @18155
    GIM_Reject,
    // Label 672: @18156
    GIM_Try, /*On fail goto*//*Label 703*/ 18277,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 704*/ 18227, // Rule ID 49463 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49463,
        GIR_Done,
      // Label 704: @18227
      GIM_Try, /*On fail goto*//*Label 705*/ 18276, // Rule ID 49464 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49464,
        GIR_Done,
      // Label 705: @18276
      GIM_Reject,
    // Label 703: @18277
    GIM_Reject,
    // Label 673: @18278
    GIM_Try, /*On fail goto*//*Label 706*/ 18399,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 707*/ 18349, // Rule ID 49431 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49431,
        GIR_Done,
      // Label 707: @18349
      GIM_Try, /*On fail goto*//*Label 708*/ 18398, // Rule ID 49432 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49432,
        GIR_Done,
      // Label 708: @18398
      GIM_Reject,
    // Label 706: @18399
    GIM_Reject,
    // Label 674: @18400
    GIM_Try, /*On fail goto*//*Label 709*/ 18521,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 710*/ 18471, // Rule ID 49443 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49443,
        GIR_Done,
      // Label 710: @18471
      GIM_Try, /*On fail goto*//*Label 711*/ 18520, // Rule ID 49444 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49444,
        GIR_Done,
      // Label 711: @18520
      GIM_Reject,
    // Label 709: @18521
    GIM_Reject,
    // Label 675: @18522
    GIM_Try, /*On fail goto*//*Label 712*/ 18643,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 713*/ 18593, // Rule ID 49459 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49459,
        GIR_Done,
      // Label 713: @18593
      GIM_Try, /*On fail goto*//*Label 714*/ 18642, // Rule ID 49460 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49460,
        GIR_Done,
      // Label 714: @18642
      GIM_Reject,
    // Label 712: @18643
    GIM_Reject,
    // Label 676: @18644
    GIM_Try, /*On fail goto*//*Label 715*/ 18765,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 716*/ 18715, // Rule ID 49503 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49503,
        GIR_Done,
      // Label 716: @18715
      GIM_Try, /*On fail goto*//*Label 717*/ 18764, // Rule ID 49504 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49504,
        GIR_Done,
      // Label 717: @18764
      GIM_Reject,
    // Label 715: @18765
    GIM_Reject,
    // Label 677: @18766
    GIM_Try, /*On fail goto*//*Label 718*/ 18887,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 719*/ 18837, // Rule ID 49435 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49435,
        GIR_Done,
      // Label 719: @18837
      GIM_Try, /*On fail goto*//*Label 720*/ 18886, // Rule ID 49436 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49436,
        GIR_Done,
      // Label 720: @18886
      GIM_Reject,
    // Label 718: @18887
    GIM_Reject,
    // Label 678: @18888
    GIM_Try, /*On fail goto*//*Label 721*/ 19009,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 722*/ 18959, // Rule ID 49455 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49455,
        GIR_Done,
      // Label 722: @18959
      GIM_Try, /*On fail goto*//*Label 723*/ 19008, // Rule ID 49456 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49456,
        GIR_Done,
      // Label 723: @19008
      GIM_Reject,
    // Label 721: @19009
    GIM_Reject,
    // Label 679: @19010
    GIM_Try, /*On fail goto*//*Label 724*/ 19131,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 725*/ 19081, // Rule ID 49491 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49491,
        GIR_Done,
      // Label 725: @19081
      GIM_Try, /*On fail goto*//*Label 726*/ 19130, // Rule ID 49492 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49492,
        GIR_Done,
      // Label 726: @19130
      GIM_Reject,
    // Label 724: @19131
    GIM_Reject,
    // Label 680: @19132
    GIM_Try, /*On fail goto*//*Label 727*/ 19253,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 728*/ 19203, // Rule ID 49507 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49507,
        GIR_Done,
      // Label 728: @19203
      GIM_Try, /*On fail goto*//*Label 729*/ 19252, // Rule ID 49508 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49508,
        GIR_Done,
      // Label 729: @19252
      GIM_Reject,
    // Label 727: @19253
    GIM_Reject,
    // Label 681: @19254
    GIM_Try, /*On fail goto*//*Label 730*/ 19375,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 731*/ 19325, // Rule ID 49451 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49451,
        GIR_Done,
      // Label 731: @19325
      GIM_Try, /*On fail goto*//*Label 732*/ 19374, // Rule ID 49452 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49452,
        GIR_Done,
      // Label 732: @19374
      GIM_Reject,
    // Label 730: @19375
    GIM_Reject,
    // Label 682: @19376
    GIM_Try, /*On fail goto*//*Label 733*/ 19497,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 734*/ 19447, // Rule ID 49479 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49479,
        GIR_Done,
      // Label 734: @19447
      GIM_Try, /*On fail goto*//*Label 735*/ 19496, // Rule ID 49480 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49480,
        GIR_Done,
      // Label 735: @19496
      GIM_Reject,
    // Label 733: @19497
    GIM_Reject,
    // Label 683: @19498
    GIM_Try, /*On fail goto*//*Label 736*/ 19619,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 737*/ 19569, // Rule ID 49495 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49495,
        GIR_Done,
      // Label 737: @19569
      GIM_Try, /*On fail goto*//*Label 738*/ 19618, // Rule ID 49496 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49496,
        GIR_Done,
      // Label 738: @19618
      GIM_Reject,
    // Label 736: @19619
    GIM_Reject,
    // Label 684: @19620
    GIM_Try, /*On fail goto*//*Label 739*/ 19741,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 740*/ 19691, // Rule ID 49511 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49511,
        GIR_Done,
      // Label 740: @19691
      GIM_Try, /*On fail goto*//*Label 741*/ 19740, // Rule ID 49512 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49512,
        GIR_Done,
      // Label 741: @19740
      GIM_Reject,
    // Label 739: @19741
    GIM_Reject,
    // Label 685: @19742
    GIM_Try, /*On fail goto*//*Label 742*/ 19863,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 743*/ 19813, // Rule ID 49467 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49467,
        GIR_Done,
      // Label 743: @19813
      GIM_Try, /*On fail goto*//*Label 744*/ 19862, // Rule ID 49468 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49468,
        GIR_Done,
      // Label 744: @19862
      GIM_Reject,
    // Label 742: @19863
    GIM_Reject,
    // Label 686: @19864
    GIM_Try, /*On fail goto*//*Label 745*/ 19985,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 746*/ 19935, // Rule ID 49483 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49483,
        GIR_Done,
      // Label 746: @19935
      GIM_Try, /*On fail goto*//*Label 747*/ 19984, // Rule ID 49484 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49484,
        GIR_Done,
      // Label 747: @19984
      GIM_Reject,
    // Label 745: @19985
    GIM_Reject,
    // Label 687: @19986
    GIM_Try, /*On fail goto*//*Label 748*/ 20107,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 749*/ 20057, // Rule ID 49499 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49499,
        GIR_Done,
      // Label 749: @20057
      GIM_Try, /*On fail goto*//*Label 750*/ 20106, // Rule ID 49500 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49500,
        GIR_Done,
      // Label 750: @20106
      GIM_Reject,
    // Label 748: @20107
    GIM_Reject,
    // Label 688: @20108
    GIM_Try, /*On fail goto*//*Label 751*/ 20229,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 752*/ 20179, // Rule ID 49471 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49471,
        GIR_Done,
      // Label 752: @20179
      GIM_Try, /*On fail goto*//*Label 753*/ 20228, // Rule ID 49472 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49472,
        GIR_Done,
      // Label 753: @20228
      GIM_Reject,
    // Label 751: @20229
    GIM_Reject,
    // Label 689: @20230
    GIM_Try, /*On fail goto*//*Label 754*/ 20351,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 755*/ 20301, // Rule ID 49487 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49487,
        GIR_Done,
      // Label 755: @20301
      GIM_Try, /*On fail goto*//*Label 756*/ 20350, // Rule ID 49488 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49488,
        GIR_Done,
      // Label 756: @20350
      GIM_Reject,
    // Label 754: @20351
    GIM_Reject,
    // Label 690: @20352
    GIM_Try, /*On fail goto*//*Label 757*/ 20473,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 758*/ 20423, // Rule ID 49475 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49475,
        GIR_Done,
      // Label 758: @20423
      GIM_Try, /*On fail goto*//*Label 759*/ 20472, // Rule ID 49476 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8_E8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49476,
        GIR_Done,
      // Label 759: @20472
      GIM_Reject,
    // Label 757: @20473
    GIM_Reject,
    // Label 691: @20474
    GIM_Reject,
    // Label 7: @20475
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 791*/ 24754,
    /*GILLT_s32*//*Label 760*/ 20512,
    /*GILLT_s64*//*Label 761*/ 20970,
    /*GILLT_nxv1s1*//*Label 762*/ 21482,
    /*GILLT_nxv1s8*//*Label 763*/ 21566,
    /*GILLT_nxv1s16*//*Label 764*/ 21688,
    /*GILLT_nxv1s32*//*Label 765*/ 21810,
    /*GILLT_nxv1s64*//*Label 766*/ 21932,
    /*GILLT_nxv2s1*//*Label 767*/ 22054,
    /*GILLT_nxv2s8*//*Label 768*/ 22138,
    /*GILLT_nxv2s16*//*Label 769*/ 22260,
    /*GILLT_nxv2s32*//*Label 770*/ 22382,
    /*GILLT_nxv2s64*//*Label 771*/ 22504,
    /*GILLT_nxv4s1*//*Label 772*/ 22626,
    /*GILLT_nxv4s8*//*Label 773*/ 22710,
    /*GILLT_nxv4s16*//*Label 774*/ 22832,
    /*GILLT_nxv4s32*//*Label 775*/ 22954,
    /*GILLT_nxv4s64*//*Label 776*/ 23076,
    /*GILLT_nxv8s1*//*Label 777*/ 23198,
    /*GILLT_nxv8s8*//*Label 778*/ 23282,
    /*GILLT_nxv8s16*//*Label 779*/ 23404,
    /*GILLT_nxv8s32*//*Label 780*/ 23526,
    /*GILLT_nxv8s64*//*Label 781*/ 23648,
    /*GILLT_nxv16s1*//*Label 782*/ 23770,
    /*GILLT_nxv16s8*//*Label 783*/ 23854,
    /*GILLT_nxv16s16*//*Label 784*/ 23976,
    /*GILLT_nxv16s32*//*Label 785*/ 24098,
    /*GILLT_nxv32s1*//*Label 786*/ 24220,
    /*GILLT_nxv32s8*//*Label 787*/ 24304,
    /*GILLT_nxv32s16*//*Label 788*/ 24426,
    /*GILLT_nxv64s1*//*Label 789*/ 24548,
    /*GILLT_nxv64s8*//*Label 790*/ 24632,
    // Label 760: @20512
    GIM_Try, /*On fail goto*//*Label 792*/ 20969,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 793*/ 20586, // Rule ID 1777 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1777,
        GIR_Done,
      // Label 793: @20586
      GIM_Try, /*On fail goto*//*Label 794*/ 20646, // Rule ID 55672 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (TH_TST:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_TST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55672,
        GIR_Done,
      // Label 794: @20646
      GIM_Try, /*On fail goto*//*Label 795*/ 20699, // Rule ID 1761 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1761,
        GIR_Done,
      // Label 795: @20699
      GIM_Try, /*On fail goto*//*Label 796*/ 20752, // Rule ID 57531 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57531,
        GIR_Done,
      // Label 796: @20752
      GIM_Try, /*On fail goto*//*Label 797*/ 20805, // Rule ID 57541 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57541,
        GIR_Done,
      // Label 797: @20805
      GIM_Try, /*On fail goto*//*Label 798*/ 20858, // Rule ID 1741 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1741,
        GIR_Done,
      // Label 798: @20858
      GIM_Try, /*On fail goto*//*Label 799*/ 20886, // Rule ID 1835 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbb_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1835,
        GIR_Done,
      // Label 799: @20886
      GIM_Try, /*On fail goto*//*Label 800*/ 20914, // Rule ID 1836 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbb_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1836,
        GIR_Done,
      // Label 800: @20914
      GIM_Try, /*On fail goto*//*Label 801*/ 20951, // Rule ID 79 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 79,
        GIR_Done,
      // Label 801: @20951
      GIM_Try, /*On fail goto*//*Label 802*/ 20968, // Rule ID 77 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 802: @20968
      GIM_Reject,
    // Label 792: @20969
    GIM_Reject,
    // Label 761: @20970
    GIM_Try, /*On fail goto*//*Label 803*/ 21481,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 804*/ 21044, // Rule ID 1776 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1776,
        GIR_Done,
      // Label 804: @21044
      GIM_Try, /*On fail goto*//*Label 805*/ 21104, // Rule ID 55671 //
        GIM_CheckFeatures, GIFBS_HasVendorXTHeadBs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GICXXPred_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (TH_TST:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::TH_TST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55671,
        GIR_Done,
      // Label 805: @21104
      GIM_Try, /*On fail goto*//*Label 806*/ 21157, // Rule ID 1760 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1760,
        GIR_Done,
      // Label 806: @21157
      GIM_Try, /*On fail goto*//*Label 807*/ 21210, // Rule ID 57530 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57530,
        GIR_Done,
      // Label 807: @21210
      GIM_Try, /*On fail goto*//*Label 808*/ 21263, // Rule ID 57540 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57540,
        GIR_Done,
      // Label 808: @21263
      GIM_Try, /*On fail goto*//*Label 809*/ 21316, // Rule ID 1740 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1740,
        GIR_Done,
      // Label 809: @21316
      GIM_Try, /*On fail goto*//*Label 810*/ 21366, // Rule ID 233 //
        GIM_CheckFeatures, GIFBS_IsRV64_NotHasStdExtZba,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::SRLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 233,
        GIR_Done,
      // Label 810: @21366
      GIM_Try, /*On fail goto*//*Label 811*/ 21394, // Rule ID 1837 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbb_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1837,
        GIR_Done,
      // Label 811: @21394
      GIM_Try, /*On fail goto*//*Label 812*/ 21426, // Rule ID 1903 //
        GIM_CheckFeatures, GIFBS_HasStdExtZba_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADD_UW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1903,
        GIR_Done,
      // Label 812: @21426
      GIM_Try, /*On fail goto*//*Label 813*/ 21463, // Rule ID 78 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 78,
        GIR_Done,
      // Label 813: @21463
      GIM_Try, /*On fail goto*//*Label 814*/ 21480, // Rule ID 76 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 814: @21480
      GIM_Reject,
    // Label 803: @21481
    GIM_Reject,
    // Label 762: @21482
    GIM_Try, /*On fail goto*//*Label 815*/ 21565,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 816*/ 21534, // Rule ID 50913 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50913,
        GIR_Done,
      // Label 816: @21534
      GIM_Try, /*On fail goto*//*Label 817*/ 21564, // Rule ID 50914 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50914,
        GIR_Done,
      // Label 817: @21564
      GIM_Reject,
    // Label 815: @21565
    GIM_Reject,
    // Label 763: @21566
    GIM_Try, /*On fail goto*//*Label 818*/ 21687,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 819*/ 21637, // Rule ID 45875 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45875,
        GIR_Done,
      // Label 819: @21637
      GIM_Try, /*On fail goto*//*Label 820*/ 21686, // Rule ID 45876 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45876,
        GIR_Done,
      // Label 820: @21686
      GIM_Reject,
    // Label 818: @21687
    GIM_Reject,
    // Label 764: @21688
    GIM_Try, /*On fail goto*//*Label 821*/ 21809,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 822*/ 21759, // Rule ID 45887 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45887,
        GIR_Done,
      // Label 822: @21759
      GIM_Try, /*On fail goto*//*Label 823*/ 21808, // Rule ID 45888 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45888,
        GIR_Done,
      // Label 823: @21808
      GIM_Reject,
    // Label 821: @21809
    GIM_Reject,
    // Label 765: @21810
    GIM_Try, /*On fail goto*//*Label 824*/ 21931,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 825*/ 21881, // Rule ID 45895 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45895,
        GIR_Done,
      // Label 825: @21881
      GIM_Try, /*On fail goto*//*Label 826*/ 21930, // Rule ID 45896 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45896,
        GIR_Done,
      // Label 826: @21930
      GIM_Reject,
    // Label 824: @21931
    GIM_Reject,
    // Label 766: @21932
    GIM_Try, /*On fail goto*//*Label 827*/ 22053,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 828*/ 22003, // Rule ID 45911 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45911,
        GIR_Done,
      // Label 828: @22003
      GIM_Try, /*On fail goto*//*Label 829*/ 22052, // Rule ID 45912 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45912,
        GIR_Done,
      // Label 829: @22052
      GIM_Reject,
    // Label 827: @22053
    GIM_Reject,
    // Label 767: @22054
    GIM_Try, /*On fail goto*//*Label 830*/ 22137,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 831*/ 22106, // Rule ID 50931 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50931,
        GIR_Done,
      // Label 831: @22106
      GIM_Try, /*On fail goto*//*Label 832*/ 22136, // Rule ID 50932 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50932,
        GIR_Done,
      // Label 832: @22136
      GIM_Reject,
    // Label 830: @22137
    GIM_Reject,
    // Label 768: @22138
    GIM_Try, /*On fail goto*//*Label 833*/ 22259,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 834*/ 22209, // Rule ID 45879 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45879,
        GIR_Done,
      // Label 834: @22209
      GIM_Try, /*On fail goto*//*Label 835*/ 22258, // Rule ID 45880 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45880,
        GIR_Done,
      // Label 835: @22258
      GIM_Reject,
    // Label 833: @22259
    GIM_Reject,
    // Label 769: @22260
    GIM_Try, /*On fail goto*//*Label 836*/ 22381,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 837*/ 22331, // Rule ID 45891 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45891,
        GIR_Done,
      // Label 837: @22331
      GIM_Try, /*On fail goto*//*Label 838*/ 22380, // Rule ID 45892 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45892,
        GIR_Done,
      // Label 838: @22380
      GIM_Reject,
    // Label 836: @22381
    GIM_Reject,
    // Label 770: @22382
    GIM_Try, /*On fail goto*//*Label 839*/ 22503,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 840*/ 22453, // Rule ID 45907 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45907,
        GIR_Done,
      // Label 840: @22453
      GIM_Try, /*On fail goto*//*Label 841*/ 22502, // Rule ID 45908 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45908,
        GIR_Done,
      // Label 841: @22502
      GIM_Reject,
    // Label 839: @22503
    GIM_Reject,
    // Label 771: @22504
    GIM_Try, /*On fail goto*//*Label 842*/ 22625,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 843*/ 22575, // Rule ID 45951 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45951,
        GIR_Done,
      // Label 843: @22575
      GIM_Try, /*On fail goto*//*Label 844*/ 22624, // Rule ID 45952 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45952,
        GIR_Done,
      // Label 844: @22624
      GIM_Reject,
    // Label 842: @22625
    GIM_Reject,
    // Label 772: @22626
    GIM_Try, /*On fail goto*//*Label 845*/ 22709,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 846*/ 22678, // Rule ID 50949 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50949,
        GIR_Done,
      // Label 846: @22678
      GIM_Try, /*On fail goto*//*Label 847*/ 22708, // Rule ID 50950 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50950,
        GIR_Done,
      // Label 847: @22708
      GIM_Reject,
    // Label 845: @22709
    GIM_Reject,
    // Label 773: @22710
    GIM_Try, /*On fail goto*//*Label 848*/ 22831,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 849*/ 22781, // Rule ID 45883 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45883,
        GIR_Done,
      // Label 849: @22781
      GIM_Try, /*On fail goto*//*Label 850*/ 22830, // Rule ID 45884 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45884,
        GIR_Done,
      // Label 850: @22830
      GIM_Reject,
    // Label 848: @22831
    GIM_Reject,
    // Label 774: @22832
    GIM_Try, /*On fail goto*//*Label 851*/ 22953,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 852*/ 22903, // Rule ID 45903 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45903,
        GIR_Done,
      // Label 852: @22903
      GIM_Try, /*On fail goto*//*Label 853*/ 22952, // Rule ID 45904 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45904,
        GIR_Done,
      // Label 853: @22952
      GIM_Reject,
    // Label 851: @22953
    GIM_Reject,
    // Label 775: @22954
    GIM_Try, /*On fail goto*//*Label 854*/ 23075,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 855*/ 23025, // Rule ID 45939 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45939,
        GIR_Done,
      // Label 855: @23025
      GIM_Try, /*On fail goto*//*Label 856*/ 23074, // Rule ID 45940 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45940,
        GIR_Done,
      // Label 856: @23074
      GIM_Reject,
    // Label 854: @23075
    GIM_Reject,
    // Label 776: @23076
    GIM_Try, /*On fail goto*//*Label 857*/ 23197,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 858*/ 23147, // Rule ID 45955 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45955,
        GIR_Done,
      // Label 858: @23147
      GIM_Try, /*On fail goto*//*Label 859*/ 23196, // Rule ID 45956 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45956,
        GIR_Done,
      // Label 859: @23196
      GIM_Reject,
    // Label 857: @23197
    GIM_Reject,
    // Label 777: @23198
    GIM_Try, /*On fail goto*//*Label 860*/ 23281,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 861*/ 23250, // Rule ID 50967 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50967,
        GIR_Done,
      // Label 861: @23250
      GIM_Try, /*On fail goto*//*Label 862*/ 23280, // Rule ID 50968 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50968,
        GIR_Done,
      // Label 862: @23280
      GIM_Reject,
    // Label 860: @23281
    GIM_Reject,
    // Label 778: @23282
    GIM_Try, /*On fail goto*//*Label 863*/ 23403,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 864*/ 23353, // Rule ID 45899 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45899,
        GIR_Done,
      // Label 864: @23353
      GIM_Try, /*On fail goto*//*Label 865*/ 23402, // Rule ID 45900 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45900,
        GIR_Done,
      // Label 865: @23402
      GIM_Reject,
    // Label 863: @23403
    GIM_Reject,
    // Label 779: @23404
    GIM_Try, /*On fail goto*//*Label 866*/ 23525,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 867*/ 23475, // Rule ID 45927 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45927,
        GIR_Done,
      // Label 867: @23475
      GIM_Try, /*On fail goto*//*Label 868*/ 23524, // Rule ID 45928 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45928,
        GIR_Done,
      // Label 868: @23524
      GIM_Reject,
    // Label 866: @23525
    GIM_Reject,
    // Label 780: @23526
    GIM_Try, /*On fail goto*//*Label 869*/ 23647,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 870*/ 23597, // Rule ID 45943 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45943,
        GIR_Done,
      // Label 870: @23597
      GIM_Try, /*On fail goto*//*Label 871*/ 23646, // Rule ID 45944 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45944,
        GIR_Done,
      // Label 871: @23646
      GIM_Reject,
    // Label 869: @23647
    GIM_Reject,
    // Label 781: @23648
    GIM_Try, /*On fail goto*//*Label 872*/ 23769,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 873*/ 23719, // Rule ID 45959 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45959,
        GIR_Done,
      // Label 873: @23719
      GIM_Try, /*On fail goto*//*Label 874*/ 23768, // Rule ID 45960 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45960,
        GIR_Done,
      // Label 874: @23768
      GIM_Reject,
    // Label 872: @23769
    GIM_Reject,
    // Label 782: @23770
    GIM_Try, /*On fail goto*//*Label 875*/ 23853,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 876*/ 23822, // Rule ID 50985 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50985,
        GIR_Done,
      // Label 876: @23822
      GIM_Try, /*On fail goto*//*Label 877*/ 23852, // Rule ID 50986 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50986,
        GIR_Done,
      // Label 877: @23852
      GIM_Reject,
    // Label 875: @23853
    GIM_Reject,
    // Label 783: @23854
    GIM_Try, /*On fail goto*//*Label 878*/ 23975,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 879*/ 23925, // Rule ID 45915 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45915,
        GIR_Done,
      // Label 879: @23925
      GIM_Try, /*On fail goto*//*Label 880*/ 23974, // Rule ID 45916 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45916,
        GIR_Done,
      // Label 880: @23974
      GIM_Reject,
    // Label 878: @23975
    GIM_Reject,
    // Label 784: @23976
    GIM_Try, /*On fail goto*//*Label 881*/ 24097,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 882*/ 24047, // Rule ID 45931 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45931,
        GIR_Done,
      // Label 882: @24047
      GIM_Try, /*On fail goto*//*Label 883*/ 24096, // Rule ID 45932 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45932,
        GIR_Done,
      // Label 883: @24096
      GIM_Reject,
    // Label 881: @24097
    GIM_Reject,
    // Label 785: @24098
    GIM_Try, /*On fail goto*//*Label 884*/ 24219,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 885*/ 24169, // Rule ID 45947 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45947,
        GIR_Done,
      // Label 885: @24169
      GIM_Try, /*On fail goto*//*Label 886*/ 24218, // Rule ID 45948 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45948,
        GIR_Done,
      // Label 886: @24218
      GIM_Reject,
    // Label 884: @24219
    GIM_Reject,
    // Label 786: @24220
    GIM_Try, /*On fail goto*//*Label 887*/ 24303,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 888*/ 24272, // Rule ID 51003 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51003,
        GIR_Done,
      // Label 888: @24272
      GIM_Try, /*On fail goto*//*Label 889*/ 24302, // Rule ID 51004 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51004,
        GIR_Done,
      // Label 889: @24302
      GIM_Reject,
    // Label 887: @24303
    GIM_Reject,
    // Label 787: @24304
    GIM_Try, /*On fail goto*//*Label 890*/ 24425,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 891*/ 24375, // Rule ID 45919 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45919,
        GIR_Done,
      // Label 891: @24375
      GIM_Try, /*On fail goto*//*Label 892*/ 24424, // Rule ID 45920 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45920,
        GIR_Done,
      // Label 892: @24424
      GIM_Reject,
    // Label 890: @24425
    GIM_Reject,
    // Label 788: @24426
    GIM_Try, /*On fail goto*//*Label 893*/ 24547,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 894*/ 24497, // Rule ID 45935 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45935,
        GIR_Done,
      // Label 894: @24497
      GIM_Try, /*On fail goto*//*Label 895*/ 24546, // Rule ID 45936 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45936,
        GIR_Done,
      // Label 895: @24546
      GIM_Reject,
    // Label 893: @24547
    GIM_Reject,
    // Label 789: @24548
    GIM_Try, /*On fail goto*//*Label 896*/ 24631,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 897*/ 24600, // Rule ID 51021 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51021,
        GIR_Done,
      // Label 897: @24600
      GIM_Try, /*On fail goto*//*Label 898*/ 24630, // Rule ID 51022 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51022,
        GIR_Done,
      // Label 898: @24630
      GIM_Reject,
    // Label 896: @24631
    GIM_Reject,
    // Label 790: @24632
    GIM_Try, /*On fail goto*//*Label 899*/ 24753,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 900*/ 24703, // Rule ID 45923 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45923,
        GIR_Done,
      // Label 900: @24703
      GIM_Try, /*On fail goto*//*Label 901*/ 24752, // Rule ID 45924 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45924,
        GIR_Done,
      // Label 901: @24752
      GIM_Reject,
    // Label 899: @24753
    GIM_Reject,
    // Label 791: @24754
    GIM_Reject,
    // Label 8: @24755
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 933*/ 28416,
    /*GILLT_s32*//*Label 902*/ 24792,
    /*GILLT_s64*//*Label 903*/ 24968,
    /*GILLT_nxv1s1*//*Label 904*/ 25144,
    /*GILLT_nxv1s8*//*Label 905*/ 25228,
    /*GILLT_nxv1s16*//*Label 906*/ 25350,
    /*GILLT_nxv1s32*//*Label 907*/ 25472,
    /*GILLT_nxv1s64*//*Label 908*/ 25594,
    /*GILLT_nxv2s1*//*Label 909*/ 25716,
    /*GILLT_nxv2s8*//*Label 910*/ 25800,
    /*GILLT_nxv2s16*//*Label 911*/ 25922,
    /*GILLT_nxv2s32*//*Label 912*/ 26044,
    /*GILLT_nxv2s64*//*Label 913*/ 26166,
    /*GILLT_nxv4s1*//*Label 914*/ 26288,
    /*GILLT_nxv4s8*//*Label 915*/ 26372,
    /*GILLT_nxv4s16*//*Label 916*/ 26494,
    /*GILLT_nxv4s32*//*Label 917*/ 26616,
    /*GILLT_nxv4s64*//*Label 918*/ 26738,
    /*GILLT_nxv8s1*//*Label 919*/ 26860,
    /*GILLT_nxv8s8*//*Label 920*/ 26944,
    /*GILLT_nxv8s16*//*Label 921*/ 27066,
    /*GILLT_nxv8s32*//*Label 922*/ 27188,
    /*GILLT_nxv8s64*//*Label 923*/ 27310,
    /*GILLT_nxv16s1*//*Label 924*/ 27432,
    /*GILLT_nxv16s8*//*Label 925*/ 27516,
    /*GILLT_nxv16s16*//*Label 926*/ 27638,
    /*GILLT_nxv16s32*//*Label 927*/ 27760,
    /*GILLT_nxv32s1*//*Label 928*/ 27882,
    /*GILLT_nxv32s8*//*Label 929*/ 27966,
    /*GILLT_nxv32s16*//*Label 930*/ 28088,
    /*GILLT_nxv64s1*//*Label 931*/ 28210,
    /*GILLT_nxv64s8*//*Label 932*/ 28294,
    // Label 902: @24792
    GIM_Try, /*On fail goto*//*Label 934*/ 24967,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 935*/ 24859, // Rule ID 57533 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57533,
        GIR_Done,
      // Label 935: @24859
      GIM_Try, /*On fail goto*//*Label 936*/ 24912, // Rule ID 1743 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1743,
        GIR_Done,
      // Label 936: @24912
      GIM_Try, /*On fail goto*//*Label 937*/ 24949, // Rule ID 75 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 75,
        GIR_Done,
      // Label 937: @24949
      GIM_Try, /*On fail goto*//*Label 938*/ 24966, // Rule ID 73 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 938: @24966
      GIM_Reject,
    // Label 934: @24967
    GIM_Reject,
    // Label 903: @24968
    GIM_Try, /*On fail goto*//*Label 939*/ 25143,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 940*/ 25035, // Rule ID 57532 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57532,
        GIR_Done,
      // Label 940: @25035
      GIM_Try, /*On fail goto*//*Label 941*/ 25088, // Rule ID 1742 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1742,
        GIR_Done,
      // Label 941: @25088
      GIM_Try, /*On fail goto*//*Label 942*/ 25125, // Rule ID 74 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 74,
        GIR_Done,
      // Label 942: @25125
      GIM_Try, /*On fail goto*//*Label 943*/ 25142, // Rule ID 72 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (OR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 943: @25142
      GIM_Reject,
    // Label 939: @25143
    GIM_Reject,
    // Label 904: @25144
    GIM_Try, /*On fail goto*//*Label 944*/ 25227,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 945*/ 25196, // Rule ID 50915 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50915,
        GIR_Done,
      // Label 945: @25196
      GIM_Try, /*On fail goto*//*Label 946*/ 25226, // Rule ID 50916 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50916,
        GIR_Done,
      // Label 946: @25226
      GIM_Reject,
    // Label 944: @25227
    GIM_Reject,
    // Label 905: @25228
    GIM_Try, /*On fail goto*//*Label 947*/ 25349,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 948*/ 25299, // Rule ID 46007 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46007,
        GIR_Done,
      // Label 948: @25299
      GIM_Try, /*On fail goto*//*Label 949*/ 25348, // Rule ID 46008 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46008,
        GIR_Done,
      // Label 949: @25348
      GIM_Reject,
    // Label 947: @25349
    GIM_Reject,
    // Label 906: @25350
    GIM_Try, /*On fail goto*//*Label 950*/ 25471,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 951*/ 25421, // Rule ID 46019 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46019,
        GIR_Done,
      // Label 951: @25421
      GIM_Try, /*On fail goto*//*Label 952*/ 25470, // Rule ID 46020 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46020,
        GIR_Done,
      // Label 952: @25470
      GIM_Reject,
    // Label 950: @25471
    GIM_Reject,
    // Label 907: @25472
    GIM_Try, /*On fail goto*//*Label 953*/ 25593,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 954*/ 25543, // Rule ID 46027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46027,
        GIR_Done,
      // Label 954: @25543
      GIM_Try, /*On fail goto*//*Label 955*/ 25592, // Rule ID 46028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46028,
        GIR_Done,
      // Label 955: @25592
      GIM_Reject,
    // Label 953: @25593
    GIM_Reject,
    // Label 908: @25594
    GIM_Try, /*On fail goto*//*Label 956*/ 25715,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 957*/ 25665, // Rule ID 46043 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46043,
        GIR_Done,
      // Label 957: @25665
      GIM_Try, /*On fail goto*//*Label 958*/ 25714, // Rule ID 46044 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46044,
        GIR_Done,
      // Label 958: @25714
      GIM_Reject,
    // Label 956: @25715
    GIM_Reject,
    // Label 909: @25716
    GIM_Try, /*On fail goto*//*Label 959*/ 25799,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 960*/ 25768, // Rule ID 50933 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50933,
        GIR_Done,
      // Label 960: @25768
      GIM_Try, /*On fail goto*//*Label 961*/ 25798, // Rule ID 50934 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50934,
        GIR_Done,
      // Label 961: @25798
      GIM_Reject,
    // Label 959: @25799
    GIM_Reject,
    // Label 910: @25800
    GIM_Try, /*On fail goto*//*Label 962*/ 25921,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 963*/ 25871, // Rule ID 46011 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46011,
        GIR_Done,
      // Label 963: @25871
      GIM_Try, /*On fail goto*//*Label 964*/ 25920, // Rule ID 46012 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46012,
        GIR_Done,
      // Label 964: @25920
      GIM_Reject,
    // Label 962: @25921
    GIM_Reject,
    // Label 911: @25922
    GIM_Try, /*On fail goto*//*Label 965*/ 26043,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 966*/ 25993, // Rule ID 46023 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46023,
        GIR_Done,
      // Label 966: @25993
      GIM_Try, /*On fail goto*//*Label 967*/ 26042, // Rule ID 46024 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46024,
        GIR_Done,
      // Label 967: @26042
      GIM_Reject,
    // Label 965: @26043
    GIM_Reject,
    // Label 912: @26044
    GIM_Try, /*On fail goto*//*Label 968*/ 26165,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 969*/ 26115, // Rule ID 46039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46039,
        GIR_Done,
      // Label 969: @26115
      GIM_Try, /*On fail goto*//*Label 970*/ 26164, // Rule ID 46040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46040,
        GIR_Done,
      // Label 970: @26164
      GIM_Reject,
    // Label 968: @26165
    GIM_Reject,
    // Label 913: @26166
    GIM_Try, /*On fail goto*//*Label 971*/ 26287,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 972*/ 26237, // Rule ID 46083 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46083,
        GIR_Done,
      // Label 972: @26237
      GIM_Try, /*On fail goto*//*Label 973*/ 26286, // Rule ID 46084 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46084,
        GIR_Done,
      // Label 973: @26286
      GIM_Reject,
    // Label 971: @26287
    GIM_Reject,
    // Label 914: @26288
    GIM_Try, /*On fail goto*//*Label 974*/ 26371,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 975*/ 26340, // Rule ID 50951 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50951,
        GIR_Done,
      // Label 975: @26340
      GIM_Try, /*On fail goto*//*Label 976*/ 26370, // Rule ID 50952 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50952,
        GIR_Done,
      // Label 976: @26370
      GIM_Reject,
    // Label 974: @26371
    GIM_Reject,
    // Label 915: @26372
    GIM_Try, /*On fail goto*//*Label 977*/ 26493,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 978*/ 26443, // Rule ID 46015 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46015,
        GIR_Done,
      // Label 978: @26443
      GIM_Try, /*On fail goto*//*Label 979*/ 26492, // Rule ID 46016 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46016,
        GIR_Done,
      // Label 979: @26492
      GIM_Reject,
    // Label 977: @26493
    GIM_Reject,
    // Label 916: @26494
    GIM_Try, /*On fail goto*//*Label 980*/ 26615,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 981*/ 26565, // Rule ID 46035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46035,
        GIR_Done,
      // Label 981: @26565
      GIM_Try, /*On fail goto*//*Label 982*/ 26614, // Rule ID 46036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46036,
        GIR_Done,
      // Label 982: @26614
      GIM_Reject,
    // Label 980: @26615
    GIM_Reject,
    // Label 917: @26616
    GIM_Try, /*On fail goto*//*Label 983*/ 26737,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 984*/ 26687, // Rule ID 46071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46071,
        GIR_Done,
      // Label 984: @26687
      GIM_Try, /*On fail goto*//*Label 985*/ 26736, // Rule ID 46072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46072,
        GIR_Done,
      // Label 985: @26736
      GIM_Reject,
    // Label 983: @26737
    GIM_Reject,
    // Label 918: @26738
    GIM_Try, /*On fail goto*//*Label 986*/ 26859,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 987*/ 26809, // Rule ID 46087 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46087,
        GIR_Done,
      // Label 987: @26809
      GIM_Try, /*On fail goto*//*Label 988*/ 26858, // Rule ID 46088 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46088,
        GIR_Done,
      // Label 988: @26858
      GIM_Reject,
    // Label 986: @26859
    GIM_Reject,
    // Label 919: @26860
    GIM_Try, /*On fail goto*//*Label 989*/ 26943,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 990*/ 26912, // Rule ID 50969 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50969,
        GIR_Done,
      // Label 990: @26912
      GIM_Try, /*On fail goto*//*Label 991*/ 26942, // Rule ID 50970 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50970,
        GIR_Done,
      // Label 991: @26942
      GIM_Reject,
    // Label 989: @26943
    GIM_Reject,
    // Label 920: @26944
    GIM_Try, /*On fail goto*//*Label 992*/ 27065,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 993*/ 27015, // Rule ID 46031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46031,
        GIR_Done,
      // Label 993: @27015
      GIM_Try, /*On fail goto*//*Label 994*/ 27064, // Rule ID 46032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46032,
        GIR_Done,
      // Label 994: @27064
      GIM_Reject,
    // Label 992: @27065
    GIM_Reject,
    // Label 921: @27066
    GIM_Try, /*On fail goto*//*Label 995*/ 27187,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 996*/ 27137, // Rule ID 46059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46059,
        GIR_Done,
      // Label 996: @27137
      GIM_Try, /*On fail goto*//*Label 997*/ 27186, // Rule ID 46060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46060,
        GIR_Done,
      // Label 997: @27186
      GIM_Reject,
    // Label 995: @27187
    GIM_Reject,
    // Label 922: @27188
    GIM_Try, /*On fail goto*//*Label 998*/ 27309,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 999*/ 27259, // Rule ID 46075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46075,
        GIR_Done,
      // Label 999: @27259
      GIM_Try, /*On fail goto*//*Label 1000*/ 27308, // Rule ID 46076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46076,
        GIR_Done,
      // Label 1000: @27308
      GIM_Reject,
    // Label 998: @27309
    GIM_Reject,
    // Label 923: @27310
    GIM_Try, /*On fail goto*//*Label 1001*/ 27431,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1002*/ 27381, // Rule ID 46091 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46091,
        GIR_Done,
      // Label 1002: @27381
      GIM_Try, /*On fail goto*//*Label 1003*/ 27430, // Rule ID 46092 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46092,
        GIR_Done,
      // Label 1003: @27430
      GIM_Reject,
    // Label 1001: @27431
    GIM_Reject,
    // Label 924: @27432
    GIM_Try, /*On fail goto*//*Label 1004*/ 27515,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1005*/ 27484, // Rule ID 50987 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50987,
        GIR_Done,
      // Label 1005: @27484
      GIM_Try, /*On fail goto*//*Label 1006*/ 27514, // Rule ID 50988 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50988,
        GIR_Done,
      // Label 1006: @27514
      GIM_Reject,
    // Label 1004: @27515
    GIM_Reject,
    // Label 925: @27516
    GIM_Try, /*On fail goto*//*Label 1007*/ 27637,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1008*/ 27587, // Rule ID 46047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46047,
        GIR_Done,
      // Label 1008: @27587
      GIM_Try, /*On fail goto*//*Label 1009*/ 27636, // Rule ID 46048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46048,
        GIR_Done,
      // Label 1009: @27636
      GIM_Reject,
    // Label 1007: @27637
    GIM_Reject,
    // Label 926: @27638
    GIM_Try, /*On fail goto*//*Label 1010*/ 27759,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1011*/ 27709, // Rule ID 46063 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46063,
        GIR_Done,
      // Label 1011: @27709
      GIM_Try, /*On fail goto*//*Label 1012*/ 27758, // Rule ID 46064 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46064,
        GIR_Done,
      // Label 1012: @27758
      GIM_Reject,
    // Label 1010: @27759
    GIM_Reject,
    // Label 927: @27760
    GIM_Try, /*On fail goto*//*Label 1013*/ 27881,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1014*/ 27831, // Rule ID 46079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46079,
        GIR_Done,
      // Label 1014: @27831
      GIM_Try, /*On fail goto*//*Label 1015*/ 27880, // Rule ID 46080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46080,
        GIR_Done,
      // Label 1015: @27880
      GIM_Reject,
    // Label 1013: @27881
    GIM_Reject,
    // Label 928: @27882
    GIM_Try, /*On fail goto*//*Label 1016*/ 27965,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1017*/ 27934, // Rule ID 51005 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51005,
        GIR_Done,
      // Label 1017: @27934
      GIM_Try, /*On fail goto*//*Label 1018*/ 27964, // Rule ID 51006 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51006,
        GIR_Done,
      // Label 1018: @27964
      GIM_Reject,
    // Label 1016: @27965
    GIM_Reject,
    // Label 929: @27966
    GIM_Try, /*On fail goto*//*Label 1019*/ 28087,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1020*/ 28037, // Rule ID 46051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46051,
        GIR_Done,
      // Label 1020: @28037
      GIM_Try, /*On fail goto*//*Label 1021*/ 28086, // Rule ID 46052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46052,
        GIR_Done,
      // Label 1021: @28086
      GIM_Reject,
    // Label 1019: @28087
    GIM_Reject,
    // Label 930: @28088
    GIM_Try, /*On fail goto*//*Label 1022*/ 28209,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1023*/ 28159, // Rule ID 46067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46067,
        GIR_Done,
      // Label 1023: @28159
      GIM_Try, /*On fail goto*//*Label 1024*/ 28208, // Rule ID 46068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46068,
        GIR_Done,
      // Label 1024: @28208
      GIM_Reject,
    // Label 1022: @28209
    GIM_Reject,
    // Label 931: @28210
    GIM_Try, /*On fail goto*//*Label 1025*/ 28293,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1026*/ 28262, // Rule ID 51023 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51023,
        GIR_Done,
      // Label 1026: @28262
      GIM_Try, /*On fail goto*//*Label 1027*/ 28292, // Rule ID 51024 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51024,
        GIR_Done,
      // Label 1027: @28292
      GIM_Reject,
    // Label 1025: @28293
    GIM_Reject,
    // Label 932: @28294
    GIM_Try, /*On fail goto*//*Label 1028*/ 28415,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1029*/ 28365, // Rule ID 46055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46055,
        GIR_Done,
      // Label 1029: @28365
      GIM_Try, /*On fail goto*//*Label 1030*/ 28414, // Rule ID 46056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46056,
        GIR_Done,
      // Label 1030: @28414
      GIM_Reject,
    // Label 1028: @28415
    GIM_Reject,
    // Label 933: @28416
    GIM_Reject,
    // Label 9: @28417
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 1062*/ 32184,
    /*GILLT_s32*//*Label 1031*/ 28454,
    /*GILLT_s64*//*Label 1032*/ 28683,
    /*GILLT_nxv1s1*//*Label 1033*/ 28912,
    /*GILLT_nxv1s8*//*Label 1034*/ 28996,
    /*GILLT_nxv1s16*//*Label 1035*/ 29118,
    /*GILLT_nxv1s32*//*Label 1036*/ 29240,
    /*GILLT_nxv1s64*//*Label 1037*/ 29362,
    /*GILLT_nxv2s1*//*Label 1038*/ 29484,
    /*GILLT_nxv2s8*//*Label 1039*/ 29568,
    /*GILLT_nxv2s16*//*Label 1040*/ 29690,
    /*GILLT_nxv2s32*//*Label 1041*/ 29812,
    /*GILLT_nxv2s64*//*Label 1042*/ 29934,
    /*GILLT_nxv4s1*//*Label 1043*/ 30056,
    /*GILLT_nxv4s8*//*Label 1044*/ 30140,
    /*GILLT_nxv4s16*//*Label 1045*/ 30262,
    /*GILLT_nxv4s32*//*Label 1046*/ 30384,
    /*GILLT_nxv4s64*//*Label 1047*/ 30506,
    /*GILLT_nxv8s1*//*Label 1048*/ 30628,
    /*GILLT_nxv8s8*//*Label 1049*/ 30712,
    /*GILLT_nxv8s16*//*Label 1050*/ 30834,
    /*GILLT_nxv8s32*//*Label 1051*/ 30956,
    /*GILLT_nxv8s64*//*Label 1052*/ 31078,
    /*GILLT_nxv16s1*//*Label 1053*/ 31200,
    /*GILLT_nxv16s8*//*Label 1054*/ 31284,
    /*GILLT_nxv16s16*//*Label 1055*/ 31406,
    /*GILLT_nxv16s32*//*Label 1056*/ 31528,
    /*GILLT_nxv32s1*//*Label 1057*/ 31650,
    /*GILLT_nxv32s8*//*Label 1058*/ 31734,
    /*GILLT_nxv32s16*//*Label 1059*/ 31856,
    /*GILLT_nxv64s1*//*Label 1060*/ 31978,
    /*GILLT_nxv64s8*//*Label 1061*/ 32062,
    // Label 1031: @28454
    GIM_Try, /*On fail goto*//*Label 1063*/ 28682,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1064*/ 28521, // Rule ID 57537 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs2)  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57537,
        GIR_Done,
      // Label 1064: @28521
      GIM_Try, /*On fail goto*//*Label 1065*/ 28574, // Rule ID 57535 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57535,
        GIR_Done,
      // Label 1065: @28574
      GIM_Try, /*On fail goto*//*Label 1066*/ 28627, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 1066: @28627
      GIM_Try, /*On fail goto*//*Label 1067*/ 28664, // Rule ID 83 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 83,
        GIR_Done,
      // Label 1067: @28664
      GIM_Try, /*On fail goto*//*Label 1068*/ 28681, // Rule ID 81 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (XOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 81,
        GIR_Done,
      // Label 1068: @28681
      GIM_Reject,
    // Label 1063: @28682
    GIM_Reject,
    // Label 1032: @28683
    GIM_Try, /*On fail goto*//*Label 1069*/ 28911,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1070*/ 28750, // Rule ID 57536 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57536,
        GIR_Done,
      // Label 1070: @28750
      GIM_Try, /*On fail goto*//*Label 1071*/ 28803, // Rule ID 57534 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57534,
        GIR_Done,
      // Label 1071: @28803
      GIM_Try, /*On fail goto*//*Label 1072*/ 28856, // Rule ID 1744 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1744,
        GIR_Done,
      // Label 1072: @28856
      GIM_Try, /*On fail goto*//*Label 1073*/ 28893, // Rule ID 82 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GICXXPred_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 82,
        GIR_Done,
      // Label 1073: @28893
      GIM_Try, /*On fail goto*//*Label 1074*/ 28910, // Rule ID 80 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (XOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 80,
        GIR_Done,
      // Label 1074: @28910
      GIM_Reject,
    // Label 1069: @28911
    GIM_Reject,
    // Label 1033: @28912
    GIM_Try, /*On fail goto*//*Label 1075*/ 28995,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1076*/ 28964, // Rule ID 50917 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50917,
        GIR_Done,
      // Label 1076: @28964
      GIM_Try, /*On fail goto*//*Label 1077*/ 28994, // Rule ID 50918 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50918,
        GIR_Done,
      // Label 1077: @28994
      GIM_Reject,
    // Label 1075: @28995
    GIM_Reject,
    // Label 1034: @28996
    GIM_Try, /*On fail goto*//*Label 1078*/ 29117,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1079*/ 29067, // Rule ID 46139 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46139,
        GIR_Done,
      // Label 1079: @29067
      GIM_Try, /*On fail goto*//*Label 1080*/ 29116, // Rule ID 46140 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46140,
        GIR_Done,
      // Label 1080: @29116
      GIM_Reject,
    // Label 1078: @29117
    GIM_Reject,
    // Label 1035: @29118
    GIM_Try, /*On fail goto*//*Label 1081*/ 29239,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1082*/ 29189, // Rule ID 46151 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46151,
        GIR_Done,
      // Label 1082: @29189
      GIM_Try, /*On fail goto*//*Label 1083*/ 29238, // Rule ID 46152 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46152,
        GIR_Done,
      // Label 1083: @29238
      GIM_Reject,
    // Label 1081: @29239
    GIM_Reject,
    // Label 1036: @29240
    GIM_Try, /*On fail goto*//*Label 1084*/ 29361,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1085*/ 29311, // Rule ID 46159 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46159,
        GIR_Done,
      // Label 1085: @29311
      GIM_Try, /*On fail goto*//*Label 1086*/ 29360, // Rule ID 46160 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46160,
        GIR_Done,
      // Label 1086: @29360
      GIM_Reject,
    // Label 1084: @29361
    GIM_Reject,
    // Label 1037: @29362
    GIM_Try, /*On fail goto*//*Label 1087*/ 29483,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1088*/ 29433, // Rule ID 46175 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46175,
        GIR_Done,
      // Label 1088: @29433
      GIM_Try, /*On fail goto*//*Label 1089*/ 29482, // Rule ID 46176 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46176,
        GIR_Done,
      // Label 1089: @29482
      GIM_Reject,
    // Label 1087: @29483
    GIM_Reject,
    // Label 1038: @29484
    GIM_Try, /*On fail goto*//*Label 1090*/ 29567,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1091*/ 29536, // Rule ID 50935 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50935,
        GIR_Done,
      // Label 1091: @29536
      GIM_Try, /*On fail goto*//*Label 1092*/ 29566, // Rule ID 50936 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50936,
        GIR_Done,
      // Label 1092: @29566
      GIM_Reject,
    // Label 1090: @29567
    GIM_Reject,
    // Label 1039: @29568
    GIM_Try, /*On fail goto*//*Label 1093*/ 29689,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1094*/ 29639, // Rule ID 46143 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46143,
        GIR_Done,
      // Label 1094: @29639
      GIM_Try, /*On fail goto*//*Label 1095*/ 29688, // Rule ID 46144 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46144,
        GIR_Done,
      // Label 1095: @29688
      GIM_Reject,
    // Label 1093: @29689
    GIM_Reject,
    // Label 1040: @29690
    GIM_Try, /*On fail goto*//*Label 1096*/ 29811,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1097*/ 29761, // Rule ID 46155 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46155,
        GIR_Done,
      // Label 1097: @29761
      GIM_Try, /*On fail goto*//*Label 1098*/ 29810, // Rule ID 46156 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46156,
        GIR_Done,
      // Label 1098: @29810
      GIM_Reject,
    // Label 1096: @29811
    GIM_Reject,
    // Label 1041: @29812
    GIM_Try, /*On fail goto*//*Label 1099*/ 29933,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1100*/ 29883, // Rule ID 46171 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46171,
        GIR_Done,
      // Label 1100: @29883
      GIM_Try, /*On fail goto*//*Label 1101*/ 29932, // Rule ID 46172 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46172,
        GIR_Done,
      // Label 1101: @29932
      GIM_Reject,
    // Label 1099: @29933
    GIM_Reject,
    // Label 1042: @29934
    GIM_Try, /*On fail goto*//*Label 1102*/ 30055,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1103*/ 30005, // Rule ID 46215 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46215,
        GIR_Done,
      // Label 1103: @30005
      GIM_Try, /*On fail goto*//*Label 1104*/ 30054, // Rule ID 46216 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46216,
        GIR_Done,
      // Label 1104: @30054
      GIM_Reject,
    // Label 1102: @30055
    GIM_Reject,
    // Label 1043: @30056
    GIM_Try, /*On fail goto*//*Label 1105*/ 30139,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1106*/ 30108, // Rule ID 50953 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50953,
        GIR_Done,
      // Label 1106: @30108
      GIM_Try, /*On fail goto*//*Label 1107*/ 30138, // Rule ID 50954 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50954,
        GIR_Done,
      // Label 1107: @30138
      GIM_Reject,
    // Label 1105: @30139
    GIM_Reject,
    // Label 1044: @30140
    GIM_Try, /*On fail goto*//*Label 1108*/ 30261,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1109*/ 30211, // Rule ID 46147 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46147,
        GIR_Done,
      // Label 1109: @30211
      GIM_Try, /*On fail goto*//*Label 1110*/ 30260, // Rule ID 46148 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46148,
        GIR_Done,
      // Label 1110: @30260
      GIM_Reject,
    // Label 1108: @30261
    GIM_Reject,
    // Label 1045: @30262
    GIM_Try, /*On fail goto*//*Label 1111*/ 30383,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1112*/ 30333, // Rule ID 46167 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46167,
        GIR_Done,
      // Label 1112: @30333
      GIM_Try, /*On fail goto*//*Label 1113*/ 30382, // Rule ID 46168 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46168,
        GIR_Done,
      // Label 1113: @30382
      GIM_Reject,
    // Label 1111: @30383
    GIM_Reject,
    // Label 1046: @30384
    GIM_Try, /*On fail goto*//*Label 1114*/ 30505,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1115*/ 30455, // Rule ID 46203 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46203,
        GIR_Done,
      // Label 1115: @30455
      GIM_Try, /*On fail goto*//*Label 1116*/ 30504, // Rule ID 46204 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46204,
        GIR_Done,
      // Label 1116: @30504
      GIM_Reject,
    // Label 1114: @30505
    GIM_Reject,
    // Label 1047: @30506
    GIM_Try, /*On fail goto*//*Label 1117*/ 30627,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1118*/ 30577, // Rule ID 46219 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46219,
        GIR_Done,
      // Label 1118: @30577
      GIM_Try, /*On fail goto*//*Label 1119*/ 30626, // Rule ID 46220 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46220,
        GIR_Done,
      // Label 1119: @30626
      GIM_Reject,
    // Label 1117: @30627
    GIM_Reject,
    // Label 1048: @30628
    GIM_Try, /*On fail goto*//*Label 1120*/ 30711,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1121*/ 30680, // Rule ID 50971 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50971,
        GIR_Done,
      // Label 1121: @30680
      GIM_Try, /*On fail goto*//*Label 1122*/ 30710, // Rule ID 50972 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50972,
        GIR_Done,
      // Label 1122: @30710
      GIM_Reject,
    // Label 1120: @30711
    GIM_Reject,
    // Label 1049: @30712
    GIM_Try, /*On fail goto*//*Label 1123*/ 30833,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1124*/ 30783, // Rule ID 46163 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46163,
        GIR_Done,
      // Label 1124: @30783
      GIM_Try, /*On fail goto*//*Label 1125*/ 30832, // Rule ID 46164 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46164,
        GIR_Done,
      // Label 1125: @30832
      GIM_Reject,
    // Label 1123: @30833
    GIM_Reject,
    // Label 1050: @30834
    GIM_Try, /*On fail goto*//*Label 1126*/ 30955,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1127*/ 30905, // Rule ID 46191 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46191,
        GIR_Done,
      // Label 1127: @30905
      GIM_Try, /*On fail goto*//*Label 1128*/ 30954, // Rule ID 46192 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46192,
        GIR_Done,
      // Label 1128: @30954
      GIM_Reject,
    // Label 1126: @30955
    GIM_Reject,
    // Label 1051: @30956
    GIM_Try, /*On fail goto*//*Label 1129*/ 31077,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1130*/ 31027, // Rule ID 46207 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46207,
        GIR_Done,
      // Label 1130: @31027
      GIM_Try, /*On fail goto*//*Label 1131*/ 31076, // Rule ID 46208 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46208,
        GIR_Done,
      // Label 1131: @31076
      GIM_Reject,
    // Label 1129: @31077
    GIM_Reject,
    // Label 1052: @31078
    GIM_Try, /*On fail goto*//*Label 1132*/ 31199,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1133*/ 31149, // Rule ID 46223 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46223,
        GIR_Done,
      // Label 1133: @31149
      GIM_Try, /*On fail goto*//*Label 1134*/ 31198, // Rule ID 46224 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46224,
        GIR_Done,
      // Label 1134: @31198
      GIM_Reject,
    // Label 1132: @31199
    GIM_Reject,
    // Label 1053: @31200
    GIM_Try, /*On fail goto*//*Label 1135*/ 31283,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1136*/ 31252, // Rule ID 50989 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50989,
        GIR_Done,
      // Label 1136: @31252
      GIM_Try, /*On fail goto*//*Label 1137*/ 31282, // Rule ID 50990 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50990,
        GIR_Done,
      // Label 1137: @31282
      GIM_Reject,
    // Label 1135: @31283
    GIM_Reject,
    // Label 1054: @31284
    GIM_Try, /*On fail goto*//*Label 1138*/ 31405,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1139*/ 31355, // Rule ID 46179 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46179,
        GIR_Done,
      // Label 1139: @31355
      GIM_Try, /*On fail goto*//*Label 1140*/ 31404, // Rule ID 46180 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46180,
        GIR_Done,
      // Label 1140: @31404
      GIM_Reject,
    // Label 1138: @31405
    GIM_Reject,
    // Label 1055: @31406
    GIM_Try, /*On fail goto*//*Label 1141*/ 31527,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1142*/ 31477, // Rule ID 46195 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46195,
        GIR_Done,
      // Label 1142: @31477
      GIM_Try, /*On fail goto*//*Label 1143*/ 31526, // Rule ID 46196 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46196,
        GIR_Done,
      // Label 1143: @31526
      GIM_Reject,
    // Label 1141: @31527
    GIM_Reject,
    // Label 1056: @31528
    GIM_Try, /*On fail goto*//*Label 1144*/ 31649,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1145*/ 31599, // Rule ID 46211 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46211,
        GIR_Done,
      // Label 1145: @31599
      GIM_Try, /*On fail goto*//*Label 1146*/ 31648, // Rule ID 46212 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46212,
        GIR_Done,
      // Label 1146: @31648
      GIM_Reject,
    // Label 1144: @31649
    GIM_Reject,
    // Label 1057: @31650
    GIM_Try, /*On fail goto*//*Label 1147*/ 31733,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1148*/ 31702, // Rule ID 51007 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51007,
        GIR_Done,
      // Label 1148: @31702
      GIM_Try, /*On fail goto*//*Label 1149*/ 31732, // Rule ID 51008 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51008,
        GIR_Done,
      // Label 1149: @31732
      GIM_Reject,
    // Label 1147: @31733
    GIM_Reject,
    // Label 1058: @31734
    GIM_Try, /*On fail goto*//*Label 1150*/ 31855,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1151*/ 31805, // Rule ID 46183 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46183,
        GIR_Done,
      // Label 1151: @31805
      GIM_Try, /*On fail goto*//*Label 1152*/ 31854, // Rule ID 46184 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46184,
        GIR_Done,
      // Label 1152: @31854
      GIM_Reject,
    // Label 1150: @31855
    GIM_Reject,
    // Label 1059: @31856
    GIM_Try, /*On fail goto*//*Label 1153*/ 31977,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1154*/ 31927, // Rule ID 46199 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46199,
        GIR_Done,
      // Label 1154: @31927
      GIM_Try, /*On fail goto*//*Label 1155*/ 31976, // Rule ID 46200 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46200,
        GIR_Done,
      // Label 1155: @31976
      GIM_Reject,
    // Label 1153: @31977
    GIM_Reject,
    // Label 1060: @31978
    GIM_Try, /*On fail goto*//*Label 1156*/ 32061,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1157*/ 32030, // Rule ID 51025 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51025,
        GIR_Done,
      // Label 1157: @32030
      GIM_Try, /*On fail goto*//*Label 1158*/ 32060, // Rule ID 51026 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51026,
        GIR_Done,
      // Label 1158: @32060
      GIM_Reject,
    // Label 1156: @32061
    GIM_Reject,
    // Label 1061: @32062
    GIM_Try, /*On fail goto*//*Label 1159*/ 32183,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1160*/ 32133, // Rule ID 46187 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46187,
        GIR_Done,
      // Label 1160: @32133
      GIM_Try, /*On fail goto*//*Label 1161*/ 32182, // Rule ID 46188 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46188,
        GIR_Done,
      // Label 1161: @32182
      GIM_Reject,
    // Label 1159: @32183
    GIM_Reject,
    // Label 1062: @32184
    GIM_Reject,
    // Label 10: @32185
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1164*/ 32428,
    /*GILLT_s32*//*Label 1162*/ 32193,
    /*GILLT_s64*//*Label 1163*/ 32340,
    // Label 1162: @32193
    GIM_Try, /*On fail goto*//*Label 1165*/ 32339,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1166*/ 32218, // Rule ID 693 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (FMV_W_X:{ *:[f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_W_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 693,
        GIR_Done,
      // Label 1166: @32218
      GIM_Try, /*On fail goto*//*Label 1167*/ 32237, // Rule ID 694 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (FMV_W_X:{ *:[f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_W_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 1167: @32237
      GIM_Try, /*On fail goto*//*Label 1168*/ 32256, // Rule ID 695 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FMV_X_W:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 1168: @32256
      GIM_Try, /*On fail goto*//*Label 1169*/ 32275, // Rule ID 696 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FMV_X_W:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 1169: @32275
      GIM_Try, /*On fail goto*//*Label 1170*/ 32296, // Rule ID 697 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRF32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (COPY_TO_REGCLASS:{ *:[f32] } GPR:{ *:[i32] }:$rs1, GPRF32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRF32RegClassID,
        // GIR_Coverage, 697,
        GIR_Done,
      // Label 1170: @32296
      GIM_Try, /*On fail goto*//*Label 1171*/ 32317, // Rule ID 698 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRF32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (COPY_TO_REGCLASS:{ *:[f32] } GPR:{ *:[i32] }:$rs1, GPRF32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRF32RegClassID,
        // GIR_Coverage, 698,
        GIR_Done,
      // Label 1171: @32317
      GIM_Try, /*On fail goto*//*Label 1172*/ 32338, // Rule ID 699 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32INX:{ *:[f32] }:$rs1)  =>  (COPY_TO_REGCLASS:{ *:[i32] } FPR32INX:{ *:[f32] }:$rs1, GPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRRegClassID,
        // GIR_Coverage, 699,
        GIR_Done,
      // Label 1172: @32338
      GIM_Reject,
    // Label 1165: @32339
    GIM_Reject,
    // Label 1163: @32340
    GIM_Try, /*On fail goto*//*Label 1173*/ 32427,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1174*/ 32365, // Rule ID 1128 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f64] } GPR:{ *:[i64] }:$rs1)  =>  (FMV_D_X:{ *:[f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_D_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1128,
        GIR_Done,
      // Label 1174: @32365
      GIM_Try, /*On fail goto*//*Label 1175*/ 32384, // Rule ID 1129 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
        // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)  =>  (FMV_X_D:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1129,
        GIR_Done,
      // Label 1175: @32384
      GIM_Try, /*On fail goto*//*Label 1176*/ 32405, // Rule ID 1156 //
        GIM_CheckFeatures, GIFBS_HasStdExtZdinx_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f64] } GPR:{ *:[i64] }:$rs1)  =>  (COPY_TO_REGCLASS:{ *:[f64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRRegClassID,
        // GIR_Coverage, 1156,
        GIR_Done,
      // Label 1176: @32405
      GIM_Try, /*On fail goto*//*Label 1177*/ 32426, // Rule ID 1157 //
        GIM_CheckFeatures, GIFBS_HasStdExtZdinx_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[i64] } GPR:{ *:[f64] }:$rs1)  =>  (COPY_TO_REGCLASS:{ *:[i64] } GPR:{ *:[f64] }:$rs1, GPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRRegClassID,
        // GIR_Coverage, 1157,
        GIR_Done,
      // Label 1177: @32426
      GIM_Reject,
    // Label 1173: @32427
    GIM_Reject,
    // Label 1164: @32428
    GIM_Reject,
    // Label 11: @32429
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 3, /*)*//*default:*//*Label 1181*/ 32624,
    /*GILLT_s16*//*Label 1178*/ 32438,
    /*GILLT_s32*//*Label 1179*/ 32500,
    /*GILLT_s64*//*Label 1180*/ 32562,
    // Label 1178: @32438
    GIM_Try, /*On fail goto*//*Label 1182*/ 32499,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      GIM_Try, /*On fail goto*//*Label 1183*/ 32475, // Rule ID 1730 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa_HasStdExtZfh,
        // (ftrunc:{ *:[f16] } FPR16:{ *:[f16] }:$rs1)  =>  (FROUND_H:{ *:[f16] } FPR16:{ *:[f16] }:$rs1, 1:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1730,
        GIR_Done,
      // Label 1183: @32475
      GIM_Try, /*On fail goto*//*Label 1184*/ 32498, // Rule ID 1731 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa_HasStdExtZfh,
        // (ftrunc:{ *:[f16] } FPR16:{ *:[f16] }:$rs1)  =>  (FROUND_H:{ *:[f16] } FPR16:{ *:[f16] }:$rs1, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1731,
        GIR_Done,
      // Label 1184: @32498
      GIM_Reject,
    // Label 1182: @32499
    GIM_Reject,
    // Label 1179: @32500
    GIM_Try, /*On fail goto*//*Label 1185*/ 32561,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 1186*/ 32537, // Rule ID 1652 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa,
        // (ftrunc:{ *:[f32] } FPR32:{ *:[f32] }:$rs1)  =>  (FROUND_S:{ *:[f32] } FPR32:{ *:[f32] }:$rs1, 1:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1652,
        GIR_Done,
      // Label 1186: @32537
      GIM_Try, /*On fail goto*//*Label 1187*/ 32560, // Rule ID 1653 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa,
        // (ftrunc:{ *:[f32] } FPR32:{ *:[f32] }:$rs1)  =>  (FROUND_S:{ *:[f32] } FPR32:{ *:[f32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1653,
        GIR_Done,
      // Label 1187: @32560
      GIM_Reject,
    // Label 1185: @32561
    GIM_Reject,
    // Label 1180: @32562
    GIM_Try, /*On fail goto*//*Label 1188*/ 32623,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 1189*/ 32599, // Rule ID 1690 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_HasStdExtZfa,
        // (ftrunc:{ *:[f64] } FPR64:{ *:[f64] }:$rs1)  =>  (FROUND_D:{ *:[f64] } FPR64:{ *:[f64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1690,
        GIR_Done,
      // Label 1189: @32599
      GIM_Try, /*On fail goto*//*Label 1190*/ 32622, // Rule ID 1691 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_HasStdExtZfa,
        // (ftrunc:{ *:[f64] } FPR64:{ *:[f64] }:$rs1)  =>  (FROUND_D:{ *:[f64] } FPR64:{ *:[f64] }:$rs1, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1691,
        GIR_Done,
      // Label 1190: @32622
      GIM_Reject,
    // Label 1188: @32623
    GIM_Reject,
    // Label 1181: @32624
    GIM_Reject,
    // Label 12: @32625
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 3, /*)*//*default:*//*Label 1194*/ 32820,
    /*GILLT_s16*//*Label 1191*/ 32634,
    /*GILLT_s32*//*Label 1192*/ 32696,
    /*GILLT_s64*//*Label 1193*/ 32758,
    // Label 1191: @32634
    GIM_Try, /*On fail goto*//*Label 1195*/ 32695,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      GIM_Try, /*On fail goto*//*Label 1196*/ 32671, // Rule ID 1714 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa_HasStdExtZfh,
        // (fround:{ *:[f16] } FPR16:{ *:[f16] }:$rs1)  =>  (FROUND_H:{ *:[f16] } FPR16:{ *:[f16] }:$rs1, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1714,
        GIR_Done,
      // Label 1196: @32671
      GIM_Try, /*On fail goto*//*Label 1197*/ 32694, // Rule ID 1715 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa_HasStdExtZfh,
        // (fround:{ *:[f16] } FPR16:{ *:[f16] }:$rs1)  =>  (FROUND_H:{ *:[f16] } FPR16:{ *:[f16] }:$rs1, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1715,
        GIR_Done,
      // Label 1197: @32694
      GIM_Reject,
    // Label 1195: @32695
    GIM_Reject,
    // Label 1192: @32696
    GIM_Try, /*On fail goto*//*Label 1198*/ 32757,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 1199*/ 32733, // Rule ID 1640 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa,
        // (fround:{ *:[f32] } FPR32:{ *:[f32] }:$rs1)  =>  (FROUND_S:{ *:[f32] } FPR32:{ *:[f32] }:$rs1, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 1199: @32733
      GIM_Try, /*On fail goto*//*Label 1200*/ 32756, // Rule ID 1641 //
        GIM_CheckFeatures, GIFBS_HasStdExtZfa,
        // (fround:{ *:[f32] } FPR32:{ *:[f32] }:$rs1)  =>  (FROUND_S:{ *:[f32] } FPR32:{ *:[f32] }:$rs1, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 1200: @32756
      GIM_Reject,
    // Label 1198: @32757
    GIM_Reject,
    // Label 1193: @32758
    GIM_Try, /*On fail goto*//*Label 1201*/ 32819,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 1202*/ 32795, // Rule ID 1674 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_HasStdExtZfa,
        // (fround:{ *:[f64] } FPR64:{ *:[f64] }:$rs1)  =>  (FROUND_D:{ *:[f64] } FPR64:{ *:[f64] }:$rs1, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1674,
        GIR_Done,
      // Label 1202: @32795
      GIM_Try, /*On fail goto*//*Label 1203*/ 32818, // Rule ID 1675 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_HasStdExtZfa,
        // (fround:{ *:[f64] } FPR64:{ *:[f64] }:$rs1)  =>  (FROUND_D:{ *:[f64] } FPR64:{ *:[f64] }:$rs1, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FROUND_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1675,
        GIR_Done,
      // Label 1203: @32818
      GIM_Reject,
    // Label 1201: @32819
    GIM_Reject,
    // Label 1194: @32820
    GIM_Reject,
    // Label 13: @32821
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1206*/ 33767,
    /*GILLT_s32*//*Label 1204*/ 32829,
    /*GILLT_s64*//*Label 1205*/ 33454,
    // Label 1204: @32829
    GIM_Try, /*On fail goto*//*Label 1207*/ 32864, // Rule ID 712 //
      GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
      // (lrint:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FCVT_W_S:{ *:[i32] } ?:{ *:[f32] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 712,
      GIR_Done,
    // Label 1207: @32864
    GIM_Try, /*On fail goto*//*Label 1208*/ 32899, // Rule ID 713 //
      GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
      // (lrint:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FCVT_W_S:{ *:[i32] } ?:{ *:[f32] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 713,
      GIR_Done,
    // Label 1208: @32899
    GIM_Try, /*On fail goto*//*Label 1209*/ 32934, // Rule ID 738 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF32RegClassID,
      // (lrint:{ *:[i32] } FPR32INX:{ *:[f32] }:$rs1)  =>  (FCVT_W_S_INX:{ *:[i32] } ?:{ *:[f32] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 738,
      GIR_Done,
    // Label 1209: @32934
    GIM_Try, /*On fail goto*//*Label 1210*/ 32969, // Rule ID 739 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF32RegClassID,
      // (lrint:{ *:[i32] } FPR32INX:{ *:[f32] }:$rs1)  =>  (FCVT_W_S_INX:{ *:[i32] } ?:{ *:[f32] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 739,
      GIR_Done,
    // Label 1210: @32969
    GIM_Try, /*On fail goto*//*Label 1211*/ 33004, // Rule ID 1088 //
      GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
      // (lrint:{ *:[i32] } FPR64:{ *:[f64] }:$rs1)  =>  (FCVT_W_D:{ *:[i32] } ?:{ *:[f64] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_D,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1088,
      GIR_Done,
    // Label 1211: @33004
    GIM_Try, /*On fail goto*//*Label 1212*/ 33039, // Rule ID 1089 //
      GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
      // (lrint:{ *:[i32] } FPR64:{ *:[f64] }:$rs1)  =>  (FCVT_W_D:{ *:[i32] } ?:{ *:[f64] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_D,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1089,
      GIR_Done,
    // Label 1212: @33039
    GIM_Try, /*On fail goto*//*Label 1213*/ 33074, // Rule ID 1114 //
      GIM_CheckFeatures, GIFBS_HasStdExtZdinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRPF64RegClassID,
      // (lrint:{ *:[i32] } FPR64IN32X:{ *:[f64] }:$rs1)  =>  (FCVT_W_D_IN32X:{ *:[i32] } ?:{ *:[f64] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_D_IN32X,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1114,
      GIR_Done,
    // Label 1213: @33074
    GIM_Try, /*On fail goto*//*Label 1214*/ 33109, // Rule ID 1115 //
      GIM_CheckFeatures, GIFBS_HasStdExtZdinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRPF64RegClassID,
      // (lrint:{ *:[i32] } FPR64IN32X:{ *:[f64] }:$rs1)  =>  (FCVT_W_D_IN32X:{ *:[i32] } ?:{ *:[f64] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_D_IN32X,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1115,
      GIR_Done,
    // Label 1214: @33109
    GIM_Try, /*On fail goto*//*Label 1215*/ 33144, // Rule ID 1418 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfh_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i32] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_W_H:{ *:[i32] } ?:{ *:[f16] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_H,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1418,
      GIR_Done,
    // Label 1215: @33144
    GIM_Try, /*On fail goto*//*Label 1216*/ 33179, // Rule ID 1419 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfh_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i32] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_W_H:{ *:[i32] } ?:{ *:[f16] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_H,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1419,
      GIR_Done,
    // Label 1216: @33179
    GIM_Try, /*On fail goto*//*Label 1217*/ 33214, // Rule ID 1444 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i32] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_W_H_INX:{ *:[i32] } ?:{ *:[f16] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_H_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1444,
      GIR_Done,
    // Label 1217: @33214
    GIM_Try, /*On fail goto*//*Label 1218*/ 33249, // Rule ID 1445 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinx_IsRV32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i32] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_W_H_INX:{ *:[i32] } ?:{ *:[f16] }:$rs1, 7:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_H_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1445,
      GIR_Done,
    // Label 1218: @33249
    GIM_Try, /*On fail goto*//*Label 1219*/ 33300, // Rule ID 1544 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfhmin_IsRV32_NoStdExtZfh,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i32] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_W_S:{ *:[i32] } (FCVT_S_H:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i64] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1544,
      GIR_Done,
    // Label 1219: @33300
    GIM_Try, /*On fail goto*//*Label 1220*/ 33351, // Rule ID 1545 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfhmin_IsRV32_NoStdExtZfh,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i32] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_W_S:{ *:[i32] } (FCVT_S_H:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1545,
      GIR_Done,
    // Label 1220: @33351
    GIM_Try, /*On fail goto*//*Label 1221*/ 33402, // Rule ID 1568 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinxmin_IsRV32_NoStdExtZhinx,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i32] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_W_S_INX:{ *:[i32] } (FCVT_S_H_INX:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i64] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H_INX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1568,
      GIR_Done,
    // Label 1221: @33402
    GIM_Try, /*On fail goto*//*Label 1222*/ 33453, // Rule ID 1569 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinxmin_IsRV32_NoStdExtZhinx,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i32] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_W_S_INX:{ *:[i32] } (FCVT_S_H_INX:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H_INX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_W_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1569,
      GIR_Done,
    // Label 1222: @33453
    GIM_Reject,
    // Label 1205: @33454
    GIM_Try, /*On fail goto*//*Label 1223*/ 33489, // Rule ID 765 //
      GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
      // (lrint:{ *:[i64] } FPR32:{ *:[f32] }:$rs1)  =>  (FCVT_L_S:{ *:[i64] } ?:{ *:[f32] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 765,
      GIR_Done,
    // Label 1223: @33489
    GIM_Try, /*On fail goto*//*Label 1224*/ 33524, // Rule ID 793 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfinx_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF32RegClassID,
      // (lrint:{ *:[i64] } FPR32INX:{ *:[f32] }:$rs1)  =>  (FCVT_L_S_INX:{ *:[i64] } ?:{ *:[f32] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 793,
      GIR_Done,
    // Label 1224: @33524
    GIM_Try, /*On fail goto*//*Label 1225*/ 33559, // Rule ID 1145 //
      GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
      // (lrint:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)  =>  (FCVT_L_D:{ *:[i64] } ?:{ *:[f64] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_D,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1145,
      GIR_Done,
    // Label 1225: @33559
    GIM_Try, /*On fail goto*//*Label 1226*/ 33594, // Rule ID 1173 //
      GIM_CheckFeatures, GIFBS_HasStdExtZdinx_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (lrint:{ *:[i64] } FPR64INX:{ *:[f64] }:$rs1)  =>  (FCVT_L_D_INX:{ *:[i64] } ?:{ *:[f64] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_D_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1173,
      GIR_Done,
    // Label 1226: @33594
    GIM_Try, /*On fail goto*//*Label 1227*/ 33629, // Rule ID 1469 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfh_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i64] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_L_H:{ *:[i64] } ?:{ *:[f16] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_H,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1469,
      GIR_Done,
    // Label 1227: @33629
    GIM_Try, /*On fail goto*//*Label 1228*/ 33664, // Rule ID 1495 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinx_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i64] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_L_H_INX:{ *:[i64] } ?:{ *:[f16] }:$rs1, 7:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_H_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1495,
      GIR_Done,
    // Label 1228: @33664
    GIM_Try, /*On fail goto*//*Label 1229*/ 33715, // Rule ID 1587 //
      GIM_CheckFeatures, GIFBS_HasStdExtZfhmin_IsRV64_NoStdExtZfh,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR16RegClassID,
      // (lrint:{ *:[i64] } FPR16:{ *:[f16] }:$rs1)  =>  (FCVT_L_S:{ *:[i64] } (FCVT_S_H:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i64] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1587,
      GIR_Done,
    // Label 1229: @33715
    GIM_Try, /*On fail goto*//*Label 1230*/ 33766, // Rule ID 1603 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinxmin_IsRV64_NoStdExtZhinx,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRF16RegClassID,
      // (lrint:{ *:[i64] } FPR16INX:{ *:[f16] }:$rs1)  =>  (FCVT_L_S_INX:{ *:[i64] } (FCVT_S_H_INX:{ *:[f32] } ?:{ *:[f16] }:$rs1), 7:{ *:[i64] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::FCVT_S_H_INX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FCVT_L_S_INX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/7,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 1230: @33766
    GIM_Reject,
    // Label 1206: @33767
    GIM_Reject,
    // Label 14: @33768
    GIM_Try, /*On fail goto*//*Label 1231*/ 33799, // Rule ID 259 //
      GIM_CheckFeatures, GIFBS_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (CSRRS:{ *:[i64] } 3072:{ *:[i64] }, X0:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CSRRS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddImm, /*InsnID*/0, /*Imm*/3072,
      GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 259,
      GIR_Done,
    // Label 1231: @33799
    GIM_Reject,
    // Label 15: @33800
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 32, /*)*//*default:*//*Label 1262*/ 35620,
    /*GILLT_s16*//*Label 1232*/ 33838, 0, 0,
    /*GILLT_nxv1s1*//*Label 1233*/ 33903,
    /*GILLT_nxv1s8*//*Label 1234*/ 33972,
    /*GILLT_nxv1s16*//*Label 1235*/ 34041,
    /*GILLT_nxv1s32*//*Label 1236*/ 34162,
    /*GILLT_nxv1s64*//*Label 1237*/ 34283,
    /*GILLT_nxv2s1*//*Label 1238*/ 34328,
    /*GILLT_nxv2s8*//*Label 1239*/ 34397,
    /*GILLT_nxv2s16*//*Label 1240*/ 34466,
    /*GILLT_nxv2s32*//*Label 1241*/ 34587,
    /*GILLT_nxv2s64*//*Label 1242*/ 34632,
    /*GILLT_nxv4s1*//*Label 1243*/ 34677,
    /*GILLT_nxv4s8*//*Label 1244*/ 34746,
    /*GILLT_nxv4s16*//*Label 1245*/ 34815,
    /*GILLT_nxv4s32*//*Label 1246*/ 34860,
    /*GILLT_nxv4s64*//*Label 1247*/ 34905,
    /*GILLT_nxv8s1*//*Label 1248*/ 34950,
    /*GILLT_nxv8s8*//*Label 1249*/ 35019,
    /*GILLT_nxv8s16*//*Label 1250*/ 35050,
    /*GILLT_nxv8s32*//*Label 1251*/ 35095,
    /*GILLT_nxv8s64*//*Label 1252*/ 35140,
    /*GILLT_nxv16s1*//*Label 1253*/ 35185,
    /*GILLT_nxv16s8*//*Label 1254*/ 35254,
    /*GILLT_nxv16s16*//*Label 1255*/ 35285,
    /*GILLT_nxv16s32*//*Label 1256*/ 35330,
    /*GILLT_nxv32s1*//*Label 1257*/ 35375,
    /*GILLT_nxv32s8*//*Label 1258*/ 35444,
    /*GILLT_nxv32s16*//*Label 1259*/ 35475,
    /*GILLT_nxv64s1*//*Label 1260*/ 35520,
    /*GILLT_nxv64s8*//*Label 1261*/ 35589,
    // Label 1232: @33838
    GIM_Try, /*On fail goto*//*Label 1263*/ 33902, // Rule ID 1377 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinxOrZhinxmin,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRF16RegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (COPY_TO_REGCLASS:{ *:[f16] } (LH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 0:{ *:[i32] }), GPRF16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::LH,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, RISCV::GPRF16RegClassID,
      // GIR_Coverage, 1377,
      GIR_Done,
    // Label 1263: @33902
    GIM_Reject,
    // Label 1233: @33903
    GIM_Try, /*On fail goto*//*Label 1264*/ 33971, // Rule ID 44308 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv1i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B1:{ *:[nxv1i1] } (IMPLICIT_DEF:{ *:[nxv1i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B1,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44308,
      GIR_Done,
    // Label 1264: @33971
    GIM_Reject,
    // Label 1234: @33972
    GIM_Try, /*On fail goto*//*Label 1265*/ 34040, // Rule ID 44300 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv1i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44300,
      GIR_Done,
    // Label 1265: @34040
    GIM_Reject,
    // Label 1235: @34041
    GIM_Try, /*On fail goto*//*Label 1266*/ 34161,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1267*/ 34111, // Rule ID 44450 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv1i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44450,
        GIR_Done,
      // Label 1267: @34111
      GIM_Try, /*On fail goto*//*Label 1268*/ 34160, // Rule ID 44462 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv1f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1f16] } (IMPLICIT_DEF:{ *:[nxv1f16] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44462,
        GIR_Done,
      // Label 1268: @34160
      GIM_Reject,
    // Label 1266: @34161
    GIM_Reject,
    // Label 1236: @34162
    GIM_Try, /*On fail goto*//*Label 1269*/ 34282,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1270*/ 34232, // Rule ID 44458 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv1i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44458,
        GIR_Done,
      // Label 1270: @34232
      GIM_Try, /*On fail goto*//*Label 1271*/ 34281, // Rule ID 44470 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (ld:{ *:[nxv1f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1f32] } (IMPLICIT_DEF:{ *:[nxv1f32] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44470,
        GIR_Done,
      // Label 1271: @34281
      GIM_Reject,
    // Label 1269: @34282
    GIM_Reject,
    // Label 1237: @34283
    GIM_Try, /*On fail goto*//*Label 1272*/ 34327,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1273*/ 34315, // Rule ID 44482 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (ld:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44482,
        GIR_Done,
      // Label 1273: @34315
      GIM_Try, /*On fail goto*//*Label 1274*/ 34326, // Rule ID 44494 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (ld:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44494,
        GIR_Done,
      // Label 1274: @34326
      GIM_Reject,
    // Label 1272: @34327
    GIM_Reject,
    // Label 1238: @34328
    GIM_Try, /*On fail goto*//*Label 1275*/ 34396, // Rule ID 44582 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv2i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B2:{ *:[nxv2i1] } (IMPLICIT_DEF:{ *:[nxv2i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44582,
      GIR_Done,
    // Label 1275: @34396
    GIM_Reject,
    // Label 1239: @34397
    GIM_Try, /*On fail goto*//*Label 1276*/ 34465, // Rule ID 44442 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv2i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF4,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44442,
      GIR_Done,
    // Label 1276: @34465
    GIM_Reject,
    // Label 1240: @34466
    GIM_Try, /*On fail goto*//*Label 1277*/ 34586,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1278*/ 34536, // Rule ID 44454 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv2i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44454,
        GIR_Done,
      // Label 1278: @34536
      GIM_Try, /*On fail goto*//*Label 1279*/ 34585, // Rule ID 44466 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv2f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2f16] } (IMPLICIT_DEF:{ *:[nxv2f16] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44466,
        GIR_Done,
      // Label 1279: @34585
      GIM_Reject,
    // Label 1277: @34586
    GIM_Reject,
    // Label 1241: @34587
    GIM_Try, /*On fail goto*//*Label 1280*/ 34631,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1281*/ 34619, // Rule ID 44478 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44478,
        GIR_Done,
      // Label 1281: @34619
      GIM_Try, /*On fail goto*//*Label 1282*/ 34630, // Rule ID 44490 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (ld:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44490,
        GIR_Done,
      // Label 1282: @34630
      GIM_Reject,
    // Label 1280: @34631
    GIM_Reject,
    // Label 1242: @34632
    GIM_Try, /*On fail goto*//*Label 1283*/ 34676,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1284*/ 34664, // Rule ID 44534 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (ld:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44534,
        GIR_Done,
      // Label 1284: @34664
      GIM_Try, /*On fail goto*//*Label 1285*/ 34675, // Rule ID 44570 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (ld:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44570,
        GIR_Done,
      // Label 1285: @34675
      GIM_Reject,
    // Label 1283: @34676
    GIM_Reject,
    // Label 1243: @34677
    GIM_Try, /*On fail goto*//*Label 1286*/ 34745, // Rule ID 44586 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv4i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B4:{ *:[nxv4i1] } (IMPLICIT_DEF:{ *:[nxv4i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B4,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44586,
      GIR_Done,
    // Label 1286: @34745
    GIM_Reject,
    // Label 1244: @34746
    GIM_Try, /*On fail goto*//*Label 1287*/ 34814, // Rule ID 44446 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv4i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44446,
      GIR_Done,
    // Label 1287: @34814
    GIM_Reject,
    // Label 1245: @34815
    GIM_Try, /*On fail goto*//*Label 1288*/ 34859,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1289*/ 34847, // Rule ID 44474 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44474,
        GIR_Done,
      // Label 1289: @34847
      GIM_Try, /*On fail goto*//*Label 1290*/ 34858, // Rule ID 44486 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44486,
        GIR_Done,
      // Label 1290: @34858
      GIM_Reject,
    // Label 1288: @34859
    GIM_Reject,
    // Label 1246: @34860
    GIM_Try, /*On fail goto*//*Label 1291*/ 34904,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1292*/ 34892, // Rule ID 44522 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44522,
        GIR_Done,
      // Label 1292: @34892
      GIM_Try, /*On fail goto*//*Label 1293*/ 34903, // Rule ID 44558 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (ld:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44558,
        GIR_Done,
      // Label 1293: @34903
      GIM_Reject,
    // Label 1291: @34904
    GIM_Reject,
    // Label 1247: @34905
    GIM_Try, /*On fail goto*//*Label 1294*/ 34949,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1295*/ 34937, // Rule ID 44538 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (ld:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44538,
        GIR_Done,
      // Label 1295: @34937
      GIM_Try, /*On fail goto*//*Label 1296*/ 34948, // Rule ID 44574 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (ld:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44574,
        GIR_Done,
      // Label 1296: @34948
      GIM_Reject,
    // Label 1294: @34949
    GIM_Reject,
    // Label 1248: @34950
    GIM_Try, /*On fail goto*//*Label 1297*/ 35018, // Rule ID 44590 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv8i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B8:{ *:[nxv8i1] } (IMPLICIT_DEF:{ *:[nxv8i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44590,
      GIR_Done,
    // Label 1297: @35018
    GIM_Reject,
    // Label 1249: @35019
    GIM_Try, /*On fail goto*//*Label 1298*/ 35049, // Rule ID 44304 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE8_V:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE8_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44304,
      GIR_Done,
    // Label 1298: @35049
    GIM_Reject,
    // Label 1250: @35050
    GIM_Try, /*On fail goto*//*Label 1299*/ 35094,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1300*/ 35082, // Rule ID 44510 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44510,
        GIR_Done,
      // Label 1300: @35082
      GIM_Try, /*On fail goto*//*Label 1301*/ 35093, // Rule ID 44546 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44546,
        GIR_Done,
      // Label 1301: @35093
      GIM_Reject,
    // Label 1299: @35094
    GIM_Reject,
    // Label 1251: @35095
    GIM_Try, /*On fail goto*//*Label 1302*/ 35139,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1303*/ 35127, // Rule ID 44526 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44526,
        GIR_Done,
      // Label 1303: @35127
      GIM_Try, /*On fail goto*//*Label 1304*/ 35138, // Rule ID 44562 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (ld:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44562,
        GIR_Done,
      // Label 1304: @35138
      GIM_Reject,
    // Label 1302: @35139
    GIM_Reject,
    // Label 1252: @35140
    GIM_Try, /*On fail goto*//*Label 1305*/ 35184,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1306*/ 35172, // Rule ID 44542 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (ld:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44542,
        GIR_Done,
      // Label 1306: @35172
      GIM_Try, /*On fail goto*//*Label 1307*/ 35183, // Rule ID 44578 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (ld:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44578,
        GIR_Done,
      // Label 1307: @35183
      GIM_Reject,
    // Label 1305: @35184
    GIM_Reject,
    // Label 1253: @35185
    GIM_Try, /*On fail goto*//*Label 1308*/ 35253, // Rule ID 44594 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv16i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B16:{ *:[nxv16i1] } (IMPLICIT_DEF:{ *:[nxv16i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44594,
      GIR_Done,
    // Label 1308: @35253
    GIM_Reject,
    // Label 1254: @35254
    GIM_Try, /*On fail goto*//*Label 1309*/ 35284, // Rule ID 44498 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE8_V:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE8_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44498,
      GIR_Done,
    // Label 1309: @35284
    GIM_Reject,
    // Label 1255: @35285
    GIM_Try, /*On fail goto*//*Label 1310*/ 35329,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1311*/ 35317, // Rule ID 44514 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44514,
        GIR_Done,
      // Label 1311: @35317
      GIM_Try, /*On fail goto*//*Label 1312*/ 35328, // Rule ID 44550 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44550,
        GIR_Done,
      // Label 1312: @35328
      GIM_Reject,
    // Label 1310: @35329
    GIM_Reject,
    // Label 1256: @35330
    GIM_Try, /*On fail goto*//*Label 1313*/ 35374,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1314*/ 35362, // Rule ID 44530 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44530,
        GIR_Done,
      // Label 1314: @35362
      GIM_Try, /*On fail goto*//*Label 1315*/ 35373, // Rule ID 44566 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (ld:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44566,
        GIR_Done,
      // Label 1315: @35373
      GIM_Reject,
    // Label 1313: @35374
    GIM_Reject,
    // Label 1257: @35375
    GIM_Try, /*On fail goto*//*Label 1316*/ 35443, // Rule ID 44598 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv32i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B32:{ *:[nxv32i1] } (IMPLICIT_DEF:{ *:[nxv32i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44598,
      GIR_Done,
    // Label 1316: @35443
    GIM_Reject,
    // Label 1258: @35444
    GIM_Try, /*On fail goto*//*Label 1317*/ 35474, // Rule ID 44502 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE8_V:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE8_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44502,
      GIR_Done,
    // Label 1317: @35474
    GIM_Reject,
    // Label 1259: @35475
    GIM_Try, /*On fail goto*//*Label 1318*/ 35519,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1319*/ 35507, // Rule ID 44518 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (ld:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44518,
        GIR_Done,
      // Label 1319: @35507
      GIM_Try, /*On fail goto*//*Label 1320*/ 35518, // Rule ID 44554 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (ld:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44554,
        GIR_Done,
      // Label 1320: @35518
      GIM_Reject,
    // Label 1318: @35519
    GIM_Reject,
    // Label 1260: @35520
    GIM_Try, /*On fail goto*//*Label 1321*/ 35588, // Rule ID 44602 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv64i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B64:{ *:[nxv64i1] } (IMPLICIT_DEF:{ *:[nxv64i1] }), GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] }, 3:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44602,
      GIR_Done,
    // Label 1321: @35588
    GIM_Reject,
    // Label 1261: @35589
    GIM_Try, /*On fail goto*//*Label 1322*/ 35619, // Rule ID 44506 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (ld:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE8_V:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE8_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44506,
      GIR_Done,
    // Label 1322: @35619
    GIM_Reject,
    // Label 1262: @35620
    GIM_Reject,
    // Label 16: @35621
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 32, /*)*//*default:*//*Label 1353*/ 37019,
    /*GILLT_s16*//*Label 1323*/ 35659, 0, 0,
    /*GILLT_nxv1s1*//*Label 1324*/ 35722,
    /*GILLT_nxv1s8*//*Label 1325*/ 35768,
    /*GILLT_nxv1s16*//*Label 1326*/ 35814,
    /*GILLT_nxv1s32*//*Label 1327*/ 35893,
    /*GILLT_nxv1s64*//*Label 1328*/ 35972,
    /*GILLT_nxv2s1*//*Label 1329*/ 36013,
    /*GILLT_nxv2s8*//*Label 1330*/ 36059,
    /*GILLT_nxv2s16*//*Label 1331*/ 36105,
    /*GILLT_nxv2s32*//*Label 1332*/ 36184,
    /*GILLT_nxv2s64*//*Label 1333*/ 36225,
    /*GILLT_nxv4s1*//*Label 1334*/ 36266,
    /*GILLT_nxv4s8*//*Label 1335*/ 36312,
    /*GILLT_nxv4s16*//*Label 1336*/ 36358,
    /*GILLT_nxv4s32*//*Label 1337*/ 36399,
    /*GILLT_nxv4s64*//*Label 1338*/ 36440,
    /*GILLT_nxv8s1*//*Label 1339*/ 36481,
    /*GILLT_nxv8s8*//*Label 1340*/ 36527,
    /*GILLT_nxv8s16*//*Label 1341*/ 36554,
    /*GILLT_nxv8s32*//*Label 1342*/ 36595,
    /*GILLT_nxv8s64*//*Label 1343*/ 36636,
    /*GILLT_nxv16s1*//*Label 1344*/ 36677,
    /*GILLT_nxv16s8*//*Label 1345*/ 36723,
    /*GILLT_nxv16s16*//*Label 1346*/ 36750,
    /*GILLT_nxv16s32*//*Label 1347*/ 36791,
    /*GILLT_nxv32s1*//*Label 1348*/ 36832,
    /*GILLT_nxv32s8*//*Label 1349*/ 36878,
    /*GILLT_nxv32s16*//*Label 1350*/ 36905,
    /*GILLT_nxv64s1*//*Label 1351*/ 36946,
    /*GILLT_nxv64s8*//*Label 1352*/ 36992,
    // Label 1323: @35659
    GIM_Try, /*On fail goto*//*Label 1354*/ 35721, // Rule ID 1379 //
      GIM_CheckFeatures, GIFBS_HasStdExtZhinxOrZhinxmin,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRF16RegClassID,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st FPR16INX:{ *:[f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (SH (COPY_TO_REGCLASS:{ *:[i32] } FPR16INX:{ *:[f16] }:$rs2, GPR:{ *:[i32] }), GPR:{ *:[i32] }:$rs1, 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::SH,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1379,
      GIR_Done,
    // Label 1354: @35721
    GIM_Reject,
    // Label 1324: @35722
    GIM_Try, /*On fail goto*//*Label 1355*/ 35767, // Rule ID 44310 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv1i1:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B1 VR:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B1,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44310,
      GIR_Done,
    // Label 1355: @35767
    GIM_Reject,
    // Label 1325: @35768
    GIM_Try, /*On fail goto*//*Label 1356*/ 35813, // Rule ID 44302 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv1i8:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF8 VR:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44302,
      GIR_Done,
    // Label 1356: @35813
    GIM_Reject,
    // Label 1326: @35814
    GIM_Try, /*On fail goto*//*Label 1357*/ 35892,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1358*/ 35861, // Rule ID 44452 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv1i16:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44452,
        GIR_Done,
      // Label 1358: @35861
      GIM_Try, /*On fail goto*//*Label 1359*/ 35891, // Rule ID 44464 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv1f16:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44464,
        GIR_Done,
      // Label 1359: @35891
      GIM_Reject,
    // Label 1357: @35892
    GIM_Reject,
    // Label 1327: @35893
    GIM_Try, /*On fail goto*//*Label 1360*/ 35971,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1361*/ 35940, // Rule ID 44460 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv1i32:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44460,
        GIR_Done,
      // Label 1361: @35940
      GIM_Try, /*On fail goto*//*Label 1362*/ 35970, // Rule ID 44472 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (st nxv1f32:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44472,
        GIR_Done,
      // Label 1362: @35970
      GIM_Reject,
    // Label 1360: @35971
    GIM_Reject,
    // Label 1328: @35972
    GIM_Try, /*On fail goto*//*Label 1363*/ 36012,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1364*/ 36000, // Rule ID 44484 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (st nxv1i64:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44484,
        GIR_Done,
      // Label 1364: @36000
      GIM_Try, /*On fail goto*//*Label 1365*/ 36011, // Rule ID 44496 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (st nxv1f64:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44496,
        GIR_Done,
      // Label 1365: @36011
      GIM_Reject,
    // Label 1363: @36012
    GIM_Reject,
    // Label 1329: @36013
    GIM_Try, /*On fail goto*//*Label 1366*/ 36058, // Rule ID 44584 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv2i1:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B2 VR:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44584,
      GIR_Done,
    // Label 1366: @36058
    GIM_Reject,
    // Label 1330: @36059
    GIM_Try, /*On fail goto*//*Label 1367*/ 36104, // Rule ID 44444 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv2i8:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF4 VR:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF4,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44444,
      GIR_Done,
    // Label 1367: @36104
    GIM_Reject,
    // Label 1331: @36105
    GIM_Try, /*On fail goto*//*Label 1368*/ 36183,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1369*/ 36152, // Rule ID 44456 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv2i16:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44456,
        GIR_Done,
      // Label 1369: @36152
      GIM_Try, /*On fail goto*//*Label 1370*/ 36182, // Rule ID 44468 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv2f16:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44468,
        GIR_Done,
      // Label 1370: @36182
      GIM_Reject,
    // Label 1368: @36183
    GIM_Reject,
    // Label 1332: @36184
    GIM_Try, /*On fail goto*//*Label 1371*/ 36224,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1372*/ 36212, // Rule ID 44480 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv2i32:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44480,
        GIR_Done,
      // Label 1372: @36212
      GIM_Try, /*On fail goto*//*Label 1373*/ 36223, // Rule ID 44492 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (st nxv2f32:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44492,
        GIR_Done,
      // Label 1373: @36223
      GIM_Reject,
    // Label 1371: @36224
    GIM_Reject,
    // Label 1333: @36225
    GIM_Try, /*On fail goto*//*Label 1374*/ 36265,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1375*/ 36253, // Rule ID 44536 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (st nxv2i64:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44536,
        GIR_Done,
      // Label 1375: @36253
      GIM_Try, /*On fail goto*//*Label 1376*/ 36264, // Rule ID 44572 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (st nxv2f64:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44572,
        GIR_Done,
      // Label 1376: @36264
      GIM_Reject,
    // Label 1374: @36265
    GIM_Reject,
    // Label 1334: @36266
    GIM_Try, /*On fail goto*//*Label 1377*/ 36311, // Rule ID 44588 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv4i1:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B4 VR:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B4,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44588,
      GIR_Done,
    // Label 1377: @36311
    GIM_Reject,
    // Label 1335: @36312
    GIM_Try, /*On fail goto*//*Label 1378*/ 36357, // Rule ID 44448 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv4i8:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF2 VR:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44448,
      GIR_Done,
    // Label 1378: @36357
    GIM_Reject,
    // Label 1336: @36358
    GIM_Try, /*On fail goto*//*Label 1379*/ 36398,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1380*/ 36386, // Rule ID 44476 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv4i16:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44476,
        GIR_Done,
      // Label 1380: @36386
      GIM_Try, /*On fail goto*//*Label 1381*/ 36397, // Rule ID 44488 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv4f16:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44488,
        GIR_Done,
      // Label 1381: @36397
      GIM_Reject,
    // Label 1379: @36398
    GIM_Reject,
    // Label 1337: @36399
    GIM_Try, /*On fail goto*//*Label 1382*/ 36439,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1383*/ 36427, // Rule ID 44524 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv4i32:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44524,
        GIR_Done,
      // Label 1383: @36427
      GIM_Try, /*On fail goto*//*Label 1384*/ 36438, // Rule ID 44560 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (st nxv4f32:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44560,
        GIR_Done,
      // Label 1384: @36438
      GIM_Reject,
    // Label 1382: @36439
    GIM_Reject,
    // Label 1338: @36440
    GIM_Try, /*On fail goto*//*Label 1385*/ 36480,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1386*/ 36468, // Rule ID 44540 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (st nxv4i64:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44540,
        GIR_Done,
      // Label 1386: @36468
      GIM_Try, /*On fail goto*//*Label 1387*/ 36479, // Rule ID 44576 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (st nxv4f64:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44576,
        GIR_Done,
      // Label 1387: @36479
      GIM_Reject,
    // Label 1385: @36480
    GIM_Reject,
    // Label 1339: @36481
    GIM_Try, /*On fail goto*//*Label 1388*/ 36526, // Rule ID 44592 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv8i1:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B8 VR:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44592,
      GIR_Done,
    // Label 1388: @36526
    GIM_Reject,
    // Label 1340: @36527
    GIM_Try, /*On fail goto*//*Label 1389*/ 36553, // Rule ID 44306 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv8i8:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44306,
      GIR_Done,
    // Label 1389: @36553
    GIM_Reject,
    // Label 1341: @36554
    GIM_Try, /*On fail goto*//*Label 1390*/ 36594,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1391*/ 36582, // Rule ID 44512 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv8i16:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44512,
        GIR_Done,
      // Label 1391: @36582
      GIM_Try, /*On fail goto*//*Label 1392*/ 36593, // Rule ID 44548 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv8f16:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44548,
        GIR_Done,
      // Label 1392: @36593
      GIM_Reject,
    // Label 1390: @36594
    GIM_Reject,
    // Label 1342: @36595
    GIM_Try, /*On fail goto*//*Label 1393*/ 36635,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1394*/ 36623, // Rule ID 44528 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv8i32:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44528,
        GIR_Done,
      // Label 1394: @36623
      GIM_Try, /*On fail goto*//*Label 1395*/ 36634, // Rule ID 44564 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (st nxv8f32:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44564,
        GIR_Done,
      // Label 1395: @36634
      GIM_Reject,
    // Label 1393: @36635
    GIM_Reject,
    // Label 1343: @36636
    GIM_Try, /*On fail goto*//*Label 1396*/ 36676,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1397*/ 36664, // Rule ID 44544 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsI64,
        // (st nxv8i64:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44544,
        GIR_Done,
      // Label 1397: @36664
      GIM_Try, /*On fail goto*//*Label 1398*/ 36675, // Rule ID 44580 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF64,
        // (st nxv8f64:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44580,
        GIR_Done,
      // Label 1398: @36675
      GIM_Reject,
    // Label 1396: @36676
    GIM_Reject,
    // Label 1344: @36677
    GIM_Try, /*On fail goto*//*Label 1399*/ 36722, // Rule ID 44596 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv16i1:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B16 VR:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44596,
      GIR_Done,
    // Label 1399: @36722
    GIM_Reject,
    // Label 1345: @36723
    GIM_Try, /*On fail goto*//*Label 1400*/ 36749, // Rule ID 44500 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv16i8:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44500,
      GIR_Done,
    // Label 1400: @36749
    GIM_Reject,
    // Label 1346: @36750
    GIM_Try, /*On fail goto*//*Label 1401*/ 36790,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1402*/ 36778, // Rule ID 44516 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv16i16:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44516,
        GIR_Done,
      // Label 1402: @36778
      GIM_Try, /*On fail goto*//*Label 1403*/ 36789, // Rule ID 44552 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv16f16:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44552,
        GIR_Done,
      // Label 1403: @36789
      GIM_Reject,
    // Label 1401: @36790
    GIM_Reject,
    // Label 1347: @36791
    GIM_Try, /*On fail goto*//*Label 1404*/ 36831,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1405*/ 36819, // Rule ID 44532 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv16i32:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44532,
        GIR_Done,
      // Label 1405: @36819
      GIM_Try, /*On fail goto*//*Label 1406*/ 36830, // Rule ID 44568 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        // (st nxv16f32:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44568,
        GIR_Done,
      // Label 1406: @36830
      GIM_Reject,
    // Label 1404: @36831
    GIM_Reject,
    // Label 1348: @36832
    GIM_Try, /*On fail goto*//*Label 1407*/ 36877, // Rule ID 44600 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv32i1:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B32 VR:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44600,
      GIR_Done,
    // Label 1407: @36877
    GIM_Reject,
    // Label 1349: @36878
    GIM_Try, /*On fail goto*//*Label 1408*/ 36904, // Rule ID 44504 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv32i8:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44504,
      GIR_Done,
    // Label 1408: @36904
    GIM_Reject,
    // Label 1350: @36905
    GIM_Try, /*On fail goto*//*Label 1409*/ 36945,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1410*/ 36933, // Rule ID 44520 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (st nxv32i16:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44520,
        GIR_Done,
      // Label 1410: @36933
      GIM_Try, /*On fail goto*//*Label 1411*/ 36944, // Rule ID 44556 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsF16,
        // (st nxv32f16:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44556,
        GIR_Done,
      // Label 1411: @36944
      GIM_Reject,
    // Label 1409: @36945
    GIM_Reject,
    // Label 1351: @36946
    GIM_Try, /*On fail goto*//*Label 1412*/ 36991, // Rule ID 44604 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv64i1:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B64 VR:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
      GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44604,
      GIR_Done,
    // Label 1412: @36991
    GIM_Reject,
    // Label 1352: @36992
    GIM_Try, /*On fail goto*//*Label 1413*/ 37018, // Rule ID 44508 //
      GIM_CheckFeatures, GIFBS_HasVInstructions,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      // MIs[0] rs1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      // (st nxv64i8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 44508,
      GIR_Done,
    // Label 1413: @37018
    GIM_Reject,
    // Label 1353: @37019
    GIM_Reject,
    // Label 17: @37020
    GIM_Try, /*On fail goto*//*Label 1414*/ 37364,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_Try, /*On fail goto*//*Label 1415*/ 37103, // Rule ID 422 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 422,
        GIR_Done,
      // Label 1415: @37103
      GIM_Try, /*On fail goto*//*Label 1416*/ 37168, // Rule ID 424 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 424,
        GIR_Done,
      // Label 1416: @37168
      GIM_Try, /*On fail goto*//*Label 1417*/ 37233, // Rule ID 426 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 426,
        GIR_Done,
      // Label 1417: @37233
      GIM_Try, /*On fail goto*//*Label 1418*/ 37298, // Rule ID 428 //
        GIM_CheckFeatures, GIF