#ifdef GET_RISCVMaskedPseudosTable_DECL
const RISCVMaskedPseudoInfo *getMaskedPseudoInfo(unsigned MaskedPseudo);
const RISCVMaskedPseudoInfo *lookupMaskedIntrinsicByUnmasked(unsigned UnmaskedPseudo);
#endif

#ifdef GET_RISCVMaskedPseudosTable_IMPL
constexpr RISCVMaskedPseudoInfo RISCVMaskedPseudosTable[] = {
  { PseudoTHVdotVMAQASU_VV_M1_MASK, PseudoTHVdotVMAQASU_VV_M1, 0x3 }, // 0
  { PseudoTHVdotVMAQASU_VV_M2_MASK, PseudoTHVdotVMAQASU_VV_M2, 0x3 }, // 1
  { PseudoTHVdotVMAQASU_VV_M4_MASK, PseudoTHVdotVMAQASU_VV_M4, 0x3 }, // 2
  { PseudoTHVdotVMAQASU_VV_M8_MASK, PseudoTHVdotVMAQASU_VV_M8, 0x3 }, // 3
  { PseudoTHVdotVMAQASU_VV_MF2_MASK, PseudoTHVdotVMAQASU_VV_MF2, 0x3 }, // 4
  { PseudoTHVdotVMAQASU_VX_M1_MASK, PseudoTHVdotVMAQASU_VX_M1, 0x3 }, // 5
  { PseudoTHVdotVMAQASU_VX_M2_MASK, PseudoTHVdotVMAQASU_VX_M2, 0x3 }, // 6
  { PseudoTHVdotVMAQASU_VX_M4_MASK, PseudoTHVdotVMAQASU_VX_M4, 0x3 }, // 7
  { PseudoTHVdotVMAQASU_VX_M8_MASK, PseudoTHVdotVMAQASU_VX_M8, 0x3 }, // 8
  { PseudoTHVdotVMAQASU_VX_MF2_MASK, PseudoTHVdotVMAQASU_VX_MF2, 0x3 }, // 9
  { PseudoTHVdotVMAQAUS_VX_M1_MASK, PseudoTHVdotVMAQAUS_VX_M1, 0x3 }, // 10
  { PseudoTHVdotVMAQAUS_VX_M2_MASK, PseudoTHVdotVMAQAUS_VX_M2, 0x3 }, // 11
  { PseudoTHVdotVMAQAUS_VX_M4_MASK, PseudoTHVdotVMAQAUS_VX_M4, 0x3 }, // 12
  { PseudoTHVdotVMAQAUS_VX_M8_MASK, PseudoTHVdotVMAQAUS_VX_M8, 0x3 }, // 13
  { PseudoTHVdotVMAQAUS_VX_MF2_MASK, PseudoTHVdotVMAQAUS_VX_MF2, 0x3 }, // 14
  { PseudoTHVdotVMAQAU_VV_M1_MASK, PseudoTHVdotVMAQAU_VV_M1, 0x3 }, // 15
  { PseudoTHVdotVMAQAU_VV_M2_MASK, PseudoTHVdotVMAQAU_VV_M2, 0x3 }, // 16
  { PseudoTHVdotVMAQAU_VV_M4_MASK, PseudoTHVdotVMAQAU_VV_M4, 0x3 }, // 17
  { PseudoTHVdotVMAQAU_VV_M8_MASK, PseudoTHVdotVMAQAU_VV_M8, 0x3 }, // 18
  { PseudoTHVdotVMAQAU_VV_MF2_MASK, PseudoTHVdotVMAQAU_VV_MF2, 0x3 }, // 19
  { PseudoTHVdotVMAQAU_VX_M1_MASK, PseudoTHVdotVMAQAU_VX_M1, 0x3 }, // 20
  { PseudoTHVdotVMAQAU_VX_M2_MASK, PseudoTHVdotVMAQAU_VX_M2, 0x3 }, // 21
  { PseudoTHVdotVMAQAU_VX_M4_MASK, PseudoTHVdotVMAQAU_VX_M4, 0x3 }, // 22
  { PseudoTHVdotVMAQAU_VX_M8_MASK, PseudoTHVdotVMAQAU_VX_M8, 0x3 }, // 23
  { PseudoTHVdotVMAQAU_VX_MF2_MASK, PseudoTHVdotVMAQAU_VX_MF2, 0x3 }, // 24
  { PseudoTHVdotVMAQA_VV_M1_MASK, PseudoTHVdotVMAQA_VV_M1, 0x3 }, // 25
  { PseudoTHVdotVMAQA_VV_M2_MASK, PseudoTHVdotVMAQA_VV_M2, 0x3 }, // 26
  { PseudoTHVdotVMAQA_VV_M4_MASK, PseudoTHVdotVMAQA_VV_M4, 0x3 }, // 27
  { PseudoTHVdotVMAQA_VV_M8_MASK, PseudoTHVdotVMAQA_VV_M8, 0x3 }, // 28
  { PseudoTHVdotVMAQA_VV_MF2_MASK, PseudoTHVdotVMAQA_VV_MF2, 0x3 }, // 29
  { PseudoTHVdotVMAQA_VX_M1_MASK, PseudoTHVdotVMAQA_VX_M1, 0x3 }, // 30
  { PseudoTHVdotVMAQA_VX_M2_MASK, PseudoTHVdotVMAQA_VX_M2, 0x3 }, // 31
  { PseudoTHVdotVMAQA_VX_M4_MASK, PseudoTHVdotVMAQA_VX_M4, 0x3 }, // 32
  { PseudoTHVdotVMAQA_VX_M8_MASK, PseudoTHVdotVMAQA_VX_M8, 0x3 }, // 33
  { PseudoTHVdotVMAQA_VX_MF2_MASK, PseudoTHVdotVMAQA_VX_MF2, 0x3 }, // 34
  { PseudoVAADDU_VV_M1_MASK, PseudoVAADDU_VV_M1, 0x3 }, // 35
  { PseudoVAADDU_VV_M2_MASK, PseudoVAADDU_VV_M2, 0x3 }, // 36
  { PseudoVAADDU_VV_M4_MASK, PseudoVAADDU_VV_M4, 0x3 }, // 37
  { PseudoVAADDU_VV_M8_MASK, PseudoVAADDU_VV_M8, 0x3 }, // 38
  { PseudoVAADDU_VV_MF2_MASK, PseudoVAADDU_VV_MF2, 0x3 }, // 39
  { PseudoVAADDU_VV_MF4_MASK, PseudoVAADDU_VV_MF4, 0x3 }, // 40
  { PseudoVAADDU_VV_MF8_MASK, PseudoVAADDU_VV_MF8, 0x3 }, // 41
  { PseudoVAADDU_VX_M1_MASK, PseudoVAADDU_VX_M1, 0x3 }, // 42
  { PseudoVAADDU_VX_M2_MASK, PseudoVAADDU_VX_M2, 0x3 }, // 43
  { PseudoVAADDU_VX_M4_MASK, PseudoVAADDU_VX_M4, 0x3 }, // 44
  { PseudoVAADDU_VX_M8_MASK, PseudoVAADDU_VX_M8, 0x3 }, // 45
  { PseudoVAADDU_VX_MF2_MASK, PseudoVAADDU_VX_MF2, 0x3 }, // 46
  { PseudoVAADDU_VX_MF4_MASK, PseudoVAADDU_VX_MF4, 0x3 }, // 47
  { PseudoVAADDU_VX_MF8_MASK, PseudoVAADDU_VX_MF8, 0x3 }, // 48
  { PseudoVAADD_VV_M1_MASK, PseudoVAADD_VV_M1, 0x3 }, // 49
  { PseudoVAADD_VV_M2_MASK, PseudoVAADD_VV_M2, 0x3 }, // 50
  { PseudoVAADD_VV_M4_MASK, PseudoVAADD_VV_M4, 0x3 }, // 51
  { PseudoVAADD_VV_M8_MASK, PseudoVAADD_VV_M8, 0x3 }, // 52
  { PseudoVAADD_VV_MF2_MASK, PseudoVAADD_VV_MF2, 0x3 }, // 53
  { PseudoVAADD_VV_MF4_MASK, PseudoVAADD_VV_MF4, 0x3 }, // 54
  { PseudoVAADD_VV_MF8_MASK, PseudoVAADD_VV_MF8, 0x3 }, // 55
  { PseudoVAADD_VX_M1_MASK, PseudoVAADD_VX_M1, 0x3 }, // 56
  { PseudoVAADD_VX_M2_MASK, PseudoVAADD_VX_M2, 0x3 }, // 57
  { PseudoVAADD_VX_M4_MASK, PseudoVAADD_VX_M4, 0x3 }, // 58
  { PseudoVAADD_VX_M8_MASK, PseudoVAADD_VX_M8, 0x3 }, // 59
  { PseudoVAADD_VX_MF2_MASK, PseudoVAADD_VX_MF2, 0x3 }, // 60
  { PseudoVAADD_VX_MF4_MASK, PseudoVAADD_VX_MF4, 0x3 }, // 61
  { PseudoVAADD_VX_MF8_MASK, PseudoVAADD_VX_MF8, 0x3 }, // 62
  { PseudoVADD_VI_M1_MASK, PseudoVADD_VI_M1, 0x3 }, // 63
  { PseudoVADD_VI_M2_MASK, PseudoVADD_VI_M2, 0x3 }, // 64
  { PseudoVADD_VI_M4_MASK, PseudoVADD_VI_M4, 0x3 }, // 65
  { PseudoVADD_VI_M8_MASK, PseudoVADD_VI_M8, 0x3 }, // 66
  { PseudoVADD_VI_MF2_MASK, PseudoVADD_VI_MF2, 0x3 }, // 67
  { PseudoVADD_VI_MF4_MASK, PseudoVADD_VI_MF4, 0x3 }, // 68
  { PseudoVADD_VI_MF8_MASK, PseudoVADD_VI_MF8, 0x3 }, // 69
  { PseudoVADD_VV_M1_MASK, PseudoVADD_VV_M1, 0x3 }, // 70
  { PseudoVADD_VV_M2_MASK, PseudoVADD_VV_M2, 0x3 }, // 71
  { PseudoVADD_VV_M4_MASK, PseudoVADD_VV_M4, 0x3 }, // 72
  { PseudoVADD_VV_M8_MASK, PseudoVADD_VV_M8, 0x3 }, // 73
  { PseudoVADD_VV_MF2_MASK, PseudoVADD_VV_MF2, 0x3 }, // 74
  { PseudoVADD_VV_MF4_MASK, PseudoVADD_VV_MF4, 0x3 }, // 75
  { PseudoVADD_VV_MF8_MASK, PseudoVADD_VV_MF8, 0x3 }, // 76
  { PseudoVADD_VX_M1_MASK, PseudoVADD_VX_M1, 0x3 }, // 77
  { PseudoVADD_VX_M2_MASK, PseudoVADD_VX_M2, 0x3 }, // 78
  { PseudoVADD_VX_M4_MASK, PseudoVADD_VX_M4, 0x3 }, // 79
  { PseudoVADD_VX_M8_MASK, PseudoVADD_VX_M8, 0x3 }, // 80
  { PseudoVADD_VX_MF2_MASK, PseudoVADD_VX_MF2, 0x3 }, // 81
  { PseudoVADD_VX_MF4_MASK, PseudoVADD_VX_MF4, 0x3 }, // 82
  { PseudoVADD_VX_MF8_MASK, PseudoVADD_VX_MF8, 0x3 }, // 83
  { PseudoVANDN_VV_M1_MASK, PseudoVANDN_VV_M1, 0x3 }, // 84
  { PseudoVANDN_VV_M2_MASK, PseudoVANDN_VV_M2, 0x3 }, // 85
  { PseudoVANDN_VV_M4_MASK, PseudoVANDN_VV_M4, 0x3 }, // 86
  { PseudoVANDN_VV_M8_MASK, PseudoVANDN_VV_M8, 0x3 }, // 87
  { PseudoVANDN_VV_MF2_MASK, PseudoVANDN_VV_MF2, 0x3 }, // 88
  { PseudoVANDN_VV_MF4_MASK, PseudoVANDN_VV_MF4, 0x3 }, // 89
  { PseudoVANDN_VV_MF8_MASK, PseudoVANDN_VV_MF8, 0x3 }, // 90
  { PseudoVANDN_VX_M1_MASK, PseudoVANDN_VX_M1, 0x3 }, // 91
  { PseudoVANDN_VX_M2_MASK, PseudoVANDN_VX_M2, 0x3 }, // 92
  { PseudoVANDN_VX_M4_MASK, PseudoVANDN_VX_M4, 0x3 }, // 93
  { PseudoVANDN_VX_M8_MASK, PseudoVANDN_VX_M8, 0x3 }, // 94
  { PseudoVANDN_VX_MF2_MASK, PseudoVANDN_VX_MF2, 0x3 }, // 95
  { PseudoVANDN_VX_MF4_MASK, PseudoVANDN_VX_MF4, 0x3 }, // 96
  { PseudoVANDN_VX_MF8_MASK, PseudoVANDN_VX_MF8, 0x3 }, // 97
  { PseudoVAND_VI_M1_MASK, PseudoVAND_VI_M1, 0x3 }, // 98
  { PseudoVAND_VI_M2_MASK, PseudoVAND_VI_M2, 0x3 }, // 99
  { PseudoVAND_VI_M4_MASK, PseudoVAND_VI_M4, 0x3 }, // 100
  { PseudoVAND_VI_M8_MASK, PseudoVAND_VI_M8, 0x3 }, // 101
  { PseudoVAND_VI_MF2_MASK, PseudoVAND_VI_MF2, 0x3 }, // 102
  { PseudoVAND_VI_MF4_MASK, PseudoVAND_VI_MF4, 0x3 }, // 103
  { PseudoVAND_VI_MF8_MASK, PseudoVAND_VI_MF8, 0x3 }, // 104
  { PseudoVAND_VV_M1_MASK, PseudoVAND_VV_M1, 0x3 }, // 105
  { PseudoVAND_VV_M2_MASK, PseudoVAND_VV_M2, 0x3 }, // 106
  { PseudoVAND_VV_M4_MASK, PseudoVAND_VV_M4, 0x3 }, // 107
  { PseudoVAND_VV_M8_MASK, PseudoVAND_VV_M8, 0x3 }, // 108
  { PseudoVAND_VV_MF2_MASK, PseudoVAND_VV_MF2, 0x3 }, // 109
  { PseudoVAND_VV_MF4_MASK, PseudoVAND_VV_MF4, 0x3 }, // 110
  { PseudoVAND_VV_MF8_MASK, PseudoVAND_VV_MF8, 0x3 }, // 111
  { PseudoVAND_VX_M1_MASK, PseudoVAND_VX_M1, 0x3 }, // 112
  { PseudoVAND_VX_M2_MASK, PseudoVAND_VX_M2, 0x3 }, // 113
  { PseudoVAND_VX_M4_MASK, PseudoVAND_VX_M4, 0x3 }, // 114
  { PseudoVAND_VX_M8_MASK, PseudoVAND_VX_M8, 0x3 }, // 115
  { PseudoVAND_VX_MF2_MASK, PseudoVAND_VX_MF2, 0x3 }, // 116
  { PseudoVAND_VX_MF4_MASK, PseudoVAND_VX_MF4, 0x3 }, // 117
  { PseudoVAND_VX_MF8_MASK, PseudoVAND_VX_MF8, 0x3 }, // 118
  { PseudoVASUBU_VV_M1_MASK, PseudoVASUBU_VV_M1, 0x3 }, // 119
  { PseudoVASUBU_VV_M2_MASK, PseudoVASUBU_VV_M2, 0x3 }, // 120
  { PseudoVASUBU_VV_M4_MASK, PseudoVASUBU_VV_M4, 0x3 }, // 121
  { PseudoVASUBU_VV_M8_MASK, PseudoVASUBU_VV_M8, 0x3 }, // 122
  { PseudoVASUBU_VV_MF2_MASK, PseudoVASUBU_VV_MF2, 0x3 }, // 123
  { PseudoVASUBU_VV_MF4_MASK, PseudoVASUBU_VV_MF4, 0x3 }, // 124
  { PseudoVASUBU_VV_MF8_MASK, PseudoVASUBU_VV_MF8, 0x3 }, // 125
  { PseudoVASUBU_VX_M1_MASK, PseudoVASUBU_VX_M1, 0x3 }, // 126
  { PseudoVASUBU_VX_M2_MASK, PseudoVASUBU_VX_M2, 0x3 }, // 127
  { PseudoVASUBU_VX_M4_MASK, PseudoVASUBU_VX_M4, 0x3 }, // 128
  { PseudoVASUBU_VX_M8_MASK, PseudoVASUBU_VX_M8, 0x3 }, // 129
  { PseudoVASUBU_VX_MF2_MASK, PseudoVASUBU_VX_MF2, 0x3 }, // 130
  { PseudoVASUBU_VX_MF4_MASK, PseudoVASUBU_VX_MF4, 0x3 }, // 131
  { PseudoVASUBU_VX_MF8_MASK, PseudoVASUBU_VX_MF8, 0x3 }, // 132
  { PseudoVASUB_VV_M1_MASK, PseudoVASUB_VV_M1, 0x3 }, // 133
  { PseudoVASUB_VV_M2_MASK, PseudoVASUB_VV_M2, 0x3 }, // 134
  { PseudoVASUB_VV_M4_MASK, PseudoVASUB_VV_M4, 0x3 }, // 135
  { PseudoVASUB_VV_M8_MASK, PseudoVASUB_VV_M8, 0x3 }, // 136
  { PseudoVASUB_VV_MF2_MASK, PseudoVASUB_VV_MF2, 0x3 }, // 137
  { PseudoVASUB_VV_MF4_MASK, PseudoVASUB_VV_MF4, 0x3 }, // 138
  { PseudoVASUB_VV_MF8_MASK, PseudoVASUB_VV_MF8, 0x3 }, // 139
  { PseudoVASUB_VX_M1_MASK, PseudoVASUB_VX_M1, 0x3 }, // 140
  { PseudoVASUB_VX_M2_MASK, PseudoVASUB_VX_M2, 0x3 }, // 141
  { PseudoVASUB_VX_M4_MASK, PseudoVASUB_VX_M4, 0x3 }, // 142
  { PseudoVASUB_VX_M8_MASK, PseudoVASUB_VX_M8, 0x3 }, // 143
  { PseudoVASUB_VX_MF2_MASK, PseudoVASUB_VX_MF2, 0x3 }, // 144
  { PseudoVASUB_VX_MF4_MASK, PseudoVASUB_VX_MF4, 0x3 }, // 145
  { PseudoVASUB_VX_MF8_MASK, PseudoVASUB_VX_MF8, 0x3 }, // 146
  { PseudoVBREV_V_M1_MASK, PseudoVBREV_V_M1, 0x2 }, // 147
  { PseudoVBREV_V_M2_MASK, PseudoVBREV_V_M2, 0x2 }, // 148
  { PseudoVBREV_V_M4_MASK, PseudoVBREV_V_M4, 0x2 }, // 149
  { PseudoVBREV_V_M8_MASK, PseudoVBREV_V_M8, 0x2 }, // 150
  { PseudoVBREV_V_MF2_MASK, PseudoVBREV_V_MF2, 0x2 }, // 151
  { PseudoVBREV_V_MF4_MASK, PseudoVBREV_V_MF4, 0x2 }, // 152
  { PseudoVBREV_V_MF8_MASK, PseudoVBREV_V_MF8, 0x2 }, // 153
  { PseudoVCLZ_V_M1_MASK, PseudoVCLZ_V_M1, 0x2 }, // 154
  { PseudoVCLZ_V_M2_MASK, PseudoVCLZ_V_M2, 0x2 }, // 155
  { PseudoVCLZ_V_M4_MASK, PseudoVCLZ_V_M4, 0x2 }, // 156
  { PseudoVCLZ_V_M8_MASK, PseudoVCLZ_V_M8, 0x2 }, // 157
  { PseudoVCLZ_V_MF2_MASK, PseudoVCLZ_V_MF2, 0x2 }, // 158
  { PseudoVCLZ_V_MF4_MASK, PseudoVCLZ_V_MF4, 0x2 }, // 159
  { PseudoVCLZ_V_MF8_MASK, PseudoVCLZ_V_MF8, 0x2 }, // 160
  { PseudoVCPOP_V_M1_MASK, PseudoVCPOP_V_M1, 0x2 }, // 161
  { PseudoVCPOP_V_M2_MASK, PseudoVCPOP_V_M2, 0x2 }, // 162
  { PseudoVCPOP_V_M4_MASK, PseudoVCPOP_V_M4, 0x2 }, // 163
  { PseudoVCPOP_V_M8_MASK, PseudoVCPOP_V_M8, 0x2 }, // 164
  { PseudoVCPOP_V_MF2_MASK, PseudoVCPOP_V_MF2, 0x2 }, // 165
  { PseudoVCPOP_V_MF4_MASK, PseudoVCPOP_V_MF4, 0x2 }, // 166
  { PseudoVCPOP_V_MF8_MASK, PseudoVCPOP_V_MF8, 0x2 }, // 167
  { PseudoVCTZ_V_M1_MASK, PseudoVCTZ_V_M1, 0x2 }, // 168
  { PseudoVCTZ_V_M2_MASK, PseudoVCTZ_V_M2, 0x2 }, // 169
  { PseudoVCTZ_V_M4_MASK, PseudoVCTZ_V_M4, 0x2 }, // 170
  { PseudoVCTZ_V_M8_MASK, PseudoVCTZ_V_M8, 0x2 }, // 171
  { PseudoVCTZ_V_MF2_MASK, PseudoVCTZ_V_MF2, 0x2 }, // 172
  { PseudoVCTZ_V_MF4_MASK, PseudoVCTZ_V_MF4, 0x2 }, // 173
  { PseudoVCTZ_V_MF8_MASK, PseudoVCTZ_V_MF8, 0x2 }, // 174
  { PseudoVDIVU_VV_M1_E16_MASK, PseudoVDIVU_VV_M1_E16, 0x3 }, // 175
  { PseudoVDIVU_VV_M1_E32_MASK, PseudoVDIVU_VV_M1_E32, 0x3 }, // 176
  { PseudoVDIVU_VV_M1_E64_MASK, PseudoVDIVU_VV_M1_E64, 0x3 }, // 177
  { PseudoVDIVU_VV_M1_E8_MASK, PseudoVDIVU_VV_M1_E8, 0x3 }, // 178
  { PseudoVDIVU_VV_M2_E16_MASK, PseudoVDIVU_VV_M2_E16, 0x3 }, // 179
  { PseudoVDIVU_VV_M2_E32_MASK, PseudoVDIVU_VV_M2_E32, 0x3 }, // 180
  { PseudoVDIVU_VV_M2_E64_MASK, PseudoVDIVU_VV_M2_E64, 0x3 }, // 181
  { PseudoVDIVU_VV_M2_E8_MASK, PseudoVDIVU_VV_M2_E8, 0x3 }, // 182
  { PseudoVDIVU_VV_M4_E16_MASK, PseudoVDIVU_VV_M4_E16, 0x3 }, // 183
  { PseudoVDIVU_VV_M4_E32_MASK, PseudoVDIVU_VV_M4_E32, 0x3 }, // 184
  { PseudoVDIVU_VV_M4_E64_MASK, PseudoVDIVU_VV_M4_E64, 0x3 }, // 185
  { PseudoVDIVU_VV_M4_E8_MASK, PseudoVDIVU_VV_M4_E8, 0x3 }, // 186
  { PseudoVDIVU_VV_M8_E16_MASK, PseudoVDIVU_VV_M8_E16, 0x3 }, // 187
  { PseudoVDIVU_VV_M8_E32_MASK, PseudoVDIVU_VV_M8_E32, 0x3 }, // 188
  { PseudoVDIVU_VV_M8_E64_MASK, PseudoVDIVU_VV_M8_E64, 0x3 }, // 189
  { PseudoVDIVU_VV_M8_E8_MASK, PseudoVDIVU_VV_M8_E8, 0x3 }, // 190
  { PseudoVDIVU_VV_MF2_E16_MASK, PseudoVDIVU_VV_MF2_E16, 0x3 }, // 191
  { PseudoVDIVU_VV_MF2_E32_MASK, PseudoVDIVU_VV_MF2_E32, 0x3 }, // 192
  { PseudoVDIVU_VV_MF2_E8_MASK, PseudoVDIVU_VV_MF2_E8, 0x3 }, // 193
  { PseudoVDIVU_VV_MF4_E16_MASK, PseudoVDIVU_VV_MF4_E16, 0x3 }, // 194
  { PseudoVDIVU_VV_MF4_E8_MASK, PseudoVDIVU_VV_MF4_E8, 0x3 }, // 195
  { PseudoVDIVU_VV_MF8_E8_MASK, PseudoVDIVU_VV_MF8_E8, 0x3 }, // 196
  { PseudoVDIVU_VX_M1_E16_MASK, PseudoVDIVU_VX_M1_E16, 0x3 }, // 197
  { PseudoVDIVU_VX_M1_E32_MASK, PseudoVDIVU_VX_M1_E32, 0x3 }, // 198
  { PseudoVDIVU_VX_M1_E64_MASK, PseudoVDIVU_VX_M1_E64, 0x3 }, // 199
  { PseudoVDIVU_VX_M1_E8_MASK, PseudoVDIVU_VX_M1_E8, 0x3 }, // 200
  { PseudoVDIVU_VX_M2_E16_MASK, PseudoVDIVU_VX_M2_E16, 0x3 }, // 201
  { PseudoVDIVU_VX_M2_E32_MASK, PseudoVDIVU_VX_M2_E32, 0x3 }, // 202
  { PseudoVDIVU_VX_M2_E64_MASK, PseudoVDIVU_VX_M2_E64, 0x3 }, // 203
  { PseudoVDIVU_VX_M2_E8_MASK, PseudoVDIVU_VX_M2_E8, 0x3 }, // 204
  { PseudoVDIVU_VX_M4_E16_MASK, PseudoVDIVU_VX_M4_E16, 0x3 }, // 205
  { PseudoVDIVU_VX_M4_E32_MASK, PseudoVDIVU_VX_M4_E32, 0x3 }, // 206
  { PseudoVDIVU_VX_M4_E64_MASK, PseudoVDIVU_VX_M4_E64, 0x3 }, // 207
  { PseudoVDIVU_VX_M4_E8_MASK, PseudoVDIVU_VX_M4_E8, 0x3 }, // 208
  { PseudoVDIVU_VX_M8_E16_MASK, PseudoVDIVU_VX_M8_E16, 0x3 }, // 209
  { PseudoVDIVU_VX_M8_E32_MASK, PseudoVDIVU_VX_M8_E32, 0x3 }, // 210
  { PseudoVDIVU_VX_M8_E64_MASK, PseudoVDIVU_VX_M8_E64, 0x3 }, // 211
  { PseudoVDIVU_VX_M8_E8_MASK, PseudoVDIVU_VX_M8_E8, 0x3 }, // 212
  { PseudoVDIVU_VX_MF2_E16_MASK, PseudoVDIVU_VX_MF2_E16, 0x3 }, // 213
  { PseudoVDIVU_VX_MF2_E32_MASK, PseudoVDIVU_VX_MF2_E32, 0x3 }, // 214
  { PseudoVDIVU_VX_MF2_E8_MASK, PseudoVDIVU_VX_MF2_E8, 0x3 }, // 215
  { PseudoVDIVU_VX_MF4_E16_MASK, PseudoVDIVU_VX_MF4_E16, 0x3 }, // 216
  { PseudoVDIVU_VX_MF4_E8_MASK, PseudoVDIVU_VX_MF4_E8, 0x3 }, // 217
  { PseudoVDIVU_VX_MF8_E8_MASK, PseudoVDIVU_VX_MF8_E8, 0x3 }, // 218
  { PseudoVDIV_VV_M1_E16_MASK, PseudoVDIV_VV_M1_E16, 0x3 }, // 219
  { PseudoVDIV_VV_M1_E32_MASK, PseudoVDIV_VV_M1_E32, 0x3 }, // 220
  { PseudoVDIV_VV_M1_E64_MASK, PseudoVDIV_VV_M1_E64, 0x3 }, // 221
  { PseudoVDIV_VV_M1_E8_MASK, PseudoVDIV_VV_M1_E8, 0x3 }, // 222
  { PseudoVDIV_VV_M2_E16_MASK, PseudoVDIV_VV_M2_E16, 0x3 }, // 223
  { PseudoVDIV_VV_M2_E32_MASK, PseudoVDIV_VV_M2_E32, 0x3 }, // 224
  { PseudoVDIV_VV_M2_E64_MASK, PseudoVDIV_VV_M2_E64, 0x3 }, // 225
  { PseudoVDIV_VV_M2_E8_MASK, PseudoVDIV_VV_M2_E8, 0x3 }, // 226
  { PseudoVDIV_VV_M4_E16_MASK, PseudoVDIV_VV_M4_E16, 0x3 }, // 227
  { PseudoVDIV_VV_M4_E32_MASK, PseudoVDIV_VV_M4_E32, 0x3 }, // 228
  { PseudoVDIV_VV_M4_E64_MASK, PseudoVDIV_VV_M4_E64, 0x3 }, // 229
  { PseudoVDIV_VV_M4_E8_MASK, PseudoVDIV_VV_M4_E8, 0x3 }, // 230
  { PseudoVDIV_VV_M8_E16_MASK, PseudoVDIV_VV_M8_E16, 0x3 }, // 231
  { PseudoVDIV_VV_M8_E32_MASK, PseudoVDIV_VV_M8_E32, 0x3 }, // 232
  { PseudoVDIV_VV_M8_E64_MASK, PseudoVDIV_VV_M8_E64, 0x3 }, // 233
  { PseudoVDIV_VV_M8_E8_MASK, PseudoVDIV_VV_M8_E8, 0x3 }, // 234
  { PseudoVDIV_VV_MF2_E16_MASK, PseudoVDIV_VV_MF2_E16, 0x3 }, // 235
  { PseudoVDIV_VV_MF2_E32_MASK, PseudoVDIV_VV_MF2_E32, 0x3 }, // 236
  { PseudoVDIV_VV_MF2_E8_MASK, PseudoVDIV_VV_MF2_E8, 0x3 }, // 237
  { PseudoVDIV_VV_MF4_E16_MASK, PseudoVDIV_VV_MF4_E16, 0x3 }, // 238
  { PseudoVDIV_VV_MF4_E8_MASK, PseudoVDIV_VV_MF4_E8, 0x3 }, // 239
  { PseudoVDIV_VV_MF8_E8_MASK, PseudoVDIV_VV_MF8_E8, 0x3 }, // 240
  { PseudoVDIV_VX_M1_E16_MASK, PseudoVDIV_VX_M1_E16, 0x3 }, // 241
  { PseudoVDIV_VX_M1_E32_MASK, PseudoVDIV_VX_M1_E32, 0x3 }, // 242
  { PseudoVDIV_VX_M1_E64_MASK, PseudoVDIV_VX_M1_E64, 0x3 }, // 243
  { PseudoVDIV_VX_M1_E8_MASK, PseudoVDIV_VX_M1_E8, 0x3 }, // 244
  { PseudoVDIV_VX_M2_E16_MASK, PseudoVDIV_VX_M2_E16, 0x3 }, // 245
  { PseudoVDIV_VX_M2_E32_MASK, PseudoVDIV_VX_M2_E32, 0x3 }, // 246
  { PseudoVDIV_VX_M2_E64_MASK, PseudoVDIV_VX_M2_E64, 0x3 }, // 247
  { PseudoVDIV_VX_M2_E8_MASK, PseudoVDIV_VX_M2_E8, 0x3 }, // 248
  { PseudoVDIV_VX_M4_E16_MASK, PseudoVDIV_VX_M4_E16, 0x3 }, // 249
  { PseudoVDIV_VX_M4_E32_MASK, PseudoVDIV_VX_M4_E32, 0x3 }, // 250
  { PseudoVDIV_VX_M4_E64_MASK, PseudoVDIV_VX_M4_E64, 0x3 }, // 251
  { PseudoVDIV_VX_M4_E8_MASK, PseudoVDIV_VX_M4_E8, 0x3 }, // 252
  { PseudoVDIV_VX_M8_E16_MASK, PseudoVDIV_VX_M8_E16, 0x3 }, // 253
  { PseudoVDIV_VX_M8_E32_MASK, PseudoVDIV_VX_M8_E32, 0x3 }, // 254
  { PseudoVDIV_VX_M8_E64_MASK, PseudoVDIV_VX_M8_E64, 0x3 }, // 255
  { PseudoVDIV_VX_M8_E8_MASK, PseudoVDIV_VX_M8_E8, 0x3 }, // 256
  { PseudoVDIV_VX_MF2_E16_MASK, PseudoVDIV_VX_MF2_E16, 0x3 }, // 257
  { PseudoVDIV_VX_MF2_E32_MASK, PseudoVDIV_VX_MF2_E32, 0x3 }, // 258
  { PseudoVDIV_VX_MF2_E8_MASK, PseudoVDIV_VX_MF2_E8, 0x3 }, // 259
  { PseudoVDIV_VX_MF4_E16_MASK, PseudoVDIV_VX_MF4_E16, 0x3 }, // 260
  { PseudoVDIV_VX_MF4_E8_MASK, PseudoVDIV_VX_MF4_E8, 0x3 }, // 261
  { PseudoVDIV_VX_MF8_E8_MASK, PseudoVDIV_VX_MF8_E8, 0x3 }, // 262
  { PseudoVFADD_VF16_M1_MASK, PseudoVFADD_VF16_M1, 0x3 }, // 263
  { PseudoVFADD_VF16_M2_MASK, PseudoVFADD_VF16_M2, 0x3 }, // 264
  { PseudoVFADD_VF16_M4_MASK, PseudoVFADD_VF16_M4, 0x3 }, // 265
  { PseudoVFADD_VF16_M8_MASK, PseudoVFADD_VF16_M8, 0x3 }, // 266
  { PseudoVFADD_VF16_MF2_MASK, PseudoVFADD_VF16_MF2, 0x3 }, // 267
  { PseudoVFADD_VF16_MF4_MASK, PseudoVFADD_VF16_MF4, 0x3 }, // 268
  { PseudoVFADD_VF32_M1_MASK, PseudoVFADD_VF32_M1, 0x3 }, // 269
  { PseudoVFADD_VF32_M2_MASK, PseudoVFADD_VF32_M2, 0x3 }, // 270
  { PseudoVFADD_VF32_M4_MASK, PseudoVFADD_VF32_M4, 0x3 }, // 271
  { PseudoVFADD_VF32_M8_MASK, PseudoVFADD_VF32_M8, 0x3 }, // 272
  { PseudoVFADD_VF32_MF2_MASK, PseudoVFADD_VF32_MF2, 0x3 }, // 273
  { PseudoVFADD_VF64_M1_MASK, PseudoVFADD_VF64_M1, 0x3 }, // 274
  { PseudoVFADD_VF64_M2_MASK, PseudoVFADD_VF64_M2, 0x3 }, // 275
  { PseudoVFADD_VF64_M4_MASK, PseudoVFADD_VF64_M4, 0x3 }, // 276
  { PseudoVFADD_VF64_M8_MASK, PseudoVFADD_VF64_M8, 0x3 }, // 277
  { PseudoVFADD_VV_M1_MASK, PseudoVFADD_VV_M1, 0x3 }, // 278
  { PseudoVFADD_VV_M2_MASK, PseudoVFADD_VV_M2, 0x3 }, // 279
  { PseudoVFADD_VV_M4_MASK, PseudoVFADD_VV_M4, 0x3 }, // 280
  { PseudoVFADD_VV_M8_MASK, PseudoVFADD_VV_M8, 0x3 }, // 281
  { PseudoVFADD_VV_MF2_MASK, PseudoVFADD_VV_MF2, 0x3 }, // 282
  { PseudoVFADD_VV_MF4_MASK, PseudoVFADD_VV_MF4, 0x3 }, // 283
  { PseudoVFCLASS_V_M1_MASK, PseudoVFCLASS_V_M1, 0x2 }, // 284
  { PseudoVFCLASS_V_M2_MASK, PseudoVFCLASS_V_M2, 0x2 }, // 285
  { PseudoVFCLASS_V_M4_MASK, PseudoVFCLASS_V_M4, 0x2 }, // 286
  { PseudoVFCLASS_V_M8_MASK, PseudoVFCLASS_V_M8, 0x2 }, // 287
  { PseudoVFCLASS_V_MF2_MASK, PseudoVFCLASS_V_MF2, 0x2 }, // 288
  { PseudoVFCLASS_V_MF4_MASK, PseudoVFCLASS_V_MF4, 0x2 }, // 289
  { PseudoVFCVT_F_XU_V_M1_MASK, PseudoVFCVT_F_XU_V_M1, 0x2 }, // 290
  { PseudoVFCVT_F_XU_V_M2_MASK, PseudoVFCVT_F_XU_V_M2, 0x2 }, // 291
  { PseudoVFCVT_F_XU_V_M4_MASK, PseudoVFCVT_F_XU_V_M4, 0x2 }, // 292
  { PseudoVFCVT_F_XU_V_M8_MASK, PseudoVFCVT_F_XU_V_M8, 0x2 }, // 293
  { PseudoVFCVT_F_XU_V_MF2_MASK, PseudoVFCVT_F_XU_V_MF2, 0x2 }, // 294
  { PseudoVFCVT_F_XU_V_MF4_MASK, PseudoVFCVT_F_XU_V_MF4, 0x2 }, // 295
  { PseudoVFCVT_F_X_V_M1_MASK, PseudoVFCVT_F_X_V_M1, 0x2 }, // 296
  { PseudoVFCVT_F_X_V_M2_MASK, PseudoVFCVT_F_X_V_M2, 0x2 }, // 297
  { PseudoVFCVT_F_X_V_M4_MASK, PseudoVFCVT_F_X_V_M4, 0x2 }, // 298
  { PseudoVFCVT_F_X_V_M8_MASK, PseudoVFCVT_F_X_V_M8, 0x2 }, // 299
  { PseudoVFCVT_F_X_V_MF2_MASK, PseudoVFCVT_F_X_V_MF2, 0x2 }, // 300
  { PseudoVFCVT_F_X_V_MF4_MASK, PseudoVFCVT_F_X_V_MF4, 0x2 }, // 301
  { PseudoVFCVT_RM_F_XU_V_M1_MASK, PseudoVFCVT_RM_F_XU_V_M1, 0x2 }, // 302
  { PseudoVFCVT_RM_F_XU_V_M2_MASK, PseudoVFCVT_RM_F_XU_V_M2, 0x2 }, // 303
  { PseudoVFCVT_RM_F_XU_V_M4_MASK, PseudoVFCVT_RM_F_XU_V_M4, 0x2 }, // 304
  { PseudoVFCVT_RM_F_XU_V_M8_MASK, PseudoVFCVT_RM_F_XU_V_M8, 0x2 }, // 305
  { PseudoVFCVT_RM_F_XU_V_MF2_MASK, PseudoVFCVT_RM_F_XU_V_MF2, 0x2 }, // 306
  { PseudoVFCVT_RM_F_XU_V_MF4_MASK, PseudoVFCVT_RM_F_XU_V_MF4, 0x2 }, // 307
  { PseudoVFCVT_RM_F_X_V_M1_MASK, PseudoVFCVT_RM_F_X_V_M1, 0x2 }, // 308
  { PseudoVFCVT_RM_F_X_V_M2_MASK, PseudoVFCVT_RM_F_X_V_M2, 0x2 }, // 309
  { PseudoVFCVT_RM_F_X_V_M4_MASK, PseudoVFCVT_RM_F_X_V_M4, 0x2 }, // 310
  { PseudoVFCVT_RM_F_X_V_M8_MASK, PseudoVFCVT_RM_F_X_V_M8, 0x2 }, // 311
  { PseudoVFCVT_RM_F_X_V_MF2_MASK, PseudoVFCVT_RM_F_X_V_MF2, 0x2 }, // 312
  { PseudoVFCVT_RM_F_X_V_MF4_MASK, PseudoVFCVT_RM_F_X_V_MF4, 0x2 }, // 313
  { PseudoVFCVT_RM_XU_F_V_M1_MASK, PseudoVFCVT_RM_XU_F_V_M1, 0x2 }, // 314
  { PseudoVFCVT_RM_XU_F_V_M2_MASK, PseudoVFCVT_RM_XU_F_V_M2, 0x2 }, // 315
  { PseudoVFCVT_RM_XU_F_V_M4_MASK, PseudoVFCVT_RM_XU_F_V_M4, 0x2 }, // 316
  { PseudoVFCVT_RM_XU_F_V_M8_MASK, PseudoVFCVT_RM_XU_F_V_M8, 0x2 }, // 317
  { PseudoVFCVT_RM_XU_F_V_MF2_MASK, PseudoVFCVT_RM_XU_F_V_MF2, 0x2 }, // 318
  { PseudoVFCVT_RM_XU_F_V_MF4_MASK, PseudoVFCVT_RM_XU_F_V_MF4, 0x2 }, // 319
  { PseudoVFCVT_RM_X_F_V_M1_MASK, PseudoVFCVT_RM_X_F_V_M1, 0x2 }, // 320
  { PseudoVFCVT_RM_X_F_V_M2_MASK, PseudoVFCVT_RM_X_F_V_M2, 0x2 }, // 321
  { PseudoVFCVT_RM_X_F_V_M4_MASK, PseudoVFCVT_RM_X_F_V_M4, 0x2 }, // 322
  { PseudoVFCVT_RM_X_F_V_M8_MASK, PseudoVFCVT_RM_X_F_V_M8, 0x2 }, // 323
  { PseudoVFCVT_RM_X_F_V_MF2_MASK, PseudoVFCVT_RM_X_F_V_MF2, 0x2 }, // 324
  { PseudoVFCVT_RM_X_F_V_MF4_MASK, PseudoVFCVT_RM_X_F_V_MF4, 0x2 }, // 325
  { PseudoVFCVT_RTZ_XU_F_V_M1_MASK, PseudoVFCVT_RTZ_XU_F_V_M1, 0x2 }, // 326
  { PseudoVFCVT_RTZ_XU_F_V_M2_MASK, PseudoVFCVT_RTZ_XU_F_V_M2, 0x2 }, // 327
  { PseudoVFCVT_RTZ_XU_F_V_M4_MASK, PseudoVFCVT_RTZ_XU_F_V_M4, 0x2 }, // 328
  { PseudoVFCVT_RTZ_XU_F_V_M8_MASK, PseudoVFCVT_RTZ_XU_F_V_M8, 0x2 }, // 329
  { PseudoVFCVT_RTZ_XU_F_V_MF2_MASK, PseudoVFCVT_RTZ_XU_F_V_MF2, 0x2 }, // 330
  { PseudoVFCVT_RTZ_XU_F_V_MF4_MASK, PseudoVFCVT_RTZ_XU_F_V_MF4, 0x2 }, // 331
  { PseudoVFCVT_RTZ_X_F_V_M1_MASK, PseudoVFCVT_RTZ_X_F_V_M1, 0x2 }, // 332
  { PseudoVFCVT_RTZ_X_F_V_M2_MASK, PseudoVFCVT_RTZ_X_F_V_M2, 0x2 }, // 333
  { PseudoVFCVT_RTZ_X_F_V_M4_MASK, PseudoVFCVT_RTZ_X_F_V_M4, 0x2 }, // 334
  { PseudoVFCVT_RTZ_X_F_V_M8_MASK, PseudoVFCVT_RTZ_X_F_V_M8, 0x2 }, // 335
  { PseudoVFCVT_RTZ_X_F_V_MF2_MASK, PseudoVFCVT_RTZ_X_F_V_MF2, 0x2 }, // 336
  { PseudoVFCVT_RTZ_X_F_V_MF4_MASK, PseudoVFCVT_RTZ_X_F_V_MF4, 0x2 }, // 337
  { PseudoVFCVT_XU_F_V_M1_MASK, PseudoVFCVT_XU_F_V_M1, 0x2 }, // 338
  { PseudoVFCVT_XU_F_V_M2_MASK, PseudoVFCVT_XU_F_V_M2, 0x2 }, // 339
  { PseudoVFCVT_XU_F_V_M4_MASK, PseudoVFCVT_XU_F_V_M4, 0x2 }, // 340
  { PseudoVFCVT_XU_F_V_M8_MASK, PseudoVFCVT_XU_F_V_M8, 0x2 }, // 341
  { PseudoVFCVT_XU_F_V_MF2_MASK, PseudoVFCVT_XU_F_V_MF2, 0x2 }, // 342
  { PseudoVFCVT_XU_F_V_MF4_MASK, PseudoVFCVT_XU_F_V_MF4, 0x2 }, // 343
  { PseudoVFCVT_X_F_V_M1_MASK, PseudoVFCVT_X_F_V_M1, 0x2 }, // 344
  { PseudoVFCVT_X_F_V_M2_MASK, PseudoVFCVT_X_F_V_M2, 0x2 }, // 345
  { PseudoVFCVT_X_F_V_M4_MASK, PseudoVFCVT_X_F_V_M4, 0x2 }, // 346
  { PseudoVFCVT_X_F_V_M8_MASK, PseudoVFCVT_X_F_V_M8, 0x2 }, // 347
  { PseudoVFCVT_X_F_V_MF2_MASK, PseudoVFCVT_X_F_V_MF2, 0x2 }, // 348
  { PseudoVFCVT_X_F_V_MF4_MASK, PseudoVFCVT_X_F_V_MF4, 0x2 }, // 349
  { PseudoVFDIV_VF16_M1_E16_MASK, PseudoVFDIV_VF16_M1_E16, 0x3 }, // 350
  { PseudoVFDIV_VF16_M2_E16_MASK, PseudoVFDIV_VF16_M2_E16, 0x3 }, // 351
  { PseudoVFDIV_VF16_M4_E16_MASK, PseudoVFDIV_VF16_M4_E16, 0x3 }, // 352
  { PseudoVFDIV_VF16_M8_E16_MASK, PseudoVFDIV_VF16_M8_E16, 0x3 }, // 353
  { PseudoVFDIV_VF16_MF2_E16_MASK, PseudoVFDIV_VF16_MF2_E16, 0x3 }, // 354
  { PseudoVFDIV_VF16_MF4_E16_MASK, PseudoVFDIV_VF16_MF4_E16, 0x3 }, // 355
  { PseudoVFDIV_VF32_M1_E32_MASK, PseudoVFDIV_VF32_M1_E32, 0x3 }, // 356
  { PseudoVFDIV_VF32_M2_E32_MASK, PseudoVFDIV_VF32_M2_E32, 0x3 }, // 357
  { PseudoVFDIV_VF32_M4_E32_MASK, PseudoVFDIV_VF32_M4_E32, 0x3 }, // 358
  { PseudoVFDIV_VF32_M8_E32_MASK, PseudoVFDIV_VF32_M8_E32, 0x3 }, // 359
  { PseudoVFDIV_VF32_MF2_E32_MASK, PseudoVFDIV_VF32_MF2_E32, 0x3 }, // 360
  { PseudoVFDIV_VF64_M1_E64_MASK, PseudoVFDIV_VF64_M1_E64, 0x3 }, // 361
  { PseudoVFDIV_VF64_M2_E64_MASK, PseudoVFDIV_VF64_M2_E64, 0x3 }, // 362
  { PseudoVFDIV_VF64_M4_E64_MASK, PseudoVFDIV_VF64_M4_E64, 0x3 }, // 363
  { PseudoVFDIV_VF64_M8_E64_MASK, PseudoVFDIV_VF64_M8_E64, 0x3 }, // 364
  { PseudoVFDIV_VV_M1_E16_MASK, PseudoVFDIV_VV_M1_E16, 0x3 }, // 365
  { PseudoVFDIV_VV_M1_E32_MASK, PseudoVFDIV_VV_M1_E32, 0x3 }, // 366
  { PseudoVFDIV_VV_M1_E64_MASK, PseudoVFDIV_VV_M1_E64, 0x3 }, // 367
  { PseudoVFDIV_VV_M2_E16_MASK, PseudoVFDIV_VV_M2_E16, 0x3 }, // 368
  { PseudoVFDIV_VV_M2_E32_MASK, PseudoVFDIV_VV_M2_E32, 0x3 }, // 369
  { PseudoVFDIV_VV_M2_E64_MASK, PseudoVFDIV_VV_M2_E64, 0x3 }, // 370
  { PseudoVFDIV_VV_M4_E16_MASK, PseudoVFDIV_VV_M4_E16, 0x3 }, // 371
  { PseudoVFDIV_VV_M4_E32_MASK, PseudoVFDIV_VV_M4_E32, 0x3 }, // 372
  { PseudoVFDIV_VV_M4_E64_MASK, PseudoVFDIV_VV_M4_E64, 0x3 }, // 373
  { PseudoVFDIV_VV_M8_E16_MASK, PseudoVFDIV_VV_M8_E16, 0x3 }, // 374
  { PseudoVFDIV_VV_M8_E32_MASK, PseudoVFDIV_VV_M8_E32, 0x3 }, // 375
  { PseudoVFDIV_VV_M8_E64_MASK, PseudoVFDIV_VV_M8_E64, 0x3 }, // 376
  { PseudoVFDIV_VV_MF2_E16_MASK, PseudoVFDIV_VV_MF2_E16, 0x3 }, // 377
  { PseudoVFDIV_VV_MF2_E32_MASK, PseudoVFDIV_VV_MF2_E32, 0x3 }, // 378
  { PseudoVFDIV_VV_MF4_E16_MASK, PseudoVFDIV_VV_MF4_E16, 0x3 }, // 379
  { PseudoVFMACC_VF16_M1_MASK, PseudoVFMACC_VF16_M1, 0x3 }, // 380
  { PseudoVFMACC_VF16_M2_MASK, PseudoVFMACC_VF16_M2, 0x3 }, // 381
  { PseudoVFMACC_VF16_M4_MASK, PseudoVFMACC_VF16_M4, 0x3 }, // 382
  { PseudoVFMACC_VF16_M8_MASK, PseudoVFMACC_VF16_M8, 0x3 }, // 383
  { PseudoVFMACC_VF16_MF2_MASK, PseudoVFMACC_VF16_MF2, 0x3 }, // 384
  { PseudoVFMACC_VF16_MF4_MASK, PseudoVFMACC_VF16_MF4, 0x3 }, // 385
  { PseudoVFMACC_VF32_M1_MASK, PseudoVFMACC_VF32_M1, 0x3 }, // 386
  { PseudoVFMACC_VF32_M2_MASK, PseudoVFMACC_VF32_M2, 0x3 }, // 387
  { PseudoVFMACC_VF32_M4_MASK, PseudoVFMACC_VF32_M4, 0x3 }, // 388
  { PseudoVFMACC_VF32_M8_MASK, PseudoVFMACC_VF32_M8, 0x3 }, // 389
  { PseudoVFMACC_VF32_MF2_MASK, PseudoVFMACC_VF32_MF2, 0x3 }, // 390
  { PseudoVFMACC_VF64_M1_MASK, PseudoVFMACC_VF64_M1, 0x3 }, // 391
  { PseudoVFMACC_VF64_M2_MASK, PseudoVFMACC_VF64_M2, 0x3 }, // 392
  { PseudoVFMACC_VF64_M4_MASK, PseudoVFMACC_VF64_M4, 0x3 }, // 393
  { PseudoVFMACC_VF64_M8_MASK, PseudoVFMACC_VF64_M8, 0x3 }, // 394
  { PseudoVFMACC_VV_M1_MASK, PseudoVFMACC_VV_M1, 0x3 }, // 395
  { PseudoVFMACC_VV_M2_MASK, PseudoVFMACC_VV_M2, 0x3 }, // 396
  { PseudoVFMACC_VV_M4_MASK, PseudoVFMACC_VV_M4, 0x3 }, // 397
  { PseudoVFMACC_VV_M8_MASK, PseudoVFMACC_VV_M8, 0x3 }, // 398
  { PseudoVFMACC_VV_MF2_MASK, PseudoVFMACC_VV_MF2, 0x3 }, // 399
  { PseudoVFMACC_VV_MF4_MASK, PseudoVFMACC_VV_MF4, 0x3 }, // 400
  { PseudoVFMADD_VF16_M1_MASK, PseudoVFMADD_VF16_M1, 0x3 }, // 401
  { PseudoVFMADD_VF16_M2_MASK, PseudoVFMADD_VF16_M2, 0x3 }, // 402
  { PseudoVFMADD_VF16_M4_MASK, PseudoVFMADD_VF16_M4, 0x3 }, // 403
  { PseudoVFMADD_VF16_M8_MASK, PseudoVFMADD_VF16_M8, 0x3 }, // 404
  { PseudoVFMADD_VF16_MF2_MASK, PseudoVFMADD_VF16_MF2, 0x3 }, // 405
  { PseudoVFMADD_VF16_MF4_MASK, PseudoVFMADD_VF16_MF4, 0x3 }, // 406
  { PseudoVFMADD_VF32_M1_MASK, PseudoVFMADD_VF32_M1, 0x3 }, // 407
  { PseudoVFMADD_VF32_M2_MASK, PseudoVFMADD_VF32_M2, 0x3 }, // 408
  { PseudoVFMADD_VF32_M4_MASK, PseudoVFMADD_VF32_M4, 0x3 }, // 409
  { PseudoVFMADD_VF32_M8_MASK, PseudoVFMADD_VF32_M8, 0x3 }, // 410
  { PseudoVFMADD_VF32_MF2_MASK, PseudoVFMADD_VF32_MF2, 0x3 }, // 411
  { PseudoVFMADD_VF64_M1_MASK, PseudoVFMADD_VF64_M1, 0x3 }, // 412
  { PseudoVFMADD_VF64_M2_MASK, PseudoVFMADD_VF64_M2, 0x3 }, // 413
  { PseudoVFMADD_VF64_M4_MASK, PseudoVFMADD_VF64_M4, 0x3 }, // 414
  { PseudoVFMADD_VF64_M8_MASK, PseudoVFMADD_VF64_M8, 0x3 }, // 415
  { PseudoVFMADD_VV_M1_MASK, PseudoVFMADD_VV_M1, 0x3 }, // 416
  { PseudoVFMADD_VV_M2_MASK, PseudoVFMADD_VV_M2, 0x3 }, // 417
  { PseudoVFMADD_VV_M4_MASK, PseudoVFMADD_VV_M4, 0x3 }, // 418
  { PseudoVFMADD_VV_M8_MASK, PseudoVFMADD_VV_M8, 0x3 }, // 419
  { PseudoVFMADD_VV_MF2_MASK, PseudoVFMADD_VV_MF2, 0x3 }, // 420
  { PseudoVFMADD_VV_MF4_MASK, PseudoVFMADD_VV_MF4, 0x3 }, // 421
  { PseudoVFMAX_VF16_M1_MASK, PseudoVFMAX_VF16_M1, 0x3 }, // 422
  { PseudoVFMAX_VF16_M2_MASK, PseudoVFMAX_VF16_M2, 0x3 }, // 423
  { PseudoVFMAX_VF16_M4_MASK, PseudoVFMAX_VF16_M4, 0x3 }, // 424
  { PseudoVFMAX_VF16_M8_MASK, PseudoVFMAX_VF16_M8, 0x3 }, // 425
  { PseudoVFMAX_VF16_MF2_MASK, PseudoVFMAX_VF16_MF2, 0x3 }, // 426
  { PseudoVFMAX_VF16_MF4_MASK, PseudoVFMAX_VF16_MF4, 0x3 }, // 427
  { PseudoVFMAX_VF32_M1_MASK, PseudoVFMAX_VF32_M1, 0x3 }, // 428
  { PseudoVFMAX_VF32_M2_MASK, PseudoVFMAX_VF32_M2, 0x3 }, // 429
  { PseudoVFMAX_VF32_M4_MASK, PseudoVFMAX_VF32_M4, 0x3 }, // 430
  { PseudoVFMAX_VF32_M8_MASK, PseudoVFMAX_VF32_M8, 0x3 }, // 431
  { PseudoVFMAX_VF32_MF2_MASK, PseudoVFMAX_VF32_MF2, 0x3 }, // 432
  { PseudoVFMAX_VF64_M1_MASK, PseudoVFMAX_VF64_M1, 0x3 }, // 433
  { PseudoVFMAX_VF64_M2_MASK, PseudoVFMAX_VF64_M2, 0x3 }, // 434
  { PseudoVFMAX_VF64_M4_MASK, PseudoVFMAX_VF64_M4, 0x3 }, // 435
  { PseudoVFMAX_VF64_M8_MASK, PseudoVFMAX_VF64_M8, 0x3 }, // 436
  { PseudoVFMAX_VV_M1_MASK, PseudoVFMAX_VV_M1, 0x3 }, // 437
  { PseudoVFMAX_VV_M2_MASK, PseudoVFMAX_VV_M2, 0x3 }, // 438
  { PseudoVFMAX_VV_M4_MASK, PseudoVFMAX_VV_M4, 0x3 }, // 439
  { PseudoVFMAX_VV_M8_MASK, PseudoVFMAX_VV_M8, 0x3 }, // 440
  { PseudoVFMAX_VV_MF2_MASK, PseudoVFMAX_VV_MF2, 0x3 }, // 441
  { PseudoVFMAX_VV_MF4_MASK, PseudoVFMAX_VV_MF4, 0x3 }, // 442
  { PseudoVFMIN_VF16_M1_MASK, PseudoVFMIN_VF16_M1, 0x3 }, // 443
  { PseudoVFMIN_VF16_M2_MASK, PseudoVFMIN_VF16_M2, 0x3 }, // 444
  { PseudoVFMIN_VF16_M4_MASK, PseudoVFMIN_VF16_M4, 0x3 }, // 445
  { PseudoVFMIN_VF16_M8_MASK, PseudoVFMIN_VF16_M8, 0x3 }, // 446
  { PseudoVFMIN_VF16_MF2_MASK, PseudoVFMIN_VF16_MF2, 0x3 }, // 447
  { PseudoVFMIN_VF16_MF4_MASK, PseudoVFMIN_VF16_MF4, 0x3 }, // 448
  { PseudoVFMIN_VF32_M1_MASK, PseudoVFMIN_VF32_M1, 0x3 }, // 449
  { PseudoVFMIN_VF32_M2_MASK, PseudoVFMIN_VF32_M2, 0x3 }, // 450
  { PseudoVFMIN_VF32_M4_MASK, PseudoVFMIN_VF32_M4, 0x3 }, // 451
  { PseudoVFMIN_VF32_M8_MASK, PseudoVFMIN_VF32_M8, 0x3 }, // 452
  { PseudoVFMIN_VF32_MF2_MASK, PseudoVFMIN_VF32_MF2, 0x3 }, // 453
  { PseudoVFMIN_VF64_M1_MASK, PseudoVFMIN_VF64_M1, 0x3 }, // 454
  { PseudoVFMIN_VF64_M2_MASK, PseudoVFMIN_VF64_M2, 0x3 }, // 455
  { PseudoVFMIN_VF64_M4_MASK, PseudoVFMIN_VF64_M4, 0x3 }, // 456
  { PseudoVFMIN_VF64_M8_MASK, PseudoVFMIN_VF64_M8, 0x3 }, // 457
  { PseudoVFMIN_VV_M1_MASK, PseudoVFMIN_VV_M1, 0x3 }, // 458
  { PseudoVFMIN_VV_M2_MASK, PseudoVFMIN_VV_M2, 0x3 }, // 459
  { PseudoVFMIN_VV_M4_MASK, PseudoVFMIN_VV_M4, 0x3 }, // 460
  { PseudoVFMIN_VV_M8_MASK, PseudoVFMIN_VV_M8, 0x3 }, // 461
  { PseudoVFMIN_VV_MF2_MASK, PseudoVFMIN_VV_MF2, 0x3 }, // 462
  { PseudoVFMIN_VV_MF4_MASK, PseudoVFMIN_VV_MF4, 0x3 }, // 463
  { PseudoVFMSAC_VF16_M1_MASK, PseudoVFMSAC_VF16_M1, 0x3 }, // 464
  { PseudoVFMSAC_VF16_M2_MASK, PseudoVFMSAC_VF16_M2, 0x3 }, // 465
  { PseudoVFMSAC_VF16_M4_MASK, PseudoVFMSAC_VF16_M4, 0x3 }, // 466
  { PseudoVFMSAC_VF16_M8_MASK, PseudoVFMSAC_VF16_M8, 0x3 }, // 467
  { PseudoVFMSAC_VF16_MF2_MASK, PseudoVFMSAC_VF16_MF2, 0x3 }, // 468
  { PseudoVFMSAC_VF16_MF4_MASK, PseudoVFMSAC_VF16_MF4, 0x3 }, // 469
  { PseudoVFMSAC_VF32_M1_MASK, PseudoVFMSAC_VF32_M1, 0x3 }, // 470
  { PseudoVFMSAC_VF32_M2_MASK, PseudoVFMSAC_VF32_M2, 0x3 }, // 471
  { PseudoVFMSAC_VF32_M4_MASK, PseudoVFMSAC_VF32_M4, 0x3 }, // 472
  { PseudoVFMSAC_VF32_M8_MASK, PseudoVFMSAC_VF32_M8, 0x3 }, // 473
  { PseudoVFMSAC_VF32_MF2_MASK, PseudoVFMSAC_VF32_MF2, 0x3 }, // 474
  { PseudoVFMSAC_VF64_M1_MASK, PseudoVFMSAC_VF64_M1, 0x3 }, // 475
  { PseudoVFMSAC_VF64_M2_MASK, PseudoVFMSAC_VF64_M2, 0x3 }, // 476
  { PseudoVFMSAC_VF64_M4_MASK, PseudoVFMSAC_VF64_M4, 0x3 }, // 477
  { PseudoVFMSAC_VF64_M8_MASK, PseudoVFMSAC_VF64_M8, 0x3 }, // 478
  { PseudoVFMSAC_VV_M1_MASK, PseudoVFMSAC_VV_M1, 0x3 }, // 479
  { PseudoVFMSAC_VV_M2_MASK, PseudoVFMSAC_VV_M2, 0x3 }, // 480
  { PseudoVFMSAC_VV_M4_MASK, PseudoVFMSAC_VV_M4, 0x3 }, // 481
  { PseudoVFMSAC_VV_M8_MASK, PseudoVFMSAC_VV_M8, 0x3 }, // 482
  { PseudoVFMSAC_VV_MF2_MASK, PseudoVFMSAC_VV_MF2, 0x3 }, // 483
  { PseudoVFMSAC_VV_MF4_MASK, PseudoVFMSAC_VV_MF4, 0x3 }, // 484
  { PseudoVFMSUB_VF16_M1_MASK, PseudoVFMSUB_VF16_M1, 0x3 }, // 485
  { PseudoVFMSUB_VF16_M2_MASK, PseudoVFMSUB_VF16_M2, 0x3 }, // 486
  { PseudoVFMSUB_VF16_M4_MASK, PseudoVFMSUB_VF16_M4, 0x3 }, // 487
  { PseudoVFMSUB_VF16_M8_MASK, PseudoVFMSUB_VF16_M8, 0x3 }, // 488
  { PseudoVFMSUB_VF16_MF2_MASK, PseudoVFMSUB_VF16_MF2, 0x3 }, // 489
  { PseudoVFMSUB_VF16_MF4_MASK, PseudoVFMSUB_VF16_MF4, 0x3 }, // 490
  { PseudoVFMSUB_VF32_M1_MASK, PseudoVFMSUB_VF32_M1, 0x3 }, // 491
  { PseudoVFMSUB_VF32_M2_MASK, PseudoVFMSUB_VF32_M2, 0x3 }, // 492
  { PseudoVFMSUB_VF32_M4_MASK, PseudoVFMSUB_VF32_M4, 0x3 }, // 493
  { PseudoVFMSUB_VF32_M8_MASK, PseudoVFMSUB_VF32_M8, 0x3 }, // 494
  { PseudoVFMSUB_VF32_MF2_MASK, PseudoVFMSUB_VF32_MF2, 0x3 }, // 495
  { PseudoVFMSUB_VF64_M1_MASK, PseudoVFMSUB_VF64_M1, 0x3 }, // 496
  { PseudoVFMSUB_VF64_M2_MASK, PseudoVFMSUB_VF64_M2, 0x3 }, // 497
  { PseudoVFMSUB_VF64_M4_MASK, PseudoVFMSUB_VF64_M4, 0x3 }, // 498
  { PseudoVFMSUB_VF64_M8_MASK, PseudoVFMSUB_VF64_M8, 0x3 }, // 499
  { PseudoVFMSUB_VV_M1_MASK, PseudoVFMSUB_VV_M1, 0x3 }, // 500
  { PseudoVFMSUB_VV_M2_MASK, PseudoVFMSUB_VV_M2, 0x3 }, // 501
  { PseudoVFMSUB_VV_M4_MASK, PseudoVFMSUB_VV_M4, 0x3 }, // 502
  { PseudoVFMSUB_VV_M8_MASK, PseudoVFMSUB_VV_M8, 0x3 }, // 503
  { PseudoVFMSUB_VV_MF2_MASK, PseudoVFMSUB_VV_MF2, 0x3 }, // 504
  { PseudoVFMSUB_VV_MF4_MASK, PseudoVFMSUB_VV_MF4, 0x3 }, // 505
  { PseudoVFMUL_VF16_M1_MASK, PseudoVFMUL_VF16_M1, 0x3 }, // 506
  { PseudoVFMUL_VF16_M2_MASK, PseudoVFMUL_VF16_M2, 0x3 }, // 507
  { PseudoVFMUL_VF16_M4_MASK, PseudoVFMUL_VF16_M4, 0x3 }, // 508
  { PseudoVFMUL_VF16_M8_MASK, PseudoVFMUL_VF16_M8, 0x3 }, // 509
  { PseudoVFMUL_VF16_MF2_MASK, PseudoVFMUL_VF16_MF2, 0x3 }, // 510
  { PseudoVFMUL_VF16_MF4_MASK, PseudoVFMUL_VF16_MF4, 0x3 }, // 511
  { PseudoVFMUL_VF32_M1_MASK, PseudoVFMUL_VF32_M1, 0x3 }, // 512
  { PseudoVFMUL_VF32_M2_MASK, PseudoVFMUL_VF32_M2, 0x3 }, // 513
  { PseudoVFMUL_VF32_M4_MASK, PseudoVFMUL_VF32_M4, 0x3 }, // 514
  { PseudoVFMUL_VF32_M8_MASK, PseudoVFMUL_VF32_M8, 0x3 }, // 515
  { PseudoVFMUL_VF32_MF2_MASK, PseudoVFMUL_VF32_MF2, 0x3 }, // 516
  { PseudoVFMUL_VF64_M1_MASK, PseudoVFMUL_VF64_M1, 0x3 }, // 517
  { PseudoVFMUL_VF64_M2_MASK, PseudoVFMUL_VF64_M2, 0x3 }, // 518
  { PseudoVFMUL_VF64_M4_MASK, PseudoVFMUL_VF64_M4, 0x3 }, // 519
  { PseudoVFMUL_VF64_M8_MASK, PseudoVFMUL_VF64_M8, 0x3 }, // 520
  { PseudoVFMUL_VV_M1_MASK, PseudoVFMUL_VV_M1, 0x3 }, // 521
  { PseudoVFMUL_VV_M2_MASK, PseudoVFMUL_VV_M2, 0x3 }, // 522
  { PseudoVFMUL_VV_M4_MASK, PseudoVFMUL_VV_M4, 0x3 }, // 523
  { PseudoVFMUL_VV_M8_MASK, PseudoVFMUL_VV_M8, 0x3 }, // 524
  { PseudoVFMUL_VV_MF2_MASK, PseudoVFMUL_VV_MF2, 0x3 }, // 525
  { PseudoVFMUL_VV_MF4_MASK, PseudoVFMUL_VV_MF4, 0x3 }, // 526
  { PseudoVFNCVT_F_F_W_M1_MASK, PseudoVFNCVT_F_F_W_M1, 0x2 }, // 527
  { PseudoVFNCVT_F_F_W_M2_MASK, PseudoVFNCVT_F_F_W_M2, 0x2 }, // 528
  { PseudoVFNCVT_F_F_W_M4_MASK, PseudoVFNCVT_F_F_W_M4, 0x2 }, // 529
  { PseudoVFNCVT_F_F_W_MF2_MASK, PseudoVFNCVT_F_F_W_MF2, 0x2 }, // 530
  { PseudoVFNCVT_F_F_W_MF4_MASK, PseudoVFNCVT_F_F_W_MF4, 0x2 }, // 531
  { PseudoVFNCVT_F_XU_W_M1_MASK, PseudoVFNCVT_F_XU_W_M1, 0x2 }, // 532
  { PseudoVFNCVT_F_XU_W_M2_MASK, PseudoVFNCVT_F_XU_W_M2, 0x2 }, // 533
  { PseudoVFNCVT_F_XU_W_M4_MASK, PseudoVFNCVT_F_XU_W_M4, 0x2 }, // 534
  { PseudoVFNCVT_F_XU_W_MF2_MASK, PseudoVFNCVT_F_XU_W_MF2, 0x2 }, // 535
  { PseudoVFNCVT_F_XU_W_MF4_MASK, PseudoVFNCVT_F_XU_W_MF4, 0x2 }, // 536
  { PseudoVFNCVT_F_X_W_M1_MASK, PseudoVFNCVT_F_X_W_M1, 0x2 }, // 537
  { PseudoVFNCVT_F_X_W_M2_MASK, PseudoVFNCVT_F_X_W_M2, 0x2 }, // 538
  { PseudoVFNCVT_F_X_W_M4_MASK, PseudoVFNCVT_F_X_W_M4, 0x2 }, // 539
  { PseudoVFNCVT_F_X_W_MF2_MASK, PseudoVFNCVT_F_X_W_MF2, 0x2 }, // 540
  { PseudoVFNCVT_F_X_W_MF4_MASK, PseudoVFNCVT_F_X_W_MF4, 0x2 }, // 541
  { PseudoVFNCVT_RM_F_XU_W_M1_MASK, PseudoVFNCVT_RM_F_XU_W_M1, 0x2 }, // 542
  { PseudoVFNCVT_RM_F_XU_W_M2_MASK, PseudoVFNCVT_RM_F_XU_W_M2, 0x2 }, // 543
  { PseudoVFNCVT_RM_F_XU_W_M4_MASK, PseudoVFNCVT_RM_F_XU_W_M4, 0x2 }, // 544
  { PseudoVFNCVT_RM_F_XU_W_MF2_MASK, PseudoVFNCVT_RM_F_XU_W_MF2, 0x2 }, // 545
  { PseudoVFNCVT_RM_F_XU_W_MF4_MASK, PseudoVFNCVT_RM_F_XU_W_MF4, 0x2 }, // 546
  { PseudoVFNCVT_RM_F_X_W_M1_MASK, PseudoVFNCVT_RM_F_X_W_M1, 0x2 }, // 547
  { PseudoVFNCVT_RM_F_X_W_M2_MASK, PseudoVFNCVT_RM_F_X_W_M2, 0x2 }, // 548
  { PseudoVFNCVT_RM_F_X_W_M4_MASK, PseudoVFNCVT_RM_F_X_W_M4, 0x2 }, // 549
  { PseudoVFNCVT_RM_F_X_W_MF2_MASK, PseudoVFNCVT_RM_F_X_W_MF2, 0x2 }, // 550
  { PseudoVFNCVT_RM_F_X_W_MF4_MASK, PseudoVFNCVT_RM_F_X_W_MF4, 0x2 }, // 551
  { PseudoVFNCVT_RM_XU_F_W_M1_MASK, PseudoVFNCVT_RM_XU_F_W_M1, 0x2 }, // 552
  { PseudoVFNCVT_RM_XU_F_W_M2_MASK, PseudoVFNCVT_RM_XU_F_W_M2, 0x2 }, // 553
  { PseudoVFNCVT_RM_XU_F_W_M4_MASK, PseudoVFNCVT_RM_XU_F_W_M4, 0x2 }, // 554
  { PseudoVFNCVT_RM_XU_F_W_MF2_MASK, PseudoVFNCVT_RM_XU_F_W_MF2, 0x2 }, // 555
  { PseudoVFNCVT_RM_XU_F_W_MF4_MASK, PseudoVFNCVT_RM_XU_F_W_MF4, 0x2 }, // 556
  { PseudoVFNCVT_RM_XU_F_W_MF8_MASK, PseudoVFNCVT_RM_XU_F_W_MF8, 0x2 }, // 557
  { PseudoVFNCVT_RM_X_F_W_M1_MASK, PseudoVFNCVT_RM_X_F_W_M1, 0x2 }, // 558
  { PseudoVFNCVT_RM_X_F_W_M2_MASK, PseudoVFNCVT_RM_X_F_W_M2, 0x2 }, // 559
  { PseudoVFNCVT_RM_X_F_W_M4_MASK, PseudoVFNCVT_RM_X_F_W_M4, 0x2 }, // 560
  { PseudoVFNCVT_RM_X_F_W_MF2_MASK, PseudoVFNCVT_RM_X_F_W_MF2, 0x2 }, // 561
  { PseudoVFNCVT_RM_X_F_W_MF4_MASK, PseudoVFNCVT_RM_X_F_W_MF4, 0x2 }, // 562
  { PseudoVFNCVT_RM_X_F_W_MF8_MASK, PseudoVFNCVT_RM_X_F_W_MF8, 0x2 }, // 563
  { PseudoVFNCVT_ROD_F_F_W_M1_MASK, PseudoVFNCVT_ROD_F_F_W_M1, 0x2 }, // 564
  { PseudoVFNCVT_ROD_F_F_W_M2_MASK, PseudoVFNCVT_ROD_F_F_W_M2, 0x2 }, // 565
  { PseudoVFNCVT_ROD_F_F_W_M4_MASK, PseudoVFNCVT_ROD_F_F_W_M4, 0x2 }, // 566
  { PseudoVFNCVT_ROD_F_F_W_MF2_MASK, PseudoVFNCVT_ROD_F_F_W_MF2, 0x2 }, // 567
  { PseudoVFNCVT_ROD_F_F_W_MF4_MASK, PseudoVFNCVT_ROD_F_F_W_MF4, 0x2 }, // 568
  { PseudoVFNCVT_RTZ_XU_F_W_M1_MASK, PseudoVFNCVT_RTZ_XU_F_W_M1, 0x2 }, // 569
  { PseudoVFNCVT_RTZ_XU_F_W_M2_MASK, PseudoVFNCVT_RTZ_XU_F_W_M2, 0x2 }, // 570
  { PseudoVFNCVT_RTZ_XU_F_W_M4_MASK, PseudoVFNCVT_RTZ_XU_F_W_M4, 0x2 }, // 571
  { PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF2, 0x2 }, // 572
  { PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF4, 0x2 }, // 573
  { PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF8, 0x2 }, // 574
  { PseudoVFNCVT_RTZ_X_F_W_M1_MASK, PseudoVFNCVT_RTZ_X_F_W_M1, 0x2 }, // 575
  { PseudoVFNCVT_RTZ_X_F_W_M2_MASK, PseudoVFNCVT_RTZ_X_F_W_M2, 0x2 }, // 576
  { PseudoVFNCVT_RTZ_X_F_W_M4_MASK, PseudoVFNCVT_RTZ_X_F_W_M4, 0x2 }, // 577
  { PseudoVFNCVT_RTZ_X_F_W_MF2_MASK, PseudoVFNCVT_RTZ_X_F_W_MF2, 0x2 }, // 578
  { PseudoVFNCVT_RTZ_X_F_W_MF4_MASK, PseudoVFNCVT_RTZ_X_F_W_MF4, 0x2 }, // 579
  { PseudoVFNCVT_RTZ_X_F_W_MF8_MASK, PseudoVFNCVT_RTZ_X_F_W_MF8, 0x2 }, // 580
  { PseudoVFNCVT_XU_F_W_M1_MASK, PseudoVFNCVT_XU_F_W_M1, 0x2 }, // 581
  { PseudoVFNCVT_XU_F_W_M2_MASK, PseudoVFNCVT_XU_F_W_M2, 0x2 }, // 582
  { PseudoVFNCVT_XU_F_W_M4_MASK, PseudoVFNCVT_XU_F_W_M4, 0x2 }, // 583
  { PseudoVFNCVT_XU_F_W_MF2_MASK, PseudoVFNCVT_XU_F_W_MF2, 0x2 }, // 584
  { PseudoVFNCVT_XU_F_W_MF4_MASK, PseudoVFNCVT_XU_F_W_MF4, 0x2 }, // 585
  { PseudoVFNCVT_XU_F_W_MF8_MASK, PseudoVFNCVT_XU_F_W_MF8, 0x2 }, // 586
  { PseudoVFNCVT_X_F_W_M1_MASK, PseudoVFNCVT_X_F_W_M1, 0x2 }, // 587
  { PseudoVFNCVT_X_F_W_M2_MASK, PseudoVFNCVT_X_F_W_M2, 0x2 }, // 588
  { PseudoVFNCVT_X_F_W_M4_MASK, PseudoVFNCVT_X_F_W_M4, 0x2 }, // 589
  { PseudoVFNCVT_X_F_W_MF2_MASK, PseudoVFNCVT_X_F_W_MF2, 0x2 }, // 590
  { PseudoVFNCVT_X_F_W_MF4_MASK, PseudoVFNCVT_X_F_W_MF4, 0x2 }, // 591
  { PseudoVFNCVT_X_F_W_MF8_MASK, PseudoVFNCVT_X_F_W_MF8, 0x2 }, // 592
  { PseudoVFNMACC_VF16_M1_MASK, PseudoVFNMACC_VF16_M1, 0x3 }, // 593
  { PseudoVFNMACC_VF16_M2_MASK, PseudoVFNMACC_VF16_M2, 0x3 }, // 594
  { PseudoVFNMACC_VF16_M4_MASK, PseudoVFNMACC_VF16_M4, 0x3 }, // 595
  { PseudoVFNMACC_VF16_M8_MASK, PseudoVFNMACC_VF16_M8, 0x3 }, // 596
  { PseudoVFNMACC_VF16_MF2_MASK, PseudoVFNMACC_VF16_MF2, 0x3 }, // 597
  { PseudoVFNMACC_VF16_MF4_MASK, PseudoVFNMACC_VF16_MF4, 0x3 }, // 598
  { PseudoVFNMACC_VF32_M1_MASK, PseudoVFNMACC_VF32_M1, 0x3 }, // 599
  { PseudoVFNMACC_VF32_M2_MASK, PseudoVFNMACC_VF32_M2, 0x3 }, // 600
  { PseudoVFNMACC_VF32_M4_MASK, PseudoVFNMACC_VF32_M4, 0x3 }, // 601
  { PseudoVFNMACC_VF32_M8_MASK, PseudoVFNMACC_VF32_M8, 0x3 }, // 602
  { PseudoVFNMACC_VF32_MF2_MASK, PseudoVFNMACC_VF32_MF2, 0x3 }, // 603
  { PseudoVFNMACC_VF64_M1_MASK, PseudoVFNMACC_VF64_M1, 0x3 }, // 604
  { PseudoVFNMACC_VF64_M2_MASK, PseudoVFNMACC_VF64_M2, 0x3 }, // 605
  { PseudoVFNMACC_VF64_M4_MASK, PseudoVFNMACC_VF64_M4, 0x3 }, // 606
  { PseudoVFNMACC_VF64_M8_MASK, PseudoVFNMACC_VF64_M8, 0x3 }, // 607
  { PseudoVFNMACC_VV_M1_MASK, PseudoVFNMACC_VV_M1, 0x3 }, // 608
  { PseudoVFNMACC_VV_M2_MASK, PseudoVFNMACC_VV_M2, 0x3 }, // 609
  { PseudoVFNMACC_VV_M4_MASK, PseudoVFNMACC_VV_M4, 0x3 }, // 610
  { PseudoVFNMACC_VV_M8_MASK, PseudoVFNMACC_VV_M8, 0x3 }, // 611
  { PseudoVFNMACC_VV_MF2_MASK, PseudoVFNMACC_VV_MF2, 0x3 }, // 612
  { PseudoVFNMACC_VV_MF4_MASK, PseudoVFNMACC_VV_MF4, 0x3 }, // 613
  { PseudoVFNMADD_VF16_M1_MASK, PseudoVFNMADD_VF16_M1, 0x3 }, // 614
  { PseudoVFNMADD_VF16_M2_MASK, PseudoVFNMADD_VF16_M2, 0x3 }, // 615
  { PseudoVFNMADD_VF16_M4_MASK, PseudoVFNMADD_VF16_M4, 0x3 }, // 616
  { PseudoVFNMADD_VF16_M8_MASK, PseudoVFNMADD_VF16_M8, 0x3 }, // 617
  { PseudoVFNMADD_VF16_MF2_MASK, PseudoVFNMADD_VF16_MF2, 0x3 }, // 618
  { PseudoVFNMADD_VF16_MF4_MASK, PseudoVFNMADD_VF16_MF4, 0x3 }, // 619
  { PseudoVFNMADD_VF32_M1_MASK, PseudoVFNMADD_VF32_M1, 0x3 }, // 620
  { PseudoVFNMADD_VF32_M2_MASK, PseudoVFNMADD_VF32_M2, 0x3 }, // 621
  { PseudoVFNMADD_VF32_M4_MASK, PseudoVFNMADD_VF32_M4, 0x3 }, // 622
  { PseudoVFNMADD_VF32_M8_MASK, PseudoVFNMADD_VF32_M8, 0x3 }, // 623
  { PseudoVFNMADD_VF32_MF2_MASK, PseudoVFNMADD_VF32_MF2, 0x3 }, // 624
  { PseudoVFNMADD_VF64_M1_MASK, PseudoVFNMADD_VF64_M1, 0x3 }, // 625
  { PseudoVFNMADD_VF64_M2_MASK, PseudoVFNMADD_VF64_M2, 0x3 }, // 626
  { PseudoVFNMADD_VF64_M4_MASK, PseudoVFNMADD_VF64_M4, 0x3 }, // 627
  { PseudoVFNMADD_VF64_M8_MASK, PseudoVFNMADD_VF64_M8, 0x3 }, // 628
  { PseudoVFNMADD_VV_M1_MASK, PseudoVFNMADD_VV_M1, 0x3 }, // 629
  { PseudoVFNMADD_VV_M2_MASK, PseudoVFNMADD_VV_M2, 0x3 }, // 630
  { PseudoVFNMADD_VV_M4_MASK, PseudoVFNMADD_VV_M4, 0x3 }, // 631
  { PseudoVFNMADD_VV_M8_MASK, PseudoVFNMADD_VV_M8, 0x3 }, // 632
  { PseudoVFNMADD_VV_MF2_MASK, PseudoVFNMADD_VV_MF2, 0x3 }, // 633
  { PseudoVFNMADD_VV_MF4_MASK, PseudoVFNMADD_VV_MF4, 0x3 }, // 634
  { PseudoVFNMSAC_VF16_M1_MASK, PseudoVFNMSAC_VF16_M1, 0x3 }, // 635
  { PseudoVFNMSAC_VF16_M2_MASK, PseudoVFNMSAC_VF16_M2, 0x3 }, // 636
  { PseudoVFNMSAC_VF16_M4_MASK, PseudoVFNMSAC_VF16_M4, 0x3 }, // 637
  { PseudoVFNMSAC_VF16_M8_MASK, PseudoVFNMSAC_VF16_M8, 0x3 }, // 638
  { PseudoVFNMSAC_VF16_MF2_MASK, PseudoVFNMSAC_VF16_MF2, 0x3 }, // 639
  { PseudoVFNMSAC_VF16_MF4_MASK, PseudoVFNMSAC_VF16_MF4, 0x3 }, // 640
  { PseudoVFNMSAC_VF32_M1_MASK, PseudoVFNMSAC_VF32_M1, 0x3 }, // 641
  { PseudoVFNMSAC_VF32_M2_MASK, PseudoVFNMSAC_VF32_M2, 0x3 }, // 642
  { PseudoVFNMSAC_VF32_M4_MASK, PseudoVFNMSAC_VF32_M4, 0x3 }, // 643
  { PseudoVFNMSAC_VF32_M8_MASK, PseudoVFNMSAC_VF32_M8, 0x3 }, // 644
  { PseudoVFNMSAC_VF32_MF2_MASK, PseudoVFNMSAC_VF32_MF2, 0x3 }, // 645
  { PseudoVFNMSAC_VF64_M1_MASK, PseudoVFNMSAC_VF64_M1, 0x3 }, // 646
  { PseudoVFNMSAC_VF64_M2_MASK, PseudoVFNMSAC_VF64_M2, 0x3 }, // 647
  { PseudoVFNMSAC_VF64_M4_MASK, PseudoVFNMSAC_VF64_M4, 0x3 }, // 648
  { PseudoVFNMSAC_VF64_M8_MASK, PseudoVFNMSAC_VF64_M8, 0x3 }, // 649
  { PseudoVFNMSAC_VV_M1_MASK, PseudoVFNMSAC_VV_M1, 0x3 }, // 650
  { PseudoVFNMSAC_VV_M2_MASK, PseudoVFNMSAC_VV_M2, 0x3 }, // 651
  { PseudoVFNMSAC_VV_M4_MASK, PseudoVFNMSAC_VV_M4, 0x3 }, // 652
  { PseudoVFNMSAC_VV_M8_MASK, PseudoVFNMSAC_VV_M8, 0x3 }, // 653
  { PseudoVFNMSAC_VV_MF2_MASK, PseudoVFNMSAC_VV_MF2, 0x3 }, // 654
  { PseudoVFNMSAC_VV_MF4_MASK, PseudoVFNMSAC_VV_MF4, 0x3 }, // 655
  { PseudoVFNMSUB_VF16_M1_MASK, PseudoVFNMSUB_VF16_M1, 0x3 }, // 656
  { PseudoVFNMSUB_VF16_M2_MASK, PseudoVFNMSUB_VF16_M2, 0x3 }, // 657
  { PseudoVFNMSUB_VF16_M4_MASK, PseudoVFNMSUB_VF16_M4, 0x3 }, // 658
  { PseudoVFNMSUB_VF16_M8_MASK, PseudoVFNMSUB_VF16_M8, 0x3 }, // 659
  { PseudoVFNMSUB_VF16_MF2_MASK, PseudoVFNMSUB_VF16_MF2, 0x3 }, // 660
  { PseudoVFNMSUB_VF16_MF4_MASK, PseudoVFNMSUB_VF16_MF4, 0x3 }, // 661
  { PseudoVFNMSUB_VF32_M1_MASK, PseudoVFNMSUB_VF32_M1, 0x3 }, // 662
  { PseudoVFNMSUB_VF32_M2_MASK, PseudoVFNMSUB_VF32_M2, 0x3 }, // 663
  { PseudoVFNMSUB_VF32_M4_MASK, PseudoVFNMSUB_VF32_M4, 0x3 }, // 664
  { PseudoVFNMSUB_VF32_M8_MASK, PseudoVFNMSUB_VF32_M8, 0x3 }, // 665
  { PseudoVFNMSUB_VF32_MF2_MASK, PseudoVFNMSUB_VF32_MF2, 0x3 }, // 666
  { PseudoVFNMSUB_VF64_M1_MASK, PseudoVFNMSUB_VF64_M1, 0x3 }, // 667
  { PseudoVFNMSUB_VF64_M2_MASK, PseudoVFNMSUB_VF64_M2, 0x3 }, // 668
  { PseudoVFNMSUB_VF64_M4_MASK, PseudoVFNMSUB_VF64_M4, 0x3 }, // 669
  { PseudoVFNMSUB_VF64_M8_MASK, PseudoVFNMSUB_VF64_M8, 0x3 }, // 670
  { PseudoVFNMSUB_VV_M1_MASK, PseudoVFNMSUB_VV_M1, 0x3 }, // 671
  { PseudoVFNMSUB_VV_M2_MASK, PseudoVFNMSUB_VV_M2, 0x3 }, // 672
  { PseudoVFNMSUB_VV_M4_MASK, PseudoVFNMSUB_VV_M4, 0x3 }, // 673
  { PseudoVFNMSUB_VV_M8_MASK, PseudoVFNMSUB_VV_M8, 0x3 }, // 674
  { PseudoVFNMSUB_VV_MF2_MASK, PseudoVFNMSUB_VV_MF2, 0x3 }, // 675
  { PseudoVFNMSUB_VV_MF4_MASK, PseudoVFNMSUB_VV_MF4, 0x3 }, // 676
  { PseudoVFRDIV_VF16_M1_E16_MASK, PseudoVFRDIV_VF16_M1_E16, 0x3 }, // 677
  { PseudoVFRDIV_VF16_M2_E16_MASK, PseudoVFRDIV_VF16_M2_E16, 0x3 }, // 678
  { PseudoVFRDIV_VF16_M4_E16_MASK, PseudoVFRDIV_VF16_M4_E16, 0x3 }, // 679
  { PseudoVFRDIV_VF16_M8_E16_MASK, PseudoVFRDIV_VF16_M8_E16, 0x3 }, // 680
  { PseudoVFRDIV_VF16_MF2_E16_MASK, PseudoVFRDIV_VF16_MF2_E16, 0x3 }, // 681
  { PseudoVFRDIV_VF16_MF4_E16_MASK, PseudoVFRDIV_VF16_MF4_E16, 0x3 }, // 682
  { PseudoVFRDIV_VF32_M1_E32_MASK, PseudoVFRDIV_VF32_M1_E32, 0x3 }, // 683
  { PseudoVFRDIV_VF32_M2_E32_MASK, PseudoVFRDIV_VF32_M2_E32, 0x3 }, // 684
  { PseudoVFRDIV_VF32_M4_E32_MASK, PseudoVFRDIV_VF32_M4_E32, 0x3 }, // 685
  { PseudoVFRDIV_VF32_M8_E32_MASK, PseudoVFRDIV_VF32_M8_E32, 0x3 }, // 686
  { PseudoVFRDIV_VF32_MF2_E32_MASK, PseudoVFRDIV_VF32_MF2_E32, 0x3 }, // 687
  { PseudoVFRDIV_VF64_M1_E64_MASK, PseudoVFRDIV_VF64_M1_E64, 0x3 }, // 688
  { PseudoVFRDIV_VF64_M2_E64_MASK, PseudoVFRDIV_VF64_M2_E64, 0x3 }, // 689
  { PseudoVFRDIV_VF64_M4_E64_MASK, PseudoVFRDIV_VF64_M4_E64, 0x3 }, // 690
  { PseudoVFRDIV_VF64_M8_E64_MASK, PseudoVFRDIV_VF64_M8_E64, 0x3 }, // 691
  { PseudoVFREC7_V_M1_MASK, PseudoVFREC7_V_M1, 0x2 }, // 692
  { PseudoVFREC7_V_M2_MASK, PseudoVFREC7_V_M2, 0x2 }, // 693
  { PseudoVFREC7_V_M4_MASK, PseudoVFREC7_V_M4, 0x2 }, // 694
  { PseudoVFREC7_V_M8_MASK, PseudoVFREC7_V_M8, 0x2 }, // 695
  { PseudoVFREC7_V_MF2_MASK, PseudoVFREC7_V_MF2, 0x2 }, // 696
  { PseudoVFREC7_V_MF4_MASK, PseudoVFREC7_V_MF4, 0x2 }, // 697
  { PseudoVFRSQRT7_V_M1_MASK, PseudoVFRSQRT7_V_M1, 0x2 }, // 698
  { PseudoVFRSQRT7_V_M2_MASK, PseudoVFRSQRT7_V_M2, 0x2 }, // 699
  { PseudoVFRSQRT7_V_M4_MASK, PseudoVFRSQRT7_V_M4, 0x2 }, // 700
  { PseudoVFRSQRT7_V_M8_MASK, PseudoVFRSQRT7_V_M8, 0x2 }, // 701
  { PseudoVFRSQRT7_V_MF2_MASK, PseudoVFRSQRT7_V_MF2, 0x2 }, // 702
  { PseudoVFRSQRT7_V_MF4_MASK, PseudoVFRSQRT7_V_MF4, 0x2 }, // 703
  { PseudoVFRSUB_VF16_M1_MASK, PseudoVFRSUB_VF16_M1, 0x3 }, // 704
  { PseudoVFRSUB_VF16_M2_MASK, PseudoVFRSUB_VF16_M2, 0x3 }, // 705
  { PseudoVFRSUB_VF16_M4_MASK, PseudoVFRSUB_VF16_M4, 0x3 }, // 706
  { PseudoVFRSUB_VF16_M8_MASK, PseudoVFRSUB_VF16_M8, 0x3 }, // 707
  { PseudoVFRSUB_VF16_MF2_MASK, PseudoVFRSUB_VF16_MF2, 0x3 }, // 708
  { PseudoVFRSUB_VF16_MF4_MASK, PseudoVFRSUB_VF16_MF4, 0x3 }, // 709
  { PseudoVFRSUB_VF32_M1_MASK, PseudoVFRSUB_VF32_M1, 0x3 }, // 710
  { PseudoVFRSUB_VF32_M2_MASK, PseudoVFRSUB_VF32_M2, 0x3 }, // 711
  { PseudoVFRSUB_VF32_M4_MASK, PseudoVFRSUB_VF32_M4, 0x3 }, // 712
  { PseudoVFRSUB_VF32_M8_MASK, PseudoVFRSUB_VF32_M8, 0x3 }, // 713
  { PseudoVFRSUB_VF32_MF2_MASK, PseudoVFRSUB_VF32_MF2, 0x3 }, // 714
  { PseudoVFRSUB_VF64_M1_MASK, PseudoVFRSUB_VF64_M1, 0x3 }, // 715
  { PseudoVFRSUB_VF64_M2_MASK, PseudoVFRSUB_VF64_M2, 0x3 }, // 716
  { PseudoVFRSUB_VF64_M4_MASK, PseudoVFRSUB_VF64_M4, 0x3 }, // 717
  { PseudoVFRSUB_VF64_M8_MASK, PseudoVFRSUB_VF64_M8, 0x3 }, // 718
  { PseudoVFSGNJN_VF16_M1_MASK, PseudoVFSGNJN_VF16_M1, 0x3 }, // 719
  { PseudoVFSGNJN_VF16_M2_MASK, PseudoVFSGNJN_VF16_M2, 0x3 }, // 720
  { PseudoVFSGNJN_VF16_M4_MASK, PseudoVFSGNJN_VF16_M4, 0x3 }, // 721
  { PseudoVFSGNJN_VF16_M8_MASK, PseudoVFSGNJN_VF16_M8, 0x3 }, // 722
  { PseudoVFSGNJN_VF16_MF2_MASK, PseudoVFSGNJN_VF16_MF2, 0x3 }, // 723
  { PseudoVFSGNJN_VF16_MF4_MASK, PseudoVFSGNJN_VF16_MF4, 0x3 }, // 724
  { PseudoVFSGNJN_VF32_M1_MASK, PseudoVFSGNJN_VF32_M1, 0x3 }, // 725
  { PseudoVFSGNJN_VF32_M2_MASK, PseudoVFSGNJN_VF32_M2, 0x3 }, // 726
  { PseudoVFSGNJN_VF32_M4_MASK, PseudoVFSGNJN_VF32_M4, 0x3 }, // 727
  { PseudoVFSGNJN_VF32_M8_MASK, PseudoVFSGNJN_VF32_M8, 0x3 }, // 728
  { PseudoVFSGNJN_VF32_MF2_MASK, PseudoVFSGNJN_VF32_MF2, 0x3 }, // 729
  { PseudoVFSGNJN_VF64_M1_MASK, PseudoVFSGNJN_VF64_M1, 0x3 }, // 730
  { PseudoVFSGNJN_VF64_M2_MASK, PseudoVFSGNJN_VF64_M2, 0x3 }, // 731
  { PseudoVFSGNJN_VF64_M4_MASK, PseudoVFSGNJN_VF64_M4, 0x3 }, // 732
  { PseudoVFSGNJN_VF64_M8_MASK, PseudoVFSGNJN_VF64_M8, 0x3 }, // 733
  { PseudoVFSGNJN_VV_M1_MASK, PseudoVFSGNJN_VV_M1, 0x3 }, // 734
  { PseudoVFSGNJN_VV_M2_MASK, PseudoVFSGNJN_VV_M2, 0x3 }, // 735
  { PseudoVFSGNJN_VV_M4_MASK, PseudoVFSGNJN_VV_M4, 0x3 }, // 736
  { PseudoVFSGNJN_VV_M8_MASK, PseudoVFSGNJN_VV_M8, 0x3 }, // 737
  { PseudoVFSGNJN_VV_MF2_MASK, PseudoVFSGNJN_VV_MF2, 0x3 }, // 738
  { PseudoVFSGNJN_VV_MF4_MASK, PseudoVFSGNJN_VV_MF4, 0x3 }, // 739
  { PseudoVFSGNJX_VF16_M1_MASK, PseudoVFSGNJX_VF16_M1, 0x3 }, // 740
  { PseudoVFSGNJX_VF16_M2_MASK, PseudoVFSGNJX_VF16_M2, 0x3 }, // 741
  { PseudoVFSGNJX_VF16_M4_MASK, PseudoVFSGNJX_VF16_M4, 0x3 }, // 742
  { PseudoVFSGNJX_VF16_M8_MASK, PseudoVFSGNJX_VF16_M8, 0x3 }, // 743
  { PseudoVFSGNJX_VF16_MF2_MASK, PseudoVFSGNJX_VF16_MF2, 0x3 }, // 744
  { PseudoVFSGNJX_VF16_MF4_MASK, PseudoVFSGNJX_VF16_MF4, 0x3 }, // 745
  { PseudoVFSGNJX_VF32_M1_MASK, PseudoVFSGNJX_VF32_M1, 0x3 }, // 746
  { PseudoVFSGNJX_VF32_M2_MASK, PseudoVFSGNJX_VF32_M2, 0x3 }, // 747
  { PseudoVFSGNJX_VF32_M4_MASK, PseudoVFSGNJX_VF32_M4, 0x3 }, // 748
  { PseudoVFSGNJX_VF32_M8_MASK, PseudoVFSGNJX_VF32_M8, 0x3 }, // 749
  { PseudoVFSGNJX_VF32_MF2_MASK, PseudoVFSGNJX_VF32_MF2, 0x3 }, // 750
  { PseudoVFSGNJX_VF64_M1_MASK, PseudoVFSGNJX_VF64_M1, 0x3 }, // 751
  { PseudoVFSGNJX_VF64_M2_MASK, PseudoVFSGNJX_VF64_M2, 0x3 }, // 752
  { PseudoVFSGNJX_VF64_M4_MASK, PseudoVFSGNJX_VF64_M4, 0x3 }, // 753
  { PseudoVFSGNJX_VF64_M8_MASK, PseudoVFSGNJX_VF64_M8, 0x3 }, // 754
  { PseudoVFSGNJX_VV_M1_MASK, PseudoVFSGNJX_VV_M1, 0x3 }, // 755
  { PseudoVFSGNJX_VV_M2_MASK, PseudoVFSGNJX_VV_M2, 0x3 }, // 756
  { PseudoVFSGNJX_VV_M4_MASK, PseudoVFSGNJX_VV_M4, 0x3 }, // 757
  { PseudoVFSGNJX_VV_M8_MASK, PseudoVFSGNJX_VV_M8, 0x3 }, // 758
  { PseudoVFSGNJX_VV_MF2_MASK, PseudoVFSGNJX_VV_MF2, 0x3 }, // 759
  { PseudoVFSGNJX_VV_MF4_MASK, PseudoVFSGNJX_VV_MF4, 0x3 }, // 760
  { PseudoVFSGNJ_VF16_M1_MASK, PseudoVFSGNJ_VF16_M1, 0x3 }, // 761
  { PseudoVFSGNJ_VF16_M2_MASK, PseudoVFSGNJ_VF16_M2, 0x3 }, // 762
  { PseudoVFSGNJ_VF16_M4_MASK, PseudoVFSGNJ_VF16_M4, 0x3 }, // 763
  { PseudoVFSGNJ_VF16_M8_MASK, PseudoVFSGNJ_VF16_M8, 0x3 }, // 764
  { PseudoVFSGNJ_VF16_MF2_MASK, PseudoVFSGNJ_VF16_MF2, 0x3 }, // 765
  { PseudoVFSGNJ_VF16_MF4_MASK, PseudoVFSGNJ_VF16_MF4, 0x3 }, // 766
  { PseudoVFSGNJ_VF32_M1_MASK, PseudoVFSGNJ_VF32_M1, 0x3 }, // 767
  { PseudoVFSGNJ_VF32_M2_MASK, PseudoVFSGNJ_VF32_M2, 0x3 }, // 768
  { PseudoVFSGNJ_VF32_M4_MASK, PseudoVFSGNJ_VF32_M4, 0x3 }, // 769
  { PseudoVFSGNJ_VF32_M8_MASK, PseudoVFSGNJ_VF32_M8, 0x3 }, // 770
  { PseudoVFSGNJ_VF32_MF2_MASK, PseudoVFSGNJ_VF32_MF2, 0x3 }, // 771
  { PseudoVFSGNJ_VF64_M1_MASK, PseudoVFSGNJ_VF64_M1, 0x3 }, // 772
  { PseudoVFSGNJ_VF64_M2_MASK, PseudoVFSGNJ_VF64_M2, 0x3 }, // 773
  { PseudoVFSGNJ_VF64_M4_MASK, PseudoVFSGNJ_VF64_M4, 0x3 }, // 774
  { PseudoVFSGNJ_VF64_M8_MASK, PseudoVFSGNJ_VF64_M8, 0x3 }, // 775
  { PseudoVFSGNJ_VV_M1_MASK, PseudoVFSGNJ_VV_M1, 0x3 }, // 776
  { PseudoVFSGNJ_VV_M2_MASK, PseudoVFSGNJ_VV_M2, 0x3 }, // 777
  { PseudoVFSGNJ_VV_M4_MASK, PseudoVFSGNJ_VV_M4, 0x3 }, // 778
  { PseudoVFSGNJ_VV_M8_MASK, PseudoVFSGNJ_VV_M8, 0x3 }, // 779
  { PseudoVFSGNJ_VV_MF2_MASK, PseudoVFSGNJ_VV_MF2, 0x3 }, // 780
  { PseudoVFSGNJ_VV_MF4_MASK, PseudoVFSGNJ_VV_MF4, 0x3 }, // 781
  { PseudoVFSLIDE1DOWN_VF16_M1_MASK, PseudoVFSLIDE1DOWN_VF16_M1, 0x3 }, // 782
  { PseudoVFSLIDE1DOWN_VF16_M2_MASK, PseudoVFSLIDE1DOWN_VF16_M2, 0x3 }, // 783
  { PseudoVFSLIDE1DOWN_VF16_M4_MASK, PseudoVFSLIDE1DOWN_VF16_M4, 0x3 }, // 784
  { PseudoVFSLIDE1DOWN_VF16_M8_MASK, PseudoVFSLIDE1DOWN_VF16_M8, 0x3 }, // 785
  { PseudoVFSLIDE1DOWN_VF16_MF2_MASK, PseudoVFSLIDE1DOWN_VF16_MF2, 0x3 }, // 786
  { PseudoVFSLIDE1DOWN_VF16_MF4_MASK, PseudoVFSLIDE1DOWN_VF16_MF4, 0x3 }, // 787
  { PseudoVFSLIDE1DOWN_VF32_M1_MASK, PseudoVFSLIDE1DOWN_VF32_M1, 0x3 }, // 788
  { PseudoVFSLIDE1DOWN_VF32_M2_MASK, PseudoVFSLIDE1DOWN_VF32_M2, 0x3 }, // 789
  { PseudoVFSLIDE1DOWN_VF32_M4_MASK, PseudoVFSLIDE1DOWN_VF32_M4, 0x3 }, // 790
  { PseudoVFSLIDE1DOWN_VF32_M8_MASK, PseudoVFSLIDE1DOWN_VF32_M8, 0x3 }, // 791
  { PseudoVFSLIDE1DOWN_VF32_MF2_MASK, PseudoVFSLIDE1DOWN_VF32_MF2, 0x3 }, // 792
  { PseudoVFSLIDE1DOWN_VF64_M1_MASK, PseudoVFSLIDE1DOWN_VF64_M1, 0x3 }, // 793
  { PseudoVFSLIDE1DOWN_VF64_M2_MASK, PseudoVFSLIDE1DOWN_VF64_M2, 0x3 }, // 794
  { PseudoVFSLIDE1DOWN_VF64_M4_MASK, PseudoVFSLIDE1DOWN_VF64_M4, 0x3 }, // 795
  { PseudoVFSLIDE1DOWN_VF64_M8_MASK, PseudoVFSLIDE1DOWN_VF64_M8, 0x3 }, // 796
  { PseudoVFSLIDE1UP_VF16_M1_MASK, PseudoVFSLIDE1UP_VF16_M1, 0x3 }, // 797
  { PseudoVFSLIDE1UP_VF16_M2_MASK, PseudoVFSLIDE1UP_VF16_M2, 0x3 }, // 798
  { PseudoVFSLIDE1UP_VF16_M4_MASK, PseudoVFSLIDE1UP_VF16_M4, 0x3 }, // 799
  { PseudoVFSLIDE1UP_VF16_M8_MASK, PseudoVFSLIDE1UP_VF16_M8, 0x3 }, // 800
  { PseudoVFSLIDE1UP_VF16_MF2_MASK, PseudoVFSLIDE1UP_VF16_MF2, 0x3 }, // 801
  { PseudoVFSLIDE1UP_VF16_MF4_MASK, PseudoVFSLIDE1UP_VF16_MF4, 0x3 }, // 802
  { PseudoVFSLIDE1UP_VF32_M1_MASK, PseudoVFSLIDE1UP_VF32_M1, 0x3 }, // 803
  { PseudoVFSLIDE1UP_VF32_M2_MASK, PseudoVFSLIDE1UP_VF32_M2, 0x3 }, // 804
  { PseudoVFSLIDE1UP_VF32_M4_MASK, PseudoVFSLIDE1UP_VF32_M4, 0x3 }, // 805
  { PseudoVFSLIDE1UP_VF32_M8_MASK, PseudoVFSLIDE1UP_VF32_M8, 0x3 }, // 806
  { PseudoVFSLIDE1UP_VF32_MF2_MASK, PseudoVFSLIDE1UP_VF32_MF2, 0x3 }, // 807
  { PseudoVFSLIDE1UP_VF64_M1_MASK, PseudoVFSLIDE1UP_VF64_M1, 0x3 }, // 808
  { PseudoVFSLIDE1UP_VF64_M2_MASK, PseudoVFSLIDE1UP_VF64_M2, 0x3 }, // 809
  { PseudoVFSLIDE1UP_VF64_M4_MASK, PseudoVFSLIDE1UP_VF64_M4, 0x3 }, // 810
  { PseudoVFSLIDE1UP_VF64_M8_MASK, PseudoVFSLIDE1UP_VF64_M8, 0x3 }, // 811
  { PseudoVFSQRT_V_M1_E16_MASK, PseudoVFSQRT_V_M1_E16, 0x2 }, // 812
  { PseudoVFSQRT_V_M1_E32_MASK, PseudoVFSQRT_V_M1_E32, 0x2 }, // 813
  { PseudoVFSQRT_V_M1_E64_MASK, PseudoVFSQRT_V_M1_E64, 0x2 }, // 814
  { PseudoVFSQRT_V_M2_E16_MASK, PseudoVFSQRT_V_M2_E16, 0x2 }, // 815
  { PseudoVFSQRT_V_M2_E32_MASK, PseudoVFSQRT_V_M2_E32, 0x2 }, // 816
  { PseudoVFSQRT_V_M2_E64_MASK, PseudoVFSQRT_V_M2_E64, 0x2 }, // 817
  { PseudoVFSQRT_V_M4_E16_MASK, PseudoVFSQRT_V_M4_E16, 0x2 }, // 818
  { PseudoVFSQRT_V_M4_E32_MASK, PseudoVFSQRT_V_M4_E32, 0x2 }, // 819
  { PseudoVFSQRT_V_M4_E64_MASK, PseudoVFSQRT_V_M4_E64, 0x2 }, // 820
  { PseudoVFSQRT_V_M8_E16_MASK, PseudoVFSQRT_V_M8_E16, 0x2 }, // 821
  { PseudoVFSQRT_V_M8_E32_MASK, PseudoVFSQRT_V_M8_E32, 0x2 }, // 822
  { PseudoVFSQRT_V_M8_E64_MASK, PseudoVFSQRT_V_M8_E64, 0x2 }, // 823
  { PseudoVFSQRT_V_MF2_E16_MASK, PseudoVFSQRT_V_MF2_E16, 0x2 }, // 824
  { PseudoVFSQRT_V_MF2_E32_MASK, PseudoVFSQRT_V_MF2_E32, 0x2 }, // 825
  { PseudoVFSQRT_V_MF4_E16_MASK, PseudoVFSQRT_V_MF4_E16, 0x2 }, // 826
  { PseudoVFSUB_VF16_M1_MASK, PseudoVFSUB_VF16_M1, 0x3 }, // 827
  { PseudoVFSUB_VF16_M2_MASK, PseudoVFSUB_VF16_M2, 0x3 }, // 828
  { PseudoVFSUB_VF16_M4_MASK, PseudoVFSUB_VF16_M4, 0x3 }, // 829
  { PseudoVFSUB_VF16_M8_MASK, PseudoVFSUB_VF16_M8, 0x3 }, // 830
  { PseudoVFSUB_VF16_MF2_MASK, PseudoVFSUB_VF16_MF2, 0x3 }, // 831
  { PseudoVFSUB_VF16_MF4_MASK, PseudoVFSUB_VF16_MF4, 0x3 }, // 832
  { PseudoVFSUB_VF32_M1_MASK, PseudoVFSUB_VF32_M1, 0x3 }, // 833
  { PseudoVFSUB_VF32_M2_MASK, PseudoVFSUB_VF32_M2, 0x3 }, // 834
  { PseudoVFSUB_VF32_M4_MASK, PseudoVFSUB_VF32_M4, 0x3 }, // 835
  { PseudoVFSUB_VF32_M8_MASK, PseudoVFSUB_VF32_M8, 0x3 }, // 836
  { PseudoVFSUB_VF32_MF2_MASK, PseudoVFSUB_VF32_MF2, 0x3 }, // 837
  { PseudoVFSUB_VF64_M1_MASK, PseudoVFSUB_VF64_M1, 0x3 }, // 838
  { PseudoVFSUB_VF64_M2_MASK, PseudoVFSUB_VF64_M2, 0x3 }, // 839
  { PseudoVFSUB_VF64_M4_MASK, PseudoVFSUB_VF64_M4, 0x3 }, // 840
  { PseudoVFSUB_VF64_M8_MASK, PseudoVFSUB_VF64_M8, 0x3 }, // 841
  { PseudoVFSUB_VV_M1_MASK, PseudoVFSUB_VV_M1, 0x3 }, // 842
  { PseudoVFSUB_VV_M2_MASK, PseudoVFSUB_VV_M2, 0x3 }, // 843
  { PseudoVFSUB_VV_M4_MASK, PseudoVFSUB_VV_M4, 0x3 }, // 844
  { PseudoVFSUB_VV_M8_MASK, PseudoVFSUB_VV_M8, 0x3 }, // 845
  { PseudoVFSUB_VV_MF2_MASK, PseudoVFSUB_VV_MF2, 0x3 }, // 846
  { PseudoVFSUB_VV_MF4_MASK, PseudoVFSUB_VV_MF4, 0x3 }, // 847
  { PseudoVFWADD_VF16_M1_MASK, PseudoVFWADD_VF16_M1, 0x3 }, // 848
  { PseudoVFWADD_VF16_M2_MASK, PseudoVFWADD_VF16_M2, 0x3 }, // 849
  { PseudoVFWADD_VF16_M4_MASK, PseudoVFWADD_VF16_M4, 0x3 }, // 850
  { PseudoVFWADD_VF16_MF2_MASK, PseudoVFWADD_VF16_MF2, 0x3 }, // 851
  { PseudoVFWADD_VF16_MF4_MASK, PseudoVFWADD_VF16_MF4, 0x3 }, // 852
  { PseudoVFWADD_VF32_M1_MASK, PseudoVFWADD_VF32_M1, 0x3 }, // 853
  { PseudoVFWADD_VF32_M2_MASK, PseudoVFWADD_VF32_M2, 0x3 }, // 854
  { PseudoVFWADD_VF32_M4_MASK, PseudoVFWADD_VF32_M4, 0x3 }, // 855
  { PseudoVFWADD_VF32_MF2_MASK, PseudoVFWADD_VF32_MF2, 0x3 }, // 856
  { PseudoVFWADD_VV_M1_MASK, PseudoVFWADD_VV_M1, 0x3 }, // 857
  { PseudoVFWADD_VV_M2_MASK, PseudoVFWADD_VV_M2, 0x3 }, // 858
  { PseudoVFWADD_VV_M4_MASK, PseudoVFWADD_VV_M4, 0x3 }, // 859
  { PseudoVFWADD_VV_MF2_MASK, PseudoVFWADD_VV_MF2, 0x3 }, // 860
  { PseudoVFWADD_VV_MF4_MASK, PseudoVFWADD_VV_MF4, 0x3 }, // 861
  { PseudoVFWADD_WF16_M1_MASK, PseudoVFWADD_WF16_M1, 0x3 }, // 862
  { PseudoVFWADD_WF16_M2_MASK, PseudoVFWADD_WF16_M2, 0x3 }, // 863
  { PseudoVFWADD_WF16_M4_MASK, PseudoVFWADD_WF16_M4, 0x3 }, // 864
  { PseudoVFWADD_WF16_MF2_MASK, PseudoVFWADD_WF16_MF2, 0x3 }, // 865
  { PseudoVFWADD_WF16_MF4_MASK, PseudoVFWADD_WF16_MF4, 0x3 }, // 866
  { PseudoVFWADD_WF32_M1_MASK, PseudoVFWADD_WF32_M1, 0x3 }, // 867
  { PseudoVFWADD_WF32_M2_MASK, PseudoVFWADD_WF32_M2, 0x3 }, // 868
  { PseudoVFWADD_WF32_M4_MASK, PseudoVFWADD_WF32_M4, 0x3 }, // 869
  { PseudoVFWADD_WF32_MF2_MASK, PseudoVFWADD_WF32_MF2, 0x3 }, // 870
  { PseudoVFWADD_WV_M1_MASK, PseudoVFWADD_WV_M1, 0x3 }, // 871
  { PseudoVFWADD_WV_M2_MASK, PseudoVFWADD_WV_M2, 0x3 }, // 872
  { PseudoVFWADD_WV_M4_MASK, PseudoVFWADD_WV_M4, 0x3 }, // 873
  { PseudoVFWADD_WV_MF2_MASK, PseudoVFWADD_WV_MF2, 0x3 }, // 874
  { PseudoVFWADD_WV_MF4_MASK, PseudoVFWADD_WV_MF4, 0x3 }, // 875
  { PseudoVFWCVT_F_F_V_M1_MASK, PseudoVFWCVT_F_F_V_M1, 0x2 }, // 876
  { PseudoVFWCVT_F_F_V_M2_MASK, PseudoVFWCVT_F_F_V_M2, 0x2 }, // 877
  { PseudoVFWCVT_F_F_V_M4_MASK, PseudoVFWCVT_F_F_V_M4, 0x2 }, // 878
  { PseudoVFWCVT_F_F_V_MF2_MASK, PseudoVFWCVT_F_F_V_MF2, 0x2 }, // 879
  { PseudoVFWCVT_F_F_V_MF4_MASK, PseudoVFWCVT_F_F_V_MF4, 0x2 }, // 880
  { PseudoVFWCVT_F_XU_V_M1_MASK, PseudoVFWCVT_F_XU_V_M1, 0x2 }, // 881
  { PseudoVFWCVT_F_XU_V_M2_MASK, PseudoVFWCVT_F_XU_V_M2, 0x2 }, // 882
  { PseudoVFWCVT_F_XU_V_M4_MASK, PseudoVFWCVT_F_XU_V_M4, 0x2 }, // 883
  { PseudoVFWCVT_F_XU_V_MF2_MASK, PseudoVFWCVT_F_XU_V_MF2, 0x2 }, // 884
  { PseudoVFWCVT_F_XU_V_MF4_MASK, PseudoVFWCVT_F_XU_V_MF4, 0x2 }, // 885
  { PseudoVFWCVT_F_XU_V_MF8_MASK, PseudoVFWCVT_F_XU_V_MF8, 0x2 }, // 886
  { PseudoVFWCVT_F_X_V_M1_MASK, PseudoVFWCVT_F_X_V_M1, 0x2 }, // 887
  { PseudoVFWCVT_F_X_V_M2_MASK, PseudoVFWCVT_F_X_V_M2, 0x2 }, // 888
  { PseudoVFWCVT_F_X_V_M4_MASK, PseudoVFWCVT_F_X_V_M4, 0x2 }, // 889
  { PseudoVFWCVT_F_X_V_MF2_MASK, PseudoVFWCVT_F_X_V_MF2, 0x2 }, // 890
  { PseudoVFWCVT_F_X_V_MF4_MASK, PseudoVFWCVT_F_X_V_MF4, 0x2 }, // 891
  { PseudoVFWCVT_F_X_V_MF8_MASK, PseudoVFWCVT_F_X_V_MF8, 0x2 }, // 892
  { PseudoVFWCVT_RM_XU_F_V_M1_MASK, PseudoVFWCVT_RM_XU_F_V_M1, 0x2 }, // 893
  { PseudoVFWCVT_RM_XU_F_V_M2_MASK, PseudoVFWCVT_RM_XU_F_V_M2, 0x2 }, // 894
  { PseudoVFWCVT_RM_XU_F_V_M4_MASK, PseudoVFWCVT_RM_XU_F_V_M4, 0x2 }, // 895
  { PseudoVFWCVT_RM_XU_F_V_MF2_MASK, PseudoVFWCVT_RM_XU_F_V_MF2, 0x2 }, // 896
  { PseudoVFWCVT_RM_XU_F_V_MF4_MASK, PseudoVFWCVT_RM_XU_F_V_MF4, 0x2 }, // 897
  { PseudoVFWCVT_RM_X_F_V_M1_MASK, PseudoVFWCVT_RM_X_F_V_M1, 0x2 }, // 898
  { PseudoVFWCVT_RM_X_F_V_M2_MASK, PseudoVFWCVT_RM_X_F_V_M2, 0x2 }, // 899
  { PseudoVFWCVT_RM_X_F_V_M4_MASK, PseudoVFWCVT_RM_X_F_V_M4, 0x2 }, // 900
  { PseudoVFWCVT_RM_X_F_V_MF2_MASK, PseudoVFWCVT_RM_X_F_V_MF2, 0x2 }, // 901
  { PseudoVFWCVT_RM_X_F_V_MF4_MASK, PseudoVFWCVT_RM_X_F_V_MF4, 0x2 }, // 902
  { PseudoVFWCVT_RTZ_XU_F_V_M1_MASK, PseudoVFWCVT_RTZ_XU_F_V_M1, 0x2 }, // 903
  { PseudoVFWCVT_RTZ_XU_F_V_M2_MASK, PseudoVFWCVT_RTZ_XU_F_V_M2, 0x2 }, // 904
  { PseudoVFWCVT_RTZ_XU_F_V_M4_MASK, PseudoVFWCVT_RTZ_XU_F_V_M4, 0x2 }, // 905
  { PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK, PseudoVFWCVT_RTZ_XU_F_V_MF2, 0x2 }, // 906
  { PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK, PseudoVFWCVT_RTZ_XU_F_V_MF4, 0x2 }, // 907
  { PseudoVFWCVT_RTZ_X_F_V_M1_MASK, PseudoVFWCVT_RTZ_X_F_V_M1, 0x2 }, // 908
  { PseudoVFWCVT_RTZ_X_F_V_M2_MASK, PseudoVFWCVT_RTZ_X_F_V_M2, 0x2 }, // 909
  { PseudoVFWCVT_RTZ_X_F_V_M4_MASK, PseudoVFWCVT_RTZ_X_F_V_M4, 0x2 }, // 910
  { PseudoVFWCVT_RTZ_X_F_V_MF2_MASK, PseudoVFWCVT_RTZ_X_F_V_MF2, 0x2 }, // 911
  { PseudoVFWCVT_RTZ_X_F_V_MF4_MASK, PseudoVFWCVT_RTZ_X_F_V_MF4, 0x2 }, // 912
  { PseudoVFWCVT_XU_F_V_M1_MASK, PseudoVFWCVT_XU_F_V_M1, 0x2 }, // 913
  { PseudoVFWCVT_XU_F_V_M2_MASK, PseudoVFWCVT_XU_F_V_M2, 0x2 }, // 914
  { PseudoVFWCVT_XU_F_V_M4_MASK, PseudoVFWCVT_XU_F_V_M4, 0x2 }, // 915
  { PseudoVFWCVT_XU_F_V_MF2_MASK, PseudoVFWCVT_XU_F_V_MF2, 0x2 }, // 916
  { PseudoVFWCVT_XU_F_V_MF4_MASK, PseudoVFWCVT_XU_F_V_MF4, 0x2 }, // 917
  { PseudoVFWCVT_X_F_V_M1_MASK, PseudoVFWCVT_X_F_V_M1, 0x2 }, // 918
  { PseudoVFWCVT_X_F_V_M2_MASK, PseudoVFWCVT_X_F_V_M2, 0x2 }, // 919
  { PseudoVFWCVT_X_F_V_M4_MASK, PseudoVFWCVT_X_F_V_M4, 0x2 }, // 920
  { PseudoVFWCVT_X_F_V_MF2_MASK, PseudoVFWCVT_X_F_V_MF2, 0x2 }, // 921
  { PseudoVFWCVT_X_F_V_MF4_MASK, PseudoVFWCVT_X_F_V_MF4, 0x2 }, // 922
  { PseudoVFWMACC_VF16_M1_MASK, PseudoVFWMACC_VF16_M1, 0x3 }, // 923
  { PseudoVFWMACC_VF16_M2_MASK, PseudoVFWMACC_VF16_M2, 0x3 }, // 924
  { PseudoVFWMACC_VF16_M4_MASK, PseudoVFWMACC_VF16_M4, 0x3 }, // 925
  { PseudoVFWMACC_VF16_MF2_MASK, PseudoVFWMACC_VF16_MF2, 0x3 }, // 926
  { PseudoVFWMACC_VF16_MF4_MASK, PseudoVFWMACC_VF16_MF4, 0x3 }, // 927
  { PseudoVFWMACC_VF32_M1_MASK, PseudoVFWMACC_VF32_M1, 0x3 }, // 928
  { PseudoVFWMACC_VF32_M2_MASK, PseudoVFWMACC_VF32_M2, 0x3 }, // 929
  { PseudoVFWMACC_VF32_M4_MASK, PseudoVFWMACC_VF32_M4, 0x3 }, // 930
  { PseudoVFWMACC_VF32_MF2_MASK, PseudoVFWMACC_VF32_MF2, 0x3 }, // 931
  { PseudoVFWMACC_VV_M1_MASK, PseudoVFWMACC_VV_M1, 0x3 }, // 932
  { PseudoVFWMACC_VV_M2_MASK, PseudoVFWMACC_VV_M2, 0x3 }, // 933
  { PseudoVFWMACC_VV_M4_MASK, PseudoVFWMACC_VV_M4, 0x3 }, // 934
  { PseudoVFWMACC_VV_MF2_MASK, PseudoVFWMACC_VV_MF2, 0x3 }, // 935
  { PseudoVFWMACC_VV_MF4_MASK, PseudoVFWMACC_VV_MF4, 0x3 }, // 936
  { PseudoVFWMSAC_VF16_M1_MASK, PseudoVFWMSAC_VF16_M1, 0x3 }, // 937
  { PseudoVFWMSAC_VF16_M2_MASK, PseudoVFWMSAC_VF16_M2, 0x3 }, // 938
  { PseudoVFWMSAC_VF16_M4_MASK, PseudoVFWMSAC_VF16_M4, 0x3 }, // 939
  { PseudoVFWMSAC_VF16_MF2_MASK, PseudoVFWMSAC_VF16_MF2, 0x3 }, // 940
  { PseudoVFWMSAC_VF16_MF4_MASK, PseudoVFWMSAC_VF16_MF4, 0x3 }, // 941
  { PseudoVFWMSAC_VF32_M1_MASK, PseudoVFWMSAC_VF32_M1, 0x3 }, // 942
  { PseudoVFWMSAC_VF32_M2_MASK, PseudoVFWMSAC_VF32_M2, 0x3 }, // 943
  { PseudoVFWMSAC_VF32_M4_MASK, PseudoVFWMSAC_VF32_M4, 0x3 }, // 944
  { PseudoVFWMSAC_VF32_MF2_MASK, PseudoVFWMSAC_VF32_MF2, 0x3 }, // 945
  { PseudoVFWMSAC_VV_M1_MASK, PseudoVFWMSAC_VV_M1, 0x3 }, // 946
  { PseudoVFWMSAC_VV_M2_MASK, PseudoVFWMSAC_VV_M2, 0x3 }, // 947
  { PseudoVFWMSAC_VV_M4_MASK, PseudoVFWMSAC_VV_M4, 0x3 }, // 948
  { PseudoVFWMSAC_VV_MF2_MASK, PseudoVFWMSAC_VV_MF2, 0x3 }, // 949
  { PseudoVFWMSAC_VV_MF4_MASK, PseudoVFWMSAC_VV_MF4, 0x3 }, // 950
  { PseudoVFWMUL_VF16_M1_MASK, PseudoVFWMUL_VF16_M1, 0x3 }, // 951
  { PseudoVFWMUL_VF16_M2_MASK, PseudoVFWMUL_VF16_M2, 0x3 }, // 952
  { PseudoVFWMUL_VF16_M4_MASK, PseudoVFWMUL_VF16_M4, 0x3 }, // 953
  { PseudoVFWMUL_VF16_MF2_MASK, PseudoVFWMUL_VF16_MF2, 0x3 }, // 954
  { PseudoVFWMUL_VF16_MF4_MASK, PseudoVFWMUL_VF16_MF4, 0x3 }, // 955
  { PseudoVFWMUL_VF32_M1_MASK, PseudoVFWMUL_VF32_M1, 0x3 }, // 956
  { PseudoVFWMUL_VF32_M2_MASK, PseudoVFWMUL_VF32_M2, 0x3 }, // 957
  { PseudoVFWMUL_VF32_M4_MASK, PseudoVFWMUL_VF32_M4, 0x3 }, // 958
  { PseudoVFWMUL_VF32_MF2_MASK, PseudoVFWMUL_VF32_MF2, 0x3 }, // 959
  { PseudoVFWMUL_VV_M1_MASK, PseudoVFWMUL_VV_M1, 0x3 }, // 960
  { PseudoVFWMUL_VV_M2_MASK, PseudoVFWMUL_VV_M2, 0x3 }, // 961
  { PseudoVFWMUL_VV_M4_MASK, PseudoVFWMUL_VV_M4, 0x3 }, // 962
  { PseudoVFWMUL_VV_MF2_MASK, PseudoVFWMUL_VV_MF2, 0x3 }, // 963
  { PseudoVFWMUL_VV_MF4_MASK, PseudoVFWMUL_VV_MF4, 0x3 }, // 964
  { PseudoVFWNMACC_VF16_M1_MASK, PseudoVFWNMACC_VF16_M1, 0x3 }, // 965
  { PseudoVFWNMACC_VF16_M2_MASK, PseudoVFWNMACC_VF16_M2, 0x3 }, // 966
  { PseudoVFWNMACC_VF16_M4_MASK, PseudoVFWNMACC_VF16_M4, 0x3 }, // 967
  { PseudoVFWNMACC_VF16_MF2_MASK, PseudoVFWNMACC_VF16_MF2, 0x3 }, // 968
  { PseudoVFWNMACC_VF16_MF4_MASK, PseudoVFWNMACC_VF16_MF4, 0x3 }, // 969
  { PseudoVFWNMACC_VF32_M1_MASK, PseudoVFWNMACC_VF32_M1, 0x3 }, // 970
  { PseudoVFWNMACC_VF32_M2_MASK, PseudoVFWNMACC_VF32_M2, 0x3 }, // 971
  { PseudoVFWNMACC_VF32_M4_MASK, PseudoVFWNMACC_VF32_M4, 0x3 }, // 972
  { PseudoVFWNMACC_VF32_MF2_MASK, PseudoVFWNMACC_VF32_MF2, 0x3 }, // 973
  { PseudoVFWNMACC_VV_M1_MASK, PseudoVFWNMACC_VV_M1, 0x3 }, // 974
  { PseudoVFWNMACC_VV_M2_MASK, PseudoVFWNMACC_VV_M2, 0x3 }, // 975
  { PseudoVFWNMACC_VV_M4_MASK, PseudoVFWNMACC_VV_M4, 0x3 }, // 976
  { PseudoVFWNMACC_VV_MF2_MASK, PseudoVFWNMACC_VV_MF2, 0x3 }, // 977
  { PseudoVFWNMACC_VV_MF4_MASK, PseudoVFWNMACC_VV_MF4, 0x3 }, // 978
  { PseudoVFWNMSAC_VF16_M1_MASK, PseudoVFWNMSAC_VF16_M1, 0x3 }, // 979
  { PseudoVFWNMSAC_VF16_M2_MASK, PseudoVFWNMSAC_VF16_M2, 0x3 }, // 980
  { PseudoVFWNMSAC_VF16_M4_MASK, PseudoVFWNMSAC_VF16_M4, 0x3 }, // 981
  { PseudoVFWNMSAC_VF16_MF2_MASK, PseudoVFWNMSAC_VF16_MF2, 0x3 }, // 982
  { PseudoVFWNMSAC_VF16_MF4_MASK, PseudoVFWNMSAC_VF16_MF4, 0x3 }, // 983
  { PseudoVFWNMSAC_VF32_M1_MASK, PseudoVFWNMSAC_VF32_M1, 0x3 }, // 984
  { PseudoVFWNMSAC_VF32_M2_MASK, PseudoVFWNMSAC_VF32_M2, 0x3 }, // 985
  { PseudoVFWNMSAC_VF32_M4_MASK, PseudoVFWNMSAC_VF32_M4, 0x3 }, // 986
  { PseudoVFWNMSAC_VF32_MF2_MASK, PseudoVFWNMSAC_VF32_MF2, 0x3 }, // 987
  { PseudoVFWNMSAC_VV_M1_MASK, PseudoVFWNMSAC_VV_M1, 0x3 }, // 988
  { PseudoVFWNMSAC_VV_M2_MASK, PseudoVFWNMSAC_VV_M2, 0x3 }, // 989
  { PseudoVFWNMSAC_VV_M4_MASK, PseudoVFWNMSAC_VV_M4, 0x3 }, // 990
  { PseudoVFWNMSAC_VV_MF2_MASK, PseudoVFWNMSAC_VV_MF2, 0x3 }, // 991
  { PseudoVFWNMSAC_VV_MF4_MASK, PseudoVFWNMSAC_VV_MF4, 0x3 }, // 992
  { PseudoVFWSUB_VF16_M1_MASK, PseudoVFWSUB_VF16_M1, 0x3 }, // 993
  { PseudoVFWSUB_VF16_M2_MASK, PseudoVFWSUB_VF16_M2, 0x3 }, // 994
  { PseudoVFWSUB_VF16_M4_MASK, PseudoVFWSUB_VF16_M4, 0x3 }, // 995
  { PseudoVFWSUB_VF16_MF2_MASK, PseudoVFWSUB_VF16_MF2, 0x3 }, // 996
  { PseudoVFWSUB_VF16_MF4_MASK, PseudoVFWSUB_VF16_MF4, 0x3 }, // 997
  { PseudoVFWSUB_VF32_M1_MASK, PseudoVFWSUB_VF32_M1, 0x3 }, // 998
  { PseudoVFWSUB_VF32_M2_MASK, PseudoVFWSUB_VF32_M2, 0x3 }, // 999
  { PseudoVFWSUB_VF32_M4_MASK, PseudoVFWSUB_VF32_M4, 0x3 }, // 1000
  { PseudoVFWSUB_VF32_MF2_MASK, PseudoVFWSUB_VF32_MF2, 0x3 }, // 1001
  { PseudoVFWSUB_VV_M1_MASK, PseudoVFWSUB_VV_M1, 0x3 }, // 1002
  { PseudoVFWSUB_VV_M2_MASK, PseudoVFWSUB_VV_M2, 0x3 }, // 1003
  { PseudoVFWSUB_VV_M4_MASK, PseudoVFWSUB_VV_M4, 0x3 }, // 1004
  { PseudoVFWSUB_VV_MF2_MASK, PseudoVFWSUB_VV_MF2, 0x3 }, // 1005
  { PseudoVFWSUB_VV_MF4_MASK, PseudoVFWSUB_VV_MF4, 0x3 }, // 1006
  { PseudoVFWSUB_WF16_M1_MASK, PseudoVFWSUB_WF16_M1, 0x3 }, // 1007
  { PseudoVFWSUB_WF16_M2_MASK, PseudoVFWSUB_WF16_M2, 0x3 }, // 1008
  { PseudoVFWSUB_WF16_M4_MASK, PseudoVFWSUB_WF16_M4, 0x3 }, // 1009
  { PseudoVFWSUB_WF16_MF2_MASK, PseudoVFWSUB_WF16_MF2, 0x3 }, // 1010
  { PseudoVFWSUB_WF16_MF4_MASK, PseudoVFWSUB_WF16_MF4, 0x3 }, // 1011
  { PseudoVFWSUB_WF32_M1_MASK, PseudoVFWSUB_WF32_M1, 0x3 }, // 1012
  { PseudoVFWSUB_WF32_M2_MASK, PseudoVFWSUB_WF32_M2, 0x3 }, // 1013
  { PseudoVFWSUB_WF32_M4_MASK, PseudoVFWSUB_WF32_M4, 0x3 }, // 1014
  { PseudoVFWSUB_WF32_MF2_MASK, PseudoVFWSUB_WF32_MF2, 0x3 }, // 1015
  { PseudoVFWSUB_WV_M1_MASK, PseudoVFWSUB_WV_M1, 0x3 }, // 1016
  { PseudoVFWSUB_WV_M2_MASK, PseudoVFWSUB_WV_M2, 0x3 }, // 1017
  { PseudoVFWSUB_WV_M4_MASK, PseudoVFWSUB_WV_M4, 0x3 }, // 1018
  { PseudoVFWSUB_WV_MF2_MASK, PseudoVFWSUB_WV_MF2, 0x3 }, // 1019
  { PseudoVFWSUB_WV_MF4_MASK, PseudoVFWSUB_WV_MF4, 0x3 }, // 1020
  { PseudoVID_V_M1_MASK, PseudoVID_V_M1, 0x1 }, // 1021
  { PseudoVID_V_M2_MASK, PseudoVID_V_M2, 0x1 }, // 1022
  { PseudoVID_V_M4_MASK, PseudoVID_V_M4, 0x1 }, // 1023
  { PseudoVID_V_M8_MASK, PseudoVID_V_M8, 0x1 }, // 1024
  { PseudoVID_V_MF2_MASK, PseudoVID_V_MF2, 0x1 }, // 1025
  { PseudoVID_V_MF4_MASK, PseudoVID_V_MF4, 0x1 }, // 1026
  { PseudoVID_V_MF8_MASK, PseudoVID_V_MF8, 0x1 }, // 1027
  { PseudoVIOTA_M_M1_MASK, PseudoVIOTA_M_M1, 0x2 }, // 1028
  { PseudoVIOTA_M_M2_MASK, PseudoVIOTA_M_M2, 0x2 }, // 1029
  { PseudoVIOTA_M_M4_MASK, PseudoVIOTA_M_M4, 0x2 }, // 1030
  { PseudoVIOTA_M_M8_MASK, PseudoVIOTA_M_M8, 0x2 }, // 1031
  { PseudoVIOTA_M_MF2_MASK, PseudoVIOTA_M_MF2, 0x2 }, // 1032
  { PseudoVIOTA_M_MF4_MASK, PseudoVIOTA_M_MF4, 0x2 }, // 1033
  { PseudoVIOTA_M_MF8_MASK, PseudoVIOTA_M_MF8, 0x2 }, // 1034
  { PseudoVLE16FF_V_M1_MASK, PseudoVLE16FF_V_M1, 0x2 }, // 1035
  { PseudoVLE16FF_V_M2_MASK, PseudoVLE16FF_V_M2, 0x2 }, // 1036
  { PseudoVLE16FF_V_M4_MASK, PseudoVLE16FF_V_M4, 0x2 }, // 1037
  { PseudoVLE16FF_V_M8_MASK, PseudoVLE16FF_V_M8, 0x2 }, // 1038
  { PseudoVLE16FF_V_MF2_MASK, PseudoVLE16FF_V_MF2, 0x2 }, // 1039
  { PseudoVLE16FF_V_MF4_MASK, PseudoVLE16FF_V_MF4, 0x2 }, // 1040
  { PseudoVLE16_V_M1_MASK, PseudoVLE16_V_M1, 0x2 }, // 1041
  { PseudoVLE16_V_M2_MASK, PseudoVLE16_V_M2, 0x2 }, // 1042
  { PseudoVLE16_V_M4_MASK, PseudoVLE16_V_M4, 0x2 }, // 1043
  { PseudoVLE16_V_M8_MASK, PseudoVLE16_V_M8, 0x2 }, // 1044
  { PseudoVLE16_V_MF2_MASK, PseudoVLE16_V_MF2, 0x2 }, // 1045
  { PseudoVLE16_V_MF4_MASK, PseudoVLE16_V_MF4, 0x2 }, // 1046
  { PseudoVLE32FF_V_M1_MASK, PseudoVLE32FF_V_M1, 0x2 }, // 1047
  { PseudoVLE32FF_V_M2_MASK, PseudoVLE32FF_V_M2, 0x2 }, // 1048
  { PseudoVLE32FF_V_M4_MASK, PseudoVLE32FF_V_M4, 0x2 }, // 1049
  { PseudoVLE32FF_V_M8_MASK, PseudoVLE32FF_V_M8, 0x2 }, // 1050
  { PseudoVLE32FF_V_MF2_MASK, PseudoVLE32FF_V_MF2, 0x2 }, // 1051
  { PseudoVLE32_V_M1_MASK, PseudoVLE32_V_M1, 0x2 }, // 1052
  { PseudoVLE32_V_M2_MASK, PseudoVLE32_V_M2, 0x2 }, // 1053
  { PseudoVLE32_V_M4_MASK, PseudoVLE32_V_M4, 0x2 }, // 1054
  { PseudoVLE32_V_M8_MASK, PseudoVLE32_V_M8, 0x2 }, // 1055
  { PseudoVLE32_V_MF2_MASK, PseudoVLE32_V_MF2, 0x2 }, // 1056
  { PseudoVLE64FF_V_M1_MASK, PseudoVLE64FF_V_M1, 0x2 }, // 1057
  { PseudoVLE64FF_V_M2_MASK, PseudoVLE64FF_V_M2, 0x2 }, // 1058
  { PseudoVLE64FF_V_M4_MASK, PseudoVLE64FF_V_M4, 0x2 }, // 1059
  { PseudoVLE64FF_V_M8_MASK, PseudoVLE64FF_V_M8, 0x2 }, // 1060
  { PseudoVLE64_V_M1_MASK, PseudoVLE64_V_M1, 0x2 }, // 1061
  { PseudoVLE64_V_M2_MASK, PseudoVLE64_V_M2, 0x2 }, // 1062
  { PseudoVLE64_V_M4_MASK, PseudoVLE64_V_M4, 0x2 }, // 1063
  { PseudoVLE64_V_M8_MASK, PseudoVLE64_V_M8, 0x2 }, // 1064
  { PseudoVLE8FF_V_M1_MASK, PseudoVLE8FF_V_M1, 0x2 }, // 1065
  { PseudoVLE8FF_V_M2_MASK, PseudoVLE8FF_V_M2, 0x2 }, // 1066
  { PseudoVLE8FF_V_M4_MASK, PseudoVLE8FF_V_M4, 0x2 }, // 1067
  { PseudoVLE8FF_V_M8_MASK, PseudoVLE8FF_V_M8, 0x2 }, // 1068
  { PseudoVLE8FF_V_MF2_MASK, PseudoVLE8FF_V_MF2, 0x2 }, // 1069
  { PseudoVLE8FF_V_MF4_MASK, PseudoVLE8FF_V_MF4, 0x2 }, // 1070
  { PseudoVLE8FF_V_MF8_MASK, PseudoVLE8FF_V_MF8, 0x2 }, // 1071
  { PseudoVLE8_V_M1_MASK, PseudoVLE8_V_M1, 0x2 }, // 1072
  { PseudoVLE8_V_M2_MASK, PseudoVLE8_V_M2, 0x2 }, // 1073
  { PseudoVLE8_V_M4_MASK, PseudoVLE8_V_M4, 0x2 }, // 1074
  { PseudoVLE8_V_M8_MASK, PseudoVLE8_V_M8, 0x2 }, // 1075
  { PseudoVLE8_V_MF2_MASK, PseudoVLE8_V_MF2, 0x2 }, // 1076
  { PseudoVLE8_V_MF4_MASK, PseudoVLE8_V_MF4, 0x2 }, // 1077
  { PseudoVLE8_V_MF8_MASK, PseudoVLE8_V_MF8, 0x2 }, // 1078
  { PseudoVLOXEI16_V_M1_M1_MASK, PseudoVLOXEI16_V_M1_M1, 0x3 }, // 1079
  { PseudoVLOXEI16_V_M1_M2_MASK, PseudoVLOXEI16_V_M1_M2, 0x3 }, // 1080
  { PseudoVLOXEI16_V_M1_M4_MASK, PseudoVLOXEI16_V_M1_M4, 0x3 }, // 1081
  { PseudoVLOXEI16_V_M1_MF2_MASK, PseudoVLOXEI16_V_M1_MF2, 0x3 }, // 1082
  { PseudoVLOXEI16_V_M2_M1_MASK, PseudoVLOXEI16_V_M2_M1, 0x3 }, // 1083
  { PseudoVLOXEI16_V_M2_M2_MASK, PseudoVLOXEI16_V_M2_M2, 0x3 }, // 1084
  { PseudoVLOXEI16_V_M2_M4_MASK, PseudoVLOXEI16_V_M2_M4, 0x3 }, // 1085
  { PseudoVLOXEI16_V_M2_M8_MASK, PseudoVLOXEI16_V_M2_M8, 0x3 }, // 1086
  { PseudoVLOXEI16_V_M4_M2_MASK, PseudoVLOXEI16_V_M4_M2, 0x3 }, // 1087
  { PseudoVLOXEI16_V_M4_M4_MASK, PseudoVLOXEI16_V_M4_M4, 0x3 }, // 1088
  { PseudoVLOXEI16_V_M4_M8_MASK, PseudoVLOXEI16_V_M4_M8, 0x3 }, // 1089
  { PseudoVLOXEI16_V_M8_M4_MASK, PseudoVLOXEI16_V_M8_M4, 0x3 }, // 1090
  { PseudoVLOXEI16_V_M8_M8_MASK, PseudoVLOXEI16_V_M8_M8, 0x3 }, // 1091
  { PseudoVLOXEI16_V_MF2_M1_MASK, PseudoVLOXEI16_V_MF2_M1, 0x3 }, // 1092
  { PseudoVLOXEI16_V_MF2_M2_MASK, PseudoVLOXEI16_V_MF2_M2, 0x3 }, // 1093
  { PseudoVLOXEI16_V_MF2_MF2_MASK, PseudoVLOXEI16_V_MF2_MF2, 0x3 }, // 1094
  { PseudoVLOXEI16_V_MF2_MF4_MASK, PseudoVLOXEI16_V_MF2_MF4, 0x3 }, // 1095
  { PseudoVLOXEI16_V_MF4_M1_MASK, PseudoVLOXEI16_V_MF4_M1, 0x3 }, // 1096
  { PseudoVLOXEI16_V_MF4_MF2_MASK, PseudoVLOXEI16_V_MF4_MF2, 0x3 }, // 1097
  { PseudoVLOXEI16_V_MF4_MF4_MASK, PseudoVLOXEI16_V_MF4_MF4, 0x3 }, // 1098
  { PseudoVLOXEI16_V_MF4_MF8_MASK, PseudoVLOXEI16_V_MF4_MF8, 0x3 }, // 1099
  { PseudoVLOXEI32_V_M1_M1_MASK, PseudoVLOXEI32_V_M1_M1, 0x3 }, // 1100
  { PseudoVLOXEI32_V_M1_M2_MASK, PseudoVLOXEI32_V_M1_M2, 0x3 }, // 1101
  { PseudoVLOXEI32_V_M1_MF2_MASK, PseudoVLOXEI32_V_M1_MF2, 0x3 }, // 1102
  { PseudoVLOXEI32_V_M1_MF4_MASK, PseudoVLOXEI32_V_M1_MF4, 0x3 }, // 1103
  { PseudoVLOXEI32_V_M2_M1_MASK, PseudoVLOXEI32_V_M2_M1, 0x3 }, // 1104
  { PseudoVLOXEI32_V_M2_M2_MASK, PseudoVLOXEI32_V_M2_M2, 0x3 }, // 1105
  { PseudoVLOXEI32_V_M2_M4_MASK, PseudoVLOXEI32_V_M2_M4, 0x3 }, // 1106
  { PseudoVLOXEI32_V_M2_MF2_MASK, PseudoVLOXEI32_V_M2_MF2, 0x3 }, // 1107
  { PseudoVLOXEI32_V_M4_M1_MASK, PseudoVLOXEI32_V_M4_M1, 0x3 }, // 1108
  { PseudoVLOXEI32_V_M4_M2_MASK, PseudoVLOXEI32_V_M4_M2, 0x3 }, // 1109
  { PseudoVLOXEI32_V_M4_M4_MASK, PseudoVLOXEI32_V_M4_M4, 0x3 }, // 1110
  { PseudoVLOXEI32_V_M4_M8_MASK, PseudoVLOXEI32_V_M4_M8, 0x3 }, // 1111
  { PseudoVLOXEI32_V_M8_M2_MASK, PseudoVLOXEI32_V_M8_M2, 0x3 }, // 1112
  { PseudoVLOXEI32_V_M8_M4_MASK, PseudoVLOXEI32_V_M8_M4, 0x3 }, // 1113
  { PseudoVLOXEI32_V_M8_M8_MASK, PseudoVLOXEI32_V_M8_M8, 0x3 }, // 1114
  { PseudoVLOXEI32_V_MF2_M1_MASK, PseudoVLOXEI32_V_MF2_M1, 0x3 }, // 1115
  { PseudoVLOXEI32_V_MF2_MF2_MASK, PseudoVLOXEI32_V_MF2_MF2, 0x3 }, // 1116
  { PseudoVLOXEI32_V_MF2_MF4_MASK, PseudoVLOXEI32_V_MF2_MF4, 0x3 }, // 1117
  { PseudoVLOXEI32_V_MF2_MF8_MASK, PseudoVLOXEI32_V_MF2_MF8, 0x3 }, // 1118
  { PseudoVLOXEI64_V_M1_M1_MASK, PseudoVLOXEI64_V_M1_M1, 0x3 }, // 1119
  { PseudoVLOXEI64_V_M1_MF2_MASK, PseudoVLOXEI64_V_M1_MF2, 0x3 }, // 1120
  { PseudoVLOXEI64_V_M1_MF4_MASK, PseudoVLOXEI64_V_M1_MF4, 0x3 }, // 1121
  { PseudoVLOXEI64_V_M1_MF8_MASK, PseudoVLOXEI64_V_M1_MF8, 0x3 }, // 1122
  { PseudoVLOXEI64_V_M2_M1_MASK, PseudoVLOXEI64_V_M2_M1, 0x3 }, // 1123
  { PseudoVLOXEI64_V_M2_M2_MASK, PseudoVLOXEI64_V_M2_M2, 0x3 }, // 1124
  { PseudoVLOXEI64_V_M2_MF2_MASK, PseudoVLOXEI64_V_M2_MF2, 0x3 }, // 1125
  { PseudoVLOXEI64_V_M2_MF4_MASK, PseudoVLOXEI64_V_M2_MF4, 0x3 }, // 1126
  { PseudoVLOXEI64_V_M4_M1_MASK, PseudoVLOXEI64_V_M4_M1, 0x3 }, // 1127
  { PseudoVLOXEI64_V_M4_M2_MASK, PseudoVLOXEI64_V_M4_M2, 0x3 }, // 1128
  { PseudoVLOXEI64_V_M4_M4_MASK, PseudoVLOXEI64_V_M4_M4, 0x3 }, // 1129
  { PseudoVLOXEI64_V_M4_MF2_MASK, PseudoVLOXEI64_V_M4_MF2, 0x3 }, // 1130
  { PseudoVLOXEI64_V_M8_M1_MASK, PseudoVLOXEI64_V_M8_M1, 0x3 }, // 1131
  { PseudoVLOXEI64_V_M8_M2_MASK, PseudoVLOXEI64_V_M8_M2, 0x3 }, // 1132
  { PseudoVLOXEI64_V_M8_M4_MASK, PseudoVLOXEI64_V_M8_M4, 0x3 }, // 1133
  { PseudoVLOXEI64_V_M8_M8_MASK, PseudoVLOXEI64_V_M8_M8, 0x3 }, // 1134
  { PseudoVLOXEI8_V_M1_M1_MASK, PseudoVLOXEI8_V_M1_M1, 0x3 }, // 1135
  { PseudoVLOXEI8_V_M1_M2_MASK, PseudoVLOXEI8_V_M1_M2, 0x3 }, // 1136
  { PseudoVLOXEI8_V_M1_M4_MASK, PseudoVLOXEI8_V_M1_M4, 0x3 }, // 1137
  { PseudoVLOXEI8_V_M1_M8_MASK, PseudoVLOXEI8_V_M1_M8, 0x3 }, // 1138
  { PseudoVLOXEI8_V_M2_M2_MASK, PseudoVLOXEI8_V_M2_M2, 0x3 }, // 1139
  { PseudoVLOXEI8_V_M2_M4_MASK, PseudoVLOXEI8_V_M2_M4, 0x3 }, // 1140
  { PseudoVLOXEI8_V_M2_M8_MASK, PseudoVLOXEI8_V_M2_M8, 0x3 }, // 1141
  { PseudoVLOXEI8_V_M4_M4_MASK, PseudoVLOXEI8_V_M4_M4, 0x3 }, // 1142
  { PseudoVLOXEI8_V_M4_M8_MASK, PseudoVLOXEI8_V_M4_M8, 0x3 }, // 1143
  { PseudoVLOXEI8_V_M8_M8_MASK, PseudoVLOXEI8_V_M8_M8, 0x3 }, // 1144
  { PseudoVLOXEI8_V_MF2_M1_MASK, PseudoVLOXEI8_V_MF2_M1, 0x3 }, // 1145
  { PseudoVLOXEI8_V_MF2_M2_MASK, PseudoVLOXEI8_V_MF2_M2, 0x3 }, // 1146
  { PseudoVLOXEI8_V_MF2_M4_MASK, PseudoVLOXEI8_V_MF2_M4, 0x3 }, // 1147
  { PseudoVLOXEI8_V_MF2_MF2_MASK, PseudoVLOXEI8_V_MF2_MF2, 0x3 }, // 1148
  { PseudoVLOXEI8_V_MF4_M1_MASK, PseudoVLOXEI8_V_MF4_M1, 0x3 }, // 1149
  { PseudoVLOXEI8_V_MF4_M2_MASK, PseudoVLOXEI8_V_MF4_M2, 0x3 }, // 1150
  { PseudoVLOXEI8_V_MF4_MF2_MASK, PseudoVLOXEI8_V_MF4_MF2, 0x3 }, // 1151
  { PseudoVLOXEI8_V_MF4_MF4_MASK, PseudoVLOXEI8_V_MF4_MF4, 0x3 }, // 1152
  { PseudoVLOXEI8_V_MF8_M1_MASK, PseudoVLOXEI8_V_MF8_M1, 0x3 }, // 1153
  { PseudoVLOXEI8_V_MF8_MF2_MASK, PseudoVLOXEI8_V_MF8_MF2, 0x3 }, // 1154
  { PseudoVLOXEI8_V_MF8_MF4_MASK, PseudoVLOXEI8_V_MF8_MF4, 0x3 }, // 1155
  { PseudoVLOXEI8_V_MF8_MF8_MASK, PseudoVLOXEI8_V_MF8_MF8, 0x3 }, // 1156
  { PseudoVLSE16_V_M1_MASK, PseudoVLSE16_V_M1, 0x3 }, // 1157
  { PseudoVLSE16_V_M2_MASK, PseudoVLSE16_V_M2, 0x3 }, // 1158
  { PseudoVLSE16_V_M4_MASK, PseudoVLSE16_V_M4, 0x3 }, // 1159
  { PseudoVLSE16_V_M8_MASK, PseudoVLSE16_V_M8, 0x3 }, // 1160
  { PseudoVLSE16_V_MF2_MASK, PseudoVLSE16_V_MF2, 0x3 }, // 1161
  { PseudoVLSE16_V_MF4_MASK, PseudoVLSE16_V_MF4, 0x3 }, // 1162
  { PseudoVLSE32_V_M1_MASK, PseudoVLSE32_V_M1, 0x3 }, // 1163
  { PseudoVLSE32_V_M2_MASK, PseudoVLSE32_V_M2, 0x3 }, // 1164
  { PseudoVLSE32_V_M4_MASK, PseudoVLSE32_V_M4, 0x3 }, // 1165
  { PseudoVLSE32_V_M8_MASK, PseudoVLSE32_V_M8, 0x3 }, // 1166
  { PseudoVLSE32_V_MF2_MASK, PseudoVLSE32_V_MF2, 0x3 }, // 1167
  { PseudoVLSE64_V_M1_MASK, PseudoVLSE64_V_M1, 0x3 }, // 1168
  { PseudoVLSE64_V_M2_MASK, PseudoVLSE64_V_M2, 0x3 }, // 1169
  { PseudoVLSE64_V_M4_MASK, PseudoVLSE64_V_M4, 0x3 }, // 1170
  { PseudoVLSE64_V_M8_MASK, PseudoVLSE64_V_M8, 0x3 }, // 1171
  { PseudoVLSE8_V_M1_MASK, PseudoVLSE8_V_M1, 0x3 }, // 1172
  { PseudoVLSE8_V_M2_MASK, PseudoVLSE8_V_M2, 0x3 }, // 1173
  { PseudoVLSE8_V_M4_MASK, PseudoVLSE8_V_M4, 0x3 }, // 1174
  { PseudoVLSE8_V_M8_MASK, PseudoVLSE8_V_M8, 0x3 }, // 1175
  { PseudoVLSE8_V_MF2_MASK, PseudoVLSE8_V_MF2, 0x3 }, // 1176
  { PseudoVLSE8_V_MF4_MASK, PseudoVLSE8_V_MF4, 0x3 }, // 1177
  { PseudoVLSE8_V_MF8_MASK, PseudoVLSE8_V_MF8, 0x3 }, // 1178
  { PseudoVLUXEI16_V_M1_M1_MASK, PseudoVLUXEI16_V_M1_M1, 0x3 }, // 1179
  { PseudoVLUXEI16_V_M1_M2_MASK, PseudoVLUXEI16_V_M1_M2, 0x3 }, // 1180
  { PseudoVLUXEI16_V_M1_M4_MASK, PseudoVLUXEI16_V_M1_M4, 0x3 }, // 1181
  { PseudoVLUXEI16_V_M1_MF2_MASK, PseudoVLUXEI16_V_M1_MF2, 0x3 }, // 1182
  { PseudoVLUXEI16_V_M2_M1_MASK, PseudoVLUXEI16_V_M2_M1, 0x3 }, // 1183
  { PseudoVLUXEI16_V_M2_M2_MASK, PseudoVLUXEI16_V_M2_M2, 0x3 }, // 1184
  { PseudoVLUXEI16_V_M2_M4_MASK, PseudoVLUXEI16_V_M2_M4, 0x3 }, // 1185
  { PseudoVLUXEI16_V_M2_M8_MASK, PseudoVLUXEI16_V_M2_M8, 0x3 }, // 1186
  { PseudoVLUXEI16_V_M4_M2_MASK, PseudoVLUXEI16_V_M4_M2, 0x3 }, // 1187
  { PseudoVLUXEI16_V_M4_M4_MASK, PseudoVLUXEI16_V_M4_M4, 0x3 }, // 1188
  { PseudoVLUXEI16_V_M4_M8_MASK, PseudoVLUXEI16_V_M4_M8, 0x3 }, // 1189
  { PseudoVLUXEI16_V_M8_M4_MASK, PseudoVLUXEI16_V_M8_M4, 0x3 }, // 1190
  { PseudoVLUXEI16_V_M8_M8_MASK, PseudoVLUXEI16_V_M8_M8, 0x3 }, // 1191
  { PseudoVLUXEI16_V_MF2_M1_MASK, PseudoVLUXEI16_V_MF2_M1, 0x3 }, // 1192
  { PseudoVLUXEI16_V_MF2_M2_MASK, PseudoVLUXEI16_V_MF2_M2, 0x3 }, // 1193
  { PseudoVLUXEI16_V_MF2_MF2_MASK, PseudoVLUXEI16_V_MF2_MF2, 0x3 }, // 1194
  { PseudoVLUXEI16_V_MF2_MF4_MASK, PseudoVLUXEI16_V_MF2_MF4, 0x3 }, // 1195
  { PseudoVLUXEI16_V_MF4_M1_MASK, PseudoVLUXEI16_V_MF4_M1, 0x3 }, // 1196
  { PseudoVLUXEI16_V_MF4_MF2_MASK, PseudoVLUXEI16_V_MF4_MF2, 0x3 }, // 1197
  { PseudoVLUXEI16_V_MF4_MF4_MASK, PseudoVLUXEI16_V_MF4_MF4, 0x3 }, // 1198
  { PseudoVLUXEI16_V_MF4_MF8_MASK, PseudoVLUXEI16_V_MF4_MF8, 0x3 }, // 1199
  { PseudoVLUXEI32_V_M1_M1_MASK, PseudoVLUXEI32_V_M1_M1, 0x3 }, // 1200
  { PseudoVLUXEI32_V_M1_M2_MASK, PseudoVLUXEI32_V_M1_M2, 0x3 }, // 1201
  { PseudoVLUXEI32_V_M1_MF2_MASK, PseudoVLUXEI32_V_M1_MF2, 0x3 }, // 1202
  { PseudoVLUXEI32_V_M1_MF4_MASK, PseudoVLUXEI32_V_M1_MF4, 0x3 }, // 1203
  { PseudoVLUXEI32_V_M2_M1_MASK, PseudoVLUXEI32_V_M2_M1, 0x3 }, // 1204
  { PseudoVLUXEI32_V_M2_M2_MASK, PseudoVLUXEI32_V_M2_M2, 0x3 }, // 1205
  { PseudoVLUXEI32_V_M2_M4_MASK, PseudoVLUXEI32_V_M2_M4, 0x3 }, // 1206
  { PseudoVLUXEI32_V_M2_MF2_MASK, PseudoVLUXEI32_V_M2_MF2, 0x3 }, // 1207
  { PseudoVLUXEI32_V_M4_M1_MASK, PseudoVLUXEI32_V_M4_M1, 0x3 }, // 1208
  { PseudoVLUXEI32_V_M4_M2_MASK, PseudoVLUXEI32_V_M4_M2, 0x3 }, // 1209
  { PseudoVLUXEI32_V_M4_M4_MASK, PseudoVLUXEI32_V_M4_M4, 0x3 }, // 1210
  { PseudoVLUXEI32_V_M4_M8_MASK, PseudoVLUXEI32_V_M4_M8, 0x3 }, // 1211
  { PseudoVLUXEI32_V_M8_M2_MASK, PseudoVLUXEI32_V_M8_M2, 0x3 }, // 1212
  { PseudoVLUXEI32_V_M8_M4_MASK, PseudoVLUXEI32_V_M8_M4, 0x3 }, // 1213
  { PseudoVLUXEI32_V_M8_M8_MASK, PseudoVLUXEI32_V_M8_M8, 0x3 }, // 1214
  { PseudoVLUXEI32_V_MF2_M1_MASK, PseudoVLUXEI32_V_MF2_M1, 0x3 }, // 1215
  { PseudoVLUXEI32_V_MF2_MF2_MASK, PseudoVLUXEI32_V_MF2_MF2, 0x3 }, // 1216
  { PseudoVLUXEI32_V_MF2_MF4_MASK, PseudoVLUXEI32_V_MF2_MF4, 0x3 }, // 1217
  { PseudoVLUXEI32_V_MF2_MF8_MASK, PseudoVLUXEI32_V_MF2_MF8, 0x3 }, // 1218
  { PseudoVLUXEI64_V_M1_M1_MASK, PseudoVLUXEI64_V_M1_M1, 0x3 }, // 1219
  { PseudoVLUXEI64_V_M1_MF2_MASK, PseudoVLUXEI64_V_M1_MF2, 0x3 }, // 1220
  { PseudoVLUXEI64_V_M1_MF4_MASK, PseudoVLUXEI64_V_M1_MF4, 0x3 }, // 1221
  { PseudoVLUXEI64_V_M1_MF8_MASK, PseudoVLUXEI64_V_M1_MF8, 0x3 }, // 1222
  { PseudoVLUXEI64_V_M2_M1_MASK, PseudoVLUXEI64_V_M2_M1, 0x3 }, // 1223
  { PseudoVLUXEI64_V_M2_M2_MASK, PseudoVLUXEI64_V_M2_M2, 0x3 }, // 1224
  { PseudoVLUXEI64_V_M2_MF2_MASK, PseudoVLUXEI64_V_M2_MF2, 0x3 }, // 1225
  { PseudoVLUXEI64_V_M2_MF4_MASK, PseudoVLUXEI64_V_M2_MF4, 0x3 }, // 1226
  { PseudoVLUXEI64_V_M4_M1_MASK, PseudoVLUXEI64_V_M4_M1, 0x3 }, // 1227
  { PseudoVLUXEI64_V_M4_M2_MASK, PseudoVLUXEI64_V_M4_M2, 0x3 }, // 1228
  { PseudoVLUXEI64_V_M4_M4_MASK, PseudoVLUXEI64_V_M4_M4, 0x3 }, // 1229
  { PseudoVLUXEI64_V_M4_MF2_MASK, PseudoVLUXEI64_V_M4_MF2, 0x3 }, // 1230
  { PseudoVLUXEI64_V_M8_M1_MASK, PseudoVLUXEI64_V_M8_M1, 0x3 }, // 1231
  { PseudoVLUXEI64_V_M8_M2_MASK, PseudoVLUXEI64_V_M8_M2, 0x3 }, // 1232
  { PseudoVLUXEI64_V_M8_M4_MASK, PseudoVLUXEI64_V_M8_M4, 0x3 }, // 1233
  { PseudoVLUXEI64_V_M8_M8_MASK, PseudoVLUXEI64_V_M8_M8, 0x3 }, // 1234
  { PseudoVLUXEI8_V_M1_M1_MASK, PseudoVLUXEI8_V_M1_M1, 0x3 }, // 1235
  { PseudoVLUXEI8_V_M1_M2_MASK, PseudoVLUXEI8_V_M1_M2, 0x3 }, // 1236
  { PseudoVLUXEI8_V_M1_M4_MASK, PseudoVLUXEI8_V_M1_M4, 0x3 }, // 1237
  { PseudoVLUXEI8_V_M1_M8_MASK, PseudoVLUXEI8_V_M1_M8, 0x3 }, // 1238
  { PseudoVLUXEI8_V_M2_M2_MASK, PseudoVLUXEI8_V_M2_M2, 0x3 }, // 1239
  { PseudoVLUXEI8_V_M2_M4_MASK, PseudoVLUXEI8_V_M2_M4, 0x3 }, // 1240
  { PseudoVLUXEI8_V_M2_M8_MASK, PseudoVLUXEI8_V_M2_M8, 0x3 }, // 1241
  { PseudoVLUXEI8_V_M4_M4_MASK, PseudoVLUXEI8_V_M4_M4, 0x3 }, // 1242
  { PseudoVLUXEI8_V_M4_M8_MASK, PseudoVLUXEI8_V_M4_M8, 0x3 }, // 1243
  { PseudoVLUXEI8_V_M8_M8_MASK, PseudoVLUXEI8_V_M8_M8, 0x3 }, // 1244
  { PseudoVLUXEI8_V_MF2_M1_MASK, PseudoVLUXEI8_V_MF2_M1, 0x3 }, // 1245
  { PseudoVLUXEI8_V_MF2_M2_MASK, PseudoVLUXEI8_V_MF2_M2, 0x3 }, // 1246
  { PseudoVLUXEI8_V_MF2_M4_MASK, PseudoVLUXEI8_V_MF2_M4, 0x3 }, // 1247
  { PseudoVLUXEI8_V_MF2_MF2_MASK, PseudoVLUXEI8_V_MF2_MF2, 0x3 }, // 1248
  { PseudoVLUXEI8_V_MF4_M1_MASK, PseudoVLUXEI8_V_MF4_M1, 0x3 }, // 1249
  { PseudoVLUXEI8_V_MF4_M2_MASK, PseudoVLUXEI8_V_MF4_M2, 0x3 }, // 1250
  { PseudoVLUXEI8_V_MF4_MF2_MASK, PseudoVLUXEI8_V_MF4_MF2, 0x3 }, // 1251
  { PseudoVLUXEI8_V_MF4_MF4_MASK, PseudoVLUXEI8_V_MF4_MF4, 0x3 }, // 1252
  { PseudoVLUXEI8_V_MF8_M1_MASK, PseudoVLUXEI8_V_MF8_M1, 0x3 }, // 1253
  { PseudoVLUXEI8_V_MF8_MF2_MASK, PseudoVLUXEI8_V_MF8_MF2, 0x3 }, // 1254
  { PseudoVLUXEI8_V_MF8_MF4_MASK, PseudoVLUXEI8_V_MF8_MF4, 0x3 }, // 1255
  { PseudoVLUXEI8_V_MF8_MF8_MASK, PseudoVLUXEI8_V_MF8_MF8, 0x3 }, // 1256
  { PseudoVMACC_VV_M1_MASK, PseudoVMACC_VV_M1, 0x3 }, // 1257
  { PseudoVMACC_VV_M2_MASK, PseudoVMACC_VV_M2, 0x3 }, // 1258
  { PseudoVMACC_VV_M4_MASK, PseudoVMACC_VV_M4, 0x3 }, // 1259
  { PseudoVMACC_VV_M8_MASK, PseudoVMACC_VV_M8, 0x3 }, // 1260
  { PseudoVMACC_VV_MF2_MASK, PseudoVMACC_VV_MF2, 0x3 }, // 1261
  { PseudoVMACC_VV_MF4_MASK, PseudoVMACC_VV_MF4, 0x3 }, // 1262
  { PseudoVMACC_VV_MF8_MASK, PseudoVMACC_VV_MF8, 0x3 }, // 1263
  { PseudoVMACC_VX_M1_MASK, PseudoVMACC_VX_M1, 0x3 }, // 1264
  { PseudoVMACC_VX_M2_MASK, PseudoVMACC_VX_M2, 0x3 }, // 1265
  { PseudoVMACC_VX_M4_MASK, PseudoVMACC_VX_M4, 0x3 }, // 1266
  { PseudoVMACC_VX_M8_MASK, PseudoVMACC_VX_M8, 0x3 }, // 1267
  { PseudoVMACC_VX_MF2_MASK, PseudoVMACC_VX_MF2, 0x3 }, // 1268
  { PseudoVMACC_VX_MF4_MASK, PseudoVMACC_VX_MF4, 0x3 }, // 1269
  { PseudoVMACC_VX_MF8_MASK, PseudoVMACC_VX_MF8, 0x3 }, // 1270
  { PseudoVMADD_VV_M1_MASK, PseudoVMADD_VV_M1, 0x3 }, // 1271
  { PseudoVMADD_VV_M2_MASK, PseudoVMADD_VV_M2, 0x3 }, // 1272
  { PseudoVMADD_VV_M4_MASK, PseudoVMADD_VV_M4, 0x3 }, // 1273
  { PseudoVMADD_VV_M8_MASK, PseudoVMADD_VV_M8, 0x3 }, // 1274
  { PseudoVMADD_VV_MF2_MASK, PseudoVMADD_VV_MF2, 0x3 }, // 1275
  { PseudoVMADD_VV_MF4_MASK, PseudoVMADD_VV_MF4, 0x3 }, // 1276
  { PseudoVMADD_VV_MF8_MASK, PseudoVMADD_VV_MF8, 0x3 }, // 1277
  { PseudoVMADD_VX_M1_MASK, PseudoVMADD_VX_M1, 0x3 }, // 1278
  { PseudoVMADD_VX_M2_MASK, PseudoVMADD_VX_M2, 0x3 }, // 1279
  { PseudoVMADD_VX_M4_MASK, PseudoVMADD_VX_M4, 0x3 }, // 1280
  { PseudoVMADD_VX_M8_MASK, PseudoVMADD_VX_M8, 0x3 }, // 1281
  { PseudoVMADD_VX_MF2_MASK, PseudoVMADD_VX_MF2, 0x3 }, // 1282
  { PseudoVMADD_VX_MF4_MASK, PseudoVMADD_VX_MF4, 0x3 }, // 1283
  { PseudoVMADD_VX_MF8_MASK, PseudoVMADD_VX_MF8, 0x3 }, // 1284
  { PseudoVMAXU_VV_M1_MASK, PseudoVMAXU_VV_M1, 0x3 }, // 1285
  { PseudoVMAXU_VV_M2_MASK, PseudoVMAXU_VV_M2, 0x3 }, // 1286
  { PseudoVMAXU_VV_M4_MASK, PseudoVMAXU_VV_M4, 0x3 }, // 1287
  { PseudoVMAXU_VV_M8_MASK, PseudoVMAXU_VV_M8, 0x3 }, // 1288
  { PseudoVMAXU_VV_MF2_MASK, PseudoVMAXU_VV_MF2, 0x3 }, // 1289
  { PseudoVMAXU_VV_MF4_MASK, PseudoVMAXU_VV_MF4, 0x3 }, // 1290
  { PseudoVMAXU_VV_MF8_MASK, PseudoVMAXU_VV_MF8, 0x3 }, // 1291
  { PseudoVMAXU_VX_M1_MASK, PseudoVMAXU_VX_M1, 0x3 }, // 1292
  { PseudoVMAXU_VX_M2_MASK, PseudoVMAXU_VX_M2, 0x3 }, // 1293
  { PseudoVMAXU_VX_M4_MASK, PseudoVMAXU_VX_M4, 0x3 }, // 1294
  { PseudoVMAXU_VX_M8_MASK, PseudoVMAXU_VX_M8, 0x3 }, // 1295
  { PseudoVMAXU_VX_MF2_MASK, PseudoVMAXU_VX_MF2, 0x3 }, // 1296
  { PseudoVMAXU_VX_MF4_MASK, PseudoVMAXU_VX_MF4, 0x3 }, // 1297
  { PseudoVMAXU_VX_MF8_MASK, PseudoVMAXU_VX_MF8, 0x3 }, // 1298
  { PseudoVMAX_VV_M1_MASK, PseudoVMAX_VV_M1, 0x3 }, // 1299
  { PseudoVMAX_VV_M2_MASK, PseudoVMAX_VV_M2, 0x3 }, // 1300
  { PseudoVMAX_VV_M4_MASK, PseudoVMAX_VV_M4, 0x3 }, // 1301
  { PseudoVMAX_VV_M8_MASK, PseudoVMAX_VV_M8, 0x3 }, // 1302
  { PseudoVMAX_VV_MF2_MASK, PseudoVMAX_VV_MF2, 0x3 }, // 1303
  { PseudoVMAX_VV_MF4_MASK, PseudoVMAX_VV_MF4, 0x3 }, // 1304
  { PseudoVMAX_VV_MF8_MASK, PseudoVMAX_VV_MF8, 0x3 }, // 1305
  { PseudoVMAX_VX_M1_MASK, PseudoVMAX_VX_M1, 0x3 }, // 1306
  { PseudoVMAX_VX_M2_MASK, PseudoVMAX_VX_M2, 0x3 }, // 1307
  { PseudoVMAX_VX_M4_MASK, PseudoVMAX_VX_M4, 0x3 }, // 1308
  { PseudoVMAX_VX_M8_MASK, PseudoVMAX_VX_M8, 0x3 }, // 1309
  { PseudoVMAX_VX_MF2_MASK, PseudoVMAX_VX_MF2, 0x3 }, // 1310
  { PseudoVMAX_VX_MF4_MASK, PseudoVMAX_VX_MF4, 0x3 }, // 1311
  { PseudoVMAX_VX_MF8_MASK, PseudoVMAX_VX_MF8, 0x3 }, // 1312
  { PseudoVMFEQ_VF16_M1_MASK, PseudoVMFEQ_VF16_M1, 0x3 }, // 1313
  { PseudoVMFEQ_VF16_M2_MASK, PseudoVMFEQ_VF16_M2, 0x3 }, // 1314
  { PseudoVMFEQ_VF16_M4_MASK, PseudoVMFEQ_VF16_M4, 0x3 }, // 1315
  { PseudoVMFEQ_VF16_M8_MASK, PseudoVMFEQ_VF16_M8, 0x3 }, // 1316
  { PseudoVMFEQ_VF16_MF2_MASK, PseudoVMFEQ_VF16_MF2, 0x3 }, // 1317
  { PseudoVMFEQ_VF16_MF4_MASK, PseudoVMFEQ_VF16_MF4, 0x3 }, // 1318
  { PseudoVMFEQ_VF32_M1_MASK, PseudoVMFEQ_VF32_M1, 0x3 }, // 1319
  { PseudoVMFEQ_VF32_M2_MASK, PseudoVMFEQ_VF32_M2, 0x3 }, // 1320
  { PseudoVMFEQ_VF32_M4_MASK, PseudoVMFEQ_VF32_M4, 0x3 }, // 1321
  { PseudoVMFEQ_VF32_M8_MASK, PseudoVMFEQ_VF32_M8, 0x3 }, // 1322
  { PseudoVMFEQ_VF32_MF2_MASK, PseudoVMFEQ_VF32_MF2, 0x3 }, // 1323
  { PseudoVMFEQ_VF64_M1_MASK, PseudoVMFEQ_VF64_M1, 0x3 }, // 1324
  { PseudoVMFEQ_VF64_M2_MASK, PseudoVMFEQ_VF64_M2, 0x3 }, // 1325
  { PseudoVMFEQ_VF64_M4_MASK, PseudoVMFEQ_VF64_M4, 0x3 }, // 1326
  { PseudoVMFEQ_VF64_M8_MASK, PseudoVMFEQ_VF64_M8, 0x3 }, // 1327
  { PseudoVMFEQ_VV_M1_MASK, PseudoVMFEQ_VV_M1, 0x3 }, // 1328
  { PseudoVMFEQ_VV_M2_MASK, PseudoVMFEQ_VV_M2, 0x3 }, // 1329
  { PseudoVMFEQ_VV_M4_MASK, PseudoVMFEQ_VV_M4, 0x3 }, // 1330
  { PseudoVMFEQ_VV_M8_MASK, PseudoVMFEQ_VV_M8, 0x3 }, // 1331
  { PseudoVMFEQ_VV_MF2_MASK, PseudoVMFEQ_VV_MF2, 0x3 }, // 1332
  { PseudoVMFEQ_VV_MF4_MASK, PseudoVMFEQ_VV_MF4, 0x3 }, // 1333
  { PseudoVMFGE_VF16_M1_MASK, PseudoVMFGE_VF16_M1, 0x3 }, // 1334
  { PseudoVMFGE_VF16_M2_MASK, PseudoVMFGE_VF16_M2, 0x3 }, // 1335
  { PseudoVMFGE_VF16_M4_MASK, PseudoVMFGE_VF16_M4, 0x3 }, // 1336
  { PseudoVMFGE_VF16_M8_MASK, PseudoVMFGE_VF16_M8, 0x3 }, // 1337
  { PseudoVMFGE_VF16_MF2_MASK, PseudoVMFGE_VF16_MF2, 0x3 }, // 1338
  { PseudoVMFGE_VF16_MF4_MASK, PseudoVMFGE_VF16_MF4, 0x3 }, // 1339
  { PseudoVMFGE_VF32_M1_MASK, PseudoVMFGE_VF32_M1, 0x3 }, // 1340
  { PseudoVMFGE_VF32_M2_MASK, PseudoVMFGE_VF32_M2, 0x3 }, // 1341
  { PseudoVMFGE_VF32_M4_MASK, PseudoVMFGE_VF32_M4, 0x3 }, // 1342
  { PseudoVMFGE_VF32_M8_MASK, PseudoVMFGE_VF32_M8, 0x3 }, // 1343
  { PseudoVMFGE_VF32_MF2_MASK, PseudoVMFGE_VF32_MF2, 0x3 }, // 1344
  { PseudoVMFGE_VF64_M1_MASK, PseudoVMFGE_VF64_M1, 0x3 }, // 1345
  { PseudoVMFGE_VF64_M2_MASK, PseudoVMFGE_VF64_M2, 0x3 }, // 1346
  { PseudoVMFGE_VF64_M4_MASK, PseudoVMFGE_VF64_M4, 0x3 }, // 1347
  { PseudoVMFGE_VF64_M8_MASK, PseudoVMFGE_VF64_M8, 0x3 }, // 1348
  { PseudoVMFGT_VF16_M1_MASK, PseudoVMFGT_VF16_M1, 0x3 }, // 1349
  { PseudoVMFGT_VF16_M2_MASK, PseudoVMFGT_VF16_M2, 0x3 }, // 1350
  { PseudoVMFGT_VF16_M4_MASK, PseudoVMFGT_VF16_M4, 0x3 }, // 1351
  { PseudoVMFGT_VF16_M8_MASK, PseudoVMFGT_VF16_M8, 0x3 }, // 1352
  { PseudoVMFGT_VF16_MF2_MASK, PseudoVMFGT_VF16_MF2, 0x3 }, // 1353
  { PseudoVMFGT_VF16_MF4_MASK, PseudoVMFGT_VF16_MF4, 0x3 }, // 1354
  { PseudoVMFGT_VF32_M1_MASK, PseudoVMFGT_VF32_M1, 0x3 }, // 1355
  { PseudoVMFGT_VF32_M2_MASK, PseudoVMFGT_VF32_M2, 0x3 }, // 1356
  { PseudoVMFGT_VF32_M4_MASK, PseudoVMFGT_VF32_M4, 0x3 }, // 1357
  { PseudoVMFGT_VF32_M8_MASK, PseudoVMFGT_VF32_M8, 0x3 }, // 1358
  { PseudoVMFGT_VF32_MF2_MASK, PseudoVMFGT_VF32_MF2, 0x3 }, // 1359
  { PseudoVMFGT_VF64_M1_MASK, PseudoVMFGT_VF64_M1, 0x3 }, // 1360
  { PseudoVMFGT_VF64_M2_MASK, PseudoVMFGT_VF64_M2, 0x3 }, // 1361
  { PseudoVMFGT_VF64_M4_MASK, PseudoVMFGT_VF64_M4, 0x3 }, // 1362
  { PseudoVMFGT_VF64_M8_MASK, PseudoVMFGT_VF64_M8, 0x3 }, // 1363
  { PseudoVMFLE_VF16_M1_MASK, PseudoVMFLE_VF16_M1, 0x3 }, // 1364
  { PseudoVMFLE_VF16_M2_MASK, PseudoVMFLE_VF16_M2, 0x3 }, // 1365
  { PseudoVMFLE_VF16_M4_MASK, PseudoVMFLE_VF16_M4, 0x3 }, // 1366
  { PseudoVMFLE_VF16_M8_MASK, PseudoVMFLE_VF16_M8, 0x3 }, // 1367
  { PseudoVMFLE_VF16_MF2_MASK, PseudoVMFLE_VF16_MF2, 0x3 }, // 1368
  { PseudoVMFLE_VF16_MF4_MASK, PseudoVMFLE_VF16_MF4, 0x3 }, // 1369
  { PseudoVMFLE_VF32_M1_MASK, PseudoVMFLE_VF32_M1, 0x3 }, // 1370
  { PseudoVMFLE_VF32_M2_MASK, PseudoVMFLE_VF32_M2, 0x3 }, // 1371
  { PseudoVMFLE_VF32_M4_MASK, PseudoVMFLE_VF32_M4, 0x3 }, // 1372
  { PseudoVMFLE_VF32_M8_MASK, PseudoVMFLE_VF32_M8, 0x3 }, // 1373
  { PseudoVMFLE_VF32_MF2_MASK, PseudoVMFLE_VF32_MF2, 0x3 }, // 1374
  { PseudoVMFLE_VF64_M1_MASK, PseudoVMFLE_VF64_M1, 0x3 }, // 1375
  { PseudoVMFLE_VF64_M2_MASK, PseudoVMFLE_VF64_M2, 0x3 }, // 1376
  { PseudoVMFLE_VF64_M4_MASK, PseudoVMFLE_VF64_M4, 0x3 }, // 1377
  { PseudoVMFLE_VF64_M8_MASK, PseudoVMFLE_VF64_M8, 0x3 }, // 1378
  { PseudoVMFLE_VV_M1_MASK, PseudoVMFLE_VV_M1, 0x3 }, // 1379
  { PseudoVMFLE_VV_M2_MASK, PseudoVMFLE_VV_M2, 0x3 }, // 1380
  { PseudoVMFLE_VV_M4_MASK, PseudoVMFLE_VV_M4, 0x3 }, // 1381
  { PseudoVMFLE_VV_M8_MASK, PseudoVMFLE_VV_M8, 0x3 }, // 1382
  { PseudoVMFLE_VV_MF2_MASK, PseudoVMFLE_VV_MF2, 0x3 }, // 1383
  { PseudoVMFLE_VV_MF4_MASK, PseudoVMFLE_VV_MF4, 0x3 }, // 1384
  { PseudoVMFLT_VF16_M1_MASK, PseudoVMFLT_VF16_M1, 0x3 }, // 1385
  { PseudoVMFLT_VF16_M2_MASK, PseudoVMFLT_VF16_M2, 0x3 }, // 1386
  { PseudoVMFLT_VF16_M4_MASK, PseudoVMFLT_VF16_M4, 0x3 }, // 1387
  { PseudoVMFLT_VF16_M8_MASK, PseudoVMFLT_VF16_M8, 0x3 }, // 1388
  { PseudoVMFLT_VF16_MF2_MASK, PseudoVMFLT_VF16_MF2, 0x3 }, // 1389
  { PseudoVMFLT_VF16_MF4_MASK, PseudoVMFLT_VF16_MF4, 0x3 }, // 1390
  { PseudoVMFLT_VF32_M1_MASK, PseudoVMFLT_VF32_M1, 0x3 }, // 1391
  { PseudoVMFLT_VF32_M2_MASK, PseudoVMFLT_VF32_M2, 0x3 }, // 1392
  { PseudoVMFLT_VF32_M4_MASK, PseudoVMFLT_VF32_M4, 0x3 }, // 1393
  { PseudoVMFLT_VF32_M8_MASK, PseudoVMFLT_VF32_M8, 0x3 }, // 1394
  { PseudoVMFLT_VF32_MF2_MASK, PseudoVMFLT_VF32_MF2, 0x3 }, // 1395
  { PseudoVMFLT_VF64_M1_MASK, PseudoVMFLT_VF64_M1, 0x3 }, // 1396
  { PseudoVMFLT_VF64_M2_MASK, PseudoVMFLT_VF64_M2, 0x3 }, // 1397
  { PseudoVMFLT_VF64_M4_MASK, PseudoVMFLT_VF64_M4, 0x3 }, // 1398
  { PseudoVMFLT_VF64_M8_MASK, PseudoVMFLT_VF64_M8, 0x3 }, // 1399
  { PseudoVMFLT_VV_M1_MASK, PseudoVMFLT_VV_M1, 0x3 }, // 1400
  { PseudoVMFLT_VV_M2_MASK, PseudoVMFLT_VV_M2, 0x3 }, // 1401
  { PseudoVMFLT_VV_M4_MASK, PseudoVMFLT_VV_M4, 0x3 }, // 1402
  { PseudoVMFLT_VV_M8_MASK, PseudoVMFLT_VV_M8, 0x3 }, // 1403
  { PseudoVMFLT_VV_MF2_MASK, PseudoVMFLT_VV_MF2, 0x3 }, // 1404
  { PseudoVMFLT_VV_MF4_MASK, PseudoVMFLT_VV_MF4, 0x3 }, // 1405
  { PseudoVMFNE_VF16_M1_MASK, PseudoVMFNE_VF16_M1, 0x3 }, // 1406
  { PseudoVMFNE_VF16_M2_MASK, PseudoVMFNE_VF16_M2, 0x3 }, // 1407
  { PseudoVMFNE_VF16_M4_MASK, PseudoVMFNE_VF16_M4, 0x3 }, // 1408
  { PseudoVMFNE_VF16_M8_MASK, PseudoVMFNE_VF16_M8, 0x3 }, // 1409
  { PseudoVMFNE_VF16_MF2_MASK, PseudoVMFNE_VF16_MF2, 0x3 }, // 1410
  { PseudoVMFNE_VF16_MF4_MASK, PseudoVMFNE_VF16_MF4, 0x3 }, // 1411
  { PseudoVMFNE_VF32_M1_MASK, PseudoVMFNE_VF32_M1, 0x3 }, // 1412
  { PseudoVMFNE_VF32_M2_MASK, PseudoVMFNE_VF32_M2, 0x3 }, // 1413
  { PseudoVMFNE_VF32_M4_MASK, PseudoVMFNE_VF32_M4, 0x3 }, // 1414
  { PseudoVMFNE_VF32_M8_MASK, PseudoVMFNE_VF32_M8, 0x3 }, // 1415
  { PseudoVMFNE_VF32_MF2_MASK, PseudoVMFNE_VF32_MF2, 0x3 }, // 1416
  { PseudoVMFNE_VF64_M1_MASK, PseudoVMFNE_VF64_M1, 0x3 }, // 1417
  { PseudoVMFNE_VF64_M2_MASK, PseudoVMFNE_VF64_M2, 0x3 }, // 1418
  { PseudoVMFNE_VF64_M4_MASK, PseudoVMFNE_VF64_M4, 0x3 }, // 1419
  { PseudoVMFNE_VF64_M8_MASK, PseudoVMFNE_VF64_M8, 0x3 }, // 1420
  { PseudoVMFNE_VV_M1_MASK, PseudoVMFNE_VV_M1, 0x3 }, // 1421
  { PseudoVMFNE_VV_M2_MASK, PseudoVMFNE_VV_M2, 0x3 }, // 1422
  { PseudoVMFNE_VV_M4_MASK, PseudoVMFNE_VV_M4, 0x3 }, // 1423
  { PseudoVMFNE_VV_M8_MASK, PseudoVMFNE_VV_M8, 0x3 }, // 1424
  { PseudoVMFNE_VV_MF2_MASK, PseudoVMFNE_VV_MF2, 0x3 }, // 1425
  { PseudoVMFNE_VV_MF4_MASK, PseudoVMFNE_VV_MF4, 0x3 }, // 1426
  { PseudoVMINU_VV_M1_MASK, PseudoVMINU_VV_M1, 0x3 }, // 1427
  { PseudoVMINU_VV_M2_MASK, PseudoVMINU_VV_M2, 0x3 }, // 1428
  { PseudoVMINU_VV_M4_MASK, PseudoVMINU_VV_M4, 0x3 }, // 1429
  { PseudoVMINU_VV_M8_MASK, PseudoVMINU_VV_M8, 0x3 }, // 1430
  { PseudoVMINU_VV_MF2_MASK, PseudoVMINU_VV_MF2, 0x3 }, // 1431
  { PseudoVMINU_VV_MF4_MASK, PseudoVMINU_VV_MF4, 0x3 }, // 1432
  { PseudoVMINU_VV_MF8_MASK, PseudoVMINU_VV_MF8, 0x3 }, // 1433
  { PseudoVMINU_VX_M1_MASK, PseudoVMINU_VX_M1, 0x3 }, // 1434
  { PseudoVMINU_VX_M2_MASK, PseudoVMINU_VX_M2, 0x3 }, // 1435
  { PseudoVMINU_VX_M4_MASK, PseudoVMINU_VX_M4, 0x3 }, // 1436
  { PseudoVMINU_VX_M8_MASK, PseudoVMINU_VX_M8, 0x3 }, // 1437
  { PseudoVMINU_VX_MF2_MASK, PseudoVMINU_VX_MF2, 0x3 }, // 1438
  { PseudoVMINU_VX_MF4_MASK, PseudoVMINU_VX_MF4, 0x3 }, // 1439
  { PseudoVMINU_VX_MF8_MASK, PseudoVMINU_VX_MF8, 0x3 }, // 1440
  { PseudoVMIN_VV_M1_MASK, PseudoVMIN_VV_M1, 0x3 }, // 1441
  { PseudoVMIN_VV_M2_MASK, PseudoVMIN_VV_M2, 0x3 }, // 1442
  { PseudoVMIN_VV_M4_MASK, PseudoVMIN_VV_M4, 0x3 }, // 1443
  { PseudoVMIN_VV_M8_MASK, PseudoVMIN_VV_M8, 0x3 }, // 1444
  { PseudoVMIN_VV_MF2_MASK, PseudoVMIN_VV_MF2, 0x3 }, // 1445
  { PseudoVMIN_VV_MF4_MASK, PseudoVMIN_VV_MF4, 0x3 }, // 1446
  { PseudoVMIN_VV_MF8_MASK, PseudoVMIN_VV_MF8, 0x3 }, // 1447
  { PseudoVMIN_VX_M1_MASK, PseudoVMIN_VX_M1, 0x3 }, // 1448
  { PseudoVMIN_VX_M2_MASK, PseudoVMIN_VX_M2, 0x3 }, // 1449
  { PseudoVMIN_VX_M4_MASK, PseudoVMIN_VX_M4, 0x3 }, // 1450
  { PseudoVMIN_VX_M8_MASK, PseudoVMIN_VX_M8, 0x3 }, // 1451
  { PseudoVMIN_VX_MF2_MASK, PseudoVMIN_VX_MF2, 0x3 }, // 1452
  { PseudoVMIN_VX_MF4_MASK, PseudoVMIN_VX_MF4, 0x3 }, // 1453
  { PseudoVMIN_VX_MF8_MASK, PseudoVMIN_VX_MF8, 0x3 }, // 1454
  { PseudoVMSEQ_VI_M1_MASK, PseudoVMSEQ_VI_M1, 0x3 }, // 1455
  { PseudoVMSEQ_VI_M2_MASK, PseudoVMSEQ_VI_M2, 0x3 }, // 1456
  { PseudoVMSEQ_VI_M4_MASK, PseudoVMSEQ_VI_M4, 0x3 }, // 1457
  { PseudoVMSEQ_VI_M8_MASK, PseudoVMSEQ_VI_M8, 0x3 }, // 1458
  { PseudoVMSEQ_VI_MF2_MASK, PseudoVMSEQ_VI_MF2, 0x3 }, // 1459
  { PseudoVMSEQ_VI_MF4_MASK, PseudoVMSEQ_VI_MF4, 0x3 }, // 1460
  { PseudoVMSEQ_VI_MF8_MASK, PseudoVMSEQ_VI_MF8, 0x3 }, // 1461
  { PseudoVMSEQ_VV_M1_MASK, PseudoVMSEQ_VV_M1, 0x3 }, // 1462
  { PseudoVMSEQ_VV_M2_MASK, PseudoVMSEQ_VV_M2, 0x3 }, // 1463
  { PseudoVMSEQ_VV_M4_MASK, PseudoVMSEQ_VV_M4, 0x3 }, // 1464
  { PseudoVMSEQ_VV_M8_MASK, PseudoVMSEQ_VV_M8, 0x3 }, // 1465
  { PseudoVMSEQ_VV_MF2_MASK, PseudoVMSEQ_VV_MF2, 0x3 }, // 1466
  { PseudoVMSEQ_VV_MF4_MASK, PseudoVMSEQ_VV_MF4, 0x3 }, // 1467
  { PseudoVMSEQ_VV_MF8_MASK, PseudoVMSEQ_VV_MF8, 0x3 }, // 1468
  { PseudoVMSEQ_VX_M1_MASK, PseudoVMSEQ_VX_M1, 0x3 }, // 1469
  { PseudoVMSEQ_VX_M2_MASK, PseudoVMSEQ_VX_M2, 0x3 }, // 1470
  { PseudoVMSEQ_VX_M4_MASK, PseudoVMSEQ_VX_M4, 0x3 }, // 1471
  { PseudoVMSEQ_VX_M8_MASK, PseudoVMSEQ_VX_M8, 0x3 }, // 1472
  { PseudoVMSEQ_VX_MF2_MASK, PseudoVMSEQ_VX_MF2, 0x3 }, // 1473
  { PseudoVMSEQ_VX_MF4_MASK, PseudoVMSEQ_VX_MF4, 0x3 }, // 1474
  { PseudoVMSEQ_VX_MF8_MASK, PseudoVMSEQ_VX_MF8, 0x3 }, // 1475
  { PseudoVMSGTU_VI_M1_MASK, PseudoVMSGTU_VI_M1, 0x3 }, // 1476
  { PseudoVMSGTU_VI_M2_MASK, PseudoVMSGTU_VI_M2, 0x3 }, // 1477
  { PseudoVMSGTU_VI_M4_MASK, PseudoVMSGTU_VI_M4, 0x3 }, // 1478
  { PseudoVMSGTU_VI_M8_MASK, PseudoVMSGTU_VI_M8, 0x3 }, // 1479
  { PseudoVMSGTU_VI_MF2_MASK, PseudoVMSGTU_VI_MF2, 0x3 }, // 1480
  { PseudoVMSGTU_VI_MF4_MASK, PseudoVMSGTU_VI_MF4, 0x3 }, // 1481
  { PseudoVMSGTU_VI_MF8_MASK, PseudoVMSGTU_VI_MF8, 0x3 }, // 1482
  { PseudoVMSGTU_VX_M1_MASK, PseudoVMSGTU_VX_M1, 0x3 }, // 1483
  { PseudoVMSGTU_VX_M2_MASK, PseudoVMSGTU_VX_M2, 0x3 }, // 1484
  { PseudoVMSGTU_VX_M4_MASK, PseudoVMSGTU_VX_M4, 0x3 }, // 1485
  { PseudoVMSGTU_VX_M8_MASK, PseudoVMSGTU_VX_M8, 0x3 }, // 1486
  { PseudoVMSGTU_VX_MF2_MASK, PseudoVMSGTU_VX_MF2, 0x3 }, // 1487
  { PseudoVMSGTU_VX_MF4_MASK, PseudoVMSGTU_VX_MF4, 0x3 }, // 1488
  { PseudoVMSGTU_VX_MF8_MASK, PseudoVMSGTU_VX_MF8, 0x3 }, // 1489
  { PseudoVMSGT_VI_M1_MASK, PseudoVMSGT_VI_M1, 0x3 }, // 1490
  { PseudoVMSGT_VI_M2_MASK, PseudoVMSGT_VI_M2, 0x3 }, // 1491
  { PseudoVMSGT_VI_M4_MASK, PseudoVMSGT_VI_M4, 0x3 }, // 1492
  { PseudoVMSGT_VI_M8_MASK, PseudoVMSGT_VI_M8, 0x3 }, // 1493
  { PseudoVMSGT_VI_MF2_MASK, PseudoVMSGT_VI_MF2, 0x3 }, // 1494
  { PseudoVMSGT_VI_MF4_MASK, PseudoVMSGT_VI_MF4, 0x3 }, // 1495
  { PseudoVMSGT_VI_MF8_MASK, PseudoVMSGT_VI_MF8, 0x3 }, // 1496
  { PseudoVMSGT_VX_M1_MASK, PseudoVMSGT_VX_M1, 0x3 }, // 1497
  { PseudoVMSGT_VX_M2_MASK, PseudoVMSGT_VX_M2, 0x3 }, // 1498
  { PseudoVMSGT_VX_M4_MASK, PseudoVMSGT_VX_M4, 0x3 }, // 1499
  { PseudoVMSGT_VX_M8_MASK, PseudoVMSGT_VX_M8, 0x3 }, // 1500
  { PseudoVMSGT_VX_MF2_MASK, PseudoVMSGT_VX_MF2, 0x3 }, // 1501
  { PseudoVMSGT_VX_MF4_MASK, PseudoVMSGT_VX_MF4, 0x3 }, // 1502
  { PseudoVMSGT_VX_MF8_MASK, PseudoVMSGT_VX_MF8, 0x3 }, // 1503
  { PseudoVMSLEU_VI_M1_MASK, PseudoVMSLEU_VI_M1, 0x3 }, // 1504
  { PseudoVMSLEU_VI_M2_MASK, PseudoVMSLEU_VI_M2, 0x3 }, // 1505
  { PseudoVMSLEU_VI_M4_MASK, PseudoVMSLEU_VI_M4, 0x3 }, // 1506
  { PseudoVMSLEU_VI_M8_MASK, PseudoVMSLEU_VI_M8, 0x3 }, // 1507
  { PseudoVMSLEU_VI_MF2_MASK, PseudoVMSLEU_VI_MF2, 0x3 }, // 1508
  { PseudoVMSLEU_VI_MF4_MASK, PseudoVMSLEU_VI_MF4, 0x3 }, // 1509
  { PseudoVMSLEU_VI_MF8_MASK, PseudoVMSLEU_VI_MF8, 0x3 }, // 1510
  { PseudoVMSLEU_VV_M1_MASK, PseudoVMSLEU_VV_M1, 0x3 }, // 1511
  { PseudoVMSLEU_VV_M2_MASK, PseudoVMSLEU_VV_M2, 0x3 }, // 1512
  { PseudoVMSLEU_VV_M4_MASK, PseudoVMSLEU_VV_M4, 0x3 }, // 1513
  { PseudoVMSLEU_VV_M8_MASK, PseudoVMSLEU_VV_M8, 0x3 }, // 1514
  { PseudoVMSLEU_VV_MF2_MASK, PseudoVMSLEU_VV_MF2, 0x3 }, // 1515
  { PseudoVMSLEU_VV_MF4_MASK, PseudoVMSLEU_VV_MF4, 0x3 }, // 1516
  { PseudoVMSLEU_VV_MF8_MASK, PseudoVMSLEU_VV_MF8, 0x3 }, // 1517
  { PseudoVMSLEU_VX_M1_MASK, PseudoVMSLEU_VX_M1, 0x3 }, // 1518
  { PseudoVMSLEU_VX_M2_MASK, PseudoVMSLEU_VX_M2, 0x3 }, // 1519
  { PseudoVMSLEU_VX_M4_MASK, PseudoVMSLEU_VX_M4, 0x3 }, // 1520
  { PseudoVMSLEU_VX_M8_MASK, PseudoVMSLEU_VX_M8, 0x3 }, // 1521
  { PseudoVMSLEU_VX_MF2_MASK, PseudoVMSLEU_VX_MF2, 0x3 }, // 1522
  { PseudoVMSLEU_VX_MF4_MASK, PseudoVMSLEU_VX_MF4, 0x3 }, // 1523
  { PseudoVMSLEU_VX_MF8_MASK, PseudoVMSLEU_VX_MF8, 0x3 }, // 1524
  { PseudoVMSLE_VI_M1_MASK, PseudoVMSLE_VI_M1, 0x3 }, // 1525
  { PseudoVMSLE_VI_M2_MASK, PseudoVMSLE_VI_M2, 0x3 }, // 1526
  { PseudoVMSLE_VI_M4_MASK, PseudoVMSLE_VI_M4, 0x3 }, // 1527
  { PseudoVMSLE_VI_M8_MASK, PseudoVMSLE_VI_M8, 0x3 }, // 1528
  { PseudoVMSLE_VI_MF2_MASK, PseudoVMSLE_VI_MF2, 0x3 }, // 1529
  { PseudoVMSLE_VI_MF4_MASK, PseudoVMSLE_VI_MF4, 0x3 }, // 1530
  { PseudoVMSLE_VI_MF8_MASK, PseudoVMSLE_VI_MF8, 0x3 }, // 1531
  { PseudoVMSLE_VV_M1_MASK, PseudoVMSLE_VV_M1, 0x3 }, // 1532
  { PseudoVMSLE_VV_M2_MASK, PseudoVMSLE_VV_M2, 0x3 }, // 1533
  { PseudoVMSLE_VV_M4_MASK, PseudoVMSLE_VV_M4, 0x3 }, // 1534
  { PseudoVMSLE_VV_M8_MASK, PseudoVMSLE_VV_M8, 0x3 }, // 1535
  { PseudoVMSLE_VV_MF2_MASK, PseudoVMSLE_VV_MF2, 0x3 }, // 1536
  { PseudoVMSLE_VV_MF4_MASK, PseudoVMSLE_VV_MF4, 0x3 }, // 1537
  { PseudoVMSLE_VV_MF8_MASK, PseudoVMSLE_VV_MF8, 0x3 }, // 1538
  { PseudoVMSLE_VX_M1_MASK, PseudoVMSLE_VX_M1, 0x3 }, // 1539
  { PseudoVMSLE_VX_M2_MASK, PseudoVMSLE_VX_M2, 0x3 }, // 1540
  { PseudoVMSLE_VX_M4_MASK, PseudoVMSLE_VX_M4, 0x3 }, // 1541
  { PseudoVMSLE_VX_M8_MASK, PseudoVMSLE_VX_M8, 0x3 }, // 1542
  { PseudoVMSLE_VX_MF2_MASK, PseudoVMSLE_VX_MF2, 0x3 }, // 1543
  { PseudoVMSLE_VX_MF4_MASK, PseudoVMSLE_VX_MF4, 0x3 }, // 1544
  { PseudoVMSLE_VX_MF8_MASK, PseudoVMSLE_VX_MF8, 0x3 }, // 1545
  { PseudoVMSLTU_VV_M1_MASK, PseudoVMSLTU_VV_M1, 0x3 }, // 1546
  { PseudoVMSLTU_VV_M2_MASK, PseudoVMSLTU_VV_M2, 0x3 }, // 1547
  { PseudoVMSLTU_VV_M4_MASK, PseudoVMSLTU_VV_M4, 0x3 }, // 1548
  { PseudoVMSLTU_VV_M8_MASK, PseudoVMSLTU_VV_M8, 0x3 }, // 1549
  { PseudoVMSLTU_VV_MF2_MASK, PseudoVMSLTU_VV_MF2, 0x3 }, // 1550
  { PseudoVMSLTU_VV_MF4_MASK, PseudoVMSLTU_VV_MF4, 0x3 }, // 1551
  { PseudoVMSLTU_VV_MF8_MASK, PseudoVMSLTU_VV_MF8, 0x3 }, // 1552
  { PseudoVMSLTU_VX_M1_MASK, PseudoVMSLTU_VX_M1, 0x3 }, // 1553
  { PseudoVMSLTU_VX_M2_MASK, PseudoVMSLTU_VX_M2, 0x3 }, // 1554
  { PseudoVMSLTU_VX_M4_MASK, PseudoVMSLTU_VX_M4, 0x3 }, // 1555
  { PseudoVMSLTU_VX_M8_MASK, PseudoVMSLTU_VX_M8, 0x3 }, // 1556
  { PseudoVMSLTU_VX_MF2_MASK, PseudoVMSLTU_VX_MF2, 0x3 }, // 1557
  { PseudoVMSLTU_VX_MF4_MASK, PseudoVMSLTU_VX_MF4, 0x3 }, // 1558
  { PseudoVMSLTU_VX_MF8_MASK, PseudoVMSLTU_VX_MF8, 0x3 }, // 1559
  { PseudoVMSLT_VV_M1_MASK, PseudoVMSLT_VV_M1, 0x3 }, // 1560
  { PseudoVMSLT_VV_M2_MASK, PseudoVMSLT_VV_M2, 0x3 }, // 1561
  { PseudoVMSLT_VV_M4_MASK, PseudoVMSLT_VV_M4, 0x3 }, // 1562
  { PseudoVMSLT_VV_M8_MASK, PseudoVMSLT_VV_M8, 0x3 }, // 1563
  { PseudoVMSLT_VV_MF2_MASK, PseudoVMSLT_VV_MF2, 0x3 }, // 1564
  { PseudoVMSLT_VV_MF4_MASK, PseudoVMSLT_VV_MF4, 0x3 }, // 1565
  { PseudoVMSLT_VV_MF8_MASK, PseudoVMSLT_VV_MF8, 0x3 }, // 1566
  { PseudoVMSLT_VX_M1_MASK, PseudoVMSLT_VX_M1, 0x3 }, // 1567
  { PseudoVMSLT_VX_M2_MASK, PseudoVMSLT_VX_M2, 0x3 }, // 1568
  { PseudoVMSLT_VX_M4_MASK, PseudoVMSLT_VX_M4, 0x3 }, // 1569
  { PseudoVMSLT_VX_M8_MASK, PseudoVMSLT_VX_M8, 0x3 }, // 1570
  { PseudoVMSLT_VX_MF2_MASK, PseudoVMSLT_VX_MF2, 0x3 }, // 1571
  { PseudoVMSLT_VX_MF4_MASK, PseudoVMSLT_VX_MF4, 0x3 }, // 1572
  { PseudoVMSLT_VX_MF8_MASK, PseudoVMSLT_VX_MF8, 0x3 }, // 1573
  { PseudoVMSNE_VI_M1_MASK, PseudoVMSNE_VI_M1, 0x3 }, // 1574
  { PseudoVMSNE_VI_M2_MASK, PseudoVMSNE_VI_M2, 0x3 }, // 1575
  { PseudoVMSNE_VI_M4_MASK, PseudoVMSNE_VI_M4, 0x3 }, // 1576
  { PseudoVMSNE_VI_M8_MASK, PseudoVMSNE_VI_M8, 0x3 }, // 1577
  { PseudoVMSNE_VI_MF2_MASK, PseudoVMSNE_VI_MF2, 0x3 }, // 1578
  { PseudoVMSNE_VI_MF4_MASK, PseudoVMSNE_VI_MF4, 0x3 }, // 1579
  { PseudoVMSNE_VI_MF8_MASK, PseudoVMSNE_VI_MF8, 0x3 }, // 1580
  { PseudoVMSNE_VV_M1_MASK, PseudoVMSNE_VV_M1, 0x3 }, // 1581
  { PseudoVMSNE_VV_M2_MASK, PseudoVMSNE_VV_M2, 0x3 }, // 1582
  { PseudoVMSNE_VV_M4_MASK, PseudoVMSNE_VV_M4, 0x3 }, // 1583
  { PseudoVMSNE_VV_M8_MASK, PseudoVMSNE_VV_M8, 0x3 }, // 1584
  { PseudoVMSNE_VV_MF2_MASK, PseudoVMSNE_VV_MF2, 0x3 }, // 1585
  { PseudoVMSNE_VV_MF4_MASK, PseudoVMSNE_VV_MF4, 0x3 }, // 1586
  { PseudoVMSNE_VV_MF8_MASK, PseudoVMSNE_VV_MF8, 0x3 }, // 1587
  { PseudoVMSNE_VX_M1_MASK, PseudoVMSNE_VX_M1, 0x3 }, // 1588
  { PseudoVMSNE_VX_M2_MASK, PseudoVMSNE_VX_M2, 0x3 }, // 1589
  { PseudoVMSNE_VX_M4_MASK, PseudoVMSNE_VX_M4, 0x3 }, // 1590
  { PseudoVMSNE_VX_M8_MASK, PseudoVMSNE_VX_M8, 0x3 }, // 1591
  { PseudoVMSNE_VX_MF2_MASK, PseudoVMSNE_VX_MF2, 0x3 }, // 1592
  { PseudoVMSNE_VX_MF4_MASK, PseudoVMSNE_VX_MF4, 0x3 }, // 1593
  { PseudoVMSNE_VX_MF8_MASK, PseudoVMSNE_VX_MF8, 0x3 }, // 1594
  { PseudoVMULHSU_VV_M1_MASK, PseudoVMULHSU_VV_M1, 0x3 }, // 1595
  { PseudoVMULHSU_VV_M2_MASK, PseudoVMULHSU_VV_M2, 0x3 }, // 1596
  { PseudoVMULHSU_VV_M4_MASK, PseudoVMULHSU_VV_M4, 0x3 }, // 1597
  { PseudoVMULHSU_VV_M8_MASK, PseudoVMULHSU_VV_M8, 0x3 }, // 1598
  { PseudoVMULHSU_VV_MF2_MASK, PseudoVMULHSU_VV_MF2, 0x3 }, // 1599
  { PseudoVMULHSU_VV_MF4_MASK, PseudoVMULHSU_VV_MF4, 0x3 }, // 1600
  { PseudoVMULHSU_VV_MF8_MASK, PseudoVMULHSU_VV_MF8, 0x3 }, // 1601
  { PseudoVMULHSU_VX_M1_MASK, PseudoVMULHSU_VX_M1, 0x3 }, // 1602
  { PseudoVMULHSU_VX_M2_MASK, PseudoVMULHSU_VX_M2, 0x3 }, // 1603
  { PseudoVMULHSU_VX_M4_MASK, PseudoVMULHSU_VX_M4, 0x3 }, // 1604
  { PseudoVMULHSU_VX_M8_MASK, PseudoVMULHSU_VX_M8, 0x3 }, // 1605
  { PseudoVMULHSU_VX_MF2_MASK, PseudoVMULHSU_VX_MF2, 0x3 }, // 1606
  { PseudoVMULHSU_VX_MF4_MASK, PseudoVMULHSU_VX_MF4, 0x3 }, // 1607
  { PseudoVMULHSU_VX_MF8_MASK, PseudoVMULHSU_VX_MF8, 0x3 }, // 1608
  { PseudoVMULHU_VV_M1_MASK, PseudoVMULHU_VV_M1, 0x3 }, // 1609
  { PseudoVMULHU_VV_M2_MASK, PseudoVMULHU_VV_M2, 0x3 }, // 1610
  { PseudoVMULHU_VV_M4_MASK, PseudoVMULHU_VV_M4, 0x3 }, // 1611
  { PseudoVMULHU_VV_M8_MASK, PseudoVMULHU_VV_M8, 0x3 }, // 1612
  { PseudoVMULHU_VV_MF2_MASK, PseudoVMULHU_VV_MF2, 0x3 }, // 1613
  { PseudoVMULHU_VV_MF4_MASK, PseudoVMULHU_VV_MF4, 0x3 }, // 1614
  { PseudoVMULHU_VV_MF8_MASK, PseudoVMULHU_VV_MF8, 0x3 }, // 1615
  { PseudoVMULHU_VX_M1_MASK, PseudoVMULHU_VX_M1, 0x3 }, // 1616
  { PseudoVMULHU_VX_M2_MASK, PseudoVMULHU_VX_M2, 0x3 }, // 1617
  { PseudoVMULHU_VX_M4_MASK, PseudoVMULHU_VX_M4, 0x3 }, // 1618
  { PseudoVMULHU_VX_M8_MASK, PseudoVMULHU_VX_M8, 0x3 }, // 1619
  { PseudoVMULHU_VX_MF2_MASK, PseudoVMULHU_VX_MF2, 0x3 }, // 1620
  { PseudoVMULHU_VX_MF4_MASK, PseudoVMULHU_VX_MF4, 0x3 }, // 1621
  { PseudoVMULHU_VX_MF8_MASK, PseudoVMULHU_VX_MF8, 0x3 }, // 1622
  { PseudoVMULH_VV_M1_MASK, PseudoVMULH_VV_M1, 0x3 }, // 1623
  { PseudoVMULH_VV_M2_MASK, PseudoVMULH_VV_M2, 0x3 }, // 1624
  { PseudoVMULH_VV_M4_MASK, PseudoVMULH_VV_M4, 0x3 }, // 1625
  { PseudoVMULH_VV_M8_MASK, PseudoVMULH_VV_M8, 0x3 }, // 1626
  { PseudoVMULH_VV_MF2_MASK, PseudoVMULH_VV_MF2, 0x3 }, // 1627
  { PseudoVMULH_VV_MF4_MASK, PseudoVMULH_VV_MF4, 0x3 }, // 1628
  { PseudoVMULH_VV_MF8_MASK, PseudoVMULH_VV_MF8, 0x3 }, // 1629
  { PseudoVMULH_VX_M1_MASK, PseudoVMULH_VX_M1, 0x3 }, // 1630
  { PseudoVMULH_VX_M2_MASK, PseudoVMULH_VX_M2, 0x3 }, // 1631
  { PseudoVMULH_VX_M4_MASK, PseudoVMULH_VX_M4, 0x3 }, // 1632
  { PseudoVMULH_VX_M8_MASK, PseudoVMULH_VX_M8, 0x3 }, // 1633
  { PseudoVMULH_VX_MF2_MASK, PseudoVMULH_VX_MF2, 0x3 }, // 1634
  { PseudoVMULH_VX_MF4_MASK, PseudoVMULH_VX_MF4, 0x3 }, // 1635
  { PseudoVMULH_VX_MF8_MASK, PseudoVMULH_VX_MF8, 0x3 }, // 1636
  { PseudoVMUL_VV_M1_MASK, PseudoVMUL_VV_M1, 0x3 }, // 1637
  { PseudoVMUL_VV_M2_MASK, PseudoVMUL_VV_M2, 0x3 }, // 1638
  { PseudoVMUL_VV_M4_MASK, PseudoVMUL_VV_M4, 0x3 }, // 1639
  { PseudoVMUL_VV_M8_MASK, PseudoVMUL_VV_M8, 0x3 }, // 1640
  { PseudoVMUL_VV_MF2_MASK, PseudoVMUL_VV_MF2, 0x3 }, // 1641
  { PseudoVMUL_VV_MF4_MASK, PseudoVMUL_VV_MF4, 0x3 }, // 1642
  { PseudoVMUL_VV_MF8_MASK, PseudoVMUL_VV_MF8, 0x3 }, // 1643
  { PseudoVMUL_VX_M1_MASK, PseudoVMUL_VX_M1, 0x3 }, // 1644
  { PseudoVMUL_VX_M2_MASK, PseudoVMUL_VX_M2, 0x3 }, // 1645
  { PseudoVMUL_VX_M4_MASK, PseudoVMUL_VX_M4, 0x3 }, // 1646
  { PseudoVMUL_VX_M8_MASK, PseudoVMUL_VX_M8, 0x3 }, // 1647
  { PseudoVMUL_VX_MF2_MASK, PseudoVMUL_VX_MF2, 0x3 }, // 1648
  { PseudoVMUL_VX_MF4_MASK, PseudoVMUL_VX_MF4, 0x3 }, // 1649
  { PseudoVMUL_VX_MF8_MASK, PseudoVMUL_VX_MF8, 0x3 }, // 1650
  { PseudoVNCLIPU_WI_M1_MASK, PseudoVNCLIPU_WI_M1, 0x3 }, // 1651
  { PseudoVNCLIPU_WI_M2_MASK, PseudoVNCLIPU_WI_M2, 0x3 }, // 1652
  { PseudoVNCLIPU_WI_M4_MASK, PseudoVNCLIPU_WI_M4, 0x3 }, // 1653
  { PseudoVNCLIPU_WI_MF2_MASK, PseudoVNCLIPU_WI_MF2, 0x3 }, // 1654
  { PseudoVNCLIPU_WI_MF4_MASK, PseudoVNCLIPU_WI_MF4, 0x3 }, // 1655
  { PseudoVNCLIPU_WI_MF8_MASK, PseudoVNCLIPU_WI_MF8, 0x3 }, // 1656
  { PseudoVNCLIPU_WV_M1_MASK, PseudoVNCLIPU_WV_M1, 0x3 }, // 1657
  { PseudoVNCLIPU_WV_M2_MASK, PseudoVNCLIPU_WV_M2, 0x3 }, // 1658
  { PseudoVNCLIPU_WV_M4_MASK, PseudoVNCLIPU_WV_M4, 0x3 }, // 1659
  { PseudoVNCLIPU_WV_MF2_MASK, PseudoVNCLIPU_WV_MF2, 0x3 }, // 1660
  { PseudoVNCLIPU_WV_MF4_MASK, PseudoVNCLIPU_WV_MF4, 0x3 }, // 1661
  { PseudoVNCLIPU_WV_MF8_MASK, PseudoVNCLIPU_WV_MF8, 0x3 }, // 1662
  { PseudoVNCLIPU_WX_M1_MASK, PseudoVNCLIPU_WX_M1, 0x3 }, // 1663
  { PseudoVNCLIPU_WX_M2_MASK, PseudoVNCLIPU_WX_M2, 0x3 }, // 1664
  { PseudoVNCLIPU_WX_M4_MASK, PseudoVNCLIPU_WX_M4, 0x3 }, // 1665
  { PseudoVNCLIPU_WX_MF2_MASK, PseudoVNCLIPU_WX_MF2, 0x3 }, // 1666
  { PseudoVNCLIPU_WX_MF4_MASK, PseudoVNCLIPU_WX_MF4, 0x3 }, // 1667
  { PseudoVNCLIPU_WX_MF8_MASK, PseudoVNCLIPU_WX_MF8, 0x3 }, // 1668
  { PseudoVNCLIP_WI_M1_MASK, PseudoVNCLIP_WI_M1, 0x3 }, // 1669
  { PseudoVNCLIP_WI_M2_MASK, PseudoVNCLIP_WI_M2, 0x3 }, // 1670
  { PseudoVNCLIP_WI_M4_MASK, PseudoVNCLIP_WI_M4, 0x3 }, // 1671
  { PseudoVNCLIP_WI_MF2_MASK, PseudoVNCLIP_WI_MF2, 0x3 }, // 1672
  { PseudoVNCLIP_WI_MF4_MASK, PseudoVNCLIP_WI_MF4, 0x3 }, // 1673
  { PseudoVNCLIP_WI_MF8_MASK, PseudoVNCLIP_WI_MF8, 0x3 }, // 1674
  { PseudoVNCLIP_WV_M1_MASK, PseudoVNCLIP_WV_M1, 0x3 }, // 1675
  { PseudoVNCLIP_WV_M2_MASK, PseudoVNCLIP_WV_M2, 0x3 }, // 1676
  { PseudoVNCLIP_WV_M4_MASK, PseudoVNCLIP_WV_M4, 0x3 }, // 1677
  { PseudoVNCLIP_WV_MF2_MASK, PseudoVNCLIP_WV_MF2, 0x3 }, // 1678
  { PseudoVNCLIP_WV_MF4_MASK, PseudoVNCLIP_WV_MF4, 0x3 }, // 1679
  { PseudoVNCLIP_WV_MF8_MASK, PseudoVNCLIP_WV_MF8, 0x3 }, // 1680
  { PseudoVNCLIP_WX_M1_MASK, PseudoVNCLIP_WX_M1, 0x3 }, // 1681
  { PseudoVNCLIP_WX_M2_MASK, PseudoVNCLIP_WX_M2, 0x3 }, // 1682
  { PseudoVNCLIP_WX_M4_MASK, PseudoVNCLIP_WX_M4, 0x3 }, // 1683
  { PseudoVNCLIP_WX_MF2_MASK, PseudoVNCLIP_WX_MF2, 0x3 }, // 1684
  { PseudoVNCLIP_WX_MF4_MASK, PseudoVNCLIP_WX_MF4, 0x3 }, // 1685
  { PseudoVNCLIP_WX_MF8_MASK, PseudoVNCLIP_WX_MF8, 0x3 }, // 1686
  { PseudoVNMSAC_VV_M1_MASK, PseudoVNMSAC_VV_M1, 0x3 }, // 1687
  { PseudoVNMSAC_VV_M2_MASK, PseudoVNMSAC_VV_M2, 0x3 }, // 1688
  { PseudoVNMSAC_VV_M4_MASK, PseudoVNMSAC_VV_M4, 0x3 }, // 1689
  { PseudoVNMSAC_VV_M8_MASK, PseudoVNMSAC_VV_M8, 0x3 }, // 1690
  { PseudoVNMSAC_VV_MF2_MASK, PseudoVNMSAC_VV_MF2, 0x3 }, // 1691
  { PseudoVNMSAC_VV_MF4_MASK, PseudoVNMSAC_VV_MF4, 0x3 }, // 1692
  { PseudoVNMSAC_VV_MF8_MASK, PseudoVNMSAC_VV_MF8, 0x3 }, // 1693
  { PseudoVNMSAC_VX_M1_MASK, PseudoVNMSAC_VX_M1, 0x3 }, // 1694
  { PseudoVNMSAC_VX_M2_MASK, PseudoVNMSAC_VX_M2, 0x3 }, // 1695
  { PseudoVNMSAC_VX_M4_MASK, PseudoVNMSAC_VX_M4, 0x3 }, // 1696
  { PseudoVNMSAC_VX_M8_MASK, PseudoVNMSAC_VX_M8, 0x3 }, // 1697
  { PseudoVNMSAC_VX_MF2_MASK, PseudoVNMSAC_VX_MF2, 0x3 }, // 1698
  { PseudoVNMSAC_VX_MF4_MASK, PseudoVNMSAC_VX_MF4, 0x3 }, // 1699
  { PseudoVNMSAC_VX_MF8_MASK, PseudoVNMSAC_VX_MF8, 0x3 }, // 1700
  { PseudoVNMSUB_VV_M1_MASK, PseudoVNMSUB_VV_M1, 0x3 }, // 1701
  { PseudoVNMSUB_VV_M2_MASK, PseudoVNMSUB_VV_M2, 0x3 }, // 1702
  { PseudoVNMSUB_VV_M4_MASK, PseudoVNMSUB_VV_M4, 0x3 }, // 1703
  { PseudoVNMSUB_VV_M8_MASK, PseudoVNMSUB_VV_M8, 0x3 }, // 1704
  { PseudoVNMSUB_VV_MF2_MASK, PseudoVNMSUB_VV_MF2, 0x3 }, // 1705
  { PseudoVNMSUB_VV_MF4_MASK, PseudoVNMSUB_VV_MF4, 0x3 }, // 1706
  { PseudoVNMSUB_VV_MF8_MASK, PseudoVNMSUB_VV_MF8, 0x3 }, // 1707
  { PseudoVNMSUB_VX_M1_MASK, PseudoVNMSUB_VX_M1, 0x3 }, // 1708
  { PseudoVNMSUB_VX_M2_MASK, PseudoVNMSUB_VX_M2, 0x3 }, // 1709
  { PseudoVNMSUB_VX_M4_MASK, PseudoVNMSUB_VX_M4, 0x3 }, // 1710
  { PseudoVNMSUB_VX_M8_MASK, PseudoVNMSUB_VX_M8, 0x3 }, // 1711
  { PseudoVNMSUB_VX_MF2_MASK, PseudoVNMSUB_VX_MF2, 0x3 }, // 1712
  { PseudoVNMSUB_VX_MF4_MASK, PseudoVNMSUB_VX_MF4, 0x3 }, // 1713
  { PseudoVNMSUB_VX_MF8_MASK, PseudoVNMSUB_VX_MF8, 0x3 }, // 1714
  { PseudoVNSRA_WI_M1_MASK, PseudoVNSRA_WI_M1, 0x3 }, // 1715
  { PseudoVNSRA_WI_M2_MASK, PseudoVNSRA_WI_M2, 0x3 }, // 1716
  { PseudoVNSRA_WI_M4_MASK, PseudoVNSRA_WI_M4, 0x3 }, // 1717
  { PseudoVNSRA_WI_MF2_MASK, PseudoVNSRA_WI_MF2, 0x3 }, // 1718
  { PseudoVNSRA_WI_MF4_MASK, PseudoVNSRA_WI_MF4, 0x3 }, // 1719
  { PseudoVNSRA_WI_MF8_MASK, PseudoVNSRA_WI_MF8, 0x3 }, // 1720
  { PseudoVNSRA_WV_M1_MASK, PseudoVNSRA_WV_M1, 0x3 }, // 1721
  { PseudoVNSRA_WV_M2_MASK, PseudoVNSRA_WV_M2, 0x3 }, // 1722
  { PseudoVNSRA_WV_M4_MASK, PseudoVNSRA_WV_M4, 0x3 }, // 1723
  { PseudoVNSRA_WV_MF2_MASK, PseudoVNSRA_WV_MF2, 0x3 }, // 1724
  { PseudoVNSRA_WV_MF4_MASK, PseudoVNSRA_WV_MF4, 0x3 }, // 1725
  { PseudoVNSRA_WV_MF8_MASK, PseudoVNSRA_WV_MF8, 0x3 }, // 1726
  { PseudoVNSRA_WX_M1_MASK, PseudoVNSRA_WX_M1, 0x3 }, // 1727
  { PseudoVNSRA_WX_M2_MASK, PseudoVNSRA_WX_M2, 0x3 }, // 1728
  { PseudoVNSRA_WX_M4_MASK, PseudoVNSRA_WX_M4, 0x3 }, // 1729
  { PseudoVNSRA_WX_MF2_MASK, PseudoVNSRA_WX_MF2, 0x3 }, // 1730
  { PseudoVNSRA_WX_MF4_MASK, PseudoVNSRA_WX_MF4, 0x3 }, // 1731
  { PseudoVNSRA_WX_MF8_MASK, PseudoVNSRA_WX_MF8, 0x3 }, // 1732
  { PseudoVNSRL_WI_M1_MASK, PseudoVNSRL_WI_M1, 0x3 }, // 1733
  { PseudoVNSRL_WI_M2_MASK, PseudoVNSRL_WI_M2, 0x3 }, // 1734
  { PseudoVNSRL_WI_M4_MASK, PseudoVNSRL_WI_M4, 0x3 }, // 1735
  { PseudoVNSRL_WI_MF2_MASK, PseudoVNSRL_WI_MF2, 0x3 }, // 1736
  { PseudoVNSRL_WI_MF4_MASK, PseudoVNSRL_WI_MF4, 0x3 }, // 1737
  { PseudoVNSRL_WI_MF8_MASK, PseudoVNSRL_WI_MF8, 0x3 }, // 1738
  { PseudoVNSRL_WV_M1_MASK, PseudoVNSRL_WV_M1, 0x3 }, // 1739
  { PseudoVNSRL_WV_M2_MASK, PseudoVNSRL_WV_M2, 0x3 }, // 1740
  { PseudoVNSRL_WV_M4_MASK, PseudoVNSRL_WV_M4, 0x3 }, // 1741
  { PseudoVNSRL_WV_MF2_MASK, PseudoVNSRL_WV_MF2, 0x3 }, // 1742
  { PseudoVNSRL_WV_MF4_MASK, PseudoVNSRL_WV_MF4, 0x3 }, // 1743
  { PseudoVNSRL_WV_MF8_MASK, PseudoVNSRL_WV_MF8, 0x3 }, // 1744
  { PseudoVNSRL_WX_M1_MASK, PseudoVNSRL_WX_M1, 0x3 }, // 1745
  { PseudoVNSRL_WX_M2_MASK, PseudoVNSRL_WX_M2, 0x3 }, // 1746
  { PseudoVNSRL_WX_M4_MASK, PseudoVNSRL_WX_M4, 0x3 }, // 1747
  { PseudoVNSRL_WX_MF2_MASK, PseudoVNSRL_WX_MF2, 0x3 }, // 1748
  { PseudoVNSRL_WX_MF4_MASK, PseudoVNSRL_WX_MF4, 0x3 }, // 1749
  { PseudoVNSRL_WX_MF8_MASK, PseudoVNSRL_WX_MF8, 0x3 }, // 1750
  { PseudoVOR_VI_M1_MASK, PseudoVOR_VI_M1, 0x3 }, // 1751
  { PseudoVOR_VI_M2_MASK, PseudoVOR_VI_M2, 0x3 }, // 1752
  { PseudoVOR_VI_M4_MASK, PseudoVOR_VI_M4, 0x3 }, // 1753
  { PseudoVOR_VI_M8_MASK, PseudoVOR_VI_M8, 0x3 }, // 1754
  { PseudoVOR_VI_MF2_MASK, PseudoVOR_VI_MF2, 0x3 }, // 1755
  { PseudoVOR_VI_MF4_MASK, PseudoVOR_VI_MF4, 0x3 }, // 1756
  { PseudoVOR_VI_MF8_MASK, PseudoVOR_VI_MF8, 0x3 }, // 1757
  { PseudoVOR_VV_M1_MASK, PseudoVOR_VV_M1, 0x3 }, // 1758
  { PseudoVOR_VV_M2_MASK, PseudoVOR_VV_M2, 0x3 }, // 1759
  { PseudoVOR_VV_M4_MASK, PseudoVOR_VV_M4, 0x3 }, // 1760
  { PseudoVOR_VV_M8_MASK, PseudoVOR_VV_M8, 0x3 }, // 1761
  { PseudoVOR_VV_MF2_MASK, PseudoVOR_VV_MF2, 0x3 }, // 1762
  { PseudoVOR_VV_MF4_MASK, PseudoVOR_VV_MF4, 0x3 }, // 1763
  { PseudoVOR_VV_MF8_MASK, PseudoVOR_VV_MF8, 0x3 }, // 1764
  { PseudoVOR_VX_M1_MASK, PseudoVOR_VX_M1, 0x3 }, // 1765
  { PseudoVOR_VX_M2_MASK, PseudoVOR_VX_M2, 0x3 }, // 1766
  { PseudoVOR_VX_M4_MASK, PseudoVOR_VX_M4, 0x3 }, // 1767
  { PseudoVOR_VX_M8_MASK, PseudoVOR_VX_M8, 0x3 }, // 1768
  { PseudoVOR_VX_MF2_MASK, PseudoVOR_VX_MF2, 0x3 }, // 1769
  { PseudoVOR_VX_MF4_MASK, PseudoVOR_VX_MF4, 0x3 }, // 1770
  { PseudoVOR_VX_MF8_MASK, PseudoVOR_VX_MF8, 0x3 }, // 1771
  { PseudoVREMU_VV_M1_E16_MASK, PseudoVREMU_VV_M1_E16, 0x3 }, // 1772
  { PseudoVREMU_VV_M1_E32_MASK, PseudoVREMU_VV_M1_E32, 0x3 }, // 1773
  { PseudoVREMU_VV_M1_E64_MASK, PseudoVREMU_VV_M1_E64, 0x3 }, // 1774
  { PseudoVREMU_VV_M1_E8_MASK, PseudoVREMU_VV_M1_E8, 0x3 }, // 1775
  { PseudoVREMU_VV_M2_E16_MASK, PseudoVREMU_VV_M2_E16, 0x3 }, // 1776
  { PseudoVREMU_VV_M2_E32_MASK, PseudoVREMU_VV_M2_E32, 0x3 }, // 1777
  { PseudoVREMU_VV_M2_E64_MASK, PseudoVREMU_VV_M2_E64, 0x3 }, // 1778
  { PseudoVREMU_VV_M2_E8_MASK, PseudoVREMU_VV_M2_E8, 0x3 }, // 1779
  { PseudoVREMU_VV_M4_E16_MASK, PseudoVREMU_VV_M4_E16, 0x3 }, // 1780
  { PseudoVREMU_VV_M4_E32_MASK, PseudoVREMU_VV_M4_E32, 0x3 }, // 1781
  { PseudoVREMU_VV_M4_E64_MASK, PseudoVREMU_VV_M4_E64, 0x3 }, // 1782
  { PseudoVREMU_VV_M4_E8_MASK, PseudoVREMU_VV_M4_E8, 0x3 }, // 1783
  { PseudoVREMU_VV_M8_E16_MASK, PseudoVREMU_VV_M8_E16, 0x3 }, // 1784
  { PseudoVREMU_VV_M8_E32_MASK, PseudoVREMU_VV_M8_E32, 0x3 }, // 1785
  { PseudoVREMU_VV_M8_E64_MASK, PseudoVREMU_VV_M8_E64, 0x3 }, // 1786
  { PseudoVREMU_VV_M8_E8_MASK, PseudoVREMU_VV_M8_E8, 0x3 }, // 1787
  { PseudoVREMU_VV_MF2_E16_MASK, PseudoVREMU_VV_MF2_E16, 0x3 }, // 1788
  { PseudoVREMU_VV_MF2_E32_MASK, PseudoVREMU_VV_MF2_E32, 0x3 }, // 1789
  { PseudoVREMU_VV_MF2_E8_MASK, PseudoVREMU_VV_MF2_E8, 0x3 }, // 1790
  { PseudoVREMU_VV_MF4_E16_MASK, PseudoVREMU_VV_MF4_E16, 0x3 }, // 1791
  { PseudoVREMU_VV_MF4_E8_MASK, PseudoVREMU_VV_MF4_E8, 0x3 }, // 1792
  { PseudoVREMU_VV_MF8_E8_MASK, PseudoVREMU_VV_MF8_E8, 0x3 }, // 1793
  { PseudoVREMU_VX_M1_E16_MASK, PseudoVREMU_VX_M1_E16, 0x3 }, // 1794
  { PseudoVREMU_VX_M1_E32_MASK, PseudoVREMU_VX_M1_E32, 0x3 }, // 1795
  { PseudoVREMU_VX_M1_E64_MASK, PseudoVREMU_VX_M1_E64, 0x3 }, // 1796
  { PseudoVREMU_VX_M1_E8_MASK, PseudoVREMU_VX_M1_E8, 0x3 }, // 1797
  { PseudoVREMU_VX_M2_E16_MASK, PseudoVREMU_VX_M2_E16, 0x3 }, // 1798
  { PseudoVREMU_VX_M2_E32_MASK, PseudoVREMU_VX_M2_E32, 0x3 }, // 1799
  { PseudoVREMU_VX_M2_E64_MASK, PseudoVREMU_VX_M2_E64, 0x3 }, // 1800
  { PseudoVREMU_VX_M2_E8_MASK, PseudoVREMU_VX_M2_E8, 0x3 }, // 1801
  { PseudoVREMU_VX_M4_E16_MASK, PseudoVREMU_VX_M4_E16, 0x3 }, // 1802
  { PseudoVREMU_VX_M4_E32_MASK, PseudoVREMU_VX_M4_E32, 0x3 }, // 1803
  { PseudoVREMU_VX_M4_E64_MASK, PseudoVREMU_VX_M4_E64, 0x3 }, // 1804
  { PseudoVREMU_VX_M4_E8_MASK, PseudoVREMU_VX_M4_E8, 0x3 }, // 1805
  { PseudoVREMU_VX_M8_E16_MASK, PseudoVREMU_VX_M8_E16, 0x3 }, // 1806
  { PseudoVREMU_VX_M8_E32_MASK, PseudoVREMU_VX_M8_E32, 0x3 }, // 1807
  { PseudoVREMU_VX_M8_E64_MASK, PseudoVREMU_VX_M8_E64, 0x3 }, // 1808
  { PseudoVREMU_VX_M8_E8_MASK, PseudoVREMU_VX_M8_E8, 0x3 }, // 1809
  { PseudoVREMU_VX_MF2_E16_MASK, PseudoVREMU_VX_MF2_E16, 0x3 }, // 1810
  { PseudoVREMU_VX_MF2_E32_MASK, PseudoVREMU_VX_MF2_E32, 0x3 }, // 1811
  { PseudoVREMU_VX_MF2_E8_MASK, PseudoVREMU_VX_MF2_E8, 0x3 }, // 1812
  { PseudoVREMU_VX_MF4_E16_MASK, PseudoVREMU_VX_MF4_E16, 0x3 }, // 1813
  { PseudoVREMU_VX_MF4_E8_MASK, PseudoVREMU_VX_MF4_E8, 0x3 }, // 1814
  { PseudoVREMU_VX_MF8_E8_MASK, PseudoVREMU_VX_MF8_E8, 0x3 }, // 1815
  { PseudoVREM_VV_M1_E16_MASK, PseudoVREM_VV_M1_E16, 0x3 }, // 1816
  { PseudoVREM_VV_M1_E32_MASK, PseudoVREM_VV_M1_E32, 0x3 }, // 1817
  { PseudoVREM_VV_M1_E64_MASK, PseudoVREM_VV_M1_E64, 0x3 }, // 1818
  { PseudoVREM_VV_M1_E8_MASK, PseudoVREM_VV_M1_E8, 0x3 }, // 1819
  { PseudoVREM_VV_M2_E16_MASK, PseudoVREM_VV_M2_E16, 0x3 }, // 1820
  { PseudoVREM_VV_M2_E32_MASK, PseudoVREM_VV_M2_E32, 0x3 }, // 1821
  { PseudoVREM_VV_M2_E64_MASK, PseudoVREM_VV_M2_E64, 0x3 }, // 1822
  { PseudoVREM_VV_M2_E8_MASK, PseudoVREM_VV_M2_E8, 0x3 }, // 1823
  { PseudoVREM_VV_M4_E16_MASK, PseudoVREM_VV_M4_E16, 0x3 }, // 1824
  { PseudoVREM_VV_M4_E32_MASK, PseudoVREM_VV_M4_E32, 0x3 }, // 1825
  { PseudoVREM_VV_M4_E64_MASK, PseudoVREM_VV_M4_E64, 0x3 }, // 1826
  { PseudoVREM_VV_M4_E8_MASK, PseudoVREM_VV_M4_E8, 0x3 }, // 1827
  { PseudoVREM_VV_M8_E16_MASK, PseudoVREM_VV_M8_E16, 0x3 }, // 1828
  { PseudoVREM_VV_M8_E32_MASK, PseudoVREM_VV_M8_E32, 0x3 }, // 1829
  { PseudoVREM_VV_M8_E64_MASK, PseudoVREM_VV_M8_E64, 0x3 }, // 1830
  { PseudoVREM_VV_M8_E8_MASK, PseudoVREM_VV_M8_E8, 0x3 }, // 1831
  { PseudoVREM_VV_MF2_E16_MASK, PseudoVREM_VV_MF2_E16, 0x3 }, // 1832
  { PseudoVREM_VV_MF2_E32_MASK, PseudoVREM_VV_MF2_E32, 0x3 }, // 1833
  { PseudoVREM_VV_MF2_E8_MASK, PseudoVREM_VV_MF2_E8, 0x3 }, // 1834
  { PseudoVREM_VV_MF4_E16_MASK, PseudoVREM_VV_MF4_E16, 0x3 }, // 1835
  { PseudoVREM_VV_MF4_E8_MASK, PseudoVREM_VV_MF4_E8, 0x3 }, // 1836
  { PseudoVREM_VV_MF8_E8_MASK, PseudoVREM_VV_MF8_E8, 0x3 }, // 1837
  { PseudoVREM_VX_M1_E16_MASK, PseudoVREM_VX_M1_E16, 0x3 }, // 1838
  { PseudoVREM_VX_M1_E32_MASK, PseudoVREM_VX_M1_E32, 0x3 }, // 1839
  { PseudoVREM_VX_M1_E64_MASK, PseudoVREM_VX_M1_E64, 0x3 }, // 1840
  { PseudoVREM_VX_M1_E8_MASK, PseudoVREM_VX_M1_E8, 0x3 }, // 1841
  { PseudoVREM_VX_M2_E16_MASK, PseudoVREM_VX_M2_E16, 0x3 }, // 1842
  { PseudoVREM_VX_M2_E32_MASK, PseudoVREM_VX_M2_E32, 0x3 }, // 1843
  { PseudoVREM_VX_M2_E64_MASK, PseudoVREM_VX_M2_E64, 0x3 }, // 1844
  { PseudoVREM_VX_M2_E8_MASK, PseudoVREM_VX_M2_E8, 0x3 }, // 1845
  { PseudoVREM_VX_M4_E16_MASK, PseudoVREM_VX_M4_E16, 0x3 }, // 1846
  { PseudoVREM_VX_M4_E32_MASK, PseudoVREM_VX_M4_E32, 0x3 }, // 1847
  { PseudoVREM_VX_M4_E64_MASK, PseudoVREM_VX_M4_E64, 0x3 }, // 1848
  { PseudoVREM_VX_M4_E8_MASK, PseudoVREM_VX_M4_E8, 0x3 }, // 1849
  { PseudoVREM_VX_M8_E16_MASK, PseudoVREM_VX_M8_E16, 0x3 }, // 1850
  { PseudoVREM_VX_M8_E32_MASK, PseudoVREM_VX_M8_E32, 0x3 }, // 1851
  { PseudoVREM_VX_M8_E64_MASK, PseudoVREM_VX_M8_E64, 0x3 }, // 1852
  { PseudoVREM_VX_M8_E8_MASK, PseudoVREM_VX_M8_E8, 0x3 }, // 1853
  { PseudoVREM_VX_MF2_E16_MASK, PseudoVREM_VX_MF2_E16, 0x3 }, // 1854
  { PseudoVREM_VX_MF2_E32_MASK, PseudoVREM_VX_MF2_E32, 0x3 }, // 1855
  { PseudoVREM_VX_MF2_E8_MASK, PseudoVREM_VX_MF2_E8, 0x3 }, // 1856
  { PseudoVREM_VX_MF4_E16_MASK, PseudoVREM_VX_MF4_E16, 0x3 }, // 1857
  { PseudoVREM_VX_MF4_E8_MASK, PseudoVREM_VX_MF4_E8, 0x3 }, // 1858
  { PseudoVREM_VX_MF8_E8_MASK, PseudoVREM_VX_MF8_E8, 0x3 }, // 1859
  { PseudoVREV8_V_M1_MASK, PseudoVREV8_V_M1, 0x2 }, // 1860
  { PseudoVREV8_V_M2_MASK, PseudoVREV8_V_M2, 0x2 }, // 1861
  { PseudoVREV8_V_M4_MASK, PseudoVREV8_V_M4, 0x2 }, // 1862
  { PseudoVREV8_V_M8_MASK, PseudoVREV8_V_M8, 0x2 }, // 1863
  { PseudoVREV8_V_MF2_MASK, PseudoVREV8_V_MF2, 0x2 }, // 1864
  { PseudoVREV8_V_MF4_MASK, PseudoVREV8_V_MF4, 0x2 }, // 1865
  { PseudoVREV8_V_MF8_MASK, PseudoVREV8_V_MF8, 0x2 }, // 1866
  { PseudoVRGATHEREI16_VV_M1_E16_M1_MASK, PseudoVRGATHEREI16_VV_M1_E16_M1, 0x3 }, // 1867
  { PseudoVRGATHEREI16_VV_M1_E16_M2_MASK, PseudoVRGATHEREI16_VV_M1_E16_M2, 0x3 }, // 1868
  { PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK, PseudoVRGATHEREI16_VV_M1_E16_MF2, 0x3 }, // 1869
  { PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK, PseudoVRGATHEREI16_VV_M1_E16_MF4, 0x3 }, // 1870
  { PseudoVRGATHEREI16_VV_M1_E32_M1_MASK, PseudoVRGATHEREI16_VV_M1_E32_M1, 0x3 }, // 1871
  { PseudoVRGATHEREI16_VV_M1_E32_M2_MASK, PseudoVRGATHEREI16_VV_M1_E32_M2, 0x3 }, // 1872
  { PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK, PseudoVRGATHEREI16_VV_M1_E32_MF2, 0x3 }, // 1873
  { PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK, PseudoVRGATHEREI16_VV_M1_E32_MF4, 0x3 }, // 1874
  { PseudoVRGATHEREI16_VV_M1_E64_M1_MASK, PseudoVRGATHEREI16_VV_M1_E64_M1, 0x3 }, // 1875
  { PseudoVRGATHEREI16_VV_M1_E64_M2_MASK, PseudoVRGATHEREI16_VV_M1_E64_M2, 0x3 }, // 1876
  { PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK, PseudoVRGATHEREI16_VV_M1_E64_MF2, 0x3 }, // 1877
  { PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK, PseudoVRGATHEREI16_VV_M1_E64_MF4, 0x3 }, // 1878
  { PseudoVRGATHEREI16_VV_M1_E8_M1_MASK, PseudoVRGATHEREI16_VV_M1_E8_M1, 0x3 }, // 1879
  { PseudoVRGATHEREI16_VV_M1_E8_M2_MASK, PseudoVRGATHEREI16_VV_M1_E8_M2, 0x3 }, // 1880
  { PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK, PseudoVRGATHEREI16_VV_M1_E8_MF2, 0x3 }, // 1881
  { PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK, PseudoVRGATHEREI16_VV_M1_E8_MF4, 0x3 }, // 1882
  { PseudoVRGATHEREI16_VV_M2_E16_M1_MASK, PseudoVRGATHEREI16_VV_M2_E16_M1, 0x3 }, // 1883
  { PseudoVRGATHEREI16_VV_M2_E16_M2_MASK, PseudoVRGATHEREI16_VV_M2_E16_M2, 0x3 }, // 1884
  { PseudoVRGATHEREI16_VV_M2_E16_M4_MASK, PseudoVRGATHEREI16_VV_M2_E16_M4, 0x3 }, // 1885
  { PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK, PseudoVRGATHEREI16_VV_M2_E16_MF2, 0x3 }, // 1886
  { PseudoVRGATHEREI16_VV_M2_E32_M1_MASK, PseudoVRGATHEREI16_VV_M2_E32_M1, 0x3 }, // 1887
  { PseudoVRGATHEREI16_VV_M2_E32_M2_MASK, PseudoVRGATHEREI16_VV_M2_E32_M2, 0x3 }, // 1888
  { PseudoVRGATHEREI16_VV_M2_E32_M4_MASK, PseudoVRGATHEREI16_VV_M2_E32_M4, 0x3 }, // 1889
  { PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK, PseudoVRGATHEREI16_VV_M2_E32_MF2, 0x3 }, // 1890
  { PseudoVRGATHEREI16_VV_M2_E64_M1_MASK, PseudoVRGATHEREI16_VV_M2_E64_M1, 0x3 }, // 1891
  { PseudoVRGATHEREI16_VV_M2_E64_M2_MASK, PseudoVRGATHEREI16_VV_M2_E64_M2, 0x3 }, // 1892
  { PseudoVRGATHEREI16_VV_M2_E64_M4_MASK, PseudoVRGATHEREI16_VV_M2_E64_M4, 0x3 }, // 1893
  { PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK, PseudoVRGATHEREI16_VV_M2_E64_MF2, 0x3 }, // 1894
  { PseudoVRGATHEREI16_VV_M2_E8_M1_MASK, PseudoVRGATHEREI16_VV_M2_E8_M1, 0x3 }, // 1895
  { PseudoVRGATHEREI16_VV_M2_E8_M2_MASK, PseudoVRGATHEREI16_VV_M2_E8_M2, 0x3 }, // 1896
  { PseudoVRGATHEREI16_VV_M2_E8_M4_MASK, PseudoVRGATHEREI16_VV_M2_E8_M4, 0x3 }, // 1897
  { PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK, PseudoVRGATHEREI16_VV_M2_E8_MF2, 0x3 }, // 1898
  { PseudoVRGATHEREI16_VV_M4_E16_M1_MASK, PseudoVRGATHEREI16_VV_M4_E16_M1, 0x3 }, // 1899
  { PseudoVRGATHEREI16_VV_M4_E16_M2_MASK, PseudoVRGATHEREI16_VV_M4_E16_M2, 0x3 }, // 1900
  { PseudoVRGATHEREI16_VV_M4_E16_M4_MASK, PseudoVRGATHEREI16_VV_M4_E16_M4, 0x3 }, // 1901
  { PseudoVRGATHEREI16_VV_M4_E16_M8_MASK, PseudoVRGATHEREI16_VV_M4_E16_M8, 0x3 }, // 1902
  { PseudoVRGATHEREI16_VV_M4_E32_M1_MASK, PseudoVRGATHEREI16_VV_M4_E32_M1, 0x3 }, // 1903
  { PseudoVRGATHEREI16_VV_M4_E32_M2_MASK, PseudoVRGATHEREI16_VV_M4_E32_M2, 0x3 }, // 1904
  { PseudoVRGATHEREI16_VV_M4_E32_M4_MASK, PseudoVRGATHEREI16_VV_M4_E32_M4, 0x3 }, // 1905
  { PseudoVRGATHEREI16_VV_M4_E32_M8_MASK, PseudoVRGATHEREI16_VV_M4_E32_M8, 0x3 }, // 1906
  { PseudoVRGATHEREI16_VV_M4_E64_M1_MASK, PseudoVRGATHEREI16_VV_M4_E64_M1, 0x3 }, // 1907
  { PseudoVRGATHEREI16_VV_M4_E64_M2_MASK, PseudoVRGATHEREI16_VV_M4_E64_M2, 0x3 }, // 1908
  { PseudoVRGATHEREI16_VV_M4_E64_M4_MASK, PseudoVRGATHEREI16_VV_M4_E64_M4, 0x3 }, // 1909
  { PseudoVRGATHEREI16_VV_M4_E64_M8_MASK, PseudoVRGATHEREI16_VV_M4_E64_M8, 0x3 }, // 1910
  { PseudoVRGATHEREI16_VV_M4_E8_M1_MASK, PseudoVRGATHEREI16_VV_M4_E8_M1, 0x3 }, // 1911
  { PseudoVRGATHEREI16_VV_M4_E8_M2_MASK, PseudoVRGATHEREI16_VV_M4_E8_M2, 0x3 }, // 1912
  { PseudoVRGATHEREI16_VV_M4_E8_M4_MASK, PseudoVRGATHEREI16_VV_M4_E8_M4, 0x3 }, // 1913
  { PseudoVRGATHEREI16_VV_M4_E8_M8_MASK, PseudoVRGATHEREI16_VV_M4_E8_M8, 0x3 }, // 1914
  { PseudoVRGATHEREI16_VV_M8_E16_M2_MASK, PseudoVRGATHEREI16_VV_M8_E16_M2, 0x3 }, // 1915
  { PseudoVRGATHEREI16_VV_M8_E16_M4_MASK, PseudoVRGATHEREI16_VV_M8_E16_M4, 0x3 }, // 1916
  { PseudoVRGATHEREI16_VV_M8_E16_M8_MASK, PseudoVRGATHEREI16_VV_M8_E16_M8, 0x3 }, // 1917
  { PseudoVRGATHEREI16_VV_M8_E32_M2_MASK, PseudoVRGATHEREI16_VV_M8_E32_M2, 0x3 }, // 1918
  { PseudoVRGATHEREI16_VV_M8_E32_M4_MASK, PseudoVRGATHEREI16_VV_M8_E32_M4, 0x3 }, // 1919
  { PseudoVRGATHEREI16_VV_M8_E32_M8_MASK, PseudoVRGATHEREI16_VV_M8_E32_M8, 0x3 }, // 1920
  { PseudoVRGATHEREI16_VV_M8_E64_M2_MASK, PseudoVRGATHEREI16_VV_M8_E64_M2, 0x3 }, // 1921
  { PseudoVRGATHEREI16_VV_M8_E64_M4_MASK, PseudoVRGATHEREI16_VV_M8_E64_M4, 0x3 }, // 1922
  { PseudoVRGATHEREI16_VV_M8_E64_M8_MASK, PseudoVRGATHEREI16_VV_M8_E64_M8, 0x3 }, // 1923
  { PseudoVRGATHEREI16_VV_M8_E8_M2_MASK, PseudoVRGATHEREI16_VV_M8_E8_M2, 0x3 }, // 1924
  { PseudoVRGATHEREI16_VV_M8_E8_M4_MASK, PseudoVRGATHEREI16_VV_M8_E8_M4, 0x3 }, // 1925
  { PseudoVRGATHEREI16_VV_M8_E8_M8_MASK, PseudoVRGATHEREI16_VV_M8_E8_M8, 0x3 }, // 1926
  { PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK, PseudoVRGATHEREI16_VV_MF2_E16_M1, 0x3 }, // 1927
  { PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK, PseudoVRGATHEREI16_VV_MF2_E16_MF2, 0x3 }, // 1928
  { PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK, PseudoVRGATHEREI16_VV_MF2_E16_MF4, 0x3 }, // 1929
  { PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK, PseudoVRGATHEREI16_VV_MF2_E16_MF8, 0x3 }, // 1930
  { PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK, PseudoVRGATHEREI16_VV_MF2_E32_M1, 0x3 }, // 1931
  { PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK, PseudoVRGATHEREI16_VV_MF2_E32_MF2, 0x3 }, // 1932
  { PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK, PseudoVRGATHEREI16_VV_MF2_E32_MF4, 0x3 }, // 1933
  { PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK, PseudoVRGATHEREI16_VV_MF2_E32_MF8, 0x3 }, // 1934
  { PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK, PseudoVRGATHEREI16_VV_MF2_E8_M1, 0x3 }, // 1935
  { PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK, PseudoVRGATHEREI16_VV_MF2_E8_MF2, 0x3 }, // 1936
  { PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK, PseudoVRGATHEREI16_VV_MF2_E8_MF4, 0x3 }, // 1937
  { PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK, PseudoVRGATHEREI16_VV_MF2_E8_MF8, 0x3 }, // 1938
  { PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK, PseudoVRGATHEREI16_VV_MF4_E16_MF2, 0x3 }, // 1939
  { PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK, PseudoVRGATHEREI16_VV_MF4_E16_MF4, 0x3 }, // 1940
  { PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK, PseudoVRGATHEREI16_VV_MF4_E16_MF8, 0x3 }, // 1941
  { PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK, PseudoVRGATHEREI16_VV_MF4_E8_MF2, 0x3 }, // 1942
  { PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK, PseudoVRGATHEREI16_VV_MF4_E8_MF4, 0x3 }, // 1943
  { PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK, PseudoVRGATHEREI16_VV_MF4_E8_MF8, 0x3 }, // 1944
  { PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK, PseudoVRGATHEREI16_VV_MF8_E8_MF4, 0x3 }, // 1945
  { PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK, PseudoVRGATHEREI16_VV_MF8_E8_MF8, 0x3 }, // 1946
  { PseudoVRGATHER_VI_M1_MASK, PseudoVRGATHER_VI_M1, 0x3 }, // 1947
  { PseudoVRGATHER_VI_M2_MASK, PseudoVRGATHER_VI_M2, 0x3 }, // 1948
  { PseudoVRGATHER_VI_M4_MASK, PseudoVRGATHER_VI_M4, 0x3 }, // 1949
  { PseudoVRGATHER_VI_M8_MASK, PseudoVRGATHER_VI_M8, 0x3 }, // 1950
  { PseudoVRGATHER_VI_MF2_MASK, PseudoVRGATHER_VI_MF2, 0x3 }, // 1951
  { PseudoVRGATHER_VI_MF4_MASK, PseudoVRGATHER_VI_MF4, 0x3 }, // 1952
  { PseudoVRGATHER_VI_MF8_MASK, PseudoVRGATHER_VI_MF8, 0x3 }, // 1953
  { PseudoVRGATHER_VV_M1_E16_MASK, PseudoVRGATHER_VV_M1_E16, 0x3 }, // 1954
  { PseudoVRGATHER_VV_M1_E32_MASK, PseudoVRGATHER_VV_M1_E32, 0x3 }, // 1955
  { PseudoVRGATHER_VV_M1_E64_MASK, PseudoVRGATHER_VV_M1_E64, 0x3 }, // 1956
  { PseudoVRGATHER_VV_M1_E8_MASK, PseudoVRGATHER_VV_M1_E8, 0x3 }, // 1957
  { PseudoVRGATHER_VV_M2_E16_MASK, PseudoVRGATHER_VV_M2_E16, 0x3 }, // 1958
  { PseudoVRGATHER_VV_M2_E32_MASK, PseudoVRGATHER_VV_M2_E32, 0x3 }, // 1959
  { PseudoVRGATHER_VV_M2_E64_MASK, PseudoVRGATHER_VV_M2_E64, 0x3 }, // 1960
  { PseudoVRGATHER_VV_M2_E8_MASK, PseudoVRGATHER_VV_M2_E8, 0x3 }, // 1961
  { PseudoVRGATHER_VV_M4_E16_MASK, PseudoVRGATHER_VV_M4_E16, 0x3 }, // 1962
  { PseudoVRGATHER_VV_M4_E32_MASK, PseudoVRGATHER_VV_M4_E32, 0x3 }, // 1963
  { PseudoVRGATHER_VV_M4_E64_MASK, PseudoVRGATHER_VV_M4_E64, 0x3 }, // 1964
  { PseudoVRGATHER_VV_M4_E8_MASK, PseudoVRGATHER_VV_M4_E8, 0x3 }, // 1965
  { PseudoVRGATHER_VV_M8_E16_MASK, PseudoVRGATHER_VV_M8_E16, 0x3 }, // 1966
  { PseudoVRGATHER_VV_M8_E32_MASK, PseudoVRGATHER_VV_M8_E32, 0x3 }, // 1967
  { PseudoVRGATHER_VV_M8_E64_MASK, PseudoVRGATHER_VV_M8_E64, 0x3 }, // 1968
  { PseudoVRGATHER_VV_M8_E8_MASK, PseudoVRGATHER_VV_M8_E8, 0x3 }, // 1969
  { PseudoVRGATHER_VV_MF2_E16_MASK, PseudoVRGATHER_VV_MF2_E16, 0x3 }, // 1970
  { PseudoVRGATHER_VV_MF2_E32_MASK, PseudoVRGATHER_VV_MF2_E32, 0x3 }, // 1971
  { PseudoVRGATHER_VV_MF2_E8_MASK, PseudoVRGATHER_VV_MF2_E8, 0x3 }, // 1972
  { PseudoVRGATHER_VV_MF4_E16_MASK, PseudoVRGATHER_VV_MF4_E16, 0x3 }, // 1973
  { PseudoVRGATHER_VV_MF4_E8_MASK, PseudoVRGATHER_VV_MF4_E8, 0x3 }, // 1974
  { PseudoVRGATHER_VV_MF8_E8_MASK, PseudoVRGATHER_VV_MF8_E8, 0x3 }, // 1975
  { PseudoVRGATHER_VX_M1_MASK, PseudoVRGATHER_VX_M1, 0x3 }, // 1976
  { PseudoVRGATHER_VX_M2_MASK, PseudoVRGATHER_VX_M2, 0x3 }, // 1977
  { PseudoVRGATHER_VX_M4_MASK, PseudoVRGATHER_VX_M4, 0x3 }, // 1978
  { PseudoVRGATHER_VX_M8_MASK, PseudoVRGATHER_VX_M8, 0x3 }, // 1979
  { PseudoVRGATHER_VX_MF2_MASK, PseudoVRGATHER_VX_MF2, 0x3 }, // 1980
  { PseudoVRGATHER_VX_MF4_MASK, PseudoVRGATHER_VX_MF4, 0x3 }, // 1981
  { PseudoVRGATHER_VX_MF8_MASK, PseudoVRGATHER_VX_MF8, 0x3 }, // 1982
  { PseudoVROL_VV_M1_MASK, PseudoVROL_VV_M1, 0x3 }, // 1983
  { PseudoVROL_VV_M2_MASK, PseudoVROL_VV_M2, 0x3 }, // 1984
  { PseudoVROL_VV_M4_MASK, PseudoVROL_VV_M4, 0x3 }, // 1985
  { PseudoVROL_VV_M8_MASK, PseudoVROL_VV_M8, 0x3 }, // 1986
  { PseudoVROL_VV_MF2_MASK, PseudoVROL_VV_MF2, 0x3 }, // 1987
  { PseudoVROL_VV_MF4_MASK, PseudoVROL_VV_MF4, 0x3 }, // 1988
  { PseudoVROL_VV_MF8_MASK, PseudoVROL_VV_MF8, 0x3 }, // 1989
  { PseudoVROL_VX_M1_MASK, PseudoVROL_VX_M1, 0x3 }, // 1990
  { PseudoVROL_VX_M2_MASK, PseudoVROL_VX_M2, 0x3 }, // 1991
  { PseudoVROL_VX_M4_MASK, PseudoVROL_VX_M4, 0x3 }, // 1992
  { PseudoVROL_VX_M8_MASK, PseudoVROL_VX_M8, 0x3 }, // 1993
  { PseudoVROL_VX_MF2_MASK, PseudoVROL_VX_MF2, 0x3 }, // 1994
  { PseudoVROL_VX_MF4_MASK, PseudoVROL_VX_MF4, 0x3 }, // 1995
  { PseudoVROL_VX_MF8_MASK, PseudoVROL_VX_MF8, 0x3 }, // 1996
  { PseudoVROR_VI_M1_MASK, PseudoVROR_VI_M1, 0x3 }, // 1997
  { PseudoVROR_VI_M2_MASK, PseudoVROR_VI_M2, 0x3 }, // 1998
  { PseudoVROR_VI_M4_MASK, PseudoVROR_VI_M4, 0x3 }, // 1999
  { PseudoVROR_VI_M8_MASK, PseudoVROR_VI_M8, 0x3 }, // 2000
  { PseudoVROR_VI_MF2_MASK, PseudoVROR_VI_MF2, 0x3 }, // 2001
  { PseudoVROR_VI_MF4_MASK, PseudoVROR_VI_MF4, 0x3 }, // 2002
  { PseudoVROR_VI_MF8_MASK, PseudoVROR_VI_MF8, 0x3 }, // 2003
  { PseudoVROR_VV_M1_MASK, PseudoVROR_VV_M1, 0x3 }, // 2004
  { PseudoVROR_VV_M2_MASK, PseudoVROR_VV_M2, 0x3 }, // 2005
  { PseudoVROR_VV_M4_MASK, PseudoVROR_VV_M4, 0x3 }, // 2006
  { PseudoVROR_VV_M8_MASK, PseudoVROR_VV_M8, 0x3 }, // 2007
  { PseudoVROR_VV_MF2_MASK, PseudoVROR_VV_MF2, 0x3 }, // 2008
  { PseudoVROR_VV_MF4_MASK, PseudoVROR_VV_MF4, 0x3 }, // 2009
  { PseudoVROR_VV_MF8_MASK, PseudoVROR_VV_MF8, 0x3 }, // 2010
  { PseudoVROR_VX_M1_MASK, PseudoVROR_VX_M1, 0x3 }, // 2011
  { PseudoVROR_VX_M2_MASK, PseudoVROR_VX_M2, 0x3 }, // 2012
  { PseudoVROR_VX_M4_MASK, PseudoVROR_VX_M4, 0x3 }, // 2013
  { PseudoVROR_VX_M8_MASK, PseudoVROR_VX_M8, 0x3 }, // 2014
  { PseudoVROR_VX_MF2_MASK, PseudoVROR_VX_MF2, 0x3 }, // 2015
  { PseudoVROR_VX_MF4_MASK, PseudoVROR_VX_MF4, 0x3 }, // 2016
  { PseudoVROR_VX_MF8_MASK, PseudoVROR_VX_MF8, 0x3 }, // 2017
  { PseudoVRSUB_VI_M1_MASK, PseudoVRSUB_VI_M1, 0x3 }, // 2018
  { PseudoVRSUB_VI_M2_MASK, PseudoVRSUB_VI_M2, 0x3 }, // 2019
  { PseudoVRSUB_VI_M4_MASK, PseudoVRSUB_VI_M4, 0x3 }, // 2020
  { PseudoVRSUB_VI_M8_MASK, PseudoVRSUB_VI_M8, 0x3 }, // 2021
  { PseudoVRSUB_VI_MF2_MASK, PseudoVRSUB_VI_MF2, 0x3 }, // 2022
  { PseudoVRSUB_VI_MF4_MASK, PseudoVRSUB_VI_MF4, 0x3 }, // 2023
  { PseudoVRSUB_VI_MF8_MASK, PseudoVRSUB_VI_MF8, 0x3 }, // 2024
  { PseudoVRSUB_VX_M1_MASK, PseudoVRSUB_VX_M1, 0x3 }, // 2025
  { PseudoVRSUB_VX_M2_MASK, PseudoVRSUB_VX_M2, 0x3 }, // 2026
  { PseudoVRSUB_VX_M4_MASK, PseudoVRSUB_VX_M4, 0x3 }, // 2027
  { PseudoVRSUB_VX_M8_MASK, PseudoVRSUB_VX_M8, 0x3 }, // 2028
  { PseudoVRSUB_VX_MF2_MASK, PseudoVRSUB_VX_MF2, 0x3 }, // 2029
  { PseudoVRSUB_VX_MF4_MASK, PseudoVRSUB_VX_MF4, 0x3 }, // 2030
  { PseudoVRSUB_VX_MF8_MASK, PseudoVRSUB_VX_MF8, 0x3 }, // 2031
  { PseudoVSADDU_VI_M1_MASK, PseudoVSADDU_VI_M1, 0x3 }, // 2032
  { PseudoVSADDU_VI_M2_MASK, PseudoVSADDU_VI_M2, 0x3 }, // 2033
  { PseudoVSADDU_VI_M4_MASK, PseudoVSADDU_VI_M4, 0x3 }, // 2034
  { PseudoVSADDU_VI_M8_MASK, PseudoVSADDU_VI_M8, 0x3 }, // 2035
  { PseudoVSADDU_VI_MF2_MASK, PseudoVSADDU_VI_MF2, 0x3 }, // 2036
  { PseudoVSADDU_VI_MF4_MASK, PseudoVSADDU_VI_MF4, 0x3 }, // 2037
  { PseudoVSADDU_VI_MF8_MASK, PseudoVSADDU_VI_MF8, 0x3 }, // 2038
  { PseudoVSADDU_VV_M1_MASK, PseudoVSADDU_VV_M1, 0x3 }, // 2039
  { PseudoVSADDU_VV_M2_MASK, PseudoVSADDU_VV_M2, 0x3 }, // 2040
  { PseudoVSADDU_VV_M4_MASK, PseudoVSADDU_VV_M4, 0x3 }, // 2041
  { PseudoVSADDU_VV_M8_MASK, PseudoVSADDU_VV_M8, 0x3 }, // 2042
  { PseudoVSADDU_VV_MF2_MASK, PseudoVSADDU_VV_MF2, 0x3 }, // 2043
  { PseudoVSADDU_VV_MF4_MASK, PseudoVSADDU_VV_MF4, 0x3 }, // 2044
  { PseudoVSADDU_VV_MF8_MASK, PseudoVSADDU_VV_MF8, 0x3 }, // 2045
  { PseudoVSADDU_VX_M1_MASK, PseudoVSADDU_VX_M1, 0x3 }, // 2046
  { PseudoVSADDU_VX_M2_MASK, PseudoVSADDU_VX_M2, 0x3 }, // 2047
  { PseudoVSADDU_VX_M4_MASK, PseudoVSADDU_VX_M4, 0x3 }, // 2048
  { PseudoVSADDU_VX_M8_MASK, PseudoVSADDU_VX_M8, 0x3 }, // 2049
  { PseudoVSADDU_VX_MF2_MASK, PseudoVSADDU_VX_MF2, 0x3 }, // 2050
  { PseudoVSADDU_VX_MF4_MASK, PseudoVSADDU_VX_MF4, 0x3 }, // 2051
  { PseudoVSADDU_VX_MF8_MASK, PseudoVSADDU_VX_MF8, 0x3 }, // 2052
  { PseudoVSADD_VI_M1_MASK, PseudoVSADD_VI_M1, 0x3 }, // 2053
  { PseudoVSADD_VI_M2_MASK, PseudoVSADD_VI_M2, 0x3 }, // 2054
  { PseudoVSADD_VI_M4_MASK, PseudoVSADD_VI_M4, 0x3 }, // 2055
  { PseudoVSADD_VI_M8_MASK, PseudoVSADD_VI_M8, 0x3 }, // 2056
  { PseudoVSADD_VI_MF2_MASK, PseudoVSADD_VI_MF2, 0x3 }, // 2057
  { PseudoVSADD_VI_MF4_MASK, PseudoVSADD_VI_MF4, 0x3 }, // 2058
  { PseudoVSADD_VI_MF8_MASK, PseudoVSADD_VI_MF8, 0x3 }, // 2059
  { PseudoVSADD_VV_M1_MASK, PseudoVSADD_VV_M1, 0x3 }, // 2060
  { PseudoVSADD_VV_M2_MASK, PseudoVSADD_VV_M2, 0x3 }, // 2061
  { PseudoVSADD_VV_M4_MASK, PseudoVSADD_VV_M4, 0x3 }, // 2062
  { PseudoVSADD_VV_M8_MASK, PseudoVSADD_VV_M8, 0x3 }, // 2063
  { PseudoVSADD_VV_MF2_MASK, PseudoVSADD_VV_MF2, 0x3 }, // 2064
  { PseudoVSADD_VV_MF4_MASK, PseudoVSADD_VV_MF4, 0x3 }, // 2065
  { PseudoVSADD_VV_MF8_MASK, PseudoVSADD_VV_MF8, 0x3 }, // 2066
  { PseudoVSADD_VX_M1_MASK, PseudoVSADD_VX_M1, 0x3 }, // 2067
  { PseudoVSADD_VX_M2_MASK, PseudoVSADD_VX_M2, 0x3 }, // 2068
  { PseudoVSADD_VX_M4_MASK, PseudoVSADD_VX_M4, 0x3 }, // 2069
  { PseudoVSADD_VX_M8_MASK, PseudoVSADD_VX_M8, 0x3 }, // 2070
  { PseudoVSADD_VX_MF2_MASK, PseudoVSADD_VX_MF2, 0x3 }, // 2071
  { PseudoVSADD_VX_MF4_MASK, PseudoVSADD_VX_MF4, 0x3 }, // 2072
  { PseudoVSADD_VX_MF8_MASK, PseudoVSADD_VX_MF8, 0x3 }, // 2073
  { PseudoVSEXT_VF2_M1_MASK, PseudoVSEXT_VF2_M1, 0x2 }, // 2074
  { PseudoVSEXT_VF2_M2_MASK, PseudoVSEXT_VF2_M2, 0x2 }, // 2075
  { PseudoVSEXT_VF2_M4_MASK, PseudoVSEXT_VF2_M4, 0x2 }, // 2076
  { PseudoVSEXT_VF2_M8_MASK, PseudoVSEXT_VF2_M8, 0x2 }, // 2077
  { PseudoVSEXT_VF2_MF2_MASK, PseudoVSEXT_VF2_MF2, 0x2 }, // 2078
  { PseudoVSEXT_VF2_MF4_MASK, PseudoVSEXT_VF2_MF4, 0x2 }, // 2079
  { PseudoVSEXT_VF4_M1_MASK, PseudoVSEXT_VF4_M1, 0x2 }, // 2080
  { PseudoVSEXT_VF4_M2_MASK, PseudoVSEXT_VF4_M2, 0x2 }, // 2081
  { PseudoVSEXT_VF4_M4_MASK, PseudoVSEXT_VF4_M4, 0x2 }, // 2082
  { PseudoVSEXT_VF4_M8_MASK, PseudoVSEXT_VF4_M8, 0x2 }, // 2083
  { PseudoVSEXT_VF4_MF2_MASK, PseudoVSEXT_VF4_MF2, 0x2 }, // 2084
  { PseudoVSEXT_VF8_M1_MASK, PseudoVSEXT_VF8_M1, 0x2 }, // 2085
  { PseudoVSEXT_VF8_M2_MASK, PseudoVSEXT_VF8_M2, 0x2 }, // 2086
  { PseudoVSEXT_VF8_M4_MASK, PseudoVSEXT_VF8_M4, 0x2 }, // 2087
  { PseudoVSEXT_VF8_M8_MASK, PseudoVSEXT_VF8_M8, 0x2 }, // 2088
  { PseudoVSLIDE1DOWN_VX_M1_MASK, PseudoVSLIDE1DOWN_VX_M1, 0x3 }, // 2089
  { PseudoVSLIDE1DOWN_VX_M2_MASK, PseudoVSLIDE1DOWN_VX_M2, 0x3 }, // 2090
  { PseudoVSLIDE1DOWN_VX_M4_MASK, PseudoVSLIDE1DOWN_VX_M4, 0x3 }, // 2091
  { PseudoVSLIDE1DOWN_VX_M8_MASK, PseudoVSLIDE1DOWN_VX_M8, 0x3 }, // 2092
  { PseudoVSLIDE1DOWN_VX_MF2_MASK, PseudoVSLIDE1DOWN_VX_MF2, 0x3 }, // 2093
  { PseudoVSLIDE1DOWN_VX_MF4_MASK, PseudoVSLIDE1DOWN_VX_MF4, 0x3 }, // 2094
  { PseudoVSLIDE1DOWN_VX_MF8_MASK, PseudoVSLIDE1DOWN_VX_MF8, 0x3 }, // 2095
  { PseudoVSLIDE1UP_VX_M1_MASK, PseudoVSLIDE1UP_VX_M1, 0x3 }, // 2096
  { PseudoVSLIDE1UP_VX_M2_MASK, PseudoVSLIDE1UP_VX_M2, 0x3 }, // 2097
  { PseudoVSLIDE1UP_VX_M4_MASK, PseudoVSLIDE1UP_VX_M4, 0x3 }, // 2098
  { PseudoVSLIDE1UP_VX_M8_MASK, PseudoVSLIDE1UP_VX_M8, 0x3 }, // 2099
  { PseudoVSLIDE1UP_VX_MF2_MASK, PseudoVSLIDE1UP_VX_MF2, 0x3 }, // 2100
  { PseudoVSLIDE1UP_VX_MF4_MASK, PseudoVSLIDE1UP_VX_MF4, 0x3 }, // 2101
  { PseudoVSLIDE1UP_VX_MF8_MASK, PseudoVSLIDE1UP_VX_MF8, 0x3 }, // 2102
  { PseudoVSLIDEDOWN_VI_M1_MASK, PseudoVSLIDEDOWN_VI_M1, 0x3 }, // 2103
  { PseudoVSLIDEDOWN_VI_M2_MASK, PseudoVSLIDEDOWN_VI_M2, 0x3 }, // 2104
  { PseudoVSLIDEDOWN_VI_M4_MASK, PseudoVSLIDEDOWN_VI_M4, 0x3 }, // 2105
  { PseudoVSLIDEDOWN_VI_M8_MASK, PseudoVSLIDEDOWN_VI_M8, 0x3 }, // 2106
  { PseudoVSLIDEDOWN_VI_MF2_MASK, PseudoVSLIDEDOWN_VI_MF2, 0x3 }, // 2107
  { PseudoVSLIDEDOWN_VI_MF4_MASK, PseudoVSLIDEDOWN_VI_MF4, 0x3 }, // 2108
  { PseudoVSLIDEDOWN_VI_MF8_MASK, PseudoVSLIDEDOWN_VI_MF8, 0x3 }, // 2109
  { PseudoVSLIDEDOWN_VX_M1_MASK, PseudoVSLIDEDOWN_VX_M1, 0x3 }, // 2110
  { PseudoVSLIDEDOWN_VX_M2_MASK, PseudoVSLIDEDOWN_VX_M2, 0x3 }, // 2111
  { PseudoVSLIDEDOWN_VX_M4_MASK, PseudoVSLIDEDOWN_VX_M4, 0x3 }, // 2112
  { PseudoVSLIDEDOWN_VX_M8_MASK, PseudoVSLIDEDOWN_VX_M8, 0x3 }, // 2113
  { PseudoVSLIDEDOWN_VX_MF2_MASK, PseudoVSLIDEDOWN_VX_MF2, 0x3 }, // 2114
  { PseudoVSLIDEDOWN_VX_MF4_MASK, PseudoVSLIDEDOWN_VX_MF4, 0x3 }, // 2115
  { PseudoVSLIDEDOWN_VX_MF8_MASK, PseudoVSLIDEDOWN_VX_MF8, 0x3 }, // 2116
  { PseudoVSLIDEUP_VI_M1_MASK, PseudoVSLIDEUP_VI_M1, 0x3 }, // 2117
  { PseudoVSLIDEUP_VI_M2_MASK, PseudoVSLIDEUP_VI_M2, 0x3 }, // 2118
  { PseudoVSLIDEUP_VI_M4_MASK, PseudoVSLIDEUP_VI_M4, 0x3 }, // 2119
  { PseudoVSLIDEUP_VI_M8_MASK, PseudoVSLIDEUP_VI_M8, 0x3 }, // 2120
  { PseudoVSLIDEUP_VI_MF2_MASK, PseudoVSLIDEUP_VI_MF2, 0x3 }, // 2121
  { PseudoVSLIDEUP_VI_MF4_MASK, PseudoVSLIDEUP_VI_MF4, 0x3 }, // 2122
  { PseudoVSLIDEUP_VI_MF8_MASK, PseudoVSLIDEUP_VI_MF8, 0x3 }, // 2123
  { PseudoVSLIDEUP_VX_M1_MASK, PseudoVSLIDEUP_VX_M1, 0x3 }, // 2124
  { PseudoVSLIDEUP_VX_M2_MASK, PseudoVSLIDEUP_VX_M2, 0x3 }, // 2125
  { PseudoVSLIDEUP_VX_M4_MASK, PseudoVSLIDEUP_VX_M4, 0x3 }, // 2126
  { PseudoVSLIDEUP_VX_M8_MASK, PseudoVSLIDEUP_VX_M8, 0x3 }, // 2127
  { PseudoVSLIDEUP_VX_MF2_MASK, PseudoVSLIDEUP_VX_MF2, 0x3 }, // 2128
  { PseudoVSLIDEUP_VX_MF4_MASK, PseudoVSLIDEUP_VX_MF4, 0x3 }, // 2129
  { PseudoVSLIDEUP_VX_MF8_MASK, PseudoVSLIDEUP_VX_MF8, 0x3 }, // 2130
  { PseudoVSLL_VI_M1_MASK, PseudoVSLL_VI_M1, 0x3 }, // 2131
  { PseudoVSLL_VI_M2_MASK, PseudoVSLL_VI_M2, 0x3 }, // 2132
  { PseudoVSLL_VI_M4_MASK, PseudoVSLL_VI_M4, 0x3 }, // 2133
  { PseudoVSLL_VI_M8_MASK, PseudoVSLL_VI_M8, 0x3 }, // 2134
  { PseudoVSLL_VI_MF2_MASK, PseudoVSLL_VI_MF2, 0x3 }, // 2135
  { PseudoVSLL_VI_MF4_MASK, PseudoVSLL_VI_MF4, 0x3 }, // 2136
  { PseudoVSLL_VI_MF8_MASK, PseudoVSLL_VI_MF8, 0x3 }, // 2137
  { PseudoVSLL_VV_M1_MASK, PseudoVSLL_VV_M1, 0x3 }, // 2138
  { PseudoVSLL_VV_M2_MASK, PseudoVSLL_VV_M2, 0x3 }, // 2139
  { PseudoVSLL_VV_M4_MASK, PseudoVSLL_VV_M4, 0x3 }, // 2140
  { PseudoVSLL_VV_M8_MASK, PseudoVSLL_VV_M8, 0x3 }, // 2141
  { PseudoVSLL_VV_MF2_MASK, PseudoVSLL_VV_MF2, 0x3 }, // 2142
  { PseudoVSLL_VV_MF4_MASK, PseudoVSLL_VV_MF4, 0x3 }, // 2143
  { PseudoVSLL_VV_MF8_MASK, PseudoVSLL_VV_MF8, 0x3 }, // 2144
  { PseudoVSLL_VX_M1_MASK, PseudoVSLL_VX_M1, 0x3 }, // 2145
  { PseudoVSLL_VX_M2_MASK, PseudoVSLL_VX_M2, 0x3 }, // 2146
  { PseudoVSLL_VX_M4_MASK, PseudoVSLL_VX_M4, 0x3 }, // 2147
  { PseudoVSLL_VX_M8_MASK, PseudoVSLL_VX_M8, 0x3 }, // 2148
  { PseudoVSLL_VX_MF2_MASK, PseudoVSLL_VX_MF2, 0x3 }, // 2149
  { PseudoVSLL_VX_MF4_MASK, PseudoVSLL_VX_MF4, 0x3 }, // 2150
  { PseudoVSLL_VX_MF8_MASK, PseudoVSLL_VX_MF8, 0x3 }, // 2151
  { PseudoVSMUL_VV_M1_MASK, PseudoVSMUL_VV_M1, 0x3 }, // 2152
  { PseudoVSMUL_VV_M2_MASK, PseudoVSMUL_VV_M2, 0x3 }, // 2153
  { PseudoVSMUL_VV_M4_MASK, PseudoVSMUL_VV_M4, 0x3 }, // 2154
  { PseudoVSMUL_VV_M8_MASK, PseudoVSMUL_VV_M8, 0x3 }, // 2155
  { PseudoVSMUL_VV_MF2_MASK, PseudoVSMUL_VV_MF2, 0x3 }, // 2156
  { PseudoVSMUL_VV_MF4_MASK, PseudoVSMUL_VV_MF4, 0x3 }, // 2157
  { PseudoVSMUL_VV_MF8_MASK, PseudoVSMUL_VV_MF8, 0x3 }, // 2158
  { PseudoVSMUL_VX_M1_MASK, PseudoVSMUL_VX_M1, 0x3 }, // 2159
  { PseudoVSMUL_VX_M2_MASK, PseudoVSMUL_VX_M2, 0x3 }, // 2160
  { PseudoVSMUL_VX_M4_MASK, PseudoVSMUL_VX_M4, 0x3 }, // 2161
  { PseudoVSMUL_VX_M8_MASK, PseudoVSMUL_VX_M8, 0x3 }, // 2162
  { PseudoVSMUL_VX_MF2_MASK, PseudoVSMUL_VX_MF2, 0x3 }, // 2163
  { PseudoVSMUL_VX_MF4_MASK, PseudoVSMUL_VX_MF4, 0x3 }, // 2164
  { PseudoVSMUL_VX_MF8_MASK, PseudoVSMUL_VX_MF8, 0x3 }, // 2165
  { PseudoVSRA_VI_M1_MASK, PseudoVSRA_VI_M1, 0x3 }, // 2166
  { PseudoVSRA_VI_M2_MASK, PseudoVSRA_VI_M2, 0x3 }, // 2167
  { PseudoVSRA_VI_M4_MASK, PseudoVSRA_VI_M4, 0x3 }, // 2168
  { PseudoVSRA_VI_M8_MASK, PseudoVSRA_VI_M8, 0x3 }, // 2169
  { PseudoVSRA_VI_MF2_MASK, PseudoVSRA_VI_MF2, 0x3 }, // 2170
  { PseudoVSRA_VI_MF4_MASK, PseudoVSRA_VI_MF4, 0x3 }, // 2171
  { PseudoVSRA_VI_MF8_MASK, PseudoVSRA_VI_MF8, 0x3 }, // 2172
  { PseudoVSRA_VV_M1_MASK, PseudoVSRA_VV_M1, 0x3 }, // 2173
  { PseudoVSRA_VV_M2_MASK, PseudoVSRA_VV_M2, 0x3 }, // 2174
  { PseudoVSRA_VV_M4_MASK, PseudoVSRA_VV_M4, 0x3 }, // 2175
  { PseudoVSRA_VV_M8_MASK, PseudoVSRA_VV_M8, 0x3 }, // 2176
  { PseudoVSRA_VV_MF2_MASK, PseudoVSRA_VV_MF2, 0x3 }, // 2177
  { PseudoVSRA_VV_MF4_MASK, PseudoVSRA_VV_MF4, 0x3 }, // 2178
  { PseudoVSRA_VV_MF8_MASK, PseudoVSRA_VV_MF8, 0x3 }, // 2179
  { PseudoVSRA_VX_M1_MASK, PseudoVSRA_VX_M1, 0x3 }, // 2180
  { PseudoVSRA_VX_M2_MASK, PseudoVSRA_VX_M2, 0x3 }, // 2181
  { PseudoVSRA_VX_M4_MASK, PseudoVSRA_VX_M4, 0x3 }, // 2182
  { PseudoVSRA_VX_M8_MASK, PseudoVSRA_VX_M8, 0x3 }, // 2183
  { PseudoVSRA_VX_MF2_MASK, PseudoVSRA_VX_MF2, 0x3 }, // 2184
  { PseudoVSRA_VX_MF4_MASK, PseudoVSRA_VX_MF4, 0x3 }, // 2185
  { PseudoVSRA_VX_MF8_MASK, PseudoVSRA_VX_MF8, 0x3 }, // 2186
  { PseudoVSRL_VI_M1_MASK, PseudoVSRL_VI_M1, 0x3 }, // 2187
  { PseudoVSRL_VI_M2_MASK, PseudoVSRL_VI_M2, 0x3 }, // 2188
  { PseudoVSRL_VI_M4_MASK, PseudoVSRL_VI_M4, 0x3 }, // 2189
  { PseudoVSRL_VI_M8_MASK, PseudoVSRL_VI_M8, 0x3 }, // 2190
  { PseudoVSRL_VI_MF2_MASK, PseudoVSRL_VI_MF2, 0x3 }, // 2191
  { PseudoVSRL_VI_MF4_MASK, PseudoVSRL_VI_MF4, 0x3 }, // 2192
  { PseudoVSRL_VI_MF8_MASK, PseudoVSRL_VI_MF8, 0x3 }, // 2193
  { PseudoVSRL_VV_M1_MASK, PseudoVSRL_VV_M1, 0x3 }, // 2194
  { PseudoVSRL_VV_M2_MASK, PseudoVSRL_VV_M2, 0x3 }, // 2195
  { PseudoVSRL_VV_M4_MASK, PseudoVSRL_VV_M4, 0x3 }, // 2196
  { PseudoVSRL_VV_M8_MASK, PseudoVSRL_VV_M8, 0x3 }, // 2197
  { PseudoVSRL_VV_MF2_MASK, PseudoVSRL_VV_MF2, 0x3 }, // 2198
  { PseudoVSRL_VV_MF4_MASK, PseudoVSRL_VV_MF4, 0x3 }, // 2199
  { PseudoVSRL_VV_MF8_MASK, PseudoVSRL_VV_MF8, 0x3 }, // 2200
  { PseudoVSRL_VX_M1_MASK, PseudoVSRL_VX_M1, 0x3 }, // 2201
  { PseudoVSRL_VX_M2_MASK, PseudoVSRL_VX_M2, 0x3 }, // 2202
  { PseudoVSRL_VX_M4_MASK, PseudoVSRL_VX_M4, 0x3 }, // 2203
  { PseudoVSRL_VX_M8_MASK, PseudoVSRL_VX_M8, 0x3 }, // 2204
  { PseudoVSRL_VX_MF2_MASK, PseudoVSRL_VX_MF2, 0x3 }, // 2205
  { PseudoVSRL_VX_MF4_MASK, PseudoVSRL_VX_MF4, 0x3 }, // 2206
  { PseudoVSRL_VX_MF8_MASK, PseudoVSRL_VX_MF8, 0x3 }, // 2207
  { PseudoVSSRA_VI_M1_MASK, PseudoVSSRA_VI_M1, 0x3 }, // 2208
  { PseudoVSSRA_VI_M2_MASK, PseudoVSSRA_VI_M2, 0x3 }, // 2209
  { PseudoVSSRA_VI_M4_MASK, PseudoVSSRA_VI_M4, 0x3 }, // 2210
  { PseudoVSSRA_VI_M8_MASK, PseudoVSSRA_VI_M8, 0x3 }, // 2211
  { PseudoVSSRA_VI_MF2_MASK, PseudoVSSRA_VI_MF2, 0x3 }, // 2212
  { PseudoVSSRA_VI_MF4_MASK, PseudoVSSRA_VI_MF4, 0x3 }, // 2213
  { PseudoVSSRA_VI_MF8_MASK, PseudoVSSRA_VI_MF8, 0x3 }, // 2214
  { PseudoVSSRA_VV_M1_MASK, PseudoVSSRA_VV_M1, 0x3 }, // 2215
  { PseudoVSSRA_VV_M2_MASK, PseudoVSSRA_VV_M2, 0x3 }, // 2216
  { PseudoVSSRA_VV_M4_MASK, PseudoVSSRA_VV_M4, 0x3 }, // 2217
  { PseudoVSSRA_VV_M8_MASK, PseudoVSSRA_VV_M8, 0x3 }, // 2218
  { PseudoVSSRA_VV_MF2_MASK, PseudoVSSRA_VV_MF2, 0x3 }, // 2219
  { PseudoVSSRA_VV_MF4_MASK, PseudoVSSRA_VV_MF4, 0x3 }, // 2220
  { PseudoVSSRA_VV_MF8_MASK, PseudoVSSRA_VV_MF8, 0x3 }, // 2221
  { PseudoVSSRA_VX_M1_MASK, PseudoVSSRA_VX_M1, 0x3 }, // 2222
  { PseudoVSSRA_VX_M2_MASK, PseudoVSSRA_VX_M2, 0x3 }, // 2223
  { PseudoVSSRA_VX_M4_MASK, PseudoVSSRA_VX_M4, 0x3 }, // 2224
  { PseudoVSSRA_VX_M8_MASK, PseudoVSSRA_VX_M8, 0x3 }, // 2225
  { PseudoVSSRA_VX_MF2_MASK, PseudoVSSRA_VX_MF2, 0x3 }, // 2226
  { PseudoVSSRA_VX_MF4_MASK, PseudoVSSRA_VX_MF4, 0x3 }, // 2227
  { PseudoVSSRA_VX_MF8_MASK, PseudoVSSRA_VX_MF8, 0x3 }, // 2228
  { PseudoVSSRL_VI_M1_MASK, PseudoVSSRL_VI_M1, 0x3 }, // 2229
  { PseudoVSSRL_VI_M2_MASK, PseudoVSSRL_VI_M2, 0x3 }, // 2230
  { PseudoVSSRL_VI_M4_MASK, PseudoVSSRL_VI_M4, 0x3 }, // 2231
  { PseudoVSSRL_VI_M8_MASK, PseudoVSSRL_VI_M8, 0x3 }, // 2232
  { PseudoVSSRL_VI_MF2_MASK, PseudoVSSRL_VI_MF2, 0x3 }, // 2233
  { PseudoVSSRL_VI_MF4_MASK, PseudoVSSRL_VI_MF4, 0x3 }, // 2234
  { PseudoVSSRL_VI_MF8_MASK, PseudoVSSRL_VI_MF8, 0x3 }, // 2235
  { PseudoVSSRL_VV_M1_MASK, PseudoVSSRL_VV_M1, 0x3 }, // 2236
  { PseudoVSSRL_VV_M2_MASK, PseudoVSSRL_VV_M2, 0x3 }, // 2237
  { PseudoVSSRL_VV_M4_MASK, PseudoVSSRL_VV_M4, 0x3 }, // 2238
  { PseudoVSSRL_VV_M8_MASK, PseudoVSSRL_VV_M8, 0x3 }, // 2239
  { PseudoVSSRL_VV_MF2_MASK, PseudoVSSRL_VV_MF2, 0x3 }, // 2240
  { PseudoVSSRL_VV_MF4_MASK, PseudoVSSRL_VV_MF4, 0x3 }, // 2241
  { PseudoVSSRL_VV_MF8_MASK, PseudoVSSRL_VV_MF8, 0x3 }, // 2242
  { PseudoVSSRL_VX_M1_MASK, PseudoVSSRL_VX_M1, 0x3 }, // 2243
  { PseudoVSSRL_VX_M2_MASK, PseudoVSSRL_VX_M2, 0x3 }, // 2244
  { PseudoVSSRL_VX_M4_MASK, PseudoVSSRL_VX_M4, 0x3 }, // 2245
  { PseudoVSSRL_VX_M8_MASK, PseudoVSSRL_VX_M8, 0x3 }, // 2246
  { PseudoVSSRL_VX_MF2_MASK, PseudoVSSRL_VX_MF2, 0x3 }, // 2247
  { PseudoVSSRL_VX_MF4_MASK, PseudoVSSRL_VX_MF4, 0x3 }, // 2248
  { PseudoVSSRL_VX_MF8_MASK, PseudoVSSRL_VX_MF8, 0x3 }, // 2249
  { PseudoVSSUBU_VV_M1_MASK, PseudoVSSUBU_VV_M1, 0x3 }, // 2250
  { PseudoVSSUBU_VV_M2_MASK, PseudoVSSUBU_VV_M2, 0x3 }, // 2251
  { PseudoVSSUBU_VV_M4_MASK, PseudoVSSUBU_VV_M4, 0x3 }, // 2252
  { PseudoVSSUBU_VV_M8_MASK, PseudoVSSUBU_VV_M8, 0x3 }, // 2253
  { PseudoVSSUBU_VV_MF2_MASK, PseudoVSSUBU_VV_MF2, 0x3 }, // 2254
  { PseudoVSSUBU_VV_MF4_MASK, PseudoVSSUBU_VV_MF4, 0x3 }, // 2255
  { PseudoVSSUBU_VV_MF8_MASK, PseudoVSSUBU_VV_MF8, 0x3 }, // 2256
  { PseudoVSSUBU_VX_M1_MASK, PseudoVSSUBU_VX_M1, 0x3 }, // 2257
  { PseudoVSSUBU_VX_M2_MASK, PseudoVSSUBU_VX_M2, 0x3 }, // 2258
  { PseudoVSSUBU_VX_M4_MASK, PseudoVSSUBU_VX_M4, 0x3 }, // 2259
  { PseudoVSSUBU_VX_M8_MASK, PseudoVSSUBU_VX_M8, 0x3 }, // 2260
  { PseudoVSSUBU_VX_MF2_MASK, PseudoVSSUBU_VX_MF2, 0x3 }, // 2261
  { PseudoVSSUBU_VX_MF4_MASK, PseudoVSSUBU_VX_MF4, 0x3 }, // 2262
  { PseudoVSSUBU_VX_MF8_MASK, PseudoVSSUBU_VX_MF8, 0x3 }, // 2263
  { PseudoVSSUB_VV_M1_MASK, PseudoVSSUB_VV_M1, 0x3 }, // 2264
  { PseudoVSSUB_VV_M2_MASK, PseudoVSSUB_VV_M2, 0x3 }, // 2265
  { PseudoVSSUB_VV_M4_MASK, PseudoVSSUB_VV_M4, 0x3 }, // 2266
  { PseudoVSSUB_VV_M8_MASK, PseudoVSSUB_VV_M8, 0x3 }, // 2267
  { PseudoVSSUB_VV_MF2_MASK, PseudoVSSUB_VV_MF2, 0x3 }, // 2268
  { PseudoVSSUB_VV_MF4_MASK, PseudoVSSUB_VV_MF4, 0x3 }, // 2269
  { PseudoVSSUB_VV_MF8_MASK, PseudoVSSUB_VV_MF8, 0x3 }, // 2270
  { PseudoVSSUB_VX_M1_MASK, PseudoVSSUB_VX_M1, 0x3 }, // 2271
  { PseudoVSSUB_VX_M2_MASK, PseudoVSSUB_VX_M2, 0x3 }, // 2272
  { PseudoVSSUB_VX_M4_MASK, PseudoVSSUB_VX_M4, 0x3 }, // 2273
  { PseudoVSSUB_VX_M8_MASK, PseudoVSSUB_VX_M8, 0x3 }, // 2274
  { PseudoVSSUB_VX_MF2_MASK, PseudoVSSUB_VX_MF2, 0x3 }, // 2275
  { PseudoVSSUB_VX_MF4_MASK, PseudoVSSUB_VX_MF4, 0x3 }, // 2276
  { PseudoVSSUB_VX_MF8_MASK, PseudoVSSUB_VX_MF8, 0x3 }, // 2277
  { PseudoVSUB_VV_M1_MASK, PseudoVSUB_VV_M1, 0x3 }, // 2278
  { PseudoVSUB_VV_M2_MASK, PseudoVSUB_VV_M2, 0x3 }, // 2279
  { PseudoVSUB_VV_M4_MASK, PseudoVSUB_VV_M4, 0x3 }, // 2280
  { PseudoVSUB_VV_M8_MASK, PseudoVSUB_VV_M8, 0x3 }, // 2281
  { PseudoVSUB_VV_MF2_MASK, PseudoVSUB_VV_MF2, 0x3 }, // 2282
  { PseudoVSUB_VV_MF4_MASK, PseudoVSUB_VV_MF4, 0x3 }, // 2283
  { PseudoVSUB_VV_MF8_MASK, PseudoVSUB_VV_MF8, 0x3 }, // 2284
  { PseudoVSUB_VX_M1_MASK, PseudoVSUB_VX_M1, 0x3 }, // 2285
  { PseudoVSUB_VX_M2_MASK, PseudoVSUB_VX_M2, 0x3 }, // 2286
  { PseudoVSUB_VX_M4_MASK, PseudoVSUB_VX_M4, 0x3 }, // 2287
  { PseudoVSUB_VX_M8_MASK, PseudoVSUB_VX_M8, 0x3 }, // 2288
  { PseudoVSUB_VX_MF2_MASK, PseudoVSUB_VX_MF2, 0x3 }, // 2289
  { PseudoVSUB_VX_MF4_MASK, PseudoVSUB_VX_MF4, 0x3 }, // 2290
  { PseudoVSUB_VX_MF8_MASK, PseudoVSUB_VX_MF8, 0x3 }, // 2291
  { PseudoVWADDU_VV_M1_MASK, PseudoVWADDU_VV_M1, 0x3 }, // 2292
  { PseudoVWADDU_VV_M2_MASK, PseudoVWADDU_VV_M2, 0x3 }, // 2293
  { PseudoVWADDU_VV_M4_MASK, PseudoVWADDU_VV_M4, 0x3 }, // 2294
  { PseudoVWADDU_VV_MF2_MASK, PseudoVWADDU_VV_MF2, 0x3 }, // 2295
  { PseudoVWADDU_VV_MF4_MASK, PseudoVWADDU_VV_MF4, 0x3 }, // 2296
  { PseudoVWADDU_VV_MF8_MASK, PseudoVWADDU_VV_MF8, 0x3 }, // 2297
  { PseudoVWADDU_VX_M1_MASK, PseudoVWADDU_VX_M1, 0x3 }, // 2298
  { PseudoVWADDU_VX_M2_MASK, PseudoVWADDU_VX_M2, 0x3 }, // 2299
  { PseudoVWADDU_VX_M4_MASK, PseudoVWADDU_VX_M4, 0x3 }, // 2300
  { PseudoVWADDU_VX_MF2_MASK, PseudoVWADDU_VX_MF2, 0x3 }, // 2301
  { PseudoVWADDU_VX_MF4_MASK, PseudoVWADDU_VX_MF4, 0x3 }, // 2302
  { PseudoVWADDU_VX_MF8_MASK, PseudoVWADDU_VX_MF8, 0x3 }, // 2303
  { PseudoVWADDU_WV_M1_MASK, PseudoVWADDU_WV_M1, 0x3 }, // 2304
  { PseudoVWADDU_WV_M2_MASK, PseudoVWADDU_WV_M2, 0x3 }, // 2305
  { PseudoVWADDU_WV_M4_MASK, PseudoVWADDU_WV_M4, 0x3 }, // 2306
  { PseudoVWADDU_WV_MF2_MASK, PseudoVWADDU_WV_MF2, 0x3 }, // 2307
  { PseudoVWADDU_WV_MF4_MASK, PseudoVWADDU_WV_MF4, 0x3 }, // 2308
  { PseudoVWADDU_WV_MF8_MASK, PseudoVWADDU_WV_MF8, 0x3 }, // 2309
  { PseudoVWADDU_WX_M1_MASK, PseudoVWADDU_WX_M1, 0x3 }, // 2310
  { PseudoVWADDU_WX_M2_MASK, PseudoVWADDU_WX_M2, 0x3 }, // 2311
  { PseudoVWADDU_WX_M4_MASK, PseudoVWADDU_WX_M4, 0x3 }, // 2312
  { PseudoVWADDU_WX_MF2_MASK, PseudoVWADDU_WX_MF2, 0x3 }, // 2313
  { PseudoVWADDU_WX_MF4_MASK, PseudoVWADDU_WX_MF4, 0x3 }, // 2314
  { PseudoVWADDU_WX_MF8_MASK, PseudoVWADDU_WX_MF8, 0x3 }, // 2315
  { PseudoVWADD_VV_M1_MASK, PseudoVWADD_VV_M1, 0x3 }, // 2316
  { PseudoVWADD_VV_M2_MASK, PseudoVWADD_VV_M2, 0x3 }, // 2317
  { PseudoVWADD_VV_M4_MASK, PseudoVWADD_VV_M4, 0x3 }, // 2318
  { PseudoVWADD_VV_MF2_MASK, PseudoVWADD_VV_MF2, 0x3 }, // 2319
  { PseudoVWADD_VV_MF4_MASK, PseudoVWADD_VV_MF4, 0x3 }, // 2320
  { PseudoVWADD_VV_MF8_MASK, PseudoVWADD_VV_MF8, 0x3 }, // 2321
  { PseudoVWADD_VX_M1_MASK, PseudoVWADD_VX_M1, 0x3 }, // 2322
  { PseudoVWADD_VX_M2_MASK, PseudoVWADD_VX_M2, 0x3 }, // 2323
  { PseudoVWADD_VX_M4_MASK, PseudoVWADD_VX_M4, 0x3 }, // 2324
  { PseudoVWADD_VX_MF2_MASK, PseudoVWADD_VX_MF2, 0x3 }, // 2325
  { PseudoVWADD_VX_MF4_MASK, PseudoVWADD_VX_MF4, 0x3 }, // 2326
  { PseudoVWADD_VX_MF8_MASK, PseudoVWADD_VX_MF8, 0x3 }, // 2327
  { PseudoVWADD_WV_M1_MASK, PseudoVWADD_WV_M1, 0x3 }, // 2328
  { PseudoVWADD_WV_M2_MASK, PseudoVWADD_WV_M2, 0x3 }, // 2329
  { PseudoVWADD_WV_M4_MASK, PseudoVWADD_WV_M4, 0x3 }, // 2330
  { PseudoVWADD_WV_MF2_MASK, PseudoVWADD_WV_MF2, 0x3 }, // 2331
  { PseudoVWADD_WV_MF4_MASK, PseudoVWADD_WV_MF4, 0x3 }, // 2332
  { PseudoVWADD_WV_MF8_MASK, PseudoVWADD_WV_MF8, 0x3 }, // 2333
  { PseudoVWADD_WX_M1_MASK, PseudoVWADD_WX_M1, 0x3 }, // 2334
  { PseudoVWADD_WX_M2_MASK, PseudoVWADD_WX_M2, 0x3 }, // 2335
  { PseudoVWADD_WX_M4_MASK, PseudoVWADD_WX_M4, 0x3 }, // 2336
  { PseudoVWADD_WX_MF2_MASK, PseudoVWADD_WX_MF2, 0x3 }, // 2337
  { PseudoVWADD_WX_MF4_MASK, PseudoVWADD_WX_MF4, 0x3 }, // 2338
  { PseudoVWADD_WX_MF8_MASK, PseudoVWADD_WX_MF8, 0x3 }, // 2339
  { PseudoVWMACCSU_VV_M1_MASK, PseudoVWMACCSU_VV_M1, 0x3 }, // 2340
  { PseudoVWMACCSU_VV_M2_MASK, PseudoVWMACCSU_VV_M2, 0x3 }, // 2341
  { PseudoVWMACCSU_VV_M4_MASK, PseudoVWMACCSU_VV_M4, 0x3 }, // 2342
  { PseudoVWMACCSU_VV_MF2_MASK, PseudoVWMACCSU_VV_MF2, 0x3 }, // 2343
  { PseudoVWMACCSU_VV_MF4_MASK, PseudoVWMACCSU_VV_MF4, 0x3 }, // 2344
  { PseudoVWMACCSU_VV_MF8_MASK, PseudoVWMACCSU_VV_MF8, 0x3 }, // 2345
  { PseudoVWMACCSU_VX_M1_MASK, PseudoVWMACCSU_VX_M1, 0x3 }, // 2346
  { PseudoVWMACCSU_VX_M2_MASK, PseudoVWMACCSU_VX_M2, 0x3 }, // 2347
  { PseudoVWMACCSU_VX_M4_MASK, PseudoVWMACCSU_VX_M4, 0x3 }, // 2348
  { PseudoVWMACCSU_VX_MF2_MASK, PseudoVWMACCSU_VX_MF2, 0x3 }, // 2349
  { PseudoVWMACCSU_VX_MF4_MASK, PseudoVWMACCSU_VX_MF4, 0x3 }, // 2350
  { PseudoVWMACCSU_VX_MF8_MASK, PseudoVWMACCSU_VX_MF8, 0x3 }, // 2351
  { PseudoVWMACCUS_VX_M1_MASK, PseudoVWMACCUS_VX_M1, 0x3 }, // 2352
  { PseudoVWMACCUS_VX_M2_MASK, PseudoVWMACCUS_VX_M2, 0x3 }, // 2353
  { PseudoVWMACCUS_VX_M4_MASK, PseudoVWMACCUS_VX_M4, 0x3 }, // 2354
  { PseudoVWMACCUS_VX_MF2_MASK, PseudoVWMACCUS_VX_MF2, 0x3 }, // 2355
  { PseudoVWMACCUS_VX_MF4_MASK, PseudoVWMACCUS_VX_MF4, 0x3 }, // 2356
  { PseudoVWMACCUS_VX_MF8_MASK, PseudoVWMACCUS_VX_MF8, 0x3 }, // 2357
  { PseudoVWMACCU_VV_M1_MASK, PseudoVWMACCU_VV_M1, 0x3 }, // 2358
  { PseudoVWMACCU_VV_M2_MASK, PseudoVWMACCU_VV_M2, 0x3 }, // 2359
  { PseudoVWMACCU_VV_M4_MASK, PseudoVWMACCU_VV_M4, 0x3 }, // 2360
  { PseudoVWMACCU_VV_MF2_MASK, PseudoVWMACCU_VV_MF2, 0x3 }, // 2361
  { PseudoVWMACCU_VV_MF4_MASK, PseudoVWMACCU_VV_MF4, 0x3 }, // 2362
  { PseudoVWMACCU_VV_MF8_MASK, PseudoVWMACCU_VV_MF8, 0x3 }, // 2363
  { PseudoVWMACCU_VX_M1_MASK, PseudoVWMACCU_VX_M1, 0x3 }, // 2364
  { PseudoVWMACCU_VX_M2_MASK, PseudoVWMACCU_VX_M2, 0x3 }, // 2365
  { PseudoVWMACCU_VX_M4_MASK, PseudoVWMACCU_VX_M4, 0x3 }, // 2366
  { PseudoVWMACCU_VX_MF2_MASK, PseudoVWMACCU_VX_MF2, 0x3 }, // 2367
  { PseudoVWMACCU_VX_MF4_MASK, PseudoVWMACCU_VX_MF4, 0x3 }, // 2368
  { PseudoVWMACCU_VX_MF8_MASK, PseudoVWMACCU_VX_MF8, 0x3 }, // 2369
  { PseudoVWMACC_VV_M1_MASK, PseudoVWMACC_VV_M1, 0x3 }, // 2370
  { PseudoVWMACC_VV_M2_MASK, PseudoVWMACC_VV_M2, 0x3 }, // 2371
  { PseudoVWMACC_VV_M4_MASK, PseudoVWMACC_VV_M4, 0x3 }, // 2372
  { PseudoVWMACC_VV_MF2_MASK, PseudoVWMACC_VV_MF2, 0x3 }, // 2373
  { PseudoVWMACC_VV_MF4_MASK, PseudoVWMACC_VV_MF4, 0x3 }, // 2374
  { PseudoVWMACC_VV_MF8_MASK, PseudoVWMACC_VV_MF8, 0x3 }, // 2375
  { PseudoVWMACC_VX_M1_MASK, PseudoVWMACC_VX_M1, 0x3 }, // 2376
  { PseudoVWMACC_VX_M2_MASK, PseudoVWMACC_VX_M2, 0x3 }, // 2377
  { PseudoVWMACC_VX_M4_MASK, PseudoVWMACC_VX_M4, 0x3 }, // 2378
  { PseudoVWMACC_VX_MF2_MASK, PseudoVWMACC_VX_MF2, 0x3 }, // 2379
  { PseudoVWMACC_VX_MF4_MASK, PseudoVWMACC_VX_MF4, 0x3 }, // 2380
  { PseudoVWMACC_VX_MF8_MASK, PseudoVWMACC_VX_MF8, 0x3 }, // 2381
  { PseudoVWMULSU_VV_M1_MASK, PseudoVWMULSU_VV_M1, 0x3 }, // 2382
  { PseudoVWMULSU_VV_M2_MASK, PseudoVWMULSU_VV_M2, 0x3 }, // 2383
  { PseudoVWMULSU_VV_M4_MASK, PseudoVWMULSU_VV_M4, 0x3 }, // 2384
  { PseudoVWMULSU_VV_MF2_MASK, PseudoVWMULSU_VV_MF2, 0x3 }, // 2385
  { PseudoVWMULSU_VV_MF4_MASK, PseudoVWMULSU_VV_MF4, 0x3 }, // 2386
  { PseudoVWMULSU_VV_MF8_MASK, PseudoVWMULSU_VV_MF8, 0x3 }, // 2387
  { PseudoVWMULSU_VX_M1_MASK, PseudoVWMULSU_VX_M1, 0x3 }, // 2388
  { PseudoVWMULSU_VX_M2_MASK, PseudoVWMULSU_VX_M2, 0x3 }, // 2389
  { PseudoVWMULSU_VX_M4_MASK, PseudoVWMULSU_VX_M4, 0x3 }, // 2390
  { PseudoVWMULSU_VX_MF2_MASK, PseudoVWMULSU_VX_MF2, 0x3 }, // 2391
  { PseudoVWMULSU_VX_MF4_MASK, PseudoVWMULSU_VX_MF4, 0x3 }, // 2392
  { PseudoVWMULSU_VX_MF8_MASK, PseudoVWMULSU_VX_MF8, 0x3 }, // 2393
  { PseudoVWMULU_VV_M1_MASK, PseudoVWMULU_VV_M1, 0x3 }, // 2394
  { PseudoVWMULU_VV_M2_MASK, PseudoVWMULU_VV_M2, 0x3 }, // 2395
  { PseudoVWMULU_VV_M4_MASK, PseudoVWMULU_VV_M4, 0x3 }, // 2396
  { PseudoVWMULU_VV_MF2_MASK, PseudoVWMULU_VV_MF2, 0x3 }, // 2397
  { PseudoVWMULU_VV_MF4_MASK, PseudoVWMULU_VV_MF4, 0x3 }, // 2398
  { PseudoVWMULU_VV_MF8_MASK, PseudoVWMULU_VV_MF8, 0x3 }, // 2399
  { PseudoVWMULU_VX_M1_MASK, PseudoVWMULU_VX_M1, 0x3 }, // 2400
  { PseudoVWMULU_VX_M2_MASK, PseudoVWMULU_VX_M2, 0x3 }, // 2401
  { PseudoVWMULU_VX_M4_MASK, PseudoVWMULU_VX_M4, 0x3 }, // 2402
  { PseudoVWMULU_VX_MF2_MASK, PseudoVWMULU_VX_MF2, 0x3 }, // 2403
  { PseudoVWMULU_VX_MF4_MASK, PseudoVWMULU_VX_MF4, 0x3 }, // 2404
  { PseudoVWMULU_VX_MF8_MASK, PseudoVWMULU_VX_MF8, 0x3 }, // 2405
  { PseudoVWMUL_VV_M1_MASK, PseudoVWMUL_VV_M1, 0x3 }, // 2406
  { PseudoVWMUL_VV_M2_MASK, PseudoVWMUL_VV_M2, 0x3 }, // 2407
  { PseudoVWMUL_VV_M4_MASK, PseudoVWMUL_VV_M4, 0x3 }, // 2408
  { PseudoVWMUL_VV_MF2_MASK, PseudoVWMUL_VV_MF2, 0x3 }, // 2409
  { PseudoVWMUL_VV_MF4_MASK, PseudoVWMUL_VV_MF4, 0x3 }, // 2410
  { PseudoVWMUL_VV_MF8_MASK, PseudoVWMUL_VV_MF8, 0x3 }, // 2411
  { PseudoVWMUL_VX_M1_MASK, PseudoVWMUL_VX_M1, 0x3 }, // 2412
  { PseudoVWMUL_VX_M2_MASK, PseudoVWMUL_VX_M2, 0x3 }, // 2413
  { PseudoVWMUL_VX_M4_MASK, PseudoVWMUL_VX_M4, 0x3 }, // 2414
  { PseudoVWMUL_VX_MF2_MASK, PseudoVWMUL_VX_MF2, 0x3 }, // 2415
  { PseudoVWMUL_VX_MF4_MASK, PseudoVWMUL_VX_MF4, 0x3 }, // 2416
  { PseudoVWMUL_VX_MF8_MASK, PseudoVWMUL_VX_MF8, 0x3 }, // 2417
  { PseudoVWSUBU_VV_M1_MASK, PseudoVWSUBU_VV_M1, 0x3 }, // 2418
  { PseudoVWSUBU_VV_M2_MASK, PseudoVWSUBU_VV_M2, 0x3 }, // 2419
  { PseudoVWSUBU_VV_M4_MASK, PseudoVWSUBU_VV_M4, 0x3 }, // 2420
  { PseudoVWSUBU_VV_MF2_MASK, PseudoVWSUBU_VV_MF2, 0x3 }, // 2421
  { PseudoVWSUBU_VV_MF4_MASK, PseudoVWSUBU_VV_MF4, 0x3 }, // 2422
  { PseudoVWSUBU_VV_MF8_MASK, PseudoVWSUBU_VV_MF8, 0x3 }, // 2423
  { PseudoVWSUBU_VX_M1_MASK, PseudoVWSUBU_VX_M1, 0x3 }, // 2424
  { PseudoVWSUBU_VX_M2_MASK, PseudoVWSUBU_VX_M2, 0x3 }, // 2425
  { PseudoVWSUBU_VX_M4_MASK, PseudoVWSUBU_VX_M4, 0x3 }, // 2426
  { PseudoVWSUBU_VX_MF2_MASK, PseudoVWSUBU_VX_MF2, 0x3 }, // 2427
  { PseudoVWSUBU_VX_MF4_MASK, PseudoVWSUBU_VX_MF4, 0x3 }, // 2428
  { PseudoVWSUBU_VX_MF8_MASK, PseudoVWSUBU_VX_MF8, 0x3 }, // 2429
  { PseudoVWSUBU_WV_M1_MASK, PseudoVWSUBU_WV_M1, 0x3 }, // 2430
  { PseudoVWSUBU_WV_M2_MASK, PseudoVWSUBU_WV_M2, 0x3 }, // 2431
  { PseudoVWSUBU_WV_M4_MASK, PseudoVWSUBU_WV_M4, 0x3 }, // 2432
  { PseudoVWSUBU_WV_MF2_MASK, PseudoVWSUBU_WV_MF2, 0x3 }, // 2433
  { PseudoVWSUBU_WV_MF4_MASK, PseudoVWSUBU_WV_MF4, 0x3 }, // 2434
  { PseudoVWSUBU_WV_MF8_MASK, PseudoVWSUBU_WV_MF8, 0x3 }, // 2435
  { PseudoVWSUBU_WX_M1_MASK, PseudoVWSUBU_WX_M1, 0x3 }, // 2436
  { PseudoVWSUBU_WX_M2_MASK, PseudoVWSUBU_WX_M2, 0x3 }, // 2437
  { PseudoVWSUBU_WX_M4_MASK, PseudoVWSUBU_WX_M4, 0x3 }, // 2438
  { PseudoVWSUBU_WX_MF2_MASK, PseudoVWSUBU_WX_MF2, 0x3 }, // 2439
  { PseudoVWSUBU_WX_MF4_MASK, PseudoVWSUBU_WX_MF4, 0x3 }, // 2440
  { PseudoVWSUBU_WX_MF8_MASK, PseudoVWSUBU_WX_MF8, 0x3 }, // 2441
  { PseudoVWSUB_VV_M1_MASK, PseudoVWSUB_VV_M1, 0x3 }, // 2442
  { PseudoVWSUB_VV_M2_MASK, PseudoVWSUB_VV_M2, 0x3 }, // 2443
  { PseudoVWSUB_VV_M4_MASK, PseudoVWSUB_VV_M4, 0x3 }, // 2444
  { PseudoVWSUB_VV_MF2_MASK, PseudoVWSUB_VV_MF2, 0x3 }, // 2445
  { PseudoVWSUB_VV_MF4_MASK, PseudoVWSUB_VV_MF4, 0x3 }, // 2446
  { PseudoVWSUB_VV_MF8_MASK, PseudoVWSUB_VV_MF8, 0x3 }, // 2447
  { PseudoVWSUB_VX_M1_MASK, PseudoVWSUB_VX_M1, 0x3 }, // 2448
  { PseudoVWSUB_VX_M2_MASK, PseudoVWSUB_VX_M2, 0x3 }, // 2449
  { PseudoVWSUB_VX_M4_MASK, PseudoVWSUB_VX_M4, 0x3 }, // 2450
  { PseudoVWSUB_VX_MF2_MASK, PseudoVWSUB_VX_MF2, 0x3 }, // 2451
  { PseudoVWSUB_VX_MF4_MASK, PseudoVWSUB_VX_MF4, 0x3 }, // 2452
  { PseudoVWSUB_VX_MF8_MASK, PseudoVWSUB_VX_MF8, 0x3 }, // 2453
  { PseudoVWSUB_WV_M1_MASK, PseudoVWSUB_WV_M1, 0x3 }, // 2454
  { PseudoVWSUB_WV_M2_MASK, PseudoVWSUB_WV_M2, 0x3 }, // 2455
  { PseudoVWSUB_WV_M4_MASK, PseudoVWSUB_WV_M4, 0x3 }, // 2456
  { PseudoVWSUB_WV_MF2_MASK, PseudoVWSUB_WV_MF2, 0x3 }, // 2457
  { PseudoVWSUB_WV_MF4_MASK, PseudoVWSUB_WV_MF4, 0x3 }, // 2458
  { PseudoVWSUB_WV_MF8_MASK, PseudoVWSUB_WV_MF8, 0x3 }, // 2459
  { PseudoVWSUB_WX_M1_MASK, PseudoVWSUB_WX_M1, 0x3 }, // 2460
  { PseudoVWSUB_WX_M2_MASK, PseudoVWSUB_WX_M2, 0x3 }, // 2461
  { PseudoVWSUB_WX_M4_MASK, PseudoVWSUB_WX_M4, 0x3 }, // 2462
  { PseudoVWSUB_WX_MF2_MASK, PseudoVWSUB_WX_MF2, 0x3 }, // 2463
  { PseudoVWSUB_WX_MF4_MASK, PseudoVWSUB_WX_MF4, 0x3 }, // 2464
  { PseudoVWSUB_WX_MF8_MASK, PseudoVWSUB_WX_MF8, 0x3 }, // 2465
  { PseudoVXOR_VI_M1_MASK, PseudoVXOR_VI_M1, 0x3 }, // 2466
  { PseudoVXOR_VI_M2_MASK, PseudoVXOR_VI_M2, 0x3 }, // 2467
  { PseudoVXOR_VI_M4_MASK, PseudoVXOR_VI_M4, 0x3 }, // 2468
  { PseudoVXOR_VI_M8_MASK, PseudoVXOR_VI_M8, 0x3 }, // 2469
  { PseudoVXOR_VI_MF2_MASK, PseudoVXOR_VI_MF2, 0x3 }, // 2470
  { PseudoVXOR_VI_MF4_MASK, PseudoVXOR_VI_MF4, 0x3 }, // 2471
  { PseudoVXOR_VI_MF8_MASK, PseudoVXOR_VI_MF8, 0x3 }, // 2472
  { PseudoVXOR_VV_M1_MASK, PseudoVXOR_VV_M1, 0x3 }, // 2473
  { PseudoVXOR_VV_M2_MASK, PseudoVXOR_VV_M2, 0x3 }, // 2474
  { PseudoVXOR_VV_M4_MASK, PseudoVXOR_VV_M4, 0x3 }, // 2475
  { PseudoVXOR_VV_M8_MASK, PseudoVXOR_VV_M8, 0x3 }, // 2476
  { PseudoVXOR_VV_MF2_MASK, PseudoVXOR_VV_MF2, 0x3 }, // 2477
  { PseudoVXOR_VV_MF4_MASK, PseudoVXOR_VV_MF4, 0x3 }, // 2478
  { PseudoVXOR_VV_MF8_MASK, PseudoVXOR_VV_MF8, 0x3 }, // 2479
  { PseudoVXOR_VX_M1_MASK, PseudoVXOR_VX_M1, 0x3 }, // 2480
  { PseudoVXOR_VX_M2_MASK, PseudoVXOR_VX_M2, 0x3 }, // 2481
  { PseudoVXOR_VX_M4_MASK, PseudoVXOR_VX_M4, 0x3 }, // 2482
  { PseudoVXOR_VX_M8_MASK, PseudoVXOR_VX_M8, 0x3 }, // 2483
  { PseudoVXOR_VX_MF2_MASK, PseudoVXOR_VX_MF2, 0x3 }, // 2484
  { PseudoVXOR_VX_MF4_MASK, PseudoVXOR_VX_MF4, 0x3 }, // 2485
  { PseudoVXOR_VX_MF8_MASK, PseudoVXOR_VX_MF8, 0x3 }, // 2486
  { PseudoVZEXT_VF2_M1_MASK, PseudoVZEXT_VF2_M1, 0x2 }, // 2487
  { PseudoVZEXT_VF2_M2_MASK, PseudoVZEXT_VF2_M2, 0x2 }, // 2488
  { PseudoVZEXT_VF2_M4_MASK, PseudoVZEXT_VF2_M4, 0x2 }, // 2489
  { PseudoVZEXT_VF2_M8_MASK, PseudoVZEXT_VF2_M8, 0x2 }, // 2490
  { PseudoVZEXT_VF2_MF2_MASK, PseudoVZEXT_VF2_MF2, 0x2 }, // 2491
  { PseudoVZEXT_VF2_MF4_MASK, PseudoVZEXT_VF2_MF4, 0x2 }, // 2492
  { PseudoVZEXT_VF4_M1_MASK, PseudoVZEXT_VF4_M1, 0x2 }, // 2493
  { PseudoVZEXT_VF4_M2_MASK, PseudoVZEXT_VF4_M2, 0x2 }, // 2494
  { PseudoVZEXT_VF4_M4_MASK, PseudoVZEXT_VF4_M4, 0x2 }, // 2495
  { PseudoVZEXT_VF4_M8_MASK, PseudoVZEXT_VF4_M8, 0x2 }, // 2496
  { PseudoVZEXT_VF4_MF2_MASK, PseudoVZEXT_VF4_MF2, 0x2 }, // 2497
  { PseudoVZEXT_VF8_M1_MASK, PseudoVZEXT_VF8_M1, 0x2 }, // 2498
  { PseudoVZEXT_VF8_M2_MASK, PseudoVZEXT_VF8_M2, 0x2 }, // 2499
  { PseudoVZEXT_VF8_M4_MASK, PseudoVZEXT_VF8_M4, 0x2 }, // 2500
  { PseudoVZEXT_VF8_M8_MASK, PseudoVZEXT_VF8_M8, 0x2 }, // 2501
 };

const RISCVMaskedPseudoInfo *getMaskedPseudoInfo(unsigned MaskedPseudo) {
  struct KeyType {
    unsigned MaskedPseudo;
  };
  KeyType Key = {MaskedPseudo};
  auto Table = ArrayRef(RISCVMaskedPseudosTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVMaskedPseudoInfo &LHS, const KeyType &RHS) {
      if (LHS.MaskedPseudo < RHS.MaskedPseudo)
        return true;
      if (LHS.MaskedPseudo > RHS.MaskedPseudo)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.MaskedPseudo != Idx->MaskedPseudo)
    return nullptr;
  return &*Idx;
}

const RISCVMaskedPseudoInfo *lookupMaskedIntrinsicByUnmasked(unsigned UnmaskedPseudo) {
  struct IndexType {
    unsigned UnmaskedPseudo;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { PseudoTHVdotVMAQASU_VV_M1, 0 },
    { PseudoTHVdotVMAQASU_VV_M2, 1 },
    { PseudoTHVdotVMAQASU_VV_M4, 2 },
    { PseudoTHVdotVMAQASU_VV_M8, 3 },
    { PseudoTHVdotVMAQASU_VV_MF2, 4 },
    { PseudoTHVdotVMAQASU_VX_M1, 5 },
    { PseudoTHVdotVMAQASU_VX_M2, 6 },
    { PseudoTHVdotVMAQASU_VX_M4, 7 },
    { PseudoTHVdotVMAQASU_VX_M8, 8 },
    { PseudoTHVdotVMAQASU_VX_MF2, 9 },
    { PseudoTHVdotVMAQAUS_VX_M1, 10 },
    { PseudoTHVdotVMAQAUS_VX_M2, 11 },
    { PseudoTHVdotVMAQAUS_VX_M4, 12 },
    { PseudoTHVdotVMAQAUS_VX_M8, 13 },
    { PseudoTHVdotVMAQAUS_VX_MF2, 14 },
    { PseudoTHVdotVMAQAU_VV_M1, 15 },
    { PseudoTHVdotVMAQAU_VV_M2, 16 },
    { PseudoTHVdotVMAQAU_VV_M4, 17 },
    { PseudoTHVdotVMAQAU_VV_M8, 18 },
    { PseudoTHVdotVMAQAU_VV_MF2, 19 },
    { PseudoTHVdotVMAQAU_VX_M1, 20 },
    { PseudoTHVdotVMAQAU_VX_M2, 21 },
    { PseudoTHVdotVMAQAU_VX_M4, 22 },
    { PseudoTHVdotVMAQAU_VX_M8, 23 },
    { PseudoTHVdotVMAQAU_VX_MF2, 24 },
    { PseudoTHVdotVMAQA_VV_M1, 25 },
    { PseudoTHVdotVMAQA_VV_M2, 26 },
    { PseudoTHVdotVMAQA_VV_M4, 27 },
    { PseudoTHVdotVMAQA_VV_M8, 28 },
    { PseudoTHVdotVMAQA_VV_MF2, 29 },
    { PseudoTHVdotVMAQA_VX_M1, 30 },
    { PseudoTHVdotVMAQA_VX_M2, 31 },
    { PseudoTHVdotVMAQA_VX_M4, 32 },
    { PseudoTHVdotVMAQA_VX_M8, 33 },
    { PseudoTHVdotVMAQA_VX_MF2, 34 },
    { PseudoVAADDU_VV_M1, 35 },
    { PseudoVAADDU_VV_M2, 36 },
    { PseudoVAADDU_VV_M4, 37 },
    { PseudoVAADDU_VV_M8, 38 },
    { PseudoVAADDU_VV_MF2, 39 },
    { PseudoVAADDU_VV_MF4, 40 },
    { PseudoVAADDU_VV_MF8, 41 },
    { PseudoVAADDU_VX_M1, 42 },
    { PseudoVAADDU_VX_M2, 43 },
    { PseudoVAADDU_VX_M4, 44 },
    { PseudoVAADDU_VX_M8, 45 },
    { PseudoVAADDU_VX_MF2, 46 },
    { PseudoVAADDU_VX_MF4, 47 },
    { PseudoVAADDU_VX_MF8, 48 },
    { PseudoVAADD_VV_M1, 49 },
    { PseudoVAADD_VV_M2, 50 },
    { PseudoVAADD_VV_M4, 51 },
    { PseudoVAADD_VV_M8, 52 },
    { PseudoVAADD_VV_MF2, 53 },
    { PseudoVAADD_VV_MF4, 54 },
    { PseudoVAADD_VV_MF8, 55 },
    { PseudoVAADD_VX_M1, 56 },
    { PseudoVAADD_VX_M2, 57 },
    { PseudoVAADD_VX_M4, 58 },
    { PseudoVAADD_VX_M8, 59 },
    { PseudoVAADD_VX_MF2, 60 },
    { PseudoVAADD_VX_MF4, 61 },
    { PseudoVAADD_VX_MF8, 62 },
    { PseudoVADD_VI_M1, 63 },
    { PseudoVADD_VI_M2, 64 },
    { PseudoVADD_VI_M4, 65 },
    { PseudoVADD_VI_M8, 66 },
    { PseudoVADD_VI_MF2, 67 },
    { PseudoVADD_VI_MF4, 68 },
    { PseudoVADD_VI_MF8, 69 },
    { PseudoVADD_VV_M1, 70 },
    { PseudoVADD_VV_M2, 71 },
    { PseudoVADD_VV_M4, 72 },
    { PseudoVADD_VV_M8, 73 },
    { PseudoVADD_VV_MF2, 74 },
    { PseudoVADD_VV_MF4, 75 },
    { PseudoVADD_VV_MF8, 76 },
    { PseudoVADD_VX_M1, 77 },
    { PseudoVADD_VX_M2, 78 },
    { PseudoVADD_VX_M4, 79 },
    { PseudoVADD_VX_M8, 80 },
    { PseudoVADD_VX_MF2, 81 },
    { PseudoVADD_VX_MF4, 82 },
    { PseudoVADD_VX_MF8, 83 },
    { PseudoVANDN_VV_M1, 84 },
    { PseudoVANDN_VV_M2, 85 },
    { PseudoVANDN_VV_M4, 86 },
    { PseudoVANDN_VV_M8, 87 },
    { PseudoVANDN_VV_MF2, 88 },
    { PseudoVANDN_VV_MF4, 89 },
    { PseudoVANDN_VV_MF8, 90 },
    { PseudoVANDN_VX_M1, 91 },
    { PseudoVANDN_VX_M2, 92 },
    { PseudoVANDN_VX_M4, 93 },
    { PseudoVANDN_VX_M8, 94 },
    { PseudoVANDN_VX_MF2, 95 },
    { PseudoVANDN_VX_MF4, 96 },
    { PseudoVANDN_VX_MF8, 97 },
    { PseudoVAND_VI_M1, 98 },
    { PseudoVAND_VI_M2, 99 },
    { PseudoVAND_VI_M4, 100 },
    { PseudoVAND_VI_M8, 101 },
    { PseudoVAND_VI_MF2, 102 },
    { PseudoVAND_VI_MF4, 103 },
    { PseudoVAND_VI_MF8, 104 },
    { PseudoVAND_VV_M1, 105 },
    { PseudoVAND_VV_M2, 106 },
    { PseudoVAND_VV_M4, 107 },
    { PseudoVAND_VV_M8, 108 },
    { PseudoVAND_VV_MF2, 109 },
    { PseudoVAND_VV_MF4, 110 },
    { PseudoVAND_VV_MF8, 111 },
    { PseudoVAND_VX_M1, 112 },
    { PseudoVAND_VX_M2, 113 },
    { PseudoVAND_VX_M4, 114 },
    { PseudoVAND_VX_M8, 115 },
    { PseudoVAND_VX_MF2, 116 },
    { PseudoVAND_VX_MF4, 117 },
    { PseudoVAND_VX_MF8, 118 },
    { PseudoVASUBU_VV_M1, 119 },
    { PseudoVASUBU_VV_M2, 120 },
    { PseudoVASUBU_VV_M4, 121 },
    { PseudoVASUBU_VV_M8, 122 },
    { PseudoVASUBU_VV_MF2, 123 },
    { PseudoVASUBU_VV_MF4, 124 },
    { PseudoVASUBU_VV_MF8, 125 },
    { PseudoVASUBU_VX_M1, 126 },
    { PseudoVASUBU_VX_M2, 127 },
    { PseudoVASUBU_VX_M4, 128 },
    { PseudoVASUBU_VX_M8, 129 },
    { PseudoVASUBU_VX_MF2, 130 },
    { PseudoVASUBU_VX_MF4, 131 },
    { PseudoVASUBU_VX_MF8, 132 },
    { PseudoVASUB_VV_M1, 133 },
    { PseudoVASUB_VV_M2, 134 },
    { PseudoVASUB_VV_M4, 135 },
    { PseudoVASUB_VV_M8, 136 },
    { PseudoVASUB_VV_MF2, 137 },
    { PseudoVASUB_VV_MF4, 138 },
    { PseudoVASUB_VV_MF8, 139 },
    { PseudoVASUB_VX_M1, 140 },
    { PseudoVASUB_VX_M2, 141 },
    { PseudoVASUB_VX_M4, 142 },
    { PseudoVASUB_VX_M8, 143 },
    { PseudoVASUB_VX_MF2, 144 },
    { PseudoVASUB_VX_MF4, 145 },
    { PseudoVASUB_VX_MF8, 146 },
    { PseudoVBREV_V_M1, 147 },
    { PseudoVBREV_V_M2, 148 },
    { PseudoVBREV_V_M4, 149 },
    { PseudoVBREV_V_M8, 150 },
    { PseudoVBREV_V_MF2, 151 },
    { PseudoVBREV_V_MF4, 152 },
    { PseudoVBREV_V_MF8, 153 },
    { PseudoVCLZ_V_M1, 154 },
    { PseudoVCLZ_V_M2, 155 },
    { PseudoVCLZ_V_M4, 156 },
    { PseudoVCLZ_V_M8, 157 },
    { PseudoVCLZ_V_MF2, 158 },
    { PseudoVCLZ_V_MF4, 159 },
    { PseudoVCLZ_V_MF8, 160 },
    { PseudoVCPOP_V_M1, 161 },
    { PseudoVCPOP_V_M2, 162 },
    { PseudoVCPOP_V_M4, 163 },
    { PseudoVCPOP_V_M8, 164 },
    { PseudoVCPOP_V_MF2, 165 },
    { PseudoVCPOP_V_MF4, 166 },
    { PseudoVCPOP_V_MF8, 167 },
    { PseudoVCTZ_V_M1, 168 },
    { PseudoVCTZ_V_M2, 169 },
    { PseudoVCTZ_V_M4, 170 },
    { PseudoVCTZ_V_M8, 171 },
    { PseudoVCTZ_V_MF2, 172 },
    { PseudoVCTZ_V_MF4, 173 },
    { PseudoVCTZ_V_MF8, 174 },
    { PseudoVDIVU_VV_M1_E16, 175 },
    { PseudoVDIVU_VV_M1_E32, 176 },
    { PseudoVDIVU_VV_M1_E64, 177 },
    { PseudoVDIVU_VV_M1_E8, 178 },
    { PseudoVDIVU_VV_M2_E16, 179 },
    { PseudoVDIVU_VV_M2_E32, 180 },
    { PseudoVDIVU_VV_M2_E64, 181 },
    { PseudoVDIVU_VV_M2_E8, 182 },
    { PseudoVDIVU_VV_M4_E16, 183 },
    { PseudoVDIVU_VV_M4_E32, 184 },
    { PseudoVDIVU_VV_M4_E64, 185 },
    { PseudoVDIVU_VV_M4_E8, 186 },
    { PseudoVDIVU_VV_M8_E16, 187 },
    { PseudoVDIVU_VV_M8_E32, 188 },
    { PseudoVDIVU_VV_M8_E64, 189 },
    { PseudoVDIVU_VV_M8_E8, 190 },
    { PseudoVDIVU_VV_MF2_E16, 191 },
    { PseudoVDIVU_VV_MF2_E32, 192 },
    { PseudoVDIVU_VV_MF2_E8, 193 },
    { PseudoVDIVU_VV_MF4_E16, 194 },
    { PseudoVDIVU_VV_MF4_E8, 195 },
    { PseudoVDIVU_VV_MF8_E8, 196 },
    { PseudoVDIVU_VX_M1_E16, 197 },
    { PseudoVDIVU_VX_M1_E32, 198 },
    { PseudoVDIVU_VX_M1_E64, 199 },
    { PseudoVDIVU_VX_M1_E8, 200 },
    { PseudoVDIVU_VX_M2_E16, 201 },
    { PseudoVDIVU_VX_M2_E32, 202 },
    { PseudoVDIVU_VX_M2_E64, 203 },
    { PseudoVDIVU_VX_M2_E8, 204 },
    { PseudoVDIVU_VX_M4_E16, 205 },
    { PseudoVDIVU_VX_M4_E32, 206 },
    { PseudoVDIVU_VX_M4_E64, 207 },
    { PseudoVDIVU_VX_M4_E8, 208 },
    { PseudoVDIVU_VX_M8_E16, 209 },
    { PseudoVDIVU_VX_M8_E32, 210 },
    { PseudoVDIVU_VX_M8_E64, 211 },
    { PseudoVDIVU_VX_M8_E8, 212 },
    { PseudoVDIVU_VX_MF2_E16, 213 },
    { PseudoVDIVU_VX_MF2_E32, 214 },
    { PseudoVDIVU_VX_MF2_E8, 215 },
    { PseudoVDIVU_VX_MF4_E16, 216 },
    { PseudoVDIVU_VX_MF4_E8, 217 },
    { PseudoVDIVU_VX_MF8_E8, 218 },
    { PseudoVDIV_VV_M1_E16, 219 },
    { PseudoVDIV_VV_M1_E32, 220 },
    { PseudoVDIV_VV_M1_E64, 221 },
    { PseudoVDIV_VV_M1_E8, 222 },
    { PseudoVDIV_VV_M2_E16, 223 },
    { PseudoVDIV_VV_M2_E32, 224 },
    { PseudoVDIV_VV_M2_E64, 225 },
    { PseudoVDIV_VV_M2_E8, 226 },
    { PseudoVDIV_VV_M4_E16, 227 },
    { PseudoVDIV_VV_M4_E32, 228 },
    { PseudoVDIV_VV_M4_E64, 229 },
    { PseudoVDIV_VV_M4_E8, 230 },
    { PseudoVDIV_VV_M8_E16, 231 },
    { PseudoVDIV_VV_M8_E32, 232 },
    { PseudoVDIV_VV_M8_E64, 233 },
    { PseudoVDIV_VV_M8_E8, 234 },
    { PseudoVDIV_VV_MF2_E16, 235 },
    { PseudoVDIV_VV_MF2_E32, 236 },
    { PseudoVDIV_VV_MF2_E8, 237 },
    { PseudoVDIV_VV_MF4_E16, 238 },
    { PseudoVDIV_VV_MF4_E8, 239 },
    { PseudoVDIV_VV_MF8_E8, 240 },
    { PseudoVDIV_VX_M1_E16, 241 },
    { PseudoVDIV_VX_M1_E32, 242 },
    { PseudoVDIV_VX_M1_E64, 243 },
    { PseudoVDIV_VX_M1_E8, 244 },
    { PseudoVDIV_VX_M2_E16, 245 },
    { PseudoVDIV_VX_M2_E32, 246 },
    { PseudoVDIV_VX_M2_E64, 247 },
    { PseudoVDIV_VX_M2_E8, 248 },
    { PseudoVDIV_VX_M4_E16, 249 },
    { PseudoVDIV_VX_M4_E32, 250 },
    { PseudoVDIV_VX_M4_E64, 251 },
    { PseudoVDIV_VX_M4_E8, 252 },
    { PseudoVDIV_VX_M8_E16, 253 },
    { PseudoVDIV_VX_M8_E32, 254 },
    { PseudoVDIV_VX_M8_E64, 255 },
    { PseudoVDIV_VX_M8_E8, 256 },
    { PseudoVDIV_VX_MF2_E16, 257 },
    { PseudoVDIV_VX_MF2_E32, 258 },
    { PseudoVDIV_VX_MF2_E8, 259 },
    { PseudoVDIV_VX_MF4_E16, 260 },
    { PseudoVDIV_VX_MF4_E8, 261 },
    { PseudoVDIV_VX_MF8_E8, 262 },
    { PseudoVFADD_VF16_M1, 263 },
    { PseudoVFADD_VF16_M2, 264 },
    { PseudoVFADD_VF16_M4, 265 },
    { PseudoVFADD_VF16_M8, 266 },
    { PseudoVFADD_VF16_MF2, 267 },
    { PseudoVFADD_VF16_MF4, 268 },
    { PseudoVFADD_VF32_M1, 269 },
    { PseudoVFADD_VF32_M2, 270 },
    { PseudoVFADD_VF32_M4, 271 },
    { PseudoVFADD_VF32_M8, 272 },
    { PseudoVFADD_VF32_MF2, 273 },
    { PseudoVFADD_VF64_M1, 274 },
    { PseudoVFADD_VF64_M2, 275 },
    { PseudoVFADD_VF64_M4, 276 },
    { PseudoVFADD_VF64_M8, 277 },
    { PseudoVFADD_VV_M1, 278 },
    { PseudoVFADD_VV_M2, 279 },
    { PseudoVFADD_VV_M4, 280 },
    { PseudoVFADD_VV_M8, 281 },
    { PseudoVFADD_VV_MF2, 282 },
    { PseudoVFADD_VV_MF4, 283 },
    { PseudoVFCLASS_V_M1, 284 },
    { PseudoVFCLASS_V_M2, 285 },
    { PseudoVFCLASS_V_M4, 286 },
    { PseudoVFCLASS_V_M8, 287 },
    { PseudoVFCLASS_V_MF2, 288 },
    { PseudoVFCLASS_V_MF4, 289 },
    { PseudoVFCVT_F_XU_V_M1, 290 },
    { PseudoVFCVT_F_XU_V_M2, 291 },
    { PseudoVFCVT_F_XU_V_M4, 292 },
    { PseudoVFCVT_F_XU_V_M8, 293 },
    { PseudoVFCVT_F_XU_V_MF2, 294 },
    { PseudoVFCVT_F_XU_V_MF4, 295 },
    { PseudoVFCVT_F_X_V_M1, 296 },
    { PseudoVFCVT_F_X_V_M2, 297 },
    { PseudoVFCVT_F_X_V_M4, 298 },
    { PseudoVFCVT_F_X_V_M8, 299 },
    { PseudoVFCVT_F_X_V_MF2, 300 },
    { PseudoVFCVT_F_X_V_MF4, 301 },
    { PseudoVFCVT_RM_F_XU_V_M1, 302 },
    { PseudoVFCVT_RM_F_XU_V_M2, 303 },
    { PseudoVFCVT_RM_F_XU_V_M4, 304 },
    { PseudoVFCVT_RM_F_XU_V_M8, 305 },
    { PseudoVFCVT_RM_F_XU_V_MF2, 306 },
    { PseudoVFCVT_RM_F_XU_V_MF4, 307 },
    { PseudoVFCVT_RM_F_X_V_M1, 308 },
    { PseudoVFCVT_RM_F_X_V_M2, 309 },
    { PseudoVFCVT_RM_F_X_V_M4, 310 },
    { PseudoVFCVT_RM_F_X_V_M8, 311 },
    { PseudoVFCVT_RM_F_X_V_MF2, 312 },
    { PseudoVFCVT_RM_F_X_V_MF4, 313 },
    { PseudoVFCVT_RM_XU_F_V_M1, 314 },
    { PseudoVFCVT_RM_XU_F_V_M2, 315 },
    { PseudoVFCVT_RM_XU_F_V_M4, 316 },
    { PseudoVFCVT_RM_XU_F_V_M8, 317 },
    { PseudoVFCVT_RM_XU_F_V_MF2, 318 },
    { PseudoVFCVT_RM_XU_F_V_MF4, 319 },
    { PseudoVFCVT_RM_X_F_V_M1, 320 },
    { PseudoVFCVT_RM_X_F_V_M2, 321 },
    { PseudoVFCVT_RM_X_F_V_M4, 322 },
    { PseudoVFCVT_RM_X_F_V_M8, 323 },
    { PseudoVFCVT_RM_X_F_V_MF2, 324 },
    { PseudoVFCVT_RM_X_F_V_MF4, 325 },
    { PseudoVFCVT_RTZ_XU_F_V_M1, 326 },
    { PseudoVFCVT_RTZ_XU_F_V_M2, 327 },
    { PseudoVFCVT_RTZ_XU_F_V_M4, 328 },
    { PseudoVFCVT_RTZ_XU_F_V_M8, 329 },
    { PseudoVFCVT_RTZ_XU_F_V_MF2, 330 },
    { PseudoVFCVT_RTZ_XU_F_V_MF4, 331 },
    { PseudoVFCVT_RTZ_X_F_V_M1, 332 },
    { PseudoVFCVT_RTZ_X_F_V_M2, 333 },
    { PseudoVFCVT_RTZ_X_F_V_M4, 334 },
    { PseudoVFCVT_RTZ_X_F_V_M8, 335 },
    { PseudoVFCVT_RTZ_X_F_V_MF2, 336 },
    { PseudoVFCVT_RTZ_X_F_V_MF4, 337 },
    { PseudoVFCVT_XU_F_V_M1, 338 },
    { PseudoVFCVT_XU_F_V_M2, 339 },
    { PseudoVFCVT_XU_F_V_M4, 340 },
    { PseudoVFCVT_XU_F_V_M8, 341 },
    { PseudoVFCVT_XU_F_V_MF2, 342 },
    { PseudoVFCVT_XU_F_V_MF4, 343 },
    { PseudoVFCVT_X_F_V_M1, 344 },
    { PseudoVFCVT_X_F_V_M2, 345 },
    { PseudoVFCVT_X_F_V_M4, 346 },
    { PseudoVFCVT_X_F_V_M8, 347 },
    { PseudoVFCVT_X_F_V_MF2, 348 },
    { PseudoVFCVT_X_F_V_MF4, 349 },
    { PseudoVFDIV_VF16_M1_E16, 350 },
    { PseudoVFDIV_VF16_M2_E16, 351 },
    { PseudoVFDIV_VF16_M4_E16, 352 },
    { PseudoVFDIV_VF16_M8_E16, 353 },
    { PseudoVFDIV_VF16_MF2_E16, 354 },
    { PseudoVFDIV_VF16_MF4_E16, 355 },
    { PseudoVFDIV_VF32_M1_E32, 356 },
    { PseudoVFDIV_VF32_M2_E32, 357 },
    { PseudoVFDIV_VF32_M4_E32, 358 },
    { PseudoVFDIV_VF32_M8_E32, 359 },
    { PseudoVFDIV_VF32_MF2_E32, 360 },
    { PseudoVFDIV_VF64_M1_E64, 361 },
    { PseudoVFDIV_VF64_M2_E64, 362 },
    { PseudoVFDIV_VF64_M4_E64, 363 },
    { PseudoVFDIV_VF64_M8_E64, 364 },
    { PseudoVFDIV_VV_M1_E16, 365 },
    { PseudoVFDIV_VV_M1_E32, 366 },
    { PseudoVFDIV_VV_M1_E64, 367 },
    { PseudoVFDIV_VV_M2_E16, 368 },
    { PseudoVFDIV_VV_M2_E32, 369 },
    { PseudoVFDIV_VV_M2_E64, 370 },
    { PseudoVFDIV_VV_M4_E16, 371 },
    { PseudoVFDIV_VV_M4_E32, 372 },
    { PseudoVFDIV_VV_M4_E64, 373 },
    { PseudoVFDIV_VV_M8_E16, 374 },
    { PseudoVFDIV_VV_M8_E32, 375 },
    { PseudoVFDIV_VV_M8_E64, 376 },
    { PseudoVFDIV_VV_MF2_E16, 377 },
    { PseudoVFDIV_VV_MF2_E32, 378 },
    { PseudoVFDIV_VV_MF4_E16, 379 },
    { PseudoVFMACC_VF16_M1, 380 },
    { PseudoVFMACC_VF16_M2, 381 },
    { PseudoVFMACC_VF16_M4, 382 },
    { PseudoVFMACC_VF16_M8, 383 },
    { PseudoVFMACC_VF16_MF2, 384 },
    { PseudoVFMACC_VF16_MF4, 385 },
    { PseudoVFMACC_VF32_M1, 386 },
    { PseudoVFMACC_VF32_M2, 387 },
    { PseudoVFMACC_VF32_M4, 388 },
    { PseudoVFMACC_VF32_M8, 389 },
    { PseudoVFMACC_VF32_MF2, 390 },
    { PseudoVFMACC_VF64_M1, 391 },
    { PseudoVFMACC_VF64_M2, 392 },
    { PseudoVFMACC_VF64_M4, 393 },
    { PseudoVFMACC_VF64_M8, 394 },
    { PseudoVFMACC_VV_M1, 395 },
    { PseudoVFMACC_VV_M2, 396 },
    { PseudoVFMACC_VV_M4, 397 },
    { PseudoVFMACC_VV_M8, 398 },
    { PseudoVFMACC_VV_MF2, 399 },
    { PseudoVFMACC_VV_MF4, 400 },
    { PseudoVFMADD_VF16_M1, 401 },
    { PseudoVFMADD_VF16_M2, 402 },
    { PseudoVFMADD_VF16_M4, 403 },
    { PseudoVFMADD_VF16_M8, 404 },
    { PseudoVFMADD_VF16_MF2, 405 },
    { PseudoVFMADD_VF16_MF4, 406 },
    { PseudoVFMADD_VF32_M1, 407 },
    { PseudoVFMADD_VF32_M2, 408 },
    { PseudoVFMADD_VF32_M4, 409 },
    { PseudoVFMADD_VF32_M8, 410 },
    { PseudoVFMADD_VF32_MF2, 411 },
    { PseudoVFMADD_VF64_M1, 412 },
    { PseudoVFMADD_VF64_M2, 413 },
    { PseudoVFMADD_VF64_M4, 414 },
    { PseudoVFMADD_VF64_M8, 415 },
    { PseudoVFMADD_VV_M1, 416 },
    { PseudoVFMADD_VV_M2, 417 },
    { PseudoVFMADD_VV_M4, 418 },
    { PseudoVFMADD_VV_M8, 419 },
    { PseudoVFMADD_VV_MF2, 420 },
    { PseudoVFMADD_VV_MF4, 421 },
    { PseudoVFMAX_VF16_M1, 422 },
    { PseudoVFMAX_VF16_M2, 423 },
    { PseudoVFMAX_VF16_M4, 424 },
    { PseudoVFMAX_VF16_M8, 425 },
    { PseudoVFMAX_VF16_MF2, 426 },
    { PseudoVFMAX_VF16_MF4, 427 },
    { PseudoVFMAX_VF32_M1, 428 },
    { PseudoVFMAX_VF32_M2, 429 },
    { PseudoVFMAX_VF32_M4, 430 },
    { PseudoVFMAX_VF32_M8, 431 },
    { PseudoVFMAX_VF32_MF2, 432 },
    { PseudoVFMAX_VF64_M1, 433 },
    { PseudoVFMAX_VF64_M2, 434 },
    { PseudoVFMAX_VF64_M4, 435 },
    { PseudoVFMAX_VF64_M8, 436 },
    { PseudoVFMAX_VV_M1, 437 },
    { PseudoVFMAX_VV_M2, 438 },
    { PseudoVFMAX_VV_M4, 439 },
    { PseudoVFMAX_VV_M8, 440 },
    { PseudoVFMAX_VV_MF2, 441 },
    { PseudoVFMAX_VV_MF4, 442 },
    { PseudoVFMIN_VF16_M1, 443 },
    { PseudoVFMIN_VF16_M2, 444 },
    { PseudoVFMIN_VF16_M4, 445 },
    { PseudoVFMIN_VF16_M8, 446 },
    { PseudoVFMIN_VF16_MF2, 447 },
    { PseudoVFMIN_VF16_MF4, 448 },
    { PseudoVFMIN_VF32_M1, 449 },
    { PseudoVFMIN_VF32_M2, 450 },
    { PseudoVFMIN_VF32_M4, 451 },
    { PseudoVFMIN_VF32_M8, 452 },
    { PseudoVFMIN_VF32_MF2, 453 },
    { PseudoVFMIN_VF64_M1, 454 },
    { PseudoVFMIN_VF64_M2, 455 },
    { PseudoVFMIN_VF64_M4, 456 },
    { PseudoVFMIN_VF64_M8, 457 },
    { PseudoVFMIN_VV_M1, 458 },
    { PseudoVFMIN_VV_M2, 459 },
    { PseudoVFMIN_VV_M4, 460 },
    { PseudoVFMIN_VV_M8, 461 },
    { PseudoVFMIN_VV_MF2, 462 },
    { PseudoVFMIN_VV_MF4, 463 },
    { PseudoVFMSAC_VF16_M1, 464 },
    { PseudoVFMSAC_VF16_M2, 465 },
    { PseudoVFMSAC_VF16_M4, 466 },
    { PseudoVFMSAC_VF16_M8, 467 },
    { PseudoVFMSAC_VF16_MF2, 468 },
    { PseudoVFMSAC_VF16_MF4, 469 },
    { PseudoVFMSAC_VF32_M1, 470 },
    { PseudoVFMSAC_VF32_M2, 471 },
    { PseudoVFMSAC_VF32_M4, 472 },
    { PseudoVFMSAC_VF32_M8, 473 },
    { PseudoVFMSAC_VF32_MF2, 474 },
    { PseudoVFMSAC_VF64_M1, 475 },
    { PseudoVFMSAC_VF64_M2, 476 },
    { PseudoVFMSAC_VF64_M4, 477 },
    { PseudoVFMSAC_VF64_M8, 478 },
    { PseudoVFMSAC_VV_M1, 479 },
    { PseudoVFMSAC_VV_M2, 480 },
    { PseudoVFMSAC_VV_M4, 481 },
    { PseudoVFMSAC_VV_M8, 482 },
    { PseudoVFMSAC_VV_MF2, 483 },
    { PseudoVFMSAC_VV_MF4, 484 },
    { PseudoVFMSUB_VF16_M1, 485 },
    { PseudoVFMSUB_VF16_M2, 486 },
    { PseudoVFMSUB_VF16_M4, 487 },
    { PseudoVFMSUB_VF16_M8, 488 },
    { PseudoVFMSUB_VF16_MF2, 489 },
    { PseudoVFMSUB_VF16_MF4, 490 },
    { PseudoVFMSUB_VF32_M1, 491 },
    { PseudoVFMSUB_VF32_M2, 492 },
    { PseudoVFMSUB_VF32_M4, 493 },
    { PseudoVFMSUB_VF32_M8, 494 },
    { PseudoVFMSUB_VF32_MF2, 495 },
    { PseudoVFMSUB_VF64_M1, 496 },
    { PseudoVFMSUB_VF64_M2, 497 },
    { PseudoVFMSUB_VF64_M4, 498 },
    { PseudoVFMSUB_VF64_M8, 499 },
    { PseudoVFMSUB_VV_M1, 500 },
    { PseudoVFMSUB_VV_M2, 501 },
    { PseudoVFMSUB_VV_M4, 502 },
    { PseudoVFMSUB_VV_M8, 503 },
    { PseudoVFMSUB_VV_MF2, 504 },
    { PseudoVFMSUB_VV_MF4, 505 },
    { PseudoVFMUL_VF16_M1, 506 },
    { PseudoVFMUL_VF16_M2, 507 },
    { PseudoVFMUL_VF16_M4, 508 },
    { PseudoVFMUL_VF16_M8, 509 },
    { PseudoVFMUL_VF16_MF2, 510 },
    { PseudoVFMUL_VF16_MF4, 511 },
    { PseudoVFMUL_VF32_M1, 512 },
    { PseudoVFMUL_VF32_M2, 513 },
    { PseudoVFMUL_VF32_M4, 514 },
    { PseudoVFMUL_VF32_M8, 515 },
    { PseudoVFMUL_VF32_MF2, 516 },
    { PseudoVFMUL_VF64_M1, 517 },
    { PseudoVFMUL_VF64_M2, 518 },
    { PseudoVFMUL_VF64_M4, 519 },
    { PseudoVFMUL_VF64_M8, 520 },
    { PseudoVFMUL_VV_M1, 521 },
    { PseudoVFMUL_VV_M2, 522 },
    { PseudoVFMUL_VV_M4, 523 },
    { PseudoVFMUL_VV_M8, 524 },
    { PseudoVFMUL_VV_MF2, 525 },
    { PseudoVFMUL_VV_MF4, 526 },
    { PseudoVFNCVT_F_F_W_M1, 527 },
    { PseudoVFNCVT_F_F_W_M2, 528 },
    { PseudoVFNCVT_F_F_W_M4, 529 },
    { PseudoVFNCVT_F_F_W_MF2, 530 },
    { PseudoVFNCVT_F_F_W_MF4, 531 },
    { PseudoVFNCVT_F_XU_W_M1, 532 },
    { PseudoVFNCVT_F_XU_W_M2, 533 },
    { PseudoVFNCVT_F_XU_W_M4, 534 },
    { PseudoVFNCVT_F_XU_W_MF2, 535 },
    { PseudoVFNCVT_F_XU_W_MF4, 536 },
    { PseudoVFNCVT_F_X_W_M1, 537 },
    { PseudoVFNCVT_F_X_W_M2, 538 },
    { PseudoVFNCVT_F_X_W_M4, 539 },
    { PseudoVFNCVT_F_X_W_MF2, 540 },
    { PseudoVFNCVT_F_X_W_MF4, 541 },
    { PseudoVFNCVT_RM_F_XU_W_M1, 542 },
    { PseudoVFNCVT_RM_F_XU_W_M2, 543 },
    { PseudoVFNCVT_RM_F_XU_W_M4, 544 },
    { PseudoVFNCVT_RM_F_XU_W_MF2, 545 },
    { PseudoVFNCVT_RM_F_XU_W_MF4, 546 },
    { PseudoVFNCVT_RM_F_X_W_M1, 547 },
    { PseudoVFNCVT_RM_F_X_W_M2, 548 },
    { PseudoVFNCVT_RM_F_X_W_M4, 549 },
    { PseudoVFNCVT_RM_F_X_W_MF2, 550 },
    { PseudoVFNCVT_RM_F_X_W_MF4, 551 },
    { PseudoVFNCVT_RM_XU_F_W_M1, 552 },
    { PseudoVFNCVT_RM_XU_F_W_M2, 553 },
    { PseudoVFNCVT_RM_XU_F_W_M4, 554 },
    { PseudoVFNCVT_RM_XU_F_W_MF2, 555 },
    { PseudoVFNCVT_RM_XU_F_W_MF4, 556 },
    { PseudoVFNCVT_RM_XU_F_W_MF8, 557 },
    { PseudoVFNCVT_RM_X_F_W_M1, 558 },
    { PseudoVFNCVT_RM_X_F_W_M2, 559 },
    { PseudoVFNCVT_RM_X_F_W_M4, 560 },
    { PseudoVFNCVT_RM_X_F_W_MF2, 561 },
    { PseudoVFNCVT_RM_X_F_W_MF4, 562 },
    { PseudoVFNCVT_RM_X_F_W_MF8, 563 },
    { PseudoVFNCVT_ROD_F_F_W_M1, 564 },
    { PseudoVFNCVT_ROD_F_F_W_M2, 565 },
    { PseudoVFNCVT_ROD_F_F_W_M4, 566 },
    { PseudoVFNCVT_ROD_F_F_W_MF2, 567 },
    { PseudoVFNCVT_ROD_F_F_W_MF4, 568 },
    { PseudoVFNCVT_RTZ_XU_F_W_M1, 569 },
    { PseudoVFNCVT_RTZ_XU_F_W_M2, 570 },
    { PseudoVFNCVT_RTZ_XU_F_W_M4, 571 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF2, 572 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF4, 573 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF8, 574 },
    { PseudoVFNCVT_RTZ_X_F_W_M1, 575 },
    { PseudoVFNCVT_RTZ_X_F_W_M2, 576 },
    { PseudoVFNCVT_RTZ_X_F_W_M4, 577 },
    { PseudoVFNCVT_RTZ_X_F_W_MF2, 578 },
    { PseudoVFNCVT_RTZ_X_F_W_MF4, 579 },
    { PseudoVFNCVT_RTZ_X_F_W_MF8, 580 },
    { PseudoVFNCVT_XU_F_W_M1, 581 },
    { PseudoVFNCVT_XU_F_W_M2, 582 },
    { PseudoVFNCVT_XU_F_W_M4, 583 },
    { PseudoVFNCVT_XU_F_W_MF2, 584 },
    { PseudoVFNCVT_XU_F_W_MF4, 585 },
    { PseudoVFNCVT_XU_F_W_MF8, 586 },
    { PseudoVFNCVT_X_F_W_M1, 587 },
    { PseudoVFNCVT_X_F_W_M2, 588 },
    { PseudoVFNCVT_X_F_W_M4, 589 },
    { PseudoVFNCVT_X_F_W_MF2, 590 },
    { PseudoVFNCVT_X_F_W_MF4, 591 },
    { PseudoVFNCVT_X_F_W_MF8, 592 },
    { PseudoVFNMACC_VF16_M1, 593 },
    { PseudoVFNMACC_VF16_M2, 594 },
    { PseudoVFNMACC_VF16_M4, 595 },
    { PseudoVFNMACC_VF16_M8, 596 },
    { PseudoVFNMACC_VF16_MF2, 597 },
    { PseudoVFNMACC_VF16_MF4, 598 },
    { PseudoVFNMACC_VF32_M1, 599 },
    { PseudoVFNMACC_VF32_M2, 600 },
    { PseudoVFNMACC_VF32_M4, 601 },
    { PseudoVFNMACC_VF32_M8, 602 },
    { PseudoVFNMACC_VF32_MF2, 603 },
    { PseudoVFNMACC_VF64_M1, 604 },
    { PseudoVFNMACC_VF64_M2, 605 },
    { PseudoVFNMACC_VF64_M4, 606 },
    { PseudoVFNMACC_VF64_M8, 607 },
    { PseudoVFNMACC_VV_M1, 608 },
    { PseudoVFNMACC_VV_M2, 609 },
    { PseudoVFNMACC_VV_M4, 610 },
    { PseudoVFNMACC_VV_M8, 611 },
    { PseudoVFNMACC_VV_MF2, 612 },
    { PseudoVFNMACC_VV_MF4, 613 },
    { PseudoVFNMADD_VF16_M1, 614 },
    { PseudoVFNMADD_VF16_M2, 615 },
    { PseudoVFNMADD_VF16_M4, 616 },
    { PseudoVFNMADD_VF16_M8, 617 },
    { PseudoVFNMADD_VF16_MF2, 618 },
    { PseudoVFNMADD_VF16_MF4, 619 },
    { PseudoVFNMADD_VF32_M1, 620 },
    { PseudoVFNMADD_VF32_M2, 621 },
    { PseudoVFNMADD_VF32_M4, 622 },
    { PseudoVFNMADD_VF32_M8, 623 },
    { PseudoVFNMADD_VF32_MF2, 624 },
    { PseudoVFNMADD_VF64_M1, 625 },
    { PseudoVFNMADD_VF64_M2, 626 },
    { PseudoVFNMADD_VF64_M4, 627 },
    { PseudoVFNMADD_VF64_M8, 628 },
    { PseudoVFNMADD_VV_M1, 629 },
    { PseudoVFNMADD_VV_M2, 630 },
    { PseudoVFNMADD_VV_M4, 631 },
    { PseudoVFNMADD_VV_M8, 632 },
    { PseudoVFNMADD_VV_MF2, 633 },
    { PseudoVFNMADD_VV_MF4, 634 },
    { PseudoVFNMSAC_VF16_M1, 635 },
    { PseudoVFNMSAC_VF16_M2, 636 },
    { PseudoVFNMSAC_VF16_M4, 637 },
    { PseudoVFNMSAC_VF16_M8, 638 },
    { PseudoVFNMSAC_VF16_MF2, 639 },
    { PseudoVFNMSAC_VF16_MF4, 640 },
    { PseudoVFNMSAC_VF32_M1, 641 },
    { PseudoVFNMSAC_VF32_M2, 642 },
    { PseudoVFNMSAC_VF32_M4, 643 },
    { PseudoVFNMSAC_VF32_M8, 644 },
    { PseudoVFNMSAC_VF32_MF2, 645 },
    { PseudoVFNMSAC_VF64_M1, 646 },
    { PseudoVFNMSAC_VF64_M2, 647 },
    { PseudoVFNMSAC_VF64_M4, 648 },
    { PseudoVFNMSAC_VF64_M8, 649 },
    { PseudoVFNMSAC_VV_M1, 650 },
    { PseudoVFNMSAC_VV_M2, 651 },
    { PseudoVFNMSAC_VV_M4, 652 },
    { PseudoVFNMSAC_VV_M8, 653 },
    { PseudoVFNMSAC_VV_MF2, 654 },
    { PseudoVFNMSAC_VV_MF4, 655 },
    { PseudoVFNMSUB_VF16_M1, 656 },
    { PseudoVFNMSUB_VF16_M2, 657 },
    { PseudoVFNMSUB_VF16_M4, 658 },
    { PseudoVFNMSUB_VF16_M8, 659 },
    { PseudoVFNMSUB_VF16_MF2, 660 },
    { PseudoVFNMSUB_VF16_MF4, 661 },
    { PseudoVFNMSUB_VF32_M1, 662 },
    { PseudoVFNMSUB_VF32_M2, 663 },
    { PseudoVFNMSUB_VF32_M4, 664 },
    { PseudoVFNMSUB_VF32_M8, 665 },
    { PseudoVFNMSUB_VF32_MF2, 666 },
    { PseudoVFNMSUB_VF64_M1, 667 },
    { PseudoVFNMSUB_VF64_M2, 668 },
    { PseudoVFNMSUB_VF64_M4, 669 },
    { PseudoVFNMSUB_VF64_M8, 670 },
    { PseudoVFNMSUB_VV_M1, 671 },
    { PseudoVFNMSUB_VV_M2, 672 },
    { PseudoVFNMSUB_VV_M4, 673 },
    { PseudoVFNMSUB_VV_M8, 674 },
    { PseudoVFNMSUB_VV_MF2, 675 },
    { PseudoVFNMSUB_VV_MF4, 676 },
    { PseudoVFRDIV_VF16_M1_E16, 677 },
    { PseudoVFRDIV_VF16_M2_E16, 678 },
    { PseudoVFRDIV_VF16_M4_E16, 679 },
    { PseudoVFRDIV_VF16_M8_E16, 680 },
    { PseudoVFRDIV_VF16_MF2_E16, 681 },
    { PseudoVFRDIV_VF16_MF4_E16, 682 },
    { PseudoVFRDIV_VF32_M1_E32, 683 },
    { PseudoVFRDIV_VF32_M2_E32, 684 },
    { PseudoVFRDIV_VF32_M4_E32, 685 },
    { PseudoVFRDIV_VF32_M8_E32, 686 },
    { PseudoVFRDIV_VF32_MF2_E32, 687 },
    { PseudoVFRDIV_VF64_M1_E64, 688 },
    { PseudoVFRDIV_VF64_M2_E64, 689 },
    { PseudoVFRDIV_VF64_M4_E64, 690 },
    { PseudoVFRDIV_VF64_M8_E64, 691 },
    { PseudoVFREC7_V_M1, 692 },
    { PseudoVFREC7_V_M2, 693 },
    { PseudoVFREC7_V_M4, 694 },
    { PseudoVFREC7_V_M8, 695 },
    { PseudoVFREC7_V_MF2, 696 },
    { PseudoVFREC7_V_MF4, 697 },
    { PseudoVFRSQRT7_V_M1, 698 },
    { PseudoVFRSQRT7_V_M2, 699 },
    { PseudoVFRSQRT7_V_M4, 700 },
    { PseudoVFRSQRT7_V_M8, 701 },
    { PseudoVFRSQRT7_V_MF2, 702 },
    { PseudoVFRSQRT7_V_MF4, 703 },
    { PseudoVFRSUB_VF16_M1, 704 },
    { PseudoVFRSUB_VF16_M2, 705 },
    { PseudoVFRSUB_VF16_M4, 706 },
    { PseudoVFRSUB_VF16_M8, 707 },
    { PseudoVFRSUB_VF16_MF2, 708 },
    { PseudoVFRSUB_VF16_MF4, 709 },
    { PseudoVFRSUB_VF32_M1, 710 },
    { PseudoVFRSUB_VF32_M2, 711 },
    { PseudoVFRSUB_VF32_M4, 712 },
    { PseudoVFRSUB_VF32_M8, 713 },
    { PseudoVFRSUB_VF32_MF2, 714 },
    { PseudoVFRSUB_VF64_M1, 715 },
    { PseudoVFRSUB_VF64_M2, 716 },
    { PseudoVFRSUB_VF64_M4, 717 },
    { PseudoVFRSUB_VF64_M8, 718 },
    { PseudoVFSGNJN_VF16_M1, 719 },
    { PseudoVFSGNJN_VF16_M2, 720 },
    { PseudoVFSGNJN_VF16_M4, 721 },
    { PseudoVFSGNJN_VF16_M8, 722 },
    { PseudoVFSGNJN_VF16_MF2, 723 },
    { PseudoVFSGNJN_VF16_MF4, 724 },
    { PseudoVFSGNJN_VF32_M1, 725 },
    { PseudoVFSGNJN_VF32_M2, 726 },
    { PseudoVFSGNJN_VF32_M4, 727 },
    { PseudoVFSGNJN_VF32_M8, 728 },
    { PseudoVFSGNJN_VF32_MF2, 729 },
    { PseudoVFSGNJN_VF64_M1, 730 },
    { PseudoVFSGNJN_VF64_M2, 731 },
    { PseudoVFSGNJN_VF64_M4, 732 },
    { PseudoVFSGNJN_VF64_M8, 733 },
    { PseudoVFSGNJN_VV_M1, 734 },
    { PseudoVFSGNJN_VV_M2, 735 },
    { PseudoVFSGNJN_VV_M4, 736 },
    { PseudoVFSGNJN_VV_M8, 737 },
    { PseudoVFSGNJN_VV_MF2, 738 },
    { PseudoVFSGNJN_VV_MF4, 739 },
    { PseudoVFSGNJX_VF16_M1, 740 },
    { PseudoVFSGNJX_VF16_M2, 741 },
    { PseudoVFSGNJX_VF16_M4, 742 },
    { PseudoVFSGNJX_VF16_M8, 743 },
    { PseudoVFSGNJX_VF16_MF2, 744 },
    { PseudoVFSGNJX_VF16_MF4, 745 },
    { PseudoVFSGNJX_VF32_M1, 746 },
    { PseudoVFSGNJX_VF32_M2, 747 },
    { PseudoVFSGNJX_VF32_M4, 748 },
    { PseudoVFSGNJX_VF32_M8, 749 },
    { PseudoVFSGNJX_VF32_MF2, 750 },
    { PseudoVFSGNJX_VF64_M1, 751 },
    { PseudoVFSGNJX_VF64_M2, 752 },
    { PseudoVFSGNJX_VF64_M4, 753 },
    { PseudoVFSGNJX_VF64_M8, 754 },
    { PseudoVFSGNJX_VV_M1, 755 },
    { PseudoVFSGNJX_VV_M2, 756 },
    { PseudoVFSGNJX_VV_M4, 757 },
    { PseudoVFSGNJX_VV_M8, 758 },
    { PseudoVFSGNJX_VV_MF2, 759 },
    { PseudoVFSGNJX_VV_MF4, 760 },
    { PseudoVFSGNJ_VF16_M1, 761 },
    { PseudoVFSGNJ_VF16_M2, 762 },
    { PseudoVFSGNJ_VF16_M4, 763 },
    { PseudoVFSGNJ_VF16_M8, 764 },
    { PseudoVFSGNJ_VF16_MF2, 765 },
    { PseudoVFSGNJ_VF16_MF4, 766 },
    { PseudoVFSGNJ_VF32_M1, 767 },
    { PseudoVFSGNJ_VF32_M2, 768 },
    { PseudoVFSGNJ_VF32_M4, 769 },
    { PseudoVFSGNJ_VF32_M8, 770 },
    { PseudoVFSGNJ_VF32_MF2, 771 },
    { PseudoVFSGNJ_VF64_M1, 772 },
    { PseudoVFSGNJ_VF64_M2, 773 },
    { PseudoVFSGNJ_VF64_M4, 774 },
    { PseudoVFSGNJ_VF64_M8, 775 },
    { PseudoVFSGNJ_VV_M1, 776 },
    { PseudoVFSGNJ_VV_M2, 777 },
    { PseudoVFSGNJ_VV_M4, 778 },
    { PseudoVFSGNJ_VV_M8, 779 },
    { PseudoVFSGNJ_VV_MF2, 780 },
    { PseudoVFSGNJ_VV_MF4, 781 },
    { PseudoVFSLIDE1DOWN_VF16_M1, 782 },
    { PseudoVFSLIDE1DOWN_VF16_M2, 783 },
    { PseudoVFSLIDE1DOWN_VF16_M4, 784 },
    { PseudoVFSLIDE1DOWN_VF16_M8, 785 },
    { PseudoVFSLIDE1DOWN_VF16_MF2, 786 },
    { PseudoVFSLIDE1DOWN_VF16_MF4, 787 },
    { PseudoVFSLIDE1DOWN_VF32_M1, 788 },
    { PseudoVFSLIDE1DOWN_VF32_M2, 789 },
    { PseudoVFSLIDE1DOWN_VF32_M4, 790 },
    { PseudoVFSLIDE1DOWN_VF32_M8, 791 },
    { PseudoVFSLIDE1DOWN_VF32_MF2, 792 },
    { PseudoVFSLIDE1DOWN_VF64_M1, 793 },
    { PseudoVFSLIDE1DOWN_VF64_M2, 794 },
    { PseudoVFSLIDE1DOWN_VF64_M4, 795 },
    { PseudoVFSLIDE1DOWN_VF64_M8, 796 },
    { PseudoVFSLIDE1UP_VF16_M1, 797 },
    { PseudoVFSLIDE1UP_VF16_M2, 798 },
    { PseudoVFSLIDE1UP_VF16_M4, 799 },
    { PseudoVFSLIDE1UP_VF16_M8, 800 },
    { PseudoVFSLIDE1UP_VF16_MF2, 801 },
    { PseudoVFSLIDE1UP_VF16_MF4, 802 },
    { PseudoVFSLIDE1UP_VF32_M1, 803 },
    { PseudoVFSLIDE1UP_VF32_M2, 804 },
    { PseudoVFSLIDE1UP_VF32_M4, 805 },
    { PseudoVFSLIDE1UP_VF32_M8, 806 },
    { PseudoVFSLIDE1UP_VF32_MF2, 807 },
    { PseudoVFSLIDE1UP_VF64_M1, 808 },
    { PseudoVFSLIDE1UP_VF64_M2, 809 },
    { PseudoVFSLIDE1UP_VF64_M4, 810 },
    { PseudoVFSLIDE1UP_VF64_M8, 811 },
    { PseudoVFSQRT_V_M1_E16, 812 },
    { PseudoVFSQRT_V_M1_E32, 813 },
    { PseudoVFSQRT_V_M1_E64, 814 },
    { PseudoVFSQRT_V_M2_E16, 815 },
    { PseudoVFSQRT_V_M2_E32, 816 },
    { PseudoVFSQRT_V_M2_E64, 817 },
    { PseudoVFSQRT_V_M4_E16, 818 },
    { PseudoVFSQRT_V_M4_E32, 819 },
    { PseudoVFSQRT_V_M4_E64, 820 },
    { PseudoVFSQRT_V_M8_E16, 821 },
    { PseudoVFSQRT_V_M8_E32, 822 },
    { PseudoVFSQRT_V_M8_E64, 823 },
    { PseudoVFSQRT_V_MF2_E16, 824 },
    { PseudoVFSQRT_V_MF2_E32, 825 },
    { PseudoVFSQRT_V_MF4_E16, 826 },
    { PseudoVFSUB_VF16_M1, 827 },
    { PseudoVFSUB_VF16_M2, 828 },
    { PseudoVFSUB_VF16_M4, 829 },
    { PseudoVFSUB_VF16_M8, 830 },
    { PseudoVFSUB_VF16_MF2, 831 },
    { PseudoVFSUB_VF16_MF4, 832 },
    { PseudoVFSUB_VF32_M1, 833 },
    { PseudoVFSUB_VF32_M2, 834 },
    { PseudoVFSUB_VF32_M4, 835 },
    { PseudoVFSUB_VF32_M8, 836 },
    { PseudoVFSUB_VF32_MF2, 837 },
    { PseudoVFSUB_VF64_M1, 838 },
    { PseudoVFSUB_VF64_M2, 839 },
    { PseudoVFSUB_VF64_M4, 840 },
    { PseudoVFSUB_VF64_M8, 841 },
    { PseudoVFSUB_VV_M1, 842 },
    { PseudoVFSUB_VV_M2, 843 },
    { PseudoVFSUB_VV_M4, 844 },
    { PseudoVFSUB_VV_M8, 845 },
    { PseudoVFSUB_VV_MF2, 846 },
    { PseudoVFSUB_VV_MF4, 847 },
    { PseudoVFWADD_VF16_M1, 848 },
    { PseudoVFWADD_VF16_M2, 849 },
    { PseudoVFWADD_VF16_M4, 850 },
    { PseudoVFWADD_VF16_MF2, 851 },
    { PseudoVFWADD_VF16_MF4, 852 },
    { PseudoVFWADD_VF32_M1, 853 },
    { PseudoVFWADD_VF32_M2, 854 },
    { PseudoVFWADD_VF32_M4, 855 },
    { PseudoVFWADD_VF32_MF2, 856 },
    { PseudoVFWADD_VV_M1, 857 },
    { PseudoVFWADD_VV_M2, 858 },
    { PseudoVFWADD_VV_M4, 859 },
    { PseudoVFWADD_VV_MF2, 860 },
    { PseudoVFWADD_VV_MF4, 861 },
    { PseudoVFWADD_WF16_M1, 862 },
    { PseudoVFWADD_WF16_M2, 863 },
    { PseudoVFWADD_WF16_M4, 864 },
    { PseudoVFWADD_WF16_MF2, 865 },
    { PseudoVFWADD_WF16_MF4, 866 },
    { PseudoVFWADD_WF32_M1, 867 },
    { PseudoVFWADD_WF32_M2, 868 },
    { PseudoVFWADD_WF32_M4, 869 },
    { PseudoVFWADD_WF32_MF2, 870 },
    { PseudoVFWADD_WV_M1, 871 },
    { PseudoVFWADD_WV_M2, 872 },
    { PseudoVFWADD_WV_M4, 873 },
    { PseudoVFWADD_WV_MF2, 874 },
    { PseudoVFWADD_WV_MF4, 875 },
    { PseudoVFWCVT_F_F_V_M1, 876 },
    { PseudoVFWCVT_F_F_V_M2, 877 },
    { PseudoVFWCVT_F_F_V_M4, 878 },
    { PseudoVFWCVT_F_F_V_MF2, 879 },
    { PseudoVFWCVT_F_F_V_MF4, 880 },
    { PseudoVFWCVT_F_XU_V_M1, 881 },
    { PseudoVFWCVT_F_XU_V_M2, 882 },
    { PseudoVFWCVT_F_XU_V_M4, 883 },
    { PseudoVFWCVT_F_XU_V_MF2, 884 },
    { PseudoVFWCVT_F_XU_V_MF4, 885 },
    { PseudoVFWCVT_F_XU_V_MF8, 886 },
    { PseudoVFWCVT_F_X_V_M1, 887 },
    { PseudoVFWCVT_F_X_V_M2, 888 },
    { PseudoVFWCVT_F_X_V_M4, 889 },
    { PseudoVFWCVT_F_X_V_MF2, 890 },
    { PseudoVFWCVT_F_X_V_MF4, 891 },
    { PseudoVFWCVT_F_X_V_MF8, 892 },
    { PseudoVFWCVT_RM_XU_F_V_M1, 893 },
    { PseudoVFWCVT_RM_XU_F_V_M2, 894 },
    { PseudoVFWCVT_RM_XU_F_V_M4, 895 },
    { PseudoVFWCVT_RM_XU_F_V_MF2, 896 },
    { PseudoVFWCVT_RM_XU_F_V_MF4, 897 },
    { PseudoVFWCVT_RM_X_F_V_M1, 898 },
    { PseudoVFWCVT_RM_X_F_V_M2, 899 },
    { PseudoVFWCVT_RM_X_F_V_M4, 900 },
    { PseudoVFWCVT_RM_X_F_V_MF2, 901 },
    { PseudoVFWCVT_RM_X_F_V_MF4, 902 },
    { PseudoVFWCVT_RTZ_XU_F_V_M1, 903 },
    { PseudoVFWCVT_RTZ_XU_F_V_M2, 904 },
    { PseudoVFWCVT_RTZ_XU_F_V_M4, 905 },
    { PseudoVFWCVT_RTZ_XU_F_V_MF2, 906 },
    { PseudoVFWCVT_RTZ_XU_F_V_MF4, 907 },
    { PseudoVFWCVT_RTZ_X_F_V_M1, 908 },
    { PseudoVFWCVT_RTZ_X_F_V_M2, 909 },
    { PseudoVFWCVT_RTZ_X_F_V_M4, 910 },
    { PseudoVFWCVT_RTZ_X_F_V_MF2, 911 },
    { PseudoVFWCVT_RTZ_X_F_V_MF4, 912 },
    { PseudoVFWCVT_XU_F_V_M1, 913 },
    { PseudoVFWCVT_XU_F_V_M2, 914 },
    { PseudoVFWCVT_XU_F_V_M4, 915 },
    { PseudoVFWCVT_XU_F_V_MF2, 916 },
    { PseudoVFWCVT_XU_F_V_MF4, 917 },
    { PseudoVFWCVT_X_F_V_M1, 918 },
    { PseudoVFWCVT_X_F_V_M2, 919 },
    { PseudoVFWCVT_X_F_V_M4, 920 },
    { PseudoVFWCVT_X_F_V_MF2, 921 },
    { PseudoVFWCVT_X_F_V_MF4, 922 },
    { PseudoVFWMACC_VF16_M1, 923 },
    { PseudoVFWMACC_VF16_M2, 924 },
    { PseudoVFWMACC_VF16_M4, 925 },
    { PseudoVFWMACC_VF16_MF2, 926 },
    { PseudoVFWMACC_VF16_MF4, 927 },
    { PseudoVFWMACC_VF32_M1, 928 },
    { PseudoVFWMACC_VF32_M2, 929 },
    { PseudoVFWMACC_VF32_M4, 930 },
    { PseudoVFWMACC_VF32_MF2, 931 },
    { PseudoVFWMACC_VV_M1, 932 },
    { PseudoVFWMACC_VV_M2, 933 },
    { PseudoVFWMACC_VV_M4, 934 },
    { PseudoVFWMACC_VV_MF2, 935 },
    { PseudoVFWMACC_VV_MF4, 936 },
    { PseudoVFWMSAC_VF16_M1, 937 },
    { PseudoVFWMSAC_VF16_M2, 938 },
    { PseudoVFWMSAC_VF16_M4, 939 },
    { PseudoVFWMSAC_VF16_MF2, 940 },
    { PseudoVFWMSAC_VF16_MF4, 941 },
    { PseudoVFWMSAC_VF32_M1, 942 },
    { PseudoVFWMSAC_VF32_M2, 943 },
    { PseudoVFWMSAC_VF32_M4, 944 },
    { PseudoVFWMSAC_VF32_MF2, 945 },
    { PseudoVFWMSAC_VV_M1, 946 },
    { PseudoVFWMSAC_VV_M2, 947 },
    { PseudoVFWMSAC_VV_M4, 948 },
    { PseudoVFWMSAC_VV_MF2, 949 },
    { PseudoVFWMSAC_VV_MF4, 950 },
    { PseudoVFWMUL_VF16_M1, 951 },
    { PseudoVFWMUL_VF16_M2, 952 },
    { PseudoVFWMUL_VF16_M4, 953 },
    { PseudoVFWMUL_VF16_MF2, 954 },
    { PseudoVFWMUL_VF16_MF4, 955 },
    { PseudoVFWMUL_VF32_M1, 956 },
    { PseudoVFWMUL_VF32_M2, 957 },
    { PseudoVFWMUL_VF32_M4, 958 },
    { PseudoVFWMUL_VF32_MF2, 959 },
    { PseudoVFWMUL_VV_M1, 960 },
    { PseudoVFWMUL_VV_M2, 961 },
    { PseudoVFWMUL_VV_M4, 962 },
    { PseudoVFWMUL_VV_MF2, 963 },
    { PseudoVFWMUL_VV_MF4, 964 },
    { PseudoVFWNMACC_VF16_M1, 965 },
    { PseudoVFWNMACC_VF16_M2, 966 },
    { PseudoVFWNMACC_VF16_M4, 967 },
    { PseudoVFWNMACC_VF16_MF2, 968 },
    { PseudoVFWNMACC_VF16_MF4, 969 },
    { PseudoVFWNMACC_VF32_M1, 970 },
    { PseudoVFWNMACC_VF32_M2, 971 },
    { PseudoVFWNMACC_VF32_M4, 972 },
    { PseudoVFWNMACC_VF32_MF2, 973 },
    { PseudoVFWNMACC_VV_M1, 974 },
    { PseudoVFWNMACC_VV_M2, 975 },
    { PseudoVFWNMACC_VV_M4, 976 },
    { PseudoVFWNMACC_VV_MF2, 977 },
    { PseudoVFWNMACC_VV_MF4, 978 },
    { PseudoVFWNMSAC_VF16_M1, 979 },
    { PseudoVFWNMSAC_VF16_M2, 980 },
    { PseudoVFWNMSAC_VF16_M4, 981 },
    { PseudoVFWNMSAC_VF16_MF2, 982 },
    { PseudoVFWNMSAC_VF16_MF4, 983 },
    { PseudoVFWNMSAC_VF32_M1, 984 },
    { PseudoVFWNMSAC_VF32_M2, 985 },
    { PseudoVFWNMSAC_VF32_M4, 986 },
    { PseudoVFWNMSAC_VF32_MF2, 987 },
    { PseudoVFWNMSAC_VV_M1, 988 },
    { PseudoVFWNMSAC_VV_M2, 989 },
    { PseudoVFWNMSAC_VV_M4, 990 },
    { PseudoVFWNMSAC_VV_MF2, 991 },
    { PseudoVFWNMSAC_VV_MF4, 992 },
    { PseudoVFWSUB_VF16_M1, 993 },
    { PseudoVFWSUB_VF16_M2, 994 },
    { PseudoVFWSUB_VF16_M4, 995 },
    { PseudoVFWSUB_VF16_MF2, 996 },
    { PseudoVFWSUB_VF16_MF4, 997 },
    { PseudoVFWSUB_VF32_M1, 998 },
    { PseudoVFWSUB_VF32_M2, 999 },
    { PseudoVFWSUB_VF32_M4, 1000 },
    { PseudoVFWSUB_VF32_MF2, 1001 },
    { PseudoVFWSUB_VV_M1, 1002 },
    { PseudoVFWSUB_VV_M2, 1003 },
    { PseudoVFWSUB_VV_M4, 1004 },
    { PseudoVFWSUB_VV_MF2, 1005 },
    { PseudoVFWSUB_VV_MF4, 1006 },
    { PseudoVFWSUB_WF16_M1, 1007 },
    { PseudoVFWSUB_WF16_M2, 1008 },
    { PseudoVFWSUB_WF16_M4, 1009 },
    { PseudoVFWSUB_WF16_MF2, 1010 },
    { PseudoVFWSUB_WF16_MF4, 1011 },
    { PseudoVFWSUB_WF32_M1, 1012 },
    { PseudoVFWSUB_WF32_M2, 1013 },
    { PseudoVFWSUB_WF32_M4, 1014 },
    { PseudoVFWSUB_WF32_MF2, 1015 },
    { PseudoVFWSUB_WV_M1, 1016 },
    { PseudoVFWSUB_WV_M2, 1017 },
    { PseudoVFWSUB_WV_M4, 1018 },
    { PseudoVFWSUB_WV_MF2, 1019 },
    { PseudoVFWSUB_WV_MF4, 1020 },
    { PseudoVID_V_M1, 1021 },
    { PseudoVID_V_M2, 1022 },
    { PseudoVID_V_M4, 1023 },
    { PseudoVID_V_M8, 1024 },
    { PseudoVID_V_MF2, 1025 },
    { PseudoVID_V_MF4, 1026 },
    { PseudoVID_V_MF8, 1027 },
    { PseudoVIOTA_M_M1, 1028 },
    { PseudoVIOTA_M_M2, 1029 },
    { PseudoVIOTA_M_M4, 1030 },
    { PseudoVIOTA_M_M8, 1031 },
    { PseudoVIOTA_M_MF2, 1032 },
    { PseudoVIOTA_M_MF4, 1033 },
    { PseudoVIOTA_M_MF8, 1034 },
    { PseudoVLE16FF_V_M1, 1035 },
    { PseudoVLE16FF_V_M2, 1036 },
    { PseudoVLE16FF_V_M4, 1037 },
    { PseudoVLE16FF_V_M8, 1038 },
    { PseudoVLE16FF_V_MF2, 1039 },
    { PseudoVLE16FF_V_MF4, 1040 },
    { PseudoVLE16_V_M1, 1041 },
    { PseudoVLE16_V_M2, 1042 },
    { PseudoVLE16_V_M4, 1043 },
    { PseudoVLE16_V_M8, 1044 },
    { PseudoVLE16_V_MF2, 1045 },
    { PseudoVLE16_V_MF4, 1046 },
    { PseudoVLE32FF_V_M1, 1047 },
    { PseudoVLE32FF_V_M2, 1048 },
    { PseudoVLE32FF_V_M4, 1049 },
    { PseudoVLE32FF_V_M8, 1050 },
    { PseudoVLE32FF_V_MF2, 1051 },
    { PseudoVLE32_V_M1, 1052 },
    { PseudoVLE32_V_M2, 1053 },
    { PseudoVLE32_V_M4, 1054 },
    { PseudoVLE32_V_M8, 1055 },
    { PseudoVLE32_V_MF2, 1056 },
    { PseudoVLE64FF_V_M1, 1057 },
    { PseudoVLE64FF_V_M2, 1058 },
    { PseudoVLE64FF_V_M4, 1059 },
    { PseudoVLE64FF_V_M8, 1060 },
    { PseudoVLE64_V_M1, 1061 },
    { PseudoVLE64_V_M2, 1062 },
    { PseudoVLE64_V_M4, 1063 },
    { PseudoVLE64_V_M8, 1064 },
    { PseudoVLE8FF_V_M1, 1065 },
    { PseudoVLE8FF_V_M2, 1066 },
    { PseudoVLE8FF_V_M4, 1067 },
    { PseudoVLE8FF_V_M8, 1068 },
    { PseudoVLE8FF_V_MF2, 1069 },
    { PseudoVLE8FF_V_MF4, 1070 },
    { PseudoVLE8FF_V_MF8, 1071 },
    { PseudoVLE8_V_M1, 1072 },
    { PseudoVLE8_V_M2, 1073 },
    { PseudoVLE8_V_M4, 1074 },
    { PseudoVLE8_V_M8, 1075 },
    { PseudoVLE8_V_MF2, 1076 },
    { PseudoVLE8_V_MF4, 1077 },
    { PseudoVLE8_V_MF8, 1078 },
    { PseudoVLOXEI16_V_M1_M1, 1079 },
    { PseudoVLOXEI16_V_M1_M2, 1080 },
    { PseudoVLOXEI16_V_M1_M4, 1081 },
    { PseudoVLOXEI16_V_M1_MF2, 1082 },
    { PseudoVLOXEI16_V_M2_M1, 1083 },
    { PseudoVLOXEI16_V_M2_M2, 1084 },
    { PseudoVLOXEI16_V_M2_M4, 1085 },
    { PseudoVLOXEI16_V_M2_M8, 1086 },
    { PseudoVLOXEI16_V_M4_M2, 1087 },
    { PseudoVLOXEI16_V_M4_M4, 1088 },
    { PseudoVLOXEI16_V_M4_M8, 1089 },
    { PseudoVLOXEI16_V_M8_M4, 1090 },
    { PseudoVLOXEI16_V_M8_M8, 1091 },
    { PseudoVLOXEI16_V_MF2_M1, 1092 },
    { PseudoVLOXEI16_V_MF2_M2, 1093 },
    { PseudoVLOXEI16_V_MF2_MF2, 1094 },
    { PseudoVLOXEI16_V_MF2_MF4, 1095 },
    { PseudoVLOXEI16_V_MF4_M1, 1096 },
    { PseudoVLOXEI16_V_MF4_MF2, 1097 },
    { PseudoVLOXEI16_V_MF4_MF4, 1098 },
    { PseudoVLOXEI16_V_MF4_MF8, 1099 },
    { PseudoVLOXEI32_V_M1_M1, 1100 },
    { PseudoVLOXEI32_V_M1_M2, 1101 },
    { PseudoVLOXEI32_V_M1_MF2, 1102 },
    { PseudoVLOXEI32_V_M1_MF4, 1103 },
    { PseudoVLOXEI32_V_M2_M1, 1104 },
    { PseudoVLOXEI32_V_M2_M2, 1105 },
    { PseudoVLOXEI32_V_M2_M4, 1106 },
    { PseudoVLOXEI32_V_M2_MF2, 1107 },
    { PseudoVLOXEI32_V_M4_M1, 1108 },
    { PseudoVLOXEI32_V_M4_M2, 1109 },
    { PseudoVLOXEI32_V_M4_M4, 1110 },
    { PseudoVLOXEI32_V_M4_M8, 1111 },
    { PseudoVLOXEI32_V_M8_M2, 1112 },
    { PseudoVLOXEI32_V_M8_M4, 1113 },
    { PseudoVLOXEI32_V_M8_M8, 1114 },
    { PseudoVLOXEI32_V_MF2_M1, 1115 },
    { PseudoVLOXEI32_V_MF2_MF2, 1116 },
    { PseudoVLOXEI32_V_MF2_MF4, 1117 },
    { PseudoVLOXEI32_V_MF2_MF8, 1118 },
    { PseudoVLOXEI64_V_M1_M1, 1119 },
    { PseudoVLOXEI64_V_M1_MF2, 1120 },
    { PseudoVLOXEI64_V_M1_MF4, 1121 },
    { PseudoVLOXEI64_V_M1_MF8, 1122 },
    { PseudoVLOXEI64_V_M2_M1, 1123 },
    { PseudoVLOXEI64_V_M2_M2, 1124 },
    { PseudoVLOXEI64_V_M2_MF2, 1125 },
    { PseudoVLOXEI64_V_M2_MF4, 1126 },
    { PseudoVLOXEI64_V_M4_M1, 1127 },
    { PseudoVLOXEI64_V_M4_M2, 1128 },
    { PseudoVLOXEI64_V_M4_M4, 1129 },
    { PseudoVLOXEI64_V_M4_MF2, 1130 },
    { PseudoVLOXEI64_V_M8_M1, 1131 },
    { PseudoVLOXEI64_V_M8_M2, 1132 },
    { PseudoVLOXEI64_V_M8_M4, 1133 },
    { PseudoVLOXEI64_V_M8_M8, 1134 },
    { PseudoVLOXEI8_V_M1_M1, 1135 },
    { PseudoVLOXEI8_V_M1_M2, 1136 },
    { PseudoVLOXEI8_V_M1_M4, 1137 },
    { PseudoVLOXEI8_V_M1_M8, 1138 },
    { PseudoVLOXEI8_V_M2_M2, 1139 },
    { PseudoVLOXEI8_V_M2_M4, 1140 },
    { PseudoVLOXEI8_V_M2_M8, 1141 },
    { PseudoVLOXEI8_V_M4_M4, 1142 },
    { PseudoVLOXEI8_V_M4_M8, 1143 },
    { PseudoVLOXEI8_V_M8_M8, 1144 },
    { PseudoVLOXEI8_V_MF2_M1, 1145 },
    { PseudoVLOXEI8_V_MF2_M2, 1146 },
    { PseudoVLOXEI8_V_MF2_M4, 1147 },
    { PseudoVLOXEI8_V_MF2_MF2, 1148 },
    { PseudoVLOXEI8_V_MF4_M1, 1149 },
    { PseudoVLOXEI8_V_MF4_M2, 1150 },
    { PseudoVLOXEI8_V_MF4_MF2, 1151 },
    { PseudoVLOXEI8_V_MF4_MF4, 1152 },
    { PseudoVLOXEI8_V_MF8_M1, 1153 },
    { PseudoVLOXEI8_V_MF8_MF2, 1154 },
    { PseudoVLOXEI8_V_MF8_MF4, 1155 },
    { PseudoVLOXEI8_V_MF8_MF8, 1156 },
    { PseudoVLSE16_V_M1, 1157 },
    { PseudoVLSE16_V_M2, 1158 },
    { PseudoVLSE16_V_M4, 1159 },
    { PseudoVLSE16_V_M8, 1160 },
    { PseudoVLSE16_V_MF2, 1161 },
    { PseudoVLSE16_V_MF4, 1162 },
    { PseudoVLSE32_V_M1, 1163 },
    { PseudoVLSE32_V_M2, 1164 },
    { PseudoVLSE32_V_M4, 1165 },
    { PseudoVLSE32_V_M8, 1166 },
    { PseudoVLSE32_V_MF2, 1167 },
    { PseudoVLSE64_V_M1, 1168 },
    { PseudoVLSE64_V_M2, 1169 },
    { PseudoVLSE64_V_M4, 1170 },
    { PseudoVLSE64_V_M8, 1171 },
    { PseudoVLSE8_V_M1, 1172 },
    { PseudoVLSE8_V_M2, 1173 },
    { PseudoVLSE8_V_M4, 1174 },
    { PseudoVLSE8_V_M8, 1175 },
    { PseudoVLSE8_V_MF2, 1176 },
    { PseudoVLSE8_V_MF4, 1177 },
    { PseudoVLSE8_V_MF8, 1178 },
    { PseudoVLUXEI16_V_M1_M1, 1179 },
    { PseudoVLUXEI16_V_M1_M2, 1180 },
    { PseudoVLUXEI16_V_M1_M4, 1181 },
    { PseudoVLUXEI16_V_M1_MF2, 1182 },
    { PseudoVLUXEI16_V_M2_M1, 1183 },
    { PseudoVLUXEI16_V_M2_M2, 1184 },
    { PseudoVLUXEI16_V_M2_M4, 1185 },
    { PseudoVLUXEI16_V_M2_M8, 1186 },
    { PseudoVLUXEI16_V_M4_M2, 1187 },
    { PseudoVLUXEI16_V_M4_M4, 1188 },
    { PseudoVLUXEI16_V_M4_M8, 1189 },
    { PseudoVLUXEI16_V_M8_M4, 1190 },
    { PseudoVLUXEI16_V_M8_M8, 1191 },
    { PseudoVLUXEI16_V_MF2_M1, 1192 },
    { PseudoVLUXEI16_V_MF2_M2, 1193 },
    { PseudoVLUXEI16_V_MF2_MF2, 1194 },
    { PseudoVLUXEI16_V_MF2_MF4, 1195 },
    { PseudoVLUXEI16_V_MF4_M1, 1196 },
    { PseudoVLUXEI16_V_MF4_MF2, 1197 },
    { PseudoVLUXEI16_V_MF4_MF4, 1198 },
    { PseudoVLUXEI16_V_MF4_MF8, 1199 },
    { PseudoVLUXEI32_V_M1_M1, 1200 },
    { PseudoVLUXEI32_V_M1_M2, 1201 },
    { PseudoVLUXEI32_V_M1_MF2, 1202 },
    { PseudoVLUXEI32_V_M1_MF4, 1203 },
    { PseudoVLUXEI32_V_M2_M1, 1204 },
    { PseudoVLUXEI32_V_M2_M2, 1205 },
    { PseudoVLUXEI32_V_M2_M4, 1206 },
    { PseudoVLUXEI32_V_M2_MF2, 1207 },
    { PseudoVLUXEI32_V_M4_M1, 1208 },
    { PseudoVLUXEI32_V_M4_M2, 1209 },
    { PseudoVLUXEI32_V_M4_M4, 1210 },
    { PseudoVLUXEI32_V_M4_M8, 1211 },
    { PseudoVLUXEI32_V_M8_M2, 1212 },
    { PseudoVLUXEI32_V_M8_M4, 1213 },
    { PseudoVLUXEI32_V_M8_M8, 1214 },
    { PseudoVLUXEI32_V_MF2_M1, 1215 },
    { PseudoVLUXEI32_V_MF2_MF2, 1216 },
    { PseudoVLUXEI32_V_MF2_MF4, 1217 },
    { PseudoVLUXEI32_V_MF2_MF8, 1218 },
    { PseudoVLUXEI64_V_M1_M1, 1219 },
    { PseudoVLUXEI64_V_M1_MF2, 1220 },
    { PseudoVLUXEI64_V_M1_MF4, 1221 },
    { PseudoVLUXEI64_V_M1_MF8, 1222 },
    { PseudoVLUXEI64_V_M2_M1, 1223 },
    { PseudoVLUXEI64_V_M2_M2, 1224 },
    { PseudoVLUXEI64_V_M2_MF2, 1225 },
    { PseudoVLUXEI64_V_M2_MF4, 1226 },
    { PseudoVLUXEI64_V_M4_M1, 1227 },
    { PseudoVLUXEI64_V_M4_M2, 1228 },
    { PseudoVLUXEI64_V_M4_M4, 1229 },
    { PseudoVLUXEI64_V_M4_MF2, 1230 },
    { PseudoVLUXEI64_V_M8_M1, 1231 },
    { PseudoVLUXEI64_V_M8_M2, 1232 },
    { PseudoVLUXEI64_V_M8_M4, 1233 },
    { PseudoVLUXEI64_V_M8_M8, 1234 },
    { PseudoVLUXEI8_V_M1_M1, 1235 },
    { PseudoVLUXEI8_V_M1_M2, 1236 },
    { PseudoVLUXEI8_V_M1_M4, 1237 },
    { PseudoVLUXEI8_V_M1_M8, 1238 },
    { PseudoVLUXEI8_V_M2_M2, 1239 },
    { PseudoVLUXEI8_V_M2_M4, 1240 },
    { PseudoVLUXEI8_V_M2_M8, 1241 },
    { PseudoVLUXEI8_V_M4_M4, 1242 },
    { PseudoVLUXEI8_V_M4_M8, 1243 },
    { PseudoVLUXEI8_V_M8_M8, 1244 },
    { PseudoVLUXEI8_V_MF2_M1, 1245 },
    { PseudoVLUXEI8_V_MF2_M2, 1246 },
    { PseudoVLUXEI8_V_MF2_M4, 1247 },
    { PseudoVLUXEI8_V_MF2_MF2, 1248 },
    { PseudoVLUXEI8_V_MF4_M1, 1249 },
    { PseudoVLUXEI8_V_MF4_M2, 1250 },
    { PseudoVLUXEI8_V_MF4_MF2, 1251 },
    { PseudoVLUXEI8_V_MF4_MF4, 1252 },
    { PseudoVLUXEI8_V_MF8_M1, 1253 },
    { PseudoVLUXEI8_V_MF8_MF2, 1254 },
    { PseudoVLUXEI8_V_MF8_MF4, 1255 },
    { PseudoVLUXEI8_V_MF8_MF8, 1256 },
    { PseudoVMACC_VV_M1, 1257 },
    { PseudoVMACC_VV_M2, 1258 },
    { PseudoVMACC_VV_M4, 1259 },
    { PseudoVMACC_VV_M8, 1260 },
    { PseudoVMACC_VV_MF2, 1261 },
    { PseudoVMACC_VV_MF4, 1262 },
    { PseudoVMACC_VV_MF8, 1263 },
    { PseudoVMACC_VX_M1, 1264 },
    { PseudoVMACC_VX_M2, 1265 },
    { PseudoVMACC_VX_M4, 1266 },
    { PseudoVMACC_VX_M8, 1267 },
    { PseudoVMACC_VX_MF2, 1268 },
    { PseudoVMACC_VX_MF4, 1269 },
    { PseudoVMACC_VX_MF8, 1270 },
    { PseudoVMADD_VV_M1, 1271 },
    { PseudoVMADD_VV_M2, 1272 },
    { PseudoVMADD_VV_M4, 1273 },
    { PseudoVMADD_VV_M8, 1274 },
    { PseudoVMADD_VV_MF2, 1275 },
    { PseudoVMADD_VV_MF4, 1276 },
    { PseudoVMADD_VV_MF8, 1277 },
    { PseudoVMADD_VX_M1, 1278 },
    { PseudoVMADD_VX_M2, 1279 },
    { PseudoVMADD_VX_M4, 1280 },
    { PseudoVMADD_VX_M8, 1281 },
    { PseudoVMADD_VX_MF2, 1282 },
    { PseudoVMADD_VX_MF4, 1283 },
    { PseudoVMADD_VX_MF8, 1284 },
    { PseudoVMAXU_VV_M1, 1285 },
    { PseudoVMAXU_VV_M2, 1286 },
    { PseudoVMAXU_VV_M4, 1287 },
    { PseudoVMAXU_VV_M8, 1288 },
    { PseudoVMAXU_VV_MF2, 1289 },
    { PseudoVMAXU_VV_MF4, 1290 },
    { PseudoVMAXU_VV_MF8, 1291 },
    { PseudoVMAXU_VX_M1, 1292 },
    { PseudoVMAXU_VX_M2, 1293 },
    { PseudoVMAXU_VX_M4, 1294 },
    { PseudoVMAXU_VX_M8, 1295 },
    { PseudoVMAXU_VX_MF2, 1296 },
    { PseudoVMAXU_VX_MF4, 1297 },
    { PseudoVMAXU_VX_MF8, 1298 },
    { PseudoVMAX_VV_M1, 1299 },
    { PseudoVMAX_VV_M2, 1300 },
    { PseudoVMAX_VV_M4, 1301 },
    { PseudoVMAX_VV_M8, 1302 },
    { PseudoVMAX_VV_MF2, 1303 },
    { PseudoVMAX_VV_MF4, 1304 },
    { PseudoVMAX_VV_MF8, 1305 },
    { PseudoVMAX_VX_M1, 1306 },
    { PseudoVMAX_VX_M2, 1307 },
    { PseudoVMAX_VX_M4, 1308 },
    { PseudoVMAX_VX_M8, 1309 },
    { PseudoVMAX_VX_MF2, 1310 },
    { PseudoVMAX_VX_MF4, 1311 },
    { PseudoVMAX_VX_MF8, 1312 },
    { PseudoVMFEQ_VF16_M1, 1313 },
    { PseudoVMFEQ_VF16_M2, 1314 },
    { PseudoVMFEQ_VF16_M4, 1315 },
    { PseudoVMFEQ_VF16_M8, 1316 },
    { PseudoVMFEQ_VF16_MF2, 1317 },
    { PseudoVMFEQ_VF16_MF4, 1318 },
    { PseudoVMFEQ_VF32_M1, 1319 },
    { PseudoVMFEQ_VF32_M2, 1320 },
    { PseudoVMFEQ_VF32_M4, 1321 },
    { PseudoVMFEQ_VF32_M8, 1322 },
    { PseudoVMFEQ_VF32_MF2, 1323 },
    { PseudoVMFEQ_VF64_M1, 1324 },
    { PseudoVMFEQ_VF64_M2, 1325 },
    { PseudoVMFEQ_VF64_M4, 1326 },
    { PseudoVMFEQ_VF64_M8, 1327 },
    { PseudoVMFEQ_VV_M1, 1328 },
    { PseudoVMFEQ_VV_M2, 1329 },
    { PseudoVMFEQ_VV_M4, 1330 },
    { PseudoVMFEQ_VV_M8, 1331 },
    { PseudoVMFEQ_VV_MF2, 1332 },
    { PseudoVMFEQ_VV_MF4, 1333 },
    { PseudoVMFGE_VF16_M1, 1334 },
    { PseudoVMFGE_VF16_M2, 1335 },
    { PseudoVMFGE_VF16_M4, 1336 },
    { PseudoVMFGE_VF16_M8, 1337 },
    { PseudoVMFGE_VF16_MF2, 1338 },
    { PseudoVMFGE_VF16_MF4, 1339 },
    { PseudoVMFGE_VF32_M1, 1340 },
    { PseudoVMFGE_VF32_M2, 1341 },
    { PseudoVMFGE_VF32_M4, 1342 },
    { PseudoVMFGE_VF32_M8, 1343 },
    { PseudoVMFGE_VF32_MF2, 1344 },
    { PseudoVMFGE_VF64_M1, 1345 },
    { PseudoVMFGE_VF64_M2, 1346 },
    { PseudoVMFGE_VF64_M4, 1347 },
    { PseudoVMFGE_VF64_M8, 1348 },
    { PseudoVMFGT_VF16_M1, 1349 },
    { PseudoVMFGT_VF16_M2, 1350 },
    { PseudoVMFGT_VF16_M4, 1351 },
    { PseudoVMFGT_VF16_M8, 1352 },
    { PseudoVMFGT_VF16_MF2, 1353 },
    { PseudoVMFGT_VF16_MF4, 1354 },
    { PseudoVMFGT_VF32_M1, 1355 },
    { PseudoVMFGT_VF32_M2, 1356 },
    { PseudoVMFGT_VF32_M4, 1357 },
    { PseudoVMFGT_VF32_M8, 1358 },
    { PseudoVMFGT_VF32_MF2, 1359 },
    { PseudoVMFGT_VF64_M1, 1360 },
    { PseudoVMFGT_VF64_M2, 1361 },
    { PseudoVMFGT_VF64_M4, 1362 },
    { PseudoVMFGT_VF64_M8, 1363 },
    { PseudoVMFLE_VF16_M1, 1364 },
    { PseudoVMFLE_VF16_M2, 1365 },
    { PseudoVMFLE_VF16_M4, 1366 },
    { PseudoVMFLE_VF16_M8, 1367 },
    { PseudoVMFLE_VF16_MF2, 1368 },
    { PseudoVMFLE_VF16_MF4, 1369 },
    { PseudoVMFLE_VF32_M1, 1370 },
    { PseudoVMFLE_VF32_M2, 1371 },
    { PseudoVMFLE_VF32_M4, 1372 },
    { PseudoVMFLE_VF32_M8, 1373 },
    { PseudoVMFLE_VF32_MF2, 1374 },
    { PseudoVMFLE_VF64_M1, 1375 },
    { PseudoVMFLE_VF64_M2, 1376 },
    { PseudoVMFLE_VF64_M4, 1377 },
    { PseudoVMFLE_VF64_M8, 1378 },
    { PseudoVMFLE_VV_M1, 1379 },
    { PseudoVMFLE_VV_M2, 1380 },
    { PseudoVMFLE_VV_M4, 1381 },
    { PseudoVMFLE_VV_M8, 1382 },
    { PseudoVMFLE_VV_MF2, 1383 },
    { PseudoVMFLE_VV_MF4, 1384 },
    { PseudoVMFLT_VF16_M1, 1385 },
    { PseudoVMFLT_VF16_M2, 1386 },
    { PseudoVMFLT_VF16_M4, 1387 },
    { PseudoVMFLT_VF16_M8, 1388 },
    { PseudoVMFLT_VF16_MF2, 1389 },
    { PseudoVMFLT_VF16_MF4, 1390 },
    { PseudoVMFLT_VF32_M1, 1391 },
    { PseudoVMFLT_VF32_M2, 1392 },
    { PseudoVMFLT_VF32_M4, 1393 },
    { PseudoVMFLT_VF32_M8, 1394 },
    { PseudoVMFLT_VF32_MF2, 1395 },
    { PseudoVMFLT_VF64_M1, 1396 },
    { PseudoVMFLT_VF64_M2, 1397 },
    { PseudoVMFLT_VF64_M4, 1398 },
    { PseudoVMFLT_VF64_M8, 1399 },
    { PseudoVMFLT_VV_M1, 1400 },
    { PseudoVMFLT_VV_M2, 1401 },
    { PseudoVMFLT_VV_M4, 1402 },
    { PseudoVMFLT_VV_M8, 1403 },
    { PseudoVMFLT_VV_MF2, 1404 },
    { PseudoVMFLT_VV_MF4, 1405 },
    { PseudoVMFNE_VF16_M1, 1406 },
    { PseudoVMFNE_VF16_M2, 1407 },
    { PseudoVMFNE_VF16_M4, 1408 },
    { PseudoVMFNE_VF16_M8, 1409 },
    { PseudoVMFNE_VF16_MF2, 1410 },
    { PseudoVMFNE_VF16_MF4, 1411 },
    { PseudoVMFNE_VF32_M1, 1412 },
    { PseudoVMFNE_VF32_M2, 1413 },
    { PseudoVMFNE_VF32_M4, 1414 },
    { PseudoVMFNE_VF32_M8, 1415 },
    { PseudoVMFNE_VF32_MF2, 1416 },
    { PseudoVMFNE_VF64_M1, 1417 },
    { PseudoVMFNE_VF64_M2, 1418 },
    { PseudoVMFNE_VF64_M4, 1419 },
    { PseudoVMFNE_VF64_M8, 1420 },
    { PseudoVMFNE_VV_M1, 1421 },
    { PseudoVMFNE_VV_M2, 1422 },
    { PseudoVMFNE_VV_M4, 1423 },
    { PseudoVMFNE_VV_M8, 1424 },
    { PseudoVMFNE_VV_MF2, 1425 },
    { PseudoVMFNE_VV_MF4, 1426 },
    { PseudoVMINU_VV_M1, 1427 },
    { PseudoVMINU_VV_M2, 1428 },
    { PseudoVMINU_VV_M4, 1429 },
    { PseudoVMINU_VV_M8, 1430 },
    { PseudoVMINU_VV_MF2, 1431 },
    { PseudoVMINU_VV_MF4, 1432 },
    { PseudoVMINU_VV_MF8, 1433 },
    { PseudoVMINU_VX_M1, 1434 },
    { PseudoVMINU_VX_M2, 1435 },
    { PseudoVMINU_VX_M4, 1436 },
    { PseudoVMINU_VX_M8, 1437 },
    { PseudoVMINU_VX_MF2, 1438 },
    { PseudoVMINU_VX_MF4, 1439 },
    { PseudoVMINU_VX_MF8, 1440 },
    { PseudoVMIN_VV_M1, 1441 },
    { PseudoVMIN_VV_M2, 1442 },
    { PseudoVMIN_VV_M4, 1443 },
    { PseudoVMIN_VV_M8, 1444 },
    { PseudoVMIN_VV_MF2, 1445 },
    { PseudoVMIN_VV_MF4, 1446 },
    { PseudoVMIN_VV_MF8, 1447 },
    { PseudoVMIN_VX_M1, 1448 },
    { PseudoVMIN_VX_M2, 1449 },
    { PseudoVMIN_VX_M4, 1450 },
    { PseudoVMIN_VX_M8, 1451 },
    { PseudoVMIN_VX_MF2, 1452 },
    { PseudoVMIN_VX_MF4, 1453 },
    { PseudoVMIN_VX_MF8, 1454 },
    { PseudoVMSEQ_VI_M1, 1455 },
    { PseudoVMSEQ_VI_M2, 1456 },
    { PseudoVMSEQ_VI_M4, 1457 },
    { PseudoVMSEQ_VI_M8, 1458 },
    { PseudoVMSEQ_VI_MF2, 1459 },
    { PseudoVMSEQ_VI_MF4, 1460 },
    { PseudoVMSEQ_VI_MF8, 1461 },
    { PseudoVMSEQ_VV_M1, 1462 },
    { PseudoVMSEQ_VV_M2, 1463 },
    { PseudoVMSEQ_VV_M4, 1464 },
    { PseudoVMSEQ_VV_M8, 1465 },
    { PseudoVMSEQ_VV_MF2, 1466 },
    { PseudoVMSEQ_VV_MF4, 1467 },
    { PseudoVMSEQ_VV_MF8, 1468 },
    { PseudoVMSEQ_VX_M1, 1469 },
    { PseudoVMSEQ_VX_M2, 1470 },
    { PseudoVMSEQ_VX_M4, 1471 },
    { PseudoVMSEQ_VX_M8, 1472 },
    { PseudoVMSEQ_VX_MF2, 1473 },
    { PseudoVMSEQ_VX_MF4, 1474 },
    { PseudoVMSEQ_VX_MF8, 1475 },
    { PseudoVMSGTU_VI_M1, 1476 },
    { PseudoVMSGTU_VI_M2, 1477 },
    { PseudoVMSGTU_VI_M4, 1478 },
    { PseudoVMSGTU_VI_M8, 1479 },
    { PseudoVMSGTU_VI_MF2, 1480 },
    { PseudoVMSGTU_VI_MF4, 1481 },
    { PseudoVMSGTU_VI_MF8, 1482 },
    { PseudoVMSGTU_VX_M1, 1483 },
    { PseudoVMSGTU_VX_M2, 1484 },
    { PseudoVMSGTU_VX_M4, 1485 },
    { PseudoVMSGTU_VX_M8, 1486 },
    { PseudoVMSGTU_VX_MF2, 1487 },
    { PseudoVMSGTU_VX_MF4, 1488 },
    { PseudoVMSGTU_VX_MF8, 1489 },
    { PseudoVMSGT_VI_M1, 1490 },
    { PseudoVMSGT_VI_M2, 1491 },
    { PseudoVMSGT_VI_M4, 1492 },
    { PseudoVMSGT_VI_M8, 1493 },
    { PseudoVMSGT_VI_MF2, 1494 },
    { PseudoVMSGT_VI_MF4, 1495 },
    { PseudoVMSGT_VI_MF8, 1496 },
    { PseudoVMSGT_VX_M1, 1497 },
    { PseudoVMSGT_VX_M2, 1498 },
    { PseudoVMSGT_VX_M4, 1499 },
    { PseudoVMSGT_VX_M8, 1500 },
    { PseudoVMSGT_VX_MF2, 1501 },
    { PseudoVMSGT_VX_MF4, 1502 },
    { PseudoVMSGT_VX_MF8, 1503 },
    { PseudoVMSLEU_VI_M1, 1504 },
    { PseudoVMSLEU_VI_M2, 1505 },
    { PseudoVMSLEU_VI_M4, 1506 },
    { PseudoVMSLEU_VI_M8, 1507 },
    { PseudoVMSLEU_VI_MF2, 1508 },
    { PseudoVMSLEU_VI_MF4, 1509 },
    { PseudoVMSLEU_VI_MF8, 1510 },
    { PseudoVMSLEU_VV_M1, 1511 },
    { PseudoVMSLEU_VV_M2, 1512 },
    { PseudoVMSLEU_VV_M4, 1513 },
    { PseudoVMSLEU_VV_M8, 1514 },
    { PseudoVMSLEU_VV_MF2, 1515 },
    { PseudoVMSLEU_VV_MF4, 1516 },
    { PseudoVMSLEU_VV_MF8, 1517 },
    { PseudoVMSLEU_VX_M1, 1518 },
    { PseudoVMSLEU_VX_M2, 1519 },
    { PseudoVMSLEU_VX_M4, 1520 },
    { PseudoVMSLEU_VX_M8, 1521 },
    { PseudoVMSLEU_VX_MF2, 1522 },
    { PseudoVMSLEU_VX_MF4, 1523 },
    { PseudoVMSLEU_VX_MF8, 1524 },
    { PseudoVMSLE_VI_M1, 1525 },
    { PseudoVMSLE_VI_M2, 1526 },
    { PseudoVMSLE_VI_M4, 1527 },
    { PseudoVMSLE_VI_M8, 1528 },
    { PseudoVMSLE_VI_MF2, 1529 },
    { PseudoVMSLE_VI_MF4, 1530 },
    { PseudoVMSLE_VI_MF8, 1531 },
    { PseudoVMSLE_VV_M1, 1532 },
    { PseudoVMSLE_VV_M2, 1533 },
    { PseudoVMSLE_VV_M4, 1534 },
    { PseudoVMSLE_VV_M8, 1535 },
    { PseudoVMSLE_VV_MF2, 1536 },
    { PseudoVMSLE_VV_MF4, 1537 },
    { PseudoVMSLE_VV_MF8, 1538 },
    { PseudoVMSLE_VX_M1, 1539 },
    { PseudoVMSLE_VX_M2, 1540 },
    { PseudoVMSLE_VX_M4, 1541 },
    { PseudoVMSLE_VX_M8, 1542 },
    { PseudoVMSLE_VX_MF2, 1543 },
    { PseudoVMSLE_VX_MF4, 1544 },
    { PseudoVMSLE_VX_MF8, 1545 },
    { PseudoVMSLTU_VV_M1, 1546 },
    { PseudoVMSLTU_VV_M2, 1547 },
    { PseudoVMSLTU_VV_M4, 1548 },
    { PseudoVMSLTU_VV_M8, 1549 },
    { PseudoVMSLTU_VV_MF2, 1550 },
    { PseudoVMSLTU_VV_MF4, 1551 },
    { PseudoVMSLTU_VV_MF8, 1552 },
    { PseudoVMSLTU_VX_M1, 1553 },
    { PseudoVMSLTU_VX_M2, 1554 },
    { PseudoVMSLTU_VX_M4, 1555 },
    { PseudoVMSLTU_VX_M8, 1556 },
    { PseudoVMSLTU_VX_MF2, 1557 },
    { PseudoVMSLTU_VX_MF4, 1558 },
    { PseudoVMSLTU_VX_MF8, 1559 },
    { PseudoVMSLT_VV_M1, 1560 },
    { PseudoVMSLT_VV_M2, 1561 },
    { PseudoVMSLT_VV_M4, 1562 },
    { PseudoVMSLT_VV_M8, 1563 },
    { PseudoVMSLT_VV_MF2, 1564 },
    { PseudoVMSLT_VV_MF4, 1565 },
    { PseudoVMSLT_VV_MF8, 1566 },
    { PseudoVMSLT_VX_M1, 1567 },
    { PseudoVMSLT_VX_M2, 1568 },
    { PseudoVMSLT_VX_M4, 1569 },
    { PseudoVMSLT_VX_M8, 1570 },
    { PseudoVMSLT_VX_MF2, 1571 },
    { PseudoVMSLT_VX_MF4, 1572 },
    { PseudoVMSLT_VX_MF8, 1573 },
    { PseudoVMSNE_VI_M1, 1574 },
    { PseudoVMSNE_VI_M2, 1575 },
    { PseudoVMSNE_VI_M4, 1576 },
    { PseudoVMSNE_VI_M8, 1577 },
    { PseudoVMSNE_VI_MF2, 1578 },
    { PseudoVMSNE_VI_MF4, 1579 },
    { PseudoVMSNE_VI_MF8, 1580 },
    { PseudoVMSNE_VV_M1, 1581 },
    { PseudoVMSNE_VV_M2, 1582 },
    { PseudoVMSNE_VV_M4, 1583 },
    { PseudoVMSNE_VV_M8, 1584 },
    { PseudoVMSNE_VV_MF2, 1585 },
    { PseudoVMSNE_VV_MF4, 1586 },
    { PseudoVMSNE_VV_MF8, 1587 },
    { PseudoVMSNE_VX_M1, 1588 },
    { PseudoVMSNE_VX_M2, 1589 },
    { PseudoVMSNE_VX_M4, 1590 },
    { PseudoVMSNE_VX_M8, 1591 },
    { PseudoVMSNE_VX_MF2, 1592 },
    { PseudoVMSNE_VX_MF4, 1593 },
    { PseudoVMSNE_VX_MF8, 1594 },
    { PseudoVMULHSU_VV_M1, 1595 },
    { PseudoVMULHSU_VV_M2, 1596 },
    { PseudoVMULHSU_VV_M4, 1597 },
    { PseudoVMULHSU_VV_M8, 1598 },
    { PseudoVMULHSU_VV_MF2, 1599 },
    { PseudoVMULHSU_VV_MF4, 1600 },
    { PseudoVMULHSU_VV_MF8, 1601 },
    { PseudoVMULHSU_VX_M1, 1602 },
    { PseudoVMULHSU_VX_M2, 1603 },
    { PseudoVMULHSU_VX_M4, 1604 },
    { PseudoVMULHSU_VX_M8, 1605 },
    { PseudoVMULHSU_VX_MF2, 1606 },
    { PseudoVMULHSU_VX_MF4, 1607 },
    { PseudoVMULHSU_VX_MF8, 1608 },
    { PseudoVMULHU_VV_M1, 1609 },
    { PseudoVMULHU_VV_M2, 1610 },
    { PseudoVMULHU_VV_M4, 1611 },
    { PseudoVMULHU_VV_M8, 1612 },
    { PseudoVMULHU_VV_MF2, 1613 },
    { PseudoVMULHU_VV_MF4, 1614 },
    { PseudoVMULHU_VV_MF8, 1615 },
    { PseudoVMULHU_VX_M1, 1616 },
    { PseudoVMULHU_VX_M2, 1617 },
    { PseudoVMULHU_VX_M4, 1618 },
    { PseudoVMULHU_VX_M8, 1619 },
    { PseudoVMULHU_VX_MF2, 1620 },
    { PseudoVMULHU_VX_MF4, 1621 },
    { PseudoVMULHU_VX_MF8, 1622 },
    { PseudoVMULH_VV_M1, 1623 },
    { PseudoVMULH_VV_M2, 1624 },
    { PseudoVMULH_VV_M4, 1625 },
    { PseudoVMULH_VV_M8, 1626 },
    { PseudoVMULH_VV_MF2, 1627 },
    { PseudoVMULH_VV_MF4, 1628 },
    { PseudoVMULH_VV_MF8, 1629 },
    { PseudoVMULH_VX_M1, 1630 },
    { PseudoVMULH_VX_M2, 1631 },
    { PseudoVMULH_VX_M4, 1632 },
    { PseudoVMULH_VX_M8, 1633 },
    { PseudoVMULH_VX_MF2, 1634 },
    { PseudoVMULH_VX_MF4, 1635 },
    { PseudoVMULH_VX_MF8, 1636 },
    { PseudoVMUL_VV_M1, 1637 },
    { PseudoVMUL_VV_M2, 1638 },
    { PseudoVMUL_VV_M4, 1639 },
    { PseudoVMUL_VV_M8, 1640 },
    { PseudoVMUL_VV_MF2, 1641 },
    { PseudoVMUL_VV_MF4, 1642 },
    { PseudoVMUL_VV_MF8, 1643 },
    { PseudoVMUL_VX_M1, 1644 },
    { PseudoVMUL_VX_M2, 1645 },
    { PseudoVMUL_VX_M4, 1646 },
    { PseudoVMUL_VX_M8, 1647 },
    { PseudoVMUL_VX_MF2, 1648 },
    { PseudoVMUL_VX_MF4, 1649 },
    { PseudoVMUL_VX_MF8, 1650 },
    { PseudoVNCLIPU_WI_M1, 1651 },
    { PseudoVNCLIPU_WI_M2, 1652 },
    { PseudoVNCLIPU_WI_M4, 1653 },
    { PseudoVNCLIPU_WI_MF2, 1654 },
    { PseudoVNCLIPU_WI_MF4, 1655 },
    { PseudoVNCLIPU_WI_MF8, 1656 },
    { PseudoVNCLIPU_WV_M1, 1657 },
    { PseudoVNCLIPU_WV_M2, 1658 },
    { PseudoVNCLIPU_WV_M4, 1659 },
    { PseudoVNCLIPU_WV_MF2, 1660 },
    { PseudoVNCLIPU_WV_MF4, 1661 },
    { PseudoVNCLIPU_WV_MF8, 1662 },
    { PseudoVNCLIPU_WX_M1, 1663 },
    { PseudoVNCLIPU_WX_M2, 1664 },
    { PseudoVNCLIPU_WX_M4, 1665 },
    { PseudoVNCLIPU_WX_MF2, 1666 },
    { PseudoVNCLIPU_WX_MF4, 1667 },
    { PseudoVNCLIPU_WX_MF8, 1668 },
    { PseudoVNCLIP_WI_M1, 1669 },
    { PseudoVNCLIP_WI_M2, 1670 },
    { PseudoVNCLIP_WI_M4, 1671 },
    { PseudoVNCLIP_WI_MF2, 1672 },
    { PseudoVNCLIP_WI_MF4, 1673 },
    { PseudoVNCLIP_WI_MF8, 1674 },
    { PseudoVNCLIP_WV_M1, 1675 },
    { PseudoVNCLIP_WV_M2, 1676 },
    { PseudoVNCLIP_WV_M4, 1677 },
    { PseudoVNCLIP_WV_MF2, 1678 },
    { PseudoVNCLIP_WV_MF4, 1679 },
    { PseudoVNCLIP_WV_MF8, 1680 },
    { PseudoVNCLIP_WX_M1, 1681 },
    { PseudoVNCLIP_WX_M2, 1682 },
    { PseudoVNCLIP_WX_M4, 1683 },
    { PseudoVNCLIP_WX_MF2, 1684 },
    { PseudoVNCLIP_WX_MF4, 1685 },
    { PseudoVNCLIP_WX_MF8, 1686 },
    { PseudoVNMSAC_VV_M1, 1687 },
    { PseudoVNMSAC_VV_M2, 1688 },
    { PseudoVNMSAC_VV_M4, 1689 },
    { PseudoVNMSAC_VV_M8, 1690 },
    { PseudoVNMSAC_VV_MF2, 1691 },
    { PseudoVNMSAC_VV_MF4, 1692 },
    { PseudoVNMSAC_VV_MF8, 1693 },
    { PseudoVNMSAC_VX_M1, 1694 },
    { PseudoVNMSAC_VX_M2, 1695 },
    { PseudoVNMSAC_VX_M4, 1696 },
    { PseudoVNMSAC_VX_M8, 1697 },
    { PseudoVNMSAC_VX_MF2, 1698 },
    { PseudoVNMSAC_VX_MF4, 1699 },
    { PseudoVNMSAC_VX_MF8, 1700 },
    { PseudoVNMSUB_VV_M1, 1701 },
    { PseudoVNMSUB_VV_M2, 1702 },
    { PseudoVNMSUB_VV_M4, 1703 },
    { PseudoVNMSUB_VV_M8, 1704 },
    { PseudoVNMSUB_VV_MF2, 1705 },
    { PseudoVNMSUB_VV_MF4, 1706 },
    { PseudoVNMSUB_VV_MF8, 1707 },
    { PseudoVNMSUB_VX_M1, 1708 },
    { PseudoVNMSUB_VX_M2, 1709 },
    { PseudoVNMSUB_VX_M4, 1710 },
    { PseudoVNMSUB_VX_M8, 1711 },
    { PseudoVNMSUB_VX_MF2, 1712 },
    { PseudoVNMSUB_VX_MF4, 1713 },
    { PseudoVNMSUB_VX_MF8, 1714 },
    { PseudoVNSRA_WI_M1, 1715 },
    { PseudoVNSRA_WI_M2, 1716 },
    { PseudoVNSRA_WI_M4, 1717 },
    { PseudoVNSRA_WI_MF2, 1718 },
    { PseudoVNSRA_WI_MF4, 1719 },
    { PseudoVNSRA_WI_MF8, 1720 },
    { PseudoVNSRA_WV_M1, 1721 },
    { PseudoVNSRA_WV_M2, 1722 },
    { PseudoVNSRA_WV_M4, 1723 },
    { PseudoVNSRA_WV_MF2, 1724 },
    { PseudoVNSRA_WV_MF4, 1725 },
    { PseudoVNSRA_WV_MF8, 1726 },
    { PseudoVNSRA_WX_M1, 1727 },
    { PseudoVNSRA_WX_M2, 1728 },
    { PseudoVNSRA_WX_M4, 1729 },
    { PseudoVNSRA_WX_MF2, 1730 },
    { PseudoVNSRA_WX_MF4, 1731 },
    { PseudoVNSRA_WX_MF8, 1732 },
    { PseudoVNSRL_WI_M1, 1733 },
    { PseudoVNSRL_WI_M2, 1734 },
    { PseudoVNSRL_WI_M4, 1735 },
    { PseudoVNSRL_WI_MF2, 1736 },
    { PseudoVNSRL_WI_MF4, 1737 },
    { PseudoVNSRL_WI_MF8, 1738 },
    { PseudoVNSRL_WV_M1, 1739 },
    { PseudoVNSRL_WV_M2, 1740 },
    { PseudoVNSRL_WV_M4, 1741 },
    { PseudoVNSRL_WV_MF2, 1742 },
    { PseudoVNSRL_WV_MF4, 1743 },
    { PseudoVNSRL_WV_MF8, 1744 },
    { PseudoVNSRL_WX_M1, 1745 },
    { PseudoVNSRL_WX_M2, 1746 },
    { PseudoVNSRL_WX_M4, 1747 },
    { PseudoVNSRL_WX_MF2, 1748 },
    { PseudoVNSRL_WX_MF4, 1749 },
    { PseudoVNSRL_WX_MF8, 1750 },
    { PseudoVOR_VI_M1, 1751 },
    { PseudoVOR_VI_M2, 1752 },
    { PseudoVOR_VI_M4, 1753 },
    { PseudoVOR_VI_M8, 1754 },
    { PseudoVOR_VI_MF2, 1755 },
    { PseudoVOR_VI_MF4, 1756 },
    { PseudoVOR_VI_MF8, 1757 },
    { PseudoVOR_VV_M1, 1758 },
    { PseudoVOR_VV_M2, 1759 },
    { PseudoVOR_VV_M4, 1760 },
    { PseudoVOR_VV_M8, 1761 },
    { PseudoVOR_VV_MF2, 1762 },
    { PseudoVOR_VV_MF4, 1763 },
    { PseudoVOR_VV_MF8, 1764 },
    { PseudoVOR_VX_M1, 1765 },
    { PseudoVOR_VX_M2, 1766 },
    { PseudoVOR_VX_M4, 1767 },
    { PseudoVOR_VX_M8, 1768 },
    { PseudoVOR_VX_MF2, 1769 },
    { PseudoVOR_VX_MF4, 1770 },
    { PseudoVOR_VX_MF8, 1771 },
    { PseudoVREMU_VV_M1_E16, 1772 },
    { PseudoVREMU_VV_M1_E32, 1773 },
    { PseudoVREMU_VV_M1_E64, 1774 },
    { PseudoVREMU_VV_M1_E8, 1775 },
    { PseudoVREMU_VV_M2_E16, 1776 },
    { PseudoVREMU_VV_M2_E32, 1777 },
    { PseudoVREMU_VV_M2_E64, 1778 },
    { PseudoVREMU_VV_M2_E8, 1779 },
    { PseudoVREMU_VV_M4_E16, 1780 },
    { PseudoVREMU_VV_M4_E32, 1781 },
    { PseudoVREMU_VV_M4_E64, 1782 },
    { PseudoVREMU_VV_M4_E8, 1783 },
    { PseudoVREMU_VV_M8_E16, 1784 },
    { PseudoVREMU_VV_M8_E32, 1785 },
    { PseudoVREMU_VV_M8_E64, 1786 },
    { PseudoVREMU_VV_M8_E8, 1787 },
    { PseudoVREMU_VV_MF2_E16, 1788 },
    { PseudoVREMU_VV_MF2_E32, 1789 },
    { PseudoVREMU_VV_MF2_E8, 1790 },
    { PseudoVREMU_VV_MF4_E16, 1791 },
    { PseudoVREMU_VV_MF4_E8, 1792 },
    { PseudoVREMU_VV_MF8_E8, 1793 },
    { PseudoVREMU_VX_M1_E16, 1794 },
    { PseudoVREMU_VX_M1_E32, 1795 },
    { PseudoVREMU_VX_M1_E64, 1796 },
    { PseudoVREMU_VX_M1_E8, 1797 },
    { PseudoVREMU_VX_M2_E16, 1798 },
    { PseudoVREMU_VX_M2_E32, 1799 },
    { PseudoVREMU_VX_M2_E64, 1800 },
    { PseudoVREMU_VX_M2_E8, 1801 },
    { PseudoVREMU_VX_M4_E16, 1802 },
    { PseudoVREMU_VX_M4_E32, 1803 },
    { PseudoVREMU_VX_M4_E64, 1804 },
    { PseudoVREMU_VX_M4_E8, 1805 },
    { PseudoVREMU_VX_M8_E16, 1806 },
    { PseudoVREMU_VX_M8_E32, 1807 },
    { PseudoVREMU_VX_M8_E64, 1808 },
    { PseudoVREMU_VX_M8_E8, 1809 },
    { PseudoVREMU_VX_MF2_E16, 1810 },
    { PseudoVREMU_VX_MF2_E32, 1811 },
    { PseudoVREMU_VX_MF2_E8, 1812 },
    { PseudoVREMU_VX_MF4_E16, 1813 },
    { PseudoVREMU_VX_MF4_E8, 1814 },
    { PseudoVREMU_VX_MF8_E8, 1815 },
    { PseudoVREM_VV_M1_E16, 1816 },
    { PseudoVREM_VV_M1_E32, 1817 },
    { PseudoVREM_VV_M1_E64, 1818 },
    { PseudoVREM_VV_M1_E8, 1819 },
    { PseudoVREM_VV_M2_E16, 1820 },
    { PseudoVREM_VV_M2_E32, 1821 },
    { PseudoVREM_VV_M2_E64, 1822 },
    { PseudoVREM_VV_M2_E8, 1823 },
    { PseudoVREM_VV_M4_E16, 1824 },
    { PseudoVREM_VV_M4_E32, 1825 },
    { PseudoVREM_VV_M4_E64, 1826 },
    { PseudoVREM_VV_M4_E8, 1827 },
    { PseudoVREM_VV_M8_E16, 1828 },
    { PseudoVREM_VV_M8_E32, 1829 },
    { PseudoVREM_VV_M8_E64, 1830 },
    { PseudoVREM_VV_M8_E8, 1831 },
    { PseudoVREM_VV_MF2_E16, 1832 },
    { PseudoVREM_VV_MF2_E32, 1833 },
    { PseudoVREM_VV_MF2_E8, 1834 },
    { PseudoVREM_VV_MF4_E16, 1835 },
    { PseudoVREM_VV_MF4_E8, 1836 },
    { PseudoVREM_VV_MF8_E8, 1837 },
    { PseudoVREM_VX_M1_E16, 1838 },
    { PseudoVREM_VX_M1_E32, 1839 },
    { PseudoVREM_VX_M1_E64, 1840 },
    { PseudoVREM_VX_M1_E8, 1841 },
    { PseudoVREM_VX_M2_E16, 1842 },
    { PseudoVREM_VX_M2_E32, 1843 },
    { PseudoVREM_VX_M2_E64, 1844 },
    { PseudoVREM_VX_M2_E8, 1845 },
    { PseudoVREM_VX_M4_E16, 1846 },
    { PseudoVREM_VX_M4_E32, 1847 },
    { PseudoVREM_VX_M4_E64, 1848 },
    { PseudoVREM_VX_M4_E8, 1849 },
    { PseudoVREM_VX_M8_E16, 1850 },
    { PseudoVREM_VX_M8_E32, 1851 },
    { PseudoVREM_VX_M8_E64, 1852 },
    { PseudoVREM_VX_M8_E8, 1853 },
    { PseudoVREM_VX_MF2_E16, 1854 },
    { PseudoVREM_VX_MF2_E32, 1855 },
    { PseudoVREM_VX_MF2_E8, 1856 },
    { PseudoVREM_VX_MF4_E16, 1857 },
    { PseudoVREM_VX_MF4_E8, 1858 },
    { PseudoVREM_VX_MF8_E8, 1859 },
    { PseudoVREV8_V_M1, 1860 },
    { PseudoVREV8_V_M2, 1861 },
    { PseudoVREV8_V_M4, 1862 },
    { PseudoVREV8_V_M8, 1863 },
    { PseudoVREV8_V_MF2, 1864 },
    { PseudoVREV8_V_MF4, 1865 },
    { PseudoVREV8_V_MF8, 1866 },
    { PseudoVRGATHEREI16_VV_M1_E16_M1, 1867 },
    { PseudoVRGATHEREI16_VV_M1_E16_M2, 1868 },
    { PseudoVRGATHEREI16_VV_M1_E16_MF2, 1869 },
    { PseudoVRGATHEREI16_VV_M1_E16_MF4, 1870 },
    { PseudoVRGATHEREI16_VV_M1_E32_M1, 1871 },
    { PseudoVRGATHEREI16_VV_M1_E32_M2, 1872 },
    { PseudoVRGATHEREI16_VV_M1_E32_MF2, 1873 },
    { PseudoVRGATHEREI16_VV_M1_E32_MF4, 1874 },
    { PseudoVRGATHEREI16_VV_M1_E64_M1, 1875 },
    { PseudoVRGATHEREI16_VV_M1_E64_M2, 1876 },
    { PseudoVRGATHEREI16_VV_M1_E64_MF2, 1877 },
    { PseudoVRGATHEREI16_VV_M1_E64_MF4, 1878 },
    { PseudoVRGATHEREI16_VV_M1_E8_M1, 1879 },
    { PseudoVRGATHEREI16_VV_M1_E8_M2, 1880 },
    { PseudoVRGATHEREI16_VV_M1_E8_MF2, 1881 },
    { PseudoVRGATHEREI16_VV_M1_E8_MF4, 1882 },
    { PseudoVRGATHEREI16_VV_M2_E16_M1, 1883 },
    { PseudoVRGATHEREI16_VV_M2_E16_M2, 1884 },
    { PseudoVRGATHEREI16_VV_M2_E16_M4, 1885 },
    { PseudoVRGATHEREI16_VV_M2_E16_MF2, 1886 },
    { PseudoVRGATHEREI16_VV_M2_E32_M1, 1887 },
    { PseudoVRGATHEREI16_VV_M2_E32_M2, 1888 },
    { PseudoVRGATHEREI16_VV_M2_E32_M4, 1889 },
    { PseudoVRGATHEREI16_VV_M2_E32_MF2, 1890 },
    { PseudoVRGATHEREI16_VV_M2_E64_M1, 1891 },
    { PseudoVRGATHEREI16_VV_M2_E64_M2, 1892 },
    { PseudoVRGATHEREI16_VV_M2_E64_M4, 1893 },
    { PseudoVRGATHEREI16_VV_M2_E64_MF2, 1894 },
    { PseudoVRGATHEREI16_VV_M2_E8_M1, 1895 },
    { PseudoVRGATHEREI16_VV_M2_E8_M2, 1896 },
    { PseudoVRGATHEREI16_VV_M2_E8_M4, 1897 },
    { PseudoVRGATHEREI16_VV_M2_E8_MF2, 1898 },
    { PseudoVRGATHEREI16_VV_M4_E16_M1, 1899 },
    { PseudoVRGATHEREI16_VV_M4_E16_M2, 1900 },
    { PseudoVRGATHEREI16_VV_M4_E16_M4, 1901 },
    { PseudoVRGATHEREI16_VV_M4_E16_M8, 1902 },
    { PseudoVRGATHEREI16_VV_M4_E32_M1, 1903 },
    { PseudoVRGATHEREI16_VV_M4_E32_M2, 1904 },
    { PseudoVRGATHEREI16_VV_M4_E32_M4, 1905 },
    { PseudoVRGATHEREI16_VV_M4_E32_M8, 1906 },
    { PseudoVRGATHEREI16_VV_M4_E64_M1, 1907 },
    { PseudoVRGATHEREI16_VV_M4_E64_M2, 1908 },
    { PseudoVRGATHEREI16_VV_M4_E64_M4, 1909 },
    { PseudoVRGATHEREI16_VV_M4_E64_M8, 1910 },
    { PseudoVRGATHEREI16_VV_M4_E8_M1, 1911 },
    { PseudoVRGATHEREI16_VV_M4_E8_M2, 1912 },
    { PseudoVRGATHEREI16_VV_M4_E8_M4, 1913 },
    { PseudoVRGATHEREI16_VV_M4_E8_M8, 1914 },
    { PseudoVRGATHEREI16_VV_M8_E16_M2, 1915 },
    { PseudoVRGATHEREI16_VV_M8_E16_M4, 1916 },
    { PseudoVRGATHEREI16_VV_M8_E16_M8, 1917 },
    { PseudoVRGATHEREI16_VV_M8_E32_M2, 1918 },
    { PseudoVRGATHEREI16_VV_M8_E32_M4, 1919 },
    { PseudoVRGATHEREI16_VV_M8_E32_M8, 1920 },
    { PseudoVRGATHEREI16_VV_M8_E64_M2, 1921 },
    { PseudoVRGATHEREI16_VV_M8_E64_M4, 1922 },
    { PseudoVRGATHEREI16_VV_M8_E64_M8, 1923 },
    { PseudoVRGATHEREI16_VV_M8_E8_M2, 1924 },
    { PseudoVRGATHEREI16_VV_M8_E8_M4, 1925 },
    { PseudoVRGATHEREI16_VV_M8_E8_M8, 1926 },
    { PseudoVRGATHEREI16_VV_MF2_E16_M1, 1927 },
    { PseudoVRGATHEREI16_VV_MF2_E16_MF2, 1928 },
    { PseudoVRGATHEREI16_VV_MF2_E16_MF4, 1929 },
    { PseudoVRGATHEREI16_VV_MF2_E16_MF8, 1930 },
    { PseudoVRGATHEREI16_VV_MF2_E32_M1, 1931 },
    { PseudoVRGATHEREI16_VV_MF2_E32_MF2, 1932 },
    { PseudoVRGATHEREI16_VV_MF2_E32_MF4, 1933 },
    { PseudoVRGATHEREI16_VV_MF2_E32_MF8, 1934 },
    { PseudoVRGATHEREI16_VV_MF2_E8_M1, 1935 },
    { PseudoVRGATHEREI16_VV_MF2_E8_MF2, 1936 },
    { PseudoVRGATHEREI16_VV_MF2_E8_MF4, 1937 },
    { PseudoVRGATHEREI16_VV_MF2_E8_MF8, 1938 },
    { PseudoVRGATHEREI16_VV_MF4_E16_MF2, 1939 },
    { PseudoVRGATHEREI16_VV_MF4_E16_MF4, 1940 },
    { PseudoVRGATHEREI16_VV_MF4_E16_MF8, 1941 },
    { PseudoVRGATHEREI16_VV_MF4_E8_MF2, 1942 },
    { PseudoVRGATHEREI16_VV_MF4_E8_MF4, 1943 },
    { PseudoVRGATHEREI16_VV_MF4_E8_MF8, 1944 },
    { PseudoVRGATHEREI16_VV_MF8_E8_MF4, 1945 },
    { PseudoVRGATHEREI16_VV_MF8_E8_MF8, 1946 },
    { PseudoVRGATHER_VI_M1, 1947 },
    { PseudoVRGATHER_VI_M2, 1948 },
    { PseudoVRGATHER_VI_M4, 1949 },
    { PseudoVRGATHER_VI_M8, 1950 },
    { PseudoVRGATHER_VI_MF2, 1951 },
    { PseudoVRGATHER_VI_MF4, 1952 },
    { PseudoVRGATHER_VI_MF8, 1953 },
    { PseudoVRGATHER_VV_M1_E16, 1954 },
    { PseudoVRGATHER_VV_M1_E32, 1955 },
    { PseudoVRGATHER_VV_M1_E64, 1956 },
    { PseudoVRGATHER_VV_M1_E8, 1957 },
    { PseudoVRGATHER_VV_M2_E16, 1958 },
    { PseudoVRGATHER_VV_M2_E32, 1959 },
    { PseudoVRGATHER_VV_M2_E64, 1960 },
    { PseudoVRGATHER_VV_M2_E8, 1961 },
    { PseudoVRGATHER_VV_M4_E16, 1962 },
    { PseudoVRGATHER_VV_M4_E32, 1963 },
    { PseudoVRGATHER_VV_M4_E64, 1964 },
    { PseudoVRGATHER_VV_M4_E8, 1965 },
    { PseudoVRGATHER_VV_M8_E16, 1966 },
    { PseudoVRGATHER_VV_M8_E32, 1967 },
    { PseudoVRGATHER_VV_M8_E64, 1968 },
    { PseudoVRGATHER_VV_M8_E8, 1969 },
    { PseudoVRGATHER_VV_MF2_E16, 1970 },
    { PseudoVRGATHER_VV_MF2_E32, 1971 },
    { PseudoVRGATHER_VV_MF2_E8, 1972 },
    { PseudoVRGATHER_VV_MF4_E16, 1973 },
    { PseudoVRGATHER_VV_MF4_E8, 1974 },
    { PseudoVRGATHER_VV_MF8_E8, 1975 },
    { PseudoVRGATHER_VX_M1, 1976 },
    { PseudoVRGATHER_VX_M2, 1977 },
    { PseudoVRGATHER_VX_M4, 1978 },
    { PseudoVRGATHER_VX_M8, 1979 },
    { PseudoVRGATHER_VX_MF2, 1980 },
    { PseudoVRGATHER_VX_MF4, 1981 },
    { PseudoVRGATHER_VX_MF8, 1982 },
    { PseudoVROL_VV_M1, 1983 },
    { PseudoVROL_VV_M2, 1984 },
    { PseudoVROL_VV_M4, 1985 },
    { PseudoVROL_VV_M8, 1986 },
    { PseudoVROL_VV_MF2, 1987 },
    { PseudoVROL_VV_MF4, 1988 },
    { PseudoVROL_VV_MF8, 1989 },
    { PseudoVROL_VX_M1, 1990 },
    { PseudoVROL_VX_M2, 1991 },
    { PseudoVROL_VX_M4, 1992 },
    { PseudoVROL_VX_M8, 1993 },
    { PseudoVROL_VX_MF2, 1994 },
    { PseudoVROL_VX_MF4, 1995 },
    { PseudoVROL_VX_MF8, 1996 },
    { PseudoVROR_VI_M1, 1997 },
    { PseudoVROR_VI_M2, 1998 },
    { PseudoVROR_VI_M4, 1999 },
    { PseudoVROR_VI_M8, 2000 },
    { PseudoVROR_VI_MF2, 2001 },
    { PseudoVROR_VI_MF4, 2002 },
    { PseudoVROR_VI_MF8, 2003 },
    { PseudoVROR_VV_M1, 2004 },
    { PseudoVROR_VV_M2, 2005 },
    { PseudoVROR_VV_M4, 2006 },
    { PseudoVROR_VV_M8, 2007 },
    { PseudoVROR_VV_MF2, 2008 },
    { PseudoVROR_VV_MF4, 2009 },
    { PseudoVROR_VV_MF8, 2010 },
    { PseudoVROR_VX_M1, 2011 },
    { PseudoVROR_VX_M2, 2012 },
    { PseudoVROR_VX_M4, 2013 },
    { PseudoVROR_VX_M8, 2014 },
    { PseudoVROR_VX_MF2, 2015 },
    { PseudoVROR_VX_MF4, 2016 },
    { PseudoVROR_VX_MF8, 2017 },
    { PseudoVRSUB_VI_M1, 2018 },
    { PseudoVRSUB_VI_M2, 2019 },
    { PseudoVRSUB_VI_M4, 2020 },
    { PseudoVRSUB_VI_M8, 2021 },
    { PseudoVRSUB_VI_MF2, 2022 },
    { PseudoVRSUB_VI_MF4, 2023 },
    { PseudoVRSUB_VI_MF8, 2024 },
    { PseudoVRSUB_VX_M1, 2025 },
    { PseudoVRSUB_VX_M2, 2026 },
    { PseudoVRSUB_VX_M4, 2027 },
    { PseudoVRSUB_VX_M8, 2028 },
    { PseudoVRSUB_VX_MF2, 2029 },
    { PseudoVRSUB_VX_MF4, 2030 },
    { PseudoVRSUB_VX_MF8, 2031 },
    { PseudoVSADDU_VI_M1, 2032 },
    { PseudoVSADDU_VI_M2, 2033 },
    { PseudoVSADDU_VI_M4, 2034 },
    { PseudoVSADDU_VI_M8, 2035 },
    { PseudoVSADDU_VI_MF2, 2036 },
    { PseudoVSADDU_VI_MF4, 2037 },
    { PseudoVSADDU_VI_MF8, 2038 },
    { PseudoVSADDU_VV_M1, 2039 },
    { PseudoVSADDU_VV_M2, 2040 },
    { PseudoVSADDU_VV_M4, 2041 },
    { PseudoVSADDU_VV_M8, 2042 },
    { PseudoVSADDU_VV_MF2, 2043 },
    { PseudoVSADDU_VV_MF4, 2044 },
    { PseudoVSADDU_VV_MF8, 2045 },
    { PseudoVSADDU_VX_M1, 2046 },
    { PseudoVSADDU_VX_M2, 2047 },
    { PseudoVSADDU_VX_M4, 2048 },
    { PseudoVSADDU_VX_M8, 2049 },
    { PseudoVSADDU_VX_MF2, 2050 },
    { PseudoVSADDU_VX_MF4, 2051 },
    { PseudoVSADDU_VX_MF8, 2052 },
    { PseudoVSADD_VI_M1, 2053 },
    { PseudoVSADD_VI_M2, 2054 },
    { PseudoVSADD_VI_M4, 2055 },
    { PseudoVSADD_VI_M8, 2056 },
    { PseudoVSADD_VI_MF2, 2057 },
    { PseudoVSADD_VI_MF4, 2058 },
    { PseudoVSADD_VI_MF8, 2059 },
    { PseudoVSADD_VV_M1, 2060 },
    { PseudoVSADD_VV_M2, 2061 },
    { PseudoVSADD_VV_M4, 2062 },
    { PseudoVSADD_VV_M8, 2063 },
    { PseudoVSADD_VV_MF2, 2064 },
    { PseudoVSADD_VV_MF4, 2065 },
    { PseudoVSADD_VV_MF8, 2066 },
    { PseudoVSADD_VX_M1, 2067 },
    { PseudoVSADD_VX_M2, 2068 },
    { PseudoVSADD_VX_M4, 2069 },
    { PseudoVSADD_VX_M8, 2070 },
    { PseudoVSADD_VX_MF2, 2071 },
    { PseudoVSADD_VX_MF4, 2072 },
    { PseudoVSADD_VX_MF8, 2073 },
    { PseudoVSEXT_VF2_M1, 2074 },
    { PseudoVSEXT_VF2_M2, 2075 },
    { PseudoVSEXT_VF2_M4, 2076 },
    { PseudoVSEXT_VF2_M8, 2077 },
    { PseudoVSEXT_VF2_MF2, 2078 },
    { PseudoVSEXT_VF2_MF4, 2079 },
    { PseudoVSEXT_VF4_M1, 2080 },
    { PseudoVSEXT_VF4_M2, 2081 },
    { PseudoVSEXT_VF4_M4, 2082 },
    { PseudoVSEXT_VF4_M8, 2083 },
    { PseudoVSEXT_VF4_MF2, 2084 },
    { PseudoVSEXT_VF8_M1, 2085 },
    { PseudoVSEXT_VF8_M2, 2086 },
    { PseudoVSEXT_VF8_M4, 2087 },
    { PseudoVSEXT_VF8_M8, 2088 },
    { PseudoVSLIDE1DOWN_VX_M1, 2089 },
    { PseudoVSLIDE1DOWN_VX_M2, 2090 },
    { PseudoVSLIDE1DOWN_VX_M4, 2091 },
    { PseudoVSLIDE1DOWN_VX_M8, 2092 },
    { PseudoVSLIDE1DOWN_VX_MF2, 2093 },
    { PseudoVSLIDE1DOWN_VX_MF4, 2094 },
    { PseudoVSLIDE1DOWN_VX_MF8, 2095 },
    { PseudoVSLIDE1UP_VX_M1, 2096 },
    { PseudoVSLIDE1UP_VX_M2, 2097 },
    { PseudoVSLIDE1UP_VX_M4, 2098 },
    { PseudoVSLIDE1UP_VX_M8, 2099 },
    { PseudoVSLIDE1UP_VX_MF2, 2100 },
    { PseudoVSLIDE1UP_VX_MF4, 2101 },
    { PseudoVSLIDE1UP_VX_MF8, 2102 },
    { PseudoVSLIDEDOWN_VI_M1, 2103 },
    { PseudoVSLIDEDOWN_VI_M2, 2104 },
    { PseudoVSLIDEDOWN_VI_M4, 2105 },
    { PseudoVSLIDEDOWN_VI_M8, 2106 },
    { PseudoVSLIDEDOWN_VI_MF2, 2107 },
    { PseudoVSLIDEDOWN_VI_MF4, 2108 },
    { PseudoVSLIDEDOWN_VI_MF8, 2109 },
    { PseudoVSLIDEDOWN_VX_M1, 2110 },
    { PseudoVSLIDEDOWN_VX_M2, 2111 },
    { PseudoVSLIDEDOWN_VX_M4, 2112 },
    { PseudoVSLIDEDOWN_VX_M8, 2113 },
    { PseudoVSLIDEDOWN_VX_MF2, 2114 },
    { PseudoVSLIDEDOWN_VX_MF4, 2115 },
    { PseudoVSLIDEDOWN_VX_MF8, 2116 },
    { PseudoVSLIDEUP_VI_M1, 2117 },
    { PseudoVSLIDEUP_VI_M2, 2118 },
    { PseudoVSLIDEUP_VI_M4, 2119 },
    { PseudoVSLIDEUP_VI_M8, 2120 },
    { PseudoVSLIDEUP_VI_MF2, 2121 },
    { PseudoVSLIDEUP_VI_MF4, 2122 },
    { PseudoVSLIDEUP_VI_MF8, 2123 },
    { PseudoVSLIDEUP_VX_M1, 2124 },
    { PseudoVSLIDEUP_VX_M2, 2125 },
    { PseudoVSLIDEUP_VX_M4, 2126 },
    { PseudoVSLIDEUP_VX_M8, 2127 },
    { PseudoVSLIDEUP_VX_MF2, 2128 },
    { PseudoVSLIDEUP_VX_MF4, 2129 },
    { PseudoVSLIDEUP_VX_MF8, 2130 },
    { PseudoVSLL_VI_M1, 2131 },
    { PseudoVSLL_VI_M2, 2132 },
    { PseudoVSLL_VI_M4, 2133 },
    { PseudoVSLL_VI_M8, 2134 },
    { PseudoVSLL_VI_MF2, 2135 },
    { PseudoVSLL_VI_MF4, 2136 },
    { PseudoVSLL_VI_MF8, 2137 },
    { PseudoVSLL_VV_M1, 2138 },
    { PseudoVSLL_VV_M2, 2139 },
    { PseudoVSLL_VV_M4, 2140 },
    { PseudoVSLL_VV_M8, 2141 },
    { PseudoVSLL_VV_MF2, 2142 },
    { PseudoVSLL_VV_MF4, 2143 },
    { PseudoVSLL_VV_MF8, 2144 },
    { PseudoVSLL_VX_M1, 2145 },
    { PseudoVSLL_VX_M2, 2146 },
    { PseudoVSLL_VX_M4, 2147 },
    { PseudoVSLL_VX_M8, 2148 },
    { PseudoVSLL_VX_MF2, 2149 },
    { PseudoVSLL_VX_MF4, 2150 },
    { PseudoVSLL_VX_MF8, 2151 },
    { PseudoVSMUL_VV_M1, 2152 },
    { PseudoVSMUL_VV_M2, 2153 },
    { PseudoVSMUL_VV_M4, 2154 },
    { PseudoVSMUL_VV_M8, 2155 },
    { PseudoVSMUL_VV_MF2, 2156 },
    { PseudoVSMUL_VV_MF4, 2157 },
    { PseudoVSMUL_VV_MF8, 2158 },
    { PseudoVSMUL_VX_M1, 2159 },
    { PseudoVSMUL_VX_M2, 2160 },
    { PseudoVSMUL_VX_M4, 2161 },
    { PseudoVSMUL_VX_M8, 2162 },
    { PseudoVSMUL_VX_MF2, 2163 },
    { PseudoVSMUL_VX_MF4, 2164 },
    { PseudoVSMUL_VX_MF8, 2165 },
    { PseudoVSRA_VI_M1, 2166 },
    { PseudoVSRA_VI_M2, 2167 },
    { PseudoVSRA_VI_M4, 2168 },
    { PseudoVSRA_VI_M8, 2169 },
    { PseudoVSRA_VI_MF2, 2170 },
    { PseudoVSRA_VI_MF4, 2171 },
    { PseudoVSRA_VI_MF8, 2172 },
    { PseudoVSRA_VV_M1, 2173 },
    { PseudoVSRA_VV_M2, 2174 },
    { PseudoVSRA_VV_M4, 2175 },
    { PseudoVSRA_VV_M8, 2176 },
    { PseudoVSRA_VV_MF2, 2177 },
    { PseudoVSRA_VV_MF4, 2178 },
    { PseudoVSRA_VV_MF8, 2179 },
    { PseudoVSRA_VX_M1, 2180 },
    { PseudoVSRA_VX_M2, 2181 },
    { PseudoVSRA_VX_M4, 2182 },
    { PseudoVSRA_VX_M8, 2183 },
    { PseudoVSRA_VX_MF2, 2184 },
    { PseudoVSRA_VX_MF4, 2185 },
    { PseudoVSRA_VX_MF8, 2186 },
    { PseudoVSRL_VI_M1, 2187 },
    { PseudoVSRL_VI_M2, 2188 },
    { PseudoVSRL_VI_M4, 2189 },
    { PseudoVSRL_VI_M8, 2190 },
    { PseudoVSRL_VI_MF2, 2191 },
    { PseudoVSRL_VI_MF4, 2192 },
    { PseudoVSRL_VI_MF8, 2193 },
    { PseudoVSRL_VV_M1, 2194 },
    { PseudoVSRL_VV_M2, 2195 },
    { PseudoVSRL_VV_M4, 2196 },
    { PseudoVSRL_VV_M8, 2197 },
    { PseudoVSRL_VV_MF2, 2198 },
    { PseudoVSRL_VV_MF4, 2199 },
    { PseudoVSRL_VV_MF8, 2200 },
    { PseudoVSRL_VX_M1, 2201 },
    { PseudoVSRL_VX_M2, 2202 },
    { PseudoVSRL_VX_M4, 2203 },
    { PseudoVSRL_VX_M8, 2204 },
    { PseudoVSRL_VX_MF2, 2205 },
    { PseudoVSRL_VX_MF4, 2206 },
    { PseudoVSRL_VX_MF8, 2207 },
    { PseudoVSSRA_VI_M1, 2208 },
    { PseudoVSSRA_VI_M2, 2209 },
    { PseudoVSSRA_VI_M4, 2210 },
    { PseudoVSSRA_VI_M8, 2211 },
    { PseudoVSSRA_VI_MF2, 2212 },
    { PseudoVSSRA_VI_MF4, 2213 },
    { PseudoVSSRA_VI_MF8, 2214 },
    { PseudoVSSRA_VV_M1, 2215 },
    { PseudoVSSRA_VV_M2, 2216 },
    { PseudoVSSRA_VV_M4, 2217 },
    { PseudoVSSRA_VV_M8, 2218 },
    { PseudoVSSRA_VV_MF2, 2219 },
    { PseudoVSSRA_VV_MF4, 2220 },
    { PseudoVSSRA_VV_MF8, 2221 },
    { PseudoVSSRA_VX_M1, 2222 },
    { PseudoVSSRA_VX_M2, 2223 },
    { PseudoVSSRA_VX_M4, 2224 },
    { PseudoVSSRA_VX_M8, 2225 },
    { PseudoVSSRA_VX_MF2, 2226 },
    { PseudoVSSRA_VX_MF4, 2227 },
    { PseudoVSSRA_VX_MF8, 2228 },
    { PseudoVSSRL_VI_M1, 2229 },
    { PseudoVSSRL_VI_M2, 2230 },
    { PseudoVSSRL_VI_M4, 2231 },
    { PseudoVSSRL_VI_M8, 2232 },
    { PseudoVSSRL_VI_MF2, 2233 },
    { PseudoVSSRL_VI_MF4, 2234 },
    { PseudoVSSRL_VI_MF8, 2235 },
    { PseudoVSSRL_VV_M1, 2236 },
    { PseudoVSSRL_VV_M2, 2237 },
    { PseudoVSSRL_VV_M4, 2238 },
    { PseudoVSSRL_VV_M8, 2239 },
    { PseudoVSSRL_VV_MF2, 2240 },
    { PseudoVSSRL_VV_MF4, 2241 },
    { PseudoVSSRL_VV_MF8, 2242 },
    { PseudoVSSRL_VX_M1, 2243 },
    { PseudoVSSRL_VX_M2, 2244 },
    { PseudoVSSRL_VX_M4, 2245 },
    { PseudoVSSRL_VX_M8, 2246 },
    { PseudoVSSRL_VX_MF2, 2247 },
    { PseudoVSSRL_VX_MF4, 2248 },
    { PseudoVSSRL_VX_MF8, 2249 },
    { PseudoVSSUBU_VV_M1, 2250 },
    { PseudoVSSUBU_VV_M2, 2251 },
    { PseudoVSSUBU_VV_M4, 2252 },
    { PseudoVSSUBU_VV_M8, 2253 },
    { PseudoVSSUBU_VV_MF2, 2254 },
    { PseudoVSSUBU_VV_MF4, 2255 },
    { PseudoVSSUBU_VV_MF8, 2256 },
    { PseudoVSSUBU_VX_M1, 2257 },
    { PseudoVSSUBU_VX_M2, 2258 },
    { PseudoVSSUBU_VX_M4, 2259 },
    { PseudoVSSUBU_VX_M8, 2260 },
    { PseudoVSSUBU_VX_MF2, 2261 },
    { PseudoVSSUBU_VX_MF4, 2262 },
    { PseudoVSSUBU_VX_MF8, 2263 },
    { PseudoVSSUB_VV_M1, 2264 },
    { PseudoVSSUB_VV_M2, 2265 },
    { PseudoVSSUB_VV_M4, 2266 },
    { PseudoVSSUB_VV_M8, 2267 },
    { PseudoVSSUB_VV_MF2, 2268 },
    { PseudoVSSUB_VV_MF4, 2269 },
    { PseudoVSSUB_VV_MF8, 2270 },
    { PseudoVSSUB_VX_M1, 2271 },
    { PseudoVSSUB_VX_M2, 2272 },
    { PseudoVSSUB_VX_M4, 2273 },
    { PseudoVSSUB_VX_M8, 2274 },
    { PseudoVSSUB_VX_MF2, 2275 },
    { PseudoVSSUB_VX_MF4, 2276 },
    { PseudoVSSUB_VX_MF8, 2277 },
    { PseudoVSUB_VV_M1, 2278 },
    { PseudoVSUB_VV_M2, 2279 },
    { PseudoVSUB_VV_M4, 2280 },
    { PseudoVSUB_VV_M8, 2281 },
    { PseudoVSUB_VV_MF2, 2282 },
    { PseudoVSUB_VV_MF4, 2283 },
    { PseudoVSUB_VV_MF8, 2284 },
    { PseudoVSUB_VX_M1, 2285 },
    { PseudoVSUB_VX_M2, 2286 },
    { PseudoVSUB_VX_M4, 2287 },
    { PseudoVSUB_VX_M8, 2288 },
    { PseudoVSUB_VX_MF2, 2289 },
    { PseudoVSUB_VX_MF4, 2290 },
    { PseudoVSUB_VX_MF8, 2291 },
    { PseudoVWADDU_VV_M1, 2292 },
    { PseudoVWADDU_VV_M2, 2293 },
    { PseudoVWADDU_VV_M4, 2294 },
    { PseudoVWADDU_VV_MF2, 2295 },
    { PseudoVWADDU_VV_MF4, 2296 },
    { PseudoVWADDU_VV_MF8, 2297 },
    { PseudoVWADDU_VX_M1, 2298 },
    { PseudoVWADDU_VX_M2, 2299 },
    { PseudoVWADDU_VX_M4, 2300 },
    { PseudoVWADDU_VX_MF2, 2301 },
    { PseudoVWADDU_VX_MF4, 2302 },
    { PseudoVWADDU_VX_MF8, 2303 },
    { PseudoVWADDU_WV_M1, 2304 },
    { PseudoVWADDU_WV_M2, 2305 },
    { PseudoVWADDU_WV_M4, 2306 },
    { PseudoVWADDU_WV_MF2, 2307 },
    { PseudoVWADDU_WV_MF4, 2308 },
    { PseudoVWADDU_WV_MF8, 2309 },
    { PseudoVWADDU_WX_M1, 2310 },
    { PseudoVWADDU_WX_M2, 2311 },
    { PseudoVWADDU_WX_M4, 2312 },
    { PseudoVWADDU_WX_MF2, 2313 },
    { PseudoVWADDU_WX_MF4, 2314 },
    { PseudoVWADDU_WX_MF8, 2315 },
    { PseudoVWADD_VV_M1, 2316 },
    { PseudoVWADD_VV_M2, 2317 },
    { PseudoVWADD_VV_M4, 2318 },
    { PseudoVWADD_VV_MF2, 2319 },
    { PseudoVWADD_VV_MF4, 2320 },
    { PseudoVWADD_VV_MF8, 2321 },
    { PseudoVWADD_VX_M1, 2322 },
    { PseudoVWADD_VX_M2, 2323 },
    { PseudoVWADD_VX_M4, 2324 },
    { PseudoVWADD_VX_MF2, 2325 },
    { PseudoVWADD_VX_MF4, 2326 },
    { PseudoVWADD_VX_MF8, 2327 },
    { PseudoVWADD_WV_M1, 2328 },
    { PseudoVWADD_WV_M2, 2329 },
    { PseudoVWADD_WV_M4, 2330 },
    { PseudoVWADD_WV_MF2, 2331 },
    { PseudoVWADD_WV_MF4, 2332 },
    { PseudoVWADD_WV_MF8, 2333 },
    { PseudoVWADD_WX_M1, 2334 },
    { PseudoVWADD_WX_M2, 2335 },
    { PseudoVWADD_WX_M4, 2336 },
    { PseudoVWADD_WX_MF2, 2337 },
    { PseudoVWADD_WX_MF4, 2338 },
    { PseudoVWADD_WX_MF8, 2339 },
    { PseudoVWMACCSU_VV_M1, 2340 },
    { PseudoVWMACCSU_VV_M2, 2341 },
    { PseudoVWMACCSU_VV_M4, 2342 },
    { PseudoVWMACCSU_VV_MF2, 2343 },
    { PseudoVWMACCSU_VV_MF4, 2344 },
    { PseudoVWMACCSU_VV_MF8, 2345 },
    { PseudoVWMACCSU_VX_M1, 2346 },
    { PseudoVWMACCSU_VX_M2, 2347 },
    { PseudoVWMACCSU_VX_M4, 2348 },
    { PseudoVWMACCSU_VX_MF2, 2349 },
    { PseudoVWMACCSU_VX_MF4, 2350 },
    { PseudoVWMACCSU_VX_MF8, 2351 },
    { PseudoVWMACCUS_VX_M1, 2352 },
    { PseudoVWMACCUS_VX_M2, 2353 },
    { PseudoVWMACCUS_VX_M4, 2354 },
    { PseudoVWMACCUS_VX_MF2, 2355 },
    { PseudoVWMACCUS_VX_MF4, 2356 },
    { PseudoVWMACCUS_VX_MF8, 2357 },
    { PseudoVWMACCU_VV_M1, 2358 },
    { PseudoVWMACCU_VV_M2, 2359 },
    { PseudoVWMACCU_VV_M4, 2360 },
    { PseudoVWMACCU_VV_MF2, 2361 },
    { PseudoVWMACCU_VV_MF4, 2362 },
    { PseudoVWMACCU_VV_MF8, 2363 },
    { PseudoVWMACCU_VX_M1, 2364 },
    { PseudoVWMACCU_VX_M2, 2365 },
    { PseudoVWMACCU_VX_M4, 2366 },
    { PseudoVWMACCU_VX_MF2, 2367 },
    { PseudoVWMACCU_VX_MF4, 2368 },
    { PseudoVWMACCU_VX_MF8, 2369 },
    { PseudoVWMACC_VV_M1, 2370 },
    { PseudoVWMACC_VV_M2, 2371 },
    { PseudoVWMACC_VV_M4, 2372 },
    { PseudoVWMACC_VV_MF2, 2373 },
    { PseudoVWMACC_VV_MF4, 2374 },
    { PseudoVWMACC_VV_MF8, 2375 },
    { PseudoVWMACC_VX_M1, 2376 },
    { PseudoVWMACC_VX_M2, 2377 },
    { PseudoVWMACC_VX_M4, 2378 },
    { PseudoVWMACC_VX_MF2, 2379 },
    { PseudoVWMACC_VX_MF4, 2380 },
    { PseudoVWMACC_VX_MF8, 2381 },
    { PseudoVWMULSU_VV_M1, 2382 },
    { PseudoVWMULSU_VV_M2, 2383 },
    { PseudoVWMULSU_VV_M4, 2384 },
    { PseudoVWMULSU_VV_MF2, 2385 },
    { PseudoVWMULSU_VV_MF4, 2386 },
    { PseudoVWMULSU_VV_MF8, 2387 },
    { PseudoVWMULSU_VX_M1, 2388 },
    { PseudoVWMULSU_VX_M2, 2389 },
    { PseudoVWMULSU_VX_M4, 2390 },
    { PseudoVWMULSU_VX_MF2, 2391 },
    { PseudoVWMULSU_VX_MF4, 2392 },
    { PseudoVWMULSU_VX_MF8, 2393 },
    { PseudoVWMULU_VV_M1, 2394 },
    { PseudoVWMULU_VV_M2, 2395 },
    { PseudoVWMULU_VV_M4, 2396 },
    { PseudoVWMULU_VV_MF2, 2397 },
    { PseudoVWMULU_VV_MF4, 2398 },
    { PseudoVWMULU_VV_MF8, 2399 },
    { PseudoVWMULU_VX_M1, 2400 },
    { PseudoVWMULU_VX_M2, 2401 },
    { PseudoVWMULU_VX_M4, 2402 },
    { PseudoVWMULU_VX_MF2, 2403 },
    { PseudoVWMULU_VX_MF4, 2404 },
    { PseudoVWMULU_VX_MF8, 2405 },
    { PseudoVWMUL_VV_M1, 2406 },
    { PseudoVWMUL_VV_M2, 2407 },
    { PseudoVWMUL_VV_M4, 2408 },
    { PseudoVWMUL_VV_MF2, 2409 },
    { PseudoVWMUL_VV_MF4, 2410 },
    { PseudoVWMUL_VV_MF8, 2411 },
    { PseudoVWMUL_VX_M1, 2412 },
    { PseudoVWMUL_VX_M2, 2413 },
    { PseudoVWMUL_VX_M4, 2414 },
    { PseudoVWMUL_VX_MF2, 2415 },
    { PseudoVWMUL_VX_MF4, 2416 },
    { PseudoVWMUL_VX_MF8, 2417 },
    { PseudoVWSUBU_VV_M1, 2418 },
    { PseudoVWSUBU_VV_M2, 2419 },
    { PseudoVWSUBU_VV_M4, 2420 },
    { PseudoVWSUBU_VV_MF2, 2421 },
    { PseudoVWSUBU_VV_MF4, 2422 },
    { PseudoVWSUBU_VV_MF8, 2423 },
    { PseudoVWSUBU_VX_M1, 2424 },
    { PseudoVWSUBU_VX_M2, 2425 },
    { PseudoVWSUBU_VX_M4, 2426 },
    { PseudoVWSUBU_VX_MF2, 2427 },
    { PseudoVWSUBU_VX_MF4, 2428 },
    { PseudoVWSUBU_VX_MF8, 2429 },
    { PseudoVWSUBU_WV_M1, 2430 },
    { PseudoVWSUBU_WV_M2, 2431 },
    { PseudoVWSUBU_WV_M4, 2432 },
    { PseudoVWSUBU_WV_MF2, 2433 },
    { PseudoVWSUBU_WV_MF4, 2434 },
    { PseudoVWSUBU_WV_MF8, 2435 },
    { PseudoVWSUBU_WX_M1, 2436 },
    { PseudoVWSUBU_WX_M2, 2437 },
    { PseudoVWSUBU_WX_M4, 2438 },
    { PseudoVWSUBU_WX_MF2, 2439 },
    { PseudoVWSUBU_WX_MF4, 2440 },
    { PseudoVWSUBU_WX_MF8, 2441 },
    { PseudoVWSUB_VV_M1, 2442 },
    { PseudoVWSUB_VV_M2, 2443 },
    { PseudoVWSUB_VV_M4, 2444 },
    { PseudoVWSUB_VV_MF2, 2445 },
    { PseudoVWSUB_VV_MF4, 2446 },
    { PseudoVWSUB_VV_MF8, 2447 },
    { PseudoVWSUB_VX_M1, 2448 },
    { PseudoVWSUB_VX_M2, 2449 },
    { PseudoVWSUB_VX_M4, 2450 },
    { PseudoVWSUB_VX_MF2, 2451 },
    { PseudoVWSUB_VX_MF4, 2452 },
    { PseudoVWSUB_VX_MF8, 2453 },
    { PseudoVWSUB_WV_M1, 2454 },
    { PseudoVWSUB_WV_M2, 2455 },
    { PseudoVWSUB_WV_M4, 2456 },
    { PseudoVWSUB_WV_MF2, 2457 },
    { PseudoVWSUB_WV_MF4, 2458 },
    { PseudoVWSUB_WV_MF8, 2459 },
    { PseudoVWSUB_WX_M1, 2460 },
    { PseudoVWSUB_WX_M2, 2461 },
    { PseudoVWSUB_WX_M4, 2462 },
    { PseudoVWSUB_WX_MF2, 2463 },
    { PseudoVWSUB_WX_MF4, 2464 },
    { PseudoVWSUB_WX_MF8, 2465 },
    { PseudoVXOR_VI_M1, 2466 },
    { PseudoVXOR_VI_M2, 2467 },
    { PseudoVXOR_VI_M4, 2468 },
    { PseudoVXOR_VI_M8, 2469 },
    { PseudoVXOR_VI_MF2, 2470 },
    { PseudoVXOR_VI_MF4, 2471 },
    { PseudoVXOR_VI_MF8, 2472 },
    { PseudoVXOR_VV_M1, 2473 },
    { PseudoVXOR_VV_M2, 2474 },
    { PseudoVXOR_VV_M4, 2475 },
    { PseudoVXOR_VV_M8, 2476 },
    { PseudoVXOR_VV_MF2, 2477 },
    { PseudoVXOR_VV_MF4, 2478 },
    { PseudoVXOR_VV_MF8, 2479 },
    { PseudoVXOR_VX_M1, 2480 },
    { PseudoVXOR_VX_M2, 2481 },
    { PseudoVXOR_VX_M4, 2482 },
    { PseudoVXOR_VX_M8, 2483 },
    { PseudoVXOR_VX_MF2, 2484 },
    { PseudoVXOR_VX_MF4, 2485 },
    { PseudoVXOR_VX_MF8, 2486 },
    { PseudoVZEXT_VF2_M1, 2487 },
    { PseudoVZEXT_VF2_M2, 2488 },
    { PseudoVZEXT_VF2_M4, 2489 },
    { PseudoVZEXT_VF2_M8, 2490 },
    { PseudoVZEXT_VF2_MF2, 2491 },
    { PseudoVZEXT_VF2_MF4, 2492 },
    { PseudoVZEXT_VF4_M1, 2493 },
    { PseudoVZEXT_VF4_M2, 2494 },
    { PseudoVZEXT_VF4_M4, 2495 },
    { PseudoVZEXT_VF4_M8, 2496 },
    { PseudoVZEXT_VF4_MF2, 2497 },
    { PseudoVZEXT_VF8_M1, 2498 },
    { PseudoVZEXT_VF8_M2, 2499 },
    { PseudoVZEXT_VF8_M4, 2500 },
    { PseudoVZEXT_VF8_M8, 2501 },
  };

  struct KeyType {
    unsigned UnmaskedPseudo;
  };
  KeyType Key = {UnmaskedPseudo};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.UnmaskedPseudo < RHS.UnmaskedPseudo)
        return true;
      if (LHS.UnmaskedPseudo > RHS.UnmaskedPseudo)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.UnmaskedPseudo != Idx->UnmaskedPseudo)
    return nullptr;
  return &RISCVMaskedPseudosTable[Idx->_index];
}
#endif

#ifdef GET_RISCVOpcodesList_DECL
const RISCVOpcode *lookupRISCVOpcodeByValue(uint8_t Value);
const RISCVOpcode *lookupRISCVOpcodeByName(StringRef Name);
#endif

#ifdef GET_RISCVOpcodesList_IMPL
constexpr RISCVOpcode RISCVOpcodesList[] = {
  { "LOAD", 0x3 }, // 0
  { "LOAD_FP", 0x7 }, // 1
  { "CUSTOM_0", 0xB }, // 2
  { "MISC_MEM", 0xF }, // 3
  { "OP_IMM", 0x13 }, // 4
  { "AUIPC", 0x17 }, // 5
  { "OP_IMM_32", 0x1B }, // 6
  { "STORE", 0x23 }, // 7
  { "STORE_FP", 0x27 }, // 8
  { "CUSTOM_1", 0x2B }, // 9
  { "AMO", 0x2F }, // 10
  { "OP", 0x33 }, // 11
  { "LUI", 0x37 }, // 12
  { "OP_32", 0x3B }, // 13
  { "MADD", 0x43 }, // 14
  { "MSUB", 0x47 }, // 15
  { "NMSUB", 0x4B }, // 16
  { "NMADD", 0x4F }, // 17
  { "OP_FP", 0x53 }, // 18
  { "OP_V", 0x57 }, // 19
  { "CUSTOM_2", 0x5B }, // 20
  { "BRANCH", 0x63 }, // 21
  { "JALR", 0x67 }, // 22
  { "JAL", 0x6F }, // 23
  { "SYSTEM", 0x73 }, // 24
  { "OP_P", 0x77 }, // 25
  { "CUSTOM_3", 0x7B }, // 26
 };

const RISCVOpcode *lookupRISCVOpcodeByValue(uint8_t Value) {
  struct KeyType {
    uint8_t Value;
  };
  KeyType Key = {Value};
  auto Table = ArrayRef(RISCVOpcodesList);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVOpcode &LHS, const KeyType &RHS) {
      if (LHS.Value < RHS.Value)
        return true;
      if (LHS.Value > RHS.Value)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Value != Idx->Value)
    return nullptr;
  return &*Idx;
}

const RISCVOpcode *lookupRISCVOpcodeByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "AMO", 10 },
    { "AUIPC", 5 },
    { "BRANCH", 21 },
    { "CUSTOM_0", 2 },
    { "CUSTOM_1", 9 },
    { "CUSTOM_2", 20 },
    { "CUSTOM_3", 26 },
    { "JAL", 23 },
    { "JALR", 22 },
    { "LOAD", 0 },
    { "LOAD_FP", 1 },
    { "LUI", 12 },
    { "MADD", 14 },
    { "MISC_MEM", 3 },
    { "MSUB", 15 },
    { "NMADD", 17 },
    { "NMSUB", 16 },
    { "OP", 11 },
    { "OP_32", 13 },
    { "OP_FP", 18 },
    { "OP_IMM", 4 },
    { "OP_IMM_32", 6 },
    { "OP_P", 25 },
    { "OP_V", 19 },
    { "STORE", 7 },
    { "STORE_FP", 8 },
    { "SYSTEM", 24 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &RISCVOpcodesList[Idx->_index];
}
#endif

#ifdef GET_RISCVVIntrinsicsTable_DECL
const RISCVVIntrinsicInfo *getRISCVVIntrinsicInfo(unsigned IntrinsicID);
#endif

#ifdef GET_RISCVVIntrinsicsTable_IMPL
constexpr RISCVVIntrinsicInfo RISCVVIntrinsicsTable[] = {
  { Intrinsic::riscv_sf_vc_fv_se, 0x3, 0x4 }, // 0
  { Intrinsic::riscv_sf_vc_fvv_se, 0x3, 0x4 }, // 1
  { Intrinsic::riscv_sf_vc_fvw_se, 0x3, 0x4 }, // 2
  { Intrinsic::riscv_sf_vc_i_se_e16m1, 0xF, 0x4 }, // 3
  { Intrinsic::riscv_sf_vc_i_se_e16m2, 0xF, 0x4 }, // 4
  { Intrinsic::riscv_sf_vc_i_se_e16m4, 0xF, 0x4 }, // 5
  { Intrinsic::riscv_sf_vc_i_se_e16m8, 0xF, 0x4 }, // 6
  { Intrinsic::riscv_sf_vc_i_se_e16mf2, 0xF, 0x4 }, // 7
  { Intrinsic::riscv_sf_vc_i_se_e16mf4, 0xF, 0x4 }, // 8
  { Intrinsic::riscv_sf_vc_i_se_e32m1, 0xF, 0x4 }, // 9
  { Intrinsic::riscv_sf_vc_i_se_e32m2, 0xF, 0x4 }, // 10
  { Intrinsic::riscv_sf_vc_i_se_e32m4, 0xF, 0x4 }, // 11
  { Intrinsic::riscv_sf_vc_i_se_e32m8, 0xF, 0x4 }, // 12
  { Intrinsic::riscv_sf_vc_i_se_e32mf2, 0xF, 0x4 }, // 13
  { Intrinsic::riscv_sf_vc_i_se_e64m1, 0xF, 0x4 }, // 14
  { Intrinsic::riscv_sf_vc_i_se_e64m2, 0xF, 0x4 }, // 15
  { Intrinsic::riscv_sf_vc_i_se_e64m4, 0xF, 0x4 }, // 16
  { Intrinsic::riscv_sf_vc_i_se_e64m8, 0xF, 0x4 }, // 17
  { Intrinsic::riscv_sf_vc_i_se_e8m1, 0xF, 0x4 }, // 18
  { Intrinsic::riscv_sf_vc_i_se_e8m2, 0xF, 0x4 }, // 19
  { Intrinsic::riscv_sf_vc_i_se_e8m4, 0xF, 0x4 }, // 20
  { Intrinsic::riscv_sf_vc_i_se_e8m8, 0xF, 0x4 }, // 21
  { Intrinsic::riscv_sf_vc_i_se_e8mf2, 0xF, 0x4 }, // 22
  { Intrinsic::riscv_sf_vc_i_se_e8mf4, 0xF, 0x4 }, // 23
  { Intrinsic::riscv_sf_vc_i_se_e8mf8, 0xF, 0x4 }, // 24
  { Intrinsic::riscv_sf_vc_iv_se, 0xF, 0x4 }, // 25
  { Intrinsic::riscv_sf_vc_ivv_se, 0xF, 0x4 }, // 26
  { Intrinsic::riscv_sf_vc_ivw_se, 0xF, 0x4 }, // 27
  { Intrinsic::riscv_sf_vc_v_fv, 0x2, 0x3 }, // 28
  { Intrinsic::riscv_sf_vc_v_fv_se, 0x2, 0x3 }, // 29
  { Intrinsic::riscv_sf_vc_v_fvv, 0x3, 0x4 }, // 30
  { Intrinsic::riscv_sf_vc_v_fvv_se, 0x3, 0x4 }, // 31
  { Intrinsic::riscv_sf_vc_v_fvw, 0x3, 0x4 }, // 32
  { Intrinsic::riscv_sf_vc_v_fvw_se, 0x3, 0x4 }, // 33
  { Intrinsic::riscv_sf_vc_v_i, 0xF, 0x3 }, // 34
  { Intrinsic::riscv_sf_vc_v_i_se, 0xF, 0x3 }, // 35
  { Intrinsic::riscv_sf_vc_v_iv, 0xF, 0x3 }, // 36
  { Intrinsic::riscv_sf_vc_v_iv_se, 0xF, 0x3 }, // 37
  { Intrinsic::riscv_sf_vc_v_ivv, 0xF, 0x4 }, // 38
  { Intrinsic::riscv_sf_vc_v_ivv_se, 0xF, 0x4 }, // 39
  { Intrinsic::riscv_sf_vc_v_ivw, 0xF, 0x4 }, // 40
  { Intrinsic::riscv_sf_vc_v_ivw_se, 0xF, 0x4 }, // 41
  { Intrinsic::riscv_sf_vc_v_vv, 0x2, 0x3 }, // 42
  { Intrinsic::riscv_sf_vc_v_vv_se, 0x2, 0x3 }, // 43
  { Intrinsic::riscv_sf_vc_v_vvv, 0x3, 0x4 }, // 44
  { Intrinsic::riscv_sf_vc_v_vvv_se, 0x3, 0x4 }, // 45
  { Intrinsic::riscv_sf_vc_v_vvw, 0x3, 0x4 }, // 46
  { Intrinsic::riscv_sf_vc_v_vvw_se, 0x3, 0x4 }, // 47
  { Intrinsic::riscv_sf_vc_v_x, 0x2, 0x3 }, // 48
  { Intrinsic::riscv_sf_vc_v_x_se, 0x2, 0x3 }, // 49
  { Intrinsic::riscv_sf_vc_v_xv, 0x2, 0x3 }, // 50
  { Intrinsic::riscv_sf_vc_v_xv_se, 0x2, 0x3 }, // 51
  { Intrinsic::riscv_sf_vc_v_xvv, 0x3, 0x4 }, // 52
  { Intrinsic::riscv_sf_vc_v_xvv_se, 0x3, 0x4 }, // 53
  { Intrinsic::riscv_sf_vc_v_xvw, 0x3, 0x4 }, // 54
  { Intrinsic::riscv_sf_vc_v_xvw_se, 0x3, 0x4 }, // 55
  { Intrinsic::riscv_sf_vc_vv_se, 0x3, 0x4 }, // 56
  { Intrinsic::riscv_sf_vc_vvv_se, 0x3, 0x4 }, // 57
  { Intrinsic::riscv_sf_vc_vvw_se, 0x3, 0x4 }, // 58
  { Intrinsic::riscv_sf_vc_x_se_e16m1, 0x3, 0x4 }, // 59
  { Intrinsic::riscv_sf_vc_x_se_e16m2, 0x3, 0x4 }, // 60
  { Intrinsic::riscv_sf_vc_x_se_e16m4, 0x3, 0x4 }, // 61
  { Intrinsic::riscv_sf_vc_x_se_e16m8, 0x3, 0x4 }, // 62
  { Intrinsic::riscv_sf_vc_x_se_e16mf2, 0x3, 0x4 }, // 63
  { Intrinsic::riscv_sf_vc_x_se_e16mf4, 0x3, 0x4 }, // 64
  { Intrinsic::riscv_sf_vc_x_se_e32m1, 0x3, 0x4 }, // 65
  { Intrinsic::riscv_sf_vc_x_se_e32m2, 0x3, 0x4 }, // 66
  { Intrinsic::riscv_sf_vc_x_se_e32m4, 0x3, 0x4 }, // 67
  { Intrinsic::riscv_sf_vc_x_se_e32m8, 0x3, 0x4 }, // 68
  { Intrinsic::riscv_sf_vc_x_se_e32mf2, 0x3, 0x4 }, // 69
  { Intrinsic::riscv_sf_vc_x_se_e64m1, 0x3, 0x4 }, // 70
  { Intrinsic::riscv_sf_vc_x_se_e64m2, 0x3, 0x4 }, // 71
  { Intrinsic::riscv_sf_vc_x_se_e64m4, 0x3, 0x4 }, // 72
  { Intrinsic::riscv_sf_vc_x_se_e64m8, 0x3, 0x4 }, // 73
  { Intrinsic::riscv_sf_vc_x_se_e8m1, 0x3, 0x4 }, // 74
  { Intrinsic::riscv_sf_vc_x_se_e8m2, 0x3, 0x4 }, // 75
  { Intrinsic::riscv_sf_vc_x_se_e8m4, 0x3, 0x4 }, // 76
  { Intrinsic::riscv_sf_vc_x_se_e8m8, 0x3, 0x4 }, // 77
  { Intrinsic::riscv_sf_vc_x_se_e8mf2, 0x3, 0x4 }, // 78
  { Intrinsic::riscv_sf_vc_x_se_e8mf4, 0x3, 0x4 }, // 79
  { Intrinsic::riscv_sf_vc_x_se_e8mf8, 0x3, 0x4 }, // 80
  { Intrinsic::riscv_sf_vc_xv_se, 0x3, 0x4 }, // 81
  { Intrinsic::riscv_sf_vc_xvv_se, 0x3, 0x4 }, // 82
  { Intrinsic::riscv_sf_vc_xvw_se, 0x3, 0x4 }, // 83
  { Intrinsic::riscv_th_vmaqa, 0x1, 0x3 }, // 84
  { Intrinsic::riscv_th_vmaqa_mask, 0x1, 0x4 }, // 85
  { Intrinsic::riscv_th_vmaqasu, 0x1, 0x3 }, // 86
  { Intrinsic::riscv_th_vmaqasu_mask, 0x1, 0x4 }, // 87
  { Intrinsic::riscv_th_vmaqau, 0x1, 0x3 }, // 88
  { Intrinsic::riscv_th_vmaqau_mask, 0x1, 0x4 }, // 89
  { Intrinsic::riscv_th_vmaqaus, 0x1, 0x3 }, // 90
  { Intrinsic::riscv_th_vmaqaus_mask, 0x1, 0x4 }, // 91
  { Intrinsic::riscv_vaadd, 0x2, 0x4 }, // 92
  { Intrinsic::riscv_vaadd_mask, 0x2, 0x5 }, // 93
  { Intrinsic::riscv_vaaddu, 0x2, 0x4 }, // 94
  { Intrinsic::riscv_vaaddu_mask, 0x2, 0x5 }, // 95
  { Intrinsic::riscv_vadc, 0x2, 0x4 }, // 96
  { Intrinsic::riscv_vadd, 0x2, 0x3 }, // 97
  { Intrinsic::riscv_vadd_mask, 0x2, 0x4 }, // 98
  { Intrinsic::riscv_vand, 0x2, 0x3 }, // 99
  { Intrinsic::riscv_vand_mask, 0x2, 0x4 }, // 100
  { Intrinsic::riscv_vasub, 0x2, 0x4 }, // 101
  { Intrinsic::riscv_vasub_mask, 0x2, 0x5 }, // 102
  { Intrinsic::riscv_vasubu, 0x2, 0x4 }, // 103
  { Intrinsic::riscv_vasubu_mask, 0x2, 0x5 }, // 104
  { Intrinsic::riscv_vcompress, 0xF, 0x3 }, // 105
  { Intrinsic::riscv_vcpop, 0xF, 0x1 }, // 106
  { Intrinsic::riscv_vcpop_mask, 0xF, 0x2 }, // 107
  { Intrinsic::riscv_vdiv, 0x2, 0x3 }, // 108
  { Intrinsic::riscv_vdiv_mask, 0x2, 0x4 }, // 109
  { Intrinsic::riscv_vdivu, 0x2, 0x3 }, // 110
  { Intrinsic::riscv_vdivu_mask, 0x2, 0x4 }, // 111
  { Intrinsic::riscv_vfadd, 0x2, 0x4 }, // 112
  { Intrinsic::riscv_vfadd_mask, 0x2, 0x5 }, // 113
  { Intrinsic::riscv_vfclass, 0xF, 0x1 }, // 114
  { Intrinsic::riscv_vfclass_mask, 0xF, 0x3 }, // 115
  { Intrinsic::riscv_vfcvt_f_x_v, 0xF, 0x3 }, // 116
  { Intrinsic::riscv_vfcvt_f_x_v_mask, 0xF, 0x4 }, // 117
  { Intrinsic::riscv_vfcvt_f_xu_v, 0xF, 0x3 }, // 118
  { Intrinsic::riscv_vfcvt_f_xu_v_mask, 0xF, 0x4 }, // 119
  { Intrinsic::riscv_vfcvt_rtz_x_f_v, 0xF, 0x2 }, // 120
  { Intrinsic::riscv_vfcvt_rtz_x_f_v_mask, 0xF, 0x3 }, // 121
  { Intrinsic::riscv_vfcvt_rtz_xu_f_v, 0xF, 0x2 }, // 122
  { Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask, 0xF, 0x3 }, // 123
  { Intrinsic::riscv_vfcvt_x_f_v, 0xF, 0x3 }, // 124
  { Intrinsic::riscv_vfcvt_x_f_v_mask, 0xF, 0x4 }, // 125
  { Intrinsic::riscv_vfcvt_xu_f_v, 0xF, 0x3 }, // 126
  { Intrinsic::riscv_vfcvt_xu_f_v_mask, 0xF, 0x4 }, // 127
  { Intrinsic::riscv_vfdiv, 0x2, 0x4 }, // 128
  { Intrinsic::riscv_vfdiv_mask, 0x2, 0x5 }, // 129
  { Intrinsic::riscv_vfirst, 0xF, 0x1 }, // 130
  { Intrinsic::riscv_vfirst_mask, 0xF, 0x2 }, // 131
  { Intrinsic::riscv_vfmacc, 0x1, 0x4 }, // 132
  { Intrinsic::riscv_vfmacc_mask, 0x1, 0x5 }, // 133
  { Intrinsic::riscv_vfmadd, 0x1, 0x4 }, // 134
  { Intrinsic::riscv_vfmadd_mask, 0x1, 0x5 }, // 135
  { Intrinsic::riscv_vfmax, 0x2, 0x3 }, // 136
  { Intrinsic::riscv_vfmax_mask, 0x2, 0x4 }, // 137
  { Intrinsic::riscv_vfmerge, 0x2, 0x4 }, // 138
  { Intrinsic::riscv_vfmin, 0x2, 0x3 }, // 139
  { Intrinsic::riscv_vfmin_mask, 0x2, 0x4 }, // 140
  { Intrinsic::riscv_vfmsac, 0x1, 0x4 }, // 141
  { Intrinsic::riscv_vfmsac_mask, 0x1, 0x5 }, // 142
  { Intrinsic::riscv_vfmsub, 0x1, 0x4 }, // 143
  { Intrinsic::riscv_vfmsub_mask, 0x1, 0x5 }, // 144
  { Intrinsic::riscv_vfmul, 0x2, 0x4 }, // 145
  { Intrinsic::riscv_vfmul_mask, 0x2, 0x5 }, // 146
  { Intrinsic::riscv_vfmv_f_s, 0xF, 0x1F }, // 147
  { Intrinsic::riscv_vfmv_s_f, 0xF, 0x2 }, // 148
  { Intrinsic::riscv_vfmv_v_f, 0xF, 0x2 }, // 149
  { Intrinsic::riscv_vfncvt_f_f_w, 0xF, 0x3 }, // 150
  { Intrinsic::riscv_vfncvt_f_f_w_mask, 0xF, 0x4 }, // 151
  { Intrinsic::riscv_vfncvt_f_x_w, 0xF, 0x3 }, // 152
  { Intrinsic::riscv_vfncvt_f_x_w_mask, 0xF, 0x4 }, // 153
  { Intrinsic::riscv_vfncvt_f_xu_w, 0xF, 0x3 }, // 154
  { Intrinsic::riscv_vfncvt_f_xu_w_mask, 0xF, 0x4 }, // 155
  { Intrinsic::riscv_vfncvt_rod_f_f_w, 0xF, 0x2 }, // 156
  { Intrinsic::riscv_vfncvt_rod_f_f_w_mask, 0xF, 0x3 }, // 157
  { Intrinsic::riscv_vfncvt_rtz_x_f_w, 0xF, 0x2 }, // 158
  { Intrinsic::riscv_vfncvt_rtz_x_f_w_mask, 0xF, 0x3 }, // 159
  { Intrinsic::riscv_vfncvt_rtz_xu_f_w, 0xF, 0x2 }, // 160
  { Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask, 0xF, 0x3 }, // 161
  { Intrinsic::riscv_vfncvt_x_f_w, 0xF, 0x3 }, // 162
  { Intrinsic::riscv_vfncvt_x_f_w_mask, 0xF, 0x4 }, // 163
  { Intrinsic::riscv_vfncvt_xu_f_w, 0xF, 0x3 }, // 164
  { Intrinsic::riscv_vfncvt_xu_f_w_mask, 0xF, 0x4 }, // 165
  { Intrinsic::riscv_vfnmacc, 0x1, 0x4 }, // 166
  { Intrinsic::riscv_vfnmacc_mask, 0x1, 0x5 }, // 167
  { Intrinsic::riscv_vfnmadd, 0x1, 0x4 }, // 168
  { Intrinsic::riscv_vfnmadd_mask, 0x1, 0x5 }, // 169
  { Intrinsic::riscv_vfnmsac, 0x1, 0x4 }, // 170
  { Intrinsic::riscv_vfnmsac_mask, 0x1, 0x5 }, // 171
  { Intrinsic::riscv_vfnmsub, 0x1, 0x4 }, // 172
  { Intrinsic::riscv_vfnmsub_mask, 0x1, 0x5 }, // 173
  { Intrinsic::riscv_vfrdiv, 0x2, 0x4 }, // 174
  { Intrinsic::riscv_vfrdiv_mask, 0x2, 0x5 }, // 175
  { Intrinsic::riscv_vfrec7, 0xF, 0x3 }, // 176
  { Intrinsic::riscv_vfrec7_mask, 0xF, 0x4 }, // 177
  { Intrinsic::riscv_vfredmax, 0xF, 0x3 }, // 178
  { Intrinsic::riscv_vfredmax_mask, 0xF, 0x4 }, // 179
  { Intrinsic::riscv_vfredmin, 0xF, 0x3 }, // 180
  { Intrinsic::riscv_vfredmin_mask, 0xF, 0x4 }, // 181
  { Intrinsic::riscv_vfredosum, 0xF, 0x4 }, // 182
  { Intrinsic::riscv_vfredosum_mask, 0xF, 0x5 }, // 183
  { Intrinsic::riscv_vfredusum, 0xF, 0x4 }, // 184
  { Intrinsic::riscv_vfredusum_mask, 0xF, 0x5 }, // 185
  { Intrinsic::riscv_vfrsqrt7, 0xF, 0x2 }, // 186
  { Intrinsic::riscv_vfrsqrt7_mask, 0xF, 0x3 }, // 187
  { Intrinsic::riscv_vfrsub, 0x2, 0x4 }, // 188
  { Intrinsic::riscv_vfrsub_mask, 0x2, 0x5 }, // 189
  { Intrinsic::riscv_vfsgnj, 0x2, 0x3 }, // 190
  { Intrinsic::riscv_vfsgnj_mask, 0x2, 0x4 }, // 191
  { Intrinsic::riscv_vfsgnjn, 0x2, 0x3 }, // 192
  { Intrinsic::riscv_vfsgnjn_mask, 0x2, 0x4 }, // 193
  { Intrinsic::riscv_vfsgnjx, 0x2, 0x3 }, // 194
  { Intrinsic::riscv_vfsgnjx_mask, 0x2, 0x4 }, // 195
  { Intrinsic::riscv_vfslide1down, 0x2, 0x3 }, // 196
  { Intrinsic::riscv_vfslide1down_mask, 0x2, 0x4 }, // 197
  { Intrinsic::riscv_vfslide1up, 0x2, 0x3 }, // 198
  { Intrinsic::riscv_vfslide1up_mask, 0x2, 0x4 }, // 199
  { Intrinsic::riscv_vfsqrt, 0xF, 0x3 }, // 200
  { Intrinsic::riscv_vfsqrt_mask, 0xF, 0x4 }, // 201
  { Intrinsic::riscv_vfsub, 0x2, 0x4 }, // 202
  { Intrinsic::riscv_vfsub_mask, 0x2, 0x5 }, // 203
  { Intrinsic::riscv_vfwadd, 0x2, 0x4 }, // 204
  { Intrinsic::riscv_vfwadd_mask, 0x2, 0x5 }, // 205
  { Intrinsic::riscv_vfwadd_w, 0x2, 0x4 }, // 206
  { Intrinsic::riscv_vfwadd_w_mask, 0x2, 0x5 }, // 207
  { Intrinsic::riscv_vfwcvt_f_f_v, 0xF, 0x2 }, // 208
  { Intrinsic::riscv_vfwcvt_f_f_v_mask, 0xF, 0x3 }, // 209
  { Intrinsic::riscv_vfwcvt_f_x_v, 0xF, 0x2 }, // 210
  { Intrinsic::riscv_vfwcvt_f_x_v_mask, 0xF, 0x3 }, // 211
  { Intrinsic::riscv_vfwcvt_f_xu_v, 0xF, 0x2 }, // 212
  { Intrinsic::riscv_vfwcvt_f_xu_v_mask, 0xF, 0x3 }, // 213
  { Intrinsic::riscv_vfwcvt_rtz_x_f_v, 0xF, 0x2 }, // 214
  { Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask, 0xF, 0x3 }, // 215
  { Intrinsic::riscv_vfwcvt_rtz_xu_f_v, 0xF, 0x2 }, // 216
  { Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask, 0xF, 0x3 }, // 217
  { Intrinsic::riscv_vfwcvt_x_f_v, 0xF, 0x3 }, // 218
  { Intrinsic::riscv_vfwcvt_x_f_v_mask, 0xF, 0x4 }, // 219
  { Intrinsic::riscv_vfwcvt_xu_f_v, 0xF, 0x3 }, // 220
  { Intrinsic::riscv_vfwcvt_xu_f_v_mask, 0xF, 0x4 }, // 221
  { Intrinsic::riscv_vfwmacc, 0x1, 0x4 }, // 222
  { Intrinsic::riscv_vfwmacc_mask, 0x1, 0x5 }, // 223
  { Intrinsic::riscv_vfwmsac, 0x1, 0x4 }, // 224
  { Intrinsic::riscv_vfwmsac_mask, 0x1, 0x5 }, // 225
  { Intrinsic::riscv_vfwmul, 0x2, 0x4 }, // 226
  { Intrinsic::riscv_vfwmul_mask, 0x2, 0x5 }, // 227
  { Intrinsic::riscv_vfwnmacc, 0x1, 0x4 }, // 228
  { Intrinsic::riscv_vfwnmacc_mask, 0x1, 0x5 }, // 229
  { Intrinsic::riscv_vfwnmsac, 0x1, 0x4 }, // 230
  { Intrinsic::riscv_vfwnmsac_mask, 0x1, 0x5 }, // 231
  { Intrinsic::riscv_vfwredosum, 0xF, 0x4 }, // 232
  { Intrinsic::riscv_vfwredosum_mask, 0xF, 0x5 }, // 233
  { Intrinsic::riscv_vfwredusum, 0xF, 0x4 }, // 234
  { Intrinsic::riscv_vfwredusum_mask, 0xF, 0x5 }, // 235
  { Intrinsic::riscv_vfwsub, 0x2, 0x4 }, // 236
  { Intrinsic::riscv_vfwsub_mask, 0x2, 0x5 }, // 237
  { Intrinsic::riscv_vfwsub_w, 0x2, 0x4 }, // 238
  { Intrinsic::riscv_vfwsub_w_mask, 0x2, 0x5 }, // 239
  { Intrinsic::riscv_vid, 0xF, 0x1 }, // 240
  { Intrinsic::riscv_vid_mask, 0xF, 0x2 }, // 241
  { Intrinsic::riscv_viota, 0xF, 0x2 }, // 242
  { Intrinsic::riscv_viota_mask, 0xF, 0x3 }, // 243
  { Intrinsic::riscv_vle, 0xF, 0x2 }, // 244
  { Intrinsic::riscv_vle_mask, 0xF, 0x3 }, // 245
  { Intrinsic::riscv_vleff, 0xF, 0x2 }, // 246
  { Intrinsic::riscv_vleff_mask, 0xF, 0x3 }, // 247
  { Intrinsic::riscv_vlm, 0xF, 0x1 }, // 248
  { Intrinsic::riscv_vloxei, 0xF, 0x3 }, // 249
  { Intrinsic::riscv_vloxei_mask, 0xF, 0x4 }, // 250
  { Intrinsic::riscv_vloxseg2, 0xF, 0x4 }, // 251
  { Intrinsic::riscv_vloxseg2_mask, 0xF, 0x5 }, // 252
  { Intrinsic::riscv_vloxseg3, 0xF, 0x5 }, // 253
  { Intrinsic::riscv_vloxseg3_mask, 0xF, 0x6 }, // 254
  { Intrinsic::riscv_vloxseg4, 0xF, 0x6 }, // 255
  { Intrinsic::riscv_vloxseg4_mask, 0xF, 0x7 }, // 256
  { Intrinsic::riscv_vloxseg5, 0xF, 0x7 }, // 257
  { Intrinsic::riscv_vloxseg5_mask, 0xF, 0x8 }, // 258
  { Intrinsic::riscv_vloxseg6, 0xF, 0x8 }, // 259
  { Intrinsic::riscv_vloxseg6_mask, 0xF, 0x9 }, // 260
  { Intrinsic::riscv_vloxseg7, 0xF, 0x9 }, // 261
  { Intrinsic::riscv_vloxseg7_mask, 0xF, 0xA }, // 262
  { Intrinsic::riscv_vloxseg8, 0xF, 0xA }, // 263
  { Intrinsic::riscv_vloxseg8_mask, 0xF, 0xB }, // 264
  { Intrinsic::riscv_vlse, 0xF, 0x3 }, // 265
  { Intrinsic::riscv_vlse_mask, 0xF, 0x4 }, // 266
  { Intrinsic::riscv_vlseg2, 0xF, 0x3 }, // 267
  { Intrinsic::riscv_vlseg2_mask, 0xF, 0x4 }, // 268
  { Intrinsic::riscv_vlseg2ff, 0xF, 0x3 }, // 269
  { Intrinsic::riscv_vlseg2ff_mask, 0xF, 0x4 }, // 270
  { Intrinsic::riscv_vlseg3, 0xF, 0x4 }, // 271
  { Intrinsic::riscv_vlseg3_mask, 0xF, 0x5 }, // 272
  { Intrinsic::riscv_vlseg3ff, 0xF, 0x4 }, // 273
  { Intrinsic::riscv_vlseg3ff_mask, 0xF, 0x5 }, // 274
  { Intrinsic::riscv_vlseg4, 0xF, 0x5 }, // 275
  { Intrinsic::riscv_vlseg4_mask, 0xF, 0x6 }, // 276
  { Intrinsic::riscv_vlseg4ff, 0xF, 0x5 }, // 277
  { Intrinsic::riscv_vlseg4ff_mask, 0xF, 0x6 }, // 278
  { Intrinsic::riscv_vlseg5, 0xF, 0x6 }, // 279
  { Intrinsic::riscv_vlseg5_mask, 0xF, 0x7 }, // 280
  { Intrinsic::riscv_vlseg5ff, 0xF, 0x6 }, // 281
  { Intrinsic::riscv_vlseg5ff_mask, 0xF, 0x7 }, // 282
  { Intrinsic::riscv_vlseg6, 0xF, 0x7 }, // 283
  { Intrinsic::riscv_vlseg6_mask, 0xF, 0x8 }, // 284
  { Intrinsic::riscv_vlseg6ff, 0xF, 0x7 }, // 285
  { Intrinsic::riscv_vlseg6ff_mask, 0xF, 0x8 }, // 286
  { Intrinsic::riscv_vlseg7, 0xF, 0x8 }, // 287
  { Intrinsic::riscv_vlseg7_mask, 0xF, 0x9 }, // 288
  { Intrinsic::riscv_vlseg7ff, 0xF, 0x8 }, // 289
  { Intrinsic::riscv_vlseg7ff_mask, 0xF, 0x9 }, // 290
  { Intrinsic::riscv_vlseg8, 0xF, 0x9 }, // 291
  { Intrinsic::riscv_vlseg8_mask, 0xF, 0xA }, // 292
  { Intrinsic::riscv_vlseg8ff, 0xF, 0x9 }, // 293
  { Intrinsic::riscv_vlseg8ff_mask, 0xF, 0xA }, // 294
  { Intrinsic::riscv_vlsseg2, 0xF, 0x4 }, // 295
  { Intrinsic::riscv_vlsseg2_mask, 0xF, 0x5 }, // 296
  { Intrinsic::riscv_vlsseg3, 0xF, 0x5 }, // 297
  { Intrinsic::riscv_vlsseg3_mask, 0xF, 0x6 }, // 298
  { Intrinsic::riscv_vlsseg4, 0xF, 0x6 }, // 299
  { Intrinsic::riscv_vlsseg4_mask, 0xF, 0x7 }, // 300
  { Intrinsic::riscv_vlsseg5, 0xF, 0x7 }, // 301
  { Intrinsic::riscv_vlsseg5_mask, 0xF, 0x8 }, // 302
  { Intrinsic::riscv_vlsseg6, 0xF, 0x8 }, // 303
  { Intrinsic::riscv_vlsseg6_mask, 0xF, 0x9 }, // 304
  { Intrinsic::riscv_vlsseg7, 0xF, 0x9 }, // 305
  { Intrinsic::riscv_vlsseg7_mask, 0xF, 0xA }, // 306
  { Intrinsic::riscv_vlsseg8, 0xF, 0xA }, // 307
  { Intrinsic::riscv_vlsseg8_mask, 0xF, 0xB }, // 308
  { Intrinsic::riscv_vluxei, 0xF, 0x3 }, // 309
  { Intrinsic::riscv_vluxei_mask, 0xF, 0x4 }, // 310
  { Intrinsic::riscv_vluxseg2, 0xF, 0x4 }, // 311
  { Intrinsic::riscv_vluxseg2_mask, 0xF, 0x5 }, // 312
  { Intrinsic::riscv_vluxseg3, 0xF, 0x5 }, // 313
  { Intrinsic::riscv_vluxseg3_mask, 0xF, 0x6 }, // 314
  { Intrinsic::riscv_vluxseg4, 0xF, 0x6 }, // 315
  { Intrinsic::riscv_vluxseg4_mask, 0xF, 0x7 }, // 316
  { Intrinsic::riscv_vluxseg5, 0xF, 0x7 }, // 317
  { Intrinsic::riscv_vluxseg5_mask, 0xF, 0x8 }, // 318
  { Intrinsic::riscv_vluxseg6, 0xF, 0x8 }, // 319
  { Intrinsic::riscv_vluxseg6_mask, 0xF, 0x9 }, // 320
  { Intrinsic::riscv_vluxseg7, 0xF, 0x9 }, // 321
  { Intrinsic::riscv_vluxseg7_mask, 0xF, 0xA }, // 322
  { Intrinsic::riscv_vluxseg8, 0xF, 0xA }, // 323
  { Intrinsic::riscv_vluxseg8_mask, 0xF, 0xB }, // 324
  { Intrinsic::riscv_vmacc, 0x1, 0x3 }, // 325
  { Intrinsic::riscv_vmacc_mask, 0x1, 0x4 }, // 326
  { Intrinsic::riscv_vmadc, 0x1, 0x2 }, // 327
  { Intrinsic::riscv_vmadc_carry_in, 0x1, 0x3 }, // 328
  { Intrinsic::riscv_vmadd, 0x1, 0x3 }, // 329
  { Intrinsic::riscv_vmadd_mask, 0x1, 0x4 }, // 330
  { Intrinsic::riscv_vmand, 0xF, 0x2 }, // 331
  { Intrinsic::riscv_vmandn, 0xF, 0x2 }, // 332
  { Intrinsic::riscv_vmax, 0x2, 0x3 }, // 333
  { Intrinsic::riscv_vmax_mask, 0x2, 0x4 }, // 334
  { Intrinsic::riscv_vmaxu, 0x2, 0x3 }, // 335
  { Intrinsic::riscv_vmaxu_mask, 0x2, 0x4 }, // 336
  { Intrinsic::riscv_vmclr, 0xF, 0x1 }, // 337
  { Intrinsic::riscv_vmerge, 0x2, 0x4 }, // 338
  { Intrinsic::riscv_vmfeq, 0x1, 0x2 }, // 339
  { Intrinsic::riscv_vmfeq_mask, 0x2, 0x4 }, // 340
  { Intrinsic::riscv_vmfge, 0x1, 0x2 }, // 341
  { Intrinsic::riscv_vmfge_mask, 0x2, 0x4 }, // 342
  { Intrinsic::riscv_vmfgt, 0x1, 0x2 }, // 343
  { Intrinsic::riscv_vmfgt_mask, 0x2, 0x4 }, // 344
  { Intrinsic::riscv_vmfle, 0x1, 0x2 }, // 345
  { Intrinsic::riscv_vmfle_mask, 0x2, 0x4 }, // 346
  { Intrinsic::riscv_vmflt, 0x1, 0x2 }, // 347
  { Intrinsic::riscv_vmflt_mask, 0x2, 0x4 }, // 348
  { Intrinsic::riscv_vmfne, 0x1, 0x2 }, // 349
  { Intrinsic::riscv_vmfne_mask, 0x2, 0x4 }, // 350
  { Intrinsic::riscv_vmin, 0x2, 0x3 }, // 351
  { Intrinsic::riscv_vmin_mask, 0x2, 0x4 }, // 352
  { Intrinsic::riscv_vminu, 0x2, 0x3 }, // 353
  { Intrinsic::riscv_vminu_mask, 0x2, 0x4 }, // 354
  { Intrinsic::riscv_vmnand, 0xF, 0x2 }, // 355
  { Intrinsic::riscv_vmnor, 0xF, 0x2 }, // 356
  { Intrinsic::riscv_vmor, 0xF, 0x2 }, // 357
  { Intrinsic::riscv_vmorn, 0xF, 0x2 }, // 358
  { Intrinsic::riscv_vmsbc, 0x1, 0x2 }, // 359
  { Intrinsic::riscv_vmsbc_borrow_in, 0x1, 0x3 }, // 360
  { Intrinsic::riscv_vmsbf, 0xF, 0x1 }, // 361
  { Intrinsic::riscv_vmsbf_mask, 0xF, 0x3 }, // 362
  { Intrinsic::riscv_vmseq, 0x1, 0x2 }, // 363
  { Intrinsic::riscv_vmseq_mask, 0x2, 0x4 }, // 364
  { Intrinsic::riscv_vmset, 0xF, 0x1 }, // 365
  { Intrinsic::riscv_vmsge, 0x1, 0x2 }, // 366
  { Intrinsic::riscv_vmsge_mask, 0x2, 0x4 }, // 367
  { Intrinsic::riscv_vmsgeu, 0x1, 0x2 }, // 368
  { Intrinsic::riscv_vmsgeu_mask, 0x2, 0x4 }, // 369
  { Intrinsic::riscv_vmsgt, 0x1, 0x2 }, // 370
  { Intrinsic::riscv_vmsgt_mask, 0x2, 0x4 }, // 371
  { Intrinsic::riscv_vmsgtu, 0x1, 0x2 }, // 372
  { Intrinsic::riscv_vmsgtu_mask, 0x2, 0x4 }, // 373
  { Intrinsic::riscv_vmsif, 0xF, 0x1 }, // 374
  { Intrinsic::riscv_vmsif_mask, 0xF, 0x3 }, // 375
  { Intrinsic::riscv_vmsle, 0x1, 0x2 }, // 376
  { Intrinsic::riscv_vmsle_mask, 0x2, 0x4 }, // 377
  { Intrinsic::riscv_vmsleu, 0x1, 0x2 }, // 378
  { Intrinsic::riscv_vmsleu_mask, 0x2, 0x4 }, // 379
  { Intrinsic::riscv_vmslt, 0x1, 0x2 }, // 380
  { Intrinsic::riscv_vmslt_mask, 0x2, 0x4 }, // 381
  { Intrinsic::riscv_vmsltu, 0x1, 0x2 }, // 382
  { Intrinsic::riscv_vmsltu_mask, 0x2, 0x4 }, // 383
  { Intrinsic::riscv_vmsne, 0x1, 0x2 }, // 384
  { Intrinsic::riscv_vmsne_mask, 0x2, 0x4 }, // 385
  { Intrinsic::riscv_vmsof, 0xF, 0x1 }, // 386
  { Intrinsic::riscv_vmsof_mask, 0xF, 0x3 }, // 387
  { Intrinsic::riscv_vmul, 0x2, 0x3 }, // 388
  { Intrinsic::riscv_vmul_mask, 0x2, 0x4 }, // 389
  { Intrinsic::riscv_vmulh, 0x2, 0x3 }, // 390
  { Intrinsic::riscv_vmulh_mask, 0x2, 0x4 }, // 391
  { Intrinsic::riscv_vmulhsu, 0x2, 0x3 }, // 392
  { Intrinsic::riscv_vmulhsu_mask, 0x2, 0x4 }, // 393
  { Intrinsic::riscv_vmulhu, 0x2, 0x3 }, // 394
  { Intrinsic::riscv_vmulhu_mask, 0x2, 0x4 }, // 395
  { Intrinsic::riscv_vmv_s_x, 0xF, 0x2 }, // 396
  { Intrinsic::riscv_vmv_v_v, 0xF, 0x2 }, // 397
  { Intrinsic::riscv_vmv_v_x, 0xF, 0x2 }, // 398
  { Intrinsic::riscv_vmv_x_s, 0xF, 0x1F }, // 399
  { Intrinsic::riscv_vmxnor, 0xF, 0x2 }, // 400
  { Intrinsic::riscv_vmxor, 0xF, 0x2 }, // 401
  { Intrinsic::riscv_vnclip, 0xF, 0x4 }, // 402
  { Intrinsic::riscv_vnclip_mask, 0xF, 0x5 }, // 403
  { Intrinsic::riscv_vnclipu, 0xF, 0x4 }, // 404
  { Intrinsic::riscv_vnclipu_mask, 0xF, 0x5 }, // 405
  { Intrinsic::riscv_vnmsac, 0x1, 0x3 }, // 406
  { Intrinsic::riscv_vnmsac_mask, 0x1, 0x4 }, // 407
  { Intrinsic::riscv_vnmsub, 0x1, 0x3 }, // 408
  { Intrinsic::riscv_vnmsub_mask, 0x1, 0x4 }, // 409
  { Intrinsic::riscv_vnsra, 0xF, 0x3 }, // 410
  { Intrinsic::riscv_vnsra_mask, 0xF, 0x4 }, // 411
  { Intrinsic::riscv_vnsrl, 0xF, 0x3 }, // 412
  { Intrinsic::riscv_vnsrl_mask, 0xF, 0x4 }, // 413
  { Intrinsic::riscv_vor, 0x2, 0x3 }, // 414
  { Intrinsic::riscv_vor_mask, 0x2, 0x4 }, // 415
  { Intrinsic::riscv_vredand, 0xF, 0x3 }, // 416
  { Intrinsic::riscv_vredand_mask, 0xF, 0x4 }, // 417
  { Intrinsic::riscv_vredmax, 0xF, 0x3 }, // 418
  { Intrinsic::riscv_vredmax_mask, 0xF, 0x4 }, // 419
  { Intrinsic::riscv_vredmaxu, 0xF, 0x3 }, // 420
  { Intrinsic::riscv_vredmaxu_mask, 0xF, 0x4 }, // 421
  { Intrinsic::riscv_vredmin, 0xF, 0x3 }, // 422
  { Intrinsic::riscv_vredmin_mask, 0xF, 0x4 }, // 423
  { Intrinsic::riscv_vredminu, 0xF, 0x3 }, // 424
  { Intrinsic::riscv_vredminu_mask, 0xF, 0x4 }, // 425
  { Intrinsic::riscv_vredor, 0xF, 0x3 }, // 426
  { Intrinsic::riscv_vredor_mask, 0xF, 0x4 }, // 427
  { Intrinsic::riscv_vredsum, 0xF, 0x3 }, // 428
  { Intrinsic::riscv_vredsum_mask, 0xF, 0x4 }, // 429
  { Intrinsic::riscv_vredxor, 0xF, 0x3 }, // 430
  { Intrinsic::riscv_vredxor_mask, 0xF, 0x4 }, // 431
  { Intrinsic::riscv_vrem, 0x2, 0x3 }, // 432
  { Intrinsic::riscv_vrem_mask, 0x2, 0x4 }, // 433
  { Intrinsic::riscv_vremu, 0x2, 0x3 }, // 434
  { Intrinsic::riscv_vremu_mask, 0x2, 0x4 }, // 435
  { Intrinsic::riscv_vrgather_vv, 0xF, 0x3 }, // 436
  { Intrinsic::riscv_vrgather_vv_mask, 0xF, 0x4 }, // 437
  { Intrinsic::riscv_vrgather_vx, 0xF, 0x3 }, // 438
  { Intrinsic::riscv_vrgather_vx_mask, 0xF, 0x4 }, // 439
  { Intrinsic::riscv_vrgatherei16_vv, 0xF, 0x3 }, // 440
  { Intrinsic::riscv_vrgatherei16_vv_mask, 0xF, 0x4 }, // 441
  { Intrinsic::riscv_vrsub, 0x2, 0x3 }, // 442
  { Intrinsic::riscv_vrsub_mask, 0x2, 0x4 }, // 443
  { Intrinsic::riscv_vsadd, 0x2, 0x3 }, // 444
  { Intrinsic::riscv_vsadd_mask, 0x2, 0x4 }, // 445
  { Intrinsic::riscv_vsaddu, 0x2, 0x3 }, // 446
  { Intrinsic::riscv_vsaddu_mask, 0x2, 0x4 }, // 447
  { Intrinsic::riscv_vsbc, 0x2, 0x4 }, // 448
  { Intrinsic::riscv_vse, 0xF, 0x2 }, // 449
  { Intrinsic::riscv_vse_mask, 0xF, 0x3 }, // 450
  { Intrinsic::riscv_vsext, 0xF, 0x2 }, // 451
  { Intrinsic::riscv_vsext_mask, 0xF, 0x3 }, // 452
  { Intrinsic::riscv_vslide1down, 0x2, 0x3 }, // 453
  { Intrinsic::riscv_vslide1down_mask, 0x2, 0x4 }, // 454
  { Intrinsic::riscv_vslide1up, 0x2, 0x3 }, // 455
  { Intrinsic::riscv_vslide1up_mask, 0x2, 0x4 }, // 456
  { Intrinsic::riscv_vslidedown, 0xF, 0x3 }, // 457
  { Intrinsic::riscv_vslidedown_mask, 0xF, 0x4 }, // 458
  { Intrinsic::riscv_vslideup, 0xF, 0x3 }, // 459
  { Intrinsic::riscv_vslideup_mask, 0xF, 0x4 }, // 460
  { Intrinsic::riscv_vsll, 0xF, 0x3 }, // 461
  { Intrinsic::riscv_vsll_mask, 0xF, 0x4 }, // 462
  { Intrinsic::riscv_vsm, 0xF, 0x2 }, // 463
  { Intrinsic::riscv_vsmul, 0x2, 0x4 }, // 464
  { Intrinsic::riscv_vsmul_mask, 0x2, 0x5 }, // 465
  { Intrinsic::riscv_vsoxei, 0xF, 0x3 }, // 466
  { Intrinsic::riscv_vsoxei_mask, 0xF, 0x4 }, // 467
  { Intrinsic::riscv_vsoxseg2, 0xF, 0x4 }, // 468
  { Intrinsic::riscv_vsoxseg2_mask, 0xF, 0x5 }, // 469
  { Intrinsic::riscv_vsoxseg3, 0xF, 0x5 }, // 470
  { Intrinsic::riscv_vsoxseg3_mask, 0xF, 0x6 }, // 471
  { Intrinsic::riscv_vsoxseg4, 0xF, 0x6 }, // 472
  { Intrinsic::riscv_vsoxseg4_mask, 0xF, 0x7 }, // 473
  { Intrinsic::riscv_vsoxseg5, 0xF, 0x7 }, // 474
  { Intrinsic::riscv_vsoxseg5_mask, 0xF, 0x8 }, // 475
  { Intrinsic::riscv_vsoxseg6, 0xF, 0x8 }, // 476
  { Intrinsic::riscv_vsoxseg6_mask, 0xF, 0x9 }, // 477
  { Intrinsic::riscv_vsoxseg7, 0xF, 0x9 }, // 478
  { Intrinsic::riscv_vsoxseg7_mask, 0xF, 0xA }, // 479
  { Intrinsic::riscv_vsoxseg8, 0xF, 0xA }, // 480
  { Intrinsic::riscv_vsoxseg8_mask, 0xF, 0xB }, // 481
  { Intrinsic::riscv_vsra, 0xF, 0x3 }, // 482
  { Intrinsic::riscv_vsra_mask, 0xF, 0x4 }, // 483
  { Intrinsic::riscv_vsrl, 0xF, 0x3 }, // 484
  { Intrinsic::riscv_vsrl_mask, 0xF, 0x4 }, // 485
  { Intrinsic::riscv_vsse, 0xF, 0x3 }, // 486
  { Intrinsic::riscv_vsse_mask, 0xF, 0x4 }, // 487
  { Intrinsic::riscv_vsseg2, 0xF, 0x3 }, // 488
  { Intrinsic::riscv_vsseg2_mask, 0xF, 0x4 }, // 489
  { Intrinsic::riscv_vsseg3, 0xF, 0x4 }, // 490
  { Intrinsic::riscv_vsseg3_mask, 0xF, 0x5 }, // 491
  { Intrinsic::riscv_vsseg4, 0xF, 0x5 }, // 492
  { Intrinsic::riscv_vsseg4_mask, 0xF, 0x6 }, // 493
  { Intrinsic::riscv_vsseg5, 0xF, 0x6 }, // 494
  { Intrinsic::riscv_vsseg5_mask, 0xF, 0x7 }, // 495
  { Intrinsic::riscv_vsseg6, 0xF, 0x7 }, // 496
  { Intrinsic::riscv_vsseg6_mask, 0xF, 0x8 }, // 497
  { Intrinsic::riscv_vsseg7, 0xF, 0x8 }, // 498
  { Intrinsic::riscv_vsseg7_mask, 0xF, 0x9 }, // 499
  { Intrinsic::riscv_vsseg8, 0xF, 0x9 }, // 500
  { Intrinsic::riscv_vsseg8_mask, 0xF, 0xA }, // 501
  { Intrinsic::riscv_vssra, 0xF, 0x4 }, // 502
  { Intrinsic::riscv_vssra_mask, 0xF, 0x6 }, // 503
  { Intrinsic::riscv_vssrl, 0xF, 0x4 }, // 504
  { Intrinsic::riscv_vssrl_mask, 0xF, 0x6 }, // 505
  { Intrinsic::riscv_vssseg2, 0xF, 0x4 }, // 506
  { Intrinsic::riscv_vssseg2_mask, 0xF, 0x5 }, // 507
  { Intrinsic::riscv_vssseg3, 0xF, 0x5 }, // 508
  { Intrinsic::riscv_vssseg3_mask, 0xF, 0x6 }, // 509
  { Intrinsic::riscv_vssseg4, 0xF, 0x6 }, // 510
  { Intrinsic::riscv_vssseg4_mask, 0xF, 0x7 }, // 511
  { Intrinsic::riscv_vssseg5, 0xF, 0x7 }, // 512
  { Intrinsic::riscv_vssseg5_mask, 0xF, 0x8 }, // 513
  { Intrinsic::riscv_vssseg6, 0xF, 0x8 }, // 514
  { Intrinsic::riscv_vssseg6_mask, 0xF, 0x9 }, // 515
  { Intrinsic::riscv_vssseg7, 0xF, 0x9 }, // 516
  { Intrinsic::riscv_vssseg7_mask, 0xF, 0xA }, // 517
  { Intrinsic::riscv_vssseg8, 0xF, 0xA }, // 518
  { Intrinsic::riscv_vssseg8_mask, 0xF, 0xB }, // 519
  { Intrinsic::riscv_vssub, 0x2, 0x3 }, // 520
  { Intrinsic::riscv_vssub_mask, 0x2, 0x4 }, // 521
  { Intrinsic::riscv_vssubu, 0x2, 0x3 }, // 522
  { Intrinsic::riscv_vssubu_mask, 0x2, 0x4 }, // 523
  { Intrinsic::riscv_vsub, 0x2, 0x3 }, // 524
  { Intrinsic::riscv_vsub_mask, 0x2, 0x4 }, // 525
  { Intrinsic::riscv_vsuxei, 0xF, 0x3 }, // 526
  { Intrinsic::riscv_vsuxei_mask, 0xF, 0x4 }, // 527
  { Intrinsic::riscv_vsuxseg2, 0xF, 0x4 }, // 528
  { Intrinsic::riscv_vsuxseg2_mask, 0xF, 0x5 }, // 529
  { Intrinsic::riscv_vsuxseg3, 0xF, 0x5 }, // 530
  { Intrinsic::riscv_vsuxseg3_mask, 0xF, 0x6 }, // 531
  { Intrinsic::riscv_vsuxseg4, 0xF, 0x6 }, // 532
  { Intrinsic::riscv_vsuxseg4_mask, 0xF, 0x7 }, // 533
  { Intrinsic::riscv_vsuxseg5, 0xF, 0x7 }, // 534
  { Intrinsic::riscv_vsuxseg5_mask, 0xF, 0x8 }, // 535
  { Intrinsic::riscv_vsuxseg6, 0xF, 0x8 }, // 536
  { Intrinsic::riscv_vsuxseg6_mask, 0xF, 0x9 }, // 537
  { Intrinsic::riscv_vsuxseg7, 0xF, 0x9 }, // 538
  { Intrinsic::riscv_vsuxseg7_mask, 0xF, 0xA }, // 539
  { Intrinsic::riscv_vsuxseg8, 0xF, 0xA }, // 540
  { Intrinsic::riscv_vsuxseg8_mask, 0xF, 0xB }, // 541
  { Intrinsic::riscv_vwadd, 0x2, 0x3 }, // 542
  { Intrinsic::riscv_vwadd_mask, 0x2, 0x4 }, // 543
  { Intrinsic::riscv_vwadd_w, 0x2, 0x3 }, // 544
  { Intrinsic::riscv_vwadd_w_mask, 0x2, 0x4 }, // 545
  { Intrinsic::riscv_vwaddu, 0x2, 0x3 }, // 546
  { Intrinsic::riscv_vwaddu_mask, 0x2, 0x4 }, // 547
  { Intrinsic::riscv_vwaddu_w, 0x2, 0x3 }, // 548
  { Intrinsic::riscv_vwaddu_w_mask, 0x2, 0x4 }, // 549
  { Intrinsic::riscv_vwmacc, 0x1, 0x3 }, // 550
  { Intrinsic::riscv_vwmacc_mask, 0x1, 0x4 }, // 551
  { Intrinsic::riscv_vwmaccsu, 0x1, 0x3 }, // 552
  { Intrinsic::riscv_vwmaccsu_mask, 0x1, 0x4 }, // 553
  { Intrinsic::riscv_vwmaccu, 0x1, 0x3 }, // 554
  { Intrinsic::riscv_vwmaccu_mask, 0x1, 0x4 }, // 555
  { Intrinsic::riscv_vwmaccus, 0x1, 0x3 }, // 556
  { Intrinsic::riscv_vwmaccus_mask, 0x1, 0x4 }, // 557
  { Intrinsic::riscv_vwmul, 0x2, 0x3 }, // 558
  { Intrinsic::riscv_vwmul_mask, 0x2, 0x4 }, // 559
  { Intrinsic::riscv_vwmulsu, 0x2, 0x3 }, // 560
  { Intrinsic::riscv_vwmulsu_mask, 0x2, 0x4 }, // 561
  { Intrinsic::riscv_vwmulu, 0x2, 0x3 }, // 562
  { Intrinsic::riscv_vwmulu_mask, 0x2, 0x4 }, // 563
  { Intrinsic::riscv_vwredsum, 0xF, 0x3 }, // 564
  { Intrinsic::riscv_vwredsum_mask, 0xF, 0x4 }, // 565
  { Intrinsic::riscv_vwredsumu, 0xF, 0x3 }, // 566
  { Intrinsic::riscv_vwredsumu_mask, 0xF, 0x4 }, // 567
  { Intrinsic::riscv_vwsub, 0x2, 0x3 }, // 568
  { Intrinsic::riscv_vwsub_mask, 0x2, 0x4 }, // 569
  { Intrinsic::riscv_vwsub_w, 0x2, 0x3 }, // 570
  { Intrinsic::riscv_vwsub_w_mask, 0x2, 0x4 }, // 571
  { Intrinsic::riscv_vwsubu, 0x2, 0x3 }, // 572
  { Intrinsic::riscv_vwsubu_mask, 0x2, 0x4 }, // 573
  { Intrinsic::riscv_vwsubu_w, 0x2, 0x3 }, // 574
  { Intrinsic::riscv_vwsubu_w_mask, 0x2, 0x4 }, // 575
  { Intrinsic::riscv_vxor, 0x2, 0x3 }, // 576
  { Intrinsic::riscv_vxor_mask, 0x2, 0x4 }, // 577
  { Intrinsic::riscv_vzext, 0xF, 0x2 }, // 578
  { Intrinsic::riscv_vzext_mask, 0xF, 0x3 }, // 579
 };

const RISCVVIntrinsicInfo *getRISCVVIntrinsicInfo(unsigned IntrinsicID) {
  struct KeyType {
    unsigned IntrinsicID;
  };
  KeyType Key = {IntrinsicID};
  auto Table = ArrayRef(RISCVVIntrinsicsTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVVIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.IntrinsicID < RHS.IntrinsicID)
        return true;
      if (LHS.IntrinsicID > RHS.IntrinsicID)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.IntrinsicID != Idx->IntrinsicID)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVInversePseudosTable_DECL
const PseudoInfo *getBaseInfo(unsigned BaseInstr, uint8_t VLMul, uint8_t SEW);
#endif

#ifdef GET_RISCVVInversePseudosTable_IMPL
constexpr PseudoInfo RISCVVInversePseudosTable[] = {
  { PseudoTHVdotVMAQASU_VV_M1, THVdotVMAQASU_VV, 0x0, 0x0 }, // 0
  { PseudoTHVdotVMAQASU_VV_M1_MASK, THVdotVMAQASU_VV, 0x0, 0x0 }, // 1
  { PseudoTHVdotVMAQASU_VV_M2, THVdotVMAQASU_VV, 0x1, 0x0 }, // 2
  { PseudoTHVdotVMAQASU_VV_M2_MASK, THVdotVMAQASU_VV, 0x1, 0x0 }, // 3
  { PseudoTHVdotVMAQASU_VV_M4, THVdotVMAQASU_VV, 0x2, 0x0 }, // 4
  { PseudoTHVdotVMAQASU_VV_M4_MASK, THVdotVMAQASU_VV, 0x2, 0x0 }, // 5
  { PseudoTHVdotVMAQASU_VV_M8, THVdotVMAQASU_VV, 0x3, 0x0 }, // 6
  { PseudoTHVdotVMAQASU_VV_M8_MASK, THVdotVMAQASU_VV, 0x3, 0x0 }, // 7
  { PseudoTHVdotVMAQASU_VV_MF2, THVdotVMAQASU_VV, 0x7, 0x0 }, // 8
  { PseudoTHVdotVMAQASU_VV_MF2_MASK, THVdotVMAQASU_VV, 0x7, 0x0 }, // 9
  { PseudoTHVdotVMAQASU_VX_M1, THVdotVMAQASU_VX, 0x0, 0x0 }, // 10
  { PseudoTHVdotVMAQASU_VX_M1_MASK, THVdotVMAQASU_VX, 0x0, 0x0 }, // 11
  { PseudoTHVdotVMAQASU_VX_M2, THVdotVMAQASU_VX, 0x1, 0x0 }, // 12
  { PseudoTHVdotVMAQASU_VX_M2_MASK, THVdotVMAQASU_VX, 0x1, 0x0 }, // 13
  { PseudoTHVdotVMAQASU_VX_M4, THVdotVMAQASU_VX, 0x2, 0x0 }, // 14
  { PseudoTHVdotVMAQASU_VX_M4_MASK, THVdotVMAQASU_VX, 0x2, 0x0 }, // 15
  { PseudoTHVdotVMAQASU_VX_M8, THVdotVMAQASU_VX, 0x3, 0x0 }, // 16
  { PseudoTHVdotVMAQASU_VX_M8_MASK, THVdotVMAQASU_VX, 0x3, 0x0 }, // 17
  { PseudoTHVdotVMAQASU_VX_MF2, THVdotVMAQASU_VX, 0x7, 0x0 }, // 18
  { PseudoTHVdotVMAQASU_VX_MF2_MASK, THVdotVMAQASU_VX, 0x7, 0x0 }, // 19
  { PseudoTHVdotVMAQAUS_VX_M1, THVdotVMAQAUS_VX, 0x0, 0x0 }, // 20
  { PseudoTHVdotVMAQAUS_VX_M1_MASK, THVdotVMAQAUS_VX, 0x0, 0x0 }, // 21
  { PseudoTHVdotVMAQAUS_VX_M2, THVdotVMAQAUS_VX, 0x1, 0x0 }, // 22
  { PseudoTHVdotVMAQAUS_VX_M2_MASK, THVdotVMAQAUS_VX, 0x1, 0x0 }, // 23
  { PseudoTHVdotVMAQAUS_VX_M4, THVdotVMAQAUS_VX, 0x2, 0x0 }, // 24
  { PseudoTHVdotVMAQAUS_VX_M4_MASK, THVdotVMAQAUS_VX, 0x2, 0x0 }, // 25
  { PseudoTHVdotVMAQAUS_VX_M8, THVdotVMAQAUS_VX, 0x3, 0x0 }, // 26
  { PseudoTHVdotVMAQAUS_VX_M8_MASK, THVdotVMAQAUS_VX, 0x3, 0x0 }, // 27
  { PseudoTHVdotVMAQAUS_VX_MF2, THVdotVMAQAUS_VX, 0x7, 0x0 }, // 28
  { PseudoTHVdotVMAQAUS_VX_MF2_MASK, THVdotVMAQAUS_VX, 0x7, 0x0 }, // 29
  { PseudoTHVdotVMAQAU_VV_M1, THVdotVMAQAU_VV, 0x0, 0x0 }, // 30
  { PseudoTHVdotVMAQAU_VV_M1_MASK, THVdotVMAQAU_VV, 0x0, 0x0 }, // 31
  { PseudoTHVdotVMAQAU_VV_M2, THVdotVMAQAU_VV, 0x1, 0x0 }, // 32
  { PseudoTHVdotVMAQAU_VV_M2_MASK, THVdotVMAQAU_VV, 0x1, 0x0 }, // 33
  { PseudoTHVdotVMAQAU_VV_M4, THVdotVMAQAU_VV, 0x2, 0x0 }, // 34
  { PseudoTHVdotVMAQAU_VV_M4_MASK, THVdotVMAQAU_VV, 0x2, 0x0 }, // 35
  { PseudoTHVdotVMAQAU_VV_M8, THVdotVMAQAU_VV, 0x3, 0x0 }, // 36
  { PseudoTHVdotVMAQAU_VV_M8_MASK, THVdotVMAQAU_VV, 0x3, 0x0 }, // 37
  { PseudoTHVdotVMAQAU_VV_MF2, THVdotVMAQAU_VV, 0x7, 0x0 }, // 38
  { PseudoTHVdotVMAQAU_VV_MF2_MASK, THVdotVMAQAU_VV, 0x7, 0x0 }, // 39
  { PseudoTHVdotVMAQAU_VX_M1, THVdotVMAQAU_VX, 0x0, 0x0 }, // 40
  { PseudoTHVdotVMAQAU_VX_M1_MASK, THVdotVMAQAU_VX, 0x0, 0x0 }, // 41
  { PseudoTHVdotVMAQAU_VX_M2, THVdotVMAQAU_VX, 0x1, 0x0 }, // 42
  { PseudoTHVdotVMAQAU_VX_M2_MASK, THVdotVMAQAU_VX, 0x1, 0x0 }, // 43
  { PseudoTHVdotVMAQAU_VX_M4, THVdotVMAQAU_VX, 0x2, 0x0 }, // 44
  { PseudoTHVdotVMAQAU_VX_M4_MASK, THVdotVMAQAU_VX, 0x2, 0x0 }, // 45
  { PseudoTHVdotVMAQAU_VX_M8, THVdotVMAQAU_VX, 0x3, 0x0 }, // 46
  { PseudoTHVdotVMAQAU_VX_M8_MASK, THVdotVMAQAU_VX, 0x3, 0x0 }, // 47
  { PseudoTHVdotVMAQAU_VX_MF2, THVdotVMAQAU_VX, 0x7, 0x0 }, // 48
  { PseudoTHVdotVMAQAU_VX_MF2_MASK, THVdotVMAQAU_VX, 0x7, 0x0 }, // 49
  { PseudoTHVdotVMAQA_VV_M1, THVdotVMAQA_VV, 0x0, 0x0 }, // 50
  { PseudoTHVdotVMAQA_VV_M1_MASK, THVdotVMAQA_VV, 0x0, 0x0 }, // 51
  { PseudoTHVdotVMAQA_VV_M2, THVdotVMAQA_VV, 0x1, 0x0 }, // 52
  { PseudoTHVdotVMAQA_VV_M2_MASK, THVdotVMAQA_VV, 0x1, 0x0 }, // 53
  { PseudoTHVdotVMAQA_VV_M4, THVdotVMAQA_VV, 0x2, 0x0 }, // 54
  { PseudoTHVdotVMAQA_VV_M4_MASK, THVdotVMAQA_VV, 0x2, 0x0 }, // 55
  { PseudoTHVdotVMAQA_VV_M8, THVdotVMAQA_VV, 0x3, 0x0 }, // 56
  { PseudoTHVdotVMAQA_VV_M8_MASK, THVdotVMAQA_VV, 0x3, 0x0 }, // 57
  { PseudoTHVdotVMAQA_VV_MF2, THVdotVMAQA_VV, 0x7, 0x0 }, // 58
  { PseudoTHVdotVMAQA_VV_MF2_MASK, THVdotVMAQA_VV, 0x7, 0x0 }, // 59
  { PseudoTHVdotVMAQA_VX_M1, THVdotVMAQA_VX, 0x0, 0x0 }, // 60
  { PseudoTHVdotVMAQA_VX_M1_MASK, THVdotVMAQA_VX, 0x0, 0x0 }, // 61
  { PseudoTHVdotVMAQA_VX_M2, THVdotVMAQA_VX, 0x1, 0x0 }, // 62
  { PseudoTHVdotVMAQA_VX_M2_MASK, THVdotVMAQA_VX, 0x1, 0x0 }, // 63
  { PseudoTHVdotVMAQA_VX_M4, THVdotVMAQA_VX, 0x2, 0x0 }, // 64
  { PseudoTHVdotVMAQA_VX_M4_MASK, THVdotVMAQA_VX, 0x2, 0x0 }, // 65
  { PseudoTHVdotVMAQA_VX_M8, THVdotVMAQA_VX, 0x3, 0x0 }, // 66
  { PseudoTHVdotVMAQA_VX_M8_MASK, THVdotVMAQA_VX, 0x3, 0x0 }, // 67
  { PseudoTHVdotVMAQA_VX_MF2, THVdotVMAQA_VX, 0x7, 0x0 }, // 68
  { PseudoTHVdotVMAQA_VX_MF2_MASK, THVdotVMAQA_VX, 0x7, 0x0 }, // 69
  { PseudoVAADDU_VV_M1, VAADDU_VV, 0x0, 0x0 }, // 70
  { PseudoVAADDU_VV_M1_MASK, VAADDU_VV, 0x0, 0x0 }, // 71
  { PseudoVAADDU_VV_M2, VAADDU_VV, 0x1, 0x0 }, // 72
  { PseudoVAADDU_VV_M2_MASK, VAADDU_VV, 0x1, 0x0 }, // 73
  { PseudoVAADDU_VV_M4, VAADDU_VV, 0x2, 0x0 }, // 74
  { PseudoVAADDU_VV_M4_MASK, VAADDU_VV, 0x2, 0x0 }, // 75
  { PseudoVAADDU_VV_M8, VAADDU_VV, 0x3, 0x0 }, // 76
  { PseudoVAADDU_VV_M8_MASK, VAADDU_VV, 0x3, 0x0 }, // 77
  { PseudoVAADDU_VV_MF8, VAADDU_VV, 0x5, 0x0 }, // 78
  { PseudoVAADDU_VV_MF8_MASK, VAADDU_VV, 0x5, 0x0 }, // 79
  { PseudoVAADDU_VV_MF4, VAADDU_VV, 0x6, 0x0 }, // 80
  { PseudoVAADDU_VV_MF4_MASK, VAADDU_VV, 0x6, 0x0 }, // 81
  { PseudoVAADDU_VV_MF2, VAADDU_VV, 0x7, 0x0 }, // 82
  { PseudoVAADDU_VV_MF2_MASK, VAADDU_VV, 0x7, 0x0 }, // 83
  { PseudoVAADDU_VX_M1, VAADDU_VX, 0x0, 0x0 }, // 84
  { PseudoVAADDU_VX_M1_MASK, VAADDU_VX, 0x0, 0x0 }, // 85
  { PseudoVAADDU_VX_M2, VAADDU_VX, 0x1, 0x0 }, // 86
  { PseudoVAADDU_VX_M2_MASK, VAADDU_VX, 0x1, 0x0 }, // 87
  { PseudoVAADDU_VX_M4, VAADDU_VX, 0x2, 0x0 }, // 88
  { PseudoVAADDU_VX_M4_MASK, VAADDU_VX, 0x2, 0x0 }, // 89
  { PseudoVAADDU_VX_M8, VAADDU_VX, 0x3, 0x0 }, // 90
  { PseudoVAADDU_VX_M8_MASK, VAADDU_VX, 0x3, 0x0 }, // 91
  { PseudoVAADDU_VX_MF8, VAADDU_VX, 0x5, 0x0 }, // 92
  { PseudoVAADDU_VX_MF8_MASK, VAADDU_VX, 0x5, 0x0 }, // 93
  { PseudoVAADDU_VX_MF4, VAADDU_VX, 0x6, 0x0 }, // 94
  { PseudoVAADDU_VX_MF4_MASK, VAADDU_VX, 0x6, 0x0 }, // 95
  { PseudoVAADDU_VX_MF2, VAADDU_VX, 0x7, 0x0 }, // 96
  { PseudoVAADDU_VX_MF2_MASK, VAADDU_VX, 0x7, 0x0 }, // 97
  { PseudoVAADD_VV_M1, VAADD_VV, 0x0, 0x0 }, // 98
  { PseudoVAADD_VV_M1_MASK, VAADD_VV, 0x0, 0x0 }, // 99
  { PseudoVAADD_VV_M2, VAADD_VV, 0x1, 0x0 }, // 100
  { PseudoVAADD_VV_M2_MASK, VAADD_VV, 0x1, 0x0 }, // 101
  { PseudoVAADD_VV_M4, VAADD_VV, 0x2, 0x0 }, // 102
  { PseudoVAADD_VV_M4_MASK, VAADD_VV, 0x2, 0x0 }, // 103
  { PseudoVAADD_VV_M8, VAADD_VV, 0x3, 0x0 }, // 104
  { PseudoVAADD_VV_M8_MASK, VAADD_VV, 0x3, 0x0 }, // 105
  { PseudoVAADD_VV_MF8, VAADD_VV, 0x5, 0x0 }, // 106
  { PseudoVAADD_VV_MF8_MASK, VAADD_VV, 0x5, 0x0 }, // 107
  { PseudoVAADD_VV_MF4, VAADD_VV, 0x6, 0x0 }, // 108
  { PseudoVAADD_VV_MF4_MASK, VAADD_VV, 0x6, 0x0 }, // 109
  { PseudoVAADD_VV_MF2, VAADD_VV, 0x7, 0x0 }, // 110
  { PseudoVAADD_VV_MF2_MASK, VAADD_VV, 0x7, 0x0 }, // 111
  { PseudoVAADD_VX_M1, VAADD_VX, 0x0, 0x0 }, // 112
  { PseudoVAADD_VX_M1_MASK, VAADD_VX, 0x0, 0x0 }, // 113
  { PseudoVAADD_VX_M2, VAADD_VX, 0x1, 0x0 }, // 114
  { PseudoVAADD_VX_M2_MASK, VAADD_VX, 0x1, 0x0 }, // 115
  { PseudoVAADD_VX_M4, VAADD_VX, 0x2, 0x0 }, // 116
  { PseudoVAADD_VX_M4_MASK, VAADD_VX, 0x2, 0x0 }, // 117
  { PseudoVAADD_VX_M8, VAADD_VX, 0x3, 0x0 }, // 118
  { PseudoVAADD_VX_M8_MASK, VAADD_VX, 0x3, 0x0 }, // 119
  { PseudoVAADD_VX_MF8, VAADD_VX, 0x5, 0x0 }, // 120
  { PseudoVAADD_VX_MF8_MASK, VAADD_VX, 0x5, 0x0 }, // 121
  { PseudoVAADD_VX_MF4, VAADD_VX, 0x6, 0x0 }, // 122
  { PseudoVAADD_VX_MF4_MASK, VAADD_VX, 0x6, 0x0 }, // 123
  { PseudoVAADD_VX_MF2, VAADD_VX, 0x7, 0x0 }, // 124
  { PseudoVAADD_VX_MF2_MASK, VAADD_VX, 0x7, 0x0 }, // 125
  { PseudoVADC_VIM_M1, VADC_VIM, 0x0, 0x0 }, // 126
  { PseudoVADC_VIM_M2, VADC_VIM, 0x1, 0x0 }, // 127
  { PseudoVADC_VIM_M4, VADC_VIM, 0x2, 0x0 }, // 128
  { PseudoVADC_VIM_M8, VADC_VIM, 0x3, 0x0 }, // 129
  { PseudoVADC_VIM_MF8, VADC_VIM, 0x5, 0x0 }, // 130
  { PseudoVADC_VIM_MF4, VADC_VIM, 0x6, 0x0 }, // 131
  { PseudoVADC_VIM_MF2, VADC_VIM, 0x7, 0x0 }, // 132
  { PseudoVADC_VVM_M1, VADC_VVM, 0x0, 0x0 }, // 133
  { PseudoVADC_VVM_M2, VADC_VVM, 0x1, 0x0 }, // 134
  { PseudoVADC_VVM_M4, VADC_VVM, 0x2, 0x0 }, // 135
  { PseudoVADC_VVM_M8, VADC_VVM, 0x3, 0x0 }, // 136
  { PseudoVADC_VVM_MF8, VADC_VVM, 0x5, 0x0 }, // 137
  { PseudoVADC_VVM_MF4, VADC_VVM, 0x6, 0x0 }, // 138
  { PseudoVADC_VVM_MF2, VADC_VVM, 0x7, 0x0 }, // 139
  { PseudoVADC_VXM_M1, VADC_VXM, 0x0, 0x0 }, // 140
  { PseudoVADC_VXM_M2, VADC_VXM, 0x1, 0x0 }, // 141
  { PseudoVADC_VXM_M4, VADC_VXM, 0x2, 0x0 }, // 142
  { PseudoVADC_VXM_M8, VADC_VXM, 0x3, 0x0 }, // 143
  { PseudoVADC_VXM_MF8, VADC_VXM, 0x5, 0x0 }, // 144
  { PseudoVADC_VXM_MF4, VADC_VXM, 0x6, 0x0 }, // 145
  { PseudoVADC_VXM_MF2, VADC_VXM, 0x7, 0x0 }, // 146
  { PseudoVADD_VI_M1, VADD_VI, 0x0, 0x0 }, // 147
  { PseudoVADD_VI_M1_MASK, VADD_VI, 0x0, 0x0 }, // 148
  { PseudoVADD_VI_M2, VADD_VI, 0x1, 0x0 }, // 149
  { PseudoVADD_VI_M2_MASK, VADD_VI, 0x1, 0x0 }, // 150
  { PseudoVADD_VI_M4, VADD_VI, 0x2, 0x0 }, // 151
  { PseudoVADD_VI_M4_MASK, VADD_VI, 0x2, 0x0 }, // 152
  { PseudoVADD_VI_M8, VADD_VI, 0x3, 0x0 }, // 153
  { PseudoVADD_VI_M8_MASK, VADD_VI, 0x3, 0x0 }, // 154
  { PseudoVADD_VI_MF8, VADD_VI, 0x5, 0x0 }, // 155
  { PseudoVADD_VI_MF8_MASK, VADD_VI, 0x5, 0x0 }, // 156
  { PseudoVADD_VI_MF4, VADD_VI, 0x6, 0x0 }, // 157
  { PseudoVADD_VI_MF4_MASK, VADD_VI, 0x6, 0x0 }, // 158
  { PseudoVADD_VI_MF2, VADD_VI, 0x7, 0x0 }, // 159
  { PseudoVADD_VI_MF2_MASK, VADD_VI, 0x7, 0x0 }, // 160
  { PseudoVADD_VV_M1, VADD_VV, 0x0, 0x0 }, // 161
  { PseudoVADD_VV_M1_MASK, VADD_VV, 0x0, 0x0 }, // 162
  { PseudoVADD_VV_M2, VADD_VV, 0x1, 0x0 }, // 163
  { PseudoVADD_VV_M2_MASK, VADD_VV, 0x1, 0x0 }, // 164
  { PseudoVADD_VV_M4, VADD_VV, 0x2, 0x0 }, // 165
  { PseudoVADD_VV_M4_MASK, VADD_VV, 0x2, 0x0 }, // 166
  { PseudoVADD_VV_M8, VADD_VV, 0x3, 0x0 }, // 167
  { PseudoVADD_VV_M8_MASK, VADD_VV, 0x3, 0x0 }, // 168
  { PseudoVADD_VV_MF8, VADD_VV, 0x5, 0x0 }, // 169
  { PseudoVADD_VV_MF8_MASK, VADD_VV, 0x5, 0x0 }, // 170
  { PseudoVADD_VV_MF4, VADD_VV, 0x6, 0x0 }, // 171
  { PseudoVADD_VV_MF4_MASK, VADD_VV, 0x6, 0x0 }, // 172
  { PseudoVADD_VV_MF2, VADD_VV, 0x7, 0x0 }, // 173
  { PseudoVADD_VV_MF2_MASK, VADD_VV, 0x7, 0x0 }, // 174
  { PseudoVADD_VX_M1, VADD_VX, 0x0, 0x0 }, // 175
  { PseudoVADD_VX_M1_MASK, VADD_VX, 0x0, 0x0 }, // 176
  { PseudoVADD_VX_M2, VADD_VX, 0x1, 0x0 }, // 177
  { PseudoVADD_VX_M2_MASK, VADD_VX, 0x1, 0x0 }, // 178
  { PseudoVADD_VX_M4, VADD_VX, 0x2, 0x0 }, // 179
  { PseudoVADD_VX_M4_MASK, VADD_VX, 0x2, 0x0 }, // 180
  { PseudoVADD_VX_M8, VADD_VX, 0x3, 0x0 }, // 181
  { PseudoVADD_VX_M8_MASK, VADD_VX, 0x3, 0x0 }, // 182
  { PseudoVADD_VX_MF8, VADD_VX, 0x5, 0x0 }, // 183
  { PseudoVADD_VX_MF8_MASK, VADD_VX, 0x5, 0x0 }, // 184
  { PseudoVADD_VX_MF4, VADD_VX, 0x6, 0x0 }, // 185
  { PseudoVADD_VX_MF4_MASK, VADD_VX, 0x6, 0x0 }, // 186
  { PseudoVADD_VX_MF2, VADD_VX, 0x7, 0x0 }, // 187
  { PseudoVADD_VX_MF2_MASK, VADD_VX, 0x7, 0x0 }, // 188
  { PseudoVANDN_VV_M1, VANDN_VV, 0x0, 0x0 }, // 189
  { PseudoVANDN_VV_M1_MASK, VANDN_VV, 0x0, 0x0 }, // 190
  { PseudoVANDN_VV_M2, VANDN_VV, 0x1, 0x0 }, // 191
  { PseudoVANDN_VV_M2_MASK, VANDN_VV, 0x1, 0x0 }, // 192
  { PseudoVANDN_VV_M4, VANDN_VV, 0x2, 0x0 }, // 193
  { PseudoVANDN_VV_M4_MASK, VANDN_VV, 0x2, 0x0 }, // 194
  { PseudoVANDN_VV_M8, VANDN_VV, 0x3, 0x0 }, // 195
  { PseudoVANDN_VV_M8_MASK, VANDN_VV, 0x3, 0x0 }, // 196
  { PseudoVANDN_VV_MF8, VANDN_VV, 0x5, 0x0 }, // 197
  { PseudoVANDN_VV_MF8_MASK, VANDN_VV, 0x5, 0x0 }, // 198
  { PseudoVANDN_VV_MF4, VANDN_VV, 0x6, 0x0 }, // 199
  { PseudoVANDN_VV_MF4_MASK, VANDN_VV, 0x6, 0x0 }, // 200
  { PseudoVANDN_VV_MF2, VANDN_VV, 0x7, 0x0 }, // 201
  { PseudoVANDN_VV_MF2_MASK, VANDN_VV, 0x7, 0x0 }, // 202
  { PseudoVANDN_VX_M1, VANDN_VX, 0x0, 0x0 }, // 203
  { PseudoVANDN_VX_M1_MASK, VANDN_VX, 0x0, 0x0 }, // 204
  { PseudoVANDN_VX_M2, VANDN_VX, 0x1, 0x0 }, // 205
  { PseudoVANDN_VX_M2_MASK, VANDN_VX, 0x1, 0x0 }, // 206
  { PseudoVANDN_VX_M4, VANDN_VX, 0x2, 0x0 }, // 207
  { PseudoVANDN_VX_M4_MASK, VANDN_VX, 0x2, 0x0 }, // 208
  { PseudoVANDN_VX_M8, VANDN_VX, 0x3, 0x0 }, // 209
  { PseudoVANDN_VX_M8_MASK, VANDN_VX, 0x3, 0x0 }, // 210
  { PseudoVANDN_VX_MF8, VANDN_VX, 0x5, 0x0 }, // 211
  { PseudoVANDN_VX_MF8_MASK, VANDN_VX, 0x5, 0x0 }, // 212
  { PseudoVANDN_VX_MF4, VANDN_VX, 0x6, 0x0 }, // 213
  { PseudoVANDN_VX_MF4_MASK, VANDN_VX, 0x6, 0x0 }, // 214
  { PseudoVANDN_VX_MF2, VANDN_VX, 0x7, 0x0 }, // 215
  { PseudoVANDN_VX_MF2_MASK, VANDN_VX, 0x7, 0x0 }, // 216
  { PseudoVAND_VI_M1, VAND_VI, 0x0, 0x0 }, // 217
  { PseudoVAND_VI_M1_MASK, VAND_VI, 0x0, 0x0 }, // 218
  { PseudoVAND_VI_M2, VAND_VI, 0x1, 0x0 }, // 219
  { PseudoVAND_VI_M2_MASK, VAND_VI, 0x1, 0x0 }, // 220
  { PseudoVAND_VI_M4, VAND_VI, 0x2, 0x0 }, // 221
  { PseudoVAND_VI_M4_MASK, VAND_VI, 0x2, 0x0 }, // 222
  { PseudoVAND_VI_M8, VAND_VI, 0x3, 0x0 }, // 223
  { PseudoVAND_VI_M8_MASK, VAND_VI, 0x3, 0x0 }, // 224
  { PseudoVAND_VI_MF8, VAND_VI, 0x5, 0x0 }, // 225
  { PseudoVAND_VI_MF8_MASK, VAND_VI, 0x5, 0x0 }, // 226
  { PseudoVAND_VI_MF4, VAND_VI, 0x6, 0x0 }, // 227
  { PseudoVAND_VI_MF4_MASK, VAND_VI, 0x6, 0x0 }, // 228
  { PseudoVAND_VI_MF2, VAND_VI, 0x7, 0x0 }, // 229
  { PseudoVAND_VI_MF2_MASK, VAND_VI, 0x7, 0x0 }, // 230
  { PseudoVAND_VV_M1, VAND_VV, 0x0, 0x0 }, // 231
  { PseudoVAND_VV_M1_MASK, VAND_VV, 0x0, 0x0 }, // 232
  { PseudoVAND_VV_M2, VAND_VV, 0x1, 0x0 }, // 233
  { PseudoVAND_VV_M2_MASK, VAND_VV, 0x1, 0x0 }, // 234
  { PseudoVAND_VV_M4, VAND_VV, 0x2, 0x0 }, // 235
  { PseudoVAND_VV_M4_MASK, VAND_VV, 0x2, 0x0 }, // 236
  { PseudoVAND_VV_M8, VAND_VV, 0x3, 0x0 }, // 237
  { PseudoVAND_VV_M8_MASK, VAND_VV, 0x3, 0x0 }, // 238
  { PseudoVAND_VV_MF8, VAND_VV, 0x5, 0x0 }, // 239
  { PseudoVAND_VV_MF8_MASK, VAND_VV, 0x5, 0x0 }, // 240
  { PseudoVAND_VV_MF4, VAND_VV, 0x6, 0x0 }, // 241
  { PseudoVAND_VV_MF4_MASK, VAND_VV, 0x6, 0x0 }, // 242
  { PseudoVAND_VV_MF2, VAND_VV, 0x7, 0x0 }, // 243
  { PseudoVAND_VV_MF2_MASK, VAND_VV, 0x7, 0x0 }, // 244
  { PseudoVAND_VX_M1, VAND_VX, 0x0, 0x0 }, // 245
  { PseudoVAND_VX_M1_MASK, VAND_VX, 0x0, 0x0 }, // 246
  { PseudoVAND_VX_M2, VAND_VX, 0x1, 0x0 }, // 247
  { PseudoVAND_VX_M2_MASK, VAND_VX, 0x1, 0x0 }, // 248
  { PseudoVAND_VX_M4, VAND_VX, 0x2, 0x0 }, // 249
  { PseudoVAND_VX_M4_MASK, VAND_VX, 0x2, 0x0 }, // 250
  { PseudoVAND_VX_M8, VAND_VX, 0x3, 0x0 }, // 251
  { PseudoVAND_VX_M8_MASK, VAND_VX, 0x3, 0x0 }, // 252
  { PseudoVAND_VX_MF8, VAND_VX, 0x5, 0x0 }, // 253
  { PseudoVAND_VX_MF8_MASK, VAND_VX, 0x5, 0x0 }, // 254
  { PseudoVAND_VX_MF4, VAND_VX, 0x6, 0x0 }, // 255
  { PseudoVAND_VX_MF4_MASK, VAND_VX, 0x6, 0x0 }, // 256
  { PseudoVAND_VX_MF2, VAND_VX, 0x7, 0x0 }, // 257
  { PseudoVAND_VX_MF2_MASK, VAND_VX, 0x7, 0x0 }, // 258
  { PseudoVASUBU_VV_M1, VASUBU_VV, 0x0, 0x0 }, // 259
  { PseudoVASUBU_VV_M1_MASK, VASUBU_VV, 0x0, 0x0 }, // 260
  { PseudoVASUBU_VV_M2, VASUBU_VV, 0x1, 0x0 }, // 261
  { PseudoVASUBU_VV_M2_MASK, VASUBU_VV, 0x1, 0x0 }, // 262
  { PseudoVASUBU_VV_M4, VASUBU_VV, 0x2, 0x0 }, // 263
  { PseudoVASUBU_VV_M4_MASK, VASUBU_VV, 0x2, 0x0 }, // 264
  { PseudoVASUBU_VV_M8, VASUBU_VV, 0x3, 0x0 }, // 265
  { PseudoVASUBU_VV_M8_MASK, VASUBU_VV, 0x3, 0x0 }, // 266
  { PseudoVASUBU_VV_MF8, VASUBU_VV, 0x5, 0x0 }, // 267
  { PseudoVASUBU_VV_MF8_MASK, VASUBU_VV, 0x5, 0x0 }, // 268
  { PseudoVASUBU_VV_MF4, VASUBU_VV, 0x6, 0x0 }, // 269
  { PseudoVASUBU_VV_MF4_MASK, VASUBU_VV, 0x6, 0x0 }, // 270
  { PseudoVASUBU_VV_MF2, VASUBU_VV, 0x7, 0x0 }, // 271
  { PseudoVASUBU_VV_MF2_MASK, VASUBU_VV, 0x7, 0x0 }, // 272
  { PseudoVASUBU_VX_M1, VASUBU_VX, 0x0, 0x0 }, // 273
  { PseudoVASUBU_VX_M1_MASK, VASUBU_VX, 0x0, 0x0 }, // 274
  { PseudoVASUBU_VX_M2, VASUBU_VX, 0x1, 0x0 }, // 275
  { PseudoVASUBU_VX_M2_MASK, VASUBU_VX, 0x1, 0x0 }, // 276
  { PseudoVASUBU_VX_M4, VASUBU_VX, 0x2, 0x0 }, // 277
  { PseudoVASUBU_VX_M4_MASK, VASUBU_VX, 0x2, 0x0 }, // 278
  { PseudoVASUBU_VX_M8, VASUBU_VX, 0x3, 0x0 }, // 279
  { PseudoVASUBU_VX_M8_MASK, VASUBU_VX, 0x3, 0x0 }, // 280
  { PseudoVASUBU_VX_MF8, VASUBU_VX, 0x5, 0x0 }, // 281
  { PseudoVASUBU_VX_MF8_MASK, VASUBU_VX, 0x5, 0x0 }, // 282
  { PseudoVASUBU_VX_MF4, VASUBU_VX, 0x6, 0x0 }, // 283
  { PseudoVASUBU_VX_MF4_MASK, VASUBU_VX, 0x6, 0x0 }, // 284
  { PseudoVASUBU_VX_MF2, VASUBU_VX, 0x7, 0x0 }, // 285
  { PseudoVASUBU_VX_MF2_MASK, VASUBU_VX, 0x7, 0x0 }, // 286
  { PseudoVASUB_VV_M1, VASUB_VV, 0x0, 0x0 }, // 287
  { PseudoVASUB_VV_M1_MASK, VASUB_VV, 0x0, 0x0 }, // 288
  { PseudoVASUB_VV_M2, VASUB_VV, 0x1, 0x0 }, // 289
  { PseudoVASUB_VV_M2_MASK, VASUB_VV, 0x1, 0x0 }, // 290
  { PseudoVASUB_VV_M4, VASUB_VV, 0x2, 0x0 }, // 291
  { PseudoVASUB_VV_M4_MASK, VASUB_VV, 0x2, 0x0 }, // 292
  { PseudoVASUB_VV_M8, VASUB_VV, 0x3, 0x0 }, // 293
  { PseudoVASUB_VV_M8_MASK, VASUB_VV, 0x3, 0x0 }, // 294
  { PseudoVASUB_VV_MF8, VASUB_VV, 0x5, 0x0 }, // 295
  { PseudoVASUB_VV_MF8_MASK, VASUB_VV, 0x5, 0x0 }, // 296
  { PseudoVASUB_VV_MF4, VASUB_VV, 0x6, 0x0 }, // 297
  { PseudoVASUB_VV_MF4_MASK, VASUB_VV, 0x6, 0x0 }, // 298
  { PseudoVASUB_VV_MF2, VASUB_VV, 0x7, 0x0 }, // 299
  { PseudoVASUB_VV_MF2_MASK, VASUB_VV, 0x7, 0x0 }, // 300
  { PseudoVASUB_VX_M1, VASUB_VX, 0x0, 0x0 }, // 301
  { PseudoVASUB_VX_M1_MASK, VASUB_VX, 0x0, 0x0 }, // 302
  { PseudoVASUB_VX_M2, VASUB_VX, 0x1, 0x0 }, // 303
  { PseudoVASUB_VX_M2_MASK, VASUB_VX, 0x1, 0x0 }, // 304
  { PseudoVASUB_VX_M4, VASUB_VX, 0x2, 0x0 }, // 305
  { PseudoVASUB_VX_M4_MASK, VASUB_VX, 0x2, 0x0 }, // 306
  { PseudoVASUB_VX_M8, VASUB_VX, 0x3, 0x0 }, // 307
  { PseudoVASUB_VX_M8_MASK, VASUB_VX, 0x3, 0x0 }, // 308
  { PseudoVASUB_VX_MF8, VASUB_VX, 0x5, 0x0 }, // 309
  { PseudoVASUB_VX_MF8_MASK, VASUB_VX, 0x5, 0x0 }, // 310
  { PseudoVASUB_VX_MF4, VASUB_VX, 0x6, 0x0 }, // 311
  { PseudoVASUB_VX_MF4_MASK, VASUB_VX, 0x6, 0x0 }, // 312
  { PseudoVASUB_VX_MF2, VASUB_VX, 0x7, 0x0 }, // 313
  { PseudoVASUB_VX_MF2_MASK, VASUB_VX, 0x7, 0x0 }, // 314
  { PseudoVBREV_V_M1, VBREV_V, 0x0, 0x0 }, // 315
  { PseudoVBREV_V_M1_MASK, VBREV_V, 0x0, 0x0 }, // 316
  { PseudoVBREV_V_M2, VBREV_V, 0x1, 0x0 }, // 317
  { PseudoVBREV_V_M2_MASK, VBREV_V, 0x1, 0x0 }, // 318
  { PseudoVBREV_V_M4, VBREV_V, 0x2, 0x0 }, // 319
  { PseudoVBREV_V_M4_MASK, VBREV_V, 0x2, 0x0 }, // 320
  { PseudoVBREV_V_M8, VBREV_V, 0x3, 0x0 }, // 321
  { PseudoVBREV_V_M8_MASK, VBREV_V, 0x3, 0x0 }, // 322
  { PseudoVBREV_V_MF8, VBREV_V, 0x5, 0x0 }, // 323
  { PseudoVBREV_V_MF8_MASK, VBREV_V, 0x5, 0x0 }, // 324
  { PseudoVBREV_V_MF4, VBREV_V, 0x6, 0x0 }, // 325
  { PseudoVBREV_V_MF4_MASK, VBREV_V, 0x6, 0x0 }, // 326
  { PseudoVBREV_V_MF2, VBREV_V, 0x7, 0x0 }, // 327
  { PseudoVBREV_V_MF2_MASK, VBREV_V, 0x7, 0x0 }, // 328
  { PseudoVCLZ_V_M1, VCLZ_V, 0x0, 0x0 }, // 329
  { PseudoVCLZ_V_M1_MASK, VCLZ_V, 0x0, 0x0 }, // 330
  { PseudoVCLZ_V_M2, VCLZ_V, 0x1, 0x0 }, // 331
  { PseudoVCLZ_V_M2_MASK, VCLZ_V, 0x1, 0x0 }, // 332
  { PseudoVCLZ_V_M4, VCLZ_V, 0x2, 0x0 }, // 333
  { PseudoVCLZ_V_M4_MASK, VCLZ_V, 0x2, 0x0 }, // 334
  { PseudoVCLZ_V_M8, VCLZ_V, 0x3, 0x0 }, // 335
  { PseudoVCLZ_V_M8_MASK, VCLZ_V, 0x3, 0x0 }, // 336
  { PseudoVCLZ_V_MF8, VCLZ_V, 0x5, 0x0 }, // 337
  { PseudoVCLZ_V_MF8_MASK, VCLZ_V, 0x5, 0x0 }, // 338
  { PseudoVCLZ_V_MF4, VCLZ_V, 0x6, 0x0 }, // 339
  { PseudoVCLZ_V_MF4_MASK, VCLZ_V, 0x6, 0x0 }, // 340
  { PseudoVCLZ_V_MF2, VCLZ_V, 0x7, 0x0 }, // 341
  { PseudoVCLZ_V_MF2_MASK, VCLZ_V, 0x7, 0x0 }, // 342
  { PseudoVCOMPRESS_VM_M1_E8, VCOMPRESS_VM, 0x0, 0x8 }, // 343
  { PseudoVCOMPRESS_VM_M1_E16, VCOMPRESS_VM, 0x0, 0x10 }, // 344
  { PseudoVCOMPRESS_VM_M1_E32, VCOMPRESS_VM, 0x0, 0x20 }, // 345
  { PseudoVCOMPRESS_VM_M1_E64, VCOMPRESS_VM, 0x0, 0x40 }, // 346
  { PseudoVCOMPRESS_VM_M2_E8, VCOMPRESS_VM, 0x1, 0x8 }, // 347
  { PseudoVCOMPRESS_VM_M2_E16, VCOMPRESS_VM, 0x1, 0x10 }, // 348
  { PseudoVCOMPRESS_VM_M2_E32, VCOMPRESS_VM, 0x1, 0x20 }, // 349
  { PseudoVCOMPRESS_VM_M2_E64, VCOMPRESS_VM, 0x1, 0x40 }, // 350
  { PseudoVCOMPRESS_VM_M4_E8, VCOMPRESS_VM, 0x2, 0x8 }, // 351
  { PseudoVCOMPRESS_VM_M4_E16, VCOMPRESS_VM, 0x2, 0x10 }, // 352
  { PseudoVCOMPRESS_VM_M4_E32, VCOMPRESS_VM, 0x2, 0x20 }, // 353
  { PseudoVCOMPRESS_VM_M4_E64, VCOMPRESS_VM, 0x2, 0x40 }, // 354
  { PseudoVCOMPRESS_VM_M8_E8, VCOMPRESS_VM, 0x3, 0x8 }, // 355
  { PseudoVCOMPRESS_VM_M8_E16, VCOMPRESS_VM, 0x3, 0x10 }, // 356
  { PseudoVCOMPRESS_VM_M8_E32, VCOMPRESS_VM, 0x3, 0x20 }, // 357
  { PseudoVCOMPRESS_VM_M8_E64, VCOMPRESS_VM, 0x3, 0x40 }, // 358
  { PseudoVCOMPRESS_VM_MF8_E8, VCOMPRESS_VM, 0x5, 0x8 }, // 359
  { PseudoVCOMPRESS_VM_MF4_E8, VCOMPRESS_VM, 0x6, 0x8 }, // 360
  { PseudoVCOMPRESS_VM_MF4_E16, VCOMPRESS_VM, 0x6, 0x10 }, // 361
  { PseudoVCOMPRESS_VM_MF2_E8, VCOMPRESS_VM, 0x7, 0x8 }, // 362
  { PseudoVCOMPRESS_VM_MF2_E16, VCOMPRESS_VM, 0x7, 0x10 }, // 363
  { PseudoVCOMPRESS_VM_MF2_E32, VCOMPRESS_VM, 0x7, 0x20 }, // 364
  { PseudoVCPOP_M_B8, VCPOP_M, 0x0, 0x0 }, // 365
  { PseudoVCPOP_M_B8_MASK, VCPOP_M, 0x0, 0x0 }, // 366
  { PseudoVCPOP_M_B16, VCPOP_M, 0x1, 0x0 }, // 367
  { PseudoVCPOP_M_B16_MASK, VCPOP_M, 0x1, 0x0 }, // 368
  { PseudoVCPOP_M_B32, VCPOP_M, 0x2, 0x0 }, // 369
  { PseudoVCPOP_M_B32_MASK, VCPOP_M, 0x2, 0x0 }, // 370
  { PseudoVCPOP_M_B64, VCPOP_M, 0x3, 0x0 }, // 371
  { PseudoVCPOP_M_B64_MASK, VCPOP_M, 0x3, 0x0 }, // 372
  { PseudoVCPOP_M_B1, VCPOP_M, 0x5, 0x0 }, // 373
  { PseudoVCPOP_M_B1_MASK, VCPOP_M, 0x5, 0x0 }, // 374
  { PseudoVCPOP_M_B2, VCPOP_M, 0x6, 0x0 }, // 375
  { PseudoVCPOP_M_B2_MASK, VCPOP_M, 0x6, 0x0 }, // 376
  { PseudoVCPOP_M_B4, VCPOP_M, 0x7, 0x0 }, // 377
  { PseudoVCPOP_M_B4_MASK, VCPOP_M, 0x7, 0x0 }, // 378
  { PseudoVCPOP_V_M1, VCPOP_V, 0x0, 0x0 }, // 379
  { PseudoVCPOP_V_M1_MASK, VCPOP_V, 0x0, 0x0 }, // 380
  { PseudoVCPOP_V_M2, VCPOP_V, 0x1, 0x0 }, // 381
  { PseudoVCPOP_V_M2_MASK, VCPOP_V, 0x1, 0x0 }, // 382
  { PseudoVCPOP_V_M4, VCPOP_V, 0x2, 0x0 }, // 383
  { PseudoVCPOP_V_M4_MASK, VCPOP_V, 0x2, 0x0 }, // 384
  { PseudoVCPOP_V_M8, VCPOP_V, 0x3, 0x0 }, // 385
  { PseudoVCPOP_V_M8_MASK, VCPOP_V, 0x3, 0x0 }, // 386
  { PseudoVCPOP_V_MF8, VCPOP_V, 0x5, 0x0 }, // 387
  { PseudoVCPOP_V_MF8_MASK, VCPOP_V, 0x5, 0x0 }, // 388
  { PseudoVCPOP_V_MF4, VCPOP_V, 0x6, 0x0 }, // 389
  { PseudoVCPOP_V_MF4_MASK, VCPOP_V, 0x6, 0x0 }, // 390
  { PseudoVCPOP_V_MF2, VCPOP_V, 0x7, 0x0 }, // 391
  { PseudoVCPOP_V_MF2_MASK, VCPOP_V, 0x7, 0x0 }, // 392
  { PseudoVCTZ_V_M1, VCTZ_V, 0x0, 0x0 }, // 393
  { PseudoVCTZ_V_M1_MASK, VCTZ_V, 0x0, 0x0 }, // 394
  { PseudoVCTZ_V_M2, VCTZ_V, 0x1, 0x0 }, // 395
  { PseudoVCTZ_V_M2_MASK, VCTZ_V, 0x1, 0x0 }, // 396
  { PseudoVCTZ_V_M4, VCTZ_V, 0x2, 0x0 }, // 397
  { PseudoVCTZ_V_M4_MASK, VCTZ_V, 0x2, 0x0 }, // 398
  { PseudoVCTZ_V_M8, VCTZ_V, 0x3, 0x0 }, // 399
  { PseudoVCTZ_V_M8_MASK, VCTZ_V, 0x3, 0x0 }, // 400
  { PseudoVCTZ_V_MF8, VCTZ_V, 0x5, 0x0 }, // 401
  { PseudoVCTZ_V_MF8_MASK, VCTZ_V, 0x5, 0x0 }, // 402
  { PseudoVCTZ_V_MF4, VCTZ_V, 0x6, 0x0 }, // 403
  { PseudoVCTZ_V_MF4_MASK, VCTZ_V, 0x6, 0x0 }, // 404
  { PseudoVCTZ_V_MF2, VCTZ_V, 0x7, 0x0 }, // 405
  { PseudoVCTZ_V_MF2_MASK, VCTZ_V, 0x7, 0x0 }, // 406
  { PseudoVC_F16V_SE_M1, VC_FV, 0x0, 0x0 }, // 407
  { PseudoVC_F32V_SE_M1, VC_FV, 0x0, 0x0 }, // 408
  { PseudoVC_F64V_SE_M1, VC_FV, 0x0, 0x0 }, // 409
  { PseudoVC_F16V_SE_M2, VC_FV, 0x1, 0x0 }, // 410
  { PseudoVC_F32V_SE_M2, VC_FV, 0x1, 0x0 }, // 411
  { PseudoVC_F64V_SE_M2, VC_FV, 0x1, 0x0 }, // 412
  { PseudoVC_F16V_SE_M4, VC_FV, 0x2, 0x0 }, // 413
  { PseudoVC_F32V_SE_M4, VC_FV, 0x2, 0x0 }, // 414
  { PseudoVC_F64V_SE_M4, VC_FV, 0x2, 0x0 }, // 415
  { PseudoVC_F16V_SE_M8, VC_FV, 0x3, 0x0 }, // 416
  { PseudoVC_F32V_SE_M8, VC_FV, 0x3, 0x0 }, // 417
  { PseudoVC_F64V_SE_M8, VC_FV, 0x3, 0x0 }, // 418
  { PseudoVC_F16V_SE_MF4, VC_FV, 0x6, 0x0 }, // 419
  { PseudoVC_F16V_SE_MF2, VC_FV, 0x7, 0x0 }, // 420
  { PseudoVC_F32V_SE_MF2, VC_FV, 0x7, 0x0 }, // 421
  { PseudoVC_F16VV_SE_M1, VC_FVV, 0x0, 0x0 }, // 422
  { PseudoVC_F32VV_SE_M1, VC_FVV, 0x0, 0x0 }, // 423
  { PseudoVC_F64VV_SE_M1, VC_FVV, 0x0, 0x0 }, // 424
  { PseudoVC_F16VV_SE_M2, VC_FVV, 0x1, 0x0 }, // 425
  { PseudoVC_F32VV_SE_M2, VC_FVV, 0x1, 0x0 }, // 426
  { PseudoVC_F64VV_SE_M2, VC_FVV, 0x1, 0x0 }, // 427
  { PseudoVC_F16VV_SE_M4, VC_FVV, 0x2, 0x0 }, // 428
  { PseudoVC_F32VV_SE_M4, VC_FVV, 0x2, 0x0 }, // 429
  { PseudoVC_F64VV_SE_M4, VC_FVV, 0x2, 0x0 }, // 430
  { PseudoVC_F16VV_SE_M8, VC_FVV, 0x3, 0x0 }, // 431
  { PseudoVC_F32VV_SE_M8, VC_FVV, 0x3, 0x0 }, // 432
  { PseudoVC_F64VV_SE_M8, VC_FVV, 0x3, 0x0 }, // 433
  { PseudoVC_F16VV_SE_MF4, VC_FVV, 0x6, 0x0 }, // 434
  { PseudoVC_F16VV_SE_MF2, VC_FVV, 0x7, 0x0 }, // 435
  { PseudoVC_F32VV_SE_MF2, VC_FVV, 0x7, 0x0 }, // 436
  { PseudoVC_F16VW_SE_M1, VC_FVW, 0x0, 0x0 }, // 437
  { PseudoVC_F32VW_SE_M1, VC_FVW, 0x0, 0x0 }, // 438
  { PseudoVC_F16VW_SE_M2, VC_FVW, 0x1, 0x0 }, // 439
  { PseudoVC_F32VW_SE_M2, VC_FVW, 0x1, 0x0 }, // 440
  { PseudoVC_F16VW_SE_M4, VC_FVW, 0x2, 0x0 }, // 441
  { PseudoVC_F32VW_SE_M4, VC_FVW, 0x2, 0x0 }, // 442
  { PseudoVC_F16VW_SE_M8, VC_FVW, 0x3, 0x0 }, // 443
  { PseudoVC_F32VW_SE_M8, VC_FVW, 0x3, 0x0 }, // 444
  { PseudoVC_F16VW_SE_MF4, VC_FVW, 0x6, 0x0 }, // 445
  { PseudoVC_F16VW_SE_MF2, VC_FVW, 0x7, 0x0 }, // 446
  { PseudoVC_F32VW_SE_MF2, VC_FVW, 0x7, 0x0 }, // 447
  { PseudoVC_I_SE_M1, VC_I, 0x0, 0x0 }, // 448
  { PseudoVC_I_SE_M2, VC_I, 0x1, 0x0 }, // 449
  { PseudoVC_I_SE_M4, VC_I, 0x2, 0x0 }, // 450
  { PseudoVC_I_SE_M8, VC_I, 0x3, 0x0 }, // 451
  { PseudoVC_I_SE_MF8, VC_I, 0x5, 0x0 }, // 452
  { PseudoVC_I_SE_MF4, VC_I, 0x6, 0x0 }, // 453
  { PseudoVC_I_SE_MF2, VC_I, 0x7, 0x0 }, // 454
  { PseudoVC_IV_SE_M1, VC_IV, 0x0, 0x0 }, // 455
  { PseudoVC_IV_SE_M2, VC_IV, 0x1, 0x0 }, // 456
  { PseudoVC_IV_SE_M4, VC_IV, 0x2, 0x0 }, // 457
  { PseudoVC_IV_SE_M8, VC_IV, 0x3, 0x0 }, // 458
  { PseudoVC_IV_SE_MF8, VC_IV, 0x5, 0x0 }, // 459
  { PseudoVC_IV_SE_MF4, VC_IV, 0x6, 0x0 }, // 460
  { PseudoVC_IV_SE_MF2, VC_IV, 0x7, 0x0 }, // 461
  { PseudoVC_IVV_SE_M1, VC_IVV, 0x0, 0x0 }, // 462
  { PseudoVC_IVV_SE_M2, VC_IVV, 0x1, 0x0 }, // 463
  { PseudoVC_IVV_SE_M4, VC_IVV, 0x2, 0x0 }, // 464
  { PseudoVC_IVV_SE_M8, VC_IVV, 0x3, 0x0 }, // 465
  { PseudoVC_IVV_SE_MF8, VC_IVV, 0x5, 0x0 }, // 466
  { PseudoVC_IVV_SE_MF4, VC_IVV, 0x6, 0x0 }, // 467
  { PseudoVC_IVV_SE_MF2, VC_IVV, 0x7, 0x0 }, // 468
  { PseudoVC_IVW_SE_M1, VC_IVW, 0x0, 0x0 }, // 469
  { PseudoVC_IVW_SE_M2, VC_IVW, 0x1, 0x0 }, // 470
  { PseudoVC_IVW_SE_M4, VC_IVW, 0x2, 0x0 }, // 471
  { PseudoVC_IVW_SE_MF8, VC_IVW, 0x5, 0x0 }, // 472
  { PseudoVC_IVW_SE_MF4, VC_IVW, 0x6, 0x0 }, // 473
  { PseudoVC_IVW_SE_MF2, VC_IVW, 0x7, 0x0 }, // 474
  { PseudoVC_VV_SE_M1, VC_VV, 0x0, 0x0 }, // 475
  { PseudoVC_VV_SE_M2, VC_VV, 0x1, 0x0 }, // 476
  { PseudoVC_VV_SE_M4, VC_VV, 0x2, 0x0 }, // 477
  { PseudoVC_VV_SE_M8, VC_VV, 0x3, 0x0 }, // 478
  { PseudoVC_VV_SE_MF8, VC_VV, 0x5, 0x0 }, // 479
  { PseudoVC_VV_SE_MF4, VC_VV, 0x6, 0x0 }, // 480
  { PseudoVC_VV_SE_MF2, VC_VV, 0x7, 0x0 }, // 481
  { PseudoVC_VVV_SE_M1, VC_VVV, 0x0, 0x0 }, // 482
  { PseudoVC_VVV_SE_M2, VC_VVV, 0x1, 0x0 }, // 483
  { PseudoVC_VVV_SE_M4, VC_VVV, 0x2, 0x0 }, // 484
  { PseudoVC_VVV_SE_M8, VC_VVV, 0x3, 0x0 }, // 485
  { PseudoVC_VVV_SE_MF8, VC_VVV, 0x5, 0x0 }, // 486
  { PseudoVC_VVV_SE_MF4, VC_VVV, 0x6, 0x0 }, // 487
  { PseudoVC_VVV_SE_MF2, VC_VVV, 0x7, 0x0 }, // 488
  { PseudoVC_VVW_SE_M1, VC_VVW, 0x0, 0x0 }, // 489
  { PseudoVC_VVW_SE_M2, VC_VVW, 0x1, 0x0 }, // 490
  { PseudoVC_VVW_SE_M4, VC_VVW, 0x2, 0x0 }, // 491
  { PseudoVC_VVW_SE_MF8, VC_VVW, 0x5, 0x0 }, // 492
  { PseudoVC_VVW_SE_MF4, VC_VVW, 0x6, 0x0 }, // 493
  { PseudoVC_VVW_SE_MF2, VC_VVW, 0x7, 0x0 }, // 494
  { PseudoVC_V_F16V_M1, VC_V_FV, 0x0, 0x0 }, // 495
  { PseudoVC_V_F16V_SE_M1, VC_V_FV, 0x0, 0x0 }, // 496
  { PseudoVC_V_F32V_M1, VC_V_FV, 0x0, 0x0 }, // 497
  { PseudoVC_V_F32V_SE_M1, VC_V_FV, 0x0, 0x0 }, // 498
  { PseudoVC_V_F64V_M1, VC_V_FV, 0x0, 0x0 }, // 499
  { PseudoVC_V_F64V_SE_M1, VC_V_FV, 0x0, 0x0 }, // 500
  { PseudoVC_V_F16V_M2, VC_V_FV, 0x1, 0x0 }, // 501
  { PseudoVC_V_F16V_SE_M2, VC_V_FV, 0x1, 0x0 }, // 502
  { PseudoVC_V_F32V_M2, VC_V_FV, 0x1, 0x0 }, // 503
  { PseudoVC_V_F32V_SE_M2, VC_V_FV, 0x1, 0x0 }, // 504
  { PseudoVC_V_F64V_M2, VC_V_FV, 0x1, 0x0 }, // 505
  { PseudoVC_V_F64V_SE_M2, VC_V_FV, 0x1, 0x0 }, // 506
  { PseudoVC_V_F16V_M4, VC_V_FV, 0x2, 0x0 }, // 507
  { PseudoVC_V_F16V_SE_M4, VC_V_FV, 0x2, 0x0 }, // 508
  { PseudoVC_V_F32V_M4, VC_V_FV, 0x2, 0x0 }, // 509
  { PseudoVC_V_F32V_SE_M4, VC_V_FV, 0x2, 0x0 }, // 510
  { PseudoVC_V_F64V_M4, VC_V_FV, 0x2, 0x0 }, // 511
  { PseudoVC_V_F64V_SE_M4, VC_V_FV, 0x2, 0x0 }, // 512
  { PseudoVC_V_F16V_M8, VC_V_FV, 0x3, 0x0 }, // 513
  { PseudoVC_V_F16V_SE_M8, VC_V_FV, 0x3, 0x0 }, // 514
  { PseudoVC_V_F32V_M8, VC_V_FV, 0x3, 0x0 }, // 515
  { PseudoVC_V_F32V_SE_M8, VC_V_FV, 0x3, 0x0 }, // 516
  { PseudoVC_V_F64V_M8, VC_V_FV, 0x3, 0x0 }, // 517
  { PseudoVC_V_F64V_SE_M8, VC_V_FV, 0x3, 0x0 }, // 518
  { PseudoVC_V_F16V_MF4, VC_V_FV, 0x6, 0x0 }, // 519
  { PseudoVC_V_F16V_SE_MF4, VC_V_FV, 0x6, 0x0 }, // 520
  { PseudoVC_V_F16V_MF2, VC_V_FV, 0x7, 0x0 }, // 521
  { PseudoVC_V_F16V_SE_MF2, VC_V_FV, 0x7, 0x0 }, // 522
  { PseudoVC_V_F32V_MF2, VC_V_FV, 0x7, 0x0 }, // 523
  { PseudoVC_V_F32V_SE_MF2, VC_V_FV, 0x7, 0x0 }, // 524
  { PseudoVC_V_F16VV_M1, VC_V_FVV, 0x0, 0x0 }, // 525
  { PseudoVC_V_F16VV_SE_M1, VC_V_FVV, 0x0, 0x0 }, // 526
  { PseudoVC_V_F32VV_M1, VC_V_FVV, 0x0, 0x0 }, // 527
  { PseudoVC_V_F32VV_SE_M1, VC_V_FVV, 0x0, 0x0 }, // 528
  { PseudoVC_V_F64VV_M1, VC_V_FVV, 0x0, 0x0 }, // 529
  { PseudoVC_V_F64VV_SE_M1, VC_V_FVV, 0x0, 0x0 }, // 530
  { PseudoVC_V_F16VV_M2, VC_V_FVV, 0x1, 0x0 }, // 531
  { PseudoVC_V_F16VV_SE_M2, VC_V_FVV, 0x1, 0x0 }, // 532
  { PseudoVC_V_F32VV_M2, VC_V_FVV, 0x1, 0x0 }, // 533
  { PseudoVC_V_F32VV_SE_M2, VC_V_FVV, 0x1, 0x0 }, // 534
  { PseudoVC_V_F64VV_M2, VC_V_FVV, 0x1, 0x0 }, // 535
  { PseudoVC_V_F64VV_SE_M2, VC_V_FVV, 0x1, 0x0 }, // 536
  { PseudoVC_V_F16VV_M4, VC_V_FVV, 0x2, 0x0 }, // 537
  { PseudoVC_V_F16VV_SE_M4, VC_V_FVV, 0x2, 0x0 }, // 538
  { PseudoVC_V_F32VV_M4, VC_V_FVV, 0x2, 0x0 }, // 539
  { PseudoVC_V_F32VV_SE_M4, VC_V_FVV, 0x2, 0x0 }, // 540
  { PseudoVC_V_F64VV_M4, VC_V_FVV, 0x2, 0x0 }, // 541
  { PseudoVC_V_F64VV_SE_M4, VC_V_FVV, 0x2, 0x0 }, // 542
  { PseudoVC_V_F16VV_M8, VC_V_FVV, 0x3, 0x0 }, // 543
  { PseudoVC_V_F16VV_SE_M8, VC_V_FVV, 0x3, 0x0 }, // 544
  { PseudoVC_V_F32VV_M8, VC_V_FVV, 0x3, 0x0 }, // 545
  { PseudoVC_V_F32VV_SE_M8, VC_V_FVV, 0x3, 0x0 }, // 546
  { PseudoVC_V_F64VV_M8, VC_V_FVV, 0x3, 0x0 }, // 547
  { PseudoVC_V_F64VV_SE_M8, VC_V_FVV, 0x3, 0x0 }, // 548
  { PseudoVC_V_F16VV_MF4, VC_V_FVV, 0x6, 0x0 }, // 549
  { PseudoVC_V_F16VV_SE_MF4, VC_V_FVV, 0x6, 0x0 }, // 550
  { PseudoVC_V_F16VV_MF2, VC_V_FVV, 0x7, 0x0 }, // 551
  { PseudoVC_V_F16VV_SE_MF2, VC_V_FVV, 0x7, 0x0 }, // 552
  { PseudoVC_V_F32VV_MF2, VC_V_FVV, 0x7, 0x0 }, // 553
  { PseudoVC_V_F32VV_SE_MF2, VC_V_FVV, 0x7, 0x0 }, // 554
  { PseudoVC_V_F16VW_M1, VC_V_FVW, 0x0, 0x0 }, // 555
  { PseudoVC_V_F16VW_SE_M1, VC_V_FVW, 0x0, 0x0 }, // 556
  { PseudoVC_V_F32VW_M1, VC_V_FVW, 0x0, 0x0 }, // 557
  { PseudoVC_V_F32VW_SE_M1, VC_V_FVW, 0x0, 0x0 }, // 558
  { PseudoVC_V_F16VW_M2, VC_V_FVW, 0x1, 0x0 }, // 559
  { PseudoVC_V_F16VW_SE_M2, VC_V_FVW, 0x1, 0x0 }, // 560
  { PseudoVC_V_F32VW_M2, VC_V_FVW, 0x1, 0x0 }, // 561
  { PseudoVC_V_F32VW_SE_M2, VC_V_FVW, 0x1, 0x0 }, // 562
  { PseudoVC_V_F16VW_M4, VC_V_FVW, 0x2, 0x0 }, // 563
  { PseudoVC_V_F16VW_SE_M4, VC_V_FVW, 0x2, 0x0 }, // 564
  { PseudoVC_V_F32VW_M4, VC_V_FVW, 0x2, 0x0 }, // 565
  { PseudoVC_V_F32VW_SE_M4, VC_V_FVW, 0x2, 0x0 }, // 566
  { PseudoVC_V_F16VW_M8, VC_V_FVW, 0x3, 0x0 }, // 567
  { PseudoVC_V_F16VW_SE_M8, VC_V_FVW, 0x3, 0x0 }, // 568
  { PseudoVC_V_F32VW_M8, VC_V_FVW, 0x3, 0x0 }, // 569
  { PseudoVC_V_F32VW_SE_M8, VC_V_FVW, 0x3, 0x0 }, // 570
  { PseudoVC_V_F16VW_MF4, VC_V_FVW, 0x6, 0x0 }, // 571
  { PseudoVC_V_F16VW_SE_MF4, VC_V_FVW, 0x6, 0x0 }, // 572
  { PseudoVC_V_F16VW_MF2, VC_V_FVW, 0x7, 0x0 }, // 573
  { PseudoVC_V_F16VW_SE_MF2, VC_V_FVW, 0x7, 0x0 }, // 574
  { PseudoVC_V_F32VW_MF2, VC_V_FVW, 0x7, 0x0 }, // 575
  { PseudoVC_V_F32VW_SE_MF2, VC_V_FVW, 0x7, 0x0 }, // 576
  { PseudoVC_V_I_M1, VC_V_I, 0x0, 0x0 }, // 577
  { PseudoVC_V_I_SE_M1, VC_V_I, 0x0, 0x0 }, // 578
  { PseudoVC_V_I_M2, VC_V_I, 0x1, 0x0 }, // 579
  { PseudoVC_V_I_SE_M2, VC_V_I, 0x1, 0x0 }, // 580
  { PseudoVC_V_I_M4, VC_V_I, 0x2, 0x0 }, // 581
  { PseudoVC_V_I_SE_M4, VC_V_I, 0x2, 0x0 }, // 582
  { PseudoVC_V_I_M8, VC_V_I, 0x3, 0x0 }, // 583
  { PseudoVC_V_I_SE_M8, VC_V_I, 0x3, 0x0 }, // 584
  { PseudoVC_V_I_MF8, VC_V_I, 0x5, 0x0 }, // 585
  { PseudoVC_V_I_SE_MF8, VC_V_I, 0x5, 0x0 }, // 586
  { PseudoVC_V_I_MF4, VC_V_I, 0x6, 0x0 }, // 587
  { PseudoVC_V_I_SE_MF4, VC_V_I, 0x6, 0x0 }, // 588
  { PseudoVC_V_I_MF2, VC_V_I, 0x7, 0x0 }, // 589
  { PseudoVC_V_I_SE_MF2, VC_V_I, 0x7, 0x0 }, // 590
  { PseudoVC_V_IV_M1, VC_V_IV, 0x0, 0x0 }, // 591
  { PseudoVC_V_IV_SE_M1, VC_V_IV, 0x0, 0x0 }, // 592
  { PseudoVC_V_IV_M2, VC_V_IV, 0x1, 0x0 }, // 593
  { PseudoVC_V_IV_SE_M2, VC_V_IV, 0x1, 0x0 }, // 594
  { PseudoVC_V_IV_M4, VC_V_IV, 0x2, 0x0 }, // 595
  { PseudoVC_V_IV_SE_M4, VC_V_IV, 0x2, 0x0 }, // 596
  { PseudoVC_V_IV_M8, VC_V_IV, 0x3, 0x0 }, // 597
  { PseudoVC_V_IV_SE_M8, VC_V_IV, 0x3, 0x0 }, // 598
  { PseudoVC_V_IV_MF8, VC_V_IV, 0x5, 0x0 }, // 599
  { PseudoVC_V_IV_SE_MF8, VC_V_IV, 0x5, 0x0 }, // 600
  { PseudoVC_V_IV_MF4, VC_V_IV, 0x6, 0x0 }, // 601
  { PseudoVC_V_IV_SE_MF4, VC_V_IV, 0x6, 0x0 }, // 602
  { PseudoVC_V_IV_MF2, VC_V_IV, 0x7, 0x0 }, // 603
  { PseudoVC_V_IV_SE_MF2, VC_V_IV, 0x7, 0x0 }, // 604
  { PseudoVC_V_IVV_M1, VC_V_IVV, 0x0, 0x0 }, // 605
  { PseudoVC_V_IVV_SE_M1, VC_V_IVV, 0x0, 0x0 }, // 606
  { PseudoVC_V_IVV_M2, VC_V_IVV, 0x1, 0x0 }, // 607
  { PseudoVC_V_IVV_SE_M2, VC_V_IVV, 0x1, 0x0 }, // 608
  { PseudoVC_V_IVV_M4, VC_V_IVV, 0x2, 0x0 }, // 609
  { PseudoVC_V_IVV_SE_M4, VC_V_IVV, 0x2, 0x0 }, // 610
  { PseudoVC_V_IVV_M8, VC_V_IVV, 0x3, 0x0 }, // 611
  { PseudoVC_V_IVV_SE_M8, VC_V_IVV, 0x3, 0x0 }, // 612
  { PseudoVC_V_IVV_MF8, VC_V_IVV, 0x5, 0x0 }, // 613
  { PseudoVC_V_IVV_SE_MF8, VC_V_IVV, 0x5, 0x0 }, // 614
  { PseudoVC_V_IVV_MF4, VC_V_IVV, 0x6, 0x0 }, // 615
  { PseudoVC_V_IVV_SE_MF4, VC_V_IVV, 0x6, 0x0 }, // 616
  { PseudoVC_V_IVV_MF2, VC_V_IVV, 0x7, 0x0 }, // 617
  { PseudoVC_V_IVV_SE_MF2, VC_V_IVV, 0x7, 0x0 }, // 618
  { PseudoVC_V_IVW_M1, VC_V_IVW, 0x0, 0x0 }, // 619
  { PseudoVC_V_IVW_SE_M1, VC_V_IVW, 0x0, 0x0 }, // 620
  { PseudoVC_V_IVW_M2, VC_V_IVW, 0x1, 0x0 }, // 621
  { PseudoVC_V_IVW_SE_M2, VC_V_IVW, 0x1, 0x0 }, // 622
  { PseudoVC_V_IVW_M4, VC_V_IVW, 0x2, 0x0 }, // 623
  { PseudoVC_V_IVW_SE_M4, VC_V_IVW, 0x2, 0x0 }, // 624
  { PseudoVC_V_IVW_MF8, VC_V_IVW, 0x5, 0x0 }, // 625
  { PseudoVC_V_IVW_SE_MF8, VC_V_IVW, 0x5, 0x0 }, // 626
  { PseudoVC_V_IVW_MF4, VC_V_IVW, 0x6, 0x0 }, // 627
  { PseudoVC_V_IVW_SE_MF4, VC_V_IVW, 0x6, 0x0 }, // 628
  { PseudoVC_V_IVW_MF2, VC_V_IVW, 0x7, 0x0 }, // 629
  { PseudoVC_V_IVW_SE_MF2, VC_V_IVW, 0x7, 0x0 }, // 630
  { PseudoVC_V_VV_M1, VC_V_VV, 0x0, 0x0 }, // 631
  { PseudoVC_V_VV_SE_M1, VC_V_VV, 0x0, 0x0 }, // 632
  { PseudoVC_V_VV_M2, VC_V_VV, 0x1, 0x0 }, // 633
  { PseudoVC_V_VV_SE_M2, VC_V_VV, 0x1, 0x0 }, // 634
  { PseudoVC_V_VV_M4, VC_V_VV, 0x2, 0x0 }, // 635
  { PseudoVC_V_VV_SE_M4, VC_V_VV, 0x2, 0x0 }, // 636
  { PseudoVC_V_VV_M8, VC_V_VV, 0x3, 0x0 }, // 637
  { PseudoVC_V_VV_SE_M8, VC_V_VV, 0x3, 0x0 }, // 638
  { PseudoVC_V_VV_MF8, VC_V_VV, 0x5, 0x0 }, // 639
  { PseudoVC_V_VV_SE_MF8, VC_V_VV, 0x5, 0x0 }, // 640
  { PseudoVC_V_VV_MF4, VC_V_VV, 0x6, 0x0 }, // 641
  { PseudoVC_V_VV_SE_MF4, VC_V_VV, 0x6, 0x0 }, // 642
  { PseudoVC_V_VV_MF2, VC_V_VV, 0x7, 0x0 }, // 643
  { PseudoVC_V_VV_SE_MF2, VC_V_VV, 0x7, 0x0 }, // 644
  { PseudoVC_V_VVV_M1, VC_V_VVV, 0x0, 0x0 }, // 645
  { PseudoVC_V_VVV_SE_M1, VC_V_VVV, 0x0, 0x0 }, // 646
  { PseudoVC_V_VVV_M2, VC_V_VVV, 0x1, 0x0 }, // 647
  { PseudoVC_V_VVV_SE_M2, VC_V_VVV, 0x1, 0x0 }, // 648
  { PseudoVC_V_VVV_M4, VC_V_VVV, 0x2, 0x0 }, // 649
  { PseudoVC_V_VVV_SE_M4, VC_V_VVV, 0x2, 0x0 }, // 650
  { PseudoVC_V_VVV_M8, VC_V_VVV, 0x3, 0x0 }, // 651
  { PseudoVC_V_VVV_SE_M8, VC_V_VVV, 0x3, 0x0 }, // 652
  { PseudoVC_V_VVV_MF8, VC_V_VVV, 0x5, 0x0 }, // 653
  { PseudoVC_V_VVV_SE_MF8, VC_V_VVV, 0x5, 0x0 }, // 654
  { PseudoVC_V_VVV_MF4, VC_V_VVV, 0x6, 0x0 }, // 655
  { PseudoVC_V_VVV_SE_MF4, VC_V_VVV, 0x6, 0x0 }, // 656
  { PseudoVC_V_VVV_MF2, VC_V_VVV, 0x7, 0x0 }, // 657
  { PseudoVC_V_VVV_SE_MF2, VC_V_VVV, 0x7, 0x0 }, // 658
  { PseudoVC_V_VVW_M1, VC_V_VVW, 0x0, 0x0 }, // 659
  { PseudoVC_V_VVW_SE_M1, VC_V_VVW, 0x0, 0x0 }, // 660
  { PseudoVC_V_VVW_M2, VC_V_VVW, 0x1, 0x0 }, // 661
  { PseudoVC_V_VVW_SE_M2, VC_V_VVW, 0x1, 0x0 }, // 662
  { PseudoVC_V_VVW_M4, VC_V_VVW, 0x2, 0x0 }, // 663
  { PseudoVC_V_VVW_SE_M4, VC_V_VVW, 0x2, 0x0 }, // 664
  { PseudoVC_V_VVW_MF8, VC_V_VVW, 0x5, 0x0 }, // 665
  { PseudoVC_V_VVW_SE_MF8, VC_V_VVW, 0x5, 0x0 }, // 666
  { PseudoVC_V_VVW_MF4, VC_V_VVW, 0x6, 0x0 }, // 667
  { PseudoVC_V_VVW_SE_MF4, VC_V_VVW, 0x6, 0x0 }, // 668
  { PseudoVC_V_VVW_MF2, VC_V_VVW, 0x7, 0x0 }, // 669
  { PseudoVC_V_VVW_SE_MF2, VC_V_VVW, 0x7, 0x0 }, // 670
  { PseudoVC_V_X_M1, VC_V_X, 0x0, 0x0 }, // 671
  { PseudoVC_V_X_SE_M1, VC_V_X, 0x0, 0x0 }, // 672
  { PseudoVC_V_X_M2, VC_V_X, 0x1, 0x0 }, // 673
  { PseudoVC_V_X_SE_M2, VC_V_X, 0x1, 0x0 }, // 674
  { PseudoVC_V_X_M4, VC_V_X, 0x2, 0x0 }, // 675
  { PseudoVC_V_X_SE_M4, VC_V_X, 0x2, 0x0 }, // 676
  { PseudoVC_V_X_M8, VC_V_X, 0x3, 0x0 }, // 677
  { PseudoVC_V_X_SE_M8, VC_V_X, 0x3, 0x0 }, // 678
  { PseudoVC_V_X_MF8, VC_V_X, 0x5, 0x0 }, // 679
  { PseudoVC_V_X_SE_MF8, VC_V_X, 0x5, 0x0 }, // 680
  { PseudoVC_V_X_MF4, VC_V_X, 0x6, 0x0 }, // 681
  { PseudoVC_V_X_SE_MF4, VC_V_X, 0x6, 0x0 }, // 682
  { PseudoVC_V_X_MF2, VC_V_X, 0x7, 0x0 }, // 683
  { PseudoVC_V_X_SE_MF2, VC_V_X, 0x7, 0x0 }, // 684
  { PseudoVC_V_XV_M1, VC_V_XV, 0x0, 0x0 }, // 685
  { PseudoVC_V_XV_SE_M1, VC_V_XV, 0x0, 0x0 }, // 686
  { PseudoVC_V_XV_M2, VC_V_XV, 0x1, 0x0 }, // 687
  { PseudoVC_V_XV_SE_M2, VC_V_XV, 0x1, 0x0 }, // 688
  { PseudoVC_V_XV_M4, VC_V_XV, 0x2, 0x0 }, // 689
  { PseudoVC_V_XV_SE_M4, VC_V_XV, 0x2, 0x0 }, // 690
  { PseudoVC_V_XV_M8, VC_V_XV, 0x3, 0x0 }, // 691
  { PseudoVC_V_XV_SE_M8, VC_V_XV, 0x3, 0x0 }, // 692
  { PseudoVC_V_XV_MF8, VC_V_XV, 0x5, 0x0 }, // 693
  { PseudoVC_V_XV_SE_MF8, VC_V_XV, 0x5, 0x0 }, // 694
  { PseudoVC_V_XV_MF4, VC_V_XV, 0x6, 0x0 }, // 695
  { PseudoVC_V_XV_SE_MF4, VC_V_XV, 0x6, 0x0 }, // 696
  { PseudoVC_V_XV_MF2, VC_V_XV, 0x7, 0x0 }, // 697
  { PseudoVC_V_XV_SE_MF2, VC_V_XV, 0x7, 0x0 }, // 698
  { PseudoVC_V_XVV_M1, VC_V_XVV, 0x0, 0x0 }, // 699
  { PseudoVC_V_XVV_SE_M1, VC_V_XVV, 0x0, 0x0 }, // 700
  { PseudoVC_V_XVV_M2, VC_V_XVV, 0x1, 0x0 }, // 701
  { PseudoVC_V_XVV_SE_M2, VC_V_XVV, 0x1, 0x0 }, // 702
  { PseudoVC_V_XVV_M4, VC_V_XVV, 0x2, 0x0 }, // 703
  { PseudoVC_V_XVV_SE_M4, VC_V_XVV, 0x2, 0x0 }, // 704
  { PseudoVC_V_XVV_M8, VC_V_XVV, 0x3, 0x0 }, // 705
  { PseudoVC_V_XVV_SE_M8, VC_V_XVV, 0x3, 0x0 }, // 706
  { PseudoVC_V_XVV_MF8, VC_V_XVV, 0x5, 0x0 }, // 707
  { PseudoVC_V_XVV_SE_MF8, VC_V_XVV, 0x5, 0x0 }, // 708
  { PseudoVC_V_XVV_MF4, VC_V_XVV, 0x6, 0x0 }, // 709
  { PseudoVC_V_XVV_SE_MF4, VC_V_XVV, 0x6, 0x0 }, // 710
  { PseudoVC_V_XVV_MF2, VC_V_XVV, 0x7, 0x0 }, // 711
  { PseudoVC_V_XVV_SE_MF2, VC_V_XVV, 0x7, 0x0 }, // 712
  { PseudoVC_V_XVW_M1, VC_V_XVW, 0x0, 0x0 }, // 713
  { PseudoVC_V_XVW_SE_M1, VC_V_XVW, 0x0, 0x0 }, // 714
  { PseudoVC_V_XVW_M2, VC_V_XVW, 0x1, 0x0 }, // 715
  { PseudoVC_V_XVW_SE_M2, VC_V_XVW, 0x1, 0x0 }, // 716
  { PseudoVC_V_XVW_M4, VC_V_XVW, 0x2, 0x0 }, // 717
  { PseudoVC_V_XVW_SE_M4, VC_V_XVW, 0x2, 0x0 }, // 718
  { PseudoVC_V_XVW_MF8, VC_V_XVW, 0x5, 0x0 }, // 719
  { PseudoVC_V_XVW_SE_MF8, VC_V_XVW, 0x5, 0x0 }, // 720
  { PseudoVC_V_XVW_MF4, VC_V_XVW, 0x6, 0x0 }, // 721
  { PseudoVC_V_XVW_SE_MF4, VC_V_XVW, 0x6, 0x0 }, // 722
  { PseudoVC_V_XVW_MF2, VC_V_XVW, 0x7, 0x0 }, // 723
  { PseudoVC_V_XVW_SE_MF2, VC_V_XVW, 0x7, 0x0 }, // 724
  { PseudoVC_X_SE_M1, VC_X, 0x0, 0x0 }, // 725
  { PseudoVC_X_SE_M2, VC_X, 0x1, 0x0 }, // 726
  { PseudoVC_X_SE_M4, VC_X, 0x2, 0x0 }, // 727
  { PseudoVC_X_SE_M8, VC_X, 0x3, 0x0 }, // 728
  { PseudoVC_X_SE_MF8, VC_X, 0x5, 0x0 }, // 729
  { PseudoVC_X_SE_MF4, VC_X, 0x6, 0x0 }, // 730
  { PseudoVC_X_SE_MF2, VC_X, 0x7, 0x0 }, // 731
  { PseudoVC_XV_SE_M1, VC_XV, 0x0, 0x0 }, // 732
  { PseudoVC_XV_SE_M2, VC_XV, 0x1, 0x0 }, // 733
  { PseudoVC_XV_SE_M4, VC_XV, 0x2, 0x0 }, // 734
  { PseudoVC_XV_SE_M8, VC_XV, 0x3, 0x0 }, // 735
  { PseudoVC_XV_SE_MF8, VC_XV, 0x5, 0x0 }, // 736
  { PseudoVC_XV_SE_MF4, VC_XV, 0x6, 0x0 }, // 737
  { PseudoVC_XV_SE_MF2, VC_XV, 0x7, 0x0 }, // 738
  { PseudoVC_XVV_SE_M1, VC_XVV, 0x0, 0x0 }, // 739
  { PseudoVC_XVV_SE_M2, VC_XVV, 0x1, 0x0 }, // 740
  { PseudoVC_XVV_SE_M4, VC_XVV, 0x2, 0x0 }, // 741
  { PseudoVC_XVV_SE_M8, VC_XVV, 0x3, 0x0 }, // 742
  { PseudoVC_XVV_SE_MF8, VC_XVV, 0x5, 0x0 }, // 743
  { PseudoVC_XVV_SE_MF4, VC_XVV, 0x6, 0x0 }, // 744
  { PseudoVC_XVV_SE_MF2, VC_XVV, 0x7, 0x0 }, // 745
  { PseudoVC_XVW_SE_M1, VC_XVW, 0x0, 0x0 }, // 746
  { PseudoVC_XVW_SE_M2, VC_XVW, 0x1, 0x0 }, // 747
  { PseudoVC_XVW_SE_M4, VC_XVW, 0x2, 0x0 }, // 748
  { PseudoVC_XVW_SE_MF8, VC_XVW, 0x5, 0x0 }, // 749
  { PseudoVC_XVW_SE_MF4, VC_XVW, 0x6, 0x0 }, // 750
  { PseudoVC_XVW_SE_MF2, VC_XVW, 0x7, 0x0 }, // 751
  { PseudoVDIVU_VV_M1_E8, VDIVU_VV, 0x0, 0x8 }, // 752
  { PseudoVDIVU_VV_M1_E8_MASK, VDIVU_VV, 0x0, 0x8 }, // 753
  { PseudoVDIVU_VV_M1_E16, VDIVU_VV, 0x0, 0x10 }, // 754
  { PseudoVDIVU_VV_M1_E16_MASK, VDIVU_VV, 0x0, 0x10 }, // 755
  { PseudoVDIVU_VV_M1_E32, VDIVU_VV, 0x0, 0x20 }, // 756
  { PseudoVDIVU_VV_M1_E32_MASK, VDIVU_VV, 0x0, 0x20 }, // 757
  { PseudoVDIVU_VV_M1_E64, VDIVU_VV, 0x0, 0x40 }, // 758
  { PseudoVDIVU_VV_M1_E64_MASK, VDIVU_VV, 0x0, 0x40 }, // 759
  { PseudoVDIVU_VV_M2_E8, VDIVU_VV, 0x1, 0x8 }, // 760
  { PseudoVDIVU_VV_M2_E8_MASK, VDIVU_VV, 0x1, 0x8 }, // 761
  { PseudoVDIVU_VV_M2_E16, VDIVU_VV, 0x1, 0x10 }, // 762
  { PseudoVDIVU_VV_M2_E16_MASK, VDIVU_VV, 0x1, 0x10 }, // 763
  { PseudoVDIVU_VV_M2_E32, VDIVU_VV, 0x1, 0x20 }, // 764
  { PseudoVDIVU_VV_M2_E32_MASK, VDIVU_VV, 0x1, 0x20 }, // 765
  { PseudoVDIVU_VV_M2_E64, VDIVU_VV, 0x1, 0x40 }, // 766
  { PseudoVDIVU_VV_M2_E64_MASK, VDIVU_VV, 0x1, 0x40 }, // 767
  { PseudoVDIVU_VV_M4_E8, VDIVU_VV, 0x2, 0x8 }, // 768
  { PseudoVDIVU_VV_M4_E8_MASK, VDIVU_VV, 0x2, 0x8 }, // 769
  { PseudoVDIVU_VV_M4_E16, VDIVU_VV, 0x2, 0x10 }, // 770
  { PseudoVDIVU_VV_M4_E16_MASK, VDIVU_VV, 0x2, 0x10 }, // 771
  { PseudoVDIVU_VV_M4_E32, VDIVU_VV, 0x2, 0x20 }, // 772
  { PseudoVDIVU_VV_M4_E32_MASK, VDIVU_VV, 0x2, 0x20 }, // 773
  { PseudoVDIVU_VV_M4_E64, VDIVU_VV, 0x2, 0x40 }, // 774
  { PseudoVDIVU_VV_M4_E64_MASK, VDIVU_VV, 0x2, 0x40 }, // 775
  { PseudoVDIVU_VV_M8_E8, VDIVU_VV, 0x3, 0x8 }, // 776
  { PseudoVDIVU_VV_M8_E8_MASK, VDIVU_VV, 0x3, 0x8 }, // 777
  { PseudoVDIVU_VV_M8_E16, VDIVU_VV, 0x3, 0x10 }, // 778
  { PseudoVDIVU_VV_M8_E16_MASK, VDIVU_VV, 0x3, 0x10 }, // 779
  { PseudoVDIVU_VV_M8_E32, VDIVU_VV, 0x3, 0x20 }, // 780
  { PseudoVDIVU_VV_M8_E32_MASK, VDIVU_VV, 0x3, 0x20 }, // 781
  { PseudoVDIVU_VV_M8_E64, VDIVU_VV, 0x3, 0x40 }, // 782
  { PseudoVDIVU_VV_M8_E64_MASK, VDIVU_VV, 0x3, 0x40 }, // 783
  { PseudoVDIVU_VV_MF8_E8, VDIVU_VV, 0x5, 0x8 }, // 784
  { PseudoVDIVU_VV_MF8_E8_MASK, VDIVU_VV, 0x5, 0x8 }, // 785
  { PseudoVDIVU_VV_MF4_E8, VDIVU_VV, 0x6, 0x8 }, // 786
  { PseudoVDIVU_VV_MF4_E8_MASK, VDIVU_VV, 0x6, 0x8 }, // 787
  { PseudoVDIVU_VV_MF4_E16, VDIVU_VV, 0x6, 0x10 }, // 788
  { PseudoVDIVU_VV_MF4_E16_MASK, VDIVU_VV, 0x6, 0x10 }, // 789
  { PseudoVDIVU_VV_MF2_E8, VDIVU_VV, 0x7, 0x8 }, // 790
  { PseudoVDIVU_VV_MF2_E8_MASK, VDIVU_VV, 0x7, 0x8 }, // 791
  { PseudoVDIVU_VV_MF2_E16, VDIVU_VV, 0x7, 0x10 }, // 792
  { PseudoVDIVU_VV_MF2_E16_MASK, VDIVU_VV, 0x7, 0x10 }, // 793
  { PseudoVDIVU_VV_MF2_E32, VDIVU_VV, 0x7, 0x20 }, // 794
  { PseudoVDIVU_VV_MF2_E32_MASK, VDIVU_VV, 0x7, 0x20 }, // 795
  { PseudoVDIVU_VX_M1_E8, VDIVU_VX, 0x0, 0x8 }, // 796
  { PseudoVDIVU_VX_M1_E8_MASK, VDIVU_VX, 0x0, 0x8 }, // 797
  { PseudoVDIVU_VX_M1_E16, VDIVU_VX, 0x0, 0x10 }, // 798
  { PseudoVDIVU_VX_M1_E16_MASK, VDIVU_VX, 0x0, 0x10 }, // 799
  { PseudoVDIVU_VX_M1_E32, VDIVU_VX, 0x0, 0x20 }, // 800
  { PseudoVDIVU_VX_M1_E32_MASK, VDIVU_VX, 0x0, 0x20 }, // 801
  { PseudoVDIVU_VX_M1_E64, VDIVU_VX, 0x0, 0x40 }, // 802
  { PseudoVDIVU_VX_M1_E64_MASK, VDIVU_VX, 0x0, 0x40 }, // 803
  { PseudoVDIVU_VX_M2_E8, VDIVU_VX, 0x1, 0x8 }, // 804
  { PseudoVDIVU_VX_M2_E8_MASK, VDIVU_VX, 0x1, 0x8 }, // 805
  { PseudoVDIVU_VX_M2_E16, VDIVU_VX, 0x1, 0x10 }, // 806
  { PseudoVDIVU_VX_M2_E16_MASK, VDIVU_VX, 0x1, 0x10 }, // 807
  { PseudoVDIVU_VX_M2_E32, VDIVU_VX, 0x1, 0x20 }, // 808
  { PseudoVDIVU_VX_M2_E32_MASK, VDIVU_VX, 0x1, 0x20 }, // 809
  { PseudoVDIVU_VX_M2_E64, VDIVU_VX, 0x1, 0x40 }, // 810
  { PseudoVDIVU_VX_M2_E64_MASK, VDIVU_VX, 0x1, 0x40 }, // 811
  { PseudoVDIVU_VX_M4_E8, VDIVU_VX, 0x2, 0x8 }, // 812
  { PseudoVDIVU_VX_M4_E8_MASK, VDIVU_VX, 0x2, 0x8 }, // 813
  { PseudoVDIVU_VX_M4_E16, VDIVU_VX, 0x2, 0x10 }, // 814
  { PseudoVDIVU_VX_M4_E16_MASK, VDIVU_VX, 0x2, 0x10 }, // 815
  { PseudoVDIVU_VX_M4_E32, VDIVU_VX, 0x2, 0x20 }, // 816
  { PseudoVDIVU_VX_M4_E32_MASK, VDIVU_VX, 0x2, 0x20 }, // 817
  { PseudoVDIVU_VX_M4_E64, VDIVU_VX, 0x2, 0x40 }, // 818
  { PseudoVDIVU_VX_M4_E64_MASK, VDIVU_VX, 0x2, 0x40 }, // 819
  { PseudoVDIVU_VX_M8_E8, VDIVU_VX, 0x3, 0x8 }, // 820
  { PseudoVDIVU_VX_M8_E8_MASK, VDIVU_VX, 0x3, 0x8 }, // 821
  { PseudoVDIVU_VX_M8_E16, VDIVU_VX, 0x3, 0x10 }, // 822
  { PseudoVDIVU_VX_M8_E16_MASK, VDIVU_VX, 0x3, 0x10 }, // 823
  { PseudoVDIVU_VX_M8_E32, VDIVU_VX, 0x3, 0x20 }, // 824
  { PseudoVDIVU_VX_M8_E32_MASK, VDIVU_VX, 0x3, 0x20 }, // 825
  { PseudoVDIVU_VX_M8_E64, VDIVU_VX, 0x3, 0x40 }, // 826
  { PseudoVDIVU_VX_M8_E64_MASK, VDIVU_VX, 0x3, 0x40 }, // 827
  { PseudoVDIVU_VX_MF8_E8, VDIVU_VX, 0x5, 0x8 }, // 828
  { PseudoVDIVU_VX_MF8_E8_MASK, VDIVU_VX, 0x5, 0x8 }, // 829
  { PseudoVDIVU_VX_MF4_E8, VDIVU_VX, 0x6, 0x8 }, // 830
  { PseudoVDIVU_VX_MF4_E8_MASK, VDIVU_VX, 0x6, 0x8 }, // 831
  { PseudoVDIVU_VX_MF4_E16, VDIVU_VX, 0x6, 0x10 }, // 832
  { PseudoVDIVU_VX_MF4_E16_MASK, VDIVU_VX, 0x6, 0x10 }, // 833
  { PseudoVDIVU_VX_MF2_E8, VDIVU_VX, 0x7, 0x8 }, // 834
  { PseudoVDIVU_VX_MF2_E8_MASK, VDIVU_VX, 0x7, 0x8 }, // 835
  { PseudoVDIVU_VX_MF2_E16, VDIVU_VX, 0x7, 0x10 }, // 836
  { PseudoVDIVU_VX_MF2_E16_MASK, VDIVU_VX, 0x7, 0x10 }, // 837
  { PseudoVDIVU_VX_MF2_E32, VDIVU_VX, 0x7, 0x20 }, // 838
  { PseudoVDIVU_VX_MF2_E32_MASK, VDIVU_VX, 0x7, 0x20 }, // 839
  { PseudoVDIV_VV_M1_E8, VDIV_VV, 0x0, 0x8 }, // 840
  { PseudoVDIV_VV_M1_E8_MASK, VDIV_VV, 0x0, 0x8 }, // 841
  { PseudoVDIV_VV_M1_E16, VDIV_VV, 0x0, 0x10 }, // 842
  { PseudoVDIV_VV_M1_E16_MASK, VDIV_VV, 0x0, 0x10 }, // 843
  { PseudoVDIV_VV_M1_E32, VDIV_VV, 0x0, 0x20 }, // 844
  { PseudoVDIV_VV_M1_E32_MASK, VDIV_VV, 0x0, 0x20 }, // 845
  { PseudoVDIV_VV_M1_E64, VDIV_VV, 0x0, 0x40 }, // 846
  { PseudoVDIV_VV_M1_E64_MASK, VDIV_VV, 0x0, 0x40 }, // 847
  { PseudoVDIV_VV_M2_E8, VDIV_VV, 0x1, 0x8 }, // 848
  { PseudoVDIV_VV_M2_E8_MASK, VDIV_VV, 0x1, 0x8 }, // 849
  { PseudoVDIV_VV_M2_E16, VDIV_VV, 0x1, 0x10 }, // 850
  { PseudoVDIV_VV_M2_E16_MASK, VDIV_VV, 0x1, 0x10 }, // 851
  { PseudoVDIV_VV_M2_E32, VDIV_VV, 0x1, 0x20 }, // 852
  { PseudoVDIV_VV_M2_E32_MASK, VDIV_VV, 0x1, 0x20 }, // 853
  { PseudoVDIV_VV_M2_E64, VDIV_VV, 0x1, 0x40 }, // 854
  { PseudoVDIV_VV_M2_E64_MASK, VDIV_VV, 0x1, 0x40 }, // 855
  { PseudoVDIV_VV_M4_E8, VDIV_VV, 0x2, 0x8 }, // 856
  { PseudoVDIV_VV_M4_E8_MASK, VDIV_VV, 0x2, 0x8 }, // 857
  { PseudoVDIV_VV_M4_E16, VDIV_VV, 0x2, 0x10 }, // 858
  { PseudoVDIV_VV_M4_E16_MASK, VDIV_VV, 0x2, 0x10 }, // 859
  { PseudoVDIV_VV_M4_E32, VDIV_VV, 0x2, 0x20 }, // 860
  { PseudoVDIV_VV_M4_E32_MASK, VDIV_VV, 0x2, 0x20 }, // 861
  { PseudoVDIV_VV_M4_E64, VDIV_VV, 0x2, 0x40 }, // 862
  { PseudoVDIV_VV_M4_E64_MASK, VDIV_VV, 0x2, 0x40 }, // 863
  { PseudoVDIV_VV_M8_E8, VDIV_VV, 0x3, 0x8 }, // 864
  { PseudoVDIV_VV_M8_E8_MASK, VDIV_VV, 0x3, 0x8 }, // 865
  { PseudoVDIV_VV_M8_E16, VDIV_VV, 0x3, 0x10 }, // 866
  { PseudoVDIV_VV_M8_E16_MASK, VDIV_VV, 0x3, 0x10 }, // 867
  { PseudoVDIV_VV_M8_E32, VDIV_VV, 0x3, 0x20 }, // 868
  { PseudoVDIV_VV_M8_E32_MASK, VDIV_VV, 0x3, 0x20 }, // 869
  { PseudoVDIV_VV_M8_E64, VDIV_VV, 0x3, 0x40 }, // 870
  { PseudoVDIV_VV_M8_E64_MASK, VDIV_VV, 0x3, 0x40 }, // 871
  { PseudoVDIV_VV_MF8_E8, VDIV_VV, 0x5, 0x8 }, // 872
  { PseudoVDIV_VV_MF8_E8_MASK, VDIV_VV, 0x5, 0x8 }, // 873
  { PseudoVDIV_VV_MF4_E8, VDIV_VV, 0x6, 0x8 }, // 874
  { PseudoVDIV_VV_MF4_E8_MASK, VDIV_VV, 0x6, 0x8 }, // 875
  { PseudoVDIV_VV_MF4_E16, VDIV_VV, 0x6, 0x10 }, // 876
  { PseudoVDIV_VV_MF4_E16_MASK, VDIV_VV, 0x6, 0x10 }, // 877
  { PseudoVDIV_VV_MF2_E8, VDIV_VV, 0x7, 0x8 }, // 878
  { PseudoVDIV_VV_MF2_E8_MASK, VDIV_VV, 0x7, 0x8 }, // 879
  { PseudoVDIV_VV_MF2_E16, VDIV_VV, 0x7, 0x10 }, // 880
  { PseudoVDIV_VV_MF2_E16_MASK, VDIV_VV, 0x7, 0x10 }, // 881
  { PseudoVDIV_VV_MF2_E32, VDIV_VV, 0x7, 0x20 }, // 882
  { PseudoVDIV_VV_MF2_E32_MASK, VDIV_VV, 0x7, 0x20 }, // 883
  { PseudoVDIV_VX_M1_E8, VDIV_VX, 0x0, 0x8 }, // 884
  { PseudoVDIV_VX_M1_E8_MASK, VDIV_VX, 0x0, 0x8 }, // 885
  { PseudoVDIV_VX_M1_E16, VDIV_VX, 0x0, 0x10 }, // 886
  { PseudoVDIV_VX_M1_E16_MASK, VDIV_VX, 0x0, 0x10 }, // 887
  { PseudoVDIV_VX_M1_E32, VDIV_VX, 0x0, 0x20 }, // 888
  { PseudoVDIV_VX_M1_E32_MASK, VDIV_VX, 0x0, 0x20 }, // 889
  { PseudoVDIV_VX_M1_E64, VDIV_VX, 0x0, 0x40 }, // 890
  { PseudoVDIV_VX_M1_E64_MASK, VDIV_VX, 0x0, 0x40 }, // 891
  { PseudoVDIV_VX_M2_E8, VDIV_VX, 0x1, 0x8 }, // 892
  { PseudoVDIV_VX_M2_E8_MASK, VDIV_VX, 0x1, 0x8 }, // 893
  { PseudoVDIV_VX_M2_E16, VDIV_VX, 0x1, 0x10 }, // 894
  { PseudoVDIV_VX_M2_E16_MASK, VDIV_VX, 0x1, 0x10 }, // 895
  { PseudoVDIV_VX_M2_E32, VDIV_VX, 0x1, 0x20 }, // 896
  { PseudoVDIV_VX_M2_E32_MASK, VDIV_VX, 0x1, 0x20 }, // 897
  { PseudoVDIV_VX_M2_E64, VDIV_VX, 0x1, 0x40 }, // 898
  { PseudoVDIV_VX_M2_E64_MASK, VDIV_VX, 0x1, 0x40 }, // 899
  { PseudoVDIV_VX_M4_E8, VDIV_VX, 0x2, 0x8 }, // 900
  { PseudoVDIV_VX_M4_E8_MASK, VDIV_VX, 0x2, 0x8 }, // 901
  { PseudoVDIV_VX_M4_E16, VDIV_VX, 0x2, 0x10 }, // 902
  { PseudoVDIV_VX_M4_E16_MASK, VDIV_VX, 0x2, 0x10 }, // 903
  { PseudoVDIV_VX_M4_E32, VDIV_VX, 0x2, 0x20 }, // 904
  { PseudoVDIV_VX_M4_E32_MASK, VDIV_VX, 0x2, 0x20 }, // 905
  { PseudoVDIV_VX_M4_E64, VDIV_VX, 0x2, 0x40 }, // 906
  { PseudoVDIV_VX_M4_E64_MASK, VDIV_VX, 0x2, 0x40 }, // 907
  { PseudoVDIV_VX_M8_E8, VDIV_VX, 0x3, 0x8 }, // 908
  { PseudoVDIV_VX_M8_E8_MASK, VDIV_VX, 0x3, 0x8 }, // 909
  { PseudoVDIV_VX_M8_E16, VDIV_VX, 0x3, 0x10 }, // 910
  { PseudoVDIV_VX_M8_E16_MASK, VDIV_VX, 0x3, 0x10 }, // 911
  { PseudoVDIV_VX_M8_E32, VDIV_VX, 0x3, 0x20 }, // 912
  { PseudoVDIV_VX_M8_E32_MASK, VDIV_VX, 0x3, 0x20 }, // 913
  { PseudoVDIV_VX_M8_E64, VDIV_VX, 0x3, 0x40 }, // 914
  { PseudoVDIV_VX_M8_E64_MASK, VDIV_VX, 0x3, 0x40 }, // 915
  { PseudoVDIV_VX_MF8_E8, VDIV_VX, 0x5, 0x8 }, // 916
  { PseudoVDIV_VX_MF8_E8_MASK, VDIV_VX, 0x5, 0x8 }, // 917
  { PseudoVDIV_VX_MF4_E8, VDIV_VX, 0x6, 0x8 }, // 918
  { PseudoVDIV_VX_MF4_E8_MASK, VDIV_VX, 0x6, 0x8 }, // 919
  { PseudoVDIV_VX_MF4_E16, VDIV_VX, 0x6, 0x10 }, // 920
  { PseudoVDIV_VX_MF4_E16_MASK, VDIV_VX, 0x6, 0x10 }, // 921
  { PseudoVDIV_VX_MF2_E8, VDIV_VX, 0x7, 0x8 }, // 922
  { PseudoVDIV_VX_MF2_E8_MASK, VDIV_VX, 0x7, 0x8 }, // 923
  { PseudoVDIV_VX_MF2_E16, VDIV_VX, 0x7, 0x10 }, // 924
  { PseudoVDIV_VX_MF2_E16_MASK, VDIV_VX, 0x7, 0x10 }, // 925
  { PseudoVDIV_VX_MF2_E32, VDIV_VX, 0x7, 0x20 }, // 926
  { PseudoVDIV_VX_MF2_E32_MASK, VDIV_VX, 0x7, 0x20 }, // 927
  { PseudoVFADD_VF16_M1, VFADD_VF, 0x0, 0x0 }, // 928
  { PseudoVFADD_VF16_M1_MASK, VFADD_VF, 0x0, 0x0 }, // 929
  { PseudoVFADD_VF32_M1, VFADD_VF, 0x0, 0x0 }, // 930
  { PseudoVFADD_VF32_M1_MASK, VFADD_VF, 0x0, 0x0 }, // 931
  { PseudoVFADD_VF64_M1, VFADD_VF, 0x0, 0x0 }, // 932
  { PseudoVFADD_VF64_M1_MASK, VFADD_VF, 0x0, 0x0 }, // 933
  { PseudoVFADD_VF16_M2, VFADD_VF, 0x1, 0x0 }, // 934
  { PseudoVFADD_VF16_M2_MASK, VFADD_VF, 0x1, 0x0 }, // 935
  { PseudoVFADD_VF32_M2, VFADD_VF, 0x1, 0x0 }, // 936
  { PseudoVFADD_VF32_M2_MASK, VFADD_VF, 0x1, 0x0 }, // 937
  { PseudoVFADD_VF64_M2, VFADD_VF, 0x1, 0x0 }, // 938
  { PseudoVFADD_VF64_M2_MASK, VFADD_VF, 0x1, 0x0 }, // 939
  { PseudoVFADD_VF16_M4, VFADD_VF, 0x2, 0x0 }, // 940
  { PseudoVFADD_VF16_M4_MASK, VFADD_VF, 0x2, 0x0 }, // 941
  { PseudoVFADD_VF32_M4, VFADD_VF, 0x2, 0x0 }, // 942
  { PseudoVFADD_VF32_M4_MASK, VFADD_VF, 0x2, 0x0 }, // 943
  { PseudoVFADD_VF64_M4, VFADD_VF, 0x2, 0x0 }, // 944
  { PseudoVFADD_VF64_M4_MASK, VFADD_VF, 0x2, 0x0 }, // 945
  { PseudoVFADD_VF16_M8, VFADD_VF, 0x3, 0x0 }, // 946
  { PseudoVFADD_VF16_M8_MASK, VFADD_VF, 0x3, 0x0 }, // 947
  { PseudoVFADD_VF32_M8, VFADD_VF, 0x3, 0x0 }, // 948
  { PseudoVFADD_VF32_M8_MASK, VFADD_VF, 0x3, 0x0 }, // 949
  { PseudoVFADD_VF64_M8, VFADD_VF, 0x3, 0x0 }, // 950
  { PseudoVFADD_VF64_M8_MASK, VFADD_VF, 0x3, 0x0 }, // 951
  { PseudoVFADD_VF16_MF4, VFADD_VF, 0x6, 0x0 }, // 952
  { PseudoVFADD_VF16_MF4_MASK, VFADD_VF, 0x6, 0x0 }, // 953
  { PseudoVFADD_VF16_MF2, VFADD_VF, 0x7, 0x0 }, // 954
  { PseudoVFADD_VF16_MF2_MASK, VFADD_VF, 0x7, 0x0 }, // 955
  { PseudoVFADD_VF32_MF2, VFADD_VF, 0x7, 0x0 }, // 956
  { PseudoVFADD_VF32_MF2_MASK, VFADD_VF, 0x7, 0x0 }, // 957
  { PseudoVFADD_VV_M1, VFADD_VV, 0x0, 0x0 }, // 958
  { PseudoVFADD_VV_M1_MASK, VFADD_VV, 0x0, 0x0 }, // 959
  { PseudoVFADD_VV_M2, VFADD_VV, 0x1, 0x0 }, // 960
  { PseudoVFADD_VV_M2_MASK, VFADD_VV, 0x1, 0x0 }, // 961
  { PseudoVFADD_VV_M4, VFADD_VV, 0x2, 0x0 }, // 962
  { PseudoVFADD_VV_M4_MASK, VFADD_VV, 0x2, 0x0 }, // 963
  { PseudoVFADD_VV_M8, VFADD_VV, 0x3, 0x0 }, // 964
  { PseudoVFADD_VV_M8_MASK, VFADD_VV, 0x3, 0x0 }, // 965
  { PseudoVFADD_VV_MF4, VFADD_VV, 0x6, 0x0 }, // 966
  { PseudoVFADD_VV_MF4_MASK, VFADD_VV, 0x6, 0x0 }, // 967
  { PseudoVFADD_VV_MF2, VFADD_VV, 0x7, 0x0 }, // 968
  { PseudoVFADD_VV_MF2_MASK, VFADD_VV, 0x7, 0x0 }, // 969
  { PseudoVFCLASS_V_M1, VFCLASS_V, 0x0, 0x0 }, // 970
  { PseudoVFCLASS_V_M1_MASK, VFCLASS_V, 0x0, 0x0 }, // 971
  { PseudoVFCLASS_V_M2, VFCLASS_V, 0x1, 0x0 }, // 972
  { PseudoVFCLASS_V_M2_MASK, VFCLASS_V, 0x1, 0x0 }, // 973
  { PseudoVFCLASS_V_M4, VFCLASS_V, 0x2, 0x0 }, // 974
  { PseudoVFCLASS_V_M4_MASK, VFCLASS_V, 0x2, 0x0 }, // 975
  { PseudoVFCLASS_V_M8, VFCLASS_V, 0x3, 0x0 }, // 976
  { PseudoVFCLASS_V_M8_MASK, VFCLASS_V, 0x3, 0x0 }, // 977
  { PseudoVFCLASS_V_MF4, VFCLASS_V, 0x6, 0x0 }, // 978
  { PseudoVFCLASS_V_MF4_MASK, VFCLASS_V, 0x6, 0x0 }, // 979
  { PseudoVFCLASS_V_MF2, VFCLASS_V, 0x7, 0x0 }, // 980
  { PseudoVFCLASS_V_MF2_MASK, VFCLASS_V, 0x7, 0x0 }, // 981
  { PseudoVFCVT_F_XU_V_M1, VFCVT_F_XU_V, 0x0, 0x0 }, // 982
  { PseudoVFCVT_F_XU_V_M1_MASK, VFCVT_F_XU_V, 0x0, 0x0 }, // 983
  { PseudoVFCVT_F_XU_V_M2, VFCVT_F_XU_V, 0x1, 0x0 }, // 984
  { PseudoVFCVT_F_XU_V_M2_MASK, VFCVT_F_XU_V, 0x1, 0x0 }, // 985
  { PseudoVFCVT_F_XU_V_M4, VFCVT_F_XU_V, 0x2, 0x0 }, // 986
  { PseudoVFCVT_F_XU_V_M4_MASK, VFCVT_F_XU_V, 0x2, 0x0 }, // 987
  { PseudoVFCVT_F_XU_V_M8, VFCVT_F_XU_V, 0x3, 0x0 }, // 988
  { PseudoVFCVT_F_XU_V_M8_MASK, VFCVT_F_XU_V, 0x3, 0x0 }, // 989
  { PseudoVFCVT_F_XU_V_MF4, VFCVT_F_XU_V, 0x6, 0x0 }, // 990
  { PseudoVFCVT_F_XU_V_MF4_MASK, VFCVT_F_XU_V, 0x6, 0x0 }, // 991
  { PseudoVFCVT_F_XU_V_MF2, VFCVT_F_XU_V, 0x7, 0x0 }, // 992
  { PseudoVFCVT_F_XU_V_MF2_MASK, VFCVT_F_XU_V, 0x7, 0x0 }, // 993
  { PseudoVFCVT_F_X_V_M1, VFCVT_F_X_V, 0x0, 0x0 }, // 994
  { PseudoVFCVT_F_X_V_M1_MASK, VFCVT_F_X_V, 0x0, 0x0 }, // 995
  { PseudoVFCVT_F_X_V_M2, VFCVT_F_X_V, 0x1, 0x0 }, // 996
  { PseudoVFCVT_F_X_V_M2_MASK, VFCVT_F_X_V, 0x1, 0x0 }, // 997
  { PseudoVFCVT_F_X_V_M4, VFCVT_F_X_V, 0x2, 0x0 }, // 998
  { PseudoVFCVT_F_X_V_M4_MASK, VFCVT_F_X_V, 0x2, 0x0 }, // 999
  { PseudoVFCVT_F_X_V_M8, VFCVT_F_X_V, 0x3, 0x0 }, // 1000
  { PseudoVFCVT_F_X_V_M8_MASK, VFCVT_F_X_V, 0x3, 0x0 }, // 1001
  { PseudoVFCVT_F_X_V_MF4, VFCVT_F_X_V, 0x6, 0x0 }, // 1002
  { PseudoVFCVT_F_X_V_MF4_MASK, VFCVT_F_X_V, 0x6, 0x0 }, // 1003
  { PseudoVFCVT_F_X_V_MF2, VFCVT_F_X_V, 0x7, 0x0 }, // 1004
  { PseudoVFCVT_F_X_V_MF2_MASK, VFCVT_F_X_V, 0x7, 0x0 }, // 1005
  { PseudoVFCVT_RTZ_XU_F_V_M1, VFCVT_RTZ_XU_F_V, 0x0, 0x0 }, // 1006
  { PseudoVFCVT_RTZ_XU_F_V_M1_MASK, VFCVT_RTZ_XU_F_V, 0x0, 0x0 }, // 1007
  { PseudoVFCVT_RTZ_XU_F_V_M2, VFCVT_RTZ_XU_F_V, 0x1, 0x0 }, // 1008
  { PseudoVFCVT_RTZ_XU_F_V_M2_MASK, VFCVT_RTZ_XU_F_V, 0x1, 0x0 }, // 1009
  { PseudoVFCVT_RTZ_XU_F_V_M4, VFCVT_RTZ_XU_F_V, 0x2, 0x0 }, // 1010
  { PseudoVFCVT_RTZ_XU_F_V_M4_MASK, VFCVT_RTZ_XU_F_V, 0x2, 0x0 }, // 1011
  { PseudoVFCVT_RTZ_XU_F_V_M8, VFCVT_RTZ_XU_F_V, 0x3, 0x0 }, // 1012
  { PseudoVFCVT_RTZ_XU_F_V_M8_MASK, VFCVT_RTZ_XU_F_V, 0x3, 0x0 }, // 1013
  { PseudoVFCVT_RTZ_XU_F_V_MF4, VFCVT_RTZ_XU_F_V, 0x6, 0x0 }, // 1014
  { PseudoVFCVT_RTZ_XU_F_V_MF4_MASK, VFCVT_RTZ_XU_F_V, 0x6, 0x0 }, // 1015
  { PseudoVFCVT_RTZ_XU_F_V_MF2, VFCVT_RTZ_XU_F_V, 0x7, 0x0 }, // 1016
  { PseudoVFCVT_RTZ_XU_F_V_MF2_MASK, VFCVT_RTZ_XU_F_V, 0x7, 0x0 }, // 1017
  { PseudoVFCVT_RTZ_X_F_V_M1, VFCVT_RTZ_X_F_V, 0x0, 0x0 }, // 1018
  { PseudoVFCVT_RTZ_X_F_V_M1_MASK, VFCVT_RTZ_X_F_V, 0x0, 0x0 }, // 1019
  { PseudoVFCVT_RTZ_X_F_V_M2, VFCVT_RTZ_X_F_V, 0x1, 0x0 }, // 1020
  { PseudoVFCVT_RTZ_X_F_V_M2_MASK, VFCVT_RTZ_X_F_V, 0x1, 0x0 }, // 1021
  { PseudoVFCVT_RTZ_X_F_V_M4, VFCVT_RTZ_X_F_V, 0x2, 0x0 }, // 1022
  { PseudoVFCVT_RTZ_X_F_V_M4_MASK, VFCVT_RTZ_X_F_V, 0x2, 0x0 }, // 1023
  { PseudoVFCVT_RTZ_X_F_V_M8, VFCVT_RTZ_X_F_V, 0x3, 0x0 }, // 1024
  { PseudoVFCVT_RTZ_X_F_V_M8_MASK, VFCVT_RTZ_X_F_V, 0x3, 0x0 }, // 1025
  { PseudoVFCVT_RTZ_X_F_V_MF4, VFCVT_RTZ_X_F_V, 0x6, 0x0 }, // 1026
  { PseudoVFCVT_RTZ_X_F_V_MF4_MASK, VFCVT_RTZ_X_F_V, 0x6, 0x0 }, // 1027
  { PseudoVFCVT_RTZ_X_F_V_MF2, VFCVT_RTZ_X_F_V, 0x7, 0x0 }, // 1028
  { PseudoVFCVT_RTZ_X_F_V_MF2_MASK, VFCVT_RTZ_X_F_V, 0x7, 0x0 }, // 1029
  { PseudoVFCVT_XU_F_V_M1, VFCVT_XU_F_V, 0x0, 0x0 }, // 1030
  { PseudoVFCVT_XU_F_V_M1_MASK, VFCVT_XU_F_V, 0x0, 0x0 }, // 1031
  { PseudoVFCVT_XU_F_V_M2, VFCVT_XU_F_V, 0x1, 0x0 }, // 1032
  { PseudoVFCVT_XU_F_V_M2_MASK, VFCVT_XU_F_V, 0x1, 0x0 }, // 1033
  { PseudoVFCVT_XU_F_V_M4, VFCVT_XU_F_V, 0x2, 0x0 }, // 1034
  { PseudoVFCVT_XU_F_V_M4_MASK, VFCVT_XU_F_V, 0x2, 0x0 }, // 1035
  { PseudoVFCVT_XU_F_V_M8, VFCVT_XU_F_V, 0x3, 0x0 }, // 1036
  { PseudoVFCVT_XU_F_V_M8_MASK, VFCVT_XU_F_V, 0x3, 0x0 }, // 1037
  { PseudoVFCVT_XU_F_V_MF4, VFCVT_XU_F_V, 0x6, 0x0 }, // 1038
  { PseudoVFCVT_XU_F_V_MF4_MASK, VFCVT_XU_F_V, 0x6, 0x0 }, // 1039
  { PseudoVFCVT_XU_F_V_MF2, VFCVT_XU_F_V, 0x7, 0x0 }, // 1040
  { PseudoVFCVT_XU_F_V_MF2_MASK, VFCVT_XU_F_V, 0x7, 0x0 }, // 1041
  { PseudoVFCVT_X_F_V_M1, VFCVT_X_F_V, 0x0, 0x0 }, // 1042
  { PseudoVFCVT_X_F_V_M1_MASK, VFCVT_X_F_V, 0x0, 0x0 }, // 1043
  { PseudoVFCVT_X_F_V_M2, VFCVT_X_F_V, 0x1, 0x0 }, // 1044
  { PseudoVFCVT_X_F_V_M2_MASK, VFCVT_X_F_V, 0x1, 0x0 }, // 1045
  { PseudoVFCVT_X_F_V_M4, VFCVT_X_F_V, 0x2, 0x0 }, // 1046
  { PseudoVFCVT_X_F_V_M4_MASK, VFCVT_X_F_V, 0x2, 0x0 }, // 1047
  { PseudoVFCVT_X_F_V_M8, VFCVT_X_F_V, 0x3, 0x0 }, // 1048
  { PseudoVFCVT_X_F_V_M8_MASK, VFCVT_X_F_V, 0x3, 0x0 }, // 1049
  { PseudoVFCVT_X_F_V_MF4, VFCVT_X_F_V, 0x6, 0x0 }, // 1050
  { PseudoVFCVT_X_F_V_MF4_MASK, VFCVT_X_F_V, 0x6, 0x0 }, // 1051
  { PseudoVFCVT_X_F_V_MF2, VFCVT_X_F_V, 0x7, 0x0 }, // 1052
  { PseudoVFCVT_X_F_V_MF2_MASK, VFCVT_X_F_V, 0x7, 0x0 }, // 1053
  { PseudoVFDIV_VF16_M1_E16, VFDIV_VF, 0x0, 0x10 }, // 1054
  { PseudoVFDIV_VF16_M1_E16_MASK, VFDIV_VF, 0x0, 0x10 }, // 1055
  { PseudoVFDIV_VF32_M1_E32, VFDIV_VF, 0x0, 0x20 }, // 1056
  { PseudoVFDIV_VF32_M1_E32_MASK, VFDIV_VF, 0x0, 0x20 }, // 1057
  { PseudoVFDIV_VF64_M1_E64, VFDIV_VF, 0x0, 0x40 }, // 1058
  { PseudoVFDIV_VF64_M1_E64_MASK, VFDIV_VF, 0x0, 0x40 }, // 1059
  { PseudoVFDIV_VF16_M2_E16, VFDIV_VF, 0x1, 0x10 }, // 1060
  { PseudoVFDIV_VF16_M2_E16_MASK, VFDIV_VF, 0x1, 0x10 }, // 1061
  { PseudoVFDIV_VF32_M2_E32, VFDIV_VF, 0x1, 0x20 }, // 1062
  { PseudoVFDIV_VF32_M2_E32_MASK, VFDIV_VF, 0x1, 0x20 }, // 1063
  { PseudoVFDIV_VF64_M2_E64, VFDIV_VF, 0x1, 0x40 }, // 1064
  { PseudoVFDIV_VF64_M2_E64_MASK, VFDIV_VF, 0x1, 0x40 }, // 1065
  { PseudoVFDIV_VF16_M4_E16, VFDIV_VF, 0x2, 0x10 }, // 1066
  { PseudoVFDIV_VF16_M4_E16_MASK, VFDIV_VF, 0x2, 0x10 }, // 1067
  { PseudoVFDIV_VF32_M4_E32, VFDIV_VF, 0x2, 0x20 }, // 1068
  { PseudoVFDIV_VF32_M4_E32_MASK, VFDIV_VF, 0x2, 0x20 }, // 1069
  { PseudoVFDIV_VF64_M4_E64, VFDIV_VF, 0x2, 0x40 }, // 1070
  { PseudoVFDIV_VF64_M4_E64_MASK, VFDIV_VF, 0x2, 0x40 }, // 1071
  { PseudoVFDIV_VF16_M8_E16, VFDIV_VF, 0x3, 0x10 }, // 1072
  { PseudoVFDIV_VF16_M8_E16_MASK, VFDIV_VF, 0x3, 0x10 }, // 1073
  { PseudoVFDIV_VF32_M8_E32, VFDIV_VF, 0x3, 0x20 }, // 1074
  { PseudoVFDIV_VF32_M8_E32_MASK, VFDIV_VF, 0x3, 0x20 }, // 1075
  { PseudoVFDIV_VF64_M8_E64, VFDIV_VF, 0x3, 0x40 }, // 1076
  { PseudoVFDIV_VF64_M8_E64_MASK, VFDIV_VF, 0x3, 0x40 }, // 1077
  { PseudoVFDIV_VF16_MF4_E16, VFDIV_VF, 0x6, 0x10 }, // 1078
  { PseudoVFDIV_VF16_MF4_E16_MASK, VFDIV_VF, 0x6, 0x10 }, // 1079
  { PseudoVFDIV_VF16_MF2_E16, VFDIV_VF, 0x7, 0x10 }, // 1080
  { PseudoVFDIV_VF16_MF2_E16_MASK, VFDIV_VF, 0x7, 0x10 }, // 1081
  { PseudoVFDIV_VF32_MF2_E32, VFDIV_VF, 0x7, 0x20 }, // 1082
  { PseudoVFDIV_VF32_MF2_E32_MASK, VFDIV_VF, 0x7, 0x20 }, // 1083
  { PseudoVFDIV_VV_M1_E16, VFDIV_VV, 0x0, 0x10 }, // 1084
  { PseudoVFDIV_VV_M1_E16_MASK, VFDIV_VV, 0x0, 0x10 }, // 1085
  { PseudoVFDIV_VV_M1_E32, VFDIV_VV, 0x0, 0x20 }, // 1086
  { PseudoVFDIV_VV_M1_E32_MASK, VFDIV_VV, 0x0, 0x20 }, // 1087
  { PseudoVFDIV_VV_M1_E64, VFDIV_VV, 0x0, 0x40 }, // 1088
  { PseudoVFDIV_VV_M1_E64_MASK, VFDIV_VV, 0x0, 0x40 }, // 1089
  { PseudoVFDIV_VV_M2_E16, VFDIV_VV, 0x1, 0x10 }, // 1090
  { PseudoVFDIV_VV_M2_E16_MASK, VFDIV_VV, 0x1, 0x10 }, // 1091
  { PseudoVFDIV_VV_M2_E32, VFDIV_VV, 0x1, 0x20 }, // 1092
  { PseudoVFDIV_VV_M2_E32_MASK, VFDIV_VV, 0x1, 0x20 }, // 1093
  { PseudoVFDIV_VV_M2_E64, VFDIV_VV, 0x1, 0x40 }, // 1094
  { PseudoVFDIV_VV_M2_E64_MASK, VFDIV_VV, 0x1, 0x40 }, // 1095
  { PseudoVFDIV_VV_M4_E16, VFDIV_VV, 0x2, 0x10 }, // 1096
  { PseudoVFDIV_VV_M4_E16_MASK, VFDIV_VV, 0x2, 0x10 }, // 1097
  { PseudoVFDIV_VV_M4_E32, VFDIV_VV, 0x2, 0x20 }, // 1098
  { PseudoVFDIV_VV_M4_E32_MASK, VFDIV_VV, 0x2, 0x20 }, // 1099
  { PseudoVFDIV_VV_M4_E64, VFDIV_VV, 0x2, 0x40 }, // 1100
  { PseudoVFDIV_VV_M4_E64_MASK, VFDIV_VV, 0x2, 0x40 }, // 1101
  { PseudoVFDIV_VV_M8_E16, VFDIV_VV, 0x3, 0x10 }, // 1102
  { PseudoVFDIV_VV_M8_E16_MASK, VFDIV_VV, 0x3, 0x10 }, // 1103
  { PseudoVFDIV_VV_M8_E32, VFDIV_VV, 0x3, 0x20 }, // 1104
  { PseudoVFDIV_VV_M8_E32_MASK, VFDIV_VV, 0x3, 0x20 }, // 1105
  { PseudoVFDIV_VV_M8_E64, VFDIV_VV, 0x3, 0x40 }, // 1106
  { PseudoVFDIV_VV_M8_E64_MASK, VFDIV_VV, 0x3, 0x40 }, // 1107
  { PseudoVFDIV_VV_MF4_E16, VFDIV_VV, 0x6, 0x10 }, // 1108
  { PseudoVFDIV_VV_MF4_E16_MASK, VFDIV_VV, 0x6, 0x10 }, // 1109
  { PseudoVFDIV_VV_MF2_E16, VFDIV_VV, 0x7, 0x10 }, // 1110
  { PseudoVFDIV_VV_MF2_E16_MASK, VFDIV_VV, 0x7, 0x10 }, // 1111
  { PseudoVFDIV_VV_MF2_E32, VFDIV_VV, 0x7, 0x20 }, // 1112
  { PseudoVFDIV_VV_MF2_E32_MASK, VFDIV_VV, 0x7, 0x20 }, // 1113
  { PseudoVFIRST_M_B8, VFIRST_M, 0x0, 0x0 }, // 1114
  { PseudoVFIRST_M_B8_MASK, VFIRST_M, 0x0, 0x0 }, // 1115
  { PseudoVFIRST_M_B16, VFIRST_M, 0x1, 0x0 }, // 1116
  { PseudoVFIRST_M_B16_MASK, VFIRST_M, 0x1, 0x0 }, // 1117
  { PseudoVFIRST_M_B32, VFIRST_M, 0x2, 0x0 }, // 1118
  { PseudoVFIRST_M_B32_MASK, VFIRST_M, 0x2, 0x0 }, // 1119
  { PseudoVFIRST_M_B64, VFIRST_M, 0x3, 0x0 }, // 1120
  { PseudoVFIRST_M_B64_MASK, VFIRST_M, 0x3, 0x0 }, // 1121
  { PseudoVFIRST_M_B1, VFIRST_M, 0x5, 0x0 }, // 1122
  { PseudoVFIRST_M_B1_MASK, VFIRST_M, 0x5, 0x0 }, // 1123
  { PseudoVFIRST_M_B2, VFIRST_M, 0x6, 0x0 }, // 1124
  { PseudoVFIRST_M_B2_MASK, VFIRST_M, 0x6, 0x0 }, // 1125
  { PseudoVFIRST_M_B4, VFIRST_M, 0x7, 0x0 }, // 1126
  { PseudoVFIRST_M_B4_MASK, VFIRST_M, 0x7, 0x0 }, // 1127
  { PseudoVFMACC_VF16_M1, VFMACC_VF, 0x0, 0x0 }, // 1128
  { PseudoVFMACC_VF16_M1_MASK, VFMACC_VF, 0x0, 0x0 }, // 1129
  { PseudoVFMACC_VF32_M1, VFMACC_VF, 0x0, 0x0 }, // 1130
  { PseudoVFMACC_VF32_M1_MASK, VFMACC_VF, 0x0, 0x0 }, // 1131
  { PseudoVFMACC_VF64_M1, VFMACC_VF, 0x0, 0x0 }, // 1132
  { PseudoVFMACC_VF64_M1_MASK, VFMACC_VF, 0x0, 0x0 }, // 1133
  { PseudoVFMACC_VF16_M2, VFMACC_VF, 0x1, 0x0 }, // 1134
  { PseudoVFMACC_VF16_M2_MASK, VFMACC_VF, 0x1, 0x0 }, // 1135
  { PseudoVFMACC_VF32_M2, VFMACC_VF, 0x1, 0x0 }, // 1136
  { PseudoVFMACC_VF32_M2_MASK, VFMACC_VF, 0x1, 0x0 }, // 1137
  { PseudoVFMACC_VF64_M2, VFMACC_VF, 0x1, 0x0 }, // 1138
  { PseudoVFMACC_VF64_M2_MASK, VFMACC_VF, 0x1, 0x0 }, // 1139
  { PseudoVFMACC_VF16_M4, VFMACC_VF, 0x2, 0x0 }, // 1140
  { PseudoVFMACC_VF16_M4_MASK, VFMACC_VF, 0x2, 0x0 }, // 1141
  { PseudoVFMACC_VF32_M4, VFMACC_VF, 0x2, 0x0 }, // 1142
  { PseudoVFMACC_VF32_M4_MASK, VFMACC_VF, 0x2, 0x0 }, // 1143
  { PseudoVFMACC_VF64_M4, VFMACC_VF, 0x2, 0x0 }, // 1144
  { PseudoVFMACC_VF64_M4_MASK, VFMACC_VF, 0x2, 0x0 }, // 1145
  { PseudoVFMACC_VF16_M8, VFMACC_VF, 0x3, 0x0 }, // 1146
  { PseudoVFMACC_VF16_M8_MASK, VFMACC_VF, 0x3, 0x0 }, // 1147
  { PseudoVFMACC_VF32_M8, VFMACC_VF, 0x3, 0x0 }, // 1148
  { PseudoVFMACC_VF32_M8_MASK, VFMACC_VF, 0x3, 0x0 }, // 1149
  { PseudoVFMACC_VF64_M8, VFMACC_VF, 0x3, 0x0 }, // 1150
  { PseudoVFMACC_VF64_M8_MASK, VFMACC_VF, 0x3, 0x0 }, // 1151
  { PseudoVFMACC_VF16_MF4, VFMACC_VF, 0x6, 0x0 }, // 1152
  { PseudoVFMACC_VF16_MF4_MASK, VFMACC_VF, 0x6, 0x0 }, // 1153
  { PseudoVFMACC_VF16_MF2, VFMACC_VF, 0x7, 0x0 }, // 1154
  { PseudoVFMACC_VF16_MF2_MASK, VFMACC_VF, 0x7, 0x0 }, // 1155
  { PseudoVFMACC_VF32_MF2, VFMACC_VF, 0x7, 0x0 }, // 1156
  { PseudoVFMACC_VF32_MF2_MASK, VFMACC_VF, 0x7, 0x0 }, // 1157
  { PseudoVFMACC_VV_M1, VFMACC_VV, 0x0, 0x0 }, // 1158
  { PseudoVFMACC_VV_M1_MASK, VFMACC_VV, 0x0, 0x0 }, // 1159
  { PseudoVFMACC_VV_M2, VFMACC_VV, 0x1, 0x0 }, // 1160
  { PseudoVFMACC_VV_M2_MASK, VFMACC_VV, 0x1, 0x0 }, // 1161
  { PseudoVFMACC_VV_M4, VFMACC_VV, 0x2, 0x0 }, // 1162
  { PseudoVFMACC_VV_M4_MASK, VFMACC_VV, 0x2, 0x0 }, // 1163
  { PseudoVFMACC_VV_M8, VFMACC_VV, 0x3, 0x0 }, // 1164
  { PseudoVFMACC_VV_M8_MASK, VFMACC_VV, 0x3, 0x0 }, // 1165
  { PseudoVFMACC_VV_MF4, VFMACC_VV, 0x6, 0x0 }, // 1166
  { PseudoVFMACC_VV_MF4_MASK, VFMACC_VV, 0x6, 0x0 }, // 1167
  { PseudoVFMACC_VV_MF2, VFMACC_VV, 0x7, 0x0 }, // 1168
  { PseudoVFMACC_VV_MF2_MASK, VFMACC_VV, 0x7, 0x0 }, // 1169
  { PseudoVFMADD_VF16_M1, VFMADD_VF, 0x0, 0x0 }, // 1170
  { PseudoVFMADD_VF16_M1_MASK, VFMADD_VF, 0x0, 0x0 }, // 1171
  { PseudoVFMADD_VF32_M1, VFMADD_VF, 0x0, 0x0 }, // 1172
  { PseudoVFMADD_VF32_M1_MASK, VFMADD_VF, 0x0, 0x0 }, // 1173
  { PseudoVFMADD_VF64_M1, VFMADD_VF, 0x0, 0x0 }, // 1174
  { PseudoVFMADD_VF64_M1_MASK, VFMADD_VF, 0x0, 0x0 }, // 1175
  { PseudoVFMADD_VF16_M2, VFMADD_VF, 0x1, 0x0 }, // 1176
  { PseudoVFMADD_VF16_M2_MASK, VFMADD_VF, 0x1, 0x0 }, // 1177
  { PseudoVFMADD_VF32_M2, VFMADD_VF, 0x1, 0x0 }, // 1178
  { PseudoVFMADD_VF32_M2_MASK, VFMADD_VF, 0x1, 0x0 }, // 1179
  { PseudoVFMADD_VF64_M2, VFMADD_VF, 0x1, 0x0 }, // 1180
  { PseudoVFMADD_VF64_M2_MASK, VFMADD_VF, 0x1, 0x0 }, // 1181
  { PseudoVFMADD_VF16_M4, VFMADD_VF, 0x2, 0x0 }, // 1182
  { PseudoVFMADD_VF16_M4_MASK, VFMADD_VF, 0x2, 0x0 }, // 1183
  { PseudoVFMADD_VF32_M4, VFMADD_VF, 0x2, 0x0 }, // 1184
  { PseudoVFMADD_VF32_M4_MASK, VFMADD_VF, 0x2, 0x0 }, // 1185
  { PseudoVFMADD_VF64_M4, VFMADD_VF, 0x2, 0x0 }, // 1186
  { PseudoVFMADD_VF64_M4_MASK, VFMADD_VF, 0x2, 0x0 }, // 1187
  { PseudoVFMADD_VF16_M8, VFMADD_VF, 0x3, 0x0 }, // 1188
  { PseudoVFMADD_VF16_M8_MASK, VFMADD_VF, 0x3, 0x0 }, // 1189
  { PseudoVFMADD_VF32_M8, VFMADD_VF, 0x3, 0x0 }, // 1190
  { PseudoVFMADD_VF32_M8_MASK, VFMADD_VF, 0x3, 0x0 }, // 1191
  { PseudoVFMADD_VF64_M8, VFMADD_VF, 0x3, 0x0 }, // 1192
  { PseudoVFMADD_VF64_M8_MASK, VFMADD_VF, 0x3, 0x0 }, // 1193
  { PseudoVFMADD_VF16_MF4, VFMADD_VF, 0x6, 0x0 }, // 1194
  { PseudoVFMADD_VF16_MF4_MASK, VFMADD_VF, 0x6, 0x0 }, // 1195
  { PseudoVFMADD_VF16_MF2, VFMADD_VF, 0x7, 0x0 }, // 1196
  { PseudoVFMADD_VF16_MF2_MASK, VFMADD_VF, 0x7, 0x0 }, // 1197
  { PseudoVFMADD_VF32_MF2, VFMADD_VF, 0x7, 0x0 }, // 1198
  { PseudoVFMADD_VF32_MF2_MASK, VFMADD_VF, 0x7, 0x0 }, // 1199
  { PseudoVFMADD_VV_M1, VFMADD_VV, 0x0, 0x0 }, // 1200
  { PseudoVFMADD_VV_M1_MASK, VFMADD_VV, 0x0, 0x0 }, // 1201
  { PseudoVFMADD_VV_M2, VFMADD_VV, 0x1, 0x0 }, // 1202
  { PseudoVFMADD_VV_M2_MASK, VFMADD_VV, 0x1, 0x0 }, // 1203
  { PseudoVFMADD_VV_M4, VFMADD_VV, 0x2, 0x0 }, // 1204
  { PseudoVFMADD_VV_M4_MASK, VFMADD_VV, 0x2, 0x0 }, // 1205
  { PseudoVFMADD_VV_M8, VFMADD_VV, 0x3, 0x0 }, // 1206
  { PseudoVFMADD_VV_M8_MASK, VFMADD_VV, 0x3, 0x0 }, // 1207
  { PseudoVFMADD_VV_MF4, VFMADD_VV, 0x6, 0x0 }, // 1208
  { PseudoVFMADD_VV_MF4_MASK, VFMADD_VV, 0x6, 0x0 }, // 1209
  { PseudoVFMADD_VV_MF2, VFMADD_VV, 0x7, 0x0 }, // 1210
  { PseudoVFMADD_VV_MF2_MASK, VFMADD_VV, 0x7, 0x0 }, // 1211
  { PseudoVFMAX_VF16_M1, VFMAX_VF, 0x0, 0x0 }, // 1212
  { PseudoVFMAX_VF16_M1_MASK, VFMAX_VF, 0x0, 0x0 }, // 1213
  { PseudoVFMAX_VF32_M1, VFMAX_VF, 0x0, 0x0 }, // 1214
  { PseudoVFMAX_VF32_M1_MASK, VFMAX_VF, 0x0, 0x0 }, // 1215
  { PseudoVFMAX_VF64_M1, VFMAX_VF, 0x0, 0x0 }, // 1216
  { PseudoVFMAX_VF64_M1_MASK, VFMAX_VF, 0x0, 0x0 }, // 1217
  { PseudoVFMAX_VF16_M2, VFMAX_VF, 0x1, 0x0 }, // 1218
  { PseudoVFMAX_VF16_M2_MASK, VFMAX_VF, 0x1, 0x0 }, // 1219
  { PseudoVFMAX_VF32_M2, VFMAX_VF, 0x1, 0x0 }, // 1220
  { PseudoVFMAX_VF32_M2_MASK, VFMAX_VF, 0x1, 0x0 }, // 1221
  { PseudoVFMAX_VF64_M2, VFMAX_VF, 0x1, 0x0 }, // 1222
  { PseudoVFMAX_VF64_M2_MASK, VFMAX_VF, 0x1, 0x0 }, // 1223
  { PseudoVFMAX_VF16_M4, VFMAX_VF, 0x2, 0x0 }, // 1224
  { PseudoVFMAX_VF16_M4_MASK, VFMAX_VF, 0x2, 0x0 }, // 1225
  { PseudoVFMAX_VF32_M4, VFMAX_VF, 0x2, 0x0 }, // 1226
  { PseudoVFMAX_VF32_M4_MASK, VFMAX_VF, 0x2, 0x0 }, // 1227
  { PseudoVFMAX_VF64_M4, VFMAX_VF, 0x2, 0x0 }, // 1228
  { PseudoVFMAX_VF64_M4_MASK, VFMAX_VF, 0x2, 0x0 }, // 1229
  { PseudoVFMAX_VF16_M8, VFMAX_VF, 0x3, 0x0 }, // 1230
  { PseudoVFMAX_VF16_M8_MASK, VFMAX_VF, 0x3, 0x0 }, // 1231
  { PseudoVFMAX_VF32_M8, VFMAX_VF, 0x3, 0x0 }, // 1232
  { PseudoVFMAX_VF32_M8_MASK, VFMAX_VF, 0x3, 0x0 }, // 1233
  { PseudoVFMAX_VF64_M8, VFMAX_VF, 0x3, 0x0 }, // 1234
  { PseudoVFMAX_VF64_M8_MASK, VFMAX_VF, 0x3, 0x0 }, // 1235
  { PseudoVFMAX_VF16_MF4, VFMAX_VF, 0x6, 0x0 }, // 1236
  { PseudoVFMAX_VF16_MF4_MASK, VFMAX_VF, 0x6, 0x0 }, // 1237
  { PseudoVFMAX_VF16_MF2, VFMAX_VF, 0x7, 0x0 }, // 1238
  { PseudoVFMAX_VF16_MF2_MASK, VFMAX_VF, 0x7, 0x0 }, // 1239
  { PseudoVFMAX_VF32_MF2, VFMAX_VF, 0x7, 0x0 }, // 1240
  { PseudoVFMAX_VF32_MF2_MASK, VFMAX_VF, 0x7, 0x0 }, // 1241
  { PseudoVFMAX_VV_M1, VFMAX_VV, 0x0, 0x0 }, // 1242
  { PseudoVFMAX_VV_M1_MASK, VFMAX_VV, 0x0, 0x0 }, // 1243
  { PseudoVFMAX_VV_M2, VFMAX_VV, 0x1, 0x0 }, // 1244
  { PseudoVFMAX_VV_M2_MASK, VFMAX_VV, 0x1, 0x0 }, // 1245
  { PseudoVFMAX_VV_M4, VFMAX_VV, 0x2, 0x0 }, // 1246
  { PseudoVFMAX_VV_M4_MASK, VFMAX_VV, 0x2, 0x0 }, // 1247
  { PseudoVFMAX_VV_M8, VFMAX_VV, 0x3, 0x0 }, // 1248
  { PseudoVFMAX_VV_M8_MASK, VFMAX_VV, 0x3, 0x0 }, // 1249
  { PseudoVFMAX_VV_MF4, VFMAX_VV, 0x6, 0x0 }, // 1250
  { PseudoVFMAX_VV_MF4_MASK, VFMAX_VV, 0x6, 0x0 }, // 1251
  { PseudoVFMAX_VV_MF2, VFMAX_VV, 0x7, 0x0 }, // 1252
  { PseudoVFMAX_VV_MF2_MASK, VFMAX_VV, 0x7, 0x0 }, // 1253
  { PseudoVFMERGE_VF16M_M1, VFMERGE_VFM, 0x0, 0x0 }, // 1254
  { PseudoVFMERGE_VF32M_M1, VFMERGE_VFM, 0x0, 0x0 }, // 1255
  { PseudoVFMERGE_VF64M_M1, VFMERGE_VFM, 0x0, 0x0 }, // 1256
  { PseudoVFMERGE_VF16M_M2, VFMERGE_VFM, 0x1, 0x0 }, // 1257
  { PseudoVFMERGE_VF32M_M2, VFMERGE_VFM, 0x1, 0x0 }, // 1258
  { PseudoVFMERGE_VF64M_M2, VFMERGE_VFM, 0x1, 0x0 }, // 1259
  { PseudoVFMERGE_VF16M_M4, VFMERGE_VFM, 0x2, 0x0 }, // 1260
  { PseudoVFMERGE_VF32M_M4, VFMERGE_VFM, 0x2, 0x0 }, // 1261
  { PseudoVFMERGE_VF64M_M4, VFMERGE_VFM, 0x2, 0x0 }, // 1262
  { PseudoVFMERGE_VF16M_M8, VFMERGE_VFM, 0x3, 0x0 }, // 1263
  { PseudoVFMERGE_VF32M_M8, VFMERGE_VFM, 0x3, 0x0 }, // 1264
  { PseudoVFMERGE_VF64M_M8, VFMERGE_VFM, 0x3, 0x0 }, // 1265
  { PseudoVFMERGE_VF16M_MF4, VFMERGE_VFM, 0x6, 0x0 }, // 1266
  { PseudoVFMERGE_VF16M_MF2, VFMERGE_VFM, 0x7, 0x0 }, // 1267
  { PseudoVFMERGE_VF32M_MF2, VFMERGE_VFM, 0x7, 0x0 }, // 1268
  { PseudoVFMIN_VF16_M1, VFMIN_VF, 0x0, 0x0 }, // 1269
  { PseudoVFMIN_VF16_M1_MASK, VFMIN_VF, 0x0, 0x0 }, // 1270
  { PseudoVFMIN_VF32_M1, VFMIN_VF, 0x0, 0x0 }, // 1271
  { PseudoVFMIN_VF32_M1_MASK, VFMIN_VF, 0x0, 0x0 }, // 1272
  { PseudoVFMIN_VF64_M1, VFMIN_VF, 0x0, 0x0 }, // 1273
  { PseudoVFMIN_VF64_M1_MASK, VFMIN_VF, 0x0, 0x0 }, // 1274
  { PseudoVFMIN_VF16_M2, VFMIN_VF, 0x1, 0x0 }, // 1275
  { PseudoVFMIN_VF16_M2_MASK, VFMIN_VF, 0x1, 0x0 }, // 1276
  { PseudoVFMIN_VF32_M2, VFMIN_VF, 0x1, 0x0 }, // 1277
  { PseudoVFMIN_VF32_M2_MASK, VFMIN_VF, 0x1, 0x0 }, // 1278
  { PseudoVFMIN_VF64_M2, VFMIN_VF, 0x1, 0x0 }, // 1279
  { PseudoVFMIN_VF64_M2_MASK, VFMIN_VF, 0x1, 0x0 }, // 1280
  { PseudoVFMIN_VF16_M4, VFMIN_VF, 0x2, 0x0 }, // 1281
  { PseudoVFMIN_VF16_M4_MASK, VFMIN_VF, 0x2, 0x0 }, // 1282
  { PseudoVFMIN_VF32_M4, VFMIN_VF, 0x2, 0x0 }, // 1283
  { PseudoVFMIN_VF32_M4_MASK, VFMIN_VF, 0x2, 0x0 }, // 1284
  { PseudoVFMIN_VF64_M4, VFMIN_VF, 0x2, 0x0 }, // 1285
  { PseudoVFMIN_VF64_M4_MASK, VFMIN_VF, 0x2, 0x0 }, // 1286
  { PseudoVFMIN_VF16_M8, VFMIN_VF, 0x3, 0x0 }, // 1287
  { PseudoVFMIN_VF16_M8_MASK, VFMIN_VF, 0x3, 0x0 }, // 1288
  { PseudoVFMIN_VF32_M8, VFMIN_VF, 0x3, 0x0 }, // 1289
  { PseudoVFMIN_VF32_M8_MASK, VFMIN_VF, 0x3, 0x0 }, // 1290
  { PseudoVFMIN_VF64_M8, VFMIN_VF, 0x3, 0x0 }, // 1291
  { PseudoVFMIN_VF64_M8_MASK, VFMIN_VF, 0x3, 0x0 }, // 1292
  { PseudoVFMIN_VF16_MF4, VFMIN_VF, 0x6, 0x0 }, // 1293
  { PseudoVFMIN_VF16_MF4_MASK, VFMIN_VF, 0x6, 0x0 }, // 1294
  { PseudoVFMIN_VF16_MF2, VFMIN_VF, 0x7, 0x0 }, // 1295
  { PseudoVFMIN_VF16_MF2_MASK, VFMIN_VF, 0x7, 0x0 }, // 1296
  { PseudoVFMIN_VF32_MF2, VFMIN_VF, 0x7, 0x0 }, // 1297
  { PseudoVFMIN_VF32_MF2_MASK, VFMIN_VF, 0x7, 0x0 }, // 1298
  { PseudoVFMIN_VV_M1, VFMIN_VV, 0x0, 0x0 }, // 1299
  { PseudoVFMIN_VV_M1_MASK, VFMIN_VV, 0x0, 0x0 }, // 1300
  { PseudoVFMIN_VV_M2, VFMIN_VV, 0x1, 0x0 }, // 1301
  { PseudoVFMIN_VV_M2_MASK, VFMIN_VV, 0x1, 0x0 }, // 1302
  { PseudoVFMIN_VV_M4, VFMIN_VV, 0x2, 0x0 }, // 1303
  { PseudoVFMIN_VV_M4_MASK, VFMIN_VV, 0x2, 0x0 }, // 1304
  { PseudoVFMIN_VV_M8, VFMIN_VV, 0x3, 0x0 }, // 1305
  { PseudoVFMIN_VV_M8_MASK, VFMIN_VV, 0x3, 0x0 }, // 1306
  { PseudoVFMIN_VV_MF4, VFMIN_VV, 0x6, 0x0 }, // 1307
  { PseudoVFMIN_VV_MF4_MASK, VFMIN_VV, 0x6, 0x0 }, // 1308
  { PseudoVFMIN_VV_MF2, VFMIN_VV, 0x7, 0x0 }, // 1309
  { PseudoVFMIN_VV_MF2_MASK, VFMIN_VV, 0x7, 0x0 }, // 1310
  { PseudoVFMSAC_VF16_M1, VFMSAC_VF, 0x0, 0x0 }, // 1311
  { PseudoVFMSAC_VF16_M1_MASK, VFMSAC_VF, 0x0, 0x0 }, // 1312
  { PseudoVFMSAC_VF32_M1, VFMSAC_VF, 0x0, 0x0 }, // 1313
  { PseudoVFMSAC_VF32_M1_MASK, VFMSAC_VF, 0x0, 0x0 }, // 1314
  { PseudoVFMSAC_VF64_M1, VFMSAC_VF, 0x0, 0x0 }, // 1315
  { PseudoVFMSAC_VF64_M1_MASK, VFMSAC_VF, 0x0, 0x0 }, // 1316
  { PseudoVFMSAC_VF16_M2, VFMSAC_VF, 0x1, 0x0 }, // 1317
  { PseudoVFMSAC_VF16_M2_MASK, VFMSAC_VF, 0x1, 0x0 }, // 1318
  { PseudoVFMSAC_VF32_M2, VFMSAC_VF, 0x1, 0x0 }, // 1319
  { PseudoVFMSAC_VF32_M2_MASK, VFMSAC_VF, 0x1, 0x0 }, // 1320
  { PseudoVFMSAC_VF64_M2, VFMSAC_VF, 0x1, 0x0 }, // 1321
  { PseudoVFMSAC_VF64_M2_MASK, VFMSAC_VF, 0x1, 0x0 }, // 1322
  { PseudoVFMSAC_VF16_M4, VFMSAC_VF, 0x2, 0x0 }, // 1323
  { PseudoVFMSAC_VF16_M4_MASK, VFMSAC_VF, 0x2, 0x0 }, // 1324
  { PseudoVFMSAC_VF32_M4, VFMSAC_VF, 0x2, 0x0 }, // 1325
  { PseudoVFMSAC_VF32_M4_MASK, VFMSAC_VF, 0x2, 0x0 }, // 1326
  { PseudoVFMSAC_VF64_M4, VFMSAC_VF, 0x2, 0x0 }, // 1327
  { PseudoVFMSAC_VF64_M4_MASK, VFMSAC_VF, 0x2, 0x0 }, // 1328
  { PseudoVFMSAC_VF16_M8, VFMSAC_VF, 0x3, 0x0 }, // 1329
  { PseudoVFMSAC_VF16_M8_MASK, VFMSAC_VF, 0x3, 0x0 }, // 1330
  { PseudoVFMSAC_VF32_M8, VFMSAC_VF, 0x3, 0x0 }, // 1331
  { PseudoVFMSAC_VF32_M8_MASK, VFMSAC_VF, 0x3, 0x0 }, // 1332
  { PseudoVFMSAC_VF64_M8, VFMSAC_VF, 0x3, 0x0 }, // 1333
  { PseudoVFMSAC_VF64_M8_MASK, VFMSAC_VF, 0x3, 0x0 }, // 1334
  { PseudoVFMSAC_VF16_MF4, VFMSAC_VF, 0x6, 0x0 }, // 1335
  { PseudoVFMSAC_VF16_MF4_MASK, VFMSAC_VF, 0x6, 0x0 }, // 1336
  { PseudoVFMSAC_VF16_MF2, VFMSAC_VF, 0x7, 0x0 }, // 1337
  { PseudoVFMSAC_VF16_MF2_MASK, VFMSAC_VF, 0x7, 0x0 }, // 1338
  { PseudoVFMSAC_VF32_MF2, VFMSAC_VF, 0x7, 0x0 }, // 1339
  { PseudoVFMSAC_VF32_MF2_MASK, VFMSAC_VF, 0x7, 0x0 }, // 1340
  { PseudoVFMSAC_VV_M1, VFMSAC_VV, 0x0, 0x0 }, // 1341
  { PseudoVFMSAC_VV_M1_MASK, VFMSAC_VV, 0x0, 0x0 }, // 1342
  { PseudoVFMSAC_VV_M2, VFMSAC_VV, 0x1, 0x0 }, // 1343
  { PseudoVFMSAC_VV_M2_MASK, VFMSAC_VV, 0x1, 0x0 }, // 1344
  { PseudoVFMSAC_VV_M4, VFMSAC_VV, 0x2, 0x0 }, // 1345
  { PseudoVFMSAC_VV_M4_MASK, VFMSAC_VV, 0x2, 0x0 }, // 1346
  { PseudoVFMSAC_VV_M8, VFMSAC_VV, 0x3, 0x0 }, // 1347
  { PseudoVFMSAC_VV_M8_MASK, VFMSAC_VV, 0x3, 0x0 }, // 1348
  { PseudoVFMSAC_VV_MF4, VFMSAC_VV, 0x6, 0x0 }, // 1349
  { PseudoVFMSAC_VV_MF4_MASK, VFMSAC_VV, 0x6, 0x0 }, // 1350
  { PseudoVFMSAC_VV_MF2, VFMSAC_VV, 0x7, 0x0 }, // 1351
  { PseudoVFMSAC_VV_MF2_MASK, VFMSAC_VV, 0x7, 0x0 }, // 1352
  { PseudoVFMSUB_VF16_M1, VFMSUB_VF, 0x0, 0x0 }, // 1353
  { PseudoVFMSUB_VF16_M1_MASK, VFMSUB_VF, 0x0, 0x0 }, // 1354
  { PseudoVFMSUB_VF32_M1, VFMSUB_VF, 0x0, 0x0 }, // 1355
  { PseudoVFMSUB_VF32_M1_MASK, VFMSUB_VF, 0x0, 0x0 }, // 1356
  { PseudoVFMSUB_VF64_M1, VFMSUB_VF, 0x0, 0x0 }, // 1357
  { PseudoVFMSUB_VF64_M1_MASK, VFMSUB_VF, 0x0, 0x0 }, // 1358
  { PseudoVFMSUB_VF16_M2, VFMSUB_VF, 0x1, 0x0 }, // 1359
  { PseudoVFMSUB_VF16_M2_MASK, VFMSUB_VF, 0x1, 0x0 }, // 1360
  { PseudoVFMSUB_VF32_M2, VFMSUB_VF, 0x1, 0x0 }, // 1361
  { PseudoVFMSUB_VF32_M2_MASK, VFMSUB_VF, 0x1, 0x0 }, // 1362
  { PseudoVFMSUB_VF64_M2, VFMSUB_VF, 0x1, 0x0 }, // 1363
  { PseudoVFMSUB_VF64_M2_MASK, VFMSUB_VF, 0x1, 0x0 }, // 1364
  { PseudoVFMSUB_VF16_M4, VFMSUB_VF, 0x2, 0x0 }, // 1365
  { PseudoVFMSUB_VF16_M4_MASK, VFMSUB_VF, 0x2, 0x0 }, // 1366
  { PseudoVFMSUB_VF32_M4, VFMSUB_VF, 0x2, 0x0 }, // 1367
  { PseudoVFMSUB_VF32_M4_MASK, VFMSUB_VF, 0x2, 0x0 }, // 1368
  { PseudoVFMSUB_VF64_M4, VFMSUB_VF, 0x2, 0x0 }, // 1369
  { PseudoVFMSUB_VF64_M4_MASK, VFMSUB_VF, 0x2, 0x0 }, // 1370
  { PseudoVFMSUB_VF16_M8, VFMSUB_VF, 0x3, 0x0 }, // 1371
  { PseudoVFMSUB_VF16_M8_MASK, VFMSUB_VF, 0x3, 0x0 }, // 1372
  { PseudoVFMSUB_VF32_M8, VFMSUB_VF, 0x3, 0x0 }, // 1373
  { PseudoVFMSUB_VF32_M8_MASK, VFMSUB_VF, 0x3, 0x0 }, // 1374
  { PseudoVFMSUB_VF64_M8, VFMSUB_VF, 0x3, 0x0 }, // 1375
  { PseudoVFMSUB_VF64_M8_MASK, VFMSUB_VF, 0x3, 0x0 }, // 1376
  { PseudoVFMSUB_VF16_MF4, VFMSUB_VF, 0x6, 0x0 }, // 1377
  { PseudoVFMSUB_VF16_MF4_MASK, VFMSUB_VF, 0x6, 0x0 }, // 1378
  { PseudoVFMSUB_VF16_MF2, VFMSUB_VF, 0x7, 0x0 }, // 1379
  { PseudoVFMSUB_VF16_MF2_MASK, VFMSUB_VF, 0x7, 0x0 }, // 1380
  { PseudoVFMSUB_VF32_MF2, VFMSUB_VF, 0x7, 0x0 }, // 1381
  { PseudoVFMSUB_VF32_MF2_MASK, VFMSUB_VF, 0x7, 0x0 }, // 1382
  { PseudoVFMSUB_VV_M1, VFMSUB_VV, 0x0, 0x0 }, // 1383
  { PseudoVFMSUB_VV_M1_MASK, VFMSUB_VV, 0x0, 0x0 }, // 1384
  { PseudoVFMSUB_VV_M2, VFMSUB_VV, 0x1, 0x0 }, // 1385
  { PseudoVFMSUB_VV_M2_MASK, VFMSUB_VV, 0x1, 0x0 }, // 1386
  { PseudoVFMSUB_VV_M4, VFMSUB_VV, 0x2, 0x0 }, // 1387
  { PseudoVFMSUB_VV_M4_MASK, VFMSUB_VV, 0x2, 0x0 }, // 1388
  { PseudoVFMSUB_VV_M8, VFMSUB_VV, 0x3, 0x0 }, // 1389
  { PseudoVFMSUB_VV_M8_MASK, VFMSUB_VV, 0x3, 0x0 }, // 1390
  { PseudoVFMSUB_VV_MF4, VFMSUB_VV, 0x6, 0x0 }, // 1391
  { PseudoVFMSUB_VV_MF4_MASK, VFMSUB_VV, 0x6, 0x0 }, // 1392
  { PseudoVFMSUB_VV_MF2, VFMSUB_VV, 0x7, 0x0 }, // 1393
  { PseudoVFMSUB_VV_MF2_MASK, VFMSUB_VV, 0x7, 0x0 }, // 1394
  { PseudoVFMUL_VF16_M1, VFMUL_VF, 0x0, 0x0 }, // 1395
  { PseudoVFMUL_VF16_M1_MASK, VFMUL_VF, 0x0, 0x0 }, // 1396
  { PseudoVFMUL_VF32_M1, VFMUL_VF, 0x0, 0x0 }, // 1397
  { PseudoVFMUL_VF32_M1_MASK, VFMUL_VF, 0x0, 0x0 }, // 1398
  { PseudoVFMUL_VF64_M1, VFMUL_VF, 0x0, 0x0 }, // 1399
  { PseudoVFMUL_VF64_M1_MASK, VFMUL_VF, 0x0, 0x0 }, // 1400
  { PseudoVFMUL_VF16_M2, VFMUL_VF, 0x1, 0x0 }, // 1401
  { PseudoVFMUL_VF16_M2_MASK, VFMUL_VF, 0x1, 0x0 }, // 1402
  { PseudoVFMUL_VF32_M2, VFMUL_VF, 0x1, 0x0 }, // 1403
  { PseudoVFMUL_VF32_M2_MASK, VFMUL_VF, 0x1, 0x0 }, // 1404
  { PseudoVFMUL_VF64_M2, VFMUL_VF, 0x1, 0x0 }, // 1405
  { PseudoVFMUL_VF64_M2_MASK, VFMUL_VF, 0x1, 0x0 }, // 1406
  { PseudoVFMUL_VF16_M4, VFMUL_VF, 0x2, 0x0 }, // 1407
  { PseudoVFMUL_VF16_M4_MASK, VFMUL_VF, 0x2, 0x0 }, // 1408
  { PseudoVFMUL_VF32_M4, VFMUL_VF, 0x2, 0x0 }, // 1409
  { PseudoVFMUL_VF32_M4_MASK, VFMUL_VF, 0x2, 0x0 }, // 1410
  { PseudoVFMUL_VF64_M4, VFMUL_VF, 0x2, 0x0 }, // 1411
  { PseudoVFMUL_VF64_M4_MASK, VFMUL_VF, 0x2, 0x0 }, // 1412
  { PseudoVFMUL_VF16_M8, VFMUL_VF, 0x3, 0x0 }, // 1413
  { PseudoVFMUL_VF16_M8_MASK, VFMUL_VF, 0x3, 0x0 }, // 1414
  { PseudoVFMUL_VF32_M8, VFMUL_VF, 0x3, 0x0 }, // 1415
  { PseudoVFMUL_VF32_M8_MASK, VFMUL_VF, 0x3, 0x0 }, // 1416
  { PseudoVFMUL_VF64_M8, VFMUL_VF, 0x3, 0x0 }, // 1417
  { PseudoVFMUL_VF64_M8_MASK, VFMUL_VF, 0x3, 0x0 }, // 1418
  { PseudoVFMUL_VF16_MF4, VFMUL_VF, 0x6, 0x0 }, // 1419
  { PseudoVFMUL_VF16_MF4_MASK, VFMUL_VF, 0x6, 0x0 }, // 1420
  { PseudoVFMUL_VF16_MF2, VFMUL_VF, 0x7, 0x0 }, // 1421
  { PseudoVFMUL_VF16_MF2_MASK, VFMUL_VF, 0x7, 0x0 }, // 1422
  { PseudoVFMUL_VF32_MF2, VFMUL_VF, 0x7, 0x0 }, // 1423
  { PseudoVFMUL_VF32_MF2_MASK, VFMUL_VF, 0x7, 0x0 }, // 1424
  { PseudoVFMUL_VV_M1, VFMUL_VV, 0x0, 0x0 }, // 1425
  { PseudoVFMUL_VV_M1_MASK, VFMUL_VV, 0x0, 0x0 }, // 1426
  { PseudoVFMUL_VV_M2, VFMUL_VV, 0x1, 0x0 }, // 1427
  { PseudoVFMUL_VV_M2_MASK, VFMUL_VV, 0x1, 0x0 }, // 1428
  { PseudoVFMUL_VV_M4, VFMUL_VV, 0x2, 0x0 }, // 1429
  { PseudoVFMUL_VV_M4_MASK, VFMUL_VV, 0x2, 0x0 }, // 1430
  { PseudoVFMUL_VV_M8, VFMUL_VV, 0x3, 0x0 }, // 1431
  { PseudoVFMUL_VV_M8_MASK, VFMUL_VV, 0x3, 0x0 }, // 1432
  { PseudoVFMUL_VV_MF4, VFMUL_VV, 0x6, 0x0 }, // 1433
  { PseudoVFMUL_VV_MF4_MASK, VFMUL_VV, 0x6, 0x0 }, // 1434
  { PseudoVFMUL_VV_MF2, VFMUL_VV, 0x7, 0x0 }, // 1435
  { PseudoVFMUL_VV_MF2_MASK, VFMUL_VV, 0x7, 0x0 }, // 1436
  { PseudoVFMV_F16_S_M1, VFMV_F_S, 0x0, 0x0 }, // 1437
  { PseudoVFMV_F32_S_M1, VFMV_F_S, 0x0, 0x0 }, // 1438
  { PseudoVFMV_F64_S_M1, VFMV_F_S, 0x0, 0x0 }, // 1439
  { PseudoVFMV_F16_S_M2, VFMV_F_S, 0x1, 0x0 }, // 1440
  { PseudoVFMV_F32_S_M2, VFMV_F_S, 0x1, 0x0 }, // 1441
  { PseudoVFMV_F64_S_M2, VFMV_F_S, 0x1, 0x0 }, // 1442
  { PseudoVFMV_F16_S_M4, VFMV_F_S, 0x2, 0x0 }, // 1443
  { PseudoVFMV_F32_S_M4, VFMV_F_S, 0x2, 0x0 }, // 1444
  { PseudoVFMV_F64_S_M4, VFMV_F_S, 0x2, 0x0 }, // 1445
  { PseudoVFMV_F16_S_M8, VFMV_F_S, 0x3, 0x0 }, // 1446
  { PseudoVFMV_F32_S_M8, VFMV_F_S, 0x3, 0x0 }, // 1447
  { PseudoVFMV_F64_S_M8, VFMV_F_S, 0x3, 0x0 }, // 1448
  { PseudoVFMV_F16_S_MF4, VFMV_F_S, 0x6, 0x0 }, // 1449
  { PseudoVFMV_F16_S_MF2, VFMV_F_S, 0x7, 0x0 }, // 1450
  { PseudoVFMV_F32_S_MF2, VFMV_F_S, 0x7, 0x0 }, // 1451
  { PseudoVFMV_S_F16_M1, VFMV_S_F, 0x0, 0x0 }, // 1452
  { PseudoVFMV_S_F32_M1, VFMV_S_F, 0x0, 0x0 }, // 1453
  { PseudoVFMV_S_F64_M1, VFMV_S_F, 0x0, 0x0 }, // 1454
  { PseudoVFMV_S_F16_M2, VFMV_S_F, 0x1, 0x0 }, // 1455
  { PseudoVFMV_S_F32_M2, VFMV_S_F, 0x1, 0x0 }, // 1456
  { PseudoVFMV_S_F64_M2, VFMV_S_F, 0x1, 0x0 }, // 1457
  { PseudoVFMV_S_F16_M4, VFMV_S_F, 0x2, 0x0 }, // 1458
  { PseudoVFMV_S_F32_M4, VFMV_S_F, 0x2, 0x0 }, // 1459
  { PseudoVFMV_S_F64_M4, VFMV_S_F, 0x2, 0x0 }, // 1460
  { PseudoVFMV_S_F16_M8, VFMV_S_F, 0x3, 0x0 }, // 1461
  { PseudoVFMV_S_F32_M8, VFMV_S_F, 0x3, 0x0 }, // 1462
  { PseudoVFMV_S_F64_M8, VFMV_S_F, 0x3, 0x0 }, // 1463
  { PseudoVFMV_S_F16_MF4, VFMV_S_F, 0x6, 0x0 }, // 1464
  { PseudoVFMV_S_F16_MF2, VFMV_S_F, 0x7, 0x0 }, // 1465
  { PseudoVFMV_S_F32_MF2, VFMV_S_F, 0x7, 0x0 }, // 1466
  { PseudoVFMV_V_F16_M1, VFMV_V_F, 0x0, 0x0 }, // 1467
  { PseudoVFMV_V_F32_M1, VFMV_V_F, 0x0, 0x0 }, // 1468
  { PseudoVFMV_V_F64_M1, VFMV_V_F, 0x0, 0x0 }, // 1469
  { PseudoVFMV_V_F16_M2, VFMV_V_F, 0x1, 0x0 }, // 1470
  { PseudoVFMV_V_F32_M2, VFMV_V_F, 0x1, 0x0 }, // 1471
  { PseudoVFMV_V_F64_M2, VFMV_V_F, 0x1, 0x0 }, // 1472
  { PseudoVFMV_V_F16_M4, VFMV_V_F, 0x2, 0x0 }, // 1473
  { PseudoVFMV_V_F32_M4, VFMV_V_F, 0x2, 0x0 }, // 1474
  { PseudoVFMV_V_F64_M4, VFMV_V_F, 0x2, 0x0 }, // 1475
  { PseudoVFMV_V_F16_M8, VFMV_V_F, 0x3, 0x0 }, // 1476
  { PseudoVFMV_V_F32_M8, VFMV_V_F, 0x3, 0x0 }, // 1477
  { PseudoVFMV_V_F64_M8, VFMV_V_F, 0x3, 0x0 }, // 1478
  { PseudoVFMV_V_F16_MF4, VFMV_V_F, 0x6, 0x0 }, // 1479
  { PseudoVFMV_V_F16_MF2, VFMV_V_F, 0x7, 0x0 }, // 1480
  { PseudoVFMV_V_F32_MF2, VFMV_V_F, 0x7, 0x0 }, // 1481
  { PseudoVFNCVT_F_F_W_M1, VFNCVT_F_F_W, 0x0, 0x0 }, // 1482
  { PseudoVFNCVT_F_F_W_M1_MASK, VFNCVT_F_F_W, 0x0, 0x0 }, // 1483
  { PseudoVFNCVT_F_F_W_M2, VFNCVT_F_F_W, 0x1, 0x0 }, // 1484
  { PseudoVFNCVT_F_F_W_M2_MASK, VFNCVT_F_F_W, 0x1, 0x0 }, // 1485
  { PseudoVFNCVT_F_F_W_M4, VFNCVT_F_F_W, 0x2, 0x0 }, // 1486
  { PseudoVFNCVT_F_F_W_M4_MASK, VFNCVT_F_F_W, 0x2, 0x0 }, // 1487
  { PseudoVFNCVT_F_F_W_MF4, VFNCVT_F_F_W, 0x6, 0x0 }, // 1488
  { PseudoVFNCVT_F_F_W_MF4_MASK, VFNCVT_F_F_W, 0x6, 0x0 }, // 1489
  { PseudoVFNCVT_F_F_W_MF2, VFNCVT_F_F_W, 0x7, 0x0 }, // 1490
  { PseudoVFNCVT_F_F_W_MF2_MASK, VFNCVT_F_F_W, 0x7, 0x0 }, // 1491
  { PseudoVFNCVT_F_XU_W_M1, VFNCVT_F_XU_W, 0x0, 0x0 }, // 1492
  { PseudoVFNCVT_F_XU_W_M1_MASK, VFNCVT_F_XU_W, 0x0, 0x0 }, // 1493
  { PseudoVFNCVT_F_XU_W_M2, VFNCVT_F_XU_W, 0x1, 0x0 }, // 1494
  { PseudoVFNCVT_F_XU_W_M2_MASK, VFNCVT_F_XU_W, 0x1, 0x0 }, // 1495
  { PseudoVFNCVT_F_XU_W_M4, VFNCVT_F_XU_W, 0x2, 0x0 }, // 1496
  { PseudoVFNCVT_F_XU_W_M4_MASK, VFNCVT_F_XU_W, 0x2, 0x0 }, // 1497
  { PseudoVFNCVT_F_XU_W_MF4, VFNCVT_F_XU_W, 0x6, 0x0 }, // 1498
  { PseudoVFNCVT_F_XU_W_MF4_MASK, VFNCVT_F_XU_W, 0x6, 0x0 }, // 1499
  { PseudoVFNCVT_F_XU_W_MF2, VFNCVT_F_XU_W, 0x7, 0x0 }, // 1500
  { PseudoVFNCVT_F_XU_W_MF2_MASK, VFNCVT_F_XU_W, 0x7, 0x0 }, // 1501
  { PseudoVFNCVT_F_X_W_M1, VFNCVT_F_X_W, 0x0, 0x0 }, // 1502
  { PseudoVFNCVT_F_X_W_M1_MASK, VFNCVT_F_X_W, 0x0, 0x0 }, // 1503
  { PseudoVFNCVT_F_X_W_M2, VFNCVT_F_X_W, 0x1, 0x0 }, // 1504
  { PseudoVFNCVT_F_X_W_M2_MASK, VFNCVT_F_X_W, 0x1, 0x0 }, // 1505
  { PseudoVFNCVT_F_X_W_M4, VFNCVT_F_X_W, 0x2, 0x0 }, // 1506
  { PseudoVFNCVT_F_X_W_M4_MASK, VFNCVT_F_X_W, 0x2, 0x0 }, // 1507
  { PseudoVFNCVT_F_X_W_MF4, VFNCVT_F_X_W, 0x6, 0x0 }, // 1508
  { PseudoVFNCVT_F_X_W_MF4_MASK, VFNCVT_F_X_W, 0x6, 0x0 }, // 1509
  { PseudoVFNCVT_F_X_W_MF2, VFNCVT_F_X_W, 0x7, 0x0 }, // 1510
  { PseudoVFNCVT_F_X_W_MF2_MASK, VFNCVT_F_X_W, 0x7, 0x0 }, // 1511
  { PseudoVFNCVT_ROD_F_F_W_M1, VFNCVT_ROD_F_F_W, 0x0, 0x0 }, // 1512
  { PseudoVFNCVT_ROD_F_F_W_M1_MASK, VFNCVT_ROD_F_F_W, 0x0, 0x0 }, // 1513
  { PseudoVFNCVT_ROD_F_F_W_M2, VFNCVT_ROD_F_F_W, 0x1, 0x0 }, // 1514
  { PseudoVFNCVT_ROD_F_F_W_M2_MASK, VFNCVT_ROD_F_F_W, 0x1, 0x0 }, // 1515
  { PseudoVFNCVT_ROD_F_F_W_M4, VFNCVT_ROD_F_F_W, 0x2, 0x0 }, // 1516
  { PseudoVFNCVT_ROD_F_F_W_M4_MASK, VFNCVT_ROD_F_F_W, 0x2, 0x0 }, // 1517
  { PseudoVFNCVT_ROD_F_F_W_MF4, VFNCVT_ROD_F_F_W, 0x6, 0x0 }, // 1518
  { PseudoVFNCVT_ROD_F_F_W_MF4_MASK, VFNCVT_ROD_F_F_W, 0x6, 0x0 }, // 1519
  { PseudoVFNCVT_ROD_F_F_W_MF2, VFNCVT_ROD_F_F_W, 0x7, 0x0 }, // 1520
  { PseudoVFNCVT_ROD_F_F_W_MF2_MASK, VFNCVT_ROD_F_F_W, 0x7, 0x0 }, // 1521
  { PseudoVFNCVT_RTZ_XU_F_W_M1, VFNCVT_RTZ_XU_F_W, 0x0, 0x0 }, // 1522
  { PseudoVFNCVT_RTZ_XU_F_W_M1_MASK, VFNCVT_RTZ_XU_F_W, 0x0, 0x0 }, // 1523
  { PseudoVFNCVT_RTZ_XU_F_W_M2, VFNCVT_RTZ_XU_F_W, 0x1, 0x0 }, // 1524
  { PseudoVFNCVT_RTZ_XU_F_W_M2_MASK, VFNCVT_RTZ_XU_F_W, 0x1, 0x0 }, // 1525
  { PseudoVFNCVT_RTZ_XU_F_W_M4, VFNCVT_RTZ_XU_F_W, 0x2, 0x0 }, // 1526
  { PseudoVFNCVT_RTZ_XU_F_W_M4_MASK, VFNCVT_RTZ_XU_F_W, 0x2, 0x0 }, // 1527
  { PseudoVFNCVT_RTZ_XU_F_W_MF8, VFNCVT_RTZ_XU_F_W, 0x5, 0x0 }, // 1528
  { PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK, VFNCVT_RTZ_XU_F_W, 0x5, 0x0 }, // 1529
  { PseudoVFNCVT_RTZ_XU_F_W_MF4, VFNCVT_RTZ_XU_F_W, 0x6, 0x0 }, // 1530
  { PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK, VFNCVT_RTZ_XU_F_W, 0x6, 0x0 }, // 1531
  { PseudoVFNCVT_RTZ_XU_F_W_MF2, VFNCVT_RTZ_XU_F_W, 0x7, 0x0 }, // 1532
  { PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK, VFNCVT_RTZ_XU_F_W, 0x7, 0x0 }, // 1533
  { PseudoVFNCVT_RTZ_X_F_W_M1, VFNCVT_RTZ_X_F_W, 0x0, 0x0 }, // 1534
  { PseudoVFNCVT_RTZ_X_F_W_M1_MASK, VFNCVT_RTZ_X_F_W, 0x0, 0x0 }, // 1535
  { PseudoVFNCVT_RTZ_X_F_W_M2, VFNCVT_RTZ_X_F_W, 0x1, 0x0 }, // 1536
  { PseudoVFNCVT_RTZ_X_F_W_M2_MASK, VFNCVT_RTZ_X_F_W, 0x1, 0x0 }, // 1537
  { PseudoVFNCVT_RTZ_X_F_W_M4, VFNCVT_RTZ_X_F_W, 0x2, 0x0 }, // 1538
  { PseudoVFNCVT_RTZ_X_F_W_M4_MASK, VFNCVT_RTZ_X_F_W, 0x2, 0x0 }, // 1539
  { PseudoVFNCVT_RTZ_X_F_W_MF8, VFNCVT_RTZ_X_F_W, 0x5, 0x0 }, // 1540
  { PseudoVFNCVT_RTZ_X_F_W_MF8_MASK, VFNCVT_RTZ_X_F_W, 0x5, 0x0 }, // 1541
  { PseudoVFNCVT_RTZ_X_F_W_MF4, VFNCVT_RTZ_X_F_W, 0x6, 0x0 }, // 1542
  { PseudoVFNCVT_RTZ_X_F_W_MF4_MASK, VFNCVT_RTZ_X_F_W, 0x6, 0x0 }, // 1543
  { PseudoVFNCVT_RTZ_X_F_W_MF2, VFNCVT_RTZ_X_F_W, 0x7, 0x0 }, // 1544
  { PseudoVFNCVT_RTZ_X_F_W_MF2_MASK, VFNCVT_RTZ_X_F_W, 0x7, 0x0 }, // 1545
  { PseudoVFNCVT_XU_F_W_M1, VFNCVT_XU_F_W, 0x0, 0x0 }, // 1546
  { PseudoVFNCVT_XU_F_W_M1_MASK, VFNCVT_XU_F_W, 0x0, 0x0 }, // 1547
  { PseudoVFNCVT_XU_F_W_M2, VFNCVT_XU_F_W, 0x1, 0x0 }, // 1548
  { PseudoVFNCVT_XU_F_W_M2_MASK, VFNCVT_XU_F_W, 0x1, 0x0 }, // 1549
  { PseudoVFNCVT_XU_F_W_M4, VFNCVT_XU_F_W, 0x2, 0x0 }, // 1550
  { PseudoVFNCVT_XU_F_W_M4_MASK, VFNCVT_XU_F_W, 0x2, 0x0 }, // 1551
  { PseudoVFNCVT_XU_F_W_MF8, VFNCVT_XU_F_W, 0x5, 0x0 }, // 1552
  { PseudoVFNCVT_XU_F_W_MF8_MASK, VFNCVT_XU_F_W, 0x5, 0x0 }, // 1553
  { PseudoVFNCVT_XU_F_W_MF4, VFNCVT_XU_F_W, 0x6, 0x0 }, // 1554
  { PseudoVFNCVT_XU_F_W_MF4_MASK, VFNCVT_XU_F_W, 0x6, 0x0 }, // 1555
  { PseudoVFNCVT_XU_F_W_MF2, VFNCVT_XU_F_W, 0x7, 0x0 }, // 1556
  { PseudoVFNCVT_XU_F_W_MF2_MASK, VFNCVT_XU_F_W, 0x7, 0x0 }, // 1557
  { PseudoVFNCVT_X_F_W_M1, VFNCVT_X_F_W, 0x0, 0x0 }, // 1558
  { PseudoVFNCVT_X_F_W_M1_MASK, VFNCVT_X_F_W, 0x0, 0x0 }, // 1559
  { PseudoVFNCVT_X_F_W_M2, VFNCVT_X_F_W, 0x1, 0x0 }, // 1560
  { PseudoVFNCVT_X_F_W_M2_MASK, VFNCVT_X_F_W, 0x1, 0x0 }, // 1561
  { PseudoVFNCVT_X_F_W_M4, VFNCVT_X_F_W, 0x2, 0x0 }, // 1562
  { PseudoVFNCVT_X_F_W_M4_MASK, VFNCVT_X_F_W, 0x2, 0x0 }, // 1563
  { PseudoVFNCVT_X_F_W_MF8, VFNCVT_X_F_W, 0x5, 0x0 }, // 1564
  { PseudoVFNCVT_X_F_W_MF8_MASK, VFNCVT_X_F_W, 0x5, 0x0 }, // 1565
  { PseudoVFNCVT_X_F_W_MF4, VFNCVT_X_F_W, 0x6, 0x0 }, // 1566
  { PseudoVFNCVT_X_F_W_MF4_MASK, VFNCVT_X_F_W, 0x6, 0x0 }, // 1567
  { PseudoVFNCVT_X_F_W_MF2, VFNCVT_X_F_W, 0x7, 0x0 }, // 1568
  { PseudoVFNCVT_X_F_W_MF2_MASK, VFNCVT_X_F_W, 0x7, 0x0 }, // 1569
  { PseudoVFNMACC_VF16_M1, VFNMACC_VF, 0x0, 0x0 }, // 1570
  { PseudoVFNMACC_VF16_M1_MASK, VFNMACC_VF, 0x0, 0x0 }, // 1571
  { PseudoVFNMACC_VF32_M1, VFNMACC_VF, 0x0, 0x0 }, // 1572
  { PseudoVFNMACC_VF32_M1_MASK, VFNMACC_VF, 0x0, 0x0 }, // 1573
  { PseudoVFNMACC_VF64_M1, VFNMACC_VF, 0x0, 0x0 }, // 1574
  { PseudoVFNMACC_VF64_M1_MASK, VFNMACC_VF, 0x0, 0x0 }, // 1575
  { PseudoVFNMACC_VF16_M2, VFNMACC_VF, 0x1, 0x0 }, // 1576
  { PseudoVFNMACC_VF16_M2_MASK, VFNMACC_VF, 0x1, 0x0 }, // 1577
  { PseudoVFNMACC_VF32_M2, VFNMACC_VF, 0x1, 0x0 }, // 1578
  { PseudoVFNMACC_VF32_M2_MASK, VFNMACC_VF, 0x1, 0x0 }, // 1579
  { PseudoVFNMACC_VF64_M2, VFNMACC_VF, 0x1, 0x0 }, // 1580
  { PseudoVFNMACC_VF64_M2_MASK, VFNMACC_VF, 0x1, 0x0 }, // 1581
  { PseudoVFNMACC_VF16_M4, VFNMACC_VF, 0x2, 0x0 }, // 1582
  { PseudoVFNMACC_VF16_M4_MASK, VFNMACC_VF, 0x2, 0x0 }, // 1583
  { PseudoVFNMACC_VF32_M4, VFNMACC_VF, 0x2, 0x0 }, // 1584
  { PseudoVFNMACC_VF32_M4_MASK, VFNMACC_VF, 0x2, 0x0 }, // 1585
  { PseudoVFNMACC_VF64_M4, VFNMACC_VF, 0x2, 0x0 }, // 1586
  { PseudoVFNMACC_VF64_M4_MASK, VFNMACC_VF, 0x2, 0x0 }, // 1587
  { PseudoVFNMACC_VF16_M8, VFNMACC_VF, 0x3, 0x0 }, // 1588
  { PseudoVFNMACC_VF16_M8_MASK, VFNMACC_VF, 0x3, 0x0 }, // 1589
  { PseudoVFNMACC_VF32_M8, VFNMACC_VF, 0x3, 0x0 }, // 1590
  { PseudoVFNMACC_VF32_M8_MASK, VFNMACC_VF, 0x3, 0x0 }, // 1591
  { PseudoVFNMACC_VF64_M8, VFNMACC_VF, 0x3, 0x0 }, // 1592
  { PseudoVFNMACC_VF64_M8_MASK, VFNMACC_VF, 0x3, 0x0 }, // 1593
  { PseudoVFNMACC_VF16_MF4, VFNMACC_VF, 0x6, 0x0 }, // 1594
  { PseudoVFNMACC_VF16_MF4_MASK, VFNMACC_VF, 0x6, 0x0 }, // 1595
  { PseudoVFNMACC_VF16_MF2, VFNMACC_VF, 0x7, 0x0 }, // 1596
  { PseudoVFNMACC_VF16_MF2_MASK, VFNMACC_VF, 0x7, 0x0 }, // 1597
  { PseudoVFNMACC_VF32_MF2, VFNMACC_VF, 0x7, 0x0 }, // 1598
  { PseudoVFNMACC_VF32_MF2_MASK, VFNMACC_VF, 0x7, 0x0 }, // 1599
  { PseudoVFNMACC_VV_M1, VFNMACC_VV, 0x0, 0x0 }, // 1600
  { PseudoVFNMACC_VV_M1_MASK, VFNMACC_VV, 0x0, 0x0 }, // 1601
  { PseudoVFNMACC_VV_M2, VFNMACC_VV, 0x1, 0x0 }, // 1602
  { PseudoVFNMACC_VV_M2_MASK, VFNMACC_VV, 0x1, 0x0 }, // 1603
  { PseudoVFNMACC_VV_M4, VFNMACC_VV, 0x2, 0x0 }, // 1604
  { PseudoVFNMACC_VV_M4_MASK, VFNMACC_VV, 0x2, 0x0 }, // 1605
  { PseudoVFNMACC_VV_M8, VFNMACC_VV, 0x3, 0x0 }, // 1606
  { PseudoVFNMACC_VV_M8_MASK, VFNMACC_VV, 0x3, 0x0 }, // 1607
  { PseudoVFNMACC_VV_MF4, VFNMACC_VV, 0x6, 0x0 }, // 1608
  { PseudoVFNMACC_VV_MF4_MASK, VFNMACC_VV, 0x6, 0x0 }, // 1609
  { PseudoVFNMACC_VV_MF2, VFNMACC_VV, 0x7, 0x0 }, // 1610
  { PseudoVFNMACC_VV_MF2_MASK, VFNMACC_VV, 0x7, 0x0 }, // 1611
  { PseudoVFNMADD_VF16_M1, VFNMADD_VF, 0x0, 0x0 }, // 1612
  { PseudoVFNMADD_VF16_M1_MASK, VFNMADD_VF, 0x0, 0x0 }, // 1613
  { PseudoVFNMADD_VF32_M1, VFNMADD_VF, 0x0, 0x0 }, // 1614
  { PseudoVFNMADD_VF32_M1_MASK, VFNMADD_VF, 0x0, 0x0 }, // 1615
  { PseudoVFNMADD_VF64_M1, VFNMADD_VF, 0x0, 0x0 }, // 1616
  { PseudoVFNMADD_VF64_M1_MASK, VFNMADD_VF, 0x0, 0x0 }, // 1617
  { PseudoVFNMADD_VF16_M2, VFNMADD_VF, 0x1, 0x0 }, // 1618
  { PseudoVFNMADD_VF16_M2_MASK, VFNMADD_VF, 0x1, 0x0 }, // 1619
  { PseudoVFNMADD_VF32_M2, VFNMADD_VF, 0x1, 0x0 }, // 1620
  { PseudoVFNMADD_VF32_M2_MASK, VFNMADD_VF, 0x1, 0x0 }, // 1621
  { PseudoVFNMADD_VF64_M2, VFNMADD_VF, 0x1, 0x0 }, // 1622
  { PseudoVFNMADD_VF64_M2_MASK, VFNMADD_VF, 0x1, 0x0 }, // 1623
  { PseudoVFNMADD_VF16_M4, VFNMADD_VF, 0x2, 0x0 }, // 1624
  { PseudoVFNMADD_VF16_M4_MASK, VFNMADD_VF, 0x2, 0x0 }, // 1625
  { PseudoVFNMADD_VF32_M4, VFNMADD_VF, 0x2, 0x0 }, // 1626
  { PseudoVFNMADD_VF32_M4_MASK, VFNMADD_VF, 0x2, 0x0 }, // 1627
  { PseudoVFNMADD_VF64_M4, VFNMADD_VF, 0x2, 0x0 }, // 1628
  { PseudoVFNMADD_VF64_M4_MASK, VFNMADD_VF, 0x2, 0x0 }, // 1629
  { PseudoVFNMADD_VF16_M8, VFNMADD_VF, 0x3, 0x0 }, // 1630
  { PseudoVFNMADD_VF16_M8_MASK, VFNMADD_VF, 0x3, 0x0 }, // 1631
  { PseudoVFNMADD_VF32_M8, VFNMADD_VF, 0x3, 0x0 }, // 1632
  { PseudoVFNMADD_VF32_M8_MASK, VFNMADD_VF, 0x3, 0x0 }, // 1633
  { PseudoVFNMADD_VF64_M8, VFNMADD_VF, 0x3, 0x0 }, // 1634
  { PseudoVFNMADD_VF64_M8_MASK, VFNMADD_VF, 0x3, 0x0 }, // 1635
  { PseudoVFNMADD_VF16_MF4, VFNMADD_VF, 0x6, 0x0 }, // 1636
  { PseudoVFNMADD_VF16_MF4_MASK, VFNMADD_VF, 0x6, 0x0 }, // 1637
  { PseudoVFNMADD_VF16_MF2, VFNMADD_VF, 0x7, 0x0 }, // 1638
  { PseudoVFNMADD_VF16_MF2_MASK, VFNMADD_VF, 0x7, 0x0 }, // 1639
  { PseudoVFNMADD_VF32_MF2, VFNMADD_VF, 0x7, 0x0 }, // 1640
  { PseudoVFNMADD_VF32_MF2_MASK, VFNMADD_VF, 0x7, 0x0 }, // 1641
  { PseudoVFNMADD_VV_M1, VFNMADD_VV, 0x0, 0x0 }, // 1642
  { PseudoVFNMADD_VV_M1_MASK, VFNMADD_VV, 0x0, 0x0 }, // 1643
  { PseudoVFNMADD_VV_M2, VFNMADD_VV, 0x1, 0x0 }, // 1644
  { PseudoVFNMADD_VV_M2_MASK, VFNMADD_VV, 0x1, 0x0 }, // 1645
  { PseudoVFNMADD_VV_M4, VFNMADD_VV, 0x2, 0x0 }, // 1646
  { PseudoVFNMADD_VV_M4_MASK, VFNMADD_VV, 0x2, 0x0 }, // 1647
  { PseudoVFNMADD_VV_M8, VFNMADD_VV, 0x3, 0x0 }, // 1648
  { PseudoVFNMADD_VV_M8_MASK, VFNMADD_VV, 0x3, 0x0 }, // 1649
  { PseudoVFNMADD_VV_MF4, VFNMADD_VV, 0x6, 0x0 }, // 1650
  { PseudoVFNMADD_VV_MF4_MASK, VFNMADD_VV, 0x6, 0x0 }, // 1651
  { PseudoVFNMADD_VV_MF2, VFNMADD_VV, 0x7, 0x0 }, // 1652
  { PseudoVFNMADD_VV_MF2_MASK, VFNMADD_VV, 0x7, 0x0 }, // 1653
  { PseudoVFNMSAC_VF16_M1, VFNMSAC_VF, 0x0, 0x0 }, // 1654
  { PseudoVFNMSAC_VF16_M1_MASK, VFNMSAC_VF, 0x0, 0x0 }, // 1655
  { PseudoVFNMSAC_VF32_M1, VFNMSAC_VF, 0x0, 0x0 }, // 1656
  { PseudoVFNMSAC_VF32_M1_MASK, VFNMSAC_VF, 0x0, 0x0 }, // 1657
  { PseudoVFNMSAC_VF64_M1, VFNMSAC_VF, 0x0, 0x0 }, // 1658
  { PseudoVFNMSAC_VF64_M1_MASK, VFNMSAC_VF, 0x0, 0x0 }, // 1659
  { PseudoVFNMSAC_VF16_M2, VFNMSAC_VF, 0x1, 0x0 }, // 1660
  { PseudoVFNMSAC_VF16_M2_MASK, VFNMSAC_VF, 0x1, 0x0 }, // 1661
  { PseudoVFNMSAC_VF32_M2, VFNMSAC_VF, 0x1, 0x0 }, // 1662
  { PseudoVFNMSAC_VF32_M2_MASK, VFNMSAC_VF, 0x1, 0x0 }, // 1663
  { PseudoVFNMSAC_VF64_M2, VFNMSAC_VF, 0x1, 0x0 }, // 1664
  { PseudoVFNMSAC_VF64_M2_MASK, VFNMSAC_VF, 0x1, 0x0 }, // 1665
  { PseudoVFNMSAC_VF16_M4, VFNMSAC_VF, 0x2, 0x0 }, // 1666
  { PseudoVFNMSAC_VF16_M4_MASK, VFNMSAC_VF, 0x2, 0x0 }, // 1667
  { PseudoVFNMSAC_VF32_M4, VFNMSAC_VF, 0x2, 0x0 }, // 1668
  { PseudoVFNMSAC_VF32_M4_MASK, VFNMSAC_VF, 0x2, 0x0 }, // 1669
  { PseudoVFNMSAC_VF64_M4, VFNMSAC_VF, 0x2, 0x0 }, // 1670
  { PseudoVFNMSAC_VF64_M4_MASK, VFNMSAC_VF, 0x2, 0x0 }, // 1671
  { PseudoVFNMSAC_VF16_M8, VFNMSAC_VF, 0x3, 0x0 }, // 1672
  { PseudoVFNMSAC_VF16_M8_MASK, VFNMSAC_VF, 0x3, 0x0 }, // 1673
  { PseudoVFNMSAC_VF32_M8, VFNMSAC_VF, 0x3, 0x0 }, // 1674
  { PseudoVFNMSAC_VF32_M8_MASK, VFNMSAC_VF, 0x3, 0x0 }, // 1675
  { PseudoVFNMSAC_VF64_M8, VFNMSAC_VF, 0x3, 0x0 }, // 1676
  { PseudoVFNMSAC_VF64_M8_MASK, VFNMSAC_VF, 0x3, 0x0 }, // 1677
  { PseudoVFNMSAC_VF16_MF4, VFNMSAC_VF, 0x6, 0x0 }, // 1678
  { PseudoVFNMSAC_VF16_MF4_MASK, VFNMSAC_VF, 0x6, 0x0 }, // 1679
  { PseudoVFNMSAC_VF16_MF2, VFNMSAC_VF, 0x7, 0x0 }, // 1680
  { PseudoVFNMSAC_VF16_MF2_MASK, VFNMSAC_VF, 0x7, 0x0 }, // 1681
  { PseudoVFNMSAC_VF32_MF2, VFNMSAC_VF, 0x7, 0x0 }, // 1682
  { PseudoVFNMSAC_VF32_MF2_MASK, VFNMSAC_VF, 0x7, 0x0 }, // 1683
  { PseudoVFNMSAC_VV_M1, VFNMSAC_VV, 0x0, 0x0 }, // 1684
  { PseudoVFNMSAC_VV_M1_MASK, VFNMSAC_VV, 0x0, 0x0 }, // 1685
  { PseudoVFNMSAC_VV_M2, VFNMSAC_VV, 0x1, 0x0 }, // 1686
  { PseudoVFNMSAC_VV_M2_MASK, VFNMSAC_VV, 0x1, 0x0 }, // 1687
  { PseudoVFNMSAC_VV_M4, VFNMSAC_VV, 0x2, 0x0 }, // 1688
  { PseudoVFNMSAC_VV_M4_MASK, VFNMSAC_VV, 0x2, 0x0 }, // 1689
  { PseudoVFNMSAC_VV_M8, VFNMSAC_VV, 0x3, 0x0 }, // 1690
  { PseudoVFNMSAC_VV_M8_MASK, VFNMSAC_VV, 0x3, 0x0 }, // 1691
  { PseudoVFNMSAC_VV_MF4, VFNMSAC_VV, 0x6, 0x0 }, // 1692
  { PseudoVFNMSAC_VV_MF4_MASK, VFNMSAC_VV, 0x6, 0x0 }, // 1693
  { PseudoVFNMSAC_VV_MF2, VFNMSAC_VV, 0x7, 0x0 }, // 1694
  { PseudoVFNMSAC_VV_MF2_MASK, VFNMSAC_VV, 0x7, 0x0 }, // 1695
  { PseudoVFNMSUB_VF16_M1, VFNMSUB_VF, 0x0, 0x0 }, // 1696
  { PseudoVFNMSUB_VF16_M1_MASK, VFNMSUB_VF, 0x0, 0x0 }, // 1697
  { PseudoVFNMSUB_VF32_M1, VFNMSUB_VF, 0x0, 0x0 }, // 1698
  { PseudoVFNMSUB_VF32_M1_MASK, VFNMSUB_VF, 0x0, 0x0 }, // 1699
  { PseudoVFNMSUB_VF64_M1, VFNMSUB_VF, 0x0, 0x0 }, // 1700
  { PseudoVFNMSUB_VF64_M1_MASK, VFNMSUB_VF, 0x0, 0x0 }, // 1701
  { PseudoVFNMSUB_VF16_M2, VFNMSUB_VF, 0x1, 0x0 }, // 1702
  { PseudoVFNMSUB_VF16_M2_MASK, VFNMSUB_VF, 0x1, 0x0 }, // 1703
  { PseudoVFNMSUB_VF32_M2, VFNMSUB_VF, 0x1, 0x0 }, // 1704
  { PseudoVFNMSUB_VF32_M2_MASK, VFNMSUB_VF, 0x1, 0x0 }, // 1705
  { PseudoVFNMSUB_VF64_M2, VFNMSUB_VF, 0x1, 0x0 }, // 1706
  { PseudoVFNMSUB_VF64_M2_MASK, VFNMSUB_VF, 0x1, 0x0 }, // 1707
  { PseudoVFNMSUB_VF16_M4, VFNMSUB_VF, 0x2, 0x0 }, // 1708
  { PseudoVFNMSUB_VF16_M4_MASK, VFNMSUB_VF, 0x2, 0x0 }, // 1709
  { PseudoVFNMSUB_VF32_M4, VFNMSUB_VF, 0x2, 0x0 }, // 1710
  { PseudoVFNMSUB_VF32_M4_MASK, VFNMSUB_VF, 0x2, 0x0 }, // 1711
  { PseudoVFNMSUB_VF64_M4, VFNMSUB_VF, 0x2, 0x0 }, // 1712
  { PseudoVFNMSUB_VF64_M4_MASK, VFNMSUB_VF, 0x2, 0x0 }, // 1713
  { PseudoVFNMSUB_VF16_M8, VFNMSUB_VF, 0x3, 0x0 }, // 1714
  { PseudoVFNMSUB_VF16_M8_MASK, VFNMSUB_VF, 0x3, 0x0 }, // 1715
  { PseudoVFNMSUB_VF32_M8, VFNMSUB_VF, 0x3, 0x0 }, // 1716
  { PseudoVFNMSUB_VF32_M8_MASK, VFNMSUB_VF, 0x3, 0x0 }, // 1717
  { PseudoVFNMSUB_VF64_M8, VFNMSUB_VF, 0x3, 0x0 }, // 1718
  { PseudoVFNMSUB_VF64_M8_MASK, VFNMSUB_VF, 0x3, 0x0 }, // 1719
  { PseudoVFNMSUB_VF16_MF4, VFNMSUB_VF, 0x6, 0x0 }, // 1720
  { PseudoVFNMSUB_VF16_MF4_MASK, VFNMSUB_VF, 0x6, 0x0 }, // 1721
  { PseudoVFNMSUB_VF16_MF2, VFNMSUB_VF, 0x7, 0x0 }, // 1722
  { PseudoVFNMSUB_VF16_MF2_MASK, VFNMSUB_VF, 0x7, 0x0 }, // 1723
  { PseudoVFNMSUB_VF32_MF2, VFNMSUB_VF, 0x7, 0x0 }, // 1724
  { PseudoVFNMSUB_VF32_MF2_MASK, VFNMSUB_VF, 0x7, 0x0 }, // 1725
  { PseudoVFNMSUB_VV_M1, VFNMSUB_VV, 0x0, 0x0 }, // 1726
  { PseudoVFNMSUB_VV_M1_MASK, VFNMSUB_VV, 0x0, 0x0 }, // 1727
  { PseudoVFNMSUB_VV_M2, VFNMSUB_VV, 0x1, 0x0 }, // 1728
  { PseudoVFNMSUB_VV_M2_MASK, VFNMSUB_VV, 0x1, 0x0 }, // 1729
  { PseudoVFNMSUB_VV_M4, VFNMSUB_VV, 0x2, 0x0 }, // 1730
  { PseudoVFNMSUB_VV_M4_MASK, VFNMSUB_VV, 0x2, 0x0 }, // 1731
  { PseudoVFNMSUB_VV_M8, VFNMSUB_VV, 0x3, 0x0 }, // 1732
  { PseudoVFNMSUB_VV_M8_MASK, VFNMSUB_VV, 0x3, 0x0 }, // 1733
  { PseudoVFNMSUB_VV_MF4, VFNMSUB_VV, 0x6, 0x0 }, // 1734
  { PseudoVFNMSUB_VV_MF4_MASK, VFNMSUB_VV, 0x6, 0x0 }, // 1735
  { PseudoVFNMSUB_VV_MF2, VFNMSUB_VV, 0x7, 0x0 }, // 1736
  { PseudoVFNMSUB_VV_MF2_MASK, VFNMSUB_VV, 0x7, 0x0 }, // 1737
  { PseudoVFRDIV_VF16_M1_E16, VFRDIV_VF, 0x0, 0x10 }, // 1738
  { PseudoVFRDIV_VF16_M1_E16_MASK, VFRDIV_VF, 0x0, 0x10 }, // 1739
  { PseudoVFRDIV_VF32_M1_E32, VFRDIV_VF, 0x0, 0x20 }, // 1740
  { PseudoVFRDIV_VF32_M1_E32_MASK, VFRDIV_VF, 0x0, 0x20 }, // 1741
  { PseudoVFRDIV_VF64_M1_E64, VFRDIV_VF, 0x0, 0x40 }, // 1742
  { PseudoVFRDIV_VF64_M1_E64_MASK, VFRDIV_VF, 0x0, 0x40 }, // 1743
  { PseudoVFRDIV_VF16_M2_E16, VFRDIV_VF, 0x1, 0x10 }, // 1744
  { PseudoVFRDIV_VF16_M2_E16_MASK, VFRDIV_VF, 0x1, 0x10 }, // 1745
  { PseudoVFRDIV_VF32_M2_E32, VFRDIV_VF, 0x1, 0x20 }, // 1746
  { PseudoVFRDIV_VF32_M2_E32_MASK, VFRDIV_VF, 0x1, 0x20 }, // 1747
  { PseudoVFRDIV_VF64_M2_E64, VFRDIV_VF, 0x1, 0x40 }, // 1748
  { PseudoVFRDIV_VF64_M2_E64_MASK, VFRDIV_VF, 0x1, 0x40 }, // 1749
  { PseudoVFRDIV_VF16_M4_E16, VFRDIV_VF, 0x2, 0x10 }, // 1750
  { PseudoVFRDIV_VF16_M4_E16_MASK, VFRDIV_VF, 0x2, 0x10 }, // 1751
  { PseudoVFRDIV_VF32_M4_E32, VFRDIV_VF, 0x2, 0x20 }, // 1752
  { PseudoVFRDIV_VF32_M4_E32_MASK, VFRDIV_VF, 0x2, 0x20 }, // 1753
  { PseudoVFRDIV_VF64_M4_E64, VFRDIV_VF, 0x2, 0x40 }, // 1754
  { PseudoVFRDIV_VF64_M4_E64_MASK, VFRDIV_VF, 0x2, 0x40 }, // 1755
  { PseudoVFRDIV_VF16_M8_E16, VFRDIV_VF, 0x3, 0x10 }, // 1756
  { PseudoVFRDIV_VF16_M8_E16_MASK, VFRDIV_VF, 0x3, 0x10 }, // 1757
  { PseudoVFRDIV_VF32_M8_E32, VFRDIV_VF, 0x3, 0x20 }, // 1758
  { PseudoVFRDIV_VF32_M8_E32_MASK, VFRDIV_VF, 0x3, 0x20 }, // 1759
  { PseudoVFRDIV_VF64_M8_E64, VFRDIV_VF, 0x3, 0x40 }, // 1760
  { PseudoVFRDIV_VF64_M8_E64_MASK, VFRDIV_VF, 0x3, 0x40 }, // 1761
  { PseudoVFRDIV_VF16_MF4_E16, VFRDIV_VF, 0x6, 0x10 }, // 1762
  { PseudoVFRDIV_VF16_MF4_E16_MASK, VFRDIV_VF, 0x6, 0x10 }, // 1763
  { PseudoVFRDIV_VF16_MF2_E16, VFRDIV_VF, 0x7, 0x10 }, // 1764
  { PseudoVFRDIV_VF16_MF2_E16_MASK, VFRDIV_VF, 0x7, 0x10 }, // 1765
  { PseudoVFRDIV_VF32_MF2_E32, VFRDIV_VF, 0x7, 0x20 }, // 1766
  { PseudoVFRDIV_VF32_MF2_E32_MASK, VFRDIV_VF, 0x7, 0x20 }, // 1767
  { PseudoVFREC7_V_M1, VFREC7_V, 0x0, 0x0 }, // 1768
  { PseudoVFREC7_V_M1_MASK, VFREC7_V, 0x0, 0x0 }, // 1769
  { PseudoVFREC7_V_M2, VFREC7_V, 0x1, 0x0 }, // 1770
  { PseudoVFREC7_V_M2_MASK, VFREC7_V, 0x1, 0x0 }, // 1771
  { PseudoVFREC7_V_M4, VFREC7_V, 0x2, 0x0 }, // 1772
  { PseudoVFREC7_V_M4_MASK, VFREC7_V, 0x2, 0x0 }, // 1773
  { PseudoVFREC7_V_M8, VFREC7_V, 0x3, 0x0 }, // 1774
  { PseudoVFREC7_V_M8_MASK, VFREC7_V, 0x3, 0x0 }, // 1775
  { PseudoVFREC7_V_MF4, VFREC7_V, 0x6, 0x0 }, // 1776
  { PseudoVFREC7_V_MF4_MASK, VFREC7_V, 0x6, 0x0 }, // 1777
  { PseudoVFREC7_V_MF2, VFREC7_V, 0x7, 0x0 }, // 1778
  { PseudoVFREC7_V_MF2_MASK, VFREC7_V, 0x7, 0x0 }, // 1779
  { PseudoVFREDMAX_VS_M1_E16, VFREDMAX_VS, 0x0, 0x0 }, // 1780
  { PseudoVFREDMAX_VS_M1_E16_MASK, VFREDMAX_VS, 0x0, 0x0 }, // 1781
  { PseudoVFREDMAX_VS_M1_E32, VFREDMAX_VS, 0x0, 0x0 }, // 1782
  { PseudoVFREDMAX_VS_M1_E32_MASK, VFREDMAX_VS, 0x0, 0x0 }, // 1783
  { PseudoVFREDMAX_VS_M1_E64, VFREDMAX_VS, 0x0, 0x0 }, // 1784
  { PseudoVFREDMAX_VS_M1_E64_MASK, VFREDMAX_VS, 0x0, 0x0 }, // 1785
  { PseudoVFREDMAX_VS_M2_E16, VFREDMAX_VS, 0x1, 0x0 }, // 1786
  { PseudoVFREDMAX_VS_M2_E16_MASK, VFREDMAX_VS, 0x1, 0x0 }, // 1787
  { PseudoVFREDMAX_VS_M2_E32, VFREDMAX_VS, 0x1, 0x0 }, // 1788
  { PseudoVFREDMAX_VS_M2_E32_MASK, VFREDMAX_VS, 0x1, 0x0 }, // 1789
  { PseudoVFREDMAX_VS_M2_E64, VFREDMAX_VS, 0x1, 0x0 }, // 1790
  { PseudoVFREDMAX_VS_M2_E64_MASK, VFREDMAX_VS, 0x1, 0x0 }, // 1791
  { PseudoVFREDMAX_VS_M4_E16, VFREDMAX_VS, 0x2, 0x0 }, // 1792
  { PseudoVFREDMAX_VS_M4_E16_MASK, VFREDMAX_VS, 0x2, 0x0 }, // 1793
  { PseudoVFREDMAX_VS_M4_E32, VFREDMAX_VS, 0x2, 0x0 }, // 1794
  { PseudoVFREDMAX_VS_M4_E32_MASK, VFREDMAX_VS, 0x2, 0x0 }, // 1795
  { PseudoVFREDMAX_VS_M4_E64, VFREDMAX_VS, 0x2, 0x0 }, // 1796
  { PseudoVFREDMAX_VS_M4_E64_MASK, VFREDMAX_VS, 0x2, 0x0 }, // 1797
  { PseudoVFREDMAX_VS_M8_E16, VFREDMAX_VS, 0x3, 0x0 }, // 1798
  { PseudoVFREDMAX_VS_M8_E16_MASK, VFREDMAX_VS, 0x3, 0x0 }, // 1799
  { PseudoVFREDMAX_VS_M8_E32, VFREDMAX_VS, 0x3, 0x0 }, // 1800
  { PseudoVFREDMAX_VS_M8_E32_MASK, VFREDMAX_VS, 0x3, 0x0 }, // 1801
  { PseudoVFREDMAX_VS_M8_E64, VFREDMAX_VS, 0x3, 0x0 }, // 1802
  { PseudoVFREDMAX_VS_M8_E64_MASK, VFREDMAX_VS, 0x3, 0x0 }, // 1803
  { PseudoVFREDMAX_VS_MF4_E16, VFREDMAX_VS, 0x6, 0x0 }, // 1804
  { PseudoVFREDMAX_VS_MF4_E16_MASK, VFREDMAX_VS, 0x6, 0x0 }, // 1805
  { PseudoVFREDMAX_VS_MF2_E16, VFREDMAX_VS, 0x7, 0x0 }, // 1806
  { PseudoVFREDMAX_VS_MF2_E16_MASK, VFREDMAX_VS, 0x7, 0x0 }, // 1807
  { PseudoVFREDMAX_VS_MF2_E32, VFREDMAX_VS, 0x7, 0x0 }, // 1808
  { PseudoVFREDMAX_VS_MF2_E32_MASK, VFREDMAX_VS, 0x7, 0x0 }, // 1809
  { PseudoVFREDMIN_VS_M1_E16, VFREDMIN_VS, 0x0, 0x0 }, // 1810
  { PseudoVFREDMIN_VS_M1_E16_MASK, VFREDMIN_VS, 0x0, 0x0 }, // 1811
  { PseudoVFREDMIN_VS_M1_E32, VFREDMIN_VS, 0x0, 0x0 }, // 1812
  { PseudoVFREDMIN_VS_M1_E32_MASK, VFREDMIN_VS, 0x0, 0x0 }, // 1813
  { PseudoVFREDMIN_VS_M1_E64, VFREDMIN_VS, 0x0, 0x0 }, // 1814
  { PseudoVFREDMIN_VS_M1_E64_MASK, VFREDMIN_VS, 0x0, 0x0 }, // 1815
  { PseudoVFREDMIN_VS_M2_E16, VFREDMIN_VS, 0x1, 0x0 }, // 1816
  { PseudoVFREDMIN_VS_M2_E16_MASK, VFREDMIN_VS, 0x1, 0x0 }, // 1817
  { PseudoVFREDMIN_VS_M2_E32, VFREDMIN_VS, 0x1, 0x0 }, // 1818
  { PseudoVFREDMIN_VS_M2_E32_MASK, VFREDMIN_VS, 0x1, 0x0 }, // 1819
  { PseudoVFREDMIN_VS_M2_E64, VFREDMIN_VS, 0x1, 0x0 }, // 1820
  { PseudoVFREDMIN_VS_M2_E64_MASK, VFREDMIN_VS, 0x1, 0x0 }, // 1821
  { PseudoVFREDMIN_VS_M4_E16, VFREDMIN_VS, 0x2, 0x0 }, // 1822
  { PseudoVFREDMIN_VS_M4_E16_MASK, VFREDMIN_VS, 0x2, 0x0 }, // 1823
  { PseudoVFREDMIN_VS_M4_E32, VFREDMIN_VS, 0x2, 0x0 }, // 1824
  { PseudoVFREDMIN_VS_M4_E32_MASK, VFREDMIN_VS, 0x2, 0x0 }, // 1825
  { PseudoVFREDMIN_VS_M4_E64, VFREDMIN_VS, 0x2, 0x0 }, // 1826
  { PseudoVFREDMIN_VS_M4_E64_MASK, VFREDMIN_VS, 0x2, 0x0 }, // 1827
  { PseudoVFREDMIN_VS_M8_E16, VFREDMIN_VS, 0x3, 0x0 }, // 1828
  { PseudoVFREDMIN_VS_M8_E16_MASK, VFREDMIN_VS, 0x3, 0x0 }, // 1829
  { PseudoVFREDMIN_VS_M8_E32, VFREDMIN_VS, 0x3, 0x0 }, // 1830
  { PseudoVFREDMIN_VS_M8_E32_MASK, VFREDMIN_VS, 0x3, 0x0 }, // 1831
  { PseudoVFREDMIN_VS_M8_E64, VFREDMIN_VS, 0x3, 0x0 }, // 1832
  { PseudoVFREDMIN_VS_M8_E64_MASK, VFREDMIN_VS, 0x3, 0x0 }, // 1833
  { PseudoVFREDMIN_VS_MF4_E16, VFREDMIN_VS, 0x6, 0x0 }, // 1834
  { PseudoVFREDMIN_VS_MF4_E16_MASK, VFREDMIN_VS, 0x6, 0x0 }, // 1835
  { PseudoVFREDMIN_VS_MF2_E16, VFREDMIN_VS, 0x7, 0x0 }, // 1836
  { PseudoVFREDMIN_VS_MF2_E16_MASK, VFREDMIN_VS, 0x7, 0x0 }, // 1837
  { PseudoVFREDMIN_VS_MF2_E32, VFREDMIN_VS, 0x7, 0x0 }, // 1838
  { PseudoVFREDMIN_VS_MF2_E32_MASK, VFREDMIN_VS, 0x7, 0x0 }, // 1839
  { PseudoVFREDOSUM_VS_M1_E16, VFREDOSUM_VS, 0x0, 0x0 }, // 1840
  { PseudoVFREDOSUM_VS_M1_E16_MASK, VFREDOSUM_VS, 0x0, 0x0 }, // 1841
  { PseudoVFREDOSUM_VS_M1_E32, VFREDOSUM_VS, 0x0, 0x0 }, // 1842
  { PseudoVFREDOSUM_VS_M1_E32_MASK, VFREDOSUM_VS, 0x0, 0x0 }, // 1843
  { PseudoVFREDOSUM_VS_M1_E64, VFREDOSUM_VS, 0x0, 0x0 }, // 1844
  { PseudoVFREDOSUM_VS_M1_E64_MASK, VFREDOSUM_VS, 0x0, 0x0 }, // 1845
  { PseudoVFREDOSUM_VS_M2_E16, VFREDOSUM_VS, 0x1, 0x0 }, // 1846
  { PseudoVFREDOSUM_VS_M2_E16_MASK, VFREDOSUM_VS, 0x1, 0x0 }, // 1847
  { PseudoVFREDOSUM_VS_M2_E32, VFREDOSUM_VS, 0x1, 0x0 }, // 1848
  { PseudoVFREDOSUM_VS_M2_E32_MASK, VFREDOSUM_VS, 0x1, 0x0 }, // 1849
  { PseudoVFREDOSUM_VS_M2_E64, VFREDOSUM_VS, 0x1, 0x0 }, // 1850
  { PseudoVFREDOSUM_VS_M2_E64_MASK, VFREDOSUM_VS, 0x1, 0x0 }, // 1851
  { PseudoVFREDOSUM_VS_M4_E16, VFREDOSUM_VS, 0x2, 0x0 }, // 1852
  { PseudoVFREDOSUM_VS_M4_E16_MASK, VFREDOSUM_VS, 0x2, 0x0 }, // 1853
  { PseudoVFREDOSUM_VS_M4_E32, VFREDOSUM_VS, 0x2, 0x0 }, // 1854
  { PseudoVFREDOSUM_VS_M4_E32_MASK, VFREDOSUM_VS, 0x2, 0x0 }, // 1855
  { PseudoVFREDOSUM_VS_M4_E64, VFREDOSUM_VS, 0x2, 0x0 }, // 1856
  { PseudoVFREDOSUM_VS_M4_E64_MASK, VFREDOSUM_VS, 0x2, 0x0 }, // 1857
  { PseudoVFREDOSUM_VS_M8_E16, VFREDOSUM_VS, 0x3, 0x0 }, // 1858
  { PseudoVFREDOSUM_VS_M8_E16_MASK, VFREDOSUM_VS, 0x3, 0x0 }, // 1859
  { PseudoVFREDOSUM_VS_M8_E32, VFREDOSUM_VS, 0x3, 0x0 }, // 1860
  { PseudoVFREDOSUM_VS_M8_E32_MASK, VFREDOSUM_VS, 0x3, 0x0 }, // 1861
  { PseudoVFREDOSUM_VS_M8_E64, VFREDOSUM_VS, 0x3, 0x0 }, // 1862
  { PseudoVFREDOSUM_VS_M8_E64_MASK, VFREDOSUM_VS, 0x3, 0x0 }, // 1863
  { PseudoVFREDOSUM_VS_MF4_E16, VFREDOSUM_VS, 0x6, 0x0 }, // 1864
  { PseudoVFREDOSUM_VS_MF4_E16_MASK, VFREDOSUM_VS, 0x6, 0x0 }, // 1865
  { PseudoVFREDOSUM_VS_MF2_E16, VFREDOSUM_VS, 0x7, 0x0 }, // 1866
  { PseudoVFREDOSUM_VS_MF2_E16_MASK, VFREDOSUM_VS, 0x7, 0x0 }, // 1867
  { PseudoVFREDOSUM_VS_MF2_E32, VFREDOSUM_VS, 0x7, 0x0 }, // 1868
  { PseudoVFREDOSUM_VS_MF2_E32_MASK, VFREDOSUM_VS, 0x7, 0x0 }, // 1869
  { PseudoVFREDUSUM_VS_M1_E16, VFREDUSUM_VS, 0x0, 0x0 }, // 1870
  { PseudoVFREDUSUM_VS_M1_E16_MASK, VFREDUSUM_VS, 0x0, 0x0 }, // 1871
  { PseudoVFREDUSUM_VS_M1_E32, VFREDUSUM_VS, 0x0, 0x0 }, // 1872
  { PseudoVFREDUSUM_VS_M1_E32_MASK, VFREDUSUM_VS, 0x0, 0x0 }, // 1873
  { PseudoVFREDUSUM_VS_M1_E64, VFREDUSUM_VS, 0x0, 0x0 }, // 1874
  { PseudoVFREDUSUM_VS_M1_E64_MASK, VFREDUSUM_VS, 0x0, 0x0 }, // 1875
  { PseudoVFREDUSUM_VS_M2_E16, VFREDUSUM_VS, 0x1, 0x0 }, // 1876
  { PseudoVFREDUSUM_VS_M2_E16_MASK, VFREDUSUM_VS, 0x1, 0x0 }, // 1877
  { PseudoVFREDUSUM_VS_M2_E32, VFREDUSUM_VS, 0x1, 0x0 }, // 1878
  { PseudoVFREDUSUM_VS_M2_E32_MASK, VFREDUSUM_VS, 0x1, 0x0 }, // 1879
  { PseudoVFREDUSUM_VS_M2_E64, VFREDUSUM_VS, 0x1, 0x0 }, // 1880
  { PseudoVFREDUSUM_VS_M2_E64_MASK, VFREDUSUM_VS, 0x1, 0x0 }, // 1881
  { PseudoVFREDUSUM_VS_M4_E16, VFREDUSUM_VS, 0x2, 0x0 }, // 1882
  { PseudoVFREDUSUM_VS_M4_E16_MASK, VFREDUSUM_VS, 0x2, 0x0 }, // 1883
  { PseudoVFREDUSUM_VS_M4_E32, VFREDUSUM_VS, 0x2, 0x0 }, // 1884
  { PseudoVFREDUSUM_VS_M4_E32_MASK, VFREDUSUM_VS, 0x2, 0x0 }, // 1885
  { PseudoVFREDUSUM_VS_M4_E64, VFREDUSUM_VS, 0x2, 0x0 }, // 1886
  { PseudoVFREDUSUM_VS_M4_E64_MASK, VFREDUSUM_VS, 0x2, 0x0 }, // 1887
  { PseudoVFREDUSUM_VS_M8_E16, VFREDUSUM_VS, 0x3, 0x0 }, // 1888
  { PseudoVFREDUSUM_VS_M8_E16_MASK, VFREDUSUM_VS, 0x3, 0x0 }, // 1889
  { PseudoVFREDUSUM_VS_M8_E32, VFREDUSUM_VS, 0x3, 0x0 }, // 1890
  { PseudoVFREDUSUM_VS_M8_E32_MASK, VFREDUSUM_VS, 0x3, 0x0 }, // 1891
  { PseudoVFREDUSUM_VS_M8_E64, VFREDUSUM_VS, 0x3, 0x0 }, // 1892
  { PseudoVFREDUSUM_VS_M8_E64_MASK, VFREDUSUM_VS, 0x3, 0x0 }, // 1893
  { PseudoVFREDUSUM_VS_MF4_E16, VFREDUSUM_VS, 0x6, 0x0 }, // 1894
  { PseudoVFREDUSUM_VS_MF4_E16_MASK, VFREDUSUM_VS, 0x6, 0x0 }, // 1895
  { PseudoVFREDUSUM_VS_MF2_E16, VFREDUSUM_VS, 0x7, 0x0 }, // 1896
  { PseudoVFREDUSUM_VS_MF2_E16_MASK, VFREDUSUM_VS, 0x7, 0x0 }, // 1897
  { PseudoVFREDUSUM_VS_MF2_E32, VFREDUSUM_VS, 0x7, 0x0 }, // 1898
  { PseudoVFREDUSUM_VS_MF2_E32_MASK, VFREDUSUM_VS, 0x7, 0x0 }, // 1899
  { PseudoVFRSQRT7_V_M1, VFRSQRT7_V, 0x0, 0x0 }, // 1900
  { PseudoVFRSQRT7_V_M1_MASK, VFRSQRT7_V, 0x0, 0x0 }, // 1901
  { PseudoVFRSQRT7_V_M2, VFRSQRT7_V, 0x1, 0x0 }, // 1902
  { PseudoVFRSQRT7_V_M2_MASK, VFRSQRT7_V, 0x1, 0x0 }, // 1903
  { PseudoVFRSQRT7_V_M4, VFRSQRT7_V, 0x2, 0x0 }, // 1904
  { PseudoVFRSQRT7_V_M4_MASK, VFRSQRT7_V, 0x2, 0x0 }, // 1905
  { PseudoVFRSQRT7_V_M8, VFRSQRT7_V, 0x3, 0x0 }, // 1906
  { PseudoVFRSQRT7_V_M8_MASK, VFRSQRT7_V, 0x3, 0x0 }, // 1907
  { PseudoVFRSQRT7_V_MF4, VFRSQRT7_V, 0x6, 0x0 }, // 1908
  { PseudoVFRSQRT7_V_MF4_MASK, VFRSQRT7_V, 0x6, 0x0 }, // 1909
  { PseudoVFRSQRT7_V_MF2, VFRSQRT7_V, 0x7, 0x0 }, // 1910
  { PseudoVFRSQRT7_V_MF2_MASK, VFRSQRT7_V, 0x7, 0x0 }, // 1911
  { PseudoVFRSUB_VF16_M1, VFRSUB_VF, 0x0, 0x0 }, // 1912
  { PseudoVFRSUB_VF16_M1_MASK, VFRSUB_VF, 0x0, 0x0 }, // 1913
  { PseudoVFRSUB_VF32_M1, VFRSUB_VF, 0x0, 0x0 }, // 1914
  { PseudoVFRSUB_VF32_M1_MASK, VFRSUB_VF, 0x0, 0x0 }, // 1915
  { PseudoVFRSUB_VF64_M1, VFRSUB_VF, 0x0, 0x0 }, // 1916
  { PseudoVFRSUB_VF64_M1_MASK, VFRSUB_VF, 0x0, 0x0 }, // 1917
  { PseudoVFRSUB_VF16_M2, VFRSUB_VF, 0x1, 0x0 }, // 1918
  { PseudoVFRSUB_VF16_M2_MASK, VFRSUB_VF, 0x1, 0x0 }, // 1919
  { PseudoVFRSUB_VF32_M2, VFRSUB_VF, 0x1, 0x0 }, // 1920
  { PseudoVFRSUB_VF32_M2_MASK, VFRSUB_VF, 0x1, 0x0 }, // 1921
  { PseudoVFRSUB_VF64_M2, VFRSUB_VF, 0x1, 0x0 }, // 1922
  { PseudoVFRSUB_VF64_M2_MASK, VFRSUB_VF, 0x1, 0x0 }, // 1923
  { PseudoVFRSUB_VF16_M4, VFRSUB_VF, 0x2, 0x0 }, // 1924
  { PseudoVFRSUB_VF16_M4_MASK, VFRSUB_VF, 0x2, 0x0 }, // 1925
  { PseudoVFRSUB_VF32_M4, VFRSUB_VF, 0x2, 0x0 }, // 1926
  { PseudoVFRSUB_VF32_M4_MASK, VFRSUB_VF, 0x2, 0x0 }, // 1927
  { PseudoVFRSUB_VF64_M4, VFRSUB_VF, 0x2, 0x0 }, // 1928
  { PseudoVFRSUB_VF64_M4_MASK, VFRSUB_VF, 0x2, 0x0 }, // 1929
  { PseudoVFRSUB_VF16_M8, VFRSUB_VF, 0x3, 0x0 }, // 1930
  { PseudoVFRSUB_VF16_M8_MASK, VFRSUB_VF, 0x3, 0x0 }, // 1931
  { PseudoVFRSUB_VF32_M8, VFRSUB_VF, 0x3, 0x0 }, // 1932
  { PseudoVFRSUB_VF32_M8_MASK, VFRSUB_VF, 0x3, 0x0 }, // 1933
  { PseudoVFRSUB_VF64_M8, VFRSUB_VF, 0x3, 0x0 }, // 1934
  { PseudoVFRSUB_VF64_M8_MASK, VFRSUB_VF, 0x3, 0x0 }, // 1935
  { PseudoVFRSUB_VF16_MF4, VFRSUB_VF, 0x6, 0x0 }, // 1936
  { PseudoVFRSUB_VF16_MF4_MASK, VFRSUB_VF, 0x6, 0x0 }, // 1937
  { PseudoVFRSUB_VF16_MF2, VFRSUB_VF, 0x7, 0x0 }, // 1938
  { PseudoVFRSUB_VF16_MF2_MASK, VFRSUB_VF, 0x7, 0x0 }, // 1939
  { PseudoVFRSUB_VF32_MF2, VFRSUB_VF, 0x7, 0x0 }, // 1940
  { PseudoVFRSUB_VF32_MF2_MASK, VFRSUB_VF, 0x7, 0x0 }, // 1941
  { PseudoVFSGNJN_VF16_M1, VFSGNJN_VF, 0x0, 0x0 }, // 1942
  { PseudoVFSGNJN_VF16_M1_MASK, VFSGNJN_VF, 0x0, 0x0 }, // 1943
  { PseudoVFSGNJN_VF32_M1, VFSGNJN_VF, 0x0, 0x0 }, // 1944
  { PseudoVFSGNJN_VF32_M1_MASK, VFSGNJN_VF, 0x0, 0x0 }, // 1945
  { PseudoVFSGNJN_VF64_M1, VFSGNJN_VF, 0x0, 0x0 }, // 1946
  { PseudoVFSGNJN_VF64_M1_MASK, VFSGNJN_VF, 0x0, 0x0 }, // 1947
  { PseudoVFSGNJN_VF16_M2, VFSGNJN_VF, 0x1, 0x0 }, // 1948
  { PseudoVFSGNJN_VF16_M2_MASK, VFSGNJN_VF, 0x1, 0x0 }, // 1949
  { PseudoVFSGNJN_VF32_M2, VFSGNJN_VF, 0x1, 0x0 }, // 1950
  { PseudoVFSGNJN_VF32_M2_MASK, VFSGNJN_VF, 0x1, 0x0 }, // 1951
  { PseudoVFSGNJN_VF64_M2, VFSGNJN_VF, 0x1, 0x0 }, // 1952
  { PseudoVFSGNJN_VF64_M2_MASK, VFSGNJN_VF, 0x1, 0x0 }, // 1953
  { PseudoVFSGNJN_VF16_M4, VFSGNJN_VF, 0x2, 0x0 }, // 1954
  { PseudoVFSGNJN_VF16_M4_MASK, VFSGNJN_VF, 0x2, 0x0 }, // 1955
  { PseudoVFSGNJN_VF32_M4, VFSGNJN_VF, 0x2, 0x0 }, // 1956
  { PseudoVFSGNJN_VF32_M4_MASK, VFSGNJN_VF, 0x2, 0x0 }, // 1957
  { PseudoVFSGNJN_VF64_M4, VFSGNJN_VF, 0x2, 0x0 }, // 1958
  { PseudoVFSGNJN_VF64_M4_MASK, VFSGNJN_VF, 0x2, 0x0 }, // 1959
  { PseudoVFSGNJN_VF16_M8, VFSGNJN_VF, 0x3, 0x0 }, // 1960
  { PseudoVFSGNJN_VF16_M8_MASK, VFSGNJN_VF, 0x3, 0x0 }, // 1961
  { PseudoVFSGNJN_VF32_M8, VFSGNJN_VF, 0x3, 0x0 }, // 1962
  { PseudoVFSGNJN_VF32_M8_MASK, VFSGNJN_VF, 0x3, 0x0 }, // 1963
  { PseudoVFSGNJN_VF64_M8, VFSGNJN_VF, 0x3, 0x0 }, // 1964
  { PseudoVFSGNJN_VF64_M8_MASK, VFSGNJN_VF, 0x3, 0x0 }, // 1965
  { PseudoVFSGNJN_VF16_MF4, VFSGNJN_VF, 0x6, 0x0 }, // 1966
  { PseudoVFSGNJN_VF16_MF4_MASK, VFSGNJN_VF, 0x6, 0x0 }, // 1967
  { PseudoVFSGNJN_VF16_MF2, VFSGNJN_VF, 0x7, 0x0 }, // 1968
  { PseudoVFSGNJN_VF16_MF2_MASK, VFSGNJN_VF, 0x7, 0x0 }, // 1969
  { PseudoVFSGNJN_VF32_MF2, VFSGNJN_VF, 0x7, 0x0 }, // 1970
  { PseudoVFSGNJN_VF32_MF2_MASK, VFSGNJN_VF, 0x7, 0x0 }, // 1971
  { PseudoVFSGNJN_VV_M1, VFSGNJN_VV, 0x0, 0x0 }, // 1972
  { PseudoVFSGNJN_VV_M1_MASK, VFSGNJN_VV, 0x0, 0x0 }, // 1973
  { PseudoVFSGNJN_VV_M2, VFSGNJN_VV, 0x1, 0x0 }, // 1974
  { PseudoVFSGNJN_VV_M2_MASK, VFSGNJN_VV, 0x1, 0x0 }, // 1975
  { PseudoVFSGNJN_VV_M4, VFSGNJN_VV, 0x2, 0x0 }, // 1976
  { PseudoVFSGNJN_VV_M4_MASK, VFSGNJN_VV, 0x2, 0x0 }, // 1977
  { PseudoVFSGNJN_VV_M8, VFSGNJN_VV, 0x3, 0x0 }, // 1978
  { PseudoVFSGNJN_VV_M8_MASK, VFSGNJN_VV, 0x3, 0x0 }, // 1979
  { PseudoVFSGNJN_VV_MF4, VFSGNJN_VV, 0x6, 0x0 }, // 1980
  { PseudoVFSGNJN_VV_MF4_MASK, VFSGNJN_VV, 0x6, 0x0 }, // 1981
  { PseudoVFSGNJN_VV_MF2, VFSGNJN_VV, 0x7, 0x0 }, // 1982
  { PseudoVFSGNJN_VV_MF2_MASK, VFSGNJN_VV, 0x7, 0x0 }, // 1983
  { PseudoVFSGNJX_VF16_M1, VFSGNJX_VF, 0x0, 0x0 }, // 1984
  { PseudoVFSGNJX_VF16_M1_MASK, VFSGNJX_VF, 0x0, 0x0 }, // 1985
  { PseudoVFSGNJX_VF32_M1, VFSGNJX_VF, 0x0, 0x0 }, // 1986
  { PseudoVFSGNJX_VF32_M1_MASK, VFSGNJX_VF, 0x0, 0x0 }, // 1987
  { PseudoVFSGNJX_VF64_M1, VFSGNJX_VF, 0x0, 0x0 }, // 1988
  { PseudoVFSGNJX_VF64_M1_MASK, VFSGNJX_VF, 0x0, 0x0 }, // 1989
  { PseudoVFSGNJX_VF16_M2, VFSGNJX_VF, 0x1, 0x0 }, // 1990
  { PseudoVFSGNJX_VF16_M2_MASK, VFSGNJX_VF, 0x1, 0x0 }, // 1991
  { PseudoVFSGNJX_VF32_M2, VFSGNJX_VF, 0x1, 0x0 }, // 1992
  { PseudoVFSGNJX_VF32_M2_MASK, VFSGNJX_VF, 0x1, 0x0 }, // 1993
  { PseudoVFSGNJX_VF64_M2, VFSGNJX_VF, 0x1, 0x0 }, // 1994
  { PseudoVFSGNJX_VF64_M2_MASK, VFSGNJX_VF, 0x1, 0x0 }, // 1995
  { PseudoVFSGNJX_VF16_M4, VFSGNJX_VF, 0x2, 0x0 }, // 1996
  { PseudoVFSGNJX_VF16_M4_MASK, VFSGNJX_VF, 0x2, 0x0 }, // 1997
  { PseudoVFSGNJX_VF32_M4, VFSGNJX_VF, 0x2, 0x0 }, // 1998
  { PseudoVFSGNJX_VF32_M4_MASK, VFSGNJX_VF, 0x2, 0x0 }, // 1999
  { PseudoVFSGNJX_VF64_M4, VFSGNJX_VF, 0x2, 0x0 }, // 2000
  { PseudoVFSGNJX_VF64_M4_MASK, VFSGNJX_VF, 0x2, 0x0 }, // 2001
  { PseudoVFSGNJX_VF16_M8, VFSGNJX_VF, 0x3, 0x0 }, // 2002
  { PseudoVFSGNJX_VF16_M8_MASK, VFSGNJX_VF, 0x3, 0x0 }, // 2003
  { PseudoVFSGNJX_VF32_M8, VFSGNJX_VF, 0x3, 0x0 }, // 2004
  { PseudoVFSGNJX_VF32_M8_MASK, VFSGNJX_VF, 0x3, 0x0 }, // 2005
  { PseudoVFSGNJX_VF64_M8, VFSGNJX_VF, 0x3, 0x0 }, // 2006
  { PseudoVFSGNJX_VF64_M8_MASK, VFSGNJX_VF, 0x3, 0x0 }, // 2007
  { PseudoVFSGNJX_VF16_MF4, VFSGNJX_VF, 0x6, 0x0 }, // 2008
  { PseudoVFSGNJX_VF16_MF4_MASK, VFSGNJX_VF, 0x6, 0x0 }, // 2009
  { PseudoVFSGNJX_VF16_MF2, VFSGNJX_VF, 0x7, 0x0 }, // 2010
  { PseudoVFSGNJX_VF16_MF2_MASK, VFSGNJX_VF, 0x7, 0x0 }, // 2011
  { PseudoVFSGNJX_VF32_MF2, VFSGNJX_VF, 0x7, 0x0 }, // 2012
  { PseudoVFSGNJX_VF32_MF2_MASK, VFSGNJX_VF, 0x7, 0x0 }, // 2013
  { PseudoVFSGNJX_VV_M1, VFSGNJX_VV, 0x0, 0x0 }, // 2014
  { PseudoVFSGNJX_VV_M1_MASK, VFSGNJX_VV, 0x0, 0x0 }, // 2015
  { PseudoVFSGNJX_VV_M2, VFSGNJX_VV, 0x1, 0x0 }, // 2016
  { PseudoVFSGNJX_VV_M2_MASK, VFSGNJX_VV, 0x1, 0x0 }, // 2017
  { PseudoVFSGNJX_VV_M4, VFSGNJX_VV, 0x2, 0x0 }, // 2018
  { PseudoVFSGNJX_VV_M4_MASK, VFSGNJX_VV, 0x2, 0x0 }, // 2019
  { PseudoVFSGNJX_VV_M8, VFSGNJX_VV, 0x3, 0x0 }, // 2020
  { PseudoVFSGNJX_VV_M8_MASK, VFSGNJX_VV, 0x3, 0x0 }, // 2021
  { PseudoVFSGNJX_VV_MF4, VFSGNJX_VV, 0x6, 0x0 }, // 2022
  { PseudoVFSGNJX_VV_MF4_MASK, VFSGNJX_VV, 0x6, 0x0 }, // 2023
  { PseudoVFSGNJX_VV_MF2, VFSGNJX_VV, 0x7, 0x0 }, // 2024
  { PseudoVFSGNJX_VV_MF2_MASK, VFSGNJX_VV, 0x7, 0x0 }, // 2025
  { PseudoVFSGNJ_VF16_M1, VFSGNJ_VF, 0x0, 0x0 }, // 2026
  { PseudoVFSGNJ_VF16_M1_MASK, VFSGNJ_VF, 0x0, 0x0 }, // 2027
  { PseudoVFSGNJ_VF32_M1, VFSGNJ_VF, 0x0, 0x0 }, // 2028
  { PseudoVFSGNJ_VF32_M1_MASK, VFSGNJ_VF, 0x0, 0x0 }, // 2029
  { PseudoVFSGNJ_VF64_M1, VFSGNJ_VF, 0x0, 0x0 }, // 2030
  { PseudoVFSGNJ_VF64_M1_MASK, VFSGNJ_VF, 0x0, 0x0 }, // 2031
  { PseudoVFSGNJ_VF16_M2, VFSGNJ_VF, 0x1, 0x0 }, // 2032
  { PseudoVFSGNJ_VF16_M2_MASK, VFSGNJ_VF, 0x1, 0x0 }, // 2033
  { PseudoVFSGNJ_VF32_M2, VFSGNJ_VF, 0x1, 0x0 }, // 2034
  { PseudoVFSGNJ_VF32_M2_MASK, VFSGNJ_VF, 0x1, 0x0 }, // 2035
  { PseudoVFSGNJ_VF64_M2, VFSGNJ_VF, 0x1, 0x0 }, // 2036
  { PseudoVFSGNJ_VF64_M2_MASK, VFSGNJ_VF, 0x1, 0x0 }, // 2037
  { PseudoVFSGNJ_VF16_M4, VFSGNJ_VF, 0x2, 0x0 }, // 2038
  { PseudoVFSGNJ_VF16_M4_MASK, VFSGNJ_VF, 0x2, 0x0 }, // 2039
  { PseudoVFSGNJ_VF32_M4, VFSGNJ_VF, 0x2, 0x0 }, // 2040
  { PseudoVFSGNJ_VF32_M4_MASK, VFSGNJ_VF, 0x2, 0x0 }, // 2041
  { PseudoVFSGNJ_VF64_M4, VFSGNJ_VF, 0x2, 0x0 }, // 2042
  { PseudoVFSGNJ_VF64_M4_MASK, VFSGNJ_VF, 0x2, 0x0 }, // 2043
  { PseudoVFSGNJ_VF16_M8, VFSGNJ_VF, 0x3, 0x0 }, // 2044
  { PseudoVFSGNJ_VF16_M8_MASK, VFSGNJ_VF, 0x3, 0x0 }, // 2045
  { PseudoVFSGNJ_VF32_M8, VFSGNJ_VF, 0x3, 0x0 }, // 2046
  { PseudoVFSGNJ_VF32_M8_MASK, VFSGNJ_VF, 0x3, 0x0 }, // 2047
  { PseudoVFSGNJ_VF64_M8, VFSGNJ_VF, 0x3, 0x0 }, // 2048
  { PseudoVFSGNJ_VF64_M8_MASK, VFSGNJ_VF, 0x3, 0x0 }, // 2049
  { PseudoVFSGNJ_VF16_MF4, VFSGNJ_VF, 0x6, 0x0 }, // 2050
  { PseudoVFSGNJ_VF16_MF4_MASK, VFSGNJ_VF, 0x6, 0x0 }, // 2051
  { PseudoVFSGNJ_VF16_MF2, VFSGNJ_VF, 0x7, 0x0 }, // 2052
  { PseudoVFSGNJ_VF16_MF2_MASK, VFSGNJ_VF, 0x7, 0x0 }, // 2053
  { PseudoVFSGNJ_VF32_MF2, VFSGNJ_VF, 0x7, 0x0 }, // 2054
  { PseudoVFSGNJ_VF32_MF2_MASK, VFSGNJ_VF, 0x7, 0x0 }, // 2055
  { PseudoVFSGNJ_VV_M1, VFSGNJ_VV, 0x0, 0x0 }, // 2056
  { PseudoVFSGNJ_VV_M1_MASK, VFSGNJ_VV, 0x0, 0x0 }, // 2057
  { PseudoVFSGNJ_VV_M2, VFSGNJ_VV, 0x1, 0x0 }, // 2058
  { PseudoVFSGNJ_VV_M2_MASK, VFSGNJ_VV, 0x1, 0x0 }, // 2059
  { PseudoVFSGNJ_VV_M4, VFSGNJ_VV, 0x2, 0x0 }, // 2060
  { PseudoVFSGNJ_VV_M4_MASK, VFSGNJ_VV, 0x2, 0x0 }, // 2061
  { PseudoVFSGNJ_VV_M8, VFSGNJ_VV, 0x3, 0x0 }, // 2062
  { PseudoVFSGNJ_VV_M8_MASK, VFSGNJ_VV, 0x3, 0x0 }, // 2063
  { PseudoVFSGNJ_VV_MF4, VFSGNJ_VV, 0x6, 0x0 }, // 2064
  { PseudoVFSGNJ_VV_MF4_MASK, VFSGNJ_VV, 0x6, 0x0 }, // 2065
  { PseudoVFSGNJ_VV_MF2, VFSGNJ_VV, 0x7, 0x0 }, // 2066
  { PseudoVFSGNJ_VV_MF2_MASK, VFSGNJ_VV, 0x7, 0x0 }, // 2067
  { PseudoVFSLIDE1DOWN_VF16_M1, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2068
  { PseudoVFSLIDE1DOWN_VF16_M1_MASK, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2069
  { PseudoVFSLIDE1DOWN_VF32_M1, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2070
  { PseudoVFSLIDE1DOWN_VF32_M1_MASK, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2071
  { PseudoVFSLIDE1DOWN_VF64_M1, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2072
  { PseudoVFSLIDE1DOWN_VF64_M1_MASK, VFSLIDE1DOWN_VF, 0x0, 0x0 }, // 2073
  { PseudoVFSLIDE1DOWN_VF16_M2, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2074
  { PseudoVFSLIDE1DOWN_VF16_M2_MASK, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2075
  { PseudoVFSLIDE1DOWN_VF32_M2, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2076
  { PseudoVFSLIDE1DOWN_VF32_M2_MASK, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2077
  { PseudoVFSLIDE1DOWN_VF64_M2, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2078
  { PseudoVFSLIDE1DOWN_VF64_M2_MASK, VFSLIDE1DOWN_VF, 0x1, 0x0 }, // 2079
  { PseudoVFSLIDE1DOWN_VF16_M4, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2080
  { PseudoVFSLIDE1DOWN_VF16_M4_MASK, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2081
  { PseudoVFSLIDE1DOWN_VF32_M4, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2082
  { PseudoVFSLIDE1DOWN_VF32_M4_MASK, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2083
  { PseudoVFSLIDE1DOWN_VF64_M4, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2084
  { PseudoVFSLIDE1DOWN_VF64_M4_MASK, VFSLIDE1DOWN_VF, 0x2, 0x0 }, // 2085
  { PseudoVFSLIDE1DOWN_VF16_M8, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2086
  { PseudoVFSLIDE1DOWN_VF16_M8_MASK, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2087
  { PseudoVFSLIDE1DOWN_VF32_M8, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2088
  { PseudoVFSLIDE1DOWN_VF32_M8_MASK, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2089
  { PseudoVFSLIDE1DOWN_VF64_M8, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2090
  { PseudoVFSLIDE1DOWN_VF64_M8_MASK, VFSLIDE1DOWN_VF, 0x3, 0x0 }, // 2091
  { PseudoVFSLIDE1DOWN_VF16_MF4, VFSLIDE1DOWN_VF, 0x6, 0x0 }, // 2092
  { PseudoVFSLIDE1DOWN_VF16_MF4_MASK, VFSLIDE1DOWN_VF, 0x6, 0x0 }, // 2093
  { PseudoVFSLIDE1DOWN_VF16_MF2, VFSLIDE1DOWN_VF, 0x7, 0x0 }, // 2094
  { PseudoVFSLIDE1DOWN_VF16_MF2_MASK, VFSLIDE1DOWN_VF, 0x7, 0x0 }, // 2095
  { PseudoVFSLIDE1DOWN_VF32_MF2, VFSLIDE1DOWN_VF, 0x7, 0x0 }, // 2096
  { PseudoVFSLIDE1DOWN_VF32_MF2_MASK, VFSLIDE1DOWN_VF, 0x7, 0x0 }, // 2097
  { PseudoVFSLIDE1UP_VF16_M1, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2098
  { PseudoVFSLIDE1UP_VF16_M1_MASK, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2099
  { PseudoVFSLIDE1UP_VF32_M1, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2100
  { PseudoVFSLIDE1UP_VF32_M1_MASK, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2101
  { PseudoVFSLIDE1UP_VF64_M1, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2102
  { PseudoVFSLIDE1UP_VF64_M1_MASK, VFSLIDE1UP_VF, 0x0, 0x0 }, // 2103
  { PseudoVFSLIDE1UP_VF16_M2, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2104
  { PseudoVFSLIDE1UP_VF16_M2_MASK, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2105
  { PseudoVFSLIDE1UP_VF32_M2, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2106
  { PseudoVFSLIDE1UP_VF32_M2_MASK, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2107
  { PseudoVFSLIDE1UP_VF64_M2, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2108
  { PseudoVFSLIDE1UP_VF64_M2_MASK, VFSLIDE1UP_VF, 0x1, 0x0 }, // 2109
  { PseudoVFSLIDE1UP_VF16_M4, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2110
  { PseudoVFSLIDE1UP_VF16_M4_MASK, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2111
  { PseudoVFSLIDE1UP_VF32_M4, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2112
  { PseudoVFSLIDE1UP_VF32_M4_MASK, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2113
  { PseudoVFSLIDE1UP_VF64_M4, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2114
  { PseudoVFSLIDE1UP_VF64_M4_MASK, VFSLIDE1UP_VF, 0x2, 0x0 }, // 2115
  { PseudoVFSLIDE1UP_VF16_M8, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2116
  { PseudoVFSLIDE1UP_VF16_M8_MASK, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2117
  { PseudoVFSLIDE1UP_VF32_M8, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2118
  { PseudoVFSLIDE1UP_VF32_M8_MASK, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2119
  { PseudoVFSLIDE1UP_VF64_M8, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2120
  { PseudoVFSLIDE1UP_VF64_M8_MASK, VFSLIDE1UP_VF, 0x3, 0x0 }, // 2121
  { PseudoVFSLIDE1UP_VF16_MF4, VFSLIDE1UP_VF, 0x6, 0x0 }, // 2122
  { PseudoVFSLIDE1UP_VF16_MF4_MASK, VFSLIDE1UP_VF, 0x6, 0x0 }, // 2123
  { PseudoVFSLIDE1UP_VF16_MF2, VFSLIDE1UP_VF, 0x7, 0x0 }, // 2124
  { PseudoVFSLIDE1UP_VF16_MF2_MASK, VFSLIDE1UP_VF, 0x7, 0x0 }, // 2125
  { PseudoVFSLIDE1UP_VF32_MF2, VFSLIDE1UP_VF, 0x7, 0x0 }, // 2126
  { PseudoVFSLIDE1UP_VF32_MF2_MASK, VFSLIDE1UP_VF, 0x7, 0x0 }, // 2127
  { PseudoVFSQRT_V_M1_E16, VFSQRT_V, 0x0, 0x10 }, // 2128
  { PseudoVFSQRT_V_M1_E16_MASK, VFSQRT_V, 0x0, 0x10 }, // 2129
  { PseudoVFSQRT_V_M1_E32, VFSQRT_V, 0x0, 0x20 }, // 2130
  { PseudoVFSQRT_V_M1_E32_MASK, VFSQRT_V, 0x0, 0x20 }, // 2131
  { PseudoVFSQRT_V_M1_E64, VFSQRT_V, 0x0, 0x40 }, // 2132
  { PseudoVFSQRT_V_M1_E64_MASK, VFSQRT_V, 0x0, 0x40 }, // 2133
  { PseudoVFSQRT_V_M2_E16, VFSQRT_V, 0x1, 0x10 }, // 2134
  { PseudoVFSQRT_V_M2_E16_MASK, VFSQRT_V, 0x1, 0x10 }, // 2135
  { PseudoVFSQRT_V_M2_E32, VFSQRT_V, 0x1, 0x20 }, // 2136
  { PseudoVFSQRT_V_M2_E32_MASK, VFSQRT_V, 0x1, 0x20 }, // 2137
  { PseudoVFSQRT_V_M2_E64, VFSQRT_V, 0x1, 0x40 }, // 2138
  { PseudoVFSQRT_V_M2_E64_MASK, VFSQRT_V, 0x1, 0x40 }, // 2139
  { PseudoVFSQRT_V_M4_E16, VFSQRT_V, 0x2, 0x10 }, // 2140
  { PseudoVFSQRT_V_M4_E16_MASK, VFSQRT_V, 0x2, 0x10 }, // 2141
  { PseudoVFSQRT_V_M4_E32, VFSQRT_V, 0x2, 0x20 }, // 2142
  { PseudoVFSQRT_V_M4_E32_MASK, VFSQRT_V, 0x2, 0x20 }, // 2143
  { PseudoVFSQRT_V_M4_E64, VFSQRT_V, 0x2, 0x40 }, // 2144
  { PseudoVFSQRT_V_M4_E64_MASK, VFSQRT_V, 0x2, 0x40 }, // 2145
  { PseudoVFSQRT_V_M8_E16, VFSQRT_V, 0x3, 0x10 }, // 2146
  { PseudoVFSQRT_V_M8_E16_MASK, VFSQRT_V, 0x3, 0x10 }, // 2147
  { PseudoVFSQRT_V_M8_E32, VFSQRT_V, 0x3, 0x20 }, // 2148
  { PseudoVFSQRT_V_M8_E32_MASK, VFSQRT_V, 0x3, 0x20 }, // 2149
  { PseudoVFSQRT_V_M8_E64, VFSQRT_V, 0x3, 0x40 }, // 2150
  { PseudoVFSQRT_V_M8_E64_MASK, VFSQRT_V, 0x3, 0x40 }, // 2151
  { PseudoVFSQRT_V_MF4_E16, VFSQRT_V, 0x6, 0x10 }, // 2152
  { PseudoVFSQRT_V_MF4_E16_MASK, VFSQRT_V, 0x6, 0x10 }, // 2153
  { PseudoVFSQRT_V_MF2_E16, VFSQRT_V, 0x7, 0x10 }, // 2154
  { PseudoVFSQRT_V_MF2_E16_MASK, VFSQRT_V, 0x7, 0x10 }, // 2155
  { PseudoVFSQRT_V_MF2_E32, VFSQRT_V, 0x7, 0x20 }, // 2156
  { PseudoVFSQRT_V_MF2_E32_MASK, VFSQRT_V, 0x7, 0x20 }, // 2157
  { PseudoVFSUB_VF16_M1, VFSUB_VF, 0x0, 0x0 }, // 2158
  { PseudoVFSUB_VF16_M1_MASK, VFSUB_VF, 0x0, 0x0 }, // 2159
  { PseudoVFSUB_VF32_M1, VFSUB_VF, 0x0, 0x0 }, // 2160
  { PseudoVFSUB_VF32_M1_MASK, VFSUB_VF, 0x0, 0x0 }, // 2161
  { PseudoVFSUB_VF64_M1, VFSUB_VF, 0x0, 0x0 }, // 2162
  { PseudoVFSUB_VF64_M1_MASK, VFSUB_VF, 0x0, 0x0 }, // 2163
  { PseudoVFSUB_VF16_M2, VFSUB_VF, 0x1, 0x0 }, // 2164
  { PseudoVFSUB_VF16_M2_MASK, VFSUB_VF, 0x1, 0x0 }, // 2165
  { PseudoVFSUB_VF32_M2, VFSUB_VF, 0x1, 0x0 }, // 2166
  { PseudoVFSUB_VF32_M2_MASK, VFSUB_VF, 0x1, 0x0 }, // 2167
  { PseudoVFSUB_VF64_M2, VFSUB_VF, 0x1, 0x0 }, // 2168
  { PseudoVFSUB_VF64_M2_MASK, VFSUB_VF, 0x1, 0x0 }, // 2169
  { PseudoVFSUB_VF16_M4, VFSUB_VF, 0x2, 0x0 }, // 2170
  { PseudoVFSUB_VF16_M4_MASK, VFSUB_VF, 0x2, 0x0 }, // 2171
  { PseudoVFSUB_VF32_M4, VFSUB_VF, 0x2, 0x0 }, // 2172
  { PseudoVFSUB_VF32_M4_MASK, VFSUB_VF, 0x2, 0x0 }, // 2173
  { PseudoVFSUB_VF64_M4, VFSUB_VF, 0x2, 0x0 }, // 2174
  { PseudoVFSUB_VF64_M4_MASK, VFSUB_VF, 0x2, 0x0 }, // 2175
  { PseudoVFSUB_VF16_M8, VFSUB_VF, 0x3, 0x0 }, // 2176
  { PseudoVFSUB_VF16_M8_MASK, VFSUB_VF, 0x3, 0x0 }, // 2177
  { PseudoVFSUB_VF32_M8, VFSUB_VF, 0x3, 0x0 }, // 2178
  { PseudoVFSUB_VF32_M8_MASK, VFSUB_VF, 0x3, 0x0 }, // 2179
  { PseudoVFSUB_VF64_M8, VFSUB_VF, 0x3, 0x0 }, // 2180
  { PseudoVFSUB_VF64_M8_MASK, VFSUB_VF, 0x3, 0x0 }, // 2181
  { PseudoVFSUB_VF16_MF4, VFSUB_VF, 0x6, 0x0 }, // 2182
  { PseudoVFSUB_VF16_MF4_MASK, VFSUB_VF, 0x6, 0x0 }, // 2183
  { PseudoVFSUB_VF16_MF2, VFSUB_VF, 0x7, 0x0 }, // 2184
  { PseudoVFSUB_VF16_MF2_MASK, VFSUB_VF, 0x7, 0x0 }, // 2185
  { PseudoVFSUB_VF32_MF2, VFSUB_VF, 0x7, 0x0 }, // 2186
  { PseudoVFSUB_VF32_MF2_MASK, VFSUB_VF, 0x7, 0x0 }, // 2187
  { PseudoVFSUB_VV_M1, VFSUB_VV, 0x0, 0x0 }, // 2188
  { PseudoVFSUB_VV_M1_MASK, VFSUB_VV, 0x0, 0x0 }, // 2189
  { PseudoVFSUB_VV_M2, VFSUB_VV, 0x1, 0x0 }, // 2190
  { PseudoVFSUB_VV_M2_MASK, VFSUB_VV, 0x1, 0x0 }, // 2191
  { PseudoVFSUB_VV_M4, VFSUB_VV, 0x2, 0x0 }, // 2192
  { PseudoVFSUB_VV_M4_MASK, VFSUB_VV, 0x2, 0x0 }, // 2193
  { PseudoVFSUB_VV_M8, VFSUB_VV, 0x3, 0x0 }, // 2194
  { PseudoVFSUB_VV_M8_MASK, VFSUB_VV, 0x3, 0x0 }, // 2195
  { PseudoVFSUB_VV_MF4, VFSUB_VV, 0x6, 0x0 }, // 2196
  { PseudoVFSUB_VV_MF4_MASK, VFSUB_VV, 0x6, 0x0 }, // 2197
  { PseudoVFSUB_VV_MF2, VFSUB_VV, 0x7, 0x0 }, // 2198
  { PseudoVFSUB_VV_MF2_MASK, VFSUB_VV, 0x7, 0x0 }, // 2199
  { PseudoVFWADD_VF16_M1, VFWADD_VF, 0x0, 0x0 }, // 2200
  { PseudoVFWADD_VF16_M1_MASK, VFWADD_VF, 0x0, 0x0 }, // 2201
  { PseudoVFWADD_VF32_M1, VFWADD_VF, 0x0, 0x0 }, // 2202
  { PseudoVFWADD_VF32_M1_MASK, VFWADD_VF, 0x0, 0x0 }, // 2203
  { PseudoVFWADD_VF16_M2, VFWADD_VF, 0x1, 0x0 }, // 2204
  { PseudoVFWADD_VF16_M2_MASK, VFWADD_VF, 0x1, 0x0 }, // 2205
  { PseudoVFWADD_VF32_M2, VFWADD_VF, 0x1, 0x0 }, // 2206
  { PseudoVFWADD_VF32_M2_MASK, VFWADD_VF, 0x1, 0x0 }, // 2207
  { PseudoVFWADD_VF16_M4, VFWADD_VF, 0x2, 0x0 }, // 2208
  { PseudoVFWADD_VF16_M4_MASK, VFWADD_VF, 0x2, 0x0 }, // 2209
  { PseudoVFWADD_VF32_M4, VFWADD_VF, 0x2, 0x0 }, // 2210
  { PseudoVFWADD_VF32_M4_MASK, VFWADD_VF, 0x2, 0x0 }, // 2211
  { PseudoVFWADD_VF16_MF4, VFWADD_VF, 0x6, 0x0 }, // 2212
  { PseudoVFWADD_VF16_MF4_MASK, VFWADD_VF, 0x6, 0x0 }, // 2213
  { PseudoVFWADD_VF16_MF2, VFWADD_VF, 0x7, 0x0 }, // 2214
  { PseudoVFWADD_VF16_MF2_MASK, VFWADD_VF, 0x7, 0x0 }, // 2215
  { PseudoVFWADD_VF32_MF2, VFWADD_VF, 0x7, 0x0 }, // 2216
  { PseudoVFWADD_VF32_MF2_MASK, VFWADD_VF, 0x7, 0x0 }, // 2217
  { PseudoVFWADD_VV_M1, VFWADD_VV, 0x0, 0x0 }, // 2218
  { PseudoVFWADD_VV_M1_MASK, VFWADD_VV, 0x0, 0x0 }, // 2219
  { PseudoVFWADD_VV_M2, VFWADD_VV, 0x1, 0x0 }, // 2220
  { PseudoVFWADD_VV_M2_MASK, VFWADD_VV, 0x1, 0x0 }, // 2221
  { PseudoVFWADD_VV_M4, VFWADD_VV, 0x2, 0x0 }, // 2222
  { PseudoVFWADD_VV_M4_MASK, VFWADD_VV, 0x2, 0x0 }, // 2223
  { PseudoVFWADD_VV_MF4, VFWADD_VV, 0x6, 0x0 }, // 2224
  { PseudoVFWADD_VV_MF4_MASK, VFWADD_VV, 0x6, 0x0 }, // 2225
  { PseudoVFWADD_VV_MF2, VFWADD_VV, 0x7, 0x0 }, // 2226
  { PseudoVFWADD_VV_MF2_MASK, VFWADD_VV, 0x7, 0x0 }, // 2227
  { PseudoVFWADD_WF16_M1, VFWADD_WF, 0x0, 0x0 }, // 2228
  { PseudoVFWADD_WF16_M1_MASK, VFWADD_WF, 0x0, 0x0 }, // 2229
  { PseudoVFWADD_WF32_M1, VFWADD_WF, 0x0, 0x0 }, // 2230
  { PseudoVFWADD_WF32_M1_MASK, VFWADD_WF, 0x0, 0x0 }, // 2231
  { PseudoVFWADD_WF16_M2, VFWADD_WF, 0x1, 0x0 }, // 2232
  { PseudoVFWADD_WF16_M2_MASK, VFWADD_WF, 0x1, 0x0 }, // 2233
  { PseudoVFWADD_WF32_M2, VFWADD_WF, 0x1, 0x0 }, // 2234
  { PseudoVFWADD_WF32_M2_MASK, VFWADD_WF, 0x1, 0x0 }, // 2235
  { PseudoVFWADD_WF16_M4, VFWADD_WF, 0x2, 0x0 }, // 2236
  { PseudoVFWADD_WF16_M4_MASK, VFWADD_WF, 0x2, 0x0 }, // 2237
  { PseudoVFWADD_WF32_M4, VFWADD_WF, 0x2, 0x0 }, // 2238
  { PseudoVFWADD_WF32_M4_MASK, VFWADD_WF, 0x2, 0x0 }, // 2239
  { PseudoVFWADD_WF16_MF4, VFWADD_WF, 0x6, 0x0 }, // 2240
  { PseudoVFWADD_WF16_MF4_MASK, VFWADD_WF, 0x6, 0x0 }, // 2241
  { PseudoVFWADD_WF16_MF2, VFWADD_WF, 0x7, 0x0 }, // 2242
  { PseudoVFWADD_WF16_MF2_MASK, VFWADD_WF, 0x7, 0x0 }, // 2243
  { PseudoVFWADD_WF32_MF2, VFWADD_WF, 0x7, 0x0 }, // 2244
  { PseudoVFWADD_WF32_MF2_MASK, VFWADD_WF, 0x7, 0x0 }, // 2245
  { PseudoVFWADD_WV_M1, VFWADD_WV, 0x0, 0x0 }, // 2246
  { PseudoVFWADD_WV_M1_MASK, VFWADD_WV, 0x0, 0x0 }, // 2247
  { PseudoVFWADD_WV_M1_MASK_TIED, VFWADD_WV, 0x0, 0x0 }, // 2248
  { PseudoVFWADD_WV_M1_TIED, VFWADD_WV, 0x0, 0x0 }, // 2249
  { PseudoVFWADD_WV_M2, VFWADD_WV, 0x1, 0x0 }, // 2250
  { PseudoVFWADD_WV_M2_MASK, VFWADD_WV, 0x1, 0x0 }, // 2251
  { PseudoVFWADD_WV_M2_MASK_TIED, VFWADD_WV, 0x1, 0x0 }, // 2252
  { PseudoVFWADD_WV_M2_TIED, VFWADD_WV, 0x1, 0x0 }, // 2253
  { PseudoVFWADD_WV_M4, VFWADD_WV, 0x2, 0x0 }, // 2254
  { PseudoVFWADD_WV_M4_MASK, VFWADD_WV, 0x2, 0x0 }, // 2255
  { PseudoVFWADD_WV_M4_MASK_TIED, VFWADD_WV, 0x2, 0x0 }, // 2256
  { PseudoVFWADD_WV_M4_TIED, VFWADD_WV, 0x2, 0x0 }, // 2257
  { PseudoVFWADD_WV_MF4, VFWADD_WV, 0x6, 0x0 }, // 2258
  { PseudoVFWADD_WV_MF4_MASK, VFWADD_WV, 0x6, 0x0 }, // 2259
  { PseudoVFWADD_WV_MF4_MASK_TIED, VFWADD_WV, 0x6, 0x0 }, // 2260
  { PseudoVFWADD_WV_MF4_TIED, VFWADD_WV, 0x6, 0x0 }, // 2261
  { PseudoVFWADD_WV_MF2, VFWADD_WV, 0x7, 0x0 }, // 2262
  { PseudoVFWADD_WV_MF2_MASK, VFWADD_WV, 0x7, 0x0 }, // 2263
  { PseudoVFWADD_WV_MF2_MASK_TIED, VFWADD_WV, 0x7, 0x0 }, // 2264
  { PseudoVFWADD_WV_MF2_TIED, VFWADD_WV, 0x7, 0x0 }, // 2265
  { PseudoVFWCVT_F_F_V_M1, VFWCVT_F_F_V, 0x0, 0x0 }, // 2266
  { PseudoVFWCVT_F_F_V_M1_MASK, VFWCVT_F_F_V, 0x0, 0x0 }, // 2267
  { PseudoVFWCVT_F_F_V_M2, VFWCVT_F_F_V, 0x1, 0x0 }, // 2268
  { PseudoVFWCVT_F_F_V_M2_MASK, VFWCVT_F_F_V, 0x1, 0x0 }, // 2269
  { PseudoVFWCVT_F_F_V_M4, VFWCVT_F_F_V, 0x2, 0x0 }, // 2270
  { PseudoVFWCVT_F_F_V_M4_MASK, VFWCVT_F_F_V, 0x2, 0x0 }, // 2271
  { PseudoVFWCVT_F_F_V_MF4, VFWCVT_F_F_V, 0x6, 0x0 }, // 2272
  { PseudoVFWCVT_F_F_V_MF4_MASK, VFWCVT_F_F_V, 0x6, 0x0 }, // 2273
  { PseudoVFWCVT_F_F_V_MF2, VFWCVT_F_F_V, 0x7, 0x0 }, // 2274
  { PseudoVFWCVT_F_F_V_MF2_MASK, VFWCVT_F_F_V, 0x7, 0x0 }, // 2275
  { PseudoVFWCVT_F_XU_V_M1, VFWCVT_F_XU_V, 0x0, 0x0 }, // 2276
  { PseudoVFWCVT_F_XU_V_M1_MASK, VFWCVT_F_XU_V, 0x0, 0x0 }, // 2277
  { PseudoVFWCVT_F_XU_V_M2, VFWCVT_F_XU_V, 0x1, 0x0 }, // 2278
  { PseudoVFWCVT_F_XU_V_M2_MASK, VFWCVT_F_XU_V, 0x1, 0x0 }, // 2279
  { PseudoVFWCVT_F_XU_V_M4, VFWCVT_F_XU_V, 0x2, 0x0 }, // 2280
  { PseudoVFWCVT_F_XU_V_M4_MASK, VFWCVT_F_XU_V, 0x2, 0x0 }, // 2281
  { PseudoVFWCVT_F_XU_V_MF8, VFWCVT_F_XU_V, 0x5, 0x0 }, // 2282
  { PseudoVFWCVT_F_XU_V_MF8_MASK, VFWCVT_F_XU_V, 0x5, 0x0 }, // 2283
  { PseudoVFWCVT_F_XU_V_MF4, VFWCVT_F_XU_V, 0x6, 0x0 }, // 2284
  { PseudoVFWCVT_F_XU_V_MF4_MASK, VFWCVT_F_XU_V, 0x6, 0x0 }, // 2285
  { PseudoVFWCVT_F_XU_V_MF2, VFWCVT_F_XU_V, 0x7, 0x0 }, // 2286
  { PseudoVFWCVT_F_XU_V_MF2_MASK, VFWCVT_F_XU_V, 0x7, 0x0 }, // 2287
  { PseudoVFWCVT_F_X_V_M1, VFWCVT_F_X_V, 0x0, 0x0 }, // 2288
  { PseudoVFWCVT_F_X_V_M1_MASK, VFWCVT_F_X_V, 0x0, 0x0 }, // 2289
  { PseudoVFWCVT_F_X_V_M2, VFWCVT_F_X_V, 0x1, 0x0 }, // 2290
  { PseudoVFWCVT_F_X_V_M2_MASK, VFWCVT_F_X_V, 0x1, 0x0 }, // 2291
  { PseudoVFWCVT_F_X_V_M4, VFWCVT_F_X_V, 0x2, 0x0 }, // 2292
  { PseudoVFWCVT_F_X_V_M4_MASK, VFWCVT_F_X_V, 0x2, 0x0 }, // 2293
  { PseudoVFWCVT_F_X_V_MF8, VFWCVT_F_X_V, 0x5, 0x0 }, // 2294
  { PseudoVFWCVT_F_X_V_MF8_MASK, VFWCVT_F_X_V, 0x5, 0x0 }, // 2295
  { PseudoVFWCVT_F_X_V_MF4, VFWCVT_F_X_V, 0x6, 0x0 }, // 2296
  { PseudoVFWCVT_F_X_V_MF4_MASK, VFWCVT_F_X_V, 0x6, 0x0 }, // 2297
  { PseudoVFWCVT_F_X_V_MF2, VFWCVT_F_X_V, 0x7, 0x0 }, // 2298
  { PseudoVFWCVT_F_X_V_MF2_MASK, VFWCVT_F_X_V, 0x7, 0x0 }, // 2299
  { PseudoVFWCVT_RTZ_XU_F_V_M1, VFWCVT_RTZ_XU_F_V, 0x0, 0x0 }, // 2300
  { PseudoVFWCVT_RTZ_XU_F_V_M1_MASK, VFWCVT_RTZ_XU_F_V, 0x0, 0x0 }, // 2301
  { PseudoVFWCVT_RTZ_XU_F_V_M2, VFWCVT_RTZ_XU_F_V, 0x1, 0x0 }, // 2302
  { PseudoVFWCVT_RTZ_XU_F_V_M2_MASK, VFWCVT_RTZ_XU_F_V, 0x1, 0x0 }, // 2303
  { PseudoVFWCVT_RTZ_XU_F_V_M4, VFWCVT_RTZ_XU_F_V, 0x2, 0x0 }, // 2304
  { PseudoVFWCVT_RTZ_XU_F_V_M4_MASK, VFWCVT_RTZ_XU_F_V, 0x2, 0x0 }, // 2305
  { PseudoVFWCVT_RTZ_XU_F_V_MF4, VFWCVT_RTZ_XU_F_V, 0x6, 0x0 }, // 2306
  { PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK, VFWCVT_RTZ_XU_F_V, 0x6, 0x0 }, // 2307
  { PseudoVFWCVT_RTZ_XU_F_V_MF2, VFWCVT_RTZ_XU_F_V, 0x7, 0x0 }, // 2308
  { PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK, VFWCVT_RTZ_XU_F_V, 0x7, 0x0 }, // 2309
  { PseudoVFWCVT_RTZ_X_F_V_M1, VFWCVT_RTZ_X_F_V, 0x0, 0x0 }, // 2310
  { PseudoVFWCVT_RTZ_X_F_V_M1_MASK, VFWCVT_RTZ_X_F_V, 0x0, 0x0 }, // 2311
  { PseudoVFWCVT_RTZ_X_F_V_M2, VFWCVT_RTZ_X_F_V, 0x1, 0x0 }, // 2312
  { PseudoVFWCVT_RTZ_X_F_V_M2_MASK, VFWCVT_RTZ_X_F_V, 0x1, 0x0 }, // 2313
  { PseudoVFWCVT_RTZ_X_F_V_M4, VFWCVT_RTZ_X_F_V, 0x2, 0x0 }, // 2314
  { PseudoVFWCVT_RTZ_X_F_V_M4_MASK, VFWCVT_RTZ_X_F_V, 0x2, 0x0 }, // 2315
  { PseudoVFWCVT_RTZ_X_F_V_MF4, VFWCVT_RTZ_X_F_V, 0x6, 0x0 }, // 2316
  { PseudoVFWCVT_RTZ_X_F_V_MF4_MASK, VFWCVT_RTZ_X_F_V, 0x6, 0x0 }, // 2317
  { PseudoVFWCVT_RTZ_X_F_V_MF2, VFWCVT_RTZ_X_F_V, 0x7, 0x0 }, // 2318
  { PseudoVFWCVT_RTZ_X_F_V_MF2_MASK, VFWCVT_RTZ_X_F_V, 0x7, 0x0 }, // 2319
  { PseudoVFWCVT_XU_F_V_M1, VFWCVT_XU_F_V, 0x0, 0x0 }, // 2320
  { PseudoVFWCVT_XU_F_V_M1_MASK, VFWCVT_XU_F_V, 0x0, 0x0 }, // 2321
  { PseudoVFWCVT_XU_F_V_M2, VFWCVT_XU_F_V, 0x1, 0x0 }, // 2322
  { PseudoVFWCVT_XU_F_V_M2_MASK, VFWCVT_XU_F_V, 0x1, 0x0 }, // 2323
  { PseudoVFWCVT_XU_F_V_M4, VFWCVT_XU_F_V, 0x2, 0x0 }, // 2324
  { PseudoVFWCVT_XU_F_V_M4_MASK, VFWCVT_XU_F_V, 0x2, 0x0 }, // 2325
  { PseudoVFWCVT_XU_F_V_MF4, VFWCVT_XU_F_V, 0x6, 0x0 }, // 2326
  { PseudoVFWCVT_XU_F_V_MF4_MASK, VFWCVT_XU_F_V, 0x6, 0x0 }, // 2327
  { PseudoVFWCVT_XU_F_V_MF2, VFWCVT_XU_F_V, 0x7, 0x0 }, // 2328
  { PseudoVFWCVT_XU_F_V_MF2_MASK, VFWCVT_XU_F_V, 0x7, 0x0 }, // 2329
  { PseudoVFWCVT_X_F_V_M1, VFWCVT_X_F_V, 0x0, 0x0 }, // 2330
  { PseudoVFWCVT_X_F_V_M1_MASK, VFWCVT_X_F_V, 0x0, 0x0 }, // 2331
  { PseudoVFWCVT_X_F_V_M2, VFWCVT_X_F_V, 0x1, 0x0 }, // 2332
  { PseudoVFWCVT_X_F_V_M2_MASK, VFWCVT_X_F_V, 0x1, 0x0 }, // 2333
  { PseudoVFWCVT_X_F_V_M4, VFWCVT_X_F_V, 0x2, 0x0 }, // 2334
  { PseudoVFWCVT_X_F_V_M4_MASK, VFWCVT_X_F_V, 0x2, 0x0 }, // 2335
  { PseudoVFWCVT_X_F_V_MF4, VFWCVT_X_F_V, 0x6, 0x0 }, // 2336
  { PseudoVFWCVT_X_F_V_MF4_MASK, VFWCVT_X_F_V, 0x6, 0x0 }, // 2337
  { PseudoVFWCVT_X_F_V_MF2, VFWCVT_X_F_V, 0x7, 0x0 }, // 2338
  { PseudoVFWCVT_X_F_V_MF2_MASK, VFWCVT_X_F_V, 0x7, 0x0 }, // 2339
  { PseudoVFWMACC_VF16_M1, VFWMACC_VF, 0x0, 0x0 }, // 2340
  { PseudoVFWMACC_VF16_M1_MASK, VFWMACC_VF, 0x0, 0x0 }, // 2341
  { PseudoVFWMACC_VF32_M1, VFWMACC_VF, 0x0, 0x0 }, // 2342
  { PseudoVFWMACC_VF32_M1_MASK, VFWMACC_VF, 0x0, 0x0 }, // 2343
  { PseudoVFWMACC_VF16_M2, VFWMACC_VF, 0x1, 0x0 }, // 2344
  { PseudoVFWMACC_VF16_M2_MASK, VFWMACC_VF, 0x1, 0x0 }, // 2345
  { PseudoVFWMACC_VF32_M2, VFWMACC_VF, 0x1, 0x0 }, // 2346
  { PseudoVFWMACC_VF32_M2_MASK, VFWMACC_VF, 0x1, 0x0 }, // 2347
  { PseudoVFWMACC_VF16_M4, VFWMACC_VF, 0x2, 0x0 }, // 2348
  { PseudoVFWMACC_VF16_M4_MASK, VFWMACC_VF, 0x2, 0x0 }, // 2349
  { PseudoVFWMACC_VF32_M4, VFWMACC_VF, 0x2, 0x0 }, // 2350
  { PseudoVFWMACC_VF32_M4_MASK, VFWMACC_VF, 0x2, 0x0 }, // 2351
  { PseudoVFWMACC_VF16_MF4, VFWMACC_VF, 0x6, 0x0 }, // 2352
  { PseudoVFWMACC_VF16_MF4_MASK, VFWMACC_VF, 0x6, 0x0 }, // 2353
  { PseudoVFWMACC_VF16_MF2, VFWMACC_VF, 0x7, 0x0 }, // 2354
  { PseudoVFWMACC_VF16_MF2_MASK, VFWMACC_VF, 0x7, 0x0 }, // 2355
  { PseudoVFWMACC_VF32_MF2, VFWMACC_VF, 0x7, 0x0 }, // 2356
  { PseudoVFWMACC_VF32_MF2_MASK, VFWMACC_VF, 0x7, 0x0 }, // 2357
  { PseudoVFWMACC_VV_M1, VFWMACC_VV, 0x0, 0x0 }, // 2358
  { PseudoVFWMACC_VV_M1_MASK, VFWMACC_VV, 0x0, 0x0 }, // 2359
  { PseudoVFWMACC_VV_M2, VFWMACC_VV, 0x1, 0x0 }, // 2360
  { PseudoVFWMACC_VV_M2_MASK, VFWMACC_VV, 0x1, 0x0 }, // 2361
  { PseudoVFWMACC_VV_M4, VFWMACC_VV, 0x2, 0x0 }, // 2362
  { PseudoVFWMACC_VV_M4_MASK, VFWMACC_VV, 0x2, 0x0 }, // 2363
  { PseudoVFWMACC_VV_MF4, VFWMACC_VV, 0x6, 0x0 }, // 2364
  { PseudoVFWMACC_VV_MF4_MASK, VFWMACC_VV, 0x6, 0x0 }, // 2365
  { PseudoVFWMACC_VV_MF2, VFWMACC_VV, 0x7, 0x0 }, // 2366
  { PseudoVFWMACC_VV_MF2_MASK, VFWMACC_VV, 0x7, 0x0 }, // 2367
  { PseudoVFWMSAC_VF16_M1, VFWMSAC_VF, 0x0, 0x0 }, // 2368
  { PseudoVFWMSAC_VF16_M1_MASK, VFWMSAC_VF, 0x0, 0x0 }, // 2369
  { PseudoVFWMSAC_VF32_M1, VFWMSAC_VF, 0x0, 0x0 }, // 2370
  { PseudoVFWMSAC_VF32_M1_MASK, VFWMSAC_VF, 0x0, 0x0 }, // 2371
  { PseudoVFWMSAC_VF16_M2, VFWMSAC_VF, 0x1, 0x0 }, // 2372
  { PseudoVFWMSAC_VF16_M2_MASK, VFWMSAC_VF, 0x1, 0x0 }, // 2373
  { PseudoVFWMSAC_VF32_M2, VFWMSAC_VF, 0x1, 0x0 }, // 2374
  { PseudoVFWMSAC_VF32_M2_MASK, VFWMSAC_VF, 0x1, 0x0 }, // 2375
  { PseudoVFWMSAC_VF16_M4, VFWMSAC_VF, 0x2, 0x0 }, // 2376
  { PseudoVFWMSAC_VF16_M4_MASK, VFWMSAC_VF, 0x2, 0x0 }, // 2377
  { PseudoVFWMSAC_VF32_M4, VFWMSAC_VF, 0x2, 0x0 }, // 2378
  { PseudoVFWMSAC_VF32_M4_MASK, VFWMSAC_VF, 0x2, 0x0 }, // 2379
  { PseudoVFWMSAC_VF16_MF4, VFWMSAC_VF, 0x6, 0x0 }, // 2380
  { PseudoVFWMSAC_VF16_MF4_MASK, VFWMSAC_VF, 0x6, 0x0 }, // 2381
  { PseudoVFWMSAC_VF16_MF2, VFWMSAC_VF, 0x7, 0x0 }, // 2382
  { PseudoVFWMSAC_VF16_MF2_MASK, VFWMSAC_VF, 0x7, 0x0 }, // 2383
  { PseudoVFWMSAC_VF32_MF2, VFWMSAC_VF, 0x7, 0x0 }, // 2384
  { PseudoVFWMSAC_VF32_MF2_MASK, VFWMSAC_VF, 0x7, 0x0 }, // 2385
  { PseudoVFWMSAC_VV_M1, VFWMSAC_VV, 0x0, 0x0 }, // 2386
  { PseudoVFWMSAC_VV_M1_MASK, VFWMSAC_VV, 0x0, 0x0 }, // 2387
  { PseudoVFWMSAC_VV_M2, VFWMSAC_VV, 0x1, 0x0 }, // 2388
  { PseudoVFWMSAC_VV_M2_MASK, VFWMSAC_VV, 0x1, 0x0 }, // 2389
  { PseudoVFWMSAC_VV_M4, VFWMSAC_VV, 0x2, 0x0 }, // 2390
  { PseudoVFWMSAC_VV_M4_MASK, VFWMSAC_VV, 0x2, 0x0 }, // 2391
  { PseudoVFWMSAC_VV_MF4, VFWMSAC_VV, 0x6, 0x0 }, // 2392
  { PseudoVFWMSAC_VV_MF4_MASK, VFWMSAC_VV, 0x6, 0x0 }, // 2393
  { PseudoVFWMSAC_VV_MF2, VFWMSAC_VV, 0x7, 0x0 }, // 2394
  { PseudoVFWMSAC_VV_MF2_MASK, VFWMSAC_VV, 0x7, 0x0 }, // 2395
  { PseudoVFWMUL_VF16_M1, VFWMUL_VF, 0x0, 0x0 }, // 2396
  { PseudoVFWMUL_VF16_M1_MASK, VFWMUL_VF, 0x0, 0x0 }, // 2397
  { PseudoVFWMUL_VF32_M1, VFWMUL_VF, 0x0, 0x0 }, // 2398
  { PseudoVFWMUL_VF32_M1_MASK, VFWMUL_VF, 0x0, 0x0 }, // 2399
  { PseudoVFWMUL_VF16_M2, VFWMUL_VF, 0x1, 0x0 }, // 2400
  { PseudoVFWMUL_VF16_M2_MASK, VFWMUL_VF, 0x1, 0x0 }, // 2401
  { PseudoVFWMUL_VF32_M2, VFWMUL_VF, 0x1, 0x0 }, // 2402
  { PseudoVFWMUL_VF32_M2_MASK, VFWMUL_VF, 0x1, 0x0 }, // 2403
  { PseudoVFWMUL_VF16_M4, VFWMUL_VF, 0x2, 0x0 }, // 2404
  { PseudoVFWMUL_VF16_M4_MASK, VFWMUL_VF, 0x2, 0x0 }, // 2405
  { PseudoVFWMUL_VF32_M4, VFWMUL_VF, 0x2, 0x0 }, // 2406
  { PseudoVFWMUL_VF32_M4_MASK, VFWMUL_VF, 0x2, 0x0 }, // 2407
  { PseudoVFWMUL_VF16_MF4, VFWMUL_VF, 0x6, 0x0 }, // 2408
  { PseudoVFWMUL_VF16_MF4_MASK, VFWMUL_VF, 0x6, 0x0 }, // 2409
  { PseudoVFWMUL_VF16_MF2, VFWMUL_VF, 0x7, 0x0 }, // 2410
  { PseudoVFWMUL_VF16_MF2_MASK, VFWMUL_VF, 0x7, 0x0 }, // 2411
  { PseudoVFWMUL_VF32_MF2, VFWMUL_VF, 0x7, 0x0 }, // 2412
  { PseudoVFWMUL_VF32_MF2_MASK, VFWMUL_VF, 0x7, 0x0 }, // 2413
  { PseudoVFWMUL_VV_M1, VFWMUL_VV, 0x0, 0x0 }, // 2414
  { PseudoVFWMUL_VV_M1_MASK, VFWMUL_VV, 0x0, 0x0 }, // 2415
  { PseudoVFWMUL_VV_M2, VFWMUL_VV, 0x1, 0x0 }, // 2416
  { PseudoVFWMUL_VV_M2_MASK, VFWMUL_VV, 0x1, 0x0 }, // 2417
  { PseudoVFWMUL_VV_M4, VFWMUL_VV, 0x2, 0x0 }, // 2418
  { PseudoVFWMUL_VV_M4_MASK, VFWMUL_VV, 0x2, 0x0 }, // 2419
  { PseudoVFWMUL_VV_MF4, VFWMUL_VV, 0x6, 0x0 }, // 2420
  { PseudoVFWMUL_VV_MF4_MASK, VFWMUL_VV, 0x6, 0x0 }, // 2421
  { PseudoVFWMUL_VV_MF2, VFWMUL_VV, 0x7, 0x0 }, // 2422
  { PseudoVFWMUL_VV_MF2_MASK, VFWMUL_VV, 0x7, 0x0 }, // 2423
  { PseudoVFWNMACC_VF16_M1, VFWNMACC_VF, 0x0, 0x0 }, // 2424
  { PseudoVFWNMACC_VF16_M1_MASK, VFWNMACC_VF, 0x0, 0x0 }, // 2425
  { PseudoVFWNMACC_VF32_M1, VFWNMACC_VF, 0x0, 0x0 }, // 2426
  { PseudoVFWNMACC_VF32_M1_MASK, VFWNMACC_VF, 0x0, 0x0 }, // 2427
  { PseudoVFWNMACC_VF16_M2, VFWNMACC_VF, 0x1, 0x0 }, // 2428
  { PseudoVFWNMACC_VF16_M2_MASK, VFWNMACC_VF, 0x1, 0x0 }, // 2429
  { PseudoVFWNMACC_VF32_M2, VFWNMACC_VF, 0x1, 0x0 }, // 2430
  { PseudoVFWNMACC_VF32_M2_MASK, VFWNMACC_VF, 0x1, 0x0 }, // 2431
  { PseudoVFWNMACC_VF16_M4, VFWNMACC_VF, 0x2, 0x0 }, // 2432
  { PseudoVFWNMACC_VF16_M4_MASK, VFWNMACC_VF, 0x2, 0x0 }, // 2433
  { PseudoVFWNMACC_VF32_M4, VFWNMACC_VF, 0x2, 0x0 }, // 2434
  { PseudoVFWNMACC_VF32_M4_MASK, VFWNMACC_VF, 0x2, 0x0 }, // 2435
  { PseudoVFWNMACC_VF16_MF4, VFWNMACC_VF, 0x6, 0x0 }, // 2436
  { PseudoVFWNMACC_VF16_MF4_MASK, VFWNMACC_VF, 0x6, 0x0 }, // 2437
  { PseudoVFWNMACC_VF16_MF2, VFWNMACC_VF, 0x7, 0x0 }, // 2438
  { PseudoVFWNMACC_VF16_MF2_MASK, VFWNMACC_VF, 0x7, 0x0 }, // 2439
  { PseudoVFWNMACC_VF32_MF2, VFWNMACC_VF, 0x7, 0x0 }, // 2440
  { PseudoVFWNMACC_VF32_MF2_MASK, VFWNMACC_VF, 0x7, 0x0 }, // 2441
  { PseudoVFWNMACC_VV_M1, VFWNMACC_VV, 0x0, 0x0 }, // 2442
  { PseudoVFWNMACC_VV_M1_MASK, VFWNMACC_VV, 0x0, 0x0 }, // 2443
  { PseudoVFWNMACC_VV_M2, VFWNMACC_VV, 0x1, 0x0 }, // 2444
  { PseudoVFWNMACC_VV_M2_MASK, VFWNMACC_VV, 0x1, 0x0 }, // 2445
  { PseudoVFWNMACC_VV_M4, VFWNMACC_VV, 0x2, 0x0 }, // 2446
  { PseudoVFWNMACC_VV_M4_MASK, VFWNMACC_VV, 0x2, 0x0 }, // 2447
  { PseudoVFWNMACC_VV_MF4, VFWNMACC_VV, 0x6, 0x0 }, // 2448
  { PseudoVFWNMACC_VV_MF4_MASK, VFWNMACC_VV, 0x6, 0x0 }, // 2449
  { PseudoVFWNMACC_VV_MF2, VFWNMACC_VV, 0x7, 0x0 }, // 2450
  { PseudoVFWNMACC_VV_MF2_MASK, VFWNMACC_VV, 0x7, 0x0 }, // 2451
  { PseudoVFWNMSAC_VF16_M1, VFWNMSAC_VF, 0x0, 0x0 }, // 2452
  { PseudoVFWNMSAC_VF16_M1_MASK, VFWNMSAC_VF, 0x0, 0x0 }, // 2453
  { PseudoVFWNMSAC_VF32_M1, VFWNMSAC_VF, 0x0, 0x0 }, // 2454
  { PseudoVFWNMSAC_VF32_M1_MASK, VFWNMSAC_VF, 0x0, 0x0 }, // 2455
  { PseudoVFWNMSAC_VF16_M2, VFWNMSAC_VF, 0x1, 0x0 }, // 2456
  { PseudoVFWNMSAC_VF16_M2_MASK, VFWNMSAC_VF, 0x1, 0x0 }, // 2457
  { PseudoVFWNMSAC_VF32_M2, VFWNMSAC_VF, 0x1, 0x0 }, // 2458
  { PseudoVFWNMSAC_VF32_M2_MASK, VFWNMSAC_VF, 0x1, 0x0 }, // 2459
  { PseudoVFWNMSAC_VF16_M4, VFWNMSAC_VF, 0x2, 0x0 }, // 2460
  { PseudoVFWNMSAC_VF16_M4_MASK, VFWNMSAC_VF, 0x2, 0x0 }, // 2461
  { PseudoVFWNMSAC_VF32_M4, VFWNMSAC_VF, 0x2, 0x0 }, // 2462
  { PseudoVFWNMSAC_VF32_M4_MASK, VFWNMSAC_VF, 0x2, 0x0 }, // 2463
  { PseudoVFWNMSAC_VF16_MF4, VFWNMSAC_VF, 0x6, 0x0 }, // 2464
  { PseudoVFWNMSAC_VF16_MF4_MASK, VFWNMSAC_VF, 0x6, 0x0 }, // 2465
  { PseudoVFWNMSAC_VF16_MF2, VFWNMSAC_VF, 0x7, 0x0 }, // 2466
  { PseudoVFWNMSAC_VF16_MF2_MASK, VFWNMSAC_VF, 0x7, 0x0 }, // 2467
  { PseudoVFWNMSAC_VF32_MF2, VFWNMSAC_VF, 0x7, 0x0 }, // 2468
  { PseudoVFWNMSAC_VF32_MF2_MASK, VFWNMSAC_VF, 0x7, 0x0 }, // 2469
  { PseudoVFWNMSAC_VV_M1, VFWNMSAC_VV, 0x0, 0x0 }, // 2470
  { PseudoVFWNMSAC_VV_M1_MASK, VFWNMSAC_VV, 0x0, 0x0 }, // 2471
  { PseudoVFWNMSAC_VV_M2, VFWNMSAC_VV, 0x1, 0x0 }, // 2472
  { PseudoVFWNMSAC_VV_M2_MASK, VFWNMSAC_VV, 0x1, 0x0 }, // 2473
  { PseudoVFWNMSAC_VV_M4, VFWNMSAC_VV, 0x2, 0x0 }, // 2474
  { PseudoVFWNMSAC_VV_M4_MASK, VFWNMSAC_VV, 0x2, 0x0 }, // 2475
  { PseudoVFWNMSAC_VV_MF4, VFWNMSAC_VV, 0x6, 0x0 }, // 2476
  { PseudoVFWNMSAC_VV_MF4_MASK, VFWNMSAC_VV, 0x6, 0x0 }, // 2477
  { PseudoVFWNMSAC_VV_MF2, VFWNMSAC_VV, 0x7, 0x0 }, // 2478
  { PseudoVFWNMSAC_VV_MF2_MASK, VFWNMSAC_VV, 0x7, 0x0 }, // 2479
  { PseudoVFWREDOSUM_VS_M1_E16, VFWREDOSUM_VS, 0x0, 0x0 }, // 2480
  { PseudoVFWREDOSUM_VS_M1_E16_MASK, VFWREDOSUM_VS, 0x0, 0x0 }, // 2481
  { PseudoVFWREDOSUM_VS_M1_E32, VFWREDOSUM_VS, 0x0, 0x0 }, // 2482
  { PseudoVFWREDOSUM_VS_M1_E32_MASK, VFWREDOSUM_VS, 0x0, 0x0 }, // 2483
  { PseudoVFWREDOSUM_VS_M2_E16, VFWREDOSUM_VS, 0x1, 0x0 }, // 2484
  { PseudoVFWREDOSUM_VS_M2_E16_MASK, VFWREDOSUM_VS, 0x1, 0x0 }, // 2485
  { PseudoVFWREDOSUM_VS_M2_E32, VFWREDOSUM_VS, 0x1, 0x0 }, // 2486
  { PseudoVFWREDOSUM_VS_M2_E32_MASK, VFWREDOSUM_VS, 0x1, 0x0 }, // 2487
  { PseudoVFWREDOSUM_VS_M4_E16, VFWREDOSUM_VS, 0x2, 0x0 }, // 2488
  { PseudoVFWREDOSUM_VS_M4_E16_MASK, VFWREDOSUM_VS, 0x2, 0x0 }, // 2489
  { PseudoVFWREDOSUM_VS_M4_E32, VFWREDOSUM_VS, 0x2, 0x0 }, // 2490
  { PseudoVFWREDOSUM_VS_M4_E32_MASK, VFWREDOSUM_VS, 0x2, 0x0 }, // 2491
  { PseudoVFWREDOSUM_VS_M8_E16, VFWREDOSUM_VS, 0x3, 0x0 }, // 2492
  { PseudoVFWREDOSUM_VS_M8_E16_MASK, VFWREDOSUM_VS, 0x3, 0x0 }, // 2493
  { PseudoVFWREDOSUM_VS_M8_E32, VFWREDOSUM_VS, 0x3, 0x0 }, // 2494
  { PseudoVFWREDOSUM_VS_M8_E32_MASK, VFWREDOSUM_VS, 0x3, 0x0 }, // 2495
  { PseudoVFWREDOSUM_VS_MF4_E16, VFWREDOSUM_VS, 0x6, 0x0 }, // 2496
  { PseudoVFWREDOSUM_VS_MF4_E16_MASK, VFWREDOSUM_VS, 0x6, 0x0 }, // 2497
  { PseudoVFWREDOSUM_VS_MF2_E16, VFWREDOSUM_VS, 0x7, 0x0 }, // 2498
  { PseudoVFWREDOSUM_VS_MF2_E16_MASK, VFWREDOSUM_VS, 0x7, 0x0 }, // 2499
  { PseudoVFWREDOSUM_VS_MF2_E32, VFWREDOSUM_VS, 0x7, 0x0 }, // 2500
  { PseudoVFWREDOSUM_VS_MF2_E32_MASK, VFWREDOSUM_VS, 0x7, 0x0 }, // 2501
  { PseudoVFWREDUSUM_VS_M1_E16, VFWREDUSUM_VS, 0x0, 0x0 }, // 2502
  { PseudoVFWREDUSUM_VS_M1_E16_MASK, VFWREDUSUM_VS, 0x0, 0x0 }, // 2503
  { PseudoVFWREDUSUM_VS_M1_E32, VFWREDUSUM_VS, 0x0, 0x0 }, // 2504
  { PseudoVFWREDUSUM_VS_M1_E32_MASK, VFWREDUSUM_VS, 0x0, 0x0 }, // 2505
  { PseudoVFWREDUSUM_VS_M2_E16, VFWREDUSUM_VS, 0x1, 0x0 }, // 2506
  { PseudoVFWREDUSUM_VS_M2_E16_MASK, VFWREDUSUM_VS, 0x1, 0x0 }, // 2507
  { PseudoVFWREDUSUM_VS_M2_E32, VFWREDUSUM_VS, 0x1, 0x0 }, // 2508
  { PseudoVFWREDUSUM_VS_M2_E32_MASK, VFWREDUSUM_VS, 0x1, 0x0 }, // 2509
  { PseudoVFWREDUSUM_VS_M4_E16, VFWREDUSUM_VS, 0x2, 0x0 }, // 2510
  { PseudoVFWREDUSUM_VS_M4_E16_MASK, VFWREDUSUM_VS, 0x2, 0x0 }, // 2511
  { PseudoVFWREDUSUM_VS_M4_E32, VFWREDUSUM_VS, 0x2, 0x0 }, // 2512
  { PseudoVFWREDUSUM_VS_M4_E32_MASK, VFWREDUSUM_VS, 0x2, 0x0 }, // 2513
  { PseudoVFWREDUSUM_VS_M8_E16, VFWREDUSUM_VS, 0x3, 0x0 }, // 2514
  { PseudoVFWREDUSUM_VS_M8_E16_MASK, VFWREDUSUM_VS, 0x3, 0x0 }, // 2515
  { PseudoVFWREDUSUM_VS_M8_E32, VFWREDUSUM_VS, 0x3, 0x0 }, // 2516
  { PseudoVFWREDUSUM_VS_M8_E32_MASK, VFWREDUSUM_VS, 0x3, 0x0 }, // 2517
  { PseudoVFWREDUSUM_VS_MF4_E16, VFWREDUSUM_VS, 0x6, 0x0 }, // 2518
  { PseudoVFWREDUSUM_VS_MF4_E16_MASK, VFWREDUSUM_VS, 0x6, 0x0 }, // 2519
  { PseudoVFWREDUSUM_VS_MF2_E16, VFWREDUSUM_VS, 0x7, 0x0 }, // 2520
  { PseudoVFWREDUSUM_VS_MF2_E16_MASK, VFWREDUSUM_VS, 0x7, 0x0 }, // 2521
  { PseudoVFWREDUSUM_VS_MF2_E32, VFWREDUSUM_VS, 0x7, 0x0 }, // 2522
  { PseudoVFWREDUSUM_VS_MF2_E32_MASK, VFWREDUSUM_VS, 0x7, 0x0 }, // 2523
  { PseudoVFWSUB_VF16_M1, VFWSUB_VF, 0x0, 0x0 }, // 2524
  { PseudoVFWSUB_VF16_M1_MASK, VFWSUB_VF, 0x0, 0x0 }, // 2525
  { PseudoVFWSUB_VF32_M1, VFWSUB_VF, 0x0, 0x0 }, // 2526
  { PseudoVFWSUB_VF32_M1_MASK, VFWSUB_VF, 0x0, 0x0 }, // 2527
  { PseudoVFWSUB_VF16_M2, VFWSUB_VF, 0x1, 0x0 }, // 2528
  { PseudoVFWSUB_VF16_M2_MASK, VFWSUB_VF, 0x1, 0x0 }, // 2529
  { PseudoVFWSUB_VF32_M2, VFWSUB_VF, 0x1, 0x0 }, // 2530
  { PseudoVFWSUB_VF32_M2_MASK, VFWSUB_VF, 0x1, 0x0 }, // 2531
  { PseudoVFWSUB_VF16_M4, VFWSUB_VF, 0x2, 0x0 }, // 2532
  { PseudoVFWSUB_VF16_M4_MASK, VFWSUB_VF, 0x2, 0x0 }, // 2533
  { PseudoVFWSUB_VF32_M4, VFWSUB_VF, 0x2, 0x0 }, // 2534
  { PseudoVFWSUB_VF32_M4_MASK, VFWSUB_VF, 0x2, 0x0 }, // 2535
  { PseudoVFWSUB_VF16_MF4, VFWSUB_VF, 0x6, 0x0 }, // 2536
  { PseudoVFWSUB_VF16_MF4_MASK, VFWSUB_VF, 0x6, 0x0 }, // 2537
  { PseudoVFWSUB_VF16_MF2, VFWSUB_VF, 0x7, 0x0 }, // 2538
  { PseudoVFWSUB_VF16_MF2_MASK, VFWSUB_VF, 0x7, 0x0 }, // 2539
  { PseudoVFWSUB_VF32_MF2, VFWSUB_VF, 0x7, 0x0 }, // 2540
  { PseudoVFWSUB_VF32_MF2_MASK, VFWSUB_VF, 0x7, 0x0 }, // 2541
  { PseudoVFWSUB_VV_M1, VFWSUB_VV, 0x0, 0x0 }, // 2542
  { PseudoVFWSUB_VV_M1_MASK, VFWSUB_VV, 0x0, 0x0 }, // 2543
  { PseudoVFWSUB_VV_M2, VFWSUB_VV, 0x1, 0x0 }, // 2544
  { PseudoVFWSUB_VV_M2_MASK, VFWSUB_VV, 0x1, 0x0 }, // 2545
  { PseudoVFWSUB_VV_M4, VFWSUB_VV, 0x2, 0x0 }, // 2546
  { PseudoVFWSUB_VV_M4_MASK, VFWSUB_VV, 0x2, 0x0 }, // 2547
  { PseudoVFWSUB_VV_MF4, VFWSUB_VV, 0x6, 0x0 }, // 2548
  { PseudoVFWSUB_VV_MF4_MASK, VFWSUB_VV, 0x6, 0x0 }, // 2549
  { PseudoVFWSUB_VV_MF2, VFWSUB_VV, 0x7, 0x0 }, // 2550
  { PseudoVFWSUB_VV_MF2_MASK, VFWSUB_VV, 0x7, 0x0 }, // 2551
  { PseudoVFWSUB_WF16_M1, VFWSUB_WF, 0x0, 0x0 }, // 2552
  { PseudoVFWSUB_WF16_M1_MASK, VFWSUB_WF, 0x0, 0x0 }, // 2553
  { PseudoVFWSUB_WF32_M1, VFWSUB_WF, 0x0, 0x0 }, // 2554
  { PseudoVFWSUB_WF32_M1_MASK, VFWSUB_WF, 0x0, 0x0 }, // 2555
  { PseudoVFWSUB_WF16_M2, VFWSUB_WF, 0x1, 0x0 }, // 2556
  { PseudoVFWSUB_WF16_M2_MASK, VFWSUB_WF, 0x1, 0x0 }, // 2557
  { PseudoVFWSUB_WF32_M2, VFWSUB_WF, 0x1, 0x0 }, // 2558
  { PseudoVFWSUB_WF32_M2_MASK, VFWSUB_WF, 0x1, 0x0 }, // 2559
  { PseudoVFWSUB_WF16_M4, VFWSUB_WF, 0x2, 0x0 }, // 2560
  { PseudoVFWSUB_WF16_M4_MASK, VFWSUB_WF, 0x2, 0x0 }, // 2561
  { PseudoVFWSUB_WF32_M4, VFWSUB_WF, 0x2, 0x0 }, // 2562
  { PseudoVFWSUB_WF32_M4_MASK, VFWSUB_WF, 0x2, 0x0 }, // 2563
  { PseudoVFWSUB_WF16_MF4, VFWSUB_WF, 0x6, 0x0 }, // 2564
  { PseudoVFWSUB_WF16_MF4_MASK, VFWSUB_WF, 0x6, 0x0 }, // 2565
  { PseudoVFWSUB_WF16_MF2, VFWSUB_WF, 0x7, 0x0 }, // 2566
  { PseudoVFWSUB_WF16_MF2_MASK, VFWSUB_WF, 0x7, 0x0 }, // 2567
  { PseudoVFWSUB_WF32_MF2, VFWSUB_WF, 0x7, 0x0 }, // 2568
  { PseudoVFWSUB_WF32_MF2_MASK, VFWSUB_WF, 0x7, 0x0 }, // 2569
  { PseudoVFWSUB_WV_M1, VFWSUB_WV, 0x0, 0x0 }, // 2570
  { PseudoVFWSUB_WV_M1_MASK, VFWSUB_WV, 0x0, 0x0 }, // 2571
  { PseudoVFWSUB_WV_M1_MASK_TIED, VFWSUB_WV, 0x0, 0x0 }, // 2572
  { PseudoVFWSUB_WV_M1_TIED, VFWSUB_WV, 0x0, 0x0 }, // 2573
  { PseudoVFWSUB_WV_M2, VFWSUB_WV, 0x1, 0x0 }, // 2574
  { PseudoVFWSUB_WV_M2_MASK, VFWSUB_WV, 0x1, 0x0 }, // 2575
  { PseudoVFWSUB_WV_M2_MASK_TIED, VFWSUB_WV, 0x1, 0x0 }, // 2576
  { PseudoVFWSUB_WV_M2_TIED, VFWSUB_WV, 0x1, 0x0 }, // 2577
  { PseudoVFWSUB_WV_M4, VFWSUB_WV, 0x2, 0x0 }, // 2578
  { PseudoVFWSUB_WV_M4_MASK, VFWSUB_WV, 0x2, 0x0 }, // 2579
  { PseudoVFWSUB_WV_M4_MASK_TIED, VFWSUB_WV, 0x2, 0x0 }, // 2580
  { PseudoVFWSUB_WV_M4_TIED, VFWSUB_WV, 0x2, 0x0 }, // 2581
  { PseudoVFWSUB_WV_MF4, VFWSUB_WV, 0x6, 0x0 }, // 2582
  { PseudoVFWSUB_WV_MF4_MASK, VFWSUB_WV, 0x6, 0x0 }, // 2583
  { PseudoVFWSUB_WV_MF4_MASK_TIED, VFWSUB_WV, 0x6, 0x0 }, // 2584
  { PseudoVFWSUB_WV_MF4_TIED, VFWSUB_WV, 0x6, 0x0 }, // 2585
  { PseudoVFWSUB_WV_MF2, VFWSUB_WV, 0x7, 0x0 }, // 2586
  { PseudoVFWSUB_WV_MF2_MASK, VFWSUB_WV, 0x7, 0x0 }, // 2587
  { PseudoVFWSUB_WV_MF2_MASK_TIED, VFWSUB_WV, 0x7, 0x0 }, // 2588
  { PseudoVFWSUB_WV_MF2_TIED, VFWSUB_WV, 0x7, 0x0 }, // 2589
  { PseudoVID_V_M1, VID_V, 0x0, 0x0 }, // 2590
  { PseudoVID_V_M1_MASK, VID_V, 0x0, 0x0 }, // 2591
  { PseudoVID_V_M2, VID_V, 0x1, 0x0 }, // 2592
  { PseudoVID_V_M2_MASK, VID_V, 0x1, 0x0 }, // 2593
  { PseudoVID_V_M4, VID_V, 0x2, 0x0 }, // 2594
  { PseudoVID_V_M4_MASK, VID_V, 0x2, 0x0 }, // 2595
  { PseudoVID_V_M8, VID_V, 0x3, 0x0 }, // 2596
  { PseudoVID_V_M8_MASK, VID_V, 0x3, 0x0 }, // 2597
  { PseudoVID_V_MF8, VID_V, 0x5, 0x0 }, // 2598
  { PseudoVID_V_MF8_MASK, VID_V, 0x5, 0x0 }, // 2599
  { PseudoVID_V_MF4, VID_V, 0x6, 0x0 }, // 2600
  { PseudoVID_V_MF4_MASK, VID_V, 0x6, 0x0 }, // 2601
  { PseudoVID_V_MF2, VID_V, 0x7, 0x0 }, // 2602
  { PseudoVID_V_MF2_MASK, VID_V, 0x7, 0x0 }, // 2603
  { PseudoVIOTA_M_M1, VIOTA_M, 0x0, 0x0 }, // 2604
  { PseudoVIOTA_M_M1_MASK, VIOTA_M, 0x0, 0x0 }, // 2605
  { PseudoVIOTA_M_M2, VIOTA_M, 0x1, 0x0 }, // 2606
  { PseudoVIOTA_M_M2_MASK, VIOTA_M, 0x1, 0x0 }, // 2607
  { PseudoVIOTA_M_M4, VIOTA_M, 0x2, 0x0 }, // 2608
  { PseudoVIOTA_M_M4_MASK, VIOTA_M, 0x2, 0x0 }, // 2609
  { PseudoVIOTA_M_M8, VIOTA_M, 0x3, 0x0 }, // 2610
  { PseudoVIOTA_M_M8_MASK, VIOTA_M, 0x3, 0x0 }, // 2611
  { PseudoVIOTA_M_MF8, VIOTA_M, 0x5, 0x0 }, // 2612
  { PseudoVIOTA_M_MF8_MASK, VIOTA_M, 0x5, 0x0 }, // 2613
  { PseudoVIOTA_M_MF4, VIOTA_M, 0x6, 0x0 }, // 2614
  { PseudoVIOTA_M_MF4_MASK, VIOTA_M, 0x6, 0x0 }, // 2615
  { PseudoVIOTA_M_MF2, VIOTA_M, 0x7, 0x0 }, // 2616
  { PseudoVIOTA_M_MF2_MASK, VIOTA_M, 0x7, 0x0 }, // 2617
  { PseudoVLE16FF_V_M1, VLE16FF_V, 0x0, 0x10 }, // 2618
  { PseudoVLE16FF_V_M1_MASK, VLE16FF_V, 0x0, 0x10 }, // 2619
  { PseudoVLE16FF_V_M2, VLE16FF_V, 0x1, 0x10 }, // 2620
  { PseudoVLE16FF_V_M2_MASK, VLE16FF_V, 0x1, 0x10 }, // 2621
  { PseudoVLE16FF_V_M4, VLE16FF_V, 0x2, 0x10 }, // 2622
  { PseudoVLE16FF_V_M4_MASK, VLE16FF_V, 0x2, 0x10 }, // 2623
  { PseudoVLE16FF_V_M8, VLE16FF_V, 0x3, 0x10 }, // 2624
  { PseudoVLE16FF_V_M8_MASK, VLE16FF_V, 0x3, 0x10 }, // 2625
  { PseudoVLE16FF_V_MF4, VLE16FF_V, 0x6, 0x10 }, // 2626
  { PseudoVLE16FF_V_MF4_MASK, VLE16FF_V, 0x6, 0x10 }, // 2627
  { PseudoVLE16FF_V_MF2, VLE16FF_V, 0x7, 0x10 }, // 2628
  { PseudoVLE16FF_V_MF2_MASK, VLE16FF_V, 0x7, 0x10 }, // 2629
  { PseudoVLE16_V_M1, VLE16_V, 0x0, 0x10 }, // 2630
  { PseudoVLE16_V_M1_MASK, VLE16_V, 0x0, 0x10 }, // 2631
  { PseudoVLE16_V_M2, VLE16_V, 0x1, 0x10 }, // 2632
  { PseudoVLE16_V_M2_MASK, VLE16_V, 0x1, 0x10 }, // 2633
  { PseudoVLE16_V_M4, VLE16_V, 0x2, 0x10 }, // 2634
  { PseudoVLE16_V_M4_MASK, VLE16_V, 0x2, 0x10 }, // 2635
  { PseudoVLE16_V_M8, VLE16_V, 0x3, 0x10 }, // 2636
  { PseudoVLE16_V_M8_MASK, VLE16_V, 0x3, 0x10 }, // 2637
  { PseudoVLE16_V_MF4, VLE16_V, 0x6, 0x10 }, // 2638
  { PseudoVLE16_V_MF4_MASK, VLE16_V, 0x6, 0x10 }, // 2639
  { PseudoVLE16_V_MF2, VLE16_V, 0x7, 0x10 }, // 2640
  { PseudoVLE16_V_MF2_MASK, VLE16_V, 0x7, 0x10 }, // 2641
  { PseudoVLE32FF_V_M1, VLE32FF_V, 0x0, 0x20 }, // 2642
  { PseudoVLE32FF_V_M1_MASK, VLE32FF_V, 0x0, 0x20 }, // 2643
  { PseudoVLE32FF_V_M2, VLE32FF_V, 0x1, 0x20 }, // 2644
  { PseudoVLE32FF_V_M2_MASK, VLE32FF_V, 0x1, 0x20 }, // 2645
  { PseudoVLE32FF_V_M4, VLE32FF_V, 0x2, 0x20 }, // 2646
  { PseudoVLE32FF_V_M4_MASK, VLE32FF_V, 0x2, 0x20 }, // 2647
  { PseudoVLE32FF_V_M8, VLE32FF_V, 0x3, 0x20 }, // 2648
  { PseudoVLE32FF_V_M8_MASK, VLE32FF_V, 0x3, 0x20 }, // 2649
  { PseudoVLE32FF_V_MF2, VLE32FF_V, 0x7, 0x20 }, // 2650
  { PseudoVLE32FF_V_MF2_MASK, VLE32FF_V, 0x7, 0x20 }, // 2651
  { PseudoVLE32_V_M1, VLE32_V, 0x0, 0x20 }, // 2652
  { PseudoVLE32_V_M1_MASK, VLE32_V, 0x0, 0x20 }, // 2653
  { PseudoVLE32_V_M2, VLE32_V, 0x1, 0x20 }, // 2654
  { PseudoVLE32_V_M2_MASK, VLE32_V, 0x1, 0x20 }, // 2655
  { PseudoVLE32_V_M4, VLE32_V, 0x2, 0x20 }, // 2656
  { PseudoVLE32_V_M4_MASK, VLE32_V, 0x2, 0x20 }, // 2657
  { PseudoVLE32_V_M8, VLE32_V, 0x3, 0x20 }, // 2658
  { PseudoVLE32_V_M8_MASK, VLE32_V, 0x3, 0x20 }, // 2659
  { PseudoVLE32_V_MF2, VLE32_V, 0x7, 0x20 }, // 2660
  { PseudoVLE32_V_MF2_MASK, VLE32_V, 0x7, 0x20 }, // 2661
  { PseudoVLE64FF_V_M1, VLE64FF_V, 0x0, 0x40 }, // 2662
  { PseudoVLE64FF_V_M1_MASK, VLE64FF_V, 0x0, 0x40 }, // 2663
  { PseudoVLE64FF_V_M2, VLE64FF_V, 0x1, 0x40 }, // 2664
  { PseudoVLE64FF_V_M2_MASK, VLE64FF_V, 0x1, 0x40 }, // 2665
  { PseudoVLE64FF_V_M4, VLE64FF_V, 0x2, 0x40 }, // 2666
  { PseudoVLE64FF_V_M4_MASK, VLE64FF_V, 0x2, 0x40 }, // 2667
  { PseudoVLE64FF_V_M8, VLE64FF_V, 0x3, 0x40 }, // 2668
  { PseudoVLE64FF_V_M8_MASK, VLE64FF_V, 0x3, 0x40 }, // 2669
  { PseudoVLE64_V_M1, VLE64_V, 0x0, 0x40 }, // 2670
  { PseudoVLE64_V_M1_MASK, VLE64_V, 0x0, 0x40 }, // 2671
  { PseudoVLE64_V_M2, VLE64_V, 0x1, 0x40 }, // 2672
  { PseudoVLE64_V_M2_MASK, VLE64_V, 0x1, 0x40 }, // 2673
  { PseudoVLE64_V_M4, VLE64_V, 0x2, 0x40 }, // 2674
  { PseudoVLE64_V_M4_MASK, VLE64_V, 0x2, 0x40 }, // 2675
  { PseudoVLE64_V_M8, VLE64_V, 0x3, 0x40 }, // 2676
  { PseudoVLE64_V_M8_MASK, VLE64_V, 0x3, 0x40 }, // 2677
  { PseudoVLE8FF_V_M1, VLE8FF_V, 0x0, 0x8 }, // 2678
  { PseudoVLE8FF_V_M1_MASK, VLE8FF_V, 0x0, 0x8 }, // 2679
  { PseudoVLE8FF_V_M2, VLE8FF_V, 0x1, 0x8 }, // 2680
  { PseudoVLE8FF_V_M2_MASK, VLE8FF_V, 0x1, 0x8 }, // 2681
  { PseudoVLE8FF_V_M4, VLE8FF_V, 0x2, 0x8 }, // 2682
  { PseudoVLE8FF_V_M4_MASK, VLE8FF_V, 0x2, 0x8 }, // 2683
  { PseudoVLE8FF_V_M8, VLE8FF_V, 0x3, 0x8 }, // 2684
  { PseudoVLE8FF_V_M8_MASK, VLE8FF_V, 0x3, 0x8 }, // 2685
  { PseudoVLE8FF_V_MF8, VLE8FF_V, 0x5, 0x8 }, // 2686
  { PseudoVLE8FF_V_MF8_MASK, VLE8FF_V, 0x5, 0x8 }, // 2687
  { PseudoVLE8FF_V_MF4, VLE8FF_V, 0x6, 0x8 }, // 2688
  { PseudoVLE8FF_V_MF4_MASK, VLE8FF_V, 0x6, 0x8 }, // 2689
  { PseudoVLE8FF_V_MF2, VLE8FF_V, 0x7, 0x8 }, // 2690
  { PseudoVLE8FF_V_MF2_MASK, VLE8FF_V, 0x7, 0x8 }, // 2691
  { PseudoVLE8_V_M1, VLE8_V, 0x0, 0x8 }, // 2692
  { PseudoVLE8_V_M1_MASK, VLE8_V, 0x0, 0x8 }, // 2693
  { PseudoVLE8_V_M2, VLE8_V, 0x1, 0x8 }, // 2694
  { PseudoVLE8_V_M2_MASK, VLE8_V, 0x1, 0x8 }, // 2695
  { PseudoVLE8_V_M4, VLE8_V, 0x2, 0x8 }, // 2696
  { PseudoVLE8_V_M4_MASK, VLE8_V, 0x2, 0x8 }, // 2697
  { PseudoVLE8_V_M8, VLE8_V, 0x3, 0x8 }, // 2698
  { PseudoVLE8_V_M8_MASK, VLE8_V, 0x3, 0x8 }, // 2699
  { PseudoVLE8_V_MF8, VLE8_V, 0x5, 0x8 }, // 2700
  { PseudoVLE8_V_MF8_MASK, VLE8_V, 0x5, 0x8 }, // 2701
  { PseudoVLE8_V_MF4, VLE8_V, 0x6, 0x8 }, // 2702
  { PseudoVLE8_V_MF4_MASK, VLE8_V, 0x6, 0x8 }, // 2703
  { PseudoVLE8_V_MF2, VLE8_V, 0x7, 0x8 }, // 2704
  { PseudoVLE8_V_MF2_MASK, VLE8_V, 0x7, 0x8 }, // 2705
  { PseudoVLM_V_B8, VLM_V, 0x0, 0x0 }, // 2706
  { PseudoVLM_V_B16, VLM_V, 0x1, 0x0 }, // 2707
  { PseudoVLM_V_B32, VLM_V, 0x2, 0x0 }, // 2708
  { PseudoVLM_V_B64, VLM_V, 0x3, 0x0 }, // 2709
  { PseudoVLM_V_B1, VLM_V, 0x5, 0x0 }, // 2710
  { PseudoVLM_V_B2, VLM_V, 0x6, 0x0 }, // 2711
  { PseudoVLM_V_B4, VLM_V, 0x7, 0x0 }, // 2712
  { PseudoVLOXEI16_V_M1_M1, VLOXEI16_V, 0x0, 0x0 }, // 2713
  { PseudoVLOXEI16_V_M1_M1_MASK, VLOXEI16_V, 0x0, 0x0 }, // 2714
  { PseudoVLOXEI16_V_M2_M1, VLOXEI16_V, 0x0, 0x0 }, // 2715
  { PseudoVLOXEI16_V_M2_M1_MASK, VLOXEI16_V, 0x0, 0x0 }, // 2716
  { PseudoVLOXEI16_V_MF2_M1, VLOXEI16_V, 0x0, 0x0 }, // 2717
  { PseudoVLOXEI16_V_MF2_M1_MASK, VLOXEI16_V, 0x0, 0x0 }, // 2718
  { PseudoVLOXEI16_V_MF4_M1, VLOXEI16_V, 0x0, 0x0 }, // 2719
  { PseudoVLOXEI16_V_MF4_M1_MASK, VLOXEI16_V, 0x0, 0x0 }, // 2720
  { PseudoVLOXEI16_V_M1_M2, VLOXEI16_V, 0x1, 0x0 }, // 2721
  { PseudoVLOXEI16_V_M1_M2_MASK, VLOXEI16_V, 0x1, 0x0 }, // 2722
  { PseudoVLOXEI16_V_M2_M2, VLOXEI16_V, 0x1, 0x0 }, // 2723
  { PseudoVLOXEI16_V_M2_M2_MASK, VLOXEI16_V, 0x1, 0x0 }, // 2724
  { PseudoVLOXEI16_V_M4_M2, VLOXEI16_V, 0x1, 0x0 }, // 2725
  { PseudoVLOXEI16_V_M4_M2_MASK, VLOXEI16_V, 0x1, 0x0 }, // 2726
  { PseudoVLOXEI16_V_MF2_M2, VLOXEI16_V, 0x1, 0x0 }, // 2727
  { PseudoVLOXEI16_V_MF2_M2_MASK, VLOXEI16_V, 0x1, 0x0 }, // 2728
  { PseudoVLOXEI16_V_M1_M4, VLOXEI16_V, 0x2, 0x0 }, // 2729
  { PseudoVLOXEI16_V_M1_M4_MASK, VLOXEI16_V, 0x2, 0x0 }, // 2730
  { PseudoVLOXEI16_V_M2_M4, VLOXEI16_V, 0x2, 0x0 }, // 2731
  { PseudoVLOXEI16_V_M2_M4_MASK, VLOXEI16_V, 0x2, 0x0 }, // 2732
  { PseudoVLOXEI16_V_M4_M4, VLOXEI16_V, 0x2, 0x0 }, // 2733
  { PseudoVLOXEI16_V_M4_M4_MASK, VLOXEI16_V, 0x2, 0x0 }, // 2734
  { PseudoVLOXEI16_V_M8_M4, VLOXEI16_V, 0x2, 0x0 }, // 2735
  { PseudoVLOXEI16_V_M8_M4_MASK, VLOXEI16_V, 0x2, 0x0 }, // 2736
  { PseudoVLOXEI16_V_M2_M8, VLOXEI16_V, 0x3, 0x0 }, // 2737
  { PseudoVLOXEI16_V_M2_M8_MASK, VLOXEI16_V, 0x3, 0x0 }, // 2738
  { PseudoVLOXEI16_V_M4_M8, VLOXEI16_V, 0x3, 0x0 }, // 2739
  { PseudoVLOXEI16_V_M4_M8_MASK, VLOXEI16_V, 0x3, 0x0 }, // 2740
  { PseudoVLOXEI16_V_M8_M8, VLOXEI16_V, 0x3, 0x0 }, // 2741
  { PseudoVLOXEI16_V_M8_M8_MASK, VLOXEI16_V, 0x3, 0x0 }, // 2742
  { PseudoVLOXEI16_V_MF4_MF8, VLOXEI16_V, 0x5, 0x0 }, // 2743
  { PseudoVLOXEI16_V_MF4_MF8_MASK, VLOXEI16_V, 0x5, 0x0 }, // 2744
  { PseudoVLOXEI16_V_MF2_MF4, VLOXEI16_V, 0x6, 0x0 }, // 2745
  { PseudoVLOXEI16_V_MF2_MF4_MASK, VLOXEI16_V, 0x6, 0x0 }, // 2746
  { PseudoVLOXEI16_V_MF4_MF4, VLOXEI16_V, 0x6, 0x0 }, // 2747
  { PseudoVLOXEI16_V_MF4_MF4_MASK, VLOXEI16_V, 0x6, 0x0 }, // 2748
  { PseudoVLOXEI16_V_M1_MF2, VLOXEI16_V, 0x7, 0x0 }, // 2749
  { PseudoVLOXEI16_V_M1_MF2_MASK, VLOXEI16_V, 0x7, 0x0 }, // 2750
  { PseudoVLOXEI16_V_MF2_MF2, VLOXEI16_V, 0x7, 0x0 }, // 2751
  { PseudoVLOXEI16_V_MF2_MF2_MASK, VLOXEI16_V, 0x7, 0x0 }, // 2752
  { PseudoVLOXEI16_V_MF4_MF2, VLOXEI16_V, 0x7, 0x0 }, // 2753
  { PseudoVLOXEI16_V_MF4_MF2_MASK, VLOXEI16_V, 0x7, 0x0 }, // 2754
  { PseudoVLOXEI32_V_M1_M1, VLOXEI32_V, 0x0, 0x0 }, // 2755
  { PseudoVLOXEI32_V_M1_M1_MASK, VLOXEI32_V, 0x0, 0x0 }, // 2756
  { PseudoVLOXEI32_V_M2_M1, VLOXEI32_V, 0x0, 0x0 }, // 2757
  { PseudoVLOXEI32_V_M2_M1_MASK, VLOXEI32_V, 0x0, 0x0 }, // 2758
  { PseudoVLOXEI32_V_M4_M1, VLOXEI32_V, 0x0, 0x0 }, // 2759
  { PseudoVLOXEI32_V_M4_M1_MASK, VLOXEI32_V, 0x0, 0x0 }, // 2760
  { PseudoVLOXEI32_V_MF2_M1, VLOXEI32_V, 0x0, 0x0 }, // 2761
  { PseudoVLOXEI32_V_MF2_M1_MASK, VLOXEI32_V, 0x0, 0x0 }, // 2762
  { PseudoVLOXEI32_V_M1_M2, VLOXEI32_V, 0x1, 0x0 }, // 2763
  { PseudoVLOXEI32_V_M1_M2_MASK, VLOXEI32_V, 0x1, 0x0 }, // 2764
  { PseudoVLOXEI32_V_M2_M2, VLOXEI32_V, 0x1, 0x0 }, // 2765
  { PseudoVLOXEI32_V_M2_M2_MASK, VLOXEI32_V, 0x1, 0x0 }, // 2766
  { PseudoVLOXEI32_V_M4_M2, VLOXEI32_V, 0x1, 0x0 }, // 2767
  { PseudoVLOXEI32_V_M4_M2_MASK, VLOXEI32_V, 0x1, 0x0 }, // 2768
  { PseudoVLOXEI32_V_M8_M2, VLOXEI32_V, 0x1, 0x0 }, // 2769
  { PseudoVLOXEI32_V_M8_M2_MASK, VLOXEI32_V, 0x1, 0x0 }, // 2770
  { PseudoVLOXEI32_V_M2_M4, VLOXEI32_V, 0x2, 0x0 }, // 2771
  { PseudoVLOXEI32_V_M2_M4_MASK, VLOXEI32_V, 0x2, 0x0 }, // 2772
  { PseudoVLOXEI32_V_M4_M4, VLOXEI32_V, 0x2, 0x0 }, // 2773
  { PseudoVLOXEI32_V_M4_M4_MASK, VLOXEI32_V, 0x2, 0x0 }, // 2774
  { PseudoVLOXEI32_V_M8_M4, VLOXEI32_V, 0x2, 0x0 }, // 2775
  { PseudoVLOXEI32_V_M8_M4_MASK, VLOXEI32_V, 0x2, 0x0 }, // 2776
  { PseudoVLOXEI32_V_M4_M8, VLOXEI32_V, 0x3, 0x0 }, // 2777
  { PseudoVLOXEI32_V_M4_M8_MASK, VLOXEI32_V, 0x3, 0x0 }, // 2778
  { PseudoVLOXEI32_V_M8_M8, VLOXEI32_V, 0x3, 0x0 }, // 2779
  { PseudoVLOXEI32_V_M8_M8_MASK, VLOXEI32_V, 0x3, 0x0 }, // 2780
  { PseudoVLOXEI32_V_MF2_MF8, VLOXEI32_V, 0x5, 0x0 }, // 2781
  { PseudoVLOXEI32_V_MF2_MF8_MASK, VLOXEI32_V, 0x5, 0x0 }, // 2782
  { PseudoVLOXEI32_V_M1_MF4, VLOXEI32_V, 0x6, 0x0 }, // 2783
  { PseudoVLOXEI32_V_M1_MF4_MASK, VLOXEI32_V, 0x6, 0x0 }, // 2784
  { PseudoVLOXEI32_V_MF2_MF4, VLOXEI32_V, 0x6, 0x0 }, // 2785
  { PseudoVLOXEI32_V_MF2_MF4_MASK, VLOXEI32_V, 0x6, 0x0 }, // 2786
  { PseudoVLOXEI32_V_M1_MF2, VLOXEI32_V, 0x7, 0x0 }, // 2787
  { PseudoVLOXEI32_V_M1_MF2_MASK, VLOXEI32_V, 0x7, 0x0 }, // 2788
  { PseudoVLOXEI32_V_M2_MF2, VLOXEI32_V, 0x7, 0x0 }, // 2789
  { PseudoVLOXEI32_V_M2_MF2_MASK, VLOXEI32_V, 0x7, 0x0 }, // 2790
  { PseudoVLOXEI32_V_MF2_MF2, VLOXEI32_V, 0x7, 0x0 }, // 2791
  { PseudoVLOXEI32_V_MF2_MF2_MASK, VLOXEI32_V, 0x7, 0x0 }, // 2792
  { PseudoVLOXEI64_V_M1_M1, VLOXEI64_V, 0x0, 0x0 }, // 2793
  { PseudoVLOXEI64_V_M1_M1_MASK, VLOXEI64_V, 0x0, 0x0 }, // 2794
  { PseudoVLOXEI64_V_M2_M1, VLOXEI64_V, 0x0, 0x0 }, // 2795
  { PseudoVLOXEI64_V_M2_M1_MASK, VLOXEI64_V, 0x0, 0x0 }, // 2796
  { PseudoVLOXEI64_V_M4_M1, VLOXEI64_V, 0x0, 0x0 }, // 2797
  { PseudoVLOXEI64_V_M4_M1_MASK, VLOXEI64_V, 0x0, 0x0 }, // 2798
  { PseudoVLOXEI64_V_M8_M1, VLOXEI64_V, 0x0, 0x0 }, // 2799
  { PseudoVLOXEI64_V_M8_M1_MASK, VLOXEI64_V, 0x0, 0x0 }, // 2800
  { PseudoVLOXEI64_V_M2_M2, VLOXEI64_V, 0x1, 0x0 }, // 2801
  { PseudoVLOXEI64_V_M2_M2_MASK, VLOXEI64_V, 0x1, 0x0 }, // 2802
  { PseudoVLOXEI64_V_M4_M2, VLOXEI64_V, 0x1, 0x0 }, // 2803
  { PseudoVLOXEI64_V_M4_M2_MASK, VLOXEI64_V, 0x1, 0x0 }, // 2804
  { PseudoVLOXEI64_V_M8_M2, VLOXEI64_V, 0x1, 0x0 }, // 2805
  { PseudoVLOXEI64_V_M8_M2_MASK, VLOXEI64_V, 0x1, 0x0 }, // 2806
  { PseudoVLOXEI64_V_M4_M4, VLOXEI64_V, 0x2, 0x0 }, // 2807
  { PseudoVLOXEI64_V_M4_M4_MASK, VLOXEI64_V, 0x2, 0x0 }, // 2808
  { PseudoVLOXEI64_V_M8_M4, VLOXEI64_V, 0x2, 0x0 }, // 2809
  { PseudoVLOXEI64_V_M8_M4_MASK, VLOXEI64_V, 0x2, 0x0 }, // 2810
  { PseudoVLOXEI64_V_M8_M8, VLOXEI64_V, 0x3, 0x0 }, // 2811
  { PseudoVLOXEI64_V_M8_M8_MASK, VLOXEI64_V, 0x3, 0x0 }, // 2812
  { PseudoVLOXEI64_V_M1_MF8, VLOXEI64_V, 0x5, 0x0 }, // 2813
  { PseudoVLOXEI64_V_M1_MF8_MASK, VLOXEI64_V, 0x5, 0x0 }, // 2814
  { PseudoVLOXEI64_V_M1_MF4, VLOXEI64_V, 0x6, 0x0 }, // 2815
  { PseudoVLOXEI64_V_M1_MF4_MASK, VLOXEI64_V, 0x6, 0x0 }, // 2816
  { PseudoVLOXEI64_V_M2_MF4, VLOXEI64_V, 0x6, 0x0 }, // 2817
  { PseudoVLOXEI64_V_M2_MF4_MASK, VLOXEI64_V, 0x6, 0x0 }, // 2818
  { PseudoVLOXEI64_V_M1_MF2, VLOXEI64_V, 0x7, 0x0 }, // 2819
  { PseudoVLOXEI64_V_M1_MF2_MASK, VLOXEI64_V, 0x7, 0x0 }, // 2820
  { PseudoVLOXEI64_V_M2_MF2, VLOXEI64_V, 0x7, 0x0 }, // 2821
  { PseudoVLOXEI64_V_M2_MF2_MASK, VLOXEI64_V, 0x7, 0x0 }, // 2822
  { PseudoVLOXEI64_V_M4_MF2, VLOXEI64_V, 0x7, 0x0 }, // 2823
  { PseudoVLOXEI64_V_M4_MF2_MASK, VLOXEI64_V, 0x7, 0x0 }, // 2824
  { PseudoVLOXEI8_V_M1_M1, VLOXEI8_V, 0x0, 0x0 }, // 2825
  { PseudoVLOXEI8_V_M1_M1_MASK, VLOXEI8_V, 0x0, 0x0 }, // 2826
  { PseudoVLOXEI8_V_MF2_M1, VLOXEI8_V, 0x0, 0x0 }, // 2827
  { PseudoVLOXEI8_V_MF2_M1_MASK, VLOXEI8_V, 0x0, 0x0 }, // 2828
  { PseudoVLOXEI8_V_MF4_M1, VLOXEI8_V, 0x0, 0x0 }, // 2829
  { PseudoVLOXEI8_V_MF4_M1_MASK, VLOXEI8_V, 0x0, 0x0 }, // 2830
  { PseudoVLOXEI8_V_MF8_M1, VLOXEI8_V, 0x0, 0x0 }, // 2831
  { PseudoVLOXEI8_V_MF8_M1_MASK, VLOXEI8_V, 0x0, 0x0 }, // 2832
  { PseudoVLOXEI8_V_M1_M2, VLOXEI8_V, 0x1, 0x0 }, // 2833
  { PseudoVLOXEI8_V_M1_M2_MASK, VLOXEI8_V, 0x1, 0x0 }, // 2834
  { PseudoVLOXEI8_V_M2_M2, VLOXEI8_V, 0x1, 0x0 }, // 2835
  { PseudoVLOXEI8_V_M2_M2_MASK, VLOXEI8_V, 0x1, 0x0 }, // 2836
  { PseudoVLOXEI8_V_MF2_M2, VLOXEI8_V, 0x1, 0x0 }, // 2837
  { PseudoVLOXEI8_V_MF2_M2_MASK, VLOXEI8_V, 0x1, 0x0 }, // 2838
  { PseudoVLOXEI8_V_MF4_M2, VLOXEI8_V, 0x1, 0x0 }, // 2839
  { PseudoVLOXEI8_V_MF4_M2_MASK, VLOXEI8_V, 0x1, 0x0 }, // 2840
  { PseudoVLOXEI8_V_M1_M4, VLOXEI8_V, 0x2, 0x0 }, // 2841
  { PseudoVLOXEI8_V_M1_M4_MASK, VLOXEI8_V, 0x2, 0x0 }, // 2842
  { PseudoVLOXEI8_V_M2_M4, VLOXEI8_V, 0x2, 0x0 }, // 2843
  { PseudoVLOXEI8_V_M2_M4_MASK, VLOXEI8_V, 0x2, 0x0 }, // 2844
  { PseudoVLOXEI8_V_M4_M4, VLOXEI8_V, 0x2, 0x0 }, // 2845
  { PseudoVLOXEI8_V_M4_M4_MASK, VLOXEI8_V, 0x2, 0x0 }, // 2846
  { PseudoVLOXEI8_V_MF2_M4, VLOXEI8_V, 0x2, 0x0 }, // 2847
  { PseudoVLOXEI8_V_MF2_M4_MASK, VLOXEI8_V, 0x2, 0x0 }, // 2848
  { PseudoVLOXEI8_V_M1_M8, VLOXEI8_V, 0x3, 0x0 }, // 2849
  { PseudoVLOXEI8_V_M1_M8_MASK, VLOXEI8_V, 0x3, 0x0 }, // 2850
  { PseudoVLOXEI8_V_M2_M8, VLOXEI8_V, 0x3, 0x0 }, // 2851
  { PseudoVLOXEI8_V_M2_M8_MASK, VLOXEI8_V, 0x3, 0x0 }, // 2852
  { PseudoVLOXEI8_V_M4_M8, VLOXEI8_V, 0x3, 0x0 }, // 2853
  { PseudoVLOXEI8_V_M4_M8_MASK, VLOXEI8_V, 0x3, 0x0 }, // 2854
  { PseudoVLOXEI8_V_M8_M8, VLOXEI8_V, 0x3, 0x0 }, // 2855
  { PseudoVLOXEI8_V_M8_M8_MASK, VLOXEI8_V, 0x3, 0x0 }, // 2856
  { PseudoVLOXEI8_V_MF8_MF8, VLOXEI8_V, 0x5, 0x0 }, // 2857
  { PseudoVLOXEI8_V_MF8_MF8_MASK, VLOXEI8_V, 0x5, 0x0 }, // 2858
  { PseudoVLOXEI8_V_MF4_MF4, VLOXEI8_V, 0x6, 0x0 }, // 2859
  { PseudoVLOXEI8_V_MF4_MF4_MASK, VLOXEI8_V, 0x6, 0x0 }, // 2860
  { PseudoVLOXEI8_V_MF8_MF4, VLOXEI8_V, 0x6, 0x0 }, // 2861
  { PseudoVLOXEI8_V_MF8_MF4_MASK, VLOXEI8_V, 0x6, 0x0 }, // 2862
  { PseudoVLOXEI8_V_MF2_MF2, VLOXEI8_V, 0x7, 0x0 }, // 2863
  { PseudoVLOXEI8_V_MF2_MF2_MASK, VLOXEI8_V, 0x7, 0x0 }, // 2864
  { PseudoVLOXEI8_V_MF4_MF2, VLOXEI8_V, 0x7, 0x0 }, // 2865
  { PseudoVLOXEI8_V_MF4_MF2_MASK, VLOXEI8_V, 0x7, 0x0 }, // 2866
  { PseudoVLOXEI8_V_MF8_MF2, VLOXEI8_V, 0x7, 0x0 }, // 2867
  { PseudoVLOXEI8_V_MF8_MF2_MASK, VLOXEI8_V, 0x7, 0x0 }, // 2868
  { PseudoVLOXSEG2EI16_V_M1_M1, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2869
  { PseudoVLOXSEG2EI16_V_M1_M1_MASK, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2870
  { PseudoVLOXSEG2EI16_V_M2_M1, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2871
  { PseudoVLOXSEG2EI16_V_M2_M1_MASK, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2872
  { PseudoVLOXSEG2EI16_V_MF2_M1, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2873
  { PseudoVLOXSEG2EI16_V_MF2_M1_MASK, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2874
  { PseudoVLOXSEG2EI16_V_MF4_M1, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2875
  { PseudoVLOXSEG2EI16_V_MF4_M1_MASK, VLOXSEG2EI16_V, 0x0, 0x0 }, // 2876
  { PseudoVLOXSEG2EI16_V_M1_M2, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2877
  { PseudoVLOXSEG2EI16_V_M1_M2_MASK, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2878
  { PseudoVLOXSEG2EI16_V_M2_M2, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2879
  { PseudoVLOXSEG2EI16_V_M2_M2_MASK, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2880
  { PseudoVLOXSEG2EI16_V_M4_M2, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2881
  { PseudoVLOXSEG2EI16_V_M4_M2_MASK, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2882
  { PseudoVLOXSEG2EI16_V_MF2_M2, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2883
  { PseudoVLOXSEG2EI16_V_MF2_M2_MASK, VLOXSEG2EI16_V, 0x1, 0x0 }, // 2884
  { PseudoVLOXSEG2EI16_V_M1_M4, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2885
  { PseudoVLOXSEG2EI16_V_M1_M4_MASK, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2886
  { PseudoVLOXSEG2EI16_V_M2_M4, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2887
  { PseudoVLOXSEG2EI16_V_M2_M4_MASK, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2888
  { PseudoVLOXSEG2EI16_V_M4_M4, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2889
  { PseudoVLOXSEG2EI16_V_M4_M4_MASK, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2890
  { PseudoVLOXSEG2EI16_V_M8_M4, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2891
  { PseudoVLOXSEG2EI16_V_M8_M4_MASK, VLOXSEG2EI16_V, 0x2, 0x0 }, // 2892
  { PseudoVLOXSEG2EI16_V_MF4_MF8, VLOXSEG2EI16_V, 0x5, 0x0 }, // 2893
  { PseudoVLOXSEG2EI16_V_MF4_MF8_MASK, VLOXSEG2EI16_V, 0x5, 0x0 }, // 2894
  { PseudoVLOXSEG2EI16_V_MF2_MF4, VLOXSEG2EI16_V, 0x6, 0x0 }, // 2895
  { PseudoVLOXSEG2EI16_V_MF2_MF4_MASK, VLOXSEG2EI16_V, 0x6, 0x0 }, // 2896
  { PseudoVLOXSEG2EI16_V_MF4_MF4, VLOXSEG2EI16_V, 0x6, 0x0 }, // 2897
  { PseudoVLOXSEG2EI16_V_MF4_MF4_MASK, VLOXSEG2EI16_V, 0x6, 0x0 }, // 2898
  { PseudoVLOXSEG2EI16_V_M1_MF2, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2899
  { PseudoVLOXSEG2EI16_V_M1_MF2_MASK, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2900
  { PseudoVLOXSEG2EI16_V_MF2_MF2, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2901
  { PseudoVLOXSEG2EI16_V_MF2_MF2_MASK, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2902
  { PseudoVLOXSEG2EI16_V_MF4_MF2, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2903
  { PseudoVLOXSEG2EI16_V_MF4_MF2_MASK, VLOXSEG2EI16_V, 0x7, 0x0 }, // 2904
  { PseudoVLOXSEG2EI32_V_M1_M1, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2905
  { PseudoVLOXSEG2EI32_V_M1_M1_MASK, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2906
  { PseudoVLOXSEG2EI32_V_M2_M1, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2907
  { PseudoVLOXSEG2EI32_V_M2_M1_MASK, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2908
  { PseudoVLOXSEG2EI32_V_M4_M1, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2909
  { PseudoVLOXSEG2EI32_V_M4_M1_MASK, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2910
  { PseudoVLOXSEG2EI32_V_MF2_M1, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2911
  { PseudoVLOXSEG2EI32_V_MF2_M1_MASK, VLOXSEG2EI32_V, 0x0, 0x0 }, // 2912
  { PseudoVLOXSEG2EI32_V_M1_M2, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2913
  { PseudoVLOXSEG2EI32_V_M1_M2_MASK, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2914
  { PseudoVLOXSEG2EI32_V_M2_M2, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2915
  { PseudoVLOXSEG2EI32_V_M2_M2_MASK, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2916
  { PseudoVLOXSEG2EI32_V_M4_M2, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2917
  { PseudoVLOXSEG2EI32_V_M4_M2_MASK, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2918
  { PseudoVLOXSEG2EI32_V_M8_M2, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2919
  { PseudoVLOXSEG2EI32_V_M8_M2_MASK, VLOXSEG2EI32_V, 0x1, 0x0 }, // 2920
  { PseudoVLOXSEG2EI32_V_M2_M4, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2921
  { PseudoVLOXSEG2EI32_V_M2_M4_MASK, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2922
  { PseudoVLOXSEG2EI32_V_M4_M4, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2923
  { PseudoVLOXSEG2EI32_V_M4_M4_MASK, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2924
  { PseudoVLOXSEG2EI32_V_M8_M4, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2925
  { PseudoVLOXSEG2EI32_V_M8_M4_MASK, VLOXSEG2EI32_V, 0x2, 0x0 }, // 2926
  { PseudoVLOXSEG2EI32_V_MF2_MF8, VLOXSEG2EI32_V, 0x5, 0x0 }, // 2927
  { PseudoVLOXSEG2EI32_V_MF2_MF8_MASK, VLOXSEG2EI32_V, 0x5, 0x0 }, // 2928
  { PseudoVLOXSEG2EI32_V_M1_MF4, VLOXSEG2EI32_V, 0x6, 0x0 }, // 2929
  { PseudoVLOXSEG2EI32_V_M1_MF4_MASK, VLOXSEG2EI32_V, 0x6, 0x0 }, // 2930
  { PseudoVLOXSEG2EI32_V_MF2_MF4, VLOXSEG2EI32_V, 0x6, 0x0 }, // 2931
  { PseudoVLOXSEG2EI32_V_MF2_MF4_MASK, VLOXSEG2EI32_V, 0x6, 0x0 }, // 2932
  { PseudoVLOXSEG2EI32_V_M1_MF2, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2933
  { PseudoVLOXSEG2EI32_V_M1_MF2_MASK, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2934
  { PseudoVLOXSEG2EI32_V_M2_MF2, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2935
  { PseudoVLOXSEG2EI32_V_M2_MF2_MASK, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2936
  { PseudoVLOXSEG2EI32_V_MF2_MF2, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2937
  { PseudoVLOXSEG2EI32_V_MF2_MF2_MASK, VLOXSEG2EI32_V, 0x7, 0x0 }, // 2938
  { PseudoVLOXSEG2EI64_V_M1_M1, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2939
  { PseudoVLOXSEG2EI64_V_M1_M1_MASK, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2940
  { PseudoVLOXSEG2EI64_V_M2_M1, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2941
  { PseudoVLOXSEG2EI64_V_M2_M1_MASK, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2942
  { PseudoVLOXSEG2EI64_V_M4_M1, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2943
  { PseudoVLOXSEG2EI64_V_M4_M1_MASK, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2944
  { PseudoVLOXSEG2EI64_V_M8_M1, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2945
  { PseudoVLOXSEG2EI64_V_M8_M1_MASK, VLOXSEG2EI64_V, 0x0, 0x0 }, // 2946
  { PseudoVLOXSEG2EI64_V_M2_M2, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2947
  { PseudoVLOXSEG2EI64_V_M2_M2_MASK, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2948
  { PseudoVLOXSEG2EI64_V_M4_M2, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2949
  { PseudoVLOXSEG2EI64_V_M4_M2_MASK, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2950
  { PseudoVLOXSEG2EI64_V_M8_M2, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2951
  { PseudoVLOXSEG2EI64_V_M8_M2_MASK, VLOXSEG2EI64_V, 0x1, 0x0 }, // 2952
  { PseudoVLOXSEG2EI64_V_M4_M4, VLOXSEG2EI64_V, 0x2, 0x0 }, // 2953
  { PseudoVLOXSEG2EI64_V_M4_M4_MASK, VLOXSEG2EI64_V, 0x2, 0x0 }, // 2954
  { PseudoVLOXSEG2EI64_V_M8_M4, VLOXSEG2EI64_V, 0x2, 0x0 }, // 2955
  { PseudoVLOXSEG2EI64_V_M8_M4_MASK, VLOXSEG2EI64_V, 0x2, 0x0 }, // 2956
  { PseudoVLOXSEG2EI64_V_M1_MF8, VLOXSEG2EI64_V, 0x5, 0x0 }, // 2957
  { PseudoVLOXSEG2EI64_V_M1_MF8_MASK, VLOXSEG2EI64_V, 0x5, 0x0 }, // 2958
  { PseudoVLOXSEG2EI64_V_M1_MF4, VLOXSEG2EI64_V, 0x6, 0x0 }, // 2959
  { PseudoVLOXSEG2EI64_V_M1_MF4_MASK, VLOXSEG2EI64_V, 0x6, 0x0 }, // 2960
  { PseudoVLOXSEG2EI64_V_M2_MF4, VLOXSEG2EI64_V, 0x6, 0x0 }, // 2961
  { PseudoVLOXSEG2EI64_V_M2_MF4_MASK, VLOXSEG2EI64_V, 0x6, 0x0 }, // 2962
  { PseudoVLOXSEG2EI64_V_M1_MF2, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2963
  { PseudoVLOXSEG2EI64_V_M1_MF2_MASK, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2964
  { PseudoVLOXSEG2EI64_V_M2_MF2, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2965
  { PseudoVLOXSEG2EI64_V_M2_MF2_MASK, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2966
  { PseudoVLOXSEG2EI64_V_M4_MF2, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2967
  { PseudoVLOXSEG2EI64_V_M4_MF2_MASK, VLOXSEG2EI64_V, 0x7, 0x0 }, // 2968
  { PseudoVLOXSEG2EI8_V_M1_M1, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2969
  { PseudoVLOXSEG2EI8_V_M1_M1_MASK, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2970
  { PseudoVLOXSEG2EI8_V_MF2_M1, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2971
  { PseudoVLOXSEG2EI8_V_MF2_M1_MASK, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2972
  { PseudoVLOXSEG2EI8_V_MF4_M1, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2973
  { PseudoVLOXSEG2EI8_V_MF4_M1_MASK, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2974
  { PseudoVLOXSEG2EI8_V_MF8_M1, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2975
  { PseudoVLOXSEG2EI8_V_MF8_M1_MASK, VLOXSEG2EI8_V, 0x0, 0x0 }, // 2976
  { PseudoVLOXSEG2EI8_V_M1_M2, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2977
  { PseudoVLOXSEG2EI8_V_M1_M2_MASK, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2978
  { PseudoVLOXSEG2EI8_V_M2_M2, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2979
  { PseudoVLOXSEG2EI8_V_M2_M2_MASK, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2980
  { PseudoVLOXSEG2EI8_V_MF2_M2, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2981
  { PseudoVLOXSEG2EI8_V_MF2_M2_MASK, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2982
  { PseudoVLOXSEG2EI8_V_MF4_M2, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2983
  { PseudoVLOXSEG2EI8_V_MF4_M2_MASK, VLOXSEG2EI8_V, 0x1, 0x0 }, // 2984
  { PseudoVLOXSEG2EI8_V_M1_M4, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2985
  { PseudoVLOXSEG2EI8_V_M1_M4_MASK, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2986
  { PseudoVLOXSEG2EI8_V_M2_M4, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2987
  { PseudoVLOXSEG2EI8_V_M2_M4_MASK, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2988
  { PseudoVLOXSEG2EI8_V_M4_M4, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2989
  { PseudoVLOXSEG2EI8_V_M4_M4_MASK, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2990
  { PseudoVLOXSEG2EI8_V_MF2_M4, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2991
  { PseudoVLOXSEG2EI8_V_MF2_M4_MASK, VLOXSEG2EI8_V, 0x2, 0x0 }, // 2992
  { PseudoVLOXSEG2EI8_V_MF8_MF8, VLOXSEG2EI8_V, 0x5, 0x0 }, // 2993
  { PseudoVLOXSEG2EI8_V_MF8_MF8_MASK, VLOXSEG2EI8_V, 0x5, 0x0 }, // 2994
  { PseudoVLOXSEG2EI8_V_MF4_MF4, VLOXSEG2EI8_V, 0x6, 0x0 }, // 2995
  { PseudoVLOXSEG2EI8_V_MF4_MF4_MASK, VLOXSEG2EI8_V, 0x6, 0x0 }, // 2996
  { PseudoVLOXSEG2EI8_V_MF8_MF4, VLOXSEG2EI8_V, 0x6, 0x0 }, // 2997
  { PseudoVLOXSEG2EI8_V_MF8_MF4_MASK, VLOXSEG2EI8_V, 0x6, 0x0 }, // 2998
  { PseudoVLOXSEG2EI8_V_MF2_MF2, VLOXSEG2EI8_V, 0x7, 0x0 }, // 2999
  { PseudoVLOXSEG2EI8_V_MF2_MF2_MASK, VLOXSEG2EI8_V, 0x7, 0x0 }, // 3000
  { PseudoVLOXSEG2EI8_V_MF4_MF2, VLOXSEG2EI8_V, 0x7, 0x0 }, // 3001
  { PseudoVLOXSEG2EI8_V_MF4_MF2_MASK, VLOXSEG2EI8_V, 0x7, 0x0 }, // 3002
  { PseudoVLOXSEG2EI8_V_MF8_MF2, VLOXSEG2EI8_V, 0x7, 0x0 }, // 3003
  { PseudoVLOXSEG2EI8_V_MF8_MF2_MASK, VLOXSEG2EI8_V, 0x7, 0x0 }, // 3004
  { PseudoVLOXSEG3EI16_V_M1_M1, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3005
  { PseudoVLOXSEG3EI16_V_M1_M1_MASK, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3006
  { PseudoVLOXSEG3EI16_V_M2_M1, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3007
  { PseudoVLOXSEG3EI16_V_M2_M1_MASK, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3008
  { PseudoVLOXSEG3EI16_V_MF2_M1, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3009
  { PseudoVLOXSEG3EI16_V_MF2_M1_MASK, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3010
  { PseudoVLOXSEG3EI16_V_MF4_M1, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3011
  { PseudoVLOXSEG3EI16_V_MF4_M1_MASK, VLOXSEG3EI16_V, 0x0, 0x0 }, // 3012
  { PseudoVLOXSEG3EI16_V_M1_M2, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3013
  { PseudoVLOXSEG3EI16_V_M1_M2_MASK, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3014
  { PseudoVLOXSEG3EI16_V_M2_M2, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3015
  { PseudoVLOXSEG3EI16_V_M2_M2_MASK, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3016
  { PseudoVLOXSEG3EI16_V_M4_M2, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3017
  { PseudoVLOXSEG3EI16_V_M4_M2_MASK, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3018
  { PseudoVLOXSEG3EI16_V_MF2_M2, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3019
  { PseudoVLOXSEG3EI16_V_MF2_M2_MASK, VLOXSEG3EI16_V, 0x1, 0x0 }, // 3020
  { PseudoVLOXSEG3EI16_V_MF4_MF8, VLOXSEG3EI16_V, 0x5, 0x0 }, // 3021
  { PseudoVLOXSEG3EI16_V_MF4_MF8_MASK, VLOXSEG3EI16_V, 0x5, 0x0 }, // 3022
  { PseudoVLOXSEG3EI16_V_MF2_MF4, VLOXSEG3EI16_V, 0x6, 0x0 }, // 3023
  { PseudoVLOXSEG3EI16_V_MF2_MF4_MASK, VLOXSEG3EI16_V, 0x6, 0x0 }, // 3024
  { PseudoVLOXSEG3EI16_V_MF4_MF4, VLOXSEG3EI16_V, 0x6, 0x0 }, // 3025
  { PseudoVLOXSEG3EI16_V_MF4_MF4_MASK, VLOXSEG3EI16_V, 0x6, 0x0 }, // 3026
  { PseudoVLOXSEG3EI16_V_M1_MF2, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3027
  { PseudoVLOXSEG3EI16_V_M1_MF2_MASK, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3028
  { PseudoVLOXSEG3EI16_V_MF2_MF2, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3029
  { PseudoVLOXSEG3EI16_V_MF2_MF2_MASK, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3030
  { PseudoVLOXSEG3EI16_V_MF4_MF2, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3031
  { PseudoVLOXSEG3EI16_V_MF4_MF2_MASK, VLOXSEG3EI16_V, 0x7, 0x0 }, // 3032
  { PseudoVLOXSEG3EI32_V_M1_M1, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3033
  { PseudoVLOXSEG3EI32_V_M1_M1_MASK, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3034
  { PseudoVLOXSEG3EI32_V_M2_M1, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3035
  { PseudoVLOXSEG3EI32_V_M2_M1_MASK, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3036
  { PseudoVLOXSEG3EI32_V_M4_M1, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3037
  { PseudoVLOXSEG3EI32_V_M4_M1_MASK, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3038
  { PseudoVLOXSEG3EI32_V_MF2_M1, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3039
  { PseudoVLOXSEG3EI32_V_MF2_M1_MASK, VLOXSEG3EI32_V, 0x0, 0x0 }, // 3040
  { PseudoVLOXSEG3EI32_V_M1_M2, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3041
  { PseudoVLOXSEG3EI32_V_M1_M2_MASK, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3042
  { PseudoVLOXSEG3EI32_V_M2_M2, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3043
  { PseudoVLOXSEG3EI32_V_M2_M2_MASK, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3044
  { PseudoVLOXSEG3EI32_V_M4_M2, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3045
  { PseudoVLOXSEG3EI32_V_M4_M2_MASK, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3046
  { PseudoVLOXSEG3EI32_V_M8_M2, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3047
  { PseudoVLOXSEG3EI32_V_M8_M2_MASK, VLOXSEG3EI32_V, 0x1, 0x0 }, // 3048
  { PseudoVLOXSEG3EI32_V_MF2_MF8, VLOXSEG3EI32_V, 0x5, 0x0 }, // 3049
  { PseudoVLOXSEG3EI32_V_MF2_MF8_MASK, VLOXSEG3EI32_V, 0x5, 0x0 }, // 3050
  { PseudoVLOXSEG3EI32_V_M1_MF4, VLOXSEG3EI32_V, 0x6, 0x0 }, // 3051
  { PseudoVLOXSEG3EI32_V_M1_MF4_MASK, VLOXSEG3EI32_V, 0x6, 0x0 }, // 3052
  { PseudoVLOXSEG3EI32_V_MF2_MF4, VLOXSEG3EI32_V, 0x6, 0x0 }, // 3053
  { PseudoVLOXSEG3EI32_V_MF2_MF4_MASK, VLOXSEG3EI32_V, 0x6, 0x0 }, // 3054
  { PseudoVLOXSEG3EI32_V_M1_MF2, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3055
  { PseudoVLOXSEG3EI32_V_M1_MF2_MASK, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3056
  { PseudoVLOXSEG3EI32_V_M2_MF2, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3057
  { PseudoVLOXSEG3EI32_V_M2_MF2_MASK, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3058
  { PseudoVLOXSEG3EI32_V_MF2_MF2, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3059
  { PseudoVLOXSEG3EI32_V_MF2_MF2_MASK, VLOXSEG3EI32_V, 0x7, 0x0 }, // 3060
  { PseudoVLOXSEG3EI64_V_M1_M1, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3061
  { PseudoVLOXSEG3EI64_V_M1_M1_MASK, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3062
  { PseudoVLOXSEG3EI64_V_M2_M1, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3063
  { PseudoVLOXSEG3EI64_V_M2_M1_MASK, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3064
  { PseudoVLOXSEG3EI64_V_M4_M1, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3065
  { PseudoVLOXSEG3EI64_V_M4_M1_MASK, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3066
  { PseudoVLOXSEG3EI64_V_M8_M1, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3067
  { PseudoVLOXSEG3EI64_V_M8_M1_MASK, VLOXSEG3EI64_V, 0x0, 0x0 }, // 3068
  { PseudoVLOXSEG3EI64_V_M2_M2, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3069
  { PseudoVLOXSEG3EI64_V_M2_M2_MASK, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3070
  { PseudoVLOXSEG3EI64_V_M4_M2, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3071
  { PseudoVLOXSEG3EI64_V_M4_M2_MASK, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3072
  { PseudoVLOXSEG3EI64_V_M8_M2, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3073
  { PseudoVLOXSEG3EI64_V_M8_M2_MASK, VLOXSEG3EI64_V, 0x1, 0x0 }, // 3074
  { PseudoVLOXSEG3EI64_V_M1_MF8, VLOXSEG3EI64_V, 0x5, 0x0 }, // 3075
  { PseudoVLOXSEG3EI64_V_M1_MF8_MASK, VLOXSEG3EI64_V, 0x5, 0x0 }, // 3076
  { PseudoVLOXSEG3EI64_V_M1_MF4, VLOXSEG3EI64_V, 0x6, 0x0 }, // 3077
  { PseudoVLOXSEG3EI64_V_M1_MF4_MASK, VLOXSEG3EI64_V, 0x6, 0x0 }, // 3078
  { PseudoVLOXSEG3EI64_V_M2_MF4, VLOXSEG3EI64_V, 0x6, 0x0 }, // 3079
  { PseudoVLOXSEG3EI64_V_M2_MF4_MASK, VLOXSEG3EI64_V, 0x6, 0x0 }, // 3080
  { PseudoVLOXSEG3EI64_V_M1_MF2, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3081
  { PseudoVLOXSEG3EI64_V_M1_MF2_MASK, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3082
  { PseudoVLOXSEG3EI64_V_M2_MF2, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3083
  { PseudoVLOXSEG3EI64_V_M2_MF2_MASK, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3084
  { PseudoVLOXSEG3EI64_V_M4_MF2, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3085
  { PseudoVLOXSEG3EI64_V_M4_MF2_MASK, VLOXSEG3EI64_V, 0x7, 0x0 }, // 3086
  { PseudoVLOXSEG3EI8_V_M1_M1, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3087
  { PseudoVLOXSEG3EI8_V_M1_M1_MASK, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3088
  { PseudoVLOXSEG3EI8_V_MF2_M1, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3089
  { PseudoVLOXSEG3EI8_V_MF2_M1_MASK, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3090
  { PseudoVLOXSEG3EI8_V_MF4_M1, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3091
  { PseudoVLOXSEG3EI8_V_MF4_M1_MASK, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3092
  { PseudoVLOXSEG3EI8_V_MF8_M1, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3093
  { PseudoVLOXSEG3EI8_V_MF8_M1_MASK, VLOXSEG3EI8_V, 0x0, 0x0 }, // 3094
  { PseudoVLOXSEG3EI8_V_M1_M2, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3095
  { PseudoVLOXSEG3EI8_V_M1_M2_MASK, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3096
  { PseudoVLOXSEG3EI8_V_M2_M2, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3097
  { PseudoVLOXSEG3EI8_V_M2_M2_MASK, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3098
  { PseudoVLOXSEG3EI8_V_MF2_M2, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3099
  { PseudoVLOXSEG3EI8_V_MF2_M2_MASK, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3100
  { PseudoVLOXSEG3EI8_V_MF4_M2, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3101
  { PseudoVLOXSEG3EI8_V_MF4_M2_MASK, VLOXSEG3EI8_V, 0x1, 0x0 }, // 3102
  { PseudoVLOXSEG3EI8_V_MF8_MF8, VLOXSEG3EI8_V, 0x5, 0x0 }, // 3103
  { PseudoVLOXSEG3EI8_V_MF8_MF8_MASK, VLOXSEG3EI8_V, 0x5, 0x0 }, // 3104
  { PseudoVLOXSEG3EI8_V_MF4_MF4, VLOXSEG3EI8_V, 0x6, 0x0 }, // 3105
  { PseudoVLOXSEG3EI8_V_MF4_MF4_MASK, VLOXSEG3EI8_V, 0x6, 0x0 }, // 3106
  { PseudoVLOXSEG3EI8_V_MF8_MF4, VLOXSEG3EI8_V, 0x6, 0x0 }, // 3107
  { PseudoVLOXSEG3EI8_V_MF8_MF4_MASK, VLOXSEG3EI8_V, 0x6, 0x0 }, // 3108
  { PseudoVLOXSEG3EI8_V_MF2_MF2, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3109
  { PseudoVLOXSEG3EI8_V_MF2_MF2_MASK, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3110
  { PseudoVLOXSEG3EI8_V_MF4_MF2, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3111
  { PseudoVLOXSEG3EI8_V_MF4_MF2_MASK, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3112
  { PseudoVLOXSEG3EI8_V_MF8_MF2, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3113
  { PseudoVLOXSEG3EI8_V_MF8_MF2_MASK, VLOXSEG3EI8_V, 0x7, 0x0 }, // 3114
  { PseudoVLOXSEG4EI16_V_M1_M1, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3115
  { PseudoVLOXSEG4EI16_V_M1_M1_MASK, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3116
  { PseudoVLOXSEG4EI16_V_M2_M1, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3117
  { PseudoVLOXSEG4EI16_V_M2_M1_MASK, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3118
  { PseudoVLOXSEG4EI16_V_MF2_M1, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3119
  { PseudoVLOXSEG4EI16_V_MF2_M1_MASK, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3120
  { PseudoVLOXSEG4EI16_V_MF4_M1, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3121
  { PseudoVLOXSEG4EI16_V_MF4_M1_MASK, VLOXSEG4EI16_V, 0x0, 0x0 }, // 3122
  { PseudoVLOXSEG4EI16_V_M1_M2, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3123
  { PseudoVLOXSEG4EI16_V_M1_M2_MASK, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3124
  { PseudoVLOXSEG4EI16_V_M2_M2, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3125
  { PseudoVLOXSEG4EI16_V_M2_M2_MASK, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3126
  { PseudoVLOXSEG4EI16_V_M4_M2, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3127
  { PseudoVLOXSEG4EI16_V_M4_M2_MASK, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3128
  { PseudoVLOXSEG4EI16_V_MF2_M2, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3129
  { PseudoVLOXSEG4EI16_V_MF2_M2_MASK, VLOXSEG4EI16_V, 0x1, 0x0 }, // 3130
  { PseudoVLOXSEG4EI16_V_MF4_MF8, VLOXSEG4EI16_V, 0x5, 0x0 }, // 3131
  { PseudoVLOXSEG4EI16_V_MF4_MF8_MASK, VLOXSEG4EI16_V, 0x5, 0x0 }, // 3132
  { PseudoVLOXSEG4EI16_V_MF2_MF4, VLOXSEG4EI16_V, 0x6, 0x0 }, // 3133
  { PseudoVLOXSEG4EI16_V_MF2_MF4_MASK, VLOXSEG4EI16_V, 0x6, 0x0 }, // 3134
  { PseudoVLOXSEG4EI16_V_MF4_MF4, VLOXSEG4EI16_V, 0x6, 0x0 }, // 3135
  { PseudoVLOXSEG4EI16_V_MF4_MF4_MASK, VLOXSEG4EI16_V, 0x6, 0x0 }, // 3136
  { PseudoVLOXSEG4EI16_V_M1_MF2, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3137
  { PseudoVLOXSEG4EI16_V_M1_MF2_MASK, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3138
  { PseudoVLOXSEG4EI16_V_MF2_MF2, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3139
  { PseudoVLOXSEG4EI16_V_MF2_MF2_MASK, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3140
  { PseudoVLOXSEG4EI16_V_MF4_MF2, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3141
  { PseudoVLOXSEG4EI16_V_MF4_MF2_MASK, VLOXSEG4EI16_V, 0x7, 0x0 }, // 3142
  { PseudoVLOXSEG4EI32_V_M1_M1, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3143
  { PseudoVLOXSEG4EI32_V_M1_M1_MASK, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3144
  { PseudoVLOXSEG4EI32_V_M2_M1, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3145
  { PseudoVLOXSEG4EI32_V_M2_M1_MASK, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3146
  { PseudoVLOXSEG4EI32_V_M4_M1, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3147
  { PseudoVLOXSEG4EI32_V_M4_M1_MASK, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3148
  { PseudoVLOXSEG4EI32_V_MF2_M1, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3149
  { PseudoVLOXSEG4EI32_V_MF2_M1_MASK, VLOXSEG4EI32_V, 0x0, 0x0 }, // 3150
  { PseudoVLOXSEG4EI32_V_M1_M2, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3151
  { PseudoVLOXSEG4EI32_V_M1_M2_MASK, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3152
  { PseudoVLOXSEG4EI32_V_M2_M2, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3153
  { PseudoVLOXSEG4EI32_V_M2_M2_MASK, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3154
  { PseudoVLOXSEG4EI32_V_M4_M2, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3155
  { PseudoVLOXSEG4EI32_V_M4_M2_MASK, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3156
  { PseudoVLOXSEG4EI32_V_M8_M2, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3157
  { PseudoVLOXSEG4EI32_V_M8_M2_MASK, VLOXSEG4EI32_V, 0x1, 0x0 }, // 3158
  { PseudoVLOXSEG4EI32_V_MF2_MF8, VLOXSEG4EI32_V, 0x5, 0x0 }, // 3159
  { PseudoVLOXSEG4EI32_V_MF2_MF8_MASK, VLOXSEG4EI32_V, 0x5, 0x0 }, // 3160
  { PseudoVLOXSEG4EI32_V_M1_MF4, VLOXSEG4EI32_V, 0x6, 0x0 }, // 3161
  { PseudoVLOXSEG4EI32_V_M1_MF4_MASK, VLOXSEG4EI32_V, 0x6, 0x0 }, // 3162
  { PseudoVLOXSEG4EI32_V_MF2_MF4, VLOXSEG4EI32_V, 0x6, 0x0 }, // 3163
  { PseudoVLOXSEG4EI32_V_MF2_MF4_MASK, VLOXSEG4EI32_V, 0x6, 0x0 }, // 3164
  { PseudoVLOXSEG4EI32_V_M1_MF2, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3165
  { PseudoVLOXSEG4EI32_V_M1_MF2_MASK, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3166
  { PseudoVLOXSEG4EI32_V_M2_MF2, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3167
  { PseudoVLOXSEG4EI32_V_M2_MF2_MASK, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3168
  { PseudoVLOXSEG4EI32_V_MF2_MF2, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3169
  { PseudoVLOXSEG4EI32_V_MF2_MF2_MASK, VLOXSEG4EI32_V, 0x7, 0x0 }, // 3170
  { PseudoVLOXSEG4EI64_V_M1_M1, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3171
  { PseudoVLOXSEG4EI64_V_M1_M1_MASK, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3172
  { PseudoVLOXSEG4EI64_V_M2_M1, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3173
  { PseudoVLOXSEG4EI64_V_M2_M1_MASK, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3174
  { PseudoVLOXSEG4EI64_V_M4_M1, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3175
  { PseudoVLOXSEG4EI64_V_M4_M1_MASK, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3176
  { PseudoVLOXSEG4EI64_V_M8_M1, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3177
  { PseudoVLOXSEG4EI64_V_M8_M1_MASK, VLOXSEG4EI64_V, 0x0, 0x0 }, // 3178
  { PseudoVLOXSEG4EI64_V_M2_M2, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3179
  { PseudoVLOXSEG4EI64_V_M2_M2_MASK, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3180
  { PseudoVLOXSEG4EI64_V_M4_M2, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3181
  { PseudoVLOXSEG4EI64_V_M4_M2_MASK, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3182
  { PseudoVLOXSEG4EI64_V_M8_M2, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3183
  { PseudoVLOXSEG4EI64_V_M8_M2_MASK, VLOXSEG4EI64_V, 0x1, 0x0 }, // 3184
  { PseudoVLOXSEG4EI64_V_M1_MF8, VLOXSEG4EI64_V, 0x5, 0x0 }, // 3185
  { PseudoVLOXSEG4EI64_V_M1_MF8_MASK, VLOXSEG4EI64_V, 0x5, 0x0 }, // 3186
  { PseudoVLOXSEG4EI64_V_M1_MF4, VLOXSEG4EI64_V, 0x6, 0x0 }, // 3187
  { PseudoVLOXSEG4EI64_V_M1_MF4_MASK, VLOXSEG4EI64_V, 0x6, 0x0 }, // 3188
  { PseudoVLOXSEG4EI64_V_M2_MF4, VLOXSEG4EI64_V, 0x6, 0x0 }, // 3189
  { PseudoVLOXSEG4EI64_V_M2_MF4_MASK, VLOXSEG4EI64_V, 0x6, 0x0 }, // 3190
  { PseudoVLOXSEG4EI64_V_M1_MF2, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3191
  { PseudoVLOXSEG4EI64_V_M1_MF2_MASK, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3192
  { PseudoVLOXSEG4EI64_V_M2_MF2, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3193
  { PseudoVLOXSEG4EI64_V_M2_MF2_MASK, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3194
  { PseudoVLOXSEG4EI64_V_M4_MF2, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3195
  { PseudoVLOXSEG4EI64_V_M4_MF2_MASK, VLOXSEG4EI64_V, 0x7, 0x0 }, // 3196
  { PseudoVLOXSEG4EI8_V_M1_M1, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3197
  { PseudoVLOXSEG4EI8_V_M1_M1_MASK, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3198
  { PseudoVLOXSEG4EI8_V_MF2_M1, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3199
  { PseudoVLOXSEG4EI8_V_MF2_M1_MASK, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3200
  { PseudoVLOXSEG4EI8_V_MF4_M1, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3201
  { PseudoVLOXSEG4EI8_V_MF4_M1_MASK, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3202
  { PseudoVLOXSEG4EI8_V_MF8_M1, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3203
  { PseudoVLOXSEG4EI8_V_MF8_M1_MASK, VLOXSEG4EI8_V, 0x0, 0x0 }, // 3204
  { PseudoVLOXSEG4EI8_V_M1_M2, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3205
  { PseudoVLOXSEG4EI8_V_M1_M2_MASK, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3206
  { PseudoVLOXSEG4EI8_V_M2_M2, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3207
  { PseudoVLOXSEG4EI8_V_M2_M2_MASK, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3208
  { PseudoVLOXSEG4EI8_V_MF2_M2, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3209
  { PseudoVLOXSEG4EI8_V_MF2_M2_MASK, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3210
  { PseudoVLOXSEG4EI8_V_MF4_M2, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3211
  { PseudoVLOXSEG4EI8_V_MF4_M2_MASK, VLOXSEG4EI8_V, 0x1, 0x0 }, // 3212
  { PseudoVLOXSEG4EI8_V_MF8_MF8, VLOXSEG4EI8_V, 0x5, 0x0 }, // 3213
  { PseudoVLOXSEG4EI8_V_MF8_MF8_MASK, VLOXSEG4EI8_V, 0x5, 0x0 }, // 3214
  { PseudoVLOXSEG4EI8_V_MF4_MF4, VLOXSEG4EI8_V, 0x6, 0x0 }, // 3215
  { PseudoVLOXSEG4EI8_V_MF4_MF4_MASK, VLOXSEG4EI8_V, 0x6, 0x0 }, // 3216
  { PseudoVLOXSEG4EI8_V_MF8_MF4, VLOXSEG4EI8_V, 0x6, 0x0 }, // 3217
  { PseudoVLOXSEG4EI8_V_MF8_MF4_MASK, VLOXSEG4EI8_V, 0x6, 0x0 }, // 3218
  { PseudoVLOXSEG4EI8_V_MF2_MF2, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3219
  { PseudoVLOXSEG4EI8_V_MF2_MF2_MASK, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3220
  { PseudoVLOXSEG4EI8_V_MF4_MF2, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3221
  { PseudoVLOXSEG4EI8_V_MF4_MF2_MASK, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3222
  { PseudoVLOXSEG4EI8_V_MF8_MF2, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3223
  { PseudoVLOXSEG4EI8_V_MF8_MF2_MASK, VLOXSEG4EI8_V, 0x7, 0x0 }, // 3224
  { PseudoVLOXSEG5EI16_V_M1_M1, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3225
  { PseudoVLOXSEG5EI16_V_M1_M1_MASK, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3226
  { PseudoVLOXSEG5EI16_V_M2_M1, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3227
  { PseudoVLOXSEG5EI16_V_M2_M1_MASK, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3228
  { PseudoVLOXSEG5EI16_V_MF2_M1, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3229
  { PseudoVLOXSEG5EI16_V_MF2_M1_MASK, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3230
  { PseudoVLOXSEG5EI16_V_MF4_M1, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3231
  { PseudoVLOXSEG5EI16_V_MF4_M1_MASK, VLOXSEG5EI16_V, 0x0, 0x0 }, // 3232
  { PseudoVLOXSEG5EI16_V_MF4_MF8, VLOXSEG5EI16_V, 0x5, 0x0 }, // 3233
  { PseudoVLOXSEG5EI16_V_MF4_MF8_MASK, VLOXSEG5EI16_V, 0x5, 0x0 }, // 3234
  { PseudoVLOXSEG5EI16_V_MF2_MF4, VLOXSEG5EI16_V, 0x6, 0x0 }, // 3235
  { PseudoVLOXSEG5EI16_V_MF2_MF4_MASK, VLOXSEG5EI16_V, 0x6, 0x0 }, // 3236
  { PseudoVLOXSEG5EI16_V_MF4_MF4, VLOXSEG5EI16_V, 0x6, 0x0 }, // 3237
  { PseudoVLOXSEG5EI16_V_MF4_MF4_MASK, VLOXSEG5EI16_V, 0x6, 0x0 }, // 3238
  { PseudoVLOXSEG5EI16_V_M1_MF2, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3239
  { PseudoVLOXSEG5EI16_V_M1_MF2_MASK, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3240
  { PseudoVLOXSEG5EI16_V_MF2_MF2, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3241
  { PseudoVLOXSEG5EI16_V_MF2_MF2_MASK, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3242
  { PseudoVLOXSEG5EI16_V_MF4_MF2, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3243
  { PseudoVLOXSEG5EI16_V_MF4_MF2_MASK, VLOXSEG5EI16_V, 0x7, 0x0 }, // 3244
  { PseudoVLOXSEG5EI32_V_M1_M1, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3245
  { PseudoVLOXSEG5EI32_V_M1_M1_MASK, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3246
  { PseudoVLOXSEG5EI32_V_M2_M1, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3247
  { PseudoVLOXSEG5EI32_V_M2_M1_MASK, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3248
  { PseudoVLOXSEG5EI32_V_M4_M1, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3249
  { PseudoVLOXSEG5EI32_V_M4_M1_MASK, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3250
  { PseudoVLOXSEG5EI32_V_MF2_M1, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3251
  { PseudoVLOXSEG5EI32_V_MF2_M1_MASK, VLOXSEG5EI32_V, 0x0, 0x0 }, // 3252
  { PseudoVLOXSEG5EI32_V_MF2_MF8, VLOXSEG5EI32_V, 0x5, 0x0 }, // 3253
  { PseudoVLOXSEG5EI32_V_MF2_MF8_MASK, VLOXSEG5EI32_V, 0x5, 0x0 }, // 3254
  { PseudoVLOXSEG5EI32_V_M1_MF4, VLOXSEG5EI32_V, 0x6, 0x0 }, // 3255
  { PseudoVLOXSEG5EI32_V_M1_MF4_MASK, VLOXSEG5EI32_V, 0x6, 0x0 }, // 3256
  { PseudoVLOXSEG5EI32_V_MF2_MF4, VLOXSEG5EI32_V, 0x6, 0x0 }, // 3257
  { PseudoVLOXSEG5EI32_V_MF2_MF4_MASK, VLOXSEG5EI32_V, 0x6, 0x0 }, // 3258
  { PseudoVLOXSEG5EI32_V_M1_MF2, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3259
  { PseudoVLOXSEG5EI32_V_M1_MF2_MASK, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3260
  { PseudoVLOXSEG5EI32_V_M2_MF2, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3261
  { PseudoVLOXSEG5EI32_V_M2_MF2_MASK, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3262
  { PseudoVLOXSEG5EI32_V_MF2_MF2, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3263
  { PseudoVLOXSEG5EI32_V_MF2_MF2_MASK, VLOXSEG5EI32_V, 0x7, 0x0 }, // 3264
  { PseudoVLOXSEG5EI64_V_M1_M1, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3265
  { PseudoVLOXSEG5EI64_V_M1_M1_MASK, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3266
  { PseudoVLOXSEG5EI64_V_M2_M1, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3267
  { PseudoVLOXSEG5EI64_V_M2_M1_MASK, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3268
  { PseudoVLOXSEG5EI64_V_M4_M1, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3269
  { PseudoVLOXSEG5EI64_V_M4_M1_MASK, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3270
  { PseudoVLOXSEG5EI64_V_M8_M1, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3271
  { PseudoVLOXSEG5EI64_V_M8_M1_MASK, VLOXSEG5EI64_V, 0x0, 0x0 }, // 3272
  { PseudoVLOXSEG5EI64_V_M1_MF8, VLOXSEG5EI64_V, 0x5, 0x0 }, // 3273
  { PseudoVLOXSEG5EI64_V_M1_MF8_MASK, VLOXSEG5EI64_V, 0x5, 0x0 }, // 3274
  { PseudoVLOXSEG5EI64_V_M1_MF4, VLOXSEG5EI64_V, 0x6, 0x0 }, // 3275
  { PseudoVLOXSEG5EI64_V_M1_MF4_MASK, VLOXSEG5EI64_V, 0x6, 0x0 }, // 3276
  { PseudoVLOXSEG5EI64_V_M2_MF4, VLOXSEG5EI64_V, 0x6, 0x0 }, // 3277
  { PseudoVLOXSEG5EI64_V_M2_MF4_MASK, VLOXSEG5EI64_V, 0x6, 0x0 }, // 3278
  { PseudoVLOXSEG5EI64_V_M1_MF2, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3279
  { PseudoVLOXSEG5EI64_V_M1_MF2_MASK, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3280
  { PseudoVLOXSEG5EI64_V_M2_MF2, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3281
  { PseudoVLOXSEG5EI64_V_M2_MF2_MASK, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3282
  { PseudoVLOXSEG5EI64_V_M4_MF2, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3283
  { PseudoVLOXSEG5EI64_V_M4_MF2_MASK, VLOXSEG5EI64_V, 0x7, 0x0 }, // 3284
  { PseudoVLOXSEG5EI8_V_M1_M1, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3285
  { PseudoVLOXSEG5EI8_V_M1_M1_MASK, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3286
  { PseudoVLOXSEG5EI8_V_MF2_M1, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3287
  { PseudoVLOXSEG5EI8_V_MF2_M1_MASK, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3288
  { PseudoVLOXSEG5EI8_V_MF4_M1, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3289
  { PseudoVLOXSEG5EI8_V_MF4_M1_MASK, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3290
  { PseudoVLOXSEG5EI8_V_MF8_M1, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3291
  { PseudoVLOXSEG5EI8_V_MF8_M1_MASK, VLOXSEG5EI8_V, 0x0, 0x0 }, // 3292
  { PseudoVLOXSEG5EI8_V_MF8_MF8, VLOXSEG5EI8_V, 0x5, 0x0 }, // 3293
  { PseudoVLOXSEG5EI8_V_MF8_MF8_MASK, VLOXSEG5EI8_V, 0x5, 0x0 }, // 3294
  { PseudoVLOXSEG5EI8_V_MF4_MF4, VLOXSEG5EI8_V, 0x6, 0x0 }, // 3295
  { PseudoVLOXSEG5EI8_V_MF4_MF4_MASK, VLOXSEG5EI8_V, 0x6, 0x0 }, // 3296
  { PseudoVLOXSEG5EI8_V_MF8_MF4, VLOXSEG5EI8_V, 0x6, 0x0 }, // 3297
  { PseudoVLOXSEG5EI8_V_MF8_MF4_MASK, VLOXSEG5EI8_V, 0x6, 0x0 }, // 3298
  { PseudoVLOXSEG5EI8_V_MF2_MF2, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3299
  { PseudoVLOXSEG5EI8_V_MF2_MF2_MASK, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3300
  { PseudoVLOXSEG5EI8_V_MF4_MF2, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3301
  { PseudoVLOXSEG5EI8_V_MF4_MF2_MASK, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3302
  { PseudoVLOXSEG5EI8_V_MF8_MF2, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3303
  { PseudoVLOXSEG5EI8_V_MF8_MF2_MASK, VLOXSEG5EI8_V, 0x7, 0x0 }, // 3304
  { PseudoVLOXSEG6EI16_V_M1_M1, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3305
  { PseudoVLOXSEG6EI16_V_M1_M1_MASK, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3306
  { PseudoVLOXSEG6EI16_V_M2_M1, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3307
  { PseudoVLOXSEG6EI16_V_M2_M1_MASK, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3308
  { PseudoVLOXSEG6EI16_V_MF2_M1, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3309
  { PseudoVLOXSEG6EI16_V_MF2_M1_MASK, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3310
  { PseudoVLOXSEG6EI16_V_MF4_M1, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3311
  { PseudoVLOXSEG6EI16_V_MF4_M1_MASK, VLOXSEG6EI16_V, 0x0, 0x0 }, // 3312
  { PseudoVLOXSEG6EI16_V_MF4_MF8, VLOXSEG6EI16_V, 0x5, 0x0 }, // 3313
  { PseudoVLOXSEG6EI16_V_MF4_MF8_MASK, VLOXSEG6EI16_V, 0x5, 0x0 }, // 3314
  { PseudoVLOXSEG6EI16_V_MF2_MF4, VLOXSEG6EI16_V, 0x6, 0x0 }, // 3315
  { PseudoVLOXSEG6EI16_V_MF2_MF4_MASK, VLOXSEG6EI16_V, 0x6, 0x0 }, // 3316
  { PseudoVLOXSEG6EI16_V_MF4_MF4, VLOXSEG6EI16_V, 0x6, 0x0 }, // 3317
  { PseudoVLOXSEG6EI16_V_MF4_MF4_MASK, VLOXSEG6EI16_V, 0x6, 0x0 }, // 3318
  { PseudoVLOXSEG6EI16_V_M1_MF2, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3319
  { PseudoVLOXSEG6EI16_V_M1_MF2_MASK, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3320
  { PseudoVLOXSEG6EI16_V_MF2_MF2, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3321
  { PseudoVLOXSEG6EI16_V_MF2_MF2_MASK, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3322
  { PseudoVLOXSEG6EI16_V_MF4_MF2, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3323
  { PseudoVLOXSEG6EI16_V_MF4_MF2_MASK, VLOXSEG6EI16_V, 0x7, 0x0 }, // 3324
  { PseudoVLOXSEG6EI32_V_M1_M1, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3325
  { PseudoVLOXSEG6EI32_V_M1_M1_MASK, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3326
  { PseudoVLOXSEG6EI32_V_M2_M1, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3327
  { PseudoVLOXSEG6EI32_V_M2_M1_MASK, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3328
  { PseudoVLOXSEG6EI32_V_M4_M1, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3329
  { PseudoVLOXSEG6EI32_V_M4_M1_MASK, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3330
  { PseudoVLOXSEG6EI32_V_MF2_M1, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3331
  { PseudoVLOXSEG6EI32_V_MF2_M1_MASK, VLOXSEG6EI32_V, 0x0, 0x0 }, // 3332
  { PseudoVLOXSEG6EI32_V_MF2_MF8, VLOXSEG6EI32_V, 0x5, 0x0 }, // 3333
  { PseudoVLOXSEG6EI32_V_MF2_MF8_MASK, VLOXSEG6EI32_V, 0x5, 0x0 }, // 3334
  { PseudoVLOXSEG6EI32_V_M1_MF4, VLOXSEG6EI32_V, 0x6, 0x0 }, // 3335
  { PseudoVLOXSEG6EI32_V_M1_MF4_MASK, VLOXSEG6EI32_V, 0x6, 0x0 }, // 3336
  { PseudoVLOXSEG6EI32_V_MF2_MF4, VLOXSEG6EI32_V, 0x6, 0x0 }, // 3337
  { PseudoVLOXSEG6EI32_V_MF2_MF4_MASK, VLOXSEG6EI32_V, 0x6, 0x0 }, // 3338
  { PseudoVLOXSEG6EI32_V_M1_MF2, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3339
  { PseudoVLOXSEG6EI32_V_M1_MF2_MASK, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3340
  { PseudoVLOXSEG6EI32_V_M2_MF2, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3341
  { PseudoVLOXSEG6EI32_V_M2_MF2_MASK, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3342
  { PseudoVLOXSEG6EI32_V_MF2_MF2, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3343
  { PseudoVLOXSEG6EI32_V_MF2_MF2_MASK, VLOXSEG6EI32_V, 0x7, 0x0 }, // 3344
  { PseudoVLOXSEG6EI64_V_M1_M1, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3345
  { PseudoVLOXSEG6EI64_V_M1_M1_MASK, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3346
  { PseudoVLOXSEG6EI64_V_M2_M1, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3347
  { PseudoVLOXSEG6EI64_V_M2_M1_MASK, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3348
  { PseudoVLOXSEG6EI64_V_M4_M1, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3349
  { PseudoVLOXSEG6EI64_V_M4_M1_MASK, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3350
  { PseudoVLOXSEG6EI64_V_M8_M1, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3351
  { PseudoVLOXSEG6EI64_V_M8_M1_MASK, VLOXSEG6EI64_V, 0x0, 0x0 }, // 3352
  { PseudoVLOXSEG6EI64_V_M1_MF8, VLOXSEG6EI64_V, 0x5, 0x0 }, // 3353
  { PseudoVLOXSEG6EI64_V_M1_MF8_MASK, VLOXSEG6EI64_V, 0x5, 0x0 }, // 3354
  { PseudoVLOXSEG6EI64_V_M1_MF4, VLOXSEG6EI64_V, 0x6, 0x0 }, // 3355
  { PseudoVLOXSEG6EI64_V_M1_MF4_MASK, VLOXSEG6EI64_V, 0x6, 0x0 }, // 3356
  { PseudoVLOXSEG6EI64_V_M2_MF4, VLOXSEG6EI64_V, 0x6, 0x0 }, // 3357
  { PseudoVLOXSEG6EI64_V_M2_MF4_MASK, VLOXSEG6EI64_V, 0x6, 0x0 }, // 3358
  { PseudoVLOXSEG6EI64_V_M1_MF2, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3359
  { PseudoVLOXSEG6EI64_V_M1_MF2_MASK, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3360
  { PseudoVLOXSEG6EI64_V_M2_MF2, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3361
  { PseudoVLOXSEG6EI64_V_M2_MF2_MASK, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3362
  { PseudoVLOXSEG6EI64_V_M4_MF2, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3363
  { PseudoVLOXSEG6EI64_V_M4_MF2_MASK, VLOXSEG6EI64_V, 0x7, 0x0 }, // 3364
  { PseudoVLOXSEG6EI8_V_M1_M1, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3365
  { PseudoVLOXSEG6EI8_V_M1_M1_MASK, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3366
  { PseudoVLOXSEG6EI8_V_MF2_M1, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3367
  { PseudoVLOXSEG6EI8_V_MF2_M1_MASK, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3368
  { PseudoVLOXSEG6EI8_V_MF4_M1, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3369
  { PseudoVLOXSEG6EI8_V_MF4_M1_MASK, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3370
  { PseudoVLOXSEG6EI8_V_MF8_M1, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3371
  { PseudoVLOXSEG6EI8_V_MF8_M1_MASK, VLOXSEG6EI8_V, 0x0, 0x0 }, // 3372
  { PseudoVLOXSEG6EI8_V_MF8_MF8, VLOXSEG6EI8_V, 0x5, 0x0 }, // 3373
  { PseudoVLOXSEG6EI8_V_MF8_MF8_MASK, VLOXSEG6EI8_V, 0x5, 0x0 }, // 3374
  { PseudoVLOXSEG6EI8_V_MF4_MF4, VLOXSEG6EI8_V, 0x6, 0x0 }, // 3375
  { PseudoVLOXSEG6EI8_V_MF4_MF4_MASK, VLOXSEG6EI8_V, 0x6, 0x0 }, // 3376
  { PseudoVLOXSEG6EI8_V_MF8_MF4, VLOXSEG6EI8_V, 0x6, 0x0 }, // 3377
  { PseudoVLOXSEG6EI8_V_MF8_MF4_MASK, VLOXSEG6EI8_V, 0x6, 0x0 }, // 3378
  { PseudoVLOXSEG6EI8_V_MF2_MF2, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3379
  { PseudoVLOXSEG6EI8_V_MF2_MF2_MASK, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3380
  { PseudoVLOXSEG6EI8_V_MF4_MF2, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3381
  { PseudoVLOXSEG6EI8_V_MF4_MF2_MASK, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3382
  { PseudoVLOXSEG6EI8_V_MF8_MF2, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3383
  { PseudoVLOXSEG6EI8_V_MF8_MF2_MASK, VLOXSEG6EI8_V, 0x7, 0x0 }, // 3384
  { PseudoVLOXSEG7EI16_V_M1_M1, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3385
  { PseudoVLOXSEG7EI16_V_M1_M1_MASK, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3386
  { PseudoVLOXSEG7EI16_V_M2_M1, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3387
  { PseudoVLOXSEG7EI16_V_M2_M1_MASK, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3388
  { PseudoVLOXSEG7EI16_V_MF2_M1, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3389
  { PseudoVLOXSEG7EI16_V_MF2_M1_MASK, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3390
  { PseudoVLOXSEG7EI16_V_MF4_M1, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3391
  { PseudoVLOXSEG7EI16_V_MF4_M1_MASK, VLOXSEG7EI16_V, 0x0, 0x0 }, // 3392
  { PseudoVLOXSEG7EI16_V_MF4_MF8, VLOXSEG7EI16_V, 0x5, 0x0 }, // 3393
  { PseudoVLOXSEG7EI16_V_MF4_MF8_MASK, VLOXSEG7EI16_V, 0x5, 0x0 }, // 3394
  { PseudoVLOXSEG7EI16_V_MF2_MF4, VLOXSEG7EI16_V, 0x6, 0x0 }, // 3395
  { PseudoVLOXSEG7EI16_V_MF2_MF4_MASK, VLOXSEG7EI16_V, 0x6, 0x0 }, // 3396
  { PseudoVLOXSEG7EI16_V_MF4_MF4, VLOXSEG7EI16_V, 0x6, 0x0 }, // 3397
  { PseudoVLOXSEG7EI16_V_MF4_MF4_MASK, VLOXSEG7EI16_V, 0x6, 0x0 }, // 3398
  { PseudoVLOXSEG7EI16_V_M1_MF2, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3399
  { PseudoVLOXSEG7EI16_V_M1_MF2_MASK, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3400
  { PseudoVLOXSEG7EI16_V_MF2_MF2, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3401
  { PseudoVLOXSEG7EI16_V_MF2_MF2_MASK, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3402
  { PseudoVLOXSEG7EI16_V_MF4_MF2, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3403
  { PseudoVLOXSEG7EI16_V_MF4_MF2_MASK, VLOXSEG7EI16_V, 0x7, 0x0 }, // 3404
  { PseudoVLOXSEG7EI32_V_M1_M1, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3405
  { PseudoVLOXSEG7EI32_V_M1_M1_MASK, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3406
  { PseudoVLOXSEG7EI32_V_M2_M1, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3407
  { PseudoVLOXSEG7EI32_V_M2_M1_MASK, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3408
  { PseudoVLOXSEG7EI32_V_M4_M1, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3409
  { PseudoVLOXSEG7EI32_V_M4_M1_MASK, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3410
  { PseudoVLOXSEG7EI32_V_MF2_M1, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3411
  { PseudoVLOXSEG7EI32_V_MF2_M1_MASK, VLOXSEG7EI32_V, 0x0, 0x0 }, // 3412
  { PseudoVLOXSEG7EI32_V_MF2_MF8, VLOXSEG7EI32_V, 0x5, 0x0 }, // 3413
  { PseudoVLOXSEG7EI32_V_MF2_MF8_MASK, VLOXSEG7EI32_V, 0x5, 0x0 }, // 3414
  { PseudoVLOXSEG7EI32_V_M1_MF4, VLOXSEG7EI32_V, 0x6, 0x0 }, // 3415
  { PseudoVLOXSEG7EI32_V_M1_MF4_MASK, VLOXSEG7EI32_V, 0x6, 0x0 }, // 3416
  { PseudoVLOXSEG7EI32_V_MF2_MF4, VLOXSEG7EI32_V, 0x6, 0x0 }, // 3417
  { PseudoVLOXSEG7EI32_V_MF2_MF4_MASK, VLOXSEG7EI32_V, 0x6, 0x0 }, // 3418
  { PseudoVLOXSEG7EI32_V_M1_MF2, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3419
  { PseudoVLOXSEG7EI32_V_M1_MF2_MASK, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3420
  { PseudoVLOXSEG7EI32_V_M2_MF2, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3421
  { PseudoVLOXSEG7EI32_V_M2_MF2_MASK, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3422
  { PseudoVLOXSEG7EI32_V_MF2_MF2, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3423
  { PseudoVLOXSEG7EI32_V_MF2_MF2_MASK, VLOXSEG7EI32_V, 0x7, 0x0 }, // 3424
  { PseudoVLOXSEG7EI64_V_M1_M1, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3425
  { PseudoVLOXSEG7EI64_V_M1_M1_MASK, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3426
  { PseudoVLOXSEG7EI64_V_M2_M1, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3427
  { PseudoVLOXSEG7EI64_V_M2_M1_MASK, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3428
  { PseudoVLOXSEG7EI64_V_M4_M1, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3429
  { PseudoVLOXSEG7EI64_V_M4_M1_MASK, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3430
  { PseudoVLOXSEG7EI64_V_M8_M1, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3431
  { PseudoVLOXSEG7EI64_V_M8_M1_MASK, VLOXSEG7EI64_V, 0x0, 0x0 }, // 3432
  { PseudoVLOXSEG7EI64_V_M1_MF8, VLOXSEG7EI64_V, 0x5, 0x0 }, // 3433
  { PseudoVLOXSEG7EI64_V_M1_MF8_MASK, VLOXSEG7EI64_V, 0x5, 0x0 }, // 3434
  { PseudoVLOXSEG7EI64_V_M1_MF4, VLOXSEG7EI64_V, 0x6, 0x0 }, // 3435
  { PseudoVLOXSEG7EI64_V_M1_MF4_MASK, VLOXSEG7EI64_V, 0x6, 0x0 }, // 3436
  { PseudoVLOXSEG7EI64_V_M2_MF4, VLOXSEG7EI64_V, 0x6, 0x0 }, // 3437
  { PseudoVLOXSEG7EI64_V_M2_MF4_MASK, VLOXSEG7EI64_V, 0x6, 0x0 }, // 3438
  { PseudoVLOXSEG7EI64_V_M1_MF2, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3439
  { PseudoVLOXSEG7EI64_V_M1_MF2_MASK, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3440
  { PseudoVLOXSEG7EI64_V_M2_MF2, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3441
  { PseudoVLOXSEG7EI64_V_M2_MF2_MASK, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3442
  { PseudoVLOXSEG7EI64_V_M4_MF2, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3443
  { PseudoVLOXSEG7EI64_V_M4_MF2_MASK, VLOXSEG7EI64_V, 0x7, 0x0 }, // 3444
  { PseudoVLOXSEG7EI8_V_M1_M1, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3445
  { PseudoVLOXSEG7EI8_V_M1_M1_MASK, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3446
  { PseudoVLOXSEG7EI8_V_MF2_M1, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3447
  { PseudoVLOXSEG7EI8_V_MF2_M1_MASK, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3448
  { PseudoVLOXSEG7EI8_V_MF4_M1, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3449
  { PseudoVLOXSEG7EI8_V_MF4_M1_MASK, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3450
  { PseudoVLOXSEG7EI8_V_MF8_M1, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3451
  { PseudoVLOXSEG7EI8_V_MF8_M1_MASK, VLOXSEG7EI8_V, 0x0, 0x0 }, // 3452
  { PseudoVLOXSEG7EI8_V_MF8_MF8, VLOXSEG7EI8_V, 0x5, 0x0 }, // 3453
  { PseudoVLOXSEG7EI8_V_MF8_MF8_MASK, VLOXSEG7EI8_V, 0x5, 0x0 }, // 3454
  { PseudoVLOXSEG7EI8_V_MF4_MF4, VLOXSEG7EI8_V, 0x6, 0x0 }, // 3455
  { PseudoVLOXSEG7EI8_V_MF4_MF4_MASK, VLOXSEG7EI8_V, 0x6, 0x0 }, // 3456
  { PseudoVLOXSEG7EI8_V_MF8_MF4, VLOXSEG7EI8_V, 0x6, 0x0 }, // 3457
  { PseudoVLOXSEG7EI8_V_MF8_MF4_MASK, VLOXSEG7EI8_V, 0x6, 0x0 }, // 3458
  { PseudoVLOXSEG7EI8_V_MF2_MF2, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3459
  { PseudoVLOXSEG7EI8_V_MF2_MF2_MASK, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3460
  { PseudoVLOXSEG7EI8_V_MF4_MF2, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3461
  { PseudoVLOXSEG7EI8_V_MF4_MF2_MASK, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3462
  { PseudoVLOXSEG7EI8_V_MF8_MF2, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3463
  { PseudoVLOXSEG7EI8_V_MF8_MF2_MASK, VLOXSEG7EI8_V, 0x7, 0x0 }, // 3464
  { PseudoVLOXSEG8EI16_V_M1_M1, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3465
  { PseudoVLOXSEG8EI16_V_M1_M1_MASK, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3466
  { PseudoVLOXSEG8EI16_V_M2_M1, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3467
  { PseudoVLOXSEG8EI16_V_M2_M1_MASK, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3468
  { PseudoVLOXSEG8EI16_V_MF2_M1, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3469
  { PseudoVLOXSEG8EI16_V_MF2_M1_MASK, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3470
  { PseudoVLOXSEG8EI16_V_MF4_M1, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3471
  { PseudoVLOXSEG8EI16_V_MF4_M1_MASK, VLOXSEG8EI16_V, 0x0, 0x0 }, // 3472
  { PseudoVLOXSEG8EI16_V_MF4_MF8, VLOXSEG8EI16_V, 0x5, 0x0 }, // 3473
  { PseudoVLOXSEG8EI16_V_MF4_MF8_MASK, VLOXSEG8EI16_V, 0x5, 0x0 }, // 3474
  { PseudoVLOXSEG8EI16_V_MF2_MF4, VLOXSEG8EI16_V, 0x6, 0x0 }, // 3475
  { PseudoVLOXSEG8EI16_V_MF2_MF4_MASK, VLOXSEG8EI16_V, 0x6, 0x0 }, // 3476
  { PseudoVLOXSEG8EI16_V_MF4_MF4, VLOXSEG8EI16_V, 0x6, 0x0 }, // 3477
  { PseudoVLOXSEG8EI16_V_MF4_MF4_MASK, VLOXSEG8EI16_V, 0x6, 0x0 }, // 3478
  { PseudoVLOXSEG8EI16_V_M1_MF2, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3479
  { PseudoVLOXSEG8EI16_V_M1_MF2_MASK, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3480
  { PseudoVLOXSEG8EI16_V_MF2_MF2, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3481
  { PseudoVLOXSEG8EI16_V_MF2_MF2_MASK, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3482
  { PseudoVLOXSEG8EI16_V_MF4_MF2, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3483
  { PseudoVLOXSEG8EI16_V_MF4_MF2_MASK, VLOXSEG8EI16_V, 0x7, 0x0 }, // 3484
  { PseudoVLOXSEG8EI32_V_M1_M1, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3485
  { PseudoVLOXSEG8EI32_V_M1_M1_MASK, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3486
  { PseudoVLOXSEG8EI32_V_M2_M1, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3487
  { PseudoVLOXSEG8EI32_V_M2_M1_MASK, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3488
  { PseudoVLOXSEG8EI32_V_M4_M1, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3489
  { PseudoVLOXSEG8EI32_V_M4_M1_MASK, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3490
  { PseudoVLOXSEG8EI32_V_MF2_M1, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3491
  { PseudoVLOXSEG8EI32_V_MF2_M1_MASK, VLOXSEG8EI32_V, 0x0, 0x0 }, // 3492
  { PseudoVLOXSEG8EI32_V_MF2_MF8, VLOXSEG8EI32_V, 0x5, 0x0 }, // 3493
  { PseudoVLOXSEG8EI32_V_MF2_MF8_MASK, VLOXSEG8EI32_V, 0x5, 0x0 }, // 3494
  { PseudoVLOXSEG8EI32_V_M1_MF4, VLOXSEG8EI32_V, 0x6, 0x0 }, // 3495
  { PseudoVLOXSEG8EI32_V_M1_MF4_MASK, VLOXSEG8EI32_V, 0x6, 0x0 }, // 3496
  { PseudoVLOXSEG8EI32_V_MF2_MF4, VLOXSEG8EI32_V, 0x6, 0x0 }, // 3497
  { PseudoVLOXSEG8EI32_V_MF2_MF4_MASK, VLOXSEG8EI32_V, 0x6, 0x0 }, // 3498
  { PseudoVLOXSEG8EI32_V_M1_MF2, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3499
  { PseudoVLOXSEG8EI32_V_M1_MF2_MASK, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3500
  { PseudoVLOXSEG8EI32_V_M2_MF2, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3501
  { PseudoVLOXSEG8EI32_V_M2_MF2_MASK, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3502
  { PseudoVLOXSEG8EI32_V_MF2_MF2, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3503
  { PseudoVLOXSEG8EI32_V_MF2_MF2_MASK, VLOXSEG8EI32_V, 0x7, 0x0 }, // 3504
  { PseudoVLOXSEG8EI64_V_M1_M1, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3505
  { PseudoVLOXSEG8EI64_V_M1_M1_MASK, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3506
  { PseudoVLOXSEG8EI64_V_M2_M1, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3507
  { PseudoVLOXSEG8EI64_V_M2_M1_MASK, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3508
  { PseudoVLOXSEG8EI64_V_M4_M1, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3509
  { PseudoVLOXSEG8EI64_V_M4_M1_MASK, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3510
  { PseudoVLOXSEG8EI64_V_M8_M1, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3511
  { PseudoVLOXSEG8EI64_V_M8_M1_MASK, VLOXSEG8EI64_V, 0x0, 0x0 }, // 3512
  { PseudoVLOXSEG8EI64_V_M1_MF8, VLOXSEG8EI64_V, 0x5, 0x0 }, // 3513
  { PseudoVLOXSEG8EI64_V_M1_MF8_MASK, VLOXSEG8EI64_V, 0x5, 0x0 }, // 3514
  { PseudoVLOXSEG8EI64_V_M1_MF4, VLOXSEG8EI64_V, 0x6, 0x0 }, // 3515
  { PseudoVLOXSEG8EI64_V_M1_MF4_MASK, VLOXSEG8EI64_V, 0x6, 0x0 }, // 3516
  { PseudoVLOXSEG8EI64_V_M2_MF4, VLOXSEG8EI64_V, 0x6, 0x0 }, // 3517
  { PseudoVLOXSEG8EI64_V_M2_MF4_MASK, VLOXSEG8EI64_V, 0x6, 0x0 }, // 3518
  { PseudoVLOXSEG8EI64_V_M1_MF2, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3519
  { PseudoVLOXSEG8EI64_V_M1_MF2_MASK, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3520
  { PseudoVLOXSEG8EI64_V_M2_MF2, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3521
  { PseudoVLOXSEG8EI64_V_M2_MF2_MASK, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3522
  { PseudoVLOXSEG8EI64_V_M4_MF2, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3523
  { PseudoVLOXSEG8EI64_V_M4_MF2_MASK, VLOXSEG8EI64_V, 0x7, 0x0 }, // 3524
  { PseudoVLOXSEG8EI8_V_M1_M1, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3525
  { PseudoVLOXSEG8EI8_V_M1_M1_MASK, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3526
  { PseudoVLOXSEG8EI8_V_MF2_M1, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3527
  { PseudoVLOXSEG8EI8_V_MF2_M1_MASK, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3528
  { PseudoVLOXSEG8EI8_V_MF4_M1, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3529
  { PseudoVLOXSEG8EI8_V_MF4_M1_MASK, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3530
  { PseudoVLOXSEG8EI8_V_MF8_M1, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3531
  { PseudoVLOXSEG8EI8_V_MF8_M1_MASK, VLOXSEG8EI8_V, 0x0, 0x0 }, // 3532
  { PseudoVLOXSEG8EI8_V_MF8_MF8, VLOXSEG8EI8_V, 0x5, 0x0 }, // 3533
  { PseudoVLOXSEG8EI8_V_MF8_MF8_MASK, VLOXSEG8EI8_V, 0x5, 0x0 }, // 3534
  { PseudoVLOXSEG8EI8_V_MF4_MF4, VLOXSEG8EI8_V, 0x6, 0x0 }, // 3535
  { PseudoVLOXSEG8EI8_V_MF4_MF4_MASK, VLOXSEG8EI8_V, 0x6, 0x0 }, // 3536
  { PseudoVLOXSEG8EI8_V_MF8_MF4, VLOXSEG8EI8_V, 0x6, 0x0 }, // 3537
  { PseudoVLOXSEG8EI8_V_MF8_MF4_MASK, VLOXSEG8EI8_V, 0x6, 0x0 }, // 3538
  { PseudoVLOXSEG8EI8_V_MF2_MF2, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3539
  { PseudoVLOXSEG8EI8_V_MF2_MF2_MASK, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3540
  { PseudoVLOXSEG8EI8_V_MF4_MF2, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3541
  { PseudoVLOXSEG8EI8_V_MF4_MF2_MASK, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3542
  { PseudoVLOXSEG8EI8_V_MF8_MF2, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3543
  { PseudoVLOXSEG8EI8_V_MF8_MF2_MASK, VLOXSEG8EI8_V, 0x7, 0x0 }, // 3544
  { PseudoVLSE16_V_M1, VLSE16_V, 0x0, 0x10 }, // 3545
  { PseudoVLSE16_V_M1_MASK, VLSE16_V, 0x0, 0x10 }, // 3546
  { PseudoVLSE16_V_M2, VLSE16_V, 0x1, 0x10 }, // 3547
  { PseudoVLSE16_V_M2_MASK, VLSE16_V, 0x1, 0x10 }, // 3548
  { PseudoVLSE16_V_M4, VLSE16_V, 0x2, 0x10 }, // 3549
  { PseudoVLSE16_V_M4_MASK, VLSE16_V, 0x2, 0x10 }, // 3550
  { PseudoVLSE16_V_M8, VLSE16_V, 0x3, 0x10 }, // 3551
  { PseudoVLSE16_V_M8_MASK, VLSE16_V, 0x3, 0x10 }, // 3552
  { PseudoVLSE16_V_MF4, VLSE16_V, 0x6, 0x10 }, // 3553
  { PseudoVLSE16_V_MF4_MASK, VLSE16_V, 0x6, 0x10 }, // 3554
  { PseudoVLSE16_V_MF2, VLSE16_V, 0x7, 0x10 }, // 3555
  { PseudoVLSE16_V_MF2_MASK, VLSE16_V, 0x7, 0x10 }, // 3556
  { PseudoVLSE32_V_M1, VLSE32_V, 0x0, 0x20 }, // 3557
  { PseudoVLSE32_V_M1_MASK, VLSE32_V, 0x0, 0x20 }, // 3558
  { PseudoVLSE32_V_M2, VLSE32_V, 0x1, 0x20 }, // 3559
  { PseudoVLSE32_V_M2_MASK, VLSE32_V, 0x1, 0x20 }, // 3560
  { PseudoVLSE32_V_M4, VLSE32_V, 0x2, 0x20 }, // 3561
  { PseudoVLSE32_V_M4_MASK, VLSE32_V, 0x2, 0x20 }, // 3562
  { PseudoVLSE32_V_M8, VLSE32_V, 0x3, 0x20 }, // 3563
  { PseudoVLSE32_V_M8_MASK, VLSE32_V, 0x3, 0x20 }, // 3564
  { PseudoVLSE32_V_MF2, VLSE32_V, 0x7, 0x20 }, // 3565
  { PseudoVLSE32_V_MF2_MASK, VLSE32_V, 0x7, 0x20 }, // 3566
  { PseudoVLSE64_V_M1, VLSE64_V, 0x0, 0x40 }, // 3567
  { PseudoVLSE64_V_M1_MASK, VLSE64_V, 0x0, 0x40 }, // 3568
  { PseudoVLSE64_V_M2, VLSE64_V, 0x1, 0x40 }, // 3569
  { PseudoVLSE64_V_M2_MASK, VLSE64_V, 0x1, 0x40 }, // 3570
  { PseudoVLSE64_V_M4, VLSE64_V, 0x2, 0x40 }, // 3571
  { PseudoVLSE64_V_M4_MASK, VLSE64_V, 0x2, 0x40 }, // 3572
  { PseudoVLSE64_V_M8, VLSE64_V, 0x3, 0x40 }, // 3573
  { PseudoVLSE64_V_M8_MASK, VLSE64_V, 0x3, 0x40 }, // 3574
  { PseudoVLSE8_V_M1, VLSE8_V, 0x0, 0x8 }, // 3575
  { PseudoVLSE8_V_M1_MASK, VLSE8_V, 0x0, 0x8 }, // 3576
  { PseudoVLSE8_V_M2, VLSE8_V, 0x1, 0x8 }, // 3577
  { PseudoVLSE8_V_M2_MASK, VLSE8_V, 0x1, 0x8 }, // 3578
  { PseudoVLSE8_V_M4, VLSE8_V, 0x2, 0x8 }, // 3579
  { PseudoVLSE8_V_M4_MASK, VLSE8_V, 0x2, 0x8 }, // 3580
  { PseudoVLSE8_V_M8, VLSE8_V, 0x3, 0x8 }, // 3581
  { PseudoVLSE8_V_M8_MASK, VLSE8_V, 0x3, 0x8 }, // 3582
  { PseudoVLSE8_V_MF8, VLSE8_V, 0x5, 0x8 }, // 3583
  { PseudoVLSE8_V_MF8_MASK, VLSE8_V, 0x5, 0x8 }, // 3584
  { PseudoVLSE8_V_MF4, VLSE8_V, 0x6, 0x8 }, // 3585
  { PseudoVLSE8_V_MF4_MASK, VLSE8_V, 0x6, 0x8 }, // 3586
  { PseudoVLSE8_V_MF2, VLSE8_V, 0x7, 0x8 }, // 3587
  { PseudoVLSE8_V_MF2_MASK, VLSE8_V, 0x7, 0x8 }, // 3588
  { PseudoVLSEG2E16FF_V_M1, VLSEG2E16FF_V, 0x0, 0x10 }, // 3589
  { PseudoVLSEG2E16FF_V_M1_MASK, VLSEG2E16FF_V, 0x0, 0x10 }, // 3590
  { PseudoVLSEG2E16FF_V_M2, VLSEG2E16FF_V, 0x1, 0x10 }, // 3591
  { PseudoVLSEG2E16FF_V_M2_MASK, VLSEG2E16FF_V, 0x1, 0x10 }, // 3592
  { PseudoVLSEG2E16FF_V_M4, VLSEG2E16FF_V, 0x2, 0x10 }, // 3593
  { PseudoVLSEG2E16FF_V_M4_MASK, VLSEG2E16FF_V, 0x2, 0x10 }, // 3594
  { PseudoVLSEG2E16FF_V_MF4, VLSEG2E16FF_V, 0x6, 0x10 }, // 3595
  { PseudoVLSEG2E16FF_V_MF4_MASK, VLSEG2E16FF_V, 0x6, 0x10 }, // 3596
  { PseudoVLSEG2E16FF_V_MF2, VLSEG2E16FF_V, 0x7, 0x10 }, // 3597
  { PseudoVLSEG2E16FF_V_MF2_MASK, VLSEG2E16FF_V, 0x7, 0x10 }, // 3598
  { PseudoVLSEG2E16_V_M1, VLSEG2E16_V, 0x0, 0x10 }, // 3599
  { PseudoVLSEG2E16_V_M1_MASK, VLSEG2E16_V, 0x0, 0x10 }, // 3600
  { PseudoVLSEG2E16_V_M2, VLSEG2E16_V, 0x1, 0x10 }, // 3601
  { PseudoVLSEG2E16_V_M2_MASK, VLSEG2E16_V, 0x1, 0x10 }, // 3602
  { PseudoVLSEG2E16_V_M4, VLSEG2E16_V, 0x2, 0x10 }, // 3603
  { PseudoVLSEG2E16_V_M4_MASK, VLSEG2E16_V, 0x2, 0x10 }, // 3604
  { PseudoVLSEG2E16_V_MF4, VLSEG2E16_V, 0x6, 0x10 }, // 3605
  { PseudoVLSEG2E16_V_MF4_MASK, VLSEG2E16_V, 0x6, 0x10 }, // 3606
  { PseudoVLSEG2E16_V_MF2, VLSEG2E16_V, 0x7, 0x10 }, // 3607
  { PseudoVLSEG2E16_V_MF2_MASK, VLSEG2E16_V, 0x7, 0x10 }, // 3608
  { PseudoVLSEG2E32FF_V_M1, VLSEG2E32FF_V, 0x0, 0x20 }, // 3609
  { PseudoVLSEG2E32FF_V_M1_MASK, VLSEG2E32FF_V, 0x0, 0x20 }, // 3610
  { PseudoVLSEG2E32FF_V_M2, VLSEG2E32FF_V, 0x1, 0x20 }, // 3611
  { PseudoVLSEG2E32FF_V_M2_MASK, VLSEG2E32FF_V, 0x1, 0x20 }, // 3612
  { PseudoVLSEG2E32FF_V_M4, VLSEG2E32FF_V, 0x2, 0x20 }, // 3613
  { PseudoVLSEG2E32FF_V_M4_MASK, VLSEG2E32FF_V, 0x2, 0x20 }, // 3614
  { PseudoVLSEG2E32FF_V_MF2, VLSEG2E32FF_V, 0x7, 0x20 }, // 3615
  { PseudoVLSEG2E32FF_V_MF2_MASK, VLSEG2E32FF_V, 0x7, 0x20 }, // 3616
  { PseudoVLSEG2E32_V_M1, VLSEG2E32_V, 0x0, 0x20 }, // 3617
  { PseudoVLSEG2E32_V_M1_MASK, VLSEG2E32_V, 0x0, 0x20 }, // 3618
  { PseudoVLSEG2E32_V_M2, VLSEG2E32_V, 0x1, 0x20 }, // 3619
  { PseudoVLSEG2E32_V_M2_MASK, VLSEG2E32_V, 0x1, 0x20 }, // 3620
  { PseudoVLSEG2E32_V_M4, VLSEG2E32_V, 0x2, 0x20 }, // 3621
  { PseudoVLSEG2E32_V_M4_MASK, VLSEG2E32_V, 0x2, 0x20 }, // 3622
  { PseudoVLSEG2E32_V_MF2, VLSEG2E32_V, 0x7, 0x20 }, // 3623
  { PseudoVLSEG2E32_V_MF2_MASK, VLSEG2E32_V, 0x7, 0x20 }, // 3624
  { PseudoVLSEG2E64FF_V_M1, VLSEG2E64FF_V, 0x0, 0x40 }, // 3625
  { PseudoVLSEG2E64FF_V_M1_MASK, VLSEG2E64FF_V, 0x0, 0x40 }, // 3626
  { PseudoVLSEG2E64FF_V_M2, VLSEG2E64FF_V, 0x1, 0x40 }, // 3627
  { PseudoVLSEG2E64FF_V_M2_MASK, VLSEG2E64FF_V, 0x1, 0x40 }, // 3628
  { PseudoVLSEG2E64FF_V_M4, VLSEG2E64FF_V, 0x2, 0x40 }, // 3629
  { PseudoVLSEG2E64FF_V_M4_MASK, VLSEG2E64FF_V, 0x2, 0x40 }, // 3630
  { PseudoVLSEG2E64_V_M1, VLSEG2E64_V, 0x0, 0x40 }, // 3631
  { PseudoVLSEG2E64_V_M1_MASK, VLSEG2E64_V, 0x0, 0x40 }, // 3632
  { PseudoVLSEG2E64_V_M2, VLSEG2E64_V, 0x1, 0x40 }, // 3633
  { PseudoVLSEG2E64_V_M2_MASK, VLSEG2E64_V, 0x1, 0x40 }, // 3634
  { PseudoVLSEG2E64_V_M4, VLSEG2E64_V, 0x2, 0x40 }, // 3635
  { PseudoVLSEG2E64_V_M4_MASK, VLSEG2E64_V, 0x2, 0x40 }, // 3636
  { PseudoVLSEG2E8FF_V_M1, VLSEG2E8FF_V, 0x0, 0x8 }, // 3637
  { PseudoVLSEG2E8FF_V_M1_MASK, VLSEG2E8FF_V, 0x0, 0x8 }, // 3638
  { PseudoVLSEG2E8FF_V_M2, VLSEG2E8FF_V, 0x1, 0x8 }, // 3639
  { PseudoVLSEG2E8FF_V_M2_MASK, VLSEG2E8FF_V, 0x1, 0x8 }, // 3640
  { PseudoVLSEG2E8FF_V_M4, VLSEG2E8FF_V, 0x2, 0x8 }, // 3641
  { PseudoVLSEG2E8FF_V_M4_MASK, VLSEG2E8FF_V, 0x2, 0x8 }, // 3642
  { PseudoVLSEG2E8FF_V_MF8, VLSEG2E8FF_V, 0x5, 0x8 }, // 3643
  { PseudoVLSEG2E8FF_V_MF8_MASK, VLSEG2E8FF_V, 0x5, 0x8 }, // 3644
  { PseudoVLSEG2E8FF_V_MF4, VLSEG2E8FF_V, 0x6, 0x8 }, // 3645
  { PseudoVLSEG2E8FF_V_MF4_MASK, VLSEG2E8FF_V, 0x6, 0x8 }, // 3646
  { PseudoVLSEG2E8FF_V_MF2, VLSEG2E8FF_V, 0x7, 0x8 }, // 3647
  { PseudoVLSEG2E8FF_V_MF2_MASK, VLSEG2E8FF_V, 0x7, 0x8 }, // 3648
  { PseudoVLSEG2E8_V_M1, VLSEG2E8_V, 0x0, 0x8 }, // 3649
  { PseudoVLSEG2E8_V_M1_MASK, VLSEG2E8_V, 0x0, 0x8 }, // 3650
  { PseudoVLSEG2E8_V_M2, VLSEG2E8_V, 0x1, 0x8 }, // 3651
  { PseudoVLSEG2E8_V_M2_MASK, VLSEG2E8_V, 0x1, 0x8 }, // 3652
  { PseudoVLSEG2E8_V_M4, VLSEG2E8_V, 0x2, 0x8 }, // 3653
  { PseudoVLSEG2E8_V_M4_MASK, VLSEG2E8_V, 0x2, 0x8 }, // 3654
  { PseudoVLSEG2E8_V_MF8, VLSEG2E8_V, 0x5, 0x8 }, // 3655
  { PseudoVLSEG2E8_V_MF8_MASK, VLSEG2E8_V, 0x5, 0x8 }, // 3656
  { PseudoVLSEG2E8_V_MF4, VLSEG2E8_V, 0x6, 0x8 }, // 3657
  { PseudoVLSEG2E8_V_MF4_MASK, VLSEG2E8_V, 0x6, 0x8 }, // 3658
  { PseudoVLSEG2E8_V_MF2, VLSEG2E8_V, 0x7, 0x8 }, // 3659
  { PseudoVLSEG2E8_V_MF2_MASK, VLSEG2E8_V, 0x7, 0x8 }, // 3660
  { PseudoVLSEG3E16FF_V_M1, VLSEG3E16FF_V, 0x0, 0x10 }, // 3661
  { PseudoVLSEG3E16FF_V_M1_MASK, VLSEG3E16FF_V, 0x0, 0x10 }, // 3662
  { PseudoVLSEG3E16FF_V_M2, VLSEG3E16FF_V, 0x1, 0x10 }, // 3663
  { PseudoVLSEG3E16FF_V_M2_MASK, VLSEG3E16FF_V, 0x1, 0x10 }, // 3664
  { PseudoVLSEG3E16FF_V_MF4, VLSEG3E16FF_V, 0x6, 0x10 }, // 3665
  { PseudoVLSEG3E16FF_V_MF4_MASK, VLSEG3E16FF_V, 0x6, 0x10 }, // 3666
  { PseudoVLSEG3E16FF_V_MF2, VLSEG3E16FF_V, 0x7, 0x10 }, // 3667
  { PseudoVLSEG3E16FF_V_MF2_MASK, VLSEG3E16FF_V, 0x7, 0x10 }, // 3668
  { PseudoVLSEG3E16_V_M1, VLSEG3E16_V, 0x0, 0x10 }, // 3669
  { PseudoVLSEG3E16_V_M1_MASK, VLSEG3E16_V, 0x0, 0x10 }, // 3670
  { PseudoVLSEG3E16_V_M2, VLSEG3E16_V, 0x1, 0x10 }, // 3671
  { PseudoVLSEG3E16_V_M2_MASK, VLSEG3E16_V, 0x1, 0x10 }, // 3672
  { PseudoVLSEG3E16_V_MF4, VLSEG3E16_V, 0x6, 0x10 }, // 3673
  { PseudoVLSEG3E16_V_MF4_MASK, VLSEG3E16_V, 0x6, 0x10 }, // 3674
  { PseudoVLSEG3E16_V_MF2, VLSEG3E16_V, 0x7, 0x10 }, // 3675
  { PseudoVLSEG3E16_V_MF2_MASK, VLSEG3E16_V, 0x7, 0x10 }, // 3676
  { PseudoVLSEG3E32FF_V_M1, VLSEG3E32FF_V, 0x0, 0x20 }, // 3677
  { PseudoVLSEG3E32FF_V_M1_MASK, VLSEG3E32FF_V, 0x0, 0x20 }, // 3678
  { PseudoVLSEG3E32FF_V_M2, VLSEG3E32FF_V, 0x1, 0x20 }, // 3679
  { PseudoVLSEG3E32FF_V_M2_MASK, VLSEG3E32FF_V, 0x1, 0x20 }, // 3680
  { PseudoVLSEG3E32FF_V_MF2, VLSEG3E32FF_V, 0x7, 0x20 }, // 3681
  { PseudoVLSEG3E32FF_V_MF2_MASK, VLSEG3E32FF_V, 0x7, 0x20 }, // 3682
  { PseudoVLSEG3E32_V_M1, VLSEG3E32_V, 0x0, 0x20 }, // 3683
  { PseudoVLSEG3E32_V_M1_MASK, VLSEG3E32_V, 0x0, 0x20 }, // 3684
  { PseudoVLSEG3E32_V_M2, VLSEG3E32_V, 0x1, 0x20 }, // 3685
  { PseudoVLSEG3E32_V_M2_MASK, VLSEG3E32_V, 0x1, 0x20 }, // 3686
  { PseudoVLSEG3E32_V_MF2, VLSEG3E32_V, 0x7, 0x20 }, // 3687
  { PseudoVLSEG3E32_V_MF2_MASK, VLSEG3E32_V, 0x7, 0x20 }, // 3688
  { PseudoVLSEG3E64FF_V_M1, VLSEG3E64FF_V, 0x0, 0x40 }, // 3689
  { PseudoVLSEG3E64FF_V_M1_MASK, VLSEG3E64FF_V, 0x0, 0x40 }, // 3690
  { PseudoVLSEG3E64FF_V_M2, VLSEG3E64FF_V, 0x1, 0x40 }, // 3691
  { PseudoVLSEG3E64FF_V_M2_MASK, VLSEG3E64FF_V, 0x1, 0x40 }, // 3692
  { PseudoVLSEG3E64_V_M1, VLSEG3E64_V, 0x0, 0x40 }, // 3693
  { PseudoVLSEG3E64_V_M1_MASK, VLSEG3E64_V, 0x0, 0x40 }, // 3694
  { PseudoVLSEG3E64_V_M2, VLSEG3E64_V, 0x1, 0x40 }, // 3695
  { PseudoVLSEG3E64_V_M2_MASK, VLSEG3E64_V, 0x1, 0x40 }, // 3696
  { PseudoVLSEG3E8FF_V_M1, VLSEG3E8FF_V, 0x0, 0x8 }, // 3697
  { PseudoVLSEG3E8FF_V_M1_MASK, VLSEG3E8FF_V, 0x0, 0x8 }, // 3698
  { PseudoVLSEG3E8FF_V_M2, VLSEG3E8FF_V, 0x1, 0x8 }, // 3699
  { PseudoVLSEG3E8FF_V_M2_MASK, VLSEG3E8FF_V, 0x1, 0x8 }, // 3700
  { PseudoVLSEG3E8FF_V_MF8, VLSEG3E8FF_V, 0x5, 0x8 }, // 3701
  { PseudoVLSEG3E8FF_V_MF8_MASK, VLSEG3E8FF_V, 0x5, 0x8 }, // 3702
  { PseudoVLSEG3E8FF_V_MF4, VLSEG3E8FF_V, 0x6, 0x8 }, // 3703
  { PseudoVLSEG3E8FF_V_MF4_MASK, VLSEG3E8FF_V, 0x6, 0x8 }, // 3704
  { PseudoVLSEG3E8FF_V_MF2, VLSEG3E8FF_V, 0x7, 0x8 }, // 3705
  { PseudoVLSEG3E8FF_V_MF2_MASK, VLSEG3E8FF_V, 0x7, 0x8 }, // 3706
  { PseudoVLSEG3E8_V_M1, VLSEG3E8_V, 0x0, 0x8 }, // 3707
  { PseudoVLSEG3E8_V_M1_MASK, VLSEG3E8_V, 0x0, 0x8 }, // 3708
  { PseudoVLSEG3E8_V_M2, VLSEG3E8_V, 0x1, 0x8 }, // 3709
  { PseudoVLSEG3E8_V_M2_MASK, VLSEG3E8_V, 0x1, 0x8 }, // 3710
  { PseudoVLSEG3E8_V_MF8, VLSEG3E8_V, 0x5, 0x8 }, // 3711
  { PseudoVLSEG3E8_V_MF8_MASK, VLSEG3E8_V, 0x5, 0x8 }, // 3712
  { PseudoVLSEG3E8_V_MF4, VLSEG3E8_V, 0x6, 0x8 }, // 3713
  { PseudoVLSEG3E8_V_MF4_MASK, VLSEG3E8_V, 0x6, 0x8 }, // 3714
  { PseudoVLSEG3E8_V_MF2, VLSEG3E8_V, 0x7, 0x8 }, // 3715
  { PseudoVLSEG3E8_V_MF2_MASK, VLSEG3E8_V, 0x7, 0x8 }, // 3716
  { PseudoVLSEG4E16FF_V_M1, VLSEG4E16FF_V, 0x0, 0x10 }, // 3717
  { PseudoVLSEG4E16FF_V_M1_MASK, VLSEG4E16FF_V, 0x0, 0x10 }, // 3718
  { PseudoVLSEG4E16FF_V_M2, VLSEG4E16FF_V, 0x1, 0x10 }, // 3719
  { PseudoVLSEG4E16FF_V_M2_MASK, VLSEG4E16FF_V, 0x1, 0x10 }, // 3720
  { PseudoVLSEG4E16FF_V_MF4, VLSEG4E16FF_V, 0x6, 0x10 }, // 3721
  { PseudoVLSEG4E16FF_V_MF4_MASK, VLSEG4E16FF_V, 0x6, 0x10 }, // 3722
  { PseudoVLSEG4E16FF_V_MF2, VLSEG4E16FF_V, 0x7, 0x10 }, // 3723
  { PseudoVLSEG4E16FF_V_MF2_MASK, VLSEG4E16FF_V, 0x7, 0x10 }, // 3724
  { PseudoVLSEG4E16_V_M1, VLSEG4E16_V, 0x0, 0x10 }, // 3725
  { PseudoVLSEG4E16_V_M1_MASK, VLSEG4E16_V, 0x0, 0x10 }, // 3726
  { PseudoVLSEG4E16_V_M2, VLSEG4E16_V, 0x1, 0x10 }, // 3727
  { PseudoVLSEG4E16_V_M2_MASK, VLSEG4E16_V, 0x1, 0x10 }, // 3728
  { PseudoVLSEG4E16_V_MF4, VLSEG4E16_V, 0x6, 0x10 }, // 3729
  { PseudoVLSEG4E16_V_MF4_MASK, VLSEG4E16_V, 0x6, 0x10 }, // 3730
  { PseudoVLSEG4E16_V_MF2, VLSEG4E16_V, 0x7, 0x10 }, // 3731
  { PseudoVLSEG4E16_V_MF2_MASK, VLSEG4E16_V, 0x7, 0x10 }, // 3732
  { PseudoVLSEG4E32FF_V_M1, VLSEG4E32FF_V, 0x0, 0x20 }, // 3733
  { PseudoVLSEG4E32FF_V_M1_MASK, VLSEG4E32FF_V, 0x0, 0x20 }, // 3734
  { PseudoVLSEG4E32FF_V_M2, VLSEG4E32FF_V, 0x1, 0x20 }, // 3735
  { PseudoVLSEG4E32FF_V_M2_MASK, VLSEG4E32FF_V, 0x1, 0x20 }, // 3736
  { PseudoVLSEG4E32FF_V_MF2, VLSEG4E32FF_V, 0x7, 0x20 }, // 3737
  { PseudoVLSEG4E32FF_V_MF2_MASK, VLSEG4E32FF_V, 0x7, 0x20 }, // 3738
  { PseudoVLSEG4E32_V_M1, VLSEG4E32_V, 0x0, 0x20 }, // 3739
  { PseudoVLSEG4E32_V_M1_MASK, VLSEG4E32_V, 0x0, 0x20 }, // 3740
  { PseudoVLSEG4E32_V_M2, VLSEG4E32_V, 0x1, 0x20 }, // 3741
  { PseudoVLSEG4E32_V_M2_MASK, VLSEG4E32_V, 0x1, 0x20 }, // 3742
  { PseudoVLSEG4E32_V_MF2, VLSEG4E32_V, 0x7, 0x20 }, // 3743
  { PseudoVLSEG4E32_V_MF2_MASK, VLSEG4E32_V, 0x7, 0x20 }, // 3744
  { PseudoVLSEG4E64FF_V_M1, VLSEG4E64FF_V, 0x0, 0x40 }, // 3745
  { PseudoVLSEG4E64FF_V_M1_MASK, VLSEG4E64FF_V, 0x0, 0x40 }, // 3746
  { PseudoVLSEG4E64FF_V_M2, VLSEG4E64FF_V, 0x1, 0x40 }, // 3747
  { PseudoVLSEG4E64FF_V_M2_MASK, VLSEG4E64FF_V, 0x1, 0x40 }, // 3748
  { PseudoVLSEG4E64_V_M1, VLSEG4E64_V, 0x0, 0x40 }, // 3749
  { PseudoVLSEG4E64_V_M1_MASK, VLSEG4E64_V, 0x0, 0x40 }, // 3750
  { PseudoVLSEG4E64_V_M2, VLSEG4E64_V, 0x1, 0x40 }, // 3751
  { PseudoVLSEG4E64_V_M2_MASK, VLSEG4E64_V, 0x1, 0x40 }, // 3752
  { PseudoVLSEG4E8FF_V_M1, VLSEG4E8FF_V, 0x0, 0x8 }, // 3753
  { PseudoVLSEG4E8FF_V_M1_MASK, VLSEG4E8FF_V, 0x0, 0x8 }, // 3754
  { PseudoVLSEG4E8FF_V_M2, VLSEG4E8FF_V, 0x1, 0x8 }, // 3755
  { PseudoVLSEG4E8FF_V_M2_MASK, VLSEG4E8FF_V, 0x1, 0x8 }, // 3756
  { PseudoVLSEG4E8FF_V_MF8, VLSEG4E8FF_V, 0x5, 0x8 }, // 3757
  { PseudoVLSEG4E8FF_V_MF8_MASK, VLSEG4E8FF_V, 0x5, 0x8 }, // 3758
  { PseudoVLSEG4E8FF_V_MF4, VLSEG4E8FF_V, 0x6, 0x8 }, // 3759
  { PseudoVLSEG4E8FF_V_MF4_MASK, VLSEG4E8FF_V, 0x6, 0x8 }, // 3760
  { PseudoVLSEG4E8FF_V_MF2, VLSEG4E8FF_V, 0x7, 0x8 }, // 3761
  { PseudoVLSEG4E8FF_V_MF2_MASK, VLSEG4E8FF_V, 0x7, 0x8 }, // 3762
  { PseudoVLSEG4E8_V_M1, VLSEG4E8_V, 0x0, 0x8 }, // 3763
  { PseudoVLSEG4E8_V_M1_MASK, VLSEG4E8_V, 0x0, 0x8 }, // 3764
  { PseudoVLSEG4E8_V_M2, VLSEG4E8_V, 0x1, 0x8 }, // 3765
  { PseudoVLSEG4E8_V_M2_MASK, VLSEG4E8_V, 0x1, 0x8 }, // 3766
  { PseudoVLSEG4E8_V_MF8, VLSEG4E8_V, 0x5, 0x8 }, // 3767
  { PseudoVLSEG4E8_V_MF8_MASK, VLSEG4E8_V, 0x5, 0x8 }, // 3768
  { PseudoVLSEG4E8_V_MF4, VLSEG4E8_V, 0x6, 0x8 }, // 3769
  { PseudoVLSEG4E8_V_MF4_MASK, VLSEG4E8_V, 0x6, 0x8 }, // 3770
  { PseudoVLSEG4E8_V_MF2, VLSEG4E8_V, 0x7, 0x8 }, // 3771
  { PseudoVLSEG4E8_V_MF2_MASK, VLSEG4E8_V, 0x7, 0x8 }, // 3772
  { PseudoVLSEG5E16FF_V_M1, VLSEG5E16FF_V, 0x0, 0x10 }, // 3773
  { PseudoVLSEG5E16FF_V_M1_MASK, VLSEG5E16FF_V, 0x0, 0x10 }, // 3774
  { PseudoVLSEG5E16FF_V_MF4, VLSEG5E16FF_V, 0x6, 0x10 }, // 3775
  { PseudoVLSEG5E16FF_V_MF4_MASK, VLSEG5E16FF_V, 0x6, 0x10 }, // 3776
  { PseudoVLSEG5E16FF_V_MF2, VLSEG5E16FF_V, 0x7, 0x10 }, // 3777
  { PseudoVLSEG5E16FF_V_MF2_MASK, VLSEG5E16FF_V, 0x7, 0x10 }, // 3778
  { PseudoVLSEG5E16_V_M1, VLSEG5E16_V, 0x0, 0x10 }, // 3779
  { PseudoVLSEG5E16_V_M1_MASK, VLSEG5E16_V, 0x0, 0x10 }, // 3780
  { PseudoVLSEG5E16_V_MF4, VLSEG5E16_V, 0x6, 0x10 }, // 3781
  { PseudoVLSEG5E16_V_MF4_MASK, VLSEG5E16_V, 0x6, 0x10 }, // 3782
  { PseudoVLSEG5E16_V_MF2, VLSEG5E16_V, 0x7, 0x10 }, // 3783
  { PseudoVLSEG5E16_V_MF2_MASK, VLSEG5E16_V, 0x7, 0x10 }, // 3784
  { PseudoVLSEG5E32FF_V_M1, VLSEG5E32FF_V, 0x0, 0x20 }, // 3785
  { PseudoVLSEG5E32FF_V_M1_MASK, VLSEG5E32FF_V, 0x0, 0x20 }, // 3786
  { PseudoVLSEG5E32FF_V_MF2, VLSEG5E32FF_V, 0x7, 0x20 }, // 3787
  { PseudoVLSEG5E32FF_V_MF2_MASK, VLSEG5E32FF_V, 0x7, 0x20 }, // 3788
  { PseudoVLSEG5E32_V_M1, VLSEG5E32_V, 0x0, 0x20 }, // 3789
  { PseudoVLSEG5E32_V_M1_MASK, VLSEG5E32_V, 0x0, 0x20 }, // 3790
  { PseudoVLSEG5E32_V_MF2, VLSEG5E32_V, 0x7, 0x20 }, // 3791
  { PseudoVLSEG5E32_V_MF2_MASK, VLSEG5E32_V, 0x7, 0x20 }, // 3792
  { PseudoVLSEG5E64FF_V_M1, VLSEG5E64FF_V, 0x0, 0x40 }, // 3793
  { PseudoVLSEG5E64FF_V_M1_MASK, VLSEG5E64FF_V, 0x0, 0x40 }, // 3794
  { PseudoVLSEG5E64_V_M1, VLSEG5E64_V, 0x0, 0x40 }, // 3795
  { PseudoVLSEG5E64_V_M1_MASK, VLSEG5E64_V, 0x0, 0x40 }, // 3796
  { PseudoVLSEG5E8FF_V_M1, VLSEG5E8FF_V, 0x0, 0x8 }, // 3797
  { PseudoVLSEG5E8FF_V_M1_MASK, VLSEG5E8FF_V, 0x0, 0x8 }, // 3798
  { PseudoVLSEG5E8FF_V_MF8, VLSEG5E8FF_V, 0x5, 0x8 }, // 3799
  { PseudoVLSEG5E8FF_V_MF8_MASK, VLSEG5E8FF_V, 0x5, 0x8 }, // 3800
  { PseudoVLSEG5E8FF_V_MF4, VLSEG5E8FF_V, 0x6, 0x8 }, // 3801
  { PseudoVLSEG5E8FF_V_MF4_MASK, VLSEG5E8FF_V, 0x6, 0x8 }, // 3802
  { PseudoVLSEG5E8FF_V_MF2, VLSEG5E8FF_V, 0x7, 0x8 }, // 3803
  { PseudoVLSEG5E8FF_V_MF2_MASK, VLSEG5E8FF_V, 0x7, 0x8 }, // 3804
  { PseudoVLSEG5E8_V_M1, VLSEG5E8_V, 0x0, 0x8 }, // 3805
  { PseudoVLSEG5E8_V_M1_MASK, VLSEG5E8_V, 0x0, 0x8 }, // 3806
  { PseudoVLSEG5E8_V_MF8, VLSEG5E8_V, 0x5, 0x8 }, // 3807
  { PseudoVLSEG5E8_V_MF8_MASK, VLSEG5E8_V, 0x5, 0x8 }, // 3808
  { PseudoVLSEG5E8_V_MF4, VLSEG5E8_V, 0x6, 0x8 }, // 3809
  { PseudoVLSEG5E8_V_MF4_MASK, VLSEG5E8_V, 0x6, 0x8 }, // 3810
  { PseudoVLSEG5E8_V_MF2, VLSEG5E8_V, 0x7, 0x8 }, // 3811
  { PseudoVLSEG5E8_V_MF2_MASK, VLSEG5E8_V, 0x7, 0x8 }, // 3812
  { PseudoVLSEG6E16FF_V_M1, VLSEG6E16FF_V, 0x0, 0x10 }, // 3813
  { PseudoVLSEG6E16FF_V_M1_MASK, VLSEG6E16FF_V, 0x0, 0x10 }, // 3814
  { PseudoVLSEG6E16FF_V_MF4, VLSEG6E16FF_V, 0x6, 0x10 }, // 3815
  { PseudoVLSEG6E16FF_V_MF4_MASK, VLSEG6E16FF_V, 0x6, 0x10 }, // 3816
  { PseudoVLSEG6E16FF_V_MF2, VLSEG6E16FF_V, 0x7, 0x10 }, // 3817
  { PseudoVLSEG6E16FF_V_MF2_MASK, VLSEG6E16FF_V, 0x7, 0x10 }, // 3818
  { PseudoVLSEG6E16_V_M1, VLSEG6E16_V, 0x0, 0x10 }, // 3819
  { PseudoVLSEG6E16_V_M1_MASK, VLSEG6E16_V, 0x0, 0x10 }, // 3820
  { PseudoVLSEG6E16_V_MF4, VLSEG6E16_V, 0x6, 0x10 }, // 3821
  { PseudoVLSEG6E16_V_MF4_MASK, VLSEG6E16_V, 0x6, 0x10 }, // 3822
  { PseudoVLSEG6E16_V_MF2, VLSEG6E16_V, 0x7, 0x10 }, // 3823
  { PseudoVLSEG6E16_V_MF2_MASK, VLSEG6E16_V, 0x7, 0x10 }, // 3824
  { PseudoVLSEG6E32FF_V_M1, VLSEG6E32FF_V, 0x0, 0x20 }, // 3825
  { PseudoVLSEG6E32FF_V_M1_MASK, VLSEG6E32FF_V, 0x0, 0x20 }, // 3826
  { PseudoVLSEG6E32FF_V_MF2, VLSEG6E32FF_V, 0x7, 0x20 }, // 3827
  { PseudoVLSEG6E32FF_V_MF2_MASK, VLSEG6E32FF_V, 0x7, 0x20 }, // 3828
  { PseudoVLSEG6E32_V_M1, VLSEG6E32_V, 0x0, 0x20 }, // 3829
  { PseudoVLSEG6E32_V_M1_MASK, VLSEG6E32_V, 0x0, 0x20 }, // 3830
  { PseudoVLSEG6E32_V_MF2, VLSEG6E32_V, 0x7, 0x20 }, // 3831
  { PseudoVLSEG6E32_V_MF2_MASK, VLSEG6E32_V, 0x7, 0x20 }, // 3832
  { PseudoVLSEG6E64FF_V_M1, VLSEG6E64FF_V, 0x0, 0x40 }, // 3833
  { PseudoVLSEG6E64FF_V_M1_MASK, VLSEG6E64FF_V, 0x0, 0x40 }, // 3834
  { PseudoVLSEG6E64_V_M1, VLSEG6E64_V, 0x0, 0x40 }, // 3835
  { PseudoVLSEG6E64_V_M1_MASK, VLSEG6E64_V, 0x0, 0x40 }, // 3836
  { PseudoVLSEG6E8FF_V_M1, VLSEG6E8FF_V, 0x0, 0x8 }, // 3837
  { PseudoVLSEG6E8FF_V_M1_MASK, VLSEG6E8FF_V, 0x0, 0x8 }, // 3838
  { PseudoVLSEG6E8FF_V_MF8, VLSEG6E8FF_V, 0x5, 0x8 }, // 3839
  { PseudoVLSEG6E8FF_V_MF8_MASK, VLSEG6E8FF_V, 0x5, 0x8 }, // 3840
  { PseudoVLSEG6E8FF_V_MF4, VLSEG6E8FF_V, 0x6, 0x8 }, // 3841
  { PseudoVLSEG6E8FF_V_MF4_MASK, VLSEG6E8FF_V, 0x6, 0x8 }, // 3842
  { PseudoVLSEG6E8FF_V_MF2, VLSEG6E8FF_V, 0x7, 0x8 }, // 3843
  { PseudoVLSEG6E8FF_V_MF2_MASK, VLSEG6E8FF_V, 0x7, 0x8 }, // 3844
  { PseudoVLSEG6E8_V_M1, VLSEG6E8_V, 0x0, 0x8 }, // 3845
  { PseudoVLSEG6E8_V_M1_MASK, VLSEG6E8_V, 0x0, 0x8 }, // 3846
  { PseudoVLSEG6E8_V_MF8, VLSEG6E8_V, 0x5, 0x8 }, // 3847
  { PseudoVLSEG6E8_V_MF8_MASK, VLSEG6E8_V, 0x5, 0x8 }, // 3848
  { PseudoVLSEG6E8_V_MF4, VLSEG6E8_V, 0x6, 0x8 }, // 3849
  { PseudoVLSEG6E8_V_MF4_MASK, VLSEG6E8_V, 0x6, 0x8 }, // 3850
  { PseudoVLSEG6E8_V_MF2, VLSEG6E8_V, 0x7, 0x8 }, // 3851
  { PseudoVLSEG6E8_V_MF2_MASK, VLSEG6E8_V, 0x7, 0x8 }, // 3852
  { PseudoVLSEG7E16FF_V_M1, VLSEG7E16FF_V, 0x0, 0x10 }, // 3853
  { PseudoVLSEG7E16FF_V_M1_MASK, VLSEG7E16FF_V, 0x0, 0x10 }, // 3854
  { PseudoVLSEG7E16FF_V_MF4, VLSEG7E16FF_V, 0x6, 0x10 }, // 3855
  { PseudoVLSEG7E16FF_V_MF4_MASK, VLSEG7E16FF_V, 0x6, 0x10 }, // 3856
  { PseudoVLSEG7E16FF_V_MF2, VLSEG7E16FF_V, 0x7, 0x10 }, // 3857
  { PseudoVLSEG7E16FF_V_MF2_MASK, VLSEG7E16FF_V, 0x7, 0x10 }, // 3858
  { PseudoVLSEG7E16_V_M1, VLSEG7E16_V, 0x0, 0x10 }, // 3859
  { PseudoVLSEG7E16_V_M1_MASK, VLSEG7E16_V, 0x0, 0x10 }, // 3860
  { PseudoVLSEG7E16_V_MF4, VLSEG7E16_V, 0x6, 0x10 }, // 3861
  { PseudoVLSEG7E16_V_MF4_MASK, VLSEG7E16_V, 0x6, 0x10 }, // 3862
  { PseudoVLSEG7E16_V_MF2, VLSEG7E16_V, 0x7, 0x10 }, // 3863
  { PseudoVLSEG7E16_V_MF2_MASK, VLSEG7E16_V, 0x7, 0x10 }, // 3864
  { PseudoVLSEG7E32FF_V_M1, VLSEG7E32FF_V, 0x0, 0x20 }, // 3865
  { PseudoVLSEG7E32FF_V_M1_MASK, VLSEG7E32FF_V, 0x0, 0x20 }, // 3866
  { PseudoVLSEG7E32FF_V_MF2, VLSEG7E32FF_V, 0x7, 0x20 }, // 3867
  { PseudoVLSEG7E32FF_V_MF2_MASK, VLSEG7E32FF_V, 0x7, 0x20 }, // 3868
  { PseudoVLSEG7E32_V_M1, VLSEG7E32_V, 0x0, 0x20 }, // 3869
  { PseudoVLSEG7E32_V_M1_MASK, VLSEG7E32_V, 0x0, 0x20 }, // 3870
  { PseudoVLSEG7E32_V_MF2, VLSEG7E32_V, 0x7, 0x20 }, // 3871
  { PseudoVLSEG7E32_V_MF2_MASK, VLSEG7E32_V, 0x7, 0x20 }, // 3872
  { PseudoVLSEG7E64FF_V_M1, VLSEG7E64FF_V, 0x0, 0x40 }, // 3873
  { PseudoVLSEG7E64FF_V_M1_MASK, VLSEG7E64FF_V, 0x0, 0x40 }, // 3874
  { PseudoVLSEG7E64_V_M1, VLSEG7E64_V, 0x0, 0x40 }, // 3875
  { PseudoVLSEG7E64_V_M1_MASK, VLSEG7E64_V, 0x0, 0x40 }, // 3876
  { PseudoVLSEG7E8FF_V_M1, VLSEG7E8FF_V, 0x0, 0x8 }, // 3877
  { PseudoVLSEG7E8FF_V_M1_MASK, VLSEG7E8FF_V, 0x0, 0x8 }, // 3878
  { PseudoVLSEG7E8FF_V_MF8, VLSEG7E8FF_V, 0x5, 0x8 }, // 3879
  { PseudoVLSEG7E8FF_V_MF8_MASK, VLSEG7E8FF_V, 0x5, 0x8 }, // 3880
  { PseudoVLSEG7E8FF_V_MF4, VLSEG7E8FF_V, 0x6, 0x8 }, // 3881
  { PseudoVLSEG7E8FF_V_MF4_MASK, VLSEG7E8FF_V, 0x6, 0x8 }, // 3882
  { PseudoVLSEG7E8FF_V_MF2, VLSEG7E8FF_V, 0x7, 0x8 }, // 3883
  { PseudoVLSEG7E8FF_V_MF2_MASK, VLSEG7E8FF_V, 0x7, 0x8 }, // 3884
  { PseudoVLSEG7E8_V_M1, VLSEG7E8_V, 0x0, 0x8 }, // 3885
  { PseudoVLSEG7E8_V_M1_MASK, VLSEG7E8_V, 0x0, 0x8 }, // 3886
  { PseudoVLSEG7E8_V_MF8, VLSEG7E8_V, 0x5, 0x8 }, // 3887
  { PseudoVLSEG7E8_V_MF8_MASK, VLSEG7E8_V, 0x5, 0x8 }, // 3888
  { PseudoVLSEG7E8_V_MF4, VLSEG7E8_V, 0x6, 0x8 }, // 3889
  { PseudoVLSEG7E8_V_MF4_MASK, VLSEG7E8_V, 0x6, 0x8 }, // 3890
  { PseudoVLSEG7E8_V_MF2, VLSEG7E8_V, 0x7, 0x8 }, // 3891
  { PseudoVLSEG7E8_V_MF2_MASK, VLSEG7E8_V, 0x7, 0x8 }, // 3892
  { PseudoVLSEG8E16FF_V_M1, VLSEG8E16FF_V, 0x0, 0x10 }, // 3893
  { PseudoVLSEG8E16FF_V_M1_MASK, VLSEG8E16FF_V, 0x0, 0x10 }, // 3894
  { PseudoVLSEG8E16FF_V_MF4, VLSEG8E16FF_V, 0x6, 0x10 }, // 3895
  { PseudoVLSEG8E16FF_V_MF4_MASK, VLSEG8E16FF_V, 0x6, 0x10 }, // 3896
  { PseudoVLSEG8E16FF_V_MF2, VLSEG8E16FF_V, 0x7, 0x10 }, // 3897
  { PseudoVLSEG8E16FF_V_MF2_MASK, VLSEG8E16FF_V, 0x7, 0x10 }, // 3898
  { PseudoVLSEG8E16_V_M1, VLSEG8E16_V, 0x0, 0x10 }, // 3899
  { PseudoVLSEG8E16_V_M1_MASK, VLSEG8E16_V, 0x0, 0x10 }, // 3900
  { PseudoVLSEG8E16_V_MF4, VLSEG8E16_V, 0x6, 0x10 }, // 3901
  { PseudoVLSEG8E16_V_MF4_MASK, VLSEG8E16_V, 0x6, 0x10 }, // 3902
  { PseudoVLSEG8E16_V_MF2, VLSEG8E16_V, 0x7, 0x10 }, // 3903
  { PseudoVLSEG8E16_V_MF2_MASK, VLSEG8E16_V, 0x7, 0x10 }, // 3904
  { PseudoVLSEG8E32FF_V_M1, VLSEG8E32FF_V, 0x0, 0x20 }, // 3905
  { PseudoVLSEG8E32FF_V_M1_MASK, VLSEG8E32FF_V, 0x0, 0x20 }, // 3906
  { PseudoVLSEG8E32FF_V_MF2, VLSEG8E32FF_V, 0x7, 0x20 }, // 3907
  { PseudoVLSEG8E32FF_V_MF2_MASK, VLSEG8E32FF_V, 0x7, 0x20 }, // 3908
  { PseudoVLSEG8E32_V_M1, VLSEG8E32_V, 0x0, 0x20 }, // 3909
  { PseudoVLSEG8E32_V_M1_MASK, VLSEG8E32_V, 0x0, 0x20 }, // 3910
  { PseudoVLSEG8E32_V_MF2, VLSEG8E32_V, 0x7, 0x20 }, // 3911
  { PseudoVLSEG8E32_V_MF2_MASK, VLSEG8E32_V, 0x7, 0x20 }, // 3912
  { PseudoVLSEG8E64FF_V_M1, VLSEG8E64FF_V, 0x0, 0x40 }, // 3913
  { PseudoVLSEG8E64FF_V_M1_MASK, VLSEG8E64FF_V, 0x0, 0x40 }, // 3914
  { PseudoVLSEG8E64_V_M1, VLSEG8E64_V, 0x0, 0x40 }, // 3915
  { PseudoVLSEG8E64_V_M1_MASK, VLSEG8E64_V, 0x0, 0x40 }, // 3916
  { PseudoVLSEG8E8FF_V_M1, VLSEG8E8FF_V, 0x0, 0x8 }, // 3917
  { PseudoVLSEG8E8FF_V_M1_MASK, VLSEG8E8FF_V, 0x0, 0x8 }, // 3918
  { PseudoVLSEG8E8FF_V_MF8, VLSEG8E8FF_V, 0x5, 0x8 }, // 3919
  { PseudoVLSEG8E8FF_V_MF8_MASK, VLSEG8E8FF_V, 0x5, 0x8 }, // 3920
  { PseudoVLSEG8E8FF_V_MF4, VLSEG8E8FF_V, 0x6, 0x8 }, // 3921
  { PseudoVLSEG8E8FF_V_MF4_MASK, VLSEG8E8FF_V, 0x6, 0x8 }, // 3922
  { PseudoVLSEG8E8FF_V_MF2, VLSEG8E8FF_V, 0x7, 0x8 }, // 3923
  { PseudoVLSEG8E8FF_V_MF2_MASK, VLSEG8E8FF_V, 0x7, 0x8 }, // 3924
  { PseudoVLSEG8E8_V_M1, VLSEG8E8_V, 0x0, 0x8 }, // 3925
  { PseudoVLSEG8E8_V_M1_MASK, VLSEG8E8_V, 0x0, 0x8 }, // 3926
  { PseudoVLSEG8E8_V_MF8, VLSEG8E8_V, 0x5, 0x8 }, // 3927
  { PseudoVLSEG8E8_V_MF8_MASK, VLSEG8E8_V, 0x5, 0x8 }, // 3928
  { PseudoVLSEG8E8_V_MF4, VLSEG8E8_V, 0x6, 0x8 }, // 3929
  { PseudoVLSEG8E8_V_MF4_MASK, VLSEG8E8_V, 0x6, 0x8 }, // 3930
  { PseudoVLSEG8E8_V_MF2, VLSEG8E8_V, 0x7, 0x8 }, // 3931
  { PseudoVLSEG8E8_V_MF2_MASK, VLSEG8E8_V, 0x7, 0x8 }, // 3932
  { PseudoVLSSEG2E16_V_M1, VLSSEG2E16_V, 0x0, 0x10 }, // 3933
  { PseudoVLSSEG2E16_V_M1_MASK, VLSSEG2E16_V, 0x0, 0x10 }, // 3934
  { PseudoVLSSEG2E16_V_M2, VLSSEG2E16_V, 0x1, 0x10 }, // 3935
  { PseudoVLSSEG2E16_V_M2_MASK, VLSSEG2E16_V, 0x1, 0x10 }, // 3936
  { PseudoVLSSEG2E16_V_M4, VLSSEG2E16_V, 0x2, 0x10 }, // 3937
  { PseudoVLSSEG2E16_V_M4_MASK, VLSSEG2E16_V, 0x2, 0x10 }, // 3938
  { PseudoVLSSEG2E16_V_MF4, VLSSEG2E16_V, 0x6, 0x10 }, // 3939
  { PseudoVLSSEG2E16_V_MF4_MASK, VLSSEG2E16_V, 0x6, 0x10 }, // 3940
  { PseudoVLSSEG2E16_V_MF2, VLSSEG2E16_V, 0x7, 0x10 }, // 3941
  { PseudoVLSSEG2E16_V_MF2_MASK, VLSSEG2E16_V, 0x7, 0x10 }, // 3942
  { PseudoVLSSEG2E32_V_M1, VLSSEG2E32_V, 0x0, 0x20 }, // 3943
  { PseudoVLSSEG2E32_V_M1_MASK, VLSSEG2E32_V, 0x0, 0x20 }, // 3944
  { PseudoVLSSEG2E32_V_M2, VLSSEG2E32_V, 0x1, 0x20 }, // 3945
  { PseudoVLSSEG2E32_V_M2_MASK, VLSSEG2E32_V, 0x1, 0x20 }, // 3946
  { PseudoVLSSEG2E32_V_M4, VLSSEG2E32_V, 0x2, 0x20 }, // 3947
  { PseudoVLSSEG2E32_V_M4_MASK, VLSSEG2E32_V, 0x2, 0x20 }, // 3948
  { PseudoVLSSEG2E32_V_MF2, VLSSEG2E32_V, 0x7, 0x20 }, // 3949
  { PseudoVLSSEG2E32_V_MF2_MASK, VLSSEG2E32_V, 0x7, 0x20 }, // 3950
  { PseudoVLSSEG2E64_V_M1, VLSSEG2E64_V, 0x0, 0x40 }, // 3951
  { PseudoVLSSEG2E64_V_M1_MASK, VLSSEG2E64_V, 0x0, 0x40 }, // 3952
  { PseudoVLSSEG2E64_V_M2, VLSSEG2E64_V, 0x1, 0x40 }, // 3953
  { PseudoVLSSEG2E64_V_M2_MASK, VLSSEG2E64_V, 0x1, 0x40 }, // 3954
  { PseudoVLSSEG2E64_V_M4, VLSSEG2E64_V, 0x2, 0x40 }, // 3955
  { PseudoVLSSEG2E64_V_M4_MASK, VLSSEG2E64_V, 0x2, 0x40 }, // 3956
  { PseudoVLSSEG2E8_V_M1, VLSSEG2E8_V, 0x0, 0x8 }, // 3957
  { PseudoVLSSEG2E8_V_M1_MASK, VLSSEG2E8_V, 0x0, 0x8 }, // 3958
  { PseudoVLSSEG2E8_V_M2, VLSSEG2E8_V, 0x1, 0x8 }, // 3959
  { PseudoVLSSEG2E8_V_M2_MASK, VLSSEG2E8_V, 0x1, 0x8 }, // 3960
  { PseudoVLSSEG2E8_V_M4, VLSSEG2E8_V, 0x2, 0x8 }, // 3961
  { PseudoVLSSEG2E8_V_M4_MASK, VLSSEG2E8_V, 0x2, 0x8 }, // 3962
  { PseudoVLSSEG2E8_V_MF8, VLSSEG2E8_V, 0x5, 0x8 }, // 3963
  { PseudoVLSSEG2E8_V_MF8_MASK, VLSSEG2E8_V, 0x5, 0x8 }, // 3964
  { PseudoVLSSEG2E8_V_MF4, VLSSEG2E8_V, 0x6, 0x8 }, // 3965
  { PseudoVLSSEG2E8_V_MF4_MASK, VLSSEG2E8_V, 0x6, 0x8 }, // 3966
  { PseudoVLSSEG2E8_V_MF2, VLSSEG2E8_V, 0x7, 0x8 }, // 3967
  { PseudoVLSSEG2E8_V_MF2_MASK, VLSSEG2E8_V, 0x7, 0x8 }, // 3968
  { PseudoVLSSEG3E16_V_M1, VLSSEG3E16_V, 0x0, 0x10 }, // 3969
  { PseudoVLSSEG3E16_V_M1_MASK, VLSSEG3E16_V, 0x0, 0x10 }, // 3970
  { PseudoVLSSEG3E16_V_M2, VLSSEG3E16_V, 0x1, 0x10 }, // 3971
  { PseudoVLSSEG3E16_V_M2_MASK, VLSSEG3E16_V, 0x1, 0x10 }, // 3972
  { PseudoVLSSEG3E16_V_MF4, VLSSEG3E16_V, 0x6, 0x10 }, // 3973
  { PseudoVLSSEG3E16_V_MF4_MASK, VLSSEG3E16_V, 0x6, 0x10 }, // 3974
  { PseudoVLSSEG3E16_V_MF2, VLSSEG3E16_V, 0x7, 0x10 }, // 3975
  { PseudoVLSSEG3E16_V_MF2_MASK, VLSSEG3E16_V, 0x7, 0x10 }, // 3976
  { PseudoVLSSEG3E32_V_M1, VLSSEG3E32_V, 0x0, 0x20 }, // 3977
  { PseudoVLSSEG3E32_V_M1_MASK, VLSSEG3E32_V, 0x0, 0x20 }, // 3978
  { PseudoVLSSEG3E32_V_M2, VLSSEG3E32_V, 0x1, 0x20 }, // 3979
  { PseudoVLSSEG3E32_V_M2_MASK, VLSSEG3E32_V, 0x1, 0x20 }, // 3980
  { PseudoVLSSEG3E32_V_MF2, VLSSEG3E32_V, 0x7, 0x20 }, // 3981
  { PseudoVLSSEG3E32_V_MF2_MASK, VLSSEG3E32_V, 0x7, 0x20 }, // 3982
  { PseudoVLSSEG3E64_V_M1, VLSSEG3E64_V, 0x0, 0x40 }, // 3983
  { PseudoVLSSEG3E64_V_M1_MASK, VLSSEG3E64_V, 0x0, 0x40 }, // 3984
  { PseudoVLSSEG3E64_V_M2, VLSSEG3E64_V, 0x1, 0x40 }, // 3985
  { PseudoVLSSEG3E64_V_M2_MASK, VLSSEG3E64_V, 0x1, 0x40 }, // 3986
  { PseudoVLSSEG3E8_V_M1, VLSSEG3E8_V, 0x0, 0x8 }, // 3987
  { PseudoVLSSEG3E8_V_M1_MASK, VLSSEG3E8_V, 0x0, 0x8 }, // 3988
  { PseudoVLSSEG3E8_V_M2, VLSSEG3E8_V, 0x1, 0x8 }, // 3989
  { PseudoVLSSEG3E8_V_M2_MASK, VLSSEG3E8_V, 0x1, 0x8 }, // 3990
  { PseudoVLSSEG3E8_V_MF8, VLSSEG3E8_V, 0x5, 0x8 }, // 3991
  { PseudoVLSSEG3E8_V_MF8_MASK, VLSSEG3E8_V, 0x5, 0x8 }, // 3992
  { PseudoVLSSEG3E8_V_MF4, VLSSEG3E8_V, 0x6, 0x8 }, // 3993
  { PseudoVLSSEG3E8_V_MF4_MASK, VLSSEG3E8_V, 0x6, 0x8 }, // 3994
  { PseudoVLSSEG3E8_V_MF2, VLSSEG3E8_V, 0x7, 0x8 }, // 3995
  { PseudoVLSSEG3E8_V_MF2_MASK, VLSSEG3E8_V, 0x7, 0x8 }, // 3996
  { PseudoVLSSEG4E16_V_M1, VLSSEG4E16_V, 0x0, 0x10 }, // 3997
  { PseudoVLSSEG4E16_V_M1_MASK, VLSSEG4E16_V, 0x0, 0x10 }, // 3998
  { PseudoVLSSEG4E16_V_M2, VLSSEG4E16_V, 0x1, 0x10 }, // 3999
  { PseudoVLSSEG4E16_V_M2_MASK, VLSSEG4E16_V, 0x1, 0x10 }, // 4000
  { PseudoVLSSEG4E16_V_MF4, VLSSEG4E16_V, 0x6, 0x10 }, // 4001
  { PseudoVLSSEG4E16_V_MF4_MASK, VLSSEG4E16_V, 0x6, 0x10 }, // 4002
  { PseudoVLSSEG4E16_V_MF2, VLSSEG4E16_V, 0x7, 0x10 }, // 4003
  { PseudoVLSSEG4E16_V_MF2_MASK, VLSSEG4E16_V, 0x7, 0x10 }, // 4004
  { PseudoVLSSEG4E32_V_M1, VLSSEG4E32_V, 0x0, 0x20 }, // 4005
  { PseudoVLSSEG4E32_V_M1_MASK, VLSSEG4E32_V, 0x0, 0x20 }, // 4006
  { PseudoVLSSEG4E32_V_M2, VLSSEG4E32_V, 0x1, 0x20 }, // 4007
  { PseudoVLSSEG4E32_V_M2_MASK, VLSSEG4E32_V, 0x1, 0x20 }, // 4008
  { PseudoVLSSEG4E32_V_MF2, VLSSEG4E32_V, 0x7, 0x20 }, // 4009
  { PseudoVLSSEG4E32_V_MF2_MASK, VLSSEG4E32_V, 0x7, 0x20 }, // 4010
  { PseudoVLSSEG4E64_V_M1, VLSSEG4E64_V, 0x0, 0x40 }, // 4011
  { PseudoVLSSEG4E64_V_M1_MASK, VLSSEG4E64_V, 0x0, 0x40 }, // 4012
  { PseudoVLSSEG4E64_V_M2, VLSSEG4E64_V, 0x1, 0x40 }, // 4013
  { PseudoVLSSEG4E64_V_M2_MASK, VLSSEG4E64_V, 0x1, 0x40 }, // 4014
  { PseudoVLSSEG4E8_V_M1, VLSSEG4E8_V, 0x0, 0x8 }, // 4015
  { PseudoVLSSEG4E8_V_M1_MASK, VLSSEG4E8_V, 0x0, 0x8 }, // 4016
  { PseudoVLSSEG4E8_V_M2, VLSSEG4E8_V, 0x1, 0x8 }, // 4017
  { PseudoVLSSEG4E8_V_M2_MASK, VLSSEG4E8_V, 0x1, 0x8 }, // 4018
  { PseudoVLSSEG4E8_V_MF8, VLSSEG4E8_V, 0x5, 0x8 }, // 4019
  { PseudoVLSSEG4E8_V_MF8_MASK, VLSSEG4E8_V, 0x5, 0x8 }, // 4020
  { PseudoVLSSEG4E8_V_MF4, VLSSEG4E8_V, 0x6, 0x8 }, // 4021
  { PseudoVLSSEG4E8_V_MF4_MASK, VLSSEG4E8_V, 0x6, 0x8 }, // 4022
  { PseudoVLSSEG4E8_V_MF2, VLSSEG4E8_V, 0x7, 0x8 }, // 4023
  { PseudoVLSSEG4E8_V_MF2_MASK, VLSSEG4E8_V, 0x7, 0x8 }, // 4024
  { PseudoVLSSEG5E16_V_M1, VLSSEG5E16_V, 0x0, 0x10 }, // 4025
  { PseudoVLSSEG5E16_V_M1_MASK, VLSSEG5E16_V, 0x0, 0x10 }, // 4026
  { PseudoVLSSEG5E16_V_MF4, VLSSEG5E16_V, 0x6, 0x10 }, // 4027
  { PseudoVLSSEG5E16_V_MF4_MASK, VLSSEG5E16_V, 0x6, 0x10 }, // 4028
  { PseudoVLSSEG5E16_V_MF2, VLSSEG5E16_V, 0x7, 0x10 }, // 4029
  { PseudoVLSSEG5E16_V_MF2_MASK, VLSSEG5E16_V, 0x7, 0x10 }, // 4030
  { PseudoVLSSEG5E32_V_M1, VLSSEG5E32_V, 0x0, 0x20 }, // 4031
  { PseudoVLSSEG5E32_V_M1_MASK, VLSSEG5E32_V, 0x0, 0x20 }, // 4032
  { PseudoVLSSEG5E32_V_MF2, VLSSEG5E32_V, 0x7, 0x20 }, // 4033
  { PseudoVLSSEG5E32_V_MF2_MASK, VLSSEG5E32_V, 0x7, 0x20 }, // 4034
  { PseudoVLSSEG5E64_V_M1, VLSSEG5E64_V, 0x0, 0x40 }, // 4035
  { PseudoVLSSEG5E64_V_M1_MASK, VLSSEG5E64_V, 0x0, 0x40 }, // 4036
  { PseudoVLSSEG5E8_V_M1, VLSSEG5E8_V, 0x0, 0x8 }, // 4037
  { PseudoVLSSEG5E8_V_M1_MASK, VLSSEG5E8_V, 0x0, 0x8 }, // 4038
  { PseudoVLSSEG5E8_V_MF8, VLSSEG5E8_V, 0x5, 0x8 }, // 4039
  { PseudoVLSSEG5E8_V_MF8_MASK, VLSSEG5E8_V, 0x5, 0x8 }, // 4040
  { PseudoVLSSEG5E8_V_MF4, VLSSEG5E8_V, 0x6, 0x8 }, // 4041
  { PseudoVLSSEG5E8_V_MF4_MASK, VLSSEG5E8_V, 0x6, 0x8 }, // 4042
  { PseudoVLSSEG5E8_V_MF2, VLSSEG5E8_V, 0x7, 0x8 }, // 4043
  { PseudoVLSSEG5E8_V_MF2_MASK, VLSSEG5E8_V, 0x7, 0x8 }, // 4044
  { PseudoVLSSEG6E16_V_M1, VLSSEG6E16_V, 0x0, 0x10 }, // 4045
  { PseudoVLSSEG6E16_V_M1_MASK, VLSSEG6E16_V, 0x0, 0x10 }, // 4046
  { PseudoVLSSEG6E16_V_MF4, VLSSEG6E16_V, 0x6, 0x10 }, // 4047
  { PseudoVLSSEG6E16_V_MF4_MASK, VLSSEG6E16_V, 0x6, 0x10 }, // 4048
  { PseudoVLSSEG6E16_V_MF2, VLSSEG6E16_V, 0x7, 0x10 }, // 4049
  { PseudoVLSSEG6E16_V_MF2_MASK, VLSSEG6E16_V, 0x7, 0x10 }, // 4050
  { PseudoVLSSEG6E32_V_M1, VLSSEG6E32_V, 0x0, 0x20 }, // 4051
  { PseudoVLSSEG6E32_V_M1_MASK, VLSSEG6E32_V, 0x0, 0x20 }, // 4052
  { PseudoVLSSEG6E32_V_MF2, VLSSEG6E32_V, 0x7, 0x20 }, // 4053
  { PseudoVLSSEG6E32_V_MF2_MASK, VLSSEG6E32_V, 0x7, 0x20 }, // 4054
  { PseudoVLSSEG6E64_V_M1, VLSSEG6E64_V, 0x0, 0x40 }, // 4055
  { PseudoVLSSEG6E64_V_M1_MASK, VLSSEG6E64_V, 0x0, 0x40 }, // 4056
  { PseudoVLSSEG6E8_V_M1, VLSSEG6E8_V, 0x0, 0x8 }, // 4057
  { PseudoVLSSEG6E8_V_M1_MASK, VLSSEG6E8_V, 0x0, 0x8 }, // 4058
  { PseudoVLSSEG6E8_V_MF8, VLSSEG6E8_V, 0x5, 0x8 }, // 4059
  { PseudoVLSSEG6E8_V_MF8_MASK, VLSSEG6E8_V, 0x5, 0x8 }, // 4060
  { PseudoVLSSEG6E8_V_MF4, VLSSEG6E8_V, 0x6, 0x8 }, // 4061
  { PseudoVLSSEG6E8_V_MF4_MASK, VLSSEG6E8_V, 0x6, 0x8 }, // 4062
  { PseudoVLSSEG6E8_V_MF2, VLSSEG6E8_V, 0x7, 0x8 }, // 4063
  { PseudoVLSSEG6E8_V_MF2_MASK, VLSSEG6E8_V, 0x7, 0x8 }, // 4064
  { PseudoVLSSEG7E16_V_M1, VLSSEG7E16_V, 0x0, 0x10 }, // 4065
  { PseudoVLSSEG7E16_V_M1_MASK, VLSSEG7E16_V, 0x0, 0x10 }, // 4066
  { PseudoVLSSEG7E16_V_MF4, VLSSEG7E16_V, 0x6, 0x10 }, // 4067
  { PseudoVLSSEG7E16_V_MF4_MASK, VLSSEG7E16_V, 0x6, 0x10 }, // 4068
  { PseudoVLSSEG7E16_V_MF2, VLSSEG7E16_V, 0x7, 0x10 }, // 4069
  { PseudoVLSSEG7E16_V_MF2_MASK, VLSSEG7E16_V, 0x7, 0x10 }, // 4070
  { PseudoVLSSEG7E32_V_M1, VLSSEG7E32_V, 0x0, 0x20 }, // 4071
  { PseudoVLSSEG7E32_V_M1_MASK, VLSSEG7E32_V, 0x0, 0x20 }, // 4072
  { PseudoVLSSEG7E32_V_MF2, VLSSEG7E32_V, 0x7, 0x20 }, // 4073
  { PseudoVLSSEG7E32_V_MF2_MASK, VLSSEG7E32_V, 0x7, 0x20 }, // 4074
  { PseudoVLSSEG7E64_V_M1, VLSSEG7E64_V, 0x0, 0x40 }, // 4075
  { PseudoVLSSEG7E64_V_M1_MASK, VLSSEG7E64_V, 0x0, 0x40 }, // 4076
  { PseudoVLSSEG7E8_V_M1, VLSSEG7E8_V, 0x0, 0x8 }, // 4077
  { PseudoVLSSEG7E8_V_M1_MASK, VLSSEG7E8_V, 0x0, 0x8 }, // 4078
  { PseudoVLSSEG7E8_V_MF8, VLSSEG7E8_V, 0x5, 0x8 }, // 4079
  { PseudoVLSSEG7E8_V_MF8_MASK, VLSSEG7E8_V, 0x5, 0x8 }, // 4080
  { PseudoVLSSEG7E8_V_MF4, VLSSEG7E8_V, 0x6, 0x8 }, // 4081
  { PseudoVLSSEG7E8_V_MF4_MASK, VLSSEG7E8_V, 0x6, 0x8 }, // 4082
  { PseudoVLSSEG7E8_V_MF2, VLSSEG7E8_V, 0x7, 0x8 }, // 4083
  { PseudoVLSSEG7E8_V_MF2_MASK, VLSSEG7E8_V, 0x7, 0x8 }, // 4084
  { PseudoVLSSEG8E16_V_M1, VLSSEG8E16_V, 0x0, 0x10 }, // 4085
  { PseudoVLSSEG8E16_V_M1_MASK, VLSSEG8E16_V, 0x0, 0x10 }, // 4086
  { PseudoVLSSEG8E16_V_MF4, VLSSEG8E16_V, 0x6, 0x10 }, // 4087
  { PseudoVLSSEG8E16_V_MF4_MASK, VLSSEG8E16_V, 0x6, 0x10 }, // 4088
  { PseudoVLSSEG8E16_V_MF2, VLSSEG8E16_V, 0x7, 0x10 }, // 4089
  { PseudoVLSSEG8E16_V_MF2_MASK, VLSSEG8E16_V, 0x7, 0x10 }, // 4090
  { PseudoVLSSEG8E32_V_M1, VLSSEG8E32_V, 0x0, 0x20 }, // 4091
  { PseudoVLSSEG8E32_V_M1_MASK, VLSSEG8E32_V, 0x0, 0x20 }, // 4092
  { PseudoVLSSEG8E32_V_MF2, VLSSEG8E32_V, 0x7, 0x20 }, // 4093
  { PseudoVLSSEG8E32_V_MF2_MASK, VLSSEG8E32_V, 0x7, 0x20 }, // 4094
  { PseudoVLSSEG8E64_V_M1, VLSSEG8E64_V, 0x0, 0x40 }, // 4095
  { PseudoVLSSEG8E64_V_M1_MASK, VLSSEG8E64_V, 0x0, 0x40 }, // 4096
  { PseudoVLSSEG8E8_V_M1, VLSSEG8E8_V, 0x0, 0x8 }, // 4097
  { PseudoVLSSEG8E8_V_M1_MASK, VLSSEG8E8_V, 0x0, 0x8 }, // 4098
  { PseudoVLSSEG8E8_V_MF8, VLSSEG8E8_V, 0x5, 0x8 }, // 4099
  { PseudoVLSSEG8E8_V_MF8_MASK, VLSSEG8E8_V, 0x5, 0x8 }, // 4100
  { PseudoVLSSEG8E8_V_MF4, VLSSEG8E8_V, 0x6, 0x8 }, // 4101
  { PseudoVLSSEG8E8_V_MF4_MASK, VLSSEG8E8_V, 0x6, 0x8 }, // 4102
  { PseudoVLSSEG8E8_V_MF2, VLSSEG8E8_V, 0x7, 0x8 }, // 4103
  { PseudoVLSSEG8E8_V_MF2_MASK, VLSSEG8E8_V, 0x7, 0x8 }, // 4104
  { PseudoVLUXEI16_V_M1_M1, VLUXEI16_V, 0x0, 0x0 }, // 4105
  { PseudoVLUXEI16_V_M1_M1_MASK, VLUXEI16_V, 0x0, 0x0 }, // 4106
  { PseudoVLUXEI16_V_M2_M1, VLUXEI16_V, 0x0, 0x0 }, // 4107
  { PseudoVLUXEI16_V_M2_M1_MASK, VLUXEI16_V, 0x0, 0x0 }, // 4108
  { PseudoVLUXEI16_V_MF2_M1, VLUXEI16_V, 0x0, 0x0 }, // 4109
  { PseudoVLUXEI16_V_MF2_M1_MASK, VLUXEI16_V, 0x0, 0x0 }, // 4110
  { PseudoVLUXEI16_V_MF4_M1, VLUXEI16_V, 0x0, 0x0 }, // 4111
  { PseudoVLUXEI16_V_MF4_M1_MASK, VLUXEI16_V, 0x0, 0x0 }, // 4112
  { PseudoVLUXEI16_V_M1_M2, VLUXEI16_V, 0x1, 0x0 }, // 4113
  { PseudoVLUXEI16_V_M1_M2_MASK, VLUXEI16_V, 0x1, 0x0 }, // 4114
  { PseudoVLUXEI16_V_M2_M2, VLUXEI16_V, 0x1, 0x0 }, // 4115
  { PseudoVLUXEI16_V_M2_M2_MASK, VLUXEI16_V, 0x1, 0x0 }, // 4116
  { PseudoVLUXEI16_V_M4_M2, VLUXEI16_V, 0x1, 0x0 }, // 4117
  { PseudoVLUXEI16_V_M4_M2_MASK, VLUXEI16_V, 0x1, 0x0 }, // 4118
  { PseudoVLUXEI16_V_MF2_M2, VLUXEI16_V, 0x1, 0x0 }, // 4119
  { PseudoVLUXEI16_V_MF2_M2_MASK, VLUXEI16_V, 0x1, 0x0 }, // 4120
  { PseudoVLUXEI16_V_M1_M4, VLUXEI16_V, 0x2, 0x0 }, // 4121
  { PseudoVLUXEI16_V_M1_M4_MASK, VLUXEI16_V, 0x2, 0x0 }, // 4122
  { PseudoVLUXEI16_V_M2_M4, VLUXEI16_V, 0x2, 0x0 }, // 4123
  { PseudoVLUXEI16_V_M2_M4_MASK, VLUXEI16_V, 0x2, 0x0 }, // 4124
  { PseudoVLUXEI16_V_M4_M4, VLUXEI16_V, 0x2, 0x0 }, // 4125
  { PseudoVLUXEI16_V_M4_M4_MASK, VLUXEI16_V, 0x2, 0x0 }, // 4126
  { PseudoVLUXEI16_V_M8_M4, VLUXEI16_V, 0x2, 0x0 }, // 4127
  { PseudoVLUXEI16_V_M8_M4_MASK, VLUXEI16_V, 0x2, 0x0 }, // 4128
  { PseudoVLUXEI16_V_M2_M8, VLUXEI16_V, 0x3, 0x0 }, // 4129
  { PseudoVLUXEI16_V_M2_M8_MASK, VLUXEI16_V, 0x3, 0x0 }, // 4130
  { PseudoVLUXEI16_V_M4_M8, VLUXEI16_V, 0x3, 0x0 }, // 4131
  { PseudoVLUXEI16_V_M4_M8_MASK, VLUXEI16_V, 0x3, 0x0 }, // 4132
  { PseudoVLUXEI16_V_M8_M8, VLUXEI16_V, 0x3, 0x0 }, // 4133
  { PseudoVLUXEI16_V_M8_M8_MASK, VLUXEI16_V, 0x3, 0x0 }, // 4134
  { PseudoVLUXEI16_V_MF4_MF8, VLUXEI16_V, 0x5, 0x0 }, // 4135
  { PseudoVLUXEI16_V_MF4_MF8_MASK, VLUXEI16_V, 0x5, 0x0 }, // 4136
  { PseudoVLUXEI16_V_MF2_MF4, VLUXEI16_V, 0x6, 0x0 }, // 4137
  { PseudoVLUXEI16_V_MF2_MF4_MASK, VLUXEI16_V, 0x6, 0x0 }, // 4138
  { PseudoVLUXEI16_V_MF4_MF4, VLUXEI16_V, 0x6, 0x0 }, // 4139
  { PseudoVLUXEI16_V_MF4_MF4_MASK, VLUXEI16_V, 0x6, 0x0 }, // 4140
  { PseudoVLUXEI16_V_M1_MF2, VLUXEI16_V, 0x7, 0x0 }, // 4141
  { PseudoVLUXEI16_V_M1_MF2_MASK, VLUXEI16_V, 0x7, 0x0 }, // 4142
  { PseudoVLUXEI16_V_MF2_MF2, VLUXEI16_V, 0x7, 0x0 }, // 4143
  { PseudoVLUXEI16_V_MF2_MF2_MASK, VLUXEI16_V, 0x7, 0x0 }, // 4144
  { PseudoVLUXEI16_V_MF4_MF2, VLUXEI16_V, 0x7, 0x0 }, // 4145
  { PseudoVLUXEI16_V_MF4_MF2_MASK, VLUXEI16_V, 0x7, 0x0 }, // 4146
  { PseudoVLUXEI32_V_M1_M1, VLUXEI32_V, 0x0, 0x0 }, // 4147
  { PseudoVLUXEI32_V_M1_M1_MASK, VLUXEI32_V, 0x0, 0x0 }, // 4148
  { PseudoVLUXEI32_V_M2_M1, VLUXEI32_V, 0x0, 0x0 }, // 4149
  { PseudoVLUXEI32_V_M2_M1_MASK, VLUXEI32_V, 0x0, 0x0 }, // 4150
  { PseudoVLUXEI32_V_M4_M1, VLUXEI32_V, 0x0, 0x0 }, // 4151
  { PseudoVLUXEI32_V_M4_M1_MASK, VLUXEI32_V, 0x0, 0x0 }, // 4152
  { PseudoVLUXEI32_V_MF2_M1, VLUXEI32_V, 0x0, 0x0 }, // 4153
  { PseudoVLUXEI32_V_MF2_M1_MASK, VLUXEI32_V, 0x0, 0x0 }, // 4154
  { PseudoVLUXEI32_V_M1_M2, VLUXEI32_V, 0x1, 0x0 }, // 4155
  { PseudoVLUXEI32_V_M1_M2_MASK, VLUXEI32_V, 0x1, 0x0 }, // 4156
  { PseudoVLUXEI32_V_M2_M2, VLUXEI32_V, 0x1, 0x0 }, // 4157
  { PseudoVLUXEI32_V_M2_M2_MASK, VLUXEI32_V, 0x1, 0x0 }, // 4158
  { PseudoVLUXEI32_V_M4_M2, VLUXEI32_V, 0x1, 0x0 }, // 4159
  { PseudoVLUXEI32_V_M4_M2_MASK, VLUXEI32_V, 0x1, 0x0 }, // 4160
  { PseudoVLUXEI32_V_M8_M2, VLUXEI32_V, 0x1, 0x0 }, // 4161
  { PseudoVLUXEI32_V_M8_M2_MASK, VLUXEI32_V, 0x1, 0x0 }, // 4162
  { PseudoVLUXEI32_V_M2_M4, VLUXEI32_V, 0x2, 0x0 }, // 4163
  { PseudoVLUXEI32_V_M2_M4_MASK, VLUXEI32_V, 0x2, 0x0 }, // 4164
  { PseudoVLUXEI32_V_M4_M4, VLUXEI32_V, 0x2, 0x0 }, // 4165
  { PseudoVLUXEI32_V_M4_M4_MASK, VLUXEI32_V, 0x2, 0x0 }, // 4166
  { PseudoVLUXEI32_V_M8_M4, VLUXEI32_V, 0x2, 0x0 }, // 4167
  { PseudoVLUXEI32_V_M8_M4_MASK, VLUXEI32_V, 0x2, 0x0 }, // 4168
  { PseudoVLUXEI32_V_M4_M8, VLUXEI32_V, 0x3, 0x0 }, // 4169
  { PseudoVLUXEI32_V_M4_M8_MASK, VLUXEI32_V, 0x3, 0x0 }, // 4170
  { PseudoVLUXEI32_V_M8_M8, VLUXEI32_V, 0x3, 0x0 }, // 4171
  { PseudoVLUXEI32_V_M8_M8_MASK, VLUXEI32_V, 0x3, 0x0 }, // 4172
  { PseudoVLUXEI32_V_MF2_MF8, VLUXEI32_V, 0x5, 0x0 }, // 4173
  { PseudoVLUXEI32_V_MF2_MF8_MASK, VLUXEI32_V, 0x5, 0x0 }, // 4174
  { PseudoVLUXEI32_V_M1_MF4, VLUXEI32_V, 0x6, 0x0 }, // 4175
  { PseudoVLUXEI32_V_M1_MF4_MASK, VLUXEI32_V, 0x6, 0x0 }, // 4176
  { PseudoVLUXEI32_V_MF2_MF4, VLUXEI32_V, 0x6, 0x0 }, // 4177
  { PseudoVLUXEI32_V_MF2_MF4_MASK, VLUXEI32_V, 0x6, 0x0 }, // 4178
  { PseudoVLUXEI32_V_M1_MF2, VLUXEI32_V, 0x7, 0x0 }, // 4179
  { PseudoVLUXEI32_V_M1_MF2_MASK, VLUXEI32_V, 0x7, 0x0 }, // 4180
  { PseudoVLUXEI32_V_M2_MF2, VLUXEI32_V, 0x7, 0x0 }, // 4181
  { PseudoVLUXEI32_V_M2_MF2_MASK, VLUXEI32_V, 0x7, 0x0 }, // 4182
  { PseudoVLUXEI32_V_MF2_MF2, VLUXEI32_V, 0x7, 0x0 }, // 4183
  { PseudoVLUXEI32_V_MF2_MF2_MASK, VLUXEI32_V, 0x7, 0x0 }, // 4184
  { PseudoVLUXEI64_V_M1_M1, VLUXEI64_V, 0x0, 0x0 }, // 4185
  { PseudoVLUXEI64_V_M1_M1_MASK, VLUXEI64_V, 0x0, 0x0 }, // 4186
  { PseudoVLUXEI64_V_M2_M1, VLUXEI64_V, 0x0, 0x0 }, // 4187
  { PseudoVLUXEI64_V_M2_M1_MASK, VLUXEI64_V, 0x0, 0x0 }, // 4188
  { PseudoVLUXEI64_V_M4_M1, VLUXEI64_V, 0x0, 0x0 }, // 4189
  { PseudoVLUXEI64_V_M4_M1_MASK, VLUXEI64_V, 0x0, 0x0 }, // 4190
  { PseudoVLUXEI64_V_M8_M1, VLUXEI64_V, 0x0, 0x0 }, // 4191
  { PseudoVLUXEI64_V_M8_M1_MASK, VLUXEI64_V, 0x0, 0x0 }, // 4192
  { PseudoVLUXEI64_V_M2_M2, VLUXEI64_V, 0x1, 0x0 }, // 4193
  { PseudoVLUXEI64_V_M2_M2_MASK, VLUXEI64_V, 0x1, 0x0 }, // 4194
  { PseudoVLUXEI64_V_M4_M2, VLUXEI64_V, 0x1, 0x0 }, // 4195
  { PseudoVLUXEI64_V_M4_M2_MASK, VLUXEI64_V, 0x1, 0x0 }, // 4196
  { PseudoVLUXEI64_V_M8_M2, VLUXEI64_V, 0x1, 0x0 }, // 4197
  { PseudoVLUXEI64_V_M8_M2_MASK, VLUXEI64_V, 0x1, 0x0 }, // 4198
  { PseudoVLUXEI64_V_M4_M4, VLUXEI64_V, 0x2, 0x0 }, // 4199
  { PseudoVLUXEI64_V_M4_M4_MASK, VLUXEI64_V, 0x2, 0x0 }, // 4200
  { PseudoVLUXEI64_V_M8_M4, VLUXEI64_V, 0x2, 0x0 }, // 4201
  { PseudoVLUXEI64_V_M8_M4_MASK, VLUXEI64_V, 0x2, 0x0 }, // 4202
  { PseudoVLUXEI64_V_M8_M8, VLUXEI64_V, 0x3, 0x0 }, // 4203
  { PseudoVLUXEI64_V_M8_M8_MASK, VLUXEI64_V, 0x3, 0x0 }, // 4204
  { PseudoVLUXEI64_V_M1_MF8, VLUXEI64_V, 0x5, 0x0 }, // 4205
  { PseudoVLUXEI64_V_M1_MF8_MASK, VLUXEI64_V, 0x5, 0x0 }, // 4206
  { PseudoVLUXEI64_V_M1_MF4, VLUXEI64_V, 0x6, 0x0 }, // 4207
  { PseudoVLUXEI64_V_M1_MF4_MASK, VLUXEI64_V, 0x6, 0x0 }, // 4208
  { PseudoVLUXEI64_V_M2_MF4, VLUXEI64_V, 0x6, 0x0 }, // 4209
  { PseudoVLUXEI64_V_M2_MF4_MASK, VLUXEI64_V, 0x6, 0x0 }, // 4210
  { PseudoVLUXEI64_V_M1_MF2, VLUXEI64_V, 0x7, 0x0 }, // 4211
  { PseudoVLUXEI64_V_M1_MF2_MASK, VLUXEI64_V, 0x7, 0x0 }, // 4212
  { PseudoVLUXEI64_V_M2_MF2, VLUXEI64_V, 0x7, 0x0 }, // 4213
  { PseudoVLUXEI64_V_M2_MF2_MASK, VLUXEI64_V, 0x7, 0x0 }, // 4214
  { PseudoVLUXEI64_V_M4_MF2, VLUXEI64_V, 0x7, 0x0 }, // 4215
  { PseudoVLUXEI64_V_M4_MF2_MASK, VLUXEI64_V, 0x7, 0x0 }, // 4216
  { PseudoVLUXEI8_V_M1_M1, VLUXEI8_V, 0x0, 0x0 }, // 4217
  { PseudoVLUXEI8_V_M1_M1_MASK, VLUXEI8_V, 0x0, 0x0 }, // 4218
  { PseudoVLUXEI8_V_MF2_M1, VLUXEI8_V, 0x0, 0x0 }, // 4219
  { PseudoVLUXEI8_V_MF2_M1_MASK, VLUXEI8_V, 0x0, 0x0 }, // 4220
  { PseudoVLUXEI8_V_MF4_M1, VLUXEI8_V, 0x0, 0x0 }, // 4221
  { PseudoVLUXEI8_V_MF4_M1_MASK, VLUXEI8_V, 0x0, 0x0 }, // 4222
  { PseudoVLUXEI8_V_MF8_M1, VLUXEI8_V, 0x0, 0x0 }, // 4223
  { PseudoVLUXEI8_V_MF8_M1_MASK, VLUXEI8_V, 0x0, 0x0 }, // 4224
  { PseudoVLUXEI8_V_M1_M2, VLUXEI8_V, 0x1, 0x0 }, // 4225
  { PseudoVLUXEI8_V_M1_M2_MASK, VLUXEI8_V, 0x1, 0x0 }, // 4226
  { PseudoVLUXEI8_V_M2_M2, VLUXEI8_V, 0x1, 0x0 }, // 4227
  { PseudoVLUXEI8_V_M2_M2_MASK, VLUXEI8_V, 0x1, 0x0 }, // 4228
  { PseudoVLUXEI8_V_MF2_M2, VLUXEI8_V, 0x1, 0x0 }, // 4229
  { PseudoVLUXEI8_V_MF2_M2_MASK, VLUXEI8_V, 0x1, 0x0 }, // 4230
  { PseudoVLUXEI8_V_MF4_M2, VLUXEI8_V, 0x1, 0x0 }, // 4231
  { PseudoVLUXEI8_V_MF4_M2_MASK, VLUXEI8_V, 0x1, 0x0 }, // 4232
  { PseudoVLUXEI8_V_M1_M4, VLUXEI8_V, 0x2, 0x0 }, // 4233
  { PseudoVLUXEI8_V_M1_M4_MASK, VLUXEI8_V, 0x2, 0x0 }, // 4234
  { PseudoVLUXEI8_V_M2_M4, VLUXEI8_V, 0x2, 0x0 }, // 4235
  { PseudoVLUXEI8_V_M2_M4_MASK, VLUXEI8_V, 0x2, 0x0 }, // 4236
  { PseudoVLUXEI8_V_M4_M4, VLUXEI8_V, 0x2, 0x0 }, // 4237
  { PseudoVLUXEI8_V_M4_M4_MASK, VLUXEI8_V, 0x2, 0x0 }, // 4238
  { PseudoVLUXEI8_V_MF2_M4, VLUXEI8_V, 0x2, 0x0 }, // 4239
  { PseudoVLUXEI8_V_MF2_M4_MASK, VLUXEI8_V, 0x2, 0x0 }, // 4240
  { PseudoVLUXEI8_V_M1_M8, VLUXEI8_V, 0x3, 0x0 }, // 4241
  { PseudoVLUXEI8_V_M1_M8_MASK, VLUXEI8_V, 0x3, 0x0 }, // 4242
  { PseudoVLUXEI8_V_M2_M8, VLUXEI8_V, 0x3, 0x0 }, // 4243
  { PseudoVLUXEI8_V_M2_M8_MASK, VLUXEI8_V, 0x3, 0x0 }, // 4244
  { PseudoVLUXEI8_V_M4_M8, VLUXEI8_V, 0x3, 0x0 }, // 4245
  { PseudoVLUXEI8_V_M4_M8_MASK, VLUXEI8_V, 0x3, 0x0 }, // 4246
  { PseudoVLUXEI8_V_M8_M8, VLUXEI8_V, 0x3, 0x0 }, // 4247
  { PseudoVLUXEI8_V_M8_M8_MASK, VLUXEI8_V, 0x3, 0x0 }, // 4248
  { PseudoVLUXEI8_V_MF8_MF8, VLUXEI8_V, 0x5, 0x0 }, // 4249
  { PseudoVLUXEI8_V_MF8_MF8_MASK, VLUXEI8_V, 0x5, 0x0 }, // 4250
  { PseudoVLUXEI8_V_MF4_MF4, VLUXEI8_V, 0x6, 0x0 }, // 4251
  { PseudoVLUXEI8_V_MF4_MF4_MASK, VLUXEI8_V, 0x6, 0x0 }, // 4252
  { PseudoVLUXEI8_V_MF8_MF4, VLUXEI8_V, 0x6, 0x0 }, // 4253
  { PseudoVLUXEI8_V_MF8_MF4_MASK, VLUXEI8_V, 0x6, 0x0 }, // 4254
  { PseudoVLUXEI8_V_MF2_MF2, VLUXEI8_V, 0x7, 0x0 }, // 4255
  { PseudoVLUXEI8_V_MF2_MF2_MASK, VLUXEI8_V, 0x7, 0x0 }, // 4256
  { PseudoVLUXEI8_V_MF4_MF2, VLUXEI8_V, 0x7, 0x0 }, // 4257
  { PseudoVLUXEI8_V_MF4_MF2_MASK, VLUXEI8_V, 0x7, 0x0 }, // 4258
  { PseudoVLUXEI8_V_MF8_MF2, VLUXEI8_V, 0x7, 0x0 }, // 4259
  { PseudoVLUXEI8_V_MF8_MF2_MASK, VLUXEI8_V, 0x7, 0x0 }, // 4260
  { PseudoVLUXSEG2EI16_V_M1_M1, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4261
  { PseudoVLUXSEG2EI16_V_M1_M1_MASK, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4262
  { PseudoVLUXSEG2EI16_V_M2_M1, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4263
  { PseudoVLUXSEG2EI16_V_M2_M1_MASK, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4264
  { PseudoVLUXSEG2EI16_V_MF2_M1, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4265
  { PseudoVLUXSEG2EI16_V_MF2_M1_MASK, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4266
  { PseudoVLUXSEG2EI16_V_MF4_M1, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4267
  { PseudoVLUXSEG2EI16_V_MF4_M1_MASK, VLUXSEG2EI16_V, 0x0, 0x0 }, // 4268
  { PseudoVLUXSEG2EI16_V_M1_M2, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4269
  { PseudoVLUXSEG2EI16_V_M1_M2_MASK, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4270
  { PseudoVLUXSEG2EI16_V_M2_M2, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4271
  { PseudoVLUXSEG2EI16_V_M2_M2_MASK, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4272
  { PseudoVLUXSEG2EI16_V_M4_M2, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4273
  { PseudoVLUXSEG2EI16_V_M4_M2_MASK, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4274
  { PseudoVLUXSEG2EI16_V_MF2_M2, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4275
  { PseudoVLUXSEG2EI16_V_MF2_M2_MASK, VLUXSEG2EI16_V, 0x1, 0x0 }, // 4276
  { PseudoVLUXSEG2EI16_V_M1_M4, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4277
  { PseudoVLUXSEG2EI16_V_M1_M4_MASK, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4278
  { PseudoVLUXSEG2EI16_V_M2_M4, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4279
  { PseudoVLUXSEG2EI16_V_M2_M4_MASK, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4280
  { PseudoVLUXSEG2EI16_V_M4_M4, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4281
  { PseudoVLUXSEG2EI16_V_M4_M4_MASK, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4282
  { PseudoVLUXSEG2EI16_V_M8_M4, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4283
  { PseudoVLUXSEG2EI16_V_M8_M4_MASK, VLUXSEG2EI16_V, 0x2, 0x0 }, // 4284
  { PseudoVLUXSEG2EI16_V_MF4_MF8, VLUXSEG2EI16_V, 0x5, 0x0 }, // 4285
  { PseudoVLUXSEG2EI16_V_MF4_MF8_MASK, VLUXSEG2EI16_V, 0x5, 0x0 }, // 4286
  { PseudoVLUXSEG2EI16_V_MF2_MF4, VLUXSEG2EI16_V, 0x6, 0x0 }, // 4287
  { PseudoVLUXSEG2EI16_V_MF2_MF4_MASK, VLUXSEG2EI16_V, 0x6, 0x0 }, // 4288
  { PseudoVLUXSEG2EI16_V_MF4_MF4, VLUXSEG2EI16_V, 0x6, 0x0 }, // 4289
  { PseudoVLUXSEG2EI16_V_MF4_MF4_MASK, VLUXSEG2EI16_V, 0x6, 0x0 }, // 4290
  { PseudoVLUXSEG2EI16_V_M1_MF2, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4291
  { PseudoVLUXSEG2EI16_V_M1_MF2_MASK, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4292
  { PseudoVLUXSEG2EI16_V_MF2_MF2, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4293
  { PseudoVLUXSEG2EI16_V_MF2_MF2_MASK, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4294
  { PseudoVLUXSEG2EI16_V_MF4_MF2, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4295
  { PseudoVLUXSEG2EI16_V_MF4_MF2_MASK, VLUXSEG2EI16_V, 0x7, 0x0 }, // 4296
  { PseudoVLUXSEG2EI32_V_M1_M1, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4297
  { PseudoVLUXSEG2EI32_V_M1_M1_MASK, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4298
  { PseudoVLUXSEG2EI32_V_M2_M1, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4299
  { PseudoVLUXSEG2EI32_V_M2_M1_MASK, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4300
  { PseudoVLUXSEG2EI32_V_M4_M1, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4301
  { PseudoVLUXSEG2EI32_V_M4_M1_MASK, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4302
  { PseudoVLUXSEG2EI32_V_MF2_M1, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4303
  { PseudoVLUXSEG2EI32_V_MF2_M1_MASK, VLUXSEG2EI32_V, 0x0, 0x0 }, // 4304
  { PseudoVLUXSEG2EI32_V_M1_M2, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4305
  { PseudoVLUXSEG2EI32_V_M1_M2_MASK, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4306
  { PseudoVLUXSEG2EI32_V_M2_M2, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4307
  { PseudoVLUXSEG2EI32_V_M2_M2_MASK, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4308
  { PseudoVLUXSEG2EI32_V_M4_M2, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4309
  { PseudoVLUXSEG2EI32_V_M4_M2_MASK, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4310
  { PseudoVLUXSEG2EI32_V_M8_M2, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4311
  { PseudoVLUXSEG2EI32_V_M8_M2_MASK, VLUXSEG2EI32_V, 0x1, 0x0 }, // 4312
  { PseudoVLUXSEG2EI32_V_M2_M4, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4313
  { PseudoVLUXSEG2EI32_V_M2_M4_MASK, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4314
  { PseudoVLUXSEG2EI32_V_M4_M4, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4315
  { PseudoVLUXSEG2EI32_V_M4_M4_MASK, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4316
  { PseudoVLUXSEG2EI32_V_M8_M4, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4317
  { PseudoVLUXSEG2EI32_V_M8_M4_MASK, VLUXSEG2EI32_V, 0x2, 0x0 }, // 4318
  { PseudoVLUXSEG2EI32_V_MF2_MF8, VLUXSEG2EI32_V, 0x5, 0x0 }, // 4319
  { PseudoVLUXSEG2EI32_V_MF2_MF8_MASK, VLUXSEG2EI32_V, 0x5, 0x0 }, // 4320
  { PseudoVLUXSEG2EI32_V_M1_MF4, VLUXSEG2EI32_V, 0x6, 0x0 }, // 4321
  { PseudoVLUXSEG2EI32_V_M1_MF4_MASK, VLUXSEG2EI32_V, 0x6, 0x0 }, // 4322
  { PseudoVLUXSEG2EI32_V_MF2_MF4, VLUXSEG2EI32_V, 0x6, 0x0 }, // 4323
  { PseudoVLUXSEG2EI32_V_MF2_MF4_MASK, VLUXSEG2EI32_V, 0x6, 0x0 }, // 4324
  { PseudoVLUXSEG2EI32_V_M1_MF2, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4325
  { PseudoVLUXSEG2EI32_V_M1_MF2_MASK, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4326
  { PseudoVLUXSEG2EI32_V_M2_MF2, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4327
  { PseudoVLUXSEG2EI32_V_M2_MF2_MASK, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4328
  { PseudoVLUXSEG2EI32_V_MF2_MF2, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4329
  { PseudoVLUXSEG2EI32_V_MF2_MF2_MASK, VLUXSEG2EI32_V, 0x7, 0x0 }, // 4330
  { PseudoVLUXSEG2EI64_V_M1_M1, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4331
  { PseudoVLUXSEG2EI64_V_M1_M1_MASK, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4332
  { PseudoVLUXSEG2EI64_V_M2_M1, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4333
  { PseudoVLUXSEG2EI64_V_M2_M1_MASK, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4334
  { PseudoVLUXSEG2EI64_V_M4_M1, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4335
  { PseudoVLUXSEG2EI64_V_M4_M1_MASK, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4336
  { PseudoVLUXSEG2EI64_V_M8_M1, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4337
  { PseudoVLUXSEG2EI64_V_M8_M1_MASK, VLUXSEG2EI64_V, 0x0, 0x0 }, // 4338
  { PseudoVLUXSEG2EI64_V_M2_M2, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4339
  { PseudoVLUXSEG2EI64_V_M2_M2_MASK, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4340
  { PseudoVLUXSEG2EI64_V_M4_M2, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4341
  { PseudoVLUXSEG2EI64_V_M4_M2_MASK, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4342
  { PseudoVLUXSEG2EI64_V_M8_M2, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4343
  { PseudoVLUXSEG2EI64_V_M8_M2_MASK, VLUXSEG2EI64_V, 0x1, 0x0 }, // 4344
  { PseudoVLUXSEG2EI64_V_M4_M4, VLUXSEG2EI64_V, 0x2, 0x0 }, // 4345
  { PseudoVLUXSEG2EI64_V_M4_M4_MASK, VLUXSEG2EI64_V, 0x2, 0x0 }, // 4346
  { PseudoVLUXSEG2EI64_V_M8_M4, VLUXSEG2EI64_V, 0x2, 0x0 }, // 4347
  { PseudoVLUXSEG2EI64_V_M8_M4_MASK, VLUXSEG2EI64_V, 0x2, 0x0 }, // 4348
  { PseudoVLUXSEG2EI64_V_M1_MF8, VLUXSEG2EI64_V, 0x5, 0x0 }, // 4349
  { PseudoVLUXSEG2EI64_V_M1_MF8_MASK, VLUXSEG2EI64_V, 0x5, 0x0 }, // 4350
  { PseudoVLUXSEG2EI64_V_M1_MF4, VLUXSEG2EI64_V, 0x6, 0x0 }, // 4351
  { PseudoVLUXSEG2EI64_V_M1_MF4_MASK, VLUXSEG2EI64_V, 0x6, 0x0 }, // 4352
  { PseudoVLUXSEG2EI64_V_M2_MF4, VLUXSEG2EI64_V, 0x6, 0x0 }, // 4353
  { PseudoVLUXSEG2EI64_V_M2_MF4_MASK, VLUXSEG2EI64_V, 0x6, 0x0 }, // 4354
  { PseudoVLUXSEG2EI64_V_M1_MF2, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4355
  { PseudoVLUXSEG2EI64_V_M1_MF2_MASK, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4356
  { PseudoVLUXSEG2EI64_V_M2_MF2, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4357
  { PseudoVLUXSEG2EI64_V_M2_MF2_MASK, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4358
  { PseudoVLUXSEG2EI64_V_M4_MF2, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4359
  { PseudoVLUXSEG2EI64_V_M4_MF2_MASK, VLUXSEG2EI64_V, 0x7, 0x0 }, // 4360
  { PseudoVLUXSEG2EI8_V_M1_M1, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4361
  { PseudoVLUXSEG2EI8_V_M1_M1_MASK, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4362
  { PseudoVLUXSEG2EI8_V_MF2_M1, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4363
  { PseudoVLUXSEG2EI8_V_MF2_M1_MASK, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4364
  { PseudoVLUXSEG2EI8_V_MF4_M1, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4365
  { PseudoVLUXSEG2EI8_V_MF4_M1_MASK, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4366
  { PseudoVLUXSEG2EI8_V_MF8_M1, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4367
  { PseudoVLUXSEG2EI8_V_MF8_M1_MASK, VLUXSEG2EI8_V, 0x0, 0x0 }, // 4368
  { PseudoVLUXSEG2EI8_V_M1_M2, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4369
  { PseudoVLUXSEG2EI8_V_M1_M2_MASK, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4370
  { PseudoVLUXSEG2EI8_V_M2_M2, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4371
  { PseudoVLUXSEG2EI8_V_M2_M2_MASK, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4372
  { PseudoVLUXSEG2EI8_V_MF2_M2, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4373
  { PseudoVLUXSEG2EI8_V_MF2_M2_MASK, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4374
  { PseudoVLUXSEG2EI8_V_MF4_M2, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4375
  { PseudoVLUXSEG2EI8_V_MF4_M2_MASK, VLUXSEG2EI8_V, 0x1, 0x0 }, // 4376
  { PseudoVLUXSEG2EI8_V_M1_M4, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4377
  { PseudoVLUXSEG2EI8_V_M1_M4_MASK, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4378
  { PseudoVLUXSEG2EI8_V_M2_M4, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4379
  { PseudoVLUXSEG2EI8_V_M2_M4_MASK, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4380
  { PseudoVLUXSEG2EI8_V_M4_M4, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4381
  { PseudoVLUXSEG2EI8_V_M4_M4_MASK, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4382
  { PseudoVLUXSEG2EI8_V_MF2_M4, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4383
  { PseudoVLUXSEG2EI8_V_MF2_M4_MASK, VLUXSEG2EI8_V, 0x2, 0x0 }, // 4384
  { PseudoVLUXSEG2EI8_V_MF8_MF8, VLUXSEG2EI8_V, 0x5, 0x0 }, // 4385
  { PseudoVLUXSEG2EI8_V_MF8_MF8_MASK, VLUXSEG2EI8_V, 0x5, 0x0 }, // 4386
  { PseudoVLUXSEG2EI8_V_MF4_MF4, VLUXSEG2EI8_V, 0x6, 0x0 }, // 4387
  { PseudoVLUXSEG2EI8_V_MF4_MF4_MASK, VLUXSEG2EI8_V, 0x6, 0x0 }, // 4388
  { PseudoVLUXSEG2EI8_V_MF8_MF4, VLUXSEG2EI8_V, 0x6, 0x0 }, // 4389
  { PseudoVLUXSEG2EI8_V_MF8_MF4_MASK, VLUXSEG2EI8_V, 0x6, 0x0 }, // 4390
  { PseudoVLUXSEG2EI8_V_MF2_MF2, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4391
  { PseudoVLUXSEG2EI8_V_MF2_MF2_MASK, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4392
  { PseudoVLUXSEG2EI8_V_MF4_MF2, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4393
  { PseudoVLUXSEG2EI8_V_MF4_MF2_MASK, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4394
  { PseudoVLUXSEG2EI8_V_MF8_MF2, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4395
  { PseudoVLUXSEG2EI8_V_MF8_MF2_MASK, VLUXSEG2EI8_V, 0x7, 0x0 }, // 4396
  { PseudoVLUXSEG3EI16_V_M1_M1, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4397
  { PseudoVLUXSEG3EI16_V_M1_M1_MASK, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4398
  { PseudoVLUXSEG3EI16_V_M2_M1, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4399
  { PseudoVLUXSEG3EI16_V_M2_M1_MASK, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4400
  { PseudoVLUXSEG3EI16_V_MF2_M1, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4401
  { PseudoVLUXSEG3EI16_V_MF2_M1_MASK, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4402
  { PseudoVLUXSEG3EI16_V_MF4_M1, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4403
  { PseudoVLUXSEG3EI16_V_MF4_M1_MASK, VLUXSEG3EI16_V, 0x0, 0x0 }, // 4404
  { PseudoVLUXSEG3EI16_V_M1_M2, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4405
  { PseudoVLUXSEG3EI16_V_M1_M2_MASK, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4406
  { PseudoVLUXSEG3EI16_V_M2_M2, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4407
  { PseudoVLUXSEG3EI16_V_M2_M2_MASK, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4408
  { PseudoVLUXSEG3EI16_V_M4_M2, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4409
  { PseudoVLUXSEG3EI16_V_M4_M2_MASK, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4410
  { PseudoVLUXSEG3EI16_V_MF2_M2, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4411
  { PseudoVLUXSEG3EI16_V_MF2_M2_MASK, VLUXSEG3EI16_V, 0x1, 0x0 }, // 4412
  { PseudoVLUXSEG3EI16_V_MF4_MF8, VLUXSEG3EI16_V, 0x5, 0x0 }, // 4413
  { PseudoVLUXSEG3EI16_V_MF4_MF8_MASK, VLUXSEG3EI16_V, 0x5, 0x0 }, // 4414
  { PseudoVLUXSEG3EI16_V_MF2_MF4, VLUXSEG3EI16_V, 0x6, 0x0 }, // 4415
  { PseudoVLUXSEG3EI16_V_MF2_MF4_MASK, VLUXSEG3EI16_V, 0x6, 0x0 }, // 4416
  { PseudoVLUXSEG3EI16_V_MF4_MF4, VLUXSEG3EI16_V, 0x6, 0x0 }, // 4417
  { PseudoVLUXSEG3EI16_V_MF4_MF4_MASK, VLUXSEG3EI16_V, 0x6, 0x0 }, // 4418
  { PseudoVLUXSEG3EI16_V_M1_MF2, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4419
  { PseudoVLUXSEG3EI16_V_M1_MF2_MASK, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4420
  { PseudoVLUXSEG3EI16_V_MF2_MF2, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4421
  { PseudoVLUXSEG3EI16_V_MF2_MF2_MASK, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4422
  { PseudoVLUXSEG3EI16_V_MF4_MF2, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4423
  { PseudoVLUXSEG3EI16_V_MF4_MF2_MASK, VLUXSEG3EI16_V, 0x7, 0x0 }, // 4424
  { PseudoVLUXSEG3EI32_V_M1_M1, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4425
  { PseudoVLUXSEG3EI32_V_M1_M1_MASK, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4426
  { PseudoVLUXSEG3EI32_V_M2_M1, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4427
  { PseudoVLUXSEG3EI32_V_M2_M1_MASK, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4428
  { PseudoVLUXSEG3EI32_V_M4_M1, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4429
  { PseudoVLUXSEG3EI32_V_M4_M1_MASK, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4430
  { PseudoVLUXSEG3EI32_V_MF2_M1, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4431
  { PseudoVLUXSEG3EI32_V_MF2_M1_MASK, VLUXSEG3EI32_V, 0x0, 0x0 }, // 4432
  { PseudoVLUXSEG3EI32_V_M1_M2, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4433
  { PseudoVLUXSEG3EI32_V_M1_M2_MASK, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4434
  { PseudoVLUXSEG3EI32_V_M2_M2, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4435
  { PseudoVLUXSEG3EI32_V_M2_M2_MASK, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4436
  { PseudoVLUXSEG3EI32_V_M4_M2, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4437
  { PseudoVLUXSEG3EI32_V_M4_M2_MASK, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4438
  { PseudoVLUXSEG3EI32_V_M8_M2, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4439
  { PseudoVLUXSEG3EI32_V_M8_M2_MASK, VLUXSEG3EI32_V, 0x1, 0x0 }, // 4440
  { PseudoVLUXSEG3EI32_V_MF2_MF8, VLUXSEG3EI32_V, 0x5, 0x0 }, // 4441
  { PseudoVLUXSEG3EI32_V_MF2_MF8_MASK, VLUXSEG3EI32_V, 0x5, 0x0 }, // 4442
  { PseudoVLUXSEG3EI32_V_M1_MF4, VLUXSEG3EI32_V, 0x6, 0x0 }, // 4443
  { PseudoVLUXSEG3EI32_V_M1_MF4_MASK, VLUXSEG3EI32_V, 0x6, 0x0 }, // 4444
  { PseudoVLUXSEG3EI32_V_MF2_MF4, VLUXSEG3EI32_V, 0x6, 0x0 }, // 4445
  { PseudoVLUXSEG3EI32_V_MF2_MF4_MASK, VLUXSEG3EI32_V, 0x6, 0x0 }, // 4446
  { PseudoVLUXSEG3EI32_V_M1_MF2, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4447
  { PseudoVLUXSEG3EI32_V_M1_MF2_MASK, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4448
  { PseudoVLUXSEG3EI32_V_M2_MF2, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4449
  { PseudoVLUXSEG3EI32_V_M2_MF2_MASK, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4450
  { PseudoVLUXSEG3EI32_V_MF2_MF2, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4451
  { PseudoVLUXSEG3EI32_V_MF2_MF2_MASK, VLUXSEG3EI32_V, 0x7, 0x0 }, // 4452
  { PseudoVLUXSEG3EI64_V_M1_M1, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4453
  { PseudoVLUXSEG3EI64_V_M1_M1_MASK, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4454
  { PseudoVLUXSEG3EI64_V_M2_M1, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4455
  { PseudoVLUXSEG3EI64_V_M2_M1_MASK, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4456
  { PseudoVLUXSEG3EI64_V_M4_M1, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4457
  { PseudoVLUXSEG3EI64_V_M4_M1_MASK, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4458
  { PseudoVLUXSEG3EI64_V_M8_M1, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4459
  { PseudoVLUXSEG3EI64_V_M8_M1_MASK, VLUXSEG3EI64_V, 0x0, 0x0 }, // 4460
  { PseudoVLUXSEG3EI64_V_M2_M2, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4461
  { PseudoVLUXSEG3EI64_V_M2_M2_MASK, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4462
  { PseudoVLUXSEG3EI64_V_M4_M2, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4463
  { PseudoVLUXSEG3EI64_V_M4_M2_MASK, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4464
  { PseudoVLUXSEG3EI64_V_M8_M2, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4465
  { PseudoVLUXSEG3EI64_V_M8_M2_MASK, VLUXSEG3EI64_V, 0x1, 0x0 }, // 4466
  { PseudoVLUXSEG3EI64_V_M1_MF8, VLUXSEG3EI64_V, 0x5, 0x0 }, // 4467
  { PseudoVLUXSEG3EI64_V_M1_MF8_MASK, VLUXSEG3EI64_V, 0x5, 0x0 }, // 4468
  { PseudoVLUXSEG3EI64_V_M1_MF4, VLUXSEG3EI64_V, 0x6, 0x0 }, // 4469
  { PseudoVLUXSEG3EI64_V_M1_MF4_MASK, VLUXSEG3EI64_V, 0x6, 0x0 }, // 4470
  { PseudoVLUXSEG3EI64_V_M2_MF4, VLUXSEG3EI64_V, 0x6, 0x0 }, // 4471
  { PseudoVLUXSEG3EI64_V_M2_MF4_MASK, VLUXSEG3EI64_V, 0x6, 0x0 }, // 4472
  { PseudoVLUXSEG3EI64_V_M1_MF2, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4473
  { PseudoVLUXSEG3EI64_V_M1_MF2_MASK, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4474
  { PseudoVLUXSEG3EI64_V_M2_MF2, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4475
  { PseudoVLUXSEG3EI64_V_M2_MF2_MASK, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4476
  { PseudoVLUXSEG3EI64_V_M4_MF2, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4477
  { PseudoVLUXSEG3EI64_V_M4_MF2_MASK, VLUXSEG3EI64_V, 0x7, 0x0 }, // 4478
  { PseudoVLUXSEG3EI8_V_M1_M1, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4479
  { PseudoVLUXSEG3EI8_V_M1_M1_MASK, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4480
  { PseudoVLUXSEG3EI8_V_MF2_M1, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4481
  { PseudoVLUXSEG3EI8_V_MF2_M1_MASK, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4482
  { PseudoVLUXSEG3EI8_V_MF4_M1, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4483
  { PseudoVLUXSEG3EI8_V_MF4_M1_MASK, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4484
  { PseudoVLUXSEG3EI8_V_MF8_M1, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4485
  { PseudoVLUXSEG3EI8_V_MF8_M1_MASK, VLUXSEG3EI8_V, 0x0, 0x0 }, // 4486
  { PseudoVLUXSEG3EI8_V_M1_M2, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4487
  { PseudoVLUXSEG3EI8_V_M1_M2_MASK, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4488
  { PseudoVLUXSEG3EI8_V_M2_M2, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4489
  { PseudoVLUXSEG3EI8_V_M2_M2_MASK, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4490
  { PseudoVLUXSEG3EI8_V_MF2_M2, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4491
  { PseudoVLUXSEG3EI8_V_MF2_M2_MASK, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4492
  { PseudoVLUXSEG3EI8_V_MF4_M2, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4493
  { PseudoVLUXSEG3EI8_V_MF4_M2_MASK, VLUXSEG3EI8_V, 0x1, 0x0 }, // 4494
  { PseudoVLUXSEG3EI8_V_MF8_MF8, VLUXSEG3EI8_V, 0x5, 0x0 }, // 4495
  { PseudoVLUXSEG3EI8_V_MF8_MF8_MASK, VLUXSEG3EI8_V, 0x5, 0x0 }, // 4496
  { PseudoVLUXSEG3EI8_V_MF4_MF4, VLUXSEG3EI8_V, 0x6, 0x0 }, // 4497
  { PseudoVLUXSEG3EI8_V_MF4_MF4_MASK, VLUXSEG3EI8_V, 0x6, 0x0 }, // 4498
  { PseudoVLUXSEG3EI8_V_MF8_MF4, VLUXSEG3EI8_V, 0x6, 0x0 }, // 4499
  { PseudoVLUXSEG3EI8_V_MF8_MF4_MASK, VLUXSEG3EI8_V, 0x6, 0x0 }, // 4500
  { PseudoVLUXSEG3EI8_V_MF2_MF2, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4501
  { PseudoVLUXSEG3EI8_V_MF2_MF2_MASK, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4502
  { PseudoVLUXSEG3EI8_V_MF4_MF2, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4503
  { PseudoVLUXSEG3EI8_V_MF4_MF2_MASK, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4504
  { PseudoVLUXSEG3EI8_V_MF8_MF2, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4505
  { PseudoVLUXSEG3EI8_V_MF8_MF2_MASK, VLUXSEG3EI8_V, 0x7, 0x0 }, // 4506
  { PseudoVLUXSEG4EI16_V_M1_M1, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4507
  { PseudoVLUXSEG4EI16_V_M1_M1_MASK, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4508
  { PseudoVLUXSEG4EI16_V_M2_M1, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4509
  { PseudoVLUXSEG4EI16_V_M2_M1_MASK, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4510
  { PseudoVLUXSEG4EI16_V_MF2_M1, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4511
  { PseudoVLUXSEG4EI16_V_MF2_M1_MASK, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4512
  { PseudoVLUXSEG4EI16_V_MF4_M1, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4513
  { PseudoVLUXSEG4EI16_V_MF4_M1_MASK, VLUXSEG4EI16_V, 0x0, 0x0 }, // 4514
  { PseudoVLUXSEG4EI16_V_M1_M2, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4515
  { PseudoVLUXSEG4EI16_V_M1_M2_MASK, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4516
  { PseudoVLUXSEG4EI16_V_M2_M2, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4517
  { PseudoVLUXSEG4EI16_V_M2_M2_MASK, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4518
  { PseudoVLUXSEG4EI16_V_M4_M2, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4519
  { PseudoVLUXSEG4EI16_V_M4_M2_MASK, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4520
  { PseudoVLUXSEG4EI16_V_MF2_M2, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4521
  { PseudoVLUXSEG4EI16_V_MF2_M2_MASK, VLUXSEG4EI16_V, 0x1, 0x0 }, // 4522
  { PseudoVLUXSEG4EI16_V_MF4_MF8, VLUXSEG4EI16_V, 0x5, 0x0 }, // 4523
  { PseudoVLUXSEG4EI16_V_MF4_MF8_MASK, VLUXSEG4EI16_V, 0x5, 0x0 }, // 4524
  { PseudoVLUXSEG4EI16_V_MF2_MF4, VLUXSEG4EI16_V, 0x6, 0x0 }, // 4525
  { PseudoVLUXSEG4EI16_V_MF2_MF4_MASK, VLUXSEG4EI16_V, 0x6, 0x0 }, // 4526
  { PseudoVLUXSEG4EI16_V_MF4_MF4, VLUXSEG4EI16_V, 0x6, 0x0 }, // 4527
  { PseudoVLUXSEG4EI16_V_MF4_MF4_MASK, VLUXSEG4EI16_V, 0x6, 0x0 }, // 4528
  { PseudoVLUXSEG4EI16_V_M1_MF2, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4529
  { PseudoVLUXSEG4EI16_V_M1_MF2_MASK, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4530
  { PseudoVLUXSEG4EI16_V_MF2_MF2, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4531
  { PseudoVLUXSEG4EI16_V_MF2_MF2_MASK, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4532
  { PseudoVLUXSEG4EI16_V_MF4_MF2, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4533
  { PseudoVLUXSEG4EI16_V_MF4_MF2_MASK, VLUXSEG4EI16_V, 0x7, 0x0 }, // 4534
  { PseudoVLUXSEG4EI32_V_M1_M1, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4535
  { PseudoVLUXSEG4EI32_V_M1_M1_MASK, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4536
  { PseudoVLUXSEG4EI32_V_M2_M1, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4537
  { PseudoVLUXSEG4EI32_V_M2_M1_MASK, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4538
  { PseudoVLUXSEG4EI32_V_M4_M1, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4539
  { PseudoVLUXSEG4EI32_V_M4_M1_MASK, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4540
  { PseudoVLUXSEG4EI32_V_MF2_M1, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4541
  { PseudoVLUXSEG4EI32_V_MF2_M1_MASK, VLUXSEG4EI32_V, 0x0, 0x0 }, // 4542
  { PseudoVLUXSEG4EI32_V_M1_M2, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4543
  { PseudoVLUXSEG4EI32_V_M1_M2_MASK, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4544
  { PseudoVLUXSEG4EI32_V_M2_M2, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4545
  { PseudoVLUXSEG4EI32_V_M2_M2_MASK, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4546
  { PseudoVLUXSEG4EI32_V_M4_M2, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4547
  { PseudoVLUXSEG4EI32_V_M4_M2_MASK, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4548
  { PseudoVLUXSEG4EI32_V_M8_M2, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4549
  { PseudoVLUXSEG4EI32_V_M8_M2_MASK, VLUXSEG4EI32_V, 0x1, 0x0 }, // 4550
  { PseudoVLUXSEG4EI32_V_MF2_MF8, VLUXSEG4EI32_V, 0x5, 0x0 }, // 4551
  { PseudoVLUXSEG4EI32_V_MF2_MF8_MASK, VLUXSEG4EI32_V, 0x5, 0x0 }, // 4552
  { PseudoVLUXSEG4EI32_V_M1_MF4, VLUXSEG4EI32_V, 0x6, 0x0 }, // 4553
  { PseudoVLUXSEG4EI32_V_M1_MF4_MASK, VLUXSEG4EI32_V, 0x6, 0x0 }, // 4554
  { PseudoVLUXSEG4EI32_V_MF2_MF4, VLUXSEG4EI32_V, 0x6, 0x0 }, // 4555
  { PseudoVLUXSEG4EI32_V_MF2_MF4_MASK, VLUXSEG4EI32_V, 0x6, 0x0 }, // 4556
  { PseudoVLUXSEG4EI32_V_M1_MF2, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4557
  { PseudoVLUXSEG4EI32_V_M1_MF2_MASK, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4558
  { PseudoVLUXSEG4EI32_V_M2_MF2, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4559
  { PseudoVLUXSEG4EI32_V_M2_MF2_MASK, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4560
  { PseudoVLUXSEG4EI32_V_MF2_MF2, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4561
  { PseudoVLUXSEG4EI32_V_MF2_MF2_MASK, VLUXSEG4EI32_V, 0x7, 0x0 }, // 4562
  { PseudoVLUXSEG4EI64_V_M1_M1, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4563
  { PseudoVLUXSEG4EI64_V_M1_M1_MASK, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4564
  { PseudoVLUXSEG4EI64_V_M2_M1, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4565
  { PseudoVLUXSEG4EI64_V_M2_M1_MASK, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4566
  { PseudoVLUXSEG4EI64_V_M4_M1, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4567
  { PseudoVLUXSEG4EI64_V_M4_M1_MASK, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4568
  { PseudoVLUXSEG4EI64_V_M8_M1, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4569
  { PseudoVLUXSEG4EI64_V_M8_M1_MASK, VLUXSEG4EI64_V, 0x0, 0x0 }, // 4570
  { PseudoVLUXSEG4EI64_V_M2_M2, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4571
  { PseudoVLUXSEG4EI64_V_M2_M2_MASK, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4572
  { PseudoVLUXSEG4EI64_V_M4_M2, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4573
  { PseudoVLUXSEG4EI64_V_M4_M2_MASK, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4574
  { PseudoVLUXSEG4EI64_V_M8_M2, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4575
  { PseudoVLUXSEG4EI64_V_M8_M2_MASK, VLUXSEG4EI64_V, 0x1, 0x0 }, // 4576
  { PseudoVLUXSEG4EI64_V_M1_MF8, VLUXSEG4EI64_V, 0x5, 0x0 }, // 4577
  { PseudoVLUXSEG4EI64_V_M1_MF8_MASK, VLUXSEG4EI64_V, 0x5, 0x0 }, // 4578
  { PseudoVLUXSEG4EI64_V_M1_MF4, VLUXSEG4EI64_V, 0x6, 0x0 }, // 4579
  { PseudoVLUXSEG4EI64_V_M1_MF4_MASK, VLUXSEG4EI64_V, 0x6, 0x0 }, // 4580
  { PseudoVLUXSEG4EI64_V_M2_MF4, VLUXSEG4EI64_V, 0x6, 0x0 }, // 4581
  { PseudoVLUXSEG4EI64_V_M2_MF4_MASK, VLUXSEG4EI64_V, 0x6, 0x0 }, // 4582
  { PseudoVLUXSEG4EI64_V_M1_MF2, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4583
  { PseudoVLUXSEG4EI64_V_M1_MF2_MASK, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4584
  { PseudoVLUXSEG4EI64_V_M2_MF2, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4585
  { PseudoVLUXSEG4EI64_V_M2_MF2_MASK, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4586
  { PseudoVLUXSEG4EI64_V_M4_MF2, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4587
  { PseudoVLUXSEG4EI64_V_M4_MF2_MASK, VLUXSEG4EI64_V, 0x7, 0x0 }, // 4588
  { PseudoVLUXSEG4EI8_V_M1_M1, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4589
  { PseudoVLUXSEG4EI8_V_M1_M1_MASK, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4590
  { PseudoVLUXSEG4EI8_V_MF2_M1, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4591
  { PseudoVLUXSEG4EI8_V_MF2_M1_MASK, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4592
  { PseudoVLUXSEG4EI8_V_MF4_M1, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4593
  { PseudoVLUXSEG4EI8_V_MF4_M1_MASK, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4594
  { PseudoVLUXSEG4EI8_V_MF8_M1, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4595
  { PseudoVLUXSEG4EI8_V_MF8_M1_MASK, VLUXSEG4EI8_V, 0x0, 0x0 }, // 4596
  { PseudoVLUXSEG4EI8_V_M1_M2, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4597
  { PseudoVLUXSEG4EI8_V_M1_M2_MASK, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4598
  { PseudoVLUXSEG4EI8_V_M2_M2, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4599
  { PseudoVLUXSEG4EI8_V_M2_M2_MASK, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4600
  { PseudoVLUXSEG4EI8_V_MF2_M2, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4601
  { PseudoVLUXSEG4EI8_V_MF2_M2_MASK, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4602
  { PseudoVLUXSEG4EI8_V_MF4_M2, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4603
  { PseudoVLUXSEG4EI8_V_MF4_M2_MASK, VLUXSEG4EI8_V, 0x1, 0x0 }, // 4604
  { PseudoVLUXSEG4EI8_V_MF8_MF8, VLUXSEG4EI8_V, 0x5, 0x0 }, // 4605
  { PseudoVLUXSEG4EI8_V_MF8_MF8_MASK, VLUXSEG4EI8_V, 0x5, 0x0 }, // 4606
  { PseudoVLUXSEG4EI8_V_MF4_MF4, VLUXSEG4EI8_V, 0x6, 0x0 }, // 4607
  { PseudoVLUXSEG4EI8_V_MF4_MF4_MASK, VLUXSEG4EI8_V, 0x6, 0x0 }, // 4608
  { PseudoVLUXSEG4EI8_V_MF8_MF4, VLUXSEG4EI8_V, 0x6, 0x0 }, // 4609
  { PseudoVLUXSEG4EI8_V_MF8_MF4_MASK, VLUXSEG4EI8_V, 0x6, 0x0 }, // 4610
  { PseudoVLUXSEG4EI8_V_MF2_MF2, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4611
  { PseudoVLUXSEG4EI8_V_MF2_MF2_MASK, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4612
  { PseudoVLUXSEG4EI8_V_MF4_MF2, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4613
  { PseudoVLUXSEG4EI8_V_MF4_MF2_MASK, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4614
  { PseudoVLUXSEG4EI8_V_MF8_MF2, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4615
  { PseudoVLUXSEG4EI8_V_MF8_MF2_MASK, VLUXSEG4EI8_V, 0x7, 0x0 }, // 4616
  { PseudoVLUXSEG5EI16_V_M1_M1, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4617
  { PseudoVLUXSEG5EI16_V_M1_M1_MASK, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4618
  { PseudoVLUXSEG5EI16_V_M2_M1, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4619
  { PseudoVLUXSEG5EI16_V_M2_M1_MASK, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4620
  { PseudoVLUXSEG5EI16_V_MF2_M1, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4621
  { PseudoVLUXSEG5EI16_V_MF2_M1_MASK, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4622
  { PseudoVLUXSEG5EI16_V_MF4_M1, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4623
  { PseudoVLUXSEG5EI16_V_MF4_M1_MASK, VLUXSEG5EI16_V, 0x0, 0x0 }, // 4624
  { PseudoVLUXSEG5EI16_V_MF4_MF8, VLUXSEG5EI16_V, 0x5, 0x0 }, // 4625
  { PseudoVLUXSEG5EI16_V_MF4_MF8_MASK, VLUXSEG5EI16_V, 0x5, 0x0 }, // 4626
  { PseudoVLUXSEG5EI16_V_MF2_MF4, VLUXSEG5EI16_V, 0x6, 0x0 }, // 4627
  { PseudoVLUXSEG5EI16_V_MF2_MF4_MASK, VLUXSEG5EI16_V, 0x6, 0x0 }, // 4628
  { PseudoVLUXSEG5EI16_V_MF4_MF4, VLUXSEG5EI16_V, 0x6, 0x0 }, // 4629
  { PseudoVLUXSEG5EI16_V_MF4_MF4_MASK, VLUXSEG5EI16_V, 0x6, 0x0 }, // 4630
  { PseudoVLUXSEG5EI16_V_M1_MF2, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4631
  { PseudoVLUXSEG5EI16_V_M1_MF2_MASK, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4632
  { PseudoVLUXSEG5EI16_V_MF2_MF2, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4633
  { PseudoVLUXSEG5EI16_V_MF2_MF2_MASK, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4634
  { PseudoVLUXSEG5EI16_V_MF4_MF2, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4635
  { PseudoVLUXSEG5EI16_V_MF4_MF2_MASK, VLUXSEG5EI16_V, 0x7, 0x0 }, // 4636
  { PseudoVLUXSEG5EI32_V_M1_M1, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4637
  { PseudoVLUXSEG5EI32_V_M1_M1_MASK, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4638
  { PseudoVLUXSEG5EI32_V_M2_M1, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4639
  { PseudoVLUXSEG5EI32_V_M2_M1_MASK, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4640
  { PseudoVLUXSEG5EI32_V_M4_M1, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4641
  { PseudoVLUXSEG5EI32_V_M4_M1_MASK, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4642
  { PseudoVLUXSEG5EI32_V_MF2_M1, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4643
  { PseudoVLUXSEG5EI32_V_MF2_M1_MASK, VLUXSEG5EI32_V, 0x0, 0x0 }, // 4644
  { PseudoVLUXSEG5EI32_V_MF2_MF8, VLUXSEG5EI32_V, 0x5, 0x0 }, // 4645
  { PseudoVLUXSEG5EI32_V_MF2_MF8_MASK, VLUXSEG5EI32_V, 0x5, 0x0 }, // 4646
  { PseudoVLUXSEG5EI32_V_M1_MF4, VLUXSEG5EI32_V, 0x6, 0x0 }, // 4647
  { PseudoVLUXSEG5EI32_V_M1_MF4_MASK, VLUXSEG5EI32_V, 0x6, 0x0 }, // 4648
  { PseudoVLUXSEG5EI32_V_MF2_MF4, VLUXSEG5EI32_V, 0x6, 0x0 }, // 4649
  { PseudoVLUXSEG5EI32_V_MF2_MF4_MASK, VLUXSEG5EI32_V, 0x6, 0x0 }, // 4650
  { PseudoVLUXSEG5EI32_V_M1_MF2, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4651
  { PseudoVLUXSEG5EI32_V_M1_MF2_MASK, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4652
  { PseudoVLUXSEG5EI32_V_M2_MF2, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4653
  { PseudoVLUXSEG5EI32_V_M2_MF2_MASK, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4654
  { PseudoVLUXSEG5EI32_V_MF2_MF2, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4655
  { PseudoVLUXSEG5EI32_V_MF2_MF2_MASK, VLUXSEG5EI32_V, 0x7, 0x0 }, // 4656
  { PseudoVLUXSEG5EI64_V_M1_M1, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4657
  { PseudoVLUXSEG5EI64_V_M1_M1_MASK, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4658
  { PseudoVLUXSEG5EI64_V_M2_M1, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4659
  { PseudoVLUXSEG5EI64_V_M2_M1_MASK, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4660
  { PseudoVLUXSEG5EI64_V_M4_M1, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4661
  { PseudoVLUXSEG5EI64_V_M4_M1_MASK, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4662
  { PseudoVLUXSEG5EI64_V_M8_M1, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4663
  { PseudoVLUXSEG5EI64_V_M8_M1_MASK, VLUXSEG5EI64_V, 0x0, 0x0 }, // 4664
  { PseudoVLUXSEG5EI64_V_M1_MF8, VLUXSEG5EI64_V, 0x5, 0x0 }, // 4665
  { PseudoVLUXSEG5EI64_V_M1_MF8_MASK, VLUXSEG5EI64_V, 0x5, 0x0 }, // 4666
  { PseudoVLUXSEG5EI64_V_M1_MF4, VLUXSEG5EI64_V, 0x6, 0x0 }, // 4667
  { PseudoVLUXSEG5EI64_V_M1_MF4_MASK, VLUXSEG5EI64_V, 0x6, 0x0 }, // 4668
  { PseudoVLUXSEG5EI64_V_M2_MF4, VLUXSEG5EI64_V, 0x6, 0x0 }, // 4669
  { PseudoVLUXSEG5EI64_V_M2_MF4_MASK, VLUXSEG5EI64_V, 0x6, 0x0 }, // 4670
  { PseudoVLUXSEG5EI64_V_M1_MF2, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4671
  { PseudoVLUXSEG5EI64_V_M1_MF2_MASK, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4672
  { PseudoVLUXSEG5EI64_V_M2_MF2, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4673
  { PseudoVLUXSEG5EI64_V_M2_MF2_MASK, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4674
  { PseudoVLUXSEG5EI64_V_M4_MF2, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4675
  { PseudoVLUXSEG5EI64_V_M4_MF2_MASK, VLUXSEG5EI64_V, 0x7, 0x0 }, // 4676
  { PseudoVLUXSEG5EI8_V_M1_M1, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4677
  { PseudoVLUXSEG5EI8_V_M1_M1_MASK, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4678
  { PseudoVLUXSEG5EI8_V_MF2_M1, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4679
  { PseudoVLUXSEG5EI8_V_MF2_M1_MASK, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4680
  { PseudoVLUXSEG5EI8_V_MF4_M1, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4681
  { PseudoVLUXSEG5EI8_V_MF4_M1_MASK, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4682
  { PseudoVLUXSEG5EI8_V_MF8_M1, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4683
  { PseudoVLUXSEG5EI8_V_MF8_M1_MASK, VLUXSEG5EI8_V, 0x0, 0x0 }, // 4684
  { PseudoVLUXSEG5EI8_V_MF8_MF8, VLUXSEG5EI8_V, 0x5, 0x0 }, // 4685
  { PseudoVLUXSEG5EI8_V_MF8_MF8_MASK, VLUXSEG5EI8_V, 0x5, 0x0 }, // 4686
  { PseudoVLUXSEG5EI8_V_MF4_MF4, VLUXSEG5EI8_V, 0x6, 0x0 }, // 4687
  { PseudoVLUXSEG5EI8_V_MF4_MF4_MASK, VLUXSEG5EI8_V, 0x6, 0x0 }, // 4688
  { PseudoVLUXSEG5EI8_V_MF8_MF4, VLUXSEG5EI8_V, 0x6, 0x0 }, // 4689
  { PseudoVLUXSEG5EI8_V_MF8_MF4_MASK, VLUXSEG5EI8_V, 0x6, 0x0 }, // 4690
  { PseudoVLUXSEG5EI8_V_MF2_MF2, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4691
  { PseudoVLUXSEG5EI8_V_MF2_MF2_MASK, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4692
  { PseudoVLUXSEG5EI8_V_MF4_MF2, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4693
  { PseudoVLUXSEG5EI8_V_MF4_MF2_MASK, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4694
  { PseudoVLUXSEG5EI8_V_MF8_MF2, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4695
  { PseudoVLUXSEG5EI8_V_MF8_MF2_MASK, VLUXSEG5EI8_V, 0x7, 0x0 }, // 4696
  { PseudoVLUXSEG6EI16_V_M1_M1, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4697
  { PseudoVLUXSEG6EI16_V_M1_M1_MASK, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4698
  { PseudoVLUXSEG6EI16_V_M2_M1, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4699
  { PseudoVLUXSEG6EI16_V_M2_M1_MASK, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4700
  { PseudoVLUXSEG6EI16_V_MF2_M1, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4701
  { PseudoVLUXSEG6EI16_V_MF2_M1_MASK, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4702
  { PseudoVLUXSEG6EI16_V_MF4_M1, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4703
  { PseudoVLUXSEG6EI16_V_MF4_M1_MASK, VLUXSEG6EI16_V, 0x0, 0x0 }, // 4704
  { PseudoVLUXSEG6EI16_V_MF4_MF8, VLUXSEG6EI16_V, 0x5, 0x0 }, // 4705
  { PseudoVLUXSEG6EI16_V_MF4_MF8_MASK, VLUXSEG6EI16_V, 0x5, 0x0 }, // 4706
  { PseudoVLUXSEG6EI16_V_MF2_MF4, VLUXSEG6EI16_V, 0x6, 0x0 }, // 4707
  { PseudoVLUXSEG6EI16_V_MF2_MF4_MASK, VLUXSEG6EI16_V, 0x6, 0x0 }, // 4708
  { PseudoVLUXSEG6EI16_V_MF4_MF4, VLUXSEG6EI16_V, 0x6, 0x0 }, // 4709
  { PseudoVLUXSEG6EI16_V_MF4_MF4_MASK, VLUXSEG6EI16_V, 0x6, 0x0 }, // 4710
  { PseudoVLUXSEG6EI16_V_M1_MF2, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4711
  { PseudoVLUXSEG6EI16_V_M1_MF2_MASK, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4712
  { PseudoVLUXSEG6EI16_V_MF2_MF2, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4713
  { PseudoVLUXSEG6EI16_V_MF2_MF2_MASK, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4714
  { PseudoVLUXSEG6EI16_V_MF4_MF2, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4715
  { PseudoVLUXSEG6EI16_V_MF4_MF2_MASK, VLUXSEG6EI16_V, 0x7, 0x0 }, // 4716
  { PseudoVLUXSEG6EI32_V_M1_M1, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4717
  { PseudoVLUXSEG6EI32_V_M1_M1_MASK, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4718
  { PseudoVLUXSEG6EI32_V_M2_M1, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4719
  { PseudoVLUXSEG6EI32_V_M2_M1_MASK, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4720
  { PseudoVLUXSEG6EI32_V_M4_M1, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4721
  { PseudoVLUXSEG6EI32_V_M4_M1_MASK, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4722
  { PseudoVLUXSEG6EI32_V_MF2_M1, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4723
  { PseudoVLUXSEG6EI32_V_MF2_M1_MASK, VLUXSEG6EI32_V, 0x0, 0x0 }, // 4724
  { PseudoVLUXSEG6EI32_V_MF2_MF8, VLUXSEG6EI32_V, 0x5, 0x0 }, // 4725
  { PseudoVLUXSEG6EI32_V_MF2_MF8_MASK, VLUXSEG6EI32_V, 0x5, 0x0 }, // 4726
  { PseudoVLUXSEG6EI32_V_M1_MF4, VLUXSEG6EI32_V, 0x6, 0x0 }, // 4727
  { PseudoVLUXSEG6EI32_V_M1_MF4_MASK, VLUXSEG6EI32_V, 0x6, 0x0 }, // 4728
  { PseudoVLUXSEG6EI32_V_MF2_MF4, VLUXSEG6EI32_V, 0x6, 0x0 }, // 4729
  { PseudoVLUXSEG6EI32_V_MF2_MF4_MASK, VLUXSEG6EI32_V, 0x6, 0x0 }, // 4730
  { PseudoVLUXSEG6EI32_V_M1_MF2, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4731
  { PseudoVLUXSEG6EI32_V_M1_MF2_MASK, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4732
  { PseudoVLUXSEG6EI32_V_M2_MF2, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4733
  { PseudoVLUXSEG6EI32_V_M2_MF2_MASK, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4734
  { PseudoVLUXSEG6EI32_V_MF2_MF2, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4735
  { PseudoVLUXSEG6EI32_V_MF2_MF2_MASK, VLUXSEG6EI32_V, 0x7, 0x0 }, // 4736
  { PseudoVLUXSEG6EI64_V_M1_M1, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4737
  { PseudoVLUXSEG6EI64_V_M1_M1_MASK, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4738
  { PseudoVLUXSEG6EI64_V_M2_M1, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4739
  { PseudoVLUXSEG6EI64_V_M2_M1_MASK, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4740
  { PseudoVLUXSEG6EI64_V_M4_M1, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4741
  { PseudoVLUXSEG6EI64_V_M4_M1_MASK, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4742
  { PseudoVLUXSEG6EI64_V_M8_M1, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4743
  { PseudoVLUXSEG6EI64_V_M8_M1_MASK, VLUXSEG6EI64_V, 0x0, 0x0 }, // 4744
  { PseudoVLUXSEG6EI64_V_M1_MF8, VLUXSEG6EI64_V, 0x5, 0x0 }, // 4745
  { PseudoVLUXSEG6EI64_V_M1_MF8_MASK, VLUXSEG6EI64_V, 0x5, 0x0 }, // 4746
  { PseudoVLUXSEG6EI64_V_M1_MF4, VLUXSEG6EI64_V, 0x6, 0x0 }, // 4747
  { PseudoVLUXSEG6EI64_V_M1_MF4_MASK, VLUXSEG6EI64_V, 0x6, 0x0 }, // 4748
  { PseudoVLUXSEG6EI64_V_M2_MF4, VLUXSEG6EI64_V, 0x6, 0x0 }, // 4749
  { PseudoVLUXSEG6EI64_V_M2_MF4_MASK, VLUXSEG6EI64_V, 0x6, 0x0 }, // 4750
  { PseudoVLUXSEG6EI64_V_M1_MF2, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4751
  { PseudoVLUXSEG6EI64_V_M1_MF2_MASK, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4752
  { PseudoVLUXSEG6EI64_V_M2_MF2, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4753
  { PseudoVLUXSEG6EI64_V_M2_MF2_MASK, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4754
  { PseudoVLUXSEG6EI64_V_M4_MF2, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4755
  { PseudoVLUXSEG6EI64_V_M4_MF2_MASK, VLUXSEG6EI64_V, 0x7, 0x0 }, // 4756
  { PseudoVLUXSEG6EI8_V_M1_M1, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4757
  { PseudoVLUXSEG6EI8_V_M1_M1_MASK, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4758
  { PseudoVLUXSEG6EI8_V_MF2_M1, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4759
  { PseudoVLUXSEG6EI8_V_MF2_M1_MASK, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4760
  { PseudoVLUXSEG6EI8_V_MF4_M1, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4761
  { PseudoVLUXSEG6EI8_V_MF4_M1_MASK, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4762
  { PseudoVLUXSEG6EI8_V_MF8_M1, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4763
  { PseudoVLUXSEG6EI8_V_MF8_M1_MASK, VLUXSEG6EI8_V, 0x0, 0x0 }, // 4764
  { PseudoVLUXSEG6EI8_V_MF8_MF8, VLUXSEG6EI8_V, 0x5, 0x0 }, // 4765
  { PseudoVLUXSEG6EI8_V_MF8_MF8_MASK, VLUXSEG6EI8_V, 0x5, 0x0 }, // 4766
  { PseudoVLUXSEG6EI8_V_MF4_MF4, VLUXSEG6EI8_V, 0x6, 0x0 }, // 4767
  { PseudoVLUXSEG6EI8_V_MF4_MF4_MASK, VLUXSEG6EI8_V, 0x6, 0x0 }, // 4768
  { PseudoVLUXSEG6EI8_V_MF8_MF4, VLUXSEG6EI8_V, 0x6, 0x0 }, // 4769
  { PseudoVLUXSEG6EI8_V_MF8_MF4_MASK, VLUXSEG6EI8_V, 0x6, 0x0 }, // 4770
  { PseudoVLUXSEG6EI8_V_MF2_MF2, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4771
  { PseudoVLUXSEG6EI8_V_MF2_MF2_MASK, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4772
  { PseudoVLUXSEG6EI8_V_MF4_MF2, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4773
  { PseudoVLUXSEG6EI8_V_MF4_MF2_MASK, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4774
  { PseudoVLUXSEG6EI8_V_MF8_MF2, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4775
  { PseudoVLUXSEG6EI8_V_MF8_MF2_MASK, VLUXSEG6EI8_V, 0x7, 0x0 }, // 4776
  { PseudoVLUXSEG7EI16_V_M1_M1, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4777
  { PseudoVLUXSEG7EI16_V_M1_M1_MASK, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4778
  { PseudoVLUXSEG7EI16_V_M2_M1, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4779
  { PseudoVLUXSEG7EI16_V_M2_M1_MASK, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4780
  { PseudoVLUXSEG7EI16_V_MF2_M1, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4781
  { PseudoVLUXSEG7EI16_V_MF2_M1_MASK, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4782
  { PseudoVLUXSEG7EI16_V_MF4_M1, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4783
  { PseudoVLUXSEG7EI16_V_MF4_M1_MASK, VLUXSEG7EI16_V, 0x0, 0x0 }, // 4784
  { PseudoVLUXSEG7EI16_V_MF4_MF8, VLUXSEG7EI16_V, 0x5, 0x0 }, // 4785
  { PseudoVLUXSEG7EI16_V_MF4_MF8_MASK, VLUXSEG7EI16_V, 0x5, 0x0 }, // 4786
  { PseudoVLUXSEG7EI16_V_MF2_MF4, VLUXSEG7EI16_V, 0x6, 0x0 }, // 4787
  { PseudoVLUXSEG7EI16_V_MF2_MF4_MASK, VLUXSEG7EI16_V, 0x6, 0x0 }, // 4788
  { PseudoVLUXSEG7EI16_V_MF4_MF4, VLUXSEG7EI16_V, 0x6, 0x0 }, // 4789
  { PseudoVLUXSEG7EI16_V_MF4_MF4_MASK, VLUXSEG7EI16_V, 0x6, 0x0 }, // 4790
  { PseudoVLUXSEG7EI16_V_M1_MF2, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4791
  { PseudoVLUXSEG7EI16_V_M1_MF2_MASK, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4792
  { PseudoVLUXSEG7EI16_V_MF2_MF2, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4793
  { PseudoVLUXSEG7EI16_V_MF2_MF2_MASK, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4794
  { PseudoVLUXSEG7EI16_V_MF4_MF2, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4795
  { PseudoVLUXSEG7EI16_V_MF4_MF2_MASK, VLUXSEG7EI16_V, 0x7, 0x0 }, // 4796
  { PseudoVLUXSEG7EI32_V_M1_M1, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4797
  { PseudoVLUXSEG7EI32_V_M1_M1_MASK, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4798
  { PseudoVLUXSEG7EI32_V_M2_M1, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4799
  { PseudoVLUXSEG7EI32_V_M2_M1_MASK, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4800
  { PseudoVLUXSEG7EI32_V_M4_M1, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4801
  { PseudoVLUXSEG7EI32_V_M4_M1_MASK, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4802
  { PseudoVLUXSEG7EI32_V_MF2_M1, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4803
  { PseudoVLUXSEG7EI32_V_MF2_M1_MASK, VLUXSEG7EI32_V, 0x0, 0x0 }, // 4804
  { PseudoVLUXSEG7EI32_V_MF2_MF8, VLUXSEG7EI32_V, 0x5, 0x0 }, // 4805
  { PseudoVLUXSEG7EI32_V_MF2_MF8_MASK, VLUXSEG7EI32_V, 0x5, 0x0 }, // 4806
  { PseudoVLUXSEG7EI32_V_M1_MF4, VLUXSEG7EI32_V, 0x6, 0x0 }, // 4807
  { PseudoVLUXSEG7EI32_V_M1_MF4_MASK, VLUXSEG7EI32_V, 0x6, 0x0 }, // 4808
  { PseudoVLUXSEG7EI32_V_MF2_MF4, VLUXSEG7EI32_V, 0x6, 0x0 }, // 4809
  { PseudoVLUXSEG7EI32_V_MF2_MF4_MASK, VLUXSEG7EI32_V, 0x6, 0x0 }, // 4810
  { PseudoVLUXSEG7EI32_V_M1_MF2, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4811
  { PseudoVLUXSEG7EI32_V_M1_MF2_MASK, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4812
  { PseudoVLUXSEG7EI32_V_M2_MF2, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4813
  { PseudoVLUXSEG7EI32_V_M2_MF2_MASK, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4814
  { PseudoVLUXSEG7EI32_V_MF2_MF2, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4815
  { PseudoVLUXSEG7EI32_V_MF2_MF2_MASK, VLUXSEG7EI32_V, 0x7, 0x0 }, // 4816
  { PseudoVLUXSEG7EI64_V_M1_M1, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4817
  { PseudoVLUXSEG7EI64_V_M1_M1_MASK, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4818
  { PseudoVLUXSEG7EI64_V_M2_M1, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4819
  { PseudoVLUXSEG7EI64_V_M2_M1_MASK, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4820
  { PseudoVLUXSEG7EI64_V_M4_M1, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4821
  { PseudoVLUXSEG7EI64_V_M4_M1_MASK, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4822
  { PseudoVLUXSEG7EI64_V_M8_M1, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4823
  { PseudoVLUXSEG7EI64_V_M8_M1_MASK, VLUXSEG7EI64_V, 0x0, 0x0 }, // 4824
  { PseudoVLUXSEG7EI64_V_M1_MF8, VLUXSEG7EI64_V, 0x5, 0x0 }, // 4825
  { PseudoVLUXSEG7EI64_V_M1_MF8_MASK, VLUXSEG7EI64_V, 0x5, 0x0 }, // 4826
  { PseudoVLUXSEG7EI64_V_M1_MF4, VLUXSEG7EI64_V, 0x6, 0x0 }, // 4827
  { PseudoVLUXSEG7EI64_V_M1_MF4_MASK, VLUXSEG7EI64_V, 0x6, 0x0 }, // 4828
  { PseudoVLUXSEG7EI64_V_M2_MF4, VLUXSEG7EI64_V, 0x6, 0x0 }, // 4829
  { PseudoVLUXSEG7EI64_V_M2_MF4_MASK, VLUXSEG7EI64_V, 0x6, 0x0 }, // 4830
  { PseudoVLUXSEG7EI64_V_M1_MF2, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4831
  { PseudoVLUXSEG7EI64_V_M1_MF2_MASK, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4832
  { PseudoVLUXSEG7EI64_V_M2_MF2, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4833
  { PseudoVLUXSEG7EI64_V_M2_MF2_MASK, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4834
  { PseudoVLUXSEG7EI64_V_M4_MF2, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4835
  { PseudoVLUXSEG7EI64_V_M4_MF2_MASK, VLUXSEG7EI64_V, 0x7, 0x0 }, // 4836
  { PseudoVLUXSEG7EI8_V_M1_M1, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4837
  { PseudoVLUXSEG7EI8_V_M1_M1_MASK, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4838
  { PseudoVLUXSEG7EI8_V_MF2_M1, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4839
  { PseudoVLUXSEG7EI8_V_MF2_M1_MASK, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4840
  { PseudoVLUXSEG7EI8_V_MF4_M1, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4841
  { PseudoVLUXSEG7EI8_V_MF4_M1_MASK, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4842
  { PseudoVLUXSEG7EI8_V_MF8_M1, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4843
  { PseudoVLUXSEG7EI8_V_MF8_M1_MASK, VLUXSEG7EI8_V, 0x0, 0x0 }, // 4844
  { PseudoVLUXSEG7EI8_V_MF8_MF8, VLUXSEG7EI8_V, 0x5, 0x0 }, // 4845
  { PseudoVLUXSEG7EI8_V_MF8_MF8_MASK, VLUXSEG7EI8_V, 0x5, 0x0 }, // 4846
  { PseudoVLUXSEG7EI8_V_MF4_MF4, VLUXSEG7EI8_V, 0x6, 0x0 }, // 4847
  { PseudoVLUXSEG7EI8_V_MF4_MF4_MASK, VLUXSEG7EI8_V, 0x6, 0x0 }, // 4848
  { PseudoVLUXSEG7EI8_V_MF8_MF4, VLUXSEG7EI8_V, 0x6, 0x0 }, // 4849
  { PseudoVLUXSEG7EI8_V_MF8_MF4_MASK, VLUXSEG7EI8_V, 0x6, 0x0 }, // 4850
  { PseudoVLUXSEG7EI8_V_MF2_MF2, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4851
  { PseudoVLUXSEG7EI8_V_MF2_MF2_MASK, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4852
  { PseudoVLUXSEG7EI8_V_MF4_MF2, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4853
  { PseudoVLUXSEG7EI8_V_MF4_MF2_MASK, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4854
  { PseudoVLUXSEG7EI8_V_MF8_MF2, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4855
  { PseudoVLUXSEG7EI8_V_MF8_MF2_MASK, VLUXSEG7EI8_V, 0x7, 0x0 }, // 4856
  { PseudoVLUXSEG8EI16_V_M1_M1, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4857
  { PseudoVLUXSEG8EI16_V_M1_M1_MASK, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4858
  { PseudoVLUXSEG8EI16_V_M2_M1, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4859
  { PseudoVLUXSEG8EI16_V_M2_M1_MASK, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4860
  { PseudoVLUXSEG8EI16_V_MF2_M1, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4861
  { PseudoVLUXSEG8EI16_V_MF2_M1_MASK, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4862
  { PseudoVLUXSEG8EI16_V_MF4_M1, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4863
  { PseudoVLUXSEG8EI16_V_MF4_M1_MASK, VLUXSEG8EI16_V, 0x0, 0x0 }, // 4864
  { PseudoVLUXSEG8EI16_V_MF4_MF8, VLUXSEG8EI16_V, 0x5, 0x0 }, // 4865
  { PseudoVLUXSEG8EI16_V_MF4_MF8_MASK, VLUXSEG8EI16_V, 0x5, 0x0 }, // 4866
  { PseudoVLUXSEG8EI16_V_MF2_MF4, VLUXSEG8EI16_V, 0x6, 0x0 }, // 4867
  { PseudoVLUXSEG8EI16_V_MF2_MF4_MASK, VLUXSEG8EI16_V, 0x6, 0x0 }, // 4868
  { PseudoVLUXSEG8EI16_V_MF4_MF4, VLUXSEG8EI16_V, 0x6, 0x0 }, // 4869
  { PseudoVLUXSEG8EI16_V_MF4_MF4_MASK, VLUXSEG8EI16_V, 0x6, 0x0 }, // 4870
  { PseudoVLUXSEG8EI16_V_M1_MF2, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4871
  { PseudoVLUXSEG8EI16_V_M1_MF2_MASK, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4872
  { PseudoVLUXSEG8EI16_V_MF2_MF2, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4873
  { PseudoVLUXSEG8EI16_V_MF2_MF2_MASK, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4874
  { PseudoVLUXSEG8EI16_V_MF4_MF2, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4875
  { PseudoVLUXSEG8EI16_V_MF4_MF2_MASK, VLUXSEG8EI16_V, 0x7, 0x0 }, // 4876
  { PseudoVLUXSEG8EI32_V_M1_M1, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4877
  { PseudoVLUXSEG8EI32_V_M1_M1_MASK, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4878
  { PseudoVLUXSEG8EI32_V_M2_M1, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4879
  { PseudoVLUXSEG8EI32_V_M2_M1_MASK, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4880
  { PseudoVLUXSEG8EI32_V_M4_M1, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4881
  { PseudoVLUXSEG8EI32_V_M4_M1_MASK, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4882
  { PseudoVLUXSEG8EI32_V_MF2_M1, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4883
  { PseudoVLUXSEG8EI32_V_MF2_M1_MASK, VLUXSEG8EI32_V, 0x0, 0x0 }, // 4884
  { PseudoVLUXSEG8EI32_V_MF2_MF8, VLUXSEG8EI32_V, 0x5, 0x0 }, // 4885
  { PseudoVLUXSEG8EI32_V_MF2_MF8_MASK, VLUXSEG8EI32_V, 0x5, 0x0 }, // 4886
  { PseudoVLUXSEG8EI32_V_M1_MF4, VLUXSEG8EI32_V, 0x6, 0x0 }, // 4887
  { PseudoVLUXSEG8EI32_V_M1_MF4_MASK, VLUXSEG8EI32_V, 0x6, 0x0 }, // 4888
  { PseudoVLUXSEG8EI32_V_MF2_MF4, VLUXSEG8EI32_V, 0x6, 0x0 }, // 4889
  { PseudoVLUXSEG8EI32_V_MF2_MF4_MASK, VLUXSEG8EI32_V, 0x6, 0x0 }, // 4890
  { PseudoVLUXSEG8EI32_V_M1_MF2, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4891
  { PseudoVLUXSEG8EI32_V_M1_MF2_MASK, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4892
  { PseudoVLUXSEG8EI32_V_M2_MF2, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4893
  { PseudoVLUXSEG8EI32_V_M2_MF2_MASK, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4894
  { PseudoVLUXSEG8EI32_V_MF2_MF2, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4895
  { PseudoVLUXSEG8EI32_V_MF2_MF2_MASK, VLUXSEG8EI32_V, 0x7, 0x0 }, // 4896
  { PseudoVLUXSEG8EI64_V_M1_M1, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4897
  { PseudoVLUXSEG8EI64_V_M1_M1_MASK, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4898
  { PseudoVLUXSEG8EI64_V_M2_M1, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4899
  { PseudoVLUXSEG8EI64_V_M2_M1_MASK, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4900
  { PseudoVLUXSEG8EI64_V_M4_M1, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4901
  { PseudoVLUXSEG8EI64_V_M4_M1_MASK, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4902
  { PseudoVLUXSEG8EI64_V_M8_M1, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4903
  { PseudoVLUXSEG8EI64_V_M8_M1_MASK, VLUXSEG8EI64_V, 0x0, 0x0 }, // 4904
  { PseudoVLUXSEG8EI64_V_M1_MF8, VLUXSEG8EI64_V, 0x5, 0x0 }, // 4905
  { PseudoVLUXSEG8EI64_V_M1_MF8_MASK, VLUXSEG8EI64_V, 0x5, 0x0 }, // 4906
  { PseudoVLUXSEG8EI64_V_M1_MF4, VLUXSEG8EI64_V, 0x6, 0x0 }, // 4907
  { PseudoVLUXSEG8EI64_V_M1_MF4_MASK, VLUXSEG8EI64_V, 0x6, 0x0 }, // 4908
  { PseudoVLUXSEG8EI64_V_M2_MF4, VLUXSEG8EI64_V, 0x6, 0x0 }, // 4909
  { PseudoVLUXSEG8EI64_V_M2_MF4_MASK, VLUXSEG8EI64_V, 0x6, 0x0 }, // 4910
  { PseudoVLUXSEG8EI64_V_M1_MF2, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4911
  { PseudoVLUXSEG8EI64_V_M1_MF2_MASK, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4912
  { PseudoVLUXSEG8EI64_V_M2_MF2, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4913
  { PseudoVLUXSEG8EI64_V_M2_MF2_MASK, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4914
  { PseudoVLUXSEG8EI64_V_M4_MF2, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4915
  { PseudoVLUXSEG8EI64_V_M4_MF2_MASK, VLUXSEG8EI64_V, 0x7, 0x0 }, // 4916
  { PseudoVLUXSEG8EI8_V_M1_M1, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4917
  { PseudoVLUXSEG8EI8_V_M1_M1_MASK, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4918
  { PseudoVLUXSEG8EI8_V_MF2_M1, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4919
  { PseudoVLUXSEG8EI8_V_MF2_M1_MASK, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4920
  { PseudoVLUXSEG8EI8_V_MF4_M1, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4921
  { PseudoVLUXSEG8EI8_V_MF4_M1_MASK, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4922
  { PseudoVLUXSEG8EI8_V_MF8_M1, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4923
  { PseudoVLUXSEG8EI8_V_MF8_M1_MASK, VLUXSEG8EI8_V, 0x0, 0x0 }, // 4924
  { PseudoVLUXSEG8EI8_V_MF8_MF8, VLUXSEG8EI8_V, 0x5, 0x0 }, // 4925
  { PseudoVLUXSEG8EI8_V_MF8_MF8_MASK, VLUXSEG8EI8_V, 0x5, 0x0 }, // 4926
  { PseudoVLUXSEG8EI8_V_MF4_MF4, VLUXSEG8EI8_V, 0x6, 0x0 }, // 4927
  { PseudoVLUXSEG8EI8_V_MF4_MF4_MASK, VLUXSEG8EI8_V, 0x6, 0x0 }, // 4928
  { PseudoVLUXSEG8EI8_V_MF8_MF4, VLUXSEG8EI8_V, 0x6, 0x0 }, // 4929
  { PseudoVLUXSEG8EI8_V_MF8_MF4_MASK, VLUXSEG8EI8_V, 0x6, 0x0 }, // 4930
  { PseudoVLUXSEG8EI8_V_MF2_MF2, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4931
  { PseudoVLUXSEG8EI8_V_MF2_MF2_MASK, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4932
  { PseudoVLUXSEG8EI8_V_MF4_MF2, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4933
  { PseudoVLUXSEG8EI8_V_MF4_MF2_MASK, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4934
  { PseudoVLUXSEG8EI8_V_MF8_MF2, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4935
  { PseudoVLUXSEG8EI8_V_MF8_MF2_MASK, VLUXSEG8EI8_V, 0x7, 0x0 }, // 4936
  { PseudoVMACC_VV_M1, VMACC_VV, 0x0, 0x0 }, // 4937
  { PseudoVMACC_VV_M1_MASK, VMACC_VV, 0x0, 0x0 }, // 4938
  { PseudoVMACC_VV_M2, VMACC_VV, 0x1, 0x0 }, // 4939
  { PseudoVMACC_VV_M2_MASK, VMACC_VV, 0x1, 0x0 }, // 4940
  { PseudoVMACC_VV_M4, VMACC_VV, 0x2, 0x0 }, // 4941
  { PseudoVMACC_VV_M4_MASK, VMACC_VV, 0x2, 0x0 }, // 4942
  { PseudoVMACC_VV_M8, VMACC_VV, 0x3, 0x0 }, // 4943
  { PseudoVMACC_VV_M8_MASK, VMACC_VV, 0x3, 0x0 }, // 4944
  { PseudoVMACC_VV_MF8, VMACC_VV, 0x5, 0x0 }, // 4945
  { PseudoVMACC_VV_MF8_MASK, VMACC_VV, 0x5, 0x0 }, // 4946
  { PseudoVMACC_VV_MF4, VMACC_VV, 0x6, 0x0 }, // 4947
  { PseudoVMACC_VV_MF4_MASK, VMACC_VV, 0x6, 0x0 }, // 4948
  { PseudoVMACC_VV_MF2, VMACC_VV, 0x7, 0x0 }, // 4949
  { PseudoVMACC_VV_MF2_MASK, VMACC_VV, 0x7, 0x0 }, // 4950
  { PseudoVMACC_VX_M1, VMACC_VX, 0x0, 0x0 }, // 4951
  { PseudoVMACC_VX_M1_MASK, VMACC_VX, 0x0, 0x0 }, // 4952
  { PseudoVMACC_VX_M2, VMACC_VX, 0x1, 0x0 }, // 4953
  { PseudoVMACC_VX_M2_MASK, VMACC_VX, 0x1, 0x0 }, // 4954
  { PseudoVMACC_VX_M4, VMACC_VX, 0x2, 0x0 }, // 4955
  { PseudoVMACC_VX_M4_MASK, VMACC_VX, 0x2, 0x0 }, // 4956
  { PseudoVMACC_VX_M8, VMACC_VX, 0x3, 0x0 }, // 4957
  { PseudoVMACC_VX_M8_MASK, VMACC_VX, 0x3, 0x0 }, // 4958
  { PseudoVMACC_VX_MF8, VMACC_VX, 0x5, 0x0 }, // 4959
  { PseudoVMACC_VX_MF8_MASK, VMACC_VX, 0x5, 0x0 }, // 4960
  { PseudoVMACC_VX_MF4, VMACC_VX, 0x6, 0x0 }, // 4961
  { PseudoVMACC_VX_MF4_MASK, VMACC_VX, 0x6, 0x0 }, // 4962
  { PseudoVMACC_VX_MF2, VMACC_VX, 0x7, 0x0 }, // 4963
  { PseudoVMACC_VX_MF2_MASK, VMACC_VX, 0x7, 0x0 }, // 4964
  { PseudoVMADC_VI_M1, VMADC_VI, 0x0, 0x0 }, // 4965
  { PseudoVMADC_VI_M2, VMADC_VI, 0x1, 0x0 }, // 4966
  { PseudoVMADC_VI_M4, VMADC_VI, 0x2, 0x0 }, // 4967
  { PseudoVMADC_VI_M8, VMADC_VI, 0x3, 0x0 }, // 4968
  { PseudoVMADC_VI_MF8, VMADC_VI, 0x5, 0x0 }, // 4969
  { PseudoVMADC_VI_MF4, VMADC_VI, 0x6, 0x0 }, // 4970
  { PseudoVMADC_VI_MF2, VMADC_VI, 0x7, 0x0 }, // 4971
  { PseudoVMADC_VIM_M1, VMADC_VIM, 0x0, 0x0 }, // 4972
  { PseudoVMADC_VIM_M2, VMADC_VIM, 0x1, 0x0 }, // 4973
  { PseudoVMADC_VIM_M4, VMADC_VIM, 0x2, 0x0 }, // 4974
  { PseudoVMADC_VIM_M8, VMADC_VIM, 0x3, 0x0 }, // 4975
  { PseudoVMADC_VIM_MF8, VMADC_VIM, 0x5, 0x0 }, // 4976
  { PseudoVMADC_VIM_MF4, VMADC_VIM, 0x6, 0x0 }, // 4977
  { PseudoVMADC_VIM_MF2, VMADC_VIM, 0x7, 0x0 }, // 4978
  { PseudoVMADC_VV_M1, VMADC_VV, 0x0, 0x0 }, // 4979
  { PseudoVMADC_VV_M2, VMADC_VV, 0x1, 0x0 }, // 4980
  { PseudoVMADC_VV_M4, VMADC_VV, 0x2, 0x0 }, // 4981
  { PseudoVMADC_VV_M8, VMADC_VV, 0x3, 0x0 }, // 4982
  { PseudoVMADC_VV_MF8, VMADC_VV, 0x5, 0x0 }, // 4983
  { PseudoVMADC_VV_MF4, VMADC_VV, 0x6, 0x0 }, // 4984
  { PseudoVMADC_VV_MF2, VMADC_VV, 0x7, 0x0 }, // 4985
  { PseudoVMADC_VVM_M1, VMADC_VVM, 0x0, 0x0 }, // 4986
  { PseudoVMADC_VVM_M2, VMADC_VVM, 0x1, 0x0 }, // 4987
  { PseudoVMADC_VVM_M4, VMADC_VVM, 0x2, 0x0 }, // 4988
  { PseudoVMADC_VVM_M8, VMADC_VVM, 0x3, 0x0 }, // 4989
  { PseudoVMADC_VVM_MF8, VMADC_VVM, 0x5, 0x0 }, // 4990
  { PseudoVMADC_VVM_MF4, VMADC_VVM, 0x6, 0x0 }, // 4991
  { PseudoVMADC_VVM_MF2, VMADC_VVM, 0x7, 0x0 }, // 4992
  { PseudoVMADC_VX_M1, VMADC_VX, 0x0, 0x0 }, // 4993
  { PseudoVMADC_VX_M2, VMADC_VX, 0x1, 0x0 }, // 4994
  { PseudoVMADC_VX_M4, VMADC_VX, 0x2, 0x0 }, // 4995
  { PseudoVMADC_VX_M8, VMADC_VX, 0x3, 0x0 }, // 4996
  { PseudoVMADC_VX_MF8, VMADC_VX, 0x5, 0x0 }, // 4997
  { PseudoVMADC_VX_MF4, VMADC_VX, 0x6, 0x0 }, // 4998
  { PseudoVMADC_VX_MF2, VMADC_VX, 0x7, 0x0 }, // 4999
  { PseudoVMADC_VXM_M1, VMADC_VXM, 0x0, 0x0 }, // 5000
  { PseudoVMADC_VXM_M2, VMADC_VXM, 0x1, 0x0 }, // 5001
  { PseudoVMADC_VXM_M4, VMADC_VXM, 0x2, 0x0 }, // 5002
  { PseudoVMADC_VXM_M8, VMADC_VXM, 0x3, 0x0 }, // 5003
  { PseudoVMADC_VXM_MF8, VMADC_VXM, 0x5, 0x0 }, // 5004
  { PseudoVMADC_VXM_MF4, VMADC_VXM, 0x6, 0x0 }, // 5005
  { PseudoVMADC_VXM_MF2, VMADC_VXM, 0x7, 0x0 }, // 5006
  { PseudoVMADD_VV_M1, VMADD_VV, 0x0, 0x0 }, // 5007
  { PseudoVMADD_VV_M1_MASK, VMADD_VV, 0x0, 0x0 }, // 5008
  { PseudoVMADD_VV_M2, VMADD_VV, 0x1, 0x0 }, // 5009
  { PseudoVMADD_VV_M2_MASK, VMADD_VV, 0x1, 0x0 }, // 5010
  { PseudoVMADD_VV_M4, VMADD_VV, 0x2, 0x0 }, // 5011
  { PseudoVMADD_VV_M4_MASK, VMADD_VV, 0x2, 0x0 }, // 5012
  { PseudoVMADD_VV_M8, VMADD_VV, 0x3, 0x0 }, // 5013
  { PseudoVMADD_VV_M8_MASK, VMADD_VV, 0x3, 0x0 }, // 5014
  { PseudoVMADD_VV_MF8, VMADD_VV, 0x5, 0x0 }, // 5015
  { PseudoVMADD_VV_MF8_MASK, VMADD_VV, 0x5, 0x0 }, // 5016
  { PseudoVMADD_VV_MF4, VMADD_VV, 0x6, 0x0 }, // 5017
  { PseudoVMADD_VV_MF4_MASK, VMADD_VV, 0x6, 0x0 }, // 5018
  { PseudoVMADD_VV_MF2, VMADD_VV, 0x7, 0x0 }, // 5019
  { PseudoVMADD_VV_MF2_MASK, VMADD_VV, 0x7, 0x0 }, // 5020
  { PseudoVMADD_VX_M1, VMADD_VX, 0x0, 0x0 }, // 5021
  { PseudoVMADD_VX_M1_MASK, VMADD_VX, 0x0, 0x0 }, // 5022
  { PseudoVMADD_VX_M2, VMADD_VX, 0x1, 0x0 }, // 5023
  { PseudoVMADD_VX_M2_MASK, VMADD_VX, 0x1, 0x0 }, // 5024
  { PseudoVMADD_VX_M4, VMADD_VX, 0x2, 0x0 }, // 5025
  { PseudoVMADD_VX_M4_MASK, VMADD_VX, 0x2, 0x0 }, // 5026
  { PseudoVMADD_VX_M8, VMADD_VX, 0x3, 0x0 }, // 5027
  { PseudoVMADD_VX_M8_MASK, VMADD_VX, 0x3, 0x0 }, // 5028
  { PseudoVMADD_VX_MF8, VMADD_VX, 0x5, 0x0 }, // 5029
  { PseudoVMADD_VX_MF8_MASK, VMADD_VX, 0x5, 0x0 }, // 5030
  { PseudoVMADD_VX_MF4, VMADD_VX, 0x6, 0x0 }, // 5031
  { PseudoVMADD_VX_MF4_MASK, VMADD_VX, 0x6, 0x0 }, // 5032
  { PseudoVMADD_VX_MF2, VMADD_VX, 0x7, 0x0 }, // 5033
  { PseudoVMADD_VX_MF2_MASK, VMADD_VX, 0x7, 0x0 }, // 5034
  { PseudoVMANDN_MM_M1, VMANDN_MM, 0x0, 0x0 }, // 5035
  { PseudoVMANDN_MM_M2, VMANDN_MM, 0x1, 0x0 }, // 5036
  { PseudoVMANDN_MM_M4, VMANDN_MM, 0x2, 0x0 }, // 5037
  { PseudoVMANDN_MM_M8, VMANDN_MM, 0x3, 0x0 }, // 5038
  { PseudoVMANDN_MM_MF8, VMANDN_MM, 0x5, 0x0 }, // 5039
  { PseudoVMANDN_MM_MF4, VMANDN_MM, 0x6, 0x0 }, // 5040
  { PseudoVMANDN_MM_MF2, VMANDN_MM, 0x7, 0x0 }, // 5041
  { PseudoVMAND_MM_M1, VMAND_MM, 0x0, 0x0 }, // 5042
  { PseudoVMAND_MM_M2, VMAND_MM, 0x1, 0x0 }, // 5043
  { PseudoVMAND_MM_M4, VMAND_MM, 0x2, 0x0 }, // 5044
  { PseudoVMAND_MM_M8, VMAND_MM, 0x3, 0x0 }, // 5045
  { PseudoVMAND_MM_MF8, VMAND_MM, 0x5, 0x0 }, // 5046
  { PseudoVMAND_MM_MF4, VMAND_MM, 0x6, 0x0 }, // 5047
  { PseudoVMAND_MM_MF2, VMAND_MM, 0x7, 0x0 }, // 5048
  { PseudoVMAXU_VV_M1, VMAXU_VV, 0x0, 0x0 }, // 5049
  { PseudoVMAXU_VV_M1_MASK, VMAXU_VV, 0x0, 0x0 }, // 5050
  { PseudoVMAXU_VV_M2, VMAXU_VV, 0x1, 0x0 }, // 5051
  { PseudoVMAXU_VV_M2_MASK, VMAXU_VV, 0x1, 0x0 }, // 5052
  { PseudoVMAXU_VV_M4, VMAXU_VV, 0x2, 0x0 }, // 5053
  { PseudoVMAXU_VV_M4_MASK, VMAXU_VV, 0x2, 0x0 }, // 5054
  { PseudoVMAXU_VV_M8, VMAXU_VV, 0x3, 0x0 }, // 5055
  { PseudoVMAXU_VV_M8_MASK, VMAXU_VV, 0x3, 0x0 }, // 5056
  { PseudoVMAXU_VV_MF8, VMAXU_VV, 0x5, 0x0 }, // 5057
  { PseudoVMAXU_VV_MF8_MASK, VMAXU_VV, 0x5, 0x0 }, // 5058
  { PseudoVMAXU_VV_MF4, VMAXU_VV, 0x6, 0x0 }, // 5059
  { PseudoVMAXU_VV_MF4_MASK, VMAXU_VV, 0x6, 0x0 }, // 5060
  { PseudoVMAXU_VV_MF2, VMAXU_VV, 0x7, 0x0 }, // 5061
  { PseudoVMAXU_VV_MF2_MASK, VMAXU_VV, 0x7, 0x0 }, // 5062
  { PseudoVMAXU_VX_M1, VMAXU_VX, 0x0, 0x0 }, // 5063
  { PseudoVMAXU_VX_M1_MASK, VMAXU_VX, 0x0, 0x0 }, // 5064
  { PseudoVMAXU_VX_M2, VMAXU_VX, 0x1, 0x0 }, // 5065
  { PseudoVMAXU_VX_M2_MASK, VMAXU_VX, 0x1, 0x0 }, // 5066
  { PseudoVMAXU_VX_M4, VMAXU_VX, 0x2, 0x0 }, // 5067
  { PseudoVMAXU_VX_M4_MASK, VMAXU_VX, 0x2, 0x0 }, // 5068
  { PseudoVMAXU_VX_M8, VMAXU_VX, 0x3, 0x0 }, // 5069
  { PseudoVMAXU_VX_M8_MASK, VMAXU_VX, 0x3, 0x0 }, // 5070
  { PseudoVMAXU_VX_MF8, VMAXU_VX, 0x5, 0x0 }, // 5071
  { PseudoVMAXU_VX_MF8_MASK, VMAXU_VX, 0x5, 0x0 }, // 5072
  { PseudoVMAXU_VX_MF4, VMAXU_VX, 0x6, 0x0 }, // 5073
  { PseudoVMAXU_VX_MF4_MASK, VMAXU_VX, 0x6, 0x0 }, // 5074
  { PseudoVMAXU_VX_MF2, VMAXU_VX, 0x7, 0x0 }, // 5075
  { PseudoVMAXU_VX_MF2_MASK, VMAXU_VX, 0x7, 0x0 }, // 5076
  { PseudoVMAX_VV_M1, VMAX_VV, 0x0, 0x0 }, // 5077
  { PseudoVMAX_VV_M1_MASK, VMAX_VV, 0x0, 0x0 }, // 5078
  { PseudoVMAX_VV_M2, VMAX_VV, 0x1, 0x0 }, // 5079
  { PseudoVMAX_VV_M2_MASK, VMAX_VV, 0x1, 0x0 }, // 5080
  { PseudoVMAX_VV_M4, VMAX_VV, 0x2, 0x0 }, // 5081
  { PseudoVMAX_VV_M4_MASK, VMAX_VV, 0x2, 0x0 }, // 5082
  { PseudoVMAX_VV_M8, VMAX_VV, 0x3, 0x0 }, // 5083
  { PseudoVMAX_VV_M8_MASK, VMAX_VV, 0x3, 0x0 }, // 5084
  { PseudoVMAX_VV_MF8, VMAX_VV, 0x5, 0x0 }, // 5085
  { PseudoVMAX_VV_MF8_MASK, VMAX_VV, 0x5, 0x0 }, // 5086
  { PseudoVMAX_VV_MF4, VMAX_VV, 0x6, 0x0 }, // 5087
  { PseudoVMAX_VV_MF4_MASK, VMAX_VV, 0x6, 0x0 }, // 5088
  { PseudoVMAX_VV_MF2, VMAX_VV, 0x7, 0x0 }, // 5089
  { PseudoVMAX_VV_MF2_MASK, VMAX_VV, 0x7, 0x0 }, // 5090
  { PseudoVMAX_VX_M1, VMAX_VX, 0x0, 0x0 }, // 5091
  { PseudoVMAX_VX_M1_MASK, VMAX_VX, 0x0, 0x0 }, // 5092
  { PseudoVMAX_VX_M2, VMAX_VX, 0x1, 0x0 }, // 5093
  { PseudoVMAX_VX_M2_MASK, VMAX_VX, 0x1, 0x0 }, // 5094
  { PseudoVMAX_VX_M4, VMAX_VX, 0x2, 0x0 }, // 5095
  { PseudoVMAX_VX_M4_MASK, VMAX_VX, 0x2, 0x0 }, // 5096
  { PseudoVMAX_VX_M8, VMAX_VX, 0x3, 0x0 }, // 5097
  { PseudoVMAX_VX_M8_MASK, VMAX_VX, 0x3, 0x0 }, // 5098
  { PseudoVMAX_VX_MF8, VMAX_VX, 0x5, 0x0 }, // 5099
  { PseudoVMAX_VX_MF8_MASK, VMAX_VX, 0x5, 0x0 }, // 5100
  { PseudoVMAX_VX_MF4, VMAX_VX, 0x6, 0x0 }, // 5101
  { PseudoVMAX_VX_MF4_MASK, VMAX_VX, 0x6, 0x0 }, // 5102
  { PseudoVMAX_VX_MF2, VMAX_VX, 0x7, 0x0 }, // 5103
  { PseudoVMAX_VX_MF2_MASK, VMAX_VX, 0x7, 0x0 }, // 5104
  { PseudoVMERGE_VIM_M1, VMERGE_VIM, 0x0, 0x0 }, // 5105
  { PseudoVMERGE_VIM_M2, VMERGE_VIM, 0x1, 0x0 }, // 5106
  { PseudoVMERGE_VIM_M4, VMERGE_VIM, 0x2, 0x0 }, // 5107
  { PseudoVMERGE_VIM_M8, VMERGE_VIM, 0x3, 0x0 }, // 5108
  { PseudoVMERGE_VIM_MF8, VMERGE_VIM, 0x5, 0x0 }, // 5109
  { PseudoVMERGE_VIM_MF4, VMERGE_VIM, 0x6, 0x0 }, // 5110
  { PseudoVMERGE_VIM_MF2, VMERGE_VIM, 0x7, 0x0 }, // 5111
  { PseudoVMERGE_VVM_M1, VMERGE_VVM, 0x0, 0x0 }, // 5112
  { PseudoVMERGE_VVM_M2, VMERGE_VVM, 0x1, 0x0 }, // 5113
  { PseudoVMERGE_VVM_M4, VMERGE_VVM, 0x2, 0x0 }, // 5114
  { PseudoVMERGE_VVM_M8, VMERGE_VVM, 0x3, 0x0 }, // 5115
  { PseudoVMERGE_VVM_MF8, VMERGE_VVM, 0x5, 0x0 }, // 5116
  { PseudoVMERGE_VVM_MF4, VMERGE_VVM, 0x6, 0x0 }, // 5117
  { PseudoVMERGE_VVM_MF2, VMERGE_VVM, 0x7, 0x0 }, // 5118
  { PseudoVMERGE_VXM_M1, VMERGE_VXM, 0x0, 0x0 }, // 5119
  { PseudoVMERGE_VXM_M2, VMERGE_VXM, 0x1, 0x0 }, // 5120
  { PseudoVMERGE_VXM_M4, VMERGE_VXM, 0x2, 0x0 }, // 5121
  { PseudoVMERGE_VXM_M8, VMERGE_VXM, 0x3, 0x0 }, // 5122
  { PseudoVMERGE_VXM_MF8, VMERGE_VXM, 0x5, 0x0 }, // 5123
  { PseudoVMERGE_VXM_MF4, VMERGE_VXM, 0x6, 0x0 }, // 5124
  { PseudoVMERGE_VXM_MF2, VMERGE_VXM, 0x7, 0x0 }, // 5125
  { PseudoVMFEQ_VF16_M1, VMFEQ_VF, 0x0, 0x0 }, // 5126
  { PseudoVMFEQ_VF16_M1_MASK, VMFEQ_VF, 0x0, 0x0 }, // 5127
  { PseudoVMFEQ_VF32_M1, VMFEQ_VF, 0x0, 0x0 }, // 5128
  { PseudoVMFEQ_VF32_M1_MASK, VMFEQ_VF, 0x0, 0x0 }, // 5129
  { PseudoVMFEQ_VF64_M1, VMFEQ_VF, 0x0, 0x0 }, // 5130
  { PseudoVMFEQ_VF64_M1_MASK, VMFEQ_VF, 0x0, 0x0 }, // 5131
  { PseudoVMFEQ_VF16_M2, VMFEQ_VF, 0x1, 0x0 }, // 5132
  { PseudoVMFEQ_VF16_M2_MASK, VMFEQ_VF, 0x1, 0x0 }, // 5133
  { PseudoVMFEQ_VF32_M2, VMFEQ_VF, 0x1, 0x0 }, // 5134
  { PseudoVMFEQ_VF32_M2_MASK, VMFEQ_VF, 0x1, 0x0 }, // 5135
  { PseudoVMFEQ_VF64_M2, VMFEQ_VF, 0x1, 0x0 }, // 5136
  { PseudoVMFEQ_VF64_M2_MASK, VMFEQ_VF, 0x1, 0x0 }, // 5137
  { PseudoVMFEQ_VF16_M4, VMFEQ_VF, 0x2, 0x0 }, // 5138
  { PseudoVMFEQ_VF16_M4_MASK, VMFEQ_VF, 0x2, 0x0 }, // 5139
  { PseudoVMFEQ_VF32_M4, VMFEQ_VF, 0x2, 0x0 }, // 5140
  { PseudoVMFEQ_VF32_M4_MASK, VMFEQ_VF, 0x2, 0x0 }, // 5141
  { PseudoVMFEQ_VF64_M4, VMFEQ_VF, 0x2, 0x0 }, // 5142
  { PseudoVMFEQ_VF64_M4_MASK, VMFEQ_VF, 0x2, 0x0 }, // 5143
  { PseudoVMFEQ_VF16_M8, VMFEQ_VF, 0x3, 0x0 }, // 5144
  { PseudoVMFEQ_VF16_M8_MASK, VMFEQ_VF, 0x3, 0x0 }, // 5145
  { PseudoVMFEQ_VF32_M8, VMFEQ_VF, 0x3, 0x0 }, // 5146
  { PseudoVMFEQ_VF32_M8_MASK, VMFEQ_VF, 0x3, 0x0 }, // 5147
  { PseudoVMFEQ_VF64_M8, VMFEQ_VF, 0x3, 0x0 }, // 5148
  { PseudoVMFEQ_VF64_M8_MASK, VMFEQ_VF, 0x3, 0x0 }, // 5149
  { PseudoVMFEQ_VF16_MF4, VMFEQ_VF, 0x6, 0x0 }, // 5150
  { PseudoVMFEQ_VF16_MF4_MASK, VMFEQ_VF, 0x6, 0x0 }, // 5151
  { PseudoVMFEQ_VF16_MF2, VMFEQ_VF, 0x7, 0x0 }, // 5152
  { PseudoVMFEQ_VF16_MF2_MASK, VMFEQ_VF, 0x7, 0x0 }, // 5153
  { PseudoVMFEQ_VF32_MF2, VMFEQ_VF, 0x7, 0x0 }, // 5154
  { PseudoVMFEQ_VF32_MF2_MASK, VMFEQ_VF, 0x7, 0x0 }, // 5155
  { PseudoVMFEQ_VV_M1, VMFEQ_VV, 0x0, 0x0 }, // 5156
  { PseudoVMFEQ_VV_M1_MASK, VMFEQ_VV, 0x0, 0x0 }, // 5157
  { PseudoVMFEQ_VV_M2, VMFEQ_VV, 0x1, 0x0 }, // 5158
  { PseudoVMFEQ_VV_M2_MASK, VMFEQ_VV, 0x1, 0x0 }, // 5159
  { PseudoVMFEQ_VV_M4, VMFEQ_VV, 0x2, 0x0 }, // 5160
  { PseudoVMFEQ_VV_M4_MASK, VMFEQ_VV, 0x2, 0x0 }, // 5161
  { PseudoVMFEQ_VV_M8, VMFEQ_VV, 0x3, 0x0 }, // 5162
  { PseudoVMFEQ_VV_M8_MASK, VMFEQ_VV, 0x3, 0x0 }, // 5163
  { PseudoVMFEQ_VV_MF4, VMFEQ_VV, 0x6, 0x0 }, // 5164
  { PseudoVMFEQ_VV_MF4_MASK, VMFEQ_VV, 0x6, 0x0 }, // 5165
  { PseudoVMFEQ_VV_MF2, VMFEQ_VV, 0x7, 0x0 }, // 5166
  { PseudoVMFEQ_VV_MF2_MASK, VMFEQ_VV, 0x7, 0x0 }, // 5167
  { PseudoVMFGE_VF16_M1, VMFGE_VF, 0x0, 0x0 }, // 5168
  { PseudoVMFGE_VF16_M1_MASK, VMFGE_VF, 0x0, 0x0 }, // 5169
  { PseudoVMFGE_VF32_M1, VMFGE_VF, 0x0, 0x0 }, // 5170
  { PseudoVMFGE_VF32_M1_MASK, VMFGE_VF, 0x0, 0x0 }, // 5171
  { PseudoVMFGE_VF64_M1, VMFGE_VF, 0x0, 0x0 }, // 5172
  { PseudoVMFGE_VF64_M1_MASK, VMFGE_VF, 0x0, 0x0 }, // 5173
  { PseudoVMFGE_VF16_M2, VMFGE_VF, 0x1, 0x0 }, // 5174
  { PseudoVMFGE_VF16_M2_MASK, VMFGE_VF, 0x1, 0x0 }, // 5175
  { PseudoVMFGE_VF32_M2, VMFGE_VF, 0x1, 0x0 }, // 5176
  { PseudoVMFGE_VF32_M2_MASK, VMFGE_VF, 0x1, 0x0 }, // 5177
  { PseudoVMFGE_VF64_M2, VMFGE_VF, 0x1, 0x0 }, // 5178
  { PseudoVMFGE_VF64_M2_MASK, VMFGE_VF, 0x1, 0x0 }, // 5179
  { PseudoVMFGE_VF16_M4, VMFGE_VF, 0x2, 0x0 }, // 5180
  { PseudoVMFGE_VF16_M4_MASK, VMFGE_VF, 0x2, 0x0 }, // 5181
  { PseudoVMFGE_VF32_M4, VMFGE_VF, 0x2, 0x0 }, // 5182
  { PseudoVMFGE_VF32_M4_MASK, VMFGE_VF, 0x2, 0x0 }, // 5183
  { PseudoVMFGE_VF64_M4, VMFGE_VF, 0x2, 0x0 }, // 5184
  { PseudoVMFGE_VF64_M4_MASK, VMFGE_VF, 0x2, 0x0 }, // 5185
  { PseudoVMFGE_VF16_M8, VMFGE_VF, 0x3, 0x0 }, // 5186
  { PseudoVMFGE_VF16_M8_MASK, VMFGE_VF, 0x3, 0x0 }, // 5187
  { PseudoVMFGE_VF32_M8, VMFGE_VF, 0x3, 0x0 }, // 5188
  { PseudoVMFGE_VF32_M8_MASK, VMFGE_VF, 0x3, 0x0 }, // 5189
  { PseudoVMFGE_VF64_M8, VMFGE_VF, 0x3, 0x0 }, // 5190
  { PseudoVMFGE_VF64_M8_MASK, VMFGE_VF, 0x3, 0x0 }, // 5191
  { PseudoVMFGE_VF16_MF4, VMFGE_VF, 0x6, 0x0 }, // 5192
  { PseudoVMFGE_VF16_MF4_MASK, VMFGE_VF, 0x6, 0x0 }, // 5193
  { PseudoVMFGE_VF16_MF2, VMFGE_VF, 0x7, 0x0 }, // 5194
  { PseudoVMFGE_VF16_MF2_MASK, VMFGE_VF, 0x7, 0x0 }, // 5195
  { PseudoVMFGE_VF32_MF2, VMFGE_VF, 0x7, 0x0 }, // 5196
  { PseudoVMFGE_VF32_MF2_MASK, VMFGE_VF, 0x7, 0x0 }, // 5197
  { PseudoVMFGT_VF16_M1, VMFGT_VF, 0x0, 0x0 }, // 5198
  { PseudoVMFGT_VF16_M1_MASK, VMFGT_VF, 0x0, 0x0 }, // 5199
  { PseudoVMFGT_VF32_M1, VMFGT_VF, 0x0, 0x0 }, // 5200
  { PseudoVMFGT_VF32_M1_MASK, VMFGT_VF, 0x0, 0x0 }, // 5201
  { PseudoVMFGT_VF64_M1, VMFGT_VF, 0x0, 0x0 }, // 5202
  { PseudoVMFGT_VF64_M1_MASK, VMFGT_VF, 0x0, 0x0 }, // 5203
  { PseudoVMFGT_VF16_M2, VMFGT_VF, 0x1, 0x0 }, // 5204
  { PseudoVMFGT_VF16_M2_MASK, VMFGT_VF, 0x1, 0x0 }, // 5205
  { PseudoVMFGT_VF32_M2, VMFGT_VF, 0x1, 0x0 }, // 5206
  { PseudoVMFGT_VF32_M2_MASK, VMFGT_VF, 0x1, 0x0 }, // 5207
  { PseudoVMFGT_VF64_M2, VMFGT_VF, 0x1, 0x0 }, // 5208
  { PseudoVMFGT_VF64_M2_MASK, VMFGT_VF, 0x1, 0x0 }, // 5209
  { PseudoVMFGT_VF16_M4, VMFGT_VF, 0x2, 0x0 }, // 5210
  { PseudoVMFGT_VF16_M4_MASK, VMFGT_VF, 0x2, 0x0 }, // 5211
  { PseudoVMFGT_VF32_M4, VMFGT_VF, 0x2, 0x0 }, // 5212
  { PseudoVMFGT_VF32_M4_MASK, VMFGT_VF, 0x2, 0x0 }, // 5213
  { PseudoVMFGT_VF64_M4, VMFGT_VF, 0x2, 0x0 }, // 5214
  { PseudoVMFGT_VF64_M4_MASK, VMFGT_VF, 0x2, 0x0 }, // 5215
  { PseudoVMFGT_VF16_M8, VMFGT_VF, 0x3, 0x0 }, // 5216
  { PseudoVMFGT_VF16_M8_MASK, VMFGT_VF, 0x3, 0x0 }, // 5217
  { PseudoVMFGT_VF32_M8, VMFGT_VF, 0x3, 0x0 }, // 5218
  { PseudoVMFGT_VF32_M8_MASK, VMFGT_VF, 0x3, 0x0 }, // 5219
  { PseudoVMFGT_VF64_M8, VMFGT_VF, 0x3, 0x0 }, // 5220
  { PseudoVMFGT_VF64_M8_MASK, VMFGT_VF, 0x3, 0x0 }, // 5221
  { PseudoVMFGT_VF16_MF4, VMFGT_VF, 0x6, 0x0 }, // 5222
  { PseudoVMFGT_VF16_MF4_MASK, VMFGT_VF, 0x6, 0x0 }, // 5223
  { PseudoVMFGT_VF16_MF2, VMFGT_VF, 0x7, 0x0 }, // 5224
  { PseudoVMFGT_VF16_MF2_MASK, VMFGT_VF, 0x7, 0x0 }, // 5225
  { PseudoVMFGT_VF32_MF2, VMFGT_VF, 0x7, 0x0 }, // 5226
  { PseudoVMFGT_VF32_MF2_MASK, VMFGT_VF, 0x7, 0x0 }, // 5227
  { PseudoVMFLE_VF16_M1, VMFLE_VF, 0x0, 0x0 }, // 5228
  { PseudoVMFLE_VF16_M1_MASK, VMFLE_VF, 0x0, 0x0 }, // 5229
  { PseudoVMFLE_VF32_M1, VMFLE_VF, 0x0, 0x0 }, // 5230
  { PseudoVMFLE_VF32_M1_MASK, VMFLE_VF, 0x0, 0x0 }, // 5231
  { PseudoVMFLE_VF64_M1, VMFLE_VF, 0x0, 0x0 }, // 5232
  { PseudoVMFLE_VF64_M1_MASK, VMFLE_VF, 0x0, 0x0 }, // 5233
  { PseudoVMFLE_VF16_M2, VMFLE_VF, 0x1, 0x0 }, // 5234
  { PseudoVMFLE_VF16_M2_MASK, VMFLE_VF, 0x1, 0x0 }, // 5235
  { PseudoVMFLE_VF32_M2, VMFLE_VF, 0x1, 0x0 }, // 5236
  { PseudoVMFLE_VF32_M2_MASK, VMFLE_VF, 0x1, 0x0 }, // 5237
  { PseudoVMFLE_VF64_M2, VMFLE_VF, 0x1, 0x0 }, // 5238
  { PseudoVMFLE_VF64_M2_MASK, VMFLE_VF, 0x1, 0x0 }, // 5239
  { PseudoVMFLE_VF16_M4, VMFLE_VF, 0x2, 0x0 }, // 5240
  { PseudoVMFLE_VF16_M4_MASK, VMFLE_VF, 0x2, 0x0 }, // 5241
  { PseudoVMFLE_VF32_M4, VMFLE_VF, 0x2, 0x0 }, // 5242
  { PseudoVMFLE_VF32_M4_MASK, VMFLE_VF, 0x2, 0x0 }, // 5243
  { PseudoVMFLE_VF64_M4, VMFLE_VF, 0x2, 0x0 }, // 5244
  { PseudoVMFLE_VF64_M4_MASK, VMFLE_VF, 0x2, 0x0 }, // 5245
  { PseudoVMFLE_VF16_M8, VMFLE_VF, 0x3, 0x0 }, // 5246
  { PseudoVMFLE_VF16_M8_MASK, VMFLE_VF, 0x3, 0x0 }, // 5247
  { PseudoVMFLE_VF32_M8, VMFLE_VF, 0x3, 0x0 }, // 5248
  { PseudoVMFLE_VF32_M8_MASK, VMFLE_VF, 0x3, 0x0 }, // 5249
  { PseudoVMFLE_VF64_M8, VMFLE_VF, 0x3, 0x0 }, // 5250
  { PseudoVMFLE_VF64_M8_MASK, VMFLE_VF, 0x3, 0x0 }, // 5251
  { PseudoVMFLE_VF16_MF4, VMFLE_VF, 0x6, 0x0 }, // 5252
  { PseudoVMFLE_VF16_MF4_MASK, VMFLE_VF, 0x6, 0x0 }, // 5253
  { PseudoVMFLE_VF16_MF2, VMFLE_VF, 0x7, 0x0 }, // 5254
  { PseudoVMFLE_VF16_MF2_MASK, VMFLE_VF, 0x7, 0x0 }, // 5255
  { PseudoVMFLE_VF32_MF2, VMFLE_VF, 0x7, 0x0 }, // 5256
  { PseudoVMFLE_VF32_MF2_MASK, VMFLE_VF, 0x7, 0x0 }, // 5257
  { PseudoVMFLE_VV_M1, VMFLE_VV, 0x0, 0x0 }, // 5258
  { PseudoVMFLE_VV_M1_MASK, VMFLE_VV, 0x0, 0x0 }, // 5259
  { PseudoVMFLE_VV_M2, VMFLE_VV, 0x1, 0x0 }, // 5260
  { PseudoVMFLE_VV_M2_MASK, VMFLE_VV, 0x1, 0x0 }, // 5261
  { PseudoVMFLE_VV_M4, VMFLE_VV, 0x2, 0x0 }, // 5262
  { PseudoVMFLE_VV_M4_MASK, VMFLE_VV, 0x2, 0x0 }, // 5263
  { PseudoVMFLE_VV_M8, VMFLE_VV, 0x3, 0x0 }, // 5264
  { PseudoVMFLE_VV_M8_MASK, VMFLE_VV, 0x3, 0x0 }, // 5265
  { PseudoVMFLE_VV_MF4, VMFLE_VV, 0x6, 0x0 }, // 5266
  { PseudoVMFLE_VV_MF4_MASK, VMFLE_VV, 0x6, 0x0 }, // 5267
  { PseudoVMFLE_VV_MF2, VMFLE_VV, 0x7, 0x0 }, // 5268
  { PseudoVMFLE_VV_MF2_MASK, VMFLE_VV, 0x7, 0x0 }, // 5269
  { PseudoVMFLT_VF16_M1, VMFLT_VF, 0x0, 0x0 }, // 5270
  { PseudoVMFLT_VF16_M1_MASK, VMFLT_VF, 0x0, 0x0 }, // 5271
  { PseudoVMFLT_VF32_M1, VMFLT_VF, 0x0, 0x0 }, // 5272
  { PseudoVMFLT_VF32_M1_MASK, VMFLT_VF, 0x0, 0x0 }, // 5273
  { PseudoVMFLT_VF64_M1, VMFLT_VF, 0x0, 0x0 }, // 5274
  { PseudoVMFLT_VF64_M1_MASK, VMFLT_VF, 0x0, 0x0 }, // 5275
  { PseudoVMFLT_VF16_M2, VMFLT_VF, 0x1, 0x0 }, // 5276
  { PseudoVMFLT_VF16_M2_MASK, VMFLT_VF, 0x1, 0x0 }, // 5277
  { PseudoVMFLT_VF32_M2, VMFLT_VF, 0x1, 0x0 }, // 5278
  { PseudoVMFLT_VF32_M2_MASK, VMFLT_VF, 0x1, 0x0 }, // 5279
  { PseudoVMFLT_VF64_M2, VMFLT_VF, 0x1, 0x0 }, // 5280
  { PseudoVMFLT_VF64_M2_MASK, VMFLT_VF, 0x1, 0x0 }, // 5281
  { PseudoVMFLT_VF16_M4, VMFLT_VF, 0x2, 0x0 }, // 5282
  { PseudoVMFLT_VF16_M4_MASK, VMFLT_VF, 0x2, 0x0 }, // 5283
  { PseudoVMFLT_VF32_M4, VMFLT_VF, 0x2, 0x0 }, // 5284
  { PseudoVMFLT_VF32_M4_MASK, VMFLT_VF, 0x2, 0x0 }, // 5285
  { PseudoVMFLT_VF64_M4, VMFLT_VF, 0x2, 0x0 }, // 5286
  { PseudoVMFLT_VF64_M4_MASK, VMFLT_VF, 0x2, 0x0 }, // 5287
  { PseudoVMFLT_VF16_M8, VMFLT_VF, 0x3, 0x0 }, // 5288
  { PseudoVMFLT_VF16_M8_MASK, VMFLT_VF, 0x3, 0x0 }, // 5289
  { PseudoVMFLT_VF32_M8, VMFLT_VF, 0x3, 0x0 }, // 5290
  { PseudoVMFLT_VF32_M8_MASK, VMFLT_VF, 0x3, 0x0 }, // 5291
  { PseudoVMFLT_VF64_M8, VMFLT_VF, 0x3, 0x0 }, // 5292
  { PseudoVMFLT_VF64_M8_MASK, VMFLT_VF, 0x3, 0x0 }, // 5293
  { PseudoVMFLT_VF16_MF4, VMFLT_VF, 0x6, 0x0 }, // 5294
  { PseudoVMFLT_VF16_MF4_MASK, VMFLT_VF, 0x6, 0x0 }, // 5295
  { PseudoVMFLT_VF16_MF2, VMFLT_VF, 0x7, 0x0 }, // 5296
  { PseudoVMFLT_VF16_MF2_MASK, VMFLT_VF, 0x7, 0x0 }, // 5297
  { PseudoVMFLT_VF32_MF2, VMFLT_VF, 0x7, 0x0 }, // 5298
  { PseudoVMFLT_VF32_MF2_MASK, VMFLT_VF, 0x7, 0x0 }, // 5299
  { PseudoVMFLT_VV_M1, VMFLT_VV, 0x0, 0x0 }, // 5300
  { PseudoVMFLT_VV_M1_MASK, VMFLT_VV, 0x0, 0x0 }, // 5301
  { PseudoVMFLT_VV_M2, VMFLT_VV, 0x1, 0x0 }, // 5302
  { PseudoVMFLT_VV_M2_MASK, VMFLT_VV, 0x1, 0x0 }, // 5303
  { PseudoVMFLT_VV_M4, VMFLT_VV, 0x2, 0x0 }, // 5304
  { PseudoVMFLT_VV_M4_MASK, VMFLT_VV, 0x2, 0x0 }, // 5305
  { PseudoVMFLT_VV_M8, VMFLT_VV, 0x3, 0x0 }, // 5306
  { PseudoVMFLT_VV_M8_MASK, VMFLT_VV, 0x3, 0x0 }, // 5307
  { PseudoVMFLT_VV_MF4, VMFLT_VV, 0x6, 0x0 }, // 5308
  { PseudoVMFLT_VV_MF4_MASK, VMFLT_VV, 0x6, 0x0 }, // 5309
  { PseudoVMFLT_VV_MF2, VMFLT_VV, 0x7, 0x0 }, // 5310
  { PseudoVMFLT_VV_MF2_MASK, VMFLT_VV, 0x7, 0x0 }, // 5311
  { PseudoVMFNE_VF16_M1, VMFNE_VF, 0x0, 0x0 }, // 5312
  { PseudoVMFNE_VF16_M1_MASK, VMFNE_VF, 0x0, 0x0 }, // 5313
  { PseudoVMFNE_VF32_M1, VMFNE_VF, 0x0, 0x0 }, // 5314
  { PseudoVMFNE_VF32_M1_MASK, VMFNE_VF, 0x0, 0x0 }, // 5315
  { PseudoVMFNE_VF64_M1, VMFNE_VF, 0x0, 0x0 }, // 5316
  { PseudoVMFNE_VF64_M1_MASK, VMFNE_VF, 0x0, 0x0 }, // 5317
  { PseudoVMFNE_VF16_M2, VMFNE_VF, 0x1, 0x0 }, // 5318
  { PseudoVMFNE_VF16_M2_MASK, VMFNE_VF, 0x1, 0x0 }, // 5319
  { PseudoVMFNE_VF32_M2, VMFNE_VF, 0x1, 0x0 }, // 5320
  { PseudoVMFNE_VF32_M2_MASK, VMFNE_VF, 0x1, 0x0 }, // 5321
  { PseudoVMFNE_VF64_M2, VMFNE_VF, 0x1, 0x0 }, // 5322
  { PseudoVMFNE_VF64_M2_MASK, VMFNE_VF, 0x1, 0x0 }, // 5323
  { PseudoVMFNE_VF16_M4, VMFNE_VF, 0x2, 0x0 }, // 5324
  { PseudoVMFNE_VF16_M4_MASK, VMFNE_VF, 0x2, 0x0 }, // 5325
  { PseudoVMFNE_VF32_M4, VMFNE_VF, 0x2, 0x0 }, // 5326
  { PseudoVMFNE_VF32_M4_MASK, VMFNE_VF, 0x2, 0x0 }, // 5327
  { PseudoVMFNE_VF64_M4, VMFNE_VF, 0x2, 0x0 }, // 5328
  { PseudoVMFNE_VF64_M4_MASK, VMFNE_VF, 0x2, 0x0 }, // 5329
  { PseudoVMFNE_VF16_M8, VMFNE_VF, 0x3, 0x0 }, // 5330
  { PseudoVMFNE_VF16_M8_MASK, VMFNE_VF, 0x3, 0x0 }, // 5331
  { PseudoVMFNE_VF32_M8, VMFNE_VF, 0x3, 0x0 }, // 5332
  { PseudoVMFNE_VF32_M8_MASK, VMFNE_VF, 0x3, 0x0 }, // 5333
  { PseudoVMFNE_VF64_M8, VMFNE_VF, 0x3, 0x0 }, // 5334
  { PseudoVMFNE_VF64_M8_MASK, VMFNE_VF, 0x3, 0x0 }, // 5335
  { PseudoVMFNE_VF16_MF4, VMFNE_VF, 0x6, 0x0 }, // 5336
  { PseudoVMFNE_VF16_MF4_MASK, VMFNE_VF, 0x6, 0x0 }, // 5337
  { PseudoVMFNE_VF16_MF2, VMFNE_VF, 0x7, 0x0 }, // 5338
  { PseudoVMFNE_VF16_MF2_MASK, VMFNE_VF, 0x7, 0x0 }, // 5339
  { PseudoVMFNE_VF32_MF2, VMFNE_VF, 0x7, 0x0 }, // 5340
  { PseudoVMFNE_VF32_MF2_MASK, VMFNE_VF, 0x7, 0x0 }, // 5341
  { PseudoVMFNE_VV_M1, VMFNE_VV, 0x0, 0x0 }, // 5342
  { PseudoVMFNE_VV_M1_MASK, VMFNE_VV, 0x0, 0x0 }, // 5343
  { PseudoVMFNE_VV_M2, VMFNE_VV, 0x1, 0x0 }, // 5344
  { PseudoVMFNE_VV_M2_MASK, VMFNE_VV, 0x1, 0x0 }, // 5345
  { PseudoVMFNE_VV_M4, VMFNE_VV, 0x2, 0x0 }, // 5346
  { PseudoVMFNE_VV_M4_MASK, VMFNE_VV, 0x2, 0x0 }, // 5347
  { PseudoVMFNE_VV_M8, VMFNE_VV, 0x3, 0x0 }, // 5348
  { PseudoVMFNE_VV_M8_MASK, VMFNE_VV, 0x3, 0x0 }, // 5349
  { PseudoVMFNE_VV_MF4, VMFNE_VV, 0x6, 0x0 }, // 5350
  { PseudoVMFNE_VV_MF4_MASK, VMFNE_VV, 0x6, 0x0 }, // 5351
  { PseudoVMFNE_VV_MF2, VMFNE_VV, 0x7, 0x0 }, // 5352
  { PseudoVMFNE_VV_MF2_MASK, VMFNE_VV, 0x7, 0x0 }, // 5353
  { PseudoVMINU_VV_M1, VMINU_VV, 0x0, 0x0 }, // 5354
  { PseudoVMINU_VV_M1_MASK, VMINU_VV, 0x0, 0x0 }, // 5355
  { PseudoVMINU_VV_M2, VMINU_VV, 0x1, 0x0 }, // 5356
  { PseudoVMINU_VV_M2_MASK, VMINU_VV, 0x1, 0x0 }, // 5357
  { PseudoVMINU_VV_M4, VMINU_VV, 0x2, 0x0 }, // 5358
  { PseudoVMINU_VV_M4_MASK, VMINU_VV, 0x2, 0x0 }, // 5359
  { PseudoVMINU_VV_M8, VMINU_VV, 0x3, 0x0 }, // 5360
  { PseudoVMINU_VV_M8_MASK, VMINU_VV, 0x3, 0x0 }, // 5361
  { PseudoVMINU_VV_MF8, VMINU_VV, 0x5, 0x0 }, // 5362
  { PseudoVMINU_VV_MF8_MASK, VMINU_VV, 0x5, 0x0 }, // 5363
  { PseudoVMINU_VV_MF4, VMINU_VV, 0x6, 0x0 }, // 5364
  { PseudoVMINU_VV_MF4_MASK, VMINU_VV, 0x6, 0x0 }, // 5365
  { PseudoVMINU_VV_MF2, VMINU_VV, 0x7, 0x0 }, // 5366
  { PseudoVMINU_VV_MF2_MASK, VMINU_VV, 0x7, 0x0 }, // 5367
  { PseudoVMINU_VX_M1, VMINU_VX, 0x0, 0x0 }, // 5368
  { PseudoVMINU_VX_M1_MASK, VMINU_VX, 0x0, 0x0 }, // 5369
  { PseudoVMINU_VX_M2, VMINU_VX, 0x1, 0x0 }, // 5370
  { PseudoVMINU_VX_M2_MASK, VMINU_VX, 0x1, 0x0 }, // 5371
  { PseudoVMINU_VX_M4, VMINU_VX, 0x2, 0x0 }, // 5372
  { PseudoVMINU_VX_M4_MASK, VMINU_VX, 0x2, 0x0 }, // 5373
  { PseudoVMINU_VX_M8, VMINU_VX, 0x3, 0x0 }, // 5374
  { PseudoVMINU_VX_M8_MASK, VMINU_VX, 0x3, 0x0 }, // 5375
  { PseudoVMINU_VX_MF8, VMINU_VX, 0x5, 0x0 }, // 5376
  { PseudoVMINU_VX_MF8_MASK, VMINU_VX, 0x5, 0x0 }, // 5377
  { PseudoVMINU_VX_MF4, VMINU_VX, 0x6, 0x0 }, // 5378
  { PseudoVMINU_VX_MF4_MASK, VMINU_VX, 0x6, 0x0 }, // 5379
  { PseudoVMINU_VX_MF2, VMINU_VX, 0x7, 0x0 }, // 5380
  { PseudoVMINU_VX_MF2_MASK, VMINU_VX, 0x7, 0x0 }, // 5381
  { PseudoVMIN_VV_M1, VMIN_VV, 0x0, 0x0 }, // 5382
  { PseudoVMIN_VV_M1_MASK, VMIN_VV, 0x0, 0x0 }, // 5383
  { PseudoVMIN_VV_M2, VMIN_VV, 0x1, 0x0 }, // 5384
  { PseudoVMIN_VV_M2_MASK, VMIN_VV, 0x1, 0x0 }, // 5385
  { PseudoVMIN_VV_M4, VMIN_VV, 0x2, 0x0 }, // 5386
  { PseudoVMIN_VV_M4_MASK, VMIN_VV, 0x2, 0x0 }, // 5387
  { PseudoVMIN_VV_M8, VMIN_VV, 0x3, 0x0 }, // 5388
  { PseudoVMIN_VV_M8_MASK, VMIN_VV, 0x3, 0x0 }, // 5389
  { PseudoVMIN_VV_MF8, VMIN_VV, 0x5, 0x0 }, // 5390
  { PseudoVMIN_VV_MF8_MASK, VMIN_VV, 0x5, 0x0 }, // 5391
  { PseudoVMIN_VV_MF4, VMIN_VV, 0x6, 0x0 }, // 5392
  { PseudoVMIN_VV_MF4_MASK, VMIN_VV, 0x6, 0x0 }, // 5393
  { PseudoVMIN_VV_MF2, VMIN_VV, 0x7, 0x0 }, // 5394
  { PseudoVMIN_VV_MF2_MASK, VMIN_VV, 0x7, 0x0 }, // 5395
  { PseudoVMIN_VX_M1, VMIN_VX, 0x0, 0x0 }, // 5396
  { PseudoVMIN_VX_M1_MASK, VMIN_VX, 0x0, 0x0 }, // 5397
  { PseudoVMIN_VX_M2, VMIN_VX, 0x1, 0x0 }, // 5398
  { PseudoVMIN_VX_M2_MASK, VMIN_VX, 0x1, 0x0 }, // 5399
  { PseudoVMIN_VX_M4, VMIN_VX, 0x2, 0x0 }, // 5400
  { PseudoVMIN_VX_M4_MASK, VMIN_VX, 0x2, 0x0 }, // 5401
  { PseudoVMIN_VX_M8, VMIN_VX, 0x3, 0x0 }, // 5402
  { PseudoVMIN_VX_M8_MASK, VMIN_VX, 0x3, 0x0 }, // 5403
  { PseudoVMIN_VX_MF8, VMIN_VX, 0x5, 0x0 }, // 5404
  { PseudoVMIN_VX_MF8_MASK, VMIN_VX, 0x5, 0x0 }, // 5405
  { PseudoVMIN_VX_MF4, VMIN_VX, 0x6, 0x0 }, // 5406
  { PseudoVMIN_VX_MF4_MASK, VMIN_VX, 0x6, 0x0 }, // 5407
  { PseudoVMIN_VX_MF2, VMIN_VX, 0x7, 0x0 }, // 5408
  { PseudoVMIN_VX_MF2_MASK, VMIN_VX, 0x7, 0x0 }, // 5409
  { PseudoVMNAND_MM_M1, VMNAND_MM, 0x0, 0x0 }, // 5410
  { PseudoVMNAND_MM_M2, VMNAND_MM, 0x1, 0x0 }, // 5411
  { PseudoVMNAND_MM_M4, VMNAND_MM, 0x2, 0x0 }, // 5412
  { PseudoVMNAND_MM_M8, VMNAND_MM, 0x3, 0x0 }, // 5413
  { PseudoVMNAND_MM_MF8, VMNAND_MM, 0x5, 0x0 }, // 5414
  { PseudoVMNAND_MM_MF4, VMNAND_MM, 0x6, 0x0 }, // 5415
  { PseudoVMNAND_MM_MF2, VMNAND_MM, 0x7, 0x0 }, // 5416
  { PseudoVMNOR_MM_M1, VMNOR_MM, 0x0, 0x0 }, // 5417
  { PseudoVMNOR_MM_M2, VMNOR_MM, 0x1, 0x0 }, // 5418
  { PseudoVMNOR_MM_M4, VMNOR_MM, 0x2, 0x0 }, // 5419
  { PseudoVMNOR_MM_M8, VMNOR_MM, 0x3, 0x0 }, // 5420
  { PseudoVMNOR_MM_MF8, VMNOR_MM, 0x5, 0x0 }, // 5421
  { PseudoVMNOR_MM_MF4, VMNOR_MM, 0x6, 0x0 }, // 5422
  { PseudoVMNOR_MM_MF2, VMNOR_MM, 0x7, 0x0 }, // 5423
  { PseudoVMORN_MM_M1, VMORN_MM, 0x0, 0x0 }, // 5424
  { PseudoVMORN_MM_M2, VMORN_MM, 0x1, 0x0 }, // 5425
  { PseudoVMORN_MM_M4, VMORN_MM, 0x2, 0x0 }, // 5426
  { PseudoVMORN_MM_M8, VMORN_MM, 0x3, 0x0 }, // 5427
  { PseudoVMORN_MM_MF8, VMORN_MM, 0x5, 0x0 }, // 5428
  { PseudoVMORN_MM_MF4, VMORN_MM, 0x6, 0x0 }, // 5429
  { PseudoVMORN_MM_MF2, VMORN_MM, 0x7, 0x0 }, // 5430
  { PseudoVMOR_MM_M1, VMOR_MM, 0x0, 0x0 }, // 5431
  { PseudoVMOR_MM_M2, VMOR_MM, 0x1, 0x0 }, // 5432
  { PseudoVMOR_MM_M4, VMOR_MM, 0x2, 0x0 }, // 5433
  { PseudoVMOR_MM_M8, VMOR_MM, 0x3, 0x0 }, // 5434
  { PseudoVMOR_MM_MF8, VMOR_MM, 0x5, 0x0 }, // 5435
  { PseudoVMOR_MM_MF4, VMOR_MM, 0x6, 0x0 }, // 5436
  { PseudoVMOR_MM_MF2, VMOR_MM, 0x7, 0x0 }, // 5437
  { PseudoVMSBC_VV_M1, VMSBC_VV, 0x0, 0x0 }, // 5438
  { PseudoVMSBC_VV_M2, VMSBC_VV, 0x1, 0x0 }, // 5439
  { PseudoVMSBC_VV_M4, VMSBC_VV, 0x2, 0x0 }, // 5440
  { PseudoVMSBC_VV_M8, VMSBC_VV, 0x3, 0x0 }, // 5441
  { PseudoVMSBC_VV_MF8, VMSBC_VV, 0x5, 0x0 }, // 5442
  { PseudoVMSBC_VV_MF4, VMSBC_VV, 0x6, 0x0 }, // 5443
  { PseudoVMSBC_VV_MF2, VMSBC_VV, 0x7, 0x0 }, // 5444
  { PseudoVMSBC_VVM_M1, VMSBC_VVM, 0x0, 0x0 }, // 5445
  { PseudoVMSBC_VVM_M2, VMSBC_VVM, 0x1, 0x0 }, // 5446
  { PseudoVMSBC_VVM_M4, VMSBC_VVM, 0x2, 0x0 }, // 5447
  { PseudoVMSBC_VVM_M8, VMSBC_VVM, 0x3, 0x0 }, // 5448
  { PseudoVMSBC_VVM_MF8, VMSBC_VVM, 0x5, 0x0 }, // 5449
  { PseudoVMSBC_VVM_MF4, VMSBC_VVM, 0x6, 0x0 }, // 5450
  { PseudoVMSBC_VVM_MF2, VMSBC_VVM, 0x7, 0x0 }, // 5451
  { PseudoVMSBC_VX_M1, VMSBC_VX, 0x0, 0x0 }, // 5452
  { PseudoVMSBC_VX_M2, VMSBC_VX, 0x1, 0x0 }, // 5453
  { PseudoVMSBC_VX_M4, VMSBC_VX, 0x2, 0x0 }, // 5454
  { PseudoVMSBC_VX_M8, VMSBC_VX, 0x3, 0x0 }, // 5455
  { PseudoVMSBC_VX_MF8, VMSBC_VX, 0x5, 0x0 }, // 5456
  { PseudoVMSBC_VX_MF4, VMSBC_VX, 0x6, 0x0 }, // 5457
  { PseudoVMSBC_VX_MF2, VMSBC_VX, 0x7, 0x0 }, // 5458
  { PseudoVMSBC_VXM_M1, VMSBC_VXM, 0x0, 0x0 }, // 5459
  { PseudoVMSBC_VXM_M2, VMSBC_VXM, 0x1, 0x0 }, // 5460
  { PseudoVMSBC_VXM_M4, VMSBC_VXM, 0x2, 0x0 }, // 5461
  { PseudoVMSBC_VXM_M8, VMSBC_VXM, 0x3, 0x0 }, // 5462
  { PseudoVMSBC_VXM_MF8, VMSBC_VXM, 0x5, 0x0 }, // 5463
  { PseudoVMSBC_VXM_MF4, VMSBC_VXM, 0x6, 0x0 }, // 5464
  { PseudoVMSBC_VXM_MF2, VMSBC_VXM, 0x7, 0x0 }, // 5465
  { PseudoVMSBF_M_B8, VMSBF_M, 0x0, 0x0 }, // 5466
  { PseudoVMSBF_M_B8_MASK, VMSBF_M, 0x0, 0x0 }, // 5467
  { PseudoVMSBF_M_B16, VMSBF_M, 0x1, 0x0 }, // 5468
  { PseudoVMSBF_M_B16_MASK, VMSBF_M, 0x1, 0x0 }, // 5469
  { PseudoVMSBF_M_B32, VMSBF_M, 0x2, 0x0 }, // 5470
  { PseudoVMSBF_M_B32_MASK, VMSBF_M, 0x2, 0x0 }, // 5471
  { PseudoVMSBF_M_B64, VMSBF_M, 0x3, 0x0 }, // 5472
  { PseudoVMSBF_M_B64_MASK, VMSBF_M, 0x3, 0x0 }, // 5473
  { PseudoVMSBF_M_B1, VMSBF_M, 0x5, 0x0 }, // 5474
  { PseudoVMSBF_M_B1_MASK, VMSBF_M, 0x5, 0x0 }, // 5475
  { PseudoVMSBF_M_B2, VMSBF_M, 0x6, 0x0 }, // 5476
  { PseudoVMSBF_M_B2_MASK, VMSBF_M, 0x6, 0x0 }, // 5477
  { PseudoVMSBF_M_B4, VMSBF_M, 0x7, 0x0 }, // 5478
  { PseudoVMSBF_M_B4_MASK, VMSBF_M, 0x7, 0x0 }, // 5479
  { PseudoVMSEQ_VI_M1, VMSEQ_VI, 0x0, 0x0 }, // 5480
  { PseudoVMSEQ_VI_M1_MASK, VMSEQ_VI, 0x0, 0x0 }, // 5481
  { PseudoVMSEQ_VI_M2, VMSEQ_VI, 0x1, 0x0 }, // 5482
  { PseudoVMSEQ_VI_M2_MASK, VMSEQ_VI, 0x1, 0x0 }, // 5483
  { PseudoVMSEQ_VI_M4, VMSEQ_VI, 0x2, 0x0 }, // 5484
  { PseudoVMSEQ_VI_M4_MASK, VMSEQ_VI, 0x2, 0x0 }, // 5485
  { PseudoVMSEQ_VI_M8, VMSEQ_VI, 0x3, 0x0 }, // 5486
  { PseudoVMSEQ_VI_M8_MASK, VMSEQ_VI, 0x3, 0x0 }, // 5487
  { PseudoVMSEQ_VI_MF8, VMSEQ_VI, 0x5, 0x0 }, // 5488
  { PseudoVMSEQ_VI_MF8_MASK, VMSEQ_VI, 0x5, 0x0 }, // 5489
  { PseudoVMSEQ_VI_MF4, VMSEQ_VI, 0x6, 0x0 }, // 5490
  { PseudoVMSEQ_VI_MF4_MASK, VMSEQ_VI, 0x6, 0x0 }, // 5491
  { PseudoVMSEQ_VI_MF2, VMSEQ_VI, 0x7, 0x0 }, // 5492
  { PseudoVMSEQ_VI_MF2_MASK, VMSEQ_VI, 0x7, 0x0 }, // 5493
  { PseudoVMSEQ_VV_M1, VMSEQ_VV, 0x0, 0x0 }, // 5494
  { PseudoVMSEQ_VV_M1_MASK, VMSEQ_VV, 0x0, 0x0 }, // 5495
  { PseudoVMSEQ_VV_M2, VMSEQ_VV, 0x1, 0x0 }, // 5496
  { PseudoVMSEQ_VV_M2_MASK, VMSEQ_VV, 0x1, 0x0 }, // 5497
  { PseudoVMSEQ_VV_M4, VMSEQ_VV, 0x2, 0x0 }, // 5498
  { PseudoVMSEQ_VV_M4_MASK, VMSEQ_VV, 0x2, 0x0 }, // 5499
  { PseudoVMSEQ_VV_M8, VMSEQ_VV, 0x3, 0x0 }, // 5500
  { PseudoVMSEQ_VV_M8_MASK, VMSEQ_VV, 0x3, 0x0 }, // 5501
  { PseudoVMSEQ_VV_MF8, VMSEQ_VV, 0x5, 0x0 }, // 5502
  { PseudoVMSEQ_VV_MF8_MASK, VMSEQ_VV, 0x5, 0x0 }, // 5503
  { PseudoVMSEQ_VV_MF4, VMSEQ_VV, 0x6, 0x0 }, // 5504
  { PseudoVMSEQ_VV_MF4_MASK, VMSEQ_VV, 0x6, 0x0 }, // 5505
  { PseudoVMSEQ_VV_MF2, VMSEQ_VV, 0x7, 0x0 }, // 5506
  { PseudoVMSEQ_VV_MF2_MASK, VMSEQ_VV, 0x7, 0x0 }, // 5507
  { PseudoVMSEQ_VX_M1, VMSEQ_VX, 0x0, 0x0 }, // 5508
  { PseudoVMSEQ_VX_M1_MASK, VMSEQ_VX, 0x0, 0x0 }, // 5509
  { PseudoVMSEQ_VX_M2, VMSEQ_VX, 0x1, 0x0 }, // 5510
  { PseudoVMSEQ_VX_M2_MASK, VMSEQ_VX, 0x1, 0x0 }, // 5511
  { PseudoVMSEQ_VX_M4, VMSEQ_VX, 0x2, 0x0 }, // 5512
  { PseudoVMSEQ_VX_M4_MASK, VMSEQ_VX, 0x2, 0x0 }, // 5513
  { PseudoVMSEQ_VX_M8, VMSEQ_VX, 0x3, 0x0 }, // 5514
  { PseudoVMSEQ_VX_M8_MASK, VMSEQ_VX, 0x3, 0x0 }, // 5515
  { PseudoVMSEQ_VX_MF8, VMSEQ_VX, 0x5, 0x0 }, // 5516
  { PseudoVMSEQ_VX_MF8_MASK, VMSEQ_VX, 0x5, 0x0 }, // 5517
  { PseudoVMSEQ_VX_MF4, VMSEQ_VX, 0x6, 0x0 }, // 5518
  { PseudoVMSEQ_VX_MF4_MASK, VMSEQ_VX, 0x6, 0x0 }, // 5519
  { PseudoVMSEQ_VX_MF2, VMSEQ_VX, 0x7, 0x0 }, // 5520
  { PseudoVMSEQ_VX_MF2_MASK, VMSEQ_VX, 0x7, 0x0 }, // 5521
  { PseudoVMSGTU_VI_M1, VMSGTU_VI, 0x0, 0x0 }, // 5522
  { PseudoVMSGTU_VI_M1_MASK, VMSGTU_VI, 0x0, 0x0 }, // 5523
  { PseudoVMSGTU_VI_M2, VMSGTU_VI, 0x1, 0x0 }, // 5524
  { PseudoVMSGTU_VI_M2_MASK, VMSGTU_VI, 0x1, 0x0 }, // 5525
  { PseudoVMSGTU_VI_M4, VMSGTU_VI, 0x2, 0x0 }, // 5526
  { PseudoVMSGTU_VI_M4_MASK, VMSGTU_VI, 0x2, 0x0 }, // 5527
  { PseudoVMSGTU_VI_M8, VMSGTU_VI, 0x3, 0x0 }, // 5528
  { PseudoVMSGTU_VI_M8_MASK, VMSGTU_VI, 0x3, 0x0 }, // 5529
  { PseudoVMSGTU_VI_MF8, VMSGTU_VI, 0x5, 0x0 }, // 5530
  { PseudoVMSGTU_VI_MF8_MASK, VMSGTU_VI, 0x5, 0x0 }, // 5531
  { PseudoVMSGTU_VI_MF4, VMSGTU_VI, 0x6, 0x0 }, // 5532
  { PseudoVMSGTU_VI_MF4_MASK, VMSGTU_VI, 0x6, 0x0 }, // 5533
  { PseudoVMSGTU_VI_MF2, VMSGTU_VI, 0x7, 0x0 }, // 5534
  { PseudoVMSGTU_VI_MF2_MASK, VMSGTU_VI, 0x7, 0x0 }, // 5535
  { PseudoVMSGTU_VX_M1, VMSGTU_VX, 0x0, 0x0 }, // 5536
  { PseudoVMSGTU_VX_M1_MASK, VMSGTU_VX, 0x0, 0x0 }, // 5537
  { PseudoVMSGTU_VX_M2, VMSGTU_VX, 0x1, 0x0 }, // 5538
  { PseudoVMSGTU_VX_M2_MASK, VMSGTU_VX, 0x1, 0x0 }, // 5539
  { PseudoVMSGTU_VX_M4, VMSGTU_VX, 0x2, 0x0 }, // 5540
  { PseudoVMSGTU_VX_M4_MASK, VMSGTU_VX, 0x2, 0x0 }, // 5541
  { PseudoVMSGTU_VX_M8, VMSGTU_VX, 0x3, 0x0 }, // 5542
  { PseudoVMSGTU_VX_M8_MASK, VMSGTU_VX, 0x3, 0x0 }, // 5543
  { PseudoVMSGTU_VX_MF8, VMSGTU_VX, 0x5, 0x0 }, // 5544
  { PseudoVMSGTU_VX_MF8_MASK, VMSGTU_VX, 0x5, 0x0 }, // 5545
  { PseudoVMSGTU_VX_MF4, VMSGTU_VX, 0x6, 0x0 }, // 5546
  { PseudoVMSGTU_VX_MF4_MASK, VMSGTU_VX, 0x6, 0x0 }, // 5547
  { PseudoVMSGTU_VX_MF2, VMSGTU_VX, 0x7, 0x0 }, // 5548
  { PseudoVMSGTU_VX_MF2_MASK, VMSGTU_VX, 0x7, 0x0 }, // 5549
  { PseudoVMSGT_VI_M1, VMSGT_VI, 0x0, 0x0 }, // 5550
  { PseudoVMSGT_VI_M1_MASK, VMSGT_VI, 0x0, 0x0 }, // 5551
  { PseudoVMSGT_VI_M2, VMSGT_VI, 0x1, 0x0 }, // 5552
  { PseudoVMSGT_VI_M2_MASK, VMSGT_VI, 0x1, 0x0 }, // 5553
  { PseudoVMSGT_VI_M4, VMSGT_VI, 0x2, 0x0 }, // 5554
  { PseudoVMSGT_VI_M4_MASK, VMSGT_VI, 0x2, 0x0 }, // 5555
  { PseudoVMSGT_VI_M8, VMSGT_VI, 0x3, 0x0 }, // 5556
  { PseudoVMSGT_VI_M8_MASK, VMSGT_VI, 0x3, 0x0 }, // 5557
  { PseudoVMSGT_VI_MF8, VMSGT_VI, 0x5, 0x0 }, // 5558
  { PseudoVMSGT_VI_MF8_MASK, VMSGT_VI, 0x5, 0x0 }, // 5559
  { PseudoVMSGT_VI_MF4, VMSGT_VI, 0x6, 0x0 }, // 5560
  { PseudoVMSGT_VI_MF4_MASK, VMSGT_VI, 0x6, 0x0 }, // 5561
  { PseudoVMSGT_VI_MF2, VMSGT_VI, 0x7, 0x0 }, // 5562
  { PseudoVMSGT_VI_MF2_MASK, VMSGT_VI, 0x7, 0x0 }, // 5563
  { PseudoVMSGT_VX_M1, VMSGT_VX, 0x0, 0x0 }, // 5564
  { PseudoVMSGT_VX_M1_MASK, VMSGT_VX, 0x0, 0x0 }, // 5565
  { PseudoVMSGT_VX_M2, VMSGT_VX, 0x1, 0x0 }, // 5566
  { PseudoVMSGT_VX_M2_MASK, VMSGT_VX, 0x1, 0x0 }, // 5567
  { PseudoVMSGT_VX_M4, VMSGT_VX, 0x2, 0x0 }, // 5568
  { PseudoVMSGT_VX_M4_MASK, VMSGT_VX, 0x2, 0x0 }, // 5569
  { PseudoVMSGT_VX_M8, VMSGT_VX, 0x3, 0x0 }, // 5570
  { PseudoVMSGT_VX_M8_MASK, VMSGT_VX, 0x3, 0x0 }, // 5571
  { PseudoVMSGT_VX_MF8, VMSGT_VX, 0x5, 0x0 }, // 5572
  { PseudoVMSGT_VX_MF8_MASK, VMSGT_VX, 0x5, 0x0 }, // 5573
  { PseudoVMSGT_VX_MF4, VMSGT_VX, 0x6, 0x0 }, // 5574
  { PseudoVMSGT_VX_MF4_MASK, VMSGT_VX, 0x6, 0x0 }, // 5575
  { PseudoVMSGT_VX_MF2, VMSGT_VX, 0x7, 0x0 }, // 5576
  { PseudoVMSGT_VX_MF2_MASK, VMSGT_VX, 0x7, 0x0 }, // 5577
  { PseudoVMSIF_M_B8, VMSIF_M, 0x0, 0x0 }, // 5578
  { PseudoVMSIF_M_B8_MASK, VMSIF_M, 0x0, 0x0 }, // 5579
  { PseudoVMSIF_M_B16, VMSIF_M, 0x1, 0x0 }, // 5580
  { PseudoVMSIF_M_B16_MASK, VMSIF_M, 0x1, 0x0 }, // 5581
  { PseudoVMSIF_M_B32, VMSIF_M, 0x2, 0x0 }, // 5582
  { PseudoVMSIF_M_B32_MASK, VMSIF_M, 0x2, 0x0 }, // 5583
  { PseudoVMSIF_M_B64, VMSIF_M, 0x3, 0x0 }, // 5584
  { PseudoVMSIF_M_B64_MASK, VMSIF_M, 0x3, 0x0 }, // 5585
  { PseudoVMSIF_M_B1, VMSIF_M, 0x5, 0x0 }, // 5586
  { PseudoVMSIF_M_B1_MASK, VMSIF_M, 0x5, 0x0 }, // 5587
  { PseudoVMSIF_M_B2, VMSIF_M, 0x6, 0x0 }, // 5588
  { PseudoVMSIF_M_B2_MASK, VMSIF_M, 0x6, 0x0 }, // 5589
  { PseudoVMSIF_M_B4, VMSIF_M, 0x7, 0x0 }, // 5590
  { PseudoVMSIF_M_B4_MASK, VMSIF_M, 0x7, 0x0 }, // 5591
  { PseudoVMSLEU_VI_M1, VMSLEU_VI, 0x0, 0x0 }, // 5592
  { PseudoVMSLEU_VI_M1_MASK, VMSLEU_VI, 0x0, 0x0 }, // 5593
  { PseudoVMSLEU_VI_M2, VMSLEU_VI, 0x1, 0x0 }, // 5594
  { PseudoVMSLEU_VI_M2_MASK, VMSLEU_VI, 0x1, 0x0 }, // 5595
  { PseudoVMSLEU_VI_M4, VMSLEU_VI, 0x2, 0x0 }, // 5596
  { PseudoVMSLEU_VI_M4_MASK, VMSLEU_VI, 0x2, 0x0 }, // 5597
  { PseudoVMSLEU_VI_M8, VMSLEU_VI, 0x3, 0x0 }, // 5598
  { PseudoVMSLEU_VI_M8_MASK, VMSLEU_VI, 0x3, 0x0 }, // 5599
  { PseudoVMSLEU_VI_MF8, VMSLEU_VI, 0x5, 0x0 }, // 5600
  { PseudoVMSLEU_VI_MF8_MASK, VMSLEU_VI, 0x5, 0x0 }, // 5601
  { PseudoVMSLEU_VI_MF4, VMSLEU_VI, 0x6, 0x0 }, // 5602
  { PseudoVMSLEU_VI_MF4_MASK, VMSLEU_VI, 0x6, 0x0 }, // 5603
  { PseudoVMSLEU_VI_MF2, VMSLEU_VI, 0x7, 0x0 }, // 5604
  { PseudoVMSLEU_VI_MF2_MASK, VMSLEU_VI, 0x7, 0x0 }, // 5605
  { PseudoVMSLEU_VV_M1, VMSLEU_VV, 0x0, 0x0 }, // 5606
  { PseudoVMSLEU_VV_M1_MASK, VMSLEU_VV, 0x0, 0x0 }, // 5607
  { PseudoVMSLEU_VV_M2, VMSLEU_VV, 0x1, 0x0 }, // 5608
  { PseudoVMSLEU_VV_M2_MASK, VMSLEU_VV, 0x1, 0x0 }, // 5609
  { PseudoVMSLEU_VV_M4, VMSLEU_VV, 0x2, 0x0 }, // 5610
  { PseudoVMSLEU_VV_M4_MASK, VMSLEU_VV, 0x2, 0x0 }, // 5611
  { PseudoVMSLEU_VV_M8, VMSLEU_VV, 0x3, 0x0 }, // 5612
  { PseudoVMSLEU_VV_M8_MASK, VMSLEU_VV, 0x3, 0x0 }, // 5613
  { PseudoVMSLEU_VV_MF8, VMSLEU_VV, 0x5, 0x0 }, // 5614
  { PseudoVMSLEU_VV_MF8_MASK, VMSLEU_VV, 0x5, 0x0 }, // 5615
  { PseudoVMSLEU_VV_MF4, VMSLEU_VV, 0x6, 0x0 }, // 5616
  { PseudoVMSLEU_VV_MF4_MASK, VMSLEU_VV, 0x6, 0x0 }, // 5617
  { PseudoVMSLEU_VV_MF2, VMSLEU_VV, 0x7, 0x0 }, // 5618
  { PseudoVMSLEU_VV_MF2_MASK, VMSLEU_VV, 0x7, 0x0 }, // 5619
  { PseudoVMSLEU_VX_M1, VMSLEU_VX, 0x0, 0x0 }, // 5620
  { PseudoVMSLEU_VX_M1_MASK, VMSLEU_VX, 0x0, 0x0 }, // 5621
  { PseudoVMSLEU_VX_M2, VMSLEU_VX, 0x1, 0x0 }, // 5622
  { PseudoVMSLEU_VX_M2_MASK, VMSLEU_VX, 0x1, 0x0 }, // 5623
  { PseudoVMSLEU_VX_M4, VMSLEU_VX, 0x2, 0x0 }, // 5624
  { PseudoVMSLEU_VX_M4_MASK, VMSLEU_VX, 0x2, 0x0 }, // 5625
  { PseudoVMSLEU_VX_M8, VMSLEU_VX, 0x3, 0x0 }, // 5626
  { PseudoVMSLEU_VX_M8_MASK, VMSLEU_VX, 0x3, 0x0 }, // 5627
  { PseudoVMSLEU_VX_MF8, VMSLEU_VX, 0x5, 0x0 }, // 5628
  { PseudoVMSLEU_VX_MF8_MASK, VMSLEU_VX, 0x5, 0x0 }, // 5629
  { PseudoVMSLEU_VX_MF4, VMSLEU_VX, 0x6, 0x0 }, // 5630
  { PseudoVMSLEU_VX_MF4_MASK, VMSLEU_VX, 0x6, 0x0 }, // 5631
  { PseudoVMSLEU_VX_MF2, VMSLEU_VX, 0x7, 0x0 }, // 5632
  { PseudoVMSLEU_VX_MF2_MASK, VMSLEU_VX, 0x7, 0x0 }, // 5633
  { PseudoVMSLE_VI_M1, VMSLE_VI, 0x0, 0x0 }, // 5634
  { PseudoVMSLE_VI_M1_MASK, VMSLE_VI, 0x0, 0x0 }, // 5635
  { PseudoVMSLE_VI_M2, VMSLE_VI, 0x1, 0x0 }, // 5636
  { PseudoVMSLE_VI_M2_MASK, VMSLE_VI, 0x1, 0x0 }, // 5637
  { PseudoVMSLE_VI_M4, VMSLE_VI, 0x2, 0x0 }, // 5638
  { PseudoVMSLE_VI_M4_MASK, VMSLE_VI, 0x2, 0x0 }, // 5639
  { PseudoVMSLE_VI_M8, VMSLE_VI, 0x3, 0x0 }, // 5640
  { PseudoVMSLE_VI_M8_MASK, VMSLE_VI, 0x3, 0x0 }, // 5641
  { PseudoVMSLE_VI_MF8, VMSLE_VI, 0x5, 0x0 }, // 5642
  { PseudoVMSLE_VI_MF8_MASK, VMSLE_VI, 0x5, 0x0 }, // 5643
  { PseudoVMSLE_VI_MF4, VMSLE_VI, 0x6, 0x0 }, // 5644
  { PseudoVMSLE_VI_MF4_MASK, VMSLE_VI, 0x6, 0x0 }, // 5645
  { PseudoVMSLE_VI_MF2, VMSLE_VI, 0x7, 0x0 }, // 5646
  { PseudoVMSLE_VI_MF2_MASK, VMSLE_VI, 0x7, 0x0 }, // 5647
  { PseudoVMSLE_VV_M1, VMSLE_VV, 0x0, 0x0 }, // 5648
  { PseudoVMSLE_VV_M1_MASK, VMSLE_VV, 0x0, 0x0 }, // 5649
  { PseudoVMSLE_VV_M2, VMSLE_VV, 0x1, 0x0 }, // 5650
  { PseudoVMSLE_VV_M2_MASK, VMSLE_VV, 0x1, 0x0 }, // 5651
  { PseudoVMSLE_VV_M4, VMSLE_VV, 0x2, 0x0 }, // 5652
  { PseudoVMSLE_VV_M4_MASK, VMSLE_VV, 0x2, 0x0 }, // 5653
  { PseudoVMSLE_VV_M8, VMSLE_VV, 0x3, 0x0 }, // 5654
  { PseudoVMSLE_VV_M8_MASK, VMSLE_VV, 0x3, 0x0 }, // 5655
  { PseudoVMSLE_VV_MF8, VMSLE_VV, 0x5, 0x0 }, // 5656
  { PseudoVMSLE_VV_MF8_MASK, VMSLE_VV, 0x5, 0x0 }, // 5657
  { PseudoVMSLE_VV_MF4, VMSLE_VV, 0x6, 0x0 }, // 5658
  { PseudoVMSLE_VV_MF4_MASK, VMSLE_VV, 0x6, 0x0 }, // 5659
  { PseudoVMSLE_VV_MF2, VMSLE_VV, 0x7, 0x0 }, // 5660
  { PseudoVMSLE_VV_MF2_MASK, VMSLE_VV, 0x7, 0x0 }, // 5661
  { PseudoVMSLE_VX_M1, VMSLE_VX, 0x0, 0x0 }, // 5662
  { PseudoVMSLE_VX_M1_MASK, VMSLE_VX, 0x0, 0x0 }, // 5663
  { PseudoVMSLE_VX_M2, VMSLE_VX, 0x1, 0x0 }, // 5664
  { PseudoVMSLE_VX_M2_MASK, VMSLE_VX, 0x1, 0x0 }, // 5665
  { PseudoVMSLE_VX_M4, VMSLE_VX, 0x2, 0x0 }, // 5666
  { PseudoVMSLE_VX_M4_MASK, VMSLE_VX, 0x2, 0x0 }, // 5667
  { PseudoVMSLE_VX_M8, VMSLE_VX, 0x3, 0x0 }, // 5668
  { PseudoVMSLE_VX_M8_MASK, VMSLE_VX, 0x3, 0x0 }, // 5669
  { PseudoVMSLE_VX_MF8, VMSLE_VX, 0x5, 0x0 }, // 5670
  { PseudoVMSLE_VX_MF8_MASK, VMSLE_VX, 0x5, 0x0 }, // 5671
  { PseudoVMSLE_VX_MF4, VMSLE_VX, 0x6, 0x0 }, // 5672
  { PseudoVMSLE_VX_MF4_MASK, VMSLE_VX, 0x6, 0x0 }, // 5673
  { PseudoVMSLE_VX_MF2, VMSLE_VX, 0x7, 0x0 }, // 5674
  { PseudoVMSLE_VX_MF2_MASK, VMSLE_VX, 0x7, 0x0 }, // 5675
  { PseudoVMSLTU_VV_M1, VMSLTU_VV, 0x0, 0x0 }, // 5676
  { PseudoVMSLTU_VV_M1_MASK, VMSLTU_VV, 0x0, 0x0 }, // 5677
  { PseudoVMSLTU_VV_M2, VMSLTU_VV, 0x1, 0x0 }, // 5678
  { PseudoVMSLTU_VV_M2_MASK, VMSLTU_VV, 0x1, 0x0 }, // 5679
  { PseudoVMSLTU_VV_M4, VMSLTU_VV, 0x2, 0x0 }, // 5680
  { PseudoVMSLTU_VV_M4_MASK, VMSLTU_VV, 0x2, 0x0 }, // 5681
  { PseudoVMSLTU_VV_M8, VMSLTU_VV, 0x3, 0x0 }, // 5682
  { PseudoVMSLTU_VV_M8_MASK, VMSLTU_VV, 0x3, 0x0 }, // 5683
  { PseudoVMSLTU_VV_MF8, VMSLTU_VV, 0x5, 0x0 }, // 5684
  { PseudoVMSLTU_VV_MF8_MASK, VMSLTU_VV, 0x5, 0x0 }, // 5685
  { PseudoVMSLTU_VV_MF4, VMSLTU_VV, 0x6, 0x0 }, // 5686
  { PseudoVMSLTU_VV_MF4_MASK, VMSLTU_VV, 0x6, 0x0 }, // 5687
  { PseudoVMSLTU_VV_MF2, VMSLTU_VV, 0x7, 0x0 }, // 5688
  { PseudoVMSLTU_VV_MF2_MASK, VMSLTU_VV, 0x7, 0x0 }, // 5689
  { PseudoVMSLTU_VX_M1, VMSLTU_VX, 0x0, 0x0 }, // 5690
  { PseudoVMSLTU_VX_M1_MASK, VMSLTU_VX, 0x0, 0x0 }, // 5691
  { PseudoVMSLTU_VX_M2, VMSLTU_VX, 0x1, 0x0 }, // 5692
  { PseudoVMSLTU_VX_M2_MASK, VMSLTU_VX, 0x1, 0x0 }, // 5693
  { PseudoVMSLTU_VX_M4, VMSLTU_VX, 0x2, 0x0 }, // 5694
  { PseudoVMSLTU_VX_M4_MASK, VMSLTU_VX, 0x2, 0x0 }, // 5695
  { PseudoVMSLTU_VX_M8, VMSLTU_VX, 0x3, 0x0 }, // 5696
  { PseudoVMSLTU_VX_M8_MASK, VMSLTU_VX, 0x3, 0x0 }, // 5697
  { PseudoVMSLTU_VX_MF8, VMSLTU_VX, 0x5, 0x0 }, // 5698
  { PseudoVMSLTU_VX_MF8_MASK, VMSLTU_VX, 0x5, 0x0 }, // 5699
  { PseudoVMSLTU_VX_MF4, VMSLTU_VX, 0x6, 0x0 }, // 5700
  { PseudoVMSLTU_VX_MF4_MASK, VMSLTU_VX, 0x6, 0x0 }, // 5701
  { PseudoVMSLTU_VX_MF2, VMSLTU_VX, 0x7, 0x0 }, // 5702
  { PseudoVMSLTU_VX_MF2_MASK, VMSLTU_VX, 0x7, 0x0 }, // 5703
  { PseudoVMSLT_VV_M1, VMSLT_VV, 0x0, 0x0 }, // 5704
  { PseudoVMSLT_VV_M1_MASK, VMSLT_VV, 0x0, 0x0 }, // 5705
  { PseudoVMSLT_VV_M2, VMSLT_VV, 0x1, 0x0 }, // 5706
  { PseudoVMSLT_VV_M2_MASK, VMSLT_VV, 0x1, 0x0 }, // 5707
  { PseudoVMSLT_VV_M4, VMSLT_VV, 0x2, 0x0 }, // 5708
  { PseudoVMSLT_VV_M4_MASK, VMSLT_VV, 0x2, 0x0 }, // 5709
  { PseudoVMSLT_VV_M8, VMSLT_VV, 0x3, 0x0 }, // 5710
  { PseudoVMSLT_VV_M8_MASK, VMSLT_VV, 0x3, 0x0 }, // 5711
  { PseudoVMSLT_VV_MF8, VMSLT_VV, 0x5, 0x0 }, // 5712
  { PseudoVMSLT_VV_MF8_MASK, VMSLT_VV, 0x5, 0x0 }, // 5713
  { PseudoVMSLT_VV_MF4, VMSLT_VV, 0x6, 0x0 }, // 5714
  { PseudoVMSLT_VV_MF4_MASK, VMSLT_VV, 0x6, 0x0 }, // 5715
  { PseudoVMSLT_VV_MF2, VMSLT_VV, 0x7, 0x0 }, // 5716
  { PseudoVMSLT_VV_MF2_MASK, VMSLT_VV, 0x7, 0x0 }, // 5717
  { PseudoVMSLT_VX_M1, VMSLT_VX, 0x0, 0x0 }, // 5718
  { PseudoVMSLT_VX_M1_MASK, VMSLT_VX, 0x0, 0x0 }, // 5719
  { PseudoVMSLT_VX_M2, VMSLT_VX, 0x1, 0x0 }, // 5720
  { PseudoVMSLT_VX_M2_MASK, VMSLT_VX, 0x1, 0x0 }, // 5721
  { PseudoVMSLT_VX_M4, VMSLT_VX, 0x2, 0x0 }, // 5722
  { PseudoVMSLT_VX_M4_MASK, VMSLT_VX, 0x2, 0x0 }, // 5723
  { PseudoVMSLT_VX_M8, VMSLT_VX, 0x3, 0x0 }, // 5724
  { PseudoVMSLT_VX_M8_MASK, VMSLT_VX, 0x3, 0x0 }, // 5725
  { PseudoVMSLT_VX_MF8, VMSLT_VX, 0x5, 0x0 }, // 5726
  { PseudoVMSLT_VX_MF8_MASK, VMSLT_VX, 0x5, 0x0 }, // 5727
  { PseudoVMSLT_VX_MF4, VMSLT_VX, 0x6, 0x0 }, // 5728
  { PseudoVMSLT_VX_MF4_MASK, VMSLT_VX, 0x6, 0x0 }, // 5729
  { PseudoVMSLT_VX_MF2, VMSLT_VX, 0x7, 0x0 }, // 5730
  { PseudoVMSLT_VX_MF2_MASK, VMSLT_VX, 0x7, 0x0 }, // 5731
  { PseudoVMSNE_VI_M1, VMSNE_VI, 0x0, 0x0 }, // 5732
  { PseudoVMSNE_VI_M1_MASK, VMSNE_VI, 0x0, 0x0 }, // 5733
  { PseudoVMSNE_VI_M2, VMSNE_VI, 0x1, 0x0 }, // 5734
  { PseudoVMSNE_VI_M2_MASK, VMSNE_VI, 0x1, 0x0 }, // 5735
  { PseudoVMSNE_VI_M4, VMSNE_VI, 0x2, 0x0 }, // 5736
  { PseudoVMSNE_VI_M4_MASK, VMSNE_VI, 0x2, 0x0 }, // 5737
  { PseudoVMSNE_VI_M8, VMSNE_VI, 0x3, 0x0 }, // 5738
  { PseudoVMSNE_VI_M8_MASK, VMSNE_VI, 0x3, 0x0 }, // 5739
  { PseudoVMSNE_VI_MF8, VMSNE_VI, 0x5, 0x0 }, // 5740
  { PseudoVMSNE_VI_MF8_MASK, VMSNE_VI, 0x5, 0x0 }, // 5741
  { PseudoVMSNE_VI_MF4, VMSNE_VI, 0x6, 0x0 }, // 5742
  { PseudoVMSNE_VI_MF4_MASK, VMSNE_VI, 0x6, 0x0 }, // 5743
  { PseudoVMSNE_VI_MF2, VMSNE_VI, 0x7, 0x0 }, // 5744
  { PseudoVMSNE_VI_MF2_MASK, VMSNE_VI, 0x7, 0x0 }, // 5745
  { PseudoVMSNE_VV_M1, VMSNE_VV, 0x0, 0x0 }, // 5746
  { PseudoVMSNE_VV_M1_MASK, VMSNE_VV, 0x0, 0x0 }, // 5747
  { PseudoVMSNE_VV_M2, VMSNE_VV, 0x1, 0x0 }, // 5748
  { PseudoVMSNE_VV_M2_MASK, VMSNE_VV, 0x1, 0x0 }, // 5749
  { PseudoVMSNE_VV_M4, VMSNE_VV, 0x2, 0x0 }, // 5750
  { PseudoVMSNE_VV_M4_MASK, VMSNE_VV, 0x2, 0x0 }, // 5751
  { PseudoVMSNE_VV_M8, VMSNE_VV, 0x3, 0x0 }, // 5752
  { PseudoVMSNE_VV_M8_MASK, VMSNE_VV, 0x3, 0x0 }, // 5753
  { PseudoVMSNE_VV_MF8, VMSNE_VV, 0x5, 0x0 }, // 5754
  { PseudoVMSNE_VV_MF8_MASK, VMSNE_VV, 0x5, 0x0 }, // 5755
  { PseudoVMSNE_VV_MF4, VMSNE_VV, 0x6, 0x0 }, // 5756
  { PseudoVMSNE_VV_MF4_MASK, VMSNE_VV, 0x6, 0x0 }, // 5757
  { PseudoVMSNE_VV_MF2, VMSNE_VV, 0x7, 0x0 }, // 5758
  { PseudoVMSNE_VV_MF2_MASK, VMSNE_VV, 0x7, 0x0 }, // 5759
  { PseudoVMSNE_VX_M1, VMSNE_VX, 0x0, 0x0 }, // 5760
  { PseudoVMSNE_VX_M1_MASK, VMSNE_VX, 0x0, 0x0 }, // 5761
  { PseudoVMSNE_VX_M2, VMSNE_VX, 0x1, 0x0 }, // 5762
  { PseudoVMSNE_VX_M2_MASK, VMSNE_VX, 0x1, 0x0 }, // 5763
  { PseudoVMSNE_VX_M4, VMSNE_VX, 0x2, 0x0 }, // 5764
  { PseudoVMSNE_VX_M4_MASK, VMSNE_VX, 0x2, 0x0 }, // 5765
  { PseudoVMSNE_VX_M8, VMSNE_VX, 0x3, 0x0 }, // 5766
  { PseudoVMSNE_VX_M8_MASK, VMSNE_VX, 0x3, 0x0 }, // 5767
  { PseudoVMSNE_VX_MF8, VMSNE_VX, 0x5, 0x0 }, // 5768
  { PseudoVMSNE_VX_MF8_MASK, VMSNE_VX, 0x5, 0x0 }, // 5769
  { PseudoVMSNE_VX_MF4, VMSNE_VX, 0x6, 0x0 }, // 5770
  { PseudoVMSNE_VX_MF4_MASK, VMSNE_VX, 0x6, 0x0 }, // 5771
  { PseudoVMSNE_VX_MF2, VMSNE_VX, 0x7, 0x0 }, // 5772
  { PseudoVMSNE_VX_MF2_MASK, VMSNE_VX, 0x7, 0x0 }, // 5773
  { PseudoVMSOF_M_B8, VMSOF_M, 0x0, 0x0 }, // 5774
  { PseudoVMSOF_M_B8_MASK, VMSOF_M, 0x0, 0x0 }, // 5775
  { PseudoVMSOF_M_B16, VMSOF_M, 0x1, 0x0 }, // 5776
  { PseudoVMSOF_M_B16_MASK, VMSOF_M, 0x1, 0x0 }, // 5777
  { PseudoVMSOF_M_B32, VMSOF_M, 0x2, 0x0 }, // 5778
  { PseudoVMSOF_M_B32_MASK, VMSOF_M, 0x2, 0x0 }, // 5779
  { PseudoVMSOF_M_B64, VMSOF_M, 0x3, 0x0 }, // 5780
  { PseudoVMSOF_M_B64_MASK, VMSOF_M, 0x3, 0x0 }, // 5781
  { PseudoVMSOF_M_B1, VMSOF_M, 0x5, 0x0 }, // 5782
  { PseudoVMSOF_M_B1_MASK, VMSOF_M, 0x5, 0x0 }, // 5783
  { PseudoVMSOF_M_B2, VMSOF_M, 0x6, 0x0 }, // 5784
  { PseudoVMSOF_M_B2_MASK, VMSOF_M, 0x6, 0x0 }, // 5785
  { PseudoVMSOF_M_B4, VMSOF_M, 0x7, 0x0 }, // 5786
  { PseudoVMSOF_M_B4_MASK, VMSOF_M, 0x7, 0x0 }, // 5787
  { PseudoVMULHSU_VV_M1, VMULHSU_VV, 0x0, 0x0 }, // 5788
  { PseudoVMULHSU_VV_M1_MASK, VMULHSU_VV, 0x0, 0x0 }, // 5789
  { PseudoVMULHSU_VV_M2, VMULHSU_VV, 0x1, 0x0 }, // 5790
  { PseudoVMULHSU_VV_M2_MASK, VMULHSU_VV, 0x1, 0x0 }, // 5791
  { PseudoVMULHSU_VV_M4, VMULHSU_VV, 0x2, 0x0 }, // 5792
  { PseudoVMULHSU_VV_M4_MASK, VMULHSU_VV, 0x2, 0x0 }, // 5793
  { PseudoVMULHSU_VV_M8, VMULHSU_VV, 0x3, 0x0 }, // 5794
  { PseudoVMULHSU_VV_M8_MASK, VMULHSU_VV, 0x3, 0x0 }, // 5795
  { PseudoVMULHSU_VV_MF8, VMULHSU_VV, 0x5, 0x0 }, // 5796
  { PseudoVMULHSU_VV_MF8_MASK, VMULHSU_VV, 0x5, 0x0 }, // 5797
  { PseudoVMULHSU_VV_MF4, VMULHSU_VV, 0x6, 0x0 }, // 5798
  { PseudoVMULHSU_VV_MF4_MASK, VMULHSU_VV, 0x6, 0x0 }, // 5799
  { PseudoVMULHSU_VV_MF2, VMULHSU_VV, 0x7, 0x0 }, // 5800
  { PseudoVMULHSU_VV_MF2_MASK, VMULHSU_VV, 0x7, 0x0 }, // 5801
  { PseudoVMULHSU_VX_M1, VMULHSU_VX, 0x0, 0x0 }, // 5802
  { PseudoVMULHSU_VX_M1_MASK, VMULHSU_VX, 0x0, 0x0 }, // 5803
  { PseudoVMULHSU_VX_M2, VMULHSU_VX, 0x1, 0x0 }, // 5804
  { PseudoVMULHSU_VX_M2_MASK, VMULHSU_VX, 0x1, 0x0 }, // 5805
  { PseudoVMULHSU_VX_M4, VMULHSU_VX, 0x2, 0x0 }, // 5806
  { PseudoVMULHSU_VX_M4_MASK, VMULHSU_VX, 0x2, 0x0 }, // 5807
  { PseudoVMULHSU_VX_M8, VMULHSU_VX, 0x3, 0x0 }, // 5808
  { PseudoVMULHSU_VX_M8_MASK, VMULHSU_VX, 0x3, 0x0 }, // 5809
  { PseudoVMULHSU_VX_MF8, VMULHSU_VX, 0x5, 0x0 }, // 5810
  { PseudoVMULHSU_VX_MF8_MASK, VMULHSU_VX, 0x5, 0x0 }, // 5811
  { PseudoVMULHSU_VX_MF4, VMULHSU_VX, 0x6, 0x0 }, // 5812
  { PseudoVMULHSU_VX_MF4_MASK, VMULHSU_VX, 0x6, 0x0 }, // 5813
  { PseudoVMULHSU_VX_MF2, VMULHSU_VX, 0x7, 0x0 }, // 5814
  { PseudoVMULHSU_VX_MF2_MASK, VMULHSU_VX, 0x7, 0x0 }, // 5815
  { PseudoVMULHU_VV_M1, VMULHU_VV, 0x0, 0x0 }, // 5816
  { PseudoVMULHU_VV_M1_MASK, VMULHU_VV, 0x0, 0x0 }, // 5817
  { PseudoVMULHU_VV_M2, VMULHU_VV, 0x1, 0x0 }, // 5818
  { PseudoVMULHU_VV_M2_MASK, VMULHU_VV, 0x1, 0x0 }, // 5819
  { PseudoVMULHU_VV_M4, VMULHU_VV, 0x2, 0x0 }, // 5820
  { PseudoVMULHU_VV_M4_MASK, VMULHU_VV, 0x2, 0x0 }, // 5821
  { PseudoVMULHU_VV_M8, VMULHU_VV, 0x3, 0x0 }, // 5822
  { PseudoVMULHU_VV_M8_MASK, VMULHU_VV, 0x3, 0x0 }, // 5823
  { PseudoVMULHU_VV_MF8, VMULHU_VV, 0x5, 0x0 }, // 5824
  { PseudoVMULHU_VV_MF8_MASK, VMULHU_VV, 0x5, 0x0 }, // 5825
  { PseudoVMULHU_VV_MF4, VMULHU_VV, 0x6, 0x0 }, // 5826
  { PseudoVMULHU_VV_MF4_MASK, VMULHU_VV, 0x6, 0x0 }, // 5827
  { PseudoVMULHU_VV_MF2, VMULHU_VV, 0x7, 0x0 }, // 5828
  { PseudoVMULHU_VV_MF2_MASK, VMULHU_VV, 0x7, 0x0 }, // 5829
  { PseudoVMULHU_VX_M1, VMULHU_VX, 0x0, 0x0 }, // 5830
  { PseudoVMULHU_VX_M1_MASK, VMULHU_VX, 0x0, 0x0 }, // 5831
  { PseudoVMULHU_VX_M2, VMULHU_VX, 0x1, 0x0 }, // 5832
  { PseudoVMULHU_VX_M2_MASK, VMULHU_VX, 0x1, 0x0 }, // 5833
  { PseudoVMULHU_VX_M4, VMULHU_VX, 0x2, 0x0 }, // 5834
  { PseudoVMULHU_VX_M4_MASK, VMULHU_VX, 0x2, 0x0 }, // 5835
  { PseudoVMULHU_VX_M8, VMULHU_VX, 0x3, 0x0 }, // 5836
  { PseudoVMULHU_VX_M8_MASK, VMULHU_VX, 0x3, 0x0 }, // 5837
  { PseudoVMULHU_VX_MF8, VMULHU_VX, 0x5, 0x0 }, // 5838
  { PseudoVMULHU_VX_MF8_MASK, VMULHU_VX, 0x5, 0x0 }, // 5839
  { PseudoVMULHU_VX_MF4, VMULHU_VX, 0x6, 0x0 }, // 5840
  { PseudoVMULHU_VX_MF4_MASK, VMULHU_VX, 0x6, 0x0 }, // 5841
  { PseudoVMULHU_VX_MF2, VMULHU_VX, 0x7, 0x0 }, // 5842
  { PseudoVMULHU_VX_MF2_MASK, VMULHU_VX, 0x7, 0x0 }, // 5843
  { PseudoVMULH_VV_M1, VMULH_VV, 0x0, 0x0 }, // 5844
  { PseudoVMULH_VV_M1_MASK, VMULH_VV, 0x0, 0x0 }, // 5845
  { PseudoVMULH_VV_M2, VMULH_VV, 0x1, 0x0 }, // 5846
  { PseudoVMULH_VV_M2_MASK, VMULH_VV, 0x1, 0x0 }, // 5847
  { PseudoVMULH_VV_M4, VMULH_VV, 0x2, 0x0 }, // 5848
  { PseudoVMULH_VV_M4_MASK, VMULH_VV, 0x2, 0x0 }, // 5849
  { PseudoVMULH_VV_M8, VMULH_VV, 0x3, 0x0 }, // 5850
  { PseudoVMULH_VV_M8_MASK, VMULH_VV, 0x3, 0x0 }, // 5851
  { PseudoVMULH_VV_MF8, VMULH_VV, 0x5, 0x0 }, // 5852
  { PseudoVMULH_VV_MF8_MASK, VMULH_VV, 0x5, 0x0 }, // 5853
  { PseudoVMULH_VV_MF4, VMULH_VV, 0x6, 0x0 }, // 5854
  { PseudoVMULH_VV_MF4_MASK, VMULH_VV, 0x6, 0x0 }, // 5855
  { PseudoVMULH_VV_MF2, VMULH_VV, 0x7, 0x0 }, // 5856
  { PseudoVMULH_VV_MF2_MASK, VMULH_VV, 0x7, 0x0 }, // 5857
  { PseudoVMULH_VX_M1, VMULH_VX, 0x0, 0x0 }, // 5858
  { PseudoVMULH_VX_M1_MASK, VMULH_VX, 0x0, 0x0 }, // 5859
  { PseudoVMULH_VX_M2, VMULH_VX, 0x1, 0x0 }, // 5860
  { PseudoVMULH_VX_M2_MASK, VMULH_VX, 0x1, 0x0 }, // 5861
  { PseudoVMULH_VX_M4, VMULH_VX, 0x2, 0x0 }, // 5862
  { PseudoVMULH_VX_M4_MASK, VMULH_VX, 0x2, 0x0 }, // 5863
  { PseudoVMULH_VX_M8, VMULH_VX, 0x3, 0x0 }, // 5864
  { PseudoVMULH_VX_M8_MASK, VMULH_VX, 0x3, 0x0 }, // 5865
  { PseudoVMULH_VX_MF8, VMULH_VX, 0x5, 0x0 }, // 5866
  { PseudoVMULH_VX_MF8_MASK, VMULH_VX, 0x5, 0x0 }, // 5867
  { PseudoVMULH_VX_MF4, VMULH_VX, 0x6, 0x0 }, // 5868
  { PseudoVMULH_VX_MF4_MASK, VMULH_VX, 0x6, 0x0 }, // 5869
  { PseudoVMULH_VX_MF2, VMULH_VX, 0x7, 0x0 }, // 5870
  { PseudoVMULH_VX_MF2_MASK, VMULH_VX, 0x7, 0x0 }, // 5871
  { PseudoVMUL_VV_M1, VMUL_VV, 0x0, 0x0 }, // 5872
  { PseudoVMUL_VV_M1_MASK, VMUL_VV, 0x0, 0x0 }, // 5873
  { PseudoVMUL_VV_M2, VMUL_VV, 0x1, 0x0 }, // 5874
  { PseudoVMUL_VV_M2_MASK, VMUL_VV, 0x1, 0x0 }, // 5875
  { PseudoVMUL_VV_M4, VMUL_VV, 0x2, 0x0 }, // 5876
  { PseudoVMUL_VV_M4_MASK, VMUL_VV, 0x2, 0x0 }, // 5877
  { PseudoVMUL_VV_M8, VMUL_VV, 0x3, 0x0 }, // 5878
  { PseudoVMUL_VV_M8_MASK, VMUL_VV, 0x3, 0x0 }, // 5879
  { PseudoVMUL_VV_MF8, VMUL_VV, 0x5, 0x0 }, // 5880
  { PseudoVMUL_VV_MF8_MASK, VMUL_VV, 0x5, 0x0 }, // 5881
  { PseudoVMUL_VV_MF4, VMUL_VV, 0x6, 0x0 }, // 5882
  { PseudoVMUL_VV_MF4_MASK, VMUL_VV, 0x6, 0x0 }, // 5883
  { PseudoVMUL_VV_MF2, VMUL_VV, 0x7, 0x0 }, // 5884
  { PseudoVMUL_VV_MF2_MASK, VMUL_VV, 0x7, 0x0 }, // 5885
  { PseudoVMUL_VX_M1, VMUL_VX, 0x0, 0x0 }, // 5886
  { PseudoVMUL_VX_M1_MASK, VMUL_VX, 0x0, 0x0 }, // 5887
  { PseudoVMUL_VX_M2, VMUL_VX, 0x1, 0x0 }, // 5888
  { PseudoVMUL_VX_M2_MASK, VMUL_VX, 0x1, 0x0 }, // 5889
  { PseudoVMUL_VX_M4, VMUL_VX, 0x2, 0x0 }, // 5890
  { PseudoVMUL_VX_M4_MASK, VMUL_VX, 0x2, 0x0 }, // 5891
  { PseudoVMUL_VX_M8, VMUL_VX, 0x3, 0x0 }, // 5892
  { PseudoVMUL_VX_M8_MASK, VMUL_VX, 0x3, 0x0 }, // 5893
  { PseudoVMUL_VX_MF8, VMUL_VX, 0x5, 0x0 }, // 5894
  { PseudoVMUL_VX_MF8_MASK, VMUL_VX, 0x5, 0x0 }, // 5895
  { PseudoVMUL_VX_MF4, VMUL_VX, 0x6, 0x0 }, // 5896
  { PseudoVMUL_VX_MF4_MASK, VMUL_VX, 0x6, 0x0 }, // 5897
  { PseudoVMUL_VX_MF2, VMUL_VX, 0x7, 0x0 }, // 5898
  { PseudoVMUL_VX_MF2_MASK, VMUL_VX, 0x7, 0x0 }, // 5899
  { PseudoVMV_S_X_M1, VMV_S_X, 0x0, 0x0 }, // 5900
  { PseudoVMV_S_X_M2, VMV_S_X, 0x1, 0x0 }, // 5901
  { PseudoVMV_S_X_M4, VMV_S_X, 0x2, 0x0 }, // 5902
  { PseudoVMV_S_X_M8, VMV_S_X, 0x3, 0x0 }, // 5903
  { PseudoVMV_S_X_MF8, VMV_S_X, 0x5, 0x0 }, // 5904
  { PseudoVMV_S_X_MF4, VMV_S_X, 0x6, 0x0 }, // 5905
  { PseudoVMV_S_X_MF2, VMV_S_X, 0x7, 0x0 }, // 5906
  { PseudoVMV_V_I_M1, VMV_V_I, 0x0, 0x0 }, // 5907
  { PseudoVMV_V_I_M2, VMV_V_I, 0x1, 0x0 }, // 5908
  { PseudoVMV_V_I_M4, VMV_V_I, 0x2, 0x0 }, // 5909
  { PseudoVMV_V_I_M8, VMV_V_I, 0x3, 0x0 }, // 5910
  { PseudoVMV_V_I_MF8, VMV_V_I, 0x5, 0x0 }, // 5911
  { PseudoVMV_V_I_MF4, VMV_V_I, 0x6, 0x0 }, // 5912
  { PseudoVMV_V_I_MF2, VMV_V_I, 0x7, 0x0 }, // 5913
  { PseudoVMV_V_V_M1, VMV_V_V, 0x0, 0x0 }, // 5914
  { PseudoVMV_V_V_M2, VMV_V_V, 0x1, 0x0 }, // 5915
  { PseudoVMV_V_V_M4, VMV_V_V, 0x2, 0x0 }, // 5916
  { PseudoVMV_V_V_M8, VMV_V_V, 0x3, 0x0 }, // 5917
  { PseudoVMV_V_V_MF8, VMV_V_V, 0x5, 0x0 }, // 5918
  { PseudoVMV_V_V_MF4, VMV_V_V, 0x6, 0x0 }, // 5919
  { PseudoVMV_V_V_MF2, VMV_V_V, 0x7, 0x0 }, // 5920
  { PseudoVMV_V_X_M1, VMV_V_X, 0x0, 0x0 }, // 5921
  { PseudoVMV_V_X_M2, VMV_V_X, 0x1, 0x0 }, // 5922
  { PseudoVMV_V_X_M4, VMV_V_X, 0x2, 0x0 }, // 5923
  { PseudoVMV_V_X_M8, VMV_V_X, 0x3, 0x0 }, // 5924
  { PseudoVMV_V_X_MF8, VMV_V_X, 0x5, 0x0 }, // 5925
  { PseudoVMV_V_X_MF4, VMV_V_X, 0x6, 0x0 }, // 5926
  { PseudoVMV_V_X_MF2, VMV_V_X, 0x7, 0x0 }, // 5927
  { PseudoVMV_X_S_M1, VMV_X_S, 0x0, 0x0 }, // 5928
  { PseudoVMV_X_S_M2, VMV_X_S, 0x1, 0x0 }, // 5929
  { PseudoVMV_X_S_M4, VMV_X_S, 0x2, 0x0 }, // 5930
  { PseudoVMV_X_S_M8, VMV_X_S, 0x3, 0x0 }, // 5931
  { PseudoVMV_X_S_MF8, VMV_X_S, 0x5, 0x0 }, // 5932
  { PseudoVMV_X_S_MF4, VMV_X_S, 0x6, 0x0 }, // 5933
  { PseudoVMV_X_S_MF2, VMV_X_S, 0x7, 0x0 }, // 5934
  { PseudoVMSET_M_B8, VMXNOR_MM, 0x0, 0x0 }, // 5935
  { PseudoVMXNOR_MM_M1, VMXNOR_MM, 0x0, 0x0 }, // 5936
  { PseudoVMSET_M_B16, VMXNOR_MM, 0x1, 0x0 }, // 5937
  { PseudoVMXNOR_MM_M2, VMXNOR_MM, 0x1, 0x0 }, // 5938
  { PseudoVMSET_M_B32, VMXNOR_MM, 0x2, 0x0 }, // 5939
  { PseudoVMXNOR_MM_M4, VMXNOR_MM, 0x2, 0x0 }, // 5940
  { PseudoVMSET_M_B64, VMXNOR_MM, 0x3, 0x0 }, // 5941
  { PseudoVMXNOR_MM_M8, VMXNOR_MM, 0x3, 0x0 }, // 5942
  { PseudoVMSET_M_B1, VMXNOR_MM, 0x5, 0x0 }, // 5943
  { PseudoVMXNOR_MM_MF8, VMXNOR_MM, 0x5, 0x0 }, // 5944
  { PseudoVMSET_M_B2, VMXNOR_MM, 0x6, 0x0 }, // 5945
  { PseudoVMXNOR_MM_MF4, VMXNOR_MM, 0x6, 0x0 }, // 5946
  { PseudoVMSET_M_B4, VMXNOR_MM, 0x7, 0x0 }, // 5947
  { PseudoVMXNOR_MM_MF2, VMXNOR_MM, 0x7, 0x0 }, // 5948
  { PseudoVMCLR_M_B8, VMXOR_MM, 0x0, 0x0 }, // 5949
  { PseudoVMXOR_MM_M1, VMXOR_MM, 0x0, 0x0 }, // 5950
  { PseudoVMCLR_M_B16, VMXOR_MM, 0x1, 0x0 }, // 5951
  { PseudoVMXOR_MM_M2, VMXOR_MM, 0x1, 0x0 }, // 5952
  { PseudoVMCLR_M_B32, VMXOR_MM, 0x2, 0x0 }, // 5953
  { PseudoVMXOR_MM_M4, VMXOR_MM, 0x2, 0x0 }, // 5954
  { PseudoVMCLR_M_B64, VMXOR_MM, 0x3, 0x0 }, // 5955
  { PseudoVMXOR_MM_M8, VMXOR_MM, 0x3, 0x0 }, // 5956
  { PseudoVMCLR_M_B1, VMXOR_MM, 0x5, 0x0 }, // 5957
  { PseudoVMXOR_MM_MF8, VMXOR_MM, 0x5, 0x0 }, // 5958
  { PseudoVMCLR_M_B2, VMXOR_MM, 0x6, 0x0 }, // 5959
  { PseudoVMXOR_MM_MF4, VMXOR_MM, 0x6, 0x0 }, // 5960
  { PseudoVMCLR_M_B4, VMXOR_MM, 0x7, 0x0 }, // 5961
  { PseudoVMXOR_MM_MF2, VMXOR_MM, 0x7, 0x0 }, // 5962
  { PseudoVNCLIPU_WI_M1, VNCLIPU_WI, 0x0, 0x0 }, // 5963
  { PseudoVNCLIPU_WI_M1_MASK, VNCLIPU_WI, 0x0, 0x0 }, // 5964
  { PseudoVNCLIPU_WI_M2, VNCLIPU_WI, 0x1, 0x0 }, // 5965
  { PseudoVNCLIPU_WI_M2_MASK, VNCLIPU_WI, 0x1, 0x0 }, // 5966
  { PseudoVNCLIPU_WI_M4, VNCLIPU_WI, 0x2, 0x0 }, // 5967
  { PseudoVNCLIPU_WI_M4_MASK, VNCLIPU_WI, 0x2, 0x0 }, // 5968
  { PseudoVNCLIPU_WI_MF8, VNCLIPU_WI, 0x5, 0x0 }, // 5969
  { PseudoVNCLIPU_WI_MF8_MASK, VNCLIPU_WI, 0x5, 0x0 }, // 5970
  { PseudoVNCLIPU_WI_MF4, VNCLIPU_WI, 0x6, 0x0 }, // 5971
  { PseudoVNCLIPU_WI_MF4_MASK, VNCLIPU_WI, 0x6, 0x0 }, // 5972
  { PseudoVNCLIPU_WI_MF2, VNCLIPU_WI, 0x7, 0x0 }, // 5973
  { PseudoVNCLIPU_WI_MF2_MASK, VNCLIPU_WI, 0x7, 0x0 }, // 5974
  { PseudoVNCLIPU_WV_M1, VNCLIPU_WV, 0x0, 0x0 }, // 5975
  { PseudoVNCLIPU_WV_M1_MASK, VNCLIPU_WV, 0x0, 0x0 }, // 5976
  { PseudoVNCLIPU_WV_M2, VNCLIPU_WV, 0x1, 0x0 }, // 5977
  { PseudoVNCLIPU_WV_M2_MASK, VNCLIPU_WV, 0x1, 0x0 }, // 5978
  { PseudoVNCLIPU_WV_M4, VNCLIPU_WV, 0x2, 0x0 }, // 5979
  { PseudoVNCLIPU_WV_M4_MASK, VNCLIPU_WV, 0x2, 0x0 }, // 5980
  { PseudoVNCLIPU_WV_MF8, VNCLIPU_WV, 0x5, 0x0 }, // 5981
  { PseudoVNCLIPU_WV_MF8_MASK, VNCLIPU_WV, 0x5, 0x0 }, // 5982
  { PseudoVNCLIPU_WV_MF4, VNCLIPU_WV, 0x6, 0x0 }, // 5983
  { PseudoVNCLIPU_WV_MF4_MASK, VNCLIPU_WV, 0x6, 0x0 }, // 5984
  { PseudoVNCLIPU_WV_MF2, VNCLIPU_WV, 0x7, 0x0 }, // 5985
  { PseudoVNCLIPU_WV_MF2_MASK, VNCLIPU_WV, 0x7, 0x0 }, // 5986
  { PseudoVNCLIPU_WX_M1, VNCLIPU_WX, 0x0, 0x0 }, // 5987
  { PseudoVNCLIPU_WX_M1_MASK, VNCLIPU_WX, 0x0, 0x0 }, // 5988
  { PseudoVNCLIPU_WX_M2, VNCLIPU_WX, 0x1, 0x0 }, // 5989
  { PseudoVNCLIPU_WX_M2_MASK, VNCLIPU_WX, 0x1, 0x0 }, // 5990
  { PseudoVNCLIPU_WX_M4, VNCLIPU_WX, 0x2, 0x0 }, // 5991
  { PseudoVNCLIPU_WX_M4_MASK, VNCLIPU_WX, 0x2, 0x0 }, // 5992
  { PseudoVNCLIPU_WX_MF8, VNCLIPU_WX, 0x5, 0x0 }, // 5993
  { PseudoVNCLIPU_WX_MF8_MASK, VNCLIPU_WX, 0x5, 0x0 }, // 5994
  { PseudoVNCLIPU_WX_MF4, VNCLIPU_WX, 0x6, 0x0 }, // 5995
  { PseudoVNCLIPU_WX_MF4_MASK, VNCLIPU_WX, 0x6, 0x0 }, // 5996
  { PseudoVNCLIPU_WX_MF2, VNCLIPU_WX, 0x7, 0x0 }, // 5997
  { PseudoVNCLIPU_WX_MF2_MASK, VNCLIPU_WX, 0x7, 0x0 }, // 5998
  { PseudoVNCLIP_WI_M1, VNCLIP_WI, 0x0, 0x0 }, // 5999
  { PseudoVNCLIP_WI_M1_MASK, VNCLIP_WI, 0x0, 0x0 }, // 6000
  { PseudoVNCLIP_WI_M2, VNCLIP_WI, 0x1, 0x0 }, // 6001
  { PseudoVNCLIP_WI_M2_MASK, VNCLIP_WI, 0x1, 0x0 }, // 6002
  { PseudoVNCLIP_WI_M4, VNCLIP_WI, 0x2, 0x0 }, // 6003
  { PseudoVNCLIP_WI_M4_MASK, VNCLIP_WI, 0x2, 0x0 }, // 6004
  { PseudoVNCLIP_WI_MF8, VNCLIP_WI, 0x5, 0x0 }, // 6005
  { PseudoVNCLIP_WI_MF8_MASK, VNCLIP_WI, 0x5, 0x0 }, // 6006
  { PseudoVNCLIP_WI_MF4, VNCLIP_WI, 0x6, 0x0 }, // 6007
  { PseudoVNCLIP_WI_MF4_MASK, VNCLIP_WI, 0x6, 0x0 }, // 6008
  { PseudoVNCLIP_WI_MF2, VNCLIP_WI, 0x7, 0x0 }, // 6009
  { PseudoVNCLIP_WI_MF2_MASK, VNCLIP_WI, 0x7, 0x0 }, // 6010
  { PseudoVNCLIP_WV_M1, VNCLIP_WV, 0x0, 0x0 }, // 6011
  { PseudoVNCLIP_WV_M1_MASK, VNCLIP_WV, 0x0, 0x0 }, // 6012
  { PseudoVNCLIP_WV_M2, VNCLIP_WV, 0x1, 0x0 }, // 6013
  { PseudoVNCLIP_WV_M2_MASK, VNCLIP_WV, 0x1, 0x0 }, // 6014
  { PseudoVNCLIP_WV_M4, VNCLIP_WV, 0x2, 0x0 }, // 6015
  { PseudoVNCLIP_WV_M4_MASK, VNCLIP_WV, 0x2, 0x0 }, // 6016
  { PseudoVNCLIP_WV_MF8, VNCLIP_WV, 0x5, 0x0 }, // 6017
  { PseudoVNCLIP_WV_MF8_MASK, VNCLIP_WV, 0x5, 0x0 }, // 6018
  { PseudoVNCLIP_WV_MF4, VNCLIP_WV, 0x6, 0x0 }, // 6019
  { PseudoVNCLIP_WV_MF4_MASK, VNCLIP_WV, 0x6, 0x0 }, // 6020
  { PseudoVNCLIP_WV_MF2, VNCLIP_WV, 0x7, 0x0 }, // 6021
  { PseudoVNCLIP_WV_MF2_MASK, VNCLIP_WV, 0x7, 0x0 }, // 6022
  { PseudoVNCLIP_WX_M1, VNCLIP_WX, 0x0, 0x0 }, // 6023
  { PseudoVNCLIP_WX_M1_MASK, VNCLIP_WX, 0x0, 0x0 }, // 6024
  { PseudoVNCLIP_WX_M2, VNCLIP_WX, 0x1, 0x0 }, // 6025
  { PseudoVNCLIP_WX_M2_MASK, VNCLIP_WX, 0x1, 0x0 }, // 6026
  { PseudoVNCLIP_WX_M4, VNCLIP_WX, 0x2, 0x0 }, // 6027
  { PseudoVNCLIP_WX_M4_MASK, VNCLIP_WX, 0x2, 0x0 }, // 6028
  { PseudoVNCLIP_WX_MF8, VNCLIP_WX, 0x5, 0x0 }, // 6029
  { PseudoVNCLIP_WX_MF8_MASK, VNCLIP_WX, 0x5, 0x0 }, // 6030
  { PseudoVNCLIP_WX_MF4, VNCLIP_WX, 0x6, 0x0 }, // 6031
  { PseudoVNCLIP_WX_MF4_MASK, VNCLIP_WX, 0x6, 0x0 }, // 6032
  { PseudoVNCLIP_WX_MF2, VNCLIP_WX, 0x7, 0x0 }, // 6033
  { PseudoVNCLIP_WX_MF2_MASK, VNCLIP_WX, 0x7, 0x0 }, // 6034
  { PseudoVNMSAC_VV_M1, VNMSAC_VV, 0x0, 0x0 }, // 6035
  { PseudoVNMSAC_VV_M1_MASK, VNMSAC_VV, 0x0, 0x0 }, // 6036
  { PseudoVNMSAC_VV_M2, VNMSAC_VV, 0x1, 0x0 }, // 6037
  { PseudoVNMSAC_VV_M2_MASK, VNMSAC_VV, 0x1, 0x0 }, // 6038
  { PseudoVNMSAC_VV_M4, VNMSAC_VV, 0x2, 0x0 }, // 6039
  { PseudoVNMSAC_VV_M4_MASK, VNMSAC_VV, 0x2, 0x0 }, // 6040
  { PseudoVNMSAC_VV_M8, VNMSAC_VV, 0x3, 0x0 }, // 6041
  { PseudoVNMSAC_VV_M8_MASK, VNMSAC_VV, 0x3, 0x0 }, // 6042
  { PseudoVNMSAC_VV_MF8, VNMSAC_VV, 0x5, 0x0 }, // 6043
  { PseudoVNMSAC_VV_MF8_MASK, VNMSAC_VV, 0x5, 0x0 }, // 6044
  { PseudoVNMSAC_VV_MF4, VNMSAC_VV, 0x6, 0x0 }, // 6045
  { PseudoVNMSAC_VV_MF4_MASK, VNMSAC_VV, 0x6, 0x0 }, // 6046
  { PseudoVNMSAC_VV_MF2, VNMSAC_VV, 0x7, 0x0 }, // 6047
  { PseudoVNMSAC_VV_MF2_MASK, VNMSAC_VV, 0x7, 0x0 }, // 6048
  { PseudoVNMSAC_VX_M1, VNMSAC_VX, 0x0, 0x0 }, // 6049
  { PseudoVNMSAC_VX_M1_MASK, VNMSAC_VX, 0x0, 0x0 }, // 6050
  { PseudoVNMSAC_VX_M2, VNMSAC_VX, 0x1, 0x0 }, // 6051
  { PseudoVNMSAC_VX_M2_MASK, VNMSAC_VX, 0x1, 0x0 }, // 6052
  { PseudoVNMSAC_VX_M4, VNMSAC_VX, 0x2, 0x0 }, // 6053
  { PseudoVNMSAC_VX_M4_MASK, VNMSAC_VX, 0x2, 0x0 }, // 6054
  { PseudoVNMSAC_VX_M8, VNMSAC_VX, 0x3, 0x0 }, // 6055
  { PseudoVNMSAC_VX_M8_MASK, VNMSAC_VX, 0x3, 0x0 }, // 6056
  { PseudoVNMSAC_VX_MF8, VNMSAC_VX, 0x5, 0x0 }, // 6057
  { PseudoVNMSAC_VX_MF8_MASK, VNMSAC_VX, 0x5, 0x0 }, // 6058
  { PseudoVNMSAC_VX_MF4, VNMSAC_VX, 0x6, 0x0 }, // 6059
  { PseudoVNMSAC_VX_MF4_MASK, VNMSAC_VX, 0x6, 0x0 }, // 6060
  { PseudoVNMSAC_VX_MF2, VNMSAC_VX, 0x7, 0x0 }, // 6061
  { PseudoVNMSAC_VX_MF2_MASK, VNMSAC_VX, 0x7, 0x0 }, // 6062
  { PseudoVNMSUB_VV_M1, VNMSUB_VV, 0x0, 0x0 }, // 6063
  { PseudoVNMSUB_VV_M1_MASK, VNMSUB_VV, 0x0, 0x0 }, // 6064
  { PseudoVNMSUB_VV_M2, VNMSUB_VV, 0x1, 0x0 }, // 6065
  { PseudoVNMSUB_VV_M2_MASK, VNMSUB_VV, 0x1, 0x0 }, // 6066
  { PseudoVNMSUB_VV_M4, VNMSUB_VV, 0x2, 0x0 }, // 6067
  { PseudoVNMSUB_VV_M4_MASK, VNMSUB_VV, 0x2, 0x0 }, // 6068
  { PseudoVNMSUB_VV_M8, VNMSUB_VV, 0x3, 0x0 }, // 6069
  { PseudoVNMSUB_VV_M8_MASK, VNMSUB_VV, 0x3, 0x0 }, // 6070
  { PseudoVNMSUB_VV_MF8, VNMSUB_VV, 0x5, 0x0 }, // 6071
  { PseudoVNMSUB_VV_MF8_MASK, VNMSUB_VV, 0x5, 0x0 }, // 6072
  { PseudoVNMSUB_VV_MF4, VNMSUB_VV, 0x6, 0x0 }, // 6073
  { PseudoVNMSUB_VV_MF4_MASK, VNMSUB_VV, 0x6, 0x0 }, // 6074
  { PseudoVNMSUB_VV_MF2, VNMSUB_VV, 0x7, 0x0 }, // 6075
  { PseudoVNMSUB_VV_MF2_MASK, VNMSUB_VV, 0x7, 0x0 }, // 6076
  { PseudoVNMSUB_VX_M1, VNMSUB_VX, 0x0, 0x0 }, // 6077
  { PseudoVNMSUB_VX_M1_MASK, VNMSUB_VX, 0x0, 0x0 }, // 6078
  { PseudoVNMSUB_VX_M2, VNMSUB_VX, 0x1, 0x0 }, // 6079
  { PseudoVNMSUB_VX_M2_MASK, VNMSUB_VX, 0x1, 0x0 }, // 6080
  { PseudoVNMSUB_VX_M4, VNMSUB_VX, 0x2, 0x0 }, // 6081
  { PseudoVNMSUB_VX_M4_MASK, VNMSUB_VX, 0x2, 0x0 }, // 6082
  { PseudoVNMSUB_VX_M8, VNMSUB_VX, 0x3, 0x0 }, // 6083
  { PseudoVNMSUB_VX_M8_MASK, VNMSUB_VX, 0x3, 0x0 }, // 6084
  { PseudoVNMSUB_VX_MF8, VNMSUB_VX, 0x5, 0x0 }, // 6085
  { PseudoVNMSUB_VX_MF8_MASK, VNMSUB_VX, 0x5, 0x0 }, // 6086
  { PseudoVNMSUB_VX_MF4, VNMSUB_VX, 0x6, 0x0 }, // 6087
  { PseudoVNMSUB_VX_MF4_MASK, VNMSUB_VX, 0x6, 0x0 }, // 6088
  { PseudoVNMSUB_VX_MF2, VNMSUB_VX, 0x7, 0x0 }, // 6089
  { PseudoVNMSUB_VX_MF2_MASK, VNMSUB_VX, 0x7, 0x0 }, // 6090
  { PseudoVNSRA_WI_M1, VNSRA_WI, 0x0, 0x0 }, // 6091
  { PseudoVNSRA_WI_M1_MASK, VNSRA_WI, 0x0, 0x0 }, // 6092
  { PseudoVNSRA_WI_M2, VNSRA_WI, 0x1, 0x0 }, // 6093
  { PseudoVNSRA_WI_M2_MASK, VNSRA_WI, 0x1, 0x0 }, // 6094
  { PseudoVNSRA_WI_M4, VNSRA_WI, 0x2, 0x0 }, // 6095
  { PseudoVNSRA_WI_M4_MASK, VNSRA_WI, 0x2, 0x0 }, // 6096
  { PseudoVNSRA_WI_MF8, VNSRA_WI, 0x5, 0x0 }, // 6097
  { PseudoVNSRA_WI_MF8_MASK, VNSRA_WI, 0x5, 0x0 }, // 6098
  { PseudoVNSRA_WI_MF4, VNSRA_WI, 0x6, 0x0 }, // 6099
  { PseudoVNSRA_WI_MF4_MASK, VNSRA_WI, 0x6, 0x0 }, // 6100
  { PseudoVNSRA_WI_MF2, VNSRA_WI, 0x7, 0x0 }, // 6101
  { PseudoVNSRA_WI_MF2_MASK, VNSRA_WI, 0x7, 0x0 }, // 6102
  { PseudoVNSRA_WV_M1, VNSRA_WV, 0x0, 0x0 }, // 6103
  { PseudoVNSRA_WV_M1_MASK, VNSRA_WV, 0x0, 0x0 }, // 6104
  { PseudoVNSRA_WV_M2, VNSRA_WV, 0x1, 0x0 }, // 6105
  { PseudoVNSRA_WV_M2_MASK, VNSRA_WV, 0x1, 0x0 }, // 6106
  { PseudoVNSRA_WV_M4, VNSRA_WV, 0x2, 0x0 }, // 6107
  { PseudoVNSRA_WV_M4_MASK, VNSRA_WV, 0x2, 0x0 }, // 6108
  { PseudoVNSRA_WV_MF8, VNSRA_WV, 0x5, 0x0 }, // 6109
  { PseudoVNSRA_WV_MF8_MASK, VNSRA_WV, 0x5, 0x0 }, // 6110
  { PseudoVNSRA_WV_MF4, VNSRA_WV, 0x6, 0x0 }, // 6111
  { PseudoVNSRA_WV_MF4_MASK, VNSRA_WV, 0x6, 0x0 }, // 6112
  { PseudoVNSRA_WV_MF2, VNSRA_WV, 0x7, 0x0 }, // 6113
  { PseudoVNSRA_WV_MF2_MASK, VNSRA_WV, 0x7, 0x0 }, // 6114
  { PseudoVNSRA_WX_M1, VNSRA_WX, 0x0, 0x0 }, // 6115
  { PseudoVNSRA_WX_M1_MASK, VNSRA_WX, 0x0, 0x0 }, // 6116
  { PseudoVNSRA_WX_M2, VNSRA_WX, 0x1, 0x0 }, // 6117
  { PseudoVNSRA_WX_M2_MASK, VNSRA_WX, 0x1, 0x0 }, // 6118
  { PseudoVNSRA_WX_M4, VNSRA_WX, 0x2, 0x0 }, // 6119
  { PseudoVNSRA_WX_M4_MASK, VNSRA_WX, 0x2, 0x0 }, // 6120
  { PseudoVNSRA_WX_MF8, VNSRA_WX, 0x5, 0x0 }, // 6121
  { PseudoVNSRA_WX_MF8_MASK, VNSRA_WX, 0x5, 0x0 }, // 6122
  { PseudoVNSRA_WX_MF4, VNSRA_WX, 0x6, 0x0 }, // 6123
  { PseudoVNSRA_WX_MF4_MASK, VNSRA_WX, 0x6, 0x0 }, // 6124
  { PseudoVNSRA_WX_MF2, VNSRA_WX, 0x7, 0x0 }, // 6125
  { PseudoVNSRA_WX_MF2_MASK, VNSRA_WX, 0x7, 0x0 }, // 6126
  { PseudoVNSRL_WI_M1, VNSRL_WI, 0x0, 0x0 }, // 6127
  { PseudoVNSRL_WI_M1_MASK, VNSRL_WI, 0x0, 0x0 }, // 6128
  { PseudoVNSRL_WI_M2, VNSRL_WI, 0x1, 0x0 }, // 6129
  { PseudoVNSRL_WI_M2_MASK, VNSRL_WI, 0x1, 0x0 }, // 6130
  { PseudoVNSRL_WI_M4, VNSRL_WI, 0x2, 0x0 }, // 6131
  { PseudoVNSRL_WI_M4_MASK, VNSRL_WI, 0x2, 0x0 }, // 6132
  { PseudoVNSRL_WI_MF8, VNSRL_WI, 0x5, 0x0 }, // 6133
  { PseudoVNSRL_WI_MF8_MASK, VNSRL_WI, 0x5, 0x0 }, // 6134
  { PseudoVNSRL_WI_MF4, VNSRL_WI, 0x6, 0x0 }, // 6135
  { PseudoVNSRL_WI_MF4_MASK, VNSRL_WI, 0x6, 0x0 }, // 6136
  { PseudoVNSRL_WI_MF2, VNSRL_WI, 0x7, 0x0 }, // 6137
  { PseudoVNSRL_WI_MF2_MASK, VNSRL_WI, 0x7, 0x0 }, // 6138
  { PseudoVNSRL_WV_M1, VNSRL_WV, 0x0, 0x0 }, // 6139
  { PseudoVNSRL_WV_M1_MASK, VNSRL_WV, 0x0, 0x0 }, // 6140
  { PseudoVNSRL_WV_M2, VNSRL_WV, 0x1, 0x0 }, // 6141
  { PseudoVNSRL_WV_M2_MASK, VNSRL_WV, 0x1, 0x0 }, // 6142
  { PseudoVNSRL_WV_M4, VNSRL_WV, 0x2, 0x0 }, // 6143
  { PseudoVNSRL_WV_M4_MASK, VNSRL_WV, 0x2, 0x0 }, // 6144
  { PseudoVNSRL_WV_MF8, VNSRL_WV, 0x5, 0x0 }, // 6145
  { PseudoVNSRL_WV_MF8_MASK, VNSRL_WV, 0x5, 0x0 }, // 6146
  { PseudoVNSRL_WV_MF4, VNSRL_WV, 0x6, 0x0 }, // 6147
  { PseudoVNSRL_WV_MF4_MASK, VNSRL_WV, 0x6, 0x0 }, // 6148
  { PseudoVNSRL_WV_MF2, VNSRL_WV, 0x7, 0x0 }, // 6149
  { PseudoVNSRL_WV_MF2_MASK, VNSRL_WV, 0x7, 0x0 }, // 6150
  { PseudoVNSRL_WX_M1, VNSRL_WX, 0x0, 0x0 }, // 6151
  { PseudoVNSRL_WX_M1_MASK, VNSRL_WX, 0x0, 0x0 }, // 6152
  { PseudoVNSRL_WX_M2, VNSRL_WX, 0x1, 0x0 }, // 6153
  { PseudoVNSRL_WX_M2_MASK, VNSRL_WX, 0x1, 0x0 }, // 6154
  { PseudoVNSRL_WX_M4, VNSRL_WX, 0x2, 0x0 }, // 6155
  { PseudoVNSRL_WX_M4_MASK, VNSRL_WX, 0x2, 0x0 }, // 6156
  { PseudoVNSRL_WX_MF8, VNSRL_WX, 0x5, 0x0 }, // 6157
  { PseudoVNSRL_WX_MF8_MASK, VNSRL_WX, 0x5, 0x0 }, // 6158
  { PseudoVNSRL_WX_MF4, VNSRL_WX, 0x6, 0x0 }, // 6159
  { PseudoVNSRL_WX_MF4_MASK, VNSRL_WX, 0x6, 0x0 }, // 6160
  { PseudoVNSRL_WX_MF2, VNSRL_WX, 0x7, 0x0 }, // 6161
  { PseudoVNSRL_WX_MF2_MASK, VNSRL_WX, 0x7, 0x0 }, // 6162
  { PseudoVOR_VI_M1, VOR_VI, 0x0, 0x0 }, // 6163
  { PseudoVOR_VI_M1_MASK, VOR_VI, 0x0, 0x0 }, // 6164
  { PseudoVOR_VI_M2, VOR_VI, 0x1, 0x0 }, // 6165
  { PseudoVOR_VI_M2_MASK, VOR_VI, 0x1, 0x0 }, // 6166
  { PseudoVOR_VI_M4, VOR_VI, 0x2, 0x0 }, // 6167
  { PseudoVOR_VI_M4_MASK, VOR_VI, 0x2, 0x0 }, // 6168
  { PseudoVOR_VI_M8, VOR_VI, 0x3, 0x0 }, // 6169
  { PseudoVOR_VI_M8_MASK, VOR_VI, 0x3, 0x0 }, // 6170
  { PseudoVOR_VI_MF8, VOR_VI, 0x5, 0x0 }, // 6171
  { PseudoVOR_VI_MF8_MASK, VOR_VI, 0x5, 0x0 }, // 6172
  { PseudoVOR_VI_MF4, VOR_VI, 0x6, 0x0 }, // 6173
  { PseudoVOR_VI_MF4_MASK, VOR_VI, 0x6, 0x0 }, // 6174
  { PseudoVOR_VI_MF2, VOR_VI, 0x7, 0x0 }, // 6175
  { PseudoVOR_VI_MF2_MASK, VOR_VI, 0x7, 0x0 }, // 6176
  { PseudoVOR_VV_M1, VOR_VV, 0x0, 0x0 }, // 6177
  { PseudoVOR_VV_M1_MASK, VOR_VV, 0x0, 0x0 }, // 6178
  { PseudoVOR_VV_M2, VOR_VV, 0x1, 0x0 }, // 6179
  { PseudoVOR_VV_M2_MASK, VOR_VV, 0x1, 0x0 }, // 6180
  { PseudoVOR_VV_M4, VOR_VV, 0x2, 0x0 }, // 6181
  { PseudoVOR_VV_M4_MASK, VOR_VV, 0x2, 0x0 }, // 6182
  { PseudoVOR_VV_M8, VOR_VV, 0x3, 0x0 }, // 6183
  { PseudoVOR_VV_M8_MASK, VOR_VV, 0x3, 0x0 }, // 6184
  { PseudoVOR_VV_MF8, VOR_VV, 0x5, 0x0 }, // 6185
  { PseudoVOR_VV_MF8_MASK, VOR_VV, 0x5, 0x0 }, // 6186
  { PseudoVOR_VV_MF4, VOR_VV, 0x6, 0x0 }, // 6187
  { PseudoVOR_VV_MF4_MASK, VOR_VV, 0x6, 0x0 }, // 6188
  { PseudoVOR_VV_MF2, VOR_VV, 0x7, 0x0 }, // 6189
  { PseudoVOR_VV_MF2_MASK, VOR_VV, 0x7, 0x0 }, // 6190
  { PseudoVOR_VX_M1, VOR_VX, 0x0, 0x0 }, // 6191
  { PseudoVOR_VX_M1_MASK, VOR_VX, 0x0, 0x0 }, // 6192
  { PseudoVOR_VX_M2, VOR_VX, 0x1, 0x0 }, // 6193
  { PseudoVOR_VX_M2_MASK, VOR_VX, 0x1, 0x0 }, // 6194
  { PseudoVOR_VX_M4, VOR_VX, 0x2, 0x0 }, // 6195
  { PseudoVOR_VX_M4_MASK, VOR_VX, 0x2, 0x0 }, // 6196
  { PseudoVOR_VX_M8, VOR_VX, 0x3, 0x0 }, // 6197
  { PseudoVOR_VX_M8_MASK, VOR_VX, 0x3, 0x0 }, // 6198
  { PseudoVOR_VX_MF8, VOR_VX, 0x5, 0x0 }, // 6199
  { PseudoVOR_VX_MF8_MASK, VOR_VX, 0x5, 0x0 }, // 6200
  { PseudoVOR_VX_MF4, VOR_VX, 0x6, 0x0 }, // 6201
  { PseudoVOR_VX_MF4_MASK, VOR_VX, 0x6, 0x0 }, // 6202
  { PseudoVOR_VX_MF2, VOR_VX, 0x7, 0x0 }, // 6203
  { PseudoVOR_VX_MF2_MASK, VOR_VX, 0x7, 0x0 }, // 6204
  { PseudoVREDAND_VS_M1_E16, VREDAND_VS, 0x0, 0x0 }, // 6205
  { PseudoVREDAND_VS_M1_E16_MASK, VREDAND_VS, 0x0, 0x0 }, // 6206
  { PseudoVREDAND_VS_M1_E32, VREDAND_VS, 0x0, 0x0 }, // 6207
  { PseudoVREDAND_VS_M1_E32_MASK, VREDAND_VS, 0x0, 0x0 }, // 6208
  { PseudoVREDAND_VS_M1_E64, VREDAND_VS, 0x0, 0x0 }, // 6209
  { PseudoVREDAND_VS_M1_E64_MASK, VREDAND_VS, 0x0, 0x0 }, // 6210
  { PseudoVREDAND_VS_M1_E8, VREDAND_VS, 0x0, 0x0 }, // 6211
  { PseudoVREDAND_VS_M1_E8_MASK, VREDAND_VS, 0x0, 0x0 }, // 6212
  { PseudoVREDAND_VS_M2_E16, VREDAND_VS, 0x1, 0x0 }, // 6213
  { PseudoVREDAND_VS_M2_E16_MASK, VREDAND_VS, 0x1, 0x0 }, // 6214
  { PseudoVREDAND_VS_M2_E32, VREDAND_VS, 0x1, 0x0 }, // 6215
  { PseudoVREDAND_VS_M2_E32_MASK, VREDAND_VS, 0x1, 0x0 }, // 6216
  { PseudoVREDAND_VS_M2_E64, VREDAND_VS, 0x1, 0x0 }, // 6217
  { PseudoVREDAND_VS_M2_E64_MASK, VREDAND_VS, 0x1, 0x0 }, // 6218
  { PseudoVREDAND_VS_M2_E8, VREDAND_VS, 0x1, 0x0 }, // 6219
  { PseudoVREDAND_VS_M2_E8_MASK, VREDAND_VS, 0x1, 0x0 }, // 6220
  { PseudoVREDAND_VS_M4_E16, VREDAND_VS, 0x2, 0x0 }, // 6221
  { PseudoVREDAND_VS_M4_E16_MASK, VREDAND_VS, 0x2, 0x0 }, // 6222
  { PseudoVREDAND_VS_M4_E32, VREDAND_VS, 0x2, 0x0 }, // 6223
  { PseudoVREDAND_VS_M4_E32_MASK, VREDAND_VS, 0x2, 0x0 }, // 6224
  { PseudoVREDAND_VS_M4_E64, VREDAND_VS, 0x2, 0x0 }, // 6225
  { PseudoVREDAND_VS_M4_E64_MASK, VREDAND_VS, 0x2, 0x0 }, // 6226
  { PseudoVREDAND_VS_M4_E8, VREDAND_VS, 0x2, 0x0 }, // 6227
  { PseudoVREDAND_VS_M4_E8_MASK, VREDAND_VS, 0x2, 0x0 }, // 6228
  { PseudoVREDAND_VS_M8_E16, VREDAND_VS, 0x3, 0x0 }, // 6229
  { PseudoVREDAND_VS_M8_E16_MASK, VREDAND_VS, 0x3, 0x0 }, // 6230
  { PseudoVREDAND_VS_M8_E32, VREDAND_VS, 0x3, 0x0 }, // 6231
  { PseudoVREDAND_VS_M8_E32_MASK, VREDAND_VS, 0x3, 0x0 }, // 6232
  { PseudoVREDAND_VS_M8_E64, VREDAND_VS, 0x3, 0x0 }, // 6233
  { PseudoVREDAND_VS_M8_E64_MASK, VREDAND_VS, 0x3, 0x0 }, // 6234
  { PseudoVREDAND_VS_M8_E8, VREDAND_VS, 0x3, 0x0 }, // 6235
  { PseudoVREDAND_VS_M8_E8_MASK, VREDAND_VS, 0x3, 0x0 }, // 6236
  { PseudoVREDAND_VS_MF8_E8, VREDAND_VS, 0x5, 0x0 }, // 6237
  { PseudoVREDAND_VS_MF8_E8_MASK, VREDAND_VS, 0x5, 0x0 }, // 6238
  { PseudoVREDAND_VS_MF4_E16, VREDAND_VS, 0x6, 0x0 }, // 6239
  { PseudoVREDAND_VS_MF4_E16_MASK, VREDAND_VS, 0x6, 0x0 }, // 6240
  { PseudoVREDAND_VS_MF4_E8, VREDAND_VS, 0x6, 0x0 }, // 6241
  { PseudoVREDAND_VS_MF4_E8_MASK, VREDAND_VS, 0x6, 0x0 }, // 6242
  { PseudoVREDAND_VS_MF2_E16, VREDAND_VS, 0x7, 0x0 }, // 6243
  { PseudoVREDAND_VS_MF2_E16_MASK, VREDAND_VS, 0x7, 0x0 }, // 6244
  { PseudoVREDAND_VS_MF2_E32, VREDAND_VS, 0x7, 0x0 }, // 6245
  { PseudoVREDAND_VS_MF2_E32_MASK, VREDAND_VS, 0x7, 0x0 }, // 6246
  { PseudoVREDAND_VS_MF2_E8, VREDAND_VS, 0x7, 0x0 }, // 6247
  { PseudoVREDAND_VS_MF2_E8_MASK, VREDAND_VS, 0x7, 0x0 }, // 6248
  { PseudoVREDMAXU_VS_M1_E16, VREDMAXU_VS, 0x0, 0x0 }, // 6249
  { PseudoVREDMAXU_VS_M1_E16_MASK, VREDMAXU_VS, 0x0, 0x0 }, // 6250
  { PseudoVREDMAXU_VS_M1_E32, VREDMAXU_VS, 0x0, 0x0 }, // 6251
  { PseudoVREDMAXU_VS_M1_E32_MASK, VREDMAXU_VS, 0x0, 0x0 }, // 6252
  { PseudoVREDMAXU_VS_M1_E64, VREDMAXU_VS, 0x0, 0x0 }, // 6253
  { PseudoVREDMAXU_VS_M1_E64_MASK, VREDMAXU_VS, 0x0, 0x0 }, // 6254
  { PseudoVREDMAXU_VS_M1_E8, VREDMAXU_VS, 0x0, 0x0 }, // 6255
  { PseudoVREDMAXU_VS_M1_E8_MASK, VREDMAXU_VS, 0x0, 0x0 }, // 6256
  { PseudoVREDMAXU_VS_M2_E16, VREDMAXU_VS, 0x1, 0x0 }, // 6257
  { PseudoVREDMAXU_VS_M2_E16_MASK, VREDMAXU_VS, 0x1, 0x0 }, // 6258
  { PseudoVREDMAXU_VS_M2_E32, VREDMAXU_VS, 0x1, 0x0 }, // 6259
  { PseudoVREDMAXU_VS_M2_E32_MASK, VREDMAXU_VS, 0x1, 0x0 }, // 6260
  { PseudoVREDMAXU_VS_M2_E64, VREDMAXU_VS, 0x1, 0x0 }, // 6261
  { PseudoVREDMAXU_VS_M2_E64_MASK, VREDMAXU_VS, 0x1, 0x0 }, // 6262
  { PseudoVREDMAXU_VS_M2_E8, VREDMAXU_VS, 0x1, 0x0 }, // 6263
  { PseudoVREDMAXU_VS_M2_E8_MASK, VREDMAXU_VS, 0x1, 0x0 }, // 6264
  { PseudoVREDMAXU_VS_M4_E16, VREDMAXU_VS, 0x2, 0x0 }, // 6265
  { PseudoVREDMAXU_VS_M4_E16_MASK, VREDMAXU_VS, 0x2, 0x0 }, // 6266
  { PseudoVREDMAXU_VS_M4_E32, VREDMAXU_VS, 0x2, 0x0 }, // 6267
  { PseudoVREDMAXU_VS_M4_E32_MASK, VREDMAXU_VS, 0x2, 0x0 }, // 6268
  { PseudoVREDMAXU_VS_M4_E64, VREDMAXU_VS, 0x2, 0x0 }, // 6269
  { PseudoVREDMAXU_VS_M4_E64_MASK, VREDMAXU_VS, 0x2, 0x0 }, // 6270
  { PseudoVREDMAXU_VS_M4_E8, VREDMAXU_VS, 0x2, 0x0 }, // 6271
  { PseudoVREDMAXU_VS_M4_E8_MASK, VREDMAXU_VS, 0x2, 0x0 }, // 6272
  { PseudoVREDMAXU_VS_M8_E16, VREDMAXU_VS, 0x3, 0x0 }, // 6273
  { PseudoVREDMAXU_VS_M8_E16_MASK, VREDMAXU_VS, 0x3, 0x0 }, // 6274
  { PseudoVREDMAXU_VS_M8_E32, VREDMAXU_VS, 0x3, 0x0 }, // 6275
  { PseudoVREDMAXU_VS_M8_E32_MASK, VREDMAXU_VS, 0x3, 0x0 }, // 6276
  { PseudoVREDMAXU_VS_M8_E64, VREDMAXU_VS, 0x3, 0x0 }, // 6277
  { PseudoVREDMAXU_VS_M8_E64_MASK, VREDMAXU_VS, 0x3, 0x0 }, // 6278
  { PseudoVREDMAXU_VS_M8_E8, VREDMAXU_VS, 0x3, 0x0 }, // 6279
  { PseudoVREDMAXU_VS_M8_E8_MASK, VREDMAXU_VS, 0x3, 0x0 }, // 6280
  { PseudoVREDMAXU_VS_MF8_E8, VREDMAXU_VS, 0x5, 0x0 }, // 6281
  { PseudoVREDMAXU_VS_MF8_E8_MASK, VREDMAXU_VS, 0x5, 0x0 }, // 6282
  { PseudoVREDMAXU_VS_MF4_E16, VREDMAXU_VS, 0x6, 0x0 }, // 6283
  { PseudoVREDMAXU_VS_MF4_E16_MASK, VREDMAXU_VS, 0x6, 0x0 }, // 6284
  { PseudoVREDMAXU_VS_MF4_E8, VREDMAXU_VS, 0x6, 0x0 }, // 6285
  { PseudoVREDMAXU_VS_MF4_E8_MASK, VREDMAXU_VS, 0x6, 0x0 }, // 6286
  { PseudoVREDMAXU_VS_MF2_E16, VREDMAXU_VS, 0x7, 0x0 }, // 6287
  { PseudoVREDMAXU_VS_MF2_E16_MASK, VREDMAXU_VS, 0x7, 0x0 }, // 6288
  { PseudoVREDMAXU_VS_MF2_E32, VREDMAXU_VS, 0x7, 0x0 }, // 6289
  { PseudoVREDMAXU_VS_MF2_E32_MASK, VREDMAXU_VS, 0x7, 0x0 }, // 6290
  { PseudoVREDMAXU_VS_MF2_E8, VREDMAXU_VS, 0x7, 0x0 }, // 6291
  { PseudoVREDMAXU_VS_MF2_E8_MASK, VREDMAXU_VS, 0x7, 0x0 }, // 6292
  { PseudoVREDMAX_VS_M1_E16, VREDMAX_VS, 0x0, 0x0 }, // 6293
  { PseudoVREDMAX_VS_M1_E16_MASK, VREDMAX_VS, 0x0, 0x0 }, // 6294
  { PseudoVREDMAX_VS_M1_E32, VREDMAX_VS, 0x0, 0x0 }, // 6295
  { PseudoVREDMAX_VS_M1_E32_MASK, VREDMAX_VS, 0x0, 0x0 }, // 6296
  { PseudoVREDMAX_VS_M1_E64, VREDMAX_VS, 0x0, 0x0 }, // 6297
  { PseudoVREDMAX_VS_M1_E64_MASK, VREDMAX_VS, 0x0, 0x0 }, // 6298
  { PseudoVREDMAX_VS_M1_E8, VREDMAX_VS, 0x0, 0x0 }, // 6299
  { PseudoVREDMAX_VS_M1_E8_MASK, VREDMAX_VS, 0x0, 0x0 }, // 6300
  { PseudoVREDMAX_VS_M2_E16, VREDMAX_VS, 0x1, 0x0 }, // 6301
  { PseudoVREDMAX_VS_M2_E16_MASK, VREDMAX_VS, 0x1, 0x0 }, // 6302
  { PseudoVREDMAX_VS_M2_E32, VREDMAX_VS, 0x1, 0x0 }, // 6303
  { PseudoVREDMAX_VS_M2_E32_MASK, VREDMAX_VS, 0x1, 0x0 }, // 6304
  { PseudoVREDMAX_VS_M2_E64, VREDMAX_VS, 0x1, 0x0 }, // 6305
  { PseudoVREDMAX_VS_M2_E64_MASK, VREDMAX_VS, 0x1, 0x0 }, // 6306
  { PseudoVREDMAX_VS_M2_E8, VREDMAX_VS, 0x1, 0x0 }, // 6307
  { PseudoVREDMAX_VS_M2_E8_MASK, VREDMAX_VS, 0x1, 0x0 }, // 6308
  { PseudoVREDMAX_VS_M4_E16, VREDMAX_VS, 0x2, 0x0 }, // 6309
  { PseudoVREDMAX_VS_M4_E16_MASK, VREDMAX_VS, 0x2, 0x0 }, // 6310
  { PseudoVREDMAX_VS_M4_E32, VREDMAX_VS, 0x2, 0x0 }, // 6311
  { PseudoVREDMAX_VS_M4_E32_MASK, VREDMAX_VS, 0x2, 0x0 }, // 6312
  { PseudoVREDMAX_VS_M4_E64, VREDMAX_VS, 0x2, 0x0 }, // 6313
  { PseudoVREDMAX_VS_M4_E64_MASK, VREDMAX_VS, 0x2, 0x0 }, // 6314
  { PseudoVREDMAX_VS_M4_E8, VREDMAX_VS, 0x2, 0x0 }, // 6315
  { PseudoVREDMAX_VS_M4_E8_MASK, VREDMAX_VS, 0x2, 0x0 }, // 6316
  { PseudoVREDMAX_VS_M8_E16, VREDMAX_VS, 0x3, 0x0 }, // 6317
  { PseudoVREDMAX_VS_M8_E16_MASK, VREDMAX_VS, 0x3, 0x0 }, // 6318
  { PseudoVREDMAX_VS_M8_E32, VREDMAX_VS, 0x3, 0x0 }, // 6319
  { PseudoVREDMAX_VS_M8_E32_MASK, VREDMAX_VS, 0x3, 0x0 }, // 6320
  { PseudoVREDMAX_VS_M8_E64, VREDMAX_VS, 0x3, 0x0 }, // 6321
  { PseudoVREDMAX_VS_M8_E64_MASK, VREDMAX_VS, 0x3, 0x0 }, // 6322
  { PseudoVREDMAX_VS_M8_E8, VREDMAX_VS, 0x3, 0x0 }, // 6323
  { PseudoVREDMAX_VS_M8_E8_MASK, VREDMAX_VS, 0x3, 0x0 }, // 6324
  { PseudoVREDMAX_VS_MF8_E8, VREDMAX_VS, 0x5, 0x0 }, // 6325
  { PseudoVREDMAX_VS_MF8_E8_MASK, VREDMAX_VS, 0x5, 0x0 }, // 6326
  { PseudoVREDMAX_VS_MF4_E16, VREDMAX_VS, 0x6, 0x0 }, // 6327
  { PseudoVREDMAX_VS_MF4_E16_MASK, VREDMAX_VS, 0x6, 0x0 }, // 6328
  { PseudoVREDMAX_VS_MF4_E8, VREDMAX_VS, 0x6, 0x0 }, // 6329
  { PseudoVREDMAX_VS_MF4_E8_MASK, VREDMAX_VS, 0x6, 0x0 }, // 6330
  { PseudoVREDMAX_VS_MF2_E16, VREDMAX_VS, 0x7, 0x0 }, // 6331
  { PseudoVREDMAX_VS_MF2_E16_MASK, VREDMAX_VS, 0x7, 0x0 }, // 6332
  { PseudoVREDMAX_VS_MF2_E32, VREDMAX_VS, 0x7, 0x0 }, // 6333
  { PseudoVREDMAX_VS_MF2_E32_MASK, VREDMAX_VS, 0x7, 0x0 }, // 6334
  { PseudoVREDMAX_VS_MF2_E8, VREDMAX_VS, 0x7, 0x0 }, // 6335
  { PseudoVREDMAX_VS_MF2_E8_MASK, VREDMAX_VS, 0x7, 0x0 }, // 6336
  { PseudoVREDMINU_VS_M1_E16, VREDMINU_VS, 0x0, 0x0 }, // 6337
  { PseudoVREDMINU_VS_M1_E16_MASK, VREDMINU_VS, 0x0, 0x0 }, // 6338
  { PseudoVREDMINU_VS_M1_E32, VREDMINU_VS, 0x0, 0x0 }, // 6339
  { PseudoVREDMINU_VS_M1_E32_MASK, VREDMINU_VS, 0x0, 0x0 }, // 6340
  { PseudoVREDMINU_VS_M1_E64, VREDMINU_VS, 0x0, 0x0 }, // 6341
  { PseudoVREDMINU_VS_M1_E64_MASK, VREDMINU_VS, 0x0, 0x0 }, // 6342
  { PseudoVREDMINU_VS_M1_E8, VREDMINU_VS, 0x0, 0x0 }, // 6343
  { PseudoVREDMINU_VS_M1_E8_MASK, VREDMINU_VS, 0x0, 0x0 }, // 6344
  { PseudoVREDMINU_VS_M2_E16, VREDMINU_VS, 0x1, 0x0 }, // 6345
  { PseudoVREDMINU_VS_M2_E16_MASK, VREDMINU_VS, 0x1, 0x0 }, // 6346
  { PseudoVREDMINU_VS_M2_E32, VREDMINU_VS, 0x1, 0x0 }, // 6347
  { PseudoVREDMINU_VS_M2_E32_MASK, VREDMINU_VS, 0x1, 0x0 }, // 6348
  { PseudoVREDMINU_VS_M2_E64, VREDMINU_VS, 0x1, 0x0 }, // 6349
  { PseudoVREDMINU_VS_M2_E64_MASK, VREDMINU_VS, 0x1, 0x0 }, // 6350
  { PseudoVREDMINU_VS_M2_E8, VREDMINU_VS, 0x1, 0x0 }, // 6351
  { PseudoVREDMINU_VS_M2_E8_MASK, VREDMINU_VS, 0x1, 0x0 }, // 6352
  { PseudoVREDMINU_VS_M4_E16, VREDMINU_VS, 0x2, 0x0 }, // 6353
  { PseudoVREDMINU_VS_M4_E16_MASK, VREDMINU_VS, 0x2, 0x0 }, // 6354
  { PseudoVREDMINU_VS_M4_E32, VREDMINU_VS, 0x2, 0x0 }, // 6355
  { PseudoVREDMINU_VS_M4_E32_MASK, VREDMINU_VS, 0x2, 0x0 }, // 6356
  { PseudoVREDMINU_VS_M4_E64, VREDMINU_VS, 0x2, 0x0 }, // 6357
  { PseudoVREDMINU_VS_M4_E64_MASK, VREDMINU_VS, 0x2, 0x0 }, // 6358
  { PseudoVREDMINU_VS_M4_E8, VREDMINU_VS, 0x2, 0x0 }, // 6359
  { PseudoVREDMINU_VS_M4_E8_MASK, VREDMINU_VS, 0x2, 0x0 }, // 6360
  { PseudoVREDMINU_VS_M8_E16, VREDMINU_VS, 0x3, 0x0 }, // 6361
  { PseudoVREDMINU_VS_M8_E16_MASK, VREDMINU_VS, 0x3, 0x0 }, // 6362
  { PseudoVREDMINU_VS_M8_E32, VREDMINU_VS, 0x3, 0x0 }, // 6363
  { PseudoVREDMINU_VS_M8_E32_MASK, VREDMINU_VS, 0x3, 0x0 }, // 6364
  { PseudoVREDMINU_VS_M8_E64, VREDMINU_VS, 0x3, 0x0 }, // 6365
  { PseudoVREDMINU_VS_M8_E64_MASK, VREDMINU_VS, 0x3, 0x0 }, // 6366
  { PseudoVREDMINU_VS_M8_E8, VREDMINU_VS, 0x3, 0x0 }, // 6367
  { PseudoVREDMINU_VS_M8_E8_MASK, VREDMINU_VS, 0x3, 0x0 }, // 6368
  { PseudoVREDMINU_VS_MF8_E8, VREDMINU_VS, 0x5, 0x0 }, // 6369
  { PseudoVREDMINU_VS_MF8_E8_MASK, VREDMINU_VS, 0x5, 0x0 }, // 6370
  { PseudoVREDMINU_VS_MF4_E16, VREDMINU_VS, 0x6, 0x0 }, // 6371
  { PseudoVREDMINU_VS_MF4_E16_MASK, VREDMINU_VS, 0x6, 0x0 }, // 6372
  { PseudoVREDMINU_VS_MF4_E8, VREDMINU_VS, 0x6, 0x0 }, // 6373
  { PseudoVREDMINU_VS_MF4_E8_MASK, VREDMINU_VS, 0x6, 0x0 }, // 6374
  { PseudoVREDMINU_VS_MF2_E16, VREDMINU_VS, 0x7, 0x0 }, // 6375
  { PseudoVREDMINU_VS_MF2_E16_MASK, VREDMINU_VS, 0x7, 0x0 }, // 6376
  { PseudoVREDMINU_VS_MF2_E32, VREDMINU_VS, 0x7, 0x0 }, // 6377
  { PseudoVREDMINU_VS_MF2_E32_MASK, VREDMINU_VS, 0x7, 0x0 }, // 6378
  { PseudoVREDMINU_VS_MF2_E8, VREDMINU_VS, 0x7, 0x0 }, // 6379
  { PseudoVREDMINU_VS_MF2_E8_MASK, VREDMINU_VS, 0x7, 0x0 }, // 6380
  { PseudoVREDMIN_VS_M1_E16, VREDMIN_VS, 0x0, 0x0 }, // 6381
  { PseudoVREDMIN_VS_M1_E16_MASK, VREDMIN_VS, 0x0, 0x0 }, // 6382
  { PseudoVREDMIN_VS_M1_E32, VREDMIN_VS, 0x0, 0x0 }, // 6383
  { PseudoVREDMIN_VS_M1_E32_MASK, VREDMIN_VS, 0x0, 0x0 }, // 6384
  { PseudoVREDMIN_VS_M1_E64, VREDMIN_VS, 0x0, 0x0 }, // 6385
  { PseudoVREDMIN_VS_M1_E64_MASK, VREDMIN_VS, 0x0, 0x0 }, // 6386
  { PseudoVREDMIN_VS_M1_E8, VREDMIN_VS, 0x0, 0x0 }, // 6387
  { PseudoVREDMIN_VS_M1_E8_MASK, VREDMIN_VS, 0x0, 0x0 }, // 6388
  { PseudoVREDMIN_VS_M2_E16, VREDMIN_VS, 0x1, 0x0 }, // 6389
  { PseudoVREDMIN_VS_M2_E16_MASK, VREDMIN_VS, 0x1, 0x0 }, // 6390
  { PseudoVREDMIN_VS_M2_E32, VREDMIN_VS, 0x1, 0x0 }, // 6391
  { PseudoVREDMIN_VS_M2_E32_MASK, VREDMIN_VS, 0x1, 0x0 }, // 6392
  { PseudoVREDMIN_VS_M2_E64, VREDMIN_VS, 0x1, 0x0 }, // 6393
  { PseudoVREDMIN_VS_M2_E64_MASK, VREDMIN_VS, 0x1, 0x0 }, // 6394
  { PseudoVREDMIN_VS_M2_E8, VREDMIN_VS, 0x1, 0x0 }, // 6395
  { PseudoVREDMIN_VS_M2_E8_MASK, VREDMIN_VS, 0x1, 0x0 }, // 6396
  { PseudoVREDMIN_VS_M4_E16, VREDMIN_VS, 0x2, 0x0 }, // 6397
  { PseudoVREDMIN_VS_M4_E16_MASK, VREDMIN_VS, 0x2, 0x0 }, // 6398
  { PseudoVREDMIN_VS_M4_E32, VREDMIN_VS, 0x2, 0x0 }, // 6399
  { PseudoVREDMIN_VS_M4_E32_MASK, VREDMIN_VS, 0x2, 0x0 }, // 6400
  { PseudoVREDMIN_VS_M4_E64, VREDMIN_VS, 0x2, 0x0 }, // 6401
  { PseudoVREDMIN_VS_M4_E64_MASK, VREDMIN_VS, 0x2, 0x0 }, // 6402
  { PseudoVREDMIN_VS_M4_E8, VREDMIN_VS, 0x2, 0x0 }, // 6403
  { PseudoVREDMIN_VS_M4_E8_MASK, VREDMIN_VS, 0x2, 0x0 }, // 6404
  { PseudoVREDMIN_VS_M8_E16, VREDMIN_VS, 0x3, 0x0 }, // 6405
  { PseudoVREDMIN_VS_M8_E16_MASK, VREDMIN_VS, 0x3, 0x0 }, // 6406
  { PseudoVREDMIN_VS_M8_E32, VREDMIN_VS, 0x3, 0x0 }, // 6407
  { PseudoVREDMIN_VS_M8_E32_MASK, VREDMIN_VS, 0x3, 0x0 }, // 6408
  { PseudoVREDMIN_VS_M8_E64, VREDMIN_VS, 0x3, 0x0 }, // 6409
  { PseudoVREDMIN_VS_M8_E64_MASK, VREDMIN_VS, 0x3, 0x0 }, // 6410
  { PseudoVREDMIN_VS_M8_E8, VREDMIN_VS, 0x3, 0x0 }, // 6411
  { PseudoVREDMIN_VS_M8_E8_MASK, VREDMIN_VS, 0x3, 0x0 }, // 6412
  { PseudoVREDMIN_VS_MF8_E8, VREDMIN_VS, 0x5, 0x0 }, // 6413
  { PseudoVREDMIN_VS_MF8_E8_MASK, VREDMIN_VS, 0x5, 0x0 }, // 6414
  { PseudoVREDMIN_VS_MF4_E16, VREDMIN_VS, 0x6, 0x0 }, // 6415
  { PseudoVREDMIN_VS_MF4_E16_MASK, VREDMIN_VS, 0x6, 0x0 }, // 6416
  { PseudoVREDMIN_VS_MF4_E8, VREDMIN_VS, 0x6, 0x0 }, // 6417
  { PseudoVREDMIN_VS_MF4_E8_MASK, VREDMIN_VS, 0x6, 0x0 }, // 6418
  { PseudoVREDMIN_VS_MF2_E16, VREDMIN_VS, 0x7, 0x0 }, // 6419
  { PseudoVREDMIN_VS_MF2_E16_MASK, VREDMIN_VS, 0x7, 0x0 }, // 6420
  { PseudoVREDMIN_VS_MF2_E32, VREDMIN_VS, 0x7, 0x0 }, // 6421
  { PseudoVREDMIN_VS_MF2_E32_MASK, VREDMIN_VS, 0x7, 0x0 }, // 6422
  { PseudoVREDMIN_VS_MF2_E8, VREDMIN_VS, 0x7, 0x0 }, // 6423
  { PseudoVREDMIN_VS_MF2_E8_MASK, VREDMIN_VS, 0x7, 0x0 }, // 6424
  { PseudoVREDOR_VS_M1_E16, VREDOR_VS, 0x0, 0x0 }, // 6425
  { PseudoVREDOR_VS_M1_E16_MASK, VREDOR_VS, 0x0, 0x0 }, // 6426
  { PseudoVREDOR_VS_M1_E32, VREDOR_VS, 0x0, 0x0 }, // 6427
  { PseudoVREDOR_VS_M1_E32_MASK, VREDOR_VS, 0x0, 0x0 }, // 6428
  { PseudoVREDOR_VS_M1_E64, VREDOR_VS, 0x0, 0x0 }, // 6429
  { PseudoVREDOR_VS_M1_E64_MASK, VREDOR_VS, 0x0, 0x0 }, // 6430
  { PseudoVREDOR_VS_M1_E8, VREDOR_VS, 0x0, 0x0 }, // 6431
  { PseudoVREDOR_VS_M1_E8_MASK, VREDOR_VS, 0x0, 0x0 }, // 6432
  { PseudoVREDOR_VS_M2_E16, VREDOR_VS, 0x1, 0x0 }, // 6433
  { PseudoVREDOR_VS_M2_E16_MASK, VREDOR_VS, 0x1, 0x0 }, // 6434
  { PseudoVREDOR_VS_M2_E32, VREDOR_VS, 0x1, 0x0 }, // 6435
  { PseudoVREDOR_VS_M2_E32_MASK, VREDOR_VS, 0x1, 0x0 }, // 6436
  { PseudoVREDOR_VS_M2_E64, VREDOR_VS, 0x1, 0x0 }, // 6437
  { PseudoVREDOR_VS_M2_E64_MASK, VREDOR_VS, 0x1, 0x0 }, // 6438
  { PseudoVREDOR_VS_M2_E8, VREDOR_VS, 0x1, 0x0 }, // 6439
  { PseudoVREDOR_VS_M2_E8_MASK, VREDOR_VS, 0x1, 0x0 }, // 6440
  { PseudoVREDOR_VS_M4_E16, VREDOR_VS, 0x2, 0x0 }, // 6441
  { PseudoVREDOR_VS_M4_E16_MASK, VREDOR_VS, 0x2, 0x0 }, // 6442
  { PseudoVREDOR_VS_M4_E32, VREDOR_VS, 0x2, 0x0 }, // 6443
  { PseudoVREDOR_VS_M4_E32_MASK, VREDOR_VS, 0x2, 0x0 }, // 6444
  { PseudoVREDOR_VS_M4_E64, VREDOR_VS, 0x2, 0x0 }, // 6445
  { PseudoVREDOR_VS_M4_E64_MASK, VREDOR_VS, 0x2, 0x0 }, // 6446
  { PseudoVREDOR_VS_M4_E8, VREDOR_VS, 0x2, 0x0 }, // 6447
  { PseudoVREDOR_VS_M4_E8_MASK, VREDOR_VS, 0x2, 0x0 }, // 6448
  { PseudoVREDOR_VS_M8_E16, VREDOR_VS, 0x3, 0x0 }, // 6449
  { PseudoVREDOR_VS_M8_E16_MASK, VREDOR_VS, 0x3, 0x0 }, // 6450
  { PseudoVREDOR_VS_M8_E32, VREDOR_VS, 0x3, 0x0 }, // 6451
  { PseudoVREDOR_VS_M8_E32_MASK, VREDOR_VS, 0x3, 0x0 }, // 6452
  { PseudoVREDOR_VS_M8_E64, VREDOR_VS, 0x3, 0x0 }, // 6453
  { PseudoVREDOR_VS_M8_E64_MASK, VREDOR_VS, 0x3, 0x0 }, // 6454
  { PseudoVREDOR_VS_M8_E8, VREDOR_VS, 0x3, 0x0 }, // 6455
  { PseudoVREDOR_VS_M8_E8_MASK, VREDOR_VS, 0x3, 0x0 }, // 6456
  { PseudoVREDOR_VS_MF8_E8, VREDOR_VS, 0x5, 0x0 }, // 6457
  { PseudoVREDOR_VS_MF8_E8_MASK, VREDOR_VS, 0x5, 0x0 }, // 6458
  { PseudoVREDOR_VS_MF4_E16, VREDOR_VS, 0x6, 0x0 }, // 6459
  { PseudoVREDOR_VS_MF4_E16_MASK, VREDOR_VS, 0x6, 0x0 }, // 6460
  { PseudoVREDOR_VS_MF4_E8, VREDOR_VS, 0x6, 0x0 }, // 6461
  { PseudoVREDOR_VS_MF4_E8_MASK, VREDOR_VS, 0x6, 0x0 }, // 6462
  { PseudoVREDOR_VS_MF2_E16, VREDOR_VS, 0x7, 0x0 }, // 6463
  { PseudoVREDOR_VS_MF2_E16_MASK, VREDOR_VS, 0x7, 0x0 }, // 6464
  { PseudoVREDOR_VS_MF2_E32, VREDOR_VS, 0x7, 0x0 }, // 6465
  { PseudoVREDOR_VS_MF2_E32_MASK, VREDOR_VS, 0x7, 0x0 }, // 6466
  { PseudoVREDOR_VS_MF2_E8, VREDOR_VS, 0x7, 0x0 }, // 6467
  { PseudoVREDOR_VS_MF2_E8_MASK, VREDOR_VS, 0x7, 0x0 }, // 6468
  { PseudoVREDSUM_VS_M1_E16, VREDSUM_VS, 0x0, 0x0 }, // 6469
  { PseudoVREDSUM_VS_M1_E16_MASK, VREDSUM_VS, 0x0, 0x0 }, // 6470
  { PseudoVREDSUM_VS_M1_E32, VREDSUM_VS, 0x0, 0x0 }, // 6471
  { PseudoVREDSUM_VS_M1_E32_MASK, VREDSUM_VS, 0x0, 0x0 }, // 6472
  { PseudoVREDSUM_VS_M1_E64, VREDSUM_VS, 0x0, 0x0 }, // 6473
  { PseudoVREDSUM_VS_M1_E64_MASK, VREDSUM_VS, 0x0, 0x0 }, // 6474
  { PseudoVREDSUM_VS_M1_E8, VREDSUM_VS, 0x0, 0x0 }, // 6475
  { PseudoVREDSUM_VS_M1_E8_MASK, VREDSUM_VS, 0x0, 0x0 }, // 6476
  { PseudoVREDSUM_VS_M2_E16, VREDSUM_VS, 0x1, 0x0 }, // 6477
  { PseudoVREDSUM_VS_M2_E16_MASK, VREDSUM_VS, 0x1, 0x0 }, // 6478
  { PseudoVREDSUM_VS_M2_E32, VREDSUM_VS, 0x1, 0x0 }, // 6479
  { PseudoVREDSUM_VS_M2_E32_MASK, VREDSUM_VS, 0x1, 0x0 }, // 6480
  { PseudoVREDSUM_VS_M2_E64, VREDSUM_VS, 0x1, 0x0 }, // 6481
  { PseudoVREDSUM_VS_M2_E64_MASK, VREDSUM_VS, 0x1, 0x0 }, // 6482
  { PseudoVREDSUM_VS_M2_E8, VREDSUM_VS, 0x1, 0x0 }, // 6483
  { PseudoVREDSUM_VS_M2_E8_MASK, VREDSUM_VS, 0x1, 0x0 }, // 6484
  { PseudoVREDSUM_VS_M4_E16, VREDSUM_VS, 0x2, 0x0 }, // 6485
  { PseudoVREDSUM_VS_M4_E16_MASK, VREDSUM_VS, 0x2, 0x0 }, // 6486
  { PseudoVREDSUM_VS_M4_E32, VREDSUM_VS, 0x2, 0x0 }, // 6487
  { PseudoVREDSUM_VS_M4_E32_MASK, VREDSUM_VS, 0x2, 0x0 }, // 6488
  { PseudoVREDSUM_VS_M4_E64, VREDSUM_VS, 0x2, 0x0 }, // 6489
  { PseudoVREDSUM_VS_M4_E64_MASK, VREDSUM_VS, 0x2, 0x0 }, // 6490
  { PseudoVREDSUM_VS_M4_E8, VREDSUM_VS, 0x2, 0x0 }, // 6491
  { PseudoVREDSUM_VS_M4_E8_MASK, VREDSUM_VS, 0x2, 0x0 }, // 6492
  { PseudoVREDSUM_VS_M8_E16, VREDSUM_VS, 0x3, 0x0 }, // 6493
  { PseudoVREDSUM_VS_M8_E16_MASK, VREDSUM_VS, 0x3, 0x0 }, // 6494
  { PseudoVREDSUM_VS_M8_E32, VREDSUM_VS, 0x3, 0x0 }, // 6495
  { PseudoVREDSUM_VS_M8_E32_MASK, VREDSUM_VS, 0x3, 0x0 }, // 6496
  { PseudoVREDSUM_VS_M8_E64, VREDSUM_VS, 0x3, 0x0 }, // 6497
  { PseudoVREDSUM_VS_M8_E64_MASK, VREDSUM_VS, 0x3, 0x0 }, // 6498
  { PseudoVREDSUM_VS_M8_E8, VREDSUM_VS, 0x3, 0x0 }, // 6499
  { PseudoVREDSUM_VS_M8_E8_MASK, VREDSUM_VS, 0x3, 0x0 }, // 6500
  { PseudoVREDSUM_VS_MF8_E8, VREDSUM_VS, 0x5, 0x0 }, // 6501
  { PseudoVREDSUM_VS_MF8_E8_MASK, VREDSUM_VS, 0x5, 0x0 }, // 6502
  { PseudoVREDSUM_VS_MF4_E16, VREDSUM_VS, 0x6, 0x0 }, // 6503
  { PseudoVREDSUM_VS_MF4_E16_MASK, VREDSUM_VS, 0x6, 0x0 }, // 6504
  { PseudoVREDSUM_VS_MF4_E8, VREDSUM_VS, 0x6, 0x0 }, // 6505
  { PseudoVREDSUM_VS_MF4_E8_MASK, VREDSUM_VS, 0x6, 0x0 }, // 6506
  { PseudoVREDSUM_VS_MF2_E16, VREDSUM_VS, 0x7, 0x0 }, // 6507
  { PseudoVREDSUM_VS_MF2_E16_MASK, VREDSUM_VS, 0x7, 0x0 }, // 6508
  { PseudoVREDSUM_VS_MF2_E32, VREDSUM_VS, 0x7, 0x0 }, // 6509
  { PseudoVREDSUM_VS_MF2_E32_MASK, VREDSUM_VS, 0x7, 0x0 }, // 6510
  { PseudoVREDSUM_VS_MF2_E8, VREDSUM_VS, 0x7, 0x0 }, // 6511
  { PseudoVREDSUM_VS_MF2_E8_MASK, VREDSUM_VS, 0x7, 0x0 }, // 6512
  { PseudoVREDXOR_VS_M1_E16, VREDXOR_VS, 0x0, 0x0 }, // 6513
  { PseudoVREDXOR_VS_M1_E16_MASK, VREDXOR_VS, 0x0, 0x0 }, // 6514
  { PseudoVREDXOR_VS_M1_E32, VREDXOR_VS, 0x0, 0x0 }, // 6515
  { PseudoVREDXOR_VS_M1_E32_MASK, VREDXOR_VS, 0x0, 0x0 }, // 6516
  { PseudoVREDXOR_VS_M1_E64, VREDXOR_VS, 0x0, 0x0 }, // 6517
  { PseudoVREDXOR_VS_M1_E64_MASK, VREDXOR_VS, 0x0, 0x0 }, // 6518
  { PseudoVREDXOR_VS_M1_E8, VREDXOR_VS, 0x0, 0x0 }, // 6519
  { PseudoVREDXOR_VS_M1_E8_MASK, VREDXOR_VS, 0x0, 0x0 }, // 6520
  { PseudoVREDXOR_VS_M2_E16, VREDXOR_VS, 0x1, 0x0 }, // 6521
  { PseudoVREDXOR_VS_M2_E16_MASK, VREDXOR_VS, 0x1, 0x0 }, // 6522
  { PseudoVREDXOR_VS_M2_E32, VREDXOR_VS, 0x1, 0x0 }, // 6523
  { PseudoVREDXOR_VS_M2_E32_MASK, VREDXOR_VS, 0x1, 0x0 }, // 6524
  { PseudoVREDXOR_VS_M2_E64, VREDXOR_VS, 0x1, 0x0 }, // 6525
  { PseudoVREDXOR_VS_M2_E64_MASK, VREDXOR_VS, 0x1, 0x0 }, // 6526
  { PseudoVREDXOR_VS_M2_E8, VREDXOR_VS, 0x1, 0x0 }, // 6527
  { PseudoVREDXOR_VS_M2_E8_MASK, VREDXOR_VS, 0x1, 0x0 }, // 6528
  { PseudoVREDXOR_VS_M4_E16, VREDXOR_VS, 0x2, 0x0 }, // 6529
  { PseudoVREDXOR_VS_M4_E16_MASK, VREDXOR_VS, 0x2, 0x0 }, // 6530
  { PseudoVREDXOR_VS_M4_E32, VREDXOR_VS, 0x2, 0x0 }, // 6531
  { PseudoVREDXOR_VS_M4_E32_MASK, VREDXOR_VS, 0x2, 0x0 }, // 6532
  { PseudoVREDXOR_VS_M4_E64, VREDXOR_VS, 0x2, 0x0 }, // 6533
  { PseudoVREDXOR_VS_M4_E64_MASK, VREDXOR_VS, 0x2, 0x0 }, // 6534
  { PseudoVREDXOR_VS_M4_E8, VREDXOR_VS, 0x2, 0x0 }, // 6535
  { PseudoVREDXOR_VS_M4_E8_MASK, VREDXOR_VS, 0x2, 0x0 }, // 6536
  { PseudoVREDXOR_VS_M8_E16, VREDXOR_VS, 0x3, 0x0 }, // 6537
  { PseudoVREDXOR_VS_M8_E16_MASK, VREDXOR_VS, 0x3, 0x0 }, // 6538
  { PseudoVREDXOR_VS_M8_E32, VREDXOR_VS, 0x3, 0x0 }, // 6539
  { PseudoVREDXOR_VS_M8_E32_MASK, VREDXOR_VS, 0x3, 0x0 }, // 6540
  { PseudoVREDXOR_VS_M8_E64, VREDXOR_VS, 0x3, 0x0 }, // 6541
  { PseudoVREDXOR_VS_M8_E64_MASK, VREDXOR_VS, 0x3, 0x0 }, // 6542
  { PseudoVREDXOR_VS_M8_E8, VREDXOR_VS, 0x3, 0x0 }, // 6543
  { PseudoVREDXOR_VS_M8_E8_MASK, VREDXOR_VS, 0x3, 0x0 }, // 6544
  { PseudoVREDXOR_VS_MF8_E8, VREDXOR_VS, 0x5, 0x0 }, // 6545
  { PseudoVREDXOR_VS_MF8_E8_MASK, VREDXOR_VS, 0x5, 0x0 }, // 6546
  { PseudoVREDXOR_VS_MF4_E16, VREDXOR_VS, 0x6, 0x0 }, // 6547
  { PseudoVREDXOR_VS_MF4_E16_MASK, VREDXOR_VS, 0x6, 0x0 }, // 6548
  { PseudoVREDXOR_VS_MF4_E8, VREDXOR_VS, 0x6, 0x0 }, // 6549
  { PseudoVREDXOR_VS_MF4_E8_MASK, VREDXOR_VS, 0x6, 0x0 }, // 6550
  { PseudoVREDXOR_VS_MF2_E16, VREDXOR_VS, 0x7, 0x0 }, // 6551
  { PseudoVREDXOR_VS_MF2_E16_MASK, VREDXOR_VS, 0x7, 0x0 }, // 6552
  { PseudoVREDXOR_VS_MF2_E32, VREDXOR_VS, 0x7, 0x0 }, // 6553
  { PseudoVREDXOR_VS_MF2_E32_MASK, VREDXOR_VS, 0x7, 0x0 }, // 6554
  { PseudoVREDXOR_VS_MF2_E8, VREDXOR_VS, 0x7, 0x0 }, // 6555
  { PseudoVREDXOR_VS_MF2_E8_MASK, VREDXOR_VS, 0x7, 0x0 }, // 6556
  { PseudoVREMU_VV_M1_E8, VREMU_VV, 0x0, 0x8 }, // 6557
  { PseudoVREMU_VV_M1_E8_MASK, VREMU_VV, 0x0, 0x8 }, // 6558
  { PseudoVREMU_VV_M1_E16, VREMU_VV, 0x0, 0x10 }, // 6559
  { PseudoVREMU_VV_M1_E16_MASK, VREMU_VV, 0x0, 0x10 }, // 6560
  { PseudoVREMU_VV_M1_E32, VREMU_VV, 0x0, 0x20 }, // 6561
  { PseudoVREMU_VV_M1_E32_MASK, VREMU_VV, 0x0, 0x20 }, // 6562
  { PseudoVREMU_VV_M1_E64, VREMU_VV, 0x0, 0x40 }, // 6563
  { PseudoVREMU_VV_M1_E64_MASK, VREMU_VV, 0x0, 0x40 }, // 6564
  { PseudoVREMU_VV_M2_E8, VREMU_VV, 0x1, 0x8 }, // 6565
  { PseudoVREMU_VV_M2_E8_MASK, VREMU_VV, 0x1, 0x8 }, // 6566
  { PseudoVREMU_VV_M2_E16, VREMU_VV, 0x1, 0x10 }, // 6567
  { PseudoVREMU_VV_M2_E16_MASK, VREMU_VV, 0x1, 0x10 }, // 6568
  { PseudoVREMU_VV_M2_E32, VREMU_VV, 0x1, 0x20 }, // 6569
  { PseudoVREMU_VV_M2_E32_MASK, VREMU_VV, 0x1, 0x20 }, // 6570
  { PseudoVREMU_VV_M2_E64, VREMU_VV, 0x1, 0x40 }, // 6571
  { PseudoVREMU_VV_M2_E64_MASK, VREMU_VV, 0x1, 0x40 }, // 6572
  { PseudoVREMU_VV_M4_E8, VREMU_VV, 0x2, 0x8 }, // 6573
  { PseudoVREMU_VV_M4_E8_MASK, VREMU_VV, 0x2, 0x8 }, // 6574
  { PseudoVREMU_VV_M4_E16, VREMU_VV, 0x2, 0x10 }, // 6575
  { PseudoVREMU_VV_M4_E16_MASK, VREMU_VV, 0x2, 0x10 }, // 6576
  { PseudoVREMU_VV_M4_E32, VREMU_VV, 0x2, 0x20 }, // 6577
  { PseudoVREMU_VV_M4_E32_MASK, VREMU_VV, 0x2, 0x20 }, // 6578
  { PseudoVREMU_VV_M4_E64, VREMU_VV, 0x2, 0x40 }, // 6579
  { PseudoVREMU_VV_M4_E64_MASK, VREMU_VV, 0x2, 0x40 }, // 6580
  { PseudoVREMU_VV_M8_E8, VREMU_VV, 0x3, 0x8 }, // 6581
  { PseudoVREMU_VV_M8_E8_MASK, VREMU_VV, 0x3, 0x8 }, // 6582
  { PseudoVREMU_VV_M8_E16, VREMU_VV, 0x3, 0x10 }, // 6583
  { PseudoVREMU_VV_M8_E16_MASK, VREMU_VV, 0x3, 0x10 }, // 6584
  { PseudoVREMU_VV_M8_E32, VREMU_VV, 0x3, 0x20 }, // 6585
  { PseudoVREMU_VV_M8_E32_MASK, VREMU_VV, 0x3, 0x20 }, // 6586
  { PseudoVREMU_VV_M8_E64, VREMU_VV, 0x3, 0x40 }, // 6587
  { PseudoVREMU_VV_M8_E64_MASK, VREMU_VV, 0x3, 0x40 }, // 6588
  { PseudoVREMU_VV_MF8_E8, VREMU_VV, 0x5, 0x8 }, // 6589
  { PseudoVREMU_VV_MF8_E8_MASK, VREMU_VV, 0x5, 0x8 }, // 6590
  { PseudoVREMU_VV_MF4_E8, VREMU_VV, 0x6, 0x8 }, // 6591
  { PseudoVREMU_VV_MF4_E8_MASK, VREMU_VV, 0x6, 0x8 }, // 6592
  { PseudoVREMU_VV_MF4_E16, VREMU_VV, 0x6, 0x10 }, // 6593
  { PseudoVREMU_VV_MF4_E16_MASK, VREMU_VV, 0x6, 0x10 }, // 6594
  { PseudoVREMU_VV_MF2_E8, VREMU_VV, 0x7, 0x8 }, // 6595
  { PseudoVREMU_VV_MF2_E8_MASK, VREMU_VV, 0x7, 0x8 }, // 6596
  { PseudoVREMU_VV_MF2_E16, VREMU_VV, 0x7, 0x10 }, // 6597
  { PseudoVREMU_VV_MF2_E16_MASK, VREMU_VV, 0x7, 0x10 }, // 6598
  { PseudoVREMU_VV_MF2_E32, VREMU_VV, 0x7, 0x20 }, // 6599
  { PseudoVREMU_VV_MF2_E32_MASK, VREMU_VV, 0x7, 0x20 }, // 6600
  { PseudoVREMU_VX_M1_E8, VREMU_VX, 0x0, 0x8 }, // 6601
  { PseudoVREMU_VX_M1_E8_MASK, VREMU_VX, 0x0, 0x8 }, // 6602
  { PseudoVREMU_VX_M1_E16, VREMU_VX, 0x0, 0x10 }, // 6603
  { PseudoVREMU_VX_M1_E16_MASK, VREMU_VX, 0x0, 0x10 }, // 6604
  { PseudoVREMU_VX_M1_E32, VREMU_VX, 0x0, 0x20 }, // 6605
  { PseudoVREMU_VX_M1_E32_MASK, VREMU_VX, 0x0, 0x20 }, // 6606
  { PseudoVREMU_VX_M1_E64, VREMU_VX, 0x0, 0x40 }, // 6607
  { PseudoVREMU_VX_M1_E64_MASK, VREMU_VX, 0x0, 0x40 }, // 6608
  { PseudoVREMU_VX_M2_E8, VREMU_VX, 0x1, 0x8 }, // 6609
  { PseudoVREMU_VX_M2_E8_MASK, VREMU_VX, 0x1, 0x8 }, // 6610
  { PseudoVREMU_VX_M2_E16, VREMU_VX, 0x1, 0x10 }, // 6611
  { PseudoVREMU_VX_M2_E16_MASK, VREMU_VX, 0x1, 0x10 }, // 6612
  { PseudoVREMU_VX_M2_E32, VREMU_VX, 0x1, 0x20 }, // 6613
  { PseudoVREMU_VX_M2_E32_MASK, VREMU_VX, 0x1, 0x20 }, // 6614
  { PseudoVREMU_VX_M2_E64, VREMU_VX, 0x1, 0x40 }, // 6615
  { PseudoVREMU_VX_M2_E64_MASK, VREMU_VX, 0x1, 0x40 }, // 6616
  { PseudoVREMU_VX_M4_E8, VREMU_VX, 0x2, 0x8 }, // 6617
  { PseudoVREMU_VX_M4_E8_MASK, VREMU_VX, 0x2, 0x8 }, // 6618
  { PseudoVREMU_VX_M4_E16, VREMU_VX, 0x2, 0x10 }, // 6619
  { PseudoVREMU_VX_M4_E16_MASK, VREMU_VX, 0x2, 0x10 }, // 6620
  { PseudoVREMU_VX_M4_E32, VREMU_VX, 0x2, 0x20 }, // 6621
  { PseudoVREMU_VX_M4_E32_MASK, VREMU_VX, 0x2, 0x20 }, // 6622
  { PseudoVREMU_VX_M4_E64, VREMU_VX, 0x2, 0x40 }, // 6623
  { PseudoVREMU_VX_M4_E64_MASK, VREMU_VX, 0x2, 0x40 }, // 6624
  { PseudoVREMU_VX_M8_E8, VREMU_VX, 0x3, 0x8 }, // 6625
  { PseudoVREMU_VX_M8_E8_MASK, VREMU_VX, 0x3, 0x8 }, // 6626
  { PseudoVREMU_VX_M8_E16, VREMU_VX, 0x3, 0x10 }, // 6627
  { PseudoVREMU_VX_M8_E16_MASK, VREMU_VX, 0x3, 0x10 }, // 6628
  { PseudoVREMU_VX_M8_E32, VREMU_VX, 0x3, 0x20 }, // 6629
  { PseudoVREMU_VX_M8_E32_MASK, VREMU_VX, 0x3, 0x20 }, // 6630
  { PseudoVREMU_VX_M8_E64, VREMU_VX, 0x3, 0x40 }, // 6631
  { PseudoVREMU_VX_M8_E64_MASK, VREMU_VX, 0x3, 0x40 }, // 6632
  { PseudoVREMU_VX_MF8_E8, VREMU_VX, 0x5, 0x8 }, // 6633
  { PseudoVREMU_VX_MF8_E8_MASK, VREMU_VX, 0x5, 0x8 }, // 6634
  { PseudoVREMU_VX_MF4_E8, VREMU_VX, 0x6, 0x8 }, // 6635
  { PseudoVREMU_VX_MF4_E8_MASK, VREMU_VX, 0x6, 0x8 }, // 6636
  { PseudoVREMU_VX_MF4_E16, VREMU_VX, 0x6, 0x10 }, // 6637
  { PseudoVREMU_VX_MF4_E16_MASK, VREMU_VX, 0x6, 0x10 }, // 6638
  { PseudoVREMU_VX_MF2_E8, VREMU_VX, 0x7, 0x8 }, // 6639
  { PseudoVREMU_VX_MF2_E8_MASK, VREMU_VX, 0x7, 0x8 }, // 6640
  { PseudoVREMU_VX_MF2_E16, VREMU_VX, 0x7, 0x10 }, // 6641
  { PseudoVREMU_VX_MF2_E16_MASK, VREMU_VX, 0x7, 0x10 }, // 6642
  { PseudoVREMU_VX_MF2_E32, VREMU_VX, 0x7, 0x20 }, // 6643
  { PseudoVREMU_VX_MF2_E32_MASK, VREMU_VX, 0x7, 0x20 }, // 6644
  { PseudoVREM_VV_M1_E8, VREM_VV, 0x0, 0x8 }, // 6645
  { PseudoVREM_VV_M1_E8_MASK, VREM_VV, 0x0, 0x8 }, // 6646
  { PseudoVREM_VV_M1_E16, VREM_VV, 0x0, 0x10 }, // 6647
  { PseudoVREM_VV_M1_E16_MASK, VREM_VV, 0x0, 0x10 }, // 6648
  { PseudoVREM_VV_M1_E32, VREM_VV, 0x0, 0x20 }, // 6649
  { PseudoVREM_VV_M1_E32_MASK, VREM_VV, 0x0, 0x20 }, // 6650
  { PseudoVREM_VV_M1_E64, VREM_VV, 0x0, 0x40 }, // 6651
  { PseudoVREM_VV_M1_E64_MASK, VREM_VV, 0x0, 0x40 }, // 6652
  { PseudoVREM_VV_M2_E8, VREM_VV, 0x1, 0x8 }, // 6653
  { PseudoVREM_VV_M2_E8_MASK, VREM_VV, 0x1, 0x8 }, // 6654
  { PseudoVREM_VV_M2_E16, VREM_VV, 0x1, 0x10 }, // 6655
  { PseudoVREM_VV_M2_E16_MASK, VREM_VV, 0x1, 0x10 }, // 6656
  { PseudoVREM_VV_M2_E32, VREM_VV, 0x1, 0x20 }, // 6657
  { PseudoVREM_VV_M2_E32_MASK, VREM_VV, 0x1, 0x20 }, // 6658
  { PseudoVREM_VV_M2_E64, VREM_VV, 0x1, 0x40 }, // 6659
  { PseudoVREM_VV_M2_E64_MASK, VREM_VV, 0x1, 0x40 }, // 6660
  { PseudoVREM_VV_M4_E8, VREM_VV, 0x2, 0x8 }, // 6661
  { PseudoVREM_VV_M4_E8_MASK, VREM_VV, 0x2, 0x8 }, // 6662
  { PseudoVREM_VV_M4_E16, VREM_VV, 0x2, 0x10 }, // 6663
  { PseudoVREM_VV_M4_E16_MASK, VREM_VV, 0x2, 0x10 }, // 6664
  { PseudoVREM_VV_M4_E32, VREM_VV, 0x2, 0x20 }, // 6665
  { PseudoVREM_VV_M4_E32_MASK, VREM_VV, 0x2, 0x20 }, // 6666
  { PseudoVREM_VV_M4_E64, VREM_VV, 0x2, 0x40 }, // 6667
  { PseudoVREM_VV_M4_E64_MASK, VREM_VV, 0x2, 0x40 }, // 6668
  { PseudoVREM_VV_M8_E8, VREM_VV, 0x3, 0x8 }, // 6669
  { PseudoVREM_VV_M8_E8_MASK, VREM_VV, 0x3, 0x8 }, // 6670
  { PseudoVREM_VV_M8_E16, VREM_VV, 0x3, 0x10 }, // 6671
  { PseudoVREM_VV_M8_E16_MASK, VREM_VV, 0x3, 0x10 }, // 6672
  { PseudoVREM_VV_M8_E32, VREM_VV, 0x3, 0x20 }, // 6673
  { PseudoVREM_VV_M8_E32_MASK, VREM_VV, 0x3, 0x20 }, // 6674
  { PseudoVREM_VV_M8_E64, VREM_VV, 0x3, 0x40 }, // 6675
  { PseudoVREM_VV_M8_E64_MASK, VREM_VV, 0x3, 0x40 }, // 6676
  { PseudoVREM_VV_MF8_E8, VREM_VV, 0x5, 0x8 }, // 6677
  { PseudoVREM_VV_MF8_E8_MASK, VREM_VV, 0x5, 0x8 }, // 6678
  { PseudoVREM_VV_MF4_E8, VREM_VV, 0x6, 0x8 }, // 6679
  { PseudoVREM_VV_MF4_E8_MASK, VREM_VV, 0x6, 0x8 }, // 6680
  { PseudoVREM_VV_MF4_E16, VREM_VV, 0x6, 0x10 }, // 6681
  { PseudoVREM_VV_MF4_E16_MASK, VREM_VV, 0x6, 0x10 }, // 6682
  { PseudoVREM_VV_MF2_E8, VREM_VV, 0x7, 0x8 }, // 6683
  { PseudoVREM_VV_MF2_E8_MASK, VREM_VV, 0x7, 0x8 }, // 6684
  { PseudoVREM_VV_MF2_E16, VREM_VV, 0x7, 0x10 }, // 6685
  { PseudoVREM_VV_MF2_E16_MASK, VREM_VV, 0x7, 0x10 }, // 6686
  { PseudoVREM_VV_MF2_E32, VREM_VV, 0x7, 0x20 }, // 6687
  { PseudoVREM_VV_MF2_E32_MASK, VREM_VV, 0x7, 0x20 }, // 6688
  { PseudoVREM_VX_M1_E8, VREM_VX, 0x0, 0x8 }, // 6689
  { PseudoVREM_VX_M1_E8_MASK, VREM_VX, 0x0, 0x8 }, // 6690
  { PseudoVREM_VX_M1_E16, VREM_VX, 0x0, 0x10 }, // 6691
  { PseudoVREM_VX_M1_E16_MASK, VREM_VX, 0x0, 0x10 }, // 6692
  { PseudoVREM_VX_M1_E32, VREM_VX, 0x0, 0x20 }, // 6693
  { PseudoVREM_VX_M1_E32_MASK, VREM_VX, 0x0, 0x20 }, // 6694
  { PseudoVREM_VX_M1_E64, VREM_VX, 0x0, 0x40 }, // 6695
  { PseudoVREM_VX_M1_E64_MASK, VREM_VX, 0x0, 0x40 }, // 6696
  { PseudoVREM_VX_M2_E8, VREM_VX, 0x1, 0x8 }, // 6697
  { PseudoVREM_VX_M2_E8_MASK, VREM_VX, 0x1, 0x8 }, // 6698
  { PseudoVREM_VX_M2_E16, VREM_VX, 0x1, 0x10 }, // 6699
  { PseudoVREM_VX_M2_E16_MASK, VREM_VX, 0x1, 0x10 }, // 6700
  { PseudoVREM_VX_M2_E32, VREM_VX, 0x1, 0x20 }, // 6701
  { PseudoVREM_VX_M2_E32_MASK, VREM_VX, 0x1, 0x20 }, // 6702
  { PseudoVREM_VX_M2_E64, VREM_VX, 0x1, 0x40 }, // 6703
  { PseudoVREM_VX_M2_E64_MASK, VREM_VX, 0x1, 0x40 }, // 6704
  { PseudoVREM_VX_M4_E8, VREM_VX, 0x2, 0x8 }, // 6705
  { PseudoVREM_VX_M4_E8_MASK, VREM_VX, 0x2, 0x8 }, // 6706
  { PseudoVREM_VX_M4_E16, VREM_VX, 0x2, 0x10 }, // 6707
  { PseudoVREM_VX_M4_E16_MASK, VREM_VX, 0x2, 0x10 }, // 6708
  { PseudoVREM_VX_M4_E32, VREM_VX, 0x2, 0x20 }, // 6709
  { PseudoVREM_VX_M4_E32_MASK, VREM_VX, 0x2, 0x20 }, // 6710
  { PseudoVREM_VX_M4_E64, VREM_VX, 0x2, 0x40 }, // 6711
  { PseudoVREM_VX_M4_E64_MASK, VREM_VX, 0x2, 0x40 }, // 6712
  { PseudoVREM_VX_M8_E8, VREM_VX, 0x3, 0x8 }, // 6713
  { PseudoVREM_VX_M8_E8_MASK, VREM_VX, 0x3, 0x8 }, // 6714
  { PseudoVREM_VX_M8_E16, VREM_VX, 0x3, 0x10 }, // 6715
  { PseudoVREM_VX_M8_E16_MASK, VREM_VX, 0x3, 0x10 }, // 6716
  { PseudoVREM_VX_M8_E32, VREM_VX, 0x3, 0x20 }, // 6717
  { PseudoVREM_VX_M8_E32_MASK, VREM_VX, 0x3, 0x20 }, // 6718
  { PseudoVREM_VX_M8_E64, VREM_VX, 0x3, 0x40 }, // 6719
  { PseudoVREM_VX_M8_E64_MASK, VREM_VX, 0x3, 0x40 }, // 6720
  { PseudoVREM_VX_MF8_E8, VREM_VX, 0x5, 0x8 }, // 6721
  { PseudoVREM_VX_MF8_E8_MASK, VREM_VX, 0x5, 0x8 }, // 6722
  { PseudoVREM_VX_MF4_E8, VREM_VX, 0x6, 0x8 }, // 6723
  { PseudoVREM_VX_MF4_E8_MASK, VREM_VX, 0x6, 0x8 }, // 6724
  { PseudoVREM_VX_MF4_E16, VREM_VX, 0x6, 0x10 }, // 6725
  { PseudoVREM_VX_MF4_E16_MASK, VREM_VX, 0x6, 0x10 }, // 6726
  { PseudoVREM_VX_MF2_E8, VREM_VX, 0x7, 0x8 }, // 6727
  { PseudoVREM_VX_MF2_E8_MASK, VREM_VX, 0x7, 0x8 }, // 6728
  { PseudoVREM_VX_MF2_E16, VREM_VX, 0x7, 0x10 }, // 6729
  { PseudoVREM_VX_MF2_E16_MASK, VREM_VX, 0x7, 0x10 }, // 6730
  { PseudoVREM_VX_MF2_E32, VREM_VX, 0x7, 0x20 }, // 6731
  { PseudoVREM_VX_MF2_E32_MASK, VREM_VX, 0x7, 0x20 }, // 6732
  { PseudoVREV8_V_M1, VREV8_V, 0x0, 0x0 }, // 6733
  { PseudoVREV8_V_M1_MASK, VREV8_V, 0x0, 0x0 }, // 6734
  { PseudoVREV8_V_M2, VREV8_V, 0x1, 0x0 }, // 6735
  { PseudoVREV8_V_M2_MASK, VREV8_V, 0x1, 0x0 }, // 6736
  { PseudoVREV8_V_M4, VREV8_V, 0x2, 0x0 }, // 6737
  { PseudoVREV8_V_M4_MASK, VREV8_V, 0x2, 0x0 }, // 6738
  { PseudoVREV8_V_M8, VREV8_V, 0x3, 0x0 }, // 6739
  { PseudoVREV8_V_M8_MASK, VREV8_V, 0x3, 0x0 }, // 6740
  { PseudoVREV8_V_MF8, VREV8_V, 0x5, 0x0 }, // 6741
  { PseudoVREV8_V_MF8_MASK, VREV8_V, 0x5, 0x0 }, // 6742
  { PseudoVREV8_V_MF4, VREV8_V, 0x6, 0x0 }, // 6743
  { PseudoVREV8_V_MF4_MASK, VREV8_V, 0x6, 0x0 }, // 6744
  { PseudoVREV8_V_MF2, VREV8_V, 0x7, 0x0 }, // 6745
  { PseudoVREV8_V_MF2_MASK, VREV8_V, 0x7, 0x0 }, // 6746
  { PseudoVRGATHEREI16_VV_M1_E8_M1, VRGATHEREI16_VV, 0x0, 0x8 }, // 6747
  { PseudoVRGATHEREI16_VV_M1_E8_M1_MASK, VRGATHEREI16_VV, 0x0, 0x8 }, // 6748
  { PseudoVRGATHEREI16_VV_M1_E8_M2, VRGATHEREI16_VV, 0x0, 0x8 }, // 6749
  { PseudoVRGATHEREI16_VV_M1_E8_M2_MASK, VRGATHEREI16_VV, 0x0, 0x8 }, // 6750
  { PseudoVRGATHEREI16_VV_M1_E8_MF2, VRGATHEREI16_VV, 0x0, 0x8 }, // 6751
  { PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK, VRGATHEREI16_VV, 0x0, 0x8 }, // 6752
  { PseudoVRGATHEREI16_VV_M1_E8_MF4, VRGATHEREI16_VV, 0x0, 0x8 }, // 6753
  { PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK, VRGATHEREI16_VV, 0x0, 0x8 }, // 6754
  { PseudoVRGATHEREI16_VV_M1_E16_M1, VRGATHEREI16_VV, 0x0, 0x10 }, // 6755
  { PseudoVRGATHEREI16_VV_M1_E16_M1_MASK, VRGATHEREI16_VV, 0x0, 0x10 }, // 6756
  { PseudoVRGATHEREI16_VV_M1_E16_M2, VRGATHEREI16_VV, 0x0, 0x10 }, // 6757
  { PseudoVRGATHEREI16_VV_M1_E16_M2_MASK, VRGATHEREI16_VV, 0x0, 0x10 }, // 6758
  { PseudoVRGATHEREI16_VV_M1_E16_MF2, VRGATHEREI16_VV, 0x0, 0x10 }, // 6759
  { PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK, VRGATHEREI16_VV, 0x0, 0x10 }, // 6760
  { PseudoVRGATHEREI16_VV_M1_E16_MF4, VRGATHEREI16_VV, 0x0, 0x10 }, // 6761
  { PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK, VRGATHEREI16_VV, 0x0, 0x10 }, // 6762
  { PseudoVRGATHEREI16_VV_M1_E32_M1, VRGATHEREI16_VV, 0x0, 0x20 }, // 6763
  { PseudoVRGATHEREI16_VV_M1_E32_M1_MASK, VRGATHEREI16_VV, 0x0, 0x20 }, // 6764
  { PseudoVRGATHEREI16_VV_M1_E32_M2, VRGATHEREI16_VV, 0x0, 0x20 }, // 6765
  { PseudoVRGATHEREI16_VV_M1_E32_M2_MASK, VRGATHEREI16_VV, 0x0, 0x20 }, // 6766
  { PseudoVRGATHEREI16_VV_M1_E32_MF2, VRGATHEREI16_VV, 0x0, 0x20 }, // 6767
  { PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK, VRGATHEREI16_VV, 0x0, 0x20 }, // 6768
  { PseudoVRGATHEREI16_VV_M1_E32_MF4, VRGATHEREI16_VV, 0x0, 0x20 }, // 6769
  { PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK, VRGATHEREI16_VV, 0x0, 0x20 }, // 6770
  { PseudoVRGATHEREI16_VV_M1_E64_M1, VRGATHEREI16_VV, 0x0, 0x40 }, // 6771
  { PseudoVRGATHEREI16_VV_M1_E64_M1_MASK, VRGATHEREI16_VV, 0x0, 0x40 }, // 6772
  { PseudoVRGATHEREI16_VV_M1_E64_M2, VRGATHEREI16_VV, 0x0, 0x40 }, // 6773
  { PseudoVRGATHEREI16_VV_M1_E64_M2_MASK, VRGATHEREI16_VV, 0x0, 0x40 }, // 6774
  { PseudoVRGATHEREI16_VV_M1_E64_MF2, VRGATHEREI16_VV, 0x0, 0x40 }, // 6775
  { PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK, VRGATHEREI16_VV, 0x0, 0x40 }, // 6776
  { PseudoVRGATHEREI16_VV_M1_E64_MF4, VRGATHEREI16_VV, 0x0, 0x40 }, // 6777
  { PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK, VRGATHEREI16_VV, 0x0, 0x40 }, // 6778
  { PseudoVRGATHEREI16_VV_M2_E8_M1, VRGATHEREI16_VV, 0x1, 0x8 }, // 6779
  { PseudoVRGATHEREI16_VV_M2_E8_M1_MASK, VRGATHEREI16_VV, 0x1, 0x8 }, // 6780
  { PseudoVRGATHEREI16_VV_M2_E8_M2, VRGATHEREI16_VV, 0x1, 0x8 }, // 6781
  { PseudoVRGATHEREI16_VV_M2_E8_M2_MASK, VRGATHEREI16_VV, 0x1, 0x8 }, // 6782
  { PseudoVRGATHEREI16_VV_M2_E8_M4, VRGATHEREI16_VV, 0x1, 0x8 }, // 6783
  { PseudoVRGATHEREI16_VV_M2_E8_M4_MASK, VRGATHEREI16_VV, 0x1, 0x8 }, // 6784
  { PseudoVRGATHEREI16_VV_M2_E8_MF2, VRGATHEREI16_VV, 0x1, 0x8 }, // 6785
  { PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK, VRGATHEREI16_VV, 0x1, 0x8 }, // 6786
  { PseudoVRGATHEREI16_VV_M2_E16_M1, VRGATHEREI16_VV, 0x1, 0x10 }, // 6787
  { PseudoVRGATHEREI16_VV_M2_E16_M1_MASK, VRGATHEREI16_VV, 0x1, 0x10 }, // 6788
  { PseudoVRGATHEREI16_VV_M2_E16_M2, VRGATHEREI16_VV, 0x1, 0x10 }, // 6789
  { PseudoVRGATHEREI16_VV_M2_E16_M2_MASK, VRGATHEREI16_VV, 0x1, 0x10 }, // 6790
  { PseudoVRGATHEREI16_VV_M2_E16_M4, VRGATHEREI16_VV, 0x1, 0x10 }, // 6791
  { PseudoVRGATHEREI16_VV_M2_E16_M4_MASK, VRGATHEREI16_VV, 0x1, 0x10 }, // 6792
  { PseudoVRGATHEREI16_VV_M2_E16_MF2, VRGATHEREI16_VV, 0x1, 0x10 }, // 6793
  { PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK, VRGATHEREI16_VV, 0x1, 0x10 }, // 6794
  { PseudoVRGATHEREI16_VV_M2_E32_M1, VRGATHEREI16_VV, 0x1, 0x20 }, // 6795
  { PseudoVRGATHEREI16_VV_M2_E32_M1_MASK, VRGATHEREI16_VV, 0x1, 0x20 }, // 6796
  { PseudoVRGATHEREI16_VV_M2_E32_M2, VRGATHEREI16_VV, 0x1, 0x20 }, // 6797
  { PseudoVRGATHEREI16_VV_M2_E32_M2_MASK, VRGATHEREI16_VV, 0x1, 0x20 }, // 6798
  { PseudoVRGATHEREI16_VV_M2_E32_M4, VRGATHEREI16_VV, 0x1, 0x20 }, // 6799
  { PseudoVRGATHEREI16_VV_M2_E32_M4_MASK, VRGATHEREI16_VV, 0x1, 0x20 }, // 6800
  { PseudoVRGATHEREI16_VV_M2_E32_MF2, VRGATHEREI16_VV, 0x1, 0x20 }, // 6801
  { PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK, VRGATHEREI16_VV, 0x1, 0x20 }, // 6802
  { PseudoVRGATHEREI16_VV_M2_E64_M1, VRGATHEREI16_VV, 0x1, 0x40 }, // 6803
  { PseudoVRGATHEREI16_VV_M2_E64_M1_MASK, VRGATHEREI16_VV, 0x1, 0x40 }, // 6804
  { PseudoVRGATHEREI16_VV_M2_E64_M2, VRGATHEREI16_VV, 0x1, 0x40 }, // 6805
  { PseudoVRGATHEREI16_VV_M2_E64_M2_MASK, VRGATHEREI16_VV, 0x1, 0x40 }, // 6806
  { PseudoVRGATHEREI16_VV_M2_E64_M4, VRGATHEREI16_VV, 0x1, 0x40 }, // 6807
  { PseudoVRGATHEREI16_VV_M2_E64_M4_MASK, VRGATHEREI16_VV, 0x1, 0x40 }, // 6808
  { PseudoVRGATHEREI16_VV_M2_E64_MF2, VRGATHEREI16_VV, 0x1, 0x40 }, // 6809
  { PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK, VRGATHEREI16_VV, 0x1, 0x40 }, // 6810
  { PseudoVRGATHEREI16_VV_M4_E8_M1, VRGATHEREI16_VV, 0x2, 0x8 }, // 6811
  { PseudoVRGATHEREI16_VV_M4_E8_M1_MASK, VRGATHEREI16_VV, 0x2, 0x8 }, // 6812
  { PseudoVRGATHEREI16_VV_M4_E8_M2, VRGATHEREI16_VV, 0x2, 0x8 }, // 6813
  { PseudoVRGATHEREI16_VV_M4_E8_M2_MASK, VRGATHEREI16_VV, 0x2, 0x8 }, // 6814
  { PseudoVRGATHEREI16_VV_M4_E8_M4, VRGATHEREI16_VV, 0x2, 0x8 }, // 6815
  { PseudoVRGATHEREI16_VV_M4_E8_M4_MASK, VRGATHEREI16_VV, 0x2, 0x8 }, // 6816
  { PseudoVRGATHEREI16_VV_M4_E8_M8, VRGATHEREI16_VV, 0x2, 0x8 }, // 6817
  { PseudoVRGATHEREI16_VV_M4_E8_M8_MASK, VRGATHEREI16_VV, 0x2, 0x8 }, // 6818
  { PseudoVRGATHEREI16_VV_M4_E16_M1, VRGATHEREI16_VV, 0x2, 0x10 }, // 6819
  { PseudoVRGATHEREI16_VV_M4_E16_M1_MASK, VRGATHEREI16_VV, 0x2, 0x10 }, // 6820
  { PseudoVRGATHEREI16_VV_M4_E16_M2, VRGATHEREI16_VV, 0x2, 0x10 }, // 6821
  { PseudoVRGATHEREI16_VV_M4_E16_M2_MASK, VRGATHEREI16_VV, 0x2, 0x10 }, // 6822
  { PseudoVRGATHEREI16_VV_M4_E16_M4, VRGATHEREI16_VV, 0x2, 0x10 }, // 6823
  { PseudoVRGATHEREI16_VV_M4_E16_M4_MASK, VRGATHEREI16_VV, 0x2, 0x10 }, // 6824
  { PseudoVRGATHEREI16_VV_M4_E16_M8, VRGATHEREI16_VV, 0x2, 0x10 }, // 6825
  { PseudoVRGATHEREI16_VV_M4_E16_M8_MASK, VRGATHEREI16_VV, 0x2, 0x10 }, // 6826
  { PseudoVRGATHEREI16_VV_M4_E32_M1, VRGATHEREI16_VV, 0x2, 0x20 }, // 6827
  { PseudoVRGATHEREI16_VV_M4_E32_M1_MASK, VRGATHEREI16_VV, 0x2, 0x20 }, // 6828
  { PseudoVRGATHEREI16_VV_M4_E32_M2, VRGATHEREI16_VV, 0x2, 0x20 }, // 6829
  { PseudoVRGATHEREI16_VV_M4_E32_M2_MASK, VRGATHEREI16_VV, 0x2, 0x20 }, // 6830
  { PseudoVRGATHEREI16_VV_M4_E32_M4, VRGATHEREI16_VV, 0x2, 0x20 }, // 6831
  { PseudoVRGATHEREI16_VV_M4_E32_M4_MASK, VRGATHEREI16_VV, 0x2, 0x20 }, // 6832
  { PseudoVRGATHEREI16_VV_M4_E32_M8, VRGATHEREI16_VV, 0x2, 0x20 }, // 6833
  { PseudoVRGATHEREI16_VV_M4_E32_M8_MASK, VRGATHEREI16_VV, 0x2, 0x20 }, // 6834
  { PseudoVRGATHEREI16_VV_M4_E64_M1, VRGATHEREI16_VV, 0x2, 0x40 }, // 6835
  { PseudoVRGATHEREI16_VV_M4_E64_M1_MASK, VRGATHEREI16_VV, 0x2, 0x40 }, // 6836
  { PseudoVRGATHEREI16_VV_M4_E64_M2, VRGATHEREI16_VV, 0x2, 0x40 }, // 6837
  { PseudoVRGATHEREI16_VV_M4_E64_M2_MASK, VRGATHEREI16_VV, 0x2, 0x40 }, // 6838
  { PseudoVRGATHEREI16_VV_M4_E64_M4, VRGATHEREI16_VV, 0x2, 0x40 }, // 6839
  { PseudoVRGATHEREI16_VV_M4_E64_M4_MASK, VRGATHEREI16_VV, 0x2, 0x40 }, // 6840
  { PseudoVRGATHEREI16_VV_M4_E64_M8, VRGATHEREI16_VV, 0x2, 0x40 }, // 6841
  { PseudoVRGATHEREI16_VV_M4_E64_M8_MASK, VRGATHEREI16_VV, 0x2, 0x40 }, // 6842
  { PseudoVRGATHEREI16_VV_M8_E8_M2, VRGATHEREI16_VV, 0x3, 0x8 }, // 6843
  { PseudoVRGATHEREI16_VV_M8_E8_M2_MASK, VRGATHEREI16_VV, 0x3, 0x8 }, // 6844
  { PseudoVRGATHEREI16_VV_M8_E8_M4, VRGATHEREI16_VV, 0x3, 0x8 }, // 6845
  { PseudoVRGATHEREI16_VV_M8_E8_M4_MASK, VRGATHEREI16_VV, 0x3, 0x8 }, // 6846
  { PseudoVRGATHEREI16_VV_M8_E8_M8, VRGATHEREI16_VV, 0x3, 0x8 }, // 6847
  { PseudoVRGATHEREI16_VV_M8_E8_M8_MASK, VRGATHEREI16_VV, 0x3, 0x8 }, // 6848
  { PseudoVRGATHEREI16_VV_M8_E16_M2, VRGATHEREI16_VV, 0x3, 0x10 }, // 6849
  { PseudoVRGATHEREI16_VV_M8_E16_M2_MASK, VRGATHEREI16_VV, 0x3, 0x10 }, // 6850
  { PseudoVRGATHEREI16_VV_M8_E16_M4, VRGATHEREI16_VV, 0x3, 0x10 }, // 6851
  { PseudoVRGATHEREI16_VV_M8_E16_M4_MASK, VRGATHEREI16_VV, 0x3, 0x10 }, // 6852
  { PseudoVRGATHEREI16_VV_M8_E16_M8, VRGATHEREI16_VV, 0x3, 0x10 }, // 6853
  { PseudoVRGATHEREI16_VV_M8_E16_M8_MASK, VRGATHEREI16_VV, 0x3, 0x10 }, // 6854
  { PseudoVRGATHEREI16_VV_M8_E32_M2, VRGATHEREI16_VV, 0x3, 0x20 }, // 6855
  { PseudoVRGATHEREI16_VV_M8_E32_M2_MASK, VRGATHEREI16_VV, 0x3, 0x20 }, // 6856
  { PseudoVRGATHEREI16_VV_M8_E32_M4, VRGATHEREI16_VV, 0x3, 0x20 }, // 6857
  { PseudoVRGATHEREI16_VV_M8_E32_M4_MASK, VRGATHEREI16_VV, 0x3, 0x20 }, // 6858
  { PseudoVRGATHEREI16_VV_M8_E32_M8, VRGATHEREI16_VV, 0x3, 0x20 }, // 6859
  { PseudoVRGATHEREI16_VV_M8_E32_M8_MASK, VRGATHEREI16_VV, 0x3, 0x20 }, // 6860
  { PseudoVRGATHEREI16_VV_M8_E64_M2, VRGATHEREI16_VV, 0x3, 0x40 }, // 6861
  { PseudoVRGATHEREI16_VV_M8_E64_M2_MASK, VRGATHEREI16_VV, 0x3, 0x40 }, // 6862
  { PseudoVRGATHEREI16_VV_M8_E64_M4, VRGATHEREI16_VV, 0x3, 0x40 }, // 6863
  { PseudoVRGATHEREI16_VV_M8_E64_M4_MASK, VRGATHEREI16_VV, 0x3, 0x40 }, // 6864
  { PseudoVRGATHEREI16_VV_M8_E64_M8, VRGATHEREI16_VV, 0x3, 0x40 }, // 6865
  { PseudoVRGATHEREI16_VV_M8_E64_M8_MASK, VRGATHEREI16_VV, 0x3, 0x40 }, // 6866
  { PseudoVRGATHEREI16_VV_MF8_E8_MF4, VRGATHEREI16_VV, 0x5, 0x8 }, // 6867
  { PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK, VRGATHEREI16_VV, 0x5, 0x8 }, // 6868
  { PseudoVRGATHEREI16_VV_MF8_E8_MF8, VRGATHEREI16_VV, 0x5, 0x8 }, // 6869
  { PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK, VRGATHEREI16_VV, 0x5, 0x8 }, // 6870
  { PseudoVRGATHEREI16_VV_MF4_E8_MF2, VRGATHEREI16_VV, 0x6, 0x8 }, // 6871
  { PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK, VRGATHEREI16_VV, 0x6, 0x8 }, // 6872
  { PseudoVRGATHEREI16_VV_MF4_E8_MF4, VRGATHEREI16_VV, 0x6, 0x8 }, // 6873
  { PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK, VRGATHEREI16_VV, 0x6, 0x8 }, // 6874
  { PseudoVRGATHEREI16_VV_MF4_E8_MF8, VRGATHEREI16_VV, 0x6, 0x8 }, // 6875
  { PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK, VRGATHEREI16_VV, 0x6, 0x8 }, // 6876
  { PseudoVRGATHEREI16_VV_MF4_E16_MF2, VRGATHEREI16_VV, 0x6, 0x10 }, // 6877
  { PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK, VRGATHEREI16_VV, 0x6, 0x10 }, // 6878
  { PseudoVRGATHEREI16_VV_MF4_E16_MF4, VRGATHEREI16_VV, 0x6, 0x10 }, // 6879
  { PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK, VRGATHEREI16_VV, 0x6, 0x10 }, // 6880
  { PseudoVRGATHEREI16_VV_MF4_E16_MF8, VRGATHEREI16_VV, 0x6, 0x10 }, // 6881
  { PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK, VRGATHEREI16_VV, 0x6, 0x10 }, // 6882
  { PseudoVRGATHEREI16_VV_MF2_E8_M1, VRGATHEREI16_VV, 0x7, 0x8 }, // 6883
  { PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK, VRGATHEREI16_VV, 0x7, 0x8 }, // 6884
  { PseudoVRGATHEREI16_VV_MF2_E8_MF2, VRGATHEREI16_VV, 0x7, 0x8 }, // 6885
  { PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK, VRGATHEREI16_VV, 0x7, 0x8 }, // 6886
  { PseudoVRGATHEREI16_VV_MF2_E8_MF4, VRGATHEREI16_VV, 0x7, 0x8 }, // 6887
  { PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK, VRGATHEREI16_VV, 0x7, 0x8 }, // 6888
  { PseudoVRGATHEREI16_VV_MF2_E8_MF8, VRGATHEREI16_VV, 0x7, 0x8 }, // 6889
  { PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK, VRGATHEREI16_VV, 0x7, 0x8 }, // 6890
  { PseudoVRGATHEREI16_VV_MF2_E16_M1, VRGATHEREI16_VV, 0x7, 0x10 }, // 6891
  { PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK, VRGATHEREI16_VV, 0x7, 0x10 }, // 6892
  { PseudoVRGATHEREI16_VV_MF2_E16_MF2, VRGATHEREI16_VV, 0x7, 0x10 }, // 6893
  { PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK, VRGATHEREI16_VV, 0x7, 0x10 }, // 6894
  { PseudoVRGATHEREI16_VV_MF2_E16_MF4, VRGATHEREI16_VV, 0x7, 0x10 }, // 6895
  { PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK, VRGATHEREI16_VV, 0x7, 0x10 }, // 6896
  { PseudoVRGATHEREI16_VV_MF2_E16_MF8, VRGATHEREI16_VV, 0x7, 0x10 }, // 6897
  { PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK, VRGATHEREI16_VV, 0x7, 0x10 }, // 6898
  { PseudoVRGATHEREI16_VV_MF2_E32_M1, VRGATHEREI16_VV, 0x7, 0x20 }, // 6899
  { PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK, VRGATHEREI16_VV, 0x7, 0x20 }, // 6900
  { PseudoVRGATHEREI16_VV_MF2_E32_MF2, VRGATHEREI16_VV, 0x7, 0x20 }, // 6901
  { PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK, VRGATHEREI16_VV, 0x7, 0x20 }, // 6902
  { PseudoVRGATHEREI16_VV_MF2_E32_MF4, VRGATHEREI16_VV, 0x7, 0x20 }, // 6903
  { PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK, VRGATHEREI16_VV, 0x7, 0x20 }, // 6904
  { PseudoVRGATHEREI16_VV_MF2_E32_MF8, VRGATHEREI16_VV, 0x7, 0x20 }, // 6905
  { PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK, VRGATHEREI16_VV, 0x7, 0x20 }, // 6906
  { PseudoVRGATHER_VI_M1, VRGATHER_VI, 0x0, 0x0 }, // 6907
  { PseudoVRGATHER_VI_M1_MASK, VRGATHER_VI, 0x0, 0x0 }, // 6908
  { PseudoVRGATHER_VI_M2, VRGATHER_VI, 0x1, 0x0 }, // 6909
  { PseudoVRGATHER_VI_M2_MASK, VRGATHER_VI, 0x1, 0x0 }, // 6910
  { PseudoVRGATHER_VI_M4, VRGATHER_VI, 0x2, 0x0 }, // 6911
  { PseudoVRGATHER_VI_M4_MASK, VRGATHER_VI, 0x2, 0x0 }, // 6912
  { PseudoVRGATHER_VI_M8, VRGATHER_VI, 0x3, 0x0 }, // 6913
  { PseudoVRGATHER_VI_M8_MASK, VRGATHER_VI, 0x3, 0x0 }, // 6914
  { PseudoVRGATHER_VI_MF8, VRGATHER_VI, 0x5, 0x0 }, // 6915
  { PseudoVRGATHER_VI_MF8_MASK, VRGATHER_VI, 0x5, 0x0 }, // 6916
  { PseudoVRGATHER_VI_MF4, VRGATHER_VI, 0x6, 0x0 }, // 6917
  { PseudoVRGATHER_VI_MF4_MASK, VRGATHER_VI, 0x6, 0x0 }, // 6918
  { PseudoVRGATHER_VI_MF2, VRGATHER_VI, 0x7, 0x0 }, // 6919
  { PseudoVRGATHER_VI_MF2_MASK, VRGATHER_VI, 0x7, 0x0 }, // 6920
  { PseudoVRGATHER_VV_M1_E8, VRGATHER_VV, 0x0, 0x8 }, // 6921
  { PseudoVRGATHER_VV_M1_E8_MASK, VRGATHER_VV, 0x0, 0x8 }, // 6922
  { PseudoVRGATHER_VV_M1_E16, VRGATHER_VV, 0x0, 0x10 }, // 6923
  { PseudoVRGATHER_VV_M1_E16_MASK, VRGATHER_VV, 0x0, 0x10 }, // 6924
  { PseudoVRGATHER_VV_M1_E32, VRGATHER_VV, 0x0, 0x20 }, // 6925
  { PseudoVRGATHER_VV_M1_E32_MASK, VRGATHER_VV, 0x0, 0x20 }, // 6926
  { PseudoVRGATHER_VV_M1_E64, VRGATHER_VV, 0x0, 0x40 }, // 6927
  { PseudoVRGATHER_VV_M1_E64_MASK, VRGATHER_VV, 0x0, 0x40 }, // 6928
  { PseudoVRGATHER_VV_M2_E8, VRGATHER_VV, 0x1, 0x8 }, // 6929
  { PseudoVRGATHER_VV_M2_E8_MASK, VRGATHER_VV, 0x1, 0x8 }, // 6930
  { PseudoVRGATHER_VV_M2_E16, VRGATHER_VV, 0x1, 0x10 }, // 6931
  { PseudoVRGATHER_VV_M2_E16_MASK, VRGATHER_VV, 0x1, 0x10 }, // 6932
  { PseudoVRGATHER_VV_M2_E32, VRGATHER_VV, 0x1, 0x20 }, // 6933
  { PseudoVRGATHER_VV_M2_E32_MASK, VRGATHER_VV, 0x1, 0x20 }, // 6934
  { PseudoVRGATHER_VV_M2_E64, VRGATHER_VV, 0x1, 0x40 }, // 6935
  { PseudoVRGATHER_VV_M2_E64_MASK, VRGATHER_VV, 0x1, 0x40 }, // 6936
  { PseudoVRGATHER_VV_M4_E8, VRGATHER_VV, 0x2, 0x8 }, // 6937
  { PseudoVRGATHER_VV_M4_E8_MASK, VRGATHER_VV, 0x2, 0x8 }, // 6938
  { PseudoVRGATHER_VV_M4_E16, VRGATHER_VV, 0x2, 0x10 }, // 6939
  { PseudoVRGATHER_VV_M4_E16_MASK, VRGATHER_VV, 0x2, 0x10 }, // 6940
  { PseudoVRGATHER_VV_M4_E32, VRGATHER_VV, 0x2, 0x20 }, // 6941
  { PseudoVRGATHER_VV_M4_E32_MASK, VRGATHER_VV, 0x2, 0x20 }, // 6942
  { PseudoVRGATHER_VV_M4_E64, VRGATHER_VV, 0x2, 0x40 }, // 6943
  { PseudoVRGATHER_VV_M4_E64_MASK, VRGATHER_VV, 0x2, 0x40 }, // 6944
  { PseudoVRGATHER_VV_M8_E8, VRGATHER_VV, 0x3, 0x8 }, // 6945
  { PseudoVRGATHER_VV_M8_E8_MASK, VRGATHER_VV, 0x3, 0x8 }, // 6946
  { PseudoVRGATHER_VV_M8_E16, VRGATHER_VV, 0x3, 0x10 }, // 6947
  { PseudoVRGATHER_VV_M8_E16_MASK, VRGATHER_VV, 0x3, 0x10 }, // 6948
  { PseudoVRGATHER_VV_M8_E32, VRGATHER_VV, 0x3, 0x20 }, // 6949
  { PseudoVRGATHER_VV_M8_E32_MASK, VRGATHER_VV, 0x3, 0x20 }, // 6950
  { PseudoVRGATHER_VV_M8_E64, VRGATHER_VV, 0x3, 0x40 }, // 6951
  { PseudoVRGATHER_VV_M8_E64_MASK, VRGATHER_VV, 0x3, 0x40 }, // 6952
  { PseudoVRGATHER_VV_MF8_E8, VRGATHER_VV, 0x5, 0x8 }, // 6953
  { PseudoVRGATHER_VV_MF8_E8_MASK, VRGATHER_VV, 0x5, 0x8 }, // 6954
  { PseudoVRGATHER_VV_MF4_E8, VRGATHER_VV, 0x6, 0x8 }, // 6955
  { PseudoVRGATHER_VV_MF4_E8_MASK, VRGATHER_VV, 0x6, 0x8 }, // 6956
  { PseudoVRGATHER_VV_MF4_E16, VRGATHER_VV, 0x6, 0x10 }, // 6957
  { PseudoVRGATHER_VV_MF4_E16_MASK, VRGATHER_VV, 0x6, 0x10 }, // 6958
  { PseudoVRGATHER_VV_MF2_E8, VRGATHER_VV, 0x7, 0x8 }, // 6959
  { PseudoVRGATHER_VV_MF2_E8_MASK, VRGATHER_VV, 0x7, 0x8 }, // 6960
  { PseudoVRGATHER_VV_MF2_E16, VRGATHER_VV, 0x7, 0x10 }, // 6961
  { PseudoVRGATHER_VV_MF2_E16_MASK, VRGATHER_VV, 0x7, 0x10 }, // 6962
  { PseudoVRGATHER_VV_MF2_E32, VRGATHER_VV, 0x7, 0x20 }, // 6963
  { PseudoVRGATHER_VV_MF2_E32_MASK, VRGATHER_VV, 0x7, 0x20 }, // 6964
  { PseudoVRGATHER_VX_M1, VRGATHER_VX, 0x0, 0x0 }, // 6965
  { PseudoVRGATHER_VX_M1_MASK, VRGATHER_VX, 0x0, 0x0 }, // 6966
  { PseudoVRGATHER_VX_M2, VRGATHER_VX, 0x1, 0x0 }, // 6967
  { PseudoVRGATHER_VX_M2_MASK, VRGATHER_VX, 0x1, 0x0 }, // 6968
  { PseudoVRGATHER_VX_M4, VRGATHER_VX, 0x2, 0x0 }, // 6969
  { PseudoVRGATHER_VX_M4_MASK, VRGATHER_VX, 0x2, 0x0 }, // 6970
  { PseudoVRGATHER_VX_M8, VRGATHER_VX, 0x3, 0x0 }, // 6971
  { PseudoVRGATHER_VX_M8_MASK, VRGATHER_VX, 0x3, 0x0 }, // 6972
  { PseudoVRGATHER_VX_MF8, VRGATHER_VX, 0x5, 0x0 }, // 6973
  { PseudoVRGATHER_VX_MF8_MASK, VRGATHER_VX, 0x5, 0x0 }, // 6974
  { PseudoVRGATHER_VX_MF4, VRGATHER_VX, 0x6, 0x0 }, // 6975
  { PseudoVRGATHER_VX_MF4_MASK, VRGATHER_VX, 0x6, 0x0 }, // 6976
  { PseudoVRGATHER_VX_MF2, VRGATHER_VX, 0x7, 0x0 }, // 6977
  { PseudoVRGATHER_VX_MF2_MASK, VRGATHER_VX, 0x7, 0x0 }, // 6978
  { PseudoVROL_VV_M1, VROL_VV, 0x0, 0x0 }, // 6979
  { PseudoVROL_VV_M1_MASK, VROL_VV, 0x0, 0x0 }, // 6980
  { PseudoVROL_VV_M2, VROL_VV, 0x1, 0x0 }, // 6981
  { PseudoVROL_VV_M2_MASK, VROL_VV, 0x1, 0x0 }, // 6982
  { PseudoVROL_VV_M4, VROL_VV, 0x2, 0x0 }, // 6983
  { PseudoVROL_VV_M4_MASK, VROL_VV, 0x2, 0x0 }, // 6984
  { PseudoVROL_VV_M8, VROL_VV, 0x3, 0x0 }, // 6985
  { PseudoVROL_VV_M8_MASK, VROL_VV, 0x3, 0x0 }, // 6986
  { PseudoVROL_VV_MF8, VROL_VV, 0x5, 0x0 }, // 6987
  { PseudoVROL_VV_MF8_MASK, VROL_VV, 0x5, 0x0 }, // 6988
  { PseudoVROL_VV_MF4, VROL_VV, 0x6, 0x0 }, // 6989
  { PseudoVROL_VV_MF4_MASK, VROL_VV, 0x6, 0x0 }, // 6990
  { PseudoVROL_VV_MF2, VROL_VV, 0x7, 0x0 }, // 6991
  { PseudoVROL_VV_MF2_MASK, VROL_VV, 0x7, 0x0 }, // 6992
  { PseudoVROL_VX_M1, VROL_VX, 0x0, 0x0 }, // 6993
  { PseudoVROL_VX_M1_MASK, VROL_VX, 0x0, 0x0 }, // 6994
  { PseudoVROL_VX_M2, VROL_VX, 0x1, 0x0 }, // 6995
  { PseudoVROL_VX_M2_MASK, VROL_VX, 0x1, 0x0 }, // 6996
  { PseudoVROL_VX_M4, VROL_VX, 0x2, 0x0 }, // 6997
  { PseudoVROL_VX_M4_MASK, VROL_VX, 0x2, 0x0 }, // 6998
  { PseudoVROL_VX_M8, VROL_VX, 0x3, 0x0 }, // 6999
  { PseudoVROL_VX_M8_MASK, VROL_VX, 0x3, 0x0 }, // 7000
  { PseudoVROL_VX_MF8, VROL_VX, 0x5, 0x0 }, // 7001
  { PseudoVROL_VX_MF8_MASK, VROL_VX, 0x5, 0x0 }, // 7002
  { PseudoVROL_VX_MF4, VROL_VX, 0x6, 0x0 }, // 7003
  { PseudoVROL_VX_MF4_MASK, VROL_VX, 0x6, 0x0 }, // 7004
  { PseudoVROL_VX_MF2, VROL_VX, 0x7, 0x0 }, // 7005
  { PseudoVROL_VX_MF2_MASK, VROL_VX, 0x7, 0x0 }, // 7006
  { PseudoVROR_VI_M1, VROR_VI, 0x0, 0x0 }, // 7007
  { PseudoVROR_VI_M1_MASK, VROR_VI, 0x0, 0x0 }, // 7008
  { PseudoVROR_VI_M2, VROR_VI, 0x1, 0x0 }, // 7009
  { PseudoVROR_VI_M2_MASK, VROR_VI, 0x1, 0x0 }, // 7010
  { PseudoVROR_VI_M4, VROR_VI, 0x2, 0x0 }, // 7011
  { PseudoVROR_VI_M4_MASK, VROR_VI, 0x2, 0x0 }, // 7012
  { PseudoVROR_VI_M8, VROR_VI, 0x3, 0x0 }, // 7013
  { PseudoVROR_VI_M8_MASK, VROR_VI, 0x3, 0x0 }, // 7014
  { PseudoVROR_VI_MF8, VROR_VI, 0x5, 0x0 }, // 7015
  { PseudoVROR_VI_MF8_MASK, VROR_VI, 0x5, 0x0 }, // 7016
  { PseudoVROR_VI_MF4, VROR_VI, 0x6, 0x0 }, // 7017
  { PseudoVROR_VI_MF4_MASK, VROR_VI, 0x6, 0x0 }, // 7018
  { PseudoVROR_VI_MF2, VROR_VI, 0x7, 0x0 }, // 7019
  { PseudoVROR_VI_MF2_MASK, VROR_VI, 0x7, 0x0 }, // 7020
  { PseudoVROR_VV_M1, VROR_VV, 0x0, 0x0 }, // 7021
  { PseudoVROR_VV_M1_MASK, VROR_VV, 0x0, 0x0 }, // 7022
  { PseudoVROR_VV_M2, VROR_VV, 0x1, 0x0 }, // 7023
  { PseudoVROR_VV_M2_MASK, VROR_VV, 0x1, 0x0 }, // 7024
  { PseudoVROR_VV_M4, VROR_VV, 0x2, 0x0 }, // 7025
  { PseudoVROR_VV_M4_MASK, VROR_VV, 0x2, 0x0 }, // 7026
  { PseudoVROR_VV_M8, VROR_VV, 0x3, 0x0 }, // 7027
  { PseudoVROR_VV_M8_MASK, VROR_VV, 0x3, 0x0 }, // 7028
  { PseudoVROR_VV_MF8, VROR_VV, 0x5, 0x0 }, // 7029
  { PseudoVROR_VV_MF8_MASK, VROR_VV, 0x5, 0x0 }, // 7030
  { PseudoVROR_VV_MF4, VROR_VV, 0x6, 0x0 }, // 7031
  { PseudoVROR_VV_MF4_MASK, VROR_VV, 0x6, 0x0 }, // 7032
  { PseudoVROR_VV_MF2, VROR_VV, 0x7, 0x0 }, // 7033
  { PseudoVROR_VV_MF2_MASK, VROR_VV, 0x7, 0x0 }, // 7034
  { PseudoVROR_VX_M1, VROR_VX, 0x0, 0x0 }, // 7035
  { PseudoVROR_VX_M1_MASK, VROR_VX, 0x0, 0x0 }, // 7036
  { PseudoVROR_VX_M2, VROR_VX, 0x1, 0x0 }, // 7037
  { PseudoVROR_VX_M2_MASK, VROR_VX, 0x1, 0x0 }, // 7038
  { PseudoVROR_VX_M4, VROR_VX, 0x2, 0x0 }, // 7039
  { PseudoVROR_VX_M4_MASK, VROR_VX, 0x2, 0x0 }, // 7040
  { PseudoVROR_VX_M8, VROR_VX, 0x3, 0x0 }, // 7041
  { PseudoVROR_VX_M8_MASK, VROR_VX, 0x3, 0x0 }, // 7042
  { PseudoVROR_VX_MF8, VROR_VX, 0x5, 0x0 }, // 7043
  { PseudoVROR_VX_MF8_MASK, VROR_VX, 0x5, 0x0 }, // 7044
  { PseudoVROR_VX_MF4, VROR_VX, 0x6, 0x0 }, // 7045
  { PseudoVROR_VX_MF4_MASK, VROR_VX, 0x6, 0x0 }, // 7046
  { PseudoVROR_VX_MF2, VROR_VX, 0x7, 0x0 }, // 7047
  { PseudoVROR_VX_MF2_MASK, VROR_VX, 0x7, 0x0 }, // 7048
  { PseudoVRSUB_VI_M1, VRSUB_VI, 0x0, 0x0 }, // 7049
  { PseudoVRSUB_VI_M1_MASK, VRSUB_VI, 0x0, 0x0 }, // 7050
  { PseudoVRSUB_VI_M2, VRSUB_VI, 0x1, 0x0 }, // 7051
  { PseudoVRSUB_VI_M2_MASK, VRSUB_VI, 0x1, 0x0 }, // 7052
  { PseudoVRSUB_VI_M4, VRSUB_VI, 0x2, 0x0 }, // 7053
  { PseudoVRSUB_VI_M4_MASK, VRSUB_VI, 0x2, 0x0 }, // 7054
  { PseudoVRSUB_VI_M8, VRSUB_VI, 0x3, 0x0 }, // 7055
  { PseudoVRSUB_VI_M8_MASK, VRSUB_VI, 0x3, 0x0 }, // 7056
  { PseudoVRSUB_VI_MF8, VRSUB_VI, 0x5, 0x0 }, // 7057
  { PseudoVRSUB_VI_MF8_MASK, VRSUB_VI, 0x5, 0x0 }, // 7058
  { PseudoVRSUB_VI_MF4, VRSUB_VI, 0x6, 0x0 }, // 7059
  { PseudoVRSUB_VI_MF4_MASK, VRSUB_VI, 0x6, 0x0 }, // 7060
  { PseudoVRSUB_VI_MF2, VRSUB_VI, 0x7, 0x0 }, // 7061
  { PseudoVRSUB_VI_MF2_MASK, VRSUB_VI, 0x7, 0x0 }, // 7062
  { PseudoVRSUB_VX_M1, VRSUB_VX, 0x0, 0x0 }, // 7063
  { PseudoVRSUB_VX_M1_MASK, VRSUB_VX, 0x0, 0x0 }, // 7064
  { PseudoVRSUB_VX_M2, VRSUB_VX, 0x1, 0x0 }, // 7065
  { PseudoVRSUB_VX_M2_MASK, VRSUB_VX, 0x1, 0x0 }, // 7066
  { PseudoVRSUB_VX_M4, VRSUB_VX, 0x2, 0x0 }, // 7067
  { PseudoVRSUB_VX_M4_MASK, VRSUB_VX, 0x2, 0x0 }, // 7068
  { PseudoVRSUB_VX_M8, VRSUB_VX, 0x3, 0x0 }, // 7069
  { PseudoVRSUB_VX_M8_MASK, VRSUB_VX, 0x3, 0x0 }, // 7070
  { PseudoVRSUB_VX_MF8, VRSUB_VX, 0x5, 0x0 }, // 7071
  { PseudoVRSUB_VX_MF8_MASK, VRSUB_VX, 0x5, 0x0 }, // 7072
  { PseudoVRSUB_VX_MF4, VRSUB_VX, 0x6, 0x0 }, // 7073
  { PseudoVRSUB_VX_MF4_MASK, VRSUB_VX, 0x6, 0x0 }, // 7074
  { PseudoVRSUB_VX_MF2, VRSUB_VX, 0x7, 0x0 }, // 7075
  { PseudoVRSUB_VX_MF2_MASK, VRSUB_VX, 0x7, 0x0 }, // 7076
  { PseudoVSADDU_VI_M1, VSADDU_VI, 0x0, 0x0 }, // 7077
  { PseudoVSADDU_VI_M1_MASK, VSADDU_VI, 0x0, 0x0 }, // 7078
  { PseudoVSADDU_VI_M2, VSADDU_VI, 0x1, 0x0 }, // 7079
  { PseudoVSADDU_VI_M2_MASK, VSADDU_VI, 0x1, 0x0 }, // 7080
  { PseudoVSADDU_VI_M4, VSADDU_VI, 0x2, 0x0 }, // 7081
  { PseudoVSADDU_VI_M4_MASK, VSADDU_VI, 0x2, 0x0 }, // 7082
  { PseudoVSADDU_VI_M8, VSADDU_VI, 0x3, 0x0 }, // 7083
  { PseudoVSADDU_VI_M8_MASK, VSADDU_VI, 0x3, 0x0 }, // 7084
  { PseudoVSADDU_VI_MF8, VSADDU_VI, 0x5, 0x0 }, // 7085
  { PseudoVSADDU_VI_MF8_MASK, VSADDU_VI, 0x5, 0x0 }, // 7086
  { PseudoVSADDU_VI_MF4, VSADDU_VI, 0x6, 0x0 }, // 7087
  { PseudoVSADDU_VI_MF4_MASK, VSADDU_VI, 0x6, 0x0 }, // 7088
  { PseudoVSADDU_VI_MF2, VSADDU_VI, 0x7, 0x0 }, // 7089
  { PseudoVSADDU_VI_MF2_MASK, VSADDU_VI, 0x7, 0x0 }, // 7090
  { PseudoVSADDU_VV_M1, VSADDU_VV, 0x0, 0x0 }, // 7091
  { PseudoVSADDU_VV_M1_MASK, VSADDU_VV, 0x0, 0x0 }, // 7092
  { PseudoVSADDU_VV_M2, VSADDU_VV, 0x1, 0x0 }, // 7093
  { PseudoVSADDU_VV_M2_MASK, VSADDU_VV, 0x1, 0x0 }, // 7094
  { PseudoVSADDU_VV_M4, VSADDU_VV, 0x2, 0x0 }, // 7095
  { PseudoVSADDU_VV_M4_MASK, VSADDU_VV, 0x2, 0x0 }, // 7096
  { PseudoVSADDU_VV_M8, VSADDU_VV, 0x3, 0x0 }, // 7097
  { PseudoVSADDU_VV_M8_MASK, VSADDU_VV, 0x3, 0x0 }, // 7098
  { PseudoVSADDU_VV_MF8, VSADDU_VV, 0x5, 0x0 }, // 7099
  { PseudoVSADDU_VV_MF8_MASK, VSADDU_VV, 0x5, 0x0 }, // 7100
  { PseudoVSADDU_VV_MF4, VSADDU_VV, 0x6, 0x0 }, // 7101
  { PseudoVSADDU_VV_MF4_MASK, VSADDU_VV, 0x6, 0x0 }, // 7102
  { PseudoVSADDU_VV_MF2, VSADDU_VV, 0x7, 0x0 }, // 7103
  { PseudoVSADDU_VV_MF2_MASK, VSADDU_VV, 0x7, 0x0 }, // 7104
  { PseudoVSADDU_VX_M1, VSADDU_VX, 0x0, 0x0 }, // 7105
  { PseudoVSADDU_VX_M1_MASK, VSADDU_VX, 0x0, 0x0 }, // 7106
  { PseudoVSADDU_VX_M2, VSADDU_VX, 0x1, 0x0 }, // 7107
  { PseudoVSADDU_VX_M2_MASK, VSADDU_VX, 0x1, 0x0 }, // 7108
  { PseudoVSADDU_VX_M4, VSADDU_VX, 0x2, 0x0 }, // 7109
  { PseudoVSADDU_VX_M4_MASK, VSADDU_VX, 0x2, 0x0 }, // 7110
  { PseudoVSADDU_VX_M8, VSADDU_VX, 0x3, 0x0 }, // 7111
  { PseudoVSADDU_VX_M8_MASK, VSADDU_VX, 0x3, 0x0 }, // 7112
  { PseudoVSADDU_VX_MF8, VSADDU_VX, 0x5, 0x0 }, // 7113
  { PseudoVSADDU_VX_MF8_MASK, VSADDU_VX, 0x5, 0x0 }, // 7114
  { PseudoVSADDU_VX_MF4, VSADDU_VX, 0x6, 0x0 }, // 7115
  { PseudoVSADDU_VX_MF4_MASK, VSADDU_VX, 0x6, 0x0 }, // 7116
  { PseudoVSADDU_VX_MF2, VSADDU_VX, 0x7, 0x0 }, // 7117
  { PseudoVSADDU_VX_MF2_MASK, VSADDU_VX, 0x7, 0x0 }, // 7118
  { PseudoVSADD_VI_M1, VSADD_VI, 0x0, 0x0 }, // 7119
  { PseudoVSADD_VI_M1_MASK, VSADD_VI, 0x0, 0x0 }, // 7120
  { PseudoVSADD_VI_M2, VSADD_VI, 0x1, 0x0 }, // 7121
  { PseudoVSADD_VI_M2_MASK, VSADD_VI, 0x1, 0x0 }, // 7122
  { PseudoVSADD_VI_M4, VSADD_VI, 0x2, 0x0 }, // 7123
  { PseudoVSADD_VI_M4_MASK, VSADD_VI, 0x2, 0x0 }, // 7124
  { PseudoVSADD_VI_M8, VSADD_VI, 0x3, 0x0 }, // 7125
  { PseudoVSADD_VI_M8_MASK, VSADD_VI, 0x3, 0x0 }, // 7126
  { PseudoVSADD_VI_MF8, VSADD_VI, 0x5, 0x0 }, // 7127
  { PseudoVSADD_VI_MF8_MASK, VSADD_VI, 0x5, 0x0 }, // 7128
  { PseudoVSADD_VI_MF4, VSADD_VI, 0x6, 0x0 }, // 7129
  { PseudoVSADD_VI_MF4_MASK, VSADD_VI, 0x6, 0x0 }, // 7130
  { PseudoVSADD_VI_MF2, VSADD_VI, 0x7, 0x0 }, // 7131
  { PseudoVSADD_VI_MF2_MASK, VSADD_VI, 0x7, 0x0 }, // 7132
  { PseudoVSADD_VV_M1, VSADD_VV, 0x0, 0x0 }, // 7133
  { PseudoVSADD_VV_M1_MASK, VSADD_VV, 0x0, 0x0 }, // 7134
  { PseudoVSADD_VV_M2, VSADD_VV, 0x1, 0x0 }, // 7135
  { PseudoVSADD_VV_M2_MASK, VSADD_VV, 0x1, 0x0 }, // 7136
  { PseudoVSADD_VV_M4, VSADD_VV, 0x2, 0x0 }, // 7137
  { PseudoVSADD_VV_M4_MASK, VSADD_VV, 0x2, 0x0 }, // 7138
  { PseudoVSADD_VV_M8, VSADD_VV, 0x3, 0x0 }, // 7139
  { PseudoVSADD_VV_M8_MASK, VSADD_VV, 0x3, 0x0 }, // 7140
  { PseudoVSADD_VV_MF8, VSADD_VV, 0x5, 0x0 }, // 7141
  { PseudoVSADD_VV_MF8_MASK, VSADD_VV, 0x5, 0x0 }, // 7142
  { PseudoVSADD_VV_MF4, VSADD_VV, 0x6, 0x0 }, // 7143
  { PseudoVSADD_VV_MF4_MASK, VSADD_VV, 0x6, 0x0 }, // 7144
  { PseudoVSADD_VV_MF2, VSADD_VV, 0x7, 0x0 }, // 7145
  { PseudoVSADD_VV_MF2_MASK, VSADD_VV, 0x7, 0x0 }, // 7146
  { PseudoVSADD_VX_M1, VSADD_VX, 0x0, 0x0 }, // 7147
  { PseudoVSADD_VX_M1_MASK, VSADD_VX, 0x0, 0x0 }, // 7148
  { PseudoVSADD_VX_M2, VSADD_VX, 0x1, 0x0 }, // 7149
  { PseudoVSADD_VX_M2_MASK, VSADD_VX, 0x1, 0x0 }, // 7150
  { PseudoVSADD_VX_M4, VSADD_VX, 0x2, 0x0 }, // 7151
  { PseudoVSADD_VX_M4_MASK, VSADD_VX, 0x2, 0x0 }, // 7152
  { PseudoVSADD_VX_M8, VSADD_VX, 0x3, 0x0 }, // 7153
  { PseudoVSADD_VX_M8_MASK, VSADD_VX, 0x3, 0x0 }, // 7154
  { PseudoVSADD_VX_MF8, VSADD_VX, 0x5, 0x0 }, // 7155
  { PseudoVSADD_VX_MF8_MASK, VSADD_VX, 0x5, 0x0 }, // 7156
  { PseudoVSADD_VX_MF4, VSADD_VX, 0x6, 0x0 }, // 7157
  { PseudoVSADD_VX_MF4_MASK, VSADD_VX, 0x6, 0x0 }, // 7158
  { PseudoVSADD_VX_MF2, VSADD_VX, 0x7, 0x0 }, // 7159
  { PseudoVSADD_VX_MF2_MASK, VSADD_VX, 0x7, 0x0 }, // 7160
  { PseudoVSBC_VVM_M1, VSBC_VVM, 0x0, 0x0 }, // 7161
  { PseudoVSBC_VVM_M2, VSBC_VVM, 0x1, 0x0 }, // 7162
  { PseudoVSBC_VVM_M4, VSBC_VVM, 0x2, 0x0 }, // 7163
  { PseudoVSBC_VVM_M8, VSBC_VVM, 0x3, 0x0 }, // 7164
  { PseudoVSBC_VVM_MF8, VSBC_VVM, 0x5, 0x0 }, // 7165
  { PseudoVSBC_VVM_MF4, VSBC_VVM, 0x6, 0x0 }, // 7166
  { PseudoVSBC_VVM_MF2, VSBC_VVM, 0x7, 0x0 }, // 7167
  { PseudoVSBC_VXM_M1, VSBC_VXM, 0x0, 0x0 }, // 7168
  { PseudoVSBC_VXM_M2, VSBC_VXM, 0x1, 0x0 }, // 7169
  { PseudoVSBC_VXM_M4, VSBC_VXM, 0x2, 0x0 }, // 7170
  { PseudoVSBC_VXM_M8, VSBC_VXM, 0x3, 0x0 }, // 7171
  { PseudoVSBC_VXM_MF8, VSBC_VXM, 0x5, 0x0 }, // 7172
  { PseudoVSBC_VXM_MF4, VSBC_VXM, 0x6, 0x0 }, // 7173
  { PseudoVSBC_VXM_MF2, VSBC_VXM, 0x7, 0x0 }, // 7174
  { PseudoVSE16_V_M1, VSE16_V, 0x0, 0x10 }, // 7175
  { PseudoVSE16_V_M1_MASK, VSE16_V, 0x0, 0x10 }, // 7176
  { PseudoVSE16_V_M2, VSE16_V, 0x1, 0x10 }, // 7177
  { PseudoVSE16_V_M2_MASK, VSE16_V, 0x1, 0x10 }, // 7178
  { PseudoVSE16_V_M4, VSE16_V, 0x2, 0x10 }, // 7179
  { PseudoVSE16_V_M4_MASK, VSE16_V, 0x2, 0x10 }, // 7180
  { PseudoVSE16_V_M8, VSE16_V, 0x3, 0x10 }, // 7181
  { PseudoVSE16_V_M8_MASK, VSE16_V, 0x3, 0x10 }, // 7182
  { PseudoVSE16_V_MF4, VSE16_V, 0x6, 0x10 }, // 7183
  { PseudoVSE16_V_MF4_MASK, VSE16_V, 0x6, 0x10 }, // 7184
  { PseudoVSE16_V_MF2, VSE16_V, 0x7, 0x10 }, // 7185
  { PseudoVSE16_V_MF2_MASK, VSE16_V, 0x7, 0x10 }, // 7186
  { PseudoVSE32_V_M1, VSE32_V, 0x0, 0x20 }, // 7187
  { PseudoVSE32_V_M1_MASK, VSE32_V, 0x0, 0x20 }, // 7188
  { PseudoVSE32_V_M2, VSE32_V, 0x1, 0x20 }, // 7189
  { PseudoVSE32_V_M2_MASK, VSE32_V, 0x1, 0x20 }, // 7190
  { PseudoVSE32_V_M4, VSE32_V, 0x2, 0x20 }, // 7191
  { PseudoVSE32_V_M4_MASK, VSE32_V, 0x2, 0x20 }, // 7192
  { PseudoVSE32_V_M8, VSE32_V, 0x3, 0x20 }, // 7193
  { PseudoVSE32_V_M8_MASK, VSE32_V, 0x3, 0x20 }, // 7194
  { PseudoVSE32_V_MF2, VSE32_V, 0x7, 0x20 }, // 7195
  { PseudoVSE32_V_MF2_MASK, VSE32_V, 0x7, 0x20 }, // 7196
  { PseudoVSE64_V_M1, VSE64_V, 0x0, 0x40 }, // 7197
  { PseudoVSE64_V_M1_MASK, VSE64_V, 0x0, 0x40 }, // 7198
  { PseudoVSE64_V_M2, VSE64_V, 0x1, 0x40 }, // 7199
  { PseudoVSE64_V_M2_MASK, VSE64_V, 0x1, 0x40 }, // 7200
  { PseudoVSE64_V_M4, VSE64_V, 0x2, 0x40 }, // 7201
  { PseudoVSE64_V_M4_MASK, VSE64_V, 0x2, 0x40 }, // 7202
  { PseudoVSE64_V_M8, VSE64_V, 0x3, 0x40 }, // 7203
  { PseudoVSE64_V_M8_MASK, VSE64_V, 0x3, 0x40 }, // 7204
  { PseudoVSE8_V_M1, VSE8_V, 0x0, 0x8 }, // 7205
  { PseudoVSE8_V_M1_MASK, VSE8_V, 0x0, 0x8 }, // 7206
  { PseudoVSE8_V_M2, VSE8_V, 0x1, 0x8 }, // 7207
  { PseudoVSE8_V_M2_MASK, VSE8_V, 0x1, 0x8 }, // 7208
  { PseudoVSE8_V_M4, VSE8_V, 0x2, 0x8 }, // 7209
  { PseudoVSE8_V_M4_MASK, VSE8_V, 0x2, 0x8 }, // 7210
  { PseudoVSE8_V_M8, VSE8_V, 0x3, 0x8 }, // 7211
  { PseudoVSE8_V_M8_MASK, VSE8_V, 0x3, 0x8 }, // 7212
  { PseudoVSE8_V_MF8, VSE8_V, 0x5, 0x8 }, // 7213
  { PseudoVSE8_V_MF8_MASK, VSE8_V, 0x5, 0x8 }, // 7214
  { PseudoVSE8_V_MF4, VSE8_V, 0x6, 0x8 }, // 7215
  { PseudoVSE8_V_MF4_MASK, VSE8_V, 0x6, 0x8 }, // 7216
  { PseudoVSE8_V_MF2, VSE8_V, 0x7, 0x8 }, // 7217
  { PseudoVSE8_V_MF2_MASK, VSE8_V, 0x7, 0x8 }, // 7218
  { PseudoVSEXT_VF2_M1, VSEXT_VF2, 0x0, 0x0 }, // 7219
  { PseudoVSEXT_VF2_M1_MASK, VSEXT_VF2, 0x0, 0x0 }, // 7220
  { PseudoVSEXT_VF2_M2, VSEXT_VF2, 0x1, 0x0 }, // 7221
  { PseudoVSEXT_VF2_M2_MASK, VSEXT_VF2, 0x1, 0x0 }, // 7222
  { PseudoVSEXT_VF2_M4, VSEXT_VF2, 0x2, 0x0 }, // 7223
  { PseudoVSEXT_VF2_M4_MASK, VSEXT_VF2, 0x2, 0x0 }, // 7224
  { PseudoVSEXT_VF2_M8, VSEXT_VF2, 0x3, 0x0 }, // 7225
  { PseudoVSEXT_VF2_M8_MASK, VSEXT_VF2, 0x3, 0x0 }, // 7226
  { PseudoVSEXT_VF2_MF4, VSEXT_VF2, 0x6, 0x0 }, // 7227
  { PseudoVSEXT_VF2_MF4_MASK, VSEXT_VF2, 0x6, 0x0 }, // 7228
  { PseudoVSEXT_VF2_MF2, VSEXT_VF2, 0x7, 0x0 }, // 7229
  { PseudoVSEXT_VF2_MF2_MASK, VSEXT_VF2, 0x7, 0x0 }, // 7230
  { PseudoVSEXT_VF4_M1, VSEXT_VF4, 0x0, 0x0 }, // 7231
  { PseudoVSEXT_VF4_M1_MASK, VSEXT_VF4, 0x0, 0x0 }, // 7232
  { PseudoVSEXT_VF4_M2, VSEXT_VF4, 0x1, 0x0 }, // 7233
  { PseudoVSEXT_VF4_M2_MASK, VSEXT_VF4, 0x1, 0x0 }, // 7234
  { PseudoVSEXT_VF4_M4, VSEXT_VF4, 0x2, 0x0 }, // 7235
  { PseudoVSEXT_VF4_M4_MASK, VSEXT_VF4, 0x2, 0x0 }, // 7236
  { PseudoVSEXT_VF4_M8, VSEXT_VF4, 0x3, 0x0 }, // 7237
  { PseudoVSEXT_VF4_M8_MASK, VSEXT_VF4, 0x3, 0x0 }, // 7238
  { PseudoVSEXT_VF4_MF2, VSEXT_VF4, 0x7, 0x0 }, // 7239
  { PseudoVSEXT_VF4_MF2_MASK, VSEXT_VF4, 0x7, 0x0 }, // 7240
  { PseudoVSEXT_VF8_M1, VSEXT_VF8, 0x0, 0x0 }, // 7241
  { PseudoVSEXT_VF8_M1_MASK, VSEXT_VF8, 0x0, 0x0 }, // 7242
  { PseudoVSEXT_VF8_M2, VSEXT_VF8, 0x1, 0x0 }, // 7243
  { PseudoVSEXT_VF8_M2_MASK, VSEXT_VF8, 0x1, 0x0 }, // 7244
  { PseudoVSEXT_VF8_M4, VSEXT_VF8, 0x2, 0x0 }, // 7245
  { PseudoVSEXT_VF8_M4_MASK, VSEXT_VF8, 0x2, 0x0 }, // 7246
  { PseudoVSEXT_VF8_M8, VSEXT_VF8, 0x3, 0x0 }, // 7247
  { PseudoVSEXT_VF8_M8_MASK, VSEXT_VF8, 0x3, 0x0 }, // 7248
  { PseudoVSLIDE1DOWN_VX_M1, VSLIDE1DOWN_VX, 0x0, 0x0 }, // 7249
  { PseudoVSLIDE1DOWN_VX_M1_MASK, VSLIDE1DOWN_VX, 0x0, 0x0 }, // 7250
  { PseudoVSLIDE1DOWN_VX_M2, VSLIDE1DOWN_VX, 0x1, 0x0 }, // 7251
  { PseudoVSLIDE1DOWN_VX_M2_MASK, VSLIDE1DOWN_VX, 0x1, 0x0 }, // 7252
  { PseudoVSLIDE1DOWN_VX_M4, VSLIDE1DOWN_VX, 0x2, 0x0 }, // 7253
  { PseudoVSLIDE1DOWN_VX_M4_MASK, VSLIDE1DOWN_VX, 0x2, 0x0 }, // 7254
  { PseudoVSLIDE1DOWN_VX_M8, VSLIDE1DOWN_VX, 0x3, 0x0 }, // 7255
  { PseudoVSLIDE1DOWN_VX_M8_MASK, VSLIDE1DOWN_VX, 0x3, 0x0 }, // 7256
  { PseudoVSLIDE1DOWN_VX_MF8, VSLIDE1DOWN_VX, 0x5, 0x0 }, // 7257
  { PseudoVSLIDE1DOWN_VX_MF8_MASK, VSLIDE1DOWN_VX, 0x5, 0x0 }, // 7258
  { PseudoVSLIDE1DOWN_VX_MF4, VSLIDE1DOWN_VX, 0x6, 0x0 }, // 7259
  { PseudoVSLIDE1DOWN_VX_MF4_MASK, VSLIDE1DOWN_VX, 0x6, 0x0 }, // 7260
  { PseudoVSLIDE1DOWN_VX_MF2, VSLIDE1DOWN_VX, 0x7, 0x0 }, // 7261
  { PseudoVSLIDE1DOWN_VX_MF2_MASK, VSLIDE1DOWN_VX, 0x7, 0x0 }, // 7262
  { PseudoVSLIDE1UP_VX_M1, VSLIDE1UP_VX, 0x0, 0x0 }, // 7263
  { PseudoVSLIDE1UP_VX_M1_MASK, VSLIDE1UP_VX, 0x0, 0x0 }, // 7264
  { PseudoVSLIDE1UP_VX_M2, VSLIDE1UP_VX, 0x1, 0x0 }, // 7265
  { PseudoVSLIDE1UP_VX_M2_MASK, VSLIDE1UP_VX, 0x1, 0x0 }, // 7266
  { PseudoVSLIDE1UP_VX_M4, VSLIDE1UP_VX, 0x2, 0x0 }, // 7267
  { PseudoVSLIDE1UP_VX_M4_MASK, VSLIDE1UP_VX, 0x2, 0x0 }, // 7268
  { PseudoVSLIDE1UP_VX_M8, VSLIDE1UP_VX, 0x3, 0x0 }, // 7269
  { PseudoVSLIDE1UP_VX_M8_MASK, VSLIDE1UP_VX, 0x3, 0x0 }, // 7270
  { PseudoVSLIDE1UP_VX_MF8, VSLIDE1UP_VX, 0x5, 0x0 }, // 7271
  { PseudoVSLIDE1UP_VX_MF8_MASK, VSLIDE1UP_VX, 0x5, 0x0 }, // 7272
  { PseudoVSLIDE1UP_VX_MF4, VSLIDE1UP_VX, 0x6, 0x0 }, // 7273
  { PseudoVSLIDE1UP_VX_MF4_MASK, VSLIDE1UP_VX, 0x6, 0x0 }, // 7274
  { PseudoVSLIDE1UP_VX_MF2, VSLIDE1UP_VX, 0x7, 0x0 }, // 7275
  { PseudoVSLIDE1UP_VX_MF2_MASK, VSLIDE1UP_VX, 0x7, 0x0 }, // 7276
  { PseudoVSLIDEDOWN_VI_M1, VSLIDEDOWN_VI, 0x0, 0x0 }, // 7277
  { PseudoVSLIDEDOWN_VI_M1_MASK, VSLIDEDOWN_VI, 0x0, 0x0 }, // 7278
  { PseudoVSLIDEDOWN_VI_M2, VSLIDEDOWN_VI, 0x1, 0x0 }, // 7279
  { PseudoVSLIDEDOWN_VI_M2_MASK, VSLIDEDOWN_VI, 0x1, 0x0 }, // 7280
  { PseudoVSLIDEDOWN_VI_M4, VSLIDEDOWN_VI, 0x2, 0x0 }, // 7281
  { PseudoVSLIDEDOWN_VI_M4_MASK, VSLIDEDOWN_VI, 0x2, 0x0 }, // 7282
  { PseudoVSLIDEDOWN_VI_M8, VSLIDEDOWN_VI, 0x3, 0x0 }, // 7283
  { PseudoVSLIDEDOWN_VI_M8_MASK, VSLIDEDOWN_VI, 0x3, 0x0 }, // 7284
  { PseudoVSLIDEDOWN_VI_MF8, VSLIDEDOWN_VI, 0x5, 0x0 }, // 7285
  { PseudoVSLIDEDOWN_VI_MF8_MASK, VSLIDEDOWN_VI, 0x5, 0x0 }, // 7286
  { PseudoVSLIDEDOWN_VI_MF4, VSLIDEDOWN_VI, 0x6, 0x0 }, // 7287
  { PseudoVSLIDEDOWN_VI_MF4_MASK, VSLIDEDOWN_VI, 0x6, 0x0 }, // 7288
  { PseudoVSLIDEDOWN_VI_MF2, VSLIDEDOWN_VI, 0x7, 0x0 }, // 7289
  { PseudoVSLIDEDOWN_VI_MF2_MASK, VSLIDEDOWN_VI, 0x7, 0x0 }, // 7290
  { PseudoVSLIDEDOWN_VX_M1, VSLIDEDOWN_VX, 0x0, 0x0 }, // 7291
  { PseudoVSLIDEDOWN_VX_M1_MASK, VSLIDEDOWN_VX, 0x0, 0x0 }, // 7292
  { PseudoVSLIDEDOWN_VX_M2, VSLIDEDOWN_VX, 0x1, 0x0 }, // 7293
  { PseudoVSLIDEDOWN_VX_M2_MASK, VSLIDEDOWN_VX, 0x1, 0x0 }, // 7294
  { PseudoVSLIDEDOWN_VX_M4, VSLIDEDOWN_VX, 0x2, 0x0 }, // 7295
  { PseudoVSLIDEDOWN_VX_M4_MASK, VSLIDEDOWN_VX, 0x2, 0x0 }, // 7296
  { PseudoVSLIDEDOWN_VX_M8, VSLIDEDOWN_VX, 0x3, 0x0 }, // 7297
  { PseudoVSLIDEDOWN_VX_M8_MASK, VSLIDEDOWN_VX, 0x3, 0x0 }, // 7298
  { PseudoVSLIDEDOWN_VX_MF8, VSLIDEDOWN_VX, 0x5, 0x0 }, // 7299
  { PseudoVSLIDEDOWN_VX_MF8_MASK, VSLIDEDOWN_VX, 0x5, 0x0 }, // 7300
  { PseudoVSLIDEDOWN_VX_MF4, VSLIDEDOWN_VX, 0x6, 0x0 }, // 7301
  { PseudoVSLIDEDOWN_VX_MF4_MASK, VSLIDEDOWN_VX, 0x6, 0x0 }, // 7302
  { PseudoVSLIDEDOWN_VX_MF2, VSLIDEDOWN_VX, 0x7, 0x0 }, // 7303
  { PseudoVSLIDEDOWN_VX_MF2_MASK, VSLIDEDOWN_VX, 0x7, 0x0 }, // 7304
  { PseudoVSLIDEUP_VI_M1, VSLIDEUP_VI, 0x0, 0x0 }, // 7305
  { PseudoVSLIDEUP_VI_M1_MASK, VSLIDEUP_VI, 0x0, 0x0 }, // 7306
  { PseudoVSLIDEUP_VI_M2, VSLIDEUP_VI, 0x1, 0x0 }, // 7307
  { PseudoVSLIDEUP_VI_M2_MASK, VSLIDEUP_VI, 0x1, 0x0 }, // 7308
  { PseudoVSLIDEUP_VI_M4, VSLIDEUP_VI, 0x2, 0x0 }, // 7309
  { PseudoVSLIDEUP_VI_M4_MASK, VSLIDEUP_VI, 0x2, 0x0 }, // 7310
  { PseudoVSLIDEUP_VI_M8, VSLIDEUP_VI, 0x3, 0x0 }, // 7311
  { PseudoVSLIDEUP_VI_M8_MASK, VSLIDEUP_VI, 0x3, 0x0 }, // 7312
  { PseudoVSLIDEUP_VI_MF8, VSLIDEUP_VI, 0x5, 0x0 }, // 7313
  { PseudoVSLIDEUP_VI_MF8_MASK, VSLIDEUP_VI, 0x5, 0x0 }, // 7314
  { PseudoVSLIDEUP_VI_MF4, VSLIDEUP_VI, 0x6, 0x0 }, // 7315
  { PseudoVSLIDEUP_VI_MF4_MASK, VSLIDEUP_VI, 0x6, 0x0 }, // 7316
  { PseudoVSLIDEUP_VI_MF2, VSLIDEUP_VI, 0x7, 0x0 }, // 7317
  { PseudoVSLIDEUP_VI_MF2_MASK, VSLIDEUP_VI, 0x7, 0x0 }, // 7318
  { PseudoVSLIDEUP_VX_M1, VSLIDEUP_VX, 0x0, 0x0 }, // 7319
  { PseudoVSLIDEUP_VX_M1_MASK, VSLIDEUP_VX, 0x0, 0x0 }, // 7320
  { PseudoVSLIDEUP_VX_M2, VSLIDEUP_VX, 0x1, 0x0 }, // 7321
  { PseudoVSLIDEUP_VX_M2_MASK, VSLIDEUP_VX, 0x1, 0x0 }, // 7322
  { PseudoVSLIDEUP_VX_M4, VSLIDEUP_VX, 0x2, 0x0 }, // 7323
  { PseudoVSLIDEUP_VX_M4_MASK, VSLIDEUP_VX, 0x2, 0x0 }, // 7324
  { PseudoVSLIDEUP_VX_M8, VSLIDEUP_VX, 0x3, 0x0 }, // 7325
  { PseudoVSLIDEUP_VX_M8_MASK, VSLIDEUP_VX, 0x3, 0x0 }, // 7326
  { PseudoVSLIDEUP_VX_MF8, VSLIDEUP_VX, 0x5, 0x0 }, // 7327
  { PseudoVSLIDEUP_VX_MF8_MASK, VSLIDEUP_VX, 0x5, 0x0 }, // 7328
  { PseudoVSLIDEUP_VX_MF4, VSLIDEUP_VX, 0x6, 0x0 }, // 7329
  { PseudoVSLIDEUP_VX_MF4_MASK, VSLIDEUP_VX, 0x6, 0x0 }, // 7330
  { PseudoVSLIDEUP_VX_MF2, VSLIDEUP_VX, 0x7, 0x0 }, // 7331
  { PseudoVSLIDEUP_VX_MF2_MASK, VSLIDEUP_VX, 0x7, 0x0 }, // 7332
  { PseudoVSLL_VI_M1, VSLL_VI, 0x0, 0x0 }, // 7333
  { PseudoVSLL_VI_M1_MASK, VSLL_VI, 0x0, 0x0 }, // 7334
  { PseudoVSLL_VI_M2, VSLL_VI, 0x1, 0x0 }, // 7335
  { PseudoVSLL_VI_M2_MASK, VSLL_VI, 0x1, 0x0 }, // 7336
  { PseudoVSLL_VI_M4, VSLL_VI, 0x2, 0x0 }, // 7337
  { PseudoVSLL_VI_M4_MASK, VSLL_VI, 0x2, 0x0 }, // 7338
  { PseudoVSLL_VI_M8, VSLL_VI, 0x3, 0x0 }, // 7339
  { PseudoVSLL_VI_M8_MASK, VSLL_VI, 0x3, 0x0 }, // 7340
  { PseudoVSLL_VI_MF8, VSLL_VI, 0x5, 0x0 }, // 7341
  { PseudoVSLL_VI_MF8_MASK, VSLL_VI, 0x5, 0x0 }, // 7342
  { PseudoVSLL_VI_MF4, VSLL_VI, 0x6, 0x0 }, // 7343
  { PseudoVSLL_VI_MF4_MASK, VSLL_VI, 0x6, 0x0 }, // 7344
  { PseudoVSLL_VI_MF2, VSLL_VI, 0x7, 0x0 }, // 7345
  { PseudoVSLL_VI_MF2_MASK, VSLL_VI, 0x7, 0x0 }, // 7346
  { PseudoVSLL_VV_M1, VSLL_VV, 0x0, 0x0 }, // 7347
  { PseudoVSLL_VV_M1_MASK, VSLL_VV, 0x0, 0x0 }, // 7348
  { PseudoVSLL_VV_M2, VSLL_VV, 0x1, 0x0 }, // 7349
  { PseudoVSLL_VV_M2_MASK, VSLL_VV, 0x1, 0x0 }, // 7350
  { PseudoVSLL_VV_M4, VSLL_VV, 0x2, 0x0 }, // 7351
  { PseudoVSLL_VV_M4_MASK, VSLL_VV, 0x2, 0x0 }, // 7352
  { PseudoVSLL_VV_M8, VSLL_VV, 0x3, 0x0 }, // 7353
  { PseudoVSLL_VV_M8_MASK, VSLL_VV, 0x3, 0x0 }, // 7354
  { PseudoVSLL_VV_MF8, VSLL_VV, 0x5, 0x0 }, // 7355
  { PseudoVSLL_VV_MF8_MASK, VSLL_VV, 0x5, 0x0 }, // 7356
  { PseudoVSLL_VV_MF4, VSLL_VV, 0x6, 0x0 }, // 7357
  { PseudoVSLL_VV_MF4_MASK, VSLL_VV, 0x6, 0x0 }, // 7358
  { PseudoVSLL_VV_MF2, VSLL_VV, 0x7, 0x0 }, // 7359
  { PseudoVSLL_VV_MF2_MASK, VSLL_VV, 0x7, 0x0 }, // 7360
  { PseudoVSLL_VX_M1, VSLL_VX, 0x0, 0x0 }, // 7361
  { PseudoVSLL_VX_M1_MASK, VSLL_VX, 0x0, 0x0 }, // 7362
  { PseudoVSLL_VX_M2, VSLL_VX, 0x1, 0x0 }, // 7363
  { PseudoVSLL_VX_M2_MASK, VSLL_VX, 0x1, 0x0 }, // 7364
  { PseudoVSLL_VX_M4, VSLL_VX, 0x2, 0x0 }, // 7365
  { PseudoVSLL_VX_M4_MASK, VSLL_VX, 0x2, 0x0 }, // 7366
  { PseudoVSLL_VX_M8, VSLL_VX, 0x3, 0x0 }, // 7367
  { PseudoVSLL_VX_M8_MASK, VSLL_VX, 0x3, 0x0 }, // 7368
  { PseudoVSLL_VX_MF8, VSLL_VX, 0x5, 0x0 }, // 7369
  { PseudoVSLL_VX_MF8_MASK, VSLL_VX, 0x5, 0x0 }, // 7370
  { PseudoVSLL_VX_MF4, VSLL_VX, 0x6, 0x0 }, // 7371
  { PseudoVSLL_VX_MF4_MASK, VSLL_VX, 0x6, 0x0 }, // 7372
  { PseudoVSLL_VX_MF2, VSLL_VX, 0x7, 0x0 }, // 7373
  { PseudoVSLL_VX_MF2_MASK, VSLL_VX, 0x7, 0x0 }, // 7374
  { PseudoVSMUL_VV_M1, VSMUL_VV, 0x0, 0x0 }, // 7375
  { PseudoVSMUL_VV_M1_MASK, VSMUL_VV, 0x0, 0x0 }, // 7376
  { PseudoVSMUL_VV_M2, VSMUL_VV, 0x1, 0x0 }, // 7377
  { PseudoVSMUL_VV_M2_MASK, VSMUL_VV, 0x1, 0x0 }, // 7378
  { PseudoVSMUL_VV_M4, VSMUL_VV, 0x2, 0x0 }, // 7379
  { PseudoVSMUL_VV_M4_MASK, VSMUL_VV, 0x2, 0x0 }, // 7380
  { PseudoVSMUL_VV_M8, VSMUL_VV, 0x3, 0x0 }, // 7381
  { PseudoVSMUL_VV_M8_MASK, VSMUL_VV, 0x3, 0x0 }, // 7382
  { PseudoVSMUL_VV_MF8, VSMUL_VV, 0x5, 0x0 }, // 7383
  { PseudoVSMUL_VV_MF8_MASK, VSMUL_VV, 0x5, 0x0 }, // 7384
  { PseudoVSMUL_VV_MF4, VSMUL_VV, 0x6, 0x0 }, // 7385
  { PseudoVSMUL_VV_MF4_MASK, VSMUL_VV, 0x6, 0x0 }, // 7386
  { PseudoVSMUL_VV_MF2, VSMUL_VV, 0x7, 0x0 }, // 7387
  { PseudoVSMUL_VV_MF2_MASK, VSMUL_VV, 0x7, 0x0 }, // 7388
  { PseudoVSMUL_VX_M1, VSMUL_VX, 0x0, 0x0 }, // 7389
  { PseudoVSMUL_VX_M1_MASK, VSMUL_VX, 0x0, 0x0 }, // 7390
  { PseudoVSMUL_VX_M2, VSMUL_VX, 0x1, 0x0 }, // 7391
  { PseudoVSMUL_VX_M2_MASK, VSMUL_VX, 0x1, 0x0 }, // 7392
  { PseudoVSMUL_VX_M4, VSMUL_VX, 0x2, 0x0 }, // 7393
  { PseudoVSMUL_VX_M4_MASK, VSMUL_VX, 0x2, 0x0 }, // 7394
  { PseudoVSMUL_VX_M8, VSMUL_VX, 0x3, 0x0 }, // 7395
  { PseudoVSMUL_VX_M8_MASK, VSMUL_VX, 0x3, 0x0 }, // 7396
  { PseudoVSMUL_VX_MF8, VSMUL_VX, 0x5, 0x0 }, // 7397
  { PseudoVSMUL_VX_MF8_MASK, VSMUL_VX, 0x5, 0x0 }, // 7398
  { PseudoVSMUL_VX_MF4, VSMUL_VX, 0x6, 0x0 }, // 7399
  { PseudoVSMUL_VX_MF4_MASK, VSMUL_VX, 0x6, 0x0 }, // 7400
  { PseudoVSMUL_VX_MF2, VSMUL_VX, 0x7, 0x0 }, // 7401
  { PseudoVSMUL_VX_MF2_MASK, VSMUL_VX, 0x7, 0x0 }, // 7402
  { PseudoVSM_V_B8, VSM_V, 0x0, 0x0 }, // 7403
  { PseudoVSM_V_B16, VSM_V, 0x1, 0x0 }, // 7404
  { PseudoVSM_V_B32, VSM_V, 0x2, 0x0 }, // 7405
  { PseudoVSM_V_B64, VSM_V, 0x3, 0x0 }, // 7406
  { PseudoVSM_V_B1, VSM_V, 0x5, 0x0 }, // 7407
  { PseudoVSM_V_B2, VSM_V, 0x6, 0x0 }, // 7408
  { PseudoVSM_V_B4, VSM_V, 0x7, 0x0 }, // 7409
  { PseudoVSOXEI16_V_M1_M1, VSOXEI16_V, 0x0, 0x0 }, // 7410
  { PseudoVSOXEI16_V_M1_M1_MASK, VSOXEI16_V, 0x0, 0x0 }, // 7411
  { PseudoVSOXEI16_V_M2_M1, VSOXEI16_V, 0x0, 0x0 }, // 7412
  { PseudoVSOXEI16_V_M2_M1_MASK, VSOXEI16_V, 0x0, 0x0 }, // 7413
  { PseudoVSOXEI16_V_MF2_M1, VSOXEI16_V, 0x0, 0x0 }, // 7414
  { PseudoVSOXEI16_V_MF2_M1_MASK, VSOXEI16_V, 0x0, 0x0 }, // 7415
  { PseudoVSOXEI16_V_MF4_M1, VSOXEI16_V, 0x0, 0x0 }, // 7416
  { PseudoVSOXEI16_V_MF4_M1_MASK, VSOXEI16_V, 0x0, 0x0 }, // 7417
  { PseudoVSOXEI16_V_M1_M2, VSOXEI16_V, 0x1, 0x0 }, // 7418
  { PseudoVSOXEI16_V_M1_M2_MASK, VSOXEI16_V, 0x1, 0x0 }, // 7419
  { PseudoVSOXEI16_V_M2_M2, VSOXEI16_V, 0x1, 0x0 }, // 7420
  { PseudoVSOXEI16_V_M2_M2_MASK, VSOXEI16_V, 0x1, 0x0 }, // 7421
  { PseudoVSOXEI16_V_M4_M2, VSOXEI16_V, 0x1, 0x0 }, // 7422
  { PseudoVSOXEI16_V_M4_M2_MASK, VSOXEI16_V, 0x1, 0x0 }, // 7423
  { PseudoVSOXEI16_V_MF2_M2, VSOXEI16_V, 0x1, 0x0 }, // 7424
  { PseudoVSOXEI16_V_MF2_M2_MASK, VSOXEI16_V, 0x1, 0x0 }, // 7425
  { PseudoVSOXEI16_V_M1_M4, VSOXEI16_V, 0x2, 0x0 }, // 7426
  { PseudoVSOXEI16_V_M1_M4_MASK, VSOXEI16_V, 0x2, 0x0 }, // 7427
  { PseudoVSOXEI16_V_M2_M4, VSOXEI16_V, 0x2, 0x0 }, // 7428
  { PseudoVSOXEI16_V_M2_M4_MASK, VSOXEI16_V, 0x2, 0x0 }, // 7429
  { PseudoVSOXEI16_V_M4_M4, VSOXEI16_V, 0x2, 0x0 }, // 7430
  { PseudoVSOXEI16_V_M4_M4_MASK, VSOXEI16_V, 0x2, 0x0 }, // 7431
  { PseudoVSOXEI16_V_M8_M4, VSOXEI16_V, 0x2, 0x0 }, // 7432
  { PseudoVSOXEI16_V_M8_M4_MASK, VSOXEI16_V, 0x2, 0x0 }, // 7433
  { PseudoVSOXEI16_V_M2_M8, VSOXEI16_V, 0x3, 0x0 }, // 7434
  { PseudoVSOXEI16_V_M2_M8_MASK, VSOXEI16_V, 0x3, 0x0 }, // 7435
  { PseudoVSOXEI16_V_M4_M8, VSOXEI16_V, 0x3, 0x0 }, // 7436
  { PseudoVSOXEI16_V_M4_M8_MASK, VSOXEI16_V, 0x3, 0x0 }, // 7437
  { PseudoVSOXEI16_V_M8_M8, VSOXEI16_V, 0x3, 0x0 }, // 7438
  { PseudoVSOXEI16_V_M8_M8_MASK, VSOXEI16_V, 0x3, 0x0 }, // 7439
  { PseudoVSOXEI16_V_MF4_MF8, VSOXEI16_V, 0x5, 0x0 }, // 7440
  { PseudoVSOXEI16_V_MF4_MF8_MASK, VSOXEI16_V, 0x5, 0x0 }, // 7441
  { PseudoVSOXEI16_V_MF2_MF4, VSOXEI16_V, 0x6, 0x0 }, // 7442
  { PseudoVSOXEI16_V_MF2_MF4_MASK, VSOXEI16_V, 0x6, 0x0 }, // 7443
  { PseudoVSOXEI16_V_MF4_MF4, VSOXEI16_V, 0x6, 0x0 }, // 7444
  { PseudoVSOXEI16_V_MF4_MF4_MASK, VSOXEI16_V, 0x6, 0x0 }, // 7445
  { PseudoVSOXEI16_V_M1_MF2, VSOXEI16_V, 0x7, 0x0 }, // 7446
  { PseudoVSOXEI16_V_M1_MF2_MASK, VSOXEI16_V, 0x7, 0x0 }, // 7447
  { PseudoVSOXEI16_V_MF2_MF2, VSOXEI16_V, 0x7, 0x0 }, // 7448
  { PseudoVSOXEI16_V_MF2_MF2_MASK, VSOXEI16_V, 0x7, 0x0 }, // 7449
  { PseudoVSOXEI16_V_MF4_MF2, VSOXEI16_V, 0x7, 0x0 }, // 7450
  { PseudoVSOXEI16_V_MF4_MF2_MASK, VSOXEI16_V, 0x7, 0x0 }, // 7451
  { PseudoVSOXEI32_V_M1_M1, VSOXEI32_V, 0x0, 0x0 }, // 7452
  { PseudoVSOXEI32_V_M1_M1_MASK, VSOXEI32_V, 0x0, 0x0 }, // 7453
  { PseudoVSOXEI32_V_M2_M1, VSOXEI32_V, 0x0, 0x0 }, // 7454
  { PseudoVSOXEI32_V_M2_M1_MASK, VSOXEI32_V, 0x0, 0x0 }, // 7455
  { PseudoVSOXEI32_V_M4_M1, VSOXEI32_V, 0x0, 0x0 }, // 7456
  { PseudoVSOXEI32_V_M4_M1_MASK, VSOXEI32_V, 0x0, 0x0 }, // 7457
  { PseudoVSOXEI32_V_MF2_M1, VSOXEI32_V, 0x0, 0x0 }, // 7458
  { PseudoVSOXEI32_V_MF2_M1_MASK, VSOXEI32_V, 0x0, 0x0 }, // 7459
  { PseudoVSOXEI32_V_M1_M2, VSOXEI32_V, 0x1, 0x0 }, // 7460
  { PseudoVSOXEI32_V_M1_M2_MASK, VSOXEI32_V, 0x1, 0x0 }, // 7461
  { PseudoVSOXEI32_V_M2_M2, VSOXEI32_V, 0x1, 0x0 }, // 7462
  { PseudoVSOXEI32_V_M2_M2_MASK, VSOXEI32_V, 0x1, 0x0 }, // 7463
  { PseudoVSOXEI32_V_M4_M2, VSOXEI32_V, 0x1, 0x0 }, // 7464
  { PseudoVSOXEI32_V_M4_M2_MASK, VSOXEI32_V, 0x1, 0x0 }, // 7465
  { PseudoVSOXEI32_V_M8_M2, VSOXEI32_V, 0x1, 0x0 }, // 7466
  { PseudoVSOXEI32_V_M8_M2_MASK, VSOXEI32_V, 0x1, 0x0 }, // 7467
  { PseudoVSOXEI32_V_M2_M4, VSOXEI32_V, 0x2, 0x0 }, // 7468
  { PseudoVSOXEI32_V_M2_M4_MASK, VSOXEI32_V, 0x2, 0x0 }, // 7469
  { PseudoVSOXEI32_V_M4_M4, VSOXEI32_V, 0x2, 0x0 }, // 7470
  { PseudoVSOXEI32_V_M4_M4_MASK, VSOXEI32_V, 0x2, 0x0 }, // 7471
  { PseudoVSOXEI32_V_M8_M4, VSOXEI32_V, 0x2, 0x0 }, // 7472
  { PseudoVSOXEI32_V_M8_M4_MASK, VSOXEI32_V, 0x2, 0x0 }, // 7473
  { PseudoVSOXEI32_V_M4_M8, VSOXEI32_V, 0x3, 0x0 }, // 7474
  { PseudoVSOXEI32_V_M4_M8_MASK, VSOXEI32_V, 0x3, 0x0 }, // 7475
  { PseudoVSOXEI32_V_M8_M8, VSOXEI32_V, 0x3, 0x0 }, // 7476
  { PseudoVSOXEI32_V_M8_M8_MASK, VSOXEI32_V, 0x3, 0x0 }, // 7477
  { PseudoVSOXEI32_V_MF2_MF8, VSOXEI32_V, 0x5, 0x0 }, // 7478
  { PseudoVSOXEI32_V_MF2_MF8_MASK, VSOXEI32_V, 0x5, 0x0 }, // 7479
  { PseudoVSOXEI32_V_M1_MF4, VSOXEI32_V, 0x6, 0x0 }, // 7480
  { PseudoVSOXEI32_V_M1_MF4_MASK, VSOXEI32_V, 0x6, 0x0 }, // 7481
  { PseudoVSOXEI32_V_MF2_MF4, VSOXEI32_V, 0x6, 0x0 }, // 7482
  { PseudoVSOXEI32_V_MF2_MF4_MASK, VSOXEI32_V, 0x6, 0x0 }, // 7483
  { PseudoVSOXEI32_V_M1_MF2, VSOXEI32_V, 0x7, 0x0 }, // 7484
  { PseudoVSOXEI32_V_M1_MF2_MASK, VSOXEI32_V, 0x7, 0x0 }, // 7485
  { PseudoVSOXEI32_V_M2_MF2, VSOXEI32_V, 0x7, 0x0 }, // 7486
  { PseudoVSOXEI32_V_M2_MF2_MASK, VSOXEI32_V, 0x7, 0x0 }, // 7487
  { PseudoVSOXEI32_V_MF2_MF2, VSOXEI32_V, 0x7, 0x0 }, // 7488
  { PseudoVSOXEI32_V_MF2_MF2_MASK, VSOXEI32_V, 0x7, 0x0 }, // 7489
  { PseudoVSOXEI64_V_M1_M1, VSOXEI64_V, 0x0, 0x0 }, // 7490
  { PseudoVSOXEI64_V_M1_M1_MASK, VSOXEI64_V, 0x0, 0x0 }, // 7491
  { PseudoVSOXEI64_V_M2_M1, VSOXEI64_V, 0x0, 0x0 }, // 7492
  { PseudoVSOXEI64_V_M2_M1_MASK, VSOXEI64_V, 0x0, 0x0 }, // 7493
  { PseudoVSOXEI64_V_M4_M1, VSOXEI64_V, 0x0, 0x0 }, // 7494
  { PseudoVSOXEI64_V_M4_M1_MASK, VSOXEI64_V, 0x0, 0x0 }, // 7495
  { PseudoVSOXEI64_V_M8_M1, VSOXEI64_V, 0x0, 0x0 }, // 7496
  { PseudoVSOXEI64_V_M8_M1_MASK, VSOXEI64_V, 0x0, 0x0 }, // 7497
  { PseudoVSOXEI64_V_M2_M2, VSOXEI64_V, 0x1, 0x0 }, // 7498
  { PseudoVSOXEI64_V_M2_M2_MASK, VSOXEI64_V, 0x1, 0x0 }, // 7499
  { PseudoVSOXEI64_V_M4_M2, VSOXEI64_V, 0x1, 0x0 }, // 7500
  { PseudoVSOXEI64_V_M4_M2_MASK, VSOXEI64_V, 0x1, 0x0 }, // 7501
  { PseudoVSOXEI64_V_M8_M2, VSOXEI64_V, 0x1, 0x0 }, // 7502
  { PseudoVSOXEI64_V_M8_M2_MASK, VSOXEI64_V, 0x1, 0x0 }, // 7503
  { PseudoVSOXEI64_V_M4_M4, VSOXEI64_V, 0x2, 0x0 }, // 7504
  { PseudoVSOXEI64_V_M4_M4_MASK, VSOXEI64_V, 0x2, 0x0 }, // 7505
  { PseudoVSOXEI64_V_M8_M4, VSOXEI64_V, 0x2, 0x0 }, // 7506
  { PseudoVSOXEI64_V_M8_M4_MASK, VSOXEI64_V, 0x2, 0x0 }, // 7507
  { PseudoVSOXEI64_V_M8_M8, VSOXEI64_V, 0x3, 0x0 }, // 7508
  { PseudoVSOXEI64_V_M8_M8_MASK, VSOXEI64_V, 0x3, 0x0 }, // 7509
  { PseudoVSOXEI64_V_M1_MF8, VSOXEI64_V, 0x5, 0x0 }, // 7510
  { PseudoVSOXEI64_V_M1_MF8_MASK, VSOXEI64_V, 0x5, 0x0 }, // 7511
  { PseudoVSOXEI64_V_M1_MF4, VSOXEI64_V, 0x6, 0x0 }, // 7512
  { PseudoVSOXEI64_V_M1_MF4_MASK, VSOXEI64_V, 0x6, 0x0 }, // 7513
  { PseudoVSOXEI64_V_M2_MF4, VSOXEI64_V, 0x6, 0x0 }, // 7514
  { PseudoVSOXEI64_V_M2_MF4_MASK, VSOXEI64_V, 0x6, 0x0 }, // 7515
  { PseudoVSOXEI64_V_M1_MF2, VSOXEI64_V, 0x7, 0x0 }, // 7516
  { PseudoVSOXEI64_V_M1_MF2_MASK, VSOXEI64_V, 0x7, 0x0 }, // 7517
  { PseudoVSOXEI64_V_M2_MF2, VSOXEI64_V, 0x7, 0x0 }, // 7518
  { PseudoVSOXEI64_V_M2_MF2_MASK, VSOXEI64_V, 0x7, 0x0 }, // 7519
  { PseudoVSOXEI64_V_M4_MF2, VSOXEI64_V, 0x7, 0x0 }, // 7520
  { PseudoVSOXEI64_V_M4_MF2_MASK, VSOXEI64_V, 0x7, 0x0 }, // 7521
  { PseudoVSOXEI8_V_M1_M1, VSOXEI8_V, 0x0, 0x0 }, // 7522
  { PseudoVSOXEI8_V_M1_M1_MASK, VSOXEI8_V, 0x0, 0x0 }, // 7523
  { PseudoVSOXEI8_V_MF2_M1, VSOXEI8_V, 0x0, 0x0 }, // 7524
  { PseudoVSOXEI8_V_MF2_M1_MASK, VSOXEI8_V, 0x0, 0x0 }, // 7525
  { PseudoVSOXEI8_V_MF4_M1, VSOXEI8_V, 0x0, 0x0 }, // 7526
  { PseudoVSOXEI8_V_MF4_M1_MASK, VSOXEI8_V, 0x0, 0x0 }, // 7527
  { PseudoVSOXEI8_V_MF8_M1, VSOXEI8_V, 0x0, 0x0 }, // 7528
  { PseudoVSOXEI8_V_MF8_M1_MASK, VSOXEI8_V, 0x0, 0x0 }, // 7529
  { PseudoVSOXEI8_V_M1_M2, VSOXEI8_V, 0x1, 0x0 }, // 7530
  { PseudoVSOXEI8_V_M1_M2_MASK, VSOXEI8_V, 0x1, 0x0 }, // 7531
  { PseudoVSOXEI8_V_M2_M2, VSOXEI8_V, 0x1, 0x0 }, // 7532
  { PseudoVSOXEI8_V_M2_M2_MASK, VSOXEI8_V, 0x1, 0x0 }, // 7533
  { PseudoVSOXEI8_V_MF2_M2, VSOXEI8_V, 0x1, 0x0 }, // 7534
  { PseudoVSOXEI8_V_MF2_M2_MASK, VSOXEI8_V, 0x1, 0x0 }, // 7535
  { PseudoVSOXEI8_V_MF4_M2, VSOXEI8_V, 0x1, 0x0 }, // 7536
  { PseudoVSOXEI8_V_MF4_M2_MASK, VSOXEI8_V, 0x1, 0x0 }, // 7537
  { PseudoVSOXEI8_V_M1_M4, VSOXEI8_V, 0x2, 0x0 }, // 7538
  { PseudoVSOXEI8_V_M1_M4_MASK, VSOXEI8_V, 0x2, 0x0 }, // 7539
  { PseudoVSOXEI8_V_M2_M4, VSOXEI8_V, 0x2, 0x0 }, // 7540
  { PseudoVSOXEI8_V_M2_M4_MASK, VSOXEI8_V, 0x2, 0x0 }, // 7541
  { PseudoVSOXEI8_V_M4_M4, VSOXEI8_V, 0x2, 0x0 }, // 7542
  { PseudoVSOXEI8_V_M4_M4_MASK, VSOXEI8_V, 0x2, 0x0 }, // 7543
  { PseudoVSOXEI8_V_MF2_M4, VSOXEI8_V, 0x2, 0x0 }, // 7544
  { PseudoVSOXEI8_V_MF2_M4_MASK, VSOXEI8_V, 0x2, 0x0 }, // 7545
  { PseudoVSOXEI8_V_M1_M8, VSOXEI8_V, 0x3, 0x0 }, // 7546
  { PseudoVSOXEI8_V_M1_M8_MASK, VSOXEI8_V, 0x3, 0x0 }, // 7547
  { PseudoVSOXEI8_V_M2_M8, VSOXEI8_V, 0x3, 0x0 }, // 7548
  { PseudoVSOXEI8_V_M2_M8_MASK, VSOXEI8_V, 0x3, 0x0 }, // 7549
  { PseudoVSOXEI8_V_M4_M8, VSOXEI8_V, 0x3, 0x0 }, // 7550
  { PseudoVSOXEI8_V_M4_M8_MASK, VSOXEI8_V, 0x3, 0x0 }, // 7551
  { PseudoVSOXEI8_V_M8_M8, VSOXEI8_V, 0x3, 0x0 }, // 7552
  { PseudoVSOXEI8_V_M8_M8_MASK, VSOXEI8_V, 0x3, 0x0 }, // 7553
  { PseudoVSOXEI8_V_MF8_MF8, VSOXEI8_V, 0x5, 0x0 }, // 7554
  { PseudoVSOXEI8_V_MF8_MF8_MASK, VSOXEI8_V, 0x5, 0x0 }, // 7555
  { PseudoVSOXEI8_V_MF4_MF4, VSOXEI8_V, 0x6, 0x0 }, // 7556
  { PseudoVSOXEI8_V_MF4_MF4_MASK, VSOXEI8_V, 0x6, 0x0 }, // 7557
  { PseudoVSOXEI8_V_MF8_MF4, VSOXEI8_V, 0x6, 0x0 }, // 7558
  { PseudoVSOXEI8_V_MF8_MF4_MASK, VSOXEI8_V, 0x6, 0x0 }, // 7559
  { PseudoVSOXEI8_V_MF2_MF2, VSOXEI8_V, 0x7, 0x0 }, // 7560
  { PseudoVSOXEI8_V_MF2_MF2_MASK, VSOXEI8_V, 0x7, 0x0 }, // 7561
  { PseudoVSOXEI8_V_MF4_MF2, VSOXEI8_V, 0x7, 0x0 }, // 7562
  { PseudoVSOXEI8_V_MF4_MF2_MASK, VSOXEI8_V, 0x7, 0x0 }, // 7563
  { PseudoVSOXEI8_V_MF8_MF2, VSOXEI8_V, 0x7, 0x0 }, // 7564
  { PseudoVSOXEI8_V_MF8_MF2_MASK, VSOXEI8_V, 0x7, 0x0 }, // 7565
  { PseudoVSOXSEG2EI16_V_M1_M1, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7566
  { PseudoVSOXSEG2EI16_V_M1_M1_MASK, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7567
  { PseudoVSOXSEG2EI16_V_M2_M1, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7568
  { PseudoVSOXSEG2EI16_V_M2_M1_MASK, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7569
  { PseudoVSOXSEG2EI16_V_MF2_M1, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7570
  { PseudoVSOXSEG2EI16_V_MF2_M1_MASK, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7571
  { PseudoVSOXSEG2EI16_V_MF4_M1, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7572
  { PseudoVSOXSEG2EI16_V_MF4_M1_MASK, VSOXSEG2EI16_V, 0x0, 0x0 }, // 7573
  { PseudoVSOXSEG2EI16_V_M1_M2, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7574
  { PseudoVSOXSEG2EI16_V_M1_M2_MASK, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7575
  { PseudoVSOXSEG2EI16_V_M2_M2, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7576
  { PseudoVSOXSEG2EI16_V_M2_M2_MASK, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7577
  { PseudoVSOXSEG2EI16_V_M4_M2, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7578
  { PseudoVSOXSEG2EI16_V_M4_M2_MASK, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7579
  { PseudoVSOXSEG2EI16_V_MF2_M2, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7580
  { PseudoVSOXSEG2EI16_V_MF2_M2_MASK, VSOXSEG2EI16_V, 0x1, 0x0 }, // 7581
  { PseudoVSOXSEG2EI16_V_M1_M4, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7582
  { PseudoVSOXSEG2EI16_V_M1_M4_MASK, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7583
  { PseudoVSOXSEG2EI16_V_M2_M4, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7584
  { PseudoVSOXSEG2EI16_V_M2_M4_MASK, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7585
  { PseudoVSOXSEG2EI16_V_M4_M4, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7586
  { PseudoVSOXSEG2EI16_V_M4_M4_MASK, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7587
  { PseudoVSOXSEG2EI16_V_M8_M4, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7588
  { PseudoVSOXSEG2EI16_V_M8_M4_MASK, VSOXSEG2EI16_V, 0x2, 0x0 }, // 7589
  { PseudoVSOXSEG2EI16_V_MF4_MF8, VSOXSEG2EI16_V, 0x5, 0x0 }, // 7590
  { PseudoVSOXSEG2EI16_V_MF4_MF8_MASK, VSOXSEG2EI16_V, 0x5, 0x0 }, // 7591
  { PseudoVSOXSEG2EI16_V_MF2_MF4, VSOXSEG2EI16_V, 0x6, 0x0 }, // 7592
  { PseudoVSOXSEG2EI16_V_MF2_MF4_MASK, VSOXSEG2EI16_V, 0x6, 0x0 }, // 7593
  { PseudoVSOXSEG2EI16_V_MF4_MF4, VSOXSEG2EI16_V, 0x6, 0x0 }, // 7594
  { PseudoVSOXSEG2EI16_V_MF4_MF4_MASK, VSOXSEG2EI16_V, 0x6, 0x0 }, // 7595
  { PseudoVSOXSEG2EI16_V_M1_MF2, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7596
  { PseudoVSOXSEG2EI16_V_M1_MF2_MASK, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7597
  { PseudoVSOXSEG2EI16_V_MF2_MF2, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7598
  { PseudoVSOXSEG2EI16_V_MF2_MF2_MASK, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7599
  { PseudoVSOXSEG2EI16_V_MF4_MF2, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7600
  { PseudoVSOXSEG2EI16_V_MF4_MF2_MASK, VSOXSEG2EI16_V, 0x7, 0x0 }, // 7601
  { PseudoVSOXSEG2EI32_V_M1_M1, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7602
  { PseudoVSOXSEG2EI32_V_M1_M1_MASK, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7603
  { PseudoVSOXSEG2EI32_V_M2_M1, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7604
  { PseudoVSOXSEG2EI32_V_M2_M1_MASK, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7605
  { PseudoVSOXSEG2EI32_V_M4_M1, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7606
  { PseudoVSOXSEG2EI32_V_M4_M1_MASK, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7607
  { PseudoVSOXSEG2EI32_V_MF2_M1, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7608
  { PseudoVSOXSEG2EI32_V_MF2_M1_MASK, VSOXSEG2EI32_V, 0x0, 0x0 }, // 7609
  { PseudoVSOXSEG2EI32_V_M1_M2, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7610
  { PseudoVSOXSEG2EI32_V_M1_M2_MASK, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7611
  { PseudoVSOXSEG2EI32_V_M2_M2, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7612
  { PseudoVSOXSEG2EI32_V_M2_M2_MASK, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7613
  { PseudoVSOXSEG2EI32_V_M4_M2, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7614
  { PseudoVSOXSEG2EI32_V_M4_M2_MASK, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7615
  { PseudoVSOXSEG2EI32_V_M8_M2, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7616
  { PseudoVSOXSEG2EI32_V_M8_M2_MASK, VSOXSEG2EI32_V, 0x1, 0x0 }, // 7617
  { PseudoVSOXSEG2EI32_V_M2_M4, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7618
  { PseudoVSOXSEG2EI32_V_M2_M4_MASK, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7619
  { PseudoVSOXSEG2EI32_V_M4_M4, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7620
  { PseudoVSOXSEG2EI32_V_M4_M4_MASK, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7621
  { PseudoVSOXSEG2EI32_V_M8_M4, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7622
  { PseudoVSOXSEG2EI32_V_M8_M4_MASK, VSOXSEG2EI32_V, 0x2, 0x0 }, // 7623
  { PseudoVSOXSEG2EI32_V_MF2_MF8, VSOXSEG2EI32_V, 0x5, 0x0 }, // 7624
  { PseudoVSOXSEG2EI32_V_MF2_MF8_MASK, VSOXSEG2EI32_V, 0x5, 0x0 }, // 7625
  { PseudoVSOXSEG2EI32_V_M1_MF4, VSOXSEG2EI32_V, 0x6, 0x0 }, // 7626
  { PseudoVSOXSEG2EI32_V_M1_MF4_MASK, VSOXSEG2EI32_V, 0x6, 0x0 }, // 7627
  { PseudoVSOXSEG2EI32_V_MF2_MF4, VSOXSEG2EI32_V, 0x6, 0x0 }, // 7628
  { PseudoVSOXSEG2EI32_V_MF2_MF4_MASK, VSOXSEG2EI32_V, 0x6, 0x0 }, // 7629
  { PseudoVSOXSEG2EI32_V_M1_MF2, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7630
  { PseudoVSOXSEG2EI32_V_M1_MF2_MASK, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7631
  { PseudoVSOXSEG2EI32_V_M2_MF2, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7632
  { PseudoVSOXSEG2EI32_V_M2_MF2_MASK, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7633
  { PseudoVSOXSEG2EI32_V_MF2_MF2, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7634
  { PseudoVSOXSEG2EI32_V_MF2_MF2_MASK, VSOXSEG2EI32_V, 0x7, 0x0 }, // 7635
  { PseudoVSOXSEG2EI64_V_M1_M1, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7636
  { PseudoVSOXSEG2EI64_V_M1_M1_MASK, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7637
  { PseudoVSOXSEG2EI64_V_M2_M1, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7638
  { PseudoVSOXSEG2EI64_V_M2_M1_MASK, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7639
  { PseudoVSOXSEG2EI64_V_M4_M1, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7640
  { PseudoVSOXSEG2EI64_V_M4_M1_MASK, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7641
  { PseudoVSOXSEG2EI64_V_M8_M1, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7642
  { PseudoVSOXSEG2EI64_V_M8_M1_MASK, VSOXSEG2EI64_V, 0x0, 0x0 }, // 7643
  { PseudoVSOXSEG2EI64_V_M2_M2, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7644
  { PseudoVSOXSEG2EI64_V_M2_M2_MASK, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7645
  { PseudoVSOXSEG2EI64_V_M4_M2, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7646
  { PseudoVSOXSEG2EI64_V_M4_M2_MASK, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7647
  { PseudoVSOXSEG2EI64_V_M8_M2, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7648
  { PseudoVSOXSEG2EI64_V_M8_M2_MASK, VSOXSEG2EI64_V, 0x1, 0x0 }, // 7649
  { PseudoVSOXSEG2EI64_V_M4_M4, VSOXSEG2EI64_V, 0x2, 0x0 }, // 7650
  { PseudoVSOXSEG2EI64_V_M4_M4_MASK, VSOXSEG2EI64_V, 0x2, 0x0 }, // 7651
  { PseudoVSOXSEG2EI64_V_M8_M4, VSOXSEG2EI64_V, 0x2, 0x0 }, // 7652
  { PseudoVSOXSEG2EI64_V_M8_M4_MASK, VSOXSEG2EI64_V, 0x2, 0x0 }, // 7653
  { PseudoVSOXSEG2EI64_V_M1_MF8, VSOXSEG2EI64_V, 0x5, 0x0 }, // 7654
  { PseudoVSOXSEG2EI64_V_M1_MF8_MASK, VSOXSEG2EI64_V, 0x5, 0x0 }, // 7655
  { PseudoVSOXSEG2EI64_V_M1_MF4, VSOXSEG2EI64_V, 0x6, 0x0 }, // 7656
  { PseudoVSOXSEG2EI64_V_M1_MF4_MASK, VSOXSEG2EI64_V, 0x6, 0x0 }, // 7657
  { PseudoVSOXSEG2EI64_V_M2_MF4, VSOXSEG2EI64_V, 0x6, 0x0 }, // 7658
  { PseudoVSOXSEG2EI64_V_M2_MF4_MASK, VSOXSEG2EI64_V, 0x6, 0x0 }, // 7659
  { PseudoVSOXSEG2EI64_V_M1_MF2, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7660
  { PseudoVSOXSEG2EI64_V_M1_MF2_MASK, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7661
  { PseudoVSOXSEG2EI64_V_M2_MF2, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7662
  { PseudoVSOXSEG2EI64_V_M2_MF2_MASK, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7663
  { PseudoVSOXSEG2EI64_V_M4_MF2, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7664
  { PseudoVSOXSEG2EI64_V_M4_MF2_MASK, VSOXSEG2EI64_V, 0x7, 0x0 }, // 7665
  { PseudoVSOXSEG2EI8_V_M1_M1, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7666
  { PseudoVSOXSEG2EI8_V_M1_M1_MASK, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7667
  { PseudoVSOXSEG2EI8_V_MF2_M1, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7668
  { PseudoVSOXSEG2EI8_V_MF2_M1_MASK, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7669
  { PseudoVSOXSEG2EI8_V_MF4_M1, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7670
  { PseudoVSOXSEG2EI8_V_MF4_M1_MASK, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7671
  { PseudoVSOXSEG2EI8_V_MF8_M1, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7672
  { PseudoVSOXSEG2EI8_V_MF8_M1_MASK, VSOXSEG2EI8_V, 0x0, 0x0 }, // 7673
  { PseudoVSOXSEG2EI8_V_M1_M2, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7674
  { PseudoVSOXSEG2EI8_V_M1_M2_MASK, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7675
  { PseudoVSOXSEG2EI8_V_M2_M2, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7676
  { PseudoVSOXSEG2EI8_V_M2_M2_MASK, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7677
  { PseudoVSOXSEG2EI8_V_MF2_M2, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7678
  { PseudoVSOXSEG2EI8_V_MF2_M2_MASK, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7679
  { PseudoVSOXSEG2EI8_V_MF4_M2, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7680
  { PseudoVSOXSEG2EI8_V_MF4_M2_MASK, VSOXSEG2EI8_V, 0x1, 0x0 }, // 7681
  { PseudoVSOXSEG2EI8_V_M1_M4, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7682
  { PseudoVSOXSEG2EI8_V_M1_M4_MASK, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7683
  { PseudoVSOXSEG2EI8_V_M2_M4, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7684
  { PseudoVSOXSEG2EI8_V_M2_M4_MASK, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7685
  { PseudoVSOXSEG2EI8_V_M4_M4, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7686
  { PseudoVSOXSEG2EI8_V_M4_M4_MASK, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7687
  { PseudoVSOXSEG2EI8_V_MF2_M4, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7688
  { PseudoVSOXSEG2EI8_V_MF2_M4_MASK, VSOXSEG2EI8_V, 0x2, 0x0 }, // 7689
  { PseudoVSOXSEG2EI8_V_MF8_MF8, VSOXSEG2EI8_V, 0x5, 0x0 }, // 7690
  { PseudoVSOXSEG2EI8_V_MF8_MF8_MASK, VSOXSEG2EI8_V, 0x5, 0x0 }, // 7691
  { PseudoVSOXSEG2EI8_V_MF4_MF4, VSOXSEG2EI8_V, 0x6, 0x0 }, // 7692
  { PseudoVSOXSEG2EI8_V_MF4_MF4_MASK, VSOXSEG2EI8_V, 0x6, 0x0 }, // 7693
  { PseudoVSOXSEG2EI8_V_MF8_MF4, VSOXSEG2EI8_V, 0x6, 0x0 }, // 7694
  { PseudoVSOXSEG2EI8_V_MF8_MF4_MASK, VSOXSEG2EI8_V, 0x6, 0x0 }, // 7695
  { PseudoVSOXSEG2EI8_V_MF2_MF2, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7696
  { PseudoVSOXSEG2EI8_V_MF2_MF2_MASK, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7697
  { PseudoVSOXSEG2EI8_V_MF4_MF2, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7698
  { PseudoVSOXSEG2EI8_V_MF4_MF2_MASK, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7699
  { PseudoVSOXSEG2EI8_V_MF8_MF2, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7700
  { PseudoVSOXSEG2EI8_V_MF8_MF2_MASK, VSOXSEG2EI8_V, 0x7, 0x0 }, // 7701
  { PseudoVSOXSEG3EI16_V_M1_M1, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7702
  { PseudoVSOXSEG3EI16_V_M1_M1_MASK, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7703
  { PseudoVSOXSEG3EI16_V_M2_M1, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7704
  { PseudoVSOXSEG3EI16_V_M2_M1_MASK, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7705
  { PseudoVSOXSEG3EI16_V_MF2_M1, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7706
  { PseudoVSOXSEG3EI16_V_MF2_M1_MASK, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7707
  { PseudoVSOXSEG3EI16_V_MF4_M1, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7708
  { PseudoVSOXSEG3EI16_V_MF4_M1_MASK, VSOXSEG3EI16_V, 0x0, 0x0 }, // 7709
  { PseudoVSOXSEG3EI16_V_M1_M2, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7710
  { PseudoVSOXSEG3EI16_V_M1_M2_MASK, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7711
  { PseudoVSOXSEG3EI16_V_M2_M2, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7712
  { PseudoVSOXSEG3EI16_V_M2_M2_MASK, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7713
  { PseudoVSOXSEG3EI16_V_M4_M2, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7714
  { PseudoVSOXSEG3EI16_V_M4_M2_MASK, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7715
  { PseudoVSOXSEG3EI16_V_MF2_M2, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7716
  { PseudoVSOXSEG3EI16_V_MF2_M2_MASK, VSOXSEG3EI16_V, 0x1, 0x0 }, // 7717
  { PseudoVSOXSEG3EI16_V_MF4_MF8, VSOXSEG3EI16_V, 0x5, 0x0 }, // 7718
  { PseudoVSOXSEG3EI16_V_MF4_MF8_MASK, VSOXSEG3EI16_V, 0x5, 0x0 }, // 7719
  { PseudoVSOXSEG3EI16_V_MF2_MF4, VSOXSEG3EI16_V, 0x6, 0x0 }, // 7720
  { PseudoVSOXSEG3EI16_V_MF2_MF4_MASK, VSOXSEG3EI16_V, 0x6, 0x0 }, // 7721
  { PseudoVSOXSEG3EI16_V_MF4_MF4, VSOXSEG3EI16_V, 0x6, 0x0 }, // 7722
  { PseudoVSOXSEG3EI16_V_MF4_MF4_MASK, VSOXSEG3EI16_V, 0x6, 0x0 }, // 7723
  { PseudoVSOXSEG3EI16_V_M1_MF2, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7724
  { PseudoVSOXSEG3EI16_V_M1_MF2_MASK, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7725
  { PseudoVSOXSEG3EI16_V_MF2_MF2, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7726
  { PseudoVSOXSEG3EI16_V_MF2_MF2_MASK, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7727
  { PseudoVSOXSEG3EI16_V_MF4_MF2, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7728
  { PseudoVSOXSEG3EI16_V_MF4_MF2_MASK, VSOXSEG3EI16_V, 0x7, 0x0 }, // 7729
  { PseudoVSOXSEG3EI32_V_M1_M1, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7730
  { PseudoVSOXSEG3EI32_V_M1_M1_MASK, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7731
  { PseudoVSOXSEG3EI32_V_M2_M1, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7732
  { PseudoVSOXSEG3EI32_V_M2_M1_MASK, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7733
  { PseudoVSOXSEG3EI32_V_M4_M1, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7734
  { PseudoVSOXSEG3EI32_V_M4_M1_MASK, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7735
  { PseudoVSOXSEG3EI32_V_MF2_M1, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7736
  { PseudoVSOXSEG3EI32_V_MF2_M1_MASK, VSOXSEG3EI32_V, 0x0, 0x0 }, // 7737
  { PseudoVSOXSEG3EI32_V_M1_M2, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7738
  { PseudoVSOXSEG3EI32_V_M1_M2_MASK, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7739
  { PseudoVSOXSEG3EI32_V_M2_M2, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7740
  { PseudoVSOXSEG3EI32_V_M2_M2_MASK, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7741
  { PseudoVSOXSEG3EI32_V_M4_M2, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7742
  { PseudoVSOXSEG3EI32_V_M4_M2_MASK, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7743
  { PseudoVSOXSEG3EI32_V_M8_M2, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7744
  { PseudoVSOXSEG3EI32_V_M8_M2_MASK, VSOXSEG3EI32_V, 0x1, 0x0 }, // 7745
  { PseudoVSOXSEG3EI32_V_MF2_MF8, VSOXSEG3EI32_V, 0x5, 0x0 }, // 7746
  { PseudoVSOXSEG3EI32_V_MF2_MF8_MASK, VSOXSEG3EI32_V, 0x5, 0x0 }, // 7747
  { PseudoVSOXSEG3EI32_V_M1_MF4, VSOXSEG3EI32_V, 0x6, 0x0 }, // 7748
  { PseudoVSOXSEG3EI32_V_M1_MF4_MASK, VSOXSEG3EI32_V, 0x6, 0x0 }, // 7749
  { PseudoVSOXSEG3EI32_V_MF2_MF4, VSOXSEG3EI32_V, 0x6, 0x0 }, // 7750
  { PseudoVSOXSEG3EI32_V_MF2_MF4_MASK, VSOXSEG3EI32_V, 0x6, 0x0 }, // 7751
  { PseudoVSOXSEG3EI32_V_M1_MF2, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7752
  { PseudoVSOXSEG3EI32_V_M1_MF2_MASK, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7753
  { PseudoVSOXSEG3EI32_V_M2_MF2, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7754
  { PseudoVSOXSEG3EI32_V_M2_MF2_MASK, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7755
  { PseudoVSOXSEG3EI32_V_MF2_MF2, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7756
  { PseudoVSOXSEG3EI32_V_MF2_MF2_MASK, VSOXSEG3EI32_V, 0x7, 0x0 }, // 7757
  { PseudoVSOXSEG3EI64_V_M1_M1, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7758
  { PseudoVSOXSEG3EI64_V_M1_M1_MASK, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7759
  { PseudoVSOXSEG3EI64_V_M2_M1, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7760
  { PseudoVSOXSEG3EI64_V_M2_M1_MASK, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7761
  { PseudoVSOXSEG3EI64_V_M4_M1, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7762
  { PseudoVSOXSEG3EI64_V_M4_M1_MASK, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7763
  { PseudoVSOXSEG3EI64_V_M8_M1, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7764
  { PseudoVSOXSEG3EI64_V_M8_M1_MASK, VSOXSEG3EI64_V, 0x0, 0x0 }, // 7765
  { PseudoVSOXSEG3EI64_V_M2_M2, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7766
  { PseudoVSOXSEG3EI64_V_M2_M2_MASK, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7767
  { PseudoVSOXSEG3EI64_V_M4_M2, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7768
  { PseudoVSOXSEG3EI64_V_M4_M2_MASK, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7769
  { PseudoVSOXSEG3EI64_V_M8_M2, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7770
  { PseudoVSOXSEG3EI64_V_M8_M2_MASK, VSOXSEG3EI64_V, 0x1, 0x0 }, // 7771
  { PseudoVSOXSEG3EI64_V_M1_MF8, VSOXSEG3EI64_V, 0x5, 0x0 }, // 7772
  { PseudoVSOXSEG3EI64_V_M1_MF8_MASK, VSOXSEG3EI64_V, 0x5, 0x0 }, // 7773
  { PseudoVSOXSEG3EI64_V_M1_MF4, VSOXSEG3EI64_V, 0x6, 0x0 }, // 7774
  { PseudoVSOXSEG3EI64_V_M1_MF4_MASK, VSOXSEG3EI64_V, 0x6, 0x0 }, // 7775
  { PseudoVSOXSEG3EI64_V_M2_MF4, VSOXSEG3EI64_V, 0x6, 0x0 }, // 7776
  { PseudoVSOXSEG3EI64_V_M2_MF4_MASK, VSOXSEG3EI64_V, 0x6, 0x0 }, // 7777
  { PseudoVSOXSEG3EI64_V_M1_MF2, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7778
  { PseudoVSOXSEG3EI64_V_M1_MF2_MASK, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7779
  { PseudoVSOXSEG3EI64_V_M2_MF2, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7780
  { PseudoVSOXSEG3EI64_V_M2_MF2_MASK, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7781
  { PseudoVSOXSEG3EI64_V_M4_MF2, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7782
  { PseudoVSOXSEG3EI64_V_M4_MF2_MASK, VSOXSEG3EI64_V, 0x7, 0x0 }, // 7783
  { PseudoVSOXSEG3EI8_V_M1_M1, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7784
  { PseudoVSOXSEG3EI8_V_M1_M1_MASK, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7785
  { PseudoVSOXSEG3EI8_V_MF2_M1, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7786
  { PseudoVSOXSEG3EI8_V_MF2_M1_MASK, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7787
  { PseudoVSOXSEG3EI8_V_MF4_M1, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7788
  { PseudoVSOXSEG3EI8_V_MF4_M1_MASK, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7789
  { PseudoVSOXSEG3EI8_V_MF8_M1, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7790
  { PseudoVSOXSEG3EI8_V_MF8_M1_MASK, VSOXSEG3EI8_V, 0x0, 0x0 }, // 7791
  { PseudoVSOXSEG3EI8_V_M1_M2, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7792
  { PseudoVSOXSEG3EI8_V_M1_M2_MASK, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7793
  { PseudoVSOXSEG3EI8_V_M2_M2, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7794
  { PseudoVSOXSEG3EI8_V_M2_M2_MASK, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7795
  { PseudoVSOXSEG3EI8_V_MF2_M2, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7796
  { PseudoVSOXSEG3EI8_V_MF2_M2_MASK, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7797
  { PseudoVSOXSEG3EI8_V_MF4_M2, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7798
  { PseudoVSOXSEG3EI8_V_MF4_M2_MASK, VSOXSEG3EI8_V, 0x1, 0x0 }, // 7799
  { PseudoVSOXSEG3EI8_V_MF8_MF8, VSOXSEG3EI8_V, 0x5, 0x0 }, // 7800
  { PseudoVSOXSEG3EI8_V_MF8_MF8_MASK, VSOXSEG3EI8_V, 0x5, 0x0 }, // 7801
  { PseudoVSOXSEG3EI8_V_MF4_MF4, VSOXSEG3EI8_V, 0x6, 0x0 }, // 7802
  { PseudoVSOXSEG3EI8_V_MF4_MF4_MASK, VSOXSEG3EI8_V, 0x6, 0x0 }, // 7803
  { PseudoVSOXSEG3EI8_V_MF8_MF4, VSOXSEG3EI8_V, 0x6, 0x0 }, // 7804
  { PseudoVSOXSEG3EI8_V_MF8_MF4_MASK, VSOXSEG3EI8_V, 0x6, 0x0 }, // 7805
  { PseudoVSOXSEG3EI8_V_MF2_MF2, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7806
  { PseudoVSOXSEG3EI8_V_MF2_MF2_MASK, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7807
  { PseudoVSOXSEG3EI8_V_MF4_MF2, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7808
  { PseudoVSOXSEG3EI8_V_MF4_MF2_MASK, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7809
  { PseudoVSOXSEG3EI8_V_MF8_MF2, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7810
  { PseudoVSOXSEG3EI8_V_MF8_MF2_MASK, VSOXSEG3EI8_V, 0x7, 0x0 }, // 7811
  { PseudoVSOXSEG4EI16_V_M1_M1, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7812
  { PseudoVSOXSEG4EI16_V_M1_M1_MASK, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7813
  { PseudoVSOXSEG4EI16_V_M2_M1, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7814
  { PseudoVSOXSEG4EI16_V_M2_M1_MASK, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7815
  { PseudoVSOXSEG4EI16_V_MF2_M1, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7816
  { PseudoVSOXSEG4EI16_V_MF2_M1_MASK, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7817
  { PseudoVSOXSEG4EI16_V_MF4_M1, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7818
  { PseudoVSOXSEG4EI16_V_MF4_M1_MASK, VSOXSEG4EI16_V, 0x0, 0x0 }, // 7819
  { PseudoVSOXSEG4EI16_V_M1_M2, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7820
  { PseudoVSOXSEG4EI16_V_M1_M2_MASK, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7821
  { PseudoVSOXSEG4EI16_V_M2_M2, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7822
  { PseudoVSOXSEG4EI16_V_M2_M2_MASK, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7823
  { PseudoVSOXSEG4EI16_V_M4_M2, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7824
  { PseudoVSOXSEG4EI16_V_M4_M2_MASK, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7825
  { PseudoVSOXSEG4EI16_V_MF2_M2, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7826
  { PseudoVSOXSEG4EI16_V_MF2_M2_MASK, VSOXSEG4EI16_V, 0x1, 0x0 }, // 7827
  { PseudoVSOXSEG4EI16_V_MF4_MF8, VSOXSEG4EI16_V, 0x5, 0x0 }, // 7828
  { PseudoVSOXSEG4EI16_V_MF4_MF8_MASK, VSOXSEG4EI16_V, 0x5, 0x0 }, // 7829
  { PseudoVSOXSEG4EI16_V_MF2_MF4, VSOXSEG4EI16_V, 0x6, 0x0 }, // 7830
  { PseudoVSOXSEG4EI16_V_MF2_MF4_MASK, VSOXSEG4EI16_V, 0x6, 0x0 }, // 7831
  { PseudoVSOXSEG4EI16_V_MF4_MF4, VSOXSEG4EI16_V, 0x6, 0x0 }, // 7832
  { PseudoVSOXSEG4EI16_V_MF4_MF4_MASK, VSOXSEG4EI16_V, 0x6, 0x0 }, // 7833
  { PseudoVSOXSEG4EI16_V_M1_MF2, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7834
  { PseudoVSOXSEG4EI16_V_M1_MF2_MASK, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7835
  { PseudoVSOXSEG4EI16_V_MF2_MF2, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7836
  { PseudoVSOXSEG4EI16_V_MF2_MF2_MASK, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7837
  { PseudoVSOXSEG4EI16_V_MF4_MF2, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7838
  { PseudoVSOXSEG4EI16_V_MF4_MF2_MASK, VSOXSEG4EI16_V, 0x7, 0x0 }, // 7839
  { PseudoVSOXSEG4EI32_V_M1_M1, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7840
  { PseudoVSOXSEG4EI32_V_M1_M1_MASK, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7841
  { PseudoVSOXSEG4EI32_V_M2_M1, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7842
  { PseudoVSOXSEG4EI32_V_M2_M1_MASK, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7843
  { PseudoVSOXSEG4EI32_V_M4_M1, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7844
  { PseudoVSOXSEG4EI32_V_M4_M1_MASK, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7845
  { PseudoVSOXSEG4EI32_V_MF2_M1, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7846
  { PseudoVSOXSEG4EI32_V_MF2_M1_MASK, VSOXSEG4EI32_V, 0x0, 0x0 }, // 7847
  { PseudoVSOXSEG4EI32_V_M1_M2, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7848
  { PseudoVSOXSEG4EI32_V_M1_M2_MASK, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7849
  { PseudoVSOXSEG4EI32_V_M2_M2, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7850
  { PseudoVSOXSEG4EI32_V_M2_M2_MASK, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7851
  { PseudoVSOXSEG4EI32_V_M4_M2, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7852
  { PseudoVSOXSEG4EI32_V_M4_M2_MASK, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7853
  { PseudoVSOXSEG4EI32_V_M8_M2, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7854
  { PseudoVSOXSEG4EI32_V_M8_M2_MASK, VSOXSEG4EI32_V, 0x1, 0x0 }, // 7855
  { PseudoVSOXSEG4EI32_V_MF2_MF8, VSOXSEG4EI32_V, 0x5, 0x0 }, // 7856
  { PseudoVSOXSEG4EI32_V_MF2_MF8_MASK, VSOXSEG4EI32_V, 0x5, 0x0 }, // 7857
  { PseudoVSOXSEG4EI32_V_M1_MF4, VSOXSEG4EI32_V, 0x6, 0x0 }, // 7858
  { PseudoVSOXSEG4EI32_V_M1_MF4_MASK, VSOXSEG4EI32_V, 0x6, 0x0 }, // 7859
  { PseudoVSOXSEG4EI32_V_MF2_MF4, VSOXSEG4EI32_V, 0x6, 0x0 }, // 7860
  { PseudoVSOXSEG4EI32_V_MF2_MF4_MASK, VSOXSEG4EI32_V, 0x6, 0x0 }, // 7861
  { PseudoVSOXSEG4EI32_V_M1_MF2, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7862
  { PseudoVSOXSEG4EI32_V_M1_MF2_MASK, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7863
  { PseudoVSOXSEG4EI32_V_M2_MF2, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7864
  { PseudoVSOXSEG4EI32_V_M2_MF2_MASK, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7865
  { PseudoVSOXSEG4EI32_V_MF2_MF2, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7866
  { PseudoVSOXSEG4EI32_V_MF2_MF2_MASK, VSOXSEG4EI32_V, 0x7, 0x0 }, // 7867
  { PseudoVSOXSEG4EI64_V_M1_M1, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7868
  { PseudoVSOXSEG4EI64_V_M1_M1_MASK, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7869
  { PseudoVSOXSEG4EI64_V_M2_M1, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7870
  { PseudoVSOXSEG4EI64_V_M2_M1_MASK, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7871
  { PseudoVSOXSEG4EI64_V_M4_M1, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7872
  { PseudoVSOXSEG4EI64_V_M4_M1_MASK, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7873
  { PseudoVSOXSEG4EI64_V_M8_M1, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7874
  { PseudoVSOXSEG4EI64_V_M8_M1_MASK, VSOXSEG4EI64_V, 0x0, 0x0 }, // 7875
  { PseudoVSOXSEG4EI64_V_M2_M2, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7876
  { PseudoVSOXSEG4EI64_V_M2_M2_MASK, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7877
  { PseudoVSOXSEG4EI64_V_M4_M2, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7878
  { PseudoVSOXSEG4EI64_V_M4_M2_MASK, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7879
  { PseudoVSOXSEG4EI64_V_M8_M2, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7880
  { PseudoVSOXSEG4EI64_V_M8_M2_MASK, VSOXSEG4EI64_V, 0x1, 0x0 }, // 7881
  { PseudoVSOXSEG4EI64_V_M1_MF8, VSOXSEG4EI64_V, 0x5, 0x0 }, // 7882
  { PseudoVSOXSEG4EI64_V_M1_MF8_MASK, VSOXSEG4EI64_V, 0x5, 0x0 }, // 7883
  { PseudoVSOXSEG4EI64_V_M1_MF4, VSOXSEG4EI64_V, 0x6, 0x0 }, // 7884
  { PseudoVSOXSEG4EI64_V_M1_MF4_MASK, VSOXSEG4EI64_V, 0x6, 0x0 }, // 7885
  { PseudoVSOXSEG4EI64_V_M2_MF4, VSOXSEG4EI64_V, 0x6, 0x0 }, // 7886
  { PseudoVSOXSEG4EI64_V_M2_MF4_MASK, VSOXSEG4EI64_V, 0x6, 0x0 }, // 7887
  { PseudoVSOXSEG4EI64_V_M1_MF2, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7888
  { PseudoVSOXSEG4EI64_V_M1_MF2_MASK, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7889
  { PseudoVSOXSEG4EI64_V_M2_MF2, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7890
  { PseudoVSOXSEG4EI64_V_M2_MF2_MASK, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7891
  { PseudoVSOXSEG4EI64_V_M4_MF2, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7892
  { PseudoVSOXSEG4EI64_V_M4_MF2_MASK, VSOXSEG4EI64_V, 0x7, 0x0 }, // 7893
  { PseudoVSOXSEG4EI8_V_M1_M1, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7894
  { PseudoVSOXSEG4EI8_V_M1_M1_MASK, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7895
  { PseudoVSOXSEG4EI8_V_MF2_M1, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7896
  { PseudoVSOXSEG4EI8_V_MF2_M1_MASK, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7897
  { PseudoVSOXSEG4EI8_V_MF4_M1, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7898
  { PseudoVSOXSEG4EI8_V_MF4_M1_MASK, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7899
  { PseudoVSOXSEG4EI8_V_MF8_M1, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7900
  { PseudoVSOXSEG4EI8_V_MF8_M1_MASK, VSOXSEG4EI8_V, 0x0, 0x0 }, // 7901
  { PseudoVSOXSEG4EI8_V_M1_M2, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7902
  { PseudoVSOXSEG4EI8_V_M1_M2_MASK, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7903
  { PseudoVSOXSEG4EI8_V_M2_M2, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7904
  { PseudoVSOXSEG4EI8_V_M2_M2_MASK, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7905
  { PseudoVSOXSEG4EI8_V_MF2_M2, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7906
  { PseudoVSOXSEG4EI8_V_MF2_M2_MASK, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7907
  { PseudoVSOXSEG4EI8_V_MF4_M2, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7908
  { PseudoVSOXSEG4EI8_V_MF4_M2_MASK, VSOXSEG4EI8_V, 0x1, 0x0 }, // 7909
  { PseudoVSOXSEG4EI8_V_MF8_MF8, VSOXSEG4EI8_V, 0x5, 0x0 }, // 7910
  { PseudoVSOXSEG4EI8_V_MF8_MF8_MASK, VSOXSEG4EI8_V, 0x5, 0x0 }, // 7911
  { PseudoVSOXSEG4EI8_V_MF4_MF4, VSOXSEG4EI8_V, 0x6, 0x0 }, // 7912
  { PseudoVSOXSEG4EI8_V_MF4_MF4_MASK, VSOXSEG4EI8_V, 0x6, 0x0 }, // 7913
  { PseudoVSOXSEG4EI8_V_MF8_MF4, VSOXSEG4EI8_V, 0x6, 0x0 }, // 7914
  { PseudoVSOXSEG4EI8_V_MF8_MF4_MASK, VSOXSEG4EI8_V, 0x6, 0x0 }, // 7915
  { PseudoVSOXSEG4EI8_V_MF2_MF2, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7916
  { PseudoVSOXSEG4EI8_V_MF2_MF2_MASK, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7917
  { PseudoVSOXSEG4EI8_V_MF4_MF2, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7918
  { PseudoVSOXSEG4EI8_V_MF4_MF2_MASK, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7919
  { PseudoVSOXSEG4EI8_V_MF8_MF2, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7920
  { PseudoVSOXSEG4EI8_V_MF8_MF2_MASK, VSOXSEG4EI8_V, 0x7, 0x0 }, // 7921
  { PseudoVSOXSEG5EI16_V_M1_M1, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7922
  { PseudoVSOXSEG5EI16_V_M1_M1_MASK, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7923
  { PseudoVSOXSEG5EI16_V_M2_M1, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7924
  { PseudoVSOXSEG5EI16_V_M2_M1_MASK, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7925
  { PseudoVSOXSEG5EI16_V_MF2_M1, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7926
  { PseudoVSOXSEG5EI16_V_MF2_M1_MASK, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7927
  { PseudoVSOXSEG5EI16_V_MF4_M1, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7928
  { PseudoVSOXSEG5EI16_V_MF4_M1_MASK, VSOXSEG5EI16_V, 0x0, 0x0 }, // 7929
  { PseudoVSOXSEG5EI16_V_MF4_MF8, VSOXSEG5EI16_V, 0x5, 0x0 }, // 7930
  { PseudoVSOXSEG5EI16_V_MF4_MF8_MASK, VSOXSEG5EI16_V, 0x5, 0x0 }, // 7931
  { PseudoVSOXSEG5EI16_V_MF2_MF4, VSOXSEG5EI16_V, 0x6, 0x0 }, // 7932
  { PseudoVSOXSEG5EI16_V_MF2_MF4_MASK, VSOXSEG5EI16_V, 0x6, 0x0 }, // 7933
  { PseudoVSOXSEG5EI16_V_MF4_MF4, VSOXSEG5EI16_V, 0x6, 0x0 }, // 7934
  { PseudoVSOXSEG5EI16_V_MF4_MF4_MASK, VSOXSEG5EI16_V, 0x6, 0x0 }, // 7935
  { PseudoVSOXSEG5EI16_V_M1_MF2, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7936
  { PseudoVSOXSEG5EI16_V_M1_MF2_MASK, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7937
  { PseudoVSOXSEG5EI16_V_MF2_MF2, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7938
  { PseudoVSOXSEG5EI16_V_MF2_MF2_MASK, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7939
  { PseudoVSOXSEG5EI16_V_MF4_MF2, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7940
  { PseudoVSOXSEG5EI16_V_MF4_MF2_MASK, VSOXSEG5EI16_V, 0x7, 0x0 }, // 7941
  { PseudoVSOXSEG5EI32_V_M1_M1, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7942
  { PseudoVSOXSEG5EI32_V_M1_M1_MASK, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7943
  { PseudoVSOXSEG5EI32_V_M2_M1, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7944
  { PseudoVSOXSEG5EI32_V_M2_M1_MASK, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7945
  { PseudoVSOXSEG5EI32_V_M4_M1, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7946
  { PseudoVSOXSEG5EI32_V_M4_M1_MASK, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7947
  { PseudoVSOXSEG5EI32_V_MF2_M1, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7948
  { PseudoVSOXSEG5EI32_V_MF2_M1_MASK, VSOXSEG5EI32_V, 0x0, 0x0 }, // 7949
  { PseudoVSOXSEG5EI32_V_MF2_MF8, VSOXSEG5EI32_V, 0x5, 0x0 }, // 7950
  { PseudoVSOXSEG5EI32_V_MF2_MF8_MASK, VSOXSEG5EI32_V, 0x5, 0x0 }, // 7951
  { PseudoVSOXSEG5EI32_V_M1_MF4, VSOXSEG5EI32_V, 0x6, 0x0 }, // 7952
  { PseudoVSOXSEG5EI32_V_M1_MF4_MASK, VSOXSEG5EI32_V, 0x6, 0x0 }, // 7953
  { PseudoVSOXSEG5EI32_V_MF2_MF4, VSOXSEG5EI32_V, 0x6, 0x0 }, // 7954
  { PseudoVSOXSEG5EI32_V_MF2_MF4_MASK, VSOXSEG5EI32_V, 0x6, 0x0 }, // 7955
  { PseudoVSOXSEG5EI32_V_M1_MF2, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7956
  { PseudoVSOXSEG5EI32_V_M1_MF2_MASK, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7957
  { PseudoVSOXSEG5EI32_V_M2_MF2, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7958
  { PseudoVSOXSEG5EI32_V_M2_MF2_MASK, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7959
  { PseudoVSOXSEG5EI32_V_MF2_MF2, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7960
  { PseudoVSOXSEG5EI32_V_MF2_MF2_MASK, VSOXSEG5EI32_V, 0x7, 0x0 }, // 7961
  { PseudoVSOXSEG5EI64_V_M1_M1, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7962
  { PseudoVSOXSEG5EI64_V_M1_M1_MASK, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7963
  { PseudoVSOXSEG5EI64_V_M2_M1, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7964
  { PseudoVSOXSEG5EI64_V_M2_M1_MASK, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7965
  { PseudoVSOXSEG5EI64_V_M4_M1, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7966
  { PseudoVSOXSEG5EI64_V_M4_M1_MASK, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7967
  { PseudoVSOXSEG5EI64_V_M8_M1, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7968
  { PseudoVSOXSEG5EI64_V_M8_M1_MASK, VSOXSEG5EI64_V, 0x0, 0x0 }, // 7969
  { PseudoVSOXSEG5EI64_V_M1_MF8, VSOXSEG5EI64_V, 0x5, 0x0 }, // 7970
  { PseudoVSOXSEG5EI64_V_M1_MF8_MASK, VSOXSEG5EI64_V, 0x5, 0x0 }, // 7971
  { PseudoVSOXSEG5EI64_V_M1_MF4, VSOXSEG5EI64_V, 0x6, 0x0 }, // 7972
  { PseudoVSOXSEG5EI64_V_M1_MF4_MASK, VSOXSEG5EI64_V, 0x6, 0x0 }, // 7973
  { PseudoVSOXSEG5EI64_V_M2_MF4, VSOXSEG5EI64_V, 0x6, 0x0 }, // 7974
  { PseudoVSOXSEG5EI64_V_M2_MF4_MASK, VSOXSEG5EI64_V, 0x6, 0x0 }, // 7975
  { PseudoVSOXSEG5EI64_V_M1_MF2, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7976
  { PseudoVSOXSEG5EI64_V_M1_MF2_MASK, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7977
  { PseudoVSOXSEG5EI64_V_M2_MF2, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7978
  { PseudoVSOXSEG5EI64_V_M2_MF2_MASK, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7979
  { PseudoVSOXSEG5EI64_V_M4_MF2, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7980
  { PseudoVSOXSEG5EI64_V_M4_MF2_MASK, VSOXSEG5EI64_V, 0x7, 0x0 }, // 7981
  { PseudoVSOXSEG5EI8_V_M1_M1, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7982
  { PseudoVSOXSEG5EI8_V_M1_M1_MASK, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7983
  { PseudoVSOXSEG5EI8_V_MF2_M1, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7984
  { PseudoVSOXSEG5EI8_V_MF2_M1_MASK, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7985
  { PseudoVSOXSEG5EI8_V_MF4_M1, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7986
  { PseudoVSOXSEG5EI8_V_MF4_M1_MASK, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7987
  { PseudoVSOXSEG5EI8_V_MF8_M1, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7988
  { PseudoVSOXSEG5EI8_V_MF8_M1_MASK, VSOXSEG5EI8_V, 0x0, 0x0 }, // 7989
  { PseudoVSOXSEG5EI8_V_MF8_MF8, VSOXSEG5EI8_V, 0x5, 0x0 }, // 7990
  { PseudoVSOXSEG5EI8_V_MF8_MF8_MASK, VSOXSEG5EI8_V, 0x5, 0x0 }, // 7991
  { PseudoVSOXSEG5EI8_V_MF4_MF4, VSOXSEG5EI8_V, 0x6, 0x0 }, // 7992
  { PseudoVSOXSEG5EI8_V_MF4_MF4_MASK, VSOXSEG5EI8_V, 0x6, 0x0 }, // 7993
  { PseudoVSOXSEG5EI8_V_MF8_MF4, VSOXSEG5EI8_V, 0x6, 0x0 }, // 7994
  { PseudoVSOXSEG5EI8_V_MF8_MF4_MASK, VSOXSEG5EI8_V, 0x6, 0x0 }, // 7995
  { PseudoVSOXSEG5EI8_V_MF2_MF2, VSOXSEG5EI8_V, 0x7, 0x0 }, // 7996
  { PseudoVSOXSEG5EI8_V_MF2_MF2_MASK, VSOXSEG5EI8_V, 0x7, 0x0 }, // 7997
  { PseudoVSOXSEG5EI8_V_MF4_MF2, VSOXSEG5EI8_V, 0x7, 0x0 }, // 7998
  { PseudoVSOXSEG5EI8_V_MF4_MF2_MASK, VSOXSEG5EI8_V, 0x7, 0x0 }, // 7999
  { PseudoVSOXSEG5EI8_V_MF8_MF2, VSOXSEG5EI8_V, 0x7, 0x0 }, // 8000
  { PseudoVSOXSEG5EI8_V_MF8_MF2_MASK, VSOXSEG5EI8_V, 0x7, 0x0 }, // 8001
  { PseudoVSOXSEG6EI16_V_M1_M1, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8002
  { PseudoVSOXSEG6EI16_V_M1_M1_MASK, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8003
  { PseudoVSOXSEG6EI16_V_M2_M1, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8004
  { PseudoVSOXSEG6EI16_V_M2_M1_MASK, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8005
  { PseudoVSOXSEG6EI16_V_MF2_M1, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8006
  { PseudoVSOXSEG6EI16_V_MF2_M1_MASK, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8007
  { PseudoVSOXSEG6EI16_V_MF4_M1, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8008
  { PseudoVSOXSEG6EI16_V_MF4_M1_MASK, VSOXSEG6EI16_V, 0x0, 0x0 }, // 8009
  { PseudoVSOXSEG6EI16_V_MF4_MF8, VSOXSEG6EI16_V, 0x5, 0x0 }, // 8010
  { PseudoVSOXSEG6EI16_V_MF4_MF8_MASK, VSOXSEG6EI16_V, 0x5, 0x0 }, // 8011
  { PseudoVSOXSEG6EI16_V_MF2_MF4, VSOXSEG6EI16_V, 0x6, 0x0 }, // 8012
  { PseudoVSOXSEG6EI16_V_MF2_MF4_MASK, VSOXSEG6EI16_V, 0x6, 0x0 }, // 8013
  { PseudoVSOXSEG6EI16_V_MF4_MF4, VSOXSEG6EI16_V, 0x6, 0x0 }, // 8014
  { PseudoVSOXSEG6EI16_V_MF4_MF4_MASK, VSOXSEG6EI16_V, 0x6, 0x0 }, // 8015
  { PseudoVSOXSEG6EI16_V_M1_MF2, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8016
  { PseudoVSOXSEG6EI16_V_M1_MF2_MASK, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8017
  { PseudoVSOXSEG6EI16_V_MF2_MF2, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8018
  { PseudoVSOXSEG6EI16_V_MF2_MF2_MASK, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8019
  { PseudoVSOXSEG6EI16_V_MF4_MF2, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8020
  { PseudoVSOXSEG6EI16_V_MF4_MF2_MASK, VSOXSEG6EI16_V, 0x7, 0x0 }, // 8021
  { PseudoVSOXSEG6EI32_V_M1_M1, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8022
  { PseudoVSOXSEG6EI32_V_M1_M1_MASK, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8023
  { PseudoVSOXSEG6EI32_V_M2_M1, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8024
  { PseudoVSOXSEG6EI32_V_M2_M1_MASK, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8025
  { PseudoVSOXSEG6EI32_V_M4_M1, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8026
  { PseudoVSOXSEG6EI32_V_M4_M1_MASK, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8027
  { PseudoVSOXSEG6EI32_V_MF2_M1, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8028
  { PseudoVSOXSEG6EI32_V_MF2_M1_MASK, VSOXSEG6EI32_V, 0x0, 0x0 }, // 8029
  { PseudoVSOXSEG6EI32_V_MF2_MF8, VSOXSEG6EI32_V, 0x5, 0x0 }, // 8030
  { PseudoVSOXSEG6EI32_V_MF2_MF8_MASK, VSOXSEG6EI32_V, 0x5, 0x0 }, // 8031
  { PseudoVSOXSEG6EI32_V_M1_MF4, VSOXSEG6EI32_V, 0x6, 0x0 }, // 8032
  { PseudoVSOXSEG6EI32_V_M1_MF4_MASK, VSOXSEG6EI32_V, 0x6, 0x0 }, // 8033
  { PseudoVSOXSEG6EI32_V_MF2_MF4, VSOXSEG6EI32_V, 0x6, 0x0 }, // 8034
  { PseudoVSOXSEG6EI32_V_MF2_MF4_MASK, VSOXSEG6EI32_V, 0x6, 0x0 }, // 8035
  { PseudoVSOXSEG6EI32_V_M1_MF2, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8036
  { PseudoVSOXSEG6EI32_V_M1_MF2_MASK, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8037
  { PseudoVSOXSEG6EI32_V_M2_MF2, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8038
  { PseudoVSOXSEG6EI32_V_M2_MF2_MASK, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8039
  { PseudoVSOXSEG6EI32_V_MF2_MF2, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8040
  { PseudoVSOXSEG6EI32_V_MF2_MF2_MASK, VSOXSEG6EI32_V, 0x7, 0x0 }, // 8041
  { PseudoVSOXSEG6EI64_V_M1_M1, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8042
  { PseudoVSOXSEG6EI64_V_M1_M1_MASK, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8043
  { PseudoVSOXSEG6EI64_V_M2_M1, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8044
  { PseudoVSOXSEG6EI64_V_M2_M1_MASK, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8045
  { PseudoVSOXSEG6EI64_V_M4_M1, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8046
  { PseudoVSOXSEG6EI64_V_M4_M1_MASK, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8047
  { PseudoVSOXSEG6EI64_V_M8_M1, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8048
  { PseudoVSOXSEG6EI64_V_M8_M1_MASK, VSOXSEG6EI64_V, 0x0, 0x0 }, // 8049
  { PseudoVSOXSEG6EI64_V_M1_MF8, VSOXSEG6EI64_V, 0x5, 0x0 }, // 8050
  { PseudoVSOXSEG6EI64_V_M1_MF8_MASK, VSOXSEG6EI64_V, 0x5, 0x0 }, // 8051
  { PseudoVSOXSEG6EI64_V_M1_MF4, VSOXSEG6EI64_V, 0x6, 0x0 }, // 8052
  { PseudoVSOXSEG6EI64_V_M1_MF4_MASK, VSOXSEG6EI64_V, 0x6, 0x0 }, // 8053
  { PseudoVSOXSEG6EI64_V_M2_MF4, VSOXSEG6EI64_V, 0x6, 0x0 }, // 8054
  { PseudoVSOXSEG6EI64_V_M2_MF4_MASK, VSOXSEG6EI64_V, 0x6, 0x0 }, // 8055
  { PseudoVSOXSEG6EI64_V_M1_MF2, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8056
  { PseudoVSOXSEG6EI64_V_M1_MF2_MASK, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8057
  { PseudoVSOXSEG6EI64_V_M2_MF2, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8058
  { PseudoVSOXSEG6EI64_V_M2_MF2_MASK, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8059
  { PseudoVSOXSEG6EI64_V_M4_MF2, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8060
  { PseudoVSOXSEG6EI64_V_M4_MF2_MASK, VSOXSEG6EI64_V, 0x7, 0x0 }, // 8061
  { PseudoVSOXSEG6EI8_V_M1_M1, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8062
  { PseudoVSOXSEG6EI8_V_M1_M1_MASK, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8063
  { PseudoVSOXSEG6EI8_V_MF2_M1, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8064
  { PseudoVSOXSEG6EI8_V_MF2_M1_MASK, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8065
  { PseudoVSOXSEG6EI8_V_MF4_M1, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8066
  { PseudoVSOXSEG6EI8_V_MF4_M1_MASK, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8067
  { PseudoVSOXSEG6EI8_V_MF8_M1, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8068
  { PseudoVSOXSEG6EI8_V_MF8_M1_MASK, VSOXSEG6EI8_V, 0x0, 0x0 }, // 8069
  { PseudoVSOXSEG6EI8_V_MF8_MF8, VSOXSEG6EI8_V, 0x5, 0x0 }, // 8070
  { PseudoVSOXSEG6EI8_V_MF8_MF8_MASK, VSOXSEG6EI8_V, 0x5, 0x0 }, // 8071
  { PseudoVSOXSEG6EI8_V_MF4_MF4, VSOXSEG6EI8_V, 0x6, 0x0 }, // 8072
  { PseudoVSOXSEG6EI8_V_MF4_MF4_MASK, VSOXSEG6EI8_V, 0x6, 0x0 }, // 8073
  { PseudoVSOXSEG6EI8_V_MF8_MF4, VSOXSEG6EI8_V, 0x6, 0x0 }, // 8074
  { PseudoVSOXSEG6EI8_V_MF8_MF4_MASK, VSOXSEG6EI8_V, 0x6, 0x0 }, // 8075
  { PseudoVSOXSEG6EI8_V_MF2_MF2, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8076
  { PseudoVSOXSEG6EI8_V_MF2_MF2_MASK, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8077
  { PseudoVSOXSEG6EI8_V_MF4_MF2, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8078
  { PseudoVSOXSEG6EI8_V_MF4_MF2_MASK, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8079
  { PseudoVSOXSEG6EI8_V_MF8_MF2, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8080
  { PseudoVSOXSEG6EI8_V_MF8_MF2_MASK, VSOXSEG6EI8_V, 0x7, 0x0 }, // 8081
  { PseudoVSOXSEG7EI16_V_M1_M1, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8082
  { PseudoVSOXSEG7EI16_V_M1_M1_MASK, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8083
  { PseudoVSOXSEG7EI16_V_M2_M1, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8084
  { PseudoVSOXSEG7EI16_V_M2_M1_MASK, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8085
  { PseudoVSOXSEG7EI16_V_MF2_M1, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8086
  { PseudoVSOXSEG7EI16_V_MF2_M1_MASK, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8087
  { PseudoVSOXSEG7EI16_V_MF4_M1, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8088
  { PseudoVSOXSEG7EI16_V_MF4_M1_MASK, VSOXSEG7EI16_V, 0x0, 0x0 }, // 8089
  { PseudoVSOXSEG7EI16_V_MF4_MF8, VSOXSEG7EI16_V, 0x5, 0x0 }, // 8090
  { PseudoVSOXSEG7EI16_V_MF4_MF8_MASK, VSOXSEG7EI16_V, 0x5, 0x0 }, // 8091
  { PseudoVSOXSEG7EI16_V_MF2_MF4, VSOXSEG7EI16_V, 0x6, 0x0 }, // 8092
  { PseudoVSOXSEG7EI16_V_MF2_MF4_MASK, VSOXSEG7EI16_V, 0x6, 0x0 }, // 8093
  { PseudoVSOXSEG7EI16_V_MF4_MF4, VSOXSEG7EI16_V, 0x6, 0x0 }, // 8094
  { PseudoVSOXSEG7EI16_V_MF4_MF4_MASK, VSOXSEG7EI16_V, 0x6, 0x0 }, // 8095
  { PseudoVSOXSEG7EI16_V_M1_MF2, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8096
  { PseudoVSOXSEG7EI16_V_M1_MF2_MASK, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8097
  { PseudoVSOXSEG7EI16_V_MF2_MF2, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8098
  { PseudoVSOXSEG7EI16_V_MF2_MF2_MASK, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8099
  { PseudoVSOXSEG7EI16_V_MF4_MF2, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8100
  { PseudoVSOXSEG7EI16_V_MF4_MF2_MASK, VSOXSEG7EI16_V, 0x7, 0x0 }, // 8101
  { PseudoVSOXSEG7EI32_V_M1_M1, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8102
  { PseudoVSOXSEG7EI32_V_M1_M1_MASK, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8103
  { PseudoVSOXSEG7EI32_V_M2_M1, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8104
  { PseudoVSOXSEG7EI32_V_M2_M1_MASK, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8105
  { PseudoVSOXSEG7EI32_V_M4_M1, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8106
  { PseudoVSOXSEG7EI32_V_M4_M1_MASK, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8107
  { PseudoVSOXSEG7EI32_V_MF2_M1, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8108
  { PseudoVSOXSEG7EI32_V_MF2_M1_MASK, VSOXSEG7EI32_V, 0x0, 0x0 }, // 8109
  { PseudoVSOXSEG7EI32_V_MF2_MF8, VSOXSEG7EI32_V, 0x5, 0x0 }, // 8110
  { PseudoVSOXSEG7EI32_V_MF2_MF8_MASK, VSOXSEG7EI32_V, 0x5, 0x0 }, // 8111
  { PseudoVSOXSEG7EI32_V_M1_MF4, VSOXSEG7EI32_V, 0x6, 0x0 }, // 8112
  { PseudoVSOXSEG7EI32_V_M1_MF4_MASK, VSOXSEG7EI32_V, 0x6, 0x0 }, // 8113
  { PseudoVSOXSEG7EI32_V_MF2_MF4, VSOXSEG7EI32_V, 0x6, 0x0 }, // 8114
  { PseudoVSOXSEG7EI32_V_MF2_MF4_MASK, VSOXSEG7EI32_V, 0x6, 0x0 }, // 8115
  { PseudoVSOXSEG7EI32_V_M1_MF2, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8116
  { PseudoVSOXSEG7EI32_V_M1_MF2_MASK, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8117
  { PseudoVSOXSEG7EI32_V_M2_MF2, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8118
  { PseudoVSOXSEG7EI32_V_M2_MF2_MASK, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8119
  { PseudoVSOXSEG7EI32_V_MF2_MF2, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8120
  { PseudoVSOXSEG7EI32_V_MF2_MF2_MASK, VSOXSEG7EI32_V, 0x7, 0x0 }, // 8121
  { PseudoVSOXSEG7EI64_V_M1_M1, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8122
  { PseudoVSOXSEG7EI64_V_M1_M1_MASK, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8123
  { PseudoVSOXSEG7EI64_V_M2_M1, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8124
  { PseudoVSOXSEG7EI64_V_M2_M1_MASK, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8125
  { PseudoVSOXSEG7EI64_V_M4_M1, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8126
  { PseudoVSOXSEG7EI64_V_M4_M1_MASK, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8127
  { PseudoVSOXSEG7EI64_V_M8_M1, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8128
  { PseudoVSOXSEG7EI64_V_M8_M1_MASK, VSOXSEG7EI64_V, 0x0, 0x0 }, // 8129
  { PseudoVSOXSEG7EI64_V_M1_MF8, VSOXSEG7EI64_V, 0x5, 0x0 }, // 8130
  { PseudoVSOXSEG7EI64_V_M1_MF8_MASK, VSOXSEG7EI64_V, 0x5, 0x0 }, // 8131
  { PseudoVSOXSEG7EI64_V_M1_MF4, VSOXSEG7EI64_V, 0x6, 0x0 }, // 8132
  { PseudoVSOXSEG7EI64_V_M1_MF4_MASK, VSOXSEG7EI64_V, 0x6, 0x0 }, // 8133
  { PseudoVSOXSEG7EI64_V_M2_MF4, VSOXSEG7EI64_V, 0x6, 0x0 }, // 8134
  { PseudoVSOXSEG7EI64_V_M2_MF4_MASK, VSOXSEG7EI64_V, 0x6, 0x0 }, // 8135
  { PseudoVSOXSEG7EI64_V_M1_MF2, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8136
  { PseudoVSOXSEG7EI64_V_M1_MF2_MASK, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8137
  { PseudoVSOXSEG7EI64_V_M2_MF2, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8138
  { PseudoVSOXSEG7EI64_V_M2_MF2_MASK, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8139
  { PseudoVSOXSEG7EI64_V_M4_MF2, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8140
  { PseudoVSOXSEG7EI64_V_M4_MF2_MASK, VSOXSEG7EI64_V, 0x7, 0x0 }, // 8141
  { PseudoVSOXSEG7EI8_V_M1_M1, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8142
  { PseudoVSOXSEG7EI8_V_M1_M1_MASK, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8143
  { PseudoVSOXSEG7EI8_V_MF2_M1, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8144
  { PseudoVSOXSEG7EI8_V_MF2_M1_MASK, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8145
  { PseudoVSOXSEG7EI8_V_MF4_M1, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8146
  { PseudoVSOXSEG7EI8_V_MF4_M1_MASK, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8147
  { PseudoVSOXSEG7EI8_V_MF8_M1, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8148
  { PseudoVSOXSEG7EI8_V_MF8_M1_MASK, VSOXSEG7EI8_V, 0x0, 0x0 }, // 8149
  { PseudoVSOXSEG7EI8_V_MF8_MF8, VSOXSEG7EI8_V, 0x5, 0x0 }, // 8150
  { PseudoVSOXSEG7EI8_V_MF8_MF8_MASK, VSOXSEG7EI8_V, 0x5, 0x0 }, // 8151
  { PseudoVSOXSEG7EI8_V_MF4_MF4, VSOXSEG7EI8_V, 0x6, 0x0 }, // 8152
  { PseudoVSOXSEG7EI8_V_MF4_MF4_MASK, VSOXSEG7EI8_V, 0x6, 0x0 }, // 8153
  { PseudoVSOXSEG7EI8_V_MF8_MF4, VSOXSEG7EI8_V, 0x6, 0x0 }, // 8154
  { PseudoVSOXSEG7EI8_V_MF8_MF4_MASK, VSOXSEG7EI8_V, 0x6, 0x0 }, // 8155
  { PseudoVSOXSEG7EI8_V_MF2_MF2, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8156
  { PseudoVSOXSEG7EI8_V_MF2_MF2_MASK, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8157
  { PseudoVSOXSEG7EI8_V_MF4_MF2, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8158
  { PseudoVSOXSEG7EI8_V_MF4_MF2_MASK, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8159
  { PseudoVSOXSEG7EI8_V_MF8_MF2, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8160
  { PseudoVSOXSEG7EI8_V_MF8_MF2_MASK, VSOXSEG7EI8_V, 0x7, 0x0 }, // 8161
  { PseudoVSOXSEG8EI16_V_M1_M1, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8162
  { PseudoVSOXSEG8EI16_V_M1_M1_MASK, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8163
  { PseudoVSOXSEG8EI16_V_M2_M1, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8164
  { PseudoVSOXSEG8EI16_V_M2_M1_MASK, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8165
  { PseudoVSOXSEG8EI16_V_MF2_M1, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8166
  { PseudoVSOXSEG8EI16_V_MF2_M1_MASK, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8167
  { PseudoVSOXSEG8EI16_V_MF4_M1, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8168
  { PseudoVSOXSEG8EI16_V_MF4_M1_MASK, VSOXSEG8EI16_V, 0x0, 0x0 }, // 8169
  { PseudoVSOXSEG8EI16_V_MF4_MF8, VSOXSEG8EI16_V, 0x5, 0x0 }, // 8170
  { PseudoVSOXSEG8EI16_V_MF4_MF8_MASK, VSOXSEG8EI16_V, 0x5, 0x0 }, // 8171
  { PseudoVSOXSEG8EI16_V_MF2_MF4, VSOXSEG8EI16_V, 0x6, 0x0 }, // 8172
  { PseudoVSOXSEG8EI16_V_MF2_MF4_MASK, VSOXSEG8EI16_V, 0x6, 0x0 }, // 8173
  { PseudoVSOXSEG8EI16_V_MF4_MF4, VSOXSEG8EI16_V, 0x6, 0x0 }, // 8174
  { PseudoVSOXSEG8EI16_V_MF4_MF4_MASK, VSOXSEG8EI16_V, 0x6, 0x0 }, // 8175
  { PseudoVSOXSEG8EI16_V_M1_MF2, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8176
  { PseudoVSOXSEG8EI16_V_M1_MF2_MASK, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8177
  { PseudoVSOXSEG8EI16_V_MF2_MF2, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8178
  { PseudoVSOXSEG8EI16_V_MF2_MF2_MASK, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8179
  { PseudoVSOXSEG8EI16_V_MF4_MF2, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8180
  { PseudoVSOXSEG8EI16_V_MF4_MF2_MASK, VSOXSEG8EI16_V, 0x7, 0x0 }, // 8181
  { PseudoVSOXSEG8EI32_V_M1_M1, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8182
  { PseudoVSOXSEG8EI32_V_M1_M1_MASK, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8183
  { PseudoVSOXSEG8EI32_V_M2_M1, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8184
  { PseudoVSOXSEG8EI32_V_M2_M1_MASK, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8185
  { PseudoVSOXSEG8EI32_V_M4_M1, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8186
  { PseudoVSOXSEG8EI32_V_M4_M1_MASK, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8187
  { PseudoVSOXSEG8EI32_V_MF2_M1, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8188
  { PseudoVSOXSEG8EI32_V_MF2_M1_MASK, VSOXSEG8EI32_V, 0x0, 0x0 }, // 8189
  { PseudoVSOXSEG8EI32_V_MF2_MF8, VSOXSEG8EI32_V, 0x5, 0x0 }, // 8190
  { PseudoVSOXSEG8EI32_V_MF2_MF8_MASK, VSOXSEG8EI32_V, 0x5, 0x0 }, // 8191
  { PseudoVSOXSEG8EI32_V_M1_MF4, VSOXSEG8EI32_V, 0x6, 0x0 }, // 8192
  { PseudoVSOXSEG8EI32_V_M1_MF4_MASK, VSOXSEG8EI32_V, 0x6, 0x0 }, // 8193
  { PseudoVSOXSEG8EI32_V_MF2_MF4, VSOXSEG8EI32_V, 0x6, 0x0 }, // 8194
  { PseudoVSOXSEG8EI32_V_MF2_MF4_MASK, VSOXSEG8EI32_V, 0x6, 0x0 }, // 8195
  { PseudoVSOXSEG8EI32_V_M1_MF2, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8196
  { PseudoVSOXSEG8EI32_V_M1_MF2_MASK, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8197
  { PseudoVSOXSEG8EI32_V_M2_MF2, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8198
  { PseudoVSOXSEG8EI32_V_M2_MF2_MASK, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8199
  { PseudoVSOXSEG8EI32_V_MF2_MF2, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8200
  { PseudoVSOXSEG8EI32_V_MF2_MF2_MASK, VSOXSEG8EI32_V, 0x7, 0x0 }, // 8201
  { PseudoVSOXSEG8EI64_V_M1_M1, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8202
  { PseudoVSOXSEG8EI64_V_M1_M1_MASK, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8203
  { PseudoVSOXSEG8EI64_V_M2_M1, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8204
  { PseudoVSOXSEG8EI64_V_M2_M1_MASK, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8205
  { PseudoVSOXSEG8EI64_V_M4_M1, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8206
  { PseudoVSOXSEG8EI64_V_M4_M1_MASK, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8207
  { PseudoVSOXSEG8EI64_V_M8_M1, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8208
  { PseudoVSOXSEG8EI64_V_M8_M1_MASK, VSOXSEG8EI64_V, 0x0, 0x0 }, // 8209
  { PseudoVSOXSEG8EI64_V_M1_MF8, VSOXSEG8EI64_V, 0x5, 0x0 }, // 8210
  { PseudoVSOXSEG8EI64_V_M1_MF8_MASK, VSOXSEG8EI64_V, 0x5, 0x0 }, // 8211
  { PseudoVSOXSEG8EI64_V_M1_MF4, VSOXSEG8EI64_V, 0x6, 0x0 }, // 8212
  { PseudoVSOXSEG8EI64_V_M1_MF4_MASK, VSOXSEG8EI64_V, 0x6, 0x0 }, // 8213
  { PseudoVSOXSEG8EI64_V_M2_MF4, VSOXSEG8EI64_V, 0x6, 0x0 }, // 8214
  { PseudoVSOXSEG8EI64_V_M2_MF4_MASK, VSOXSEG8EI64_V, 0x6, 0x0 }, // 8215
  { PseudoVSOXSEG8EI64_V_M1_MF2, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8216
  { PseudoVSOXSEG8EI64_V_M1_MF2_MASK, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8217
  { PseudoVSOXSEG8EI64_V_M2_MF2, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8218
  { PseudoVSOXSEG8EI64_V_M2_MF2_MASK, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8219
  { PseudoVSOXSEG8EI64_V_M4_MF2, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8220
  { PseudoVSOXSEG8EI64_V_M4_MF2_MASK, VSOXSEG8EI64_V, 0x7, 0x0 }, // 8221
  { PseudoVSOXSEG8EI8_V_M1_M1, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8222
  { PseudoVSOXSEG8EI8_V_M1_M1_MASK, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8223
  { PseudoVSOXSEG8EI8_V_MF2_M1, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8224
  { PseudoVSOXSEG8EI8_V_MF2_M1_MASK, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8225
  { PseudoVSOXSEG8EI8_V_MF4_M1, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8226
  { PseudoVSOXSEG8EI8_V_MF4_M1_MASK, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8227
  { PseudoVSOXSEG8EI8_V_MF8_M1, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8228
  { PseudoVSOXSEG8EI8_V_MF8_M1_MASK, VSOXSEG8EI8_V, 0x0, 0x0 }, // 8229
  { PseudoVSOXSEG8EI8_V_MF8_MF8, VSOXSEG8EI8_V, 0x5, 0x0 }, // 8230
  { PseudoVSOXSEG8EI8_V_MF8_MF8_MASK, VSOXSEG8EI8_V, 0x5, 0x0 }, // 8231
  { PseudoVSOXSEG8EI8_V_MF4_MF4, VSOXSEG8EI8_V, 0x6, 0x0 }, // 8232
  { PseudoVSOXSEG8EI8_V_MF4_MF4_MASK, VSOXSEG8EI8_V, 0x6, 0x0 }, // 8233
  { PseudoVSOXSEG8EI8_V_MF8_MF4, VSOXSEG8EI8_V, 0x6, 0x0 }, // 8234
  { PseudoVSOXSEG8EI8_V_MF8_MF4_MASK, VSOXSEG8EI8_V, 0x6, 0x0 }, // 8235
  { PseudoVSOXSEG8EI8_V_MF2_MF2, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8236
  { PseudoVSOXSEG8EI8_V_MF2_MF2_MASK, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8237
  { PseudoVSOXSEG8EI8_V_MF4_MF2, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8238
  { PseudoVSOXSEG8EI8_V_MF4_MF2_MASK, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8239
  { PseudoVSOXSEG8EI8_V_MF8_MF2, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8240
  { PseudoVSOXSEG8EI8_V_MF8_MF2_MASK, VSOXSEG8EI8_V, 0x7, 0x0 }, // 8241
  { PseudoVSRA_VI_M1, VSRA_VI, 0x0, 0x0 }, // 8242
  { PseudoVSRA_VI_M1_MASK, VSRA_VI, 0x0, 0x0 }, // 8243
  { PseudoVSRA_VI_M2, VSRA_VI, 0x1, 0x0 }, // 8244
  { PseudoVSRA_VI_M2_MASK, VSRA_VI, 0x1, 0x0 }, // 8245
  { PseudoVSRA_VI_M4, VSRA_VI, 0x2, 0x0 }, // 8246
  { PseudoVSRA_VI_M4_MASK, VSRA_VI, 0x2, 0x0 }, // 8247
  { PseudoVSRA_VI_M8, VSRA_VI, 0x3, 0x0 }, // 8248
  { PseudoVSRA_VI_M8_MASK, VSRA_VI, 0x3, 0x0 }, // 8249
  { PseudoVSRA_VI_MF8, VSRA_VI, 0x5, 0x0 }, // 8250
  { PseudoVSRA_VI_MF8_MASK, VSRA_VI, 0x5, 0x0 }, // 8251
  { PseudoVSRA_VI_MF4, VSRA_VI, 0x6, 0x0 }, // 8252
  { PseudoVSRA_VI_MF4_MASK, VSRA_VI, 0x6, 0x0 }, // 8253
  { PseudoVSRA_VI_MF2, VSRA_VI, 0x7, 0x0 }, // 8254
  { PseudoVSRA_VI_MF2_MASK, VSRA_VI, 0x7, 0x0 }, // 8255
  { PseudoVSRA_VV_M1, VSRA_VV, 0x0, 0x0 }, // 8256
  { PseudoVSRA_VV_M1_MASK, VSRA_VV, 0x0, 0x0 }, // 8257
  { PseudoVSRA_VV_M2, VSRA_VV, 0x1, 0x0 }, // 8258
  { PseudoVSRA_VV_M2_MASK, VSRA_VV, 0x1, 0x0 }, // 8259
  { PseudoVSRA_VV_M4, VSRA_VV, 0x2, 0x0 }, // 8260
  { PseudoVSRA_VV_M4_MASK, VSRA_VV, 0x2, 0x0 }, // 8261
  { PseudoVSRA_VV_M8, VSRA_VV, 0x3, 0x0 }, // 8262
  { PseudoVSRA_VV_M8_MASK, VSRA_VV, 0x3, 0x0 }, // 8263
  { PseudoVSRA_VV_MF8, VSRA_VV, 0x5, 0x0 }, // 8264
  { PseudoVSRA_VV_MF8_MASK, VSRA_VV, 0x5, 0x0 }, // 8265
  { PseudoVSRA_VV_MF4, VSRA_VV, 0x6, 0x0 }, // 8266
  { PseudoVSRA_VV_MF4_MASK, VSRA_VV, 0x6, 0x0 }, // 8267
  { PseudoVSRA_VV_MF2, VSRA_VV, 0x7, 0x0 }, // 8268
  { PseudoVSRA_VV_MF2_MASK, VSRA_VV, 0x7, 0x0 }, // 8269
  { PseudoVSRA_VX_M1, VSRA_VX, 0x0, 0x0 }, // 8270
  { PseudoVSRA_VX_M1_MASK, VSRA_VX, 0x0, 0x0 }, // 8271
  { PseudoVSRA_VX_M2, VSRA_VX, 0x1, 0x0 }, // 8272
  { PseudoVSRA_VX_M2_MASK, VSRA_VX, 0x1, 0x0 }, // 8273
  { PseudoVSRA_VX_M4, VSRA_VX, 0x2, 0x0 }, // 8274
  { PseudoVSRA_VX_M4_MASK, VSRA_VX, 0x2, 0x0 }, // 8275
  { PseudoVSRA_VX_M8, VSRA_VX, 0x3, 0x0 }, // 8276
  { PseudoVSRA_VX_M8_MASK, VSRA_VX, 0x3, 0x0 }, // 8277
  { PseudoVSRA_VX_MF8, VSRA_VX, 0x5, 0x0 }, // 8278
  { PseudoVSRA_VX_MF8_MASK, VSRA_VX, 0x5, 0x0 }, // 8279
  { PseudoVSRA_VX_MF4, VSRA_VX, 0x6, 0x0 }, // 8280
  { PseudoVSRA_VX_MF4_MASK, VSRA_VX, 0x6, 0x0 }, // 8281
  { PseudoVSRA_VX_MF2, VSRA_VX, 0x7, 0x0 }, // 8282
  { PseudoVSRA_VX_MF2_MASK, VSRA_VX, 0x7, 0x0 }, // 8283
  { PseudoVSRL_VI_M1, VSRL_VI, 0x0, 0x0 }, // 8284
  { PseudoVSRL_VI_M1_MASK, VSRL_VI, 0x0, 0x0 }, // 8285
  { PseudoVSRL_VI_M2, VSRL_VI, 0x1, 0x0 }, // 8286
  { PseudoVSRL_VI_M2_MASK, VSRL_VI, 0x1, 0x0 }, // 8287
  { PseudoVSRL_VI_M4, VSRL_VI, 0x2, 0x0 }, // 8288
  { PseudoVSRL_VI_M4_MASK, VSRL_VI, 0x2, 0x0 }, // 8289
  { PseudoVSRL_VI_M8, VSRL_VI, 0x3, 0x0 }, // 8290
  { PseudoVSRL_VI_M8_MASK, VSRL_VI, 0x3, 0x0 }, // 8291
  { PseudoVSRL_VI_MF8, VSRL_VI, 0x5, 0x0 }, // 8292
  { PseudoVSRL_VI_MF8_MASK, VSRL_VI, 0x5, 0x0 }, // 8293
  { PseudoVSRL_VI_MF4, VSRL_VI, 0x6, 0x0 }, // 8294
  { PseudoVSRL_VI_MF4_MASK, VSRL_VI, 0x6, 0x0 }, // 8295
  { PseudoVSRL_VI_MF2, VSRL_VI, 0x7, 0x0 }, // 8296
  { PseudoVSRL_VI_MF2_MASK, VSRL_VI, 0x7, 0x0 }, // 8297
  { PseudoVSRL_VV_M1, VSRL_VV, 0x0, 0x0 }, // 8298
  { PseudoVSRL_VV_M1_MASK, VSRL_VV, 0x0, 0x0 }, // 8299
  { PseudoVSRL_VV_M2, VSRL_VV, 0x1, 0x0 }, // 8300
  { PseudoVSRL_VV_M2_MASK, VSRL_VV, 0x1, 0x0 }, // 8301
  { PseudoVSRL_VV_M4, VSRL_VV, 0x2, 0x0 }, // 8302
  { PseudoVSRL_VV_M4_MASK, VSRL_VV, 0x2, 0x0 }, // 8303
  { PseudoVSRL_VV_M8, VSRL_VV, 0x3, 0x0 }, // 8304
  { PseudoVSRL_VV_M8_MASK, VSRL_VV, 0x3, 0x0 }, // 8305
  { PseudoVSRL_VV_MF8, VSRL_VV, 0x5, 0x0 }, // 8306
  { PseudoVSRL_VV_MF8_MASK, VSRL_VV, 0x5, 0x0 }, // 8307
  { PseudoVSRL_VV_MF4, VSRL_VV, 0x6, 0x0 }, // 8308
  { PseudoVSRL_VV_MF4_MASK, VSRL_VV, 0x6, 0x0 }, // 8309
  { PseudoVSRL_VV_MF2, VSRL_VV, 0x7, 0x0 }, // 8310
  { PseudoVSRL_VV_MF2_MASK, VSRL_VV, 0x7, 0x0 }, // 8311
  { PseudoVSRL_VX_M1, VSRL_VX, 0x0, 0x0 }, // 8312
  { PseudoVSRL_VX_M1_MASK, VSRL_VX, 0x0, 0x0 }, // 8313
  { PseudoVSRL_VX_M2, VSRL_VX, 0x1, 0x0 }, // 8314
  { PseudoVSRL_VX_M2_MASK, VSRL_VX, 0x1, 0x0 }, // 8315
  { PseudoVSRL_VX_M4, VSRL_VX, 0x2, 0x0 }, // 8316
  { PseudoVSRL_VX_M4_MASK, VSRL_VX, 0x2, 0x0 }, // 8317
  { PseudoVSRL_VX_M8, VSRL_VX, 0x3, 0x0 }, // 8318
  { PseudoVSRL_VX_M8_MASK, VSRL_VX, 0x3, 0x0 }, // 8319
  { PseudoVSRL_VX_MF8, VSRL_VX, 0x5, 0x0 }, // 8320
  { PseudoVSRL_VX_MF8_MASK, VSRL_VX, 0x5, 0x0 }, // 8321
  { PseudoVSRL_VX_MF4, VSRL_VX, 0x6, 0x0 }, // 8322
  { PseudoVSRL_VX_MF4_MASK, VSRL_VX, 0x6, 0x0 }, // 8323
  { PseudoVSRL_VX_MF2, VSRL_VX, 0x7, 0x0 }, // 8324
  { PseudoVSRL_VX_MF2_MASK, VSRL_VX, 0x7, 0x0 }, // 8325
  { PseudoVSSE16_V_M1, VSSE16_V, 0x0, 0x10 }, // 8326
  { PseudoVSSE16_V_M1_MASK, VSSE16_V, 0x0, 0x10 }, // 8327
  { PseudoVSSE16_V_M2, VSSE16_V, 0x1, 0x10 }, // 8328
  { PseudoVSSE16_V_M2_MASK, VSSE16_V, 0x1, 0x10 }, // 8329
  { PseudoVSSE16_V_M4, VSSE16_V, 0x2, 0x10 }, // 8330
  { PseudoVSSE16_V_M4_MASK, VSSE16_V, 0x2, 0x10 }, // 8331
  { PseudoVSSE16_V_M8, VSSE16_V, 0x3, 0x10 }, // 8332
  { PseudoVSSE16_V_M8_MASK, VSSE16_V, 0x3, 0x10 }, // 8333
  { PseudoVSSE16_V_MF4, VSSE16_V, 0x6, 0x10 }, // 8334
  { PseudoVSSE16_V_MF4_MASK, VSSE16_V, 0x6, 0x10 }, // 8335
  { PseudoVSSE16_V_MF2, VSSE16_V, 0x7, 0x10 }, // 8336
  { PseudoVSSE16_V_MF2_MASK, VSSE16_V, 0x7, 0x10 }, // 8337
  { PseudoVSSE32_V_M1, VSSE32_V, 0x0, 0x20 }, // 8338
  { PseudoVSSE32_V_M1_MASK, VSSE32_V, 0x0, 0x20 }, // 8339
  { PseudoVSSE32_V_M2, VSSE32_V, 0x1, 0x20 }, // 8340
  { PseudoVSSE32_V_M2_MASK, VSSE32_V, 0x1, 0x20 }, // 8341
  { PseudoVSSE32_V_M4, VSSE32_V, 0x2, 0x20 }, // 8342
  { PseudoVSSE32_V_M4_MASK, VSSE32_V, 0x2, 0x20 }, // 8343
  { PseudoVSSE32_V_M8, VSSE32_V, 0x3, 0x20 }, // 8344
  { PseudoVSSE32_V_M8_MASK, VSSE32_V, 0x3, 0x20 }, // 8345
  { PseudoVSSE32_V_MF2, VSSE32_V, 0x7, 0x20 }, // 8346
  { PseudoVSSE32_V_MF2_MASK, VSSE32_V, 0x7, 0x20 }, // 8347
  { PseudoVSSE64_V_M1, VSSE64_V, 0x0, 0x40 }, // 8348
  { PseudoVSSE64_V_M1_MASK, VSSE64_V, 0x0, 0x40 }, // 8349
  { PseudoVSSE64_V_M2, VSSE64_V, 0x1, 0x40 }, // 8350
  { PseudoVSSE64_V_M2_MASK, VSSE64_V, 0x1, 0x40 }, // 8351
  { PseudoVSSE64_V_M4, VSSE64_V, 0x2, 0x40 }, // 8352
  { PseudoVSSE64_V_M4_MASK, VSSE64_V, 0x2, 0x40 }, // 8353
  { PseudoVSSE64_V_M8, VSSE64_V, 0x3, 0x40 }, // 8354
  { PseudoVSSE64_V_M8_MASK, VSSE64_V, 0x3, 0x40 }, // 8355
  { PseudoVSSE8_V_M1, VSSE8_V, 0x0, 0x8 }, // 8356
  { PseudoVSSE8_V_M1_MASK, VSSE8_V, 0x0, 0x8 }, // 8357
  { PseudoVSSE8_V_M2, VSSE8_V, 0x1, 0x8 }, // 8358
  { PseudoVSSE8_V_M2_MASK, VSSE8_V, 0x1, 0x8 }, // 8359
  { PseudoVSSE8_V_M4, VSSE8_V, 0x2, 0x8 }, // 8360
  { PseudoVSSE8_V_M4_MASK, VSSE8_V, 0x2, 0x8 }, // 8361
  { PseudoVSSE8_V_M8, VSSE8_V, 0x3, 0x8 }, // 8362
  { PseudoVSSE8_V_M8_MASK, VSSE8_V, 0x3, 0x8 }, // 8363
  { PseudoVSSE8_V_MF8, VSSE8_V, 0x5, 0x8 }, // 8364
  { PseudoVSSE8_V_MF8_MASK, VSSE8_V, 0x5, 0x8 }, // 8365
  { PseudoVSSE8_V_MF4, VSSE8_V, 0x6, 0x8 }, // 8366
  { PseudoVSSE8_V_MF4_MASK, VSSE8_V, 0x6, 0x8 }, // 8367
  { PseudoVSSE8_V_MF2, VSSE8_V, 0x7, 0x8 }, // 8368
  { PseudoVSSE8_V_MF2_MASK, VSSE8_V, 0x7, 0x8 }, // 8369
  { PseudoVSSEG2E16_V_M1, VSSEG2E16_V, 0x0, 0x10 }, // 8370
  { PseudoVSSEG2E16_V_M1_MASK, VSSEG2E16_V, 0x0, 0x10 }, // 8371
  { PseudoVSSEG2E16_V_M2, VSSEG2E16_V, 0x1, 0x10 }, // 8372
  { PseudoVSSEG2E16_V_M2_MASK, VSSEG2E16_V, 0x1, 0x10 }, // 8373
  { PseudoVSSEG2E16_V_M4, VSSEG2E16_V, 0x2, 0x10 }, // 8374
  { PseudoVSSEG2E16_V_M4_MASK, VSSEG2E16_V, 0x2, 0x10 }, // 8375
  { PseudoVSSEG2E16_V_MF4, VSSEG2E16_V, 0x6, 0x10 }, // 8376
  { PseudoVSSEG2E16_V_MF4_MASK, VSSEG2E16_V, 0x6, 0x10 }, // 8377
  { PseudoVSSEG2E16_V_MF2, VSSEG2E16_V, 0x7, 0x10 }, // 8378
  { PseudoVSSEG2E16_V_MF2_MASK, VSSEG2E16_V, 0x7, 0x10 }, // 8379
  { PseudoVSSEG2E32_V_M1, VSSEG2E32_V, 0x0, 0x20 }, // 8380
  { PseudoVSSEG2E32_V_M1_MASK, VSSEG2E32_V, 0x0, 0x20 }, // 8381
  { PseudoVSSEG2E32_V_M2, VSSEG2E32_V, 0x1, 0x20 }, // 8382
  { PseudoVSSEG2E32_V_M2_MASK, VSSEG2E32_V, 0x1, 0x20 }, // 8383
  { PseudoVSSEG2E32_V_M4, VSSEG2E32_V, 0x2, 0x20 }, // 8384
  { PseudoVSSEG2E32_V_M4_MASK, VSSEG2E32_V, 0x2, 0x20 }, // 8385
  { PseudoVSSEG2E32_V_MF2, VSSEG2E32_V, 0x7, 0x20 }, // 8386
  { PseudoVSSEG2E32_V_MF2_MASK, VSSEG2E32_V, 0x7, 0x20 }, // 8387
  { PseudoVSSEG2E64_V_M1, VSSEG2E64_V, 0x0, 0x40 }, // 8388
  { PseudoVSSEG2E64_V_M1_MASK, VSSEG2E64_V, 0x0, 0x40 }, // 8389
  { PseudoVSSEG2E64_V_M2, VSSEG2E64_V, 0x1, 0x40 }, // 8390
  { PseudoVSSEG2E64_V_M2_MASK, VSSEG2E64_V, 0x1, 0x40 }, // 8391
  { PseudoVSSEG2E64_V_M4, VSSEG2E64_V, 0x2, 0x40 }, // 8392
  { PseudoVSSEG2E64_V_M4_MASK, VSSEG2E64_V, 0x2, 0x40 }, // 8393
  { PseudoVSSEG2E8_V_M1, VSSEG2E8_V, 0x0, 0x8 }, // 8394
  { PseudoVSSEG2E8_V_M1_MASK, VSSEG2E8_V, 0x0, 0x8 }, // 8395
  { PseudoVSSEG2E8_V_M2, VSSEG2E8_V, 0x1, 0x8 }, // 8396
  { PseudoVSSEG2E8_V_M2_MASK, VSSEG2E8_V, 0x1, 0x8 }, // 8397
  { PseudoVSSEG2E8_V_M4, VSSEG2E8_V, 0x2, 0x8 }, // 8398
  { PseudoVSSEG2E8_V_M4_MASK, VSSEG2E8_V, 0x2, 0x8 }, // 8399
  { PseudoVSSEG2E8_V_MF8, VSSEG2E8_V, 0x5, 0x8 }, // 8400
  { PseudoVSSEG2E8_V_MF8_MASK, VSSEG2E8_V, 0x5, 0x8 }, // 8401
  { PseudoVSSEG2E8_V_MF4, VSSEG2E8_V, 0x6, 0x8 }, // 8402
  { PseudoVSSEG2E8_V_MF4_MASK, VSSEG2E8_V, 0x6, 0x8 }, // 8403
  { PseudoVSSEG2E8_V_MF2, VSSEG2E8_V, 0x7, 0x8 }, // 8404
  { PseudoVSSEG2E8_V_MF2_MASK, VSSEG2E8_V, 0x7, 0x8 }, // 8405
  { PseudoVSSEG3E16_V_M1, VSSEG3E16_V, 0x0, 0x10 }, // 8406
  { PseudoVSSEG3E16_V_M1_MASK, VSSEG3E16_V, 0x0, 0x10 }, // 8407
  { PseudoVSSEG3E16_V_M2, VSSEG3E16_V, 0x1, 0x10 }, // 8408
  { PseudoVSSEG3E16_V_M2_MASK, VSSEG3E16_V, 0x1, 0x10 }, // 8409
  { PseudoVSSEG3E16_V_MF4, VSSEG3E16_V, 0x6, 0x10 }, // 8410
  { PseudoVSSEG3E16_V_MF4_MASK, VSSEG3E16_V, 0x6, 0x10 }, // 8411
  { PseudoVSSEG3E16_V_MF2, VSSEG3E16_V, 0x7, 0x10 }, // 8412
  { PseudoVSSEG3E16_V_MF2_MASK, VSSEG3E16_V, 0x7, 0x10 }, // 8413
  { PseudoVSSEG3E32_V_M1, VSSEG3E32_V, 0x0, 0x20 }, // 8414
  { PseudoVSSEG3E32_V_M1_MASK, VSSEG3E32_V, 0x0, 0x20 }, // 8415
  { PseudoVSSEG3E32_V_M2, VSSEG3E32_V, 0x1, 0x20 }, // 8416
  { PseudoVSSEG3E32_V_M2_MASK, VSSEG3E32_V, 0x1, 0x20 }, // 8417
  { PseudoVSSEG3E32_V_MF2, VSSEG3E32_V, 0x7, 0x20 }, // 8418
  { PseudoVSSEG3E32_V_MF2_MASK, VSSEG3E32_V, 0x7, 0x20 }, // 8419
  { PseudoVSSEG3E64_V_M1, VSSEG3E64_V, 0x0, 0x40 }, // 8420
  { PseudoVSSEG3E64_V_M1_MASK, VSSEG3E64_V, 0x0, 0x40 }, // 8421
  { PseudoVSSEG3E64_V_M2, VSSEG3E64_V, 0x1, 0x40 }, // 8422
  { PseudoVSSEG3E64_V_M2_MASK, VSSEG3E64_V, 0x1, 0x40 }, // 8423
  { PseudoVSSEG3E8_V_M1, VSSEG3E8_V, 0x0, 0x8 }, // 8424
  { PseudoVSSEG3E8_V_M1_MASK, VSSEG3E8_V, 0x0, 0x8 }, // 8425
  { PseudoVSSEG3E8_V_M2, VSSEG3E8_V, 0x1, 0x8 }, // 8426
  { PseudoVSSEG3E8_V_M2_MASK, VSSEG3E8_V, 0x1, 0x8 }, // 8427
  { PseudoVSSEG3E8_V_MF8, VSSEG3E8_V, 0x5, 0x8 }, // 8428
  { PseudoVSSEG3E8_V_MF8_MASK, VSSEG3E8_V, 0x5, 0x8 }, // 8429
  { PseudoVSSEG3E8_V_MF4, VSSEG3E8_V, 0x6, 0x8 }, // 8430
  { PseudoVSSEG3E8_V_MF4_MASK, VSSEG3E8_V, 0x6, 0x8 }, // 8431
  { PseudoVSSEG3E8_V_MF2, VSSEG3E8_V, 0x7, 0x8 }, // 8432
  { PseudoVSSEG3E8_V_MF2_MASK, VSSEG3E8_V, 0x7, 0x8 }, // 8433
  { PseudoVSSEG4E16_V_M1, VSSEG4E16_V, 0x0, 0x10 }, // 8434
  { PseudoVSSEG4E16_V_M1_MASK, VSSEG4E16_V, 0x0, 0x10 }, // 8435
  { PseudoVSSEG4E16_V_M2, VSSEG4E16_V, 0x1, 0x10 }, // 8436
  { PseudoVSSEG4E16_V_M2_MASK, VSSEG4E16_V, 0x1, 0x10 }, // 8437
  { PseudoVSSEG4E16_V_MF4, VSSEG4E16_V, 0x6, 0x10 }, // 8438
  { PseudoVSSEG4E16_V_MF4_MASK, VSSEG4E16_V, 0x6, 0x10 }, // 8439
  { PseudoVSSEG4E16_V_MF2, VSSEG4E16_V, 0x7, 0x10 }, // 8440
  { PseudoVSSEG4E16_V_MF2_MASK, VSSEG4E16_V, 0x7, 0x10 }, // 8441
  { PseudoVSSEG4E32_V_M1, VSSEG4E32_V, 0x0, 0x20 }, // 8442
  { PseudoVSSEG4E32_V_M1_MASK, VSSEG4E32_V, 0x0, 0x20 }, // 8443
  { PseudoVSSEG4E32_V_M2, VSSEG4E32_V, 0x1, 0x20 }, // 8444
  { PseudoVSSEG4E32_V_M2_MASK, VSSEG4E32_V, 0x1, 0x20 }, // 8445
  { PseudoVSSEG4E32_V_MF2, VSSEG4E32_V, 0x7, 0x20 }, // 8446
  { PseudoVSSEG4E32_V_MF2_MASK, VSSEG4E32_V, 0x7, 0x20 }, // 8447
  { PseudoVSSEG4E64_V_M1, VSSEG4E64_V, 0x0, 0x40 }, // 8448
  { PseudoVSSEG4E64_V_M1_MASK, VSSEG4E64_V, 0x0, 0x40 }, // 8449
  { PseudoVSSEG4E64_V_M2, VSSEG4E64_V, 0x1, 0x40 }, // 8450
  { PseudoVSSEG4E64_V_M2_MASK, VSSEG4E64_V, 0x1, 0x40 }, // 8451
  { PseudoVSSEG4E8_V_M1, VSSEG4E8_V, 0x0, 0x8 }, // 8452
  { PseudoVSSEG4E8_V_M1_MASK, VSSEG4E8_V, 0x0, 0x8 }, // 8453
  { PseudoVSSEG4E8_V_M2, VSSEG4E8_V, 0x1, 0x8 }, // 8454
  { PseudoVSSEG4E8_V_M2_MASK, VSSEG4E8_V, 0x1, 0x8 }, // 8455
  { PseudoVSSEG4E8_V_MF8, VSSEG4E8_V, 0x5, 0x8 }, // 8456
  { PseudoVSSEG4E8_V_MF8_MASK, VSSEG4E8_V, 0x5, 0x8 }, // 8457
  { PseudoVSSEG4E8_V_MF4, VSSEG4E8_V, 0x6, 0x8 }, // 8458
  { PseudoVSSEG4E8_V_MF4_MASK, VSSEG4E8_V, 0x6, 0x8 }, // 8459
  { PseudoVSSEG4E8_V_MF2, VSSEG4E8_V, 0x7, 0x8 }, // 8460
  { PseudoVSSEG4E8_V_MF2_MASK, VSSEG4E8_V, 0x7, 0x8 }, // 8461
  { PseudoVSSEG5E16_V_M1, VSSEG5E16_V, 0x0, 0x10 }, // 8462
  { PseudoVSSEG5E16_V_M1_MASK, VSSEG5E16_V, 0x0, 0x10 }, // 8463
  { PseudoVSSEG5E16_V_MF4, VSSEG5E16_V, 0x6, 0x10 }, // 8464
  { PseudoVSSEG5E16_V_MF4_MASK, VSSEG5E16_V, 0x6, 0x10 }, // 8465
  { PseudoVSSEG5E16_V_MF2, VSSEG5E16_V, 0x7, 0x10 }, // 8466
  { PseudoVSSEG5E16_V_MF2_MASK, VSSEG5E16_V, 0x7, 0x10 }, // 8467
  { PseudoVSSEG5E32_V_M1, VSSEG5E32_V, 0x0, 0x20 }, // 8468
  { PseudoVSSEG5E32_V_M1_MASK, VSSEG5E32_V, 0x0, 0x20 }, // 8469
  { PseudoVSSEG5E32_V_MF2, VSSEG5E32_V, 0x7, 0x20 }, // 8470
  { PseudoVSSEG5E32_V_MF2_MASK, VSSEG5E32_V, 0x7, 0x20 }, // 8471
  { PseudoVSSEG5E64_V_M1, VSSEG5E64_V, 0x0, 0x40 }, // 8472
  { PseudoVSSEG5E64_V_M1_MASK, VSSEG5E64_V, 0x0, 0x40 }, // 8473
  { PseudoVSSEG5E8_V_M1, VSSEG5E8_V, 0x0, 0x8 }, // 8474
  { PseudoVSSEG5E8_V_M1_MASK, VSSEG5E8_V, 0x0, 0x8 }, // 8475
  { PseudoVSSEG5E8_V_MF8, VSSEG5E8_V, 0x5, 0x8 }, // 8476
  { PseudoVSSEG5E8_V_MF8_MASK, VSSEG5E8_V, 0x5, 0x8 }, // 8477
  { PseudoVSSEG5E8_V_MF4, VSSEG5E8_V, 0x6, 0x8 }, // 8478
  { PseudoVSSEG5E8_V_MF4_MASK, VSSEG5E8_V, 0x6, 0x8 }, // 8479
  { PseudoVSSEG5E8_V_MF2, VSSEG5E8_V, 0x7, 0x8 }, // 8480
  { PseudoVSSEG5E8_V_MF2_MASK, VSSEG5E8_V, 0x7, 0x8 }, // 8481
  { PseudoVSSEG6E16_V_M1, VSSEG6E16_V, 0x0, 0x10 }, // 8482
  { PseudoVSSEG6E16_V_M1_MASK, VSSEG6E16_V, 0x0, 0x10 }, // 8483
  { PseudoVSSEG6E16_V_MF4, VSSEG6E16_V, 0x6, 0x10 }, // 8484
  { PseudoVSSEG6E16_V_MF4_MASK, VSSEG6E16_V, 0x6, 0x10 }, // 8485
  { PseudoVSSEG6E16_V_MF2, VSSEG6E16_V, 0x7, 0x10 }, // 8486
  { PseudoVSSEG6E16_V_MF2_MASK, VSSEG6E16_V, 0x7, 0x10 }, // 8487
  { PseudoVSSEG6E32_V_M1, VSSEG6E32_V, 0x0, 0x20 }, // 8488
  { PseudoVSSEG6E32_V_M1_MASK, VSSEG6E32_V, 0x0, 0x20 }, // 8489
  { PseudoVSSEG6E32_V_MF2, VSSEG6E32_V, 0x7, 0x20 }, // 8490
  { PseudoVSSEG6E32_V_MF2_MASK, VSSEG6E32_V, 0x7, 0x20 }, // 8491
  { PseudoVSSEG6E64_V_M1, VSSEG6E64_V, 0x0, 0x40 }, // 8492
  { PseudoVSSEG6E64_V_M1_MASK, VSSEG6E64_V, 0x0, 0x40 }, // 8493
  { PseudoVSSEG6E8_V_M1, VSSEG6E8_V, 0x0, 0x8 }, // 8494
  { PseudoVSSEG6E8_V_M1_MASK, VSSEG6E8_V, 0x0, 0x8 }, // 8495
  { PseudoVSSEG6E8_V_MF8, VSSEG6E8_V, 0x5, 0x8 }, // 8496
  { PseudoVSSEG6E8_V_MF8_MASK, VSSEG6E8_V, 0x5, 0x8 }, // 8497
  { PseudoVSSEG6E8_V_MF4, VSSEG6E8_V, 0x6, 0x8 }, // 8498
  { PseudoVSSEG6E8_V_MF4_MASK, VSSEG6E8_V, 0x6, 0x8 }, // 8499
  { PseudoVSSEG6E8_V_MF2, VSSEG6E8_V, 0x7, 0x8 }, // 8500
  { PseudoVSSEG6E8_V_MF2_MASK, VSSEG6E8_V, 0x7, 0x8 }, // 8501
  { PseudoVSSEG7E16_V_M1, VSSEG7E16_V, 0x0, 0x10 }, // 8502
  { PseudoVSSEG7E16_V_M1_MASK, VSSEG7E16_V, 0x0, 0x10 }, // 8503
  { PseudoVSSEG7E16_V_MF4, VSSEG7E16_V, 0x6, 0x10 }, // 8504
  { PseudoVSSEG7E16_V_MF4_MASK, VSSEG7E16_V, 0x6, 0x10 }, // 8505
  { PseudoVSSEG7E16_V_MF2, VSSEG7E16_V, 0x7, 0x10 }, // 8506
  { PseudoVSSEG7E16_V_MF2_MASK, VSSEG7E16_V, 0x7, 0x10 }, // 8507
  { PseudoVSSEG7E32_V_M1, VSSEG7E32_V, 0x0, 0x20 }, // 8508
  { PseudoVSSEG7E32_V_M1_MASK, VSSEG7E32_V, 0x0, 0x20 }, // 8509
  { PseudoVSSEG7E32_V_MF2, VSSEG7E32_V, 0x7, 0x20 }, // 8510
  { PseudoVSSEG7E32_V_MF2_MASK, VSSEG7E32_V, 0x7, 0x20 }, // 8511
  { PseudoVSSEG7E64_V_M1, VSSEG7E64_V, 0x0, 0x40 }, // 8512
  { PseudoVSSEG7E64_V_M1_MASK, VSSEG7E64_V, 0x0, 0x40 }, // 8513
  { PseudoVSSEG7E8_V_M1, VSSEG7E8_V, 0x0, 0x8 }, // 8514
  { PseudoVSSEG7E8_V_M1_MASK, VSSEG7E8_V, 0x0, 0x8 }, // 8515
  { PseudoVSSEG7E8_V_MF8, VSSEG7E8_V, 0x5, 0x8 }, // 8516
  { PseudoVSSEG7E8_V_MF8_MASK, VSSEG7E8_V, 0x5, 0x8 }, // 8517
  { PseudoVSSEG7E8_V_MF4, VSSEG7E8_V, 0x6, 0x8 }, // 8518
  { PseudoVSSEG7E8_V_MF4_MASK, VSSEG7E8_V, 0x6, 0x8 }, // 8519
  { PseudoVSSEG7E8_V_MF2, VSSEG7E8_V, 0x7, 0x8 }, // 8520
  { PseudoVSSEG7E8_V_MF2_MASK, VSSEG7E8_V, 0x7, 0x8 }, // 8521
  { PseudoVSSEG8E16_V_M1, VSSEG8E16_V, 0x0, 0x10 }, // 8522
  { PseudoVSSEG8E16_V_M1_MASK, VSSEG8E16_V, 0x0, 0x10 }, // 8523
  { PseudoVSSEG8E16_V_MF4, VSSEG8E16_V, 0x6, 0x10 }, // 8524
  { PseudoVSSEG8E16_V_MF4_MASK, VSSEG8E16_V, 0x6, 0x10 }, // 8525
  { PseudoVSSEG8E16_V_MF2, VSSEG8E16_V, 0x7, 0x10 }, // 8526
  { PseudoVSSEG8E16_V_MF2_MASK, VSSEG8E16_V, 0x7, 0x10 }, // 8527
  { PseudoVSSEG8E32_V_M1, VSSEG8E32_V, 0x0, 0x20 }, // 8528
  { PseudoVSSEG8E32_V_M1_MASK, VSSEG8E32_V, 0x0, 0x20 }, // 8529
  { PseudoVSSEG8E32_V_MF2, VSSEG8E32_V, 0x7, 0x20 }, // 8530
  { PseudoVSSEG8E32_V_MF2_MASK, VSSEG8E32_V, 0x7, 0x20 }, // 8531
  { PseudoVSSEG8E64_V_M1, VSSEG8E64_V, 0x0, 0x40 }, // 8532
  { PseudoVSSEG8E64_V_M1_MASK, VSSEG8E64_V, 0x0, 0x40 }, // 8533
  { PseudoVSSEG8E8_V_M1, VSSEG8E8_V, 0x0, 0x8 }, // 8534
  { PseudoVSSEG8E8_V_M1_MASK, VSSEG8E8_V, 0x0, 0x8 }, // 8535
  { PseudoVSSEG8E8_V_MF8, VSSEG8E8_V, 0x5, 0x8 }, // 8536
  { PseudoVSSEG8E8_V_MF8_MASK, VSSEG8E8_V, 0x5, 0x8 }, // 8537
  { PseudoVSSEG8E8_V_MF4, VSSEG8E8_V, 0x6, 0x8 }, // 8538
  { PseudoVSSEG8E8_V_MF4_MASK, VSSEG8E8_V, 0x6, 0x8 }, // 8539
  { PseudoVSSEG8E8_V_MF2, VSSEG8E8_V, 0x7, 0x8 }, // 8540
  { PseudoVSSEG8E8_V_MF2_MASK, VSSEG8E8_V, 0x7, 0x8 }, // 8541
  { PseudoVSSRA_VI_M1, VSSRA_VI, 0x0, 0x0 }, // 8542
  { PseudoVSSRA_VI_M1_MASK, VSSRA_VI, 0x0, 0x0 }, // 8543
  { PseudoVSSRA_VI_M2, VSSRA_VI, 0x1, 0x0 }, // 8544
  { PseudoVSSRA_VI_M2_MASK, VSSRA_VI, 0x1, 0x0 }, // 8545
  { PseudoVSSRA_VI_M4, VSSRA_VI, 0x2, 0x0 }, // 8546
  { PseudoVSSRA_VI_M4_MASK, VSSRA_VI, 0x2, 0x0 }, // 8547
  { PseudoVSSRA_VI_M8, VSSRA_VI, 0x3, 0x0 }, // 8548
  { PseudoVSSRA_VI_M8_MASK, VSSRA_VI, 0x3, 0x0 }, // 8549
  { PseudoVSSRA_VI_MF8, VSSRA_VI, 0x5, 0x0 }, // 8550
  { PseudoVSSRA_VI_MF8_MASK, VSSRA_VI, 0x5, 0x0 }, // 8551
  { PseudoVSSRA_VI_MF4, VSSRA_VI, 0x6, 0x0 }, // 8552
  { PseudoVSSRA_VI_MF4_MASK, VSSRA_VI, 0x6, 0x0 }, // 8553
  { PseudoVSSRA_VI_MF2, VSSRA_VI, 0x7, 0x0 }, // 8554
  { PseudoVSSRA_VI_MF2_MASK, VSSRA_VI, 0x7, 0x0 }, // 8555
  { PseudoVSSRA_VV_M1, VSSRA_VV, 0x0, 0x0 }, // 8556
  { PseudoVSSRA_VV_M1_MASK, VSSRA_VV, 0x0, 0x0 }, // 8557
  { PseudoVSSRA_VV_M2, VSSRA_VV, 0x1, 0x0 }, // 8558
  { PseudoVSSRA_VV_M2_MASK, VSSRA_VV, 0x1, 0x0 }, // 8559
  { PseudoVSSRA_VV_M4, VSSRA_VV, 0x2, 0x0 }, // 8560
  { PseudoVSSRA_VV_M4_MASK, VSSRA_VV, 0x2, 0x0 }, // 8561
  { PseudoVSSRA_VV_M8, VSSRA_VV, 0x3, 0x0 }, // 8562
  { PseudoVSSRA_VV_M8_MASK, VSSRA_VV, 0x3, 0x0 }, // 8563
  { PseudoVSSRA_VV_MF8, VSSRA_VV, 0x5, 0x0 }, // 8564
  { PseudoVSSRA_VV_MF8_MASK, VSSRA_VV, 0x5, 0x0 }, // 8565
  { PseudoVSSRA_VV_MF4, VSSRA_VV, 0x6, 0x0 }, // 8566
  { PseudoVSSRA_VV_MF4_MASK, VSSRA_VV, 0x6, 0x0 }, // 8567
  { PseudoVSSRA_VV_MF2, VSSRA_VV, 0x7, 0x0 }, // 8568
  { PseudoVSSRA_VV_MF2_MASK, VSSRA_VV, 0x7, 0x0 }, // 8569
  { PseudoVSSRA_VX_M1, VSSRA_VX, 0x0, 0x0 }, // 8570
  { PseudoVSSRA_VX_M1_MASK, VSSRA_VX, 0x0, 0x0 }, // 8571
  { PseudoVSSRA_VX_M2, VSSRA_VX, 0x1, 0x0 }, // 8572
  { PseudoVSSRA_VX_M2_MASK, VSSRA_VX, 0x1, 0x0 }, // 8573
  { PseudoVSSRA_VX_M4, VSSRA_VX, 0x2, 0x0 }, // 8574
  { PseudoVSSRA_VX_M4_MASK, VSSRA_VX, 0x2, 0x0 }, // 8575
  { PseudoVSSRA_VX_M8, VSSRA_VX, 0x3, 0x0 }, // 8576
  { PseudoVSSRA_VX_M8_MASK, VSSRA_VX, 0x3, 0x0 }, // 8577
  { PseudoVSSRA_VX_MF8, VSSRA_VX, 0x5, 0x0 }, // 8578
  { PseudoVSSRA_VX_MF8_MASK, VSSRA_VX, 0x5, 0x0 }, // 8579
  { PseudoVSSRA_VX_MF4, VSSRA_VX, 0x6, 0x0 }, // 8580
  { PseudoVSSRA_VX_MF4_MASK, VSSRA_VX, 0x6, 0x0 }, // 8581
  { PseudoVSSRA_VX_MF2, VSSRA_VX, 0x7, 0x0 }, // 8582
  { PseudoVSSRA_VX_MF2_MASK, VSSRA_VX, 0x7, 0x0 }, // 8583
  { PseudoVSSRL_VI_M1, VSSRL_VI, 0x0, 0x0 }, // 8584
  { PseudoVSSRL_VI_M1_MASK, VSSRL_VI, 0x0, 0x0 }, // 8585
  { PseudoVSSRL_VI_M2, VSSRL_VI, 0x1, 0x0 }, // 8586
  { PseudoVSSRL_VI_M2_MASK, VSSRL_VI, 0x1, 0x0 }, // 8587
  { PseudoVSSRL_VI_M4, VSSRL_VI, 0x2, 0x0 }, // 8588
  { PseudoVSSRL_VI_M4_MASK, VSSRL_VI, 0x2, 0x0 }, // 8589
  { PseudoVSSRL_VI_M8, VSSRL_VI, 0x3, 0x0 }, // 8590
  { PseudoVSSRL_VI_M8_MASK, VSSRL_VI, 0x3, 0x0 }, // 8591
  { PseudoVSSRL_VI_MF8, VSSRL_VI, 0x5, 0x0 }, // 8592
  { PseudoVSSRL_VI_MF8_MASK, VSSRL_VI, 0x5, 0x0 }, // 8593
  { PseudoVSSRL_VI_MF4, VSSRL_VI, 0x6, 0x0 }, // 8594
  { PseudoVSSRL_VI_MF4_MASK, VSSRL_VI, 0x6, 0x0 }, // 8595
  { PseudoVSSRL_VI_MF2, VSSRL_VI, 0x7, 0x0 }, // 8596
  { PseudoVSSRL_VI_MF2_MASK, VSSRL_VI, 0x7, 0x0 }, // 8597
  { PseudoVSSRL_VV_M1, VSSRL_VV, 0x0, 0x0 }, // 8598
  { PseudoVSSRL_VV_M1_MASK, VSSRL_VV, 0x0, 0x0 }, // 8599
  { PseudoVSSRL_VV_M2, VSSRL_VV, 0x1, 0x0 }, // 8600
  { PseudoVSSRL_VV_M2_MASK, VSSRL_VV, 0x1, 0x0 }, // 8601
  { PseudoVSSRL_VV_M4, VSSRL_VV, 0x2, 0x0 }, // 8602
  { PseudoVSSRL_VV_M4_MASK, VSSRL_VV, 0x2, 0x0 }, // 8603
  { PseudoVSSRL_VV_M8, VSSRL_VV, 0x3, 0x0 }, // 8604
  { PseudoVSSRL_VV_M8_MASK, VSSRL_VV, 0x3, 0x0 }, // 8605
  { PseudoVSSRL_VV_MF8, VSSRL_VV, 0x5, 0x0 }, // 8606
  { PseudoVSSRL_VV_MF8_MASK, VSSRL_VV, 0x5, 0x0 }, // 8607
  { PseudoVSSRL_VV_MF4, VSSRL_VV, 0x6, 0x0 }, // 8608
  { PseudoVSSRL_VV_MF4_MASK, VSSRL_VV, 0x6, 0x0 }, // 8609
  { PseudoVSSRL_VV_MF2, VSSRL_VV, 0x7, 0x0 }, // 8610
  { PseudoVSSRL_VV_MF2_MASK, VSSRL_VV, 0x7, 0x0 }, // 8611
  { PseudoVSSRL_VX_M1, VSSRL_VX, 0x0, 0x0 }, // 8612
  { PseudoVSSRL_VX_M1_MASK, VSSRL_VX, 0x0, 0x0 }, // 8613
  { PseudoVSSRL_VX_M2, VSSRL_VX, 0x1, 0x0 }, // 8614
  { PseudoVSSRL_VX_M2_MASK, VSSRL_VX, 0x1, 0x0 }, // 8615
  { PseudoVSSRL_VX_M4, VSSRL_VX, 0x2, 0x0 }, // 8616
  { PseudoVSSRL_VX_M4_MASK, VSSRL_VX, 0x2, 0x0 }, // 8617
  { PseudoVSSRL_VX_M8, VSSRL_VX, 0x3, 0x0 }, // 8618
  { PseudoVSSRL_VX_M8_MASK, VSSRL_VX, 0x3, 0x0 }, // 8619
  { PseudoVSSRL_VX_MF8, VSSRL_VX, 0x5, 0x0 }, // 8620
  { PseudoVSSRL_VX_MF8_MASK, VSSRL_VX, 0x5, 0x0 }, // 8621
  { PseudoVSSRL_VX_MF4, VSSRL_VX, 0x6, 0x0 }, // 8622
  { PseudoVSSRL_VX_MF4_MASK, VSSRL_VX, 0x6, 0x0 }, // 8623
  { PseudoVSSRL_VX_MF2, VSSRL_VX, 0x7, 0x0 }, // 8624
  { PseudoVSSRL_VX_MF2_MASK, VSSRL_VX, 0x7, 0x0 }, // 8625
  { PseudoVSSSEG2E16_V_M1, VSSSEG2E16_V, 0x0, 0x10 }, // 8626
  { PseudoVSSSEG2E16_V_M1_MASK, VSSSEG2E16_V, 0x0, 0x10 }, // 8627
  { PseudoVSSSEG2E16_V_M2, VSSSEG2E16_V, 0x1, 0x10 }, // 8628
  { PseudoVSSSEG2E16_V_M2_MASK, VSSSEG2E16_V, 0x1, 0x10 }, // 8629
  { PseudoVSSSEG2E16_V_M4, VSSSEG2E16_V, 0x2, 0x10 }, // 8630
  { PseudoVSSSEG2E16_V_M4_MASK, VSSSEG2E16_V, 0x2, 0x10 }, // 8631
  { PseudoVSSSEG2E16_V_MF4, VSSSEG2E16_V, 0x6, 0x10 }, // 8632
  { PseudoVSSSEG2E16_V_MF4_MASK, VSSSEG2E16_V, 0x6, 0x10 }, // 8633
  { PseudoVSSSEG2E16_V_MF2, VSSSEG2E16_V, 0x7, 0x10 }, // 8634
  { PseudoVSSSEG2E16_V_MF2_MASK, VSSSEG2E16_V, 0x7, 0x10 }, // 8635
  { PseudoVSSSEG2E32_V_M1, VSSSEG2E32_V, 0x0, 0x20 }, // 8636
  { PseudoVSSSEG2E32_V_M1_MASK, VSSSEG2E32_V, 0x0, 0x20 }, // 8637
  { PseudoVSSSEG2E32_V_M2, VSSSEG2E32_V, 0x1, 0x20 }, // 8638
  { PseudoVSSSEG2E32_V_M2_MASK, VSSSEG2E32_V, 0x1, 0x20 }, // 8639
  { PseudoVSSSEG2E32_V_M4, VSSSEG2E32_V, 0x2, 0x20 }, // 8640
  { PseudoVSSSEG2E32_V_M4_MASK, VSSSEG2E32_V, 0x2, 0x20 }, // 8641
  { PseudoVSSSEG2E32_V_MF2, VSSSEG2E32_V, 0x7, 0x20 }, // 8642
  { PseudoVSSSEG2E32_V_MF2_MASK, VSSSEG2E32_V, 0x7, 0x20 }, // 8643
  { PseudoVSSSEG2E64_V_M1, VSSSEG2E64_V, 0x0, 0x40 }, // 8644
  { PseudoVSSSEG2E64_V_M1_MASK, VSSSEG2E64_V, 0x0, 0x40 }, // 8645
  { PseudoVSSSEG2E64_V_M2, VSSSEG2E64_V, 0x1, 0x40 }, // 8646
  { PseudoVSSSEG2E64_V_M2_MASK, VSSSEG2E64_V, 0x1, 0x40 }, // 8647
  { PseudoVSSSEG2E64_V_M4, VSSSEG2E64_V, 0x2, 0x40 }, // 8648
  { PseudoVSSSEG2E64_V_M4_MASK, VSSSEG2E64_V, 0x2, 0x40 }, // 8649
  { PseudoVSSSEG2E8_V_M1, VSSSEG2E8_V, 0x0, 0x8 }, // 8650
  { PseudoVSSSEG2E8_V_M1_MASK, VSSSEG2E8_V, 0x0, 0x8 }, // 8651
  { PseudoVSSSEG2E8_V_M2, VSSSEG2E8_V, 0x1, 0x8 }, // 8652
  { PseudoVSSSEG2E8_V_M2_MASK, VSSSEG2E8_V, 0x1, 0x8 }, // 8653
  { PseudoVSSSEG2E8_V_M4, VSSSEG2E8_V, 0x2, 0x8 }, // 8654
  { PseudoVSSSEG2E8_V_M4_MASK, VSSSEG2E8_V, 0x2, 0x8 }, // 8655
  { PseudoVSSSEG2E8_V_MF8, VSSSEG2E8_V, 0x5, 0x8 }, // 8656
  { PseudoVSSSEG2E8_V_MF8_MASK, VSSSEG2E8_V, 0x5, 0x8 }, // 8657
  { PseudoVSSSEG2E8_V_MF4, VSSSEG2E8_V, 0x6, 0x8 }, // 8658
  { PseudoVSSSEG2E8_V_MF4_MASK, VSSSEG2E8_V, 0x6, 0x8 }, // 8659
  { PseudoVSSSEG2E8_V_MF2, VSSSEG2E8_V, 0x7, 0x8 }, // 8660
  { PseudoVSSSEG2E8_V_MF2_MASK, VSSSEG2E8_V, 0x7, 0x8 }, // 8661
  { PseudoVSSSEG3E16_V_M1, VSSSEG3E16_V, 0x0, 0x10 }, // 8662
  { PseudoVSSSEG3E16_V_M1_MASK, VSSSEG3E16_V, 0x0, 0x10 }, // 8663
  { PseudoVSSSEG3E16_V_M2, VSSSEG3E16_V, 0x1, 0x10 }, // 8664
  { PseudoVSSSEG3E16_V_M2_MASK, VSSSEG3E16_V, 0x1, 0x10 }, // 8665
  { PseudoVSSSEG3E16_V_MF4, VSSSEG3E16_V, 0x6, 0x10 }, // 8666
  { PseudoVSSSEG3E16_V_MF4_MASK, VSSSEG3E16_V, 0x6, 0x10 }, // 8667
  { PseudoVSSSEG3E16_V_MF2, VSSSEG3E16_V, 0x7, 0x10 }, // 8668
  { PseudoVSSSEG3E16_V_MF2_MASK, VSSSEG3E16_V, 0x7, 0x10 }, // 8669
  { PseudoVSSSEG3E32_V_M1, VSSSEG3E32_V, 0x0, 0x20 }, // 8670
  { PseudoVSSSEG3E32_V_M1_MASK, VSSSEG3E32_V, 0x0, 0x20 }, // 8671
  { PseudoVSSSEG3E32_V_M2, VSSSEG3E32_V, 0x1, 0x20 }, // 8672
  { PseudoVSSSEG3E32_V_M2_MASK, VSSSEG3E32_V, 0x1, 0x20 }, // 8673
  { PseudoVSSSEG3E32_V_MF2, VSSSEG3E32_V, 0x7, 0x20 }, // 8674
  { PseudoVSSSEG3E32_V_MF2_MASK, VSSSEG3E32_V, 0x7, 0x20 }, // 8675
  { PseudoVSSSEG3E64_V_M1, VSSSEG3E64_V, 0x0, 0x40 }, // 8676
  { PseudoVSSSEG3E64_V_M1_MASK, VSSSEG3E64_V, 0x0, 0x40 }, // 8677
  { PseudoVSSSEG3E64_V_M2, VSSSEG3E64_V, 0x1, 0x40 }, // 8678
  { PseudoVSSSEG3E64_V_M2_MASK, VSSSEG3E64_V, 0x1, 0x40 }, // 8679
  { PseudoVSSSEG3E8_V_M1, VSSSEG3E8_V, 0x0, 0x8 }, // 8680
  { PseudoVSSSEG3E8_V_M1_MASK, VSSSEG3E8_V, 0x0, 0x8 }, // 8681
  { PseudoVSSSEG3E8_V_M2, VSSSEG3E8_V, 0x1, 0x8 }, // 8682
  { PseudoVSSSEG3E8_V_M2_MASK, VSSSEG3E8_V, 0x1, 0x8 }, // 8683
  { PseudoVSSSEG3E8_V_MF8, VSSSEG3E8_V, 0x5, 0x8 }, // 8684
  { PseudoVSSSEG3E8_V_MF8_MASK, VSSSEG3E8_V, 0x5, 0x8 }, // 8685
  { PseudoVSSSEG3E8_V_MF4, VSSSEG3E8_V, 0x6, 0x8 }, // 8686
  { PseudoVSSSEG3E8_V_MF4_MASK, VSSSEG3E8_V, 0x6, 0x8 }, // 8687
  { PseudoVSSSEG3E8_V_MF2, VSSSEG3E8_V, 0x7, 0x8 }, // 8688
  { PseudoVSSSEG3E8_V_MF2_MASK, VSSSEG3E8_V, 0x7, 0x8 }, // 8689
  { PseudoVSSSEG4E16_V_M1, VSSSEG4E16_V, 0x0, 0x10 }, // 8690
  { PseudoVSSSEG4E16_V_M1_MASK, VSSSEG4E16_V, 0x0, 0x10 }, // 8691
  { PseudoVSSSEG4E16_V_M2, VSSSEG4E16_V, 0x1, 0x10 }, // 8692
  { PseudoVSSSEG4E16_V_M2_MASK, VSSSEG4E16_V, 0x1, 0x10 }, // 8693
  { PseudoVSSSEG4E16_V_MF4, VSSSEG4E16_V, 0x6, 0x10 }, // 8694
  { PseudoVSSSEG4E16_V_MF4_MASK, VSSSEG4E16_V, 0x6, 0x10 }, // 8695
  { PseudoVSSSEG4E16_V_MF2, VSSSEG4E16_V, 0x7, 0x10 }, // 8696
  { PseudoVSSSEG4E16_V_MF2_MASK, VSSSEG4E16_V, 0x7, 0x10 }, // 8697
  { PseudoVSSSEG4E32_V_M1, VSSSEG4E32_V, 0x0, 0x20 }, // 8698
  { PseudoVSSSEG4E32_V_M1_MASK, VSSSEG4E32_V, 0x0, 0x20 }, // 8699
  { PseudoVSSSEG4E32_V_M2, VSSSEG4E32_V, 0x1, 0x20 }, // 8700
  { PseudoVSSSEG4E32_V_M2_MASK, VSSSEG4E32_V, 0x1, 0x20 }, // 8701
  { PseudoVSSSEG4E32_V_MF2, VSSSEG4E32_V, 0x7, 0x20 }, // 8702
  { PseudoVSSSEG4E32_V_MF2_MASK, VSSSEG4E32_V, 0x7, 0x20 }, // 8703
  { PseudoVSSSEG4E64_V_M1, VSSSEG4E64_V, 0x0, 0x40 }, // 8704
  { PseudoVSSSEG4E64_V_M1_MASK, VSSSEG4E64_V, 0x0, 0x40 }, // 8705
  { PseudoVSSSEG4E64_V_M2, VSSSEG4E64_V, 0x1, 0x40 }, // 8706
  { PseudoVSSSEG4E64_V_M2_MASK, VSSSEG4E64_V, 0x1, 0x40 }, // 8707
  { PseudoVSSSEG4E8_V_M1, VSSSEG4E8_V, 0x0, 0x8 }, // 8708
  { PseudoVSSSEG4E8_V_M1_MASK, VSSSEG4E8_V, 0x0, 0x8 }, // 8709
  { PseudoVSSSEG4E8_V_M2, VSSSEG4E8_V, 0x1, 0x8 }, // 8710
  { PseudoVSSSEG4E8_V_M2_MASK, VSSSEG4E8_V, 0x1, 0x8 }, // 8711
  { PseudoVSSSEG4E8_V_MF8, VSSSEG4E8_V, 0x5, 0x8 }, // 8712
  { PseudoVSSSEG4E8_V_MF8_MASK, VSSSEG4E8_V, 0x5, 0x8 }, // 8713
  { PseudoVSSSEG4E8_V_MF4, VSSSEG4E8_V, 0x6, 0x8 }, // 8714
  { PseudoVSSSEG4E8_V_MF4_MASK, VSSSEG4E8_V, 0x6, 0x8 }, // 8715
  { PseudoVSSSEG4E8_V_MF2, VSSSEG4E8_V, 0x7, 0x8 }, // 8716
  { PseudoVSSSEG4E8_V_MF2_MASK, VSSSEG4E8_V, 0x7, 0x8 }, // 8717
  { PseudoVSSSEG5E16_V_M1, VSSSEG5E16_V, 0x0, 0x10 }, // 8718
  { PseudoVSSSEG5E16_V_M1_MASK, VSSSEG5E16_V, 0x0, 0x10 }, // 8719
  { PseudoVSSSEG5E16_V_MF4, VSSSEG5E16_V, 0x6, 0x10 }, // 8720
  { PseudoVSSSEG5E16_V_MF4_MASK, VSSSEG5E16_V, 0x6, 0x10 }, // 8721
  { PseudoVSSSEG5E16_V_MF2, VSSSEG5E16_V, 0x7, 0x10 }, // 8722
  { PseudoVSSSEG5E16_V_MF2_MASK, VSSSEG5E16_V, 0x7, 0x10 }, // 8723
  { PseudoVSSSEG5E32_V_M1, VSSSEG5E32_V, 0x0, 0x20 }, // 8724
  { PseudoVSSSEG5E32_V_M1_MASK, VSSSEG5E32_V, 0x0, 0x20 }, // 8725
  { PseudoVSSSEG5E32_V_MF2, VSSSEG5E32_V, 0x7, 0x20 }, // 8726
  { PseudoVSSSEG5E32_V_MF2_MASK, VSSSEG5E32_V, 0x7, 0x20 }, // 8727
  { PseudoVSSSEG5E64_V_M1, VSSSEG5E64_V, 0x0, 0x40 }, // 8728
  { PseudoVSSSEG5E64_V_M1_MASK, VSSSEG5E64_V, 0x0, 0x40 }, // 8729
  { PseudoVSSSEG5E8_V_M1, VSSSEG5E8_V, 0x0, 0x8 }, // 8730
  { PseudoVSSSEG5E8_V_M1_MASK, VSSSEG5E8_V, 0x0, 0x8 }, // 8731
  { PseudoVSSSEG5E8_V_MF8, VSSSEG5E8_V, 0x5, 0x8 }, // 8732
  { PseudoVSSSEG5E8_V_MF8_MASK, VSSSEG5E8_V, 0x5, 0x8 }, // 8733
  { PseudoVSSSEG5E8_V_MF4, VSSSEG5E8_V, 0x6, 0x8 }, // 8734
  { PseudoVSSSEG5E8_V_MF4_MASK, VSSSEG5E8_V, 0x6, 0x8 }, // 8735
  { PseudoVSSSEG5E8_V_MF2, VSSSEG5E8_V, 0x7, 0x8 }, // 8736
  { PseudoVSSSEG5E8_V_MF2_MASK, VSSSEG5E8_V, 0x7, 0x8 }, // 8737
  { PseudoVSSSEG6E16_V_M1, VSSSEG6E16_V, 0x0, 0x10 }, // 8738
  { PseudoVSSSEG6E16_V_M1_MASK, VSSSEG6E16_V, 0x0, 0x10 }, // 8739
  { PseudoVSSSEG6E16_V_MF4, VSSSEG6E16_V, 0x6, 0x10 }, // 8740
  { PseudoVSSSEG6E16_V_MF4_MASK, VSSSEG6E16_V, 0x6, 0x10 }, // 8741
  { PseudoVSSSEG6E16_V_MF2, VSSSEG6E16_V, 0x7, 0x10 }, // 8742
  { PseudoVSSSEG6E16_V_MF2_MASK, VSSSEG6E16_V, 0x7, 0x10 }, // 8743
  { PseudoVSSSEG6E32_V_M1, VSSSEG6E32_V, 0x0, 0x20 }, // 8744
  { PseudoVSSSEG6E32_V_M1_MASK, VSSSEG6E32_V, 0x0, 0x20 }, // 8745
  { PseudoVSSSEG6E32_V_MF2, VSSSEG6E32_V, 0x7, 0x20 }, // 8746
  { PseudoVSSSEG6E32_V_MF2_MASK, VSSSEG6E32_V, 0x7, 0x20 }, // 8747
  { PseudoVSSSEG6E64_V_M1, VSSSEG6E64_V, 0x0, 0x40 }, // 8748
  { PseudoVSSSEG6E64_V_M1_MASK, VSSSEG6E64_V, 0x0, 0x40 }, // 8749
  { PseudoVSSSEG6E8_V_M1, VSSSEG6E8_V, 0x0, 0x8 }, // 8750
  { PseudoVSSSEG6E8_V_M1_MASK, VSSSEG6E8_V, 0x0, 0x8 }, // 8751
  { PseudoVSSSEG6E8_V_MF8, VSSSEG6E8_V, 0x5, 0x8 }, // 8752
  { PseudoVSSSEG6E8_V_MF8_MASK, VSSSEG6E8_V, 0x5, 0x8 }, // 8753
  { PseudoVSSSEG6E8_V_MF4, VSSSEG6E8_V, 0x6, 0x8 }, // 8754
  { PseudoVSSSEG6E8_V_MF4_MASK, VSSSEG6E8_V, 0x6, 0x8 }, // 8755
  { PseudoVSSSEG6E8_V_MF2, VSSSEG6E8_V, 0x7, 0x8 }, // 8756
  { PseudoVSSSEG6E8_V_MF2_MASK, VSSSEG6E8_V, 0x7, 0x8 }, // 8757
  { PseudoVSSSEG7E16_V_M1, VSSSEG7E16_V, 0x0, 0x10 }, // 8758
  { PseudoVSSSEG7E16_V_M1_MASK, VSSSEG7E16_V, 0x0, 0x10 }, // 8759
  { PseudoVSSSEG7E16_V_MF4, VSSSEG7E16_V, 0x6, 0x10 }, // 8760
  { PseudoVSSSEG7E16_V_MF4_MASK, VSSSEG7E16_V, 0x6, 0x10 }, // 8761
  { PseudoVSSSEG7E16_V_MF2, VSSSEG7E16_V, 0x7, 0x10 }, // 8762
  { PseudoVSSSEG7E16_V_MF2_MASK, VSSSEG7E16_V, 0x7, 0x10 }, // 8763
  { PseudoVSSSEG7E32_V_M1, VSSSEG7E32_V, 0x0, 0x20 }, // 8764
  { PseudoVSSSEG7E32_V_M1_MASK, VSSSEG7E32_V, 0x0, 0x20 }, // 8765
  { PseudoVSSSEG7E32_V_MF2, VSSSEG7E32_V, 0x7, 0x20 }, // 8766
  { PseudoVSSSEG7E32_V_MF2_MASK, VSSSEG7E32_V, 0x7, 0x20 }, // 8767
  { PseudoVSSSEG7E64_V_M1, VSSSEG7E64_V, 0x0, 0x40 }, // 8768
  { PseudoVSSSEG7E64_V_M1_MASK, VSSSEG7E64_V, 0x0, 0x40 }, // 8769
  { PseudoVSSSEG7E8_V_M1, VSSSEG7E8_V, 0x0, 0x8 }, // 8770
  { PseudoVSSSEG7E8_V_M1_MASK, VSSSEG7E8_V, 0x0, 0x8 }, // 8771
  { PseudoVSSSEG7E8_V_MF8, VSSSEG7E8_V, 0x5, 0x8 }, // 8772
  { PseudoVSSSEG7E8_V_MF8_MASK, VSSSEG7E8_V, 0x5, 0x8 }, // 8773
  { PseudoVSSSEG7E8_V_MF4, VSSSEG7E8_V, 0x6, 0x8 }, // 8774
  { PseudoVSSSEG7E8_V_MF4_MASK, VSSSEG7E8_V, 0x6, 0x8 }, // 8775
  { PseudoVSSSEG7E8_V_MF2, VSSSEG7E8_V, 0x7, 0x8 }, // 8776
  { PseudoVSSSEG7E8_V_MF2_MASK, VSSSEG7E8_V, 0x7, 0x8 }, // 8777
  { PseudoVSSSEG8E16_V_M1, VSSSEG8E16_V, 0x0, 0x10 }, // 8778
  { PseudoVSSSEG8E16_V_M1_MASK, VSSSEG8E16_V, 0x0, 0x10 }, // 8779
  { PseudoVSSSEG8E16_V_MF4, VSSSEG8E16_V, 0x6, 0x10 }, // 8780
  { PseudoVSSSEG8E16_V_MF4_MASK, VSSSEG8E16_V, 0x6, 0x10 }, // 8781
  { PseudoVSSSEG8E16_V_MF2, VSSSEG8E16_V, 0x7, 0x10 }, // 8782
  { PseudoVSSSEG8E16_V_MF2_MASK, VSSSEG8E16_V, 0x7, 0x10 }, // 8783
  { PseudoVSSSEG8E32_V_M1, VSSSEG8E32_V, 0x0, 0x20 }, // 8784
  { PseudoVSSSEG8E32_V_M1_MASK, VSSSEG8E32_V, 0x0, 0x20 }, // 8785
  { PseudoVSSSEG8E32_V_MF2, VSSSEG8E32_V, 0x7, 0x20 }, // 8786
  { PseudoVSSSEG8E32_V_MF2_MASK, VSSSEG8E32_V, 0x7, 0x20 }, // 8787
  { PseudoVSSSEG8E64_V_M1, VSSSEG8E64_V, 0x0, 0x40 }, // 8788
  { PseudoVSSSEG8E64_V_M1_MASK, VSSSEG8E64_V, 0x0, 0x40 }, // 8789
  { PseudoVSSSEG8E8_V_M1, VSSSEG8E8_V, 0x0, 0x8 }, // 8790
  { PseudoVSSSEG8E8_V_M1_MASK, VSSSEG8E8_V, 0x0, 0x8 }, // 8791
  { PseudoVSSSEG8E8_V_MF8, VSSSEG8E8_V, 0x5, 0x8 }, // 8792
  { PseudoVSSSEG8E8_V_MF8_MASK, VSSSEG8E8_V, 0x5, 0x8 }, // 8793
  { PseudoVSSSEG8E8_V_MF4, VSSSEG8E8_V, 0x6, 0x8 }, // 8794
  { PseudoVSSSEG8E8_V_MF4_MASK, VSSSEG8E8_V, 0x6, 0x8 }, // 8795
  { PseudoVSSSEG8E8_V_MF2, VSSSEG8E8_V, 0x7, 0x8 }, // 8796
  { PseudoVSSSEG8E8_V_MF2_MASK, VSSSEG8E8_V, 0x7, 0x8 }, // 8797
  { PseudoVSSUBU_VV_M1, VSSUBU_VV, 0x0, 0x0 }, // 8798
  { PseudoVSSUBU_VV_M1_MASK, VSSUBU_VV, 0x0, 0x0 }, // 8799
  { PseudoVSSUBU_VV_M2, VSSUBU_VV, 0x1, 0x0 }, // 8800
  { PseudoVSSUBU_VV_M2_MASK, VSSUBU_VV, 0x1, 0x0 }, // 8801
  { PseudoVSSUBU_VV_M4, VSSUBU_VV, 0x2, 0x0 }, // 8802
  { PseudoVSSUBU_VV_M4_MASK, VSSUBU_VV, 0x2, 0x0 }, // 8803
  { PseudoVSSUBU_VV_M8, VSSUBU_VV, 0x3, 0x0 }, // 8804
  { PseudoVSSUBU_VV_M8_MASK, VSSUBU_VV, 0x3, 0x0 }, // 8805
  { PseudoVSSUBU_VV_MF8, VSSUBU_VV, 0x5, 0x0 }, // 8806
  { PseudoVSSUBU_VV_MF8_MASK, VSSUBU_VV, 0x5, 0x0 }, // 8807
  { PseudoVSSUBU_VV_MF4, VSSUBU_VV, 0x6, 0x0 }, // 8808
  { PseudoVSSUBU_VV_MF4_MASK, VSSUBU_VV, 0x6, 0x0 }, // 8809
  { PseudoVSSUBU_VV_MF2, VSSUBU_VV, 0x7, 0x0 }, // 8810
  { PseudoVSSUBU_VV_MF2_MASK, VSSUBU_VV, 0x7, 0x0 }, // 8811
  { PseudoVSSUBU_VX_M1, VSSUBU_VX, 0x0, 0x0 }, // 8812
  { PseudoVSSUBU_VX_M1_MASK, VSSUBU_VX, 0x0, 0x0 }, // 8813
  { PseudoVSSUBU_VX_M2, VSSUBU_VX, 0x1, 0x0 }, // 8814
  { PseudoVSSUBU_VX_M2_MASK, VSSUBU_VX, 0x1, 0x0 }, // 8815
  { PseudoVSSUBU_VX_M4, VSSUBU_VX, 0x2, 0x0 }, // 8816
  { PseudoVSSUBU_VX_M4_MASK, VSSUBU_VX, 0x2, 0x0 }, // 8817
  { PseudoVSSUBU_VX_M8, VSSUBU_VX, 0x3, 0x0 }, // 8818
  { PseudoVSSUBU_VX_M8_MASK, VSSUBU_VX, 0x3, 0x0 }, // 8819
  { PseudoVSSUBU_VX_MF8, VSSUBU_VX, 0x5, 0x0 }, // 8820
  { PseudoVSSUBU_VX_MF8_MASK, VSSUBU_VX, 0x5, 0x0 }, // 8821
  { PseudoVSSUBU_VX_MF4, VSSUBU_VX, 0x6, 0x0 }, // 8822
  { PseudoVSSUBU_VX_MF4_MASK, VSSUBU_VX, 0x6, 0x0 }, // 8823
  { PseudoVSSUBU_VX_MF2, VSSUBU_VX, 0x7, 0x0 }, // 8824
  { PseudoVSSUBU_VX_MF2_MASK, VSSUBU_VX, 0x7, 0x0 }, // 8825
  { PseudoVSSUB_VV_M1, VSSUB_VV, 0x0, 0x0 }, // 8826
  { PseudoVSSUB_VV_M1_MASK, VSSUB_VV, 0x0, 0x0 }, // 8827
  { PseudoVSSUB_VV_M2, VSSUB_VV, 0x1, 0x0 }, // 8828
  { PseudoVSSUB_VV_M2_MASK, VSSUB_VV, 0x1, 0x0 }, // 8829
  { PseudoVSSUB_VV_M4, VSSUB_VV, 0x2, 0x0 }, // 8830
  { PseudoVSSUB_VV_M4_MASK, VSSUB_VV, 0x2, 0x0 }, // 8831
  { PseudoVSSUB_VV_M8, VSSUB_VV, 0x3, 0x0 }, // 8832
  { PseudoVSSUB_VV_M8_MASK, VSSUB_VV, 0x3, 0x0 }, // 8833
  { PseudoVSSUB_VV_MF8, VSSUB_VV, 0x5, 0x0 }, // 8834
  { PseudoVSSUB_VV_MF8_MASK, VSSUB_VV, 0x5, 0x0 }, // 8835
  { PseudoVSSUB_VV_MF4, VSSUB_VV, 0x6, 0x0 }, // 8836
  { PseudoVSSUB_VV_MF4_MASK, VSSUB_VV, 0x6, 0x0 }, // 8837
  { PseudoVSSUB_VV_MF2, VSSUB_VV, 0x7, 0x0 }, // 8838
  { PseudoVSSUB_VV_MF2_MASK, VSSUB_VV, 0x7, 0x0 }, // 8839
  { PseudoVSSUB_VX_M1, VSSUB_VX, 0x0, 0x0 }, // 8840
  { PseudoVSSUB_VX_M1_MASK, VSSUB_VX, 0x0, 0x0 }, // 8841
  { PseudoVSSUB_VX_M2, VSSUB_VX, 0x1, 0x0 }, // 8842
  { PseudoVSSUB_VX_M2_MASK, VSSUB_VX, 0x1, 0x0 }, // 8843
  { PseudoVSSUB_VX_M4, VSSUB_VX, 0x2, 0x0 }, // 8844
  { PseudoVSSUB_VX_M4_MASK, VSSUB_VX, 0x2, 0x0 }, // 8845
  { PseudoVSSUB_VX_M8, VSSUB_VX, 0x3, 0x0 }, // 8846
  { PseudoVSSUB_VX_M8_MASK, VSSUB_VX, 0x3, 0x0 }, // 8847
  { PseudoVSSUB_VX_MF8, VSSUB_VX, 0x5, 0x0 }, // 8848
  { PseudoVSSUB_VX_MF8_MASK, VSSUB_VX, 0x5, 0x0 }, // 8849
  { PseudoVSSUB_VX_MF4, VSSUB_VX, 0x6, 0x0 }, // 8850
  { PseudoVSSUB_VX_MF4_MASK, VSSUB_VX, 0x6, 0x0 }, // 8851
  { PseudoVSSUB_VX_MF2, VSSUB_VX, 0x7, 0x0 }, // 8852
  { PseudoVSSUB_VX_MF2_MASK, VSSUB_VX, 0x7, 0x0 }, // 8853
  { PseudoVSUB_VV_M1, VSUB_VV, 0x0, 0x0 }, // 8854
  { PseudoVSUB_VV_M1_MASK, VSUB_VV, 0x0, 0x0 }, // 8855
  { PseudoVSUB_VV_M2, VSUB_VV, 0x1, 0x0 }, // 8856
  { PseudoVSUB_VV_M2_MASK, VSUB_VV, 0x1, 0x0 }, // 8857
  { PseudoVSUB_VV_M4, VSUB_VV, 0x2, 0x0 }, // 8858
  { PseudoVSUB_VV_M4_MASK, VSUB_VV, 0x2, 0x0 }, // 8859
  { PseudoVSUB_VV_M8, VSUB_VV, 0x3, 0x0 }, // 8860
  { PseudoVSUB_VV_M8_MASK, VSUB_VV, 0x3, 0x0 }, // 8861
  { PseudoVSUB_VV_MF8, VSUB_VV, 0x5, 0x0 }, // 8862
  { PseudoVSUB_VV_MF8_MASK, VSUB_VV, 0x5, 0x0 }, // 8863
  { PseudoVSUB_VV_MF4, VSUB_VV, 0x6, 0x0 }, // 8864
  { PseudoVSUB_VV_MF4_MASK, VSUB_VV, 0x6, 0x0 }, // 8865
  { PseudoVSUB_VV_MF2, VSUB_VV, 0x7, 0x0 }, // 8866
  { PseudoVSUB_VV_MF2_MASK, VSUB_VV, 0x7, 0x0 }, // 8867
  { PseudoVSUB_VX_M1, VSUB_VX, 0x0, 0x0 }, // 8868
  { PseudoVSUB_VX_M1_MASK, VSUB_VX, 0x0, 0x0 }, // 8869
  { PseudoVSUB_VX_M2, VSUB_VX, 0x1, 0x0 }, // 8870
  { PseudoVSUB_VX_M2_MASK, VSUB_VX, 0x1, 0x0 }, // 8871
  { PseudoVSUB_VX_M4, VSUB_VX, 0x2, 0x0 }, // 8872
  { PseudoVSUB_VX_M4_MASK, VSUB_VX, 0x2, 0x0 }, // 8873
  { PseudoVSUB_VX_M8, VSUB_VX, 0x3, 0x0 }, // 8874
  { PseudoVSUB_VX_M8_MASK, VSUB_VX, 0x3, 0x0 }, // 8875
  { PseudoVSUB_VX_MF8, VSUB_VX, 0x5, 0x0 }, // 8876
  { PseudoVSUB_VX_MF8_MASK, VSUB_VX, 0x5, 0x0 }, // 8877
  { PseudoVSUB_VX_MF4, VSUB_VX, 0x6, 0x0 }, // 8878
  { PseudoVSUB_VX_MF4_MASK, VSUB_VX, 0x6, 0x0 }, // 8879
  { PseudoVSUB_VX_MF2, VSUB_VX, 0x7, 0x0 }, // 8880
  { PseudoVSUB_VX_MF2_MASK, VSUB_VX, 0x7, 0x0 }, // 8881
  { PseudoVSUXEI16_V_M1_M1, VSUXEI16_V, 0x0, 0x0 }, // 8882
  { PseudoVSUXEI16_V_M1_M1_MASK, VSUXEI16_V, 0x0, 0x0 }, // 8883
  { PseudoVSUXEI16_V_M2_M1, VSUXEI16_V, 0x0, 0x0 }, // 8884
  { PseudoVSUXEI16_V_M2_M1_MASK, VSUXEI16_V, 0x0, 0x0 }, // 8885
  { PseudoVSUXEI16_V_MF2_M1, VSUXEI16_V, 0x0, 0x0 }, // 8886
  { PseudoVSUXEI16_V_MF2_M1_MASK, VSUXEI16_V, 0x0, 0x0 }, // 8887
  { PseudoVSUXEI16_V_MF4_M1, VSUXEI16_V, 0x0, 0x0 }, // 8888
  { PseudoVSUXEI16_V_MF4_M1_MASK, VSUXEI16_V, 0x0, 0x0 }, // 8889
  { PseudoVSUXEI16_V_M1_M2, VSUXEI16_V, 0x1, 0x0 }, // 8890
  { PseudoVSUXEI16_V_M1_M2_MASK, VSUXEI16_V, 0x1, 0x0 }, // 8891
  { PseudoVSUXEI16_V_M2_M2, VSUXEI16_V, 0x1, 0x0 }, // 8892
  { PseudoVSUXEI16_V_M2_M2_MASK, VSUXEI16_V, 0x1, 0x0 }, // 8893
  { PseudoVSUXEI16_V_M4_M2, VSUXEI16_V, 0x1, 0x0 }, // 8894
  { PseudoVSUXEI16_V_M4_M2_MASK, VSUXEI16_V, 0x1, 0x0 }, // 8895
  { PseudoVSUXEI16_V_MF2_M2, VSUXEI16_V, 0x1, 0x0 }, // 8896
  { PseudoVSUXEI16_V_MF2_M2_MASK, VSUXEI16_V, 0x1, 0x0 }, // 8897
  { PseudoVSUXEI16_V_M1_M4, VSUXEI16_V, 0x2, 0x0 }, // 8898
  { PseudoVSUXEI16_V_M1_M4_MASK, VSUXEI16_V, 0x2, 0x0 }, // 8899
  { PseudoVSUXEI16_V_M2_M4, VSUXEI16_V, 0x2, 0x0 }, // 8900
  { PseudoVSUXEI16_V_M2_M4_MASK, VSUXEI16_V, 0x2, 0x0 }, // 8901
  { PseudoVSUXEI16_V_M4_M4, VSUXEI16_V, 0x2, 0x0 }, // 8902
  { PseudoVSUXEI16_V_M4_M4_MASK, VSUXEI16_V, 0x2, 0x0 }, // 8903
  { PseudoVSUXEI16_V_M8_M4, VSUXEI16_V, 0x2, 0x0 }, // 8904
  { PseudoVSUXEI16_V_M8_M4_MASK, VSUXEI16_V, 0x2, 0x0 }, // 8905
  { PseudoVSUXEI16_V_M2_M8, VSUXEI16_V, 0x3, 0x0 }, // 8906
  { PseudoVSUXEI16_V_M2_M8_MASK, VSUXEI16_V, 0x3, 0x0 }, // 8907
  { PseudoVSUXEI16_V_M4_M8, VSUXEI16_V, 0x3, 0x0 }, // 8908
  { PseudoVSUXEI16_V_M4_M8_MASK, VSUXEI16_V, 0x3, 0x0 }, // 8909
  { PseudoVSUXEI16_V_M8_M8, VSUXEI16_V, 0x3, 0x0 }, // 8910
  { PseudoVSUXEI16_V_M8_M8_MASK, VSUXEI16_V, 0x3, 0x0 }, // 8911
  { PseudoVSUXEI16_V_MF4_MF8, VSUXEI16_V, 0x5, 0x0 }, // 8912
  { PseudoVSUXEI16_V_MF4_MF8_MASK, VSUXEI16_V, 0x5, 0x0 }, // 8913
  { PseudoVSUXEI16_V_MF2_MF4, VSUXEI16_V, 0x6, 0x0 }, // 8914
  { PseudoVSUXEI16_V_MF2_MF4_MASK, VSUXEI16_V, 0x6, 0x0 }, // 8915
  { PseudoVSUXEI16_V_MF4_MF4, VSUXEI16_V, 0x6, 0x0 }, // 8916
  { PseudoVSUXEI16_V_MF4_MF4_MASK, VSUXEI16_V, 0x6, 0x0 }, // 8917
  { PseudoVSUXEI16_V_M1_MF2, VSUXEI16_V, 0x7, 0x0 }, // 8918
  { PseudoVSUXEI16_V_M1_MF2_MASK, VSUXEI16_V, 0x7, 0x0 }, // 8919
  { PseudoVSUXEI16_V_MF2_MF2, VSUXEI16_V, 0x7, 0x0 }, // 8920
  { PseudoVSUXEI16_V_MF2_MF2_MASK, VSUXEI16_V, 0x7, 0x0 }, // 8921
  { PseudoVSUXEI16_V_MF4_MF2, VSUXEI16_V, 0x7, 0x0 }, // 8922
  { PseudoVSUXEI16_V_MF4_MF2_MASK, VSUXEI16_V, 0x7, 0x0 }, // 8923
  { PseudoVSUXEI32_V_M1_M1, VSUXEI32_V, 0x0, 0x0 }, // 8924
  { PseudoVSUXEI32_V_M1_M1_MASK, VSUXEI32_V, 0x0, 0x0 }, // 8925
  { PseudoVSUXEI32_V_M2_M1, VSUXEI32_V, 0x0, 0x0 }, // 8926
  { PseudoVSUXEI32_V_M2_M1_MASK, VSUXEI32_V, 0x0, 0x0 }, // 8927
  { PseudoVSUXEI32_V_M4_M1, VSUXEI32_V, 0x0, 0x0 }, // 8928
  { PseudoVSUXEI32_V_M4_M1_MASK, VSUXEI32_V, 0x0, 0x0 }, // 8929
  { PseudoVSUXEI32_V_MF2_M1, VSUXEI32_V, 0x0, 0x0 }, // 8930
  { PseudoVSUXEI32_V_MF2_M1_MASK, VSUXEI32_V, 0x0, 0x0 }, // 8931
  { PseudoVSUXEI32_V_M1_M2, VSUXEI32_V, 0x1, 0x0 }, // 8932
  { PseudoVSUXEI32_V_M1_M2_MASK, VSUXEI32_V, 0x1, 0x0 }, // 8933
  { PseudoVSUXEI32_V_M2_M2, VSUXEI32_V, 0x1, 0x0 }, // 8934
  { PseudoVSUXEI32_V_M2_M2_MASK, VSUXEI32_V, 0x1, 0x0 }, // 8935
  { PseudoVSUXEI32_V_M4_M2, VSUXEI32_V, 0x1, 0x0 }, // 8936
  { PseudoVSUXEI32_V_M4_M2_MASK, VSUXEI32_V, 0x1, 0x0 }, // 8937
  { PseudoVSUXEI32_V_M8_M2, VSUXEI32_V, 0x1, 0x0 }, // 8938
  { PseudoVSUXEI32_V_M8_M2_MASK, VSUXEI32_V, 0x1, 0x0 }, // 8939
  { PseudoVSUXEI32_V_M2_M4, VSUXEI32_V, 0x2, 0x0 }, // 8940
  { PseudoVSUXEI32_V_M2_M4_MASK, VSUXEI32_V, 0x2, 0x0 }, // 8941
  { PseudoVSUXEI32_V_M4_M4, VSUXEI32_V, 0x2, 0x0 }, // 8942
  { PseudoVSUXEI32_V_M4_M4_MASK, VSUXEI32_V, 0x2, 0x0 }, // 8943
  { PseudoVSUXEI32_V_M8_M4, VSUXEI32_V, 0x2, 0x0 }, // 8944
  { PseudoVSUXEI32_V_M8_M4_MASK, VSUXEI32_V, 0x2, 0x0 }, // 8945
  { PseudoVSUXEI32_V_M4_M8, VSUXEI32_V, 0x3, 0x0 }, // 8946
  { PseudoVSUXEI32_V_M4_M8_MASK, VSUXEI32_V, 0x3, 0x0 }, // 8947
  { PseudoVSUXEI32_V_M8_M8, VSUXEI32_V, 0x3, 0x0 }, // 8948
  { PseudoVSUXEI32_V_M8_M8_MASK, VSUXEI32_V, 0x3, 0x0 }, // 8949
  { PseudoVSUXEI32_V_MF2_MF8, VSUXEI32_V, 0x5, 0x0 }, // 8950
  { PseudoVSUXEI32_V_MF2_MF8_MASK, VSUXEI32_V, 0x5, 0x0 }, // 8951
  { PseudoVSUXEI32_V_M1_MF4, VSUXEI32_V, 0x6, 0x0 }, // 8952
  { PseudoVSUXEI32_V_M1_MF4_MASK, VSUXEI32_V, 0x6, 0x0 }, // 8953
  { PseudoVSUXEI32_V_MF2_MF4, VSUXEI32_V, 0x6, 0x0 }, // 8954
  { PseudoVSUXEI32_V_MF2_MF4_MASK, VSUXEI32_V, 0x6, 0x0 }, // 8955
  { PseudoVSUXEI32_V_M1_MF2, VSUXEI32_V, 0x7, 0x0 }, // 8956
  { PseudoVSUXEI32_V_M1_MF2_MASK, VSUXEI32_V, 0x7, 0x0 }, // 8957
  { PseudoVSUXEI32_V_M2_MF2, VSUXEI32_V, 0x7, 0x0 }, // 8958
  { PseudoVSUXEI32_V_M2_MF2_MASK, VSUXEI32_V, 0x7, 0x0 }, // 8959
  { PseudoVSUXEI32_V_MF2_MF2, VSUXEI32_V, 0x7, 0x0 }, // 8960
  { PseudoVSUXEI32_V_MF2_MF2_MASK, VSUXEI32_V, 0x7, 0x0 }, // 8961
  { PseudoVSUXEI64_V_M1_M1, VSUXEI64_V, 0x0, 0x0 }, // 8962
  { PseudoVSUXEI64_V_M1_M1_MASK, VSUXEI64_V, 0x0, 0x0 }, // 8963
  { PseudoVSUXEI64_V_M2_M1, VSUXEI64_V, 0x0, 0x0 }, // 8964
  { PseudoVSUXEI64_V_M2_M1_MASK, VSUXEI64_V, 0x0, 0x0 }, // 8965
  { PseudoVSUXEI64_V_M4_M1, VSUXEI64_V, 0x0, 0x0 }, // 8966
  { PseudoVSUXEI64_V_M4_M1_MASK, VSUXEI64_V, 0x0, 0x0 }, // 8967
  { PseudoVSUXEI64_V_M8_M1, VSUXEI64_V, 0x0, 0x0 }, // 8968
  { PseudoVSUXEI64_V_M8_M1_MASK, VSUXEI64_V, 0x0, 0x0 }, // 8969
  { PseudoVSUXEI64_V_M2_M2, VSUXEI64_V, 0x1, 0x0 }, // 8970
  { PseudoVSUXEI64_V_M2_M2_MASK, VSUXEI64_V, 0x1, 0x0 }, // 8971
  { PseudoVSUXEI64_V_M4_M2, VSUXEI64_V, 0x1, 0x0 }, // 8972
  { PseudoVSUXEI64_V_M4_M2_MASK, VSUXEI64_V, 0x1, 0x0 }, // 8973
  { PseudoVSUXEI64_V_M8_M2, VSUXEI64_V, 0x1, 0x0 }, // 8974
  { PseudoVSUXEI64_V_M8_M2_MASK, VSUXEI64_V, 0x1, 0x0 }, // 8975
  { PseudoVSUXEI64_V_M4_M4, VSUXEI64_V, 0x2, 0x0 }, // 8976
  { PseudoVSUXEI64_V_M4_M4_MASK, VSUXEI64_V, 0x2, 0x0 }, // 8977
  { PseudoVSUXEI64_V_M8_M4, VSUXEI64_V, 0x2, 0x0 }, // 8978
  { PseudoVSUXEI64_V_M8_M4_MASK, VSUXEI64_V, 0x2, 0x0 }, // 8979
  { PseudoVSUXEI64_V_M8_M8, VSUXEI64_V, 0x3, 0x0 }, // 8980
  { PseudoVSUXEI64_V_M8_M8_MASK, VSUXEI64_V, 0x3, 0x0 }, // 8981
  { PseudoVSUXEI64_V_M1_MF8, VSUXEI64_V, 0x5, 0x0 }, // 8982
  { PseudoVSUXEI64_V_M1_MF8_MASK, VSUXEI64_V, 0x5, 0x0 }, // 8983
  { PseudoVSUXEI64_V_M1_MF4, VSUXEI64_V, 0x6, 0x0 }, // 8984
  { PseudoVSUXEI64_V_M1_MF4_MASK, VSUXEI64_V, 0x6, 0x0 }, // 8985
  { PseudoVSUXEI64_V_M2_MF4, VSUXEI64_V, 0x6, 0x0 }, // 8986
  { PseudoVSUXEI64_V_M2_MF4_MASK, VSUXEI64_V, 0x6, 0x0 }, // 8987
  { PseudoVSUXEI64_V_M1_MF2, VSUXEI64_V, 0x7, 0x0 }, // 8988
  { PseudoVSUXEI64_V_M1_MF2_MASK, VSUXEI64_V, 0x7, 0x0 }, // 8989
  { PseudoVSUXEI64_V_M2_MF2, VSUXEI64_V, 0x7, 0x0 }, // 8990
  { PseudoVSUXEI64_V_M2_MF2_MASK, VSUXEI64_V, 0x7, 0x0 }, // 8991
  { PseudoVSUXEI64_V_M4_MF2, VSUXEI64_V, 0x7, 0x0 }, // 8992
  { PseudoVSUXEI64_V_M4_MF2_MASK, VSUXEI64_V, 0x7, 0x0 }, // 8993
  { PseudoVSUXEI8_V_M1_M1, VSUXEI8_V, 0x0, 0x0 }, // 8994
  { PseudoVSUXEI8_V_M1_M1_MASK, VSUXEI8_V, 0x0, 0x0 }, // 8995
  { PseudoVSUXEI8_V_MF2_M1, VSUXEI8_V, 0x0, 0x0 }, // 8996
  { PseudoVSUXEI8_V_MF2_M1_MASK, VSUXEI8_V, 0x0, 0x0 }, // 8997
  { PseudoVSUXEI8_V_MF4_M1, VSUXEI8_V, 0x0, 0x0 }, // 8998
  { PseudoVSUXEI8_V_MF4_M1_MASK, VSUXEI8_V, 0x0, 0x0 }, // 8999
  { PseudoVSUXEI8_V_MF8_M1, VSUXEI8_V, 0x0, 0x0 }, // 9000
  { PseudoVSUXEI8_V_MF8_M1_MASK, VSUXEI8_V, 0x0, 0x0 }, // 9001
  { PseudoVSUXEI8_V_M1_M2, VSUXEI8_V, 0x1, 0x0 }, // 9002
  { PseudoVSUXEI8_V_M1_M2_MASK, VSUXEI8_V, 0x1, 0x0 }, // 9003
  { PseudoVSUXEI8_V_M2_M2, VSUXEI8_V, 0x1, 0x0 }, // 9004
  { PseudoVSUXEI8_V_M2_M2_MASK, VSUXEI8_V, 0x1, 0x0 }, // 9005
  { PseudoVSUXEI8_V_MF2_M2, VSUXEI8_V, 0x1, 0x0 }, // 9006
  { PseudoVSUXEI8_V_MF2_M2_MASK, VSUXEI8_V, 0x1, 0x0 }, // 9007
  { PseudoVSUXEI8_V_MF4_M2, VSUXEI8_V, 0x1, 0x0 }, // 9008
  { PseudoVSUXEI8_V_MF4_M2_MASK, VSUXEI8_V, 0x1, 0x0 }, // 9009
  { PseudoVSUXEI8_V_M1_M4, VSUXEI8_V, 0x2, 0x0 }, // 9010
  { PseudoVSUXEI8_V_M1_M4_MASK, VSUXEI8_V, 0x2, 0x0 }, // 9011
  { PseudoVSUXEI8_V_M2_M4, VSUXEI8_V, 0x2, 0x0 }, // 9012
  { PseudoVSUXEI8_V_M2_M4_MASK, VSUXEI8_V, 0x2, 0x0 }, // 9013
  { PseudoVSUXEI8_V_M4_M4, VSUXEI8_V, 0x2, 0x0 }, // 9014
  { PseudoVSUXEI8_V_M4_M4_MASK, VSUXEI8_V, 0x2, 0x0 }, // 9015
  { PseudoVSUXEI8_V_MF2_M4, VSUXEI8_V, 0x2, 0x0 }, // 9016
  { PseudoVSUXEI8_V_MF2_M4_MASK, VSUXEI8_V, 0x2, 0x0 }, // 9017
  { PseudoVSUXEI8_V_M1_M8, VSUXEI8_V, 0x3, 0x0 }, // 9018
  { PseudoVSUXEI8_V_M1_M8_MASK, VSUXEI8_V, 0x3, 0x0 }, // 9019
  { PseudoVSUXEI8_V_M2_M8, VSUXEI8_V, 0x3, 0x0 }, // 9020
  { PseudoVSUXEI8_V_M2_M8_MASK, VSUXEI8_V, 0x3, 0x0 }, // 9021
  { PseudoVSUXEI8_V_M4_M8, VSUXEI8_V, 0x3, 0x0 }, // 9022
  { PseudoVSUXEI8_V_M4_M8_MASK, VSUXEI8_V, 0x3, 0x0 }, // 9023
  { PseudoVSUXEI8_V_M8_M8, VSUXEI8_V, 0x3, 0x0 }, // 9024
  { PseudoVSUXEI8_V_M8_M8_MASK, VSUXEI8_V, 0x3, 0x0 }, // 9025
  { PseudoVSUXEI8_V_MF8_MF8, VSUXEI8_V, 0x5, 0x0 }, // 9026
  { PseudoVSUXEI8_V_MF8_MF8_MASK, VSUXEI8_V, 0x5, 0x0 }, // 9027
  { PseudoVSUXEI8_V_MF4_MF4, VSUXEI8_V, 0x6, 0x0 }, // 9028
  { PseudoVSUXEI8_V_MF4_MF4_MASK, VSUXEI8_V, 0x6, 0x0 }, // 9029
  { PseudoVSUXEI8_V_MF8_MF4, VSUXEI8_V, 0x6, 0x0 }, // 9030
  { PseudoVSUXEI8_V_MF8_MF4_MASK, VSUXEI8_V, 0x6, 0x0 }, // 9031
  { PseudoVSUXEI8_V_MF2_MF2, VSUXEI8_V, 0x7, 0x0 }, // 9032
  { PseudoVSUXEI8_V_MF2_MF2_MASK, VSUXEI8_V, 0x7, 0x0 }, // 9033
  { PseudoVSUXEI8_V_MF4_MF2, VSUXEI8_V, 0x7, 0x0 }, // 9034
  { PseudoVSUXEI8_V_MF4_MF2_MASK, VSUXEI8_V, 0x7, 0x0 }, // 9035
  { PseudoVSUXEI8_V_MF8_MF2, VSUXEI8_V, 0x7, 0x0 }, // 9036
  { PseudoVSUXEI8_V_MF8_MF2_MASK, VSUXEI8_V, 0x7, 0x0 }, // 9037
  { PseudoVSUXSEG2EI16_V_M1_M1, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9038
  { PseudoVSUXSEG2EI16_V_M1_M1_MASK, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9039
  { PseudoVSUXSEG2EI16_V_M2_M1, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9040
  { PseudoVSUXSEG2EI16_V_M2_M1_MASK, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9041
  { PseudoVSUXSEG2EI16_V_MF2_M1, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9042
  { PseudoVSUXSEG2EI16_V_MF2_M1_MASK, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9043
  { PseudoVSUXSEG2EI16_V_MF4_M1, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9044
  { PseudoVSUXSEG2EI16_V_MF4_M1_MASK, VSUXSEG2EI16_V, 0x0, 0x0 }, // 9045
  { PseudoVSUXSEG2EI16_V_M1_M2, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9046
  { PseudoVSUXSEG2EI16_V_M1_M2_MASK, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9047
  { PseudoVSUXSEG2EI16_V_M2_M2, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9048
  { PseudoVSUXSEG2EI16_V_M2_M2_MASK, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9049
  { PseudoVSUXSEG2EI16_V_M4_M2, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9050
  { PseudoVSUXSEG2EI16_V_M4_M2_MASK, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9051
  { PseudoVSUXSEG2EI16_V_MF2_M2, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9052
  { PseudoVSUXSEG2EI16_V_MF2_M2_MASK, VSUXSEG2EI16_V, 0x1, 0x0 }, // 9053
  { PseudoVSUXSEG2EI16_V_M1_M4, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9054
  { PseudoVSUXSEG2EI16_V_M1_M4_MASK, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9055
  { PseudoVSUXSEG2EI16_V_M2_M4, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9056
  { PseudoVSUXSEG2EI16_V_M2_M4_MASK, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9057
  { PseudoVSUXSEG2EI16_V_M4_M4, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9058
  { PseudoVSUXSEG2EI16_V_M4_M4_MASK, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9059
  { PseudoVSUXSEG2EI16_V_M8_M4, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9060
  { PseudoVSUXSEG2EI16_V_M8_M4_MASK, VSUXSEG2EI16_V, 0x2, 0x0 }, // 9061
  { PseudoVSUXSEG2EI16_V_MF4_MF8, VSUXSEG2EI16_V, 0x5, 0x0 }, // 9062
  { PseudoVSUXSEG2EI16_V_MF4_MF8_MASK, VSUXSEG2EI16_V, 0x5, 0x0 }, // 9063
  { PseudoVSUXSEG2EI16_V_MF2_MF4, VSUXSEG2EI16_V, 0x6, 0x0 }, // 9064
  { PseudoVSUXSEG2EI16_V_MF2_MF4_MASK, VSUXSEG2EI16_V, 0x6, 0x0 }, // 9065
  { PseudoVSUXSEG2EI16_V_MF4_MF4, VSUXSEG2EI16_V, 0x6, 0x0 }, // 9066
  { PseudoVSUXSEG2EI16_V_MF4_MF4_MASK, VSUXSEG2EI16_V, 0x6, 0x0 }, // 9067
  { PseudoVSUXSEG2EI16_V_M1_MF2, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9068
  { PseudoVSUXSEG2EI16_V_M1_MF2_MASK, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9069
  { PseudoVSUXSEG2EI16_V_MF2_MF2, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9070
  { PseudoVSUXSEG2EI16_V_MF2_MF2_MASK, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9071
  { PseudoVSUXSEG2EI16_V_MF4_MF2, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9072
  { PseudoVSUXSEG2EI16_V_MF4_MF2_MASK, VSUXSEG2EI16_V, 0x7, 0x0 }, // 9073
  { PseudoVSUXSEG2EI32_V_M1_M1, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9074
  { PseudoVSUXSEG2EI32_V_M1_M1_MASK, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9075
  { PseudoVSUXSEG2EI32_V_M2_M1, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9076
  { PseudoVSUXSEG2EI32_V_M2_M1_MASK, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9077
  { PseudoVSUXSEG2EI32_V_M4_M1, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9078
  { PseudoVSUXSEG2EI32_V_M4_M1_MASK, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9079
  { PseudoVSUXSEG2EI32_V_MF2_M1, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9080
  { PseudoVSUXSEG2EI32_V_MF2_M1_MASK, VSUXSEG2EI32_V, 0x0, 0x0 }, // 9081
  { PseudoVSUXSEG2EI32_V_M1_M2, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9082
  { PseudoVSUXSEG2EI32_V_M1_M2_MASK, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9083
  { PseudoVSUXSEG2EI32_V_M2_M2, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9084
  { PseudoVSUXSEG2EI32_V_M2_M2_MASK, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9085
  { PseudoVSUXSEG2EI32_V_M4_M2, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9086
  { PseudoVSUXSEG2EI32_V_M4_M2_MASK, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9087
  { PseudoVSUXSEG2EI32_V_M8_M2, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9088
  { PseudoVSUXSEG2EI32_V_M8_M2_MASK, VSUXSEG2EI32_V, 0x1, 0x0 }, // 9089
  { PseudoVSUXSEG2EI32_V_M2_M4, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9090
  { PseudoVSUXSEG2EI32_V_M2_M4_MASK, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9091
  { PseudoVSUXSEG2EI32_V_M4_M4, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9092
  { PseudoVSUXSEG2EI32_V_M4_M4_MASK, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9093
  { PseudoVSUXSEG2EI32_V_M8_M4, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9094
  { PseudoVSUXSEG2EI32_V_M8_M4_MASK, VSUXSEG2EI32_V, 0x2, 0x0 }, // 9095
  { PseudoVSUXSEG2EI32_V_MF2_MF8, VSUXSEG2EI32_V, 0x5, 0x0 }, // 9096
  { PseudoVSUXSEG2EI32_V_MF2_MF8_MASK, VSUXSEG2EI32_V, 0x5, 0x0 }, // 9097
  { PseudoVSUXSEG2EI32_V_M1_MF4, VSUXSEG2EI32_V, 0x6, 0x0 }, // 9098
  { PseudoVSUXSEG2EI32_V_M1_MF4_MASK, VSUXSEG2EI32_V, 0x6, 0x0 }, // 9099
  { PseudoVSUXSEG2EI32_V_MF2_MF4, VSUXSEG2EI32_V, 0x6, 0x0 }, // 9100
  { PseudoVSUXSEG2EI32_V_MF2_MF4_MASK, VSUXSEG2EI32_V, 0x6, 0x0 }, // 9101
  { PseudoVSUXSEG2EI32_V_M1_MF2, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9102
  { PseudoVSUXSEG2EI32_V_M1_MF2_MASK, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9103
  { PseudoVSUXSEG2EI32_V_M2_MF2, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9104
  { PseudoVSUXSEG2EI32_V_M2_MF2_MASK, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9105
  { PseudoVSUXSEG2EI32_V_MF2_MF2, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9106
  { PseudoVSUXSEG2EI32_V_MF2_MF2_MASK, VSUXSEG2EI32_V, 0x7, 0x0 }, // 9107
  { PseudoVSUXSEG2EI64_V_M1_M1, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9108
  { PseudoVSUXSEG2EI64_V_M1_M1_MASK, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9109
  { PseudoVSUXSEG2EI64_V_M2_M1, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9110
  { PseudoVSUXSEG2EI64_V_M2_M1_MASK, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9111
  { PseudoVSUXSEG2EI64_V_M4_M1, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9112
  { PseudoVSUXSEG2EI64_V_M4_M1_MASK, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9113
  { PseudoVSUXSEG2EI64_V_M8_M1, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9114
  { PseudoVSUXSEG2EI64_V_M8_M1_MASK, VSUXSEG2EI64_V, 0x0, 0x0 }, // 9115
  { PseudoVSUXSEG2EI64_V_M2_M2, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9116
  { PseudoVSUXSEG2EI64_V_M2_M2_MASK, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9117
  { PseudoVSUXSEG2EI64_V_M4_M2, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9118
  { PseudoVSUXSEG2EI64_V_M4_M2_MASK, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9119
  { PseudoVSUXSEG2EI64_V_M8_M2, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9120
  { PseudoVSUXSEG2EI64_V_M8_M2_MASK, VSUXSEG2EI64_V, 0x1, 0x0 }, // 9121
  { PseudoVSUXSEG2EI64_V_M4_M4, VSUXSEG2EI64_V, 0x2, 0x0 }, // 9122
  { PseudoVSUXSEG2EI64_V_M4_M4_MASK, VSUXSEG2EI64_V, 0x2, 0x0 }, // 9123
  { PseudoVSUXSEG2EI64_V_M8_M4, VSUXSEG2EI64_V, 0x2, 0x0 }, // 9124
  { PseudoVSUXSEG2EI64_V_M8_M4_MASK, VSUXSEG2EI64_V, 0x2, 0x0 }, // 9125
  { PseudoVSUXSEG2EI64_V_M1_MF8, VSUXSEG2EI64_V, 0x5, 0x0 }, // 9126
  { PseudoVSUXSEG2EI64_V_M1_MF8_MASK, VSUXSEG2EI64_V, 0x5, 0x0 }, // 9127
  { PseudoVSUXSEG2EI64_V_M1_MF4, VSUXSEG2EI64_V, 0x6, 0x0 }, // 9128
  { PseudoVSUXSEG2EI64_V_M1_MF4_MASK, VSUXSEG2EI64_V, 0x6, 0x0 }, // 9129
  { PseudoVSUXSEG2EI64_V_M2_MF4, VSUXSEG2EI64_V, 0x6, 0x0 }, // 9130
  { PseudoVSUXSEG2EI64_V_M2_MF4_MASK, VSUXSEG2EI64_V, 0x6, 0x0 }, // 9131
  { PseudoVSUXSEG2EI64_V_M1_MF2, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9132
  { PseudoVSUXSEG2EI64_V_M1_MF2_MASK, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9133
  { PseudoVSUXSEG2EI64_V_M2_MF2, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9134
  { PseudoVSUXSEG2EI64_V_M2_MF2_MASK, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9135
  { PseudoVSUXSEG2EI64_V_M4_MF2, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9136
  { PseudoVSUXSEG2EI64_V_M4_MF2_MASK, VSUXSEG2EI64_V, 0x7, 0x0 }, // 9137
  { PseudoVSUXSEG2EI8_V_M1_M1, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9138
  { PseudoVSUXSEG2EI8_V_M1_M1_MASK, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9139
  { PseudoVSUXSEG2EI8_V_MF2_M1, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9140
  { PseudoVSUXSEG2EI8_V_MF2_M1_MASK, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9141
  { PseudoVSUXSEG2EI8_V_MF4_M1, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9142
  { PseudoVSUXSEG2EI8_V_MF4_M1_MASK, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9143
  { PseudoVSUXSEG2EI8_V_MF8_M1, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9144
  { PseudoVSUXSEG2EI8_V_MF8_M1_MASK, VSUXSEG2EI8_V, 0x0, 0x0 }, // 9145
  { PseudoVSUXSEG2EI8_V_M1_M2, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9146
  { PseudoVSUXSEG2EI8_V_M1_M2_MASK, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9147
  { PseudoVSUXSEG2EI8_V_M2_M2, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9148
  { PseudoVSUXSEG2EI8_V_M2_M2_MASK, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9149
  { PseudoVSUXSEG2EI8_V_MF2_M2, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9150
  { PseudoVSUXSEG2EI8_V_MF2_M2_MASK, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9151
  { PseudoVSUXSEG2EI8_V_MF4_M2, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9152
  { PseudoVSUXSEG2EI8_V_MF4_M2_MASK, VSUXSEG2EI8_V, 0x1, 0x0 }, // 9153
  { PseudoVSUXSEG2EI8_V_M1_M4, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9154
  { PseudoVSUXSEG2EI8_V_M1_M4_MASK, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9155
  { PseudoVSUXSEG2EI8_V_M2_M4, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9156
  { PseudoVSUXSEG2EI8_V_M2_M4_MASK, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9157
  { PseudoVSUXSEG2EI8_V_M4_M4, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9158
  { PseudoVSUXSEG2EI8_V_M4_M4_MASK, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9159
  { PseudoVSUXSEG2EI8_V_MF2_M4, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9160
  { PseudoVSUXSEG2EI8_V_MF2_M4_MASK, VSUXSEG2EI8_V, 0x2, 0x0 }, // 9161
  { PseudoVSUXSEG2EI8_V_MF8_MF8, VSUXSEG2EI8_V, 0x5, 0x0 }, // 9162
  { PseudoVSUXSEG2EI8_V_MF8_MF8_MASK, VSUXSEG2EI8_V, 0x5, 0x0 }, // 9163
  { PseudoVSUXSEG2EI8_V_MF4_MF4, VSUXSEG2EI8_V, 0x6, 0x0 }, // 9164
  { PseudoVSUXSEG2EI8_V_MF4_MF4_MASK, VSUXSEG2EI8_V, 0x6, 0x0 }, // 9165
  { PseudoVSUXSEG2EI8_V_MF8_MF4, VSUXSEG2EI8_V, 0x6, 0x0 }, // 9166
  { PseudoVSUXSEG2EI8_V_MF8_MF4_MASK, VSUXSEG2EI8_V, 0x6, 0x0 }, // 9167
  { PseudoVSUXSEG2EI8_V_MF2_MF2, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9168
  { PseudoVSUXSEG2EI8_V_MF2_MF2_MASK, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9169
  { PseudoVSUXSEG2EI8_V_MF4_MF2, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9170
  { PseudoVSUXSEG2EI8_V_MF4_MF2_MASK, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9171
  { PseudoVSUXSEG2EI8_V_MF8_MF2, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9172
  { PseudoVSUXSEG2EI8_V_MF8_MF2_MASK, VSUXSEG2EI8_V, 0x7, 0x0 }, // 9173
  { PseudoVSUXSEG3EI16_V_M1_M1, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9174
  { PseudoVSUXSEG3EI16_V_M1_M1_MASK, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9175
  { PseudoVSUXSEG3EI16_V_M2_M1, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9176
  { PseudoVSUXSEG3EI16_V_M2_M1_MASK, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9177
  { PseudoVSUXSEG3EI16_V_MF2_M1, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9178
  { PseudoVSUXSEG3EI16_V_MF2_M1_MASK, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9179
  { PseudoVSUXSEG3EI16_V_MF4_M1, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9180
  { PseudoVSUXSEG3EI16_V_MF4_M1_MASK, VSUXSEG3EI16_V, 0x0, 0x0 }, // 9181
  { PseudoVSUXSEG3EI16_V_M1_M2, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9182
  { PseudoVSUXSEG3EI16_V_M1_M2_MASK, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9183
  { PseudoVSUXSEG3EI16_V_M2_M2, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9184
  { PseudoVSUXSEG3EI16_V_M2_M2_MASK, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9185
  { PseudoVSUXSEG3EI16_V_M4_M2, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9186
  { PseudoVSUXSEG3EI16_V_M4_M2_MASK, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9187
  { PseudoVSUXSEG3EI16_V_MF2_M2, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9188
  { PseudoVSUXSEG3EI16_V_MF2_M2_MASK, VSUXSEG3EI16_V, 0x1, 0x0 }, // 9189
  { PseudoVSUXSEG3EI16_V_MF4_MF8, VSUXSEG3EI16_V, 0x5, 0x0 }, // 9190
  { PseudoVSUXSEG3EI16_V_MF4_MF8_MASK, VSUXSEG3EI16_V, 0x5, 0x0 }, // 9191
  { PseudoVSUXSEG3EI16_V_MF2_MF4, VSUXSEG3EI16_V, 0x6, 0x0 }, // 9192
  { PseudoVSUXSEG3EI16_V_MF2_MF4_MASK, VSUXSEG3EI16_V, 0x6, 0x0 }, // 9193
  { PseudoVSUXSEG3EI16_V_MF4_MF4, VSUXSEG3EI16_V, 0x6, 0x0 }, // 9194
  { PseudoVSUXSEG3EI16_V_MF4_MF4_MASK, VSUXSEG3EI16_V, 0x6, 0x0 }, // 9195
  { PseudoVSUXSEG3EI16_V_M1_MF2, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9196
  { PseudoVSUXSEG3EI16_V_M1_MF2_MASK, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9197
  { PseudoVSUXSEG3EI16_V_MF2_MF2, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9198
  { PseudoVSUXSEG3EI16_V_MF2_MF2_MASK, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9199
  { PseudoVSUXSEG3EI16_V_MF4_MF2, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9200
  { PseudoVSUXSEG3EI16_V_MF4_MF2_MASK, VSUXSEG3EI16_V, 0x7, 0x0 }, // 9201
  { PseudoVSUXSEG3EI32_V_M1_M1, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9202
  { PseudoVSUXSEG3EI32_V_M1_M1_MASK, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9203
  { PseudoVSUXSEG3EI32_V_M2_M1, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9204
  { PseudoVSUXSEG3EI32_V_M2_M1_MASK, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9205
  { PseudoVSUXSEG3EI32_V_M4_M1, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9206
  { PseudoVSUXSEG3EI32_V_M4_M1_MASK, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9207
  { PseudoVSUXSEG3EI32_V_MF2_M1, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9208
  { PseudoVSUXSEG3EI32_V_MF2_M1_MASK, VSUXSEG3EI32_V, 0x0, 0x0 }, // 9209
  { PseudoVSUXSEG3EI32_V_M1_M2, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9210
  { PseudoVSUXSEG3EI32_V_M1_M2_MASK, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9211
  { PseudoVSUXSEG3EI32_V_M2_M2, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9212
  { PseudoVSUXSEG3EI32_V_M2_M2_MASK, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9213
  { PseudoVSUXSEG3EI32_V_M4_M2, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9214
  { PseudoVSUXSEG3EI32_V_M4_M2_MASK, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9215
  { PseudoVSUXSEG3EI32_V_M8_M2, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9216
  { PseudoVSUXSEG3EI32_V_M8_M2_MASK, VSUXSEG3EI32_V, 0x1, 0x0 }, // 9217
  { PseudoVSUXSEG3EI32_V_MF2_MF8, VSUXSEG3EI32_V, 0x5, 0x0 }, // 9218
  { PseudoVSUXSEG3EI32_V_MF2_MF8_MASK, VSUXSEG3EI32_V, 0x5, 0x0 }, // 9219
  { PseudoVSUXSEG3EI32_V_M1_MF4, VSUXSEG3EI32_V, 0x6, 0x0 }, // 9220
  { PseudoVSUXSEG3EI32_V_M1_MF4_MASK, VSUXSEG3EI32_V, 0x6, 0x0 }, // 9221
  { PseudoVSUXSEG3EI32_V_MF2_MF4, VSUXSEG3EI32_V, 0x6, 0x0 }, // 9222
  { PseudoVSUXSEG3EI32_V_MF2_MF4_MASK, VSUXSEG3EI32_V, 0x6, 0x0 }, // 9223
  { PseudoVSUXSEG3EI32_V_M1_MF2, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9224
  { PseudoVSUXSEG3EI32_V_M1_MF2_MASK, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9225
  { PseudoVSUXSEG3EI32_V_M2_MF2, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9226
  { PseudoVSUXSEG3EI32_V_M2_MF2_MASK, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9227
  { PseudoVSUXSEG3EI32_V_MF2_MF2, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9228
  { PseudoVSUXSEG3EI32_V_MF2_MF2_MASK, VSUXSEG3EI32_V, 0x7, 0x0 }, // 9229
  { PseudoVSUXSEG3EI64_V_M1_M1, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9230
  { PseudoVSUXSEG3EI64_V_M1_M1_MASK, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9231
  { PseudoVSUXSEG3EI64_V_M2_M1, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9232
  { PseudoVSUXSEG3EI64_V_M2_M1_MASK, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9233
  { PseudoVSUXSEG3EI64_V_M4_M1, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9234
  { PseudoVSUXSEG3EI64_V_M4_M1_MASK, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9235
  { PseudoVSUXSEG3EI64_V_M8_M1, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9236
  { PseudoVSUXSEG3EI64_V_M8_M1_MASK, VSUXSEG3EI64_V, 0x0, 0x0 }, // 9237
  { PseudoVSUXSEG3EI64_V_M2_M2, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9238
  { PseudoVSUXSEG3EI64_V_M2_M2_MASK, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9239
  { PseudoVSUXSEG3EI64_V_M4_M2, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9240
  { PseudoVSUXSEG3EI64_V_M4_M2_MASK, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9241
  { PseudoVSUXSEG3EI64_V_M8_M2, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9242
  { PseudoVSUXSEG3EI64_V_M8_M2_MASK, VSUXSEG3EI64_V, 0x1, 0x0 }, // 9243
  { PseudoVSUXSEG3EI64_V_M1_MF8, VSUXSEG3EI64_V, 0x5, 0x0 }, // 9244
  { PseudoVSUXSEG3EI64_V_M1_MF8_MASK, VSUXSEG3EI64_V, 0x5, 0x0 }, // 9245
  { PseudoVSUXSEG3EI64_V_M1_MF4, VSUXSEG3EI64_V, 0x6, 0x0 }, // 9246
  { PseudoVSUXSEG3EI64_V_M1_MF4_MASK, VSUXSEG3EI64_V, 0x6, 0x0 }, // 9247
  { PseudoVSUXSEG3EI64_V_M2_MF4, VSUXSEG3EI64_V, 0x6, 0x0 }, // 9248
  { PseudoVSUXSEG3EI64_V_M2_MF4_MASK, VSUXSEG3EI64_V, 0x6, 0x0 }, // 9249
  { PseudoVSUXSEG3EI64_V_M1_MF2, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9250
  { PseudoVSUXSEG3EI64_V_M1_MF2_MASK, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9251
  { PseudoVSUXSEG3EI64_V_M2_MF2, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9252
  { PseudoVSUXSEG3EI64_V_M2_MF2_MASK, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9253
  { PseudoVSUXSEG3EI64_V_M4_MF2, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9254
  { PseudoVSUXSEG3EI64_V_M4_MF2_MASK, VSUXSEG3EI64_V, 0x7, 0x0 }, // 9255
  { PseudoVSUXSEG3EI8_V_M1_M1, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9256
  { PseudoVSUXSEG3EI8_V_M1_M1_MASK, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9257
  { PseudoVSUXSEG3EI8_V_MF2_M1, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9258
  { PseudoVSUXSEG3EI8_V_MF2_M1_MASK, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9259
  { PseudoVSUXSEG3EI8_V_MF4_M1, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9260
  { PseudoVSUXSEG3EI8_V_MF4_M1_MASK, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9261
  { PseudoVSUXSEG3EI8_V_MF8_M1, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9262
  { PseudoVSUXSEG3EI8_V_MF8_M1_MASK, VSUXSEG3EI8_V, 0x0, 0x0 }, // 9263
  { PseudoVSUXSEG3EI8_V_M1_M2, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9264
  { PseudoVSUXSEG3EI8_V_M1_M2_MASK, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9265
  { PseudoVSUXSEG3EI8_V_M2_M2, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9266
  { PseudoVSUXSEG3EI8_V_M2_M2_MASK, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9267
  { PseudoVSUXSEG3EI8_V_MF2_M2, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9268
  { PseudoVSUXSEG3EI8_V_MF2_M2_MASK, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9269
  { PseudoVSUXSEG3EI8_V_MF4_M2, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9270
  { PseudoVSUXSEG3EI8_V_MF4_M2_MASK, VSUXSEG3EI8_V, 0x1, 0x0 }, // 9271
  { PseudoVSUXSEG3EI8_V_MF8_MF8, VSUXSEG3EI8_V, 0x5, 0x0 }, // 9272
  { PseudoVSUXSEG3EI8_V_MF8_MF8_MASK, VSUXSEG3EI8_V, 0x5, 0x0 }, // 9273
  { PseudoVSUXSEG3EI8_V_MF4_MF4, VSUXSEG3EI8_V, 0x6, 0x0 }, // 9274
  { PseudoVSUXSEG3EI8_V_MF4_MF4_MASK, VSUXSEG3EI8_V, 0x6, 0x0 }, // 9275
  { PseudoVSUXSEG3EI8_V_MF8_MF4, VSUXSEG3EI8_V, 0x6, 0x0 }, // 9276
  { PseudoVSUXSEG3EI8_V_MF8_MF4_MASK, VSUXSEG3EI8_V, 0x6, 0x0 }, // 9277
  { PseudoVSUXSEG3EI8_V_MF2_MF2, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9278
  { PseudoVSUXSEG3EI8_V_MF2_MF2_MASK, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9279
  { PseudoVSUXSEG3EI8_V_MF4_MF2, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9280
  { PseudoVSUXSEG3EI8_V_MF4_MF2_MASK, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9281
  { PseudoVSUXSEG3EI8_V_MF8_MF2, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9282
  { PseudoVSUXSEG3EI8_V_MF8_MF2_MASK, VSUXSEG3EI8_V, 0x7, 0x0 }, // 9283
  { PseudoVSUXSEG4EI16_V_M1_M1, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9284
  { PseudoVSUXSEG4EI16_V_M1_M1_MASK, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9285
  { PseudoVSUXSEG4EI16_V_M2_M1, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9286
  { PseudoVSUXSEG4EI16_V_M2_M1_MASK, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9287
  { PseudoVSUXSEG4EI16_V_MF2_M1, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9288
  { PseudoVSUXSEG4EI16_V_MF2_M1_MASK, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9289
  { PseudoVSUXSEG4EI16_V_MF4_M1, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9290
  { PseudoVSUXSEG4EI16_V_MF4_M1_MASK, VSUXSEG4EI16_V, 0x0, 0x0 }, // 9291
  { PseudoVSUXSEG4EI16_V_M1_M2, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9292
  { PseudoVSUXSEG4EI16_V_M1_M2_MASK, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9293
  { PseudoVSUXSEG4EI16_V_M2_M2, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9294
  { PseudoVSUXSEG4EI16_V_M2_M2_MASK, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9295
  { PseudoVSUXSEG4EI16_V_M4_M2, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9296
  { PseudoVSUXSEG4EI16_V_M4_M2_MASK, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9297
  { PseudoVSUXSEG4EI16_V_MF2_M2, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9298
  { PseudoVSUXSEG4EI16_V_MF2_M2_MASK, VSUXSEG4EI16_V, 0x1, 0x0 }, // 9299
  { PseudoVSUXSEG4EI16_V_MF4_MF8, VSUXSEG4EI16_V, 0x5, 0x0 }, // 9300
  { PseudoVSUXSEG4EI16_V_MF4_MF8_MASK, VSUXSEG4EI16_V, 0x5, 0x0 }, // 9301
  { PseudoVSUXSEG4EI16_V_MF2_MF4, VSUXSEG4EI16_V, 0x6, 0x0 }, // 9302
  { PseudoVSUXSEG4EI16_V_MF2_MF4_MASK, VSUXSEG4EI16_V, 0x6, 0x0 }, // 9303
  { PseudoVSUXSEG4EI16_V_MF4_MF4, VSUXSEG4EI16_V, 0x6, 0x0 }, // 9304
  { PseudoVSUXSEG4EI16_V_MF4_MF4_MASK, VSUXSEG4EI16_V, 0x6, 0x0 }, // 9305
  { PseudoVSUXSEG4EI16_V_M1_MF2, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9306
  { PseudoVSUXSEG4EI16_V_M1_MF2_MASK, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9307
  { PseudoVSUXSEG4EI16_V_MF2_MF2, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9308
  { PseudoVSUXSEG4EI16_V_MF2_MF2_MASK, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9309
  { PseudoVSUXSEG4EI16_V_MF4_MF2, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9310
  { PseudoVSUXSEG4EI16_V_MF4_MF2_MASK, VSUXSEG4EI16_V, 0x7, 0x0 }, // 9311
  { PseudoVSUXSEG4EI32_V_M1_M1, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9312
  { PseudoVSUXSEG4EI32_V_M1_M1_MASK, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9313
  { PseudoVSUXSEG4EI32_V_M2_M1, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9314
  { PseudoVSUXSEG4EI32_V_M2_M1_MASK, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9315
  { PseudoVSUXSEG4EI32_V_M4_M1, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9316
  { PseudoVSUXSEG4EI32_V_M4_M1_MASK, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9317
  { PseudoVSUXSEG4EI32_V_MF2_M1, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9318
  { PseudoVSUXSEG4EI32_V_MF2_M1_MASK, VSUXSEG4EI32_V, 0x0, 0x0 }, // 9319
  { PseudoVSUXSEG4EI32_V_M1_M2, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9320
  { PseudoVSUXSEG4EI32_V_M1_M2_MASK, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9321
  { PseudoVSUXSEG4EI32_V_M2_M2, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9322
  { PseudoVSUXSEG4EI32_V_M2_M2_MASK, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9323
  { PseudoVSUXSEG4EI32_V_M4_M2, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9324
  { PseudoVSUXSEG4EI32_V_M4_M2_MASK, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9325
  { PseudoVSUXSEG4EI32_V_M8_M2, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9326
  { PseudoVSUXSEG4EI32_V_M8_M2_MASK, VSUXSEG4EI32_V, 0x1, 0x0 }, // 9327
  { PseudoVSUXSEG4EI32_V_MF2_MF8, VSUXSEG4EI32_V, 0x5, 0x0 }, // 9328
  { PseudoVSUXSEG4EI32_V_MF2_MF8_MASK, VSUXSEG4EI32_V, 0x5, 0x0 }, // 9329
  { PseudoVSUXSEG4EI32_V_M1_MF4, VSUXSEG4EI32_V, 0x6, 0x0 }, // 9330
  { PseudoVSUXSEG4EI32_V_M1_MF4_MASK, VSUXSEG4EI32_V, 0x6, 0x0 }, // 9331
  { PseudoVSUXSEG4EI32_V_MF2_MF4, VSUXSEG4EI32_V, 0x6, 0x0 }, // 9332
  { PseudoVSUXSEG4EI32_V_MF2_MF4_MASK, VSUXSEG4EI32_V, 0x6, 0x0 }, // 9333
  { PseudoVSUXSEG4EI32_V_M1_MF2, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9334
  { PseudoVSUXSEG4EI32_V_M1_MF2_MASK, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9335
  { PseudoVSUXSEG4EI32_V_M2_MF2, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9336
  { PseudoVSUXSEG4EI32_V_M2_MF2_MASK, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9337
  { PseudoVSUXSEG4EI32_V_MF2_MF2, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9338
  { PseudoVSUXSEG4EI32_V_MF2_MF2_MASK, VSUXSEG4EI32_V, 0x7, 0x0 }, // 9339
  { PseudoVSUXSEG4EI64_V_M1_M1, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9340
  { PseudoVSUXSEG4EI64_V_M1_M1_MASK, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9341
  { PseudoVSUXSEG4EI64_V_M2_M1, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9342
  { PseudoVSUXSEG4EI64_V_M2_M1_MASK, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9343
  { PseudoVSUXSEG4EI64_V_M4_M1, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9344
  { PseudoVSUXSEG4EI64_V_M4_M1_MASK, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9345
  { PseudoVSUXSEG4EI64_V_M8_M1, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9346
  { PseudoVSUXSEG4EI64_V_M8_M1_MASK, VSUXSEG4EI64_V, 0x0, 0x0 }, // 9347
  { PseudoVSUXSEG4EI64_V_M2_M2, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9348
  { PseudoVSUXSEG4EI64_V_M2_M2_MASK, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9349
  { PseudoVSUXSEG4EI64_V_M4_M2, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9350
  { PseudoVSUXSEG4EI64_V_M4_M2_MASK, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9351
  { PseudoVSUXSEG4EI64_V_M8_M2, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9352
  { PseudoVSUXSEG4EI64_V_M8_M2_MASK, VSUXSEG4EI64_V, 0x1, 0x0 }, // 9353
  { PseudoVSUXSEG4EI64_V_M1_MF8, VSUXSEG4EI64_V, 0x5, 0x0 }, // 9354
  { PseudoVSUXSEG4EI64_V_M1_MF8_MASK, VSUXSEG4EI64_V, 0x5, 0x0 }, // 9355
  { PseudoVSUXSEG4EI64_V_M1_MF4, VSUXSEG4EI64_V, 0x6, 0x0 }, // 9356
  { PseudoVSUXSEG4EI64_V_M1_MF4_MASK, VSUXSEG4EI64_V, 0x6, 0x0 }, // 9357
  { PseudoVSUXSEG4EI64_V_M2_MF4, VSUXSEG4EI64_V, 0x6, 0x0 }, // 9358
  { PseudoVSUXSEG4EI64_V_M2_MF4_MASK, VSUXSEG4EI64_V, 0x6, 0x0 }, // 9359
  { PseudoVSUXSEG4EI64_V_M1_MF2, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9360
  { PseudoVSUXSEG4EI64_V_M1_MF2_MASK, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9361
  { PseudoVSUXSEG4EI64_V_M2_MF2, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9362
  { PseudoVSUXSEG4EI64_V_M2_MF2_MASK, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9363
  { PseudoVSUXSEG4EI64_V_M4_MF2, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9364
  { PseudoVSUXSEG4EI64_V_M4_MF2_MASK, VSUXSEG4EI64_V, 0x7, 0x0 }, // 9365
  { PseudoVSUXSEG4EI8_V_M1_M1, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9366
  { PseudoVSUXSEG4EI8_V_M1_M1_MASK, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9367
  { PseudoVSUXSEG4EI8_V_MF2_M1, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9368
  { PseudoVSUXSEG4EI8_V_MF2_M1_MASK, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9369
  { PseudoVSUXSEG4EI8_V_MF4_M1, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9370
  { PseudoVSUXSEG4EI8_V_MF4_M1_MASK, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9371
  { PseudoVSUXSEG4EI8_V_MF8_M1, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9372
  { PseudoVSUXSEG4EI8_V_MF8_M1_MASK, VSUXSEG4EI8_V, 0x0, 0x0 }, // 9373
  { PseudoVSUXSEG4EI8_V_M1_M2, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9374
  { PseudoVSUXSEG4EI8_V_M1_M2_MASK, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9375
  { PseudoVSUXSEG4EI8_V_M2_M2, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9376
  { PseudoVSUXSEG4EI8_V_M2_M2_MASK, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9377
  { PseudoVSUXSEG4EI8_V_MF2_M2, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9378
  { PseudoVSUXSEG4EI8_V_MF2_M2_MASK, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9379
  { PseudoVSUXSEG4EI8_V_MF4_M2, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9380
  { PseudoVSUXSEG4EI8_V_MF4_M2_MASK, VSUXSEG4EI8_V, 0x1, 0x0 }, // 9381
  { PseudoVSUXSEG4EI8_V_MF8_MF8, VSUXSEG4EI8_V, 0x5, 0x0 }, // 9382
  { PseudoVSUXSEG4EI8_V_MF8_MF8_MASK, VSUXSEG4EI8_V, 0x5, 0x0 }, // 9383
  { PseudoVSUXSEG4EI8_V_MF4_MF4, VSUXSEG4EI8_V, 0x6, 0x0 }, // 9384
  { PseudoVSUXSEG4EI8_V_MF4_MF4_MASK, VSUXSEG4EI8_V, 0x6, 0x0 }, // 9385
  { PseudoVSUXSEG4EI8_V_MF8_MF4, VSUXSEG4EI8_V, 0x6, 0x0 }, // 9386
  { PseudoVSUXSEG4EI8_V_MF8_MF4_MASK, VSUXSEG4EI8_V, 0x6, 0x0 }, // 9387
  { PseudoVSUXSEG4EI8_V_MF2_MF2, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9388
  { PseudoVSUXSEG4EI8_V_MF2_MF2_MASK, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9389
  { PseudoVSUXSEG4EI8_V_MF4_MF2, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9390
  { PseudoVSUXSEG4EI8_V_MF4_MF2_MASK, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9391
  { PseudoVSUXSEG4EI8_V_MF8_MF2, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9392
  { PseudoVSUXSEG4EI8_V_MF8_MF2_MASK, VSUXSEG4EI8_V, 0x7, 0x0 }, // 9393
  { PseudoVSUXSEG5EI16_V_M1_M1, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9394
  { PseudoVSUXSEG5EI16_V_M1_M1_MASK, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9395
  { PseudoVSUXSEG5EI16_V_M2_M1, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9396
  { PseudoVSUXSEG5EI16_V_M2_M1_MASK, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9397
  { PseudoVSUXSEG5EI16_V_MF2_M1, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9398
  { PseudoVSUXSEG5EI16_V_MF2_M1_MASK, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9399
  { PseudoVSUXSEG5EI16_V_MF4_M1, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9400
  { PseudoVSUXSEG5EI16_V_MF4_M1_MASK, VSUXSEG5EI16_V, 0x0, 0x0 }, // 9401
  { PseudoVSUXSEG5EI16_V_MF4_MF8, VSUXSEG5EI16_V, 0x5, 0x0 }, // 9402
  { PseudoVSUXSEG5EI16_V_MF4_MF8_MASK, VSUXSEG5EI16_V, 0x5, 0x0 }, // 9403
  { PseudoVSUXSEG5EI16_V_MF2_MF4, VSUXSEG5EI16_V, 0x6, 0x0 }, // 9404
  { PseudoVSUXSEG5EI16_V_MF2_MF4_MASK, VSUXSEG5EI16_V, 0x6, 0x0 }, // 9405
  { PseudoVSUXSEG5EI16_V_MF4_MF4, VSUXSEG5EI16_V, 0x6, 0x0 }, // 9406
  { PseudoVSUXSEG5EI16_V_MF4_MF4_MASK, VSUXSEG5EI16_V, 0x6, 0x0 }, // 9407
  { PseudoVSUXSEG5EI16_V_M1_MF2, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9408
  { PseudoVSUXSEG5EI16_V_M1_MF2_MASK, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9409
  { PseudoVSUXSEG5EI16_V_MF2_MF2, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9410
  { PseudoVSUXSEG5EI16_V_MF2_MF2_MASK, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9411
  { PseudoVSUXSEG5EI16_V_MF4_MF2, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9412
  { PseudoVSUXSEG5EI16_V_MF4_MF2_MASK, VSUXSEG5EI16_V, 0x7, 0x0 }, // 9413
  { PseudoVSUXSEG5EI32_V_M1_M1, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9414
  { PseudoVSUXSEG5EI32_V_M1_M1_MASK, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9415
  { PseudoVSUXSEG5EI32_V_M2_M1, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9416
  { PseudoVSUXSEG5EI32_V_M2_M1_MASK, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9417
  { PseudoVSUXSEG5EI32_V_M4_M1, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9418
  { PseudoVSUXSEG5EI32_V_M4_M1_MASK, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9419
  { PseudoVSUXSEG5EI32_V_MF2_M1, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9420
  { PseudoVSUXSEG5EI32_V_MF2_M1_MASK, VSUXSEG5EI32_V, 0x0, 0x0 }, // 9421
  { PseudoVSUXSEG5EI32_V_MF2_MF8, VSUXSEG5EI32_V, 0x5, 0x0 }, // 9422
  { PseudoVSUXSEG5EI32_V_MF2_MF8_MASK, VSUXSEG5EI32_V, 0x5, 0x0 }, // 9423
  { PseudoVSUXSEG5EI32_V_M1_MF4, VSUXSEG5EI32_V, 0x6, 0x0 }, // 9424
  { PseudoVSUXSEG5EI32_V_M1_MF4_MASK, VSUXSEG5EI32_V, 0x6, 0x0 }, // 9425
  { PseudoVSUXSEG5EI32_V_MF2_MF4, VSUXSEG5EI32_V, 0x6, 0x0 }, // 9426
  { PseudoVSUXSEG5EI32_V_MF2_MF4_MASK, VSUXSEG5EI32_V, 0x6, 0x0 }, // 9427
  { PseudoVSUXSEG5EI32_V_M1_MF2, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9428
  { PseudoVSUXSEG5EI32_V_M1_MF2_MASK, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9429
  { PseudoVSUXSEG5EI32_V_M2_MF2, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9430
  { PseudoVSUXSEG5EI32_V_M2_MF2_MASK, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9431
  { PseudoVSUXSEG5EI32_V_MF2_MF2, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9432
  { PseudoVSUXSEG5EI32_V_MF2_MF2_MASK, VSUXSEG5EI32_V, 0x7, 0x0 }, // 9433
  { PseudoVSUXSEG5EI64_V_M1_M1, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9434
  { PseudoVSUXSEG5EI64_V_M1_M1_MASK, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9435
  { PseudoVSUXSEG5EI64_V_M2_M1, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9436
  { PseudoVSUXSEG5EI64_V_M2_M1_MASK, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9437
  { PseudoVSUXSEG5EI64_V_M4_M1, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9438
  { PseudoVSUXSEG5EI64_V_M4_M1_MASK, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9439
  { PseudoVSUXSEG5EI64_V_M8_M1, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9440
  { PseudoVSUXSEG5EI64_V_M8_M1_MASK, VSUXSEG5EI64_V, 0x0, 0x0 }, // 9441
  { PseudoVSUXSEG5EI64_V_M1_MF8, VSUXSEG5EI64_V, 0x5, 0x0 }, // 9442
  { PseudoVSUXSEG5EI64_V_M1_MF8_MASK, VSUXSEG5EI64_V, 0x5, 0x0 }, // 9443
  { PseudoVSUXSEG5EI64_V_M1_MF4, VSUXSEG5EI64_V, 0x6, 0x0 }, // 9444
  { PseudoVSUXSEG5EI64_V_M1_MF4_MASK, VSUXSEG5EI64_V, 0x6, 0x0 }, // 9445
  { PseudoVSUXSEG5EI64_V_M2_MF4, VSUXSEG5EI64_V, 0x6, 0x0 }, // 9446
  { PseudoVSUXSEG5EI64_V_M2_MF4_MASK, VSUXSEG5EI64_V, 0x6, 0x0 }, // 9447
  { PseudoVSUXSEG5EI64_V_M1_MF2, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9448
  { PseudoVSUXSEG5EI64_V_M1_MF2_MASK, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9449
  { PseudoVSUXSEG5EI64_V_M2_MF2, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9450
  { PseudoVSUXSEG5EI64_V_M2_MF2_MASK, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9451
  { PseudoVSUXSEG5EI64_V_M4_MF2, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9452
  { PseudoVSUXSEG5EI64_V_M4_MF2_MASK, VSUXSEG5EI64_V, 0x7, 0x0 }, // 9453
  { PseudoVSUXSEG5EI8_V_M1_M1, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9454
  { PseudoVSUXSEG5EI8_V_M1_M1_MASK, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9455
  { PseudoVSUXSEG5EI8_V_MF2_M1, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9456
  { PseudoVSUXSEG5EI8_V_MF2_M1_MASK, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9457
  { PseudoVSUXSEG5EI8_V_MF4_M1, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9458
  { PseudoVSUXSEG5EI8_V_MF4_M1_MASK, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9459
  { PseudoVSUXSEG5EI8_V_MF8_M1, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9460
  { PseudoVSUXSEG5EI8_V_MF8_M1_MASK, VSUXSEG5EI8_V, 0x0, 0x0 }, // 9461
  { PseudoVSUXSEG5EI8_V_MF8_MF8, VSUXSEG5EI8_V, 0x5, 0x0 }, // 9462
  { PseudoVSUXSEG5EI8_V_MF8_MF8_MASK, VSUXSEG5EI8_V, 0x5, 0x0 }, // 9463
  { PseudoVSUXSEG5EI8_V_MF4_MF4, VSUXSEG5EI8_V, 0x6, 0x0 }, // 9464
  { PseudoVSUXSEG5EI8_V_MF4_MF4_MASK, VSUXSEG5EI8_V, 0x6, 0x0 }, // 9465
  { PseudoVSUXSEG5EI8_V_MF8_MF4, VSUXSEG5EI8_V, 0x6, 0x0 }, // 9466
  { PseudoVSUXSEG5EI8_V_MF8_MF4_MASK, VSUXSEG5EI8_V, 0x6, 0x0 }, // 9467
  { PseudoVSUXSEG5EI8_V_MF2_MF2, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9468
  { PseudoVSUXSEG5EI8_V_MF2_MF2_MASK, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9469
  { PseudoVSUXSEG5EI8_V_MF4_MF2, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9470
  { PseudoVSUXSEG5EI8_V_MF4_MF2_MASK, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9471
  { PseudoVSUXSEG5EI8_V_MF8_MF2, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9472
  { PseudoVSUXSEG5EI8_V_MF8_MF2_MASK, VSUXSEG5EI8_V, 0x7, 0x0 }, // 9473
  { PseudoVSUXSEG6EI16_V_M1_M1, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9474
  { PseudoVSUXSEG6EI16_V_M1_M1_MASK, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9475
  { PseudoVSUXSEG6EI16_V_M2_M1, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9476
  { PseudoVSUXSEG6EI16_V_M2_M1_MASK, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9477
  { PseudoVSUXSEG6EI16_V_MF2_M1, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9478
  { PseudoVSUXSEG6EI16_V_MF2_M1_MASK, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9479
  { PseudoVSUXSEG6EI16_V_MF4_M1, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9480
  { PseudoVSUXSEG6EI16_V_MF4_M1_MASK, VSUXSEG6EI16_V, 0x0, 0x0 }, // 9481
  { PseudoVSUXSEG6EI16_V_MF4_MF8, VSUXSEG6EI16_V, 0x5, 0x0 }, // 9482
  { PseudoVSUXSEG6EI16_V_MF4_MF8_MASK, VSUXSEG6EI16_V, 0x5, 0x0 }, // 9483
  { PseudoVSUXSEG6EI16_V_MF2_MF4, VSUXSEG6EI16_V, 0x6, 0x0 }, // 9484
  { PseudoVSUXSEG6EI16_V_MF2_MF4_MASK, VSUXSEG6EI16_V, 0x6, 0x0 }, // 9485
  { PseudoVSUXSEG6EI16_V_MF4_MF4, VSUXSEG6EI16_V, 0x6, 0x0 }, // 9486
  { PseudoVSUXSEG6EI16_V_MF4_MF4_MASK, VSUXSEG6EI16_V, 0x6, 0x0 }, // 9487
  { PseudoVSUXSEG6EI16_V_M1_MF2, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9488
  { PseudoVSUXSEG6EI16_V_M1_MF2_MASK, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9489
  { PseudoVSUXSEG6EI16_V_MF2_MF2, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9490
  { PseudoVSUXSEG6EI16_V_MF2_MF2_MASK, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9491
  { PseudoVSUXSEG6EI16_V_MF4_MF2, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9492
  { PseudoVSUXSEG6EI16_V_MF4_MF2_MASK, VSUXSEG6EI16_V, 0x7, 0x0 }, // 9493
  { PseudoVSUXSEG6EI32_V_M1_M1, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9494
  { PseudoVSUXSEG6EI32_V_M1_M1_MASK, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9495
  { PseudoVSUXSEG6EI32_V_M2_M1, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9496
  { PseudoVSUXSEG6EI32_V_M2_M1_MASK, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9497
  { PseudoVSUXSEG6EI32_V_M4_M1, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9498
  { PseudoVSUXSEG6EI32_V_M4_M1_MASK, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9499
  { PseudoVSUXSEG6EI32_V_MF2_M1, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9500
  { PseudoVSUXSEG6EI32_V_MF2_M1_MASK, VSUXSEG6EI32_V, 0x0, 0x0 }, // 9501
  { PseudoVSUXSEG6EI32_V_MF2_MF8, VSUXSEG6EI32_V, 0x5, 0x0 }, // 9502
  { PseudoVSUXSEG6EI32_V_MF2_MF8_MASK, VSUXSEG6EI32_V, 0x5, 0x0 }, // 9503
  { PseudoVSUXSEG6EI32_V_M1_MF4, VSUXSEG6EI32_V, 0x6, 0x0 }, // 9504
  { PseudoVSUXSEG6EI32_V_M1_MF4_MASK, VSUXSEG6EI32_V, 0x6, 0x0 }, // 9505
  { PseudoVSUXSEG6EI32_V_MF2_MF4, VSUXSEG6EI32_V, 0x6, 0x0 }, // 9506
  { PseudoVSUXSEG6EI32_V_MF2_MF4_MASK, VSUXSEG6EI32_V, 0x6, 0x0 }, // 9507
  { PseudoVSUXSEG6EI32_V_M1_MF2, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9508
  { PseudoVSUXSEG6EI32_V_M1_MF2_MASK, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9509
  { PseudoVSUXSEG6EI32_V_M2_MF2, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9510
  { PseudoVSUXSEG6EI32_V_M2_MF2_MASK, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9511
  { PseudoVSUXSEG6EI32_V_MF2_MF2, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9512
  { PseudoVSUXSEG6EI32_V_MF2_MF2_MASK, VSUXSEG6EI32_V, 0x7, 0x0 }, // 9513
  { PseudoVSUXSEG6EI64_V_M1_M1, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9514
  { PseudoVSUXSEG6EI64_V_M1_M1_MASK, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9515
  { PseudoVSUXSEG6EI64_V_M2_M1, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9516
  { PseudoVSUXSEG6EI64_V_M2_M1_MASK, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9517
  { PseudoVSUXSEG6EI64_V_M4_M1, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9518
  { PseudoVSUXSEG6EI64_V_M4_M1_MASK, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9519
  { PseudoVSUXSEG6EI64_V_M8_M1, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9520
  { PseudoVSUXSEG6EI64_V_M8_M1_MASK, VSUXSEG6EI64_V, 0x0, 0x0 }, // 9521
  { PseudoVSUXSEG6EI64_V_M1_MF8, VSUXSEG6EI64_V, 0x5, 0x0 }, // 9522
  { PseudoVSUXSEG6EI64_V_M1_MF8_MASK, VSUXSEG6EI64_V, 0x5, 0x0 }, // 9523
  { PseudoVSUXSEG6EI64_V_M1_MF4, VSUXSEG6EI64_V, 0x6, 0x0 }, // 9524
  { PseudoVSUXSEG6EI64_V_M1_MF4_MASK, VSUXSEG6EI64_V, 0x6, 0x0 }, // 9525
  { PseudoVSUXSEG6EI64_V_M2_MF4, VSUXSEG6EI64_V, 0x6, 0x0 }, // 9526
  { PseudoVSUXSEG6EI64_V_M2_MF4_MASK, VSUXSEG6EI64_V, 0x6, 0x0 }, // 9527
  { PseudoVSUXSEG6EI64_V_M1_MF2, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9528
  { PseudoVSUXSEG6EI64_V_M1_MF2_MASK, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9529
  { PseudoVSUXSEG6EI64_V_M2_MF2, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9530
  { PseudoVSUXSEG6EI64_V_M2_MF2_MASK, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9531
  { PseudoVSUXSEG6EI64_V_M4_MF2, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9532
  { PseudoVSUXSEG6EI64_V_M4_MF2_MASK, VSUXSEG6EI64_V, 0x7, 0x0 }, // 9533
  { PseudoVSUXSEG6EI8_V_M1_M1, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9534
  { PseudoVSUXSEG6EI8_V_M1_M1_MASK, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9535
  { PseudoVSUXSEG6EI8_V_MF2_M1, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9536
  { PseudoVSUXSEG6EI8_V_MF2_M1_MASK, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9537
  { PseudoVSUXSEG6EI8_V_MF4_M1, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9538
  { PseudoVSUXSEG6EI8_V_MF4_M1_MASK, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9539
  { PseudoVSUXSEG6EI8_V_MF8_M1, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9540
  { PseudoVSUXSEG6EI8_V_MF8_M1_MASK, VSUXSEG6EI8_V, 0x0, 0x0 }, // 9541
  { PseudoVSUXSEG6EI8_V_MF8_MF8, VSUXSEG6EI8_V, 0x5, 0x0 }, // 9542
  { PseudoVSUXSEG6EI8_V_MF8_MF8_MASK, VSUXSEG6EI8_V, 0x5, 0x0 }, // 9543
  { PseudoVSUXSEG6EI8_V_MF4_MF4, VSUXSEG6EI8_V, 0x6, 0x0 }, // 9544
  { PseudoVSUXSEG6EI8_V_MF4_MF4_MASK, VSUXSEG6EI8_V, 0x6, 0x0 }, // 9545
  { PseudoVSUXSEG6EI8_V_MF8_MF4, VSUXSEG6EI8_V, 0x6, 0x0 }, // 9546
  { PseudoVSUXSEG6EI8_V_MF8_MF4_MASK, VSUXSEG6EI8_V, 0x6, 0x0 }, // 9547
  { PseudoVSUXSEG6EI8_V_MF2_MF2, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9548
  { PseudoVSUXSEG6EI8_V_MF2_MF2_MASK, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9549
  { PseudoVSUXSEG6EI8_V_MF4_MF2, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9550
  { PseudoVSUXSEG6EI8_V_MF4_MF2_MASK, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9551
  { PseudoVSUXSEG6EI8_V_MF8_MF2, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9552
  { PseudoVSUXSEG6EI8_V_MF8_MF2_MASK, VSUXSEG6EI8_V, 0x7, 0x0 }, // 9553
  { PseudoVSUXSEG7EI16_V_M1_M1, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9554
  { PseudoVSUXSEG7EI16_V_M1_M1_MASK, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9555
  { PseudoVSUXSEG7EI16_V_M2_M1, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9556
  { PseudoVSUXSEG7EI16_V_M2_M1_MASK, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9557
  { PseudoVSUXSEG7EI16_V_MF2_M1, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9558
  { PseudoVSUXSEG7EI16_V_MF2_M1_MASK, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9559
  { PseudoVSUXSEG7EI16_V_MF4_M1, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9560
  { PseudoVSUXSEG7EI16_V_MF4_M1_MASK, VSUXSEG7EI16_V, 0x0, 0x0 }, // 9561
  { PseudoVSUXSEG7EI16_V_MF4_MF8, VSUXSEG7EI16_V, 0x5, 0x0 }, // 9562
  { PseudoVSUXSEG7EI16_V_MF4_MF8_MASK, VSUXSEG7EI16_V, 0x5, 0x0 }, // 9563
  { PseudoVSUXSEG7EI16_V_MF2_MF4, VSUXSEG7EI16_V, 0x6, 0x0 }, // 9564
  { PseudoVSUXSEG7EI16_V_MF2_MF4_MASK, VSUXSEG7EI16_V, 0x6, 0x0 }, // 9565
  { PseudoVSUXSEG7EI16_V_MF4_MF4, VSUXSEG7EI16_V, 0x6, 0x0 }, // 9566
  { PseudoVSUXSEG7EI16_V_MF4_MF4_MASK, VSUXSEG7EI16_V, 0x6, 0x0 }, // 9567
  { PseudoVSUXSEG7EI16_V_M1_MF2, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9568
  { PseudoVSUXSEG7EI16_V_M1_MF2_MASK, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9569
  { PseudoVSUXSEG7EI16_V_MF2_MF2, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9570
  { PseudoVSUXSEG7EI16_V_MF2_MF2_MASK, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9571
  { PseudoVSUXSEG7EI16_V_MF4_MF2, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9572
  { PseudoVSUXSEG7EI16_V_MF4_MF2_MASK, VSUXSEG7EI16_V, 0x7, 0x0 }, // 9573
  { PseudoVSUXSEG7EI32_V_M1_M1, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9574
  { PseudoVSUXSEG7EI32_V_M1_M1_MASK, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9575
  { PseudoVSUXSEG7EI32_V_M2_M1, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9576
  { PseudoVSUXSEG7EI32_V_M2_M1_MASK, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9577
  { PseudoVSUXSEG7EI32_V_M4_M1, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9578
  { PseudoVSUXSEG7EI32_V_M4_M1_MASK, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9579
  { PseudoVSUXSEG7EI32_V_MF2_M1, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9580
  { PseudoVSUXSEG7EI32_V_MF2_M1_MASK, VSUXSEG7EI32_V, 0x0, 0x0 }, // 9581
  { PseudoVSUXSEG7EI32_V_MF2_MF8, VSUXSEG7EI32_V, 0x5, 0x0 }, // 9582
  { PseudoVSUXSEG7EI32_V_MF2_MF8_MASK, VSUXSEG7EI32_V, 0x5, 0x0 }, // 9583
  { PseudoVSUXSEG7EI32_V_M1_MF4, VSUXSEG7EI32_V, 0x6, 0x0 }, // 9584
  { PseudoVSUXSEG7EI32_V_M1_MF4_MASK, VSUXSEG7EI32_V, 0x6, 0x0 }, // 9585
  { PseudoVSUXSEG7EI32_V_MF2_MF4, VSUXSEG7EI32_V, 0x6, 0x0 }, // 9586
  { PseudoVSUXSEG7EI32_V_MF2_MF4_MASK, VSUXSEG7EI32_V, 0x6, 0x0 }, // 9587
  { PseudoVSUXSEG7EI32_V_M1_MF2, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9588
  { PseudoVSUXSEG7EI32_V_M1_MF2_MASK, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9589
  { PseudoVSUXSEG7EI32_V_M2_MF2, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9590
  { PseudoVSUXSEG7EI32_V_M2_MF2_MASK, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9591
  { PseudoVSUXSEG7EI32_V_MF2_MF2, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9592
  { PseudoVSUXSEG7EI32_V_MF2_MF2_MASK, VSUXSEG7EI32_V, 0x7, 0x0 }, // 9593
  { PseudoVSUXSEG7EI64_V_M1_M1, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9594
  { PseudoVSUXSEG7EI64_V_M1_M1_MASK, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9595
  { PseudoVSUXSEG7EI64_V_M2_M1, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9596
  { PseudoVSUXSEG7EI64_V_M2_M1_MASK, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9597
  { PseudoVSUXSEG7EI64_V_M4_M1, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9598
  { PseudoVSUXSEG7EI64_V_M4_M1_MASK, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9599
  { PseudoVSUXSEG7EI64_V_M8_M1, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9600
  { PseudoVSUXSEG7EI64_V_M8_M1_MASK, VSUXSEG7EI64_V, 0x0, 0x0 }, // 9601
  { PseudoVSUXSEG7EI64_V_M1_MF8, VSUXSEG7EI64_V, 0x5, 0x0 }, // 9602
  { PseudoVSUXSEG7EI64_V_M1_MF8_MASK, VSUXSEG7EI64_V, 0x5, 0x0 }, // 9603
  { PseudoVSUXSEG7EI64_V_M1_MF4, VSUXSEG7EI64_V, 0x6, 0x0 }, // 9604
  { PseudoVSUXSEG7EI64_V_M1_MF4_MASK, VSUXSEG7EI64_V, 0x6, 0x0 }, // 9605
  { PseudoVSUXSEG7EI64_V_M2_MF4, VSUXSEG7EI64_V, 0x6, 0x0 }, // 9606
  { PseudoVSUXSEG7EI64_V_M2_MF4_MASK, VSUXSEG7EI64_V, 0x6, 0x0 }, // 9607
  { PseudoVSUXSEG7EI64_V_M1_MF2, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9608
  { PseudoVSUXSEG7EI64_V_M1_MF2_MASK, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9609
  { PseudoVSUXSEG7EI64_V_M2_MF2, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9610
  { PseudoVSUXSEG7EI64_V_M2_MF2_MASK, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9611
  { PseudoVSUXSEG7EI64_V_M4_MF2, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9612
  { PseudoVSUXSEG7EI64_V_M4_MF2_MASK, VSUXSEG7EI64_V, 0x7, 0x0 }, // 9613
  { PseudoVSUXSEG7EI8_V_M1_M1, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9614
  { PseudoVSUXSEG7EI8_V_M1_M1_MASK, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9615
  { PseudoVSUXSEG7EI8_V_MF2_M1, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9616
  { PseudoVSUXSEG7EI8_V_MF2_M1_MASK, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9617
  { PseudoVSUXSEG7EI8_V_MF4_M1, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9618
  { PseudoVSUXSEG7EI8_V_MF4_M1_MASK, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9619
  { PseudoVSUXSEG7EI8_V_MF8_M1, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9620
  { PseudoVSUXSEG7EI8_V_MF8_M1_MASK, VSUXSEG7EI8_V, 0x0, 0x0 }, // 9621
  { PseudoVSUXSEG7EI8_V_MF8_MF8, VSUXSEG7EI8_V, 0x5, 0x0 }, // 9622
  { PseudoVSUXSEG7EI8_V_MF8_MF8_MASK, VSUXSEG7EI8_V, 0x5, 0x0 }, // 9623
  { PseudoVSUXSEG7EI8_V_MF4_MF4, VSUXSEG7EI8_V, 0x6, 0x0 }, // 9624
  { PseudoVSUXSEG7EI8_V_MF4_MF4_MASK, VSUXSEG7EI8_V, 0x6, 0x0 }, // 9625
  { PseudoVSUXSEG7EI8_V_MF8_MF4, VSUXSEG7EI8_V, 0x6, 0x0 }, // 9626
  { PseudoVSUXSEG7EI8_V_MF8_MF4_MASK, VSUXSEG7EI8_V, 0x6, 0x0 }, // 9627
  { PseudoVSUXSEG7EI8_V_MF2_MF2, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9628
  { PseudoVSUXSEG7EI8_V_MF2_MF2_MASK, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9629
  { PseudoVSUXSEG7EI8_V_MF4_MF2, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9630
  { PseudoVSUXSEG7EI8_V_MF4_MF2_MASK, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9631
  { PseudoVSUXSEG7EI8_V_MF8_MF2, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9632
  { PseudoVSUXSEG7EI8_V_MF8_MF2_MASK, VSUXSEG7EI8_V, 0x7, 0x0 }, // 9633
  { PseudoVSUXSEG8EI16_V_M1_M1, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9634
  { PseudoVSUXSEG8EI16_V_M1_M1_MASK, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9635
  { PseudoVSUXSEG8EI16_V_M2_M1, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9636
  { PseudoVSUXSEG8EI16_V_M2_M1_MASK, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9637
  { PseudoVSUXSEG8EI16_V_MF2_M1, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9638
  { PseudoVSUXSEG8EI16_V_MF2_M1_MASK, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9639
  { PseudoVSUXSEG8EI16_V_MF4_M1, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9640
  { PseudoVSUXSEG8EI16_V_MF4_M1_MASK, VSUXSEG8EI16_V, 0x0, 0x0 }, // 9641
  { PseudoVSUXSEG8EI16_V_MF4_MF8, VSUXSEG8EI16_V, 0x5, 0x0 }, // 9642
  { PseudoVSUXSEG8EI16_V_MF4_MF8_MASK, VSUXSEG8EI16_V, 0x5, 0x0 }, // 9643
  { PseudoVSUXSEG8EI16_V_MF2_MF4, VSUXSEG8EI16_V, 0x6, 0x0 }, // 9644
  { PseudoVSUXSEG8EI16_V_MF2_MF4_MASK, VSUXSEG8EI16_V, 0x6, 0x0 }, // 9645
  { PseudoVSUXSEG8EI16_V_MF4_MF4, VSUXSEG8EI16_V, 0x6, 0x0 }, // 9646
  { PseudoVSUXSEG8EI16_V_MF4_MF4_MASK, VSUXSEG8EI16_V, 0x6, 0x0 }, // 9647
  { PseudoVSUXSEG8EI16_V_M1_MF2, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9648
  { PseudoVSUXSEG8EI16_V_M1_MF2_MASK, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9649
  { PseudoVSUXSEG8EI16_V_MF2_MF2, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9650
  { PseudoVSUXSEG8EI16_V_MF2_MF2_MASK, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9651
  { PseudoVSUXSEG8EI16_V_MF4_MF2, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9652
  { PseudoVSUXSEG8EI16_V_MF4_MF2_MASK, VSUXSEG8EI16_V, 0x7, 0x0 }, // 9653
  { PseudoVSUXSEG8EI32_V_M1_M1, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9654
  { PseudoVSUXSEG8EI32_V_M1_M1_MASK, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9655
  { PseudoVSUXSEG8EI32_V_M2_M1, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9656
  { PseudoVSUXSEG8EI32_V_M2_M1_MASK, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9657
  { PseudoVSUXSEG8EI32_V_M4_M1, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9658
  { PseudoVSUXSEG8EI32_V_M4_M1_MASK, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9659
  { PseudoVSUXSEG8EI32_V_MF2_M1, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9660
  { PseudoVSUXSEG8EI32_V_MF2_M1_MASK, VSUXSEG8EI32_V, 0x0, 0x0 }, // 9661
  { PseudoVSUXSEG8EI32_V_MF2_MF8, VSUXSEG8EI32_V, 0x5, 0x0 }, // 9662
  { PseudoVSUXSEG8EI32_V_MF2_MF8_MASK, VSUXSEG8EI32_V, 0x5, 0x0 }, // 9663
  { PseudoVSUXSEG8EI32_V_M1_MF4, VSUXSEG8EI32_V, 0x6, 0x0 }, // 9664
  { PseudoVSUXSEG8EI32_V_M1_MF4_MASK, VSUXSEG8EI32_V, 0x6, 0x0 }, // 9665
  { PseudoVSUXSEG8EI32_V_MF2_MF4, VSUXSEG8EI32_V, 0x6, 0x0 }, // 9666
  { PseudoVSUXSEG8EI32_V_MF2_MF4_MASK, VSUXSEG8EI32_V, 0x6, 0x0 }, // 9667
  { PseudoVSUXSEG8EI32_V_M1_MF2, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9668
  { PseudoVSUXSEG8EI32_V_M1_MF2_MASK, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9669
  { PseudoVSUXSEG8EI32_V_M2_MF2, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9670
  { PseudoVSUXSEG8EI32_V_M2_MF2_MASK, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9671
  { PseudoVSUXSEG8EI32_V_MF2_MF2, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9672
  { PseudoVSUXSEG8EI32_V_MF2_MF2_MASK, VSUXSEG8EI32_V, 0x7, 0x0 }, // 9673
  { PseudoVSUXSEG8EI64_V_M1_M1, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9674
  { PseudoVSUXSEG8EI64_V_M1_M1_MASK, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9675
  { PseudoVSUXSEG8EI64_V_M2_M1, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9676
  { PseudoVSUXSEG8EI64_V_M2_M1_MASK, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9677
  { PseudoVSUXSEG8EI64_V_M4_M1, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9678
  { PseudoVSUXSEG8EI64_V_M4_M1_MASK, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9679
  { PseudoVSUXSEG8EI64_V_M8_M1, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9680
  { PseudoVSUXSEG8EI64_V_M8_M1_MASK, VSUXSEG8EI64_V, 0x0, 0x0 }, // 9681
  { PseudoVSUXSEG8EI64_V_M1_MF8, VSUXSEG8EI64_V, 0x5, 0x0 }, // 9682
  { PseudoVSUXSEG8EI64_V_M1_MF8_MASK, VSUXSEG8EI64_V, 0x5, 0x0 }, // 9683
  { PseudoVSUXSEG8EI64_V_M1_MF4, VSUXSEG8EI64_V, 0x6, 0x0 }, // 9684
  { PseudoVSUXSEG8EI64_V_M1_MF4_MASK, VSUXSEG8EI64_V, 0x6, 0x0 }, // 9685
  { PseudoVSUXSEG8EI64_V_M2_MF4, VSUXSEG8EI64_V, 0x6, 0x0 }, // 9686
  { PseudoVSUXSEG8EI64_V_M2_MF4_MASK, VSUXSEG8EI64_V, 0x6, 0x0 }, // 9687
  { PseudoVSUXSEG8EI64_V_M1_MF2, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9688
  { PseudoVSUXSEG8EI64_V_M1_MF2_MASK, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9689
  { PseudoVSUXSEG8EI64_V_M2_MF2, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9690
  { PseudoVSUXSEG8EI64_V_M2_MF2_MASK, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9691
  { PseudoVSUXSEG8EI64_V_M4_MF2, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9692
  { PseudoVSUXSEG8EI64_V_M4_MF2_MASK, VSUXSEG8EI64_V, 0x7, 0x0 }, // 9693
  { PseudoVSUXSEG8EI8_V_M1_M1, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9694
  { PseudoVSUXSEG8EI8_V_M1_M1_MASK, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9695
  { PseudoVSUXSEG8EI8_V_MF2_M1, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9696
  { PseudoVSUXSEG8EI8_V_MF2_M1_MASK, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9697
  { PseudoVSUXSEG8EI8_V_MF4_M1, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9698
  { PseudoVSUXSEG8EI8_V_MF4_M1_MASK, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9699
  { PseudoVSUXSEG8EI8_V_MF8_M1, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9700
  { PseudoVSUXSEG8EI8_V_MF8_M1_MASK, VSUXSEG8EI8_V, 0x0, 0x0 }, // 9701
  { PseudoVSUXSEG8EI8_V_MF8_MF8, VSUXSEG8EI8_V, 0x5, 0x0 }, // 9702
  { PseudoVSUXSEG8EI8_V_MF8_MF8_MASK, VSUXSEG8EI8_V, 0x5, 0x0 }, // 9703
  { PseudoVSUXSEG8EI8_V_MF4_MF4, VSUXSEG8EI8_V, 0x6, 0x0 }, // 9704
  { PseudoVSUXSEG8EI8_V_MF4_MF4_MASK, VSUXSEG8EI8_V, 0x6, 0x0 }, // 9705
  { PseudoVSUXSEG8EI8_V_MF8_MF4, VSUXSEG8EI8_V, 0x6, 0x0 }, // 9706
  { PseudoVSUXSEG8EI8_V_MF8_MF4_MASK, VSUXSEG8EI8_V, 0x6, 0x0 }, // 9707
  { PseudoVSUXSEG8EI8_V_MF2_MF2, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9708
  { PseudoVSUXSEG8EI8_V_MF2_MF2_MASK, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9709
  { PseudoVSUXSEG8EI8_V_MF4_MF2, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9710
  { PseudoVSUXSEG8EI8_V_MF4_MF2_MASK, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9711
  { PseudoVSUXSEG8EI8_V_MF8_MF2, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9712
  { PseudoVSUXSEG8EI8_V_MF8_MF2_MASK, VSUXSEG8EI8_V, 0x7, 0x0 }, // 9713
  { PseudoVWADDU_VV_M1, VWADDU_VV, 0x0, 0x0 }, // 9714
  { PseudoVWADDU_VV_M1_MASK, VWADDU_VV, 0x0, 0x0 }, // 9715
  { PseudoVWADDU_VV_M2, VWADDU_VV, 0x1, 0x0 }, // 9716
  { PseudoVWADDU_VV_M2_MASK, VWADDU_VV, 0x1, 0x0 }, // 9717
  { PseudoVWADDU_VV_M4, VWADDU_VV, 0x2, 0x0 }, // 9718
  { PseudoVWADDU_VV_M4_MASK, VWADDU_VV, 0x2, 0x0 }, // 9719
  { PseudoVWADDU_VV_MF8, VWADDU_VV, 0x5, 0x0 }, // 9720
  { PseudoVWADDU_VV_MF8_MASK, VWADDU_VV, 0x5, 0x0 }, // 9721
  { PseudoVWADDU_VV_MF4, VWADDU_VV, 0x6, 0x0 }, // 9722
  { PseudoVWADDU_VV_MF4_MASK, VWADDU_VV, 0x6, 0x0 }, // 9723
  { PseudoVWADDU_VV_MF2, VWADDU_VV, 0x7, 0x0 }, // 9724
  { PseudoVWADDU_VV_MF2_MASK, VWADDU_VV, 0x7, 0x0 }, // 9725
  { PseudoVWADDU_VX_M1, VWADDU_VX, 0x0, 0x0 }, // 9726
  { PseudoVWADDU_VX_M1_MASK, VWADDU_VX, 0x0, 0x0 }, // 9727
  { PseudoVWADDU_VX_M2, VWADDU_VX, 0x1, 0x0 }, // 9728
  { PseudoVWADDU_VX_M2_MASK, VWADDU_VX, 0x1, 0x0 }, // 9729
  { PseudoVWADDU_VX_M4, VWADDU_VX, 0x2, 0x0 }, // 9730
  { PseudoVWADDU_VX_M4_MASK, VWADDU_VX, 0x2, 0x0 }, // 9731
  { PseudoVWADDU_VX_MF8, VWADDU_VX, 0x5, 0x0 }, // 9732
  { PseudoVWADDU_VX_MF8_MASK, VWADDU_VX, 0x5, 0x0 }, // 9733
  { PseudoVWADDU_VX_MF4, VWADDU_VX, 0x6, 0x0 }, // 9734
  { PseudoVWADDU_VX_MF4_MASK, VWADDU_VX, 0x6, 0x0 }, // 9735
  { PseudoVWADDU_VX_MF2, VWADDU_VX, 0x7, 0x0 }, // 9736
  { PseudoVWADDU_VX_MF2_MASK, VWADDU_VX, 0x7, 0x0 }, // 9737
  { PseudoVWADDU_WV_M1, VWADDU_WV, 0x0, 0x0 }, // 9738
  { PseudoVWADDU_WV_M1_MASK, VWADDU_WV, 0x0, 0x0 }, // 9739
  { PseudoVWADDU_WV_M1_MASK_TIED, VWADDU_WV, 0x0, 0x0 }, // 9740
  { PseudoVWADDU_WV_M1_TIED, VWADDU_WV, 0x0, 0x0 }, // 9741
  { PseudoVWADDU_WV_M2, VWADDU_WV, 0x1, 0x0 }, // 9742
  { PseudoVWADDU_WV_M2_MASK, VWADDU_WV, 0x1, 0x0 }, // 9743
  { PseudoVWADDU_WV_M2_MASK_TIED, VWADDU_WV, 0x1, 0x0 }, // 9744
  { PseudoVWADDU_WV_M2_TIED, VWADDU_WV, 0x1, 0x0 }, // 9745
  { PseudoVWADDU_WV_M4, VWADDU_WV, 0x2, 0x0 }, // 9746
  { PseudoVWADDU_WV_M4_MASK, VWADDU_WV, 0x2, 0x0 }, // 9747
  { PseudoVWADDU_WV_M4_MASK_TIED, VWADDU_WV, 0x2, 0x0 }, // 9748
  { PseudoVWADDU_WV_M4_TIED, VWADDU_WV, 0x2, 0x0 }, // 9749
  { PseudoVWADDU_WV_MF8, VWADDU_WV, 0x5, 0x0 }, // 9750
  { PseudoVWADDU_WV_MF8_MASK, VWADDU_WV, 0x5, 0x0 }, // 9751
  { PseudoVWADDU_WV_MF8_MASK_TIED, VWADDU_WV, 0x5, 0x0 }, // 9752
  { PseudoVWADDU_WV_MF8_TIED, VWADDU_WV, 0x5, 0x0 }, // 9753
  { PseudoVWADDU_WV_MF4, VWADDU_WV, 0x6, 0x0 }, // 9754
  { PseudoVWADDU_WV_MF4_MASK, VWADDU_WV, 0x6, 0x0 }, // 9755
  { PseudoVWADDU_WV_MF4_MASK_TIED, VWADDU_WV, 0x6, 0x0 }, // 9756
  { PseudoVWADDU_WV_MF4_TIED, VWADDU_WV, 0x6, 0x0 }, // 9757
  { PseudoVWADDU_WV_MF2, VWADDU_WV, 0x7, 0x0 }, // 9758
  { PseudoVWADDU_WV_MF2_MASK, VWADDU_WV, 0x7, 0x0 }, // 9759
  { PseudoVWADDU_WV_MF2_MASK_TIED, VWADDU_WV, 0x7, 0x0 }, // 9760
  { PseudoVWADDU_WV_MF2_TIED, VWADDU_WV, 0x7, 0x0 }, // 9761
  { PseudoVWADDU_WX_M1, VWADDU_WX, 0x0, 0x0 }, // 9762
  { PseudoVWADDU_WX_M1_MASK, VWADDU_WX, 0x0, 0x0 }, // 9763
  { PseudoVWADDU_WX_M2, VWADDU_WX, 0x1, 0x0 }, // 9764
  { PseudoVWADDU_WX_M2_MASK, VWADDU_WX, 0x1, 0x0 }, // 9765
  { PseudoVWADDU_WX_M4, VWADDU_WX, 0x2, 0x0 }, // 9766
  { PseudoVWADDU_WX_M4_MASK, VWADDU_WX, 0x2, 0x0 }, // 9767
  { PseudoVWADDU_WX_MF8, VWADDU_WX, 0x5, 0x0 }, // 9768
  { PseudoVWADDU_WX_MF8_MASK, VWADDU_WX, 0x5, 0x0 }, // 9769
  { PseudoVWADDU_WX_MF4, VWADDU_WX, 0x6, 0x0 }, // 9770
  { PseudoVWADDU_WX_MF4_MASK, VWADDU_WX, 0x6, 0x0 }, // 9771
  { PseudoVWADDU_WX_MF2, VWADDU_WX, 0x7, 0x0 }, // 9772
  { PseudoVWADDU_WX_MF2_MASK, VWADDU_WX, 0x7, 0x0 }, // 9773
  { PseudoVWADD_VV_M1, VWADD_VV, 0x0, 0x0 }, // 9774
  { PseudoVWADD_VV_M1_MASK, VWADD_VV, 0x0, 0x0 }, // 9775
  { PseudoVWADD_VV_M2, VWADD_VV, 0x1, 0x0 }, // 9776
  { PseudoVWADD_VV_M2_MASK, VWADD_VV, 0x1, 0x0 }, // 9777
  { PseudoVWADD_VV_M4, VWADD_VV, 0x2, 0x0 }, // 9778
  { PseudoVWADD_VV_M4_MASK, VWADD_VV, 0x2, 0x0 }, // 9779
  { PseudoVWADD_VV_MF8, VWADD_VV, 0x5, 0x0 }, // 9780
  { PseudoVWADD_VV_MF8_MASK, VWADD_VV, 0x5, 0x0 }, // 9781
  { PseudoVWADD_VV_MF4, VWADD_VV, 0x6, 0x0 }, // 9782
  { PseudoVWADD_VV_MF4_MASK, VWADD_VV, 0x6, 0x0 }, // 9783
  { PseudoVWADD_VV_MF2, VWADD_VV, 0x7, 0x0 }, // 9784
  { PseudoVWADD_VV_MF2_MASK, VWADD_VV, 0x7, 0x0 }, // 9785
  { PseudoVWADD_VX_M1, VWADD_VX, 0x0, 0x0 }, // 9786
  { PseudoVWADD_VX_M1_MASK, VWADD_VX, 0x0, 0x0 }, // 9787
  { PseudoVWADD_VX_M2, VWADD_VX, 0x1, 0x0 }, // 9788
  { PseudoVWADD_VX_M2_MASK, VWADD_VX, 0x1, 0x0 }, // 9789
  { PseudoVWADD_VX_M4, VWADD_VX, 0x2, 0x0 }, // 9790
  { PseudoVWADD_VX_M4_MASK, VWADD_VX, 0x2, 0x0 }, // 9791
  { PseudoVWADD_VX_MF8, VWADD_VX, 0x5, 0x0 }, // 9792
  { PseudoVWADD_VX_MF8_MASK, VWADD_VX, 0x5, 0x0 }, // 9793
  { PseudoVWADD_VX_MF4, VWADD_VX, 0x6, 0x0 }, // 9794
  { PseudoVWADD_VX_MF4_MASK, VWADD_VX, 0x6, 0x0 }, // 9795
  { PseudoVWADD_VX_MF2, VWADD_VX, 0x7, 0x0 }, // 9796
  { PseudoVWADD_VX_MF2_MASK, VWADD_VX, 0x7, 0x0 }, // 9797
  { PseudoVWADD_WV_M1, VWADD_WV, 0x0, 0x0 }, // 9798
  { PseudoVWADD_WV_M1_MASK, VWADD_WV, 0x0, 0x0 }, // 9799
  { PseudoVWADD_WV_M1_MASK_TIED, VWADD_WV, 0x0, 0x0 }, // 9800
  { PseudoVWADD_WV_M1_TIED, VWADD_WV, 0x0, 0x0 }, // 9801
  { PseudoVWADD_WV_M2, VWADD_WV, 0x1, 0x0 }, // 9802
  { PseudoVWADD_WV_M2_MASK, VWADD_WV, 0x1, 0x0 }, // 9803
  { PseudoVWADD_WV_M2_MASK_TIED, VWADD_WV, 0x1, 0x0 }, // 9804
  { PseudoVWADD_WV_M2_TIED, VWADD_WV, 0x1, 0x0 }, // 9805
  { PseudoVWADD_WV_M4, VWADD_WV, 0x2, 0x0 }, // 9806
  { PseudoVWADD_WV_M4_MASK, VWADD_WV, 0x2, 0x0 }, // 9807
  { PseudoVWADD_WV_M4_MASK_TIED, VWADD_WV, 0x2, 0x0 }, // 9808
  { PseudoVWADD_WV_M4_TIED, VWADD_WV, 0x2, 0x0 }, // 9809
  { PseudoVWADD_WV_MF8, VWADD_WV, 0x5, 0x0 }, // 9810
  { PseudoVWADD_WV_MF8_MASK, VWADD_WV, 0x5, 0x0 }, // 9811
  { PseudoVWADD_WV_MF8_MASK_TIED, VWADD_WV, 0x5, 0x0 }, // 9812
  { PseudoVWADD_WV_MF8_TIED, VWADD_WV, 0x5, 0x0 }, // 9813
  { PseudoVWADD_WV_MF4, VWADD_WV, 0x6, 0x0 }, // 9814
  { PseudoVWADD_WV_MF4_MASK, VWADD_WV, 0x6, 0x0 }, // 9815
  { PseudoVWADD_WV_MF4_MASK_TIED, VWADD_WV, 0x6, 0x0 }, // 9816
  { PseudoVWADD_WV_MF4_TIED, VWADD_WV, 0x6, 0x0 }, // 9817
  { PseudoVWADD_WV_MF2, VWADD_WV, 0x7, 0x0 }, // 9818
  { PseudoVWADD_WV_MF2_MASK, VWADD_WV, 0x7, 0x0 }, // 9819
  { PseudoVWADD_WV_MF2_MASK_TIED, VWADD_WV, 0x7, 0x0 }, // 9820
  { PseudoVWADD_WV_MF2_TIED, VWADD_WV, 0x7, 0x0 }, // 9821
  { PseudoVWADD_WX_M1, VWADD_WX, 0x0, 0x0 }, // 9822
  { PseudoVWADD_WX_M1_MASK, VWADD_WX, 0x0, 0x0 }, // 9823
  { PseudoVWADD_WX_M2, VWADD_WX, 0x1, 0x0 }, // 9824
  { PseudoVWADD_WX_M2_MASK, VWADD_WX, 0x1, 0x0 }, // 9825
  { PseudoVWADD_WX_M4, VWADD_WX, 0x2, 0x0 }, // 9826
  { PseudoVWADD_WX_M4_MASK, VWADD_WX, 0x2, 0x0 }, // 9827
  { PseudoVWADD_WX_MF8, VWADD_WX, 0x5, 0x0 }, // 9828
  { PseudoVWADD_WX_MF8_MASK, VWADD_WX, 0x5, 0x0 }, // 9829
  { PseudoVWADD_WX_MF4, VWADD_WX, 0x6, 0x0 }, // 9830
  { PseudoVWADD_WX_MF4_MASK, VWADD_WX, 0x6, 0x0 }, // 9831
  { PseudoVWADD_WX_MF2, VWADD_WX, 0x7, 0x0 }, // 9832
  { PseudoVWADD_WX_MF2_MASK, VWADD_WX, 0x7, 0x0 }, // 9833
  { PseudoVWMACCSU_VV_M1, VWMACCSU_VV, 0x0, 0x0 }, // 9834
  { PseudoVWMACCSU_VV_M1_MASK, VWMACCSU_VV, 0x0, 0x0 }, // 9835
  { PseudoVWMACCSU_VV_M2, VWMACCSU_VV, 0x1, 0x0 }, // 9836
  { PseudoVWMACCSU_VV_M2_MASK, VWMACCSU_VV, 0x1, 0x0 }, // 9837
  { PseudoVWMACCSU_VV_M4, VWMACCSU_VV, 0x2, 0x0 }, // 9838
  { PseudoVWMACCSU_VV_M4_MASK, VWMACCSU_VV, 0x2, 0x0 }, // 9839
  { PseudoVWMACCSU_VV_MF8, VWMACCSU_VV, 0x5, 0x0 }, // 9840
  { PseudoVWMACCSU_VV_MF8_MASK, VWMACCSU_VV, 0x5, 0x0 }, // 9841
  { PseudoVWMACCSU_VV_MF4, VWMACCSU_VV, 0x6, 0x0 }, // 9842
  { PseudoVWMACCSU_VV_MF4_MASK, VWMACCSU_VV, 0x6, 0x0 }, // 9843
  { PseudoVWMACCSU_VV_MF2, VWMACCSU_VV, 0x7, 0x0 }, // 9844
  { PseudoVWMACCSU_VV_MF2_MASK, VWMACCSU_VV, 0x7, 0x0 }, // 9845
  { PseudoVWMACCSU_VX_M1, VWMACCSU_VX, 0x0, 0x0 }, // 9846
  { PseudoVWMACCSU_VX_M1_MASK, VWMACCSU_VX, 0x0, 0x0 }, // 9847
  { PseudoVWMACCSU_VX_M2, VWMACCSU_VX, 0x1, 0x0 }, // 9848
  { PseudoVWMACCSU_VX_M2_MASK, VWMACCSU_VX, 0x1, 0x0 }, // 9849
  { PseudoVWMACCSU_VX_M4, VWMACCSU_VX, 0x2, 0x0 }, // 9850
  { PseudoVWMACCSU_VX_M4_MASK, VWMACCSU_VX, 0x2, 0x0 }, // 9851
  { PseudoVWMACCSU_VX_MF8, VWMACCSU_VX, 0x5, 0x0 }, // 9852
  { PseudoVWMACCSU_VX_MF8_MASK, VWMACCSU_VX, 0x5, 0x0 }, // 9853
  { PseudoVWMACCSU_VX_MF4, VWMACCSU_VX, 0x6, 0x0 }, // 9854
  { PseudoVWMACCSU_VX_MF4_MASK, VWMACCSU_VX, 0x6, 0x0 }, // 9855
  { PseudoVWMACCSU_VX_MF2, VWMACCSU_VX, 0x7, 0x0 }, // 9856
  { PseudoVWMACCSU_VX_MF2_MASK, VWMACCSU_VX, 0x7, 0x0 }, // 9857
  { PseudoVWMACCUS_VX_M1, VWMACCUS_VX, 0x0, 0x0 }, // 9858
  { PseudoVWMACCUS_VX_M1_MASK, VWMACCUS_VX, 0x0, 0x0 }, // 9859
  { PseudoVWMACCUS_VX_M2, VWMACCUS_VX, 0x1, 0x0 }, // 9860
  { PseudoVWMACCUS_VX_M2_MASK, VWMACCUS_VX, 0x1, 0x0 }, // 9861
  { PseudoVWMACCUS_VX_M4, VWMACCUS_VX, 0x2, 0x0 }, // 9862
  { PseudoVWMACCUS_VX_M4_MASK, VWMACCUS_VX, 0x2, 0x0 }, // 9863
  { PseudoVWMACCUS_VX_MF8, VWMACCUS_VX, 0x5, 0x0 }, // 9864
  { PseudoVWMACCUS_VX_MF8_MASK, VWMACCUS_VX, 0x5, 0x0 }, // 9865
  { PseudoVWMACCUS_VX_MF4, VWMACCUS_VX, 0x6, 0x0 }, // 9866
  { PseudoVWMACCUS_VX_MF4_MASK, VWMACCUS_VX, 0x6, 0x0 }, // 9867
  { PseudoVWMACCUS_VX_MF2, VWMACCUS_VX, 0x7, 0x0 }, // 9868
  { PseudoVWMACCUS_VX_MF2_MASK, VWMACCUS_VX, 0x7, 0x0 }, // 9869
  { PseudoVWMACCU_VV_M1, VWMACCU_VV, 0x0, 0x0 }, // 9870
  { PseudoVWMACCU_VV_M1_MASK, VWMACCU_VV, 0x0, 0x0 }, // 9871
  { PseudoVWMACCU_VV_M2, VWMACCU_VV, 0x1, 0x0 }, // 9872
  { PseudoVWMACCU_VV_M2_MASK, VWMACCU_VV, 0x1, 0x0 }, // 9873
  { PseudoVWMACCU_VV_M4, VWMACCU_VV, 0x2, 0x0 }, // 9874
  { PseudoVWMACCU_VV_M4_MASK, VWMACCU_VV, 0x2, 0x0 }, // 9875
  { PseudoVWMACCU_VV_MF8, VWMACCU_VV, 0x5, 0x0 }, // 9876
  { PseudoVWMACCU_VV_MF8_MASK, VWMACCU_VV, 0x5, 0x0 }, // 9877
  { PseudoVWMACCU_VV_MF4, VWMACCU_VV, 0x6, 0x0 }, // 9878
  { PseudoVWMACCU_VV_MF4_MASK, VWMACCU_VV, 0x6, 0x0 }, // 9879
  { PseudoVWMACCU_VV_MF2, VWMACCU_VV, 0x7, 0x0 }, // 9880
  { PseudoVWMACCU_VV_MF2_MASK, VWMACCU_VV, 0x7, 0x0 }, // 9881
  { PseudoVWMACCU_VX_M1, VWMACCU_VX, 0x0, 0x0 }, // 9882
  { PseudoVWMACCU_VX_M1_MASK, VWMACCU_VX, 0x0, 0x0 }, // 9883
  { PseudoVWMACCU_VX_M2, VWMACCU_VX, 0x1, 0x0 }, // 9884
  { PseudoVWMACCU_VX_M2_MASK, VWMACCU_VX, 0x1, 0x0 }, // 9885
  { PseudoVWMACCU_VX_M4, VWMACCU_VX, 0x2, 0x0 }, // 9886
  { PseudoVWMACCU_VX_M4_MASK, VWMACCU_VX, 0x2, 0x0 }, // 9887
  { PseudoVWMACCU_VX_MF8, VWMACCU_VX, 0x5, 0x0 }, // 9888
  { PseudoVWMACCU_VX_MF8_MASK, VWMACCU_VX, 0x5, 0x0 }, // 9889
  { PseudoVWMACCU_VX_MF4, VWMACCU_VX, 0x6, 0x0 }, // 9890
  { PseudoVWMACCU_VX_MF4_MASK, VWMACCU_VX, 0x6, 0x0 }, // 9891
  { PseudoVWMACCU_VX_MF2, VWMACCU_VX, 0x7, 0x0 }, // 9892
  { PseudoVWMACCU_VX_MF2_MASK, VWMACCU_VX, 0x7, 0x0 }, // 9893
  { PseudoVWMACC_VV_M1, VWMACC_VV, 0x0, 0x0 }, // 9894
  { PseudoVWMACC_VV_M1_MASK, VWMACC_VV, 0x0, 0x0 }, // 9895
  { PseudoVWMACC_VV_M2, VWMACC_VV, 0x1, 0x0 }, // 9896
  { PseudoVWMACC_VV_M2_MASK, VWMACC_VV, 0x1, 0x0 }, // 9897
  { PseudoVWMACC_VV_M4, VWMACC_VV, 0x2, 0x0 }, // 9898
  { PseudoVWMACC_VV_M4_MASK, VWMACC_VV, 0x2, 0x0 }, // 9899
  { PseudoVWMACC_VV_MF8, VWMACC_VV, 0x5, 0x0 }, // 9900
  { PseudoVWMACC_VV_MF8_MASK, VWMACC_VV, 0x5, 0x0 }, // 9901
  { PseudoVWMACC_VV_MF4, VWMACC_VV, 0x6, 0x0 }, // 9902
  { PseudoVWMACC_VV_MF4_MASK, VWMACC_VV, 0x6, 0x0 }, // 9903
  { PseudoVWMACC_VV_MF2, VWMACC_VV, 0x7, 0x0 }, // 9904
  { PseudoVWMACC_VV_MF2_MASK, VWMACC_VV, 0x7, 0x0 }, // 9905
  { PseudoVWMACC_VX_M1, VWMACC_VX, 0x0, 0x0 }, // 9906
  { PseudoVWMACC_VX_M1_MASK, VWMACC_VX, 0x0, 0x0 }, // 9907
  { PseudoVWMACC_VX_M2, VWMACC_VX, 0x1, 0x0 }, // 9908
  { PseudoVWMACC_VX_M2_MASK, VWMACC_VX, 0x1, 0x0 }, // 9909
  { PseudoVWMACC_VX_M4, VWMACC_VX, 0x2, 0x0 }, // 9910
  { PseudoVWMACC_VX_M4_MASK, VWMACC_VX, 0x2, 0x0 }, // 9911
  { PseudoVWMACC_VX_MF8, VWMACC_VX, 0x5, 0x0 }, // 9912
  { PseudoVWMACC_VX_MF8_MASK, VWMACC_VX, 0x5, 0x0 }, // 9913
  { PseudoVWMACC_VX_MF4, VWMACC_VX, 0x6, 0x0 }, // 9914
  { PseudoVWMACC_VX_MF4_MASK, VWMACC_VX, 0x6, 0x0 }, // 9915
  { PseudoVWMACC_VX_MF2, VWMACC_VX, 0x7, 0x0 }, // 9916
  { PseudoVWMACC_VX_MF2_MASK, VWMACC_VX, 0x7, 0x0 }, // 9917
  { PseudoVWMULSU_VV_M1, VWMULSU_VV, 0x0, 0x0 }, // 9918
  { PseudoVWMULSU_VV_M1_MASK, VWMULSU_VV, 0x0, 0x0 }, // 9919
  { PseudoVWMULSU_VV_M2, VWMULSU_VV, 0x1, 0x0 }, // 9920
  { PseudoVWMULSU_VV_M2_MASK, VWMULSU_VV, 0x1, 0x0 }, // 9921
  { PseudoVWMULSU_VV_M4, VWMULSU_VV, 0x2, 0x0 }, // 9922
  { PseudoVWMULSU_VV_M4_MASK, VWMULSU_VV, 0x2, 0x0 }, // 9923
  { PseudoVWMULSU_VV_MF8, VWMULSU_VV, 0x5, 0x0 }, // 9924
  { PseudoVWMULSU_VV_MF8_MASK, VWMULSU_VV, 0x5, 0x0 }, // 9925
  { PseudoVWMULSU_VV_MF4, VWMULSU_VV, 0x6, 0x0 }, // 9926
  { PseudoVWMULSU_VV_MF4_MASK, VWMULSU_VV, 0x6, 0x0 }, // 9927
  { PseudoVWMULSU_VV_MF2, VWMULSU_VV, 0x7, 0x0 }, // 9928
  { PseudoVWMULSU_VV_MF2_MASK, VWMULSU_VV, 0x7, 0x0 }, // 9929
  { PseudoVWMULSU_VX_M1, VWMULSU_VX, 0x0, 0x0 }, // 9930
  { PseudoVWMULSU_VX_M1_MASK, VWMULSU_VX, 0x0, 0x0 }, // 9931
  { PseudoVWMULSU_VX_M2, VWMULSU_VX, 0x1, 0x0 }, // 9932
  { PseudoVWMULSU_VX_M2_MASK, VWMULSU_VX, 0x1, 0x0 }, // 9933
  { PseudoVWMULSU_VX_M4, VWMULSU_VX, 0x2, 0x0 }, // 9934
  { PseudoVWMULSU_VX_M4_MASK, VWMULSU_VX, 0x2, 0x0 }, // 9935
  { PseudoVWMULSU_VX_MF8, VWMULSU_VX, 0x5, 0x0 }, // 9936
  { PseudoVWMULSU_VX_MF8_MASK, VWMULSU_VX, 0x5, 0x0 }, // 9937
  { PseudoVWMULSU_VX_MF4, VWMULSU_VX, 0x6, 0x0 }, // 9938
  { PseudoVWMULSU_VX_MF4_MASK, VWMULSU_VX, 0x6, 0x0 }, // 9939
  { PseudoVWMULSU_VX_MF2, VWMULSU_VX, 0x7, 0x0 }, // 9940
  { PseudoVWMULSU_VX_MF2_MASK, VWMULSU_VX, 0x7, 0x0 }, // 9941
  { PseudoVWMULU_VV_M1, VWMULU_VV, 0x0, 0x0 }, // 9942
  { PseudoVWMULU_VV_M1_MASK, VWMULU_VV, 0x0, 0x0 }, // 9943
  { PseudoVWMULU_VV_M2, VWMULU_VV, 0x1, 0x0 }, // 9944
  { PseudoVWMULU_VV_M2_MASK, VWMULU_VV, 0x1, 0x0 }, // 9945
  { PseudoVWMULU_VV_M4, VWMULU_VV, 0x2, 0x0 }, // 9946
  { PseudoVWMULU_VV_M4_MASK, VWMULU_VV, 0x2, 0x0 }, // 9947
  { PseudoVWMULU_VV_MF8, VWMULU_VV, 0x5, 0x0 }, // 9948
  { PseudoVWMULU_VV_MF8_MASK, VWMULU_VV, 0x5, 0x0 }, // 9949
  { PseudoVWMULU_VV_MF4, VWMULU_VV, 0x6, 0x0 }, // 9950
  { PseudoVWMULU_VV_MF4_MASK, VWMULU_VV, 0x6, 0x0 }, // 9951
  { PseudoVWMULU_VV_MF2, VWMULU_VV, 0x7, 0x0 }, // 9952
  { PseudoVWMULU_VV_MF2_MASK, VWMULU_VV, 0x7, 0x0 }, // 9953
  { PseudoVWMULU_VX_M1, VWMULU_VX, 0x0, 0x0 }, // 9954
  { PseudoVWMULU_VX_M1_MASK, VWMULU_VX, 0x0, 0x0 }, // 9955
  { PseudoVWMULU_VX_M2, VWMULU_VX, 0x1, 0x0 }, // 9956
  { PseudoVWMULU_VX_M2_MASK, VWMULU_VX, 0x1, 0x0 }, // 9957
  { PseudoVWMULU_VX_M4, VWMULU_VX, 0x2, 0x0 }, // 9958
  { PseudoVWMULU_VX_M4_MASK, VWMULU_VX, 0x2, 0x0 }, // 9959
  { PseudoVWMULU_VX_MF8, VWMULU_VX, 0x5, 0x0 }, // 9960
  { PseudoVWMULU_VX_MF8_MASK, VWMULU_VX, 0x5, 0x0 }, // 9961
  { PseudoVWMULU_VX_MF4, VWMULU_VX, 0x6, 0x0 }, // 9962
  { PseudoVWMULU_VX_MF4_MASK, VWMULU_VX, 0x6, 0x0 }, // 9963
  { PseudoVWMULU_VX_MF2, VWMULU_VX, 0x7, 0x0 }, // 9964
  { PseudoVWMULU_VX_MF2_MASK, VWMULU_VX, 0x7, 0x0 }, // 9965
  { PseudoVWMUL_VV_M1, VWMUL_VV, 0x0, 0x0 }, // 9966
  { PseudoVWMUL_VV_M1_MASK, VWMUL_VV, 0x0, 0x0 }, // 9967
  { PseudoVWMUL_VV_M2, VWMUL_VV, 0x1, 0x0 }, // 9968
  { PseudoVWMUL_VV_M2_MASK, VWMUL_VV, 0x1, 0x0 }, // 9969
  { PseudoVWMUL_VV_M4, VWMUL_VV, 0x2, 0x0 }, // 9970
  { PseudoVWMUL_VV_M4_MASK, VWMUL_VV, 0x2, 0x0 }, // 9971
  { PseudoVWMUL_VV_MF8, VWMUL_VV, 0x5, 0x0 }, // 9972
  { PseudoVWMUL_VV_MF8_MASK, VWMUL_VV, 0x5, 0x0 }, // 9973
  { PseudoVWMUL_VV_MF4, VWMUL_VV, 0x6, 0x0 }, // 9974
  { PseudoVWMUL_VV_MF4_MASK, VWMUL_VV, 0x6, 0x0 }, // 9975
  { PseudoVWMUL_VV_MF2, VWMUL_VV, 0x7, 0x0 }, // 9976
  { PseudoVWMUL_VV_MF2_MASK, VWMUL_VV, 0x7, 0x0 }, // 9977
  { PseudoVWMUL_VX_M1, VWMUL_VX, 0x0, 0x0 }, // 9978
  { PseudoVWMUL_VX_M1_MASK, VWMUL_VX, 0x0, 0x0 }, // 9979
  { PseudoVWMUL_VX_M2, VWMUL_VX, 0x1, 0x0 }, // 9980
  { PseudoVWMUL_VX_M2_MASK, VWMUL_VX, 0x1, 0x0 }, // 9981
  { PseudoVWMUL_VX_M4, VWMUL_VX, 0x2, 0x0 }, // 9982
  { PseudoVWMUL_VX_M4_MASK, VWMUL_VX, 0x2, 0x0 }, // 9983
  { PseudoVWMUL_VX_MF8, VWMUL_VX, 0x5, 0x0 }, // 9984
  { PseudoVWMUL_VX_MF8_MASK, VWMUL_VX, 0x5, 0x0 }, // 9985
  { PseudoVWMUL_VX_MF4, VWMUL_VX, 0x6, 0x0 }, // 9986
  { PseudoVWMUL_VX_MF4_MASK, VWMUL_VX, 0x6, 0x0 }, // 9987
  { PseudoVWMUL_VX_MF2, VWMUL_VX, 0x7, 0x0 }, // 9988
  { PseudoVWMUL_VX_MF2_MASK, VWMUL_VX, 0x7, 0x0 }, // 9989
  { PseudoVWREDSUMU_VS_M1_E16, VWREDSUMU_VS, 0x0, 0x0 }, // 9990
  { PseudoVWREDSUMU_VS_M1_E16_MASK, VWREDSUMU_VS, 0x0, 0x0 }, // 9991
  { PseudoVWREDSUMU_VS_M1_E32, VWREDSUMU_VS, 0x0, 0x0 }, // 9992
  { PseudoVWREDSUMU_VS_M1_E32_MASK, VWREDSUMU_VS, 0x0, 0x0 }, // 9993
  { PseudoVWREDSUMU_VS_M1_E8, VWREDSUMU_VS, 0x0, 0x0 }, // 9994
  { PseudoVWREDSUMU_VS_M1_E8_MASK, VWREDSUMU_VS, 0x0, 0x0 }, // 9995
  { PseudoVWREDSUMU_VS_M2_E16, VWREDSUMU_VS, 0x1, 0x0 }, // 9996
  { PseudoVWREDSUMU_VS_M2_E16_MASK, VWREDSUMU_VS, 0x1, 0x0 }, // 9997
  { PseudoVWREDSUMU_VS_M2_E32, VWREDSUMU_VS, 0x1, 0x0 }, // 9998
  { PseudoVWREDSUMU_VS_M2_E32_MASK, VWREDSUMU_VS, 0x1, 0x0 }, // 9999
  { PseudoVWREDSUMU_VS_M2_E8, VWREDSUMU_VS, 0x1, 0x0 }, // 10000
  { PseudoVWREDSUMU_VS_M2_E8_MASK, VWREDSUMU_VS, 0x1, 0x0 }, // 10001
  { PseudoVWREDSUMU_VS_M4_E16, VWREDSUMU_VS, 0x2, 0x0 }, // 10002
  { PseudoVWREDSUMU_VS_M4_E16_MASK, VWREDSUMU_VS, 0x2, 0x0 }, // 10003
  { PseudoVWREDSUMU_VS_M4_E32, VWREDSUMU_VS, 0x2, 0x0 }, // 10004
  { PseudoVWREDSUMU_VS_M4_E32_MASK, VWREDSUMU_VS, 0x2, 0x0 }, // 10005
  { PseudoVWREDSUMU_VS_M4_E8, VWREDSUMU_VS, 0x2, 0x0 }, // 10006
  { PseudoVWREDSUMU_VS_M4_E8_MASK, VWREDSUMU_VS, 0x2, 0x0 }, // 10007
  { PseudoVWREDSUMU_VS_M8_E16, VWREDSUMU_VS, 0x3, 0x0 }, // 10008
  { PseudoVWREDSUMU_VS_M8_E16_MASK, VWREDSUMU_VS, 0x3, 0x0 }, // 10009
  { PseudoVWREDSUMU_VS_M8_E32, VWREDSUMU_VS, 0x3, 0x0 }, // 10010
  { PseudoVWREDSUMU_VS_M8_E32_MASK, VWREDSUMU_VS, 0x3, 0x0 }, // 10011
  { PseudoVWREDSUMU_VS_M8_E8, VWREDSUMU_VS, 0x3, 0x0 }, // 10012
  { PseudoVWREDSUMU_VS_M8_E8_MASK, VWREDSUMU_VS, 0x3, 0x0 }, // 10013
  { PseudoVWREDSUMU_VS_MF8_E8, VWREDSUMU_VS, 0x5, 0x0 }, // 10014
  { PseudoVWREDSUMU_VS_MF8_E8_MASK, VWREDSUMU_VS, 0x5, 0x0 }, // 10015
  { PseudoVWREDSUMU_VS_MF4_E16, VWREDSUMU_VS, 0x6, 0x0 }, // 10016
  { PseudoVWREDSUMU_VS_MF4_E16_MASK, VWREDSUMU_VS, 0x6, 0x0 }, // 10017
  { PseudoVWREDSUMU_VS_MF4_E8, VWREDSUMU_VS, 0x6, 0x0 }, // 10018
  { PseudoVWREDSUMU_VS_MF4_E8_MASK, VWREDSUMU_VS, 0x6, 0x0 }, // 10019
  { PseudoVWREDSUMU_VS_MF2_E16, VWREDSUMU_VS, 0x7, 0x0 }, // 10020
  { PseudoVWREDSUMU_VS_MF2_E16_MASK, VWREDSUMU_VS, 0x7, 0x0 }, // 10021
  { PseudoVWREDSUMU_VS_MF2_E32, VWREDSUMU_VS, 0x7, 0x0 }, // 10022
  { PseudoVWREDSUMU_VS_MF2_E32_MASK, VWREDSUMU_VS, 0x7, 0x0 }, // 10023
  { PseudoVWREDSUMU_VS_MF2_E8, VWREDSUMU_VS, 0x7, 0x0 }, // 10024
  { PseudoVWREDSUMU_VS_MF2_E8_MASK, VWREDSUMU_VS, 0x7, 0x0 }, // 10025
  { PseudoVWREDSUM_VS_M1_E16, VWREDSUM_VS, 0x0, 0x0 }, // 10026
  { PseudoVWREDSUM_VS_M1_E16_MASK, VWREDSUM_VS, 0x0, 0x0 }, // 10027
  { PseudoVWREDSUM_VS_M1_E32, VWREDSUM_VS, 0x0, 0x0 }, // 10028
  { PseudoVWREDSUM_VS_M1_E32_MASK, VWREDSUM_VS, 0x0, 0x0 }, // 10029
  { PseudoVWREDSUM_VS_M1_E8, VWREDSUM_VS, 0x0, 0x0 }, // 10030
  { PseudoVWREDSUM_VS_M1_E8_MASK, VWREDSUM_VS, 0x0, 0x0 }, // 10031
  { PseudoVWREDSUM_VS_M2_E16, VWREDSUM_VS, 0x1, 0x0 }, // 10032
  { PseudoVWREDSUM_VS_M2_E16_MASK, VWREDSUM_VS, 0x1, 0x0 }, // 10033
  { PseudoVWREDSUM_VS_M2_E32, VWREDSUM_VS, 0x1, 0x0 }, // 10034
  { PseudoVWREDSUM_VS_M2_E32_MASK, VWREDSUM_VS, 0x1, 0x0 }, // 10035
  { PseudoVWREDSUM_VS_M2_E8, VWREDSUM_VS, 0x1, 0x0 }, // 10036
  { PseudoVWREDSUM_VS_M2_E8_MASK, VWREDSUM_VS, 0x1, 0x0 }, // 10037
  { PseudoVWREDSUM_VS_M4_E16, VWREDSUM_VS, 0x2, 0x0 }, // 10038
  { PseudoVWREDSUM_VS_M4_E16_MASK, VWREDSUM_VS, 0x2, 0x0 }, // 10039
  { PseudoVWREDSUM_VS_M4_E32, VWREDSUM_VS, 0x2, 0x0 }, // 10040
  { PseudoVWREDSUM_VS_M4_E32_MASK, VWREDSUM_VS, 0x2, 0x0 }, // 10041
  { PseudoVWREDSUM_VS_M4_E8, VWREDSUM_VS, 0x2, 0x0 }, // 10042
  { PseudoVWREDSUM_VS_M4_E8_MASK, VWREDSUM_VS, 0x2, 0x0 }, // 10043
  { PseudoVWREDSUM_VS_M8_E16, VWREDSUM_VS, 0x3, 0x0 }, // 10044
  { PseudoVWREDSUM_VS_M8_E16_MASK, VWREDSUM_VS, 0x3, 0x0 }, // 10045
  { PseudoVWREDSUM_VS_M8_E32, VWREDSUM_VS, 0x3, 0x0 }, // 10046
  { PseudoVWREDSUM_VS_M8_E32_MASK, VWREDSUM_VS, 0x3, 0x0 }, // 10047
  { PseudoVWREDSUM_VS_M8_E8, VWREDSUM_VS, 0x3, 0x0 }, // 10048
  { PseudoVWREDSUM_VS_M8_E8_MASK, VWREDSUM_VS, 0x3, 0x0 }, // 10049
  { PseudoVWREDSUM_VS_MF8_E8, VWREDSUM_VS, 0x5, 0x0 }, // 10050
  { PseudoVWREDSUM_VS_MF8_E8_MASK, VWREDSUM_VS, 0x5, 0x0 }, // 10051
  { PseudoVWREDSUM_VS_MF4_E16, VWREDSUM_VS, 0x6, 0x0 }, // 10052
  { PseudoVWREDSUM_VS_MF4_E16_MASK, VWREDSUM_VS, 0x6, 0x0 }, // 10053
  { PseudoVWREDSUM_VS_MF4_E8, VWREDSUM_VS, 0x6, 0x0 }, // 10054
  { PseudoVWREDSUM_VS_MF4_E8_MASK, VWREDSUM_VS, 0x6, 0x0 }, // 10055
  { PseudoVWREDSUM_VS_MF2_E16, VWREDSUM_VS, 0x7, 0x0 }, // 10056
  { PseudoVWREDSUM_VS_MF2_E16_MASK, VWREDSUM_VS, 0x7, 0x0 }, // 10057
  { PseudoVWREDSUM_VS_MF2_E32, VWREDSUM_VS, 0x7, 0x0 }, // 10058
  { PseudoVWREDSUM_VS_MF2_E32_MASK, VWREDSUM_VS, 0x7, 0x0 }, // 10059
  { PseudoVWREDSUM_VS_MF2_E8, VWREDSUM_VS, 0x7, 0x0 }, // 10060
  { PseudoVWREDSUM_VS_MF2_E8_MASK, VWREDSUM_VS, 0x7, 0x0 }, // 10061
  { PseudoVWSUBU_VV_M1, VWSUBU_VV, 0x0, 0x0 }, // 10062
  { PseudoVWSUBU_VV_M1_MASK, VWSUBU_VV, 0x0, 0x0 }, // 10063
  { PseudoVWSUBU_VV_M2, VWSUBU_VV, 0x1, 0x0 }, // 10064
  { PseudoVWSUBU_VV_M2_MASK, VWSUBU_VV, 0x1, 0x0 }, // 10065
  { PseudoVWSUBU_VV_M4, VWSUBU_VV, 0x2, 0x0 }, // 10066
  { PseudoVWSUBU_VV_M4_MASK, VWSUBU_VV, 0x2, 0x0 }, // 10067
  { PseudoVWSUBU_VV_MF8, VWSUBU_VV, 0x5, 0x0 }, // 10068
  { PseudoVWSUBU_VV_MF8_MASK, VWSUBU_VV, 0x5, 0x0 }, // 10069
  { PseudoVWSUBU_VV_MF4, VWSUBU_VV, 0x6, 0x0 }, // 10070
  { PseudoVWSUBU_VV_MF4_MASK, VWSUBU_VV, 0x6, 0x0 }, // 10071
  { PseudoVWSUBU_VV_MF2, VWSUBU_VV, 0x7, 0x0 }, // 10072
  { PseudoVWSUBU_VV_MF2_MASK, VWSUBU_VV, 0x7, 0x0 }, // 10073
  { PseudoVWSUBU_VX_M1, VWSUBU_VX, 0x0, 0x0 }, // 10074
  { PseudoVWSUBU_VX_M1_MASK, VWSUBU_VX, 0x0, 0x0 }, // 10075
  { PseudoVWSUBU_VX_M2, VWSUBU_VX, 0x1, 0x0 }, // 10076
  { PseudoVWSUBU_VX_M2_MASK, VWSUBU_VX, 0x1, 0x0 }, // 10077
  { PseudoVWSUBU_VX_M4, VWSUBU_VX, 0x2, 0x0 }, // 10078
  { PseudoVWSUBU_VX_M4_MASK, VWSUBU_VX, 0x2, 0x0 }, // 10079
  { PseudoVWSUBU_VX_MF8, VWSUBU_VX, 0x5, 0x0 }, // 10080
  { PseudoVWSUBU_VX_MF8_MASK, VWSUBU_VX, 0x5, 0x0 }, // 10081
  { PseudoVWSUBU_VX_MF4, VWSUBU_VX, 0x6, 0x0 }, // 10082
  { PseudoVWSUBU_VX_MF4_MASK, VWSUBU_VX, 0x6, 0x0 }, // 10083
  { PseudoVWSUBU_VX_MF2, VWSUBU_VX, 0x7, 0x0 }, // 10084
  { PseudoVWSUBU_VX_MF2_MASK, VWSUBU_VX, 0x7, 0x0 }, // 10085
  { PseudoVWSUBU_WV_M1, VWSUBU_WV, 0x0, 0x0 }, // 10086
  { PseudoVWSUBU_WV_M1_MASK, VWSUBU_WV, 0x0, 0x0 }, // 10087
  { PseudoVWSUBU_WV_M1_MASK_TIED, VWSUBU_WV, 0x0, 0x0 }, // 10088
  { PseudoVWSUBU_WV_M1_TIED, VWSUBU_WV, 0x0, 0x0 }, // 10089
  { PseudoVWSUBU_WV_M2, VWSUBU_WV, 0x1, 0x0 }, // 10090
  { PseudoVWSUBU_WV_M2_MASK, VWSUBU_WV, 0x1, 0x0 }, // 10091
  { PseudoVWSUBU_WV_M2_MASK_TIED, VWSUBU_WV, 0x1, 0x0 }, // 10092
  { PseudoVWSUBU_WV_M2_TIED, VWSUBU_WV, 0x1, 0x0 }, // 10093
  { PseudoVWSUBU_WV_M4, VWSUBU_WV, 0x2, 0x0 }, // 10094
  { PseudoVWSUBU_WV_M4_MASK, VWSUBU_WV, 0x2, 0x0 }, // 10095
  { PseudoVWSUBU_WV_M4_MASK_TIED, VWSUBU_WV, 0x2, 0x0 }, // 10096
  { PseudoVWSUBU_WV_M4_TIED, VWSUBU_WV, 0x2, 0x0 }, // 10097
  { PseudoVWSUBU_WV_MF8, VWSUBU_WV, 0x5, 0x0 }, // 10098
  { PseudoVWSUBU_WV_MF8_MASK, VWSUBU_WV, 0x5, 0x0 }, // 10099
  { PseudoVWSUBU_WV_MF8_MASK_TIED, VWSUBU_WV, 0x5, 0x0 }, // 10100
  { PseudoVWSUBU_WV_MF8_TIED, VWSUBU_WV, 0x5, 0x0 }, // 10101
  { PseudoVWSUBU_WV_MF4, VWSUBU_WV, 0x6, 0x0 }, // 10102
  { PseudoVWSUBU_WV_MF4_MASK, VWSUBU_WV, 0x6, 0x0 }, // 10103
  { PseudoVWSUBU_WV_MF4_MASK_TIED, VWSUBU_WV, 0x6, 0x0 }, // 10104
  { PseudoVWSUBU_WV_MF4_TIED, VWSUBU_WV, 0x6, 0x0 }, // 10105
  { PseudoVWSUBU_WV_MF2, VWSUBU_WV, 0x7, 0x0 }, // 10106
  { PseudoVWSUBU_WV_MF2_MASK, VWSUBU_WV, 0x7, 0x0 }, // 10107
  { PseudoVWSUBU_WV_MF2_MASK_TIED, VWSUBU_WV, 0x7, 0x0 }, // 10108
  { PseudoVWSUBU_WV_MF2_TIED, VWSUBU_WV, 0x7, 0x0 }, // 10109
  { PseudoVWSUBU_WX_M1, VWSUBU_WX, 0x0, 0x0 }, // 10110
  { PseudoVWSUBU_WX_M1_MASK, VWSUBU_WX, 0x0, 0x0 }, // 10111
  { PseudoVWSUBU_WX_M2, VWSUBU_WX, 0x1, 0x0 }, // 10112
  { PseudoVWSUBU_WX_M2_MASK, VWSUBU_WX, 0x1, 0x0 }, // 10113
  { PseudoVWSUBU_WX_M4, VWSUBU_WX, 0x2, 0x0 }, // 10114
  { PseudoVWSUBU_WX_M4_MASK, VWSUBU_WX, 0x2, 0x0 }, // 10115
  { PseudoVWSUBU_WX_MF8, VWSUBU_WX, 0x5, 0x0 }, // 10116
  { PseudoVWSUBU_WX_MF8_MASK, VWSUBU_WX, 0x5, 0x0 }, // 10117
  { PseudoVWSUBU_WX_MF4, VWSUBU_WX, 0x6, 0x0 }, // 10118
  { PseudoVWSUBU_WX_MF4_MASK, VWSUBU_WX, 0x6, 0x0 }, // 10119
  { PseudoVWSUBU_WX_MF2, VWSUBU_WX, 0x7, 0x0 }, // 10120
  { PseudoVWSUBU_WX_MF2_MASK, VWSUBU_WX, 0x7, 0x0 }, // 10121
  { PseudoVWSUB_VV_M1, VWSUB_VV, 0x0, 0x0 }, // 10122
  { PseudoVWSUB_VV_M1_MASK, VWSUB_VV, 0x0, 0x0 }, // 10123
  { PseudoVWSUB_VV_M2, VWSUB_VV, 0x1, 0x0 }, // 10124
  { PseudoVWSUB_VV_M2_MASK, VWSUB_VV, 0x1, 0x0 }, // 10125
  { PseudoVWSUB_VV_M4, VWSUB_VV, 0x2, 0x0 }, // 10126
  { PseudoVWSUB_VV_M4_MASK, VWSUB_VV, 0x2, 0x0 }, // 10127
  { PseudoVWSUB_VV_MF8, VWSUB_VV, 0x5, 0x0 }, // 10128
  { PseudoVWSUB_VV_MF8_MASK, VWSUB_VV, 0x5, 0x0 }, // 10129
  { PseudoVWSUB_VV_MF4, VWSUB_VV, 0x6, 0x0 }, // 10130
  { PseudoVWSUB_VV_MF4_MASK, VWSUB_VV, 0x6, 0x0 }, // 10131
  { PseudoVWSUB_VV_MF2, VWSUB_VV, 0x7, 0x0 }, // 10132
  { PseudoVWSUB_VV_MF2_MASK, VWSUB_VV, 0x7, 0x0 }, // 10133
  { PseudoVWSUB_VX_M1, VWSUB_VX, 0x0, 0x0 }, // 10134
  { PseudoVWSUB_VX_M1_MASK, VWSUB_VX, 0x0, 0x0 }, // 10135
  { PseudoVWSUB_VX_M2, VWSUB_VX, 0x1, 0x0 }, // 10136
  { PseudoVWSUB_VX_M2_MASK, VWSUB_VX, 0x1, 0x0 }, // 10137
  { PseudoVWSUB_VX_M4, VWSUB_VX, 0x2, 0x0 }, // 10138
  { PseudoVWSUB_VX_M4_MASK, VWSUB_VX, 0x2, 0x0 }, // 10139
  { PseudoVWSUB_VX_MF8, VWSUB_VX, 0x5, 0x0 }, // 10140
  { PseudoVWSUB_VX_MF8_MASK, VWSUB_VX, 0x5, 0x0 }, // 10141
  { PseudoVWSUB_VX_MF4, VWSUB_VX, 0x6, 0x0 }, // 10142
  { PseudoVWSUB_VX_MF4_MASK, VWSUB_VX, 0x6, 0x0 }, // 10143
  { PseudoVWSUB_VX_MF2, VWSUB_VX, 0x7, 0x0 }, // 10144
  { PseudoVWSUB_VX_MF2_MASK, VWSUB_VX, 0x7, 0x0 }, // 10145
  { PseudoVWSUB_WV_M1, VWSUB_WV, 0x0, 0x0 }, // 10146
  { PseudoVWSUB_WV_M1_MASK, VWSUB_WV, 0x0, 0x0 }, // 10147
  { PseudoVWSUB_WV_M1_MASK_TIED, VWSUB_WV, 0x0, 0x0 }, // 10148
  { PseudoVWSUB_WV_M1_TIED, VWSUB_WV, 0x0, 0x0 }, // 10149
  { PseudoVWSUB_WV_M2, VWSUB_WV, 0x1, 0x0 }, // 10150
  { PseudoVWSUB_WV_M2_MASK, VWSUB_WV, 0x1, 0x0 }, // 10151
  { PseudoVWSUB_WV_M2_MASK_TIED, VWSUB_WV, 0x1, 0x0 }, // 10152
  { PseudoVWSUB_WV_M2_TIED, VWSUB_WV, 0x1, 0x0 }, // 10153
  { PseudoVWSUB_WV_M4, VWSUB_WV, 0x2, 0x0 }, // 10154
  { PseudoVWSUB_WV_M4_MASK, VWSUB_WV, 0x2, 0x0 }, // 10155
  { PseudoVWSUB_WV_M4_MASK_TIED, VWSUB_WV, 0x2, 0x0 }, // 10156
  { PseudoVWSUB_WV_M4_TIED, VWSUB_WV, 0x2, 0x0 }, // 10157
  { PseudoVWSUB_WV_MF8, VWSUB_WV, 0x5, 0x0 }, // 10158
  { PseudoVWSUB_WV_MF8_MASK, VWSUB_WV, 0x5, 0x0 }, // 10159
  { PseudoVWSUB_WV_MF8_MASK_TIED, VWSUB_WV, 0x5, 0x0 }, // 10160
  { PseudoVWSUB_WV_MF8_TIED, VWSUB_WV, 0x5, 0x0 }, // 10161
  { PseudoVWSUB_WV_MF4, VWSUB_WV, 0x6, 0x0 }, // 10162
  { PseudoVWSUB_WV_MF4_MASK, VWSUB_WV, 0x6, 0x0 }, // 10163
  { PseudoVWSUB_WV_MF4_MASK_TIED, VWSUB_WV, 0x6, 0x0 }, // 10164
  { PseudoVWSUB_WV_MF4_TIED, VWSUB_WV, 0x6, 0x0 }, // 10165
  { PseudoVWSUB_WV_MF2, VWSUB_WV, 0x7, 0x0 }, // 10166
  { PseudoVWSUB_WV_MF2_MASK, VWSUB_WV, 0x7, 0x0 }, // 10167
  { PseudoVWSUB_WV_MF2_MASK_TIED, VWSUB_WV, 0x7, 0x0 }, // 10168
  { PseudoVWSUB_WV_MF2_TIED, VWSUB_WV, 0x7, 0x0 }, // 10169
  { PseudoVWSUB_WX_M1, VWSUB_WX, 0x0, 0x0 }, // 10170
  { PseudoVWSUB_WX_M1_MASK, VWSUB_WX, 0x0, 0x0 }, // 10171
  { PseudoVWSUB_WX_M2, VWSUB_WX, 0x1, 0x0 }, // 10172
  { PseudoVWSUB_WX_M2_MASK, VWSUB_WX, 0x1, 0x0 }, // 10173
  { PseudoVWSUB_WX_M4, VWSUB_WX, 0x2, 0x0 }, // 10174
  { PseudoVWSUB_WX_M4_MASK, VWSUB_WX, 0x2, 0x0 }, // 10175
  { PseudoVWSUB_WX_MF8, VWSUB_WX, 0x5, 0x0 }, // 10176
  { PseudoVWSUB_WX_MF8_MASK, VWSUB_WX, 0x5, 0x0 }, // 10177
  { PseudoVWSUB_WX_MF4, VWSUB_WX, 0x6, 0x0 }, // 10178
  { PseudoVWSUB_WX_MF4_MASK, VWSUB_WX, 0x6, 0x0 }, // 10179
  { PseudoVWSUB_WX_MF2, VWSUB_WX, 0x7, 0x0 }, // 10180
  { PseudoVWSUB_WX_MF2_MASK, VWSUB_WX, 0x7, 0x0 }, // 10181
  { PseudoVXOR_VI_M1, VXOR_VI, 0x0, 0x0 }, // 10182
  { PseudoVXOR_VI_M1_MASK, VXOR_VI, 0x0, 0x0 }, // 10183
  { PseudoVXOR_VI_M2, VXOR_VI, 0x1, 0x0 }, // 10184
  { PseudoVXOR_VI_M2_MASK, VXOR_VI, 0x1, 0x0 }, // 10185
  { PseudoVXOR_VI_M4, VXOR_VI, 0x2, 0x0 }, // 10186
  { PseudoVXOR_VI_M4_MASK, VXOR_VI, 0x2, 0x0 }, // 10187
  { PseudoVXOR_VI_M8, VXOR_VI, 0x3, 0x0 }, // 10188
  { PseudoVXOR_VI_M8_MASK, VXOR_VI, 0x3, 0x0 }, // 10189
  { PseudoVXOR_VI_MF8, VXOR_VI, 0x5, 0x0 }, // 10190
  { PseudoVXOR_VI_MF8_MASK, VXOR_VI, 0x5, 0x0 }, // 10191
  { PseudoVXOR_VI_MF4, VXOR_VI, 0x6, 0x0 }, // 10192
  { PseudoVXOR_VI_MF4_MASK, VXOR_VI, 0x6, 0x0 }, // 10193
  { PseudoVXOR_VI_MF2, VXOR_VI, 0x7, 0x0 }, // 10194
  { PseudoVXOR_VI_MF2_MASK, VXOR_VI, 0x7, 0x0 }, // 10195
  { PseudoVXOR_VV_M1, VXOR_VV, 0x0, 0x0 }, // 10196
  { PseudoVXOR_VV_M1_MASK, VXOR_VV, 0x0, 0x0 }, // 10197
  { PseudoVXOR_VV_M2, VXOR_VV, 0x1, 0x0 }, // 10198
  { PseudoVXOR_VV_M2_MASK, VXOR_VV, 0x1, 0x0 }, // 10199
  { PseudoVXOR_VV_M4, VXOR_VV, 0x2, 0x0 }, // 10200
  { PseudoVXOR_VV_M4_MASK, VXOR_VV, 0x2, 0x0 }, // 10201
  { PseudoVXOR_VV_M8, VXOR_VV, 0x3, 0x0 }, // 10202
  { PseudoVXOR_VV_M8_MASK, VXOR_VV, 0x3, 0x0 }, // 10203
  { PseudoVXOR_VV_MF8, VXOR_VV, 0x5, 0x0 }, // 10204
  { PseudoVXOR_VV_MF8_MASK, VXOR_VV, 0x5, 0x0 }, // 10205
  { PseudoVXOR_VV_MF4, VXOR_VV, 0x6, 0x0 }, // 10206
  { PseudoVXOR_VV_MF4_MASK, VXOR_VV, 0x6, 0x0 }, // 10207
  { PseudoVXOR_VV_MF2, VXOR_VV, 0x7, 0x0 }, // 10208
  { PseudoVXOR_VV_MF2_MASK, VXOR_VV, 0x7, 0x0 }, // 10209
  { PseudoVXOR_VX_M1, VXOR_VX, 0x0, 0x0 }, // 10210
  { PseudoVXOR_VX_M1_MASK, VXOR_VX, 0x0, 0x0 }, // 10211
  { PseudoVXOR_VX_M2, VXOR_VX, 0x1, 0x0 }, // 10212
  { PseudoVXOR_VX_M2_MASK, VXOR_VX, 0x1, 0x0 }, // 10213
  { PseudoVXOR_VX_M4, VXOR_VX, 0x2, 0x0 }, // 10214
  { PseudoVXOR_VX_M4_MASK, VXOR_VX, 0x2, 0x0 }, // 10215
  { PseudoVXOR_VX_M8, VXOR_VX, 0x3, 0x0 }, // 10216
  { PseudoVXOR_VX_M8_MASK, VXOR_VX, 0x3, 0x0 }, // 10217
  { PseudoVXOR_VX_MF8, VXOR_VX, 0x5, 0x0 }, // 10218
  { PseudoVXOR_VX_MF8_MASK, VXOR_VX, 0x5, 0x0 }, // 10219
  { PseudoVXOR_VX_MF4, VXOR_VX, 0x6, 0x0 }, // 10220
  { PseudoVXOR_VX_MF4_MASK, VXOR_VX, 0x6, 0x0 }, // 10221
  { PseudoVXOR_VX_MF2, VXOR_VX, 0x7, 0x0 }, // 10222
  { PseudoVXOR_VX_MF2_MASK, VXOR_VX, 0x7, 0x0 }, // 10223
  { PseudoVZEXT_VF2_M1, VZEXT_VF2, 0x0, 0x0 }, // 10224
  { PseudoVZEXT_VF2_M1_MASK, VZEXT_VF2, 0x0, 0x0 }, // 10225
  { PseudoVZEXT_VF2_M2, VZEXT_VF2, 0x1, 0x0 }, // 10226
  { PseudoVZEXT_VF2_M2_MASK, VZEXT_VF2, 0x1, 0x0 }, // 10227
  { PseudoVZEXT_VF2_M4, VZEXT_VF2, 0x2, 0x0 }, // 10228
  { PseudoVZEXT_VF2_M4_MASK, VZEXT_VF2, 0x2, 0x0 }, // 10229
  { PseudoVZEXT_VF2_M8, VZEXT_VF2, 0x3, 0x0 }, // 10230
  { PseudoVZEXT_VF2_M8_MASK, VZEXT_VF2, 0x3, 0x0 }, // 10231
  { PseudoVZEXT_VF2_MF4, VZEXT_VF2, 0x6, 0x0 }, // 10232
  { PseudoVZEXT_VF2_MF4_MASK, VZEXT_VF2, 0x6, 0x0 }, // 10233
  { PseudoVZEXT_VF2_MF2, VZEXT_VF2, 0x7, 0x0 }, // 10234
  { PseudoVZEXT_VF2_MF2_MASK, VZEXT_VF2, 0x7, 0x0 }, // 10235
  { PseudoVZEXT_VF4_M1, VZEXT_VF4, 0x0, 0x0 }, // 10236
  { PseudoVZEXT_VF4_M1_MASK, VZEXT_VF4, 0x0, 0x0 }, // 10237
  { PseudoVZEXT_VF4_M2, VZEXT_VF4, 0x1, 0x0 }, // 10238
  { PseudoVZEXT_VF4_M2_MASK, VZEXT_VF4, 0x1, 0x0 }, // 10239
  { PseudoVZEXT_VF4_M4, VZEXT_VF4, 0x2, 0x0 }, // 10240
  { PseudoVZEXT_VF4_M4_MASK, VZEXT_VF4, 0x2, 0x0 }, // 10241
  { PseudoVZEXT_VF4_M8, VZEXT_VF4, 0x3, 0x0 }, // 10242
  { PseudoVZEXT_VF4_M8_MASK, VZEXT_VF4, 0x3, 0x0 }, // 10243
  { PseudoVZEXT_VF4_MF2, VZEXT_VF4, 0x7, 0x0 }, // 10244
  { PseudoVZEXT_VF4_MF2_MASK, VZEXT_VF4, 0x7, 0x0 }, // 10245
  { PseudoVZEXT_VF8_M1, VZEXT_VF8, 0x0, 0x0 }, // 10246
  { PseudoVZEXT_VF8_M1_MASK, VZEXT_VF8, 0x0, 0x0 }, // 10247
  { PseudoVZEXT_VF8_M2, VZEXT_VF8, 0x1, 0x0 }, // 10248
  { PseudoVZEXT_VF8_M2_MASK, VZEXT_VF8, 0x1, 0x0 }, // 10249
  { PseudoVZEXT_VF8_M4, VZEXT_VF8, 0x2, 0x0 }, // 10250
  { PseudoVZEXT_VF8_M4_MASK, VZEXT_VF8, 0x2, 0x0 }, // 10251
  { PseudoVZEXT_VF8_M8, VZEXT_VF8, 0x3, 0x0 }, // 10252
  { PseudoVZEXT_VF8_M8_MASK, VZEXT_VF8, 0x3, 0x0 }, // 10253
 };

const PseudoInfo *getBaseInfo(unsigned BaseInstr, uint8_t VLMul, uint8_t SEW) {
  if ((BaseInstr < THVdotVMAQASU_VV) ||
      (BaseInstr > VZEXT_VF8))
    return nullptr;

  struct KeyType {
    unsigned BaseInstr;
    uint8_t VLMul;
    uint8_t SEW;
  };
  KeyType Key = {BaseInstr, VLMul, SEW};
  auto Table = ArrayRef(RISCVVInversePseudosTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const PseudoInfo &LHS, const KeyType &RHS) {
      if (LHS.BaseInstr < RHS.BaseInstr)
        return true;
      if (LHS.BaseInstr > RHS.BaseInstr)
        return false;
      if (LHS.VLMul < RHS.VLMul)
        return true;
      if (LHS.VLMul > RHS.VLMul)
        return false;
      if (LHS.SEW < RHS.SEW)
        return true;
      if (LHS.SEW > RHS.SEW)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseInstr != Idx->BaseInstr ||
      Key.VLMul != Idx->VLMul ||
      Key.SEW != Idx->SEW)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLETable_DECL
const VLEPseudo *getVLEPseudo(uint8_t Masked, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL);
#endif

#ifdef GET_RISCVVLETable_IMPL
constexpr VLEPseudo RISCVVLETable[] = {
  { 0x0, 0x0, 0x0, 0x0, 0x0, PseudoVLM_V_B8 }, // 0
  { 0x0, 0x0, 0x0, 0x0, 0x1, PseudoVLM_V_B16 }, // 1
  { 0x0, 0x0, 0x0, 0x0, 0x2, PseudoVLM_V_B32 }, // 2
  { 0x0, 0x0, 0x0, 0x0, 0x3, PseudoVLM_V_B64 }, // 3
  { 0x0, 0x0, 0x0, 0x0, 0x5, PseudoVLM_V_B1 }, // 4
  { 0x0, 0x0, 0x0, 0x0, 0x6, PseudoVLM_V_B2 }, // 5
  { 0x0, 0x0, 0x0, 0x0, 0x7, PseudoVLM_V_B4 }, // 6
  { 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLE8_V_M1 }, // 7
  { 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLE8_V_M2 }, // 8
  { 0x0, 0x0, 0x0, 0x3, 0x2, PseudoVLE8_V_M4 }, // 9
  { 0x0, 0x0, 0x0, 0x3, 0x3, PseudoVLE8_V_M8 }, // 10
  { 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLE8_V_MF8 }, // 11
  { 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLE8_V_MF4 }, // 12
  { 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLE8_V_MF2 }, // 13
  { 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLE16_V_M1 }, // 14
  { 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLE16_V_M2 }, // 15
  { 0x0, 0x0, 0x0, 0x4, 0x2, PseudoVLE16_V_M4 }, // 16
  { 0x0, 0x0, 0x0, 0x4, 0x3, PseudoVLE16_V_M8 }, // 17
  { 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLE16_V_MF4 }, // 18
  { 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLE16_V_MF2 }, // 19
  { 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLE32_V_M1 }, // 20
  { 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLE32_V_M2 }, // 21
  { 0x0, 0x0, 0x0, 0x5, 0x2, PseudoVLE32_V_M4 }, // 22
  { 0x0, 0x0, 0x0, 0x5, 0x3, PseudoVLE32_V_M8 }, // 23
  { 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLE32_V_MF2 }, // 24
  { 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLE64_V_M1 }, // 25
  { 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLE64_V_M2 }, // 26
  { 0x0, 0x0, 0x0, 0x6, 0x2, PseudoVLE64_V_M4 }, // 27
  { 0x0, 0x0, 0x0, 0x6, 0x3, PseudoVLE64_V_M8 }, // 28
  { 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLE8FF_V_M1 }, // 29
  { 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLE8FF_V_M2 }, // 30
  { 0x0, 0x0, 0x1, 0x3, 0x2, PseudoVLE8FF_V_M4 }, // 31
  { 0x0, 0x0, 0x1, 0x3, 0x3, PseudoVLE8FF_V_M8 }, // 32
  { 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLE8FF_V_MF8 }, // 33
  { 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLE8FF_V_MF4 }, // 34
  { 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLE8FF_V_MF2 }, // 35
  { 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLE16FF_V_M1 }, // 36
  { 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLE16FF_V_M2 }, // 37
  { 0x0, 0x0, 0x1, 0x4, 0x2, PseudoVLE16FF_V_M4 }, // 38
  { 0x0, 0x0, 0x1, 0x4, 0x3, PseudoVLE16FF_V_M8 }, // 39
  { 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLE16FF_V_MF4 }, // 40
  { 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLE16FF_V_MF2 }, // 41
  { 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLE32FF_V_M1 }, // 42
  { 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLE32FF_V_M2 }, // 43
  { 0x0, 0x0, 0x1, 0x5, 0x2, PseudoVLE32FF_V_M4 }, // 44
  { 0x0, 0x0, 0x1, 0x5, 0x3, PseudoVLE32FF_V_M8 }, // 45
  { 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLE32FF_V_MF2 }, // 46
  { 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLE64FF_V_M1 }, // 47
  { 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLE64FF_V_M2 }, // 48
  { 0x0, 0x0, 0x1, 0x6, 0x2, PseudoVLE64FF_V_M4 }, // 49
  { 0x0, 0x0, 0x1, 0x6, 0x3, PseudoVLE64FF_V_M8 }, // 50
  { 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSE8_V_M1 }, // 51
  { 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSE8_V_M2 }, // 52
  { 0x0, 0x1, 0x0, 0x3, 0x2, PseudoVLSE8_V_M4 }, // 53
  { 0x0, 0x1, 0x0, 0x3, 0x3, PseudoVLSE8_V_M8 }, // 54
  { 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSE8_V_MF8 }, // 55
  { 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSE8_V_MF4 }, // 56
  { 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSE8_V_MF2 }, // 57
  { 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSE16_V_M1 }, // 58
  { 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSE16_V_M2 }, // 59
  { 0x0, 0x1, 0x0, 0x4, 0x2, PseudoVLSE16_V_M4 }, // 60
  { 0x0, 0x1, 0x0, 0x4, 0x3, PseudoVLSE16_V_M8 }, // 61
  { 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSE16_V_MF4 }, // 62
  { 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSE16_V_MF2 }, // 63
  { 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSE32_V_M1 }, // 64
  { 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSE32_V_M2 }, // 65
  { 0x0, 0x1, 0x0, 0x5, 0x2, PseudoVLSE32_V_M4 }, // 66
  { 0x0, 0x1, 0x0, 0x5, 0x3, PseudoVLSE32_V_M8 }, // 67
  { 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSE32_V_MF2 }, // 68
  { 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSE64_V_M1 }, // 69
  { 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSE64_V_M2 }, // 70
  { 0x0, 0x1, 0x0, 0x6, 0x2, PseudoVLSE64_V_M4 }, // 71
  { 0x0, 0x1, 0x0, 0x6, 0x3, PseudoVLSE64_V_M8 }, // 72
  { 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLE8_V_M1_MASK }, // 73
  { 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLE8_V_M2_MASK }, // 74
  { 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLE8_V_M4_MASK }, // 75
  { 0x1, 0x0, 0x0, 0x3, 0x3, PseudoVLE8_V_M8_MASK }, // 76
  { 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLE8_V_MF8_MASK }, // 77
  { 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLE8_V_MF4_MASK }, // 78
  { 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLE8_V_MF2_MASK }, // 79
  { 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLE16_V_M1_MASK }, // 80
  { 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLE16_V_M2_MASK }, // 81
  { 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLE16_V_M4_MASK }, // 82
  { 0x1, 0x0, 0x0, 0x4, 0x3, PseudoVLE16_V_M8_MASK }, // 83
  { 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLE16_V_MF4_MASK }, // 84
  { 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLE16_V_MF2_MASK }, // 85
  { 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLE32_V_M1_MASK }, // 86
  { 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLE32_V_M2_MASK }, // 87
  { 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLE32_V_M4_MASK }, // 88
  { 0x1, 0x0, 0x0, 0x5, 0x3, PseudoVLE32_V_M8_MASK }, // 89
  { 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLE32_V_MF2_MASK }, // 90
  { 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLE64_V_M1_MASK }, // 91
  { 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLE64_V_M2_MASK }, // 92
  { 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLE64_V_M4_MASK }, // 93
  { 0x1, 0x0, 0x0, 0x6, 0x3, PseudoVLE64_V_M8_MASK }, // 94
  { 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLE8FF_V_M1_MASK }, // 95
  { 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLE8FF_V_M2_MASK }, // 96
  { 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLE8FF_V_M4_MASK }, // 97
  { 0x1, 0x0, 0x1, 0x3, 0x3, PseudoVLE8FF_V_M8_MASK }, // 98
  { 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLE8FF_V_MF8_MASK }, // 99
  { 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLE8FF_V_MF4_MASK }, // 100
  { 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLE8FF_V_MF2_MASK }, // 101
  { 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLE16FF_V_M1_MASK }, // 102
  { 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLE16FF_V_M2_MASK }, // 103
  { 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLE16FF_V_M4_MASK }, // 104
  { 0x1, 0x0, 0x1, 0x4, 0x3, PseudoVLE16FF_V_M8_MASK }, // 105
  { 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLE16FF_V_MF4_MASK }, // 106
  { 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLE16FF_V_MF2_MASK }, // 107
  { 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLE32FF_V_M1_MASK }, // 108
  { 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLE32FF_V_M2_MASK }, // 109
  { 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLE32FF_V_M4_MASK }, // 110
  { 0x1, 0x0, 0x1, 0x5, 0x3, PseudoVLE32FF_V_M8_MASK }, // 111
  { 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLE32FF_V_MF2_MASK }, // 112
  { 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLE64FF_V_M1_MASK }, // 113
  { 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLE64FF_V_M2_MASK }, // 114
  { 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLE64FF_V_M4_MASK }, // 115
  { 0x1, 0x0, 0x1, 0x6, 0x3, PseudoVLE64FF_V_M8_MASK }, // 116
  { 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSE8_V_M1_MASK }, // 117
  { 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSE8_V_M2_MASK }, // 118
  { 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSE8_V_M4_MASK }, // 119
  { 0x1, 0x1, 0x0, 0x3, 0x3, PseudoVLSE8_V_M8_MASK }, // 120
  { 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSE8_V_MF8_MASK }, // 121
  { 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSE8_V_MF4_MASK }, // 122
  { 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSE8_V_MF2_MASK }, // 123
  { 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSE16_V_M1_MASK }, // 124
  { 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSE16_V_M2_MASK }, // 125
  { 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSE16_V_M4_MASK }, // 126
  { 0x1, 0x1, 0x0, 0x4, 0x3, PseudoVLSE16_V_M8_MASK }, // 127
  { 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSE16_V_MF4_MASK }, // 128
  { 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSE16_V_MF2_MASK }, // 129
  { 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSE32_V_M1_MASK }, // 130
  { 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSE32_V_M2_MASK }, // 131
  { 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSE32_V_M4_MASK }, // 132
  { 0x1, 0x1, 0x0, 0x5, 0x3, PseudoVLSE32_V_M8_MASK }, // 133
  { 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSE32_V_MF2_MASK }, // 134
  { 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSE64_V_M1_MASK }, // 135
  { 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSE64_V_M2_MASK }, // 136
  { 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSE64_V_M4_MASK }, // 137
  { 0x1, 0x1, 0x0, 0x6, 0x3, PseudoVLSE64_V_M8_MASK }, // 138
 };

const VLEPseudo *getVLEPseudo(uint8_t Masked, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL) {
  struct KeyType {
    uint8_t Masked;
    uint8_t Strided;
    uint8_t FF;
    uint8_t Log2SEW;
    uint8_t LMUL;
  };
  KeyType Key = {Masked, Strided, FF, Log2SEW, LMUL};
  auto Table = ArrayRef(RISCVVLETable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const VLEPseudo &LHS, const KeyType &RHS) {
      if (LHS.Masked < RHS.Masked)
        return true;
      if (LHS.Masked > RHS.Masked)
        return false;
      if (LHS.Strided < RHS.Strided)
        return true;
      if (LHS.Strided > RHS.Strided)
        return false;
      if (LHS.FF < RHS.FF)
        return true;
      if (LHS.FF > RHS.FF)
        return false;
      if (LHS.Log2SEW < RHS.Log2SEW)
        return true;
      if (LHS.Log2SEW > RHS.Log2SEW)
        return false;
      if (LHS.LMUL < RHS.LMUL)
        return true;
      if (LHS.LMUL > RHS.LMUL)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Masked != Idx->Masked ||
      Key.Strided != Idx->Strided ||
      Key.FF != Idx->FF ||
      Key.Log2SEW != Idx->Log2SEW ||
      Key.LMUL != Idx->LMUL)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLSEGTable_DECL
const VLSEGPseudo *getVLSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL);
#endif

#ifdef GET_RISCVVLSEGTable_IMPL
constexpr VLSEGPseudo RISCVVLSEGTable[] = {
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG2E8_V_M1 }, // 0
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG2E8_V_M2 }, // 1
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x2, PseudoVLSEG2E8_V_M4 }, // 2
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG2E8_V_MF8 }, // 3
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG2E8_V_MF4 }, // 4
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG2E8_V_MF2 }, // 5
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG2E16_V_M1 }, // 6
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG2E16_V_M2 }, // 7
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x2, PseudoVLSEG2E16_V_M4 }, // 8
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG2E16_V_MF4 }, // 9
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG2E16_V_MF2 }, // 10
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG2E32_V_M1 }, // 11
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG2E32_V_M2 }, // 12
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x2, PseudoVLSEG2E32_V_M4 }, // 13
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG2E32_V_MF2 }, // 14
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG2E64_V_M1 }, // 15
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG2E64_V_M2 }, // 16
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x2, PseudoVLSEG2E64_V_M4 }, // 17
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG2E8FF_V_M1 }, // 18
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG2E8FF_V_M2 }, // 19
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x2, PseudoVLSEG2E8FF_V_M4 }, // 20
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG2E8FF_V_MF8 }, // 21
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG2E8FF_V_MF4 }, // 22
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG2E8FF_V_MF2 }, // 23
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG2E16FF_V_M1 }, // 24
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG2E16FF_V_M2 }, // 25
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x2, PseudoVLSEG2E16FF_V_M4 }, // 26
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG2E16FF_V_MF4 }, // 27
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG2E16FF_V_MF2 }, // 28
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG2E32FF_V_M1 }, // 29
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG2E32FF_V_M2 }, // 30
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x2, PseudoVLSEG2E32FF_V_M4 }, // 31
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG2E32FF_V_MF2 }, // 32
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG2E64FF_V_M1 }, // 33
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG2E64FF_V_M2 }, // 34
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x2, PseudoVLSEG2E64FF_V_M4 }, // 35
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG2E8_V_M1 }, // 36
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG2E8_V_M2 }, // 37
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x2, PseudoVLSSEG2E8_V_M4 }, // 38
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG2E8_V_MF8 }, // 39
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG2E8_V_MF4 }, // 40
  { 0x2, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG2E8_V_MF2 }, // 41
  { 0x2, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG2E16_V_M1 }, // 42
  { 0x2, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG2E16_V_M2 }, // 43
  { 0x2, 0x0, 0x1, 0x0, 0x4, 0x2, PseudoVLSSEG2E16_V_M4 }, // 44
  { 0x2, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG2E16_V_MF4 }, // 45
  { 0x2, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG2E16_V_MF2 }, // 46
  { 0x2, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG2E32_V_M1 }, // 47
  { 0x2, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG2E32_V_M2 }, // 48
  { 0x2, 0x0, 0x1, 0x0, 0x5, 0x2, PseudoVLSSEG2E32_V_M4 }, // 49
  { 0x2, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG2E32_V_MF2 }, // 50
  { 0x2, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG2E64_V_M1 }, // 51
  { 0x2, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG2E64_V_M2 }, // 52
  { 0x2, 0x0, 0x1, 0x0, 0x6, 0x2, PseudoVLSSEG2E64_V_M4 }, // 53
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG2E8_V_M1_MASK }, // 54
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG2E8_V_M2_MASK }, // 55
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLSEG2E8_V_M4_MASK }, // 56
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG2E8_V_MF8_MASK }, // 57
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG2E8_V_MF4_MASK }, // 58
  { 0x2, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG2E8_V_MF2_MASK }, // 59
  { 0x2, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG2E16_V_M1_MASK }, // 60
  { 0x2, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG2E16_V_M2_MASK }, // 61
  { 0x2, 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLSEG2E16_V_M4_MASK }, // 62
  { 0x2, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG2E16_V_MF4_MASK }, // 63
  { 0x2, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG2E16_V_MF2_MASK }, // 64
  { 0x2, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG2E32_V_M1_MASK }, // 65
  { 0x2, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG2E32_V_M2_MASK }, // 66
  { 0x2, 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLSEG2E32_V_M4_MASK }, // 67
  { 0x2, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG2E32_V_MF2_MASK }, // 68
  { 0x2, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG2E64_V_M1_MASK }, // 69
  { 0x2, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG2E64_V_M2_MASK }, // 70
  { 0x2, 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLSEG2E64_V_M4_MASK }, // 71
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG2E8FF_V_M1_MASK }, // 72
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG2E8FF_V_M2_MASK }, // 73
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLSEG2E8FF_V_M4_MASK }, // 74
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG2E8FF_V_MF8_MASK }, // 75
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG2E8FF_V_MF4_MASK }, // 76
  { 0x2, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG2E8FF_V_MF2_MASK }, // 77
  { 0x2, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG2E16FF_V_M1_MASK }, // 78
  { 0x2, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG2E16FF_V_M2_MASK }, // 79
  { 0x2, 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLSEG2E16FF_V_M4_MASK }, // 80
  { 0x2, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG2E16FF_V_MF4_MASK }, // 81
  { 0x2, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG2E16FF_V_MF2_MASK }, // 82
  { 0x2, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG2E32FF_V_M1_MASK }, // 83
  { 0x2, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG2E32FF_V_M2_MASK }, // 84
  { 0x2, 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLSEG2E32FF_V_M4_MASK }, // 85
  { 0x2, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG2E32FF_V_MF2_MASK }, // 86
  { 0x2, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG2E64FF_V_M1_MASK }, // 87
  { 0x2, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG2E64FF_V_M2_MASK }, // 88
  { 0x2, 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLSEG2E64FF_V_M4_MASK }, // 89
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG2E8_V_M1_MASK }, // 90
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG2E8_V_M2_MASK }, // 91
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSSEG2E8_V_M4_MASK }, // 92
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG2E8_V_MF8_MASK }, // 93
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG2E8_V_MF4_MASK }, // 94
  { 0x2, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG2E8_V_MF2_MASK }, // 95
  { 0x2, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG2E16_V_M1_MASK }, // 96
  { 0x2, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG2E16_V_M2_MASK }, // 97
  { 0x2, 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSSEG2E16_V_M4_MASK }, // 98
  { 0x2, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG2E16_V_MF4_MASK }, // 99
  { 0x2, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG2E16_V_MF2_MASK }, // 100
  { 0x2, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG2E32_V_M1_MASK }, // 101
  { 0x2, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG2E32_V_M2_MASK }, // 102
  { 0x2, 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSSEG2E32_V_M4_MASK }, // 103
  { 0x2, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG2E32_V_MF2_MASK }, // 104
  { 0x2, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG2E64_V_M1_MASK }, // 105
  { 0x2, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG2E64_V_M2_MASK }, // 106
  { 0x2, 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSSEG2E64_V_M4_MASK }, // 107
  { 0x3, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG3E8_V_M1 }, // 108
  { 0x3, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG3E8_V_M2 }, // 109
  { 0x3, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG3E8_V_MF8 }, // 110
  { 0x3, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG3E8_V_MF4 }, // 111
  { 0x3, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG3E8_V_MF2 }, // 112
  { 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG3E16_V_M1 }, // 113
  { 0x3, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG3E16_V_M2 }, // 114
  { 0x3, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG3E16_V_MF4 }, // 115
  { 0x3, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG3E16_V_MF2 }, // 116
  { 0x3, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG3E32_V_M1 }, // 117
  { 0x3, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG3E32_V_M2 }, // 118
  { 0x3, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG3E32_V_MF2 }, // 119
  { 0x3, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG3E64_V_M1 }, // 120
  { 0x3, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG3E64_V_M2 }, // 121
  { 0x3, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG3E8FF_V_M1 }, // 122
  { 0x3, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG3E8FF_V_M2 }, // 123
  { 0x3, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG3E8FF_V_MF8 }, // 124
  { 0x3, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG3E8FF_V_MF4 }, // 125
  { 0x3, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG3E8FF_V_MF2 }, // 126
  { 0x3, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG3E16FF_V_M1 }, // 127
  { 0x3, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG3E16FF_V_M2 }, // 128
  { 0x3, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG3E16FF_V_MF4 }, // 129
  { 0x3, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG3E16FF_V_MF2 }, // 130
  { 0x3, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG3E32FF_V_M1 }, // 131
  { 0x3, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG3E32FF_V_M2 }, // 132
  { 0x3, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG3E32FF_V_MF2 }, // 133
  { 0x3, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG3E64FF_V_M1 }, // 134
  { 0x3, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG3E64FF_V_M2 }, // 135
  { 0x3, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG3E8_V_M1 }, // 136
  { 0x3, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG3E8_V_M2 }, // 137
  { 0x3, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG3E8_V_MF8 }, // 138
  { 0x3, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG3E8_V_MF4 }, // 139
  { 0x3, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG3E8_V_MF2 }, // 140
  { 0x3, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG3E16_V_M1 }, // 141
  { 0x3, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG3E16_V_M2 }, // 142
  { 0x3, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG3E16_V_MF4 }, // 143
  { 0x3, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG3E16_V_MF2 }, // 144
  { 0x3, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG3E32_V_M1 }, // 145
  { 0x3, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG3E32_V_M2 }, // 146
  { 0x3, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG3E32_V_MF2 }, // 147
  { 0x3, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG3E64_V_M1 }, // 148
  { 0x3, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG3E64_V_M2 }, // 149
  { 0x3, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG3E8_V_M1_MASK }, // 150
  { 0x3, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG3E8_V_M2_MASK }, // 151
  { 0x3, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG3E8_V_MF8_MASK }, // 152
  { 0x3, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG3E8_V_MF4_MASK }, // 153
  { 0x3, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG3E8_V_MF2_MASK }, // 154
  { 0x3, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG3E16_V_M1_MASK }, // 155
  { 0x3, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG3E16_V_M2_MASK }, // 156
  { 0x3, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG3E16_V_MF4_MASK }, // 157
  { 0x3, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG3E16_V_MF2_MASK }, // 158
  { 0x3, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG3E32_V_M1_MASK }, // 159
  { 0x3, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG3E32_V_M2_MASK }, // 160
  { 0x3, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG3E32_V_MF2_MASK }, // 161
  { 0x3, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG3E64_V_M1_MASK }, // 162
  { 0x3, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG3E64_V_M2_MASK }, // 163
  { 0x3, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG3E8FF_V_M1_MASK }, // 164
  { 0x3, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG3E8FF_V_M2_MASK }, // 165
  { 0x3, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG3E8FF_V_MF8_MASK }, // 166
  { 0x3, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG3E8FF_V_MF4_MASK }, // 167
  { 0x3, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG3E8FF_V_MF2_MASK }, // 168
  { 0x3, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG3E16FF_V_M1_MASK }, // 169
  { 0x3, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG3E16FF_V_M2_MASK }, // 170
  { 0x3, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG3E16FF_V_MF4_MASK }, // 171
  { 0x3, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG3E16FF_V_MF2_MASK }, // 172
  { 0x3, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG3E32FF_V_M1_MASK }, // 173
  { 0x3, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG3E32FF_V_M2_MASK }, // 174
  { 0x3, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG3E32FF_V_MF2_MASK }, // 175
  { 0x3, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG3E64FF_V_M1_MASK }, // 176
  { 0x3, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG3E64FF_V_M2_MASK }, // 177
  { 0x3, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG3E8_V_M1_MASK }, // 178
  { 0x3, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG3E8_V_M2_MASK }, // 179
  { 0x3, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG3E8_V_MF8_MASK }, // 180
  { 0x3, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG3E8_V_MF4_MASK }, // 181
  { 0x3, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG3E8_V_MF2_MASK }, // 182
  { 0x3, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG3E16_V_M1_MASK }, // 183
  { 0x3, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG3E16_V_M2_MASK }, // 184
  { 0x3, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG3E16_V_MF4_MASK }, // 185
  { 0x3, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG3E16_V_MF2_MASK }, // 186
  { 0x3, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG3E32_V_M1_MASK }, // 187
  { 0x3, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG3E32_V_M2_MASK }, // 188
  { 0x3, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG3E32_V_MF2_MASK }, // 189
  { 0x3, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG3E64_V_M1_MASK }, // 190
  { 0x3, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG3E64_V_M2_MASK }, // 191
  { 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG4E8_V_M1 }, // 192
  { 0x4, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG4E8_V_M2 }, // 193
  { 0x4, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG4E8_V_MF8 }, // 194
  { 0x4, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG4E8_V_MF4 }, // 195
  { 0x4, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG4E8_V_MF2 }, // 196
  { 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG4E16_V_M1 }, // 197
  { 0x4, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG4E16_V_M2 }, // 198
  { 0x4, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG4E16_V_MF4 }, // 199
  { 0x4, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG4E16_V_MF2 }, // 200
  { 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG4E32_V_M1 }, // 201
  { 0x4, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG4E32_V_M2 }, // 202
  { 0x4, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG4E32_V_MF2 }, // 203
  { 0x4, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG4E64_V_M1 }, // 204
  { 0x4, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG4E64_V_M2 }, // 205
  { 0x4, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG4E8FF_V_M1 }, // 206
  { 0x4, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG4E8FF_V_M2 }, // 207
  { 0x4, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG4E8FF_V_MF8 }, // 208
  { 0x4, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG4E8FF_V_MF4 }, // 209
  { 0x4, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG4E8FF_V_MF2 }, // 210
  { 0x4, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG4E16FF_V_M1 }, // 211
  { 0x4, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG4E16FF_V_M2 }, // 212
  { 0x4, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG4E16FF_V_MF4 }, // 213
  { 0x4, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG4E16FF_V_MF2 }, // 214
  { 0x4, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG4E32FF_V_M1 }, // 215
  { 0x4, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG4E32FF_V_M2 }, // 216
  { 0x4, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG4E32FF_V_MF2 }, // 217
  { 0x4, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG4E64FF_V_M1 }, // 218
  { 0x4, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG4E64FF_V_M2 }, // 219
  { 0x4, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG4E8_V_M1 }, // 220
  { 0x4, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG4E8_V_M2 }, // 221
  { 0x4, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG4E8_V_MF8 }, // 222
  { 0x4, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG4E8_V_MF4 }, // 223
  { 0x4, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG4E8_V_MF2 }, // 224
  { 0x4, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG4E16_V_M1 }, // 225
  { 0x4, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG4E16_V_M2 }, // 226
  { 0x4, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG4E16_V_MF4 }, // 227
  { 0x4, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG4E16_V_MF2 }, // 228
  { 0x4, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG4E32_V_M1 }, // 229
  { 0x4, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG4E32_V_M2 }, // 230
  { 0x4, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG4E32_V_MF2 }, // 231
  { 0x4, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG4E64_V_M1 }, // 232
  { 0x4, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG4E64_V_M2 }, // 233
  { 0x4, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG4E8_V_M1_MASK }, // 234
  { 0x4, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG4E8_V_M2_MASK }, // 235
  { 0x4, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG4E8_V_MF8_MASK }, // 236
  { 0x4, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG4E8_V_MF4_MASK }, // 237
  { 0x4, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG4E8_V_MF2_MASK }, // 238
  { 0x4, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG4E16_V_M1_MASK }, // 239
  { 0x4, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG4E16_V_M2_MASK }, // 240
  { 0x4, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG4E16_V_MF4_MASK }, // 241
  { 0x4, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG4E16_V_MF2_MASK }, // 242
  { 0x4, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG4E32_V_M1_MASK }, // 243
  { 0x4, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG4E32_V_M2_MASK }, // 244
  { 0x4, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG4E32_V_MF2_MASK }, // 245
  { 0x4, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG4E64_V_M1_MASK }, // 246
  { 0x4, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG4E64_V_M2_MASK }, // 247
  { 0x4, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG4E8FF_V_M1_MASK }, // 248
  { 0x4, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG4E8FF_V_M2_MASK }, // 249
  { 0x4, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG4E8FF_V_MF8_MASK }, // 250
  { 0x4, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG4E8FF_V_MF4_MASK }, // 251
  { 0x4, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG4E8FF_V_MF2_MASK }, // 252
  { 0x4, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG4E16FF_V_M1_MASK }, // 253
  { 0x4, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG4E16FF_V_M2_MASK }, // 254
  { 0x4, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG4E16FF_V_MF4_MASK }, // 255
  { 0x4, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG4E16FF_V_MF2_MASK }, // 256
  { 0x4, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG4E32FF_V_M1_MASK }, // 257
  { 0x4, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG4E32FF_V_M2_MASK }, // 258
  { 0x4, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG4E32FF_V_MF2_MASK }, // 259
  { 0x4, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG4E64FF_V_M1_MASK }, // 260
  { 0x4, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG4E64FF_V_M2_MASK }, // 261
  { 0x4, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG4E8_V_M1_MASK }, // 262
  { 0x4, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG4E8_V_M2_MASK }, // 263
  { 0x4, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG4E8_V_MF8_MASK }, // 264
  { 0x4, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG4E8_V_MF4_MASK }, // 265
  { 0x4, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG4E8_V_MF2_MASK }, // 266
  { 0x4, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG4E16_V_M1_MASK }, // 267
  { 0x4, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG4E16_V_M2_MASK }, // 268
  { 0x4, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG4E16_V_MF4_MASK }, // 269
  { 0x4, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG4E16_V_MF2_MASK }, // 270
  { 0x4, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG4E32_V_M1_MASK }, // 271
  { 0x4, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG4E32_V_M2_MASK }, // 272
  { 0x4, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG4E32_V_MF2_MASK }, // 273
  { 0x4, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG4E64_V_M1_MASK }, // 274
  { 0x4, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG4E64_V_M2_MASK }, // 275
  { 0x5, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG5E8_V_M1 }, // 276
  { 0x5, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG5E8_V_MF8 }, // 277
  { 0x5, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG5E8_V_MF4 }, // 278
  { 0x5, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG5E8_V_MF2 }, // 279
  { 0x5, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG5E16_V_M1 }, // 280
  { 0x5, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG5E16_V_MF4 }, // 281
  { 0x5, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG5E16_V_MF2 }, // 282
  { 0x5, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG5E32_V_M1 }, // 283
  { 0x5, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG5E32_V_MF2 }, // 284
  { 0x5, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG5E64_V_M1 }, // 285
  { 0x5, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG5E8FF_V_M1 }, // 286
  { 0x5, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG5E8FF_V_MF8 }, // 287
  { 0x5, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG5E8FF_V_MF4 }, // 288
  { 0x5, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG5E8FF_V_MF2 }, // 289
  { 0x5, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG5E16FF_V_M1 }, // 290
  { 0x5, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG5E16FF_V_MF4 }, // 291
  { 0x5, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG5E16FF_V_MF2 }, // 292
  { 0x5, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG5E32FF_V_M1 }, // 293
  { 0x5, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG5E32FF_V_MF2 }, // 294
  { 0x5, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG5E64FF_V_M1 }, // 295
  { 0x5, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG5E8_V_M1 }, // 296
  { 0x5, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG5E8_V_MF8 }, // 297
  { 0x5, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG5E8_V_MF4 }, // 298
  { 0x5, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG5E8_V_MF2 }, // 299
  { 0x5, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG5E16_V_M1 }, // 300
  { 0x5, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG5E16_V_MF4 }, // 301
  { 0x5, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG5E16_V_MF2 }, // 302
  { 0x5, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG5E32_V_M1 }, // 303
  { 0x5, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG5E32_V_MF2 }, // 304
  { 0x5, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG5E64_V_M1 }, // 305
  { 0x5, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG5E8_V_M1_MASK }, // 306
  { 0x5, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG5E8_V_MF8_MASK }, // 307
  { 0x5, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG5E8_V_MF4_MASK }, // 308
  { 0x5, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG5E8_V_MF2_MASK }, // 309
  { 0x5, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG5E16_V_M1_MASK }, // 310
  { 0x5, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG5E16_V_MF4_MASK }, // 311
  { 0x5, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG5E16_V_MF2_MASK }, // 312
  { 0x5, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG5E32_V_M1_MASK }, // 313
  { 0x5, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG5E32_V_MF2_MASK }, // 314
  { 0x5, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG5E64_V_M1_MASK }, // 315
  { 0x5, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG5E8FF_V_M1_MASK }, // 316
  { 0x5, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG5E8FF_V_MF8_MASK }, // 317
  { 0x5, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG5E8FF_V_MF4_MASK }, // 318
  { 0x5, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG5E8FF_V_MF2_MASK }, // 319
  { 0x5, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG5E16FF_V_M1_MASK }, // 320
  { 0x5, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG5E16FF_V_MF4_MASK }, // 321
  { 0x5, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG5E16FF_V_MF2_MASK }, // 322
  { 0x5, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG5E32FF_V_M1_MASK }, // 323
  { 0x5, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG5E32FF_V_MF2_MASK }, // 324
  { 0x5, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG5E64FF_V_M1_MASK }, // 325
  { 0x5, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG5E8_V_M1_MASK }, // 326
  { 0x5, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG5E8_V_MF8_MASK }, // 327
  { 0x5, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG5E8_V_MF4_MASK }, // 328
  { 0x5, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG5E8_V_MF2_MASK }, // 329
  { 0x5, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG5E16_V_M1_MASK }, // 330
  { 0x5, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG5E16_V_MF4_MASK }, // 331
  { 0x5, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG5E16_V_MF2_MASK }, // 332
  { 0x5, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG5E32_V_M1_MASK }, // 333
  { 0x5, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG5E32_V_MF2_MASK }, // 334
  { 0x5, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG5E64_V_M1_MASK }, // 335
  { 0x6, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG6E8_V_M1 }, // 336
  { 0x6, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG6E8_V_MF8 }, // 337
  { 0x6, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG6E8_V_MF4 }, // 338
  { 0x6, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG6E8_V_MF2 }, // 339
  { 0x6, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG6E16_V_M1 }, // 340
  { 0x6, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG6E16_V_MF4 }, // 341
  { 0x6, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG6E16_V_MF2 }, // 342
  { 0x6, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG6E32_V_M1 }, // 343
  { 0x6, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG6E32_V_MF2 }, // 344
  { 0x6, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG6E64_V_M1 }, // 345
  { 0x6, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG6E8FF_V_M1 }, // 346
  { 0x6, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG6E8FF_V_MF8 }, // 347
  { 0x6, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG6E8FF_V_MF4 }, // 348
  { 0x6, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG6E8FF_V_MF2 }, // 349
  { 0x6, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG6E16FF_V_M1 }, // 350
  { 0x6, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG6E16FF_V_MF4 }, // 351
  { 0x6, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG6E16FF_V_MF2 }, // 352
  { 0x6, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG6E32FF_V_M1 }, // 353
  { 0x6, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG6E32FF_V_MF2 }, // 354
  { 0x6, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG6E64FF_V_M1 }, // 355
  { 0x6, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG6E8_V_M1 }, // 356
  { 0x6, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG6E8_V_MF8 }, // 357
  { 0x6, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG6E8_V_MF4 }, // 358
  { 0x6, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG6E8_V_MF2 }, // 359
  { 0x6, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG6E16_V_M1 }, // 360
  { 0x6, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG6E16_V_MF4 }, // 361
  { 0x6, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG6E16_V_MF2 }, // 362
  { 0x6, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG6E32_V_M1 }, // 363
  { 0x6, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG6E32_V_MF2 }, // 364
  { 0x6, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG6E64_V_M1 }, // 365
  { 0x6, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG6E8_V_M1_MASK }, // 366
  { 0x6, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG6E8_V_MF8_MASK }, // 367
  { 0x6, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG6E8_V_MF4_MASK }, // 368
  { 0x6, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG6E8_V_MF2_MASK }, // 369
  { 0x6, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG6E16_V_M1_MASK }, // 370
  { 0x6, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG6E16_V_MF4_MASK }, // 371
  { 0x6, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG6E16_V_MF2_MASK }, // 372
  { 0x6, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG6E32_V_M1_MASK }, // 373
  { 0x6, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG6E32_V_MF2_MASK }, // 374
  { 0x6, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG6E64_V_M1_MASK }, // 375
  { 0x6, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG6E8FF_V_M1_MASK }, // 376
  { 0x6, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG6E8FF_V_MF8_MASK }, // 377
  { 0x6, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG6E8FF_V_MF4_MASK }, // 378
  { 0x6, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG6E8FF_V_MF2_MASK }, // 379
  { 0x6, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG6E16FF_V_M1_MASK }, // 380
  { 0x6, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG6E16FF_V_MF4_MASK }, // 381
  { 0x6, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG6E16FF_V_MF2_MASK }, // 382
  { 0x6, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG6E32FF_V_M1_MASK }, // 383
  { 0x6, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG6E32FF_V_MF2_MASK }, // 384
  { 0x6, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG6E64FF_V_M1_MASK }, // 385
  { 0x6, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG6E8_V_M1_MASK }, // 386
  { 0x6, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG6E8_V_MF8_MASK }, // 387
  { 0x6, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG6E8_V_MF4_MASK }, // 388
  { 0x6, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG6E8_V_MF2_MASK }, // 389
  { 0x6, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG6E16_V_M1_MASK }, // 390
  { 0x6, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG6E16_V_MF4_MASK }, // 391
  { 0x6, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG6E16_V_MF2_MASK }, // 392
  { 0x6, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG6E32_V_M1_MASK }, // 393
  { 0x6, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG6E32_V_MF2_MASK }, // 394
  { 0x6, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG6E64_V_M1_MASK }, // 395
  { 0x7, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG7E8_V_M1 }, // 396
  { 0x7, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG7E8_V_MF8 }, // 397
  { 0x7, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG7E8_V_MF4 }, // 398
  { 0x7, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG7E8_V_MF2 }, // 399
  { 0x7, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG7E16_V_M1 }, // 400
  { 0x7, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG7E16_V_MF4 }, // 401
  { 0x7, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG7E16_V_MF2 }, // 402
  { 0x7, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG7E32_V_M1 }, // 403
  { 0x7, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG7E32_V_MF2 }, // 404
  { 0x7, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG7E64_V_M1 }, // 405
  { 0x7, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG7E8FF_V_M1 }, // 406
  { 0x7, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG7E8FF_V_MF8 }, // 407
  { 0x7, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG7E8FF_V_MF4 }, // 408
  { 0x7, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG7E8FF_V_MF2 }, // 409
  { 0x7, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG7E16FF_V_M1 }, // 410
  { 0x7, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG7E16FF_V_MF4 }, // 411
  { 0x7, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG7E16FF_V_MF2 }, // 412
  { 0x7, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG7E32FF_V_M1 }, // 413
  { 0x7, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG7E32FF_V_MF2 }, // 414
  { 0x7, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG7E64FF_V_M1 }, // 415
  { 0x7, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG7E8_V_M1 }, // 416
  { 0x7, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG7E8_V_MF8 }, // 417
  { 0x7, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG7E8_V_MF4 }, // 418
  { 0x7, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG7E8_V_MF2 }, // 419
  { 0x7, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG7E16_V_M1 }, // 420
  { 0x7, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG7E16_V_MF4 }, // 421
  { 0x7, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG7E16_V_MF2 }, // 422
  { 0x7, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG7E32_V_M1 }, // 423
  { 0x7, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG7E32_V_MF2 }, // 424
  { 0x7, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG7E64_V_M1 }, // 425
  { 0x7, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG7E8_V_M1_MASK }, // 426
  { 0x7, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG7E8_V_MF8_MASK }, // 427
  { 0x7, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG7E8_V_MF4_MASK }, // 428
  { 0x7, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG7E8_V_MF2_MASK }, // 429
  { 0x7, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG7E16_V_M1_MASK }, // 430
  { 0x7, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG7E16_V_MF4_MASK }, // 431
  { 0x7, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG7E16_V_MF2_MASK }, // 432
  { 0x7, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG7E32_V_M1_MASK }, // 433
  { 0x7, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG7E32_V_MF2_MASK }, // 434
  { 0x7, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG7E64_V_M1_MASK }, // 435
  { 0x7, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG7E8FF_V_M1_MASK }, // 436
  { 0x7, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG7E8FF_V_MF8_MASK }, // 437
  { 0x7, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG7E8FF_V_MF4_MASK }, // 438
  { 0x7, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG7E8FF_V_MF2_MASK }, // 439
  { 0x7, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG7E16FF_V_M1_MASK }, // 440
  { 0x7, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG7E16FF_V_MF4_MASK }, // 441
  { 0x7, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG7E16FF_V_MF2_MASK }, // 442
  { 0x7, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG7E32FF_V_M1_MASK }, // 443
  { 0x7, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG7E32FF_V_MF2_MASK }, // 444
  { 0x7, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG7E64FF_V_M1_MASK }, // 445
  { 0x7, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG7E8_V_M1_MASK }, // 446
  { 0x7, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG7E8_V_MF8_MASK }, // 447
  { 0x7, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG7E8_V_MF4_MASK }, // 448
  { 0x7, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG7E8_V_MF2_MASK }, // 449
  { 0x7, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG7E16_V_M1_MASK }, // 450
  { 0x7, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG7E16_V_MF4_MASK }, // 451
  { 0x7, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG7E16_V_MF2_MASK }, // 452
  { 0x7, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG7E32_V_M1_MASK }, // 453
  { 0x7, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG7E32_V_MF2_MASK }, // 454
  { 0x7, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG7E64_V_M1_MASK }, // 455
  { 0x8, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG8E8_V_M1 }, // 456
  { 0x8, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG8E8_V_MF8 }, // 457
  { 0x8, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG8E8_V_MF4 }, // 458
  { 0x8, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG8E8_V_MF2 }, // 459
  { 0x8, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG8E16_V_M1 }, // 460
  { 0x8, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG8E16_V_MF4 }, // 461
  { 0x8, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG8E16_V_MF2 }, // 462
  { 0x8, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG8E32_V_M1 }, // 463
  { 0x8, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG8E32_V_MF2 }, // 464
  { 0x8, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG8E64_V_M1 }, // 465
  { 0x8, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG8E8FF_V_M1 }, // 466
  { 0x8, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG8E8FF_V_MF8 }, // 467
  { 0x8, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG8E8FF_V_MF4 }, // 468
  { 0x8, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG8E8FF_V_MF2 }, // 469
  { 0x8, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG8E16FF_V_M1 }, // 470
  { 0x8, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG8E16FF_V_MF4 }, // 471
  { 0x8, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG8E16FF_V_MF2 }, // 472
  { 0x8, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG8E32FF_V_M1 }, // 473
  { 0x8, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG8E32FF_V_MF2 }, // 474
  { 0x8, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG8E64FF_V_M1 }, // 475
  { 0x8, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG8E8_V_M1 }, // 476
  { 0x8, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG8E8_V_MF8 }, // 477
  { 0x8, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG8E8_V_MF4 }, // 478
  { 0x8, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG8E8_V_MF2 }, // 479
  { 0x8, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG8E16_V_M1 }, // 480
  { 0x8, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG8E16_V_MF4 }, // 481
  { 0x8, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG8E16_V_MF2 }, // 482
  { 0x8, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG8E32_V_M1 }, // 483
  { 0x8, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG8E32_V_MF2 }, // 484
  { 0x8, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG8E64_V_M1 }, // 485
  { 0x8, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG8E8_V_M1_MASK }, // 486
  { 0x8, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG8E8_V_MF8_MASK }, // 487
  { 0x8, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG8E8_V_MF4_MASK }, // 488
  { 0x8, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG8E8_V_MF2_MASK }, // 489
  { 0x8, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG8E16_V_M1_MASK }, // 490
  { 0x8, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG8E16_V_MF4_MASK }, // 491
  { 0x8, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG8E16_V_MF2_MASK }, // 492
  { 0x8, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG8E32_V_M1_MASK }, // 493
  { 0x8, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG8E32_V_MF2_MASK }, // 494
  { 0x8, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG8E64_V_M1_MASK }, // 495
  { 0x8, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG8E8FF_V_M1_MASK }, // 496
  { 0x8, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG8E8FF_V_MF8_MASK }, // 497
  { 0x8, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG8E8FF_V_MF4_MASK }, // 498
  { 0x8, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG8E8FF_V_MF2_MASK }, // 499
  { 0x8, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG8E16FF_V_M1_MASK }, // 500
  { 0x8, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG8E16FF_V_MF4_MASK }, // 501
  { 0x8, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG8E16FF_V_MF2_MASK }, // 502
  { 0x8, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG8E32FF_V_M1_MASK }, // 503
  { 0x8, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG8E32FF_V_MF2_MASK }, // 504
  { 0x8, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG8E64FF_V_M1_MASK }, // 505
  { 0x8, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG8E8_V_M1_MASK }, // 506
  { 0x8, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG8E8_V_MF8_MASK }, // 507
  { 0x8, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG8E8_V_MF4_MASK }, // 508
  { 0x8, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG8E8_V_MF2_MASK }, // 509
  { 0x8, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG8E16_V_M1_MASK }, // 510
  { 0x8, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG8E16_V_MF4_MASK }, // 511
  { 0x8, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG8E16_V_MF2_MASK }, // 512
  { 0x8, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG8E32_V_M1_MASK }, // 513
  { 0x8, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG8E32_V_MF2_MASK }, // 514
  { 0x8, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG8E64_V_M1_MASK }, // 515
 };

const VLSEGPseudo *getVLSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL) {
  struct KeyType {
    uint8_t NF;
    uint8_t Masked;
    uint8_t Strided;
    uint8_t FF;
    uint8_t Log2SEW;
    uint8_t LMUL;
  };
  KeyType Key = {NF, Masked, Strided, FF, Log2SEW, LMUL};
  auto Table = ArrayRef(RISCVVLSEGTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const VLSEGPseudo &LHS, const KeyType &RHS) {
      if (LHS.NF < RHS.NF)
        return true;
      if (LHS.NF > RHS.NF)
        return false;
      if (LHS.Masked < RHS.Masked)
        return true;
      if (LHS.Masked > RHS.Masked)
        return false;
      if (LHS.Strided < RHS.Strided)
        return true;
      if (LHS.Strided > RHS.Strided)
        return false;
      if (LHS.FF < RHS.FF)
        return true;
      if (LHS.FF > RHS.FF)
        return false;
      if (LHS.Log2SEW < RHS.Log2SEW)
        return true;
      if (LHS.Log2SEW > RHS.Log2SEW)
        return false;
      if (LHS.LMUL < RHS.LMUL)
        return true;
      if (LHS.LMUL > RHS.LMUL)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.NF != Idx->NF ||
      Key.Masked != Idx->Masked ||
      Key.Strided != Idx->Strided ||
      Key.FF != Idx->FF ||
      Key.Log2SEW != Idx->Log2SEW ||
      Key.LMUL != Idx->LMUL)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLXSEGTable_DECL
const VLXSEGPseudo *getVLXSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t Ordered, uint8_t Log2SEW, uint8_t LMUL, uint8_t IndexLMUL);
#endif

#ifdef GET_RISCVVLXSEGTable_IMPL
constexpr VLXSEGPseudo RISCVVLXSEGTable[] = {
  { 0x2, 0x0, 0x0, 0x3, 0x0, 0x0, PseudoVLUXSEG2EI8_V_M1_M1 }, // 0
  { 0x2, 0x0, 0x0, 0x3, 0x0, 0x5, PseudoVLUXSEG2EI8_V_MF8_M1 }, // 1
  { 0x2, 0x0, 0x0, 0x3, 0x0, 0x6, PseudoVLUXSEG2EI8_V_MF4_M1 }, // 2
  { 0x2, 0x0, 0x0, 0x3, 0x0, 0x7, PseudoVLUXSEG2EI8_V_MF2_M1 }, // 3
  { 0x2, 0x0, 0x0, 0x3, 0x1, 0x0, PseudoVLUXSEG2EI8_V_M1_M2 }, // 4
  { 0x2, 0x0, 0x0, 0x3, 0x1, 0x1, PseudoVLUXSEG2EI8_V_M2_M2 }, // 5
  { 0x2, 0x0, 0x0, 0x3, 0x1, 0x6, PseudoVLUXSEG2EI8_V_MF4_M2 }, // 6
  { 0x2, 0x0, 0x0, 0x3, 0x1, 0x7, PseudoVLUXSEG2EI8_V_MF2_M2 }, // 7
  { 0x2, 0x0, 0x0, 0x3, 0x2, 0x0, PseudoVLUXSEG2EI8_V_M1_M4 }, // 8
  { 0x2, 0x0, 0x0, 0x3, 0x2, 0x1, PseudoVLUXSEG2EI8_V_M2_M4 }, // 9
  { 0x2, 0x0, 0x0, 0x3, 0x2, 0x2, PseudoVLUXSEG2EI8_V_M4_M4 }, // 10
  { 0x2, 0x0, 0x0, 0x3, 0x2, 0x7, PseudoVLUXSEG2EI8_V_MF2_M4 }, // 11
  { 0x2, 0x0, 0x0, 0x3, 0x5, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF8 }, // 12
  { 0x2, 0x0, 0x0, 0x3, 0x6, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF4 }, // 13
  { 0x2, 0x0, 0x0, 0x3, 0x6, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF4 }, // 14
  { 0x2, 0x0, 0x0, 0x3, 0x7, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF2 }, // 15
  { 0x2, 0x0, 0x0, 0x3, 0x7, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF2 }, // 16
  { 0x2, 0x0, 0x0, 0x3, 0x7, 0x7, PseudoVLUXSEG2EI8_V_MF2_MF2 }, // 17
  { 0x2, 0x0, 0x0, 0x4, 0x0, 0x0, PseudoVLUXSEG2EI16_V_M1_M1 }, // 18
  { 0x2, 0x0, 0x0, 0x4, 0x0, 0x1, PseudoVLUXSEG2EI16_V_M2_M1 }, // 19
  { 0x2, 0x0, 0x0, 0x4, 0x0, 0x6, PseudoVLUXSEG2EI16_V_MF4_M1 }, // 20
  { 0x2, 0x0, 0x0, 0x4, 0x0, 0x7, PseudoVLUXSEG2EI16_V_MF2_M1 }, // 21
  { 0x2, 0x0, 0x0, 0x4, 0x1, 0x0, PseudoVLUXSEG2EI16_V_M1_M2 }, // 22
  { 0x2, 0x0, 0x0, 0x4, 0x1, 0x1, PseudoVLUXSEG2EI16_V_M2_M2 }, // 23
  { 0x2, 0x0, 0x0, 0x4, 0x1, 0x2, PseudoVLUXSEG2EI16_V_M4_M2 }, // 24
  { 0x2, 0x0, 0x0, 0x4, 0x1, 0x7, PseudoVLUXSEG2EI16_V_MF2_M2 }, // 25
  { 0x2, 0x0, 0x0, 0x4, 0x2, 0x0, PseudoVLUXSEG2EI16_V_M1_M4 }, // 26
  { 0x2, 0x0, 0x0, 0x4, 0x2, 0x1, PseudoVLUXSEG2EI16_V_M2_M4 }, // 27
  { 0x2, 0x0, 0x0, 0x4, 0x2, 0x2, PseudoVLUXSEG2EI16_V_M4_M4 }, // 28
  { 0x2, 0x0, 0x0, 0x4, 0x2, 0x3, PseudoVLUXSEG2EI16_V_M8_M4 }, // 29
  { 0x2, 0x0, 0x0, 0x4, 0x5, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF8 }, // 30
  { 0x2, 0x0, 0x0, 0x4, 0x6, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF4 }, // 31
  { 0x2, 0x0, 0x0, 0x4, 0x6, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF4 }, // 32
  { 0x2, 0x0, 0x0, 0x4, 0x7, 0x0, PseudoVLUXSEG2EI16_V_M1_MF2 }, // 33
  { 0x2, 0x0, 0x0, 0x4, 0x7, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF2 }, // 34
  { 0x2, 0x0, 0x0, 0x4, 0x7, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF2 }, // 35
  { 0x2, 0x0, 0x0, 0x5, 0x0, 0x0, PseudoVLUXSEG2EI32_V_M1_M1 }, // 36
  { 0x2, 0x0, 0x0, 0x5, 0x0, 0x1, PseudoVLUXSEG2EI32_V_M2_M1 }, // 37
  { 0x2, 0x0, 0x0, 0x5, 0x0, 0x2, PseudoVLUXSEG2EI32_V_M4_M1 }, // 38
  { 0x2, 0x0, 0x0, 0x5, 0x0, 0x7, PseudoVLUXSEG2EI32_V_MF2_M1 }, // 39
  { 0x2, 0x0, 0x0, 0x5, 0x1, 0x0, PseudoVLUXSEG2EI32_V_M1_M2 }, // 40
  { 0x2, 0x0, 0x0, 0x5, 0x1, 0x1, PseudoVLUXSEG2EI32_V_M2_M2 }, // 41
  { 0x2, 0x0, 0x0, 0x5, 0x1, 0x2, PseudoVLUXSEG2EI32_V_M4_M2 }, // 42
  { 0x2, 0x0, 0x0, 0x5, 0x1, 0x3, PseudoVLUXSEG2EI32_V_M8_M2 }, // 43
  { 0x2, 0x0, 0x0, 0x5, 0x2, 0x1, PseudoVLUXSEG2EI32_V_M2_M4 }, // 44
  { 0x2, 0x0, 0x0, 0x5, 0x2, 0x2, PseudoVLUXSEG2EI32_V_M4_M4 }, // 45
  { 0x2, 0x0, 0x0, 0x5, 0x2, 0x3, PseudoVLUXSEG2EI32_V_M8_M4 }, // 46
  { 0x2, 0x0, 0x0, 0x5, 0x5, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF8 }, // 47
  { 0x2, 0x0, 0x0, 0x5, 0x6, 0x0, PseudoVLUXSEG2EI32_V_M1_MF4 }, // 48
  { 0x2, 0x0, 0x0, 0x5, 0x6, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF4 }, // 49
  { 0x2, 0x0, 0x0, 0x5, 0x7, 0x0, PseudoVLUXSEG2EI32_V_M1_MF2 }, // 50
  { 0x2, 0x0, 0x0, 0x5, 0x7, 0x1, PseudoVLUXSEG2EI32_V_M2_MF2 }, // 51
  { 0x2, 0x0, 0x0, 0x5, 0x7, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF2 }, // 52
  { 0x2, 0x0, 0x0, 0x6, 0x0, 0x0, PseudoVLUXSEG2EI64_V_M1_M1 }, // 53
  { 0x2, 0x0, 0x0, 0x6, 0x0, 0x1, PseudoVLUXSEG2EI64_V_M2_M1 }, // 54
  { 0x2, 0x0, 0x0, 0x6, 0x0, 0x2, PseudoVLUXSEG2EI64_V_M4_M1 }, // 55
  { 0x2, 0x0, 0x0, 0x6, 0x0, 0x3, PseudoVLUXSEG2EI64_V_M8_M1 }, // 56
  { 0x2, 0x0, 0x0, 0x6, 0x1, 0x1, PseudoVLUXSEG2EI64_V_M2_M2 }, // 57
  { 0x2, 0x0, 0x0, 0x6, 0x1, 0x2, PseudoVLUXSEG2EI64_V_M4_M2 }, // 58
  { 0x2, 0x0, 0x0, 0x6, 0x1, 0x3, PseudoVLUXSEG2EI64_V_M8_M2 }, // 59
  { 0x2, 0x0, 0x0, 0x6, 0x2, 0x2, PseudoVLUXSEG2EI64_V_M4_M4 }, // 60
  { 0x2, 0x0, 0x0, 0x6, 0x2, 0x3, PseudoVLUXSEG2EI64_V_M8_M4 }, // 61
  { 0x2, 0x0, 0x0, 0x6, 0x5, 0x0, PseudoVLUXSEG2EI64_V_M1_MF8 }, // 62
  { 0x2, 0x0, 0x0, 0x6, 0x6, 0x0, PseudoVLUXSEG2EI64_V_M1_MF4 }, // 63
  { 0x2, 0x0, 0x0, 0x6, 0x6, 0x1, PseudoVLUXSEG2EI64_V_M2_MF4 }, // 64
  { 0x2, 0x0, 0x0, 0x6, 0x7, 0x0, PseudoVLUXSEG2EI64_V_M1_MF2 }, // 65
  { 0x2, 0x0, 0x0, 0x6, 0x7, 0x1, PseudoVLUXSEG2EI64_V_M2_MF2 }, // 66
  { 0x2, 0x0, 0x0, 0x6, 0x7, 0x2, PseudoVLUXSEG2EI64_V_M4_MF2 }, // 67
  { 0x2, 0x0, 0x1, 0x3, 0x0, 0x0, PseudoVLOXSEG2EI8_V_M1_M1 }, // 68
  { 0x2, 0x0, 0x1, 0x3, 0x0, 0x5, PseudoVLOXSEG2EI8_V_MF8_M1 }, // 69
  { 0x2, 0x0, 0x1, 0x3, 0x0, 0x6, PseudoVLOXSEG2EI8_V_MF4_M1 }, // 70
  { 0x2, 0x0, 0x1, 0x3, 0x0, 0x7, PseudoVLOXSEG2EI8_V_MF2_M1 }, // 71
  { 0x2, 0x0, 0x1, 0x3, 0x1, 0x0, PseudoVLOXSEG2EI8_V_M1_M2 }, // 72
  { 0x2, 0x0, 0x1, 0x3, 0x1, 0x1, PseudoVLOXSEG2EI8_V_M2_M2 }, // 73
  { 0x2, 0x0, 0x1, 0x3, 0x1, 0x6, PseudoVLOXSEG2EI8_V_MF4_M2 }, // 74
  { 0x2, 0x0, 0x1, 0x3, 0x1, 0x7, PseudoVLOXSEG2EI8_V_MF2_M2 }, // 75
  { 0x2, 0x0, 0x1, 0x3, 0x2, 0x0, PseudoVLOXSEG2EI8_V_M1_M4 }, // 76
  { 0x2, 0x0, 0x1, 0x3, 0x2, 0x1, PseudoVLOXSEG2EI8_V_M2_M4 }, // 77
  { 0x2, 0x0, 0x1, 0x3, 0x2, 0x2, PseudoVLOXSEG2EI8_V_M4_M4 }, // 78
  { 0x2, 0x0, 0x1, 0x3, 0x2, 0x7, PseudoVLOXSEG2EI8_V_MF2_M4 }, // 79
  { 0x2, 0x0, 0x1, 0x3, 0x5, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF8 }, // 80
  { 0x2, 0x0, 0x1, 0x3, 0x6, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF4 }, // 81
  { 0x2, 0x0, 0x1, 0x3, 0x6, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF4 }, // 82
  { 0x2, 0x0, 0x1, 0x3, 0x7, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF2 }, // 83
  { 0x2, 0x0, 0x1, 0x3, 0x7, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF2 }, // 84
  { 0x2, 0x0, 0x1, 0x3, 0x7, 0x7, PseudoVLOXSEG2EI8_V_MF2_MF2 }, // 85
  { 0x2, 0x0, 0x1, 0x4, 0x0, 0x0, PseudoVLOXSEG2EI16_V_M1_M1 }, // 86
  { 0x2, 0x0, 0x1, 0x4, 0x0, 0x1, PseudoVLOXSEG2EI16_V_M2_M1 }, // 87
  { 0x2, 0x0, 0x1, 0x4, 0x0, 0x6, PseudoVLOXSEG2EI16_V_MF4_M1 }, // 88
  { 0x2, 0x0, 0x1, 0x4, 0x0, 0x7, PseudoVLOXSEG2EI16_V_MF2_M1 }, // 89
  { 0x2, 0x0, 0x1, 0x4, 0x1, 0x0, PseudoVLOXSEG2EI16_V_M1_M2 }, // 90
  { 0x2, 0x0, 0x1, 0x4, 0x1, 0x1, PseudoVLOXSEG2EI16_V_M2_M2 }, // 91
  { 0x2, 0x0, 0x1, 0x4, 0x1, 0x2, PseudoVLOXSEG2EI16_V_M4_M2 }, // 92
  { 0x2, 0x0, 0x1, 0x4, 0x1, 0x7, PseudoVLOXSEG2EI16_V_MF2_M2 }, // 93
  { 0x2, 0x0, 0x1, 0x4, 0x2, 0x0, PseudoVLOXSEG2EI16_V_M1_M4 }, // 94
  { 0x2, 0x0, 0x1, 0x4, 0x2, 0x1, PseudoVLOXSEG2EI16_V_M2_M4 }, // 95
  { 0x2, 0x0, 0x1, 0x4, 0x2, 0x2, PseudoVLOXSEG2EI16_V_M4_M4 }, // 96
  { 0x2, 0x0, 0x1, 0x4, 0x2, 0x3, PseudoVLOXSEG2EI16_V_M8_M4 }, // 97
  { 0x2, 0x0, 0x1, 0x4, 0x5, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF8 }, // 98
  { 0x2, 0x0, 0x1, 0x4, 0x6, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF4 }, // 99
  { 0x2, 0x0, 0x1, 0x4, 0x6, 0x7, PseudoVLOXSEG2EI16_V_MF2_MF4 }, // 100
  { 0x2, 0x0, 0x1, 0x4, 0x7, 0x0, PseudoVLOXSEG2EI16_V_M1_MF2 }, // 101
  { 0x2, 0x0, 0x1, 0x4, 0x7, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF2 }, // 102
  { 0x2, 0x0, 0x1, 0x4, 0x7, 0x7, PseudoVLOXSEG2EI16_V_MF2_MF2 }, // 103
  { 0x2, 0x0, 0x1, 0x5, 0x0, 0x0, PseudoVLOXSEG2EI32_V_M1_M1 }, // 104
  { 0x2, 0x0, 0x1, 0x5, 0x0, 0x1, PseudoVLOXSEG2EI32_V_M2_M1 }, // 105
  { 0x2, 0x0, 0x1, 0x5, 0x0, 0x2, PseudoVLOXSEG2EI32_V_M4_M1 }, // 106
  { 0x2, 0x0, 0x1, 0x5, 0x0, 0x7, PseudoVLOXSEG2EI32_V_MF2_M1 }, // 107
  { 0x2, 0x0, 0x1, 0x5, 0x1, 0x0, PseudoVLOXSEG2EI32_V_M1_M2 }, // 108
  { 0x2, 0x0, 0x1, 0x5, 0x1, 0x1, PseudoVLOXSEG2EI32_V_M2_M2 }, // 109
  { 0x2, 0x0, 0x1, 0x5, 0x1, 0x2, PseudoVLOXSEG2EI32_V_M4_M2 }, // 110
  { 0x2, 0x0, 0x1, 0x5, 0x1, 0x3, PseudoVLOXSEG2EI32_V_M8_M2 }, // 111
  { 0x2, 0x0, 0x1, 0x5, 0x2, 0x1, PseudoVLOXSEG2EI32_V_M2_M4 }, // 112
  { 0x2, 0x0, 0x1, 0x5, 0x2, 0x2, PseudoVLOXSEG2EI32_V_M4_M4 }, // 113
  { 0x2, 0x0, 0x1, 0x5, 0x2, 0x3, PseudoVLOXSEG2EI32_V_M8_M4 }, // 114
  { 0x2, 0x0, 0x1, 0x5, 0x5, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF8 }, // 115
  { 0x2, 0x0, 0x1, 0x5, 0x6, 0x0, PseudoVLOXSEG2EI32_V_M1_MF4 }, // 116
  { 0x2, 0x0, 0x1, 0x5, 0x6, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF4 }, // 117
  { 0x2, 0x0, 0x1, 0x5, 0x7, 0x0, PseudoVLOXSEG2EI32_V_M1_MF2 }, // 118
  { 0x2, 0x0, 0x1, 0x5, 0x7, 0x1, PseudoVLOXSEG2EI32_V_M2_MF2 }, // 119
  { 0x2, 0x0, 0x1, 0x5, 0x7, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF2 }, // 120
  { 0x2, 0x0, 0x1, 0x6, 0x0, 0x0, PseudoVLOXSEG2EI64_V_M1_M1 }, // 121
  { 0x2, 0x0, 0x1, 0x6, 0x0, 0x1, PseudoVLOXSEG2EI64_V_M2_M1 }, // 122
  { 0x2, 0x0, 0x1, 0x6, 0x0, 0x2, PseudoVLOXSEG2EI64_V_M4_M1 }, // 123
  { 0x2, 0x0, 0x1, 0x6, 0x0, 0x3, PseudoVLOXSEG2EI64_V_M8_M1 }, // 124
  { 0x2, 0x0, 0x1, 0x6, 0x1, 0x1, PseudoVLOXSEG2EI64_V_M2_M2 }, // 125
  { 0x2, 0x0, 0x1, 0x6, 0x1, 0x2, PseudoVLOXSEG2EI64_V_M4_M2 }, // 126
  { 0x2, 0x0, 0x1, 0x6, 0x1, 0x3, PseudoVLOXSEG2EI64_V_M8_M2 }, // 127
  { 0x2, 0x0, 0x1, 0x6, 0x2, 0x2, PseudoVLOXSEG2EI64_V_M4_M4 }, // 128
  { 0x2, 0x0, 0x1, 0x6, 0x2, 0x3, PseudoVLOXSEG2EI64_V_M8_M4 }, // 129
  { 0x2, 0x0, 0x1, 0x6, 0x5, 0x0, PseudoVLOXSEG2EI64_V_M1_MF8 }, // 130
  { 0x2, 0x0, 0x1, 0x6, 0x6, 0x0, PseudoVLOXSEG2EI64_V_M1_MF4 }, // 131
  { 0x2, 0x0, 0x1, 0x6, 0x6, 0x1, PseudoVLOXSEG2EI64_V_M2_MF4 }, // 132
  { 0x2, 0x0, 0x1, 0x6, 0x7, 0x0, PseudoVLOXSEG2EI64_V_M1_MF2 }, // 133
  { 0x2, 0x0, 0x1, 0x6, 0x7, 0x1, PseudoVLOXSEG2EI64_V_M2_MF2 }, // 134
  { 0x2, 0x0, 0x1, 0x6, 0x7, 0x2, PseudoVLOXSEG2EI64_V_M4_MF2 }, // 135
  { 0x2, 0x1, 0x0, 0x3, 0x0, 0x0, PseudoVLUXSEG2EI8_V_M1_M1_MASK }, // 136
  { 0x2, 0x1, 0x0, 0x3, 0x0, 0x5, PseudoVLUXSEG2EI8_V_MF8_M1_MASK }, // 137
  { 0x2, 0x1, 0x0, 0x3, 0x0, 0x6, PseudoVLUXSEG2EI8_V_MF4_M1_MASK }, // 138
  { 0x2, 0x1, 0x0, 0x3, 0x0, 0x7, PseudoVLUXSEG2EI8_V_MF2_M1_MASK }, // 139
  { 0x2, 0x1, 0x0, 0x3, 0x1, 0x0, PseudoVLUXSEG2EI8_V_M1_M2_MASK }, // 140
  { 0x2, 0x1, 0x0, 0x3, 0x1, 0x1, PseudoVLUXSEG2EI8_V_M2_M2_MASK }, // 141
  { 0x2, 0x1, 0x0, 0x3, 0x1, 0x6, PseudoVLUXSEG2EI8_V_MF4_M2_MASK }, // 142
  { 0x2, 0x1, 0x0, 0x3, 0x1, 0x7, PseudoVLUXSEG2EI8_V_MF2_M2_MASK }, // 143
  { 0x2, 0x1, 0x0, 0x3, 0x2, 0x0, PseudoVLUXSEG2EI8_V_M1_M4_MASK }, // 144
  { 0x2, 0x1, 0x0, 0x3, 0x2, 0x1, PseudoVLUXSEG2EI8_V_M2_M4_MASK }, // 145
  { 0x2, 0x1, 0x0, 0x3, 0x2, 0x2, PseudoVLUXSEG2EI8_V_M4_M4_MASK }, // 146
  { 0x2, 0x1, 0x0, 0x3, 0x2, 0x7, PseudoVLUXSEG2EI8_V_MF2_M4_MASK }, // 147
  { 0x2, 0x1, 0x0, 0x3, 0x5, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF8_MASK }, // 148
  { 0x2, 0x1, 0x0, 0x3, 0x6, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF4_MASK }, // 149
  { 0x2, 0x1, 0x0, 0x3, 0x6, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF4_MASK }, // 150
  { 0x2, 0x1, 0x0, 0x3, 0x7, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF2_MASK }, // 151
  { 0x2, 0x1, 0x0, 0x3, 0x7, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF2_MASK }, // 152
  { 0x2, 0x1, 0x0, 0x3, 0x7, 0x7, PseudoVLUXSEG2EI8_V_MF2_MF2_MASK }, // 153
  { 0x2, 0x1, 0x0, 0x4, 0x0, 0x0, PseudoVLUXSEG2EI16_V_M1_M1_MASK }, // 154
  { 0x2, 0x1, 0x0, 0x4, 0x0, 0x1, PseudoVLUXSEG2EI16_V_M2_M1_MASK }, // 155
  { 0x2, 0x1, 0x0, 0x4, 0x0, 0x6, PseudoVLUXSEG2EI16_V_MF4_M1_MASK }, // 156
  { 0x2, 0x1, 0x0, 0x4, 0x0, 0x7, PseudoVLUXSEG2EI16_V_MF2_M1_MASK }, // 157
  { 0x2, 0x1, 0x0, 0x4, 0x1, 0x0, PseudoVLUXSEG2EI16_V_M1_M2_MASK }, // 158
  { 0x2, 0x1, 0x0, 0x4, 0x1, 0x1, PseudoVLUXSEG2EI16_V_M2_M2_MASK }, // 159
  { 0x2, 0x1, 0x0, 0x4, 0x1, 0x2, PseudoVLUXSEG2EI16_V_M4_M2_MASK }, // 160
  { 0x2, 0x1, 0x0, 0x4, 0x1, 0x7, PseudoVLUXSEG2EI16_V_MF2_M2_MASK }, // 161
  { 0x2, 0x1, 0x0, 0x4, 0x2, 0x0, PseudoVLUXSEG2EI16_V_M1_M4_MASK }, // 162
  { 0x2, 0x1, 0x0, 0x4, 0x2, 0x1, PseudoVLUXSEG2EI16_V_M2_M4_MASK }, // 163
  { 0x2, 0x1, 0x0, 0x4, 0x2, 0x2, PseudoVLUXSEG2EI16_V_M4_M4_MASK }, // 164
  { 0x2, 0x1, 0x0, 0x4, 0x2, 0x3, PseudoVLUXSEG2EI16_V_M8_M4_MASK }, // 165
  { 0x2, 0x1, 0x0, 0x4, 0x5, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF8_MASK }, // 166
  { 0x2, 0x1, 0x0, 0x4, 0x6, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF4_MASK }, // 167
  { 0x2, 0x1, 0x0, 0x4, 0x6, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF4_MASK }, // 168
  { 0x2, 0x1, 0x0, 0x4, 0x7, 0x0, PseudoVLUXSEG2EI16_V_M1_MF2_MASK }, // 169
  { 0x2, 0x1, 0x0, 0x4, 0x7, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF2_MASK }, // 170
  { 0x2, 0x1, 0x0, 0x4, 0x7, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF2_MASK }, // 171
  { 0x2, 0x1, 0x0, 0x5, 0x0, 0x0, PseudoVLUXSEG2EI32_V_M1_M1_MASK }, // 172
  { 0x2, 0x1, 0x0, 0x5, 0x0, 0x1, PseudoVLUXSEG2EI32_V_M2_M1_MASK }, // 173
  { 0x2, 0x1, 0x0, 0x5, 0x0, 0x2, PseudoVLUXSEG2EI32_V_M4_M1_MASK }, // 174
  { 0x2, 0x1, 0x0, 0x5, 0x0, 0x7, PseudoVLUXSEG2EI32_V_MF2_M1_MASK }, // 175
  { 0x2, 0x1, 0x0, 0x5, 0x1, 0x0, PseudoVLUXSEG2EI32_V_M1_M2_MASK }, // 176
  { 0x2, 0x1, 0x0, 0x5, 0x1, 0x1, PseudoVLUXSEG2EI32_V_M2_M2_MASK }, // 177
  { 0x2, 0x1, 0x0, 0x5, 0x1, 0x2, PseudoVLUXSEG2EI32_V_M4_M2_MASK }, // 178
  { 0x2, 0x1, 0x0, 0x5, 0x1, 0x3, PseudoVLUXSEG2EI32_V_M8_M2_MASK }, // 179
  { 0x2, 0x1, 0x0, 0x5, 0x2, 0x1, PseudoVLUXSEG2EI32_V_M2_M4_MASK }, // 180
  { 0x2, 0x1, 0x0, 0x5, 0x2, 0x2, PseudoVLUXSEG2EI32_V_M4_M4_MASK }, // 181
  { 0x2, 0x1, 0x0, 0x5, 0x2, 0x3, PseudoVLUXSEG2EI32_V_M8_M4_MASK }, // 182
  { 0x2, 0x1, 0x0, 0x5, 0x5, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF8_MASK }, // 183
  { 0x2, 0x1, 0x0, 0x5, 0x6, 0x0, PseudoVLUXSEG2EI32_V_M1_MF4_MASK }, // 184
  { 0x2, 0x1, 0x0, 0x5, 0x6, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF4_MASK }, // 185
  { 0x2, 0x1, 0x0, 0x5, 0x7, 0x0, PseudoVLUXSEG2EI32_V_M1_MF2_MASK }, // 186
  { 0x2, 0x1, 0x0, 0x5, 0x7, 0x1, PseudoVLUXSEG2EI32_V_M2_MF2_MASK }, // 187
  { 0x2, 0x1, 0x0, 0x5, 0x7, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF2_MASK }, // 188
  { 0x2, 0x1, 0x0, 0x6, 0x0, 0x0, PseudoVLUXSEG2EI64_V_M1_M1_MASK }, // 189
  { 0x2, 0x1, 0x0, 0x6, 0x0, 0x1, PseudoVLUXSEG2EI64_V_M2_M1_MASK }, // 190
  { 0x2, 0x1, 0x0, 0x6, 0x0, 0x2, PseudoVLUXSEG2EI64_V_M4_M1_MASK }, // 191
  { 0x2, 0x1, 0x0, 0x6, 0x0, 0x3, PseudoVLUXSEG2EI64_V_M8_M1_MASK }, // 192
  { 0x2, 0x1, 0x0, 0x6, 0x1, 0x1, PseudoVLUXSEG2EI64_V_M2_M2_MASK }, // 193
  { 0x2, 0x1, 0x0, 0x6, 0x1, 0x2, PseudoVLUXSEG2EI64_V_M4_M2_MASK }, // 194
  { 0x2, 0x1, 0x0, 0x6, 0x1, 0x3, PseudoVLUXSEG2EI64_V_M8_M2_MASK }, // 195
  { 0x2, 0x1, 0x0, 0x6, 0x2, 0x2, PseudoVLUXSEG2EI64_V_M4_M4_MASK }, // 196
  { 0x2, 0x1, 0x0, 0x6, 0x2, 0x3, PseudoVLUXSEG2EI64_V_M8_M4_MASK }, // 197
  { 0x2, 0x1, 0x0, 0x6, 0x5, 0x0, PseudoVLUXSEG2EI64_V_M1_MF8_MASK }, // 198
  { 0x2, 0x1, 0x0, 0x6, 0x6, 0x0, PseudoVLUXSEG2EI64_V_M1_MF4_MASK }, // 199
  { 0x2, 0x1, 0x0, 0x6, 0x6, 0x1, PseudoVLUXSEG2EI64_V_M2_MF4_MASK }, // 200
  { 0x2, 0x1, 0x0, 0x6, 0x7, 0x0, PseudoVLUXSEG2EI64_V_M1_MF2_MASK }, // 201
  { 0x2, 0x1, 0x0, 0x6, 0x7, 0x1, PseudoVLUXSEG2EI64_V_M2_MF2_MASK }, // 202
  { 0x2, 0x1, 0x0, 0x6, 0x7, 0x2, PseudoVLUXSEG2EI64_V_M4_MF2_MASK }, // 203
  { 0x2, 0x1, 0x1, 0x3, 0x0, 0x0, PseudoVLOXSEG2EI8_V_M1_M1_MASK }, // 204
  { 0x2, 0x1, 0x1, 0x3, 0x0, 0x5, PseudoVLOXSEG2EI8_V_MF8_M1_MASK }, // 205
  { 0x2, 0x1, 0x1, 0x3, 0x0, 0x6, PseudoVLOXSEG2EI8_V_MF4_M1_MASK }, // 206
  { 0x2, 0x1, 0x1, 0x3, 0x0, 0x7, PseudoVLOXSEG2EI8_V_MF2_M1_MASK }, // 207
  { 0x2, 0x1, 0x1, 0x3, 0x1, 0x0, PseudoVLOXSEG2EI8_V_M1_M2_MASK }, // 208
  { 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, PseudoVLOXSEG2EI8_V_M2_M2_MASK }, // 209
  { 0x2, 0x1, 0x1, 0x3, 0x1, 0x6, PseudoVLOXSEG2EI8_V_MF4_M2_MASK }, // 210
  { 0x2, 0x1, 0x1, 0x3, 0x1, 0x7, PseudoVLOXSEG2EI8_V_MF2_M2_MASK }, // 211
  { 0x2, 0x1, 0x1, 0x3, 0x2, 0x0, PseudoVLOXSEG2EI8_V_M1_M4_MASK }, // 212
  { 0x2, 0x1, 0x1, 0x3, 0x2, 0x1, PseudoVLOXSEG2EI8_V_M2_M4_MASK }, // 213
  { 0x2, 0x1, 0x1, 0x3, 0x2, 0x2, PseudoVLOXSEG2EI8_V_M4_M4_MASK }, // 214
  { 0x2, 0x1, 0x1, 0x3, 0x2, 0x7, PseudoVLOXSEG2EI8_V_MF2_M4_MASK }, // 215
  { 0x2, 0x1, 0x1, 0x3, 0x5, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF8_MASK }, // 216
  { 0x2, 0x1, 0x1, 0x3, 0x6, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF4_MASK }, // 217
  { 0x2, 0x1, 0x1, 0x3, 0x6, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF4_MASK }, // 218
  { 0x2, 0x1, 0x1, 0x3, 0x7, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF2_MASK }, // 219
  { 0x2, 0x1, 0x1, 0x3, 0x7, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF2_MASK }, // 220
  { 0x2, 0x1, 0x1, 0x3, 