/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * Sparc Disassembler                                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace llvm {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * be constructible from an APInt (this can be private)
// * Support insertBits(bits, startBit, numBits)
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
// * Support put (<<) to raw_ostream&
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// a field.
template <typename InsnType>
static std::enable_if_t<std::is_integral<InsnType>::value>
insertBits(InsnType &field, InsnType bits, unsigned startBit, unsigned numBits) {
  assert(startBit + numBits <= sizeof field * 8);
  field |= (InsnType)bits << startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value>
insertBits(InsnType &field, uint64_t bits, unsigned startBit, unsigned numBits) {
  field.insertBits(bits, startBit, numBits);
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTableSparc32[] = {
/* 0 */       MCD::OPC_ExtractField, 30, 2,  // Inst{31-30} ...
/* 3 */       MCD::OPC_FilterValue, 0, 183, 1, 0, // Skip to: 447
/* 8 */       MCD::OPC_ExtractField, 22, 3,  // Inst{24-22} ...
/* 11 */      MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 27
/* 16 */      MCD::OPC_CheckField, 25, 5, 0, 136, 29, 0, // Skip to: 7583
/* 23 */      MCD::OPC_Decode, 215, 5, 0, // Opcode: UNIMP
/* 27 */      MCD::OPC_FilterValue, 1, 127, 0, 0, // Skip to: 159
/* 32 */      MCD::OPC_ExtractField, 19, 3,  // Inst{21-19} ...
/* 35 */      MCD::OPC_FilterValue, 0, 31, 0, 0, // Skip to: 71
/* 40 */      MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 43 */      MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 57
/* 48 */      MCD::OPC_CheckPredicate, 0, 106, 29, 0, // Skip to: 7583
/* 53 */      MCD::OPC_Decode, 185, 2, 1, // Opcode: BPICCNT
/* 57 */      MCD::OPC_FilterValue, 1, 97, 29, 0, // Skip to: 7583
/* 62 */      MCD::OPC_CheckPredicate, 0, 92, 29, 0, // Skip to: 7583
/* 67 */      MCD::OPC_Decode, 184, 2, 1, // Opcode: BPICCANT
/* 71 */      MCD::OPC_FilterValue, 1, 31, 0, 0, // Skip to: 107
/* 76 */      MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 79 */      MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 93
/* 84 */      MCD::OPC_CheckPredicate, 0, 70, 29, 0, // Skip to: 7583
/* 89 */      MCD::OPC_Decode, 182, 2, 1, // Opcode: BPICC
/* 93 */      MCD::OPC_FilterValue, 1, 61, 29, 0, // Skip to: 7583
/* 98 */      MCD::OPC_CheckPredicate, 0, 56, 29, 0, // Skip to: 7583
/* 103 */     MCD::OPC_Decode, 183, 2, 1, // Opcode: BPICCA
/* 107 */     MCD::OPC_FilterValue, 4, 21, 0, 0, // Skip to: 133
/* 112 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 115 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 124
/* 120 */     MCD::OPC_Decode, 193, 2, 1, // Opcode: BPXCCNT
/* 124 */     MCD::OPC_FilterValue, 1, 30, 29, 0, // Skip to: 7583
/* 129 */     MCD::OPC_Decode, 192, 2, 1, // Opcode: BPXCCANT
/* 133 */     MCD::OPC_FilterValue, 5, 21, 29, 0, // Skip to: 7583
/* 138 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 141 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 150
/* 146 */     MCD::OPC_Decode, 190, 2, 1, // Opcode: BPXCC
/* 150 */     MCD::OPC_FilterValue, 1, 4, 29, 0, // Skip to: 7583
/* 155 */     MCD::OPC_Decode, 191, 2, 1, // Opcode: BPXCCA
/* 159 */     MCD::OPC_FilterValue, 2, 32, 0, 0, // Skip to: 196
/* 164 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 167 */     MCD::OPC_FilterValue, 0, 15, 0, 0, // Skip to: 187
/* 172 */     MCD::OPC_CheckField, 25, 4, 8, 4, 0, 0, // Skip to: 183
/* 179 */     MCD::OPC_Decode, 172, 2, 0, // Opcode: BA
/* 183 */     MCD::OPC_Decode, 173, 2, 2, // Opcode: BCOND
/* 187 */     MCD::OPC_FilterValue, 1, 223, 28, 0, // Skip to: 7583
/* 192 */     MCD::OPC_Decode, 174, 2, 2, // Opcode: BCONDA
/* 196 */     MCD::OPC_FilterValue, 3, 55, 0, 0, // Skip to: 256
/* 201 */     MCD::OPC_ExtractField, 19, 1,  // Inst{19} ...
/* 204 */     MCD::OPC_FilterValue, 0, 21, 0, 0, // Skip to: 230
/* 209 */     MCD::OPC_ExtractField, 28, 2,  // Inst{29-28} ...
/* 212 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 221
/* 217 */     MCD::OPC_Decode, 189, 2, 3, // Opcode: BPRNT
/* 221 */     MCD::OPC_FilterValue, 2, 189, 28, 0, // Skip to: 7583
/* 226 */     MCD::OPC_Decode, 188, 2, 3, // Opcode: BPRANT
/* 230 */     MCD::OPC_FilterValue, 1, 180, 28, 0, // Skip to: 7583
/* 235 */     MCD::OPC_ExtractField, 28, 2,  // Inst{29-28} ...
/* 238 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 186, 2, 3, // Opcode: BPR
/* 247 */     MCD::OPC_FilterValue, 2, 163, 28, 0, // Skip to: 7583
/* 252 */     MCD::OPC_Decode, 187, 2, 3, // Opcode: BPRA
/* 256 */     MCD::OPC_FilterValue, 4, 22, 0, 0, // Skip to: 283
/* 261 */     MCD::OPC_CheckField, 25, 5, 0, 11, 0, 0, // Skip to: 279
/* 268 */     MCD::OPC_CheckField, 0, 22, 0, 4, 0, 0, // Skip to: 279
/* 275 */     MCD::OPC_Decode, 190, 4, 4, // Opcode: NOP
/* 279 */     MCD::OPC_Decode, 233, 4, 5, // Opcode: SETHIi
/* 283 */     MCD::OPC_FilterValue, 5, 107, 0, 0, // Skip to: 395
/* 288 */     MCD::OPC_ExtractField, 19, 1,  // Inst{19} ...
/* 291 */     MCD::OPC_FilterValue, 0, 31, 0, 0, // Skip to: 327
/* 296 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 299 */     MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 313
/* 304 */     MCD::OPC_CheckPredicate, 0, 106, 28, 0, // Skip to: 7583
/* 309 */     MCD::OPC_Decode, 181, 2, 6, // Opcode: BPFCCNT
/* 313 */     MCD::OPC_FilterValue, 1, 97, 28, 0, // Skip to: 7583
/* 318 */     MCD::OPC_CheckPredicate, 0, 92, 28, 0, // Skip to: 7583
/* 323 */     MCD::OPC_Decode, 180, 2, 6, // Opcode: BPFCCANT
/* 327 */     MCD::OPC_FilterValue, 1, 83, 28, 0, // Skip to: 7583
/* 332 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 335 */     MCD::OPC_FilterValue, 0, 25, 0, 0, // Skip to: 365
/* 340 */     MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 356
/* 345 */     MCD::OPC_CheckField, 20, 2, 0, 4, 0, 0, // Skip to: 356
/* 352 */     MCD::OPC_Decode, 238, 2, 1, // Opcode: FBCOND_V9
/* 356 */     MCD::OPC_CheckPredicate, 0, 54, 28, 0, // Skip to: 7583
/* 361 */     MCD::OPC_Decode, 178, 2, 6, // Opcode: BPFCC
/* 365 */     MCD::OPC_FilterValue, 1, 45, 28, 0, // Skip to: 7583
/* 370 */     MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 386
/* 375 */     MCD::OPC_CheckField, 20, 2, 0, 4, 0, 0, // Skip to: 386
/* 382 */     MCD::OPC_Decode, 237, 2, 1, // Opcode: FBCONDA_V9
/* 386 */     MCD::OPC_CheckPredicate, 0, 24, 28, 0, // Skip to: 7583
/* 391 */     MCD::OPC_Decode, 179, 2, 6, // Opcode: BPFCCA
/* 395 */     MCD::OPC_FilterValue, 6, 21, 0, 0, // Skip to: 421
/* 400 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 403 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 412
/* 408 */     MCD::OPC_Decode, 235, 2, 2, // Opcode: FBCOND
/* 412 */     MCD::OPC_FilterValue, 1, 254, 27, 0, // Skip to: 7583
/* 417 */     MCD::OPC_Decode, 236, 2, 2, // Opcode: FBCONDA
/* 421 */     MCD::OPC_FilterValue, 7, 245, 27, 0, // Skip to: 7583
/* 426 */     MCD::OPC_ExtractField, 29, 1,  // Inst{29} ...
/* 429 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 438
/* 434 */     MCD::OPC_Decode, 202, 2, 2, // Opcode: CBCOND
/* 438 */     MCD::OPC_FilterValue, 1, 228, 27, 0, // Skip to: 7583
/* 443 */     MCD::OPC_Decode, 203, 2, 2, // Opcode: CBCONDA
/* 447 */     MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 456
/* 452 */     MCD::OPC_Decode, 195, 2, 7, // Opcode: CALL
/* 456 */     MCD::OPC_FilterValue, 2, 199, 21, 0, // Skip to: 6036
/* 461 */     MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 464 */     MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 497
/* 469 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 472 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 488
/* 477 */     MCD::OPC_CheckField, 5, 8, 0, 187, 27, 0, // Skip to: 7583
/* 484 */     MCD::OPC_Decode, 155, 2, 8, // Opcode: ADDrr
/* 488 */     MCD::OPC_FilterValue, 1, 178, 27, 0, // Skip to: 7583
/* 493 */     MCD::OPC_Decode, 154, 2, 9, // Opcode: ADDri
/* 497 */     MCD::OPC_FilterValue, 1, 28, 0, 0, // Skip to: 530
/* 502 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 505 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 521
/* 510 */     MCD::OPC_CheckField, 5, 8, 0, 154, 27, 0, // Skip to: 7583
/* 517 */     MCD::OPC_Decode, 168, 2, 8, // Opcode: ANDrr
/* 521 */     MCD::OPC_FilterValue, 1, 145, 27, 0, // Skip to: 7583
/* 526 */     MCD::OPC_Decode, 167, 2, 9, // Opcode: ANDri
/* 530 */     MCD::OPC_FilterValue, 2, 28, 0, 0, // Skip to: 563
/* 535 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 538 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 554
/* 543 */     MCD::OPC_CheckField, 5, 8, 0, 121, 27, 0, // Skip to: 7583
/* 550 */     MCD::OPC_Decode, 201, 4, 8, // Opcode: ORrr
/* 554 */     MCD::OPC_FilterValue, 1, 112, 27, 0, // Skip to: 7583
/* 559 */     MCD::OPC_Decode, 200, 4, 9, // Opcode: ORri
/* 563 */     MCD::OPC_FilterValue, 3, 28, 0, 0, // Skip to: 596
/* 568 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 571 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 587
/* 576 */     MCD::OPC_CheckField, 5, 8, 0, 88, 27, 0, // Skip to: 7583
/* 583 */     MCD::OPC_Decode, 249, 5, 8, // Opcode: XORrr
/* 587 */     MCD::OPC_FilterValue, 1, 79, 27, 0, // Skip to: 7583
/* 592 */     MCD::OPC_Decode, 248, 5, 9, // Opcode: XORri
/* 596 */     MCD::OPC_FilterValue, 4, 28, 0, 0, // Skip to: 629
/* 601 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 604 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 620
/* 609 */     MCD::OPC_CheckField, 5, 8, 0, 55, 27, 0, // Skip to: 7583
/* 616 */     MCD::OPC_Decode, 174, 5, 8, // Opcode: SUBrr
/* 620 */     MCD::OPC_FilterValue, 1, 46, 27, 0, // Skip to: 7583
/* 625 */     MCD::OPC_Decode, 173, 5, 9, // Opcode: SUBri
/* 629 */     MCD::OPC_FilterValue, 5, 28, 0, 0, // Skip to: 662
/* 634 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 637 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 653
/* 642 */     MCD::OPC_CheckField, 5, 8, 0, 22, 27, 0, // Skip to: 7583
/* 649 */     MCD::OPC_Decode, 163, 2, 8, // Opcode: ANDNrr
/* 653 */     MCD::OPC_FilterValue, 1, 13, 27, 0, // Skip to: 7583
/* 658 */     MCD::OPC_Decode, 162, 2, 9, // Opcode: ANDNri
/* 662 */     MCD::OPC_FilterValue, 6, 28, 0, 0, // Skip to: 695
/* 667 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 670 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 686
/* 675 */     MCD::OPC_CheckField, 5, 8, 0, 245, 26, 0, // Skip to: 7583
/* 682 */     MCD::OPC_Decode, 196, 4, 8, // Opcode: ORNrr
/* 686 */     MCD::OPC_FilterValue, 1, 236, 26, 0, // Skip to: 7583
/* 691 */     MCD::OPC_Decode, 195, 4, 9, // Opcode: ORNri
/* 695 */     MCD::OPC_FilterValue, 7, 28, 0, 0, // Skip to: 728
/* 700 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 703 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 719
/* 708 */     MCD::OPC_CheckField, 5, 8, 0, 212, 26, 0, // Skip to: 7583
/* 715 */     MCD::OPC_Decode, 243, 5, 8, // Opcode: XNORrr
/* 719 */     MCD::OPC_FilterValue, 1, 203, 26, 0, // Skip to: 7583
/* 724 */     MCD::OPC_Decode, 242, 5, 9, // Opcode: XNORri
/* 728 */     MCD::OPC_FilterValue, 8, 28, 0, 0, // Skip to: 761
/* 733 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 736 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 752
/* 741 */     MCD::OPC_CheckField, 5, 8, 0, 179, 26, 0, // Skip to: 7583
/* 748 */     MCD::OPC_Decode, 147, 2, 8, // Opcode: ADDCrr
/* 752 */     MCD::OPC_FilterValue, 1, 170, 26, 0, // Skip to: 7583
/* 757 */     MCD::OPC_Decode, 146, 2, 9, // Opcode: ADDCri
/* 761 */     MCD::OPC_FilterValue, 9, 28, 0, 0, // Skip to: 794
/* 766 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 769 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 785
/* 774 */     MCD::OPC_CheckField, 5, 8, 0, 146, 26, 0, // Skip to: 7583
/* 781 */     MCD::OPC_Decode, 189, 4, 10, // Opcode: MULXrr
/* 785 */     MCD::OPC_FilterValue, 1, 137, 26, 0, // Skip to: 7583
/* 790 */     MCD::OPC_Decode, 188, 4, 11, // Opcode: MULXri
/* 794 */     MCD::OPC_FilterValue, 10, 28, 0, 0, // Skip to: 827
/* 799 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 802 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 818
/* 807 */     MCD::OPC_CheckField, 5, 8, 0, 113, 26, 0, // Skip to: 7583
/* 814 */     MCD::OPC_Decode, 214, 5, 8, // Opcode: UMULrr
/* 818 */     MCD::OPC_FilterValue, 1, 104, 26, 0, // Skip to: 7583
/* 823 */     MCD::OPC_Decode, 213, 5, 9, // Opcode: UMULri
/* 827 */     MCD::OPC_FilterValue, 11, 28, 0, 0, // Skip to: 860
/* 832 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 835 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 851
/* 840 */     MCD::OPC_CheckField, 5, 8, 0, 80, 26, 0, // Skip to: 7583
/* 847 */     MCD::OPC_Decode, 246, 4, 8, // Opcode: SMULrr
/* 851 */     MCD::OPC_FilterValue, 1, 71, 26, 0, // Skip to: 7583
/* 856 */     MCD::OPC_Decode, 245, 4, 9, // Opcode: SMULri
/* 860 */     MCD::OPC_FilterValue, 12, 28, 0, 0, // Skip to: 893
/* 865 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 868 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 884
/* 873 */     MCD::OPC_CheckField, 5, 8, 0, 47, 26, 0, // Skip to: 7583
/* 880 */     MCD::OPC_Decode, 168, 5, 8, // Opcode: SUBCrr
/* 884 */     MCD::OPC_FilterValue, 1, 38, 26, 0, // Skip to: 7583
/* 889 */     MCD::OPC_Decode, 167, 5, 9, // Opcode: SUBCri
/* 893 */     MCD::OPC_FilterValue, 13, 28, 0, 0, // Skip to: 926
/* 898 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 901 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 917
/* 906 */     MCD::OPC_CheckField, 5, 8, 0, 14, 26, 0, // Skip to: 7583
/* 913 */     MCD::OPC_Decode, 205, 5, 10, // Opcode: UDIVXrr
/* 917 */     MCD::OPC_FilterValue, 1, 5, 26, 0, // Skip to: 7583
/* 922 */     MCD::OPC_Decode, 204, 5, 11, // Opcode: UDIVXri
/* 926 */     MCD::OPC_FilterValue, 14, 28, 0, 0, // Skip to: 959
/* 931 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 934 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 950
/* 939 */     MCD::OPC_CheckField, 5, 8, 0, 237, 25, 0, // Skip to: 7583
/* 946 */     MCD::OPC_Decode, 207, 5, 8, // Opcode: UDIVrr
/* 950 */     MCD::OPC_FilterValue, 1, 228, 25, 0, // Skip to: 7583
/* 955 */     MCD::OPC_Decode, 206, 5, 9, // Opcode: UDIVri
/* 959 */     MCD::OPC_FilterValue, 15, 28, 0, 0, // Skip to: 992
/* 964 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 967 */     MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 983
/* 972 */     MCD::OPC_CheckField, 5, 8, 0, 204, 25, 0, // Skip to: 7583
/* 979 */     MCD::OPC_Decode, 231, 4, 8, // Opcode: SDIVrr
/* 983 */     MCD::OPC_FilterValue, 1, 195, 25, 0, // Skip to: 7583
/* 988 */     MCD::OPC_Decode, 230, 4, 9, // Opcode: SDIVri
/* 992 */     MCD::OPC_FilterValue, 16, 28, 0, 0, // Skip to: 1025
/* 997 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1000 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1016
/* 1005 */    MCD::OPC_CheckField, 5, 8, 0, 171, 25, 0, // Skip to: 7583
/* 1012 */    MCD::OPC_Decode, 145, 2, 8, // Opcode: ADDCCrr
/* 1016 */    MCD::OPC_FilterValue, 1, 162, 25, 0, // Skip to: 7583
/* 1021 */    MCD::OPC_Decode, 144, 2, 9, // Opcode: ADDCCri
/* 1025 */    MCD::OPC_FilterValue, 17, 28, 0, 0, // Skip to: 1058
/* 1030 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1033 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1049
/* 1038 */    MCD::OPC_CheckField, 5, 8, 0, 138, 25, 0, // Skip to: 7583
/* 1045 */    MCD::OPC_Decode, 159, 2, 8, // Opcode: ANDCCrr
/* 1049 */    MCD::OPC_FilterValue, 1, 129, 25, 0, // Skip to: 7583
/* 1054 */    MCD::OPC_Decode, 158, 2, 9, // Opcode: ANDCCri
/* 1058 */    MCD::OPC_FilterValue, 18, 28, 0, 0, // Skip to: 1091
/* 1063 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1066 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1082
/* 1071 */    MCD::OPC_CheckField, 5, 8, 0, 105, 25, 0, // Skip to: 7583
/* 1078 */    MCD::OPC_Decode, 192, 4, 8, // Opcode: ORCCrr
/* 1082 */    MCD::OPC_FilterValue, 1, 96, 25, 0, // Skip to: 7583
/* 1087 */    MCD::OPC_Decode, 191, 4, 9, // Opcode: ORCCri
/* 1091 */    MCD::OPC_FilterValue, 19, 28, 0, 0, // Skip to: 1124
/* 1096 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1099 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1115
/* 1104 */    MCD::OPC_CheckField, 5, 8, 0, 72, 25, 0, // Skip to: 7583
/* 1111 */    MCD::OPC_Decode, 245, 5, 8, // Opcode: XORCCrr
/* 1115 */    MCD::OPC_FilterValue, 1, 63, 25, 0, // Skip to: 7583
/* 1120 */    MCD::OPC_Decode, 244, 5, 9, // Opcode: XORCCri
/* 1124 */    MCD::OPC_FilterValue, 20, 51, 0, 0, // Skip to: 1180
/* 1129 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1132 */    MCD::OPC_FilterValue, 0, 23, 0, 0, // Skip to: 1160
/* 1137 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 1140 */    MCD::OPC_FilterValue, 0, 38, 25, 0, // Skip to: 7583
/* 1145 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 1156
/* 1152 */    MCD::OPC_Decode, 208, 2, 12, // Opcode: CMPrr
/* 1156 */    MCD::OPC_Decode, 166, 5, 8, // Opcode: SUBCCrr
/* 1160 */    MCD::OPC_FilterValue, 1, 18, 25, 0, // Skip to: 7583
/* 1165 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 1176
/* 1172 */    MCD::OPC_Decode, 207, 2, 13, // Opcode: CMPri
/* 1176 */    MCD::OPC_Decode, 165, 5, 9, // Opcode: SUBCCri
/* 1180 */    MCD::OPC_FilterValue, 21, 28, 0, 0, // Skip to: 1213
/* 1185 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1188 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1204
/* 1193 */    MCD::OPC_CheckField, 5, 8, 0, 239, 24, 0, // Skip to: 7583
/* 1200 */    MCD::OPC_Decode, 161, 2, 8, // Opcode: ANDNCCrr
/* 1204 */    MCD::OPC_FilterValue, 1, 230, 24, 0, // Skip to: 7583
/* 1209 */    MCD::OPC_Decode, 160, 2, 9, // Opcode: ANDNCCri
/* 1213 */    MCD::OPC_FilterValue, 22, 28, 0, 0, // Skip to: 1246
/* 1218 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1221 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1237
/* 1226 */    MCD::OPC_CheckField, 5, 8, 0, 206, 24, 0, // Skip to: 7583
/* 1233 */    MCD::OPC_Decode, 194, 4, 8, // Opcode: ORNCCrr
/* 1237 */    MCD::OPC_FilterValue, 1, 197, 24, 0, // Skip to: 7583
/* 1242 */    MCD::OPC_Decode, 193, 4, 9, // Opcode: ORNCCri
/* 1246 */    MCD::OPC_FilterValue, 23, 28, 0, 0, // Skip to: 1279
/* 1251 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1254 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1270
/* 1259 */    MCD::OPC_CheckField, 5, 8, 0, 173, 24, 0, // Skip to: 7583
/* 1266 */    MCD::OPC_Decode, 240, 5, 8, // Opcode: XNORCCrr
/* 1270 */    MCD::OPC_FilterValue, 1, 164, 24, 0, // Skip to: 7583
/* 1275 */    MCD::OPC_Decode, 239, 5, 9, // Opcode: XNORCCri
/* 1279 */    MCD::OPC_FilterValue, 24, 28, 0, 0, // Skip to: 1312
/* 1284 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1287 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1303
/* 1292 */    MCD::OPC_CheckField, 5, 8, 0, 140, 24, 0, // Skip to: 7583
/* 1299 */    MCD::OPC_Decode, 149, 2, 8, // Opcode: ADDErr
/* 1303 */    MCD::OPC_FilterValue, 1, 131, 24, 0, // Skip to: 7583
/* 1308 */    MCD::OPC_Decode, 148, 2, 9, // Opcode: ADDEri
/* 1312 */    MCD::OPC_FilterValue, 26, 28, 0, 0, // Skip to: 1345
/* 1317 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1320 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1336
/* 1325 */    MCD::OPC_CheckField, 5, 8, 0, 107, 24, 0, // Skip to: 7583
/* 1332 */    MCD::OPC_Decode, 211, 5, 8, // Opcode: UMULCCrr
/* 1336 */    MCD::OPC_FilterValue, 1, 98, 24, 0, // Skip to: 7583
/* 1341 */    MCD::OPC_Decode, 210, 5, 9, // Opcode: UMULCCri
/* 1345 */    MCD::OPC_FilterValue, 27, 28, 0, 0, // Skip to: 1378
/* 1350 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1353 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1369
/* 1358 */    MCD::OPC_CheckField, 5, 8, 0, 74, 24, 0, // Skip to: 7583
/* 1365 */    MCD::OPC_Decode, 244, 4, 8, // Opcode: SMULCCrr
/* 1369 */    MCD::OPC_FilterValue, 1, 65, 24, 0, // Skip to: 7583
/* 1374 */    MCD::OPC_Decode, 243, 4, 9, // Opcode: SMULCCri
/* 1378 */    MCD::OPC_FilterValue, 28, 28, 0, 0, // Skip to: 1411
/* 1383 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1386 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1402
/* 1391 */    MCD::OPC_CheckField, 5, 8, 0, 41, 24, 0, // Skip to: 7583
/* 1398 */    MCD::OPC_Decode, 170, 5, 8, // Opcode: SUBErr
/* 1402 */    MCD::OPC_FilterValue, 1, 32, 24, 0, // Skip to: 7583
/* 1407 */    MCD::OPC_Decode, 169, 5, 9, // Opcode: SUBEri
/* 1411 */    MCD::OPC_FilterValue, 30, 28, 0, 0, // Skip to: 1444
/* 1416 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1419 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1435
/* 1424 */    MCD::OPC_CheckField, 5, 8, 0, 8, 24, 0, // Skip to: 7583
/* 1431 */    MCD::OPC_Decode, 203, 5, 8, // Opcode: UDIVCCrr
/* 1435 */    MCD::OPC_FilterValue, 1, 255, 23, 0, // Skip to: 7583
/* 1440 */    MCD::OPC_Decode, 202, 5, 9, // Opcode: UDIVCCri
/* 1444 */    MCD::OPC_FilterValue, 31, 28, 0, 0, // Skip to: 1477
/* 1449 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1452 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1468
/* 1457 */    MCD::OPC_CheckField, 5, 8, 0, 231, 23, 0, // Skip to: 7583
/* 1464 */    MCD::OPC_Decode, 227, 4, 8, // Opcode: SDIVCCrr
/* 1468 */    MCD::OPC_FilterValue, 1, 222, 23, 0, // Skip to: 7583
/* 1473 */    MCD::OPC_Decode, 226, 4, 9, // Opcode: SDIVCCri
/* 1477 */    MCD::OPC_FilterValue, 32, 28, 0, 0, // Skip to: 1510
/* 1482 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1485 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1501
/* 1490 */    MCD::OPC_CheckField, 5, 8, 0, 198, 23, 0, // Skip to: 7583
/* 1497 */    MCD::OPC_Decode, 184, 5, 8, // Opcode: TADDCCrr
/* 1501 */    MCD::OPC_FilterValue, 1, 189, 23, 0, // Skip to: 7583
/* 1506 */    MCD::OPC_Decode, 183, 5, 9, // Opcode: TADDCCri
/* 1510 */    MCD::OPC_FilterValue, 33, 28, 0, 0, // Skip to: 1543
/* 1515 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1518 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1534
/* 1523 */    MCD::OPC_CheckField, 5, 8, 0, 165, 23, 0, // Skip to: 7583
/* 1530 */    MCD::OPC_Decode, 199, 5, 8, // Opcode: TSUBCCrr
/* 1534 */    MCD::OPC_FilterValue, 1, 156, 23, 0, // Skip to: 7583
/* 1539 */    MCD::OPC_Decode, 198, 5, 9, // Opcode: TSUBCCri
/* 1543 */    MCD::OPC_FilterValue, 34, 28, 0, 0, // Skip to: 1576
/* 1548 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1551 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1567
/* 1556 */    MCD::OPC_CheckField, 5, 8, 0, 132, 23, 0, // Skip to: 7583
/* 1563 */    MCD::OPC_Decode, 182, 5, 8, // Opcode: TADDCCTVrr
/* 1567 */    MCD::OPC_FilterValue, 1, 123, 23, 0, // Skip to: 7583
/* 1572 */    MCD::OPC_Decode, 181, 5, 9, // Opcode: TADDCCTVri
/* 1576 */    MCD::OPC_FilterValue, 35, 28, 0, 0, // Skip to: 1609
/* 1581 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1584 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1600
/* 1589 */    MCD::OPC_CheckField, 5, 8, 0, 99, 23, 0, // Skip to: 7583
/* 1596 */    MCD::OPC_Decode, 197, 5, 8, // Opcode: TSUBCCTVrr
/* 1600 */    MCD::OPC_FilterValue, 1, 90, 23, 0, // Skip to: 7583
/* 1605 */    MCD::OPC_Decode, 196, 5, 9, // Opcode: TSUBCCTVri
/* 1609 */    MCD::OPC_FilterValue, 36, 28, 0, 0, // Skip to: 1642
/* 1614 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1617 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 1633
/* 1622 */    MCD::OPC_CheckField, 5, 8, 0, 66, 23, 0, // Skip to: 7583
/* 1629 */    MCD::OPC_Decode, 187, 4, 8, // Opcode: MULSCCrr
/* 1633 */    MCD::OPC_FilterValue, 1, 57, 23, 0, // Skip to: 7583
/* 1638 */    MCD::OPC_Decode, 186, 4, 9, // Opcode: MULSCCri
/* 1642 */    MCD::OPC_FilterValue, 37, 39, 0, 0, // Skip to: 1686
/* 1647 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1650 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1659
/* 1655 */    MCD::OPC_Decode, 240, 4, 8, // Opcode: SLLrr
/* 1659 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1668
/* 1664 */    MCD::OPC_Decode, 238, 4, 14, // Opcode: SLLXrr
/* 1668 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1677
/* 1673 */    MCD::OPC_Decode, 239, 4, 15, // Opcode: SLLri
/* 1677 */    MCD::OPC_FilterValue, 3, 13, 23, 0, // Skip to: 7583
/* 1682 */    MCD::OPC_Decode, 237, 4, 16, // Opcode: SLLXri
/* 1686 */    MCD::OPC_FilterValue, 38, 39, 0, 0, // Skip to: 1730
/* 1691 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1694 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1703
/* 1699 */    MCD::OPC_Decode, 254, 4, 8, // Opcode: SRLrr
/* 1703 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1712
/* 1708 */    MCD::OPC_Decode, 252, 4, 14, // Opcode: SRLXrr
/* 1712 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1721
/* 1717 */    MCD::OPC_Decode, 253, 4, 15, // Opcode: SRLri
/* 1721 */    MCD::OPC_FilterValue, 3, 225, 22, 0, // Skip to: 7583
/* 1726 */    MCD::OPC_Decode, 251, 4, 16, // Opcode: SRLXri
/* 1730 */    MCD::OPC_FilterValue, 39, 39, 0, 0, // Skip to: 1774
/* 1735 */    MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 1738 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1747
/* 1743 */    MCD::OPC_Decode, 250, 4, 8, // Opcode: SRArr
/* 1747 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1756
/* 1752 */    MCD::OPC_Decode, 248, 4, 14, // Opcode: SRAXrr
/* 1756 */    MCD::OPC_FilterValue, 2, 4, 0, 0, // Skip to: 1765
/* 1761 */    MCD::OPC_Decode, 249, 4, 15, // Opcode: SRAri
/* 1765 */    MCD::OPC_FilterValue, 3, 181, 22, 0, // Skip to: 7583
/* 1770 */    MCD::OPC_Decode, 247, 4, 16, // Opcode: SRAXri
/* 1774 */    MCD::OPC_FilterValue, 40, 81, 0, 0, // Skip to: 1860
/* 1779 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1782 */    MCD::OPC_FilterValue, 0, 45, 0, 0, // Skip to: 1832
/* 1787 */    MCD::OPC_ExtractField, 0, 13,  // Inst{12-0} ...
/* 1790 */    MCD::OPC_FilterValue, 0, 156, 22, 0, // Skip to: 7583
/* 1795 */    MCD::OPC_ExtractField, 14, 5,  // Inst{18-14} ...
/* 1798 */    MCD::OPC_FilterValue, 5, 9, 0, 0, // Skip to: 1812
/* 1803 */    MCD::OPC_CheckPredicate, 0, 20, 0, 0, // Skip to: 1828
/* 1808 */    MCD::OPC_Decode, 210, 4, 17, // Opcode: RDPC
/* 1812 */    MCD::OPC_FilterValue, 15, 11, 0, 0, // Skip to: 1828
/* 1817 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 1828
/* 1824 */    MCD::OPC_Decode, 128, 5, 4, // Opcode: STBAR
/* 1828 */    MCD::OPC_Decode, 209, 4, 18, // Opcode: RDASR
/* 1832 */    MCD::OPC_FilterValue, 1, 114, 22, 0, // Skip to: 7583
/* 1837 */    MCD::OPC_CheckPredicate, 0, 109, 22, 0, // Skip to: 7583
/* 1842 */    MCD::OPC_CheckField, 25, 5, 0, 102, 22, 0, // Skip to: 7583
/* 1849 */    MCD::OPC_CheckField, 14, 5, 15, 95, 22, 0, // Skip to: 7583
/* 1856 */    MCD::OPC_Decode, 172, 4, 19, // Opcode: MEMBARi
/* 1860 */    MCD::OPC_FilterValue, 41, 11, 0, 0, // Skip to: 1876
/* 1865 */    MCD::OPC_CheckField, 0, 19, 0, 79, 22, 0, // Skip to: 7583
/* 1872 */    MCD::OPC_Decode, 212, 4, 17, // Opcode: RDPSR
/* 1876 */    MCD::OPC_FilterValue, 42, 28, 0, 0, // Skip to: 1909
/* 1881 */    MCD::OPC_ExtractField, 0, 14,  // Inst{13-0} ...
/* 1884 */    MCD::OPC_FilterValue, 0, 62, 22, 0, // Skip to: 7583
/* 1889 */    MCD::OPC_CheckField, 14, 5, 0, 4, 0, 0, // Skip to: 1900
/* 1896 */    MCD::OPC_Decode, 214, 4, 17, // Opcode: RDWIM
/* 1900 */    MCD::OPC_CheckPredicate, 0, 46, 22, 0, // Skip to: 7583
/* 1905 */    MCD::OPC_Decode, 211, 4, 20, // Opcode: RDPR
/* 1909 */    MCD::OPC_FilterValue, 43, 28, 0, 0, // Skip to: 1942
/* 1914 */    MCD::OPC_ExtractField, 0, 19,  // Inst{18-0} ...
/* 1917 */    MCD::OPC_FilterValue, 0, 29, 22, 0, // Skip to: 7583
/* 1922 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 1938
/* 1927 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 1938
/* 1934 */    MCD::OPC_Decode, 145, 3, 4, // Opcode: FLUSHW
/* 1938 */    MCD::OPC_Decode, 213, 4, 17, // Opcode: RDTBR
/* 1942 */    MCD::OPC_FilterValue, 44, 141, 0, 0, // Skip to: 2088
/* 1947 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1950 */    MCD::OPC_FilterValue, 0, 64, 0, 0, // Skip to: 2019
/* 1955 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 1958 */    MCD::OPC_FilterValue, 0, 25, 0, 0, // Skip to: 1988
/* 1963 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 1979
/* 1968 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, 0, // Skip to: 1979
/* 1975 */    MCD::OPC_Decode, 175, 4, 21, // Opcode: MOVFCCrr
/* 1979 */    MCD::OPC_CheckPredicate, 0, 223, 21, 0, // Skip to: 7583
/* 1984 */    MCD::OPC_Decode, 226, 5, 22, // Opcode: V9MOVFCCrr
/* 1988 */    MCD::OPC_FilterValue, 1, 214, 21, 0, // Skip to: 7583
/* 1993 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 1996 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 2010
/* 2001 */    MCD::OPC_CheckPredicate, 0, 201, 21, 0, // Skip to: 7583
/* 2006 */    MCD::OPC_Decode, 177, 4, 21, // Opcode: MOVICCrr
/* 2010 */    MCD::OPC_FilterValue, 2, 192, 21, 0, // Skip to: 7583
/* 2015 */    MCD::OPC_Decode, 184, 4, 21, // Opcode: MOVXCCrr
/* 2019 */    MCD::OPC_FilterValue, 1, 183, 21, 0, // Skip to: 7583
/* 2024 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 2027 */    MCD::OPC_FilterValue, 0, 25, 0, 0, // Skip to: 2057
/* 2032 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 2048
/* 2037 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, 0, // Skip to: 2048
/* 2044 */    MCD::OPC_Decode, 174, 4, 23, // Opcode: MOVFCCri
/* 2048 */    MCD::OPC_CheckPredicate, 0, 154, 21, 0, // Skip to: 7583
/* 2053 */    MCD::OPC_Decode, 225, 5, 24, // Opcode: V9MOVFCCri
/* 2057 */    MCD::OPC_FilterValue, 1, 145, 21, 0, // Skip to: 7583
/* 2062 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 2065 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 2079
/* 2070 */    MCD::OPC_CheckPredicate, 0, 132, 21, 0, // Skip to: 7583
/* 2075 */    MCD::OPC_Decode, 176, 4, 23, // Opcode: MOVICCri
/* 2079 */    MCD::OPC_FilterValue, 2, 123, 21, 0, // Skip to: 7583
/* 2084 */    MCD::OPC_Decode, 183, 4, 23, // Opcode: MOVXCCri
/* 2088 */    MCD::OPC_FilterValue, 45, 28, 0, 0, // Skip to: 2121
/* 2093 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2096 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2112
/* 2101 */    MCD::OPC_CheckField, 5, 8, 0, 99, 21, 0, // Skip to: 7583
/* 2108 */    MCD::OPC_Decode, 229, 4, 10, // Opcode: SDIVXrr
/* 2112 */    MCD::OPC_FilterValue, 1, 90, 21, 0, // Skip to: 7583
/* 2117 */    MCD::OPC_Decode, 228, 4, 11, // Opcode: SDIVXri
/* 2121 */    MCD::OPC_FilterValue, 46, 16, 0, 0, // Skip to: 2142
/* 2126 */    MCD::OPC_CheckPredicate, 0, 76, 21, 0, // Skip to: 7583
/* 2131 */    MCD::OPC_CheckField, 5, 14, 0, 69, 21, 0, // Skip to: 7583
/* 2138 */    MCD::OPC_Decode, 204, 4, 25, // Opcode: POPCrr
/* 2142 */    MCD::OPC_FilterValue, 47, 28, 0, 0, // Skip to: 2175
/* 2147 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2150 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2166
/* 2155 */    MCD::OPC_CheckField, 5, 5, 0, 45, 21, 0, // Skip to: 7583
/* 2162 */    MCD::OPC_Decode, 179, 4, 26, // Opcode: MOVRrr
/* 2166 */    MCD::OPC_FilterValue, 1, 36, 21, 0, // Skip to: 7583
/* 2171 */    MCD::OPC_Decode, 178, 4, 27, // Opcode: MOVRri
/* 2175 */    MCD::OPC_FilterValue, 48, 51, 0, 0, // Skip to: 2231
/* 2180 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2183 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 2199
/* 2188 */    MCD::OPC_CheckField, 5, 8, 0, 12, 21, 0, // Skip to: 7583
/* 2195 */    MCD::OPC_Decode, 228, 5, 28, // Opcode: WRASRrr
/* 2199 */    MCD::OPC_FilterValue, 1, 3, 21, 0, // Skip to: 7583
/* 2204 */    MCD::OPC_CheckPredicate, 0, 18, 0, 0, // Skip to: 2227
/* 2209 */    MCD::OPC_CheckField, 25, 5, 15, 11, 0, 0, // Skip to: 2227
/* 2216 */    MCD::OPC_CheckField, 14, 5, 0, 4, 0, 0, // Skip to: 2227
/* 2223 */    MCD::OPC_Decode, 236, 4, 29, // Opcode: SIR
/* 2227 */    MCD::OPC_Decode, 227, 5, 30, // Opcode: WRASRri
/* 2231 */    MCD::OPC_FilterValue, 49, 127, 0, 0, // Skip to: 2363
/* 2236 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2239 */    MCD::OPC_FilterValue, 0, 88, 0, 0, // Skip to: 2332
/* 2244 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 2247 */    MCD::OPC_FilterValue, 0, 35, 0, 0, // Skip to: 2287
/* 2252 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 2255 */    MCD::OPC_FilterValue, 0, 203, 20, 0, // Skip to: 7583
/* 2260 */    MCD::OPC_CheckPredicate, 0, 18, 0, 0, // Skip to: 2283
/* 2265 */    MCD::OPC_CheckField, 14, 5, 0, 11, 0, 0, // Skip to: 2283
/* 2272 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, 0, // Skip to: 2283
/* 2279 */    MCD::OPC_Decode, 223, 4, 4, // Opcode: SAVED
/* 2283 */    MCD::OPC_Decode, 232, 5, 12, // Opcode: WRPSRrr
/* 2287 */    MCD::OPC_FilterValue, 1, 171, 20, 0, // Skip to: 7583
/* 2292 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 2295 */    MCD::OPC_FilterValue, 0, 163, 20, 0, // Skip to: 7583
/* 2300 */    MCD::OPC_CheckPredicate, 0, 18, 0, 0, // Skip to: 2323
/* 2305 */    MCD::OPC_CheckField, 14, 5, 0, 11, 0, 0, // Skip to: 2323
/* 2312 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, 0, // Skip to: 2323
/* 2319 */    MCD::OPC_Decode, 215, 4, 4, // Opcode: RESTORED
/* 2323 */    MCD::OPC_CheckPredicate, 1, 135, 20, 0, // Skip to: 7583
/* 2328 */    MCD::OPC_Decode, 208, 4, 12, // Opcode: PWRPSRrr
/* 2332 */    MCD::OPC_FilterValue, 1, 126, 20, 0, // Skip to: 7583
/* 2337 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 2340 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 2349
/* 2345 */    MCD::OPC_Decode, 231, 5, 13, // Opcode: WRPSRri
/* 2349 */    MCD::OPC_FilterValue, 1, 109, 20, 0, // Skip to: 7583
/* 2354 */    MCD::OPC_CheckPredicate, 1, 104, 20, 0, // Skip to: 7583
/* 2359 */    MCD::OPC_Decode, 207, 4, 13, // Opcode: PWRPSRri
/* 2363 */    MCD::OPC_FilterValue, 50, 61, 0, 0, // Skip to: 2429
/* 2368 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2371 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 2404
/* 2376 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 2379 */    MCD::OPC_FilterValue, 0, 79, 20, 0, // Skip to: 7583
/* 2384 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 2395
/* 2391 */    MCD::OPC_Decode, 236, 5, 12, // Opcode: WRWIMrr
/* 2395 */    MCD::OPC_CheckPredicate, 0, 63, 20, 0, // Skip to: 7583
/* 2400 */    MCD::OPC_Decode, 230, 5, 31, // Opcode: WRPRrr
/* 2404 */    MCD::OPC_FilterValue, 1, 54, 20, 0, // Skip to: 7583
/* 2409 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 2420
/* 2416 */    MCD::OPC_Decode, 235, 5, 13, // Opcode: WRWIMri
/* 2420 */    MCD::OPC_CheckPredicate, 0, 38, 20, 0, // Skip to: 7583
/* 2425 */    MCD::OPC_Decode, 229, 5, 32, // Opcode: WRPRri
/* 2429 */    MCD::OPC_FilterValue, 51, 42, 0, 0, // Skip to: 2476
/* 2434 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 2437 */    MCD::OPC_FilterValue, 0, 18, 0, 0, // Skip to: 2460
/* 2442 */    MCD::OPC_CheckField, 25, 5, 0, 14, 20, 0, // Skip to: 7583
/* 2449 */    MCD::OPC_CheckField, 5, 8, 0, 7, 20, 0, // Skip to: 7583
/* 2456 */    MCD::OPC_Decode, 234, 5, 12, // Opcode: WRTBRrr
/* 2460 */    MCD::OPC_FilterValue, 1, 254, 19, 0, // Skip to: 7583
/* 2465 */    MCD::OPC_CheckField, 25, 5, 0, 247, 19, 0, // Skip to: 7583
/* 2472 */    MCD::OPC_Decode, 233, 5, 13, // Opcode: WRTBRri
/* 2476 */    MCD::OPC_FilterValue, 52, 43, 3, 0, // Skip to: 3292
/* 2481 */    MCD::OPC_ExtractField, 5, 9,  // Inst{13-5} ...
/* 2484 */    MCD::OPC_FilterValue, 1, 11, 0, 0, // Skip to: 2500
/* 2489 */    MCD::OPC_CheckField, 14, 5, 0, 223, 19, 0, // Skip to: 7583
/* 2496 */    MCD::OPC_Decode, 160, 3, 33, // Opcode: FMOVS
/* 2500 */    MCD::OPC_FilterValue, 2, 16, 0, 0, // Skip to: 2521
/* 2505 */    MCD::OPC_CheckPredicate, 0, 209, 19, 0, // Skip to: 7583
/* 2510 */    MCD::OPC_CheckField, 14, 5, 0, 202, 19, 0, // Skip to: 7583
/* 2517 */    MCD::OPC_Decode, 149, 3, 34, // Opcode: FMOVD
/* 2521 */    MCD::OPC_FilterValue, 3, 16, 0, 0, // Skip to: 2542
/* 2526 */    MCD::OPC_CheckPredicate, 0, 188, 19, 0, // Skip to: 7583
/* 2531 */    MCD::OPC_CheckField, 14, 5, 0, 181, 19, 0, // Skip to: 7583
/* 2538 */    MCD::OPC_Decode, 153, 3, 35, // Opcode: FMOVQ
/* 2542 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 2558
/* 2547 */    MCD::OPC_CheckField, 14, 5, 0, 165, 19, 0, // Skip to: 7583
/* 2554 */    MCD::OPC_Decode, 180, 3, 33, // Opcode: FNEGS
/* 2558 */    MCD::OPC_FilterValue, 6, 16, 0, 0, // Skip to: 2579
/* 2563 */    MCD::OPC_CheckPredicate, 0, 151, 19, 0, // Skip to: 7583
/* 2568 */    MCD::OPC_CheckField, 14, 5, 0, 144, 19, 0, // Skip to: 7583
/* 2575 */    MCD::OPC_Decode, 178, 3, 34, // Opcode: FNEGD
/* 2579 */    MCD::OPC_FilterValue, 7, 16, 0, 0, // Skip to: 2600
/* 2584 */    MCD::OPC_CheckPredicate, 0, 130, 19, 0, // Skip to: 7583
/* 2589 */    MCD::OPC_CheckField, 14, 5, 0, 123, 19, 0, // Skip to: 7583
/* 2596 */    MCD::OPC_Decode, 179, 3, 35, // Opcode: FNEGQ
/* 2600 */    MCD::OPC_FilterValue, 9, 11, 0, 0, // Skip to: 2616
/* 2605 */    MCD::OPC_CheckField, 14, 5, 0, 107, 19, 0, // Skip to: 7583
/* 2612 */    MCD::OPC_Decode, 224, 2, 33, // Opcode: FABSS
/* 2616 */    MCD::OPC_FilterValue, 10, 16, 0, 0, // Skip to: 2637
/* 2621 */    MCD::OPC_CheckPredicate, 0, 93, 19, 0, // Skip to: 7583
/* 2626 */    MCD::OPC_CheckField, 14, 5, 0, 86, 19, 0, // Skip to: 7583
/* 2633 */    MCD::OPC_Decode, 222, 2, 34, // Opcode: FABSD
/* 2637 */    MCD::OPC_FilterValue, 11, 16, 0, 0, // Skip to: 2658
/* 2642 */    MCD::OPC_CheckPredicate, 0, 72, 19, 0, // Skip to: 7583
/* 2647 */    MCD::OPC_CheckField, 14, 5, 0, 65, 19, 0, // Skip to: 7583
/* 2654 */    MCD::OPC_Decode, 223, 2, 35, // Opcode: FABSQ
/* 2658 */    MCD::OPC_FilterValue, 41, 11, 0, 0, // Skip to: 2674
/* 2663 */    MCD::OPC_CheckField, 14, 5, 0, 49, 19, 0, // Skip to: 7583
/* 2670 */    MCD::OPC_Decode, 224, 3, 33, // Opcode: FSQRTS
/* 2674 */    MCD::OPC_FilterValue, 42, 11, 0, 0, // Skip to: 2690
/* 2679 */    MCD::OPC_CheckField, 14, 5, 0, 33, 19, 0, // Skip to: 7583
/* 2686 */    MCD::OPC_Decode, 222, 3, 34, // Opcode: FSQRTD
/* 2690 */    MCD::OPC_FilterValue, 43, 11, 0, 0, // Skip to: 2706
/* 2695 */    MCD::OPC_CheckField, 14, 5, 0, 17, 19, 0, // Skip to: 7583
/* 2702 */    MCD::OPC_Decode, 223, 3, 35, // Opcode: FSQRTQ
/* 2706 */    MCD::OPC_FilterValue, 65, 4, 0, 0, // Skip to: 2715
/* 2711 */    MCD::OPC_Decode, 227, 2, 36, // Opcode: FADDS
/* 2715 */    MCD::OPC_FilterValue, 66, 4, 0, 0, // Skip to: 2724
/* 2720 */    MCD::OPC_Decode, 225, 2, 37, // Opcode: FADDD
/* 2724 */    MCD::OPC_FilterValue, 67, 4, 0, 0, // Skip to: 2733
/* 2729 */    MCD::OPC_Decode, 226, 2, 38, // Opcode: FADDQ
/* 2733 */    MCD::OPC_FilterValue, 69, 4, 0, 0, // Skip to: 2742
/* 2738 */    MCD::OPC_Decode, 239, 3, 36, // Opcode: FSUBS
/* 2742 */    MCD::OPC_FilterValue, 70, 4, 0, 0, // Skip to: 2751
/* 2747 */    MCD::OPC_Decode, 237, 3, 37, // Opcode: FSUBD
/* 2751 */    MCD::OPC_FilterValue, 71, 4, 0, 0, // Skip to: 2760
/* 2756 */    MCD::OPC_Decode, 238, 3, 38, // Opcode: FSUBQ
/* 2760 */    MCD::OPC_FilterValue, 73, 4, 0, 0, // Skip to: 2769
/* 2765 */    MCD::OPC_Decode, 173, 3, 36, // Opcode: FMULS
/* 2769 */    MCD::OPC_FilterValue, 74, 4, 0, 0, // Skip to: 2778
/* 2774 */    MCD::OPC_Decode, 169, 3, 37, // Opcode: FMULD
/* 2778 */    MCD::OPC_FilterValue, 75, 4, 0, 0, // Skip to: 2787
/* 2783 */    MCD::OPC_Decode, 172, 3, 38, // Opcode: FMULQ
/* 2787 */    MCD::OPC_FilterValue, 77, 4, 0, 0, // Skip to: 2796
/* 2792 */    MCD::OPC_Decode, 128, 3, 36, // Opcode: FDIVS
/* 2796 */    MCD::OPC_FilterValue, 78, 4, 0, 0, // Skip to: 2805
/* 2801 */    MCD::OPC_Decode, 254, 2, 37, // Opcode: FDIVD
/* 2805 */    MCD::OPC_FilterValue, 79, 4, 0, 0, // Skip to: 2814
/* 2810 */    MCD::OPC_Decode, 255, 2, 38, // Opcode: FDIVQ
/* 2814 */    MCD::OPC_FilterValue, 81, 9, 0, 0, // Skip to: 2828
/* 2819 */    MCD::OPC_CheckPredicate, 2, 151, 18, 0, // Skip to: 7583
/* 2824 */    MCD::OPC_Decode, 175, 3, 37, // Opcode: FNADDS
/* 2828 */    MCD::OPC_FilterValue, 82, 9, 0, 0, // Skip to: 2842
/* 2833 */    MCD::OPC_CheckPredicate, 2, 137, 18, 0, // Skip to: 7583
/* 2838 */    MCD::OPC_Decode, 174, 3, 37, // Opcode: FNADDD
/* 2842 */    MCD::OPC_FilterValue, 89, 9, 0, 0, // Skip to: 2856
/* 2847 */    MCD::OPC_CheckPredicate, 2, 123, 18, 0, // Skip to: 7583
/* 2852 */    MCD::OPC_Decode, 184, 3, 37, // Opcode: FNMULS
/* 2856 */    MCD::OPC_FilterValue, 90, 9, 0, 0, // Skip to: 2870
/* 2861 */    MCD::OPC_CheckPredicate, 2, 109, 18, 0, // Skip to: 7583
/* 2866 */    MCD::OPC_Decode, 183, 3, 37, // Opcode: FNMULD
/* 2870 */    MCD::OPC_FilterValue, 97, 9, 0, 0, // Skip to: 2884
/* 2875 */    MCD::OPC_CheckPredicate, 2, 95, 18, 0, // Skip to: 7583
/* 2880 */    MCD::OPC_Decode, 136, 3, 37, // Opcode: FHADDS
/* 2884 */    MCD::OPC_FilterValue, 98, 9, 0, 0, // Skip to: 2898
/* 2889 */    MCD::OPC_CheckPredicate, 2, 81, 18, 0, // Skip to: 7583
/* 2894 */    MCD::OPC_Decode, 135, 3, 37, // Opcode: FHADDD
/* 2898 */    MCD::OPC_FilterValue, 101, 9, 0, 0, // Skip to: 2912
/* 2903 */    MCD::OPC_CheckPredicate, 2, 67, 18, 0, // Skip to: 7583
/* 2908 */    MCD::OPC_Decode, 138, 3, 37, // Opcode: FHSUBS
/* 2912 */    MCD::OPC_FilterValue, 102, 9, 0, 0, // Skip to: 2926
/* 2917 */    MCD::OPC_CheckPredicate, 2, 53, 18, 0, // Skip to: 7583
/* 2922 */    MCD::OPC_Decode, 137, 3, 37, // Opcode: FHSUBD
/* 2926 */    MCD::OPC_FilterValue, 105, 4, 0, 0, // Skip to: 2935
/* 2931 */    MCD::OPC_Decode, 221, 3, 39, // Opcode: FSMULD
/* 2935 */    MCD::OPC_FilterValue, 110, 4, 0, 0, // Skip to: 2944
/* 2940 */    MCD::OPC_Decode, 129, 3, 40, // Opcode: FDMULQ
/* 2944 */    MCD::OPC_FilterValue, 113, 9, 0, 0, // Skip to: 2958
/* 2949 */    MCD::OPC_CheckPredicate, 2, 21, 18, 0, // Skip to: 7583
/* 2954 */    MCD::OPC_Decode, 182, 3, 37, // Opcode: FNHADDS
/* 2958 */    MCD::OPC_FilterValue, 114, 9, 0, 0, // Skip to: 2972
/* 2963 */    MCD::OPC_CheckPredicate, 2, 7, 18, 0, // Skip to: 7583
/* 2968 */    MCD::OPC_Decode, 181, 3, 37, // Opcode: FNHADDD
/* 2972 */    MCD::OPC_FilterValue, 121, 9, 0, 0, // Skip to: 2986
/* 2977 */    MCD::OPC_CheckPredicate, 2, 249, 17, 0, // Skip to: 7583
/* 2982 */    MCD::OPC_Decode, 191, 3, 37, // Opcode: FNSMULD
/* 2986 */    MCD::OPC_FilterValue, 129, 1, 11, 0, 0, // Skip to: 3003
/* 2992 */    MCD::OPC_CheckField, 14, 5, 0, 232, 17, 0, // Skip to: 7583
/* 2999 */    MCD::OPC_Decode, 236, 3, 41, // Opcode: FSTOX
/* 3003 */    MCD::OPC_FilterValue, 130, 1, 11, 0, 0, // Skip to: 3020
/* 3009 */    MCD::OPC_CheckField, 14, 5, 0, 215, 17, 0, // Skip to: 7583
/* 3016 */    MCD::OPC_Decode, 133, 3, 34, // Opcode: FDTOX
/* 3020 */    MCD::OPC_FilterValue, 131, 1, 11, 0, 0, // Skip to: 3037
/* 3026 */    MCD::OPC_CheckField, 14, 5, 0, 198, 17, 0, // Skip to: 7583
/* 3033 */    MCD::OPC_Decode, 216, 3, 42, // Opcode: FQTOX
/* 3037 */    MCD::OPC_FilterValue, 132, 1, 11, 0, 0, // Skip to: 3054
/* 3043 */    MCD::OPC_CheckField, 14, 5, 0, 181, 17, 0, // Skip to: 7583
/* 3050 */    MCD::OPC_Decode, 246, 3, 43, // Opcode: FXTOS
/* 3054 */    MCD::OPC_FilterValue, 136, 1, 11, 0, 0, // Skip to: 3071
/* 3060 */    MCD::OPC_CheckField, 14, 5, 0, 164, 17, 0, // Skip to: 7583
/* 3067 */    MCD::OPC_Decode, 244, 3, 34, // Opcode: FXTOD
/* 3071 */    MCD::OPC_FilterValue, 140, 1, 11, 0, 0, // Skip to: 3088
/* 3077 */    MCD::OPC_CheckField, 14, 5, 0, 147, 17, 0, // Skip to: 7583
/* 3084 */    MCD::OPC_Decode, 245, 3, 44, // Opcode: FXTOQ
/* 3088 */    MCD::OPC_FilterValue, 196, 1, 11, 0, 0, // Skip to: 3105
/* 3094 */    MCD::OPC_CheckField, 14, 5, 0, 130, 17, 0, // Skip to: 7583
/* 3101 */    MCD::OPC_Decode, 141, 3, 33, // Opcode: FITOS
/* 3105 */    MCD::OPC_FilterValue, 198, 1, 11, 0, 0, // Skip to: 3122
/* 3111 */    MCD::OPC_CheckField, 14, 5, 0, 113, 17, 0, // Skip to: 7583
/* 3118 */    MCD::OPC_Decode, 132, 3, 43, // Opcode: FDTOS
/* 3122 */    MCD::OPC_FilterValue, 199, 1, 11, 0, 0, // Skip to: 3139
/* 3128 */    MCD::OPC_CheckField, 14, 5, 0, 96, 17, 0, // Skip to: 7583
/* 3135 */    MCD::OPC_Decode, 215, 3, 45, // Opcode: FQTOS
/* 3139 */    MCD::OPC_FilterValue, 200, 1, 11, 0, 0, // Skip to: 3156
/* 3145 */    MCD::OPC_CheckField, 14, 5, 0, 79, 17, 0, // Skip to: 7583
/* 3152 */    MCD::OPC_Decode, 139, 3, 41, // Opcode: FITOD
/* 3156 */    MCD::OPC_FilterValue, 201, 1, 11, 0, 0, // Skip to: 3173
/* 3162 */    MCD::OPC_CheckField, 14, 5, 0, 62, 17, 0, // Skip to: 7583
/* 3169 */    MCD::OPC_Decode, 233, 3, 41, // Opcode: FSTOD
/* 3173 */    MCD::OPC_FilterValue, 203, 1, 11, 0, 0, // Skip to: 3190
/* 3179 */    MCD::OPC_CheckField, 14, 5, 0, 45, 17, 0, // Skip to: 7583
/* 3186 */    MCD::OPC_Decode, 213, 3, 42, // Opcode: FQTOD
/* 3190 */    MCD::OPC_FilterValue, 204, 1, 11, 0, 0, // Skip to: 3207
/* 3196 */    MCD::OPC_CheckField, 14, 5, 0, 28, 17, 0, // Skip to: 7583
/* 3203 */    MCD::OPC_Decode, 140, 3, 46, // Opcode: FITOQ
/* 3207 */    MCD::OPC_FilterValue, 205, 1, 11, 0, 0, // Skip to: 3224
/* 3213 */    MCD::OPC_CheckField, 14, 5, 0, 11, 17, 0, // Skip to: 7583
/* 3220 */    MCD::OPC_Decode, 235, 3, 46, // Opcode: FSTOQ
/* 3224 */    MCD::OPC_FilterValue, 206, 1, 11, 0, 0, // Skip to: 3241
/* 3230 */    MCD::OPC_CheckField, 14, 5, 0, 250, 16, 0, // Skip to: 7583
/* 3237 */    MCD::OPC_Decode, 131, 3, 44, // Opcode: FDTOQ
/* 3241 */    MCD::OPC_FilterValue, 209, 1, 11, 0, 0, // Skip to: 3258
/* 3247 */    MCD::OPC_CheckField, 14, 5, 0, 233, 16, 0, // Skip to: 7583
/* 3254 */    MCD::OPC_Decode, 234, 3, 33, // Opcode: FSTOI
/* 3258 */    MCD::OPC_FilterValue, 210, 1, 11, 0, 0, // Skip to: 3275
/* 3264 */    MCD::OPC_CheckField, 14, 5, 0, 216, 16, 0, // Skip to: 7583
/* 3271 */    MCD::OPC_Decode, 130, 3, 43, // Opcode: FDTOI
/* 3275 */    MCD::OPC_FilterValue, 211, 1, 206, 16, 0, // Skip to: 7583
/* 3281 */    MCD::OPC_CheckField, 14, 5, 0, 199, 16, 0, // Skip to: 7583
/* 3288 */    MCD::OPC_Decode, 214, 3, 45, // Opcode: FQTOI
/* 3292 */    MCD::OPC_FilterValue, 53, 188, 1, 0, // Skip to: 3741
/* 3297 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 3300 */    MCD::OPC_FilterValue, 1, 94, 0, 0, // Skip to: 3399
/* 3305 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 3308 */    MCD::OPC_FilterValue, 0, 41, 0, 0, // Skip to: 3354
/* 3313 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 3316 */    MCD::OPC_FilterValue, 0, 166, 16, 0, // Skip to: 7583
/* 3321 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 3324 */    MCD::OPC_FilterValue, 0, 158, 16, 0, // Skip to: 7583
/* 3329 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 3345
/* 3334 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, 0, // Skip to: 3345
/* 3341 */    MCD::OPC_Decode, 161, 3, 47, // Opcode: FMOVS_FCC
/* 3345 */    MCD::OPC_CheckPredicate, 0, 137, 16, 0, // Skip to: 7583
/* 3350 */    MCD::OPC_Decode, 224, 5, 48, // Opcode: V9FMOVS_FCC
/* 3354 */    MCD::OPC_FilterValue, 1, 128, 16, 0, // Skip to: 7583
/* 3359 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 3362 */    MCD::OPC_FilterValue, 0, 16, 0, 0, // Skip to: 3383
/* 3367 */    MCD::OPC_CheckPredicate, 0, 115, 16, 0, // Skip to: 7583
/* 3372 */    MCD::OPC_CheckField, 18, 1, 0, 108, 16, 0, // Skip to: 7583
/* 3379 */    MCD::OPC_Decode, 162, 3, 47, // Opcode: FMOVS_ICC
/* 3383 */    MCD::OPC_FilterValue, 4, 99, 16, 0, // Skip to: 7583
/* 3388 */    MCD::OPC_CheckField, 18, 1, 0, 92, 16, 0, // Skip to: 7583
/* 3395 */    MCD::OPC_Decode, 163, 3, 47, // Opcode: FMOVS_XCC
/* 3399 */    MCD::OPC_FilterValue, 2, 94, 0, 0, // Skip to: 3498
/* 3404 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 3407 */    MCD::OPC_FilterValue, 0, 41, 0, 0, // Skip to: 3453
/* 3412 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 3415 */    MCD::OPC_FilterValue, 0, 67, 16, 0, // Skip to: 7583
/* 3420 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 3423 */    MCD::OPC_FilterValue, 0, 59, 16, 0, // Skip to: 7583
/* 3428 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 3444
/* 3433 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, 0, // Skip to: 3444
/* 3440 */    MCD::OPC_Decode, 150, 3, 49, // Opcode: FMOVD_FCC
/* 3444 */    MCD::OPC_CheckPredicate, 0, 38, 16, 0, // Skip to: 7583
/* 3449 */    MCD::OPC_Decode, 222, 5, 50, // Opcode: V9FMOVD_FCC
/* 3453 */    MCD::OPC_FilterValue, 1, 29, 16, 0, // Skip to: 7583
/* 3458 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 3461 */    MCD::OPC_FilterValue, 0, 16, 0, 0, // Skip to: 3482
/* 3466 */    MCD::OPC_CheckPredicate, 0, 16, 16, 0, // Skip to: 7583
/* 3471 */    MCD::OPC_CheckField, 18, 1, 0, 9, 16, 0, // Skip to: 7583
/* 3478 */    MCD::OPC_Decode, 151, 3, 49, // Opcode: FMOVD_ICC
/* 3482 */    MCD::OPC_FilterValue, 4, 0, 16, 0, // Skip to: 7583
/* 3487 */    MCD::OPC_CheckField, 18, 1, 0, 249, 15, 0, // Skip to: 7583
/* 3494 */    MCD::OPC_Decode, 152, 3, 49, // Opcode: FMOVD_XCC
/* 3498 */    MCD::OPC_FilterValue, 3, 94, 0, 0, // Skip to: 3597
/* 3503 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 3506 */    MCD::OPC_FilterValue, 0, 41, 0, 0, // Skip to: 3552
/* 3511 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 3514 */    MCD::OPC_FilterValue, 0, 224, 15, 0, // Skip to: 7583
/* 3519 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 3522 */    MCD::OPC_FilterValue, 0, 216, 15, 0, // Skip to: 7583
/* 3527 */    MCD::OPC_CheckPredicate, 0, 11, 0, 0, // Skip to: 3543
/* 3532 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, 0, // Skip to: 3543
/* 3539 */    MCD::OPC_Decode, 154, 3, 51, // Opcode: FMOVQ_FCC
/* 3543 */    MCD::OPC_CheckPredicate, 0, 195, 15, 0, // Skip to: 7583
/* 3548 */    MCD::OPC_Decode, 223, 5, 52, // Opcode: V9FMOVQ_FCC
/* 3552 */    MCD::OPC_FilterValue, 1, 186, 15, 0, // Skip to: 7583
/* 3557 */    MCD::OPC_ExtractField, 10, 3,  // Inst{12-10} ...
/* 3560 */    MCD::OPC_FilterValue, 0, 16, 0, 0, // Skip to: 3581
/* 3565 */    MCD::OPC_CheckPredicate, 0, 173, 15, 0, // Skip to: 7583
/* 3570 */    MCD::OPC_CheckField, 18, 1, 0, 166, 15, 0, // Skip to: 7583
/* 3577 */    MCD::OPC_Decode, 155, 3, 51, // Opcode: FMOVQ_ICC
/* 3581 */    MCD::OPC_FilterValue, 4, 157, 15, 0, // Skip to: 7583
/* 3586 */    MCD::OPC_CheckField, 18, 1, 0, 150, 15, 0, // Skip to: 7583
/* 3593 */    MCD::OPC_Decode, 156, 3, 51, // Opcode: FMOVQ_XCC
/* 3597 */    MCD::OPC_FilterValue, 5, 11, 0, 0, // Skip to: 3613
/* 3602 */    MCD::OPC_CheckField, 13, 1, 0, 134, 15, 0, // Skip to: 7583
/* 3609 */    MCD::OPC_Decode, 159, 3, 53, // Opcode: FMOVRS
/* 3613 */    MCD::OPC_FilterValue, 6, 11, 0, 0, // Skip to: 3629
/* 3618 */    MCD::OPC_CheckField, 13, 1, 0, 118, 15, 0, // Skip to: 7583
/* 3625 */    MCD::OPC_Decode, 157, 3, 54, // Opcode: FMOVRD
/* 3629 */    MCD::OPC_FilterValue, 7, 11, 0, 0, // Skip to: 3645
/* 3634 */    MCD::OPC_CheckField, 13, 1, 0, 102, 15, 0, // Skip to: 7583
/* 3641 */    MCD::OPC_Decode, 158, 3, 55, // Opcode: FMOVRQ
/* 3645 */    MCD::OPC_FilterValue, 17, 11, 0, 0, // Skip to: 3661
/* 3650 */    MCD::OPC_CheckField, 10, 4, 2, 86, 15, 0, // Skip to: 7583
/* 3657 */    MCD::OPC_Decode, 221, 5, 56, // Opcode: V9FCMPS
/* 3661 */    MCD::OPC_FilterValue, 18, 11, 0, 0, // Skip to: 3677
/* 3666 */    MCD::OPC_CheckField, 10, 4, 2, 70, 15, 0, // Skip to: 7583
/* 3673 */    MCD::OPC_Decode, 216, 5, 57, // Opcode: V9FCMPD
/* 3677 */    MCD::OPC_FilterValue, 19, 11, 0, 0, // Skip to: 3693
/* 3682 */    MCD::OPC_CheckField, 10, 4, 2, 54, 15, 0, // Skip to: 7583
/* 3689 */    MCD::OPC_Decode, 220, 5, 58, // Opcode: V9FCMPQ
/* 3693 */    MCD::OPC_FilterValue, 21, 11, 0, 0, // Skip to: 3709
/* 3698 */    MCD::OPC_CheckField, 10, 4, 2, 38, 15, 0, // Skip to: 7583
/* 3705 */    MCD::OPC_Decode, 219, 5, 56, // Opcode: V9FCMPES
/* 3709 */    MCD::OPC_FilterValue, 22, 11, 0, 0, // Skip to: 3725
/* 3714 */    MCD::OPC_CheckField, 10, 4, 2, 22, 15, 0, // Skip to: 7583
/* 3721 */    MCD::OPC_Decode, 217, 5, 57, // Opcode: V9FCMPED
/* 3725 */    MCD::OPC_FilterValue, 23, 13, 15, 0, // Skip to: 7583
/* 3730 */    MCD::OPC_CheckField, 10, 4, 2, 6, 15, 0, // Skip to: 7583
/* 3737 */    MCD::OPC_Decode, 218, 5, 58, // Opcode: V9FCMPEQ
/* 3741 */    MCD::OPC_FilterValue, 54, 35, 7, 0, // Skip to: 5573
/* 3746 */    MCD::OPC_ExtractField, 5, 9,  // Inst{13-5} ...
/* 3749 */    MCD::OPC_FilterValue, 0, 9, 0, 0, // Skip to: 3763
/* 3754 */    MCD::OPC_CheckPredicate, 3, 240, 14, 0, // Skip to: 7583
/* 3759 */    MCD::OPC_Decode, 218, 2, 10, // Opcode: EDGE8
/* 3763 */    MCD::OPC_FilterValue, 1, 9, 0, 0, // Skip to: 3777
/* 3768 */    MCD::OPC_CheckPredicate, 4, 226, 14, 0, // Skip to: 7583
/* 3773 */    MCD::OPC_Decode, 221, 2, 10, // Opcode: EDGE8N
/* 3777 */    MCD::OPC_FilterValue, 2, 9, 0, 0, // Skip to: 3791
/* 3782 */    MCD::OPC_CheckPredicate, 3, 212, 14, 0, // Skip to: 7583
/* 3787 */    MCD::OPC_Decode, 219, 2, 10, // Opcode: EDGE8L
/* 3791 */    MCD::OPC_FilterValue, 3, 9, 0, 0, // Skip to: 3805
/* 3796 */    MCD::OPC_CheckPredicate, 4, 198, 14, 0, // Skip to: 7583
/* 3801 */    MCD::OPC_Decode, 220, 2, 10, // Opcode: EDGE8LN
/* 3805 */    MCD::OPC_FilterValue, 4, 9, 0, 0, // Skip to: 3819
/* 3810 */    MCD::OPC_CheckPredicate, 3, 184, 14, 0, // Skip to: 7583
/* 3815 */    MCD::OPC_Decode, 210, 2, 10, // Opcode: EDGE16
/* 3819 */    MCD::OPC_FilterValue, 5, 9, 0, 0, // Skip to: 3833
/* 3824 */    MCD::OPC_CheckPredicate, 4, 170, 14, 0, // Skip to: 7583
/* 3829 */    MCD::OPC_Decode, 213, 2, 10, // Opcode: EDGE16N
/* 3833 */    MCD::OPC_FilterValue, 6, 9, 0, 0, // Skip to: 3847
/* 3838 */    MCD::OPC_CheckPredicate, 3, 156, 14, 0, // Skip to: 7583
/* 3843 */    MCD::OPC_Decode, 211, 2, 10, // Opcode: EDGE16L
/* 3847 */    MCD::OPC_FilterValue, 7, 9, 0, 0, // Skip to: 3861
/* 3852 */    MCD::OPC_CheckPredicate, 4, 142, 14, 0, // Skip to: 7583
/* 3857 */    MCD::OPC_Decode, 212, 2, 10, // Opcode: EDGE16LN
/* 3861 */    MCD::OPC_FilterValue, 8, 9, 0, 0, // Skip to: 3875
/* 3866 */    MCD::OPC_CheckPredicate, 3, 128, 14, 0, // Skip to: 7583
/* 3871 */    MCD::OPC_Decode, 214, 2, 10, // Opcode: EDGE32
/* 3875 */    MCD::OPC_FilterValue, 9, 9, 0, 0, // Skip to: 3889
/* 3880 */    MCD::OPC_CheckPredicate, 4, 114, 14, 0, // Skip to: 7583
/* 3885 */    MCD::OPC_Decode, 217, 2, 10, // Opcode: EDGE32N
/* 3889 */    MCD::OPC_FilterValue, 10, 9, 0, 0, // Skip to: 3903
/* 3894 */    MCD::OPC_CheckPredicate, 3, 100, 14, 0, // Skip to: 7583
/* 3899 */    MCD::OPC_Decode, 215, 2, 10, // Opcode: EDGE32L
/* 3903 */    MCD::OPC_FilterValue, 11, 9, 0, 0, // Skip to: 3917
/* 3908 */    MCD::OPC_CheckPredicate, 4, 86, 14, 0, // Skip to: 7583
/* 3913 */    MCD::OPC_Decode, 216, 2, 10, // Opcode: EDGE32LN
/* 3917 */    MCD::OPC_FilterValue, 16, 9, 0, 0, // Skip to: 3931
/* 3922 */    MCD::OPC_CheckPredicate, 3, 72, 14, 0, // Skip to: 7583
/* 3927 */    MCD::OPC_Decode, 171, 2, 10, // Opcode: ARRAY8
/* 3931 */    MCD::OPC_FilterValue, 17, 9, 0, 0, // Skip to: 3945
/* 3936 */    MCD::OPC_CheckPredicate, 2, 58, 14, 0, // Skip to: 7583
/* 3941 */    MCD::OPC_Decode, 150, 2, 10, // Opcode: ADDXC
/* 3945 */    MCD::OPC_FilterValue, 18, 9, 0, 0, // Skip to: 3959
/* 3950 */    MCD::OPC_CheckPredicate, 3, 44, 14, 0, // Skip to: 7583
/* 3955 */    MCD::OPC_Decode, 169, 2, 10, // Opcode: ARRAY16
/* 3959 */    MCD::OPC_FilterValue, 19, 9, 0, 0, // Skip to: 3973
/* 3964 */    MCD::OPC_CheckPredicate, 2, 30, 14, 0, // Skip to: 7583
/* 3969 */    MCD::OPC_Decode, 151, 2, 10, // Opcode: ADDXCCC
/* 3973 */    MCD::OPC_FilterValue, 20, 9, 0, 0, // Skip to: 3987
/* 3978 */    MCD::OPC_CheckPredicate, 3, 16, 14, 0, // Skip to: 7583
/* 3983 */    MCD::OPC_Decode, 170, 2, 10, // Opcode: ARRAY32
/* 3987 */    MCD::OPC_FilterValue, 22, 9, 0, 0, // Skip to: 4001
/* 3992 */    MCD::OPC_CheckPredicate, 2, 2, 14, 0, // Skip to: 7583
/* 3997 */    MCD::OPC_Decode, 212, 5, 10, // Opcode: UMULXHI
/* 4001 */    MCD::OPC_FilterValue, 23, 16, 0, 0, // Skip to: 4022
/* 4006 */    MCD::OPC_CheckPredicate, 2, 244, 13, 0, // Skip to: 7583
/* 4011 */    MCD::OPC_CheckField, 14, 5, 0, 237, 13, 0, // Skip to: 7583
/* 4018 */    MCD::OPC_Decode, 171, 4, 59, // Opcode: LZCNT
/* 4022 */    MCD::OPC_FilterValue, 24, 9, 0, 0, // Skip to: 4036
/* 4027 */    MCD::OPC_CheckPredicate, 3, 223, 13, 0, // Skip to: 7583
/* 4032 */    MCD::OPC_Decode, 156, 2, 10, // Opcode: ALIGNADDR
/* 4036 */    MCD::OPC_FilterValue, 25, 9, 0, 0, // Skip to: 4050
/* 4041 */    MCD::OPC_CheckPredicate, 4, 209, 13, 0, // Skip to: 7583
/* 4046 */    MCD::OPC_Decode, 177, 2, 10, // Opcode: BMASK
/* 4050 */    MCD::OPC_FilterValue, 26, 9, 0, 0, // Skip to: 4064
/* 4055 */    MCD::OPC_CheckPredicate, 3, 195, 13, 0, // Skip to: 7583
/* 4060 */    MCD::OPC_Decode, 157, 2, 10, // Opcode: ALIGNADDRL
/* 4064 */    MCD::OPC_FilterValue, 27, 23, 0, 0, // Skip to: 4092
/* 4069 */    MCD::OPC_CheckPredicate, 2, 181, 13, 0, // Skip to: 7583
/* 4074 */    MCD::OPC_CheckField, 25, 5, 0, 174, 13, 0, // Skip to: 7583
/* 4081 */    MCD::OPC_CheckField, 14, 5, 0, 167, 13, 0, // Skip to: 7583
/* 4088 */    MCD::OPC_Decode, 206, 2, 60, // Opcode: CMASK8
/* 4092 */    MCD::OPC_FilterValue, 28, 9, 0, 0, // Skip to: 4106
/* 4097 */    MCD::OPC_CheckPredicate, 4, 153, 13, 0, // Skip to: 7583
/* 4102 */    MCD::OPC_Decode, 194, 2, 37, // Opcode: BSHUFFLE
/* 4106 */    MCD::OPC_FilterValue, 29, 23, 0, 0, // Skip to: 4134
/* 4111 */    MCD::OPC_CheckPredicate, 2, 139, 13, 0, // Skip to: 7583
/* 4116 */    MCD::OPC_CheckField, 25, 5, 0, 132, 13, 0, // Skip to: 7583
/* 4123 */    MCD::OPC_CheckField, 14, 5, 0, 125, 13, 0, // Skip to: 7583
/* 4130 */    MCD::OPC_Decode, 204, 2, 60, // Opcode: CMASK16
/* 4134 */    MCD::OPC_FilterValue, 31, 23, 0, 0, // Skip to: 4162
/* 4139 */    MCD::OPC_CheckPredicate, 2, 111, 13, 0, // Skip to: 7583
/* 4144 */    MCD::OPC_CheckField, 25, 5, 0, 104, 13, 0, // Skip to: 7583
/* 4151 */    MCD::OPC_CheckField, 14, 5, 0, 97, 13, 0, // Skip to: 7583
/* 4158 */    MCD::OPC_Decode, 205, 2, 60, // Opcode: CMASK32
/* 4162 */    MCD::OPC_FilterValue, 32, 9, 0, 0, // Skip to: 4176
/* 4167 */    MCD::OPC_CheckPredicate, 3, 83, 13, 0, // Skip to: 7583
/* 4172 */    MCD::OPC_Decode, 246, 2, 61, // Opcode: FCMPLE16
/* 4176 */    MCD::OPC_FilterValue, 33, 9, 0, 0, // Skip to: 4190
/* 4181 */    MCD::OPC_CheckPredicate, 2, 69, 13, 0, // Skip to: 7583
/* 4186 */    MCD::OPC_Decode, 219, 3, 37, // Opcode: FSLL16
/* 4190 */    MCD::OPC_FilterValue, 34, 9, 0, 0, // Skip to: 4204
/* 4195 */    MCD::OPC_CheckPredicate, 3, 55, 13, 0, // Skip to: 7583
/* 4200 */    MCD::OPC_Decode, 248, 2, 61, // Opcode: FCMPNE16
/* 4204 */    MCD::OPC_FilterValue, 35, 9, 0, 0, // Skip to: 4218
/* 4209 */    MCD::OPC_CheckPredicate, 2, 41, 13, 0, // Skip to: 7583
/* 4214 */    MCD::OPC_Decode, 231, 3, 37, // Opcode: FSRL16
/* 4218 */    MCD::OPC_FilterValue, 36, 9, 0, 0, // Skip to: 4232
/* 4223 */    MCD::OPC_CheckPredicate, 3, 27, 13, 0, // Skip to: 7583
/* 4228 */    MCD::OPC_Decode, 247, 2, 61, // Opcode: FCMPLE32
/* 4232 */    MCD::OPC_FilterValue, 37, 9, 0, 0, // Skip to: 4246
/* 4237 */    MCD::OPC_CheckPredicate, 2, 13, 13, 0, // Skip to: 7583
/* 4242 */    MCD::OPC_Decode, 220, 3, 37, // Opcode: FSLL32
/* 4246 */    MCD::OPC_FilterValue, 38, 9, 0, 0, // Skip to: 4260
/* 4251 */    MCD::OPC_CheckPredicate, 3, 255, 12, 0, // Skip to: 7583
/* 4256 */    MCD::OPC_Decode, 249, 2, 61, // Opcode: FCMPNE32
/* 4260 */    MCD::OPC_FilterValue, 39, 9, 0, 0, // Skip to: 4274
/* 4265 */    MCD::OPC_CheckPredicate, 2, 241, 12, 0, // Skip to: 7583
/* 4270 */    MCD::OPC_Decode, 232, 3, 37, // Opcode: FSRL32
/* 4274 */    MCD::OPC_FilterValue, 40, 9, 0, 0, // Skip to: 4288
/* 4279 */    MCD::OPC_CheckPredicate, 3, 227, 12, 0, // Skip to: 7583
/* 4284 */    MCD::OPC_Decode, 244, 2, 61, // Opcode: FCMPGT16
/* 4288 */    MCD::OPC_FilterValue, 41, 9, 0, 0, // Skip to: 4302
/* 4293 */    MCD::OPC_CheckPredicate, 2, 213, 12, 0, // Skip to: 7583
/* 4298 */    MCD::OPC_Decode, 217, 3, 37, // Opcode: FSLAS16
/* 4302 */    MCD::OPC_FilterValue, 42, 9, 0, 0, // Skip to: 4316
/* 4307 */    MCD::OPC_CheckPredicate, 3, 199, 12, 0, // Skip to: 7583
/* 4312 */    MCD::OPC_Decode, 242, 2, 61, // Opcode: FCMPEQ16
/* 4316 */    MCD::OPC_FilterValue, 43, 9, 0, 0, // Skip to: 4330
/* 4321 */    MCD::OPC_CheckPredicate, 2, 185, 12, 0, // Skip to: 7583
/* 4326 */    MCD::OPC_Decode, 225, 3, 37, // Opcode: FSRA16
/* 4330 */    MCD::OPC_FilterValue, 44, 9, 0, 0, // Skip to: 4344
/* 4335 */    MCD::OPC_CheckPredicate, 3, 171, 12, 0, // Skip to: 7583
/* 4340 */    MCD::OPC_Decode, 245, 2, 61, // Opcode: FCMPGT32
/* 4344 */    MCD::OPC_FilterValue, 45, 9, 0, 0, // Skip to: 4358
/* 4349 */    MCD::OPC_CheckPredicate, 2, 157, 12, 0, // Skip to: 7583
/* 4354 */    MCD::OPC_Decode, 218, 3, 37, // Opcode: FSLAS32
/* 4358 */    MCD::OPC_FilterValue, 46, 9, 0, 0, // Skip to: 4372
/* 4363 */    MCD::OPC_CheckPredicate, 3, 143, 12, 0, // Skip to: 7583
/* 4368 */    MCD::OPC_Decode, 243, 2, 61, // Opcode: FCMPEQ32
/* 4372 */    MCD::OPC_FilterValue, 47, 9, 0, 0, // Skip to: 4386
/* 4377 */    MCD::OPC_CheckPredicate, 2, 129, 12, 0, // Skip to: 7583
/* 4382 */    MCD::OPC_Decode, 226, 3, 37, // Opcode: FSRA32
/* 4386 */    MCD::OPC_FilterValue, 49, 9, 0, 0, // Skip to: 4400
/* 4391 */    MCD::OPC_CheckPredicate, 3, 115, 12, 0, // Skip to: 7583
/* 4396 */    MCD::OPC_Decode, 166, 3, 37, // Opcode: FMUL8X16
/* 4400 */    MCD::OPC_FilterValue, 51, 9, 0, 0, // Skip to: 4414
/* 4405 */    MCD::OPC_CheckPredicate, 3, 101, 12, 0, // Skip to: 7583
/* 4410 */    MCD::OPC_Decode, 168, 3, 37, // Opcode: FMUL8X16AU
/* 4414 */    MCD::OPC_FilterValue, 53, 9, 0, 0, // Skip to: 4428
/* 4419 */    MCD::OPC_CheckPredicate, 3, 87, 12, 0, // Skip to: 7583
/* 4424 */    MCD::OPC_Decode, 167, 3, 37, // Opcode: FMUL8X16AL
/* 4428 */    MCD::OPC_FilterValue, 54, 9, 0, 0, // Skip to: 4442
/* 4433 */    MCD::OPC_CheckPredicate, 3, 73, 12, 0, // Skip to: 7583
/* 4438 */    MCD::OPC_Decode, 164, 3, 37, // Opcode: FMUL8SUX16
/* 4442 */    MCD::OPC_FilterValue, 55, 9, 0, 0, // Skip to: 4456
/* 4447 */    MCD::OPC_CheckPredicate, 3, 59, 12, 0, // Skip to: 7583
/* 4452 */    MCD::OPC_Decode, 165, 3, 37, // Opcode: FMUL8ULX16
/* 4456 */    MCD::OPC_FilterValue, 56, 9, 0, 0, // Skip to: 4470
/* 4461 */    MCD::OPC_CheckPredicate, 3, 45, 12, 0, // Skip to: 7583
/* 4466 */    MCD::OPC_Decode, 170, 3, 37, // Opcode: FMULD8SUX16
/* 4470 */    MCD::OPC_FilterValue, 57, 9, 0, 0, // Skip to: 4484
/* 4475 */    MCD::OPC_CheckPredicate, 3, 31, 12, 0, // Skip to: 7583
/* 4480 */    MCD::OPC_Decode, 171, 3, 37, // Opcode: FMULD8ULX16
/* 4484 */    MCD::OPC_FilterValue, 58, 9, 0, 0, // Skip to: 4498
/* 4489 */    MCD::OPC_CheckPredicate, 3, 17, 12, 0, // Skip to: 7583
/* 4494 */    MCD::OPC_Decode, 201, 3, 37, // Opcode: FPACK32
/* 4498 */    MCD::OPC_FilterValue, 59, 16, 0, 0, // Skip to: 4519
/* 4503 */    MCD::OPC_CheckPredicate, 3, 3, 12, 0, // Skip to: 7583
/* 4508 */    MCD::OPC_CheckField, 14, 5, 0, 252, 11, 0, // Skip to: 7583
/* 4515 */    MCD::OPC_Decode, 200, 3, 34, // Opcode: FPACK16
/* 4519 */    MCD::OPC_FilterValue, 61, 16, 0, 0, // Skip to: 4540
/* 4524 */    MCD::OPC_CheckPredicate, 3, 238, 11, 0, // Skip to: 7583
/* 4529 */    MCD::OPC_CheckField, 14, 5, 0, 231, 11, 0, // Skip to: 7583
/* 4536 */    MCD::OPC_Decode, 202, 3, 34, // Opcode: FPACKFIX
/* 4540 */    MCD::OPC_FilterValue, 62, 9, 0, 0, // Skip to: 4554
/* 4545 */    MCD::OPC_CheckPredicate, 3, 217, 11, 0, // Skip to: 7583
/* 4550 */    MCD::OPC_Decode, 202, 4, 37, // Opcode: PDIST
/* 4554 */    MCD::OPC_FilterValue, 63, 9, 0, 0, // Skip to: 4568
/* 4559 */    MCD::OPC_CheckPredicate, 2, 203, 11, 0, // Skip to: 7583
/* 4564 */    MCD::OPC_Decode, 203, 4, 37, // Opcode: PDISTN
/* 4568 */    MCD::OPC_FilterValue, 64, 9, 0, 0, // Skip to: 4582
/* 4573 */    MCD::OPC_CheckPredicate, 2, 189, 11, 0, // Skip to: 7583
/* 4578 */    MCD::OPC_Decode, 148, 3, 37, // Opcode: FMEAN16
/* 4582 */    MCD::OPC_FilterValue, 66, 9, 0, 0, // Skip to: 4596
/* 4587 */    MCD::OPC_CheckPredicate, 2, 175, 11, 0, // Skip to: 7583
/* 4592 */    MCD::OPC_Decode, 207, 3, 37, // Opcode: FPADD64
/* 4596 */    MCD::OPC_FilterValue, 68, 9, 0, 0, // Skip to: 4610
/* 4601 */    MCD::OPC_CheckPredicate, 2, 161, 11, 0, // Skip to: 7583
/* 4606 */    MCD::OPC_Decode, 239, 2, 37, // Opcode: FCHKSM16
/* 4610 */    MCD::OPC_FilterValue, 72, 9, 0, 0, // Skip to: 4624
/* 4615 */    MCD::OPC_CheckPredicate, 3, 147, 11, 0, // Skip to: 7583
/* 4620 */    MCD::OPC_Decode, 228, 2, 37, // Opcode: FALIGNADATA
/* 4624 */    MCD::OPC_FilterValue, 75, 9, 0, 0, // Skip to: 4638
/* 4629 */    MCD::OPC_CheckPredicate, 3, 133, 11, 0, // Skip to: 7583
/* 4634 */    MCD::OPC_Decode, 208, 3, 37, // Opcode: FPMERGE
/* 4638 */    MCD::OPC_FilterValue, 77, 16, 0, 0, // Skip to: 4659
/* 4643 */    MCD::OPC_CheckPredicate, 3, 119, 11, 0, // Skip to: 7583
/* 4648 */    MCD::OPC_CheckField, 14, 5, 0, 112, 11, 0, // Skip to: 7583
/* 4655 */    MCD::OPC_Decode, 134, 3, 34, // Opcode: FEXPAND
/* 4659 */    MCD::OPC_FilterValue, 80, 9, 0, 0, // Skip to: 4673
/* 4664 */    MCD::OPC_CheckPredicate, 3, 98, 11, 0, // Skip to: 7583
/* 4669 */    MCD::OPC_Decode, 203, 3, 37, // Opcode: FPADD16
/* 4673 */    MCD::OPC_FilterValue, 81, 9, 0, 0, // Skip to: 4687
/* 4678 */    MCD::OPC_CheckPredicate, 3, 84, 11, 0, // Skip to: 7583
/* 4683 */    MCD::OPC_Decode, 204, 3, 37, // Opcode: FPADD16S
/* 4687 */    MCD::OPC_FilterValue, 82, 9, 0, 0, // Skip to: 4701
/* 4692 */    MCD::OPC_CheckPredicate, 3, 70, 11, 0, // Skip to: 7583
/* 4697 */    MCD::OPC_Decode, 205, 3, 37, // Opcode: FPADD32
/* 4701 */    MCD::OPC_FilterValue, 83, 9, 0, 0, // Skip to: 4715
/* 4706 */    MCD::OPC_CheckPredicate, 3, 56, 11, 0, // Skip to: 7583
/* 4711 */    MCD::OPC_Decode, 206, 3, 37, // Opcode: FPADD32S
/* 4715 */    MCD::OPC_FilterValue, 84, 9, 0, 0, // Skip to: 4729
/* 4720 */    MCD::OPC_CheckPredicate, 3, 42, 11, 0, // Skip to: 7583
/* 4725 */    MCD::OPC_Decode, 209, 3, 37, // Opcode: FPSUB16
/* 4729 */    MCD::OPC_FilterValue, 85, 9, 0, 0, // Skip to: 4743
/* 4734 */    MCD::OPC_CheckPredicate, 3, 28, 11, 0, // Skip to: 7583
/* 4739 */    MCD::OPC_Decode, 210, 3, 37, // Opcode: FPSUB16S
/* 4743 */    MCD::OPC_FilterValue, 86, 9, 0, 0, // Skip to: 4757
/* 4748 */    MCD::OPC_CheckPredicate, 3, 14, 11, 0, // Skip to: 7583
/* 4753 */    MCD::OPC_Decode, 211, 3, 37, // Opcode: FPSUB32
/* 4757 */    MCD::OPC_FilterValue, 87, 9, 0, 0, // Skip to: 4771
/* 4762 */    MCD::OPC_CheckPredicate, 3, 0, 11, 0, // Skip to: 7583
/* 4767 */    MCD::OPC_Decode, 212, 3, 37, // Opcode: FPSUB32S
/* 4771 */    MCD::OPC_FilterValue, 96, 23, 0, 0, // Skip to: 4799
/* 4776 */    MCD::OPC_CheckPredicate, 3, 242, 10, 0, // Skip to: 7583
/* 4781 */    MCD::OPC_CheckField, 14, 5, 0, 235, 10, 0, // Skip to: 7583
/* 4788 */    MCD::OPC_CheckField, 0, 5, 0, 228, 10, 0, // Skip to: 7583
/* 4795 */    MCD::OPC_Decode, 247, 3, 62, // Opcode: FZERO
/* 4799 */    MCD::OPC_FilterValue, 97, 23, 0, 0, // Skip to: 4827
/* 4804 */    MCD::OPC_CheckPredicate, 3, 214, 10, 0, // Skip to: 7583
/* 4809 */    MCD::OPC_CheckField, 14, 5, 0, 207, 10, 0, // Skip to: 7583
/* 4816 */    MCD::OPC_CheckField, 0, 5, 0, 200, 10, 0, // Skip to: 7583
/* 4823 */    MCD::OPC_Decode, 248, 3, 63, // Opcode: FZEROS
/* 4827 */    MCD::OPC_FilterValue, 98, 9, 0, 0, // Skip to: 4841
/* 4832 */    MCD::OPC_CheckPredicate, 3, 186, 10, 0, // Skip to: 7583
/* 4837 */    MCD::OPC_Decode, 185, 3, 37, // Opcode: FNOR
/* 4841 */    MCD::OPC_FilterValue, 99, 9, 0, 0, // Skip to: 4855
/* 4846 */    MCD::OPC_CheckPredicate, 3, 172, 10, 0, // Skip to: 7583
/* 4851 */    MCD::OPC_Decode, 186, 3, 36, // Opcode: FNORS
/* 4855 */    MCD::OPC_FilterValue, 100, 9, 0, 0, // Skip to: 4869
/* 4860 */    MCD::OPC_CheckPredicate, 3, 158, 10, 0, // Skip to: 7583
/* 4865 */    MCD::OPC_Decode, 232, 2, 37, // Opcode: FANDNOT2
/* 4869 */    MCD::OPC_FilterValue, 101, 9, 0, 0, // Skip to: 4883
/* 4874 */    MCD::OPC_CheckPredicate, 3, 144, 10, 0, // Skip to: 7583
/* 4879 */    MCD::OPC_Decode, 233, 2, 36, // Opcode: FANDNOT2S
/* 4883 */    MCD::OPC_FilterValue, 102, 16, 0, 0, // Skip to: 4904
/* 4888 */    MCD::OPC_CheckPredicate, 3, 130, 10, 0, // Skip to: 7583
/* 4893 */    MCD::OPC_CheckField, 14, 5, 0, 123, 10, 0, // Skip to: 7583
/* 4900 */    MCD::OPC_Decode, 189, 3, 34, // Opcode: FNOT2
/* 4904 */    MCD::OPC_FilterValue, 103, 16, 0, 0, // Skip to: 4925
/* 4909 */    MCD::OPC_CheckPredicate, 3, 109, 10, 0, // Skip to: 7583
/* 4914 */    MCD::OPC_CheckField, 14, 5, 0, 102, 10, 0, // Skip to: 7583
/* 4921 */    MCD::OPC_Decode, 190, 3, 33, // Opcode: FNOT2S
/* 4925 */    MCD::OPC_FilterValue, 104, 9, 0, 0, // Skip to: 4939
/* 4930 */    MCD::OPC_CheckPredicate, 3, 88, 10, 0, // Skip to: 7583
/* 4935 */    MCD::OPC_Decode, 230, 2, 37, // Opcode: FANDNOT1
/* 4939 */    MCD::OPC_FilterValue, 105, 9, 0, 0, // Skip to: 4953
/* 4944 */    MCD::OPC_CheckPredicate, 3, 74, 10, 0, // Skip to: 7583
/* 4949 */    MCD::OPC_Decode, 231, 2, 36, // Opcode: FANDNOT1S
/* 4953 */    MCD::OPC_FilterValue, 106, 16, 0, 0, // Skip to: 4974
/* 4958 */    MCD::OPC_CheckPredicate, 3, 60, 10, 0, // Skip to: 7583
/* 4963 */    MCD::OPC_CheckField, 0, 5, 0, 53, 10, 0, // Skip to: 7583
/* 4970 */    MCD::OPC_Decode, 187, 3, 64, // Opcode: FNOT1
/* 4974 */    MCD::OPC_FilterValue, 107, 16, 0, 0, // Skip to: 4995
/* 4979 */    MCD::OPC_CheckPredicate, 3, 39, 10, 0, // Skip to: 7583
/* 4984 */    MCD::OPC_CheckField, 0, 5, 0, 32, 10, 0, // Skip to: 7583
/* 4991 */    MCD::OPC_Decode, 188, 3, 65, // Opcode: FNOT1S
/* 4995 */    MCD::OPC_FilterValue, 108, 9, 0, 0, // Skip to: 5009
/* 5000 */    MCD::OPC_CheckPredicate, 3, 18, 10, 0, // Skip to: 7583
/* 5005 */    MCD::OPC_Decode, 242, 3, 37, // Opcode: FXOR
/* 5009 */    MCD::OPC_FilterValue, 109, 9, 0, 0, // Skip to: 5023
/* 5014 */    MCD::OPC_CheckPredicate, 3, 4, 10, 0, // Skip to: 7583
/* 5019 */    MCD::OPC_Decode, 243, 3, 36, // Opcode: FXORS
/* 5023 */    MCD::OPC_FilterValue, 110, 9, 0, 0, // Skip to: 5037
/* 5028 */    MCD::OPC_CheckPredicate, 3, 246, 9, 0, // Skip to: 7583
/* 5033 */    MCD::OPC_Decode, 176, 3, 37, // Opcode: FNAND
/* 5037 */    MCD::OPC_FilterValue, 111, 9, 0, 0, // Skip to: 5051
/* 5042 */    MCD::OPC_CheckPredicate, 3, 232, 9, 0, // Skip to: 7583
/* 5047 */    MCD::OPC_Decode, 177, 3, 36, // Opcode: FNANDS
/* 5051 */    MCD::OPC_FilterValue, 112, 9, 0, 0, // Skip to: 5065
/* 5056 */    MCD::OPC_CheckPredicate, 3, 218, 9, 0, // Skip to: 7583
/* 5061 */    MCD::OPC_Decode, 229, 2, 37, // Opcode: FAND
/* 5065 */    MCD::OPC_FilterValue, 113, 9, 0, 0, // Skip to: 5079
/* 5070 */    MCD::OPC_CheckPredicate, 3, 204, 9, 0, // Skip to: 7583
/* 5075 */    MCD::OPC_Decode, 234, 2, 36, // Opcode: FANDS
/* 5079 */    MCD::OPC_FilterValue, 114, 9, 0, 0, // Skip to: 5093
/* 5084 */    MCD::OPC_CheckPredicate, 3, 190, 9, 0, // Skip to: 7583
/* 5089 */    MCD::OPC_Decode, 240, 3, 37, // Opcode: FXNOR
/* 5093 */    MCD::OPC_FilterValue, 115, 9, 0, 0, // Skip to: 5107
/* 5098 */    MCD::OPC_CheckPredicate, 3, 176, 9, 0, // Skip to: 7583
/* 5103 */    MCD::OPC_Decode, 241, 3, 36, // Opcode: FXNORS
/* 5107 */    MCD::OPC_FilterValue, 116, 16, 0, 0, // Skip to: 5128
/* 5112 */    MCD::OPC_CheckPredicate, 3, 162, 9, 0, // Skip to: 7583
/* 5117 */    MCD::OPC_CheckField, 0, 5, 0, 155, 9, 0, // Skip to: 7583
/* 5124 */    MCD::OPC_Decode, 227, 3, 64, // Opcode: FSRC1
/* 5128 */    MCD::OPC_FilterValue, 117, 16, 0, 0, // Skip to: 5149
/* 5133 */    MCD::OPC_CheckPredicate, 3, 141, 9, 0, // Skip to: 7583
/* 5138 */    MCD::OPC_CheckField, 0, 5, 0, 134, 9, 0, // Skip to: 7583
/* 5145 */    MCD::OPC_Decode, 228, 3, 65, // Opcode: FSRC1S
/* 5149 */    MCD::OPC_FilterValue, 118, 9, 0, 0, // Skip to: 5163
/* 5154 */    MCD::OPC_CheckPredicate, 3, 120, 9, 0, // Skip to: 7583
/* 5159 */    MCD::OPC_Decode, 197, 3, 37, // Opcode: FORNOT2
/* 5163 */    MCD::OPC_FilterValue, 119, 9, 0, 0, // Skip to: 5177
/* 5168 */    MCD::OPC_CheckPredicate, 3, 106, 9, 0, // Skip to: 7583
/* 5173 */    MCD::OPC_Decode, 198, 3, 36, // Opcode: FORNOT2S
/* 5177 */    MCD::OPC_FilterValue, 120, 16, 0, 0, // Skip to: 5198
/* 5182 */    MCD::OPC_CheckPredicate, 3, 92, 9, 0, // Skip to: 7583
/* 5187 */    MCD::OPC_CheckField, 14, 5, 0, 85, 9, 0, // Skip to: 7583
/* 5194 */    MCD::OPC_Decode, 229, 3, 34, // Opcode: FSRC2
/* 5198 */    MCD::OPC_FilterValue, 121, 16, 0, 0, // Skip to: 5219
/* 5203 */    MCD::OPC_CheckPredicate, 3, 71, 9, 0, // Skip to: 7583
/* 5208 */    MCD::OPC_CheckField, 14, 5, 0, 64, 9, 0, // Skip to: 7583
/* 5215 */    MCD::OPC_Decode, 230, 3, 33, // Opcode: FSRC2S
/* 5219 */    MCD::OPC_FilterValue, 122, 9, 0, 0, // Skip to: 5233
/* 5224 */    MCD::OPC_CheckPredicate, 3, 50, 9, 0, // Skip to: 7583
/* 5229 */    MCD::OPC_Decode, 195, 3, 37, // Opcode: FORNOT1
/* 5233 */    MCD::OPC_FilterValue, 123, 9, 0, 0, // Skip to: 5247
/* 5238 */    MCD::OPC_CheckPredicate, 3, 36, 9, 0, // Skip to: 7583
/* 5243 */    MCD::OPC_Decode, 196, 3, 36, // Opcode: FORNOT1S
/* 5247 */    MCD::OPC_FilterValue, 124, 9, 0, 0, // Skip to: 5261
/* 5252 */    MCD::OPC_CheckPredicate, 3, 22, 9, 0, // Skip to: 7583
/* 5257 */    MCD::OPC_Decode, 194, 3, 37, // Opcode: FOR
/* 5261 */    MCD::OPC_FilterValue, 125, 9, 0, 0, // Skip to: 5275
/* 5266 */    MCD::OPC_CheckPredicate, 3, 8, 9, 0, // Skip to: 7583
/* 5271 */    MCD::OPC_Decode, 199, 3, 36, // Opcode: FORS
/* 5275 */    MCD::OPC_FilterValue, 126, 23, 0, 0, // Skip to: 5303
/* 5280 */    MCD::OPC_CheckPredicate, 3, 250, 8, 0, // Skip to: 7583
/* 5285 */    MCD::OPC_CheckField, 14, 5, 0, 243, 8, 0, // Skip to: 7583
/* 5292 */    MCD::OPC_CheckField, 0, 5, 0, 236, 8, 0, // Skip to: 7583
/* 5299 */    MCD::OPC_Decode, 192, 3, 62, // Opcode: FONE
/* 5303 */    MCD::OPC_FilterValue, 127, 23, 0, 0, // Skip to: 5331
/* 5308 */    MCD::OPC_CheckPredicate, 3, 222, 8, 0, // Skip to: 7583
/* 5313 */    MCD::OPC_CheckField, 14, 5, 0, 215, 8, 0, // Skip to: 7583
/* 5320 */    MCD::OPC_CheckField, 0, 5, 0, 208, 8, 0, // Skip to: 7583
/* 5327 */    MCD::OPC_Decode, 193, 3, 63, // Opcode: FONES
/* 5331 */    MCD::OPC_FilterValue, 128, 1, 30, 0, 0, // Skip to: 5367
/* 5337 */    MCD::OPC_CheckPredicate, 3, 193, 8, 0, // Skip to: 7583
/* 5342 */    MCD::OPC_CheckField, 25, 5, 0, 186, 8, 0, // Skip to: 7583
/* 5349 */    MCD::OPC_CheckField, 14, 5, 0, 179, 8, 0, // Skip to: 7583
/* 5356 */    MCD::OPC_CheckField, 0, 5, 0, 172, 8, 0, // Skip to: 7583
/* 5363 */    MCD::OPC_Decode, 234, 4, 4, // Opcode: SHUTDOWN
/* 5367 */    MCD::OPC_FilterValue, 129, 1, 30, 0, 0, // Skip to: 5403
/* 5373 */    MCD::OPC_CheckPredicate, 4, 157, 8, 0, // Skip to: 7583
/* 5378 */    MCD::OPC_CheckField, 25, 5, 0, 150, 8, 0, // Skip to: 7583
/* 5385 */    MCD::OPC_CheckField, 14, 5, 0, 143, 8, 0, // Skip to: 7583
/* 5392 */    MCD::OPC_CheckField, 0, 5, 0, 136, 8, 0, // Skip to: 7583
/* 5399 */    MCD::OPC_Decode, 235, 4, 4, // Opcode: SIAM
/* 5403 */    MCD::OPC_FilterValue, 144, 2, 16, 0, 0, // Skip to: 5425
/* 5409 */    MCD::OPC_CheckPredicate, 2, 121, 8, 0, // Skip to: 7583
/* 5414 */    MCD::OPC_CheckField, 14, 5, 0, 114, 8, 0, // Skip to: 7583
/* 5421 */    MCD::OPC_Decode, 173, 4, 66, // Opcode: MOVDTOX
/* 5425 */    MCD::OPC_FilterValue, 145, 2, 16, 0, 0, // Skip to: 5447
/* 5431 */    MCD::OPC_CheckPredicate, 2, 99, 8, 0, // Skip to: 7583
/* 5436 */    MCD::OPC_CheckField, 14, 5, 0, 92, 8, 0, // Skip to: 7583
/* 5443 */    MCD::OPC_Decode, 181, 4, 66, // Opcode: MOVSTOUW
/* 5447 */    MCD::OPC_FilterValue, 147, 2, 16, 0, 0, // Skip to: 5469
/* 5453 */    MCD::OPC_CheckPredicate, 2, 77, 8, 0, // Skip to: 7583
/* 5458 */    MCD::OPC_CheckField, 14, 5, 0, 70, 8, 0, // Skip to: 7583
/* 5465 */    MCD::OPC_Decode, 180, 4, 66, // Opcode: MOVSTOSW
/* 5469 */    MCD::OPC_FilterValue, 149, 2, 9, 0, 0, // Skip to: 5484
/* 5475 */    MCD::OPC_CheckPredicate, 2, 55, 8, 0, // Skip to: 7583
/* 5480 */    MCD::OPC_Decode, 237, 5, 10, // Opcode: XMULX
/* 5484 */    MCD::OPC_FilterValue, 151, 2, 9, 0, 0, // Skip to: 5499
/* 5490 */    MCD::OPC_CheckPredicate, 2, 40, 8, 0, // Skip to: 7583
/* 5495 */    MCD::OPC_Decode, 238, 5, 10, // Opcode: XMULXHI
/* 5499 */    MCD::OPC_FilterValue, 152, 2, 16, 0, 0, // Skip to: 5521
/* 5505 */    MCD::OPC_CheckPredicate, 2, 25, 8, 0, // Skip to: 7583
/* 5510 */    MCD::OPC_CheckField, 14, 5, 0, 18, 8, 0, // Skip to: 7583
/* 5517 */    MCD::OPC_Decode, 185, 4, 67, // Opcode: MOVXTOD
/* 5521 */    MCD::OPC_FilterValue, 153, 2, 16, 0, 0, // Skip to: 5543
/* 5527 */    MCD::OPC_CheckPredicate, 2, 3, 8, 0, // Skip to: 7583
/* 5532 */    MCD::OPC_CheckField, 14, 5, 0, 252, 7, 0, // Skip to: 7583
/* 5539 */    MCD::OPC_Decode, 182, 4, 67, // Opcode: MOVWTOS
/* 5543 */    MCD::OPC_FilterValue, 209, 2, 9, 0, 0, // Skip to: 5558
/* 5549 */    MCD::OPC_CheckPredicate, 2, 237, 7, 0, // Skip to: 7583
/* 5554 */    MCD::OPC_Decode, 143, 3, 57, // Opcode: FLCMPS
/* 5558 */    MCD::OPC_FilterValue, 210, 2, 227, 7, 0, // Skip to: 7583
/* 5564 */    MCD::OPC_CheckPredicate, 2, 222, 7, 0, // Skip to: 7583
/* 5569 */    MCD::OPC_Decode, 142, 3, 57, // Opcode: FLCMPD
/* 5573 */    MCD::OPC_FilterValue, 56, 28, 0, 0, // Skip to: 5606
/* 5578 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5581 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 5597
/* 5586 */    MCD::OPC_CheckField, 5, 8, 0, 198, 7, 0, // Skip to: 7583
/* 5593 */    MCD::OPC_Decode, 252, 3, 68, // Opcode: JMPLrr
/* 5597 */    MCD::OPC_FilterValue, 1, 189, 7, 0, // Skip to: 7583
/* 5602 */    MCD::OPC_Decode, 251, 3, 69, // Opcode: JMPLri
/* 5606 */    MCD::OPC_FilterValue, 57, 42, 0, 0, // Skip to: 5653
/* 5611 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5614 */    MCD::OPC_FilterValue, 0, 18, 0, 0, // Skip to: 5637
/* 5619 */    MCD::OPC_CheckField, 25, 5, 0, 165, 7, 0, // Skip to: 7583
/* 5626 */    MCD::OPC_CheckField, 5, 8, 0, 158, 7, 0, // Skip to: 7583
/* 5633 */    MCD::OPC_Decode, 222, 4, 70, // Opcode: RETTrr
/* 5637 */    MCD::OPC_FilterValue, 1, 149, 7, 0, // Skip to: 7583
/* 5642 */    MCD::OPC_CheckField, 25, 5, 0, 142, 7, 0, // Skip to: 7583
/* 5649 */    MCD::OPC_Decode, 221, 4, 71, // Opcode: RETTri
/* 5653 */    MCD::OPC_FilterValue, 58, 119, 0, 0, // Skip to: 5777
/* 5658 */    MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 5661 */    MCD::OPC_FilterValue, 16, 18, 0, 0, // Skip to: 5684
/* 5666 */    MCD::OPC_CheckField, 29, 1, 0, 118, 7, 0, // Skip to: 7583
/* 5673 */    MCD::OPC_CheckField, 5, 3, 0, 111, 7, 0, // Skip to: 7583
/* 5680 */    MCD::OPC_Decode, 201, 5, 72, // Opcode: TXCCrr
/* 5684 */    MCD::OPC_FilterValue, 32, 72, 0, 0, // Skip to: 5761
/* 5689 */    MCD::OPC_ExtractField, 0, 8,  // Inst{7-0} ...
/* 5692 */    MCD::OPC_FilterValue, 1, 18, 0, 0, // Skip to: 5715
/* 5697 */    MCD::OPC_CheckField, 25, 5, 8, 87, 7, 0, // Skip to: 7583
/* 5704 */    MCD::OPC_CheckField, 14, 5, 0, 80, 7, 0, // Skip to: 7583
/* 5711 */    MCD::OPC_Decode, 178, 5, 4, // Opcode: TA1
/* 5715 */    MCD::OPC_FilterValue, 3, 18, 0, 0, // Skip to: 5738
/* 5720 */    MCD::OPC_CheckField, 25, 5, 8, 64, 7, 0, // Skip to: 7583
/* 5727 */    MCD::OPC_CheckField, 14, 5, 0, 57, 7, 0, // Skip to: 7583
/* 5734 */    MCD::OPC_Decode, 179, 5, 4, // Opcode: TA3
/* 5738 */    MCD::OPC_FilterValue, 5, 48, 7, 0, // Skip to: 7583
/* 5743 */    MCD::OPC_CheckField, 25, 5, 8, 41, 7, 0, // Skip to: 7583
/* 5750 */    MCD::OPC_CheckField, 14, 5, 0, 34, 7, 0, // Skip to: 7583
/* 5757 */    MCD::OPC_Decode, 180, 5, 4, // Opcode: TA5
/* 5761 */    MCD::OPC_FilterValue, 48, 25, 7, 0, // Skip to: 7583
/* 5766 */    MCD::OPC_CheckField, 29, 1, 0, 18, 7, 0, // Skip to: 7583
/* 5773 */    MCD::OPC_Decode, 200, 5, 73, // Opcode: TXCCri
/* 5777 */    MCD::OPC_FilterValue, 59, 62, 0, 0, // Skip to: 5844
/* 5782 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5785 */    MCD::OPC_FilterValue, 0, 38, 0, 0, // Skip to: 5828
/* 5790 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 5793 */    MCD::OPC_FilterValue, 0, 249, 6, 0, // Skip to: 7583
/* 5798 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5801 */    MCD::OPC_FilterValue, 0, 241, 6, 0, // Skip to: 7583
/* 5806 */    MCD::OPC_CheckField, 14, 5, 0, 11, 0, 0, // Skip to: 5824
/* 5813 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, 0, // Skip to: 5824
/* 5820 */    MCD::OPC_Decode, 144, 3, 4, // Opcode: FLUSH
/* 5824 */    MCD::OPC_Decode, 147, 3, 70, // Opcode: FLUSHrr
/* 5828 */    MCD::OPC_FilterValue, 1, 214, 6, 0, // Skip to: 7583
/* 5833 */    MCD::OPC_CheckField, 25, 5, 0, 207, 6, 0, // Skip to: 7583
/* 5840 */    MCD::OPC_Decode, 146, 3, 71, // Opcode: FLUSHri
/* 5844 */    MCD::OPC_FilterValue, 60, 28, 0, 0, // Skip to: 5877
/* 5849 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5852 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 5868
/* 5857 */    MCD::OPC_CheckField, 5, 8, 0, 183, 6, 0, // Skip to: 7583
/* 5864 */    MCD::OPC_Decode, 225, 4, 8, // Opcode: SAVErr
/* 5868 */    MCD::OPC_FilterValue, 1, 174, 6, 0, // Skip to: 7583
/* 5873 */    MCD::OPC_Decode, 224, 4, 9, // Opcode: SAVEri
/* 5877 */    MCD::OPC_FilterValue, 61, 28, 0, 0, // Skip to: 5910
/* 5882 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5885 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 5901
/* 5890 */    MCD::OPC_CheckField, 5, 8, 0, 150, 6, 0, // Skip to: 7583
/* 5897 */    MCD::OPC_Decode, 217, 4, 8, // Opcode: RESTORErr
/* 5901 */    MCD::OPC_FilterValue, 1, 141, 6, 0, // Skip to: 7583
/* 5906 */    MCD::OPC_Decode, 216, 4, 9, // Opcode: RESTOREri
/* 5910 */    MCD::OPC_FilterValue, 62, 88, 0, 0, // Skip to: 6003
/* 5915 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 5918 */    MCD::OPC_FilterValue, 0, 71, 0, 0, // Skip to: 5994
/* 5923 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 5926 */    MCD::OPC_FilterValue, 0, 116, 6, 0, // Skip to: 7583
/* 5931 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 5934 */    MCD::OPC_FilterValue, 0, 23, 0, 0, // Skip to: 5962
/* 5939 */    MCD::OPC_CheckPredicate, 0, 46, 0, 0, // Skip to: 5990
/* 5944 */    MCD::OPC_CheckField, 14, 5, 0, 39, 0, 0, // Skip to: 5990
/* 5951 */    MCD::OPC_CheckField, 0, 5, 0, 32, 0, 0, // Skip to: 5990
/* 5958 */    MCD::OPC_Decode, 209, 2, 4, // Opcode: DONE
/* 5962 */    MCD::OPC_FilterValue, 1, 23, 0, 0, // Skip to: 5990
/* 5967 */    MCD::OPC_CheckPredicate, 0, 18, 0, 0, // Skip to: 5990
/* 5972 */    MCD::OPC_CheckField, 14, 5, 0, 11, 0, 0, // Skip to: 5990
/* 5979 */    MCD::OPC_CheckField, 0, 5, 0, 4, 0, 0, // Skip to: 5990
/* 5986 */    MCD::OPC_Decode, 220, 4, 4, // Opcode: RETRY
/* 5990 */    MCD::OPC_Decode, 209, 5, 8, // Opcode: UMACrr
/* 5994 */    MCD::OPC_FilterValue, 1, 48, 6, 0, // Skip to: 7583
/* 5999 */    MCD::OPC_Decode, 208, 5, 9, // Opcode: UMACri
/* 6003 */    MCD::OPC_FilterValue, 63, 39, 6, 0, // Skip to: 7583
/* 6008 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6011 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6027
/* 6016 */    MCD::OPC_CheckField, 5, 8, 0, 24, 6, 0, // Skip to: 7583
/* 6023 */    MCD::OPC_Decode, 242, 4, 8, // Opcode: SMACrr
/* 6027 */    MCD::OPC_FilterValue, 1, 15, 6, 0, // Skip to: 7583
/* 6032 */    MCD::OPC_Decode, 241, 4, 9, // Opcode: SMACri
/* 6036 */    MCD::OPC_FilterValue, 3, 6, 6, 0, // Skip to: 7583
/* 6041 */    MCD::OPC_ExtractField, 19, 6,  // Inst{24-19} ...
/* 6044 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 6077
/* 6049 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6052 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6068
/* 6057 */    MCD::OPC_CheckField, 5, 8, 0, 239, 5, 0, // Skip to: 7583
/* 6064 */    MCD::OPC_Decode, 168, 4, 68, // Opcode: LDrr
/* 6068 */    MCD::OPC_FilterValue, 1, 230, 5, 0, // Skip to: 7583
/* 6073 */    MCD::OPC_Decode, 167, 4, 69, // Opcode: LDri
/* 6077 */    MCD::OPC_FilterValue, 1, 28, 0, 0, // Skip to: 6110
/* 6082 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6085 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6101
/* 6090 */    MCD::OPC_CheckField, 5, 8, 0, 206, 5, 0, // Skip to: 7583
/* 6097 */    MCD::OPC_Decode, 159, 4, 68, // Opcode: LDUBrr
/* 6101 */    MCD::OPC_FilterValue, 1, 197, 5, 0, // Skip to: 7583
/* 6106 */    MCD::OPC_Decode, 158, 4, 69, // Opcode: LDUBri
/* 6110 */    MCD::OPC_FilterValue, 2, 28, 0, 0, // Skip to: 6143
/* 6115 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6118 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6134
/* 6123 */    MCD::OPC_CheckField, 5, 8, 0, 173, 5, 0, // Skip to: 7583
/* 6130 */    MCD::OPC_Decode, 162, 4, 68, // Opcode: LDUHrr
/* 6134 */    MCD::OPC_FilterValue, 1, 164, 5, 0, // Skip to: 7583
/* 6139 */    MCD::OPC_Decode, 161, 4, 69, // Opcode: LDUHri
/* 6143 */    MCD::OPC_FilterValue, 3, 28, 0, 0, // Skip to: 6176
/* 6148 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6151 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6167
/* 6156 */    MCD::OPC_CheckField, 5, 8, 0, 140, 5, 0, // Skip to: 7583
/* 6163 */    MCD::OPC_Decode, 137, 4, 74, // Opcode: LDDrr
/* 6167 */    MCD::OPC_FilterValue, 1, 131, 5, 0, // Skip to: 7583
/* 6172 */    MCD::OPC_Decode, 136, 4, 75, // Opcode: LDDri
/* 6176 */    MCD::OPC_FilterValue, 4, 28, 0, 0, // Skip to: 6209
/* 6181 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6184 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6200
/* 6189 */    MCD::OPC_CheckField, 5, 8, 0, 107, 5, 0, // Skip to: 7583
/* 6196 */    MCD::OPC_Decode, 164, 5, 76, // Opcode: STrr
/* 6200 */    MCD::OPC_FilterValue, 1, 98, 5, 0, // Skip to: 7583
/* 6205 */    MCD::OPC_Decode, 163, 5, 77, // Opcode: STri
/* 6209 */    MCD::OPC_FilterValue, 5, 28, 0, 0, // Skip to: 6242
/* 6214 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6217 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6233
/* 6222 */    MCD::OPC_CheckField, 5, 8, 0, 74, 5, 0, // Skip to: 7583
/* 6229 */    MCD::OPC_Decode, 131, 5, 76, // Opcode: STBrr
/* 6233 */    MCD::OPC_FilterValue, 1, 65, 5, 0, // Skip to: 7583
/* 6238 */    MCD::OPC_Decode, 130, 5, 77, // Opcode: STBri
/* 6242 */    MCD::OPC_FilterValue, 6, 28, 0, 0, // Skip to: 6275
/* 6247 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6250 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6266
/* 6255 */    MCD::OPC_CheckField, 5, 8, 0, 41, 5, 0, // Skip to: 7583
/* 6262 */    MCD::OPC_Decode, 155, 5, 76, // Opcode: STHrr
/* 6266 */    MCD::OPC_FilterValue, 1, 32, 5, 0, // Skip to: 7583
/* 6271 */    MCD::OPC_Decode, 154, 5, 77, // Opcode: STHri
/* 6275 */    MCD::OPC_FilterValue, 7, 28, 0, 0, // Skip to: 6308
/* 6280 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6283 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6299
/* 6288 */    MCD::OPC_CheckField, 5, 8, 0, 8, 5, 0, // Skip to: 7583
/* 6295 */    MCD::OPC_Decode, 147, 5, 78, // Opcode: STDrr
/* 6299 */    MCD::OPC_FilterValue, 1, 255, 4, 0, // Skip to: 7583
/* 6304 */    MCD::OPC_Decode, 146, 5, 79, // Opcode: STDri
/* 6308 */    MCD::OPC_FilterValue, 8, 28, 0, 0, // Skip to: 6341
/* 6313 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6316 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6332
/* 6321 */    MCD::OPC_CheckField, 5, 8, 0, 231, 4, 0, // Skip to: 7583
/* 6328 */    MCD::OPC_Decode, 156, 4, 80, // Opcode: LDSWrr
/* 6332 */    MCD::OPC_FilterValue, 1, 222, 4, 0, // Skip to: 7583
/* 6337 */    MCD::OPC_Decode, 155, 4, 81, // Opcode: LDSWri
/* 6341 */    MCD::OPC_FilterValue, 9, 28, 0, 0, // Skip to: 6374
/* 6346 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6349 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6365
/* 6354 */    MCD::OPC_CheckField, 5, 8, 0, 198, 4, 0, // Skip to: 7583
/* 6361 */    MCD::OPC_Decode, 148, 4, 68, // Opcode: LDSBrr
/* 6365 */    MCD::OPC_FilterValue, 1, 189, 4, 0, // Skip to: 7583
/* 6370 */    MCD::OPC_Decode, 147, 4, 69, // Opcode: LDSBri
/* 6374 */    MCD::OPC_FilterValue, 10, 28, 0, 0, // Skip to: 6407
/* 6379 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6382 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6398
/* 6387 */    MCD::OPC_CheckField, 5, 8, 0, 165, 4, 0, // Skip to: 7583
/* 6394 */    MCD::OPC_Decode, 151, 4, 68, // Opcode: LDSHrr
/* 6398 */    MCD::OPC_FilterValue, 1, 156, 4, 0, // Skip to: 7583
/* 6403 */    MCD::OPC_Decode, 150, 4, 69, // Opcode: LDSHri
/* 6407 */    MCD::OPC_FilterValue, 11, 28, 0, 0, // Skip to: 6440
/* 6412 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6415 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6431
/* 6420 */    MCD::OPC_CheckField, 5, 8, 0, 132, 4, 0, // Skip to: 7583
/* 6427 */    MCD::OPC_Decode, 166, 4, 80, // Opcode: LDXrr
/* 6431 */    MCD::OPC_FilterValue, 1, 123, 4, 0, // Skip to: 7583
/* 6436 */    MCD::OPC_Decode, 165, 4, 81, // Opcode: LDXri
/* 6440 */    MCD::OPC_FilterValue, 13, 28, 0, 0, // Skip to: 6473
/* 6445 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6448 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6464
/* 6453 */    MCD::OPC_CheckField, 5, 8, 0, 99, 4, 0, // Skip to: 7583
/* 6460 */    MCD::OPC_Decode, 154, 4, 68, // Opcode: LDSTUBrr
/* 6464 */    MCD::OPC_FilterValue, 1, 90, 4, 0, // Skip to: 7583
/* 6469 */    MCD::OPC_Decode, 153, 4, 69, // Opcode: LDSTUBri
/* 6473 */    MCD::OPC_FilterValue, 14, 28, 0, 0, // Skip to: 6506
/* 6478 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6481 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6497
/* 6486 */    MCD::OPC_CheckField, 5, 8, 0, 66, 4, 0, // Skip to: 7583
/* 6493 */    MCD::OPC_Decode, 162, 5, 82, // Opcode: STXrr
/* 6497 */    MCD::OPC_FilterValue, 1, 57, 4, 0, // Skip to: 7583
/* 6502 */    MCD::OPC_Decode, 161, 5, 83, // Opcode: STXri
/* 6506 */    MCD::OPC_FilterValue, 15, 28, 0, 0, // Skip to: 6539
/* 6511 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6514 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6530
/* 6519 */    MCD::OPC_CheckField, 5, 8, 0, 33, 4, 0, // Skip to: 7583
/* 6526 */    MCD::OPC_Decode, 177, 5, 84, // Opcode: SWAPrr
/* 6530 */    MCD::OPC_FilterValue, 1, 24, 4, 0, // Skip to: 7583
/* 6535 */    MCD::OPC_Decode, 176, 5, 85, // Opcode: SWAPri
/* 6539 */    MCD::OPC_FilterValue, 16, 11, 0, 0, // Skip to: 6555
/* 6544 */    MCD::OPC_CheckField, 13, 1, 0, 8, 4, 0, // Skip to: 7583
/* 6551 */    MCD::OPC_Decode, 253, 3, 86, // Opcode: LDArr
/* 6555 */    MCD::OPC_FilterValue, 17, 11, 0, 0, // Skip to: 6571
/* 6560 */    MCD::OPC_CheckField, 13, 1, 0, 248, 3, 0, // Skip to: 7583
/* 6567 */    MCD::OPC_Decode, 157, 4, 86, // Opcode: LDUBArr
/* 6571 */    MCD::OPC_FilterValue, 18, 11, 0, 0, // Skip to: 6587
/* 6576 */    MCD::OPC_CheckField, 13, 1, 0, 232, 3, 0, // Skip to: 7583
/* 6583 */    MCD::OPC_Decode, 160, 4, 86, // Opcode: LDUHArr
/* 6587 */    MCD::OPC_FilterValue, 19, 11, 0, 0, // Skip to: 6603
/* 6592 */    MCD::OPC_CheckField, 13, 1, 0, 216, 3, 0, // Skip to: 7583
/* 6599 */    MCD::OPC_Decode, 130, 4, 87, // Opcode: LDDArr
/* 6603 */    MCD::OPC_FilterValue, 20, 11, 0, 0, // Skip to: 6619
/* 6608 */    MCD::OPC_CheckField, 13, 1, 0, 200, 3, 0, // Skip to: 7583
/* 6615 */    MCD::OPC_Decode, 255, 4, 88, // Opcode: STArr
/* 6619 */    MCD::OPC_FilterValue, 21, 11, 0, 0, // Skip to: 6635
/* 6624 */    MCD::OPC_CheckField, 13, 1, 0, 184, 3, 0, // Skip to: 7583
/* 6631 */    MCD::OPC_Decode, 129, 5, 88, // Opcode: STBArr
/* 6635 */    MCD::OPC_FilterValue, 22, 11, 0, 0, // Skip to: 6651
/* 6640 */    MCD::OPC_CheckField, 13, 1, 0, 168, 3, 0, // Skip to: 7583
/* 6647 */    MCD::OPC_Decode, 153, 5, 88, // Opcode: STHArr
/* 6651 */    MCD::OPC_FilterValue, 23, 11, 0, 0, // Skip to: 6667
/* 6656 */    MCD::OPC_CheckField, 13, 1, 0, 152, 3, 0, // Skip to: 7583
/* 6663 */    MCD::OPC_Decode, 136, 5, 89, // Opcode: STDArr
/* 6667 */    MCD::OPC_FilterValue, 25, 11, 0, 0, // Skip to: 6683
/* 6672 */    MCD::OPC_CheckField, 13, 1, 0, 136, 3, 0, // Skip to: 7583
/* 6679 */    MCD::OPC_Decode, 146, 4, 86, // Opcode: LDSBArr
/* 6683 */    MCD::OPC_FilterValue, 26, 11, 0, 0, // Skip to: 6699
/* 6688 */    MCD::OPC_CheckField, 13, 1, 0, 120, 3, 0, // Skip to: 7583
/* 6695 */    MCD::OPC_Decode, 149, 4, 86, // Opcode: LDSHArr
/* 6699 */    MCD::OPC_FilterValue, 29, 11, 0, 0, // Skip to: 6715
/* 6704 */    MCD::OPC_CheckField, 13, 1, 0, 104, 3, 0, // Skip to: 7583
/* 6711 */    MCD::OPC_Decode, 152, 4, 86, // Opcode: LDSTUBArr
/* 6715 */    MCD::OPC_FilterValue, 31, 11, 0, 0, // Skip to: 6731
/* 6720 */    MCD::OPC_CheckField, 13, 1, 0, 88, 3, 0, // Skip to: 7583
/* 6727 */    MCD::OPC_Decode, 175, 5, 90, // Opcode: SWAPArr
/* 6731 */    MCD::OPC_FilterValue, 32, 28, 0, 0, // Skip to: 6764
/* 6736 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6739 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6755
/* 6744 */    MCD::OPC_CheckField, 5, 8, 0, 64, 3, 0, // Skip to: 7583
/* 6751 */    MCD::OPC_Decode, 142, 4, 91, // Opcode: LDFrr
/* 6755 */    MCD::OPC_FilterValue, 1, 55, 3, 0, // Skip to: 7583
/* 6760 */    MCD::OPC_Decode, 141, 4, 92, // Opcode: LDFri
/* 6764 */    MCD::OPC_FilterValue, 33, 79, 0, 0, // Skip to: 6848
/* 6769 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6772 */    MCD::OPC_FilterValue, 0, 40, 0, 0, // Skip to: 6817
/* 6777 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 6780 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6796
/* 6785 */    MCD::OPC_CheckField, 5, 8, 0, 23, 3, 0, // Skip to: 7583
/* 6792 */    MCD::OPC_Decode, 140, 4, 70, // Opcode: LDFSRrr
/* 6796 */    MCD::OPC_FilterValue, 1, 14, 3, 0, // Skip to: 7583
/* 6801 */    MCD::OPC_CheckPredicate, 0, 9, 3, 0, // Skip to: 7583
/* 6806 */    MCD::OPC_CheckField, 5, 8, 0, 2, 3, 0, // Skip to: 7583
/* 6813 */    MCD::OPC_Decode, 164, 4, 70, // Opcode: LDXFSRrr
/* 6817 */    MCD::OPC_FilterValue, 1, 249, 2, 0, // Skip to: 7583
/* 6822 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 6825 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 6834
/* 6830 */    MCD::OPC_Decode, 139, 4, 71, // Opcode: LDFSRri
/* 6834 */    MCD::OPC_FilterValue, 1, 232, 2, 0, // Skip to: 7583
/* 6839 */    MCD::OPC_CheckPredicate, 0, 227, 2, 0, // Skip to: 7583
/* 6844 */    MCD::OPC_Decode, 163, 4, 71, // Opcode: LDXFSRri
/* 6848 */    MCD::OPC_FilterValue, 34, 38, 0, 0, // Skip to: 6891
/* 6853 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6856 */    MCD::OPC_FilterValue, 0, 16, 0, 0, // Skip to: 6877
/* 6861 */    MCD::OPC_CheckPredicate, 0, 205, 2, 0, // Skip to: 7583
/* 6866 */    MCD::OPC_CheckField, 5, 8, 0, 198, 2, 0, // Skip to: 7583
/* 6873 */    MCD::OPC_Decode, 145, 4, 93, // Opcode: LDQFrr
/* 6877 */    MCD::OPC_FilterValue, 1, 189, 2, 0, // Skip to: 7583
/* 6882 */    MCD::OPC_CheckPredicate, 0, 184, 2, 0, // Skip to: 7583
/* 6887 */    MCD::OPC_Decode, 144, 4, 94, // Opcode: LDQFri
/* 6891 */    MCD::OPC_FilterValue, 35, 28, 0, 0, // Skip to: 6924
/* 6896 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6899 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6915
/* 6904 */    MCD::OPC_CheckField, 5, 8, 0, 160, 2, 0, // Skip to: 7583
/* 6911 */    MCD::OPC_Decode, 135, 4, 95, // Opcode: LDDFrr
/* 6915 */    MCD::OPC_FilterValue, 1, 151, 2, 0, // Skip to: 7583
/* 6920 */    MCD::OPC_Decode, 134, 4, 96, // Opcode: LDDFri
/* 6924 */    MCD::OPC_FilterValue, 36, 28, 0, 0, // Skip to: 6957
/* 6929 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6932 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6948
/* 6937 */    MCD::OPC_CheckField, 5, 8, 0, 127, 2, 0, // Skip to: 7583
/* 6944 */    MCD::OPC_Decode, 152, 5, 97, // Opcode: STFrr
/* 6948 */    MCD::OPC_FilterValue, 1, 118, 2, 0, // Skip to: 7583
/* 6953 */    MCD::OPC_Decode, 151, 5, 98, // Opcode: STFri
/* 6957 */    MCD::OPC_FilterValue, 37, 79, 0, 0, // Skip to: 7041
/* 6962 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 6965 */    MCD::OPC_FilterValue, 0, 40, 0, 0, // Skip to: 7010
/* 6970 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 6973 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 6989
/* 6978 */    MCD::OPC_CheckField, 5, 8, 0, 86, 2, 0, // Skip to: 7583
/* 6985 */    MCD::OPC_Decode, 150, 5, 70, // Opcode: STFSRrr
/* 6989 */    MCD::OPC_FilterValue, 1, 77, 2, 0, // Skip to: 7583
/* 6994 */    MCD::OPC_CheckPredicate, 0, 72, 2, 0, // Skip to: 7583
/* 6999 */    MCD::OPC_CheckField, 5, 8, 0, 65, 2, 0, // Skip to: 7583
/* 7006 */    MCD::OPC_Decode, 160, 5, 70, // Opcode: STXFSRrr
/* 7010 */    MCD::OPC_FilterValue, 1, 56, 2, 0, // Skip to: 7583
/* 7015 */    MCD::OPC_ExtractField, 25, 5,  // Inst{29-25} ...
/* 7018 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 7027
/* 7023 */    MCD::OPC_Decode, 149, 5, 71, // Opcode: STFSRri
/* 7027 */    MCD::OPC_FilterValue, 1, 39, 2, 0, // Skip to: 7583
/* 7032 */    MCD::OPC_CheckPredicate, 0, 34, 2, 0, // Skip to: 7583
/* 7037 */    MCD::OPC_Decode, 159, 5, 71, // Opcode: STXFSRri
/* 7041 */    MCD::OPC_FilterValue, 38, 61, 0, 0, // Skip to: 7107
/* 7046 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7049 */    MCD::OPC_FilterValue, 0, 28, 0, 0, // Skip to: 7082
/* 7054 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 7057 */    MCD::OPC_FilterValue, 0, 9, 2, 0, // Skip to: 7583
/* 7062 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 7073
/* 7069 */    MCD::OPC_Decode, 143, 5, 70, // Opcode: STDFQrr
/* 7073 */    MCD::OPC_CheckPredicate, 0, 249, 1, 0, // Skip to: 7583
/* 7078 */    MCD::OPC_Decode, 158, 5, 99, // Opcode: STQFrr
/* 7082 */    MCD::OPC_FilterValue, 1, 240, 1, 0, // Skip to: 7583
/* 7087 */    MCD::OPC_CheckField, 25, 5, 0, 4, 0, 0, // Skip to: 7098
/* 7094 */    MCD::OPC_Decode, 142, 5, 71, // Opcode: STDFQri
/* 7098 */    MCD::OPC_CheckPredicate, 0, 224, 1, 0, // Skip to: 7583
/* 7103 */    MCD::OPC_Decode, 157, 5, 100, // Opcode: STQFri
/* 7107 */    MCD::OPC_FilterValue, 39, 28, 0, 0, // Skip to: 7140
/* 7112 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7115 */    MCD::OPC_FilterValue, 0, 11, 0, 0, // Skip to: 7131
/* 7120 */    MCD::OPC_CheckField, 5, 8, 0, 200, 1, 0, // Skip to: 7583
/* 7127 */    MCD::OPC_Decode, 145, 5, 101, // Opcode: STDFrr
/* 7131 */    MCD::OPC_FilterValue, 1, 191, 1, 0, // Skip to: 7583
/* 7136 */    MCD::OPC_Decode, 144, 5, 102, // Opcode: STDFri
/* 7140 */    MCD::OPC_FilterValue, 45, 38, 0, 0, // Skip to: 7183
/* 7145 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7148 */    MCD::OPC_FilterValue, 0, 16, 0, 0, // Skip to: 7169
/* 7153 */    MCD::OPC_CheckPredicate, 0, 169, 1, 0, // Skip to: 7583
/* 7158 */    MCD::OPC_CheckField, 5, 8, 0, 162, 1, 0, // Skip to: 7583
/* 7165 */    MCD::OPC_Decode, 206, 4, 103, // Opcode: PREFETCHr
/* 7169 */    MCD::OPC_FilterValue, 1, 153, 1, 0, // Skip to: 7583
/* 7174 */    MCD::OPC_CheckPredicate, 0, 148, 1, 0, // Skip to: 7583
/* 7179 */    MCD::OPC_Decode, 205, 4, 104, // Opcode: PREFETCHi
/* 7183 */    MCD::OPC_FilterValue, 48, 37, 0, 0, // Skip to: 7225
/* 7188 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7191 */    MCD::OPC_FilterValue, 0, 20, 0, 0, // Skip to: 7216
/* 7196 */    MCD::OPC_CheckField, 5, 8, 0, 4, 0, 0, // Skip to: 7207
/* 7203 */    MCD::OPC_Decode, 129, 4, 105, // Opcode: LDCrr
/* 7207 */    MCD::OPC_CheckPredicate, 0, 115, 1, 0, // Skip to: 7583
/* 7212 */    MCD::OPC_Decode, 138, 4, 106, // Opcode: LDFArr
/* 7216 */    MCD::OPC_FilterValue, 1, 106, 1, 0, // Skip to: 7583
/* 7221 */    MCD::OPC_Decode, 128, 4, 107, // Opcode: LDCri
/* 7225 */    MCD::OPC_FilterValue, 49, 42, 0, 0, // Skip to: 7272
/* 7230 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7233 */    MCD::OPC_FilterValue, 0, 18, 0, 0, // Skip to: 7256
/* 7238 */    MCD::OPC_CheckField, 25, 5, 0, 82, 1, 0, // Skip to: 7583
/* 7245 */    MCD::OPC_CheckField, 5, 8, 0, 75, 1, 0, // Skip to: 7583
/* 7252 */    MCD::OPC_Decode, 255, 3, 70, // Opcode: LDCSRrr
/* 7256 */    MCD::OPC_FilterValue, 1, 66, 1, 0, // Skip to: 7583
/* 7261 */    MCD::OPC_CheckField, 25, 5, 0, 59, 1, 0, // Skip to: 7583
/* 7268 */    MCD::OPC_Decode, 254, 3, 71, // Opcode: LDCSRri
/* 7272 */    MCD::OPC_FilterValue, 50, 16, 0, 0, // Skip to: 7293
/* 7277 */    MCD::OPC_CheckPredicate, 0, 45, 1, 0, // Skip to: 7583
/* 7282 */    MCD::OPC_CheckField, 13, 1, 0, 38, 1, 0, // Skip to: 7583
/* 7289 */    MCD::OPC_Decode, 143, 4, 108, // Opcode: LDQFArr
/* 7293 */    MCD::OPC_FilterValue, 51, 37, 0, 0, // Skip to: 7335
/* 7298 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7301 */    MCD::OPC_FilterValue, 0, 20, 0, 0, // Skip to: 7326
/* 7306 */    MCD::OPC_CheckField, 5, 8, 0, 4, 0, 0, // Skip to: 7317
/* 7313 */    MCD::OPC_Decode, 132, 4, 109, // Opcode: LDDCrr
/* 7317 */    MCD::OPC_CheckPredicate, 0, 5, 1, 0, // Skip to: 7583
/* 7322 */    MCD::OPC_Decode, 133, 4, 110, // Opcode: LDDFArr
/* 7326 */    MCD::OPC_FilterValue, 1, 252, 0, 0, // Skip to: 7583
/* 7331 */    MCD::OPC_Decode, 131, 4, 111, // Opcode: LDDCri
/* 7335 */    MCD::OPC_FilterValue, 52, 37, 0, 0, // Skip to: 7377
/* 7340 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7343 */    MCD::OPC_FilterValue, 0, 20, 0, 0, // Skip to: 7368
/* 7348 */    MCD::OPC_CheckField, 5, 8, 0, 4, 0, 0, // Skip to: 7359
/* 7355 */    MCD::OPC_Decode, 135, 5, 112, // Opcode: STCrr
/* 7359 */    MCD::OPC_CheckPredicate, 0, 219, 0, 0, // Skip to: 7583
/* 7364 */    MCD::OPC_Decode, 148, 5, 113, // Opcode: STFArr
/* 7368 */    MCD::OPC_FilterValue, 1, 210, 0, 0, // Skip to: 7583
/* 7373 */    MCD::OPC_Decode, 134, 5, 114, // Opcode: STCri
/* 7377 */    MCD::OPC_FilterValue, 53, 42, 0, 0, // Skip to: 7424
/* 7382 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7385 */    MCD::OPC_FilterValue, 0, 18, 0, 0, // Skip to: 7408
/* 7390 */    MCD::OPC_CheckField, 25, 5, 0, 186, 0, 0, // Skip to: 7583
/* 7397 */    MCD::OPC_CheckField, 5, 8, 0, 179, 0, 0, // Skip to: 7583
/* 7404 */    MCD::OPC_Decode, 133, 5, 70, // Opcode: STCSRrr
/* 7408 */    MCD::OPC_FilterValue, 1, 170, 0, 0, // Skip to: 7583
/* 7413 */    MCD::OPC_CheckField, 25, 5, 0, 163, 0, 0, // Skip to: 7583
/* 7420 */    MCD::OPC_Decode, 132, 5, 71, // Opcode: STCSRri
/* 7424 */    MCD::OPC_FilterValue, 54, 51, 0, 0, // Skip to: 7480
/* 7429 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7432 */    MCD::OPC_FilterValue, 0, 27, 0, 0, // Skip to: 7464
/* 7437 */    MCD::OPC_CheckField, 25, 5, 0, 11, 0, 0, // Skip to: 7455
/* 7444 */    MCD::OPC_CheckField, 5, 8, 0, 4, 0, 0, // Skip to: 7455
/* 7451 */    MCD::OPC_Decode, 138, 5, 70, // Opcode: STDCQrr
/* 7455 */    MCD::OPC_CheckPredicate, 0, 123, 0, 0, // Skip to: 7583
/* 7460 */    MCD::OPC_Decode, 156, 5, 115, // Opcode: STQFArr
/* 7464 */    MCD::OPC_FilterValue, 1, 114, 0, 0, // Skip to: 7583
/* 7469 */    MCD::OPC_CheckField, 25, 5, 0, 107, 0, 0, // Skip to: 7583
/* 7476 */    MCD::OPC_Decode, 137, 5, 71, // Opcode: STDCQri
/* 7480 */    MCD::OPC_FilterValue, 55, 37, 0, 0, // Skip to: 7522
/* 7485 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7488 */    MCD::OPC_FilterValue, 0, 20, 0, 0, // Skip to: 7513
/* 7493 */    MCD::OPC_CheckField, 5, 8, 0, 4, 0, 0, // Skip to: 7504
/* 7500 */    MCD::OPC_Decode, 140, 5, 116, // Opcode: STDCrr
/* 7504 */    MCD::OPC_CheckPredicate, 0, 74, 0, 0, // Skip to: 7583
/* 7509 */    MCD::OPC_Decode, 141, 5, 117, // Opcode: STDFArr
/* 7513 */    MCD::OPC_FilterValue, 1, 65, 0, 0, // Skip to: 7583
/* 7518 */    MCD::OPC_Decode, 139, 5, 118, // Opcode: STDCri
/* 7522 */    MCD::OPC_FilterValue, 60, 39, 0, 0, // Skip to: 7566
/* 7527 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 7530 */    MCD::OPC_FilterValue, 0, 48, 0, 0, // Skip to: 7583
/* 7535 */    MCD::OPC_ExtractField, 5, 8,  // Inst{12-5} ...
/* 7538 */    MCD::OPC_FilterValue, 10, 4, 0, 0, // Skip to: 7547
/* 7543 */    MCD::OPC_Decode, 198, 2, 119, // Opcode: CASAasi10
/* 7547 */    MCD::OPC_FilterValue, 128, 1, 9, 0, 0, // Skip to: 7562
/* 7553 */    MCD::OPC_CheckPredicate, 0, 4, 0, 0, // Skip to: 7562
/* 7558 */    MCD::OPC_Decode, 201, 2, 119, // Opcode: CASrr
/* 7562 */    MCD::OPC_Decode, 199, 2, 120, // Opcode: CASArr
/* 7566 */    MCD::OPC_FilterValue, 62, 12, 0, 0, // Skip to: 7583
/* 7571 */    MCD::OPC_CheckField, 5, 9, 128, 1, 4, 0, 0, // Skip to: 7583
/* 7579 */    MCD::OPC_Decode, 200, 2, 121, // Opcode: CASXrr
/* 7583 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableSparcV832[] = {
/* 0 */       MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 3 */       MCD::OPC_FilterValue, 0, 25, 0, 0, // Skip to: 33
/* 8 */       MCD::OPC_CheckField, 29, 3, 4, 41, 0, 0, // Skip to: 56
/* 15 */      MCD::OPC_CheckField, 19, 6, 58, 34, 0, 0, // Skip to: 56
/* 22 */      MCD::OPC_CheckField, 5, 3, 0, 27, 0, 0, // Skip to: 56
/* 29 */      MCD::OPC_Decode, 195, 5, 72, // Opcode: TRAPrr
/* 33 */      MCD::OPC_FilterValue, 32, 18, 0, 0, // Skip to: 56
/* 38 */      MCD::OPC_CheckField, 29, 3, 4, 11, 0, 0, // Skip to: 56
/* 45 */      MCD::OPC_CheckField, 19, 6, 58, 4, 0, 0, // Skip to: 56
/* 52 */      MCD::OPC_Decode, 194, 5, 73, // Opcode: TRAPri
/* 56 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableSparcV932[] = {
/* 0 */       MCD::OPC_ExtractField, 8, 6,  // Inst{13-8} ...
/* 3 */       MCD::OPC_FilterValue, 0, 30, 0, 0, // Skip to: 38
/* 8 */       MCD::OPC_CheckPredicate, 0, 53, 0, 0, // Skip to: 66
/* 13 */      MCD::OPC_CheckField, 29, 3, 4, 46, 0, 0, // Skip to: 66
/* 20 */      MCD::OPC_CheckField, 19, 6, 58, 39, 0, 0, // Skip to: 66
/* 27 */      MCD::OPC_CheckField, 5, 3, 0, 32, 0, 0, // Skip to: 66
/* 34 */      MCD::OPC_Decode, 188, 5, 72, // Opcode: TICCrr
/* 38 */      MCD::OPC_FilterValue, 32, 23, 0, 0, // Skip to: 66
/* 43 */      MCD::OPC_CheckPredicate, 0, 18, 0, 0, // Skip to: 66
/* 48 */      MCD::OPC_CheckField, 29, 3, 4, 11, 0, 0, // Skip to: 66
/* 55 */      MCD::OPC_CheckField, 19, 6, 58, 4, 0, 0, // Skip to: 66
/* 62 */      MCD::OPC_Decode, 187, 5, 73, // Opcode: TICCri
/* 66 */      MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[Sparc::FeatureV9]);
  case 1:
    return (Bits[Sparc::FeaturePWRPSR]);
  case 2:
    return (Bits[Sparc::FeatureVIS3]);
  case 3:
    return (Bits[Sparc::FeatureVIS]);
  case 4:
    return (Bits[Sparc::FeatureVIS2]);
  }
}

template <typename InsnType>
static DecodeStatus decodeToMCInst(DecodeStatus S, unsigned Idx, InsnType insn, MCInst &MI,
                                   uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 22);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 19);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 22);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 3:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 14), 0, 14);
    insertBits(tmp, fieldFromInstruction(insn, 20, 2), 14, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 22);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 0, 19);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 20, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 0, 30);
    if (!Check(S, DecodeCall(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 11);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 11);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeASRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodePRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    if (!Check(S, DecodeSIMM13(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 37:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 39:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 40:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 41:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 42:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 43:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 44:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 45:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 46:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 47:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 48:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 49:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 50:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 51:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 52:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 53:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 54:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 55:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 56:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 57:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 58:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFCCRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 59:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 60:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 61:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 62:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 63:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 64:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 65:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 66:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 67:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 68:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 69:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 70:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 71:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 72:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 73:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 74:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 75:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 76:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 77:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 78:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 79:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 80:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 81:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 82:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 83:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 84:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 85:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 86:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 87:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 88:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 89:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 90:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 91:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 92:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 93:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 94:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 95:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 96:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 97:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 98:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 99:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 100:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 101:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 102:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 103:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 104:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 105:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 106:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 107:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 108:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 109:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 110:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 111:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 112:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 113:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 114:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 115:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeQFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 116:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 117:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeDFPRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 118:
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodePointerLikeRegClass0(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 13);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeCoprocPairRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 119:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 120:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeIntRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 121:
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 25, 5);
    if (!Check(S, DecodeI64RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    switch (*Ptr) {
    default:
      errs() << Loc << ": Unexpected decode table opcode!\n";
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      unsigned Start = *++Ptr;
      unsigned Len = *++Ptr;
      ++Ptr;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue: {
      // Decode the field value.
      unsigned Len;
      uint64_t Val = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the filter operation.
      if (Val != CurFieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_FilterValue(" << Val << ", " << NumToSkip
                   << "): " << ((Val != CurFieldValue) ? "FAIL:" : "PASS:")
                   << " continuing at " << (Ptr - DecodeTable) << "\n");

      break;
    }
    case MCD::OPC_CheckField: {
      unsigned Start = *++Ptr;
      unsigned Len = *++Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // If the actual and expected values don't match, skip.
      if (ExpectedValue != FieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckField(" << Start << ", "
                   << Len << ", " << ExpectedValue << ", " << NumToSkip
                   << "): FieldValue = " << FieldValue << ", ExpectedValue = "
                   << ExpectedValue << ": "
                   << ((ExpectedValue == FieldValue) ? "PASS\n" : "FAIL\n"));
      break;
    }
    case MCD::OPC_CheckPredicate: {
      unsigned Len;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;
      // Check the predicate.
      bool Pred;
      if (!(Pred = checkDecoderPredicate(PIdx, Bits)))
        Ptr += NumToSkip;
      (void)Pred;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckPredicate(" << PIdx << "): "
            << (Pred ? "PASS\n" : "FAIL\n"));

      break;
    }
    case MCD::OPC_Decode: {
      unsigned Len;
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      unsigned DecodeIdx = decodeULEB128(Ptr, &Len);
      Ptr += Len;

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
      return S;
    }
    case MCD::OPC_TryDecode: {
      unsigned Len;
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      unsigned DecodeIdx = decodeULEB128(Ptr, &Len);
      Ptr += Len;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the decode operation.
      MCInst TmpMI;
      TmpMI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, TmpMI, Address, DisAsm, DecodeComplete);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_TryDecode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": ");

      if (DecodeComplete) {
        // Decoding complete.
        LLVM_DEBUG(dbgs() << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
        MI = TmpMI;
        return S;
      } else {
        assert(S == MCDisassembler::Fail);
        // If the decoding was incomplete, skip.
        Ptr += NumToSkip;
        LLVM_DEBUG(dbgs() << "FAIL: continuing at " << (Ptr - DecodeTable) << "\n");
        // Reset decode status. This also drops a SoftFail status that could be
        // set before the decode attempt.
        S = MCDisassembler::Success;
      }
      break;
    }
    case MCD::OPC_SoftFail: {
      // Decode the mask values.
      unsigned Len;
      uint64_t PositiveMask = decodeULEB128(++Ptr, &Len);
      Ptr += Len;
      uint64_t NegativeMask = decodeULEB128(Ptr, &Len);
      Ptr += Len;
      bool Fail = (insn & PositiveMask) != 0 || (~insn & NegativeMask) != 0;
      if (Fail)
        S = MCDisassembler::SoftFail;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_SoftFail: " << (Fail ? "FAIL\n" : "PASS\n"));
      break;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // end namespace llvm
