/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidImmUnsignedi4,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_Not64BitModeBit = 4,
  Feature_In64BitModeBit = 2,
  Feature_In16BitModeBit = 0,
  Feature_Not16BitModeBit = 3,
  Feature_In32BitModeBit = 1,
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 34 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 1;	 // "ah"
      case 'l':	 // 1 string to match.
        return 2;	 // "al"
      case 'x':	 // 1 string to match.
        return 3;	 // "ax"
      }
      break;
    case 'b':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 4;	 // "bh"
      case 'l':	 // 1 string to match.
        return 5;	 // "bl"
      case 'p':	 // 1 string to match.
        return 6;	 // "bp"
      case 'x':	 // 1 string to match.
        return 9;	 // "bx"
      }
      break;
    case 'c':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 10;	 // "ch"
      case 'l':	 // 1 string to match.
        return 11;	 // "cl"
      case 's':	 // 1 string to match.
        return 12;	 // "cs"
      case 'x':	 // 1 string to match.
        return 13;	 // "cx"
      }
      break;
    case 'd':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 15;	 // "dh"
      case 'i':	 // 1 string to match.
        return 16;	 // "di"
      case 'l':	 // 1 string to match.
        return 19;	 // "dl"
      case 's':	 // 1 string to match.
        return 20;	 // "ds"
      case 'x':	 // 1 string to match.
        return 21;	 // "dx"
      }
      break;
    case 'e':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 31;	 // "es"
    case 'f':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 36;	 // "fs"
    case 'g':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 38;	 // "gs"
    case 'i':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 49;	 // "ip"
    case 'k':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 112;	 // "k0"
      case '1':	 // 1 string to match.
        return 113;	 // "k1"
      case '2':	 // 1 string to match.
        return 114;	 // "k2"
      case '3':	 // 1 string to match.
        return 115;	 // "k3"
      case '4':	 // 1 string to match.
        return 116;	 // "k4"
      case '5':	 // 1 string to match.
        return 117;	 // "k5"
      case '6':	 // 1 string to match.
        return 118;	 // "k6"
      case '7':	 // 1 string to match.
        return 119;	 // "k7"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return 128;	 // "r8"
      case '9':	 // 1 string to match.
        return 129;	 // "r9"
      }
      break;
    case 's':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        return 62;	 // "si"
      case 'p':	 // 1 string to match.
        return 65;	 // "sp"
      case 's':	 // 1 string to match.
        return 68;	 // "ss"
      case 't':	 // 1 string to match.
        return 136;	 // "st"
      }
      break;
    }
    break;
  case 3:	 // 73 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pl", 2) != 0)
        break;
      return 8;	 // "bpl"
    case 'c':	 // 10 strings to match.
      if (Name[1] != 'r')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 72;	 // "cr0"
      case '1':	 // 1 string to match.
        return 73;	 // "cr1"
      case '2':	 // 1 string to match.
        return 74;	 // "cr2"
      case '3':	 // 1 string to match.
        return 75;	 // "cr3"
      case '4':	 // 1 string to match.
        return 76;	 // "cr4"
      case '5':	 // 1 string to match.
        return 77;	 // "cr5"
      case '6':	 // 1 string to match.
        return 78;	 // "cr6"
      case '7':	 // 1 string to match.
        return 79;	 // "cr7"
      case '8':	 // 1 string to match.
        return 80;	 // "cr8"
      case '9':	 // 1 string to match.
        return 81;	 // "cr9"
      }
      break;
    case 'd':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 18;	 // "dil"
      case 'r':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 88;	 // "dr0"
        case '1':	 // 1 string to match.
          return 89;	 // "dr1"
        case '2':	 // 1 string to match.
          return 90;	 // "dr2"
        case '3':	 // 1 string to match.
          return 91;	 // "dr3"
        case '4':	 // 1 string to match.
          return 92;	 // "dr4"
        case '5':	 // 1 string to match.
          return 93;	 // "dr5"
        case '6':	 // 1 string to match.
          return 94;	 // "dr6"
        case '7':	 // 1 string to match.
          return 95;	 // "dr7"
        case '8':	 // 1 string to match.
          return 96;	 // "dr8"
        case '9':	 // 1 string to match.
          return 97;	 // "dr9"
        }
        break;
      }
      break;
    case 'e':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 22;	 // "eax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 23;	 // "ebp"
        case 'x':	 // 1 string to match.
          return 24;	 // "ebx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 25;	 // "ecx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 26;	 // "edi"
        case 'x':	 // 1 string to match.
          return 27;	 // "edx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 29;	 // "eip"
        case 'z':	 // 1 string to match.
          return 30;	 // "eiz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 32;	 // "esi"
        case 'p':	 // 1 string to match.
          return 33;	 // "esp"
        }
        break;
      }
      break;
    case 'f':	 // 8 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 104;	 // "fp0"
      case '1':	 // 1 string to match.
        return 105;	 // "fp1"
      case '2':	 // 1 string to match.
        return 106;	 // "fp2"
      case '3':	 // 1 string to match.
        return 107;	 // "fp3"
      case '4':	 // 1 string to match.
        return 108;	 // "fp4"
      case '5':	 // 1 string to match.
        return 109;	 // "fp5"
      case '6':	 // 1 string to match.
        return 110;	 // "fp6"
      case '7':	 // 1 string to match.
        return 111;	 // "fp7"
      }
      break;
    case 'm':	 // 8 strings to match.
      if (Name[1] != 'm')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 120;	 // "mm0"
      case '1':	 // 1 string to match.
        return 121;	 // "mm1"
      case '2':	 // 1 string to match.
        return 122;	 // "mm2"
      case '3':	 // 1 string to match.
        return 123;	 // "mm3"
      case '4':	 // 1 string to match.
        return 124;	 // "mm4"
      case '5':	 // 1 string to match.
        return 125;	 // "mm5"
      case '6':	 // 1 string to match.
        return 126;	 // "mm6"
      case '7':	 // 1 string to match.
        return 127;	 // "mm7"
      }
      break;
    case 'r':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 130;	 // "r10"
        case '1':	 // 1 string to match.
          return 131;	 // "r11"
        case '2':	 // 1 string to match.
          return 132;	 // "r12"
        case '3':	 // 1 string to match.
          return 133;	 // "r13"
        case '4':	 // 1 string to match.
          return 134;	 // "r14"
        case '5':	 // 1 string to match.
          return 135;	 // "r15"
        }
        break;
      case '8':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 248;	 // "r8b"
        case 'd':	 // 1 string to match.
          return 264;	 // "r8d"
        case 'w':	 // 1 string to match.
          return 272;	 // "r8w"
        }
        break;
      case '9':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 249;	 // "r9b"
        case 'd':	 // 1 string to match.
          return 265;	 // "r9d"
        case 'w':	 // 1 string to match.
          return 273;	 // "r9w"
        }
        break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 51;	 // "rax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 52;	 // "rbp"
        case 'x':	 // 1 string to match.
          return 53;	 // "rbx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 54;	 // "rcx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 55;	 // "rdi"
        case 'x':	 // 1 string to match.
          return 56;	 // "rdx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 58;	 // "rip"
        case 'z':	 // 1 string to match.
          return 59;	 // "riz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 60;	 // "rsi"
        case 'p':	 // 1 string to match.
          return 61;	 // "rsp"
        }
        break;
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 64;	 // "sil"
      case 'p':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 67;	 // "spl"
      case 's':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return 69;	 // "ssp"
      }
      break;
    }
    break;
  case 4:	 // 70 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 82;	 // "cr10"
      case '1':	 // 1 string to match.
        return 83;	 // "cr11"
      case '2':	 // 1 string to match.
        return 84;	 // "cr12"
      case '3':	 // 1 string to match.
        return 85;	 // "cr13"
      case '4':	 // 1 string to match.
        return 86;	 // "cr14"
      case '5':	 // 1 string to match.
        return 87;	 // "cr15"
      }
      break;
    case 'd':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 98;	 // "dr10"
      case '1':	 // 1 string to match.
        return 99;	 // "dr11"
      case '2':	 // 1 string to match.
        return 100;	 // "dr12"
      case '3':	 // 1 string to match.
        return 101;	 // "dr13"
      case '4':	 // 1 string to match.
        return 102;	 // "dr14"
      case '5':	 // 1 string to match.
        return 103;	 // "dr15"
      }
      break;
    case 'f':	 // 2 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (Name[3] != 'r')
          break;
        return 34;	 // "fpcr"
      case 's':	 // 1 string to match.
        if (Name[3] != 'r')
          break;
        return 35;	 // "fpsr"
      }
      break;
    case 'r':	 // 18 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 250;	 // "r10b"
        case 'd':	 // 1 string to match.
          return 266;	 // "r10d"
        case 'w':	 // 1 string to match.
          return 274;	 // "r10w"
        }
        break;
      case '1':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 251;	 // "r11b"
        case 'd':	 // 1 string to match.
          return 267;	 // "r11d"
        case 'w':	 // 1 string to match.
          return 275;	 // "r11w"
        }
        break;
      case '2':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 252;	 // "r12b"
        case 'd':	 // 1 string to match.
          return 268;	 // "r12d"
        case 'w':	 // 1 string to match.
          return 276;	 // "r12w"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 253;	 // "r13b"
        case 'd':	 // 1 string to match.
          return 269;	 // "r13d"
        case 'w':	 // 1 string to match.
          return 277;	 // "r13w"
        }
        break;
      case '4':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 254;	 // "r14b"
        case 'd':	 // 1 string to match.
          return 270;	 // "r14d"
        case 'w':	 // 1 string to match.
          return 278;	 // "r14w"
        }
        break;
      case '5':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 255;	 // "r15b"
        case 'd':	 // 1 string to match.
          return 271;	 // "r15d"
        case 'w':	 // 1 string to match.
          return 279;	 // "r15w"
        }
        break;
      }
      break;
    case 't':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 144;	 // "tmm0"
      case '1':	 // 1 string to match.
        return 145;	 // "tmm1"
      case '2':	 // 1 string to match.
        return 146;	 // "tmm2"
      case '3':	 // 1 string to match.
        return 147;	 // "tmm3"
      case '4':	 // 1 string to match.
        return 148;	 // "tmm4"
      case '5':	 // 1 string to match.
        return 149;	 // "tmm5"
      case '6':	 // 1 string to match.
        return 150;	 // "tmm6"
      case '7':	 // 1 string to match.
        return 151;	 // "tmm7"
      }
      break;
    case 'x':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 152;	 // "xmm0"
      case '1':	 // 1 string to match.
        return 153;	 // "xmm1"
      case '2':	 // 1 string to match.
        return 154;	 // "xmm2"
      case '3':	 // 1 string to match.
        return 155;	 // "xmm3"
      case '4':	 // 1 string to match.
        return 156;	 // "xmm4"
      case '5':	 // 1 string to match.
        return 157;	 // "xmm5"
      case '6':	 // 1 string to match.
        return 158;	 // "xmm6"
      case '7':	 // 1 string to match.
        return 159;	 // "xmm7"
      case '8':	 // 1 string to match.
        return 160;	 // "xmm8"
      case '9':	 // 1 string to match.
        return 161;	 // "xmm9"
      }
      break;
    case 'y':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 184;	 // "ymm0"
      case '1':	 // 1 string to match.
        return 185;	 // "ymm1"
      case '2':	 // 1 string to match.
        return 186;	 // "ymm2"
      case '3':	 // 1 string to match.
        return 187;	 // "ymm3"
      case '4':	 // 1 string to match.
        return 188;	 // "ymm4"
      case '5':	 // 1 string to match.
        return 189;	 // "ymm5"
      case '6':	 // 1 string to match.
        return 190;	 // "ymm6"
      case '7':	 // 1 string to match.
        return 191;	 // "ymm7"
      case '8':	 // 1 string to match.
        return 192;	 // "ymm8"
      case '9':	 // 1 string to match.
        return 193;	 // "ymm9"
      }
      break;
    case 'z':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 216;	 // "zmm0"
      case '1':	 // 1 string to match.
        return 217;	 // "zmm1"
      case '2':	 // 1 string to match.
        return 218;	 // "zmm2"
      case '3':	 // 1 string to match.
        return 219;	 // "zmm3"
      case '4':	 // 1 string to match.
        return 220;	 // "zmm4"
      case '5':	 // 1 string to match.
        return 221;	 // "zmm5"
      case '6':	 // 1 string to match.
        return 222;	 // "zmm6"
      case '7':	 // 1 string to match.
        return 223;	 // "zmm7"
      case '8':	 // 1 string to match.
        return 224;	 // "zmm8"
      case '9':	 // 1 string to match.
        return 225;	 // "zmm9"
      }
      break;
    }
    break;
  case 5:	 // 75 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lags", 4) != 0)
        break;
      return 28;	 // "flags"
    case 'm':	 // 1 string to match.
      if (memcmp(Name.data()+1, "xcsr", 4) != 0)
        break;
      return 50;	 // "mxcsr"
    case 's':	 // 7 strings to match.
      if (memcmp(Name.data()+1, "t(", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 137;	 // "st(1)"
      case '2':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 138;	 // "st(2)"
      case '3':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 139;	 // "st(3)"
      case '4':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 140;	 // "st(4)"
      case '5':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 141;	 // "st(5)"
      case '6':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 142;	 // "st(6)"
      case '7':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 143;	 // "st(7)"
      }
      break;
    case 'x':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 162;	 // "xmm10"
        case '1':	 // 1 string to match.
          return 163;	 // "xmm11"
        case '2':	 // 1 string to match.
          return 164;	 // "xmm12"
        case '3':	 // 1 string to match.
          return 165;	 // "xmm13"
        case '4':	 // 1 string to match.
          return 166;	 // "xmm14"
        case '5':	 // 1 string to match.
          return 167;	 // "xmm15"
        case '6':	 // 1 string to match.
          return 168;	 // "xmm16"
        case '7':	 // 1 string to match.
          return 169;	 // "xmm17"
        case '8':	 // 1 string to match.
          return 170;	 // "xmm18"
        case '9':	 // 1 string to match.
          return 171;	 // "xmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 172;	 // "xmm20"
        case '1':	 // 1 string to match.
          return 173;	 // "xmm21"
        case '2':	 // 1 string to match.
          return 174;	 // "xmm22"
        case '3':	 // 1 string to match.
          return 175;	 // "xmm23"
        case '4':	 // 1 string to match.
          return 176;	 // "xmm24"
        case '5':	 // 1 string to match.
          return 177;	 // "xmm25"
        case '6':	 // 1 string to match.
          return 178;	 // "xmm26"
        case '7':	 // 1 string to match.
          return 179;	 // "xmm27"
        case '8':	 // 1 string to match.
          return 180;	 // "xmm28"
        case '9':	 // 1 string to match.
          return 181;	 // "xmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 182;	 // "xmm30"
        case '1':	 // 1 string to match.
          return 183;	 // "xmm31"
        }
        break;
      }
      break;
    case 'y':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 194;	 // "ymm10"
        case '1':	 // 1 string to match.
          return 195;	 // "ymm11"
        case '2':	 // 1 string to match.
          return 196;	 // "ymm12"
        case '3':	 // 1 string to match.
          return 197;	 // "ymm13"
        case '4':	 // 1 string to match.
          return 198;	 // "ymm14"
        case '5':	 // 1 string to match.
          return 199;	 // "ymm15"
        case '6':	 // 1 string to match.
          return 200;	 // "ymm16"
        case '7':	 // 1 string to match.
          return 201;	 // "ymm17"
        case '8':	 // 1 string to match.
          return 202;	 // "ymm18"
        case '9':	 // 1 string to match.
          return 203;	 // "ymm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 204;	 // "ymm20"
        case '1':	 // 1 string to match.
          return 205;	 // "ymm21"
        case '2':	 // 1 string to match.
          return 206;	 // "ymm22"
        case '3':	 // 1 string to match.
          return 207;	 // "ymm23"
        case '4':	 // 1 string to match.
          return 208;	 // "ymm24"
        case '5':	 // 1 string to match.
          return 209;	 // "ymm25"
        case '6':	 // 1 string to match.
          return 210;	 // "ymm26"
        case '7':	 // 1 string to match.
          return 211;	 // "ymm27"
        case '8':	 // 1 string to match.
          return 212;	 // "ymm28"
        case '9':	 // 1 string to match.
          return 213;	 // "ymm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 214;	 // "ymm30"
        case '1':	 // 1 string to match.
          return 215;	 // "ymm31"
        }
        break;
      }
      break;
    case 'z':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 226;	 // "zmm10"
        case '1':	 // 1 string to match.
          return 227;	 // "zmm11"
        case '2':	 // 1 string to match.
          return 228;	 // "zmm12"
        case '3':	 // 1 string to match.
          return 229;	 // "zmm13"
        case '4':	 // 1 string to match.
          return 230;	 // "zmm14"
        case '5':	 // 1 string to match.
          return 231;	 // "zmm15"
        case '6':	 // 1 string to match.
          return 232;	 // "zmm16"
        case '7':	 // 1 string to match.
          return 233;	 // "zmm17"
        case '8':	 // 1 string to match.
          return 234;	 // "zmm18"
        case '9':	 // 1 string to match.
          return 235;	 // "zmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 236;	 // "zmm20"
        case '1':	 // 1 string to match.
          return 237;	 // "zmm21"
        case '2':	 // 1 string to match.
          return 238;	 // "zmm22"
        case '3':	 // 1 string to match.
          return 239;	 // "zmm23"
        case '4':	 // 1 string to match.
          return 240;	 // "zmm24"
        case '5':	 // 1 string to match.
          return 241;	 // "zmm25"
        case '6':	 // 1 string to match.
          return 242;	 // "zmm26"
        case '7':	 // 1 string to match.
          return 243;	 // "zmm27"
        case '8':	 // 1 string to match.
          return 244;	 // "zmm28"
        case '9':	 // 1 string to match.
          return 245;	 // "zmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 246;	 // "zmm30"
        case '1':	 // 1 string to match.
          return 247;	 // "zmm31"
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(Name.data()+1, "flags", 5) != 0)
        break;
      return 71;	 // "eflags"
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "flags", 5) != 0)
        break;
      return 57;	 // "rflags"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "mmcfg", 5) != 0)
        break;
      return 70;	 // "tmmcfg"
    }
    break;
  case 7:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "irflag", 6) != 0)
        break;
      return 14;	 // "dirflag"
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "s.base", 6) != 0)
        break;
      return 37;	 // "fs.base"
    case 'g':	 // 1 string to match.
      if (memcmp(Name.data()+1, "s.base", 6) != 0)
        break;
      return 39;	 // "gs.base"
    }
    break;
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_Not64BitModeBit: return "Not 64-bit mode";
  case Feature_In64BitModeBit: return "64-bit mode";
  case Feature_In16BitModeBit: return "16-bit mode";
  case Feature_Not16BitModeBit: return "Not 16-bit mode";
  case Feature_In32BitModeBit: return "32-bit mode";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[2] != 'w')
              break;
            Mnemonic = "cbtw";	 // "cbw"
            return;
          case 'd':	 // 1 string to match.
            if (Mnemonic[2] != 'q')
              break;
            Mnemonic = "cltd";	 // "cdq"
            return;
          case 'q':	 // 1 string to match.
            if (Mnemonic[2] != 'o')
              break;
            Mnemonic = "cqto";	 // "cqo"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[2] != 'd')
              break;
            Mnemonic = "cwtd";	 // "cwd"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "pop"
            Mnemonic = "popw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "popl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "popq";
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "ret"
            Mnemonic = "retw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "retl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "retq";
          return;
        }
        break;
      case 4:	 // 18 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ll", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "call"
              Mnemonic = "callw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "calll";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "callq";
            return;
          case 'd':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "qe", 2) != 0)
              break;
            Mnemonic = "cltq";	 // "cdqe"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "de", 2) != 0)
              break;
            Mnemonic = "cwtl";	 // "cwde"
            return;
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ret", 3) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "iret"
            Mnemonic = "iretw";
          else if (Features.test(Feature_Not16BitModeBit))
            Mnemonic = "iretl";
          return;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lgdt"
              Mnemonic = "lgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lgdtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "lgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lidt"
              Mnemonic = "lidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lidtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "lidtq";
            return;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "et", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lret"
              Mnemonic = "lretw";
            else if (Features.test(Feature_Not16BitModeBit))
              Mnemonic = "lretl";
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "popa"
                Mnemonic = "popaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "popf"
                Mnemonic = "popfw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "popfl";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "popfq";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "push"
              Mnemonic = "pushw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "pushl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "pushq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "retn"
            Mnemonic = "retw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "retl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "retq";
          return;
        case 's':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 4 strings to match.
            if (Mnemonic[2] != 'l')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              Mnemonic = "shlb";	 // "salb"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "shll";	 // "sall"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "shlq";	 // "salq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "shlw";	 // "salw"
              return;
            }
            break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sgdt"
              Mnemonic = "sgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sgdtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "sgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sidt"
              Mnemonic = "sidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sidtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "sidtq";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "d2a", 3) != 0)
            break;
          Mnemonic = "ud2";	 // "ud2a"
          return;
        }
        break;
      case 5:	 // 12 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ildq", 4) != 0)
            break;
          Mnemonic = "fildll";	 // "fildq"
          return;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pfd", 3) != 0)
              break;
            Mnemonic = "popfl";	 // "popfd"
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pusha"
                Mnemonic = "pushaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pushf"
                Mnemonic = "pushfw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushfl";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        case 's':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "movsb";	 // "smovb"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "movsl";	 // "smovl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "movsq";	 // "smovq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "movsw";	 // "smovw"
            return;
          }
          break;
        case 'u':	 // 3 strings to match.
          if (memcmp(Mnemonic.data()+1, "d2b", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "ud1l";	 // "ud2bl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "ud1q";	 // "ud2bq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "ud1w";	 // "ud2bw"
            return;
          }
          break;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "errw", 4) != 0)
            break;
          Mnemonic = "verr";	 // "verrw"
          return;
        }
        break;
      case 6:	 // 15 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 6 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovcl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovcq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovcw"
              return;
            }
            break;
          case 'z':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovel";	 // "cmovzl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmoveq";	 // "cmovzq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovew";	 // "cmovzw"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "fcmovnbe";	 // "fcmova"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "fcmove";	 // "fcmovz"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "stpq", 4) != 0)
              break;
            Mnemonic = "fistpll";	 // "fistpq"
            return;
          case 'l':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dcww", 4) != 0)
              break;
            Mnemonic = "fldcw";	 // "fldcww"
            return;
          }
          break;
        case 'l':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "eave", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (Features.test(Feature_Not64BitModeBit))	 // "leavel"
              Mnemonic = "leave";
            return;
          case 'q':	 // 1 string to match.
            if (Features.test(Feature_In64BitModeBit))	 // "leaveq"
              Mnemonic = "leave";
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushfd", 5) != 0)
            break;
          Mnemonic = "pushfl";	 // "pushfd"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysret", 5) != 0)
            break;
          Mnemonic = "sysretl";	 // "sysret"
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "saveq", 5) != 0)
            break;
          Mnemonic = "xsave64";	 // "xsaveq"
          return;
        }
        break;
      case 7:	 // 34 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbel";	 // "cmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbeq";	 // "cmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbew";	 // "cmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovlel";	 // "cmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovleq";	 // "cmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlew";	 // "cmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgel";	 // "cmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgeq";	 // "cmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgew";	 // "cmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnel";	 // "cmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovneq";	 // "cmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnew";	 // "cmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovpl";	 // "cmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovpq";	 // "cmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovpw";	 // "cmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnpl";	 // "cmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovnpq";	 // "cmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnpw";	 // "cmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "fcmovnb";	 // "fcmovae"
              return;
            case 'n':	 // 1 string to match.
              if (Mnemonic[6] != 'a')
                break;
              Mnemonic = "fcmovbe";	 // "fcmovna"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sttpq", 5) != 0)
              break;
            Mnemonic = "fisttpll";	 // "fisttpq"
            return;
          case 'n':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "st", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstcw";	 // "fnstcww"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstsw";	 // "fnstsww"
              return;
            }
            break;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "saveq", 5) != 0)
              break;
            Mnemonic = "fxsave64";	 // "fxsaveq"
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysexit", 6) != 0)
            break;
          Mnemonic = "sysexitl";	 // "sysexit"
          return;
        case 'x':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "storq", 5) != 0)
              break;
            Mnemonic = "xrstor64";	 // "xrstorq"
            return;
          case 's':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "ave", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsavec64";	 // "xsavecq"
              return;
            case 's':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsaves64";	 // "xsavesq"
              return;
            }
            break;
          }
          break;
        }
        break;
      case 8:	 // 15 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 12 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovnael"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovnaeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovnaew"
              return;
            }
            break;
          case 'b':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmoval";	 // "cmovnbel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovaq";	 // "cmovnbeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovaw";	 // "cmovnbew"
              return;
            }
            break;
          case 'g':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovll";	 // "cmovngel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovlq";	 // "cmovngeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovlw";	 // "cmovngew"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovgl";	 // "cmovnlel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovgq";	 // "cmovnleq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovgw";	 // "cmovnlew"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "movnae", 6) != 0)
              break;
            Mnemonic = "fcmovb";	 // "fcmovnae"
            return;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "rstorq", 6) != 0)
              break;
            Mnemonic = "fxrstor64";	 // "fxrstorq"
            return;
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "rstorsq", 7) != 0)
            break;
          Mnemonic = "xrstors64";	 // "xrstorsq"
          return;
        }
        break;
      case 9:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "xsaveoptq", 9) != 0)
          break;
        Mnemonic = "xsaveopt64";	 // "xsaveoptq"
        return;
      }
    break;
  case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "sal", 3) != 0)
          break;
        Mnemonic = "shl";	 // "sal"
        return;
      case 4:	 // 7 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lgdt"
              Mnemonic = "lgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lidt"
              Mnemonic = "lidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lidtd";
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          switch (Mnemonic[3]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Features.test(Feature_In16BitModeBit))	 // "popa"
              Mnemonic = "popaw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "popal";
            return;
          case 'f':	 // 1 string to match.
            if (Features.test(Feature_In64BitModeBit))	 // "popf"
              Mnemonic = "popfq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          Mnemonic = "ret";	 // "retn"
          return;
        case 's':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sgdt"
              Mnemonic = "sgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sidt"
              Mnemonic = "sidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sidtd";
            return;
          }
          break;
        }
        break;
      case 5:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 1 string to match.
            Mnemonic = "cmovb";	 // "cmovc"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cmove";	 // "cmovz"
            return;
          }
          break;
        case 'p':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[4] != 'd')
                break;
              if (Features.test(Feature_Not64BitModeBit))	 // "popad"
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if (Mnemonic[4] != 'w')
                break;
              if (Features.test(Feature_In32BitModeBit))	 // "popfw"
                Mnemonic = "popf";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "popf";
              return;
            }
            break;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pusha"
                Mnemonic = "pushaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In64BitModeBit))	 // "pushf"
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        }
        break;
      case 6:	 // 10 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 8 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "cmovbe";	 // "cmovna"
              return;
            case 'b':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnb"
              return;
            case 'c':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnc"
              return;
            case 'g':	 // 1 string to match.
              Mnemonic = "cmovle";	 // "cmovng"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovge";	 // "cmovnl"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cmovne";	 // "cmovnz"
              return;
            }
            break;
          case 'p':	 // 2 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "cmovp";	 // "cmovpe"
              return;
            case 'o':	 // 1 string to match.
              Mnemonic = "cmovnp";	 // "cmovpo"
              return;
            }
            break;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "ush", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Mnemonic[5] != 'd')
              break;
            if (Features.test(Feature_Not64BitModeBit))	 // "pushad"
              Mnemonic = "pushal";
            return;
          case 'f':	 // 1 string to match.
            if (Mnemonic[5] != 'w')
              break;
            if (Features.test(Feature_In32BitModeBit))	 // "pushfw"
              Mnemonic = "pushf";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "pushf";
            return;
          }
          break;
        }
        break;
      case 7:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "cquire", 6) != 0)
            break;
          Mnemonic = "xacquire";	 // "acquire"
          return;
        case 'c':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovb";	 // "cmovnae"
            return;
          case 'b':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmova";	 // "cmovnbe"
            return;
          case 'g':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovl";	 // "cmovnge"
            return;
          case 'l':	 // 1 string to match.
            if (Mnemonic[6] != 'e')
              break;
            Mnemonic = "cmovg";	 // "cmovnle"
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "elease", 6) != 0)
            break;
          Mnemonic = "xrelease";	 // "release"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 2 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'c':	 // 1 string to match.
      Mnemonic = "jb";	 // "jc"
      return;
    case 'z':	 // 1 string to match.
      Mnemonic = "je";	 // "jz"
      return;
    }
    break;
  case 3:	 // 8 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "jbe";	 // "jna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "jle";	 // "jng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jge";	 // "jnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jne";	 // "jnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jp";	 // "jpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jnp";	 // "jpo"
        return;
      }
      break;
    }
    break;
  case 4:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'j':	 // 4 strings to match.
      if (Mnemonic[1] != 'n')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jb";	 // "jnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "ja";	 // "jnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jl";	 // "jnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jg";	 // "jnle"
        return;
      }
      break;
    case 'r':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "ep", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "rep";	 // "repe"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "rep";	 // "repz"
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        Mnemonic = "setb";	 // "setc"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "sete";	 // "setz"
        return;
      }
      break;
    }
    break;
  case 5:	 // 11 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "wait", 4) != 0)
        break;
      Mnemonic = "wait";	 // "fwait"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopz", 4) != 0)
        break;
      Mnemonic = "loope";	 // "loopz"
      return;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "epnz", 4) != 0)
        break;
      Mnemonic = "repne";	 // "repnz"
      return;
    case 's':	 // 8 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'n':	 // 6 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "setbe";	 // "setna"
          return;
        case 'b':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnb"
          return;
        case 'c':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnc"
          return;
        case 'g':	 // 1 string to match.
          Mnemonic = "setle";	 // "setng"
          return;
        case 'l':	 // 1 string to match.
          Mnemonic = "setge";	 // "setnl"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setne";	 // "setnz"
          return;
        }
        break;
      case 'p':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          Mnemonic = "setp";	 // "setpe"
          return;
        case 'o':	 // 1 string to match.
          Mnemonic = "setnp";	 // "setpo"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 6 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "comip", 5) != 0)
        break;
      Mnemonic = "fcompi";	 // "fcomip"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopnz", 5) != 0)
        break;
      Mnemonic = "loopne";	 // "loopnz"
      return;
    case 's':	 // 4 strings to match.
      if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setb";	 // "setnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "seta";	 // "setnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setl";	 // "setnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[5] != 'e')
          break;
        Mnemonic = "setg";	 // "setnle"
        return;
      }
      break;
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "fucomip", 7) != 0)
      break;
    Mnemonic = "fucompi";	 // "fucomip"
    return;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie0_4_4,
  Tie1_1_1,
  Tie1_2_2,
  Tie1_3_3,
  Tie1_4_4,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_4_4 */ { 0, 4, 4 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie1_2_2 */ { 1, 2, 2 },
  /* Tie1_3_3 */ { 1, 3, 3 },
  /* Tie1_4_4 */ { 1, 4, 4 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_imm_95_10,
  CVT_95_addImmOperands,
  CVT_95_addMemOperands,
  CVT_95_Reg,
  CVT_regAX,
  CVT_regEAX,
  CVT_regRAX,
  CVT_95_addAbsMemOperands,
  CVT_imm_95_7,
  CVT_imm_95_3,
  CVT_imm_95_2,
  CVT_imm_95_6,
  CVT_imm_95_4,
  CVT_imm_95_15,
  CVT_imm_95_13,
  CVT_imm_95_12,
  CVT_imm_95_14,
  CVT_imm_95_5,
  CVT_imm_95_1,
  CVT_imm_95_11,
  CVT_imm_95_9,
  CVT_imm_95_0,
  CVT_imm_95_8,
  CVT_95_addDstIdxOperands,
  CVT_95_addSrcIdxOperands,
  CVT_95_addGR32orGR64Operands,
  CVT_regST1,
  CVT_regST0,
  CVT_95_addGR16orGR32orGR64Operands,
  CVT_95_addMemOffsOperands,
  CVT_imm_95_17,
  CVT_imm_95_16,
  CVT_95_addAVX512RCOperands,
  CVT_95_addMaskPairOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__imm_95_10,
  Convert__Imm1_0,
  Convert__Mem325_0__Reg1_1,
  Convert__Mem645_0__Reg1_1,
  Convert__Mem325_1__Reg1_0,
  Convert__Mem645_1__Reg1_0,
  Convert__Imm1_1,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_1,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_1,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_1,
  Convert__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1,
  Convert__Reg1_0__Tie0_1_1__Imm1_1,
  Convert__Reg1_0__Tie0_1_1__Mem165_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1,
  Convert__Reg1_0__Tie0_1_1__Mem85_1,
  Convert__Mem165_0__Reg1_1,
  Convert__Mem165_0__ImmSExti16i81_1,
  Convert__Mem165_0__Imm1_1,
  Convert__Mem325_0__ImmSExti32i81_1,
  Convert__Mem325_0__Imm1_1,
  Convert__Mem645_0__ImmSExti64i81_1,
  Convert__Mem645_0__ImmSExti64i321_1,
  Convert__Mem85_0__Reg1_1,
  Convert__Mem85_0__Imm1_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0,
  Convert__Mem85_1__Reg1_0,
  Convert__Reg1_1__Tie0_2_2__Imm1_0,
  Convert__Mem85_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem85_0,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0,
  Convert__Mem325_1__ImmSExti32i81_0,
  Convert__Mem325_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0,
  Convert__Mem645_1__ImmSExti64i81_0,
  Convert__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0,
  Convert__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0,
  Convert__Mem165_1__Reg1_0,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0,
  Convert__Mem165_1__ImmSExti16i81_0,
  Convert__Mem165_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem165_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Mem325_0,
  Convert__Reg1_1__Tie0_1_1__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1,
  Convert__Reg1_1__Tie0_1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Mem5_1,
  Convert__Reg1_1__Tie0_2_2__Mem5_0,
  Convert__Mem5_0,
  Convert__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Mem1285_1,
  Convert__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__Mem325_2,
  Convert__Reg1_0__Reg1_1__Mem645_2,
  Convert__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Mem325_1__Reg1_2,
  Convert__Reg1_0__Mem325_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i321_2,
  Convert__Reg1_0__Mem645_1__Reg1_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i321_2,
  Convert__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_0__Mem325_1,
  Convert__Reg1_0__Mem645_1,
  Convert__Reg1_1__Mem325_0,
  Convert__Reg1_1__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1,
  Convert__Reg1_0__Mem165_1,
  Convert__Reg1_1__Mem165_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__Reg1_0__ImmUnsignedi81_1,
  Convert__Mem325_1__ImmUnsignedi81_0,
  Convert__Mem165_0__ImmUnsignedi81_1,
  Convert__Mem325_0__ImmUnsignedi81_1,
  Convert__Mem645_0__ImmUnsignedi81_1,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0,
  Convert__Mem645_1__ImmUnsignedi81_0,
  Convert__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0,
  Convert__AbsMem1_0,
  Convert__Mem165_0,
  Convert__Mem325_0,
  Convert__Mem645_0,
  Convert__Imm1_1__Imm1_0,
  Convert__Reg1_1,
  Convert__Mem325_1,
  Convert__Mem645_1,
  Convert__Mem165_1,
  Convert__Mem85_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8,
  Convert__regAX__ImmSExti16i81_1,
  Convert__regEAX__ImmSExti32i81_1,
  Convert__regRAX__ImmSExti64i81_1,
  Convert__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__Imm1_1,
  Convert__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_0__Mem85_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_7,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_1__Mem85_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_15,
  Convert__regEAX__ImmSExti32i81_0,
  Convert__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_10,
  Convert__regRAX__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti64i321_0,
  Convert__DstIdx161_1__SrcIdx162_0,
  Convert__DstIdx321_1__SrcIdx322_0,
  Convert__DstIdx641_1__SrcIdx642_0,
  Convert__DstIdx81_1__SrcIdx82_0,
  Convert__DstIdx81_0__SrcIdx82_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0,
  Convert__DstIdx321_0__SrcIdx322_1,
  Convert__DstIdx641_0__SrcIdx642_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx161_0__SrcIdx162_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_8,
  Convert__regAX__ImmSExti16i81_0,
  Convert__Reg1_1__ImmSExti16i81_0,
  Convert__Mem1285_0,
  Convert__Mem85_1,
  Convert__Reg1_0__Mem5125_1,
  Convert__Reg1_1__Mem5125_0,
  Convert__Imm1_0__Imm1_1,
  Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0,
  Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__regST1,
  Convert__regST0,
  Convert__Mem805_0,
  Convert__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__Reg1_0__Imm1_1,
  Convert__Reg1_0__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_0__Reg1_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i81_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i81_2,
  Convert__Reg1_1__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_1__Tie0_1_1__Mem165_0,
  Convert__Reg1_2__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__Imm1_0,
  Convert__ImmUnsignedi81_1,
  Convert__DstIdx161_0,
  Convert__DstIdx321_0,
  Convert__DstIdx81_0,
  Convert__DstIdx81_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__DstIdx321_1,
  Convert__DstIdx161_1,
  Convert__AbsMem1_0__imm_95_7,
  Convert__AbsMem1_0__imm_95_3,
  Convert__AbsMem1_0__imm_95_2,
  Convert__AbsMem1_0__imm_95_6,
  Convert__AbsMem1_0__imm_95_4,
  Convert__AbsMem1_0__imm_95_15,
  Convert__AbsMem1_0__imm_95_13,
  Convert__AbsMem1_0__imm_95_12,
  Convert__AbsMem1_0__imm_95_14,
  Convert__AbsMem1_0__imm_95_5,
  Convert__AbsMem1_0__imm_95_1,
  Convert__AbsMem1_0__imm_95_11,
  Convert__AbsMem1_0__imm_95_9,
  Convert__AbsMem1_0__imm_95_0,
  Convert__AbsMem1_0__imm_95_10,
  Convert__AbsMem1_0__imm_95_8,
  Convert__Reg1_0__GR16orGR32orGR641_1,
  Convert__Reg1_1__GR16orGR32orGR641_0,
  Convert__Mem5_1,
  Convert__Reg1_0__Mem5_1,
  Convert__Reg1_1__Mem5_0,
  Convert__SrcIdx162_0,
  Convert__SrcIdx322_0,
  Convert__SrcIdx642_0,
  Convert__SrcIdx82_0,
  Convert__SrcIdx82_1,
  Convert__SrcIdx162_1,
  Convert__SrcIdx322_1,
  Convert__SrcIdx642_1,
  Convert__MemOffs16_82_1,
  Convert__MemOffs32_82_1,
  Convert__MemOffs16_162_1,
  Convert__MemOffs32_162_1,
  Convert__MemOffs16_322_1,
  Convert__MemOffs32_322_1,
  Convert__MemOffs32_642_1,
  Convert__MemOffs16_162_0,
  Convert__MemOffs16_322_0,
  Convert__MemOffs16_82_0,
  Convert__MemOffs32_162_0,
  Convert__MemOffs32_322_0,
  Convert__MemOffs32_642_0,
  Convert__MemOffs32_82_0,
  Convert__MemOffs64_82_1,
  Convert__MemOffs64_162_1,
  Convert__MemOffs64_322_1,
  Convert__MemOffs64_642_1,
  Convert__MemOffs64_162_0,
  Convert__MemOffs64_322_0,
  Convert__MemOffs64_642_0,
  Convert__MemOffs64_82_0,
  Convert__Mem1285_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1,
  Convert__Reg1_0__Mem512_GR165_1,
  Convert__Reg1_0__Mem512_GR325_1,
  Convert__Reg1_0__Mem512_GR645_1,
  Convert__Reg1_1__Mem512_GR165_0,
  Convert__Reg1_1__Mem512_GR325_0,
  Convert__Reg1_1__Mem512_GR645_0,
  Convert__GR32orGR641_1__Reg1_0,
  Convert__GR32orGR641_0__Reg1_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0,
  Convert__ImmSExti64i81_0,
  Convert__ImmSExti16i81_0,
  Convert__ImmSExti32i81_0,
  Convert__Mem85_0__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0_1_1,
  Convert__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx641_0,
  Convert__DstIdx641_1,
  Convert__Reg1_0__imm_95_7,
  Convert__Mem85_0__imm_95_7,
  Convert__Reg1_0__imm_95_3,
  Convert__Mem85_0__imm_95_3,
  Convert__Reg1_0__imm_95_2,
  Convert__Mem85_0__imm_95_2,
  Convert__Reg1_0__imm_95_6,
  Convert__Mem85_0__imm_95_6,
  Convert__Reg1_0__imm_95_4,
  Convert__Mem85_0__imm_95_4,
  Convert__Reg1_0__imm_95_15,
  Convert__Mem85_0__imm_95_15,
  Convert__Reg1_0__imm_95_13,
  Convert__Mem85_0__imm_95_13,
  Convert__Reg1_0__imm_95_12,
  Convert__Mem85_0__imm_95_12,
  Convert__Reg1_0__imm_95_14,
  Convert__Mem85_0__imm_95_14,
  Convert__Reg1_0__imm_95_5,
  Convert__Mem85_0__imm_95_5,
  Convert__Reg1_0__imm_95_1,
  Convert__Mem85_0__imm_95_1,
  Convert__Reg1_0__imm_95_11,
  Convert__Mem85_0__imm_95_11,
  Convert__Reg1_0__imm_95_9,
  Convert__Mem85_0__imm_95_9,
  Convert__Reg1_0__imm_95_0,
  Convert__Mem85_0__imm_95_0,
  Convert__Reg1_0__imm_95_10,
  Convert__Mem85_0__imm_95_10,
  Convert__Reg1_0__imm_95_8,
  Convert__Mem85_0__imm_95_8,
  Convert__Mem325_2__Reg1_1,
  Convert__Mem645_2__Reg1_1,
  Convert__Mem165_2__Reg1_1,
  Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0,
  Convert__Reg1_0__SibMem5_1,
  Convert__Reg1_1__SibMem5_0,
  Convert__SibMem5_1__Reg1_0,
  Convert__SibMem5_0__Reg1_1,
  Convert__GR32orGR641_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_1__Mem165_2,
  Convert__Reg1_3__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0,
  Convert__Reg1_3__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Reg1_1__Mem165_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0,
  Convert__Reg1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5,
  Convert__Reg1_0__Reg1_2__Mem645_5,
  Convert__Reg1_1__Reg1_3__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5,
  Convert__Reg1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Mem2565_1,
  Convert__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5,
  Convert__Reg1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_2__Mem325_5,
  Convert__Reg1_1__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_1,
  Convert__Mem2565_1__Reg1_0,
  Convert__Mem5125_1__Reg1_0,
  Convert__Mem2565_0__Reg1_1,
  Convert__Mem5125_0__Reg1_1,
  Convert__Mem1285_1__Reg1_3__Reg1_0,
  Convert__Mem2565_1__Reg1_3__Reg1_0,
  Convert__Mem5125_1__Reg1_3__Reg1_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4,
  Convert__Mem2565_0__Reg1_2__Reg1_4,
  Convert__Mem5125_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0,
  Convert__Reg1_2__Reg1_4__Mem325_0,
  Convert__Reg1_0__Reg1_1__AVX512RC1_2,
  Convert__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Mem5125_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Mem645_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0,
  Convert__Reg1_2__Reg1_4__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0,
  Convert__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0,
  Convert__Reg1_0__Reg1_2__Mem165_5,
  Convert__Reg1_2__Reg1_4__Mem165_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1,
  Convert__Reg1_2__Reg1_4__Reg1_1,
  Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Reg1_1,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1,
  Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem165_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem165_6,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem165_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem165_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC1285_1__Tie1_3_3,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC1285_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC256X5_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC256X5_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC2565_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC256X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC256X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC5125_0,
  Convert__Reg1_1__Mem512_RC256X5_3,
  Convert__Reg1_2__Mem512_RC256X5_0,
  Convert__Reg1_1__Mem512_RC5125_3,
  Convert__Reg1_2__Mem512_RC5125_0,
  Convert__Reg1_1__Mem256_RC5125_3,
  Convert__Reg1_2__Mem256_RC5125_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC2565_1__Tie1_3_3,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC256X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC256X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC5125_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem165_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem85_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem85_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0,
  Convert__Mem1285_2__Reg1_1__Reg1_0,
  Convert__Mem2565_2__Reg1_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1__Reg1_2,
  Convert__Mem2565_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_2__Reg1_4,
  Convert__Mem645_1__Reg1_3__Reg1_0,
  Convert__Mem645_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0,
  Convert__Mem165_1__Reg1_3__Reg1_0,
  Convert__Mem165_0__Reg1_2__Reg1_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0,
  Convert__Reg1_1__Reg1_3__Mem165_0,
  Convert__Mem325_1__Reg1_3__Reg1_0,
  Convert__Mem325_0__Reg1_2__Reg1_4,
  Convert__VK4Pair1_2__Reg1_1__Reg1_0,
  Convert__VK8Pair1_2__Reg1_1__Reg1_0,
  Convert__VK16Pair1_2__Reg1_1__Reg1_0,
  Convert__VK16Pair1_0__Reg1_1__Reg1_2,
  Convert__VK16Pair1_0__Reg1_1__Mem5125_2,
  Convert__VK4Pair1_0__Reg1_1__Reg1_2,
  Convert__VK4Pair1_0__Reg1_1__Mem1285_2,
  Convert__VK8Pair1_0__Reg1_1__Reg1_2,
  Convert__VK8Pair1_0__Reg1_1__Mem2565_2,
  Convert__VK4Pair1_2__Reg1_1__Mem1285_0,
  Convert__VK8Pair1_2__Reg1_1__Mem2565_0,
  Convert__VK16Pair1_2__Reg1_1__Mem5125_0,
  Convert__VK16Pair1_0__Reg1_1__Mem325_2,
  Convert__VK4Pair1_0__Reg1_1__Mem325_2,
  Convert__VK8Pair1_0__Reg1_1__Mem325_2,
  Convert__VK16Pair1_3__Reg1_2__Mem325_0,
  Convert__VK4Pair1_3__Reg1_2__Mem325_0,
  Convert__VK8Pair1_3__Reg1_2__Mem325_0,
  Convert__VK2Pair1_2__Reg1_1__Reg1_0,
  Convert__VK2Pair1_0__Reg1_1__Reg1_2,
  Convert__VK2Pair1_0__Reg1_1__Mem1285_2,
  Convert__VK4Pair1_0__Reg1_1__Mem2565_2,
  Convert__VK8Pair1_0__Reg1_1__Mem5125_2,
  Convert__VK2Pair1_2__Reg1_1__Mem1285_0,
  Convert__VK4Pair1_2__Reg1_1__Mem2565_0,
  Convert__VK8Pair1_2__Reg1_1__Mem5125_0,
  Convert__VK2Pair1_0__Reg1_1__Mem645_2,
  Convert__VK4Pair1_0__Reg1_1__Mem645_2,
  Convert__VK8Pair1_0__Reg1_1__Mem645_2,
  Convert__VK2Pair1_3__Reg1_2__Mem645_0,
  Convert__VK4Pair1_3__Reg1_2__Mem645_0,
  Convert__VK8Pair1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0,
  Convert__Reg1_0__Reg1_2__Mem85_5,
  Convert__Reg1_1__Reg1_3__Mem85_0,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi41_0,
  Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Mem1285_1__Reg1_2,
  Convert__Reg1_3__Mem128_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem256_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem512_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem128_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem256_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem512_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem256_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem512_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem256_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem512_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem128_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem256_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem128_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem256_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2,
  Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1,
  Convert__AbsMem161_0,
  Convert__Reg1_1__Tie0_2_2,
  Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__imm_95_10
  { CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ImmSExti64i321_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Imm1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_0__ImmSExti16i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem165_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__ImmSExti32i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i321_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem85_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Imm1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem5_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem5_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem5_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem1285_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_0__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__AbsMem1_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Mem165_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem645_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem85_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regAX__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem85_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem85_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_1__SrcIdx162_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_1__SrcIdx322_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1__SrcIdx642_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1__SrcIdx82_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0__SrcIdx82_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_0__SrcIdx322_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0__SrcIdx642_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0__SrcIdx162_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regAX__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem85_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5125_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Imm1_0__Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addGR32orGR64Operands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regST1
  { CVT_regST1, 0, CVT_Done },
  // Convert__regST0
  { CVT_regST0, 0, CVT_Done },
  // Convert__Mem805_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__ImmUnsignedi81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmUnsignedi81_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__DstIdx161_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__AbsMem1_0__imm_95_7
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_3
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_2
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_6
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_4
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_15
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_13
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_12
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_14
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_5
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_1
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_11
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_9
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_0
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_10
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_8
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__GR16orGR32orGR641_1
  { CVT_95_Reg, 1, CVT_95_addGR16orGR32orGR64Operands, 2, CVT_Done },
  // Convert__Reg1_1__GR16orGR32orGR641_0
  { CVT_95_Reg, 2, CVT_95_addGR16orGR32orGR64Operands, 1, CVT_Done },
  // Convert__Mem5_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SrcIdx162_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx322_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx642_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx322_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx642_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__MemOffs16_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__Mem1285_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem512_GR165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_GR325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_GR645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__GR32orGR641_1__Reg1_0
  { CVT_95_addGR32orGR64Operands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti16i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti32i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Mem85_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx641_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_7
  { CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_7
  { CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_3
  { CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_2
  { CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_6
  { CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_6
  { CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_4
  { CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_4
  { CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_15
  { CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_15
  { CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_13
  { CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_13
  { CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_12
  { CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_12
  { CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_14
  { CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_14
  { CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_5
  { CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_5
  { CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_1
  { CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_11
  { CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_11
  { CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_9
  { CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_9
  { CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_0
  { CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_0
  { CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_10
  { CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_10
  { CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_8
  { CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_8
  { CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__SibMem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__SibMem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SibMem5_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__SibMem5_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GR32orGR641_0
  { CVT_95_addGR32orGR64Operands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem2565_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5125_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addAVX512RCOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addAVX512RCOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem165_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem165_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem256_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem256_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem512_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem512_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_RC256X5_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem512_RC256X5_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem512_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem256_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem256_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem128_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem128_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem128_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem256_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem128_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem256_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem85_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem85_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem645_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK16Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Mem5125_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem1285_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem2565_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Mem1285_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Mem2565_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK16Pair1_2__Reg1_1__Mem5125_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK16Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK2Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Mem1285_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem2565_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem5125_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK2Pair1_2__Reg1_1__Mem1285_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Mem2565_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Mem5125_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK2Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem85_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addGR32orGR64Operands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Mem128_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem256_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem512_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem128_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem256_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem512_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem256_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem512_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem256_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem512_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem128_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem256_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem128_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem256_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_2_2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Tied, Tie0_2_2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__AbsMem161_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_Done },
  // Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1
  { CVT_regEAX, 0, CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
};

void X86AsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned OpIdx;
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<X86Operand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[OpIdx][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_95_addImmOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addMemOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMemOperands(Inst, 5);
      break;
    case CVT_95_Reg:
      static_cast<X86Operand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regAX:
      Inst.addOperand(MCOperand::createReg(X86::AX));
      break;
    case CVT_regEAX:
      Inst.addOperand(MCOperand::createReg(X86::EAX));
      break;
    case CVT_regRAX:
      Inst.addOperand(MCOperand::createReg(X86::RAX));
      break;
    case CVT_95_addAbsMemOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addAbsMemOperands(Inst, 1);
      break;
    case CVT_imm_95_7:
      Inst.addOperand(MCOperand::createImm(7));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_6:
      Inst.addOperand(MCOperand::createImm(6));
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_imm_95_13:
      Inst.addOperand(MCOperand::createImm(13));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_11:
      Inst.addOperand(MCOperand::createImm(11));
      break;
    case CVT_imm_95_9:
      Inst.addOperand(MCOperand::createImm(9));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_imm_95_8:
      Inst.addOperand(MCOperand::createImm(8));
      break;
    case CVT_95_addDstIdxOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addDstIdxOperands(Inst, 1);
      break;
    case CVT_95_addSrcIdxOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addSrcIdxOperands(Inst, 2);
      break;
    case CVT_95_addGR32orGR64Operands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addGR32orGR64Operands(Inst, 1);
      break;
    case CVT_regST1:
      Inst.addOperand(MCOperand::createReg(X86::ST1));
      break;
    case CVT_regST0:
      Inst.addOperand(MCOperand::createReg(X86::ST0));
      break;
    case CVT_95_addGR16orGR32orGR64Operands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addGR16orGR32orGR64Operands(Inst, 1);
      break;
    case CVT_95_addMemOffsOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMemOffsOperands(Inst, 2);
      break;
    case CVT_imm_95_17:
      Inst.addOperand(MCOperand::createImm(17));
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_95_addAVX512RCOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addAVX512RCOperands(Inst, 1);
      break;
    case CVT_95_addMaskPairOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMaskPairOperands(Inst, 1);
      break;
    }
  }
}

void X86AsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 5;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regEAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regRAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addAbsMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_6:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_13:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_11:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_9:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addDstIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSrcIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regST1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regST0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addGR16orGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOffsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_17:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addAVX512RCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMaskPairOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__STAR_, // '*'
  MCK__123_, // '{'
  MCK__123_1to16_125_, // '{1to16}'
  MCK__123_1to2_125_, // '{1to2}'
  MCK__123_1to32_125_, // '{1to32}'
  MCK__123_1to4_125_, // '{1to4}'
  MCK__123_1to8_125_, // '{1to8}'
  MCK__123_sae_125_, // '{sae}'
  MCK__123_z_125_, // '{z}'
  MCK__125_, // '}'
  MCK_LAST_TOKEN = MCK__125_,
  MCK_Reg82, // derived register class
  MCK_Reg81, // derived register class
  MCK_Reg79, // derived register class
  MCK_Reg76, // derived register class
  MCK_Reg74, // derived register class
  MCK_Reg72, // derived register class
  MCK_Reg38, // derived register class
  MCK_Reg36, // derived register class
  MCK_Reg34, // derived register class
  MCK_Reg32, // derived register class
  MCK_AL, // register class 'AL'
  MCK_AX, // register class 'AX'
  MCK_CCR, // register class 'CCR'
  MCK_CL, // register class 'CL'
  MCK_CS, // register class 'CS'
  MCK_DFCCR, // register class 'DFCCR'
  MCK_DS, // register class 'DS'
  MCK_DX, // register class 'DX'
  MCK_EAX, // register class 'EAX'
  MCK_EBX, // register class 'EBX'
  MCK_ECX, // register class 'ECX'
  MCK_EDX, // register class 'EDX'
  MCK_ES, // register class 'ES'
  MCK_FPCCR, // register class 'FPCCR'
  MCK_FS, // register class 'FS'
  MCK_GS, // register class 'GS'
  MCK_RAX, // register class 'RAX'
  MCK_RBX, // register class 'RBX'
  MCK_RCX, // register class 'RCX'
  MCK_RDX, // register class 'RDX'
  MCK_RFP80_7, // register class 'RFP80_7'
  MCK_SS, // register class 'SS'
  MCK_ST0, // register class 'ST0'
  MCK_XMM0, // register class 'XMM0'
  MCK_Reg78, // derived register class
  MCK_Reg77, // derived register class
  MCK_Reg75, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg71, // derived register class
  MCK_Reg69, // derived register class
  MCK_Reg67, // derived register class
  MCK_GR32_AD, // register class 'GR32_AD'
  MCK_GR32_ArgRef, // register class 'GR32_ArgRef,GR32_DC'
  MCK_GR32_BPSP, // register class 'GR32_BPSP'
  MCK_GR32_BSI, // register class 'GR32_BSI'
  MCK_GR32_CB, // register class 'GR32_CB'
  MCK_GR32_DIBP, // register class 'GR32_DIBP'
  MCK_GR32_SIDI, // register class 'GR32_SIDI'
  MCK_GR64_AD, // register class 'GR64_AD'
  MCK_GR64_ArgRef, // register class 'GR64_ArgRef'
  MCK_Reg111, // derived register class
  MCK_Reg41, // derived register class
  MCK_Reg15, // derived register class
  MCK_Reg57, // derived register class
  MCK_GR16_ABCD, // register class 'GR16_ABCD'
  MCK_GR32_ABCD, // register class 'GR32_ABCD'
  MCK_GR32_TC, // register class 'GR32_TC'
  MCK_GR64_ABCD, // register class 'GR64_ABCD'
  MCK_GR8_ABCD_H, // register class 'GR8_ABCD_H'
  MCK_GR8_ABCD_L, // register class 'GR8_ABCD_L'
  MCK_VK16PAIR, // register class 'VK16PAIR,VK1PAIR,VK2PAIR,VK4PAIR,VK8PAIR'
  MCK_Reg63, // derived register class
  MCK_Reg62, // derived register class
  MCK_Reg50, // derived register class
  MCK_Reg65, // derived register class
  MCK_Reg51, // derived register class
  MCK_SEGMENT_REG, // register class 'SEGMENT_REG'
  MCK_Reg64, // derived register class
  MCK_Reg60, // derived register class
  MCK_Reg55, // derived register class
  MCK_Reg54, // derived register class
  MCK_GR32_NOREX_NOSP, // register class 'GR32_NOREX_NOSP'
  MCK_GR64_NOREX_NOSP, // register class 'GR64_NOREX_NOSP'
  MCK_RFP32, // register class 'RFP32,RFP64,RFP80'
  MCK_VK16WM, // register class 'VK16WM,VK1WM,VK2WM,VK4WM,VK8WM,VK32WM,VK64WM'
  MCK_Reg61, // derived register class
  MCK_Reg58, // derived register class
  MCK_Reg56, // derived register class
  MCK_Reg44, // derived register class
  MCK_GR16_NOREX, // register class 'GR16_NOREX'
  MCK_GR32_NOREX, // register class 'GR32_NOREX'
  MCK_GR8_NOREX, // register class 'GR8_NOREX'
  MCK_RST, // register class 'RST'
  MCK_TILE, // register class 'TILE'
  MCK_VK1, // register class 'VK1,VK16,VK2,VK4,VK8,VK32,VK64'
  MCK_VR64, // register class 'VR64'
  MCK_Reg52, // derived register class
  MCK_Reg23, // derived register class
  MCK_GR64_NOREX, // register class 'GR64_NOREX'
  MCK_GR64_TCW64, // register class 'GR64_TCW64'
  MCK_GR64_TC, // register class 'GR64_TC'
  MCK_GRH8, // register class 'GRH8'
  MCK_GR64PLTSafe, // register class 'GR64PLTSafe'
  MCK_GR32_NOSP, // register class 'GR32_NOSP'
  MCK_GR64_NOSP, // register class 'GR64_NOSP'
  MCK_Reg45, // derived register class
  MCK_CONTROL_REG, // register class 'CONTROL_REG'
  MCK_DEBUG_REG, // register class 'DEBUG_REG'
  MCK_FR16, // register class 'FR16,FR32,FR64,VR128'
  MCK_GR16, // register class 'GR16'
  MCK_GR32, // register class 'GR32'
  MCK_VR256, // register class 'VR256'
  MCK_VR512_0_15, // register class 'VR512_0_15'
  MCK_Reg20, // derived register class
  MCK_GR64, // register class 'GR64'
  MCK_GRH16, // register class 'GRH16'
  MCK_LOW32_ADDR_ACCESS, // register class 'LOW32_ADDR_ACCESS'
  MCK_LOW32_ADDR_ACCESS_RBP, // register class 'LOW32_ADDR_ACCESS_RBP'
  MCK_GR8, // register class 'GR8'
  MCK_FR16X, // register class 'FR16X,FR32X,FR64X,VR128X'
  MCK_VR256X, // register class 'VR256X'
  MCK_VR512, // register class 'VR512'
  MCK_LAST_REGISTER = MCK_VR512,
  MCK_AVX512RC, // user defined class 'AVX512RCOperand'
  MCK_ImmSExti64i8, // user defined class 'ImmSExti64i8AsmOperand'
  MCK_ImmSExti16i8, // user defined class 'ImmSExti16i8AsmOperand'
  MCK_ImmSExti32i8, // user defined class 'ImmSExti32i8AsmOperand'
  MCK_ImmSExti64i32, // user defined class 'ImmSExti64i32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmUnsignedi4, // user defined class 'ImmUnsignedi4AsmOperand'
  MCK_ImmUnsignedi8, // user defined class 'ImmUnsignedi8AsmOperand'
  MCK_VK16Pair, // user defined class 'VK16PairAsmOperand'
  MCK_VK1Pair, // user defined class 'VK1PairAsmOperand'
  MCK_VK2Pair, // user defined class 'VK2PairAsmOperand'
  MCK_VK4Pair, // user defined class 'VK4PairAsmOperand'
  MCK_VK8Pair, // user defined class 'VK8PairAsmOperand'
  MCK_GR16orGR32orGR64, // user defined class 'X86GR16orGR32orGR64AsmOperand'
  MCK_GR32orGR64, // user defined class 'X86GR32orGR64AsmOperand'
  MCK_AbsMem16, // user defined class 'X86AbsMem16AsmOperand'
  MCK_DstIdx16, // user defined class 'X86DstIdx16Operand'
  MCK_DstIdx32, // user defined class 'X86DstIdx32Operand'
  MCK_DstIdx64, // user defined class 'X86DstIdx64Operand'
  MCK_DstIdx8, // user defined class 'X86DstIdx8Operand'
  MCK_MemOffs16_16, // user defined class 'X86MemOffs16_16AsmOperand'
  MCK_MemOffs16_32, // user defined class 'X86MemOffs16_32AsmOperand'
  MCK_MemOffs16_8, // user defined class 'X86MemOffs16_8AsmOperand'
  MCK_MemOffs32_16, // user defined class 'X86MemOffs32_16AsmOperand'
  MCK_MemOffs32_32, // user defined class 'X86MemOffs32_32AsmOperand'
  MCK_MemOffs32_64, // user defined class 'X86MemOffs32_64AsmOperand'
  MCK_MemOffs32_8, // user defined class 'X86MemOffs32_8AsmOperand'
  MCK_MemOffs64_16, // user defined class 'X86MemOffs64_16AsmOperand'
  MCK_MemOffs64_32, // user defined class 'X86MemOffs64_32AsmOperand'
  MCK_MemOffs64_64, // user defined class 'X86MemOffs64_64AsmOperand'
  MCK_MemOffs64_8, // user defined class 'X86MemOffs64_8AsmOperand'
  MCK_SrcIdx16, // user defined class 'X86SrcIdx16Operand'
  MCK_SrcIdx32, // user defined class 'X86SrcIdx32Operand'
  MCK_SrcIdx64, // user defined class 'X86SrcIdx64Operand'
  MCK_SrcIdx8, // user defined class 'X86SrcIdx8Operand'
  MCK_AbsMem, // user defined class 'X86AbsMemAsmOperand'
  MCK_Mem128, // user defined class 'X86Mem128AsmOperand'
  MCK_Mem128_RC128, // user defined class 'X86Mem128_RC128Operand'
  MCK_Mem128_RC128X, // user defined class 'X86Mem128_RC128XOperand'
  MCK_Mem128_RC256, // user defined class 'X86Mem128_RC256Operand'
  MCK_Mem128_RC256X, // user defined class 'X86Mem128_RC256XOperand'
  MCK_Mem16, // user defined class 'X86Mem16AsmOperand'
  MCK_Mem256, // user defined class 'X86Mem256AsmOperand'
  MCK_Mem256_RC128, // user defined class 'X86Mem256_RC128Operand'
  MCK_Mem256_RC128X, // user defined class 'X86Mem256_RC128XOperand'
  MCK_Mem256_RC256, // user defined class 'X86Mem256_RC256Operand'
  MCK_Mem256_RC256X, // user defined class 'X86Mem256_RC256XOperand'
  MCK_Mem256_RC512, // user defined class 'X86Mem256_RC512Operand'
  MCK_Mem32, // user defined class 'X86Mem32AsmOperand'
  MCK_Mem512, // user defined class 'X86Mem512AsmOperand'
  MCK_Mem512_GR16, // user defined class 'X86Mem512_GR16Operand'
  MCK_Mem512_GR32, // user defined class 'X86Mem512_GR32Operand'
  MCK_Mem512_GR64, // user defined class 'X86Mem512_GR64Operand'
  MCK_Mem512_RC256X, // user defined class 'X86Mem512_RC256XOperand'
  MCK_Mem512_RC512, // user defined class 'X86Mem512_RC512Operand'
  MCK_Mem64, // user defined class 'X86Mem64AsmOperand'
  MCK_Mem64_RC128, // user defined class 'X86Mem64_RC128Operand'
  MCK_Mem64_RC128X, // user defined class 'X86Mem64_RC128XOperand'
  MCK_Mem80, // user defined class 'X86Mem80AsmOperand'
  MCK_Mem8, // user defined class 'X86Mem8AsmOperand'
  MCK_SibMem, // user defined class 'X86SibMemOperand'
  MCK_Mem, // user defined class 'X86MemAsmOperand'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case '*':	 // 1 string to match.
      return MCK__STAR_;	 // "*"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 3:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{z}", 3) != 0)
      break;
    return MCK__123_z_125_;	 // "{z}"
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{sae}", 5) != 0)
      break;
    return MCK__123_sae_125_;	 // "{sae}"
  case 6:	 // 3 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case '2':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to2_125_;	 // "{1to2}"
    case '4':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to4_125_;	 // "{1to4}"
    case '8':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to8_125_;	 // "{1to8}"
    }
    break;
  case 7:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case '1':	 // 1 string to match.
      if (memcmp(Name.data()+5, "6}", 2) != 0)
        break;
      return MCK__123_1to16_125_;	 // "{1to16}"
    case '3':	 // 1 string to match.
      if (memcmp(Name.data()+5, "2}", 2) != 0)
        break;
      return MCK__123_1to32_125_;	 // "{1to32}"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_Reg82:
    switch (B) {
    default: return false;
    case MCK_Reg78: return true;
    case MCK_Reg62: return true;
    case MCK_Reg54: return true;
    case MCK_Reg61: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg81:
    switch (B) {
    default: return false;
    case MCK_GR64_ArgRef: return true;
    case MCK_Reg65: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg79:
    switch (B) {
    default: return false;
    case MCK_Reg77: return true;
    case MCK_Reg57: return true;
    case MCK_Reg62: return true;
    case MCK_Reg51: return true;
    case MCK_Reg60: return true;
    case MCK_Reg54: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg76:
    switch (B) {
    default: return false;
    case MCK_Reg78: return true;
    case MCK_Reg77: return true;
    case MCK_Reg75: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_Reg23: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_Reg20: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg74:
    switch (B) {
    default: return false;
    case MCK_Reg75: return true;
    case MCK_Reg73: return true;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg72:
    switch (B) {
    default: return false;
    case MCK_Reg73: return true;
    case MCK_Reg71: return true;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_GR32_BPSP: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg36:
    switch (B) {
    default: return false;
    case MCK_GR32_BPSP: return true;
    case MCK_GR32_DIBP: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg34:
    switch (B) {
    default: return false;
    case MCK_GR32_DIBP: return true;
    case MCK_GR32_SIDI: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg32:
    switch (B) {
    default: return false;
    case MCK_GR32_BSI: return true;
    case MCK_GR32_SIDI: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_AL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_AX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_CL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_CS:
    return B == MCK_SEGMENT_REG;

  case MCK_DS:
    return B == MCK_SEGMENT_REG;

  case MCK_DX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_EAX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_Reg15: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_EBX:
    switch (B) {
    default: return false;
    case MCK_GR32_BSI: return true;
    case MCK_GR32_CB: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_ECX:
    switch (B) {
    default: return false;
    case MCK_GR32_ArgRef: return true;
    case MCK_GR32_CB: return true;
    case MCK_Reg15: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_EDX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_GR32_ArgRef: return true;
    case MCK_Reg15: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_ES:
    return B == MCK_SEGMENT_REG;

  case MCK_FS:
    return B == MCK_SEGMENT_REG;

  case MCK_GS:
    return B == MCK_SEGMENT_REG;

  case MCK_RAX:
    switch (B) {
    default: return false;
    case MCK_GR64_AD: return true;
    case MCK_Reg41: return true;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_RBX:
    switch (B) {
    default: return false;
    case MCK_Reg71: return true;
    case MCK_Reg69: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_RCX:
    switch (B) {
    default: return false;
    case MCK_Reg69: return true;
    case MCK_Reg67: return true;
    case MCK_Reg41: return true;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_RDX:
    switch (B) {
    default: return false;
    case MCK_Reg67: return true;
    case MCK_GR64_AD: return true;
    case MCK_Reg41: return true;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_SS:
    return B == MCK_SEGMENT_REG;

  case MCK_ST0:
    return B == MCK_RST;

  case MCK_XMM0:
    switch (B) {
    default: return false;
    case MCK_FR16: return true;
    case MCK_FR16X: return true;
    }

  case MCK_Reg78:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg77:
    switch (B) {
    default: return false;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg75:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg73:
    switch (B) {
    default: return false;
    case MCK_Reg50: return true;
    case MCK_Reg51: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg71:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg69:
    switch (B) {
    default: return false;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg67:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR32_AD:
    switch (B) {
    default: return false;
    case MCK_Reg15: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_ArgRef:
    switch (B) {
    default: return false;
    case MCK_Reg15: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_BPSP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_BSI:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_CB:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_DIBP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_SIDI:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_AD:
    switch (B) {
    default: return false;
    case MCK_Reg41: return true;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_ArgRef:
    switch (B) {
    default: return false;
    case MCK_Reg64: return true;
    case MCK_Reg58: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg111:
    return B == MCK_VK16PAIR;

  case MCK_Reg41:
    switch (B) {
    default: return false;
    case MCK_Reg57: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_Reg63: return true;
    case MCK_Reg62: return true;
    case MCK_Reg50: return true;
    case MCK_Reg65: return true;
    case MCK_Reg51: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg15:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_Reg57:
    switch (B) {
    default: return false;
    case MCK_Reg62: return true;
    case MCK_Reg51: return true;
    case MCK_Reg60: return true;
    case MCK_Reg54: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR16_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR32_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR32_TC:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR8_ABCD_H:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_L:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_Reg63:
    switch (B) {
    default: return false;
    case MCK_Reg65: return true;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg55: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg62:
    switch (B) {
    default: return false;
    case MCK_Reg54: return true;
    case MCK_Reg61: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg50:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_Reg55: return true;
    case MCK_Reg54: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg56: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg65:
    switch (B) {
    default: return false;
    case MCK_Reg64: return true;
    case MCK_Reg60: return true;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg56: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg51:
    switch (B) {
    default: return false;
    case MCK_Reg54: return true;
    case MCK_Reg44: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg64:
    switch (B) {
    default: return false;
    case MCK_Reg58: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg60:
    switch (B) {
    default: return false;
    case MCK_Reg61: return true;
    case MCK_Reg58: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg55:
    switch (B) {
    default: return false;
    case MCK_Reg56: return true;
    case MCK_Reg52: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg54:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR32_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_Reg23: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg44: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64PLTSafe: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_VK16WM:
    return B == MCK_VK1;

  case MCK_Reg61:
    switch (B) {
    default: return false;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg58:
    switch (B) {
    default: return false;
    case MCK_GR64_TCW64: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg56:
    switch (B) {
    default: return false;
    case MCK_Reg52: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg44:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR16_NOREX:
    return B == MCK_GR16;

  case MCK_GR32_NOREX:
    switch (B) {
    default: return false;
    case MCK_Reg23: return true;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR8_NOREX:
    return B == MCK_GR8;

  case MCK_Reg52:
    switch (B) {
    default: return false;
    case MCK_GR64_TC: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg23:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOREX:
    return B == MCK_GR64;

  case MCK_GR64_TCW64:
    return B == MCK_GR64;

  case MCK_GR64_TC:
    return B == MCK_GR64;

  case MCK_GR64PLTSafe:
    switch (B) {
    default: return false;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR32_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32: return true;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_GR64_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg45: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg45:
    return B == MCK_GR64;

  case MCK_FR16:
    return B == MCK_FR16X;

  case MCK_GR32:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_LOW32_ADDR_ACCESS: return true;
    case MCK_LOW32_ADDR_ACCESS_RBP: return true;
    }

  case MCK_VR256:
    return B == MCK_VR256X;

  case MCK_VR512_0_15:
    return B == MCK_VR512;

  case MCK_Reg20:
    return B == MCK_LOW32_ADDR_ACCESS_RBP;

  case MCK_LOW32_ADDR_ACCESS:
    return B == MCK_LOW32_ADDR_ACCESS_RBP;

  case MCK_ImmSExti64i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti16i8: return true;
    case MCK_ImmSExti32i8: return true;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti16i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti32i8:
    return B == MCK_Imm;

  case MCK_ImmSExti64i32:
    return B == MCK_Imm;

  case MCK_AbsMem16:
    switch (B) {
    default: return false;
    case MCK_AbsMem: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_DstIdx8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs16_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs32_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_MemOffs64_8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx16:
    switch (B) {
    default: return false;
    case MCK_Mem16: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx32:
    switch (B) {
    default: return false;
    case MCK_Mem32: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx64:
    switch (B) {
    default: return false;
    case MCK_Mem64: return true;
    case MCK_Mem: return true;
    }

  case MCK_SrcIdx8:
    switch (B) {
    default: return false;
    case MCK_Mem8: return true;
    case MCK_Mem: return true;
    }

  case MCK_AbsMem:
    return B == MCK_Mem;

  case MCK_Mem128:
    return B == MCK_Mem;

  case MCK_Mem128_RC128:
    return B == MCK_Mem;

  case MCK_Mem128_RC128X:
    return B == MCK_Mem;

  case MCK_Mem128_RC256:
    return B == MCK_Mem;

  case MCK_Mem128_RC256X:
    return B == MCK_Mem;

  case MCK_Mem16:
    return B == MCK_Mem;

  case MCK_Mem256:
    return B == MCK_Mem;

  case MCK_Mem256_RC128:
    return B == MCK_Mem;

  case MCK_Mem256_RC128X:
    return B == MCK_Mem;

  case MCK_Mem256_RC256:
    return B == MCK_Mem;

  case MCK_Mem256_RC256X:
    return B == MCK_Mem;

  case MCK_Mem256_RC512:
    return B == MCK_Mem;

  case MCK_Mem32:
    return B == MCK_Mem;

  case MCK_Mem512:
    return B == MCK_Mem;

  case MCK_Mem512_GR16:
    return B == MCK_Mem;

  case MCK_Mem512_GR32:
    return B == MCK_Mem;

  case MCK_Mem512_GR64:
    return B == MCK_Mem;

  case MCK_Mem512_RC256X:
    return B == MCK_Mem;

  case MCK_Mem512_RC512:
    return B == MCK_Mem;

  case MCK_Mem64:
    return B == MCK_Mem;

  case MCK_Mem64_RC128:
    return B == MCK_Mem;

  case MCK_Mem64_RC128X:
    return B == MCK_Mem;

  case MCK_Mem80:
    return B == MCK_Mem;

  case MCK_Mem8:
    return B == MCK_Mem;

  case MCK_SibMem:
    return B == MCK_Mem;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  X86Operand &Operand = (X86Operand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AVX512RC' class
  case MCK_AVX512RC: {
    DiagnosticPredicate DP(Operand.isAVX512RC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti64i8' class
  case MCK_ImmSExti64i8: {
    DiagnosticPredicate DP(Operand.isImmSExti64i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti16i8' class
  case MCK_ImmSExti16i8: {
    DiagnosticPredicate DP(Operand.isImmSExti16i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti32i8' class
  case MCK_ImmSExti32i8: {
    DiagnosticPredicate DP(Operand.isImmSExti32i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmSExti64i32' class
  case MCK_ImmSExti64i32: {
    DiagnosticPredicate DP(Operand.isImmSExti64i32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmUnsignedi4' class
  case MCK_ImmUnsignedi4: {
    DiagnosticPredicate DP(Operand.isImmUnsignedi4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return X86AsmParser::Match_InvalidImmUnsignedi4;
    break;
    }
  // 'ImmUnsignedi8' class
  case MCK_ImmUnsignedi8: {
    DiagnosticPredicate DP(Operand.isImmUnsignedi8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VK16Pair' class
  case MCK_VK16Pair: {
    DiagnosticPredicate DP(Operand.isVK16Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VK1Pair' class
  case MCK_VK1Pair: {
    DiagnosticPredicate DP(Operand.isVK1Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VK2Pair' class
  case MCK_VK2Pair: {
    DiagnosticPredicate DP(Operand.isVK2Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VK4Pair' class
  case MCK_VK4Pair: {
    DiagnosticPredicate DP(Operand.isVK4Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'VK8Pair' class
  case MCK_VK8Pair: {
    DiagnosticPredicate DP(Operand.isVK8Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GR16orGR32orGR64' class
  case MCK_GR16orGR32orGR64: {
    DiagnosticPredicate DP(Operand.isGR16orGR32orGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GR32orGR64' class
  case MCK_GR32orGR64: {
    DiagnosticPredicate DP(Operand.isGR32orGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AbsMem16' class
  case MCK_AbsMem16: {
    DiagnosticPredicate DP(Operand.isAbsMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx16' class
  case MCK_DstIdx16: {
    DiagnosticPredicate DP(Operand.isDstIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx32' class
  case MCK_DstIdx32: {
    DiagnosticPredicate DP(Operand.isDstIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx64' class
  case MCK_DstIdx64: {
    DiagnosticPredicate DP(Operand.isDstIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'DstIdx8' class
  case MCK_DstIdx8: {
    DiagnosticPredicate DP(Operand.isDstIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_16' class
  case MCK_MemOffs16_16: {
    DiagnosticPredicate DP(Operand.isMemOffs16_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_32' class
  case MCK_MemOffs16_32: {
    DiagnosticPredicate DP(Operand.isMemOffs16_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs16_8' class
  case MCK_MemOffs16_8: {
    DiagnosticPredicate DP(Operand.isMemOffs16_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_16' class
  case MCK_MemOffs32_16: {
    DiagnosticPredicate DP(Operand.isMemOffs32_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_32' class
  case MCK_MemOffs32_32: {
    DiagnosticPredicate DP(Operand.isMemOffs32_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_64' class
  case MCK_MemOffs32_64: {
    DiagnosticPredicate DP(Operand.isMemOffs32_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs32_8' class
  case MCK_MemOffs32_8: {
    DiagnosticPredicate DP(Operand.isMemOffs32_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_16' class
  case MCK_MemOffs64_16: {
    DiagnosticPredicate DP(Operand.isMemOffs64_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_32' class
  case MCK_MemOffs64_32: {
    DiagnosticPredicate DP(Operand.isMemOffs64_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_64' class
  case MCK_MemOffs64_64: {
    DiagnosticPredicate DP(Operand.isMemOffs64_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'MemOffs64_8' class
  case MCK_MemOffs64_8: {
    DiagnosticPredicate DP(Operand.isMemOffs64_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx16' class
  case MCK_SrcIdx16: {
    DiagnosticPredicate DP(Operand.isSrcIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx32' class
  case MCK_SrcIdx32: {
    DiagnosticPredicate DP(Operand.isSrcIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx64' class
  case MCK_SrcIdx64: {
    DiagnosticPredicate DP(Operand.isSrcIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SrcIdx8' class
  case MCK_SrcIdx8: {
    DiagnosticPredicate DP(Operand.isSrcIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AbsMem' class
  case MCK_AbsMem: {
    DiagnosticPredicate DP(Operand.isAbsMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128' class
  case MCK_Mem128: {
    DiagnosticPredicate DP(Operand.isMem128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC128' class
  case MCK_Mem128_RC128: {
    DiagnosticPredicate DP(Operand.isMem128_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC128X' class
  case MCK_Mem128_RC128X: {
    DiagnosticPredicate DP(Operand.isMem128_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC256' class
  case MCK_Mem128_RC256: {
    DiagnosticPredicate DP(Operand.isMem128_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem128_RC256X' class
  case MCK_Mem128_RC256X: {
    DiagnosticPredicate DP(Operand.isMem128_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem16' class
  case MCK_Mem16: {
    DiagnosticPredicate DP(Operand.isMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256' class
  case MCK_Mem256: {
    DiagnosticPredicate DP(Operand.isMem256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC128' class
  case MCK_Mem256_RC128: {
    DiagnosticPredicate DP(Operand.isMem256_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC128X' class
  case MCK_Mem256_RC128X: {
    DiagnosticPredicate DP(Operand.isMem256_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC256' class
  case MCK_Mem256_RC256: {
    DiagnosticPredicate DP(Operand.isMem256_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC256X' class
  case MCK_Mem256_RC256X: {
    DiagnosticPredicate DP(Operand.isMem256_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem256_RC512' class
  case MCK_Mem256_RC512: {
    DiagnosticPredicate DP(Operand.isMem256_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem32' class
  case MCK_Mem32: {
    DiagnosticPredicate DP(Operand.isMem32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512' class
  case MCK_Mem512: {
    DiagnosticPredicate DP(Operand.isMem512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_GR16' class
  case MCK_Mem512_GR16: {
    DiagnosticPredicate DP(Operand.isMem512_GR16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_GR32' class
  case MCK_Mem512_GR32: {
    DiagnosticPredicate DP(Operand.isMem512_GR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_GR64' class
  case MCK_Mem512_GR64: {
    DiagnosticPredicate DP(Operand.isMem512_GR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_RC256X' class
  case MCK_Mem512_RC256X: {
    DiagnosticPredicate DP(Operand.isMem512_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem512_RC512' class
  case MCK_Mem512_RC512: {
    DiagnosticPredicate DP(Operand.isMem512_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64' class
  case MCK_Mem64: {
    DiagnosticPredicate DP(Operand.isMem64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64_RC128' class
  case MCK_Mem64_RC128: {
    DiagnosticPredicate DP(Operand.isMem64_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem64_RC128X' class
  case MCK_Mem64_RC128X: {
    DiagnosticPredicate DP(Operand.isMem64_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem80' class
  case MCK_Mem80: {
    DiagnosticPredicate DP(Operand.isMem80());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem8' class
  case MCK_Mem8: {
    DiagnosticPredicate DP(Operand.isMem8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SibMem' class
  case MCK_SibMem: {
    DiagnosticPredicate DP(Operand.isSibMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Mem' class
  case MCK_Mem: {
    DiagnosticPredicate DP(Operand.isMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case X86::AL: OpKind = MCK_AL; break;
    case X86::DL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::CL: OpKind = MCK_CL; break;
    case X86::BL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::AH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::DH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::CH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::BH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::SIL: OpKind = MCK_GR8; break;
    case X86::DIL: OpKind = MCK_GR8; break;
    case X86::BPL: OpKind = MCK_GR8; break;
    case X86::SPL: OpKind = MCK_GR8; break;
    case X86::R8B: OpKind = MCK_GR8; break;
    case X86::R9B: OpKind = MCK_GR8; break;
    case X86::R10B: OpKind = MCK_GR8; break;
    case X86::R11B: OpKind = MCK_GR8; break;
    case X86::R12B: OpKind = MCK_GR8; break;
    case X86::R13B: OpKind = MCK_GR8; break;
    case X86::R14B: OpKind = MCK_GR8; break;
    case X86::R15B: OpKind = MCK_GR8; break;
    case X86::SIH: OpKind = MCK_GRH8; break;
    case X86::DIH: OpKind = MCK_GRH8; break;
    case X86::BPH: OpKind = MCK_GRH8; break;
    case X86::SPH: OpKind = MCK_GRH8; break;
    case X86::R8BH: OpKind = MCK_GRH8; break;
    case X86::R9BH: OpKind = MCK_GRH8; break;
    case X86::R10BH: OpKind = MCK_GRH8; break;
    case X86::R11BH: OpKind = MCK_GRH8; break;
    case X86::R12BH: OpKind = MCK_GRH8; break;
    case X86::R13BH: OpKind = MCK_GRH8; break;
    case X86::R14BH: OpKind = MCK_GRH8; break;
    case X86::R15BH: OpKind = MCK_GRH8; break;
    case X86::HAX: OpKind = MCK_GRH16; break;
    case X86::HDX: OpKind = MCK_GRH16; break;
    case X86::HCX: OpKind = MCK_GRH16; break;
    case X86::HBX: OpKind = MCK_GRH16; break;
    case X86::HSI: OpKind = MCK_GRH16; break;
    case X86::HDI: OpKind = MCK_GRH16; break;
    case X86::HBP: OpKind = MCK_GRH16; break;
    case X86::HSP: OpKind = MCK_GRH16; break;
    case X86::HIP: OpKind = MCK_GRH16; break;
    case X86::R8WH: OpKind = MCK_GRH16; break;
    case X86::R9WH: OpKind = MCK_GRH16; break;
    case X86::R10WH: OpKind = MCK_GRH16; break;
    case X86::R11WH: OpKind = MCK_GRH16; break;
    case X86::R12WH: OpKind = MCK_GRH16; break;
    case X86::R13WH: OpKind = MCK_GRH16; break;
    case X86::R14WH: OpKind = MCK_GRH16; break;
    case X86::R15WH: OpKind = MCK_GRH16; break;
    case X86::AX: OpKind = MCK_AX; break;
    case X86::DX: OpKind = MCK_DX; break;
    case X86::CX: OpKind = MCK_GR16_ABCD; break;
    case X86::BX: OpKind = MCK_GR16_ABCD; break;
    case X86::SI: OpKind = MCK_GR16_NOREX; break;
    case X86::DI: OpKind = MCK_GR16_NOREX; break;
    case X86::BP: OpKind = MCK_GR16_NOREX; break;
    case X86::SP: OpKind = MCK_GR16_NOREX; break;
    case X86::R8W: OpKind = MCK_GR16; break;
    case X86::R9W: OpKind = MCK_GR16; break;
    case X86::R10W: OpKind = MCK_GR16; break;
    case X86::R11W: OpKind = MCK_GR16; break;
    case X86::R12W: OpKind = MCK_GR16; break;
    case X86::R13W: OpKind = MCK_GR16; break;
    case X86::R14W: OpKind = MCK_GR16; break;
    case X86::R15W: OpKind = MCK_GR16; break;
    case X86::EAX: OpKind = MCK_EAX; break;
    case X86::EDX: OpKind = MCK_EDX; break;
    case X86::ECX: OpKind = MCK_ECX; break;
    case X86::EBX: OpKind = MCK_EBX; break;
    case X86::ESI: OpKind = MCK_Reg32; break;
    case X86::EDI: OpKind = MCK_Reg34; break;
    case X86::EBP: OpKind = MCK_Reg36; break;
    case X86::ESP: OpKind = MCK_Reg38; break;
    case X86::R8D: OpKind = MCK_GR32_NOSP; break;
    case X86::R9D: OpKind = MCK_GR32_NOSP; break;
    case X86::R10D: OpKind = MCK_GR32_NOSP; break;
    case X86::R11D: OpKind = MCK_GR32_NOSP; break;
    case X86::R12D: OpKind = MCK_GR32_NOSP; break;
    case X86::R13D: OpKind = MCK_GR32_NOSP; break;
    case X86::R14D: OpKind = MCK_GR32_NOSP; break;
    case X86::R15D: OpKind = MCK_GR32_NOSP; break;
    case X86::RAX: OpKind = MCK_RAX; break;
    case X86::RDX: OpKind = MCK_RDX; break;
    case X86::RCX: OpKind = MCK_RCX; break;
    case X86::RBX: OpKind = MCK_RBX; break;
    case X86::RSI: OpKind = MCK_Reg72; break;
    case X86::RDI: OpKind = MCK_Reg74; break;
    case X86::RBP: OpKind = MCK_Reg76; break;
    case X86::RSP: OpKind = MCK_Reg79; break;
    case X86::R8: OpKind = MCK_Reg63; break;
    case X86::R9: OpKind = MCK_Reg63; break;
    case X86::R10: OpKind = MCK_GR64_ArgRef; break;
    case X86::R11: OpKind = MCK_Reg81; break;
    case X86::R12: OpKind = MCK_GR64PLTSafe; break;
    case X86::R13: OpKind = MCK_GR64PLTSafe; break;
    case X86::R14: OpKind = MCK_GR64PLTSafe; break;
    case X86::R15: OpKind = MCK_GR64PLTSafe; break;
    case X86::RIP: OpKind = MCK_Reg82; break;
    case X86::MM0: OpKind = MCK_VR64; break;
    case X86::MM1: OpKind = MCK_VR64; break;
    case X86::MM2: OpKind = MCK_VR64; break;
    case X86::MM3: OpKind = MCK_VR64; break;
    case X86::MM4: OpKind = MCK_VR64; break;
    case X86::MM5: OpKind = MCK_VR64; break;
    case X86::MM6: OpKind = MCK_VR64; break;
    case X86::MM7: OpKind = MCK_VR64; break;
    case X86::FP0: OpKind = MCK_RFP32; break;
    case X86::FP1: OpKind = MCK_RFP32; break;
    case X86::FP2: OpKind = MCK_RFP32; break;
    case X86::FP3: OpKind = MCK_RFP32; break;
    case X86::FP4: OpKind = MCK_RFP32; break;
    case X86::FP5: OpKind = MCK_RFP32; break;
    case X86::FP6: OpKind = MCK_RFP32; break;
    case X86::FP7: OpKind = MCK_RFP80_7; break;
    case X86::XMM0: OpKind = MCK_XMM0; break;
    case X86::XMM1: OpKind = MCK_FR16; break;
    case X86::XMM2: OpKind = MCK_FR16; break;
    case X86::XMM3: OpKind = MCK_FR16; break;
    case X86::XMM4: OpKind = MCK_FR16; break;
    case X86::XMM5: OpKind = MCK_FR16; break;
    case X86::XMM6: OpKind = MCK_FR16; break;
    case X86::XMM7: OpKind = MCK_FR16; break;
    case X86::XMM8: OpKind = MCK_FR16; break;
    case X86::XMM9: OpKind = MCK_FR16; break;
    case X86::XMM10: OpKind = MCK_FR16; break;
    case X86::XMM11: OpKind = MCK_FR16; break;
    case X86::XMM12: OpKind = MCK_FR16; break;
    case X86::XMM13: OpKind = MCK_FR16; break;
    case X86::XMM14: OpKind = MCK_FR16; break;
    case X86::XMM15: OpKind = MCK_FR16; break;
    case X86::XMM16: OpKind = MCK_FR16X; break;
    case X86::XMM17: OpKind = MCK_FR16X; break;
    case X86::XMM18: OpKind = MCK_FR16X; break;
    case X86::XMM19: OpKind = MCK_FR16X; break;
    case X86::XMM20: OpKind = MCK_FR16X; break;
    case X86::XMM21: OpKind = MCK_FR16X; break;
    case X86::XMM22: OpKind = MCK_FR16X; break;
    case X86::XMM23: OpKind = MCK_FR16X; break;
    case X86::XMM24: OpKind = MCK_FR16X; break;
    case X86::XMM25: OpKind = MCK_FR16X; break;
    case X86::XMM26: OpKind = MCK_FR16X; break;
    case X86::XMM27: OpKind = MCK_FR16X; break;
    case X86::XMM28: OpKind = MCK_FR16X; break;
    case X86::XMM29: OpKind = MCK_FR16X; break;
    case X86::XMM30: OpKind = MCK_FR16X; break;
    case X86::XMM31: OpKind = MCK_FR16X; break;
    case X86::YMM0: OpKind = MCK_VR256; break;
    case X86::YMM1: OpKind = MCK_VR256; break;
    case X86::YMM2: OpKind = MCK_VR256; break;
    case X86::YMM3: OpKind = MCK_VR256; break;
    case X86::YMM4: OpKind = MCK_VR256; break;
    case X86::YMM5: OpKind = MCK_VR256; break;
    case X86::YMM6: OpKind = MCK_VR256; break;
    case X86::YMM7: OpKind = MCK_VR256; break;
    case X86::YMM8: OpKind = MCK_VR256; break;
    case X86::YMM9: OpKind = MCK_VR256; break;
    case X86::YMM10: OpKind = MCK_VR256; break;
    case X86::YMM11: OpKind = MCK_VR256; break;
    case X86::YMM12: OpKind = MCK_VR256; break;
    case X86::YMM13: OpKind = MCK_VR256; break;
    case X86::YMM14: OpKind = MCK_VR256; break;
    case X86::YMM15: OpKind = MCK_VR256; break;
    case X86::YMM16: OpKind = MCK_VR256X; break;
    case X86::YMM17: OpKind = MCK_VR256X; break;
    case X86::YMM18: OpKind = MCK_VR256X; break;
    case X86::YMM19: OpKind = MCK_VR256X; break;
    case X86::YMM20: OpKind = MCK_VR256X; break;
    case X86::YMM21: OpKind = MCK_VR256X; break;
    case X86::YMM22: OpKind = MCK_VR256X; break;
    case X86::YMM23: OpKind = MCK_VR256X; break;
    case X86::YMM24: OpKind = MCK_VR256X; break;
    case X86::YMM25: OpKind = MCK_VR256X; break;
    case X86::YMM26: OpKind = MCK_VR256X; break;
    case X86::YMM27: OpKind = MCK_VR256X; break;
    case X86::YMM28: OpKind = MCK_VR256X; break;
    case X86::YMM29: OpKind = MCK_VR256X; break;
    case X86::YMM30: OpKind = MCK_VR256X; break;
    case X86::YMM31: OpKind = MCK_VR256X; break;
    case X86::ZMM0: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM1: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM2: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM3: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM4: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM5: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM6: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM7: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM8: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM9: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM10: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM11: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM12: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM13: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM14: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM15: OpKind = MCK_VR512_0_15; break;
    case X86::ZMM16: OpKind = MCK_VR512; break;
    case X86::ZMM17: OpKind = MCK_VR512; break;
    case X86::ZMM18: OpKind = MCK_VR512; break;
    case X86::ZMM19: OpKind = MCK_VR512; break;
    case X86::ZMM20: OpKind = MCK_VR512; break;
    case X86::ZMM21: OpKind = MCK_VR512; break;
    case X86::ZMM22: OpKind = MCK_VR512; break;
    case X86::ZMM23: OpKind = MCK_VR512; break;
    case X86::ZMM24: OpKind = MCK_VR512; break;
    case X86::ZMM25: OpKind = MCK_VR512; break;
    case X86::ZMM26: OpKind = MCK_VR512; break;
    case X86::ZMM27: OpKind = MCK_VR512; break;
    case X86::ZMM28: OpKind = MCK_VR512; break;
    case X86::ZMM29: OpKind = MCK_VR512; break;
    case X86::ZMM30: OpKind = MCK_VR512; break;
    case X86::ZMM31: OpKind = MCK_VR512; break;
    case X86::TMM0: OpKind = MCK_TILE; break;
    case X86::TMM1: OpKind = MCK_TILE; break;
    case X86::TMM2: OpKind = MCK_TILE; break;
    case X86::TMM3: OpKind = MCK_TILE; break;
    case X86::TMM4: OpKind = MCK_TILE; break;
    case X86::TMM5: OpKind = MCK_TILE; break;
    case X86::TMM6: OpKind = MCK_TILE; break;
    case X86::TMM7: OpKind = MCK_TILE; break;
    case X86::K0: OpKind = MCK_VK1; break;
    case X86::K1: OpKind = MCK_VK16WM; break;
    case X86::K2: OpKind = MCK_VK16WM; break;
    case X86::K3: OpKind = MCK_VK16WM; break;
    case X86::K4: OpKind = MCK_VK16WM; break;
    case X86::K5: OpKind = MCK_VK16WM; break;
    case X86::K6: OpKind = MCK_VK16WM; break;
    case X86::K7: OpKind = MCK_VK16WM; break;
    case X86::ST0: OpKind = MCK_ST0; break;
    case X86::ST1: OpKind = MCK_RST; break;
    case X86::ST2: OpKind = MCK_RST; break;
    case X86::ST3: OpKind = MCK_RST; break;
    case X86::ST4: OpKind = MCK_RST; break;
    case X86::ST5: OpKind = MCK_RST; break;
    case X86::ST6: OpKind = MCK_RST; break;
    case X86::ST7: OpKind = MCK_RST; break;
    case X86::FPSW: OpKind = MCK_FPCCR; break;
    case X86::EFLAGS: OpKind = MCK_CCR; break;
    case X86::DF: OpKind = MCK_DFCCR; break;
    case X86::CS: OpKind = MCK_CS; break;
    case X86::DS: OpKind = MCK_DS; break;
    case X86::SS: OpKind = MCK_SS; break;
    case X86::ES: OpKind = MCK_ES; break;
    case X86::FS: OpKind = MCK_FS; break;
    case X86::GS: OpKind = MCK_GS; break;
    case X86::DR0: OpKind = MCK_DEBUG_REG; break;
    case X86::DR1: OpKind = MCK_DEBUG_REG; break;
    case X86::DR2: OpKind = MCK_DEBUG_REG; break;
    case X86::DR3: OpKind = MCK_DEBUG_REG; break;
    case X86::DR4: OpKind = MCK_DEBUG_REG; break;
    case X86::DR5: OpKind = MCK_DEBUG_REG; break;
    case X86::DR6: OpKind = MCK_DEBUG_REG; break;
    case X86::DR7: OpKind = MCK_DEBUG_REG; break;
    case X86::DR8: OpKind = MCK_DEBUG_REG; break;
    case X86::DR9: OpKind = MCK_DEBUG_REG; break;
    case X86::DR10: OpKind = MCK_DEBUG_REG; break;
    case X86::DR11: OpKind = MCK_DEBUG_REG; break;
    case X86::DR12: OpKind = MCK_DEBUG_REG; break;
    case X86::DR13: OpKind = MCK_DEBUG_REG; break;
    case X86::DR14: OpKind = MCK_DEBUG_REG; break;
    case X86::DR15: OpKind = MCK_DEBUG_REG; break;
    case X86::CR0: OpKind = MCK_CONTROL_REG; break;
    case X86::CR1: OpKind = MCK_CONTROL_REG; break;
    case X86::CR2: OpKind = MCK_CONTROL_REG; break;
    case X86::CR3: OpKind = MCK_CONTROL_REG; break;
    case X86::CR4: OpKind = MCK_CONTROL_REG; break;
    case X86::CR5: OpKind = MCK_CONTROL_REG; break;
    case X86::CR6: OpKind = MCK_CONTROL_REG; break;
    case X86::CR7: OpKind = MCK_CONTROL_REG; break;
    case X86::CR8: OpKind = MCK_CONTROL_REG; break;
    case X86::CR9: OpKind = MCK_CONTROL_REG; break;
    case X86::CR10: OpKind = MCK_CONTROL_REG; break;
    case X86::CR11: OpKind = MCK_CONTROL_REG; break;
    case X86::CR12: OpKind = MCK_CONTROL_REG; break;
    case X86::CR13: OpKind = MCK_CONTROL_REG; break;
    case X86::CR14: OpKind = MCK_CONTROL_REG; break;
    case X86::CR15: OpKind = MCK_CONTROL_REG; break;
    case X86::K0_K1: OpKind = MCK_VK16PAIR; break;
    case X86::K2_K3: OpKind = MCK_Reg111; break;
    case X86::K4_K5: OpKind = MCK_Reg111; break;
    case X86::K6_K7: OpKind = MCK_Reg111; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__STAR_: return "MCK__STAR_";
  case MCK__123_: return "MCK__123_";
  case MCK__123_1to16_125_: return "MCK__123_1to16_125_";
  case MCK__123_1to2_125_: return "MCK__123_1to2_125_";
  case MCK__123_1to32_125_: return "MCK__123_1to32_125_";
  case MCK__123_1to4_125_: return "MCK__123_1to4_125_";
  case MCK__123_1to8_125_: return "MCK__123_1to8_125_";
  case MCK__123_sae_125_: return "MCK__123_sae_125_";
  case MCK__123_z_125_: return "MCK__123_z_125_";
  case MCK__125_: return "MCK__125_";
  case MCK_Reg82: return "MCK_Reg82";
  case MCK_Reg81: return "MCK_Reg81";
  case MCK_Reg79: return "MCK_Reg79";
  case MCK_Reg76: return "MCK_Reg76";
  case MCK_Reg74: return "MCK_Reg74";
  case MCK_Reg72: return "MCK_Reg72";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_Reg36: return "MCK_Reg36";
  case MCK_Reg34: return "MCK_Reg34";
  case MCK_Reg32: return "MCK_Reg32";
  case MCK_AL: return "MCK_AL";
  case MCK_AX: return "MCK_AX";
  case MCK_CCR: return "MCK_CCR";
  case MCK_CL: return "MCK_CL";
  case MCK_CS: return "MCK_CS";
  case MCK_DFCCR: return "MCK_DFCCR";
  case MCK_DS: return "MCK_DS";
  case MCK_DX: return "MCK_DX";
  case MCK_EAX: return "MCK_EAX";
  case MCK_EBX: return "MCK_EBX";
  case MCK_ECX: return "MCK_ECX";
  case MCK_EDX: return "MCK_EDX";
  case MCK_ES: return "MCK_ES";
  case MCK_FPCCR: return "MCK_FPCCR";
  case MCK_FS: return "MCK_FS";
  case MCK_GS: return "MCK_GS";
  case MCK_RAX: return "MCK_RAX";
  case MCK_RBX: return "MCK_RBX";
  case MCK_RCX: return "MCK_RCX";
  case MCK_RDX: return "MCK_RDX";
  case MCK_RFP80_7: return "MCK_RFP80_7";
  case MCK_SS: return "MCK_SS";
  case MCK_ST0: return "MCK_ST0";
  case MCK_XMM0: return "MCK_XMM0";
  case MCK_Reg78: return "MCK_Reg78";
  case MCK_Reg77: return "MCK_Reg77";
  case MCK_Reg75: return "MCK_Reg75";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg71: return "MCK_Reg71";
  case MCK_Reg69: return "MCK_Reg69";
  case MCK_Reg67: return "MCK_Reg67";
  case MCK_GR32_AD: return "MCK_GR32_AD";
  case MCK_GR32_ArgRef: return "MCK_GR32_ArgRef";
  case MCK_GR32_BPSP: return "MCK_GR32_BPSP";
  case MCK_GR32_BSI: return "MCK_GR32_BSI";
  case MCK_GR32_CB: return "MCK_GR32_CB";
  case MCK_GR32_DIBP: return "MCK_GR32_DIBP";
  case MCK_GR32_SIDI: return "MCK_GR32_SIDI";
  case MCK_GR64_AD: return "MCK_GR64_AD";
  case MCK_GR64_ArgRef: return "MCK_GR64_ArgRef";
  case MCK_Reg111: return "MCK_Reg111";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg15: return "MCK_Reg15";
  case MCK_Reg57: return "MCK_Reg57";
  case MCK_GR16_ABCD: return "MCK_GR16_ABCD";
  case MCK_GR32_ABCD: return "MCK_GR32_ABCD";
  case MCK_GR32_TC: return "MCK_GR32_TC";
  case MCK_GR64_ABCD: return "MCK_GR64_ABCD";
  case MCK_GR8_ABCD_H: return "MCK_GR8_ABCD_H";
  case MCK_GR8_ABCD_L: return "MCK_GR8_ABCD_L";
  case MCK_VK16PAIR: return "MCK_VK16PAIR";
  case MCK_Reg63: return "MCK_Reg63";
  case MCK_Reg62: return "MCK_Reg62";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_Reg65: return "MCK_Reg65";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_SEGMENT_REG: return "MCK_SEGMENT_REG";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg60: return "MCK_Reg60";
  case MCK_Reg55: return "MCK_Reg55";
  case MCK_Reg54: return "MCK_Reg54";
  case MCK_GR32_NOREX_NOSP: return "MCK_GR32_NOREX_NOSP";
  case MCK_GR64_NOREX_NOSP: return "MCK_GR64_NOREX_NOSP";
  case MCK_RFP32: return "MCK_RFP32";
  case MCK_VK16WM: return "MCK_VK16WM";
  case MCK_Reg61: return "MCK_Reg61";
  case MCK_Reg58: return "MCK_Reg58";
  case MCK_Reg56: return "MCK_Reg56";
  case MCK_Reg44: return "MCK_Reg44";
  case MCK_GR16_NOREX: return "MCK_GR16_NOREX";
  case MCK_GR32_NOREX: return "MCK_GR32_NOREX";
  case MCK_GR8_NOREX: return "MCK_GR8_NOREX";
  case MCK_RST: return "MCK_RST";
  case MCK_TILE: return "MCK_TILE";
  case MCK_VK1: return "MCK_VK1";
  case MCK_VR64: return "MCK_VR64";
  case MCK_Reg52: return "MCK_Reg52";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_GR64_NOREX: return "MCK_GR64_NOREX";
  case MCK_GR64_TCW64: return "MCK_GR64_TCW64";
  case MCK_GR64_TC: return "MCK_GR64_TC";
  case MCK_GRH8: return "MCK_GRH8";
  case MCK_GR64PLTSafe: return "MCK_GR64PLTSafe";
  case MCK_GR32_NOSP: return "MCK_GR32_NOSP";
  case MCK_GR64_NOSP: return "MCK_GR64_NOSP";
  case MCK_Reg45: return "MCK_Reg45";
  case MCK_CONTROL_REG: return "MCK_CONTROL_REG";
  case MCK_DEBUG_REG: return "MCK_DEBUG_REG";
  case MCK_FR16: return "MCK_FR16";
  case MCK_GR16: return "MCK_GR16";
  case MCK_GR32: return "MCK_GR32";
  case MCK_VR256: return "MCK_VR256";
  case MCK_VR512_0_15: return "MCK_VR512_0_15";
  case MCK_Reg20: return "MCK_Reg20";
  case MCK_GR64: return "MCK_GR64";
  case MCK_GRH16: return "MCK_GRH16";
  case MCK_LOW32_ADDR_ACCESS: return "MCK_LOW32_ADDR_ACCESS";
  case MCK_LOW32_ADDR_ACCESS_RBP: return "MCK_LOW32_ADDR_ACCESS_RBP";
  case MCK_GR8: return "MCK_GR8";
  case MCK_FR16X: return "MCK_FR16X";
  case MCK_VR256X: return "MCK_VR256X";
  case MCK_VR512: return "MCK_VR512";
  case MCK_AVX512RC: return "MCK_AVX512RC";
  case MCK_ImmSExti64i8: return "MCK_ImmSExti64i8";
  case MCK_ImmSExti16i8: return "MCK_ImmSExti16i8";
  case MCK_ImmSExti32i8: return "MCK_ImmSExti32i8";
  case MCK_ImmSExti64i32: return "MCK_ImmSExti64i32";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmUnsignedi4: return "MCK_ImmUnsignedi4";
  case MCK_ImmUnsignedi8: return "MCK_ImmUnsignedi8";
  case MCK_VK16Pair: return "MCK_VK16Pair";
  case MCK_VK1Pair: return "MCK_VK1Pair";
  case MCK_VK2Pair: return "MCK_VK2Pair";
  case MCK_VK4Pair: return "MCK_VK4Pair";
  case MCK_VK8Pair: return "MCK_VK8Pair";
  case MCK_GR16orGR32orGR64: return "MCK_GR16orGR32orGR64";
  case MCK_GR32orGR64: return "MCK_GR32orGR64";
  case MCK_AbsMem16: return "MCK_AbsMem16";
  case MCK_DstIdx16: return "MCK_DstIdx16";
  case MCK_DstIdx32: return "MCK_DstIdx32";
  case MCK_DstIdx64: return "MCK_DstIdx64";
  case MCK_DstIdx8: return "MCK_DstIdx8";
  case MCK_MemOffs16_16: return "MCK_MemOffs16_16";
  case MCK_MemOffs16_32: return "MCK_MemOffs16_32";
  case MCK_MemOffs16_8: return "MCK_MemOffs16_8";
  case MCK_MemOffs32_16: return "MCK_MemOffs32_16";
  case MCK_MemOffs32_32: return "MCK_MemOffs32_32";
  case MCK_MemOffs32_64: return "MCK_MemOffs32_64";
  case MCK_MemOffs32_8: return "MCK_MemOffs32_8";
  case MCK_MemOffs64_16: return "MCK_MemOffs64_16";
  case MCK_MemOffs64_32: return "MCK_MemOffs64_32";
  case MCK_MemOffs64_64: return "MCK_MemOffs64_64";
  case MCK_MemOffs64_8: return "MCK_MemOffs64_8";
  case MCK_SrcIdx16: return "MCK_SrcIdx16";
  case MCK_SrcIdx32: return "MCK_SrcIdx32";
  case MCK_SrcIdx64: return "MCK_SrcIdx64";
  case MCK_SrcIdx8: return "MCK_SrcIdx8";
  case MCK_AbsMem: return "MCK_AbsMem";
  case MCK_Mem128: return "MCK_Mem128";
  case MCK_Mem128_RC128: return "MCK_Mem128_RC128";
  case MCK_Mem128_RC128X: return "MCK_Mem128_RC128X";
  case MCK_Mem128_RC256: return "MCK_Mem128_RC256";
  case MCK_Mem128_RC256X: return "MCK_Mem128_RC256X";
  case MCK_Mem16: return "MCK_Mem16";
  case MCK_Mem256: return "MCK_Mem256";
  case MCK_Mem256_RC128: return "MCK_Mem256_RC128";
  case MCK_Mem256_RC128X: return "MCK_Mem256_RC128X";
  case MCK_Mem256_RC256: return "MCK_Mem256_RC256";
  case MCK_Mem256_RC256X: return "MCK_Mem256_RC256X";
  case MCK_Mem256_RC512: return "MCK_Mem256_RC512";
  case MCK_Mem32: return "MCK_Mem32";
  case MCK_Mem512: return "MCK_Mem512";
  case MCK_Mem512_GR16: return "MCK_Mem512_GR16";
  case MCK_Mem512_GR32: return "MCK_Mem512_GR32";
  case MCK_Mem512_GR64: return "MCK_Mem512_GR64";
  case MCK_Mem512_RC256X: return "MCK_Mem512_RC256X";
  case MCK_Mem512_RC512: return "MCK_Mem512_RC512";
  case MCK_Mem64: return "MCK_Mem64";
  case MCK_Mem64_RC128: return "MCK_Mem64_RC128";
  case MCK_Mem64_RC128X: return "MCK_Mem64_RC128X";
  case MCK_Mem80: return "MCK_Mem80";
  case MCK_Mem8: return "MCK_Mem8";
  case MCK_SibMem: return "MCK_SibMem";
  case MCK_Mem: return "MCK_Mem";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset X86AsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (!FB[X86::Is64Bit])
    Features.set(Feature_Not64BitModeBit);
  if (FB[X86::Is64Bit])
    Features.set(Feature_In64BitModeBit);
  if (FB[X86::Is16Bit])
    Features.set(Feature_In16BitModeBit);
  if (!FB[X86::Is16Bit])
    Features.set(Feature_Not16BitModeBit);
  if (FB[X86::Is32Bit])
    Features.set(Feature_In32BitModeBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const X86AsmParser&AsmParser,
                               unsigned Kind,
                               const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\003aaa\003aad\004aadd\005aaddl\005aaddq\003aam\004aand\005aandl\005aan"
    "dq\003aas\003adc\004adcb\004adcl\004adcq\004adcw\004adcx\005adcxl\005ad"
    "cxq\003add\004addb\004addl\005addpd\005addps\004addq\006addr16\006addr3"
    "2\005addsd\005addss\010addsubpd\010addsubps\004addw\004adox\005adoxl\005"
    "adoxq\006aesdec\013aesdec128kl\013aesdec256kl\naesdeclast\017aesdecwide"
    "128kl\017aesdecwide256kl\006aesenc\013aesenc128kl\013aesenc256kl\naesen"
    "clast\017aesencwide128kl\017aesencwide256kl\006aesimc\017aeskeygenassis"
    "t\003and\004andb\004andl\004andn\005andnl\006andnpd\006andnps\005andnq\005"
    "andpd\005andps\004andq\004andw\003aor\004aorl\004aorq\004arpl\004axor\005"
    "axorl\005axorq\005bextr\006bextrl\006bextrq\007blcfill\010blcfilll\010b"
    "lcfillq\004blci\005blcic\006blcicl\006blcicq\005blcil\005blciq\006blcms"
    "k\007blcmskl\007blcmskq\004blcs\005blcsl\005blcsq\007blendpd\007blendps"
    "\010blendvpd\010blendvps\007blsfill\010blsfilll\010blsfillq\004blsi\005"
    "blsic\006blsicl\006blsicq\005blsil\005blsiq\006blsmsk\007blsmskl\007bls"
    "mskq\004blsr\005blsrl\005blsrq\005bound\003bsf\004bsfl\004bsfq\004bsfw\003"
    "bsr\004bsrl\004bsrq\004bsrw\005bswap\006bswapl\006bswapq\002bt\003btc\004"
    "btcl\004btcq\004btcw\003btl\003btq\003btr\004btrl\004btrq\004btrw\003bt"
    "s\004btsl\004btsq\004btsw\003btw\004bzhi\005bzhil\005bzhiq\004call\005c"
    "alll\005callq\005callw\004cbtw\003cbw\003cdq\004cdqe\004clac\003clc\003"
    "cld\010cldemote\007clflush\nclflushopt\004clgi\003cli\003clr\004clrb\004"
    "clrl\004clrq\010clrssbsy\004clrw\004cltd\004cltq\004clts\004clui\004clw"
    "b\006clzero\003cmc\005cmova\006cmovae\007cmovael\007cmovaeq\007cmovaew\006"
    "cmoval\006cmovaq\006cmovaw\005cmovb\006cmovbe\007cmovbel\007cmovbeq\007"
    "cmovbew\006cmovbl\006cmovbq\006cmovbw\005cmove\006cmovel\006cmoveq\006c"
    "movew\005cmovg\006cmovge\007cmovgel\007cmovgeq\007cmovgew\006cmovgl\006"
    "cmovgq\006cmovgw\005cmovl\006cmovle\007cmovlel\007cmovleq\007cmovlew\006"
    "cmovll\006cmovlq\006cmovlw\006cmovne\007cmovnel\007cmovneq\007cmovnew\006"
    "cmovno\007cmovnol\007cmovnoq\007cmovnow\006cmovnp\007cmovnpl\007cmovnpq"
    "\007cmovnpw\006cmovns\007cmovnsl\007cmovnsq\007cmovnsw\005cmovo\006cmov"
    "ol\006cmovoq\006cmovow\005cmovp\006cmovpl\006cmovpq\006cmovpw\005cmovs\006"
    "cmovsl\006cmovsq\006cmovsw\003cmp\tcmpaexadd\010cmpaxadd\004cmpb\tcmpbe"
    "xadd\010cmpbxadd\010cmpexadd\tcmpgexadd\010cmpgxadd\004cmpl\tcmplexadd\010"
    "cmplxadd\ncmpnbexadd\tcmpnbxadd\tcmpnexadd\ncmpnlexadd\tcmpnlxadd\tcmpn"
    "oxadd\tcmpnpxadd\tcmpnsxadd\tcmpnzxadd\010cmpoxadd\005cmppd\005cmpps\010"
    "cmppxadd\004cmpq\004cmps\005cmpsb\005cmpsd\005cmpsl\005cmpsq\005cmpss\005"
    "cmpsw\010cmpsxadd\004cmpw\007cmpxchg\ncmpxchg16b\tcmpxchg8b\010cmpxchgb"
    "\010cmpxchgl\010cmpxchgq\010cmpxchgw\010cmpzxadd\006comisd\006comiss\005"
    "cpuid\003cqo\004cqto\005crc32\006crc32b\006crc32l\006crc32q\006crc32w\002"
    "cs\010cvtdq2pd\010cvtdq2ps\010cvtpd2dq\010cvtpd2pi\010cvtpd2ps\010cvtpi"
    "2pd\010cvtpi2ps\010cvtps2dq\010cvtps2pd\010cvtps2pi\010cvtsd2si\tcvtsd2"
    "sil\tcvtsd2siq\010cvtsd2ss\010cvtsi2sd\tcvtsi2sdl\tcvtsi2sdq\010cvtsi2s"
    "s\tcvtsi2ssl\tcvtsi2ssq\010cvtss2sd\010cvtss2si\tcvtss2sil\tcvtss2siq\t"
    "cvttpd2dq\tcvttpd2pi\tcvttps2dq\tcvttps2pi\tcvttsd2si\ncvttsd2sil\ncvtt"
    "sd2siq\tcvttss2si\ncvttss2sil\ncvttss2siq\003cwd\004cwde\004cwtd\004cwt"
    "l\003daa\003das\006data16\003dec\004decb\004decl\004decq\004decw\003div"
    "\004divb\004divl\005divpd\005divps\004divq\005divsd\005divss\004divw\004"
    "dppd\004dpps\002ds\004emms\005encls\005enclu\005enclv\014encodekey128\014"
    "encodekey256\007endbr32\007endbr64\006enqcmd\007enqcmds\005enter\002es\t"
    "extractps\005extrq\005f2xm1\004fabs\004fadd\005faddl\005faddp\005fadds\004"
    "fbld\005fbstp\004fchs\006fcmovb\007fcmovbe\006fcmove\007fcmovnb\010fcmo"
    "vnbe\007fcmovne\007fcmovnu\006fcmovu\004fcom\005fcomi\005fcoml\005fcomp"
    "\006fcompi\006fcompl\006fcompp\006fcomps\005fcoms\004fcos\007fdecstp\004"
    "fdiv\005fdivl\005fdivp\005fdivr\006fdivrl\006fdivrp\006fdivrs\005fdivs\005"
    "femms\005ffree\006ffreep\005fiadd\006fiaddl\006fiadds\005ficom\006ficom"
    "l\006ficomp\007ficompl\007ficomps\006ficoms\005fidiv\006fidivl\006fidiv"
    "r\007fidivrl\007fidivrs\006fidivs\004fild\005fildl\006fildll\005filds\005"
    "fimul\006fimull\006fimuls\007fincstp\004fist\005fistl\005fistp\006fistp"
    "l\007fistpll\006fistps\005fists\006fisttp\007fisttpl\010fisttpll\007fis"
    "ttps\005fisub\006fisubl\006fisubr\007fisubrl\007fisubrs\006fisubs\003fl"
    "d\004fld1\005fldcw\006fldenv\004fldl\006fldl2e\006fldl2t\006fldlg2\006f"
    "ldln2\005fldpi\004flds\004fldt\004fldz\004fmul\005fmull\005fmulp\005fmu"
    "ls\006fnclex\006fninit\004fnop\006fnsave\006fnstcw\007fnstenv\006fnstsw"
    "\006fpatan\005fprem\006fprem1\005fptan\007frndint\006frstor\002fs\006fs"
    "cale\004fsin\007fsincos\005fsqrt\003fst\004fstl\004fstp\005fstpl\005fst"
    "ps\005fstpt\004fsts\004fsub\005fsubl\005fsubp\005fsubr\006fsubrl\006fsu"
    "brp\006fsubrs\005fsubs\004ftst\005fucom\006fucomi\006fucomp\007fucompi\007"
    "fucompp\004fxam\004fxch\007fxrstor\tfxrstor64\006fxsave\010fxsave64\007"
    "fxtract\005fyl2x\007fyl2xp1\006getsec\020gf2p8affineinvqb\015gf2p8affin"
    "eqb\tgf2p8mulb\002gs\006haddpd\006haddps\003hlt\006hreset\006hsubpd\006"
    "hsubps\004idiv\005idivb\005idivl\005idivq\005idivw\004imul\005imulb\005"
    "imull\005imulq\005imulw\002in\003inb\003inc\004incb\004incl\004incq\007"
    "incsspd\007incsspq\004incw\003inl\003ins\004insb\004insd\010insertps\007"
    "insertq\004insl\004insw\003int\004int3\004into\004invd\006invept\006inv"
    "lpg\007invlpga\007invlpgb\007invpcid\007invvpid\003inw\004iret\005iretd"
    "\005iretl\005iretq\005iretw\002ja\003jae\002jb\003jbe\004jcxz\002je\005"
    "jecxz\002jg\003jge\002jl\003jle\003jmp\004jmpl\004jmpq\004jmpw\003jne\003"
    "jno\003jnp\003jns\002jo\002jp\005jrcxz\002js\005kaddb\005kaddd\005kaddq"
    "\005kaddw\005kandb\005kandd\006kandnb\006kandnd\006kandnq\006kandnw\005"
    "kandq\005kandw\005kmovb\005kmovd\005kmovq\005kmovw\005knotb\005knotd\005"
    "knotq\005knotw\004korb\004kord\004korq\010kortestb\010kortestd\010korte"
    "stq\010kortestw\004korw\010kshiftlb\010kshiftld\010kshiftlq\010kshiftlw"
    "\010kshiftrb\010kshiftrd\010kshiftrq\010kshiftrw\006ktestb\006ktestd\006"
    "ktestq\006ktestw\010kunpckbw\010kunpckdq\010kunpckwd\006kxnorb\006kxnor"
    "d\006kxnorq\006kxnorw\005kxorb\005kxord\005kxorq\005kxorw\004lahf\003la"
    "r\004larl\004larq\004larw\005lcall\006lcalll\006lcallq\006lcallw\005ldd"
    "qu\007ldmxcsr\003lds\004ldsl\004ldsw\tldtilecfg\003lea\004leal\004leaq\005"
    "leave\004leaw\003les\004lesl\004lesw\006lfence\003lfs\004lfsl\004lfsq\004"
    "lfsw\004lgdt\005lgdtd\005lgdtl\005lgdtq\005lgdtw\003lgs\004lgsl\004lgsq"
    "\004lgsw\004lidt\005lidtd\005lidtl\005lidtq\005lidtw\004ljmp\005ljmpl\005"
    "ljmpq\005ljmpw\004lldt\005lldtw\006llwpcb\004lmsw\005lmsww\tloadiwkey\004"
    "lock\004lods\005lodsb\005lodsd\005lodsl\005lodsq\005lodsw\004loop\005lo"
    "ope\006loopne\005lretl\005lretq\005lretw\003lsl\004lsll\004lslq\004lslw"
    "\003lss\004lssl\004lssq\004lssw\003ltr\004ltrw\006lwpins\006lwpval\005l"
    "zcnt\006lzcntl\006lzcntq\006lzcntw\nmaskmovdqu\010maskmovq\005maxpd\005"
    "maxps\005maxsd\005maxss\006mfence\005minpd\005minps\005minsd\005minss\007"
    "monitor\010monitorx\007montmul\003mov\005mov.s\006movabs\007movabsb\007"
    "movabsl\007movabsq\007movabsw\006movapd\010movapd.s\006movaps\010movaps"
    ".s\004movb\006movb.s\005movbe\006movbel\006movbeq\006movbew\004movd\007"
    "movddup\tmovdir64b\007movdiri\007movdq2q\006movdqa\010movdqa.s\006movdq"
    "u\010movdqu.s\007movhlps\006movhpd\006movhps\004movl\006movl.s\007movlh"
    "ps\006movlpd\006movlps\010movmskpd\010movmskps\007movntdq\010movntdqa\006"
    "movnti\007movntil\007movntiq\007movntpd\007movntps\006movntq\007movntsd"
    "\007movntss\004movq\006movq.s\007movq2dq\004movs\005movsb\006movsbl\006"
    "movsbq\006movsbw\005movsd\007movsd.s\010movshdup\005movsl\010movsldup\006"
    "movslq\005movsq\005movss\007movss.s\005movsw\006movswl\006movswq\005mov"
    "sx\006movsxd\006movupd\010movupd.s\006movups\010movups.s\004movw\006mov"
    "w.s\006movzbl\006movzbq\006movzbw\006movzwl\006movzwq\005movzx\007mpsad"
    "bw\003mul\004mulb\004mull\005mulpd\005mulps\004mulq\005mulsd\005mulss\004"
    "mulw\004mulx\005mulxl\005mulxq\005mwait\006mwaitx\003neg\004negb\004neg"
    "l\004negq\004negw\003nop\004nopl\004nopq\004nopw\003not\004notb\004notl"
    "\004notq\004notw\002or\003orb\003orl\004orpd\004orps\003orq\003orw\003o"
    "ut\004outb\004outl\004outs\005outsb\005outsd\005outsl\005outsw\004outw\005"
    "pabsb\005pabsd\005pabsw\010packssdw\010packsswb\010packusdw\010packuswb"
    "\005paddb\005paddd\005paddq\006paddsb\006paddsw\007paddusb\007paddusw\005"
    "paddw\007palignr\004pand\005pandn\005pause\005pavgb\007pavgusb\005pavgw"
    "\010pblendvb\007pblendw\006pbndkb\014pclmulhqhqdq\014pclmulhqlqdq\014pc"
    "lmullqhqdq\014pclmullqlqdq\tpclmulqdq\007pcmpeqb\007pcmpeqd\007pcmpeqq\007"
    "pcmpeqw\tpcmpestri\tpcmpestrm\007pcmpgtb\007pcmpgtd\007pcmpgtq\007pcmpg"
    "tw\tpcmpistri\tpcmpistrm\007pconfig\004pdep\005pdepl\005pdepq\004pext\005"
    "pextl\005pextq\006pextrb\006pextrd\006pextrq\006pextrw\005pf2id\005pf2i"
    "w\005pfacc\005pfadd\007pfcmpeq\007pfcmpge\007pfcmpgt\005pfmax\005pfmin\005"
    "pfmul\006pfnacc\007pfpnacc\005pfrcp\010pfrcpit1\010pfrcpit2\010pfrsqit1"
    "\007pfrsqrt\005pfsub\006pfsubr\006phaddd\007phaddsw\006phaddw\nphminpos"
    "uw\006phsubd\007phsubsw\006phsubw\005pi2fd\005pi2fw\006pinsrb\006pinsrd"
    "\006pinsrq\006pinsrw\tpmaddubsw\007pmaddwd\006pmaxsb\006pmaxsd\006pmaxs"
    "w\006pmaxub\006pmaxud\006pmaxuw\006pminsb\006pminsd\006pminsw\006pminub"
    "\006pminud\006pminuw\010pmovmskb\010pmovsxbd\010pmovsxbq\010pmovsxbw\010"
    "pmovsxdq\010pmovsxwd\010pmovsxwq\010pmovzxbd\010pmovzxbq\010pmovzxbw\010"
    "pmovzxdq\010pmovzxwd\010pmovzxwq\006pmuldq\010pmulhrsw\007pmulhrw\007pm"
    "ulhuw\006pmulhw\006pmulld\006pmullw\007pmuludq\003pop\005popal\005popaw"
    "\006popcnt\007popcntl\007popcntq\007popcntw\004popf\005popfd\005popfl\005"
    "popfq\005popfw\004popl\004popq\004popw\003por\010prefetch\013prefetchit"
    "0\013prefetchit1\013prefetchnta\nprefetcht0\nprefetcht1\nprefetcht2\tpr"
    "efetchw\013prefetchwt1\006psadbw\006pshufb\006pshufd\007pshufhw\007pshu"
    "flw\006pshufw\006psignb\006psignd\006psignw\005pslld\006pslldq\005psllq"
    "\005psllw\006psmash\005psrad\005psraw\005psrld\006psrldq\005psrlq\005ps"
    "rlw\005psubb\005psubd\005psubq\006psubsb\006psubsw\007psubusb\007psubus"
    "w\005psubw\006pswapd\005ptest\007ptwrite\010ptwritel\010ptwriteq\tpunpc"
    "khbw\tpunpckhdq\npunpckhqdq\tpunpckhwd\tpunpcklbw\tpunpckldq\npunpcklqd"
    "q\tpunpcklwd\004push\006pushal\006pushaw\005pushf\006pushfd\006pushfl\006"
    "pushfq\006pushfw\005pushl\005pushq\005pushw\tpvalidate\004pxor\003rcl\004"
    "rclb\004rcll\004rclq\004rclw\005rcpps\005rcpss\003rcr\004rcrb\004rcrl\004"
    "rcrq\004rcrw\010rdfsbase\trdfsbasel\trdfsbaseq\010rdgsbase\trdgsbasel\t"
    "rdgsbaseq\005rdmsr\trdmsrlist\005rdpid\006rdpkru\005rdpmc\005rdpru\006r"
    "drand\007rdrandl\007rdrandq\007rdrandw\006rdseed\007rdseedl\007rdseedq\007"
    "rdseedw\006rdsspd\006rdsspq\005rdtsc\006rdtscp\003rep\005repne\003ret\004"
    "retf\005retfq\004retl\004retq\004retw\005rex64\trmpadjust\010rmpquery\t"
    "rmpupdate\003rol\004rolb\004roll\004rolq\004rolw\003ror\004rorb\004rorl"
    "\004rorq\004rorw\004rorx\005rorxl\005rorxq\007roundpd\007roundps\007rou"
    "ndsd\007roundss\003rsm\007rsqrtps\007rsqrtss\010rstorssp\004sahf\004sal"
    "c\003sar\004sarb\004sarl\004sarq\004sarw\004sarx\005sarxl\005sarxq\013s"
    "aveprevssp\003sbb\004sbbb\004sbbl\004sbbq\004sbbw\004scas\005scasb\005s"
    "casd\005scasl\005scasq\005scasw\010seamcall\007seamops\007seamret\010se"
    "nduipi\tserialize\004seta\005setae\004setb\005setbe\004sete\004setg\005"
    "setge\004setl\005setle\005setne\005setno\005setnp\005setns\004seto\004s"
    "etp\004sets\010setssbsy\006sfence\004sgdt\005sgdtd\005sgdtl\005sgdtq\005"
    "sgdtw\010sha1msg1\010sha1msg2\tsha1nexte\tsha1rnds4\nsha256msg1\nsha256"
    "msg2\013sha256rnds2\003shl\004shlb\004shld\005shldl\005shldq\005shldw\004"
    "shll\004shlq\004shlw\004shlx\005shlxl\005shlxq\003shr\004shrb\004shrd\005"
    "shrdl\005shrdq\005shrdw\004shrl\004shrq\004shrw\004shrx\005shrxl\005shr"
    "xq\006shufpd\006shufps\004sidt\005sidtd\005sidtl\005sidtq\005sidtw\006s"
    "kinit\004sldt\005sldtl\005sldtq\005sldtw\006slwpcb\004smsw\005smswl\005"
    "smswq\005smsww\006sqrtpd\006sqrtps\006sqrtsd\006sqrtss\002ss\004stac\003"
    "stc\003std\004stgi\003sti\007stmxcsr\004stos\005stosb\005stosd\005stosl"
    "\005stosq\005stosw\003str\004strl\004strq\004strw\tsttilecfg\004stui\003"
    "sub\004subb\004subl\005subpd\005subps\004subq\005subsd\005subss\004subw"
    "\006swapgs\007syscall\010sysenter\007sysexit\010sysexitl\010sysexitq\006"
    "sysret\007sysretl\007sysretq\006t1mskc\007t1mskcl\007t1mskcq\014tcmmimf"
    "p16ps\014tcmmrlfp16ps\006tdcall\ttdpbf16ps\007tdpbssd\007tdpbsud\007tdp"
    "busd\007tdpbuud\ttdpfp16ps\004test\005testb\005testl\005testq\006testui"
    "\005testw\ttileloadd\013tileloaddt1\013tilerelease\ntilestored\010tilez"
    "ero\007tlbsync\006tpause\005tzcnt\006tzcntl\006tzcntq\006tzcntw\005tzms"
    "k\006tzmskl\006tzmskq\007ucomisd\007ucomiss\003ud1\004ud1l\004ud1q\004u"
    "d1w\003ud2\005uiret\010umonitor\006umwait\010unpckhpd\010unpckhps\010un"
    "pcklpd\010unpcklps\tv4fmaddps\tv4fmaddss\nv4fnmaddps\nv4fnmaddss\006vad"
    "dpd\006vaddph\006vaddps\006vaddsd\006vaddsh\006vaddss\tvaddsubpd\tvadds"
    "ubps\007vaesdec\013vaesdeclast\007vaesenc\013vaesenclast\007vaesimc\020"
    "vaeskeygenassist\007valignd\007valignq\007vandnpd\007vandnps\006vandpd\006"
    "vandps\016vbcstnebf162ps\014vbcstnesh2ps\tvblendmpd\tvblendmps\010vblen"
    "dpd\010vblendps\tvblendvpd\tvblendvps\016vbroadcastf128\017vbroadcastf3"
    "2x2\017vbroadcastf32x4\017vbroadcastf32x8\017vbroadcastf64x2\017vbroadc"
    "astf64x4\016vbroadcasti128\017vbroadcasti32x2\017vbroadcasti32x4\017vbr"
    "oadcasti32x8\017vbroadcasti64x2\017vbroadcasti64x4\014vbroadcastsd\014v"
    "broadcastss\006vcmppd\006vcmpph\006vcmpps\006vcmpsd\006vcmpsh\006vcmpss"
    "\007vcomisd\007vcomish\007vcomiss\013vcompresspd\013vcompressps\tvcvtdq"
    "2pd\tvcvtdq2ph\nvcvtdq2phx\nvcvtdq2phy\tvcvtdq2ps\016vcvtne2ps2bf16\016"
    "vcvtneebf162ps\014vcvtneeph2ps\016vcvtneobf162ps\014vcvtneoph2ps\015vcv"
    "tneps2bf16\016vcvtneps2bf16x\016vcvtneps2bf16y\tvcvtpd2dq\nvcvtpd2dqx\n"
    "vcvtpd2dqy\tvcvtpd2ph\nvcvtpd2phx\nvcvtpd2phy\nvcvtpd2phz\tvcvtpd2ps\nv"
    "cvtpd2psx\nvcvtpd2psy\tvcvtpd2qq\nvcvtpd2udq\013vcvtpd2udqx\013vcvtpd2u"
    "dqy\nvcvtpd2uqq\tvcvtph2dq\tvcvtph2pd\tvcvtph2ps\nvcvtph2psx\tvcvtph2qq"
    "\nvcvtph2udq\nvcvtph2uqq\tvcvtph2uw\010vcvtph2w\tvcvtps2dq\tvcvtps2pd\t"
    "vcvtps2ph\nvcvtps2phx\013vcvtps2phxx\013vcvtps2phxy\tvcvtps2qq\nvcvtps2"
    "udq\nvcvtps2uqq\tvcvtqq2pd\tvcvtqq2ph\nvcvtqq2phx\nvcvtqq2phy\nvcvtqq2p"
    "hz\tvcvtqq2ps\nvcvtqq2psx\nvcvtqq2psy\tvcvtsd2sh\tvcvtsd2si\nvcvtsd2sil"
    "\nvcvtsd2siq\tvcvtsd2ss\nvcvtsd2usi\013vcvtsd2usil\013vcvtsd2usiq\tvcvt"
    "sh2sd\tvcvtsh2si\nvcvtsh2sil\nvcvtsh2siq\tvcvtsh2ss\nvcvtsh2usi\013vcvt"
    "sh2usil\013vcvtsh2usiq\tvcvtsi2sd\nvcvtsi2sdl\nvcvtsi2sdq\tvcvtsi2sh\nv"
    "cvtsi2shl\nvcvtsi2shq\tvcvtsi2ss\nvcvtsi2ssl\nvcvtsi2ssq\tvcvtss2sd\tvc"
    "vtss2sh\tvcvtss2si\nvcvtss2sil\nvcvtss2siq\nvcvtss2usi\013vcvtss2usil\013"
    "vcvtss2usiq\nvcvttpd2dq\013vcvttpd2dqx\013vcvttpd2dqy\nvcvttpd2qq\013vc"
    "vttpd2udq\014vcvttpd2udqx\014vcvttpd2udqy\013vcvttpd2uqq\nvcvttph2dq\nv"
    "cvttph2qq\013vcvttph2udq\013vcvttph2uqq\nvcvttph2uw\tvcvttph2w\nvcvttps"
    "2dq\nvcvttps2qq\013vcvttps2udq\013vcvttps2uqq\nvcvttsd2si\013vcvttsd2si"
    "l\013vcvttsd2siq\013vcvttsd2usi\014vcvttsd2usil\014vcvttsd2usiq\nvcvtts"
    "h2si\013vcvttsh2sil\013vcvttsh2siq\013vcvttsh2usi\014vcvttsh2usil\014vc"
    "vttsh2usiq\nvcvttss2si\013vcvttss2sil\013vcvttss2siq\013vcvttss2usi\014"
    "vcvttss2usil\014vcvttss2usiq\nvcvtudq2pd\nvcvtudq2ph\013vcvtudq2phx\013"
    "vcvtudq2phy\nvcvtudq2ps\nvcvtuqq2pd\nvcvtuqq2ph\013vcvtuqq2phx\013vcvtu"
    "qq2phy\013vcvtuqq2phz\nvcvtuqq2ps\013vcvtuqq2psx\013vcvtuqq2psy\nvcvtus"
    "i2sd\013vcvtusi2sdl\013vcvtusi2sdq\nvcvtusi2sh\013vcvtusi2shl\013vcvtus"
    "i2shq\nvcvtusi2ss\013vcvtusi2ssl\013vcvtusi2ssq\tvcvtuw2ph\010vcvtw2ph\t"
    "vdbpsadbw\006vdivpd\006vdivph\006vdivps\006vdivsd\006vdivsh\006vdivss\t"
    "vdpbf16ps\005vdppd\005vdpps\004verr\004verw\007vexp2pd\007vexp2ps\tvexp"
    "andpd\tvexpandps\014vextractf128\015vextractf32x4\015vextractf32x8\015v"
    "extractf64x2\015vextractf64x4\014vextracti128\015vextracti32x4\015vextr"
    "acti32x8\015vextracti64x2\015vextracti64x4\nvextractps\nvfcmaddcph\nvfc"
    "maddcsh\tvfcmulcph\tvfcmulcsh\013vfixupimmpd\013vfixupimmps\013vfixupim"
    "msd\013vfixupimmss\013vfmadd132pd\013vfmadd132ph\013vfmadd132ps\013vfma"
    "dd132sd\013vfmadd132sh\013vfmadd132ss\013vfmadd213pd\013vfmadd213ph\013"
    "vfmadd213ps\013vfmadd213sd\013vfmadd213sh\013vfmadd213ss\013vfmadd231pd"
    "\013vfmadd231ph\013vfmadd231ps\013vfmadd231sd\013vfmadd231sh\013vfmadd2"
    "31ss\tvfmaddcph\tvfmaddcsh\010vfmaddpd\010vfmaddps\010vfmaddsd\010vfmad"
    "dss\016vfmaddsub132pd\016vfmaddsub132ph\016vfmaddsub132ps\016vfmaddsub2"
    "13pd\016vfmaddsub213ph\016vfmaddsub213ps\016vfmaddsub231pd\016vfmaddsub"
    "231ph\016vfmaddsub231ps\013vfmaddsubpd\013vfmaddsubps\013vfmsub132pd\013"
    "vfmsub132ph\013vfmsub132ps\013vfmsub132sd\013vfmsub132sh\013vfmsub132ss"
    "\013vfmsub213pd\013vfmsub213ph\013vfmsub213ps\013vfmsub213sd\013vfmsub2"
    "13sh\013vfmsub213ss\013vfmsub231pd\013vfmsub231ph\013vfmsub231ps\013vfm"
    "sub231sd\013vfmsub231sh\013vfmsub231ss\016vfmsubadd132pd\016vfmsubadd13"
    "2ph\016vfmsubadd132ps\016vfmsubadd213pd\016vfmsubadd213ph\016vfmsubadd2"
    "13ps\016vfmsubadd231pd\016vfmsubadd231ph\016vfmsubadd231ps\013vfmsubadd"
    "pd\013vfmsubaddps\010vfmsubpd\010vfmsubps\010vfmsubsd\010vfmsubss\010vf"
    "mulcph\010vfmulcsh\014vfnmadd132pd\014vfnmadd132ph\014vfnmadd132ps\014v"
    "fnmadd132sd\014vfnmadd132sh\014vfnmadd132ss\014vfnmadd213pd\014vfnmadd2"
    "13ph\014vfnmadd213ps\014vfnmadd213sd\014vfnmadd213sh\014vfnmadd213ss\014"
    "vfnmadd231pd\014vfnmadd231ph\014vfnmadd231ps\014vfnmadd231sd\014vfnmadd"
    "231sh\014vfnmadd231ss\tvfnmaddpd\tvfnmaddps\tvfnmaddsd\tvfnmaddss\014vf"
    "nmsub132pd\014vfnmsub132ph\014vfnmsub132ps\014vfnmsub132sd\014vfnmsub13"
    "2sh\014vfnmsub132ss\014vfnmsub213pd\014vfnmsub213ph\014vfnmsub213ps\014"
    "vfnmsub213sd\014vfnmsub213sh\014vfnmsub213ss\014vfnmsub231pd\014vfnmsub"
    "231ph\014vfnmsub231ps\014vfnmsub231sd\014vfnmsub231sh\014vfnmsub231ss\t"
    "vfnmsubpd\tvfnmsubps\tvfnmsubsd\tvfnmsubss\nvfpclasspd\013vfpclasspdx\013"
    "vfpclasspdy\013vfpclasspdz\nvfpclassph\013vfpclassphx\013vfpclassphy\013"
    "vfpclassphz\nvfpclassps\013vfpclasspsx\013vfpclasspsy\013vfpclasspsz\nv"
    "fpclasssd\nvfpclasssh\nvfpclassss\007vfrczpd\007vfrczps\007vfrczsd\007v"
    "frczss\nvgatherdpd\nvgatherdps\015vgatherpf0dpd\015vgatherpf0dps\015vga"
    "therpf0qpd\015vgatherpf0qps\015vgatherpf1dpd\015vgatherpf1dps\015vgathe"
    "rpf1qpd\015vgatherpf1qps\nvgatherqpd\nvgatherqps\tvgetexppd\tvgetexpph\t"
    "vgetexpps\tvgetexpsd\tvgetexpsh\tvgetexpss\nvgetmantpd\nvgetmantph\nvge"
    "tmantps\nvgetmantsd\nvgetmantsh\nvgetmantss\021vgf2p8affineinvqb\016vgf"
    "2p8affineqb\nvgf2p8mulb\007vhaddpd\007vhaddps\007vhsubpd\007vhsubps\013"
    "vinsertf128\014vinsertf32x4\014vinsertf32x8\014vinsertf64x2\014vinsertf"
    "64x4\013vinserti128\014vinserti32x4\014vinserti32x8\014vinserti64x2\014"
    "vinserti64x4\tvinsertps\006vlddqu\010vldmxcsr\013vmaskmovdqu\nvmaskmovp"
    "d\nvmaskmovps\006vmaxpd\006vmaxph\006vmaxps\006vmaxsd\006vmaxsh\006vmax"
    "ss\006vmcall\007vmclear\006vmfunc\006vminpd\006vminph\006vminps\006vmin"
    "sd\006vminsh\006vminss\010vmlaunch\006vmload\007vmmcall\007vmovapd\tvmo"
    "vapd.s\007vmovaps\tvmovaps.s\005vmovd\010vmovddup\007vmovdqa\tvmovdqa.s"
    "\tvmovdqa32\013vmovdqa32.s\tvmovdqa64\013vmovdqa64.s\007vmovdqu\tvmovdq"
    "u.s\tvmovdqu16\013vmovdqu16.s\tvmovdqu32\013vmovdqu32.s\tvmovdqu64\013v"
    "movdqu64.s\010vmovdqu8\nvmovdqu8.s\010vmovhlps\007vmovhpd\007vmovhps\010"
    "vmovlhps\007vmovlpd\007vmovlps\tvmovmskpd\tvmovmskps\010vmovntdq\tvmovn"
    "tdqa\010vmovntpd\010vmovntps\005vmovq\007vmovq.s\006vmovsd\010vmovsd.s\006"
    "vmovsh\010vmovsh.s\tvmovshdup\tvmovsldup\006vmovss\010vmovss.s\007vmovu"
    "pd\tvmovupd.s\007vmovups\tvmovups.s\005vmovw\010vmpsadbw\007vmptrld\007"
    "vmptrst\006vmread\007vmreadl\007vmreadq\010vmresume\005vmrun\006vmsave\006"
    "vmulpd\006vmulph\006vmulps\006vmulsd\006vmulsh\006vmulss\007vmwrite\010"
    "vmwritel\010vmwriteq\006vmxoff\005vmxon\005vorpd\005vorps\015vp2interse"
    "ctd\015vp2intersectq\tvp4dpwssd\nvp4dpwssds\006vpabsb\006vpabsd\006vpab"
    "sq\006vpabsw\tvpackssdw\tvpacksswb\tvpackusdw\tvpackuswb\006vpaddb\006v"
    "paddd\006vpaddq\007vpaddsb\007vpaddsw\010vpaddusb\010vpaddusw\006vpaddw"
    "\010vpalignr\005vpand\006vpandd\006vpandn\007vpandnd\007vpandnq\006vpan"
    "dq\006vpavgb\006vpavgw\010vpblendd\tvpblendmb\tvpblendmd\tvpblendmq\tvp"
    "blendmw\tvpblendvb\010vpblendw\014vpbroadcastb\014vpbroadcastd\017vpbro"
    "adcastmb2q\017vpbroadcastmw2d\014vpbroadcastq\014vpbroadcastw\015vpclmu"
    "lhqhqdq\015vpclmulhqlqdq\015vpclmullqhqdq\015vpclmullqlqdq\nvpclmulqdq\006"
    "vpcmov\006vpcmpb\006vpcmpd\010vpcmpeqb\010vpcmpeqd\010vpcmpeqq\010vpcmp"
    "eqw\nvpcmpestri\nvpcmpestrm\010vpcmpgtb\010vpcmpgtd\010vpcmpgtq\010vpcm"
    "pgtw\nvpcmpistri\nvpcmpistrm\006vpcmpq\007vpcmpub\007vpcmpud\007vpcmpuq"
    "\007vpcmpuw\006vpcmpw\006vpcomb\006vpcomd\013vpcompressb\013vpcompressd"
    "\013vpcompressq\013vpcompressw\006vpcomq\007vpcomub\007vpcomud\007vpcom"
    "uq\007vpcomuw\006vpcomw\013vpconflictd\013vpconflictq\010vpdpbssd\tvpdp"
    "bssds\010vpdpbsud\tvpdpbsuds\010vpdpbusd\tvpdpbusds\010vpdpbuud\tvpdpbu"
    "uds\010vpdpwssd\tvpdpwssds\010vpdpwsud\tvpdpwsuds\010vpdpwusd\tvpdpwusd"
    "s\010vpdpwuud\tvpdpwuuds\nvperm2f128\nvperm2i128\006vpermb\006vpermd\010"
    "vpermi2b\010vpermi2d\tvpermi2pd\tvpermi2ps\010vpermi2q\010vpermi2w\nvpe"
    "rmil2pd\nvpermil2ps\tvpermilpd\tvpermilps\007vpermpd\007vpermps\006vper"
    "mq\010vpermt2b\010vpermt2d\tvpermt2pd\tvpermt2ps\010vpermt2q\010vpermt2"
    "w\006vpermw\tvpexpandb\tvpexpandd\tvpexpandq\tvpexpandw\007vpextrb\007v"
    "pextrd\007vpextrq\007vpextrw\nvpgatherdd\nvpgatherdq\nvpgatherqd\nvpgat"
    "herqq\010vphaddbd\010vphaddbq\010vphaddbw\007vphaddd\010vphadddq\010vph"
    "addsw\tvphaddubd\tvphaddubq\tvphaddubw\tvphaddudq\tvphadduwd\tvphadduwq"
    "\007vphaddw\010vphaddwd\010vphaddwq\013vphminposuw\010vphsubbw\007vphsu"
    "bd\010vphsubdq\010vphsubsw\007vphsubw\010vphsubwd\007vpinsrb\007vpinsrd"
    "\007vpinsrq\007vpinsrw\010vplzcntd\010vplzcntq\010vpmacsdd\tvpmacsdqh\t"
    "vpmacsdql\tvpmacssdd\nvpmacssdqh\nvpmacssdql\tvpmacsswd\tvpmacssww\010v"
    "pmacswd\010vpmacsww\nvpmadcsswd\tvpmadcswd\013vpmadd52huq\013vpmadd52lu"
    "q\nvpmaddubsw\010vpmaddwd\nvpmaskmovd\nvpmaskmovq\007vpmaxsb\007vpmaxsd"
    "\007vpmaxsq\007vpmaxsw\007vpmaxub\007vpmaxud\007vpmaxuq\007vpmaxuw\007v"
    "pminsb\007vpminsd\007vpminsq\007vpminsw\007vpminub\007vpminud\007vpminu"
    "q\007vpminuw\010vpmovb2m\010vpmovd2m\007vpmovdb\007vpmovdw\010vpmovm2b\010"
    "vpmovm2d\010vpmovm2q\010vpmovm2w\tvpmovmskb\010vpmovq2m\007vpmovqb\007v"
    "pmovqd\007vpmovqw\010vpmovsdb\010vpmovsdw\010vpmovsqb\010vpmovsqd\010vp"
    "movsqw\010vpmovswb\tvpmovsxbd\tvpmovsxbq\tvpmovsxbw\tvpmovsxdq\tvpmovsx"
    "wd\tvpmovsxwq\tvpmovusdb\tvpmovusdw\tvpmovusqb\tvpmovusqd\tvpmovusqw\tv"
    "pmovuswb\010vpmovw2m\007vpmovwb\tvpmovzxbd\tvpmovzxbq\tvpmovzxbw\tvpmov"
    "zxdq\tvpmovzxwd\tvpmovzxwq\007vpmuldq\tvpmulhrsw\010vpmulhuw\007vpmulhw"
    "\007vpmulld\007vpmullq\007vpmullw\016vpmultishiftqb\010vpmuludq\010vpop"
    "cntb\010vpopcntd\010vpopcntq\010vpopcntw\004vpor\005vpord\005vporq\006v"
    "pperm\006vprold\006vprolq\007vprolvd\007vprolvq\006vprord\006vprorq\007"
    "vprorvd\007vprorvq\006vprotb\006vprotd\006vprotq\006vprotw\007vpsadbw\013"
    "vpscatterdd\013vpscatterdq\013vpscatterqd\013vpscatterqq\006vpshab\006v"
    "pshad\006vpshaq\006vpshaw\006vpshlb\006vpshld\007vpshldd\007vpshldq\010"
    "vpshldvd\010vpshldvq\010vpshldvw\007vpshldw\006vpshlq\006vpshlw\007vpsh"
    "rdd\007vpshrdq\010vpshrdvd\010vpshrdvq\010vpshrdvw\007vpshrdw\007vpshuf"
    "b\014vpshufbitqmb\007vpshufd\010vpshufhw\010vpshuflw\007vpsignb\007vpsi"
    "gnd\007vpsignw\006vpslld\007vpslldq\006vpsllq\007vpsllvd\007vpsllvq\007"
    "vpsllvw\006vpsllw\006vpsrad\006vpsraq\007vpsravd\007vpsravq\007vpsravw\006"
    "vpsraw\006vpsrld\007vpsrldq\006vpsrlq\007vpsrlvd\007vpsrlvq\007vpsrlvw\006"
    "vpsrlw\006vpsubb\006vpsubd\006vpsubq\007vpsubsb\007vpsubsw\010vpsubusb\010"
    "vpsubusw\006vpsubw\nvpternlogd\nvpternlogq\006vptest\010vptestmb\010vpt"
    "estmd\010vptestmq\010vptestmw\tvptestnmb\tvptestnmd\tvptestnmq\tvptestn"
    "mw\nvpunpckhbw\nvpunpckhdq\013vpunpckhqdq\nvpunpckhwd\nvpunpcklbw\nvpun"
    "pckldq\013vpunpcklqdq\nvpunpcklwd\005vpxor\006vpxord\006vpxorq\010vrang"
    "epd\010vrangeps\010vrangesd\010vrangess\010vrcp14pd\010vrcp14ps\010vrcp"
    "14sd\010vrcp14ss\010vrcp28pd\010vrcp28ps\010vrcp28sd\010vrcp28ss\006vrc"
    "pph\006vrcpps\006vrcpsh\006vrcpss\tvreducepd\tvreduceph\tvreduceps\tvre"
    "ducesd\tvreducesh\tvreducess\013vrndscalepd\013vrndscaleph\013vrndscale"
    "ps\013vrndscalesd\013vrndscalesh\013vrndscaless\010vroundpd\010vroundps"
    "\010vroundsd\010vroundss\nvrsqrt14pd\nvrsqrt14ps\nvrsqrt14sd\nvrsqrt14s"
    "s\nvrsqrt28pd\nvrsqrt28ps\nvrsqrt28sd\nvrsqrt28ss\010vrsqrtph\010vrsqrt"
    "ps\010vrsqrtsh\010vrsqrtss\tvscalefpd\tvscalefph\tvscalefps\tvscalefsd\t"
    "vscalefsh\tvscalefss\013vscatterdpd\013vscatterdps\016vscatterpf0dpd\016"
    "vscatterpf0dps\016vscatterpf0qpd\016vscatterpf0qps\016vscatterpf1dpd\016"
    "vscatterpf1dps\016vscatterpf1qpd\016vscatterpf1qps\013vscatterqpd\013vs"
    "catterqps\013vsha512msg1\013vsha512msg2\014vsha512rnds2\nvshuff32x4\nvs"
    "huff64x2\nvshufi32x4\nvshufi64x2\007vshufpd\007vshufps\010vsm3msg1\010v"
    "sm3msg2\tvsm3rnds2\010vsm4key4\tvsm4rnds4\007vsqrtpd\007vsqrtph\007vsqr"
    "tps\007vsqrtsd\007vsqrtsh\007vsqrtss\010vstmxcsr\006vsubpd\006vsubph\006"
    "vsubps\006vsubsd\006vsubsh\006vsubss\007vtestpd\007vtestps\010vucomisd\010"
    "vucomish\010vucomiss\tvunpckhpd\tvunpckhps\tvunpcklpd\tvunpcklps\006vxo"
    "rpd\006vxorps\010vzeroall\nvzeroupper\004wait\006wbinvd\010wbnoinvd\010"
    "wrfsbase\twrfsbasel\twrfsbaseq\010wrgsbase\twrgsbasel\twrgsbaseq\005wrm"
    "sr\twrmsrlist\007wrmsrns\006wrpkru\005wrssd\005wrssq\006wrussd\006wruss"
    "q\006xabort\010xacquire\004xadd\005xaddb\005xaddl\005xaddq\005xaddw\006"
    "xbegin\004xchg\005xchgb\005xchgl\005xchgq\005xchgw\txcryptcbc\txcryptcf"
    "b\txcryptctr\txcryptecb\txcryptofb\004xend\006xgetbv\005xlatb\003xor\004"
    "xorb\004xorl\005xorpd\005xorps\004xorq\004xorw\010xrelease\txresldtrk\006"
    "xrstor\010xrstor64\007xrstors\txrstors64\005xsave\007xsave64\006xsavec\010"
    "xsavec64\010xsaveopt\nxsaveopt64\006xsaves\010xsaves64\006xsetbv\005xsh"
    "a1\007xsha256\006xstore\txstorerng\txsusldtrk\005xtest";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_In16BitMode,
  AMFBS_In32BitMode,
  AMFBS_In64BitMode,
  AMFBS_Not16BitMode,
  AMFBS_Not64BitMode,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_In16BitModeBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_Not16BitModeBit, },
  {Feature_Not64BitModeBit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[9];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* aaa */, X86::AAA, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__imm_95_10, AMFBS_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 13 /* aaddl */, X86::AADD32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 19 /* aaddq */, X86::AADD64mr, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 25 /* aam */, X86::AAM8i8, Convert__imm_95_10, AMFBS_Not64BitMode, {  }, },
  { 25 /* aam */, X86::AAM8i8, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 34 /* aandl */, X86::AAND32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 40 /* aandq */, X86::AAND64mr, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 46 /* aas */, X86::AAS, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 54 /* adcb */, X86::ADC8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 54 /* adcb */, X86::ADC8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 54 /* adcb */, X86::ADC8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 54 /* adcb */, X86::ADC8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 54 /* adcb */, X86::ADC8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 54 /* adcb */, X86::ADC8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 59 /* adcl */, X86::ADC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 59 /* adcl */, X86::ADC32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 59 /* adcl */, X86::ADC32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 59 /* adcl */, X86::ADC32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 59 /* adcl */, X86::ADC32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 59 /* adcl */, X86::ADC32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 59 /* adcl */, X86::ADC32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 59 /* adcl */, X86::ADC32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 59 /* adcl */, X86::ADC32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 64 /* adcq */, X86::ADC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 64 /* adcq */, X86::ADC64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 64 /* adcq */, X86::ADC64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 64 /* adcq */, X86::ADC64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 64 /* adcq */, X86::ADC64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 64 /* adcq */, X86::ADC64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 64 /* adcq */, X86::ADC64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 64 /* adcq */, X86::ADC64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 64 /* adcq */, X86::ADC64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 69 /* adcw */, X86::ADC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 69 /* adcw */, X86::ADC16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 69 /* adcw */, X86::ADC16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 69 /* adcw */, X86::ADC16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 69 /* adcw */, X86::ADC16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 69 /* adcw */, X86::ADC16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 69 /* adcw */, X86::ADC16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 69 /* adcw */, X86::ADC16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 69 /* adcw */, X86::ADC16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 79 /* adcxl */, X86::ADCX32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 79 /* adcxl */, X86::ADCX32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 85 /* adcxq */, X86::ADCX64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 85 /* adcxq */, X86::ADCX64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 95 /* addb */, X86::ADD8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 95 /* addb */, X86::ADD8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 95 /* addb */, X86::ADD8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 95 /* addb */, X86::ADD8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 95 /* addb */, X86::ADD8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 95 /* addb */, X86::ADD8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 100 /* addl */, X86::ADD32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 100 /* addl */, X86::ADD32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 100 /* addl */, X86::ADD32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 100 /* addl */, X86::ADD32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 100 /* addl */, X86::ADD32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 100 /* addl */, X86::ADD32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 100 /* addl */, X86::ADD32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 100 /* addl */, X86::ADD32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 100 /* addl */, X86::ADD32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 105 /* addpd */, X86::ADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 105 /* addpd */, X86::ADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 111 /* addps */, X86::ADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 111 /* addps */, X86::ADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 117 /* addq */, X86::ADD64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 117 /* addq */, X86::ADD64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 117 /* addq */, X86::ADD64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 117 /* addq */, X86::ADD64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 117 /* addq */, X86::ADD64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 117 /* addq */, X86::ADD64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 117 /* addq */, X86::ADD64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 117 /* addq */, X86::ADD64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 117 /* addq */, X86::ADD64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 122 /* addr16 */, X86::ADDR16_PREFIX, Convert_NoOperands, AMFBS_In32BitMode, {  }, },
  { 129 /* addr32 */, X86::ADDR32_PREFIX, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 136 /* addsd */, X86::ADDSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 136 /* addsd */, X86::ADDSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 142 /* addss */, X86::ADDSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 142 /* addss */, X86::ADDSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 148 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 148 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 157 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 157 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 166 /* addw */, X86::ADD16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 166 /* addw */, X86::ADD16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 166 /* addw */, X86::ADD16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 166 /* addw */, X86::ADD16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 166 /* addw */, X86::ADD16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 166 /* addw */, X86::ADD16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 166 /* addw */, X86::ADD16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 166 /* addw */, X86::ADD16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 166 /* addw */, X86::ADD16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 176 /* adoxl */, X86::ADOX32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 176 /* adoxl */, X86::ADOX32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 182 /* adoxq */, X86::ADOX64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 182 /* adoxq */, X86::ADOX64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 188 /* aesdec */, X86::AESDECrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 188 /* aesdec */, X86::AESDECrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 195 /* aesdec128kl */, X86::AESDEC128KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 207 /* aesdec256kl */, X86::AESDEC256KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 219 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 219 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 230 /* aesdecwide128kl */, X86::AESDECWIDE128KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 246 /* aesdecwide256kl */, X86::AESDECWIDE256KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 262 /* aesenc */, X86::AESENCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 262 /* aesenc */, X86::AESENCrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 269 /* aesenc128kl */, X86::AESENC128KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 281 /* aesenc256kl */, X86::AESENC256KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 293 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 293 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 304 /* aesencwide128kl */, X86::AESENCWIDE128KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 320 /* aesencwide256kl */, X86::AESENCWIDE256KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 336 /* aesimc */, X86::AESIMCrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 336 /* aesimc */, X86::AESIMCrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 343 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 343 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 363 /* andb */, X86::AND8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 363 /* andb */, X86::AND8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 363 /* andb */, X86::AND8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 363 /* andb */, X86::AND8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 363 /* andb */, X86::AND8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 363 /* andb */, X86::AND8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 368 /* andl */, X86::AND32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 368 /* andl */, X86::AND32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 368 /* andl */, X86::AND32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 368 /* andl */, X86::AND32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 368 /* andl */, X86::AND32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 368 /* andl */, X86::AND32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 368 /* andl */, X86::AND32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 368 /* andl */, X86::AND32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 368 /* andl */, X86::AND32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 378 /* andnl */, X86::ANDN32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 378 /* andnl */, X86::ANDN32rm, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 384 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 384 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 391 /* andnps */, X86::ANDNPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 391 /* andnps */, X86::ANDNPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 398 /* andnq */, X86::ANDN64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 398 /* andnq */, X86::ANDN64rm, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 404 /* andpd */, X86::ANDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 404 /* andpd */, X86::ANDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 410 /* andps */, X86::ANDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 410 /* andps */, X86::ANDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 416 /* andq */, X86::AND64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 416 /* andq */, X86::AND64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 416 /* andq */, X86::AND64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 416 /* andq */, X86::AND64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 416 /* andq */, X86::AND64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 416 /* andq */, X86::AND64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 416 /* andq */, X86::AND64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 416 /* andq */, X86::AND64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 416 /* andq */, X86::AND64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 421 /* andw */, X86::AND16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 421 /* andw */, X86::AND16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 421 /* andw */, X86::AND16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 421 /* andw */, X86::AND16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 421 /* andw */, X86::AND16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 421 /* andw */, X86::AND16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 421 /* andw */, X86::AND16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 421 /* andw */, X86::AND16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 421 /* andw */, X86::AND16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 430 /* aorl */, X86::AOR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 435 /* aorq */, X86::AOR64mr, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 440 /* arpl */, X86::ARPL16rr, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 440 /* arpl */, X86::ARPL16mr, Convert__Mem165_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 450 /* axorl */, X86::AXOR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 456 /* axorq */, X86::AXOR64mr, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 468 /* bextrl */, X86::BEXTR32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 468 /* bextrl */, X86::BEXTR32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 468 /* bextrl */, X86::BEXTRI32ri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 468 /* bextrl */, X86::BEXTRI32mi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 475 /* bextrq */, X86::BEXTR64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 475 /* bextrq */, X86::BEXTR64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 475 /* bextrq */, X86::BEXTRI64ri, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 475 /* bextrq */, X86::BEXTRI64mi, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 490 /* blcfilll */, X86::BLCFILL32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 490 /* blcfilll */, X86::BLCFILL32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 499 /* blcfillq */, X86::BLCFILL64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 499 /* blcfillq */, X86::BLCFILL64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 519 /* blcicl */, X86::BLCIC32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 519 /* blcicl */, X86::BLCIC32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 526 /* blcicq */, X86::BLCIC64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 526 /* blcicq */, X86::BLCIC64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 533 /* blcil */, X86::BLCI32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 533 /* blcil */, X86::BLCI32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 539 /* blciq */, X86::BLCI64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 539 /* blciq */, X86::BLCI64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 552 /* blcmskl */, X86::BLCMSK32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 552 /* blcmskl */, X86::BLCMSK32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 560 /* blcmskq */, X86::BLCMSK64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 560 /* blcmskq */, X86::BLCMSK64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 573 /* blcsl */, X86::BLCS32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 573 /* blcsl */, X86::BLCS32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 579 /* blcsq */, X86::BLCS64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 579 /* blcsq */, X86::BLCS64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 585 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 585 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 593 /* blendps */, X86::BLENDPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 593 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 601 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 601 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 601 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 601 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 610 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 610 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 610 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 610 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 627 /* blsfilll */, X86::BLSFILL32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 627 /* blsfilll */, X86::BLSFILL32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 636 /* blsfillq */, X86::BLSFILL64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 636 /* blsfillq */, X86::BLSFILL64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 656 /* blsicl */, X86::BLSIC32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 656 /* blsicl */, X86::BLSIC32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 663 /* blsicq */, X86::BLSIC64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 663 /* blsicq */, X86::BLSIC64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 670 /* blsil */, X86::BLSI32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 670 /* blsil */, X86::BLSI32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 676 /* blsiq */, X86::BLSI64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 676 /* blsiq */, X86::BLSI64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 689 /* blsmskl */, X86::BLSMSK32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 689 /* blsmskl */, X86::BLSMSK32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 697 /* blsmskq */, X86::BLSMSK64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 697 /* blsmskq */, X86::BLSMSK64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 710 /* blsrl */, X86::BLSR32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 710 /* blsrl */, X86::BLSR32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 716 /* blsrq */, X86::BLSR64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 716 /* blsrq */, X86::BLSR64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 722 /* bound */, X86::BOUNDS16rm, Convert__Reg1_0__Mem165_1, AMFBS_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 722 /* bound */, X86::BOUNDS32rm, Convert__Reg1_0__Mem325_1, AMFBS_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 732 /* bsfl */, X86::BSF32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 732 /* bsfl */, X86::BSF32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 737 /* bsfq */, X86::BSF64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 737 /* bsfq */, X86::BSF64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 742 /* bsfw */, X86::BSF16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 742 /* bsfw */, X86::BSF16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 751 /* bsrl */, X86::BSR32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 751 /* bsrl */, X86::BSR32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 756 /* bsrq */, X86::BSR64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 756 /* bsrq */, X86::BSR64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 761 /* bsrw */, X86::BSR16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 761 /* bsrw */, X86::BSR16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 772 /* bswapl */, X86::BSWAP32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 779 /* bswapq */, X86::BSWAP64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 786 /* bt */, X86::BT32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 789 /* btc */, X86::BTC32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 793 /* btcl */, X86::BTC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 793 /* btcl */, X86::BTC32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 793 /* btcl */, X86::BTC32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 793 /* btcl */, X86::BTC32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 798 /* btcq */, X86::BTC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 798 /* btcq */, X86::BTC64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 798 /* btcq */, X86::BTC64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 798 /* btcq */, X86::BTC64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 803 /* btcw */, X86::BTC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 803 /* btcw */, X86::BTC16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 803 /* btcw */, X86::BTC16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 803 /* btcw */, X86::BTC16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 808 /* btl */, X86::BT32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 808 /* btl */, X86::BT32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 808 /* btl */, X86::BT32ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 808 /* btl */, X86::BT32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 812 /* btq */, X86::BT64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 812 /* btq */, X86::BT64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 812 /* btq */, X86::BT64ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 812 /* btq */, X86::BT64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 816 /* btr */, X86::BTR32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 820 /* btrl */, X86::BTR32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 820 /* btrl */, X86::BTR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 820 /* btrl */, X86::BTR32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 820 /* btrl */, X86::BTR32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 825 /* btrq */, X86::BTR64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 825 /* btrq */, X86::BTR64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 825 /* btrq */, X86::BTR64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 825 /* btrq */, X86::BTR64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 830 /* btrw */, X86::BTR16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 830 /* btrw */, X86::BTR16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 830 /* btrw */, X86::BTR16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 830 /* btrw */, X86::BTR16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 835 /* bts */, X86::BTS32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 839 /* btsl */, X86::BTS32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 839 /* btsl */, X86::BTS32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 839 /* btsl */, X86::BTS32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 839 /* btsl */, X86::BTS32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 844 /* btsq */, X86::BTS64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 844 /* btsq */, X86::BTS64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 844 /* btsq */, X86::BTS64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 844 /* btsq */, X86::BTS64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 849 /* btsw */, X86::BTS16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 849 /* btsw */, X86::BTS16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 849 /* btsw */, X86::BTS16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 849 /* btsw */, X86::BTS16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 854 /* btw */, X86::BT16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 854 /* btw */, X86::BT16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 854 /* btw */, X86::BT16ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 854 /* btw */, X86::BT16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 863 /* bzhil */, X86::BZHI32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 863 /* bzhil */, X86::BZHI32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 869 /* bzhiq */, X86::BZHI64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 869 /* bzhiq */, X86::BZHI64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 875 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 875 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 880 /* calll */, X86::CALLpcrel32, Convert__AbsMem1_0, AMFBS_Not64BitMode, { MCK_AbsMem }, },
  { 880 /* calll */, X86::CALL32r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 880 /* calll */, X86::CALL32m, Convert__Mem325_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 880 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 886 /* callq */, X86::CALL64pcrel32, Convert__AbsMem1_0, AMFBS_In64BitMode, { MCK_AbsMem }, },
  { 886 /* callq */, X86::CALL64r, Convert__Reg1_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 886 /* callq */, X86::CALL64m, Convert__Mem645_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 892 /* callw */, X86::CALLpcrel16, Convert__AbsMem1_0, AMFBS_Not64BitMode, { MCK_AbsMem }, },
  { 892 /* callw */, X86::CALL16r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 892 /* callw */, X86::CALL16m, Convert__Mem165_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 892 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 898 /* cbtw */, X86::CBW, Convert_NoOperands, AMFBS_None, {  }, },
  { 916 /* clac */, X86::CLAC, Convert_NoOperands, AMFBS_None, {  }, },
  { 921 /* clc */, X86::CLC, Convert_NoOperands, AMFBS_None, {  }, },
  { 925 /* cld */, X86::CLD, Convert_NoOperands, AMFBS_None, {  }, },
  { 929 /* cldemote */, X86::CLDEMOTE, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 938 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 946 /* clflushopt */, X86::CLFLUSHOPT, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 957 /* clgi */, X86::CLGI, Convert_NoOperands, AMFBS_None, {  }, },
  { 962 /* cli */, X86::CLI, Convert_NoOperands, AMFBS_None, {  }, },
  { 970 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 975 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 980 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 985 /* clrssbsy */, X86::CLRSSBSY, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 994 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 999 /* cltd */, X86::CDQ, Convert_NoOperands, AMFBS_None, {  }, },
  { 1004 /* cltq */, X86::CDQE, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 1009 /* clts */, X86::CLTS, Convert_NoOperands, AMFBS_None, {  }, },
  { 1014 /* clui */, X86::CLUI, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 1019 /* clwb */, X86::CLWB, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 1024 /* clzero */, X86::CLZERO32r, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 1024 /* clzero */, X86::CLZERO64r, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 1024 /* clzero */, X86::CLZERO32r, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX }, },
  { 1024 /* clzero */, X86::CLZERO64r, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX }, },
  { 1031 /* cmc */, X86::CMC, Convert_NoOperands, AMFBS_None, {  }, },
  { 1048 /* cmovael */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1048 /* cmovael */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1056 /* cmovaeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1056 /* cmovaeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1064 /* cmovaew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1064 /* cmovaew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1072 /* cmoval */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1072 /* cmoval */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1079 /* cmovaq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1079 /* cmovaq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1086 /* cmovaw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1086 /* cmovaw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1106 /* cmovbel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1106 /* cmovbel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1114 /* cmovbeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1114 /* cmovbeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1122 /* cmovbew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1122 /* cmovbew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1130 /* cmovbl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1130 /* cmovbl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1137 /* cmovbq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1137 /* cmovbq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1144 /* cmovbw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1144 /* cmovbw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1157 /* cmovel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1157 /* cmovel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1164 /* cmoveq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1164 /* cmoveq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1171 /* cmovew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1171 /* cmovew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1191 /* cmovgel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1191 /* cmovgel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1199 /* cmovgeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1199 /* cmovgeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1207 /* cmovgew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1207 /* cmovgew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1215 /* cmovgl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1215 /* cmovgl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1222 /* cmovgq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1222 /* cmovgq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1229 /* cmovgw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1229 /* cmovgw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1249 /* cmovlel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1249 /* cmovlel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1257 /* cmovleq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1257 /* cmovleq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1265 /* cmovlew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1265 /* cmovlew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1273 /* cmovll */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1273 /* cmovll */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1280 /* cmovlq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1280 /* cmovlq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1287 /* cmovlw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1287 /* cmovlw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1301 /* cmovnel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1301 /* cmovnel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1309 /* cmovneq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1309 /* cmovneq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1317 /* cmovnew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1317 /* cmovnew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1332 /* cmovnol */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1332 /* cmovnol */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1340 /* cmovnoq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1340 /* cmovnoq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1348 /* cmovnow */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1348 /* cmovnow */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1363 /* cmovnpl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1363 /* cmovnpl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1371 /* cmovnpq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1371 /* cmovnpq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1379 /* cmovnpw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1379 /* cmovnpw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1394 /* cmovnsl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1394 /* cmovnsl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1402 /* cmovnsq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1402 /* cmovnsq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1410 /* cmovnsw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1410 /* cmovnsw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1424 /* cmovol */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1424 /* cmovol */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1431 /* cmovoq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1431 /* cmovoq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1438 /* cmovow */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1438 /* cmovow */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1451 /* cmovpl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1451 /* cmovpl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1458 /* cmovpq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1458 /* cmovpq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1465 /* cmovpw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1465 /* cmovpw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1478 /* cmovsl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1478 /* cmovsl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1485 /* cmovsq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1485 /* cmovsq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1492 /* cmovsw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1492 /* cmovsw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1503 /* cmpaexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1503 /* cmpaexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1513 /* cmpaxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1513 /* cmpaxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1522 /* cmpb */, X86::CMP8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 1522 /* cmpb */, X86::CMP8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 1522 /* cmpb */, X86::CMP8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 1522 /* cmpb */, X86::CMP8ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 1522 /* cmpb */, X86::CMP8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 1522 /* cmpb */, X86::CMP8rm, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 1527 /* cmpbexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1527 /* cmpbexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1537 /* cmpbxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1537 /* cmpbxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1546 /* cmpexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1546 /* cmpexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1555 /* cmpgexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1555 /* cmpgexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1565 /* cmpgxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1565 /* cmpgxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1574 /* cmpl */, X86::CMP32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1574 /* cmpl */, X86::CMP32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 1574 /* cmpl */, X86::CMP32ri8, Convert__regEAX__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 1574 /* cmpl */, X86::CMP32ri8, Convert__Reg1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1574 /* cmpl */, X86::CMP32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1574 /* cmpl */, X86::CMP32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 1574 /* cmpl */, X86::CMP32ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 1574 /* cmpl */, X86::CMP32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 1574 /* cmpl */, X86::CMP32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1579 /* cmplexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1579 /* cmplexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1589 /* cmplxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1589 /* cmplxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1598 /* cmpnbexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1598 /* cmpnbexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1609 /* cmpnbxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1609 /* cmpnbxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1619 /* cmpnexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1619 /* cmpnexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1629 /* cmpnlexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1629 /* cmpnlexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1640 /* cmpnlxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1640 /* cmpnlxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1650 /* cmpnoxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1650 /* cmpnoxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1660 /* cmpnpxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1660 /* cmpnpxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1670 /* cmpnsxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1670 /* cmpnsxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1680 /* cmpnzxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1680 /* cmpnzxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1690 /* cmpoxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1690 /* cmpoxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1699 /* cmppd */, X86::CMPPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 1699 /* cmppd */, X86::CMPPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 1705 /* cmpps */, X86::CMPPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 1705 /* cmpps */, X86::CMPPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 1711 /* cmppxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1711 /* cmppxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1720 /* cmpq */, X86::CMP64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1720 /* cmpq */, X86::CMP64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 1720 /* cmpq */, X86::CMP64ri8, Convert__regRAX__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 1720 /* cmpq */, X86::CMP64ri8, Convert__Reg1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1720 /* cmpq */, X86::CMP64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1720 /* cmpq */, X86::CMP64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 1720 /* cmpq */, X86::CMP64ri32, Convert__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1720 /* cmpq */, X86::CMP64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1720 /* cmpq */, X86::CMP64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1730 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_0__SrcIdx82_1, AMFBS_None, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 1736 /* cmpsd */, X86::CMPSDrr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 1736 /* cmpsd */, X86::CMPSDrm_Int, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16 }, },
  { 1742 /* cmpsl */, X86::CMPSL, Convert__DstIdx321_0__SrcIdx322_1, AMFBS_None, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 1748 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_0__SrcIdx642_1, AMFBS_In64BitMode, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 1754 /* cmpss */, X86::CMPSSrr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 1754 /* cmpss */, X86::CMPSSrm_Int, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16 }, },
  { 1760 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_0__SrcIdx162_1, AMFBS_None, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 1766 /* cmpsxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1766 /* cmpsxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1775 /* cmpw */, X86::CMP16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1775 /* cmpw */, X86::CMP16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 1775 /* cmpw */, X86::CMP16ri8, Convert__regAX__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 1775 /* cmpw */, X86::CMP16ri8, Convert__Reg1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1775 /* cmpw */, X86::CMP16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1775 /* cmpw */, X86::CMP16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 1775 /* cmpw */, X86::CMP16ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 1775 /* cmpw */, X86::CMP16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 1775 /* cmpw */, X86::CMP16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 1788 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, AMFBS_In64BitMode, { MCK_Mem128 }, },
  { 1799 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 1809 /* cmpxchgb */, X86::CMPXCHG8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 1809 /* cmpxchgb */, X86::CMPXCHG8rm, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 1818 /* cmpxchgl */, X86::CMPXCHG32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1818 /* cmpxchgl */, X86::CMPXCHG32rm, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 1827 /* cmpxchgq */, X86::CMPXCHG64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1827 /* cmpxchgq */, X86::CMPXCHG64rm, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 1836 /* cmpxchgw */, X86::CMPXCHG16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 1836 /* cmpxchgw */, X86::CMPXCHG16rm, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 1845 /* cmpzxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 1845 /* cmpzxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 1854 /* comisd */, X86::COMISDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1854 /* comisd */, X86::COMISDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 1861 /* comiss */, X86::COMISSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1861 /* comiss */, X86::COMISSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 1868 /* cpuid */, X86::CPUID, Convert_NoOperands, AMFBS_None, {  }, },
  { 1878 /* cqto */, X86::CQO, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 1889 /* crc32b */, X86::CRC32r32r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 1889 /* crc32b */, X86::CRC32r64r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 1889 /* crc32b */, X86::CRC32r32m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR32 }, },
  { 1889 /* crc32b */, X86::CRC32r64m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR64 }, },
  { 1896 /* crc32l */, X86::CRC32r32r32, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 1896 /* crc32l */, X86::CRC32r32m32, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 1903 /* crc32q */, X86::CRC32r64r64, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1903 /* crc32q */, X86::CRC32r64m64, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 1910 /* crc32w */, X86::CRC32r32r16, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 1910 /* crc32w */, X86::CRC32r32m16, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 1917 /* cs */, X86::CS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 1920 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1920 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 1929 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1929 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 1938 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1938 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 1947 /* cvtpd2pi */, X86::MMX_CVTPD2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 1947 /* cvtpd2pi */, X86::MMX_CVTPD2PIrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR64 }, },
  { 1956 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1956 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 1965 /* cvtpi2pd */, X86::MMX_CVTPI2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_FR16 }, },
  { 1965 /* cvtpi2pd */, X86::MMX_CVTPI2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 1974 /* cvtpi2ps */, X86::MMX_CVTPI2PSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_FR16 }, },
  { 1974 /* cvtpi2ps */, X86::MMX_CVTPI2PSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 1983 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1983 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 1992 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 1992 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 2001 /* cvtps2pi */, X86::MMX_CVTPS2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 2001 /* cvtps2pi */, X86::MMX_CVTPS2PIrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 2010 /* cvtsd2si */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2010 /* cvtsd2si */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2010 /* cvtsd2si */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 2010 /* cvtsd2si */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2019 /* cvtsd2sil */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2019 /* cvtsd2sil */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 2029 /* cvtsd2siq */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2029 /* cvtsd2siq */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2039 /* cvtsd2ss */, X86::CVTSD2SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2039 /* cvtsd2ss */, X86::CVTSD2SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 2048 /* cvtsi2sd */, X86::CVTSI2SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 2048 /* cvtsi2sd */, X86::CVTSI642SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 2048 /* cvtsi2sd */, X86::CVTSI2SDrm_Int, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2057 /* cvtsi2sdl */, X86::CVTSI2SDrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 2057 /* cvtsi2sdl */, X86::CVTSI2SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2067 /* cvtsi2sdq */, X86::CVTSI642SDrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 2067 /* cvtsi2sdq */, X86::CVTSI642SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 2077 /* cvtsi2ss */, X86::CVTSI2SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 2077 /* cvtsi2ss */, X86::CVTSI642SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 2077 /* cvtsi2ss */, X86::CVTSI2SSrm_Int, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2086 /* cvtsi2ssl */, X86::CVTSI2SSrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 2086 /* cvtsi2ssl */, X86::CVTSI2SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2096 /* cvtsi2ssq */, X86::CVTSI642SSrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 2096 /* cvtsi2ssq */, X86::CVTSI642SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 2106 /* cvtss2sd */, X86::CVTSS2SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2106 /* cvtss2sd */, X86::CVTSS2SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2115 /* cvtss2si */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2115 /* cvtss2si */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2115 /* cvtss2si */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2115 /* cvtss2si */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 2124 /* cvtss2sil */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2124 /* cvtss2sil */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2134 /* cvtss2siq */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2134 /* cvtss2siq */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 2144 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2144 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 2154 /* cvttpd2pi */, X86::MMX_CVTTPD2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 2154 /* cvttpd2pi */, X86::MMX_CVTTPD2PIrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR64 }, },
  { 2164 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2164 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 2174 /* cvttps2pi */, X86::MMX_CVTTPS2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 2174 /* cvttps2pi */, X86::MMX_CVTTPS2PIrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 2184 /* cvttsd2si */, X86::CVTTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2184 /* cvttsd2si */, X86::CVTTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2184 /* cvttsd2si */, X86::CVTTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 2184 /* cvttsd2si */, X86::CVTTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2194 /* cvttsd2sil */, X86::CVTTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2194 /* cvttsd2sil */, X86::CVTTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 2205 /* cvttsd2siq */, X86::CVTTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2205 /* cvttsd2siq */, X86::CVTTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2216 /* cvttss2si */, X86::CVTTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2216 /* cvttss2si */, X86::CVTTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2216 /* cvttss2si */, X86::CVTTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2216 /* cvttss2si */, X86::CVTTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 2226 /* cvttss2sil */, X86::CVTTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 2226 /* cvttss2sil */, X86::CVTTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2237 /* cvttss2siq */, X86::CVTTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 2237 /* cvttss2siq */, X86::CVTTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 2257 /* cwtd */, X86::CWD, Convert_NoOperands, AMFBS_None, {  }, },
  { 2262 /* cwtl */, X86::CWDE, Convert_NoOperands, AMFBS_None, {  }, },
  { 2267 /* daa */, X86::DAA, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 2271 /* das */, X86::DAS, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 2275 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 2286 /* decb */, X86::DEC8r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 2286 /* decb */, X86::DEC8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2291 /* decl */, X86::DEC32r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 2291 /* decl */, X86::DEC32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 2291 /* decl */, X86::DEC32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2296 /* decq */, X86::DEC64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 2296 /* decq */, X86::DEC64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 2301 /* decw */, X86::DEC16r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR16 }, },
  { 2301 /* decw */, X86::DEC16r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 2301 /* decw */, X86::DEC16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2310 /* divb */, X86::DIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 2310 /* divb */, X86::DIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2310 /* divb */, X86::DIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8, MCK_AL }, },
  { 2310 /* divb */, X86::DIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_AL }, },
  { 2315 /* divl */, X86::DIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 2315 /* divl */, X86::DIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2315 /* divl */, X86::DIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32, MCK_EAX }, },
  { 2315 /* divl */, X86::DIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_EAX }, },
  { 2320 /* divpd */, X86::DIVPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2320 /* divpd */, X86::DIVPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 2326 /* divps */, X86::DIVPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2326 /* divps */, X86::DIVPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 2332 /* divq */, X86::DIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 2332 /* divq */, X86::DIV64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 2332 /* divq */, X86::DIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64, MCK_RAX }, },
  { 2332 /* divq */, X86::DIV64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_RAX }, },
  { 2337 /* divsd */, X86::DIVSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2337 /* divsd */, X86::DIVSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 2343 /* divss */, X86::DIVSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2343 /* divss */, X86::DIVSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 2349 /* divw */, X86::DIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 2349 /* divw */, X86::DIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2349 /* divw */, X86::DIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16, MCK_AX }, },
  { 2349 /* divw */, X86::DIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_AX }, },
  { 2354 /* dppd */, X86::DPPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 2354 /* dppd */, X86::DPPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 2359 /* dpps */, X86::DPPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 2359 /* dpps */, X86::DPPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 2364 /* ds */, X86::DS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 2367 /* emms */, X86::MMX_EMMS, Convert_NoOperands, AMFBS_None, {  }, },
  { 2372 /* encls */, X86::ENCLS, Convert_NoOperands, AMFBS_None, {  }, },
  { 2378 /* enclu */, X86::ENCLU, Convert_NoOperands, AMFBS_None, {  }, },
  { 2384 /* enclv */, X86::ENCLV, Convert_NoOperands, AMFBS_None, {  }, },
  { 2390 /* encodekey128 */, X86::ENCODEKEY128, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2403 /* encodekey256 */, X86::ENCODEKEY256, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2416 /* endbr32 */, X86::ENDBR32, Convert_NoOperands, AMFBS_None, {  }, },
  { 2424 /* endbr64 */, X86::ENDBR64, Convert_NoOperands, AMFBS_None, {  }, },
  { 2432 /* enqcmd */, X86::ENQCMD16, Convert__Reg1_1__Mem5125_0, AMFBS_Not64BitMode, { MCK_Mem512, MCK_GR16 }, },
  { 2432 /* enqcmd */, X86::ENQCMD32, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_GR32 }, },
  { 2432 /* enqcmd */, X86::ENQCMD64, Convert__Reg1_1__Mem5125_0, AMFBS_In64BitMode, { MCK_Mem512, MCK_GR64 }, },
  { 2439 /* enqcmds */, X86::ENQCMDS16, Convert__Reg1_1__Mem5125_0, AMFBS_Not64BitMode, { MCK_Mem512, MCK_GR16 }, },
  { 2439 /* enqcmds */, X86::ENQCMDS32, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_GR32 }, },
  { 2439 /* enqcmds */, X86::ENQCMDS64, Convert__Reg1_1__Mem5125_0, AMFBS_In64BitMode, { MCK_Mem512, MCK_GR64 }, },
  { 2447 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 2453 /* es */, X86::ES_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 2456 /* extractps */, X86::EXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR32orGR64 }, },
  { 2456 /* extractps */, X86::EXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem32 }, },
  { 2466 /* extrq */, X86::EXTRQ, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 2466 /* extrq */, X86::EXTRQI, Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 2472 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, AMFBS_None, {  }, },
  { 2478 /* fabs */, X86::ABS_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 2483 /* fadd */, X86::ADD_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 2483 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2483 /* fadd */, X86::ADD_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2483 /* fadd */, X86::ADD_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2483 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2488 /* faddl */, X86::ADD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2494 /* faddp */, X86::ADD_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 2494 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2494 /* faddp */, X86::ADD_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2494 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2494 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2500 /* fadds */, X86::ADD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2506 /* fbld */, X86::FBLDm, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 2511 /* fbstp */, X86::FBSTPm, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 2517 /* fchs */, X86::CHS_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 2522 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2529 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2537 /* fcmove */, X86::CMOVE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2544 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2552 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2561 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2569 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2577 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2584 /* fcom */, X86::COM_FST0r, Convert__regST1, AMFBS_None, {  }, },
  { 2584 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2589 /* fcomi */, X86::COM_FIr, Convert__regST1, AMFBS_None, {  }, },
  { 2589 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2589 /* fcomi */, X86::COM_FIr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2589 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2595 /* fcoml */, X86::FCOM64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2601 /* fcomp */, X86::COMP_FST0r, Convert__regST1, AMFBS_None, {  }, },
  { 2601 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2607 /* fcompi */, X86::COM_FIPr, Convert__regST1, AMFBS_None, {  }, },
  { 2607 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2607 /* fcompi */, X86::COM_FIPr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2607 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2614 /* fcompl */, X86::FCOMP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2621 /* fcompp */, X86::FCOMPP, Convert_NoOperands, AMFBS_None, {  }, },
  { 2628 /* fcomps */, X86::FCOMP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2635 /* fcoms */, X86::FCOM32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2641 /* fcos */, X86::FCOS, Convert_NoOperands, AMFBS_None, {  }, },
  { 2646 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, AMFBS_None, {  }, },
  { 2654 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2654 /* fdiv */, X86::DIV_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2654 /* fdiv */, X86::DIVR_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2654 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2659 /* fdivl */, X86::DIV_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2665 /* fdivp */, X86::DIVR_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 2665 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2665 /* fdivp */, X86::DIVR_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2665 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2665 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2671 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2671 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2671 /* fdivr */, X86::DIV_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2671 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2677 /* fdivrl */, X86::DIVR_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2684 /* fdivrp */, X86::DIV_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 2684 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2684 /* fdivrp */, X86::DIV_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 2684 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 2684 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 2691 /* fdivrs */, X86::DIVR_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2698 /* fdivs */, X86::DIV_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2704 /* femms */, X86::FEMMS, Convert_NoOperands, AMFBS_None, {  }, },
  { 2710 /* ffree */, X86::FFREE, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2716 /* ffreep */, X86::FFREEP, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 2729 /* fiaddl */, X86::ADD_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2736 /* fiadds */, X86::ADD_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2749 /* ficoml */, X86::FICOM32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2763 /* ficompl */, X86::FICOMP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2771 /* ficomps */, X86::FICOMP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2779 /* ficoms */, X86::FICOM16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2792 /* fidivl */, X86::DIV_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2806 /* fidivrl */, X86::DIVR_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2814 /* fidivrs */, X86::DIVR_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2822 /* fidivs */, X86::DIV_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2834 /* fildl */, X86::ILD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2840 /* fildll */, X86::ILD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2847 /* filds */, X86::ILD_F16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2859 /* fimull */, X86::MUL_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2866 /* fimuls */, X86::MUL_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2873 /* fincstp */, X86::FINCSTP, Convert_NoOperands, AMFBS_None, {  }, },
  { 2886 /* fistl */, X86::IST_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2898 /* fistpl */, X86::IST_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2905 /* fistpll */, X86::IST_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2913 /* fistps */, X86::IST_FP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2920 /* fists */, X86::IST_F16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2933 /* fisttpl */, X86::ISTT_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2941 /* fisttpll */, X86::ISTT_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 2950 /* fisttps */, X86::ISTT_FP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2964 /* fisubl */, X86::SUB_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2978 /* fisubrl */, X86::SUBR_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2986 /* fisubrs */, X86::SUBR_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 2994 /* fisubs */, X86::SUB_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3001 /* fld */, X86::LD_Frr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3005 /* fld1 */, X86::LD_F1, Convert_NoOperands, AMFBS_None, {  }, },
  { 3010 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3016 /* fldenv */, X86::FLDENVm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3023 /* fldl */, X86::LD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3028 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, AMFBS_None, {  }, },
  { 3035 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, AMFBS_None, {  }, },
  { 3042 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, AMFBS_None, {  }, },
  { 3049 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, AMFBS_None, {  }, },
  { 3056 /* fldpi */, X86::FLDPI, Convert_NoOperands, AMFBS_None, {  }, },
  { 3062 /* flds */, X86::LD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3067 /* fldt */, X86::LD_F80m, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 3072 /* fldz */, X86::LD_F0, Convert_NoOperands, AMFBS_None, {  }, },
  { 3077 /* fmul */, X86::MUL_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 3077 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3077 /* fmul */, X86::MUL_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3077 /* fmul */, X86::MUL_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3077 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3082 /* fmull */, X86::MUL_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3088 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 3088 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3088 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3088 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3088 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3094 /* fmuls */, X86::MUL_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3100 /* fnclex */, X86::FNCLEX, Convert_NoOperands, AMFBS_None, {  }, },
  { 3107 /* fninit */, X86::FNINIT, Convert_NoOperands, AMFBS_None, {  }, },
  { 3114 /* fnop */, X86::FNOP, Convert_NoOperands, AMFBS_None, {  }, },
  { 3119 /* fnsave */, X86::FSAVEm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3126 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3133 /* fnstenv */, X86::FSTENVm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3141 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, AMFBS_None, {  }, },
  { 3141 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, AMFBS_None, { MCK_AX }, },
  { 3141 /* fnstsw */, X86::FNSTSWm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3148 /* fpatan */, X86::FPATAN, Convert_NoOperands, AMFBS_None, {  }, },
  { 3155 /* fprem */, X86::FPREM, Convert_NoOperands, AMFBS_None, {  }, },
  { 3161 /* fprem1 */, X86::FPREM1, Convert_NoOperands, AMFBS_None, {  }, },
  { 3168 /* fptan */, X86::FPTAN, Convert_NoOperands, AMFBS_None, {  }, },
  { 3174 /* frndint */, X86::FRNDINT, Convert_NoOperands, AMFBS_None, {  }, },
  { 3182 /* frstor */, X86::FRSTORm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3189 /* fs */, X86::FS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 3192 /* fscale */, X86::FSCALE, Convert_NoOperands, AMFBS_None, {  }, },
  { 3199 /* fsin */, X86::FSIN, Convert_NoOperands, AMFBS_None, {  }, },
  { 3204 /* fsincos */, X86::FSINCOS, Convert_NoOperands, AMFBS_None, {  }, },
  { 3212 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 3218 /* fst */, X86::ST_Frr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3222 /* fstl */, X86::ST_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3227 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3232 /* fstpl */, X86::ST_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3238 /* fstps */, X86::ST_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3244 /* fstpt */, X86::ST_FP80m, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 3250 /* fsts */, X86::ST_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3255 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3255 /* fsub */, X86::SUB_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3255 /* fsub */, X86::SUBR_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3255 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3260 /* fsubl */, X86::SUB_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3266 /* fsubp */, X86::SUBR_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 3266 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3266 /* fsubp */, X86::SUBR_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3266 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3266 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3272 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3272 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3272 /* fsubr */, X86::SUB_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3272 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3278 /* fsubrl */, X86::SUBR_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3285 /* fsubrp */, X86::SUB_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 3285 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3285 /* fsubrp */, X86::SUB_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3285 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 3285 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3292 /* fsubrs */, X86::SUBR_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3299 /* fsubs */, X86::SUB_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3305 /* ftst */, X86::TST_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 3310 /* fucom */, X86::UCOM_Fr, Convert__regST1, AMFBS_None, {  }, },
  { 3310 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3316 /* fucomi */, X86::UCOM_FIr, Convert__regST1, AMFBS_None, {  }, },
  { 3316 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3316 /* fucomi */, X86::UCOM_FIr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3316 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3323 /* fucomp */, X86::UCOM_FPr, Convert__regST1, AMFBS_None, {  }, },
  { 3323 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3330 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, AMFBS_None, {  }, },
  { 3330 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3330 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 3330 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 3338 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, AMFBS_None, {  }, },
  { 3346 /* fxam */, X86::XAM_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 3351 /* fxch */, X86::XCH_F, Convert__regST1, AMFBS_None, {  }, },
  { 3351 /* fxch */, X86::XCH_F, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 3356 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3364 /* fxrstor64 */, X86::FXRSTOR64, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 3374 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 3381 /* fxsave64 */, X86::FXSAVE64, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 3390 /* fxtract */, X86::FXTRACT, Convert_NoOperands, AMFBS_None, {  }, },
  { 3398 /* fyl2x */, X86::FYL2X, Convert_NoOperands, AMFBS_None, {  }, },
  { 3404 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, AMFBS_None, {  }, },
  { 3412 /* getsec */, X86::GETSEC, Convert_NoOperands, AMFBS_None, {  }, },
  { 3419 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3419 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 3436 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3436 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 3450 /* gf2p8mulb */, X86::GF2P8MULBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3450 /* gf2p8mulb */, X86::GF2P8MULBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 3460 /* gs */, X86::GS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 3463 /* haddpd */, X86::HADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3463 /* haddpd */, X86::HADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 3470 /* haddps */, X86::HADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3470 /* haddps */, X86::HADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 3477 /* hlt */, X86::HLT, Convert_NoOperands, AMFBS_None, {  }, },
  { 3481 /* hreset */, X86::HRESET, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 3488 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3488 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 3495 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3495 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 3507 /* idivb */, X86::IDIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 3507 /* idivb */, X86::IDIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 3507 /* idivb */, X86::IDIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8, MCK_AL }, },
  { 3507 /* idivb */, X86::IDIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_AL }, },
  { 3513 /* idivl */, X86::IDIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 3513 /* idivl */, X86::IDIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3513 /* idivl */, X86::IDIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32, MCK_EAX }, },
  { 3513 /* idivl */, X86::IDIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_EAX }, },
  { 3519 /* idivq */, X86::IDIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 3519 /* idivq */, X86::IDIV64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 3519 /* idivq */, X86::IDIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64, MCK_RAX }, },
  { 3519 /* idivq */, X86::IDIV64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_RAX }, },
  { 3525 /* idivw */, X86::IDIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 3525 /* idivw */, X86::IDIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3525 /* idivw */, X86::IDIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16, MCK_AX }, },
  { 3525 /* idivw */, X86::IDIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_AX }, },
  { 3536 /* imulb */, X86::IMUL8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 3536 /* imulb */, X86::IMUL8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 3542 /* imull */, X86::IMUL32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3542 /* imull */, X86::IMUL32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rri8, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rmi8, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 3542 /* imull */, X86::IMUL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 3548 /* imulq */, X86::IMUL64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 3548 /* imulq */, X86::IMUL64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rri8, Convert__Reg1_1__Reg1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rri32, Convert__Reg1_1__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rri8, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rmi8, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rri32, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 3548 /* imulq */, X86::IMUL64rmi32, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 3554 /* imulw */, X86::IMUL16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3554 /* imulw */, X86::IMUL16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rri8, Convert__Reg1_1__Reg1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rri8, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rmi8, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 3554 /* imulw */, X86::IMUL16rmi, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 3563 /* inb */, X86::IN8rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 3563 /* inb */, X86::IN8ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 3563 /* inb */, X86::IN8rr, Convert_NoOperands, AMFBS_None, { MCK_DX, MCK_AL }, },
  { 3563 /* inb */, X86::IN8ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_AL }, },
  { 3571 /* incb */, X86::INC8r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 3571 /* incb */, X86::INC8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 3576 /* incl */, X86::INC32r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 3576 /* incl */, X86::INC32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 3576 /* incl */, X86::INC32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 3581 /* incq */, X86::INC64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 3581 /* incq */, X86::INC64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 3586 /* incsspd */, X86::INCSSPD, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 3594 /* incsspq */, X86::INCSSPQ, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 3602 /* incw */, X86::INC16r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR16 }, },
  { 3602 /* incw */, X86::INC16r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 3602 /* incw */, X86::INC16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 3607 /* inl */, X86::IN32rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 3607 /* inl */, X86::IN32ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 3607 /* inl */, X86::IN32rr, Convert_NoOperands, AMFBS_None, { MCK_DX, MCK_EAX }, },
  { 3607 /* inl */, X86::IN32ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_EAX }, },
  { 3615 /* insb */, X86::INSB, Convert__DstIdx81_1, AMFBS_None, { MCK_DX, MCK_DstIdx8 }, },
  { 3625 /* insertps */, X86::INSERTPSrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3625 /* insertps */, X86::INSERTPSrm, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16 }, },
  { 3634 /* insertq */, X86::INSERTQ, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3634 /* insertq */, X86::INSERTQI, Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3642 /* insl */, X86::INSL, Convert__DstIdx321_1, AMFBS_None, { MCK_DX, MCK_DstIdx32 }, },
  { 3647 /* insw */, X86::INSW, Convert__DstIdx161_1, AMFBS_None, { MCK_DX, MCK_DstIdx16 }, },
  { 3652 /* int */, X86::INT, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 3656 /* int3 */, X86::INT3, Convert_NoOperands, AMFBS_None, {  }, },
  { 3661 /* into */, X86::INTO, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 3666 /* invd */, X86::INVD, Convert_NoOperands, AMFBS_None, {  }, },
  { 3671 /* invept */, X86::INVEPT32, Convert__Reg1_1__Mem1285_0, AMFBS_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3671 /* invept */, X86::INVEPT64, Convert__Reg1_1__Mem1285_0, AMFBS_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3678 /* invlpg */, X86::INVLPG, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 3685 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 3685 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 3685 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 3685 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_ECX }, },
  { 3693 /* invlpgb */, X86::INVLPGB32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 3693 /* invlpgb */, X86::INVLPGB64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 3693 /* invlpgb */, X86::INVLPGB32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_EDX }, },
  { 3693 /* invlpgb */, X86::INVLPGB64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_EDX }, },
  { 3701 /* invpcid */, X86::INVPCID32, Convert__Reg1_1__Mem1285_0, AMFBS_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3701 /* invpcid */, X86::INVPCID64, Convert__Reg1_1__Mem1285_0, AMFBS_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3709 /* invvpid */, X86::INVVPID32, Convert__Reg1_1__Mem1285_0, AMFBS_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3709 /* invvpid */, X86::INVVPID64, Convert__Reg1_1__Mem1285_0, AMFBS_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3717 /* inw */, X86::IN16rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 3717 /* inw */, X86::IN16ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 3717 /* inw */, X86::IN16rr, Convert_NoOperands, AMFBS_None, { MCK_DX, MCK_AX }, },
  { 3717 /* inw */, X86::IN16ri, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_AX }, },
  { 3732 /* iretl */, X86::IRET32, Convert_NoOperands, AMFBS_None, {  }, },
  { 3738 /* iretq */, X86::IRET64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 3744 /* iretw */, X86::IRET16, Convert_NoOperands, AMFBS_None, {  }, },
  { 3750 /* ja */, X86::JCC_1, Convert__AbsMem1_0__imm_95_7, AMFBS_None, { MCK_AbsMem }, },
  { 3753 /* jae */, X86::JCC_1, Convert__AbsMem1_0__imm_95_3, AMFBS_None, { MCK_AbsMem }, },
  { 3757 /* jb */, X86::JCC_1, Convert__AbsMem1_0__imm_95_2, AMFBS_None, { MCK_AbsMem }, },
  { 3760 /* jbe */, X86::JCC_1, Convert__AbsMem1_0__imm_95_6, AMFBS_None, { MCK_AbsMem }, },
  { 3764 /* jcxz */, X86::JCXZ, Convert__AbsMem1_0, AMFBS_Not64BitMode, { MCK_AbsMem }, },
  { 3769 /* je */, X86::JCC_1, Convert__AbsMem1_0__imm_95_4, AMFBS_None, { MCK_AbsMem }, },
  { 3772 /* jecxz */, X86::JECXZ, Convert__AbsMem1_0, AMFBS_None, { MCK_AbsMem }, },
  { 3778 /* jg */, X86::JCC_1, Convert__AbsMem1_0__imm_95_15, AMFBS_None, { MCK_AbsMem }, },
  { 3781 /* jge */, X86::JCC_1, Convert__AbsMem1_0__imm_95_13, AMFBS_None, { MCK_AbsMem }, },
  { 3785 /* jl */, X86::JCC_1, Convert__AbsMem1_0__imm_95_12, AMFBS_None, { MCK_AbsMem }, },
  { 3788 /* jle */, X86::JCC_1, Convert__AbsMem1_0__imm_95_14, AMFBS_None, { MCK_AbsMem }, },
  { 3792 /* jmp */, X86::JMP_1, Convert__AbsMem1_0, AMFBS_None, { MCK_AbsMem }, },
  { 3792 /* jmp */, X86::JMP16m, Convert__Mem165_1, AMFBS_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3792 /* jmp */, X86::JMP32m, Convert__Mem325_1, AMFBS_In32BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3792 /* jmp */, X86::JMP64m, Convert__Mem645_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3792 /* jmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, AMFBS_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3792 /* jmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, AMFBS_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 3796 /* jmpl */, X86::JMP32r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 3796 /* jmpl */, X86::JMP32m, Convert__Mem325_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3796 /* jmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3801 /* jmpq */, X86::JMP64r, Convert__Reg1_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 3801 /* jmpq */, X86::JMP64m, Convert__Mem645_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3806 /* jmpw */, X86::JMP16r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 3806 /* jmpw */, X86::JMP16m, Convert__Mem165_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3806 /* jmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3811 /* jne */, X86::JCC_1, Convert__AbsMem1_0__imm_95_5, AMFBS_None, { MCK_AbsMem }, },
  { 3815 /* jno */, X86::JCC_1, Convert__AbsMem1_0__imm_95_1, AMFBS_None, { MCK_AbsMem }, },
  { 3819 /* jnp */, X86::JCC_1, Convert__AbsMem1_0__imm_95_11, AMFBS_None, { MCK_AbsMem }, },
  { 3823 /* jns */, X86::JCC_1, Convert__AbsMem1_0__imm_95_9, AMFBS_None, { MCK_AbsMem }, },
  { 3827 /* jo */, X86::JCC_1, Convert__AbsMem1_0__imm_95_0, AMFBS_None, { MCK_AbsMem }, },
  { 3830 /* jp */, X86::JCC_1, Convert__AbsMem1_0__imm_95_10, AMFBS_None, { MCK_AbsMem }, },
  { 3833 /* jrcxz */, X86::JRCXZ, Convert__AbsMem1_0, AMFBS_In64BitMode, { MCK_AbsMem }, },
  { 3839 /* js */, X86::JCC_1, Convert__AbsMem1_0__imm_95_8, AMFBS_None, { MCK_AbsMem }, },
  { 3842 /* kaddb */, X86::KADDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3848 /* kaddd */, X86::KADDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3854 /* kaddq */, X86::KADDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3860 /* kaddw */, X86::KADDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3866 /* kandb */, X86::KANDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3872 /* kandd */, X86::KANDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3878 /* kandnb */, X86::KANDNBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3885 /* kandnd */, X86::KANDNDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3892 /* kandnq */, X86::KANDNQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3899 /* kandnw */, X86::KANDNWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3906 /* kandq */, X86::KANDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3912 /* kandw */, X86::KANDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3918 /* kmovb */, X86::KMOVBkk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3918 /* kmovb */, X86::KMOVBrk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_GR32 }, },
  { 3918 /* kmovb */, X86::KMOVBmk, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_Mem8 }, },
  { 3918 /* kmovb */, X86::KMOVBkr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_VK1 }, },
  { 3918 /* kmovb */, X86::KMOVBkm, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_VK1 }, },
  { 3924 /* kmovd */, X86::KMOVDkk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3924 /* kmovd */, X86::KMOVDrk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_GR32 }, },
  { 3924 /* kmovd */, X86::KMOVDmk, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_Mem32 }, },
  { 3924 /* kmovd */, X86::KMOVDkr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_VK1 }, },
  { 3924 /* kmovd */, X86::KMOVDkm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VK1 }, },
  { 3930 /* kmovq */, X86::KMOVQkk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3930 /* kmovq */, X86::KMOVQrk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_GR64 }, },
  { 3930 /* kmovq */, X86::KMOVQmk, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_Mem64 }, },
  { 3930 /* kmovq */, X86::KMOVQkr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_VK1 }, },
  { 3930 /* kmovq */, X86::KMOVQkm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VK1 }, },
  { 3936 /* kmovw */, X86::KMOVWkk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3936 /* kmovw */, X86::KMOVWrk, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_GR32 }, },
  { 3936 /* kmovw */, X86::KMOVWmk, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_Mem16 }, },
  { 3936 /* kmovw */, X86::KMOVWkr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_VK1 }, },
  { 3936 /* kmovw */, X86::KMOVWkm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_VK1 }, },
  { 3942 /* knotb */, X86::KNOTBrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3948 /* knotd */, X86::KNOTDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3954 /* knotq */, X86::KNOTQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3960 /* knotw */, X86::KNOTWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3966 /* korb */, X86::KORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3971 /* kord */, X86::KORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3976 /* korq */, X86::KORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3981 /* kortestb */, X86::KORTESTBrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3990 /* kortestd */, X86::KORTESTDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 3999 /* kortestq */, X86::KORTESTQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4008 /* kortestw */, X86::KORTESTWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4017 /* korw */, X86::KORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4022 /* kshiftlb */, X86::KSHIFTLBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4031 /* kshiftld */, X86::KSHIFTLDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4040 /* kshiftlq */, X86::KSHIFTLQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4049 /* kshiftlw */, X86::KSHIFTLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4058 /* kshiftrb */, X86::KSHIFTRBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4067 /* kshiftrd */, X86::KSHIFTRDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4076 /* kshiftrq */, X86::KSHIFTRQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4085 /* kshiftrw */, X86::KSHIFTRWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 4094 /* ktestb */, X86::KTESTBrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4101 /* ktestd */, X86::KTESTDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4108 /* ktestq */, X86::KTESTQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4115 /* ktestw */, X86::KTESTWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1 }, },
  { 4122 /* kunpckbw */, X86::KUNPCKBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4131 /* kunpckdq */, X86::KUNPCKDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4140 /* kunpckwd */, X86::KUNPCKWDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4149 /* kxnorb */, X86::KXNORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4156 /* kxnord */, X86::KXNORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4163 /* kxnorq */, X86::KXNORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4170 /* kxnorw */, X86::KXNORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4177 /* kxorb */, X86::KXORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4183 /* kxord */, X86::KXORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4189 /* kxorq */, X86::KXORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4195 /* kxorw */, X86::KXORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 4201 /* lahf */, X86::LAHF, Convert_NoOperands, AMFBS_None, {  }, },
  { 4210 /* larl */, X86::LAR32rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR32 }, },
  { 4210 /* larl */, X86::LAR32rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 4215 /* larq */, X86::LAR64rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR64 }, },
  { 4215 /* larq */, X86::LAR64rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 4220 /* larw */, X86::LAR16rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR16 }, },
  { 4220 /* larw */, X86::LAR16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 4225 /* lcall */, X86::FARCALL32m, Convert__Mem5_1, AMFBS_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4225 /* lcall */, X86::FARCALL16m, Convert__Mem5_1, AMFBS_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4225 /* lcall */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 4225 /* lcall */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 4231 /* lcalll */, X86::FARCALL32m, Convert__Mem5_1, AMFBS_None, { MCK__STAR_, MCK_Mem }, },
  { 4231 /* lcalll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4238 /* lcallq */, X86::FARCALL64m, Convert__Mem5_1, AMFBS_None, { MCK__STAR_, MCK_Mem }, },
  { 4245 /* lcallw */, X86::FARCALL16m, Convert__Mem5_1, AMFBS_None, { MCK__STAR_, MCK_Mem }, },
  { 4245 /* lcallw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4252 /* lddqu */, X86::LDDQUrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4258 /* ldmxcsr */, X86::LDMXCSR, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 4270 /* ldsl */, X86::LDS32rm, Convert__Reg1_1__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 4275 /* ldsw */, X86::LDS16rm, Convert__Reg1_1__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem, MCK_GR16 }, },
  { 4280 /* ldtilecfg */, X86::LDTILECFG, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 4294 /* leal */, X86::LEA32r, Convert__Reg1_1__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 4294 /* leal */, X86::LEA64_32r, Convert__Reg1_1__Mem5_0, AMFBS_In64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 4299 /* leaq */, X86::LEA64r, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR64 }, },
  { 4304 /* leave */, X86::LEAVE, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 4304 /* leave */, X86::LEAVE64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 4310 /* leaw */, X86::LEA16r, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR16 }, },
  { 4319 /* lesl */, X86::LES32rm, Convert__Reg1_1__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 4324 /* lesw */, X86::LES16rm, Convert__Reg1_1__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem, MCK_GR16 }, },
  { 4329 /* lfence */, X86::LFENCE, Convert_NoOperands, AMFBS_None, {  }, },
  { 4340 /* lfsl */, X86::LFS32rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR32 }, },
  { 4345 /* lfsq */, X86::LFS64rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR64 }, },
  { 4350 /* lfsw */, X86::LFS16rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR16 }, },
  { 4366 /* lgdtl */, X86::LGDT32m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 4372 /* lgdtq */, X86::LGDT64m, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 4378 /* lgdtw */, X86::LGDT16m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 4388 /* lgsl */, X86::LGS32rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR32 }, },
  { 4393 /* lgsq */, X86::LGS64rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR64 }, },
  { 4398 /* lgsw */, X86::LGS16rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR16 }, },
  { 4414 /* lidtl */, X86::LIDT32m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 4420 /* lidtq */, X86::LIDT64m, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 4426 /* lidtw */, X86::LIDT16m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 4432 /* ljmp */, X86::FARJMP32m, Convert__Mem5_1, AMFBS_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4432 /* ljmp */, X86::FARJMP16m, Convert__Mem5_1, AMFBS_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4432 /* ljmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, AMFBS_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 4432 /* ljmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, AMFBS_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 4437 /* ljmpl */, X86::FARJMP32m, Convert__Mem5_1, AMFBS_None, { MCK__STAR_, MCK_Mem }, },
  { 4437 /* ljmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4443 /* ljmpq */, X86::FARJMP64m, Convert__Mem5_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_Mem }, },
  { 4449 /* ljmpw */, X86::FARJMP16m, Convert__Mem5_1, AMFBS_None, { MCK__STAR_, MCK_Mem }, },
  { 4449 /* ljmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 4460 /* lldtw */, X86::LLDT16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 4460 /* lldtw */, X86::LLDT16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 4466 /* llwpcb */, X86::LLWPCB, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 4466 /* llwpcb */, X86::LLWPCB64, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 4478 /* lmsww */, X86::LMSW16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 4478 /* lmsww */, X86::LMSW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 4484 /* loadiwkey */, X86::LOADIWKEY, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4494 /* lock */, X86::LOCK_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 4499 /* lods */, X86::LODSW, Convert__SrcIdx162_0, AMFBS_None, { MCK_SrcIdx16, MCK_AX }, },
  { 4499 /* lods */, X86::LODSL, Convert__SrcIdx322_0, AMFBS_None, { MCK_SrcIdx32, MCK_EAX }, },
  { 4499 /* lods */, X86::LODSQ, Convert__SrcIdx642_0, AMFBS_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 4499 /* lods */, X86::LODSB, Convert__SrcIdx82_0, AMFBS_None, { MCK_SrcIdx8, MCK_AL }, },
  { 4504 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, AMFBS_None, { MCK_SrcIdx8 }, },
  { 4504 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, AMFBS_None, { MCK_SrcIdx8, MCK_AL }, },
  { 4516 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, AMFBS_None, { MCK_SrcIdx32 }, },
  { 4516 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, AMFBS_None, { MCK_SrcIdx32, MCK_EAX }, },
  { 4522 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, AMFBS_In64BitMode, { MCK_SrcIdx64 }, },
  { 4522 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, AMFBS_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 4528 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, AMFBS_None, { MCK_SrcIdx16 }, },
  { 4528 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, AMFBS_None, { MCK_SrcIdx16, MCK_AX }, },
  { 4534 /* loop */, X86::LOOP, Convert__AbsMem1_0, AMFBS_None, { MCK_AbsMem }, },
  { 4539 /* loope */, X86::LOOPE, Convert__AbsMem1_0, AMFBS_None, { MCK_AbsMem }, },
  { 4545 /* loopne */, X86::LOOPNE, Convert__AbsMem1_0, AMFBS_None, { MCK_AbsMem }, },
  { 4552 /* lretl */, X86::LRET32, Convert_NoOperands, AMFBS_None, {  }, },
  { 4552 /* lretl */, X86::LRETI32, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 4558 /* lretq */, X86::LRET64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 4558 /* lretq */, X86::LRETI64, Convert__Imm1_0, AMFBS_In64BitMode, { MCK_Imm }, },
  { 4564 /* lretw */, X86::LRET16, Convert_NoOperands, AMFBS_None, {  }, },
  { 4564 /* lretw */, X86::LRETI16, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 4574 /* lsll */, X86::LSL32rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR32 }, },
  { 4574 /* lsll */, X86::LSL32rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 4579 /* lslq */, X86::LSL64rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR64 }, },
  { 4579 /* lslq */, X86::LSL64rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 4584 /* lslw */, X86::LSL16rr, Convert__Reg1_1__GR16orGR32orGR641_0, AMFBS_None, { MCK_GR16orGR32orGR64, MCK_GR16 }, },
  { 4584 /* lslw */, X86::LSL16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 4593 /* lssl */, X86::LSS32rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR32 }, },
  { 4598 /* lssq */, X86::LSS64rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR64 }, },
  { 4603 /* lssw */, X86::LSS16rm, Convert__Reg1_1__Mem5_0, AMFBS_None, { MCK_Mem, MCK_GR16 }, },
  { 4612 /* ltrw */, X86::LTRr, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 4612 /* ltrw */, X86::LTRm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 4617 /* lwpins */, X86::LWPINS32rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 4617 /* lwpins */, X86::LWPINS64rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR64 }, },
  { 4617 /* lwpins */, X86::LWPINS32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 4617 /* lwpins */, X86::LWPINS64rmi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR64 }, },
  { 4624 /* lwpval */, X86::LWPVAL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 4624 /* lwpval */, X86::LWPVAL64rri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR64 }, },
  { 4624 /* lwpval */, X86::LWPVAL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 4624 /* lwpval */, X86::LWPVAL64rmi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR64 }, },
  { 4637 /* lzcntl */, X86::LZCNT32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4637 /* lzcntl */, X86::LZCNT32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 4644 /* lzcntq */, X86::LZCNT64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4644 /* lzcntq */, X86::LZCNT64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 4651 /* lzcntw */, X86::LZCNT16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 4651 /* lzcntw */, X86::LZCNT16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 4658 /* maskmovdqu */, X86::MASKMOVDQU64, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_FR16, MCK_FR16 }, },
  { 4658 /* maskmovdqu */, X86::MASKMOVDQU, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4669 /* maskmovq */, X86::MMX_MASKMOVQ, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 4669 /* maskmovq */, X86::MMX_MASKMOVQ64, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 4678 /* maxpd */, X86::MAXPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4678 /* maxpd */, X86::MAXPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4684 /* maxps */, X86::MAXPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4684 /* maxps */, X86::MAXPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4690 /* maxsd */, X86::MAXSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4690 /* maxsd */, X86::MAXSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4696 /* maxss */, X86::MAXSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4696 /* maxss */, X86::MAXSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4702 /* mfence */, X86::MFENCE, Convert_NoOperands, AMFBS_None, {  }, },
  { 4709 /* minpd */, X86::MINPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4709 /* minpd */, X86::MINPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4715 /* minps */, X86::MINPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4715 /* minps */, X86::MINPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4721 /* minsd */, X86::MINSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4721 /* minsd */, X86::MINSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4727 /* minss */, X86::MINSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4727 /* minss */, X86::MINSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4733 /* monitor */, X86::MONITOR32rrr, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 4733 /* monitor */, X86::MONITOR64rrr, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 4733 /* monitor */, X86::MONITOR32rrr, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 4733 /* monitor */, X86::MONITOR64rrr, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 4741 /* monitorx */, X86::MONITORX32rrr, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 4741 /* monitorx */, X86::MONITORX64rrr, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 4741 /* monitorx */, X86::MONITORX32rrr, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 4741 /* monitorx */, X86::MONITORX64rrr, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 4750 /* montmul */, X86::MONTMUL, Convert_NoOperands, AMFBS_None, {  }, },
  { 4762 /* mov.s */, X86::MOV16rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 4762 /* mov.s */, X86::MOV32rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4762 /* mov.s */, X86::MOV64rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4762 /* mov.s */, X86::MOV8rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 4775 /* movabsb */, X86::MOV8o64a, Convert__MemOffs64_82_1, AMFBS_None, { MCK_AL, MCK_MemOffs64_8 }, },
  { 4775 /* movabsb */, X86::MOV8ao64, Convert__MemOffs64_82_0, AMFBS_None, { MCK_MemOffs64_8, MCK_AL }, },
  { 4783 /* movabsl */, X86::MOV32o64a, Convert__MemOffs64_322_1, AMFBS_None, { MCK_EAX, MCK_MemOffs64_32 }, },
  { 4783 /* movabsl */, X86::MOV32ao64, Convert__MemOffs64_322_0, AMFBS_None, { MCK_MemOffs64_32, MCK_EAX }, },
  { 4791 /* movabsq */, X86::MOV64o64a, Convert__MemOffs64_642_1, AMFBS_None, { MCK_RAX, MCK_MemOffs64_64 }, },
  { 4791 /* movabsq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR64 }, },
  { 4791 /* movabsq */, X86::MOV64ao64, Convert__MemOffs64_642_0, AMFBS_None, { MCK_MemOffs64_64, MCK_RAX }, },
  { 4799 /* movabsw */, X86::MOV16o64a, Convert__MemOffs64_162_1, AMFBS_None, { MCK_AX, MCK_MemOffs64_16 }, },
  { 4799 /* movabsw */, X86::MOV16ao64, Convert__MemOffs64_162_0, AMFBS_None, { MCK_MemOffs64_16, MCK_AX }, },
  { 4807 /* movapd */, X86::MOVAPDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4807 /* movapd */, X86::MOVAPDmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 4807 /* movapd */, X86::MOVAPDrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4814 /* movapd.s */, X86::MOVAPDrr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4823 /* movaps */, X86::MOVAPSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4823 /* movaps */, X86::MOVAPSmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 4823 /* movaps */, X86::MOVAPSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4830 /* movaps.s */, X86::MOVAPSrr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4839 /* movb */, X86::MOV8o16a, Convert__MemOffs16_82_1, AMFBS_None, { MCK_AL, MCK_MemOffs16_8 }, },
  { 4839 /* movb */, X86::MOV8o32a, Convert__MemOffs32_82_1, AMFBS_None, { MCK_AL, MCK_MemOffs32_8 }, },
  { 4839 /* movb */, X86::MOV8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 4839 /* movb */, X86::MOV8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 4839 /* movb */, X86::MOV8ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 4839 /* movb */, X86::MOV8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 4839 /* movb */, X86::MOV8ao16, Convert__MemOffs16_82_0, AMFBS_None, { MCK_MemOffs16_8, MCK_AL }, },
  { 4839 /* movb */, X86::MOV8ao32, Convert__MemOffs32_82_0, AMFBS_None, { MCK_MemOffs32_8, MCK_AL }, },
  { 4839 /* movb */, X86::MOV8rm, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 4844 /* movb.s */, X86::MOV8rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 4857 /* movbel */, X86::MOVBE32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 4857 /* movbel */, X86::MOVBE32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 4864 /* movbeq */, X86::MOVBE64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 4864 /* movbeq */, X86::MOVBE64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 4871 /* movbew */, X86::MOVBE16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 4871 /* movbew */, X86::MOVBE16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 4878 /* movd */, X86::MMX_MOVD64grr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_GR32 }, },
  { 4878 /* movd */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_GR64 }, },
  { 4878 /* movd */, X86::MMX_MOVD64mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_Mem32 }, },
  { 4878 /* movd */, X86::MOVPDI2DIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4878 /* movd */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4878 /* movd */, X86::MOVPDI2DImr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem32 }, },
  { 4878 /* movd */, X86::MMX_MOVD64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_VR64 }, },
  { 4878 /* movd */, X86::MOVDI2PDIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 4878 /* movd */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_VR64 }, },
  { 4878 /* movd */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 4878 /* movd */, X86::MMX_MOVD64rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR64 }, },
  { 4878 /* movd */, X86::MOVDI2PDIrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4883 /* movddup */, X86::MOVDDUPrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4883 /* movddup */, X86::MOVDDUPrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4891 /* movdir64b */, X86::MOVDIR64B16, Convert__Reg1_1__Mem512_GR165_0, AMFBS_Not64BitMode, { MCK_Mem512_GR16, MCK_GR16 }, },
  { 4891 /* movdir64b */, X86::MOVDIR64B32, Convert__Reg1_1__Mem512_GR325_0, AMFBS_None, { MCK_Mem512_GR32, MCK_GR32 }, },
  { 4891 /* movdir64b */, X86::MOVDIR64B64, Convert__Reg1_1__Mem512_GR645_0, AMFBS_In64BitMode, { MCK_Mem512_GR64, MCK_GR64 }, },
  { 4901 /* movdiri */, X86::MOVDIRI32, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 4901 /* movdiri */, X86::MOVDIRI64, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 4909 /* movdq2q */, X86::MMX_MOVDQ2Qrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 4917 /* movdqa */, X86::MOVDQArr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4917 /* movdqa */, X86::MOVDQAmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 4917 /* movdqa */, X86::MOVDQArm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4924 /* movdqa.s */, X86::MOVDQArr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4933 /* movdqu */, X86::MOVDQUrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4933 /* movdqu */, X86::MOVDQUmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 4933 /* movdqu */, X86::MOVDQUrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4940 /* movdqu.s */, X86::MOVDQUrr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4949 /* movhlps */, X86::MOVHLPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4957 /* movhpd */, X86::MOVHPDmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 4957 /* movhpd */, X86::MOVHPDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4964 /* movhps */, X86::MOVHPSmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 4964 /* movhps */, X86::MOVHPSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4971 /* movl */, X86::MOV32o16a, Convert__MemOffs16_322_1, AMFBS_None, { MCK_EAX, MCK_MemOffs16_32 }, },
  { 4971 /* movl */, X86::MOV32o32a, Convert__MemOffs32_322_1, AMFBS_None, { MCK_EAX, MCK_MemOffs32_32 }, },
  { 4971 /* movl */, X86::MOV32rs, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_SEGMENT_REG, MCK_GR32 }, },
  { 4971 /* movl */, X86::MOV32rc, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_CONTROL_REG, MCK_GR32 }, },
  { 4971 /* movl */, X86::MOV32rd, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_DEBUG_REG, MCK_GR32 }, },
  { 4971 /* movl */, X86::MOV32sr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_SEGMENT_REG }, },
  { 4971 /* movl */, X86::MOV32cr, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR32, MCK_CONTROL_REG }, },
  { 4971 /* movl */, X86::MOV32dr, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR32, MCK_DEBUG_REG }, },
  { 4971 /* movl */, X86::MOV32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4971 /* movl */, X86::MOV32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 4971 /* movl */, X86::MOV32ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 4971 /* movl */, X86::MOV32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 4971 /* movl */, X86::MOV32ao16, Convert__MemOffs16_322_0, AMFBS_None, { MCK_MemOffs16_32, MCK_EAX }, },
  { 4971 /* movl */, X86::MOV32ao32, Convert__MemOffs32_322_0, AMFBS_None, { MCK_MemOffs32_32, MCK_EAX }, },
  { 4971 /* movl */, X86::MOV32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 4976 /* movl.s */, X86::MOV32rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4983 /* movlhps */, X86::MOVLHPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4991 /* movlpd */, X86::MOVLPDmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 4991 /* movlpd */, X86::MOVLPDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4998 /* movlps */, X86::MOVLPSmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 4998 /* movlps */, X86::MOVLPSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 5005 /* movmskpd */, X86::MOVMSKPDrr, Convert__GR32orGR641_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32orGR64 }, },
  { 5014 /* movmskps */, X86::MOVMSKPSrr, Convert__GR32orGR641_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32orGR64 }, },
  { 5023 /* movntdq */, X86::MOVNTDQmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 5031 /* movntdqa */, X86::MOVNTDQArm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5047 /* movntil */, X86::MOVNTImr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 5055 /* movntiq */, X86::MOVNTI_64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 5063 /* movntpd */, X86::MOVNTPDmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 5071 /* movntps */, X86::MOVNTPSmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 5079 /* movntq */, X86::MMX_MOVNTQmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_Mem64 }, },
  { 5086 /* movntsd */, X86::MOVNTSD, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 5094 /* movntss */, X86::MOVNTSS, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem32 }, },
  { 5102 /* movq */, X86::MOV64o32a, Convert__MemOffs32_642_1, AMFBS_None, { MCK_RAX, MCK_MemOffs32_64 }, },
  { 5102 /* movq */, X86::MOV64rs, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_SEGMENT_REG, MCK_GR64 }, },
  { 5102 /* movq */, X86::MMX_MOVQ64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5102 /* movq */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_VR64, MCK_GR64 }, },
  { 5102 /* movq */, X86::MMX_MOVQ64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_Mem64 }, },
  { 5102 /* movq */, X86::MOV64rc, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_CONTROL_REG, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOV64rd, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_DEBUG_REG, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOVZPQILo2PQIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5102 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOVPQI2QImr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 5102 /* movq */, X86::MOV64sr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_SEGMENT_REG }, },
  { 5102 /* movq */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_VR64 }, },
  { 5102 /* movq */, X86::MOV64cr, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_CONTROL_REG }, },
  { 5102 /* movq */, X86::MOV64dr, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_DEBUG_REG }, },
  { 5102 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 5102 /* movq */, X86::MOV64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOV64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 5102 /* movq */, X86::MOV64ri32, Convert__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOV64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 5102 /* movq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR64 }, },
  { 5102 /* movq */, X86::MOV64ao32, Convert__MemOffs32_642_0, AMFBS_None, { MCK_MemOffs32_64, MCK_RAX }, },
  { 5102 /* movq */, X86::MMX_MOVQ64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5102 /* movq */, X86::MOVQI2PQIrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 5102 /* movq */, X86::MOV64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 5107 /* movq.s */, X86::MMX_MOVQ64rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5107 /* movq.s */, X86::MOVPQI2QIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5107 /* movq.s */, X86::MOV64rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5114 /* movq2dq */, X86::MMX_MOVQ2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_FR16 }, },
  { 5127 /* movsb */, X86::MOVSB, Convert__DstIdx81_1__SrcIdx82_0, AMFBS_None, { MCK_SrcIdx8, MCK_DstIdx8 }, },
  { 5133 /* movsbl */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 5133 /* movsbl */, X86::MOVSX32rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR32 }, },
  { 5140 /* movsbq */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 5140 /* movsbq */, X86::MOVSX64rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR64 }, },
  { 5147 /* movsbw */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR16 }, },
  { 5147 /* movsbw */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR16 }, },
  { 5154 /* movsd */, X86::MOVSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5154 /* movsd */, X86::MOVSDmr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem64 }, },
  { 5154 /* movsd */, X86::MOVSDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 5160 /* movsd.s */, X86::MOVSDrr_REV, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5168 /* movshdup */, X86::MOVSHDUPrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5168 /* movshdup */, X86::MOVSHDUPrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5177 /* movsl */, X86::MOVSL, Convert__DstIdx321_1__SrcIdx322_0, AMFBS_None, { MCK_SrcIdx32, MCK_DstIdx32 }, },
  { 5183 /* movsldup */, X86::MOVSLDUPrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5183 /* movsldup */, X86::MOVSLDUPrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5192 /* movslq */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR64 }, },
  { 5192 /* movslq */, X86::MOVSX64rm32, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR64 }, },
  { 5199 /* movsq */, X86::MOVSQ, Convert__DstIdx641_1__SrcIdx642_0, AMFBS_In64BitMode, { MCK_SrcIdx64, MCK_DstIdx64 }, },
  { 5205 /* movss */, X86::MOVSSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5205 /* movss */, X86::MOVSSmr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem32 }, },
  { 5205 /* movss */, X86::MOVSSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 5211 /* movss.s */, X86::MOVSSrr_REV, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5219 /* movsw */, X86::MOVSW, Convert__DstIdx161_1__SrcIdx162_0, AMFBS_None, { MCK_SrcIdx16, MCK_DstIdx16 }, },
  { 5225 /* movswl */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 5225 /* movswl */, X86::MOVSX32rm16, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 5232 /* movswq */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR64 }, },
  { 5232 /* movswq */, X86::MOVSX64rm16, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 5239 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 5239 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR64 }, },
  { 5239 /* movsx */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 5239 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR16 }, },
  { 5239 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 5239 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 5239 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR16 }, },
  { 5252 /* movupd */, X86::MOVUPDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5252 /* movupd */, X86::MOVUPDmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 5252 /* movupd */, X86::MOVUPDrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5259 /* movupd.s */, X86::MOVUPDrr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5268 /* movups */, X86::MOVUPSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5268 /* movups */, X86::MOVUPSmr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128 }, },
  { 5268 /* movups */, X86::MOVUPSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5275 /* movups.s */, X86::MOVUPSrr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5284 /* movw */, X86::MOV16o16a, Convert__MemOffs16_162_1, AMFBS_None, { MCK_AX, MCK_MemOffs16_16 }, },
  { 5284 /* movw */, X86::MOV16o32a, Convert__MemOffs32_162_1, AMFBS_None, { MCK_AX, MCK_MemOffs32_16 }, },
  { 5284 /* movw */, X86::MOV16rs, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_SEGMENT_REG, MCK_GR16 }, },
  { 5284 /* movw */, X86::MOV16ms, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_SEGMENT_REG, MCK_Mem16 }, },
  { 5284 /* movw */, X86::MOV16sr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_SEGMENT_REG }, },
  { 5284 /* movw */, X86::MOV16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 5284 /* movw */, X86::MOV16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 5284 /* movw */, X86::MOV16ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 5284 /* movw */, X86::MOV16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 5284 /* movw */, X86::MOV16ao16, Convert__MemOffs16_162_0, AMFBS_None, { MCK_MemOffs16_16, MCK_AX }, },
  { 5284 /* movw */, X86::MOV16ao32, Convert__MemOffs32_162_0, AMFBS_None, { MCK_MemOffs32_16, MCK_AX }, },
  { 5284 /* movw */, X86::MOV16sm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_SEGMENT_REG }, },
  { 5284 /* movw */, X86::MOV16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 5289 /* movw.s */, X86::MOV16rr_REV, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 5296 /* movzbl */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 5296 /* movzbl */, X86::MOVZX32rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR32 }, },
  { 5303 /* movzbq */, X86::MOVZX64rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 5303 /* movzbq */, X86::MOVZX64rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR64 }, },
  { 5310 /* movzbw */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR16 }, },
  { 5310 /* movzbw */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR16 }, },
  { 5317 /* movzwl */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 5317 /* movzwl */, X86::MOVZX32rm16, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 5324 /* movzwq */, X86::MOVZX64rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR64 }, },
  { 5324 /* movzwq */, X86::MOVZX64rm16, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 5331 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 5331 /* movzx */, X86::MOVZX64rr16, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR64 }, },
  { 5331 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR16 }, },
  { 5331 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 5331 /* movzx */, X86::MOVZX64rr8, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 5331 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR16 }, },
  { 5337 /* mpsadbw */, X86::MPSADBWrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5337 /* mpsadbw */, X86::MPSADBWrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5349 /* mulb */, X86::MUL8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 5349 /* mulb */, X86::MUL8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 5354 /* mull */, X86::MUL32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 5354 /* mull */, X86::MUL32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5359 /* mulpd */, X86::MULPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5359 /* mulpd */, X86::MULPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5365 /* mulps */, X86::MULPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5365 /* mulps */, X86::MULPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5371 /* mulq */, X86::MUL64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 5371 /* mulq */, X86::MUL64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5376 /* mulsd */, X86::MULSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5376 /* mulsd */, X86::MULSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 5382 /* mulss */, X86::MULSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5382 /* mulss */, X86::MULSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 5388 /* mulw */, X86::MUL16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 5388 /* mulw */, X86::MUL16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5398 /* mulxl */, X86::MULX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5398 /* mulxl */, X86::MULX32rm, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5404 /* mulxq */, X86::MULX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5404 /* mulxq */, X86::MULX64rm, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5410 /* mwait */, X86::MWAITrr, Convert_NoOperands, AMFBS_None, {  }, },
  { 5410 /* mwait */, X86::MWAITrr, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 5410 /* mwait */, X86::MWAITrr, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX }, },
  { 5416 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, AMFBS_None, {  }, },
  { 5416 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EBX }, },
  { 5416 /* mwaitx */, X86::MWAITXrrr, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RBX }, },
  { 5427 /* negb */, X86::NEG8r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 5427 /* negb */, X86::NEG8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 5432 /* negl */, X86::NEG32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 5432 /* negl */, X86::NEG32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5437 /* negq */, X86::NEG64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 5437 /* negq */, X86::NEG64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5442 /* negw */, X86::NEG16r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 5442 /* negw */, X86::NEG16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5447 /* nop */, X86::NOOP, Convert_NoOperands, AMFBS_None, {  }, },
  { 5451 /* nopl */, X86::NOOPLr, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 5451 /* nopl */, X86::NOOPL, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5456 /* nopq */, X86::NOOPQr, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 5456 /* nopq */, X86::NOOPQ, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5461 /* nopw */, X86::NOOPWr, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 5461 /* nopw */, X86::NOOPW, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5470 /* notb */, X86::NOT8r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 5470 /* notb */, X86::NOT8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 5475 /* notl */, X86::NOT32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 5475 /* notl */, X86::NOT32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5480 /* notq */, X86::NOT64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 5480 /* notq */, X86::NOT64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5485 /* notw */, X86::NOT16r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 5485 /* notw */, X86::NOT16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5493 /* orb */, X86::OR8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 5493 /* orb */, X86::OR8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 5493 /* orb */, X86::OR8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 5493 /* orb */, X86::OR8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 5493 /* orb */, X86::OR8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 5493 /* orb */, X86::OR8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 5497 /* orl */, X86::OR32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5497 /* orl */, X86::OR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 5497 /* orl */, X86::OR32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 5497 /* orl */, X86::OR32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 5497 /* orl */, X86::OR32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 5497 /* orl */, X86::OR32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 5497 /* orl */, X86::OR32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 5497 /* orl */, X86::OR32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 5497 /* orl */, X86::OR32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 5501 /* orpd */, X86::ORPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5501 /* orpd */, X86::ORPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5506 /* orps */, X86::ORPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5506 /* orps */, X86::ORPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5511 /* orq */, X86::OR64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5511 /* orq */, X86::OR64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 5511 /* orq */, X86::OR64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 5511 /* orq */, X86::OR64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 5511 /* orq */, X86::OR64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 5511 /* orq */, X86::OR64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 5511 /* orq */, X86::OR64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 5511 /* orq */, X86::OR64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 5511 /* orq */, X86::OR64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 5515 /* orw */, X86::OR16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 5515 /* orw */, X86::OR16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 5515 /* orw */, X86::OR16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 5515 /* orw */, X86::OR16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 5515 /* orw */, X86::OR16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 5515 /* orw */, X86::OR16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 5515 /* orw */, X86::OR16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 5515 /* orw */, X86::OR16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 5515 /* orw */, X86::OR16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 5523 /* outb */, X86::OUT8rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 5523 /* outb */, X86::OUT8ir, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 5523 /* outb */, X86::OUT8rr, Convert_NoOperands, AMFBS_None, { MCK_AL, MCK_DX }, },
  { 5523 /* outb */, X86::OUT8ir, Convert__ImmUnsignedi81_1, AMFBS_None, { MCK_AL, MCK_ImmUnsignedi8 }, },
  { 5528 /* outl */, X86::OUT32rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 5528 /* outl */, X86::OUT32ir, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 5528 /* outl */, X86::OUT32rr, Convert_NoOperands, AMFBS_None, { MCK_EAX, MCK_DX }, },
  { 5528 /* outl */, X86::OUT32ir, Convert__ImmUnsignedi81_1, AMFBS_None, { MCK_EAX, MCK_ImmUnsignedi8 }, },
  { 5538 /* outsb */, X86::OUTSB, Convert__SrcIdx82_0, AMFBS_None, { MCK_SrcIdx8, MCK_DX }, },
  { 5550 /* outsl */, X86::OUTSL, Convert__SrcIdx322_0, AMFBS_None, { MCK_SrcIdx32, MCK_DX }, },
  { 5556 /* outsw */, X86::OUTSW, Convert__SrcIdx162_0, AMFBS_None, { MCK_SrcIdx16, MCK_DX }, },
  { 5562 /* outw */, X86::OUT16rr, Convert_NoOperands, AMFBS_None, { MCK_DX }, },
  { 5562 /* outw */, X86::OUT16ir, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 5562 /* outw */, X86::OUT16rr, Convert_NoOperands, AMFBS_None, { MCK_AX, MCK_DX }, },
  { 5562 /* outw */, X86::OUT16ir, Convert__ImmUnsignedi81_1, AMFBS_None, { MCK_AX, MCK_ImmUnsignedi8 }, },
  { 5567 /* pabsb */, X86::MMX_PABSBrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5567 /* pabsb */, X86::PABSBrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5567 /* pabsb */, X86::PABSBrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5567 /* pabsb */, X86::MMX_PABSBrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5573 /* pabsd */, X86::MMX_PABSDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5573 /* pabsd */, X86::PABSDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5573 /* pabsd */, X86::PABSDrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5573 /* pabsd */, X86::MMX_PABSDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5579 /* pabsw */, X86::MMX_PABSWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5579 /* pabsw */, X86::PABSWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5579 /* pabsw */, X86::PABSWrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5579 /* pabsw */, X86::MMX_PABSWrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5585 /* packssdw */, X86::MMX_PACKSSDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5585 /* packssdw */, X86::PACKSSDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5585 /* packssdw */, X86::PACKSSDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5585 /* packssdw */, X86::MMX_PACKSSDWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5594 /* packsswb */, X86::MMX_PACKSSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5594 /* packsswb */, X86::PACKSSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5594 /* packsswb */, X86::PACKSSWBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5594 /* packsswb */, X86::MMX_PACKSSWBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5603 /* packusdw */, X86::PACKUSDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5603 /* packusdw */, X86::PACKUSDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5612 /* packuswb */, X86::MMX_PACKUSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5612 /* packuswb */, X86::PACKUSWBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5612 /* packuswb */, X86::PACKUSWBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5612 /* packuswb */, X86::MMX_PACKUSWBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5621 /* paddb */, X86::MMX_PADDBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5621 /* paddb */, X86::PADDBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5621 /* paddb */, X86::PADDBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5621 /* paddb */, X86::MMX_PADDBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5627 /* paddd */, X86::MMX_PADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5627 /* paddd */, X86::PADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5627 /* paddd */, X86::PADDDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5627 /* paddd */, X86::MMX_PADDDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5633 /* paddq */, X86::MMX_PADDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5633 /* paddq */, X86::PADDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5633 /* paddq */, X86::PADDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5633 /* paddq */, X86::MMX_PADDQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5639 /* paddsb */, X86::MMX_PADDSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5639 /* paddsb */, X86::PADDSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5639 /* paddsb */, X86::PADDSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5639 /* paddsb */, X86::MMX_PADDSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5646 /* paddsw */, X86::MMX_PADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5646 /* paddsw */, X86::PADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5646 /* paddsw */, X86::PADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5646 /* paddsw */, X86::MMX_PADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5653 /* paddusb */, X86::MMX_PADDUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5653 /* paddusb */, X86::PADDUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5653 /* paddusb */, X86::PADDUSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5653 /* paddusb */, X86::MMX_PADDUSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5661 /* paddusw */, X86::MMX_PADDUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5661 /* paddusw */, X86::PADDUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5661 /* paddusw */, X86::PADDUSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5661 /* paddusw */, X86::MMX_PADDUSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5669 /* paddw */, X86::MMX_PADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5669 /* paddw */, X86::PADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5669 /* paddw */, X86::PADDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5669 /* paddw */, X86::MMX_PADDWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5675 /* palignr */, X86::MMX_PALIGNRrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 5675 /* palignr */, X86::PALIGNRrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5675 /* palignr */, X86::PALIGNRrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5675 /* palignr */, X86::MMX_PALIGNRrmi, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 5683 /* pand */, X86::MMX_PANDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5683 /* pand */, X86::PANDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5683 /* pand */, X86::PANDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5683 /* pand */, X86::MMX_PANDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5688 /* pandn */, X86::MMX_PANDNrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5688 /* pandn */, X86::PANDNrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5688 /* pandn */, X86::PANDNrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5688 /* pandn */, X86::MMX_PANDNrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5694 /* pause */, X86::PAUSE, Convert_NoOperands, AMFBS_None, {  }, },
  { 5700 /* pavgb */, X86::MMX_PAVGBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5700 /* pavgb */, X86::PAVGBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5700 /* pavgb */, X86::PAVGBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5700 /* pavgb */, X86::MMX_PAVGBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5706 /* pavgusb */, X86::PAVGUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5706 /* pavgusb */, X86::PAVGUSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5714 /* pavgw */, X86::MMX_PAVGWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5714 /* pavgw */, X86::PAVGWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5714 /* pavgw */, X86::PAVGWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5714 /* pavgw */, X86::MMX_PAVGWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5720 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5720 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5720 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 5720 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 5729 /* pblendw */, X86::PBLENDWrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5729 /* pblendw */, X86::PBLENDWrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5737 /* pbndkb */, X86::PBNDKB, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 5744 /* pclmulhqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5744 /* pclmulhqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5757 /* pclmulhqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5757 /* pclmulhqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5770 /* pclmullqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5770 /* pclmullqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5783 /* pclmullqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5783 /* pclmullqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5796 /* pclmulqdq */, X86::PCLMULQDQrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5796 /* pclmulqdq */, X86::PCLMULQDQrm, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5806 /* pcmpeqb */, X86::MMX_PCMPEQBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5806 /* pcmpeqb */, X86::PCMPEQBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5806 /* pcmpeqb */, X86::PCMPEQBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5806 /* pcmpeqb */, X86::MMX_PCMPEQBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5814 /* pcmpeqd */, X86::MMX_PCMPEQDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5814 /* pcmpeqd */, X86::PCMPEQDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5814 /* pcmpeqd */, X86::PCMPEQDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5814 /* pcmpeqd */, X86::MMX_PCMPEQDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5822 /* pcmpeqq */, X86::PCMPEQQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5822 /* pcmpeqq */, X86::PCMPEQQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5830 /* pcmpeqw */, X86::MMX_PCMPEQWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5830 /* pcmpeqw */, X86::PCMPEQWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5830 /* pcmpeqw */, X86::PCMPEQWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5830 /* pcmpeqw */, X86::MMX_PCMPEQWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5838 /* pcmpestri */, X86::PCMPESTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5838 /* pcmpestri */, X86::PCMPESTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5848 /* pcmpestrm */, X86::PCMPESTRMrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5848 /* pcmpestrm */, X86::PCMPESTRMrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5858 /* pcmpgtb */, X86::MMX_PCMPGTBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5858 /* pcmpgtb */, X86::PCMPGTBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5858 /* pcmpgtb */, X86::PCMPGTBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5858 /* pcmpgtb */, X86::MMX_PCMPGTBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5866 /* pcmpgtd */, X86::MMX_PCMPGTDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5866 /* pcmpgtd */, X86::PCMPGTDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5866 /* pcmpgtd */, X86::PCMPGTDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5866 /* pcmpgtd */, X86::MMX_PCMPGTDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5874 /* pcmpgtq */, X86::PCMPGTQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5874 /* pcmpgtq */, X86::PCMPGTQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5882 /* pcmpgtw */, X86::MMX_PCMPGTWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5882 /* pcmpgtw */, X86::PCMPGTWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5882 /* pcmpgtw */, X86::PCMPGTWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5882 /* pcmpgtw */, X86::MMX_PCMPGTWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5890 /* pcmpistri */, X86::PCMPISTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5890 /* pcmpistri */, X86::PCMPISTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5900 /* pcmpistrm */, X86::PCMPISTRMrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5900 /* pcmpistrm */, X86::PCMPISTRMrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5910 /* pconfig */, X86::PCONFIG, Convert_NoOperands, AMFBS_None, {  }, },
  { 5923 /* pdepl */, X86::PDEP32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5923 /* pdepl */, X86::PDEP32rm, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5929 /* pdepq */, X86::PDEP64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5929 /* pdepq */, X86::PDEP64rm, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5940 /* pextl */, X86::PEXT32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5940 /* pextl */, X86::PEXT32rm, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5946 /* pextq */, X86::PEXT64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5946 /* pextq */, X86::PEXT64rm, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5952 /* pextrb */, X86::PEXTRBrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR32orGR64 }, },
  { 5952 /* pextrb */, X86::PEXTRBmr, Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem8 }, },
  { 5959 /* pextrd */, X86::PEXTRDrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR32 }, },
  { 5959 /* pextrd */, X86::PEXTRDmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem32 }, },
  { 5966 /* pextrq */, X86::PEXTRQrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR64 }, },
  { 5966 /* pextrq */, X86::PEXTRQmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem64 }, },
  { 5973 /* pextrw */, X86::MMX_PEXTRWrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64, MCK_GR32orGR64 }, },
  { 5973 /* pextrw */, X86::PEXTRWrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR32orGR64 }, },
  { 5973 /* pextrw */, X86::PEXTRWmr, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem16 }, },
  { 5980 /* pf2id */, X86::PF2IDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5980 /* pf2id */, X86::PF2IDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5986 /* pf2iw */, X86::PF2IWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5986 /* pf2iw */, X86::PF2IWrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5992 /* pfacc */, X86::PFACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5992 /* pfacc */, X86::PFACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 5998 /* pfadd */, X86::PFADDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 5998 /* pfadd */, X86::PFADDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6004 /* pfcmpeq */, X86::PFCMPEQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6004 /* pfcmpeq */, X86::PFCMPEQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6012 /* pfcmpge */, X86::PFCMPGErr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6012 /* pfcmpge */, X86::PFCMPGErm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6020 /* pfcmpgt */, X86::PFCMPGTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6020 /* pfcmpgt */, X86::PFCMPGTrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6028 /* pfmax */, X86::PFMAXrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6028 /* pfmax */, X86::PFMAXrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6034 /* pfmin */, X86::PFMINrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6034 /* pfmin */, X86::PFMINrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6040 /* pfmul */, X86::PFMULrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6040 /* pfmul */, X86::PFMULrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6046 /* pfnacc */, X86::PFNACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6046 /* pfnacc */, X86::PFNACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6053 /* pfpnacc */, X86::PFPNACCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6053 /* pfpnacc */, X86::PFPNACCrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6061 /* pfrcp */, X86::PFRCPrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6061 /* pfrcp */, X86::PFRCPrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6067 /* pfrcpit1 */, X86::PFRCPIT1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6067 /* pfrcpit1 */, X86::PFRCPIT1rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6076 /* pfrcpit2 */, X86::PFRCPIT2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6076 /* pfrcpit2 */, X86::PFRCPIT2rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6085 /* pfrsqit1 */, X86::PFRSQIT1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6085 /* pfrsqit1 */, X86::PFRSQIT1rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6094 /* pfrsqrt */, X86::PFRSQRTrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6094 /* pfrsqrt */, X86::PFRSQRTrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6102 /* pfsub */, X86::PFSUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6102 /* pfsub */, X86::PFSUBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6108 /* pfsubr */, X86::PFSUBRrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6108 /* pfsubr */, X86::PFSUBRrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6115 /* phaddd */, X86::MMX_PHADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6115 /* phaddd */, X86::PHADDDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6115 /* phaddd */, X86::PHADDDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6115 /* phaddd */, X86::MMX_PHADDDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6122 /* phaddsw */, X86::MMX_PHADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6122 /* phaddsw */, X86::PHADDSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6122 /* phaddsw */, X86::PHADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6122 /* phaddsw */, X86::MMX_PHADDSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6130 /* phaddw */, X86::MMX_PHADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6130 /* phaddw */, X86::PHADDWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6130 /* phaddw */, X86::PHADDWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6130 /* phaddw */, X86::MMX_PHADDWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6137 /* phminposuw */, X86::PHMINPOSUWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6137 /* phminposuw */, X86::PHMINPOSUWrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6148 /* phsubd */, X86::MMX_PHSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6148 /* phsubd */, X86::PHSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6148 /* phsubd */, X86::PHSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6148 /* phsubd */, X86::MMX_PHSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6155 /* phsubsw */, X86::MMX_PHSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6155 /* phsubsw */, X86::PHSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6155 /* phsubsw */, X86::PHSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6155 /* phsubsw */, X86::MMX_PHSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6163 /* phsubw */, X86::MMX_PHSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6163 /* phsubw */, X86::PHSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6163 /* phsubw */, X86::PHSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6163 /* phsubw */, X86::MMX_PHSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6170 /* pi2fd */, X86::PI2FDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6170 /* pi2fd */, X86::PI2FDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6176 /* pi2fw */, X86::PI2FWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6176 /* pi2fw */, X86::PI2FWrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6182 /* pinsrb */, X86::PINSRBrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR16 }, },
  { 6182 /* pinsrb */, X86::PINSRBrm, Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8, MCK_FR16 }, },
  { 6189 /* pinsrd */, X86::PINSRDrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_FR16 }, },
  { 6189 /* pinsrd */, X86::PINSRDrm, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16 }, },
  { 6196 /* pinsrq */, X86::PINSRQrr, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_FR16 }, },
  { 6196 /* pinsrq */, X86::PINSRQrm, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16 }, },
  { 6203 /* pinsrw */, X86::MMX_PINSRWrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_VR64 }, },
  { 6203 /* pinsrw */, X86::PINSRWrr, Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR16 }, },
  { 6203 /* pinsrw */, X86::MMX_PINSRWrm, Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_VR64 }, },
  { 6203 /* pinsrw */, X86::PINSRWrm, Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_FR16 }, },
  { 6210 /* pmaddubsw */, X86::MMX_PMADDUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6210 /* pmaddubsw */, X86::PMADDUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6210 /* pmaddubsw */, X86::PMADDUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6210 /* pmaddubsw */, X86::MMX_PMADDUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6220 /* pmaddwd */, X86::MMX_PMADDWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6220 /* pmaddwd */, X86::PMADDWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6220 /* pmaddwd */, X86::PMADDWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6220 /* pmaddwd */, X86::MMX_PMADDWDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6228 /* pmaxsb */, X86::PMAXSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6228 /* pmaxsb */, X86::PMAXSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6235 /* pmaxsd */, X86::PMAXSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6235 /* pmaxsd */, X86::PMAXSDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6242 /* pmaxsw */, X86::MMX_PMAXSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6242 /* pmaxsw */, X86::PMAXSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6242 /* pmaxsw */, X86::PMAXSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6242 /* pmaxsw */, X86::MMX_PMAXSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6249 /* pmaxub */, X86::MMX_PMAXUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6249 /* pmaxub */, X86::PMAXUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6249 /* pmaxub */, X86::PMAXUBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6249 /* pmaxub */, X86::MMX_PMAXUBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6256 /* pmaxud */, X86::PMAXUDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6256 /* pmaxud */, X86::PMAXUDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6263 /* pmaxuw */, X86::PMAXUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6263 /* pmaxuw */, X86::PMAXUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6270 /* pminsb */, X86::PMINSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6270 /* pminsb */, X86::PMINSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6277 /* pminsd */, X86::PMINSDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6277 /* pminsd */, X86::PMINSDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6284 /* pminsw */, X86::MMX_PMINSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6284 /* pminsw */, X86::PMINSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6284 /* pminsw */, X86::PMINSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6284 /* pminsw */, X86::MMX_PMINSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6291 /* pminub */, X86::MMX_PMINUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6291 /* pminub */, X86::PMINUBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6291 /* pminub */, X86::PMINUBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6291 /* pminub */, X86::MMX_PMINUBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6298 /* pminud */, X86::PMINUDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6298 /* pminud */, X86::PMINUDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6305 /* pminuw */, X86::PMINUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6305 /* pminuw */, X86::PMINUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6312 /* pmovmskb */, X86::MMX_PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_GR32orGR64 }, },
  { 6312 /* pmovmskb */, X86::PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32orGR64 }, },
  { 6321 /* pmovsxbd */, X86::PMOVSXBDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6321 /* pmovsxbd */, X86::PMOVSXBDrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 6330 /* pmovsxbq */, X86::PMOVSXBQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6330 /* pmovsxbq */, X86::PMOVSXBQrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16 }, },
  { 6339 /* pmovsxbw */, X86::PMOVSXBWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6339 /* pmovsxbw */, X86::PMOVSXBWrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6348 /* pmovsxdq */, X86::PMOVSXDQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6348 /* pmovsxdq */, X86::PMOVSXDQrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6357 /* pmovsxwd */, X86::PMOVSXWDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6357 /* pmovsxwd */, X86::PMOVSXWDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6366 /* pmovsxwq */, X86::PMOVSXWQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6366 /* pmovsxwq */, X86::PMOVSXWQrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 6375 /* pmovzxbd */, X86::PMOVZXBDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6375 /* pmovzxbd */, X86::PMOVZXBDrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 6384 /* pmovzxbq */, X86::PMOVZXBQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6384 /* pmovzxbq */, X86::PMOVZXBQrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16 }, },
  { 6393 /* pmovzxbw */, X86::PMOVZXBWrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6393 /* pmovzxbw */, X86::PMOVZXBWrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6402 /* pmovzxdq */, X86::PMOVZXDQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6402 /* pmovzxdq */, X86::PMOVZXDQrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6411 /* pmovzxwd */, X86::PMOVZXWDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6411 /* pmovzxwd */, X86::PMOVZXWDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 6420 /* pmovzxwq */, X86::PMOVZXWQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6420 /* pmovzxwq */, X86::PMOVZXWQrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 6429 /* pmuldq */, X86::PMULDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6429 /* pmuldq */, X86::PMULDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6436 /* pmulhrsw */, X86::MMX_PMULHRSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6436 /* pmulhrsw */, X86::PMULHRSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6436 /* pmulhrsw */, X86::PMULHRSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6436 /* pmulhrsw */, X86::MMX_PMULHRSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6445 /* pmulhrw */, X86::PMULHRWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6445 /* pmulhrw */, X86::PMULHRWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6453 /* pmulhuw */, X86::MMX_PMULHUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6453 /* pmulhuw */, X86::PMULHUWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6453 /* pmulhuw */, X86::PMULHUWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6453 /* pmulhuw */, X86::MMX_PMULHUWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6461 /* pmulhw */, X86::MMX_PMULHWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6461 /* pmulhw */, X86::PMULHWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6461 /* pmulhw */, X86::PMULHWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6461 /* pmulhw */, X86::MMX_PMULHWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6468 /* pmulld */, X86::PMULLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6468 /* pmulld */, X86::PMULLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6475 /* pmullw */, X86::MMX_PMULLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6475 /* pmullw */, X86::PMULLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6475 /* pmullw */, X86::PMULLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6475 /* pmullw */, X86::MMX_PMULLWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6482 /* pmuludq */, X86::MMX_PMULUDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6482 /* pmuludq */, X86::PMULUDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6482 /* pmuludq */, X86::PMULUDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6482 /* pmuludq */, X86::MMX_PMULUDQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6494 /* popal */, X86::POPA32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 6500 /* popaw */, X86::POPA16, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 6513 /* popcntl */, X86::POPCNT32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 6513 /* popcntl */, X86::POPCNT32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 6521 /* popcntq */, X86::POPCNT64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 6521 /* popcntq */, X86::POPCNT64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 6529 /* popcntw */, X86::POPCNT16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 6529 /* popcntw */, X86::POPCNT16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 6548 /* popfl */, X86::POPF32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 6554 /* popfq */, X86::POPF64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 6560 /* popfw */, X86::POPF16, Convert_NoOperands, AMFBS_None, {  }, },
  { 6566 /* popl */, X86::POPDS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_DS }, },
  { 6566 /* popl */, X86::POPES32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_ES }, },
  { 6566 /* popl */, X86::POPFS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_FS }, },
  { 6566 /* popl */, X86::POPGS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_GS }, },
  { 6566 /* popl */, X86::POPSS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_SS }, },
  { 6566 /* popl */, X86::POP32r, Convert__Reg1_0, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 6566 /* popl */, X86::POP32rmm, Convert__Mem325_0, AMFBS_Not64BitMode, { MCK_Mem32 }, },
  { 6571 /* popq */, X86::POPFS64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_FS }, },
  { 6571 /* popq */, X86::POPGS64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_GS }, },
  { 6571 /* popq */, X86::POP64r, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 6571 /* popq */, X86::POP64rmm, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 6576 /* popw */, X86::POPDS16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_DS }, },
  { 6576 /* popw */, X86::POPES16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_ES }, },
  { 6576 /* popw */, X86::POPFS16, Convert_NoOperands, AMFBS_None, { MCK_FS }, },
  { 6576 /* popw */, X86::POPGS16, Convert_NoOperands, AMFBS_None, { MCK_GS }, },
  { 6576 /* popw */, X86::POPSS16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_SS }, },
  { 6576 /* popw */, X86::POP16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 6576 /* popw */, X86::POP16rmm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 6581 /* por */, X86::MMX_PORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6581 /* por */, X86::PORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6581 /* por */, X86::PORrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6581 /* por */, X86::MMX_PORrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6585 /* prefetch */, X86::PREFETCH, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6594 /* prefetchit0 */, X86::PREFETCHIT0, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6606 /* prefetchit1 */, X86::PREFETCHIT1, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6618 /* prefetchnta */, X86::PREFETCHNTA, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6630 /* prefetcht0 */, X86::PREFETCHT0, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6641 /* prefetcht1 */, X86::PREFETCHT1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6652 /* prefetcht2 */, X86::PREFETCHT2, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6663 /* prefetchw */, X86::PREFETCHW, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6673 /* prefetchwt1 */, X86::PREFETCHWT1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6685 /* psadbw */, X86::MMX_PSADBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6685 /* psadbw */, X86::PSADBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6685 /* psadbw */, X86::PSADBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6685 /* psadbw */, X86::MMX_PSADBWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6692 /* pshufb */, X86::MMX_PSHUFBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6692 /* pshufb */, X86::PSHUFBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6692 /* pshufb */, X86::PSHUFBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6692 /* pshufb */, X86::MMX_PSHUFBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6699 /* pshufd */, X86::PSHUFDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 6699 /* pshufd */, X86::PSHUFDmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 6706 /* pshufhw */, X86::PSHUFHWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 6706 /* pshufhw */, X86::PSHUFHWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 6714 /* pshuflw */, X86::PSHUFLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 6714 /* pshuflw */, X86::PSHUFLWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 6722 /* pshufw */, X86::MMX_PSHUFWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 6722 /* pshufw */, X86::MMX_PSHUFWmi, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 6729 /* psignb */, X86::MMX_PSIGNBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6729 /* psignb */, X86::PSIGNBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6729 /* psignb */, X86::PSIGNBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6729 /* psignb */, X86::MMX_PSIGNBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6736 /* psignd */, X86::MMX_PSIGNDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6736 /* psignd */, X86::PSIGNDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6736 /* psignd */, X86::PSIGNDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6736 /* psignd */, X86::MMX_PSIGNDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6743 /* psignw */, X86::MMX_PSIGNWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6743 /* psignw */, X86::PSIGNWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6743 /* psignw */, X86::PSIGNWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6743 /* psignw */, X86::MMX_PSIGNWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6750 /* pslld */, X86::MMX_PSLLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6750 /* pslld */, X86::PSLLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6750 /* pslld */, X86::MMX_PSLLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6750 /* pslld */, X86::PSLLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6750 /* pslld */, X86::PSLLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6750 /* pslld */, X86::MMX_PSLLDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6756 /* pslldq */, X86::PSLLDQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6763 /* psllq */, X86::MMX_PSLLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6763 /* psllq */, X86::PSLLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6763 /* psllq */, X86::MMX_PSLLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6763 /* psllq */, X86::PSLLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6763 /* psllq */, X86::PSLLQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6763 /* psllq */, X86::MMX_PSLLQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6769 /* psllw */, X86::MMX_PSLLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6769 /* psllw */, X86::PSLLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6769 /* psllw */, X86::MMX_PSLLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6769 /* psllw */, X86::PSLLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6769 /* psllw */, X86::PSLLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6769 /* psllw */, X86::MMX_PSLLWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6775 /* psmash */, X86::PSMASH, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 6775 /* psmash */, X86::PSMASH, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX }, },
  { 6782 /* psrad */, X86::MMX_PSRADrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6782 /* psrad */, X86::PSRADrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6782 /* psrad */, X86::MMX_PSRADri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6782 /* psrad */, X86::PSRADri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6782 /* psrad */, X86::PSRADrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6782 /* psrad */, X86::MMX_PSRADrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6788 /* psraw */, X86::MMX_PSRAWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6788 /* psraw */, X86::PSRAWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6788 /* psraw */, X86::MMX_PSRAWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6788 /* psraw */, X86::PSRAWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6788 /* psraw */, X86::PSRAWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6788 /* psraw */, X86::MMX_PSRAWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6794 /* psrld */, X86::MMX_PSRLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6794 /* psrld */, X86::PSRLDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6794 /* psrld */, X86::MMX_PSRLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6794 /* psrld */, X86::PSRLDri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6794 /* psrld */, X86::PSRLDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6794 /* psrld */, X86::MMX_PSRLDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6800 /* psrldq */, X86::PSRLDQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6807 /* psrlq */, X86::MMX_PSRLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6807 /* psrlq */, X86::PSRLQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6807 /* psrlq */, X86::MMX_PSRLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6807 /* psrlq */, X86::PSRLQri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6807 /* psrlq */, X86::PSRLQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6807 /* psrlq */, X86::MMX_PSRLQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6813 /* psrlw */, X86::MMX_PSRLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6813 /* psrlw */, X86::PSRLWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6813 /* psrlw */, X86::MMX_PSRLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 6813 /* psrlw */, X86::PSRLWri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 6813 /* psrlw */, X86::PSRLWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6813 /* psrlw */, X86::MMX_PSRLWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6819 /* psubb */, X86::MMX_PSUBBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6819 /* psubb */, X86::PSUBBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6819 /* psubb */, X86::PSUBBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6819 /* psubb */, X86::MMX_PSUBBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6825 /* psubd */, X86::MMX_PSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6825 /* psubd */, X86::PSUBDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6825 /* psubd */, X86::PSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6825 /* psubd */, X86::MMX_PSUBDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6831 /* psubq */, X86::MMX_PSUBQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6831 /* psubq */, X86::PSUBQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6831 /* psubq */, X86::PSUBQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6831 /* psubq */, X86::MMX_PSUBQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6837 /* psubsb */, X86::MMX_PSUBSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6837 /* psubsb */, X86::PSUBSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6837 /* psubsb */, X86::PSUBSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6837 /* psubsb */, X86::MMX_PSUBSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6844 /* psubsw */, X86::MMX_PSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6844 /* psubsw */, X86::PSUBSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6844 /* psubsw */, X86::PSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6844 /* psubsw */, X86::MMX_PSUBSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6851 /* psubusb */, X86::MMX_PSUBUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6851 /* psubusb */, X86::PSUBUSBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6851 /* psubusb */, X86::PSUBUSBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6851 /* psubusb */, X86::MMX_PSUBUSBrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6859 /* psubusw */, X86::MMX_PSUBUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6859 /* psubusw */, X86::PSUBUSWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6859 /* psubusw */, X86::PSUBUSWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6859 /* psubusw */, X86::MMX_PSUBUSWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6867 /* psubw */, X86::MMX_PSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6867 /* psubw */, X86::PSUBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6867 /* psubw */, X86::PSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6867 /* psubw */, X86::MMX_PSUBWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6873 /* pswapd */, X86::PSWAPDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6873 /* pswapd */, X86::PSWAPDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6880 /* ptest */, X86::PTESTrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6880 /* ptest */, X86::PTESTrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6894 /* ptwritel */, X86::PTWRITEr, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 6894 /* ptwritel */, X86::PTWRITEm, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6903 /* ptwriteq */, X86::PTWRITE64r, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 6903 /* ptwriteq */, X86::PTWRITE64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 6912 /* punpckhbw */, X86::MMX_PUNPCKHBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6912 /* punpckhbw */, X86::PUNPCKHBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6912 /* punpckhbw */, X86::PUNPCKHBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6912 /* punpckhbw */, X86::MMX_PUNPCKHBWrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6922 /* punpckhdq */, X86::MMX_PUNPCKHDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6922 /* punpckhdq */, X86::PUNPCKHDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6922 /* punpckhdq */, X86::PUNPCKHDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6922 /* punpckhdq */, X86::MMX_PUNPCKHDQrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6932 /* punpckhqdq */, X86::PUNPCKHQDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6932 /* punpckhqdq */, X86::PUNPCKHQDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6943 /* punpckhwd */, X86::MMX_PUNPCKHWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6943 /* punpckhwd */, X86::PUNPCKHWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6943 /* punpckhwd */, X86::PUNPCKHWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6943 /* punpckhwd */, X86::MMX_PUNPCKHWDrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 6953 /* punpcklbw */, X86::MMX_PUNPCKLBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6953 /* punpcklbw */, X86::PUNPCKLBWrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6953 /* punpcklbw */, X86::PUNPCKLBWrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6953 /* punpcklbw */, X86::MMX_PUNPCKLBWrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR64 }, },
  { 6963 /* punpckldq */, X86::MMX_PUNPCKLDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6963 /* punpckldq */, X86::PUNPCKLDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6963 /* punpckldq */, X86::PUNPCKLDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6963 /* punpckldq */, X86::MMX_PUNPCKLDQrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR64 }, },
  { 6973 /* punpcklqdq */, X86::PUNPCKLQDQrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6973 /* punpcklqdq */, X86::PUNPCKLQDQrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6984 /* punpcklwd */, X86::MMX_PUNPCKLWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 6984 /* punpcklwd */, X86::PUNPCKLWDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6984 /* punpcklwd */, X86::PUNPCKLWDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6984 /* punpcklwd */, X86::MMX_PUNPCKLWDrm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR64 }, },
  { 6999 /* pushal */, X86::PUSHA32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7006 /* pushaw */, X86::PUSHA16, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7026 /* pushfl */, X86::PUSHF32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7033 /* pushfq */, X86::PUSHF64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7040 /* pushfw */, X86::PUSHF16, Convert_NoOperands, AMFBS_None, {  }, },
  { 7047 /* pushl */, X86::PUSHCS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_CS }, },
  { 7047 /* pushl */, X86::PUSHDS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_DS }, },
  { 7047 /* pushl */, X86::PUSHES32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_ES }, },
  { 7047 /* pushl */, X86::PUSHFS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_FS }, },
  { 7047 /* pushl */, X86::PUSHGS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_GS }, },
  { 7047 /* pushl */, X86::PUSHSS32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_SS }, },
  { 7047 /* pushl */, X86::PUSH32r, Convert__Reg1_0, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 7047 /* pushl */, X86::PUSH32i8, Convert__ImmSExti32i81_0, AMFBS_Not64BitMode, { MCK_ImmSExti32i8 }, },
  { 7047 /* pushl */, X86::PUSH32i, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 7047 /* pushl */, X86::PUSH32rmm, Convert__Mem325_0, AMFBS_Not64BitMode, { MCK_Mem32 }, },
  { 7053 /* pushq */, X86::PUSHFS64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_FS }, },
  { 7053 /* pushq */, X86::PUSHGS64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_GS }, },
  { 7053 /* pushq */, X86::PUSH64r, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 7053 /* pushq */, X86::PUSH64i8, Convert__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8 }, },
  { 7053 /* pushq */, X86::PUSH64i32, Convert__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32 }, },
  { 7053 /* pushq */, X86::PUSH64rmm, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7059 /* pushw */, X86::PUSHCS16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_CS }, },
  { 7059 /* pushw */, X86::PUSHDS16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_DS }, },
  { 7059 /* pushw */, X86::PUSHES16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_ES }, },
  { 7059 /* pushw */, X86::PUSHFS16, Convert_NoOperands, AMFBS_None, { MCK_FS }, },
  { 7059 /* pushw */, X86::PUSHGS16, Convert_NoOperands, AMFBS_None, { MCK_GS }, },
  { 7059 /* pushw */, X86::PUSHSS16, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_SS }, },
  { 7059 /* pushw */, X86::PUSH16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 7059 /* pushw */, X86::PUSH16i8, Convert__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8 }, },
  { 7059 /* pushw */, X86::PUSH16i, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 7059 /* pushw */, X86::PUSH16rmm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7065 /* pvalidate */, X86::PVALIDATE64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7065 /* pvalidate */, X86::PVALIDATE32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7065 /* pvalidate */, X86::PVALIDATE32, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 7065 /* pvalidate */, X86::PVALIDATE64, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 7075 /* pxor */, X86::MMX_PXORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_VR64 }, },
  { 7075 /* pxor */, X86::PXORrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7075 /* pxor */, X86::PXORrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7075 /* pxor */, X86::MMX_PXORrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 7084 /* rclb */, X86::RCL8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7084 /* rclb */, X86::RCL8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7084 /* rclb */, X86::RCL8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7084 /* rclb */, X86::RCL8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7084 /* rclb */, X86::RCL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7084 /* rclb */, X86::RCL8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7089 /* rcll */, X86::RCL32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7089 /* rcll */, X86::RCL32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7089 /* rcll */, X86::RCL32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7089 /* rcll */, X86::RCL32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7089 /* rcll */, X86::RCL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7089 /* rcll */, X86::RCL32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7094 /* rclq */, X86::RCL64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7094 /* rclq */, X86::RCL64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7094 /* rclq */, X86::RCL64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7094 /* rclq */, X86::RCL64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7094 /* rclq */, X86::RCL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7094 /* rclq */, X86::RCL64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7099 /* rclw */, X86::RCL16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7099 /* rclw */, X86::RCL16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7099 /* rclw */, X86::RCL16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7099 /* rclw */, X86::RCL16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7099 /* rclw */, X86::RCL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7099 /* rclw */, X86::RCL16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7104 /* rcpps */, X86::RCPPSr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7104 /* rcpps */, X86::RCPPSm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7110 /* rcpss */, X86::RCPSSr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7110 /* rcpss */, X86::RCPSSm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 7120 /* rcrb */, X86::RCR8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7120 /* rcrb */, X86::RCR8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7120 /* rcrb */, X86::RCR8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7120 /* rcrb */, X86::RCR8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7120 /* rcrb */, X86::RCR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7120 /* rcrb */, X86::RCR8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7125 /* rcrl */, X86::RCR32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7125 /* rcrl */, X86::RCR32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7125 /* rcrl */, X86::RCR32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7125 /* rcrl */, X86::RCR32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7125 /* rcrl */, X86::RCR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7125 /* rcrl */, X86::RCR32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7130 /* rcrq */, X86::RCR64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7130 /* rcrq */, X86::RCR64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7130 /* rcrq */, X86::RCR64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7130 /* rcrq */, X86::RCR64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7130 /* rcrq */, X86::RCR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7130 /* rcrq */, X86::RCR64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7135 /* rcrw */, X86::RCR16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7135 /* rcrw */, X86::RCR16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7135 /* rcrw */, X86::RCR16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7135 /* rcrw */, X86::RCR16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7135 /* rcrw */, X86::RCR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7135 /* rcrw */, X86::RCR16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7149 /* rdfsbasel */, X86::RDFSBASE, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 7159 /* rdfsbaseq */, X86::RDFSBASE64, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 7178 /* rdgsbasel */, X86::RDGSBASE, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 7188 /* rdgsbaseq */, X86::RDGSBASE64, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 7198 /* rdmsr */, X86::RDMSR, Convert_NoOperands, AMFBS_None, {  }, },
  { 7204 /* rdmsrlist */, X86::RDMSRLIST, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7214 /* rdpid */, X86::RDPID32, Convert__Reg1_0, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 7214 /* rdpid */, X86::RDPID64, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 7220 /* rdpkru */, X86::RDPKRUr, Convert_NoOperands, AMFBS_None, {  }, },
  { 7227 /* rdpmc */, X86::RDPMC, Convert_NoOperands, AMFBS_None, {  }, },
  { 7233 /* rdpru */, X86::RDPRU, Convert_NoOperands, AMFBS_None, {  }, },
  { 7246 /* rdrandl */, X86::RDRAND32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 7254 /* rdrandq */, X86::RDRAND64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 7262 /* rdrandw */, X86::RDRAND16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 7277 /* rdseedl */, X86::RDSEED32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 7285 /* rdseedq */, X86::RDSEED64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 7293 /* rdseedw */, X86::RDSEED16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 7301 /* rdsspd */, X86::RDSSPD, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7308 /* rdsspq */, X86::RDSSPQ, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7315 /* rdtsc */, X86::RDTSC, Convert_NoOperands, AMFBS_None, {  }, },
  { 7321 /* rdtscp */, X86::RDTSCP, Convert_NoOperands, AMFBS_None, {  }, },
  { 7328 /* rep */, X86::REP_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 7332 /* repne */, X86::REPNE_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 7353 /* retl */, X86::RET32, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7353 /* retl */, X86::RETI32, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 7358 /* retq */, X86::RET64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7358 /* retq */, X86::RETI64, Convert__Imm1_0, AMFBS_In64BitMode, { MCK_Imm }, },
  { 7363 /* retw */, X86::RET16, Convert_NoOperands, AMFBS_None, {  }, },
  { 7363 /* retw */, X86::RETI16, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 7368 /* rex64 */, X86::REX64_PREFIX, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7374 /* rmpadjust */, X86::RMPADJUST, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7374 /* rmpadjust */, X86::RMPADJUST, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 7384 /* rmpquery */, X86::RMPQUERY, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7384 /* rmpquery */, X86::RMPQUERY, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RDX }, },
  { 7393 /* rmpupdate */, X86::RMPUPDATE, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7393 /* rmpupdate */, X86::RMPUPDATE, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX, MCK_RCX }, },
  { 7407 /* rolb */, X86::ROL8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7407 /* rolb */, X86::ROL8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7407 /* rolb */, X86::ROL8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7407 /* rolb */, X86::ROL8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7407 /* rolb */, X86::ROL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7407 /* rolb */, X86::ROL8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7412 /* roll */, X86::ROL32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7412 /* roll */, X86::ROL32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7412 /* roll */, X86::ROL32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7412 /* roll */, X86::ROL32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7412 /* roll */, X86::ROL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7412 /* roll */, X86::ROL32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7417 /* rolq */, X86::ROL64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7417 /* rolq */, X86::ROL64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7417 /* rolq */, X86::ROL64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7417 /* rolq */, X86::ROL64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7417 /* rolq */, X86::ROL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7417 /* rolq */, X86::ROL64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7422 /* rolw */, X86::ROL16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7422 /* rolw */, X86::ROL16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7422 /* rolw */, X86::ROL16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7422 /* rolw */, X86::ROL16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7422 /* rolw */, X86::ROL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7422 /* rolw */, X86::ROL16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7431 /* rorb */, X86::ROR8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7431 /* rorb */, X86::ROR8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7431 /* rorb */, X86::ROR8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7431 /* rorb */, X86::ROR8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7431 /* rorb */, X86::ROR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7431 /* rorb */, X86::ROR8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7436 /* rorl */, X86::ROR32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7436 /* rorl */, X86::ROR32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7436 /* rorl */, X86::ROR32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7436 /* rorl */, X86::ROR32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7436 /* rorl */, X86::ROR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7436 /* rorl */, X86::ROR32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7441 /* rorq */, X86::ROR64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7441 /* rorq */, X86::ROR64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7441 /* rorq */, X86::ROR64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7441 /* rorq */, X86::ROR64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7441 /* rorq */, X86::ROR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7441 /* rorq */, X86::ROR64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7446 /* rorw */, X86::ROR16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7446 /* rorw */, X86::ROR16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7446 /* rorw */, X86::ROR16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7446 /* rorw */, X86::ROR16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7446 /* rorw */, X86::ROR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7446 /* rorw */, X86::ROR16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7456 /* rorxl */, X86::RORX32ri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 7456 /* rorxl */, X86::RORX32mi, Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_GR32 }, },
  { 7462 /* rorxq */, X86::RORX64ri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 7462 /* rorxq */, X86::RORX64mi, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_GR64 }, },
  { 7468 /* roundpd */, X86::ROUNDPDr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 7468 /* roundpd */, X86::ROUNDPDm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 7476 /* roundps */, X86::ROUNDPSr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 7476 /* roundps */, X86::ROUNDPSm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 7484 /* roundsd */, X86::ROUNDSDr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 7484 /* roundsd */, X86::ROUNDSDm_Int, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16 }, },
  { 7492 /* roundss */, X86::ROUNDSSr_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 7492 /* roundss */, X86::ROUNDSSm_Int, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16 }, },
  { 7500 /* rsm */, X86::RSM, Convert_NoOperands, AMFBS_None, {  }, },
  { 7504 /* rsqrtps */, X86::RSQRTPSr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7504 /* rsqrtps */, X86::RSQRTPSm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7512 /* rsqrtss */, X86::RSQRTSSr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7512 /* rsqrtss */, X86::RSQRTSSm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 7520 /* rstorssp */, X86::RSTORSSP, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7529 /* sahf */, X86::SAHF, Convert_NoOperands, AMFBS_None, {  }, },
  { 7534 /* salc */, X86::SALC, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 7543 /* sarb */, X86::SAR8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7543 /* sarb */, X86::SAR8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7543 /* sarb */, X86::SAR8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7543 /* sarb */, X86::SAR8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7543 /* sarb */, X86::SAR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7543 /* sarb */, X86::SAR8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7548 /* sarl */, X86::SAR32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7548 /* sarl */, X86::SAR32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7548 /* sarl */, X86::SAR32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7548 /* sarl */, X86::SAR32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7548 /* sarl */, X86::SAR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7548 /* sarl */, X86::SAR32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7553 /* sarq */, X86::SAR64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7553 /* sarq */, X86::SAR64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7553 /* sarq */, X86::SAR64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7553 /* sarq */, X86::SAR64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7553 /* sarq */, X86::SAR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7553 /* sarq */, X86::SAR64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7558 /* sarw */, X86::SAR16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7558 /* sarw */, X86::SAR16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7558 /* sarw */, X86::SAR16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7558 /* sarw */, X86::SAR16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7558 /* sarw */, X86::SAR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7558 /* sarw */, X86::SAR16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7568 /* sarxl */, X86::SARX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7568 /* sarxl */, X86::SARX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 7574 /* sarxq */, X86::SARX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7574 /* sarxq */, X86::SARX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 7580 /* saveprevssp */, X86::SAVEPREVSSP, Convert_NoOperands, AMFBS_None, {  }, },
  { 7596 /* sbbb */, X86::SBB8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 7596 /* sbbb */, X86::SBB8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 7596 /* sbbb */, X86::SBB8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 7596 /* sbbb */, X86::SBB8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 7596 /* sbbb */, X86::SBB8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 7596 /* sbbb */, X86::SBB8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 7601 /* sbbl */, X86::SBB32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7601 /* sbbl */, X86::SBB32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 7601 /* sbbl */, X86::SBB32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 7601 /* sbbl */, X86::SBB32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 7601 /* sbbl */, X86::SBB32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 7601 /* sbbl */, X86::SBB32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 7601 /* sbbl */, X86::SBB32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 7601 /* sbbl */, X86::SBB32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 7601 /* sbbl */, X86::SBB32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 7606 /* sbbq */, X86::SBB64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7606 /* sbbq */, X86::SBB64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 7606 /* sbbq */, X86::SBB64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 7606 /* sbbq */, X86::SBB64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 7606 /* sbbq */, X86::SBB64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 7606 /* sbbq */, X86::SBB64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7606 /* sbbq */, X86::SBB64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7606 /* sbbq */, X86::SBB64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7606 /* sbbq */, X86::SBB64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 7611 /* sbbw */, X86::SBB16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 7611 /* sbbw */, X86::SBB16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 7611 /* sbbw */, X86::SBB16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 7611 /* sbbw */, X86::SBB16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 7611 /* sbbw */, X86::SBB16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 7611 /* sbbw */, X86::SBB16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 7611 /* sbbw */, X86::SBB16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 7611 /* sbbw */, X86::SBB16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 7611 /* sbbw */, X86::SBB16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 7616 /* scas */, X86::SCASW, Convert__DstIdx161_0, AMFBS_None, { MCK_DstIdx16, MCK_AX }, },
  { 7616 /* scas */, X86::SCASL, Convert__DstIdx321_0, AMFBS_None, { MCK_DstIdx32, MCK_EAX }, },
  { 7616 /* scas */, X86::SCASQ, Convert__DstIdx641_0, AMFBS_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 7616 /* scas */, X86::SCASB, Convert__DstIdx81_0, AMFBS_None, { MCK_DstIdx8, MCK_AL }, },
  { 7621 /* scasb */, X86::SCASB, Convert__DstIdx81_0, AMFBS_None, { MCK_DstIdx8 }, },
  { 7621 /* scasb */, X86::SCASB, Convert__DstIdx81_0, AMFBS_None, { MCK_DstIdx8, MCK_AL }, },
  { 7633 /* scasl */, X86::SCASL, Convert__DstIdx321_0, AMFBS_None, { MCK_DstIdx32 }, },
  { 7633 /* scasl */, X86::SCASL, Convert__DstIdx321_0, AMFBS_None, { MCK_DstIdx32, MCK_EAX }, },
  { 7639 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, AMFBS_In64BitMode, { MCK_DstIdx64 }, },
  { 7639 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, AMFBS_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 7645 /* scasw */, X86::SCASW, Convert__DstIdx161_0, AMFBS_None, { MCK_DstIdx16 }, },
  { 7645 /* scasw */, X86::SCASW, Convert__DstIdx161_0, AMFBS_None, { MCK_DstIdx16, MCK_AX }, },
  { 7651 /* seamcall */, X86::SEAMCALL, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7660 /* seamops */, X86::SEAMOPS, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7668 /* seamret */, X86::SEAMRET, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 7676 /* senduipi */, X86::SENDUIPI, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 7685 /* serialize */, X86::SERIALIZE, Convert_NoOperands, AMFBS_None, {  }, },
  { 7695 /* seta */, X86::SETCCr, Convert__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR8 }, },
  { 7695 /* seta */, X86::SETCCm, Convert__Mem85_0__imm_95_7, AMFBS_None, { MCK_Mem8 }, },
  { 7700 /* setae */, X86::SETCCr, Convert__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR8 }, },
  { 7700 /* setae */, X86::SETCCm, Convert__Mem85_0__imm_95_3, AMFBS_None, { MCK_Mem8 }, },
  { 7706 /* setb */, X86::SETCCr, Convert__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR8 }, },
  { 7706 /* setb */, X86::SETCCm, Convert__Mem85_0__imm_95_2, AMFBS_None, { MCK_Mem8 }, },
  { 7711 /* setbe */, X86::SETCCr, Convert__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR8 }, },
  { 7711 /* setbe */, X86::SETCCm, Convert__Mem85_0__imm_95_6, AMFBS_None, { MCK_Mem8 }, },
  { 7717 /* sete */, X86::SETCCr, Convert__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR8 }, },
  { 7717 /* sete */, X86::SETCCm, Convert__Mem85_0__imm_95_4, AMFBS_None, { MCK_Mem8 }, },
  { 7722 /* setg */, X86::SETCCr, Convert__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR8 }, },
  { 7722 /* setg */, X86::SETCCm, Convert__Mem85_0__imm_95_15, AMFBS_None, { MCK_Mem8 }, },
  { 7727 /* setge */, X86::SETCCr, Convert__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR8 }, },
  { 7727 /* setge */, X86::SETCCm, Convert__Mem85_0__imm_95_13, AMFBS_None, { MCK_Mem8 }, },
  { 7733 /* setl */, X86::SETCCr, Convert__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR8 }, },
  { 7733 /* setl */, X86::SETCCm, Convert__Mem85_0__imm_95_12, AMFBS_None, { MCK_Mem8 }, },
  { 7738 /* setle */, X86::SETCCr, Convert__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR8 }, },
  { 7738 /* setle */, X86::SETCCm, Convert__Mem85_0__imm_95_14, AMFBS_None, { MCK_Mem8 }, },
  { 7744 /* setne */, X86::SETCCr, Convert__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR8 }, },
  { 7744 /* setne */, X86::SETCCm, Convert__Mem85_0__imm_95_5, AMFBS_None, { MCK_Mem8 }, },
  { 7750 /* setno */, X86::SETCCr, Convert__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR8 }, },
  { 7750 /* setno */, X86::SETCCm, Convert__Mem85_0__imm_95_1, AMFBS_None, { MCK_Mem8 }, },
  { 7756 /* setnp */, X86::SETCCr, Convert__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR8 }, },
  { 7756 /* setnp */, X86::SETCCm, Convert__Mem85_0__imm_95_11, AMFBS_None, { MCK_Mem8 }, },
  { 7762 /* setns */, X86::SETCCr, Convert__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR8 }, },
  { 7762 /* setns */, X86::SETCCm, Convert__Mem85_0__imm_95_9, AMFBS_None, { MCK_Mem8 }, },
  { 7768 /* seto */, X86::SETCCr, Convert__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR8 }, },
  { 7768 /* seto */, X86::SETCCm, Convert__Mem85_0__imm_95_0, AMFBS_None, { MCK_Mem8 }, },
  { 7773 /* setp */, X86::SETCCr, Convert__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR8 }, },
  { 7773 /* setp */, X86::SETCCm, Convert__Mem85_0__imm_95_10, AMFBS_None, { MCK_Mem8 }, },
  { 7778 /* sets */, X86::SETCCr, Convert__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR8 }, },
  { 7778 /* sets */, X86::SETCCm, Convert__Mem85_0__imm_95_8, AMFBS_None, { MCK_Mem8 }, },
  { 7783 /* setssbsy */, X86::SETSSBSY, Convert_NoOperands, AMFBS_None, {  }, },
  { 7792 /* sfence */, X86::SFENCE, Convert_NoOperands, AMFBS_None, {  }, },
  { 7810 /* sgdtl */, X86::SGDT32m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 7816 /* sgdtq */, X86::SGDT64m, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 7822 /* sgdtw */, X86::SGDT16m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 7828 /* sha1msg1 */, X86::SHA1MSG1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7828 /* sha1msg1 */, X86::SHA1MSG1rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7837 /* sha1msg2 */, X86::SHA1MSG2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7837 /* sha1msg2 */, X86::SHA1MSG2rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7846 /* sha1nexte */, X86::SHA1NEXTErr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7846 /* sha1nexte */, X86::SHA1NEXTErm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7856 /* sha1rnds4 */, X86::SHA1RNDS4rri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 7856 /* sha1rnds4 */, X86::SHA1RNDS4rmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 7866 /* sha256msg1 */, X86::SHA256MSG1rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7866 /* sha256msg1 */, X86::SHA256MSG1rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7877 /* sha256msg2 */, X86::SHA256MSG2rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7877 /* sha256msg2 */, X86::SHA256MSG2rm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7888 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 7888 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 7888 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 7888 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 7904 /* shlb */, X86::SHL8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7904 /* shlb */, X86::SHL8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7904 /* shlb */, X86::SHL8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7904 /* shlb */, X86::SHL8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7904 /* shlb */, X86::SHL8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7904 /* shlb */, X86::SHL8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7914 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7914 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 7914 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 7914 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 7914 /* shldl */, X86::SHLD32rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 7914 /* shldl */, X86::SHLD32mri8, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_Mem32 }, },
  { 7920 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7920 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 7920 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 7920 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 7920 /* shldq */, X86::SHLD64rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 7920 /* shldq */, X86::SHLD64mri8, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_Mem64 }, },
  { 7926 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 7926 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 7926 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 7926 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 7926 /* shldw */, X86::SHLD16rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16, MCK_GR16 }, },
  { 7926 /* shldw */, X86::SHLD16mri8, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16, MCK_Mem16 }, },
  { 7932 /* shll */, X86::SHL32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7932 /* shll */, X86::SHL32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7932 /* shll */, X86::SHL32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7932 /* shll */, X86::SHL32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7932 /* shll */, X86::SHL32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7932 /* shll */, X86::SHL32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 7937 /* shlq */, X86::SHL64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 7937 /* shlq */, X86::SHL64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 7937 /* shlq */, X86::SHL64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 7937 /* shlq */, X86::SHL64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 7937 /* shlq */, X86::SHL64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 7937 /* shlq */, X86::SHL64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 7942 /* shlw */, X86::SHL16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 7942 /* shlw */, X86::SHL16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 7942 /* shlw */, X86::SHL16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 7942 /* shlw */, X86::SHL16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 7942 /* shlw */, X86::SHL16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 7942 /* shlw */, X86::SHL16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 7952 /* shlxl */, X86::SHLX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7952 /* shlxl */, X86::SHLX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 7958 /* shlxq */, X86::SHLX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7958 /* shlxq */, X86::SHLX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 7968 /* shrb */, X86::SHR8r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 7968 /* shrb */, X86::SHR8m1, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 7968 /* shrb */, X86::SHR8rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR8 }, },
  { 7968 /* shrb */, X86::SHR8mCL, Convert__Mem85_1, AMFBS_None, { MCK_CL, MCK_Mem8 }, },
  { 7968 /* shrb */, X86::SHR8ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR8 }, },
  { 7968 /* shrb */, X86::SHR8mi, Convert__Mem85_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem8 }, },
  { 7978 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7978 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 7978 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 7978 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 7978 /* shrdl */, X86::SHRD32rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_GR32 }, },
  { 7978 /* shrdl */, X86::SHRD32mri8, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32, MCK_Mem32 }, },
  { 7984 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7984 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 7984 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 7984 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 7984 /* shrdq */, X86::SHRD64rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_GR64 }, },
  { 7984 /* shrdq */, X86::SHRD64mri8, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64, MCK_Mem64 }, },
  { 7990 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 7990 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 7990 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 7990 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_2__Reg1_1, AMFBS_None, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 7990 /* shrdw */, X86::SHRD16rri8, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16, MCK_GR16 }, },
  { 7990 /* shrdw */, X86::SHRD16mri8, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16, MCK_Mem16 }, },
  { 7996 /* shrl */, X86::SHR32r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 7996 /* shrl */, X86::SHR32m1, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 7996 /* shrl */, X86::SHR32rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR32 }, },
  { 7996 /* shrl */, X86::SHR32mCL, Convert__Mem325_1, AMFBS_None, { MCK_CL, MCK_Mem32 }, },
  { 7996 /* shrl */, X86::SHR32ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 7996 /* shrl */, X86::SHR32mi, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 8001 /* shrq */, X86::SHR64r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 8001 /* shrq */, X86::SHR64m1, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 8001 /* shrq */, X86::SHR64rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR64 }, },
  { 8001 /* shrq */, X86::SHR64mCL, Convert__Mem645_1, AMFBS_In64BitMode, { MCK_CL, MCK_Mem64 }, },
  { 8001 /* shrq */, X86::SHR64ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 8001 /* shrq */, X86::SHR64mi, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 8006 /* shrw */, X86::SHR16r1, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 8006 /* shrw */, X86::SHR16m1, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 8006 /* shrw */, X86::SHR16rCL, Convert__Reg1_1__Tie0_1_1, AMFBS_None, { MCK_CL, MCK_GR16 }, },
  { 8006 /* shrw */, X86::SHR16mCL, Convert__Mem165_1, AMFBS_None, { MCK_CL, MCK_Mem16 }, },
  { 8006 /* shrw */, X86::SHR16ri, Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 8006 /* shrw */, X86::SHR16mi, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 8016 /* shrxl */, X86::SHRX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8016 /* shrxl */, X86::SHRX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 8022 /* shrxq */, X86::SHRX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8022 /* shrxq */, X86::SHRX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 8028 /* shufpd */, X86::SHUFPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 8028 /* shufpd */, X86::SHUFPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 8035 /* shufps */, X86::SHUFPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 8035 /* shufps */, X86::SHUFPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 8053 /* sidtl */, X86::SIDT32m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 8059 /* sidtq */, X86::SIDT64m, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 8065 /* sidtw */, X86::SIDT16m, Convert__Mem5_0, AMFBS_Not64BitMode, { MCK_Mem }, },
  { 8071 /* skinit */, X86::SKINIT, Convert_NoOperands, AMFBS_None, {  }, },
  { 8071 /* skinit */, X86::SKINIT, Convert_NoOperands, AMFBS_None, { MCK_EAX }, },
  { 8078 /* sldt */, X86::SLDT16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 8083 /* sldtl */, X86::SLDT32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 8089 /* sldtq */, X86::SLDT64r, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 8095 /* sldtw */, X86::SLDT16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 8095 /* sldtw */, X86::SLDT16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 8101 /* slwpcb */, X86::SLWPCB, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 8101 /* slwpcb */, X86::SLWPCB64, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 8113 /* smswl */, X86::SMSW32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 8119 /* smswq */, X86::SMSW64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 8125 /* smsww */, X86::SMSW16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 8125 /* smsww */, X86::SMSW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 8131 /* sqrtpd */, X86::SQRTPDr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8131 /* sqrtpd */, X86::SQRTPDm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8138 /* sqrtps */, X86::SQRTPSr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8138 /* sqrtps */, X86::SQRTPSm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8145 /* sqrtsd */, X86::SQRTSDr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8145 /* sqrtsd */, X86::SQRTSDm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 8152 /* sqrtss */, X86::SQRTSSr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8152 /* sqrtss */, X86::SQRTSSm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 8159 /* ss */, X86::SS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 8162 /* stac */, X86::STAC, Convert_NoOperands, AMFBS_None, {  }, },
  { 8167 /* stc */, X86::STC, Convert_NoOperands, AMFBS_None, {  }, },
  { 8171 /* std */, X86::STD, Convert_NoOperands, AMFBS_None, {  }, },
  { 8175 /* stgi */, X86::STGI, Convert_NoOperands, AMFBS_None, {  }, },
  { 8180 /* sti */, X86::STI, Convert_NoOperands, AMFBS_None, {  }, },
  { 8184 /* stmxcsr */, X86::STMXCSR, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 8192 /* stos */, X86::STOSB, Convert__DstIdx81_1, AMFBS_None, { MCK_AL, MCK_DstIdx8 }, },
  { 8192 /* stos */, X86::STOSW, Convert__DstIdx161_1, AMFBS_None, { MCK_AX, MCK_DstIdx16 }, },
  { 8192 /* stos */, X86::STOSL, Convert__DstIdx321_1, AMFBS_None, { MCK_EAX, MCK_DstIdx32 }, },
  { 8192 /* stos */, X86::STOSQ, Convert__DstIdx641_1, AMFBS_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 8197 /* stosb */, X86::STOSB, Convert__DstIdx81_0, AMFBS_None, { MCK_DstIdx8 }, },
  { 8197 /* stosb */, X86::STOSB, Convert__DstIdx81_1, AMFBS_None, { MCK_AL, MCK_DstIdx8 }, },
  { 8209 /* stosl */, X86::STOSL, Convert__DstIdx321_0, AMFBS_None, { MCK_DstIdx32 }, },
  { 8209 /* stosl */, X86::STOSL, Convert__DstIdx321_1, AMFBS_None, { MCK_EAX, MCK_DstIdx32 }, },
  { 8215 /* stosq */, X86::STOSQ, Convert__DstIdx641_0, AMFBS_In64BitMode, { MCK_DstIdx64 }, },
  { 8215 /* stosq */, X86::STOSQ, Convert__DstIdx641_1, AMFBS_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 8221 /* stosw */, X86::STOSW, Convert__DstIdx161_0, AMFBS_None, { MCK_DstIdx16 }, },
  { 8221 /* stosw */, X86::STOSW, Convert__DstIdx161_1, AMFBS_None, { MCK_AX, MCK_DstIdx16 }, },
  { 8231 /* strl */, X86::STR32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 8236 /* strq */, X86::STR64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 8241 /* strw */, X86::STR16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 8241 /* strw */, X86::STRm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 8246 /* sttilecfg */, X86::STTILECFG, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 8256 /* stui */, X86::STUI, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8265 /* subb */, X86::SUB8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 8265 /* subb */, X86::SUB8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 8265 /* subb */, X86::SUB8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 8265 /* subb */, X86::SUB8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 8265 /* subb */, X86::SUB8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 8265 /* subb */, X86::SUB8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 8270 /* subl */, X86::SUB32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8270 /* subl */, X86::SUB32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 8270 /* subl */, X86::SUB32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 8270 /* subl */, X86::SUB32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 8270 /* subl */, X86::SUB32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 8270 /* subl */, X86::SUB32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 8270 /* subl */, X86::SUB32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 8270 /* subl */, X86::SUB32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 8270 /* subl */, X86::SUB32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8275 /* subpd */, X86::SUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8275 /* subpd */, X86::SUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8281 /* subps */, X86::SUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8281 /* subps */, X86::SUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8287 /* subq */, X86::SUB64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8287 /* subq */, X86::SUB64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 8287 /* subq */, X86::SUB64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 8287 /* subq */, X86::SUB64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 8287 /* subq */, X86::SUB64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 8287 /* subq */, X86::SUB64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 8287 /* subq */, X86::SUB64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 8287 /* subq */, X86::SUB64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 8287 /* subq */, X86::SUB64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8292 /* subsd */, X86::SUBSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8292 /* subsd */, X86::SUBSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 8298 /* subss */, X86::SUBSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8298 /* subss */, X86::SUBSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 8304 /* subw */, X86::SUB16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 8304 /* subw */, X86::SUB16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 8304 /* subw */, X86::SUB16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 8304 /* subw */, X86::SUB16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 8304 /* subw */, X86::SUB16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 8304 /* subw */, X86::SUB16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 8304 /* subw */, X86::SUB16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 8304 /* subw */, X86::SUB16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 8304 /* subw */, X86::SUB16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 8309 /* swapgs */, X86::SWAPGS, Convert_NoOperands, AMFBS_None, {  }, },
  { 8316 /* syscall */, X86::SYSCALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8324 /* sysenter */, X86::SYSENTER, Convert_NoOperands, AMFBS_None, {  }, },
  { 8341 /* sysexitl */, X86::SYSEXIT, Convert_NoOperands, AMFBS_None, {  }, },
  { 8350 /* sysexitq */, X86::SYSEXIT64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8366 /* sysretl */, X86::SYSRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 8374 /* sysretq */, X86::SYSRET64, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8389 /* t1mskcl */, X86::T1MSKC32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8389 /* t1mskcl */, X86::T1MSKC32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8397 /* t1mskcq */, X86::T1MSKC64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8397 /* t1mskcq */, X86::T1MSKC64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8405 /* tcmmimfp16ps */, X86::TCMMIMFP16PS, Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8418 /* tcmmrlfp16ps */, X86::TCMMRLFP16PS, Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8431 /* tdcall */, X86::TDCALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8438 /* tdpbf16ps */, X86::TDPBF16PS, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8448 /* tdpbssd */, X86::TDPBSSD, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8456 /* tdpbsud */, X86::TDPBSUD, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8464 /* tdpbusd */, X86::TDPBUSD, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8472 /* tdpbuud */, X86::TDPBUUD, Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8480 /* tdpfp16ps */, X86::TDPFP16PS, Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_TILE, MCK_TILE }, },
  { 8495 /* testb */, X86::TEST8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 8495 /* testb */, X86::TEST8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 8495 /* testb */, X86::TEST8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 8495 /* testb */, X86::TEST8ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 8495 /* testb */, X86::TEST8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 8495 /* testb */, X86::TEST8mr, Convert__Mem85_0__Reg1_1, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 8501 /* testl */, X86::TEST32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8501 /* testl */, X86::TEST32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 8501 /* testl */, X86::TEST32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 8501 /* testl */, X86::TEST32ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 8501 /* testl */, X86::TEST32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 8501 /* testl */, X86::TEST32mr, Convert__Mem325_0__Reg1_1, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8507 /* testq */, X86::TEST64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8507 /* testq */, X86::TEST64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 8507 /* testq */, X86::TEST64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 8507 /* testq */, X86::TEST64ri32, Convert__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 8507 /* testq */, X86::TEST64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 8507 /* testq */, X86::TEST64mr, Convert__Mem645_0__Reg1_1, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8513 /* testui */, X86::TESTUI, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8520 /* testw */, X86::TEST16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 8520 /* testw */, X86::TEST16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 8520 /* testw */, X86::TEST16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 8520 /* testw */, X86::TEST16ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 8520 /* testw */, X86::TEST16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 8520 /* testw */, X86::TEST16mr, Convert__Mem165_0__Reg1_1, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 8526 /* tileloadd */, X86::TILELOADD, Convert__Reg1_1__SibMem5_0, AMFBS_In64BitMode, { MCK_SibMem, MCK_TILE }, },
  { 8536 /* tileloaddt1 */, X86::TILELOADDT1, Convert__Reg1_1__SibMem5_0, AMFBS_In64BitMode, { MCK_SibMem, MCK_TILE }, },
  { 8548 /* tilerelease */, X86::TILERELEASE, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8560 /* tilestored */, X86::TILESTORED, Convert__SibMem5_1__Reg1_0, AMFBS_In64BitMode, { MCK_TILE, MCK_SibMem }, },
  { 8571 /* tilezero */, X86::TILEZERO, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_TILE }, },
  { 8580 /* tlbsync */, X86::TLBSYNC, Convert_NoOperands, AMFBS_None, {  }, },
  { 8588 /* tpause */, X86::TPAUSE, Convert__GR32orGR641_0, AMFBS_None, { MCK_GR32orGR64 }, },
  { 8601 /* tzcntl */, X86::TZCNT32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8601 /* tzcntl */, X86::TZCNT32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8608 /* tzcntq */, X86::TZCNT64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8608 /* tzcntq */, X86::TZCNT64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8615 /* tzcntw */, X86::TZCNT16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 8615 /* tzcntw */, X86::TZCNT16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 8628 /* tzmskl */, X86::TZMSK32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8628 /* tzmskl */, X86::TZMSK32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8635 /* tzmskq */, X86::TZMSK64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8635 /* tzmskq */, X86::TZMSK64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8642 /* ucomisd */, X86::UCOMISDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8642 /* ucomisd */, X86::UCOMISDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 8650 /* ucomiss */, X86::UCOMISSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8650 /* ucomiss */, X86::UCOMISSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 8662 /* ud1l */, X86::UD1Lr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8662 /* ud1l */, X86::UD1Lm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 8667 /* ud1q */, X86::UD1Qr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8667 /* ud1q */, X86::UD1Qm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 8672 /* ud1w */, X86::UD1Wr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 8672 /* ud1w */, X86::UD1Wm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 8677 /* ud2 */, X86::TRAP, Convert_NoOperands, AMFBS_None, {  }, },
  { 8681 /* uiret */, X86::UIRET, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 8687 /* umonitor */, X86::UMONITOR16, Convert__Reg1_0, AMFBS_Not64BitMode, { MCK_GR16 }, },
  { 8687 /* umonitor */, X86::UMONITOR32, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 8687 /* umonitor */, X86::UMONITOR64, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 8696 /* umwait */, X86::UMWAIT, Convert__GR32orGR641_0, AMFBS_None, { MCK_GR32orGR64 }, },
  { 8703 /* unpckhpd */, X86::UNPCKHPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8703 /* unpckhpd */, X86::UNPCKHPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8712 /* unpckhps */, X86::UNPCKHPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8712 /* unpckhps */, X86::UNPCKHPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8721 /* unpcklpd */, X86::UNPCKLPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8721 /* unpcklpd */, X86::UNPCKLPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8730 /* unpcklps */, X86::UNPCKLPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8730 /* unpcklps */, X86::UNPCKLPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8739 /* v4fmaddps */, X86::V4FMADDPSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 8739 /* v4fmaddps */, X86::V4FMADDPSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8739 /* v4fmaddps */, X86::V4FMADDPSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8749 /* v4fmaddss */, X86::V4FMADDSSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8749 /* v4fmaddss */, X86::V4FMADDSSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8749 /* v4fmaddss */, X86::V4FMADDSSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8759 /* v4fnmaddps */, X86::V4FNMADDPSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 8759 /* v4fnmaddps */, X86::V4FNMADDPSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8759 /* v4fnmaddps */, X86::V4FNMADDPSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8770 /* v4fnmaddss */, X86::V4FNMADDSSrm, Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8770 /* v4fnmaddss */, X86::V4FNMADDSSrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8770 /* v4fnmaddss */, X86::V4FNMADDSSrmkz, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8781 /* vaddpd */, X86::VADDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8781 /* vaddpd */, X86::VADDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8781 /* vaddpd */, X86::VADDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8781 /* vaddpd */, X86::VADDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8781 /* vaddpd */, X86::VADDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8781 /* vaddpd */, X86::VADDPDZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8781 /* vaddpd */, X86::VADDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8781 /* vaddpd */, X86::VADDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8788 /* vaddph */, X86::VADDPHZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8788 /* vaddph */, X86::VADDPHZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8788 /* vaddph */, X86::VADDPHZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rmb, Convert__Reg1_3__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK_VR256X }, },
  { 8788 /* vaddph */, X86::VADDPHZrmb, Convert__Reg1_3__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK_VR512 }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rmb, Convert__Reg1_3__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK_FR16X }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8788 /* vaddph */, X86::VADDPHZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8795 /* vaddps */, X86::VADDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8795 /* vaddps */, X86::VADDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8795 /* vaddps */, X86::VADDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8795 /* vaddps */, X86::VADDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8795 /* vaddps */, X86::VADDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8795 /* vaddps */, X86::VADDPSZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8795 /* vaddps */, X86::VADDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8795 /* vaddps */, X86::VADDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8802 /* vaddsd */, X86::VADDSDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8802 /* vaddsd */, X86::VADDSDrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16, MCK_FR16 }, },
  { 8802 /* vaddsd */, X86::VADDSDZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 8802 /* vaddsd */, X86::VADDSDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8802 /* vaddsd */, X86::VADDSDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8802 /* vaddsd */, X86::VADDSDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8809 /* vaddsh */, X86::VADDSHZrm_Int, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X }, },
  { 8809 /* vaddsh */, X86::VADDSHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8809 /* vaddsh */, X86::VADDSHZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8809 /* vaddsh */, X86::VADDSHZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vaddss */, X86::VADDSSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8816 /* vaddss */, X86::VADDSSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8816 /* vaddss */, X86::VADDSSrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 8816 /* vaddss */, X86::VADDSSZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 8816 /* vaddss */, X86::VADDSSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8816 /* vaddss */, X86::VADDSSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8816 /* vaddss */, X86::VADDSSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8816 /* vaddss */, X86::VADDSSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vaddss */, X86::VADDSSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8816 /* vaddss */, X86::VADDSSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vaddss */, X86::VADDSSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8823 /* vaddsubpd */, X86::VADDSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8823 /* vaddsubpd */, X86::VADDSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8823 /* vaddsubpd */, X86::VADDSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8823 /* vaddsubpd */, X86::VADDSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8833 /* vaddsubps */, X86::VADDSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8833 /* vaddsubps */, X86::VADDSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8833 /* vaddsubps */, X86::VADDSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8833 /* vaddsubps */, X86::VADDSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8843 /* vaesdec */, X86::VAESDECrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8843 /* vaesdec */, X86::VAESDECYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8843 /* vaesdec */, X86::VAESDECZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8843 /* vaesdec */, X86::VAESDECZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8843 /* vaesdec */, X86::VAESDECZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8843 /* vaesdec */, X86::VAESDECrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8843 /* vaesdec */, X86::VAESDECZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8843 /* vaesdec */, X86::VAESDECYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8843 /* vaesdec */, X86::VAESDECZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8843 /* vaesdec */, X86::VAESDECZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8851 /* vaesdeclast */, X86::VAESDECLASTZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8863 /* vaesenc */, X86::VAESENCrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8863 /* vaesenc */, X86::VAESENCYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8863 /* vaesenc */, X86::VAESENCZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8863 /* vaesenc */, X86::VAESENCZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8863 /* vaesenc */, X86::VAESENCZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8863 /* vaesenc */, X86::VAESENCrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8863 /* vaesenc */, X86::VAESENCZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8863 /* vaesenc */, X86::VAESENCYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8863 /* vaesenc */, X86::VAESENCZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8863 /* vaesenc */, X86::VAESENCZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8871 /* vaesenclast */, X86::VAESENCLASTZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8883 /* vaesimc */, X86::VAESIMCrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 8883 /* vaesimc */, X86::VAESIMCrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 8891 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 8891 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8908 /* valignd */, X86::VALIGNDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8908 /* valignd */, X86::VALIGNDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8908 /* valignd */, X86::VALIGNDZrmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8908 /* valignd */, X86::VALIGNDZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8916 /* valignq */, X86::VALIGNQZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8916 /* valignq */, X86::VALIGNQZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8916 /* valignq */, X86::VALIGNQZrmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrrik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrmik, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrmbik, Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8916 /* valignq */, X86::VALIGNQZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8924 /* vandnpd */, X86::VANDNPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vandnpd */, X86::VANDNPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8924 /* vandnpd */, X86::VANDNPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vandnpd */, X86::VANDNPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8932 /* vandnps */, X86::VANDNPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8932 /* vandnps */, X86::VANDNPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8932 /* vandnps */, X86::VANDNPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8932 /* vandnps */, X86::VANDNPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8932 /* vandnps */, X86::VANDNPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8932 /* vandnps */, X86::VANDNPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8932 /* vandnps */, X86::VANDNPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8940 /* vandpd */, X86::VANDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8940 /* vandpd */, X86::VANDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8940 /* vandpd */, X86::VANDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8940 /* vandpd */, X86::VANDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8940 /* vandpd */, X86::VANDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8940 /* vandpd */, X86::VANDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8940 /* vandpd */, X86::VANDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 8947 /* vandps */, X86::VANDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8947 /* vandps */, X86::VANDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8947 /* vandps */, X86::VANDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8947 /* vandps */, X86::VANDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8947 /* vandps */, X86::VANDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 8947 /* vandps */, X86::VANDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8947 /* vandps */, X86::VANDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8947 /* vandps */, X86::VANDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8947 /* vandps */, X86::VANDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8947 /* vandps */, X86::VANDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8947 /* vandps */, X86::VANDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 8947 /* vandps */, X86::VANDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8947 /* vandps */, X86::VANDPSZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8947 /* vandps */, X86::VANDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8954 /* vbcstnebf162ps */, X86::VBCSTNEBF162PSrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16 }, },
  { 8954 /* vbcstnebf162ps */, X86::VBCSTNEBF162PSYrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_VR256 }, },
  { 8969 /* vbcstnesh2ps */, X86::VBCSTNESH2PSrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16 }, },
  { 8969 /* vbcstnesh2ps */, X86::VBCSTNESH2PSYrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_VR256 }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8982 /* vblendmpd */, X86::VBLENDMPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 8992 /* vblendmps */, X86::VBLENDMPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9002 /* vblendpd */, X86::VBLENDPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9002 /* vblendpd */, X86::VBLENDPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9002 /* vblendpd */, X86::VBLENDPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9002 /* vblendpd */, X86::VBLENDPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9011 /* vblendps */, X86::VBLENDPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9011 /* vblendps */, X86::VBLENDPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9011 /* vblendps */, X86::VBLENDPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9011 /* vblendps */, X86::VBLENDPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9020 /* vblendvpd */, X86::VBLENDVPDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9020 /* vblendvpd */, X86::VBLENDVPDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9020 /* vblendvpd */, X86::VBLENDVPDYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9020 /* vblendvpd */, X86::VBLENDVPDYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9030 /* vblendvps */, X86::VBLENDVPSrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9030 /* vblendvps */, X86::VBLENDVPSrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9030 /* vblendvps */, X86::VBLENDVPSYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9030 /* vblendvps */, X86::VBLENDVPSYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9040 /* vbroadcastf128 */, X86::VBROADCASTF128, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256 }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512 }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Z256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9055 /* vbroadcastf32x2 */, X86::VBROADCASTF32X2Zrmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9087 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9087 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9087 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9103 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9119 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9119 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9119 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9135 /* vbroadcasti128 */, X86::VBROADCASTI128, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256 }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512 }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Z256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9150 /* vbroadcasti32x2 */, X86::VBROADCASTI32X2Zrmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9166 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9182 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9182 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9182 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9198 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9214 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9214 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9214 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR256 }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDYrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256 }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512 }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vbroadcastsd */, X86::VBROADCASTSDZrmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR256 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSYrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR256 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR256X }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR512 }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9243 /* vbroadcastss */, X86::VBROADCASTSSZrmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9256 /* vcmppd */, X86::VCMPPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1 }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrribk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ128rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZ256rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9256 /* vcmppd */, X86::VCMPPDZrmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rmbi, Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrmbi, Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rmbi, Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK_VK1 }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrribk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ256rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZrmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9263 /* vcmpph */, X86::VCMPPHZ128rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9270 /* vcmpps */, X86::VCMPPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16, MCK_FR16 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1 }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrrik, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrmik, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrribk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZrmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ128rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9270 /* vcmpps */, X86::VCMPPSZ256rmbik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9277 /* vcmpsd */, X86::VCMPSDrr_Int, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrr_Int, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9277 /* vcmpsd */, X86::VCMPSDrm_Int, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16, MCK_FR16 }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrm_Int, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16X, MCK_VK1 }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrrb_Int, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrr_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrm_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9277 /* vcmpsd */, X86::VCMPSDZrrb_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrr_Int, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrm_Int, Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_FR16X, MCK_VK1 }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrrb_Int, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrr_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrm_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9284 /* vcmpsh */, X86::VCMPSHZrrb_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9291 /* vcmpss */, X86::VCMPSSrr_Int, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrr_Int, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9291 /* vcmpss */, X86::VCMPSSrm_Int, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrm_Int, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16X, MCK_VK1 }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrrb_Int, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1 }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrr_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrm_Intk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9291 /* vcmpss */, X86::VCMPSSZrrb_Intk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9298 /* vcomisd */, X86::VCOMISDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9298 /* vcomisd */, X86::VCOMISDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9298 /* vcomisd */, X86::VCOMISDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 9298 /* vcomisd */, X86::VCOMISDZrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9298 /* vcomisd */, X86::VCOMISDZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X }, },
  { 9306 /* vcomish */, X86::VCOMISHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9306 /* vcomish */, X86::VCOMISHZrm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X }, },
  { 9306 /* vcomish */, X86::VCOMISHZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X }, },
  { 9314 /* vcomiss */, X86::VCOMISSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9314 /* vcomiss */, X86::VCOMISSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9314 /* vcomiss */, X86::VCOMISSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 9314 /* vcomiss */, X86::VCOMISSZrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X }, },
  { 9314 /* vcomiss */, X86::VCOMISSZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ128mr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_Mem128 }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ256mr, Convert__Mem2565_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_Mem256 }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZmr, Convert__Mem5125_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_Mem512 }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9322 /* vcompresspd */, X86::VCOMPRESSPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ128mr, Convert__Mem1285_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_Mem128 }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ256mr, Convert__Mem2565_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_Mem256 }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZmr, Convert__Mem5125_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_Mem512 }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9334 /* vcompressps */, X86::VCOMPRESSPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR256 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDYrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9346 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9356 /* vcvtdq2ph */, X86::VCVTDQ2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9366 /* vcvtdq2phx */, X86::VCVTDQ2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9377 /* vcvtdq2phy */, X86::VCVTDQ2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9388 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrm, Convert__Reg1_2__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrmk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rmbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Zrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9398 /* vcvtne2ps2bf16 */, X86::VCVTNE2PS2BF16Z256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9413 /* vcvtneebf162ps */, X86::VCVTNEEBF162PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9413 /* vcvtneebf162ps */, X86::VCVTNEEBF162PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9428 /* vcvtneeph2ps */, X86::VCVTNEEPH2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9428 /* vcvtneeph2ps */, X86::VCVTNEEPH2PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9441 /* vcvtneobf162ps */, X86::VCVTNEOBF162PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9441 /* vcvtneobf162ps */, X86::VCVTNEOBF162PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9456 /* vcvtneoph2ps */, X86::VCVTNEOPH2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9456 /* vcvtneoph2ps */, X86::VCVTNEOPH2PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Yrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Zrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9469 /* vcvtneps2bf16 */, X86::VCVTNEPS2BF16Z256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16Z128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16Z128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16Z128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9483 /* vcvtneps2bf16x */, X86::VCVTNEPS2BF16Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Yrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Z256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Yrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16 }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Z256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Z256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9498 /* vcvtneps2bf16y */, X86::VCVTNEPS2BF16Z256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9513 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9523 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16 }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9534 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9545 /* vcvtpd2ph */, X86::VCVTPD2PHZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9555 /* vcvtpd2phx */, X86::VCVTPD2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9566 /* vcvtpd2phy */, X86::VCVTPD2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9577 /* vcvtpd2phz */, X86::VCVTPD2PHZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9588 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9598 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16 }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9609 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9641 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9653 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9665 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9676 /* vcvtph2dq */, X86::VCVTPH2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_VR512 }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9686 /* vcvtph2pd */, X86::VCVTPH2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR256 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSYrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9696 /* vcvtph2ps */, X86::VCVTPH2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9706 /* vcvtph2psx */, X86::VCVTPH2PSXZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512 }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9717 /* vcvtph2qq */, X86::VCVTPH2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9727 /* vcvtph2udq */, X86::VCVTPH2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512 }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512 }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512 }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9738 /* vcvtph2uqq */, X86::VCVTPH2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512 }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9749 /* vcvtph2uw */, X86::VCVTPH2UWZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512 }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZrmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to32_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9759 /* vcvtph2w */, X86::VCVTPH2WZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_VR256 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9768 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR256 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDYrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9778 /* vcvtps2pd */, X86::VCVTPS2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem64 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHYrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR16 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHYmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ128mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_Mem64 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ256rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR16X }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ256mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrrb, Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ128rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ128mrk, Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_Mem64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ256rrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ256mrk, Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrrk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZmrk, Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrrbk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9788 /* vcvtps2ph */, X86::VCVTPS2PHZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9798 /* vcvtps2phx */, X86::VCVTPS2PHXZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9809 /* vcvtps2phxx */, X86::VCVTPS2PHXZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9821 /* vcvtps2phxy */, X86::VCVTPS2PHXZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9833 /* vcvtps2qq */, X86::VCVTPS2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9843 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmb, Convert__Reg1_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9854 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, AMFBS_None, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9865 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9875 /* vcvtqq2ph */, X86::VCVTQQ2PHZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9885 /* vcvtqq2phx */, X86::VCVTQQ2PHZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9896 /* vcvtqq2phy */, X86::VCVTQQ2PHZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9907 /* vcvtqq2phz */, X86::VCVTQQ2PHZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9918 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9928 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9939 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9950 /* vcvtsd2sh */, X86::VCVTSD2SHZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SIZrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SI64Zrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 9960 /* vcvtsd2si */, X86::VCVTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 9970 /* vcvtsd2sil */, X86::VCVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 9970 /* vcvtsd2sil */, X86::VCVTSD2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 9970 /* vcvtsd2sil */, X86::VCVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 9970 /* vcvtsd2sil */, X86::VCVTSD2SIZrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 9970 /* vcvtsd2sil */, X86::VCVTSD2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 9981 /* vcvtsd2siq */, X86::VCVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 9981 /* vcvtsd2siq */, X86::VCVTSD2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 9981 /* vcvtsd2siq */, X86::VCVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 9981 /* vcvtsd2siq */, X86::VCVTSD2SI64Zrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 9981 /* vcvtsd2siq */, X86::VCVTSD2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16, MCK_FR16 }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9992 /* vcvtsd2ss */, X86::VCVTSD2SSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10002 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10013 /* vcvtsd2usil */, X86::VCVTSD2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10013 /* vcvtsd2usil */, X86::VCVTSD2USIZrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 10013 /* vcvtsd2usil */, X86::VCVTSD2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10025 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10025 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 10025 /* vcvtsd2usiq */, X86::VCVTSD2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10037 /* vcvtsh2sd */, X86::VCVTSH2SDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SIZrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SI64Zrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10047 /* vcvtsh2si */, X86::VCVTSH2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10057 /* vcvtsh2sil */, X86::VCVTSH2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10057 /* vcvtsh2sil */, X86::VCVTSH2SIZrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 10057 /* vcvtsh2sil */, X86::VCVTSH2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10068 /* vcvtsh2siq */, X86::VCVTSH2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10068 /* vcvtsh2siq */, X86::VCVTSH2SI64Zrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 10068 /* vcvtsh2siq */, X86::VCVTSH2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10079 /* vcvtsh2ss */, X86::VCVTSH2SSZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USIZrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USI64Zrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10089 /* vcvtsh2usi */, X86::VCVTSH2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10100 /* vcvtsh2usil */, X86::VCVTSH2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10100 /* vcvtsh2usil */, X86::VCVTSH2USIZrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 10100 /* vcvtsh2usil */, X86::VCVTSH2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10112 /* vcvtsh2usiq */, X86::VCVTSH2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10112 /* vcvtsh2usiq */, X86::VCVTSH2USI64Zrm_Int, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR64 }, },
  { 10112 /* vcvtsh2usiq */, X86::VCVTSH2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI2SDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16, MCK_FR16 }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI2SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI642SDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16, MCK_FR16 }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI642SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI2SDrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI2SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10124 /* vcvtsi2sd */, X86::VCVTSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10134 /* vcvtsi2sdl */, X86::VCVTSI2SDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16, MCK_FR16 }, },
  { 10134 /* vcvtsi2sdl */, X86::VCVTSI2SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10134 /* vcvtsi2sdl */, X86::VCVTSI2SDrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 10134 /* vcvtsi2sdl */, X86::VCVTSI2SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10145 /* vcvtsi2sdq */, X86::VCVTSI642SDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16, MCK_FR16 }, },
  { 10145 /* vcvtsi2sdq */, X86::VCVTSI642SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10145 /* vcvtsi2sdq */, X86::VCVTSI642SDrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16, MCK_FR16 }, },
  { 10145 /* vcvtsi2sdq */, X86::VCVTSI642SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 10145 /* vcvtsi2sdq */, X86::VCVTSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10156 /* vcvtsi2sh */, X86::VCVTSI2SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10156 /* vcvtsi2sh */, X86::VCVTSI642SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10156 /* vcvtsi2sh */, X86::VCVTSI2SHZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10156 /* vcvtsi2sh */, X86::VCVTSI2SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR32, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10156 /* vcvtsi2sh */, X86::VCVTSI642SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10166 /* vcvtsi2shl */, X86::VCVTSI2SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10166 /* vcvtsi2shl */, X86::VCVTSI2SHZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10166 /* vcvtsi2shl */, X86::VCVTSI2SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR32, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10177 /* vcvtsi2shq */, X86::VCVTSI642SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10177 /* vcvtsi2shq */, X86::VCVTSI642SHZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 10177 /* vcvtsi2shq */, X86::VCVTSI642SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI2SSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16, MCK_FR16 }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI2SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI642SSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16, MCK_FR16 }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI642SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI2SSrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI2SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR32, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10188 /* vcvtsi2ss */, X86::VCVTSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10198 /* vcvtsi2ssl */, X86::VCVTSI2SSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16, MCK_FR16 }, },
  { 10198 /* vcvtsi2ssl */, X86::VCVTSI2SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16X, MCK_FR16X }, },
  { 10198 /* vcvtsi2ssl */, X86::VCVTSI2SSrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 10198 /* vcvtsi2ssl */, X86::VCVTSI2SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10198 /* vcvtsi2ssl */, X86::VCVTSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR32, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10209 /* vcvtsi2ssq */, X86::VCVTSI642SSrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16, MCK_FR16 }, },
  { 10209 /* vcvtsi2ssq */, X86::VCVTSI642SSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16X, MCK_FR16X }, },
  { 10209 /* vcvtsi2ssq */, X86::VCVTSI642SSrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16, MCK_FR16 }, },
  { 10209 /* vcvtsi2ssq */, X86::VCVTSI642SSZrm_Int, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK_FR16X }, },
  { 10209 /* vcvtsi2ssq */, X86::VCVTSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, AMFBS_None, { MCK_GR64, MCK_AVX512RC, MCK_FR16X, MCK_FR16X }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16, MCK_FR16 }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16, MCK_FR16 }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10220 /* vcvtss2sd */, X86::VCVTSS2SDZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrm_Int, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrr_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrm_Intk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrrb_Intk, Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10230 /* vcvtss2sh */, X86::VCVTSS2SHZrrb_Intkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SIZrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SI64Zrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10240 /* vcvtss2si */, X86::VCVTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10250 /* vcvtss2sil */, X86::VCVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 10250 /* vcvtss2sil */, X86::VCVTSS2SIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10250 /* vcvtss2sil */, X86::VCVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10250 /* vcvtss2sil */, X86::VCVTSS2SIZrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10250 /* vcvtss2sil */, X86::VCVTSS2SIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10261 /* vcvtss2siq */, X86::VCVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 10261 /* vcvtss2siq */, X86::VCVTSS2SI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10261 /* vcvtss2siq */, X86::VCVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10261 /* vcvtss2siq */, X86::VCVTSS2SI64Zrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10261 /* vcvtss2siq */, X86::VCVTSS2SI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10272 /* vcvtss2usi */, X86::VCVTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10283 /* vcvtss2usil */, X86::VCVTSS2USIZrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR32 }, },
  { 10283 /* vcvtss2usil */, X86::VCVTSS2USIZrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 10283 /* vcvtss2usil */, X86::VCVTSS2USIZrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR32 }, },
  { 10295 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_GR64 }, },
  { 10295 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 10295 /* vcvtss2usiq */, X86::VCVTSS2USI64Zrrb_Int, Convert__Reg1_2__Reg1_1__AVX512RC1_0, AMFBS_None, { MCK_AVX512RC, MCK_FR16X, MCK_GR64 }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10307 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10318 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256, MCK_FR16 }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16 }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10330 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10342 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10353 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10365 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rrk, Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10378 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512 }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512 }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmb, Convert__Reg1_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, AMFBS_None, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10391 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, AMFBS_None, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512 }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrm, Convert__Reg1_1__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512 }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrrb, Convert__Reg1_2__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512 }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4_125_, MCK_FR16X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rmb, Convert__Reg1_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to8_125_, MCK_VR256X }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrrk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0, AMFBS_None, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rmk, Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrrbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1, AMFBS_None, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_FR16X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_FR16X, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, AMFBS_None, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZrmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10403 /* vcvttph2dq */, X86::VCVTTPH2DQZ128rmbk, Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0, AMFBS_None, { MCK_Mem16, MCK__123_1to4