/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  FeatureADX = 2,
  FeatureAES = 3,
  FeatureAMXBF16 = 4,
  FeatureAMXCOMPLEX = 5,
  FeatureAMXFP16 = 6,
  FeatureAMXINT8 = 7,
  FeatureAMXTILE = 8,
  FeatureAVX = 9,
  FeatureAVX2 = 10,
  FeatureAVX512 = 11,
  FeatureAVXIFMA = 12,
  FeatureAVXNECONVERT = 13,
  FeatureAVXVNNI = 14,
  FeatureAVXVNNIINT8 = 15,
  FeatureAVXVNNIINT16 = 16,
  FeatureBF16 = 17,
  FeatureBITALG = 18,
  FeatureBMI = 19,
  FeatureBMI2 = 20,
  FeatureBWI = 21,
  FeatureCDI = 22,
  FeatureCLDEMOTE = 23,
  FeatureCLFLUSHOPT = 24,
  FeatureCLWB = 25,
  FeatureCLZERO = 26,
  FeatureCMOV = 27,
  FeatureCMPCCXADD = 28,
  FeatureCRC32 = 29,
  FeatureCX8 = 30,
  FeatureCX16 = 31,
  FeatureDQI = 32,
  FeatureENQCMD = 33,
  FeatureERI = 34,
  FeatureERMSB = 35,
  FeatureF16C = 36,
  FeatureFMA = 37,
  FeatureFMA4 = 38,
  FeatureFP16 = 39,
  FeatureFSGSBase = 40,
  FeatureFSRM = 41,
  FeatureFXSR = 42,
  FeatureGFNI = 43,
  FeatureHRESET = 44,
  FeatureHardenSlsIJmp = 45,
  FeatureHardenSlsRet = 46,
  FeatureIFMA = 47,
  FeatureINVPCID = 48,
  FeatureKL = 49,
  FeatureLAHFSAHF64 = 50,
  FeatureLVIControlFlowIntegrity = 51,
  FeatureLVILoadHardening = 52,
  FeatureLWP = 53,
  FeatureLZCNT = 54,
  FeatureMMX = 55,
  FeatureMOVBE = 56,
  FeatureMOVDIR64B = 57,
  FeatureMOVDIRI = 58,
  FeatureMWAITX = 59,
  FeatureNOPL = 60,
  FeaturePCLMUL = 61,
  FeaturePCONFIG = 62,
  FeaturePFI = 63,
  FeaturePKU = 64,
  FeaturePOPCNT = 65,
  FeaturePREFETCHI = 66,
  FeaturePREFETCHWT1 = 67,
  FeaturePRFCHW = 68,
  FeaturePTWRITE = 69,
  FeatureRAOINT = 70,
  FeatureRDPID = 71,
  FeatureRDPRU = 72,
  FeatureRDRAND = 73,
  FeatureRDSEED = 74,
  FeatureRTM = 75,
  FeatureRetpoline = 76,
  FeatureRetpolineExternalThunk = 77,
  FeatureRetpolineIndirectBranches = 78,
  FeatureRetpolineIndirectCalls = 79,
  FeatureSERIALIZE = 80,
  FeatureSGX = 81,
  FeatureSHA = 82,
  FeatureSHA512 = 83,
  FeatureSHSTK = 84,
  FeatureSM3 = 85,
  FeatureSM4 = 86,
  FeatureSSE1 = 87,
  FeatureSSE2 = 88,
  FeatureSSE3 = 89,
  FeatureSSE4A = 90,
  FeatureSSE41 = 91,
  FeatureSSE42 = 92,
  FeatureSSEUnalignedMem = 93,
  FeatureSSSE3 = 94,
  FeatureSoftFloat = 95,
  FeatureSpeculativeExecutionSideEffectSuppression = 96,
  FeatureTBM = 97,
  FeatureTSXLDTRK = 98,
  FeatureTaggedGlobals = 99,
  FeatureUINTR = 100,
  FeatureVAES = 101,
  FeatureVBMI = 102,
  FeatureVBMI2 = 103,
  FeatureVLX = 104,
  FeatureVNNI = 105,
  FeatureVP2INTERSECT = 106,
  FeatureVPCLMULQDQ = 107,
  FeatureVPOPCNTDQ = 108,
  FeatureWAITPKG = 109,
  FeatureWBNOINVD = 110,
  FeatureWIDEKL = 111,
  FeatureX86_64 = 112,
  FeatureX87 = 113,
  FeatureXOP = 114,
  FeatureXSAVE = 115,
  FeatureXSAVEC = 116,
  FeatureXSAVEOPT = 117,
  FeatureXSAVES = 118,
  Is16Bit = 119,
  Is32Bit = 120,
  Is64Bit = 121,
  ProcIntelAtom = 122,
  TuningAllowLight256Bit = 123,
  TuningBranchFusion = 124,
  TuningFast7ByteNOP = 125,
  TuningFast11ByteNOP = 126,
  TuningFast15ByteNOP = 127,
  TuningFastBEXTR = 128,
  TuningFastGather = 129,
  TuningFastHorizontalOps = 130,
  TuningFastImmVectorShift = 131,
  TuningFastLZCNT = 132,
  TuningFastMOVBE = 133,
  TuningFastSHLDRotate = 134,
  TuningFastScalarFSQRT = 135,
  TuningFastScalarShiftMasks = 136,
  TuningFastVariableCrossLaneShuffle = 137,
  TuningFastVariablePerLaneShuffle = 138,
  TuningFastVectorFSQRT = 139,
  TuningFastVectorShiftMasks = 140,
  TuningGETMANTFalseDeps = 141,
  TuningInsertVZEROUPPER = 142,
  TuningLEAForSP = 143,
  TuningLEAUsesAG = 144,
  TuningLZCNTFalseDeps = 145,
  TuningMULCFalseDeps = 146,
  TuningMULLQFalseDeps = 147,
  TuningMacroFusion = 148,
  TuningNoDomainDelay = 149,
  TuningNoDomainDelayBlend = 150,
  TuningNoDomainDelayMov = 151,
  TuningNoDomainDelayShuffle = 152,
  TuningPERMFalseDeps = 153,
  TuningPOPCNTFalseDeps = 154,
  TuningPadShortFunctions = 155,
  TuningPrefer128Bit = 156,
  TuningPrefer256Bit = 157,
  TuningPreferMaskRegisters = 158,
  TuningPreferMovmskOverVTest = 159,
  TuningPreferNoGather = 160,
  TuningPreferNoScatter = 161,
  TuningPreferShiftShuffle = 162,
  TuningRANGEFalseDeps = 163,
  TuningSBBDepBreaking = 164,
  TuningSlow3OpsLEA = 165,
  TuningSlowDivide32 = 166,
  TuningSlowDivide64 = 167,
  TuningSlowIncDec = 168,
  TuningSlowLEA = 169,
  TuningSlowPMADDWD = 170,
  TuningSlowPMULLD = 171,
  TuningSlowSHLD = 172,
  TuningSlowTwoMemOps = 173,
  TuningSlowUAMem16 = 174,
  TuningSlowUAMem32 = 175,
  TuningUseGLMDivSqrtCosts = 176,
  TuningUseSLMArithCosts = 177,
  NumSubtargetFeatures = 178
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(FastImmVectorShift, false, fastImmVectorShift)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXCOMPLEX, false, hasAMXCOMPLEX)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT16, false, hasAVXVNNIINT16)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERI, false, hasERI)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPFI, false, hasPFI)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPREFETCHWT1, false, hasPREFETCHWT1)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHA512, false, hasSHA512)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(HasSM3, false, hasSM3)
GET_SUBTARGETINFO_MACRO(HasSM4, false, hasSM4)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(NoDomainDelay, false, noDomainDelay)
GET_SUBTARGETINFO_MACRO(NoDomainDelayBlend, false, noDomainDelayBlend)
GET_SUBTARGETINFO_MACRO(NoDomainDelayMov, false, noDomainDelayMov)
GET_SUBTARGETINFO_MACRO(NoDomainDelayShuffle, false, noDomainDelayShuffle)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferGather, true, preferGather)
GET_SUBTARGETINFO_MACRO(PreferLowerShuffleAsShift, false, preferLowerShuffleAsShift)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(PreferMovmskOverVTest, false, preferMovmskOverVTest)
GET_SUBTARGETINFO_MACRO(PreferScatter, true, preferScatter)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-complex", "Support AMX-COMPLEX instructions", X86::FeatureAMXCOMPLEX, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x10000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0x3000000400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x100200000ULL, 0x10000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint16", "Enable AVX-VNNI-INT16", X86::FeatureAVXVNNIINT16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x40000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "faster-shift-than-shuffle", "Shifts are faster (or as fast) as shuffle", X86::TuningPreferShiftShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x200ULL, 0x4000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay", "Has no bypass delay when using the 'wrong' domain", X86::TuningNoDomainDelay, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-blend", "Has no bypass delay when using the 'wrong' blend type", X86::TuningNoDomainDelayBlend, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-mov", "Has no bypass delay when using the 'wrong' mov type", X86::TuningNoDomainDelayMov, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-shuffle", "Has no bypass delay when using the 'wrong' shuffle type", X86::TuningNoDomainDelayShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-movmsk-over-vtest", "Prefer movmsk over vtest instruction", X86::TuningPreferMovmskOverVTest, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-gather", "Prefer no gather instructions", X86::TuningPreferNoGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-scatter", "Prefer no scatter instructions", X86::TuningPreferNoScatter, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0xc000ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x8000ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x8000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha512", "Support SHA512 instructions", X86::FeatureSHA512, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm3", "Support SM3 instructions", X86::FeatureSM3, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm4", "Support SM4 instructions", X86::FeatureSM4, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x800000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x40000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x8000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x2000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x2000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tuning-fast-imm-vector-shift", "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)", X86::TuningFastImmVectorShift, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x208ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x2000000000000200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x2000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x4000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x8000000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x8000000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x8000000000000ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles, StartAtCycle}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0,  0 }, // Invalid
  { 5,  1,   0}, // #1
  { 1,  1,   0}, // #2
  { 2,  1,   0}, // #3
  { 3,  1,   0}, // #4
  { 4,  1,   0}, // #5
  { 5,  1,   0}, // #6
  { 6,  1,   0}, // #7
  { 7,  1,   0}, // #8
  { 8,  1,   0}, // #9
  { 4,  1,   0}, // #10
  { 5,  1,   0}, // #11
  { 7,  1,   0}, // #12
  { 8,  1,   0}, // #13
  { 4,  2,   0}, // #14
  { 5,  3,   0}, // #15
  { 7,  2,   0}, // #16
  { 8,  2,   0}, // #17
  {15,  2,   0}, // #18
  {16,  1,   0}, // #19
  {19,  1,   0}, // #20
  {23,  1,   0}, // #21
  { 4,  1,   0}, // #22
  { 5,  1,   0}, // #23
  { 7,  1,   0}, // #24
  { 8,  1,   0}, // #25
  {13,  1,   0}, // #26
  {14,  1,   0}, // #27
  {15,  1,   0}, // #28
  {16,  1,   0}, // #29
  { 2,  1,   0}, // #30
  { 3,  1,   0}, // #31
  { 4,  1,   0}, // #32
  { 5,  1,   0}, // #33
  { 9,  1,   0}, // #34
  {10,  1,   0}, // #35
  {11,  1,   0}, // #36
  {15,  1,   0}, // #37
  {19,  1,   0}, // #38
  {23,  1,   0}, // #39
  { 5,  1,   0}, // #40
  {15,  2,   0}, // #41
  {16,  1,   0}, // #42
  {19,  1,   0}, // #43
  {23,  1,   0}, // #44
  { 4,  1,   0}, // #45
  { 5,  2,   0}, // #46
  { 7,  1,   0}, // #47
  { 8,  1,   0}, // #48
  {15,  2,   0}, // #49
  {16,  1,   0}, // #50
  {19,  1,   0}, // #51
  {23,  1,   0}, // #52
  { 3,  1,   0}, // #53
  { 4,  1,   0}, // #54
  { 5,  1,   0}, // #55
  {10,  1,   0}, // #56
  {11,  1,   0}, // #57
  {15,  1,   0}, // #58
  {16,  1,   0}, // #59
  { 3,  1,   0}, // #60
  { 4,  1,   0}, // #61
  { 5,  1,   0}, // #62
  { 6,  1,   0}, // #63
  { 7,  1,   0}, // #64
  {10,  1,   0}, // #65
  {11,  1,   0}, // #66
  {20,  1,   0}, // #67
  { 2,  1,   0}, // #68
  { 3,  1,   0}, // #69
  { 4,  1,   0}, // #70
  { 5,  1,   0}, // #71
  {15,  1,   0}, // #72
  {16,  1,   0}, // #73
  { 2,  2,   0}, // #74
  { 3,  2,   0}, // #75
  { 4,  2,   0}, // #76
  { 5,  2,   0}, // #77
  {15,  1,   0}, // #78
  {16,  1,   0}, // #79
  { 1,  4,   0}, // #80
  { 2,  5,   0}, // #81
  { 3, 11,   0}, // #82
  { 4, 13,   0}, // #83
  { 5, 13,   0}, // #84
  { 6,  7,   0}, // #85
  { 7,  9,   0}, // #86
  { 8,  6,   0}, // #87
  {10,  6,   0}, // #88
  {11,  6,   0}, // #89
  {15,  1,   0}, // #90
  {16,  1,   0}, // #91
  {20,  3,   0}, // #92
  { 1,  4,   0}, // #93
  { 2,  5,   0}, // #94
  { 3, 12,   0}, // #95
  { 4, 14,   0}, // #96
  { 5, 14,   0}, // #97
  { 6,  7,   0}, // #98
  { 7,  9,   0}, // #99
  { 8,  6,   0}, // #100
  {10,  6,   0}, // #101
  {11,  6,   0}, // #102
  {20,  3,   0}, // #103
  { 2,  1,   0}, // #104
  { 3,  1,   0}, // #105
  { 4,  2,   0}, // #106
  { 5,  2,   0}, // #107
  { 7,  1,   0}, // #108
  { 8,  1,   0}, // #109
  { 9,  1,   0}, // #110
  {10,  1,   0}, // #111
  {11,  1,   0}, // #112
  {15,  1,   0}, // #113
  {16,  1,   0}, // #114
  { 5,  1,   0}, // #115
  {11,  1,   0}, // #116
  {15,  1,   0}, // #117
  {16,  1,   0}, // #118
  { 2,  1,   0}, // #119
  { 3,  1,   0}, // #120
  { 4,  1,   0}, // #121
  { 5,  1,   0}, // #122
  { 9,  1,   0}, // #123
  {10,  1,   0}, // #124
  {11,  1,   0}, // #125
  {15,  1,   0}, // #126
  {16,  1,   0}, // #127
  { 2,  1,   0}, // #128
  { 3,  1,   0}, // #129
  { 4,  3,   0}, // #130
  { 5,  9,   0}, // #131
  { 7,  2,   0}, // #132
  { 8,  2,   0}, // #133
  { 9,  1,   0}, // #134
  {10,  1,   0}, // #135
  {11,  3,   0}, // #136
  {15,  1,   0}, // #137
  {16,  1,   0}, // #138
  { 2,  1,   0}, // #139
  { 3,  1,   0}, // #140
  { 4,  1,   0}, // #141
  { 5,  1,   0}, // #142
  { 9,  1,   0}, // #143
  {10,  1,   0}, // #144
  {11,  1,   0}, // #145
  {15,  2,   0}, // #146
  {16,  1,   0}, // #147
  {19,  1,   0}, // #148
  {23,  1,   0}, // #149
  { 2,  1,   0}, // #150
  { 3,  1,   0}, // #151
  { 4,  3,   0}, // #152
  { 5,  8,   0}, // #153
  { 7,  2,   0}, // #154
  { 8,  2,   0}, // #155
  { 9,  1,   0}, // #156
  {10,  1,   0}, // #157
  {11,  3,   0}, // #158
  {15,  2,   0}, // #159
  {16,  1,   0}, // #160
  {19,  1,   0}, // #161
  {23,  1,   0}, // #162
  { 4,  1,   0}, // #163
  { 5,  1,   0}, // #164
  { 7,  1,   0}, // #165
  { 8,  1,   0}, // #166
  {15,  1,   0}, // #167
  {16,  1,   0}, // #168
  { 4,  2,   0}, // #169
  { 5,  5,   0}, // #170
  { 7,  2,   0}, // #171
  { 8,  2,   0}, // #172
  { 1,  1,   0}, // #173
  { 2,  1,   0}, // #174
  { 3,  1,   0}, // #175
  { 4,  1,   0}, // #176
  { 5,  1,   0}, // #177
  { 6,  1,   0}, // #178
  { 7,  1,   0}, // #179
  { 8,  1,   0}, // #180
  {15,  1,   0}, // #181
  {16,  1,   0}, // #182
  { 2,  1,   0}, // #183
  { 3,  2,   0}, // #184
  { 4,  2,   0}, // #185
  { 5,  2,   0}, // #186
  { 6,  1,   0}, // #187
  { 7,  1,   0}, // #188
  {10,  1,   0}, // #189
  {11,  1,   0}, // #190
  {20,  1,   0}, // #191
  { 2,  1,   0}, // #192
  { 3,  2,   0}, // #193
  { 4,  2,   0}, // #194
  { 5,  2,   0}, // #195
  { 6,  1,   0}, // #196
  { 7,  1,   0}, // #197
  {10,  1,   0}, // #198
  {11,  1,   0}, // #199
  {15,  1,   0}, // #200
  {16,  1,   0}, // #201
  {20,  1,   0}, // #202
  { 1,  1,   0}, // #203
  { 2,  2,   0}, // #204
  { 3,  2,   0}, // #205
  { 4,  2,   0}, // #206
  { 5,  2,   0}, // #207
  { 6,  1,   0}, // #208
  { 7,  1,   0}, // #209
  { 8,  1,   0}, // #210
  {15,  1,   0}, // #211
  {16,  1,   0}, // #212
  { 2,  3,   0}, // #213
  { 3,  3,   0}, // #214
  { 4,  3,   0}, // #215
  { 5,  4,   0}, // #216
  { 9,  3,   0}, // #217
  {10,  3,   0}, // #218
  {11,  3,   0}, // #219
  {15,  1,   0}, // #220
  {16,  1,   0}, // #221
  { 2,  3,   0}, // #222
  { 3,  3,   0}, // #223
  { 4,  3,   0}, // #224
  { 5,  3,   0}, // #225
  { 9,  3,   0}, // #226
  {10,  3,   0}, // #227
  {11,  3,   0}, // #228
  {15,  1,   0}, // #229
  {16,  1,   0}, // #230
  { 2,  2,   0}, // #231
  { 3,  3,   0}, // #232
  { 4,  3,   0}, // #233
  { 5,  3,   0}, // #234
  {10,  1,   0}, // #235
  {11,  1,   0}, // #236
  {15,  1,   0}, // #237
  {16,  1,   0}, // #238
  { 2,  2,   0}, // #239
  { 3,  5,   0}, // #240
  { 4,  6,   0}, // #241
  { 5,  6,   0}, // #242
  { 6,  1,   0}, // #243
  { 7,  2,   0}, // #244
  { 8,  1,   0}, // #245
  {10,  3,   0}, // #246
  {11,  3,   0}, // #247
  {15,  1,   0}, // #248
  {16,  1,   0}, // #249
  {20,  1,   0}, // #250
  { 2,  2,   0}, // #251
  { 3,  5,   0}, // #252
  { 4,  6,   0}, // #253
  { 5,  6,   0}, // #254
  { 6,  1,   0}, // #255
  { 7,  2,   0}, // #256
  { 8,  1,   0}, // #257
  {10,  3,   0}, // #258
  {11,  3,   0}, // #259
  {20,  1,   0}, // #260
  { 3,  1,   0}, // #261
  { 4,  1,   0}, // #262
  { 5,  1,   0}, // #263
  {10,  1,   0}, // #264
  {11,  1,   0}, // #265
  {15,  1,   0}, // #266
  {19,  1,   0}, // #267
  {23,  1,   0}, // #268
  { 1,  1,   0}, // #269
  { 2,  1,   0}, // #270
  { 3,  2,   0}, // #271
  { 4,  2,   0}, // #272
  { 5,  2,   0}, // #273
  { 6,  1,   0}, // #274
  { 7,  1,   0}, // #275
  { 8,  1,   0}, // #276
  {10,  1,   0}, // #277
  {11,  1,   0}, // #278
  { 3,  1,   0}, // #279
  { 4,  1,   0}, // #280
  { 5,  1,   0}, // #281
  { 6,  1,   0}, // #282
  { 7,  1,   0}, // #283
  {10,  1,   0}, // #284
  {11,  1,   0}, // #285
  {13,  1,   0}, // #286
  {14,  1,   0}, // #287
  {15,  1,   0}, // #288
  {16,  1,   0}, // #289
  {20,  1,   0}, // #290
  { 1,  1,   0}, // #291
  { 2,  1,   0}, // #292
  { 3,  9,   0}, // #293
  { 4, 10,   0}, // #294
  { 5, 10,   0}, // #295
  { 6,  9,   0}, // #296
  { 7, 10,   0}, // #297
  { 8,  2,   0}, // #298
  { 3,  2,   0}, // #299
  { 4,  2,   0}, // #300
  { 5,  2,   0}, // #301
  { 6,  2,   0}, // #302
  { 7,  2,   0}, // #303
  { 3,  3,   0}, // #304
  { 4,  3,   0}, // #305
  { 5,  3,   0}, // #306
  { 6,  2,   0}, // #307
  { 7,  2,   0}, // #308
  {10,  3,   0}, // #309
  {11,  3,   0}, // #310
  {15,  1,   0}, // #311
  {16,  1,   0}, // #312
  {20,  2,   0}, // #313
  { 3,  3,   0}, // #314
  { 4,  3,   0}, // #315
  { 5,  3,   0}, // #316
  { 6,  2,   0}, // #317
  { 7,  2,   0}, // #318
  {10,  3,   0}, // #319
  {11,  3,   0}, // #320
  {20,  2,   0}, // #321
  { 2,  1,   0}, // #322
  { 3,  1,   0}, // #323
  { 4,  2,   0}, // #324
  { 5,  4,   0}, // #325
  { 7,  1,   0}, // #326
  { 8,  1,   0}, // #327
  { 9,  1,   0}, // #328
  {10,  1,   0}, // #329
  {11,  1,   0}, // #330
  {15,  1,   0}, // #331
  {16,  1,   0}, // #332
  { 2,  1,   0}, // #333
  { 3,  1,   0}, // #334
  { 4,  1,   0}, // #335
  { 5,  2,   0}, // #336
  { 9,  1,   0}, // #337
  {10,  1,   0}, // #338
  {11,  1,   0}, // #339
  {15,  1,   0}, // #340
  {16,  1,   0}, // #341
  { 2,  1,   0}, // #342
  { 3,  1,   0}, // #343
  { 4,  2,   0}, // #344
  { 5,  3,   0}, // #345
  { 7,  1,   0}, // #346
  { 8,  1,   0}, // #347
  { 9,  1,   0}, // #348
  {10,  1,   0}, // #349
  {11,  1,   0}, // #350
  {15,  1,   0}, // #351
  {16,  1,   0}, // #352
  { 2,  1,   0}, // #353
  { 3,  2,   0}, // #354
  { 4,  2,   0}, // #355
  { 5,  2,   0}, // #356
  { 6,  1,   0}, // #357
  { 7,  1,   0}, // #358
  { 9,  1,   0}, // #359
  {10,  2,   0}, // #360
  {11,  2,   0}, // #361
  {15,  1,   0}, // #362
  {16,  1,   0}, // #363
  {20,  1,   0}, // #364
  { 2,  1,   0}, // #365
  { 3,  2,   0}, // #366
  { 4,  2,   0}, // #367
  { 5,  2,   0}, // #368
  { 6,  1,   0}, // #369
  { 7,  1,   0}, // #370
  { 9,  1,   0}, // #371
  {10,  2,   0}, // #372
  {11,  2,   0}, // #373
  {20,  1,   0}, // #374
  { 3,  1,   0}, // #375
  { 4,  1,   0}, // #376
  { 5,  1,   0}, // #377
  { 6,  1,   0}, // #378
  { 7,  1,   0}, // #379
  {10,  1,   0}, // #380
  {11,  1,   0}, // #381
  {15,  1,   0}, // #382
  {16,  1,   0}, // #383
  {20,  1,   0}, // #384
  { 1,  1,   0}, // #385
  { 2,  1,   0}, // #386
  { 3,  2,   0}, // #387
  { 4,  3,   0}, // #388
  { 5,  3,   0}, // #389
  { 6,  1,   0}, // #390
  { 7,  2,   0}, // #391
  { 8,  2,   0}, // #392
  {15,  1,   0}, // #393
  {16,  1,   0}, // #394
  { 3,  1,   0}, // #395
  { 4,  1,   0}, // #396
  { 5,  1,   0}, // #397
  { 6,  1,   0}, // #398
  { 7,  1,   0}, // #399
  {15,  1,   0}, // #400
  {16,  1,   0}, // #401
  { 3,  3,   0}, // #402
  { 4,  3,   0}, // #403
  { 5,  3,   0}, // #404
  { 6,  3,   0}, // #405
  { 7,  3,   0}, // #406
  {10,  2,   0}, // #407
  {11,  2,   0}, // #408
  {15,  1,   0}, // #409
  {16,  1,   0}, // #410
  {20,  2,   0}, // #411
  { 3,  3,   0}, // #412
  { 4,  3,   0}, // #413
  { 5,  3,   0}, // #414
  { 6,  3,   0}, // #415
  { 7,  3,   0}, // #416
  {10,  2,   0}, // #417
  {11,  2,   0}, // #418
  {20,  2,   0}, // #419
  { 3,  2,   0}, // #420
  { 4,  2,   0}, // #421
  { 5,  2,   0}, // #422
  { 6,  1,   0}, // #423
  { 7,  1,   0}, // #424
  {10,  2,   0}, // #425
  {11,  2,   0}, // #426
  {20,  1,   0}, // #427
  { 1,  1,   0}, // #428
  { 2,  1,   0}, // #429
  { 3,  2,   0}, // #430
  { 4,  2,   0}, // #431
  { 5,  2,   0}, // #432
  { 6,  2,   0}, // #433
  { 7,  2,   0}, // #434
  { 8,  1,   0}, // #435
  {10,  1,   0}, // #436
  {11,  1,   0}, // #437
  {15,  1,   0}, // #438
  {16,  1,   0}, // #439
  {20,  1,   0}, // #440
  { 1,  1,   0}, // #441
  { 2,  1,   0}, // #442
  { 3,  2,   0}, // #443
  { 4,  2,   0}, // #444
  { 5,  2,   0}, // #445
  { 6,  2,   0}, // #446
  { 7,  2,   0}, // #447
  { 8,  1,   0}, // #448
  {10,  1,   0}, // #449
  {11,  1,   0}, // #450
  {20,  1,   0}, // #451
  { 3,  2,   0}, // #452
  { 4,  2,   0}, // #453
  { 5,  2,   0}, // #454
  { 6,  1,   0}, // #455
  { 7,  1,   0}, // #456
  {10,  2,   0}, // #457
  {11,  2,   0}, // #458
  {15,  1,   0}, // #459
  {16,  1,   0}, // #460
  {20,  1,   0}, // #461
  { 1,  3,   0}, // #462
  { 2,  4,   0}, // #463
  { 3,  6,   0}, // #464
  { 4,  7,   0}, // #465
  { 5,  7,   0}, // #466
  { 6,  4,   0}, // #467
  { 7,  5,   0}, // #468
  { 8,  4,   0}, // #469
  { 9,  1,   0}, // #470
  {10,  2,   0}, // #471
  {11,  2,   0}, // #472
  {15,  1,   0}, // #473
  {16,  1,   0}, // #474
  {20,  1,   0}, // #475
  { 1,  3,   0}, // #476
  { 2,  4,   0}, // #477
  { 3,  7,   0}, // #478
  { 4,  8,   0}, // #479
  { 5,  8,   0}, // #480
  { 6,  4,   0}, // #481
  { 7,  5,   0}, // #482
  { 8,  4,   0}, // #483
  { 9,  1,   0}, // #484
  {10,  2,   0}, // #485
  {11,  2,   0}, // #486
  {20,  1,   0}, // #487
  { 1,  3,   0}, // #488
  { 2,  4,   0}, // #489
  { 3,  7,   0}, // #490
  { 4,  8,   0}, // #491
  { 5,  8,   0}, // #492
  { 6,  4,   0}, // #493
  { 7,  5,   0}, // #494
  { 8,  4,   0}, // #495
  { 9,  1,   0}, // #496
  {10,  2,   0}, // #497
  {11,  2,   0}, // #498
  {15,  1,   0}, // #499
  {16,  1,   0}, // #500
  {20,  1,   0}, // #501
  { 1,  3,   0}, // #502
  { 2,  4,   0}, // #503
  { 3,  8,   0}, // #504
  { 4,  9,   0}, // #505
  { 5,  9,   0}, // #506
  { 6,  4,   0}, // #507
  { 7,  5,   0}, // #508
  { 8,  4,   0}, // #509
  { 9,  1,   0}, // #510
  {10,  2,   0}, // #511
  {11,  2,   0}, // #512
  {20,  1,   0}, // #513
  { 1,  3,   0}, // #514
  { 2,  3,   0}, // #515
  { 3,  3,   0}, // #516
  { 4,  3,   0}, // #517
  { 5,  3,   0}, // #518
  { 6,  3,   0}, // #519
  { 7,  3,   0}, // #520
  { 8,  3,   0}, // #521
  {15,  1,   0}, // #522
  {16,  1,   0}, // #523
  { 3,  3,   0}, // #524
  { 4,  3,   0}, // #525
  { 5,  3,   0}, // #526
  {10,  2,   0}, // #527
  {11,  2,   0}, // #528
  {15,  1,   0}, // #529
  {16,  1,   0}, // #530
  { 2,  1,   0}, // #531
  { 3,  2,   0}, // #532
  { 4,  2,   0}, // #533
  { 5,  2,   0}, // #534
  {10,  1,   0}, // #535
  {11,  1,   0}, // #536
  { 2,  2,   0}, // #537
  { 3,  2,   0}, // #538
  { 4,  5,   0}, // #539
  { 5,  7,   0}, // #540
  { 7,  3,   0}, // #541
  { 8,  3,   0}, // #542
  { 9,  2,   0}, // #543
  {10,  2,   0}, // #544
  {11,  2,   0}, // #545
  {15,  2,   0}, // #546
  {16,  1,   0}, // #547
  {19,  1,   0}, // #548
  {23,  1,   0}, // #549
  { 4,  2,   0}, // #550
  { 5,  2,   0}, // #551
  { 7,  2,   0}, // #552
  { 8,  2,   0}, // #553
  { 4,  1,   0}, // #554
  { 5,  1,   0}, // #555
  { 7,  1,   0}, // #556
  { 8,  1,   0}, // #557
  {15,  2,   0}, // #558
  {16,  1,   0}, // #559
  {19,  1,   0}, // #560
  {23,  1,   0}, // #561
  { 4,  2,   0}, // #562
  { 5,  2,   0}, // #563
  { 7,  2,   0}, // #564
  { 8,  2,   0}, // #565
  {15,  2,   0}, // #566
  {16,  1,   0}, // #567
  {19,  1,   0}, // #568
  {23,  1,   0}, // #569
  { 4,  2,   0}, // #570
  { 5,  2,   0}, // #571
  { 7,  2,   0}, // #572
  { 8,  2,   0}, // #573
  {15,  1,   0}, // #574
  {19,  1,   0}, // #575
  {23,  1,   0}, // #576
  { 2,  1,   0}, // #577
  { 3,  1,   0}, // #578
  { 4,  2,   0}, // #579
  { 5,  3,   0}, // #580
  { 7,  1,   0}, // #581
  { 8,  1,   0}, // #582
  { 9,  1,   0}, // #583
  {10,  1,   0}, // #584
  {11,  1,   0}, // #585
  {15,  2,   0}, // #586
  {16,  1,   0}, // #587
  {19,  1,   0}, // #588
  {23,  1,   0}, // #589
  { 2,  1,   0}, // #590
  { 3,  1,   0}, // #591
  { 4,  1,   0}, // #592
  { 5,  2,   0}, // #593
  { 9,  1,   0}, // #594
  {10,  1,   0}, // #595
  {11,  1,   0}, // #596
  {15,  2,   0}, // #597
  {16,  1,   0}, // #598
  {19,  1,   0}, // #599
  {23,  1,   0}, // #600
  { 1,  1,   0}, // #601
  { 2,  1,   0}, // #602
  { 3,  1,   0}, // #603
  { 4,  1,   0}, // #604
  { 5,  1,   0}, // #605
  { 6,  1,   0}, // #606
  { 7,  1,   0}, // #607
  { 8,  1,   0}, // #608
  {28,  7,   0}, // #609
  { 1,  1,   0}, // #610
  { 2,  1,   0}, // #611
  { 3,  1,   0}, // #612
  { 4,  2,   0}, // #613
  { 5,  2,   0}, // #614
  { 6,  1,   0}, // #615
  { 7,  2,   0}, // #616
  { 8,  2,   0}, // #617
  {15,  1,   0}, // #618
  {19,  1,   0}, // #619
  {23,  1,   0}, // #620
  { 3,  3,   0}, // #621
  { 4,  3,   0}, // #622
  { 5,  3,   0}, // #623
  {15,  1,   0}, // #624
  {16,  1,   0}, // #625
  { 2,  1,   0}, // #626
  { 3,  1,   0}, // #627
  { 4,  1,   0}, // #628
  { 5,  1,   0}, // #629
  {15,  1,   0}, // #630
  {19,  1,   0}, // #631
  {23,  1,   0}, // #632
  { 1,  1,   0}, // #633
  { 2,  1,   0}, // #634
  { 3,  1,   0}, // #635
  { 4,  1,   0}, // #636
  { 5,  1,   0}, // #637
  { 6,  1,   0}, // #638
  { 7,  1,   0}, // #639
  { 8,  1,   0}, // #640
  {15,  1,   0}, // #641
  {19,  1,   0}, // #642
  {23,  1,   0}, // #643
  { 1,  2,   0}, // #644
  { 2,  3,   0}, // #645
  { 3,  7,   0}, // #646
  { 4, 15,   0}, // #647
  { 5, 15,   0}, // #648
  { 6,  6,   0}, // #649
  { 7, 10,   0}, // #650
  { 8,  6,   0}, // #651
  { 9,  1,   0}, // #652
  {10,  3,   0}, // #653
  {11,  3,   0}, // #654
  {20,  2,   0}, // #655
  {21,  4,   0}, // #656
  { 2,  1,   0}, // #657
  { 3,  3,   0}, // #658
  { 4,  3,   0}, // #659
  { 5,  3,   0}, // #660
  { 6,  2,   0}, // #661
  { 7,  2,   0}, // #662
  {10,  2,   0}, // #663
  {11,  2,   0}, // #664
  {20,  2,   0}, // #665
  { 1,  1,   0}, // #666
  { 2,  2,   0}, // #667
  { 3,  3,   0}, // #668
  { 4,  3,   0}, // #669
  { 5,  3,   0}, // #670
  { 6,  2,   0}, // #671
  { 7,  2,   0}, // #672
  { 8,  1,   0}, // #673
  {10,  1,   0}, // #674
  {11,  1,   0}, // #675
  {20,  1,   0}, // #676
  {14,  1,   0}, // #677
  {15,  1,   0}, // #678
  {18,  1,   0}, // #679
  {19,  1,   0}, // #680
  { 5,  4,   0}, // #681
  {15,  2,   0}, // #682
  {16,  1,   0}, // #683
  {19,  1,   0}, // #684
  {23,  1,   0}, // #685
  { 4,  1,   0}, // #686
  { 5,  6,   0}, // #687
  { 7,  1,   0}, // #688
  { 8,  1,   0}, // #689
  {15,  2,   0}, // #690
  {16,  1,   0}, // #691
  {19,  1,   0}, // #692
  {23,  1,   0}, // #693
  { 1,  1,   0}, // #694
  { 2,  1,   0}, // #695
  { 3,  2,   0}, // #696
  { 4,  2,   0}, // #697
  { 5,  2,   0}, // #698
  { 6,  2,   0}, // #699
  { 7,  2,   0}, // #700
  { 8,  1,   0}, // #701
  {13,  1,   0}, // #702
  {14,  1,   0}, // #703
  {15,  1,   0}, // #704
  {16,  1,   0}, // #705
  { 3,  1,   0}, // #706
  { 4,  1,   0}, // #707
  { 5,  1,   0}, // #708
  { 6,  1,   0}, // #709
  { 7,  1,   0}, // #710
  {10,  1,   0}, // #711
  {11,  1,   0}, // #712
  {14,  1,   0}, // #713
  {15,  1,   0}, // #714
  {18,  1,   0}, // #715
  {19,  1,   0}, // #716
  {20,  1,   0}, // #717
  { 2,  1,   0}, // #718
  { 3,  1,   0}, // #719
  { 4,  7,   0}, // #720
  { 5, 11,   0}, // #721
  { 7,  6,   0}, // #722
  { 8,  6,   0}, // #723
  { 9,  1,   0}, // #724
  {10,  1,   0}, // #725
  {11,  1,   0}, // #726
  { 4,  1,   0}, // #727
  { 5,  1,   0}, // #728
  { 7,  1,   0}, // #729
  { 8,  1,   0}, // #730
  {14,  1,   0}, // #731
  {15,  1,   0}, // #732
  {18,  1,   0}, // #733
  {19,  1,   0}, // #734
  {21,  1,   0}, // #735
  { 3,  1,   0}, // #736
  { 4,  2,   0}, // #737
  { 5,  2,   0}, // #738
  { 6,  1,   0}, // #739
  { 7,  2,   0}, // #740
  { 8,  1,   0}, // #741
  {10,  1,   0}, // #742
  {11,  1,   0}, // #743
  {20,  1,   0}, // #744
  { 2,  2,   0}, // #745
  { 3,  2,   0}, // #746
  { 4,  9,   0}, // #747
  { 5, 13,   0}, // #748
  { 7,  7,   0}, // #749
  { 8,  7,   0}, // #750
  { 9,  2,   0}, // #751
  {10,  2,   0}, // #752
  {11,  2,   0}, // #753
  {15,  2,   0}, // #754
  {16,  1,   0}, // #755
  {19,  1,   0}, // #756
  {23,  1,   0}, // #757
  { 2,  1,   0}, // #758
  { 3,  1,   0}, // #759
  { 4,  5,   0}, // #760
  { 5,  7,   0}, // #761
  { 7,  4,   0}, // #762
  { 8,  4,   0}, // #763
  { 9,  1,   0}, // #764
  {10,  1,   0}, // #765
  {11,  1,   0}, // #766
  { 1,  2,   0}, // #767
  { 2,  2,   0}, // #768
  { 3,  6,   0}, // #769
  { 4, 12,   0}, // #770
  { 5, 19,   0}, // #771
  { 6,  4,   0}, // #772
  { 7, 10,   0}, // #773
  { 8,  8,   0}, // #774
  {10,  4,   0}, // #775
  {11,  4,   0}, // #776
  {15,  2,   0}, // #777
  {16,  1,   0}, // #778
  {19,  1,   0}, // #779
  {20,  2,   0}, // #780
  {23,  1,   0}, // #781
  { 4,  4,   0}, // #782
  { 5,  4,   0}, // #783
  { 1,  2,   0}, // #784
  { 2,  8,   0}, // #785
  { 3, 12,   0}, // #786
  { 4, 21,   0}, // #787
  { 5, 21,   0}, // #788
  { 6,  5,   0}, // #789
  { 7, 14,   0}, // #790
  { 8,  9,   0}, // #791
  { 9,  4,   0}, // #792
  {10,  7,   0}, // #793
  {11,  7,   0}, // #794
  {20,  3,   0}, // #795
  { 1,  2,   0}, // #796
  { 2,  4,   0}, // #797
  { 3, 13,   0}, // #798
  { 4, 34,   0}, // #799
  { 5, 34,   0}, // #800
  { 6, 11,   0}, // #801
  { 7, 32,   0}, // #802
  { 8, 23,   0}, // #803
  { 9,  2,   0}, // #804
  {10, 11,   0}, // #805
  {11, 11,   0}, // #806
  {15, 19,   0}, // #807
  {16, 14,   0}, // #808
  {19,  4,   0}, // #809
  {20,  9,   0}, // #810
  {23,  5,   0}, // #811
  { 2,  1,   0}, // #812
  { 3,  1,   0}, // #813
  { 4,  3,   0}, // #814
  { 5,  9,   0}, // #815
  { 7,  2,   0}, // #816
  { 8,  2,   0}, // #817
  { 9,  1,   0}, // #818
  {10,  1,   0}, // #819
  {11,  1,   0}, // #820
  {15,  1,   0}, // #821
  {16,  1,   0}, // #822
  { 3,  1,   0}, // #823
  { 4, 10,   0}, // #824
  { 5, 10,   0}, // #825
  { 6,  1,   0}, // #826
  { 7,  3,   0}, // #827
  { 8,  2,   0}, // #828
  {10,  1,   0}, // #829
  {11,  1,   0}, // #830
  {20,  1,   0}, // #831
  {21,  2,   0}, // #832
  { 1,  7,   0}, // #833
  { 2, 24,   0}, // #834
  { 3, 44,   0}, // #835
  { 4, 70,   0}, // #836
  { 5, 75,   0}, // #837
  { 6, 26,   0}, // #838
  { 7, 52,   0}, // #839
  { 8, 32,   0}, // #840
  { 9, 17,   0}, // #841
  {10, 36,   0}, // #842
  {11, 37,   0}, // #843
  {15, 10,   0}, // #844
  {16,  9,   0}, // #845
  {19,  1,   0}, // #846
  {20, 19,   0}, // #847
  {23,  1,   0}, // #848
  { 3,  9,   0}, // #849
  { 4, 15,   0}, // #850
  { 5, 15,   0}, // #851
  { 6,  9,   0}, // #852
  { 7,  9,   0}, // #853
  {10,  6,   0}, // #854
  {11,  6,   0}, // #855
  {20,  6,   0}, // #856
  { 1,  5,   0}, // #857
  { 2, 20,   0}, // #858
  { 3, 35,   0}, // #859
  { 4, 61,   0}, // #860
  { 5, 66,   0}, // #861
  { 6, 20,   0}, // #862
  { 7, 46,   0}, // #863
  { 8, 31,   0}, // #864
  { 9, 15,   0}, // #865
  {10, 30,   0}, // #866
  {11, 30,   0}, // #867
  {15,  6,   0}, // #868
  {16,  5,   0}, // #869
  {19,  1,   0}, // #870
  {20, 15,   0}, // #871
  {23,  1,   0}, // #872
  { 1,  5,   0}, // #873
  { 2, 20,   0}, // #874
  { 3, 36,   0}, // #875
  { 4, 61,   0}, // #876
  { 5, 66,   0}, // #877
  { 6, 21,   0}, // #878
  { 7, 46,   0}, // #879
  { 8, 30,   0}, // #880
  { 9, 15,   0}, // #881
  {10, 30,   0}, // #882
  {11, 30,   0}, // #883
  {15,  6,   0}, // #884
  {16,  5,   0}, // #885
  {19,  1,   0}, // #886
  {20, 15,   0}, // #887
  {23,  1,   0}, // #888
  { 1,  6,   0}, // #889
  { 2, 23,   0}, // #890
  { 3, 41,   0}, // #891
  { 4, 68,   0}, // #892
  { 5, 73,   0}, // #893
  { 6, 24,   0}, // #894
  { 7, 51,   0}, // #895
  { 8, 33,   0}, // #896
  { 9, 16,   0}, // #897
  {10, 34,   0}, // #898
  {11, 34,   0}, // #899
  {15,  9,   0}, // #900
  {16,  8,   0}, // #901
  {19,  1,   0}, // #902
  {20, 18,   0}, // #903
  {23,  1,   0}, // #904
  { 2,  9,   0}, // #905
  { 3, 23,   0}, // #906
  { 4, 53,   0}, // #907
  { 5, 54,   0}, // #908
  { 6,  3,   0}, // #909
  { 7, 33,   0}, // #910
  { 8, 20,   0}, // #911
  { 9,  8,   0}, // #912
  {10, 15,   0}, // #913
  {11, 16,   0}, // #914
  {20,  2,   0}, // #915
  { 1,  7,   0}, // #916
  { 2, 26,   0}, // #917
  { 3, 46,   0}, // #918
  { 4, 71,   0}, // #919
  { 5, 79,   0}, // #920
  { 6, 27,   0}, // #921
  { 7, 52,   0}, // #922
  { 8, 32,   0}, // #923
  { 9, 19,   0}, // #924
  {10, 39,   0}, // #925
  {11, 41,   0}, // #926
  {15,  8,   0}, // #927
  {16,  8,   0}, // #928
  {20, 20,   0}, // #929
  { 1,  7,   0}, // #930
  { 2, 26,   0}, // #931
  { 3, 46,   0}, // #932
  { 4, 71,   0}, // #933
  { 5, 79,   0}, // #934
  { 6, 27,   0}, // #935
  { 7, 52,   0}, // #936
  { 8, 32,   0}, // #937
  { 9, 19,   0}, // #938
  {10, 39,   0}, // #939
  {11, 41,   0}, // #940
  {15,  7,   0}, // #941
  {16,  7,   0}, // #942
  {20, 20,   0}, // #943
  { 1,  2,   0}, // #944
  { 2,  9,   0}, // #945
  { 3, 14,   0}, // #946
  { 4, 24,   0}, // #947
  { 5, 24,   0}, // #948
  { 6,  7,   0}, // #949
  { 7, 17,   0}, // #950
  { 8, 12,   0}, // #951
  { 9,  6,   0}, // #952
  {10, 11,   0}, // #953
  {11, 11,   0}, // #954
  {15,  1,   0}, // #955
  {19,  1,   0}, // #956
  {20,  5,   0}, // #957
  {23,  1,   0}, // #958
  { 1,  2,   0}, // #959
  { 2, 12,   0}, // #960
  { 3, 17,   0}, // #961
  { 4, 27,   0}, // #962
  { 5, 32,   0}, // #963
  { 6,  7,   0}, // #964
  { 7, 17,   0}, // #965
  { 8, 12,   0}, // #966
  { 9, 10,   0}, // #967
  {10, 15,   0}, // #968
  {11, 15,   0}, // #969
  {15, 40,   0}, // #970
  {16,  2,   0}, // #971
  {19, 38,   0}, // #972
  {20,  5,   0}, // #973
  {23, 38,   0}, // #974
  { 1,  4,   0}, // #975
  { 2,  4,   0}, // #976
  { 3,  6,   0}, // #977
  { 4, 57,   0}, // #978
  { 5, 57,   0}, // #979
  { 6,  5,   0}, // #980
  { 7,  9,   0}, // #981
  { 8,  8,   0}, // #982
  {10,  1,   0}, // #983
  {11,  1,   0}, // #984
  {13, 33,   0}, // #985
  {14, 33,   0}, // #986
  {15, 33,   0}, // #987
  {16, 33,   0}, // #988
  {21,  2,   0}, // #989
  { 1,  8,   0}, // #990
  { 2, 35,   0}, // #991
  { 3, 79,   0}, // #992
  { 4, 142,   0}, // #993
  { 5, 142,   0}, // #994
  { 6, 37,   0}, // #995
  { 7, 100,   0}, // #996
  { 8, 71,   0}, // #997
  { 9, 21,   0}, // #998
  {10, 46,   0}, // #999
  {11, 46,   0}, // #1000
  {15,  1,   0}, // #1001
  {19,  1,   0}, // #1002
  {20, 10,   0}, // #1003
  {23,  1,   0}, // #1004
  { 1,  1,   0}, // #1005
  { 2,  1,   0}, // #1006
  { 3,  1,   0}, // #1007
  { 4,  2,   0}, // #1008
  { 5,  2,   0}, // #1009
  { 6,  1,   0}, // #1010
  { 7,  1,   0}, // #1011
  { 8,  1,   0}, // #1012
  { 2,  3,   0}, // #1013
  { 3,  3,   0}, // #1014
  { 4,  7,   0}, // #1015
  { 5, 10,   0}, // #1016
  { 7,  4,   0}, // #1017
  { 8,  4,   0}, // #1018
  { 9,  3,   0}, // #1019
  {10,  3,   0}, // #1020
  {11,  3,   0}, // #1021
  { 2,  1,   0}, // #1022
  { 3,  1,   0}, // #1023
  { 4,  3,   0}, // #1024
  { 5,  3,   0}, // #1025
  { 7,  2,   0}, // #1026
  { 8,  2,   0}, // #1027
  { 9,  1,   0}, // #1028
  {10,  1,   0}, // #1029
  {11,  1,   0}, // #1030
  { 3,  1,   0}, // #1031
  { 4,  1,   0}, // #1032
  { 5,  1,   0}, // #1033
  { 6,  1,   0}, // #1034
  { 7,  1,   0}, // #1035
  {10,  1,   0}, // #1036
  {11,  1,   0}, // #1037
  {15,  1,   0}, // #1038
  {19,  1,   0}, // #1039
  {20,  1,   0}, // #1040
  {23,  1,   0}, // #1041
  { 5,  2,   0}, // #1042
  {15,  1,   0}, // #1043
  {19,  1,   0}, // #1044
  {23,  1,   0}, // #1045
  { 2,  1,   0}, // #1046
  { 3,  1,   0}, // #1047
  { 4,  2,   0}, // #1048
  { 5,  2,   0}, // #1049
  { 7,  1,   0}, // #1050
  { 8,  1,   0}, // #1051
  { 9,  1,   0}, // #1052
  {10,  1,   0}, // #1053
  {11,  1,   0}, // #1054
  {15,  1,   0}, // #1055
  {19,  1,   0}, // #1056
  {23,  1,   0}, // #1057
  { 1,  5,   0}, // #1058
  { 2, 13,   0}, // #1059
  { 3, 13,   0}, // #1060
  { 4, 13,   0}, // #1061
  { 5, 13,   0}, // #1062
  { 6,  5,   0}, // #1063
  { 7,  5,   0}, // #1064
  { 8,  5,   0}, // #1065
  { 9,  8,   0}, // #1066
  {10,  8,   0}, // #1067
  {11,  8,   0}, // #1068
  {15, 21,   0}, // #1069
  {16, 21,   0}, // #1070
  { 4,  1,   0}, // #1071
  { 5,  1,   0}, // #1072
  { 7,  1,   0}, // #1073
  { 8,  1,   0}, // #1074
  {13,  1,   0}, // #1075
  {14,  1,   0}, // #1076
  {15,  1,   0}, // #1077
  {16,  1,   0}, // #1078
  {21,  1,   0}, // #1079
  { 1,  1,   0}, // #1080
  { 2,  1,   0}, // #1081
  { 3,  1,   0}, // #1082
  { 4,  1,   0}, // #1083
  { 5,  1,   0}, // #1084
  { 6,  1,   0}, // #1085
  { 7,  1,   0}, // #1086
  { 8,  1,   0}, // #1087
  {14,  1,   0}, // #1088
  {15,  1,   0}, // #1089
  {18,  1,   0}, // #1090
  {19,  1,   0}, // #1091
  { 5,  5,   0}, // #1092
  {15,  2,   0}, // #1093
  {16,  2,   0}, // #1094
  { 5,  2,   0}, // #1095
  {15,  2,   0}, // #1096
  {16,  1,   0}, // #1097
  {19,  1,   0}, // #1098
  {23,  1,   0}, // #1099
  { 4,  2,   0}, // #1100
  { 5,  2,   0}, // #1101
  { 7,  1,   0}, // #1102
  { 8,  1,   0}, // #1103
  {13,  1,   0}, // #1104
  {14,  2,   0}, // #1105
  {15,  2,   0}, // #1106
  {16,  1,   0}, // #1107
  {18,  1,   0}, // #1108
  {19,  1,   0}, // #1109
  {21,  1,   0}, // #1110
  { 4,  1,   0}, // #1111
  { 5,  3,   0}, // #1112
  { 7,  1,   0}, // #1113
  { 8,  1,   0}, // #1114
  {15,  2,   0}, // #1115
  {16,  1,   0}, // #1116
  {19,  1,   0}, // #1117
  {23,  1,   0}, // #1118
  { 3,  2,   0}, // #1119
  { 4,  2,   0}, // #1120
  { 5,  2,   0}, // #1121
  { 6,  2,   0}, // #1122
  { 7,  2,   0}, // #1123
  {10,  2,   0}, // #1124
  {11,  2,   0}, // #1125
  {13,  1,   0}, // #1126
  {14,  1,   0}, // #1127
  {15,  1,   0}, // #1128
  {16,  1,   0}, // #1129
  {20,  2,   0}, // #1130
  { 1,  1,   0}, // #1131
  { 2,  1,   0}, // #1132
  { 3,  1,   0}, // #1133
  { 4,  1,   0}, // #1134
  { 5,  1,   0}, // #1135
  { 6,  1,   0}, // #1136
  { 7,  1,   0}, // #1137
  { 8,  1,   0}, // #1138
  {13,  1,   0}, // #1139
  {14,  1,   0}, // #1140
  {15,  1,   0}, // #1141
  {16,  1,   0}, // #1142
  { 1,  1,   0}, // #1143
  { 2,  1,   0}, // #1144
  { 3,  2,   0}, // #1145
  { 4,  2,   0}, // #1146
  { 5,  2,   0}, // #1147
  { 6,  2,   0}, // #1148
  { 7,  2,   0}, // #1149
  { 8,  1,   0}, // #1150
  {10,  1,   0}, // #1151
  {11,  1,   0}, // #1152
  {13,  1,   0}, // #1153
  {14,  1,   0}, // #1154
  {15,  1,   0}, // #1155
  {16,  1,   0}, // #1156
  {20,  1,   0}, // #1157
  { 2,  3,   0}, // #1158
  { 3,  4,   0}, // #1159
  { 4,  7,   0}, // #1160
  { 5, 10,   0}, // #1161
  { 7,  3,   0}, // #1162
  { 8,  3,   0}, // #1163
  { 9,  3,   0}, // #1164
  {10,  3,   0}, // #1165
  {11,  4,   0}, // #1166
  { 4,  2,   0}, // #1167
  { 5,  2,   0}, // #1168
  { 7,  2,   0}, // #1169
  { 8,  2,   0}, // #1170
  {15,  1,   0}, // #1171
  {16,  1,   0}, // #1172
  { 2,  2,   0}, // #1173
  { 3,  3,   0}, // #1174
  { 4,  9,   0}, // #1175
  { 5, 18,   0}, // #1176
  { 6,  1,   0}, // #1177
  { 7,  7,   0}, // #1178
  { 8,  6,   0}, // #1179
  { 9,  2,   0}, // #1180
  {10,  3,   0}, // #1181
  {11,  3,   0}, // #1182
  {20,  1,   0}, // #1183
  { 1,  2,   0}, // #1184
  { 2,  9,   0}, // #1185
  { 3, 14,   0}, // #1186
  { 4, 21,   0}, // #1187
  { 5, 24,   0}, // #1188
  { 6,  4,   0}, // #1189
  { 7, 11,   0}, // #1190
  { 8,  7,   0}, // #1191
  { 9,  7,   0}, // #1192
  {10, 12,   0}, // #1193
  {11, 12,   0}, // #1194
  {15,  1,   0}, // #1195
  {16,  1,   0}, // #1196
  {20,  2,   0}, // #1197
  { 2,  2,   0}, // #1198
  { 3,  2,   0}, // #1199
  { 4,  2,   0}, // #1200
  { 5,  3,   0}, // #1201
  { 9,  2,   0}, // #1202
  {10,  2,   0}, // #1203
  {11,  2,   0}, // #1204
  {15,  2,   0}, // #1205
  {19,  2,   0}, // #1206
  {23,  2,   0}, // #1207
  { 4,  1,   0}, // #1208
  { 5,  1,   0}, // #1209
  { 7,  1,   0}, // #1210
  { 8,  1,   0}, // #1211
  {15,  1,   0}, // #1212
  {19,  1,   0}, // #1213
  {23,  1,   0}, // #1214
  { 2,  5,   0}, // #1215
  { 3,  5,   0}, // #1216
  { 4, 16,   0}, // #1217
  { 5, 23,   0}, // #1218
  { 7, 11,   0}, // #1219
  { 8,  8,   0}, // #1220
  { 9,  5,   0}, // #1221
  {10,  5,   0}, // #1222
  {11,  5,   0}, // #1223
  { 3,  2,   0}, // #1224
  { 4,  2,   0}, // #1225
  { 5,  2,   0}, // #1226
  { 6,  2,   0}, // #1227
  { 7,  2,   0}, // #1228
  {10,  2,   0}, // #1229
  {11,  2,   0}, // #1230
  {15,  1,   0}, // #1231
  {16,  1,   0}, // #1232
  {20,  2,   0}, // #1233
  { 3,  2,   0}, // #1234
  { 4,  2,   0}, // #1235
  { 5,  2,   0}, // #1236
  { 6,  2,   0}, // #1237
  { 7,  2,   0}, // #1238
  {10,  2,   0}, // #1239
  {11,  2,   0}, // #1240
  {20,  2,   0}, // #1241
  { 1,  1,   0}, // #1242
  { 2,  6,   0}, // #1243
  { 3,  8,   0}, // #1244
  { 4, 17,   0}, // #1245
  { 5, 20,   0}, // #1246
  { 6,  2,   0}, // #1247
  { 7, 11,   0}, // #1248
  { 8,  9,   0}, // #1249
  { 9,  5,   0}, // #1250
  {10,  7,   0}, // #1251
  {11,  7,   0}, // #1252
  {15,  2,   0}, // #1253
  {16,  2,   0}, // #1254
  {20,  1,   0}, // #1255
  { 1,  1,   0}, // #1256
  { 2,  4,   0}, // #1257
  { 3,  5,   0}, // #1258
  { 4, 10,   0}, // #1259
  { 5, 10,   0}, // #1260
  { 6,  2,   0}, // #1261
  { 7,  7,   0}, // #1262
  { 8,  6,   0}, // #1263
  { 9,  3,   0}, // #1264
  {10,  4,   0}, // #1265
  {11,  4,   0}, // #1266
  {15,  3,   0}, // #1267
  {16,  3,   0}, // #1268
  {20,  1,   0}, // #1269
  { 2,  8,   0}, // #1270
  { 3, 14,   0}, // #1271
  { 4, 30,   0}, // #1272
  { 5, 54,   0}, // #1273
  { 6,  2,   0}, // #1274
  { 7, 18,   0}, // #1275
  { 8, 14,   0}, // #1276
  { 9,  8,   0}, // #1277
  {10, 10,   0}, // #1278
  {11, 11,   0}, // #1279
  {20,  2,   0}, // #1280
  { 2,  2,   0}, // #1281
  { 3,  2,   0}, // #1282
  { 4,  7,   0}, // #1283
  { 5,  9,   0}, // #1284
  { 7,  5,   0}, // #1285
  { 8,  5,   0}, // #1286
  { 9,  2,   0}, // #1287
  {10,  2,   0}, // #1288
  {11,  2,   0}, // #1289
  { 2,  3,   0}, // #1290
  { 3,  4,   0}, // #1291
  { 4, 10,   0}, // #1292
  { 5, 15,   0}, // #1293
  { 6,  1,   0}, // #1294
  { 7,  7,   0}, // #1295
  { 8,  6,   0}, // #1296
  { 9,  3,   0}, // #1297
  {10,  4,   0}, // #1298
  {11,  4,   0}, // #1299
  {20,  1,   0}, // #1300
  { 2,  1,   0}, // #1301
  { 3,  1,   0}, // #1302
  { 4, 30,   0}, // #1303
  { 5, 30,   0}, // #1304
  { 7,  8,   0}, // #1305
  { 8,  8,   0}, // #1306
  { 9,  1,   0}, // #1307
  {10,  1,   0}, // #1308
  {11,  1,   0}, // #1309
  {13,  1,   0}, // #1310
  {14,  1,   0}, // #1311
  {15,  1,   0}, // #1312
  {16,  1,   0}, // #1313
  {21,  8,   0}, // #1314
  { 2, 35,   0}, // #1315
  { 3, 90,   0}, // #1316
  { 4, 134,   0}, // #1317
  { 5, 134,   0}, // #1318
  { 6, 34,   0}, // #1319
  { 7, 78,   0}, // #1320
  { 8, 44,   0}, // #1321
  { 9, 21,   0}, // #1322
  {10, 51,   0}, // #1323
  {11, 51,   0}, // #1324
  {15,  5,   0}, // #1325
  {16,  4,   0}, // #1326
  {19,  1,   0}, // #1327
  {20,  9,   0}, // #1328
  {23,  1,   0}, // #1329
  { 2, 52,   0}, // #1330
  { 3, 97,   0}, // #1331
  { 4, 150,   0}, // #1332
  { 5, 150,   0}, // #1333
  { 6, 45,   0}, // #1334
  { 7, 98,   0}, // #1335
  { 8, 53,   0}, // #1336
  { 9, 27,   0}, // #1337
  {10, 37,   0}, // #1338
  {11, 37,   0}, // #1339
  {15,  5,   0}, // #1340
  {16,  4,   0}, // #1341
  {19,  1,   0}, // #1342
  {20, 10,   0}, // #1343
  {23,  1,   0}, // #1344
  { 2,  1,   0}, // #1345
  { 3,  4,   0}, // #1346
  { 4, 15,   0}, // #1347
  { 5, 15,   0}, // #1348
  { 6,  2,   0}, // #1349
  { 7,  5,   0}, // #1350
  { 8,  3,   0}, // #1351
  { 9,  1,   0}, // #1352
  {10,  4,   0}, // #1353
  {11,  4,   0}, // #1354
  {13,  1,   0}, // #1355
  {14,  2,   0}, // #1356
  {15,  2,   0}, // #1357
  {16,  1,   0}, // #1358
  {18,  1,   0}, // #1359
  {19,  1,   0}, // #1360
  {20,  2,   0}, // #1361
  {21,  3,   0}, // #1362
  { 1,  2,   0}, // #1363
  { 2,  2,   0}, // #1364
  { 3,  7,   0}, // #1365
  { 4, 56,   0}, // #1366
  { 5, 56,   0}, // #1367
  { 6,  7,   0}, // #1368
  { 7, 17,   0}, // #1369
  { 8, 12,   0}, // #1370
  {13,  8,   0}, // #1371
  {14,  8,   0}, // #1372
  {15,  8,   0}, // #1373
  {16,  8,   0}, // #1374
  { 1,  4,   0}, // #1375
  { 2,  4,   0}, // #1376
  { 3,  6,   0}, // #1377
  { 4, 57,   0}, // #1378
  { 5, 57,   0}, // #1379
  { 6,  5,   0}, // #1380
  { 7, 11,   0}, // #1381
  { 8, 10,   0}, // #1382
  {10,  1,   0}, // #1383
  {11,  1,   0}, // #1384
  {13, 31,   0}, // #1385
  {14, 31,   0}, // #1386
  {15, 31,   0}, // #1387
  {16, 31,   0}, // #1388
  {21,  4,   0}, // #1389
  { 1,  9,   0}, // #1390
  { 2, 10,   0}, // #1391
  { 3, 26,   0}, // #1392
  { 4, 78,   0}, // #1393
  { 5, 78,   0}, // #1394
  { 6, 25,   0}, // #1395
  { 7, 47,   0}, // #1396
  { 8, 31,   0}, // #1397
  { 9,  1,   0}, // #1398
  {10, 17,   0}, // #1399
  {11, 17,   0}, // #1400
  {14, 11,   0}, // #1401
  {15, 11,   0}, // #1402
  {18, 11,   0}, // #1403
  {19, 11,   0}, // #1404
  {20, 16,   0}, // #1405
  {21,  1,   0}, // #1406
  { 1,  1,   0}, // #1407
  { 2,  1,   0}, // #1408
  { 3,  3,   0}, // #1409
  { 4,  3,   0}, // #1410
  { 5,  3,   0}, // #1411
  { 6,  1,   0}, // #1412
  { 7,  1,   0}, // #1413
  { 8,  1,   0}, // #1414
  {10,  1,   0}, // #1415
  {11,  1,   0}, // #1416
  {15,  2,   0}, // #1417
  {16,  2,   0}, // #1418
  { 1,  1,   0}, // #1419
  { 2,  1,   0}, // #1420
  { 3,  4,   0}, // #1421
  { 4,  4,   0}, // #1422
  { 5,  4,   0}, // #1423
  { 6,  1,   0}, // #1424
  { 7,  1,   0}, // #1425
  { 8,  1,   0}, // #1426
  {10,  2,   0}, // #1427
  {11,  2,   0}, // #1428
  {15,  4,   0}, // #1429
  {16,  4,   0}, // #1430
  { 1,  1,   0}, // #1431
  { 2,  1,   0}, // #1432
  { 3,  4,   0}, // #1433
  { 4,  4,   0}, // #1434
  { 5,  4,   0}, // #1435
  { 6,  1,   0}, // #1436
  { 7,  1,   0}, // #1437
  { 8,  1,   0}, // #1438
  {10,  2,   0}, // #1439
  {11,  2,   0}, // #1440
  {15,  8,   0}, // #1441
  {16,  8,   0}, // #1442
  { 4,  2,   0}, // #1443
  { 5,  2,   0}, // #1444
  { 7,  1,   0}, // #1445
  { 8,  1,   0}, // #1446
  {13,  1,   0}, // #1447
  {14,  1,   0}, // #1448
  {15,  1,   0}, // #1449
  {16,  1,   0}, // #1450
  {21,  1,   0}, // #1451
  { 2,  1,   0}, // #1452
  { 3,  1,   0}, // #1453
  { 4,  3,   0}, // #1454
  { 5,  3,   0}, // #1455
  { 7,  2,   0}, // #1456
  { 8,  2,   0}, // #1457
  { 9,  1,   0}, // #1458
  {10,  1,   0}, // #1459
  {11,  1,   0}, // #1460
  {15,  1,   0}, // #1461
  {16,  1,   0}, // #1462
  { 1,  2,   0}, // #1463
  { 2,  2,   0}, // #1464
  { 3,  2,   0}, // #1465
  { 4,  2,   0}, // #1466
  { 5,  2,   0}, // #1467
  { 6,  2,   0}, // #1468
  { 7,  2,   0}, // #1469
  { 8,  2,   0}, // #1470
  {15,  1,   0}, // #1471
  {19,  1,   0}, // #1472
  {23,  1,   0}, // #1473
  { 2,  3,   0}, // #1474
  { 3,  6,   0}, // #1475
  { 4,  7,   0}, // #1476
  { 5,  7,   0}, // #1477
  { 6,  1,   0}, // #1478
  { 7,  2,   0}, // #1479
  { 8,  1,   0}, // #1480
  {10,  1,   0}, // #1481
  {11,  1,   0}, // #1482
  {20,  1,   0}, // #1483
  { 2,  3,   0}, // #1484
  { 3,  6,   0}, // #1485
  { 4,  7,   0}, // #1486
  { 5,  7,   0}, // #1487
  { 6,  1,   0}, // #1488
  { 7,  2,   0}, // #1489
  { 8,  1,   0}, // #1490
  {10,  1,   0}, // #1491
  {11,  1,   0}, // #1492
  {15,  1,   0}, // #1493
  {16,  1,   0}, // #1494
  {20,  1,   0}, // #1495
  { 2,  2,   0}, // #1496
  { 3,  6,   0}, // #1497
  { 4,  7,   0}, // #1498
  { 5,  7,   0}, // #1499
  { 7,  1,   0}, // #1500
  { 8,  1,   0}, // #1501
  {10,  2,   0}, // #1502
  {11,  2,   0}, // #1503
  { 2,  2,   0}, // #1504
  { 3,  6,   0}, // #1505
  { 4,  7,   0}, // #1506
  { 5,  7,   0}, // #1507
  { 7,  1,   0}, // #1508
  { 8,  1,   0}, // #1509
  {10,  2,   0}, // #1510
  {11,  2,   0}, // #1511
  {15,  1,   0}, // #1512
  {16,  1,   0}, // #1513
  { 2,  1,   0}, // #1514
  { 3,  3,   0}, // #1515
  { 4,  3,   0}, // #1516
  { 5,  3,   0}, // #1517
  {10,  1,   0}, // #1518
  {11,  1,   0}, // #1519
  { 2,  1,   0}, // #1520
  { 3,  3,   0}, // #1521
  { 4,  3,   0}, // #1522
  { 5,  3,   0}, // #1523
  {10,  1,   0}, // #1524
  {11,  1,   0}, // #1525
  {15,  1,   0}, // #1526
  {16,  1,   0}, // #1527
  { 4,  1,   0}, // #1528
  { 5,  2,   0}, // #1529
  { 7,  1,   0}, // #1530
  { 8,  1,   0}, // #1531
  {15,  1,   0}, // #1532
  {16,  1,   0}, // #1533
  { 4,  1,   0}, // #1534
  { 5,  5,   0}, // #1535
  { 7,  1,   0}, // #1536
  { 8,  1,   0}, // #1537
  {15,  2,   0}, // #1538
  {16,  1,   0}, // #1539
  {19,  1,   0}, // #1540
  {23,  1,   0}, // #1541
  { 1,  1,   0}, // #1542
  { 2,  4,   0}, // #1543
  { 3,  5,   0}, // #1544
  { 4,  9,   0}, // #1545
  { 5, 13,   0}, // #1546
  { 6,  2,   0}, // #1547
  { 7,  6,   0}, // #1548
  { 8,  5,   0}, // #1549
  { 9,  3,   0}, // #1550
  {10,  4,   0}, // #1551
  {11,  4,   0}, // #1552
  {15,  2,   0}, // #1553
  {16,  2,   0}, // #1554
  {20,  1,   0}, // #1555
  { 1,  1,   0}, // #1556
  { 2,  1,   0}, // #1557
  { 3,  3,   0}, // #1558
  { 4,  3,   0}, // #1559
  { 5,  3,   0}, // #1560
  { 6,  3,   0}, // #1561
  { 7,  3,   0}, // #1562
  { 8,  1,   0}, // #1563
  {10,  2,   0}, // #1564
  {11,  2,   0}, // #1565
  {20,  2,   0}, // #1566
  { 2,  1,   0}, // #1567
  { 3,  3,   0}, // #1568
  { 4,  3,   0}, // #1569
  { 5,  3,   0}, // #1570
  {10,  2,   0}, // #1571
  {11,  2,   0}, // #1572
  { 1,  1,   0}, // #1573
  { 2,  1,   0}, // #1574
  { 3,  3,   0}, // #1575
  { 4,  3,   0}, // #1576
  { 5,  3,   0}, // #1577
  { 6,  3,   0}, // #1578
  { 7,  3,   0}, // #1579
  { 8,  1,   0}, // #1580
  {10,  2,   0}, // #1581
  {11,  2,   0}, // #1582
  {15,  1,   0}, // #1583
  {16,  1,   0}, // #1584
  {20,  2,   0}, // #1585
  { 2,  1,   0}, // #1586
  { 3,  3,   0}, // #1587
  { 4,  3,   0}, // #1588
  { 5,  3,   0}, // #1589
  {10,  2,   0}, // #1590
  {11,  2,   0}, // #1591
  {15,  1,   0}, // #1592
  {16,  1,   0}, // #1593
  { 2, 52,   0}, // #1594
  { 3, 125,   0}, // #1595
  { 4, 178,   0}, // #1596
  { 5, 178,   0}, // #1597
  { 6, 41,   0}, // #1598
  { 7, 94,   0}, // #1599
  { 8, 53,   0}, // #1600
  { 9, 29,   0}, // #1601
  {10, 69,   0}, // #1602
  {11, 69,   0}, // #1603
  {15,  6,   0}, // #1604
  {16,  4,   0}, // #1605
  {19,  2,   0}, // #1606
  {20,  8,   0}, // #1607
  {23,  2,   0}, // #1608
  { 4,  1,   0}, // #1609
  { 5,  1,   0}, // #1610
  {13,  1,   0}, // #1611
  {14,  2,   0}, // #1612
  {15,  2,   0}, // #1613
  {16,  1,   0}, // #1614
  {18,  1,   0}, // #1615
  {19,  1,   0}, // #1616
  { 2,  1,   0}, // #1617
  { 3,  1,   0}, // #1618
  { 4,  3,   0}, // #1619
  { 5,  8,   0}, // #1620
  { 7,  2,   0}, // #1621
  { 8,  2,   0}, // #1622
  { 9,  1,   0}, // #1623
  {10,  1,   0}, // #1624
  {11,  1,   0}, // #1625
  {15,  1,   0}, // #1626
  {16,  1,   0}, // #1627
  { 2,  1,   0}, // #1628
  { 3,  1,   0}, // #1629
  { 4,  3,   0}, // #1630
  { 5,  7,   0}, // #1631
  { 7,  2,   0}, // #1632
  { 8,  2,   0}, // #1633
  { 9,  1,   0}, // #1634
  {10,  1,   0}, // #1635
  {11,  1,   0}, // #1636
  {15,  2,   0}, // #1637
  {16,  1,   0}, // #1638
  {19,  1,   0}, // #1639
  {23,  1,   0}, // #1640
  { 4,  1,   0}, // #1641
  { 5,  2,   0}, // #1642
  { 7,  1,   0}, // #1643
  { 8,  1,   0}, // #1644
  {15,  1,   0}, // #1645
  {19,  1,   0}, // #1646
  {23,  1,   0}, // #1647
  { 2,  1,   0}, // #1648
  { 3,  4,   0}, // #1649
  { 4, 10,   0}, // #1650
  { 5, 10,   0}, // #1651
  { 6,  3,   0}, // #1652
  { 7,  9,   0}, // #1653
  { 8,  6,   0}, // #1654
  { 9,  1,   0}, // #1655
  {10,  4,   0}, // #1656
  {11,  4,   0}, // #1657
  {20,  3,   0}, // #1658
  { 1,  7,   0}, // #1659
  { 2, 26,   0}, // #1660
  { 3, 47,   0}, // #1661
  { 4, 73,   0}, // #1662
  { 5, 80,   0}, // #1663
  { 6, 28,   0}, // #1664
  { 7, 54,   0}, // #1665
  { 8, 33,   0}, // #1666
  { 9, 19,   0}, // #1667
  {10, 40,   0}, // #1668
  {11, 42,   0}, // #1669
  {15,  7,   0}, // #1670
  {16,  7,   0}, // #1671
  {20, 21,   0}, // #1672
  { 1,  7,   0}, // #1673
  { 2, 27,   0}, // #1674
  { 3, 47,   0}, // #1675
  { 4, 73,   0}, // #1676
  { 5, 80,   0}, // #1677
  { 6, 27,   0}, // #1678
  { 7, 53,   0}, // #1679
  { 8, 33,   0}, // #1680
  { 9, 19,   0}, // #1681
  {10, 39,   0}, // #1682
  {11, 42,   0}, // #1683
  {15,  7,   0}, // #1684
  {16,  7,   0}, // #1685
  {20, 20,   0}, // #1686
  { 1,  7,   0}, // #1687
  { 2, 28,   0}, // #1688
  { 3, 48,   0}, // #1689
  { 4, 76,   0}, // #1690
  { 5, 84,   0}, // #1691
  { 6, 27,   0}, // #1692
  { 7, 55,   0}, // #1693
  { 8, 35,   0}, // #1694
  { 9, 21,   0}, // #1695
  {10, 41,   0}, // #1696
  {11, 43,   0}, // #1697
  {15, 10,   0}, // #1698
  {16, 10,   0}, // #1699
  {20, 20,   0}, // #1700
  { 1,  7,   0}, // #1701
  { 2, 28,   0}, // #1702
  { 3, 49,   0}, // #1703
  { 4, 77,   0}, // #1704
  { 5, 88,   0}, // #1705
  { 6, 28,   0}, // #1706
  { 7, 56,   0}, // #1707
  { 8, 35,   0}, // #1708
  { 9, 21,   0}, // #1709
  {10, 42,   0}, // #1710
  {11, 44,   0}, // #1711
  {15, 11,   0}, // #1712
  {16, 11,   0}, // #1713
  {20, 21,   0}, // #1714
  { 1,  7,   0}, // #1715
  { 2, 24,   0}, // #1716
  { 3, 43,   0}, // #1717
  { 4, 67,   0}, // #1718
  { 5, 73,   0}, // #1719
  { 6, 26,   0}, // #1720
  { 7, 50,   0}, // #1721
  { 8, 31,   0}, // #1722
  { 9, 17,   0}, // #1723
  {10, 36,   0}, // #1724
  {11, 36,   0}, // #1725
  {15,  9,   0}, // #1726
  {16,  8,   0}, // #1727
  {19,  1,   0}, // #1728
  {20, 19,   0}, // #1729
  {23,  1,   0}, // #1730
  { 1,  7,   0}, // #1731
  { 2, 24,   0}, // #1732
  { 3, 46,   0}, // #1733
  { 4, 74,   0}, // #1734
  { 5, 79,   0}, // #1735
  { 6, 28,   0}, // #1736
  { 7, 56,   0}, // #1737
  { 8, 34,   0}, // #1738
  { 9, 17,   0}, // #1739
  {10, 38,   0}, // #1740
  {11, 38,   0}, // #1741
  {15, 12,   0}, // #1742
  {16, 11,   0}, // #1743
  {19,  1,   0}, // #1744
  {20, 21,   0}, // #1745
  {23,  1,   0}, // #1746
  { 1,  5,   0}, // #1747
  { 2, 11,   0}, // #1748
  { 3, 18,   0}, // #1749
  { 4, 26,   0}, // #1750
  { 5, 32,   0}, // #1751
  { 6, 12,   0}, // #1752
  { 7, 20,   0}, // #1753
  { 8, 13,   0}, // #1754
  { 9,  6,   0}, // #1755
  {10, 13,   0}, // #1756
  {11, 15,   0}, // #1757
  {15,  5,   0}, // #1758
  {19,  5,   0}, // #1759
  {20,  7,   0}, // #1760
  {23,  5,   0}, // #1761
  { 4,  1,   0}, // #1762
  { 5,  1,   0}, // #1763
  { 7,  1,   0}, // #1764
  { 8,  1,   0}, // #1765
  {21,  1,   0}, // #1766
  { 1,  8,   0}, // #1767
  { 2, 22,   0}, // #1768
  { 3, 23,   0}, // #1769
  { 4, 25,   0}, // #1770
  { 5, 25,   0}, // #1771
  { 6,  9,   0}, // #1772
  { 7, 11,   0}, // #1773
  { 8, 10,   0}, // #1774
  { 9, 14,   0}, // #1775
  {10, 15,   0}, // #1776
  {11, 15,   0}, // #1777
  {15,  3,   0}, // #1778
  {16,  3,   0}, // #1779
  {20,  1,   0}, // #1780
  { 1,  1,   0}, // #1781
  { 2,  6,   0}, // #1782
  { 3,  9,   0}, // #1783
  { 4, 18,   0}, // #1784
  { 5, 20,   0}, // #1785
  { 6,  4,   0}, // #1786
  { 7, 13,   0}, // #1787
  { 8, 10,   0}, // #1788
  { 9,  5,   0}, // #1789
  {10,  6,   0}, // #1790
  {11,  6,   0}, // #1791
  {15,  3,   0}, // #1792
  {16,  3,   0}, // #1793
  {20,  1,   0}, // #1794
  { 1,  1,   0}, // #1795
  { 2,  4,   0}, // #1796
  { 3,  4,   0}, // #1797
  { 4,  8,   0}, // #1798
  { 5, 10,   0}, // #1799
  { 6,  1,   0}, // #1800
  { 7,  5,   0}, // #1801
  { 8,  5,   0}, // #1802
  { 9,  3,   0}, // #1803
  {10,  3,   0}, // #1804
  {11,  3,   0}, // #1805
  {15,  3,   0}, // #1806
  {16,  2,   0}, // #1807
  {19,  1,   0}, // #1808
  {23,  1,   0}, // #1809
  { 2,  3,   0}, // #1810
  { 3,  4,   0}, // #1811
  { 4,  9,   0}, // #1812
  { 5, 10,   0}, // #1813
  { 6,  1,   0}, // #1814
  { 7,  6,   0}, // #1815
  { 8,  5,   0}, // #1816
  { 9,  3,   0}, // #1817
  {10,  3,   0}, // #1818
  {11,  3,   0}, // #1819
  {15,  3,   0}, // #1820
  {16,  2,   0}, // #1821
  {19,  1,   0}, // #1822
  {23,  1,   0}, // #1823
  { 2,  3,   0}, // #1824
  { 3,  3,   0}, // #1825
  { 4,  8,   0}, // #1826
  { 5,  8,   0}, // #1827
  { 7,  5,   0}, // #1828
  { 8,  5,   0}, // #1829
  { 9,  3,   0}, // #1830
  {10,  3,   0}, // #1831
  {11,  3,   0}, // #1832
  {15,  3,   0}, // #1833
  {16,  2,   0}, // #1834
  {19,  1,   0}, // #1835
  {23,  1,   0}, // #1836
  { 2,  3,   0}, // #1837
  { 3,  3,   0}, // #1838
  { 4,  7,   0}, // #1839
  { 5,  8,   0}, // #1840
  { 7,  4,   0}, // #1841
  { 8,  4,   0}, // #1842
  { 9,  3,   0}, // #1843
  {10,  3,   0}, // #1844
  {11,  3,   0}, // #1845
  {15,  2,   0}, // #1846
  {16,  1,   0}, // #1847
  {19,  1,   0}, // #1848
  {23,  1,   0}, // #1849
  { 1,  1,   0}, // #1850
  { 2,  4,   0}, // #1851
  { 3, 12,   0}, // #1852
  { 4, 20,   0}, // #1853
  { 5, 22,   0}, // #1854
  { 6,  8,   0}, // #1855
  { 7, 16,   0}, // #1856
  { 8,  9,   0}, // #1857
  { 9,  3,   0}, // #1858
  {10, 10,   0}, // #1859
  {11, 10,   0}, // #1860
  {15,  3,   0}, // #1861
  {16,  1,   0}, // #1862
  {19,  2,   0}, // #1863
  {20,  7,   0}, // #1864
  {23,  2,   0}, // #1865
  { 2,  1,   0}, // #1866
  { 3,  6,   0}, // #1867
  { 4, 13,   0}, // #1868
  { 5, 18,   0}, // #1869
  { 6,  5,   0}, // #1870
  { 7, 12,   0}, // #1871
  { 8,  7,   0}, // #1872
  { 9,  1,   0}, // #1873
  {10,  6,   0}, // #1874
  {11,  6,   0}, // #1875
  {15,  2,   0}, // #1876
  {19,  2,   0}, // #1877
  {20,  5,   0}, // #1878
  {23,  2,   0}, // #1879
  { 2,  8,   0}, // #1880
  { 3, 22,   0}, // #1881
  { 4, 38,   0}, // #1882
  { 5, 44,   0}, // #1883
  { 6, 12,   0}, // #1884
  { 7, 28,   0}, // #1885
  { 8, 16,   0}, // #1886
  { 9,  7,   0}, // #1887
  {10, 19,   0}, // #1888
  {11, 21,   0}, // #1889
  {15,  2,   0}, // #1890
  {19,  2,   0}, // #1891
  {20, 12,   0}, // #1892
  {23,  2,   0}, // #1893
  { 3,  1,   0}, // #1894
  { 4,  2,   0}, // #1895
  { 5,  3,   0}, // #1896
  { 6,  1,   0}, // #1897
  { 7,  2,   0}, // #1898
  { 8,  1,   0}, // #1899
  {10,  1,   0}, // #1900
  {11,  1,   0}, // #1901
  {20,  1,   0}, // #1902
  { 2,  4,   0}, // #1903
  { 3, 10,   0}, // #1904
  { 4, 18,   0}, // #1905
  { 5, 24,   0}, // #1906
  { 6,  3,   0}, // #1907
  { 7, 11,   0}, // #1908
  { 8,  8,   0}, // #1909
  { 9,  4,   0}, // #1910
  {10,  7,   0}, // #1911
  {11,  9,   0}, // #1912
  {20,  3,   0}, // #1913
  { 1,  6,   0}, // #1914
  { 2, 21,   0}, // #1915
  { 3, 38,   0}, // #1916
  { 4, 66,   0}, // #1917
  { 5, 70,   0}, // #1918
  { 6, 23,   0}, // #1919
  { 7, 51,   0}, // #1920
  { 8, 34,   0}, // #1921
  { 9, 15,   0}, // #1922
  {10, 31,   0}, // #1923
  {11, 31,   0}, // #1924
  {15,  8,   0}, // #1925
  {16,  7,   0}, // #1926
  {19,  1,   0}, // #1927
  {20, 16,   0}, // #1928
  {23,  1,   0}, // #1929
  { 1,  6,   0}, // #1930
  { 2, 21,   0}, // #1931
  { 3, 37,   0}, // #1932
  { 4, 64,   0}, // #1933
  { 5, 70,   0}, // #1934
  { 6, 22,   0}, // #1935
  { 7, 49,   0}, // #1936
  { 8, 33,   0}, // #1937
  { 9, 15,   0}, // #1938
  {10, 31,   0}, // #1939
  {11, 31,   0}, // #1940
  {15,  8,   0}, // #1941
  {16,  7,   0}, // #1942
  {19,  1,   0}, // #1943
  {20, 16,   0}, // #1944
  {23,  1,   0}, // #1945
  { 1,  6,   0}, // #1946
  { 2, 21,   0}, // #1947
  { 3, 40,   0}, // #1948
  { 4, 70,   0}, // #1949
  { 5, 74,   0}, // #1950
  { 6, 25,   0}, // #1951
  { 7, 55,   0}, // #1952
  { 8, 36,   0}, // #1953
  { 9, 15,   0}, // #1954
  {10, 33,   0}, // #1955
  {11, 33,   0}, // #1956
  {15, 10,   0}, // #1957
  {16,  9,   0}, // #1958
  {19,  1,   0}, // #1959
  {20, 18,   0}, // #1960
  {23,  1,   0}, // #1961
  { 1,  6,   0}, // #1962
  { 2, 21,   0}, // #1963
  { 3, 39,   0}, // #1964
  { 4, 68,   0}, // #1965
  { 5, 74,   0}, // #1966
  { 6, 24,   0}, // #1967
  { 7, 53,   0}, // #1968
  { 8, 35,   0}, // #1969
  { 9, 15,   0}, // #1970
  {10, 33,   0}, // #1971
  {11, 33,   0}, // #1972
  {15, 10,   0}, // #1973
  {16,  9,   0}, // #1974
  {19,  1,   0}, // #1975
  {20, 18,   0}, // #1976
  {23,  1,   0}, // #1977
  { 1,  7,   0}, // #1978
  { 2, 23,   0}, // #1979
  { 3, 40,   0}, // #1980
  { 4, 65,   0}, // #1981
  { 5, 71,   0}, // #1982
  { 6, 24,   0}, // #1983
  { 7, 49,   0}, // #1984
  { 8, 32,   0}, // #1985
  { 9, 16,   0}, // #1986
  {10, 33,   0}, // #1987
  {11, 33,   0}, // #1988
  {15,  8,   0}, // #1989
  {16,  7,   0}, // #1990
  {19,  1,   0}, // #1991
  {20, 17,   0}, // #1992
  {23,  1,   0}, // #1993
  { 1,  7,   0}, // #1994
  { 2, 23,   0}, // #1995
  { 3, 43,   0}, // #1996
  { 4, 71,   0}, // #1997
  { 5, 77,   0}, // #1998
  { 6, 27,   0}, // #1999
  { 7, 55,   0}, // #2000
  { 8, 35,   0}, // #2001
  { 9, 16,   0}, // #2002
  {10, 36,   0}, // #2003
  {11, 36,   0}, // #2004
  {15, 11,   0}, // #2005
  {16, 10,   0}, // #2006
  {19,  1,   0}, // #2007
  {20, 20,   0}, // #2008
  {23,  1,   0}, // #2009
  { 4,  2,   0}, // #2010
  { 5,  3,   0}, // #2011
  { 7,  2,   0}, // #2012
  { 8,  2,   0}, // #2013
  {15,  1,   0}, // #2014
  {16,  1,   0}, // #2015
  {21,  2,   0}, // #2016
  { 4,  2,   0}, // #2017
  { 5,  3,   0}, // #2018
  { 7,  2,   0}, // #2019
  { 8,  2,   0}, // #2020
  {21,  2,   0}, // #2021
  { 4,  2,   0}, // #2022
  { 5,  4,   0}, // #2023
  { 7,  2,   0}, // #2024
  { 8,  2,   0}, // #2025
  {21,  2,   0}, // #2026
  { 2,  2,   0}, // #2027
  { 3,  2,   0}, // #2028
  { 4,  7,   0}, // #2029
  { 5,  8,   0}, // #2030
  { 7,  5,   0}, // #2031
  { 8,  5,   0}, // #2032
  { 9,  2,   0}, // #2033
  {10,  2,   0}, // #2034
  {11,  2,   0}, // #2035
  {15,  2,   0}, // #2036
  {16,  1,   0}, // #2037
  {19,  1,   0}, // #2038
  {23,  1,   0}, // #2039
  { 2,  3,   0}, // #2040
  { 3,  3,   0}, // #2041
  { 4,  7,   0}, // #2042
  { 5,  9,   0}, // #2043
  { 7,  4,   0}, // #2044
  { 8,  4,   0}, // #2045
  { 9,  3,   0}, // #2046
  {10,  3,   0}, // #2047
  {11,  3,   0}, // #2048
  {15,  2,   0}, // #2049
  {16,  1,   0}, // #2050
  {19,  1,   0}, // #2051
  {23,  1,   0}, // #2052
  { 1,  2,   0}, // #2053
  { 2,  9,   0}, // #2054
  { 3, 16,   0}, // #2055
  { 4, 24,   0}, // #2056
  { 5, 24,   0}, // #2057
  { 6,  6,   0}, // #2058
  { 7, 14,   0}, // #2059
  { 8,  7,   0}, // #2060
  { 9,  7,   0}, // #2061
  {10, 11,   0}, // #2062
  {11, 11,   0}, // #2063
  {15,  1,   0}, // #2064
  {16,  1,   0}, // #2065
  {20,  4,   0}, // #2066
  { 2,  1,   0}, // #2067
  { 3,  1,   0}, // #2068
  { 4,  3,   0}, // #2069
  { 5,  5,   0}, // #2070
  { 7,  2,   0}, // #2071
  { 8,  2,   0}, // #2072
  { 9,  1,   0}, // #2073
  {10,  1,   0}, // #2074
  {11,  1,   0}, // #2075
  {15,  1,   0}, // #2076
  {19,  1,   0}, // #2077
  {23,  1,   0}, // #2078
  { 3,  1,   0}, // #2079
  { 4,  1,   0}, // #2080
  { 5,  2,   0}, // #2081
  { 6,  1,   0}, // #2082
  { 7,  1,   0}, // #2083
  {10,  1,   0}, // #2084
  {11,  1,   0}, // #2085
  {20,  1,   0}, // #2086
  { 2,  1,   0}, // #2087
  { 3,  1,   0}, // #2088
  { 4,  5,   0}, // #2089
  { 5,  6,   0}, // #2090
  { 7,  4,   0}, // #2091
  { 8,  4,   0}, // #2092
  { 9,  1,   0}, // #2093
  {10,  1,   0}, // #2094
  {11,  1,   0}, // #2095
  { 1,  6,   0}, // #2096
  { 2, 13,   0}, // #2097
  { 3, 13,   0}, // #2098
  { 4, 13,   0}, // #2099
  { 5, 13,   0}, // #2100
  { 6,  6,   0}, // #2101
  { 7,  6,   0}, // #2102
  { 8,  6,   0}, // #2103
  { 9,  7,   0}, // #2104
  {10,  7,   0}, // #2105
  {11,  7,   0}, // #2106
  {15, 18,   0}, // #2107
  {16, 18,   0}, // #2108
  { 1,  6,   0}, // #2109
  { 2, 13,   0}, // #2110
  { 3, 13,   0}, // #2111
  { 4, 13,   0}, // #2112
  { 5, 13,   0}, // #2113
  { 6,  6,   0}, // #2114
  { 7,  6,   0}, // #2115
  { 8,  6,   0}, // #2116
  { 9,  7,   0}, // #2117
  {10,  7,   0}, // #2118
  {11,  7,   0}, // #2119
  {15, 17,   0}, // #2120
  {16, 17,   0}, // #2121
  { 1,  5,   0}, // #2122
  { 2, 13,   0}, // #2123
  { 3, 13,   0}, // #2124
  { 4, 13,   0}, // #2125
  { 5, 13,   0}, // #2126
  { 6,  5,   0}, // #2127
  { 7,  5,   0}, // #2128
  { 8,  5,   0}, // #2129
  { 9,  8,   0}, // #2130
  {10,  8,   0}, // #2131
  {11,  8,   0}, // #2132
  {15, 20,   0}, // #2133
  {16, 20,   0}, // #2134
  { 1,  1,   0}, // #2135
  { 2,  1,   0}, // #2136
  { 3,  1,   0}, // #2137
  { 4,  2,   0}, // #2138
  { 5,  2,   0}, // #2139
  { 6,  1,   0}, // #2140
  { 7,  2,   0}, // #2141
  { 8,  2,   0}, // #2142
  {15,  1,   0}, // #2143
  {16,  1,   0}, // #2144
  { 2,  4,   0}, // #2145
  { 3,  5,   0}, // #2146
  { 4,  6,   0}, // #2147
  { 5,  8,   0}, // #2148
  { 6,  1,   0}, // #2149
  { 7,  2,   0}, // #2150
  { 8,  1,   0}, // #2151
  { 9,  4,   0}, // #2152
  {10,  5,   0}, // #2153
  {11,  5,   0}, // #2154
  {20,  1,   0}, // #2155
  { 1,  1,   0}, // #2156
  { 2, 43,   0}, // #2157
  { 3, 91,   0}, // #2158
  { 4, 143,   0}, // #2159
  { 5, 143,   0}, // #2160
  { 6, 49,   0}, // #2161
  { 7, 101,   0}, // #2162
  { 8, 53,   0}, // #2163
  { 9, 23,   0}, // #2164
  {10, 35,   0}, // #2165
  {11, 35,   0}, // #2166
  {15,  6,   0}, // #2167
  {16,  4,   0}, // #2168
  {19,  2,   0}, // #2169
  {20, 12,   0}, // #2170
  {23,  2,   0}, // #2171
  { 1,  1,   0}, // #2172
  { 2, 43,   0}, // #2173
  { 3, 91,   0}, // #2174
  { 4, 144,   0}, // #2175
  { 5, 144,   0}, // #2176
  { 6, 49,   0}, // #2177
  { 7, 102,   0}, // #2178
  { 8, 54,   0}, // #2179
  { 9, 23,   0}, // #2180
  {10, 35,   0}, // #2181
  {11, 35,   0}, // #2182
  {15,  6,   0}, // #2183
  {16,  4,   0}, // #2184
  {19,  2,   0}, // #2185
  {20, 12,   0}, // #2186
  {23,  2,   0}, // #2187
  { 2, 52,   0}, // #2188
  { 3, 97,   0}, // #2189
  { 4, 149,   0}, // #2190
  { 5, 149,   0}, // #2191
  { 6, 45,   0}, // #2192
  { 7, 97,   0}, // #2193
  { 8, 52,   0}, // #2194
  { 9, 27,   0}, // #2195
  {10, 37,   0}, // #2196
  {11, 37,   0}, // #2197
  {15,  5,   0}, // #2198
  {16,  4,   0}, // #2199
  {19,  1,   0}, // #2200
  {20, 10,   0}, // #2201
  {23,  1,   0}, // #2202
  { 2, 52,   0}, // #2203
  { 3, 123,   0}, // #2204
  { 4, 176,   0}, // #2205
  { 5, 176,   0}, // #2206
  { 6, 41,   0}, // #2207
  { 7, 94,   0}, // #2208
  { 8, 53,   0}, // #2209
  { 9, 29,   0}, // #2210
  {10, 68,   0}, // #2211
  {11, 68,   0}, // #2212
  {15,  6,   0}, // #2213
  {16,  4,   0}, // #2214
  {19,  2,   0}, // #2215
  {20,  9,   0}, // #2216
  {23,  2,   0}, // #2217
  { 1,  1,   0}, // #2218
  { 3,  2,   0}, // #2219
  { 1,  1,   0}, // #2220
  { 3,  1,   0}, // #2221
  { 1,  6,   0}, // #2222
  { 2,  6,   0}, // #2223
  { 3, 12,   0}, // #2224
  { 1,  5,   0}, // #2225
  { 2,  5,   0}, // #2226
  { 3, 10,   0}, // #2227
  { 1, 16,   0}, // #2228
  { 2, 16,   0}, // #2229
  { 3, 32,   0}, // #2230
  { 3, 15,   0}, // #2231
  { 1, 10,   0}, // #2232
  { 2, 10,   0}, // #2233
  { 3, 20,   0}, // #2234
  { 1,  9,   0}, // #2235
  { 2,  9,   0}, // #2236
  { 3, 18,   0}, // #2237
  { 1,  5,   0}, // #2238
  { 3,  5,   0}, // #2239
  { 1,  7,   0}, // #2240
  { 2,  7,   0}, // #2241
  { 3, 14,   0}, // #2242
  { 1,  8,   0}, // #2243
  { 2,  8,   0}, // #2244
  { 3, 16,   0}, // #2245
  { 1, 12,   0}, // #2246
  { 2, 12,   0}, // #2247
  { 3, 24,   0}, // #2248
  { 1, 11,   0}, // #2249
  { 2, 11,   0}, // #2250
  { 3, 22,   0}, // #2251
  { 1, 50,   0}, // #2252
  { 2, 50,   0}, // #2253
  { 3, 100,   0}, // #2254
  { 1, 130,   0}, // #2255
  { 2, 130,   0}, // #2256
  { 3, 260,   0}, // #2257
  { 1, 68,   0}, // #2258
  { 2, 68,   0}, // #2259
  { 3, 136,   0}, // #2260
  { 1, 125,   0}, // #2261
  { 2, 125,   0}, // #2262
  { 3, 250,   0}, // #2263
  { 1, 70,   0}, // #2264
  { 2, 70,   0}, // #2265
  { 3, 140,   0}, // #2266
  { 1, 34,   0}, // #2267
  { 2, 34,   0}, // #2268
  { 3, 68,   0}, // #2269
  { 1, 62,   0}, // #2270
  { 2, 62,   0}, // #2271
  { 3, 124,   0}, // #2272
  { 1,  2,   0}, // #2273
  { 3,  2,   0}, // #2274
  { 1, 14,   0}, // #2275
  { 2, 14,   0}, // #2276
  { 3, 28,   0}, // #2277
  { 1,  3,   0}, // #2278
  { 3,  3,   0}, // #2279
  { 1,  4,   0}, // #2280
  { 2,  4,   0}, // #2281
  { 3,  8,   0}, // #2282
  { 1,  3,   0}, // #2283
  { 2,  3,   0}, // #2284
  { 3,  6,   0}, // #2285
  { 1,  2,   0}, // #2286
  { 2,  2,   0}, // #2287
  { 3,  4,   0}, // #2288
  { 1,  4,   0}, // #2289
  { 3,  4,   0}, // #2290
  { 1, 71,   0}, // #2291
  { 3, 71,   0}, // #2292
  { 1, 15,   0}, // #2293
  { 2, 15,   0}, // #2294
  { 3, 30,   0}, // #2295
  { 3, 21,   0}, // #2296
  { 3, 25,   0}, // #2297
  { 3, 29,   0}, // #2298
  { 3, 45,   0}, // #2299
  { 3, 55,   0}, // #2300
  { 3, 59,   0}, // #2301
  { 3, 63,   0}, // #2302
  { 3, 72,   0}, // #2303
  { 3, 74,   0}, // #2304
  { 3, 77,   0}, // #2305
  { 3, 78,   0}, // #2306
  { 3, 92,   0}, // #2307
  { 3, 94,   0}, // #2308
  { 3, 99,   0}, // #2309
  { 3, 121,   0}, // #2310
  { 3, 127,   0}, // #2311
  { 3, 130,   0}, // #2312
  { 3, 141,   0}, // #2313
  { 3, 146,   0}, // #2314
  { 3, 147,   0}, // #2315
  { 3, 168,   0}, // #2316
  { 3, 174,   0}, // #2317
  { 3, 183,   0}, // #2318
  { 3, 202,   0}, // #2319
  { 9,  6,   0}, // #2320
  {10,  2,   0}, // #2321
  { 4,  1,   0}, // #2322
  { 6,  1,   0}, // #2323
  { 5,  2,   0}, // #2324
  { 6,  2,   0}, // #2325
  {10,  1,   0}, // #2326
  { 5,  1,   0}, // #2327
  { 6,  1,   0}, // #2328
  {10,  1,   0}, // #2329
  { 4,  5,   0}, // #2330
  { 6,  5,   0}, // #2331
  {10,  1,   0}, // #2332
  { 4,  4,   0}, // #2333
  { 6,  4,   0}, // #2334
  {10,  1,   0}, // #2335
  { 4,  1,   0}, // #2336
  { 6,  1,   0}, // #2337
  {10,  1,   0}, // #2338
  { 7, 10,   0}, // #2339
  { 8, 10,   0}, // #2340
  { 9, 20,   0}, // #2341
  {10,  1,   0}, // #2342
  { 7,  1,   0}, // #2343
  { 8,  1,   0}, // #2344
  { 9,  2,   0}, // #2345
  {10,  1,   0}, // #2346
  { 7,  1,   0}, // #2347
  { 8,  1,   0}, // #2348
  { 9,  2,   0}, // #2349
  {10,  2,   0}, // #2350
  { 4,  2,   0}, // #2351
  { 6,  2,   0}, // #2352
  {10,  1,   0}, // #2353
  { 1, 25,   0}, // #2354
  { 9,  1,   0}, // #2355
  {10,  1,   0}, // #2356
  { 2, 69,   0}, // #2357
  { 4,  1,   0}, // #2358
  { 6,  1,   0}, // #2359
  {10,  1,   0}, // #2360
  { 2, 39,   0}, // #2361
  { 4,  1,   0}, // #2362
  { 6,  1,   0}, // #2363
  {10,  1,   0}, // #2364
  { 2, 17,   0}, // #2365
  { 4,  1,   0}, // #2366
  { 6,  1,   0}, // #2367
  {10,  1,   0}, // #2368
  { 2, 32,   0}, // #2369
  { 4,  1,   0}, // #2370
  { 6,  1,   0}, // #2371
  {10,  1,   0}, // #2372
  { 5,  8,   0}, // #2373
  { 6,  8,   0}, // #2374
  {10,  1,   0}, // #2375
  { 5, 12,   0}, // #2376
  { 6, 12,   0}, // #2377
  {10,  1,   0}, // #2378
  { 4,  1,   0}, // #2379
  { 6,  1,   0}, // #2380
  {10,  2,   0}, // #2381
  { 6, 10,   0}, // #2382
  { 5,  6,   0}, // #2383
  { 6,  6,   0}, // #2384
  {10,  1,   0}, // #2385
  { 8,  5,   0}, // #2386
  { 9,  5,   0}, // #2387
  {10,  1,   0}, // #2388
  { 8,  4,   0}, // #2389
  { 9,  4,   0}, // #2390
  {10,  1,   0}, // #2391
  { 8,  7,   0}, // #2392
  { 9,  7,   0}, // #2393
  {10,  1,   0}, // #2394
  { 8,  2,   0}, // #2395
  { 9,  2,   0}, // #2396
  {10,  1,   0}, // #2397
  { 7,  1,   0}, // #2398
  { 9,  1,   0}, // #2399
  {10,  1,   0}, // #2400
  { 3,  4,   0}, // #2401
  { 4,  1,   0}, // #2402
  { 6,  1,   0}, // #2403
  {10,  1,   0}, // #2404
  { 3,  2,   0}, // #2405
  { 4,  1,   0}, // #2406
  { 6,  1,   0}, // #2407
  {10,  1,   0}, // #2408
  { 4, 10,   0}, // #2409
  { 6, 10,   0}, // #2410
  {10,  1,   0}, // #2411
  { 4, 21,   0}, // #2412
  { 6, 21,   0}, // #2413
  {10,  1,   0}, // #2414
  { 4, 17,   0}, // #2415
  { 6, 17,   0}, // #2416
  {10,  1,   0}, // #2417
  { 4, 13,   0}, // #2418
  { 6, 13,   0}, // #2419
  {10,  1,   0}, // #2420
  { 4, 11,   0}, // #2421
  { 6, 11,   0}, // #2422
  {10,  1,   0}, // #2423
  { 4,  8,   0}, // #2424
  { 6,  8,   0}, // #2425
  {10,  1,   0}, // #2426
  { 2, 70,   0}, // #2427
  { 4,  1,   0}, // #2428
  { 6,  1,   0}, // #2429
  {10,  1,   0}, // #2430
  { 2, 40,   0}, // #2431
  { 4,  1,   0}, // #2432
  { 6,  1,   0}, // #2433
  {10,  1,   0}, // #2434
  { 2, 35,   0}, // #2435
  { 4,  1,   0}, // #2436
  { 6,  1,   0}, // #2437
  {10,  1,   0}, // #2438
  { 2, 20,   0}, // #2439
  { 4,  1,   0}, // #2440
  { 6,  1,   0}, // #2441
  {10,  1,   0}, // #2442
  { 5,  2,   0}, // #2443
  { 8,  2,   0}, // #2444
  {11,  1,   0}, // #2445
  {14,  1,   0}, // #2446
  {20,  1,   0}, // #2447
  { 2,  1,   0}, // #2448
  { 5,  1,   0}, // #2449
  { 7,  1,   0}, // #2450
  { 8,  1,   0}, // #2451
  { 1,  2,   0}, // #2452
  { 5, 44,   0}, // #2453
  { 7, 44,   0}, // #2454
  { 8, 44,   0}, // #2455
  {22,  1,   0}, // #2456
  {24,  1,   0}, // #2457
  { 1,  3,   0}, // #2458
  { 2,  1,   0}, // #2459
  { 5,  1,   0}, // #2460
  { 7,  1,   0}, // #2461
  { 8,  1,   0}, // #2462
  {22,  3,   0}, // #2463
  { 5,  1,   0}, // #2464
  { 8,  1,   0}, // #2465
  { 1,  1,   0}, // #2466
  {24,  1,   0}, // #2467
  { 5,  6,   0}, // #2468
  { 8,  6,   0}, // #2469
  { 1,  1,   0}, // #2470
  {13,  1,   0}, // #2471
  {14,  3,   0}, // #2472
  {20,  3,   0}, // #2473
  {24,  1,   0}, // #2474
  { 1,  3,   0}, // #2475
  {10,  3,   0}, // #2476
  {14,  1,   0}, // #2477
  {19,  1,   0}, // #2478
  {22,  3,   0}, // #2479
  { 1,  1,   0}, // #2480
  {13,  2,   0}, // #2481
  {14, 36,   0}, // #2482
  {20, 36,   0}, // #2483
  {24,  1,   0}, // #2484
  { 1,  4,   0}, // #2485
  { 5,  2,   0}, // #2486
  { 8,  2,   0}, // #2487
  {22,  3,   0}, // #2488
  {24,  1,   0}, // #2489
  {10,  4,   0}, // #2490
  {14,  1,   0}, // #2491
  {16,  1,   0}, // #2492
  {19,  1,   0}, // #2493
  { 1,  3,   0}, // #2494
  { 5,  2,   0}, // #2495
  { 8,  2,   0}, // #2496
  {22,  3,   0}, // #2497
  { 1,  3,   0}, // #2498
  {10,  1,   0}, // #2499
  {14,  1,   0}, // #2500
  {15,  1,   0}, // #2501
  {19,  1,   0}, // #2502
  {22,  3,   0}, // #2503
  { 1,  3,   0}, // #2504
  {12,  1,   0}, // #2505
  {14,  1,   0}, // #2506
  {15,  1,   0}, // #2507
  {19,  1,   0}, // #2508
  {22,  3,   0}, // #2509
  { 1,  3,   0}, // #2510
  {11,  1,   0}, // #2511
  {14,  1,   0}, // #2512
  {20,  1,   0}, // #2513
  {22,  3,   0}, // #2514
  { 1,  3,   0}, // #2515
  {14,  1,   0}, // #2516
  {16,  1,   0}, // #2517
  {19,  1,   0}, // #2518
  {21,  1,   0}, // #2519
  {22,  3,   0}, // #2520
  { 1,  3,   0}, // #2521
  { 5,  6,   0}, // #2522
  { 8,  6,   0}, // #2523
  {22,  3,   0}, // #2524
  { 1,  3,   0}, // #2525
  { 5,  8,   0}, // #2526
  { 8,  8,   0}, // #2527
  {22,  3,   0}, // #2528
  { 1,  2,   0}, // #2529
  { 5,  7,   0}, // #2530
  { 8,  7,   0}, // #2531
  {22,  2,   0}, // #2532
  { 1,  1,   0}, // #2533
  { 5, 42,   0}, // #2534
  { 8, 42,   0}, // #2535
  {22,  1,   0}, // #2536
  { 1,  1,   0}, // #2537
  { 5, 44,   0}, // #2538
  { 8, 44,   0}, // #2539
  {22,  1,   0}, // #2540
  { 1,  3,   0}, // #2541
  { 5,  1,   0}, // #2542
  { 8,  1,   0}, // #2543
  {22,  3,   0}, // #2544
  { 1,  2,   0}, // #2545
  {22,  2,   0}, // #2546
  { 5,  3,   0}, // #2547
  { 7,  3,   0}, // #2548
  { 8,  3,   0}, // #2549
  { 1,  3,   0}, // #2550
  { 5,  1,   0}, // #2551
  { 6,  1,   0}, // #2552
  { 8,  1,   0}, // #2553
  {10,  1,   0}, // #2554
  {14,  1,   0}, // #2555
  {15,  1,   0}, // #2556
  {19,  1,   0}, // #2557
  {22,  3,   0}, // #2558
  { 1,  3,   0}, // #2559
  { 5,  4,   0}, // #2560
  { 8,  4,   0}, // #2561
  {22,  3,   0}, // #2562
  { 1,  3,   0}, // #2563
  { 9,  1,   0}, // #2564
  {13,  1,   0}, // #2565
  {14,  1,   0}, // #2566
  {15,  1,   0}, // #2567
  {19,  1,   0}, // #2568
  {22,  3,   0}, // #2569
  { 1,  3,   0}, // #2570
  { 5,  1,   0}, // #2571
  { 6,  1,   0}, // #2572
  { 8,  1,   0}, // #2573
  { 9,  1,   0}, // #2574
  {10,  1,   0}, // #2575
  {13,  1,   0}, // #2576
  {14,  1,   0}, // #2577
  {15,  1,   0}, // #2578
  {19,  1,   0}, // #2579
  {22,  3,   0}, // #2580
  { 1,  3,   0}, // #2581
  { 9,  2,   0}, // #2582
  {13,  1,   0}, // #2583
  {14,  1,   0}, // #2584
  {15,  1,   0}, // #2585
  {19,  1,   0}, // #2586
  {22,  3,   0}, // #2587
  { 1,  3,   0}, // #2588
  { 4, 15,   0}, // #2589
  { 5,  1,   0}, // #2590
  { 7,  1,   0}, // #2591
  { 8,  1,   0}, // #2592
  {22,  3,   0}, // #2593
  { 1,  3,   0}, // #2594
  { 4, 14,   0}, // #2595
  { 5,  1,   0}, // #2596
  { 7,  1,   0}, // #2597
  { 8,  1,   0}, // #2598
  {22,  3,   0}, // #2599
  { 1,  3,   0}, // #2600
  { 4, 12,   0}, // #2601
  { 5,  1,   0}, // #2602
  { 7,  1,   0}, // #2603
  { 8,  1,   0}, // #2604
  {22,  3,   0}, // #2605
  { 1,  3,   0}, // #2606
  {10,  9,   0}, // #2607
  {14,  1,   0}, // #2608
  {16,  1,   0}, // #2609
  {19,  1,   0}, // #2610
  {22,  3,   0}, // #2611
  { 1,  3,   0}, // #2612
  {10, 10,   0}, // #2613
  {14,  1,   0}, // #2614
  {16,  1,   0}, // #2615
  {19,  1,   0}, // #2616
  {22,  3,   0}, // #2617
  { 1,  3,   0}, // #2618
  {10, 14,   0}, // #2619
  {14,  1,   0}, // #2620
  {16,  1,   0}, // #2621
  {19,  1,   0}, // #2622
  {22,  3,   0}, // #2623
  { 1,  1,   0}, // #2624
  {13,  1,   0}, // #2625
  {14,  2,   0}, // #2626
  {16,  2,   0}, // #2627
  {19,  2,   0}, // #2628
  {24,  1,   0}, // #2629
  { 5,  1,   0}, // #2630
  { 6,  1,   0}, // #2631
  { 8,  1,   0}, // #2632
  {10,  3,   0}, // #2633
  {14,  1,   0}, // #2634
  {15,  1,   0}, // #2635
  {19,  1,   0}, // #2636
  {10,  1,   0}, // #2637
  {14,  1,   0}, // #2638
  {19,  1,   0}, // #2639
  {13,  1,   0}, // #2640
  {14,  1,   0}, // #2641
  {16,  1,   0}, // #2642
  {19,  1,   0}, // #2643
  { 1,  3,   0}, // #2644
  {10,  5,   0}, // #2645
  {14,  1,   0}, // #2646
  {15,  1,   0}, // #2647
  {19,  1,   0}, // #2648
  {22,  3,   0}, // #2649
  { 1,  3,   0}, // #2650
  { 4, 17,   0}, // #2651
  { 5,  1,   0}, // #2652
  { 7,  1,   0}, // #2653
  { 8,  1,   0}, // #2654
  {22,  3,   0}, // #2655
  { 1,  3,   0}, // #2656
  { 4, 25,   0}, // #2657
  { 5,  1,   0}, // #2658
  { 7,  1,   0}, // #2659
  { 8,  1,   0}, // #2660
  {22,  3,   0}, // #2661
  { 1,  3,   0}, // #2662
  { 5,  1,   0}, // #2663
  { 7,  1,   0}, // #2664
  { 8,  1,   0}, // #2665
  {22,  3,   0}, // #2666
  {23,  5,   0}, // #2667
  { 5,  1,   0}, // #2668
  { 7,  1,   0}, // #2669
  { 8,  1,   0}, // #2670
  {23,  5,   0}, // #2671
  { 1,  3,   0}, // #2672
  { 5,  1,   0}, // #2673
  { 7,  1,   0}, // #2674
  { 8,  1,   0}, // #2675
  {22,  3,   0}, // #2676
  {23,  2,   0}, // #2677
  { 5,  1,   0}, // #2678
  { 7,  1,   0}, // #2679
  { 8,  1,   0}, // #2680
  {23,  2,   0}, // #2681
  { 1,  3,   0}, // #2682
  { 5,  1,   0}, // #2683
  { 7,  1,   0}, // #2684
  { 8,  1,   0}, // #2685
  {22,  3,   0}, // #2686
  {23,  4,   0}, // #2687
  { 5,  1,   0}, // #2688
  { 7,  1,   0}, // #2689
  { 8,  1,   0}, // #2690
  {23,  4,   0}, // #2691
  { 1,  3,   0}, // #2692
  { 5,  1,   0}, // #2693
  { 7,  1,   0}, // #2694
  { 8,  1,   0}, // #2695
  {22,  3,   0}, // #2696
  {23,  6,   0}, // #2697
  { 5,  1,   0}, // #2698
  { 7,  1,   0}, // #2699
  { 8,  1,   0}, // #2700
  {23,  6,   0}, // #2701
  { 1,  3,   0}, // #2702
  {10,  2,   0}, // #2703
  {14,  1,   0}, // #2704
  {19,  1,   0}, // #2705
  {22,  3,   0}, // #2706
  { 1,  3,   0}, // #2707
  {11,  3,   0}, // #2708
  {14,  1,   0}, // #2709
  {19,  1,   0}, // #2710
  {22,  3,   0}, // #2711
  { 1,  1,   0}, // #2712
  {22,  1,   0}, // #2713
  { 1,  3,   0}, // #2714
  { 5,  2,   0}, // #2715
  { 6,  2,   0}, // #2716
  { 8,  2,   0}, // #2717
  {22,  3,   0}, // #2718
  {11,  2,   0}, // #2719
  {14,  1,   0}, // #2720
  {19,  1,   0}, // #2721
  { 1,  1,   0}, // #2722
  {13,  1,   0}, // #2723
  {14,  1,   0}, // #2724
  {16,  1,   0}, // #2725
  {19,  1,   0}, // #2726
  {24,  1,   0}, // #2727
  {11,  1,   0}, // #2728
  {14,  1,   0}, // #2729
  {19,  1,   0}, // #2730
  { 1,  3,   0}, // #2731
  {11,  4,   0}, // #2732
  {14,  1,   0}, // #2733
  {19,  1,   0}, // #2734
  {22,  3,   0}, // #2735
  { 1,  3,   0}, // #2736
  {11,  2,   0}, // #2737
  {14,  1,   0}, // #2738
  {19,  1,   0}, // #2739
  {22,  3,   0}, // #2740
  { 1,  3,   0}, // #2741
  {12,  4,   0}, // #2742
  {14,  1,   0}, // #2743
  {15,  1,   0}, // #2744
  {19,  1,   0}, // #2745
  {22,  3,   0}, // #2746
  { 1,  3,   0}, // #2747
  {10,  1,   0}, // #2748
  {14,  1,   0}, // #2749
  {16,  1,   0}, // #2750
  {19,  1,   0}, // #2751
  {22,  3,   0}, // #2752
  { 1,  3,   0}, // #2753
  {12,  7,   0}, // #2754
  {14,  1,   0}, // #2755
  {15,  1,   0}, // #2756
  {19,  1,   0}, // #2757
  {22,  3,   0}, // #2758
  { 1, 23,   0}, // #2759
  { 5,  1,   0}, // #2760
  { 6,  1,   0}, // #2761
  { 8,  1,   0}, // #2762
  {10,  1,   0}, // #2763
  {11, 10,   0}, // #2764
  {14,  1,   0}, // #2765
  {16,  1,   0}, // #2766
  {19,  1,   0}, // #2767
  {22, 13,   0}, // #2768
  {24, 10,   0}, // #2769
  { 1, 20,   0}, // #2770
  { 5,  1,   0}, // #2771
  { 6,  1,   0}, // #2772
  { 8,  1,   0}, // #2773
  {10,  1,   0}, // #2774
  {11, 10,   0}, // #2775
  {14,  1,   0}, // #2776
  {16,  1,   0}, // #2777
  {19,  1,   0}, // #2778
  {22, 10,   0}, // #2779
  {24, 10,   0}, // #2780
  { 1,  3,   0}, // #2781
  { 5,  1,   0}, // #2782
  { 6,  1,   0}, // #2783
  { 8,  1,   0}, // #2784
  {10,  6,   0}, // #2785
  {14,  1,   0}, // #2786
  {16,  1,   0}, // #2787
  {19,  1,   0}, // #2788
  {22,  3,   0}, // #2789
  { 1,  3,   0}, // #2790
  { 5,  1,   0}, // #2791
  { 6,  1,   0}, // #2792
  { 8,  1,   0}, // #2793
  {10,  8,   0}, // #2794
  {14,  1,   0}, // #2795
  {16,  1,   0}, // #2796
  {19,  1,   0}, // #2797
  {22,  3,   0}, // #2798
  { 1,  3,   0}, // #2799
  {11,  1,   0}, // #2800
  {14,  1,   0}, // #2801
  {15,  1,   0}, // #2802
  {19,  1,   0}, // #2803
  {22,  3,   0}, // #2804
  { 1,  3,   0}, // #2805
  {11,  1,   0}, // #2806
  {12,  2,   0}, // #2807
  {14,  3,   0}, // #2808
  {15,  2,   0}, // #2809
  {19,  3,   0}, // #2810
  {22,  3,   0}, // #2811
  { 1,  3,   0}, // #2812
  {22,  2,   0}, // #2813
  {24,  1,   0}, // #2814
  { 1,  4,   0}, // #2815
  { 5,  1,   0}, // #2816
  { 8,  1,   0}, // #2817
  {22,  3,   0}, // #2818
  {24,  1,   0}, // #2819
  { 1,  3,   0}, // #2820
  {13,  1,   0}, // #2821
  {14,  1,   0}, // #2822
  {16,  1,   0}, // #2823
  {19,  1,   0}, // #2824
  {22,  3,   0}, // #2825
  { 1,  3,   0}, // #2826
  {10,  2,   0}, // #2827
  {14,  1,   0}, // #2828
  {16,  1,   0}, // #2829
  {19,  1,   0}, // #2830
  {22,  3,   0}, // #2831
  { 1,  1,   0}, // #2832
  { 5,  1,   0}, // #2833
  { 8,  1,   0}, // #2834
  {24,  1,   0}, // #2835
  { 1,  1,   0}, // #2836
  { 5, 22,   0}, // #2837
  { 8, 22,   0}, // #2838
  {22,  1,   0}, // #2839
  {10, 18,   0}, // #2840
  {14,  1,   0}, // #2841
  {16,  1,   0}, // #2842
  {19,  1,   0}, // #2843
  { 1, 18,   0}, // #2844
  {24, 18,   0}, // #2845
  { 1,  3,   0}, // #2846
  {10,  3,   0}, // #2847
  {14,  1,   0}, // #2848
  {22,  3,   0}, // #2849
  { 1,  3,   0}, // #2850
  {10,  2,   0}, // #2851
  {14,  1,   0}, // #2852
  {15,  1,   0}, // #2853
  {19,  1,   0}, // #2854
  {22,  3,   0}, // #2855
  { 1,  3,   0}, // #2856
  {14,  2,   0}, // #2857
  {16,  2,   0}, // #2858
  {19,  2,   0}, // #2859
  {21,  2,   0}, // #2860
  {22,  3,   0}, // #2861
  { 1,  3,   0}, // #2862
  {11,  2,   0}, // #2863
  {14,  2,   0}, // #2864
  {20,  2,   0}, // #2865
  {22,  3,   0}, // #2866
  { 1,  3,   0}, // #2867
  {11,  1,   0}, // #2868
  {14,  1,   0}, // #2869
  {19,  1,   0}, // #2870
  {22,  3,   0}, // #2871
  { 1,  3,   0}, // #2872
  { 9,  2,   0}, // #2873
  {10,  1,   0}, // #2874
  {13,  1,   0}, // #2875
  {14,  1,   0}, // #2876
  {15,  1,   0}, // #2877
  {19,  1,   0}, // #2878
  {22,  3,   0}, // #2879
  { 1,  1,   0}, // #2880
  { 9,  2,   0}, // #2881
  {10,  1,   0}, // #2882
  {13,  1,   0}, // #2883
  {14,  1,   0}, // #2884
  {15,  1,   0}, // #2885
  {19,  1,   0}, // #2886
  {24,  1,   0}, // #2887
  { 1,  1,   0}, // #2888
  { 9,  2,   0}, // #2889
  {13,  1,   0}, // #2890
  {14,  1,   0}, // #2891
  {15,  1,   0}, // #2892
  {19,  1,   0}, // #2893
  {24,  1,   0}, // #2894
  { 1,  3,   0}, // #2895
  {10, 18,   0}, // #2896
  {14,  2,   0}, // #2897
  {16,  2,   0}, // #2898
  {19,  2,   0}, // #2899
  {22,  3,   0}, // #2900
  { 1,  3,   0}, // #2901
  {10, 25,   0}, // #2902
  {14,  2,   0}, // #2903
  {16,  2,   0}, // #2904
  {19,  2,   0}, // #2905
  {22,  3,   0}, // #2906
  { 1,  3,   0}, // #2907
  {13,  1,   0}, // #2908
  {14,  2,   0}, // #2909
  {16,  2,   0}, // #2910
  {19,  2,   0}, // #2911
  {22,  3,   0}, // #2912
  { 1,  3,   0}, // #2913
  {10,  8,   0}, // #2914
  {14,  1,   0}, // #2915
  {15,  1,   0}, // #2916
  {19,  1,   0}, // #2917
  {22,  3,   0}, // #2918
  { 1,  3,   0}, // #2919
  {11,  3,   0}, // #2920
  {14,  2,   0}, // #2921
  {19,  2,   0}, // #2922
  {22,  3,   0}, // #2923
  { 1,  2,   0}, // #2924
  {10, 376,   0}, // #2925
  {14,  2,   0}, // #2926
  {19,  2,   0}, // #2927
  {24,  2,   0}, // #2928
  { 1,  3,   0}, // #2929
  {10,  4,   0}, // #2930
  {14,  2,   0}, // #2931
  {19,  2,   0}, // #2932
  {22,  3,   0}, // #2933
  { 1,  1,   0}, // #2934
  {10, 188,   0}, // #2935
  {14,  1,   0}, // #2936
  {19,  1,   0}, // #2937
  {24,  1,   0}, // #2938
  { 1,  3,   0}, // #2939
  {10,  4,   0}, // #2940
  {14,  1,   0}, // #2941
  {19,  1,   0}, // #2942
  {22,  3,   0}, // #2943
  {10,  2,   0}, // #2944
  {14,  2,   0}, // #2945
  {19,  2,   0}, // #2946
  { 1,  2,   0}, // #2947
  {13,  2,   0}, // #2948
  {14, 36,   0}, // #2949
  {20, 36,   0}, // #2950
  {24,  2,   0}, // #2951
  {11,  2,   0}, // #2952
  {14,  2,   0}, // #2953
  {19,  2,   0}, // #2954
  { 1,  3,   0}, // #2955
  {11,  4,   0}, // #2956
  {14,  2,   0}, // #2957
  {19,  2,   0}, // #2958
  {22,  3,   0}, // #2959
  { 1,  2,   0}, // #2960
  {13,  2,   0}, // #2961
  {14,  2,   0}, // #2962
  {16,  2,   0}, // #2963
  {19,  2,   0}, // #2964
  {24,  2,   0}, // #2965
  { 1,  3,   0}, // #2966
  { 5,  1,   0}, // #2967
  { 6,  1,   0}, // #2968
  { 8,  1,   0}, // #2969
  {10,  4,   0}, // #2970
  {14,  2,   0}, // #2971
  {19,  2,   0}, // #2972
  {22,  3,   0}, // #2973
  { 1,  3,   0}, // #2974
  {10,  1,   0}, // #2975
  {14,  2,   0}, // #2976
  {16,  2,   0}, // #2977
  {19,  2,   0}, // #2978
  {22,  3,   0}, // #2979
  { 1,  3,   0}, // #2980
  {10,  2,   0}, // #2981
  {14,  2,   0}, // #2982
  {16,  2,   0}, // #2983
  {19,  2,   0}, // #2984
  {22,  3,   0}, // #2985
  { 1,  3,   0}, // #2986
  { 5,  1,   0}, // #2987
  { 6,  1,   0}, // #2988
  { 8,  1,   0}, // #2989
  {10,  4,   0}, // #2990
  {14,  4,   0}, // #2991
  {19,  4,   0}, // #2992
  {22,  3,   0}, // #2993
  { 9,  3,   0}, // #2994
  {13,  1,   0}, // #2995
  {14,  1,   0}, // #2996
  {15,  1,   0}, // #2997
  {19,  1,   0}, // #2998
  { 5, 23,   0}, // #2999
  { 7, 23,   0}, // #3000
  { 8, 23,   0}, // #3001
  { 5, 21,   0}, // #3002
  { 7, 21,   0}, // #3003
  { 8, 21,   0}, // #3004
  { 5, 26,   0}, // #3005
  { 7, 26,   0}, // #3006
  { 8, 26,   0}, // #3007
  { 5, 69,   0}, // #3008
  { 7, 69,   0}, // #3009
  { 8, 69,   0}, // #3010
  { 5, 14,   0}, // #3011
  { 8, 14,   0}, // #3012
  { 5, 25,   0}, // #3013
  { 8, 25,   0}, // #3014
  { 1,  1,   0}, // #3015
  {10,  4,   0}, // #3016
  {14,  2,   0}, // #3017
  {19,  2,   0}, // #3018
  {22,  1,   0}, // #3019
  { 5, 20,   0}, // #3020
  { 7, 20,   0}, // #3021
  { 8, 20,   0}, // #3022
  { 1,  3,   0}, // #3023
  {10, 10,   0}, // #3024
  {14,  1,   0}, // #3025
  {15,  1,   0}, // #3026
  {19,  1,   0}, // #3027
  {22,  3,   0}, // #3028
  { 1,  3,   0}, // #3029
  {10, 18,   0}, // #3030
  {14,  1,   0}, // #3031
  {15,  1,   0}, // #3032
  {19,  1,   0}, // #3033
  {22,  3,   0}, // #3034
  { 5, 375,   0}, // #3035
  { 8, 375,   0}, // #3036
  { 5, 24,   0}, // #3037
  { 8, 24,   0}, // #3038
  {10,  6,   0}, // #3039
  {14,  1,   0}, // #3040
  {19,  1,   0}, // #3041
  {10,  8,   0}, // #3042
  {14,  1,   0}, // #3043
  {19,  1,   0}, // #3044
  { 5,  3,   0}, // #3045
  { 8,  3,   0}, // #3046
  { 5, 18,   0}, // #3047
  { 8, 18,   0}, // #3048
  { 5, 88,   0}, // #3049
  { 8, 88,   0}, // #3050
  { 1,  3,   0}, // #3051
  { 5,  3,   0}, // #3052
  { 8,  3,   0}, // #3053
  {22,  3,   0}, // #3054
  { 5, 10,   0}, // #3055
  { 8, 10,   0}, // #3056
  { 5, 12,   0}, // #3057
  { 8, 12,   0}, // #3058
  { 5, 17,   0}, // #3059
  { 8, 17,   0}, // #3060
  { 5,  5,   0}, // #3061
  { 8,  5,   0}, // #3062
  { 5, 23,   0}, // #3063
  { 8, 23,   0}, // #3064
  { 5, 20,   0}, // #3065
  { 8, 20,   0}, // #3066
  { 5, 19,   0}, // #3067
  { 8, 19,   0}, // #3068
  { 5, 13,   0}, // #3069
  { 8, 13,   0}, // #3070
  { 5, 21,   0}, // #3071
  { 8, 21,   0}, // #3072
  { 5, 15,   0}, // #3073
  { 8, 15,   0}, // #3074
  {13,  1,   0}, // #3075
  {14, 10,   0}, // #3076
  {16, 10,   0}, // #3077
  {19, 10,   0}, // #3078
  {13,  1,   0}, // #3079
  {14,  3,   0}, // #3080
  {16,  3,   0}, // #3081
  {19,  3,   0}, // #3082
  {13,  1,   0}, // #3083
  {14,  4,   0}, // #3084
  {16,  4,   0}, // #3085
  {19,  4,   0}, // #3086
  {11,  1,   0}, // #3087
  {12,  1,   0}, // #3088
  {14,  1,   0}, // #3089
  {15,  1,   0}, // #3090
  {19,  1,   0}, // #3091
  {22,  1,   0}, // #3092
  {23,  1,   0}, // #3093
  {14,  1,   0}, // #3094
  {20,  1,   0}, // #3095
  {22,  1,   0}, // #3096
  {23,  1,   0}, // #3097
  { 7,  1,   0}, // #3098
  {12,  1,   0}, // #3099
  {14,  2,   0}, // #3100
  {17,  1,   0}, // #3101
  {20,  2,   0}, // #3102
  {21,  2,   0}, // #3103
  {22,  3,   0}, // #3104
  {23,  6,   0}, // #3105
  {14,  1,   0}, // #3106
  {17,  1,   0}, // #3107
  {20,  1,   0}, // #3108
  {21,  1,   0}, // #3109
  {22,  1,   0}, // #3110
  {23,  2,   0}, // #3111
  { 7,  1,   0}, // #3112
  {12,  1,   0}, // #3113
  {21,  1,   0}, // #3114
  {23,  2,   0}, // #3115
  { 4,  1,   0}, // #3116
  {11,  1,   0}, // #3117
  {15,  1,   0}, // #3118
  {16,  1,   0}, // #3119
  {19,  1,   0}, // #3120
  {22,  1,   0}, // #3121
  {23,  1,   0}, // #3122
  {17,  1,   0}, // #3123
  {21,  1,   0}, // #3124
  {23,  1,   0}, // #3125
  { 7,  1,   0}, // #3126
  {12,  1,   0}, // #3127
  {17,  1,   0}, // #3128
  {21,  2,   0}, // #3129
  {22,  1,   0}, // #3130
  {23,  4,   0}, // #3131
  { 8,  1,   0}, // #3132
  {13,  1,   0}, // #3133
  {15,  1,   0}, // #3134
  {18,  1,   0}, // #3135
  {19,  1,   0}, // #3136
  {20,  1,   0}, // #3137
  {22,  1,   0}, // #3138
  {23,  1,   0}, // #3139
  {17,  1,   0}, // #3140
  {21,  1,   0}, // #3141
  {22,  1,   0}, // #3142
  {23,  2,   0}, // #3143
  { 4,  1,   0}, // #3144
  {11,  1,   0}, // #3145
  {15,  1,   0}, // #3146
  {16,  1,   0}, // #3147
  {17,  1,   0}, // #3148
  {19,  1,   0}, // #3149
  {21,  1,   0}, // #3150
  {22,  1,   0}, // #3151
  {23,  2,   0}, // #3152
  { 8,  1,   0}, // #3153
  {13,  1,   0}, // #3154
  {15,  1,   0}, // #3155
  {17,  1,   0}, // #3156
  {18,  1,   0}, // #3157
  {19,  1,   0}, // #3158
  {20,  1,   0}, // #3159
  {21,  1,   0}, // #3160
  {22,  1,   0}, // #3161
  {23,  2,   0}, // #3162
  { 8,  2,   0}, // #3163
  {13,  2,   0}, // #3164
  {15,  2,   0}, // #3165
  {17,  1,   0}, // #3166
  {18,  2,   0}, // #3167
  {19,  2,   0}, // #3168
  {20,  2,   0}, // #3169
  {21,  1,   0}, // #3170
  {22,  2,   0}, // #3171
  {23,  3,   0}, // #3172
  { 8,  2,   0}, // #3173
  {13,  2,   0}, // #3174
  {15,  2,   0}, // #3175
  {18,  2,   0}, // #3176
  {19,  2,   0}, // #3177
  {20,  2,   0}, // #3178
  {22,  2,   0}, // #3179
  {23,  2,   0}, // #3180
  { 3,  2,   0}, // #3181
  { 8,  7,   0}, // #3182
  {11,  2,   0}, // #3183
  {12,  2,   0}, // #3184
  {13,  9,   0}, // #3185
  {14,  2,   0}, // #3186
  {15,  7,   0}, // #3187
  {17,  1,   0}, // #3188
  {18,  7,   0}, // #3189
  {19, 10,   0}, // #3190
  {20,  9,   0}, // #3191
  {21,  1,   0}, // #3192
  {22, 10,   0}, // #3193
  {23, 11,   0}, // #3194
  { 3,  2,   0}, // #3195
  { 8,  7,   0}, // #3196
  {11,  2,   0}, // #3197
  {12,  2,   0}, // #3198
  {13,  9,   0}, // #3199
  {14,  2,   0}, // #3200
  {15,  7,   0}, // #3201
  {18,  7,   0}, // #3202
  {19, 11,   0}, // #3203
  {20,  9,   0}, // #3204
  {22, 11,   0}, // #3205
  {23, 11,   0}, // #3206
  {14,  1,   0}, // #3207
  {15,  1,   0}, // #3208
  {17,  1,   0}, // #3209
  {19,  1,   0}, // #3210
  {20,  1,   0}, // #3211
  {21,  1,   0}, // #3212
  {22,  2,   0}, // #3213
  {23,  3,   0}, // #3214
  {14,  1,   0}, // #3215
  {15,  1,   0}, // #3216
  {19,  1,   0}, // #3217
  {20,  1,   0}, // #3218
  {22,  2,   0}, // #3219
  {23,  2,   0}, // #3220
  {15,  1,   0}, // #3221
  {17,  1,   0}, // #3222
  {19,  1,   0}, // #3223
  {21,  1,   0}, // #3224
  {22,  1,   0}, // #3225
  {23,  2,   0}, // #3226
  { 7,  1,   0}, // #3227
  {12,  1,   0}, // #3228
  {14,  1,   0}, // #3229
  {17,  1,   0}, // #3230
  {20,  1,   0}, // #3231
  {21,  2,   0}, // #3232
  {22,  1,   0}, // #3233
  {23,  4,   0}, // #3234
  {22,  3,   0}, // #3235
  {23,  3,   0}, // #3236
  {14,  2,   0}, // #3237
  {20,  2,   0}, // #3238
  {22,  5,   0}, // #3239
  {23,  5,   0}, // #3240
  { 4,  1,   0}, // #3241
  { 8,  1,   0}, // #3242
  {11,  1,   0}, // #3243
  {13,  1,   0}, // #3244
  {15,  2,   0}, // #3245
  {16,  1,   0}, // #3246
  {17,  1,   0}, // #3247
  {18,  1,   0}, // #3248
  {19,  2,   0}, // #3249
  {20,  1,   0}, // #3250
  {21,  1,   0}, // #3251
  {22,  2,   0}, // #3252
  {23,  3,   0}, // #3253
  { 4,  1,   0}, // #3254
  { 8,  1,   0}, // #3255
  {11,  1,   0}, // #3256
  {13,  1,   0}, // #3257
  {15,  2,   0}, // #3258
  {16,  1,   0}, // #3259
  {18,  1,   0}, // #3260
  {19,  2,   0}, // #3261
  {20,  1,   0}, // #3262
  {22,  2,   0}, // #3263
  {23,  2,   0}, // #3264
  { 3,  1,   0}, // #3265
  {11,  1,   0}, // #3266
  {12,  1,   0}, // #3267
  {13,  1,   0}, // #3268
  {14,  1,   0}, // #3269
  {17,  1,   0}, // #3270
  {19,  1,   0}, // #3271
  {20,  1,   0}, // #3272
  {21,  1,   0}, // #3273
  {22,  1,   0}, // #3274
  {23,  2,   0}, // #3275
  { 3,  1,   0}, // #3276
  { 8,  1,   0}, // #3277
  {11,  1,   0}, // #3278
  {12,  1,   0}, // #3279
  {13,  2,   0}, // #3280
  {14,  1,   0}, // #3281
  {15,  1,   0}, // #3282
  {18,  1,   0}, // #3283
  {19,  2,   0}, // #3284
  {20,  2,   0}, // #3285
  {22,  2,   0}, // #3286
  {23,  2,   0}, // #3287
  { 3,  1,   0}, // #3288
  { 4,  1,   0}, // #3289
  {11,  2,   0}, // #3290
  {12,  1,   0}, // #3291
  {13,  1,   0}, // #3292
  {14,  1,   0}, // #3293
  {15,  1,   0}, // #3294
  {16,  1,   0}, // #3295
  {17,  1,   0}, // #3296
  {19,  2,   0}, // #3297
  {20,  1,   0}, // #3298
  {21,  1,   0}, // #3299
  {22,  2,   0}, // #3300
  {23,  3,   0}, // #3301
  { 3,  1,   0}, // #3302
  { 4,  1,   0}, // #3303
  {11,  2,   0}, // #3304
  {12,  1,   0}, // #3305
  {13,  1,   0}, // #3306
  {14,  1,   0}, // #3307
  {15,  1,   0}, // #3308
  {16,  1,   0}, // #3309
  {19,  2,   0}, // #3310
  {20,  1,   0}, // #3311
  {22,  2,   0}, // #3312
  {23,  2,   0}, // #3313
  { 3,  2,   0}, // #3314
  { 4,  2,   0}, // #3315
  { 8,  2,   0}, // #3316
  {11,  4,   0}, // #3317
  {12,  2,   0}, // #3318
  {13,  4,   0}, // #3319
  {14,  2,   0}, // #3320
  {15,  4,   0}, // #3321
  {16,  2,   0}, // #3322
  {17,  1,   0}, // #3323
  {18,  2,   0}, // #3324
  {19,  6,   0}, // #3325
  {20,  4,   0}, // #3326
  {21,  1,   0}, // #3327
  {22,  7,   0}, // #3328
  {23,  8,   0}, // #3329
  { 3,  7,   0}, // #3330
  { 4,  7,   0}, // #3331
  { 8,  3,   0}, // #3332
  { 9,  3,   0}, // #3333
  {11, 15,   0}, // #3334
  {12,  7,   0}, // #3335
  {13, 10,   0}, // #3336
  {14, 10,   0}, // #3337
  {15, 10,   0}, // #3338
  {16, 10,   0}, // #3339
  {18,  6,   0}, // #3340
  {19, 18,   0}, // #3341
  {20, 13,   0}, // #3342
  {22, 32,   0}, // #3343
  {23, 32,   0}, // #3344
  { 1, 10,   0}, // #3345
  { 3,  1,   0}, // #3346
  {11,  1,   0}, // #3347
  {12,  1,   0}, // #3348
  {13,  1,   0}, // #3349
  {14,  1,   0}, // #3350
  {19,  1,   0}, // #3351
  {20,  1,   0}, // #3352
  {22,  1,   0}, // #3353
  {23,  1,   0}, // #3354
  { 2,  8,   0}, // #3355
  { 3,  1,   0}, // #3356
  {11,  1,   0}, // #3357
  {12,  1,   0}, // #3358
  {13,  1,   0}, // #3359
  {14,  1,   0}, // #3360
  {17,  1,   0}, // #3361
  {19,  1,   0}, // #3362
  {20,  1,   0}, // #3363
  {21,  1,   0}, // #3364
  {22,  1,   0}, // #3365
  {23,  2,   0}, // #3366
  { 2,  8,   0}, // #3367
  { 3,  1,   0}, // #3368
  {11,  1,   0}, // #3369
  {12,  1,   0}, // #3370
  {13,  1,   0}, // #3371
  {14,  1,   0}, // #3372
  {19,  1,   0}, // #3373
  {20,  1,   0}, // #3374
  {22,  1,   0}, // #3375
  {23,  1,   0}, // #3376
  { 2,  5,   0}, // #3377
  { 3,  1,   0}, // #3378
  {11,  1,   0}, // #3379
  {12,  1,   0}, // #3380
  {13,  1,   0}, // #3381
  {14,  1,   0}, // #3382
  {17,  1,   0}, // #3383
  {19,  1,   0}, // #3384
  {20,  1,   0}, // #3385
  {21,  1,   0}, // #3386
  {22,  1,   0}, // #3387
  {23,  2,   0}, // #3388
  { 2,  5,   0}, // #3389
  { 3,  1,   0}, // #3390
  {11,  1,   0}, // #3391
  {12,  1,   0}, // #3392
  {13,  1,   0}, // #3393
  {14,  1,   0}, // #3394
  {19,  1,   0}, // #3395
  {20,  1,   0}, // #3396
  {22,  1,   0}, // #3397
  {23,  1,   0}, // #3398
  { 2,  3,   0}, // #3399
  { 3,  1,   0}, // #3400
  {11,  1,   0}, // #3401
  {12,  1,   0}, // #3402
  {13,  1,   0}, // #3403
  {14,  1,   0}, // #3404
  {19,  1,   0}, // #3405
  {20,  1,   0}, // #3406
  {22,  1,   0}, // #3407
  {23,  1,   0}, // #3408
  { 2,  4,   0}, // #3409
  { 3,  1,   0}, // #3410
  {11,  1,   0}, // #3411
  {12,  1,   0}, // #3412
  {13,  1,   0}, // #3413
  {14,  1,   0}, // #3414
  {19,  1,   0}, // #3415
  {20,  1,   0}, // #3416
  {22,  1,   0}, // #3417
  {23,  1,   0}, // #3418
  { 3,  1,   0}, // #3419
  { 4,  1,   0}, // #3420
  { 8,  1,   0}, // #3421
  {11,  2,   0}, // #3422
  {12,  1,   0}, // #3423
  {13,  2,   0}, // #3424
  {14,  1,   0}, // #3425
  {15,  2,   0}, // #3426
  {16,  1,   0}, // #3427
  {17,  1,   0}, // #3428
  {18,  1,   0}, // #3429
  {19,  3,   0}, // #3430
  {20,  2,   0}, // #3431
  {21,  1,   0}, // #3432
  {22,  3,   0}, // #3433
  {23,  4,   0}, // #3434
  { 3,  1,   0}, // #3435
  { 4,  1,   0}, // #3436
  { 8,  1,   0}, // #3437
  {11,  2,   0}, // #3438
  {12,  1,   0}, // #3439
  {13,  2,   0}, // #3440
  {14,  1,   0}, // #3441
  {15,  2,   0}, // #3442
  {16,  1,   0}, // #3443
  {18,  1,   0}, // #3444
  {19,  3,   0}, // #3445
  {20,  2,   0}, // #3446
  {22,  3,   0}, // #3447
  {23,  3,   0}, // #3448
  { 3,  2,   0}, // #3449
  { 4,  1,   0}, // #3450
  { 8,  1,   0}, // #3451
  {11,  3,   0}, // #3452
  {12,  2,   0}, // #3453
  {13,  3,   0}, // #3454
  {14,  2,   0}, // #3455
  {15,  2,   0}, // #3456
  {16,  1,   0}, // #3457
  {17,  1,   0}, // #3458
  {18,  1,   0}, // #3459
  {19,  4,   0}, // #3460
  {20,  3,   0}, // #3461
  {21,  1,   0}, // #3462
  {22,  4,   0}, // #3463
  {23,  5,   0}, // #3464
  { 3,  2,   0}, // #3465
  { 4,  1,   0}, // #3466
  { 8,  1,   0}, // #3467
  {11,  3,   0}, // #3468
  {12,  2,   0}, // #3469
  {13,  3,   0}, // #3470
  {14,  2,   0}, // #3471
  {15,  2,   0}, // #3472
  {16,  1,   0}, // #3473
  {18,  1,   0}, // #3474
  {19,  4,   0}, // #3475
  {20,  3,   0}, // #3476
  {22,  4,   0}, // #3477
  {23,  4,   0}, // #3478
  { 7,  1,   0}, // #3479
  { 8,  1,   0}, // #3480
  {12,  1,   0}, // #3481
  {13,  1,   0}, // #3482
  {15,  1,   0}, // #3483
  {18,  1,   0}, // #3484
  {19,  1,   0}, // #3485
  {20,  1,   0}, // #3486
  {21,  1,   0}, // #3487
  {22,  1,   0}, // #3488
  {23,  3,   0}, // #3489
  {11,  8,   0}, // #3490
  {15,  1,   0}, // #3491
  {19, 30,   0}, // #3492
  {22, 31,   0}, // #3493
  {23, 31,   0}, // #3494
  {11,  2,   0}, // #3495
  {19,  2,   0}, // #3496
  {22,  2,   0}, // #3497
  {23,  2,   0}, // #3498
  { 4,  1,   0}, // #3499
  { 8,  2,   0}, // #3500
  {11,  1,   0}, // #3501
  {13,  2,   0}, // #3502
  {15,  3,   0}, // #3503
  {16,  1,   0}, // #3504
  {17,  1,   0}, // #3505
  {18,  2,   0}, // #3506
  {19,  3,   0}, // #3507
  {20,  2,   0}, // #3508
  {21,  1,   0}, // #3509
  {22,  3,   0}, // #3510
  {23,  4,   0}, // #3511
  { 4,  1,   0}, // #3512
  { 8,  2,   0}, // #3513
  {11,  1,   0}, // #3514
  {13,  2,   0}, // #3515
  {15,  3,   0}, // #3516
  {16,  1,   0}, // #3517
  {18,  2,   0}, // #3518
  {19,  3,   0}, // #3519
  {20,  2,   0}, // #3520
  {22,  3,   0}, // #3521
  {23,  3,   0}, // #3522
  { 4,  1,   0}, // #3523
  {11,  1,   0}, // #3524
  {14,  1,   0}, // #3525
  {15,  1,   0}, // #3526
  {16,  1,   0}, // #3527
  {17,  1,   0}, // #3528
  {19,  1,   0}, // #3529
  {20,  1,   0}, // #3530
  {21,  1,   0}, // #3531
  {22,  4,   0}, // #3532
  {23,  5,   0}, // #3533
  { 4,  1,   0}, // #3534
  {11,  1,   0}, // #3535
  {14,  1,   0}, // #3536
  {15,  1,   0}, // #3537
  {16,  1,   0}, // #3538
  {19,  1,   0}, // #3539
  {20,  1,   0}, // #3540
  {22,  4,   0}, // #3541
  {23,  4,   0}, // #3542
  { 4,  1,   0}, // #3543
  {11,  1,   0}, // #3544
  {15,  1,   0}, // #3545
  {16,  1,   0}, // #3546
  {17,  1,   0}, // #3547
  {19,  1,   0}, // #3548
  {21,  1,   0}, // #3549
  {22,  2,   0}, // #3550
  {23,  3,   0}, // #3551
  { 4,  1,   0}, // #3552
  {11,  1,   0}, // #3553
  {15,  1,   0}, // #3554
  {16,  1,   0}, // #3555
  {19,  1,   0}, // #3556
  {22,  2,   0}, // #3557
  {23,  2,   0}, // #3558
  { 4,  1,   0}, // #3559
  {11,  1,   0}, // #3560
  {14,  1,   0}, // #3561
  {15,  1,   0}, // #3562
  {16,  1,   0}, // #3563
  {17,  1,   0}, // #3564
  {19,  1,   0}, // #3565
  {20,  1,   0}, // #3566
  {21,  1,   0}, // #3567
  {22,  3,   0}, // #3568
  {23,  4,   0}, // #3569
  { 4,  1,   0}, // #3570
  {11,  1,   0}, // #3571
  {14,  1,   0}, // #3572
  {15,  1,   0}, // #3573
  {16,  1,   0}, // #3574
  {19,  1,   0}, // #3575
  {20,  1,   0}, // #3576
  {22,  3,   0}, // #3577
  {23,  3,   0}, // #3578
  { 3,  1,   0}, // #3579
  {11,  1,   0}, // #3580
  {12,  1,   0}, // #3581
  {13,  1,   0}, // #3582
  {14,  1,   0}, // #3583
  {17,  1,   0}, // #3584
  {19,  1,   0}, // #3585
  {20,  1,   0}, // #3586
  {21,  1,   0}, // #3587
  {22,  2,   0}, // #3588
  {23,  3,   0}, // #3589
  {11,  1,   0}, // #3590
  {19,  1,   0}, // #3591
  {22,  1,   0}, // #3592
  {23,  1,   0}, // #3593
  { 7,  1,   0}, // #3594
  {12,  1,   0}, // #3595
  {17,  1,   0}, // #3596
  {21,  1,   0}, // #3597
  {23,  2,   0}, // #3598
  { 8,  2,   0}, // #3599
  {13,  2,   0}, // #3600
  {15,  3,   0}, // #3601
  {17,  1,   0}, // #3602
  {18,  2,   0}, // #3603
  {19,  3,   0}, // #3604
  {20,  2,   0}, // #3605
  {21,  1,   0}, // #3606
  {22,  3,   0}, // #3607
  {23,  4,   0}, // #3608
  { 8,  2,   0}, // #3609
  {13,  2,   0}, // #3610
  {15,  3,   0}, // #3611
  {18,  2,   0}, // #3612
  {19,  3,   0}, // #3613
  {20,  2,   0}, // #3614
  {22,  3,   0}, // #3615
  {23,  3,   0}, // #3616
  { 3,  1,   0}, // #3617
  { 8,  2,   0}, // #3618
  {11,  1,   0}, // #3619
  {12,  1,   0}, // #3620
  {13,  3,   0}, // #3621
  {14,  1,   0}, // #3622
  {15,  2,   0}, // #3623
  {17,  1,   0}, // #3624
  {18,  2,   0}, // #3625
  {19,  3,   0}, // #3626
  {20,  3,   0}, // #3627
  {21,  1,   0}, // #3628
  {22,  3,   0}, // #3629
  {23,  4,   0}, // #3630
  { 3,  1,   0}, // #3631
  { 8,  2,   0}, // #3632
  {11,  1,   0}, // #3633
  {12,  1,   0}, // #3634
  {13,  3,   0}, // #3635
  {14,  1,   0}, // #3636
  {15,  2,   0}, // #3637
  {18,  2,   0}, // #3638
  {19,  3,   0}, // #3639
  {20,  3,   0}, // #3640
  {22,  3,   0}, // #3641
  {23,  3,   0}, // #3642
  {11,  1,   0}, // #3643
  {17,  1,   0}, // #3644
  {19,  1,   0}, // #3645
  {21,  1,   0}, // #3646
  {22,  1,   0}, // #3647
  {23,  2,   0}, // #3648
  { 3,  4,   0}, // #3649
  { 8,  3,   0}, // #3650
  {11,  4,   0}, // #3651
  {12,  4,   0}, // #3652
  {13,  7,   0}, // #3653
  {14,  4,   0}, // #3654
  {15,  3,   0}, // #3655
  {17,  1,   0}, // #3656
  {18,  3,   0}, // #3657
  {19,  7,   0}, // #3658
  {20,  7,   0}, // #3659
  {21,  1,   0}, // #3660
  {22,  8,   0}, // #3661
  {23,  9,   0}, // #3662
  { 3,  4,   0}, // #3663
  { 8,  3,   0}, // #3664
  {11,  4,   0}, // #3665
  {12,  4,   0}, // #3666
  {13,  7,   0}, // #3667
  {14,  4,   0}, // #3668
  {15,  3,   0}, // #3669
  {18,  3,   0}, // #3670
  {19,  7,   0}, // #3671
  {20,  7,   0}, // #3672
  {22,  8,   0}, // #3673
  {23,  8,   0}, // #3674
  { 3,  4,   0}, // #3675
  { 8,  3,   0}, // #3676
  {11,  4,   0}, // #3677
  {12,  4,   0}, // #3678
  {13,  7,   0}, // #3679
  {14,  4,   0}, // #3680
  {15,  3,   0}, // #3681
  {17,  1,   0}, // #3682
  {18,  3,   0}, // #3683
  {19,  8,   0}, // #3684
  {20,  7,   0}, // #3685
  {21,  1,   0}, // #3686
  {22,  9,   0}, // #3687
  {23, 10,   0}, // #3688
  { 3,  4,   0}, // #3689
  { 8,  3,   0}, // #3690
  {11,  4,   0}, // #3691
  {12,  4,   0}, // #3692
  {13,  7,   0}, // #3693
  {14,  4,   0}, // #3694
  {15,  3,   0}, // #3695
  {18,  3,   0}, // #3696
  {19,  8,   0}, // #3697
  {20,  7,   0}, // #3698
  {22,  9,   0}, // #3699
  {23,  9,   0}, // #3700
  { 3,  3,   0}, // #3701
  {11,  3,   0}, // #3702
  {12,  3,   0}, // #3703
  {13,  3,   0}, // #3704
  {14,  3,   0}, // #3705
  {17,  1,   0}, // #3706
  {19,  3,   0}, // #3707
  {20,  3,   0}, // #3708
  {21,  1,   0}, // #3709
  {22,  3,   0}, // #3710
  {23,  4,   0}, // #3711
  { 3,  3,   0}, // #3712
  {11,  3,   0}, // #3713
  {12,  3,   0}, // #3714
  {13,  3,   0}, // #3715
  {14,  3,   0}, // #3716
  {19,  3,   0}, // #3717
  {20,  3,   0}, // #3718
  {22,  3,   0}, // #3719
  {23,  3,   0}, // #3720
  { 3,  2,   0}, // #3721
  {11,  2,   0}, // #3722
  {12,  2,   0}, // #3723
  {13,  2,   0}, // #3724
  {14,  2,   0}, // #3725
  {17,  1,   0}, // #3726
  {19,  2,   0}, // #3727
  {20,  2,   0}, // #3728
  {21,  1,   0}, // #3729
  {22,  2,   0}, // #3730
  {23,  3,   0}, // #3731
  { 3,  2,   0}, // #3732
  {11,  2,   0}, // #3733
  {12,  2,   0}, // #3734
  {13,  2,   0}, // #3735
  {14,  2,   0}, // #3736
  {19,  2,   0}, // #3737
  {20,  2,   0}, // #3738
  {22,  2,   0}, // #3739
  {23,  2,   0}, // #3740
  { 7,  1,   0}, // #3741
  {12,  1,   0}, // #3742
  {17,  1,   0}, // #3743
  {21,  2,   0}, // #3744
  {23,  3,   0}, // #3745
  { 3,  1,   0}, // #3746
  { 8,  1,   0}, // #3747
  {11,  1,   0}, // #3748
  {12,  1,   0}, // #3749
  {13,  2,   0}, // #3750
  {14,  1,   0}, // #3751
  {15,  1,   0}, // #3752
  {17,  1,   0}, // #3753
  {18,  1,   0}, // #3754
  {19,  2,   0}, // #3755
  {20,  2,   0}, // #3756
  {21,  1,   0}, // #3757
  {22,  2,   0}, // #3758
  {23,  3,   0}, // #3759
  {14,  2,   0}, // #3760
  {20,  2,   0}, // #3761
  {22,  3,   0}, // #3762
  {23,  3,   0}, // #3763
  { 4,  2,   0}, // #3764
  {11,  2,   0}, // #3765
  {15,  2,   0}, // #3766
  {16,  2,   0}, // #3767
  {17,  1,   0}, // #3768
  {19,  2,   0}, // #3769
  {21,  1,   0}, // #3770
  {22,  2,   0}, // #3771
  {23,  3,   0}, // #3772
  { 7,  1,   0}, // #3773
  {12,  1,   0}, // #3774
  {14,  1,   0}, // #3775
  {20,  1,   0}, // #3776
  {21,  1,   0}, // #3777
  {22,  1,   0}, // #3778
  {23,  3,   0}, // #3779
  { 4,  1,   0}, // #3780
  {11,  1,   0}, // #3781
  {14,  1,   0}, // #3782
  {15,  1,   0}, // #3783
  {16,  1,   0}, // #3784
  {17,  1,   0}, // #3785
  {19,  1,   0}, // #3786
  {20,  1,   0}, // #3787
  {21,  2,   0}, // #3788
  {22,  4,   0}, // #3789
  {23,  6,   0}, // #3790
  { 4,  1,   0}, // #3791
  {11,  1,   0}, // #3792
  {15,  1,   0}, // #3793
  {16,  1,   0}, // #3794
  {17,  1,   0}, // #3795
  {19,  1,   0}, // #3796
  {21,  2,   0}, // #3797
  {22,  2,   0}, // #3798
  {23,  4,   0}, // #3799
  { 2, 14,   0}, // #3800
  { 3,  1,   0}, // #3801
  {11,  1,   0}, // #3802
  {12,  1,   0}, // #3803
  {13,  1,   0}, // #3804
  {14,  1,   0}, // #3805
  {17,  1,   0}, // #3806
  {19,  1,   0}, // #3807
  {20,  1,   0}, // #3808
  {21,  1,   0}, // #3809
  {22,  1,   0}, // #3810
  {23,  2,   0}, // #3811
  { 2, 14,   0}, // #3812
  { 3,  1,   0}, // #3813
  {11,  1,   0}, // #3814
  {12,  1,   0}, // #3815
  {13,  1,   0}, // #3816
  {14,  1,   0}, // #3817
  {19,  1,   0}, // #3818
  {20,  1,   0}, // #3819
  {22,  1,   0}, // #3820
  {23,  1,   0}, // #3821
  { 2,  7,   0}, // #3822
  { 3,  1,   0}, // #3823
  {11,  1,   0}, // #3824
  {12,  1,   0}, // #3825
  {13,  1,   0}, // #3826
  {14,  1,   0}, // #3827
  {17,  1,   0}, // #3828
  {19,  1,   0}, // #3829
  {20,  1,   0}, // #3830
  {21,  1,   0}, // #3831
  {22,  1,   0}, // #3832
  {23,  2,   0}, // #3833
  { 2,  7,   0}, // #3834
  { 3,  1,   0}, // #3835
  {11,  1,   0}, // #3836
  {12,  1,   0}, // #3837
  {13,  1,   0}, // #3838
  {14,  1,   0}, // #3839
  {19,  1,   0}, // #3840
  {20,  1,   0}, // #3841
  {22,  1,   0}, // #3842
  {23,  1,   0}, // #3843
  { 2,  9,   0}, // #3844
  { 3,  1,   0}, // #3845
  {11,  1,   0}, // #3846
  {12,  1,   0}, // #3847
  {13,  1,   0}, // #3848
  {14,  1,   0}, // #3849
  {19,  1,   0}, // #3850
  {20,  1,   0}, // #3851
  {22,  1,   0}, // #3852
  {23,  1,   0}, // #3853
  { 4,  1,   0}, // #3854
  { 7,  1,   0}, // #3855
  {11,  1,   0}, // #3856
  {12,  1,   0}, // #3857
  {15,  1,   0}, // #3858
  {16,  1,   0}, // #3859
  {19,  1,   0}, // #3860
  {21,  1,   0}, // #3861
  {22,  1,   0}, // #3862
  {23,  3,   0}, // #3863
  { 2, 16,   0}, // #3864
  { 3,  2,   0}, // #3865
  {11,  2,   0}, // #3866
  {12,  2,   0}, // #3867
  {13,  2,   0}, // #3868
  {14,  2,   0}, // #3869
  {17,  1,   0}, // #3870
  {19,  3,   0}, // #3871
  {20,  2,   0}, // #3872
  {21,  1,   0}, // #3873
  {22,  3,   0}, // #3874
  {23,  4,   0}, // #3875
  { 2, 16,   0}, // #3876
  { 3,  2,   0}, // #3877
  {11,  2,   0}, // #3878
  {12,  2,   0}, // #3879
  {13,  2,   0}, // #3880
  {14,  2,   0}, // #3881
  {19,  3,   0}, // #3882
  {20,  2,   0}, // #3883
  {22,  3,   0}, // #3884
  {23,  3,   0}, // #3885
  { 2, 10,   0}, // #3886
  { 3,  2,   0}, // #3887
  {11,  2,   0}, // #3888
  {12,  2,   0}, // #3889
  {13,  2,   0}, // #3890
  {14,  2,   0}, // #3891
  {17,  1,   0}, // #3892
  {19,  3,   0}, // #3893
  {20,  2,   0}, // #3894
  {21,  1,   0}, // #3895
  {22,  3,   0}, // #3896
  {23,  4,   0}, // #3897
  { 2, 10,   0}, // #3898
  { 3,  2,   0}, // #3899
  {11,  2,   0}, // #3900
  {12,  2,   0}, // #3901
  {13,  2,   0}, // #3902
  {14,  2,   0}, // #3903
  {19,  3,   0}, // #3904
  {20,  2,   0}, // #3905
  {22,  3,   0}, // #3906
  {23,  3,   0}, // #3907
  { 3,  1,   0}, // #3908
  { 7,  1,   0}, // #3909
  {11,  1,   0}, // #3910
  {12,  2,   0}, // #3911
  {13,  1,   0}, // #3912
  {14,  1,   0}, // #3913
  {15,  1,   0}, // #3914
  {19,  2,   0}, // #3915
  {20,  1,   0}, // #3916
  {21,  1,   0}, // #3917
  {22,  2,   0}, // #3918
  {23,  4,   0}, // #3919
  { 3,  2,   0}, // #3920
  { 8,  1,   0}, // #3921
  {11,  2,   0}, // #3922
  {12,  2,   0}, // #3923
  {13,  3,   0}, // #3924
  {14,  2,   0}, // #3925
  {15,  1,   0}, // #3926
  {17,  1,   0}, // #3927
  {18,  1,   0}, // #3928
  {19,  3,   0}, // #3929
  {20,  3,   0}, // #3930
  {21,  1,   0}, // #3931
  {22,  3,   0}, // #3932
  {23,  4,   0}, // #3933
  { 3,  2,   0}, // #3934
  { 8,  1,   0}, // #3935
  {11,  2,   0}, // #3936
  {12,  2,   0}, // #3937
  {13,  3,   0}, // #3938
  {14,  2,   0}, // #3939
  {15,  1,   0}, // #3940
  {18,  1,   0}, // #3941
  {19,  3,   0}, // #3942
  {20,  3,   0}, // #3943
  {22,  3,   0}, // #3944
  {23,  3,   0}, // #3945
  { 2, 28,   0}, // #3946
  { 3,  2,   0}, // #3947
  {11,  2,   0}, // #3948
  {12,  2,   0}, // #3949
  {13,  2,   0}, // #3950
  {14,  2,   0}, // #3951
  {17,  1,   0}, // #3952
  {19,  3,   0}, // #3953
  {20,  2,   0}, // #3954
  {21,  1,   0}, // #3955
  {22,  3,   0}, // #3956
  {23,  4,   0}, // #3957
  { 2, 28,   0}, // #3958
  { 3,  2,   0}, // #3959
  {11,  2,   0}, // #3960
  {12,  2,   0}, // #3961
  {13,  2,   0}, // #3962
  {14,  2,   0}, // #3963
  {19,  3,   0}, // #3964
  {20,  2,   0}, // #3965
  {22,  3,   0}, // #3966
  {23,  3,   0}, // #3967
  { 2, 14,   0}, // #3968
  { 3,  2,   0}, // #3969
  {11,  2,   0}, // #3970
  {12,  2,   0}, // #3971
  {13,  2,   0}, // #3972
  {14,  2,   0}, // #3973
  {17,  1,   0}, // #3974
  {19,  3,   0}, // #3975
  {20,  2,   0}, // #3976
  {21,  1,   0}, // #3977
  {22,  3,   0}, // #3978
  {23,  4,   0}, // #3979
  { 2, 14,   0}, // #3980
  { 3,  2,   0}, // #3981
  {11,  2,   0}, // #3982
  {12,  2,   0}, // #3983
  {13,  2,   0}, // #3984
  {14,  2,   0}, // #3985
  {19,  3,   0}, // #3986
  {20,  2,   0}, // #3987
  {22,  3,   0}, // #3988
  {23,  3,   0}, // #3989
  {14,  1,   0}, // #3990
  {17,  1,   0}, // #3991
  {20,  1,   0}, // #3992
  {21,  2,   0}, // #3993
  {22,  3,   0}, // #3994
  {23,  5,   0}, // #3995
  { 4,  2,   0}, // #3996
  {11,  2,   0}, // #3997
  {14,  3,   0}, // #3998
  {15,  3,   0}, // #3999
  {16,  2,   0}, // #4000
  {17,  1,   0}, // #4001
  {19,  3,   0}, // #4002
  {20,  3,   0}, // #4003
  {21,  2,   0}, // #4004
  {22,  9,   0}, // #4005
  {23, 11,   0}, // #4006
  { 3,  2,   0}, // #4007
  { 4,  1,   0}, // #4008
  { 9,  4,   0}, // #4009
  {11,  3,   0}, // #4010
  {12,  2,   0}, // #4011
  {13,  2,   0}, // #4012
  {14,  6,   0}, // #4013
  {15,  1,   0}, // #4014
  {16,  5,   0}, // #4015
  {18,  4,   0}, // #4016
  {19,  3,   0}, // #4017
  {20,  6,   0}, // #4018
  {22, 12,   0}, // #4019
  {23, 12,   0}, // #4020
  {17,  1,   0}, // #4021
  {21,  1,   0}, // #4022
  {22,  2,   0}, // #4023
  {23,  3,   0}, // #4024
  { 9,  1,   0}, // #4025
  {14,  1,   0}, // #4026
  {16,  1,   0}, // #4027
  {18,  1,   0}, // #4028
  {20,  1,   0}, // #4029
  {22,  3,   0}, // #4030
  {23,  3,   0}, // #4031
  { 7,  1,   0}, // #4032
  {12,  1,   0}, // #4033
  {17,  1,   0}, // #4034
  {21,  2,   0}, // #4035
  {22,  3,   0}, // #4036
  {23,  6,   0}, // #4037
  {14,  1,   0}, // #4038
  {20,  1,   0}, // #4039
  {22,  2,   0}, // #4040
  {23,  2,   0}, // #4041
  { 3,  1,   0}, // #4042
  {11,  2,   0}, // #4043
  {12,  1,   0}, // #4044
  {13,  1,   0}, // #4045
  {14,  1,   0}, // #4046
  {17,  1,   0}, // #4047
  {19,  2,   0}, // #4048
  {20,  1,   0}, // #4049
  {21,  1,   0}, // #4050
  {22,  2,   0}, // #4051
  {23,  3,   0}, // #4052
  {14,  2,   0}, // #4053
  {20,  2,   0}, // #4054
  {22, 11,   0}, // #4055
  {23, 11,   0}, // #4056
  { 7,  1,   0}, // #4057
  { 9,  1,   0}, // #4058
  {12,  1,   0}, // #4059
  {14,  1,   0}, // #4060
  {16,  1,   0}, // #4061
  {18,  1,   0}, // #4062
  {20,  1,   0}, // #4063
  {21,  1,   0}, // #4064
  {22,  1,   0}, // #4065
  {23,  3,   0}, // #4066
  { 9,  1,   0}, // #4067
  {14,  1,   0}, // #4068
  {16,  1,   0}, // #4069
  {18,  1,   0}, // #4070
  {20,  1,   0}, // #4071
  {22,  5,   0}, // #4072
  {23,  5,   0}, // #4073
  { 7,  1,   0}, // #4074
  {12,  1,   0}, // #4075
  {14,  4,   0}, // #4076
  {15,  2,   0}, // #4077
  {17,  1,   0}, // #4078
  {19,  2,   0}, // #4079
  {20,  4,   0}, // #4080
  {21,  2,   0}, // #4081
  {22, 11,   0}, // #4082
  {23, 14,   0}, // #4083
  { 9,  2,   0}, // #4084
  {14,  4,   0}, // #4085
  {15,  1,   0}, // #4086
  {16,  2,   0}, // #4087
  {18,  2,   0}, // #4088
  {19,  1,   0}, // #4089
  {20,  4,   0}, // #4090
  {22,  7,   0}, // #4091
  {23,  7,   0}, // #4092
  { 9,  1,   0}, // #4093
  {14,  1,   0}, // #4094
  {16,  1,   0}, // #4095
  {18,  1,   0}, // #4096
  {20,  1,   0}, // #4097
  {22,  6,   0}, // #4098
  {23,  6,   0}, // #4099
  { 3,  2,   0}, // #4100
  { 7,  1,   0}, // #4101
  { 8,  4,   0}, // #4102
  {11,  2,   0}, // #4103
  {12,  3,   0}, // #4104
  {13,  6,   0}, // #4105
  {14,  6,   0}, // #4106
  {15,  4,   0}, // #4107
  {17,  1,   0}, // #4108
  {18,  4,   0}, // #4109
  {19,  6,   0}, // #4110
  {20, 10,   0}, // #4111
  {21,  2,   0}, // #4112
  {22, 16,   0}, // #4113
  {23, 19,   0}, // #4114
  { 8,  2,   0}, // #4115
  {13,  2,   0}, // #4116
  {15,  2,   0}, // #4117
  {18,  2,   0}, // #4118
  {19,  2,   0}, // #4119
  {20,  2,   0}, // #4120
  {22, 22,   0}, // #4121
  {23, 22,   0}, // #4122
  { 7,  1,   0}, // #4123
  { 8,  1,   0}, // #4124
  { 9,  1,   0}, // #4125
  {12,  1,   0}, // #4126
  {13,  1,   0}, // #4127
  {14,  2,   0}, // #4128
  {15,  1,   0}, // #4129
  {16,  1,   0}, // #4130
  {17,  1,   0}, // #4131
  {18,  2,   0}, // #4132
  {19,  1,   0}, // #4133
  {20,  3,   0}, // #4134
  {21,  2,   0}, // #4135
  {22,  5,   0}, // #4136
  {23,  8,   0}, // #4137
  { 8,  6,   0}, // #4138
  {11,  3,   0}, // #4139
  {13,  6,   0}, // #4140
  {15,  6,   0}, // #4141
  {18,  6,   0}, // #4142
  {19,  9,   0}, // #4143
  {20,  6,   0}, // #4144
  {22, 15,   0}, // #4145
  {23, 15,   0}, // #4146
  { 8,  1,   0}, // #4147
  { 9,  5,   0}, // #4148
  {13,  1,   0}, // #4149
  {14,  9,   0}, // #4150
  {15,  1,   0}, // #4151
  {16,  5,   0}, // #4152
  {17,  2,   0}, // #4153
  {18,  6,   0}, // #4154
  {19,  1,   0}, // #4155
  {20, 10,   0}, // #4156
  {21,  3,   0}, // #4157
  {22, 20,   0}, // #4158
  {23, 23,   0}, // #4159
  { 8,  1,   0}, // #4160
  { 9,  5,   0}, // #4161
  {13,  1,   0}, // #4162
  {14,  9,   0}, // #4163
  {15,  1,   0}, // #4164
  {16,  5,   0}, // #4165
  {17,  3,   0}, // #4166
  {18,  6,   0}, // #4167
  {19,  1,   0}, // #4168
  {20, 10,   0}, // #4169
  {21,  3,   0}, // #4170
  {22, 20,   0}, // #4171
  {23, 23,   0}, // #4172
  { 8,  1,   0}, // #4173
  { 9,  1,   0}, // #4174
  {13,  1,   0}, // #4175
  {14,  2,   0}, // #4176
  {15,  1,   0}, // #4177
  {16,  1,   0}, // #4178
  {18,  2,   0}, // #4179
  {19,  1,   0}, // #4180
  {20,  3,   0}, // #4181
  {22,  8,   0}, // #4182
  {23,  8,   0}, // #4183
  { 3,  4,   0}, // #4184
  { 9,  2,   0}, // #4185
  {11,  4,   0}, // #4186
  {12,  4,   0}, // #4187
  {13,  5,   0}, // #4188
  {14,  8,   0}, // #4189
  {15,  1,   0}, // #4190
  {16,  2,   0}, // #4191
  {17, 33,   0}, // #4192
  {18,  2,   0}, // #4193
  {19,  6,   0}, // #4194
  {20,  9,   0}, // #4195
  {21, 33,   0}, // #4196
  {22, 57,   0}, // #4197
  {23, 90,   0}, // #4198
  { 9,  1,   0}, // #4199
  {14,  1,   0}, // #4200
  {16,  1,   0}, // #4201
  {17,  1,   0}, // #4202
  {18,  1,   0}, // #4203
  {20,  1,   0}, // #4204
  {21,  1,   0}, // #4205
  {22,  2,   0}, // #4206
  {23,  3,   0}, // #4207
  { 3,  1,   0}, // #4208
  {11,  1,   0}, // #4209
  {12,  1,   0}, // #4210
  {13,  1,   0}, // #4211
  {14,  1,   0}, // #4212
  {19,  1,   0}, // #4213
  {20,  1,   0}, // #4214
  {22,  2,   0}, // #4215
  {23,  2,   0}, // #4216
  {11,  1,   0}, // #4217
  {19,  2,   0}, // #4218
  {22,  2,   0}, // #4219
  {23,  2,   0}, // #4220
  {14,  1,   0}, // #4221
  {20,  1,   0}, // #4222
  {22,  3,   0}, // #4223
  {23,  3,   0}, // #4224
  { 4,  2,   0}, // #4225
  {11,  2,   0}, // #4226
  {14,  4,   0}, // #4227
  {15,  2,   0}, // #4228
  {16,  2,   0}, // #4229
  {19,  2,   0}, // #4230
  {20,  4,   0}, // #4231
  {22,  8,   0}, // #4232
  {23,  8,   0}, // #4233
  { 4,  2,   0}, // #4234
  {11,  2,   0}, // #4235
  {14,  3,   0}, // #4236
  {15,  3,   0}, // #4237
  {16,  2,   0}, // #4238
  {19,  3,   0}, // #4239
  {20,  3,   0}, // #4240
  {22, 10,   0}, // #4241
  {23, 10,   0}, // #4242
  { 7,  1,   0}, // #4243
  {12,  1,   0}, // #4244
  {21,  1,   0}, // #4245
  {22,  1,   0}, // #4246
  {23,  3,   0}, // #4247
  { 7,  1,   0}, // #4248
  {12,  1,   0}, // #4249
  {14,  1,   0}, // #4250
  {20,  1,   0}, // #4251
  {21,  1,   0}, // #4252
  {22,  2,   0}, // #4253
  {23,  4,   0}, // #4254
  { 7,  1,   0}, // #4255
  { 9,  1,   0}, // #4256
  {12,  1,   0}, // #4257
  {14,  1,   0}, // #4258
  {16,  1,   0}, // #4259
  {18,  1,   0}, // #4260
  {20,  1,   0}, // #4261
  {21,  1,   0}, // #4262
  {22,  2,   0}, // #4263
  {23,  4,   0}, // #4264
  { 7,  1,   0}, // #4265
  {12,  1,   0}, // #4266
  {21,  1,   0}, // #4267
  {22,  4,   0}, // #4268
  {23,  6,   0}, // #4269
  { 9,  1,   0}, // #4270
  {14,  1,   0}, // #4271
  {16,  1,   0}, // #4272
  {18,  1,   0}, // #4273
  {20,  1,   0}, // #4274
  {22,  2,   0}, // #4275
  {23,  2,   0}, // #4276
  { 9,  1,   0}, // #4277
  {14,  1,   0}, // #4278
  {16,  1,   0}, // #4279
  {17,  1,   0}, // #4280
  {18,  1,   0}, // #4281
  {20,  1,   0}, // #4282
  {21,  1,   0}, // #4283
  {22,  1,   0}, // #4284
  {23,  2,   0}, // #4285
  { 3,  1,   0}, // #4286
  { 7,  1,   0}, // #4287
  {11,  1,   0}, // #4288
  {12,  2,   0}, // #4289
  {13,  1,   0}, // #4290
  {14,  1,   0}, // #4291
  {19,  1,   0}, // #4292
  {20,  1,   0}, // #4293
  {21,  1,   0}, // #4294
  {22,  1,   0}, // #4295
  {23,  3,   0}, // #4296
  { 4,  1,   0}, // #4297
  { 9,  1,   0}, // #4298
  {11,  1,   0}, // #4299
  {14,  2,   0}, // #4300
  {15,  1,   0}, // #4301
  {16,  2,   0}, // #4302
  {18,  1,   0}, // #4303
  {19,  1,   0}, // #4304
  {20,  2,   0}, // #4305
  {22,  4,   0}, // #4306
  {23,  4,   0}, // #4307
  { 7,  1,   0}, // #4308
  { 9,  1,   0}, // #4309
  {12,  1,   0}, // #4310
  {14,  1,   0}, // #4311
  {16,  1,   0}, // #4312
  {17,  1,   0}, // #4313
  {18,  1,   0}, // #4314
  {20,  1,   0}, // #4315
  {21,  2,   0}, // #4316
  {22,  2,   0}, // #4317
  {23,  5,   0}, // #4318
  { 7,  1,   0}, // #4319
  {12,  1,   0}, // #4320
  {14,  2,   0}, // #4321
  {17,  1,   0}, // #4322
  {20,  2,   0}, // #4323
  {21,  2,   0}, // #4324
  {22,  2,   0}, // #4325
  {23,  5,   0}, // #4326
  { 7,  1,   0}, // #4327
  {12,  1,   0}, // #4328
  {17,  1,   0}, // #4329
  {21,  2,   0}, // #4330
  {22,  2,   0}, // #4331
  {23,  5,   0}, // #4332
  { 8,  1,   0}, // #4333
  { 9,  1,   0}, // #4334
  {13,  1,   0}, // #4335
  {14,  1,   0}, // #4336
  {15,  1,   0}, // #4337
  {16,  1,   0}, // #4338
  {18,  2,   0}, // #4339
  {19,  1,   0}, // #4340
  {20,  2,   0}, // #4341
  {22,  2,   0}, // #4342
  {23,  2,   0}, // #4343
  {14,  1,   0}, // #4344
  {17,  1,   0}, // #4345
  {20,  1,   0}, // #4346
  {21,  1,   0}, // #4347
  {22,  4,   0}, // #4348
  {23,  5,   0}, // #4349
  { 9,  1,   0}, // #4350
  {14,  1,   0}, // #4351
  {16,  1,   0}, // #4352
  {18,  1,   0}, // #4353
  {20,  1,   0}, // #4354
  {22,  1,   0}, // #4355
  {23,  1,   0}, // #4356
  { 7,  1,   0}, // #4357
  {12,  1,   0}, // #4358
  {15,  1,   0}, // #4359
  {19,  1,   0}, // #4360
  {21,  1,   0}, // #4361
  {22,  1,   0}, // #4362
  {23,  3,   0}, // #4363
  {14,  2,   0}, // #4364
  {20,  2,   0}, // #4365
  {22,  2,   0}, // #4366
  {23,  2,   0}, // #4367
  { 8,  2,   0}, // #4368
  {13,  2,   0}, // #4369
  {15,  2,   0}, // #4370
  {18,  2,   0}, // #4371
  {19,  2,   0}, // #4372
  {20,  2,   0}, // #4373
  {22,  3,   0}, // #4374
  {23,  3,   0}, // #4375
  { 8,  1,   0}, // #4376
  {13,  1,   0}, // #4377
  {15,  1,   0}, // #4378
  {17,  1,   0}, // #4379
  {18,  1,   0}, // #4380
  {19,  2,   0}, // #4381
  {20,  1,   0}, // #4382
  {21,  1,   0}, // #4383
  {22,  2,   0}, // #4384
  {23,  3,   0}, // #4385
  { 4,  2,   0}, // #4386
  { 9,  2,   0}, // #4387
  {11,  2,   0}, // #4388
  {14,  2,   0}, // #4389
  {15,  2,   0}, // #4390
  {16,  4,   0}, // #4391
  {17,  1,   0}, // #4392
  {18,  2,   0}, // #4393
  {19,  2,   0}, // #4394
  {20,  2,   0}, // #4395
  {21,  1,   0}, // #4396
  {22,  7,   0}, // #4397
  {23,  8,   0}, // #4398
  { 4,  1,   0}, // #4399
  { 9,  2,   0}, // #4400
  {11,  1,   0}, // #4401
  {14,  2,   0}, // #4402
  {15,  1,   0}, // #4403
  {16,  3,   0}, // #4404
  {17,  1,   0}, // #4405
  {18,  2,   0}, // #4406
  {19,  1,   0}, // #4407
  {20,  2,   0}, // #4408
  {21,  1,   0}, // #4409
  {22,  4,   0}, // #4410
  {23,  5,   0}, // #4411
  { 4,  1,   0}, // #4412
  { 9,  1,   0}, // #4413
  {11,  1,   0}, // #4414
  {14,  2,   0}, // #4415
  {15,  1,   0}, // #4416
  {16,  2,   0}, // #4417
  {18,  1,   0}, // #4418
  {19,  1,   0}, // #4419
  {20,  2,   0}, // #4420
  {22,  3,   0}, // #4421
  {23,  3,   0}, // #4422
  {14,  1,   0}, // #4423
  {20,  1,   0}, // #4424
  {22,  5,   0}, // #4425
  {23,  5,   0}, // #4426
  { 4,  1,   0}, // #4427
  {11,  1,   0}, // #4428
  {14,  4,   0}, // #4429
  {15,  2,   0}, // #4430
  {16,  1,   0}, // #4431
  {17,  1,   0}, // #4432
  {19,  2,   0}, // #4433
  {20,  4,   0}, // #4434
  {21,  2,   0}, // #4435
  {22,  8,   0}, // #4436
  {23, 10,   0}, // #4437
  { 4,  2,   0}, // #4438
  {11,  2,   0}, // #4439
  {14,  2,   0}, // #4440
  {15,  2,   0}, // #4441
  {16,  2,   0}, // #4442
  {19,  2,   0}, // #4443
  {20,  2,   0}, // #4444
  {22,  7,   0}, // #4445
  {23,  7,   0}, // #4446
  { 4,  1,   0}, // #4447
  {11,  1,   0}, // #4448
  {14,  4,   0}, // #4449
  {15,  2,   0}, // #4450
  {16,  1,   0}, // #4451
  {19,  2,   0}, // #4452
  {20,  4,   0}, // #4453
  {22,  9,   0}, // #4454
  {23,  9,   0}, // #4455
  { 9,  3,   0}, // #4456
  {14,  3,   0}, // #4457
  {16,  3,   0}, // #4458
  {17,  1,   0}, // #4459
  {18,  3,   0}, // #4460
  {20,  3,   0}, // #4461
  {21,  1,   0}, // #4462
  {22, 18,   0}, // #4463
  {23, 19,   0}, // #4464
  { 7,  1,   0}, // #4465
  { 9,  5,   0}, // #4466
  {12,  1,   0}, // #4467
  {14,  5,   0}, // #4468
  {16,  5,   0}, // #4469
  {17,  1,   0}, // #4470
  {18,  5,   0}, // #4471
  {20,  5,   0}, // #4472
  {21,  2,   0}, // #4473
  {22, 24,   0}, // #4474
  {23, 27,   0}, // #4475
  { 7,  1,   0}, // #4476
  { 9,  6,   0}, // #4477
  {12,  1,   0}, // #4478
  {14,  6,   0}, // #4479
  {16,  6,   0}, // #4480
  {17,  1,   0}, // #4481
  {18,  6,   0}, // #4482
  {20,  6,   0}, // #4483
  {21,  2,   0}, // #4484
  {22, 25,   0}, // #4485
  {23, 28,   0}, // #4486
  { 3,  2,   0}, // #4487
  {11,  4,   0}, // #4488
  {12,  2,   0}, // #4489
  {13,  3,   0}, // #4490
  {14, 12,   0}, // #4491
  {17,  8,   0}, // #4492
  {19,  7,   0}, // #4493
  {20, 13,   0}, // #4494
  {21,  8,   0}, // #4495
  {22, 56,   0}, // #4496
  {23, 64,   0}, // #4497
  { 3,  4,   0}, // #4498
  { 9,  4,   0}, // #4499
  {11,  4,   0}, // #4500
  {12,  4,   0}, // #4501
  {13,  5,   0}, // #4502
  {14, 10,   0}, // #4503
  {15,  1,   0}, // #4504
  {16,  4,   0}, // #4505
  {17, 31,   0}, // #4506
  {18,  4,   0}, // #4507
  {19,  6,   0}, // #4508
  {20, 11,   0}, // #4509
  {21, 31,   0}, // #4510
  {22, 57,   0}, // #4511
  {23, 88,   0}, // #4512
  { 3,  9,   0}, // #4513
  { 4,  9,   0}, // #4514
  { 7, 11,   0}, // #4515
  { 8,  8,   0}, // #4516
  { 9,  1,   0}, // #4517
  {11, 18,   0}, // #4518
  {12, 20,   0}, // #4519
  {13, 17,   0}, // #4520
  {14, 31,   0}, // #4521
  {15, 17,   0}, // #4522
  {16, 10,   0}, // #4523
  {18,  9,   0}, // #4524
  {19, 26,   0}, // #4525
  {20, 39,   0}, // #4526
  {21, 11,   0}, // #4527
  {22, 78,   0}, // #4528
  {23, 100,   0}, // #4529
  { 7,  1,   0}, // #4530
  { 8,  3,   0}, // #4531
  {12,  1,   0}, // #4532
  {13,  3,   0}, // #4533
  {15,  3,   0}, // #4534
  {17,  2,   0}, // #4535
  {18,  3,   0}, // #4536
  {19,  3,   0}, // #4537
  {20,  3,   0}, // #4538
  {21,  2,   0}, // #4539
  {22,  4,   0}, // #4540
  {23,  7,   0}, // #4541
  { 7,  1,   0}, // #4542
  { 8,  3,   0}, // #4543
  {12,  1,   0}, // #4544
  {13,  3,   0}, // #4545
  {15,  3,   0}, // #4546
  {17,  4,   0}, // #4547
  {18,  3,   0}, // #4548
  {19,  3,   0}, // #4549
  {20,  3,   0}, // #4550
  {21,  4,   0}, // #4551
  {22,  4,   0}, // #4552
  {23,  9,   0}, // #4553
  { 7,  1,   0}, // #4554
  { 8,  4,   0}, // #4555
  {12,  1,   0}, // #4556
  {13,  4,   0}, // #4557
  {15,  4,   0}, // #4558
  {17,  4,   0}, // #4559
  {18,  4,   0}, // #4560
  {19,  4,   0}, // #4561
  {20,  4,   0}, // #4562
  {21,  4,   0}, // #4563
  {22,  5,   0}, // #4564
  {23, 10,   0}, // #4565
  { 7,  1,   0}, // #4566
  { 8,  4,   0}, // #4567
  {12,  1,   0}, // #4568
  {13,  4,   0}, // #4569
  {15,  4,   0}, // #4570
  {17,  8,   0}, // #4571
  {18,  4,   0}, // #4572
  {19,  4,   0}, // #4573
  {20,  4,   0}, // #4574
  {21,  8,   0}, // #4575
  {22,  5,   0}, // #4576
  {23, 14,   0}, // #4577
  { 7,  1,   0}, // #4578
  { 8,  5,   0}, // #4579
  {12,  1,   0}, // #4580
  {13,  5,   0}, // #4581
  {15,  5,   0}, // #4582
  {17,  2,   0}, // #4583
  {18,  5,   0}, // #4584
  {19,  5,   0}, // #4585
  {20,  5,   0}, // #4586
  {21,  2,   0}, // #4587
  {22,  6,   0}, // #4588
  {23,  9,   0}, // #4589
  { 9,  1,   0}, // #4590
  {14,  1,   0}, // #4591
  {16,  1,   0}, // #4592
  {17,  1,   0}, // #4593
  {18,  1,   0}, // #4594
  {20,  1,   0}, // #4595
  {21,  1,   0}, // #4596
  {22, 17,   0}, // #4597
  {23, 18,   0}, // #4598
  {14,  1,   0}, // #4599
  {17,  1,   0}, // #4600
  {20,  1,   0}, // #4601
  {21,  1,   0}, // #4602
  {22,  2,   0}, // #4603
  {23,  3,   0}, // #4604
  { 9,  1,   0}, // #4605
  {16,  1,   0}, // #4606
  { 3,  3,   0}, // #4607
  {11,  1,   0}, // #4608
  {12,  2,   0}, // #4609
  {14,  1,   0}, // #4610
  { 8,  1,   0}, // #4611
  { 9,  1,   0}, // #4612
  {12,  1,   0}, // #4613
  {14,  1,   0}, // #4614
  {15,  1,   0}, // #4615
  { 8,  2,   0}, // #4616
  { 9,  2,   0}, // #4617
  {12,  2,   0}, // #4618
  {14,  2,   0}, // #4619
  {15,  2,   0}, // #4620
  { 3,  1,   0}, // #4621
  {11,  1,   0}, // #4622
  {12,  2,   0}, // #4623
  {14,  1,   0}, // #4624
  { 3,  2,   0}, // #4625
  {11,  1,   0}, // #4626
  {12,  2,   0}, // #4627
  {14,  1,   0}, // #4628
  { 3,  2,   0}, // #4629
  {11,  1,   0}, // #4630
  {12,  1,   0}, // #4631
  { 5,  1,   0}, // #4632
  { 7,  1,   0}, // #4633
  { 9,  1,   0}, // #4634
  {10,  1,   0}, // #4635
  {11,  1,   0}, // #4636
  {12,  1,   0}, // #4637
  { 7,  1,   0}, // #4638
  { 9,  2,   0}, // #4639
  {11,  1,   0}, // #4640
  {12,  1,   0}, // #4641
  {16,  1,   0}, // #4642
  {19,  1,   0}, // #4643
  { 7,  1,   0}, // #4644
  { 9,  2,   0}, // #4645
  {16,  1,   0}, // #4646
  {19,  1,   0}, // #4647
  { 7,  1,   0}, // #4648
  { 9,  1,   0}, // #4649
  {11,  1,   0}, // #4650
  {12,  1,   0}, // #4651
  {19,  1,   0}, // #4652
  { 7,  1,   0}, // #4653
  { 9,  1,   0}, // #4654
  {19,  1,   0}, // #4655
  { 9,  4,   0}, // #4656
  {10,  4,   0}, // #4657
  {11,  1,   0}, // #4658
  {12,  1,   0}, // #4659
  { 3,  8,   0}, // #4660
  {11,  1,   0}, // #4661
  {12,  1,   0}, // #4662
  { 1,  1,   0}, // #4663
  { 3,  1,   0}, // #4664
  { 5,  1,   0}, // #4665
  { 7,  1,   0}, // #4666
  { 9,  1,   0}, // #4667
  {10,  1,   0}, // #4668
  {11,  1,   0}, // #4669
  {12,  1,   0}, // #4670
  { 3,  4,   0}, // #4671
  {11,  1,   0}, // #4672
  {12,  1,   0}, // #4673
  { 8,  1,   0}, // #4674
  { 9,  1,   0}, // #4675
  {11,  1,   0}, // #4676
  {12,  1,   0}, // #4677
  {15,  1,   0}, // #4678
  { 8,  1,   0}, // #4679
  { 9,  1,   0}, // #4680
  {15,  1,   0}, // #4681
  { 1,  1,   0}, // #4682
  { 3,  1,   0}, // #4683
  { 5,  1,   0}, // #4684
  { 7,  1,   0}, // #4685
  { 8,  1,   0}, // #4686
  { 9,  2,   0}, // #4687
  {10,  1,   0}, // #4688
  {11,  1,   0}, // #4689
  {12,  1,   0}, // #4690
  {15,  1,   0}, // #4691
  { 1,  1,   0}, // #4692
  { 3,  1,   0}, // #4693
  { 5,  1,   0}, // #4694
  { 7,  1,   0}, // #4695
  { 8,  1,   0}, // #4696
  { 9,  2,   0}, // #4697
  {10,  1,   0}, // #4698
  {15,  1,   0}, // #4699
  { 8,  1,   0}, // #4700
  { 9,  1,   0}, // #4701
  {11,  1,   0}, // #4702
  {12,  1,   0}, // #4703
  {15,  2,   0}, // #4704
  { 8,  1,   0}, // #4705
  { 9,  1,   0}, // #4706
  {15,  2,   0}, // #4707
  { 2,  1,   0}, // #4708
  { 3,  1,   0}, // #4709
  { 4, 17,   0}, // #4710
  {11,  1,   0}, // #4711
  {12,  1,   0}, // #4712
  { 2,  1,   0}, // #4713
  { 3,  1,   0}, // #4714
  { 4, 25,   0}, // #4715
  {11,  1,   0}, // #4716
  {12,  1,   0}, // #4717
  { 2,  1,   0}, // #4718
  { 3,  1,   0}, // #4719
  { 4, 41,   0}, // #4720
  {11,  1,   0}, // #4721
  {12,  1,   0}, // #4722
  { 2,  1,   0}, // #4723
  { 3,  1,   0}, // #4724
  { 4, 12,   0}, // #4725
  {11,  1,   0}, // #4726
  {12,  1,   0}, // #4727
  { 6, 19,   0}, // #4728
  { 8,  1,   0}, // #4729
  { 9,  1,   0}, // #4730
  {10, 19,   0}, // #4731
  {11,  1,   0}, // #4732
  {12,  1,   0}, // #4733
  { 5,  3,   0}, // #4734
  { 6,  3,   0}, // #4735
  { 8,  1,   0}, // #4736
  { 9,  1,   0}, // #4737
  {10,  6,   0}, // #4738
  {11,  1,   0}, // #4739
  {12,  1,   0}, // #4740
  { 9,  1,   0}, // #4741
  {11,  1,   0}, // #4742
  {12,  1,   0}, // #4743
  {16,  1,   0}, // #4744
  { 2,  1,   0}, // #4745
  { 3,  1,   0}, // #4746
  {11,  1,   0}, // #4747
  {12,  1,   0}, // #4748
  {13,  3,   0}, // #4749
  { 2,  1,   0}, // #4750
  { 3,  1,   0}, // #4751
  {13,  3,   0}, // #4752
  { 2,  1,   0}, // #4753
  { 3,  1,   0}, // #4754
  {11,  1,   0}, // #4755
  {12,  1,   0}, // #4756
  {13,  1,   0}, // #4757
  { 2,  1,   0}, // #4758
  { 3,  1,   0}, // #4759
  {11,  1,   0}, // #4760
  {12,  1,   0}, // #4761
  {13,  2,   0}, // #4762
  { 2,  1,   0}, // #4763
  { 3,  1,   0}, // #4764
  {13,  1,   0}, // #4765
  { 2,  1,   0}, // #4766
  { 3,  1,   0}, // #4767
  {13,  2,   0}, // #4768
  { 2,  1,   0}, // #4769
  { 3,  1,   0}, // #4770
  {11,  1,   0}, // #4771
  {12,  1,   0}, // #4772
  {13,  4,   0}, // #4773
  { 2,  1,   0}, // #4774
  { 3,  1,   0}, // #4775
  {13,  4,   0}, // #4776
  { 7,  1,   0}, // #4777
  { 9,  1,   0}, // #4778
  {11,  1,   0}, // #4779
  {12,  1,   0}, // #4780
  {19,  2,   0}, // #4781
  { 7,  1,   0}, // #4782
  { 9,  1,   0}, // #4783
  {19,  2,   0}, // #4784
  { 6,  2,   0}, // #4785
  { 8,  1,   0}, // #4786
  { 9,  1,   0}, // #4787
  {10,  2,   0}, // #4788
  {11,  1,   0}, // #4789
  {12,  1,   0}, // #4790
  { 6,  1,   0}, // #4791
  { 8,  1,   0}, // #4792
  { 9,  1,   0}, // #4793
  {10,  1,   0}, // #4794
  {11,  1,   0}, // #4795
  {12,  1,   0}, // #4796
  { 9,  4,   0}, // #4797
  {11,  1,   0}, // #4798
  {12,  1,   0}, // #4799
  {16,  4,   0}, // #4800
  { 9,  4,   0}, // #4801
  {16,  4,   0}, // #4802
  { 1,  1,   0}, // #4803
  { 3,  1,   0}, // #4804
  { 5,  1,   0}, // #4805
  { 8,  1,   0}, // #4806
  { 9,  1,   0}, // #4807
  {10,  1,   0}, // #4808
  {11,  3,   0}, // #4809
  {12,  5,   0}, // #4810
  {14,  2,   0}, // #4811
  {16, 10,   0}, // #4812
  {18,  4,   0}, // #4813
  { 1,  1,   0}, // #4814
  { 3,  1,   0}, // #4815
  { 5,  1,   0}, // #4816
  { 8,  1,   0}, // #4817
  { 9,  1,   0}, // #4818
  {10,  1,   0}, // #4819
  {11,  2,   0}, // #4820
  {12,  4,   0}, // #4821
  {14,  2,   0}, // #4822
  {16, 10,   0}, // #4823
  {18,  4,   0}, // #4824
  { 1,  1,   0}, // #4825
  { 3,  1,   0}, // #4826
  { 5,  1,   0}, // #4827
  { 7,  1,   0}, // #4828
  { 8,  2,   0}, // #4829
  { 9,  3,   0}, // #4830
  {10,  1,   0}, // #4831
  {11,  1,   0}, // #4832
  {12,  1,   0}, // #4833
  {16,  2,   0}, // #4834
  {18,  2,   0}, // #4835
  { 1,  1,   0}, // #4836
  { 3,  1,   0}, // #4837
  { 5,  1,   0}, // #4838
  { 7,  1,   0}, // #4839
  { 8,  2,   0}, // #4840
  { 9,  3,   0}, // #4841
  {10,  1,   0}, // #4842
  {16,  2,   0}, // #4843
  {18,  2,   0}, // #4844
  { 7,  2,   0}, // #4845
  { 9,  3,   0}, // #4846
  {11,  1,   0}, // #4847
  {12,  1,   0}, // #4848
  {16,  1,   0}, // #4849
  {19,  2,   0}, // #4850
  { 7,  2,   0}, // #4851
  { 9,  3,   0}, // #4852
  {16,  1,   0}, // #4853
  {19,  2,   0}, // #4854
  { 9,  1,   0}, // #4855
  {11,  1,   0}, // #4856
  {12,  1,   0}, // #4857
  {16,  4,   0}, // #4858
  { 9,  1,   0}, // #4859
  {16,  4,   0}, // #4860
  { 3,  1,   0}, // #4861
  {12,  1,   0}, // #4862
  {14,  1,   0}, // #4863
  { 3, 22,   0}, // #4864
  {11,  1,   0}, // #4865
  {12,  1,   0}, // #4866
  { 6, 27,   0}, // #4867
  { 8,  1,   0}, // #4868
  { 9,  1,   0}, // #4869
  {10, 27,   0}, // #4870
  {11,  1,   0}, // #4871
  {12,  1,   0}, // #4872
  { 6, 21,   0}, // #4873
  { 8,  1,   0}, // #4874
  { 9,  1,   0}, // #4875
  {10, 21,   0}, // #4876
  {11,  1,   0}, // #4877
  {12,  1,   0}, // #4878
  { 6, 35,   0}, // #4879
  { 8,  1,   0}, // #4880
  { 9,  1,   0}, // #4881
  {10, 35,   0}, // #4882
  { 5,  2,   0}, // #4883
  { 7,  2,   0}, // #4884
  { 9,  2,   0}, // #4885
  {10,  2,   0}, // #4886
  {11,  2,   0}, // #4887
  {12,  2,   0}, // #4888
  { 8,  2,   0}, // #4889
  { 9,  2,   0}, // #4890
  {15,  2,   0}, // #4891
  { 9,  6,   0}, // #4892
  {10,  6,   0}, // #4893
  {11,  2,   0}, // #4894
  {12,  2,   0}, // #4895
  { 9,  2,   0}, // #4896
  {10,  2,   0}, // #4897
  {11,  1,   0}, // #4898
  {12,  1,   0}, // #4899
  { 8,  2,   0}, // #4900
  { 9,  2,   0}, // #4901
  {11,  2,   0}, // #4902
  {12,  2,   0}, // #4903
  {15,  2,   0}, // #4904
  { 8,  2,   0}, // #4905
  { 9,  2,   0}, // #4906
  {10,  4,   0}, // #4907
  {11,  2,   0}, // #4908
  {12,  2,   0}, // #4909
  {15,  2,   0}, // #4910
  { 8,  2,   0}, // #4911
  { 9,  2,   0}, // #4912
  {10,  4,   0}, // #4913
  {15,  2,   0}, // #4914
  { 8,  2,   0}, // #4915
  { 9,  2,   0}, // #4916
  {10,  2,   0}, // #4917
  {12,  1,   0}, // #4918
  {14,  1,   0}, // #4919
  {15,  2,   0}, // #4920
  { 8,  2,   0}, // #4921
  { 9,  2,   0}, // #4922
  {10,  2,   0}, // #4923
  {15,  2,   0}, // #4924
  { 6, 38,   0}, // #4925
  { 8,  2,   0}, // #4926
  { 9,  2,   0}, // #4927
  {10, 38,   0}, // #4928
  {11,  2,   0}, // #4929
  {12,  2,   0}, // #4930
  { 5,  6,   0}, // #4931
  { 6,  6,   0}, // #4932
  { 8,  2,   0}, // #4933
  { 9,  2,   0}, // #4934
  {10, 12,   0}, // #4935
  {11,  2,   0}, // #4936
  {12,  2,   0}, // #4937
  { 3,  4,   0}, // #4938
  { 5,  1,   0}, // #4939
  { 7,  1,   0}, // #4940
  { 8,  4,   0}, // #4941
  { 9,  5,   0}, // #4942
  {10,  1,   0}, // #4943
  {11,  4,   0}, // #4944
  {12,  8,   0}, // #4945
  {14,  4,   0}, // #4946
  {15,  4,   0}, // #4947
  { 9,  4,   0}, // #4948
  {10,  4,   0}, // #4949
  {11,  2,   0}, // #4950
  {12,  2,   0}, // #4951
  { 3,  2,   0}, // #4952
  { 5,  1,   0}, // #4953
  { 7,  1,   0}, // #4954
  { 8,  2,   0}, // #4955
  { 9,  3,   0}, // #4956
  {10,  1,   0}, // #4957
  {11,  2,   0}, // #4958
  {12,  4,   0}, // #4959
  {14,  2,   0}, // #4960
  {15,  2,   0}, // #4961
  { 3,  8,   0}, // #4962
  { 5,  1,   0}, // #4963
  { 7,  1,   0}, // #4964
  { 8, 10,   0}, // #4965
  { 9, 11,   0}, // #4966
  {10,  1,   0}, // #4967
  {11,  8,   0}, // #4968
  {12, 16,   0}, // #4969
  {14,  8,   0}, // #4970
  {15, 10,   0}, // #4971
  { 3,  4,   0}, // #4972
  { 5,  1,   0}, // #4973
  { 7,  1,   0}, // #4974
  { 8,  5,   0}, // #4975
  { 9,  6,   0}, // #4976
  {10,  1,   0}, // #4977
  {11,  4,   0}, // #4978
  {12,  8,   0}, // #4979
  {14,  4,   0}, // #4980
  {15,  5,   0}, // #4981
  { 9,  2,   0}, // #4982
  {16,  2,   0}, // #4983
  { 6,  4,   0}, // #4984
  { 8,  2,   0}, // #4985
  { 9,  2,   0}, // #4986
  {10,  4,   0}, // #4987
  {11,  2,   0}, // #4988
  {12,  2,   0}, // #4989
  { 6,  2,   0}, // #4990
  { 8,  2,   0}, // #4991
  { 9,  2,   0}, // #4992
  {10,  2,   0}, // #4993
  {11,  2,   0}, // #4994
  {12,  2,   0}, // #4995
  { 9,  2,   0}, // #4996
  {10,  6,   0}, // #4997
  {11,  2,   0}, // #4998
  {12,  2,   0}, // #4999
  { 9,  1,   0}, // #5000
  {10,  4,   0}, // #5001
  {11,  1,   0}, // #5002
  {12,  1,   0}, // #5003
  { 9,  4,   0}, // #5004
  {11,  2,   0}, // #5005
  {12,  2,   0}, // #5006
  {16,  4,   0}, // #5007
  { 9,  2,   0}, // #5008
  {11,  1,   0}, // #5009
  {12,  1,   0}, // #5010
  {16,  2,   0}, // #5011
  { 1,  1,   0}, // #5012
  { 3,  1,   0}, // #5013
  { 5,  2,   0}, // #5014
  { 9,  2,   0}, // #5015
  {10,  4,   0}, // #5016
  {11,  2,   0}, // #5017
  {12,  2,   0}, // #5018
  { 6, 54,   0}, // #5019
  { 8,  2,   0}, // #5020
  { 9,  2,   0}, // #5021
  {10, 54,   0}, // #5022
  {11,  2,   0}, // #5023
  {12,  2,   0}, // #5024
  { 6, 42,   0}, // #5025
  { 8,  2,   0}, // #5026
  { 9,  2,   0}, // #5027
  {10, 42,   0}, // #5028
  {11,  2,   0}, // #5029
  {12,  2,   0}, // #5030
  { 3,  2,   0}, // #5031
  {11, 16,   0}, // #5032
  {12, 32,   0}, // #5033
  {14, 16,   0}, // #5034
  { 9,  2,   0}, // #5035
  {10,  4,   0}, // #5036
  {11,  1,   0}, // #5037
  {12,  1,   0}, // #5038
  { 3, 42,   0}, // #5039
  { 5,  1,   0}, // #5040
  { 7,  1,   0}, // #5041
  { 8,  2,   0}, // #5042
  { 9,  3,   0}, // #5043
  {10,  1,   0}, // #5044
  {11,  2,   0}, // #5045
  {12, 18,   0}, // #5046
  {14, 16,   0}, // #5047
  {15,  2,   0}, // #5048
  { 3,  3,   0}, // #5049
  {11, 19,   0}, // #5050
  {12, 38,   0}, // #5051
  {14, 19,   0}, // #5052
  { 3,  6,   0}, // #5053
  {11, 38,   0}, // #5054
  {12, 76,   0}, // #5055
  {14, 38,   0}, // #5056
  { 3,  3,   0}, // #5057
  {11, 16,   0}, // #5058
  {12, 32,   0}, // #5059
  {14, 16,   0}, // #5060
  { 3,  3,   0}, // #5061
  {11, 17,   0}, // #5062
  {12, 34,   0}, // #5063
  {14, 17,   0}, // #5064
  { 3,  6,   0}, // #5065
  {11,  1,   0}, // #5066
  {12,  2,   0}, // #5067
  {14,  1,   0}, // #5068
  { 3,  1,   0}, // #5069
  {11, 19,   0}, // #5070
  {12, 38,   0}, // #5071
  {14, 19,   0}, // #5072
  { 2,  1,   0}, // #5073
  { 3,  1,   0}, // #5074
  {12,  1,   0}, // #5075
  {14,  1,   0}, // #5076
  {13,  1,   0}, // #5077
  {19,  1,   0}, // #5078
  {20,  1,   0}, // #5079
  {22,  1,   0}, // #5080
  {23,  1,   0}, // #5081
  { 3,  3,   0}, // #5082
  { 8,  6,   0}, // #5083
  {11,  3,   0}, // #5084
  {12,  3,   0}, // #5085
  {13,  9,   0}, // #5086
  {14,  3,   0}, // #5087
  {15,  6,   0}, // #5088
  {17,  1,   0}, // #5089
  {18,  6,   0}, // #5090
  {19, 10,   0}, // #5091
  {20,  9,   0}, // #5092
  {21,  1,   0}, // #5093
  {22, 10,   0}, // #5094
  {23, 11,   0}, // #5095
  { 3,  3,   0}, // #5096
  { 8,  6,   0}, // #5097
  {11,  3,   0}, // #5098
  {12,  3,   0}, // #5099
  {13,  9,   0}, // #5100
  {14,  3,   0}, // #5101
  {15,  6,   0}, // #5102
  {18,  6,   0}, // #5103
  {19, 11,   0}, // #5104
  {20,  9,   0}, // #5105
  {22, 11,   0}, // #5106
  {23, 11,   0}, // #5107
  { 8,  1,   0}, // #5108
  {11,  1,   0}, // #5109
  {13,  1,   0}, // #5110
  {15,  1,   0}, // #5111
  {17,  1,   0}, // #5112
  {18,  1,   0}, // #5113
  {19,  2,   0}, // #5114
  {20,  1,   0}, // #5115
  {21,  1,   0}, // #5116
  {22,  2,   0}, // #5117
  {23,  3,   0}, // #5118
  { 8,  1,   0}, // #5119
  {11,  1,   0}, // #5120
  {13,  1,   0}, // #5121
  {15,  1,   0}, // #5122
  {18,  1,   0}, // #5123
  {19,  2,   0}, // #5124
  {20,  1,   0}, // #5125
  {22,  2,   0}, // #5126
  {23,  2,   0}, // #5127
  {11,  2,   0}, // #5128
  {17,  1,   0}, // #5129
  {19,  2,   0}, // #5130
  {21,  1,   0}, // #5131
  {22,  2,   0}, // #5132
  {23,  3,   0}, // #5133
  { 1, 10,   0}, // #5134
  { 3,  1,   0}, // #5135
  {11,  1,   0}, // #5136
  {12,  1,   0}, // #5137
  {13,  1,   0}, // #5138
  {14,  1,   0}, // #5139
  {17,  1,   0}, // #5140
  {19,  1,   0}, // #5141
  {20,  1,   0}, // #5142
  {21,  1,   0}, // #5143
  {22,  1,   0}, // #5144
  {23,  2,   0}, // #5145
  { 3,  7,   0}, // #5146
  { 4,  2,   0}, // #5147
  { 8,  8,   0}, // #5148
  { 9,  3,   0}, // #5149
  {11,  9,   0}, // #5150
  {12,  7,   0}, // #5151
  {13, 16,   0}, // #5152
  {14, 10,   0}, // #5153
  {15, 10,   0}, // #5154
  {16,  5,   0}, // #5155
  {18, 11,   0}, // #5156
  {19, 18,   0}, // #5157
  {20, 19,   0}, // #5158
  {22, 32,   0}, // #5159
  {23, 32,   0}, // #5160
  { 2,  4,   0}, // #5161
  { 3,  1,   0}, // #5162
  {11,  1,   0}, // #5163
  {12,  1,   0}, // #5164
  {13,  1,   0}, // #5165
  {14,  1,   0}, // #5166
  {17,  1,   0}, // #5167
  {19,  1,   0}, // #5168
  {20,  1,   0}, // #5169
  {21,  1,   0}, // #5170
  {22,  1,   0}, // #5171
  {23,  2,   0}, // #5172
  { 2,  3,   0}, // #5173
  { 3,  1,   0}, // #5174
  {11,  1,   0}, // #5175
  {12,  1,   0}, // #5176
  {13,  1,   0}, // #5177
  {14,  1,   0}, // #5178
  {17,  1,   0}, // #5179
  {19,  1,   0}, // #5180
  {20,  1,   0}, // #5181
  {21,  1,   0}, // #5182
  {22,  1,   0}, // #5183
  {23,  2,   0}, // #5184
  { 8,  1,   0}, // #5185
  {13,  1,   0}, // #5186
  {15,  1,   0}, // #5187
  {17,  1,   0}, // #5188
  {18,  1,   0}, // #5189
  {19,  3,   0}, // #5190
  {20,  1,   0}, // #5191
  {21,  1,   0}, // #5192
  {22,  3,   0}, // #5193
  {23,  4,   0}, // #5194
  { 8,  1,   0}, // #5195
  {13,  1,   0}, // #5196
  {15,  1,   0}, // #5197
  {18,  1,   0}, // #5198
  {19,  3,   0}, // #5199
  {20,  1,   0}, // #5200
  {22,  3,   0}, // #5201
  {23,  3,   0}, // #5202
  { 8,  1,   0}, // #5203
  {13,  1,   0}, // #5204
  {15,  1,   0}, // #5205
  {17,  1,   0}, // #5206
  {18,  1,   0}, // #5207
  {19,  4,   0}, // #5208
  {20,  1,   0}, // #5209
  {21,  1,   0}, // #5210
  {22,  4,   0}, // #5211
  {23,  5,   0}, // #5212
  { 8,  1,   0}, // #5213
  {13,  1,   0}, // #5214
  {15,  1,   0}, // #5215
  {18,  1,   0}, // #5216
  {19,  4,   0}, // #5217
  {20,  1,   0}, // #5218
  {22,  4,   0}, // #5219
  {23,  4,   0}, // #5220
  {13,  9,   0}, // #5221
  {19,  9,   0}, // #5222
  {20,  9,   0}, // #5223
  {22, 10,   0}, // #5224
  {23, 10,   0}, // #5225
  {13,  2,   0}, // #5226
  {19,  2,   0}, // #5227
  {20,  2,   0}, // #5228
  {22,  2,   0}, // #5229
  {23,  2,   0}, // #5230
  { 8,  2,   0}, // #5231
  {13,  2,   0}, // #5232
  {15,  2,   0}, // #5233
  {17,  1,   0}, // #5234
  {18,  2,   0}, // #5235
  {19,  3,   0}, // #5236
  {20,  2,   0}, // #5237
  {21,  1,   0}, // #5238
  {22,  3,   0}, // #5239
  {23,  4,   0}, // #5240
  { 8,  2,   0}, // #5241
  {13,  2,   0}, // #5242
  {15,  2,   0}, // #5243
  {18,  2,   0}, // #5244
  {19,  3,   0}, // #5245
  {20,  2,   0}, // #5246
  {22,  3,   0}, // #5247
  {23,  3,   0}, // #5248
  { 3,  2,   0}, // #5249
  { 8,  4,   0}, // #5250
  {11,  2,   0}, // #5251
  {12,  2,   0}, // #5252
  {13,  6,   0}, // #5253
  {14,  2,   0}, // #5254
  {15,  4,   0}, // #5255
  {17,  1,   0}, // #5256
  {18,  4,   0}, // #5257
  {19,  6,   0}, // #5258
  {20,  6,   0}, // #5259
  {21,  1,   0}, // #5260
  {22,  7,   0}, // #5261
  {23,  8,   0}, // #5262
  { 3,  4,   0}, // #5263
  { 4,  2,   0}, // #5264
  { 8,  4,   0}, // #5265
  { 9,  8,   0}, // #5266
  {11,  6,   0}, // #5267
  {12,  4,   0}, // #5268
  {13,  8,   0}, // #5269
  {14, 26,   0}, // #5270
  {15,  6,   0}, // #5271
  {16, 10,   0}, // #5272
  {18, 12,   0}, // #5273
  {19, 10,   0}, // #5274
  {20, 30,   0}, // #5275
  {22, 66,   0}, // #5276
  {23, 66,   0}, // #5277
  {13,  1,   0}, // #5278
  {17,  1,   0}, // #5279
  {19,  1,   0}, // #5280
  {20,  1,   0}, // #5281
  {21,  1,   0}, // #5282
  {22,  1,   0}, // #5283
  {23,  2,   0}, // #5284
  { 8,  2,   0}, // #5285
  {13,  3,   0}, // #5286
  {15,  2,   0}, // #5287
  {17,  1,   0}, // #5288
  {18,  2,   0}, // #5289
  {19,  3,   0}, // #5290
  {20,  3,   0}, // #5291
  {21,  1,   0}, // #5292
  {22,  3,   0}, // #5293
  {23,  4,   0}, // #5294
  { 8,  2,   0}, // #5295
  {13,  3,   0}, // #5296
  {15,  2,   0}, // #5297
  {18,  2,   0}, // #5298
  {19,  3,   0}, // #5299
  {20,  3,   0}, // #5300
  {22,  3,   0}, // #5301
  {23,  3,   0}, // #5302
  { 7,  1,   0}, // #5303
  {12,  1,   0}, // #5304
  {14,  3,   0}, // #5305
  {17,  1,   0}, // #5306
  {20,  3,   0}, // #5307
  {21,  2,   0}, // #5308
  {22,  3,   0}, // #5309
  {23,  6,   0}, // #5310
  {14,  3,   0}, // #5311
  {20,  3,   0}, // #5312
  {22,  3,   0}, // #5313
  {23,  3,   0}, // #5314
  { 4,  1,   0}, // #5315
  {11,  1,   0}, // #5316
  {14,  2,   0}, // #5317
  {15,  1,   0}, // #5318
  {16,  1,   0}, // #5319
  {17,  1,   0}, // #5320
  {19,  1,   0}, // #5321
  {20,  2,   0}, // #5322
  {21,  2,   0}, // #5323
  {22,  4,   0}, // #5324
  {23,  6,   0}, // #5325
  { 4,  1,   0}, // #5326
  {11,  1,   0}, // #5327
  {14,  2,   0}, // #5328
  {15,  1,   0}, // #5329
  {16,  1,   0}, // #5330
  {19,  1,   0}, // #5331
  {20,  2,   0}, // #5332
  {22,  4,   0}, // #5333
  {23,  4,   0}, // #5334
  { 2,  6,   0}, // #5335
  { 3,  1,   0}, // #5336
  {11,  1,   0}, // #5337
  {12,  1,   0}, // #5338
  {13,  1,   0}, // #5339
  {14,  1,   0}, // #5340
  {17,  1,   0}, // #5341
  {19,  1,   0}, // #5342
  {20,  1,   0}, // #5343
  {21,  1,   0}, // #5344
  {22,  1,   0}, // #5345
  {23,  2,   0}, // #5346
  { 2,  6,   0}, // #5347
  { 3,  1,   0}, // #5348
  {11,  1,   0}, // #5349
  {12,  1,   0}, // #5350
  {13,  1,   0}, // #5351
  {14,  1,   0}, // #5352
  {19,  1,   0}, // #5353
  {20,  1,   0}, // #5354
  {22,  1,   0}, // #5355
  {23,  1,   0}, // #5356
  { 8,  1,   0}, // #5357
  {13,  2,   0}, // #5358
  {15,  1,   0}, // #5359
  {17,  1,   0}, // #5360
  {18,  1,   0}, // #5361
  {19,  2,   0}, // #5362
  {20,  2,   0}, // #5363
  {21,  1,   0}, // #5364
  {22,  2,   0}, // #5365
  {23,  3,   0}, // #5366
  { 8,  1,   0}, // #5367
  {13,  2,   0}, // #5368
  {15,  1,   0}, // #5369
  {18,  1,   0}, // #5370
  {19,  2,   0}, // #5371
  {20,  2,   0}, // #5372
  {22,  2,   0}, // #5373
  {23,  2,   0}, // #5374
  {13,  2,   0}, // #5375
  {17,  1,   0}, // #5376
  {19,  2,   0}, // #5377
  {20,  2,   0}, // #5378
  {21,  1,   0}, // #5379
  {22,  2,   0}, // #5380
  {23,  3,   0}, // #5381
  { 7,  1,   0}, // #5382
  { 8,  1,   0}, // #5383
  {11,  1,   0}, // #5384
  {12,  1,   0}, // #5385
  {13,  1,   0}, // #5386
  {15,  1,   0}, // #5387
  {18,  1,   0}, // #5388
  {19,  2,   0}, // #5389
  {20,  1,   0}, // #5390
  {21,  1,   0}, // #5391
  {22,  2,   0}, // #5392
  {23,  4,   0}, // #5393
  { 7,  1,   0}, // #5394
  { 8,  1,   0}, // #5395
  {12,  1,   0}, // #5396
  {13,  2,   0}, // #5397
  {15,  1,   0}, // #5398
  {18,  1,   0}, // #5399
  {19,  2,   0}, // #5400
  {20,  2,   0}, // #5401
  {21,  1,   0}, // #5402
  {22,  2,   0}, // #5403
  {23,  4,   0}, // #5404
  { 2, 16,   0}, // #5405
  { 3,  2,   0}, // #5406
  { 8,  1,   0}, // #5407
  {11,  2,   0}, // #5408
  {12,  2,   0}, // #5409
  {13,  3,   0}, // #5410
  {14,  2,   0}, // #5411
  {15,  1,   0}, // #5412
  {17,  1,   0}, // #5413
  {18,  1,   0}, // #5414
  {19,  3,   0}, // #5415
  {20,  3,   0}, // #5416
  {21,  1,   0}, // #5417
  {22,  3,   0}, // #5418
  {23,  4,   0}, // #5419
  { 2, 16,   0}, // #5420
  { 3,  2,   0}, // #5421
  { 8,  1,   0}, // #5422
  {11,  2,   0}, // #5423
  {12,  2,   0}, // #5424
  {13,  3,   0}, // #5425
  {14,  2,   0}, // #5426
  {15,  1,   0}, // #5427
  {18,  1,   0}, // #5428
  {19,  3,   0}, // #5429
  {20,  3,   0}, // #5430
  {22,  3,   0}, // #5431
  {23,  3,   0}, // #5432
  { 2, 10,   0}, // #5433
  { 3,  2,   0}, // #5434
  { 8,  1,   0}, // #5435
  {11,  2,   0}, // #5436
  {12,  2,   0}, // #5437
  {13,  3,   0}, // #5438
  {14,  2,   0}, // #5439
  {15,  1,   0}, // #5440
  {17,  1,   0}, // #5441
  {18,  1,   0}, // #5442
  {19,  3,   0}, // #5443
  {20,  3,   0}, // #5444
  {21,  1,   0}, // #5445
  {22,  3,   0}, // #5446
  {23,  4,   0}, // #5447
  { 2, 10,   0}, // #5448
  { 3,  2,   0}, // #5449
  { 8,  1,   0}, // #5450
  {11,  2,   0}, // #5451
  {12,  2,   0}, // #5452
  {13,  3,   0}, // #5453
  {14,  2,   0}, // #5454
  {15,  1,   0}, // #5455
  {18,  1,   0}, // #5456
  {19,  3,   0}, // #5457
  {20,  3,   0}, // #5458
  {22,  3,   0}, // #5459
  {23,  3,   0}, // #5460
  { 3,  1,   0}, // #5461
  { 7,  1,   0}, // #5462
  {11,  1,   0}, // #5463
  {12,  2,   0}, // #5464
  {13,  1,   0}, // #5465
  {14,  1,   0}, // #5466
  {17,  1,   0}, // #5467
  {19,  1,   0}, // #5468
  {20,  1,   0}, // #5469
  {21,  1,   0}, // #5470
  {22,  1,   0}, // #5471
  {23,  3,   0}, // #5472
  { 2, 12,   0}, // #5473
  { 3,  1,   0}, // #5474
  {11,  1,   0}, // #5475
  {12,  1,   0}, // #5476
  {13,  1,   0}, // #5477
  {14,  1,   0}, // #5478
  {17,  1,   0}, // #5479
  {19,  1,   0}, // #5480
  {20,  1,   0}, // #5481
  {21,  1,   0}, // #5482
  {22,  1,   0}, // #5483
  {23,  2,   0}, // #5484
  { 2, 12,   0}, // #5485
  { 3,  1,   0}, // #5486
  {11,  1,   0}, // #5487
  {12,  1,   0}, // #5488
  {13,  1,   0}, // #5489
  {14,  1,   0}, // #5490
  {19,  1,   0}, // #5491
  {20,  1,   0}, // #5492
  {22,  1,   0}, // #5493
  {23,  1,   0}, // #5494
  { 2, 24,   0}, // #5495
  { 3,  2,   0}, // #5496
  { 8,  1,   0}, // #5497
  {11,  2,   0}, // #5498
  {12,  2,   0}, // #5499
  {13,  3,   0}, // #5500
  {14,  2,   0}, // #5501
  {15,  1,   0}, // #5502
  {17,  1,   0}, // #5503
  {18,  1,   0}, // #5504
  {19,  3,   0}, // #5505
  {20,  3,   0}, // #5506
  {21,  1,   0}, // #5507
  {22,  3,   0}, // #5508
  {23,  4,   0}, // #5509
  { 2, 24,   0}, // #5510
  { 3,  2,   0}, // #5511
  { 8,  1,   0}, // #5512
  {11,  2,   0}, // #5513
  {12,  2,   0}, // #5514
  {13,  3,   0}, // #5515
  {14,  2,   0}, // #5516
  {15,  1,   0}, // #5517
  {18,  1,   0}, // #5518
  {19,  3,   0}, // #5519
  {20,  3,   0}, // #5520
  {22,  3,   0}, // #5521
  {23,  3,   0}, // #5522
  { 2, 12,   0}, // #5523
  { 3,  2,   0}, // #5524
  { 8,  1,   0}, // #5525
  {11,  2,   0}, // #5526
  {12,  2,   0}, // #5527
  {13,  3,   0}, // #5528
  {14,  2,   0}, // #5529
  {15,  1,   0}, // #5530
  {17,  1,   0}, // #5531
  {18,  1,   0}, // #5532
  {19,  3,   0}, // #5533
  {20,  3,   0}, // #5534
  {21,  1,   0}, // #5535
  {22,  3,   0}, // #5536
  {23,  4,   0}, // #5537
  { 2, 12,   0}, // #5538
  { 3,  2,   0}, // #5539
  { 8,  1,   0}, // #5540
  {11,  2,   0}, // #5541
  {12,  2,   0}, // #5542
  {13,  3,   0}, // #5543
  {14,  2,   0}, // #5544
  {15,  1,   0}, // #5545
  {18,  1,   0}, // #5546
  {19,  3,   0}, // #5547
  {20,  3,   0}, // #5548
  {22,  3,   0}, // #5549
  {23,  3,   0}, // #5550
  { 4,  2,   0}, // #5551
  {11,  2,   0}, // #5552
  {14,  4,   0}, // #5553
  {15,  3,   0}, // #5554
  {16,  2,   0}, // #5555
  {17,  1,   0}, // #5556
  {19,  3,   0}, // #5557
  {20,  4,   0}, // #5558
  {21,  2,   0}, // #5559
  {22,  9,   0}, // #5560
  {23, 11,   0}, // #5561
  { 3,  2,   0}, // #5562
  { 4,  1,   0}, // #5563
  { 8,  2,   0}, // #5564
  { 9,  4,   0}, // #5565
  {11,  3,   0}, // #5566
  {12,  2,   0}, // #5567
  {13,  6,   0}, // #5568
  {14,  6,   0}, // #5569
  {15,  3,   0}, // #5570
  {16,  5,   0}, // #5571
  {18,  6,   0}, // #5572
  {19,  7,   0}, // #5573
  {20, 10,   0}, // #5574
  {22, 15,   0}, // #5575
  {23, 15,   0}, // #5576
  { 8,  2,   0}, // #5577
  {11,  1,   0}, // #5578
  {13,  2,   0}, // #5579
  {15,  2,   0}, // #5580
  {18,  2,   0}, // #5581
  {19,  3,   0}, // #5582
  {20,  2,   0}, // #5583
  {22,  3,   0}, // #5584
  {23,  3,   0}, // #5585
  { 3,  1,   0}, // #5586
  { 8,  1,   0}, // #5587
  {11,  2,   0}, // #5588
  {12,  1,   0}, // #5589
  {13,  2,   0}, // #5590
  {14,  1,   0}, // #5591
  {15,  1,   0}, // #5592
  {18,  1,   0}, // #5593
  {19,  3,   0}, // #5594
  {20,  2,   0}, // #5595
  {22,  3,   0}, // #5596
  {23,  3,   0}, // #5597
  { 7,  1,   0}, // #5598
  { 9,  1,   0}, // #5599
  {12,  1,   0}, // #5600
  {14,  2,   0}, // #5601
  {16,  1,   0}, // #5602
  {17,  1,   0}, // #5603
  {18,  1,   0}, // #5604
  {20,  2,   0}, // #5605
  {21,  2,   0}, // #5606
  {22,  5,   0}, // #5607
  {23,  8,   0}, // #5608
  { 3,  1,   0}, // #5609
  {11,  1,   0}, // #5610
  {12,  1,   0}, // #5611
  {13,  2,   0}, // #5612
  {14,  1,   0}, // #5613
  {17,  1,   0}, // #5614
  {19,  2,   0}, // #5615
  {20,  2,   0}, // #5616
  {21,  1,   0}, // #5617
  {22,  2,   0}, // #5618
  {23,  3,   0}, // #5619
  { 9,  1,   0}, // #5620
  {14,  1,   0}, // #5621
  {16,  1,   0}, // #5622
  {18,  1,   0}, // #5623
  {20,  1,   0}, // #5624
  {22,  4,   0}, // #5625
  {23,  4,   0}, // #5626
  { 9,  1,   0}, // #5627
  {14,  4,   0}, // #5628
  {15,  1,   0}, // #5629
  {16,  1,   0}, // #5630
  {18,  1,   0}, // #5631
  {19,  1,   0}, // #5632
  {20,  4,   0}, // #5633
  {22,  7,   0}, // #5634
  {23,  7,   0}, // #5635
  { 8,  1,   0}, // #5636
  { 9,  2,   0}, // #5637
  {13,  1,   0}, // #5638
  {14,  2,   0}, // #5639
  {15,  1,   0}, // #5640
  {16,  2,   0}, // #5641
  {18,  3,   0}, // #5642
  {19,  1,   0}, // #5643
  {20,  3,   0}, // #5644
  {22, 10,   0}, // #5645
  {23, 10,   0}, // #5646
  { 8,  6,   0}, // #5647
  {13,  9,   0}, // #5648
  {15,  6,   0}, // #5649
  {18,  6,   0}, // #5650
  {19,  9,   0}, // #5651
  {20,  9,   0}, // #5652
  {22, 15,   0}, // #5653
  {23, 15,   0}, // #5654
  { 4,  2,   0}, // #5655
  {11,  2,   0}, // #5656
  {14,  4,   0}, // #5657
  {15,  3,   0}, // #5658
  {16,  2,   0}, // #5659
  {19,  3,   0}, // #5660
  {20,  4,   0}, // #5661
  {22, 10,   0}, // #5662
  {23, 10,   0}, // #5663
  { 4,  1,   0}, // #5664
  { 9,  5,   0}, // #5665
  {11,  1,   0}, // #5666
  {13,  4,   0}, // #5667
  {14,  5,   0}, // #5668
  {15,  1,   0}, // #5669
  {16,  6,   0}, // #5670
  {18,  5,   0}, // #5671
  {19,  5,   0}, // #5672
  {20,  9,   0}, // #5673
  {22, 10,   0}, // #5674
  {23, 10,   0}, // #5675
  { 4,  1,   0}, // #5676
  { 9,  1,   0}, // #5677
  {11,  1,   0}, // #5678
  {14,  1,   0}, // #5679
  {15,  1,   0}, // #5680
  {16,  2,   0}, // #5681
  {18,  1,   0}, // #5682
  {19,  1,   0}, // #5683
  {20,  1,   0}, // #5684
  {22,  4,   0}, // #5685
  {23,  4,   0}, // #5686
  { 4,  1,   0}, // #5687
  {11,  1,   0}, // #5688
  {14,  5,   0}, // #5689
  {15,  2,   0}, // #5690
  {16,  1,   0}, // #5691
  {17,  1,   0}, // #5692
  {19,  2,   0}, // #5693
  {20,  5,   0}, // #5694
  {21,  2,   0}, // #5695
  {22,  8,   0}, // #5696
  {23, 10,   0}, // #5697
  { 4,  2,   0}, // #5698
  {11,  2,   0}, // #5699
  {14,  3,   0}, // #5700
  {15,  2,   0}, // #5701
  {16,  2,   0}, // #5702
  {19,  2,   0}, // #5703
  {20,  3,   0}, // #5704
  {22,  7,   0}, // #5705
  {23,  7,   0}, // #5706
  { 4,  1,   0}, // #5707
  {11,  1,   0}, // #5708
  {14,  5,   0}, // #5709
  {15,  2,   0}, // #5710
  {16,  1,   0}, // #5711
  {19,  2,   0}, // #5712
  {20,  5,   0}, // #5713
  {22,  9,   0}, // #5714
  {23,  9,   0}, // #5715
  { 4,  1,   0}, // #5716
  { 9,  8,   0}, // #5717
  {11,  1,   0}, // #5718
  {14,  8,   0}, // #5719
  {15,  1,   0}, // #5720
  {16,  9,   0}, // #5721
  {17,  1,   0}, // #5722
  {18,  8,   0}, // #5723
  {19,  1,   0}, // #5724
  {20,  8,   0}, // #5725
  {21,  1,   0}, // #5726
  {22, 30,   0}, // #5727
  {23, 31,   0}, // #5728
  { 7,  1,   0}, // #5729
  { 9, 10,   0}, // #5730
  {12,  1,   0}, // #5731
  {14, 10,   0}, // #5732
  {16, 10,   0}, // #5733
  {17,  1,   0}, // #5734
  {18, 10,   0}, // #5735
  {20, 10,   0}, // #5736
  {21,  2,   0}, // #5737
  {22, 36,   0}, // #5738
  {23, 39,   0}, // #5739
  { 7,  1,   0}, // #5740
  { 9, 11,   0}, // #5741
  {12,  1,   0}, // #5742
  {14, 11,   0}, // #5743
  {16, 11,   0}, // #5744
  {17,  1,   0}, // #5745
  {18, 11,   0}, // #5746
  {20, 11,   0}, // #5747
  {21,  2,   0}, // #5748
  {22, 37,   0}, // #5749
  {23, 40,   0}, // #5750
  { 4,  1,   0}, // #5751
  { 7,  1,   0}, // #5752
  { 8,  2,   0}, // #5753
  { 9,  3,   0}, // #5754
  {11,  1,   0}, // #5755
  {12,  1,   0}, // #5756
  {13,  2,   0}, // #5757
  {14,  3,   0}, // #5758
  {15,  4,   0}, // #5759
  {16,  4,   0}, // #5760
  {17,  1,   0}, // #5761
  {18,  5,   0}, // #5762
  {19,  4,   0}, // #5763
  {20,  5,   0}, // #5764
  {21,  2,   0}, // #5765
  {22, 15,   0}, // #5766
  {23, 18,   0}, // #5767
  { 3,  2,   0}, // #5768
  {11,  2,   0}, // #5769
  {12,  2,   0}, // #5770
  {13,  7,   0}, // #5771
  {14, 12,   0}, // #5772
  {17,  8,   0}, // #5773
  {19,  7,   0}, // #5774
  {20, 17,   0}, // #5775
  {21,  8,   0}, // #5776
  {22, 56,   0}, // #5777
  {23, 64,   0}, // #5778
  { 3,  9,   0}, // #5779
  { 4,  1,   0}, // #5780
  { 7, 11,   0}, // #5781
  { 8, 16,   0}, // #5782
  { 9,  1,   0}, // #5783
  {11, 10,   0}, // #5784
  {12, 20,   0}, // #5785
  {13, 25,   0}, // #5786
  {14, 31,   0}, // #5787
  {15, 17,   0}, // #5788
  {16,  2,   0}, // #5789
  {18, 17,   0}, // #5790
  {19, 26,   0}, // #5791
  {20, 47,   0}, // #5792
  {21, 11,   0}, // #5793
  {22, 78,   0}, // #5794
  {23, 100,   0}, // #5795
  { 3,  1,   0}, // #5796
  { 8,  1,   0}, // #5797
  {11,  1,   0}, // #5798
  {12,  1,   0}, // #5799
  {13,  2,   0}, // #5800
  {14,  1,   0}, // #5801
  {15,  1,   0}, // #5802
  {17,  2,   0}, // #5803
  {18,  1,   0}, // #5804
  {19,  3,   0}, // #5805
  {20,  2,   0}, // #5806
  {21,  2,   0}, // #5807
  {22,  3,   0}, // #5808
  {23,  5,   0}, // #5809
  { 3,  1,   0}, // #5810
  { 8,  1,   0}, // #5811
  {11,  1,   0}, // #5812
  {12,  1,   0}, // #5813
  {13,  2,   0}, // #5814
  {14,  1,   0}, // #5815
  {15,  1,   0}, // #5816
  {17,  4,   0}, // #5817
  {18,  1,   0}, // #5818
  {19,  3,   0}, // #5819
  {20,  2,   0}, // #5820
  {21,  4,   0}, // #5821
  {22,  3,   0}, // #5822
  {23,  7,   0}, // #5823
  { 3,  1,   0}, // #5824
  { 8,  1,   0}, // #5825
  {11,  1,   0}, // #5826
  {12,  1,   0}, // #5827
  {13,  2,   0}, // #5828
  {14,  1,   0}, // #5829
  {15,  1,   0}, // #5830
  {17,  8,   0}, // #5831
  {18,  1,   0}, // #5832
  {19,  3,   0}, // #5833
  {20,  2,   0}, // #5834
  {21,  8,   0}, // #5835
  {22,  3,   0}, // #5836
  {23, 11,   0}, // #5837
  { 8,  5,   0}, // #5838
  {11,  5,   0}, // #5839
  {13,  5,   0}, // #5840
  {15,  5,   0}, // #5841
  {18,  5,   0}, // #5842
  {19, 14,   0}, // #5843
  {20,  5,   0}, // #5844
  {22, 14,   0}, // #5845
  {23, 14,   0}, // #5846
  { 8,  9,   0}, // #5847
  {11,  7,   0}, // #5848
  {13,  9,   0}, // #5849
  {15,  9,   0}, // #5850
  {18,  9,   0}, // #5851
  {19, 21,   0}, // #5852
  {20,  9,   0}, // #5853
  {22, 21,   0}, // #5854
  {23, 21,   0}, // #5855
  { 8, 17,   0}, // #5856
  {11, 11,   0}, // #5857
  {13, 17,   0}, // #5858
  {15, 17,   0}, // #5859
  {18, 17,   0}, // #5860
  {19, 35,   0}, // #5861
  {20, 17,   0}, // #5862
  {22, 35,   0}, // #5863
  {23, 35,   0}, // #5864
  { 8,  2,   0}, // #5865
  {11,  1,   0}, // #5866
  {13,  2,   0}, // #5867
  {15,  2,   0}, // #5868
  {17,  1,   0}, // #5869
  {18,  2,   0}, // #5870
  {19,  3,   0}, // #5871
  {20,  2,   0}, // #5872
  {21,  1,   0}, // #5873
  {22,  3,   0}, // #5874
  {23,  4,   0}, // #5875
  { 7,  2,   0}, // #5876
  {12,  2,   0}, // #5877
  {15,  1,   0}, // #5878
  {19,  1,   0}, // #5879
  {21,  2,   0}, // #5880
  {22,  1,   0}, // #5881
  {23,  5,   0}, // #5882
  { 7,  1,   0}, // #5883
  {11,  1,   0}, // #5884
  {12,  1,   0}, // #5885
  {19,  1,   0}, // #5886
  {21,  1,   0}, // #5887
  {22,  1,   0}, // #5888
  {23,  3,   0}, // #5889
  { 7,  1,   0}, // #5890
  { 8,  2,   0}, // #5891
  {12,  1,   0}, // #5892
  {13,  2,   0}, // #5893
  {15,  2,   0}, // #5894
  {18,  2,   0}, // #5895
  {19,  2,   0}, // #5896
  {20,  2,   0}, // #5897
  {21,  1,   0}, // #5898
  {22,  2,   0}, // #5899
  {23,  4,   0}, // #5900
  { 8,  1,   0}, // #5901
  {13,  1,   0}, // #5902
  {15,  1,   0}, // #5903
  {17,  1,   0}, // #5904
  {18,  1,   0}, // #5905
  {19,  1,   0}, // #5906
  {20,  1,   0}, // #5907
  {21,  1,   0}, // #5908
  {22,  2,   0}, // #5909
  {23,  3,   0}, // #5910
  { 3,  1,   0}, // #5911
  { 7,  2,   0}, // #5912
  {11,  1,   0}, // #5913
  {12,  3,   0}, // #5914
  {13,  1,   0}, // #5915
  {14,  1,   0}, // #5916
  {19,  1,   0}, // #5917
  {20,  1,   0}, // #5918
  {21,  2,   0}, // #5919
  {22,  3,   0}, // #5920
  {23,  7,   0}, // #5921
  { 3,  1,   0}, // #5922
  { 7,  4,   0}, // #5923
  {11,  1,   0}, // #5924
  {12,  5,   0}, // #5925
  {13,  1,   0}, // #5926
  {14,  1,   0}, // #5927
  {19,  1,   0}, // #5928
  {20,  1,   0}, // #5929
  {21,  4,   0}, // #5930
  {22,  3,   0}, // #5931
  {23, 11,   0}, // #5932
  { 3,  1,   0}, // #5933
  { 7,  8,   0}, // #5934
  {11,  1,   0}, // #5935
  {12,  9,   0}, // #5936
  {13,  1,   0}, // #5937
  {14,  1,   0}, // #5938
  {19,  1,   0}, // #5939
  {20,  1,   0}, // #5940
  {21,  8,   0}, // #5941
  {22,  3,   0}, // #5942
  {23, 19,   0}, // #5943
  { 3,  1,   0}, // #5944
  { 7, 16,   0}, // #5945
  { 8,  1,   0}, // #5946
  {11,  1,   0}, // #5947
  {12, 17,   0}, // #5948
  {13,  2,   0}, // #5949
  {14,  1,   0}, // #5950
  {15,  1,   0}, // #5951
  {18,  1,   0}, // #5952
  {19,  2,   0}, // #5953
  {20,  2,   0}, // #5954
  {21, 16,   0}, // #5955
  {22,  4,   0}, // #5956
  {23, 36,   0}, // #5957
  { 3,  1,   0}, // #5958
  { 7,  2,   0}, // #5959
  { 8,  1,   0}, // #5960
  {11,  1,   0}, // #5961
  {12,  3,   0}, // #5962
  {13,  2,   0}, // #5963
  {14,  1,   0}, // #5964
  {15,  1,   0}, // #5965
  {18,  1,   0}, // #5966
  {19,  2,   0}, // #5967
  {20,  2,   0}, // #5968
  {21,  2,   0}, // #5969
  {22,  4,   0}, // #5970
  {23,  8,   0}, // #5971
  { 3,  1,   0}, // #5972
  { 7,  4,   0}, // #5973
  { 8,  1,   0}, // #5974
  {11,  1,   0}, // #5975
  {12,  5,   0}, // #5976
  {13,  2,   0}, // #5977
  {14,  1,   0}, // #5978
  {15,  1,   0}, // #5979
  {18,  1,   0}, // #5980
  {19,  2,   0}, // #5981
  {20,  2,   0}, // #5982
  {21,  4,   0}, // #5983
  {22,  4,   0}, // #5984
  {23, 12,   0}, // #5985
  { 3,  1,   0}, // #5986
  { 7,  8,   0}, // #5987
  { 8,  1,   0}, // #5988
  {11,  1,   0}, // #5989
  {12,  9,   0}, // #5990
  {13,  2,   0}, // #5991
  {14,  1,   0}, // #5992
  {15,  1,   0}, // #5993
  {18,  1,   0}, // #5994
  {19,  2,   0}, // #5995
  {20,  2,   0}, // #5996
  {21,  8,   0}, // #5997
  {22,  4,   0}, // #5998
  {23, 20,   0}, // #5999
  {11,  3,   0}, // #6000
  {19,  3,   0}, // #6001
  {22,  3,   0}, // #6002
  {23,  3,   0}, // #6003
  {13,  3,   0}, // #6004
  {19,  3,   0}, // #6005
  {20,  3,   0}, // #6006
  {22,  3,   0}, // #6007
  {23,  3,   0}, // #6008
  { 4,  1,   0}, // #6009
  { 8,  2,   0}, // #6010
  {11,  3,   0}, // #6011
  {13,  2,   0}, // #6012
  {15,  3,   0}, // #6013
  {16,  1,   0}, // #6014
  {17,  1,   0}, // #6015
  {18,  2,   0}, // #6016
  {19,  7,   0}, // #6017
  {20,  2,   0}, // #6018
  {21,  1,   0}, // #6019
  {22,  7,   0}, // #6020
  {23,  8,   0}, // #6021
  {11,  3,   0}, // #6022
  {17,  1,   0}, // #6023
  {19,  3,   0}, // #6024
  {21,  1,   0}, // #6025
  {22,  3,   0}, // #6026
  {23,  4,   0}, // #6027
  {13,  3,   0}, // #6028
  {17,  1,   0}, // #6029
  {19,  3,   0}, // #6030
  {20,  3,   0}, // #6031
  {21,  1,   0}, // #6032
  {22,  3,   0}, // #6033
  {23,  4,   0}, // #6034
  { 3,  1,   0}, // #6035
  {11,  1,   0}, // #6036
  {12,  1,   0}, // #6037
  {13,  1,   0}, // #6038
  {14,  1,   0}, // #6039
  {17,  2,   0}, // #6040
  {19,  2,   0}, // #6041
  {20,  1,   0}, // #6042
  {21,  2,   0}, // #6043
  {22,  3,   0}, // #6044
  {23,  5,   0}, // #6045
  { 3,  1,   0}, // #6046
  {11,  1,   0}, // #6047
  {12,  1,   0}, // #6048
  {13,  1,   0}, // #6049
  {14,  1,   0}, // #6050
  {17,  4,   0}, // #6051
  {19,  2,   0}, // #6052
  {20,  1,   0}, // #6053
  {21,  4,   0}, // #6054
  {22,  3,   0}, // #6055
  {23,  7,   0}, // #6056
  { 3,  1,   0}, // #6057
  {11,  1,   0}, // #6058
  {12,  1,   0}, // #6059
  {13,  1,   0}, // #6060
  {14,  1,   0}, // #6061
  {17,  8,   0}, // #6062
  {19,  2,   0}, // #6063
  {20,  1,   0}, // #6064
  {21,  8,   0}, // #6065
  {22,  3,   0}, // #6066
  {23, 11,   0}, // #6067
  { 3,  1,   0}, // #6068
  {11,  1,   0}, // #6069
  {12,  1,   0}, // #6070
  {13,  1,   0}, // #6071
  {14,  1,   0}, // #6072
  {17, 16,   0}, // #6073
  {19,  2,   0}, // #6074
  {20,  1,   0}, // #6075
  {21, 16,   0}, // #6076
  {22,  3,   0}, // #6077
  {23, 19,   0}, // #6078
  { 8,  5,   0}, // #6079
  {11,  5,   0}, // #6080
  {13,  5,   0}, // #6081
  {15,  5,   0}, // #6082
  {17,  1,   0}, // #6083
  {18,  5,   0}, // #6084
  {19, 14,   0}, // #6085
  {20,  5,   0}, // #6086
  {21,  1,   0}, // #6087
  {22, 14,   0}, // #6088
  {23, 15,   0}, // #6089
  { 8,  9,   0}, // #6090
  {11,  7,   0}, // #6091
  {13,  9,   0}, // #6092
  {15,  9,   0}, // #6093
  {17,  1,   0}, // #6094
  {18,  9,   0}, // #6095
  {19, 21,   0}, // #6096
  {20,  9,   0}, // #6097
  {21,  1,   0}, // #6098
  {22, 21,   0}, // #6099
  {23, 22,   0}, // #6100
  { 8, 17,   0}, // #6101
  {11, 11,   0}, // #6102
  {13, 17,   0}, // #6103
  {15, 17,   0}, // #6104
  {17,  1,   0}, // #6105
  {18, 17,   0}, // #6106
  {19, 35,   0}, // #6107
  {20, 17,   0}, // #6108
  {21,  1,   0}, // #6109
  {22, 35,   0}, // #6110
  {23, 36,   0}, // #6111
  {14,  2,   0}, // #6112
  {17,  1,   0}, // #6113
  {20,  2,   0}, // #6114
  {21,  1,   0}, // #6115
  {22,  2,   0}, // #6116
  {23,  3,   0}, // #6117
  { 7,  1,   0}, // #6118
  {12,  1,   0}, // #6119
  {14,  2,   0}, // #6120
  {20,  2,   0}, // #6121
  {21,  1,   0}, // #6122
  {22,  2,   0}, // #6123
  {23,  4,   0}, // #6124
  { 4,  1,   0}, // #6125
  { 7,  1,   0}, // #6126
  { 9,  1,   0}, // #6127
  {11,  1,   0}, // #6128
  {12,  1,   0}, // #6129
  { 6,  1,   0}, // #6130
  { 8,  1,   0}, // #6131
  { 9,  1,   0}, // #6132
  {11,  1,   0}, // #6133
  {12,  1,   0}, // #6134
  { 5,  1,   0}, // #6135
  { 6,  2,   0}, // #6136
  { 8,  2,   0}, // #6137
  { 9,  2,   0}, // #6138
  {10,  2,   0}, // #6139
  {11,  3,   0}, // #6140
  {12,  6,   0}, // #6141
  { 6,  1,   0}, // #6142
  { 8,  1,   0}, // #6143
  { 9,  1,   0}, // #6144
  {10,  1,   0}, // #6145
  {11,  1,   0}, // #6146
  {12,  2,   0}, // #6147
  { 5,  1,   0}, // #6148
  {10,  1,   0}, // #6149
  {12,  2,   0}, // #6150
  {10,  1,   0}, // #6151
  {12,  1,   0}, // #6152
  { 5,  1,   0}, // #6153
  {10,  2,   0}, // #6154
  {11,  1,   0}, // #6155
  {12,  4,   0}, // #6156
  { 5,  1,   0}, // #6157
  {10,  2,   0}, // #6158
  {11,  3,   0}, // #6159
  {12,  6,   0}, // #6160
  { 8,  1,   0}, // #6161
  {10,  1,   0}, // #6162
  {11,  2,   0}, // #6163
  {12,  3,   0}, // #6164
  { 4,  1,   0}, // #6165
  { 7,  1,   0}, // #6166
  { 9,  1,   0}, // #6167
  {10,  1,   0}, // #6168
  {11,  1,   0}, // #6169
  {12,  2,   0}, // #6170
  { 6,  1,   0}, // #6171
  { 8,  1,   0}, // #6172
  { 9,  1,   0}, // #6173
  {10,  1,   0}, // #6174
  {11,  2,   0}, // #6175
  {12,  3,   0}, // #6176
  { 6,  1,   0}, // #6177
  { 8,  1,   0}, // #6178
  { 9,  1,   0}, // #6179
  {11,  2,   0}, // #6180
  {12,  2,   0}, // #6181
  { 6,  2,   0}, // #6182
  { 8,  2,   0}, // #6183
  { 9,  2,   0}, // #6184
  {10,  1,   0}, // #6185
  {11,  2,   0}, // #6186
  {12,  3,   0}, // #6187
  { 6,  2,   0}, // #6188
  { 8,  2,   0}, // #6189
  { 9,  2,   0}, // #6190
  {11,  2,   0}, // #6191
  {12,  2,   0}, // #6192
  {10,  1,   0}, // #6193
  {11, 10,   0}, // #6194
  {12, 11,   0}, // #6195
  {11, 11,   0}, // #6196
  {12, 11,   0}, // #6197
  { 4,  1,   0}, // #6198
  { 7,  1,   0}, // #6199
  { 8,  1,   0}, // #6200
  { 9,  1,   0}, // #6201
  {10,  1,   0}, // #6202
  {11,  2,   0}, // #6203
  {12,  3,   0}, // #6204
  { 4,  1,   0}, // #6205
  { 7,  1,   0}, // #6206
  { 8,  1,   0}, // #6207
  { 9,  1,   0}, // #6208
  {11,  2,   0}, // #6209
  {12,  2,   0}, // #6210
  { 8,  1,   0}, // #6211
  {10,  1,   0}, // #6212
  {11,  1,   0}, // #6213
  {12,  2,   0}, // #6214
  { 8,  2,   0}, // #6215
  {10,  1,   0}, // #6216
  {11,  2,   0}, // #6217
  {12,  3,   0}, // #6218
  { 8,  2,   0}, // #6219
  {11,  2,   0}, // #6220
  {12,  2,   0}, // #6221
  { 5,  1,   0}, // #6222
  { 6,  1,   0}, // #6223
  { 8,  2,   0}, // #6224
  { 9,  1,   0}, // #6225
  {10,  2,   0}, // #6226
  {11,  3,   0}, // #6227
  {12,  6,   0}, // #6228
  { 5,  1,   0}, // #6229
  { 8,  1,   0}, // #6230
  {10,  2,   0}, // #6231
  {11,  1,   0}, // #6232
  {12,  4,   0}, // #6233
  { 6,  2,   0}, // #6234
  { 8,  3,   0}, // #6235
  { 9,  2,   0}, // #6236
  {11,  3,   0}, // #6237
  {12,  3,   0}, // #6238
  { 8,  1,   0}, // #6239
  {11,  4,   0}, // #6240
  {12,  4,   0}, // #6241
  { 4,  1,   0}, // #6242
  { 6,  1,   0}, // #6243
  { 7,  1,   0}, // #6244
  { 8,  1,   0}, // #6245
  { 9,  2,   0}, // #6246
  {10,  1,   0}, // #6247
  {11,  2,   0}, // #6248
  {12,  3,   0}, // #6249
  { 4,  1,   0}, // #6250
  { 6,  1,   0}, // #6251
  { 7,  1,   0}, // #6252
  { 8,  1,   0}, // #6253
  { 9,  2,   0}, // #6254
  {11,  2,   0}, // #6255
  {12,  2,   0}, // #6256
  { 3,  1,   0}, // #6257
  { 7,  1,   0}, // #6258
  { 8,  1,   0}, // #6259
  {10,  1,   0}, // #6260
  {11,  1,   0}, // #6261
  {12,  2,   0}, // #6262
  { 3,  1,   0}, // #6263
  { 6,  1,   0}, // #6264
  { 7,  1,   0}, // #6265
  { 8,  2,   0}, // #6266
  { 9,  1,   0}, // #6267
  {11,  2,   0}, // #6268
  {12,  2,   0}, // #6269
  { 3,  1,   0}, // #6270
  { 4,  1,   0}, // #6271
  { 7,  2,   0}, // #6272
  { 8,  1,   0}, // #6273
  { 9,  1,   0}, // #6274
  {10,  1,   0}, // #6275
  {11,  2,   0}, // #6276
  {12,  3,   0}, // #6277
  { 3,  1,   0}, // #6278
  { 4,  1,   0}, // #6279
  { 7,  2,   0}, // #6280
  { 8,  1,   0}, // #6281
  { 9,  1,   0}, // #6282
  {11,  2,   0}, // #6283
  {12,  2,   0}, // #6284
  { 4,  1,   0}, // #6285
  { 6,  2,   0}, // #6286
  { 7,  1,   0}, // #6287
  { 8,  2,   0}, // #6288
  { 9,  3,   0}, // #6289
  {11,  3,   0}, // #6290
  {12,  3,   0}, // #6291
  { 3,  1,   0}, // #6292
  { 7,  1,   0}, // #6293
  { 8,  1,   0}, // #6294
  {11,  1,   0}, // #6295
  {12,  1,   0}, // #6296
  { 1, 10,   0}, // #6297
  { 3,  1,   0}, // #6298
  { 7,  1,   0}, // #6299
  { 8,  1,   0}, // #6300
  {10,  1,   0}, // #6301
  {11,  1,   0}, // #6302
  {12,  2,   0}, // #6303
  { 1, 10,   0}, // #6304
  { 3,  1,   0}, // #6305
  { 7,  1,   0}, // #6306
  { 8,  1,   0}, // #6307
  {11,  1,   0}, // #6308
  {12,  1,   0}, // #6309
  { 2, 22,   0}, // #6310
  { 3,  1,   0}, // #6311
  { 7,  1,   0}, // #6312
  { 8,  1,   0}, // #6313
  {10,  1,   0}, // #6314
  {11,  1,   0}, // #6315
  {12,  2,   0}, // #6316
  { 2, 22,   0}, // #6317
  { 3,  1,   0}, // #6318
  { 7,  1,   0}, // #6319
  { 8,  1,   0}, // #6320
  {11,  1,   0}, // #6321
  {12,  1,   0}, // #6322
  { 2, 14,   0}, // #6323
  { 3,  1,   0}, // #6324
  { 7,  1,   0}, // #6325
  { 8,  1,   0}, // #6326
  {10,  1,   0}, // #6327
  {11,  1,   0}, // #6328
  {12,  2,   0}, // #6329
  { 2, 14,   0}, // #6330
  { 3,  1,   0}, // #6331
  { 7,  1,   0}, // #6332
  { 8,  1,   0}, // #6333
  {11,  1,   0}, // #6334
  {12,  1,   0}, // #6335
  { 3,  1,   0}, // #6336
  { 4,  1,   0}, // #6337
  { 6,  1,   0}, // #6338
  { 7,  2,   0}, // #6339
  { 8,  2,   0}, // #6340
  { 9,  2,   0}, // #6341
  {10,  1,   0}, // #6342
  {11,  3,   0}, // #6343
  {12,  4,   0}, // #6344
  { 3,  1,   0}, // #6345
  { 4,  1,   0}, // #6346
  { 6,  1,   0}, // #6347
  { 7,  2,   0}, // #6348
  { 8,  2,   0}, // #6349
  { 9,  2,   0}, // #6350
  {11,  3,   0}, // #6351
  {12,  3,   0}, // #6352
  { 3,  1,   0}, // #6353
  { 4,  2,   0}, // #6354
  { 6,  1,   0}, // #6355
  { 7,  3,   0}, // #6356
  { 8,  2,   0}, // #6357
  { 9,  3,   0}, // #6358
  {10,  1,   0}, // #6359
  {11,  4,   0}, // #6360
  {12,  5,   0}, // #6361
  { 3,  1,   0}, // #6362
  { 4,  2,   0}, // #6363
  { 6,  1,   0}, // #6364
  { 7,  3,   0}, // #6365
  { 8,  2,   0}, // #6366
  { 9,  3,   0}, // #6367
  {11,  4,   0}, // #6368
  {12,  4,   0}, // #6369
  { 5,  1,   0}, // #6370
  { 9,  1,   0}, // #6371
  {10,  1,   0}, // #6372
  {11,  1,   0}, // #6373
  {12,  3,   0}, // #6374
  { 3,  1,   0}, // #6375
  { 7,  1,   0}, // #6376
  { 8,  1,   0}, // #6377
  { 9,  1,   0}, // #6378
  {11,  2,   0}, // #6379
  {12,  2,   0}, // #6380
  {11, 31,   0}, // #6381
  {12, 31,   0}, // #6382
  { 4,  1,   0}, // #6383
  { 6,  2,   0}, // #6384
  { 7,  1,   0}, // #6385
  { 8,  2,   0}, // #6386
  { 9,  3,   0}, // #6387
  {10,  1,   0}, // #6388
  {11,  3,   0}, // #6389
  {12,  4,   0}, // #6390
  { 4,  1,   0}, // #6391
  { 7,  1,   0}, // #6392
  { 8,  1,   0}, // #6393
  { 9,  1,   0}, // #6394
  {10,  1,   0}, // #6395
  {11,  4,   0}, // #6396
  {12,  5,   0}, // #6397
  { 4,  1,   0}, // #6398
  { 7,  1,   0}, // #6399
  { 8,  1,   0}, // #6400
  { 9,  1,   0}, // #6401
  {11,  4,   0}, // #6402
  {12,  4,   0}, // #6403
  { 4,  1,   0}, // #6404
  { 7,  1,   0}, // #6405
  { 9,  1,   0}, // #6406
  {10,  1,   0}, // #6407
  {11,  2,   0}, // #6408
  {12,  3,   0}, // #6409
  { 4,  1,   0}, // #6410
  { 7,  1,   0}, // #6411
  { 9,  1,   0}, // #6412
  {11,  2,   0}, // #6413
  {12,  2,   0}, // #6414
  { 4,  1,   0}, // #6415
  { 7,  1,   0}, // #6416
  { 8,  1,   0}, // #6417
  { 9,  1,   0}, // #6418
  {10,  1,   0}, // #6419
  {11,  3,   0}, // #6420
  {12,  4,   0}, // #6421
  { 4,  1,   0}, // #6422
  { 7,  1,   0}, // #6423
  { 8,  1,   0}, // #6424
  { 9,  1,   0}, // #6425
  {11,  3,   0}, // #6426
  {12,  3,   0}, // #6427
  { 3,  1,   0}, // #6428
  { 5,  1,   0}, // #6429
  { 6,  1,   0}, // #6430
  { 7,  1,   0}, // #6431
  { 8,  2,   0}, // #6432
  { 9,  1,   0}, // #6433
  {10,  1,   0}, // #6434
  {11,  2,   0}, // #6435
  {12,  4,   0}, // #6436
  { 6,  1,   0}, // #6437
  { 8,  1,   0}, // #6438
  { 9,  2,   0}, // #6439
  {11,  2,   0}, // #6440
  {12,  2,   0}, // #6441
  { 3,  1,   0}, // #6442
  { 7,  1,   0}, // #6443
  { 8,  1,   0}, // #6444
  { 9,  2,   0}, // #6445
  {10,  1,   0}, // #6446
  {11,  3,   0}, // #6447
  {12,  4,   0}, // #6448
  { 3,  1,   0}, // #6449
  { 7,  1,   0}, // #6450
  { 8,  1,   0}, // #6451
  { 9,  2,   0}, // #6452
  {11,  3,   0}, // #6453
  {12,  3,   0}, // #6454
  {10,  1,   0}, // #6455
  {11, 17,   0}, // #6456
  {12, 18,   0}, // #6457
  {11, 18,   0}, // #6458
  {12, 18,   0}, // #6459
  {10,  1,   0}, // #6460
  {11,  7,   0}, // #6461
  {12,  8,   0}, // #6462
  {11,  8,   0}, // #6463
  {12,  8,   0}, // #6464
  { 3,  3,   0}, // #6465
  { 7,  3,   0}, // #6466
  { 8,  3,   0}, // #6467
  {10,  1,   0}, // #6468
  {11,  3,   0}, // #6469
  {12,  4,   0}, // #6470
  { 3,  3,   0}, // #6471
  { 7,  3,   0}, // #6472
  { 8,  3,   0}, // #6473
  {11,  3,   0}, // #6474
  {12,  3,   0}, // #6475
  { 5,  1,   0}, // #6476
  {10,  2,   0}, // #6477
  {12,  3,   0}, // #6478
  { 3,  1,   0}, // #6479
  { 7,  1,   0}, // #6480
  { 8,  1,   0}, // #6481
  { 9,  1,   0}, // #6482
  {10,  1,   0}, // #6483
  {11,  2,   0}, // #6484
  {12,  3,   0}, // #6485
  { 3,  1,   0}, // #6486
  { 6,  1,   0}, // #6487
  { 7,  1,   0}, // #6488
  { 8,  2,   0}, // #6489
  { 9,  1,   0}, // #6490
  {10,  1,   0}, // #6491
  {11,  2,   0}, // #6492
  {12,  3,   0}, // #6493
  { 5,  1,   0}, // #6494
  { 8,  2,   0}, // #6495
  {10,  2,   0}, // #6496
  {11,  2,   0}, // #6497
  {12,  5,   0}, // #6498
  { 5,  1,   0}, // #6499
  { 8,  3,   0}, // #6500
  {10,  2,   0}, // #6501
  {11,  3,   0}, // #6502
  {12,  6,   0}, // #6503
  { 5,  1,   0}, // #6504
  { 8,  1,   0}, // #6505
  {10,  1,   0}, // #6506
  {11,  1,   0}, // #6507
  {12,  3,   0}, // #6508
  { 5,  1,   0}, // #6509
  { 8,  3,   0}, // #6510
  {10,  2,   0}, // #6511
  {11,  4,   0}, // #6512
  {12,  7,   0}, // #6513
  { 5,  1,   0}, // #6514
  { 8,  1,   0}, // #6515
  {10,  2,   0}, // #6516
  {11,  2,   0}, // #6517
  {12,  5,   0}, // #6518
  { 2, 21,   0}, // #6519
  { 3,  1,   0}, // #6520
  { 7,  1,   0}, // #6521
  { 8,  1,   0}, // #6522
  {10,  1,   0}, // #6523
  {11,  1,   0}, // #6524
  {12,  2,   0}, // #6525
  { 2, 21,   0}, // #6526
  { 3,  1,   0}, // #6527
  { 7,  1,   0}, // #6528
  { 8,  1,   0}, // #6529
  {11,  1,   0}, // #6530
  {12,  1,   0}, // #6531
  { 2, 24,   0}, // #6532
  { 3,  1,   0}, // #6533
  { 7,  1,   0}, // #6534
  { 8,  1,   0}, // #6535
  {11,  1,   0}, // #6536
  {12,  1,   0}, // #6537
  { 7,  1,   0}, // #6538
  {10,  1,   0}, // #6539
  {11,  1,   0}, // #6540
  {12,  2,   0}, // #6541
  { 4,  1,   0}, // #6542
  { 5,  1,   0}, // #6543
  { 7,  1,   0}, // #6544
  { 9,  1,   0}, // #6545
  {10,  1,   0}, // #6546
  {11,  1,   0}, // #6547
  {12,  3,   0}, // #6548
  { 2, 44,   0}, // #6549
  { 3,  2,   0}, // #6550
  { 7,  2,   0}, // #6551
  { 8,  3,   0}, // #6552
  {10,  1,   0}, // #6553
  {11,  3,   0}, // #6554
  {12,  4,   0}, // #6555
  { 2, 44,   0}, // #6556
  { 3,  2,   0}, // #6557
  { 7,  2,   0}, // #6558
  { 8,  3,   0}, // #6559
  {11,  3,   0}, // #6560
  {12,  3,   0}, // #6561
  { 2, 28,   0}, // #6562
  { 3,  2,   0}, // #6563
  { 7,  2,   0}, // #6564
  { 8,  3,   0}, // #6565
  {10,  1,   0}, // #6566
  {11,  3,   0}, // #6567
  {12,  4,   0}, // #6568
  { 2, 28,   0}, // #6569
  { 3,  2,   0}, // #6570
  { 7,  2,   0}, // #6571
  { 8,  3,   0}, // #6572
  {11,  3,   0}, // #6573
  {12,  3,   0}, // #6574
  { 5,  1,   0}, // #6575
  { 7,  1,   0}, // #6576
  {10,  1,   0}, // #6577
  {11,  1,   0}, // #6578
  {12,  3,   0}, // #6579
  { 8,  7,   0}, // #6580
  {10,  4,   0}, // #6581
  {11,  7,   0}, // #6582
  {12, 11,   0}, // #6583
  { 5,  1,   0}, // #6584
  {10,  2,   0}, // #6585
  {11,  2,   0}, // #6586
  {12,  5,   0}, // #6587
  { 6,  1,   0}, // #6588
  { 7,  1,   0}, // #6589
  { 8,  1,   0}, // #6590
  { 9,  1,   0}, // #6591
  {10,  1,   0}, // #6592
  {11,  2,   0}, // #6593
  {12,  3,   0}, // #6594
  { 5,  1,   0}, // #6595
  { 6,  2,   0}, // #6596
  { 8,  2,   0}, // #6597
  { 9,  2,   0}, // #6598
  {10,  2,   0}, // #6599
  {11,  2,   0}, // #6600
  {12,  5,   0}, // #6601
  { 4,  1,   0}, // #6602
  { 5,  1,   0}, // #6603
  { 7,  1,   0}, // #6604
  { 9,  1,   0}, // #6605
  {10,  2,   0}, // #6606
  {11,  1,   0}, // #6607
  {12,  4,   0}, // #6608
  { 4,  1,   0}, // #6609
  { 6,  3,   0}, // #6610
  { 7,  1,   0}, // #6611
  { 8,  5,   0}, // #6612
  { 9,  4,   0}, // #6613
  {11, 12,   0}, // #6614
  {12, 12,   0}, // #6615
  { 5,  1,   0}, // #6616
  { 6,  1,   0}, // #6617
  { 8,  1,   0}, // #6618
  { 9,  1,   0}, // #6619
  {10,  2,   0}, // #6620
  {11,  1,   0}, // #6621
  {12,  4,   0}, // #6622
  { 6,  1,   0}, // #6623
  { 8,  1,   0}, // #6624
  { 9,  1,   0}, // #6625
  {11,  4,   0}, // #6626
  {12,  4,   0}, // #6627
  { 4,  1,   0}, // #6628
  { 6,  3,   0}, // #6629
  { 7,  1,   0}, // #6630
  { 8,  3,   0}, // #6631
  { 9,  4,   0}, // #6632
  {11,  8,   0}, // #6633
  {12,  8,   0}, // #6634
  { 5,  1,   0}, // #6635
  { 6,  2,   0}, // #6636
  { 7,  1,   0}, // #6637
  { 8,  2,   0}, // #6638
  { 9,  2,   0}, // #6639
  {10,  1,   0}, // #6640
  {11,  3,   0}, // #6641
  {12,  5,   0}, // #6642
  { 3,  1,   0}, // #6643
  { 7,  1,   0}, // #6644
  { 8,  1,   0}, // #6645
  {11,  2,   0}, // #6646
  {12,  2,   0}, // #6647
  { 8,  2,   0}, // #6648
  {11,  3,   0}, // #6649
  {12,  3,   0}, // #6650
  { 4,  1,   0}, // #6651
  { 6,  1,   0}, // #6652
  { 7,  1,   0}, // #6653
  { 8,  5,   0}, // #6654
  { 9,  2,   0}, // #6655
  {11,  8,   0}, // #6656
  {12,  8,   0}, // #6657
  { 8,  8,   0}, // #6658
  {11,  8,   0}, // #6659
  {12,  8,   0}, // #6660
  { 5,  1,   0}, // #6661
  { 6,  1,   0}, // #6662
  { 8,  1,   0}, // #6663
  { 9,  1,   0}, // #6664
  {10,  1,   0}, // #6665
  {11,  1,   0}, // #6666
  {12,  3,   0}, // #6667
  { 5,  1,   0}, // #6668
  {10,  1,   0}, // #6669
  {11,  1,   0}, // #6670
  {12,  3,   0}, // #6671
  { 3,  1,   0}, // #6672
  { 5,  1,   0}, // #6673
  { 7,  1,   0}, // #6674
  { 8,  1,   0}, // #6675
  { 9,  1,   0}, // #6676
  {10,  1,   0}, // #6677
  {11,  2,   0}, // #6678
  {12,  4,   0}, // #6679
  { 5,  1,   0}, // #6680
  { 6,  1,   0}, // #6681
  { 7,  1,   0}, // #6682
  { 8,  1,   0}, // #6683
  { 9,  1,   0}, // #6684
  {10,  1,   0}, // #6685
  {11,  2,   0}, // #6686
  {12,  4,   0}, // #6687
  { 3,  1,   0}, // #6688
  { 5,  1,   0}, // #6689
  { 7,  1,   0}, // #6690
  { 8,  1,   0}, // #6691
  {10,  2,   0}, // #6692
  {11,  1,   0}, // #6693
  {12,  4,   0}, // #6694
  { 4,  1,   0}, // #6695
  { 6,  2,   0}, // #6696
  { 7,  1,   0}, // #6697
  { 8,  2,   0}, // #6698
  { 9,  3,   0}, // #6699
  {11,  4,   0}, // #6700
  {12,  4,   0}, // #6701
  {10,  2,   0}, // #6702
  {11,  3,   0}, // #6703
  {12,  5,   0}, // #6704
  { 5,  1,   0}, // #6705
  { 6,  1,   0}, // #6706
  { 7,  1,   0}, // #6707
  { 8,  1,   0}, // #6708
  { 9,  1,   0}, // #6709
  {10,  2,   0}, // #6710
  {11,  2,   0}, // #6711
  {12,  5,   0}, // #6712
  { 5,  1,   0}, // #6713
  { 8,  2,   0}, // #6714
  {10,  2,   0}, // #6715
  {11,  3,   0}, // #6716
  {12,  6,   0}, // #6717
  { 4,  2,   0}, // #6718
  { 7,  2,   0}, // #6719
  { 9,  2,   0}, // #6720
  {10,  1,   0}, // #6721
  {11,  2,   0}, // #6722
  {12,  3,   0}, // #6723
  { 8,  2,   0}, // #6724
  {10,  1,   0}, // #6725
  {11,  3,   0}, // #6726
  {12,  4,   0}, // #6727
  { 5,  1,   0}, // #6728
  { 8,  2,   0}, // #6729
  {10,  1,   0}, // #6730
  {11,  2,   0}, // #6731
  {12,  4,   0}, // #6732
  { 3,  1,   0}, // #6733
  { 4,  1,   0}, // #6734
  { 8,  1,   0}, // #6735
  { 9,  1,   0}, // #6736
  {11,  2,   0}, // #6737
  {12,  1,   0}, // #6738
  {13,  2,   0}, // #6739
  {14,  2,   0}, // #6740
  {15,  2,   0}, // #6741
  {16,  2,   0}, // #6742
  {18,  2,   0}, // #6743
  {19,  3,   0}, // #6744
  {20,  3,   0}, // #6745
  {22,  4,   0}, // #6746
  {23,  4,   0}, // #6747
  { 4,  1,   0}, // #6748
  { 9,  1,   0}, // #6749
  {11,  1,   0}, // #6750
  {14,  1,   0}, // #6751
  {15,  1,   0}, // #6752
  {16,  2,   0}, // #6753
  {17,  1,   0}, // #6754
  {18,  1,   0}, // #6755
  {19,  1,   0}, // #6756
  {20,  1,   0}, // #6757
  {21,  1,   0}, // #6758
  {22,  2,   0}, // #6759
  {23,  3,   0}, // #6760
  { 4,  1,   0}, // #6761
  { 9,  1,   0}, // #6762
  {11,  1,   0}, // #6763
  {14,  1,   0}, // #6764
  {15,  1,   0}, // #6765
  {16,  2,   0}, // #6766
  {18,  1,   0}, // #6767
  {19,  1,   0}, // #6768
  {20,  1,   0}, // #6769
  {22,  2,   0}, // #6770
  {23,  2,   0}, // #6771
  { 2, 17,   0}, // #6772
  { 3,  1,   0}, // #6773
  {11,  1,   0}, // #6774
  {12,  1,   0}, // #6775
  {13,  1,   0}, // #6776
  {14,  1,   0}, // #6777
  {19,  1,   0}, // #6778
  {20,  1,   0}, // #6779
  {22,  1,   0}, // #6780
  {23,  1,   0}, // #6781
  { 4,  1,   0}, // #6782
  { 7,  1,   0}, // #6783
  { 8,  1,   0}, // #6784
  {11,  1,   0}, // #6785
  {12,  1,   0}, // #6786
  {13,  1,   0}, // #6787
  {15,  2,   0}, // #6788
  {16,  1,   0}, // #6789
  {18,  1,   0}, // #6790
  {19,  2,   0}, // #6791
  {20,  1,   0}, // #6792
  {21,  1,   0}, // #6793
  {22,  2,   0}, // #6794
  {23,  4,   0}, // #6795
  { 2, 28,   0}, // #6796
  { 3,  2,   0}, // #6797
  {11,  2,   0}, // #6798
  {12,  2,   0}, // #6799
  {13,  2,   0}, // #6800
  {14,  2,   0}, // #6801
  {15,  1,   0}, // #6802
  {17,  1,   0}, // #6803
  {19,  3,   0}, // #6804
  {20,  2,   0}, // #6805
  {21,  1,   0}, // #6806
  {22,  3,   0}, // #6807
  {23,  4,   0}, // #6808
  { 2, 28,   0}, // #6809
  { 3,  2,   0}, // #6810
  {11,  2,   0}, // #6811
  {12,  2,   0}, // #6812
  {13,  2,   0}, // #6813
  {14,  2,   0}, // #6814
  {15,  1,   0}, // #6815
  {19,  3,   0}, // #6816
  {20,  2,   0}, // #6817
  {22,  3,   0}, // #6818
  {23,  3,   0}, // #6819
  { 2, 14,   0}, // #6820
  { 3,  2,   0}, // #6821
  {11,  2,   0}, // #6822
  {12,  2,   0}, // #6823
  {13,  2,   0}, // #6824
  {14,  2,   0}, // #6825
  {15,  1,   0}, // #6826
  {17,  1,   0}, // #6827
  {19,  3,   0}, // #6828
  {20,  2,   0}, // #6829
  {21,  1,   0}, // #6830
  {22,  3,   0}, // #6831
  {23,  4,   0}, // #6832
  { 2, 14,   0}, // #6833
  { 3,  2,   0}, // #6834
  {11,  2,   0}, // #6835
  {12,  2,   0}, // #6836
  {13,  2,   0}, // #6837
  {14,  2,   0}, // #6838
  {15,  1,   0}, // #6839
  {19,  3,   0}, // #6840
  {20,  2,   0}, // #6841
  {22,  3,   0}, // #6842
  {23,  3,   0}, // #6843
  { 4,  2,   0}, // #6844
  {11,  2,   0}, // #6845
  {15,  2,   0}, // #6846
  {16,  2,   0}, // #6847
  {19,  2,   0}, // #6848
  {22,  2,   0}, // #6849
  {23,  2,   0}, // #6850
  { 3,  2,   0}, // #6851
  { 4,  1,   0}, // #6852
  { 8,  2,   0}, // #6853
  { 9,  4,   0}, // #6854
  {11,  5,   0}, // #6855
  {12,  2,   0}, // #6856
  {13,  4,   0}, // #6857
  {14,  6,   0}, // #6858
  {15,  3,   0}, // #6859
  {16,  5,   0}, // #6860
  {18,  6,   0}, // #6861
  {19,  7,   0}, // #6862
  {20,  8,   0}, // #6863
  {22, 15,   0}, // #6864
  {23, 15,   0}, // #6865
  { 7,  1,   0}, // #6866
  {12,  1,   0}, // #6867
  {17,  2,   0}, // #6868
  {21,  2,   0}, // #6869
  {22,  2,   0}, // #6870
  {23,  5,   0}, // #6871
  {17,  1,   0}, // #6872
  {21,  1,   0}, // #6873
  {22, 14,   0}, // #6874
  {23, 15,   0}, // #6875
  {17,  2,   0}, // #6876
  {21,  2,   0}, // #6877
  {22,  3,   0}, // #6878
  {23,  5,   0}, // #6879
  { 9,  2,   0}, // #6880
  {14,  2,   0}, // #6881
  {16,  2,   0}, // #6882
  {17,  1,   0}, // #6883
  {18,  2,   0}, // #6884
  {19,  1,   0}, // #6885
  {20,  2,   0}, // #6886
  {21,  1,   0}, // #6887
  {22,  3,   0}, // #6888
  {23,  4,   0}, // #6889
  {17,  1,   0}, // #6890
  {19, 16,   0}, // #6891
  {21,  1,   0}, // #6892
  {22, 16,   0}, // #6893
  {23, 17,   0}, // #6894
  { 3,  2,   0}, // #6895
  { 8,  2,   0}, // #6896
  {11,  2,   0}, // #6897
  {12,  2,   0}, // #6898
  {13,  4,   0}, // #6899
  {14,  4,   0}, // #6900
  {15,  3,   0}, // #6901
  {17,  2,   0}, // #6902
  {18,  2,   0}, // #6903
  {19,  8,   0}, // #6904
  {20,  6,   0}, // #6905
  {21,  2,   0}, // #6906
  {22, 10,   0}, // #6907
  {23, 12,   0}, // #6908
  { 3,  3,   0}, // #6909
  { 8,  3,   0}, // #6910
  {11,  3,   0}, // #6911
  {12,  3,   0}, // #6912
  {13,  6,   0}, // #6913
  {14,  7,   0}, // #6914
  {15,  4,   0}, // #6915
  {17,  4,   0}, // #6916
  {18,  3,   0}, // #6917
  {19, 12,   0}, // #6918
  {20, 10,   0}, // #6919
  {21,  4,   0}, // #6920
  {22, 16,   0}, // #6921
  {23, 20,   0}, // #6922
  { 3,  5,   0}, // #6923
  { 8,  3,   0}, // #6924
  {11,  5,   0}, // #6925
  {12,  5,   0}, // #6926
  {13,  8,   0}, // #6927
  {14, 13,   0}, // #6928
  {15,  4,   0}, // #6929
  {17,  8,   0}, // #6930
  {18,  3,   0}, // #6931
  {19, 18,   0}, // #6932
  {20, 16,   0}, // #6933
  {21,  8,   0}, // #6934
  {22, 26,   0}, // #6935
  {23, 34,   0}, // #6936
  { 3,  3,   0}, // #6937
  { 8,  3,   0}, // #6938
  {11,  3,   0}, // #6939
  {12,  3,   0}, // #6940
  {13,  6,   0}, // #6941
  {14,  5,   0}, // #6942
  {15,  4,   0}, // #6943
  {17,  2,   0}, // #6944
  {18,  3,   0}, // #6945
  {19, 10,   0}, // #6946
  {20,  8,   0}, // #6947
  {21,  2,   0}, // #6948
  {22, 12,   0}, // #6949
  {23, 14,   0}, // #6950
  { 3,  5,   0}, // #6951
  { 8,  3,   0}, // #6952
  {11,  5,   0}, // #6953
  {12,  5,   0}, // #6954
  {13,  8,   0}, // #6955
  {14,  9,   0}, // #6956
  {15,  4,   0}, // #6957
  {17,  4,   0}, // #6958
  {18,  3,   0}, // #6959
  {19, 14,   0}, // #6960
  {20, 12,   0}, // #6961
  {21,  4,   0}, // #6962
  {22, 18,   0}, // #6963
  {23, 22,   0}, // #6964
  { 3,  3,   0}, // #6965
  { 8,  3,   0}, // #6966
  {11,  3,   0}, // #6967
  {12,  3,   0}, // #6968
  {13,  6,   0}, // #6969
  {14,  5,   0}, // #6970
  {15,  4,   0}, // #6971
  {17,  2,   0}, // #6972
  {18,  3,   0}, // #6973
  {19, 11,   0}, // #6974
  {20,  8,   0}, // #6975
  {21,  2,   0}, // #6976
  {22, 13,   0}, // #6977
  {23, 15,   0}, // #6978
  {14,  1,   0}, // #6979
  {17,  1,   0}, // #6980
  {20,  1,   0}, // #6981
  {21,  1,   0}, // #6982
  {22,  3,   0}, // #6983
  {23,  4,   0}, // #6984
  { 4,  2,   0}, // #6985
  { 5,  3,   0}, // #6986
  { 7,  2,   0}, // #6987
  { 8,  2,   0}, // #6988
  {14,  2,   0}, // #6989
  {15,  1,   0}, // #6990
  {18,  1,   0}, // #6991
  {22,  1,   0}, // #6992
  {14,  1,   0}, // #6993
  {18,  1,   0}, // #6994
  {22,  1,   0}, // #6995
  { 5,  1,   0}, // #6996
  {14,  2,   0}, // #6997
  {15,  1,   0}, // #6998
  {18,  1,   0}, // #6999
  {22,  1,   0}, // #7000
  { 4,  1,   0}, // #7001
  { 5,  2,   0}, // #7002
  { 7,  1,   0}, // #7003
  { 8,  1,   0}, // #7004
  {14,  2,   0}, // #7005
  {15,  1,   0}, // #7006
  {18,  1,   0}, // #7007
  {22,  1,   0}, // #7008
  { 3,  1,   0}, // #7009
  { 4,  1,   0}, // #7010
  { 5,  1,   0}, // #7011
  {10,  1,   0}, // #7012
  {11,  1,   0}, // #7013
  {14,  1,   0}, // #7014
  {15,  1,   0}, // #7015
  { 2,  1,   0}, // #7016
  { 3,  1,   0}, // #7017
  { 4,  1,   0}, // #7018
  { 5,  1,   0}, // #7019
  {14,  1,   0}, // #7020
  {15,  1,   0}, // #7021
  { 2,  2,   0}, // #7022
  { 3,  2,   0}, // #7023
  { 4,  2,   0}, // #7024
  { 5,  2,   0}, // #7025
  {14,  1,   0}, // #7026
  {15,  1,   0}, // #7027
  { 1,  4,   0}, // #7028
  { 2,  5,   0}, // #7029
  { 3, 11,   0}, // #7030
  { 4, 13,   0}, // #7031
  { 5, 13,   0}, // #7032
  { 6,  7,   0}, // #7033
  { 7,  9,   0}, // #7034
  { 8,  6,   0}, // #7035
  {10,  6,   0}, // #7036
  {11,  6,   0}, // #7037
  {14,  1,   0}, // #7038
  {15,  1,   0}, // #7039
  {19,  3,   0}, // #7040
  { 1,  4,   0}, // #7041
  { 2,  5,   0}, // #7042
  { 3, 12,   0}, // #7043
  { 4, 14,   0}, // #7044
  { 5, 14,   0}, // #7045
  { 6,  7,   0}, // #7046
  { 7,  9,   0}, // #7047
  { 8,  6,   0}, // #7048
  {10,  6,   0}, // #7049
  {11,  6,   0}, // #7050
  {19,  3,   0}, // #7051
  { 2,  1,   0}, // #7052
  { 3,  1,   0}, // #7053
  { 4,  2,   0}, // #7054
  { 5,  2,   0}, // #7055
  { 7,  1,   0}, // #7056
  { 8,  1,   0}, // #7057
  { 9,  1,   0}, // #7058
  {10,  1,   0}, // #7059
  {11,  1,   0}, // #7060
  {14,  1,   0}, // #7061
  {15,  1,   0}, // #7062
  { 5,  1,   0}, // #7063
  {11,  1,   0}, // #7064
  {14,  1,   0}, // #7065
  {15,  1,   0}, // #7066
  { 2,  1,   0}, // #7067
  { 3,  1,   0}, // #7068
  { 4,  1,   0}, // #7069
  { 5,  1,   0}, // #7070
  { 9,  1,   0}, // #7071
  {10,  1,   0}, // #7072
  {11,  1,   0}, // #7073
  {14,  1,   0}, // #7074
  {15,  1,   0}, // #7075
  { 2,  1,   0}, // #7076
  { 3,  1,   0}, // #7077
  { 4,  3,   0}, // #7078
  { 5,  9,   0}, // #7079
  { 7,  2,   0}, // #7080
  { 8,  2,   0}, // #7081
  { 9,  1,   0}, // #7082
  {10,  1,   0}, // #7083
  {11,  3,   0}, // #7084
  {14,  1,   0}, // #7085
  {15,  1,   0}, // #7086
  { 2,  1,   0}, // #7087
  { 3,  1,   0}, // #7088
  { 4,  1,   0}, // #7089
  { 5,  1,   0}, // #7090
  { 9,  1,   0}, // #7091
  {10,  1,   0}, // #7092
  {11,  1,   0}, // #7093
  {14,  2,   0}, // #7094
  {15,  1,   0}, // #7095
  {18,  1,   0}, // #7096
  {22,  1,   0}, // #7097
  { 2,  1,   0}, // #7098
  { 3,  1,   0}, // #7099
  { 4,  3,   0}, // #7100
  { 5,  8,   0}, // #7101
  { 7,  2,   0}, // #7102
  { 8,  2,   0}, // #7103
  { 9,  1,   0}, // #7104
  {10,  1,   0}, // #7105
  {11,  3,   0}, // #7106
  {14,  2,   0}, // #7107
  {15,  1,   0}, // #7108
  {18,  1,   0}, // #7109
  {22,  1,   0}, // #7110
  { 3,  1,   0}, // #7111
  { 4,  1,   0}, // #7112
  { 5,  1,   0}, // #7113
  { 6,  1,   0}, // #7114
  { 7,  1,   0}, // #7115
  {10,  1,   0}, // #7116
  {11,  1,   0}, // #7117
  {19,  1,   0}, // #7118
  { 2,  1,   0}, // #7119
  { 3,  2,   0}, // #7120
  { 4,  2,   0}, // #7121
  { 5,  2,   0}, // #7122
  { 6,  1,   0}, // #7123
  { 7,  1,   0}, // #7124
  {10,  1,   0}, // #7125
  {11,  1,   0}, // #7126
  {19,  1,   0}, // #7127
  { 2,  1,   0}, // #7128
  { 3,  2,   0}, // #7129
  { 4,  2,   0}, // #7130
  { 5,  2,   0}, // #7131
  { 6,  1,   0}, // #7132
  { 7,  1,   0}, // #7133
  {10,  1,   0}, // #7134
  {11,  1,   0}, // #7135
  {14,  1,   0}, // #7136
  {15,  1,   0}, // #7137
  {19,  1,   0}, // #7138
  { 1,  1,   0}, // #7139
  { 2,  2,   0}, // #7140
  { 3,  2,   0}, // #7141
  { 4,  2,   0}, // #7142
  { 5,  2,   0}, // #7143
  { 6,  1,   0}, // #7144
  { 7,  1,   0}, // #7145
  { 8,  1,   0}, // #7146
  {14,  1,   0}, // #7147
  {15,  1,   0}, // #7148
  { 2,  1,   0}, // #7149
  { 3,  3,   0}, // #7150
  { 4,  3,   0}, // #7151
  { 5,  3,   0}, // #7152
  { 6,  1,   0}, // #7153
  { 7,  1,   0}, // #7154
  {10,  1,   0}, // #7155
  {11,  1,   0}, // #7156
  {19,  1,   0}, // #7157
  { 2,  3,   0}, // #7158
  { 3,  3,   0}, // #7159
  { 4,  3,   0}, // #7160
  { 5,  4,   0}, // #7161
  { 9,  3,   0}, // #7162
  {10,  3,   0}, // #7163
  {11,  3,   0}, // #7164
  {14,  1,   0}, // #7165
  {15,  1,   0}, // #7166
  { 2,  3,   0}, // #7167
  { 3,  3,   0}, // #7168
  { 4,  3,   0}, // #7169
  { 5,  3,   0}, // #7170
  { 9,  3,   0}, // #7171
  {10,  3,   0}, // #7172
  {11,  3,   0}, // #7173
  {14,  1,   0}, // #7174
  {15,  1,   0}, // #7175
  { 2,  2,   0}, // #7176
  { 3,  3,   0}, // #7177
  { 4,  3,   0}, // #7178
  { 5,  3,   0}, // #7179
  {10,  1,   0}, // #7180
  {11,  1,   0}, // #7181
  {14,  1,   0}, // #7182
  {15,  1,   0}, // #7183
  { 2,  2,   0}, // #7184
  { 3,  5,   0}, // #7185
  { 4,  6,   0}, // #7186
  { 5,  6,   0}, // #7187
  { 6,  1,   0}, // #7188
  { 7,  2,   0}, // #7189
  { 8,  1,   0}, // #7190
  {10,  3,   0}, // #7191
  {11,  3,   0}, // #7192
  {14,  1,   0}, // #7193
  {15,  1,   0}, // #7194
  {19,  1,   0}, // #7195
  { 2,  2,   0}, // #7196
  { 3,  5,   0}, // #7197
  { 4,  6,   0}, // #7198
  { 5,  6,   0}, // #7199
  { 6,  1,   0}, // #7200
  { 7,  2,   0}, // #7201
  { 8,  1,   0}, // #7202
  {10,  3,   0}, // #7203
  {11,  3,   0}, // #7204
  {19,  1,   0}, // #7205
  { 3,  1,   0}, // #7206
  { 4,  1,   0}, // #7207
  { 5,  1,   0}, // #7208
  {10,  1,   0}, // #7209
  {11,  1,   0}, // #7210
  {14,  1,   0}, // #7211
  {18,  1,   0}, // #7212
  {22,  1,   0}, // #7213
  { 3,  1,   0}, // #7214
  { 4,  1,   0}, // #7215
  { 5,  1,   0}, // #7216
  { 6,  1,   0}, // #7217
  { 7,  1,   0}, // #7218
  {10,  1,   0}, // #7219
  {11,  1,   0}, // #7220
  {14,  1,   0}, // #7221
  {15,  1,   0}, // #7222
  {19,  1,   0}, // #7223
  { 3,  3,   0}, // #7224
  { 4,  3,   0}, // #7225
  { 5,  3,   0}, // #7226
  { 6,  2,   0}, // #7227
  { 7,  2,   0}, // #7228
  {10,  3,   0}, // #7229
  {11,  3,   0}, // #7230
  {14,  1,   0}, // #7231
  {15,  1,   0}, // #7232
  {19,  2,   0}, // #7233
  { 3,  3,   0}, // #7234
  { 4,  3,   0}, // #7235
  { 5,  3,   0}, // #7236
  { 6,  2,   0}, // #7237
  { 7,  2,   0}, // #7238
  {10,  3,   0}, // #7239
  {11,  3,   0}, // #7240
  {19,  2,   0}, // #7241
  { 2,  1,   0}, // #7242
  { 3,  1,   0}, // #7243
  { 4,  2,   0}, // #7244
  { 5,  4,   0}, // #7245
  { 7,  1,   0}, // #7246
  { 8,  1,   0}, // #7247
  { 9,  1,   0}, // #7248
  {10,  1,   0}, // #7249
  {11,  1,   0}, // #7250
  {14,  1,   0}, // #7251
  {15,  1,   0}, // #7252
  { 2,  1,   0}, // #7253
  { 3,  1,   0}, // #7254
  { 4,  1,   0}, // #7255
  { 5,  2,   0}, // #7256
  { 9,  1,   0}, // #7257
  {10,  1,   0}, // #7258
  {11,  1,   0}, // #7259
  {14,  1,   0}, // #7260
  {15,  1,   0}, // #7261
  { 2,  1,   0}, // #7262
  { 3,  1,   0}, // #7263
  { 4,  2,   0}, // #7264
  { 5,  3,   0}, // #7265
  { 7,  1,   0}, // #7266
  { 8,  1,   0}, // #7267
  { 9,  1,   0}, // #7268
  {10,  1,   0}, // #7269
  {11,  1,   0}, // #7270
  {14,  1,   0}, // #7271
  {15,  1,   0}, // #7272
  { 2,  1,   0}, // #7273
  { 3,  2,   0}, // #7274
  { 4,  2,   0}, // #7275
  { 5,  2,   0}, // #7276
  { 6,  1,   0}, // #7277
  { 7,  1,   0}, // #7278
  { 9,  1,   0}, // #7279
  {10,  2,   0}, // #7280
  {11,  2,   0}, // #7281
  {14,  1,   0}, // #7282
  {15,  1,   0}, // #7283
  {19,  1,   0}, // #7284
  { 2,  1,   0}, // #7285
  { 3,  2,   0}, // #7286
  { 4,  2,   0}, // #7287
  { 5,  2,   0}, // #7288
  { 6,  1,   0}, // #7289
  { 7,  1,   0}, // #7290
  { 9,  1,   0}, // #7291
  {10,  2,   0}, // #7292
  {11,  2,   0}, // #7293
  {19,  1,   0}, // #7294
  { 1,  1,   0}, // #7295
  { 2,  1,   0}, // #7296
  { 3,  2,   0}, // #7297
  { 4,  3,   0}, // #7298
  { 5,  3,   0}, // #7299
  { 6,  1,   0}, // #7300
  { 7,  2,   0}, // #7301
  { 8,  2,   0}, // #7302
  {14,  1,   0}, // #7303
  {15,  1,   0}, // #7304
  { 3,  1,   0}, // #7305
  { 4,  1,   0}, // #7306
  { 5,  1,   0}, // #7307
  { 6,  1,   0}, // #7308
  { 7,  1,   0}, // #7309
  {14,  1,   0}, // #7310
  {15,  1,   0}, // #7311
  { 3,  3,   0}, // #7312
  { 4,  3,   0}, // #7313
  { 5,  3,   0}, // #7314
  { 6,  3,   0}, // #7315
  { 7,  3,   0}, // #7316
  {10,  2,   0}, // #7317
  {11,  2,   0}, // #7318
  {14,  1,   0}, // #7319
  {15,  1,   0}, // #7320
  {19,  2,   0}, // #7321
  { 3,  3,   0}, // #7322
  { 4,  3,   0}, // #7323
  { 5,  3,   0}, // #7324
  { 6,  3,   0}, // #7325
  { 7,  3,   0}, // #7326
  {10,  2,   0}, // #7327
  {11,  2,   0}, // #7328
  {19,  2,   0}, // #7329
  { 3,  2,   0}, // #7330
  { 4,  2,   0}, // #7331
  { 5,  2,   0}, // #7332
  { 6,  1,   0}, // #7333
  { 7,  1,   0}, // #7334
  {10,  2,   0}, // #7335
  {11,  2,   0}, // #7336
  {19,  1,   0}, // #7337
  { 1,  1,   0}, // #7338
  { 2,  1,   0}, // #7339
  { 3,  2,   0}, // #7340
  { 4,  2,   0}, // #7341
  { 5,  2,   0}, // #7342
  { 6,  2,   0}, // #7343
  { 7,  2,   0}, // #7344
  { 8,  1,   0}, // #7345
  {10,  1,   0}, // #7346
  {11,  1,   0}, // #7347
  {14,  1,   0}, // #7348
  {15,  1,   0}, // #7349
  {19,  1,   0}, // #7350
  { 1,  1,   0}, // #7351
  { 2,  1,   0}, // #7352
  { 3,  2,   0}, // #7353
  { 4,  2,   0}, // #7354
  { 5,  2,   0}, // #7355
  { 6,  2,   0}, // #7356
  { 7,  2,   0}, // #7357
  { 8,  1,   0}, // #7358
  {10,  1,   0}, // #7359
  {11,  1,   0}, // #7360
  {19,  1,   0}, // #7361
  { 3,  2,   0}, // #7362
  { 4,  2,   0}, // #7363
  { 5,  2,   0}, // #7364
  { 6,  1,   0}, // #7365
  { 7,  1,   0}, // #7366
  {10,  2,   0}, // #7367
  {11,  2,   0}, // #7368
  {14,  1,   0}, // #7369
  {15,  1,   0}, // #7370
  {19,  1,   0}, // #7371
  { 1,  3,   0}, // #7372
  { 2,  4,   0}, // #7373
  { 3,  6,   0}, // #7374
  { 4,  7,   0}, // #7375
  { 5,  7,   0}, // #7376
  { 6,  4,   0}, // #7377
  { 7,  5,   0}, // #7378
  { 8,  4,   0}, // #7379
  { 9,  1,   0}, // #7380
  {10,  2,   0}, // #7381
  {11,  2,   0}, // #7382
  {14,  1,   0}, // #7383
  {15,  1,   0}, // #7384
  {19,  1,   0}, // #7385
  { 1,  3,   0}, // #7386
  { 2,  4,   0}, // #7387
  { 3,  7,   0}, // #7388
  { 4,  8,   0}, // #7389
  { 5,  8,   0}, // #7390
  { 6,  4,   0}, // #7391
  { 7,  5,   0}, // #7392
  { 8,  4,   0}, // #7393
  { 9,  1,   0}, // #7394
  {10,  2,   0}, // #7395
  {11,  2,   0}, // #7396
  {19,  1,   0}, // #7397
  { 1,  3,   0}, // #7398
  { 2,  4,   0}, // #7399
  { 3,  7,   0}, // #7400
  { 4,  8,   0}, // #7401
  { 5,  8,   0}, // #7402
  { 6,  4,   0}, // #7403
  { 7,  5,   0}, // #7404
  { 8,  4,   0}, // #7405
  { 9,  1,   0}, // #7406
  {10,  2,   0}, // #7407
  {11,  2,   0}, // #7408
  {14,  1,   0}, // #7409
  {15,  1,   0}, // #7410
  {19,  1,   0}, // #7411
  { 1,  3,   0}, // #7412
  { 2,  4,   0}, // #7413
  { 3,  8,   0}, // #7414
  { 4,  9,   0}, // #7415
  { 5,  9,   0}, // #7416
  { 6,  4,   0}, // #7417
  { 7,  5,   0}, // #7418
  { 8,  4,   0}, // #7419
  { 9,  1,   0}, // #7420
  {10,  2,   0}, // #7421
  {11,  2,   0}, // #7422
  {19,  1,   0}, // #7423
  { 1,  3,   0}, // #7424
  { 2,  3,   0}, // #7425
  { 3,  3,   0}, // #7426
  { 4,  3,   0}, // #7427
  { 5,  3,   0}, // #7428
  { 6,  3,   0}, // #7429
  { 7,  3,   0}, // #7430
  { 8,  3,   0}, // #7431
  {14,  1,   0}, // #7432
  {15,  1,   0}, // #7433
  { 3,  3,   0}, // #7434
  { 4,  3,   0}, // #7435
  { 5,  3,   0}, // #7436
  {10,  2,   0}, // #7437
  {11,  2,   0}, // #7438
  {14,  1,   0}, // #7439
  {15,  1,   0}, // #7440
  { 2,  2,   0}, // #7441
  { 3,  2,   0}, // #7442
  { 4,  5,   0}, // #7443
  { 5,  7,   0}, // #7444
  { 7,  3,   0}, // #7445
  { 8,  3,   0}, // #7446
  { 9,  2,   0}, // #7447
  {10,  2,   0}, // #7448
  {11,  2,   0}, // #7449
  {14,  2,   0}, // #7450
  {15,  1,   0}, // #7451
  {18,  1,   0}, // #7452
  {22,  1,   0}, // #7453
  { 4,  1,   0}, // #7454
  { 5,  1,   0}, // #7455
  { 7,  1,   0}, // #7456
  { 8,  1,   0}, // #7457
  {14,  2,   0}, // #7458
  {15,  1,   0}, // #7459
  {18,  1,   0}, // #7460
  {22,  1,   0}, // #7461
  { 4,  2,   0}, // #7462
  { 5,  2,   0}, // #7463
  { 7,  2,   0}, // #7464
  { 8,  2,   0}, // #7465
  {14,  2,   0}, // #7466
  {15,  1,   0}, // #7467
  {18,  1,   0}, // #7468
  {22,  1,   0}, // #7469
  { 4,  2,   0}, // #7470
  { 5,  2,   0}, // #7471
  { 7,  2,   0}, // #7472
  { 8,  2,   0}, // #7473
  {14,  1,   0}, // #7474
  {18,  1,   0}, // #7475
  {22,  1,   0}, // #7476
  { 2,  1,   0}, // #7477
  { 3,  1,   0}, // #7478
  { 4,  2,   0}, // #7479
  { 5,  3,   0}, // #7480
  { 7,  1,   0}, // #7481
  { 8,  1,   0}, // #7482
  { 9,  1,   0}, // #7483
  {10,  1,   0}, // #7484
  {11,  1,   0}, // #7485
  {14,  2,   0}, // #7486
  {15,  1,   0}, // #7487
  {18,  1,   0}, // #7488
  {22,  1,   0}, // #7489
  { 2,  1,   0}, // #7490
  { 3,  1,   0}, // #7491
  { 4,  1,   0}, // #7492
  { 5,  2,   0}, // #7493
  { 9,  1,   0}, // #7494
  {10,  1,   0}, // #7495
  {11,  1,   0}, // #7496
  {14,  2,   0}, // #7497
  {15,  1,   0}, // #7498
  {18,  1,   0}, // #7499
  {22,  1,   0}, // #7500
  { 1,  1,   0}, // #7501
  { 2,  1,   0}, // #7502
  { 3,  1,   0}, // #7503
  { 4,  1,   0}, // #7504
  { 5,  1,   0}, // #7505
  { 6,  1,   0}, // #7506
  { 7,  1,   0}, // #7507
  { 8,  1,   0}, // #7508
  {27,  7,   0}, // #7509
  { 1,  1,   0}, // #7510
  { 2,  1,   0}, // #7511
  { 3,  1,   0}, // #7512
  { 4,  2,   0}, // #7513
  { 5,  2,   0}, // #7514
  { 6,  1,   0}, // #7515
  { 7,  2,   0}, // #7516
  { 8,  2,   0}, // #7517
  {14,  1,   0}, // #7518
  {18,  1,   0}, // #7519
  {22,  1,   0}, // #7520
  { 3,  2,   0}, // #7521
  { 4,  2,   0}, // #7522
  { 5,  2,   0}, // #7523
  { 6,  2,   0}, // #7524
  { 7,  2,   0}, // #7525
  {10,  2,   0}, // #7526
  {11,  2,   0}, // #7527
  {19,  2,   0}, // #7528
  { 1,  1,   0}, // #7529
  { 2,  1,   0}, // #7530
  { 3,  4,   0}, // #7531
  { 4,  5,   0}, // #7532
  { 5,  5,   0}, // #7533
  { 6,  4,   0}, // #7534
  { 7,  5,   0}, // #7535
  { 8,  2,   0}, // #7536
  {10,  1,   0}, // #7537
  {11,  1,   0}, // #7538
  {14,  1,   0}, // #7539
  {15,  1,   0}, // #7540
  {19,  1,   0}, // #7541
  { 1,  1,   0}, // #7542
  { 2,  1,   0}, // #7543
  { 3,  4,   0}, // #7544
  { 4,  4,   0}, // #7545
  { 5,  4,   0}, // #7546
  { 6,  4,   0}, // #7547
  { 7,  4,   0}, // #7548
  { 8,  1,   0}, // #7549
  {10,  1,   0}, // #7550
  {11,  1,   0}, // #7551
  {19,  1,   0}, // #7552
  { 2,  1,   0}, // #7553
  { 3,  1,   0}, // #7554
  { 4,  1,   0}, // #7555
  { 5,  1,   0}, // #7556
  {14,  1,   0}, // #7557
  {18,  1,   0}, // #7558
  {22,  1,   0}, // #7559
  { 1,  1,   0}, // #7560
  { 2,  1,   0}, // #7561
  { 3,  1,   0}, // #7562
  { 4,  1,   0}, // #7563
  { 5,  1,   0}, // #7564
  { 6,  1,   0}, // #7565
  { 7,  1,   0}, // #7566
  { 8,  1,   0}, // #7567
  {14,  1,   0}, // #7568
  {18,  1,   0}, // #7569
  {22,  1,   0}, // #7570
  { 1,  2,   0}, // #7571
  { 2,  2,   0}, // #7572
  { 3,  3,   0}, // #7573
  { 4,  3,   0}, // #7574
  { 5,  3,   0}, // #7575
  { 6,  3,   0}, // #7576
  { 7,  3,   0}, // #7577
  { 8,  2,   0}, // #7578
  {14,  1,   0}, // #7579
  {15,  1,   0}, // #7580
  { 1,  2,   0}, // #7581
  { 2,  2,   0}, // #7582
  { 3,  2,   0}, // #7583
  { 4,  2,   0}, // #7584
  { 5,  2,   0}, // #7585
  { 6,  2,   0}, // #7586
  { 7,  2,   0}, // #7587
  { 8,  2,   0}, // #7588
  {14,  1,   0}, // #7589
  {15,  1,   0}, // #7590
  { 1,  2,   0}, // #7591
  { 2,  3,   0}, // #7592
  { 3,  7,   0}, // #7593
  { 4, 15,   0}, // #7594
  { 5, 15,   0}, // #7595
  { 6,  6,   0}, // #7596
  { 7, 10,   0}, // #7597
  { 8,  6,   0}, // #7598
  { 9,  1,   0}, // #7599
  {10,  3,   0}, // #7600
  {11,  3,   0}, // #7601
  {19,  2,   0}, // #7602
  {20,  4,   0}, // #7603
  { 2,  1,   0}, // #7604
  { 3,  3,   0}, // #7605
  { 4,  3,   0}, // #7606
  { 5,  3,   0}, // #7607
  { 6,  2,   0}, // #7608
  { 7,  2,   0}, // #7609
  {10,  2,   0}, // #7610
  {11,  2,   0}, // #7611
  {19,  2,   0}, // #7612
  { 1,  1,   0}, // #7613
  { 2,  2,   0}, // #7614
  { 3,  3,   0}, // #7615
  { 4,  3,   0}, // #7616
  { 5,  3,   0}, // #7617
  { 6,  2,   0}, // #7618
  { 7,  2,   0}, // #7619
  { 8,  1,   0}, // #7620
  {10,  1,   0}, // #7621
  {11,  1,   0}, // #7622
  {19,  1,   0}, // #7623
  { 5,  3,   0}, // #7624
  {14,  1,   0}, // #7625
  {15,  1,   0}, // #7626
  { 5,  4,   0}, // #7627
  {14,  2,   0}, // #7628
  {15,  1,   0}, // #7629
  {18,  1,   0}, // #7630
  {22,  1,   0}, // #7631
  { 4,  1,   0}, // #7632
  { 5,  6,   0}, // #7633
  { 7,  1,   0}, // #7634
  { 8,  1,   0}, // #7635
  {14,  2,   0}, // #7636
  {15,  1,   0}, // #7637
  {18,  1,   0}, // #7638
  {22,  1,   0}, // #7639
  { 1,  1,   0}, // #7640
  { 2,  1,   0}, // #7641
  { 3,  2,   0}, // #7642
  { 4,  2,   0}, // #7643
  { 5,  2,   0}, // #7644
  { 6,  2,   0}, // #7645
  { 7,  2,   0}, // #7646
  { 8,  1,   0}, // #7647
  {14,  1,   0}, // #7648
  {15,  1,   0}, // #7649
  { 3,  1,   0}, // #7650
  { 4,  1,   0}, // #7651
  { 5,  1,   0}, // #7652
  { 6,  1,   0}, // #7653
  { 7,  1,   0}, // #7654
  {10,  1,   0}, // #7655
  {11,  1,   0}, // #7656
  {17,  1,   0}, // #7657
  {18,  2,   0}, // #7658
  {19,  1,   0}, // #7659
  { 4,  1,   0}, // #7660
  { 5,  1,   0}, // #7661
  { 7,  1,   0}, // #7662
  { 8,  1,   0}, // #7663
  {17,  1,   0}, // #7664
  {18,  2,   0}, // #7665
  {20,  1,   0}, // #7666
  { 3,  1,   0}, // #7667
  { 4,  2,   0}, // #7668
  { 5,  2,   0}, // #7669
  { 6,  1,   0}, // #7670
  { 7,  2,   0}, // #7671
  { 8,  1,   0}, // #7672
  {10,  1,   0}, // #7673
  {11,  1,   0}, // #7674
  {19,  1,   0}, // #7675
  { 2,  2,   0}, // #7676
  { 3,  2,   0}, // #7677
  { 4,  9,   0}, // #7678
  { 5, 13,   0}, // #7679
  { 7,  7,   0}, // #7680
  { 8,  7,   0}, // #7681
  { 9,  2,   0}, // #7682
  {10,  2,   0}, // #7683
  {11,  2,   0}, // #7684
  {14,  2,   0}, // #7685
  {15,  1,   0}, // #7686
  {18,  1,   0}, // #7687
  {22,  1,   0}, // #7688
  { 1,  2,   0}, // #7689
  { 2,  2,   0}, // #7690
  { 3,  6,   0}, // #7691
  { 4, 12,   0}, // #7692
  { 5, 19,   0}, // #7693
  { 6,  4,   0}, // #7694
  { 7, 10,   0}, // #7695
  { 8,  8,   0}, // #7696
  {10,  4,   0}, // #7697
  {11,  4,   0}, // #7698
  {14,  2,   0}, // #7699
  {15,  1,   0}, // #7700
  {18,  1,   0}, // #7701
  {19,  2,   0}, // #7702
  {22,  1,   0}, // #7703
  { 1,  2,   0}, // #7704
  { 2,  8,   0}, // #7705
  { 3, 12,   0}, // #7706
  { 4, 21,   0}, // #7707
  { 5, 21,   0}, // #7708
  { 6,  5,   0}, // #7709
  { 7, 14,   0}, // #7710
  { 8,  9,   0}, // #7711
  { 9,  4,   0}, // #7712
  {10,  7,   0}, // #7713
  {11,  7,   0}, // #7714
  {19,  3,   0}, // #7715
  { 1,  2,   0}, // #7716
  { 2,  4,   0}, // #7717
  { 3, 13,   0}, // #7718
  { 4, 34,   0}, // #7719
  { 5, 34,   0}, // #7720
  { 6, 11,   0}, // #7721
  { 7, 32,   0}, // #7722
  { 8, 23,   0}, // #7723
  { 9,  2,   0}, // #7724
  {10, 11,   0}, // #7725
  {11, 11,   0}, // #7726
  {14, 19,   0}, // #7727
  {15, 14,   0}, // #7728
  {18,  4,   0}, // #7729
  {19,  9,   0}, // #7730
  {22,  5,   0}, // #7731
  { 2,  1,   0}, // #7732
  { 3,  1,   0}, // #7733
  { 4,  3,   0}, // #7734
  { 5,  9,   0}, // #7735
  { 7,  2,   0}, // #7736
  { 8,  2,   0}, // #7737
  { 9,  1,   0}, // #7738
  {10,  1,   0}, // #7739
  {11,  1,   0}, // #7740
  {14,  1,   0}, // #7741
  {15,  1,   0}, // #7742
  { 3,  1,   0}, // #7743
  { 4, 10,   0}, // #7744
  { 5, 10,   0}, // #7745
  { 6,  1,   0}, // #7746
  { 7,  3,   0}, // #7747
  { 8,  2,   0}, // #7748
  {10,  1,   0}, // #7749
  {11,  1,   0}, // #7750
  {19,  1,   0}, // #7751
  {20,  2,   0}, // #7752
  { 1,  7,   0}, // #7753
  { 2, 24,   0}, // #7754
  { 3, 44,   0}, // #7755
  { 4, 70,   0}, // #7756
  { 5, 75,   0}, // #7757
  { 6, 26,   0}, // #7758
  { 7, 52,   0}, // #7759
  { 8, 32,   0}, // #7760
  { 9, 17,   0}, // #7761
  {10, 36,   0}, // #7762
  {11, 37,   0}, // #7763
  {14, 10,   0}, // #7764
  {15,  9,   0}, // #7765
  {18,  1,   0}, // #7766
  {19, 19,   0}, // #7767
  {22,  1,   0}, // #7768
  { 3,  9,   0}, // #7769
  { 4, 15,   0}, // #7770
  { 5, 15,   0}, // #7771
  { 6,  9,   0}, // #7772
  { 7,  9,   0}, // #7773
  {10,  6,   0}, // #7774
  {11,  6,   0}, // #7775
  {19,  6,   0}, // #7776
  { 1,  5,   0}, // #7777
  { 2, 20,   0}, // #7778
  { 3, 35,   0}, // #7779
  { 4, 61,   0}, // #7780
  { 5, 66,   0}, // #7781
  { 6, 20,   0}, // #7782
  { 7, 46,   0}, // #7783
  { 8, 31,   0}, // #7784
  { 9, 15,   0}, // #7785
  {10, 30,   0}, // #7786
  {11, 30,   0}, // #7787
  {14,  6,   0}, // #7788
  {15,  5,   0}, // #7789
  {18,  1,   0}, // #7790
  {19, 15,   0}, // #7791
  {22,  1,   0}, // #7792
  { 1,  5,   0}, // #7793
  { 2, 20,   0}, // #7794
  { 3, 36,   0}, // #7795
  { 4, 61,   0}, // #7796
  { 5, 66,   0}, // #7797
  { 6, 21,   0}, // #7798
  { 7, 46,   0}, // #7799
  { 8, 30,   0}, // #7800
  { 9, 15,   0}, // #7801
  {10, 30,   0}, // #7802
  {11, 30,   0}, // #7803
  {14,  6,   0}, // #7804
  {15,  5,   0}, // #7805
  {18,  1,   0}, // #7806
  {19, 15,   0}, // #7807
  {22,  1,   0}, // #7808
  { 1,  6,   0}, // #7809
  { 2, 23,   0}, // #7810
  { 3, 41,   0}, // #7811
  { 4, 68,   0}, // #7812
  { 5, 73,   0}, // #7813
  { 6, 24,   0}, // #7814
  { 7, 51,   0}, // #7815
  { 8, 33,   0}, // #7816
  { 9, 16,   0}, // #7817
  {10, 34,   0}, // #7818
  {11, 34,   0}, // #7819
  {14,  9,   0}, // #7820
  {15,  8,   0}, // #7821
  {18,  1,   0}, // #7822
  {19, 18,   0}, // #7823
  {22,  1,   0}, // #7824
  { 2,  9,   0}, // #7825
  { 3, 23,   0}, // #7826
  { 4, 53,   0}, // #7827
  { 5, 54,   0}, // #7828
  { 6,  3,   0}, // #7829
  { 7, 33,   0}, // #7830
  { 8, 20,   0}, // #7831
  { 9,  8,   0}, // #7832
  {10, 15,   0}, // #7833
  {11, 16,   0}, // #7834
  {19,  2,   0}, // #7835
  { 1,  7,   0}, // #7836
  { 2, 26,   0}, // #7837
  { 3, 46,   0}, // #7838
  { 4, 71,   0}, // #7839
  { 5, 79,   0}, // #7840
  { 6, 27,   0}, // #7841
  { 7, 52,   0}, // #7842
  { 8, 32,   0}, // #7843
  { 9, 19,   0}, // #7844
  {10, 39,   0}, // #7845
  {11, 41,   0}, // #7846
  {14,  8,   0}, // #7847
  {15,  8,   0}, // #7848
  {19, 20,   0}, // #7849
  { 1,  7,   0}, // #7850
  { 2, 26,   0}, // #7851
  { 3, 46,   0}, // #7852
  { 4, 71,   0}, // #7853
  { 5, 79,   0}, // #7854
  { 6, 27,   0}, // #7855
  { 7, 52,   0}, // #7856
  { 8, 32,   0}, // #7857
  { 9, 19,   0}, // #7858
  {10, 39,   0}, // #7859
  {11, 41,   0}, // #7860
  {14,  7,   0}, // #7861
  {15,  7,   0}, // #7862
  {19, 20,   0}, // #7863
  { 1,  2,   0}, // #7864
  { 2,  9,   0}, // #7865
  { 3, 14,   0}, // #7866
  { 4, 24,   0}, // #7867
  { 5, 24,   0}, // #7868
  { 6,  7,   0}, // #7869
  { 7, 17,   0}, // #7870
  { 8, 12,   0}, // #7871
  { 9,  6,   0}, // #7872
  {10, 11,   0}, // #7873
  {11, 11,   0}, // #7874
  {14,  1,   0}, // #7875
  {18,  1,   0}, // #7876
  {19,  5,   0}, // #7877
  {22,  1,   0}, // #7878
  { 1,  2,   0}, // #7879
  { 2, 12,   0}, // #7880
  { 3, 17,   0}, // #7881
  { 4, 27,   0}, // #7882
  { 5, 32,   0}, // #7883
  { 6,  7,   0}, // #7884
  { 7, 17,   0}, // #7885
  { 8, 12,   0}, // #7886
  { 9, 10,   0}, // #7887
  {10, 15,   0}, // #7888
  {11, 15,   0}, // #7889
  {14, 40,   0}, // #7890
  {15,  2,   0}, // #7891
  {18, 38,   0}, // #7892
  {19,  5,   0}, // #7893
  {22, 38,   0}, // #7894
  { 1,  4,   0}, // #7895
  { 2,  4,   0}, // #7896
  { 3,  6,   0}, // #7897
  { 4, 10,   0}, // #7898
  { 5, 10,   0}, // #7899
  { 6,  5,   0}, // #7900
  { 7,  9,   0}, // #7901
  { 8,  8,   0}, // #7902
  {10,  1,   0}, // #7903
  {11,  1,   0}, // #7904
  {13, 47,   0}, // #7905
  {14, 80,   0}, // #7906
  {15, 80,   0}, // #7907
  {20,  2,   0}, // #7908
  { 1,  8,   0}, // #7909
  { 2, 35,   0}, // #7910
  { 3, 79,   0}, // #7911
  { 4, 142,   0}, // #7912
  { 5, 142,   0}, // #7913
  { 6, 37,   0}, // #7914
  { 7, 100,   0}, // #7915
  { 8, 71,   0}, // #7916
  { 9, 21,   0}, // #7917
  {10, 46,   0}, // #7918
  {11, 46,   0}, // #7919
  {14,  1,   0}, // #7920
  {18,  1,   0}, // #7921
  {19, 10,   0}, // #7922
  {22,  1,   0}, // #7923
  { 2,  1,   0}, // #7924
  { 3,  1,   0}, // #7925
  { 4,  1,   0}, // #7926
  { 5,  1,   0}, // #7927
  { 9,  1,   0}, // #7928
  {10,  1,   0}, // #7929
  {11,  1,   0}, // #7930
  {14,  1,   0}, // #7931
  {18,  1,   0}, // #7932
  {22,  1,   0}, // #7933
  { 3,  1,   0}, // #7934
  { 4,  1,   0}, // #7935
  { 5,  1,   0}, // #7936
  { 6,  1,   0}, // #7937
  { 7,  1,   0}, // #7938
  {10,  1,   0}, // #7939
  {11,  1,   0}, // #7940
  {14,  1,   0}, // #7941
  {18,  1,   0}, // #7942
  {19,  1,   0}, // #7943
  {22,  1,   0}, // #7944
  { 5,  2,   0}, // #7945
  {14,  1,   0}, // #7946
  {18,  1,   0}, // #7947
  {22,  1,   0}, // #7948
  { 2,  1,   0}, // #7949
  { 3,  1,   0}, // #7950
  { 4,  2,   0}, // #7951
  { 5,  2,   0}, // #7952
  { 7,  1,   0}, // #7953
  { 8,  1,   0}, // #7954
  { 9,  1,   0}, // #7955
  {10,  1,   0}, // #7956
  {11,  1,   0}, // #7957
  {14,  1,   0}, // #7958
  {18,  1,   0}, // #7959
  {22,  1,   0}, // #7960
  { 1,  5,   0}, // #7961
  { 2, 13,   0}, // #7962
  { 3, 13,   0}, // #7963
  { 4, 13,   0}, // #7964
  { 5, 13,   0}, // #7965
  { 6,  5,   0}, // #7966
  { 7,  5,   0}, // #7967
  { 8,  5,   0}, // #7968
  { 9,  8,   0}, // #7969
  {10,  8,   0}, // #7970
  {11,  8,   0}, // #7971
  {14, 21,   0}, // #7972
  {15, 21,   0}, // #7973
  { 4,  1,   0}, // #7974
  { 5,  1,   0}, // #7975
  { 7,  1,   0}, // #7976
  { 8,  1,   0}, // #7977
  {14,  1,   0}, // #7978
  {15,  1,   0}, // #7979
  {20,  1,   0}, // #7980
  { 1,  1,   0}, // #7981
  { 2,  1,   0}, // #7982
  { 3,  1,   0}, // #7983
  { 4,  1,   0}, // #7984
  { 5,  1,   0}, // #7985
  { 6,  1,   0}, // #7986
  { 7,  1,   0}, // #7987
  { 8,  1,   0}, // #7988
  {17,  1,   0}, // #7989
  {18,  2,   0}, // #7990
  { 5,  5,   0}, // #7991
  {14,  2,   0}, // #7992
  {15,  2,   0}, // #7993
  { 5,  2,   0}, // #7994
  {14,  2,   0}, // #7995
  {15,  1,   0}, // #7996
  {18,  1,   0}, // #7997
  {22,  1,   0}, // #7998
  { 4,  1,   0}, // #7999
  { 5,  1,   0}, // #8000
  { 7,  1,   0}, // #8001
  { 8,  1,   0}, // #8002
  {13,  1,   0}, // #8003
  {14,  2,   0}, // #8004
  {15,  2,   0}, // #8005
  {17,  1,   0}, // #8006
  {18,  2,   0}, // #8007
  {20,  1,   0}, // #8008
  { 4,  1,   0}, // #8009
  { 5,  3,   0}, // #8010
  { 7,  1,   0}, // #8011
  { 8,  1,   0}, // #8012
  {14,  2,   0}, // #8013
  {15,  1,   0}, // #8014
  {18,  1,   0}, // #8015
  {22,  1,   0}, // #8016
  { 3,  2,   0}, // #8017
  { 4,  2,   0}, // #8018
  { 5,  2,   0}, // #8019
  { 6,  2,   0}, // #8020
  { 7,  2,   0}, // #8021
  {10,  2,   0}, // #8022
  {11,  2,   0}, // #8023
  {14,  1,   0}, // #8024
  {15,  1,   0}, // #8025
  {19,  2,   0}, // #8026
  { 4,  2,   0}, // #8027
  { 5,  2,   0}, // #8028
  { 7,  2,   0}, // #8029
  { 8,  2,   0}, // #8030
  {14,  1,   0}, // #8031
  {15,  1,   0}, // #8032
  { 2,  2,   0}, // #8033
  { 3,  3,   0}, // #8034
  { 4,  9,   0}, // #8035
  { 5, 18,   0}, // #8036
  { 6,  1,   0}, // #8037
  { 7,  7,   0}, // #8038
  { 8,  6,   0}, // #8039
  { 9,  2,   0}, // #8040
  {10,  3,   0}, // #8041
  {11,  3,   0}, // #8042
  {19,  1,   0}, // #8043
  { 1,  2,   0}, // #8044
  { 2,  9,   0}, // #8045
  { 3, 14,   0}, // #8046
  { 4, 21,   0}, // #8047
  { 5, 24,   0}, // #8048
  { 6,  4,   0}, // #8049
  { 7, 11,   0}, // #8050
  { 8,  7,   0}, // #8051
  { 9,  7,   0}, // #8052
  {10, 12,   0}, // #8053
  {11, 12,   0}, // #8054
  {14,  1,   0}, // #8055
  {15,  1,   0}, // #8056
  {19,  2,   0}, // #8057
  { 2,  2,   0}, // #8058
  { 3,  2,   0}, // #8059
  { 4,  2,   0}, // #8060
  { 5,  3,   0}, // #8061
  { 9,  2,   0}, // #8062
  {10,  2,   0}, // #8063
  {11,  2,   0}, // #8064
  {14,  2,   0}, // #8065
  {18,  2,   0}, // #8066
  {22,  2,   0}, // #8067
  { 4,  1,   0}, // #8068
  { 5,  1,   0}, // #8069
  { 7,  1,   0}, // #8070
  { 8,  1,   0}, // #8071
  {14,  1,   0}, // #8072
  {18,  1,   0}, // #8073
  {22,  1,   0}, // #8074
  { 1,  1,   0}, // #8075
  { 2,  6,   0}, // #8076
  { 3,  8,   0}, // #8077
  { 4, 17,   0}, // #8078
  { 5, 20,   0}, // #8079
  { 6,  2,   0}, // #8080
  { 7, 11,   0}, // #8081
  { 8,  9,   0}, // #8082
  { 9,  5,   0}, // #8083
  {10,  7,   0}, // #8084
  {11,  7,   0}, // #8085
  {14,  2,   0}, // #8086
  {15,  2,   0}, // #8087
  {19,  1,   0}, // #8088
  { 1,  1,   0}, // #8089
  { 2,  4,   0}, // #8090
  { 3,  5,   0}, // #8091
  { 4, 10,   0}, // #8092
  { 5, 10,   0}, // #8093
  { 6,  2,   0}, // #8094
  { 7,  7,   0}, // #8095
  { 8,  6,   0}, // #8096
  { 9,  3,   0}, // #8097
  {10,  4,   0}, // #8098
  {11,  4,   0}, // #8099
  {14,  3,   0}, // #8100
  {15,  3,   0}, // #8101
  {19,  1,   0}, // #8102
  { 2,  8,   0}, // #8103
  { 3, 14,   0}, // #8104
  { 4, 30,   0}, // #8105
  { 5, 54,   0}, // #8106
  { 6,  2,   0}, // #8107
  { 7, 18,   0}, // #8108
  { 8, 14,   0}, // #8109
  { 9,  8,   0}, // #8110
  {10, 10,   0}, // #8111
  {11, 11,   0}, // #8112
  {19,  2,   0}, // #8113
  { 2,  3,   0}, // #8114
  { 3,  4,   0}, // #8115
  { 4, 10,   0}, // #8116
  { 5, 15,   0}, // #8117
  { 6,  1,   0}, // #8118
  { 7,  7,   0}, // #8119
  { 8,  6,   0}, // #8120
  { 9,  3,   0}, // #8121
  {10,  4,   0}, // #8122
  {11,  4,   0}, // #8123
  {19,  1,   0}, // #8124
  { 2,  1,   0}, // #8125
  { 3,  1,   0}, // #8126
  { 4,  9,   0}, // #8127
  { 5,  9,   0}, // #8128
  { 7,  8,   0}, // #8129
  { 8,  8,   0}, // #8130
  { 9,  1,   0}, // #8131
  {10,  1,   0}, // #8132
  {11,  1,   0}, // #8133
  {13, 21,   0}, // #8134
  {14, 22,   0}, // #8135
  {15, 22,   0}, // #8136
  {20,  8,   0}, // #8137
  { 2, 35,   0}, // #8138
  { 3, 90,   0}, // #8139
  { 4, 134,   0}, // #8140
  { 5, 134,   0}, // #8141
  { 6, 34,   0}, // #8142
  { 7, 78,   0}, // #8143
  { 8, 44,   0}, // #8144
  { 9, 21,   0}, // #8145
  {10, 51,   0}, // #8146
  {11, 51,   0}, // #8147
  {14,  5,   0}, // #8148
  {15,  4,   0}, // #8149
  {18,  1,   0}, // #8150
  {19,  9,   0}, // #8151
  {22,  1,   0}, // #8152
  { 2, 52,   0}, // #8153
  { 3, 97,   0}, // #8154
  { 4, 150,   0}, // #8155
  { 5, 150,   0}, // #8156
  { 6, 45,   0}, // #8157
  { 7, 98,   0}, // #8158
  { 8, 53,   0}, // #8159
  { 9, 27,   0}, // #8160
  {10, 37,   0}, // #8161
  {11, 37,   0}, // #8162
  {14,  5,   0}, // #8163
  {15,  4,   0}, // #8164
  {18,  1,   0}, // #8165
  {19, 10,   0}, // #8166
  {22,  1,   0}, // #8167
  { 2,  1,   0}, // #8168
  { 3,  4,   0}, // #8169
  { 4,  7,   0}, // #8170
  { 5,  7,   0}, // #8171
  { 6,  2,   0}, // #8172
  { 7,  5,   0}, // #8173
  { 8,  3,   0}, // #8174
  { 9,  1,   0}, // #8175
  {10,  4,   0}, // #8176
  {11,  4,   0}, // #8177
  {13,  1,   0}, // #8178
  {14,  9,   0}, // #8179
  {15,  9,   0}, // #8180
  {17,  1,   0}, // #8181
  {18,  2,   0}, // #8182
  {19,  2,   0}, // #8183
  {20,  3,   0}, // #8184
  { 1,  2,   0}, // #8185
  { 2,  2,   0}, // #8186
  { 3,  7,   0}, // #8187
  { 4, 17,   0}, // #8188
  { 5, 17,   0}, // #8189
  { 6,  7,   0}, // #8190
  { 7, 17,   0}, // #8191
  { 8, 12,   0}, // #8192
  {13, 39,   0}, // #8193
  {14, 47,   0}, // #8194
  {15, 47,   0}, // #8195
  { 1,  4,   0}, // #8196
  { 2,  4,   0}, // #8197
  { 3,  6,   0}, // #8198
  { 4, 12,   0}, // #8199
  { 5, 12,   0}, // #8200
  { 6,  5,   0}, // #8201
  { 7, 11,   0}, // #8202
  { 8, 10,   0}, // #8203
  {10,  1,   0}, // #8204
  {11,  1,   0}, // #8205
  {13, 45,   0}, // #8206
  {14, 76,   0}, // #8207
  {15, 76,   0}, // #8208
  {20,  4,   0}, // #8209
  { 1,  9,   0}, // #8210
  { 2, 10,   0}, // #8211
  { 3, 26,   0}, // #8212
  { 4, 59,   0}, // #8213
  { 5, 59,   0}, // #8214
  { 6, 25,   0}, // #8215
  { 7, 47,   0}, // #8216
  { 8, 31,   0}, // #8217
  { 9,  1,   0}, // #8218
  {10, 17,   0}, // #8219
  {11, 17,   0}, // #8220
  {17, 30,   0}, // #8221
  {18, 41,   0}, // #8222
  {19, 16,   0}, // #8223
  {20,  1,   0}, // #8224
  { 1,  1,   0}, // #8225
  { 2,  1,   0}, // #8226
  { 3,  3,   0}, // #8227
  { 4,  3,   0}, // #8228
  { 5,  3,   0}, // #8229
  { 6,  1,   0}, // #8230
  { 7,  1,   0}, // #8231
  { 8,  1,   0}, // #8232
  {10,  1,   0}, // #8233
  {11,  1,   0}, // #8234
  {14,  2,   0}, // #8235
  {15,  2,   0}, // #8236
  { 1,  1,   0}, // #8237
  { 2,  1,   0}, // #8238
  { 3,  4,   0}, // #8239
  { 4,  4,   0}, // #8240
  { 5,  4,   0}, // #8241
  { 6,  1,   0}, // #8242
  { 7,  1,   0}, // #8243
  { 8,  1,   0}, // #8244
  {10,  2,   0}, // #8245
  {11,  2,   0}, // #8246
  {14,  4,   0}, // #8247
  {15,  4,   0}, // #8248
  { 1,  1,   0}, // #8249
  { 2,  1,   0}, // #8250
  { 3,  4,   0}, // #8251
  { 4,  4,   0}, // #8252
  { 5,  4,   0}, // #8253
  { 6,  1,   0}, // #8254
  { 7,  1,   0}, // #8255
  { 8,  1,   0}, // #8256
  {10,  2,   0}, // #8257
  {11,  2,   0}, // #8258
  {14,  8,   0}, // #8259
  {15,  8,   0}, // #8260
  { 4,  1,   0}, // #8261
  { 5,  1,   0}, // #8262
  { 7,  1,   0}, // #8263
  { 8,  1,   0}, // #8264
  {13,  1,   0}, // #8265
  {14,  2,   0}, // #8266
  {15,  2,   0}, // #8267
  {20,  1,   0}, // #8268
  { 2,  1,   0}, // #8269
  { 3,  1,   0}, // #8270
  { 4,  3,   0}, // #8271
  { 5,  3,   0}, // #8272
  { 7,  2,   0}, // #8273
  { 8,  2,   0}, // #8274
  { 9,  1,   0}, // #8275
  {10,  1,   0}, // #8276
  {11,  1,   0}, // #8277
  {14,  1,   0}, // #8278
  {15,  1,   0}, // #8279
  { 1,  2,   0}, // #8280
  { 2,  2,   0}, // #8281
  { 3,  2,   0}, // #8282
  { 4,  2,   0}, // #8283
  { 5,  2,   0}, // #8284
  { 6,  2,   0}, // #8285
  { 7,  2,   0}, // #8286
  { 8,  2,   0}, // #8287
  {14,  1,   0}, // #8288
  {18,  1,   0}, // #8289
  {22,  1,   0}, // #8290
  { 2,  3,   0}, // #8291
  { 3,  6,   0}, // #8292
  { 4,  7,   0}, // #8293
  { 5,  7,   0}, // #8294
  { 6,  1,   0}, // #8295
  { 7,  2,   0}, // #8296
  { 8,  1,   0}, // #8297
  {10,  1,   0}, // #8298
  {11,  1,   0}, // #8299
  {19,  1,   0}, // #8300
  { 2,  3,   0}, // #8301
  { 3,  6,   0}, // #8302
  { 4,  7,   0}, // #8303
  { 5,  7,   0}, // #8304
  { 6,  1,   0}, // #8305
  { 7,  2,   0}, // #8306
  { 8,  1,   0}, // #8307
  {10,  1,   0}, // #8308
  {11,  1,   0}, // #8309
  {14,  1,   0}, // #8310
  {15,  1,   0}, // #8311
  {19,  1,   0}, // #8312
  { 2,  2,   0}, // #8313
  { 3,  6,   0}, // #8314
  { 4,  7,   0}, // #8315
  { 5,  7,   0}, // #8316
  { 7,  1,   0}, // #8317
  { 8,  1,   0}, // #8318
  {10,  2,   0}, // #8319
  {11,  2,   0}, // #8320
  {14,  1,   0}, // #8321
  {15,  1,   0}, // #8322
  { 2,  1,   0}, // #8323
  { 3,  3,   0}, // #8324
  { 4,  3,   0}, // #8325
  { 5,  3,   0}, // #8326
  {10,  1,   0}, // #8327
  {11,  1,   0}, // #8328
  {14,  1,   0}, // #8329
  {15,  1,   0}, // #8330
  { 4,  1,   0}, // #8331
  { 5,  2,   0}, // #8332
  { 7,  1,   0}, // #8333
  { 8,  1,   0}, // #8334
  {14,  1,   0}, // #8335
  {15,  1,   0}, // #8336
  { 4,  1,   0}, // #8337
  { 5,  5,   0}, // #8338
  { 7,  1,   0}, // #8339
  { 8,  1,   0}, // #8340
  {14,  2,   0}, // #8341
  {15,  1,   0}, // #8342
  {18,  1,   0}, // #8343
  {22,  1,   0}, // #8344
  { 2,  2,   0}, // #8345
  { 3,  4,   0}, // #8346
  { 4,  4,   0}, // #8347
  { 5,  4,   0}, // #8348
  { 6,  2,   0}, // #8349
  { 7,  2,   0}, // #8350
  {10,  2,   0}, // #8351
  {11,  2,   0}, // #8352
  {19,  2,   0}, // #8353
  { 1,  2,   0}, // #8354
  { 2,  2,   0}, // #8355
  { 3,  4,   0}, // #8356
  { 4,  4,   0}, // #8357
  { 5,  4,   0}, // #8358
  { 6,  4,   0}, // #8359
  { 7,  4,   0}, // #8360
  { 8,  2,   0}, // #8361
  {10,  2,   0}, // #8362
  {11,  2,   0}, // #8363
  {19,  2,   0}, // #8364
  { 2,  5,   0}, // #8365
  { 3, 15,   0}, // #8366
  { 4, 15,   0}, // #8367
  { 5, 15,   0}, // #8368
  { 6,  5,   0}, // #8369
  { 7,  5,   0}, // #8370
  {10,  5,   0}, // #8371
  {11,  5,   0}, // #8372
  {19,  5,   0}, // #8373
  { 2,  7,   0}, // #8374
  { 3, 22,   0}, // #8375
  { 4, 23,   0}, // #8376
  { 5, 23,   0}, // #8377
  { 6,  9,   0}, // #8378
  { 7, 10,   0}, // #8379
  { 8,  1,   0}, // #8380
  {10,  9,   0}, // #8381
  {11,  9,   0}, // #8382
  {19,  9,   0}, // #8383
  { 1, 11,   0}, // #8384
  { 2, 11,   0}, // #8385
  { 3, 37,   0}, // #8386
  { 4, 37,   0}, // #8387
  { 5, 37,   0}, // #8388
  { 6, 37,   0}, // #8389
  { 7, 37,   0}, // #8390
  { 8, 11,   0}, // #8391
  {10, 17,   0}, // #8392
  {11, 17,   0}, // #8393
  {19, 17,   0}, // #8394
  { 1,  1,   0}, // #8395
  { 2,  4,   0}, // #8396
  { 3,  5,   0}, // #8397
  { 4,  9,   0}, // #8398
  { 5, 13,   0}, // #8399
  { 6,  2,   0}, // #8400
  { 7,  6,   0}, // #8401
  { 8,  5,   0}, // #8402
  { 9,  3,   0}, // #8403
  {10,  4,   0}, // #8404
  {11,  4,   0}, // #8405
  {14,  2,   0}, // #8406
  {15,  2,   0}, // #8407
  {19,  1,   0}, // #8408
  { 1,  1,   0}, // #8409
  { 2,  1,   0}, // #8410
  { 3,  3,   0}, // #8411
  { 4,  3,   0}, // #8412
  { 5,  3,   0}, // #8413
  { 6,  3,   0}, // #8414
  { 7,  3,   0}, // #8415
  { 8,  1,   0}, // #8416
  {10,  2,   0}, // #8417
  {11,  2,   0}, // #8418
  {19,  2,   0}, // #8419
  { 1,  1,   0}, // #8420
  { 2,  1,   0}, // #8421
  { 3,  3,   0}, // #8422
  { 4,  3,   0}, // #8423
  { 5,  3,   0}, // #8424
  { 6,  3,   0}, // #8425
  { 7,  3,   0}, // #8426
  { 8,  1,   0}, // #8427
  {10,  2,   0}, // #8428
  {11,  2,   0}, // #8429
  {14,  1,   0}, // #8430
  {15,  1,   0}, // #8431
  {19,  2,   0}, // #8432
  { 2,  1,   0}, // #8433
  { 3,  3,   0}, // #8434
  { 4,  3,   0}, // #8435
  { 5,  3,   0}, // #8436
  {10,  2,   0}, // #8437
  {11,  2,   0}, // #8438
  {14,  1,   0}, // #8439
  {15,  1,   0}, // #8440
  { 2, 52,   0}, // #8441
  { 3, 125,   0}, // #8442
  { 4, 178,   0}, // #8443
  { 5, 178,   0}, // #8444
  { 6, 41,   0}, // #8445
  { 7, 94,   0}, // #8446
  { 8, 53,   0}, // #8447
  { 9, 29,   0}, // #8448
  {10, 69,   0}, // #8449
  {11, 69,   0}, // #8450
  {14,  6,   0}, // #8451
  {15,  4,   0}, // #8452
  {18,  2,   0}, // #8453
  {19,  8,   0}, // #8454
  {22,  2,   0}, // #8455
  { 3,  2,   0}, // #8456
  { 4,  2,   0}, // #8457
  { 5,  2,   0}, // #8458
  { 6,  1,   0}, // #8459
  { 7,  1,   0}, // #8460
  {10,  2,   0}, // #8461
  {11,  2,   0}, // #8462
  {14,  1,   0}, // #8463
  {18,  1,   0}, // #8464
  {19,  1,   0}, // #8465
  {22,  1,   0}, // #8466
  { 3,  2,   0}, // #8467
  { 4,  2,   0}, // #8468
  { 5,  2,   0}, // #8469
  { 6,  2,   0}, // #8470
  { 7,  2,   0}, // #8471
  {10,  2,   0}, // #8472
  {11,  2,   0}, // #8473
  {14,  1,   0}, // #8474
  {18,  1,   0}, // #8475
  {19,  2,   0}, // #8476
  {22,  1,   0}, // #8477
  { 1,  1,   0}, // #8478
  { 2,  2,   0}, // #8479
  { 3,  2,   0}, // #8480
  { 4,  2,   0}, // #8481
  { 5,  3,   0}, // #8482
  { 6,  1,   0}, // #8483
  { 7,  1,   0}, // #8484
  { 8,  1,   0}, // #8485
  {14,  2,   0}, // #8486
  {18,  2,   0}, // #8487
  {22,  2,   0}, // #8488
  { 1,  1,   0}, // #8489
  { 2,  2,   0}, // #8490
  { 3,  2,   0}, // #8491
  { 4,  2,   0}, // #8492
  { 5,  3,   0}, // #8493
  { 6,  1,   0}, // #8494
  { 7,  1,   0}, // #8495
  { 8,  1,   0}, // #8496
  {14,  4,   0}, // #8497
  {18,  4,   0}, // #8498
  {22,  4,   0}, // #8499
  { 1,  2,   0}, // #8500
  { 2,  2,   0}, // #8501
  { 3,  2,   0}, // #8502
  { 4,  2,   0}, // #8503
  { 5,  3,   0}, // #8504
  { 6,  2,   0}, // #8505
  { 7,  2,   0}, // #8506
  { 8,  2,   0}, // #8507
  {14,  8,   0}, // #8508
  {18,  8,   0}, // #8509
  {22,  8,   0}, // #8510
  { 1,  2,   0}, // #8511
  { 2,  2,   0}, // #8512
  { 3,  2,   0}, // #8513
  { 4,  2,   0}, // #8514
  { 5,  3,   0}, // #8515
  { 6,  2,   0}, // #8516
  { 7,  2,   0}, // #8517
  { 8,  2,   0}, // #8518
  {14, 16,   0}, // #8519
  {18, 16,   0}, // #8520
  {22, 16,   0}, // #8521
  { 1,  1,   0}, // #8522
  { 2,  2,   0}, // #8523
  { 3,  2,   0}, // #8524
  { 4,  2,   0}, // #8525
  { 5,  3,   0}, // #8526
  { 6,  1,   0}, // #8527
  { 7,  1,   0}, // #8528
  { 8,  1,   0}, // #8529
  {14,  8,   0}, // #8530
  {18,  8,   0}, // #8531
  {22,  8,   0}, // #8532
  { 3,  3,   0}, // #8533
  { 4,  3,   0}, // #8534
  { 5,  3,   0}, // #8535
  { 6,  2,   0}, // #8536
  { 7,  2,   0}, // #8537
  {10,  2,   0}, // #8538
  {11,  2,   0}, // #8539
  {14,  1,   0}, // #8540
  {15,  1,   0}, // #8541
  {19,  2,   0}, // #8542
  { 2,  5,   0}, // #8543
  { 3, 14,   0}, // #8544
  { 4, 14,   0}, // #8545
  { 5, 14,   0}, // #8546
  { 6,  5,   0}, // #8547
  { 7,  5,   0}, // #8548
  {10,  5,   0}, // #8549
  {11,  5,   0}, // #8550
  {14,  1,   0}, // #8551
  {15,  1,   0}, // #8552
  {19,  5,   0}, // #8553
  { 2,  3,   0}, // #8554
  { 3,  3,   0}, // #8555
  { 4,  3,   0}, // #8556
  { 5,  3,   0}, // #8557
  {14,  1,   0}, // #8558
  {15,  1,   0}, // #8559
  { 1,  1,   0}, // #8560
  { 2,  1,   0}, // #8561
  { 3,  2,   0}, // #8562
  { 4,  2,   0}, // #8563
  { 5,  2,   0}, // #8564
  { 6,  1,   0}, // #8565
  { 7,  1,   0}, // #8566
  { 8,  1,   0}, // #8567
  {10,  1,   0}, // #8568
  {11,  1,   0}, // #8569
  {14,  2,   0}, // #8570
  {15,  2,   0}, // #8571
  { 1,  1,   0}, // #8572
  { 2,  1,   0}, // #8573
  { 3,  3,   0}, // #8574
  { 4,  3,   0}, // #8575
  { 5,  3,   0}, // #8576
  { 6,  1,   0}, // #8577
  { 7,  1,   0}, // #8578
  { 8,  1,   0}, // #8579
  {10,  2,   0}, // #8580
  {11,  2,   0}, // #8581
  {14,  4,   0}, // #8582
  {15,  4,   0}, // #8583
  { 1,  1,   0}, // #8584
  { 2,  1,   0}, // #8585
  { 3,  3,   0}, // #8586
  { 4,  3,   0}, // #8587
  { 5,  3,   0}, // #8588
  { 6,  1,   0}, // #8589
  { 7,  1,   0}, // #8590
  { 8,  1,   0}, // #8591
  {10,  2,   0}, // #8592
  {11,  2,   0}, // #8593
  {14,  8,   0}, // #8594
  {15,  8,   0}, // #8595
  { 1,  1,   0}, // #8596
  { 2,  1,   0}, // #8597
  { 3,  3,   0}, // #8598
  { 4,  3,   0}, // #8599
  { 5,  3,   0}, // #8600
  { 6,  3,   0}, // #8601
  { 7,  3,   0}, // #8602
  { 8,  1,   0}, // #8603
  {10,  2,   0}, // #8604
  {11,  2,   0}, // #8605
  {14, 16,   0}, // #8606
  {15, 16,   0}, // #8607
  {19,  2,   0}, // #8608
  { 1,  7,   0}, // #8609
  { 2,  7,   0}, // #8610
  { 3, 22,   0}, // #8611
  { 4, 22,   0}, // #8612
  { 5, 22,   0}, // #8613
  { 6, 22,   0}, // #8614
  { 7, 22,   0}, // #8615
  { 8,  7,   0}, // #8616
  {10,  9,   0}, // #8617
  {11,  9,   0}, // #8618
  {19,  9,   0}, // #8619
  { 2,  7,   0}, // #8620
  { 3, 21,   0}, // #8621
  { 4, 22,   0}, // #8622
  { 5, 22,   0}, // #8623
  { 6,  9,   0}, // #8624
  { 7, 10,   0}, // #8625
  { 8,  1,   0}, // #8626
  {10,  9,   0}, // #8627
  {11,  9,   0}, // #8628
  {14,  1,   0}, // #8629
  {15,  1,   0}, // #8630
  {19,  9,   0}, // #8631
  { 1,  7,   0}, // #8632
  { 2,  7,   0}, // #8633
  { 3, 21,   0}, // #8634
  { 4, 21,   0}, // #8635
  { 5, 21,   0}, // #8636
  { 6, 21,   0}, // #8637
  { 7, 21,   0}, // #8638
  { 8,  7,   0}, // #8639
  {10,  9,   0}, // #8640
  {11,  9,   0}, // #8641
  {14,  1,   0}, // #8642
  {15,  1,   0}, // #8643
  {19,  9,   0}, // #8644
  { 1, 11,   0}, // #8645
  { 2, 11,   0}, // #8646
  { 3, 36,   0}, // #8647
  { 4, 36,   0}, // #8648
  { 5, 36,   0}, // #8649
  { 6, 36,   0}, // #8650
  { 7, 36,   0}, // #8651
  { 8, 11,   0}, // #8652
  {10, 17,   0}, // #8653
  {11, 17,   0}, // #8654
  {14,  1,   0}, // #8655
  {15,  1,   0}, // #8656
  {19, 17,   0}, // #8657
  { 2,  1,   0}, // #8658
  { 3,  1,   0}, // #8659
  { 4,  3,   0}, // #8660
  { 5,  8,   0}, // #8661
  { 7,  2,   0}, // #8662
  { 8,  2,   0}, // #8663
  { 9,  1,   0}, // #8664
  {10,  1,   0}, // #8665
  {11,  1,   0}, // #8666
  {14,  1,   0}, // #8667
  {15,  1,   0}, // #8668
  { 2,  1,   0}, // #8669
  { 3,  1,   0}, // #8670
  { 4,  3,   0}, // #8671
  { 5,  7,   0}, // #8672
  { 7,  2,   0}, // #8673
  { 8,  2,   0}, // #8674
  { 9,  1,   0}, // #8675
  {10,  1,   0}, // #8676
  {11,  1,   0}, // #8677
  {14,  2,   0}, // #8678
  {15,  1,   0}, // #8679
  {18,  1,   0}, // #8680
  {22,  1,   0}, // #8681
  { 4,  1,   0}, // #8682
  { 5,  2,   0}, // #8683
  { 7,  1,   0}, // #8684
  { 8,  1,   0}, // #8685
  {14,  1,   0}, // #8686
  {18,  1,   0}, // #8687
  {22,  1,   0}, // #8688
  { 2,  1,   0}, // #8689
  { 3,  4,   0}, // #8690
  { 4, 10,   0}, // #8691
  { 5, 10,   0}, // #8692
  { 6,  3,   0}, // #8693
  { 7,  9,   0}, // #8694
  { 8,  6,   0}, // #8695
  { 9,  1,   0}, // #8696
  {10,  4,   0}, // #8697
  {11,  4,   0}, // #8698
  {19,  3,   0}, // #8699
  { 1,  7,   0}, // #8700
  { 2, 26,   0}, // #8701
  { 3, 47,   0}, // #8702
  { 4, 73,   0}, // #8703
  { 5, 80,   0}, // #8704
  { 6, 28,   0}, // #8705
  { 7, 54,   0}, // #8706
  { 8, 33,   0}, // #8707
  { 9, 19,   0}, // #8708
  {10, 40,   0}, // #8709
  {11, 42,   0}, // #8710
  {14,  7,   0}, // #8711
  {15,  7,   0}, // #8712
  {19, 21,   0}, // #8713
  { 1,  7,   0}, // #8714
  { 2, 27,   0}, // #8715
  { 3, 47,   0}, // #8716
  { 4, 73,   0}, // #8717
  { 5, 80,   0}, // #8718
  { 6, 27,   0}, // #8719
  { 7, 53,   0}, // #8720
  { 8, 33,   0}, // #8721
  { 9, 19,   0}, // #8722
  {10, 39,   0}, // #8723
  {11, 42,   0}, // #8724
  {14,  7,   0}, // #8725
  {15,  7,   0}, // #8726
  {19, 20,   0}, // #8727
  { 1,  7,   0}, // #8728
  { 2, 28,   0}, // #8729
  { 3, 48,   0}, // #8730
  { 4, 76,   0}, // #8731
  { 5, 84,   0}, // #8732
  { 6, 27,   0}, // #8733
  { 7, 55,   0}, // #8734
  { 8, 35,   0}, // #8735
  { 9, 21,   0}, // #8736
  {10, 41,   0}, // #8737
  {11, 43,   0}, // #8738
  {14, 10,   0}, // #8739
  {15, 10,   0}, // #8740
  {19, 20,   0}, // #8741
  { 1,  7,   0}, // #8742
  { 2, 28,   0}, // #8743
  { 3, 49,   0}, // #8744
  { 4, 77,   0}, // #8745
  { 5, 88,   0}, // #8746
  { 6, 28,   0}, // #8747
  { 7, 56,   0}, // #8748
  { 8, 35,   0}, // #8749
  { 9, 21,   0}, // #8750
  {10, 42,   0}, // #8751
  {11, 44,   0}, // #8752
  {14, 11,   0}, // #8753
  {15, 11,   0}, // #8754
  {19, 21,   0}, // #8755
  { 1,  7,   0}, // #8756
  { 2, 24,   0}, // #8757
  { 3, 43,   0}, // #8758
  { 4, 67,   0}, // #8759
  { 5, 73,   0}, // #8760
  { 6, 26,   0}, // #8761
  { 7, 50,   0}, // #8762
  { 8, 31,   0}, // #8763
  { 9, 17,   0}, // #8764
  {10, 36,   0}, // #8765
  {11, 36,   0}, // #8766
  {14,  9,   0}, // #8767
  {15,  8,   0}, // #8768
  {18,  1,   0}, // #8769
  {19, 19,   0}, // #8770
  {22,  1,   0}, // #8771
  { 1,  7,   0}, // #8772
  { 2, 24,   0}, // #8773
  { 3, 46,   0}, // #8774
  { 4, 74,   0}, // #8775
  { 5, 79,   0}, // #8776
  { 6, 28,   0}, // #8777
  { 7, 56,   0}, // #8778
  { 8, 34,   0}, // #8779
  { 9, 17,   0}, // #8780
  {10, 38,   0}, // #8781
  {11, 38,   0}, // #8782
  {14, 12,   0}, // #8783
  {15, 11,   0}, // #8784
  {18,  1,   0}, // #8785
  {19, 21,   0}, // #8786
  {22,  1,   0}, // #8787
  { 1,  5,   0}, // #8788
  { 2, 11,   0}, // #8789
  { 3, 18,   0}, // #8790
  { 4, 26,   0}, // #8791
  { 5, 32,   0}, // #8792
  { 6, 12,   0}, // #8793
  { 7, 20,   0}, // #8794
  { 8, 13,   0}, // #8795
  { 9,  6,   0}, // #8796
  {10, 13,   0}, // #8797
  {11, 15,   0}, // #8798
  {14,  5,   0}, // #8799
  {18,  5,   0}, // #8800
  {19,  7,   0}, // #8801
  {22,  5,   0}, // #8802
  { 4,  1,   0}, // #8803
  { 5,  1,   0}, // #8804
  { 7,  1,   0}, // #8805
  { 8,  1,   0}, // #8806
  {20,  1,   0}, // #8807
  { 1,  8,   0}, // #8808
  { 2, 22,   0}, // #8809
  { 3, 23,   0}, // #8810
  { 4, 25,   0}, // #8811
  { 5, 25,   0}, // #8812
  { 6,  9,   0}, // #8813
  { 7, 11,   0}, // #8814
  { 8, 10,   0}, // #8815
  { 9, 14,   0}, // #8816
  {10, 15,   0}, // #8817
  {11, 15,   0}, // #8818
  {14,  3,   0}, // #8819
  {15,  3,   0}, // #8820
  {19,  1,   0}, // #8821
  { 1,  1,   0}, // #8822
  { 2,  6,   0}, // #8823
  { 3,  9,   0}, // #8824
  { 4, 18,   0}, // #8825
  { 5, 20,   0}, // #8826
  { 6,  4,   0}, // #8827
  { 7, 13,   0}, // #8828
  { 8, 10,   0}, // #8829
  { 9,  5,   0}, // #8830
  {10,  6,   0}, // #8831
  {11,  6,   0}, // #8832
  {14,  3,   0}, // #8833
  {15,  3,   0}, // #8834
  {19,  1,   0}, // #8835
  { 1,  1,   0}, // #8836
  { 2,  4,   0}, // #8837
  { 3,  4,   0}, // #8838
  { 4,  8,   0}, // #8839
  { 5, 10,   0}, // #8840
  { 6,  1,   0}, // #8841
  { 7,  5,   0}, // #8842
  { 8,  5,   0}, // #8843
  { 9,  3,   0}, // #8844
  {10,  3,   0}, // #8845
  {11,  3,   0}, // #8846
  {14,  3,   0}, // #8847
  {15,  2,   0}, // #8848
  {18,  1,   0}, // #8849
  {22,  1,   0}, // #8850
  { 2,  3,   0}, // #8851
  { 3,  4,   0}, // #8852
  { 4,  9,   0}, // #8853
  { 5, 10,   0}, // #8854
  { 6,  1,   0}, // #8855
  { 7,  6,   0}, // #8856
  { 8,  5,   0}, // #8857
  { 9,  3,   0}, // #8858
  {10,  3,   0}, // #8859
  {11,  3,   0}, // #8860
  {14,  3,   0}, // #8861
  {15,  2,   0}, // #8862
  {18,  1,   0}, // #8863
  {22,  1,   0}, // #8864
  { 2,  3,   0}, // #8865
  { 3,  3,   0}, // #8866
  { 4,  8,   0}, // #8867
  { 5,  8,   0}, // #8868
  { 7,  5,   0}, // #8869
  { 8,  5,   0}, // #8870
  { 9,  3,   0}, // #8871
  {10,  3,   0}, // #8872
  {11,  3,   0}, // #8873
  {14,  3,   0}, // #8874
  {15,  2,   0}, // #8875
  {18,  1,   0}, // #8876
  {22,  1,   0}, // #8877
  { 2,  3,   0}, // #8878
  { 3,  3,   0}, // #8879
  { 4,  7,   0}, // #8880
  { 5,  8,   0}, // #8881
  { 7,  4,   0}, // #8882
  { 8,  4,   0}, // #8883
  { 9,  3,   0}, // #8884
  {10,  3,   0}, // #8885
  {11,  3,   0}, // #8886
  {14,  2,   0}, // #8887
  {15,  1,   0}, // #8888
  {18,  1,   0}, // #8889
  {22,  1,   0}, // #8890
  { 1,  1,   0}, // #8891
  { 2,  4,   0}, // #8892
  { 3, 12,   0}, // #8893
  { 4, 20,   0}, // #8894
  { 5, 22,   0}, // #8895
  { 6,  8,   0}, // #8896
  { 7, 16,   0}, // #8897
  { 8,  9,   0}, // #8898
  { 9,  3,   0}, // #8899
  {10, 10,   0}, // #8900
  {11, 10,   0}, // #8901
  {14,  3,   0}, // #8902
  {15,  1,   0}, // #8903
  {18,  2,   0}, // #8904
  {19,  7,   0}, // #8905
  {22,  2,   0}, // #8906
  { 2,  1,   0}, // #8907
  { 3,  6,   0}, // #8908
  { 4, 13,   0}, // #8909
  { 5, 18,   0}, // #8910
  { 6,  5,   0}, // #8911
  { 7, 12,   0}, // #8912
  { 8,  7,   0}, // #8913
  { 9,  1,   0}, // #8914
  {10,  6,   0}, // #8915
  {11,  6,   0}, // #8916
  {14,  2,   0}, // #8917
  {18,  2,   0}, // #8918
  {19,  5,   0}, // #8919
  {22,  2,   0}, // #8920
  { 2,  8,   0}, // #8921
  { 3, 22,   0}, // #8922
  { 4, 38,   0}, // #8923
  { 5, 44,   0}, // #8924
  { 6, 12,   0}, // #8925
  { 7, 28,   0}, // #8926
  { 8, 16,   0}, // #8927
  { 9,  7,   0}, // #8928
  {10, 19,   0}, // #8929
  {11, 21,   0}, // #8930
  {14,  2,   0}, // #8931
  {18,  2,   0}, // #8932
  {19, 12,   0}, // #8933
  {22,  2,   0}, // #8934
  { 3,  1,   0}, // #8935
  { 4,  2,   0}, // #8936
  { 5,  3,   0}, // #8937
  { 6,  1,   0}, // #8938
  { 7,  2,   0}, // #8939
  { 8,  1,   0}, // #8940
  {10,  1,   0}, // #8941
  {11,  1,   0}, // #8942
  {19,  1,   0}, // #8943
  { 2,  4,   0}, // #8944
  { 3, 10,   0}, // #8945
  { 4, 18,   0}, // #8946
  { 5, 24,   0}, // #8947
  { 6,  3,   0}, // #8948
  { 7, 11,   0}, // #8949
  { 8,  8,   0}, // #8950
  { 9,  4,   0}, // #8951
  {10,  7,   0}, // #8952
  {11,  9,   0}, // #8953
  {19,  3,   0}, // #8954
  { 1,  6,   0}, // #8955
  { 2, 21,   0}, // #8956
  { 3, 38,   0}, // #8957
  { 4, 66,   0}, // #8958
  { 5, 70,   0}, // #8959
  { 6, 23,   0}, // #8960
  { 7, 51,   0}, // #8961
  { 8, 34,   0}, // #8962
  { 9, 15,   0}, // #8963
  {10, 31,   0}, // #8964
  {11, 31,   0}, // #8965
  {14,  8,   0}, // #8966
  {15,  7,   0}, // #8967
  {18,  1,   0}, // #8968
  {19, 16,   0}, // #8969
  {22,  1,   0}, // #8970
  { 1,  6,   0}, // #8971
  { 2, 21,   0}, // #8972
  { 3, 37,   0}, // #8973
  { 4, 64,   0}, // #8974
  { 5, 70,   0}, // #8975
  { 6, 22,   0}, // #8976
  { 7, 49,   0}, // #8977
  { 8, 33,   0}, // #8978
  { 9, 15,   0}, // #8979
  {10, 31,   0}, // #8980
  {11, 31,   0}, // #8981
  {14,  8,   0}, // #8982
  {15,  7,   0}, // #8983
  {18,  1,   0}, // #8984
  {19, 16,   0}, // #8985
  {22,  1,   0}, // #8986
  { 1,  6,   0}, // #8987
  { 2, 21,   0}, // #8988
  { 3, 40,   0}, // #8989
  { 4, 70,   0}, // #8990
  { 5, 74,   0}, // #8991
  { 6, 25,   0}, // #8992
  { 7, 55,   0}, // #8993
  { 8, 36,   0}, // #8994
  { 9, 15,   0}, // #8995
  {10, 33,   0}, // #8996
  {11, 33,   0}, // #8997
  {14, 10,   0}, // #8998
  {15,  9,   0}, // #8999
  {18,  1,   0}, // #9000
  {19, 18,   0}, // #9001
  {22,  1,   0}, // #9002
  { 1,  6,   0}, // #9003
  { 2, 21,   0}, // #9004
  { 3, 39,   0}, // #9005
  { 4, 68,   0}, // #9006
  { 5, 74,   0}, // #9007
  { 6, 24,   0}, // #9008
  { 7, 53,   0}, // #9009
  { 8, 35,   0}, // #9010
  { 9, 15,   0}, // #9011
  {10, 33,   0}, // #9012
  {11, 33,   0}, // #9013
  {14, 10,   0}, // #9014
  {15,  9,   0}, // #9015
  {18,  1,   0}, // #9016
  {19, 18,   0}, // #9017
  {22,  1,   0}, // #9018
  { 1,  7,   0}, // #9019
  { 2, 23,   0}, // #9020
  { 3, 40,   0}, // #9021
  { 4, 65,   0}, // #9022
  { 5, 71,   0}, // #9023
  { 6, 24,   0}, // #9024
  { 7, 49,   0}, // #9025
  { 8, 32,   0}, // #9026
  { 9, 16,   0}, // #9027
  {10, 33,   0}, // #9028
  {11, 33,   0}, // #9029
  {14,  8,   0}, // #9030
  {15,  7,   0}, // #9031
  {18,  1,   0}, // #9032
  {19, 17,   0}, // #9033
  {22,  1,   0}, // #9034
  { 1,  7,   0}, // #9035
  { 2, 23,   0}, // #9036
  { 3, 43,   0}, // #9037
  { 4, 71,   0}, // #9038
  { 5, 77,   0}, // #9039
  { 6, 27,   0}, // #9040
  { 7, 55,   0}, // #9041
  { 8, 35,   0}, // #9042
  { 9, 16,   0}, // #9043
  {10, 36,   0}, // #9044
  {11, 36,   0}, // #9045
  {14, 11,   0}, // #9046
  {15, 10,   0}, // #9047
  {18,  1,   0}, // #9048
  {19, 20,   0}, // #9049
  {22,  1,   0}, // #9050
  { 4,  2,   0}, // #9051
  { 5,  3,   0}, // #9052
  { 7,  2,   0}, // #9053
  { 8,  2,   0}, // #9054
  {14,  1,   0}, // #9055
  {15,  1,   0}, // #9056
  {20,  2,   0}, // #9057
  { 4,  2,   0}, // #9058
  { 5,  3,   0}, // #9059
  { 7,  2,   0}, // #9060
  { 8,  2,   0}, // #9061
  {20,  2,   0}, // #9062
  { 4,  2,   0}, // #9063
  { 5,  4,   0}, // #9064
  { 7,  2,   0}, // #9065
  { 8,  2,   0}, // #9066
  {20,  2,   0}, // #9067
  { 2,  2,   0}, // #9068
  { 3,  2,   0}, // #9069
  { 4,  7,   0}, // #9070
  { 5,  8,   0}, // #9071
  { 7,  5,   0}, // #9072
  { 8,  5,   0}, // #9073
  { 9,  2,   0}, // #9074
  {10,  2,   0}, // #9075
  {11,  2,   0}, // #9076
  {14,  2,   0}, // #9077
  {15,  1,   0}, // #9078
  {18,  1,   0}, // #9079
  {22,  1,   0}, // #9080
  { 2,  3,   0}, // #9081
  { 3,  3,   0}, // #9082
  { 4,  7,   0}, // #9083
  { 5,  9,   0}, // #9084
  { 7,  4,   0}, // #9085
  { 8,  4,   0}, // #9086
  { 9,  3,   0}, // #9087
  {10,  3,   0}, // #9088
  {11,  3,   0}, // #9089
  {14,  2,   0}, // #9090
  {15,  1,   0}, // #9091
  {18,  1,   0}, // #9092
  {22,  1,   0}, // #9093
  { 1,  2,   0}, // #9094
  { 2,  9,   0}, // #9095
  { 3, 16,   0}, // #9096
  { 4, 24,   0}, // #9097
  { 5, 24,   0}, // #9098
  { 6,  6,   0}, // #9099
  { 7, 14,   0}, // #9100
  { 8,  7,   0}, // #9101
  { 9,  7,   0}, // #9102
  {10, 11,   0}, // #9103
  {11, 11,   0}, // #9104
  {14,  1,   0}, // #9105
  {15,  1,   0}, // #9106
  {19,  4,   0}, // #9107
  { 2,  1,   0}, // #9108
  { 3,  1,   0}, // #9109
  { 4,  3,   0}, // #9110
  { 5,  5,   0}, // #9111
  { 7,  2,   0}, // #9112
  { 8,  2,   0}, // #9113
  { 9,  1,   0}, // #9114
  {10,  1,   0}, // #9115
  {11,  1,   0}, // #9116
  {14,  1,   0}, // #9117
  {18,  1,   0}, // #9118
  {22,  1,   0}, // #9119
  { 3,  1,   0}, // #9120
  { 4,  1,   0}, // #9121
  { 5,  2,   0}, // #9122
  { 6,  1,   0}, // #9123
  { 7,  1,   0}, // #9124
  {10,  1,   0}, // #9125
  {11,  1,   0}, // #9126
  {19,  1,   0}, // #9127
  { 1,  6,   0}, // #9128
  { 2, 13,   0}, // #9129
  { 3, 13,   0}, // #9130
  { 4, 13,   0}, // #9131
  { 5, 13,   0}, // #9132
  { 6,  6,   0}, // #9133
  { 7,  6,   0}, // #9134
  { 8,  6,   0}, // #9135
  { 9,  7,   0}, // #9136
  {10,  7,   0}, // #9137
  {11,  7,   0}, // #9138
  {14, 18,   0}, // #9139
  {15, 18,   0}, // #9140
  { 1,  6,   0}, // #9141
  { 2, 13,   0}, // #9142
  { 3, 13,   0}, // #9143
  { 4, 13,   0}, // #9144
  { 5, 13,   0}, // #9145
  { 6,  6,   0}, // #9146
  { 7,  6,   0}, // #9147
  { 8,  6,   0}, // #9148
  { 9,  7,   0}, // #9149
  {10,  7,   0}, // #9150
  {11,  7,   0}, // #9151
  {14, 17,   0}, // #9152
  {15, 17,   0}, // #9153
  { 1,  5,   0}, // #9154
  { 2, 13,   0}, // #9155
  { 3, 13,   0}, // #9156
  { 4, 13,   0}, // #9157
  { 5, 13,   0}, // #9158
  { 6,  5,   0}, // #9159
  { 7,  5,   0}, // #9160
  { 8,  5,   0}, // #9161
  { 9,  8,   0}, // #9162
  {10,  8,   0}, // #9163
  {11,  8,   0}, // #9164
  {14, 20,   0}, // #9165
  {15, 20,   0}, // #9166
  { 1,  1,   0}, // #9167
  { 2,  1,   0}, // #9168
  { 3,  1,   0}, // #9169
  { 4,  2,   0}, // #9170
  { 5,  2,   0}, // #9171
  { 6,  1,   0}, // #9172
  { 7,  2,   0}, // #9173
  { 8,  2,   0}, // #9174
  {14,  1,   0}, // #9175
  {15,  1,   0}, // #9176
  { 2,  4,   0}, // #9177
  { 3,  5,   0}, // #9178
  { 4,  6,   0}, // #9179
  { 5,  8,   0}, // #9180
  { 6,  1,   0}, // #9181
  { 7,  2,   0}, // #9182
  { 8,  1,   0}, // #9183
  { 9,  4,   0}, // #9184
  {10,  5,   0}, // #9185
  {11,  5,   0}, // #9186
  {19,  1,   0}, // #9187
  { 1,  1,   0}, // #9188
  { 2, 43,   0}, // #9189
  { 3, 91,   0}, // #9190
  { 4, 143,   0}, // #9191
  { 5, 143,   0}, // #9192
  { 6, 49,   0}, // #9193
  { 7, 101,   0}, // #9194
  { 8, 53,   0}, // #9195
  { 9, 23,   0}, // #9196
  {10, 35,   0}, // #9197
  {11, 35,   0}, // #9198
  {14,  6,   0}, // #9199
  {15,  4,   0}, // #9200
  {18,  2,   0}, // #9201
  {19, 12,   0}, // #9202
  {22,  2,   0}, // #9203
  { 1,  1,   0}, // #9204
  { 2, 43,   0}, // #9205
  { 3, 91,   0}, // #9206
  { 4, 144,   0}, // #9207
  { 5, 144,   0}, // #9208
  { 6, 49,   0}, // #9209
  { 7, 102,   0}, // #9210
  { 8, 54,   0}, // #9211
  { 9, 23,   0}, // #9212
  {10, 35,   0}, // #9213
  {11, 35,   0}, // #9214
  {14,  6,   0}, // #9215
  {15,  4,   0}, // #9216
  {18,  2,   0}, // #9217
  {19, 12,   0}, // #9218
  {22,  2,   0}, // #9219
  { 2, 52,   0}, // #9220
  { 3, 97,   0}, // #9221
  { 4, 149,   0}, // #9222
  { 5, 149,   0}, // #9223
  { 6, 45,   0}, // #9224
  { 7, 97,   0}, // #9225
  { 8, 52,   0}, // #9226
  { 9, 27,   0}, // #9227
  {10, 37,   0}, // #9228
  {11, 37,   0}, // #9229
  {14,  5,   0}, // #9230
  {15,  4,   0}, // #9231
  {18,  1,   0}, // #9232
  {19, 10,   0}, // #9233
  {22,  1,   0}, // #9234
  { 2, 52,   0}, // #9235
  { 3, 123,   0}, // #9236
  { 4, 176,   0}, // #9237
  { 5, 176,   0}, // #9238
  { 6, 41,   0}, // #9239
  { 7, 94,   0}, // #9240
  { 8, 53,   0}, // #9241
  { 9, 29,   0}, // #9242
  {10, 68,   0}, // #9243
  {11, 68,   0}, // #9244
  {14,  6,   0}, // #9245
  {15,  4,   0}, // #9246
  {18,  2,   0}, // #9247
  {19,  9,   0}, // #9248
  {22,  2,   0}, // #9249
  { 2,  1,   0}, // #9250
  { 3,  3,   0}, // #9251
  { 4,  3,   0}, // #9252
  { 5,  3,   0}, // #9253
  { 6,  1,   0}, // #9254
  { 7,  1,   0}, // #9255
  {10,  2,   0}, // #9256
  {11,  2,   0}, // #9257
  {14,  1,   0}, // #9258
  {15,  1,   0}, // #9259
  {19,  1,   0}, // #9260
  { 2,  1,   0}, // #9261
  { 3,  3,   0}, // #9262
  { 4,  3,   0}, // #9263
  { 5,  3,   0}, // #9264
  { 6,  1,   0}, // #9265
  { 7,  1,   0}, // #9266
  {10,  2,   0}, // #9267
  {11,  2,   0}, // #9268
  {19,  1,   0}, // #9269
  { 2,  2,   0}, // #9270
  { 3,  4,   0}, // #9271
  { 4,  4,   0}, // #9272
  { 5,  4,   0}, // #9273
  { 6,  1,   0}, // #9274
  { 7,  1,   0}, // #9275
  {10,  2,   0}, // #9276
  {11,  2,   0}, // #9277
  {14,  1,   0}, // #9278
  {15,  1,   0}, // #9279
  {19,  1,   0}, // #9280
  { 2,  2,   0}, // #9281
  { 3,  4,   0}, // #9282
  { 4,  4,   0}, // #9283
  { 5,  4,   0}, // #9284
  { 6,  1,   0}, // #9285
  { 7,  1,   0}, // #9286
  {10,  2,   0}, // #9287
  {11,  2,   0}, // #9288
  {19,  1,   0}, // #9289
  { 1,  2,   0}, // #9290
  { 2,  2,   0}, // #9291
  { 3,  4,   0}, // #9292
  { 4,  4,   0}, // #9293
  { 5,  4,   0}, // #9294
  { 6,  4,   0}, // #9295
  { 7,  4,   0}, // #9296
  { 8,  2,   0}, // #9297
  {10,  2,   0}, // #9298
  {11,  2,   0}, // #9299
  {14,  1,   0}, // #9300
  {15,  1,   0}, // #9301
  {19,  2,   0}, // #9302
  { 2,  2,   0}, // #9303
  { 3,  5,   0}, // #9304
  { 4,  6,   0}, // #9305
  { 5,  6,   0}, // #9306
  { 6,  2,   0}, // #9307
  { 7,  3,   0}, // #9308
  { 8,  1,   0}, // #9309
  {10,  2,   0}, // #9310
  {11,  2,   0}, // #9311
  {14,  1,   0}, // #9312
  {15,  1,   0}, // #9313
  {19,  2,   0}, // #9314
  { 2,  2,   0}, // #9315
  { 3,  5,   0}, // #9316
  { 4,  5,   0}, // #9317
  { 5,  5,   0}, // #9318
  { 6,  2,   0}, // #9319
  { 7,  2,   0}, // #9320
  {10,  2,   0}, // #9321
  {11,  2,   0}, // #9322
  {19,  2,   0}, // #9323
  { 2,  2,   0}, // #9324
  { 3,  4,   0}, // #9325
  { 4,  5,   0}, // #9326
  { 5,  5,   0}, // #9327
  { 6,  2,   0}, // #9328
  { 7,  3,   0}, // #9329
  { 8,  1,   0}, // #9330
  {10,  2,   0}, // #9331
  {11,  2,   0}, // #9332
  {14,  1,   0}, // #9333
  {15,  1,   0}, // #9334
  {19,  2,   0}, // #9335
  { 1,  2,   0}, // #9336
  { 2,  2,   0}, // #9337
  { 3,  4,   0}, // #9338
  { 4,  5,   0}, // #9339
  { 5,  5,   0}, // #9340
  { 6,  4,   0}, // #9341
  { 7,  5,   0}, // #9342
  { 8,  3,   0}, // #9343
  {10,  2,   0}, // #9344
  {11,  2,   0}, // #9345
  {14,  1,   0}, // #9346
  {15,  1,   0}, // #9347
  {19,  2,   0}, // #9348
  { 2,  2,   0}, // #9349
  { 3,  5,   0}, // #9350
  { 4,  6,   0}, // #9351
  { 5,  6,   0}, // #9352
  { 6,  2,   0}, // #9353
  { 7,  3,   0}, // #9354
  { 8,  1,   0}, // #9355
  {10,  2,   0}, // #9356
  {11,  2,   0}, // #9357
  {19,  2,   0}, // #9358
  { 2,  2,   0}, // #9359
  { 3,  4,   0}, // #9360
  { 4,  4,   0}, // #9361
  { 5,  4,   0}, // #9362
  { 6,  2,   0}, // #9363
  { 7,  2,   0}, // #9364
  {10,  2,   0}, // #9365
  {11,  2,   0}, // #9366
  {14,  1,   0}, // #9367
  {15,  1,   0}, // #9368
  {19,  2,   0}, // #9369
  { 2,  1,   0}, // #9370
  { 3,  4,   0}, // #9371
  { 4,  5,   0}, // #9372
  { 5,  5,   0}, // #9373
  { 6,  1,   0}, // #9374
  { 7,  2,   0}, // #9375
  { 8,  1,   0}, // #9376
  {10,  1,   0}, // #9377
  {11,  1,   0}, // #9378
  {14,  1,   0}, // #9379
  {15,  1,   0}, // #9380
  {19,  1,   0}, // #9381
  { 2,  1,   0}, // #9382
  { 3,  4,   0}, // #9383
  { 4,  4,   0}, // #9384
  { 5,  4,   0}, // #9385
  { 6,  1,   0}, // #9386
  { 7,  1,   0}, // #9387
  {10,  1,   0}, // #9388
  {11,  1,   0}, // #9389
  {19,  1,   0}, // #9390
  { 2,  1,   0}, // #9391
  { 3,  4,   0}, // #9392
  { 4,  4,   0}, // #9393
  { 5,  4,   0}, // #9394
  { 6,  1,   0}, // #9395
  { 7,  1,   0}, // #9396
  {10,  2,   0}, // #9397
  {11,  2,   0}, // #9398
  {14,  1,   0}, // #9399
  {15,  1,   0}, // #9400
  {19,  1,   0}, // #9401
  { 2,  1,   0}, // #9402
  { 3,  4,   0}, // #9403
  { 4,  4,   0}, // #9404
  { 5,  4,   0}, // #9405
  { 6,  1,   0}, // #9406
  { 7,  1,   0}, // #9407
  {10,  2,   0}, // #9408
  {11,  2,   0}, // #9409
  {19,  1,   0}, // #9410
  { 1,  1,   0}, // #9411
  { 2,  1,   0}, // #9412
  { 3,  4,   0}, // #9413
  { 4,  4,   0}, // #9414
  { 5,  4,   0}, // #9415
  { 6,  4,   0}, // #9416
  { 7,  4,   0}, // #9417
  { 8,  1,   0}, // #9418
  {10,  2,   0}, // #9419
  {11,  2,   0}, // #9420
  {14,  1,   0}, // #9421
  {15,  1,   0}, // #9422
  {19,  2,   0}, // #9423
  { 1,  1,   0}, // #9424
  { 2,  1,   0}, // #9425
  { 3,  4,   0}, // #9426
  { 4,  4,   0}, // #9427
  { 5,  4,   0}, // #9428
  { 6,  4,   0}, // #9429
  { 7,  4,   0}, // #9430
  { 8,  1,   0}, // #9431
  {10,  2,   0}, // #9432
  {11,  2,   0}, // #9433
  {19,  2,   0}, // #9434
  { 2,  2,   0}, // #9435
  { 3,  5,   0}, // #9436
  { 4,  6,   0}, // #9437
  { 5,  6,   0}, // #9438
  { 6,  1,   0}, // #9439
  { 7,  2,   0}, // #9440
  { 8,  1,   0}, // #9441
  {10,  1,   0}, // #9442
  {11,  1,   0}, // #9443
  {14,  1,   0}, // #9444
  {15,  1,   0}, // #9445
  {19,  1,   0}, // #9446
  { 2,  2,   0}, // #9447
  { 3,  4,   0}, // #9448
  { 4,  4,   0}, // #9449
  { 5,  4,   0}, // #9450
  { 6,  1,   0}, // #9451
  { 7,  1,   0}, // #9452
  {10,  1,   0}, // #9453
  {11,  1,   0}, // #9454
  {19,  1,   0}, // #9455
  { 2,  2,   0}, // #9456
  { 3,  3,   0}, // #9457
  { 4,  3,   0}, // #9458
  { 5,  3,   0}, // #9459
  { 6,  1,   0}, // #9460
  { 7,  1,   0}, // #9461
  {10,  1,   0}, // #9462
  {11,  1,   0}, // #9463
  {14,  1,   0}, // #9464
  {15,  1,   0}, // #9465
  {19,  1,   0}, // #9466
  { 2,  2,   0}, // #9467
  { 3,  3,   0}, // #9468
  { 4,  3,   0}, // #9469
  { 5,  3,   0}, // #9470
  { 6,  1,   0}, // #9471
  { 7,  1,   0}, // #9472
  {10,  1,   0}, // #9473
  {11,  1,   0}, // #9474
  {19,  1,   0}, // #9475
  { 1,  1,   0}, // #9476
  { 2,  2,   0}, // #9477
  { 3,  3,   0}, // #9478
  { 4,  3,   0}, // #9479
  { 5,  3,   0}, // #9480
  { 6,  1,   0}, // #9481
  { 7,  1,   0}, // #9482
  { 8,  1,   0}, // #9483
  { 2,  1,   0}, // #9484
  { 3,  2,   0}, // #9485
  { 4,  2,   0}, // #9486
  { 5,  2,   0}, // #9487
  {14,  1,   0}, // #9488
  {15,  1,   0}, // #9489
  { 1,  2,   0}, // #9490
  { 2,  2,   0}, // #9491
  { 3,  3,   0}, // #9492
  { 4,  3,   0}, // #9493
  { 5,  3,   0}, // #9494
  { 6,  2,   0}, // #9495
  { 7,  2,   0}, // #9496
  { 8,  2,   0}, // #9497
  {14,  1,   0}, // #9498
  {15,  1,   0}, // #9499
  { 1,  4,   0}, // #9500
  { 2,  4,   0}, // #9501
  { 3,  7,   0}, // #9502
  { 4,  8,   0}, // #9503
  { 5,  8,   0}, // #9504
  { 6,  7,   0}, // #9505
  { 7,  8,   0}, // #9506
  { 8,  5,   0}, // #9507
  {10,  1,   0}, // #9508
  {11,  1,   0}, // #9509
  {14,  1,   0}, // #9510
  {15,  1,   0}, // #9511
  {19,  1,   0}, // #9512
  { 1,  4,   0}, // #9513
  { 2,  4,   0}, // #9514
  { 3,  5,   0}, // #9515
  { 4,  6,   0}, // #9516
  { 5,  6,   0}, // #9517
  { 6,  5,   0}, // #9518
  { 7,  6,   0}, // #9519
  { 8,  5,   0}, // #9520
  {10,  1,   0}, // #9521
  {11,  1,   0}, // #9522
  {19,  1,   0}, // #9523
  { 1,  1,   0}, // #9524
  { 2,  1,   0}, // #9525
  { 3,  3,   0}, // #9526
  { 4,  3,   0}, // #9527
  { 5,  3,   0}, // #9528
  { 6,  3,   0}, // #9529
  { 7,  3,   0}, // #9530
  { 8,  1,   0}, // #9531
  {10,  2,   0}, // #9532
  {11,  2,   0}, // #9533
  {14,  8,   0}, // #9534
  {15,  8,   0}, // #9535
  {19,  2,   0}, // #9536
  { 5,  1,   0}, // #9537
  {14,  2,   0}, // #9538
  {18,  2,   0}, // #9539
  {22,  2,   0}, // #9540
  { 3, 11,   0}, // #9541
  { 4, 11,   0}, // #9542
  { 5, 11,   0}, // #9543
  { 6,  8,   0}, // #9544
  { 7,  8,   0}, // #9545
  {10,  8,   0}, // #9546
  {11,  8,   0}, // #9547
  {14,  1,   0}, // #9548
  {15,  1,   0}, // #9549
  {19,  8,   0}, // #9550
  { 3, 12,   0}, // #9551
  { 4, 12,   0}, // #9552
  { 5, 12,   0}, // #9553
  { 6,  8,   0}, // #9554
  { 7,  8,   0}, // #9555
  {10,  8,   0}, // #9556
  {11,  8,   0}, // #9557
  {19,  8,   0}, // #9558
  { 1,  1,   0}, // #9559
  { 2,  9,   0}, // #9560
  { 3, 29,   0}, // #9561
  { 4, 29,   0}, // #9562
  { 5, 29,   0}, // #9563
  { 6, 12,   0}, // #9564
  { 7, 12,   0}, // #9565
  { 8,  1,   0}, // #9566
  {10, 13,   0}, // #9567
  {11, 13,   0}, // #9568
  {14,  1,   0}, // #9569
  {15,  1,   0}, // #9570
  {19, 11,   0}, // #9571
  { 1,  1,   0}, // #9572
  { 2,  9,   0}, // #9573
  { 3, 30,   0}, // #9574
  { 4, 30,   0}, // #9575
  { 5, 30,   0}, // #9576
  { 6, 12,   0}, // #9577
  { 7, 12,   0}, // #9578
  { 8,  1,   0}, // #9579
  {10, 13,   0}, // #9580
  {11, 13,   0}, // #9581
  {19, 11,   0}, // #9582
  { 1, 13,   0}, // #9583
  { 2, 13,   0}, // #9584
  { 3, 45,   0}, // #9585
  { 4, 45,   0}, // #9586
  { 5, 45,   0}, // #9587
  { 6, 45,   0}, // #9588
  { 7, 45,   0}, // #9589
  { 8, 13,   0}, // #9590
  {10, 23,   0}, // #9591
  {11, 23,   0}, // #9592
  {14,  1,   0}, // #9593
  {15,  1,   0}, // #9594
  {19, 23,   0}, // #9595
  { 1, 13,   0}, // #9596
  { 2, 13,   0}, // #9597
  { 3, 46,   0}, // #9598
  { 4, 46,   0}, // #9599
  { 5, 46,   0}, // #9600
  { 6, 46,   0}, // #9601
  { 7, 46,   0}, // #9602
  { 8, 13,   0}, // #9603
  {10, 23,   0}, // #9604
  {11, 23,   0}, // #9605
  {19, 23,   0}, // #9606
  { 3,  4,   0}, // #9607
  { 4,  4,   0}, // #9608
  { 5,  4,   0}, // #9609
  { 6,  4,   0}, // #9610
  { 7,  4,   0}, // #9611
  {10,  4,   0}, // #9612
  {11,  4,   0}, // #9613
  {14,  1,   0}, // #9614
  {15,  1,   0}, // #9615
  {19,  4,   0}, // #9616
  { 3,  4,   0}, // #9617
  { 4,  4,   0}, // #9618
  { 5,  4,   0}, // #9619
  { 6,  4,   0}, // #9620
  { 7,  4,   0}, // #9621
  {10,  4,   0}, // #9622
  {11,  4,   0}, // #9623
  {19,  4,   0}, // #9624
  { 1,  8,   0}, // #9625
  { 2,  8,   0}, // #9626
  { 3, 29,   0}, // #9627
  { 4, 29,   0}, // #9628
  { 5, 29,   0}, // #9629
  { 6, 29,   0}, // #9630
  { 7, 29,   0}, // #9631
  { 8,  8,   0}, // #9632
  {10, 14,   0}, // #9633
  {11, 14,   0}, // #9634
  {14,  1,   0}, // #9635
  {15,  1,   0}, // #9636
  {19, 14,   0}, // #9637
  { 1,  8,   0}, // #9638
  { 2,  8,   0}, // #9639
  { 3, 30,   0}, // #9640
  { 4, 30,   0}, // #9641
  { 5, 30,   0}, // #9642
  { 6, 30,   0}, // #9643
  { 7, 30,   0}, // #9644
  { 8,  8,   0}, // #9645
  {10, 14,   0}, // #9646
  {11, 14,   0}, // #9647
  {19, 14,   0}, // #9648
  { 1,  1,   0}, // #9649
  { 2,  1,   0}, // #9650
  { 3,  3,   0}, // #9651
  { 4,  4,   0}, // #9652
  { 5,  4,   0}, // #9653
  { 6,  3,   0}, // #9654
  { 7,  4,   0}, // #9655
  { 8,  2,   0}, // #9656
  {10,  2,   0}, // #9657
  {11,  2,   0}, // #9658
  {14,  1,   0}, // #9659
  {18,  1,   0}, // #9660
  {19,  2,   0}, // #9661
  {22,  1,   0}, // #9662
  { 1,  1,   0}, // #9663
  { 2,  1,   0}, // #9664
  { 3,  3,   0}, // #9665
  { 4,  3,   0}, // #9666
  { 5,  4,   0}, // #9667
  { 6,  3,   0}, // #9668
  { 7,  3,   0}, // #9669
  { 8,  1,   0}, // #9670
  {10,  2,   0}, // #9671
  {11,  2,   0}, // #9672
  {14,  2,   0}, // #9673
  {18,  2,   0}, // #9674
  {19,  2,   0}, // #9675
  {22,  2,   0}, // #9676
  {25,  1,   0}, // #9677
  {26,  1,   0}, // #9678
  {15,  1,   0}, // #9679
  {23,  1,   0}, // #9680
  {24,  1,   0}, // #9681
  {25,  1,   0}, // #9682
  {26,  1,   0}, // #9683
  {16,  1,   0}, // #9684
  {24,  1,   0}, // #9685
  {25,  1,   0}, // #9686
  {26,  1,   0}, // #9687
  {16,  2,   0}, // #9688
  {19,  1,   0}, // #9689
  {20,  1,   0}, // #9690
  {22,  1,   0}, // #9691
  {24,  2,   0}, // #9692
  {25,  3,   0}, // #9693
  {26,  6,   0}, // #9694
  {16,  1,   0}, // #9695
  {19,  1,   0}, // #9696
  {24,  1,   0}, // #9697
  {25,  1,   0}, // #9698
  {26,  2,   0}, // #9699
  {17,  1,   0}, // #9700
  {23,  1,   0}, // #9701
  {25,  1,   0}, // #9702
  {26,  1,   0}, // #9703
  {20,  1,   0}, // #9704
  {22,  1,   0}, // #9705
  {26,  2,   0}, // #9706
  { 4,  1,   0}, // #9707
  {13,  1,   0}, // #9708
  {17,  1,   0}, // #9709
  {18,  1,   0}, // #9710
  {23,  1,   0}, // #9711
  {25,  1,   0}, // #9712
  {26,  1,   0}, // #9713
  {19,  1,   0}, // #9714
  {26,  1,   0}, // #9715
  {19,  1,   0}, // #9716
  {20,  1,   0}, // #9717
  {22,  1,   0}, // #9718
  {25,  1,   0}, // #9719
  {26,  4,   0}, // #9720
  { 3,  1,   0}, // #9721
  {13,  1,   0}, // #9722
  {14,  1,   0}, // #9723
  {15,  1,   0}, // #9724
  {16,  1,   0}, // #9725
  {23,  1,   0}, // #9726
  {24,  1,   0}, // #9727
  {25,  1,   0}, // #9728
  {26,  1,   0}, // #9729
  {19,  1,   0}, // #9730
  {25,  1,   0}, // #9731
  {26,  2,   0}, // #9732
  {13,  1,   0}, // #9733
  {19,  1,   0}, // #9734
  {23,  1,   0}, // #9735
  {25,  1,   0}, // #9736
  {26,  2,   0}, // #9737
  {13,  1,   0}, // #9738
  {23,  1,   0}, // #9739
  {25,  1,   0}, // #9740
  {26,  1,   0}, // #9741
  { 3,  1,   0}, // #9742
  {13,  1,   0}, // #9743
  {14,  1,   0}, // #9744
  {15,  1,   0}, // #9745
  {16,  1,   0}, // #9746
  {19,  1,   0}, // #9747
  {23,  1,   0}, // #9748
  {24,  1,   0}, // #9749
  {25,  1,   0}, // #9750
  {26,  2,   0}, // #9751
  { 3,  2,   0}, // #9752
  {13,  2,   0}, // #9753
  {14,  2,   0}, // #9754
  {15,  2,   0}, // #9755
  {16,  2,   0}, // #9756
  {19,  1,   0}, // #9757
  {23,  2,   0}, // #9758
  {24,  2,   0}, // #9759
  {25,  2,   0}, // #9760
  {26,  3,   0}, // #9761
  { 3,  2,   0}, // #9762
  {13,  2,   0}, // #9763
  {14,  2,   0}, // #9764
  {15,  2,   0}, // #9765
  {16,  2,   0}, // #9766
  {23,  2,   0}, // #9767
  {24,  2,   0}, // #9768
  {25,  2,   0}, // #9769
  {26,  2,   0}, // #9770
  { 3,  3,   0}, // #9771
  { 8,  6,   0}, // #9772
  {13,  3,   0}, // #9773
  {14,  3,   0}, // #9774
  {15,  9,   0}, // #9775
  {16,  3,   0}, // #9776
  {17,  6,   0}, // #9777
  {19,  1,   0}, // #9778
  {21,  6,   0}, // #9779
  {23, 10,   0}, // #9780
  {24,  9,   0}, // #9781
  {25, 10,   0}, // #9782
  {26, 11,   0}, // #9783
  { 3,  3,   0}, // #9784
  { 8,  6,   0}, // #9785
  {13,  3,   0}, // #9786
  {14,  3,   0}, // #9787
  {15,  9,   0}, // #9788
  {16,  3,   0}, // #9789
  {17,  6,   0}, // #9790
  {21,  6,   0}, // #9791
  {23, 11,   0}, // #9792
  {24,  9,   0}, // #9793
  {25, 11,   0}, // #9794
  {26, 11,   0}, // #9795
  {16,  1,   0}, // #9796
  {17,  1,   0}, // #9797
  {19,  1,   0}, // #9798
  {23,  1,   0}, // #9799
  {24,  1,   0}, // #9800
  {25,  2,   0}, // #9801
  {26,  3,   0}, // #9802
  {16,  1,   0}, // #9803
  {17,  1,   0}, // #9804
  {23,  1,   0}, // #9805
  {24,  1,   0}, // #9806
  {25,  2,   0}, // #9807
  {26,  2,   0}, // #9808
  {19,  1,   0}, // #9809
  {23,  2,   0}, // #9810
  {25,  2,   0}, // #9811
  {26,  3,   0}, // #9812
  {23,  2,   0}, // #9813
  {25,  2,   0}, // #9814
  {26,  2,   0}, // #9815
  {17,  1,   0}, // #9816
  {19,  1,   0}, // #9817
  {23,  1,   0}, // #9818
  {25,  1,   0}, // #9819
  {26,  2,   0}, // #9820
  { 4,  1,   0}, // #9821
  {13,  1,   0}, // #9822
  {17,  1,   0}, // #9823
  {18,  1,   0}, // #9824
  {19,  1,   0}, // #9825
  {23,  1,   0}, // #9826
  {25,  1,   0}, // #9827
  {26,  2,   0}, // #9828
  {16,  1,   0}, // #9829
  {19,  1,   0}, // #9830
  {20,  1,   0}, // #9831
  {22,  1,   0}, // #9832
  {24,  1,   0}, // #9833
  {25,  1,   0}, // #9834
  {26,  4,   0}, // #9835
  {25,  3,   0}, // #9836
  {26,  3,   0}, // #9837
  {16,  2,   0}, // #9838
  {24,  2,   0}, // #9839
  {25,  5,   0}, // #9840
  {26,  5,   0}, // #9841
  { 8,  1,   0}, // #9842
  {13,  1,   0}, // #9843
  {15,  1,   0}, // #9844
  {17,  1,   0}, // #9845
  {19,  1,   0}, // #9846
  {21,  1,   0}, // #9847
  {23,  2,   0}, // #9848
  {24,  1,   0}, // #9849
  {25,  2,   0}, // #9850
  {26,  3,   0}, // #9851
  { 8,  1,   0}, // #9852
  {13,  1,   0}, // #9853
  {15,  1,   0}, // #9854
  {17,  1,   0}, // #9855
  {21,  1,   0}, // #9856
  {23,  2,   0}, // #9857
  {24,  1,   0}, // #9858
  {25,  2,   0}, // #9859
  {26,  2,   0}, // #9860
  {13,  2,   0}, // #9861
  {19,  1,   0}, // #9862
  {23,  2,   0}, // #9863
  {25,  2,   0}, // #9864
  {26,  3,   0}, // #9865
  {13,  2,   0}, // #9866
  {23,  2,   0}, // #9867
  {25,  2,   0}, // #9868
  {26,  2,   0}, // #9869
  { 1, 10,   0}, // #9870
  { 3,  1,   0}, // #9871
  {13,  1,   0}, // #9872
  {14,  1,   0}, // #9873
  {15,  1,   0}, // #9874
  {16,  1,   0}, // #9875
  {19,  1,   0}, // #9876
  {23,  1,   0}, // #9877
  {24,  1,   0}, // #9878
  {25,  1,   0}, // #9879
  {26,  2,   0}, // #9880
  { 3,  7,   0}, // #9881
  { 4,  2,   0}, // #9882
  { 8,  8,   0}, // #9883
  { 9,  3,   0}, // #9884
  {13,  9,   0}, // #9885
  {14,  7,   0}, // #9886
  {15, 16,   0}, // #9887
  {16, 10,   0}, // #9888
  {17, 10,   0}, // #9889
  {18,  5,   0}, // #9890
  {21, 11,   0}, // #9891
  {23, 18,   0}, // #9892
  {24, 19,   0}, // #9893
  {25, 32,   0}, // #9894
  {26, 32,   0}, // #9895
  { 1, 10,   0}, // #9896
  { 3,  1,   0}, // #9897
  {13,  1,   0}, // #9898
  {14,  1,   0}, // #9899
  {15,  1,   0}, // #9900
  {16,  1,   0}, // #9901
  {23,  1,   0}, // #9902
  {24,  1,   0}, // #9903
  {25,  1,   0}, // #9904
  {26,  1,   0}, // #9905
  { 2,  4,   0}, // #9906
  { 3,  1,   0}, // #9907
  {13,  1,   0}, // #9908
  {14,  1,   0}, // #9909
  {15,  1,   0}, // #9910
  {16,  1,   0}, // #9911
  {19,  1,   0}, // #9912
  {23,  1,   0}, // #9913
  {24,  1,   0}, // #9914
  {25,  1,   0}, // #9915
  {26,  2,   0}, // #9916
  { 2,  4,   0}, // #9917
  { 3,  1,   0}, // #9918
  {13,  1,   0}, // #9919
  {14,  1,   0}, // #9920
  {15,  1,   0}, // #9921
  {16,  1,   0}, // #9922
  {23,  1,   0}, // #9923
  {24,  1,   0}, // #9924
  {25,  1,   0}, // #9925
  {26,  1,   0}, // #9926
  { 2,  3,   0}, // #9927
  { 3,  1,   0}, // #9928
  {13,  1,   0}, // #9929
  {14,  1,   0}, // #9930
  {15,  1,   0}, // #9931
  {16,  1,   0}, // #9932
  {19,  1,   0}, // #9933
  {23,  1,   0}, // #9934
  {24,  1,   0}, // #9935
  {25,  1,   0}, // #9936
  {26,  2,   0}, // #9937
  { 2,  3,   0}, // #9938
  { 3,  1,   0}, // #9939
  {13,  1,   0}, // #9940
  {14,  1,   0}, // #9941
  {15,  1,   0}, // #9942
  {16,  1,   0}, // #9943
  {23,  1,   0}, // #9944
  {24,  1,   0}, // #9945
  {25,  1,   0}, // #9946
  {26,  1,   0}, // #9947
  { 8,  1,   0}, // #9948
  {15,  1,   0}, // #9949
  {17,  1,   0}, // #9950
  {19,  1,   0}, // #9951
  {21,  1,   0}, // #9952
  {23,  3,   0}, // #9953
  {24,  1,   0}, // #9954
  {25,  3,   0}, // #9955
  {26,  4,   0}, // #9956
  { 8,  1,   0}, // #9957
  {15,  1,   0}, // #9958
  {17,  1,   0}, // #9959
  {21,  1,   0}, // #9960
  {23,  3,   0}, // #9961
  {24,  1,   0}, // #9962
  {25,  3,   0}, // #9963
  {26,  3,   0}, // #9964
  { 8,  1,   0}, // #9965
  {15,  1,   0}, // #9966
  {17,  1,   0}, // #9967
  {19,  1,   0}, // #9968
  {21,  1,   0}, // #9969
  {23,  4,   0}, // #9970
  {24,  1,   0}, // #9971
  {25,  4,   0}, // #9972
  {26,  5,   0}, // #9973
  { 8,  1,   0}, // #9974
  {15,  1,   0}, // #9975
  {17,  1,   0}, // #9976
  {21,  1,   0}, // #9977
  {23,  4,   0}, // #9978
  {24,  1,   0}, // #9979
  {25,  4,   0}, // #9980
  {26,  4,   0}, // #9981
  { 8,  1,   0}, // #9982
  {15,  1,   0}, // #9983
  {17,  1,   0}, // #9984
  {20,  1,   0}, // #9985
  {21,  1,   0}, // #9986
  {22,  1,   0}, // #9987
  {23,  1,   0}, // #9988
  {24,  1,   0}, // #9989
  {25,  1,   0}, // #9990
  {26,  3,   0}, // #9991
  { 3,  1,   0}, // #9992
  { 8,  1,   0}, // #9993
  {13,  1,   0}, // #9994
  {14,  1,   0}, // #9995
  {15,  2,   0}, // #9996
  {16,  1,   0}, // #9997
  {17,  1,   0}, // #9998
  {21,  1,   0}, // #9999
  {23,  2,   0}, // #10000
  {24,  2,   0}, // #10001
  {25,  2,   0}, // #10002
  {26,  2,   0}, // #10003
  {15,  9,   0}, // #10004
  {23,  9,   0}, // #10005
  {24,  9,   0}, // #10006
  {25, 10,   0}, // #10007
  {26, 10,   0}, // #10008
  {15,  2,   0}, // #10009
  {23,  2,   0}, // #10010
  {24,  2,   0}, // #10011
  {25,  2,   0}, // #10012
  {26,  2,   0}, // #10013
  { 8,  2,   0}, // #10014
  {15,  2,   0}, // #10015
  {17,  2,   0}, // #10016
  {19,  1,   0}, // #10017
  {21,  2,   0}, // #10018
  {23,  3,   0}, // #10019
  {24,  2,   0}, // #10020
  {25,  3,   0}, // #10021
  {26,  4,   0}, // #10022
  { 8,  2,   0}, // #10023
  {15,  2,   0}, // #10024
  {17,  2,   0}, // #10025
  {21,  2,   0}, // #10026
  {23,  3,   0}, // #10027
  {24,  2,   0}, // #10028
  {25,  3,   0}, // #10029
  {26,  3,   0}, // #10030
  { 3,  2,   0}, // #10031
  { 8,  4,   0}, // #10032
  {13,  2,   0}, // #10033
  {14,  2,   0}, // #10034
  {15,  6,   0}, // #10035
  {16,  2,   0}, // #10036
  {17,  4,   0}, // #10037
  {19,  1,   0}, // #10038
  {21,  4,   0}, // #10039
  {23,  6,   0}, // #10040
  {24,  6,   0}, // #10041
  {25,  7,   0}, // #10042
  {26,  8,   0}, // #10043
  { 3,  4,   0}, // #10044
  { 4,  2,   0}, // #10045
  { 8,  4,   0}, // #10046
  { 9,  8,   0}, // #10047
  {13,  6,   0}, // #10048
  {14,  4,   0}, // #10049
  {15,  8,   0}, // #10050
  {16, 26,   0}, // #10051
  {17,  6,   0}, // #10052
  {18, 10,   0}, // #10053
  {21, 12,   0}, // #10054
  {23, 10,   0}, // #10055
  {24, 30,   0}, // #10056
  {25, 66,   0}, // #10057
  {26, 66,   0}, // #10058
  { 4,  1,   0}, // #10059
  {13,  1,   0}, // #10060
  {16,  1,   0}, // #10061
  {17,  1,   0}, // #10062
  {18,  1,   0}, // #10063
  {19,  1,   0}, // #10064
  {23,  1,   0}, // #10065
  {24,  1,   0}, // #10066
  {25,  4,   0}, // #10067
  {26,  5,   0}, // #10068
  { 4,  1,   0}, // #10069
  {13,  1,   0}, // #10070
  {16,  1,   0}, // #10071
  {17,  1,   0}, // #10072
  {18,  1,   0}, // #10073
  {23,  1,   0}, // #10074
  {24,  1,   0}, // #10075
  {25,  4,   0}, // #10076
  {26,  4,   0}, // #10077
  { 4,  1,   0}, // #10078
  {13,  1,   0}, // #10079
  {17,  1,   0}, // #10080
  {18,  1,   0}, // #10081
  {19,  1,   0}, // #10082
  {23,  1,   0}, // #10083
  {25,  2,   0}, // #10084
  {26,  3,   0}, // #10085
  { 4,  1,   0}, // #10086
  {13,  1,   0}, // #10087
  {17,  1,   0}, // #10088
  {18,  1,   0}, // #10089
  {23,  1,   0}, // #10090
  {25,  2,   0}, // #10091
  {26,  2,   0}, // #10092
  { 4,  1,   0}, // #10093
  {13,  1,   0}, // #10094
  {16,  1,   0}, // #10095
  {17,  1,   0}, // #10096
  {18,  1,   0}, // #10097
  {19,  1,   0}, // #10098
  {23,  1,   0}, // #10099
  {24,  1,   0}, // #10100
  {25,  3,   0}, // #10101
  {26,  4,   0}, // #10102
  { 4,  1,   0}, // #10103
  {13,  1,   0}, // #10104
  {16,  1,   0}, // #10105
  {17,  1,   0}, // #10106
  {18,  1,   0}, // #10107
  {23,  1,   0}, // #10108
  {24,  1,   0}, // #10109
  {25,  3,   0}, // #10110
  {26,  3,   0}, // #10111
  { 4,  1,   0}, // #10112
  { 8,  1,   0}, // #10113
  {13,  1,   0}, // #10114
  {15,  1,   0}, // #10115
  {17,  2,   0}, // #10116
  {18,  1,   0}, // #10117
  {19,  1,   0}, // #10118
  {21,  1,   0}, // #10119
  {23,  2,   0}, // #10120
  {24,  1,   0}, // #10121
  {25,  2,   0}, // #10122
  {26,  3,   0}, // #10123
  { 4,  1,   0}, // #10124
  { 8,  1,   0}, // #10125
  {13,  1,   0}, // #10126
  {15,  1,   0}, // #10127
  {17,  2,   0}, // #10128
  {18,  1,   0}, // #10129
  {21,  1,   0}, // #10130
  {23,  2,   0}, // #10131
  {24,  1,   0}, // #10132
  {25,  2,   0}, // #10133
  {26,  2,   0}, // #10134
  { 8,  1,   0}, // #10135
  {15,  1,   0}, // #10136
  {17,  1,   0}, // #10137
  {21,  1,   0}, // #10138
  {23,  1,   0}, // #10139
  {24,  1,   0}, // #10140
  {25,  1,   0}, // #10141
  {26,  1,   0}, // #10142
  { 3,  1,   0}, // #10143
  {13,  1,   0}, // #10144
  {14,  1,   0}, // #10145
  {15,  1,   0}, // #10146
  {16,  1,   0}, // #10147
  {19,  1,   0}, // #10148
  {23,  1,   0}, // #10149
  {24,  1,   0}, // #10150
  {25,  2,   0}, // #10151
  {26,  3,   0}, // #10152
  {15,  1,   0}, // #10153
  {19,  1,   0}, // #10154
  {23,  1,   0}, // #10155
  {24,  1,   0}, // #10156
  {25,  1,   0}, // #10157
  {26,  2,   0}, // #10158
  { 8,  1,   0}, // #10159
  {15,  1,   0}, // #10160
  {17,  1,   0}, // #10161
  {19,  1,   0}, // #10162
  {21,  1,   0}, // #10163
  {23,  1,   0}, // #10164
  {24,  1,   0}, // #10165
  {25,  1,   0}, // #10166
  {26,  2,   0}, // #10167
  { 8,  2,   0}, // #10168
  {15,  3,   0}, // #10169
  {17,  2,   0}, // #10170
  {19,  1,   0}, // #10171
  {21,  2,   0}, // #10172
  {23,  3,   0}, // #10173
  {24,  3,   0}, // #10174
  {25,  3,   0}, // #10175
  {26,  4,   0}, // #10176
  { 8,  2,   0}, // #10177
  {15,  3,   0}, // #10178
  {17,  2,   0}, // #10179
  {21,  2,   0}, // #10180
  {23,  3,   0}, // #10181
  {24,  3,   0}, // #10182
  {25,  3,   0}, // #10183
  {26,  3,   0}, // #10184
  { 8,  2,   0}, // #10185
  {15,  2,   0}, // #10186
  {17,  2,   0}, // #10187
  {21,  2,   0}, // #10188
  {23,  2,   0}, // #10189
  {24,  2,   0}, // #10190
  {25,  2,   0}, // #10191
  {26,  2,   0}, // #10192
  { 8,  2,   0}, // #10193
  {15,  2,   0}, // #10194
  {17,  2,   0}, // #10195
  {19,  1,   0}, // #10196
  {21,  2,   0}, // #10197
  {23,  2,   0}, // #10198
  {24,  2,   0}, // #10199
  {25,  2,   0}, // #10200
  {26,  3,   0}, // #10201
  { 3,  4,   0}, // #10202
  { 8,  3,   0}, // #10203
  {13,  4,   0}, // #10204
  {14,  4,   0}, // #10205
  {15,  7,   0}, // #10206
  {16,  4,   0}, // #10207
  {17,  3,   0}, // #10208
  {19,  1,   0}, // #10209
  {21,  3,   0}, // #10210
  {23,  7,   0}, // #10211
  {24,  7,   0}, // #10212
  {25,  8,   0}, // #10213
  {26,  9,   0}, // #10214
  { 3,  4,   0}, // #10215
  { 8,  3,   0}, // #10216
  {13,  4,   0}, // #10217
  {14,  4,   0}, // #10218
  {15,  7,   0}, // #10219
  {16,  4,   0}, // #10220
  {17,  3,   0}, // #10221
  {21,  3,   0}, // #10222
  {23,  7,   0}, // #10223
  {24,  7,   0}, // #10224
  {25,  8,   0}, // #10225
  {26,  8,   0}, // #10226
  { 3,  4,   0}, // #10227
  { 8,  3,   0}, // #10228
  {13,  4,   0}, // #10229
  {14,  4,   0}, // #10230
  {15,  7,   0}, // #10231
  {16,  4,   0}, // #10232
  {17,  3,   0}, // #10233
  {19,  1,   0}, // #10234
  {21,  3,   0}, // #10235
  {23,  8,   0}, // #10236
  {24,  7,   0}, // #10237
  {25,  9,   0}, // #10238
  {26, 10,   0}, // #10239
  { 3,  4,   0}, // #10240
  { 8,  3,   0}, // #10241
  {13,  4,   0}, // #10242
  {14,  4,   0}, // #10243
  {15,  7,   0}, // #10244
  {16,  4,   0}, // #10245
  {17,  3,   0}, // #10246
  {21,  3,   0}, // #10247
  {23,  8,   0}, // #10248
  {24,  7,   0}, // #10249
  {25,  9,   0}, // #10250
  {26,  9,   0}, // #10251
  { 3,  3,   0}, // #10252
  {13,  3,   0}, // #10253
  {14,  3,   0}, // #10254
  {15,  3,   0}, // #10255
  {16,  3,   0}, // #10256
  {19,  1,   0}, // #10257
  {23,  3,   0}, // #10258
  {24,  3,   0}, // #10259
  {25,  3,   0}, // #10260
  {26,  4,   0}, // #10261
  { 3,  3,   0}, // #10262
  {13,  3,   0}, // #10263
  {14,  3,   0}, // #10264
  {15,  3,   0}, // #10265
  {16,  3,   0}, // #10266
  {23,  3,   0}, // #10267
  {24,  3,   0}, // #10268
  {25,  3,   0}, // #10269
  {26,  3,   0}, // #10270
  {19,  1,   0}, // #10271
  {20,  1,   0}, // #10272
  {22,  1,   0}, // #10273
  {26,  3,   0}, // #10274
  { 3,  1,   0}, // #10275
  { 8,  1,   0}, // #10276
  {13,  1,   0}, // #10277
  {14,  1,   0}, // #10278
  {15,  2,   0}, // #10279
  {16,  1,   0}, // #10280
  {17,  1,   0}, // #10281
  {19,  1,   0}, // #10282
  {21,  1,   0}, // #10283
  {23,  2,   0}, // #10284
  {24,  2,   0}, // #10285
  {25,  2,   0}, // #10286
  {26,  3,   0}, // #10287
  {16,  3,   0}, // #10288
  {19,  1,   0}, // #10289
  {20,  1,   0}, // #10290
  {22,  1,   0}, // #10291
  {24,  3,   0}, // #10292
  {25,  3,   0}, // #10293
  {26,  6,   0}, // #10294
  {16,  3,   0}, // #10295
  {24,  3,   0}, // #10296
  {25,  3,   0}, // #10297
  {26,  3,   0}, // #10298
  {16,  1,   0}, // #10299
  {20,  1,   0}, // #10300
  {22,  1,   0}, // #10301
  {24,  1,   0}, // #10302
  {25,  1,   0}, // #10303
  {26,  3,   0}, // #10304
  { 4,  1,   0}, // #10305
  {13,  1,   0}, // #10306
  {16,  2,   0}, // #10307
  {17,  1,   0}, // #10308
  {18,  1,   0}, // #10309
  {19,  1,   0}, // #10310
  {22,  1,   0}, // #10311
  {23,  1,   0}, // #10312
  {24,  2,   0}, // #10313
  {25,  4,   0}, // #10314
  {26,  6,   0}, // #10315
  { 4,  1,   0}, // #10316
  {13,  1,   0}, // #10317
  {17,  1,   0}, // #10318
  {18,  1,   0}, // #10319
  {19,  1,   0}, // #10320
  {22,  1,   0}, // #10321
  {23,  1,   0}, // #10322
  {25,  2,   0}, // #10323
  {26,  4,   0}, // #10324
  { 4,  1,   0}, // #10325
  {13,  1,   0}, // #10326
  {16,  2,   0}, // #10327
  {17,  1,   0}, // #10328
  {18,  1,   0}, // #10329
  {23,  1,   0}, // #10330
  {24,  2,   0}, // #10331
  {25,  4,   0}, // #10332
  {26,  4,   0}, // #10333
  { 2,  6,   0}, // #10334
  { 3,  1,   0}, // #10335
  {13,  1,   0}, // #10336
  {14,  1,   0}, // #10337
  {15,  1,   0}, // #10338
  {16,  1,   0}, // #10339
  {19,  1,   0}, // #10340
  {23,  1,   0}, // #10341
  {24,  1,   0}, // #10342
  {25,  1,   0}, // #10343
  {26,  2,   0}, // #10344
  { 2,  6,   0}, // #10345
  { 3,  1,   0}, // #10346
  {13,  1,   0}, // #10347
  {14,  1,   0}, // #10348
  {15,  1,   0}, // #10349
  {16,  1,   0}, // #10350
  {23,  1,   0}, // #10351
  {24,  1,   0}, // #10352
  {25,  1,   0}, // #10353
  {26,  1,   0}, // #10354
  { 2,  7,   0}, // #10355
  { 3,  1,   0}, // #10356
  {13,  1,   0}, // #10357
  {14,  1,   0}, // #10358
  {15,  1,   0}, // #10359
  {16,  1,   0}, // #10360
  {23,  1,   0}, // #10361
  {24,  1,   0}, // #10362
  {25,  1,   0}, // #10363
  {26,  1,   0}, // #10364
  {15,  2,   0}, // #10365
  {19,  1,   0}, // #10366
  {23,  2,   0}, // #10367
  {24,  2,   0}, // #10368
  {25,  2,   0}, // #10369
  {26,  3,   0}, // #10370
  { 8,  1,   0}, // #10371
  {13,  1,   0}, // #10372
  {15,  1,   0}, // #10373
  {17,  1,   0}, // #10374
  {20,  1,   0}, // #10375
  {21,  1,   0}, // #10376
  {22,  1,   0}, // #10377
  {23,  2,   0}, // #10378
  {24,  1,   0}, // #10379
  {25,  2,   0}, // #10380
  {26,  4,   0}, // #10381
  { 8,  1,   0}, // #10382
  {15,  2,   0}, // #10383
  {17,  1,   0}, // #10384
  {20,  1,   0}, // #10385
  {21,  1,   0}, // #10386
  {22,  1,   0}, // #10387
  {23,  2,   0}, // #10388
  {24,  2,   0}, // #10389
  {25,  2,   0}, // #10390
  {26,  4,   0}, // #10391
  { 8,  1,   0}, // #10392
  {15,  2,   0}, // #10393
  {17,  1,   0}, // #10394
  {21,  1,   0}, // #10395
  {23,  2,   0}, // #10396
  {24,  2,   0}, // #10397
  {25,  2,   0}, // #10398
  {26,  2,   0}, // #10399
  { 2,  8,   0}, // #10400
  { 3,  1,   0}, // #10401
  {13,  1,   0}, // #10402
  {14,  1,   0}, // #10403
  {15,  1,   0}, // #10404
  {16,  1,   0}, // #10405
  {19,  1,   0}, // #10406
  {23,  1,   0}, // #10407
  {24,  1,   0}, // #10408
  {25,  1,   0}, // #10409
  {26,  2,   0}, // #10410
  { 2,  8,   0}, // #10411
  { 3,  1,   0}, // #10412
  {13,  1,   0}, // #10413
  {14,  1,   0}, // #10414
  {15,  1,   0}, // #10415
  {16,  1,   0}, // #10416
  {23,  1,   0}, // #10417
  {24,  1,   0}, // #10418
  {25,  1,   0}, // #10419
  {26,  1,   0}, // #10420
  { 2, 16,   0}, // #10421
  { 3,  2,   0}, // #10422
  { 8,  1,   0}, // #10423
  {13,  2,   0}, // #10424
  {14,  2,   0}, // #10425
  {15,  3,   0}, // #10426
  {16,  2,   0}, // #10427
  {17,  1,   0}, // #10428
  {19,  1,   0}, // #10429
  {21,  1,   0}, // #10430
  {23,  3,   0}, // #10431
  {24,  3,   0}, // #10432
  {25,  3,   0}, // #10433
  {26,  4,   0}, // #10434
  { 2, 16,   0}, // #10435
  { 3,  2,   0}, // #10436
  { 8,  1,   0}, // #10437
  {13,  2,   0}, // #10438
  {14,  2,   0}, // #10439
  {15,  3,   0}, // #10440
  {16,  2,   0}, // #10441
  {17,  1,   0}, // #10442
  {21,  1,   0}, // #10443
  {23,  3,   0}, // #10444
  {24,  3,   0}, // #10445
  {25,  3,   0}, // #10446
  {26,  3,   0}, // #10447
  { 2,  5,   0}, // #10448
  { 3,  1,   0}, // #10449
  {13,  1,   0}, // #10450
  {14,  1,   0}, // #10451
  {15,  1,   0}, // #10452
  {16,  1,   0}, // #10453
  {19,  1,   0}, // #10454
  {23,  1,   0}, // #10455
  {24,  1,   0}, // #10456
  {25,  1,   0}, // #10457
  {26,  2,   0}, // #10458
  { 2,  5,   0}, // #10459
  { 3,  1,   0}, // #10460
  {13,  1,   0}, // #10461
  {14,  1,   0}, // #10462
  {15,  1,   0}, // #10463
  {16,  1,   0}, // #10464
  {23,  1,   0}, // #10465
  {24,  1,   0}, // #10466
  {25,  1,   0}, // #10467
  {26,  1,   0}, // #10468
  { 2, 10,   0}, // #10469
  { 3,  2,   0}, // #10470
  { 8,  1,   0}, // #10471
  {13,  2,   0}, // #10472
  {14,  2,   0}, // #10473
  {15,  3,   0}, // #10474
  {16,  2,   0}, // #10475
  {17,  1,   0}, // #10476
  {19,  1,   0}, // #10477
  {21,  1,   0}, // #10478
  {23,  3,   0}, // #10479
  {24,  3,   0}, // #10480
  {25,  3,   0}, // #10481
  {26,  4,   0}, // #10482
  { 2, 10,   0}, // #10483
  { 3,  2,   0}, // #10484
  { 8,  1,   0}, // #10485
  {13,  2,   0}, // #10486
  {14,  2,   0}, // #10487
  {15,  3,   0}, // #10488
  {16,  2,   0}, // #10489
  {17,  1,   0}, // #10490
  {21,  1,   0}, // #10491
  {23,  3,   0}, // #10492
  {24,  3,   0}, // #10493
  {25,  3,   0}, // #10494
  {26,  3,   0}, // #10495
  { 3,  1,   0}, // #10496
  {13,  1,   0}, // #10497
  {14,  1,   0}, // #10498
  {15,  1,   0}, // #10499
  {16,  1,   0}, // #10500
  {20,  1,   0}, // #10501
  {22,  1,   0}, // #10502
  {23,  1,   0}, // #10503
  {24,  1,   0}, // #10504
  {25,  1,   0}, // #10505
  {26,  3,   0}, // #10506
  { 2, 12,   0}, // #10507
  { 3,  1,   0}, // #10508
  {13,  1,   0}, // #10509
  {14,  1,   0}, // #10510
  {15,  1,   0}, // #10511
  {16,  1,   0}, // #10512
  {19,  1,   0}, // #10513
  {23,  1,   0}, // #10514
  {24,  1,   0}, // #10515
  {25,  1,   0}, // #10516
  {26,  2,   0}, // #10517
  { 2, 12,   0}, // #10518
  { 3,  1,   0}, // #10519
  {13,  1,   0}, // #10520
  {14,  1,   0}, // #10521
  {15,  1,   0}, // #10522
  {16,  1,   0}, // #10523
  {23,  1,   0}, // #10524
  {24,  1,   0}, // #10525
  {25,  1,   0}, // #10526
  {26,  1,   0}, // #10527
  { 2, 24,   0}, // #10528
  { 3,  2,   0}, // #10529
  { 8,  1,   0}, // #10530
  {13,  2,   0}, // #10531
  {14,  2,   0}, // #10532
  {15,  3,   0}, // #10533
  {16,  2,   0}, // #10534
  {17,  1,   0}, // #10535
  {19,  1,   0}, // #10536
  {21,  1,   0}, // #10537
  {23,  3,   0}, // #10538
  {24,  3,   0}, // #10539
  {25,  3,   0}, // #10540
  {26,  4,   0}, // #10541
  { 2, 24,   0}, // #10542
  { 3,  2,   0}, // #10543
  { 8,  1,   0}, // #10544
  {13,  2,   0}, // #10545
  {14,  2,   0}, // #10546
  {15,  3,   0}, // #10547
  {16,  2,   0}, // #10548
  {17,  1,   0}, // #10549
  {21,  1,   0}, // #10550
  {23,  3,   0}, // #10551
  {24,  3,   0}, // #10552
  {25,  3,   0}, // #10553
  {26,  3,   0}, // #10554
  { 2, 12,   0}, // #10555
  { 3,  2,   0}, // #10556
  { 8,  1,   0}, // #10557
  {13,  2,   0}, // #10558
  {14,  2,   0}, // #10559
  {15,  3,   0}, // #10560
  {16,  2,   0}, // #10561
  {17,  1,   0}, // #10562
  {19,  1,   0}, // #10563
  {21,  1,   0}, // #10564
  {23,  3,   0}, // #10565
  {24,  3,   0}, // #10566
  {25,  3,   0}, // #10567
  {26,  4,   0}, // #10568
  { 2, 12,   0}, // #10569
  { 3,  2,   0}, // #10570
  { 8,  1,   0}, // #10571
  {13,  2,   0}, // #10572
  {14,  2,   0}, // #10573
  {15,  3,   0}, // #10574
  {16,  2,   0}, // #10575
  {17,  1,   0}, // #10576
  {21,  1,   0}, // #10577
  {23,  3,   0}, // #10578
  {24,  3,   0}, // #10579
  {25,  3,   0}, // #10580
  {26,  3,   0}, // #10581
  {16,  1,   0}, // #10582
  {19,  1,   0}, // #10583
  {22,  1,   0}, // #10584
  {24,  1,   0}, // #10585
  {25,  3,   0}, // #10586
  {26,  5,   0}, // #10587
  { 4,  2,   0}, // #10588
  {13,  2,   0}, // #10589
  {16,  4,   0}, // #10590
  {17,  3,   0}, // #10591
  {18,  2,   0}, // #10592
  {19,  1,   0}, // #10593
  {22,  1,   0}, // #10594
  {23,  3,   0}, // #10595
  {24,  4,   0}, // #10596
  {25,  9,   0}, // #10597
  {26, 11,   0}, // #10598
  { 3,  2,   0}, // #10599
  { 4,  1,   0}, // #10600
  { 8,  2,   0}, // #10601
  { 9,  4,   0}, // #10602
  {13,  3,   0}, // #10603
  {14,  2,   0}, // #10604
  {15,  6,   0}, // #10605
  {16,  6,   0}, // #10606
  {17,  3,   0}, // #10607
  {18,  5,   0}, // #10608
  {21,  6,   0}, // #10609
  {23,  7,   0}, // #10610
  {24, 10,   0}, // #10611
  {25, 15,   0}, // #10612
  {26, 15,   0}, // #10613
  { 8,  2,   0}, // #10614
  {13,  1,   0}, // #10615
  {15,  2,   0}, // #10616
  {17,  2,   0}, // #10617
  {21,  2,   0}, // #10618
  {23,  3,   0}, // #10619
  {24,  2,   0}, // #10620
  {25,  3,   0}, // #10621
  {26,  3,   0}, // #10622
  { 3,  1,   0}, // #10623
  { 8,  1,   0}, // #10624
  {13,  2,   0}, // #10625
  {14,  1,   0}, // #10626
  {15,  2,   0}, // #10627
  {16,  1,   0}, // #10628
  {17,  1,   0}, // #10629
  {21,  1,   0}, // #10630
  {23,  3,   0}, // #10631
  {24,  2,   0}, // #10632
  {25,  3,   0}, // #10633
  {26,  3,   0}, // #10634
  {19,  1,   0}, // #10635
  {25,  2,   0}, // #10636
  {26,  3,   0}, // #10637
  { 9,  1,   0}, // #10638
  {16,  1,   0}, // #10639
  {18,  1,   0}, // #10640
  {21,  1,   0}, // #10641
  {24,  1,   0}, // #10642
  {25,  3,   0}, // #10643
  {26,  3,   0}, // #10644
  { 9,  1,   0}, // #10645
  {16,  2,   0}, // #10646
  {18,  1,   0}, // #10647
  {19,  1,   0}, // #10648
  {20,  1,   0}, // #10649
  {21,  1,   0}, // #10650
  {22,  1,   0}, // #10651
  {24,  2,   0}, // #10652
  {25,  5,   0}, // #10653
  {26,  8,   0}, // #10654
  {16,  1,   0}, // #10655
  {24,  1,   0}, // #10656
  {25,  2,   0}, // #10657
  {26,  2,   0}, // #10658
  { 3,  1,   0}, // #10659
  {13,  1,   0}, // #10660
  {14,  1,   0}, // #10661
  {15,  2,   0}, // #10662
  {16,  1,   0}, // #10663
  {19,  1,   0}, // #10664
  {23,  2,   0}, // #10665
  {24,  2,   0}, // #10666
  {25,  2,   0}, // #10667
  {26,  3,   0}, // #10668
  {16,  2,   0}, // #10669
  {24,  2,   0}, // #10670
  {25, 11,   0}, // #10671
  {26, 11,   0}, // #10672
  { 9,  1,   0}, // #10673
  {16,  1,   0}, // #10674
  {18,  1,   0}, // #10675
  {20,  1,   0}, // #10676
  {21,  1,   0}, // #10677
  {22,  1,   0}, // #10678
  {24,  1,   0}, // #10679
  {25,  1,   0}, // #10680
  {26,  3,   0}, // #10681
  { 9,  1,   0}, // #10682
  {16,  1,   0}, // #10683
  {18,  1,   0}, // #10684
  {21,  1,   0}, // #10685
  {24,  1,   0}, // #10686
  {25,  4,   0}, // #10687
  {26,  4,   0}, // #10688
  {16,  4,   0}, // #10689
  {17,  2,   0}, // #10690
  {19,  1,   0}, // #10691
  {20,  1,   0}, // #10692
  {22,  1,   0}, // #10693
  {23,  2,   0}, // #10694
  {24,  4,   0}, // #10695
  {25, 11,   0}, // #10696
  {26, 14,   0}, // #10697
  { 9,  1,   0}, // #10698
  {16,  4,   0}, // #10699
  {17,  1,   0}, // #10700
  {18,  1,   0}, // #10701
  {21,  1,   0}, // #10702
  {23,  1,   0}, // #10703
  {24,  4,   0}, // #10704
  {25,  7,   0}, // #10705
  {26,  7,   0}, // #10706
  { 9,  1,   0}, // #10707
  {16,  1,   0}, // #10708
  {18,  1,   0}, // #10709
  {21,  1,   0}, // #10710
  {24,  1,   0}, // #10711
  {25,  6,   0}, // #10712
  {26,  6,   0}, // #10713
  { 3,  2,   0}, // #10714
  { 8,  4,   0}, // #10715
  {13,  2,   0}, // #10716
  {14,  2,   0}, // #10717
  {15,  6,   0}, // #10718
  {16,  6,   0}, // #10719
  {17,  4,   0}, // #10720
  {19,  1,   0}, // #10721
  {20,  1,   0}, // #10722
  {21,  4,   0}, // #10723
  {22,  1,   0}, // #10724
  {23,  6,   0}, // #10725
  {24, 10,   0}, // #10726
  {25, 16,   0}, // #10727
  {26, 19,   0}, // #10728
  { 8,  2,   0}, // #10729
  {15,  2,   0}, // #10730
  {17,  2,   0}, // #10731
  {21,  2,   0}, // #10732
  {23,  2,   0}, // #10733
  {24,  2,   0}, // #10734
  {25, 22,   0}, // #10735
  {26, 22,   0}, // #10736
  { 8,  1,   0}, // #10737
  { 9,  2,   0}, // #10738
  {15,  1,   0}, // #10739
  {16,  2,   0}, // #10740
  {17,  1,   0}, // #10741
  {18,  2,   0}, // #10742
  {21,  3,   0}, // #10743
  {23,  1,   0}, // #10744
  {24,  3,   0}, // #10745
  {25, 10,   0}, // #10746
  {26, 10,   0}, // #10747
  { 8,  1,   0}, // #10748
  { 9,  1,   0}, // #10749
  {15,  1,   0}, // #10750
  {16,  2,   0}, // #10751
  {17,  1,   0}, // #10752
  {18,  1,   0}, // #10753
  {19,  1,   0}, // #10754
  {20,  1,   0}, // #10755
  {21,  2,   0}, // #10756
  {22,  1,   0}, // #10757
  {23,  1,   0}, // #10758
  {24,  3,   0}, // #10759
  {25,  5,   0}, // #10760
  {26,  8,   0}, // #10761
  { 8,  6,   0}, // #10762
  {15,  9,   0}, // #10763
  {17,  6,   0}, // #10764
  {21,  6,   0}, // #10765
  {23,  9,   0}, // #10766
  {24,  9,   0}, // #10767
  {25, 15,   0}, // #10768
  {26, 15,   0}, // #10769
  { 8,  1,   0}, // #10770
  { 9,  5,   0}, // #10771
  {15,  1,   0}, // #10772
  {16,  9,   0}, // #10773
  {17,  1,   0}, // #10774
  {18,  5,   0}, // #10775
  {19,  2,   0}, // #10776
  {21,  6,   0}, // #10777
  {22,  1,   0}, // #10778
  {23,  1,   0}, // #10779
  {24, 10,   0}, // #10780
  {25, 20,   0}, // #10781
  {26, 23,   0}, // #10782
  { 8,  1,   0}, // #10783
  { 9,  5,   0}, // #10784
  {15,  1,   0}, // #10785
  {16,  9,   0}, // #10786
  {17,  1,   0}, // #10787
  {18,  5,   0}, // #10788
  {19,  3,   0}, // #10789
  {21,  6,   0}, // #10790
  {23,  1,   0}, // #10791
  {24, 10,   0}, // #10792
  {25, 20,   0}, // #10793
  {26, 23,   0}, // #10794
  { 8,  1,   0}, // #10795
  { 9,  1,   0}, // #10796
  {15,  1,   0}, // #10797
  {16,  2,   0}, // #10798
  {17,  1,   0}, // #10799
  {18,  1,   0}, // #10800
  {21,  2,   0}, // #10801
  {23,  1,   0}, // #10802
  {24,  3,   0}, // #10803
  {25,  8,   0}, // #10804
  {26,  8,   0}, // #10805
  { 3,  4,   0}, // #10806
  { 9,  2,   0}, // #10807
  {13,  4,   0}, // #10808
  {14,  4,   0}, // #10809
  {15,  5,   0}, // #10810
  {16,  8,   0}, // #10811
  {17,  1,   0}, // #10812
  {18,  2,   0}, // #10813
  {19, 33,   0}, // #10814
  {21,  2,   0}, // #10815
  {23,  6,   0}, // #10816
  {24,  9,   0}, // #10817
  {25, 57,   0}, // #10818
  {26, 90,   0}, // #10819
  { 9,  1,   0}, // #10820
  {16,  1,   0}, // #10821
  {18,  1,   0}, // #10822
  {19,  1,   0}, // #10823
  {21,  1,   0}, // #10824
  {24,  1,   0}, // #10825
  {25,  2,   0}, // #10826
  {26,  3,   0}, // #10827
  { 3,  1,   0}, // #10828
  {13,  1,   0}, // #10829
  {14,  1,   0}, // #10830
  {15,  1,   0}, // #10831
  {16,  1,   0}, // #10832
  {23,  1,   0}, // #10833
  {24,  1,   0}, // #10834
  {25,  2,   0}, // #10835
  {26,  2,   0}, // #10836
  {16,  1,   0}, // #10837
  {24,  1,   0}, // #10838
  {25,  3,   0}, // #10839
  {26,  3,   0}, // #10840
  { 4,  2,   0}, // #10841
  {13,  2,   0}, // #10842
  {16,  3,   0}, // #10843
  {17,  2,   0}, // #10844
  {18,  2,   0}, // #10845
  {23,  2,   0}, // #10846
  {24,  3,   0}, // #10847
  {25,  7,   0}, // #10848
  {26,  7,   0}, // #10849
  { 4,  2,   0}, // #10850
  {13,  2,   0}, // #10851
  {16,  4,   0}, // #10852
  {17,  3,   0}, // #10853
  {18,  2,   0}, // #10854
  {23,  3,   0}, // #10855
  {24,  4,   0}, // #10856
  {25, 10,   0}, // #10857
  {26, 10,   0}, // #10858
  {20,  1,   0}, // #10859
  {22,  1,   0}, // #10860
  {25,  1,   0}, // #10861
  {26,  3,   0}, // #10862
  {16,  1,   0}, // #10863
  {20,  1,   0}, // #10864
  {22,  1,   0}, // #10865
  {24,  1,   0}, // #10866
  {25,  2,   0}, // #10867
  {26,  4,   0}, // #10868
  { 9,  1,   0}, // #10869
  {16,  1,   0}, // #10870
  {18,  1,   0}, // #10871
  {20,  1,   0}, // #10872
  {21,  1,   0}, // #10873
  {22,  1,   0}, // #10874
  {24,  1,   0}, // #10875
  {25,  2,   0}, // #10876
  {26,  4,   0}, // #10877
  {20,  1,   0}, // #10878
  {22,  1,   0}, // #10879
  {25,  4,   0}, // #10880
  {26,  6,   0}, // #10881
  { 9,  1,   0}, // #10882
  {16,  1,   0}, // #10883
  {18,  1,   0}, // #10884
  {21,  1,   0}, // #10885
  {24,  1,   0}, // #10886
  {25,  2,   0}, // #10887
  {26,  2,   0}, // #10888
  { 9,  1,   0}, // #10889
  {16,  1,   0}, // #10890
  {18,  1,   0}, // #10891
  {19,  1,   0}, // #10892
  {21,  1,   0}, // #10893
  {24,  1,   0}, // #10894
  {25,  1,   0}, // #10895
  {26,  2,   0}, // #10896
  { 4,  1,   0}, // #10897
  { 9,  1,   0}, // #10898
  {13,  1,   0}, // #10899
  {16,  2,   0}, // #10900
  {17,  1,   0}, // #10901
  {18,  2,   0}, // #10902
  {21,  1,   0}, // #10903
  {23,  1,   0}, // #10904
  {24,  2,   0}, // #10905
  {25,  4,   0}, // #10906
  {26,  4,   0}, // #10907
  { 9,  1,   0}, // #10908
  {16,  1,   0}, // #10909
  {18,  1,   0}, // #10910
  {19,  1,   0}, // #10911
  {20,  1,   0}, // #10912
  {21,  1,   0}, // #10913
  {22,  1,   0}, // #10914
  {24,  1,   0}, // #10915
  {25,  2,   0}, // #10916
  {26,  5,   0}, // #10917
  {16,  2,   0}, // #10918
  {19,  1,   0}, // #10919
  {20,  1,   0}, // #10920
  {22,  1,   0}, // #10921
  {24,  2,   0}, // #10922
  {25,  2,   0}, // #10923
  {26,  5,   0}, // #10924
  {19,  1,   0}, // #10925
  {20,  1,   0}, // #10926
  {22,  1,   0}, // #10927
  {25,  2,   0}, // #10928
  {26,  5,   0}, // #10929
  { 4,  1,   0}, // #10930
  { 9,  5,   0}, // #10931
  {13,  1,   0}, // #10932
  {15,  4,   0}, // #10933
  {16,  5,   0}, // #10934
  {17,  1,   0}, // #10935
  {18,  6,   0}, // #10936
  {21,  5,   0}, // #10937
  {23,  5,   0}, // #10938
  {24,  9,   0}, // #10939
  {25, 10,   0}, // #10940
  {26, 10,   0}, // #10941
  { 9,  1,   0}, // #10942
  {16,  1,   0}, // #10943
  {18,  1,   0}, // #10944
  {21,  1,   0}, // #10945
  {24,  1,   0}, // #10946
  {25,  1,   0}, // #10947
  {26,  1,   0}, // #10948
  {17,  1,   0}, // #10949
  {20,  1,   0}, // #10950
  {22,  1,   0}, // #10951
  {23,  1,   0}, // #10952
  {25,  1,   0}, // #10953
  {26,  3,   0}, // #10954
  {20,  1,   0}, // #10955
  {22,  2,   0}, // #10956
  {26,  3,   0}, // #10957
  {16,  2,   0}, // #10958
  {24,  2,   0}, // #10959
  {25,  2,   0}, // #10960
  {26,  2,   0}, // #10961
  { 8,  2,   0}, // #10962
  {15,  2,   0}, // #10963
  {17,  2,   0}, // #10964
  {21,  2,   0}, // #10965
  {23,  2,   0}, // #10966
  {24,  2,   0}, // #10967
  {25,  3,   0}, // #10968
  {26,  3,   0}, // #10969
  { 4,  1,   0}, // #10970
  { 9,  1,   0}, // #10971
  {13,  1,   0}, // #10972
  {16,  1,   0}, // #10973
  {17,  1,   0}, // #10974
  {18,  2,   0}, // #10975
  {21,  1,   0}, // #10976
  {23,  1,   0}, // #10977
  {24,  1,   0}, // #10978
  {25,  4,   0}, // #10979
  {26,  4,   0}, // #10980
  { 4,  1,   0}, // #10981
  { 9,  2,   0}, // #10982
  {13,  1,   0}, // #10983
  {16,  2,   0}, // #10984
  {17,  1,   0}, // #10985
  {18,  3,   0}, // #10986
  {19,  1,   0}, // #10987
  {21,  2,   0}, // #10988
  {23,  1,   0}, // #10989
  {24,  2,   0}, // #10990
  {25,  4,   0}, // #10991
  {26,  5,   0}, // #10992
  { 4,  1,   0}, // #10993
  { 9,  1,   0}, // #10994
  {13,  1,   0}, // #10995
  {16,  2,   0}, // #10996
  {17,  1,   0}, // #10997
  {18,  2,   0}, // #10998
  {21,  1,   0}, // #10999
  {23,  1,   0}, // #11000
  {24,  2,   0}, // #11001
  {25,  3,   0}, // #11002
  {26,  3,   0}, // #11003
  {16,  1,   0}, // #11004
  {24,  1,   0}, // #11005
  {25,  5,   0}, // #11006
  {26,  5,   0}, // #11007
  { 4,  1,   0}, // #11008
  {13,  1,   0}, // #11009
  {16,  5,   0}, // #11010
  {17,  2,   0}, // #11011
  {18,  1,   0}, // #11012
  {19,  1,   0}, // #11013
  {22,  1,   0}, // #11014
  {23,  2,   0}, // #11015
  {24,  5,   0}, // #11016
  {25,  8,   0}, // #11017
  {26, 10,   0}, // #11018
  { 4,  1,   0}, // #11019
  {13,  1,   0}, // #11020
  {16,  5,   0}, // #11021
  {17,  2,   0}, // #11022
  {18,  1,   0}, // #11023
  {23,  2,   0}, // #11024
  {24,  5,   0}, // #11025
  {25,  9,   0}, // #11026
  {26,  9,   0}, // #11027
  { 4,  1,   0}, // #11028
  { 9,  8,   0}, // #11029
  {13,  1,   0}, // #11030
  {16,  8,   0}, // #11031
  {17,  1,   0}, // #11032
  {18,  9,   0}, // #11033
  {19,  1,   0}, // #11034
  {21,  8,   0}, // #11035
  {23,  1,   0}, // #11036
  {24,  8,   0}, // #11037
  {25, 30,   0}, // #11038
  {26, 31,   0}, // #11039
  { 9, 10,   0}, // #11040
  {16, 10,   0}, // #11041
  {18, 10,   0}, // #11042
  {19,  1,   0}, // #11043
  {20,  1,   0}, // #11044
  {21, 10,   0}, // #11045
  {22,  1,   0}, // #11046
  {24, 10,   0}, // #11047
  {25, 36,   0}, // #11048
  {26, 39,   0}, // #11049
  { 9, 11,   0}, // #11050
  {16, 11,   0}, // #11051
  {18, 11,   0}, // #11052
  {19,  1,   0}, // #11053
  {20,  1,   0}, // #11054
  {21, 11,   0}, // #11055
  {22,  1,   0}, // #11056
  {24, 11,   0}, // #11057
  {25, 37,   0}, // #11058
  {26, 40,   0}, // #11059
  { 4,  1,   0}, // #11060
  { 8,  2,   0}, // #11061
  { 9,  3,   0}, // #11062
  {13,  1,   0}, // #11063
  {15,  2,   0}, // #11064
  {16,  3,   0}, // #11065
  {17,  4,   0}, // #11066
  {18,  4,   0}, // #11067
  {19,  1,   0}, // #11068
  {20,  1,   0}, // #11069
  {21,  5,   0}, // #11070
  {22,  1,   0}, // #11071
  {23,  4,   0}, // #11072
  {24,  5,   0}, // #11073
  {25, 15,   0}, // #11074
  {26, 18,   0}, // #11075
  { 3,  2,   0}, // #11076
  {13,  2,   0}, // #11077
  {14,  2,   0}, // #11078
  {15,  7,   0}, // #11079
  {16, 12,   0}, // #11080
  {19,  8,   0}, // #11081
  {23,  7,   0}, // #11082
  {24, 17,   0}, // #11083
  {25, 56,   0}, // #11084
  {26, 64,   0}, // #11085
  { 3,  4,   0}, // #11086
  { 9,  4,   0}, // #11087
  {13,  4,   0}, // #11088
  {14,  4,   0}, // #11089
  {15,  5,   0}, // #11090
  {16, 10,   0}, // #11091
  {17,  1,   0}, // #11092
  {18,  4,   0}, // #11093
  {19, 31,   0}, // #11094
  {21,  4,   0}, // #11095
  {23,  6,   0}, // #11096
  {24, 11,   0}, // #11097
  {25, 57,   0}, // #11098
  {26, 88,   0}, // #11099
  { 3,  9,   0}, // #11100
  { 4,  1,   0}, // #11101
  { 8, 16,   0}, // #11102
  { 9,  1,   0}, // #11103
  {13, 10,   0}, // #11104
  {14,  9,   0}, // #11105
  {15, 25,   0}, // #11106
  {16, 31,   0}, // #11107
  {17, 17,   0}, // #11108
  {18,  2,   0}, // #11109
  {20, 11,   0}, // #11110
  {21, 17,   0}, // #11111
  {22, 11,   0}, // #11112
  {23, 26,   0}, // #11113
  {24, 47,   0}, // #11114
  {25, 78,   0}, // #11115
  {26, 100,   0}, // #11116
  { 3,  1,   0}, // #11117
  { 8,  1,   0}, // #11118
  {13,  1,   0}, // #11119
  {14,  1,   0}, // #11120
  {15,  2,   0}, // #11121
  {16,  1,   0}, // #11122
  {17,  1,   0}, // #11123
  {19,  2,   0}, // #11124
  {21,  1,   0}, // #11125
  {23,  3,   0}, // #11126
  {24,  2,   0}, // #11127
  {25,  3,   0}, // #11128
  {26,  5,   0}, // #11129
  { 3,  1,   0}, // #11130
  { 8,  1,   0}, // #11131
  {13,  1,   0}, // #11132
  {14,  1,   0}, // #11133
  {15,  2,   0}, // #11134
  {16,  1,   0}, // #11135
  {17,  1,   0}, // #11136
  {19,  4,   0}, // #11137
  {21,  1,   0}, // #11138
  {23,  3,   0}, // #11139
  {24,  2,   0}, // #11140
  {25,  3,   0}, // #11141
  {26,  7,   0}, // #11142
  { 3,  1,   0}, // #11143
  { 8,  1,   0}, // #11144
  {13,  1,   0}, // #11145
  {14,  1,   0}, // #11146
  {15,  2,   0}, // #11147
  {16,  1,   0}, // #11148
  {17,  1,   0}, // #11149
  {19,  8,   0}, // #11150
  {21,  1,   0}, // #11151
  {23,  3,   0}, // #11152
  {24,  2,   0}, // #11153
  {25,  3,   0}, // #11154
  {26, 11,   0}, // #11155
  { 8,  5,   0}, // #11156
  {13,  5,   0}, // #11157
  {15,  5,   0}, // #11158
  {17,  5,   0}, // #11159
  {21,  5,   0}, // #11160
  {23, 14,   0}, // #11161
  {24,  5,   0}, // #11162
  {25, 14,   0}, // #11163
  {26, 14,   0}, // #11164
  { 8,  9,   0}, // #11165
  {13,  7,   0}, // #11166
  {15,  9,   0}, // #11167
  {17,  9,   0}, // #11168
  {21,  9,   0}, // #11169
  {23, 21,   0}, // #11170
  {24,  9,   0}, // #11171
  {25, 21,   0}, // #11172
  {26, 21,   0}, // #11173
  { 8, 17,   0}, // #11174
  {13, 11,   0}, // #11175
  {15, 17,   0}, // #11176
  {17, 17,   0}, // #11177
  {21, 17,   0}, // #11178
  {23, 35,   0}, // #11179
  {24, 17,   0}, // #11180
  {25, 35,   0}, // #11181
  {26, 35,   0}, // #11182
  { 3,  1,   0}, // #11183
  { 8,  2,   0}, // #11184
  {13,  1,   0}, // #11185
  {14,  1,   0}, // #11186
  {15,  3,   0}, // #11187
  {16,  1,   0}, // #11188
  {17,  2,   0}, // #11189
  {21,  2,   0}, // #11190
  {23,  3,   0}, // #11191
  {24,  3,   0}, // #11192
  {25,  3,   0}, // #11193
  {26,  3,   0}, // #11194
  { 3,  1,   0}, // #11195
  { 8,  2,   0}, // #11196
  {13,  1,   0}, // #11197
  {14,  1,   0}, // #11198
  {15,  3,   0}, // #11199
  {16,  1,   0}, // #11200
  {17,  2,   0}, // #11201
  {19,  1,   0}, // #11202
  {21,  2,   0}, // #11203
  {23,  3,   0}, // #11204
  {24,  3,   0}, // #11205
  {25,  3,   0}, // #11206
  {26,  4,   0}, // #11207
  { 8,  2,   0}, // #11208
  {13,  1,   0}, // #11209
  {15,  2,   0}, // #11210
  {17,  2,   0}, // #11211
  {19,  1,   0}, // #11212
  {21,  2,   0}, // #11213
  {23,  3,   0}, // #11214
  {24,  2,   0}, // #11215
  {25,  3,   0}, // #11216
  {26,  4,   0}, // #11217
  {17,  1,   0}, // #11218
  {20,  2,   0}, // #11219
  {22,  2,   0}, // #11220
  {23,  1,   0}, // #11221
  {25,  1,   0}, // #11222
  {26,  5,   0}, // #11223
  {13,  1,   0}, // #11224
  {20,  1,   0}, // #11225
  {22,  1,   0}, // #11226
  {23,  1,   0}, // #11227
  {25,  1,   0}, // #11228
  {26,  3,   0}, // #11229
  { 8,  2,   0}, // #11230
  {15,  2,   0}, // #11231
  {17,  2,   0}, // #11232
  {20,  1,   0}, // #11233
  {21,  2,   0}, // #11234
  {22,  1,   0}, // #11235
  {23,  2,   0}, // #11236
  {24,  2,   0}, // #11237
  {25,  2,   0}, // #11238
  {26,  4,   0}, // #11239
  { 8,  1,   0}, // #11240
  {15,  1,   0}, // #11241
  {17,  1,   0}, // #11242
  {19,  1,   0}, // #11243
  {21,  1,   0}, // #11244
  {23,  1,   0}, // #11245
  {24,  1,   0}, // #11246
  {25,  2,   0}, // #11247
  {26,  3,   0}, // #11248
  { 3,  1,   0}, // #11249
  {13,  1,   0}, // #11250
  {14,  1,   0}, // #11251
  {15,  1,   0}, // #11252
  {16,  1,   0}, // #11253
  {20,  2,   0}, // #11254
  {22,  2,   0}, // #11255
  {23,  1,   0}, // #11256
  {24,  1,   0}, // #11257
  {25,  3,   0}, // #11258
  {26,  7,   0}, // #11259
  { 3,  1,   0}, // #11260
  {13,  1,   0}, // #11261
  {14,  1,   0}, // #11262
  {15,  1,   0}, // #11263
  {16,  1,   0}, // #11264
  {20,  4,   0}, // #11265
  {22,  4,   0}, // #11266
  {23,  1,   0}, // #11267
  {24,  1,   0}, // #11268
  {25,  3,   0}, // #11269
  {26, 11,   0}, // #11270
  { 3,  1,   0}, // #11271
  {13,  1,   0}, // #11272
  {14,  1,   0}, // #11273
  {15,  1,   0}, // #11274
  {16,  1,   0}, // #11275
  {20,  8,   0}, // #11276
  {22,  8,   0}, // #11277
  {23,  1,   0}, // #11278
  {24,  1,   0}, // #11279
  {25,  3,   0}, // #11280
  {26, 19,   0}, // #11281
  { 3,  1,   0}, // #11282
  { 8,  1,   0}, // #11283
  {13,  1,   0}, // #11284
  {14,  1,   0}, // #11285
  {15,  2,   0}, // #11286
  {16,  1,   0}, // #11287
  {17,  1,   0}, // #11288
  {20, 16,   0}, // #11289
  {21,  1,   0}, // #11290
  {22, 16,   0}, // #11291
  {23,  2,   0}, // #11292
  {24,  2,   0}, // #11293
  {25,  4,   0}, // #11294
  {26, 36,   0}, // #11295
  { 3,  1,   0}, // #11296
  { 8,  1,   0}, // #11297
  {13,  1,   0}, // #11298
  {14,  1,   0}, // #11299
  {15,  2,   0}, // #11300
  {16,  1,   0}, // #11301
  {17,  1,   0}, // #11302
  {20,  2,   0}, // #11303
  {21,  1,   0}, // #11304
  {22,  2,   0}, // #11305
  {23,  2,   0}, // #11306
  {24,  2,   0}, // #11307
  {25,  4,   0}, // #11308
  {26,  8,   0}, // #11309
  { 3,  1,   0}, // #11310
  { 8,  1,   0}, // #11311
  {13,  1,   0}, // #11312
  {14,  1,   0}, // #11313
  {15,  2,   0}, // #11314
  {16,  1,   0}, // #11315
  {17,  1,   0}, // #11316
  {20,  4,   0}, // #11317
  {21,  1,   0}, // #11318
  {22,  4,   0}, // #11319
  {23,  2,   0}, // #11320
  {24,  2,   0}, // #11321
  {25,  4,   0}, // #11322
  {26, 12,   0}, // #11323
  { 3,  1,   0}, // #11324
  { 8,  1,   0}, // #11325
  {13,  1,   0}, // #11326
  {14,  1,   0}, // #11327
  {15,  2,   0}, // #11328
  {16,  1,   0}, // #11329
  {17,  1,   0}, // #11330
  {20,  8,   0}, // #11331
  {21,  1,   0}, // #11332
  {22,  8,   0}, // #11333
  {23,  2,   0}, // #11334
  {24,  2,   0}, // #11335
  {25,  4,   0}, // #11336
  {26, 20,   0}, // #11337
  {13,  3,   0}, // #11338
  {23,  3,   0}, // #11339
  {25,  3,   0}, // #11340
  {26,  3,   0}, // #11341
  { 3,  1,   0}, // #11342
  {13,  2,   0}, // #11343
  {14,  1,   0}, // #11344
  {15,  1,   0}, // #11345
  {16,  1,   0}, // #11346
  {19,  1,   0}, // #11347
  {23,  2,   0}, // #11348
  {24,  1,   0}, // #11349
  {25,  2,   0}, // #11350
  {26,  3,   0}, // #11351
  { 4,  1,   0}, // #11352
  { 8,  2,   0}, // #11353
  {13,  3,   0}, // #11354
  {15,  2,   0}, // #11355
  {17,  3,   0}, // #11356
  {18,  1,   0}, // #11357
  {19,  1,   0}, // #11358
  {21,  2,   0}, // #11359
  {23,  7,   0}, // #11360
  {24,  2,   0}, // #11361
  {25,  7,   0}, // #11362
  {26,  8,   0}, // #11363
  {13,  3,   0}, // #11364
  {19,  1,   0}, // #11365
  {23,  3,   0}, // #11366
  {25,  3,   0}, // #11367
  {26,  4,   0}, // #11368
  { 3,  1,   0}, // #11369
  {13,  1,   0}, // #11370
  {14,  1,   0}, // #11371
  {15,  1,   0}, // #11372
  {16,  1,   0}, // #11373
  {19,  2,   0}, // #11374
  {23,  2,   0}, // #11375
  {24,  1,   0}, // #11376
  {25,  3,   0}, // #11377
  {26,  5,   0}, // #11378
  { 3,  1,   0}, // #11379
  {13,  1,   0}, // #11380
  {14,  1,   0}, // #11381
  {15,  1,   0}, // #11382
  {16,  1,   0}, // #11383
  {19,  4,   0}, // #11384
  {23,  2,   0}, // #11385
  {24,  1,   0}, // #11386
  {25,  3,   0}, // #11387
  {26,  7,   0}, // #11388
  { 3,  1,   0}, // #11389
  {13,  1,   0}, // #11390
  {14,  1,   0}, // #11391
  {15,  1,   0}, // #11392
  {16,  1,   0}, // #11393
  {19,  8,   0}, // #11394
  {23,  2,   0}, // #11395
  {24,  1,   0}, // #11396
  {25,  3,   0}, // #11397
  {26, 11,   0}, // #11398
  { 3,  1,   0}, // #11399
  {13,  1,   0}, // #11400
  {14,  1,   0}, // #11401
  {15,  1,   0}, // #11402
  {16,  1,   0}, // #11403
  {19, 16,   0}, // #11404
  {23,  2,   0}, // #11405
  {24,  1,   0}, // #11406
  {25,  3,   0}, // #11407
  {26, 19,   0}, // #11408
  { 8,  5,   0}, // #11409
  {13,  5,   0}, // #11410
  {15,  5,   0}, // #11411
  {17,  5,   0}, // #11412
  {19,  1,   0}, // #11413
  {21,  5,   0}, // #11414
  {23, 14,   0}, // #11415
  {24,  5,   0}, // #11416
  {25, 14,   0}, // #11417
  {26, 15,   0}, // #11418
  { 8,  9,   0}, // #11419
  {13,  7,   0}, // #11420
  {15,  9,   0}, // #11421
  {17,  9,   0}, // #11422
  {19,  1,   0}, // #11423
  {21,  9,   0}, // #11424
  {23, 21,   0}, // #11425
  {24,  9,   0}, // #11426
  {25, 21,   0}, // #11427
  {26, 22,   0}, // #11428
  { 8, 17,   0}, // #11429
  {13, 11,   0}, // #11430
  {15, 17,   0}, // #11431
  {17, 17,   0}, // #11432
  {19,  1,   0}, // #11433
  {21, 17,   0}, // #11434
  {23, 35,   0}, // #11435
  {24, 17,   0}, // #11436
  {25, 35,   0}, // #11437
  {26, 36,   0}, // #11438
  {16,  2,   0}, // #11439
  {19,  1,   0}, // #11440
  {24,  2,   0}, // #11441
  {25,  2,   0}, // #11442
  {26,  3,   0}, // #11443
  {16,  2,   0}, // #11444
  {20,  1,   0}, // #11445
  {22,  1,   0}, // #11446
  {24,  2,   0}, // #11447
  {25,  2,   0}, // #11448
  {26,  4,   0}, // #11449
  { 3,  1,   0}, // #11450
  {11,  2,   0}, // #11451
  {12,  1,   0}, // #11452
  {13,  1,   0}, // #11453
  {14,  1,   0}, // #11454
  {19,  2,   0}, // #11455
  {20,  1,   0}, // #11456
  {22,  2,   0}, // #11457
  {23,  2,   0}, // #11458
  { 8,  1,   0}, // #11459
  {11,  2,   0}, // #11460
  {13,  1,   0}, // #11461
  {15,  1,   0}, // #11462
  {17,  1,   0}, // #11463
  {18,  1,   0}, // #11464
  {19,  3,   0}, // #11465
  {20,  1,   0}, // #11466
  {21,  1,   0}, // #11467
  {22,  3,   0}, // #11468
  {23,  4,   0}, // #11469
  { 8,  1,   0}, // #11470
  {11,  2,   0}, // #11471
  {13,  1,   0}, // #11472
  {15,  1,   0}, // #11473
  {18,  1,   0}, // #11474
  {19,  3,   0}, // #11475
  {20,  1,   0}, // #11476
  {22,  3,   0}, // #11477
  {23,  3,   0}, // #11478
  { 8,  1,   0}, // #11479
  {11,  3,   0}, // #11480
  {13,  1,   0}, // #11481
  {15,  1,   0}, // #11482
  {17,  1,   0}, // #11483
  {18,  1,   0}, // #11484
  {19,  4,   0}, // #11485
  {20,  1,   0}, // #11486
  {21,  1,   0}, // #11487
  {22,  4,   0}, // #11488
  {23,  5,   0}, // #11489
  { 8,  1,   0}, // #11490
  {11,  3,   0}, // #11491
  {13,  1,   0}, // #11492
  {15,  1,   0}, // #11493
  {18,  1,   0}, // #11494
  {19,  4,   0}, // #11495
  {20,  1,   0}, // #11496
  {22,  4,   0}, // #11497
  {23,  4,   0}, // #11498
  {22, 16,   0}, // #11499
  {23, 16,   0}, // #11500
  { 7,  1,   0}, // #11501
  { 9, 11,   0}, // #11502
  {12,  1,   0}, // #11503
  {14, 11,   0}, // #11504
  {16, 11,   0}, // #11505
  {17,  1,   0}, // #11506
  {18, 11,   0}, // #11507
  {20, 11,   0}, // #11508
  {21,  2,   0}, // #11509
  {22, 41,   0}, // #11510
  {23, 44,   0}, // #11511
  {11,  1,   0}, // #11512
  {22,  1,   0}, // #11513
  { 1,  1,   0}, // #11514
  { 4,  1,   0}, // #11515
  { 1,  2,   0}, // #11516
  { 4,  1,   0}, // #11517
  {11,  1,   0}, // #11518
  {15,  1,   0}, // #11519
  {18,  1,   0}, // #11520
  {20,  1,   0}, // #11521
  {21,  1,   0}, // #11522
  {22,  1,   0}, // #11523
  { 1,  1,   0}, // #11524
  {11,  1,   0}, // #11525
  {21,  1,   0}, // #11526
  { 1,  1,   0}, // #11527
  {11,  1,   0}, // #11528
  {16,  1,   0}, // #11529
  {22,  1,   0}, // #11530
  { 1,  1,   0}, // #11531
  { 4,  2,   0}, // #11532
  { 1,  1,   0}, // #11533
  { 4, 12,   0}, // #11534
  { 1,  1,   0}, // #11535
  { 4, 16,   0}, // #11536
  { 1,  1,   0}, // #11537
  {11,  2,   0}, // #11538
  {14,  1,   0}, // #11539
  {16,  1,   0}, // #11540
  {17,  1,   0}, // #11541
  {19,  1,   0}, // #11542
  {21,  1,   0}, // #11543
  {22,  1,   0}, // #11544
  { 1,  1,   0}, // #11545
  {11,  1,   0}, // #11546
  {12,  1,   0}, // #11547
  {16,  1,   0}, // #11548
  {17,  1,   0}, // #11549
  {18,  1,   0}, // #11550
  {22,  1,   0}, // #11551
  { 1,  1,   0}, // #11552
  {11,  1,   0}, // #11553
  {15,  1,   0}, // #11554
  {18,  1,   0}, // #11555
  {20,  1,   0}, // #11556
  {21,  1,   0}, // #11557
  {22,  1,   0}, // #11558
  { 1,  1,   0}, // #11559
  {11,  2,   0}, // #11560
  {15,  2,   0}, // #11561
  {18,  2,   0}, // #11562
  {20,  2,   0}, // #11563
  {21,  2,   0}, // #11564
  {22,  2,   0}, // #11565
  { 1,  1,   0}, // #11566
  { 4,  1,   0}, // #11567
  { 7,  1,   0}, // #11568
  {10, 17,   0}, // #11569
  { 1,  1,   0}, // #11570
  { 4,  1,   0}, // #11571
  { 7,  1,   0}, // #11572
  {10, 25,   0}, // #11573
  { 1,  1,   0}, // #11574
  { 4,  1,   0}, // #11575
  { 7,  1,   0}, // #11576
  {10, 41,   0}, // #11577
  { 1,  1,   0}, // #11578
  { 4,  1,   0}, // #11579
  { 7,  1,   0}, // #11580
  {10, 15,   0}, // #11581
  { 1,  1,   0}, // #11582
  {11,  5,   0}, // #11583
  {15,  5,   0}, // #11584
  {18,  5,   0}, // #11585
  {20,  5,   0}, // #11586
  {21,  5,   0}, // #11587
  {22,  5,   0}, // #11588
  { 1,  1,   0}, // #11589
  {11,  3,   0}, // #11590
  {15,  3,   0}, // #11591
  {18,  3,   0}, // #11592
  {20,  3,   0}, // #11593
  {21,  3,   0}, // #11594
  {22,  3,   0}, // #11595
  { 1,  1,   0}, // #11596
  {11,  5,   0}, // #11597
  {14,  3,   0}, // #11598
  {17,  3,   0}, // #11599
  {19,  5,   0}, // #11600
  {21,  3,   0}, // #11601
  {11,  3,   0}, // #11602
  {14,  2,   0}, // #11603
  {17,  2,   0}, // #11604
  {19,  3,   0}, // #11605
  {21,  2,   0}, // #11606
  { 1,  1,   0}, // #11607
  {11,  1,   0}, // #11608
  {22,  1,   0}, // #11609
  { 1,  1,   0}, // #11610
  { 4,  1,   0}, // #11611
  { 6,  1,   0}, // #11612
  {23,  1,   0}, // #11613
  { 1,  1,   0}, // #11614
  {11,  1,   0}, // #11615
  {19,  1,   0}, // #11616
  { 1,  1,   0}, // #11617
  {11,  1,   0}, // #11618
  {20,  1,   0}, // #11619
  {22,  1,   0}, // #11620
  {11,  1,   0}, // #11621
  {14,  1,   0}, // #11622
  {17,  1,   0}, // #11623
  {19,  1,   0}, // #11624
  {21,  1,   0}, // #11625
  { 1,  1,   0}, // #11626
  {11,  1,   0}, // #11627
  {14,  1,   0}, // #11628
  {17,  1,   0}, // #11629
  {19,  1,   0}, // #11630
  {21,  1,   0}, // #11631
  { 1,  1,   0}, // #11632
  { 4,  1,   0}, // #11633
  { 6,  1,   0}, // #11634
  {23,  2,   0}, // #11635
  { 1,  1,   0}, // #11636
  {11,  2,   0}, // #11637
  {12,  2,   0}, // #11638
  {16,  2,   0}, // #11639
  {17,  2,   0}, // #11640
  {18,  2,   0}, // #11641
  {22,  2,   0}, // #11642
  { 1,  1,   0}, // #11643
  {11,  2,   0}, // #11644
  {19,  2,   0}, // #11645
  { 1,  1,   0}, // #11646
  {11,  8,   0}, // #11647
  {15,  8,   0}, // #11648
  {18,  8,   0}, // #11649
  {20,  8,   0}, // #11650
  {21,  8,   0}, // #11651
  {22,  8,   0}, // #11652
  {11, 20,   0}, // #11653
  {15, 20,   0}, // #11654
  {18, 20,   0}, // #11655
  {20, 20,   0}, // #11656
  {21, 20,   0}, // #11657
  {22, 20,   0}, // #11658
  { 1,  1,   0}, // #11659
  {11,  2,   0}, // #11660
  {21,  2,   0}, // #11661
  { 1,  1,   0}, // #11662
  {11,  2,   0}, // #11663
  {16,  2,   0}, // #11664
  {22,  2,   0}, // #11665
  { 1,  1,   0}, // #11666
  {11,  9,   0}, // #11667
  {15,  9,   0}, // #11668
  {18,  9,   0}, // #11669
  {20,  9,   0}, // #11670
  {21,  9,   0}, // #11671
  {22,  9,   0}, // #11672
  { 1,  1,   0}, // #11673
  {11,  6,   0}, // #11674
  {15,  6,   0}, // #11675
  {18,  6,   0}, // #11676
  {20,  6,   0}, // #11677
  {21,  6,   0}, // #11678
  {22,  6,   0}, // #11679
  { 1,  1,   0}, // #11680
  {11,  2,   0}, // #11681
  {22,  2,   0}, // #11682
  { 1,  1,   0}, // #11683
  {11,  3,   0}, // #11684
  {16,  3,   0}, // #11685
  {22,  3,   0}, // #11686
  { 1,  1,   0}, // #11687
  {11,  4,   0}, // #11688
  {19,  4,   0}, // #11689
  {11,  2,   0}, // #11690
  {14,  2,   0}, // #11691
  {17,  2,   0}, // #11692
  {19,  2,   0}, // #11693
  {21,  2,   0}, // #11694
  { 1,  1,   0}, // #11695
  {11,  4,   0}, // #11696
  {12,  4,   0}, // #11697
  {16,  4,   0}, // #11698
  {17,  4,   0}, // #11699
  {18,  4,   0}, // #11700
  {22,  4,   0}, // #11701
  { 1,  1,   0}, // #11702
  {11,  2,   0}, // #11703
  {14,  2,   0}, // #11704
  {17,  2,   0}, // #11705
  {19,  2,   0}, // #11706
  {21,  2,   0}, // #11707
  { 1,  1,   0}, // #11708
  {11,  2,   0}, // #11709
  {13,  2,   0}, // #11710
  {16,  2,   0}, // #11711
  {19,  2,   0}, // #11712
  {20,  2,   0}, // #11713
  {22,  2,   0}, // #11714
  { 1,  1,   0}, // #11715
  {11,  4,   0}, // #11716
  {13,  4,   0}, // #11717
  {16,  4,   0}, // #11718
  {19,  4,   0}, // #11719
  {20,  4,   0}, // #11720
  {22,  4,   0}, // #11721
  { 1,  1,   0}, // #11722
  {11, 16,   0}, // #11723
  {15, 16,   0}, // #11724
  {18, 16,   0}, // #11725
  {20, 16,   0}, // #11726
  {21, 16,   0}, // #11727
  {22, 16,   0}, // #11728
  { 1,  1,   0}, // #11729
  {11, 10,   0}, // #11730
  {15, 10,   0}, // #11731
  {18, 10,   0}, // #11732
  {20, 10,   0}, // #11733
  {21, 10,   0}, // #11734
  {22, 10,   0}, // #11735
  {11,  2,   0}, // #11736
  {15,  1,   0}, // #11737
  {18,  1,   0}, // #11738
  {19,  1,   0}, // #11739
  {20,  1,   0}, // #11740
  {21,  1,   0}, // #11741
  {22,  1,   0}, // #11742
  { 1,  1,   0}, // #11743
  {11,  2,   0}, // #11744
  {15,  1,   0}, // #11745
  {18,  1,   0}, // #11746
  {19,  1,   0}, // #11747
  {20,  1,   0}, // #11748
  {21,  1,   0}, // #11749
  {22,  1,   0}, // #11750
  { 1,  1,   0}, // #11751
  {11,  1,   0}, // #11752
  {17,  1,   0}, // #11753
  { 1,  5,   0}, // #11754
  {11,  3,   0}, // #11755
  {14,  2,   0}, // #11756
  {17,  2,   0}, // #11757
  {19,  3,   0}, // #11758
  {21,  2,   0}, // #11759
  { 1,  1,   0}, // #11760
  {11,  1,   0}, // #11761
  {18,  1,   0}, // #11762
  {22,  1,   0}, // #11763
  { 1,  1,   0}, // #11764
  {11,  3,   0}, // #11765
  {18,  3,   0}, // #11766
  {22,  3,   0}, // #11767
  { 1,  1,   0}, // #11768
  {11,  2,   0}, // #11769
  {18,  2,   0}, // #11770
  {22,  2,   0}, // #11771
  { 1,  1,   0}, // #11772
  { 4,  1,   0}, // #11773
  { 9,  1,   0}, // #11774
  {11,  2,   0}, // #11775
  {15,  1,   0}, // #11776
  {18,  1,   0}, // #11777
  {20,  1,   0}, // #11778
  {21,  1,   0}, // #11779
  {22,  2,   0}, // #11780
  {11,  2,   0}, // #11781
  {14,  1,   0}, // #11782
  {15,  1,   0}, // #11783
  {17,  1,   0}, // #11784
  {18,  1,   0}, // #11785
  {19,  1,   0}, // #11786
  {20,  1,   0}, // #11787
  {21,  2,   0}, // #11788
  {22,  1,   0}, // #11789
  { 1,  1,   0}, // #11790
  {11,  2,   0}, // #11791
  {14,  1,   0}, // #11792
  {15,  1,   0}, // #11793
  {17,  1,   0}, // #11794
  {18,  1,   0}, // #11795
  {19,  1,   0}, // #11796
  {20,  1,   0}, // #11797
  {21,  2,   0}, // #11798
  {22,  1,   0}, // #11799
  {11,  2,   0}, // #11800
  {14,  1,   0}, // #11801
  {17,  1,   0}, // #11802
  {19,  2,   0}, // #11803
  {21,  1,   0}, // #11804
  {11,  2,   0}, // #11805
  {13,  1,   0}, // #11806
  {16,  1,   0}, // #11807
  {18,  1,   0}, // #11808
  {19,  1,   0}, // #11809
  {20,  1,   0}, // #11810
  {22,  2,   0}, // #11811
  {11,  1,   0}, // #11812
  {13,  1,   0}, // #11813
  {16,  1,   0}, // #11814
  {19,  1,   0}, // #11815
  {20,  1,   0}, // #11816
  {22,  1,   0}, // #11817
  { 1,  1,   0}, // #11818
  {11,  1,   0}, // #11819
  {13,  1,   0}, // #11820
  {16,  1,   0}, // #11821
  {19,  1,   0}, // #11822
  {20,  1,   0}, // #11823
  {22,  1,   0}, // #11824
  {12,  1,   0}, // #11825
  {23,  1,   0}, // #11826
  { 1,  2,   0}, // #11827
  { 5,  1,   0}, // #11828
  {12,  1,   0}, // #11829
  {16,  1,   0}, // #11830
  {19,  1,   0}, // #11831
  {21,  1,   0}, // #11832
  {22,  1,   0}, // #11833
  {23,  1,   0}, // #11834
  { 1,  1,   0}, // #11835
  {12,  1,   0}, // #11836
  {22,  1,   0}, // #11837
  { 1,  1,   0}, // #11838
  {12,  1,   0}, // #11839
  {17,  1,   0}, // #11840
  {23,  1,   0}, // #11841
  { 1,  1,   0}, // #11842
  { 5,  2,   0}, // #11843
  { 1,  1,   0}, // #11844
  { 5, 12,   0}, // #11845
  { 1,  1,   0}, // #11846
  { 5, 16,   0}, // #11847
  { 1,  1,   0}, // #11848
  {12,  2,   0}, // #11849
  {15,  1,   0}, // #11850
  {17,  1,   0}, // #11851
  {18,  1,   0}, // #11852
  {20,  1,   0}, // #11853
  {22,  1,   0}, // #11854
  {23,  1,   0}, // #11855
  { 1,  1,   0}, // #11856
  {12,  1,   0}, // #11857
  {13,  1,   0}, // #11858
  {17,  1,   0}, // #11859
  {18,  1,   0}, // #11860
  {19,  1,   0}, // #11861
  {23,  1,   0}, // #11862
  { 1,  1,   0}, // #11863
  {12,  1,   0}, // #11864
  {16,  1,   0}, // #11865
  {19,  1,   0}, // #11866
  {21,  1,   0}, // #11867
  {22,  1,   0}, // #11868
  {23,  1,   0}, // #11869
  { 1,  1,   0}, // #11870
  {12,  2,   0}, // #11871
  {16,  2,   0}, // #11872
  {19,  2,   0}, // #11873
  {21,  2,   0}, // #11874
  {22,  2,   0}, // #11875
  {23,  2,   0}, // #11876
  { 1,  1,   0}, // #11877
  { 5,  1,   0}, // #11878
  { 8,  1,   0}, // #11879
  {11, 17,   0}, // #11880
  { 1,  1,   0}, // #11881
  { 5,  1,   0}, // #11882
  { 8,  1,   0}, // #11883
  {11, 25,   0}, // #11884
  { 1,  1,   0}, // #11885
  { 5,  1,   0}, // #11886
  { 8,  1,   0}, // #11887
  {11, 41,   0}, // #11888
  { 1,  1,   0}, // #11889
  { 5,  1,   0}, // #11890
  { 8,  1,   0}, // #11891
  {11, 15,   0}, // #11892
  { 1,  1,   0}, // #11893
  {12,  6,   0}, // #11894
  {16,  6,   0}, // #11895
  {19,  6,   0}, // #11896
  {21,  6,   0}, // #11897
  {22,  6,   0}, // #11898
  {23,  6,   0}, // #11899
  { 1,  1,   0}, // #11900
  {12,  5,   0}, // #11901
  {16,  5,   0}, // #11902
  {19,  5,   0}, // #11903
  {21,  5,   0}, // #11904
  {22,  5,   0}, // #11905
  {23,  5,   0}, // #11906
  { 1,  1,   0}, // #11907
  {12,  5,   0}, // #11908
  {15,  3,   0}, // #11909
  {18,  3,   0}, // #11910
  {20,  5,   0}, // #11911
  {22,  3,   0}, // #11912
  {12,  3,   0}, // #11913
  {15,  2,   0}, // #11914
  {18,  2,   0}, // #11915
  {20,  3,   0}, // #11916
  {22,  2,   0}, // #11917
  { 1,  1,   0}, // #11918
  {12,  1,   0}, // #11919
  {23,  1,   0}, // #11920
  { 1,  1,   0}, // #11921
  { 5,  1,   0}, // #11922
  { 7,  1,   0}, // #11923
  {24,  1,   0}, // #11924
  { 1,  1,   0}, // #11925
  {12,  1,   0}, // #11926
  {20,  1,   0}, // #11927
  { 1,  1,   0}, // #11928
  {12,  1,   0}, // #11929
  {21,  1,   0}, // #11930
  {23,  1,   0}, // #11931
  {12,  1,   0}, // #11932
  {15,  1,   0}, // #11933
  {18,  1,   0}, // #11934
  {20,  1,   0}, // #11935
  {22,  1,   0}, // #11936
  { 1,  1,   0}, // #11937
  {12,  1,   0}, // #11938
  {15,  1,   0}, // #11939
  {18,  1,   0}, // #11940
  {20,  1,   0}, // #11941
  {22,  1,   0}, // #11942
  { 1,  1,   0}, // #11943
  { 5,  1,   0}, // #11944
  { 7,  1,   0}, // #11945
  {24,  2,   0}, // #11946
  { 1,  1,   0}, // #11947
  {12,  2,   0}, // #11948
  {13,  2,   0}, // #11949
  {17,  2,   0}, // #11950
  {18,  2,   0}, // #11951
  {19,  2,   0}, // #11952
  {23,  2,   0}, // #11953
  { 1,  1,   0}, // #11954
  {12,  2,   0}, // #11955
  {20,  2,   0}, // #11956
  { 1,  1,   0}, // #11957
  {12, 10,   0}, // #11958
  {16, 10,   0}, // #11959
  {19, 10,   0}, // #11960
  {21, 10,   0}, // #11961
  {22, 10,   0}, // #11962
  {23, 10,   0}, // #11963
  { 1,  1,   0}, // #11964
  {12,  7,   0}, // #11965
  {16,  7,   0}, // #11966
  {19,  7,   0}, // #11967
  {21,  7,   0}, // #11968
  {22,  7,   0}, // #11969
  {23,  7,   0}, // #11970
  {12, 20,   0}, // #11971
  {16, 20,   0}, // #11972
  {19, 20,   0}, // #11973
  {21, 20,   0}, // #11974
  {22, 20,   0}, // #11975
  {23, 20,   0}, // #11976
  { 1,  1,   0}, // #11977
  {12,  2,   0}, // #11978
  {17,  2,   0}, // #11979
  {23,  2,   0}, // #11980
  {12,  2,   0}, // #11981
  {15,  2,   0}, // #11982
  {18,  2,   0}, // #11983
  {20,  2,   0}, // #11984
  {22,  2,   0}, // #11985
  { 1,  1,   0}, // #11986
  {12,  2,   0}, // #11987
  {14,  2,   0}, // #11988
  {17,  2,   0}, // #11989
  {20,  2,   0}, // #11990
  {21,  2,   0}, // #11991
  {23,  2,   0}, // #11992
  {12,  2,   0}, // #11993
  {16,  1,   0}, // #11994
  {19,  1,   0}, // #11995
  {20,  1,   0}, // #11996
  {21,  1,   0}, // #11997
  {22,  1,   0}, // #11998
  {23,  1,   0}, // #11999
  { 1,  1,   0}, // #12000
  {12,  2,   0}, // #12001
  {16,  1,   0}, // #12002
  {19,  1,   0}, // #12003
  {20,  1,   0}, // #12004
  {21,  1,   0}, // #12005
  {22,  1,   0}, // #12006
  {23,  1,   0}, // #12007
  { 1,  1,   0}, // #12008
  {12,  1,   0}, // #12009
  {18,  1,   0}, // #12010
  { 1,  5,   0}, // #12011
  {12,  3,   0}, // #12012
  {15,  2,   0}, // #12013
  {18,  2,   0}, // #12014
  {20,  3,   0}, // #12015
  {22,  2,   0}, // #12016
  { 1,  1,   0}, // #12017
  {12,  1,   0}, // #12018
  {19,  1,   0}, // #12019
  {23,  1,   0}, // #12020
  { 1,  1,   0}, // #12021
  {12,  3,   0}, // #12022
  {19,  3,   0}, // #12023
  {23,  3,   0}, // #12024
  { 1,  1,   0}, // #12025
  {12,  3,   0}, // #12026
  {17,  3,   0}, // #12027
  {23,  3,   0}, // #12028
  { 1,  1,   0}, // #12029
  { 5,  1,   0}, // #12030
  {10,  1,   0}, // #12031
  {12,  2,   0}, // #12032
  {16,  1,   0}, // #12033
  {19,  1,   0}, // #12034
  {21,  1,   0}, // #12035
  {22,  1,   0}, // #12036
  {23,  2,   0}, // #12037
  {12,  2,   0}, // #12038
  {15,  1,   0}, // #12039
  {16,  1,   0}, // #12040
  {18,  1,   0}, // #12041
  {19,  1,   0}, // #12042
  {20,  1,   0}, // #12043
  {21,  1,   0}, // #12044
  {22,  2,   0}, // #12045
  {23,  1,   0}, // #12046
  { 1,  1,   0}, // #12047
  {12,  2,   0}, // #12048
  {15,  1,   0}, // #12049
  {16,  1,   0}, // #12050
  {18,  1,   0}, // #12051
  {19,  1,   0}, // #12052
  {20,  1,   0}, // #12053
  {21,  1,   0}, // #12054
  {22,  2,   0}, // #12055
  {23,  1,   0}, // #12056
  {12,  2,   0}, // #12057
  {15,  1,   0}, // #12058
  {18,  1,   0}, // #12059
  {20,  2,   0}, // #12060
  {22,  1,   0}, // #12061
  {12,  2,   0}, // #12062
  {14,  1,   0}, // #12063
  {17,  1,   0}, // #12064
  {19,  1,   0}, // #12065
  {20,  1,   0}, // #12066
  {21,  1,   0}, // #12067
  {23,  2,   0}, // #12068
  {12,  1,   0}, // #12069
  {14,  1,   0}, // #12070
  {17,  1,   0}, // #12071
  {20,  1,   0}, // #12072
  {21,  1,   0}, // #12073
  {23,  1,   0}, // #12074
  { 1,  1,   0}, // #12075
  {12,  1,   0}, // #12076
  {14,  1,   0}, // #12077
  {17,  1,   0}, // #12078
  {20,  1,   0}, // #12079
  {21,  1,   0}, // #12080
  {23,  1,   0}, // #12081
  {11,  1,   0}, // #12082
  {36,  1,   0}, // #12083
  {11,  0,   0}, // #12084
  {36,  0,   0}, // #12085
  {14,  1,   0}, // #12086
  {20,  1,   0}, // #12087
  {28,  1,   0}, // #12088
  {31,  1,   0}, // #12089
  {32,  1,   0}, // #12090
  {13,  1,   0}, // #12091
  {36,  1,   0}, // #12092
  {11, 12,   0}, // #12093
  {36, 12,   0}, // #12094
  { 4,  1,   0}, // #12095
  {13,  1,   0}, // #12096
  {36,  2,   0}, // #12097
  {37,  1,   0}, // #12098
  {38,  1,   0}, // #12099
  {11,  4,   0}, // #12100
  {36,  4,   0}, // #12101
  {11, 100,   0}, // #12102
  {36, 100,   0}, // #12103
  { 4,  1,   0}, // #12104
  {36,  1,   0}, // #12105
  { 4,  1,   0}, // #12106
  {36,  1,   0}, // #12107
  {37,  1,   0}, // #12108
  {39,  1,   0}, // #12109
  {10,  3,   0}, // #12110
  {11,  3,   0}, // #12111
  {36,  3,   0}, // #12112
  {26,  1,   0}, // #12113
  {27,  1,   0}, // #12114
  {37,  1,   0}, // #12115
  {39,  1,   0}, // #12116
  {14,  1,   0}, // #12117
  {26,  1,   0}, // #12118
  {37,  1,   0}, // #12119
  {38,  1,   0}, // #12120
  { 4,  2,   0}, // #12121
  {11,  1,   0}, // #12122
  {36,  3,   0}, // #12123
  {37,  2,   0}, // #12124
  {38,  1,   0}, // #12125
  {39,  1,   0}, // #12126
  {14,  2,   0}, // #12127
  {15,  2,   0}, // #12128
  {16,  2,   0}, // #12129
  {20,  2,   0}, // #12130
  {21,  2,   0}, // #12131
  {28,  2,   0}, // #12132
  {29,  2,   0}, // #12133
  {31,  2,   0}, // #12134
  {32,  2,   0}, // #12135
  { 4,  2,   0}, // #12136
  {11,  4,   0}, // #12137
  {36,  6,   0}, // #12138
  {37,  2,   0}, // #12139
  {38,  1,   0}, // #12140
  {39,  1,   0}, // #12141
  { 4,  1,   0}, // #12142
  {11,  4,   0}, // #12143
  {36,  5,   0}, // #12144
  {37,  1,   0}, // #12145
  {38,  1,   0}, // #12146
  { 4,  1,   0}, // #12147
  {11,  1,   0}, // #12148
  {36,  2,   0}, // #12149
  {37,  1,   0}, // #12150
  {38,  1,   0}, // #12151
  {14,  2,   0}, // #12152
  {17,  1,   0}, // #12153
  {18,  1,   0}, // #12154
  {20,  1,   0}, // #12155
  {26,  1,   0}, // #12156
  {28,  1,   0}, // #12157
  {31,  1,   0}, // #12158
  {32,  1,   0}, // #12159
  {37,  1,   0}, // #12160
  {38,  1,   0}, // #12161
  {14,  1,   0}, // #12162
  {17,  1,   0}, // #12163
  {18,  1,   0}, // #12164
  {20,  1,   0}, // #12165
  {28,  1,   0}, // #12166
  {31,  1,   0}, // #12167
  {32,  1,   0}, // #12168
  {14,  2,   0}, // #12169
  {15,  1,   0}, // #12170
  {16,  1,   0}, // #12171
  {20,  1,   0}, // #12172
  {21,  1,   0}, // #12173
  {26,  1,   0}, // #12174
  {28,  1,   0}, // #12175
  {29,  1,   0}, // #12176
  {31,  1,   0}, // #12177
  {32,  1,   0}, // #12178
  {37,  1,   0}, // #12179
  {38,  1,   0}, // #12180
  {14,  1,   0}, // #12181
  {15,  1,   0}, // #12182
  {16,  1,   0}, // #12183
  {20,  1,   0}, // #12184
  {21,  1,   0}, // #12185
  {28,  1,   0}, // #12186
  {29,  1,   0}, // #12187
  {31,  1,   0}, // #12188
  {32,  1,   0}, // #12189
  {14,  2,   0}, // #12190
  {20,  1,   0}, // #12191
  {26,  1,   0}, // #12192
  {28,  1,   0}, // #12193
  {31,  1,   0}, // #12194
  {32,  1,   0}, // #12195
  {37,  1,   0}, // #12196
  {38,  1,   0}, // #12197
  { 4,  1,   0}, // #12198
  {10,  1,   0}, // #12199
  {11,  1,   0}, // #12200
  {36,  2,   0}, // #12201
  {37,  1,   0}, // #12202
  {38,  1,   0}, // #12203
  {10,  1,   0}, // #12204
  {11,  1,   0}, // #12205
  {36,  1,   0}, // #12206
  { 4,  1,   0}, // #12207
  {11,  2,   0}, // #12208
  {36,  3,   0}, // #12209
  {37,  1,   0}, // #12210
  {38,  1,   0}, // #12211
  {11,  2,   0}, // #12212
  {36,  2,   0}, // #12213
  { 4,  1,   0}, // #12214
  { 6,  3,   0}, // #12215
  {10,  3,   0}, // #12216
  {11,  3,   0}, // #12217
  {36,  4,   0}, // #12218
  {37,  1,   0}, // #12219
  {38,  1,   0}, // #12220
  { 6,  3,   0}, // #12221
  {10,  3,   0}, // #12222
  {11,  3,   0}, // #12223
  {36,  3,   0}, // #12224
  { 4,  1,   0}, // #12225
  { 6,  4,   0}, // #12226
  {10,  4,   0}, // #12227
  {11,  4,   0}, // #12228
  {36,  5,   0}, // #12229
  {37,  1,   0}, // #12230
  {38,  1,   0}, // #12231
  { 6,  4,   0}, // #12232
  {10,  4,   0}, // #12233
  {11,  4,   0}, // #12234
  {36,  4,   0}, // #12235
  { 4,  2,   0}, // #12236
  {10,  1,   0}, // #12237
  {11,  1,   0}, // #12238
  {36,  3,   0}, // #12239
  {37,  2,   0}, // #12240
  {38,  1,   0}, // #12241
  {39,  1,   0}, // #12242
  {10,  2,   0}, // #12243
  {11,  2,   0}, // #12244
  {36,  2,   0}, // #12245
  { 4,  1,   0}, // #12246
  {36,  1,   0}, // #12247
  {37,  1,   0}, // #12248
  {38,  1,   0}, // #12249
  { 4,  1,   0}, // #12250
  { 9,  1,   0}, // #12251
  {11,  1,   0}, // #12252
  {36,  2,   0}, // #12253
  {37,  1,   0}, // #12254
  {38,  1,   0}, // #12255
  { 9,  1,   0}, // #12256
  {11,  1,   0}, // #12257
  {36,  1,   0}, // #12258
  {11, 28,   0}, // #12259
  {36, 28,   0}, // #12260
  {11,  8,   0}, // #12261
  {36,  8,   0}, // #12262
  {14,  3,   0}, // #12263
  {15,  2,   0}, // #12264
  {16,  2,   0}, // #12265
  {20,  2,   0}, // #12266
  {21,  2,   0}, // #12267
  {26,  1,   0}, // #12268
  {28,  2,   0}, // #12269
  {29,  2,   0}, // #12270
  {31,  2,   0}, // #12271
  {32,  2,   0}, // #12272
  {37,  1,   0}, // #12273
  {38,  1,   0}, // #12274
  { 4,  1,   0}, // #12275
  { 6,  1,   0}, // #12276
  {10,  1,   0}, // #12277
  {11,  1,   0}, // #12278
  {36,  2,   0}, // #12279
  {37,  1,   0}, // #12280
  {38,  1,   0}, // #12281
  { 6,  1,   0}, // #12282
  {10,  1,   0}, // #12283
  {11,  1,   0}, // #12284
  {36,  1,   0}, // #12285
  {14,  3,   0}, // #12286
  {17,  2,   0}, // #12287
  {18,  2,   0}, // #12288
  {20,  2,   0}, // #12289
  {26,  1,   0}, // #12290
  {28,  2,   0}, // #12291
  {31,  2,   0}, // #12292
  {32,  2,   0}, // #12293
  {37,  1,   0}, // #12294
  {38,  1,   0}, // #12295
  {14,  2,   0}, // #12296
  {17,  2,   0}, // #12297
  {18,  2,   0}, // #12298
  {20,  2,   0}, // #12299
  {28,  2,   0}, // #12300
  {31,  2,   0}, // #12301
  {32,  2,   0}, // #12302
  { 4,  1,   0}, // #12303
  { 5, 11,   0}, // #12304
  { 9, 11,   0}, // #12305
  {11, 11,   0}, // #12306
  {13, 11,   0}, // #12307
  {36, 12,   0}, // #12308
  {37,  1,   0}, // #12309
  {38,  1,   0}, // #12310
  { 5, 11,   0}, // #12311
  { 9, 11,   0}, // #12312
  {11, 11,   0}, // #12313
  {13, 11,   0}, // #12314
  {36, 11,   0}, // #12315
  { 4,  1,   0}, // #12316
  { 5, 13,   0}, // #12317
  { 9, 13,   0}, // #12318
  {11, 13,   0}, // #12319
  {13, 13,   0}, // #12320
  {36, 14,   0}, // #12321
  {37,  1,   0}, // #12322
  {38,  1,   0}, // #12323
  { 5, 13,   0}, // #12324
  { 9, 13,   0}, // #12325
  {11, 13,   0}, // #12326
  {13, 13,   0}, // #12327
  {36, 13,   0}, // #12328
  { 4,  1,   0}, // #12329
  { 5, 17,   0}, // #12330
  { 9, 17,   0}, // #12331
  {11, 17,   0}, // #12332
  {13, 17,   0}, // #12333
  {36, 18,   0}, // #12334
  {37,  1,   0}, // #12335
  {38,  1,   0}, // #12336
  { 5, 17,   0}, // #12337
  { 9, 17,   0}, // #12338
  {11, 17,   0}, // #12339
  {13, 17,   0}, // #12340
  {36, 17,   0}, // #12341
  { 4,  1,   0}, // #12342
  { 5, 10,   0}, // #12343
  { 9, 10,   0}, // #12344
  {11, 10,   0}, // #12345
  {13, 10,   0}, // #12346
  {36, 11,   0}, // #12347
  {37,  1,   0}, // #12348
  {38,  1,   0}, // #12349
  { 5, 10,   0}, // #12350
  { 9, 10,   0}, // #12351
  {11, 10,   0}, // #12352
  {13, 10,   0}, // #12353
  {36, 10,   0}, // #12354
  {14,  6,   0}, // #12355
  {15,  5,   0}, // #12356
  {16,  5,   0}, // #12357
  {19,  5,   0}, // #12358
  {20,  5,   0}, // #12359
  {21,  5,   0}, // #12360
  {23,  5,   0}, // #12361
  {26,  1,   0}, // #12362
  {28,  5,   0}, // #12363
  {29,  5,   0}, // #12364
  {30,  5,   0}, // #12365
  {31,  5,   0}, // #12366
  {32,  5,   0}, // #12367
  {34,  5,   0}, // #12368
  {35,  5,   0}, // #12369
  {37,  1,   0}, // #12370
  {38,  1,   0}, // #12371
  {14,  5,   0}, // #12372
  {15,  5,   0}, // #12373
  {16,  5,   0}, // #12374
  {19,  5,   0}, // #12375
  {20,  5,   0}, // #12376
  {21,  5,   0}, // #12377
  {23,  5,   0}, // #12378
  {28,  5,   0}, // #12379
  {29,  5,   0}, // #12380
  {30,  5,   0}, // #12381
  {31,  5,   0}, // #12382
  {32,  5,   0}, // #12383
  {34,  5,   0}, // #12384
  {35,  5,   0}, // #12385
  {14,  4,   0}, // #12386
  {15,  3,   0}, // #12387
  {16,  3,   0}, // #12388
  {19,  3,   0}, // #12389
  {20,  3,   0}, // #12390
  {21,  3,   0}, // #12391
  {23,  3,   0}, // #12392
  {26,  1,   0}, // #12393
  {28,  3,   0}, // #12394
  {29,  3,   0}, // #12395
  {30,  3,   0}, // #12396
  {31,  3,   0}, // #12397
  {32,  3,   0}, // #12398
  {34,  3,   0}, // #12399
  {35,  3,   0}, // #12400
  {37,  1,   0}, // #12401
  {38,  1,   0}, // #12402
  {14,  3,   0}, // #12403
  {15,  3,   0}, // #12404
  {16,  3,   0}, // #12405
  {19,  3,   0}, // #12406
  {20,  3,   0}, // #12407
  {21,  3,   0}, // #12408
  {23,  3,   0}, // #12409
  {28,  3,   0}, // #12410
  {29,  3,   0}, // #12411
  {30,  3,   0}, // #12412
  {31,  3,   0}, // #12413
  {32,  3,   0}, // #12414
  {34,  3,   0}, // #12415
  {35,  3,   0}, // #12416
  {14,  7,   0}, // #12417
  {15,  6,   0}, // #12418
  {16,  6,   0}, // #12419
  {20,  6,   0}, // #12420
  {21,  6,   0}, // #12421
  {26,  1,   0}, // #12422
  {28,  6,   0}, // #12423
  {29,  6,   0}, // #12424
  {31,  6,   0}, // #12425
  {32,  6,   0}, // #12426
  {37,  1,   0}, // #12427
  {38,  1,   0}, // #12428
  {14,  6,   0}, // #12429
  {15,  6,   0}, // #12430
  {16,  6,   0}, // #12431
  {20,  6,   0}, // #12432
  {21,  6,   0}, // #12433
  {28,  6,   0}, // #12434
  {29,  6,   0}, // #12435
  {31,  6,   0}, // #12436
  {32,  6,   0}, // #12437
  {14,  9,   0}, // #12438
  {15,  8,   0}, // #12439
  {16,  8,   0}, // #12440
  {20,  8,   0}, // #12441
  {21,  8,   0}, // #12442
  {26,  1,   0}, // #12443
  {28,  8,   0}, // #12444
  {29,  8,   0}, // #12445
  {31,  8,   0}, // #12446
  {32,  8,   0}, // #12447
  {37,  1,   0}, // #12448
  {38,  1,   0}, // #12449
  {14,  8,   0}, // #12450
  {15,  8,   0}, // #12451
  {16,  8,   0}, // #12452
  {20,  8,   0}, // #12453
  {21,  8,   0}, // #12454
  {28,  8,   0}, // #12455
  {29,  8,   0}, // #12456
  {31,  8,   0}, // #12457
  {32,  8,   0}, // #12458
  { 4,  1,   0}, // #12459
  {36,  1,   0}, // #12460
  {37,  2,   0}, // #12461
  {39,  2,   0}, // #12462
  {14,  2,   0}, // #12463
  {26,  2,   0}, // #12464
  {14,  2,   0}, // #12465
  {15,  1,   0}, // #12466
  {16,  1,   0}, // #12467
  {19,  1,   0}, // #12468
  {20,  1,   0}, // #12469
  {21,  1,   0}, // #12470
  {23,  1,   0}, // #12471
  {26,  1,   0}, // #12472
  {28,  1,   0}, // #12473
  {29,  1,   0}, // #12474
  {30,  1,   0}, // #12475
  {31,  1,   0}, // #12476
  {32,  1,   0}, // #12477
  {34,  1,   0}, // #12478
  {35,  1,   0}, // #12479
  {37,  1,   0}, // #12480
  {38,  1,   0}, // #12481
  {14,  2,   0}, // #12482
  {20,  1,   0}, // #12483
  {26,  1,   0}, // #12484
  {28,  1,   0}, // #12485
  {31,  1,   0}, // #12486
  {32,  1,   0}, // #12487
  {33,  1,   0}, // #12488
  {37,  1,   0}, // #12489
  {38,  1,   0}, // #12490
  {14,  1,   0}, // #12491
  {20,  1,   0}, // #12492
  {28,  1,   0}, // #12493
  {31,  1,   0}, // #12494
  {32,  1,   0}, // #12495
  {33,  1,   0}, // #12496
  {14,  3,   0}, // #12497
  {17,  2,   0}, // #12498
  {18,  2,   0}, // #12499
  {19,  2,   0}, // #12500
  {20,  2,   0}, // #12501
  {24,  2,   0}, // #12502
  {26,  1,   0}, // #12503
  {28,  2,   0}, // #12504
  {30,  2,   0}, // #12505
  {31,  2,   0}, // #12506
  {32,  2,   0}, // #12507
  {34,  2,   0}, // #12508
  {35,  2,   0}, // #12509
  {37,  1,   0}, // #12510
  {38,  1,   0}, // #12511
  {14,  2,   0}, // #12512
  {17,  2,   0}, // #12513
  {18,  2,   0}, // #12514
  {19,  2,   0}, // #12515
  {20,  2,   0}, // #12516
  {24,  2,   0}, // #12517
  {28,  2,   0}, // #12518
  {30,  2,   0}, // #12519
  {31,  2,   0}, // #12520
  {32,  2,   0}, // #12521
  {34,  2,   0}, // #12522
  {35,  2,   0}, // #12523
  {14,  2,   0}, // #12524
  {19,  1,   0}, // #12525
  {20,  1,   0}, // #12526
  {26,  1,   0}, // #12527
  {28,  1,   0}, // #12528
  {30,  1,   0}, // #12529
  {31,  1,   0}, // #12530
  {32,  1,   0}, // #12531
  {34,  1,   0}, // #12532
  {35,  1,   0}, // #12533
  {37,  1,   0}, // #12534
  {38,  1,   0}, // #12535
  {14,  1,   0}, // #12536
  {19,  1,   0}, // #12537
  {20,  1,   0}, // #12538
  {28,  1,   0}, // #12539
  {30,  1,   0}, // #12540
  {31,  1,   0}, // #12541
  {32,  1,   0}, // #12542
  {34,  1,   0}, // #12543
  {35,  1,   0}, // #12544
  { 8,  1,   0}, // #12545
  { 9,  1,   0}, // #12546
  {11,  1,   0}, // #12547
  {36,  1,   0}, // #12548
  { 4,  1,   0}, // #12549
  {11,  6,   0}, // #12550
  {36,  7,   0}, // #12551
  {37,  1,   0}, // #12552
  {38,  1,   0}, // #12553
  {14,  3,   0}, // #12554
  {15,  2,   0}, // #12555
  {16,  2,   0}, // #12556
  {20,  2,   0}, // #12557
  {21,  2,   0}, // #12558
  {22,  2,   0}, // #12559
  {26,  1,   0}, // #12560
  {28,  2,   0}, // #12561
  {29,  2,   0}, // #12562
  {31,  2,   0}, // #12563
  {32,  2,   0}, // #12564
  {33,  2,   0}, // #12565
  {37,  1,   0}, // #12566
  {38,  1,   0}, // #12567
  {14,  2,   0}, // #12568
  {15,  2,   0}, // #12569
  {16,  2,   0}, // #12570
  {20,  2,   0}, // #12571
  {21,  2,   0}, // #12572
  {22,  2,   0}, // #12573
  {28,  2,   0}, // #12574
  {29,  2,   0}, // #12575
  {31,  2,   0}, // #12576
  {32,  2,   0}, // #12577
  {33,  2,   0}, // #12578
  {14,  3,   0}, // #12579
  {26,  3,   0}, // #12580
  {37,  1,   0}, // #12581
  {38,  1,   0}, // #12582
  {14,  1,   0}, // #12583
  {17,  1,   0}, // #12584
  {18,  1,   0}, // #12585
  {19,  1,   0}, // #12586
  {20,  1,   0}, // #12587
  {24,  1,   0}, // #12588
  {28,  1,   0}, // #12589
  {30,  1,   0}, // #12590
  {31,  1,   0}, // #12591
  {32,  1,   0}, // #12592
  {34,  1,   0}, // #12593
  {35,  1,   0}, // #12594
  {14,  3,   0}, // #12595
  {20,  2,   0}, // #12596
  {26,  1,   0}, // #12597
  {28,  2,   0}, // #12598
  {31,  2,   0}, // #12599
  {32,  2,   0}, // #12600
  {37,  1,   0}, // #12601
  {38,  1,   0}, // #12602
  {14,  2,   0}, // #12603
  {20,  2,   0}, // #12604
  {28,  2,   0}, // #12605
  {31,  2,   0}, // #12606
  {32,  2,   0}, // #12607
  {14,  9,   0}, // #12608
  {20,  8,   0}, // #12609
  {26,  1,   0}, // #12610
  {28,  8,   0}, // #12611
  {31,  8,   0}, // #12612
  {32,  8,   0}, // #12613
  {37,  1,   0}, // #12614
  {38,  1,   0}, // #12615
  {14,  8,   0}, // #12616
  {20,  8,   0}, // #12617
  {28,  8,   0}, // #12618
  {31,  8,   0}, // #12619
  {32,  8,   0}, // #12620
  {14,  5,   0}, // #12621
  {15,  4,   0}, // #12622
  {16,  4,   0}, // #12623
  {20,  4,   0}, // #12624
  {21,  4,   0}, // #12625
  {26,  1,   0}, // #12626
  {28,  4,   0}, // #12627
  {29,  4,   0}, // #12628
  {31,  4,   0}, // #12629
  {32,  4,   0}, // #12630
  {37,  1,   0}, // #12631
  {38,  1,   0}, // #12632
  {14,  4,   0}, // #12633
  {15,  4,   0}, // #12634
  {16,  4,   0}, // #12635
  {20,  4,   0}, // #12636
  {21,  4,   0}, // #12637
  {28,  4,   0}, // #12638
  {29,  4,   0}, // #12639
  {31,  4,   0}, // #12640
  {32,  4,   0}, // #12641
  {14, 13,   0}, // #12642
  {20, 12,   0}, // #12643
  {26,  1,   0}, // #12644
  {28, 12,   0}, // #12645
  {31, 12,   0}, // #12646
  {32, 12,   0}, // #12647
  {37,  1,   0}, // #12648
  {38,  1,   0}, // #12649
  {14, 12,   0}, // #12650
  {20, 12,   0}, // #12651
  {28, 12,   0}, // #12652
  {31, 12,   0}, // #12653
  {32, 12,   0}, // #12654
  { 4,  2,   0}, // #12655
  {36,  2,   0}, // #12656
  {37,  3,   0}, // #12657
  {38,  1,   0}, // #12658
  {39,  2,   0}, // #12659
  {14,  2,   0}, // #12660
  {19,  1,   0}, // #12661
  {20,  1,   0}, // #12662
  {26,  2,   0}, // #12663
  {27,  1,   0}, // #12664
  {28,  1,   0}, // #12665
  {30,  1,   0}, // #12666
  {31,  1,   0}, // #12667
  {32,  1,   0}, // #12668
  {34,  1,   0}, // #12669
  {35,  1,   0}, // #12670
  {37,  1,   0}, // #12671
  {38,  1,   0}, // #12672
  {14,  1,   0}, // #12673
  {19,  1,   0}, // #12674
  {20,  1,   0}, // #12675
  {26,  1,   0}, // #12676
  {27,  1,   0}, // #12677
  {28,  1,   0}, // #12678
  {30,  1,   0}, // #12679
  {31,  1,   0}, // #12680
  {32,  1,   0}, // #12681
  {34,  1,   0}, // #12682
  {35,  1,   0}, // #12683
  {14,  1,   0}, // #12684
  {15,  1,   0}, // #12685
  {16,  1,   0}, // #12686
  {19,  1,   0}, // #12687
  {20,  1,   0}, // #12688
  {21,  1,   0}, // #12689
  {23,  1,   0}, // #12690
  {28,  1,   0}, // #12691
  {29,  1,   0}, // #12692
  {30,  1,   0}, // #12693
  {31,  1,   0}, // #12694
  {32,  1,   0}, // #12695
  {34,  1,   0}, // #12696
  {35,  1,   0}, // #12697
  { 4,  1,   0}, // #12698
  { 9,  2,   0}, // #12699
  {11,  2,   0}, // #12700
  {36,  3,   0}, // #12701
  {37,  1,   0}, // #12702
  {39,  1,   0}, // #12703
  { 9,  2,   0}, // #12704
  {11,  2,   0}, // #12705
  {36,  2,   0}, // #12706
  { 4,  1,   0}, // #12707
  {10,  4,   0}, // #12708
  {11,  4,   0}, // #12709
  {36,  5,   0}, // #12710
  {37,  1,   0}, // #12711
  {38,  1,   0}, // #12712
  {14, 10,   0}, // #12713
  {15,  9,   0}, // #12714
  {16,  9,   0}, // #12715
  {19,  9,   0}, // #12716
  {20,  9,   0}, // #12717
  {21,  9,   0}, // #12718
  {23,  9,   0}, // #12719
  {26,  1,   0}, // #12720
  {28,  9,   0}, // #12721
  {29,  9,   0}, // #12722
  {30,  9,   0}, // #12723
  {31,  9,   0}, // #12724
  {32,  9,   0}, // #12725
  {34,  9,   0}, // #12726
  {35,  9,   0}, // #12727
  {37,  1,   0}, // #12728
  {38,  1,   0}, // #12729
  {14,  9,   0}, // #12730
  {15,  9,   0}, // #12731
  {16,  9,   0}, // #12732
  {19,  9,   0}, // #12733
  {20,  9,   0}, // #12734
  {21,  9,   0}, // #12735
  {23,  9,   0}, // #12736
  {28,  9,   0}, // #12737
  {29,  9,   0}, // #12738
  {30,  9,   0}, // #12739
  {31,  9,   0}, // #12740
  {32,  9,   0}, // #12741
  {34,  9,   0}, // #12742
  {35,  9,   0}, // #12743
  {14, 23,   0}, // #12744
  {15, 23,   0}, // #12745
  {16, 23,   0}, // #12746
  {19, 23,   0}, // #12747
  {20, 23,   0}, // #12748
  {21, 23,   0}, // #12749
  {23, 23,   0}, // #12750
  {28, 23,   0}, // #12751
  {29, 23,   0}, // #12752
  {30, 23,   0}, // #12753
  {31, 23,   0}, // #12754
  {32, 23,   0}, // #12755
  {34, 23,   0}, // #12756
  {35, 23,   0}, // #12757
  { 4,  1,   0}, // #12758
  {11, 60,   0}, // #12759
  {36, 61,   0}, // #12760
  {37,  1,   0}, // #12761
  {39,  1,   0}, // #12762
  {14,  2,   0}, // #12763
  {17,  2,   0}, // #12764
  {18,  2,   0}, // #12765
  {20,  2,   0}, // #12766
  {26,  1,   0}, // #12767
  {27,  1,   0}, // #12768
  {28,  2,   0}, // #12769
  {31,  2,   0}, // #12770
  {32,  2,   0}, // #12771
  {37,  1,   0}, // #12772
  {39,  1,   0}, // #12773
  {14,  1,   0}, // #12774
  {17,  1,   0}, // #12775
  {18,  1,   0}, // #12776
  {20,  1,   0}, // #12777
  {26,  1,   0}, // #12778
  {27,  1,   0}, // #12779
  {28,  1,   0}, // #12780
  {31,  1,   0}, // #12781
  {32,  1,   0}, // #12782
  {37,  1,   0}, // #12783
  {39,  1,   0}, // #12784
  {26,  6,   0}, // #12785
  {27,  6,   0}, // #12786
  {37,  1,   0}, // #12787
  {39,  1,   0}, // #12788
  {26,  4,   0}, // #12789
  {27,  4,   0}, // #12790
  {37,  1,   0}, // #12791
  {39,  1,   0}, // #12792
  {26, 12,   0}, // #12793
  {27, 12,   0}, // #12794
  {37,  1,   0}, // #12795
  {39,  1,   0}, // #12796
  {14,  4,   0}, // #12797
  {19,  3,   0}, // #12798
  {20,  3,   0}, // #12799
  {26,  1,   0}, // #12800
  {28,  3,   0}, // #12801
  {30,  3,   0}, // #12802
  {31,  3,   0}, // #12803
  {32,  3,   0}, // #12804
  {34,  3,   0}, // #12805
  {35,  3,   0}, // #12806
  {37,  1,   0}, // #12807
  {38,  1,   0}, // #12808
  {14,  3,   0}, // #12809
  {19,  3,   0}, // #12810
  {20,  3,   0}, // #12811
  {28,  3,   0}, // #12812
  {30,  3,   0}, // #12813
  {31,  3,   0}, // #12814
  {32,  3,   0}, // #12815
  {34,  3,   0}, // #12816
  {35,  3,   0}, // #12817
  {14,  3,   0}, // #12818
  {19,  2,   0}, // #12819
  {20,  2,   0}, // #12820
  {26,  1,   0}, // #12821
  {28,  2,   0}, // #12822
  {30,  2,   0}, // #12823
  {31,  2,   0}, // #12824
  {32,  2,   0}, // #12825
  {34,  2,   0}, // #12826
  {35,  2,   0}, // #12827
  {37,  1,   0}, // #12828
  {38,  1,   0}, // #12829
  {14,  2,   0}, // #12830
  {19,  2,   0}, // #12831
  {20,  2,   0}, // #12832
  {28,  2,   0}, // #12833
  {30,  2,   0}, // #12834
  {31,  2,   0}, // #12835
  {32,  2,   0}, // #12836
  {34,  2,   0}, // #12837
  {35,  2,   0}, // #12838
  { 4,  1,   0}, // #12839
  {10,  8,   0}, // #12840
  {11,  8,   0}, // #12841
  {36,  9,   0}, // #12842
  {37,  1,   0}, // #12843
  {38,  1,   0}, // #12844
  {37, 30,   0}, // #12845
  { 4,  3,   0}, // #12846
  {36,  3,   0}, // #12847
  {37,  1,   0}, // #12848
  {38,  1,   0}, // #12849
  { 4,  1,   0}, // #12850
  {11, 12,   0}, // #12851
  {36, 13,   0}, // #12852
  {37,  1,   0}, // #12853
  {38,  1,   0}, // #12854
  {11, 24,   0}, // #12855
  {36, 24,   0}, // #12856
  {11, 59,   0}, // #12857
  {36, 59,   0}, // #12858
  {10,  6,   0}, // #12859
  {11,  6,   0}, // #12860
  {36,  6,   0}, // #12861
  {10,  8,   0}, // #12862
  {11,  8,   0}, // #12863
  {36,  8,   0}, // #12864
  { 4,  1,   0}, // #12865
  {14,  1,   0}, // #12866
  {15,  1,   0}, // #12867
  {16,  1,   0}, // #12868
  {20,  1,   0}, // #12869
  {21,  1,   0}, // #12870
  {22,  1,   0}, // #12871
  {28,  1,   0}, // #12872
  {29,  1,   0}, // #12873
  {31,  1,   0}, // #12874
  {32,  1,   0}, // #12875
  {33,  1,   0}, // #12876
  {36,  1,   0}, // #12877
  {37,  1,   0}, // #12878
  {38,  1,   0}, // #12879
  { 4,  1,   0}, // #12880
  {14, 24,   0}, // #12881
  {20, 24,   0}, // #12882
  {28, 24,   0}, // #12883
  {31, 24,   0}, // #12884
  {32, 24,   0}, // #12885
  {36,  1,   0}, // #12886
  {37,  1,   0}, // #12887
  {38,  1,   0}, // #12888
  { 4,  1,   0}, // #12889
  {14, 62,   0}, // #12890
  {20, 62,   0}, // #12891
  {28, 62,   0}, // #12892
  {31, 62,   0}, // #12893
  {32, 62,   0}, // #12894
  {36,  1,   0}, // #12895
  {37,  1,   0}, // #12896
  {38,  1,   0}, // #12897
  { 4,  1,   0}, // #12898
  {11,  4,   0}, // #12899
  {36,  5,   0}, // #12900
  {37,  1,   0}, // #12901
  {39,  1,   0}, // #12902
  {14,  6,   0}, // #12903
  {17,  6,   0}, // #12904
  {18,  6,   0}, // #12905
  {20,  6,   0}, // #12906
  {28,  6,   0}, // #12907
  {31,  6,   0}, // #12908
  {32,  6,   0}, // #12909
  { 4,  1,   0}, // #12910
  {14,  1,   0}, // #12911
  {15,  1,   0}, // #12912
  {16,  1,   0}, // #12913
  {19,  1,   0}, // #12914
  {20,  1,   0}, // #12915
  {21,  1,   0}, // #12916
  {23,  1,   0}, // #12917
  {28,  1,   0}, // #12918
  {29,  1,   0}, // #12919
  {30,  1,   0}, // #12920
  {31,  1,   0}, // #12921
  {32,  1,   0}, // #12922
  {34,  1,   0}, // #12923
  {35,  1,   0}, // #12924
  {36,  1,   0}, // #12925
  {37,  1,   0}, // #12926
  {38,  1,   0}, // #12927
  {14,  1,   0}, // #12928
  {15,  1,   0}, // #12929
  {16,  1,   0}, // #12930
  {20,  1,   0}, // #12931
  {21,  1,   0}, // #12932
  {22,  1,   0}, // #12933
  {26,  1,   0}, // #12934
  {27,  1,   0}, // #12935
  {28,  1,   0}, // #12936
  {29,  1,   0}, // #12937
  {31,  1,   0}, // #12938
  {32,  1,   0}, // #12939
  {33,  1,   0}, // #12940
  {37,  1,   0}, // #12941
  {39,  1,   0}, // #12942
  { 4,  1,   0}, // #12943
  {14,  8,   0}, // #12944
  {20,  8,   0}, // #12945
  {28,  8,   0}, // #12946
  {31,  8,   0}, // #12947
  {32,  8,   0}, // #12948
  {36,  1,   0}, // #12949
  {37,  1,   0}, // #12950
  {38,  1,   0}, // #12951
  {14,  3,   0}, // #12952
  {20,  3,   0}, // #12953
  {28,  3,   0}, // #12954
  {31,  3,   0}, // #12955
  {32,  3,   0}, // #12956
  { 4,  1,   0}, // #12957
  {14,  3,   0}, // #12958
  {20,  3,   0}, // #12959
  {28,  3,   0}, // #12960
  {31,  3,   0}, // #12961
  {32,  3,   0}, // #12962
  {36,  1,   0}, // #12963
  {37,  1,   0}, // #12964
  {38,  1,   0}, // #12965
  { 4,  1,   0}, // #12966
  {14,  2,   0}, // #12967
  {20,  2,   0}, // #12968
  {28,  2,   0}, // #12969
  {31,  2,   0}, // #12970
  {32,  2,   0}, // #12971
  {36,  1,   0}, // #12972
  {37,  1,   0}, // #12973
  {38,  1,   0}, // #12974
  { 4,  1,   0}, // #12975
  {11,  7,   0}, // #12976
  {36,  8,   0}, // #12977
  {37,  2,   0}, // #12978
  {38,  1,   0}, // #12979
  {39,  1,   0}, // #12980
  { 4,  1,   0}, // #12981
  {10,  2,   0}, // #12982
  {11,  2,   0}, // #12983
  {36,  3,   0}, // #12984
  {37,  1,   0}, // #12985
  {38,  1,   0}, // #12986
  {14,  5,   0}, // #12987
  {20,  4,   0}, // #12988
  {26,  1,   0}, // #12989
  {28,  4,   0}, // #12990
  {31,  4,   0}, // #12991
  {32,  4,   0}, // #12992
  { 4,  1,   0}, // #12993
  {14,  2,   0}, // #12994
  {15,  2,   0}, // #12995
  {16,  2,   0}, // #12996
  {19,  2,   0}, // #12997
  {20,  2,   0}, // #12998
  {21,  2,   0}, // #12999
  {23,  2,   0}, // #13000
  {28,  2,   0}, // #13001
  {29,  2,   0}, // #13002
  {30,  2,   0}, // #13003
  {31,  2,   0}, // #13004
  {32,  2,   0}, // #13005
  {34,  2,   0}, // #13006
  {35,  2,   0}, // #13007
  {36,  1,   0}, // #13008
  {37,  1,   0}, // #13009
  {38,  1,   0}, // #13010
  {11,  1,   0}, // #13011
  {41,  1,   0}, // #13012
  {11,  0,   0}, // #13013
  {41,  0,   0}, // #13014
  {14,  1,   0}, // #13015
  {28,  1,   0}, // #13016
  {33,  1,   0}, // #13017
  {36,  1,   0}, // #13018
  {37,  1,   0}, // #13019
  {13,  1,   0}, // #13020
  {41,  1,   0}, // #13021
  {11, 12,   0}, // #13022
  {41, 12,   0}, // #13023
  { 4,  1,   0}, // #13024
  {13,  1,   0}, // #13025
  {41,  2,   0}, // #13026
  {42,  1,   0}, // #13027
  {43,  1,   0}, // #13028
  {11,  4,   0}, // #13029
  {41,  4,   0}, // #13030
  {11, 100,   0}, // #13031
  {41, 100,   0}, // #13032
  { 4,  1,   0}, // #13033
  {41,  1,   0}, // #13034
  { 4,  1,   0}, // #13035
  {41,  1,   0}, // #13036
  {42,  1,   0}, // #13037
  {44,  1,   0}, // #13038
  {10,  3,   0}, // #13039
  {11,  3,   0}, // #13040
  {41,  3,   0}, // #13041
  {19,  1,   0}, // #13042
  {32,  1,   0}, // #13043
  {42,  1,   0}, // #13044
  {44,  1,   0}, // #13045
  {14,  1,   0}, // #13046
  {19,  1,   0}, // #13047
  {30,  1,   0}, // #13048
  {42,  1,   0}, // #13049
  {43,  1,   0}, // #13050
  { 4,  2,   0}, // #13051
  {11,  1,   0}, // #13052
  {41,  3,   0}, // #13053
  {42,  2,   0}, // #13054
  {43,  1,   0}, // #13055
  {44,  1,   0}, // #13056
  {14,  2,   0}, // #13057
  {20,  2,   0}, // #13058
  {21,  2,   0}, // #13059
  {24,  2,   0}, // #13060
  {28,  2,   0}, // #13061
  {29,  2,   0}, // #13062
  {33,  2,   0}, // #13063
  {34,  2,   0}, // #13064
  {36,  2,   0}, // #13065
  {37,  2,   0}, // #13066
  { 4,  2,   0}, // #13067
  {11,  4,   0}, // #13068
  {41,  6,   0}, // #13069
  {42,  2,   0}, // #13070
  {43,  1,   0}, // #13071
  {44,  1,   0}, // #13072
  { 4,  1,   0}, // #13073
  {11,  4,   0}, // #13074
  {41,  5,   0}, // #13075
  {42,  1,   0}, // #13076
  {43,  1,   0}, // #13077
  { 4,  1,   0}, // #13078
  {11,  1,   0}, // #13079
  {41,  2,   0}, // #13080
  {42,  1,   0}, // #13081
  {43,  1,   0}, // #13082
  {14,  2,   0}, // #13083
  {19,  1,   0}, // #13084
  {22,  1,   0}, // #13085
  {23,  1,   0}, // #13086
  {26,  1,   0}, // #13087
  {27,  1,   0}, // #13088
  {28,  1,   0}, // #13089
  {30,  1,   0}, // #13090
  {31,  1,   0}, // #13091
  {33,  1,   0}, // #13092
  {36,  1,   0}, // #13093
  {37,  1,   0}, // #13094
  {42,  1,   0}, // #13095
  {43,  1,   0}, // #13096
  {14,  1,   0}, // #13097
  {22,  1,   0}, // #13098
  {23,  1,   0}, // #13099
  {26,  1,   0}, // #13100
  {27,  1,   0}, // #13101
  {28,  1,   0}, // #13102
  {31,  1,   0}, // #13103
  {33,  1,   0}, // #13104
  {36,  1,   0}, // #13105
  {37,  1,   0}, // #13106
  {14,  2,   0}, // #13107
  {19,  1,   0}, // #13108
  {20,  1,   0}, // #13109
  {21,  1,   0}, // #13110
  {24,  1,   0}, // #13111
  {28,  1,   0}, // #13112
  {29,  1,   0}, // #13113
  {30,  1,   0}, // #13114
  {33,  1,   0}, // #13115
  {34,  1,   0}, // #13116
  {36,  1,   0}, // #13117
  {37,  1,   0}, // #13118
  {42,  1,   0}, // #13119
  {43,  1,   0}, // #13120
  {14,  1,   0}, // #13121
  {20,  1,   0}, // #13122
  {21,  1,   0}, // #13123
  {24,  1,   0}, // #13124
  {28,  1,   0}, // #13125
  {29,  1,   0}, // #13126
  {33,  1,   0}, // #13127
  {34,  1,   0}, // #13128
  {36,  1,   0}, // #13129
  {37,  1,   0}, // #13130
  {14,  2,   0}, // #13131
  {19,  1,   0}, // #13132
  {28,  1,   0}, // #13133
  {30,  1,   0}, // #13134
  {33,  1,   0}, // #13135
  {36,  1,   0}, // #13136
  {37,  1,   0}, // #13137
  {42,  1,   0}, // #13138
  {43,  1,   0}, // #13139
  { 4,  1,   0}, // #13140
  {10,  1,   0}, // #13141
  {11,  1,   0}, // #13142
  {41,  2,   0}, // #13143
  {42,  1,   0}, // #13144
  {43,  1,   0}, // #13145
  {10,  1,   0}, // #13146
  {11,  1,   0}, // #13147
  {41,  1,   0}, // #13148
  { 4,  1,   0}, // #13149
  { 6,  1,   0}, // #13150
  {10,  1,   0}, // #13151
  {11,  1,   0}, // #13152
  {41,  2,   0}, // #13153
  {42,  1,   0}, // #13154
  {43,  1,   0}, // #13155
  { 6,  1,   0}, // #13156
  {10,  1,   0}, // #13157
  {11,  1,   0}, // #13158
  {41,  1,   0}, // #13159
  { 4,  2,   0}, // #13160
  {10,  1,   0}, // #13161
  {11,  1,   0}, // #13162
  {41,  3,   0}, // #13163
  {42,  2,   0}, // #13164
  {43,  1,   0}, // #13165
  {44,  1,   0}, // #13166
  {10,  2,   0}, // #13167
  {11,  2,   0}, // #13168
  {41,  2,   0}, // #13169
  { 4,  1,   0}, // #13170
  {41,  1,   0}, // #13171
  {42,  1,   0}, // #13172
  {43,  1,   0}, // #13173
  { 4,  1,   0}, // #13174
  { 9,  1,   0}, // #13175
  {11,  1,   0}, // #13176
  {41,  2,   0}, // #13177
  {42,  1,   0}, // #13178
  {43,  1,   0}, // #13179
  { 9,  1,   0}, // #13180
  {11,  1,   0}, // #13181
  {41,  1,   0}, // #13182
  {11, 28,   0}, // #13183
  {41, 28,   0}, // #13184
  {11,  8,   0}, // #13185
  {41,  8,   0}, // #13186
  {14,  3,   0}, // #13187
  {19,  1,   0}, // #13188
  {20,  2,   0}, // #13189
  {21,  2,   0}, // #13190
  {24,  2,   0}, // #13191
  {28,  2,   0}, // #13192
  {29,  2,   0}, // #13193
  {30,  1,   0}, // #13194
  {33,  2,   0}, // #13195
  {34,  2,   0}, // #13196
  {36,  2,   0}, // #13197
  {37,  2,   0}, // #13198
  {42,  1,   0}, // #13199
  {43,  1,   0}, // #13200
  {14,  3,   0}, // #13201
  {19,  1,   0}, // #13202
  {22,  2,   0}, // #13203
  {23,  2,   0}, // #13204
  {26,  2,   0}, // #13205
  {27,  2,   0}, // #13206
  {28,  2,   0}, // #13207
  {30,  1,   0}, // #13208
  {31,  2,   0}, // #13209
  {33,  2,   0}, // #13210
  {36,  2,   0}, // #13211
  {37,  2,   0}, // #13212
  {42,  1,   0}, // #13213
  {43,  1,   0}, // #13214
  {14,  2,   0}, // #13215
  {22,  2,   0}, // #13216
  {23,  2,   0}, // #13217
  {26,  2,   0}, // #13218
  {27,  2,   0}, // #13219
  {28,  2,   0}, // #13220
  {31,  2,   0}, // #13221
  {33,  2,   0}, // #13222
  {36,  2,   0}, // #13223
  {37,  2,   0}, // #13224
  {14,  6,   0}, // #13225
  {19,  1,   0}, // #13226
  {22,  5,   0}, // #13227
  {23,  5,   0}, // #13228
  {26,  5,   0}, // #13229
  {27,  5,   0}, // #13230
  {28,  5,   0}, // #13231
  {30,  1,   0}, // #13232
  {31,  5,   0}, // #13233
  {33,  5,   0}, // #13234
  {36,  5,   0}, // #13235
  {37,  5,   0}, // #13236
  {42,  1,   0}, // #13237
  {43,  1,   0}, // #13238
  {14,  5,   0}, // #13239
  {22,  5,   0}, // #13240
  {23,  5,   0}, // #13241
  {26,  5,   0}, // #13242
  {27,  5,   0}, // #13243
  {28,  5,   0}, // #13244
  {31,  5,   0}, // #13245
  {33,  5,   0}, // #13246
  {36,  5,   0}, // #13247
  {37,  5,   0}, // #13248
  { 4,  1,   0}, // #13249
  { 5, 11,   0}, // #13250
  { 9, 11,   0}, // #13251
  {11, 11,   0}, // #13252
  {13, 11,   0}, // #13253
  {41, 12,   0}, // #13254
  {42,  1,   0}, // #13255
  {43,  1,   0}, // #13256
  { 5, 11,   0}, // #13257
  { 9, 11,   0}, // #13258
  {11, 11,   0}, // #13259
  {13, 11,   0}, // #13260
  {41, 11,   0}, // #13261
  { 4,  1,   0}, // #13262
  { 5, 13,   0}, // #13263
  { 9, 13,   0}, // #13264
  {11, 13,   0}, // #13265
  {13, 13,   0}, // #13266
  {41, 14,   0}, // #13267
  {42,  1,   0}, // #13268
  {43,  1,   0}, // #13269
  { 5, 13,   0}, // #13270
  { 9, 13,   0}, // #13271
  {11, 13,   0}, // #13272
  {13, 13,   0}, // #13273
  {41, 13,   0}, // #13274
  { 4,  1,   0}, // #13275
  { 5, 17,   0}, // #13276
  { 9, 17,   0}, // #13277
  {11, 17,   0}, // #13278
  {13, 17,   0}, // #13279
  {41, 18,   0}, // #13280
  {42,  1,   0}, // #13281
  {43,  1,   0}, // #13282
  { 5, 17,   0}, // #13283
  { 9, 17,   0}, // #13284
  {11, 17,   0}, // #13285
  {13, 17,   0}, // #13286
  {41, 17,   0}, // #13287
  { 4,  1,   0}, // #13288
  { 5, 10,   0}, // #13289
  { 9, 10,   0}, // #13290
  {11, 10,   0}, // #13291
  {13, 10,   0}, // #13292
  {41, 11,   0}, // #13293
  {42,  1,   0}, // #13294
  {43,  1,   0}, // #13295
  { 5, 10,   0}, // #13296
  { 9, 10,   0}, // #13297
  {11, 10,   0}, // #13298
  {13, 10,   0}, // #13299
  {41, 10,   0}, // #13300
  {14,  6,   0}, // #13301
  {16,  5,   0}, // #13302
  {19,  1,   0}, // #13303
  {20,  5,   0}, // #13304
  {21,  5,   0}, // #13305
  {24,  5,   0}, // #13306
  {25,  5,   0}, // #13307
  {27,  5,   0}, // #13308
  {28,  5,   0}, // #13309
  {29,  5,   0}, // #13310
  {30,  1,   0}, // #13311
  {33,  5,   0}, // #13312
  {34,  5,   0}, // #13313
  {35,  5,   0}, // #13314
  {36,  5,   0}, // #13315
  {37,  5,   0}, // #13316
  {39,  5,   0}, // #13317
  {40,  5,   0}, // #13318
  {42,  1,   0}, // #13319
  {43,  1,   0}, // #13320
  {14,  5,   0}, // #13321
  {16,  5,   0}, // #13322
  {20,  5,   0}, // #13323
  {21,  5,   0}, // #13324
  {24,  5,   0}, // #13325
  {25,  5,   0}, // #13326
  {27,  5,   0}, // #13327
  {28,  5,   0}, // #13328
  {29,  5,   0}, // #13329
  {33,  5,   0}, // #13330
  {34,  5,   0}, // #13331
  {35,  5,   0}, // #13332
  {36,  5,   0}, // #13333
  {37,  5,   0}, // #13334
  {39,  5,   0}, // #13335
  {40,  5,   0}, // #13336
  {14,  4,   0}, // #13337
  {16,  3,   0}, // #13338
  {19,  1,   0}, // #13339
  {20,  3,   0}, // #13340
  {21,  3,   0}, // #13341
  {24,  3,   0}, // #13342
  {25,  3,   0}, // #13343
  {27,  3,   0}, // #13344
  {28,  3,   0}, // #13345
  {29,  3,   0}, // #13346
  {30,  1,   0}, // #13347
  {33,  3,   0}, // #13348
  {34,  3,   0}, // #13349
  {35,  3,   0}, // #13350
  {36,  3,   0}, // #13351
  {37,  3,   0}, // #13352
  {39,  3,   0}, // #13353
  {40,  3,   0}, // #13354
  {42,  1,   0}, // #13355
  {43,  1,   0}, // #13356
  {14,  3,   0}, // #13357
  {16,  3,   0}, // #13358
  {20,  3,   0}, // #13359
  {21,  3,   0}, // #13360
  {24,  3,   0}, // #13361
  {25,  3,   0}, // #13362
  {27,  3,   0}, // #13363
  {28,  3,   0}, // #13364
  {29,  3,   0}, // #13365
  {33,  3,   0}, // #13366
  {34,  3,   0}, // #13367
  {35,  3,   0}, // #13368
  {36,  3,   0}, // #13369
  {37,  3,   0}, // #13370
  {39,  3,   0}, // #13371
  {40,  3,   0}, // #13372
  {14,  7,   0}, // #13373
  {19,  1,   0}, // #13374
  {20,  6,   0}, // #13375
  {21,  6,   0}, // #13376
  {24,  6,   0}, // #13377
  {28,  6,   0}, // #13378
  {29,  6,   0}, // #13379
  {30,  1,   0}, // #13380
  {33,  6,   0}, // #13381
  {34,  6,   0}, // #13382
  {36,  6,   0}, // #13383
  {37,  6,   0}, // #13384
  {42,  1,   0}, // #13385
  {43,  1,   0}, // #13386
  {14,  6,   0}, // #13387
  {20,  6,   0}, // #13388
  {21,  6,   0}, // #13389
  {24,  6,   0}, // #13390
  {28,  6,   0}, // #13391
  {29,  6,   0}, // #13392
  {33,  6,   0}, // #13393
  {34,  6,   0}, // #13394
  {36,  6,   0}, // #13395
  {37,  6,   0}, // #13396
  {14,  9,   0}, // #13397
  {19,  1,   0}, // #13398
  {20,  8,   0}, // #13399
  {21,  8,   0}, // #13400
  {24,  8,   0}, // #13401
  {28,  8,   0}, // #13402
  {29,  8,   0}, // #13403
  {30,  1,   0}, // #13404
  {33,  8,   0}, // #13405
  {34,  8,   0}, // #13406
  {36,  8,   0}, // #13407
  {37,  8,   0}, // #13408
  {42,  1,   0}, // #13409
  {43,  1,   0}, // #13410
  {14,  8,   0}, // #13411
  {20,  8,   0}, // #13412
  {21,  8,   0}, // #13413
  {24,  8,   0}, // #13414
  {28,  8,   0}, // #13415
  {29,  8,   0}, // #13416
  {33,  8,   0}, // #13417
  {34,  8,   0}, // #13418
  {36,  8,   0}, // #13419
  {37,  8,   0}, // #13420
  { 4,  1,   0}, // #13421
  {41,  1,   0}, // #13422
  {42,  2,   0}, // #13423
  {44,  2,   0}, // #13424
  {14,  2,   0}, // #13425
  {19,  2,   0}, // #13426
  {30,  2,   0}, // #13427
  {14,  2,   0}, // #13428
  {16,  1,   0}, // #13429
  {19,  1,   0}, // #13430
  {20,  1,   0}, // #13431
  {21,  1,   0}, // #13432
  {24,  1,   0}, // #13433
  {25,  1,   0}, // #13434
  {27,  1,   0}, // #13435
  {28,  1,   0}, // #13436
  {29,  1,   0}, // #13437
  {30,  1,   0}, // #13438
  {33,  1,   0}, // #13439
  {34,  1,   0}, // #13440
  {35,  1,   0}, // #13441
  {36,  1,   0}, // #13442
  {37,  1,   0}, // #13443
  {39,  1,   0}, // #13444
  {40,  1,   0}, // #13445
  {42,  1,   0}, // #13446
  {43,  1,   0}, // #13447
  {14,  2,   0}, // #13448
  {19,  1,   0}, // #13449
  {28,  1,   0}, // #13450
  {30,  1,   0}, // #13451
  {33,  1,   0}, // #13452
  {36,  1,   0}, // #13453
  {37,  1,   0}, // #13454
  {38,  1,   0}, // #13455
  {42,  1,   0}, // #13456
  {43,  1,   0}, // #13457
  {14,  1,   0}, // #13458
  {28,  1,   0}, // #13459
  {33,  1,   0}, // #13460
  {36,  1,   0}, // #13461
  {37,  1,   0}, // #13462
  {38,  1,   0}, // #13463
  {14,  3,   0}, // #13464
  {17,  2,   0}, // #13465
  {19,  1,   0}, // #13466
  {22,  2,   0}, // #13467
  {23,  2,   0}, // #13468
  {25,  2,   0}, // #13469
  {26,  2,   0}, // #13470
  {27,  2,   0}, // #13471
  {28,  2,   0}, // #13472
  {30,  1,   0}, // #13473
  {31,  2,   0}, // #13474
  {33,  2,   0}, // #13475
  {35,  2,   0}, // #13476
  {36,  2,   0}, // #13477
  {37,  2,   0}, // #13478
  {39,  2,   0}, // #13479
  {40,  2,   0}, // #13480
  {42,  1,   0}, // #13481
  {43,  1,   0}, // #13482
  {14,  2,   0}, // #13483
  {17,  2,   0}, // #13484
  {22,  2,   0}, // #13485
  {23,  2,   0}, // #13486
  {25,  2,   0}, // #13487
  {26,  2,   0}, // #13488
  {27,  2,   0}, // #13489
  {28,  2,   0}, // #13490
  {31,  2,   0}, // #13491
  {33,  2,   0}, // #13492
  {35,  2,   0}, // #13493
  {36,  2,   0}, // #13494
  {37,  2,   0}, // #13495
  {39,  2,   0}, // #13496
  {40,  2,   0}, // #13497
  { 4,  1,   0}, // #13498
  { 6,  3,   0}, // #13499
  {10,  3,   0}, // #13500
  {11,  3,   0}, // #13501
  {41,  4,   0}, // #13502
  {42,  1,   0}, // #13503
  {43,  1,   0}, // #13504
  { 6,  3,   0}, // #13505
  {10,  3,   0}, // #13506
  {11,  3,   0}, // #13507
  {41,  3,   0}, // #13508
  { 4,  1,   0}, // #13509
  { 6,  4,   0}, // #13510
  {10,  4,   0}, // #13511
  {11,  4,   0}, // #13512
  {41,  5,   0}, // #13513
  {42,  1,   0}, // #13514
  {43,  1,   0}, // #13515
  { 6,  4,   0}, // #13516
  {10,  4,   0}, // #13517
  {11,  4,   0}, // #13518
  {41,  4,   0}, // #13519
  {14,  2,   0}, // #13520
  {19,  1,   0}, // #13521
  {25,  1,   0}, // #13522
  {27,  1,   0}, // #13523
  {28,  1,   0}, // #13524
  {30,  1,   0}, // #13525
  {33,  1,   0}, // #13526
  {35,  1,   0}, // #13527
  {36,  1,   0}, // #13528
  {37,  1,   0}, // #13529
  {39,  1,   0}, // #13530
  {40,  1,   0}, // #13531
  {42,  1,   0}, // #13532
  {43,  1,   0}, // #13533
  {14,  1,   0}, // #13534
  {25,  1,   0}, // #13535
  {27,  1,   0}, // #13536
  {28,  1,   0}, // #13537
  {33,  1,   0}, // #13538
  {35,  1,   0}, // #13539
  {36,  1,   0}, // #13540
  {37,  1,   0}, // #13541
  {39,  1,   0}, // #13542
  {40,  1,   0}, // #13543
  { 8,  1,   0}, // #13544
  { 9,  1,   0}, // #13545
  {11,  1,   0}, // #13546
  {41,  1,   0}, // #13547
  { 4,  1,   0}, // #13548
  {11,  6,   0}, // #13549
  {41,  7,   0}, // #13550
  {42,  1,   0}, // #13551
  {43,  1,   0}, // #13552
  {14,  3,   0}, // #13553
  {15,  2,   0}, // #13554
  {19,  1,   0}, // #13555
  {20,  2,   0}, // #13556
  {21,  2,   0}, // #13557
  {24,  2,   0}, // #13558
  {28,  2,   0}, // #13559
  {29,  2,   0}, // #13560
  {30,  1,   0}, // #13561
  {33,  2,   0}, // #13562
  {34,  2,   0}, // #13563
  {36,  2,   0}, // #13564
  {37,  2,   0}, // #13565
  {38,  2,   0}, // #13566
  {42,  1,   0}, // #13567
  {43,  1,   0}, // #13568
  {14,  2,   0}, // #13569
  {15,  2,   0}, // #13570
  {20,  2,   0}, // #13571
  {21,  2,   0}, // #13572
  {24,  2,   0}, // #13573
  {28,  2,   0}, // #13574
  {29,  2,   0}, // #13575
  {33,  2,   0}, // #13576
  {34,  2,   0}, // #13577
  {36,  2,   0}, // #13578
  {37,  2,   0}, // #13579
  {38,  2,   0}, // #13580
  {14,  3,   0}, // #13581
  {19,  3,   0}, // #13582
  {30,  3,   0}, // #13583
  {42,  1,   0}, // #13584
  {43,  1,   0}, // #13585
  {14,  1,   0}, // #13586
  {17,  1,   0}, // #13587
  {22,  1,   0}, // #13588
  {23,  1,   0}, // #13589
  {25,  1,   0}, // #13590
  {26,  1,   0}, // #13591
  {27,  1,   0}, // #13592
  {28,  1,   0}, // #13593
  {31,  1,   0}, // #13594
  {33,  1,   0}, // #13595
  {35,  1,   0}, // #13596
  {36,  1,   0}, // #13597
  {37,  1,   0}, // #13598
  {39,  1,   0}, // #13599
  {40,  1,   0}, // #13600
  {14,  3,   0}, // #13601
  {19,  1,   0}, // #13602
  {28,  2,   0}, // #13603
  {30,  1,   0}, // #13604
  {33,  2,   0}, // #13605
  {36,  2,   0}, // #13606
  {37,  2,   0}, // #13607
  {42,  1,   0}, // #13608
  {43,  1,   0}, // #13609
  {14,  2,   0}, // #13610
  {28,  2,   0}, // #13611
  {33,  2,   0}, // #13612
  {36,  2,   0}, // #13613
  {37,  2,   0}, // #13614
  {14,  9,   0}, // #13615
  {19,  1,   0}, // #13616
  {28,  8,   0}, // #13617
  {30,  1,   0}, // #13618
  {33,  8,   0}, // #13619
  {36,  8,   0}, // #13620
  {37,  8,   0}, // #13621
  {42,  1,   0}, // #13622
  {43,  1,   0}, // #13623
  {14,  8,   0}, // #13624
  {28,  8,   0}, // #13625
  {33,  8,   0}, // #13626
  {36,  8,   0}, // #13627
  {37,  8,   0}, // #13628
  {14,  5,   0}, // #13629
  {19,  1,   0}, // #13630
  {20,  4,   0}, // #13631
  {21,  4,   0}, // #13632
  {24,  4,   0}, // #13633
  {28,  4,   0}, // #13634
  {29,  4,   0}, // #13635
  {30,  1,   0}, // #13636
  {33,  4,   0}, // #13637
  {34,  4,   0}, // #13638
  {36,  4,   0}, // #13639
  {37,  4,   0}, // #13640
  {42,  1,   0}, // #13641
  {43,  1,   0}, // #13642
  {14,  4,   0}, // #13643
  {20,  4,   0}, // #13644
  {21,  4,   0}, // #13645
  {24,  4,   0}, // #13646
  {28,  4,   0}, // #13647
  {29,  4,   0}, // #13648
  {33,  4,   0}, // #13649
  {34,  4,   0}, // #13650
  {36,  4,   0}, // #13651
  {37,  4,   0}, // #13652
  {14, 13,   0}, // #13653
  {19,  1,   0}, // #13654
  {28, 12,   0}, // #13655
  {30,  1,   0}, // #13656
  {33, 12,   0}, // #13657
  {36, 12,   0}, // #13658
  {37, 12,   0}, // #13659
  {42,  1,   0}, // #13660
  {43,  1,   0}, // #13661
  {14, 12,   0}, // #13662
  {28, 12,   0}, // #13663
  {33, 12,   0}, // #13664
  {36, 12,   0}, // #13665
  {37, 12,   0}, // #13666
  { 4,  2,   0}, // #13667
  {41,  2,   0}, // #13668
  {42,  3,   0}, // #13669
  {43,  1,   0}, // #13670
  {44,  2,   0}, // #13671
  {14,  3,   0}, // #13672
  {19,  1,   0}, // #13673
  {25,  2,   0}, // #13674
  {27,  2,   0}, // #13675
  {28,  2,   0}, // #13676
  {30,  1,   0}, // #13677
  {33,  2,   0}, // #13678
  {35,  2,   0}, // #13679
  {36,  2,   0}, // #13680
  {37,  2,   0}, // #13681
  {39,  2,   0}, // #13682
  {40,  2,   0}, // #13683
  {42,  1,   0}, // #13684
  {43,  1,   0}, // #13685
  {14,  2,   0}, // #13686
  {25,  2,   0}, // #13687
  {27,  2,   0}, // #13688
  {28,  2,   0}, // #13689
  {33,  2,   0}, // #13690
  {35,  2,   0}, // #13691
  {36,  2,   0}, // #13692
  {37,  2,   0}, // #13693
  {39,  2,   0}, // #13694
  {40,  2,   0}, // #13695
  {14,  2,   0}, // #13696
  {19,  2,   0}, // #13697
  {25,  1,   0}, // #13698
  {27,  1,   0}, // #13699
  {28,  1,   0}, // #13700
  {30,  1,   0}, // #13701
  {32,  1,   0}, // #13702
  {33,  1,   0}, // #13703
  {35,  1,   0}, // #13704
  {36,  1,   0}, // #13705
  {37,  1,   0}, // #13706
  {39,  1,   0}, // #13707
  {40,  1,   0}, // #13708
  {42,  1,   0}, // #13709
  {43,  1,   0}, // #13710
  {14,  1,   0}, // #13711
  {19,  1,   0}, // #13712
  {25,  1,   0}, // #13713
  {27,  1,   0}, // #13714
  {28,  1,   0}, // #13715
  {32,  1,   0}, // #13716
  {33,  1,   0}, // #13717
  {35,  1,   0}, // #13718
  {36,  1,   0}, // #13719
  {37,  1,   0}, // #13720
  {39,  1,   0}, // #13721
  {40,  1,   0}, // #13722
  {14,  1,   0}, // #13723
  {16,  1,   0}, // #13724
  {20,  1,   0}, // #13725
  {21,  1,   0}, // #13726
  {24,  1,   0}, // #13727
  {25,  1,   0}, // #13728
  {27,  1,   0}, // #13729
  {28,  1,   0}, // #13730
  {29,  1,   0}, // #13731
  {33,  1,   0}, // #13732
  {34,  1,   0}, // #13733
  {35,  1,   0}, // #13734
  {36,  1,   0}, // #13735
  {37,  1,   0}, // #13736
  {39,  1,   0}, // #13737
  {40,  1,   0}, // #13738
  { 4,  1,   0}, // #13739
  { 9,  2,   0}, // #13740
  {11,  2,   0}, // #13741
  {41,  3,   0}, // #13742
  {42,  1,   0}, // #13743
  {44,  1,   0}, // #13744
  { 9,  2,   0}, // #13745
  {11,  2,   0}, // #13746
  {41,  2,   0}, // #13747
  { 4,  1,   0}, // #13748
  {10,  4,   0}, // #13749
  {11,  4,   0}, // #13750
  {41,  5,   0}, // #13751
  {42,  1,   0}, // #13752
  {43,  1,   0}, // #13753
  {14, 10,   0}, // #13754
  {16,  9,   0}, // #13755
  {19,  1,   0}, // #13756
  {20,  9,   0}, // #13757
  {21,  9,   0}, // #13758
  {24,  9,   0}, // #13759
  {25,  9,   0}, // #13760
  {27,  9,   0}, // #13761
  {28,  9,   0}, // #13762
  {29,  9,   0}, // #13763
  {30,  1,   0}, // #13764
  {33,  9,   0}, // #13765
  {34,  9,   0}, // #13766
  {35,  9,   0}, // #13767
  {36,  9,   0}, // #13768
  {37,  9,   0}, // #13769
  {39,  9,   0}, // #13770
  {40,  9,   0}, // #13771
  {42,  1,   0}, // #13772
  {43,  1,   0}, // #13773
  {14,  9,   0}, // #13774
  {16,  9,   0}, // #13775
  {20,  9,   0}, // #13776
  {21,  9,   0}, // #13777
  {24,  9,   0}, // #13778
  {25,  9,   0}, // #13779
  {27,  9,   0}, // #13780
  {28,  9,   0}, // #13781
  {29,  9,   0}, // #13782
  {33,  9,   0}, // #13783
  {34,  9,   0}, // #13784
  {35,  9,   0}, // #13785
  {36,  9,   0}, // #13786
  {37,  9,   0}, // #13787
  {39,  9,   0}, // #13788
  {40,  9,   0}, // #13789
  {14, 23,   0}, // #13790
  {16, 23,   0}, // #13791
  {20, 23,   0}, // #13792
  {21, 23,   0}, // #13793
  {24, 23,   0}, // #13794
  {25, 23,   0}, // #13795
  {27, 23,   0}, // #13796
  {28, 23,   0}, // #13797
  {29, 23,   0}, // #13798
  {33, 23,   0}, // #13799
  {34, 23,   0}, // #13800
  {35, 23,   0}, // #13801
  {36, 23,   0}, // #13802
  {37, 23,   0}, // #13803
  {39, 23,   0}, // #13804
  {40, 23,   0}, // #13805
  { 4,  1,   0}, // #13806
  {11, 60,   0}, // #13807
  {41, 61,   0}, // #13808
  {42,  1,   0}, // #13809
  {44,  1,   0}, // #13810
  {14,  5,   0}, // #13811
  {19,  1,   0}, // #13812
  {22,  4,   0}, // #13813
  {23,  4,   0}, // #13814
  {26,  4,   0}, // #13815
  {27,  4,   0}, // #13816
  {28,  4,   0}, // #13817
  {30,  1,   0}, // #13818
  {31,  4,   0}, // #13819
  {33,  4,   0}, // #13820
  {36,  4,   0}, // #13821
  {37,  4,   0}, // #13822
  {42,  1,   0}, // #13823
  {43,  1,   0}, // #13824
  {14,  4,   0}, // #13825
  {22,  4,   0}, // #13826
  {23,  4,   0}, // #13827
  {26,  4,   0}, // #13828
  {27,  4,   0}, // #13829
  {28,  4,   0}, // #13830
  {31,  4,   0}, // #13831
  {33,  4,   0}, // #13832
  {36,  4,   0}, // #13833
  {37,  4,   0}, // #13834
  {14,  2,   0}, // #13835
  {19,  1,   0}, // #13836
  {22,  2,   0}, // #13837
  {23,  2,   0}, // #13838
  {26,  2,   0}, // #13839
  {27,  2,   0}, // #13840
  {28,  2,   0}, // #13841
  {31,  2,   0}, // #13842
  {32,  1,   0}, // #13843
  {33,  2,   0}, // #13844
  {36,  2,   0}, // #13845
  {37,  2,   0}, // #13846
  {42,  1,   0}, // #13847
  {44,  1,   0}, // #13848
  {14,  1,   0}, // #13849
  {19,  1,   0}, // #13850
  {22,  1,   0}, // #13851
  {23,  1,   0}, // #13852
  {26,  1,   0}, // #13853
  {27,  1,   0}, // #13854
  {28,  1,   0}, // #13855
  {31,  1,   0}, // #13856
  {32,  1,   0}, // #13857
  {33,  1,   0}, // #13858
  {36,  1,   0}, // #13859
  {37,  1,   0}, // #13860
  {42,  1,   0}, // #13861
  {44,  1,   0}, // #13862
  {14,  5,   0}, // #13863
  {19,  1,   0}, // #13864
  {28,  4,   0}, // #13865
  {30,  1,   0}, // #13866
  {33,  4,   0}, // #13867
  {36,  4,   0}, // #13868
  {37,  4,   0}, // #13869
  {42,  1,   0}, // #13870
  {43,  1,   0}, // #13871
  {14,  4,   0}, // #13872
  {28,  4,   0}, // #13873
  {33,  4,   0}, // #13874
  {36,  4,   0}, // #13875
  {37,  4,   0}, // #13876
  {14, 11,   0}, // #13877
  {16, 10,   0}, // #13878
  {19,  1,   0}, // #13879
  {20, 10,   0}, // #13880
  {21, 10,   0}, // #13881
  {24, 10,   0}, // #13882
  {25, 10,   0}, // #13883
  {27, 10,   0}, // #13884
  {28, 10,   0}, // #13885
  {29, 10,   0}, // #13886
  {30,  1,   0}, // #13887
  {33, 10,   0}, // #13888
  {34, 10,   0}, // #13889
  {35, 10,   0}, // #13890
  {36, 10,   0}, // #13891
  {37, 10,   0}, // #13892
  {39, 10,   0}, // #13893
  {40, 10,   0}, // #13894
  {42,  1,   0}, // #13895
  {43,  1,   0}, // #13896
  {14, 10,   0}, // #13897
  {16, 10,   0}, // #13898
  {20, 10,   0}, // #13899
  {21, 10,   0}, // #13900
  {24, 10,   0}, // #13901
  {25, 10,   0}, // #13902
  {27, 10,   0}, // #13903
  {28, 10,   0}, // #13904
  {29, 10,   0}, // #13905
  {33, 10,   0}, // #13906
  {34, 10,   0}, // #13907
  {35, 10,   0}, // #13908
  {36, 10,   0}, // #13909
  {37, 10,   0}, // #13910
  {39, 10,   0}, // #13911
  {40, 10,   0}, // #13912
  {14,  7,   0}, // #13913
  {16,  6,   0}, // #13914
  {19,  1,   0}, // #13915
  {20,  6,   0}, // #13916
  {21,  6,   0}, // #13917
  {24,  6,   0}, // #13918
  {25,  6,   0}, // #13919
  {27,  6,   0}, // #13920
  {28,  6,   0}, // #13921
  {29,  6,   0}, // #13922
  {30,  1,   0}, // #13923
  {33,  6,   0}, // #13924
  {34,  6,   0}, // #13925
  {35,  6,   0}, // #13926
  {36,  6,   0}, // #13927
  {37,  6,   0}, // #13928
  {39,  6,   0}, // #13929
  {40,  6,   0}, // #13930
  {42,  1,   0}, // #13931
  {43,  1,   0}, // #13932
  {14,  6,   0}, // #13933
  {16,  6,   0}, // #13934
  {20,  6,   0}, // #13935
  {21,  6,   0}, // #13936
  {24,  6,   0}, // #13937
  {25,  6,   0}, // #13938
  {27,  6,   0}, // #13939
  {28,  6,   0}, // #13940
  {29,  6,   0}, // #13941
  {33,  6,   0}, // #13942
  {34,  6,   0}, // #13943
  {35,  6,   0}, // #13944
  {36,  6,   0}, // #13945
  {37,  6,   0}, // #13946
  {39,  6,   0}, // #13947
  {40,  6,   0}, // #13948
  {14,  3,   0}, // #13949
  {19,  1,   0}, // #13950
  {28,  2,   0}, // #13951
  {30,  1,   0}, // #13952
  {33,  2,   0}, // #13953
  {36,  2,   0}, // #13954
  {37,  2,   0}, // #13955
  {38,  2,   0}, // #13956
  {42,  1,   0}, // #13957
  {43,  1,   0}, // #13958
  {14,  2,   0}, // #13959
  {28,  2,   0}, // #13960
  {33,  2,   0}, // #13961
  {36,  2,   0}, // #13962
  {37,  2,   0}, // #13963
  {38,  2,   0}, // #13964
  {19,  6,   0}, // #13965
  {32,  6,   0}, // #13966
  {42,  1,   0}, // #13967
  {44,  1,   0}, // #13968
  {19,  4,   0}, // #13969
  {32,  4,   0}, // #13970
  {42,  1,   0}, // #13971
  {44,  1,   0}, // #13972
  {19, 12,   0}, // #13973
  {32, 12,   0}, // #13974
  {42,  1,   0}, // #13975
  {44,  1,   0}, // #13976
  {14,  4,   0}, // #13977
  {15,  3,   0}, // #13978
  {19,  1,   0}, // #13979
  {20,  3,   0}, // #13980
  {21,  3,   0}, // #13981
  {24,  3,   0}, // #13982
  {28,  3,   0}, // #13983
  {29,  3,   0}, // #13984
  {30,  1,   0}, // #13985
  {33,  3,   0}, // #13986
  {34,  3,   0}, // #13987
  {36,  3,   0}, // #13988
  {37,  3,   0}, // #13989
  {38,  3,   0}, // #13990
  {42,  1,   0}, // #13991
  {43,  1,   0}, // #13992
  {14,  3,   0}, // #13993
  {15,  3,   0}, // #13994
  {20,  3,   0}, // #13995
  {21,  3,   0}, // #13996
  {24,  3,   0}, // #13997
  {28,  3,   0}, // #13998
  {29,  3,   0}, // #13999
  {33,  3,   0}, // #14000
  {34,  3,   0}, // #14001
  {36,  3,   0}, // #14002
  {37,  3,   0}, // #14003
  {38,  3,   0}, // #14004
  {14,  4,   0}, // #14005
  {19,  1,   0}, // #14006
  {25,  3,   0}, // #14007
  {27,  3,   0}, // #14008
  {28,  3,   0}, // #14009
  {30,  1,   0}, // #14010
  {33,  3,   0}, // #14011
  {35,  3,   0}, // #14012
  {36,  3,   0}, // #14013
  {37,  3,   0}, // #14014
  {39,  3,   0}, // #14015
  {40,  3,   0}, // #14016
  {42,  1,   0}, // #14017
  {43,  1,   0}, // #14018
  {14,  3,   0}, // #14019
  {25,  3,   0}, // #14020
  {27,  3,   0}, // #14021
  {28,  3,   0}, // #14022
  {33,  3,   0}, // #14023
  {35,  3,   0}, // #14024
  {36,  3,   0}, // #14025
  {37,  3,   0}, // #14026
  {39,  3,   0}, // #14027
  {40,  3,   0}, // #14028
  {14,  3,   0}, // #14029
  {16,  2,   0}, // #14030
  {19,  1,   0}, // #14031
  {20,  2,   0}, // #14032
  {21,  2,   0}, // #14033
  {24,  2,   0}, // #14034
  {25,  2,   0}, // #14035
  {27,  2,   0}, // #14036
  {28,  2,   0}, // #14037
  {29,  2,   0}, // #14038
  {30,  1,   0}, // #14039
  {33,  2,   0}, // #14040
  {34,  2,   0}, // #14041
  {35,  2,   0}, // #14042
  {36,  2,   0}, // #14043
  {37,  2,   0}, // #14044
  {39,  2,   0}, // #14045
  {40,  2,   0}, // #14046
  {42,  1,   0}, // #14047
  {43,  1,   0}, // #14048
  {14,  2,   0}, // #14049
  {16,  2,   0}, // #14050
  {20,  2,   0}, // #14051
  {21,  2,   0}, // #14052
  {24,  2,   0}, // #14053
  {25,  2,   0}, // #14054
  {27,  2,   0}, // #14055
  {28,  2,   0}, // #14056
  {29,  2,   0}, // #14057
  {33,  2,   0}, // #14058
  {34,  2,   0}, // #14059
  {35,  2,   0}, // #14060
  {36,  2,   0}, // #14061
  {37,  2,   0}, // #14062
  {39,  2,   0}, // #14063
  {40,  2,   0}, // #14064
  {14, 19,   0}, // #14065
  {16, 18,   0}, // #14066
  {19,  1,   0}, // #14067
  {20, 18,   0}, // #14068
  {21, 18,   0}, // #14069
  {24, 18,   0}, // #14070
  {25, 18,   0}, // #14071
  {27, 18,   0}, // #14072
  {28, 18,   0}, // #14073
  {29, 18,   0}, // #14074
  {30,  1,   0}, // #14075
  {33, 18,   0}, // #14076
  {34, 18,   0}, // #14077
  {35, 18,   0}, // #14078
  {36, 18,   0}, // #14079
  {37, 18,   0}, // #14080
  {39, 18,   0}, // #14081
  {40, 18,   0}, // #14082
  {42,  1,   0}, // #14083
  {43,  1,   0}, // #14084
  {14, 18,   0}, // #14085
  {16, 18,   0}, // #14086
  {20, 18,   0}, // #14087
  {21, 18,   0}, // #14088
  {24, 18,   0}, // #14089
  {25, 18,   0}, // #14090
  {27, 18,   0}, // #14091
  {28, 18,   0}, // #14092
  {29, 18,   0}, // #14093
  {33, 18,   0}, // #14094
  {34, 18,   0}, // #14095
  {35, 18,   0}, // #14096
  {36, 18,   0}, // #14097
  {37, 18,   0}, // #14098
  {39, 18,   0}, // #14099
  {40, 18,   0}, // #14100
  { 4,  1,   0}, // #14101
  {10,  8,   0}, // #14102
  {11,  8,   0}, // #14103
  {41,  9,   0}, // #14104
  {42,  1,   0}, // #14105
  {43,  1,   0}, // #14106
  {42, 30,   0}, // #14107
  { 4,  1,   0}, // #14108
  {11,  2,   0}, // #14109
  {41,  3,   0}, // #14110
  {42,  1,   0}, // #14111
  {43,  1,   0}, // #14112
  { 4,  3,   0}, // #14113
  {41,  3,   0}, // #14114
  {42,  1,   0}, // #14115
  {43,  1,   0}, // #14116
  { 4,  1,   0}, // #14117
  {11, 12,   0}, // #14118
  {41, 13,   0}, // #14119
  {42,  1,   0}, // #14120
  {43,  1,   0}, // #14121
  {11, 24,   0}, // #14122
  {41, 24,   0}, // #14123
  {11, 59,   0}, // #14124
  {41, 59,   0}, // #14125
  {10,  6,   0}, // #14126
  {11,  6,   0}, // #14127
  {41,  6,   0}, // #14128
  {10,  8,   0}, // #14129
  {11,  8,   0}, // #14130
  {41,  8,   0}, // #14131
  { 4,  1,   0}, // #14132
  {14,  1,   0}, // #14133
  {15,  1,   0}, // #14134
  {20,  1,   0}, // #14135
  {21,  1,   0}, // #14136
  {24,  1,   0}, // #14137
  {28,  1,   0}, // #14138
  {29,  1,   0}, // #14139
  {33,  1,   0}, // #14140
  {34,  1,   0}, // #14141
  {36,  1,   0}, // #14142
  {37,  1,   0}, // #14143
  {38,  1,   0}, // #14144
  {41,  1,   0}, // #14145
  {42,  1,   0}, // #14146
  {43,  1,   0}, // #14147
  { 4,  1,   0}, // #14148
  {14, 24,   0}, // #14149
  {28, 24,   0}, // #14150
  {33, 24,   0}, // #14151
  {36, 24,   0}, // #14152
  {37, 24,   0}, // #14153
  {41,  1,   0}, // #14154
  {42,  1,   0}, // #14155
  {43,  1,   0}, // #14156
  { 4,  1,   0}, // #14157
  {14, 62,   0}, // #14158
  {28, 62,   0}, // #14159
  {33, 62,   0}, // #14160
  {36, 62,   0}, // #14161
  {37, 62,   0}, // #14162
  {41,  1,   0}, // #14163
  {42,  1,   0}, // #14164
  {43,  1,   0}, // #14165
  { 4,  1,   0}, // #14166
  {11,  4,   0}, // #14167
  {41,  5,   0}, // #14168
  {42,  1,   0}, // #14169
  {44,  1,   0}, // #14170
  { 4,  1,   0}, // #14171
  {14,  1,   0}, // #14172
  {16,  1,   0}, // #14173
  {20,  1,   0}, // #14174
  {21,  1,   0}, // #14175
  {24,  1,   0}, // #14176
  {25,  1,   0}, // #14177
  {27,  1,   0}, // #14178
  {28,  1,   0}, // #14179
  {29,  1,   0}, // #14180
  {33,  1,   0}, // #14181
  {34,  1,   0}, // #14182
  {35,  1,   0}, // #14183
  {36,  1,   0}, // #14184
  {37,  1,   0}, // #14185
  {39,  1,   0}, // #14186
  {40,  1,   0}, // #14187
  {41,  1,   0}, // #14188
  {42,  1,   0}, // #14189
  {43,  1,   0}, // #14190
  {14,  1,   0}, // #14191
  {15,  1,   0}, // #14192
  {19,  1,   0}, // #14193
  {20,  1,   0}, // #14194
  {21,  1,   0}, // #14195
  {24,  1,   0}, // #14196
  {28,  1,   0}, // #14197
  {29,  1,   0}, // #14198
  {32,  1,   0}, // #14199
  {33,  1,   0}, // #14200
  {34,  1,   0}, // #14201
  {36,  1,   0}, // #14202
  {37,  1,   0}, // #14203
  {38,  1,   0}, // #14204
  {42,  1,   0}, // #14205
  {44,  1,   0}, // #14206
  { 4,  1,   0}, // #14207
  {14,  8,   0}, // #14208
  {28,  8,   0}, // #14209
  {33,  8,   0}, // #14210
  {36,  8,   0}, // #14211
  {37,  8,   0}, // #14212
  {41,  1,   0}, // #14213
  {42,  1,   0}, // #14214
  {43,  1,   0}, // #14215
  {14,  3,   0}, // #14216
  {28,  3,   0}, // #14217
  {33,  3,   0}, // #14218
  {36,  3,   0}, // #14219
  {37,  3,   0}, // #14220
  { 4,  1,   0}, // #14221
  {14,  3,   0}, // #14222
  {28,  3,   0}, // #14223
  {33,  3,   0}, // #14224
  {36,  3,   0}, // #14225
  {37,  3,   0}, // #14226
  {41,  1,   0}, // #14227
  {42,  1,   0}, // #14228
  {43,  1,   0}, // #14229
  { 4,  1,   0}, // #14230
  {14,  2,   0}, // #14231
  {28,  2,   0}, // #14232
  {33,  2,   0}, // #14233
  {36,  2,   0}, // #14234
  {37,  2,   0}, // #14235
  {41,  1,   0}, // #14236
  {42,  1,   0}, // #14237
  {43,  1,   0}, // #14238
  { 4,  1,   0}, // #14239
  {11,  7,   0}, // #14240
  {41,  8,   0}, // #14241
  {42,  2,   0}, // #14242
  {43,  1,   0}, // #14243
  {44,  1,   0}, // #14244
  { 4,  1,   0}, // #14245
  {10,  2,   0}, // #14246
  {11,  2,   0}, // #14247
  {41,  3,   0}, // #14248
  {42,  1,   0}, // #14249
  {43,  1,   0}, // #14250
  { 4,  1,   0}, // #14251
  {14,  2,   0}, // #14252
  {16,  2,   0}, // #14253
  {20,  2,   0}, // #14254
  {21,  2,   0}, // #14255
  {24,  2,   0}, // #14256
  {25,  2,   0}, // #14257
  {27,  2,   0}, // #14258
  {28,  2,   0}, // #14259
  {29,  2,   0}, // #14260
  {33,  2,   0}, // #14261
  {34,  2,   0}, // #14262
  {35,  2,   0}, // #14263
  {36,  2,   0}, // #14264
  {37,  2,   0}, // #14265
  {39,  2,   0}, // #14266
  {40,  2,   0}, // #14267
  {41,  1,   0}, // #14268
  {42,  1,   0}, // #14269
  {43,  1,   0}, // #14270
  {14,  1,   0}, // #14271
  {30,  1,   0}, // #14272
  {14,  6,   0}, // #14273
  {22,  6,   0}, // #14274
  {23,  6,   0}, // #14275
  {26,  6,   0}, // #14276
  {27,  6,   0}, // #14277
  {28,  6,   0}, // #14278
  {31,  6,   0}, // #14279
  {33,  6,   0}, // #14280
  {36,  6,   0}, // #14281
  {37,  6,   0}, // #14282
  {14,  4,   0}, // #14283
  {25,  4,   0}, // #14284
  {27,  4,   0}, // #14285
  {28,  4,   0}, // #14286
  {33,  4,   0}, // #14287
  {35,  4,   0}, // #14288
  {36,  4,   0}, // #14289
  {37,  4,   0}, // #14290
  {39,  4,   0}, // #14291
  {40,  4,   0}, // #14292
  {14,  5,   0}, // #14293
  {25,  5,   0}, // #14294
  {27,  5,   0}, // #14295
  {28,  5,   0}, // #14296
  {33,  5,   0}, // #14297
  {35,  5,   0}, // #14298
  {36,  5,   0}, // #14299
  {37,  5,   0}, // #14300
  {39,  5,   0}, // #14301
  {40,  5,   0}, // #14302
  {14,  3,   0}, // #14303
  {20,  3,   0}, // #14304
  {21,  3,   0}, // #14305
  {24,  3,   0}, // #14306
  {28,  3,   0}, // #14307
  {29,  3,   0}, // #14308
  {33,  3,   0}, // #14309
  {34,  3,   0}, // #14310
  {36,  3,   0}, // #14311
  {37,  3,   0}, // #14312
  {14,  5,   0}, // #14313
  {20,  5,   0}, // #14314
  {21,  5,   0}, // #14315
  {24,  5,   0}, // #14316
  {28,  5,   0}, // #14317
  {29,  5,   0}, // #14318
  {33,  5,   0}, // #14319
  {34,  5,   0}, // #14320
  {36,  5,   0}, // #14321
  {37,  5,   0}, // #14322
  {14,  6,   0}, // #14323
  {20,  2,   0}, // #14324
  {21,  2,   0}, // #14325
  {22,  2,   0}, // #14326
  {23,  2,   0}, // #14327
  {24,  2,   0}, // #14328
  {25,  2,   0}, // #14329
  {26,  2,   0}, // #14330
  {27,  4,   0}, // #14331
  {28,  6,   0}, // #14332
  {29,  2,   0}, // #14333
  {31,  2,   0}, // #14334
  {33,  6,   0}, // #14335
  {34,  2,   0}, // #14336
  {35,  2,   0}, // #14337
  {36,  6,   0}, // #14338
  {37,  6,   0}, // #14339
  {39,  2,   0}, // #14340
  {40,  2,   0}, // #14341
  {14,  2,   0}, // #14342
  {27,  2,   0}, // #14343
  {28,  2,   0}, // #14344
  {33,  2,   0}, // #14345
  {36,  2,   0}, // #14346
  {37,  2,   0} // #14347
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteLEA_WriteRMW_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteLoad_WriteCMOVLd_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteSHDrri_WriteLAHFSAHF_WriteVecMoveToGpr_WriteVecTest_WriteSETCCStore_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBLS_WriteMMXMOVMSK_WriteVecStoreNTY_WriteFStoreNTY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteFVarBlendY_WriteFVarBlendZ_WriteVarBlendY_WriteVarBlendZ_SPRWriteResGroup43_SPRWriteResGroup164_SPRWriteResGroup160_SPRWriteResGroup193_SPRWriteResGroup52_SPRWriteResGroup61_SPRWriteResGroup23_SPRWriteResGroup58_SPRWriteResGroup24_SPRWriteResGroup195_SPRWriteResGroup216_SPRWriteResGroup95_SPRWriteResGroup137_SPRWriteResGroup92_SPRWriteResGroup78_SPRWriteResGroup81_SPRWriteResGroup89_SPRWriteResGroup138_SPRWriteResGroup139_SPRWriteResGroup140_SPRWriteResGroup147_SPRWriteResGroup153_SPRWriteResGroup192_SPRWriteResGroup214_SPRWriteResGroup240_SPRWriteResGroup508_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_WriteFCmp64X_WriteFCmpX_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftX_WriteFCmp64Y_WriteFCmpY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_WriteBSF_WriteBSR_WriteCvtSD2I_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVMMX_Zn4WriteSFENCE_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmp64YLd_WriteFCmpYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup142_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteMPSADLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64ZLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteFAddYLd_WriteFAddZLd_WriteFCmpZLd_WriteCvtI2PSZLd_WriteCvtPS2PHZSt_WriteFRndZLd_WriteFCmp64ZLd_SPRWriteResGroup37_SPRWriteResGroup185_SPRWriteResGroup54_SPRWriteResGroup182_SPRWriteResGroup554_SPRWriteResGroup151_SPRWriteResGroup148_SPRWriteResGroup129_SPRWriteResGroup124_SPRWriteResGroup235_SPRWriteResGroup449_SPRWriteResGroup504_SPRWriteResGroup501_SPRWriteResGroup505_SPRWriteResGroup502_SPRWriteResGroup257_SPRWriteResGroup73_SPRWriteResGroup136_SPRWriteResGroup144_SPRWriteResGroup265_SPRWriteResGroup272_SPRWriteResGroup303_SPRWriteResGroup347_SPRWriteResGroup351_SPRWriteResGroup419_SPRWriteResGroup444_SPRWriteResGroup446_SPRWriteResGroup465_SPRWriteResGroup467_SPRWriteResGroup489_SPRWriteResGroup517_SPRWriteResGroup518_SPRWriteResGroup546_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_WriteFRcpZLd_WriteFRsqrtZLd
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup232_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLZCNTLd_WritePHAdd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteSHDrrcl_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_SPRWriteResGroup104_SPRWriteResGroup5_SPRWriteResGroup103_SPRWriteResGroup163_SPRWriteResGroup243_SPRWriteResGroup57_SPRWriteResGroup239_SPRWriteResGroup32_SPRWriteResGroup213_SPRWriteResGroup120_SPRWriteResGroup237_SPRWriteResGroup230_SPRWriteResGroup234_SPRWriteResGroup494_SPRWriteResGroup150_SPRWriteResGroup162_SPRWriteResGroup251_SPRWriteResGroup253_SPRWriteResGroup365_SPRWriteResGroup437_SPRWriteResGroup438_SPRWriteResGroup443_SPRWriteResGroup520_SPRWriteResGroup538_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4Writerm_SHA256MSG1rm_Zn4WriteSHA1RNDS4rri_Zn4WriteSHA1MSG1rm_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_SPRWriteResGroup177_SPRWriteResGroup202_SPRWriteResGroup72_SPRWriteResGroup556_SPRWriteResGroup29_SPRWriteResGroup205_SPRWriteResGroup207_SPRWriteResGroup30_SPRWriteResGroup86_SPRWriteResGroup105_SPRWriteResGroup106_SPRWriteResGroup107_SPRWriteResGroup108_SPRWriteResGroup109_SPRWriteResGroup110_SPRWriteResGroup145_SPRWriteResGroup175_SPRWriteResGroup176_SPRWriteResGroup189_SPRWriteResGroup190_SPRWriteResGroup191_SPRWriteResGroup203_SPRWriteResGroup204_SPRWriteResGroup209_SPRWriteResGroup224_SPRWriteResGroup241_SPRWriteResGroup244_SPRWriteResGroup557_SPRWriteResGroup576_ZnWriteMicrocoded_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup119_ADLPWriteResGroup16_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteFLoadX_WriteLoad_WriteXCHG_WriteFCmp64X_WriteFCmpX_WriteVecLoadX_WriteVecLoadNT_WriteFRnd_WriteFMaskedLoad_WriteVecMaskedLoad_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteEXTRQ_PdWriteINSERTQI_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_WriteRotateCL_WriteShiftCL_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteFMulY_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteMove_WriteShuffleZ_WriteVecALUZ_WriteVarShuffleZ_SPRWriteResGroup25_SPRWriteResGroup113_SPRWriteResGroup112_SPRWriteResGroup67_SPRWriteResGroup127_SPRWriteResGroup22_SPRWriteResGroup68_SPRWriteResGroup128_SPRWriteResGroup18_SPRWriteResGroup26_SPRWriteResGroup21_SPRWriteResGroup232_SPRWriteResGroup133_SPRWriteResGroup418_SPRWriteResGroup250_SPRWriteResGroup96_SPRWriteResGroup263_SPRWriteResGroup223_SPRWriteResGroup260_SPRWriteResGroup267_SPRWriteResGroup441_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WritePDEP_PEXT_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WriteEXTRQ_INSERTQ_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WritePDEP_PEXT_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WriteSHA256MSG2rr_Zn4WriteEXTRQ_INSERTQ_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 7,  0}, // #6 WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup13_ADLPWriteResGroup143_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup41_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteCvtSD2SSLd_WriteIMul64_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WriteFMul64X_WriteVarBlendLd_WritePHMINPOSLd_WriteFRcpLd_WriteFRsqrtLd_SLMWriteResGroup1rm_WriteFLogicLd_WriteFBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteRCL3264rCL_PdWriteVEXTRACTF128mr_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteVecIMulXLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtPD2IZ_SPRWriteResGroup121_SPRWriteResGroup161_SPRWriteResGroup82_SPRWriteResGroup62_SPRWriteResGroup565_SPRWriteResGroup212_SPRWriteResGroup246_SPRWriteResGroup20_SPRWriteResGroup15_SPRWriteResGroup152_SPRWriteResGroup199_SPRWriteResGroup115_SPRWriteResGroup149_SPRWriteResGroup464_SPRWriteResGroup39_SPRWriteResGroup268_SPRWriteResGroup93_SPRWriteResGroup0_SPRWriteResGroup44_SPRWriteResGroup415_SPRWriteResGroup271_SPRWriteResGroup470_SPRWriteResGroup486_SPRWriteResGroup488_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup92_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_WriteFHAdd_WriteIMulHLd_WriteFHAddY_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteRotateRightMCL_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_WriteDPPD_Zn4WriteRotateRightMCL_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteVPERM2F128rm_Zn4WriteSHA256MSG2rm_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteVPERMPSYrr
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup175_ADLPWriteResGroup192_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteAESDecEnc_WriteAESKeyGen_WriteCvtI2PSLd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteIMul32Ld_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePSADBWXLd_SLMWriteResGroup2rm_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteMULX32Ld_WriteMULX64Ld_WriteFVarBlendYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteVecShiftImmXLd_SPRWriteResGroup40_SPRWriteResGroup41_SPRWriteResGroup178_SPRWriteResGroup126_SPRWriteResGroup181_SPRWriteResGroup196_SPRWriteResGroup179_SPRWriteResGroup119_SPRWriteResGroup231_SPRWriteResGroup383_SPRWriteResGroup289_SPRWriteResGroup156_SPRWriteResGroup159_SPRWriteResGroup222_SPRWriteResGroup245_SPRWriteResGroup219_SPRWriteResGroup283_SPRWriteResGroup291_SPRWriteResGroup297_SPRWriteResGroup320_SPRWriteResGroup343_SPRWriteResGroup361_SPRWriteResGroup362_SPRWriteResGroup484_SPRWriteResGroup506_SPRWriteResGroup521_SPRWriteResGroup533_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteFCmp64YLd_WriteFCmpYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteRotateLeftMI_Zn3WriteVINSERTF128rmr_Zn3WriteRotateLeftMCL_Zn3WriteVEXTRACTI128mr_WriteFVarBlendZLd_Zn4WriteRotateLeftMI_Zn4WriteVINSERTF128rmr_Zn4WriteRotateLeftMCL_Zn4WriteVEXTRACTI128mr
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WritePMULLD_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_BWWriteResGroup122_1_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePMULLDLd_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteFAddXLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WritePSADBWZLd_WriteVarShuffleZLd_SPRWriteResGroup60_SPRWriteResGroup165_SPRWriteResGroup258_SPRWriteResGroup132_SPRWriteResGroup417_SPRWriteResGroup255_SPRWriteResGroup313_SPRWriteResGroup455_SPRWriteResGroup483_SPRWriteResGroup254_SPRWriteResGroup317_SPRWriteResGroup321_SPRWriteResGroup354_SPRWriteResGroup374_SPRWriteResGroup482_SPRWriteResGroup515_SPRWriteResGroup535_SPRWriteResGroup537_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPD2ILd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_WritePMULLDYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_WriteCvtPH2PSYLd_Zn3WriteVPERMPSYrm_WriteCvtI2PDZLd_WriteCvtPS2IZLd_WriteCvtPH2PSZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVPERMPSYrm
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteIMul64Ld_WriteLDMXCSR_WriteMPSADLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAXLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_SPRWriteResGroup10_SPRWriteResGroup485_SPRWriteResGroup389_SPRWriteResGroup17_SPRWriteResGroup8_SPRWriteResGroup259_SPRWriteResGroup264_SPRWriteResGroup284_SPRWriteResGroup290_SPRWriteResGroup292_SPRWriteResGroup298_SPRWriteResGroup334_SPRWriteResGroup344_SPRWriteResGroup350_SPRWriteResGroup358_SPRWriteResGroup410_SPRWriteResGroup413_SPRWriteResGroup431_SPRWriteResGroup432_SPRWriteResGroup479_SPRWriteResGroup511_SPRWriteResGroup513_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtSS2SDLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup138_SKLWriteResGroup140_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePHAddXLd_WriteFDivY_WriteVarVecShiftLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtPS2PDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteVecIMulZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERMPDYmi
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteRMW_WriteCMOVLd_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_SPRWriteResGroup186_SPRWriteResGroup111_SPRWriteResGroup247_SPRWriteResGroup575_SPRWriteResGroup187_SPRWriteResGroup236_SPRWriteResGroup367_SPRWriteResGroup340_SPRWriteResGroup31_SPRWriteResGroup74_SPRWriteResGroup135_SPRWriteResGroup142_SPRWriteResGroup414_SPRWriteResGroup252_SPRWriteResGroup463_SPRWriteResGroup469_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteStore_WritePOPCNTLd_WriteCvtI2PDY_WriteCvtI2PSY_ZnWriteCVTPD2PSYr_WriteCvtPD2IY_WriteCvtPS2IY_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDPPDLd_WriteDPPS_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteCvtPD2PSZLd_SPRWriteResGroup47_SPRWriteResGroup299_SPRWriteResGroup266_SPRWriteResGroup498_SPRWriteResGroup500_SPRWriteResGroup473_SPRWriteResGroup300_SPRWriteResGroup218_SPRWriteResGroup269_SPRWriteResGroup281_SPRWriteResGroup304_SPRWriteResGroup311_SPRWriteResGroup328_SPRWriteResGroup341_SPRWriteResGroup382_SPRWriteResGroup393_SPRWriteResGroup397_SPRWriteResGroup408_SPRWriteResGroup411_SPRWriteResGroup475_SPRWriteResGroup493_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64Y_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup14_ADLPWriteResGroup219_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteCMOV_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteVecTest_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteRMW_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SPRWriteResGroup248_SPRWriteResGroup555_SPRWriteResGroup88_SPRWriteResGroup66_SPRWriteResGroup114_SPRWriteResGroup59_SPRWriteResGroup42_SPRWriteResGroup28_SPRWriteResGroup16_SPRWriteResGroup225_SPRWriteResGroup102_SPRWriteResGroup228_SPRWriteResGroup184_SPRWriteResGroup13_SPRWriteResGroup27_SPRWriteResGroup491_SPRWriteResGroup509_SPRWriteResGroup514_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4WriteSHA256MSG1rr_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGN_Zn4WritePACK_Zn4WriteFCmp64_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteDPPSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_WriteCvtPS2IZLd_WritePMULLDZLd_SPRWriteResGroup36_SPRWriteResGroup210_SPRWriteResGroup125_SPRWriteResGroup286_SPRWriteResGroup288_SPRWriteResGroup294_SPRWriteResGroup296_SPRWriteResGroup312_SPRWriteResGroup318_SPRWriteResGroup319_SPRWriteResGroup329_SPRWriteResGroup335_SPRWriteResGroup345_SPRWriteResGroup348_SPRWriteResGroup352_SPRWriteResGroup356_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteJumpLd_WriteADCLd_WriteALULd_WriteFAdd64X_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecExtractSt_WriteVecALUXLd_WriteIMul16Reg_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteStore_WriteVecTestLd_WriteShiftLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_WriteBSR_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteBEXTRLd_WriteBSF_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WritePMULLD_WritePOPCNTLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAddX_WriteAESDecEnc_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFRndZ_SPRWriteResGroup87_SPRWriteResGroup64_SPRWriteResGroup55_SPRWriteResGroup194_SPRWriteResGroup564_SPRWriteResGroup130_SPRWriteResGroup167_SPRWriteResGroup91_SPRWriteResGroup314_SPRWriteResGroup516_SPRWriteResGroup519_SPRWriteResGroup220_SPRWriteResGroup492_SPRWriteResGroup456_SPRWriteResGroup249_SPRWriteResGroup256_SPRWriteResGroup481_SPRWriteResGroup522_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPS2IZ_WriteCvtPH2PSZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WritePCmpEStrMLd_WritePCmpIStrILd_WriteDPPDLd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WriteFDiv64Ld_SPRWriteResGroup168_SPRWriteResGroup85_SPRWriteResGroup51_SPRWriteResGroup495_SPRWriteResGroup457_SPRWriteResGroup83_SPRWriteResGroup84_SPRWriteResGroup346_SPRWriteResGroup349_SPRWriteResGroup357_SPRWriteResGroup525_SPRWriteResGroup529_SPRWriteResGroup540_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_WriteCvtPH2PSZLd_SPRWriteResGroup478_SPRWriteResGroup461_SPRWriteResGroup285_SPRWriteResGroup287_SPRWriteResGroup293_SPRWriteResGroup295_SPRWriteResGroup308_SPRWriteResGroup324_SPRWriteResGroup336_SPRWriteResGroup337_SPRWriteResGroup338_SPRWriteResGroup339_SPRWriteResGroup364_SPRWriteResGroup384_SPRWriteResGroup390_SPRWriteResGroup394_SPRWriteResGroup471_SPRWriteResGroup523_SPRWriteResGroup528_SPRWriteResGroup532_ICXWriteResGroup199_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SPRWriteResGroup503_SPRWriteResGroup48_SPRWriteResGroup270_SPRWriteResGroup301_SPRWriteResGroup325_SPRWriteResGroup553_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WriteFSqrtLd_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_SPRWriteResGroup497_SPRWriteResGroup499_SPRWriteResGroup459_SPRWriteResGroup309_SPRWriteResGroup322_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_WriteFDivLd_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_SPRWriteResGroup49_SPRWriteResGroup302_SPRWriteResGroup326_SPRWriteResGroup526_SPRWriteResGroup530_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteFDiv64YLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WritePCmpIStrI_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFDivXLd_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_SPRWriteResGroup563_SPRWriteResGroup451_SPRWriteResGroup448_SPRWriteResGroup19_SPRWriteResGroup273_SPRWriteResGroup277_SPRWriteResGroup282_SPRWriteResGroup316_SPRWriteResGroup333_SPRWriteResGroup342_SPRWriteResGroup379_SPRWriteResGroup460_SPRWriteResGroup474_SPRWriteResGroup476_SPRWriteResGroup534_SPRWriteResGroup536_ICXWriteResGroup202_ICXWriteGatherEVEX2_SKLWriteResGroup180_WriteFDivLd_WriteFDivYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WritePMULLDLd_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_SPRWriteResGroup166_SPRWriteResGroup496_SPRWriteResGroup276_SPRWriteResGroup280_SPRWriteResGroup315_SPRWriteResGroup331_SPRWriteResGroup355_SPRWriteResGroup363_SPRWriteResGroup381_SPRWriteResGroup445_SPRWriteResGroup447_SPRWriteResGroup466_SPRWriteResGroup468_SPRWriteResGroup487_ICXWriteResGroup190_ICXWriteResGroup187_ICXWriteResGroup188_ICXWriteResGroup189_SKLWriteResGroup170_SKLWriteResGroup169_WriteFHAddLd_WriteFHAddYLd_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup197_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WritePHAddLd_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtPS2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WriteShuffleZLd_WriteFLogicZLd_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVecShiftZLd_SPRWriteResGroup123_SPRWriteResGroup131_SPRWriteResGroup201_SPRWriteResGroup262_SPRWriteResGroup134_SPRWriteResGroup227_SPRWriteResGroup183_SPRWriteResGroup472_SPRWriteResGroup477_SPRWriteResGroup261_SPRWriteResGroup442_SPRWriteResGroup275_SPRWriteResGroup279_SPRWriteResGroup330_SPRWriteResGroup366_SPRWriteResGroup392_SPRWriteResGroup396_SPRWriteResGroup409_SPRWriteResGroup412_SPRWriteResGroup507_SPRWriteResGroup510_SPRWriteResGroup512_SPRWriteResGroup524_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteCvtPS2PDLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMDYm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4WriteVPERMYm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WriteFSqrt64YLd_SPRWriteResGroup226_SPRWriteResGroup274_SPRWriteResGroup278_SPRWriteResGroup305_SPRWriteResGroup353_SPRWriteResGroup380_SPRWriteResGroup391_SPRWriteResGroup395_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup231_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_AtomWrite01_13_WriteBSFLd_WriteBSRLd_WriteCLMulLd_WritePCmpIStrM_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteCvtPS2PDZLd_WriteVecIMulZLd_SPRWriteResGroup122_SPRWriteResGroup35_SPRWriteResGroup11_SPRWriteResGroup229_SPRWriteResGroup233_SPRWriteResGroup4_SPRWriteResGroup480_SPRWriteResGroup332_SPRWriteResGroup458_SPRWriteResGroup7_SPRWriteResGroup94_SPRWriteResGroup238_SPRWriteResGroup307_SPRWriteResGroup359_SPRWriteResGroup360_SPRWriteResGroup462_SPRWriteResGroup490_SPRWriteResGroup527_SPRWriteResGroup531_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_SKLWriteResGroup162_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteCvtPD2PSZLd_WriteFDiv64Z
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145_SPRWriteResGroup154
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148_SPRWriteResGroup157
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149_SPRWriteResGroup158
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165_WriteFSqrt64ZLd_SPRWriteResGroup370_SPRWriteResGroup543
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271_SPRWriteResGroup215_SPRWriteResGroup558
  { 1,  0}, // #34 WriteRMW
  {19,  0}, // #35 WriteRotateCLLd
  { 1,  0}, // #36 WriteRMW
  {24,  0}, // #37 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrILd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162_SPRWriteResGroup118_SPRWriteResGroup450_SPRWriteResGroup242_SPRWriteResGroup306
  { 5,  0}, // #38 WriteLoad
  { 5,  0}, // #39 WriteVecMaskedGatherWriteback
  {507,  0}, // #40 WriteVecStoreNTY
  {542,  0}, // #41 WriteFStoreNTY
  {25,  0}, // #42 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDPPS_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteFDiv64Ld_SPRWriteResGroup34_SPRWriteResGroup50_SPRWriteResGroup454_SPRWriteResGroup327_SPRWriteResGroup539_ICXWriteResGroup233_ICXWriteGatherEVEX16_SKLWriteResGroup202
  {11,  0}, // #43 WriteALULd
  { 1,  0}, // #44 WriteRMW
  {39,  0}, // #45 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFDivX_WriteFSqrt64ZLd_SPRWriteResGroup561_SPRWriteResGroup560_SPRWriteResGroup373_SPRWriteResGroup542
  { 1,  0}, // #46 WriteRMW
  {32,  0}, // #47 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z_SPRWriteResGroup33
  {42,  0}, // #48 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_WriteFDivXLd_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_SPRWriteResGroup211_SPRWriteResGroup567_SPRWriteResGroup572_SPRWriteResGroup574_SPRWriteResGroup569_SPRWriteResGroup570_SPRWriteResGroup571_SPRWriteResGroup573_SPRWriteResGroup548_ICXWriteResGroup254_ICXWriteResGroup255_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #49 ADLPWriteResGroup49_SPRWriteResGroup53
  {75,  0}, // #50 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SPRWriteResGroup65_ICXWriteResGroup263_SKLWriteResGroup220
  {35,  0}, // #51 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteFSqrt64_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SPRWriteResGroup174_SPRWriteResGroup173_SPRWriteResGroup79_SPRWriteResGroup80_SPRWriteResGroup75_SPRWriteResGroup76_SPRWriteResGroup77_SPRWriteResGroup169_SPRWriteResGroup170_SPRWriteResGroup171_SPRWriteResGroup172_SPRWriteResGroup545_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #52 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SPRWriteResGroup70_SPRWriteResGroup71_SPRWriteResGroup117_ICXWriteResGroup260_ICXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #53 ADLPWriteResGroup248_ADLPWriteResGroup246_SPRWriteResGroup387_SPRWriteResGroup385
  {13,  0}, // #54 ADLPWriteResGroup213_ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup215_SPRWriteResGroup217_SPRWriteResGroup559_SPRWriteResGroup197_SPRWriteResGroup221
  { 1,  0}, // #55 WriteRMW
  {65,  0}, // #56 ADLPWriteResGroup90_SPRWriteResGroup100
  {70,  0}, // #57 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd_SPRWriteResGroup116
  {37,  0}, // #58 ADLPWriteResGroup279_WriteFDiv64Ld_SKXWriteResGroup250_SKXWriteResGroup249_SPRWriteResGroup566_SPRWriteResGroup372_ICXWriteResGroup250_ICXWriteResGroup249_SKLWriteResGroup211
  {27,  0}, // #59 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_SPRWriteResGroup45_SPRWriteResGroup433_SPRWriteResGroup434_ICXWriteResGroup239_SKLWriteResGroup206_WriteFSqrt64YLd
  {30,  0}, // #60 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SPRWriteResGroup46_SPRWriteResGroup440_ICXWriteResGroup243_SKLWriteResGroup208
  {41,  0}, // #61 ADLPWriteResGroup281_WriteFSqrtX_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_SPRWriteResGroup568_SPRWriteResGroup377_SPRWriteResGroup544_ICXWriteResGroup253_SKLWriteResGroup213
  {46,  0}, // #62 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {40,  0}, // #63 ADLPWriteResGroup257_WriteFSqrt80_SKXWriteResGroup252_SPRWriteResGroup416_SPRWriteResGroup435_SPRWriteResGroup436_SPRWriteResGroup547_ICXWriteResGroup252_SKLWriteResGroup212
  {62,  0}, // #64 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SPRWriteResGroup63_ICXWriteResGroup258_SKLWriteResGroup217
  {106,  0}, // #65 ADLPWriteResGroup65_SKXWriteResGroup266_SPRWriteResGroup69_ICXWriteResGroup266_SKLWriteResGroup223
  {20,  0}, // #66 ADLPWriteResGroup251_SPRWriteResGroup402_SPRWriteResGroup399
  { 5,  0}, // #67 WriteVecMaskedGatherWriteback
  {29,  0}, // #68 ADLPWriteResGroup250_AtomWrite01_29_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_SPRWriteResGroup398_SPRWriteResGroup405_SPRWriteResGroup439_ICXWriteResGroup242
  { 5,  0}, // #69 WriteVecMaskedGatherWriteback
  {28,  0}, // #70 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_SPRWriteResGroup407_SPRWriteResGroup400_SPRWriteResGroup401_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {30,  0}, // #72 ADLPWriteResGroup252_SPRWriteResGroup403_SPRWriteResGroup406
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {40,  0}, // #74 ADLPWriteResGroup275_SPRWriteResGroup562
  { 1,  0}, // #75 WriteRMW
  {26,  0}, // #76 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd_SPRWriteResGroup38_SPRWriteResGroup310_SPRWriteResGroup323_SPRWriteResGroup453
  {198,  0}, // #77 ADLPWriteResGroup87_SPRWriteResGroup97
  {66,  0}, // #78 ADLPWriteResGroup88_SPRWriteResGroup98
  {71,  0}, // #79 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_SPRWriteResGroup99_SPRWriteResGroup101
  {217,  0}, // #80 ADLPWriteResGroup133_SPRWriteResGroup143
  {181,  0}, // #81 ADLPWriteResGroup136_SPRWriteResGroup146
  {514,  0}, // #82 ADLPWriteResGroup146_SPRWriteResGroup155
  {20,  0}, // #83 ADLPWriteResGroup194_ADLPWriteResGroup196_SPRWriteResGroup198_SPRWriteResGroup200
  { 1,  0}, // #84 WriteRMW
  {1386,  0}, // #85 ADLPWriteResGroup202_SPRWriteResGroup206
  {1381,  0}, // #86 ADLPWriteResGroup204_SPRWriteResGroup208
  {74,  0}, // #87 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_WriteFSqrt64XLd_SKXWriteResGroup262_SPRWriteResGroup386_SPRWriteResGroup388_ICXWriteResGroup262
  {521,  0}, // #88 ADLPWriteResGroup259_SPRWriteResGroup423
  {473,  0}, // #89 ADLPWriteResGroup260_SPRWriteResGroup422
  {494,  0}, // #90 ADLPWriteResGroup261_SPRWriteResGroup427
  {470,  0}, // #91 ADLPWriteResGroup262_SPRWriteResGroup421
  {50,  0}, // #92 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #93 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #94 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #95 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #96 WriteFDivLd_WriteFSqrtLd_WriteFDiv64_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166
  { 1,  0}, // #97 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #98 WriteRMW
  {45,  0}, // #99 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_SPRWriteResGroup551_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #100 AtomWrite01_48
  {55,  0}, // #101 AtomWrite01_55_SPRWriteResGroup550
  {59,  0}, // #102 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #103 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #104 AtomWrite01_77
  {78,  0}, // #105 AtomWrite01_78
  {79,  0}, // #106 AtomWrite01_79
  {92,  0}, // #107 AtomWrite01_92
  {94,  0}, // #108 AtomWrite01_94
  {99,  0}, // #109 AtomWrite01_99
  {121,  0}, // #110 AtomWrite01_121
  {127,  0}, // #111 AtomWrite01_127
  {140,  0}, // #112 AtomWrite01_140_SKXWriteResGroup267_SPRWriteResGroup180_ICXWriteResGroup267
  {141,  0}, // #113 AtomWrite01_141
  {146,  0}, // #114 AtomWrite01_146
  {147,  0}, // #115 AtomWrite01_147
  {168,  0}, // #116 AtomWrite01_168
  {174,  0}, // #117 AtomWrite01_174
  {183,  0}, // #118 AtomWrite01_183
  {202,  0}, // #119 AtomWrite01_202
  {69,  0}, // #120 WriteFDiv64X
  { 4,  0}, // #121 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #122 WriteRMW
  {44,  0}, // #123 WriteFSqrtXLd_WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_ICXWriteResGroup256
  {38,  0}, // #124 WriteFSqrt64Ld_WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_SPRWriteResGroup369_SPRWriteResGroup541
  { 5,  0}, // #125 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #126 WriteRMW
  {90,  0}, // #127 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #128 PdWriteLARrr
  {33,  0}, // #129 WriteAESKeyGenLd_SPRWriteResGroup452_SPRWriteResGroup371
  {80,  0}, // #130 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #131 WriteIMulHLd
  { 8,  0}, // #132 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #133 WriteIMulH
  { 3,  0}, // #134 WriteMULX32_WriteMULX64
  { 6,  0}, // #135 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #136 WriteRMW
  { 8,  0}, // #137 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #138 WriteRMW
  {60,  0}, // #139 BWWriteResGroup197
  {115,  0}, // #140 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #141 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #142 WriteRMW
  {43,  0}, // #143 WriteFDiv64YLd_WriteFDivYLd_SPRWriteResGroup378
  {54,  0}, // #144 WriteFSqrt64Y
  {47,  0}, // #145 WriteFSqrtYLd_HWWriteFBLD_SPRWriteResGroup552
  {11,  0}, // #146 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #147 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #148 JWriteXADDrm_XCHG_Part
  {11,  0}, // #149 JWriteXADDrm_LdSt_Part
  {76,  0}, // #150 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #151 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #152 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #153 WriteRotateLd
  { 1,  0}, // #154 WriteRMW
  {52,  0}, // #155 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #156 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171_SPRWriteResGroup368
  {98,  0}, // #157 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #158 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #159 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #160 HWWriteResGroup177
  {27,  0}, // #161 SPRWriteResGroup404
  { 5,  0}, // #162 WriteVecMaskedGatherWriteback
  {49,  0}, // #163 SPRWriteResGroup375
  {51,  0}, // #164 SPRWriteResGroup376
  {477,  0}, // #165 SPRWriteResGroup420
  {550,  0}, // #166 SPRWriteResGroup424
  {474,  0}, // #167 SPRWriteResGroup425
  {464,  0}, // #168 SPRWriteResGroup426
  {475,  0}, // #169 SPRWriteResGroup428
  {476,  0}, // #170 SPRWriteResGroup429
  {471,  0}, // #171 SPRWriteResGroup430
  {53,  0}, // #172 SPRWriteResGroup549
  { 3,  0}, // #173 WriteIMulH
  { 3,  0}, // #174 WriteMULX32_WriteMULX64
  { 4,  0}, // #175 WriteLoad
  { 8,  0}, // #176 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #177 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #178 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {5,  0,  5}, // #1
  {6,  0,  5}, // #2
  {0,  0,  5}, // #3
  {6,  0,  5}, // #4
  {0,  0,  6}, // #5
  {1,  0,  0}, // #6
  {0,  0,  6}, // #7
  {6,  0,  6}, // #8
  {0,  0,  6}, // #9
  {1,  0,  6}, // #10
  {0,  0,  5}, // #11
  {1,  0,  5}, // #12
  {5,  0,  3}, // #13
  {6,  0,  3}, // #14
  {0,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {1,  0,  3}, // #18
  {5,  0,  4}, // #19
  {6,  0,  4}, // #20
  {0,  0,  4}, // #21
  {6,  0,  4}, // #22
  {0,  0, -10}, // #23
  {1,  0, -10}, // #24
  {0,  0, -6}, // #25
  {1,  0, -6}, // #26
  {5,  0,  3}, // #27
  {6,  0,  3}, // #28
  {7,  0,  3}, // #29
  {8,  0,  3}, // #30
  {0,  0,  7}, // #31
  {0,  0,  7}, // #32
  {6,  0,  7}, // #33
  {0,  0,  7}, // #34
  {1,  0,  7}, // #35
  {0,  0,  8}, // #36
  {0,  0,  8}, // #37
  {6,  0,  8}, // #38
  {0,  0,  8}, // #39
  {1,  0,  8}, // #40
  {0,  0, -1}, // #41
  {1,  0, -1} // #42
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  2, 8,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 14, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 22, 8,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  5, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false, 30, 7,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           3, false, false, false, 18, 4,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false, 10, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 28, 2,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 28, 2,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW")        4, false, false, false, 40, 5,  2, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  2, 8,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        5, false, false, false, 45, 8,  2, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 45, 8,  2, 1,  1, 2}, // #21
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 45, 4,  8, 1,  3, 2}, // #22
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #23
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  3, 1}, // #24
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #25
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #27
  {DBGFIELD("WriteFAddX")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #28
  {DBGFIELD("WriteNop")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #30
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 53, 5,  5, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #32
  {DBGFIELD("WriteFAdd")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 53, 7,  9, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #35
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false,  3, 4, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 74, 6, 11, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 74, 4,  7, 1,  0, 0}, // #38
  {DBGFIELD("WriteAESKeyGenLd")   14, false, false, false, 80, 13,  2, 1,  0, 0}, // #39
  {DBGFIELD("WriteAESKeyGen")     14, false, false, false, 93, 11,  6, 1,  0, 0}, // #40
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #41
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 104, 11,  8, 1,  1, 1}, // #43
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 104, 9,  3, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 104, 11,  8, 1,  0, 0}, // #45
  {DBGFIELD("WriteALULd")         1, false, false, false,  1, 1,  8, 1,  0, 0}, // #46
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #47
  {DBGFIELD("WriteFBlend")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #48
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #49
  {DBGFIELD("WriteFVarBlend")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 115, 4,  6, 1,  0, 0}, // #51
  {DBGFIELD("WriteBLS")           1, false, false, false, 115, 2, 12, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSF")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSR")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 104, 9, 12, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 119, 9,  3, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestRegLd")  10, false, false, false, 128, 11,  8, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTest")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 139, 11,  2, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, false, 150, 13, 13, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 30, 7,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #65
  {DBGFIELD("WriteBZHI")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #66
  {DBGFIELD("WriteLoad")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #67
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 163, 6,  6, 1,  3, 1}, // #68
  {DBGFIELD("WriteCMOV")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #70
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #71
  {DBGFIELD("WriteXCHG")          3, false, false, false, 15, 1, 12, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #73
  {DBGFIELD("WriteFCmp64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #75
  {DBGFIELD("WriteFCmpX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #77
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #79
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #80
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 169, 4,  5, 1,  0, 0}, // #81
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #82
  {DBGFIELD("WriteFComX")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteFCom")          1, false, false, false, 60, 8,  1, 1,  0, 0}, // #84
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #85
  {DBGFIELD("WriteCRC32")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, false, 192, 11,  2, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, false, 192, 11,  2, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 68, 6,  8, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #102
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #105
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #106
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #107
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #109
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #110
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #111
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #112
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #115
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  1, 2}, // #117
  {DBGFIELD("WriteDiv16")         4, false, false, false, 213, 7, 16, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  1, 2}, // #119
  {DBGFIELD("WriteDiv32")         4, false, false, false, 213, 7, 11, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  1, 2}, // #121
  {DBGFIELD("WriteDiv64")         3, false, false, false, 222, 7, 13, 1,  0, 0}, // #122
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  1, 2}, // #123
  {DBGFIELD("WriteDiv8")          3, false, false, false, 222, 7, 20, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #125
  {DBGFIELD("WriteFDiv64X")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #127
  {DBGFIELD("WriteFDivX")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 173, 10, 13, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv")          1, false, false, false,  2, 8,  8, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #131
  {DBGFIELD("WriteFDiv64")        1, false, false, false,  2, 8, 21, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #133
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 231, 8, 16, 1,  5, 1}, // #134
  {DBGFIELD("WriteDPPD")          3, false, false, false, 231, 6, 22, 1,  0, 0}, // #135
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 7, false, false, false, 239, 12, 23, 1,  5, 1}, // #136
  {DBGFIELD("WriteDPPS")          6, false, false, false, 251, 10, 21, 1,  0, 0}, // #137
  {DBGFIELD("WriteStore")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 261, 8, 17, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 269, 10, 14, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #141
  {DBGFIELD("WriteFComLd")        2, false, false, false, 279, 12,  7, 1,  0, 0}, // #142
  {DBGFIELD("WriteEMMS")          10, false, false, false, 291, 8,  9, 1,  0, 0}, // #143
  {DBGFIELD("WriteFLDC")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #144
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #145
  {DBGFIELD("WriteVecIMulX")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #146
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #147
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 304, 10,  2, 1,  5, 1}, // #148
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 314, 8,  3, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  1, 2}, // #150
  {DBGFIELD("WriteIDiv16")        4, false, false, false, 213, 7, 16, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  1, 2}, // #152
  {DBGFIELD("WriteIDiv32")        4, false, false, false, 213, 7, 11, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  1, 2}, // #154
  {DBGFIELD("WriteIDiv64")        3, false, false, false, 222, 7, 13, 1,  0, 0}, // #155
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  1, 2}, // #156
  {DBGFIELD("WriteIDiv8")         3, false, false, false, 222, 7, 20, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 322, 11,  9, 1,  1, 2}, // #158
  {DBGFIELD("WriteIMul16")        4, false, false, false, 322, 9, 10, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #160
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 333, 9, 22, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 333, 7, 14, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 342, 11, 22, 1,  1, 2}, // #164
  {DBGFIELD("WriteIMul32")        3, false, false, false, 342, 9, 14, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #166
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 353, 12, 22, 1,  1, 2}, // #170
  {DBGFIELD("WriteIMul64")        2, false, false, false, 365, 10, 14, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #172
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 2}, // #176
  {DBGFIELD("WriteIMul8")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #177
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #178
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 60, 8,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteShuffle")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 10, 4,  5, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #183
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 385, 10,  6, 1,  0, 0}, // #184
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteFLD1")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteFence")         1, false, false, false, 10, 4, 12, 1,  0, 0}, // #187
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #188
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStore")      2, false, false, false, 37, 3,  2, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false,  2, 8,  5, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 28, 2,  6, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveX")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 37, 3, 25, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMove")       1, false, false, false,  4, 5,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 173, 10, 22, 1,  0, 0}, // #198
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #199
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #200
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #201
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 5,  1, 1,  0, 0}, // #202
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 402, 10,  8, 1,  5, 1}, // #203
  {DBGFIELD("WritePHAdd")         3, false, false, false, 412, 8,  5, 1,  0, 0}, // #204
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 53, 7,  7, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 420, 8, 14, 1,  6, 1}, // #206
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 24, 1,  5, 1}, // #207
  {DBGFIELD("WriteVecIMul")       1, false, false, false,  2, 8, 10, 1,  0, 0}, // #208
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #209
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #210
  {DBGFIELD("WritePSADBW")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #211
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 3, false, false, false, 428, 13,  8, 1,  5, 1}, // #212
  {DBGFIELD("WriteVarShuffle")    2, false, false, false, 441, 11,  5, 1,  0, 0}, // #213
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 375, 10, 22, 1,  0, 0}, // #214
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false,  2, 8,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #216
  {DBGFIELD("WriteVecShift")      1, false, false, false,  2, 8,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFMoveX")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 375, 10,  7, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStore")        2, false, false, false, 37, 3,  2, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false,  2, 8,  5, 1,  0, 0}, // #221
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #222
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 37, 3, 26, 1,  0, 0}, // #223
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #224
  {DBGFIELD("WriteFStoreNT")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #225
  {DBGFIELD("WriteFLoad")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #226
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 452, 10,  8, 1,  5, 1}, // #227
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 420, 8, 14, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #229
  {DBGFIELD("WriteFMul64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #231
  {DBGFIELD("WriteFMulX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #233
  {DBGFIELD("WriteFMul64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #234
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #235
  {DBGFIELD("WriteFMul")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #236
  {DBGFIELD("WriteMULX32Ld")      3, false, false, false, 342, 11, 22, 1,  0, 0}, // #237
  {DBGFIELD("WriteMULX32")        2, false, false, false, 342, 9, 14, 1,  0, 0}, // #238
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 342, 11, 28, 2,  1, 1}, // #239
  {DBGFIELD("WriteIMulH_WriteMULX32") 3, false, false, false, 342, 9, 30, 2,  0, 0}, // #240
  {DBGFIELD("WriteMULX64Ld")      2, false, false, false, 353, 12, 22, 1,  0, 0}, // #241
  {DBGFIELD("WriteMULX64")        1, false, false, false, 365, 10, 14, 1,  0, 0}, // #242
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 353, 12, 28, 2,  1, 1}, // #243
  {DBGFIELD("WriteIMulH_WriteMULX64") 2, false, false, false, 365, 10, 30, 2,  0, 0}, // #244
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 68, 6,  8, 1,  0, 0}, // #245
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 68, 6,  7, 1,  0, 0}, // #246
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #247
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #249
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #250
  {DBGFIELD("WriteVarBlend")      1, false, false, false,  4, 3,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #252
  {DBGFIELD("WriteBlend")         1, false, false, false, 53, 5,  1, 1,  0, 0}, // #253
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #254
  {DBGFIELD("WriteCLMul")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8, false, false, false, 462, 14, 32, 1,  5, 1}, // #256
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 476, 12, 16, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, false, 488, 14, 20, 1,  5, 1}, // #258
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 502, 12, 16, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 32, 1,  5, 1}, // #260
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #261
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 16, 1,  5, 1}, // #262
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #263
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #264
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 524, 7, 22, 1,  5, 1}, // #265
  {DBGFIELD("WritePHAddX")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #266
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 173, 10,  8, 1,  0, 0}, // #267
  {DBGFIELD("WritePHMINPOS")      1, false, false, false,  2, 8, 14, 1,  0, 0}, // #268
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 53, 7,  7, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 13, 1,  5, 1}, // #272
  {DBGFIELD("WritePMULLD")        2, false, false, false, 74, 4,  9, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          3, false, false, false, 18, 4, 20, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 119, 9,  7, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 531, 6, 12, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 428, 13, 22, 1,  5, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        3, false, false, false, 14, 4, 12, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      2, false, false, false, 550, 4, 12, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 173, 10,  8, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 173, 10,  8, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false,  2, 8, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 10, 4,  2, 1,  0, 0}, // #295
  {DBGFIELD("WriteShift")         1, false, false, false, 10, 4,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 74, 6, 11, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRnd")          2, false, false, false, 74, 4,  7, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #299
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 173, 10,  8, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 173, 10,  8, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #303
  {DBGFIELD("WriteFRsqrt")        1, false, false, false,  2, 8, 14, 1,  0, 0}, // #304
  {DBGFIELD("WriteShiftLd_WriteRMW") 4, false, false, false, 554, 8, 33, 2,  0, 0}, // #305
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCL")       2, false, false, false, 550, 4, 12, 1,  0, 0}, // #307
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 10, 4,  2, 1,  1, 1}, // #308
  {DBGFIELD("WriteSETCCStore")    4, false, false, false, 570, 7, 24, 1,  0, 0}, // #309
  {DBGFIELD("WriteSETCC")         2, false, false, false, 550, 4, 12, 1,  0, 0}, // #310
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 577, 13,  2, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmri")        5, false, false, false, 590, 11,  2, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDrrcl")       3, false, false, false, 342, 9, 10, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 173, 10, 37, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 173, 10, 17, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtX")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 173, 10, 18, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 18, 1,  5, 1}, // #319
  {DBGFIELD("WriteFSqrt64")       1, false, false, false,  2, 8, 13, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 173, 10, 17, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #322
  {DBGFIELD("WriteFSqrt")         1, false, false, false,  2, 8,  2, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 601, 9, 23, 1,  0, 0}, // #324
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 610, 11,  2, 1,  0, 0}, // #325
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #327
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMALd")         2, false, false, false, 68, 6,  8, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #330
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #334
  {DBGFIELD("WriteFAddY")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #335
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #338
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #339
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #342
  {DBGFIELD("WriteFLogicY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #343
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #348
  {DBGFIELD("WriteFVarBlendY")    3, false, false, false, 223, 3,  5, 1,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #352
  {DBGFIELD("WriteFBlendY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  7, 2}, // #354
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  7, 2}, // #355
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 375, 10,  8, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #357
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 53, 7, 22, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 60, 8,  5, 1,  0, 0}, // #359
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #361
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #362
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #363
  {DBGFIELD("WriteFCmpY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #367
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, false, 192, 11, 11, 1,  5, 1}, // #378
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, false, 192, 11, 11, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, false, 192, 11, 11, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 626, 7,  2, 1,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 626, 7,  2, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #406
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #407
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #408
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #409
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 23, 1,  5, 1}, // #412
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #416
  {DBGFIELD("WriteFDivY")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #417
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #420
  {DBGFIELD("WriteFMAX")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #422
  {DBGFIELD("WriteFMAY")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #423
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 7, false, false, false, 239, 12, 19, 1,  5, 1}, // #426
  {DBGFIELD("WriteDPPSY")         6, false, false, false, 251, 10, 21, 1,  0, 0}, // #427
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  9, 2}, // #429
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #430
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false,  3, 4, 14, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  7, 2}, // #434
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  7, 2}, // #435
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  7, 2}, // #436
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #437
  {DBGFIELD("WriteFRndY")         2, false, false, false, 74, 4,  7, 1,  0, 0}, // #438
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #439
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #442
  {DBGFIELD("WriteVecIMulY")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #446
  {DBGFIELD("WriteVecALUY")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #447
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 304, 10, 24, 1,  5, 1}, // #450
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 314, 8, 10, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #452
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #453
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 28, 2,  7, 1,  0, 0}, // #454
  {DBGFIELD("WriteFMaskedStore64Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 69, 5, 22, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedStore64") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 69, 5,  7, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedStore32Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #460
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMoveY")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 375, 10, 22, 1,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecMoveY")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 37, 3, 40, 1,  0, 0}, // #473
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 37, 3, 41, 1,  0, 0}, // #474
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 452, 10,  2, 1,  5, 1}, // #475
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 420, 8, 14, 1,  0, 0}, // #476
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #477
  {DBGFIELD("WriteFMul64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #478
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #481
  {DBGFIELD("WriteFMulY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #482
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 68, 6, 22, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #487
  {DBGFIELD("WriteVecLogicY")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #491
  {DBGFIELD("WriteBlendY")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #493
  {DBGFIELD("WriteVarBlendY")     3, false, false, false, 223, 3,  5, 1,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  7, 2}, // #497
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  7, 2}, // #498
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  7, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  9, 2}, // #500
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  7, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  9, 2}, // #502
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 24, 1,  9, 2}, // #503
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6, 24, 1,  9, 2}, // #504
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #506
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  7, 2}, // #508
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  9, 2}, // #509
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 60, 8,  1, 1,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  7, 2}, // #511
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  9, 2}, // #512
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #514
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #515
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 524, 7,  9, 1,  5, 1}, // #518
  {DBGFIELD("WritePHAddY")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 420, 8, 14, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #521
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 69, 5, 22, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore32") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 69, 5,  7, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecMaskedStore64Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecMaskedStore64") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #529
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #530
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #531
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false,  2, 8, 14, 1,  0, 0}, // #532
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 13, 1,  5, 1}, // #533
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 74, 4,  9, 1,  0, 0}, // #534
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  7, 2}, // #537
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  9, 2}, // #538
  {DBGFIELD("WriteVecShiftImmXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #544
  {DBGFIELD("WriteVarVecShift")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #546
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #547
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #551
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #552
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #556
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 183, 9, 14, 1,  0, 0}, // #557
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 428, 13,  2, 1,  5, 1}, // #560
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 441, 11,  3, 1,  0, 0}, // #561
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #562
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  5, 1}, // #563
  {DBGFIELD("WriteFRcpY")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #564
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 173, 10,  2, 1,  0, 0}, // #567
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 74, 6, 16, 1,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #569
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  5, 1}, // #570
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 173, 10,  2, 1,  0, 0}, // #574
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #575
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 173, 10, 42, 1,  0, 0}, // #577
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 37, 1,  5, 1}, // #579
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 42, 1,  5, 1}, // #580
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #583
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #584
  {DBGFIELD("WriteFSqrtY")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 173, 10, 15, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #589
  {DBGFIELD("WriteFTestY")        1, false, false, false,  2, 8, 10, 1,  0, 0}, // #590
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #591
  {DBGFIELD("WriteFTest")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #592
  {DBGFIELD("WriteALULd_WriteRMW") 4, false, false, false, 40, 5, 43, 2,  0, 0}, // #593
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("XAM_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #595
  {DBGFIELD("LD_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #597
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #598
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #599
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 554, 8, 33, 2,  0, 0}, // #600
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #601
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #602
  {DBGFIELD("FCOMPP")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #603
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  2, 8, 12, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 203, 8,  6, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #606
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 269, 8, 22, 1,  0, 0}, // #607
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #608
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #609
  {DBGFIELD("XCH_F")              15, false, false, false, 644, 13, 20, 1,  0, 0}, // #610
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #611
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 173, 10, 24, 1,  0, 0}, // #612
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 68, 6,  8, 1,  0, 0}, // #614
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 68, 6,  8, 1,  5, 1}, // #615
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 657, 9,  7, 1,  0, 1}, // #616
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 657, 9,  7, 1,  6, 1}, // #617
  {DBGFIELD("CVTSI642SSrm")       3, false, false, false, 192, 11,  2, 1,  0, 0}, // #618
  {DBGFIELD("CVTSI642SSrm_Int")   3, false, false, false, 192, 11,  2, 1,  5, 1}, // #619
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #621
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #622
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 76, 2, 12, 1,  0, 0}, // #623
  {DBGFIELD("LFENCE")             1, false, false, false, 10, 4, 12, 1,  0, 0}, // #624
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #625
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 77, 3,  3, 1,  0, 0}, // #626
  {DBGFIELD("POP16r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #627
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 3, false, false, false, 18, 4,  1, 1,  0, 0}, // #628
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 623, 3,  3, 1,  0, 0}, // #629
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #630
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 677, 4,  1, 1,  0, 0}, // #631
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  5, 2,  1, 1,  0, 0}, // #632
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #635
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 37, 3,  2, 1,  0, 0}, // #636
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false,  4, 3,  1, 1,  0, 0}, // #637
  {DBGFIELD("CLD")                2, false, false, false, 45, 4,  5, 1,  0, 0}, // #638
  {DBGFIELD("LDDQUrm")            1, false, false, false, 28, 2,  6, 1,  0, 0}, // #639
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 7, false, false, false, 681, 5,  6, 1,  0, 0}, // #640
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #641
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 9, false, false, false, 686, 8, 45, 2,  0, 0}, // #642
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 524, 5, 12, 1,  0, 0}, // #643
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 2, false, false, false, 115, 4,  3, 1,  0, 0}, // #644
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #645
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 28, 2,  6, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 28, 2,  6, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 69, 5,  7, 1,  5, 1}, // #648
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #649
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 106, 4, 12, 1,  0, 0}, // #650
  {DBGFIELD("LD_F80m")            1, false, false, false, 26, 4,  6, 1,  0, 0}, // #651
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 524, 7, 22, 1,  5, 1}, // #652
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 269, 10, 14, 1,  0, 0}, // #653
  {DBGFIELD("FLDCW16m")           3, false, false, false, 694, 12,  6, 1,  0, 0}, // #654
  {DBGFIELD("ST_FP80m")           2, false, false, false, 677, 4,  1, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 412, 8,  5, 1,  0, 0}, // #656
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 14, 8, 24, 1,  0, 0}, // #657
  {DBGFIELD("INTO")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #658
  {DBGFIELD("XLAT")               3, false, false, false, 77, 3,  6, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #662
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #663
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 706, 12, 14, 1,  0, 0}, // #664
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 402, 10,  8, 1,  5, 1}, // #665
  {DBGFIELD("AAD8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #666
  {DBGFIELD("LOOPE")              11, false, false, false, 718, 9,  5, 1,  0, 0}, // #667
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 677, 4,  1, 1,  0, 0}, // #668
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #669
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 727, 9, 12, 1,  0, 0}, // #670
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #671
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 677, 4,  1, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #674
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #675
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 169, 4,  5, 1,  0, 0}, // #676
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #677
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("AAA_AAS")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #679
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #680
  {DBGFIELD("LOOPNE")             11, false, false, false, 718, 9, 12, 1,  0, 0}, // #681
  {DBGFIELD("PAUSE")              2, false, false, false, 736, 9, 14, 1,  0, 0}, // #682
  {DBGFIELD("CMPXCHG8B")          16, false, false, false, 745, 13, 42, 1,  0, 0}, // #683
  {DBGFIELD("DAA")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #684
  {DBGFIELD("LOOP")               7, false, false, false, 758, 9,  5, 1,  0, 0}, // #685
  {DBGFIELD("DAS")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("AAM8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #687
  {DBGFIELD("STD")                2, false, false, false, 45, 4,  3, 1,  0, 0}, // #688
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 767, 15, 47, 1,  0, 0}, // #689
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #690
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 782, 2, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #692
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #693
  {DBGFIELD("RDTSC_RDTSCP")       21, false, false, false, 784, 12, 48, 1,  0, 0}, // #694
  {DBGFIELD("ENTER")              57, false, false, false, 796, 16, 49, 1,  0, 0}, // #695
  {DBGFIELD("POPF16")             10, false, false, false, 812, 11, 10, 1,  0, 0}, // #696
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("FRNDINT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 823, 10, 15, 1,  0, 0}, // #699
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("FPREM")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #701
  {DBGFIELD("INSB_INSL_INSW")     86, false, false, false, 833, 16, 15, 1,  0, 0}, // #702
  {DBGFIELD("FNINIT")             15, false, false, false, 849, 8, 50, 1,  0, 0}, // #703
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 73, false, false, false, 857, 16, 51, 1,  0, 0}, // #704
  {DBGFIELD("FPREM1")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 73, false, false, false, 873, 16, 51, 1,  0, 0}, // #707
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  83, false, false, false, 889, 16,  4, 1,  0, 0}, // #708
  {DBGFIELD("FSCALE")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RDMSR")              54, false, false, false, 905, 11,  4, 1,  0, 0}, // #710
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #711
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 87, false, false, false, 916, 14, 51, 1,  0, 0}, // #712
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 86, false, false, false, 930, 14, 51, 1,  0, 0}, // #713
  {DBGFIELD("F2XM1")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #714
  {DBGFIELD("CPUID")              26, false, false, false, 944, 15, 13, 1,  0, 0}, // #715
  {DBGFIELD("INT")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("INT3")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXSAVE_FXSAVE64")    110, false, false, false, 959, 16,  4, 1,  0, 0}, // #718
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 975, 15, 52, 1,  0, 0}, // #719
  {DBGFIELD("FYL2X")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FYL2XP1")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FPTAN")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("FPATAN")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("WRMSR")              144, false, false, false, 990, 15,  4, 1,  0, 0}, // #725
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #726
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #727
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 299, 5, 12, 1,  0, 0}, // #728
  {DBGFIELD("FNOP")               1, false, false, false,  4, 5,  1, 1,  0, 0}, // #729
  {DBGFIELD("RET64")              2, false, false, false, 163, 6,  6, 1,  0, 0}, // #730
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 10, 4,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false,  4, 5,  1, 1,  0, 0}, // #733
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #734
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 623, 3,  3, 1,  0, 0}, // #735
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false,  2, 8,  5, 1,  0, 0}, // #736
  {DBGFIELD("CWD")                2, false, false, false, 45, 4, 12, 1,  0, 0}, // #737
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1005, 8,  5, 1,  0, 0}, // #738
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 184, 5,  5, 1,  0, 0}, // #739
  {DBGFIELD("PUSHFS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #740
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 441, 11, 14, 1,  0, 0}, // #741
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #742
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #743
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #744
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOV64sr")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 1013, 9, 22, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                3, false, false, false, 1022, 9,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 706, 12, 14, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      2, false, false, false, 37, 3,  5, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 1031, 11,  2, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 4, false, false, false, 1042, 4,  6, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 261, 8,  2, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, false, 1046, 12, 14, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 3, false, false, false, 629, 4, 12, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 173, 10, 22, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 375, 10, 22, 1,  5, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        3, false, false, false, 77, 3, 10, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 69, 5, 22, 1,  5, 1}, // #770
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 395, 7, 22, 1,  5, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        34, false, false, false, 1058, 13, 53, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1071, 9,  3, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1080, 12,  5, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 2, false, false, false, 333, 7,  3, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 7, false, false, false, 1092, 3,  3, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1095, 5, 54, 2,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1100, 11,  6, 1,  0, 0}, // #782
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 26, 4,  6, 1,  0, 0}, // #783
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #784
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 1111, 8,  2, 1, 11, 2}, // #785
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #786
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #787
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 1119, 12,  8, 1,  0, 0}, // #788
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 1131, 12,  8, 1,  0, 0}, // #789
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 1119, 12, 24, 1,  0, 0}, // #790
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 1143, 15, 21, 1,  0, 0}, // #791
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 1131, 12, 19, 1,  0, 0}, // #792
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 1143, 15, 42, 1,  0, 0}, // #793
  {DBGFIELD("VZEROALL")           10, false, false, false, 1158, 9, 16, 1,  0, 0}, // #794
  {DBGFIELD("VZEROUPPER")         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #795
  {DBGFIELD("CLC")                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #796
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #797
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #798
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #799
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #800
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #801
  {DBGFIELD("PSUBQrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #802
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #803
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #804
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 2, false, false, false, 163, 6,  6, 1,  3, 1}, // #805
  {DBGFIELD("SETCCr")             2, false, false, false, 550, 4, 12, 1,  0, 0}, // #806
  {DBGFIELD("SETCCm")             4, false, false, false, 570, 7, 24, 1,  0, 0}, // #807
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #808
  {DBGFIELD("RETI16_RETI32_RETI64") 3, false, false, false, 1167, 6,  3, 1,  0, 0}, // #809
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #810
  {DBGFIELD("RDPMC")              18, false, false, false, 1173, 11,  4, 1,  0, 0}, // #811
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 25, false, false, false, 1184, 14,  4, 1,  0, 0}, // #812
  {DBGFIELD("FBLDm")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  5, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("FSAVEm")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FRSTORm")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FXTRACT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #818
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 28, 2,  7, 1,  0, 0}, // #819
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 28, 2,  7, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #821
  {DBGFIELD("FBSTPm")             2, false, false, false, 677, 4,  1, 1,  0, 0}, // #822
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 677, 4,  1, 1,  0, 0}, // #823
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 677, 4,  1, 1,  0, 0}, // #824
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #826
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 269, 8,  5, 1,  0, 0}, // #827
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #828
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 5,  1, 1,  0, 0}, // #829
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 115, 2, 12, 1,  0, 0}, // #830
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #831
  {DBGFIELD("VPBLENDDrri")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #832
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 7, false, false, false, 1198, 10, 23, 1,  0, 0}, // #833
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #834
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #835
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #836
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #837
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #838
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1071, 9,  3, 1,  0, 0}, // #839
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 115, 4,  6, 1,  3, 1}, // #840
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 3, false, false, false, 104, 11,  6, 1,  0, 0}, // #841
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 69, 5, 22, 1,  5, 1}, // #842
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 69, 5,  7, 1,  5, 1}, // #843
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 69, 5, 22, 1,  5, 1}, // #844
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 28, 2, 10, 1,  0, 0}, // #845
  {DBGFIELD("SFENCE")             2, false, false, false, 37, 3, 12, 1,  0, 0}, // #846
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1208, 7,  2, 1,  0, 0}, // #848
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #849
  {DBGFIELD("MFENCE")             2, false, false, false, 37, 3,  5, 1,  0, 0}, // #850
  {DBGFIELD("XGETBV")             23, false, false, false, 1215, 9, 14, 1,  0, 0}, // #851
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 1224, 10,  2, 1,  5, 1}, // #852
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 163, 6,  3, 1,  0, 0}, // #853
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 550, 4,  1, 1,  0, 0}, // #854
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #855
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #856
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #857
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 2, false, false, false, 1234, 8, 14, 1,  0, 0}, // #858
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 629, 4,  5, 1,  0, 0}, // #859
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #860
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #861
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 22, false, false, false, 1242, 14, 56, 1,  0, 0}, // #862
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 13, false, false, false, 1256, 14, 57, 1,  0, 0}, // #863
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #864
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 375, 10,  8, 1,  5, 1}, // #865
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 657, 9,  7, 1,  6, 1}, // #866
  {DBGFIELD("STR16r_STR32r_STR64r") 2, false, false, false, 333, 7, 10, 1,  0, 0}, // #867
  {DBGFIELD("XSETBV")             54, false, false, false, 1270, 11, 10, 1,  0, 0}, // #868
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #869
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 537, 9,  7, 1,  0, 0}, // #870
  {DBGFIELD("RCL8rCL")            9, false, false, false, 1281, 9,  6, 1,  0, 0}, // #871
  {DBGFIELD("RDTSC")              15, false, false, false, 1290, 11, 13, 1,  0, 0}, // #872
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1301, 14, 58, 1,  0, 0}, // #873
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 1131, 12, 59, 1,  0, 0}, // #875
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 1143, 15, 60, 1,  0, 0}, // #876
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #877
  {DBGFIELD("XSAVE64")            140, false, false, false, 1315, 15, 61, 1,  0, 0}, // #878
  {DBGFIELD("XSAVE")              140, false, false, false, 1315, 15, 48, 1,  0, 0}, // #879
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 156, false, false, false, 1330, 15, 62, 1,  0, 0}, // #880
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1345, 18, 63, 1,  0, 0}, // #881
  {DBGFIELD("FLDENVm")            64, false, false, false, 1363, 12, 64, 1,  0, 0}, // #882
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1375, 15, 52, 1,  0, 0}, // #883
  {DBGFIELD("FSTENVm")            100, false, false, false, 1390, 17, 65, 1,  0, 0}, // #884
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #885
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #886
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8, false, false, false, 1419, 12, 70, 2,  0, 0}, // #887
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 12, false, false, false, 1431, 12, 72, 2,  0, 0}, // #888
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #890
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #891
  {DBGFIELD("VPXORYrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #892
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #893
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #894
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #895
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #896
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 279, 12,  7, 1,  0, 0}, // #897
  {DBGFIELD("LRET64")             3, false, false, false, 1443, 9,  6, 1,  0, 0}, // #898
  {DBGFIELD("POPF64")             7, false, false, false, 1452, 11, 10, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #900
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  3, 4,  1, 1,  0, 0}, // #901
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #902
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 68, 6,  7, 1,  5, 1}, // #903
  {DBGFIELD("PCMPGTQrm")          2, false, false, false, 375, 10,  9, 1,  5, 1}, // #904
  {DBGFIELD("MOV16rm")            2, false, false, false, 71, 3,  3, 1,  0, 0}, // #905
  {DBGFIELD("POP16rmm")           3, false, false, false, 18, 4,  2, 1,  0, 0}, // #906
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #907
  {DBGFIELD("PUSHF16")            4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #908
  {DBGFIELD("LAHF")               1, false, false, false, 10, 4,  5, 1,  0, 0}, // #909
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #910
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #911
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 5, false, false, false, 45, 8,  2, 1,  0, 0}, // #912
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #913
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, false, 1208, 7,  5, 1,  0, 0}, // #914
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #915
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #916
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #917
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #918
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #919
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #920
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #921
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #922
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #923
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 4, false, false, false, 1463, 11,  2, 1,  0, 0}, // #924
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 677, 4,  1, 1,  0, 0}, // #925
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 677, 4,  1, 1,  0, 0}, // #926
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 69, 5, 22, 1,  0, 0}, // #927
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 69, 5,  7, 1,  0, 0}, // #928
  {DBGFIELD("VPMASKMOVDYmr")      3, false, false, false, 633, 11, 21, 1,  0, 0}, // #929
  {DBGFIELD("VPMASKMOVDmr")       3, false, false, false, 633, 11, 21, 1,  0, 0}, // #930
  {DBGFIELD("VPMASKMOVQYmr")      3, false, false, false, 633, 11, 21, 1,  0, 0}, // #931
  {DBGFIELD("VPMASKMOVQmr")       3, false, false, false, 633, 11, 21, 1,  0, 0}, // #932
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #933
  {DBGFIELD("VPGATHERDDYrm")      12, false, false, false, 1431, 12, 72, 2,  0, 0}, // #934
  {DBGFIELD("VPGATHERDDrm")       8, false, false, false, 1419, 12, 70, 2,  0, 0}, // #935
  {DBGFIELD("VPGATHERDQYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #936
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #937
  {DBGFIELD("VPGATHERQDYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #938
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #939
  {DBGFIELD("VPGATHERQQYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #940
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #941
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #942
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #943
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #944
  {DBGFIELD("VPERM2I128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #945
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #946
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #947
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #948
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #949
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #950
  {DBGFIELD("VINSERTI128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #951
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #952
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 183, 9,  6, 1,  0, 0}, // #953
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #954
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #955
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #956
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #957
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 183, 9,  3, 1,  0, 0}, // #958
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #959
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #960
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #961
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #962
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #963
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #964
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #965
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #966
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #967
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #968
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #969
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #970
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #971
  {DBGFIELD("SHA256MSG2rm")       3, false, false, false, 1224, 10, 24, 1,  5, 1}, // #972
  {DBGFIELD("SHA256MSG2rr")       2, false, false, false, 1234, 8,  3, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 7, false, false, false, 1474, 10, 10, 1,  0, 0}, // #974
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 8, false, false, false, 1484, 12,  2, 1,  5, 1}, // #975
  {DBGFIELD("SHA1MSG2rr")         7, false, false, false, 1496, 8,  3, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG2rm")         8, false, false, false, 1504, 10, 24, 1,  5, 1}, // #977
  {DBGFIELD("SHA1NEXTErr")        3, false, false, false, 1514, 6,  5, 1,  0, 0}, // #978
  {DBGFIELD("SHA1NEXTErm")        4, false, false, false, 1520, 8,  7, 1,  5, 1}, // #979
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 60, 8,  3, 1,  0, 0}, // #980
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 375, 10, 24, 1,  5, 1}, // #981
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 60, 8,  3, 1,  0, 0}, // #982
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 375, 10, 24, 1,  5, 1}, // #983
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #984
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #985
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #986
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #987
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #988
  {DBGFIELD("MOVBE16rm")          3, false, false, false, 1528, 6,  6, 1,  0, 0}, // #989
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #990
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #991
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #992
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 1111, 8, 24, 1, 11, 2}, // #993
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 30, 7,  1, 1,  0, 0}, // #994
  {DBGFIELD("LEA16r")             2, false, false, false, 333, 7, 12, 1,  0, 0}, // #995
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 14, 8,  2, 1,  0, 0}, // #996
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 14, 8,  2, 1,  0, 0}, // #997
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #998
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 1534, 8, 74, 2,  0, 0}, // #999
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1000
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1001
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1002
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1003
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1004
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_MOVQ2FR64rr")    2, false, false, false, 269, 8,  5, 1,  0, 0}, // #1007
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1008
  {DBGFIELD("EXTRQ")              1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1009
  {DBGFIELD("INSERTQ")            1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1010
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1011
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1012
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1013
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 192, 11, 37, 1,  0, 0}, // #1014
  {DBGFIELD("SHA1MSG1rr")         2, false, false, false, 184, 8, 12, 1,  0, 0}, // #1015
  {DBGFIELD("SHA1MSG1rm")         3, false, false, false, 193, 10, 22, 1,  5, 1}, // #1016
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1017
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1018
  {DBGFIELD("VPERMQYri")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1019
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1020
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1021
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1022
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1028
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1029
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1030
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VPANDNYrr")          1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1032
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1033
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1034
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1035
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1036
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1037
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1041
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1042
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1043
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1044
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1045
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1046
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1047
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1048
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1049
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1051
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1052
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1054
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1055
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1057
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1058
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 531, 6, 12, 1,  0, 0}, // #1060
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 2, false, false, false, 183, 9, 14, 1,  0, 0}, // #1061
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1063
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1072
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1073
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VFMSUB231SSZr_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1075
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1076
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1080
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1082
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1083
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1085
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1086
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1087
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1088
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1089
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1090
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1092
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1100
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1101
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1105
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1108
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1109
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1111
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1112
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VPERMI2PD128rr_VPERMI2PD128rrk_VPERMI2PD128rrkz_VPERMI2PS128rr_VPERMI2PS128rrk_VPERMI2PS128rrkz_VPERMT2PD128rr_VPERMT2PD128rrk_VPERMT2PD128rrkz_VPERMT2PS128rr_VPERMT2PS128rrk_VPERMT2PS128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMI2B128rr_VPERMI2B128rrk_VPERMI2B128rrkz_VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2B128rr_VPERMT2B128rrk_VPERMT2B128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1116
  {DBGFIELD("VPERMI2PD256rr_VPERMI2PD256rrk_VPERMI2PD256rrkz_VPERMI2PS256rr_VPERMI2PS256rrk_VPERMI2PS256rrkz_VPERMT2PD256rr_VPERMT2PD256rrk_VPERMT2PD256rrkz_VPERMT2PS256rr_VPERMT2PS256rrk_VPERMT2PS256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1117
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2B256rr_VPERMI2B256rrk_VPERMI2B256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2B256rr_VPERMT2B256rrk_VPERMT2B256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1118
  {DBGFIELD("VPERMI2PDrr_VPERMI2PDrrk_VPERMI2PDrrkz_VPERMI2PSrr_VPERMI2PSrrk_VPERMI2PSrrkz_VPERMT2PDrr_VPERMT2PDrrk_VPERMT2PDrrkz_VPERMT2PSrr_VPERMT2PSrrk_VPERMT2PSrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1119
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2Brr_VPERMI2Brrk_VPERMI2Brrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Brr_VPERMT2Brrk_VPERMT2Brrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1120
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1121
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 15, false, false, false, 1542, 14, 52, 1,  0, 0}, // #1122
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #1123
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1124
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false,  1, 1,  8, 1,  0, 0}, // #1125
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1126
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1127
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1128
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1129
  {DBGFIELD("SAHF")               2, false, false, false, 550, 4, 14, 1,  0, 0}, // #1130
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 104, 9,  3, 1,  0, 0}, // #1131
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 104, 11,  8, 1,  0, 0}, // #1132
  {DBGFIELD("RCR8ri")             3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1133
  {DBGFIELD("RCL16rCL")           7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1134
  {DBGFIELD("RCR16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1135
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1136
  {DBGFIELD("RCL16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1137
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1138
  {DBGFIELD("SHLD16rrCL")         3, false, false, false, 342, 9, 10, 1,  0, 0}, // #1139
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1140
  {DBGFIELD("TST_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #1141
  {DBGFIELD("VDPPSrri")           6, false, false, false, 251, 10, 21, 1,  0, 0}, // #1142
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1143
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1144
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #1145
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1146
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #1147
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 183, 9,  7, 1,  0, 0}, // #1148
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 183, 9,  6, 1,  0, 1}, // #1149
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1150
  {DBGFIELD("MOVDQArr")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1151
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 74, 4,  9, 1,  0, 0}, // #1152
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1153
  {DBGFIELD("VPPERMrrm")          2, false, false, false, 53, 7,  7, 1,  9, 2}, // #1154
  {DBGFIELD("VPPERMrmr")          2, false, false, false, 53, 7,  7, 1,  7, 2}, // #1155
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 524, 5, 12, 1,  0, 0}, // #1156
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 524, 7, 22, 1,  5, 1}, // #1157
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1158
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1159
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1160
  {DBGFIELD("PANDNrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1161
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1162
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1163
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 169, 4,  5, 1,  0, 0}, // #1164
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1165
  {DBGFIELD("XCHG8rr")            3, false, false, false, 15, 1, 12, 1,  0, 0}, // #1166
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1167
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1168
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1169
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1170
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1171
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1172
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1173
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1174
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1556, 11,  5, 1,  0, 0}, // #1175
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1567, 6, 12, 1,  0, 0}, // #1176
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 1567, 6, 12, 1,  0, 0}, // #1177
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #1178
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1179
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #1181
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #1182
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1573, 13,  8, 1,  5, 1}, // #1183
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1586, 8, 22, 1,  5, 1}, // #1184
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 1586, 8,  9, 1,  5, 1}, // #1185
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 186, false, false, false, 1594, 15, 48, 1,  0, 0}, // #1186
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1187
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1188
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1189
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1190
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1191
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1192
  {DBGFIELD("VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1193
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1194
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1196
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1197
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1200
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1201
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1202
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1204
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1206
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1207
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1208
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1211
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1222
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1223
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1224
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1225
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1230
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1231
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1232
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1233
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 626, 7,  2, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 626, 7,  2, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1239
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1240
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1241
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1242
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1243
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1244
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1245
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1246
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1247
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1248
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1249
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1250
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1251
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1258
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1259
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1260
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1261
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1262
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1263
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1264
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1265
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1266
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1267
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1268
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #1269
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1270
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1271
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1272
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1273
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1274
  {DBGFIELD("VSCATTERDPSZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1275
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1276
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1277
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #1278
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1280
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1281
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1282
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1283
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1284
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1285
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1286
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1288
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1289
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #1291
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1292
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1293
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1294
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1295
  {DBGFIELD("VPSCATTERDDZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1296
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1297
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1298
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1299
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1300
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1301
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1302
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1303
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1304
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1305
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1306
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1307
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1308
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1309
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1311
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1313
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1314
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #1315
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1317
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1318
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1319
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1320
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1321
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1322
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1323
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1324
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1325
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1326
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1327
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1329
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1331
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1333
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1335
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1337
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1339
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1340
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1341
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1342
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1343
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1344
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1346
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1347
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1348
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1350
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1351
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1352
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1355
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1356
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1357
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1358
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1360
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1361
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1362
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1363
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1364
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1365
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1367
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1370
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1371
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1373
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1374
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1376
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1377
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1379
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1380
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1381
  {DBGFIELD("VPALIGNRYrri")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1382
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1383
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1384
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1385
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1386
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1387
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1388
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1389
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1390
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1391
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1392
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1393
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1394
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1395
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1396
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 3, false, false, false, 1609, 8,  6, 1,  0, 0}, // #1398
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1399
  {DBGFIELD("RET16")              2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1400
  {DBGFIELD("RORX32mi_RORX64mi")  2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1401
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 2, false, false, false, 163, 6,  3, 1, 11, 2}, // #1402
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 5, false, false, false, 45, 8, 24, 1,  0, 0}, // #1403
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1404
  {DBGFIELD("MOV8rm")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1405
  {DBGFIELD("POP16rmr_POP32rmr")  2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1406
  {DBGFIELD("POP32r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1407
  {DBGFIELD("CMP64mi32")          2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1408
  {DBGFIELD("MOV8rm_NOREX")       2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1409
  {DBGFIELD("MOVZX16rm8")         2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1410
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 2, false, false, false, 71, 3,  3, 1,  3, 1}, // #1411
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 2, false, false, false, 71, 3,  3, 1,  3, 1}, // #1412
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1413
  {DBGFIELD("MOV64rr_MOV64rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1414
  {DBGFIELD("JMP_2")              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1415
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1416
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1417
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1418
  {DBGFIELD("ADD8mr")             4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1419
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1420
  {DBGFIELD("SUB8mr")             4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1421
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1422
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1423
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1424
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1425
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1426
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1427
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1428
  {DBGFIELD("TEST64mi32")         2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1429
  {DBGFIELD("OR64rm_XOR64rm")     2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1430
  {DBGFIELD("AND64rm")            2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1431
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1432
  {DBGFIELD("BT64mr")             9, false, false, false, 1617, 11,  9, 1,  0, 0}, // #1433
  {DBGFIELD("BT64rr")             1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1434
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1435
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 10, false, false, false, 1628, 13, 20, 1,  0, 0}, // #1436
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #1437
  {DBGFIELD("CALL64r_CALL64r_NT") 3, false, false, false, 1208, 7,  5, 1,  0, 0}, // #1438
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1439
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1440
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1441
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1442
  {DBGFIELD("CLFLUSH")            4, false, false, false, 1641, 7, 12, 1,  0, 0}, // #1443
  {DBGFIELD("CLTS")               10, false, false, false, 1648, 11,  4, 1,  0, 0}, // #1444
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 3, false, false, false, 629, 4, 10, 1,  0, 0}, // #1445
  {DBGFIELD("CLWB")               3, false, false, false, 629, 4, 10, 1,  0, 0}, // #1446
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 3, false, false, false, 203, 10, 76, 1,  0, 0}, // #1447
  {DBGFIELD("VCVTTSD2SIrm_Int")   3, false, false, false, 203, 10, 76, 1,  0, 0}, // #1448
  {DBGFIELD("VCVTSI642SSrm_Int")  3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1449
  {DBGFIELD("VCVTSI642SSrm")      3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1450
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 657, 9,  7, 1,  6, 1}, // #1451
  {DBGFIELD("JECXZ_JRCXZ")        2, false, false, false, 45, 4, 12, 1,  0, 0}, // #1452
  {DBGFIELD("ST_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1453
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1454
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1455
  {DBGFIELD("SYSCALL")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1456
  {DBGFIELD("DEC32r_alt")         1, false, false, false, 554, 8,  6, 1,  0, 0}, // #1457
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #1458
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #1459
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #1460
  {DBGFIELD("SMSW16m")            3, false, false, false, 1031, 11,  2, 1,  0, 0}, // #1461
  {DBGFIELD("MMX_PEXTRWrr")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #1462
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1463
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1464
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1465
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1466
  {DBGFIELD("VGF2P8MULBYrm")      2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1467
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1468
  {DBGFIELD("VGF2P8MULBYrr")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1469
  {DBGFIELD("IN16ri")             87, false, false, false, 1659, 14, 51, 1,  0, 0}, // #1470
  {DBGFIELD("IN16rr")             87, false, false, false, 1673, 14, 51, 1,  0, 0}, // #1471
  {DBGFIELD("IN32ri")             94, false, false, false, 1687, 14, 51, 1,  0, 0}, // #1472
  {DBGFIELD("IN32rr")             99, false, false, false, 1701, 14,  1, 1,  0, 0}, // #1473
  {DBGFIELD("INC16r_alt")         4, false, false, false, 10, 4,  1, 1,  0, 0}, // #1474
  {DBGFIELD("INC32r_alt")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1475
  {DBGFIELD("INSB")               83, false, false, false, 1715, 16, 15, 1,  0, 0}, // #1476
  {DBGFIELD("INSL")               92, false, false, false, 1731, 16, 15, 1,  0, 0}, // #1477
  {DBGFIELD("INVLPG")             42, false, false, false, 1747, 15,  4, 1,  0, 0}, // #1478
  {DBGFIELD("JMP64r_REX")         1, false, false, false, 1762, 5,  1, 1,  0, 0}, // #1479
  {DBGFIELD("JMP_1_JMP_4")        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1480
  {DBGFIELD("LAR16rm")            81, false, false, false, 1767, 14, 77, 1,  0, 0}, // #1481
  {DBGFIELD("LAR16rr")            22, false, false, false, 1242, 14, 78, 1,  0, 0}, // #1482
  {DBGFIELD("LAR32rm")            85, false, false, false, 1781, 14, 79, 1,  0, 0}, // #1483
  {DBGFIELD("LAR64rm")            87, false, false, false, 1781, 14, 79, 1,  0, 0}, // #1484
  {DBGFIELD("LEAVE")              4, false, false, false, 623, 3,  3, 1,  0, 0}, // #1485
  {DBGFIELD("LGDT64m")            14, false, false, false, 1795, 15,  4, 1,  0, 0}, // #1486
  {DBGFIELD("LIDT64m")            14, false, false, false, 1810, 14,  4, 1,  0, 0}, // #1487
  {DBGFIELD("LLDT16m")            12, false, false, false, 1824, 13,  4, 1,  0, 0}, // #1488
  {DBGFIELD("LLDT16r")            11, false, false, false, 1837, 13,  4, 1,  0, 0}, // #1489
  {DBGFIELD("LMSW16m")            27, false, false, false, 1850, 16,  4, 1,  0, 0}, // #1490
  {DBGFIELD("LMSW16r")            22, false, false, false, 1866, 14,  4, 1,  0, 0}, // #1491
  {DBGFIELD("MMX_MOVD64mr")       2, false, false, false, 37, 3, 13, 1,  0, 0}, // #1492
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1493
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1494
  {DBGFIELD("MMX_MOVFR642Qrr")    2, false, false, false, 184, 5,  5, 1,  0, 0}, // #1495
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 3, false, false, false, 1224, 10,  2, 1,  5, 1}, // #1496
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 2, false, false, false, 1234, 8, 14, 1,  0, 0}, // #1497
  {DBGFIELD("MMX_PINSRWrr")       2, false, false, false, 1234, 8, 14, 1,  6, 1}, // #1498
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #1499
  {DBGFIELD("MMX_PINSRWrm")       2, false, false, false, 375, 10, 22, 1,  3, 1}, // #1500
  {DBGFIELD("VPALIGNRYrmi")       2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1501
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 2, false, false, false, 71, 3, 10, 1,  0, 0}, // #1502
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1503
  {DBGFIELD("MOV16ms")            3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1504
  {DBGFIELD("MOVBE32mr")          3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1505
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1506
  {DBGFIELD("SLDT16r")            2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1507
  {DBGFIELD("STR16r")             2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1508
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1509
  {DBGFIELD("MOV64ao64")          1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1510
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 3, false, false, false, 629, 4,  1, 1,  0, 0}, // #1511
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1512
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1513
  {DBGFIELD("MOV64ao32")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1514
  {DBGFIELD("MOV64dr")            48, false, false, false, 1880, 14, 80, 1,  0, 0}, // #1515
  {DBGFIELD("MOV64o32a")          2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1516
  {DBGFIELD("MOV64rc")            3, false, false, false, 1894, 9,  4, 1,  0, 0}, // #1517
  {DBGFIELD("MOV64rd")            24, false, false, false, 1903, 11, 81, 1,  0, 0}, // #1518
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 2, false, false, false, 71, 3,  1, 1,  0, 0}, // #1519
  {DBGFIELD("MOV8mi_MOV8mr")      2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1520
  {DBGFIELD("MOV8mr_NOREX")       2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1521
  {DBGFIELD("MOVBE32rm")          2, false, false, false, 119, 9,  3, 1,  0, 0}, // #1522
  {DBGFIELD("SLDT16m")            4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #1523
  {DBGFIELD("STRm")               4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #1524
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 4, false, false, false, 554, 8,  1, 1,  0, 0}, // #1525
  {DBGFIELD("MOVDIRI32")          2, false, false, false, 37, 3, 25, 1,  0, 0}, // #1526
  {DBGFIELD("MOVDIRI64")          2, false, false, false, 37, 3, 82, 1,  0, 0}, // #1527
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1528
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1529
  {DBGFIELD("MOVNTDQmr")          2, false, false, false, 37, 3, 26, 1,  0, 0}, // #1530
  {DBGFIELD("MOVNTImr")           2, false, false, false, 37, 3, 27, 1,  0, 0}, // #1531
  {DBGFIELD("MOVSB")              7, false, false, false, 681, 5,  7, 1,  0, 0}, // #1532
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1533
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1534
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1535
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1536
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1537
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1538
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1539
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1540
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1541
  {DBGFIELD("OUT16ir")            79, false, false, false, 1914, 16, 51, 1,  0, 0}, // #1542
  {DBGFIELD("OUT16rr")            79, false, false, false, 1930, 16, 51, 1,  0, 0}, // #1543
  {DBGFIELD("OUT32ir")            85, false, false, false, 1946, 16, 51, 1,  0, 0}, // #1544
  {DBGFIELD("OUT32rr")            85, false, false, false, 1962, 16, 51, 1,  0, 0}, // #1545
  {DBGFIELD("OUTSB")              80, false, false, false, 1978, 16,  4, 1,  0, 0}, // #1546
  {DBGFIELD("OUTSL")              89, false, false, false, 1994, 16,  4, 1,  0, 0}, // #1547
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #1548
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1549
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1550
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1551
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 26, 4, 10, 1,  0, 0}, // #1552
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1553
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1554
  {DBGFIELD("PTWRITE64m_PTWRITEm") 4, false, false, false, 2010, 7,  4, 1,  0, 0}, // #1555
  {DBGFIELD("PTWRITE64r")         3, false, false, false, 2017, 5,  4, 1,  0, 0}, // #1556
  {DBGFIELD("PTWRITEr")           4, false, false, false, 2022, 5,  4, 1,  0, 0}, // #1557
  {DBGFIELD("PUSH64r")            2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1558
  {DBGFIELD("PUSH64rmr")          2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1559
  {DBGFIELD("RCL8m1_RCR8m1")      6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1560
  {DBGFIELD("RCL8mi")             6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1561
  {DBGFIELD("RCR8mi")             6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1562
  {DBGFIELD("RCL8mCL")            11, false, false, false, 2027, 13, 83, 2,  0, 0}, // #1563
  {DBGFIELD("RCR8mCL")            12, false, false, false, 2040, 13, 83, 2,  0, 0}, // #1564
  {DBGFIELD("RDPID64")            1, false, false, false, 30, 7,  4, 1,  0, 0}, // #1565
  {DBGFIELD("RDPKRUr")            3, false, false, false, 342, 9,  4, 1,  0, 0}, // #1566
  {DBGFIELD("RDRAND16r")          25, false, false, false, 1184, 14, 85, 1,  0, 0}, // #1567
  {DBGFIELD("RDSEED16r")          25, false, false, false, 2053, 14, 86, 1,  0, 0}, // #1568
  {DBGFIELD("RDSEED32r_RDSEED64r") 25, false, false, false, 2053, 14,  4, 1,  0, 0}, // #1569
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1570
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #1571
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #1572
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, false, 550, 4,  1, 1,  0, 0}, // #1573
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #1574
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 4, false, false, false, 554, 8, 54, 2,  0, 0}, // #1575
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 2, false, false, false, 163, 6,  7, 1,  3, 1}, // #1576
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 10, 4,  5, 1,  0, 0}, // #1577
  {DBGFIELD("SERIALIZE")          7, false, false, false, 2067, 12,  4, 1,  0, 0}, // #1578
  {DBGFIELD("SHRD16mri8")         5, false, false, false, 590, 11, 24, 1,  0, 0}, // #1579
  {DBGFIELD("SMSW16r")            2, false, false, false, 2079, 8,  1, 1,  0, 0}, // #1580
  {DBGFIELD("SMSW32r_SMSW64r")    2, false, false, false, 2079, 8,  4, 1,  0, 0}, // #1581
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 2, false, false, false, 173, 10, 37, 1,  5, 1}, // #1582
  {DBGFIELD("STI")                6, false, false, false, 2087, 9,  4, 1,  0, 0}, // #1583
  {DBGFIELD("STOSB")              4, false, false, false, 1042, 4,  7, 1,  0, 0}, // #1584
  {DBGFIELD("VBLENDVPDrm_VBLENDVPSrm") 4, false, false, false, 621, 5, 22, 1,  9, 2}, // #1585
  {DBGFIELD("VPBLENDVBrm")        4, false, false, false, 621, 5, 22, 1,  9, 2}, // #1586
  {DBGFIELD("VBLENDVPDrr_VBLENDVPSrr") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1587
  {DBGFIELD("VPBLENDVBrr")        3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1588
  {DBGFIELD("VERRm")              31, false, false, false, 2096, 13, 53, 1,  0, 0}, // #1589
  {DBGFIELD("VERRr")              30, false, false, false, 2109, 13, 87, 1,  0, 0}, // #1590
  {DBGFIELD("VERWr")              33, false, false, false, 2122, 13, 87, 1,  0, 0}, // #1591
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 3, false, false, false, 314, 8, 10, 1,  0, 0}, // #1592
  {DBGFIELD("VLDMXCSR")           3, false, false, false, 2135, 10,  6, 1,  0, 0}, // #1593
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false,  2, 8, 10, 1,  0, 0}, // #1594
  {DBGFIELD("VMOVNTDQmr")         2, false, false, false, 37, 3, 88, 1,  0, 0}, // #1595
  {DBGFIELD("VMOVNTPDmr")         2, false, false, false, 37, 3, 89, 1,  0, 0}, // #1596
  {DBGFIELD("VMOVNTPSYmr")        2, false, false, false, 37, 3, 90, 1,  0, 0}, // #1597
  {DBGFIELD("VMOVNTPSmr")         2, false, false, false, 37, 3, 91, 1,  0, 0}, // #1598
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1599
  {DBGFIELD("VPCLMULQDQYrm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1600
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1601
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1602
  {DBGFIELD("WRPKRUr")            8, false, false, false, 2145, 11,  4, 1,  0, 0}, // #1603
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 5, false, false, false, 1095, 5, 33, 2,  0, 0}, // #1604
  {DBGFIELD("XCHG16rm")           8, false, false, false, 1534, 8, 45, 2,  0, 0}, // #1605
  {DBGFIELD("XCHG32rm")           8, false, false, false, 1534, 8, 45, 2,  0, 0}, // #1606
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 31, false, false, false, 1301, 14, 58, 1,  0, 0}, // #1607
  {DBGFIELD("XSAVEC")             151, false, false, false, 2156, 16, 48, 1,  0, 0}, // #1608
  {DBGFIELD("XSAVEC64")           152, false, false, false, 2172, 16, 48, 1,  0, 0}, // #1609
  {DBGFIELD("XSAVEOPT")           155, false, false, false, 2188, 15, 62, 1,  0, 0}, // #1610
  {DBGFIELD("XSAVES")             184, false, false, false, 2203, 15, 48, 1,  0, 0}, // #1611
  {DBGFIELD("VMOVAPDZrr_VMOVAPDZrr_REV_VMOVAPSZrr_VMOVAPSZrr_REV_VMOVUPDZrr_VMOVUPDZrr_REV_VMOVUPSZrr_VMOVUPSZrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1612
  {DBGFIELD("VMOVDQA32Z256rr_VMOVDQA32Z256rr_REV_VMOVDQA64Z256rr_VMOVDQA64Z256rr_REV_VMOVDQAYrr_VMOVDQAYrr_REV_VMOVDQUYrr_VMOVDQUYrr_REV_VMOVDQU16Z256rr_VMOVDQU16Z256rr_REV_VMOVDQU32Z256rr_VMOVDQU32Z256rr_REV_VMOVDQU64Z256rr_VMOVDQU64Z256rr_REV_VMOVDQU8Z256rr_VMOVDQU8Z256rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1613
  {DBGFIELD("VMOVDQA32Zrr_VMOVDQA32Zrr_REV_VMOVDQA64Zrr_VMOVDQA64Zrr_REV_VMOVDQU16Zrr_VMOVDQU16Zrr_REV_VMOVDQU32Zrr_VMOVDQU32Zrr_REV_VMOVDQU64Zrr_VMOVDQU64Zrr_REV_VMOVDQU8Zrr_VMOVDQU8Zrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1614
  {DBGFIELD("ADDPSrm_SUBPSrm_VADDPSrm_VSUBPSrm_ADDSUBPSrm_VADDSUBPSrm_VADDPSZ128rm_VADDPSZ128rmb_VADDPSZ128rmbk_VADDPSZ128rmk_VADDPSZ128rmkz_VSUBPSZ128rm_VSUBPSZ128rmb_VSUBPSZ128rmbk_VSUBPSZ128rmk_VSUBPSZ128rmkz_VADDPSZ128rmbkz_VSUBPSZ128rmbkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #1615
  {DBGFIELD("ADDPSrr_SUBPSrr_VADDPSrr_VSUBPSrr_ADDSUBPSrr_VADDSUBPSrr_VADDPSZ128rr_VADDPSZ128rrk_VSUBPSZ128rr_VSUBPSZ128rrk") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1616
  {DBGFIELD("VADDPSYrr_VSUBPSYrr_VADDPSZ256rr_VADDPSZ256rrk_VSUBPSZ256rr_VSUBPSZ256rrk") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1617
  {DBGFIELD("VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1618
  {DBGFIELD("VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1619
  {DBGFIELD("VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1620
  {DBGFIELD("VPSHUFHWZ128rik_VPSHUFHWZ128rikz_VPSHUFLWZ128rik_VPSHUFLWZ128rikz_VPUNPCKHBWZ128rrk_VPUNPCKHBWZ128rrkz_VPUNPCKHWDZ128rrk_VPUNPCKHWDZ128rrkz_VPUNPCKLBWZ128rrk_VPUNPCKLBWZ128rrkz_VPUNPCKLWDZ128rrk_VPUNPCKLWDZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1621
  {DBGFIELD("VPSHUFHWZ256rik_VPSHUFHWZ256rikz_VPSHUFLWZ256rik_VPSHUFLWZ256rikz_VPUNPCKHBWZ256rrk_VPUNPCKHBWZ256rrkz_VPUNPCKHWDZ256rrk_VPUNPCKHWDZ256rrkz_VPUNPCKLBWZ256rrk_VPUNPCKLBWZ256rrkz_VPUNPCKLWDZ256rrk_VPUNPCKLWDZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1622
  {DBGFIELD("VADDSUBPSYrr")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1623
  {DBGFIELD("VPOPCNTBZ128rm_VPOPCNTDZ128rm_VPOPCNTQZ128rm_VPOPCNTWZ128rm_VPOPCNTDZ128rmb_VPOPCNTDZ128rmk_VPOPCNTDZ128rmkz_VPOPCNTQZ128rmb_VPOPCNTQZ128rmk_VPOPCNTQZ128rmkz_VPOPCNTDZ128rmbk_VPOPCNTDZ128rmbkz_VPOPCNTQZ128rmbk_VPOPCNTQZ128rmbkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1624
  {DBGFIELD("VFPCLASSPDZ128rmb_VFPCLASSPSZ128rmb") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1625
  {DBGFIELD("VFPCLASSPHZ128rmb")  2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1626
  {DBGFIELD("VPACKSSDWZ128rm_VPACKSSWBZ128rm_VPACKUSDWZ128rm_VPACKUSWBZ128rm_VPACKSSDWZ128rmb_VPACKUSDWZ128rmb") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1627
  {DBGFIELD("VPMULTISHIFTQBZ128rm_VPMULTISHIFTQBZ128rmb") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1628
  {DBGFIELD("VFPCLASSPHZ128rm")   2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1629
  {DBGFIELD("VFPCLASSPDZ256rm_VFPCLASSPSZ256rm") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1630
  {DBGFIELD("VFPCLASSPDZrm_VFPCLASSPSZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1631
  {DBGFIELD("VFPCLASSPHZ256rm")   2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1632
  {DBGFIELD("VFPCLASSPHZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1633
  {DBGFIELD("VPERMBZ128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1634
  {DBGFIELD("VPEXPANDBZ128rmk_VPEXPANDBZ128rmkz_VPEXPANDBZ256rmk_VPEXPANDBZ256rmkz_VPEXPANDWZ128rmk_VPEXPANDWZ128rmkz_VPEXPANDWZ256rmk_VPEXPANDWZ256rmkz_VPEXPANDBZrmk_VPEXPANDBZrmkz_VPEXPANDWZrmk_VPEXPANDWZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1635
  {DBGFIELD("ADD_FPrST0_ADD_FrST0_SUBR_FPrST0_SUBR_FrST0_SUB_FPrST0_SUB_FrST0_SUBR_FST0r_SUB_FST0r") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1636
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVWkr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1637
  {DBGFIELD("VCMPPHZ128rri_VCMPPHZ128rrik_VFPCLASSPHZ128rr_VFPCLASSPHZ128rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1638
  {DBGFIELD("VCMPPHZ256rri_VCMPPHZ256rrik_VFPCLASSPHZ256rr_VFPCLASSPHZ256rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1639
  {DBGFIELD("VCMPSHZrr_VCMPSHZrr_Int_VCMPSHZrr_Intk_VCMPSHZrrb_Int_VCMPSHZrrb_Intk_VFPCLASSSHZrr_VFPCLASSSHZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1640
  {DBGFIELD("VPACKSSDWZ128rr_VPACKSSWBZ128rr_VPACKUSDWZ128rr_VPACKUSWBZ128rr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1641
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSWBZ256rr_VPACKUSDWZ256rr_VPACKUSWBZ256rr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1642
  {DBGFIELD("VPALIGNRZ128rrik_VPALIGNRZ128rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1643
  {DBGFIELD("VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1644
  {DBGFIELD("VPBROADCASTBZ128rrk_VPBROADCASTBZ128rrkz_VPBROADCASTWZ128rrk_VPBROADCASTWZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1645
  {DBGFIELD("VPERMBZ128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1646
  {DBGFIELD("VPERMBZ256rr_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1647
  {DBGFIELD("VPERMBZrr_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1648
  {DBGFIELD("VPERMQZrr_VPERMQZrrk_VPERMQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1649
  {DBGFIELD("VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1650
  {DBGFIELD("VPMULTISHIFTQBZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1651
  {DBGFIELD("VPMULTISHIFTQBZ256rr_VPOPCNTBZ256rr_VPOPCNTDZ256rr_VPOPCNTQZ256rr_VPOPCNTWZ256rr_VPOPCNTDZ256rrk_VPOPCNTDZ256rrkz_VPOPCNTQZ256rrk_VPOPCNTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1652
  {DBGFIELD("VPOPCNTBZ128rr_VPOPCNTDZ128rr_VPOPCNTQZ128rr_VPOPCNTWZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1653
  {DBGFIELD("VMOVSHDUPZ128rr_VMOVSHDUPZ128rrk_VMOVSHDUPZ128rrkz_VMOVSLDUPZ128rr_VMOVSLDUPZ128rrk_VMOVSLDUPZ128rrkz_VSHUFPDZ128rri_VSHUFPDZ128rrik_VSHUFPDZ128rrikz_VSHUFPSZ128rri_VSHUFPSZ128rrik_VSHUFPSZ128rrikz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1654
  {DBGFIELD("VMOVSHDUPZ256rr_VMOVSHDUPZ256rrk_VMOVSHDUPZ256rrkz_VMOVSLDUPZ256rr_VMOVSLDUPZ256rrk_VMOVSLDUPZ256rrkz_VSHUFPDZ256rri_VSHUFPDZ256rrik_VSHUFPDZ256rrikz_VSHUFPSZ256rri_VSHUFPSZ256rrik_VSHUFPSZ256rrikz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1655
  {DBGFIELD("VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1656
  {DBGFIELD("VCVTPD2DQZ128rm_VCVTPD2DQZ128rmb_VCVTPD2DQZ128rmbk_VCVTPD2DQZ128rmk_VCVTPD2DQZ128rmkz_VCVTPD2UDQZ128rm_VCVTPD2UDQZ128rmb_VCVTPD2UDQZ128rmbk_VCVTPD2UDQZ128rmk_VCVTPD2UDQZ128rmkz_VCVTTPD2DQZ128rm_VCVTTPD2DQZ128rmb_VCVTTPD2DQZ128rmbk_VCVTTPD2DQZ128rmk_VCVTTPD2DQZ128rmkz_VCVTTPD2UDQZ128rm_VCVTTPD2UDQZ128rmb_VCVTTPD2UDQZ128rmbk_VCVTTPD2UDQZ128rmk_VCVTTPD2UDQZ128rmkz_VCVTPD2DQZ128rmbkz_VCVTPD2UDQZ128rmbkz_VCVTTPD2DQZ128rmbkz_VCVTTPD2UDQZ128rmbkz") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1657
  {DBGFIELD("VCVTPH2PSXZ128rm_VCVTPH2PSXZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1658
  {DBGFIELD("VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz_VCVTQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1659
  {DBGFIELD("VCVTSI642SSZrm_VCVTSI642SSZrm_Int_VCVTUSI642SSZrm_VCVTUSI642SSZrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1660
  {DBGFIELD("VCVTSD2SIZrm_VCVTTSD2SIZrm_VCVTSD2SIZrm_Int_VCVTTSD2SIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1661
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1662
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_Int_VCVTSI2SSZrr_VCVTUSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1663
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #1664
  {DBGFIELD("DIVSDrm_VDIVSDrm")   2, false, false, false, 173, 10, 17, 1,  5, 1}, // #1665
  {DBGFIELD("VDIVSDZrm")          2, false, false, false, 173, 10, 17, 1,  5, 1}, // #1666
  {DBGFIELD("VSQRTSHZm_Int_VSQRTSHZm_Intk_VSQRTSHZm_Intkz") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #1667
  {DBGFIELD("VSQRTSHZm")          2, false, false, false, 173, 10, 17, 1,  5, 1}, // #1668
  {DBGFIELD("ENQCMD16_ENQCMD32_ENQCMD64_ENQCMDS16_ENQCMDS32_ENQCMDS64") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1669
  {DBGFIELD("VPMOVQDZ256mr_VPMOVQDZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1670
  {DBGFIELD("VEXTRACTPSZmr")      3, false, false, false, 261, 8, 17, 1,  0, 0}, // #1671
  {DBGFIELD("VEXTRACTPSZrr")      2, false, false, false, 269, 10, 14, 1,  0, 0}, // #1672
  {DBGFIELD("VPERMWZrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1673
  {DBGFIELD("VPEXPANDBZ256rm_VPEXPANDBZrm_VPEXPANDWZ256rm_VPEXPANDWZrm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1674
  {DBGFIELD("VPADDBZrr_VPADDDZrr_VPADDQZrr_VPADDWZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrrk_VPADDQZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1675
  {DBGFIELD("VPLZCNTDZ256rm_VPLZCNTDZ256rmb_VPLZCNTDZ256rmbk_VPLZCNTDZ256rmk_VPLZCNTDZ256rmkz_VPLZCNTQZ256rm_VPLZCNTQZ256rmb_VPLZCNTQZ256rmbk_VPLZCNTQZ256rmk_VPLZCNTQZ256rmkz_VPLZCNTDZ256rmbkz_VPLZCNTQZ256rmbkz") 2, false, false, false, 68, 6, 24, 1,  0, 0}, // #1676
  {DBGFIELD("VADDPHZ128rm_VADDPHZ128rmb_VADDPHZ128rmbk_VADDPHZ128rmk_VADDPHZ128rmkz_VSUBPHZ128rm_VSUBPHZ128rmb_VSUBPHZ128rmbk_VSUBPHZ128rmk_VSUBPHZ128rmkz_VADDPHZ128rmbkz_VSUBPHZ128rmbkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #1677
  {DBGFIELD("VGETEXPPHZ128m_VGETEXPPHZ128mb_VGETEXPPHZ128mbk_VGETEXPPHZ128mk_VGETEXPPHZ128mkz_VGETEXPSHZm_VGETEXPSHZmk_VGETEXPSHZmkz_VGETMANTPHZ128rmbi_VGETMANTPHZ128rmik_VGETMANTPHZ128rmbik_VGETMANTPHZ128rmbikz_VGETMANTPHZ128rmi_VGETMANTPHZ128rmikz_VGETMANTSHZrmi_VGETMANTSHZrmik_VGETMANTSHZrmikz") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #1678
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbi_VGF2P8AFFINEINVQBZ128rmi_VGF2P8AFFINEQBZ128rmbi_VGF2P8AFFINEQBZ128rmi") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1679
  {DBGFIELD("VMAXCPHZ128rm_VMAXCPHZ128rmb_VMAXCPHZ128rmbk_VMAXCPHZ128rmk_VMAXCPHZ128rmkz_VMINCPHZ128rm_VMINCPHZ128rmb_VMINCPHZ128rmbk_VMINCPHZ128rmk_VMINCPHZ128rmkz_VMAXCPHZ128rmbkz_VMINCPHZ128rmbkz_VMAXPHZ128rm_VMAXPHZ128rmb_VMAXPHZ128rmbk_VMAXPHZ128rmk_VMAXPHZ128rmkz_VMINPHZ128rm_VMINPHZ128rmb_VMINPHZ128rmbk_VMINPHZ128rmk_VMINPHZ128rmkz_VMAXPHZ128rmbkz_VMINPHZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1680
  {DBGFIELD("VMULPHZ128rm_VMULPHZ128rmb_VMULPHZ128rmbk_VMULPHZ128rmk_VMULPHZ128rmkz_VMULPHZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1681
  {DBGFIELD("VGETEXPPHZ128mbkz")  3, false, false, false, 74, 6, 11, 1,  5, 1}, // #1682
  {DBGFIELD("VGF2P8MULBZ128rm")   2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1683
  {DBGFIELD("VADDSHZrm_VSUBSHZrm_VADDSHZrm_Int_VADDSHZrm_Intk_VADDSHZrm_Intkz_VSUBSHZrm_Int_VSUBSHZrm_Intk_VSUBSHZrm_Intkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #1684
  {DBGFIELD("VCVTSH2SSZrm_VCVTSH2SSZrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1685
  {DBGFIELD("VMAXCSHZrm_VMINCSHZrm_VMAXSHZrm_VMINSHZrm_VMAXSHZrm_Int_VMAXSHZrm_Intk_VMAXSHZrm_Intkz_VMINSHZrm_Int_VMINSHZrm_Intk_VMINSHZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1686
  {DBGFIELD("VMULSHZrm_VMULSHZrm_Int_VMULSHZrm_Intk_VMULSHZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1687
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbi_VGF2P8AFFINEINVQBZ256rmi_VGF2P8AFFINEQBZ256rmbi_VGF2P8AFFINEQBZ256rmi") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1688
  {DBGFIELD("VGF2P8MULBZ256rm")   2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1689
  {DBGFIELD("VFMADD132PHZ128m_VFMADD132PHZ128mb_VFMADD132PHZ128mbk_VFMADD132PHZ128mk_VFMADD132PHZ128mkz_VFMADD213PHZ128m_VFMADD213PHZ128mb_VFMADD213PHZ128mbk_VFMADD213PHZ128mk_VFMADD213PHZ128mkz_VFMADD231PHZ128m_VFMADD231PHZ128mb_VFMADD231PHZ128mbk_VFMADD231PHZ128mk_VFMADD231PHZ128mkz_VFMSUB132PHZ128m_VFMSUB132PHZ128mb_VFMSUB132PHZ128mbk_VFMSUB132PHZ128mk_VFMSUB132PHZ128mkz_VFMSUB213PHZ128m_VFMSUB213PHZ128mb_VFMSUB213PHZ128mbk_VFMSUB213PHZ128mk_VFMSUB213PHZ128mkz_VFMSUB231PHZ128m_VFMSUB231PHZ128mb_VFMSUB231PHZ128mbk_VFMSUB231PHZ128mk_VFMSUB231PHZ128mkz_VFNMADD132PHZ128m_VFNMADD132PHZ128mb_VFNMADD132PHZ128mbk_VFNMADD132PHZ128mk_VFNMADD132PHZ128mkz_VFNMADD213PHZ128m_VFNMADD213PHZ128mb_VFNMADD213PHZ128mbk_VFNMADD213PHZ128mk_VFNMADD213PHZ128mkz_VFNMADD231PHZ128m_VFNMADD231PHZ128mb_VFNMADD231PHZ128mbk_VFNMADD231PHZ128mk_VFNMADD231PHZ128mkz_VFNMSUB132PHZ128m_VFNMSUB132PHZ128mb_VFNMSUB132PHZ128mbk_VFNMSUB132PHZ128mk_VFNMSUB132PHZ128mkz_VFNMSUB213PHZ128m_VFNMSUB213PHZ128mb_VFNMSUB213PHZ128mbk_VFNMSUB213PHZ128mk_VFNMSUB213PHZ128mkz_VFNMSUB231PHZ128m_VFNMSUB231PHZ128mb_VFNMSUB231PHZ128mbk_VFNMSUB231PHZ128mk_VFNMSUB231PHZ128mkz_VFMADD132PHZ128mbkz_VFMADD213PHZ128mbkz_VFMADD231PHZ128mbkz_VFMSUB132PHZ128mbkz_VFMSUB213PHZ128mbkz_VFMSUB231PHZ128mbkz_VFNMADD132PHZ128mbkz_VFNMADD213PHZ128mbkz_VFNMADD231PHZ128mbkz_VFNMSUB132PHZ128mbkz_VFNMSUB213PHZ128mbkz_VFNMSUB231PHZ128mbkz_VFMADDSUB132PHZ128m_VFMADDSUB132PHZ128mb_VFMADDSUB132PHZ128mbk_VFMADDSUB132PHZ128mk_VFMADDSUB132PHZ128mkz_VFMADDSUB213PHZ128m_VFMADDSUB213PHZ128mb_VFMADDSUB213PHZ128mbk_VFMADDSUB213PHZ128mk_VFMADDSUB213PHZ128mkz_VFMADDSUB231PHZ128m_VFMADDSUB231PHZ128mb_VFMADDSUB231PHZ128mbk_VFMADDSUB231PHZ128mk_VFMADDSUB231PHZ128mkz_VFMADDSUB132PHZ128mbkz_VFMADDSUB213PHZ128mbkz_VFMADDSUB231PHZ128mbkz_VFMSUBADD132PHZ128m_VFMSUBADD132PHZ128mb_VFMSUBADD132PHZ128mbk_VFMSUBADD132PHZ128mk_VFMSUBADD132PHZ128mkz_VFMSUBADD213PHZ128m_VFMSUBADD213PHZ128mb_VFMSUBADD213PHZ128mbk_VFMSUBADD213PHZ128mk_VFMSUBADD213PHZ128mkz_VFMSUBADD231PHZ128m_VFMSUBADD231PHZ128mb_VFMSUBADD231PHZ128mbk_VFMSUBADD231PHZ128mk_VFMSUBADD231PHZ128mkz_VFMSUBADD132PHZ128mbkz_VFMSUBADD213PHZ128mbkz_VFMSUBADD231PHZ128mbkz") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #1690
  {DBGFIELD("VFMADD132SHZm_VFMADD213SHZm_VFMADD231SHZm_VFMSUB132SHZm_VFMSUB213SHZm_VFMSUB231SHZm_VFNMADD132SHZm_VFNMADD213SHZm_VFNMADD231SHZm_VFNMSUB132SHZm_VFNMSUB213SHZm_VFNMSUB231SHZm_VFMADD132SHZm_Int_VFMADD132SHZm_Intk_VFMADD132SHZm_Intkz_VFMADD213SHZm_Int_VFMADD213SHZm_Intk_VFMADD213SHZm_Intkz_VFMADD231SHZm_Int_VFMADD231SHZm_Intk_VFMADD231SHZm_Intkz_VFMSUB132SHZm_Int_VFMSUB132SHZm_Intk_VFMSUB132SHZm_Intkz_VFMSUB213SHZm_Int_VFMSUB213SHZm_Intk_VFMSUB213SHZm_Intkz_VFMSUB231SHZm_Int_VFMSUB231SHZm_Intk_VFMSUB231SHZm_Intkz_VFNMADD132SHZm_Int_VFNMADD132SHZm_Intk_VFNMADD132SHZm_Intkz_VFNMADD213SHZm_Int_VFNMADD213SHZm_Intk_VFNMADD213SHZm_Intkz_VFNMADD231SHZm_Int_VFNMADD231SHZm_Intk_VFNMADD231SHZm_Intkz_VFNMSUB132SHZm_Int_VFNMSUB132SHZm_Intk_VFNMSUB132SHZm_Intkz_VFNMSUB213SHZm_Int_VFNMSUB213SHZm_Intk_VFNMSUB213SHZm_Intkz_VFNMSUB231SHZm_Int_VFNMSUB231SHZm_Intk_VFNMSUB231SHZm_Intkz") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #1691
  {DBGFIELD("VPMADD52HUQZ256m_VPMADD52HUQZ256mb_VPMADD52HUQZ256mbk_VPMADD52HUQZ256mk_VPMADD52HUQZ256mkz_VPMADD52LUQZ256m_VPMADD52LUQZ256mb_VPMADD52LUQZ256mbk_VPMADD52LUQZ256mk_VPMADD52LUQZ256mkz_VPMADD52HUQZ256mbkz_VPMADD52LUQZ256mbkz") 2, false, false, false, 68, 6, 24, 1,  9, 2}, // #1692
  {DBGFIELD("VADDPHZ128rr_VSUBPHZ128rr") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1693
  {DBGFIELD("VADDPHZ256rr_VSUBPHZ256rr") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1694
  {DBGFIELD("VADDSHZrr_VSUBSHZrr_VADDSHZrr_Int_VADDSHZrrb_Int_VSUBSHZrr_Int_VSUBSHZrrb_Int") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1695
  {DBGFIELD("VCVTPH2UWZ128rr_VCVTPH2WZ128rr_VCVTTPH2UWZ128rr_VCVTTPH2WZ128rr_VCVTUW2PHZ128rr_VCVTW2PHZ128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1696
  {DBGFIELD("VCVTPH2UWZ256rr_VCVTPH2WZ256rr_VCVTTPH2UWZ256rr_VCVTTPH2WZ256rr_VCVTUW2PHZ256rr_VCVTW2PHZ256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1697
  {DBGFIELD("VCVTSH2SSZrr_Int_VCVTSH2SSZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1698
  {DBGFIELD("VFMADD132PHZ128r_VFMADD213PHZ128r_VFMADD231PHZ128r_VFMSUB132PHZ128r_VFMSUB213PHZ128r_VFMSUB231PHZ128r_VFNMADD132PHZ128r_VFNMADD213PHZ128r_VFNMADD231PHZ128r_VFNMSUB132PHZ128r_VFNMSUB213PHZ128r_VFNMSUB231PHZ128r_VFMADDSUB132PHZ128r_VFMADDSUB213PHZ128r_VFMADDSUB231PHZ128r_VFMSUBADD132PHZ128r_VFMSUBADD213PHZ128r_VFMSUBADD231PHZ128r") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1699
  {DBGFIELD("VFMADD132PHZ256r_VFMADD213PHZ256r_VFMADD231PHZ256r_VFMSUB132PHZ256r_VFMSUB213PHZ256r_VFMSUB231PHZ256r_VFNMADD132PHZ256r_VFNMADD213PHZ256r_VFNMADD231PHZ256r_VFNMSUB132PHZ256r_VFNMSUB213PHZ256r_VFNMSUB231PHZ256r_VFMADDSUB132PHZ256r_VFMADDSUB213PHZ256r_VFMADDSUB231PHZ256r_VFMSUBADD132PHZ256r_VFMSUBADD213PHZ256r_VFMSUBADD231PHZ256r") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1700
  {DBGFIELD("VFMADD132SHZr_VFMADD132SHZr_Int_VFMADD132SHZrb_VFMADD132SHZrb_Int_VFMADD213SHZr_VFMADD213SHZr_Int_VFMADD213SHZrb_VFMADD213SHZrb_Int_VFMADD231SHZr_VFMADD231SHZr_Int_VFMADD231SHZrb_VFMADD231SHZrb_Int_VFMSUB132SHZr_VFMSUB132SHZr_Int_VFMSUB132SHZrb_VFMSUB132SHZrb_Int_VFMSUB213SHZr_VFMSUB213SHZr_Int_VFMSUB213SHZrb_VFMSUB213SHZrb_Int_VFMSUB231SHZr_VFMSUB231SHZr_Int_VFMSUB231SHZrb_VFMSUB231SHZrb_Int_VFNMADD132SHZr_VFNMADD132SHZr_Int_VFNMADD132SHZrb_VFNMADD132SHZrb_Int_VFNMADD213SHZr_VFNMADD213SHZr_Int_VFNMADD213SHZrb_VFNMADD213SHZrb_Int_VFNMADD231SHZr_VFNMADD231SHZr_Int_VFNMADD231SHZrb_VFNMADD231SHZrb_Int_VFNMSUB132SHZr_VFNMSUB132SHZr_Int_VFNMSUB132SHZrb_VFNMSUB132SHZrb_Int_VFNMSUB213SHZr_VFNMSUB213SHZr_Int_VFNMSUB213SHZrb_VFNMSUB213SHZrb_Int_VFNMSUB231SHZr_VFNMSUB231SHZr_Int_VFNMSUB231SHZrb_VFNMSUB231SHZrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1701
  {DBGFIELD("VGETEXPPHZ128r_VGETEXPSHZr_VGETEXPSHZrb_VGETMANTPHZ128rri_VGETMANTSHZrri_VGETMANTSHZrrib") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1702
  {DBGFIELD("VGETEXPPHZ256r_VGETMANTPHZ256rri") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1703
  {DBGFIELD("VGF2P8MULBZ128rr")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1704
  {DBGFIELD("VGF2P8MULBZ256rr")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1705
  {DBGFIELD("VMAXCPHZ128rr_VMINCPHZ128rr_VMAXPHZ128rr_VMINPHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1706
  {DBGFIELD("VMAXCPHZ256rr_VMINCPHZ256rr_VMAXPHZ256rr_VMINPHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1707
  {DBGFIELD("VMAXCSHZrr_VMINCSHZrr_VMAXSHZrr_VMINSHZrr_VMAXSHZrr_Int_VMAXSHZrrb_Int_VMINSHZrr_Int_VMINSHZrrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1708
  {DBGFIELD("VMULPHZ128rr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1709
  {DBGFIELD("VMULPHZ256rr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1710
  {DBGFIELD("VMULSHZrr_VMULSHZrr_Int_VMULSHZrrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1711
  {DBGFIELD("VCVTSH2SSZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1712
  {DBGFIELD("VBROADCASTSSZ128rm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1713
  {DBGFIELD("VMOVDDUPZ128rm_VMOVSHDUPZ128rm_VMOVSLDUPZ128rm") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1714
  {DBGFIELD("VPBROADCASTDZ128rm_VPBROADCASTQZ128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1715
  {DBGFIELD("VBROADCASTI32X2Z128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1716
  {DBGFIELD("KANDBrr_KANDDrr_KANDNDrr_KANDNQrr_KANDNWrr_KANDQrr_KANDWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1717
  {DBGFIELD("VPABSBZrr_VPSUBSBZrr_VPABSDZrr_VPABSQZrr_VPABSWZrr_VPABSDZrrk_VPABSDZrrkz_VPABSQZrrk_VPABSQZrrkz_VPADDSBZrr_VPADDSWZrr_VPADDUSBZrr_VPADDUSWZrr_VPAVGBZrr_VPAVGWZrr_VPMAXSBZrr_VPMAXUDZrr_VPMAXUWZrr_VPMINSBZrr_VPMINUDZrr_VPMINUWZrr_VPMAXSDZrr_VPMAXUBZrr_VPMINSDZrr_VPMINUBZrr_VPMAXSDZrrk_VPMAXSDZrrkz_VPMAXUDZrrk_VPMAXUDZrrkz_VPMINSDZrrk_VPMINSDZrrkz_VPMINUDZrrk_VPMINUDZrrkz_VPMAXSWZrr_VPMINSWZrr_VPSUBSWZrr_VPSUBUSWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1718
  {DBGFIELD("VPSHLDDZrri_VPSHLDQZrri_VPSHLDWZrri_VPSHRDDZrri_VPSHRDQZrri_VPSHRDWZrri_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1719
  {DBGFIELD("VPSHLDVDZr_VPSHLDVQZr_VPSHLDVWZr_VPSHRDVDZr_VPSHRDVQZr_VPSHRDVWZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1720
  {DBGFIELD("VPSUBUSBZrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1721
  {DBGFIELD("KMOVBmk")            2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1722
  {DBGFIELD("VBROADCASTSSZ128rr_VBROADCASTSSZ128rrk_VBROADCASTSSZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1723
  {DBGFIELD("VPALIGNRZrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1724
  {DBGFIELD("VPSHUFDZri_VPSHUFHWZri_VPSHUFLWZri_VPSHUFDZrik_VPSHUFDZrikz_VPUNPCKHBWZrr_VPUNPCKHWDZrr_VPUNPCKLBWZrr_VPUNPCKLWDZrr_VPUNPCKHDQZrr_VPUNPCKHDQZrrk_VPUNPCKHDQZrrkz_VPUNPCKLDQZrr_VPUNPCKLDQZrrk_VPUNPCKLDQZrrkz_VPUNPCKLQDQZrr_VPUNPCKLQDQZrrk_VPUNPCKLQDQZrrkz_VPUNPCKHQDQZrr_VPUNPCKHQDQZrrk_VPUNPCKHQDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1725
  {DBGFIELD("VPSHUFBZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1726
  {DBGFIELD("VPABSBZrrk_VPABSBZrrkz_VPABSWZrrk_VPABSWZrrkz_VPSUBSBZrrk_VPSUBSBZrrkz_VPSUBSWZrrk_VPSUBSWZrrkz_VPADDSBZrrk_VPADDSBZrrkz_VPADDSWZrrk_VPADDSWZrrkz_VPADDUSBZrrk_VPADDUSBZrrkz_VPADDUSWZrrk_VPADDUSWZrrkz_VPAVGBZrrk_VPAVGBZrrkz_VPAVGWZrrk_VPAVGWZrrkz_VPMAXSBZrrk_VPMAXSBZrrkz_VPMAXUWZrrk_VPMAXUWZrrkz_VPMINSBZrrk_VPMINSBZrrkz_VPMINUWZrrk_VPMINUWZrrkz_VPMAXSWZrrk_VPMAXSWZrrkz_VPMAXUBZrrk_VPMAXUBZrrkz_VPMINSWZrrk_VPMINSWZrrkz_VPMINUBZrrk_VPMINUBZrrkz_VPSUBUSBZrrk_VPSUBUSBZrrkz_VPSUBUSWZrrk_VPSUBUSWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1727
  {DBGFIELD("VPSHLDVWZrk_VPSHLDVWZrkz_VPSHRDVWZrk_VPSHRDVWZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1728
  {DBGFIELD("VPSLLVWZrrk_VPSLLVWZrrkz_VPSRLVWZrrk_VPSRLVWZrrkz_VPSRAVWZrrk_VPSRAVWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1729
  {DBGFIELD("VPSLLWZrik_VPSLLWZrikz_VPSRLWZrik_VPSRLWZrikz_VPSRAWZrik_VPSRAWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1730
  {DBGFIELD("VMOVSDto64Zrr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1731
  {DBGFIELD("VCVTPH2DQZ128rr_VCVTPH2UDQZ128rr_VCVTTPH2DQZ128rr_VCVTTPH2UDQZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1732
  {DBGFIELD("VCVTPH2DQZ256rr_VCVTPH2UDQZ256rr_VCVTTPH2DQZ256rr_VCVTTPH2UDQZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1733
  {DBGFIELD("VCVTPH2PSXZ256rr")   2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1734
  {DBGFIELD("VCVTPS2PHXZ256rr")   2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1735
  {DBGFIELD("VCVTPH2PSXZ128rr")   2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1736
  {DBGFIELD("VCVTPS2PHXZ128rr")   2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1737
  {DBGFIELD("VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1738
  {DBGFIELD("VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1739
  {DBGFIELD("VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRLWZ256rrk_VPSRLWZ256rrkz_VPSRAWZ256rrk_VPSRAWZ256rrkz") 2, false, false, false, 183, 9, 14, 1,  0, 0}, // #1740
  {DBGFIELD("VMOVSHZmr_VMOVWmr")  2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1741
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTI32X2Z256rm_VBROADCASTF32X2Zrm_VBROADCASTI32X2Zrm_VPBROADCASTQZrm_VPBROADCASTDZ256rm_VPBROADCASTQZ256rm_VPBROADCASTDZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1742
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTI32X4Z256rm_VBROADCASTF32X8rm_VBROADCASTI32X8rm_VBROADCASTF32X4rm_VBROADCASTF64X4rm_VBROADCASTI32X4rm_VBROADCASTI64X4rm_VBROADCASTF64X2Z128rm_VBROADCASTF64X2rm_VBROADCASTI64X2Z128rm_VBROADCASTI64X2rm") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1743
  {DBGFIELD("VBROADCASTSSZrm_VBROADCASTSDZ256rm_VBROADCASTSSZ256rm_VBROADCASTSDZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1744
  {DBGFIELD("VMOVDDUPZrm_VMOVSHDUPZrm_VMOVSLDUPZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1745
  {DBGFIELD("VMOVDDUPZ256rm_VMOVSHDUPZ256rm_VMOVSLDUPZ256rm") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1746
  {DBGFIELD("VPMOVDBZrr_VPMOVQBZrr_VPMOVSQBZrr_VPMOVQWZrr_VPMOVSQWZrr_VPMOVSDBZrr_VPMOVUSDBZrr_VPMOVUSQBZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1747
  {DBGFIELD("VPMOVSWBZrr_VPMOVWBZrr_VPMOVDWZrr_VPMOVSDWZrr_VPMOVUSDWZrr_VPMOVSQDZrr_VPMOVUSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1748
  {DBGFIELD("VPMOVUSQWZrr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1749
  {DBGFIELD("VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1750
  {DBGFIELD("VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1751
  {DBGFIELD("VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1752
  {DBGFIELD("VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1753
  {DBGFIELD("VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Zrmk_VMOVDQU64Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1754
  {DBGFIELD("VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1755
  {DBGFIELD("VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1756
  {DBGFIELD("VPADDBZrm_VPADDDZrm_VPADDQZrm_VPADDWZrm_VPSUBBZrm_VPSUBDZrm_VPSUBQZrm_VPSUBWZrm_VPADDDZrmb_VPADDDZrmk_VPADDDZrmkz_VPADDQZrmb_VPADDQZrmk_VPADDQZrmkz_VPSUBDZrmb_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrmb_VPSUBQZrmk_VPSUBQZrmkz_VPADDDZrmbk_VPADDDZrmbkz_VPADDQZrmbk_VPADDQZrmbkz_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBQZrmbk_VPSUBQZrmbkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmik_VPTERNLOGQZrmbi_VPTERNLOGQZrmik_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmikz_VPTERNLOGQZrmi_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1757
  {DBGFIELD("VPBROADCASTWZrm_VPBROADCASTBZ256rm_VPBROADCASTWZ256rm_VPBROADCASTBZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1758
  {DBGFIELD("VFPCLASSPDZ128rm_VFPCLASSPSZ128rm") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1759
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSSZrm") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1760
  {DBGFIELD("VFPCLASSSHZrm")      2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1761
  {DBGFIELD("VPALIGNRZ256rmi")    2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1762
  {DBGFIELD("VPSHUFBZrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1763
  {DBGFIELD("MOV16ri_MOV64ri_MOV8ri_MOV16ri_alt_MOV8ri_alt_MOV16rr_MOV16rr_REV_MOV8rr_MOV8rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1764
  {DBGFIELD("MOV32ri_MOV32ri_alt") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1765
  {DBGFIELD("MOV8rr_NOREX")       1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1766
  {DBGFIELD("VMOVLPDZ128rm_VMOVLPSZ128rm_VSHUFPDZ128rmbi_VSHUFPDZ128rmik_VSHUFPSZ128rmbi_VSHUFPSZ128rmik_VSHUFPDZ128rmbik_VSHUFPDZ128rmbikz_VSHUFPSZ128rmbik_VSHUFPSZ128rmbikz_VSHUFPDZ128rmi_VSHUFPDZ128rmikz_VSHUFPSZ128rmi_VSHUFPSZ128rmikz") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1767
  {DBGFIELD("VMOVAPDZ128rrk_VMOVAPDZ128rrk_REV_VMOVAPDZ128rrkz_VMOVAPDZ128rrkz_REV_VMOVAPSZ128rrk_VMOVAPSZ128rrk_REV_VMOVAPSZ128rrkz_VMOVAPSZ128rrkz_REV_VMOVUPDZ128rrk_VMOVUPDZ128rrk_REV_VMOVUPDZ128rrkz_VMOVUPDZ128rrkz_REV_VMOVUPSZ128rrk_VMOVUPSZ128rrk_REV_VMOVUPSZ128rrkz_VMOVUPSZ128rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1768
  {DBGFIELD("VMOVAPDZ256rrk_VMOVAPDZ256rrk_REV_VMOVAPDZ256rrkz_VMOVAPDZ256rrkz_REV_VMOVAPSZ256rrk_VMOVAPSZ256rrk_REV_VMOVAPSZ256rrkz_VMOVAPSZ256rrkz_REV_VMOVUPDZ256rrk_VMOVUPDZ256rrk_REV_VMOVUPDZ256rrkz_VMOVUPDZ256rrkz_REV_VMOVUPSZ256rrk_VMOVUPSZ256rrk_REV_VMOVUPSZ256rrkz_VMOVUPSZ256rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1769
  {DBGFIELD("VMOVDQA32Z128rrk_VMOVDQA32Z128rrk_REV_VMOVDQA32Z128rrkz_VMOVDQA32Z128rrkz_REV_VMOVDQA64Z128rrk_VMOVDQA64Z128rrk_REV_VMOVDQA64Z128rrkz_VMOVDQA64Z128rrkz_REV_VMOVDQU32Z128rrk_VMOVDQU32Z128rrk_REV_VMOVDQU32Z128rrkz_VMOVDQU32Z128rrkz_REV_VMOVDQU64Z128rrk_VMOVDQU64Z128rrk_REV_VMOVDQU64Z128rrkz_VMOVDQU64Z128rrkz_REV_VPMOVM2DZ128rr_VPMOVM2QZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1770
  {DBGFIELD("VMOVSHZrr_VMOVSHZrr_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1771
  {DBGFIELD("VPADDBZ128rr_VPADDDZ128rr_VPADDQZ128rr_VPADDWZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rrk_VPADDQZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1772
  {DBGFIELD("VPADDBZ256rr_VPADDDZ256rr_VPADDQZ256rr_VPADDWZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rrk_VPADDQZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1773
  {DBGFIELD("VPABSBZrmk_VPABSBZrmkz_VPABSWZrmk_VPABSWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1774
  {DBGFIELD("VPSLLWZmik_VPSLLWZmikz_VPSRLWZmik_VPSRLWZmikz_VPSRAWZmik_VPSRAWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1775
  {DBGFIELD("VPADDSBZrmk_VPADDSBZrmkz_VPADDSWZrmk_VPADDSWZrmkz_VPADDUSBZrmk_VPADDUSBZrmkz_VPADDUSWZrmk_VPADDUSWZrmkz_VPSUBSBZrmk_VPSUBSBZrmkz_VPSUBSWZrmk_VPSUBSWZrmkz_VPSUBUSBZrmk_VPSUBUSBZrmkz_VPSUBUSWZrmk_VPSUBUSWZrmkz_VPAVGBZrmk_VPAVGBZrmkz_VPAVGWZrmk_VPAVGWZrmkz_VPMAXSBZrmk_VPMAXSBZrmkz_VPMAXUWZrmk_VPMAXUWZrmkz_VPMINSBZrmk_VPMINSBZrmkz_VPMINUWZrmk_VPMINUWZrmkz_VPMAXSWZrmk_VPMAXSWZrmkz_VPMAXUBZrmk_VPMAXUBZrmkz_VPMINSWZrmk_VPMINSWZrmkz_VPMINUBZrmk_VPMINUBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1776
  {DBGFIELD("VPSHLDVWZmk_VPSHLDVWZmkz_VPSHRDVWZmk_VPSHRDVWZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1777
  {DBGFIELD("VPSLLVWZrmk_VPSLLVWZrmkz_VPSRLVWZrmk_VPSRLVWZrmkz_VPSRAVWZrmk_VPSRAVWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1778
  {DBGFIELD("VPSLLWZrmk_VPSLLWZrmkz_VPSRLWZrmk_VPSRLWZrmkz_VPSRAWZrmk_VPSRAWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1779
  {DBGFIELD("VCOMISHZrr_VCOMISHZrrb_VUCOMISHZrr_VUCOMISHZrrb_VCOMISHZrr_Int_VUCOMISHZrr_Int") 1, false, false, false,  2, 8,  5, 1,  0, 0}, // #1780
  {DBGFIELD("VCVTPD2QQZrrb_VCVTPD2QQZrrbk_VCVTPD2QQZrrk_VCVTPD2QQZrrkz_VCVTPD2UQQZrrb_VCVTPD2UQQZrrbk_VCVTPD2UQQZrrk_VCVTPD2UQQZrrkz_VCVTTPD2QQZrrb_VCVTTPD2QQZrrbk_VCVTTPD2QQZrrk_VCVTTPD2QQZrrkz_VCVTTPD2UQQZrrb_VCVTTPD2UQQZrrbk_VCVTTPD2UQQZrrk_VCVTTPD2UQQZrrkz_VCVTPD2QQZrrbkz_VCVTPD2UQQZrrbkz_VCVTTPD2QQZrrbkz_VCVTTPD2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1781
  {DBGFIELD("VCVTPS2DQZrrb_VCVTPS2DQZrrbk_VCVTPS2DQZrrk_VCVTPS2DQZrrkz_VCVTPS2UDQZrrb_VCVTPS2UDQZrrbk_VCVTPS2UDQZrrk_VCVTPS2UDQZrrkz_VCVTTPS2DQZrrb_VCVTTPS2DQZrrbk_VCVTTPS2DQZrrk_VCVTTPS2DQZrrkz_VCVTTPS2UDQZrrb_VCVTTPS2UDQZrrbk_VCVTTPS2UDQZrrk_VCVTTPS2UDQZrrkz_VCVTPS2DQZrrbkz_VCVTPS2UDQZrrbkz_VCVTTPS2DQZrrbkz_VCVTTPS2UDQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1782
  {DBGFIELD("VMAXCPSZrr_VMAXCPSZrrk_VMAXCPSZrrkz_VMAXPSZrr_VMAXPSZrrk_VMAXPSZrrkz_VMINCPSZrr_VMINCPSZrrk_VMINCPSZrrkz_VMINPSZrr_VMINPSZrrk_VMINPSZrrkz_VMAXPSZrrb_VMAXPSZrrbk_VMAXPSZrrbkz_VMINPSZrrb_VMINPSZrrbk_VMINPSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1783
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1784
  {DBGFIELD("VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1785
  {DBGFIELD("VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1786
  {DBGFIELD("VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1787
  {DBGFIELD("VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1788
  {DBGFIELD("VPADDBZ128rm_VPADDDZ128rm_VPADDQZ128rm_VPADDWZ128rm_VPSUBBZ128rm_VPSUBDZ128rm_VPSUBQZ128rm_VPSUBWZ128rm_VPADDDZ128rmb_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rmb_VPADDQZ128rmk_VPADDQZ128rmkz_VPSUBDZ128rmb_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rmb_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmik_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmik_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmikz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1789
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTWZ128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1790
  {DBGFIELD("VPALIGNRZ128rmi")    2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1791
  {DBGFIELD("VPEXTRDZmr_VPEXTRQZmr") 3, false, false, false, 261, 8, 17, 1,  0, 0}, // #1792
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1793
  {DBGFIELD("ROUNDPDm_ROUNDPSm_VROUNDPDm_VROUNDPSm") 3, false, false, false, 74, 6, 11, 1,  0, 0}, // #1794
  {DBGFIELD("ROUNDSDm_ROUNDSDm_Int_ROUNDSSm_ROUNDSSm_Int_VROUNDSDm_VROUNDSDm_Int_VROUNDSSm_VROUNDSSm_Int_VRNDSCALEPDZ128rmbi_VRNDSCALEPDZ128rmik_VRNDSCALEPSZ128rmbi_VRNDSCALEPSZ128rmik_VRNDSCALEPDZ128rmbik_VRNDSCALEPDZ128rmbikz_VRNDSCALEPSZ128rmbik_VRNDSCALEPSZ128rmbikz_VRNDSCALEPDZ128rmi_VRNDSCALEPDZ128rmikz_VRNDSCALEPSZ128rmi_VRNDSCALEPSZ128rmikz_VRNDSCALESDZm_VRNDSCALESSZm_VRNDSCALESDZm_Int_VRNDSCALESDZm_Intk_VRNDSCALESDZm_Intkz_VRNDSCALESSZm_Int_VRNDSCALESSZm_Intk_VRNDSCALESSZm_Intkz") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #1795
  {DBGFIELD("ROUNDPDr_ROUNDSSr_VROUNDPDr_VROUNDSSr_ROUNDPSr_ROUNDSDr_VROUNDPSr_VROUNDSDr_ROUNDSDr_Int_ROUNDSSr_Int_VROUNDSDr_Int_VROUNDSSr_Int_VRNDSCALEPDZ128rri_VRNDSCALEPDZ128rrik_VRNDSCALEPDZ128rrikz_VRNDSCALEPSZ128rri_VRNDSCALEPSZ128rrik_VRNDSCALEPSZ128rrikz_VRNDSCALESDZr_VRNDSCALESSZr_VRNDSCALESDZr_Int_VRNDSCALESDZr_Intk_VRNDSCALESDZr_Intkz_VRNDSCALESDZrb_Int_VRNDSCALESDZrb_Intk_VRNDSCALESDZrb_Intkz_VRNDSCALESSZr_Int_VRNDSCALESSZr_Intk_VRNDSCALESSZr_Intkz_VRNDSCALESSZrb_Int_VRNDSCALESSZrb_Intk_VRNDSCALESSZrb_Intkz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1796
  {DBGFIELD("VRNDSCALEPDZ256rri_VRNDSCALEPDZ256rrik_VRNDSCALEPDZ256rrikz_VRNDSCALEPSZ256rri_VRNDSCALEPSZ256rrik_VRNDSCALEPSZ256rrikz_VROUNDPDYr_VROUNDPSYr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1797
  {DBGFIELD("VPMOVSXBWZ256rmk_VPMOVSXBWZ256rmkz_VPMOVSXBWZrmk_VPMOVSXBWZrmkz_VPMOVZXBWZ256rmk_VPMOVZXBWZ256rmkz_VPMOVZXBWZrmk_VPMOVZXBWZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1798
  {DBGFIELD("VPOPCNTBZ128rmk_VPOPCNTBZ128rmkz_VPOPCNTWZ128rmk_VPOPCNTWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1799
  {DBGFIELD("VPOPCNTBZ256rmk_VPOPCNTBZ256rmkz_VPOPCNTWZ256rmk_VPOPCNTWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1800
  {DBGFIELD("VPOPCNTBZrmk_VPOPCNTBZrmkz_VPOPCNTWZrmk_VPOPCNTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1801
  {DBGFIELD("VDBPSADBWZ128rmik_VDBPSADBWZ128rmikz") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #1802
  {DBGFIELD("VPMULTISHIFTQBZ128rmbk_VPMULTISHIFTQBZ128rmkz_VPMULTISHIFTQBZ128rmbkz_VPMULTISHIFTQBZ128rmk") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1803
  {DBGFIELD("VDBPSADBWZ256rmik_VDBPSADBWZ256rmikz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1804
  {DBGFIELD("VDBPSADBWZrmik_VDBPSADBWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1805
  {DBGFIELD("VPACKSSDWZ256rmbk_VPACKSSDWZ256rmkz_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmkz_VPACKSSDWZ256rmbkz_VPACKUSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSWBZ256rmk_VPACKUSDWZ256rmk_VPACKUSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSWBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1806
  {DBGFIELD("VPACKSSDWZrmbk_VPACKSSDWZrmkz_VPACKUSDWZrmbk_VPACKUSDWZrmkz_VPACKSSDWZrmbkz_VPACKUSDWZrmbkz_VPACKSSDWZrmk_VPACKSSWBZrmk_VPACKUSDWZrmk_VPACKUSWBZrmk_VPACKSSWBZrmkz_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1807
  {DBGFIELD("VPERMBZ128rmk_VPERMBZ128rmkz_VPERMBZ256rmk_VPERMBZ256rmkz_VPERMBZrmk_VPERMBZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1808
  {DBGFIELD("VPMULTISHIFTQBZ256rmbk_VPMULTISHIFTQBZ256rmkz_VPMULTISHIFTQBZ256rmbkz_VPMULTISHIFTQBZ256rmk") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1809
  {DBGFIELD("VPMULTISHIFTQBZrmbk_VPMULTISHIFTQBZrmkz_VPMULTISHIFTQBZrmbkz_VPMULTISHIFTQBZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1810
  {DBGFIELD("VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVWBZrrk_VPMOVWBZrrkz_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSWBZrrk_VPMOVUSWBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1811
  {DBGFIELD("VSQRTSDZm_Int")      2, false, false, false, 173, 10, 18, 1,  5, 1}, // #1812
  {DBGFIELD("VADDPDZ128rrkz_VSUBPDZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1813
  {DBGFIELD("VADDPDZ256rrkz_VSUBPDZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1814
  {DBGFIELD("VADDPSZ128rrkz_VSUBPSZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1815
  {DBGFIELD("VADDPSZ256rrkz_VSUBPSZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1816
  {DBGFIELD("VADDSDZrr_Intkz_VADDSDZrrb_Intkz_VSUBSDZrr_Intkz_VSUBSDZrrb_Intkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1817
  {DBGFIELD("VADDSSZrr_Intkz_VADDSSZrrb_Intkz_VSUBSSZrr_Intkz_VSUBSSZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1818
  {DBGFIELD("VADDPDZrr_VADDPDZrrb_VSUBPDZrr_VSUBPDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1819
  {DBGFIELD("VADDPSZrr_VADDPSZrrb_VSUBPSZrr_VSUBPSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1820
  {DBGFIELD("VMOVDQU16Zrrk_VMOVDQU16Zrrk_REV_VMOVDQU16Zrrkz_VMOVDQU16Zrrkz_REV_VMOVDQU8Zrrk_VMOVDQU8Zrrk_REV_VMOVDQU8Zrrkz_VMOVDQU8Zrrkz_REV_VPMOVM2BZrr_VPMOVM2WZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1821
  {DBGFIELD("VPBLENDMBZrrk_VPBLENDMBZrrkz_VPBLENDMWZrrk_VPBLENDMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1822
  {DBGFIELD("VADDPHZ128rrk_VADDPHZ128rrkz_VSUBPHZ128rrk_VSUBPHZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1823
  {DBGFIELD("VADDPHZ256rrk_VADDPHZ256rrkz_VSUBPHZ256rrk_VSUBPHZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1824
  {DBGFIELD("VADDSHZrr_Intk_VADDSHZrr_Intkz_VADDSHZrrb_Intk_VADDSHZrrb_Intkz_VSUBSHZrr_Intk_VSUBSHZrr_Intkz_VSUBSHZrrb_Intk_VSUBSHZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1825
  {DBGFIELD("VCVTPH2UWZ128rrk_VCVTPH2UWZ128rrkz_VCVTPH2WZ128rrk_VCVTPH2WZ128rrkz_VCVTTPH2UWZ128rrk_VCVTTPH2UWZ128rrkz_VCVTTPH2WZ128rrk_VCVTTPH2WZ128rrkz_VCVTUW2PHZ128rrk_VCVTUW2PHZ128rrkz_VCVTW2PHZ128rrk_VCVTW2PHZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1826
  {DBGFIELD("VCVTPH2UWZ256rrk_VCVTPH2UWZ256rrkz_VCVTPH2WZ256rrk_VCVTPH2WZ256rrkz_VCVTTPH2UWZ256rrk_VCVTTPH2UWZ256rrkz_VCVTTPH2WZ256rrk_VCVTTPH2WZ256rrkz_VCVTUW2PHZ256rrk_VCVTUW2PHZ256rrkz_VCVTW2PHZ256rrk_VCVTW2PHZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1827
  {DBGFIELD("VFMADD132PHZ128rk_VFMADD132PHZ128rkz_VFMADD213PHZ128rk_VFMADD213PHZ128rkz_VFMADD231PHZ128rk_VFMADD231PHZ128rkz_VFMSUB132PHZ128rk_VFMSUB132PHZ128rkz_VFMSUB213PHZ128rk_VFMSUB213PHZ128rkz_VFMSUB231PHZ128rk_VFMSUB231PHZ128rkz_VFNMADD132PHZ128rk_VFNMADD132PHZ128rkz_VFNMADD213PHZ128rk_VFNMADD213PHZ128rkz_VFNMADD231PHZ128rk_VFNMADD231PHZ128rkz_VFNMSUB132PHZ128rk_VFNMSUB132PHZ128rkz_VFNMSUB213PHZ128rk_VFNMSUB213PHZ128rkz_VFNMSUB231PHZ128rk_VFNMSUB231PHZ128rkz_VFMADDSUB132PHZ128rk_VFMADDSUB132PHZ128rkz_VFMADDSUB213PHZ128rk_VFMADDSUB213PHZ128rkz_VFMADDSUB231PHZ128rk_VFMADDSUB231PHZ128rkz_VFMSUBADD132PHZ128rk_VFMSUBADD132PHZ128rkz_VFMSUBADD213PHZ128rk_VFMSUBADD213PHZ128rkz_VFMSUBADD231PHZ128rk_VFMSUBADD231PHZ128rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1828
  {DBGFIELD("VFMADD132PHZ256rk_VFMADD132PHZ256rkz_VFMADD213PHZ256rk_VFMADD213PHZ256rkz_VFMADD231PHZ256rk_VFMADD231PHZ256rkz_VFMSUB132PHZ256rk_VFMSUB132PHZ256rkz_VFMSUB213PHZ256rk_VFMSUB213PHZ256rkz_VFMSUB231PHZ256rk_VFMSUB231PHZ256rkz_VFNMADD132PHZ256rk_VFNMADD132PHZ256rkz_VFNMADD213PHZ256rk_VFNMADD213PHZ256rkz_VFNMADD231PHZ256rk_VFNMADD231PHZ256rkz_VFNMSUB132PHZ256rk_VFNMSUB132PHZ256rkz_VFNMSUB213PHZ256rk_VFNMSUB213PHZ256rkz_VFNMSUB231PHZ256rk_VFNMSUB231PHZ256rkz_VFMADDSUB132PHZ256rk_VFMADDSUB132PHZ256rkz_VFMADDSUB213PHZ256rk_VFMADDSUB213PHZ256rkz_VFMADDSUB231PHZ256rk_VFMADDSUB231PHZ256rkz_VFMSUBADD132PHZ256rk_VFMSUBADD132PHZ256rkz_VFMSUBADD213PHZ256rk_VFMSUBADD213PHZ256rkz_VFMSUBADD231PHZ256rk_VFMSUBADD231PHZ256rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1829
  {DBGFIELD("VFMADD132SHZr_Intk_VFMADD132SHZr_Intkz_VFMADD132SHZrb_Intk_VFMADD132SHZrb_Intkz_VFMADD213SHZr_Intk_VFMADD213SHZr_Intkz_VFMADD213SHZrb_Intk_VFMADD213SHZrb_Intkz_VFMADD231SHZr_Intk_VFMADD231SHZr_Intkz_VFMADD231SHZrb_Intk_VFMADD231SHZrb_Intkz_VFMSUB132SHZr_Intk_VFMSUB132SHZr_Intkz_VFMSUB132SHZrb_Intk_VFMSUB132SHZrb_Intkz_VFMSUB213SHZr_Intk_VFMSUB213SHZr_Intkz_VFMSUB213SHZrb_Intk_VFMSUB213SHZrb_Intkz_VFMSUB231SHZr_Intk_VFMSUB231SHZr_Intkz_VFMSUB231SHZrb_Intk_VFMSUB231SHZrb_Intkz_VFNMADD132SHZr_Intk_VFNMADD132SHZr_Intkz_VFNMADD132SHZrb_Intk_VFNMADD132SHZrb_Intkz_VFNMADD213SHZr_Intk_VFNMADD213SHZr_Intkz_VFNMADD213SHZrb_Intk_VFNMADD213SHZrb_Intkz_VFNMADD231SHZr_Intk_VFNMADD231SHZr_Intkz_VFNMADD231SHZrb_Intk_VFNMADD231SHZrb_Intkz_VFNMSUB132SHZr_Intk_VFNMSUB132SHZr_Intkz_VFNMSUB132SHZrb_Intk_VFNMSUB132SHZrb_Intkz_VFNMSUB213SHZr_Intk_VFNMSUB213SHZr_Intkz_VFNMSUB213SHZrb_Intk_VFNMSUB213SHZrb_Intkz_VFNMSUB231SHZr_Intk_VFNMSUB231SHZr_Intkz_VFNMSUB231SHZrb_Intk_VFNMSUB231SHZrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1830
  {DBGFIELD("VGETEXPPHZ128rk_VGETEXPPHZ128rkz_VGETEXPSHZrbk_VGETEXPSHZrkz_VGETEXPSHZrbkz_VGETEXPSHZrk_VGETMANTPHZ128rrik_VGETMANTPHZ128rrikz_VGETMANTSHZrribk_VGETMANTSHZrrikz_VGETMANTSHZrribkz_VGETMANTSHZrrik") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1831
  {DBGFIELD("VGETEXPPHZ256rk_VGETEXPPHZ256rkz_VGETMANTPHZ256rrik_VGETMANTPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1832
  {DBGFIELD("VMAXCPHZ128rrk_VMAXCPHZ128rrkz_VMINCPHZ128rrk_VMINCPHZ128rrkz_VMAXPHZ128rrk_VMAXPHZ128rrkz_VMINPHZ128rrk_VMINPHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1833
  {DBGFIELD("VMAXCPHZ256rrk_VMAXCPHZ256rrkz_VMINCPHZ256rrk_VMINCPHZ256rrkz_VMAXPHZ256rrk_VMAXPHZ256rrkz_VMINPHZ256rrk_VMINPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1834
  {DBGFIELD("VMULPHZ128rrk_VMULPHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1835
  {DBGFIELD("VMULPHZ256rrk_VMULPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1836
  {DBGFIELD("VMAXSHZrr_Intk_VMAXSHZrr_Intkz_VMAXSHZrrb_Intk_VMAXSHZrrb_Intkz_VMINSHZrr_Intk_VMINSHZrr_Intkz_VMINSHZrrb_Intk_VMINSHZrrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1837
  {DBGFIELD("VMULSHZrr_Intk_VMULSHZrr_Intkz_VMULSHZrrb_Intk_VMULSHZrrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1838
  {DBGFIELD("VADDPHZrr_VADDPHZrrb_VSUBPHZrr_VSUBPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1839
  {DBGFIELD("VAESDECLASTZrr_VAESDECZrr_VAESENCLASTZrr_VAESENCZrr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1840
  {DBGFIELD("VCVTPH2UWZrr_VCVTPH2UWZrrb_VCVTPH2WZrr_VCVTPH2WZrrb_VCVTTPH2UWZrr_VCVTTPH2UWZrrb_VCVTTPH2WZrr_VCVTTPH2WZrrb_VCVTUW2PHZrr_VCVTUW2PHZrrb_VCVTW2PHZrr_VCVTW2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1841
  {DBGFIELD("VFMADD132PHZr_VFMADD132PHZrb_VFMADD213PHZr_VFMADD213PHZrb_VFMADD231PHZr_VFMADD231PHZrb_VFMSUB132PHZr_VFMSUB132PHZrb_VFMSUB213PHZr_VFMSUB213PHZrb_VFMSUB231PHZr_VFMSUB231PHZrb_VFNMADD132PHZr_VFNMADD132PHZrb_VFNMADD213PHZr_VFNMADD213PHZrb_VFNMADD231PHZr_VFNMADD231PHZrb_VFNMSUB132PHZr_VFNMSUB132PHZrb_VFNMSUB213PHZr_VFNMSUB213PHZrb_VFNMSUB231PHZr_VFNMSUB231PHZrb_VFMADDSUB132PHZr_VFMADDSUB132PHZrb_VFMADDSUB213PHZr_VFMADDSUB213PHZrb_VFMADDSUB231PHZr_VFMADDSUB231PHZrb_VFMSUBADD132PHZr_VFMSUBADD132PHZrb_VFMSUBADD213PHZr_VFMSUBADD213PHZrb_VFMSUBADD231PHZr_VFMSUBADD231PHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1842
  {DBGFIELD("VGETEXPPHZr_VGETEXPPHZrb_VGETMANTPHZrri_VGETMANTPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1843
  {DBGFIELD("VMAXCPHZrr_VMINCPHZrr_VMAXPHZrr_VMAXPHZrrb_VMINPHZrr_VMINPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1844
  {DBGFIELD("VMULPHZrr_VMULPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1845
  {DBGFIELD("VGF2P8MULBZrr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1846
  {DBGFIELD("VADDPHZrrbk_VADDPHZrrkz_VSUBPHZrrbk_VSUBPHZrrkz_VADDPHZrrbkz_VADDPHZrrk_VSUBPHZrrbkz_VSUBPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1847
  {DBGFIELD("VCVTPH2UWZrrbk_VCVTPH2UWZrrkz_VCVTPH2WZrrbk_VCVTPH2WZrrkz_VCVTTPH2UWZrrbk_VCVTTPH2UWZrrkz_VCVTTPH2WZrrbk_VCVTTPH2WZrrkz_VCVTPH2UWZrrbkz_VCVTPH2UWZrrk_VCVTPH2WZrrbkz_VCVTPH2WZrrk_VCVTTPH2UWZrrbkz_VCVTTPH2UWZrrk_VCVTTPH2WZrrbkz_VCVTTPH2WZrrk_VCVTUW2PHZrrbk_VCVTUW2PHZrrkz_VCVTW2PHZrrbk_VCVTW2PHZrrkz_VCVTUW2PHZrrbkz_VCVTUW2PHZrrk_VCVTW2PHZrrbkz_VCVTW2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1848
  {DBGFIELD("VFMADD132PHZrbk_VFMADD132PHZrkz_VFMADD213PHZrbk_VFMADD213PHZrkz_VFMADD231PHZrbk_VFMADD231PHZrkz_VFMSUB132PHZrbk_VFMSUB132PHZrkz_VFMSUB213PHZrbk_VFMSUB213PHZrkz_VFMSUB231PHZrbk_VFMSUB231PHZrkz_VFNMADD132PHZrbk_VFNMADD132PHZrkz_VFNMADD213PHZrbk_VFNMADD213PHZrkz_VFNMADD231PHZrbk_VFNMADD231PHZrkz_VFNMSUB132PHZrbk_VFNMSUB132PHZrkz_VFNMSUB213PHZrbk_VFNMSUB213PHZrkz_VFNMSUB231PHZrbk_VFNMSUB231PHZrkz_VFMADD132PHZrbkz_VFMADD132PHZrk_VFMADD213PHZrbkz_VFMADD213PHZrk_VFMADD231PHZrbkz_VFMADD231PHZrk_VFMSUB132PHZrbkz_VFMSUB132PHZrk_VFMSUB213PHZrbkz_VFMSUB213PHZrk_VFMSUB231PHZrbkz_VFMSUB231PHZrk_VFNMADD132PHZrbkz_VFNMADD132PHZrk_VFNMADD213PHZrbkz_VFNMADD213PHZrk_VFNMADD231PHZrbkz_VFNMADD231PHZrk_VFNMSUB132PHZrbkz_VFNMSUB132PHZrk_VFNMSUB213PHZrbkz_VFNMSUB213PHZrk_VFNMSUB231PHZrbkz_VFNMSUB231PHZrk_VFMADDSUB132PHZrbk_VFMADDSUB132PHZrkz_VFMADDSUB213PHZrbk_VFMADDSUB213PHZrkz_VFMADDSUB231PHZrbk_VFMADDSUB231PHZrkz_VFMADDSUB132PHZrbkz_VFMADDSUB132PHZrk_VFMADDSUB213PHZrbkz_VFMADDSUB213PHZrk_VFMADDSUB231PHZrbkz_VFMADDSUB231PHZrk_VFMSUBADD132PHZrbk_VFMSUBADD132PHZrkz_VFMSUBADD213PHZrbk_VFMSUBADD213PHZrkz_VFMSUBADD231PHZrbk_VFMSUBADD231PHZrkz_VFMSUBADD132PHZrbkz_VFMSUBADD132PHZrk_VFMSUBADD213PHZrbkz_VFMSUBADD213PHZrk_VFMSUBADD231PHZrbkz_VFMSUBADD231PHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1849
  {DBGFIELD("VGETEXPPHZrbk_VGETEXPPHZrkz_VGETEXPPHZrbkz_VGETEXPPHZrk_VGETMANTPHZrribk_VGETMANTPHZrrikz_VGETMANTPHZrribkz_VGETMANTPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1850
  {DBGFIELD("VMAXCPHZrrk_VMAXCPHZrrkz_VMINCPHZrrk_VMINCPHZrrkz_VMAXPHZrrbk_VMAXPHZrrkz_VMINPHZrrbk_VMINPHZrrkz_VMAXPHZrrbkz_VMAXPHZrrk_VMINPHZrrbkz_VMINPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1851
  {DBGFIELD("VMULPHZrrbk_VMULPHZrrkz_VMULPHZrrbkz_VMULPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1852
  {DBGFIELD("VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPSHUFHWZ128mik_VPSHUFHWZ128mikz_VPSHUFLWZ128mik_VPSHUFLWZ128mikz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1853
  {DBGFIELD("VPSHUFHWZ256mik_VPSHUFHWZ256mikz_VPSHUFLWZ256mik_VPSHUFLWZ256mikz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1854
  {DBGFIELD("VADDPSYrm_VSUBPSYrm_VADDPSZ256rm_VADDPSZ256rmb_VADDPSZ256rmbk_VADDPSZ256rmk_VADDPSZ256rmkz_VSUBPSZ256rm_VSUBPSZ256rmb_VSUBPSZ256rmbk_VSUBPSZ256rmk_VSUBPSZ256rmkz_VADDPSZ256rmbkz_VSUBPSZ256rmbkz") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #1855
  {DBGFIELD("VPSHUFBZ256rmk_VPSHUFBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1856
  {DBGFIELD("VPUNPCKHBWZ256rmk_VPUNPCKHBWZ256rmkz_VPUNPCKHWDZ256rmk_VPUNPCKHWDZ256rmkz_VPUNPCKLBWZ256rmk_VPUNPCKLBWZ256rmkz_VPUNPCKLWDZ256rmk_VPUNPCKLWDZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1857
  {DBGFIELD("VADDSUBPSYrm")       2, false, false, false, 53, 7,  8, 1,  5, 1}, // #1858
  {DBGFIELD("VPSHUFBZ128rmk_VPSHUFBZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1859
  {DBGFIELD("VPUNPCKHBWZ128rmk_VPUNPCKHBWZ128rmkz_VPUNPCKHWDZ128rmk_VPUNPCKHWDZ128rmkz_VPUNPCKLBWZ128rmk_VPUNPCKLBWZ128rmkz_VPUNPCKLWDZ128rmk_VPUNPCKLWDZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1860
  {DBGFIELD("VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1861
  {DBGFIELD("VADDPSZrm_VADDPSZrmb_VADDPSZrmbk_VADDPSZrmk_VADDPSZrmkz_VSUBPSZrm_VSUBPSZrmb_VSUBPSZrmbk_VSUBPSZrmk_VSUBPSZrmkz_VADDPSZrmbkz_VSUBPSZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1862
  {DBGFIELD("VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1863
  {DBGFIELD("VADDPSZrrbk_VADDPSZrrkz_VSUBPSZrrbk_VSUBPSZrrkz_VADDPSZrrbkz_VADDPSZrrk_VSUBPSZrrbkz_VSUBPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1864
  {DBGFIELD("VPLZCNTDZrm_VPLZCNTDZrmb_VPLZCNTDZrmbk_VPLZCNTDZrmk_VPLZCNTDZrmkz_VPLZCNTQZrm_VPLZCNTQZrmb_VPLZCNTQZrmbk_VPLZCNTQZrmk_VPLZCNTQZrmkz_VPLZCNTDZrmbkz_VPLZCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1865
  {DBGFIELD("VAESDECLASTZrm_VAESDECZrm_VAESENCLASTZrm_VAESENCZrm") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1866
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbi_VGF2P8AFFINEINVQBZrmi_VGF2P8AFFINEQBZrmbi_VGF2P8AFFINEQBZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1867
  {DBGFIELD("VGF2P8MULBZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1868
  {DBGFIELD("VPMADD52HUQZm_VPMADD52HUQZmb_VPMADD52HUQZmbk_VPMADD52HUQZmk_VPMADD52HUQZmkz_VPMADD52LUQZm_VPMADD52LUQZmb_VPMADD52LUQZmbk_VPMADD52LUQZmk_VPMADD52LUQZmkz_VPMADD52HUQZmbkz_VPMADD52LUQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1869
  {DBGFIELD("VPOPCNTBZ256rm_VPOPCNTDZ256rm_VPOPCNTQZ256rm_VPOPCNTWZ256rm_VPOPCNTDZ256rmb_VPOPCNTDZ256rmk_VPOPCNTDZ256rmkz_VPOPCNTQZ256rmb_VPOPCNTQZ256rmk_VPOPCNTQZ256rmkz_VPOPCNTDZ256rmbk_VPOPCNTDZ256rmbkz_VPOPCNTQZ256rmbk_VPOPCNTQZ256rmbkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1870
  {DBGFIELD("VPOPCNTBZrm_VPOPCNTDZrm_VPOPCNTQZrm_VPOPCNTWZrm_VPOPCNTDZrmb_VPOPCNTDZrmk_VPOPCNTDZrmkz_VPOPCNTQZrmb_VPOPCNTQZrmk_VPOPCNTQZrmkz_VPOPCNTDZrmbk_VPOPCNTDZrmbkz_VPOPCNTQZrmbk_VPOPCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1871
  {DBGFIELD("VPSHUFHWZmik_VPSHUFHWZmikz_VPSHUFLWZmik_VPSHUFLWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1872
  {DBGFIELD("VFPCLASSPDZ256rmb_VFPCLASSPSZ256rmb") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1873
  {DBGFIELD("VFPCLASSPDZrmb_VFPCLASSPSZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1874
  {DBGFIELD("VFPCLASSPHZ256rmb")  2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1875
  {DBGFIELD("VFPCLASSPHZrmb")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1876
  {DBGFIELD("VPALIGNRZrmik_VPALIGNRZrmikz_VPUNPCKHBWZrmk_VPUNPCKHBWZrmkz_VPUNPCKHWDZrmk_VPUNPCKHWDZrmkz_VPUNPCKLBWZrmk_VPUNPCKLBWZrmkz_VPUNPCKLWDZrmk_VPUNPCKLWDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1877
  {DBGFIELD("VPMULTISHIFTQBZ256rm_VPMULTISHIFTQBZ256rmb") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1878
  {DBGFIELD("VPMULTISHIFTQBZrm_VPMULTISHIFTQBZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1879
  {DBGFIELD("VPCLMULQDQZrm")      2, false, false, false, 375, 10,  9, 1,  5, 1}, // #1880
  {DBGFIELD("VPCLMULQDQZ256rm")   2, false, false, false, 375, 10,  9, 1,  5, 1}, // #1881
  {DBGFIELD("VBLENDVPDYrm_VBLENDVPSYrm") 4, false, false, false, 621, 5,  9, 1,  7, 2}, // #1882
  {DBGFIELD("VPBLENDVBYrm")       4, false, false, false, 621, 5,  9, 1,  7, 2}, // #1883
  {DBGFIELD("VBLENDVPDYrr_VBLENDVPSYrr") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1884
  {DBGFIELD("VPBLENDVBYrr")       3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1885
  {DBGFIELD("VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPSZ256rmk_VMOVUPSZ256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1886
  {DBGFIELD("VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1887
  {DBGFIELD("VPADDBZ256rm_VPADDDZ256rm_VPADDQZ256rm_VPADDWZ256rm_VPSUBBZ256rm_VPSUBDZ256rm_VPSUBQZ256rm_VPSUBWZ256rm_VPADDDZ256rmb_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rmb_VPADDQZ256rmk_VPADDQZ256rmkz_VPSUBDZ256rmb_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rmb_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmik_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmik_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmikz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1888
  {DBGFIELD("VCMPPHZ128rmbi_VCMPPHZ128rmik_VCMPPHZ128rmbik_VCMPPHZ128rmi_VFPCLASSPHZ128rmbk_VFPCLASSPHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1889
  {DBGFIELD("VCMPPHZ256rmbi_VCMPPHZ256rmik_VCMPPHZ256rmbik_VCMPPHZ256rmi_VFPCLASSPHZ256rmbk_VFPCLASSPHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1890
  {DBGFIELD("VCMPPHZrmbi_VCMPPHZrmik_VCMPPHZrmbik_VCMPPHZrmi_VFPCLASSPHZrmbk_VFPCLASSPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1891
  {DBGFIELD("VCMPSHZrm_VCMPSHZrm_Int_VCMPSHZrm_Intk_VFPCLASSSHZrmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1892
  {DBGFIELD("VCOMISHZrm_VCOMISHZrm_Int_VUCOMISHZrm_VUCOMISHZrm_Int") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #1893
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ256mr_VCOMPRESSPSZ128mr_VCOMPRESSPSZ256mr_VCOMPRESSPDZmr_VCOMPRESSPSZmr_VPCOMPRESSDZ128mr_VPCOMPRESSDZ256mr_VPCOMPRESSQZ128mr_VPCOMPRESSQZ256mr_VPCOMPRESSDZmr_VPCOMPRESSQZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1894
  {DBGFIELD("VPMOVDBZmr_VPMOVQBZmr_VPMOVSQBZmr_VPMOVSWBZmr_VPMOVWBZmr_VPMOVDWZmr_VPMOVQWZmr_VPMOVSDWZmr_VPMOVSQWZmr_VPMOVUSDWZmr_VPMOVUSQWZmr_VPMOVSDBZmr_VPMOVSQDZmr_VPMOVUSDBZmr_VPMOVUSQDZmr_VPMOVUSQBZmr_VPMOVUSWBZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1895
  {DBGFIELD("VPMOVDBZmrk_VPMOVQBZmrk_VPMOVSQBZmrk_VPMOVSWBZmrk_VPMOVWBZmrk_VPMOVDWZmrk_VPMOVQWZmrk_VPMOVSDWZmrk_VPMOVSQWZmrk_VPMOVUSDWZmrk_VPMOVUSQWZmrk_VPMOVSDBZmrk_VPMOVSQDZmrk_VPMOVUSDBZmrk_VPMOVUSQDZmrk_VPMOVUSQBZmrk_VPMOVUSWBZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1896
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPSZ128rr_VPCOMPRESSDZ128rr_VPCOMPRESSQZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1897
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPSZ256rr_VPCOMPRESSDZ256rr_VPCOMPRESSQZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1898
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPSZrr_VPCOMPRESSDZrr_VPCOMPRESSQZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1899
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ256rr_VEXPANDPSZ128rr_VEXPANDPSZ256rr_VEXPANDPDZrr_VEXPANDPSZrr_VPEXPANDDZ128rr_VPEXPANDDZ256rr_VPEXPANDQZ128rr_VPEXPANDQZ256rr_VPEXPANDDZrr_VPEXPANDQZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1900
  {DBGFIELD("VPCOMPRESSBZ128rr_VPCOMPRESSWZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1901
  {DBGFIELD("VPCOMPRESSBZ256rr_VPCOMPRESSWZ256rr_VPEXPANDBZ256rr_VPEXPANDWZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1902
  {DBGFIELD("VPCOMPRESSBZrr_VPCOMPRESSWZrr_VPEXPANDBZrr_VPEXPANDWZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1903
  {DBGFIELD("VPEXPANDBZ128rr_VPEXPANDWZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1904
  {DBGFIELD("VCVTDQ2PDZrrk_VCVTDQ2PDZrrkz_VCVTUDQ2PDZrrk_VCVTUDQ2PDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1905
  {DBGFIELD("VCVTPS2QQZrrb_VCVTPS2QQZrrbk_VCVTPS2QQZrrk_VCVTPS2QQZrrkz_VCVTPS2UQQZrrb_VCVTPS2UQQZrrbk_VCVTPS2UQQZrrk_VCVTPS2UQQZrrkz_VCVTTPS2QQZrrb_VCVTTPS2QQZrrbk_VCVTTPS2QQZrrk_VCVTTPS2QQZrrkz_VCVTTPS2UQQZrrb_VCVTTPS2UQQZrrbk_VCVTTPS2UQQZrrk_VCVTTPS2UQQZrrkz_VCVTPS2QQZrrbkz_VCVTPS2UQQZrrbkz_VCVTTPS2QQZrrbkz_VCVTTPS2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1906
  {DBGFIELD("VCVTQQ2PSZrrb_VCVTQQ2PSZrrbk_VCVTQQ2PSZrrk_VCVTQQ2PSZrrkz_VCVTUQQ2PSZrrb_VCVTUQQ2PSZrrbk_VCVTUQQ2PSZrrk_VCVTUQQ2PSZrrkz_VCVTQQ2PSZrrbkz_VCVTUQQ2PSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1907
  {DBGFIELD("VCVTDQ2PHZ128rm_VCVTDQ2PHZ128rmb_VCVTUDQ2PHZ128rm_VCVTUDQ2PHZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1908
  {DBGFIELD("VCVTNEPS2BF16Z128rm_VCVTNEPS2BF16Z128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1909
  {DBGFIELD("VCVTDQ2PHZ128rmbk_VCVTDQ2PHZ128rmkz_VCVTUDQ2PHZ128rmbk_VCVTUDQ2PHZ128rmkz_VCVTDQ2PHZ128rmbkz_VCVTDQ2PHZ128rmk_VCVTUDQ2PHZ128rmbkz_VCVTUDQ2PHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1910
  {DBGFIELD("VCVTDQ2PHZ128rr_VCVTUDQ2PHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1911
  {DBGFIELD("VCVTDQ2PHZ128rrk_VCVTDQ2PHZ128rrkz_VCVTUDQ2PHZ128rrk_VCVTUDQ2PHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1912
  {DBGFIELD("VCVTDQ2PHZ256rm_VCVTDQ2PHZ256rmb_VCVTUDQ2PHZ256rm_VCVTUDQ2PHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1913
  {DBGFIELD("VCVTNEPS2BF16Z128rmbk_VCVTNEPS2BF16Z128rmkz_VCVTNEPS2BF16Z128rmbkz_VCVTNEPS2BF16Z128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1914
  {DBGFIELD("VCVTDQ2PHZ256rmbk_VCVTDQ2PHZ256rmkz_VCVTUDQ2PHZ256rmbk_VCVTUDQ2PHZ256rmkz_VCVTDQ2PHZ256rmbkz_VCVTDQ2PHZ256rmk_VCVTUDQ2PHZ256rmbkz_VCVTUDQ2PHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1915
  {DBGFIELD("VCVTDQ2PHZ256rr_VCVTUDQ2PHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1916
  {DBGFIELD("VCVTDQ2PHZ256rrk_VCVTDQ2PHZ256rrkz_VCVTUDQ2PHZ256rrk_VCVTUDQ2PHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1917
  {DBGFIELD("VCVTDQ2PHZrm_VCVTDQ2PHZrmb_VCVTUDQ2PHZrm_VCVTUDQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1918
  {DBGFIELD("VCVTDQ2PHZrmbk_VCVTDQ2PHZrmkz_VCVTUDQ2PHZrmbk_VCVTUDQ2PHZrmkz_VCVTDQ2PHZrmbkz_VCVTDQ2PHZrmk_VCVTUDQ2PHZrmbkz_VCVTUDQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1919
  {DBGFIELD("VCVTDQ2PHZrr_VCVTDQ2PHZrrb_VCVTUDQ2PHZrr_VCVTUDQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1920
  {DBGFIELD("VCVTDQ2PHZrrbk_VCVTDQ2PHZrrkz_VCVTUDQ2PHZrrbk_VCVTUDQ2PHZrrkz_VCVTDQ2PHZrrbkz_VCVTDQ2PHZrrk_VCVTUDQ2PHZrrbkz_VCVTUDQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1921
  {DBGFIELD("VCVTNE2PS2BF16Z128rm_VCVTNE2PS2BF16Z128rmb") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1922
  {DBGFIELD("VCVTNE2PS2BF16Z128rmbk_VCVTNE2PS2BF16Z128rmkz_VCVTNE2PS2BF16Z128rmbkz_VCVTNE2PS2BF16Z128rmk") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1923
  {DBGFIELD("VCVTNE2PS2BF16Z128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1924
  {DBGFIELD("VCVTNE2PS2BF16Z256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1925
  {DBGFIELD("VCVTNE2PS2BF16Z128rrk_VCVTNE2PS2BF16Z128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1926
  {DBGFIELD("VCVTNE2PS2BF16Z256rrk_VCVTNE2PS2BF16Z256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1927
  {DBGFIELD("VCVTNE2PS2BF16Z256rm_VCVTNE2PS2BF16Z256rmb") 3, false, false, false, 192, 11, 11, 1,  5, 1}, // #1928
  {DBGFIELD("VCVTNE2PS2BF16Z256rmbk_VCVTNE2PS2BF16Z256rmkz_VCVTNE2PS2BF16Z256rmbkz_VCVTNE2PS2BF16Z256rmk") 3, false, false, false, 192, 11, 11, 1,  5, 1}, // #1929
  {DBGFIELD("VCVTNE2PS2BF16Zrm_VCVTNE2PS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1930
  {DBGFIELD("VDPBF16PSZm_VDPBF16PSZmb_VDPBF16PSZmbk_VDPBF16PSZmk_VDPBF16PSZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1931
  {DBGFIELD("VDPBF16PSZmbkz")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1932
  {DBGFIELD("VCVTNE2PS2BF16Zrmbk_VCVTNE2PS2BF16Zrmkz_VCVTNE2PS2BF16Zrmbkz_VCVTNE2PS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1933
  {DBGFIELD("VCVTNE2PS2BF16Zrr")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1934
  {DBGFIELD("VCVTNE2PS2BF16Zrrk_VCVTNE2PS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1935
  {DBGFIELD("VCVTNEPS2BF16Z128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1936
  {DBGFIELD("VCVTNEPS2BF16Z256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1937
  {DBGFIELD("VCVTNEPS2BF16Z128rrk_VCVTNEPS2BF16Z128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1938
  {DBGFIELD("VCVTNEPS2BF16Z256rrk_VCVTNEPS2BF16Z256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1939
  {DBGFIELD("VCVTNEPS2BF16Z256rm_VCVTNEPS2BF16Z256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1940
  {DBGFIELD("VCVTNEPS2BF16Z256rmbk_VCVTNEPS2BF16Z256rmkz_VCVTNEPS2BF16Z256rmbkz_VCVTNEPS2BF16Z256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1941
  {DBGFIELD("VCVTNEPS2BF16Zrm_VCVTNEPS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1942
  {DBGFIELD("VCVTNEPS2BF16Zrmbk_VCVTNEPS2BF16Zrmkz_VCVTNEPS2BF16Zrmbkz_VCVTNEPS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1943
  {DBGFIELD("VCVTNEPS2BF16Zrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1944
  {DBGFIELD("VCVTNEPS2BF16Zrrk_VCVTNEPS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1945
  {DBGFIELD("VCVTPD2DQZ256rm_VCVTPD2DQZ256rmb_VCVTPD2UDQZ256rm_VCVTPD2UDQZ256rmb_VCVTTPD2DQZ256rm_VCVTTPD2DQZ256rmb_VCVTTPD2UDQZ256rm_VCVTTPD2UDQZ256rmb_VCVTPD2DQZ256rmbk_VCVTPD2DQZ256rmkz_VCVTPD2UDQZ256rmbk_VCVTPD2UDQZ256rmkz_VCVTTPD2DQZ256rmbk_VCVTTPD2DQZ256rmkz_VCVTTPD2UDQZ256rmbk_VCVTTPD2UDQZ256rmkz_VCVTPD2DQZ256rmbkz_VCVTPD2DQZ256rmk_VCVTPD2UDQZ256rmbkz_VCVTPD2UDQZ256rmk_VCVTTPD2DQZ256rmbkz_VCVTTPD2DQZ256rmk_VCVTTPD2UDQZ256rmbkz_VCVTTPD2UDQZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1946
  {DBGFIELD("VCVTPH2DQZ256rm_VCVTPH2DQZ256rmb_VCVTPH2UDQZ256rm_VCVTPH2UDQZ256rmb_VCVTTPH2DQZ256rm_VCVTTPH2DQZ256rmb_VCVTTPH2UDQZ256rm_VCVTTPH2UDQZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1947
  {DBGFIELD("VCVTPH2PSXZ128rmbk_VCVTPH2PSXZ128rmkz_VCVTPH2PSXZ128rmbkz_VCVTPH2PSXZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1948
  {DBGFIELD("VCVTPH2PSXZ256rm_VCVTPH2PSXZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1949
  {DBGFIELD("VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz_VCVTQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmbkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1950
  {DBGFIELD("VCVTPH2DQZrm_VCVTPH2DQZrmb_VCVTPH2UDQZrm_VCVTPH2UDQZrmb_VCVTTPH2DQZrm_VCVTTPH2DQZrmb_VCVTTPH2UDQZrm_VCVTTPH2UDQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1951
  {DBGFIELD("VCVTPH2PSXZrm_VCVTPH2PSXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1952
  {DBGFIELD("VCVTPD2PHZ128rm_VCVTPD2PHZ128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1953
  {DBGFIELD("VCVTPD2PHZ128rmbk_VCVTPD2PHZ128rmkz_VCVTPD2PHZ128rmbkz_VCVTPD2PHZ128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1954
  {DBGFIELD("VCVTPD2PHZ128rr")    2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1955
  {DBGFIELD("VCVTPD2PHZ128rrk_VCVTPD2PHZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1956
  {DBGFIELD("VCVTPD2PHZ256rm_VCVTPD2PHZ256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1957
  {DBGFIELD("VCVTPD2PHZ256rmbk_VCVTPD2PHZ256rmkz_VCVTPD2PHZ256rmbkz_VCVTPD2PHZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1958
  {DBGFIELD("VCVTPD2PHZ256rr")    2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1959
  {DBGFIELD("VCVTPD2PHZ256rrk_VCVTPD2PHZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1960
  {DBGFIELD("VCVTPD2PHZrm_VCVTPD2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1961
  {DBGFIELD("VCVTPH2PDZrm_VCVTPH2PDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1962
  {DBGFIELD("VCVTPD2PHZrmbk_VCVTPD2PHZrmkz_VCVTPD2PHZrmbkz_VCVTPD2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1963
  {DBGFIELD("VCVTPH2PDZrmbk_VCVTPH2PDZrmkz_VCVTPH2PDZrmbkz_VCVTPH2PDZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1964
  {DBGFIELD("VCVTPD2PHZrr_VCVTPD2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1965
  {DBGFIELD("VCVTPH2PDZrr_VCVTPH2PDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1966
  {DBGFIELD("VCVTPD2PHZrrbk_VCVTPD2PHZrrkz_VCVTPD2PHZrrbkz_VCVTPD2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1967
  {DBGFIELD("VCVTPH2PDZrrbk_VCVTPH2PDZrrkz_VCVTPH2PDZrrbkz_VCVTPH2PDZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1968
  {DBGFIELD("VPABSBZ128rmk_VPABSBZ128rmkz_VPABSWZ128rmk_VPABSWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1969
  {DBGFIELD("VPABSBZ256rmk_VPABSBZ256rmkz_VPABSWZ256rmk_VPABSWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1970
  {DBGFIELD("VPLZCNTDZ128rm_VPLZCNTDZ128rmb_VPLZCNTDZ128rmbk_VPLZCNTDZ128rmk_VPLZCNTDZ128rmkz_VPLZCNTQZ128rm_VPLZCNTQZ128rmb_VPLZCNTQZ128rmbk_VPLZCNTQZ128rmk_VPLZCNTQZ128rmkz_VPLZCNTDZ128rmbkz_VPLZCNTQZ128rmbkz") 2, false, false, false, 68, 6, 24, 1,  0, 0}, // #1971
  {DBGFIELD("VPSLLWZ128mik_VPSLLWZ128mikz_VPSRLWZ128mik_VPSRLWZ128mikz_VPSRAWZ128mik_VPSRAWZ128mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1972
  {DBGFIELD("VPSLLWZ256mik_VPSLLWZ256mikz_VPSRLWZ256mik_VPSRLWZ256mikz_VPSRAWZ256mik_VPSRAWZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1973
  {DBGFIELD("VFIXUPIMMSDZrmi_VFIXUPIMMSDZrmik_VFIXUPIMMSDZrmikz_VFIXUPIMMSSZrmi_VFIXUPIMMSSZrmik_VFIXUPIMMSSZrmikz_VSCALEFSDZrm_VSCALEFSDZrmk_VSCALEFSDZrmkz_VSCALEFSSZrm_VSCALEFSSZrmk_VSCALEFSSZrmkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #1974
  {DBGFIELD("VPADDSBZ128rmk_VPADDSBZ128rmkz_VPADDSWZ128rmk_VPADDSWZ128rmkz_VPADDUSBZ128rmk_VPADDUSBZ128rmkz_VPADDUSWZ128rmk_VPADDUSWZ128rmkz_VPSUBSBZ128rmk_VPSUBSBZ128rmkz_VPSUBSWZ128rmk_VPSUBSWZ128rmkz_VPSUBUSBZ128rmk_VPSUBUSBZ128rmkz_VPSUBUSWZ128rmk_VPSUBUSWZ128rmkz_VPAVGBZ128rmk_VPAVGBZ128rmkz_VPAVGWZ128rmk_VPAVGWZ128rmkz_VPMAXSBZ128rmk_VPMAXSBZ128rmkz_VPMAXUWZ128rmk_VPMAXUWZ128rmkz_VPMINSBZ128rmk_VPMINSBZ128rmkz_VPMINUWZ128rmk_VPMINUWZ128rmkz_VPMAXSWZ128rmk_VPMAXSWZ128rmkz_VPMAXUBZ128rmk_VPMAXUBZ128rmkz_VPMINSWZ128rmk_VPMINSWZ128rmkz_VPMINUBZ128rmk_VPMINUBZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1975
  {DBGFIELD("VPSHLDVWZ128mk_VPSHLDVWZ128mkz_VPSHRDVWZ128mk_VPSHRDVWZ128mkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1976
  {DBGFIELD("VPSLLVWZ128rmk_VPSLLVWZ128rmkz_VPSRLVWZ128rmk_VPSRLVWZ128rmkz_VPSRAVWZ128rmk_VPSRAVWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1977
  {DBGFIELD("VPSLLWZ128rmk_VPSLLWZ128rmkz_VPSRLWZ128rmk_VPSRLWZ128rmkz_VPSRAWZ128rmk_VPSRAWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1978
  {DBGFIELD("VPADDSBZ256rmk_VPADDSBZ256rmkz_VPADDSWZ256rmk_VPADDSWZ256rmkz_VPADDUSBZ256rmk_VPADDUSBZ256rmkz_VPADDUSWZ256rmk_VPADDUSWZ256rmkz_VPSUBSBZ256rmk_VPSUBSBZ256rmkz_VPSUBSWZ256rmk_VPSUBSWZ256rmkz_VPSUBUSBZ256rmk_VPSUBUSBZ256rmkz_VPSUBUSWZ256rmk_VPSUBUSWZ256rmkz_VPAVGBZ256rmk_VPAVGBZ256rmkz_VPAVGWZ256rmk_VPAVGWZ256rmkz_VPMAXSBZ256rmk_VPMAXSBZ256rmkz_VPMAXUWZ256rmk_VPMAXUWZ256rmkz_VPMINSBZ256rmk_VPMINSBZ256rmkz_VPMINUWZ256rmk_VPMINUWZ256rmkz_VPMAXSWZ256rmk_VPMAXSWZ256rmkz_VPMAXUBZ256rmk_VPMAXUBZ256rmkz_VPMINSWZ256rmk_VPMINSWZ256rmkz_VPMINUBZ256rmk_VPMINUBZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1979
  {DBGFIELD("VPSHLDVWZ256mk_VPSHLDVWZ256mkz_VPSHRDVWZ256mk_VPSHRDVWZ256mkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1980
  {DBGFIELD("VPSLLVWZ256rmk_VPSLLVWZ256rmkz_VPSRLVWZ256rmk_VPSRLVWZ256rmkz_VPSRAVWZ256rmk_VPSRAVWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1981
  {DBGFIELD("VPSLLWZ256rmk_VPSLLWZ256rmkz_VPSRLWZ256rmk_VPSRLWZ256rmkz_VPSRAWZ256rmk_VPSRAWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1982
  {DBGFIELD("VPMADD52HUQZ128m_VPMADD52HUQZ128mb_VPMADD52HUQZ128mbk_VPMADD52HUQZ128mk_VPMADD52HUQZ128mkz_VPMADD52LUQZ128m_VPMADD52LUQZ128mb_VPMADD52LUQZ128mbk_VPMADD52LUQZ128mk_VPMADD52LUQZ128mkz_VPMADD52HUQZ128mbkz_VPMADD52LUQZ128mbkz") 2, false, false, false, 68, 6, 24, 1,  9, 2}, // #1983
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1984
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1985
  {DBGFIELD("VFIXUPIMMSDZrri_VFIXUPIMMSSZrri_VSCALEFSDZrr_VSCALEFSDZrrk_VSCALEFSDZrrkz_VSCALEFSSZrr_VSCALEFSSZrrk_VSCALEFSSZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1986
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1987
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1988
  {DBGFIELD("VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1989
  {DBGFIELD("VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1990
  {DBGFIELD("VFIXUPIMMSDZrrib_VFIXUPIMMSDZrribk_VFIXUPIMMSDZrribkz_VFIXUPIMMSSZrrib_VFIXUPIMMSSZrribk_VFIXUPIMMSSZrribkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #1991
  {DBGFIELD("VCVTPH2DQZ128rm_VCVTPH2DQZ128rmb_VCVTPH2UDQZ128rm_VCVTPH2UDQZ128rmb_VCVTTPH2DQZ128rm_VCVTTPH2DQZ128rmb_VCVTTPH2UDQZ128rm_VCVTTPH2UDQZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1992
  {DBGFIELD("VCVTPS2PHXZ128rm_VCVTPS2PHXZ128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1993
  {DBGFIELD("VCVTPH2DQZ128rmbk_VCVTPH2DQZ128rmkz_VCVTPH2UDQZ128rmbk_VCVTPH2UDQZ128rmkz_VCVTTPH2DQZ128rmbk_VCVTTPH2DQZ128rmkz_VCVTTPH2UDQZ128rmbk_VCVTTPH2UDQZ128rmkz_VCVTPH2DQZ128rmbkz_VCVTPH2DQZ128rmk_VCVTPH2UDQZ128rmbkz_VCVTPH2UDQZ128rmk_VCVTTPH2DQZ128rmbkz_VCVTTPH2DQZ128rmk_VCVTTPH2UDQZ128rmbkz_VCVTTPH2UDQZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1994
  {DBGFIELD("VCVTPH2DQZ128rrk_VCVTPH2DQZ128rrkz_VCVTPH2UDQZ128rrk_VCVTPH2UDQZ128rrkz_VCVTTPH2DQZ128rrk_VCVTTPH2DQZ128rrkz_VCVTTPH2UDQZ128rrk_VCVTTPH2UDQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1995
  {DBGFIELD("VCVTPH2DQZ256rrk_VCVTPH2DQZ256rrkz_VCVTPH2UDQZ256rrk_VCVTPH2UDQZ256rrkz_VCVTTPH2DQZ256rrk_VCVTTPH2DQZ256rrkz_VCVTTPH2UDQZ256rrk_VCVTTPH2UDQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1996
  {DBGFIELD("VCVTPH2PSXZ256rrk_VCVTPH2PSXZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1997
  {DBGFIELD("VCVTPH2PSZ256rrk_VCVTPH2PSZ256rrkz") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #1998
  {DBGFIELD("VCVTPS2PHXZ256rrk_VCVTPS2PHXZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1999
  {DBGFIELD("VCVTPS2PHZ256rrk_VCVTPS2PHZ256rrkz") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #2000
  {DBGFIELD("VCVTPH2DQZ256rmbk_VCVTPH2DQZ256rmkz_VCVTPH2UDQZ256rmbk_VCVTPH2UDQZ256rmkz_VCVTTPH2DQZ256rmbk_VCVTTPH2DQZ256rmkz_VCVTTPH2UDQZ256rmbk_VCVTTPH2UDQZ256rmkz_VCVTPH2DQZ256rmbkz_VCVTPH2DQZ256rmk_VCVTPH2UDQZ256rmbkz_VCVTPH2UDQZ256rmk_VCVTTPH2DQZ256rmbkz_VCVTTPH2DQZ256rmk_VCVTTPH2UDQZ256rmbkz_VCVTTPH2UDQZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2001
  {DBGFIELD("VCVTPH2PSXZ256rmbk_VCVTPH2PSXZ256rmkz_VCVTPH2PSXZ256rmbkz_VCVTPH2PSXZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2002
  {DBGFIELD("VCVTPS2PHXZ256rmbk_VCVTPS2PHXZ256rmkz_VCVTPS2PHXZ256rmbkz_VCVTPS2PHXZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #2003
  {DBGFIELD("VCVTPH2DQZrmbk_VCVTPH2DQZrmkz_VCVTPH2UDQZrmbk_VCVTPH2UDQZrmkz_VCVTTPH2DQZrmbk_VCVTTPH2DQZrmkz_VCVTTPH2UDQZrmbk_VCVTTPH2UDQZrmkz_VCVTPH2DQZrmbkz_VCVTPH2DQZrmk_VCVTPH2UDQZrmbkz_VCVTPH2UDQZrmk_VCVTTPH2DQZrmbkz_VCVTTPH2DQZrmk_VCVTTPH2UDQZrmbkz_VCVTTPH2UDQZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2004
  {DBGFIELD("VCVTPH2PSXZrmbk_VCVTPH2PSXZrmkz_VCVTPH2PSXZrmbkz_VCVTPH2PSXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2005
  {DBGFIELD("VCVTPS2PHXZrmbk_VCVTPS2PHXZrmkz_VCVTPS2PHXZrmbkz_VCVTPS2PHXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2006
  {DBGFIELD("VCVTPH2DQZrr_VCVTPH2DQZrrb_VCVTPH2UDQZrr_VCVTPH2UDQZrrb_VCVTTPH2DQZrr_VCVTTPH2DQZrrb_VCVTTPH2UDQZrr_VCVTTPH2UDQZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2007
  {DBGFIELD("VCVTPH2PSXZrr_VCVTPH2PSXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2008
  {DBGFIELD("VCVTPH2PSZrr_VCVTPH2PSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2009
  {DBGFIELD("VCVTPS2PHXZrr_VCVTPS2PHXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2010
  {DBGFIELD("VCVTPS2PHZrr_VCVTPS2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2011
  {DBGFIELD("VPSHUFBITQMBZ128rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2012
  {DBGFIELD("VPSHUFBITQMBZ256rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2013
  {DBGFIELD("VPSHUFBITQMBZrrk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2014
  {DBGFIELD("VCVTPH2DQZrrbk_VCVTPH2DQZrrkz_VCVTPH2UDQZrrbk_VCVTPH2UDQZrrkz_VCVTTPH2DQZrrbk_VCVTTPH2DQZrrkz_VCVTTPH2UDQZrrbk_VCVTTPH2UDQZrrkz_VCVTPH2DQZrrbkz_VCVTPH2DQZrrk_VCVTPH2UDQZrrbkz_VCVTPH2UDQZrrk_VCVTTPH2DQZrrbkz_VCVTTPH2DQZrrk_VCVTTPH2UDQZrrbkz_VCVTTPH2UDQZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2015
  {DBGFIELD("VCVTPH2PSXZrrbk_VCVTPH2PSXZrrkz_VCVTPH2PSXZrrbkz_VCVTPH2PSXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2016
  {DBGFIELD("VCVTPS2PHXZrrbk_VCVTPS2PHXZrrkz_VCVTPS2PHXZrrbkz_VCVTPS2PHXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2017
  {DBGFIELD("VCVTPH2PDZ128rm_VCVTPH2PDZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2018
  {DBGFIELD("VCVTPH2PDZ128rmbk_VCVTPH2PDZ128rmkz_VCVTPH2PDZ128rmbkz_VCVTPH2PDZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2019
  {DBGFIELD("VCVTPH2PDZ128rr")    2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2020
  {DBGFIELD("VCVTPH2PDZ128rrk_VCVTPH2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2021
  {DBGFIELD("VCVTPH2PDZ256rm_VCVTPH2PDZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2022
  {DBGFIELD("VCVTPH2PDZ256rmbk_VCVTPH2PDZ256rmkz_VCVTPH2PDZ256rmbkz_VCVTPH2PDZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2023
  {DBGFIELD("VCVTPH2PDZ256rr")    2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2024
  {DBGFIELD("VCVTPH2PDZ256rrk_VCVTPH2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2025
  {DBGFIELD("VCVTPH2PSXZ128rrk_VCVTPH2PSXZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2026
  {DBGFIELD("VCVTPH2PSZ128rrk_VCVTPH2PSZ128rrkz") 2, false, false, false, 183, 9,  3, 1,  0, 0}, // #2027
  {DBGFIELD("VCVTPS2PHXZ128rrk_VCVTPS2PHXZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2028
  {DBGFIELD("VCVTPS2PHZ128rrk_VCVTPS2PHZ128rrkz") 2, false, false, false, 183, 9,  3, 1,  0, 0}, // #2029
  {DBGFIELD("VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2030
  {DBGFIELD("VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2031
  {DBGFIELD("VCVTSH2SSZrm_Intk_VCVTSH2SSZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2032
  {DBGFIELD("VPMADDUBSWZ128rmk_VPMADDUBSWZ128rmkz_VPMULHRSWZ128rmk_VPMULHRSWZ128rmkz_VPMULHUWZ128rmk_VPMULHUWZ128rmkz_VPMULHWZ128rmk_VPMULHWZ128rmkz_VPMULLWZ128rmk_VPMULLWZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2033
  {DBGFIELD("VPMADDUBSWZ256rmk_VPMADDUBSWZ256rmkz_VPMULHRSWZ256rmk_VPMULHRSWZ256rmkz_VPMULHUWZ256rmk_VPMULHUWZ256rmkz_VPMULHWZ256rmk_VPMULHWZ256rmkz_VPMULLWZ256rmk_VPMULLWZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2034
  {DBGFIELD("VCVTPH2PSZrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2035
  {DBGFIELD("VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2036
  {DBGFIELD("VCVTPH2QQZ128rm_VCVTPH2QQZ128rmb_VCVTPH2QQZ128rmbk_VCVTPH2QQZ128rmk_VCVTPH2QQZ128rmkz_VCVTPH2UQQZ128rm_VCVTPH2UQQZ128rmb_VCVTPH2UQQZ128rmbk_VCVTPH2UQQZ128rmk_VCVTPH2UQQZ128rmkz_VCVTTPH2QQZ128rm_VCVTTPH2QQZ128rmb_VCVTTPH2QQZ128rmbk_VCVTTPH2QQZ128rmk_VCVTTPH2QQZ128rmkz_VCVTTPH2UQQZ128rm_VCVTTPH2UQQZ128rmb_VCVTTPH2UQQZ128rmbk_VCVTTPH2UQQZ128rmk_VCVTTPH2UQQZ128rmkz_VCVTPH2QQZ128rmbkz_VCVTPH2UQQZ128rmbkz_VCVTTPH2QQZ128rmbkz_VCVTTPH2UQQZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2037
  {DBGFIELD("VCVTPH2QQZ128rr_VCVTPH2QQZ128rrk_VCVTPH2QQZ128rrkz_VCVTPH2UQQZ128rr_VCVTPH2UQQZ128rrk_VCVTPH2UQQZ128rrkz_VCVTTPH2QQZ128rr_VCVTTPH2QQZ128rrk_VCVTTPH2QQZ128rrkz_VCVTTPH2UQQZ128rr_VCVTTPH2UQQZ128rrk_VCVTTPH2UQQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2038
  {DBGFIELD("VCVTPH2QQZ256rr_VCVTPH2QQZ256rrk_VCVTPH2QQZ256rrkz_VCVTPH2UQQZ256rr_VCVTPH2UQQZ256rrk_VCVTPH2UQQZ256rrkz_VCVTTPH2QQZ256rr_VCVTTPH2QQZ256rrk_VCVTTPH2QQZ256rrkz_VCVTTPH2UQQZ256rr_VCVTTPH2UQQZ256rrk_VCVTTPH2UQQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2039
  {DBGFIELD("VCVTPH2QQZ256rm_VCVTPH2QQZ256rmb_VCVTPH2QQZ256rmbk_VCVTPH2QQZ256rmk_VCVTPH2QQZ256rmkz_VCVTPH2UQQZ256rm_VCVTPH2UQQZ256rmb_VCVTPH2UQQZ256rmbk_VCVTPH2UQQZ256rmk_VCVTPH2UQQZ256rmkz_VCVTTPH2QQZ256rm_VCVTTPH2QQZ256rmb_VCVTTPH2QQZ256rmbk_VCVTTPH2QQZ256rmk_VCVTTPH2QQZ256rmkz_VCVTTPH2UQQZ256rm_VCVTTPH2UQQZ256rmb_VCVTTPH2UQQZ256rmbk_VCVTTPH2UQQZ256rmk_VCVTTPH2UQQZ256rmkz_VCVTPH2QQZ256rmbkz_VCVTPH2UQQZ256rmbkz_VCVTTPH2QQZ256rmbkz_VCVTTPH2UQQZ256rmbkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2040
  {DBGFIELD("VCVTPS2PHXZ128rmbk_VCVTPS2PHXZ128rmkz_VCVTPS2PHXZ128rmbkz_VCVTPS2PHXZ128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #2041
  {DBGFIELD("VCVTPS2PHXZ256rm_VCVTPS2PHXZ256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #2042
  {DBGFIELD("VCVTPS2PHXZrm_VCVTPS2PHXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2043
  {DBGFIELD("VCVTPS2PHZ128mrk")   3, false, false, false, 626, 7,  2, 1,  0, 0}, // #2044
  {DBGFIELD("VCVTPS2PHZ256mrk")   3, false, false, false, 626, 7,  2, 1,  0, 0}, // #2045
  {DBGFIELD("VCVTPS2PHZmrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2046
  {DBGFIELD("VCVTQQ2PHZ128rm_VCVTQQ2PHZ128rmb_VCVTUQQ2PHZ128rm_VCVTUQQ2PHZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2047
  {DBGFIELD("VCVTQQ2PHZ128rmbk_VCVTQQ2PHZ128rmkz_VCVTUQQ2PHZ128rmbk_VCVTUQQ2PHZ128rmkz_VCVTQQ2PHZ128rmbkz_VCVTQQ2PHZ128rmk_VCVTUQQ2PHZ128rmbkz_VCVTUQQ2PHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2048
  {DBGFIELD("VCVTQQ2PHZ128rr_VCVTUQQ2PHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2049
  {DBGFIELD("VCVTQQ2PHZ128rrk_VCVTQQ2PHZ128rrkz_VCVTUQQ2PHZ128rrk_VCVTUQQ2PHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2050
  {DBGFIELD("VCVTQQ2PHZ256rr_VCVTUQQ2PHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2051
  {DBGFIELD("VCVTQQ2PHZ256rm_VCVTQQ2PHZ256rmb_VCVTUQQ2PHZ256rm_VCVTUQQ2PHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2052
  {DBGFIELD("VCVTQQ2PHZ256rmbk_VCVTQQ2PHZ256rmkz_VCVTUQQ2PHZ256rmbk_VCVTUQQ2PHZ256rmkz_VCVTQQ2PHZ256rmbkz_VCVTQQ2PHZ256rmk_VCVTUQQ2PHZ256rmbkz_VCVTUQQ2PHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2053
  {DBGFIELD("VCVTQQ2PHZ256rrk_VCVTQQ2PHZ256rrkz_VCVTUQQ2PHZ256rrk_VCVTUQQ2PHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2054
  {DBGFIELD("VCVTQQ2PHZrm_VCVTQQ2PHZrmb_VCVTUQQ2PHZrm_VCVTUQQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2055
  {DBGFIELD("VCVTQQ2PHZrmbk_VCVTQQ2PHZrmkz_VCVTUQQ2PHZrmbk_VCVTUQQ2PHZrmkz_VCVTQQ2PHZrmbkz_VCVTQQ2PHZrmk_VCVTUQQ2PHZrmbkz_VCVTUQQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2056
  {DBGFIELD("VCVTQQ2PHZrr_VCVTQQ2PHZrrb_VCVTUQQ2PHZrr_VCVTUQQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2057
  {DBGFIELD("VCVTQQ2PHZrrbk_VCVTQQ2PHZrrkz_VCVTUQQ2PHZrrbk_VCVTUQQ2PHZrrkz_VCVTQQ2PHZrrbkz_VCVTQQ2PHZrrk_VCVTUQQ2PHZrrbkz_VCVTUQQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2058
  {DBGFIELD("VCVTSD2SHZrm_VCVTSD2SHZrm_Int") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #2059
  {DBGFIELD("VCVTSD2SHZrm_Intk_VCVTSD2SHZrm_Intkz") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #2060
  {DBGFIELD("VCVTSD2SHZrr_Int_VCVTSD2SHZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2061
  {DBGFIELD("VCVTSD2SHZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2062
  {DBGFIELD("VCVTSD2SHZrr_Intk_VCVTSD2SHZrr_Intkz_VCVTSD2SHZrrb_Intk_VCVTSD2SHZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2063
  {DBGFIELD("VCVTSH2SDZrm_VCVTSH2SDZrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2064
  {DBGFIELD("VCVTSH2SDZrm_Intk_VCVTSH2SDZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2065
  {DBGFIELD("VCVTSH2SDZrr_Int_VCVTSH2SDZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2066
  {DBGFIELD("VCVTSH2SDZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2067
  {DBGFIELD("VCVTSH2SDZrr_Intk_VCVTSH2SDZrr_Intkz_VCVTSH2SDZrrb_Intk_VCVTSH2SDZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2068
  {DBGFIELD("VCVTSH2SI64Zrm_Int_VCVTSH2SIZrm_Int_VCVTSH2USI64Zrm_Int_VCVTSH2USIZrm_Int_VCVTTSH2SI64Zrm_Int_VCVTTSH2SIZrm_Int_VCVTTSH2USI64Zrm_Int_VCVTTSH2USIZrm_Int_VCVTTSH2SI64Zrm_VCVTTSH2SIZrm_VCVTTSH2USI64Zrm_VCVTTSH2USIZrm") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #2069
  {DBGFIELD("VCVTSH2SI64Zrr_Int_VCVTSH2SI64Zrrb_Int_VCVTSH2SIZrr_Int_VCVTSH2SIZrrb_Int_VCVTSH2USI64Zrr_Int_VCVTSH2USI64Zrrb_Int_VCVTSH2USIZrr_Int_VCVTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_Int_VCVTTSH2SI64Zrrb_Int_VCVTTSH2SIZrr_Int_VCVTTSH2SIZrrb_Int_VCVTTSH2USI64Zrr_Int_VCVTTSH2USI64Zrrb_Int_VCVTTSH2USIZrr_Int_VCVTTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_VCVTTSH2SIZrr_VCVTTSH2USI64Zrr_VCVTTSH2USIZrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #2070
  {DBGFIELD("VCVTSH2SSZrr_Intk_VCVTSH2SSZrr_Intkz_VCVTSH2SSZrrb_Intk_VCVTSH2SSZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2071
  {DBGFIELD("VCVTSI2SHZrm_VCVTSI2SHZrm_Int_VCVTSI642SHZrm_VCVTSI642SHZrm_Int_VCVTUSI2SHZrm_VCVTUSI2SHZrm_Int_VCVTUSI642SHZrm_VCVTUSI642SHZrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2072
  {DBGFIELD("VCVTSS2SHZrm_VCVTSS2SHZrm_Int") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #2073
  {DBGFIELD("VCVTSS2SHZrm_Intk_VCVTSS2SHZrm_Intkz") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #2074
  {DBGFIELD("VCVTSS2SHZrr_Int_VCVTSS2SHZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2075
  {DBGFIELD("VCVTSS2SHZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2076
  {DBGFIELD("VCVTSS2SHZrr_Intk_VCVTSS2SHZrr_Intkz_VCVTSS2SHZrrb_Intk_VCVTSS2SHZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2077
  {DBGFIELD("VDBPSADBWZ128rrik_VDBPSADBWZ128rrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2078
  {DBGFIELD("VDBPSADBWZ256rrik_VDBPSADBWZ256rrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2079
  {DBGFIELD("VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2080
  {DBGFIELD("VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2081
  {DBGFIELD("VPBROADCASTBZ256rrk_VPBROADCASTBZ256rrkz_VPBROADCASTBZrrk_VPBROADCASTBZrrkz_VPBROADCASTDrZ256rrk_VPBROADCASTDrZ256rrkz_VPBROADCASTDrZrrk_VPBROADCASTDrZrrkz_VPBROADCASTQrZ256rrk_VPBROADCASTQrZ256rrkz_VPBROADCASTQrZrrk_VPBROADCASTQrZrrkz_VPBROADCASTWZ256rrk_VPBROADCASTWZ256rrkz_VPBROADCASTWZrrk_VPBROADCASTWZrrkz_VPBROADCASTWrZ256rrk_VPBROADCASTWrZ256rrkz_VPBROADCASTWrZrrk_VPBROADCASTWrZrrkz_VPBROADCASTBrZ256rr_VPBROADCASTDrZ256rr_VPBROADCASTQrZ256rr_VPBROADCASTWrZ256rr_VPBROADCASTBrZ256rrk_VPBROADCASTBrZ256rrkz_VPBROADCASTBrZrr_VPBROADCASTDrZrr_VPBROADCASTQrZrr_VPBROADCASTWrZrr_VPBROADCASTBrZrrk_VPBROADCASTBrZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2082
  {DBGFIELD("VPBROADCASTBrZ128rr_VPBROADCASTDrZ128rr_VPBROADCASTQrZ128rr_VPBROADCASTWrZ128rr_VPBROADCASTBrZ128rrk_VPBROADCASTBrZ128rrkz_VPBROADCASTDrZ128rrk_VPBROADCASTDrZ128rrkz_VPBROADCASTQrZ128rrk_VPBROADCASTQrZ128rrkz_VPBROADCASTWrZ128rrk_VPBROADCASTWrZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2083
  {DBGFIELD("VPERMBZ128rrk_VPERMBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2084
  {DBGFIELD("VPERMBZ256rrk_VPERMBZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2085
  {DBGFIELD("VPERMBZrrk_VPERMBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2086
  {DBGFIELD("VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2087
  {DBGFIELD("VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVZXBWZrrk_VPMOVZXBWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2088
  {DBGFIELD("VPMULTISHIFTQBZ128rrk_VPMULTISHIFTQBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2089
  {DBGFIELD("VPMULTISHIFTQBZ256rrk_VPMULTISHIFTQBZ256rrkz_VPOPCNTBZ256rrk_VPOPCNTBZ256rrkz_VPOPCNTWZ256rrk_VPOPCNTWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2090
  {DBGFIELD("VPMULTISHIFTQBZrrk_VPMULTISHIFTQBZrrkz_VPOPCNTBZrrk_VPOPCNTBZrrkz_VPOPCNTWZrrk_VPOPCNTWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2091
  {DBGFIELD("VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2092
  {DBGFIELD("VDIVPHZ128rm_VDIVPHZ128rmb") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #2093
  {DBGFIELD("VDIVPHZ128rmbk_VDIVPHZ128rmkz_VDIVPHZ128rmbkz_VDIVPHZ128rmk") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #2094
  {DBGFIELD("VDIVPHZ128rr")       1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2095
  {DBGFIELD("VDIVPHZ256rr")       1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2096
  {DBGFIELD("VDIVPHZ128rrk")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2097
  {DBGFIELD("VDIVPHZ256rrk")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2098
  {DBGFIELD("VSQRTPHZ128r")       1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2099
  {DBGFIELD("VSQRTPHZ256r")       1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2100
  {DBGFIELD("VDIVPHZ128rrkz")     1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2101
  {DBGFIELD("VDIVPHZ256rm_VDIVPHZ256rmb") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #2102
  {DBGFIELD("VDIVPHZ256rmbk_VDIVPHZ256rmkz_VDIVPHZ256rmbkz_VDIVPHZ256rmk") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #2103
  {DBGFIELD("VSQRTPHZ128m_VSQRTPHZ128mb") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #2104
  {DBGFIELD("VDIVPHZ256rrkz")     1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2105
  {DBGFIELD("VDIVPHZrm_VDIVPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2106
  {DBGFIELD("VDIVPHZrmbk_VDIVPHZrmkz_VDIVPHZrmbkz_VDIVPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2107
  {DBGFIELD("VDIVPHZrr_VDIVPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2108
  {DBGFIELD("VDIVPHZrrbk_VDIVPHZrrkz_VDIVPHZrrbkz_VDIVPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2109
  {DBGFIELD("VDIVPSZrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2110
  {DBGFIELD("VDIVSHZrm_Int_VDIVSHZrm_Intk_VDIVSHZrm_Intkz") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #2111
  {DBGFIELD("VDIVSHZrm")          2, false, false, false, 173, 10, 13, 1,  5, 1}, // #2112
  {DBGFIELD("VDIVSHZrr_Int")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2113
  {DBGFIELD("VSQRTSHZr_Int")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2114
  {DBGFIELD("VDPBF16PSZ128m_VDPBF16PSZ128mb_VDPBF16PSZ128mbk_VDPBF16PSZ128mk_VDPBF16PSZ128mkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2115
  {DBGFIELD("VDPBF16PSZ128mbkz")  2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2116
  {DBGFIELD("VDPBF16PSZ256m_VDPBF16PSZ256mb_VDPBF16PSZ256mbk_VDPBF16PSZ256mk_VDPBF16PSZ256mkz") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #2117
  {DBGFIELD("VDPBF16PSZ256mbkz")  2, false, false, false, 68, 6,  2, 1,  5, 1}, // #2118
  {DBGFIELD("VPEXPANDBZ128rm_VPEXPANDWZ128rm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2119
  {DBGFIELD("VFCMADDCPHZ128m_VFCMADDCPHZ128mb_VFMADDCPHZ128m_VFMADDCPHZ128mb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2120
  {DBGFIELD("VFCMADDCPHZ256m_VFCMADDCPHZ256mb_VFMADDCPHZ256m_VFMADDCPHZ256mb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2121
  {DBGFIELD("VROUNDPDYm_VROUNDPSYm") 3, false, false, false, 74, 6, 16, 1,  0, 0}, // #2122
  {DBGFIELD("VFCMADDCSHZm_VFMADDCSHZm_VFCMULCPHZ128rm_VFCMULCPHZ128rmb_VFMULCPHZ128rm_VFMULCPHZ128rmb_VFCMULCSHZrm_VFMULCSHZrm") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2123
  {DBGFIELD("VRNDSCALEPHZ128rmbi_VRNDSCALEPHZ128rmi_VRNDSCALESHZm_VRNDSCALESHZm_Int") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #2124
  {DBGFIELD("VSCALEFPHZ128rm_VSCALEFPHZ128rmb") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #2125
  {DBGFIELD("VFCMULCPHZ256rm_VFCMULCPHZ256rmb_VFMULCPHZ256rm_VFMULCPHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #2126
  {DBGFIELD("VRNDSCALEPDZ256rmbi_VRNDSCALEPDZ256rmi_VRNDSCALEPHZ256rmbi_VRNDSCALEPHZ256rmi_VRNDSCALEPSZ256rmbi_VRNDSCALEPSZ256rmi_VRNDSCALEPDZ256rmbik_VRNDSCALEPDZ256rmbikz_VRNDSCALEPDZ256rmik_VRNDSCALEPDZ256rmikz_VRNDSCALEPSZ256rmbik_VRNDSCALEPSZ256rmbikz_VRNDSCALEPSZ256rmik_VRNDSCALEPSZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #2127
  {DBGFIELD("VSCALEFPHZ256rm_VSCALEFPHZ256rmb") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #2128
  {DBGFIELD("VSCALEFSHZrm")       2, false, false, false, 53, 7,  9, 1,  5, 1}, // #2129
  {DBGFIELD("VFCMADDCPHZ128mbk_VFCMADDCPHZ128mkz_VFMADDCPHZ128mbk_VFMADDCPHZ128mkz_VFCMADDCPHZ128mbkz_VFCMADDCPHZ128mk_VFMADDCPHZ128mbkz_VFMADDCPHZ128mk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2130
  {DBGFIELD("VFCMADDCPHZ256mbk_VFCMADDCPHZ256mkz_VFMADDCPHZ256mbk_VFMADDCPHZ256mkz_VFCMADDCPHZ256mbkz_VFCMADDCPHZ256mk_VFMADDCPHZ256mbkz_VFMADDCPHZ256mk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2131
  {DBGFIELD("VFCMADDCSHZmk_VFCMADDCSHZmkz_VFMADDCSHZmk_VFMADDCSHZmkz_VFCMULCPHZ128rmbk_VFCMULCPHZ128rmkz_VFMULCPHZ128rmbk_VFMULCPHZ128rmkz_VFCMULCPHZ128rmbkz_VFCMULCPHZ128rmk_VFMULCPHZ128rmbkz_VFMULCPHZ128rmk_VFCMULCSHZrmk_VFCMULCSHZrmkz_VFMULCSHZrmk_VFMULCSHZrmkz") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #2132
  {DBGFIELD("VFCMULCPHZ256rmbk_VFCMULCPHZ256rmkz_VFMULCPHZ256rmbk_VFMULCPHZ256rmkz_VFCMULCPHZ256rmbkz_VFCMULCPHZ256rmk_VFMULCPHZ256rmbkz_VFMULCPHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #2133
  {DBGFIELD("VFCMADDCPHZ128r_VFMADDCPHZ128r_VFCMADDCSHZr_VFCMADDCSHZrb_VFMADDCSHZr_VFMADDCSHZrb_VFCMULCPHZ128rr_VFMULCPHZ128rr_VFCMULCSHZrr_VFCMULCSHZrrb_VFMULCSHZrr_VFMULCSHZrrb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2134
  {DBGFIELD("VFCMADDCPHZ256r_VFMADDCPHZ256r_VFCMULCPHZ256rr_VFMULCPHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2135
  {DBGFIELD("VRNDSCALEPHZ128rri_VRNDSCALESHZr_Int_VRNDSCALESHZrb_Int") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2136
  {DBGFIELD("VRNDSCALEPHZ256rri") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2137
  {DBGFIELD("VSCALEFPHZ128rr")    1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2138
  {DBGFIELD("VSCALEFPHZ256rr")    1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2139
  {DBGFIELD("VRNDSCALESHZr")      2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2140
  {DBGFIELD("VSCALEFSHZrr_VSCALEFSHZrrb_Int") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2141
  {DBGFIELD("VFCMADDCPHZ128rk_VFCMADDCPHZ128rkz_VFMADDCPHZ128rk_VFMADDCPHZ128rkz_VFCMADDCSHZrbk_VFCMADDCSHZrkz_VFMADDCSHZrbk_VFMADDCSHZrkz_VFCMADDCSHZrbkz_VFCMADDCSHZrk_VFMADDCSHZrbkz_VFMADDCSHZrk_VFCMULCPHZ128rrk_VFCMULCPHZ128rrkz_VFMULCPHZ128rrk_VFMULCPHZ128rrkz_VFCMULCSHZrrbk_VFCMULCSHZrrkz_VFMULCSHZrrbk_VFMULCSHZrrkz_VFCMULCSHZrrbkz_VFCMULCSHZrrk_VFMULCSHZrrbkz_VFMULCSHZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2142
  {DBGFIELD("VFCMADDCPHZ256rk_VFCMADDCPHZ256rkz_VFMADDCPHZ256rk_VFMADDCPHZ256rkz_VFCMULCPHZ256rrk_VFCMULCPHZ256rrkz_VFMULCPHZ256rrk_VFMULCPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2143
  {DBGFIELD("VFCMADDCPHZm_VFCMADDCPHZmb_VFMADDCPHZm_VFMADDCPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2144
  {DBGFIELD("VFCMULCPHZrm_VFCMULCPHZrmb_VFMULCPHZrm_VFMULCPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2145
  {DBGFIELD("VRNDSCALEPDZrmbi_VRNDSCALEPDZrmi_VRNDSCALEPHZrmbi_VRNDSCALEPHZrmi_VRNDSCALEPSZrmbi_VRNDSCALEPSZrmi_VRNDSCALEPDZrmbik_VRNDSCALEPDZrmbikz_VRNDSCALEPDZrmik_VRNDSCALEPDZrmikz_VRNDSCALEPSZrmbik_VRNDSCALEPSZrmbikz_VRNDSCALEPSZrmik_VRNDSCALEPSZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2146
  {DBGFIELD("VSCALEFPHZrm_VSCALEFPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2147
  {DBGFIELD("VFCMADDCPHZmbk_VFCMADDCPHZmkz_VFMADDCPHZmbk_VFMADDCPHZmkz_VFCMADDCPHZmbkz_VFCMADDCPHZmk_VFMADDCPHZmbkz_VFMADDCPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2148
  {DBGFIELD("VFCMULCPHZrmbk_VFCMULCPHZrmkz_VFMULCPHZrmbk_VFMULCPHZrmkz_VFCMULCPHZrmbkz_VFCMULCPHZrmk_VFMULCPHZrmbkz_VFMULCPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2149
  {DBGFIELD("VFCMADDCPHZr_VFCMADDCPHZrb_VFMADDCPHZr_VFMADDCPHZrb_VFCMULCPHZrr_VFCMULCPHZrrb_VFMULCPHZrr_VFMULCPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2150
  {DBGFIELD("VRNDSCALEPHZrri_VRNDSCALEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2151
  {DBGFIELD("VSCALEFPHZrr_VSCALEFPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2152
  {DBGFIELD("VFCMADDCPHZrbk_VFCMADDCPHZrkz_VFMADDCPHZrbk_VFMADDCPHZrkz_VFCMADDCPHZrbkz_VFCMADDCPHZrk_VFMADDCPHZrbkz_VFMADDCPHZrk_VFCMULCPHZrrbk_VFCMULCPHZrrkz_VFMULCPHZrrbk_VFMULCPHZrrkz_VFCMULCPHZrrbkz_VFCMULCPHZrrk_VFMULCPHZrrbkz_VFMULCPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2153
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #2154
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQQZ256rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #2155
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #2156
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #2157
  {DBGFIELD("VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #2158
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbik_VGF2P8AFFINEINVQBZ128rmbikz_VGF2P8AFFINEINVQBZ128rmik_VGF2P8AFFINEINVQBZ128rmikz_VGF2P8AFFINEQBZ128rmbik_VGF2P8AFFINEQBZ128rmbikz_VGF2P8AFFINEQBZ128rmik_VGF2P8AFFINEQBZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2159
  {DBGFIELD("VGF2P8MULBZ128rmk_VGF2P8MULBZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #2160
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbik_VGF2P8AFFINEINVQBZ256rmbikz_VGF2P8AFFINEINVQBZ256rmik_VGF2P8AFFINEINVQBZ256rmikz_VGF2P8AFFINEQBZ256rmbik_VGF2P8AFFINEQBZ256rmbikz_VGF2P8AFFINEQBZ256rmik_VGF2P8AFFINEQBZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2161
  {DBGFIELD("VGF2P8MULBZ256rmk_VGF2P8MULBZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #2162
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrik_VGF2P8AFFINEQBZ128rrik") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2163
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrik_VGF2P8AFFINEQBZ256rrik") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2164
  {DBGFIELD("VGF2P8MULBZ128rrk")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2165
  {DBGFIELD("VGF2P8MULBZ256rrk")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2166
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrikz_VGF2P8AFFINEQBZ128rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2167
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrikz_VGF2P8AFFINEQBZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2168
  {DBGFIELD("VGF2P8MULBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2169
  {DBGFIELD("VGF2P8MULBZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2170
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbik_VGF2P8AFFINEINVQBZrmbikz_VGF2P8AFFINEINVQBZrmik_VGF2P8AFFINEINVQBZrmikz_VGF2P8AFFINEQBZrmbik_VGF2P8AFFINEQBZrmbikz_VGF2P8AFFINEQBZrmik_VGF2P8AFFINEQBZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2171
  {DBGFIELD("VGF2P8MULBZrmk_VGF2P8MULBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2172
  {DBGFIELD("VGF2P8AFFINEINVQBZrrik_VGF2P8AFFINEQBZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2173
  {DBGFIELD("VGF2P8MULBZrrk")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2174
  {DBGFIELD("VGF2P8AFFINEINVQBZrrikz_VGF2P8AFFINEQBZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2175
  {DBGFIELD("VGF2P8MULBZrrkz")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2176
  {DBGFIELD("VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #2177
  {DBGFIELD("VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #2178
  {DBGFIELD("VMOVSHZrmk_VMOVSHZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #2179
  {DBGFIELD("VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #2180
  {DBGFIELD("VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #2181
  {DBGFIELD("VMOVDQU16Z128rrk_VMOVDQU16Z128rrk_REV_VMOVDQU16Z128rrkz_VMOVDQU16Z128rrkz_REV_VMOVDQU8Z128rrk_VMOVDQU8Z128rrk_REV_VMOVDQU8Z128rrkz_VMOVDQU8Z128rrkz_REV_VPMOVM2BZ128rr_VPMOVM2WZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2182
  {DBGFIELD("VMOVDQU16Z256rrk_VMOVDQU16Z256rrk_REV_VMOVDQU16Z256rrkz_VMOVDQU16Z256rrkz_REV_VMOVDQU8Z256rrk_VMOVDQU8Z256rrk_REV_VMOVDQU8Z256rrkz_VMOVDQU8Z256rrkz_REV_VPMOVM2BZ256rr_VPMOVM2WZ256rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2183
  {DBGFIELD("VMOVSHZrrk_VMOVSHZrrk_REV_VMOVSHZrrkz_VMOVSHZrrkz_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2184
  {DBGFIELD("VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #2185
  {DBGFIELD("VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #2186
  {DBGFIELD("VMOVDQU8Zmrk")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2187
  {DBGFIELD("VMOVNTDQZ128mr")     2, false, false, false, 37, 3, 25, 1,  0, 0}, // #2188
  {DBGFIELD("VMOVNTDQZ256mr")     2, false, false, false, 37, 3, 40, 1,  0, 0}, // #2189
  {DBGFIELD("VMOVNTDQZmr")        2, false, false, false, 37, 3, 40, 1,  0, 0}, // #2190
  {DBGFIELD("VMOVNTPDZ128mr")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #2191
  {DBGFIELD("VMOVNTPDZ256mr")     2, false, false, false, 37, 3, 41, 1,  0, 0}, // #2192
  {DBGFIELD("VMOVNTPDZmr")        2, false, false, false, 37, 3, 41, 1,  0, 0}, // #2193
  {DBGFIELD("VMOVNTPSZ128mr")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #2194
  {DBGFIELD("VMOVNTPSZ256mr")     2, false, false, false, 37, 3, 41, 1,  0, 0}, // #2195
  {DBGFIELD("VMOVNTPSZmr")        2, false, false, false, 37, 3, 41, 1,  0, 0}, // #2196
  {DBGFIELD("VP2INTERSECTDZ128rm_VP2INTERSECTDZ128rmb") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #2197
  {DBGFIELD("VP2INTERSECTQZ256rm_VP2INTERSECTQZ256rmb") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #2198
  {DBGFIELD("VP2INTERSECTDZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2199
  {DBGFIELD("VP2INTERSECTQZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2200
  {DBGFIELD("VP2INTERSECTDZ256rm_VP2INTERSECTDZ256rmb") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #2201
  {DBGFIELD("VP2INTERSECTDZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2202
  {DBGFIELD("VP2INTERSECTDZrm_VP2INTERSECTDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2203
  {DBGFIELD("VP2INTERSECTDZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2204
  {DBGFIELD("VP2INTERSECTQZ128rm_VP2INTERSECTQZ128rmb") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #2205
  {DBGFIELD("VP2INTERSECTQZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2206
  {DBGFIELD("VP2INTERSECTQZrm_VP2INTERSECTQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2207
  {DBGFIELD("VP2INTERSECTQZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2208
  {DBGFIELD("VPABSBZ128rrk_VPABSBZ128rrkz_VPABSWZ128rrk_VPABSWZ128rrkz_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2209
  {DBGFIELD("VPABSBZ256rrk_VPABSBZ256rrkz_VPABSWZ256rrk_VPABSWZ256rrkz_VPSUBSBZ256rrk_VPSUBSBZ256rrkz_VPSUBSWZ256rrk_VPSUBSWZ256rrkz_VPADDSBZ256rrk_VPADDSBZ256rrkz_VPADDSWZ256rrk_VPADDSWZ256rrkz_VPADDUSBZ256rrk_VPADDUSBZ256rrkz_VPADDUSWZ256rrk_VPADDUSWZ256rrkz_VPAVGBZ256rrk_VPAVGBZ256rrkz_VPAVGWZ256rrk_VPAVGWZ256rrkz_VPMAXSBZ256rrk_VPMAXSBZ256rrkz_VPMAXUWZ256rrk_VPMAXUWZ256rrkz_VPMINSBZ256rrk_VPMINSBZ256rrkz_VPMINUWZ256rrk_VPMINUWZ256rrkz_VPMAXSWZ256rrk_VPMAXSWZ256rrkz_VPMAXUBZ256rrk_VPMAXUBZ256rrkz_VPMINSWZ256rrk_VPMINSWZ256rrkz_VPMINUBZ256rrk_VPMINUBZ256rrkz_VPSUBUSBZ256rrk_VPSUBUSBZ256rrkz_VPSUBUSWZ256rrk_VPSUBUSWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2210
  {DBGFIELD("VPMAXSBZ128rrk_VPMAXSBZ128rrkz_VPMAXUWZ128rrk_VPMAXUWZ128rrkz_VPMINSBZ128rrk_VPMINSBZ128rrkz_VPMINUWZ128rrk_VPMINUWZ128rrkz_VPMAXSWZ128rrk_VPMAXSWZ128rrkz_VPMAXUBZ128rrk_VPMAXUBZ128rrkz_VPMINSWZ128rrk_VPMINSWZ128rrkz_VPMINUBZ128rrk_VPMINUBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2211
  {DBGFIELD("VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2212
  {DBGFIELD("VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2213
  {DBGFIELD("VPSLLVWZ128rrk_VPSLLVWZ128rrkz_VPSRLVWZ128rrk_VPSRLVWZ128rrkz_VPSRAVWZ128rrk_VPSRAVWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2214
  {DBGFIELD("VPSLLVWZ256rrk_VPSLLVWZ256rrkz_VPSRLVWZ256rrk_VPSRLVWZ256rrkz_VPSRAVWZ256rrk_VPSRAVWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2215
  {DBGFIELD("VPSLLWZ128rik_VPSLLWZ128rikz_VPSRLWZ128rik_VPSRLWZ128rikz_VPSRAWZ128rik_VPSRAWZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2216
  {DBGFIELD("VPSLLWZ256rik_VPSLLWZ256rikz_VPSRLWZ256rik_VPSRLWZ256rikz_VPSRAWZ256rik_VPSRAWZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2217
  {DBGFIELD("VSHUFPDZ256rmbi_VSHUFPDZ256rmik_VSHUFPSZ256rmbi_VSHUFPSZ256rmik_VSHUFPDZ256rmbik_VSHUFPDZ256rmbikz_VSHUFPSZ256rmbik_VSHUFPSZ256rmbikz_VSHUFPDZ256rmi_VSHUFPDZ256rmikz_VSHUFPSZ256rmi_VSHUFPSZ256rmikz") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #2218
  {DBGFIELD("VPBROADCASTMB2QZ128rr_VPBROADCASTMB2QZ256rr_VPBROADCASTMW2DZ128rr_VPBROADCASTMW2DZ256rr_VPBROADCASTMB2QZrr_VPBROADCASTMW2DZrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2219
  {DBGFIELD("VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2220
  {DBGFIELD("VPSRAWZrrk_VPSRAWZrrkz_VPSLLWZrrk_VPSLLWZrrkz_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2221
  {DBGFIELD("VPSHUFBITQMBZ128rr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2222
  {DBGFIELD("VPSHUFBITQMBZ256rr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2223
  {DBGFIELD("VPSHUFBITQMBZrr")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2224
  {DBGFIELD("VPCOMPRESSBZ128mr_VPCOMPRESSBZ256mr_VPCOMPRESSWZ128mr_VPCOMPRESSWZ256mr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2225
  {DBGFIELD("VPCOMPRESSWZmr")     2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2226
  {DBGFIELD("VPCOMPRESSBZ128mrk_VPCOMPRESSBZ256mrk_VPCOMPRESSWZ128mrk_VPCOMPRESSWZ256mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2227
  {DBGFIELD("VPCOMPRESSWZmrk")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2228
  {DBGFIELD("VPCOMPRESSBZmr")     2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2229
  {DBGFIELD("VPCOMPRESSBZmrk")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2230
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #2231
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #2232
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2233
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2234
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #2235
  {DBGFIELD("VPERMI2B128rm_VPERMT2B128rm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2236
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #2237
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2238
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2239
  {DBGFIELD("VPERMI2B128rmk_VPERMI2B128rmkz_VPERMT2B128rmk_VPERMT2B128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2240
  {DBGFIELD("VPERMT2W128rm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2241
  {DBGFIELD("VPERMI2B128rr_VPERMT2B128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2242
  {DBGFIELD("VPERMI2B256rr_VPERMT2B256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2243
  {DBGFIELD("VPERMI2B256rrk_VPERMI2B256rrkz_VPERMT2B256rrk_VPERMT2B256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2244
  {DBGFIELD("VPERMI2W128rr_VPERMT2W128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2245
  {DBGFIELD("VPERMI2W256rr_VPERMT2W256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2246
  {DBGFIELD("VPERMI2B256rm_VPERMT2B256rm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2247
  {DBGFIELD("VPERMI2B256rmk_VPERMI2B256rmkz_VPERMT2B256rmk_VPERMT2B256rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2248
  {DBGFIELD("VPERMI2W128rm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2249
  {DBGFIELD("VPERMT2W256rm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2250
  {DBGFIELD("VPERMI2Brm_VPERMT2Brm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2251
  {DBGFIELD("VPERMI2Brmk_VPERMI2Brmkz_VPERMT2Brmk_VPERMT2Brmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2252
  {DBGFIELD("VPERMT2Wrm")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2253
  {DBGFIELD("VPERMI2Brr_VPERMT2Brr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2254
  {DBGFIELD("VPERMI2Brrk_VPERMI2Brrkz_VPERMT2Brrk_VPERMT2Brrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2255
  {DBGFIELD("VPERMI2Wrr_VPERMT2Wrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2256
  {DBGFIELD("VPERMI2W128rmk_VPERMI2W128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2257
  {DBGFIELD("VPERMT2W256rmk_VPERMT2W256rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2258
  {DBGFIELD("VPERMI2W256rm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2259
  {DBGFIELD("VPERMI2W256rmk_VPERMI2W256rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2260
  {DBGFIELD("VPERMI2Wrm")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2261
  {DBGFIELD("VPERMI2Wrmk_VPERMI2Wrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2262
  {DBGFIELD("VPERMWZ128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2263
  {DBGFIELD("VPERMWZ256rmk_VPERMWZ256rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2264
  {DBGFIELD("VPERMWZ128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2265
  {DBGFIELD("VPERMWZ256rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2266
  {DBGFIELD("VPERMWZ256rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #2267
  {DBGFIELD("VPEXPANDBZ128rrk_VPEXPANDBZ128rrkz_VPEXPANDWZ128rrk_VPEXPANDWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2268
  {DBGFIELD("VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2269
  {DBGFIELD("VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2270
  {DBGFIELD("VPMADDUBSWZ128rrk_VPMADDUBSWZ128rrkz_VPMULHRSWZ128rrk_VPMULHRSWZ128rrkz_VPMULHUWZ128rrk_VPMULHUWZ128rrkz_VPMULHWZ128rrk_VPMULHWZ128rrkz_VPMULLWZ128rrk_VPMULLWZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2271
  {DBGFIELD("VPMADDUBSWZ256rrk_VPMADDUBSWZ256rrkz_VPMULHRSWZ256rrk_VPMULHRSWZ256rrkz_VPMULHUWZ256rrk_VPMULHUWZ256rrkz_VPMULHWZ256rrk_VPMULHWZ256rrkz_VPMULLWZ256rrk_VPMULLWZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2272
  {DBGFIELD("VPMADDUBSWZrmk_VPMADDUBSWZrmkz_VPMULHRSWZrmk_VPMULHRSWZrmkz_VPMULHUWZrmk_VPMULHUWZrmkz_VPMULHWZrmk_VPMULHWZrmkz_VPMULLWZrmk_VPMULLWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2273
  {DBGFIELD("VPMADDUBSWZrrk_VPMADDUBSWZrrkz_VPMULHRSWZrrk_VPMULHRSWZrrkz_VPMULHUWZrrk_VPMULHUWZrrkz_VPMULHWZrrk_VPMULHWZrrkz_VPMULLWZrrk_VPMULLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2274
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ256mr_VPMOVUSDBZ128mr_VPMOVUSDBZ256mr_VPMOVDWZ128mr_VPMOVDWZ256mr_VPMOVQWZ128mr_VPMOVQWZ256mr_VPMOVSDWZ128mr_VPMOVSDWZ256mr_VPMOVSQWZ128mr_VPMOVSQWZ256mr_VPMOVUSDWZ128mr_VPMOVUSDWZ256mr_VPMOVUSQWZ128mr_VPMOVUSQWZ256mr_VPMOVQBZ256mr_VPMOVSDBZ256mr_VPMOVSWBZ256mr_VPMOVWBZ256mr_VPMOVSDBZ128mr_VPMOVWBZ128mr_VPMOVSQBZ256mr_VPMOVUSQBZ256mr_VPMOVSQDZ128mr_VPMOVSQDZ256mr_VPMOVUSQDZ128mr_VPMOVUSQDZ256mr_VPMOVSWBZ128mr_VPMOVUSWBZ128mr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2275
  {DBGFIELD("VPMOVUSWBZ256mr")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2276
  {DBGFIELD("VPMOVDBZ128mrk_VPMOVQBZ128mrk_VPMOVSQBZ128mrk_VPMOVSWBZ128mrk_VPMOVWBZ128mrk_VPMOVDWZ128mrk_VPMOVQWZ128mrk_VPMOVSDWZ128mrk_VPMOVSQWZ128mrk_VPMOVUSDWZ128mrk_VPMOVUSQWZ128mrk_VPMOVSDBZ128mrk_VPMOVSQDZ128mrk_VPMOVUSDBZ128mrk_VPMOVUSQDZ128mrk_VPMOVUSQBZ128mrk_VPMOVUSWBZ128mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2277
  {DBGFIELD("VPMOVDBZ128rr_VPMOVQBZ128rr_VPMOVSQBZ128rr_VPMOVSWBZ128rr_VPMOVWBZ128rr_VPMOVDWZ128rr_VPMOVQWZ128rr_VPMOVSDWZ128rr_VPMOVSQWZ128rr_VPMOVUSDWZ128rr_VPMOVSDBZ128rr_VPMOVSQDZ128rr_VPMOVUSDBZ128rr_VPMOVUSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSWBZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2278
  {DBGFIELD("VPMOVUSQWZ128rr")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2279
  {DBGFIELD("VPMOVDBZ256rr_VPMOVQBZ256rr_VPMOVSQBZ256rr_VPMOVSWBZ256rr_VPMOVWBZ256rr_VPMOVDWZ256rr_VPMOVQWZ256rr_VPMOVSDWZ256rr_VPMOVSQWZ256rr_VPMOVUSDWZ256rr_VPMOVSDBZ256rr_VPMOVSQDZ256rr_VPMOVUSDBZ256rr_VPMOVUSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQBZ256rr_VPMOVUSWBZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2280
  {DBGFIELD("VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2281
  {DBGFIELD("VPMOVUSQWZ256rr")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2282
  {DBGFIELD("VPMOVDBZ256mrk_VPMOVQBZ256mrk_VPMOVSQBZ256mrk_VPMOVSWBZ256mrk_VPMOVWBZ256mrk_VPMOVDWZ256mrk_VPMOVQWZ256mrk_VPMOVSDWZ256mrk_VPMOVSQWZ256mrk_VPMOVUSDWZ256mrk_VPMOVUSQWZ256mrk_VPMOVSDBZ256mrk_VPMOVSQDZ256mrk_VPMOVUSDBZ256mrk_VPMOVUSQDZ256mrk_VPMOVUSQBZ256mrk_VPMOVUSWBZ256mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2283
  {DBGFIELD("VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2284
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2285
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2286
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2287
  {DBGFIELD("VPSCATTERQDZ256mr_VSCATTERQPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2288
  {DBGFIELD("VPSCATTERQDZmr_VSCATTERQPSZmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2289
  {DBGFIELD("VPSHLDDZ128rmbi_VPSHLDQZ128rmbi_VPSHRDDZ128rmbi_VPSHRDQZ128rmbi_VPSHLDDZ128rmi_VPSHLDQZ128rmi_VPSHLDWZ128rmi_VPSHRDDZ128rmi_VPSHRDQZ128rmi_VPSHRDWZ128rmi_VPSHLDVDZ128m_VPSHLDVQZ128m_VPSHLDVWZ128m_VPSHRDVDZ128m_VPSHRDVQZ128m_VPSHRDVWZ128m_VPSHLDVDZ128mb_VPSHLDVDZ128mk_VPSHLDVDZ128mkz_VPSHLDVQZ128mb_VPSHLDVQZ128mk_VPSHLDVQZ128mkz_VPSHRDVDZ128mb_VPSHRDVDZ128mk_VPSHRDVDZ128mkz_VPSHRDVQZ128mb_VPSHRDVQZ128mk_VPSHRDVQZ128mkz_VPSHLDVDZ128mbk_VPSHLDVDZ128mbkz_VPSHLDVQZ128mbk_VPSHLDVQZ128mbkz_VPSHRDVDZ128mbk_VPSHRDVDZ128mbkz_VPSHRDVQZ128mbk_VPSHRDVQZ128mbkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2290
  {DBGFIELD("VPSHLDDZ128rmbik_VPSHLDDZ128rmbikz_VPSHLDDZ128rmik_VPSHLDDZ128rmikz_VPSHLDQZ128rmbik_VPSHLDQZ128rmbikz_VPSHLDQZ128rmik_VPSHLDQZ128rmikz_VPSHRDDZ128rmbik_VPSHRDDZ128rmbikz_VPSHRDDZ128rmik_VPSHRDDZ128rmikz_VPSHRDQZ128rmbik_VPSHRDQZ128rmbikz_VPSHRDQZ128rmik_VPSHRDQZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2291
  {DBGFIELD("VPSHLDDZ128rri_VPSHLDQZ128rri_VPSHLDWZ128rri_VPSHRDDZ128rri_VPSHRDQZ128rri_VPSHRDWZ128rri_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2292
  {DBGFIELD("VPSHLDDZ256rri_VPSHLDQZ256rri_VPSHLDWZ256rri_VPSHRDDZ256rri_VPSHRDQZ256rri_VPSHRDWZ256rri_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2293
  {DBGFIELD("VPSHLDVDZ128r_VPSHLDVQZ128r_VPSHLDVWZ128r_VPSHRDVDZ128r_VPSHRDVQZ128r_VPSHRDVWZ128r") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2294
  {DBGFIELD("VPSHLDVDZ256r_VPSHLDVQZ256r_VPSHLDVWZ256r_VPSHRDVDZ256r_VPSHRDVQZ256r_VPSHRDVWZ256r") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2295
  {DBGFIELD("VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rrik_VPSHRDQZ128rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2296
  {DBGFIELD("VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rrik_VPSHRDQZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2297
  {DBGFIELD("VPSHLDDZ256rmbi_VPSHLDQZ256rmbi_VPSHRDDZ256rmbi_VPSHRDQZ256rmbi_VPSHLDDZ256rmi_VPSHLDQZ256rmi_VPSHLDWZ256rmi_VPSHRDDZ256rmi_VPSHRDQZ256rmi_VPSHRDWZ256rmi_VPSHLDVDZ256m_VPSHLDVQZ256m_VPSHLDVWZ256m_VPSHRDVDZ256m_VPSHRDVQZ256m_VPSHRDVWZ256m_VPSHLDVDZ256mb_VPSHLDVDZ256mk_VPSHLDVDZ256mkz_VPSHLDVQZ256mb_VPSHLDVQZ256mk_VPSHLDVQZ256mkz_VPSHRDVDZ256mb_VPSHRDVDZ256mk_VPSHRDVDZ256mkz_VPSHRDVQZ256mb_VPSHRDVQZ256mk_VPSHRDVQZ256mkz_VPSHLDVDZ256mbk_VPSHLDVDZ256mbkz_VPSHLDVQZ256mbk_VPSHLDVQZ256mbkz_VPSHRDVDZ256mbk_VPSHRDVDZ256mbkz_VPSHRDVQZ256mbk_VPSHRDVQZ256mbkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2298
  {DBGFIELD("VPSHLDDZ256rmbik_VPSHLDDZ256rmbikz_VPSHLDDZ256rmik_VPSHLDDZ256rmikz_VPSHLDQZ256rmbik_VPSHLDQZ256rmbikz_VPSHLDQZ256rmik_VPSHLDQZ256rmikz_VPSHRDDZ256rmbik_VPSHRDDZ256rmbikz_VPSHRDDZ256rmik_VPSHRDDZ256rmikz_VPSHRDQZ256rmbik_VPSHRDQZ256rmbikz_VPSHRDQZ256rmik_VPSHRDQZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2299
  {DBGFIELD("VPSHLDDZrmbi_VPSHLDQZrmbi_VPSHRDDZrmbi_VPSHRDQZrmbi_VPSHLDDZrmi_VPSHLDQZrmi_VPSHLDWZrmi_VPSHRDDZrmi_VPSHRDQZrmi_VPSHRDWZrmi_VPSHLDVDZm_VPSHLDVQZm_VPSHLDVWZm_VPSHRDVDZm_VPSHRDVQZm_VPSHRDVWZm_VPSHLDVDZmb_VPSHLDVDZmk_VPSHLDVDZmkz_VPSHLDVQZmb_VPSHLDVQZmk_VPSHLDVQZmkz_VPSHRDVDZmb_VPSHRDVDZmk_VPSHRDVDZmkz_VPSHRDVQZmb_VPSHRDVQZmk_VPSHRDVQZmkz_VPSHLDVDZmbk_VPSHLDVDZmbkz_VPSHLDVQZmbk_VPSHLDVQZmbkz_VPSHRDVDZmbk_VPSHRDVDZmbkz_VPSHRDVQZmbk_VPSHRDVQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2300
  {DBGFIELD("VPSHLDDZrmbik_VPSHLDDZrmbikz_VPSHLDDZrmik_VPSHLDDZrmikz_VPSHLDQZrmbik_VPSHLDQZrmbikz_VPSHLDQZrmik_VPSHLDQZrmikz_VPSHRDDZrmbik_VPSHRDDZrmbikz_VPSHRDDZrmik_VPSHRDDZrmikz_VPSHRDQZrmbik_VPSHRDQZrmbikz_VPSHRDQZrmik_VPSHRDQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2301
  {DBGFIELD("VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrrik_VPSHRDQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2302
  {DBGFIELD("VPSHLDWZ128rmik_VPSHLDWZ128rmikz_VPSHRDWZ128rmik_VPSHRDWZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2303
  {DBGFIELD("VPSHLDWZ256rmik_VPSHLDWZ256rmikz_VPSHRDWZ256rmik_VPSHRDWZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2304
  {DBGFIELD("VPSHLDWZrmik_VPSHLDWZrmikz_VPSHRDWZrmik_VPSHRDWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2305
  {DBGFIELD("VPSHUFBITQMBZ128rm") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2306
  {DBGFIELD("VPSHUFBITQMBZ256rm") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2307
  {DBGFIELD("VPSHUFBITQMBZrm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2308
  {DBGFIELD("VPSHUFBITQMBZ128rmk") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2309
  {DBGFIELD("VPSHUFBITQMBZ256rmk") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #2310
  {DBGFIELD("VPSHUFBITQMBZrmk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2311
  {DBGFIELD("VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRAWZ128rrk_VPSRAWZ128rrkz") 2, false, false, false, 531, 6, 12, 1,  0, 0}, // #2312
  {DBGFIELD("VRCPPHZmbk_VRCPPHZmkz_VRCPPHZmbkz_VRCPPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2313
  {DBGFIELD("VRSQRTPHZmbk_VRSQRTPHZmkz_VRSQRTPHZmbkz_VRSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2314
  {DBGFIELD("VRCPPHZrk_VRCPPHZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2315
  {DBGFIELD("VREDUCEPHZ128rmbi_VREDUCEPHZ128rmi") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #2316
  {DBGFIELD("VREDUCESHZrmi")      3, false, false, false, 74, 6, 11, 1,  5, 1}, // #2317
  {DBGFIELD("VREDUCEPHZ256rmbi_VREDUCEPHZ256rmi") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #2318
  {DBGFIELD("VREDUCEPHZ128rmbik_VREDUCEPHZ128rmbikz_VREDUCEPHZ128rmik_VREDUCEPHZ128rmikz_VREDUCESHZrmik_VREDUCESHZrmikz") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #2319
  {DBGFIELD("VREDUCEPHZ256rmbik_VREDUCEPHZ256rmbikz_VREDUCEPHZ256rmik_VREDUCEPHZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #2320
  {DBGFIELD("VREDUCEPHZ128rri_VREDUCESHZrri_VREDUCESHZrrib") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2321
  {DBGFIELD("VREDUCEPHZ256rri")   2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2322
  {DBGFIELD("VREDUCEPHZ128rrik_VREDUCEPHZ128rrikz_VREDUCESHZrribk_VREDUCESHZrrikz_VREDUCESHZrribkz_VREDUCESHZrrik") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2323
  {DBGFIELD("VREDUCEPHZ256rrik_VREDUCEPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2324
  {DBGFIELD("VREDUCEPHZrmbi_VREDUCEPHZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2325
  {DBGFIELD("VREDUCEPHZrmbik_VREDUCEPHZrmbikz_VREDUCEPHZrmik_VREDUCEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2326
  {DBGFIELD("VREDUCEPHZrri_VREDUCEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2327
  {DBGFIELD("VREDUCEPHZrribk_VREDUCEPHZrrikz_VREDUCEPHZrribkz_VREDUCEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2328
  {DBGFIELD("VRNDSCALEPDZrri_VRNDSCALEPDZrrib_VRNDSCALEPDZrribk_VRNDSCALEPDZrrik_VRNDSCALEPDZrrikz_VRNDSCALEPSZrri_VRNDSCALEPSZrrib_VRNDSCALEPSZrribk_VRNDSCALEPSZrrik_VRNDSCALEPSZrrikz_VRNDSCALEPDZrribkz_VRNDSCALEPSZrribkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2329
  {DBGFIELD("VRNDSCALEPHZ128rmbik_VRNDSCALEPHZ128rmbikz_VRNDSCALEPHZ128rmik_VRNDSCALEPHZ128rmikz_VRNDSCALESHZm_Intk_VRNDSCALESHZm_Intkz") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #2330
  {DBGFIELD("VSCALEFPHZ128rmbk_VSCALEFPHZ128rmkz_VSCALEFPHZ128rmbkz_VSCALEFPHZ128rmk") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #2331
  {DBGFIELD("VRNDSCALEPHZ256rmbik_VRNDSCALEPHZ256rmbikz_VRNDSCALEPHZ256rmik_VRNDSCALEPHZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #2332
  {DBGFIELD("VSCALEFPHZ256rmbk_VSCALEFPHZ256rmkz_VSCALEFPHZ256rmbkz_VSCALEFPHZ256rmk") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #2333
  {DBGFIELD("VSCALEFSHZrmk_VSCALEFSHZrmkz") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #2334
  {DBGFIELD("VRNDSCALEPHZ128rrik_VRNDSCALEPHZ128rrikz_VRNDSCALESHZr_Intk_VRNDSCALESHZr_Intkz_VRNDSCALESHZrb_Intk_VRNDSCALESHZrb_Intkz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2335
  {DBGFIELD("VRNDSCALEPHZ256rrik_VRNDSCALEPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2336
  {DBGFIELD("VSCALEFPHZ128rrk_VSCALEFPHZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2337
  {DBGFIELD("VSCALEFPHZ256rrk_VSCALEFPHZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2338
  {DBGFIELD("VSCALEFSHZrrb_Intk_VSCALEFSHZrrb_Intkz_VSCALEFSHZrrk_VSCALEFSHZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2339
  {DBGFIELD("VRNDSCALEPHZrmbik_VRNDSCALEPHZrmbikz_VRNDSCALEPHZrmik_VRNDSCALEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2340
  {DBGFIELD("VSCALEFPHZrmbk_VSCALEFPHZrmkz_VSCALEFPHZrmbkz_VSCALEFPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2341
  {DBGFIELD("VRNDSCALEPHZrribk_VRNDSCALEPHZrrikz_VRNDSCALEPHZrribkz_VRNDSCALEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2342
  {DBGFIELD("VSCALEFPHZrrbk_VSCALEFPHZrrkz_VSCALEFPHZrrbkz_VSCALEFPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2343
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PSZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2344
  {DBGFIELD("VRSQRT14PSZrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2345
  {DBGFIELD("VRSQRTPHZr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2346
  {DBGFIELD("VSQRTPDYm")          2, false, false, false, 173, 10, 42, 1,  0, 0}, // #2347
  {DBGFIELD("VSQRTPDZ256m_VSQRTPDZ256mb") 2, false, false, false, 173, 10, 42, 1,  5, 1}, // #2348
  {DBGFIELD("VSQRTPDZ128mbk_VSQRTPDZ128mkz_VSQRTPDZ128mbkz_VSQRTPDZ128mk") 2, false, false, false, 173, 10, 37, 1,  5, 1}, // #2349
  {DBGFIELD("VSQRTSDZm_Intk_VSQRTSDZm_Intkz") 2, false, false, false, 173, 10, 18, 1,  5, 1}, // #2350
  {DBGFIELD("VSQRTPDZm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2351
  {DBGFIELD("VSQRTPDZmb")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2352
  {DBGFIELD("VSQRTPDZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2353
  {DBGFIELD("VSQRTPHZ128mbk_VSQRTPHZ128mkz_VSQRTPHZ128mbkz_VSQRTPHZ128mk") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #2354
  {DBGFIELD("VSQRTPHZ128rk")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2355
  {DBGFIELD("VSQRTPHZ256rk")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2356
  {DBGFIELD("VSQRTPHZ256rkz")     1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2357
  {DBGFIELD("VSQRTPHZ128rkz")     1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2358
  {DBGFIELD("VSQRTPHZ256m_VSQRTPHZ256mb") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #2359
  {DBGFIELD("VSQRTPHZ256mbk_VSQRTPHZ256mkz_VSQRTPHZ256mbkz_VSQRTPHZ256mk") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #2360
  {DBGFIELD("VSQRTPHZm_VSQRTPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2361
  {DBGFIELD("VSQRTPHZmbk_VSQRTPHZmkz_VSQRTPHZmbkz_VSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2362
  {DBGFIELD("VSQRTPHZr_VSQRTPHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2363
  {DBGFIELD("VSQRTPHZrbk_VSQRTPHZrkz_VSQRTPHZrbkz_VSQRTPHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2364
  {DBGFIELD("VSQRTPSZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2365
  {DBGFIELD("XTEST")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #2366
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2367
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2368
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2369
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2370
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2371
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2372
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2373
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2374
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2375
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2376
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2377
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2378
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2379
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2380
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2381
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2382
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2383
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2384
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2385
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2386
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2387
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2388
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2389
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2390
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2391
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2392
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2393
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2394
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2395
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2396
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2397
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2398
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2399
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2400
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2401
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2402
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2403
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2404
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2405
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2406
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2407
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2408
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2409
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2410
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2411
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2412
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2413
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2414
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2415
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2416
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2417
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2418
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2419
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2420
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2421
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2422
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2423
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2424
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2425
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2426
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2427
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2428
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2429
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2430
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2431
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2432
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2433
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2434
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2435
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2436
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2437
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2438
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2439
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2440
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2441
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2442
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2443
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2444
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2445
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2446
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2447
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2448
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2449
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2450
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2451
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2452
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2453
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2454
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2455
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2456
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2457
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2458
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2459
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2460
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2461
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2462
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2463
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2464
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2465
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2466
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2467
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2468
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2469
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false,  3, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false,  3, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  4, 1,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #21
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 2}, // #22
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #23
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #24
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #25
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #27
  {DBGFIELD("WriteFAddX")         1, false, false, false,  3, 2, 10, 1,  0, 0}, // #28
  {DBGFIELD("WriteNop")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #30
  {DBGFIELD("WriteFAdd64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #32
  {DBGFIELD("WriteFAdd")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 269, 3, 10, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #41
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteALULd")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSF")           10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSR")           10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 293, 1, 22, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTest")       1, false, false, false,  3, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  3, 2,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #65
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #66
  {DBGFIELD("WriteLoad")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #68
  {DBGFIELD("WriteCMOV")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #70
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #71
  {DBGFIELD("WriteXCHG")          1, false, false, false, 75, 1, 12, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #73
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #75
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #77
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #79
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 2231, 1, 11, 1,  0, 0}, // #81
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 2232, 3,  9, 1, 15, 1}, // #82
  {DBGFIELD("WriteFComX")         4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #83
  {DBGFIELD("WriteFCom")          1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #84
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #85
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 2246, 3,  2, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 2249, 3,  8, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 2240, 3,  7, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 2222, 3,  6, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 2232, 3, 22, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 2246, 3,  8, 1, 15, 1}, // #102
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 2232, 3,  9, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 2240, 3,  6, 1, 15, 1}, // #105
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #106
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #107
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 2222, 3,  6, 1, 15, 1}, // #109
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #110
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #111
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #112
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #115
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2252, 3, 92, 1, 13, 2}, // #117
  {DBGFIELD("WriteDiv16")         12, false, false, false, 2252, 3, 92, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2252, 3, 92, 1, 13, 2}, // #119
  {DBGFIELD("WriteDiv32")         12, false, false, false, 2252, 3, 92, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 2255, 3, 93, 1, 13, 2}, // #121
  {DBGFIELD("WriteDiv64")         38, false, false, false, 2255, 3, 93, 1,  0, 0}, // #122
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 2258, 3, 94, 1, 13, 2}, // #123
  {DBGFIELD("WriteDiv8")          9, false, false, false, 2252, 3, 92, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 2261, 3, 95, 1, 15, 1}, // #125
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 2261, 3, 95, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 2264, 3, 57, 1, 15, 1}, // #127
  {DBGFIELD("WriteFDivX")         6, false, false, false, 2264, 3, 57, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv")          3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #131
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 2270, 3, 64, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 2267, 3, 96, 1, 15, 1}, // #133
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #134
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #135
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #136
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #137
  {DBGFIELD("WriteStore")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #141
  {DBGFIELD("WriteFComLd")        1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #142
  {DBGFIELD("WriteEMMS")          1, false, false, false, 240, 1, 10, 1,  0, 0}, // #143
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1904, 1,  9, 1,  0, 0}, // #144
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #145
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #146
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #147
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 2235, 3, 22, 1, 15, 1}, // #148
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2270, 3, 64, 1, 13, 2}, // #150
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 2270, 3, 64, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2270, 3, 64, 1, 13, 2}, // #152
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 2270, 3, 64, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 2255, 3, 93, 1, 13, 2}, // #154
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 2255, 3, 93, 1,  0, 0}, // #155
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 2270, 3, 64, 1, 13, 2}, // #156
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 2270, 3, 64, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 2243, 3,  7, 1, 13, 2}, // #158
  {DBGFIELD("WriteIMul16")        4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 2240, 3,  6, 1, 15, 1}, // #160
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 2222, 3,  3, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2222, 3,  3, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 2240, 3,  6, 1, 13, 2}, // #164
  {DBGFIELD("WriteIMul32")        3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #166
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2246, 3,  2, 1, 13, 2}, // #170
  {DBGFIELD("WriteIMul64")        8, false, false, false, 2246, 3,  2, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 2246, 3,  2, 1, 15, 1}, // #172
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 2275, 3, 21, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 2246, 3,  2, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 2275, 3, 21, 1,  0, 0}, // #175
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 2240, 3,  6, 1, 13, 2}, // #176
  {DBGFIELD("WriteIMul8")         3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #177
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #178
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 2225, 3, 10, 1,  0, 0}, // #184
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteFLD1")          1, false, false, false, 464, 1,  3, 1,  0, 0}, // #186
  {DBGFIELD("WriteFence")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #188
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #189
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveX")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #199
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #200
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #201
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #202
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2280, 3, 14, 1, 15, 1}, // #203
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2283, 3,  5, 1,  0, 0}, // #204
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #205
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 2220, 2,  1, 1,  6, 1}, // #206
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2220, 2, 14, 1, 15, 1}, // #207
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2220, 2, 14, 1,  0, 0}, // #208
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #209
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 2220, 2, 14, 1, 15, 1}, // #210
  {DBGFIELD("WritePSADBW")        1, false, false, false, 2220, 2, 14, 1,  0, 0}, // #211
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #212
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 2286, 3,  5, 1, 15, 1}, // #216
  {DBGFIELD("WriteVecShift")      2, false, false, false, 269, 3, 12, 1,  0, 0}, // #217
  {DBGFIELD("WriteFMoveX")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFStore")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #221
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #225
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #226
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #227
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #228
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 2232, 3,  9, 1, 15, 1}, // #229
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 2235, 3, 22, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #231
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #233
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #234
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2273, 2, 14, 1, 15, 1}, // #235
  {DBGFIELD("WriteFMul")          1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #236
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #245
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #247
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #249
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #264
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #265
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #266
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #267
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #268
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #272
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 2273, 2, 12, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 15, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 2286, 3,  5, 1, 15, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 269, 3, 12, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #284
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 2232, 3,  9, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2289, 2, 14, 1, 15, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShift")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #299
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 2232, 3,  9, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2289, 2, 14, 1, 15, 1}, // #303
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #304
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #305
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #307
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #308
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #309
  {DBGFIELD("WriteSETCC")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #310
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 75, 1, 12, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 2261, 3, 95, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 2261, 3, 95, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 2264, 3, 57, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 2264, 3, 57, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 2270, 3, 64, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #319
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 2270, 3, 64, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 2267, 3, 96, 1, 15, 1}, // #322
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2291, 2, 79, 1,  0, 0}, // #324
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 2293, 3, 11, 1,  0, 0}, // #325
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 2246, 3,  2, 1, 15, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 2232, 3, 22, 1, 15, 1}, // #406
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 2235, 3, 22, 1, 15, 1}, // #407
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 17, 2}, // #502
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 17, 2}, // #504
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #521
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 15, 2}, // #537
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 17, 2}, // #538
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #550
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 2232, 3,  9, 1, 15, 1}, // #562
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2232, 3,  9, 1, 15, 1}, // #569
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 2261, 3, 95, 1, 15, 1}, // #579
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2264, 3, 57, 1, 15, 1}, // #583
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #589
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #590
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #591
  {DBGFIELD("WriteFTest")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #592
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #593
  {DBGFIELD("COPY")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #594
  {DBGFIELD("XAM_F")              1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("LD_Frr")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #597
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #598
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("FCOMPP")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #606
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #607
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #608
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #609
  {DBGFIELD("XCH_F")              1, false, false, false, 269, 3,  1, 1,  0, 0}, // #610
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #611
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2225, 3, 10, 1,  0, 0}, // #612
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2225, 3, 10, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #614
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #618
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #621
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 2249, 3,  9, 1,  0, 0}, // #622
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #623
  {DBGFIELD("LFENCE")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #624
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #625
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #626
  {DBGFIELD("POP16r")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #627
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #628
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #629
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #630
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #631
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 75, 1, 12, 1,  0, 0}, // #632
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #633
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #634
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #635
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #636
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #637
  {DBGFIELD("CLD")                1, false, false, false, 214, 1,  5, 1,  0, 0}, // #638
  {DBGFIELD("LDDQUrm")            1, false, false, false, 214, 1,  5, 1,  0, 0}, // #639
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #640
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #641
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #642
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #643
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #644
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #645
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 214, 1,  5, 1,  0, 0}, // #648
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #649
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #650
  {DBGFIELD("LD_F80m")            1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #651
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #652
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #653
  {DBGFIELD("FLDCW16m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #654
  {DBGFIELD("ST_FP80m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 240, 1, 10, 1,  0, 0}, // #656
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #657
  {DBGFIELD("INTO")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #658
  {DBGFIELD("XLAT")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #662
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #663
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #664
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #665
  {DBGFIELD("AAD8i8")             1, false, false, false, 478, 1,  6, 1,  0, 0}, // #666
  {DBGFIELD("LOOPE")              1, false, false, false, 504, 1,  7, 1,  0, 0}, // #667
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 504, 1,  7, 1,  0, 0}, // #668
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 504, 1,  7, 1,  0, 0}, // #669
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 504, 1,  7, 1,  0, 0}, // #670
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 293, 1, 22, 1,  0, 0}, // #671
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #674
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #675
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #676
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #677
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #678
  {DBGFIELD("AAA_AAS")            1, false, false, false, 798, 1, 24, 1,  0, 0}, // #679
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 946, 1, 21, 1,  0, 0}, // #680
  {DBGFIELD("LOOPNE")             1, false, false, false, 961, 1, 20, 1,  0, 0}, // #681
  {DBGFIELD("PAUSE")              1, false, false, false, 961, 1, 20, 1,  0, 0}, // #682
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #683
  {DBGFIELD("DAA")                1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #684
  {DBGFIELD("LOOP")               1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #685
  {DBGFIELD("DAS")                1, false, false, false, 2234, 1, 15, 1,  0, 0}, // #686
  {DBGFIELD("AAM8i8")             1, false, false, false, 2296, 1, 23, 1,  0, 0}, // #687
  {DBGFIELD("STD")                1, false, false, false, 2296, 1, 23, 1,  0, 0}, // #688
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 1881, 1, 19, 1,  0, 0}, // #689
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 906, 1, 18, 1,  0, 0}, // #690
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2297, 1, 42, 1,  0, 0}, // #691
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1392, 1, 76, 1,  0, 0}, // #692
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2298, 1, 68, 1,  0, 0}, // #693
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2295, 1, 60, 1,  0, 0}, // #694
  {DBGFIELD("ENTER")              1, false, false, false, 2230, 1, 47, 1,  0, 0}, // #695
  {DBGFIELD("POPF16")             1, false, false, false, 2230, 1, 47, 1,  0, 0}, // #696
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2299, 1, 99, 1,  0, 0}, // #697
  {DBGFIELD("FRNDINT")            1, false, false, false, 918, 1, 62, 1,  0, 0}, // #698
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 918, 1, 62, 1,  0, 0}, // #699
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1689, 1, 100, 1,  0, 0}, // #700
  {DBGFIELD("FPREM")              1, false, false, false, 2300, 1, 101, 1,  0, 0}, // #701
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2301, 1, 102, 1,  0, 0}, // #702
  {DBGFIELD("FNINIT")             1, false, false, false, 2302, 1, 52, 1,  0, 0}, // #703
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2269, 1, 94, 1,  0, 0}, // #704
  {DBGFIELD("FPREM1")             1, false, false, false, 2292, 1, 79, 1,  0, 0}, // #705
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2292, 1, 79, 1,  0, 0}, // #706
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2303, 1, 103, 1,  0, 0}, // #707
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2304, 1, 87, 1,  0, 0}, // #708
  {DBGFIELD("FSCALE")             1, false, false, false, 2305, 1, 104, 1,  0, 0}, // #709
  {DBGFIELD("RDMSR")              1, false, false, false, 2306, 1, 105, 1,  0, 0}, // #710
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #711
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2307, 1, 107, 1,  0, 0}, // #712
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2308, 1, 108, 1,  0, 0}, // #713
  {DBGFIELD("F2XM1")              1, false, false, false, 2309, 1, 109, 1,  0, 0}, // #714
  {DBGFIELD("CPUID")              1, false, false, false, 2310, 1, 110, 1,  0, 0}, // #715
  {DBGFIELD("INT")                1, false, false, false, 2311, 1, 111, 1,  0, 0}, // #716
  {DBGFIELD("INT3")               1, false, false, false, 2312, 1, 93, 1,  0, 0}, // #717
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2266, 1, 112, 1,  0, 0}, // #718
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2313, 1, 113, 1,  0, 0}, // #719
  {DBGFIELD("FYL2X")              1, false, false, false, 2314, 1, 114, 1,  0, 0}, // #720
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2315, 1, 115, 1,  0, 0}, // #721
  {DBGFIELD("FPTAN")              1, false, false, false, 2316, 1, 116, 1,  0, 0}, // #722
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2317, 1, 117, 1,  0, 0}, // #723
  {DBGFIELD("FPATAN")             1, false, false, false, 2318, 1, 118, 1,  0, 0}, // #724
  {DBGFIELD("WRMSR")              1, false, false, false, 2319, 1, 119, 1,  0, 0}, // #725
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #726
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false,  3, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #728
  {DBGFIELD("FNOP")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #729
  {DBGFIELD("RET64")              1, false, false, false, 992, 1, 106, 1,  0, 0}, // #730
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #733
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #735
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #736
  {DBGFIELD("CWD")                1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #737
  {DBGFIELD("FNSTSW16r")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #738
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #739
  {DBGFIELD("PUSHFS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #740
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #742
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #745
  {DBGFIELD("MOV64sr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                1, false, false, false,  4, 1,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      1, false, false, false,  3, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 293, 1, 22, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 214, 1,  5, 1,  0, 0}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 2232, 3,  9, 1, 15, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #783
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #784
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #785
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #786
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #787
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #788
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #789
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #790
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #791
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #792
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #793
  {DBGFIELD("VZEROALL")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #794
  {DBGFIELD("VZEROUPPER")         1, false, false, false,  4, 1,  4, 1,  0, 0}, // #795
  {DBGFIELD("CLC")                1, false, false, false,  4, 1,  1, 1,  0, 0}, // #796
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #797
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #798
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #800
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #801
  {DBGFIELD("PSUBQrr")            1, false, false, false, 75, 1, 12, 1,  0, 0}, // #802
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #803
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #804
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #805
  {DBGFIELD("SETCCr")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("SETCCm")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #807
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #808
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #809
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #810
  {DBGFIELD("RDPMC")              1, false, false, false, 918, 1, 62, 1,  0, 0}, // #811
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #812
  {DBGFIELD("FBLDm")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #813
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #814
  {DBGFIELD("FSAVEm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #815
  {DBGFIELD("FRSTORm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #816
  {DBGFIELD("FXTRACT")            1, false, false, false, 2297, 1, 42, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #818
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #819
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("FBSTPm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #822
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #823
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #824
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #825
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #826
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #827
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #829
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #830
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #831
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #832
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #833
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #836
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #838
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #840
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #841
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #844
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 269, 3,  1, 1,  0, 0}, // #845
  {DBGFIELD("SFENCE")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #846
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #849
  {DBGFIELD("MFENCE")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #850
  {DBGFIELD("XGETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #851
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #852
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 992, 1, 106, 1,  0, 0}, // #853
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #854
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #855
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #857
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #858
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #859
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #860
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #861
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #862
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #863
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #864
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #865
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #866
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #867
  {DBGFIELD("XSETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #868
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #869
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #870
  {DBGFIELD("RCL8rCL")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #871
  {DBGFIELD("RDTSC")              1, false, false, false, 2295, 1, 60, 1,  0, 0}, // #872
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #873
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #874
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #875
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #876
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #877
  {DBGFIELD("XSAVE64")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #878
  {DBGFIELD("XSAVE")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #880
  {DBGFIELD("VMCLEARm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #881
  {DBGFIELD("FLDENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #882
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2313, 1, 113, 1,  0, 0}, // #883
  {DBGFIELD("FSTENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #884
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #885
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #886
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #888
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #889
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #890
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #891
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #892
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #893
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #894
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #895
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #896
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #897
  {DBGFIELD("LRET64")             1, false, false, false, 992, 1, 106, 1,  0, 0}, // #898
  {DBGFIELD("POPF64")             1, false, false, false, 1392, 1, 76, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #900
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #901
  {DBGFIELD("PCMPGTQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #902
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #903
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #904
  {DBGFIELD("MOV16rm")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #905
  {DBGFIELD("POP16rmm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #906
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #907
  {DBGFIELD("PUSHF16")            1, false, false, false, 293, 1, 22, 1,  0, 0}, // #908
  {DBGFIELD("LAHF")               1, false, false, false, 75, 1, 12, 1,  0, 0}, // #909
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #910
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #911
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #912
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #913
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #914
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #915
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #916
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #917
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #918
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #919
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #920
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #921
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #922
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #923
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #924
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #925
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #926
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #933
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #937
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #938
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #939
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #940
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #941
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #942
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #943
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VPERM2I128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #945
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #946
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #948
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #949
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("VINSERTI128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #951
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #952
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #953
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #954
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #955
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #956
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #957
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #958
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #959
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #960
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #961
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #962
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #963
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #964
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #965
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #966
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #967
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 2232, 3, 22, 1,  0, 0}, // #968
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #969
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #970
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  4, 1,  1, 1,  0, 0}, // #971
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #972
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #974
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #975
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #976
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #977
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #978
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #979
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #980
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #981
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #982
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #983
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #984
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #985
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #987
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #988
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #989
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #990
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #991
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #992
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #993
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #994
  {DBGFIELD("LEA16r")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #995
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #996
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #997
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #998
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 214, 1,  5, 1,  0, 0}, // #999
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1000
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1001
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1002
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1003
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1004
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1006
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1007
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1008
  {DBGFIELD("EXTRQ")              1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1009
  {DBGFIELD("INSERTQ")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1010
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1011
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1012
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1013
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1014
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1015
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #1016
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1017
  {DBGFIELD("VPERMPDYri")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1018
  {DBGFIELD("VPERMQYri")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1019
  {DBGFIELD("VPERMPDYmi")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1020
  {DBGFIELD("VPERMQYmi")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1021
  {DBGFIELD("VPERMDYrm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1024
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1028
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1029
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1030
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1031
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1032
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1033
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1034
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1035
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1036
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1037
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1041
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("VPERMDYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1044
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1045
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1046
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1047
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1048
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1049
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1051
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1054
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1057
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 269, 3, 12, 1,  0, 0}, // #1060
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1061
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #1067
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1073
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VFMSUB231SSZr_Intkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1076
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1077
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1082
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1085
  {DBGFIELD("CMPPSrri_VCMPPSrri") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1086
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1087
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1088
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1089
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1097
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1105
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1106
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #1108
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VPERMI2PD128rr_VPERMI2PD128rrk_VPERMI2PD128rrkz_VPERMI2PS128rr_VPERMI2PS128rrk_VPERMI2PS128rrkz_VPERMT2PD128rr_VPERMT2PD128rrk_VPERMT2PD128rrkz_VPERMT2PS128rr_VPERMT2PS128rrk_VPERMT2PS128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMI2B128rr_VPERMI2B128rrk_VPERMI2B128rrkz_VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2B128rr_VPERMT2B128rrk_VPERMT2B128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1115
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD("VPERMI2PD256rr_VPERMI2PD256rrk_VPERMI2PD256rrkz_VPERMI2PS256rr_VPERMI2PS256rrk_VPERMI2PS256rrkz_VPERMT2PD256rr_VPERMT2PD256rrk_VPERMT2PD256rrkz_VPERMT2PS256rr_VPERMT2PS256rrk_VPERMT2PS256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1117
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2B256rr_VPERMI2B256rrk_VPERMI2B256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2B256rr_VPERMT2B256rrk_VPERMT2B256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD("VPERMI2PDrr_VPERMI2PDrrk_VPERMI2PDrrkz_VPERMI2PSrr_VPERMI2PSrrk_VPERMI2PSrrkz_VPERMT2PDrr_VPERMT2PDrrk_VPERMT2PDrrkz_VPERMT2PSrr_VPERMT2PSrrk_VPERMT2PSrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1119
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2Brr_VPERMI2Brrk_VPERMI2Brrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Brr_VPERMT2Brrk_VPERMT2Brrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1121
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1122
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1123
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1124
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1125
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1126
  {DBGFIELD("CRC32r32r16")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("CRC32r32r32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("CRC32r64r64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("SAHF")               1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1130
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1131
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1132
  {DBGFIELD("RCR8ri")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1133
  {DBGFIELD("RCL16rCL")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1134
  {DBGFIELD("RCR16ri")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1135
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1136
  {DBGFIELD("RCL16ri")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1137
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1138
  {DBGFIELD("SHLD16rrCL")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #1139
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("TST_F")              1, false, false, false, 293, 1, 22, 1,  0, 0}, // #1141
  {DBGFIELD("VDPPSrri")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1143
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1144
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #1145
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1146
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1147
  {DBGFIELD("MMX_CVTTPD2PIrr")    4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1148
  {DBGFIELD("CVTSI2SSrr")         3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #1149
  {DBGFIELD("VMOVDQUYmr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("MOVDQArr")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1151
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #1153
  {DBGFIELD("VPPERMrrm")          5, false, false, false, 2280, 3, 10, 1, 17, 2}, // #1154
  {DBGFIELD("VPPERMrmr")          5, false, false, false, 2280, 3, 10, 1, 15, 2}, // #1155
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1156
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #1157
  {DBGFIELD("VPCLMULQDQrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1159
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1160
  {DBGFIELD("PANDNrr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1161
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1162
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #1163
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, false, 2231, 1, 11, 1,  0, 0}, // #1164
  {DBGFIELD("LCMPXCHG8B")         1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #1165
  {DBGFIELD("XCHG8rr")            1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1166
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1167
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1168
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1169
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1170
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1171
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1172
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1173
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1174
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, false, 240, 1, 10, 1,  0, 0}, // #1175
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1176
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1178
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1179
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1181
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #1183
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #1184
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1186
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1187
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1188
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1190
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1191
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1192
  {DBGFIELD("VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1193
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1196
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1199
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1202
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1206
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1207
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1210
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1211
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1214
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 4, false, false, false, 2222, 3,  6, 1,  0, 0}, // #1229
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1230
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ