/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* This file generated from grl_cl_kernel_gen.py, don't edit directly. */

#ifndef GRL_CL_KERNEL_H
#define GRL_CL_KERNEL_H

#include "genxml/gen_macros.h"
#include "compiler/brw_kernel.h"

#ifdef __cplusplus
extern "C" {
#endif

enum grl_cl_kernel {
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_DFS,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_BEGIN_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_INIT_SCHEDULER_BATCHED,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY_BATCHED,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_KICKOFF,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_SCHEDULER,
    GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_TRY_TO_FILL_GRB_BATCHED,
    GRL_CL_KERNEL_BVH_BUILD_BFS_CATEGORIZE_BUILDS_AND_INIT_SCHEDULER,
    GRL_CL_KERNEL_BVH_BUILD_BFS_SCHEDULER,
    GRL_CL_KERNEL_BVH_BUILD_DFS_DFS,
    GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG,
    GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL,
    GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL_BATCHABLE,
    GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES,
    GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS,
    GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_PROCEDURALS,
    GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_QUADS,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_INDIRECT,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS_INDIRECT,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS_INDIRECT,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS,
    GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS_INDIRECT,
    GRL_CL_KERNEL_BVH_COPY_CLONE_INDIRECT,
    GRL_CL_KERNEL_BVH_COPY_COMPACT,
    GRL_CL_KERNEL_BVH_COPY_DESERIALIZE_INDIRECT,
    GRL_CL_KERNEL_BVH_COPY_DXR_DECODE,
    GRL_CL_KERNEL_BVH_COPY_SERIALIZE_FOR_INPUT_DUMP_INDIRECT,
    GRL_CL_KERNEL_BVH_COPY_SERIALIZE_INDIRECT,
    GRL_CL_KERNEL_BVH_POSTBUILD_INFO_COMPACTED_SIZE,
    GRL_CL_KERNEL_BVH_POSTBUILD_INFO_CURRENT_SIZE,
    GRL_CL_KERNEL_BVH_POSTBUILD_INFO_DECODED_SIZE,
    GRL_CL_KERNEL_BVH_POSTBUILD_INFO_SERIALIZED_SIZE,
    GRL_CL_KERNEL_MISC_BATCHED_INIT_GLOBALS,
    GRL_CL_KERNEL_MISC_COPY_GEO_DESCS_INDIRECT_BUILD,
    GRL_CL_KERNEL_MISC_COPY_GEO_META_DATA,
    GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS,
    GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR,
    GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR_INDIRECT,
    GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_INDIRECT,
    GRL_CL_KERNEL_MISC_COPY_INSTANCES,
    GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR,
    GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR_INDIRECT,
    GRL_CL_KERNEL_MISC_COPY_INSTANCES_INDIRECT,
    GRL_CL_KERNEL_MISC_COPY_MOCK,
    GRL_CL_KERNEL_MISC_MEM_SET,
    GRL_CL_KERNEL_MISC_MEM_SET_SIZE_PTR,
    GRL_CL_KERNEL_MAX,
};

const char *genX(grl_cl_kernel_name)(enum grl_cl_kernel kernel);

const char *genX(grl_get_cl_kernel_sha1)(enum grl_cl_kernel id);

void genX(grl_get_cl_kernel)(struct brw_kernel *kernel, enum grl_cl_kernel id);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* INTEL_GRL_H */
