
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "anv_private.h"
#include "grl/genX_grl.h"

#ifndef GRL_METAKERNEL_BUILD_PRIMREF
#define GRL_METAKERNEL_BUILD_PRIMREF

#ifdef __cplusplus
extern "C" {
#endif

struct grl_build_primref_MKBuilderState {
    uint64_t geomDesc_buffer;
    uint64_t build_primref_buffer;
    uint64_t build_globals;
    uint64_t bvh_buffer;
    uint32_t leaf_type;
    uint32_t leaf_size;
};
struct grl_build_primref_MKSizeEstimate {
    uint32_t numTriangles;
    uint32_t numProcedurals;
    uint32_t numPrimitives;
    uint32_t numMeshes;
    uint32_t numBuildPrimitives;
    uint32_t numPrimitivesToSplit;
    uint32_t instance_descs_start;
    uint32_t geo_meta_data_start;
    uint32_t node_data_start;
    uint32_t leaf_data_start;
    uint32_t procedural_data_start;
    uint32_t back_pointer_start;
    uint32_t sizeTotal;
    uint32_t updateScratchSizeTotal;
    uint32_t fatleaf_table_start;
    uint32_t innernode_table_start;
    uint32_t max_fatleaves;
    uint32_t quad_indices_data_start;
};
void
genX(grl_build_primref_buildPrimirefsFromInstances)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescBuff,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate);
void
genX(grl_build_primref_buildPrimirefsFromInstancesIndirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescBuff,
    uint64_t indirectBuildRangeInfo,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate);
void
genX(grl_build_primref_buildPrimirefsFromInstancesArrOfPtrs)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescPtrArrayBuff,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate);
void
genX(grl_build_primref_buildPrimirefsFromInstancesArrOfPtrsIndirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescPtrArrayBuff,
    uint64_t indirectBuildRangeInfo,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate);
void
genX(grl_build_primref_primrefs_from_tris)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint32_t geom_id,
    uint32_t geom_flags,
    uint32_t num_prims);
void
genX(grl_build_primref_primrefs_from_tris_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint64_t indirectBuildRangeInfo,
    uint32_t geom_id,
    uint32_t geom_flags);
void
genX(grl_build_primref_primrefs_from_proc)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint32_t geom_id,
    uint32_t geom_flags,
    uint32_t num_prims);
void
genX(grl_build_primref_primrefs_from_proc_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint64_t indirectBuildRangeInfo,
    uint32_t geom_id,
    uint32_t geom_flags);

#ifdef __cplusplus
}
#endif

#endif /* GRL_METAKERNEL_BUILD_PRIMREF */