
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "anv_private.h"
#include "grl/genX_grl.h"

#ifndef GRL_METAKERNEL_NEW_SAH_BUILDER
#define GRL_METAKERNEL_NEW_SAH_BUILDER

#ifdef __cplusplus
extern "C" {
#endif

struct grl_new_sah_builder_Scheduler {
    uint32_t num_bfs_wgs;
    uint32_t num_dfs_wgs;
    uint32_t scheduler_postsync;
    uint32_t _pad1;
    uint32_t num_trivial_builds;
    uint32_t num_single_builds;
    uint32_t batched_build_wg_count;
    uint32_t batched_build_loop_mask;
};
struct grl_new_sah_builder_SAHBuildArgs {
    uint64_t p_num_primitives;
    uint64_t p_qnode_child_buffer;
    uint64_t p_scheduler;
    uint64_t p_sah_globals;
    uint64_t p_globals;
    uint64_t p_primref_buffer;
    uint64_t p_primref_index_buffers;
    uint64_t p_bvh_base;
    uint64_t p_bvh2;
    uint64_t p_root_buffer_counters;
    uint32_t sah_build_flags;
    uint32_t leaf_size;
    uint32_t leaf_type;
    uint32_t max_internal_nodes;
};
struct grl_new_sah_builder_SAHBuildArgsBatchable {
    uint64_t p_globals_ptrs;
    uint64_t p_scheduler;
    uint64_t p_buffers_info;
    uint64_t p_sah_globals;
    uint32_t num_max_qnode_global_root_buffer_entries;
    uint32_t num_builds;
};
void
genX(grl_new_sah_builder_single_pass_binsah)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t build_globals,
    uint64_t bvh_buffer,
    uint64_t build_primref_buffer,
    uint64_t build_primref_index_buffers,
    uint32_t alloc_backpointers);
void
genX(grl_new_sah_builder_new_sah_build)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_new_sah_builder_SAHBuildArgs build_args);
void
genX(grl_new_sah_builder_new_sah_build_batchable)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_new_sah_builder_SAHBuildArgsBatchable build_args);

#ifdef __cplusplus
}
#endif

#endif /* GRL_METAKERNEL_NEW_SAH_BUILDER */