
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "grl_metakernel_build_leaf.h"

#include "genxml/gen_macros.h"
#include "genxml/genX_pack.h"
#include "genxml/genX_rt_pack.h"

/* We reserve :
 *    - GPR 14 for secondary command buffer returns
 *    - GPR 15 for conditional rendering
 */
#define MI_BUILDER_NUM_ALLOC_GPRS 14
#define __gen_get_batch_dwords anv_batch_emit_dwords
#define __gen_address_offset anv_address_add
#define __gen_get_batch_address(b, a) anv_batch_address(b, a)
#include "common/mi_builder.h"

#define MI_PREDICATE_RESULT mi_reg32(0x2418)
#define DISPATCHDIM_X mi_reg32(0x2500)
#define DISPATCHDIM_Y mi_reg32(0x2504)
#define DISPATCHDIM_Z mi_reg32(0x2508)
static const uint64_t Instances_GROUPSIZE = 16;
void
genX(grl_leaf_builder_buildLeafDXR_instances)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint64_t srcInstanceDescrArray,
    uint32_t stride,
    uint32_t offset,
    uint32_t numPrims)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp0 = (numPrims + Instances_GROUPSIZE);
    uint64_t _tmp1 = (_tmp0 - 1);
    uint64_t _tmp2 = (_tmp1 / Instances_GROUPSIZE);
    {
        const uint32_t _group_size[3] = { _tmp2, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.build_primref_buffer },
            { .u64 = state.bvh_buffer },
            { .u64 = srcInstanceDescrArray },
            { .u64 = stride },
            { .u64 = offset },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_leaf_builder_buildLeafDXR_instances_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint64_t srcInstanceDescrArray,
    uint64_t indirectBuildRangeInfo,
    uint32_t stride,
    uint32_t offset)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp3 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp4 = mi_iadd(&b, _tmp3, mi_imm(15));
    struct mi_value _tmp5 = mi_ushr_imm(&b, _tmp4, 4);
    struct mi_value _tmp6 = mi_value_half(_tmp5, false);
    mi_store(&b, DISPATCHDIM_X, _tmp6);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.build_primref_buffer },
            { .u64 = state.bvh_buffer },
            { .u64 = srcInstanceDescrArray },
            { .u64 = stride },
            { .u64 = offset },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_leaf_builder_buildLeafDXR_instances_pointers)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint64_t srcInstanceDescrArrayPtr,
    uint32_t stride,
    uint32_t offset,
    uint32_t numPrims)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp7 = (numPrims + Instances_GROUPSIZE);
    uint64_t _tmp8 = (_tmp7 - 1);
    uint64_t _tmp9 = (_tmp8 / Instances_GROUPSIZE);
    {
        const uint32_t _group_size[3] = { _tmp9, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.build_primref_buffer },
            { .u64 = state.bvh_buffer },
            { .u64 = srcInstanceDescrArrayPtr },
            { .u64 = stride },
            { .u64 = offset },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_leaf_builder_buildLeafDXR_instances_pointers_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint64_t srcInstanceDescrArrayPtr,
    uint64_t indirectBuildRangeInfo,
    uint32_t stride,
    uint32_t offset)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp10 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp11 = mi_iadd(&b, _tmp10, mi_imm(15));
    struct mi_value _tmp12 = mi_ushr_imm(&b, _tmp11, 4);
    struct mi_value _tmp13 = mi_value_half(_tmp12, false);
    mi_store(&b, DISPATCHDIM_X, _tmp13);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.build_primref_buffer },
            { .u64 = state.bvh_buffer },
            { .u64 = srcInstanceDescrArrayPtr },
            { .u64 = stride },
            { .u64 = offset },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_leaf_builder_buildLeafDXR_procedurals)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint32_t stride,
    uint32_t offset,
    uint64_t p_numPrimitives)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp14 = mi_mem32(anv_address_from_u64(p_numPrimitives));
    struct mi_value _tmp15 = mi_iadd(&b, _tmp14, mi_imm(16));
    struct mi_value _tmp16 = mi_isub(&b, _tmp15, mi_imm(1));
    struct mi_value _tmp17 = mi_ushr_imm(&b, _tmp16, 4);
    mi_store(&b, DISPATCHDIM_X, _tmp17);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = state.build_primref_buffer },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.bvh_buffer },
            { .u64 = state.geomDesc_buffer },
            { .u64 = stride },
            { .u64 = offset },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_PROCEDURALS,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_leaf_builder_buildLeafDXR_quads)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_leaf_builder_MKBuilderState state,
    uint64_t build_primref_index_buffers,
    uint32_t stride,
    uint32_t offset,
    uint64_t p_numPrimitives,
    uint32_t allow_update)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp18 = mi_mem32(anv_address_from_u64(p_numPrimitives));
    struct mi_value _tmp19 = mi_iadd(&b, _tmp18, mi_imm(32));
    struct mi_value _tmp20 = mi_isub(&b, _tmp19, mi_imm(1));
    struct mi_value _tmp21 = mi_ushr_imm(&b, _tmp20, 4);
    struct mi_value _tmp22 = mi_ushr_imm(&b, _tmp21, 1);
    mi_store(&b, DISPATCHDIM_X, _tmp22);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = state.build_globals },
            { .u64 = state.build_primref_buffer },
            { .u64 = build_primref_index_buffers },
            { .u64 = state.bvh_buffer },
            { .u64 = state.geomDesc_buffer },
            { .u64 = stride },
            { .u64 = offset },
            { .u64 = allow_update },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_QUADS,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}