
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "grl_metakernel_postbuild_info.h"

#include "genxml/gen_macros.h"
#include "genxml/genX_pack.h"
#include "genxml/genX_rt_pack.h"

/* We reserve :
 *    - GPR 14 for secondary command buffer returns
 *    - GPR 15 for conditional rendering
 */
#define MI_BUILDER_NUM_ALLOC_GPRS 14
#define __gen_get_batch_dwords anv_batch_emit_dwords
#define __gen_address_offset anv_address_add
#define __gen_get_batch_address(b, a) anv_batch_address(b, a)
#include "common/mi_builder.h"

#define MI_PREDICATE_RESULT mi_reg32(0x2418)
#define DISPATCHDIM_X mi_reg32(0x2500)
#define DISPATCHDIM_Y mi_reg32(0x2504)
#define DISPATCHDIM_Z mi_reg32(0x2508)
void
genX(grl_postbuild_info_compacted_size)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh,
    uint64_t postbuildInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 1, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh },
            { .u64 = postbuildInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_POSTBUILD_INFO_COMPACTED_SIZE,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_postbuild_info_current_size)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh,
    uint64_t postbuildInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 1, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh },
            { .u64 = postbuildInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_POSTBUILD_INFO_CURRENT_SIZE,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_postbuild_info_serialized_size)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh,
    uint64_t postbuildInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 1, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh },
            { .u64 = postbuildInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_POSTBUILD_INFO_SERIALIZED_SIZE,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_postbuild_info_decoded_size)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh,
    uint64_t postbuildInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 1, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh },
            { .u64 = postbuildInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_POSTBUILD_INFO_DECODED_SIZE,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}