
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "anv_private.h"
#include "grl/genX_grl.h"

#ifndef GRL_METAKERNEL_COPY
#define GRL_METAKERNEL_COPY

#ifdef __cplusplus
extern "C" {
#endif

void
genX(grl_copy_clone_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t srcBVHsizedwordAddr);
void
genX(grl_copy_compact)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src);
void
genX(grl_copy_serialize_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t driverID,
    uint64_t srcBVHsizedwordAddr);
void
genX(grl_copy_serialize_for_input_dump_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t batchPtrs,
    uint64_t dstOffset,
    uint64_t src,
    uint64_t driverID,
    uint64_t srcBVHsizedwordAddr);
void
genX(grl_copy_deserialize_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t srcBVHsizedwordAddr);
void
genX(grl_copy_dxr_decode)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src);

#ifdef __cplusplus
}
#endif

#endif /* GRL_METAKERNEL_COPY */