
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "grl_metakernel_build_primref.h"

#include "genxml/gen_macros.h"
#include "genxml/genX_pack.h"
#include "genxml/genX_rt_pack.h"

/* We reserve :
 *    - GPR 14 for secondary command buffer returns
 *    - GPR 15 for conditional rendering
 */
#define MI_BUILDER_NUM_ALLOC_GPRS 14
#define __gen_get_batch_dwords anv_batch_emit_dwords
#define __gen_address_offset anv_address_add
#define __gen_get_batch_address(b, a) anv_batch_address(b, a)
#include "common/mi_builder.h"

#define MI_PREDICATE_RESULT mi_reg32(0x2418)
#define DISPATCHDIM_X mi_reg32(0x2500)
#define DISPATCHDIM_Y mi_reg32(0x2504)
#define DISPATCHDIM_Z mi_reg32(0x2508)
static const uint64_t PrimirefsFromInstances_GROUPSIZE = 16;
void
genX(grl_build_primref_buildPrimirefsFromInstances)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescBuff,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp0 = (estimate.numPrimitives + PrimirefsFromInstances_GROUPSIZE);
    uint64_t _tmp1 = (_tmp0 - 1);
    uint64_t _tmp2 = (_tmp1 / PrimirefsFromInstances_GROUPSIZE);
    {
        const uint32_t _group_size[3] = { _tmp2, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = instanceDescBuff },
            { .u64 = estimate.numPrimitives },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = allowUpdate },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_buildPrimirefsFromInstancesIndirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescBuff,
    uint64_t indirectBuildRangeInfo,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp3 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp4 = mi_iadd(&b, _tmp3, mi_imm(15));
    struct mi_value _tmp5 = mi_ushr_imm(&b, _tmp4, 4);
    struct mi_value _tmp6 = mi_value_half(_tmp5, false);
    mi_store(&b, DISPATCHDIM_X, _tmp6);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = instanceDescBuff },
            { .u64 = indirectBuildRangeInfo },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = allowUpdate },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_buildPrimirefsFromInstancesArrOfPtrs)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescPtrArrayBuff,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp7 = (estimate.numPrimitives + PrimirefsFromInstances_GROUPSIZE);
    uint64_t _tmp8 = (_tmp7 - 1);
    uint64_t _tmp9 = (_tmp8 / PrimirefsFromInstances_GROUPSIZE);
    {
        const uint32_t _group_size[3] = { _tmp9, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = instanceDescPtrArrayBuff },
            { .u64 = estimate.numPrimitives },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = allowUpdate },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_buildPrimirefsFromInstancesArrOfPtrsIndirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t instanceDescPtrArrayBuff,
    uint64_t indirectBuildRangeInfo,
    struct grl_build_primref_MKSizeEstimate estimate,
    struct grl_build_primref_MKBuilderState build_state,
    uint32_t allowUpdate)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp10 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp11 = mi_iadd(&b, _tmp10, mi_imm(15));
    struct mi_value _tmp12 = mi_ushr_imm(&b, _tmp11, 4);
    struct mi_value _tmp13 = mi_value_half(_tmp12, false);
    mi_store(&b, DISPATCHDIM_X, _tmp13);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = instanceDescPtrArrayBuff },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = indirectBuildRangeInfo },
            { .u64 = allowUpdate },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_primrefs_from_tris)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint32_t geom_id,
    uint32_t geom_flags,
    uint32_t num_prims)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp14 = (num_prims + 15);
    uint64_t _tmp15 = (_tmp14 / 16);
    uint64_t _tmp16 = (geom_id & 0xffffffu);
    uint64_t _tmp17 = (geom_flags << 24);
    uint64_t _tmp18 = (_tmp16 + _tmp17);
    {
        const uint32_t _group_size[3] = { _tmp15, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = geo_ptr },
            { .u64 = _tmp18 },
            { .u64 = num_prims },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_primrefs_from_tris_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint64_t indirectBuildRangeInfo,
    uint32_t geom_id,
    uint32_t geom_flags)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp19 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp20 = mi_iadd(&b, _tmp19, mi_imm(15));
    struct mi_value _tmp21 = mi_ushr_imm(&b, _tmp20, 4);
    struct mi_value _tmp22 = mi_value_half(_tmp21, false);
    mi_store(&b, DISPATCHDIM_X, _tmp22);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    uint64_t _tmp23 = (geom_id & 0xffffffu);
    uint64_t _tmp24 = (geom_flags << 24);
    uint64_t _tmp25 = (_tmp23 + _tmp24);
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = geo_ptr },
            { .u64 = indirectBuildRangeInfo },
            { .u64 = _tmp25 },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_primrefs_from_proc)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint32_t geom_id,
    uint32_t geom_flags,
    uint32_t num_prims)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp26 = (num_prims + 15);
    uint64_t _tmp27 = (_tmp26 / 16);
    uint64_t _tmp28 = (geom_id & 0xffffffu);
    uint64_t _tmp29 = (geom_flags << 24);
    uint64_t _tmp30 = (_tmp28 + _tmp29);
    {
        const uint32_t _group_size[3] = { _tmp27, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = geo_ptr },
            { .u64 = _tmp30 },
            { .u64 = num_prims },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_build_primref_primrefs_from_proc_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    struct grl_build_primref_MKBuilderState build_state,
    struct grl_build_primref_MKSizeEstimate estimate,
    uint64_t geo_ptr,
    uint64_t indirectBuildRangeInfo,
    uint32_t geom_id,
    uint32_t geom_flags)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp31 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp32 = mi_iadd(&b, _tmp31, mi_imm(15));
    struct mi_value _tmp33 = mi_ushr_imm(&b, _tmp32, 4);
    struct mi_value _tmp34 = mi_value_half(_tmp33, false);
    mi_store(&b, DISPATCHDIM_X, _tmp34);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    uint64_t _tmp35 = (geom_id & 0xffffffu);
    uint64_t _tmp36 = (geom_flags << 24);
    uint64_t _tmp37 = (_tmp35 + _tmp36);
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = build_state.build_globals },
            { .u64 = build_state.bvh_buffer },
            { .u64 = build_state.build_primref_buffer },
            { .u64 = geo_ptr },
            { .u64 = indirectBuildRangeInfo },
            { .u64 = _tmp37 },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}